# -*- coding: utf-8 -*-
""" Unicode character maps

Thanks to: http://developer.mimer.com/charts/index.tml

"""
unicode_character_map = {
    "en": [
        ("a", "A"),
        ("b", "B"),
        ("c", "C"),
        ("d", "D"),
        ("e", "E"),
        ("f", "F"),
        ("g", "G"),
        ("h", "H"),
        ("i", "I"),
        ("j", "J"),
        ("k", "K"),
        ("l", "L"),
        ("m", "M"),
        ("n", "N"),
        ("o", "O"),
        ("p", "P"),
        ("q", "Q"),
        ("r", "R"),
        ("s", "S"),
        ("t", "T"),
        ("u", "U"),
        ("v", "V"),
        ("w", "W"),
        ("x", "X"),
        ("y", "Y"),
        ("z", "Z"),
    ],
    "en-US": [
        ("a", "A"),
        ("b", "B"),
        ("c", "C"),
        ("d", "D"),
        ("e", "E"),
        ("f", "F"),
        ("g", "G"),
        ("h", "H"),
        ("i", "I"),
        ("j", "J"),
        ("k", "K"),
        ("l", "L"),
        ("m", "M"),
        ("n", "N"),
        ("o", "O"),
        ("p", "P"),
        ("q", "Q"),
        ("r", "R"),
        ("s", "S"),
        ("t", "T"),
        ("u", "U"),
        ("v", "V"),
        ("w", "W"),
        ("x", "X"),
        ("y", "Y"),
        ("z", "Z"),
    ],
    "el": [
        ("\u03B1", "\u0391", "\u03AC", "\u0386"),
        ("\u03B2", "\u0392"),
        ("\u03B3", "\u0393"),
        ("\u03B4", "\u0394"),
        ("\u03B5", "\u0395", "\u03AD", "\u0388"),
        ("\u03B6", "\u0396"),
        ("\u03B7", "\u0397", "\u03AE", "\u0389"),
        ("\u03B8", "\u0398"),
        ("\u03B9", "\u0399", "\u03AF", "\u038A", "\u03CA", "\u03AA", "\u0390"),
        ("\u03BA", "\u039A"),
        ("\u03BB", "\u039B"),
        ("\u03BC", "\u039C", "\u00B5"),
        ("\u03BD", "\u039D"),
        ("\u03BE", "\u039E"),
        ("\u03BF", "\u039F", "\u03CC", "\u038C"),
        ("\u03C0", "\u03A0"),
        ("\u03C1", "\u03A1"),
        ("\u03C3", "\u03A3", "\u03C2"),
        ("\u03C4", "\u03A4"),
        ("\u03C5", "\u03A5", "\u03CD", "\u038E", "\u03CB", "\u03AB", "\u03B0"),
        ("\u03C6", "\u03A6"),
        ("\u03C7", "\u03A7"),
        ("\u03C8", "\u03A8"),
        ("\u03C9", "\u03A9", "\u2126", "\u03CE", "\u038F"),
    ],
    "bg": [
        ("\u0430", "\u0410"),
        ("\u0431", "\u0411"),
        ("\u0432", "\u0412"),
        ("\u0433", "\u0413", "\u0491", "\u0490"),
        ("\u0434", "\u0414"),
        ("\u0435", "\u0415", "\u0450", "\u0400", "\u0451", "\u0401"),
        ("\u0436", "\u0416", "\u04C2", "\u04C1"),
        ("\u0437", "\u0417"),
        ("\u0438", "\u0418", "\u045D", "\u040D", "\u04E3", "\u04E2"),
        ("\u0439", "\u0419"),
        ("\u043A", "\u041A"),
        ("\u043B", "\u041B"),
        ("\u043C", "\u041C"),
        ("\u043D", "\u041D"),
        ("\u043E", "\u041E"),
        ("\u043F", "\u041F"),
        ("\u0440", "\u0420"),
        ("\u0441", "\u0421"),
        ("\u0442", "\u0422"),
        ("\u0443", "\u0423", "\u04EF", "\u04EE"),
        ("\u0444", "\u0424"),
        ("\u0445", "\u0425"),
        ("\u0446", "\u0426"),
        ("\u0447", "\u0427"),
        ("\u0448", "\u0428"),
        ("\u0449", "\u0429"),
        ("\u044A", "\u042A"),
        ("\u044C", "\u042C"),
        ("\u044E", "\u042E"),
        ("\u044F", "\u042F"),
    ],
    "da": [
        ("a", "A"),
        ("b", "B"),
        ("c", "C"),
        ("d", "D"),
        ("e", "E"),
        ("f", "F"),
        ("g", "G"),
        ("h", "H"),
        ("i", "I"),
        ("j", "J"),
        ("k", "K"),
        ("l", "L"),
        ("m", "M"),
        ("n", "N"),
        ("o", "O"),
        ("p", "P"),
        ("q", "Q"),
        ("r", "R"),
        ("s", "S"),
        ("t", "T"),
        ("u", "U"),
        ("v", "V"),
        ("w", "W"),
        ("x", "X"),
        ("y", "Y"),
        ("z", "Z"),
        ("\u00E6", "\u00C6"),
        ("\u00F8", "\u00D8"),
        ("\u00E5", "\u00C5"),
    ],
    "et": [
        ("a", "\u0041"),
        ("b", "B"),
        ("c", "\u0043"),
        ("d", "\u0044"),
        ("e", "\u0045"),
        ("\u0066", "\u0046"),
        ("\u0067", "\u0047"),
        ("\u0068", "\u0048"),
        ("\u0069", "\u0049"),
        ("\u006A", "\u004A"),
        ("\u006B", "\u004B"),
        ("\u006C", "\u004C"),
        ("\u006D", "\u004D"),
        ("\u006E", "\u004E"),
        ("\u006F", "\u004F"),
        ("\u0070", "\u0050"),
        ("\u0071", "\u0051"),
        ("\u0072", "\u0052"),
        ("\u0073", "\u0053"),
        ("\u0161", "\u0160"),
        ("\u007A", "\u005A"),
        ("\u017E", "\u017D"),
        ("\u0074", "\u0054"),
        ("\u0075", "\u0055"),
        ("\u0076", "\u0056"),
        ("\u0077", "\u0057"),
        ("\u00F5", "\u00D5"),
        ("\u00E4", "\u00C4"),
        ("\u00F6", "\u00D6"),
        ("\u00FC", "\u00DC"),
        ("\u0078", "\u0058"),
        ("\u0079", "\u0059"),
    ],
    "fi": [
        ("a", "\u0041"),
        ("b", "B"),
        ("c", "\u0043"),
        ("d", "\u0044"),
        ("e", "\u0045"),
        ("\u0066", "\u0046"),
        ("\u0067", "\u0047"),
        ("\u0068", "\u0048"),
        ("\u0069", "\u0049"),
        ("\u006A", "\u004A"),
        ("\u006B", "\u004B"),
        ("\u006C", "\u004C"),
        ("\u006D", "\u004D"),
        ("\u006E", "\u004E"),
        ("\u006F", "\u004F"),
        ("\u0070", "\u0050"),
        ("\u0071", "\u0051"),
        ("\u0072", "\u0052"),
        ("\u0073", "\u0053"),
        ("\u0074", "\u0054"),
        ("\u0075", "\u0055"),
        ("\u0076", "\u0056"),
        ("\u0078", "\u0058"),
        ("\u0079", "\u0059"),
        ("\u007A", "\u005A"),
        ("\u00E5", "\u00C5"),
        ("\u00E4", "\u00C4"),
        ("\u00F6", "\u00D6"),
    ],
    "hu": [
        ("a", "\u0041"),
        ("\u00E1", "\u00C1"),
        ("b", "B"),
        ("c", "\u0043"),
        ("\u0063\u0073", "\u0043\u0073"),
        ("d", "\u0044"),
        ("\u0064\u007A", "\u0044\u007A", "\u0044\u005A"),
        ("\u0064\u007A\u0073", "\u0044\u007A\u0073", "\u0044\u005A\u0053"),
        ("e", "\u0045"),
        ("\u00E9", "\u00C9"),
        ("\u0066", "\u0046"),
        ("\u0067", "\u0047"),
        ("\u0067\u0079", "\u0047\u0079", "\u0047\u0059"),
        ("\u0068", "\u0048"),
        ("\u0069", "\u0049"),
        ("\u00ED", "\u00CD"),
        ("\u006A", "\u004A"),
        ("\u006B", "\u004B"),
        ("\u006C", "\u004C"),
        ("\u006C\u0079", "\u004C\u0079", "\u004C\u0059"),
        ("\u006D", "\u004D"),
        ("\u006E", "\u004E"),
        ("\u006E\u0079", "\u004E\u0079", "\u004E\u0059"),
        ("\u006F", "\u004F"),
        ("\u00F3", "\u00D3"),
        ("\u00F6", "\u00D6"),
        ("\u0151", "\u0150"),
        ("\u0070", "\u0050"),
        ("\u0071", "\u0051"),
        ("\u0072", "\u0052"),
        ("\u0073", "\u0053"),
        ("\u0073\u007A", "\u0053\u007A", "\u0053\u005A"),
        ("\u0074", "\u0054"),
        ("\u0074\u0079", "\u0054\u0079", "\u0054\u0059"),
        ("\u0075", "\u0055"),
        ("\u00FA", "\u00DA"),
        ("\u00FC", "\u00DC"),
        ("\u0171", "\u0170"),
        ("\u0076", "\u0056"),
        ("\u007A", "\u005A"),
        ("\u007A\u0073", "\u005A\u0073", "\u005A\u0053"),
    ],
    "ru": [
        ("\u0430", "\u0410"),
        ("\u0431", "\u0411"),
        ("\u0432", "\u0412"),
        ("\u0433", "\u0413"),
        ("\u0434", "\u0414"),
        ("\u0435", "\u0415"),
        ("\u0451", "\u0401"),
        ("\u0436", "\u0416"),
        ("\u0437", "\u0417"),
        ("\u0438", "\u0418"),
        ("\u0439", "\u0419"),
        ("\u043A", "\u041A"),
        ("\u043B", "\u041B"),
        ("\u043C", "\u041C"),
        ("\u043D", "\u041D"),
        ("\u043E", "\u041E"),
        ("\u043F", "\u041F"),
        ("\u0440", "\u0420"),
        ("\u0441", "\u0421"),
        ("\u0442", "\u0422"),
        ("\u0443", "\u0423"),
        ("\u0444", "\u0424"),
        ("\u0445", "\u0425"),
        ("\u0446", "\u0426"),
        ("\u0447", "\u0427"),
        ("\u0448", "\u0428"),
        ("\u0449", "\u0429"),
        ("\u044A", "\u042A"),
        ("\u044B", "\u042B"),
        ("\u044C", "\u042C"),
        ("\u044D", "\u042D"),
        ("\u044E", "\u042E"),
        ("\u044F", "\u042F"),
    ],
    "eu": [
        ("a", "\u0041"),
        ("b", "B"),
        ("c", "\u0043"),
        ("d", "\u0044"),
        ("e", "\u0045"),
        ("\u0066", "\u0046"),
        ("\u0067", "\u0047"),
        ("\u0068", "\u0048"),
        ("\u0069", "\u0049"),
        ("\u006A", "\u004A"),
        ("\u006B", "\u004B"),
        ("\u006C", "\u004C"),
        ("\u006D", "\u004D"),
        ("\u006E", "\u004E"),
        ("\u00F1", "\u00D1"),
        ("\u006F", "\u004F"),
        ("\u0070", "\u0050"),
        ("\u0071", "\u0051"),
        ("\u0072", "\u0052"),
        ("\u0073", "\u0053"),
        ("\u0074", "\u0054"),
        ("\u0075", "\u0055"),
        ("\u0076", "\u0056"),
        ("\u0077", "\u0057"),
        ("\u0078", "\u0058"),
        ("\u0079", "\u0059"),
        ("\u007A", "\u005A"),
    ],
    "cs": [
        ("a", "\u0041"),
        ("\u00E1", "\u00C1"),
        ("b", "B"),
        ("c", "\u0043"),
        ("\u010D", "\u010C"),
        ("d", "\u0044"),
        ("\u010F", "\u010E"),
        ("e", "\u0045"),
        ("\u00E9", "\u00C9"),
        ("\u011B", "\u011A"),
        ("\u0066", "\u0046"),
        ("\u0067", "\u0047"),
        ("\u0068", "\u0048"),
        ("\u0063\u0068", "\u0043\u0068", "\u0043\u0048"),
        ("\u0069", "\u0049"),
        ("\u00ED", "\u00CD"),
        ("\u006A", "\u004A"),
        ("\u006B", "\u004B"),
        ("\u006C", "\u004C"),
        ("\u006D", "\u004D"),
        ("\u006E", "\u004E"),
        ("\u0148", "\u0147"),
        ("\u006F", "\u004F"),
        ("\u00F3", "\u00D3"),
        ("\u0070", "\u0050"),
        ("\u0071", "\u0051"),
        ("\u0072", "\u0052"),
        ("\u0159", "\u0158"),
        ("\u0073", "\u0053"),
        ("\u0161", "\u0160"),
        ("\u0074", "\u0054"),
        ("\u0165", "\u0164"),
        ("\u0075", "\u0055"),
        ("\u00FA", "\u00DA"),
        ("\u016F", "\u016E"),
        ("\u0076", "\u0056"),
        ("\u0077", "\u0057"),
        ("\u0078", "\u0058"),
        ("\u0079", "\u0059"),
        ("\u00FD", "\u00DD"),
        ("\u007A", "\u005A"),
        ("\u017E", "\u017D"),
    ],
    "fr": [
        ("a", "A", "\u00E0", "\u00C0", "\u00E2", "\u00C2"),
        ("b", "B"),
        ("c", "\u0043", "\u00E7", "\u00C7"),
        ("d", "\u0044"),
        (
            "e",
            "\u0045",
            "\u00E9",
            "\u00C9",
            "\u00E8",
            "\u00C8",
            "\u00EA",
            "\u00CA",
            "\u00EB",
            "\u00CB",
        ),
        ("\u0066", "\u0046"),
        ("\u0067", "\u0047"),
        ("\u0068", "\u0048"),
        ("\u0069", "\u0049", "\u00EE", "\u00CE"),
        ("\u006A", "\u004A"),
        ("\u006B", "\u004B"),
        ("\u006C", "\u004C"),
        ("\u006D", "\u004D"),
        ("\u006E", "\u004E"),
        ("\u006F", "\u004F", "\u00F4", "\u00D4", "\u0153", "\u0152"),
        ("\u0070", "\u0050"),
        ("\u0071", "\u0051"),
        ("\u0072", "\u0052"),
        ("\u0073", "\u0053"),
        ("\u0074", "\u0054"),
        ("\u0075", "\u0055", "\u00F9", "\u00D9", "\u00FB", "\u00DB"),
        ("\u0076", "\u0056"),
        ("\u0077", "\u0057"),
        ("\u0078", "\u0058"),
        ("\u0079", "\u0059"),
        ("\u007A", "\u005A"),
    ],
    "it": [
        ("a", "A", "\u00E0", "\u00C0"),
        ("b", "B"),
        ("c", "\u0043"),
        ("d", "\u0044"),
        ("e", "\u0045", "\u00E9", "\u00C9", "\u00E8", "\u00C8"),
        ("\u0066", "\u0046"),
        ("\u0067", "\u0047"),
        ("\u0068", "\u0048"),
        ("\u0069", "\u0049", "\u00ED", "\u00CD", "\u00EC", "\u00CC"),
        ("\u006A", "\u004A"),
        ("\u006B", "\u004B"),
        ("\u006C", "\u004C"),
        ("\u006D", "\u004D"),
        ("\u006E", "\u004E"),
        ("\u006F", "\u004F", "\u00F3", "\u00D3", "\u00F2", "\u00D2"),
        ("\u0070", "\u0050"),
        ("\u0071", "\u0051"),
        ("\u0072", "\u0052"),
        ("\u0073", "\u0053"),
        ("\u0074", "\u0054"),
        ("\u0075", "\u0055", "\u00FA", "\u00DA", "\u00F9", "\u00D9"),
        ("\u0076", "\u0056"),
        ("\u0077", "\u0057"),
        ("\u0078", "\u0058"),
        ("\u0079", "\u0059"),
        ("\u007A", "\u005A"),
    ],
    "de": [
        ("a", "A", "\u00E4", "\u00C4"),
        ("b", "B"),
        ("c", "\u0043"),
        ("d", "\u0044"),
        ("e", "\u0045"),
        ("\u0066", "\u0046"),
        ("\u0067", "\u0047"),
        ("\u0068", "\u0048"),
        ("\u0069", "\u0049"),
        ("\u006A", "\u004A"),
        ("\u006B", "\u004B"),
        ("\u006C", "\u004C"),
        ("\u006D", "\u004D"),
        ("\u006E", "\u004E"),
        ("\u006F", "\u004F", "\u00F6", "\u00D6"),
        ("\u0070", "\u0050"),
        ("\u0071", "\u0051"),
        ("\u0072", "\u0052"),
        ("\u0073", "\u0053", "\u00DF"),
        ("\u0074", "\u0054"),
        ("\u0075", "\u0055", "\u00FC", "\u00DC"),
        ("\u0076", "\u0056"),
        ("\u0077", "\u0057"),
        ("\u0078", "\u0058"),
        ("\u0079", "\u0059"),
        ("\u007A", "\u005A"),
    ],
    "pt": [
        (
            "a",
            "A",
            "\u00E1",
            "\u00C1",
            "\u00E0",
            "\u00C0",
            "\u00E2",
            "\u00C2",
            "\u00E3",
            "\u00C3",
        ),
        ("b", "B"),
        ("c", "\u0043", "\u00E7", "\u00C7"),
        ("d", "\u0044"),
        ("e", "\u0045", "\u00E9", "\u00C9", "\u00EA", "\u00CA"),
        ("\u0066", "\u0046"),
        ("\u0067", "\u0047"),
        ("\u0068", "\u0048"),
        ("\u0069", "\u0049", "\u00ED", "\u00CD"),
        ("\u006A", "\u004A"),
        ("\u006B", "\u004B"),
        ("\u006C", "\u004C"),
        ("\u006D", "\u004D"),
        ("\u006E", "\u004E"),
        (
            "\u006F",
            "\u004F",
            "\u00F3",
            "\u00D3",
            "\u00F4",
            "\u00D4",
            "\u00F5",
            "\u00D5",
        ),
        ("\u0070", "\u0050"),
        ("\u0071", "\u0051"),
        ("\u0072", "\u0052"),
        ("\u0073", "\u0053"),
        ("\u0074", "\u0054"),
        ("\u0075", "\u0055", "\u00FA", "\u00DA"),
        ("\u0076", "\u0056"),
        ("\u0077", "\u0057"),
        ("\u0078", "\u0058"),
        ("\u0079", "\u0059"),
        ("\u007A", "\u005A"),
    ],
    "es": [
        ("a", "A", "\u00E1", "\u00C1"),
        ("b", "B"),
        ("c", "\u0043"),
        ("d", "\u0044"),
        ("e", "\u0045", "\u00E9", "\u00C9"),
        ("\u0066", "\u0046"),
        ("\u0067", "\u0047"),
        ("\u0068", "\u0048"),
        ("\u0069", "\u0049", "\u00ED", "\u00CD"),
        ("\u006A", "\u004A"),
        ("\u006B", "\u004B"),
        ("\u006C", "\u004C"),
        ("\u006D", "\u004D"),
        ("\u006E", "\u004E"),
        ("\u00F1", "\u00D1"),
        ("\u006F", "\u004F", "\u00F3", "\u00D3"),
        ("\u0070", "\u0050"),
        ("\u0071", "\u0051"),
        ("\u0072", "\u0052"),
        ("\u0073", "\u0053"),
        ("\u0074", "\u0054"),
        ("\u0075", "\u0055", "\u00FA", "\u00DA"),
        ("\u0076", "\u0056"),
        ("\u0077", "\u0057"),
        ("\u0078", "\u0058"),
        ("\u0079", "\u0059"),
        ("\u007A", "\u005A"),
    ],
    "nl": [
        ("a", "A", "\u00E4", "\u00C4"),
        ("b", "B"),
        ("c", "\u0043"),
        ("d", "\u0044"),
        ("e", "\u0045", "\u00EB", "\u00CB"),
        ("\u0066", "\u0046"),
        ("\u0067", "\u0047"),
        ("\u0068", "\u0048"),
        ("\u0069", "\u0049", "\u00EF", "\u00CF"),
        ("\u006A", "\u004A"),
        ("\u006B", "\u004B"),
        ("\u006C", "\u004C"),
        ("\u006D", "\u004D"),
        ("\u006E", "\u004E"),
        ("\u006F", "\u004F", "\u00F6", "\u00D6"),
        ("\u0070", "\u0050"),
        ("\u0071", "\u0051"),
        ("\u0072", "\u0052"),
        ("\u0073", "\u0053"),
        ("\u0074", "\u0054"),
        ("\u0075", "\u0055", "\u00FC", "\u00DC"),
        ("\u0076", "\u0056"),
        ("\u0077", "\u0057"),
        ("\u0078", "\u0058"),
        ("\u0079", "\u0059"),
        ("\u007A", "\u005A"),
    ],
    "no": [
        ("a", "A"),
        ("b", "B"),
        ("c", "C"),
        ("d", "D"),
        ("e", "E"),
        ("f", "F"),
        ("g", "G"),
        ("h", "H"),
        ("i", "I"),
        ("j", "J"),
        ("k", "K"),
        ("l", "L"),
        ("m", "M"),
        ("n", "N"),
        ("o", "O"),
        ("p", "P"),
        ("q", "Q"),
        ("r", "R"),
        ("s", "S"),
        ("t", "T"),
        ("u", "U"),
        ("v", "V"),
        ("w", "W"),
        ("x", "X"),
        ("y", "Y"),
        ("z", "Z"),
        ("\u00E6", "\u00C6"),
        ("\u00F8", "\u00D8"),
        ("\u00E5", "\u00C5"),
    ],
    "pl": [
        ("a", "\u0041"),
        ("\u0105", "\u0104"),
        ("b", "B"),
        ("c", "\u0043"),
        ("\u0107", "\u0106"),
        ("d", "\u0044"),
        ("e", "\u0045"),
        ("\u0119", "\u0118"),
        ("\u0066", "\u0046"),
        ("\u0067", "\u0047"),
        ("\u0068", "\u0048"),
        ("\u0069", "\u0049"),
        ("\u006A", "\u004A"),
        ("\u006B", "\u004B"),
        ("\u006C", "\u004C"),
        ("\u0142", "\u0141"),
        ("\u006D", "\u004D"),
        ("\u006E", "\u004E"),
        ("\u0144", "\u0143"),
        ("\u006F", "\u004F"),
        ("\u00F3", "\u00D3"),
        ("\u0070", "\u0050"),
        ("\u0071", "\u0051"),
        ("\u0072", "\u0052"),
        ("\u0073", "\u0053"),
        ("\u015B", "\u015A"),
        ("\u0074", "\u0054"),
        ("\u0075", "\u0055"),
        ("\u0076", "\u0056"),
        ("\u0077", "\u0057"),
        ("\u0078", "\u0058"),
        ("\u0079", "\u0059"),
        ("\u007A", "\u005A"),
        ("\u017A", "\u0179"),
        ("\u017C", "\u017B"),
    ],
    "sk": [
        ("a", "\u0041"),
        ("\u00E1", "\u00C1"),
        ("\u00E4", "\u00C4"),
        ("b", "B"),
        ("c", "\u0043"),
        ("\u010D", "\u010C"),
        ("d", "\u0044"),
        ("\u010F", "\u010E"),
        ("\u0064\u007A", "\u0044\u007A", "\u0044\u005A"),
        ("\u0064\u017E", "\u0044\u017E", "\u0044\u017D"),
        ("e", "\u0045"),
        ("\u00E9", "\u00C9"),
        ("\u0066", "\u0046"),
        ("\u0067", "\u0047"),
        ("\u0068", "\u0048"),
        ("\u0063\u0068", "\u0043\u0068", "\u0043\u0048"),
        ("\u0069", "\u0049"),
        ("\u00ED", "\u00CD"),
        ("\u006A", "\u004A"),
        ("\u006B", "\u004B"),
        ("\u006C", "\u004C"),
        ("\u013A", "\u0139"),
        ("\u013E", "\u013D"),
        ("\u006D", "\u004D"),
        ("\u006E", "\u004E"),
        ("\u0148", "\u0147"),
        ("\u006F", "\u004F"),
        ("\u00F3", "\u00D3"),
        ("\u00F4", "\u00D4"),
        ("\u0070", "\u0050"),
        ("\u0071", "\u0051"),
        ("\u0072", "\u0052"),
        ("\u0155", "\u0154"),
        ("\u0073", "\u0053"),
        ("\u0161", "\u0160"),
        ("\u0074", "\u0054"),
        ("\u0165", "\u0164"),
        ("\u0075", "\u0055"),
        ("\u00FA", "\u00DA"),
        ("\u0076", "\u0056"),
        ("\u0077", "\u0057"),
        ("\u0078", "\u0058"),
        ("\u0079", "\u0059"),
        ("\u00FD", "\u00DD"),
        ("\u007A", "\u005A"),
        ("\u017E", "\u017D"),
    ],
    "sl": [
        ("a", "\u0041"),
        ("b", "B"),
        ("c", "\u0043"),
        ("\u010D", "\u010C"),
        ("d", "\u0044"),
        ("e", "\u0045"),
        ("\u0066", "\u0046"),
        ("\u0067", "\u0047"),
        ("\u0068", "\u0048"),
        ("\u0069", "\u0049"),
        ("\u006A", "\u004A"),
        ("\u006B", "\u004B"),
        ("\u006C", "\u004C"),
        ("\u006D", "\u004D"),
        ("\u006E", "\u004E"),
        ("\u006F", "\u004F"),
        ("\u0070", "\u0050"),
        ("\u0071", "\u0051"),
        ("\u0072", "\u0052"),
        ("\u0073", "\u0053"),
        ("\u0161", "\u0160"),
        ("\u0074", "\u0054"),
        ("\u0075", "\u0055"),
        ("\u0076", "\u0056"),
        ("\u0077", "\u0057"),
        ("\u0078", "\u0058"),
        ("\u0079", "\u0059"),
        ("\u007A", "\u005A"),
        ("\u017E", "\u017D"),
    ],
    "sv": [
        ("a", "A"),
        ("b", "B"),
        ("c", "C"),
        ("d", "D"),
        ("e", "E"),
        ("f", "F"),
        ("g", "G"),
        ("h", "H"),
        ("i", "I"),
        ("j", "J"),
        ("k", "K"),
        ("l", "L"),
        ("m", "M"),
        ("n", "N"),
        ("o", "O"),
        ("p", "P"),
        ("q", "Q"),
        ("r", "R"),
        ("s", "S"),
        ("t", "T"),
        ("u", "U"),
        ("v", "V"),
        ("w", "W"),
        ("x", "X"),
        ("y", "Y"),
        ("z", "Z"),
        ("\u00E5", "\u00C5"),
        ("\u00E4", "\u00C4"),
        ("\u00F6", "\u00D6"),
    ],
    "lt": [
        ("a", "A", "ą", "Ą"),
        ("b", "B"),
        ("c", "C"),
        ("č", "Č"),
        ("d", "D"),
        ("e", "E", "ę", "Ę", "ė", "Ė"),
        ("f", "F"),
        ("g", "G"),
        ("h", "H"),
        ("i", "I", "į", "Į", "y", "Y"),
        ("j", "J"),
        ("k", "K"),
        ("l", "L"),
        ("m", "M"),
        ("n", "N"),
        ("o", "O"),
        ("p", "P"),
        ("r", "R"),
        ("s", "S"),
        ("š", "Š"),
        ("t", "T"),
        ("u", "U", "ų", "Ų", "ū", "Ū"),
        ("v", "V"),
        ("z", "Z"),
        ("ž", "Ž"),
    ],
    "lv": [
        ("a", "A", "ā", "Ā"),
        ("b", "B"),
        ("c", "C"),
        ("č", "Č"),
        ("d", "D"),
        ("e", "E", "ē", "Ē"),
        ("f", "F"),
        ("g", "G"),
        ("ģ", "Ģ"),
        ("h", "H"),
        ("i", "I", "ī", "Ī"),
        ("j", "J"),
        ("k", "K"),
        ("ķ", "Ķ"),
        ("l", "L"),
        ("ļ", "Ļ"),
        ("m", "M"),
        ("n", "N"),
        ("ņ", "Ņ"),
        ("o", "O"),
        ("p", "P"),
        ("r", "R"),
        ("s", "S"),
        ("š", "Š"),
        ("t", "T"),
        ("u", "U", "ū", "Ū"),
        ("v", "V"),
        ("z", "Z"),
        ("ž", "Ž"),
    ],
    # mt:
    # A B Ċ D E F Ġ G GĦ H Ħ I IE J K L M N O P Q R S T U V W X Ż Z
    # A B Ċ D E F Ġ G Għ H Ħ I Ie J K L M N O P Q R S T U V W X Ż Z
    # a b ċ d e f ġ g għ h ħ i ie j k l m n o p q r s t u v w x ż z
    "mt": [
        ("a", "A"),
        ("à", "À"),
        ("b", "B"),
        ("ċ", "Ċ"),
        ("d", "D"),
        ("e", "E", "è", "È"),
        ("f", "F"),
        ("ġ", "Ġ"),
        ("g", "G"),
        ("għ", "Għ", "GĦ"),
        ("h", "H"),
        ("ħ", "Ħ"),
        ("i", "I", "ì", "Ì"),
        ("j", "J"),
        ("k", "K"),
        ("l", "L"),
        ("m", "M"),
        ("n", "N"),
        ("o", "O", "ò", "Ò"),
        ("p", "P"),
        ("q", "Q"),
        ("r", "R"),
        ("s", "S"),
        ("t", "T"),
        ("u", "U", "ù", "Ù"),
        ("v", "V"),
        ("w", "W"),
        ("x", "X"),
        ("ż", "Ż"),
        ("z", "Z"),
    ],
    # ga:
    # a á b c d e é f g h i í l m n o ó p r s t u ú
    # Loan words: j k q v w x y z
    "ga": [
        ("a", "A", "á", "Á"),
        ("b", "B"),
        ("c", "C"),
        ("d", "D"),
        ("e", "E", "é", "É"),
        ("f", "F"),
        ("g", "G"),
        ("h", "H"),
        ("i", "I", "í", "Í"),
        ("j", "J"),
        # (u'k', u'K'),
        ("l", "L"),
        ("m", "M"),
        ("n", "N"),
        ("o", "O", "ó", "Ó"),
        ("p", "P"),
        ("q", "Q"),
        ("r", "R"),
        ("s", "S"),
        ("t", "T"),
        ("u", "U", "ú", "Ú"),
        ("v", "V"),
        ("w", "W"),
        ("x", "X"),
        ("y", "Y"),
        ("z", "Z"),
    ],
    # ro:
    # A a   Ă ă     Â â     B b     C c     D d     E e
    # F f   G g     H h     I i     Î î     J j     K k
    # L l   M m     N n     O o     P p     R r     S s
    # Ş ş   T t     Ţ ţ     U u     V v     X x     Z z
    "ro": [
        ("a", "A"),
        ("ă", "Ă"),
        ("â", "Â"),
        ("b", "B"),
        ("c", "C"),
        ("d", "D"),
        ("e", "E"),
        ("f", "F"),
        ("g", "G"),
        ("h", "H"),
        ("i", "I"),
        ("î", "Î"),
        ("j", "J"),
        ("k", "K"),
        ("l", "L"),
        ("m", "M"),
        ("n", "N"),
        ("o", "O"),
        ("p", "P"),
        ("q", "Q"),
        ("r", "R"),
        ("s", "S"),
        ("ş", "Ş", "ș", "Ș"),
        ("t", "T"),
        ("ţ", "Ţ", "ț", "Ț"),
        ("u", "U"),
        ("v", "V"),
        ("w", "W"),
        ("x", "X"),
        ("y", "Y"),
        ("z", "Z"),
    ],
    "ar": [
        (
            "\u0627",
            "\uFE8E",
            "\uFE8D",
            "\uFD3C",
            "\uFD3D",
            "\u0675",
            "\u0623",
            "\uFE84",
            "\uFE83",
            "\u0625",
            "\uFE88",
            "\uFE87",
            "\u0622",
            "\uFE82",
            "\uFE81",
        ),
        ("\u0628", "\uFE91", "\uFE92", "\uFE90", "\uFE8F"),
        ("\u062A", "\uFE97", "\uFE98", "\uFE96", "\uFE95"),
        ("\u062B", "\uFE9B", "\uFE9C", "\uFE9A", "\uFE99"),
        (
            "\u062C",
            "\uFE9F",
            "\uFEA0",
            "\uFE9E",
            "\uFE9D",
            "\u0686",
            "\uFB7C",
            "\uFB7D",
            "\uFB7B",
            "\uFB7A",
        ),
        ("\u062D", "\uFEA3", "\uFEA4", "\uFEA2", "\uFEA1"),
        ("\u062E", "\uFEA7", "\uFEA8", "\uFEA6", "\uFEA5"),
        ("\u062F", "\uFEAA", "\uFEA9"),
        ("\u0630", "\uFEAC", "\uFEAB"),
        ("\u0631", "\uFEAE", "\uFEAD"),
        ("\u0632", "\uFEB0", "\uFEAF"),
        ("\u0633", "\uFEB3", "\uFEB4", "\uFEB2", "\uFEB1"),
        ("\u0634", "\uFEB7", "\uFEB8", "\uFEB6", "\uFEB5"),
        ("\u0635", "\uFEBB", "\uFEBA", "\uFEBC", "\uFEB9"),
        ("\u0636", "\uFEBF", "\uFEC0", "\uFEC0", "\uFEBD"),
        ("\u0637", "\uFEC3", "\uFEC4", "\uFEC2", "\uFEC1"),
        ("\u0638", "\uFEC7", "\uFEC8", "\uFEC6", "\uFEC5"),
        ("\u0639", "\uFECB", "\uFECC", "\uFECA", "\uFEC9"),
        ("\u063A", "\uFECF", "\uFED0", "\uFECE", "\uFECD"),
        ("\u0641", "\uFED3", "\uFED4", "\uFED2", "\uFED1", "\u06A8"),
        ("\u0642", "\uFED7", "\uFED8", "\uFED6", "\uFED5"),
        ("\u0643", "\uFEDB", "\uFEDC", "\uFEDA", "\uFED9"),
        ("\u0644", "\uFEDF", "\uFEE0", "\uFEDE", "\uFEDD"),
        ("\u0645", "\uFEE3", "\uFEE4", "\uFEE2", "\uFEE1", "\u06FE"),
        ("\u0646", "\uFEE7", "\uFEE8", "\uFEE6", "\uFEE5"),
        ("\u0647", "\uFEEB", "\uFEEC", "\uFEEA", "\uFEE9"),
        ("\u0648", "\u06E5", "\uFEEE", "\uFEED", "\u0676"),
        (
            "\u0649",
            "\uFEF0",
            "\uFEEF",
            "\u064A",
            "\u06E6",
            "\uFEF3",
            "\uFEF4",
            "\uFEF2",
            "\uFEF1",
            "\u0678",
        ),
    ],
    "is": [
        ("a", "A"),
        ("á", "Á"),
        ("b", "B"),
        ("d", "D"),
        ("ð", "Ð"),
        ("e", "E"),
        ("é", "É"),
        ("f", "F"),
        ("g", "G"),
        ("h", "H"),
        ("i", "I"),
        ("í", "Í"),
        ("j", "J"),
        ("k", "K"),
        ("l", "L"),
        ("m", "M"),
        ("n", "N"),
        ("o", "O"),
        ("ó", "Ó"),
        ("p", "P"),
        ("r", "R"),
        ("s", "S"),
        ("t", "T"),
        ("u", "U"),
        ("ú", "Ú"),
        ("v", "V"),
        ("x", "X"),
        ("y", "Y"),
        ("ý", "Ý"),
        ("þ", "Þ"),
        ("æ", "Æ"),
        ("ö", "Ö"),
    ],
    "tr": [
        ("a", "A", "â", "Â"),
        ("b", "B"),
        ("c", "C"),
        ("ç", "Ç"),
        ("d", "D"),
        ("e", "E"),
        ("f", "F"),
        ("g", "G"),
        ("ğ", "Ğ"),
        ("h", "H"),
        ("ı", "I"),
        ("i", "İ", "î", "Î"),
        ("j", "J"),
        ("k", "K"),
        ("l", "L"),
        ("m", "M"),
        ("n", "N"),
        ("o", "O"),
        ("ö", "Ö"),
        ("p", "P"),
        ("r", "R"),
        ("s", "S"),
        ("ş", "Ş"),
        ("t", "T"),
        ("u", "U", "û", "Û"),
        ("ü", "Ü"),
        ("v", "V"),
        ("y", "Y"),
        ("z", "Z"),
    ],
}
