# AUTOGENERATED! DO NOT EDIT! File to edit: ../05_HoleMakerROI.ipynb.

# %% auto 0
__all__ = ['HoleMakerROI']

# %% ../05_HoleMakerROI.ipynb 3
from .holemakertechnique import *
import numpy as np
import cv2
import random

# %% ../05_HoleMakerROI.ipynb 5
class HoleMakerROI(HoleMakerTechnique):
    def __init__(self,
            ROI_class: int = -1, # The class that is going to be targeted to select as a ROI (region of interest).
            ROI_area: int = 25 # The minimum area to be selected as a ROI.
        ):
        self.holes = []
    
    def __get_holes__(self,
             mask: np.ndarray): # The mask associated with the image where the holes are going to be made.
        "Defines how to make the hole."
        # Gets the contours of the binary mask
        ROI_class = self.ROI_class if self.ROI_class != -1 else random.randint(1, np.unique(mask) - 1)
        _mask = mask[mask != ROI_class] = 0
        contours, _ = cv2.findContours(_mask, cv2.RETR_TREE, cv2.CHAIN_APPROX_SIMPLE)
        
        # Extracts the ROIs
        areas = []
        extractions = []
        for c in contours:
            if cv2.contourArea(c) >= self.ROI_area:
                areas.append(cv2.contourArea(c))
                extractions.append(cv2.boundingRect(c))
        extractions = extractions[:np.argmax(areas)]
        
        # Saves all the possible holes
        self.holes = [[slice(extraction[1], extraction[1] + extraction[3]), slice(extraction[0], extraction[0] + extraction[2])] for extraction in extractions]
    
    def get_hole(self,
             mask: np.ndarray): # The mask associated with the image where the holes are going to be made.
        "Defines how to make the hole."
        if self.holes:
            return self.holes.pop()
        else:
            self.__get_holes__(mask)
            if self.holes:
                return self.get_hole()
            else:
                raise Exception("The image hasn't got any ROIs")
