import abc
from threading import Thread
from typing import Any, Callable, Protocol

class Cancellable(Protocol):
    def cancel(self) -> None: ...

class LoopingThread(Thread, abc.ABC, Cancellable, metaclass=abc.ABCMeta):
    def __init__(self) -> None: ...
    @abc.abstractmethod
    def loop(self) -> None: ...
    def cancel(self) -> None: ...
    def run(self) -> None: ...

class CallbackLoopingThread(LoopingThread):
    def __init__(self, callback: Callable[[], Any]) -> None: ...
    def loop(self) -> None: ...

def cancelThread(thread: Cancellable) -> None: ...
