from _typeshed import Incomplete
from jstreams.noop import NoOpCls
from threading import Lock
from typing import Any, Callable, TypeVar

__all__ = ['Injector', 'AutoStart', 'AutoInit', 'injector', 'inject', 'var']

class AutoStart:
    def start(self) -> None: ...

class AutoInit:
    def init(self) -> None: ...

class ContainerDependency:
    qualifiedDependencies: Incomplete
    def __init__(self) -> None: ...

class VariableDependency:
    qualifiedVariables: Incomplete
    def __init__(self) -> None: ...
T = TypeVar('T')

class _Injector:
    instance: _Injector | None
    instanceLock: Lock
    def __init__(self) -> None: ...
    def clear(self) -> None: ...
    def get(self, className: type[T], qualifier: str | None = None) -> T: ...
    def getVar(self, className: type[T], qualifier: str) -> T: ...
    def findVar(self, className: type[T], qualifier: str) -> T | None: ...
    def findVarOr(self, className: type[T], qualifier: str, orVal: T) -> T | None: ...
    def find(self, className: type[T], qualifier: str | None = None) -> T | None: ...
    def findOr(self, className: type[T], orCall: Callable[[], T], qualifier: str | None = None) -> T: ...
    def findNoOp(self, className: type[T], qualifier: str | None = None) -> T | NoOpCls: ...
    @staticmethod
    def getInstance() -> _Injector: ...
    def provideVarIfNotNull(self, className: type, qualifier: str, value: Any) -> _Injector: ...
    def provideVar(self, className: type, qualifier: str, value: Any) -> _Injector: ...
    def provide(self, className: type, comp: Any, qualifier: str | None = None) -> _Injector: ...
    def provideDependencies(self, dependencies: dict[type, Any]) -> _Injector: ...
    def provideVariables(self, variables: list[tuple[type, str, Any]]) -> _Injector: ...

Injector: Incomplete

def injector() -> _Injector: ...
def inject(className: type[T], qualifier: str | None = None) -> T: ...
def var(className: type[T], qualifier: str) -> T: ...
