"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_ecs_1 = require("@aws-cdk/aws-ecs");
const queue_processing_service_base_1 = require("../base/queue-processing-service-base");
/**
 * Class to create a queue processing Fargate service
 */
class QueueProcessingFargateService extends queue_processing_service_base_1.QueueProcessingServiceBase {
    /**
     * Constructs a new instance of the QueueProcessingFargateService class.
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        // Create a Task Definition for the container to start
        this.taskDefinition = new aws_ecs_1.FargateTaskDefinition(this, 'QueueProcessingTaskDef', {
            memoryLimitMiB: props.memoryLimitMiB || 512,
            cpu: props.cpu || 256,
            family: props.family,
        });
        this.taskDefinition.addContainer('QueueProcessingContainer', {
            image: props.image,
            command: props.command,
            environment: this.environment,
            secrets: this.secrets,
            logging: this.logDriver,
        });
        // Create a Fargate service with the previously defined Task Definition and configure
        // autoscaling based on cpu utilization and number of messages visible in the SQS queue.
        this.service = new aws_ecs_1.FargateService(this, 'QueueProcessingFargateService', {
            cluster: this.cluster,
            desiredCount: this.desiredCount,
            taskDefinition: this.taskDefinition,
            serviceName: props.serviceName,
            propagateTags: props.propagateTags,
            enableECSManagedTags: props.enableECSManagedTags,
        });
        this.configureAutoscalingForService(this.service);
        this.grantPermissionsToService(this.service);
    }
}
exports.QueueProcessingFargateService = QueueProcessingFargateService;
//# sourceMappingURL=data:application/json;base64,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