from django.urls import reverse
from django.apps import apps


class Node(object):
    pass


class CLNode(Node):
    def __init__(self, app, model, title=None, perms=['change']):
        self.app = app
        self.model = model
        self.title = title
        self.perms = perms

    def as_tuple(self):
        model = apps.get_model(self.app, self.model)
        vnp = model._meta.verbose_name_plural
        if self.title is None:
            title = \
                self.model.title() + 's' if vnp == self.model + 's' else vnp
        else:
            title = self.title
        perms = ['%s.%s_%s' % (self.app, i, self.model) for i in self.perms]
        return title, {
            'perms': perms,
            'url': reverse('admin:%s_%s_changelist' % (self.app, self.model))}
