import * as ecs from 'aws-cdk-lib/aws-ecs';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as route53 from 'aws-cdk-lib/aws-route53';
import { Duration } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export interface EcsPublicDiscoveryProps {
    /**
     * The ECS cluster to enable ECS public discovery for
     */
    readonly cluster: ecs.ICluster;
    /**
     * The Route 53 hosted zone to create DNS entries in
     */
    readonly hostedZone: route53.IHostedZone;
    /**
     * Enable AWS X-Ray Tracing for Lambda Functions
     *
     * @default Tracing.Disabled
     */
    readonly tracing?: lambda.Tracing;
}
export interface ServiceOptions {
    /**
     * The ECS service to create DNS entries for
     */
    readonly service: ecs.BaseService;
    /**
     * A name for the Service.
     */
    readonly name: string;
    /**
     * The amount of time that you want DNS resolvers to cache the settings for this record.
     *
     * @default Duration.minutes(1)
     */
    readonly dnsTtl?: Duration;
}
export declare class EcsPublicDiscovery extends Construct {
    private readonly cluster;
    constructor(scope: Construct, id: string, props: EcsPublicDiscoveryProps);
    addService(options: ServiceOptions): void;
}
