# AUTOGENERATED! DO NOT EDIT! File to edit: ../00_reader.ipynb.

# %% auto 0
__all__ = ['Read_data']

# %% ../00_reader.ipynb 4
import pandas as pd

# %% ../00_reader.ipynb 5
class Read_data:
    "Reads data from csv `path` and parses it in the correct format for analysis"
    def __init__(self, 
                 path:str): # `path` of the csv file
        self.path = path
        self.error = None
        self.data = self.get_data()
        
        
    def get_data(self):
        try:
            df = pd.read_csv(self.path)
        except:
            self.error = 'error'
        else:   
            df.rename(columns={'created_at':'date'}, inplace=True)
            df['date'] = pd.to_datetime(df['date']).dt.tz_convert(None)
            df['description'] = df['description'].str.replace("\r\n"," ")
            df = df[['date','address','description','abuser','abuse_type_id','abuse_type_other']].sort_values(by='date')
            return df
