# Tsdat Tools

This repository contains helpful scripts and notes for several tsdat-related tools.

Some tools are available as jupyter notebooks, and others are available as a command-line utility.

To get access to the command-line utilities, just run:

```shell
pip install tsdat-tools
```

To use all the other tools, we recommend cloning this repository.

## Data to Yaml

The goal of this tool is to reduce the tediousness of writing tsdat configuration files for data that you can already
read and convert into an `xr.Dataset` object in tsdat. It generates two output files: `dataset.yaml` and
`retriever.yaml`, which are used by `tsdat` to define metadata and how the input variables should be mapped to output
variables.

If your file is in one of the following formats, this tool can already do this for you. Formats supported out-of-box:

* **`netCDF`**: Files ending with `.nc` or `.cdf` will use the `tsdat.NetCDFReader` class
* **`csv`**: Files ending with `.csv` will use the `tsdat.CSVReader` class
* **`parquet`**: Files ending with `.parquet` or `.pq` or `.pqt` will use the `tsdat.ParquetReader` class
* **`zarr`**: Files/folders ending with `.zarr` will use the `tsdat.ZarrReader` class

### Usage

Then you can run the tool with:

```shell
tsdat-tools data2yaml path/to/data/file --input-config path/to/current/dataset.yaml
```

Full usage instructions can be obtained using the `--help` flag:

```shell
>>> tsdat-tools data2yaml --help

Usage: tsdat-tools data2yaml [OPTIONS] DATAPATH

╭─ Arguments ─────────────────────────────────────────────────────────────────────────────────────────────╮
│ *    datapath   PATH  Path to the input data file that should be used to generate tsdat configurations. │
│                       [default: None]                                                                   │
│                       [required]                                                                        │
╰─────────────────────────────────────────────────────────────────────────────────────────────────────────╯
╭─ Options ───────────────────────────────────────────────────────────────────────────────────────────────╮
│ --outdir                               DIRECTORY                      The path to the directory where   │
│                                                                       the 'dataset.yaml' and            │
│                                                                       'retriever.yaml' files should be  │
│                                                                       written.                          │
│                                                                       [default: .]                      │
│ --input-config                         PATH                           Path to a dataset.yaml file to be │
│                                                                       used in addition to               │
│                                                                       configurations derived from the   │
│                                                                       input data file. Configurations   │
│                                                                       defined here take priority over   │
│                                                                       auto-detected properties in the   │
│                                                                       input file.                       │
│                                                                       [default: None]                   │
│ --help                                                                Show this message and exit.       │
╰─────────────────────────────────────────────────────────────────────────────────────────────────────────╯
```

This tool is designed to be run in the following workflow:

1. Generate new ingest/pipeline from cookiecutter template (e.g., `make cookies` command)
2. Put an example data file for your pipeline in the `test/data/input` folder
3. Clean up the autogenerated `dataset.yaml` file.
    * Add metadata and remove any unused variables
    * Don't add additional variables yet; just make sure that the info in the current file is accurate
4. Commit your changes in `git` or back up your changes so you can compare before & after the script runs.
5. Run this script, passing it the path to your input data file and using the `--input-config` option to tell it where
your cleaned `dataset.yaml` file is. By default this will generate a new `dataset.yaml` file in the current working
directory (location of `pwd` on the command line), but you can also use the `--outdir` option to specify the path where
it should write to.
6. Review the changes the script made to each file. Note that it is not capable of standardizing units or other
metadata, so you will still need to clean those up manually.
7. Continue with the rest of the ingest/pipeline development steps

## Excel to Yaml

Please consult the documentation in the [excel2yaml/README.md](./excel2yaml/README.md) file for more information about
this tool.

## NetCDF to CSV

Please consult the documentation in the [netcdf2csv/README.md](./netcdf2csv/README.md) file for more information about
this tool.
