# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nornir_table_inventory', 'nornir_table_inventory.plugins.inventory']

package_data = \
{'': ['*']}

install_requires = \
['nornir>=3.0.0,<4.0.0', 'pandas>=1.2.0,<2.0.0']

entry_points = \
{'nornir.plugins.inventory': ['CSVInventory = '
                              'nornir_table_inventory.plugins.inventory.table:CSVInventory',
                              'ExcelInventory = '
                              'nornir_table_inventory.plugins.inventory.table:ExcelInventory',
                              'FlatDataInventory = '
                              'nornir_table_inventory.plugins.inventory.table:FlatDataInventory']}

setup_kwargs = {
    'name': 'nornir-table-inventory',
    'version': '0.4.5',
    'description': 'nornir inventory plugin,support managing inventory by csv or excel file',
    'long_description': '[![Python 3.6](https://img.shields.io/badge/python-3.6-blue.svg)](https://www.python.org/downloads/release/python-360/)\n[![Python 3.7](https://img.shields.io/badge/python-3.7-blue.svg)](https://www.python.org/downloads/release/python-370/)\n[![Python 3.8](https://img.shields.io/badge/python-3.8-blue.svg)](https://www.python.org/downloads/release/python-380/)\n\n\n# nornir_table_inventory\n\nThe nornir_table_inventory is [Nornir](https://github.com/nornir-automation/nornir) plugin for inventory.It can manage inventory by table file(CSV or Excel).\nExcitedly, it provides a hidden method to use your database or your automation system as a inventory source.\nNetmiko connections support only.\n\nIt doesn\'t support groups or defaults,because it focuses on flat data,and the data lies in table file of two-dimensional.\n\n\n\nnornir_table_inventory supports 3  inventory classes .\n- `CSVInventory` manages inventory by csv file\n- `ExcelInventory` manages inventory by excel(xlsx) file\n- `FlatDataInventory` manages inventory by python list object of dict,by this inventory plugin ,you can combine nornir with your database and automation system.\n\n## Installing\n\n\n```bash\npip install nornir-table-inventory\n```\n\n## Example usage\n\n### Using the Nornir configuration file\n\n```yaml\n---\ninventory:\n      plugin: CSVInventory\n      options:\n          csv_file: "inventory.csv"\n\nrunner:\n    plugin: threaded\n    options:\n        num_workers: 100\n```\n```python\nfrom nornir import InitNornir\n\n\nnr = InitNornir(config_file=r\'config.yml\')\n\nfor n, h in nr.inventory.hosts.items():\n  print(\'host name:\', n)\n  print(\'host hostname:\', h.hostname)\n  print(\'host username:\', h.username)\n  print(\'host password:\', h.password)\n  print(\'host platform:\', h.platform)\n  print(\'host port:\', h.port)\n  print(\'host data:\', h.data)\n  print(\'host netmiko details:\', h.connection_options.get(\'netmiko\').dict())\n  print(\'=\'*150)\n```\n\n\n### Using the InitNornir function by dict data\n\n```python\nfrom nornir import InitNornir\n\nrunner = {\n    "plugin": "threaded",\n    "options": {\n        "num_workers": 100,\n    },\n}\ninventory = {\n    "plugin": "ExcelInventory",\n    "options": {\n        "excel_file": "inventory.xlsx",\n    },\n}\n\nnr = InitNornir(runner=runner, inventory=inventory)\n\nfor n, h in nr.inventory.hosts.items():\n  print(\'host name:\', n)\n  print(\'host hostname:\', h.hostname)\n  print(\'host username:\', h.username)\n  print(\'host password:\', h.password)\n  print(\'host platform:\', h.platform)\n  print(\'host port:\', h.port)\n  print(\'host data:\', h.data)\n  print(\'host netmiko details:\', h.connection_options.get(\'netmiko\').dict())\n  print(\'=\'*150)\n\n```\n\n\n\n### CSVInventory arguments\n\n```\nArguments:\n    csv_file: csv file path，optional，default:inventory.csv\n```\n\n### ExcelInventory arguments\n\n```\nArguments:\n    excel_file: excel file path，optional，default:inventory.xlsx（Microsoft Office EXCEL 2007/2010/2013/2016/2019）\n```\n\n# Table Instructions\n\n|name|hostname|platform|port|username|password|city|model|netmiko_timeout|netmiko_secret|\n| ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- |\n|netdevops01|192.168.137.201|cisco_ios|22|netdevops|admin123!|bj|catalyst3750|60|admin1234!|\n|netdevops02|192.168.137.202|cisco_ios|22|netdevops|admin123!|shanghai|catalyst3750|60|admin1234!|\n\n- name：name of host\n\n- hostname： IP or fqdn of host\n\n- platform：netmiko\'s device_type\n\n- port：port of host,netmiko\'s port\n\n- username，password： username adn password of host\n\n- `netmiko_`prefix variables，will load into ConnectHandler（Netmiko）function to build netmiko ssh connection object.\n\n- `timeout conn_timeout auth_timeout banner_timeout blocking_timeout session_timeout` will be converted into int.If you define it in table\'s headers，you must assignment it，otherwise it will raise exception ，because it will call `int(None)`.\n\n- netmiko\'s `fast_cli` will be converted into boolean.values of  `false 0 None`(Case insensitive)will be converted into False，others will be converted into True。\n\n- others data such as city or model (any field name you can define) in the table will be host\'s data.\n\n\n  Above table will be used as following codes and result\n\n  ```python\n  from nornir import InitNornir\n  \n  nr = InitNornir(config_file=r\'config.yml\')\n  for n, h in nr.inventory.hosts.items():\n    print(\'host name:\', n)\n    print(\'host hostname:\', h.hostname)\n    print(\'host username:\', h.username)\n    print(\'host password:\', h.password)\n    print(\'host platform:\', h.platform)\n    print(\'host port:\', h.port)\n    print(\'host data:\', h.data)\n    print(\'host netmiko details:\', h.connection_options.get(\'netmiko\').dict())\n    print(\'=\'*150)\n  \n  ```\n\n  Results：\n\n  ```shell\n  host name: netdevops01\n  host hostname: 192.168.137.201\n  host username: netdevops\n  host password: admin123!\n  host platform: cisco_ios\n  host port: 22\n  host data: {\'city\': \'bj\', \'model\': \'catalyst3750\'}\n  host netmiko details: {\'extras\': {\'timeout\': 60, \'secret\': \'admin1234!\'}, \'hostname\': None, \'port\': None, \'username\': None, \'password\': None, \'platform\': None}\n  ======================================================================================================================================================\n  host name: netdevops02\n  host hostname: 192.168.137.202\n  host username: netdevops\n  host password: admin123!\n  host platform: cisco_ios\n  host port: 22\n  host data: {\'city\': \'shanghai\', \'model\': \'catalyst3750\'}\n  host netmiko details: {\'extras\': {\'timeout\': 60, \'secret\': \'admin1234!\'}, \'hostname\': None, \'port\': None, \'username\': None, \'password\': None, \'platform\':\n  ```\n\n  # A Strong Hidden Method —— any data source as a inventory\n\nThe two inventory plugins are based on the FlatDataInventory plugin. \nFlatDataInventory plugin provides a way to load inventory by puthon\'s list,the list\'s member is dict.\nWe can get some data, and transform them into form as list of dict.\nBy this way we can combine nornir with any database or automation system.\nYou do not need sql or csv plugin any more.\n \n  ```python\n  from nornir import InitNornir\nfrom nornir_utils.plugins.functions import print_result\nfrom nornir_netmiko import netmiko_send_command\n\n\ndef get_nornir_by_your_func(some_args=None, num_workers=100):\n    """Use any way to get some data(such as sql or restful api), and transform them into form as follwing"""\n    data = [{\'name\': \'netdevops01\', \'hostname\': \'192.168.137.201\',\n             \'platform\': \'cisco_ios\', \'port\': 22, \'username\': \'netdevops\',\n             \'password\': \'admin123!\', \'city\': \'bj\', \'model\': \'catalyst3750\',\n             \'netmiko_timeout\': 180, \'netmiko_secret\': \'admin1234!\',\n             \'netmiko_banner_timeout\': \'30\', \'netmiko_conn_timeout\': \'20\'},\n            {\'name\': \'netdevops02\', \'hostname\': \'192.168.137.202\', \'platform\':\n                \'cisco_ios\', \'port\': 22, \'username\': \'netdevops\', \'password\': \'admin123!\',\n             \'city\': \'bj\', \'model\': \'catalyst3750\', \'netmiko_timeout\': 120,\n             \'netmiko_secret\': \'admin1234!\', \'netmiko_banner_timeout\': 30,\n             \'netmiko_conn_timeout\': 20}\n            ]\n    runner = {\n        "plugin": "threaded",\n        "options": {\n            "num_workers": num_workers,\n        },\n    }\n    inventory = {\n        "plugin": "FlatDataInventory",\n        "options": {\n            "data": data,\n        },\n    }\n    nr = InitNornir(runner=runner, inventory=inventory)\n    return nr\n\n\nif __name__ == \'__main__\':\n    \n    nr = get_nornir_by_your_func()\n    bj_devs = nr.filter(city=\'bj\')\n    r = bj_devs.run(task=netmiko_send_command, command_string=\'display version\')\n    print_result(r)\n  \n  ```',
    'author': 'feifeiflight',
    'author_email': 'feifeiflight@126.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/jiujing/nornir_table_inventory',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
