import sys
sys.path.append('../../')

import numpy as np

import os
from datetime import datetime


def plot_parallel(data, labels, colors=None, up_down=None):
    import matplotlib.pyplot as plt

    if up_down is not None:
        data *= np.array(up_down)

    data = np.array(data)
    x = list(range(len(data[0])))
    fig, axis = plt.subplots(1, len(data[0]), sharey=False)

    print(data.shape)

    for di, d in enumerate(data):
        for i, a in enumerate(axis[0:-1]):
            temp = d[i:i+2].copy()
            if (np.max(data[:,i+1])-np.min(data[:,i+1]))!=0:
                temp[1]=(temp[1]-np.min(data[:,i+1]))*(np.max(data[:,i])-np.min(data[:,i]))/(np.max(data[:,i+1])-np.min(data[:,i+1]))+np.min(data[:,i])
            if colors is not None:
                a.plot(x[i:i + 2], temp, color=colors[di])
            else:
                a.plot(x[i:i + 2], temp)


    for i, a in enumerate(axis[0:-1]):
        a.set_xlim([x[i], x[i+1]])
        a.set_xticks([x[i], x[i+1]])
        a.set_xticklabels([labels[i], labels[i+1]], minor=False, rotation=45)
        a.set_ylim([np.min(data[:, i]), np.max(data[:, i])])

    axis[-1].set_ylim([np.min(data[:, -1]), np.max(data[:, -1])])
    axis[-1].set_xticks([])

    plt.subplots_adjust(wspace=0)

    plt.show()


#visualize_performance('Oscillation_evo_4788.txt')
#visualize_performance('Oscillation_evo_3192.txt')#MNIST_test_last_split_3510.txt

def two_gene_comparison(data, labels, colors=None):
    import matplotlib.pyplot as plt

    width=0.5

    x=np.array(list(range(len(labels)))).astype(np.float64)
    x += 0.3
    plt.bar(x, np.array(data[0])/np.array(data[0])*100-100, width, tick_label=labels, color=colors)

    x += 0.3
    plt.bar(x, np.array(data[1])/np.array(data[0])*100-100, width, tick_label=labels, color=colors)

    #plt.xlabel('parameters')
    plt.ylabel('change from original %')

    plt.show()

def plot_parallel_bar(data, labels):
    import matplotlib.pyplot as plt

    #print(np.array(data).shape)

    x=np.array(list(range(len(labels)))).astype(np.float64)
    block_count = 5
    w=1/(block_count+2)
    l=labels
    len_data=len(data)
    block_size=len_data/block_count

    first_block = np.mean(data[:int(block_size)], axis=0)

    for i in range(block_count-1):
        block_ct = i+1
        block = np.mean(data[int(block_size*block_ct):int(block_size*(block_ct+1))], axis=0)
        block = block/first_block-1
        x += w
        plt.bar(x, block, w, tick_label=l)  # , yerr=e, color=c

    #print(x.shape)
    #print(avg.shape)

    #first = np.mean(data[:10], axis=0)
    #last = np.mean(data[-10:], axis=0)
    #avg = np.mean(data, axis=0)

    #avg = avg / first -1
    #last = last / first -1
    #first = first/first -1

    #plt.bar(x, first, w, tick_label=l)#, yerr=e, color=c



    #x += 0.2
    #plt.bar(x, avg, w, tick_label=l)#, yerr=e, color=c

    plt.show()

def visualize_evolution_run(file,labels, up_down=None):

    f = open('../../Data/Evo/' + file, "r")
    data=[]
    for line in f.readlines():
        if 'survivers:' in line:
            population = string_to_array(line[line.index('['):-1])
            data.extend(population)
            #data.append(np.average(population, axis=0))

    f.close()

    ld = len(data)
    nr=4
    for i in range(nr):
        data.append(np.average(data[int(ld/nr)*i:int(ld/nr)*(i+1)],axis=0))


    #data.extend([np.average(data[0:int(ld/2)],axis=0),np.average(data[int(ld/2):-1],axis=0)])


    ld = len(data)
    colors = [(1-1/ld*i, 1/ld*i, 0, 0.1) for i in range(ld)]#green= newer red=older
    for i in range(nr):
        colors[-(i+1)] = (1/nr*i, 1-1/nr*i, 1, 1)

    plot_parallel_bar(data, labels)


    #colors[-3] = (0, 0, 0, 1)#last data point
    #colors[-2] = (0, 1, 1, 1)#first half
    #colors[-1] = (1, 0, 1, 1)#second half
    plot_parallel(data, labels, colors=colors, up_down=up_down)


def string_to_array(s):
    result = []
    s = s.replace(']', '')
    parts = s.split('[')
    for p in parts:
        if p != '':
            result.append([float(num) for num in p.split(', ') if num != ''])

    return result

def visualize_performance(file, visualize=True):
    if visualize:
        import matplotlib.pyplot as plt

    f = open('../../Data/Evo/' + file, "r")
    i=0
    avg_perf=[]
    for line in f.readlines():
        if 'fitnesses:' in line:
            l = line[line.index('['):-1].replace('[','').replace(']','')
            performances=[float(num) for num in l.split(',')]
            if visualize:
                plt.scatter([i for _ in range(len(performances))], performances)
            avg=np.average(np.array(performances))
            avg_perf.append(avg)
            print(i, avg)
            i += 1
    if visualize:
        plt.plot(avg_perf)
        plt.show()

    f.close()

def compare(param_original, param_new, names):
    import matplotlib.pyplot as plt
    x=[0]
    h=[0]
    w=[0]
    l=['']
    for o, n,name in zip(param_original,param_new, names):
        x.append(x[-1]+1)
        l.append('')
        w.append(0.5)
        h.append(n/o-1)
        plt.text(x[-1], 0, name, fontsize=12, horizontalalignment='center', verticalalignment='center', rotation=90)
    plt.bar(x, h, w, tick_label=l)
    plt.show()

def get_newest_evolution():

    print('Files:')
    print()

    search_dir = '../../Data/Evo/'
    os.chdir(search_dir)
    files = filter(os.path.isfile, os.listdir(search_dir))
    files = [os.path.join(search_dir, f) for f in files if '.txt' in f]  # add path to each file
    files.sort(key=lambda x: -os.path.getmtime(x))
    for f in files:
        print(os.path.basename(f), datetime.fromtimestamp(int(os.path.getmtime(f))), os.path.getsize(f))

    print()

    if len(files) > 0:
        print('selected newest', files[0])
        return os.path.basename(files[0])
    else:
        return None



if __name__ == '__main__':

    #compare(
    #    [0.89, 0.80222, 0.1383, 0.1698, 0.11045, 0.0001, 0.04, 0.2944, 0.0006, 0.3, 0.01, 0.2944, 0.1, 0.0001, 0.87038,0.82099, 1.5, 0.08, 30.0],
        #[0.6828200083021586, 0.6050826299550228, 0.27340764947165486, 0.11895670182349916, 0.09240731578767125,0.00016169410156046727, 0.03073392425413874, 0.3144793476060314, 0.0002815704596128816, 0.22574975043865556,0.013842493647697771, 0.37396533444265084, 0.11193287910054223, 9.52953796589554e-05, 1.1186328285166929,0.6188618067727688, 1.4402062021072555, 0.08858786066982591, 22.846206788079957],
        #[4.24289026824522, 0.1772551762687538, 0.10334918756466115, 0.2689743758706922, 0.041718700386009305, 0.00014380428405254888, 0.044381807703706956, 0.19567408560566968, 0.0010460542504209989, 0.11012200304339823, 0.01588825464021605, 0.22199256517434313, 0.015329201503661292, 5.4803392906312225e-05, 0.5059785852681881, 0.5495712393492611, 1.9563902980182912, 0.040728651397532685, 14.814732459232534],
        #[1.0148183622159357, 0.6984408613343585, 0.12825291841042993, 0.15099757385843465, 0.1259325323380118,0.0006717958601140686, 0.025484186093683716, 0.480954500267735, 0.0008017091457567466, 0.0021117766910587585,0.007525397103081159, 0.27618238644397386, 0.06492559876992648, 0.00010667927977102129, 2.1973520931324693,0.7981004713623345, 0.20442194524635993, 2.2007232776963606, 0.07218633790848408],
    #    ['distribution', 'distribution', 'strength', 'strength', 'strength', 'eta_stdp', 'h_ip', 'h_ip', 'eta_ip', 'eta_nox', 'h_sc', 'h_sc', 'eta_sc', 'eta_istdp', 'distribution', 'distribution', 'strength', 'strength', 'integration_length']
    #)

    #plot_parallel([
    #    [0.9859236905263934, 0.5344602712696023, 0.09050971484596297, 0.1171020162702352, 0.0690763277009382,
    #     0.00016361591403898446, 0.0534296421315614, 0.3202616530989009, 0.0012053980694357019, 0.2721925611831352,
    #     0.012365381087302684, 0.4243650411342812, 0.08636813251560188, 8.382143262626783e-05, 0.6454046832568021,
    #     1.1665134076346286, 1.6508949707018836, 0.054443970205713496, 23.776663719923743],
    #    [0.89, 0.80222, 0.1383, 0.1698, 0.11045, 0.0001, 0.04, 0.2944, 0.0006, 0.3, 0.01, 0.2944, 0.1, 0.0001, 0.87038,
    #     0.82099, 1.5, 0.08, 30.0]
    #],labels=['distribution', 'distribution', 'strength', 'strength', 'strength', 'eta_stdp', 'h_ip', 'h_ip', 'eta_ip',
    # 'eta_nox', 'h_sc', 'h_sc', 'eta_sc', 'eta_istdp', 'distribution', 'distribution', 'strength', 'strength',
    # 'integration_length'])

    labels=['e=>e\n(GLU)\ninitial\nweight\nlognormal\nsigma',#0
       'i=>e\n(GABA)\ninitial\nweight\nlognormal\nsigma',#1
       'e=>e\n(GLU)\nfactor',#2
       'i=>e\n(GABA)\nfactor',#3
       'i=>e\n(GABA)\nfactor\n(same step)',#4
       'eta\nSTDP',#5
       'h_IP\nlognormal\nmean',#6
       'h_IP\nlognormal\nsigma',#7
       'eta\nIP',#8
       'eta\ndiffuse IP',#9
       'synaptic\nscaling\ntarget\nlognormal\nmean',#10
       'synaptic\nscaling\ntarget\nlognormal\nsigma',#11
       'eta\nsynaptic\nscaling',#12
       'eta\niSTDP',#13
       'e=>i\n(GLU)\ninitial\nweight\nlognormal\nsigma',#14
       'i=>i\n(GABA)\ninitial\nweight\nlognormal\nsigma',#15
       'i=>i\n(GABA)\nfactor',#16
       'e=>i\n(GLU)\nfactorn\n(same step)',#17
       'i=>i\n(GABA)\nfactor\n(same step)',#18
       'IP\nintegration\nlength']#19

    two_gene_comparison(
    [
        [0.95, 0.4, 0.1383, 0.1698, 0.1, 0.00015, 0.04, 0.2944, 0.0006, 0.5, 0.015, 0.2944, 0.1, 0.0001, 0.87038, 0.82099, 1.5, 1.5, 0.08, 15.0],
        [0.8696216017907924, 0.4054197902251851, 0.15908648909538786, 0.16151455753719493, 0.048518733002033534, 0.0001606965068387588, 0.04879157151210372, 0.24231706635277966, 0.00045610819523760965, 0.5253225640567556, 0.014480162857178793, 0.3081697797506037, 0.09954804863544643, 0.00010776187534473455, 0.8077440101913735, 0.7062739421354904, 2.4503147431937236, 3.040822590617692, 0.08547161769469239, 13.841327314728604]

        #[0.95, 0.4, 0.1383, 0.1698, 0.1, 0.00015, 0.04, 0.2944, 0.0006, 0.5, 0.015, 0.2944, 0.1, 0.0001, 0.87038, 0.82099, 1.5, 1.5, 0.08, 15.0],
        #[0.9017392286400007, 0.336521535781792, 0.13270199949220565, 0.14962388907357316, 0.06263567358824208, 0.0001397543247035365, 0.05482554055188729, 0.18435824905204146, 0.00042698042629804394, 0.3583295613950753, 0.01496552477298455, 0.25978647637282687, 0.09257143917052511, 0.0001021643241400783, 1.2256750667338105, 0.9819249648687961, 2.7626521922657132, 2.7626521922657132, 0.08020358998634196, 12.47920274827478]
        #[0.9150239636600058, 0.41444993786908246, 0.13078958866926443, 0.13714627712547764, 0.10630224681081862, 0.00015355740938283497, 0.0572896064024363, 0.17205724061775884, 0.00039571392172929647, 0.36313382202600764, 0.014006216457593942, 0.2853897955370888, 0.09556820236444917, 0.0001020117958079417, 1.2850520374240129, 0.9521124386241633, 2.8949553979288645, 1.4680181329908213, 0.07774755473801938, 13.999695490935174]
    ],labels, colors=['gray', 'gray', 'red', 'red', 'red', 'purple', 'aqua', 'aqua', 'blue', 'blue', 'aqua', 'aqua', 'blue', 'purple', 'gray', 'gray', 'red', 'red', 'red', 'blue'])


    default = ''#'Oscillation_evo_9228.txt'

    plot = True
    if len(sys.argv)==1:
        default = get_newest_evolution()
    elif len(sys.argv) == 2:
        plot = False
        default = sys.argv[1]

    if '.txt' not in default:
        default += '.txt'

    #visualize_evolution_run(default,labels,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1])
    #visualize_performance(default, visualize=plot)
    visualize_performance(default, visualize=True)

    #['sGLU','sGA','fGA','IsGA','IfGLU','IfGA','actDist','diffIP','EGLU','EGA','IGLU','IGA','ta', 'stdp']

#plot_parallel(
#[[0.026399600711183788, 0.10421287397951307, 0.021482024800966677, 16.10501205419176, 7.904382913730577, 1.057800783774907, 2.706611954475853, 0.00453784936351466, 2.7021801632286797], [0.033939221217053686, 0.10973934923012851, 0.025842484724953933, 9.467300292125369, 8.622352517559419, 1.2696902597487556, 2.261168118793612, 0.004414061693611318, 2.1609222844671807], [0.02658598667883493, 0.09852851787676563, 0.02442403068646604, 10.717066390893645, 7.5197124443007475, 1.1224863034611066, 2.9900598468824557, 0.004285329604199595, 2.212951472592392], [0.027490067571595504, 0.137396412639583, 0.02640346905501148, 12.740385380135315, 6.900357549023947, 1.2998919344453153, 2.7650314723275313, 0.004513981883385645, 2.500021922140509], [0.029518712086736267, 0.11640012338939008, 0.014355127410086934, 9.094461388916535, 8.035008201503635, 1.422938487014065, 2.05054644002522, 0.004147955771998798, 2.1950952737756815], [0.024147319222227317, 0.13946361560414958, 0.022784400852762222, 11.039140373628847, 7.04889143593394, 1.3041284789829708, 3.292930693570675, 0.004323825471867509, 2.1150970620390117], [0.026997380052701473, 0.09672533079151178, 0.0188295822315554, 16.486885381039084, 6.163440606296113, 1.0153664617944136, 2.93889848554337, 0.00467427466165002, 2.814504139833568], [0.02012765108697833, 0.12764828101460102, 0.02040714222172662, 19.479949414966548, 5.361892808639032, 1.2269191713101444, 2.7429505536908065, 0.005319843533389511, 2.9928552718182857], [0.030383183528167892, 0.09998636461918434, 0.020373227368310286, 9.079825095538473, 7.057705377119237, 1.009948153807398, 2.1278815797143054, 0.004680984178917832, 2.174841537724602], [0.02411334194632601, 0.12410958869941428, 0.01910223772405967, 16.737843044770795, 4.9949764649225115, 1.1617855828319377, 2.291591159681755, 0.004573676629075663, 2.5164146165977033], [0.029142409582549468, 0.12119210469536604, 0.027654153465545624, 11.484335546692295, 7.772559402228492, 1.113397452176122, 2.7615214250782376, 0.004589410992628731, 2.9206684854151597], [0.021637111543762032, 0.14339141329670985, 0.02474782475818466, 12.504861960969432, 9.35484137291592, 1.2120778866663897, 3.1777996304440106, 0.004330769474138951, 1.8381430622550463], [0.033024871919686324, 0.11530156053945967, 0.016997551555743284, 8.665831956466882, 7.260100820505031, 1.3571655114085448, 2.2201487458884226, 0.004552201224824904, 2.1959558414210614], [0.024485296770220686, 0.10687003029032241, 0.018937037894713935, 17.955982947425206, 5.658949442541166, 1.0422802679932712, 3.8255332611288084, 0.005031226713729138, 2.2612835912389015], [0.030265346130723715, 0.0998923143185152, 0.01576714013079018, 10.281174587507723, 6.5146162191856885, 1.1797427755540384, 2.3980940440413843, 0.005036285022653433, 2.4870074679872762], [0.03224778073133177, 0.11316644946140203, 0.014481190635195745, 8.73681509086475, 9.037199332588271, 1.3867866484153657, 3.536033523150019, 0.004252395369161241, 2.6971969535509634], [0.021759485616814213, 0.1024436145221656, 0.02851734029146808, 13.19044256115523, 8.927682524951853, 1.3045704861806562, 2.8739278549034815, 0.004034619476027959, 2.5697174880068157], [0.03121545800379324, 0.11855654287010021, 0.01782205953453117, 9.056187121436283, 5.469665829007414, 0.9881125173104762, 2.2468021515195313, 0.004026682460489123, 3.048780192071233], [0.02827558142627364, 0.10954515832980696, 0.02363344468202449, 9.935008736746544, 5.1753622174445875, 1.4114808980133084, 2.805535983030516, 0.0055716357462428446, 2.7526566773696843], [0.03262366227620157, 0.10733948754569361, 0.024072810953637048, 10.526292457500777, 6.323009106144176, 1.1433169253776956, 2.779732956339481, 0.005267022790767759, 1.8062976778479731], [0.03027611194749989, 0.148755286430398, 0.024501754021127135, 12.745452650733728, 8.198818617570131, 1.1045466344272972, 2.7116555206917723, 0.0038114422355277483, 2.650103245241718], [0.025551859085599322, 0.15163310381113743, 0.024533524016817864, 8.78567468668842, 7.441316176941135, 1.3544827859848125, 3.1137730824682883, 0.004773887514540574, 2.4021894462426014], [0.02612152660822145, 0.11882628942446467, 0.02169293940513842, 20.04493808393676, 4.528410417376675, 0.9732471390793811, 2.6857877595885524, 0.005006451283186123, 2.193347308051817], [0.02408338282917107, 0.11581633349708384, 0.01579424714424249, 17.501675587294073, 9.274966474714565, 1.5899379451551734, 2.437034942709909, 0.0045592874839391305, 2.4418516857359136], [0.018313141923298432, 0.16361636942586175, 0.01969183985499199, 18.34782043366343, 7.742686864096275, 1.1562274230880563, 2.6513066743239637, 0.005849571944979164, 2.655687967387472], [0.022662192403332844, 0.09418160208560579, 0.018491679277012285, 20.386384413569438, 5.775175662289763, 1.2586279491704397, 3.7121422329699234, 0.0048587930395741765, 2.48143155059474], [0.023265043104310157, 0.12875940230188182, 0.01931679003424243, 9.02167482262453, 4.876685782677277, 1.0872952778214517, 3.3022378035333455, 0.005450146437784983, 3.1065864664930567], [0.035085128625072584, 0.09007377659896271, 0.013636533845105523, 10.081366233450893, 7.864957503509887, 0.8823423513932549, 2.2716785609008516, 0.004261878640202153, 2.124613595774027], [0.02093290898614127, 0.15175156797481168, 0.023776424094376507, 12.743522331187629, 10.175227366863677, 1.334559519417372, 3.381675618416075, 0.004467834803483442, 2.98272382544379], [0.02309999086943922, 0.12082444644371947, 0.024747190924842656, 11.356656167406292, 8.012747091312077, 1.407541146858735, 3.1065817516670267, 0.004875959261010229, 2.013734503895933], [0.022687731951700985, 0.13505555687790174, 0.019816734212445404, 13.57161705505256, 5.979819626788322, 1.1249963996912666, 2.608609897847657, 0.005100673210779394, 3.1488024864271194], [0.03136024154614614, 0.11349127195516276, 0.01331900927499702, 8.492639605447094, 8.034519814777902, 1.1007009056476273, 2.4303800334862964, 0.004014078775442332, 2.294171383481117]]
#[[0.02871476068341346, 0.07369329862103527, 0.03199718782222999, 8.826732401238447, 6.736004706644136, 1.2343528025662007, 0.7597614688047336, 0.011077213740373947, 5.126728217574705], [0.028349728956042985, 0.062092853057678095, 0.031768622971660505, 10.888253261228574, 5.845568574326768, 1.932899765203572, 0.9577872460990217, 0.010260677059520957, 3.279125803159945], [0.02794284175956824, 0.07784590792647839, 0.03290606581605467, 9.153165575663074, 5.592448359989123, 1.7885592816011369, 0.8083147349858294, 0.009247985196736988, 3.166863981285702], [0.022302018386950118, 0.09007586275491217, 0.03730195124825633, 8.935277003428677, 7.253377080249644, 0.966583742917805, 1.5809231072327536, 0.01176716029191808, 6.518963345482706], [0.029969653921162506, 0.07213168944969153, 0.032510975766194425, 7.721696138782031, 4.711896272021068, 1.4359623295887052, 0.6262871836535363, 0.006724290328701352, 3.252293211368051], [0.02886690062588982, 0.07874177262702918, 0.032058836131447936, 7.433753575912954, 7.6379206924117975, 1.4951519205071089, 0.6994224137738948, 0.007972544250100869, 4.921619889050969], [0.026890963395227844, 0.06400014099471854, 0.029487817883571625, 9.809510919565149, 6.324848538550076, 1.417093289552397, 1.2438125116771082, 0.01057020357894175, 5.502285498663169], [0.023858489181534052, 0.07090819734367756, 0.028304664770403356, 9.006794833536182, 6.378466912218847, 1.3753024159642708, 1.7550915499694644, 0.010469972182551185, 5.4977457961832386], [0.027710701939279825, 0.07573829314709025, 0.02899708616158189, 10.607613216258674, 6.459433777317866, 1.2637019393379718, 0.767956188611097, 0.011387815810421743, 6.606780278757695], [0.028623039294310346, 0.08259181214896895, 0.03127745684582737, 8.842381623038085, 6.995415929981227, 1.6619759996266659, 0.8180028968658475, 0.007650285572334104, 2.9012262683059906], [0.023994093425831368, 0.07252321647770128, 0.01832720018287394, 8.42250671832511, 6.318679799734239, 1.1076298940050309, 0.6743970592021331, 0.010068799393320104, 5.972536329213329], [0.025665879319598083, 0.0834939277289522, 0.04682119156846147, 10.487731007270535, 6.889552133606896, 2.0899526181326107, 1.2760345899702765, 0.012857416876582926, 3.55661244827608], [0.02444257309359014, 0.07346796118973196, 0.024701109019008977, 8.723225258311277, 7.837769335195447, 0.8992572415350731, 1.6472000608867763, 0.0082752839871029, 3.75120404024872], [0.02784145769928323, 0.08518447850221375, 0.02315101564916876, 8.873460327697547, 5.5590563715694605, 1.0262627178295594, 1.3061495533130667, 0.009784567316517319, 4.953485982705393], [0.02525728050602806, 0.06991123543803719, 0.02721845258489475, 12.395362690553226, 5.995887008019309, 1.9693840277279606, 0.7978096517037399, 0.009637553656213297, 3.136602796273931], [0.028513640677442265, 0.06616317904056301, 0.04509126509849014, 8.318767958506038, 8.713259381860533, 1.0602476453633205, 1.5644513943225353, 0.012445610271711698, 3.5012058152828565], [0.024280867356860886, 0.07659827347833223, 0.028414063967203758, 9.018908827072273, 7.848814774139783, 1.4979079088204976, 0.8311502442037428, 0.00697237144719964, 3.248357335332645], [0.03125061563069252, 0.08311529268076265, 0.03298296033997747, 7.220628445516491, 7.733185601942187, 2.0303851562601993, 0.8038525072000998, 0.009739140053957178, 5.245708650311424], [0.023653149293573403, 0.09102292057365578, 0.029479313766697383, 10.129788946209512, 5.935184377799268, 1.7609777895445877, 0.8039718458815625, 0.009567676487215513, 3.0252448364280724], [0.031133576087408334, 0.058264246216114146, 0.0322285364306403, 10.629413063504408, 7.3143474970480105, 1.9407169631952814, 1.0139738098338307, 0.010438376599606997, 3.5389487551944536], [0.02938503157204643, 0.09070688669380465, 0.021027995533298628, 8.542575982815187, 4.897307500000814, 0.9353064157144869, 0.7527050032596312, 0.010003814328020093, 5.194373337199787], [0.023286899088475976, 0.09401978069474475, 0.03610730814544172, 10.39381500818355, 8.313523443687215, 1.7638199775877255, 0.7457174273504669, 0.01143545838428004, 6.782836305299575], [0.03005819990417846, 0.07646010796778815, 0.031699216776897916, 10.082250640209832, 6.342785865386974, 1.2033541883848378, 0.7157810457103693, 0.011402439183632453, 6.142212918092834], [0.02924543594599935, 0.07306692998753281, 0.03178309406636447, 6.792737608826258, 6.164673941700853, 1.6473537571517136, 0.8977483715389631, 0.010362837854672385, 3.117178823614617], [0.02366981042771647, 0.0666186596663999, 0.039332007985643236, 12.608558788549983, 7.194562062055053, 2.294223480337175, 0.7315204308754004, 0.012932689854264363, 3.0992288703015807], [0.024325100953326594, 0.0713477494140968, 0.02814716668327497, 7.531143970007538, 6.809603864280291, 1.176788063099855, 1.608928898212126, 0.009203859914348462, 3.191616118668991], [0.028093594579971383, 0.09273366935195952, 0.04637939111520012, 8.173546582567957, 6.799186457940071, 1.119015485100507, 0.8163335368218995, 0.007327488902441688, 3.8112999224107615], [0.02375590092416007, 0.09261980571557507, 0.016770902078201144, 8.872935065372742, 6.565698046979244, 1.9909740917857626, 0.6973357831189273, 0.01085339859111414, 5.6580969052349825], [0.027146834670984984, 0.08350025536708153, 0.031885767056511645, 7.772154826124721, 5.542789986822889, 1.126762458315955, 0.8027237638022097, 0.006203238660815065, 3.4146674676424564], [0.025441918342554586, 0.07761683902038684, 0.03244832795236198, 8.333943280488946, 7.611420743860631, 2.08380021178414, 0.7386297312756268, 0.007021161467570558, 5.996921282679402], [0.026703997098615526, 0.0905815370759381, 0.029258303853445963, 9.536705223874796, 6.682296793077931, 1.6493838895398871, 1.3249808989240304, 0.009077923969548271, 2.483806126323762], [0.027879618276967312, 0.0559180508340009, 0.03792682964023795, 8.861523330377132, 6.096649905507678, 2.2552288528718245, 0.9810057141538625, 0.009858851228844789, 3.370579842972913], [0.025841106242758115, 0.08569671126940884, 0.035813848005690936, 11.273526847158655, 7.463874117172104, 1.6195016479417164, 1.1297003824260705, 0.009299233110839984, 3.2893435474990387], [0.023264952470824392, 0.08195052463697715, 0.030900359655502915, 11.38115702115756, 7.594562843578047, 2.0879754374981525, 0.9519756065382446, 0.012265322435030358, 3.1294998352213157], [0.026149493127992085, 0.0749813088900423, 0.02837816443949419, 11.010105563819513, 7.045954002752471, 1.9140764779280361, 0.804495180077794, 0.009064260002383105, 3.2504215922779247], [0.025116012290211934, 0.06439092392070536, 0.03124518666720144, 9.825244679131734, 6.892658971081134, 1.701516597121304, 1.1046624044966376, 0.009818124105640305, 4.21793827726329], [0.02629788592636457, 0.05514079794385412, 0.024180556559899865, 10.025980937423459, 8.035781777150389, 1.8668429274881733, 1.9530396634627385, 0.007607382597676855, 4.01853282829918], [0.030236246533982783, 0.05787843415512028, 0.03427112885678362, 6.8717894737444105, 4.299312045491103, 1.7004580771753885, 0.7358516578344636, 0.0074542478510181255, 2.399457742574337], [0.024901120003611145, 0.08468276373179331, 0.02888599310599739, 11.498364585227378, 5.645198661175445, 2.0048519751343266, 0.7565223647512093, 0.011221208056386222, 4.971630287347196], [0.020494361981469523, 0.07296353354812254, 0.02001607674081181, 9.782868064223274, 10.15239506749275, 1.0880470530380153, 0.5465739615388331, 0.011780522082340162, 5.416467373585119]]
#[[0.04907189925156115, 0.06708559284765897, 0.14899529673699022, 7.879462606201745, 17.78142871965709, 7.660311671626889, 2.949666299410705, 0.016397217227996044, 28.014278815089696], [0.05506001382752021, 0.06852890141978968, 0.13242128321936952, 5.542816774086765, 11.473729924223182, 10.898730945476522, 2.7157712478592013, 0.013631811881345563, 17.89236568366634], [0.05898498236643578, 0.06383324080283956, 0.1837952044939311, 7.394629969010662, 16.94706476087831, 6.884130874326576, 3.179586369783397, 0.016324217200412595, 32.02622189304238], [0.053893957251875145, 0.073127461037686, 0.13079720253720903, 8.290156391856923, 10.094975243316508, 15.684699870644083, 2.318937389009466, 0.0138254445440186, 21.47495369769661], [0.052504867167536724, 0.0761525878437378, 0.15110124512937284, 6.883277466643484, 18.288890189834785, 14.068699180483522, 2.5988991620756767, 0.011471636523333344, 14.530545274704007], [0.05982398628005066, 0.06871943787870292, 0.14303190216272219, 6.273229868528508, 14.623936830207258, 13.668066563368091, 2.904949193292285, 0.0117748297061715, 32.92200762321469], [0.06208981498816859, 0.07070511158131948, 0.13756220461600455, 6.280374928263901, 10.689506771883604, 13.659504597298078, 2.5805544583648383, 0.012359294799815299, 16.12409064228943], [0.05234428415816301, 0.08181493614819929, 0.1467939638826444, 6.800378387974903, 17.406507718009472, 12.219744110087618, 2.3286943944781675, 0.010923302668716765, 14.142760932087306], [0.054866348348120944, 0.06310923190612501, 0.15101702076431123, 5.341269044942515, 11.267664655635755, 13.167729694792605, 2.3514183920733362, 0.016933515287251753, 27.06144259139219], [0.041942544198443746, 0.08216527119001502, 0.12618817304895227, 6.594764482493146, 15.927193505874435, 8.544802154166376, 2.4523764157976236, 0.014133530363041158, 30.043714538283528], [0.05512537198598401, 0.058305880244366164, 0.1310075571583164, 7.141376048192306, 12.377246541682617, 15.082593046093683, 2.162244035781917, 0.012683625434636928, 23.71559634205502], [0.050492167560499054, 0.08578657044382333, 0.15397839766905894, 5.508804232085167, 16.62215471324626, 8.797463099511004, 2.3146852945094403, 0.014603965982303934, 29.45390697990813], [0.04573551283703085, 0.08588798538035464, 0.12550568965644793, 7.2067464954028635, 14.00335153297824, 8.93000717680782, 2.6862548026012982, 0.014965599107690008, 29.743977366441364], [0.05862031788441267, 0.06861274544998204, 0.12466459828714892, 5.986015556168569, 8.774925148430507, 21.042827080737695, 2.9412605974246544, 0.010622814048709505, 20.74769904106661], [0.05287119299257621, 0.0704732167148532, 0.1514581388607456, 6.718305813270546, 10.946057044208851, 11.556963779955767, 3.311210903895142, 0.018601325035368113, 29.03666053688825], [0.04984935365598878, 0.06494339223403488, 0.13652504432372423, 5.288615079799364, 9.725254037080166, 15.44411552758647, 2.6942873013235733, 0.01595136420250355, 27.794746028417904], [0.053240372724981125, 0.0843130432619808, 0.16538894942915033, 5.843648041797742, 17.292592405994572, 10.17309039438174, 2.767343892364688, 0.014382924876789834, 32.01357836438473], [0.036750021497954255, 0.06945208335704377, 0.13499391720477258, 8.382455285638128, 14.9509070934635, 17.582607188689785, 2.493657609253558, 0.016406123081559185, 29.003654591392664], [0.04438515722879025, 0.08071333458871024, 0.1369422277669079, 4.729303467834102, 17.707133424466146, 13.785705386825823, 2.8193101883297333, 0.01301657119122353, 29.887985119594077], [0.044772876932971925, 0.0572554091880969, 0.11331703359098537, 7.1661325011623775, 12.054381155836573, 14.878978817825823, 2.4734999305581504, 0.01086123761237863, 27.078750975528937], [0.054891384839218904, 0.059325144389263805, 0.1386540693371075, 6.967977732443206, 9.536223413310273, 12.504551393808573, 2.6981679534862817, 0.016984955193605746, 14.58150424501936], [0.0457537909700014, 0.075667845202812, 0.13311127584651208, 6.066507764604745, 12.41223526411421, 16.387155463858146, 2.7795835927252726, 0.012389238573740654, 26.825373262397093], [0.0433627714272182, 0.061559715168622256, 0.12911573554867004, 3.9890746270588346, 10.565168474147162, 16.4081658962275, 2.3811486939455095, 0.013268896364470347, 31.216190315746697], [0.043118546476506404, 0.05366066885450062, 0.12631855813344606, 7.359663041677657, 10.246310853299407, 6.0474623384013615, 2.7623088038292263, 0.010680834798298207, 31.89690611791166], [0.0604713614485221, 0.052566416559893595, 0.15230369301451696, 5.98848261393983, 13.82121826377072, 9.666647481195772, 3.264199539921067, 0.012236961079859983, 25.434688875576086], [0.05169326473856102, 0.061076856160060644, 0.14123510190059527, 6.370375402523406, 11.553540855488937, 12.48863634829238, 3.15646005200052, 0.021228133359971074, 27.76580853030549], [0.04783367435895111, 0.0691471279446338, 0.15561691251063503, 6.423664812031788, 14.252828436379254, 10.901110320497343, 2.8118721665222175, 0.017302708038585274, 27.907548993009954], [0.035448522276328207, 0.07072301092881808, 0.1316100702023373, 5.660030703840499, 15.79805038738254, 13.923209080439328, 2.798267278005963, 0.014117687422543834, 30.297181698824197], [0.045370071956792594, 0.05670268382127436, 0.12142227824453503, 8.075768930403873, 13.318134629404804, 15.630837624829478, 1.9631617743204557, 0.015858975631804897, 28.800785014695006], [0.051910898667729355, 0.0765435971941556, 0.14327330297879928, 5.569692722895824, 10.250086808906651, 17.858214676178477, 2.778020309876159, 0.015591851534357876, 26.046805423243573], [0.03103211034570255, 0.09693809968230394, 0.12100411402188382, 5.859202791442559, 15.094263329333613, 20.76164408960647, 2.5774913118308453, 0.014794690123611443, 31.577382771051525], [0.05071736607029624, 0.06570185240135569, 0.1978489344252828, 6.686106703438812, 15.195578649968931, 10.489972914959136, 3.4209325831203934, 0.015428801000918296, 33.1749285894743], [0.059117857311024966, 0.07913474497810222, 0.15597246278006138, 7.755735580497088, 16.50099955250655, 6.257966509127027, 2.8473541584539697, 0.014271341926056773, 30.27695616250891], [0.05116044031965035, 0.08243655011873985, 0.15238847690647436, 5.127595092151691, 10.708012259207045, 12.023413568498933, 3.449416700974663, 0.012553669874782267, 29.80599337436376], [0.041460513754012746, 0.08833799431544406, 0.13919852719495762, 5.331119140329503, 14.797588828846619, 9.828298066335693, 3.3202168952912645, 0.01808713237593401, 27.183748478347052], [0.03693138470231494, 0.08518430144099828, 0.14409711533687883, 4.394361479660213, 14.265675169884407, 9.284675020105716, 2.7603004354487277, 0.013308684236115132, 32.32487449696194], [0.06100941466544817, 0.07875489292445412, 0.13527672565944454, 7.260722289659147, 15.97428535282936, 10.601001406379549, 2.154377385065095, 0.00924244645356945, 13.368889502431736], [0.06096486940965808, 0.06545356874190895, 0.16935285214561793, 6.599906215470368, 18.92035150585551, 22.666208864010983, 2.803305907347482, 0.010690700509325706, 12.439388584302293], [0.048907644016008806, 0.07276469887201038, 0.17559230685843694, 7.021624659306239, 19.41842498138742, 6.230718148503517, 2.7184471093515077, 0.017013419291517888, 33.925639838039416], [0.0517745522355942, 0.060817721275322534, 0.12302645506473843, 5.774145745383047, 11.02054803517591, 16.09702104040424, 2.8123758383697295, 0.01091366607947712, 26.63335827403174]]
#, ['GABA_min', 'GABE_rnd', 'th', 'exp', 'learn speed','inc','dec','pattern chance','norm','---'])