"""
This module contains default configuration of the core 'plugin'.

The config object `c` is relatively imported, and options under the `core`
attribute is set to the default values. It's encouraged for plugin developer to
use this way for plugin options.

DO NOT EDIT THIS FILE, copy lines into `instance/config.py` to override.
"""
from whisper.core import app, require
from . import FileProvider as provider  # pylint: disable=unused-import

require('core')

# use specified provider to render file list
app.c.file.main = 'main'

app.c.file.css = ''
# Exmaple:
# app.c.file.css = """<style>
# ul {
#     ...
# }
# </style>"""

app.c.file.js = ''
# Exmaple:
# app.c.file.js = """<script>
# // code goes here ...
# </script>"""
