# -*- coding: utf-8 -*-
# Generated by Django 1.11.3 on 2018-02-21 06:17
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


def create_user_settings(apps, schema_editor):
    User = apps.get_registered_model('auth', 'User')
    UserSettings = apps.get_registered_model('main', 'UserSettings')
    for user in User.objects.all():
        UserSettings.objects.create(user=user)


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('main', '0034_periodictask_enabled'),
    ]

    operations = [
        migrations.CreateModel(
            name='UserSettings',
            fields=[
                ('id', models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('settings', models.TextField(default='{}')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='settings', related_query_name='settings', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.RunPython(create_user_settings),
    ]
