/**
This file was auto-generated by mupdfwrap.py.
*/

#ifndef MUPDF_CLASSES_H
#define MUPDF_CLASSES_H


#include "mupdf/fitz.h"
#include "mupdf/functions.h"
#include "mupdf/pdf.h"

#include <string>
#include <vector>


namespace mupdf
{

/* Forward declarations of all classes that we define. */
struct AaContext;
struct Aes;
struct AllocContext;
struct Arc4;
struct Archive;
struct BandWriter;
struct Bitmap;
struct Buffer;
struct ColorParams;
struct Colorspace;
struct ColorspaceContext;
struct CompressedBuffer;
struct CompressedImage;
struct CompressionParams;
struct Context;
struct Cookie;
struct DefaultColorspaces;
struct Device;
struct DeviceContainerStack;
struct DisplayList;
struct Document;
struct DocumentHandler;
struct DocumentHandlerContext;
struct DocumentWriter;
struct DrawOptions;
struct ErrorContext;
struct ErrorStackSlot;
struct Font;
struct FontContext;
struct FontFlagsT;
struct Glyph;
struct GlyphCache;
struct Halftone;
struct HashTable;
struct IccProfile;
struct Image;
struct Irect;
struct Jbig2Globals;
struct KeyStorable;
struct LayoutBlock;
struct LayoutChar;
struct LayoutLine;
struct Link;
struct LinkDest;
struct Location;
struct LocksContext;
struct Matrix;
struct Md5;
struct Outline;
struct OutlineItem;
struct OutlineIterator;
struct Output;
struct Overprint;
struct Page;
struct Path;
struct PathWalker;
struct PclOptions;
struct PclmOptions;
struct PdfAlertEvent;
struct PdfAnnot;
struct PdfCmap;
struct PdfCrypt;
struct PdfCsi;
struct PdfDocEvent;
struct PdfDocument;
struct PdfFilterOptions;
struct PdfFontDesc;
struct PdfFontResourceKey;
struct PdfFunction;
struct PdfGraftMap;
struct PdfGstate;
struct PdfHintPage;
struct PdfHintShared;
struct PdfHmtx;
struct PdfJournal;
struct PdfJs;
struct PdfJsConsole;
struct PdfKeystrokeEvent;
struct PdfLaunchUrlEvent;
struct PdfLayerConfig;
struct PdfLayerConfigUi;
struct PdfLexbuf;
struct PdfLexbufLarge;
struct PdfLockedFields;
struct PdfMailDocEvent;
struct PdfMarkList;
struct PdfMrange;
struct PdfObj;
struct PdfOcgDescriptor;
struct PdfPage;
struct PdfPattern;
struct PdfPkcs7DistinguishedName;
struct PdfPkcs7Signer;
struct PdfPkcs7Verifier;
struct PdfProcessor;
struct PdfRange;
struct PdfRedactOptions;
struct PdfRevPageMap;
struct PdfTextObjectState;
struct PdfTextState;
struct PdfUnsavedSig;
struct PdfVmtx;
struct PdfWriteOptions;
struct PdfXrange;
struct PdfXref;
struct PdfXrefEntry;
struct PdfXrefSubsec;
struct PdfocrOptions;
struct Pixmap;
struct PixmapImage;
struct Point;
struct Pool;
struct PwgOptions;
struct Quad;
struct Range;
struct Rect;
struct Separations;
struct Sha256;
struct Sha512;
struct Shade;
struct ShadeColorCache;
struct ShaperDataT;
struct StextBlock;
struct StextChar;
struct StextLine;
struct StextOptions;
struct StextPage;
struct Storable;
struct Store;
struct StoreHash;
struct StoreType;
struct Stream;
struct StrokeState;
struct StyleContext;
struct Text;
struct TextItem;
struct TextSpan;
struct Transition;
struct Tree;
struct TuningContext;
struct Vertex;
struct WarnContext;
struct Xml;
struct XmlDoc;
struct ZipWriter;


/** Wrapper class for struct `fz_aa_context`. */
struct AaContext
{
	/** We use default copy constructor and operator=. */

	/** Constructor using raw copy of pre-existing `fz_aa_context`. */
	FZ_FUNCTION AaContext(const fz_aa_context* internal);

	/** Constructor using raw copy of pre-existing `fz_aa_context`. */
	FZ_FUNCTION AaContext(const fz_aa_context internal);

	/** Access as underlying struct. */
	FZ_FUNCTION fz_aa_context* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const fz_aa_context* internal() const;

	/** We use default destructor. */

	/* == Member data. */

	/* These members are the same as the members of fz_aa_context. */
	int hscale;
	int vscale;
	int scale;
	int bits;
	int text_bits;
	float min_line_width;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();
};

/** Writes a AaContext's underlying fz_aa_context's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const AaContext& rhs);

/** Wrapper class for struct `fz_aes`. Not copyable or assignable. */
/**
	Structure definitions are public to enable stack
	based allocation. Do not access the members directly.
*/
struct Aes
{
	/* == Methods. */

	/** Wrapper for `fz_aes_crypt_cbc()`.  */
	/**
		AES block processing. Encrypts or Decrypts (according to mode,
		which must match what was initially set up) length bytes (which
		must be a multiple of 16), using (and modifying) the insertion
		vector iv, reading from input, and writing to output.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void aes_crypt_cbc(int mode, size_t length, unsigned char iv[16], const unsigned char *input, unsigned char *output);

	/** Wrapper for `fz_aes_setkey_dec()`.  */
	/**
		AES decryption intialisation. Fills in the supplied context
		and prepares for decryption using the given key.
	
		Returns non-zero for error (key size other than 128/192/256).
	
		Never throws an exception.
	*/
	FZ_FUNCTION int aes_setkey_dec(const unsigned char *key, int keysize);

	/** Wrapper for `fz_aes_setkey_enc()`.  */
	/**
		AES encryption intialisation. Fills in the supplied context
		and prepares for encryption using the given key.
	
		Returns non-zero for error (key size other than 128/192/256).
	
		Never throws an exception.
	*/
	FZ_FUNCTION int aes_setkey_enc(const unsigned char *key, int keysize);

	/** Constructor using raw copy of pre-existing `fz_aes`. */
	FZ_FUNCTION Aes(fz_aes* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_aes* m_internal;

	private:

	/** This class is not copyable or assignable. */
	Aes(const Aes& rhs);
	Aes& operator=(const Aes& rhs);
};

/** Wrapper class for struct `fz_alloc_context`. Not copyable or assignable. */
/**
	Allocator structure; holds callbacks and private data pointer.
*/
struct AllocContext
{
	/** Constructor using raw copy of pre-existing `fz_alloc_context`. */
	FZ_FUNCTION AllocContext(fz_alloc_context* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_alloc_context* m_internal;

	private:

	/** This class is not copyable or assignable. */
	AllocContext(const AllocContext& rhs);
	AllocContext& operator=(const AllocContext& rhs);
};

/** Wrapper class for struct `fz_arc4`. Not copyable or assignable. */
/**
	Structure definition is public to enable stack
	based allocation. Do not access the members directly.
*/
struct Arc4
{
	/* == Methods. */

	/** Wrapper for `fz_arc4_encrypt()`.  */
	/**
		RC4 block encrypt operation; encrypt src into dst (both of
		length len) updating the RC4 state as we go.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void arc4_encrypt(unsigned char *dest, const unsigned char *src, size_t len);

	/** Wrapper for `fz_arc4_init()`.  */
	/**
		RC4 initialization. Begins an RC4 operation, writing a new
		context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void arc4_init(const unsigned char *key, size_t len);

	/** Constructor using raw copy of pre-existing `fz_arc4`. */
	FZ_FUNCTION Arc4(fz_arc4* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_arc4* m_internal;

	private:

	/** This class is not copyable or assignable. */
	Arc4(const Arc4& rhs);
	Arc4& operator=(const Arc4& rhs);
};

/** Wrapper class for struct `fz_archive`. Not copyable or assignable. */
/**
	fz_archive:

	fz_archive provides methods for accessing "archive" files.
	An archive file is a conceptual entity that contains multiple
	files, which can be counted, enumerated, and read.

	Implementations of fz_archive based upon directories, zip
	and tar files are included.
*/
struct Archive
{
	/** == Constructors. */

	/** Constructor using `fz_new_archive_of_size()`. */
	FZ_FUNCTION Archive(const Stream& file, int size);

	/* == Methods. */

	/** Wrapper for `fz_archive_format()`.  */
	/**
		Return a pointer to a string describing the format of the
		archive.
	
		The lifetime of the string is unspecified (in current
		implementations the string will persist until the archive
		is closed, but this is not guaranteed).
	*/
	FZ_FUNCTION const char *archive_format();

	/** Wrapper for `fz_count_archive_entries()`.  */
	/**
		Number of entries in archive.
	
		Will always return a value >= 0.
	
		May throw an exception if this type of archive cannot count the
		entries (such as a directory).
	*/
	FZ_FUNCTION int count_archive_entries();

	/** Wrapper for `fz_has_archive_entry()`.  */
	/**
		Check if entry by given name exists.
	
		If named entry does not exist 0 will be returned, if it does
		exist 1 is returned.
	
		name: Entry name to look for, this must be an exact match to
		the entry name in the archive.
	*/
	FZ_FUNCTION int has_archive_entry(const char *name);

	/** Wrapper for `fz_list_archive_entry()`.  */
	/**
		Get listed name of entry position idx.
	
		idx: Must be a value >= 0 < return value from
		fz_count_archive_entries. If not in range NULL will be
		returned.
	
		May throw an exception if this type of archive cannot list the
		entries (such as a directory).
	*/
	FZ_FUNCTION const char *list_archive_entry(int idx);

	/** Wrapper for `fz_open_archive_entry()`.  */
	/**
		Opens an archive entry as a stream.
	
		name: Entry name to look for, this must be an exact match to
		the entry name in the archive.
	*/
	FZ_FUNCTION Stream open_archive_entry(const char *name);

	/** Wrapper for `fz_read_archive_entry()`.  */
	/**
		Reads all bytes in an archive entry
		into a buffer.
	
		name: Entry name to look for, this must be an exact match to
		the entry name in the archive.
	*/
	FZ_FUNCTION Buffer read_archive_entry(const char *name);

	/** Constructor using raw copy of pre-existing `fz_archive`. */
	FZ_FUNCTION Archive(fz_archive* internal);

	/** Destructor using fz_drop_archive(). */
	FZ_FUNCTION ~Archive();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_archive* m_internal;

	private:

	/** This class is not copyable or assignable. */
	Archive(const Archive& rhs);
	Archive& operator=(const Archive& rhs);
};

/** Wrapper class for struct `fz_band_writer`. Not copyable or assignable. */
/**
	fz_band_writer
*/
struct BandWriter
{
	enum Cm
	{
		MONO,
		COLOR,
	};
	enum P
	{
		PNG,
		PNM,
		PAM,
		PBM,
		PKM,
		PS,
		PSD,
	};

	/** == Constructors. */

	/** Constructor using `fz_new_band_writer_of_size()`. */
	FZ_FUNCTION BandWriter(size_t size, const Output& out);

	/** Constructor using `fz_new_color_pcl_band_writer()`. */
	/**
		Create a new band writer, outputing color pcl.
	*/
	/* Disabled because same args as fz_new_mono_pcl_band_writer.
	FZ_FUNCTION BandWriter(const Output& out, const PclOptions& options);
	*/

	/** Constructor using `fz_new_mono_pcl_band_writer()`. */
	/**
		Create a new band writer, outputing monochrome pcl.
	*/
	FZ_FUNCTION BandWriter(const Output& out, const PclOptions& options);

	/** Constructor using `fz_new_mono_pwg_band_writer()`. */
	/**
		Create a new monochrome pwg band writer.
	*/
	FZ_FUNCTION BandWriter(const Output& out, PwgOptions& pwg);

	/** Constructor using `fz_new_pam_band_writer()`. */
	/**
		Create a band writer targetting pnm (greyscale, rgb or cmyk,
		with or without alpha).
	*/
	/* Disabled because same args as fz_new_png_band_writer.
	FZ_FUNCTION BandWriter(const Output& out);
	*/

	/** Constructor using `fz_new_pbm_band_writer()`. */
	/**
		Create a new band writer, targetting pbm.
	*/
	/* Disabled because same args as fz_new_png_band_writer.
	FZ_FUNCTION BandWriter(const Output& out);
	*/

	/** Constructor using `fz_new_pclm_band_writer()`. */
	/**
		Create a new band writer, outputing pclm
	*/
	FZ_FUNCTION BandWriter(const Output& out, const PclmOptions& options);

	/** Constructor using `fz_new_pdfocr_band_writer()`. */
	/**
		Create a new band writer, outputing pdfocr.
	
		Ownership of output stays with the caller, the band writer
		borrows the reference. The caller must keep the output around
		for the duration of the band writer, and then close/drop as
		appropriate.
	*/
	FZ_FUNCTION BandWriter(const Output& out, PdfocrOptions& options);

	/** Constructor using `fz_new_pkm_band_writer()`. */
	/**
		Create a new pkm band writer for CMYK pixmaps.
	*/
	/* Disabled because same args as fz_new_png_band_writer.
	FZ_FUNCTION BandWriter(const Output& out);
	*/

	/** Constructor using `fz_new_png_band_writer()`. */
	/**
		Create a new png band writer (greyscale or RGB, with or without
		alpha).
	*/
	FZ_FUNCTION BandWriter(const Output& out);

	/** Constructor using `fz_new_pnm_band_writer()`. */
	/**
		Create a band writer targetting pnm (greyscale or rgb, no
		alpha).
	*/
	/* Disabled because same args as fz_new_png_band_writer.
	FZ_FUNCTION BandWriter(const Output& out);
	*/

	/** Constructor using `fz_new_ps_band_writer()`. */
	/**
		Create a postscript band writer for gray, rgb, or cmyk, no
		alpha.
	*/
	/* Disabled because same args as fz_new_png_band_writer.
	FZ_FUNCTION BandWriter(const Output& out);
	*/

	/** Constructor using `fz_new_psd_band_writer()`. */
	/**
		Open a PSD band writer.
	*/
	/* Disabled because same args as fz_new_png_band_writer.
	FZ_FUNCTION BandWriter(const Output& out);
	*/

	/** Constructor using `fz_new_pwg_band_writer()`. */
	/**
		Create a new color pwg band writer.
	*/
	/* Disabled because same args as fz_new_mono_pwg_band_writer.
	FZ_FUNCTION BandWriter(const Output& out, PwgOptions& pwg);
	*/

	/** Calls fz_new_mono_pcl_band_writer() or fz_new_color_pcl_band_writer(). */
	FZ_FUNCTION BandWriter(Output& out, Cm cm, const PclOptions& options);

	/** Calls fz_new_p*_band_writer(). */
	FZ_FUNCTION BandWriter(Output& out, P p);

	/** Calls fz_new_mono_pwg_band_writer() or fz_new_pwg_band_writer(). */
	FZ_FUNCTION BandWriter(Output& out, Cm cm, const PwgOptions& options);

	/* == Methods. */

	/** Wrapper for `fz_close_band_writer()`.  */
	/**
		Finishes up the output and closes the band writer. After this
		call no more headers or bands may be written.
	*/
	FZ_FUNCTION void close_band_writer();

	/** Wrapper for `fz_pdfocr_band_writer_set_progress()`.  */
	/**
		Set the progress callback for a pdfocr bandwriter.
	*/
	FZ_FUNCTION void pdfocr_band_writer_set_progress(fz_pdfocr_progress_fn *progress_fn, void *progress_arg);

	/** Wrapper for `fz_write_band()`.  */
	/**
		Cause a band writer to write the next band
		of data for an image.
	
		stride: The byte offset from the first byte of the data
		for a pixel to the first byte of the data for the same pixel
		on the row below.
	
		band_height: The number of lines in this band.
	
		samples: Pointer to first byte of the data.
	*/
	FZ_FUNCTION void write_band(int stride, int band_height, const unsigned char *samples);

	/** Wrapper for `fz_write_header()`.  */
	/**
		Cause a band writer to write the header for
		a banded image with the given properties/dimensions etc. This
		also configures the bandwriter for the format of the data to be
		passed in future calls.
	
		w, h: Width and Height of the entire page.
	
		n: Number of components (including spots and alphas).
	
		alpha: Number of alpha components.
	
		xres, yres: X and Y resolutions in dpi.
	
		cs: Colorspace (NULL for bitmaps)
	
		seps: Separation details (or NULL).
	*/
	FZ_FUNCTION void write_header(int w, int h, int n, int alpha, int xres, int yres, int pagenum, const Colorspace& cs, const Separations& seps);

	/** Constructor using raw copy of pre-existing `fz_band_writer`. */
	FZ_FUNCTION BandWriter(fz_band_writer* internal);

	/** Destructor using fz_drop_band_writer(). */
	FZ_FUNCTION ~BandWriter();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_band_writer* m_internal;

	private:

	/** This class is not copyable or assignable. */
	BandWriter(const BandWriter& rhs);
	BandWriter& operator=(const BandWriter& rhs);
};

/** Wrapper class for struct `fz_bitmap`. */
/**
	Bitmaps have 1 bit per component. Only used for creating
	halftoned versions of contone buffers, and saving out. Samples
	are stored msb first, akin to pbms.

	The internals of this struct are considered implementation
	details and subject to change. Where possible, accessor
	functions should be used in preference.
*/
struct Bitmap
{
	/** == Constructors. */

	/** Constructor using `fz_new_bitmap()`. */
	/**
		Create a new bitmap.
	
		w, h: Width and Height for the bitmap
	
		n: Number of color components (assumed to be a divisor of 8)
	
		xres, yres: X and Y resolutions (in pixels per inch).
	
		Returns pointer to created bitmap structure. The bitmap
		data is uninitialised.
	*/
	FZ_FUNCTION Bitmap(int w, int h, int n, int xres, int yres);

	/** Constructor using `fz_new_bitmap_from_pixmap()`. */
	/**
		Make a bitmap from a pixmap and a halftone.
	
		pix: The pixmap to generate from. Currently must be a single
		color component with no alpha.
	
		ht: The halftone to use. NULL implies the default halftone.
	
		Returns the resultant bitmap. Throws exceptions in the case of
		failure to allocate.
	*/
	FZ_FUNCTION Bitmap(const Pixmap& pix, const Halftone& ht);

	/** Constructor using `fz_new_bitmap_from_pixmap_band()`. */
	/**
		Make a bitmap from a pixmap and a
		halftone, allowing for the position of the pixmap within an
		overall banded rendering.
	
		pix: The pixmap to generate from. Currently must be a single
		color component with no alpha.
	
		ht: The halftone to use. NULL implies the default halftone.
	
		band_start: Vertical offset within the overall banded rendering
		(in pixels)
	
		Returns the resultant bitmap. Throws exceptions in the case of
		failure to allocate.
	*/
	FZ_FUNCTION Bitmap(const Pixmap& pix, const Halftone& ht, int band_start);

	/** Copy constructor using `fz_keep_bitmap()`. */
	FZ_FUNCTION Bitmap(const Bitmap& rhs);

	/** operator= using `fz_keep_bitmap()` and `fz_drop_bitmap()`. */
	FZ_FUNCTION Bitmap& operator=(const Bitmap& rhs);

	/* == Methods. */

	/** Wrapper for `fz_bitmap_details()`.
	
	This method has out-params. Python/C# wrappers look like:
		`bitmap_details()` => `(int w, int h, int n, int stride)`
	 */
	/**
		Retrieve details of a given bitmap.
	
		bitmap: The bitmap to query.
	
		w: Pointer to storage to retrieve width (or NULL).
	
		h: Pointer to storage to retrieve height (or NULL).
	
		n: Pointer to storage to retrieve number of color components (or
		NULL).
	
		stride: Pointer to storage to retrieve bitmap stride (or NULL).
	*/
	FZ_FUNCTION void bitmap_details(
			#ifdef SWIG
				int *OUTPUT
			#else
				int *w
			#endif
			, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *h
			#endif
			, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *n
			#endif
			, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *stride
			#endif
			);

	/** Wrapper for `fz_clear_bitmap()`.  */
	/**
		Set the entire bitmap to 0.
	
		Never throws exceptions.
	*/
	FZ_FUNCTION void clear_bitmap();

	/** Wrapper for `fz_save_bitmap_as_pbm()`.  */
	/**
		Save a bitmap as a pbm.
	*/
	FZ_FUNCTION void save_bitmap_as_pbm(const char *filename);

	/** Wrapper for `fz_save_bitmap_as_pcl()`.  */
	/**
		Save a bitmap as mono PCL.
	*/
	FZ_FUNCTION void save_bitmap_as_pcl(char *filename, int append, const PclOptions& pcl);

	/** Wrapper for `fz_save_bitmap_as_pkm()`.  */
	/**
		Save a CMYK bitmap as a pkm.
	*/
	FZ_FUNCTION void save_bitmap_as_pkm(const char *filename);

	/** Wrapper for `fz_save_bitmap_as_pwg()`.  */
	/**
		Save a bitmap as a PWG.
	*/
	FZ_FUNCTION void save_bitmap_as_pwg(char *filename, int append, PwgOptions& pwg);

	/** Constructor using raw copy of pre-existing `fz_bitmap`. */
	FZ_FUNCTION Bitmap(fz_bitmap* internal);

	/* == Accessors to members of fz_bitmap m_internal. */

	FZ_FUNCTION int refs();
	FZ_FUNCTION int w();
	FZ_FUNCTION int h();
	FZ_FUNCTION int stride();
	FZ_FUNCTION int n();
	FZ_FUNCTION int xres();
	FZ_FUNCTION int yres();
	FZ_FUNCTION const unsigned char *samples();

	/** Destructor using fz_drop_bitmap(). */
	FZ_FUNCTION ~Bitmap();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_bitmap* m_internal;
};

/** Wrapper class for struct `fz_buffer`. */
/**
	fz_buffer is a wrapper around a dynamically allocated array of
	bytes.

	Buffers have a capacity (the number of bytes storage immediately
	available) and a current size.

	The contents of the structure are considered implementation
	details and are subject to change. Users should use the accessor
	functions in preference.
*/
struct Buffer
{
	/** == Constructors. */

	/** Constructor using `fz_new_buffer()`. */
	FZ_FUNCTION Buffer(size_t capacity);

	/** Constructor using `fz_new_buffer_from_base64()`. */
	/**
		Create a new buffer with data decoded from a base64 input string.
	*/
	FZ_FUNCTION Buffer(const char *data, size_t size);

	/** Constructor using `fz_new_buffer_from_data()`. */
	/**
		Create a new buffer with existing data.
	
		data: Pointer to existing data.
		size: Size of existing data.
	
		Takes ownership of data. Does not make a copy. Calls fz_free on
		the data when the buffer is deallocated. Do not use 'data' after
		passing to this function.
	
		Returns pointer to new buffer. Throws exception on allocation
		failure.
	*/
	FZ_FUNCTION Buffer(unsigned char *data, size_t size);

	/** Constructor using `fz_new_buffer_from_display_list()`. */
	FZ_FUNCTION Buffer(const DisplayList& list, StextOptions& options);

	/** Constructor using `fz_new_buffer_from_image_as_png()`. */
	/**
		Reencode a given image as a PNG into a buffer.
	
		Ownership of the buffer is returned.
	*/
	FZ_FUNCTION Buffer(const Image& image, ColorParams& color_params);

	/** Constructor using `fz_new_buffer_from_page()`. */
	FZ_FUNCTION Buffer(const Page& page, StextOptions& options);

	/** Constructor using `fz_new_buffer_from_page_number()`. */
	FZ_FUNCTION Buffer(const Document& doc, int number, StextOptions& options);

	/** Constructor using `fz_new_buffer_from_page_with_format()`. */
	/**
		Returns an fz_buffer containing a page after conversion to specified format.
	
		page: The page to convert.
		format, options: Passed to fz_new_document_writer_with_output() internally.
		transform, cookie: Passed to fz_run_page() internally.
	*/
	FZ_FUNCTION Buffer(const Page& page, const char *format, const char *options, Matrix& transform, Cookie& cookie);

	/** Constructor using `fz_new_buffer_from_pixmap_as_png()`. */
	/**
		Reencode a given pixmap as a PNG into a buffer.
	
		Ownership of the buffer is returned.
	*/
	FZ_FUNCTION Buffer(const Pixmap& pixmap, ColorParams& color_params);

	/** Constructor using `fz_new_buffer_from_shared_data()`. */
	/**
		Like fz_new_buffer, but does not take ownership.
	*/
	FZ_FUNCTION Buffer(const unsigned char *data, size_t size);

	/** Constructor using `fz_new_buffer_from_stext_page()`. */
	/**
		Convert structured text into plain text.
	*/
	FZ_FUNCTION Buffer(const StextPage& text);

	/** Constructor using `fz_read_file()`. */
	/**
		Read all the contents of a file into a buffer.
	*/
	FZ_FUNCTION Buffer(const char *filename);

	/** Copy constructor using `fz_keep_buffer()`. */
	FZ_FUNCTION Buffer(const Buffer& rhs);

	/** operator= using `fz_keep_buffer()` and `fz_drop_buffer()`. */
	FZ_FUNCTION Buffer& operator=(const Buffer& rhs);

	/* == Static methods. */

	/** Wrapper for `fz_new_buffer_from_copied_data()`.  */
	/**
		Create a new buffer containing a copy of the passed data.
	*/
	FZ_FUNCTION static Buffer new_buffer_from_copied_data(const unsigned char *data, size_t size);

	/* == Methods. */

	/** Wrapper for `fz_append_bits()`.  */
	FZ_FUNCTION void append_bits(int value, int count);

	/** Wrapper for `fz_append_bits_pad()`.  */
	FZ_FUNCTION void append_bits_pad();

	/** Wrapper for `fz_append_buffer()`.  */
	/**
		Append the contents of the source buffer onto the end of the
		destination buffer, extending automatically as required.
	
		Ownership of buffers does not change.
	*/
	FZ_FUNCTION void append_buffer(const Buffer& source);

	/** Wrapper for `fz_append_byte()`.  */
	FZ_FUNCTION void append_byte(int c);

	/** Wrapper for `fz_append_data()`.  */
	/**
		fz_append_*: Append data to a buffer.
	
		The buffer will automatically grow as required.
	*/
	FZ_FUNCTION void append_data(const void *data, size_t len);

	/** Wrapper for `fz_append_int16_be()`.  */
	FZ_FUNCTION void append_int16_be(int x);

	/** Wrapper for `fz_append_int16_le()`.  */
	FZ_FUNCTION void append_int16_le(int x);

	/** Wrapper for `fz_append_int32_be()`.  */
	FZ_FUNCTION void append_int32_be(int x);

	/** Wrapper for `fz_append_int32_le()`.  */
	FZ_FUNCTION void append_int32_le(int x);

	/** Wrapper for `fz_append_pdf_string()`.  */
	/**
		fz_append_pdf_string: Append a string with PDF syntax quotes and
		escapes.
	
		The buffer will automatically grow as required.
	*/
	FZ_FUNCTION void append_pdf_string(const char *text);

	/** Wrapper for `fz_append_rune()`.  */
	FZ_FUNCTION void append_rune(int c);

	/** Wrapper for `fz_append_string()`.  */
	FZ_FUNCTION void append_string(const char *data);

	/** Wrapper for `fz_append_vprintf()`.  */
	/**
		fz_append_vprintf: Format and append data to buffer using
		printf-like formatting with varargs (see fz_vsnprintf).
	*/
	FZ_FUNCTION void append_vprintf(const char *fmt, va_list args);

	/** Wrapper for `fz_buffer_extract()`.
	
	This method has out-params. Python/C# wrappers look like:
		`buffer_extract()` => `(size_t, unsigned char *data)`
	 */
	/**
		Take ownership of buffer contents.
	
		Performs the same task as fz_buffer_storage, but ownership of
		the data buffer returns with this call. The buffer is left
		empty.
	
		Note: Bad things may happen if this is called on a buffer with
		multiple references that is being used from multiple threads.
	
		data: Pointer to place to retrieve data pointer.
	
		Returns length of stream.
	*/
	FZ_FUNCTION size_t buffer_extract(
			#ifdef SWIG
				unsigned char **OUTPUT
			#else
				unsigned char **data
			#endif
			);

	/** Wrapper for `fz_buffer_storage()`.
	
	This method has out-params. Python/C# wrappers look like:
		`buffer_storage()` => `(size_t, unsigned char *datap)`
	 */
	/**
		Retrieve internal memory of buffer.
	
		datap: Output parameter that will be pointed to the data.
	
		Returns the current size of the data in bytes.
	*/
	FZ_FUNCTION size_t buffer_storage(
			#ifdef SWIG
				unsigned char **OUTPUT
			#else
				unsigned char **datap
			#endif
			);

	/** Wrapper for `fz_clear_buffer()`.  */
	/**
		Empties the buffer. Storage is not freed, but is held ready
		to be reused as the buffer is refilled.
	
		Never throws exceptions.
	*/
	FZ_FUNCTION void clear_buffer();

	/** Wrapper for `fz_grow_buffer()`.  */
	/**
		Make some space within a buffer (i.e. ensure that
		capacity > size).
	*/
	FZ_FUNCTION void grow_buffer();

	/** Wrapper for `fz_load_jbig2_globals()`.  */
	/**
		Create a jbig2 globals record from a buffer.
	
		Immutable once created.
	*/
	FZ_FUNCTION Jbig2Globals load_jbig2_globals();

	/** Wrapper for `fz_md5_buffer()`.  */
	/**
		Create an MD5 digest from buffer contents.
	
		Never throws exceptions.
	*/
	FZ_FUNCTION void md5_buffer(unsigned char digest[16]);

	/** Wrapper for `fz_new_display_list_from_svg()`.
	
	This method has out-params. Python/C# wrappers look like:
		`new_display_list_from_svg(const char *base_uri, fz_archive *zip)` => `(fz_display_list *, float w, float h)`
	 */
	/**
		Parse an SVG document into a display-list.
	*/
	FZ_FUNCTION DisplayList new_display_list_from_svg(const char *base_uri, const Archive& zip, 
			#ifdef SWIG
				float *OUTPUT
			#else
				float *w
			#endif
			, 
			#ifdef SWIG
				float *OUTPUT
			#else
				float *h
			#endif
			);

	/** Wrapper for `fz_new_image_from_buffer()`.  */
	/**
		Create a new image from a
		buffer of data, inferring its type from the format
		of the data.
	*/
	FZ_FUNCTION Image new_image_from_buffer();

	/** Wrapper for `fz_new_image_from_svg()`.  */
	/**
		Create a scalable image from an SVG document.
	*/
	FZ_FUNCTION Image new_image_from_svg(const char *base_uri, const Archive& zip);

	/** Wrapper for `fz_open_buffer()`.  */
	/**
		Open a buffer as a stream.
	
		buf: The buffer to open. Ownership of the buffer is NOT passed
		in (this function takes its own reference).
	
		Returns pointer to newly created stream. May throw exceptions on
		failure to allocate.
	*/
	FZ_FUNCTION Stream open_buffer();

	/** Wrapper for `fz_resize_buffer()`.  */
	/**
		Ensure that a buffer has a given capacity,
		truncating data if required.
	
		capacity: The desired capacity for the buffer. If the current
		size of the buffer contents is smaller than capacity, it is
		truncated.
	*/
	FZ_FUNCTION void resize_buffer(size_t capacity);

	/** Wrapper for `fz_save_buffer()`.  */
	/**
		Save the contents of a buffer to a file.
	*/
	FZ_FUNCTION void save_buffer(const char *filename);

	/** Wrapper for `fz_string_from_buffer()`.  */
	/**
		Ensure that a buffer's data ends in a
		0 byte, and return a pointer to it.
	*/
	FZ_FUNCTION const char *string_from_buffer();

	/** Wrapper for `fz_terminate_buffer()`.  */
	/**
		Zero-terminate buffer in order to use as a C string.
	
		This byte is invisible and does not affect the length of the
		buffer as returned by fz_buffer_storage. The zero byte is
		written *after* the data, and subsequent writes will overwrite
		the terminating byte.
	
		Subsequent changes to the size of the buffer (such as by
		fz_buffer_trim, fz_buffer_grow, fz_resize_buffer, etc) may
		invalidate this.
	*/
	FZ_FUNCTION void terminate_buffer();

	/** Wrapper for `fz_trim_buffer()`.  */
	/**
		Trim wasted capacity from a buffer by resizing internal memory.
	*/
	FZ_FUNCTION void trim_buffer();

	/** Wrapper for `pdf_append_token()`.  */
	FZ_FUNCTION void append_token(int tok, const PdfLexbuf& lex);

	/** Wrapper for `pdf_new_buffer_processor()`.  */
	FZ_FUNCTION PdfProcessor new_buffer_processor(int ahxencode);

	/** Constructor using raw copy of pre-existing `fz_buffer`. */
	FZ_FUNCTION Buffer(fz_buffer* internal=NULL);

	/** Destructor using fz_drop_buffer(). */
	FZ_FUNCTION ~Buffer();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_buffer* m_internal;
};

/** Wrapper class for struct `fz_color_params`. */
struct ColorParams
{
	/** Equivalent to fz_default_color_params. */
	FZ_FUNCTION ColorParams();

	/** We use default copy constructor and operator=. */

	/** Constructor using raw copy of pre-existing `fz_color_params`. */
	FZ_FUNCTION ColorParams(const fz_color_params* internal);

	/** Constructor using raw copy of pre-existing `fz_color_params`. */
	FZ_FUNCTION ColorParams(const fz_color_params internal);

	/** Access as underlying struct. */
	FZ_FUNCTION fz_color_params* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const fz_color_params* internal() const;

	/** We use default destructor. */

	/* == Member data. */

	/* These members are the same as the members of fz_color_params. */
	uint8_t ri;
	uint8_t bp;
	uint8_t op;
	uint8_t opm;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();
};

/** Writes a ColorParams's underlying fz_color_params's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const ColorParams& rhs);

/** Wrapper class for struct `fz_colorspace`. */
/**
	Describes a given colorspace.
*/
struct Colorspace
{
	enum Fixed
	{
		Fixed_GRAY,
		Fixed_RGB,
		Fixed_BGR,
		Fixed_CMYK,
		Fixed_LAB,
	};

	/** == Constructors. */

	/** Constructor using `fz_new_cal_gray_colorspace()`. */
	/**
		Create a calibrated gray colorspace.
	
		The returned reference should be dropped when it is finished
		with.
	
		Colorspaces are immutable once created.
	*/
	FZ_FUNCTION Colorspace(float wp[3], float bp[3], float gamma);

	/** Constructor using `fz_new_cal_rgb_colorspace()`. */
	/**
		Create a calibrated rgb colorspace.
	
		The returned reference should be dropped when it is finished
		with.
	
		Colorspaces are immutable once created.
	*/
	FZ_FUNCTION Colorspace(float wp[3], float bp[3], float gamma[3], float matrix[9]);

	/** Constructor using `fz_new_colorspace()`. */
	/**
		Creates a new colorspace instance and returns a reference.
	
		No internal checking is done that the colorspace type (e.g.
		CMYK) matches with the flags (e.g. FZ_COLORSPACE_HAS_CMYK) or
		colorant count (n) or name.
	
		The reference should be dropped when it is finished with.
	
		Colorspaces are immutable once created (with the exception of
		setting up colorant names for separation spaces).
	*/
	FZ_FUNCTION Colorspace(enum fz_colorspace_type type, int flags, int n, const char *name);

	/** Constructor using `fz_new_icc_colorspace()`. */
	/**
		Create a colorspace from an ICC profile supplied in buf.
	
		Limited checking is done to ensure that the colorspace type is
		appropriate for the supplied ICC profile.
	
		An additional reference is taken to buf, which will be dropped
		on destruction. Ownership is NOT passed in.
	
		The returned reference should be dropped when it is finished
		with.
	
		Colorspaces are immutable once created.
	*/
	FZ_FUNCTION Colorspace(enum fz_colorspace_type type, int flags, const char *name, const Buffer& buf);

	/** Constructor using `fz_new_indexed_colorspace()`. */
	/**
		Create an indexed colorspace.
	
		The supplied lookup table is high palette entries long. Each
		entry is n bytes long, where n is given by the number of
		colorants in the base colorspace, one byte per colorant.
	
		Ownership of lookup is passed it; it will be freed on
		destruction, so must be heap allocated.
	
		The colorspace will keep an additional reference to the base
		colorspace that will be dropped on destruction.
	
		The returned reference should be dropped when it is finished
		with.
	
		Colorspaces are immutable once created.
	*/
	FZ_FUNCTION Colorspace(const Colorspace& base, int high, unsigned char *lookup);

	/** Construct using one of: fz_device_gray(), fz_device_rgb(), fz_device_bgr(), fz_device_cmyk(), fz_device_lab(). */
	FZ_FUNCTION Colorspace(Fixed fixed);

	/** Sets m_internal = NULL. */
	FZ_FUNCTION Colorspace();

	/** Copy constructor using `fz_keep_colorspace()`. */
	FZ_FUNCTION Colorspace(const Colorspace& rhs);

	/** operator= using `fz_keep_colorspace()` and `fz_drop_colorspace()`. */
	FZ_FUNCTION Colorspace& operator=(const Colorspace& rhs);

	/* == Methods. */

	/** Wrapper for `fz_clamp_color()`.
	
	This method has out-params. Python/C# wrappers look like:
		`clamp_color(const float *in)` => float out
	 */
	/**
		Clamp the samples in a color to the correct ranges for a
		given colorspace.
	*/
	FZ_FUNCTION void clamp_color(const float *in, 
			#ifdef SWIG
				float *OUTPUT
			#else
				float *out
			#endif
			);

	/** Wrapper for `fz_colorspace_colorant()`.  */
	/**
		Retrieve a the name for a colorant.
	
		Returns a pointer with the same lifespan as the colorspace.
	*/
	FZ_FUNCTION const char *colorspace_colorant(int n);

	/** Wrapper for `fz_colorspace_device_n_has_cmyk()`.  */
	/**
		True if DeviceN color space has cyan magenta yellow or black as
		one of its colorants.
	*/
	FZ_FUNCTION int colorspace_device_n_has_cmyk();

	/** Wrapper for `fz_colorspace_device_n_has_only_cmyk()`.  */
	/**
		True if DeviceN color space has only colorants from the CMYK set.
	*/
	FZ_FUNCTION int colorspace_device_n_has_only_cmyk();

	/** Wrapper for `fz_colorspace_is_cmyk()`.  */
	FZ_FUNCTION int colorspace_is_cmyk();

	/** Wrapper for `fz_colorspace_is_device()`.  */
	FZ_FUNCTION int colorspace_is_device();

	/** Wrapper for `fz_colorspace_is_device_cmyk()`.  */
	FZ_FUNCTION int colorspace_is_device_cmyk();

	/** Wrapper for `fz_colorspace_is_device_gray()`.  */
	FZ_FUNCTION int colorspace_is_device_gray();

	/** Wrapper for `fz_colorspace_is_device_n()`.  */
	FZ_FUNCTION int colorspace_is_device_n();

	/** Wrapper for `fz_colorspace_is_gray()`.  */
	/**
		Tests for particular types of colorspaces
	*/
	FZ_FUNCTION int colorspace_is_gray();

	/** Wrapper for `fz_colorspace_is_indexed()`.  */
	FZ_FUNCTION int colorspace_is_indexed();

	/** Wrapper for `fz_colorspace_is_lab()`.  */
	FZ_FUNCTION int colorspace_is_lab();

	/** Wrapper for `fz_colorspace_is_lab_icc()`.  */
	FZ_FUNCTION int colorspace_is_lab_icc();

	/** Wrapper for `fz_colorspace_is_rgb()`.  */
	FZ_FUNCTION int colorspace_is_rgb();

	/** Wrapper for `fz_colorspace_is_subtractive()`.  */
	/**
		True for CMYK, Separation and DeviceN colorspaces.
	*/
	FZ_FUNCTION int colorspace_is_subtractive();

	/** Wrapper for `fz_colorspace_n()`.  */
	/**
		Query the number of colorants in a colorspace.
	*/
	FZ_FUNCTION int colorspace_n();

	/** Wrapper for `fz_colorspace_name()`.  */
	/**
		Query the name of a colorspace.
	
		The returned string has the same lifespan as the colorspace
		does. Caller should not free it.
	*/
	FZ_FUNCTION const char *colorspace_name();

	/** Wrapper for `fz_colorspace_name_colorant()`.  */
	/**
		Assign a name for a given colorant in a colorspace.
	
		Used while initially setting up a colorspace. The string is
		copied into local storage, so need not be retained by the
		caller.
	*/
	FZ_FUNCTION void colorspace_name_colorant(int n, const char *name);

	/** Wrapper for `fz_colorspace_type()`.  */
	/**
		Query the type of colorspace.
	*/
	FZ_FUNCTION enum fz_colorspace_type colorspace_type();

	/** Wrapper for `fz_convert_color()`.
	
	This method has out-params. Python/C# wrappers look like:
		`convert_color(const float *sv, fz_colorspace *ds, fz_colorspace *is, fz_color_params params)` => float dv
	 */
	/**
		Convert color values sv from colorspace ss into colorvalues dv
		for colorspace ds, via an optional intervening space is,
		respecting the given color_params.
	*/
	FZ_FUNCTION void convert_color(const float *sv, const Colorspace& ds, 
			#ifdef SWIG
				float *OUTPUT
			#else
				float *dv
			#endif
			, const Colorspace& is, ColorParams& params);

	/** Wrapper for `fz_convert_separation_colors()`.
	
	This method has out-params. Python/C# wrappers look like:
		`convert_separation_colors(const float *src_color, fz_separations *dst_seps, fz_colorspace *dst_cs, fz_color_params color_params)` => float dst_color
	 */
	/**
		Convert a color given in terms of one colorspace,
		to a color in terms of another colorspace/separations.
	*/
	FZ_FUNCTION void convert_separation_colors(const float *src_color, const Separations& dst_seps, const Colorspace& dst_cs, 
			#ifdef SWIG
				float *OUTPUT
			#else
				float *dst_color
			#endif
			, ColorParams& color_params);

	/** Wrapper for `fz_is_valid_blend_colorspace()`.  */
	/**
		Check to see that a colorspace is appropriate to be used as
		a blending space (i.e. only grey, rgb or cmyk).
	*/
	FZ_FUNCTION int is_valid_blend_colorspace();

	/** Wrapper for `fz_new_indexed_colorspace()`.  */
	/**
		Create an indexed colorspace.
	
		The supplied lookup table is high palette entries long. Each
		entry is n bytes long, where n is given by the number of
		colorants in the base colorspace, one byte per colorant.
	
		Ownership of lookup is passed it; it will be freed on
		destruction, so must be heap allocated.
	
		The colorspace will keep an additional reference to the base
		colorspace that will be dropped on destruction.
	
		The returned reference should be dropped when it is finished
		with.
	
		Colorspaces are immutable once created.
	*/
	FZ_FUNCTION Colorspace new_indexed_colorspace(int high, unsigned char *lookup);

	/** Wrapper for `fz_new_pixmap()`.  */
	/**
		Create a new pixmap, with its origin at (0,0)
	
		cs: The colorspace to use for the pixmap, or NULL for an alpha
		plane/mask.
	
		w: The width of the pixmap (in pixels)
	
		h: The height of the pixmap (in pixels)
	
		seps: Details of separations.
	
		alpha: 0 for no alpha, 1 for alpha.
	
		Returns a pointer to the new pixmap. Throws exception on failure
		to allocate.
	*/
	FZ_FUNCTION Pixmap new_pixmap(int w, int h, const Separations& seps, int alpha);

	/** Wrapper for `fz_new_pixmap_with_bbox()`.  */
	/**
		Create a pixmap of a given size, location and pixel format.
	
		The bounding box specifies the size of the created pixmap and
		where it will be located. The colorspace determines the number
		of components per pixel. Alpha is always present. Pixmaps are
		reference counted, so drop references using fz_drop_pixmap.
	
		colorspace: Colorspace format used for the created pixmap. The
		pixmap will keep a reference to the colorspace.
	
		bbox: Bounding box specifying location/size of created pixmap.
	
		seps: Details of separations.
	
		alpha: 0 for no alpha, 1 for alpha.
	
		Returns a pointer to the new pixmap. Throws exception on failure
		to allocate.
	*/
	FZ_FUNCTION Pixmap new_pixmap_with_bbox(Irect& bbox, const Separations& seps, int alpha);

	/** Wrapper for `fz_new_pixmap_with_bbox_and_data()`.  */
	/**
		Create a pixmap of a given size, location and pixel format,
		using the supplied data block.
	
		The bounding box specifies the size of the created pixmap and
		where it will be located. The colorspace determines the number
		of components per pixel. Alpha is always present. Pixmaps are
		reference counted, so drop references using fz_drop_pixmap.
	
		colorspace: Colorspace format used for the created pixmap. The
		pixmap will keep a reference to the colorspace.
	
		rect: Bounding box specifying location/size of created pixmap.
	
		seps: Details of separations.
	
		alpha: Number of alpha planes (0 or 1).
	
		samples: The data block to keep the samples in.
	
		Returns a pointer to the new pixmap. Throws exception on failure
		to allocate.
	*/
	FZ_FUNCTION Pixmap new_pixmap_with_bbox_and_data(Irect& rect, const Separations& seps, int alpha, unsigned char *samples);

	/** Wrapper for `fz_new_pixmap_with_data()`.  */
	/**
		Create a new pixmap, with its origin at
		(0,0) using the supplied data block.
	
		cs: The colorspace to use for the pixmap, or NULL for an alpha
		plane/mask.
	
		w: The width of the pixmap (in pixels)
	
		h: The height of the pixmap (in pixels)
	
		seps: Details of separations.
	
		alpha: 0 for no alpha, 1 for alpha.
	
		stride: The byte offset from the pixel data in a row to the
		pixel data in the next row.
	
		samples: The data block to keep the samples in.
	
		Returns a pointer to the new pixmap. Throws exception on failure to
		allocate.
	*/
	FZ_FUNCTION Pixmap new_pixmap_with_data(int w, int h, const Separations& seps, int alpha, int stride, unsigned char *samples);

	/** Wrapper for `pdf_is_tint_colorspace()`.  */
	FZ_FUNCTION int is_tint_colorspace();

	/** Constructor using raw copy of pre-existing `fz_colorspace`. */
	FZ_FUNCTION Colorspace(fz_colorspace* internal);

	/** Destructor using fz_drop_colorspace(). */
	FZ_FUNCTION ~Colorspace();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_colorspace* m_internal;
};

/** Wrapper class for struct `fz_colorspace_context`. Not copyable or assignable. */
struct ColorspaceContext
{
	/** Constructor using raw copy of pre-existing `fz_colorspace_context`. */
	FZ_FUNCTION ColorspaceContext(fz_colorspace_context* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_colorspace_context* m_internal;

	private:

	/** This class is not copyable or assignable. */
	ColorspaceContext(const ColorspaceContext& rhs);
	ColorspaceContext& operator=(const ColorspaceContext& rhs);
};

/** Wrapper class for struct `fz_compressed_buffer`. Not copyable or assignable. */
/**
	Buffers of compressed data; typically for the source data
	for images.
*/
struct CompressedBuffer
{
	/* == Methods. */

	/** Wrapper for `fz_compressed_buffer_size()`.  */
	/**
		Return the storage size used for a buffer and its data.
		Used in implementing store handling.
	
		Never throws exceptions.
	*/
	FZ_FUNCTION size_t compressed_buffer_size();

	/** Wrapper for `fz_open_compressed_buffer()`.  */
	/**
		Open a stream to read the decompressed version of a buffer.
	*/
	FZ_FUNCTION Stream open_compressed_buffer();

	/** Wrapper for `fz_open_image_decomp_stream_from_buffer()`.
	
	This method has out-params. Python/C# wrappers look like:
		`open_image_decomp_stream_from_buffer()` => `(fz_stream *, int l2factor)`
	 */
	/**
		Open a stream to read the decompressed version of a buffer,
		with optional log2 subsampling.
	
		l2factor = NULL for no subsampling, or a pointer to an integer
		containing the maximum log2 subsample factor acceptable (0 =
		none, 1 = halve dimensions, 2 = quarter dimensions etc). If
		non-NULL, then *l2factor will be updated on exit with the actual
		log2 subsample factor achieved.
	*/
	FZ_FUNCTION Stream open_image_decomp_stream_from_buffer(
			#ifdef SWIG
				int *OUTPUT
			#else
				int *l2factor
			#endif
			);

	/** Constructor using raw copy of pre-existing `fz_compressed_buffer`. */
	FZ_FUNCTION CompressedBuffer(fz_compressed_buffer* internal);

	/** Destructor using fz_drop_compressed_buffer(). */
	FZ_FUNCTION ~CompressedBuffer();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_compressed_buffer* m_internal;

	private:

	/** This class is not copyable or assignable. */
	CompressedBuffer(const CompressedBuffer& rhs);
	CompressedBuffer& operator=(const CompressedBuffer& rhs);
};

/** Wrapper class for struct `fz_compressed_image`. Not copyable or assignable. */
struct CompressedImage
{
	/* == Methods. */

	/** Wrapper for `fz_set_compressed_image_buffer()`.  */
	FZ_FUNCTION void set_compressed_image_buffer(const CompressedBuffer& buf);

	/** Constructor using raw copy of pre-existing `fz_compressed_image`. */
	FZ_FUNCTION CompressedImage(fz_compressed_image* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_compressed_image* m_internal;

	private:

	/** This class is not copyable or assignable. */
	CompressedImage(const CompressedImage& rhs);
	CompressedImage& operator=(const CompressedImage& rhs);
};

/** Wrapper class for struct `fz_compression_params`. Not copyable or assignable. */
/**
	Compression parameters used for buffers of compressed data;
	typically for the source data for images.
*/
struct CompressionParams
{
	/** Constructor using raw copy of pre-existing `fz_compression_params`. */
	FZ_FUNCTION CompressionParams(fz_compression_params* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_compression_params* m_internal;

	private:

	/** This class is not copyable or assignable. */
	CompressionParams(const CompressionParams& rhs);
	CompressionParams& operator=(const CompressionParams& rhs);
};

/** Wrapper class for struct `fz_context`. Not copyable or assignable. */
struct Context
{
	/** == Constructors. */

	/** Constructor using `fz_new_context_imp()`. */
	FZ_FUNCTION Context(const AllocContext& alloc, const LocksContext& locks, size_t max_store, const char *version);

	/** Constructor using raw copy of pre-existing `fz_context`. */
	FZ_FUNCTION Context(fz_context* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_context* m_internal;

	private:

	/** This class is not copyable or assignable. */
	Context(const Context& rhs);
	Context& operator=(const Context& rhs);
};

/** Wrapper class for struct `fz_cookie`. Not copyable or assignable. */
/**
	Provide two-way communication between application and library.
	Intended for multi-threaded applications where one thread is
	rendering pages and another thread wants to read progress
	feedback or abort a job that takes a long time to finish. The
	communication is unsynchronized without locking.

	abort: The application should set this field to 0 before
	calling fz_run_page to render a page. At any point when the
	page is being rendered the application my set this field to 1
	which will cause the rendering to finish soon. This field is
	checked periodically when the page is rendered, but exactly
	when is not known, therefore there is no upper bound on
	exactly when the rendering will abort. If the application
	did not provide a set of locks to fz_new_context, it must also
	await the completion of fz_run_page before issuing another
	call to fz_run_page. Note that once the application has set
	this field to 1 after it called fz_run_page it may not change
	the value again.

	progress: Communicates rendering progress back to the
	application and is read only. Increments as a page is being
	rendered. The value starts out at 0 and is limited to less
	than or equal to progress_max, unless progress_max is -1.

	progress_max: Communicates the known upper bound of rendering
	back to the application and is read only. The maximum value
	that the progress field may take. If there is no known upper
	bound on how long the rendering may take this value is -1 and
	progress is not limited. Note that the value of progress_max
	may change from -1 to a positive value once an upper bound is
	known, so take this into consideration when comparing the
	value of progress to that of progress_max.

	errors: count of errors during current rendering.

	incomplete: Initially should be set to 0. Will be set to
	non-zero if a TRYLATER error is thrown during rendering.
*/
struct Cookie
{
	/** Sets all fields to default values. */
	FZ_FUNCTION Cookie();

	/* == Methods. */

	/** Sets m_internal.abort to 1. */
	FZ_FUNCTION void set_abort();

	/** Increments m_internal.errors by <delta>. */
	FZ_FUNCTION void increment_errors(int delta);

	/* == Accessors to members of fz_cookie m_internal. */

	FZ_FUNCTION int abort();
	FZ_FUNCTION int progress();
	FZ_FUNCTION size_t progress_max();
	FZ_FUNCTION int errors();
	FZ_FUNCTION int incomplete();

	/** We use default destructor. */

	/* == Member data. */

	fz_cookie  m_internal; /** Wrapped data is held by value. */

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	private:

	/** This class is not copyable or assignable. */
	Cookie(const Cookie& rhs);
	Cookie& operator=(const Cookie& rhs);
};

/** Writes a Cookie's underlying fz_cookie's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const Cookie& rhs);

/** Wrapper class for struct `fz_default_colorspaces`. */
/**
	Structure to hold default colorspaces.
*/
struct DefaultColorspaces
{
	/** == Constructors. */

	/** Constructor using `fz_new_default_colorspaces()`. */
	/**
		Create a new default colorspace structure with values inherited
		from the context, and return a reference to it.
	
		These can be overridden using fz_set_default_xxxx.
	
		These should not be overridden while more than one caller has
		the reference for fear of race conditions.
	
		The caller should drop this reference once finished with it.
	*/
	FZ_FUNCTION DefaultColorspaces();

	/** Copy constructor using `fz_keep_default_colorspaces()`. */
	FZ_FUNCTION DefaultColorspaces(const DefaultColorspaces& rhs);

	/** operator= using `fz_keep_default_colorspaces()` and `fz_drop_default_colorspaces()`. */
	FZ_FUNCTION DefaultColorspaces& operator=(const DefaultColorspaces& rhs);

	/* == Methods. */

	/** Wrapper for `fz_clone_default_colorspaces()`.  */
	/**
		Returns a reference to a newly cloned default colorspaces
		structure.
	
		The new clone may safely be altered without fear of race
		conditions as the caller is the only reference holder.
	*/
	FZ_FUNCTION DefaultColorspaces clone_default_colorspaces();

	/** Wrapper for `fz_default_cmyk()`.  */
	FZ_FUNCTION Colorspace default_cmyk();

	/** Wrapper for `fz_default_gray()`.  */
	/**
		Retrieve default colorspaces (typically page local).
	
		If default_cs is non NULL, the default is retrieved from there,
		otherwise the global default is retrieved.
	
		These return borrowed references that should not be dropped,
		unless they are kept first.
	*/
	FZ_FUNCTION Colorspace default_gray();

	/** Wrapper for `fz_default_output_intent()`.  */
	FZ_FUNCTION Colorspace default_output_intent();

	/** Wrapper for `fz_default_rgb()`.  */
	FZ_FUNCTION Colorspace default_rgb();

	/** Wrapper for `fz_set_default_cmyk()`.  */
	FZ_FUNCTION void set_default_cmyk(const Colorspace& cs);

	/** Wrapper for `fz_set_default_gray()`.  */
	/**
		Set new defaults within the default colorspace structure.
	
		New references are taken to the new default, and references to
		the old defaults dropped.
	
		Never throws exceptions.
	*/
	FZ_FUNCTION void set_default_gray(const Colorspace& cs);

	/** Wrapper for `fz_set_default_output_intent()`.  */
	FZ_FUNCTION void set_default_output_intent(const Colorspace& cs);

	/** Wrapper for `fz_set_default_rgb()`.  */
	FZ_FUNCTION void set_default_rgb(const Colorspace& cs);

	/** Wrapper for `pdf_update_default_colorspaces()`.  */
	FZ_FUNCTION DefaultColorspaces update_default_colorspaces(const PdfObj& res);

	/** Constructor using raw copy of pre-existing `fz_default_colorspaces`. */
	FZ_FUNCTION DefaultColorspaces(fz_default_colorspaces* internal);

	/** Destructor using fz_drop_default_colorspaces(). */
	FZ_FUNCTION ~DefaultColorspaces();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_default_colorspaces* m_internal;
};

/** Wrapper class for struct `fz_device`. */
/**
	The different format handlers (pdf, xps etc) interpret pages to
	a device. These devices can then process the stream of calls
	they receive in various ways:
		The trace device outputs debugging information for the calls.
		The draw device will render them.
		The list device stores them in a list to play back later.
		The text device performs text extraction and searching.
		The bbox device calculates the bounding box for the page.
	Other devices can (and will) be written in the future.
*/
struct Device
{
	/** == Constructors. */

	/** Constructor using `fz_new_bbox_device()`. */
	/**
		Create a device to compute the bounding
		box of all marks on a page.
	
		The returned bounding box will be the union of all bounding
		boxes of all objects on a page.
	*/
	FZ_FUNCTION Device(Rect& rectp);

	/** Constructor using `fz_new_device_of_size()`. */
	/**
		Devices are created by calls to device implementations, for
		instance: foo_new_device(). These will be implemented by calling
		fz_new_derived_device(ctx, foo_device) where foo_device is a
		structure "derived from" fz_device, for instance
		typedef struct { fz_device base;  ...extras...} foo_device;
	*/
	FZ_FUNCTION Device(int size);

	/** Constructor using `fz_new_draw_device()`. */
	/**
		Create a device to draw on a pixmap.
	
		dest: Target pixmap for the draw device. See fz_new_pixmap*
		for how to obtain a pixmap. The pixmap is not cleared by the
		draw device, see fz_clear_pixmap* for how to clear it prior to
		calling fz_new_draw_device. Free the device by calling
		fz_drop_device.
	
		transform: Transform from user space in points to device space
		in pixels.
	*/
	FZ_FUNCTION Device(Matrix& transform, const Pixmap& dest);

	/** Constructor using `fz_new_draw_device_with_bbox()`. */
	/**
		Create a device to draw on a pixmap.
	
		dest: Target pixmap for the draw device. See fz_new_pixmap*
		for how to obtain a pixmap. The pixmap is not cleared by the
		draw device, see fz_clear_pixmap* for how to clear it prior to
		calling fz_new_draw_device. Free the device by calling
		fz_drop_device.
	
		transform: Transform from user space in points to device space
		in pixels.
	
		clip: Bounding box to restrict any marking operations of the
		draw device.
	*/
	FZ_FUNCTION Device(Matrix& transform, const Pixmap& dest, Irect& clip);

	/** Constructor using `fz_new_draw_device_with_bbox_proof()`. */
	/**
		Create a device to draw on a pixmap.
	
		dest: Target pixmap for the draw device. See fz_new_pixmap*
		for how to obtain a pixmap. The pixmap is not cleared by the
		draw device, see fz_clear_pixmap* for how to clear it prior to
		calling fz_new_draw_device. Free the device by calling
		fz_drop_device.
	
		transform: Transform from user space in points to device space
		in pixels.
	
		clip: Bounding box to restrict any marking operations of the
		draw device.
	
		proof_cs: Color space to render to prior to mapping to color
		space defined by pixmap.
	*/
	FZ_FUNCTION Device(Matrix& transform, const Pixmap& dest, Irect& clip, const Colorspace& cs);

	/** Constructor using `fz_new_draw_device_with_proof()`. */
	/**
		Create a device to draw on a pixmap.
	
		dest: Target pixmap for the draw device. See fz_new_pixmap*
		for how to obtain a pixmap. The pixmap is not cleared by the
		draw device, see fz_clear_pixmap* for how to clear it prior to
		calling fz_new_draw_device. Free the device by calling
		fz_drop_device.
	
		transform: Transform from user space in points to device space
		in pixels.
	
		proof_cs: Intermediate color space to map though when mapping to
		color space defined by pixmap.
	*/
	FZ_FUNCTION Device(Matrix& transform, const Pixmap& dest, const Colorspace& proof_cs);

	/** Constructor using `fz_new_list_device()`. */
	/**
		Create a rendering device for a display list.
	
		When the device is rendering a page it will populate the
		display list with drawing commands (text, images, etc.). The
		display list can later be reused to render a page many times
		without having to re-interpret the page from the document file
		for each rendering. Once the device is no longer needed, free
		it with fz_drop_device.
	
		list: A display list that the list device takes a reference to.
	*/
	FZ_FUNCTION Device(const DisplayList& list);

	/** Constructor using `fz_new_ocr_device()`. */
	/**
		Create a device to OCR the text on the page.
	
		Renders the page internally to a bitmap that is then OCRd. Text
		is then forwarded onto the target device.
	
		target: The target device to receive the OCRd text.
	
		ctm: The transform to apply to the mediabox to get the size for
		the rendered page image. Also used to calculate the resolution
		for the page image. In general, this will be the same as the CTM
		that you pass to fz_run_page (or fz_run_display_list) to feed
		this device.
	
		mediabox: The mediabox (in points). Combined with the CTM to get
		the bounds of the pixmap used internally for the rendered page
		image.
	
		with_list: If with_list is false, then all non-text operations
		are forwarded instantly to the target device. This results in
		the target device seeing all NON-text operations, followed by
		all the text operations (derived from OCR).
	
		If with_list is true, then all the marking operations are
		collated into a display list which is then replayed to the
		target device at the end.
	
		language: NULL (for "eng"), or a pointer to a string to describe
		the languages/scripts that should be used for OCR (e.g.
		"eng,ara").
	
		datadir: NULL (for ""), or a pointer to a path string otherwise
		provided to Tesseract in the TESSDATA_PREFIX environment variable.
	
		progress: NULL, or function to be called periodically to indicate
		progress. Return 0 to continue, or 1 to cancel. progress_arg is
		returned as the void *. The int is a value between 0 and 100 to
		indicate progress.
	
		progress_arg: A void * value to be parrotted back to the progress
		function.
	*/
	FZ_FUNCTION Device(const Device& target, Matrix& ctm, Rect& mediabox, int with_list, const char *language, const char *datadir, int (*progress)(fz_context *, void *, int ), void *progress_arg);

	/** Constructor using `fz_new_stext_device()`. */
	/**
		Create a device to extract the text on a page.
	
		Gather the text on a page into blocks and lines.
	
		The reading order is taken from the order the text is drawn in
		the source file, so may not be accurate.
	
		page: The text page to which content should be added. This will
		usually be a newly created (empty) text page, but it can be one
		containing data already (for example when merging multiple
		pages, or watermarking).
	
		options: Options to configure the stext device.
	*/
	FZ_FUNCTION Device(const StextPage& page, StextOptions& options);

	/** Constructor using `fz_new_svg_device()`. */
	/**
		Create a device that outputs (single page) SVG files to
		the given output stream.
	
		Equivalent to fz_new_svg_device_with_id passing id = NULL.
	*/
	FZ_FUNCTION Device(const Output& out, float page_width, float page_height, int text_format, int reuse_images);

	/** Constructor using `fz_new_svg_device_with_id()`. */
	/**
		Create a device that outputs (single page) SVG files to
		the given output stream.
	
		output: The output stream to send the constructed SVG page to.
	
		page_width, page_height: The page dimensions to use (in points).
	
		text_format: How to emit text. One of the following values:
			FZ_SVG_TEXT_AS_TEXT: As <text> elements with possible
			layout errors and mismatching fonts.
			FZ_SVG_TEXT_AS_PATH: As <path> elements with exact
			visual appearance.
	
		reuse_images: Share image resources using <symbol> definitions.
	
		id: ID parameter to keep generated IDs unique across SVG files.
	*/
	FZ_FUNCTION Device(const Output& out, float page_width, float page_height, int text_format, int reuse_images, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *id
			#endif
			);

	/** Constructor using `fz_new_test_device()`. */
	/**
		Create a device to test for features.
	
		Currently only tests for the presence of non-grayscale colors.
	
		is_color: Possible values returned:
			0: Definitely greyscale
			1: Probably color (all colors were grey, but there
			were images or shadings in a non grey colorspace).
			2: Definitely color
	
		threshold: The difference from grayscale that will be tolerated.
		Typical values to use are either 0 (be exact) and 0.02 (allow an
		imperceptible amount of slop).
	
		options: A set of bitfield options, from the FZ_TEST_OPT set.
	
		passthrough: A device to pass all calls through to, or NULL.
		If set, then the test device can both test and pass through to
		an underlying device (like, say, the display list device). This
		means that a display list can be created and at the end we'll
		know if it's colored or not.
	
		In the absence of a passthrough device, the device will throw
		an exception to stop page interpretation when color is found.
	*/
	FZ_FUNCTION Device(
			#ifdef SWIG
				int *OUTPUT
			#else
				int *is_color
			#endif
			, float threshold, int options, const Device& passthrough);

	/** Constructor using `fz_new_trace_device()`. */
	/**
		Create a device to print a debug trace of all device calls.
	*/
	FZ_FUNCTION Device(const Output& out);

	/** Sets m_internal = NULL. */
	FZ_FUNCTION Device();

	/** Copy constructor using `fz_keep_device()`. */
	FZ_FUNCTION Device(const Device& rhs);

	/** operator= using `fz_keep_device()` and `fz_drop_device()`. */
	FZ_FUNCTION Device& operator=(const Device& rhs);

	/* == Static methods. */

	/** Wrapper for `fz_new_xmltext_device()`.  */
	/**
		Create a device to output raw information.
	*/
	FZ_FUNCTION static Device new_xmltext_device(const Output& out);

	/** Wrapper for `fz_new_draw_device_type3()`.  */
	FZ_FUNCTION static Device new_draw_device_type3(Matrix& transform, const Pixmap& dest);

	/* == Methods. */

	/** Wrapper for `fz_begin_group()`.  */
	FZ_FUNCTION void begin_group(Rect& area, const Colorspace& cs, int isolated, int knockout, int blendmode, float alpha);

	/** Wrapper for `fz_begin_layer()`.  */
	FZ_FUNCTION void begin_layer(const char *layer_name);

	/** Wrapper for `fz_begin_mask()`.  */
	FZ_FUNCTION void begin_mask(Rect& area, int luminosity, const Colorspace& colorspace, const float *bc, ColorParams& color_params);

	/** Wrapper for `fz_begin_tile()`.  */
	FZ_FUNCTION void begin_tile(Rect& area, Rect& view, float xstep, float ystep, Matrix& ctm);

	/** Wrapper for `fz_begin_tile_id()`.  */
	FZ_FUNCTION int begin_tile_id(Rect& area, Rect& view, float xstep, float ystep, Matrix& ctm, int id);

	/** Wrapper for `fz_clip_image_mask()`.  */
	FZ_FUNCTION void clip_image_mask(const Image& image, Matrix& ctm, Rect& scissor);

	/** Wrapper for `fz_clip_path()`.  */
	FZ_FUNCTION void clip_path(const Path& path, int even_odd, Matrix& ctm, Rect& scissor);

	/** Wrapper for `fz_clip_stroke_path()`.  */
	FZ_FUNCTION void clip_stroke_path(const Path& path, const StrokeState& stroke, Matrix& ctm, Rect& scissor);

	/** Wrapper for `fz_clip_stroke_text()`.  */
	FZ_FUNCTION void clip_stroke_text(const Text& text, const StrokeState& stroke, Matrix& ctm, Rect& scissor);

	/** Wrapper for `fz_clip_text()`.  */
	FZ_FUNCTION void clip_text(const Text& text, Matrix& ctm, Rect& scissor);

	/** Wrapper for `fz_close_device()`.  */
	/**
		Signal the end of input, and flush any buffered output.
		This is NOT called implicitly on fz_drop_device. This
		may throw exceptions.
	*/
	FZ_FUNCTION void close_device();

	/** Wrapper for `fz_device_current_scissor()`.  */
	/**
		Find current scissor region as tracked by the device.
	*/
	FZ_FUNCTION Rect device_current_scissor();

	/** Wrapper for `fz_disable_device_hints()`.  */
	/**
		Disable (clear) hint bits within the hint bitfield for a device.
	*/
	FZ_FUNCTION void disable_device_hints(int hints);

	/** Wrapper for `fz_enable_device_hints()`.  */
	/**
		Enable (set) hint bits within the hint bitfield for a device.
	*/
	FZ_FUNCTION void enable_device_hints(int hints);

	/** Wrapper for `fz_end_group()`.  */
	FZ_FUNCTION void end_group();

	/** Wrapper for `fz_end_layer()`.  */
	FZ_FUNCTION void end_layer();

	/** Wrapper for `fz_end_mask()`.  */
	FZ_FUNCTION void end_mask();

	/** Wrapper for `fz_end_tile()`.  */
	FZ_FUNCTION void end_tile();

	/** Wrapper for `fz_fill_image()`.  */
	FZ_FUNCTION void fill_image(const Image& image, Matrix& ctm, float alpha, ColorParams& color_params);

	/** Wrapper for `fz_fill_image_mask()`.  */
	FZ_FUNCTION void fill_image_mask(const Image& image, Matrix& ctm, const Colorspace& colorspace, const float *color, float alpha, ColorParams& color_params);

	/** Wrapper for `fz_fill_path()`.  */
	/**
		Device calls; graphics primitives and containers.
	*/
	FZ_FUNCTION void fill_path(const Path& path, int even_odd, Matrix& ctm, const Colorspace& colorspace, const float *color, float alpha, ColorParams& color_params);

	/** Wrapper for `fz_fill_shade()`.  */
	FZ_FUNCTION void fill_shade(const Shade& shade, Matrix& ctm, float alpha, ColorParams& color_params);

	/** Wrapper for `fz_fill_text()`.  */
	FZ_FUNCTION void fill_text(const Text& text, Matrix& ctm, const Colorspace& colorspace, const float *color, float alpha, ColorParams& color_params);

	/** Wrapper for `fz_ignore_text()`.  */
	FZ_FUNCTION void ignore_text(const Text& text, Matrix& ctm);

	/** Wrapper for `fz_new_ocr_device()`.  */
	/**
		Create a device to OCR the text on the page.
	
		Renders the page internally to a bitmap that is then OCRd. Text
		is then forwarded onto the target device.
	
		target: The target device to receive the OCRd text.
	
		ctm: The transform to apply to the mediabox to get the size for
		the rendered page image. Also used to calculate the resolution
		for the page image. In general, this will be the same as the CTM
		that you pass to fz_run_page (or fz_run_display_list) to feed
		this device.
	
		mediabox: The mediabox (in points). Combined with the CTM to get
		the bounds of the pixmap used internally for the rendered page
		image.
	
		with_list: If with_list is false, then all non-text operations
		are forwarded instantly to the target device. This results in
		the target device seeing all NON-text operations, followed by
		all the text operations (derived from OCR).
	
		If with_list is true, then all the marking operations are
		collated into a display list which is then replayed to the
		target device at the end.
	
		language: NULL (for "eng"), or a pointer to a string to describe
		the languages/scripts that should be used for OCR (e.g.
		"eng,ara").
	
		datadir: NULL (for ""), or a pointer to a path string otherwise
		provided to Tesseract in the TESSDATA_PREFIX environment variable.
	
		progress: NULL, or function to be called periodically to indicate
		progress. Return 0 to continue, or 1 to cancel. progress_arg is
		returned as the void *. The int is a value between 0 and 100 to
		indicate progress.
	
		progress_arg: A void * value to be parrotted back to the progress
		function.
	*/
	FZ_FUNCTION Device new_ocr_device(Matrix& ctm, Rect& mediabox, int with_list, const char *language, const char *datadir, int (*progress)(fz_context *, void *, int ), void *progress_arg);

	/** Wrapper for `fz_pop_clip()`.  */
	FZ_FUNCTION void pop_clip();

	/** Wrapper for `fz_render_flags()`.  */
	FZ_FUNCTION void render_flags(int set, int clear);

	/** Wrapper for `fz_render_t3_glyph_direct()`.  */
	/**
		Nasty PDF interpreter specific hernia, required to allow the
		interpreter to replay glyphs from a type3 font directly into
		the target device.
	
		This is only used in exceptional circumstances (such as type3
		glyphs that inherit current graphics state, or nested type3
		glyphs).
	*/
	FZ_FUNCTION void render_t3_glyph_direct(const Font& font, int gid, Matrix& trm, void *gstate, const DefaultColorspaces& def_cs);

	/** Wrapper for `fz_set_default_colorspaces()`.  */
	FZ_FUNCTION void set_default_colorspaces(const DefaultColorspaces& default_cs);

	/** Wrapper for `fz_stroke_path()`.  */
	FZ_FUNCTION void stroke_path(const Path& path, const StrokeState& stroke, Matrix& ctm, const Colorspace& colorspace, const float *color, float alpha, ColorParams& color_params);

	/** Wrapper for `fz_stroke_text()`.  */
	FZ_FUNCTION void stroke_text(const Text& text, const StrokeState& stroke, Matrix& ctm, const Colorspace& colorspace, const float *color, float alpha, ColorParams& color_params);

	/** Wrapper for `pdf_new_run_processor()`.  */
	FZ_FUNCTION PdfProcessor new_run_processor(Matrix& ctm, const char *usage, const PdfGstate& gstate, const DefaultColorspaces& default_cs, Cookie& cookie);

	/** Constructor using raw copy of pre-existing `fz_device`. */
	FZ_FUNCTION Device(fz_device* internal);

	/** Destructor using fz_drop_device(). */
	FZ_FUNCTION ~Device();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_device* m_internal;
};

/** Wrapper class for struct fz_device with virtual fns for each fnptr; this is for use as a SWIG Director class. */
struct Device2 : Device
{

	/** == Constructor. */
	FZ_FUNCTION Device2();

	/** These methods set the function pointers in *m_internal
	to point to internal callbacks that call our virtual methods. */
	FZ_FUNCTION void use_virtual_close_device( bool use=true);
	FZ_FUNCTION void use_virtual_drop_device( bool use=true);
	FZ_FUNCTION void use_virtual_fill_path( bool use=true);
	FZ_FUNCTION void use_virtual_stroke_path( bool use=true);
	FZ_FUNCTION void use_virtual_clip_path( bool use=true);
	FZ_FUNCTION void use_virtual_clip_stroke_path( bool use=true);
	FZ_FUNCTION void use_virtual_fill_text( bool use=true);
	FZ_FUNCTION void use_virtual_stroke_text( bool use=true);
	FZ_FUNCTION void use_virtual_clip_text( bool use=true);
	FZ_FUNCTION void use_virtual_clip_stroke_text( bool use=true);
	FZ_FUNCTION void use_virtual_ignore_text( bool use=true);
	FZ_FUNCTION void use_virtual_fill_shade( bool use=true);
	FZ_FUNCTION void use_virtual_fill_image( bool use=true);
	FZ_FUNCTION void use_virtual_fill_image_mask( bool use=true);
	FZ_FUNCTION void use_virtual_clip_image_mask( bool use=true);
	FZ_FUNCTION void use_virtual_pop_clip( bool use=true);
	FZ_FUNCTION void use_virtual_begin_mask( bool use=true);
	FZ_FUNCTION void use_virtual_end_mask( bool use=true);
	FZ_FUNCTION void use_virtual_begin_group( bool use=true);
	FZ_FUNCTION void use_virtual_end_group( bool use=true);
	FZ_FUNCTION void use_virtual_begin_tile( bool use=true);
	FZ_FUNCTION void use_virtual_end_tile( bool use=true);
	FZ_FUNCTION void use_virtual_render_flags( bool use=true);
	FZ_FUNCTION void use_virtual_set_default_colorspaces( bool use=true);
	FZ_FUNCTION void use_virtual_begin_layer( bool use=true);
	FZ_FUNCTION void use_virtual_end_layer( bool use=true);

	/** Default virtual method implementations; these all throw an exception. */
	FZ_FUNCTION virtual void close_device();
	FZ_FUNCTION virtual void drop_device();
	FZ_FUNCTION virtual void fill_path(const struct fz_path *arg_2, int arg_3, fz_matrix arg_4, struct fz_colorspace *arg_5, const float *arg_6, float arg_7, fz_color_params arg_8);
	FZ_FUNCTION virtual void stroke_path(const struct fz_path *arg_2, const fz_stroke_state *arg_3, fz_matrix arg_4, struct fz_colorspace *arg_5, const float *arg_6, float arg_7, fz_color_params arg_8);
	FZ_FUNCTION virtual void clip_path(const struct fz_path *arg_2, int arg_3, fz_matrix arg_4, fz_rect arg_5);
	FZ_FUNCTION virtual void clip_stroke_path(const struct fz_path *arg_2, const fz_stroke_state *arg_3, fz_matrix arg_4, fz_rect arg_5);
	FZ_FUNCTION virtual void fill_text(const fz_text *arg_2, fz_matrix arg_3, struct fz_colorspace *arg_4, const float *arg_5, float arg_6, fz_color_params arg_7);
	FZ_FUNCTION virtual void stroke_text(const fz_text *arg_2, const fz_stroke_state *arg_3, fz_matrix arg_4, struct fz_colorspace *arg_5, const float *arg_6, float arg_7, fz_color_params arg_8);
	FZ_FUNCTION virtual void clip_text(const fz_text *arg_2, fz_matrix arg_3, fz_rect arg_4);
	FZ_FUNCTION virtual void clip_stroke_text(const fz_text *arg_2, const fz_stroke_state *arg_3, fz_matrix arg_4, fz_rect arg_5);
	FZ_FUNCTION virtual void ignore_text(const fz_text *arg_2, fz_matrix arg_3);
	FZ_FUNCTION virtual void fill_shade(fz_shade *arg_2, fz_matrix arg_3, float arg_4, fz_color_params arg_5);
	FZ_FUNCTION virtual void fill_image(struct fz_image *arg_2, fz_matrix arg_3, float arg_4, fz_color_params arg_5);
	FZ_FUNCTION virtual void fill_image_mask(struct fz_image *arg_2, fz_matrix arg_3, struct fz_colorspace *arg_4, const float *arg_5, float arg_6, fz_color_params arg_7);
	FZ_FUNCTION virtual void clip_image_mask(struct fz_image *arg_2, fz_matrix arg_3, fz_rect arg_4);
	FZ_FUNCTION virtual void pop_clip();
	FZ_FUNCTION virtual void begin_mask(fz_rect arg_2, int arg_3, struct fz_colorspace *arg_4, const float *arg_5, fz_color_params arg_6);
	FZ_FUNCTION virtual void end_mask();
	FZ_FUNCTION virtual void begin_group(fz_rect arg_2, struct fz_colorspace *arg_3, int arg_4, int arg_5, int arg_6, float arg_7);
	FZ_FUNCTION virtual void end_group();
	FZ_FUNCTION virtual int begin_tile(fz_rect arg_2, fz_rect arg_3, float arg_4, float arg_5, fz_matrix arg_6, int arg_7);
	FZ_FUNCTION virtual void end_tile();
	FZ_FUNCTION virtual void render_flags(int arg_2, int arg_3);
	FZ_FUNCTION virtual void set_default_colorspaces(fz_default_colorspaces *arg_2);
	FZ_FUNCTION virtual void begin_layer(const char *arg_2);
	FZ_FUNCTION virtual void end_layer();
};

/** Wrapper class for struct `fz_device_container_stack`. Not copyable or assignable. */
/**
	Devices can keep track of containers (clips/masks/groups/tiles)
	as they go to save callers having to do it.
*/
struct DeviceContainerStack
{
	/** Constructor using raw copy of pre-existing `fz_device_container_stack`. */
	FZ_FUNCTION DeviceContainerStack(fz_device_container_stack* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_device_container_stack* m_internal;

	private:

	/** This class is not copyable or assignable. */
	DeviceContainerStack(const DeviceContainerStack& rhs);
	DeviceContainerStack& operator=(const DeviceContainerStack& rhs);
};

/** Wrapper class for struct `fz_display_list`. */
/**
	fz_display_list is a list containing drawing commands (text,
	images, etc.). The intent is two-fold: as a caching-mechanism
	to reduce parsing of a page, and to be used as a data
	structure in multi-threading where one thread parses the page
	and another renders pages.

	Create a display list with fz_new_display_list, hand it over to
	fz_new_list_device to have it populated, and later replay the
	list (once or many times) by calling fz_run_display_list. When
	the list is no longer needed drop it with fz_drop_display_list.
*/
struct DisplayList
{
	/** == Constructors. */

	/** Constructor using `fz_new_display_list()`. */
	/**
		Create an empty display list.
	
		A display list contains drawing commands (text, images, etc.).
		Use fz_new_list_device for populating the list.
	
		mediabox: Bounds of the page (in points) represented by the
		display list.
	*/
	FZ_FUNCTION DisplayList(Rect& mediabox);

	/** Constructor using `fz_new_display_list_from_page()`. */
	/**
		Create a display list.
	
		Ownership of the display list is returned to the caller.
	*/
	FZ_FUNCTION DisplayList(const Page& page);

	/** Constructor using `fz_new_display_list_from_page_number()`. */
	FZ_FUNCTION DisplayList(const Document& doc, int number);

	/** Constructor using `fz_new_display_list_from_svg()`. */
	/**
		Parse an SVG document into a display-list.
	*/
	FZ_FUNCTION DisplayList(const Buffer& buf, const char *base_uri, const Archive& zip, 
			#ifdef SWIG
				float *OUTPUT
			#else
				float *w
			#endif
			, 
			#ifdef SWIG
				float *OUTPUT
			#else
				float *h
			#endif
			);

	/** Constructor using `fz_new_display_list_from_svg_xml()`. */
	/**
		Parse an SVG document into a display-list.
	*/
	FZ_FUNCTION DisplayList(const XmlDoc& xmldoc, const Xml& xml, const char *base_uri, const Archive& zip, 
			#ifdef SWIG
				float *OUTPUT
			#else
				float *w
			#endif
			, 
			#ifdef SWIG
				float *OUTPUT
			#else
				float *h
			#endif
			);

	/** Copy constructor using `fz_keep_display_list()`. */
	FZ_FUNCTION DisplayList(const DisplayList& rhs);

	/** operator= using `fz_keep_display_list()` and `fz_drop_display_list()`. */
	FZ_FUNCTION DisplayList& operator=(const DisplayList& rhs);

	/* == Static methods. */

	/** Wrapper for `fz_new_display_list_from_page_contents()`.  */
	/**
		Create a display list from page contents (no annotations).
	
		Ownership of the display list is returned to the caller.
	*/
	FZ_FUNCTION static DisplayList new_display_list_from_page_contents(const Page& page);

	/* == Methods. */

	/** Wrapper for `fz_bound_display_list()`.  */
	/**
		Return the bounding box of the page recorded in a display list.
	*/
	FZ_FUNCTION Rect bound_display_list();

	/** Wrapper for `fz_display_list_is_empty()`.  */
	/**
		Check for a display list being empty
	
		list: The list to check.
	
		Returns true if empty, false otherwise.
	*/
	FZ_FUNCTION int display_list_is_empty();

	/** Wrapper for `fz_new_buffer_from_display_list()`.  */
	FZ_FUNCTION Buffer new_buffer_from_display_list(StextOptions& options);

	/** Wrapper for `fz_new_list_device()`.  */
	/**
		Create a rendering device for a display list.
	
		When the device is rendering a page it will populate the
		display list with drawing commands (text, images, etc.). The
		display list can later be reused to render a page many times
		without having to re-interpret the page from the document file
		for each rendering. Once the device is no longer needed, free
		it with fz_drop_device.
	
		list: A display list that the list device takes a reference to.
	*/
	FZ_FUNCTION Device new_list_device();

	/** Wrapper for `fz_new_pixmap_from_display_list()`.  */
	/**
		Render the page to a pixmap using the transform and colorspace.
	
		Ownership of the pixmap is returned to the caller.
	*/
	FZ_FUNCTION Pixmap new_pixmap_from_display_list(Matrix& ctm, const Colorspace& cs, int alpha);

	/** Wrapper for `fz_new_pixmap_from_display_list_with_separations()`.  */
	/**
		Render the page contents with control over spot colors.
	
		Ownership of the pixmap is returned to the caller.
	*/
	FZ_FUNCTION Pixmap new_pixmap_from_display_list_with_separations(Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha);

	/** Wrapper for `fz_run_display_list()`.  */
	/**
		(Re)-run a display list through a device.
	
		list: A display list, created by fz_new_display_list and
		populated with objects from a page by running fz_run_page on a
		device obtained from fz_new_list_device.
	
		ctm: Transform to apply to display list contents. May include
		for example scaling and rotation, see fz_scale, fz_rotate and
		fz_concat. Set to fz_identity if no transformation is desired.
	
		scissor: Only the part of the contents of the display list
		visible within this area will be considered when the list is
		run through the device. This does not imply for tile objects
		contained in the display list.
	
		cookie: Communication mechanism between caller and library
		running the page. Intended for multi-threaded applications,
		while single-threaded applications set cookie to NULL. The
		caller may abort an ongoing page run. Cookie also communicates
		progress information back to the caller. The fields inside
		cookie are continually updated while the page is being run.
	*/
	FZ_FUNCTION void run_display_list(const Device& dev, Matrix& ctm, Rect& scissor, Cookie& cookie);

	/** Wrapper for `fz_search_display_list()`.
	
	This method has out-params. Python/C# wrappers look like:
		`search_display_list(const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
	 */
	FZ_FUNCTION int search_display_list(const char *needle, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *hit_mark
			#endif
			, Quad& hit_bbox, int hit_max);

	/** Constructor using raw copy of pre-existing `fz_display_list`. */
	FZ_FUNCTION DisplayList(fz_display_list* internal);

	/** Destructor using fz_drop_display_list(). */
	FZ_FUNCTION ~DisplayList();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_display_list* m_internal;
};

/** Wrapper class for struct `fz_document`. */
struct Document
{
	/** == Constructors. */

	/** Constructor using `fz_open_accelerated_document()`. */
	/**
		Open a document file and read its basic structure so pages and
		objects can be located. MuPDF will try to repair broken
		documents (without actually changing the file contents).
	
		The returned fz_document is used when calling most other
		document related functions.
	
		filename: a path to a file as it would be given to open(2).
	*/
	FZ_FUNCTION Document(const char *filename, const char *accel);

	/** Constructor using `fz_open_accelerated_document_with_stream()`. */
	/**
		Open a document using the specified stream object rather than
		opening a file on disk.
	
		magic: a string used to detect document type; either a file name
		or mime-type.
	*/
	FZ_FUNCTION Document(const char *magic, const Stream& stream, const Stream& accel);

	/** Constructor using `fz_open_document()`. */
	/**
		Open a document file and read its basic structure so pages and
		objects can be located. MuPDF will try to repair broken
		documents (without actually changing the file contents).
	
		The returned fz_document is used when calling most other
		document related functions.
	
		filename: a path to a file as it would be given to open(2).
	*/
	FZ_FUNCTION Document(const char *filename);

	/** Constructor using `fz_open_document_with_stream()`. */
	/**
		Open a document using the specified stream object rather than
		opening a file on disk.
	
		magic: a string used to detect document type; either a file name
		or mime-type.
	*/
	FZ_FUNCTION Document(const char *magic, const Stream& stream);

	/** Return Document for pdfdocument.m_internal.super. */
	FZ_FUNCTION Document(PdfDocument& pdfdocument);

	/** Copy constructor using `fz_keep_document()`. */
	FZ_FUNCTION Document(const Document& rhs);

	/** operator= using `fz_keep_document()` and `fz_drop_document()`. */
	FZ_FUNCTION Document& operator=(const Document& rhs);

	/* == Static methods. */

	/** Wrapper for `fz_new_xhtml_document_from_document()`.  */
	/**
		Use text extraction to convert the input document into XHTML,
		then open the result as a new document that can be reflowed.
	*/
	FZ_FUNCTION static Document new_xhtml_document_from_document(const Document& old_doc, StextOptions& opts);

	/* == Methods. */

	/** Wrapper for `fz_authenticate_password()`.  */
	/**
		Test if the given password can decrypt the document.
	
		password: The password string to be checked. Some document
		specifications do not specify any particular text encoding, so
		neither do we.
	
		Returns 0 for failure to authenticate, non-zero for success.
	
		For PDF documents, further information can be given by examining
		the bits in the return code.
	
			Bit 0 => No password required
			Bit 1 => User password authenticated
			Bit 2 => Owner password authenticated
	*/
	FZ_FUNCTION int authenticate_password(const char *password);

	/** Wrapper for `fz_clamp_location()`.  */
	/**
		Clamps a location into valid chapter/page range. (First clamps
		the chapter into range, then the page into range).
	*/
	FZ_FUNCTION Location clamp_location(Location& loc);

	/** Wrapper for `fz_count_chapter_pages()`.  */
	/**
		Return the number of pages in a chapter.
		May return 0.
	*/
	FZ_FUNCTION int count_chapter_pages(int chapter);

	/** Wrapper for `fz_count_chapters()`.  */
	/**
		Return the number of chapters in the document.
		At least 1.
	*/
	FZ_FUNCTION int count_chapters();

	/** Wrapper for `fz_count_pages()`.  */
	/**
		Return the number of pages in document
	
		May return 0 for documents with no pages.
	*/
	FZ_FUNCTION int count_pages();

	/** Wrapper for `fz_document_output_intent()`.  */
	/**
		Find the output intent colorspace if the document has defined
		one.
	
		Returns a borrowed reference that should not be dropped, unless
		it is kept first.
	*/
	FZ_FUNCTION Colorspace document_output_intent();

	/** Wrapper for `fz_document_supports_accelerator()`.  */
	/**
		Query if the document supports the saving of accelerator data.
	*/
	FZ_FUNCTION int document_supports_accelerator();

	/** Wrapper for `fz_format_link_uri()`.  */
	/**
		Format an internal link to a page number, location, and possible viewing parameters,
		suitable for use with fz_create_link.
	
		Returns a newly allocated string that the caller must free.
	*/
	FZ_FUNCTION char *format_link_uri(const LinkDest& dest);

	/** Wrapper for `fz_has_permission()`.  */
	/**
		Check permission flags on document.
	*/
	FZ_FUNCTION int has_permission(fz_permission p);

	/** Wrapper for `fz_is_document_reflowable()`.  */
	/**
		Is the document reflowable.
	
		Returns 1 to indicate reflowable documents, otherwise 0.
	*/
	FZ_FUNCTION int is_document_reflowable();

	/** Wrapper for `fz_last_page()`.  */
	/**
		Function to get the location for the last page in the document.
		Using this can be far more efficient in some cases than calling
		fz_count_pages and using the page number.
	*/
	FZ_FUNCTION Location last_page();

	/** Wrapper for `fz_layout_document()`.  */
	/**
		Layout reflowable document types.
	
		w, h: Page size in points.
		em: Default font size in points.
	*/
	FZ_FUNCTION void layout_document(float w, float h, float em);

	/** Wrapper for `fz_load_chapter_page()`.  */
	/**
		Load a page.
	
		After fz_load_page is it possible to retrieve the size of the
		page using fz_bound_page, or to render the page using
		fz_run_page_*. Free the page by calling fz_drop_page.
	
		chapter: chapter number, 0 is the first chapter of the document.
		number: page number, 0 is the first page of the chapter.
	*/
	FZ_FUNCTION Page load_chapter_page(int chapter, int page);

	/** Wrapper for `fz_load_outline()`.  */
	/**
		Load the hierarchical document outline.
	
		Should be freed by fz_drop_outline.
	*/
	FZ_FUNCTION Outline load_outline();

	/** Wrapper for `fz_load_page()`.  */
	/**
		Load a given page number from a document. This may be much less
		efficient than loading by location (chapter+page) for some
		document types.
	*/
	FZ_FUNCTION Page load_page(int number);

	/** Wrapper for `fz_location_from_page_number()`.  */
	/**
		Converts from page number to chapter+page. This may cause many
		chapters to be laid out in order to calculate the number of
		pages within those chapters.
	*/
	FZ_FUNCTION Location location_from_page_number(int number);

	/** Wrapper for `fz_lookup_bookmark()`.  */
	/**
		Find a bookmark and return its page number.
	*/
	FZ_FUNCTION Location lookup_bookmark(fz_bookmark mark);

	/** Wrapper for `fz_make_bookmark()`.  */
	/**
		Create a bookmark for the given page, which can be used to find
		the same location after the document has been laid out with
		different parameters.
	*/
	FZ_FUNCTION fz_bookmark make_bookmark(Location& loc);

	/** Wrapper for `fz_needs_password()`.  */
	/**
		Check if a document is encrypted with a
		non-blank password.
	*/
	FZ_FUNCTION int needs_password();

	/** Wrapper for `fz_new_buffer_from_page_number()`.  */
	FZ_FUNCTION Buffer new_buffer_from_page_number(int number, StextOptions& options);

	/** Wrapper for `fz_new_display_list_from_page_number()`.  */
	FZ_FUNCTION DisplayList new_display_list_from_page_number(int number);

	/** Wrapper for `fz_new_pixmap_from_page_number()`.  */
	FZ_FUNCTION Pixmap new_pixmap_from_page_number(int number, Matrix& ctm, const Colorspace& cs, int alpha);

	/** Wrapper for `fz_new_pixmap_from_page_number_with_separations()`.  */
	FZ_FUNCTION Pixmap new_pixmap_from_page_number_with_separations(int number, Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha);

	/** Wrapper for `fz_new_xhtml_document_from_document()`.  */
	/**
		Use text extraction to convert the input document into XHTML,
		then open the result as a new document that can be reflowed.
	*/
	FZ_FUNCTION Document new_xhtml_document_from_document(StextOptions& opts);

	/** Wrapper for `fz_next_page()`.  */
	/**
		Function to get the location of the next page (allowing for the
		end of chapters etc). If at the end of the document, returns the
		current location.
	*/
	FZ_FUNCTION Location next_page(Location& loc);

	/** Wrapper for `fz_open_reflowed_document()`.  */
	FZ_FUNCTION Document open_reflowed_document(StextOptions& opts);

	/** Wrapper for `fz_output_accelerator()`.  */
	/**
		Output accelerator data for the document to a given output
		stream.
	*/
	FZ_FUNCTION void output_accelerator(const Output& accel);

	/** Wrapper for `fz_page_number_from_location()`.  */
	/**
		Converts from chapter+page to page number. This may cause many
		chapters to be laid out in order to calculate the number of
		pages within those chapters.
	*/
	FZ_FUNCTION int page_number_from_location(Location& loc);

	/** Wrapper for `fz_previous_page()`.  */
	/**
		Function to get the location of the previous page (allowing for
		the end of chapters etc). If already at the start of the
		document, returns the current page.
	*/
	FZ_FUNCTION Location previous_page(Location& loc);

	/** Wrapper for `fz_process_opened_pages()`.  */
	/**
		Iterates over all opened pages of the document, calling the
		provided callback for each page for processing. If the callback
		returns non-NULL then the iteration stops and that value is returned
		to the called of fz_process_opened_pages().
	
		The state pointer provided to fz_process_opened_pages() is
		passed on to the callback but is owned by the caller.
	
		Returns the first non-NULL value returned by the callback,
		or NULL if the callback returned NULL for all opened pages.
	*/
	FZ_FUNCTION void *process_opened_pages(fz_process_opened_page_fn *process_openend_page, void *state);

	/** Wrapper for `fz_resolve_link()`.
	
	This method has out-params. Python/C# wrappers look like:
		`resolve_link(const char *uri)` => `(fz_location, float xp, float yp)`
	 */
	/**
		Resolve an internal link to a page number.
	
		xp, yp: Pointer to store coordinate of destination on the page.
	
		Returns (-1,-1) if the URI cannot be resolved.
	*/
	FZ_FUNCTION Location resolve_link(const char *uri, 
			#ifdef SWIG
				float *OUTPUT
			#else
				float *xp
			#endif
			, 
			#ifdef SWIG
				float *OUTPUT
			#else
				float *yp
			#endif
			);

	/** Wrapper for `fz_save_accelerator()`.  */
	/**
		Save accelerator data for the document to a given file.
	*/
	FZ_FUNCTION void save_accelerator(const char *accel);

	/** Wrapper for `fz_search_chapter_page_number()`.
	
	This method has out-params. Python/C# wrappers look like:
		`search_chapter_page_number(int chapter, int page, const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
	 */
	FZ_FUNCTION int search_chapter_page_number(int chapter, int page, const char *needle, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *hit_mark
			#endif
			, Quad& hit_bbox, int hit_max);

	/** Wrapper for `fz_search_page_number()`.
	
	This method has out-params. Python/C# wrappers look like:
		`search_page_number(int number, const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
	 */
	FZ_FUNCTION int search_page_number(int number, const char *needle, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *hit_mark
			#endif
			, Quad& hit_bbox, int hit_max);

	/** Wrapper for `fz_set_metadata()`.  */
	FZ_FUNCTION void set_metadata(const char *key, const char *value);

	/** Wrapper for `pdf_count_pages_imp()`.  */
	FZ_FUNCTION int count_pages_imp(int chapter);

	/** Wrapper for `pdf_document_from_fz_document()`.  */
	FZ_FUNCTION PdfDocument document_from_fz_document();

	/** Wrapper for `pdf_load_page_imp()`.  */
	FZ_FUNCTION Page load_page_imp(int chapter, int number);

	/** Wrapper for `pdf_specifics()`.  */
	FZ_FUNCTION PdfDocument specifics();

	/** Wrapper for fz_lookup_metadata() that returns a std::string and sets
	*o_out to length of string plus one. If <key> is not found, returns empty
	string with *o_out=-1. <o_out> can be NULL if caller is not interested in
	error information. */
	FZ_FUNCTION std::string lookup_metadata(const char* key, int* o_out=NULL);

	/** Constructor using raw copy of pre-existing `fz_document`. */
	FZ_FUNCTION Document(fz_document* internal);

	/** Destructor using fz_drop_document(). */
	FZ_FUNCTION ~Document();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_document* m_internal;
};

/** Wrapper class for struct `fz_document_handler`. Not copyable or assignable. */
struct DocumentHandler
{
	/* == Methods. */

	/** Wrapper for `fz_register_document_handler()`.  */
	/**
		Register a handler for a document type.
	
		handler: The handler to register.
	*/
	FZ_FUNCTION void register_document_handler();

	/** Constructor using raw copy of pre-existing `fz_document_handler`. */
	FZ_FUNCTION DocumentHandler(fz_document_handler* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_document_handler* m_internal;

	private:

	/** This class is not copyable or assignable. */
	DocumentHandler(const DocumentHandler& rhs);
	DocumentHandler& operator=(const DocumentHandler& rhs);
};

/** Wrapper class for struct `fz_document_handler_context`. Not copyable or assignable. */
struct DocumentHandlerContext
{
	/** Constructor using raw copy of pre-existing `fz_document_handler_context`. */
	FZ_FUNCTION DocumentHandlerContext(fz_document_handler_context* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_document_handler_context* m_internal;

	private:

	/** This class is not copyable or assignable. */
	DocumentHandlerContext(const DocumentHandlerContext& rhs);
	DocumentHandlerContext& operator=(const DocumentHandlerContext& rhs);
};

/** Wrapper class for struct `fz_document_writer`. Not copyable or assignable. */
struct DocumentWriter
{
	/* Used for constructor that wraps fz_ functions taking (const char *path, const char *options). */
	enum PathType
	{
		PathType_CBZ,
		PathType_DOCX,
		PathType_ODT,
		PathType_PAM_PIXMAP,
		PathType_PBM_PIXMAP,
		PathType_PCL,
		PathType_PCLM,
		PathType_PDF,
		PathType_PDFOCR,
		PathType_PGM_PIXMAP,
		PathType_PKM_PIXMAP,
		PathType_PNG_PIXMAP,
		PathType_PNM_PIXMAP,
		PathType_PPM_PIXMAP,
		PathType_PS,
		PathType_PWG,
		PathType_SVG,
	};

	/* Used for constructor that wraps fz_ functions taking (Output& out, const char *options). */
	enum OutputType
	{
		OutputType_CBZ,
		OutputType_DOCX,
		OutputType_ODT,
		OutputType_PCL,
		OutputType_PCLM,
		OutputType_PDF,
		OutputType_PDFOCR,
		OutputType_PS,
		OutputType_PWG,
	};

	/* Used for constructor that wraps fz_ functions taking (const char *format, const char *path, const char *options). */
	enum FormatPathType
	{
		FormatPathType_DOCUMENT,
		FormatPathType_TEXT,
	};

	/** == Constructors. */

	/** Constructor using `fz_new_document_writer_of_size()`. */
	/**
		Internal function to allocate a
		block for a derived document_writer structure, with the base
		structure's function pointers populated correctly, and the extra
		space zero initialised.
	*/
	FZ_FUNCTION DocumentWriter(size_t size, fz_document_writer_begin_page_fn *begin_page, fz_document_writer_end_page_fn *end_page, fz_document_writer_close_writer_fn *close, fz_document_writer_drop_writer_fn *drop);

	/** Constructor using `fz_new_pixmap_writer()`. */
	FZ_FUNCTION DocumentWriter(const char *path, const char *options, const char *default_path, int n, void (*save)(fz_context *, fz_pixmap *, const char *));

	/** Constructor using one of:
		fz_new_cbz_writer()
		fz_new_docx_writer()
		fz_new_odt_writer()
		fz_new_pam_pixmap_writer()
		fz_new_pbm_pixmap_writer()
		fz_new_pcl_writer()
		fz_new_pclm_writer()
		fz_new_pdf_writer()
		fz_new_pdfocr_writer()
		fz_new_pgm_pixmap_writer()
		fz_new_pkm_pixmap_writer()
		fz_new_png_pixmap_writer()
		fz_new_pnm_pixmap_writer()
		fz_new_ppm_pixmap_writer()
		fz_new_ps_writer()
		fz_new_pwg_writer()
		fz_new_svg_writer()
	*/
	FZ_FUNCTION DocumentWriter(const char *path, const char *options, PathType path_type);

	/** Constructor using one of:
		fz_new_cbz_writer_with_output()
		fz_new_docx_writer_with_output()
		fz_new_odt_writer_with_output()
		fz_new_pcl_writer_with_output()
		fz_new_pclm_writer_with_output()
		fz_new_pdf_writer_with_output()
		fz_new_pdfocr_writer_with_output()
		fz_new_ps_writer_with_output()
		fz_new_pwg_writer_with_output()
	
	This constructor takes ownership of <out> -
	out.m_internal is set to NULL after this constructor
	returns so <out> must not be used again.
	*/
	FZ_FUNCTION DocumentWriter(Output& out, const char *options, OutputType output_type);

	/** Constructor using one of:
		fz_new_document_writer()
		fz_new_text_writer()
	*/
	FZ_FUNCTION DocumentWriter(const char *format, const char *path, const char *options, FormatPathType format_path_type);

	/** Constructor using fz_new_document_writer_with_output().
	
	This constructor takes ownership of <out> -
	out.m_internal is set to NULL after this constructor
	returns so <out> must not be used again.
	*/
	FZ_FUNCTION DocumentWriter(Output& out, const char *format, const char *options);

	/** Constructor using fz_new_text_writer_with_output().
	
	This constructor takes ownership of <out> -
	out.m_internal is set to NULL after this constructor
	returns so <out> must not be used again.
	*/
	FZ_FUNCTION DocumentWriter(const char *format, Output& out, const char *options);

	/* == Methods. */

	/** Wrapper for `fz_close_document_writer()`.  */
	/**
		Called to end the process of writing
		pages to a document.
	
		This writes any file level trailers required. After this
		completes successfully the file is up to date and complete.
	*/
	FZ_FUNCTION void close_document_writer();

	/** Wrapper for `fz_end_page()`.  */
	/**
		Called to end the process of writing a page to a
		document.
	*/
	FZ_FUNCTION void end_page();

	/** Wrapper for `fz_pdfocr_writer_set_progress()`.  */
	FZ_FUNCTION void pdfocr_writer_set_progress(fz_pdfocr_progress_fn *progress, void *arg_2);

	/** Wrapper for `fz_write_document()`.  */
	/**
		Convenience function to feed all the pages of a document to
		fz_begin_page/fz_run_page/fz_end_page.
	*/
	FZ_FUNCTION void write_document(const Document& doc);

	/*
	Custom wrapper for fz_begin_page().
	
	Called to start the process of writing a page to
	a document.
	
	mediabox: page size rectangle in points.
	
	Returns a Device to write page contents to.
	*/
	FZ_FUNCTION Device begin_page(Rect& mediabox);

	/** Constructor using raw copy of pre-existing `fz_document_writer`. */
	FZ_FUNCTION DocumentWriter(fz_document_writer* internal);

	/** Destructor using fz_drop_document_writer(). */
	FZ_FUNCTION ~DocumentWriter();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_document_writer* m_internal;

	private:

	/** This class is not copyable or assignable. */
	DocumentWriter(const DocumentWriter& rhs);
	DocumentWriter& operator=(const DocumentWriter& rhs);
};

/** Wrapper class for struct `fz_draw_options`. Not copyable or assignable. */
/**
	struct fz_draw_options: Options for creating a pixmap and draw
	device.
*/
struct DrawOptions
{
	/** == Constructors. */

	/** Constructor using `fz_parse_draw_options()`. */
	/**
		Parse draw device options from a comma separated key-value string.
	*/
	FZ_FUNCTION DrawOptions(DrawOptions& options, const char *string);

	/** Constructor using raw copy of pre-existing `fz_draw_options`. */
	FZ_FUNCTION DrawOptions(const fz_draw_options* internal);

	/** Constructor using raw copy of pre-existing `fz_draw_options`. */
	FZ_FUNCTION DrawOptions(const fz_draw_options internal);

	/** Access as underlying struct. */
	FZ_FUNCTION fz_draw_options* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const fz_draw_options* internal() const;

	/** We use default destructor. */

	/* == Member data. */

	/* These members are the same as the members of fz_draw_options. */
	int rotate;
	int x_resolution;
	int y_resolution;
	int width;
	int height;
	fz_colorspace *colorspace;
	int alpha;
	int graphics;
	int text;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();

	private:

	/** This class is not copyable or assignable. */
	DrawOptions(const DrawOptions& rhs);
	DrawOptions& operator=(const DrawOptions& rhs);
};

/** Writes a DrawOptions's underlying fz_draw_options's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const DrawOptions& rhs);

/** Wrapper class for struct `fz_error_context`. Not copyable or assignable. */
struct ErrorContext
{
	/** Constructor using raw copy of pre-existing `fz_error_context`. */
	FZ_FUNCTION ErrorContext(fz_error_context* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_error_context* m_internal;

	private:

	/** This class is not copyable or assignable. */
	ErrorContext(const ErrorContext& rhs);
	ErrorContext& operator=(const ErrorContext& rhs);
};

/** Wrapper class for struct `fz_error_stack_slot`. Not copyable or assignable. */
struct ErrorStackSlot
{
	/** Constructor using raw copy of pre-existing `fz_error_stack_slot`. */
	FZ_FUNCTION ErrorStackSlot(fz_error_stack_slot* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_error_stack_slot* m_internal;

	private:

	/** This class is not copyable or assignable. */
	ErrorStackSlot(const ErrorStackSlot& rhs);
	ErrorStackSlot& operator=(const ErrorStackSlot& rhs);
};

/** Wrapper class for struct `fz_font`. */
/**
	An abstract font handle.
*/
struct Font
{
	/** == Constructors. */

	/** Constructor using `fz_new_base14_font()`. */
	/**
		Create a new font from one of the built-in fonts.
	*/
	FZ_FUNCTION Font(const char *name);

	/** Constructor using `fz_new_builtin_font()`. */
	FZ_FUNCTION Font(const char *name, int is_bold, int is_italic);

	/** Constructor using `fz_new_cjk_font()`. */
	FZ_FUNCTION Font(int ordering);

	/** Constructor using `fz_new_font_from_buffer()`. */
	/**
		Create a new font from a font file in a fz_buffer.
	
		name: Name of font (leave NULL to use name from font).
	
		buffer: Buffer to load from.
	
		index: Which font from the file to load (0 for default).
	
		use_glyph_box: 1 if we should use the glyph bbox, 0 otherwise.
	
		Returns new font handle, or throws exception on error.
	*/
	FZ_FUNCTION Font(const char *name, const Buffer& buffer, int index, int use_glyph_bbox);

	/** Constructor using `fz_new_font_from_file()`. */
	/**
		Create a new font from a font file.
	
		name: Name of font (leave NULL to use name from font).
	
		path: File path to load from.
	
		index: Which font from the file to load (0 for default).
	
		use_glyph_box: 1 if we should use the glyph bbox, 0 otherwise.
	
		Returns new font handle, or throws exception on error.
	*/
	FZ_FUNCTION Font(const char *name, const char *path, int index, int use_glyph_bbox);

	/** Constructor using `fz_new_font_from_memory()`. */
	/**
		Create a new font from a font
		file in memory.
	
		name: Name of font (leave NULL to use name from font).
	
		data: Pointer to the font file data.
	
		len: Length of the font file data.
	
		index: Which font from the file to load (0 for default).
	
		use_glyph_box: 1 if we should use the glyph bbox, 0 otherwise.
	
		Returns new font handle, or throws exception on error.
	*/
	FZ_FUNCTION Font(const char *name, const unsigned char *data, int len, int index, int use_glyph_bbox);

	/** Constructor using `fz_new_type3_font()`. */
	/**
		Create a new (empty) type3 font.
	
		name: Name of font (or NULL).
	
		matrix: Font matrix.
	
		Returns a new font handle, or throws exception on
		allocation failure.
	*/
	FZ_FUNCTION Font(const char *name, Matrix& matrix);

	/** Copy constructor using `fz_keep_font()`. */
	FZ_FUNCTION Font(const Font& rhs);

	/** operator= using `fz_keep_font()` and `fz_drop_font()`. */
	FZ_FUNCTION Font& operator=(const Font& rhs);

	/* == Methods. */

	/** Wrapper for `fz_advance_glyph()`.  */
	/**
		Return the advance for a given glyph.
	
		font: The font to look for the glyph in.
	
		glyph: The glyph to find the advance for.
	
		wmode: 1 for vertical mode, 0 for horizontal.
	
		Returns the advance for the glyph.
	*/
	FZ_FUNCTION float advance_glyph(int glyph, int wmode);

	/** Wrapper for `fz_bound_glyph()`.  */
	/**
		Return a bbox for a given glyph in a font.
	
		font: The font to look for the glyph in.
	
		gid: The glyph to bound.
	
		trm: The matrix to apply to the glyph before bounding.
	
		Returns rectangle by value containing the bounds of the given
		glyph.
	*/
	FZ_FUNCTION Rect bound_glyph(int gid, Matrix& trm);

	/** Wrapper for `fz_decouple_type3_font()`.  */
	FZ_FUNCTION void decouple_type3_font(void *t3doc);

	/** Wrapper for `fz_encode_character()`.  */
	/**
		Find the glyph id for a given unicode
		character within a font.
	
		font: The font to look for the unicode character in.
	
		unicode: The unicode character to encode.
	
		Returns the glyph id for the given unicode value, or 0 if
		unknown.
	*/
	FZ_FUNCTION int encode_character(int unicode);

	/** Wrapper for `fz_encode_character_by_glyph_name()`.  */
	/**
		Encode character.
	
		Either by direct lookup of glyphname within a font, or, failing
		that, by mapping glyphname to unicode and thence to the glyph
		index within the given font.
	
		Returns zero for type3 fonts.
	*/
	FZ_FUNCTION int encode_character_by_glyph_name(const char *glyphname);

	/** Wrapper for `fz_encode_character_sc()`.  */
	/**
		Encode character, preferring small-caps variant if available.
	
		font: The font to look for the unicode character in.
	
		unicode: The unicode character to encode.
	
		Returns the glyph id for the given unicode value, or 0 if
		unknown.
	*/
	FZ_FUNCTION int encode_character_sc(int unicode);

	/** Wrapper for `fz_font_ascender()`.  */
	/**
		Retrieve font ascender in ems.
	*/
	FZ_FUNCTION float font_ascender();

	/** Wrapper for `fz_font_bbox()`.  */
	/**
		Retrieve the font bbox.
	
		font: The font to query.
	
		Returns the font bbox by value; it is valid only if
		fz_font_flags(font)->invalid_bbox is zero.
	*/
	FZ_FUNCTION Rect font_bbox();

	/** Wrapper for `fz_font_descender()`.  */
	/**
		Retrieve font descender in ems.
	*/
	FZ_FUNCTION float font_descender();

	/** Wrapper for `fz_font_digest()`.  */
	/**
		Retrieve the MD5 digest for the font's data.
	*/
	FZ_FUNCTION void font_digest(unsigned char digest[16]);

	/** Wrapper for `fz_font_ft_face()`.  */
	/**
		Retrieve the FT_Face handle
		for the font.
	
		font: The font to query
	
		Returns the FT_Face handle for the font, or NULL
		if not a freetype handled font. (Cast to void *
		to avoid nasty header exposure).
	*/
	FZ_FUNCTION void *font_ft_face();

	/** Wrapper for `fz_font_is_bold()`.  */
	/**
		Query whether the font flags say that this font is bold.
	*/
	FZ_FUNCTION int font_is_bold();

	/** Wrapper for `fz_font_is_italic()`.  */
	/**
		Query whether the font flags say that this font is italic.
	*/
	FZ_FUNCTION int font_is_italic();

	/** Wrapper for `fz_font_is_monospaced()`.  */
	/**
		Query whether the font flags say that this font is monospaced.
	*/
	FZ_FUNCTION int font_is_monospaced();

	/** Wrapper for `fz_font_is_serif()`.  */
	/**
		Query whether the font flags say that this font is serif.
	*/
	FZ_FUNCTION int font_is_serif();

	/** Wrapper for `fz_font_name()`.  */
	/**
		Retrieve a pointer to the name of the font.
	
		font: The font to query.
	
		Returns a pointer to an internal copy of the font name.
		Will never be NULL, but may be the empty string.
	*/
	FZ_FUNCTION const char *font_name();

	/** Wrapper for `fz_font_t3_procs()`.  */
	/**
		Retrieve the Type3 procs
		for a font.
	
		font: The font to query
	
		Returns the t3_procs pointer. Will be NULL for a
		non type-3 font.
	*/
	FZ_FUNCTION fz_buffer **font_t3_procs();

	/** Wrapper for `fz_get_glyph_name()`.  */
	/**
		Find the name of a glyph
	
		font: The font to look for the glyph in.
	
		glyph: The glyph id to look for.
	
		buf: Pointer to a buffer for the name to be inserted into.
	
		size: The size of the buffer.
	
		If a font contains a name table, then the name of the glyph
		will be returned in the supplied buffer. Otherwise a name
		is synthesised. The name will be truncated to fit in
		the buffer.
	*/
	FZ_FUNCTION void get_glyph_name(int glyph, char *buf, int size);

	/** Wrapper for `fz_glyph_cacheable()`.  */
	/**
		Determine if a given glyph in a font
		is cacheable. Certain glyphs in a type 3 font cannot safely
		be cached, as their appearance depends on the enclosing
		graphic state.
	
		font: The font to look for the glyph in.
	
		gif: The glyph to query.
	
		Returns non-zero if cacheable, 0 if not.
	*/
	FZ_FUNCTION int glyph_cacheable(int gid);

	/** Wrapper for `fz_measure_string()`.  */
	/**
		Measure the advance width of a UTF8 string should it be added to a text object.
	
		This uses the same layout algorithms as fz_show_string, and can be used
		to calculate text alignment adjustments.
	*/
	FZ_FUNCTION Matrix measure_string(Matrix& trm, const char *s, int wmode, int bidi_level, fz_bidi_direction markup_dir, fz_text_language language);

	/** Wrapper for `fz_outline_glyph()`.  */
	/**
		Look a glyph up from a font, and return the outline of the
		glyph using the given transform.
	
		The caller owns the returned path, and so is responsible for
		ensuring that it eventually gets dropped.
	*/
	FZ_FUNCTION Path outline_glyph(int gid, Matrix& ctm);

	/** Wrapper for `fz_prepare_t3_glyph()`.  */
	/**
		Force a type3 font to cache the displaylist for a given glyph
		id.
	
		This caching can involve reading the underlying file, so must
		happen ahead of time, so we aren't suddenly forced to read the
		file while playing a displaylist back.
	*/
	FZ_FUNCTION void prepare_t3_glyph(int gid);

	/** Wrapper for `fz_render_glyph_pixmap()`.  */
	/**
		Create a pixmap containing a rendered glyph.
	
		Lookup gid from font, clip it with scissor, and rendering it
		with aa bits of antialiasing into a new pixmap.
	
		The caller takes ownership of the pixmap and so must free it.
	
		Note: This function is no longer used for normal rendering
		operations, and is kept around just because we use it in the
		app. It should be considered "at risk" of removal from the API.
	*/
	FZ_FUNCTION Pixmap render_glyph_pixmap(int gid, Matrix& ctm, Irect& scissor, int aa);

	/** Wrapper for `fz_run_t3_glyph()`.  */
	/**
		Run a glyph from a Type3 font to
		a given device.
	
		font: The font to find the glyph in.
	
		gid: The glyph to run.
	
		trm: The transform to apply.
	
		dev: The device to render onto.
	*/
	FZ_FUNCTION void run_t3_glyph(int gid, Matrix& trm, const Device& dev);

	/** Wrapper for `fz_set_font_bbox()`.  */
	/**
		Set the font bbox.
	
		font: The font to set the bbox for.
	
		xmin, ymin, xmax, ymax: The bounding box.
	*/
	FZ_FUNCTION void set_font_bbox(float xmin, float ymin, float xmax, float ymax);

	/** Wrapper for `pdf_font_writing_supported()`.  */
	FZ_FUNCTION int font_writing_supported();

	/** Wrapper for `pdf_layout_fit_text()`.  */
	FZ_FUNCTION Text layout_fit_text(fz_text_language lang, const char *str, Rect& bounds);

	/** Constructor using raw copy of pre-existing `fz_font`. */
	FZ_FUNCTION Font(fz_font* internal);

	/** Destructor using fz_drop_font(). */
	FZ_FUNCTION ~Font();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_font* m_internal;
};

/** Wrapper class for struct `fz_font_context`. Not copyable or assignable. */
struct FontContext
{
	/** Constructor using raw copy of pre-existing `fz_font_context`. */
	FZ_FUNCTION FontContext(fz_font_context* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_font_context* m_internal;

	private:

	/** This class is not copyable or assignable. */
	FontContext(const FontContext& rhs);
	FontContext& operator=(const FontContext& rhs);
};

/** Wrapper class for struct `fz_font_flags_t`. Not copyable or assignable. */
/**
	Every fz_font carries a set of flags
	within it, in a fz_font_flags_t structure.
*/
struct FontFlagsT
{
	/** Constructor using raw copy of pre-existing `fz_font_flags_t`. */
	FZ_FUNCTION FontFlagsT(fz_font_flags_t* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_font_flags_t* m_internal;

	private:

	/** This class is not copyable or assignable. */
	FontFlagsT(const FontFlagsT& rhs);
	FontFlagsT& operator=(const FontFlagsT& rhs);
};

/** Wrapper class for struct `fz_glyph`. */
/**
	Glyphs represent a run length encoded set of pixels for a 2
	dimensional region of a plane.
*/
struct Glyph
{
	/** Copy constructor using `fz_keep_glyph()`. */
	FZ_FUNCTION Glyph(const Glyph& rhs);

	/** operator= using `fz_keep_glyph()` and `fz_drop_glyph()`. */
	FZ_FUNCTION Glyph& operator=(const Glyph& rhs);

	/* == Methods. */

	/** Wrapper for `fz_glyph_bbox()`.  */
	/**
		Return the bounding box of the glyph in pixels.
	*/
	FZ_FUNCTION Irect glyph_bbox();

	/** Wrapper for `fz_glyph_bbox_no_ctx()`.  */
	FZ_FUNCTION Irect glyph_bbox_no_ctx();

	/** Wrapper for `fz_glyph_height()`.  */
	/**
		Return the height of the glyph in pixels.
	*/
	FZ_FUNCTION int glyph_height();

	/** Wrapper for `fz_glyph_width()`.  */
	/**
		Return the width of the glyph in pixels.
	*/
	FZ_FUNCTION int glyph_width();

	/** Constructor using raw copy of pre-existing `fz_glyph`. */
	FZ_FUNCTION Glyph(fz_glyph* internal);

	/** Destructor using fz_drop_glyph(). */
	FZ_FUNCTION ~Glyph();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_glyph* m_internal;
};

/** Wrapper class for struct `fz_glyph_cache`. Not copyable or assignable. */
struct GlyphCache
{
	/** Constructor using raw copy of pre-existing `fz_glyph_cache`. */
	FZ_FUNCTION GlyphCache(fz_glyph_cache* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_glyph_cache* m_internal;

	private:

	/** This class is not copyable or assignable. */
	GlyphCache(const GlyphCache& rhs);
	GlyphCache& operator=(const GlyphCache& rhs);
};

/** Wrapper class for struct `fz_halftone`. */
/**
	A halftone is a set of threshold tiles, one per component. Each
	threshold tile is a pixmap, possibly of varying sizes and
	phases. Currently, we only provide one 'default' halftone tile
	for operating on 1 component plus alpha pixmaps (where the alpha
	is ignored). This is signified by a fz_halftone pointer to NULL.
*/
struct Halftone
{
	/** Copy constructor using `fz_keep_halftone()`. */
	FZ_FUNCTION Halftone(const Halftone& rhs);

	/** operator= using `fz_keep_halftone()` and `fz_drop_halftone()`. */
	FZ_FUNCTION Halftone& operator=(const Halftone& rhs);

	/** Constructor using raw copy of pre-existing `fz_halftone`. */
	FZ_FUNCTION Halftone(fz_halftone* internal=NULL);

	/** Destructor using fz_drop_halftone(). */
	FZ_FUNCTION ~Halftone();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_halftone* m_internal;
};

/** Wrapper class for struct `fz_hash_table`. Not copyable or assignable. */
/**
	Generic hash-table with fixed-length keys.

	The keys and values are NOT reference counted by the hash table.
	Callers are responsible for taking care the reference counts are
	correct. Inserting a duplicate entry will NOT overwrite the old
	value, and will return the old value.

	The drop_val callback function is only used to release values
	when the hash table is destroyed.
*/
struct HashTable
{
	/** == Constructors. */

	/** Constructor using `fz_new_hash_table()`. */
	/**
		Create a new hash table.
	
		initialsize: The initial size of the hashtable. The hashtable
		may grow (double in size) if it starts to get crowded (80%
		full).
	
		keylen: byte length for each key.
	
		lock: -1 for no lock, otherwise the FZ_LOCK to use to protect
		this table.
	
		drop_val: Function to use to destroy values on table drop.
	*/
	FZ_FUNCTION HashTable(int initialsize, int keylen, int lock, fz_hash_table_drop_fn *drop_val);

	/* == Methods. */

	/** Wrapper for `fz_hash_filter()`.  */
	/**
		Iterate over the entries in a hash table, removing all the ones where callback returns true.
		Does NOT free the value of the entry, so the caller is expected to take care of this.
	*/
	FZ_FUNCTION void hash_filter(void *state, fz_hash_table_filter_fn *callback);

	/** Wrapper for `fz_hash_find()`.  */
	/**
		Search for a matching hash within the table, and return the
		associated value.
	*/
	FZ_FUNCTION void *hash_find(const void *key);

	/** Wrapper for `fz_hash_for_each()`.  */
	/**
		Iterate over the entries in a hash table.
	*/
	FZ_FUNCTION void hash_for_each(void *state, fz_hash_table_for_each_fn *callback);

	/** Wrapper for `fz_hash_insert()`.  */
	/**
		Insert a new key/value pair into the hash table.
	
		If an existing entry with the same key is found, no change is
		made to the hash table, and a pointer to the existing value is
		returned.
	
		If no existing entry with the same key is found, ownership of
		val passes in, key is copied, and NULL is returned.
	*/
	FZ_FUNCTION void *hash_insert(const void *key, void *val);

	/** Wrapper for `fz_hash_remove()`.  */
	/**
		Remove the entry for a given key.
	
		The value is NOT freed, so the caller is expected to take care
		of this.
	*/
	FZ_FUNCTION void hash_remove(const void *key);

	/** Constructor using raw copy of pre-existing `fz_hash_table`. */
	FZ_FUNCTION HashTable(fz_hash_table* internal);

	/** Destructor using fz_drop_hash_table(). */
	FZ_FUNCTION ~HashTable();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_hash_table* m_internal;

	private:

	/** This class is not copyable or assignable. */
	HashTable(const HashTable& rhs);
	HashTable& operator=(const HashTable& rhs);
};

/** Wrapper class for struct `fz_icc_profile`. Not copyable or assignable. */
/**
	Opaque type for an ICC Profile.
*/
struct IccProfile
{
	/** Constructor using raw copy of pre-existing `fz_icc_profile`. */
	FZ_FUNCTION IccProfile(fz_icc_profile* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_icc_profile* m_internal;

	private:

	/** This class is not copyable or assignable. */
	IccProfile(const IccProfile& rhs);
	IccProfile& operator=(const IccProfile& rhs);
};

/** Wrapper class for struct `fz_image`. */
/**
	Images are storable objects from which we can obtain fz_pixmaps.
	These may be implemented as simple wrappers around a pixmap, or
	as more complex things that decode at different subsample
	settings on demand.
*/
struct Image
{
	/** == Constructors. */

	/** Constructor using `fz_new_image_from_buffer()`. */
	/**
		Create a new image from a
		buffer of data, inferring its type from the format
		of the data.
	*/
	FZ_FUNCTION Image(const Buffer& buffer);

	/** Constructor using `fz_new_image_from_compressed_buffer()`. */
	/**
		Create an image based on
		the data in the supplied compressed buffer.
	
		w,h: Width and height of the created image.
	
		bpc: Bits per component.
	
		colorspace: The colorspace (determines the number of components,
		and any color conversions required while decoding).
	
		xres, yres: The X and Y resolutions respectively.
	
		interpolate: 1 if interpolation should be used when decoding
		this image, 0 otherwise.
	
		imagemask: 1 if this is an imagemask (i.e. transparency bitmap
		mask), 0 otherwise.
	
		decode: NULL, or a pointer to to a decode array. The default
		decode array is [0 1] (repeated n times, for n color components).
	
		colorkey: NULL, or a pointer to a colorkey array. The default
		colorkey array is [0 255] (repeated n times, for n color
		components).
	
		buffer: Buffer of compressed data and compression parameters.
		Ownership of this reference is passed in.
	
		mask: NULL, or another image to use as a mask for this one.
		A new reference is taken to this image. Supplying a masked
		image as a mask to another image is illegal!
	*/
	FZ_FUNCTION Image(int w, int h, int bpc, const Colorspace& colorspace, int xres, int yres, int interpolate, int imagemask, 
			#ifdef SWIG
				float *OUTPUT
			#else
				float *decode
			#endif
			, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *colorkey
			#endif
			, const CompressedBuffer& buffer, const Image& mask);

	/** Constructor using `fz_new_image_from_display_list()`. */
	/**
		Create a new image from a display list.
	
		w, h: The conceptual width/height of the image.
	
		transform: The matrix that needs to be applied to the given
		list to make it render to the unit square.
	
		list: The display list.
	*/
	FZ_FUNCTION Image(float w, float h, const DisplayList& list);

	/** Constructor using `fz_new_image_from_file()`. */
	/**
		Create a new image from the contents
		of a file, inferring its type from the format of the
		data.
	*/
	FZ_FUNCTION Image(const char *path);

	/** Constructor using `fz_new_image_from_pixmap()`. */
	/**
		Create an image from the given
		pixmap.
	
		pixmap: The pixmap to base the image upon. A new reference
		to this is taken.
	
		mask: NULL, or another image to use as a mask for this one.
		A new reference is taken to this image. Supplying a masked
		image as a mask to another image is illegal!
	*/
	FZ_FUNCTION Image(const Pixmap& pixmap, const Image& mask);

	/** Constructor using `fz_new_image_from_svg()`. */
	/**
		Create a scalable image from an SVG document.
	*/
	FZ_FUNCTION Image(const Buffer& buf, const char *base_uri, const Archive& zip);

	/** Constructor using `fz_new_image_from_svg_xml()`. */
	/**
		Create a scalable image from an SVG document.
	*/
	FZ_FUNCTION Image(const XmlDoc& xmldoc, const Xml& xml, const char *base_uri, const Archive& zip);

	/** Constructor using `fz_new_image_of_size()`. */
	/**
		Internal function to make a new fz_image structure
		for a derived class.
	
		w,h: Width and height of the created image.
	
		bpc: Bits per component.
	
		colorspace: The colorspace (determines the number of components,
		and any color conversions required while decoding).
	
		xres, yres: The X and Y resolutions respectively.
	
		interpolate: 1 if interpolation should be used when decoding
		this image, 0 otherwise.
	
		imagemask: 1 if this is an imagemask (i.e. transparent), 0
		otherwise.
	
		decode: NULL, or a pointer to to a decode array. The default
		decode array is [0 1] (repeated n times, for n color components).
	
		colorkey: NULL, or a pointer to a colorkey array. The default
		colorkey array is [0 255] (repeated n times, for n color
		components).
	
		mask: NULL, or another image to use as a mask for this one.
		A new reference is taken to this image. Supplying a masked
		image as a mask to another image is illegal!
	
		size: The size of the required allocated structure (the size of
		the derived structure).
	
		get: The function to be called to obtain a decoded pixmap.
	
		get_size: The function to be called to return the storage size
		used by this image.
	
		drop: The function to be called to dispose of this image once
		the last reference is dropped.
	
		Returns a pointer to an allocated structure of the required size,
		with the first sizeof(fz_image) bytes initialised as appropriate
		given the supplied parameters, and the other bytes set to zero.
	*/
	FZ_FUNCTION Image(int w, int h, int bpc, const Colorspace& colorspace, int xres, int yres, int interpolate, int imagemask, 
			#ifdef SWIG
				float *OUTPUT
			#else
				float *decode
			#endif
			, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *colorkey
			#endif
			, const Image& mask, size_t size, fz_image_get_pixmap_fn *get_pixmap, fz_image_get_size_fn *get_size, fz_drop_image_fn *drop);

	/** Construct with m_internal set to null. */
	FZ_FUNCTION Image();

	/** Copy constructor using `fz_keep_image()`. */
	FZ_FUNCTION Image(const Image& rhs);

	/** operator= using `fz_keep_image()` and `fz_drop_image()`. */
	FZ_FUNCTION Image& operator=(const Image& rhs);

	/* == Methods. */

	/** Wrapper for `fz_get_pixmap_from_image()`.
	
	This method has out-params. Python/C# wrappers look like:
		`get_pixmap_from_image(const fz_irect *subarea, fz_matrix *ctm)` => `(fz_pixmap *, int w, int h)`
	 */
	/**
		Called to get a handle to a pixmap from an image.
	
		image: The image to retrieve a pixmap from.
	
		subarea: The subarea of the image that we actually care about
		(or NULL to indicate the whole image).
	
		ctm: Optional, unless subarea is given. If given, then on
		entry this is the transform that will be applied to the complete
		image. It should be updated on exit to the transform to apply to
		the given subarea of the image. This is used to calculate the
		desired width/height for subsampling.
	
		w: If non-NULL, a pointer to an int to be updated on exit to the
		width (in pixels) that the scaled output will cover.
	
		h: If non-NULL, a pointer to an int to be updated on exit to the
		height (in pixels) that the scaled output will cover.
	
		Returns a non NULL pixmap pointer. May throw exceptions.
	*/
	FZ_FUNCTION Pixmap get_pixmap_from_image(Irect& subarea, Matrix& ctm, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *w
			#endif
			, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *h
			#endif
			);

	/** Wrapper for `fz_get_unscaled_pixmap_from_image()`.  */
	/**
		Calls fz_get_pixmap_from_image() with ctm, subarea, w and h all set to NULL.
	*/
	FZ_FUNCTION Pixmap get_unscaled_pixmap_from_image();

	/** Wrapper for `fz_image_orientation()`.  */
	/**
		Request the natural orientation of an image.
	
		This is for images (such as JPEG) that can contain internal
		specifications of rotation/flips. This is ignored by all the
		internal decode/rendering routines, but can be used by callers
		(such as the image document handler) to respect such
		specifications.
	
		The values used by MuPDF are as follows, with the equivalent
		Exif specifications given for information:
	
		0: Undefined
		1: 0 degree ccw rotation. (Exif = 1)
		2: 90 degree ccw rotation. (Exif = 8)
		3: 180 degree ccw rotation. (Exif = 3)
		4: 270 degree ccw rotation. (Exif = 6)
		5: flip on X. (Exif = 2)
		6: flip on X, then rotate ccw by 90 degrees. (Exif = 5)
		7: flip on X, then rotate ccw by 180 degrees. (Exif = 4)
		8: flip on X, then rotate ccw by 270 degrees. (Exif = 7)
	*/
	FZ_FUNCTION uint8_t image_orientation();

	/** Wrapper for `fz_image_orientation_matrix()`.  */
	FZ_FUNCTION Matrix image_orientation_matrix();

	/** Wrapper for `fz_image_resolution()`.
	
	This method has out-params. Python/C# wrappers look like:
		`image_resolution()` => `(int xres, int yres)`
	 */
	/**
		Request the natural resolution
		of an image.
	
		xres, yres: Pointers to ints to be updated with the
		natural resolution of an image (or a sensible default
		if not encoded).
	*/
	FZ_FUNCTION void image_resolution(
			#ifdef SWIG
				int *OUTPUT
			#else
				int *xres
			#endif
			, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *yres
			#endif
			);

	/** Wrapper for `fz_image_size()`.  */
	/**
		Return the size of the storage used by an image.
	*/
	FZ_FUNCTION size_t image_size();

	/** Wrapper for `fz_new_buffer_from_image_as_png()`.  */
	/**
		Reencode a given image as a PNG into a buffer.
	
		Ownership of the buffer is returned.
	*/
	FZ_FUNCTION Buffer new_buffer_from_image_as_png(ColorParams& color_params);

	/** Constructor using raw copy of pre-existing `fz_image`. */
	FZ_FUNCTION Image(fz_image* internal);

	/* == Accessors to members of fz_image m_internal. */

	FZ_FUNCTION fz_key_storable key_storable();
	FZ_FUNCTION int w();
	FZ_FUNCTION int h();
	FZ_FUNCTION int n();
	FZ_FUNCTION int bpc();
	FZ_FUNCTION unsigned int imagemask();
	FZ_FUNCTION unsigned int interpolate();
	FZ_FUNCTION unsigned int use_colorkey();
	FZ_FUNCTION unsigned int use_decode();
	FZ_FUNCTION unsigned int invert_cmyk_jpeg();
	FZ_FUNCTION unsigned int decoded();
	FZ_FUNCTION unsigned int scalable();
	FZ_FUNCTION int orientation();
	FZ_FUNCTION Image mask();
	FZ_FUNCTION int xres();
	FZ_FUNCTION int yres();
	FZ_FUNCTION Colorspace colorspace();
	FZ_FUNCTION int * colorkey();
	FZ_FUNCTION float * decode();

	/** Destructor using fz_drop_image(). */
	FZ_FUNCTION ~Image();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_image* m_internal;
};

/** Wrapper class for struct `fz_irect`. */
/**
	fz_irect is a rectangle using integers instead of floats.

	It's used in the draw device and for pixmap dimensions.
*/
struct Irect
{
	/** == Constructors. */

	/** Constructor using `fz_irect_from_rect()`. */
	/**
		Convert a rect into the minimal bounding box
		that covers the rectangle.
	
		Coordinates in a bounding box are integers, so rounding of the
		rects coordinates takes place. The top left corner is rounded
		upwards and left while the bottom right corner is rounded
		downwards and to the right.
	*/
	FZ_FUNCTION Irect(Rect& rect);

	/** Constructor using `fz_make_irect()`. */
	FZ_FUNCTION Irect(int x0, int y0, int x1, int y1);

	/** We use default copy constructor and operator=. */

	/* == Methods. */

	/** Wrapper for `fz_expand_irect()`.  */
	FZ_FUNCTION Irect expand_irect(int expand);

	/** Wrapper for `fz_intersect_irect()`.  */
	/**
		Compute intersection of two bounding boxes.
	
		Similar to fz_intersect_rect but operates on two bounding
		boxes instead of two rectangles.
	*/
	FZ_FUNCTION Irect intersect_irect(Irect& b);

	/** Wrapper for `fz_irect_height()`.  */
	/**
		Return the height of an irect. Invalid irects return 0.
	*/
	FZ_FUNCTION int irect_height();

	/** Wrapper for `fz_irect_width()`.  */
	/**
		Return the width of an irect. Invalid irects return 0.
	*/
	FZ_FUNCTION unsigned int irect_width();

	/** Wrapper for `fz_is_empty_irect()`.  */
	FZ_FUNCTION int is_empty_irect();

	/** Wrapper for `fz_is_infinite_irect()`.  */
	/**
		Check if an integer rectangle
		is infinite.
	*/
	FZ_FUNCTION int is_infinite_irect();

	/** Wrapper for `fz_is_valid_irect()`.  */
	/**
		Check if an integer rectangle is valid.
	*/
	FZ_FUNCTION int is_valid_irect();

	/** Wrapper for `fz_rect_from_irect()`.  */
	/**
		Convert a bbox into a rect.
	
		For our purposes, a rect can represent all the values we meet in
		a bbox, so nothing can go wrong.
	
		rect: A place to store the generated rectangle.
	
		bbox: The bbox to convert.
	
		Returns rect (updated).
	*/
	FZ_FUNCTION Rect rect_from_irect();

	/** Wrapper for `fz_translate_irect()`.  */
	FZ_FUNCTION Irect translate_irect(int xoff, int yoff);

	/** Constructor using raw copy of pre-existing `fz_irect`. */
	FZ_FUNCTION Irect(const fz_irect* internal);

	/** Constructor using raw copy of pre-existing `fz_irect`. */
	FZ_FUNCTION Irect(const fz_irect internal);

	/** Access as underlying struct. */
	FZ_FUNCTION fz_irect* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const fz_irect* internal() const;

	/** We use default destructor. */

	/* == Member data. */

	/* These members are the same as the members of fz_irect. */
	int x0;
	int y0;
	int x1;
	int y1;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();
};

/** Writes a Irect's underlying fz_irect's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const Irect& rhs);

/** Wrapper class for struct `fz_jbig2_globals`. */
struct Jbig2Globals
{
	/** Copy constructor using `fz_keep_jbig2_globals()`. */
	FZ_FUNCTION Jbig2Globals(const Jbig2Globals& rhs);

	/** operator= using `fz_keep_jbig2_globals()` and `fz_drop_jbig2_globals()`. */
	FZ_FUNCTION Jbig2Globals& operator=(const Jbig2Globals& rhs);

	/* == Methods. */

	/** Wrapper for `fz_jbig2_globals_data()`.  */
	/**
		Return buffer containing jbig2 globals data stream.
	*/
	FZ_FUNCTION Buffer jbig2_globals_data();

	/** Constructor using raw copy of pre-existing `fz_jbig2_globals`. */
	FZ_FUNCTION Jbig2Globals(fz_jbig2_globals* internal);

	/** Destructor using fz_drop_jbig2_globals(). */
	FZ_FUNCTION ~Jbig2Globals();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_jbig2_globals* m_internal;
};

/** Wrapper class for struct `fz_key_storable`. */
/**
	Any storable object that can appear in the key of another
	storable object should include an fz_key_storable structure
	at the start (by convention at least) of their structure.
*/
struct KeyStorable
{
	/** Copy constructor using `fz_keep_key_storable()`. */
	FZ_FUNCTION KeyStorable(const KeyStorable& rhs);

	/** operator= using `fz_keep_key_storable()` and `fz_drop_key_storable()`. */
	FZ_FUNCTION KeyStorable& operator=(const KeyStorable& rhs);

	/** Constructor using raw copy of pre-existing `fz_key_storable`. */
	FZ_FUNCTION KeyStorable(fz_key_storable* internal);

	/** Destructor using fz_drop_key_storable(). */
	FZ_FUNCTION ~KeyStorable();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_key_storable* m_internal;
};

/** Wrapper class for struct `fz_layout_block`. Not copyable or assignable. */
struct LayoutBlock
{
	/** == Constructors. */

	/** Constructor using `fz_new_layout()`. */
	/**
		Create a new layout block, with new allocation pool, zero
		matrices, and initialise linked pointers.
	*/
	FZ_FUNCTION LayoutBlock();

	/* == Methods. */

	/** Wrapper for `fz_add_layout_char()`.  */
	/**
		Add a new char to the line at the end of the layout block.
	*/
	FZ_FUNCTION void add_layout_char(float x, float w, const char *p);

	/** Wrapper for `fz_add_layout_line()`.  */
	/**
		Add a new line to the end of the layout block.
	*/
	FZ_FUNCTION void add_layout_line(float x, float y, float h, const char *p);

	/** Constructor using raw copy of pre-existing `fz_layout_block`. */
	FZ_FUNCTION LayoutBlock(fz_layout_block* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_layout_block* m_internal;

	private:

	/** This class is not copyable or assignable. */
	LayoutBlock(const LayoutBlock& rhs);
	LayoutBlock& operator=(const LayoutBlock& rhs);
};

/** Wrapper class for struct `fz_layout_char`. Not copyable or assignable. */
/**
	Simple text layout (for use with annotation editing primarily).
*/
struct LayoutChar
{
	/** Constructor using raw copy of pre-existing `fz_layout_char`. */
	FZ_FUNCTION LayoutChar(fz_layout_char* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_layout_char* m_internal;

	private:

	/** This class is not copyable or assignable. */
	LayoutChar(const LayoutChar& rhs);
	LayoutChar& operator=(const LayoutChar& rhs);
};

/** Wrapper class for struct `fz_layout_line`. Not copyable or assignable. */
struct LayoutLine
{
	/** Constructor using raw copy of pre-existing `fz_layout_line`. */
	FZ_FUNCTION LayoutLine(fz_layout_line* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_layout_line* m_internal;

	private:

	/** This class is not copyable or assignable. */
	LayoutLine(const LayoutLine& rhs);
	LayoutLine& operator=(const LayoutLine& rhs);
};

struct LinkIterator;

/** Wrapper class for struct `fz_link`. */
/**
	fz_link is a list of interactive links on a page.

	There is no relation between the order of the links in the
	list and the order they appear on the page. The list of links
	for a given page can be obtained from fz_load_links.

	A link is reference counted. Dropping a reference to a link is
	done by calling fz_drop_link.

	rect: The hot zone. The area that can be clicked in
	untransformed coordinates.

	uri: Link destinations come in two forms: internal and external.
	Internal links refer to other pages in the same document.
	External links are URLs to other documents.

	next: A pointer to the next link on the same page.
*/
struct Link
{
	/** == Constructors. */

	/** Constructor using `fz_new_link()`. */
	/**
		Create a new link record.
	
		next is set to NULL with the expectation that the caller will
		handle the linked list setup.
	
		Internal function.
	*/
	FZ_FUNCTION Link(Rect& bbox, const char *uri);

	/** Copy constructor using `fz_keep_link()`. */
	FZ_FUNCTION Link(const Link& rhs);

	/** operator= using `fz_keep_link()` and `fz_drop_link()`. */
	FZ_FUNCTION Link& operator=(const Link& rhs);

	/* == Methods. */

	/** Used for iteration over linked list of Link items starting at fz_link::. */
	FZ_FUNCTION LinkIterator begin();

	/** Used for iteration over linked list of Link items starting at fz_link::. */
	FZ_FUNCTION LinkIterator end();

	/** Constructor using raw copy of pre-existing `fz_link`. */
	FZ_FUNCTION Link(fz_link* internal);

	/* == Accessors to members of fz_link m_internal. */

	FZ_FUNCTION int refs();
	FZ_FUNCTION Link next();
	FZ_FUNCTION fz_rect rect();
	FZ_FUNCTION const char *uri();

	/** Destructor using fz_drop_link(). */
	FZ_FUNCTION ~Link();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_link* m_internal;

	typedef LinkIterator iterator;
};

/** Wrapper class for struct `fz_link_dest`. Not copyable or assignable. */
struct LinkDest
{
	/* == Methods. */

	/** Wrapper for `pdf_format_link_uri()`.  */
	FZ_FUNCTION char *format_link_uri();

	/** Constructor using raw copy of pre-existing `fz_link_dest`. */
	FZ_FUNCTION LinkDest(fz_link_dest* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_link_dest* m_internal;

	private:

	/** This class is not copyable or assignable. */
	LinkDest(const LinkDest& rhs);
	LinkDest& operator=(const LinkDest& rhs);
};

/** Wrapper class for struct `fz_location`. */
/**
	Locations within the document are referred to in terms of
	chapter and page, rather than just a page number. For some
	documents (such as epub documents with large numbers of pages
	broken into many chapters) this can make navigation much faster
	as only the required chapter needs to be decoded at a time.
*/
struct Location
{
	/** == Constructors. */

	/** Constructor using `fz_make_location()`. */
	/**
		Simple constructor for fz_locations.
	*/
	FZ_FUNCTION Location(int chapter, int page);

	/** We use default copy constructor and operator=. */

	/** Constructor using raw copy of pre-existing `fz_location`. */
	FZ_FUNCTION Location(const fz_location* internal);

	/** Constructor using raw copy of pre-existing `fz_location`. */
	FZ_FUNCTION Location(const fz_location internal);

	/** Access as underlying struct. */
	FZ_FUNCTION fz_location* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const fz_location* internal() const;

	/** We use default destructor. */

	/* == Member data. */

	/* These members are the same as the members of fz_location. */
	int chapter;
	int page;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();
};

/** Writes a Location's underlying fz_location's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const Location& rhs);

/** Wrapper class for struct `fz_locks_context`. Not copyable or assignable. */
/**
	Locking functions

	MuPDF is kept deliberately free of any knowledge of particular
	threading systems. As such, in order for safe multi-threaded
	operation, we rely on callbacks to client provided functions.

	A client is expected to provide FZ_LOCK_MAX number of mutexes,
	and a function to lock/unlock each of them. These may be
	recursive mutexes, but do not have to be.

	If a client does not intend to use multiple threads, then it
	may pass NULL instead of a lock structure.

	In order to avoid deadlocks, we have one simple rule
	internally as to how we use locks: We can never take lock n
	when we already hold any lock i, where 0 <= i <= n. In order
	to verify this, we have some debugging code, that can be
	enabled by defining FITZ_DEBUG_LOCKING.
*/
struct LocksContext
{
	/** Constructor using raw copy of pre-existing `fz_locks_context`. */
	FZ_FUNCTION LocksContext(fz_locks_context* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_locks_context* m_internal;

	private:

	/** This class is not copyable or assignable. */
	LocksContext(const LocksContext& rhs);
	LocksContext& operator=(const LocksContext& rhs);
};

/** Wrapper class for struct `fz_matrix`. */
/**
	fz_matrix is a row-major 3x3 matrix used for representing
	transformations of coordinates throughout MuPDF.

	Since all points reside in a two-dimensional space, one vector
	is always a constant unit vector; hence only some elements may
	vary in a matrix. Below is how the elements map between
	different representations.

	/ a b 0 \
	| c d 0 | normally represented as [ a b c d e f ].
	\ e f 1 /
*/
struct Matrix
{
	/** == Constructors. */

	/** Constructor using `fz_make_matrix()`. */
	FZ_FUNCTION Matrix(float a, float b, float c, float d, float e, float f);

	/** Constructs identity matrix (like fz_identity). */
	FZ_FUNCTION Matrix();

	/** We use default copy constructor and operator=. */

	/* == Static methods. */

	/** Wrapper for `fz_concat()`.  */
	/**
		Multiply two matrices.
	
		The order of the two matrices are important since matrix
		multiplication is not commutative.
	
		Returns result.
	*/
	FZ_FUNCTION static Matrix concat(Matrix& left, Matrix& right);

	/** Wrapper for `fz_scale()`.  */
	/**
		Create a scaling matrix.
	
		The returned matrix is of the form [ sx 0 0 sy 0 0 ].
	
		m: Pointer to the matrix to populate
	
		sx, sy: Scaling factors along the X- and Y-axes. A scaling
		factor of 1.0 will not cause any scaling along the relevant
		axis.
	
		Returns m.
	*/
	FZ_FUNCTION static Matrix scale(float sx, float sy);

	/** Wrapper for `fz_shear()`.  */
	/**
		Create a shearing matrix.
	
		The returned matrix is of the form [ 1 sy sx 1 0 0 ].
	
		m: pointer to place to store returned matrix
	
		sx, sy: Shearing factors. A shearing factor of 0.0 will not
		cause any shearing along the relevant axis.
	
		Returns m.
	*/
	FZ_FUNCTION static Matrix shear(float sx, float sy);

	/** Wrapper for `fz_rotate()`.  */
	/**
		Create a rotation matrix.
	
		The returned matrix is of the form
		[ cos(deg) sin(deg) -sin(deg) cos(deg) 0 0 ].
	
		m: Pointer to place to store matrix
	
		degrees: Degrees of counter clockwise rotation. Values less
		than zero and greater than 360 are handled as expected.
	
		Returns m.
	*/
	FZ_FUNCTION static Matrix rotate(float degrees);

	/** Wrapper for `fz_translate()`.  */
	/**
		Create a translation matrix.
	
		The returned matrix is of the form [ 1 0 0 1 tx ty ].
	
		m: A place to store the created matrix.
	
		tx, ty: Translation distances along the X- and Y-axes. A
		translation of 0 will not cause any translation along the
		relevant axis.
	
		Returns m.
	*/
	FZ_FUNCTION static Matrix translate(float tx, float ty);

	/** Wrapper for `fz_transform_page()`.  */
	/**
		Create transform matrix to draw page
		at a given resolution and rotation. Adjusts the scaling
		factors so that the page covers whole number of
		pixels and adjust the page origin to be at 0,0.
	*/
	FZ_FUNCTION static Matrix transform_page(Rect& mediabox, float resolution, float rotate);

	/* == Methods. */

	/** Wrapper for `fz_concat()`.  */
	/**
		Multiply two matrices.
	
		The order of the two matrices are important since matrix
		multiplication is not commutative.
	
		Returns result.
	*/
	FZ_FUNCTION Matrix concat(Matrix& right);

	/** Wrapper for `fz_invert_matrix()`.  */
	/**
		Create an inverse matrix.
	
		inverse: Place to store inverse matrix.
	
		matrix: Matrix to invert. A degenerate matrix, where the
		determinant is equal to zero, can not be inverted and the
		original matrix is returned instead.
	
		Returns inverse.
	*/
	FZ_FUNCTION Matrix invert_matrix();

	/** Wrapper for `fz_is_identity()`.  */
	FZ_FUNCTION int is_identity();

	/** Wrapper for `fz_is_rectilinear()`.  */
	/**
		Check if a transformation is rectilinear.
	
		Rectilinear means that no shearing is present and that any
		rotations present are a multiple of 90 degrees. Usually this
		is used to make sure that axis-aligned rectangles before the
		transformation are still axis-aligned rectangles afterwards.
	*/
	FZ_FUNCTION int is_rectilinear();

	/** Wrapper for `fz_matrix_expansion()`.  */
	/**
		Calculate average scaling factor of matrix.
	*/
	FZ_FUNCTION float matrix_expansion();

	/** Wrapper for `fz_matrix_max_expansion()`.  */
	/**
		Find the largest expansion performed by this matrix.
		(i.e. max(abs(m.a),abs(m.b),abs(m.c),abs(m.d))
	*/
	FZ_FUNCTION float matrix_max_expansion();

	/** Wrapper for `fz_post_scale()`.  */
	/**
		Scale a matrix by postmultiplication.
	
		m: Pointer to the matrix to scale
	
		sx, sy: Scaling factors along the X- and Y-axes. A scaling
		factor of 1.0 will not cause any scaling along the relevant
		axis.
	
		Returns m (updated).
	*/
	FZ_FUNCTION Matrix post_scale(float sx, float sy);

	/** Wrapper for `fz_pre_rotate()`.  */
	/**
		Rotate a transformation by premultiplying.
	
		The premultiplied matrix is of the form
		[ cos(deg) sin(deg) -sin(deg) cos(deg) 0 0 ].
	
		m: Pointer to matrix to premultiply.
	
		degrees: Degrees of counter clockwise rotation. Values less
		than zero and greater than 360 are handled as expected.
	
		Returns m (updated).
	*/
	FZ_FUNCTION Matrix pre_rotate(float degrees);

	/** Wrapper for `fz_pre_scale()`.  */
	/**
		Scale a matrix by premultiplication.
	
		m: Pointer to the matrix to scale
	
		sx, sy: Scaling factors along the X- and Y-axes. A scaling
		factor of 1.0 will not cause any scaling along the relevant
		axis.
	
		Returns m (updated).
	*/
	FZ_FUNCTION Matrix pre_scale(float sx, float sy);

	/** Wrapper for `fz_pre_shear()`.  */
	/**
		Premultiply a matrix with a shearing matrix.
	
		The shearing matrix is of the form [ 1 sy sx 1 0 0 ].
	
		m: pointer to matrix to premultiply
	
		sx, sy: Shearing factors. A shearing factor of 0.0 will not
		cause any shearing along the relevant axis.
	
		Returns m (updated).
	*/
	FZ_FUNCTION Matrix pre_shear(float sx, float sy);

	/** Wrapper for `fz_pre_translate()`.  */
	/**
		Translate a matrix by premultiplication.
	
		m: The matrix to translate
	
		tx, ty: Translation distances along the X- and Y-axes. A
		translation of 0 will not cause any translation along the
		relevant axis.
	
		Returns m.
	*/
	FZ_FUNCTION Matrix pre_translate(float tx, float ty);

	/** Wrapper for `fz_subpixel_adjust()`.  */
	/**
		Perform subpixel quantisation and adjustment on a glyph matrix.
	
		ctm: On entry, the desired 'ideal' transformation for a glyph.
		On exit, adjusted to a (very similar) transformation quantised
		for subpixel caching.
	
		subpix_ctm: Initialised by the routine to the transform that
		should be used to render the glyph.
	
		qe, qf: which subpixel position we quantised to.
	
		Returns: the size of the glyph.
	
		Note: This is currently only exposed for use in our app. It
		should be considered "at risk" of removal from the API.
	*/
	FZ_FUNCTION float subpixel_adjust(Matrix& subpix_ctm, unsigned char *qe, unsigned char *qf);

	/** Wrapper for `fz_try_invert_matrix()`.  */
	/**
		Attempt to create an inverse matrix.
	
		inverse: Place to store inverse matrix.
	
		matrix: Matrix to invert. A degenerate matrix, where the
		determinant is equal to zero, can not be inverted.
	
		Returns 1 if matrix is degenerate (singular), or 0 otherwise.
	*/
	FZ_FUNCTION int try_invert_matrix(Matrix& src);

	/** Constructor using raw copy of pre-existing `fz_matrix`. */
	FZ_FUNCTION Matrix(const fz_matrix* internal);

	/** Constructor using raw copy of pre-existing `fz_matrix`. */
	FZ_FUNCTION Matrix(const fz_matrix internal);

	/** Access as underlying struct. */
	FZ_FUNCTION fz_matrix* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const fz_matrix* internal() const;

	/** We use default destructor. */

	/* == Member data. */

	/* These members are the same as the members of fz_matrix. */
	float a;
	float b;
	float c;
	float d;
	float e;
	float f;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();
};

/** Writes a Matrix's underlying fz_matrix's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const Matrix& rhs);

/** Wrapper class for struct `fz_md5`. */
/**
	Structure definition is public to enable stack
	based allocation. Do not access the members directly.
*/
struct Md5
{
	/** Default constructor calls md5_init(). */
	FZ_FUNCTION Md5();

	/** We use default copy constructor and operator=. */

	/* == Methods. */

	/** Wrapper for `fz_md5_final()`.  */
	/**
		MD5 finalization. Ends an MD5 message-digest operation, writing
		the message digest and zeroizing the context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void md5_final(unsigned char digest[16]);

	/** Wrapper for `fz_md5_init()`.  */
	/**
		MD5 initialization. Begins an MD5 operation, writing a new
		context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void md5_init();

	/** Wrapper for `fz_md5_update()`.  */
	/**
		MD5 block update operation. Continues an MD5 message-digest
		operation, processing another message block, and updating the
		context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void md5_update(const unsigned char *input, size_t inlen);

	/** Wrapper for `fz_md5_update_int64()`.  */
	/**
		MD5 block update operation. Continues an MD5 message-digest
		operation, processing an int64, and updating the context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void md5_update_int64(int64_t i);

	/** Wrapper for fz_md5_final() that returns the digest by value. */
	FZ_FUNCTION std::vector<unsigned char> md5_final2();

	/** Constructor using raw copy of pre-existing `fz_md5`. */
	FZ_FUNCTION Md5(const fz_md5* internal);

	/* == Accessors to members of fz_md5 m_internal. */

	FZ_FUNCTION uint32_t lo();
	FZ_FUNCTION uint32_t hi();
	FZ_FUNCTION uint32_t a();
	FZ_FUNCTION uint32_t b();
	FZ_FUNCTION uint32_t c();
	FZ_FUNCTION uint32_t d();
	FZ_FUNCTION unsigned char * buffer();

	/** We use default destructor. */

	/* == Member data. */

	fz_md5  m_internal; /** Wrapped data is held by value. */

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();
};

/** Writes a Md5's underlying fz_md5's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const Md5& rhs);

/** Wrapper class for struct `fz_outline`. */
/**
	fz_outline is a tree of the outline of a document (also known
	as table of contents).

	title: Title of outline item using UTF-8 encoding. May be NULL
	if the outline item has no text string.

	uri: Destination in the document to be displayed when this
	outline item is activated. May be an internal or external
	link, or NULL if the outline item does not have a destination.

	page: The page number of an internal link, or -1 for external
	links or links with no destination.

	next: The next outline item at the same level as this outline
	item. May be NULL if no more outline items exist at this level.

	down: The outline items immediate children in the hierarchy.
	May be NULL if no children exist.
*/
struct Outline
{
	/** == Constructors. */

	/** Constructor using `fz_load_outline()`. */
	/**
		Load the hierarchical document outline.
	
		Should be freed by fz_drop_outline.
	*/
	FZ_FUNCTION Outline(const Document& doc);

	/** Constructor using `fz_load_outline_from_iterator()`. */
	/**
		Routine to implement the old Structure based API from an iterator.
	*/
	FZ_FUNCTION Outline(const OutlineIterator& iter);

	/** Constructor using `fz_new_outline()`. */
	/**
		Create a new outline entry with zeroed fields for the caller
		to fill in.
	*/
	FZ_FUNCTION Outline();

	/** Copy constructor using `fz_keep_outline()`. */
	FZ_FUNCTION Outline(const Outline& rhs);

	/** operator= using `fz_keep_outline()` and `fz_drop_outline()`. */
	FZ_FUNCTION Outline& operator=(const Outline& rhs);

	/** Constructor using raw copy of pre-existing `fz_outline`. */
	FZ_FUNCTION Outline(fz_outline* internal);

	/* == Accessors to members of fz_outline m_internal. */

	FZ_FUNCTION int refs();
	FZ_FUNCTION const char *title();
	FZ_FUNCTION const char *uri();
	FZ_FUNCTION fz_location page();
	FZ_FUNCTION float x();
	FZ_FUNCTION float y();
	FZ_FUNCTION Outline next();
	FZ_FUNCTION Outline down();
	FZ_FUNCTION int is_open();

	/** Destructor using fz_drop_outline(). */
	FZ_FUNCTION ~Outline();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_outline* m_internal;
};

/** Wrapper class for struct `fz_outline_item`. */
struct OutlineItem
{
	FZ_FUNCTION bool valid() const;
	FZ_FUNCTION const std::string& title() const;   /* Will throw if valid() is not true. */
	FZ_FUNCTION const std::string& uri() const;     /* Will throw if valid() is not true. */
	FZ_FUNCTION int is_open() const;                /* Will throw if valid() is not true. */

	/** We use default copy constructor and operator=. */

	/** Constructor using raw copy of pre-existing `fz_outline_item`. */
	FZ_FUNCTION OutlineItem(const fz_outline_item* internal);

	/** We use default destructor. */

	/* == Member data. */


	private:
	bool        m_valid;
	std::string m_title;
	std::string m_uri;
	int         m_is_open;
};

/** Wrapper class for struct `fz_outline_iterator`. Not copyable or assignable. */
struct OutlineIterator
{
	/** == Constructors. */

	/** Constructor using `fz_new_outline_iterator()`. */
	/**
		Get an iterator for the document outline.
	
		Should be freed by fz_drop_outline_iterator.
	*/
	FZ_FUNCTION OutlineIterator(const Document& doc);

	/** Constructor using `fz_new_outline_iterator_of_size()`. */
	FZ_FUNCTION OutlineIterator(size_t size, const Document& doc);

	/* == Methods. */

	/** Wrapper for `fz_load_outline_from_iterator()`.  */
	/**
		Routine to implement the old Structure based API from an iterator.
	*/
	FZ_FUNCTION Outline load_outline_from_iterator();

	/** Wrapper for `fz_outline_iterator_delete()`.  */
	/**
		Delete the current item.
	
		This implicitly moves us to the 'next' item, and the return code is as for fz_outline_iterator_next.
	*/
	FZ_FUNCTION int outline_iterator_delete();

	/** Wrapper for `fz_outline_iterator_down()`.  */
	FZ_FUNCTION int outline_iterator_down();

	/** Wrapper for `fz_outline_iterator_item()`.  */
	/**
		Call to get the current outline item.
	
		Can return NULL. The item is only valid until the next call.
	*/
	FZ_FUNCTION OutlineItem outline_iterator_item();

	/** Wrapper for `fz_outline_iterator_next()`.  */
	/**
		Calls to move the iterator position.
	
		A negative return value means we could not move as requested. Otherwise:
		0 = the final position has a valid item.
		1 = not a valid item, but we can insert an item here.
	*/
	FZ_FUNCTION int outline_iterator_next();

	/** Wrapper for `fz_outline_iterator_prev()`.  */
	FZ_FUNCTION int outline_iterator_prev();

	/** Wrapper for `fz_outline_iterator_up()`.  */
	FZ_FUNCTION int outline_iterator_up();

	/** Custom wrapper for fz_outline_iterator_insert(). */
	FZ_FUNCTION int outline_iterator_insert(OutlineItem& item);

	/** Custom wrapper for fz_outline_iterator_update(). */
	FZ_FUNCTION void outline_iterator_update(OutlineItem& item);

	/** Constructor using raw copy of pre-existing `fz_outline_iterator`. */
	FZ_FUNCTION OutlineIterator(fz_outline_iterator* internal);

	/** Destructor using fz_drop_outline_iterator(). */
	FZ_FUNCTION ~OutlineIterator();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_outline_iterator* m_internal;

	private:

	/** This class is not copyable or assignable. */
	OutlineIterator(const OutlineIterator& rhs);
	OutlineIterator& operator=(const OutlineIterator& rhs);
};

/** Wrapper class for struct `fz_output`. Not copyable or assignable. */
struct Output
{
	enum Fixed
	{
		Fixed_STDOUT=1,
		Fixed_STDERR=2,
	};
	enum Filter
	{
		Filter_HEX,
		Filter_85,
		Filter_RLE,
	};

	/** == Constructors. */

	/** Constructor using `fz_new_arc4_output()`. */
	FZ_FUNCTION Output(const Output& chain, unsigned char *key, size_t keylen);

	/** Constructor using `fz_new_deflate_output()`. */
	FZ_FUNCTION Output(const Output& chain, int effort, int raw);

	/** Constructor using `fz_new_log_for_module()`. */
	/**
		Internal function to actually do the opening of the logfile.
	
		Caller should close/drop the output when finished with it.
	*/
	FZ_FUNCTION Output(const char *module);

	/** Constructor using `fz_new_output()`. */
	/**
		Create a new output object with the given
		internal state and function pointers.
	
		state: Internal state (opaque to everything but implementation).
	
		write: Function to output a given buffer.
	
		close: Cleanup function to destroy state when output closed.
		May permissibly be null.
	*/
	FZ_FUNCTION Output(int bufsiz, void *state, fz_output_write_fn *write, fz_output_close_fn *close, fz_output_drop_fn *drop);

	/** Constructor using `fz_new_output_with_buffer()`. */
	/**
		Open an output stream that appends
		to a buffer.
	
		buf: The buffer to append to.
	*/
	FZ_FUNCTION Output(const Buffer& buf);

	/** Constructor using `fz_new_output_with_path()`. */
	/**
		Open an output stream that writes to a
		given path.
	
		filename: The filename to write to (specified in UTF-8).
	
		append: non-zero if we should append to the file, rather than
		overwriting it.
	*/
	FZ_FUNCTION Output(const char *filename, int append);

	/** Uses fz_stdout() or fz_stderr(). */
	FZ_FUNCTION Output(Fixed out);

	/** Calls one of: fz_new_asciihex_output(), fz_new_ascii85_output(), fz_new_rle_output(). */
	FZ_FUNCTION Output(const Output& chain, Filter filter);

	/* == Methods. */

	/** Wrapper for `fz_close_output()`.  */
	/**
		Flush pending output and close an output stream.
	*/
	FZ_FUNCTION void close_output();

	/** Wrapper for `fz_debug_store()`.  */
	/**
		Output debugging information for the current state of the store
		to the given output channel.
	*/
	FZ_FUNCTION void debug_store();

	/** Wrapper for `fz_dump_glyph_cache_stats()`.  */
	/**
		Dump debug statistics for the glyph cache.
	*/
	FZ_FUNCTION void dump_glyph_cache_stats();

	/** Wrapper for `fz_flush_output()`.  */
	/**
		Flush unwritten data.
	*/
	FZ_FUNCTION void flush_output();

	/** Wrapper for `fz_new_svg_device()`.  */
	/**
		Create a device that outputs (single page) SVG files to
		the given output stream.
	
		Equivalent to fz_new_svg_device_with_id passing id = NULL.
	*/
	FZ_FUNCTION Device new_svg_device(float page_width, float page_height, int text_format, int reuse_images);

	/** Wrapper for `fz_new_svg_device_with_id()`.
	
	This method has out-params. Python/C# wrappers look like:
		`new_svg_device_with_id(float page_width, float page_height, int text_format, int reuse_images)` => `(fz_device *, int id)`
	 */
	/**
		Create a device that outputs (single page) SVG files to
		the given output stream.
	
		output: The output stream to send the constructed SVG page to.
	
		page_width, page_height: The page dimensions to use (in points).
	
		text_format: How to emit text. One of the following values:
			FZ_SVG_TEXT_AS_TEXT: As <text> elements with possible
			layout errors and mismatching fonts.
			FZ_SVG_TEXT_AS_PATH: As <path> elements with exact
			visual appearance.
	
		reuse_images: Share image resources using <symbol> definitions.
	
		id: ID parameter to keep generated IDs unique across SVG files.
	*/
	FZ_FUNCTION Device new_svg_device_with_id(float page_width, float page_height, int text_format, int reuse_images, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *id
			#endif
			);

	/** Wrapper for `fz_new_trace_device()`.  */
	/**
		Create a device to print a debug trace of all device calls.
	*/
	FZ_FUNCTION Device new_trace_device();

	/** Wrapper for `fz_new_xmltext_device()`.  */
	/**
		Create a device to output raw information.
	*/
	FZ_FUNCTION Device new_xmltext_device();

	/** Wrapper for `fz_output_supports_stream()`.  */
	/**
		Query whether a given fz_output supports fz_stream_from_output.
	*/
	FZ_FUNCTION int output_supports_stream();

	/** Wrapper for `fz_print_stext_header_as_html()`.  */
	FZ_FUNCTION void print_stext_header_as_html();

	/** Wrapper for `fz_print_stext_header_as_xhtml()`.  */
	FZ_FUNCTION void print_stext_header_as_xhtml();

	/** Wrapper for `fz_print_stext_page_as_html()`.  */
	/**
		Output structured text to a file in HTML (visual) format.
	*/
	FZ_FUNCTION void print_stext_page_as_html(const StextPage& page, int id);

	/** Wrapper for `fz_print_stext_page_as_json()`.  */
	/**
		Output structured text to a file in JSON format.
	*/
	FZ_FUNCTION void print_stext_page_as_json(const StextPage& page, float scale);

	/** Wrapper for `fz_print_stext_page_as_text()`.  */
	/**
		Output structured text to a file in plain-text UTF-8 format.
	*/
	FZ_FUNCTION void print_stext_page_as_text(const StextPage& page);

	/** Wrapper for `fz_print_stext_page_as_xhtml()`.  */
	/**
		Output structured text to a file in XHTML (semantic) format.
	*/
	FZ_FUNCTION void print_stext_page_as_xhtml(const StextPage& page, int id);

	/** Wrapper for `fz_print_stext_page_as_xml()`.  */
	/**
		Output structured text to a file in XML format.
	*/
	FZ_FUNCTION void print_stext_page_as_xml(const StextPage& page, int id);

	/** Wrapper for `fz_print_stext_trailer_as_html()`.  */
	FZ_FUNCTION void print_stext_trailer_as_html();

	/** Wrapper for `fz_print_stext_trailer_as_xhtml()`.  */
	FZ_FUNCTION void print_stext_trailer_as_xhtml();

	/** Wrapper for `fz_seek_output()`.  */
	/**
		Seek to the specified file position.
		See fseek for arguments.
	
		Throw an error on unseekable outputs.
	*/
	FZ_FUNCTION void seek_output(int64_t off, int whence);

	/** Wrapper for `fz_set_stddbg()`.  */
	/**
		Set the output stream to be used for fz_stddbg. Set to NULL to
		reset to default (stderr).
	*/
	FZ_FUNCTION void set_stddbg();

	/** Wrapper for `fz_stream_from_output()`.  */
	/**
		Obtain the fz_output in the form of a fz_stream.
	
		This allows data to be read back from some forms of fz_output
		object. When finished reading, the fz_stream should be released
		by calling fz_drop_stream. Until the fz_stream is dropped, no
		further operations should be performed on the fz_output object.
	*/
	FZ_FUNCTION Stream stream_from_output();

	/** Wrapper for `fz_tell_output()`.  */
	/**
		Return the current file position.
	
		Throw an error on untellable outputs.
	*/
	FZ_FUNCTION int64_t tell_output();

	/** Wrapper for `fz_truncate_output()`.  */
	/**
		Truncate the output at the current position.
	
		This allows output streams which have seeked back from the end
		of their storage to be truncated at the current point.
	*/
	FZ_FUNCTION void truncate_output();

	/** Wrapper for `fz_write_base64()`.  */
	/**
		Write a base64 encoded data block, optionally with periodic
		newlines.
	*/
	FZ_FUNCTION void write_base64(const unsigned char *data, size_t size, int newline);

	/** Wrapper for `fz_write_base64_buffer()`.  */
	/**
		Write a base64 encoded fz_buffer, optionally with periodic
		newlines.
	*/
	FZ_FUNCTION void write_base64_buffer(const Buffer& data, int newline);

	/** Wrapper for `fz_write_bitmap_as_pbm()`.  */
	/**
		Write a bitmap as a pbm.
	*/
	FZ_FUNCTION void write_bitmap_as_pbm(const Bitmap& bitmap);

	/** Wrapper for `fz_write_bitmap_as_pcl()`.  */
	/**
		Write a bitmap as mono PCL.
	*/
	FZ_FUNCTION void write_bitmap_as_pcl(const Bitmap& bitmap, const PclOptions& pcl);

	/** Wrapper for `fz_write_bitmap_as_pkm()`.  */
	/**
		Write a CMYK bitmap as a pkm.
	*/
	FZ_FUNCTION void write_bitmap_as_pkm(const Bitmap& bitmap);

	/** Wrapper for `fz_write_bitmap_as_pwg()`.  */
	/**
		Write a bitmap as a PWG.
	*/
	FZ_FUNCTION void write_bitmap_as_pwg(const Bitmap& bitmap, PwgOptions& pwg);

	/** Wrapper for `fz_write_bitmap_as_pwg_page()`.  */
	/**
		Write a bitmap as a PWG page.
	
		Caller should provide a file header by calling
		fz_write_pwg_file_header, but can then write several pages to
		the same file.
	*/
	FZ_FUNCTION void write_bitmap_as_pwg_page(const Bitmap& bitmap, PwgOptions& pwg);

	/** Wrapper for `fz_write_byte()`.  */
	FZ_FUNCTION void write_byte(unsigned char x);

	/** Wrapper for `fz_write_char()`.  */
	FZ_FUNCTION void write_char(char x);

	/** Wrapper for `fz_write_data()`.  */
	/**
		Write data to output.
	
		data: Pointer to data to write.
		size: Size of data to write in bytes.
	*/
	FZ_FUNCTION void write_data(const void *data, size_t size);

	/** Wrapper for `fz_write_float_be()`.  */
	FZ_FUNCTION void write_float_be(float f);

	/** Wrapper for `fz_write_float_le()`.  */
	FZ_FUNCTION void write_float_le(float f);

	/** Wrapper for `fz_write_image_as_data_uri()`.  */
	/**
		Write image as a data URI (for HTML and SVG output).
	*/
	FZ_FUNCTION void write_image_as_data_uri(const Image& image);

	/** Wrapper for `fz_write_int16_be()`.  */
	FZ_FUNCTION void write_int16_be(int x);

	/** Wrapper for `fz_write_int16_le()`.  */
	FZ_FUNCTION void write_int16_le(int x);

	/** Wrapper for `fz_write_int32_be()`.  */
	/**
		Write different sized data to an output stream.
	*/
	FZ_FUNCTION void write_int32_be(int x);

	/** Wrapper for `fz_write_int32_le()`.  */
	FZ_FUNCTION void write_int32_le(int x);

	/** Wrapper for `fz_write_pixmap_as_data_uri()`.  */
	FZ_FUNCTION void write_pixmap_as_data_uri(const Pixmap& pixmap);

	/** Wrapper for `fz_write_pixmap_as_pam()`.  */
	/**
		Write a pixmap as a pnm (greyscale, rgb or cmyk, with or without
		alpha).
	*/
	FZ_FUNCTION void write_pixmap_as_pam(const Pixmap& pixmap);

	/** Wrapper for `fz_write_pixmap_as_pcl()`.  */
	/**
		Write an (RGB) pixmap as color PCL.
	*/
	FZ_FUNCTION void write_pixmap_as_pcl(const Pixmap& pixmap, const PclOptions& pcl);

	/** Wrapper for `fz_write_pixmap_as_pclm()`.  */
	/**
		Write a (Greyscale or RGB) pixmap as pclm.
	*/
	FZ_FUNCTION void write_pixmap_as_pclm(const Pixmap& pixmap, const PclmOptions& options);

	/** Wrapper for `fz_write_pixmap_as_pdfocr()`.  */
	/**
		Write a (Greyscale or RGB) pixmap as pdfocr.
	*/
	FZ_FUNCTION void write_pixmap_as_pdfocr(const Pixmap& pixmap, PdfocrOptions& options);

	/** Wrapper for `fz_write_pixmap_as_png()`.  */
	/**
		Write a (Greyscale or RGB) pixmap as a png.
	*/
	FZ_FUNCTION void write_pixmap_as_png(const Pixmap& pixmap);

	/** Wrapper for `fz_write_pixmap_as_pnm()`.  */
	/**
		Write a pixmap as a pnm (greyscale or rgb, no alpha).
	*/
	FZ_FUNCTION void write_pixmap_as_pnm(const Pixmap& pixmap);

	/** Wrapper for `fz_write_pixmap_as_ps()`.  */
	/**
		Write a (gray, rgb, or cmyk, no alpha) pixmap out as postscript.
	*/
	FZ_FUNCTION void write_pixmap_as_ps(const Pixmap& pixmap);

	/** Wrapper for `fz_write_pixmap_as_psd()`.  */
	/**
		Write a pixmap as a PSD file.
	*/
	FZ_FUNCTION void write_pixmap_as_psd(const Pixmap& pixmap);

	/** Wrapper for `fz_write_pixmap_as_pwg()`.  */
	/**
		Write a pixmap as a PWG.
	*/
	FZ_FUNCTION void write_pixmap_as_pwg(const Pixmap& pixmap, PwgOptions& pwg);

	/** Wrapper for `fz_write_pixmap_as_pwg_page()`.  */
	/**
		Write a pixmap as a PWG page.
	
		Caller should provide a file header by calling
		fz_write_pwg_file_header, but can then write several pages to
		the same file.
	*/
	FZ_FUNCTION void write_pixmap_as_pwg_page(const Pixmap& pixmap, PwgOptions& pwg);

	/** Wrapper for `fz_write_ps_file_header()`.  */
	/**
		Write the file level header for ps band writer output.
	*/
	FZ_FUNCTION void write_ps_file_header();

	/** Wrapper for `fz_write_ps_file_trailer()`.  */
	/**
		Write the file level trailer for ps band writer output.
	*/
	FZ_FUNCTION void write_ps_file_trailer(int pages);

	/** Wrapper for `fz_write_pwg_file_header()`.  */
	/**
		Output the file header to a pwg stream, ready for pages to follow it.
	*/
	FZ_FUNCTION void write_pwg_file_header();

	/** Wrapper for `fz_write_rune()`.  */
	/**
		Write a UTF-8 encoded unicode character.
	*/
	FZ_FUNCTION void write_rune(int rune);

	/** Wrapper for `fz_write_string()`.  */
	/**
		Write a string. Does not write zero terminator.
	*/
	FZ_FUNCTION void write_string(const char *s);

	/** Wrapper for `fz_write_uint16_be()`.  */
	FZ_FUNCTION void write_uint16_be(unsigned int x);

	/** Wrapper for `fz_write_uint16_le()`.  */
	FZ_FUNCTION void write_uint16_le(unsigned int x);

	/** Wrapper for `fz_write_uint32_be()`.  */
	FZ_FUNCTION void write_uint32_be(unsigned int x);

	/** Wrapper for `fz_write_uint32_le()`.  */
	FZ_FUNCTION void write_uint32_le(unsigned int x);

	/** Wrapper for `fz_write_vprintf()`.  */
	/**
		va_list version of fz_write_printf.
	*/
	FZ_FUNCTION void write_vprintf(const char *fmt, va_list ap);

	/** Wrapper for `pdf_new_output_processor()`.  */
	FZ_FUNCTION PdfProcessor new_output_processor(int ahxencode);

	/** Wrapper for `pdf_print_crypt()`.  */
	FZ_FUNCTION void print_crypt(const PdfCrypt& crypt);

	/** Wrapper for `pdf_print_encrypted_obj()`.  */
	FZ_FUNCTION void print_encrypted_obj(const PdfObj& obj, int tight, int ascii, const PdfCrypt& crypt, int num, int gen);

	/** Wrapper for `pdf_print_font()`.  */
	FZ_FUNCTION void print_font(const PdfFontDesc& fontdesc);

	/** Wrapper for `pdf_print_obj()`.  */
	FZ_FUNCTION void print_obj(const PdfObj& obj, int tight, int ascii);

	/** Wrapper for `pdf_write_digest()`.  */
	FZ_FUNCTION void write_digest(const PdfObj& byte_range, const PdfObj& field, size_t digest_offset, size_t digest_length, const PdfPkcs7Signer& signer);

	/** Constructor using raw copy of pre-existing `fz_output`. */
	FZ_FUNCTION Output(fz_output* internal=NULL);

	/** Destructor using fz_drop_output(). */
	FZ_FUNCTION ~Output();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_output* m_internal;

	private:

	/** This class is not copyable or assignable. */
	Output(const Output& rhs);
	Output& operator=(const Output& rhs);
};

/** Wrapper class for struct fz_output with virtual fns for each fnptr; this is for use as a SWIG Director class. */
struct Output2 : Output
{

	/** == Constructor. */
	FZ_FUNCTION Output2();

	/** These methods set the function pointers in *m_internal
	to point to internal callbacks that call our virtual methods. */
	FZ_FUNCTION void use_virtual_write( bool use=true);
	FZ_FUNCTION void use_virtual_seek( bool use=true);
	FZ_FUNCTION void use_virtual_tell( bool use=true);
	FZ_FUNCTION void use_virtual_close( bool use=true);
	FZ_FUNCTION void use_virtual_drop( bool use=true);
	FZ_FUNCTION void use_virtual_as_stream( bool use=true);
	FZ_FUNCTION void use_virtual_truncate( bool use=true);

	/** Default virtual method implementations; these all throw an exception. */
	FZ_FUNCTION virtual void write(const void *arg_2, unsigned long arg_3);
	FZ_FUNCTION virtual void seek(long long arg_2, int arg_3);
	FZ_FUNCTION virtual long long tell();
	FZ_FUNCTION virtual void close();
	FZ_FUNCTION virtual void drop();
	FZ_FUNCTION virtual struct fz_stream * as_stream();
	FZ_FUNCTION virtual void truncate();
};

/** Wrapper class for struct `fz_overprint`. Not copyable or assignable. */
/**
	Pixmaps represent a set of pixels for a 2 dimensional region of
	a plane. Each pixel has n components per pixel. The components
	are in the order process-components, spot-colors, alpha, where
	there can be 0 of any of those types. The data is in
	premultiplied alpha when rendering, but non-premultiplied for
	colorspace conversions and rescaling.
*/
struct Overprint
{
	/** Constructor using raw copy of pre-existing `fz_overprint`. */
	FZ_FUNCTION Overprint(fz_overprint* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_overprint* m_internal;

	private:

	/** This class is not copyable or assignable. */
	Overprint(const Overprint& rhs);
	Overprint& operator=(const Overprint& rhs);
};

/** Wrapper class for struct `fz_page`. */
struct Page
{
	/** == Constructors. */

	/** Constructor using `fz_load_chapter_page()`. */
	/**
		Load a page.
	
		After fz_load_page is it possible to retrieve the size of the
		page using fz_bound_page, or to render the page using
		fz_run_page_*. Free the page by calling fz_drop_page.
	
		chapter: chapter number, 0 is the first chapter of the document.
		number: page number, 0 is the first page of the chapter.
	*/
	FZ_FUNCTION Page(const Document& doc, int chapter, int page);

	/** Constructor using `fz_load_page()`. */
	/**
		Load a given page number from a document. This may be much less
		efficient than loading by location (chapter+page) for some
		document types.
	*/
	FZ_FUNCTION Page(const Document& doc, int number);

	/** Constructor using `fz_new_page_of_size()`. */
	/**
		Different document types will be implemented by deriving from
		fz_page. This macro allocates such derived structures, and
		initialises the base sections.
	*/
	FZ_FUNCTION Page(int size, const Document& doc);

	/** Return Page for pdfpage.m_internal.super. */
	FZ_FUNCTION Page(PdfPage& pdfpage);

	/** Copy constructor using `fz_keep_page()`. */
	FZ_FUNCTION Page(const Page& rhs);

	/** operator= using `fz_keep_page()` and `fz_drop_page()`. */
	FZ_FUNCTION Page& operator=(const Page& rhs);

	/* == Methods. */

	/** Wrapper for `fz_bound_page()`.  */
	/**
		Determine the size of a page at 72 dpi.
	*/
	FZ_FUNCTION Rect bound_page();

	/** Wrapper for `fz_create_link()`.  */
	/**
		Create a new link on a page.
	*/
	FZ_FUNCTION Link create_link(Rect& bbox, const char *uri);

	/** Wrapper for `fz_load_links()`.  */
	/**
		Load the list of links for a page.
	
		Returns a linked list of all the links on the page, each with
		its clickable region and link destination. Each link is
		reference counted so drop and free the list of links by
		calling fz_drop_link on the pointer return from fz_load_links.
	
		page: Page obtained from fz_load_page.
	*/
	FZ_FUNCTION Link load_links();

	/** Wrapper for `fz_new_buffer_from_page()`.  */
	FZ_FUNCTION Buffer new_buffer_from_page(StextOptions& options);

	/** Wrapper for `fz_new_buffer_from_page_with_format()`.  */
	/**
		Returns an fz_buffer containing a page after conversion to specified format.
	
		page: The page to convert.
		format, options: Passed to fz_new_document_writer_with_output() internally.
		transform, cookie: Passed to fz_run_page() internally.
	*/
	FZ_FUNCTION Buffer new_buffer_from_page_with_format(const char *format, const char *options, Matrix& transform, Cookie& cookie);

	/** Wrapper for `fz_new_display_list_from_page()`.  */
	/**
		Create a display list.
	
		Ownership of the display list is returned to the caller.
	*/
	FZ_FUNCTION DisplayList new_display_list_from_page();

	/** Wrapper for `fz_new_display_list_from_page_contents()`.  */
	/**
		Create a display list from page contents (no annotations).
	
		Ownership of the display list is returned to the caller.
	*/
	FZ_FUNCTION DisplayList new_display_list_from_page_contents();

	/** Wrapper for `fz_new_pixmap_from_page()`.  */
	FZ_FUNCTION Pixmap new_pixmap_from_page(Matrix& ctm, const Colorspace& cs, int alpha);

	/** Wrapper for `fz_new_pixmap_from_page_contents()`.  */
	/**
		Render the page contents without annotations.
	
		Ownership of the pixmap is returned to the caller.
	*/
	FZ_FUNCTION Pixmap new_pixmap_from_page_contents(Matrix& ctm, const Colorspace& cs, int alpha);

	/** Wrapper for `fz_new_pixmap_from_page_contents_with_separations()`.  */
	FZ_FUNCTION Pixmap new_pixmap_from_page_contents_with_separations(Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha);

	/** Wrapper for `fz_new_pixmap_from_page_with_separations()`.  */
	FZ_FUNCTION Pixmap new_pixmap_from_page_with_separations(Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha);

	/** Wrapper for `fz_page_presentation()`.
	
	This method has out-params. Python/C# wrappers look like:
		`page_presentation(fz_transition *transition)` => `(fz_transition *, float duration)`
	 */
	/**
		Get the presentation details for a given page.
	
		transition: A pointer to a transition struct to fill out.
	
		duration: A pointer to a place to set the page duration in
		seconds. Will be set to 0 if no transition is specified for the
		page.
	
		Returns: a pointer to the transition structure, or NULL if there
		is no transition specified for the page.
	*/
	FZ_FUNCTION Transition page_presentation(Transition& transition, 
			#ifdef SWIG
				float *OUTPUT
			#else
				float *duration
			#endif
			);

	/** Wrapper for `fz_page_separations()`.  */
	/**
		Get the separations details for a page.
		This will be NULL, unless the format specifically supports
		separations (such as PDF files). May be NULL even
		so, if there are no separations on a page.
	
		Returns a reference that must be dropped.
	*/
	FZ_FUNCTION Separations page_separations();

	/** Wrapper for `fz_page_uses_overprint()`.  */
	/**
		Query if a given page requires overprint.
	*/
	FZ_FUNCTION int page_uses_overprint();

	/** Wrapper for `fz_run_page()`.  */
	/**
		Run a page through a device.
	
		page: Page obtained from fz_load_page.
	
		dev: Device obtained from fz_new_*_device.
	
		transform: Transform to apply to page. May include for example
		scaling and rotation, see fz_scale, fz_rotate and fz_concat.
		Set to fz_identity if no transformation is desired.
	
		cookie: Communication mechanism between caller and library
		rendering the page. Intended for multi-threaded applications,
		while single-threaded applications set cookie to NULL. The
		caller may abort an ongoing rendering of a page. Cookie also
		communicates progress information back to the caller. The
		fields inside cookie are continually updated while the page is
		rendering.
	*/
	FZ_FUNCTION void run_page(const Device& dev, Matrix& transform, Cookie& cookie);

	/** Wrapper for `fz_run_page_annots()`.  */
	/**
		Run the annotations on a page through a device.
	*/
	FZ_FUNCTION void run_page_annots(const Device& dev, Matrix& transform, Cookie& cookie);

	/** Wrapper for `fz_run_page_contents()`.  */
	/**
		Run a page through a device. Just the main
		page content, without the annotations, if any.
	
		page: Page obtained from fz_load_page.
	
		dev: Device obtained from fz_new_*_device.
	
		transform: Transform to apply to page. May include for example
		scaling and rotation, see fz_scale, fz_rotate and fz_concat.
		Set to fz_identity if no transformation is desired.
	
		cookie: Communication mechanism between caller and library
		rendering the page. Intended for multi-threaded applications,
		while single-threaded applications set cookie to NULL. The
		caller may abort an ongoing rendering of a page. Cookie also
		communicates progress information back to the caller. The
		fields inside cookie are continually updated while the page is
		rendering.
	*/
	FZ_FUNCTION void run_page_contents(const Device& dev, Matrix& transform, Cookie& cookie);

	/** Wrapper for `fz_run_page_widgets()`.  */
	/**
		Run the widgets on a page through a device.
	*/
	FZ_FUNCTION void run_page_widgets(const Device& dev, Matrix& transform, Cookie& cookie);

	/** Wrapper for `pdf_page_from_fz_page()`.  */
	FZ_FUNCTION PdfPage page_from_fz_page();

	/** Wrapper for fz_search_page(). */
	FZ_FUNCTION std::vector<Quad> search_page(const char* needle, int *hit_mark, int max);

	/** Returns wrapper for .doc member. */
	FZ_FUNCTION Document doc();

	/** Constructor using raw copy of pre-existing `fz_page`. */
	FZ_FUNCTION Page(fz_page* internal);

	/** Destructor using fz_drop_page(). */
	FZ_FUNCTION ~Page();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_page* m_internal;
};

/** Wrapper class for struct `fz_path`. */
/**
 * Vector path buffer.
 * It can be stroked and dashed, or be filled.
 * It has a fill rule (nonzero or even_odd).
 *
 * When rendering, they are flattened, stroked and dashed straight
 * into the Global Edge List.
 */
struct Path
{
	/** == Constructors. */

	/** Constructor using `fz_new_path()`. */
	/**
		Create a new (empty) path structure.
	*/
	FZ_FUNCTION Path();

	/** Copy constructor using `fz_keep_path()`. */
	FZ_FUNCTION Path(const Path& rhs);

	/** operator= using `fz_keep_path()` and `fz_drop_path()`. */
	FZ_FUNCTION Path& operator=(const Path& rhs);

	/* == Methods. */

	/** Wrapper for `fz_bound_path()`.  */
	/**
		Return a bounding rectangle for a path.
	
		path: The path to bound.
	
		stroke: If NULL, the bounding rectangle given is for
		the filled path. If non-NULL the bounding rectangle
		given is for the path stroked with the given attributes.
	
		ctm: The matrix to apply to the path during stroking.
	
		r: Pointer to a fz_rect which will be used to hold
		the result.
	
		Returns r, updated to contain the bounding rectangle.
	*/
	FZ_FUNCTION Rect bound_path(const StrokeState& stroke, Matrix& ctm);

	/** Wrapper for `fz_clone_path()`.  */
	/**
		Clone the data for a path.
	
		This is used in preference to fz_keep_path when a whole
		new copy of a path is required, rather than just a shared
		pointer. This probably indicates that the path is about to
		be modified.
	
		path: path to clone.
	
		Throws exceptions on failure to allocate.
	*/
	FZ_FUNCTION Path clone_path();

	/** Wrapper for `fz_closepath()`.  */
	/**
		Close the current subpath.
	
		path: The path to modify.
	
		Throws exceptions on failure to allocate, attempting to modify
		a packed path, and illegal path closes (i.e. closing a non open
		path).
	*/
	FZ_FUNCTION void closepath();

	/** Wrapper for `fz_currentpoint()`.  */
	/**
		Return the current point that a path has
		reached or (0,0) if empty.
	
		path: path to return the current point of.
	*/
	FZ_FUNCTION Point currentpoint();

	/** Wrapper for `fz_curveto()`.  */
	/**
		Append a 'curveto' command to an open path. (For a
		cubic bezier).
	
		path: The path to modify.
	
		x0, y0: The coordinates of the first control point for the
		curve.
	
		x1, y1: The coordinates of the second control point for the
		curve.
	
		x2, y2: The end coordinates for the curve.
	
		Throws exceptions on failure to allocate, or attempting to
		modify a packed path.
	*/
	FZ_FUNCTION void curveto(float x0, float y0, float x1, float y1, float x2, float y2);

	/** Wrapper for `fz_curvetov()`.  */
	/**
		Append a 'curvetov' command to an open path. (For a
		cubic bezier with the first control coordinate equal to
		the start point).
	
		path: The path to modify.
	
		x1, y1: The coordinates of the second control point for the
		curve.
	
		x2, y2: The end coordinates for the curve.
	
		Throws exceptions on failure to allocate, or attempting to
		modify a packed path.
	*/
	FZ_FUNCTION void curvetov(float x1, float y1, float x2, float y2);

	/** Wrapper for `fz_curvetoy()`.  */
	/**
		Append a 'curvetoy' command to an open path. (For a
		cubic bezier with the second control coordinate equal to
		the end point).
	
		path: The path to modify.
	
		x0, y0: The coordinates of the first control point for the
		curve.
	
		x2, y2: The end coordinates for the curve (and the second
		control coordinate).
	
		Throws exceptions on failure to allocate, or attempting to
		modify a packed path.
	*/
	FZ_FUNCTION void curvetoy(float x0, float y0, float x2, float y2);

	/** Wrapper for `fz_lineto()`.  */
	/**
		Append a 'lineto' command to an open path.
	
		path: The path to modify.
	
		x, y: The coordinate to line to.
	
		Throws exceptions on failure to allocate, or attempting to
		modify a packed path.
	*/
	FZ_FUNCTION void lineto(float x, float y);

	/** Wrapper for `fz_moveto()`.  */
	/**
		Append a 'moveto' command to a path.
		This 'opens' a path.
	
		path: The path to modify.
	
		x, y: The coordinate to move to.
	
		Throws exceptions on failure to allocate, or attempting to
		modify a packed path.
	*/
	FZ_FUNCTION void moveto(float x, float y);

	/** Wrapper for `fz_packed_path_size()`.  */
	/**
		Return the number of bytes required to pack a path.
	*/
	FZ_FUNCTION int packed_path_size();

	/** Wrapper for `fz_quadto()`.  */
	/**
		Append a 'quadto' command to an open path. (For a
		quadratic bezier).
	
		path: The path to modify.
	
		x0, y0: The control coordinates for the quadratic curve.
	
		x1, y1: The end coordinates for the quadratic curve.
	
		Throws exceptions on failure to allocate, or attempting to
		modify a packed path.
	*/
	FZ_FUNCTION void quadto(float x0, float y0, float x1, float y1);

	/** Wrapper for `fz_rectto()`.  */
	/**
		Append a 'rectto' command to an open path.
	
		The rectangle is equivalent to:
			moveto x0 y0
			lineto x1 y0
			lineto x1 y1
			lineto x0 y1
			closepath
	
		path: The path to modify.
	
		x0, y0: First corner of the rectangle.
	
		x1, y1: Second corner of the rectangle.
	
		Throws exceptions on failure to allocate, or attempting to
		modify a packed path.
	*/
	FZ_FUNCTION void rectto(float x0, float y0, float x1, float y1);

	/** Wrapper for `fz_transform_path()`.  */
	/**
		Transform a path by a given
		matrix.
	
		path: The path to modify (must not be a packed path).
	
		transform: The transform to apply.
	
		Throws exceptions if the path is packed, or on failure
		to allocate.
	*/
	FZ_FUNCTION void transform_path(Matrix& transform);

	/** Wrapper for `fz_trim_path()`.  */
	/**
		Minimise the internal storage used by a path.
	
		As paths are constructed, the internal buffers
		grow. To avoid repeated reallocations they
		grow with some spare space. Once a path has
		been fully constructed, this call allows the
		excess space to be trimmed.
	*/
	FZ_FUNCTION void trim_path();

	/** Wrapper for `fz_walk_path()`.  */
	/**
		Walk the segments of a path, calling the
		appropriate callback function from a given set for each
		segment of the path.
	
		path: The path to walk.
	
		walker: The set of callback functions to use. The first
		4 callback pointers in the set must be non-NULL. The
		subsequent ones can either be supplied, or can be left
		as NULL, in which case the top 4 functions will be
		called as appropriate to simulate them.
	
		arg: An opaque argument passed in to each callback.
	
		Exceptions will only be thrown if the underlying callback
		functions throw them.
	*/
	FZ_FUNCTION void walk_path(const PathWalker& walker, void *arg);

	/** Constructor using raw copy of pre-existing `fz_path`. */
	FZ_FUNCTION Path(fz_path* internal);

	/** Destructor using fz_drop_path(). */
	FZ_FUNCTION ~Path();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_path* m_internal;
};

/** Wrapper class for struct `fz_path_walker`. Not copyable or assignable. */
struct PathWalker
{
	/** Constructor using raw copy of pre-existing `fz_path_walker`. */
	FZ_FUNCTION PathWalker(fz_path_walker* internal=NULL);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_path_walker* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PathWalker(const PathWalker& rhs);
	PathWalker& operator=(const PathWalker& rhs);
};

/** Wrapper class for struct fz_path_walker with virtual fns for each fnptr; this is for use as a SWIG Director class. */
struct PathWalker2 : PathWalker
{

	/** == Constructor. */
	FZ_FUNCTION PathWalker2();

	/** == Destructor. */
	FZ_FUNCTION ~PathWalker2();

	/** These methods set the function pointers in *m_internal
	to point to internal callbacks that call our virtual methods. */
	FZ_FUNCTION void use_virtual_moveto( bool use=true);
	FZ_FUNCTION void use_virtual_lineto( bool use=true);
	FZ_FUNCTION void use_virtual_curveto( bool use=true);
	FZ_FUNCTION void use_virtual_closepath( bool use=true);
	FZ_FUNCTION void use_virtual_quadto( bool use=true);
	FZ_FUNCTION void use_virtual_curvetov( bool use=true);
	FZ_FUNCTION void use_virtual_curvetoy( bool use=true);
	FZ_FUNCTION void use_virtual_rectto( bool use=true);

	/** Default virtual method implementations; these all throw an exception. */
	FZ_FUNCTION virtual void moveto(float arg_2, float arg_3);
	FZ_FUNCTION virtual void lineto(float arg_2, float arg_3);
	FZ_FUNCTION virtual void curveto(float arg_2, float arg_3, float arg_4, float arg_5, float arg_6, float arg_7);
	FZ_FUNCTION virtual void closepath();
	FZ_FUNCTION virtual void quadto(float arg_2, float arg_3, float arg_4, float arg_5);
	FZ_FUNCTION virtual void curvetov(float arg_2, float arg_3, float arg_4, float arg_5);
	FZ_FUNCTION virtual void curvetoy(float arg_2, float arg_3, float arg_4, float arg_5);
	FZ_FUNCTION virtual void rectto(float arg_2, float arg_3, float arg_4, float arg_5);
};

/** Wrapper class for struct `fz_pcl_options`. Not copyable or assignable. */
/**
	PCL output
*/
struct PclOptions
{
	/** == Constructors. */

	/** Constructor using `fz_parse_pcl_options()`. */
	/**
		Parse PCL options.
	
		Currently defined options and values are as follows:
	
			preset=X	Either "generic" or one of the presets as for fz_pcl_preset.
			spacing=0	No vertical spacing capability
			spacing=1	PCL 3 spacing (<ESC>*p+<n>Y)
			spacing=2	PCL 4 spacing (<ESC>*b<n>Y)
			spacing=3	PCL 5 spacing (<ESC>*b<n>Y and clear seed row)
			mode2		Disable/Enable mode 2 graphics compression
			mode3		Disable/Enable mode 3 graphics compression
			eog_reset	End of graphics (<ESC>*rB) resets all parameters
			has_duplex	Duplex supported (<ESC>&l<duplex>S)
			has_papersize	Papersize setting supported (<ESC>&l<sizecode>A)
			has_copies	Number of copies supported (<ESC>&l<copies>X)
			is_ljet4pjl	Disable/Enable HP 4PJL model-specific output
			is_oce9050	Disable/Enable Oce 9050 model-specific output
	*/
	FZ_FUNCTION PclOptions(const PclOptions& opts, const char *args);

	/* == Methods. */

	/** Wrapper for `fz_pcl_preset()`.  */
	/**
		Initialize PCL option struct for a given preset.
	
		Currently defined presets include:
	
			generic	Generic PCL printer
			ljet4	HP DeskJet
			dj500	HP DeskJet 500
			fs600	Kyocera FS-600
			lj	HP LaserJet, HP LaserJet Plus
			lj2	HP LaserJet IIp, HP LaserJet IId
			lj3	HP LaserJet III
			lj3d	HP LaserJet IIId
			lj4	HP LaserJet 4
			lj4pl	HP LaserJet 4 PL
			lj4d	HP LaserJet 4d
			lp2563b	HP 2563B line printer
			oce9050	Oce 9050 Line printer
	*/
	FZ_FUNCTION void pcl_preset(const char *preset);

	/** Constructor using raw copy of pre-existing `fz_pcl_options`. */
	FZ_FUNCTION PclOptions(fz_pcl_options* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_pcl_options* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PclOptions(const PclOptions& rhs);
	PclOptions& operator=(const PclOptions& rhs);
};

/** Wrapper class for struct `fz_pclm_options`. Not copyable or assignable. */
/**
	PCLm output
*/
struct PclmOptions
{
	/** == Constructors. */

	/** Constructor using `fz_parse_pclm_options()`. */
	/**
		Parse PCLm options.
	
		Currently defined options and values are as follows:
	
			compression=none: No compression
			compression=flate: Flate compression
			strip-height=n: Strip height (default 16)
	*/
	FZ_FUNCTION PclmOptions(const PclmOptions& opts, const char *args);

	/** Construct using fz_parse_pclm_options(). */
	FZ_FUNCTION PclmOptions(const char *args);

	/** Constructor using raw copy of pre-existing `fz_pclm_options`. */
	FZ_FUNCTION PclmOptions(fz_pclm_options* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_pclm_options* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PclmOptions(const PclmOptions& rhs);
	PclmOptions& operator=(const PclmOptions& rhs);
};

/** Wrapper class for struct `pdf_alert_event`. Not copyable or assignable. */
struct PdfAlertEvent
{
	/** Constructor using raw copy of pre-existing `pdf_alert_event`. */
	FZ_FUNCTION PdfAlertEvent(pdf_alert_event* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_alert_event* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfAlertEvent(const PdfAlertEvent& rhs);
	PdfAlertEvent& operator=(const PdfAlertEvent& rhs);
};

/** Wrapper class for struct `pdf_annot`. */
struct PdfAnnot
{
	/** Copy constructor using `pdf_keep_annot()`. */
	FZ_FUNCTION PdfAnnot(const PdfAnnot& rhs);

	/** operator= using `pdf_keep_annot()` and `pdf_drop_annot()`. */
	FZ_FUNCTION PdfAnnot& operator=(const PdfAnnot& rhs);

	/* == Methods. */

	/** Wrapper for `pdf_add_annot_ink_list_stroke()`.  */
	FZ_FUNCTION void add_annot_ink_list_stroke();

	/** Wrapper for `pdf_add_annot_ink_list_stroke_vertex()`.  */
	FZ_FUNCTION void add_annot_ink_list_stroke_vertex(Point& p);

	/** Wrapper for `pdf_add_annot_quad_point()`.  */
	FZ_FUNCTION void add_annot_quad_point(Quad& quad);

	/** Wrapper for `pdf_add_annot_vertex()`.  */
	FZ_FUNCTION void add_annot_vertex(Point& p);

	/** Wrapper for `pdf_annot_MK_BC()`.
	
	This method has out-params. Python/C# wrappers look like:
		`annot_MK_BC(float color[4])` => int n
	 */
	FZ_FUNCTION void annot_MK_BC(
			#ifdef SWIG
				int *OUTPUT
			#else
				int *n
			#endif
			, float color[4]);

	/** Wrapper for `pdf_annot_MK_BC_rgb()`.  */
	FZ_FUNCTION int annot_MK_BC_rgb(float rgb[3]);

	/** Wrapper for `pdf_annot_MK_BG()`.
	
	This method has out-params. Python/C# wrappers look like:
		`annot_MK_BG(float color[4])` => int n
	 */
	FZ_FUNCTION void annot_MK_BG(
			#ifdef SWIG
				int *OUTPUT
			#else
				int *n
			#endif
			, float color[4]);

	/** Wrapper for `pdf_annot_MK_BG_rgb()`.  */
	FZ_FUNCTION int annot_MK_BG_rgb(float rgb[3]);

	/** Wrapper for `pdf_annot_active()`.  */
	FZ_FUNCTION int annot_active();

	/** Wrapper for `pdf_annot_ap()`.  */
	FZ_FUNCTION PdfObj annot_ap();

	/** Wrapper for `pdf_annot_author()`.  */
	FZ_FUNCTION const char *annot_author();

	/** Wrapper for `pdf_annot_border()`.  */
	FZ_FUNCTION float annot_border();

	/** Wrapper for `pdf_annot_color()`.
	
	This method has out-params. Python/C# wrappers look like:
		`annot_color(float color[4])` => int n
	 */
	FZ_FUNCTION void annot_color(
			#ifdef SWIG
				int *OUTPUT
			#else
				int *n
			#endif
			, float color[4]);

	/** Wrapper for `pdf_annot_contents()`.  */
	FZ_FUNCTION const char *annot_contents();

	/** Wrapper for `pdf_annot_creation_date()`.  */
	FZ_FUNCTION int64_t annot_creation_date();

	/** Wrapper for `pdf_annot_default_appearance()`.
	
	This method has out-params. Python/C# wrappers look like:
		`annot_default_appearance(float color[4])` => `(const char *font, float size, int n)`
	 */
	FZ_FUNCTION void annot_default_appearance(
			#ifdef SWIG
				const char **OUTPUT
			#else
				const char **font
			#endif
			, 
			#ifdef SWIG
				float *OUTPUT
			#else
				float *size
			#endif
			, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *n
			#endif
			, float color[4]);

	/** Wrapper for `pdf_annot_ensure_local_xref()`.  */
	FZ_FUNCTION void annot_ensure_local_xref();

	/** Wrapper for `pdf_annot_event_blur()`.  */
	FZ_FUNCTION void annot_event_blur();

	/** Wrapper for `pdf_annot_event_down()`.  */
	FZ_FUNCTION void annot_event_down();

	/** Wrapper for `pdf_annot_event_enter()`.  */
	FZ_FUNCTION void annot_event_enter();

	/** Wrapper for `pdf_annot_event_exit()`.  */
	FZ_FUNCTION void annot_event_exit();

	/** Wrapper for `pdf_annot_event_focus()`.  */
	FZ_FUNCTION void annot_event_focus();

	/** Wrapper for `pdf_annot_event_page_close()`.  */
	FZ_FUNCTION void annot_event_page_close();

	/** Wrapper for `pdf_annot_event_page_invisible()`.  */
	FZ_FUNCTION void annot_event_page_invisible();

	/** Wrapper for `pdf_annot_event_page_open()`.  */
	FZ_FUNCTION void annot_event_page_open();

	/** Wrapper for `pdf_annot_event_page_visible()`.  */
	FZ_FUNCTION void annot_event_page_visible();

	/** Wrapper for `pdf_annot_event_up()`.  */
	FZ_FUNCTION void annot_event_up();

	/** Wrapper for `pdf_annot_field_flags()`.  */
	FZ_FUNCTION int annot_field_flags();

	/** Wrapper for `pdf_annot_field_label()`.  */
	FZ_FUNCTION const char *annot_field_label();

	/** Wrapper for `pdf_annot_field_value()`.  */
	FZ_FUNCTION const char *annot_field_value();

	/** Wrapper for `pdf_annot_flags()`.  */
	FZ_FUNCTION int annot_flags();

	/** Wrapper for `pdf_annot_has_author()`.  */
	FZ_FUNCTION int annot_has_author();

	/** Wrapper for `pdf_annot_has_icon_name()`.  */
	FZ_FUNCTION int annot_has_icon_name();

	/** Wrapper for `pdf_annot_has_ink_list()`.  */
	FZ_FUNCTION int annot_has_ink_list();

	/** Wrapper for `pdf_annot_has_interior_color()`.  */
	FZ_FUNCTION int annot_has_interior_color();

	/** Wrapper for `pdf_annot_has_line()`.  */
	FZ_FUNCTION int annot_has_line();

	/** Wrapper for `pdf_annot_has_line_ending_styles()`.  */
	FZ_FUNCTION int annot_has_line_ending_styles();

	/** Wrapper for `pdf_annot_has_open()`.  */
	FZ_FUNCTION int annot_has_open();

	/** Wrapper for `pdf_annot_has_quad_points()`.  */
	FZ_FUNCTION int annot_has_quad_points();

	/** Wrapper for `pdf_annot_has_vertices()`.  */
	FZ_FUNCTION int annot_has_vertices();

	/** Wrapper for `pdf_annot_hot()`.  */
	FZ_FUNCTION int annot_hot();

	/** Wrapper for `pdf_annot_icon_name()`.  */
	FZ_FUNCTION const char *annot_icon_name();

	/** Wrapper for `pdf_annot_ink_list_count()`.  */
	FZ_FUNCTION int annot_ink_list_count();

	/** Wrapper for `pdf_annot_ink_list_stroke_count()`.  */
	FZ_FUNCTION int annot_ink_list_stroke_count(int i);

	/** Wrapper for `pdf_annot_ink_list_stroke_vertex()`.  */
	FZ_FUNCTION Point annot_ink_list_stroke_vertex(int i, int k);

	/** Wrapper for `pdf_annot_interior_color()`.
	
	This method has out-params. Python/C# wrappers look like:
		`annot_interior_color(float color[4])` => int n
	 */
	FZ_FUNCTION void annot_interior_color(
			#ifdef SWIG
				int *OUTPUT
			#else
				int *n
			#endif
			, float color[4]);

	/** Wrapper for `pdf_annot_is_open()`.  */
	FZ_FUNCTION int annot_is_open();

	/** Wrapper for `pdf_annot_line()`.  */
	FZ_FUNCTION void annot_line(Point& a, Point& b);

	/** Wrapper for `pdf_annot_line_end_style()`.  */
	FZ_FUNCTION enum pdf_line_ending annot_line_end_style();

	/** Wrapper for `pdf_annot_line_ending_styles()`.
	
	This method has out-params. Python/C# wrappers look like:
		`annot_line_ending_styles()` => `(enum pdf_line_ending start_style, enum pdf_line_ending end_style)`
	 */
	FZ_FUNCTION void annot_line_ending_styles(
			#ifdef SWIG
				enum pdf_line_ending *OUTPUT
			#else
				enum pdf_line_ending *start_style
			#endif
			, 
			#ifdef SWIG
				enum pdf_line_ending *OUTPUT
			#else
				enum pdf_line_ending *end_style
			#endif
			);

	/** Wrapper for `pdf_annot_line_start_style()`.  */
	FZ_FUNCTION enum pdf_line_ending annot_line_start_style();

	/** Wrapper for `pdf_annot_modification_date()`.  */
	FZ_FUNCTION int64_t annot_modification_date();

	/** Wrapper for `pdf_annot_needs_resynthesis()`.  */
	FZ_FUNCTION int annot_needs_resynthesis();

	/** Wrapper for `pdf_annot_obj()`.  */
	FZ_FUNCTION PdfObj annot_obj();

	/** Wrapper for `pdf_annot_opacity()`.  */
	FZ_FUNCTION float annot_opacity();

	/** Wrapper for `pdf_annot_page()`.  */
	FZ_FUNCTION PdfPage annot_page();

	/** Wrapper for `pdf_annot_pop_and_discard_local_xref()`.  */
	FZ_FUNCTION void annot_pop_and_discard_local_xref();

	/** Wrapper for `pdf_annot_pop_local_xref()`.  */
	FZ_FUNCTION void annot_pop_local_xref();

	/** Wrapper for `pdf_annot_popup()`.  */
	FZ_FUNCTION Rect annot_popup();

	/** Wrapper for `pdf_annot_push_local_xref()`.  */
	FZ_FUNCTION void annot_push_local_xref();

	/** Wrapper for `pdf_annot_quad_point()`.  */
	FZ_FUNCTION Quad annot_quad_point(int i);

	/** Wrapper for `pdf_annot_quad_point_count()`.  */
	FZ_FUNCTION int annot_quad_point_count();

	/** Wrapper for `pdf_annot_quadding()`.  */
	FZ_FUNCTION int annot_quadding();

	/** Wrapper for `pdf_annot_rect()`.  */
	FZ_FUNCTION Rect annot_rect();

	/** Wrapper for `pdf_annot_request_resynthesis()`.  */
	FZ_FUNCTION void annot_request_resynthesis();

	/** Wrapper for `pdf_annot_transform()`.  */
	FZ_FUNCTION Matrix annot_transform();

	/** Wrapper for `pdf_annot_type()`.  */
	FZ_FUNCTION enum pdf_annot_type annot_type();

	/** Wrapper for `pdf_annot_vertex()`.  */
	FZ_FUNCTION Point annot_vertex(int i);

	/** Wrapper for `pdf_annot_vertex_count()`.  */
	FZ_FUNCTION int annot_vertex_count();

	/** Wrapper for `pdf_bound_annot()`.  */
	FZ_FUNCTION Rect bound_annot();

	/** Wrapper for `pdf_bound_widget()`.  */
	FZ_FUNCTION Rect bound_widget();

	/** Wrapper for `pdf_choice_widget_is_multiselect()`.  */
	FZ_FUNCTION int choice_widget_is_multiselect();

	/** Wrapper for `pdf_choice_widget_options()`.  */
	FZ_FUNCTION int choice_widget_options(int exportval, const char *opts[]);

	/** Wrapper for `pdf_choice_widget_set_value()`.  */
	FZ_FUNCTION void choice_widget_set_value(int n, const char *opts[]);

	/** Wrapper for `pdf_choice_widget_value()`.  */
	FZ_FUNCTION int choice_widget_value(const char *opts[]);

	/** Wrapper for `pdf_clear_annot_ink_list()`.  */
	FZ_FUNCTION void clear_annot_ink_list();

	/** Wrapper for `pdf_clear_annot_quad_points()`.  */
	FZ_FUNCTION void clear_annot_quad_points();

	/** Wrapper for `pdf_clear_annot_vertices()`.  */
	FZ_FUNCTION void clear_annot_vertices();

	/** Wrapper for `pdf_clear_signature()`.  */
	FZ_FUNCTION void clear_signature();

	/** Wrapper for `pdf_dirty_annot()`.  */
	FZ_FUNCTION void dirty_annot();

	/** Wrapper for `pdf_edit_text_field_value()`.
	
	This method has out-params. Python/C# wrappers look like:
		`edit_text_field_value(const char *value, const char *change)` => `(int, int selStart, int selEnd, char *newvalue)`
	 */
	FZ_FUNCTION int edit_text_field_value(const char *value, const char *change, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *selStart
			#endif
			, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *selEnd
			#endif
			, 
			#ifdef SWIG
				char **OUTPUT
			#else
				char **newvalue
			#endif
			);

	/** Wrapper for `pdf_get_widget_editing_state()`.  */
	FZ_FUNCTION int get_widget_editing_state();

	/** Wrapper for `pdf_new_display_list_from_annot()`.  */
	FZ_FUNCTION DisplayList new_display_list_from_annot();

	/** Wrapper for `pdf_new_pixmap_from_annot()`.  */
	FZ_FUNCTION Pixmap new_pixmap_from_annot(Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha);

	/** Wrapper for `pdf_next_annot()`.  */
	FZ_FUNCTION PdfAnnot next_annot();

	/** Wrapper for `pdf_next_widget()`.  */
	FZ_FUNCTION PdfAnnot next_widget();

	/** Wrapper for `pdf_run_annot()`.  */
	FZ_FUNCTION void run_annot(const Device& dev, Matrix& ctm, Cookie& cookie);

	/** Wrapper for `pdf_set_annot_active()`.  */
	FZ_FUNCTION void set_annot_active(int active);

	/** Wrapper for `pdf_set_annot_appearance()`.  */
	FZ_FUNCTION void set_annot_appearance(const char *appearance, const char *state, Matrix& ctm, Rect& bbox, const PdfObj& res, const Buffer& contents);

	/** Wrapper for `pdf_set_annot_appearance_from_display_list()`.  */
	FZ_FUNCTION void set_annot_appearance_from_display_list(const char *appearance, const char *state, Matrix& ctm, const DisplayList& list);

	/** Wrapper for `pdf_set_annot_author()`.  */
	FZ_FUNCTION void set_annot_author(const char *author);

	/** Wrapper for `pdf_set_annot_border()`.  */
	FZ_FUNCTION void set_annot_border(float width);

	/** Wrapper for `pdf_set_annot_color()`.  */
	FZ_FUNCTION void set_annot_color(int n, const float *color);

	/** Wrapper for `pdf_set_annot_contents()`.  */
	FZ_FUNCTION void set_annot_contents(const char *text);

	/** Wrapper for `pdf_set_annot_creation_date()`.  */
	FZ_FUNCTION void set_annot_creation_date(int64_t time);

	/** Wrapper for `pdf_set_annot_default_appearance()`.  */
	FZ_FUNCTION void set_annot_default_appearance(const char *font, float size, int n, const float *color);

	/** Wrapper for `pdf_set_annot_flags()`.  */
	FZ_FUNCTION void set_annot_flags(int flags);

	/** Wrapper for `pdf_set_annot_hot()`.  */
	FZ_FUNCTION void set_annot_hot(int hot);

	/** Wrapper for `pdf_set_annot_icon_name()`.  */
	FZ_FUNCTION void set_annot_icon_name(const char *name);

	/** Wrapper for `pdf_set_annot_ink_list()`.  */
	FZ_FUNCTION void set_annot_ink_list(int n, const int *count, Point& v);

	/** Wrapper for `pdf_set_annot_interior_color()`.  */
	FZ_FUNCTION void set_annot_interior_color(int n, const float *color);

	/** Wrapper for `pdf_set_annot_is_open()`.  */
	FZ_FUNCTION void set_annot_is_open(int is_open);

	/** Wrapper for `pdf_set_annot_language()`.  */
	FZ_FUNCTION void set_annot_language(fz_text_language lang);

	/** Wrapper for `pdf_set_annot_line()`.  */
	FZ_FUNCTION void set_annot_line(Point& a, Point& b);

	/** Wrapper for `pdf_set_annot_line_end_style()`.  */
	FZ_FUNCTION void set_annot_line_end_style(enum pdf_line_ending e);

	/** Wrapper for `pdf_set_annot_line_ending_styles()`.  */
	FZ_FUNCTION void set_annot_line_ending_styles(enum pdf_line_ending start_style, enum pdf_line_ending end_style);

	/** Wrapper for `pdf_set_annot_line_start_style()`.  */
	FZ_FUNCTION void set_annot_line_start_style(enum pdf_line_ending s);

	/** Wrapper for `pdf_set_annot_modification_date()`.  */
	FZ_FUNCTION void set_annot_modification_date(int64_t time);

	/** Wrapper for `pdf_set_annot_opacity()`.  */
	FZ_FUNCTION void set_annot_opacity(float opacity);

	/** Wrapper for `pdf_set_annot_popup()`.  */
	FZ_FUNCTION void set_annot_popup(Rect& rect);

	/** Wrapper for `pdf_set_annot_quad_points()`.  */
	FZ_FUNCTION void set_annot_quad_points(int n, Quad& qv);

	/** Wrapper for `pdf_set_annot_quadding()`.  */
	FZ_FUNCTION void set_annot_quadding(int q);

	/** Wrapper for `pdf_set_annot_rect()`.  */
	FZ_FUNCTION void set_annot_rect(Rect& rect);

	/** Wrapper for `pdf_set_annot_resynthesised()`.  */
	FZ_FUNCTION void set_annot_resynthesised();

	/** Wrapper for `pdf_set_annot_vertex()`.  */
	FZ_FUNCTION void set_annot_vertex(int i, Point& p);

	/** Wrapper for `pdf_set_annot_vertices()`.  */
	FZ_FUNCTION void set_annot_vertices(int n, Point& v);

	/** Wrapper for `pdf_set_choice_field_value()`.  */
	FZ_FUNCTION int set_choice_field_value(const char *value);

	/** Wrapper for `pdf_set_text_field_value()`.  */
	FZ_FUNCTION int set_text_field_value(const char *value);

	/** Wrapper for `pdf_set_widget_editing_state()`.  */
	FZ_FUNCTION void set_widget_editing_state(int editing);

	/** Wrapper for `pdf_sign_signature()`.  */
	FZ_FUNCTION void sign_signature(const PdfPkcs7Signer& signer, int appearance_flags, const Image& graphic, const char *reason, const char *location);

	/** Wrapper for `pdf_sign_signature_with_appearance()`.  */
	FZ_FUNCTION void sign_signature_with_appearance(const PdfPkcs7Signer& signer, int64_t date, const DisplayList& disp_list);

	/** Wrapper for `pdf_text_widget_format()`.  */
	FZ_FUNCTION int text_widget_format();

	/** Wrapper for `pdf_text_widget_max_len()`.  */
	FZ_FUNCTION int text_widget_max_len();

	/** Wrapper for `pdf_toggle_widget()`.  */
	FZ_FUNCTION int toggle_widget();

	/** Wrapper for `pdf_update_annot()`.  */
	FZ_FUNCTION int update_annot();

	/** Wrapper for `pdf_update_widget()`.  */
	FZ_FUNCTION int update_widget();

	/** Wrapper for `pdf_validate_signature()`.  */
	FZ_FUNCTION int validate_signature();

	/** Wrapper for `pdf_widget_is_readonly()`.  */
	FZ_FUNCTION int widget_is_readonly();

	/** Wrapper for `pdf_widget_is_signed()`.  */
	FZ_FUNCTION int widget_is_signed();

	/** Wrapper for `pdf_widget_type()`.  */
	FZ_FUNCTION enum pdf_widget_type widget_type();

	/** Constructor using raw copy of pre-existing `pdf_annot`. */
	FZ_FUNCTION PdfAnnot(pdf_annot* internal);

	/** Destructor using pdf_drop_annot(). */
	FZ_FUNCTION ~PdfAnnot();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_annot* m_internal;
};

/** Wrapper class for struct `pdf_cmap`. */
struct PdfCmap
{
	/** == Constructors. */

	/** Constructor using `pdf_new_cmap()`. */
	FZ_FUNCTION PdfCmap();

	/** Constructor using `pdf_new_identity_cmap()`. */
	FZ_FUNCTION PdfCmap(int wmode, int bytes);

	/** Copy constructor using `pdf_keep_cmap()`. */
	FZ_FUNCTION PdfCmap(const PdfCmap& rhs);

	/** operator= using `pdf_keep_cmap()` and `pdf_drop_cmap()`. */
	FZ_FUNCTION PdfCmap& operator=(const PdfCmap& rhs);

	/* == Methods. */

	/** Wrapper for `pdf_add_codespace()`.  */
	FZ_FUNCTION void add_codespace(unsigned int low, unsigned int high, size_t n);

	/** Wrapper for `pdf_cmap_size()`.  */
	FZ_FUNCTION size_t cmap_size();

	/** Wrapper for `pdf_cmap_wmode()`.  */
	FZ_FUNCTION int cmap_wmode();

	/** Wrapper for `pdf_decode_cmap()`.
	
	This method has out-params. Python/C# wrappers look like:
		`decode_cmap(unsigned char *s, unsigned char *e)` => `(int, unsigned int cpt)`
	 */
	FZ_FUNCTION int decode_cmap(unsigned char *s, unsigned char *e, 
			#ifdef SWIG
				unsigned int *OUTPUT
			#else
				unsigned int *cpt
			#endif
			);

	/** Wrapper for `pdf_lookup_cmap()`.  */
	FZ_FUNCTION int lookup_cmap(unsigned int cpt);

	/** Wrapper for `pdf_lookup_cmap_full()`.
	
	This method has out-params. Python/C# wrappers look like:
		`lookup_cmap_full(unsigned int cpt)` => `(int, int out)`
	 */
	FZ_FUNCTION int lookup_cmap_full(unsigned int cpt, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *out
			#endif
			);

	/** Wrapper for `pdf_map_one_to_many()`.
	
	This method has out-params. Python/C# wrappers look like:
		`map_one_to_many(unsigned int one, size_t len)` => int many
	 */
	FZ_FUNCTION void map_one_to_many(unsigned int one, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *many
			#endif
			, size_t len);

	/** Wrapper for `pdf_map_range_to_range()`.  */
	FZ_FUNCTION void map_range_to_range(unsigned int srclo, unsigned int srchi, int dstlo);

	/** Wrapper for `pdf_set_cmap_wmode()`.  */
	FZ_FUNCTION void set_cmap_wmode(int wmode);

	/** Wrapper for `pdf_set_usecmap()`.  */
	FZ_FUNCTION void set_usecmap(const PdfCmap& usecmap);

	/** Wrapper for `pdf_sort_cmap()`.  */
	FZ_FUNCTION void sort_cmap();

	/** Constructor using raw copy of pre-existing `pdf_cmap`. */
	FZ_FUNCTION PdfCmap(pdf_cmap* internal);

	/** Destructor using pdf_drop_cmap(). */
	FZ_FUNCTION ~PdfCmap();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_cmap* m_internal;
};

/** Wrapper class for struct `pdf_crypt`. Not copyable or assignable. */
struct PdfCrypt
{
	/** == Constructors. */

	/** Constructor using `pdf_new_crypt()`. */
	FZ_FUNCTION PdfCrypt(const PdfObj& enc, const PdfObj& id);

	/** Constructor using `pdf_new_encrypt()`. */
	FZ_FUNCTION PdfCrypt(const char *opwd_utf8, const char *upwd_utf8, const PdfObj& id, int permissions, int algorithm);

	/* == Methods. */

	/** Wrapper for `pdf_crypt_encrypt_metadata()`.  */
	FZ_FUNCTION int crypt_encrypt_metadata();

	/** Wrapper for `pdf_crypt_key()`.  */
	FZ_FUNCTION unsigned char *crypt_key();

	/** Wrapper for `pdf_crypt_length()`.  */
	FZ_FUNCTION int crypt_length();

	/** Wrapper for `pdf_crypt_method()`.  */
	FZ_FUNCTION char *crypt_method();

	/** Wrapper for `pdf_crypt_obj()`.  */
	FZ_FUNCTION void crypt_obj(const PdfObj& obj, int num, int gen);

	/** Wrapper for `pdf_crypt_owner_encryption()`.  */
	FZ_FUNCTION unsigned char *crypt_owner_encryption();

	/** Wrapper for `pdf_crypt_owner_password()`.  */
	FZ_FUNCTION unsigned char *crypt_owner_password();

	/** Wrapper for `pdf_crypt_permissions()`.  */
	FZ_FUNCTION int crypt_permissions();

	/** Wrapper for `pdf_crypt_permissions_encryption()`.  */
	FZ_FUNCTION unsigned char *crypt_permissions_encryption();

	/** Wrapper for `pdf_crypt_revision()`.  */
	FZ_FUNCTION int crypt_revision();

	/** Wrapper for `pdf_crypt_user_encryption()`.  */
	FZ_FUNCTION unsigned char *crypt_user_encryption();

	/** Wrapper for `pdf_crypt_user_password()`.  */
	FZ_FUNCTION unsigned char *crypt_user_password();

	/** Wrapper for `pdf_crypt_version()`.  */
	FZ_FUNCTION int crypt_version();

	/** Wrapper for `pdf_encrypt_data()`.  */
	FZ_FUNCTION void encrypt_data(int num, int gen, void (*fmt_str_out)(fz_context *, void *, const unsigned char *, size_t ), void *arg, const unsigned char *s, size_t n);

	/** Wrapper for `pdf_encrypted_len()`.  */
	FZ_FUNCTION size_t encrypted_len(int num, int gen, size_t len);

	/** Constructor using raw copy of pre-existing `pdf_crypt`. */
	FZ_FUNCTION PdfCrypt(pdf_crypt* internal);

	/** Destructor using pdf_drop_crypt(). */
	FZ_FUNCTION ~PdfCrypt();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_crypt* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfCrypt(const PdfCrypt& rhs);
	PdfCrypt& operator=(const PdfCrypt& rhs);
};

/** Wrapper class for struct `pdf_csi`. Not copyable or assignable. */
struct PdfCsi
{
	/** Constructor using raw copy of pre-existing `pdf_csi`. */
	FZ_FUNCTION PdfCsi(pdf_csi* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_csi* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfCsi(const PdfCsi& rhs);
	PdfCsi& operator=(const PdfCsi& rhs);
};

/** Wrapper class for struct `pdf_doc_event`. Not copyable or assignable. */
struct PdfDocEvent
{
	/* == Methods. */

	/** Wrapper for `pdf_access_exec_menu_item_event()`.  */
	FZ_FUNCTION const char *access_exec_menu_item_event();

	/** Constructor using raw copy of pre-existing `pdf_doc_event`. */
	FZ_FUNCTION PdfDocEvent(pdf_doc_event* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_doc_event* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfDocEvent(const PdfDocEvent& rhs);
	PdfDocEvent& operator=(const PdfDocEvent& rhs);
};

/** Wrapper class for struct `pdf_document`. */
struct PdfDocument
{
	/** == Constructors. */

	/** Constructor using `pdf_create_document()`. */
	FZ_FUNCTION PdfDocument();

	/** Constructor using `pdf_document_from_fz_document()`. */
	FZ_FUNCTION PdfDocument(const Document& ptr);

	/** Constructor using `pdf_open_document()`. */
	FZ_FUNCTION PdfDocument(const char *filename);

	/** Constructor using `pdf_open_document_with_stream()`. */
	FZ_FUNCTION PdfDocument(const Stream& file);

	/** Copy constructor using `pdf_keep_document()`. */
	FZ_FUNCTION PdfDocument(const PdfDocument& rhs);

	/** operator= using `pdf_keep_document()` and `pdf_drop_document()`. */
	FZ_FUNCTION PdfDocument& operator=(const PdfDocument& rhs);

	/* == Methods. */

	/** Wrapper for `pdf_add_cid_font()`.  */
	FZ_FUNCTION PdfObj add_cid_font(const Font& font);

	/** Wrapper for `pdf_add_cjk_font()`.  */
	FZ_FUNCTION PdfObj add_cjk_font(const Font& font, int script, int wmode, int serif);

	/** Wrapper for `pdf_add_embedded_file()`.  */
	FZ_FUNCTION PdfObj add_embedded_file(const char *filename, const char *mimetype, const Buffer& contents);

	/** Wrapper for `pdf_add_image()`.  */
	FZ_FUNCTION PdfObj add_image(const Image& image);

	/** Wrapper for `pdf_add_journal_fragment()`.  */
	FZ_FUNCTION void add_journal_fragment(int parent, const PdfObj& copy, const Buffer& copy_stream, int newobj);

	/** Wrapper for `pdf_add_new_array()`.  */
	FZ_FUNCTION PdfObj add_new_array(int initial);

	/** Wrapper for `pdf_add_new_dict()`.  */
	FZ_FUNCTION PdfObj add_new_dict(int initial);

	/** Wrapper for `pdf_add_object()`.  */
	FZ_FUNCTION PdfObj add_object(const PdfObj& obj);

	/** Wrapper for `pdf_add_page()`.  */
	FZ_FUNCTION PdfObj add_page(Rect& mediabox, int rotate, const PdfObj& resources, const Buffer& contents);

	/** Wrapper for `pdf_add_simple_font()`.  */
	FZ_FUNCTION PdfObj add_simple_font(const Font& font, int encoding);

	/** Wrapper for `pdf_add_stream()`.  */
	FZ_FUNCTION PdfObj add_stream(const Buffer& buf, const PdfObj& obj, int compressed);

	/** Wrapper for `pdf_add_substitute_font()`.  */
	FZ_FUNCTION PdfObj add_substitute_font(const Font& font);

	/** Wrapper for `pdf_annot_field_event_keystroke()`.  */
	FZ_FUNCTION int annot_field_event_keystroke(const PdfAnnot& annot, const PdfKeystrokeEvent& evt);

	/** Wrapper for `pdf_authenticate_password()`.  */
	FZ_FUNCTION int authenticate_password(const char *pw);

	/** Wrapper for `pdf_begin_implicit_operation()`.  */
	FZ_FUNCTION void begin_implicit_operation();

	/** Wrapper for `pdf_begin_operation()`.  */
	FZ_FUNCTION void begin_operation(const char *operation);

	/** Wrapper for `pdf_calculate_form()`.  */
	FZ_FUNCTION void calculate_form();

	/** Wrapper for `pdf_can_be_saved_incrementally()`.  */
	FZ_FUNCTION int can_be_saved_incrementally();

	/** Wrapper for `pdf_can_redo()`.  */
	FZ_FUNCTION int can_redo();

	/** Wrapper for `pdf_can_undo()`.  */
	FZ_FUNCTION int can_undo();

	/** Wrapper for `pdf_clear_xref()`.  */
	FZ_FUNCTION void clear_xref();

	/** Wrapper for `pdf_clear_xref_to_mark()`.  */
	FZ_FUNCTION void clear_xref_to_mark();

	/** Wrapper for `pdf_count_layer_config_ui()`.  */
	FZ_FUNCTION int count_layer_config_ui();

	/** Wrapper for `pdf_count_layer_configs()`.  */
	FZ_FUNCTION int count_layer_configs();

	/** Wrapper for `pdf_count_objects()`.  */
	FZ_FUNCTION int count_objects();

	/** Wrapper for `pdf_count_pages()`.  */
	FZ_FUNCTION int count_pages();

	/** Wrapper for `pdf_count_signatures()`.  */
	FZ_FUNCTION int count_signatures();

	/** Wrapper for `pdf_count_unsaved_versions()`.  */
	FZ_FUNCTION int count_unsaved_versions();

	/** Wrapper for `pdf_count_versions()`.  */
	FZ_FUNCTION int count_versions();

	/** Wrapper for `pdf_create_field_name()`.  */
	FZ_FUNCTION void create_field_name(const char *prefix, char *buf, size_t len);

	/** Wrapper for `pdf_create_object()`.  */
	FZ_FUNCTION int create_object();

	/** Wrapper for `pdf_debug_doc_changes()`.  */
	FZ_FUNCTION void debug_doc_changes();

	/** Wrapper for `pdf_delete_object()`.  */
	FZ_FUNCTION void delete_object(int num);

	/** Wrapper for `pdf_delete_page()`.  */
	FZ_FUNCTION void delete_page(int number);

	/** Wrapper for `pdf_delete_page_range()`.  */
	FZ_FUNCTION void delete_page_range(int start, int end);

	/** Wrapper for `pdf_deselect_layer_config_ui()`.  */
	FZ_FUNCTION void deselect_layer_config_ui(int ui);

	/** Wrapper for `pdf_deserialise_journal()`.  */
	FZ_FUNCTION void deserialise_journal(const Stream& stm);

	/** Wrapper for `pdf_disable_js()`.  */
	FZ_FUNCTION void disable_js();

	/** Wrapper for `pdf_doc_was_linearized()`.  */
	FZ_FUNCTION int doc_was_linearized();

	/** Wrapper for `pdf_document_event_did_print()`.  */
	FZ_FUNCTION void document_event_did_print();

	/** Wrapper for `pdf_document_event_did_save()`.  */
	FZ_FUNCTION void document_event_did_save();

	/** Wrapper for `pdf_document_event_will_close()`.  */
	FZ_FUNCTION void document_event_will_close();

	/** Wrapper for `pdf_document_event_will_print()`.  */
	FZ_FUNCTION void document_event_will_print();

	/** Wrapper for `pdf_document_event_will_save()`.  */
	FZ_FUNCTION void document_event_will_save();

	/** Wrapper for `pdf_document_output_intent()`.  */
	FZ_FUNCTION Colorspace document_output_intent();

	/** Wrapper for `pdf_document_permissions()`.  */
	FZ_FUNCTION int document_permissions();

	/** Wrapper for `pdf_empty_store()`.  */
	FZ_FUNCTION void empty_store();

	/** Wrapper for `pdf_enable_journal()`.  */
	FZ_FUNCTION void enable_journal();

	/** Wrapper for `pdf_enable_js()`.  */
	FZ_FUNCTION void enable_js();

	/** Wrapper for `pdf_end_operation()`.  */
	FZ_FUNCTION void end_operation();

	/** Wrapper for `pdf_ensure_solid_xref()`.  */
	FZ_FUNCTION void ensure_solid_xref(int num);

	/** Wrapper for `pdf_event_issue_alert()`.  */
	FZ_FUNCTION void event_issue_alert(const PdfAlertEvent& evt);

	/** Wrapper for `pdf_event_issue_exec_menu_item()`.  */
	FZ_FUNCTION void event_issue_exec_menu_item(const char *item);

	/** Wrapper for `pdf_event_issue_launch_url()`.  */
	FZ_FUNCTION void event_issue_launch_url(const char *url, int new_frame);

	/** Wrapper for `pdf_event_issue_mail_doc()`.  */
	FZ_FUNCTION void event_issue_mail_doc(const PdfMailDocEvent& evt);

	/** Wrapper for `pdf_event_issue_print()`.  */
	FZ_FUNCTION void event_issue_print();

	/** Wrapper for `pdf_field_event_calculate()`.  */
	FZ_FUNCTION void field_event_calculate(const PdfObj& field);

	/** Wrapper for `pdf_field_event_format()`.  */
	FZ_FUNCTION char *field_event_format(const PdfObj& field);

	/** Wrapper for `pdf_field_event_keystroke()`.  */
	FZ_FUNCTION int field_event_keystroke(const PdfObj& field, const PdfKeystrokeEvent& evt);

	/** Wrapper for `pdf_field_event_validate()`.
	
	This method has out-params. Python/C# wrappers look like:
		`field_event_validate(pdf_obj *field, const char *value)` => `(int, char *newvalue)`
	 */
	FZ_FUNCTION int field_event_validate(const PdfObj& field, const char *value, 
			#ifdef SWIG
				char **OUTPUT
			#else
				char **newvalue
			#endif
			);

	/** Wrapper for `pdf_field_reset()`.  */
	FZ_FUNCTION void field_reset(const PdfObj& field);

	/** Wrapper for `pdf_filter_annot_contents()`.  */
	FZ_FUNCTION void filter_annot_contents(const PdfAnnot& annot, PdfFilterOptions& filter);

	/** Wrapper for `pdf_filter_page_contents()`.  */
	FZ_FUNCTION void filter_page_contents(const PdfPage& page, PdfFilterOptions& filter);

	/** Wrapper for `pdf_find_font_resource()`.  */
	FZ_FUNCTION PdfObj find_font_resource(int type, int encoding, const Font& item, const PdfFontResourceKey& key);

	/** Wrapper for `pdf_find_version_for_obj()`.  */
	FZ_FUNCTION int find_version_for_obj(const PdfObj& obj);

	/** Wrapper for `pdf_forget_xref()`.  */
	FZ_FUNCTION void forget_xref();

	/** Wrapper for `pdf_get_doc_event_callback_data()`.  */
	FZ_FUNCTION void *get_doc_event_callback_data();

	/** Wrapper for `pdf_graft_object()`.  */
	FZ_FUNCTION PdfObj graft_object(const PdfObj& obj);

	/** Wrapper for `pdf_graft_page()`.  */
	FZ_FUNCTION void graft_page(int page_to, const PdfDocument& src, int page_from);

	/** Wrapper for `pdf_has_permission()`.  */
	FZ_FUNCTION int has_permission(fz_permission p);

	/** Wrapper for `pdf_has_unsaved_changes()`.  */
	FZ_FUNCTION int has_unsaved_changes();

	/** Wrapper for `pdf_has_unsaved_sigs()`.  */
	FZ_FUNCTION int has_unsaved_sigs();

	/** Wrapper for `pdf_insert_font_resource()`.  */
	FZ_FUNCTION PdfObj insert_font_resource(const PdfFontResourceKey& key, const PdfObj& obj);

	/** Wrapper for `pdf_insert_page()`.  */
	FZ_FUNCTION void insert_page(int at, const PdfObj& page);

	/** Wrapper for `pdf_invalidate_xfa()`.  */
	FZ_FUNCTION void invalidate_xfa();

	/** Wrapper for `pdf_is_local_object()`.  */
	FZ_FUNCTION int is_local_object(const PdfObj& obj);

	/** Wrapper for `pdf_is_ocg_hidden()`.  */
	FZ_FUNCTION int is_ocg_hidden(const PdfObj& rdb, const char *usage, const PdfObj& ocg);

	/** Wrapper for `pdf_js_set_console()`.  */
	FZ_FUNCTION void js_set_console(const PdfJsConsole& console, void *user);

	/** Wrapper for `pdf_js_supported()`.  */
	FZ_FUNCTION int js_supported();

	/** Wrapper for `pdf_layer_config_info()`.  */
	FZ_FUNCTION void layer_config_info(int config_num, PdfLayerConfig& info);

	/** Wrapper for `pdf_layer_config_ui_info()`.  */
	FZ_FUNCTION void layer_config_ui_info(int ui, PdfLayerConfigUi& info);

	/** Wrapper for `pdf_load_compressed_inline_image()`.  */
	FZ_FUNCTION void load_compressed_inline_image(const PdfObj& dict, int length, const Stream& cstm, int indexed, const CompressedImage& image);

	/** Wrapper for `pdf_load_default_colorspaces()`.  */
	FZ_FUNCTION DefaultColorspaces load_default_colorspaces(const PdfPage& page);

	/** Wrapper for `pdf_load_embedded_cmap()`.  */
	FZ_FUNCTION PdfCmap load_embedded_cmap(const PdfObj& ref);

	/** Wrapper for `pdf_load_image()`.  */
	FZ_FUNCTION Image load_image(const PdfObj& obj);

	/** Wrapper for `pdf_load_inline_image()`.  */
	FZ_FUNCTION Image load_inline_image(const PdfObj& rdb, const PdfObj& dict, const Stream& file);

	/** Wrapper for `pdf_load_journal()`.  */
	FZ_FUNCTION void load_journal(const char *filename);

	/** Wrapper for `pdf_load_link_annots()`.  */
	FZ_FUNCTION Link load_link_annots(const PdfObj& annots, int pagenum, Matrix& page_ctm);

	/** Wrapper for `pdf_load_name_tree()`.  */
	FZ_FUNCTION PdfObj load_name_tree(const PdfObj& which);

	/** Wrapper for `pdf_load_object()`.  */
	FZ_FUNCTION PdfObj load_object(int num);

	/** Wrapper for `pdf_load_outline()`.  */
	FZ_FUNCTION Outline load_outline();

	/** Wrapper for `pdf_load_page()`.  */
	FZ_FUNCTION PdfPage load_page(int number);

	/** Wrapper for `pdf_load_page_tree()`.  */
	FZ_FUNCTION void load_page_tree();

	/** Wrapper for `pdf_load_pattern()`.  */
	FZ_FUNCTION PdfPattern load_pattern(const PdfObj& obj);

	/** Wrapper for `pdf_load_raw_stream_number()`.  */
	FZ_FUNCTION Buffer load_raw_stream_number(int num);

	/** Wrapper for `pdf_load_shading()`.  */
	FZ_FUNCTION Shade load_shading(const PdfObj& obj);

	/** Wrapper for `pdf_load_stream_number()`.  */
	FZ_FUNCTION Buffer load_stream_number(int num);

	/** Wrapper for `pdf_load_to_unicode()`.
	
	This method has out-params. Python/C# wrappers look like:
		`load_to_unicode(pdf_font_desc *font, char *collection, pdf_obj *cmapstm)` => const char *strings
	 */
	FZ_FUNCTION void load_to_unicode(const PdfFontDesc& font, 
			#ifdef SWIG
				const char **OUTPUT
			#else
				const char **strings
			#endif
			, char *collection, const PdfObj& cmapstm);

	/** Wrapper for `pdf_load_type3_glyphs()`.  */
	FZ_FUNCTION void load_type3_glyphs(const PdfFontDesc& fontdesc);

	/** Wrapper for `pdf_load_unencrypted_object()`.  */
	FZ_FUNCTION PdfObj load_unencrypted_object(int num);

	/** Wrapper for `pdf_lookup_anchor()`.
	
	This method has out-params. Python/C# wrappers look like:
		`lookup_anchor(const char *name)` => `(int, float xp, float yp)`
	 */
	FZ_FUNCTION int lookup_anchor(const char *name, 
			#ifdef SWIG
				float *OUTPUT
			#else
				float *xp
			#endif
			, 
			#ifdef SWIG
				float *OUTPUT
			#else
				float *yp
			#endif
			);

	/** Wrapper for `pdf_lookup_dest()`.  */
	FZ_FUNCTION PdfObj lookup_dest(const PdfObj& needle);

	/** Wrapper for `pdf_lookup_metadata()`.  */
	FZ_FUNCTION int lookup_metadata(const char *key, char *ptr, int size);

	/** Wrapper for `pdf_lookup_name()`.  */
	FZ_FUNCTION PdfObj lookup_name(const PdfObj& which, const PdfObj& needle);

	/** Wrapper for `pdf_lookup_page_number()`.  */
	FZ_FUNCTION int lookup_page_number(const PdfObj& pageobj);

	/** Wrapper for `pdf_lookup_page_obj()`.  */
	FZ_FUNCTION PdfObj lookup_page_obj(int needle);

	/** Wrapper for `pdf_mark_xref()`.  */
	FZ_FUNCTION void mark_xref();

	/** Wrapper for `pdf_metadata()`.  */
	FZ_FUNCTION PdfObj metadata();

	/** Wrapper for `pdf_needs_password()`.  */
	FZ_FUNCTION int needs_password();

	/** Wrapper for `pdf_new_action_from_link()`.  */
	FZ_FUNCTION PdfObj new_action_from_link(const char *uri);

	/** Wrapper for `pdf_new_array()`.  */
	FZ_FUNCTION PdfObj new_array(int initialcap);

	/** Wrapper for `pdf_new_date()`.  */
	FZ_FUNCTION PdfObj new_date(int64_t time);

	/** Wrapper for `pdf_new_destination_from_link()`.  */
	FZ_FUNCTION PdfObj new_destination_from_link(const char *uri);

	/** Wrapper for `pdf_new_dict()`.  */
	FZ_FUNCTION PdfObj new_dict(int initialcap);

	/** Wrapper for `pdf_new_filter_processor()`.  */
	FZ_FUNCTION PdfProcessor new_filter_processor(const PdfProcessor& chain, const PdfObj& old_res, const PdfObj& new_res, int struct_parents, Matrix& transform, PdfFilterOptions& filter);

	/** Wrapper for `pdf_new_graft_map()`.  */
	FZ_FUNCTION PdfGraftMap new_graft_map();

	/** Wrapper for `pdf_new_indirect()`.  */
	FZ_FUNCTION PdfObj new_indirect(int num, int gen);

	/** Wrapper for `pdf_new_matrix()`.  */
	FZ_FUNCTION PdfObj new_matrix(Matrix& mtx);

	/** Wrapper for `pdf_new_pdf_device()`.  */
	FZ_FUNCTION Device new_pdf_device(Matrix& topctm, const PdfObj& resources, const Buffer& contents);

	/** Wrapper for `pdf_new_rect()`.  */
	FZ_FUNCTION PdfObj new_rect(Rect& rect);

	/** Wrapper for `pdf_new_xobject()`.  */
	FZ_FUNCTION PdfObj new_xobject(Rect& bbox, Matrix& matrix, const PdfObj& res, const Buffer& buffer);

	/** Wrapper for `pdf_obj_num_is_stream()`.  */
	FZ_FUNCTION int obj_num_is_stream(int num);

	/** Wrapper for `pdf_open_contents_stream()`.  */
	FZ_FUNCTION Stream open_contents_stream(const PdfObj& obj);

	/** Wrapper for `pdf_open_inline_stream()`.  */
	FZ_FUNCTION Stream open_inline_stream(const PdfObj& stmobj, int length, const Stream& chain, const CompressionParams& params);

	/** Wrapper for `pdf_open_raw_stream_number()`.  */
	FZ_FUNCTION Stream open_raw_stream_number(int num);

	/** Wrapper for `pdf_open_stream_number()`.  */
	FZ_FUNCTION Stream open_stream_number(int num);

	/** Wrapper for `pdf_open_stream_with_offset()`.  */
	FZ_FUNCTION Stream open_stream_with_offset(int num, const PdfObj& dict, int64_t stm_ofs);

	/** Wrapper for `pdf_page_write()`.
	
	This method has out-params. Python/C# wrappers look like:
		`page_write(fz_rect mediabox, pdf_obj **presources, fz_buffer **pcontents)` => `(fz_device *)`
	 */
	FZ_FUNCTION Device page_write(Rect& mediabox, PdfObj& presources, Buffer& pcontents);

	/** Wrapper for `pdf_parse_array()`.  */
	FZ_FUNCTION PdfObj parse_array(const Stream& f, const PdfLexbuf& buf);

	/** Wrapper for `pdf_parse_dict()`.  */
	FZ_FUNCTION PdfObj parse_dict(const Stream& f, const PdfLexbuf& buf);

	/** Wrapper for `pdf_parse_ind_obj()`.
	
	This method has out-params. Python/C# wrappers look like:
		`parse_ind_obj(fz_stream *f)` => `(pdf_obj *, int num, int gen, int64_t stm_ofs, int try_repair)`
	 */
	FZ_FUNCTION PdfObj parse_ind_obj(const Stream& f, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *num
			#endif
			, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *gen
			#endif
			, 
			#ifdef SWIG
				int64_t *OUTPUT
			#else
				int64_t *stm_ofs
			#endif
			, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *try_repair
			#endif
			);

	/** Wrapper for `pdf_parse_journal_obj()`.
	
	This method has out-params. Python/C# wrappers look like:
		`parse_journal_obj(fz_stream *stm, fz_buffer **ostm)` => `(pdf_obj *, int onum, int newobj)`
	 */
	FZ_FUNCTION PdfObj parse_journal_obj(const Stream& stm, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *onum
			#endif
			, Buffer& ostm, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *newobj
			#endif
			);

	/** Wrapper for `pdf_parse_link_action()`.  */
	FZ_FUNCTION char *parse_link_action(const PdfObj& obj, int pagenum);

	/** Wrapper for `pdf_parse_link_dest()`.  */
	FZ_FUNCTION char *parse_link_dest(const PdfObj& obj);

	/** Wrapper for `pdf_parse_stm_obj()`.  */
	FZ_FUNCTION PdfObj parse_stm_obj(const Stream& f, const PdfLexbuf& buf);

	/** Wrapper for `pdf_progressive_advance()`.  */
	FZ_FUNCTION PdfObj progressive_advance(int pagenum);

	/** Wrapper for `pdf_purge_local_font_resources()`.  */
	FZ_FUNCTION void purge_local_font_resources();

	/** Wrapper for `pdf_purge_locals_from_store()`.  */
	FZ_FUNCTION void purge_locals_from_store();

	/** Wrapper for `pdf_read_journal()`.  */
	FZ_FUNCTION void read_journal(const Stream& stm);

	/** Wrapper for `pdf_redact_page()`.  */
	FZ_FUNCTION int redact_page(const PdfPage& page, PdfRedactOptions& opts);

	/** Wrapper for `pdf_redo()`.  */
	FZ_FUNCTION void redo();

	/** Wrapper for `pdf_repair_obj()`.
	
	This method has out-params. Python/C# wrappers look like:
		`repair_obj(pdf_lexbuf *buf, pdf_obj **encrypt, pdf_obj **id, pdf_obj **page, pdf_obj **root)` => `(int, int64_t stmofsp, int stmlenp, int64_t tmpofs)`
	 */
	FZ_FUNCTION int repair_obj(const PdfLexbuf& buf, 
			#ifdef SWIG
				int64_t *OUTPUT
			#else
				int64_t *stmofsp
			#endif
			, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *stmlenp
			#endif
			, PdfObj& encrypt, PdfObj& id, PdfObj& page, 
			#ifdef SWIG
				int64_t *OUTPUT
			#else
				int64_t *tmpofs
			#endif
			, PdfObj& root);

	/** Wrapper for `pdf_repair_obj_stms()`.  */
	FZ_FUNCTION void repair_obj_stms();

	/** Wrapper for `pdf_repair_trailer()`.  */
	FZ_FUNCTION void repair_trailer();

	/** Wrapper for `pdf_repair_xref()`.  */
	FZ_FUNCTION void repair_xref();

	/** Wrapper for `pdf_replace_xref()`.  */
	FZ_FUNCTION void replace_xref(const PdfXrefEntry& entries, int n);

	/** Wrapper for `pdf_reset_form()`.  */
	FZ_FUNCTION void reset_form(const PdfObj& fields, int exclude);

	/** Wrapper for `pdf_resolve_link()`.
	
	This method has out-params. Python/C# wrappers look like:
		`resolve_link(const char *uri)` => `(int, float xp, float yp)`
	 */
	FZ_FUNCTION int resolve_link(const char *uri, 
			#ifdef SWIG
				float *OUTPUT
			#else
				float *xp
			#endif
			, 
			#ifdef SWIG
				float *OUTPUT
			#else
				float *yp
			#endif
			);

	/** Wrapper for `pdf_run_glyph()`.  */
	FZ_FUNCTION void run_glyph(const PdfObj& resources, const Buffer& contents, const Device& dev, Matrix& ctm, void *gstate, const DefaultColorspaces& default_cs);

	/** Wrapper for `pdf_save_document()`.  */
	FZ_FUNCTION void save_document(const char *filename, PdfWriteOptions& opts);

	/** Wrapper for `pdf_save_journal()`.  */
	FZ_FUNCTION void save_journal(const char *filename);

	/** Wrapper for `pdf_save_snapshot()`.  */
	FZ_FUNCTION void save_snapshot(const char *filename);

	/** Wrapper for `pdf_select_layer_config()`.  */
	FZ_FUNCTION void select_layer_config(int config_num);

	/** Wrapper for `pdf_select_layer_config_ui()`.  */
	FZ_FUNCTION void select_layer_config_ui(int ui);

	/** Wrapper for `pdf_serialise_journal()`.  */
	FZ_FUNCTION void serialise_journal(const Output& out);

	/** Wrapper for `pdf_set_annot_field_value()`.  */
	FZ_FUNCTION int set_annot_field_value(const PdfAnnot& widget, const char *text, int ignore_trigger_events);

	/** Wrapper for `pdf_set_doc_event_callback()`.  */
	FZ_FUNCTION void set_doc_event_callback(pdf_doc_event_cb *event_cb, pdf_free_doc_event_data_cb *free_event_data_cb, void *data);

	/** Wrapper for `pdf_set_document_language()`.  */
	FZ_FUNCTION void set_document_language(fz_text_language lang);

	/** Wrapper for `pdf_set_field_value()`.  */
	FZ_FUNCTION int set_field_value(const PdfObj& field, const char *text, int ignore_trigger_events);

	/** Wrapper for `pdf_set_layer_config_as_default()`.  */
	FZ_FUNCTION void set_layer_config_as_default();

	/** Wrapper for `pdf_set_populating_xref_trailer()`.  */
	FZ_FUNCTION void set_populating_xref_trailer(const PdfObj& trailer);

	/** Wrapper for `pdf_signature_byte_range()`.  */
	FZ_FUNCTION int signature_byte_range(const PdfObj& signature, const Range& byte_range);

	/** Wrapper for `pdf_signature_contents()`.
	
	This method has out-params. Python/C# wrappers look like:
		`signature_contents(pdf_obj *signature)` => `(size_t, char *contents)`
	 */
	FZ_FUNCTION size_t signature_contents(const PdfObj& signature, 
			#ifdef SWIG
				char **OUTPUT
			#else
				char **contents
			#endif
			);

	/** Wrapper for `pdf_signature_hash_bytes()`.  */
	FZ_FUNCTION Stream signature_hash_bytes(const PdfObj& signature);

	/** Wrapper for `pdf_signature_incremental_change_since_signing()`.  */
	FZ_FUNCTION int signature_incremental_change_since_signing(const PdfObj& signature);

	/** Wrapper for `pdf_signature_is_signed()`.  */
	FZ_FUNCTION int signature_is_signed(const PdfObj& field);

	/** Wrapper for `pdf_signature_set_value()`.  */
	FZ_FUNCTION void signature_set_value(const PdfObj& field, const PdfPkcs7Signer& signer, int64_t stime);

	/** Wrapper for `pdf_toggle_layer_config_ui()`.  */
	FZ_FUNCTION void toggle_layer_config_ui(int ui);

	/** Wrapper for `pdf_trailer()`.  */
	FZ_FUNCTION PdfObj trailer();

	/** Wrapper for `pdf_undo()`.  */
	FZ_FUNCTION void undo();

	/** Wrapper for `pdf_undoredo_state()`.
	
	This method has out-params. Python/C# wrappers look like:
		`undoredo_state()` => `(int, int steps)`
	 */
	FZ_FUNCTION int undoredo_state(
			#ifdef SWIG
				int *OUTPUT
			#else
				int *steps
			#endif
			);

	/** Wrapper for `pdf_undoredo_step()`.  */
	FZ_FUNCTION const char *undoredo_step(int step);

	/** Wrapper for `pdf_update_object()`.  */
	FZ_FUNCTION void update_object(int num, const PdfObj& obj);

	/** Wrapper for `pdf_update_stream()`.  */
	FZ_FUNCTION void update_stream(const PdfObj& ref, const Buffer& buf, int compressed);

	/** Wrapper for `pdf_update_xobject()`.  */
	FZ_FUNCTION void update_xobject(const PdfObj& xobj, Rect& bbox, Matrix& mat, const PdfObj& res, const Buffer& buffer);

	/** Wrapper for `pdf_validate_change_history()`.  */
	FZ_FUNCTION int validate_change_history();

	/** Wrapper for `pdf_validate_changes()`.  */
	FZ_FUNCTION int validate_changes(int version);

	/** Wrapper for `pdf_version()`.  */
	FZ_FUNCTION int version();

	/** Wrapper for `pdf_was_pure_xfa()`.  */
	FZ_FUNCTION int was_pure_xfa();

	/** Wrapper for `pdf_was_repaired()`.  */
	FZ_FUNCTION int was_repaired();

	/** Wrapper for `pdf_write_document()`.  */
	FZ_FUNCTION void write_document(const Output& out, PdfWriteOptions& opts);

	/** Wrapper for `pdf_write_journal()`.  */
	FZ_FUNCTION void write_journal(const Output& out);

	/** Wrapper for `pdf_write_snapshot()`.  */
	FZ_FUNCTION void write_snapshot(const Output& out);

	/** Wrapper for `pdf_xref_ensure_incremental_object()`.  */
	FZ_FUNCTION int xref_ensure_incremental_object(int num);

	/** Wrapper for `pdf_xref_ensure_local_object()`.  */
	FZ_FUNCTION void xref_ensure_local_object(int num);

	/** Wrapper for `pdf_xref_is_incremental()`.  */
	FZ_FUNCTION int xref_is_incremental(int num);

	/** Wrapper for `pdf_xref_len()`.  */
	FZ_FUNCTION int xref_len();

	/** Wrapper for `pdf_xref_obj_is_unsaved_signature()`.  */
	FZ_FUNCTION int xref_obj_is_unsaved_signature(const PdfObj& obj);

	/** Wrapper for `pdf_xref_remove_unsaved_signature()`.  */
	FZ_FUNCTION void xref_remove_unsaved_signature(const PdfObj& field);

	/** Wrapper for `pdf_xref_store_unsaved_signature()`.  */
	FZ_FUNCTION void xref_store_unsaved_signature(const PdfObj& field, const PdfPkcs7Signer& signer);

	/** Wrapper for pdf_lookup_metadata() that returns a std::string and sets
	*o_out to length of string plus one. If <key> is not found, returns empty
	string with *o_out=-1. <o_out> can be NULL if caller is not interested in
	error information. */
	FZ_FUNCTION std::string lookup_metadata(const char* key, int* o_out=NULL);

	/** Returns wrapper for .super member. */
	FZ_FUNCTION Document super();

	/** Constructor using raw copy of pre-existing `pdf_document`. */
	FZ_FUNCTION PdfDocument(pdf_document* internal);

	/** Destructor using pdf_drop_document(). */
	FZ_FUNCTION ~PdfDocument();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_document* m_internal;
};

/** Wrapper class for struct `pdf_filter_options`. */
struct PdfFilterOptions
{
	/** Default constructor initialises all fields to null/zero. */
	FZ_FUNCTION PdfFilterOptions();

	/** We use default copy constructor and operator=. */

	/** Constructor using raw copy of pre-existing `pdf_filter_options`. */
	FZ_FUNCTION PdfFilterOptions(const pdf_filter_options* internal);

	/** Constructor using raw copy of pre-existing `pdf_filter_options`. */
	FZ_FUNCTION PdfFilterOptions(const pdf_filter_options internal);

	/** Access as underlying struct. */
	FZ_FUNCTION pdf_filter_options* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const pdf_filter_options* internal() const;

	/** We use default destructor. */

	/* == Member data. */

	/* These members are the same as the members of pdf_filter_options. */
	void *opaque;
	fz_image *(*image_filter)(fz_context *, void *, fz_matrix , const char *, fz_image *);
	int (*text_filter)(fz_context *, void *, int *, int , fz_matrix , fz_matrix , fz_rect );
	void (*after_text_object)(fz_context *, void *, pdf_document *, pdf_processor *, fz_matrix );
	void (*end_page)(fz_context *, fz_buffer *, void *);
	int recurse;
	int instance_forms;
	int sanitize;
	int ascii;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();
};

/** Writes a PdfFilterOptions's underlying pdf_filter_options's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const PdfFilterOptions& rhs);

/** Wrapper class for struct pdf_filter_options with virtual fns for each fnptr; this is for use as a SWIG Director class. */
struct PdfFilterOptions2 : PdfFilterOptions
{

	/** == Constructor. */
	FZ_FUNCTION PdfFilterOptions2();

	/** These methods set the function pointers in *m_internal
	to point to internal callbacks that call our virtual methods. */
	FZ_FUNCTION void use_virtual_image_filter( bool use=true);
	FZ_FUNCTION void use_virtual_text_filter( bool use=true);
	FZ_FUNCTION void use_virtual_after_text_object( bool use=true);
	FZ_FUNCTION void use_virtual_end_page( bool use=true);

	/** Default virtual method implementations; these all throw an exception. */
	FZ_FUNCTION virtual struct fz_image * image_filter(fz_matrix arg_2, const char *arg_3, struct fz_image *arg_4);
	FZ_FUNCTION virtual int text_filter(int *arg_2, int arg_3, fz_matrix arg_4, fz_matrix arg_5, fz_rect arg_6);
	FZ_FUNCTION virtual void after_text_object(struct pdf_document *arg_2, struct pdf_processor *arg_3, fz_matrix arg_4);
	FZ_FUNCTION virtual void end_page(void *arg_2);
};

/** Wrapper class for struct `pdf_font_desc`. Not copyable or assignable. */
struct PdfFontDesc
{
	/** == Constructors. */

	/** Constructor using `pdf_new_font_desc()`. */
	FZ_FUNCTION PdfFontDesc();

	/* == Methods. */

	/** Wrapper for `pdf_add_hmtx()`.  */
	FZ_FUNCTION void add_hmtx(int lo, int hi, int w);

	/** Wrapper for `pdf_add_vmtx()`.  */
	FZ_FUNCTION void add_vmtx(int lo, int hi, int x, int y, int w);

	/** Wrapper for `pdf_end_hmtx()`.  */
	FZ_FUNCTION void end_hmtx();

	/** Wrapper for `pdf_end_vmtx()`.  */
	FZ_FUNCTION void end_vmtx();

	/** Wrapper for `pdf_font_cid_to_gid()`.  */
	FZ_FUNCTION int font_cid_to_gid(int cid);

	/** Wrapper for `pdf_set_default_hmtx()`.  */
	FZ_FUNCTION void set_default_hmtx(int w);

	/** Wrapper for `pdf_set_default_vmtx()`.  */
	FZ_FUNCTION void set_default_vmtx(int y, int w);

	/** Wrapper for `pdf_set_font_wmode()`.  */
	FZ_FUNCTION void set_font_wmode(int wmode);

	/** Constructor using raw copy of pre-existing `pdf_font_desc`. */
	FZ_FUNCTION PdfFontDesc(pdf_font_desc* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_font_desc* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfFontDesc(const PdfFontDesc& rhs);
	PdfFontDesc& operator=(const PdfFontDesc& rhs);
};

/** Wrapper class for struct `pdf_font_resource_key`. Not copyable or assignable. */
struct PdfFontResourceKey
{
	/** Constructor using raw copy of pre-existing `pdf_font_resource_key`. */
	FZ_FUNCTION PdfFontResourceKey(pdf_font_resource_key* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_font_resource_key* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfFontResourceKey(const PdfFontResourceKey& rhs);
	PdfFontResourceKey& operator=(const PdfFontResourceKey& rhs);
};

/** Wrapper class for struct `pdf_function`. */
struct PdfFunction
{
	/** Copy constructor using `pdf_keep_function()`. */
	FZ_FUNCTION PdfFunction(const PdfFunction& rhs);

	/** operator= using `pdf_keep_function()` and `pdf_drop_function()`. */
	FZ_FUNCTION PdfFunction& operator=(const PdfFunction& rhs);

	/* == Methods. */

	/** Wrapper for `pdf_eval_function()`.
	
	This method has out-params. Python/C# wrappers look like:
		`eval_function(const float *in, int inlen, int outlen)` => float out
	 */
	FZ_FUNCTION void eval_function(const float *in, int inlen, 
			#ifdef SWIG
				float *OUTPUT
			#else
				float *out
			#endif
			, int outlen);

	/** Wrapper for `pdf_function_size()`.  */
	FZ_FUNCTION size_t function_size();

	/** Constructor using raw copy of pre-existing `pdf_function`. */
	FZ_FUNCTION PdfFunction(pdf_function* internal);

	/** Destructor using pdf_drop_function(). */
	FZ_FUNCTION ~PdfFunction();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_function* m_internal;
};

/** Wrapper class for struct `pdf_graft_map`. */
struct PdfGraftMap
{
	/** == Constructors. */

	/** Constructor using `pdf_new_graft_map()`. */
	FZ_FUNCTION PdfGraftMap(const PdfDocument& dst);

	/** Copy constructor using `pdf_keep_graft_map()`. */
	FZ_FUNCTION PdfGraftMap(const PdfGraftMap& rhs);

	/** operator= using `pdf_keep_graft_map()` and `pdf_drop_graft_map()`. */
	FZ_FUNCTION PdfGraftMap& operator=(const PdfGraftMap& rhs);

	/* == Methods. */

	/** Wrapper for `pdf_graft_mapped_object()`.  */
	FZ_FUNCTION PdfObj graft_mapped_object(const PdfObj& obj);

	/** Wrapper for `pdf_graft_mapped_page()`.  */
	FZ_FUNCTION void graft_mapped_page(int page_to, const PdfDocument& src, int page_from);

	/** Constructor using raw copy of pre-existing `pdf_graft_map`. */
	FZ_FUNCTION PdfGraftMap(pdf_graft_map* internal);

	/** Destructor using pdf_drop_graft_map(). */
	FZ_FUNCTION ~PdfGraftMap();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_graft_map* m_internal;
};

/** Wrapper class for struct `pdf_gstate`. Not copyable or assignable. */
struct PdfGstate
{
	/** Constructor using raw copy of pre-existing `pdf_gstate`. */
	FZ_FUNCTION PdfGstate(pdf_gstate* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_gstate* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfGstate(const PdfGstate& rhs);
	PdfGstate& operator=(const PdfGstate& rhs);
};

/** Wrapper class for struct `pdf_hint_page`. Not copyable or assignable. */
struct PdfHintPage
{
	/** Constructor using raw copy of pre-existing `pdf_hint_page`. */
	FZ_FUNCTION PdfHintPage(pdf_hint_page* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_hint_page* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfHintPage(const PdfHintPage& rhs);
	PdfHintPage& operator=(const PdfHintPage& rhs);
};

/** Wrapper class for struct `pdf_hint_shared`. Not copyable or assignable. */
struct PdfHintShared
{
	/** Constructor using raw copy of pre-existing `pdf_hint_shared`. */
	FZ_FUNCTION PdfHintShared(pdf_hint_shared* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_hint_shared* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfHintShared(const PdfHintShared& rhs);
	PdfHintShared& operator=(const PdfHintShared& rhs);
};

/** Wrapper class for struct `pdf_hmtx`. Not copyable or assignable. */
struct PdfHmtx
{
	/** Constructor using raw copy of pre-existing `pdf_hmtx`. */
	FZ_FUNCTION PdfHmtx(pdf_hmtx* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_hmtx* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfHmtx(const PdfHmtx& rhs);
	PdfHmtx& operator=(const PdfHmtx& rhs);
};

/** Wrapper class for struct `pdf_journal`. Not copyable or assignable. */
struct PdfJournal
{
	/* == Methods. */

	/** Wrapper for `pdf_discard_journal()`.  */
	FZ_FUNCTION void discard_journal();

	/** Constructor using raw copy of pre-existing `pdf_journal`. */
	FZ_FUNCTION PdfJournal(pdf_journal* internal);

	/** Destructor using pdf_drop_journal(). */
	FZ_FUNCTION ~PdfJournal();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_journal* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfJournal(const PdfJournal& rhs);
	PdfJournal& operator=(const PdfJournal& rhs);
};

/** Wrapper class for struct `pdf_js`. Not copyable or assignable. */
struct PdfJs
{
	/* == Methods. */

	/** Wrapper for `pdf_js_event_init()`.  */
	FZ_FUNCTION void js_event_init(const PdfObj& target, const char *value, int willCommit);

	/** Wrapper for `pdf_js_event_init_keystroke()`.  */
	FZ_FUNCTION void js_event_init_keystroke(const PdfObj& target, const PdfKeystrokeEvent& evt);

	/** Wrapper for `pdf_js_event_result()`.  */
	FZ_FUNCTION int js_event_result();

	/** Wrapper for `pdf_js_event_result_keystroke()`.  */
	FZ_FUNCTION int js_event_result_keystroke(const PdfKeystrokeEvent& evt);

	/** Wrapper for `pdf_js_event_result_validate()`.
	
	This method has out-params. Python/C# wrappers look like:
		`js_event_result_validate()` => `(int, char *newvalue)`
	 */
	FZ_FUNCTION int js_event_result_validate(
			#ifdef SWIG
				char **OUTPUT
			#else
				char **newvalue
			#endif
			);

	/** Wrapper for `pdf_js_event_value()`.  */
	FZ_FUNCTION char *js_event_value();

	/** Wrapper for `pdf_js_execute()`.
	
	This method has out-params. Python/C# wrappers look like:
		`js_execute(const char *name, const char *code)` => char *result
	 */
	FZ_FUNCTION void js_execute(const char *name, const char *code, 
			#ifdef SWIG
				char **OUTPUT
			#else
				char **result
			#endif
			);

	/** Constructor using raw copy of pre-existing `pdf_js`. */
	FZ_FUNCTION PdfJs(pdf_js* internal);

	/** Destructor using pdf_drop_js(). */
	FZ_FUNCTION ~PdfJs();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_js* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfJs(const PdfJs& rhs);
	PdfJs& operator=(const PdfJs& rhs);
};

/** Wrapper class for struct `pdf_js_console`. Not copyable or assignable. */
struct PdfJsConsole
{
	/** Constructor using raw copy of pre-existing `pdf_js_console`. */
	FZ_FUNCTION PdfJsConsole(pdf_js_console* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_js_console* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfJsConsole(const PdfJsConsole& rhs);
	PdfJsConsole& operator=(const PdfJsConsole& rhs);
};

/** Wrapper class for struct `pdf_keystroke_event`. Not copyable or assignable. */
struct PdfKeystrokeEvent
{
	/** Constructor using raw copy of pre-existing `pdf_keystroke_event`. */
	FZ_FUNCTION PdfKeystrokeEvent(pdf_keystroke_event* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_keystroke_event* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfKeystrokeEvent(const PdfKeystrokeEvent& rhs);
	PdfKeystrokeEvent& operator=(const PdfKeystrokeEvent& rhs);
};

/** Wrapper class for struct `pdf_launch_url_event`. Not copyable or assignable. */
struct PdfLaunchUrlEvent
{
	/** Constructor using raw copy of pre-existing `pdf_launch_url_event`. */
	FZ_FUNCTION PdfLaunchUrlEvent(pdf_launch_url_event* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_launch_url_event* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfLaunchUrlEvent(const PdfLaunchUrlEvent& rhs);
	PdfLaunchUrlEvent& operator=(const PdfLaunchUrlEvent& rhs);
};

/** Wrapper class for struct `pdf_layer_config`. */
struct PdfLayerConfig
{
	/** Default constructor sets .name and .creator to null. */
	FZ_FUNCTION PdfLayerConfig();

	/** We use default copy constructor and operator=. */

	/** Constructor using raw copy of pre-existing `pdf_layer_config`. */
	FZ_FUNCTION PdfLayerConfig(const pdf_layer_config* internal);

	/** Constructor using raw copy of pre-existing `pdf_layer_config`. */
	FZ_FUNCTION PdfLayerConfig(const pdf_layer_config internal);

	/** Access as underlying struct. */
	FZ_FUNCTION pdf_layer_config* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const pdf_layer_config* internal() const;

	/** We use default destructor. */

	/* == Member data. */

	/* These members are the same as the members of pdf_layer_config. */
	const char *name;
	const char *creator;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();
};

/** Writes a PdfLayerConfig's underlying pdf_layer_config's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const PdfLayerConfig& rhs);

/** Wrapper class for struct `pdf_layer_config_ui`. */
struct PdfLayerConfigUi
{
	/** Default constructor sets all .text to null and other fields to zero. */
	FZ_FUNCTION PdfLayerConfigUi();

	/** We use default copy constructor and operator=. */

	/** Constructor using raw copy of pre-existing `pdf_layer_config_ui`. */
	FZ_FUNCTION PdfLayerConfigUi(const pdf_layer_config_ui* internal);

	/** Constructor using raw copy of pre-existing `pdf_layer_config_ui`. */
	FZ_FUNCTION PdfLayerConfigUi(const pdf_layer_config_ui internal);

	/** Access as underlying struct. */
	FZ_FUNCTION pdf_layer_config_ui* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const pdf_layer_config_ui* internal() const;

	/** We use default destructor. */

	/* == Member data. */

	/* These members are the same as the members of pdf_layer_config_ui. */
	const char *text;
	int depth;
	pdf_layer_config_ui_type type;
	int selected;
	int locked;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();
};

/** Writes a PdfLayerConfigUi's underlying pdf_layer_config_ui's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const PdfLayerConfigUi& rhs);

/** Wrapper class for struct `pdf_lexbuf`. Not copyable or assignable. */
struct PdfLexbuf
{
	/** Constructor that calls pdf_lexbuf_init(size) */
	FZ_FUNCTION PdfLexbuf(int size);

	/* == Methods. */

	/** Wrapper for `pdf_lexbuf_fin()`.  */
	FZ_FUNCTION void lexbuf_fin();

	/** Wrapper for `pdf_lexbuf_grow()`.  */
	FZ_FUNCTION ptrdiff_t lexbuf_grow();

	/** Wrapper for `pdf_lexbuf_init()`.  */
	FZ_FUNCTION void lexbuf_init(int size);

	/** Destructor that calls pdf_lexbuf_fin(). */
	FZ_FUNCTION ~PdfLexbuf();

	/** Constructor using raw copy of pre-existing `pdf_lexbuf`. */
	FZ_FUNCTION PdfLexbuf(pdf_lexbuf* internal);

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_lexbuf* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfLexbuf(const PdfLexbuf& rhs);
	PdfLexbuf& operator=(const PdfLexbuf& rhs);
};

/** Wrapper class for struct `pdf_lexbuf_large`. Not copyable or assignable. */
struct PdfLexbufLarge
{
	/** Constructor using raw copy of pre-existing `pdf_lexbuf_large`. */
	FZ_FUNCTION PdfLexbufLarge(pdf_lexbuf_large* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_lexbuf_large* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfLexbufLarge(const PdfLexbufLarge& rhs);
	PdfLexbufLarge& operator=(const PdfLexbufLarge& rhs);
};

/** Wrapper class for struct `pdf_locked_fields`. Not copyable or assignable. */
struct PdfLockedFields
{
	/* == Methods. */

	/** Wrapper for `pdf_is_field_locked()`.  */
	FZ_FUNCTION int is_field_locked(const char *name);

	/** Constructor using raw copy of pre-existing `pdf_locked_fields`. */
	FZ_FUNCTION PdfLockedFields(pdf_locked_fields* internal);

	/** Destructor using pdf_drop_locked_fields(). */
	FZ_FUNCTION ~PdfLockedFields();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_locked_fields* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfLockedFields(const PdfLockedFields& rhs);
	PdfLockedFields& operator=(const PdfLockedFields& rhs);
};

/** Wrapper class for struct `pdf_mail_doc_event`. Not copyable or assignable. */
struct PdfMailDocEvent
{
	/** Constructor using raw copy of pre-existing `pdf_mail_doc_event`. */
	FZ_FUNCTION PdfMailDocEvent(pdf_mail_doc_event* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_mail_doc_event* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfMailDocEvent(const PdfMailDocEvent& rhs);
	PdfMailDocEvent& operator=(const PdfMailDocEvent& rhs);
};

/** Wrapper class for struct `pdf_mark_list`. Not copyable or assignable. */
struct PdfMarkList
{
	/* == Methods. */

	/** Wrapper for `pdf_mark_list_free()`.  */
	FZ_FUNCTION void mark_list_free();

	/** Wrapper for `pdf_mark_list_init()`.  */
	FZ_FUNCTION void mark_list_init();

	/** Wrapper for `pdf_mark_list_pop()`.  */
	FZ_FUNCTION void mark_list_pop();

	/** Wrapper for `pdf_mark_list_push()`.  */
	FZ_FUNCTION int mark_list_push(const PdfObj& obj);

	/** Constructor using raw copy of pre-existing `pdf_mark_list`. */
	FZ_FUNCTION PdfMarkList(pdf_mark_list* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_mark_list* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfMarkList(const PdfMarkList& rhs);
	PdfMarkList& operator=(const PdfMarkList& rhs);
};

/** Wrapper class for struct `pdf_mrange`. Not copyable or assignable. */
struct PdfMrange
{
	/** Constructor using raw copy of pre-existing `pdf_mrange`. */
	FZ_FUNCTION PdfMrange(pdf_mrange* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_mrange* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfMrange(const PdfMrange& rhs);
	PdfMrange& operator=(const PdfMrange& rhs);
};

/** Wrapper class for struct `pdf_obj`. */
struct PdfObj
{
	/** == Constructors. */

	/** Constructor using `pdf_new_array()`. */
	FZ_FUNCTION PdfObj(const PdfDocument& doc, int initialcap);

	/** Constructor using `pdf_new_date()`. */
	FZ_FUNCTION PdfObj(const PdfDocument& doc, int64_t time);

	/** Constructor using `pdf_new_destination_from_link()`. */
	FZ_FUNCTION PdfObj(const PdfDocument& doc, const char *uri);

	/** Constructor using `pdf_new_indirect()`. */
	FZ_FUNCTION PdfObj(const PdfDocument& doc, int num, int gen);

	/** Constructor using `pdf_new_int()`. */
	FZ_FUNCTION PdfObj(int64_t i);

	/** Constructor using `pdf_new_matrix()`. */
	FZ_FUNCTION PdfObj(const PdfDocument& doc, Matrix& mtx);

	/** Constructor using `pdf_new_name()`. */
	FZ_FUNCTION PdfObj(const char *str);

	/** Constructor using `pdf_new_real()`. */
	FZ_FUNCTION PdfObj(float f);

	/** Constructor using `pdf_new_rect()`. */
	FZ_FUNCTION PdfObj(const PdfDocument& doc, Rect& rect);

	/** Constructor using `pdf_new_string()`. */
	FZ_FUNCTION PdfObj(const char *str, size_t len);

	/** Constructor using `pdf_new_xobject()`. */
	FZ_FUNCTION PdfObj(const PdfDocument& doc, Rect& bbox, Matrix& matrix, const PdfObj& res, const Buffer& buffer);

	/** Copy constructor using `pdf_keep_obj()`. */
	FZ_FUNCTION PdfObj(const PdfObj& rhs);

	/** operator= using `pdf_keep_obj()` and `pdf_drop_obj()`. */
	FZ_FUNCTION PdfObj& operator=(const PdfObj& rhs);

	/* == Static methods. */

	/** Wrapper for `pdf_new_text_string()`.  */
	FZ_FUNCTION static PdfObj new_text_string(const char *s);

	/** Wrapper for `pdf_new_dict()`.  */
	FZ_FUNCTION static PdfObj new_dict(const PdfDocument& doc, int initialcap);

	/** Wrapper for `pdf_new_action_from_link()`.  */
	FZ_FUNCTION static PdfObj new_action_from_link(const PdfDocument& doc, const char *uri);

	/* == Methods. */

	/** Wrapper for `pdf_array_contains()`.  */
	FZ_FUNCTION int array_contains(const PdfObj& obj);

	/** Wrapper for `pdf_array_delete()`.  */
	FZ_FUNCTION void array_delete(int index);

	/** Wrapper for `pdf_array_find()`.  */
	FZ_FUNCTION int array_find(const PdfObj& obj);

	/** Wrapper for `pdf_array_get()`.  */
	FZ_FUNCTION PdfObj array_get(int i);

	/** Wrapper for `pdf_array_get_bool()`.  */
	FZ_FUNCTION int array_get_bool(int index);

	/** Wrapper for `pdf_array_get_int()`.  */
	FZ_FUNCTION int array_get_int(int index);

	/** Wrapper for `pdf_array_get_matrix()`.  */
	FZ_FUNCTION Matrix array_get_matrix(int index);

	/** Wrapper for `pdf_array_get_name()`.  */
	FZ_FUNCTION const char *array_get_name(int index);

	/** Wrapper for `pdf_array_get_real()`.  */
	FZ_FUNCTION float array_get_real(int index);

	/** Wrapper for `pdf_array_get_rect()`.  */
	FZ_FUNCTION Rect array_get_rect(int index);

	/** Wrapper for `pdf_array_get_string()`.
	
	This method has out-params. Python/C# wrappers look like:
		`array_get_string(int index)` => `(const char *, size_t sizep)`
	 */
	FZ_FUNCTION const char *array_get_string(int index, 
			#ifdef SWIG
				size_t *OUTPUT
			#else
				size_t *sizep
			#endif
			);

	/** Wrapper for `pdf_array_get_text_string()`.  */
	FZ_FUNCTION const char *array_get_text_string(int index);

	/** Wrapper for `pdf_array_insert()`.  */
	FZ_FUNCTION void array_insert(const PdfObj& obj, int index);

	/** Wrapper for `pdf_array_len()`.  */
	FZ_FUNCTION int array_len();

	/** Wrapper for `pdf_array_push()`.  */
	FZ_FUNCTION void array_push(const PdfObj& obj);

	/** Wrapper for `pdf_array_push_array()`.  */
	FZ_FUNCTION PdfObj array_push_array(int initial);

	/** Wrapper for `pdf_array_push_bool()`.  */
	FZ_FUNCTION void array_push_bool(int x);

	/** Wrapper for `pdf_array_push_dict()`.  */
	FZ_FUNCTION PdfObj array_push_dict(int initial);

	/** Wrapper for `pdf_array_push_int()`.  */
	FZ_FUNCTION void array_push_int(int64_t x);

	/** Wrapper for `pdf_array_push_name()`.  */
	FZ_FUNCTION void array_push_name(const char *x);

	/** Wrapper for `pdf_array_push_real()`.  */
	FZ_FUNCTION void array_push_real(double x);

	/** Wrapper for `pdf_array_push_string()`.  */
	FZ_FUNCTION void array_push_string(const char *x, size_t n);

	/** Wrapper for `pdf_array_push_text_string()`.  */
	FZ_FUNCTION void array_push_text_string(const char *x);

	/** Wrapper for `pdf_array_put()`.  */
	FZ_FUNCTION void array_put(int i, const PdfObj& obj);

	/** Wrapper for `pdf_button_field_on_state()`.  */
	FZ_FUNCTION PdfObj button_field_on_state();

	/** Wrapper for `pdf_choice_field_option()`.  */
	FZ_FUNCTION const char *choice_field_option(int exportval, int i);

	/** Wrapper for `pdf_choice_field_option_count()`.  */
	FZ_FUNCTION int choice_field_option_count();

	/** Wrapper for `pdf_clean_obj()`.  */
	FZ_FUNCTION void clean_obj();

	/** Wrapper for `pdf_copy_array()`.  */
	FZ_FUNCTION PdfObj copy_array();

	/** Wrapper for `pdf_copy_dict()`.  */
	FZ_FUNCTION PdfObj copy_dict();

	/** Wrapper for `pdf_debug_obj()`.  */
	FZ_FUNCTION void debug_obj();

	/** Wrapper for `pdf_debug_ref()`.  */
	FZ_FUNCTION void debug_ref();

	/** Wrapper for `pdf_deep_copy_obj()`.  */
	FZ_FUNCTION PdfObj deep_copy_obj();

	/** Wrapper for `pdf_dict_del()`.  */
	FZ_FUNCTION void dict_del(const PdfObj& key);

	/** Wrapper for `pdf_dict_dels()`.  */
	FZ_FUNCTION void dict_dels(const char *key);

	/** Wrapper for `pdf_dict_get()`.  */
	FZ_FUNCTION PdfObj dict_get(const PdfObj& key);

	/** Wrapper for `pdf_dict_get_bool()`.  */
	FZ_FUNCTION int dict_get_bool(const PdfObj& key);

	/** Wrapper for `pdf_dict_get_date()`.  */
	FZ_FUNCTION int64_t dict_get_date(const PdfObj& key);

	/** Wrapper for `pdf_dict_get_inheritable()`.  */
	FZ_FUNCTION PdfObj dict_get_inheritable(const PdfObj& key);

	/** Wrapper for `pdf_dict_get_int()`.  */
	FZ_FUNCTION int dict_get_int(const PdfObj& key);

	/** Wrapper for `pdf_dict_get_key()`.  */
	FZ_FUNCTION PdfObj dict_get_key(int idx);

	/** Wrapper for `pdf_dict_get_matrix()`.  */
	FZ_FUNCTION Matrix dict_get_matrix(const PdfObj& key);

	/** Wrapper for `pdf_dict_get_name()`.  */
	FZ_FUNCTION const char *dict_get_name(const PdfObj& key);

	/** Wrapper for `pdf_dict_get_real()`.  */
	FZ_FUNCTION float dict_get_real(const PdfObj& key);

	/** Wrapper for `pdf_dict_get_rect()`.  */
	FZ_FUNCTION Rect dict_get_rect(const PdfObj& key);

	/** Wrapper for `pdf_dict_get_string()`.
	
	This method has out-params. Python/C# wrappers look like:
		`dict_get_string(pdf_obj *key)` => `(const char *, size_t sizep)`
	 */
	FZ_FUNCTION const char *dict_get_string(const PdfObj& key, 
			#ifdef SWIG
				size_t *OUTPUT
			#else
				size_t *sizep
			#endif
			);

	/** Wrapper for `pdf_dict_get_text_string()`.  */
	FZ_FUNCTION const char *dict_get_text_string(const PdfObj& key);

	/** Wrapper for `pdf_dict_get_val()`.  */
	FZ_FUNCTION PdfObj dict_get_val(int idx);

	/** Wrapper for `pdf_dict_geta()`.  */
	FZ_FUNCTION PdfObj dict_geta(const PdfObj& key, const PdfObj& abbrev);

	/** Wrapper for `pdf_dict_getp()`.  */
	FZ_FUNCTION PdfObj dict_getp(const char *path);

	/** Wrapper for `pdf_dict_getp_inheritable()`.  */
	FZ_FUNCTION PdfObj dict_getp_inheritable(const char *path);

	/** Wrapper for `pdf_dict_gets()`.  */
	FZ_FUNCTION PdfObj dict_gets(const char *key);

	/** Wrapper for `pdf_dict_getsa()`.  */
	FZ_FUNCTION PdfObj dict_getsa(const char *key, const char *abbrev);

	/** Wrapper for `pdf_dict_len()`.  */
	FZ_FUNCTION int dict_len();

	/** Wrapper for `pdf_dict_put()`.  */
	FZ_FUNCTION void dict_put(const PdfObj& key, const PdfObj& val);

	/** Wrapper for `pdf_dict_put_array()`.  */
	FZ_FUNCTION PdfObj dict_put_array(const PdfObj& key, int initial);

	/** Wrapper for `pdf_dict_put_bool()`.  */
	FZ_FUNCTION void dict_put_bool(const PdfObj& key, int x);

	/** Wrapper for `pdf_dict_put_date()`.  */
	FZ_FUNCTION void dict_put_date(const PdfObj& key, int64_t time);

	/** Wrapper for `pdf_dict_put_dict()`.  */
	FZ_FUNCTION PdfObj dict_put_dict(const PdfObj& key, int initial);

	/** Wrapper for `pdf_dict_put_int()`.  */
	FZ_FUNCTION void dict_put_int(const PdfObj& key, int64_t x);

	/** Wrapper for `pdf_dict_put_matrix()`.  */
	FZ_FUNCTION void dict_put_matrix(const PdfObj& key, Matrix& x);

	/** Wrapper for `pdf_dict_put_name()`.  */
	FZ_FUNCTION void dict_put_name(const PdfObj& key, const char *x);

	/** Wrapper for `pdf_dict_put_real()`.  */
	FZ_FUNCTION void dict_put_real(const PdfObj& key, double x);

	/** Wrapper for `pdf_dict_put_rect()`.  */
	FZ_FUNCTION void dict_put_rect(const PdfObj& key, Rect& x);

	/** Wrapper for `pdf_dict_put_string()`.  */
	FZ_FUNCTION void dict_put_string(const PdfObj& key, const char *x, size_t n);

	/** Wrapper for `pdf_dict_put_text_string()`.  */
	FZ_FUNCTION void dict_put_text_string(const PdfObj& key, const char *x);

	/** Wrapper for `pdf_dict_put_val_null()`.  */
	FZ_FUNCTION void dict_put_val_null(int idx);

	/** Wrapper for `pdf_dict_putp()`.  */
	FZ_FUNCTION void dict_putp(const char *path, const PdfObj& val);

	/** Wrapper for `pdf_dict_puts()`.  */
	FZ_FUNCTION void dict_puts(const char *key, const PdfObj& val);

	/** Wrapper for `pdf_dict_puts_dict()`.  */
	FZ_FUNCTION PdfObj dict_puts_dict(const char *key, int initial);

	/** Wrapper for `pdf_dirty_obj()`.  */
	FZ_FUNCTION void dirty_obj();

	/** Wrapper for `pdf_embedded_file_name()`.  */
	FZ_FUNCTION const char *embedded_file_name();

	/** Wrapper for `pdf_embedded_file_stream()`.  */
	FZ_FUNCTION PdfObj embedded_file_stream();

	/** Wrapper for `pdf_embedded_file_type()`.  */
	FZ_FUNCTION const char *embedded_file_type();

	/** Wrapper for `pdf_field_border_style()`.  */
	FZ_FUNCTION char *field_border_style();

	/** Wrapper for `pdf_field_display()`.  */
	FZ_FUNCTION int field_display();

	/** Wrapper for `pdf_field_flags()`.  */
	FZ_FUNCTION int field_flags();

	/** Wrapper for `pdf_field_label()`.  */
	FZ_FUNCTION const char *field_label();

	/** Wrapper for `pdf_field_name()`.  */
	FZ_FUNCTION char *field_name();

	/** Wrapper for `pdf_field_set_border_style()`.  */
	FZ_FUNCTION void field_set_border_style(const char *text);

	/** Wrapper for `pdf_field_set_button_caption()`.  */
	FZ_FUNCTION void field_set_button_caption(const char *text);

	/** Wrapper for `pdf_field_set_display()`.  */
	FZ_FUNCTION void field_set_display(int d);

	/** Wrapper for `pdf_field_set_fill_color()`.  */
	FZ_FUNCTION void field_set_fill_color(const PdfObj& col);

	/** Wrapper for `pdf_field_set_text_color()`.  */
	FZ_FUNCTION void field_set_text_color(const PdfObj& col);

	/** Wrapper for `pdf_field_type()`.  */
	FZ_FUNCTION int field_type();

	/** Wrapper for `pdf_field_type_string()`.  */
	FZ_FUNCTION const char *field_type_string();

	/** Wrapper for `pdf_field_value()`.  */
	FZ_FUNCTION const char *field_value();

	/** Wrapper for `pdf_filter_xobject_instance()`.  */
	FZ_FUNCTION PdfObj filter_xobject_instance(const PdfObj& page_res, Matrix& ctm, PdfFilterOptions& filter);

	/** Wrapper for `pdf_flatten_inheritable_page_items()`.  */
	FZ_FUNCTION void flatten_inheritable_page_items();

	/** Wrapper for `pdf_get_bound_document()`.  */
	FZ_FUNCTION PdfDocument get_bound_document();

	/** Wrapper for `pdf_get_indirect_document()`.  */
	FZ_FUNCTION PdfDocument get_indirect_document();

	/** Wrapper for `pdf_is_array()`.  */
	FZ_FUNCTION int is_array();

	/** Wrapper for `pdf_is_bool()`.  */
	FZ_FUNCTION int is_bool();

	/** Wrapper for `pdf_is_dict()`.  */
	FZ_FUNCTION int is_dict();

	/** Wrapper for `pdf_is_embedded_file()`.  */
	FZ_FUNCTION int is_embedded_file();

	/** Wrapper for `pdf_is_indirect()`.  */
	FZ_FUNCTION int is_indirect();

	/** Wrapper for `pdf_is_int()`.  */
	FZ_FUNCTION int is_int();

	/** Wrapper for `pdf_is_jpx_image()`.  */
	FZ_FUNCTION int is_jpx_image();

	/** Wrapper for `pdf_is_name()`.  */
	FZ_FUNCTION int is_name();

	/** Wrapper for `pdf_is_null()`.  */
	FZ_FUNCTION int is_null();

	/** Wrapper for `pdf_is_number()`.  */
	FZ_FUNCTION int is_number();

	/** Wrapper for `pdf_is_real()`.  */
	FZ_FUNCTION int is_real();

	/** Wrapper for `pdf_is_stream()`.  */
	FZ_FUNCTION int is_stream();

	/** Wrapper for `pdf_is_string()`.  */
	FZ_FUNCTION int is_string();

	/** Wrapper for `pdf_line_ending_from_name()`.  */
	FZ_FUNCTION enum pdf_line_ending line_ending_from_name();

	/** Wrapper for `pdf_load_colorspace()`.  */
	FZ_FUNCTION Colorspace load_colorspace();

	/** Wrapper for `pdf_load_embedded_file()`.  */
	FZ_FUNCTION Buffer load_embedded_file();

	/** Wrapper for `pdf_load_function()`.  */
	FZ_FUNCTION PdfFunction load_function(int in, int out);

	/** Wrapper for `pdf_load_raw_stream()`.  */
	FZ_FUNCTION Buffer load_raw_stream();

	/** Wrapper for `pdf_load_stream()`.  */
	FZ_FUNCTION Buffer load_stream();

	/** Wrapper for `pdf_load_stream_or_string_as_utf8()`.  */
	FZ_FUNCTION char *load_stream_or_string_as_utf8();

	/** Wrapper for `pdf_lookup_field()`.  */
	FZ_FUNCTION PdfObj lookup_field(const char *name);

	/** Wrapper for `pdf_lookup_number()`.  */
	FZ_FUNCTION PdfObj lookup_number(int needle);

	/** Wrapper for `pdf_mark_obj()`.  */
	FZ_FUNCTION int mark_obj();

	/** Wrapper for `pdf_name_eq()`.  */
	FZ_FUNCTION int name_eq(const PdfObj& b);

	/** Wrapper for `pdf_new_utf8_from_pdf_stream_obj()`.  */
	FZ_FUNCTION char *new_utf8_from_pdf_stream_obj();

	/** Wrapper for `pdf_new_utf8_from_pdf_string_obj()`.  */
	FZ_FUNCTION char *new_utf8_from_pdf_string_obj();

	/** Wrapper for `pdf_obj_is_dirty()`.  */
	FZ_FUNCTION int obj_is_dirty();

	/** Wrapper for `pdf_obj_is_incremental()`.  */
	FZ_FUNCTION int obj_is_incremental();

	/** Wrapper for `pdf_obj_marked()`.  */
	FZ_FUNCTION int obj_marked();

	/** Wrapper for `pdf_obj_memo()`.
	
	This method has out-params. Python/C# wrappers look like:
		`obj_memo(int bit)` => `(int, int memo)`
	 */
	FZ_FUNCTION int obj_memo(int bit, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *memo
			#endif
			);

	/** Wrapper for `pdf_obj_parent_num()`.  */
	FZ_FUNCTION int obj_parent_num();

	/** Wrapper for `pdf_obj_refs()`.  */
	FZ_FUNCTION int obj_refs();

	/** Wrapper for `pdf_objcmp()`.  */
	FZ_FUNCTION int objcmp(const PdfObj& b);

	/** Wrapper for `pdf_objcmp_resolve()`.  */
	FZ_FUNCTION int objcmp_resolve(const PdfObj& b);

	/** Wrapper for `pdf_open_raw_stream()`.  */
	FZ_FUNCTION Stream open_raw_stream();

	/** Wrapper for `pdf_open_stream()`.  */
	FZ_FUNCTION Stream open_stream();

	/** Wrapper for `pdf_page_obj_transform()`.  */
	FZ_FUNCTION void page_obj_transform(Rect& page_mediabox, Matrix& page_ctm);

	/** Wrapper for `pdf_resolve_indirect()`.  */
	FZ_FUNCTION PdfObj resolve_indirect();

	/** Wrapper for `pdf_resolve_indirect_chain()`.  */
	FZ_FUNCTION PdfObj resolve_indirect_chain();

	/** Wrapper for `pdf_set_int()`.  */
	FZ_FUNCTION void set_int(int64_t i);

	/** Wrapper for `pdf_set_obj_memo()`.  */
	FZ_FUNCTION void set_obj_memo(int bit, int memo);

	/** Wrapper for `pdf_set_obj_parent()`.  */
	FZ_FUNCTION void set_obj_parent(int num);

	/** Wrapper for `pdf_set_str_len()`.  */
	FZ_FUNCTION void set_str_len(size_t newlen);

	/** Wrapper for `pdf_sort_dict()`.  */
	FZ_FUNCTION void sort_dict();

	/** Wrapper for `pdf_store_item()`.  */
	FZ_FUNCTION void store_item(void *val, size_t itemsize);

	/** Wrapper for `pdf_to_bool()`.  */
	FZ_FUNCTION int to_bool();

	/** Wrapper for `pdf_to_date()`.  */
	FZ_FUNCTION int64_t to_date();

	/** Wrapper for `pdf_to_gen()`.  */
	FZ_FUNCTION int to_gen();

	/** Wrapper for `pdf_to_int()`.  */
	FZ_FUNCTION int to_int();

	/** Wrapper for `pdf_to_int64()`.  */
	FZ_FUNCTION int64_t to_int64();

	/** Wrapper for `pdf_to_matrix()`.  */
	FZ_FUNCTION Matrix to_matrix();

	/** Wrapper for `pdf_to_name()`.  */
	FZ_FUNCTION const char *to_name();

	/** Wrapper for `pdf_to_num()`.  */
	FZ_FUNCTION int to_num();

	/** Wrapper for `pdf_to_quad()`.  */
	FZ_FUNCTION Quad to_quad(int offset);

	/** Wrapper for `pdf_to_real()`.  */
	FZ_FUNCTION float to_real();

	/** Wrapper for `pdf_to_rect()`.  */
	FZ_FUNCTION Rect to_rect();

	/** Wrapper for `pdf_to_str_buf()`.  */
	FZ_FUNCTION char *to_str_buf();

	/** Wrapper for `pdf_to_str_len()`.  */
	FZ_FUNCTION size_t to_str_len();

	/** Wrapper for `pdf_to_string()`.
	
	This method has out-params. Python/C# wrappers look like:
		`to_string()` => `(const char *, size_t sizep)`
	 */
	FZ_FUNCTION const char *to_string(
			#ifdef SWIG
				size_t *OUTPUT
			#else
				size_t *sizep
			#endif
			);

	/** Wrapper for `pdf_to_text_string()`.  */
	FZ_FUNCTION const char *to_text_string();

	/** Wrapper for `pdf_unmark_obj()`.  */
	FZ_FUNCTION void unmark_obj();

	/** Wrapper for `pdf_walk_tree()`.
	
	This method has out-params. Python/C# wrappers look like:
		`walk_tree(pdf_obj *kid_name, void (*arrive)(fz_context *, pdf_obj *, void *, pdf_obj **), void (*leave)(fz_context *, pdf_obj *, void *), void *arg, pdf_obj **names, pdf_obj **values)` => `()`
	 */
	FZ_FUNCTION void walk_tree(const PdfObj& kid_name, void (*arrive)(fz_context *, pdf_obj *, void *, pdf_obj **), void (*leave)(fz_context *, pdf_obj *, void *), void *arg, PdfObj& names, PdfObj& values);

	/** Wrapper for `pdf_xobject_bbox()`.  */
	FZ_FUNCTION Rect xobject_bbox();

	/** Wrapper for `pdf_xobject_colorspace()`.  */
	FZ_FUNCTION Colorspace xobject_colorspace();

	/** Wrapper for `pdf_xobject_isolated()`.  */
	FZ_FUNCTION int xobject_isolated();

	/** Wrapper for `pdf_xobject_knockout()`.  */
	FZ_FUNCTION int xobject_knockout();

	/** Wrapper for `pdf_xobject_matrix()`.  */
	FZ_FUNCTION Matrix xobject_matrix();

	/** Wrapper for `pdf_xobject_resources()`.  */
	FZ_FUNCTION PdfObj xobject_resources();

	/** Wrapper for `pdf_xobject_transparency()`.  */
	FZ_FUNCTION int xobject_transparency();

	/** Typesafe wrapper for looking up things such as PDF_ENUM_NAME_Annots.*/
	FZ_FUNCTION PdfObj dict_get(int key);

	/** Constructor using raw copy of pre-existing `pdf_obj`. */
	FZ_FUNCTION PdfObj(pdf_obj* internal=NULL);

	/** Destructor using pdf_drop_obj(). */
	FZ_FUNCTION ~PdfObj();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_obj* m_internal;
};

/** Wrapper class for struct `pdf_ocg_descriptor`. Not copyable or assignable. */
struct PdfOcgDescriptor
{
	/** Constructor using raw copy of pre-existing `pdf_ocg_descriptor`. */
	FZ_FUNCTION PdfOcgDescriptor(pdf_ocg_descriptor* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_ocg_descriptor* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfOcgDescriptor(const PdfOcgDescriptor& rhs);
	PdfOcgDescriptor& operator=(const PdfOcgDescriptor& rhs);
};

/** Wrapper class for struct `pdf_page`. */
struct PdfPage
{
	/** We use default copy constructor and operator=. */

	/* == Methods. */

	/** Wrapper for `pdf_bound_page()`.  */
	FZ_FUNCTION Rect bound_page();

	/** Wrapper for `pdf_create_annot()`.  */
	FZ_FUNCTION PdfAnnot create_annot(enum pdf_annot_type type);

	/** Wrapper for `pdf_create_annot_raw()`.  */
	FZ_FUNCTION PdfAnnot create_annot_raw(enum pdf_annot_type type);

	/** Wrapper for `pdf_create_link()`.  */
	FZ_FUNCTION Link create_link(Rect& bbox, const char *uri);

	/** Wrapper for `pdf_create_signature_widget()`.  */
	FZ_FUNCTION PdfAnnot create_signature_widget(char *name);

	/** Wrapper for `pdf_delete_annot()`.  */
	FZ_FUNCTION void delete_annot(const PdfAnnot& annot);

	/** Wrapper for `pdf_first_annot()`.  */
	FZ_FUNCTION PdfAnnot first_annot();

	/** Wrapper for `pdf_first_widget()`.  */
	FZ_FUNCTION PdfAnnot first_widget();

	/** Wrapper for `pdf_load_links()`.  */
	FZ_FUNCTION Link load_links();

	/** Wrapper for `pdf_new_pixmap_from_page_contents_with_separations_and_usage()`.  */
	FZ_FUNCTION Pixmap new_pixmap_from_page_contents_with_separations_and_usage(Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha, const char *usage);

	/** Wrapper for `pdf_new_pixmap_from_page_contents_with_usage()`.  */
	FZ_FUNCTION Pixmap new_pixmap_from_page_contents_with_usage(Matrix& ctm, const Colorspace& cs, int alpha, const char *usage);

	/** Wrapper for `pdf_new_pixmap_from_page_with_separations_and_usage()`.  */
	FZ_FUNCTION Pixmap new_pixmap_from_page_with_separations_and_usage(Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha, const char *usage);

	/** Wrapper for `pdf_new_pixmap_from_page_with_usage()`.  */
	FZ_FUNCTION Pixmap new_pixmap_from_page_with_usage(Matrix& ctm, const Colorspace& cs, int alpha, const char *usage);

	/** Wrapper for `pdf_page_contents()`.  */
	FZ_FUNCTION PdfObj page_contents();

	/** Wrapper for `pdf_page_event_close()`.  */
	FZ_FUNCTION void page_event_close();

	/** Wrapper for `pdf_page_event_open()`.  */
	FZ_FUNCTION void page_event_open();

	/** Wrapper for `pdf_page_group()`.  */
	FZ_FUNCTION PdfObj page_group();

	/** Wrapper for `pdf_page_presentation()`.
	
	This method has out-params. Python/C# wrappers look like:
		`page_presentation(fz_transition *transition)` => `(fz_transition *, float duration)`
	 */
	FZ_FUNCTION Transition page_presentation(Transition& transition, 
			#ifdef SWIG
				float *OUTPUT
			#else
				float *duration
			#endif
			);

	/** Wrapper for `pdf_page_resources()`.  */
	FZ_FUNCTION PdfObj page_resources();

	/** Wrapper for `pdf_page_separations()`.  */
	FZ_FUNCTION Separations page_separations();

	/** Wrapper for `pdf_page_transform()`.  */
	FZ_FUNCTION void page_transform(Rect& mediabox, Matrix& ctm);

	/** Wrapper for `pdf_run_page()`.  */
	FZ_FUNCTION void run_page(const Device& dev, Matrix& ctm, Cookie& cookie);

	/** Wrapper for `pdf_run_page_annots()`.  */
	FZ_FUNCTION void run_page_annots(const Device& dev, Matrix& ctm, Cookie& cookie);

	/** Wrapper for `pdf_run_page_annots_with_usage()`.  */
	FZ_FUNCTION void run_page_annots_with_usage(const Device& dev, Matrix& ctm, const char *usage, Cookie& cookie);

	/** Wrapper for `pdf_run_page_contents()`.  */
	FZ_FUNCTION void run_page_contents(const Device& dev, Matrix& ctm, Cookie& cookie);

	/** Wrapper for `pdf_run_page_contents_with_usage()`.  */
	FZ_FUNCTION void run_page_contents_with_usage(const Device& dev, Matrix& ctm, const char *usage, Cookie& cookie);

	/** Wrapper for `pdf_run_page_widgets()`.  */
	FZ_FUNCTION void run_page_widgets(const Device& dev, Matrix& ctm, Cookie& cookie);

	/** Wrapper for `pdf_run_page_widgets_with_usage()`.  */
	FZ_FUNCTION void run_page_widgets_with_usage(const Device& dev, Matrix& ctm, const char *usage, Cookie& cookie);

	/** Wrapper for `pdf_run_page_with_usage()`.  */
	FZ_FUNCTION void run_page_with_usage(const Device& dev, Matrix& ctm, const char *usage, Cookie& cookie);

	/** Wrapper for `pdf_update_page()`.  */
	FZ_FUNCTION int update_page();

	/** Returns wrapper for .super member. */
	FZ_FUNCTION Page super();

	/** Returns wrapper for .doc member. */
	FZ_FUNCTION PdfDocument doc();

	/** Returns wrapper for .obj member. */
	FZ_FUNCTION PdfObj obj();

	/** Constructor using raw copy of pre-existing `pdf_page`. */
	FZ_FUNCTION PdfPage(pdf_page* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_page* m_internal;
};

/** Wrapper class for struct `pdf_pattern`. */
struct PdfPattern
{
	/** Copy constructor using `pdf_keep_pattern()`. */
	FZ_FUNCTION PdfPattern(const PdfPattern& rhs);

	/** operator= using `pdf_keep_pattern()` and `pdf_drop_pattern()`. */
	FZ_FUNCTION PdfPattern& operator=(const PdfPattern& rhs);

	/** Constructor using raw copy of pre-existing `pdf_pattern`. */
	FZ_FUNCTION PdfPattern(pdf_pattern* internal);

	/** Destructor using pdf_drop_pattern(). */
	FZ_FUNCTION ~PdfPattern();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_pattern* m_internal;
};

/** Wrapper class for struct `pdf_pkcs7_distinguished_name`. Not copyable or assignable. */
struct PdfPkcs7DistinguishedName
{
	/* == Methods. */

	/** Wrapper for `pdf_signature_drop_distinguished_name()`.  */
	FZ_FUNCTION void signature_drop_distinguished_name();

	/** Wrapper for `pdf_signature_format_distinguished_name()`.  */
	FZ_FUNCTION char *signature_format_distinguished_name();

	/** Constructor using raw copy of pre-existing `pdf_pkcs7_distinguished_name`. */
	FZ_FUNCTION PdfPkcs7DistinguishedName(pdf_pkcs7_distinguished_name* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_pkcs7_distinguished_name* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfPkcs7DistinguishedName(const PdfPkcs7DistinguishedName& rhs);
	PdfPkcs7DistinguishedName& operator=(const PdfPkcs7DistinguishedName& rhs);
};

/** Wrapper class for struct `pdf_pkcs7_signer`. Not copyable or assignable. */
struct PdfPkcs7Signer
{
	/** Constructor using raw copy of pre-existing `pdf_pkcs7_signer`. */
	FZ_FUNCTION PdfPkcs7Signer(pdf_pkcs7_signer* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_pkcs7_signer* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfPkcs7Signer(const PdfPkcs7Signer& rhs);
	PdfPkcs7Signer& operator=(const PdfPkcs7Signer& rhs);
};

/** Wrapper class for struct `pdf_pkcs7_verifier`. Not copyable or assignable. */
struct PdfPkcs7Verifier
{
	/* == Methods. */

	/** Wrapper for `pdf_check_signature()`.  */
	FZ_FUNCTION int check_signature(const PdfDocument& doc, const PdfObj& signature, char *ebuf, size_t ebufsize);

	/** Constructor using raw copy of pre-existing `pdf_pkcs7_verifier`. */
	FZ_FUNCTION PdfPkcs7Verifier(pdf_pkcs7_verifier* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_pkcs7_verifier* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfPkcs7Verifier(const PdfPkcs7Verifier& rhs);
	PdfPkcs7Verifier& operator=(const PdfPkcs7Verifier& rhs);
};

/** Wrapper class for struct `pdf_processor`. */
struct PdfProcessor
{
	/** == Constructors. */

	/** Constructor using `pdf_new_buffer_processor()`. */
	FZ_FUNCTION PdfProcessor(const Buffer& buffer, int ahxencode);

	/** Constructor using `pdf_new_filter_processor()`. */
	FZ_FUNCTION PdfProcessor(const PdfDocument& doc, const PdfProcessor& chain, const PdfObj& old_res, const PdfObj& new_res, int struct_parents, Matrix& transform, PdfFilterOptions& filter);

	/** Constructor using `pdf_new_output_processor()`. */
	FZ_FUNCTION PdfProcessor(const Output& out, int ahxencode);

	/** Constructor using `pdf_new_run_processor()`. */
	FZ_FUNCTION PdfProcessor(const Device& dev, Matrix& ctm, const char *usage, const PdfGstate& gstate, const DefaultColorspaces& default_cs, Cookie& cookie);

	/** Sets m_internal = NULL. */
	FZ_FUNCTION PdfProcessor();

	/** Copy constructor using `pdf_keep_processor()`. */
	FZ_FUNCTION PdfProcessor(const PdfProcessor& rhs);

	/** operator= using `pdf_keep_processor()` and `pdf_drop_processor()`. */
	FZ_FUNCTION PdfProcessor& operator=(const PdfProcessor& rhs);

	/* == Methods. */

	/** Wrapper for `pdf_close_processor()`.  */
	FZ_FUNCTION void close_processor();

	/** Wrapper for `pdf_process_annot()`.  */
	FZ_FUNCTION void process_annot(const PdfAnnot& annot, Cookie& cookie);

	/** Wrapper for `pdf_process_contents()`.  */
	FZ_FUNCTION void process_contents(const PdfDocument& doc, const PdfObj& obj, const PdfObj& res, Cookie& cookie);

	/** Wrapper for `pdf_process_glyph()`.  */
	FZ_FUNCTION void process_glyph(const PdfDocument& doc, const PdfObj& resources, const Buffer& contents);

	/** Constructor using raw copy of pre-existing `pdf_processor`. */
	FZ_FUNCTION PdfProcessor(pdf_processor* internal);

	/** Destructor using pdf_drop_processor(). */
	FZ_FUNCTION ~PdfProcessor();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_processor* m_internal;
};

/** Wrapper class for struct pdf_processor with virtual fns for each fnptr; this is for use as a SWIG Director class. */
struct PdfProcessor2 : PdfProcessor
{

	/** == Constructor. */
	FZ_FUNCTION PdfProcessor2();

	/** These methods set the function pointers in *m_internal
	to point to internal callbacks that call our virtual methods. */
	FZ_FUNCTION void use_virtual_close_processor( bool use=true);
	FZ_FUNCTION void use_virtual_drop_processor( bool use=true);
	FZ_FUNCTION void use_virtual_op_w( bool use=true);
	FZ_FUNCTION void use_virtual_op_j( bool use=true);
	FZ_FUNCTION void use_virtual_op_J( bool use=true);
	FZ_FUNCTION void use_virtual_op_M( bool use=true);
	FZ_FUNCTION void use_virtual_op_d( bool use=true);
	FZ_FUNCTION void use_virtual_op_ri( bool use=true);
	FZ_FUNCTION void use_virtual_op_i( bool use=true);
	FZ_FUNCTION void use_virtual_op_gs_begin( bool use=true);
	FZ_FUNCTION void use_virtual_op_gs_BM( bool use=true);
	FZ_FUNCTION void use_virtual_op_gs_ca( bool use=true);
	FZ_FUNCTION void use_virtual_op_gs_CA( bool use=true);
	FZ_FUNCTION void use_virtual_op_gs_SMask( bool use=true);
	FZ_FUNCTION void use_virtual_op_gs_end( bool use=true);
	FZ_FUNCTION void use_virtual_op_q( bool use=true);
	FZ_FUNCTION void use_virtual_op_Q( bool use=true);
	FZ_FUNCTION void use_virtual_op_cm( bool use=true);
	FZ_FUNCTION void use_virtual_op_m( bool use=true);
	FZ_FUNCTION void use_virtual_op_l( bool use=true);
	FZ_FUNCTION void use_virtual_op_c( bool use=true);
	FZ_FUNCTION void use_virtual_op_v( bool use=true);
	FZ_FUNCTION void use_virtual_op_y( bool use=true);
	FZ_FUNCTION void use_virtual_op_h( bool use=true);
	FZ_FUNCTION void use_virtual_op_re( bool use=true);
	FZ_FUNCTION void use_virtual_op_S( bool use=true);
	FZ_FUNCTION void use_virtual_op_s( bool use=true);
	FZ_FUNCTION void use_virtual_op_F( bool use=true);
	FZ_FUNCTION void use_virtual_op_f( bool use=true);
	FZ_FUNCTION void use_virtual_op_fstar( bool use=true);
	FZ_FUNCTION void use_virtual_op_B( bool use=true);
	FZ_FUNCTION void use_virtual_op_Bstar( bool use=true);
	FZ_FUNCTION void use_virtual_op_b( bool use=true);
	FZ_FUNCTION void use_virtual_op_bstar( bool use=true);
	FZ_FUNCTION void use_virtual_op_n( bool use=true);
	FZ_FUNCTION void use_virtual_op_W( bool use=true);
	FZ_FUNCTION void use_virtual_op_Wstar( bool use=true);
	FZ_FUNCTION void use_virtual_op_BT( bool use=true);
	FZ_FUNCTION void use_virtual_op_ET( bool use=true);
	FZ_FUNCTION void use_virtual_op_Tc( bool use=true);
	FZ_FUNCTION void use_virtual_op_Tw( bool use=true);
	FZ_FUNCTION void use_virtual_op_Tz( bool use=true);
	FZ_FUNCTION void use_virtual_op_TL( bool use=true);
	FZ_FUNCTION void use_virtual_op_Tf( bool use=true);
	FZ_FUNCTION void use_virtual_op_Tr( bool use=true);
	FZ_FUNCTION void use_virtual_op_Ts( bool use=true);
	FZ_FUNCTION void use_virtual_op_Td( bool use=true);
	FZ_FUNCTION void use_virtual_op_TD( bool use=true);
	FZ_FUNCTION void use_virtual_op_Tm( bool use=true);
	FZ_FUNCTION void use_virtual_op_Tstar( bool use=true);
	FZ_FUNCTION void use_virtual_op_TJ( bool use=true);
	FZ_FUNCTION void use_virtual_op_Tj( bool use=true);
	FZ_FUNCTION void use_virtual_op_squote( bool use=true);
	FZ_FUNCTION void use_virtual_op_dquote( bool use=true);
	FZ_FUNCTION void use_virtual_op_d0( bool use=true);
	FZ_FUNCTION void use_virtual_op_d1( bool use=true);
	FZ_FUNCTION void use_virtual_op_CS( bool use=true);
	FZ_FUNCTION void use_virtual_op_cs( bool use=true);
	FZ_FUNCTION void use_virtual_op_SC_pattern( bool use=true);
	FZ_FUNCTION void use_virtual_op_sc_pattern( bool use=true);
	FZ_FUNCTION void use_virtual_op_SC_shade( bool use=true);
	FZ_FUNCTION void use_virtual_op_sc_shade( bool use=true);
	FZ_FUNCTION void use_virtual_op_SC_color( bool use=true);
	FZ_FUNCTION void use_virtual_op_sc_color( bool use=true);
	FZ_FUNCTION void use_virtual_op_G( bool use=true);
	FZ_FUNCTION void use_virtual_op_g( bool use=true);
	FZ_FUNCTION void use_virtual_op_RG( bool use=true);
	FZ_FUNCTION void use_virtual_op_rg( bool use=true);
	FZ_FUNCTION void use_virtual_op_K( bool use=true);
	FZ_FUNCTION void use_virtual_op_k( bool use=true);
	FZ_FUNCTION void use_virtual_op_BI( bool use=true);
	FZ_FUNCTION void use_virtual_op_sh( bool use=true);
	FZ_FUNCTION void use_virtual_op_Do_image( bool use=true);
	FZ_FUNCTION void use_virtual_op_Do_form( bool use=true);
	FZ_FUNCTION void use_virtual_op_MP( bool use=true);
	FZ_FUNCTION void use_virtual_op_DP( bool use=true);
	FZ_FUNCTION void use_virtual_op_BMC( bool use=true);
	FZ_FUNCTION void use_virtual_op_BDC( bool use=true);
	FZ_FUNCTION void use_virtual_op_EMC( bool use=true);
	FZ_FUNCTION void use_virtual_op_BX( bool use=true);
	FZ_FUNCTION void use_virtual_op_EX( bool use=true);
	FZ_FUNCTION void use_virtual_op_gs_OP( bool use=true);
	FZ_FUNCTION void use_virtual_op_gs_op( bool use=true);
	FZ_FUNCTION void use_virtual_op_gs_OPM( bool use=true);
	FZ_FUNCTION void use_virtual_op_gs_UseBlackPtComp( bool use=true);
	FZ_FUNCTION void use_virtual_op_END( bool use=true);

	/** Default virtual method implementations; these all throw an exception. */
	FZ_FUNCTION virtual void close_processor();
	FZ_FUNCTION virtual void drop_processor();
	FZ_FUNCTION virtual void op_w(float arg_2);
	FZ_FUNCTION virtual void op_j(int arg_2);
	FZ_FUNCTION virtual void op_J(int arg_2);
	FZ_FUNCTION virtual void op_M(float arg_2);
	FZ_FUNCTION virtual void op_d(struct pdf_obj *arg_2, float arg_3);
	FZ_FUNCTION virtual void op_ri(const char *arg_2);
	FZ_FUNCTION virtual void op_i(float arg_2);
	FZ_FUNCTION virtual void op_gs_begin(const char *arg_2, struct pdf_obj *arg_3);
	FZ_FUNCTION virtual void op_gs_BM(const char *arg_2);
	FZ_FUNCTION virtual void op_gs_ca(float arg_2);
	FZ_FUNCTION virtual void op_gs_CA(float arg_2);
	FZ_FUNCTION virtual void op_gs_SMask(struct pdf_obj *arg_2, struct pdf_obj *arg_3, float *arg_4, int arg_5);
	FZ_FUNCTION virtual void op_gs_end();
	FZ_FUNCTION virtual void op_q();
	FZ_FUNCTION virtual void op_Q();
	FZ_FUNCTION virtual void op_cm(float arg_2, float arg_3, float arg_4, float arg_5, float arg_6, float arg_7);
	FZ_FUNCTION virtual void op_m(float arg_2, float arg_3);
	FZ_FUNCTION virtual void op_l(float arg_2, float arg_3);
	FZ_FUNCTION virtual void op_c(float arg_2, float arg_3, float arg_4, float arg_5, float arg_6, float arg_7);
	FZ_FUNCTION virtual void op_v(float arg_2, float arg_3, float arg_4, float arg_5);
	FZ_FUNCTION virtual void op_y(float arg_2, float arg_3, float arg_4, float arg_5);
	FZ_FUNCTION virtual void op_h();
	FZ_FUNCTION virtual void op_re(float arg_2, float arg_3, float arg_4, float arg_5);
	FZ_FUNCTION virtual void op_S();
	FZ_FUNCTION virtual void op_s();
	FZ_FUNCTION virtual void op_F();
	FZ_FUNCTION virtual void op_f();
	FZ_FUNCTION virtual void op_fstar();
	FZ_FUNCTION virtual void op_B();
	FZ_FUNCTION virtual void op_Bstar();
	FZ_FUNCTION virtual void op_b();
	FZ_FUNCTION virtual void op_bstar();
	FZ_FUNCTION virtual void op_n();
	FZ_FUNCTION virtual void op_W();
	FZ_FUNCTION virtual void op_Wstar();
	FZ_FUNCTION virtual void op_BT();
	FZ_FUNCTION virtual void op_ET();
	FZ_FUNCTION virtual void op_Tc(float arg_2);
	FZ_FUNCTION virtual void op_Tw(float arg_2);
	FZ_FUNCTION virtual void op_Tz(float arg_2);
	FZ_FUNCTION virtual void op_TL(float arg_2);
	FZ_FUNCTION virtual void op_Tf(const char *arg_2, pdf_font_desc *arg_3, float arg_4);
	FZ_FUNCTION virtual void op_Tr(int arg_2);
	FZ_FUNCTION virtual void op_Ts(float arg_2);
	FZ_FUNCTION virtual void op_Td(float arg_2, float arg_3);
	FZ_FUNCTION virtual void op_TD(float arg_2, float arg_3);
	FZ_FUNCTION virtual void op_Tm(float arg_2, float arg_3, float arg_4, float arg_5, float arg_6, float arg_7);
	FZ_FUNCTION virtual void op_Tstar();
	FZ_FUNCTION virtual void op_TJ(struct pdf_obj *arg_2);
	FZ_FUNCTION virtual void op_Tj(char *arg_2, unsigned long arg_3);
	FZ_FUNCTION virtual void op_squote(char *arg_2, unsigned long arg_3);
	FZ_FUNCTION virtual void op_dquote(float arg_2, float arg_3, char *arg_4, unsigned long arg_5);
	FZ_FUNCTION virtual void op_d0(float arg_2, float arg_3);
	FZ_FUNCTION virtual void op_d1(float arg_2, float arg_3, float arg_4, float arg_5, float arg_6, float arg_7);
	FZ_FUNCTION virtual void op_CS(const char *arg_2, struct fz_colorspace *arg_3);
	FZ_FUNCTION virtual void op_cs(const char *arg_2, struct fz_colorspace *arg_3);
	FZ_FUNCTION virtual void op_SC_pattern(const char *arg_2, pdf_pattern *arg_3, int arg_4, float *arg_5);
	FZ_FUNCTION virtual void op_sc_pattern(const char *arg_2, pdf_pattern *arg_3, int arg_4, float *arg_5);
	FZ_FUNCTION virtual void op_SC_shade(const char *arg_2, fz_shade *arg_3);
	FZ_FUNCTION virtual void op_sc_shade(const char *arg_2, fz_shade *arg_3);
	FZ_FUNCTION virtual void op_SC_color(int arg_2, float *arg_3);
	FZ_FUNCTION virtual void op_sc_color(int arg_2, float *arg_3);
	FZ_FUNCTION virtual void op_G(float arg_2);
	FZ_FUNCTION virtual void op_g(float arg_2);
	FZ_FUNCTION virtual void op_RG(float arg_2, float arg_3, float arg_4);
	FZ_FUNCTION virtual void op_rg(float arg_2, float arg_3, float arg_4);
	FZ_FUNCTION virtual void op_K(float arg_2, float arg_3, float arg_4, float arg_5);
	FZ_FUNCTION virtual void op_k(float arg_2, float arg_3, float arg_4, float arg_5);
	FZ_FUNCTION virtual void op_BI(struct fz_image *arg_2, const char *arg_3);
	FZ_FUNCTION virtual void op_sh(const char *arg_2, fz_shade *arg_3);
	FZ_FUNCTION virtual void op_Do_image(const char *arg_2, struct fz_image *arg_3);
	FZ_FUNCTION virtual void op_Do_form(const char *arg_2, struct pdf_obj *arg_3, struct pdf_obj *arg_4);
	FZ_FUNCTION virtual void op_MP(const char *arg_2);
	FZ_FUNCTION virtual void op_DP(const char *arg_2, struct pdf_obj *arg_3, struct pdf_obj *arg_4);
	FZ_FUNCTION virtual void op_BMC(const char *arg_2);
	FZ_FUNCTION virtual void op_BDC(const char *arg_2, struct pdf_obj *arg_3, struct pdf_obj *arg_4);
	FZ_FUNCTION virtual void op_EMC();
	FZ_FUNCTION virtual void op_BX();
	FZ_FUNCTION virtual void op_EX();
	FZ_FUNCTION virtual void op_gs_OP(int arg_2);
	FZ_FUNCTION virtual void op_gs_op(int arg_2);
	FZ_FUNCTION virtual void op_gs_OPM(int arg_2);
	FZ_FUNCTION virtual void op_gs_UseBlackPtComp(struct pdf_obj *arg_2);
	FZ_FUNCTION virtual void op_END();
};

/** Wrapper class for struct `pdf_range`. Not copyable or assignable. */
struct PdfRange
{
	/** Constructor using raw copy of pre-existing `pdf_range`. */
	FZ_FUNCTION PdfRange(pdf_range* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_range* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfRange(const PdfRange& rhs);
	PdfRange& operator=(const PdfRange& rhs);
};

/** Wrapper class for struct `pdf_redact_options`. */
struct PdfRedactOptions
{
	/** Default constructor initialises .black_boxes=0 and .image_method=0. */
	FZ_FUNCTION PdfRedactOptions();

	/** We use default copy constructor and operator=. */

	/** Constructor using raw copy of pre-existing `pdf_redact_options`. */
	FZ_FUNCTION PdfRedactOptions(const pdf_redact_options* internal);

	/** Constructor using raw copy of pre-existing `pdf_redact_options`. */
	FZ_FUNCTION PdfRedactOptions(const pdf_redact_options internal);

	/** Access as underlying struct. */
	FZ_FUNCTION pdf_redact_options* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const pdf_redact_options* internal() const;

	/** We use default destructor. */

	/* == Member data. */

	/* These members are the same as the members of pdf_redact_options. */
	int black_boxes;
	int image_method;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();
};

/** Writes a PdfRedactOptions's underlying pdf_redact_options's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const PdfRedactOptions& rhs);

/** Wrapper class for struct `pdf_rev_page_map`. Not copyable or assignable. */
struct PdfRevPageMap
{
	/** Constructor using raw copy of pre-existing `pdf_rev_page_map`. */
	FZ_FUNCTION PdfRevPageMap(pdf_rev_page_map* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_rev_page_map* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfRevPageMap(const PdfRevPageMap& rhs);
	PdfRevPageMap& operator=(const PdfRevPageMap& rhs);
};

/** Wrapper class for struct `pdf_text_object_state`. Not copyable or assignable. */
struct PdfTextObjectState
{
	/* == Methods. */

	/** Wrapper for `pdf_tos_get_text()`.  */
	FZ_FUNCTION Text tos_get_text();

	/** Wrapper for `pdf_tos_make_trm()`.  */
	FZ_FUNCTION int tos_make_trm(const PdfTextState& text, const PdfFontDesc& fontdesc, int cid, Matrix& trm);

	/** Wrapper for `pdf_tos_move_after_char()`.  */
	FZ_FUNCTION void tos_move_after_char();

	/** Wrapper for `pdf_tos_newline()`.  */
	FZ_FUNCTION void tos_newline(float leading);

	/** Wrapper for `pdf_tos_reset()`.  */
	FZ_FUNCTION void tos_reset(int render);

	/** Wrapper for `pdf_tos_set_matrix()`.  */
	FZ_FUNCTION void tos_set_matrix(float a, float b, float c, float d, float e, float f);

	/** Wrapper for `pdf_tos_translate()`.  */
	FZ_FUNCTION void tos_translate(float tx, float ty);

	/** Constructor using raw copy of pre-existing `pdf_text_object_state`. */
	FZ_FUNCTION PdfTextObjectState(pdf_text_object_state* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_text_object_state* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfTextObjectState(const PdfTextObjectState& rhs);
	PdfTextObjectState& operator=(const PdfTextObjectState& rhs);
};

/** Wrapper class for struct `pdf_text_state`. Not copyable or assignable. */
struct PdfTextState
{
	/** Constructor using raw copy of pre-existing `pdf_text_state`. */
	FZ_FUNCTION PdfTextState(pdf_text_state* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_text_state* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfTextState(const PdfTextState& rhs);
	PdfTextState& operator=(const PdfTextState& rhs);
};

/** Wrapper class for struct `pdf_unsaved_sig`. Not copyable or assignable. */
struct PdfUnsavedSig
{
	/** Constructor using raw copy of pre-existing `pdf_unsaved_sig`. */
	FZ_FUNCTION PdfUnsavedSig(pdf_unsaved_sig* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_unsaved_sig* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfUnsavedSig(const PdfUnsavedSig& rhs);
	PdfUnsavedSig& operator=(const PdfUnsavedSig& rhs);
};

/** Wrapper class for struct `pdf_vmtx`. Not copyable or assignable. */
struct PdfVmtx
{
	/** Constructor using raw copy of pre-existing `pdf_vmtx`. */
	FZ_FUNCTION PdfVmtx(pdf_vmtx* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_vmtx* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfVmtx(const PdfVmtx& rhs);
	PdfVmtx& operator=(const PdfVmtx& rhs);
};

/** Wrapper class for struct `pdf_write_options`. */
struct PdfWriteOptions
{
	/** Default constructor, makes copy of pdf_default_write_options. */
	FZ_FUNCTION PdfWriteOptions();

	/** Copy constructor using plain memcpy(). */
	FZ_FUNCTION PdfWriteOptions(const PdfWriteOptions& rhs);

	/** We use default copy constructor and operator=. */

	/* == Methods. */

	/** Wrapper for `pdf_parse_write_options()`.  */
	FZ_FUNCTION PdfWriteOptions parse_write_options(const char *args);

	/** Assignment using plain memcpy(). */
	FZ_FUNCTION PdfWriteOptions& operator=(const PdfWriteOptions& rhs);

	/** Copies <text> into opwd_utf8[]. */
	FZ_FUNCTION void opwd_utf8_set_value(const std::string& text);

	/** Copies <text> into upwd_utf8[]. */
	FZ_FUNCTION void upwd_utf8_set_value(const std::string& text);

	/** Constructor using raw copy of pre-existing `pdf_write_options`. */
	FZ_FUNCTION PdfWriteOptions(const pdf_write_options* internal);

	/** Constructor using raw copy of pre-existing `pdf_write_options`. */
	FZ_FUNCTION PdfWriteOptions(const pdf_write_options internal);

	/** Access as underlying struct. */
	FZ_FUNCTION pdf_write_options* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const pdf_write_options* internal() const;

	/** We use default destructor. */

	/* == Member data. */

	/* These members are the same as the members of pdf_write_options. */
	int do_incremental;
	int do_pretty;
	int do_ascii;
	int do_compress;
	int do_compress_images;
	int do_compress_fonts;
	int do_decompress;
	int do_garbage;
	int do_linear;
	int do_clean;
	int do_sanitize;
	int do_appearance;
	int do_encrypt;
	int dont_regenerate_id;
	int permissions;
	char opwd_utf8[128];
	char upwd_utf8[128];
	int do_snapshot;
	int do_preserve_metadata;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();
};

/** Writes a PdfWriteOptions's underlying pdf_write_options's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const PdfWriteOptions& rhs);

/** Wrapper class for struct `pdf_xrange`. Not copyable or assignable. */
struct PdfXrange
{
	/** Constructor using raw copy of pre-existing `pdf_xrange`. */
	FZ_FUNCTION PdfXrange(pdf_xrange* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_xrange* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfXrange(const PdfXrange& rhs);
	PdfXrange& operator=(const PdfXrange& rhs);
};

/** Wrapper class for struct `pdf_xref`. Not copyable or assignable. */
struct PdfXref
{
	/** == Constructors. */

	/** Constructor using `pdf_new_local_xref()`. */
	FZ_FUNCTION PdfXref(const PdfDocument& doc);

	/** Constructor using raw copy of pre-existing `pdf_xref`. */
	FZ_FUNCTION PdfXref(pdf_xref* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_xref* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfXref(const PdfXref& rhs);
	PdfXref& operator=(const PdfXref& rhs);
};

/** Wrapper class for struct `pdf_xref_entry`. Not copyable or assignable. */
struct PdfXrefEntry
{
	/** Constructor using raw copy of pre-existing `pdf_xref_entry`. */
	FZ_FUNCTION PdfXrefEntry(pdf_xref_entry* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_xref_entry* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfXrefEntry(const PdfXrefEntry& rhs);
	PdfXrefEntry& operator=(const PdfXrefEntry& rhs);
};

/** Wrapper class for struct `pdf_xref_subsec`. Not copyable or assignable. */
struct PdfXrefSubsec
{
	/** Constructor using raw copy of pre-existing `pdf_xref_subsec`. */
	FZ_FUNCTION PdfXrefSubsec(pdf_xref_subsec* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	pdf_xref_subsec* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PdfXrefSubsec(const PdfXrefSubsec& rhs);
	PdfXrefSubsec& operator=(const PdfXrefSubsec& rhs);
};

/** Wrapper class for struct `fz_pdfocr_options`. */
/**
	PDFOCR output
*/
struct PdfocrOptions
{
	/** Default constructor; sets all fields to zero or empty string. */
	FZ_FUNCTION PdfocrOptions();

	/** We use default copy constructor and operator=. */

	/* == Methods. */

	/** Wrapper for `fz_parse_pdfocr_options()`.  */
	/**
		Parse PDFOCR options.
	
		Currently defined options and values are as follows:
	
			compression=none: No compression
			compression=flate: Flate compression
			strip-height=n: Strip height (default 16)
			ocr-language=<lang>: OCR Language (default eng)
			ocr-datadir=<datadir>: OCR data path (default rely on TESSDATA_PREFIX)
	*/
	FZ_FUNCTION PdfocrOptions parse_pdfocr_options(const char *args);

	/** Copies <language> into this->language, truncating if necessary. */
	FZ_FUNCTION void language_set2(const char* language);

	/** Copies <datadir> into this->datadir, truncating if necessary. */
	FZ_FUNCTION void datadir_set2(const char* datadir);

	/** Constructor using raw copy of pre-existing `fz_pdfocr_options`. */
	FZ_FUNCTION PdfocrOptions(const fz_pdfocr_options* internal);

	/** Constructor using raw copy of pre-existing `fz_pdfocr_options`. */
	FZ_FUNCTION PdfocrOptions(const fz_pdfocr_options internal);

	/** Access as underlying struct. */
	FZ_FUNCTION fz_pdfocr_options* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const fz_pdfocr_options* internal() const;

	/** We use default destructor. */

	/* == Member data. */

	/* These members are the same as the members of fz_pdfocr_options. */
	int compress;
	int strip_height;
	char language[256];
	char datadir[1024];
	int page_count;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();
};

/** Writes a PdfocrOptions's underlying fz_pdfocr_options's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const PdfocrOptions& rhs);

/** Wrapper class for struct `fz_pixmap`. */
/**
	Pixmaps represent a set of pixels for a 2 dimensional region of
	a plane. Each pixel has n components per pixel. The components
	are in the order process-components, spot-colors, alpha, where
	there can be 0 of any of those types. The data is in
	premultiplied alpha when rendering, but non-premultiplied for
	colorspace conversions and rescaling.
*/
struct Pixmap
{
	/** == Constructors. */

	/** Constructor using `fz_new_pixmap()`. */
	/**
		Create a new pixmap, with its origin at (0,0)
	
		cs: The colorspace to use for the pixmap, or NULL for an alpha
		plane/mask.
	
		w: The width of the pixmap (in pixels)
	
		h: The height of the pixmap (in pixels)
	
		seps: Details of separations.
	
		alpha: 0 for no alpha, 1 for alpha.
	
		Returns a pointer to the new pixmap. Throws exception on failure
		to allocate.
	*/
	FZ_FUNCTION Pixmap(const Colorspace& cs, int w, int h, const Separations& seps, int alpha);

	/** Constructor using `fz_new_pixmap_from_color_and_mask()`. */
	FZ_FUNCTION Pixmap(const Pixmap& color, const Pixmap& mask);

	/** Constructor using `fz_new_pixmap_from_display_list()`. */
	/**
		Render the page to a pixmap using the transform and colorspace.
	
		Ownership of the pixmap is returned to the caller.
	*/
	FZ_FUNCTION Pixmap(const DisplayList& list, Matrix& ctm, const Colorspace& cs, int alpha);

	/** Constructor using `fz_new_pixmap_from_display_list_with_separations()`. */
	/**
		Render the page contents with control over spot colors.
	
		Ownership of the pixmap is returned to the caller.
	*/
	FZ_FUNCTION Pixmap(const DisplayList& list, Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha);

	/** Constructor using `fz_new_pixmap_from_page()`. */
	FZ_FUNCTION Pixmap(const Page& page, Matrix& ctm, const Colorspace& cs, int alpha);

	/** Constructor using `fz_new_pixmap_from_page_number()`. */
	FZ_FUNCTION Pixmap(const Document& doc, int number, Matrix& ctm, const Colorspace& cs, int alpha);

	/** Constructor using `fz_new_pixmap_from_page_number_with_separations()`. */
	FZ_FUNCTION Pixmap(const Document& doc, int number, Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha);

	/** Constructor using `fz_new_pixmap_from_page_with_separations()`. */
	FZ_FUNCTION Pixmap(const Page& page, Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha);

	/** Constructor using `fz_new_pixmap_from_pixmap()`. */
	/**
		Create a new pixmap that represents a subarea of the specified
		pixmap. A reference is taken to this pixmap that will be dropped
		on destruction.
	
		The supplied rectangle must be wholly contained within the
		original pixmap.
	
		Returns a pointer to the new pixmap. Throws exception on failure
		to allocate.
	*/
	FZ_FUNCTION Pixmap(const Pixmap& pixmap, Irect& rect);

	/** Constructor using `fz_new_pixmap_with_bbox()`. */
	/**
		Create a pixmap of a given size, location and pixel format.
	
		The bounding box specifies the size of the created pixmap and
		where it will be located. The colorspace determines the number
		of components per pixel. Alpha is always present. Pixmaps are
		reference counted, so drop references using fz_drop_pixmap.
	
		colorspace: Colorspace format used for the created pixmap. The
		pixmap will keep a reference to the colorspace.
	
		bbox: Bounding box specifying location/size of created pixmap.
	
		seps: Details of separations.
	
		alpha: 0 for no alpha, 1 for alpha.
	
		Returns a pointer to the new pixmap. Throws exception on failure
		to allocate.
	*/
	FZ_FUNCTION Pixmap(const Colorspace& colorspace, Irect& bbox, const Separations& seps, int alpha);

	/** Constructor using `fz_new_pixmap_with_bbox_and_data()`. */
	/**
		Create a pixmap of a given size, location and pixel format,
		using the supplied data block.
	
		The bounding box specifies the size of the created pixmap and
		where it will be located. The colorspace determines the number
		of components per pixel. Alpha is always present. Pixmaps are
		reference counted, so drop references using fz_drop_pixmap.
	
		colorspace: Colorspace format used for the created pixmap. The
		pixmap will keep a reference to the colorspace.
	
		rect: Bounding box specifying location/size of created pixmap.
	
		seps: Details of separations.
	
		alpha: Number of alpha planes (0 or 1).
	
		samples: The data block to keep the samples in.
	
		Returns a pointer to the new pixmap. Throws exception on failure
		to allocate.
	*/
	FZ_FUNCTION Pixmap(const Colorspace& colorspace, Irect& rect, const Separations& seps, int alpha, unsigned char *samples);

	/** Constructor using `fz_new_pixmap_with_data()`. */
	/**
		Create a new pixmap, with its origin at
		(0,0) using the supplied data block.
	
		cs: The colorspace to use for the pixmap, or NULL for an alpha
		plane/mask.
	
		w: The width of the pixmap (in pixels)
	
		h: The height of the pixmap (in pixels)
	
		seps: Details of separations.
	
		alpha: 0 for no alpha, 1 for alpha.
	
		stride: The byte offset from the pixel data in a row to the
		pixel data in the next row.
	
		samples: The data block to keep the samples in.
	
		Returns a pointer to the new pixmap. Throws exception on failure to
		allocate.
	*/
	FZ_FUNCTION Pixmap(const Colorspace& colorspace, int w, int h, const Separations& seps, int alpha, int stride, unsigned char *samples);

	/** Copy constructor using `fz_keep_pixmap()`. */
	FZ_FUNCTION Pixmap(const Pixmap& rhs);

	/** operator= using `fz_keep_pixmap()` and `fz_drop_pixmap()`. */
	FZ_FUNCTION Pixmap& operator=(const Pixmap& rhs);

	/* == Static methods. */

	/** Wrapper for `fz_new_pixmap_from_page_contents()`.  */
	/**
		Render the page contents without annotations.
	
		Ownership of the pixmap is returned to the caller.
	*/
	FZ_FUNCTION static Pixmap new_pixmap_from_page_contents(const Page& page, Matrix& ctm, const Colorspace& cs, int alpha);

	/** Wrapper for `fz_new_pixmap_from_page_contents_with_separations()`.  */
	FZ_FUNCTION static Pixmap new_pixmap_from_page_contents_with_separations(const Page& page, Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha);

	/* == Methods. */

	/** Wrapper for `fz_alpha_from_gray()`.  */
	FZ_FUNCTION Pixmap alpha_from_gray();

	/** Wrapper for `fz_clear_pixmap()`.  */
	/**
		Sets all components (including alpha) of
		all pixels in a pixmap to 0.
	
		pix: The pixmap to clear.
	*/
	FZ_FUNCTION void clear_pixmap();

	/** Wrapper for `fz_clear_pixmap_rect_with_value()`.  */
	/**
		Clears a subrect of a pixmap with the given value.
	
		pix: The pixmap to clear.
	
		value: Values in the range 0 to 255 are valid. Each component
		sample for each pixel in the pixmap will be set to this value,
		while alpha will always be set to 255 (non-transparent).
	
		r: the rectangle.
	*/
	FZ_FUNCTION void clear_pixmap_rect_with_value(int value, Irect& r);

	/** Wrapper for `fz_clear_pixmap_with_value()`.  */
	/**
		Clears a pixmap with the given value.
	
		pix: The pixmap to clear.
	
		value: Values in the range 0 to 255 are valid. Each component
		sample for each pixel in the pixmap will be set to this value,
		while alpha will always be set to 255 (non-transparent).
	
		This function is horrible, and should be removed from the
		API and replaced with a less magic one.
	*/
	FZ_FUNCTION void clear_pixmap_with_value(int value);

	/** Wrapper for `fz_clone_pixmap()`.  */
	/**
		Clone a pixmap, copying the pixels and associated data to new
		storage.
	
		The reference count of 'old' is unchanged.
	*/
	FZ_FUNCTION Pixmap clone_pixmap();

	/** Wrapper for `fz_clone_pixmap_area_with_different_seps()`.  */
	FZ_FUNCTION Pixmap clone_pixmap_area_with_different_seps(Irect& bbox, const Colorspace& dcs, const Separations& seps, ColorParams& color_params, const DefaultColorspaces& default_cs);

	/** Wrapper for `fz_convert_indexed_pixmap_to_base()`.  */
	/**
		Convert pixmap from indexed to base colorspace.
	
		This creates a new bitmap containing the converted pixmap data.
	 */
	FZ_FUNCTION Pixmap convert_indexed_pixmap_to_base();

	/** Wrapper for `fz_convert_pixmap()`.  */
	/**
		Convert an existing pixmap to a desired
		colorspace. Other properties of the pixmap, such as resolution
		and position are copied to the converted pixmap.
	
		pix: The pixmap to convert.
	
		default_cs: If NULL pix->colorspace is used. It is possible that
		the data may need to be interpreted as one of the color spaces
		in default_cs.
	
		cs_des: Desired colorspace, may be NULL to denote alpha-only.
	
		prf: Proofing color space through which we need to convert.
	
		color_params: Parameters that may be used in conversion (e.g.
		ri).
	
		keep_alpha: If 0 any alpha component is removed, otherwise
		alpha is kept if present in the pixmap.
	*/
	FZ_FUNCTION Pixmap convert_pixmap(const Colorspace& cs_des, const Colorspace& prf, const DefaultColorspaces& default_cs, ColorParams& color_params, int keep_alpha);

	/** Wrapper for `fz_convert_separation_pixmap_to_base()`.  */
	/**
		Convert pixmap from DeviceN/Separation to base colorspace.
	
		This creates a new bitmap containing the converted pixmap data.
	*/
	FZ_FUNCTION Pixmap convert_separation_pixmap_to_base();

	/** Wrapper for `fz_decode_tile()`.  */
	FZ_FUNCTION void decode_tile(const float *decode);

	/** Wrapper for `fz_fill_pixmap_with_color()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fill_pixmap_with_color(fz_colorspace *colorspace, fz_color_params color_params)` => float color
	 */
	/**
		Fill pixmap with solid color.
	*/
	FZ_FUNCTION void fill_pixmap_with_color(const Colorspace& colorspace, 
			#ifdef SWIG
				float *OUTPUT
			#else
				float *color
			#endif
			, ColorParams& color_params);

	/** Wrapper for `fz_gamma_pixmap()`.  */
	/**
		Apply gamma correction to a pixmap. All components
		of all pixels are modified (except alpha, which is unchanged).
	
		gamma: The gamma value to apply; 1.0 for no change.
	*/
	FZ_FUNCTION void gamma_pixmap(float gamma);

	/** Wrapper for `fz_generate_transition()`.  */
	/**
		Generate a frame of a transition.
	
		tpix: Target pixmap
		opix: Old pixmap
		npix: New pixmap
		time: Position within the transition (0 to 256)
		trans: Transition details
	
		Returns 1 if successfully generated a frame.
	
		Note: Pixmaps must include alpha.
	*/
	FZ_FUNCTION int generate_transition(const Pixmap& opix, const Pixmap& npix, int time, Transition& trans);

	/** Wrapper for `fz_invert_pixmap()`.  */
	/**
		Invert all the pixels in a pixmap. All components (process and
		spots) of all pixels are inverted (except alpha, which is
		unchanged).
	*/
	FZ_FUNCTION void invert_pixmap();

	/** Wrapper for `fz_invert_pixmap_alpha()`.  */
	/**
		Invert the alpha fo all the pixels in a pixmap.
	*/
	FZ_FUNCTION void invert_pixmap_alpha();

	/** Wrapper for `fz_invert_pixmap_luminance()`.  */
	/**
		Transform the pixels in a pixmap so that luminance of each
		pixel is inverted, and the chrominance remains unchanged (as
		much as accuracy allows).
	
		All components of all pixels are inverted (except alpha, which
		is unchanged). Only supports Grey and RGB bitmaps.
	*/
	FZ_FUNCTION void invert_pixmap_luminance();

	/** Wrapper for `fz_invert_pixmap_rect()`.  */
	/**
		Invert all the pixels in a given rectangle of a
		pixmap. All components of all pixels in the rectangle are
		inverted (except alpha, which is unchanged).
	*/
	FZ_FUNCTION void invert_pixmap_rect(Irect& rect);

	/** Wrapper for `fz_is_pixmap_monochrome()`.  */
	/**
		Check if the pixmap is a 1-channel image containing samples with
		only values 0 and 255
	*/
	FZ_FUNCTION int is_pixmap_monochrome();

	/** Wrapper for `fz_new_bitmap_from_pixmap()`.  */
	/**
		Make a bitmap from a pixmap and a halftone.
	
		pix: The pixmap to generate from. Currently must be a single
		color component with no alpha.
	
		ht: The halftone to use. NULL implies the default halftone.
	
		Returns the resultant bitmap. Throws exceptions in the case of
		failure to allocate.
	*/
	FZ_FUNCTION Bitmap new_bitmap_from_pixmap(const Halftone& ht);

	/** Wrapper for `fz_new_bitmap_from_pixmap_band()`.  */
	/**
		Make a bitmap from a pixmap and a
		halftone, allowing for the position of the pixmap within an
		overall banded rendering.
	
		pix: The pixmap to generate from. Currently must be a single
		color component with no alpha.
	
		ht: The halftone to use. NULL implies the default halftone.
	
		band_start: Vertical offset within the overall banded rendering
		(in pixels)
	
		Returns the resultant bitmap. Throws exceptions in the case of
		failure to allocate.
	*/
	FZ_FUNCTION Bitmap new_bitmap_from_pixmap_band(const Halftone& ht, int band_start);

	/** Wrapper for `fz_new_buffer_from_pixmap_as_png()`.  */
	/**
		Reencode a given pixmap as a PNG into a buffer.
	
		Ownership of the buffer is returned.
	*/
	FZ_FUNCTION Buffer new_buffer_from_pixmap_as_png(ColorParams& color_params);

	/** Wrapper for `fz_new_image_from_pixmap()`.  */
	/**
		Create an image from the given
		pixmap.
	
		pixmap: The pixmap to base the image upon. A new reference
		to this is taken.
	
		mask: NULL, or another image to use as a mask for this one.
		A new reference is taken to this image. Supplying a masked
		image as a mask to another image is illegal!
	*/
	FZ_FUNCTION Image new_image_from_pixmap(const Image& mask);

	/** Wrapper for `fz_new_pixmap_from_alpha_channel()`.  */
	FZ_FUNCTION Pixmap new_pixmap_from_alpha_channel();

	/** Wrapper for `fz_new_pixmap_from_color_and_mask()`.  */
	FZ_FUNCTION Pixmap new_pixmap_from_color_and_mask(const Pixmap& mask);

	/** Wrapper for `fz_new_pixmap_from_pixmap()`.  */
	/**
		Create a new pixmap that represents a subarea of the specified
		pixmap. A reference is taken to this pixmap that will be dropped
		on destruction.
	
		The supplied rectangle must be wholly contained within the
		original pixmap.
	
		Returns a pointer to the new pixmap. Throws exception on failure
		to allocate.
	*/
	FZ_FUNCTION Pixmap new_pixmap_from_pixmap(Irect& rect);

	/** Wrapper for `fz_pixmap_alpha()`.  */
	/**
		Return the number of alpha planes in a pixmap.
	
		Returns the number of alphas. Does not throw exceptions.
	*/
	FZ_FUNCTION int pixmap_alpha();

	/** Wrapper for `fz_pixmap_bbox()`.  */
	/**
		Return the bounding box for a pixmap.
	*/
	FZ_FUNCTION Irect pixmap_bbox();

	/** Wrapper for `fz_pixmap_colorants()`.  */
	/**
		Return the number of colorants in a pixmap.
	
		Returns the number of colorants (components, less any spots and
		alpha).
	*/
	FZ_FUNCTION int pixmap_colorants();

	/** Wrapper for `fz_pixmap_colorspace()`.  */
	/**
		Return the colorspace of a pixmap
	
		Returns colorspace.
	*/
	FZ_FUNCTION Colorspace pixmap_colorspace();

	/** Wrapper for `fz_pixmap_components()`.  */
	/**
		Return the number of components in a pixmap.
	
		Returns the number of components (including spots and alpha).
	*/
	FZ_FUNCTION int pixmap_components();

	/** Wrapper for `fz_pixmap_height()`.  */
	/**
		Return the height of the pixmap in pixels.
	*/
	FZ_FUNCTION int pixmap_height();

	/** Wrapper for `fz_pixmap_samples()`.  */
	/**
		Returns a pointer to the pixel data of a pixmap.
	
		Returns the pointer.
	*/
	FZ_FUNCTION unsigned char *pixmap_samples();

	/** Wrapper for `fz_pixmap_spots()`.  */
	/**
		Return the number of spots in a pixmap.
	
		Returns the number of spots (components, less colorants and
		alpha). Does not throw exceptions.
	*/
	FZ_FUNCTION int pixmap_spots();

	/** Wrapper for `fz_pixmap_stride()`.  */
	/**
		Return the number of bytes in a row in the pixmap.
	*/
	FZ_FUNCTION int pixmap_stride();

	/** Wrapper for `fz_pixmap_width()`.  */
	/**
		Return the width of the pixmap in pixels.
	*/
	FZ_FUNCTION int pixmap_width();

	/** Wrapper for `fz_pixmap_x()`.  */
	/**
		Return the x value of the pixmap in pixels.
	*/
	FZ_FUNCTION int pixmap_x();

	/** Wrapper for `fz_pixmap_y()`.  */
	/**
		Return the y value of the pixmap in pixels.
	*/
	FZ_FUNCTION int pixmap_y();

	/** Wrapper for `fz_save_pixmap_as_pam()`.  */
	/**
		Save a pixmap as a pnm (greyscale, rgb or cmyk, with or without
		alpha).
	*/
	FZ_FUNCTION void save_pixmap_as_pam(const char *filename);

	/** Wrapper for `fz_save_pixmap_as_pbm()`.  */
	/**
		Save a pixmap as a pbm. (Performing halftoning).
	*/
	FZ_FUNCTION void save_pixmap_as_pbm(const char *filename);

	/** Wrapper for `fz_save_pixmap_as_pcl()`.  */
	/**
		Save an (RGB) pixmap as color PCL.
	*/
	FZ_FUNCTION void save_pixmap_as_pcl(char *filename, int append, const PclOptions& pcl);

	/** Wrapper for `fz_save_pixmap_as_pclm()`.  */
	/**
		Save a (Greyscale or RGB) pixmap as pclm.
	*/
	FZ_FUNCTION void save_pixmap_as_pclm(char *filename, int append, const PclmOptions& options);

	/** Wrapper for `fz_save_pixmap_as_pdfocr()`.  */
	/**
		Save a (Greyscale or RGB) pixmap as pdfocr.
	*/
	FZ_FUNCTION void save_pixmap_as_pdfocr(char *filename, int append, PdfocrOptions& options);

	/** Wrapper for `fz_save_pixmap_as_pkm()`.  */
	/**
		Save a CMYK pixmap as a pkm. (Performing halftoning).
	*/
	FZ_FUNCTION void save_pixmap_as_pkm(const char *filename);

	/** Wrapper for `fz_save_pixmap_as_png()`.  */
	/**
		Save a (Greyscale or RGB) pixmap as a png.
	*/
	FZ_FUNCTION void save_pixmap_as_png(const char *filename);

	/** Wrapper for `fz_save_pixmap_as_pnm()`.  */
	/**
		Save a pixmap as a pnm (greyscale or rgb, no alpha).
	*/
	FZ_FUNCTION void save_pixmap_as_pnm(const char *filename);

	/** Wrapper for `fz_save_pixmap_as_ps()`.  */
	/**
		Save a (gray, rgb, or cmyk, no alpha) pixmap out as postscript.
	*/
	FZ_FUNCTION void save_pixmap_as_ps(char *filename, int append);

	/** Wrapper for `fz_save_pixmap_as_psd()`.  */
	/**
		Save a pixmap as a PSD file.
	*/
	FZ_FUNCTION void save_pixmap_as_psd(const char *filename);

	/** Wrapper for `fz_save_pixmap_as_pwg()`.  */
	/**
		Save a pixmap as a PWG.
	*/
	FZ_FUNCTION void save_pixmap_as_pwg(char *filename, int append, PwgOptions& pwg);

	/** Wrapper for `fz_set_pixmap_resolution()`.  */
	/**
		Set the pixels per inch resolution of the pixmap.
	*/
	FZ_FUNCTION void set_pixmap_resolution(int xres, int yres);

	/** Wrapper for `fz_tint_pixmap()`.  */
	/**
		Tint all the pixels in an RGB, BGR, or Gray pixmap.
	
		black: Map black to this hexadecimal RGB color.
	
		white: Map white to this hexadecimal RGB color.
	*/
	FZ_FUNCTION void tint_pixmap(int black, int white);

	/** Wrapper for fz_md5_pixmap(). */
	FZ_FUNCTION std::vector<unsigned char> md5_pixmap();

	/** Alternative to pixmap_samples() that returns pointer as integer. */
	FZ_FUNCTION long long pixmap_samples_int();

	/** Returns m_internal->samples[offset]. */
	FZ_FUNCTION int samples_get(int offset);

	/** Sets m_internal->samples[offset] to value. */
	FZ_FUNCTION void samples_set(int offset, int value);

	/** Constructor using raw copy of pre-existing `fz_pixmap`. */
	FZ_FUNCTION Pixmap(fz_pixmap* internal);

	/* == Accessors to members of fz_pixmap m_internal. */

	FZ_FUNCTION fz_storable storable();
	FZ_FUNCTION int x();
	FZ_FUNCTION int y();
	FZ_FUNCTION int w();
	FZ_FUNCTION int h();
	FZ_FUNCTION unsigned char n();
	FZ_FUNCTION unsigned char s();
	FZ_FUNCTION unsigned char alpha();
	FZ_FUNCTION unsigned char flags();
	FZ_FUNCTION ptrdiff_t stride();
	FZ_FUNCTION Separations seps();
	FZ_FUNCTION int xres();
	FZ_FUNCTION int yres();
	FZ_FUNCTION Colorspace colorspace();
	FZ_FUNCTION const unsigned char *samples();
	FZ_FUNCTION Pixmap underlying();

	/** Destructor using fz_drop_pixmap(). */
	FZ_FUNCTION ~Pixmap();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_pixmap* m_internal;
};

/** Wrapper class for struct `fz_pixmap_image`. Not copyable or assignable. */
struct PixmapImage
{
	/* == Methods. */

	/** Wrapper for `fz_pixmap_image_tile()`.  */
	/**
		Retrieve the underlying fz_pixmap for an image.
	
		Returns a pointer to the underlying fz_pixmap for an image,
		or NULL if this image is not based upon an fz_pixmap.
	
		No reference is returned. Lifespan is limited to that of
		the image itself. If required, use fz_keep_pixmap to take
		a reference to keep it longer.
	*/
	FZ_FUNCTION Pixmap pixmap_image_tile();

	/** Wrapper for `fz_set_pixmap_image_tile()`.  */
	FZ_FUNCTION void set_pixmap_image_tile(const Pixmap& pix);

	/** Constructor using raw copy of pre-existing `fz_pixmap_image`. */
	FZ_FUNCTION PixmapImage(fz_pixmap_image* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_pixmap_image* m_internal;

	private:

	/** This class is not copyable or assignable. */
	PixmapImage(const PixmapImage& rhs);
	PixmapImage& operator=(const PixmapImage& rhs);
};

/** Wrapper class for struct `fz_point`. */
/**
	fz_point is a point in a two-dimensional space.
*/
struct Point
{
	/** Construct using specified values. */
	FZ_FUNCTION Point(float x, float y);

	/** We use default copy constructor and operator=. */

	/* == Static methods. */

	/** Wrapper for `fz_transform_point()`.  */
	/**
		Apply a transformation to a point.
	
		transform: Transformation matrix to apply. See fz_concat,
		fz_scale, fz_rotate and fz_translate for how to create a
		matrix.
	
		point: Pointer to point to update.
	
		Returns transform (unchanged).
	*/
	FZ_FUNCTION static Point transform_point(Point& point, Matrix& m);

	/** Wrapper for `fz_transform_point_xy()`.  */
	FZ_FUNCTION static Point transform_point_xy(float x, float y, Matrix& m);

	/** Wrapper for `fz_transform_vector()`.  */
	/**
		Apply a transformation to a vector.
	
		transform: Transformation matrix to apply. See fz_concat,
		fz_scale and fz_rotate for how to create a matrix. Any
		translation will be ignored.
	
		vector: Pointer to vector to update.
	*/
	FZ_FUNCTION static Point transform_vector(Point& vector, Matrix& m);

	/* == Methods. */

	/** Wrapper for `fz_is_point_inside_quad()`.  */
	/**
		Inclusion test for quads.
	*/
	FZ_FUNCTION int is_point_inside_quad(Quad& q);

	/** Wrapper for `fz_is_point_inside_rect()`.  */
	/**
		Inclusion test for rects. (Rect is assumed to be open, i.e.
		top right corner is not included).
	*/
	FZ_FUNCTION int is_point_inside_rect(Rect& r);

	/** Wrapper for `fz_normalize_vector()`.  */
	/**
		Normalize a vector to length one.
	*/
	FZ_FUNCTION Point normalize_vector();

	/** Wrapper for `fz_transform_point()`.  */
	/**
		Apply a transformation to a point.
	
		transform: Transformation matrix to apply. See fz_concat,
		fz_scale, fz_rotate and fz_translate for how to create a
		matrix.
	
		point: Pointer to point to update.
	
		Returns transform (unchanged).
	*/
	FZ_FUNCTION Point transform_point(Matrix& m);

	/** Wrapper for `fz_transform_vector()`.  */
	/**
		Apply a transformation to a vector.
	
		transform: Transformation matrix to apply. See fz_concat,
		fz_scale and fz_rotate for how to create a matrix. Any
		translation will be ignored.
	
		vector: Pointer to vector to update.
	*/
	FZ_FUNCTION Point transform_vector(Matrix& m);

	/** Post-multiply *this by <m> and return *this. */
	FZ_FUNCTION Point& transform(const Matrix& m);

	/** Constructor using raw copy of pre-existing `fz_point`. */
	FZ_FUNCTION Point(const fz_point* internal);

	/** Constructor using raw copy of pre-existing `fz_point`. */
	FZ_FUNCTION Point(const fz_point internal);

	/** Access as underlying struct. */
	FZ_FUNCTION fz_point* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const fz_point* internal() const;

	/** We use default destructor. */

	/* == Member data. */

	/* These members are the same as the members of fz_point. */
	float x;
	float y;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();
};

/** Writes a Point's underlying fz_point's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const Point& rhs);

/** Wrapper class for struct `fz_pool`. Not copyable or assignable. */
/**
	Simple pool allocators.

	Allocate from the pool, which can then be freed at once.
*/
struct Pool
{
	/** == Constructors. */

	/** Constructor using `fz_new_pool()`. */
	/**
		Create a new pool to allocate from.
	*/
	FZ_FUNCTION Pool();

	/* == Methods. */

	/** Wrapper for `fz_pool_alloc()`.  */
	/**
		Allocate a block of size bytes from the pool.
	*/
	FZ_FUNCTION void *pool_alloc(size_t size);

	/** Wrapper for `fz_pool_size()`.  */
	/**
		The current size of the pool.
	
		The number of bytes of storage currently allocated to the pool.
		This is the total of the storage used for the blocks making
		up the pool, rather then total of the allocated blocks so far,
		so it will increase in 'lumps'.
		from the pool, then the pool size may still be X
	*/
	FZ_FUNCTION size_t pool_size();

	/** Wrapper for `fz_pool_strdup()`.  */
	/**
		strdup equivalent allocating from the pool.
	*/
	FZ_FUNCTION char *pool_strdup(const char *s);

	/** Constructor using raw copy of pre-existing `fz_pool`. */
	FZ_FUNCTION Pool(fz_pool* internal);

	/** Destructor using fz_drop_pool(). */
	FZ_FUNCTION ~Pool();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_pool* m_internal;

	private:

	/** This class is not copyable or assignable. */
	Pool(const Pool& rhs);
	Pool& operator=(const Pool& rhs);
};

/** Wrapper class for struct `fz_pwg_options`. */
struct PwgOptions
{
	/** We use default copy constructor and operator=. */

	/** Constructor using raw copy of pre-existing `fz_pwg_options`. */
	FZ_FUNCTION PwgOptions(const fz_pwg_options* internal);

	/* == Accessors to members of fz_pwg_options m_internal. */

	FZ_FUNCTION char * media_class();
	FZ_FUNCTION char * media_color();
	FZ_FUNCTION char * media_type();
	FZ_FUNCTION char * output_type();
	FZ_FUNCTION unsigned int advance_distance();
	FZ_FUNCTION int advance_media();
	FZ_FUNCTION int collate();
	FZ_FUNCTION int cut_media();
	FZ_FUNCTION int duplex();
	FZ_FUNCTION int insert_sheet();
	FZ_FUNCTION int jog();
	FZ_FUNCTION int leading_edge();
	FZ_FUNCTION int manual_feed();
	FZ_FUNCTION unsigned int media_position();
	FZ_FUNCTION unsigned int media_weight();
	FZ_FUNCTION int mirror_print();
	FZ_FUNCTION int negative_print();
	FZ_FUNCTION unsigned int num_copies();
	FZ_FUNCTION int orientation();
	FZ_FUNCTION int output_face_up();
	FZ_FUNCTION unsigned int * PageSize();
	FZ_FUNCTION int separations();
	FZ_FUNCTION int tray_switch();
	FZ_FUNCTION int tumble();
	FZ_FUNCTION int media_type_num();
	FZ_FUNCTION int compression();
	FZ_FUNCTION unsigned int row_count();
	FZ_FUNCTION unsigned int row_feed();
	FZ_FUNCTION unsigned int row_step();
	FZ_FUNCTION char * rendering_intent();
	FZ_FUNCTION char * page_size_name();

	/** We use default destructor. */

	/* == Member data. */

	fz_pwg_options  m_internal; /** Wrapped data is held by value. */

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();
};

/** Writes a PwgOptions's underlying fz_pwg_options's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const PwgOptions& rhs);

/** Wrapper class for struct `fz_quad`. */
/**
	A representation for a region defined by 4 points.

	The significant difference between quads and rects is that
	the edges of quads are not axis aligned.
*/
struct Quad
{
	/** == Constructors. */

	/** Constructor using `fz_quad_from_rect()`. */
	/**
		Convert a rect to a quad (losslessly).
	*/
	FZ_FUNCTION Quad(Rect& r);

	/** Constructor using `fz_transform_quad()`. */
	/**
		Transform a quad by a matrix.
	*/
	FZ_FUNCTION Quad(Quad& q, Matrix& m);

	/** Default constructor. */
	FZ_FUNCTION Quad();

	/** We use default copy constructor and operator=. */

	/* == Methods. */

	/** Wrapper for `fz_is_quad_inside_quad()`.  */
	/**
		Inclusion test for quad in quad.
	
		This may break down if quads are not 'well formed'.
	*/
	FZ_FUNCTION int is_quad_inside_quad(Quad& haystack);

	/** Wrapper for `fz_is_quad_intersecting_quad()`.  */
	/**
		Intersection test for quads.
	
		This may break down if quads are not 'well formed'.
	*/
	FZ_FUNCTION int is_quad_intersecting_quad(Quad& b);

	/** Wrapper for `fz_rect_from_quad()`.  */
	/**
		Convert a quad to the smallest rect that covers it.
	*/
	FZ_FUNCTION Rect rect_from_quad();

	/** Wrapper for `fz_transform_quad()`.  */
	/**
		Transform a quad by a matrix.
	*/
	FZ_FUNCTION Quad transform_quad(Matrix& m);

	/** Constructor using raw copy of pre-existing `fz_quad`. */
	FZ_FUNCTION Quad(const fz_quad* internal);

	/** Constructor using raw copy of pre-existing `fz_quad`. */
	FZ_FUNCTION Quad(const fz_quad internal);

	/** Access as underlying struct. */
	FZ_FUNCTION fz_quad* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const fz_quad* internal() const;

	/** We use default destructor. */

	/* == Member data. */

	/* These members are the same as the members of fz_quad. */
	fz_point ul;
	fz_point ur;
	fz_point ll;
	fz_point lr;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();
};

/** Writes a Quad's underlying fz_quad's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const Quad& rhs);

/** Wrapper class for struct `fz_range`. Not copyable or assignable. */
struct Range
{
	/** Constructor using raw copy of pre-existing `fz_range`. */
	FZ_FUNCTION Range(fz_range* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_range* m_internal;

	private:

	/** This class is not copyable or assignable. */
	Range(const Range& rhs);
	Range& operator=(const Range& rhs);
};

/** Wrapper class for struct `fz_rect`. */
struct Rect
{
	enum Fixed
	{
		Fixed_UNIT,
		Fixed_EMPTY,
		Fixed_INFINITE,
	};

	/** == Constructors. */

	/** Constructor using `fz_bound_display_list()`. */
	/**
		Return the bounding box of the page recorded in a display list.
	*/
	FZ_FUNCTION Rect(const DisplayList& list);

	/** Constructor using `fz_rect_from_irect()`. */
	/**
		Convert a bbox into a rect.
	
		For our purposes, a rect can represent all the values we meet in
		a bbox, so nothing can go wrong.
	
		rect: A place to store the generated rectangle.
	
		bbox: The bbox to convert.
	
		Returns rect (updated).
	*/
	FZ_FUNCTION Rect(Irect& bbox);

	/** Constructor using `fz_rect_from_quad()`. */
	/**
		Convert a quad to the smallest rect that covers it.
	*/
	FZ_FUNCTION Rect(Quad& q);

	/** Constructor using `fz_transform_rect()`. */
	/**
		Apply a transform to a rectangle.
	
		After the four corner points of the axis-aligned rectangle
		have been transformed it may not longer be axis-aligned. So a
		new axis-aligned rectangle is created covering at least the
		area of the transformed rectangle.
	
		transform: Transformation matrix to apply. See fz_concat,
		fz_scale and fz_rotate for how to create a matrix.
	
		rect: Rectangle to be transformed. The two special cases
		fz_empty_rect and fz_infinite_rect, may be used but are
		returned unchanged as expected.
	*/
	FZ_FUNCTION Rect(Rect& rect, Matrix& m);

	/** Construct from specified values. */
	FZ_FUNCTION Rect(double x0, double y0, double x1, double y1);

	/** Copy constructor using plain copy. */
	FZ_FUNCTION Rect(const Rect& rhs);

	/** Construct from fz_unit_rect, fz_empty_rect or fz_infinite_rect. */
	FZ_FUNCTION Rect(Fixed fixed);

	/** We use default copy constructor and operator=. */

	/* == Static methods. */

	/** Wrapper for `fz_intersect_rect()`.  */
	/**
		Compute intersection of two rectangles.
	
		Given two rectangles, update the first to be the smallest
		axis-aligned rectangle that covers the area covered by both
		given rectangles. If either rectangle is empty then the
		intersection is also empty. If either rectangle is infinite
		then the intersection is simply the non-infinite rectangle.
		Should both rectangles be infinite, then the intersection is
		also infinite.
	*/
	FZ_FUNCTION static Rect intersect_rect(Rect& a, Rect& b);

	/** Wrapper for `fz_union_rect()`.  */
	/**
		Compute union of two rectangles.
	
		Given two rectangles, update the first to be the smallest
		axis-aligned rectangle that encompasses both given rectangles.
		If either rectangle is infinite then the union is also infinite.
		If either rectangle is empty then the union is simply the
		non-empty rectangle. Should both rectangles be empty, then the
		union is also empty.
	*/
	FZ_FUNCTION static Rect union_rect(Rect& a, Rect& b);

	/* == Methods. */

	/** Wrapper for `fz_adjust_rect_for_stroke()`.  */
	/**
		Given a rectangle (assumed to be the bounding box for a path),
		expand it to allow for the expansion of the bbox that would be
		seen by stroking the path with the given stroke state and
		transform.
	*/
	FZ_FUNCTION Rect adjust_rect_for_stroke(const StrokeState& stroke, Matrix& ctm);

	/** Wrapper for `fz_contains_rect()`.  */
	/**
		Test rectangle inclusion.
	
		Return true if a entirely contains b.
	*/
	FZ_FUNCTION int contains_rect(Rect& b);

	/** Wrapper for `fz_expand_rect()`.  */
	/**
		Expand a bbox by a given amount in all directions.
	*/
	FZ_FUNCTION Rect expand_rect(float expand);

	/** Wrapper for `fz_include_point_in_rect()`.  */
	/**
		Expand a bbox to include a given point.
		To create a rectangle that encompasses a sequence of points, the
		rectangle must first be set to be the empty rectangle at one of
		the points before including the others.
	*/
	FZ_FUNCTION Rect include_point_in_rect(Point& p);

	/** Wrapper for `fz_intersect_rect()`.  */
	/**
		Compute intersection of two rectangles.
	
		Given two rectangles, update the first to be the smallest
		axis-aligned rectangle that covers the area covered by both
		given rectangles. If either rectangle is empty then the
		intersection is also empty. If either rectangle is infinite
		then the intersection is simply the non-infinite rectangle.
		Should both rectangles be infinite, then the intersection is
		also infinite.
	*/
	FZ_FUNCTION Rect intersect_rect(Rect& b);

	/** Wrapper for `fz_irect_from_rect()`.  */
	/**
		Convert a rect into the minimal bounding box
		that covers the rectangle.
	
		Coordinates in a bounding box are integers, so rounding of the
		rects coordinates takes place. The top left corner is rounded
		upwards and left while the bottom right corner is rounded
		downwards and to the right.
	*/
	FZ_FUNCTION Irect irect_from_rect();

	/** Wrapper for `fz_is_empty_rect()`.  */
	/**
		Check if rectangle is empty.
	
		An empty rectangle is defined as one whose area is zero.
		All invalid rectangles are empty.
	*/
	FZ_FUNCTION int is_empty_rect();

	/** Wrapper for `fz_is_infinite_rect()`.  */
	/**
		Check if rectangle is infinite.
	*/
	FZ_FUNCTION int is_infinite_rect();

	/** Wrapper for `fz_is_valid_rect()`.  */
	/**
		Check if rectangle is valid.
	*/
	FZ_FUNCTION int is_valid_rect();

	/** Wrapper for `fz_new_bbox_device()`.  */
	/**
		Create a device to compute the bounding
		box of all marks on a page.
	
		The returned bounding box will be the union of all bounding
		boxes of all objects on a page.
	*/
	FZ_FUNCTION Device new_bbox_device();

	/** Wrapper for `fz_new_display_list()`.  */
	/**
		Create an empty display list.
	
		A display list contains drawing commands (text, images, etc.).
		Use fz_new_list_device for populating the list.
	
		mediabox: Bounds of the page (in points) represented by the
		display list.
	*/
	FZ_FUNCTION DisplayList new_display_list();

	/** Wrapper for `fz_new_link()`.  */
	/**
		Create a new link record.
	
		next is set to NULL with the expectation that the caller will
		handle the linked list setup.
	
		Internal function.
	*/
	FZ_FUNCTION Link new_link(const char *uri);

	/** Wrapper for `fz_quad_from_rect()`.  */
	/**
		Convert a rect to a quad (losslessly).
	*/
	FZ_FUNCTION Quad quad_from_rect();

	/** Wrapper for `fz_round_rect()`.  */
	/**
		Round rectangle coordinates.
	
		Coordinates in a bounding box are integers, so rounding of the
		rects coordinates takes place. The top left corner is rounded
		upwards and left while the bottom right corner is rounded
		downwards and to the right.
	
		This differs from fz_irect_from_rect, in that fz_irect_from_rect
		slavishly follows the numbers (i.e any slight over/under
		calculations can cause whole extra pixels to be added).
		fz_round_rect allows for a small amount of rounding error when
		calculating the bbox.
	*/
	FZ_FUNCTION Irect round_rect();

	/** Wrapper for `fz_transform_page()`.  */
	/**
		Create transform matrix to draw page
		at a given resolution and rotation. Adjusts the scaling
		factors so that the page covers whole number of
		pixels and adjust the page origin to be at 0,0.
	*/
	FZ_FUNCTION Matrix transform_page(float resolution, float rotate);

	/** Wrapper for `fz_transform_rect()`.  */
	/**
		Apply a transform to a rectangle.
	
		After the four corner points of the axis-aligned rectangle
		have been transformed it may not longer be axis-aligned. So a
		new axis-aligned rectangle is created covering at least the
		area of the transformed rectangle.
	
		transform: Transformation matrix to apply. See fz_concat,
		fz_scale and fz_rotate for how to create a matrix.
	
		rect: Rectangle to be transformed. The two special cases
		fz_empty_rect and fz_infinite_rect, may be used but are
		returned unchanged as expected.
	*/
	FZ_FUNCTION Rect transform_rect(Matrix& m);

	/** Wrapper for `fz_translate_rect()`.  */
	/**
		Translate bounding box.
	
		Translate a bbox by a given x and y offset. Allows for overflow.
	*/
	FZ_FUNCTION Rect translate_rect(float xoff, float yoff);

	/** Wrapper for `fz_union_rect()`.  */
	/**
		Compute union of two rectangles.
	
		Given two rectangles, update the first to be the smallest
		axis-aligned rectangle that encompasses both given rectangles.
		If either rectangle is infinite then the union is also infinite.
		If either rectangle is empty then the union is simply the
		non-empty rectangle. Should both rectangles be empty, then the
		union is also empty.
	*/
	FZ_FUNCTION Rect union_rect(Rect& b);

	/** Wrapper for `pdf_signature_appearance_signed()`.  */
	FZ_FUNCTION DisplayList signature_appearance_signed(fz_text_language lang, const Image& img, const char *left_text, const char *right_text, int include_logo);

	/** Wrapper for `pdf_signature_appearance_unsigned()`.  */
	FZ_FUNCTION DisplayList signature_appearance_unsigned(fz_text_language lang);

	/** Transforms *this using fz_transform_rect() with <m>. */
	FZ_FUNCTION void transform(const Matrix& m);

	/** Convenience method using fz_contains_rect(). */
	FZ_FUNCTION bool contains(double x, double y);

	/** Uses fz_contains_rect(*this, rhs). */
	FZ_FUNCTION bool contains(Rect& rhs);

	/** Uses fz_is_empty_rect(). */
	FZ_FUNCTION bool is_empty();

	/** Updates *this using fz_union_rect(). */
	FZ_FUNCTION void union_(Rect& rhs);

	/** Constructor using raw copy of pre-existing `fz_rect`. */
	FZ_FUNCTION Rect(const fz_rect* internal);

	/** Constructor using raw copy of pre-existing `fz_rect`. */
	FZ_FUNCTION Rect(const fz_rect internal);

	/** Access as underlying struct. */
	FZ_FUNCTION fz_rect* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const fz_rect* internal() const;

	/** We use default destructor. */

	/* == Member data. */

	/* These members are the same as the members of fz_rect. */
	float x0;
	float y0;
	float x1;
	float y1;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();
};

/** Writes a Rect's underlying fz_rect's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const Rect& rhs);

/** Wrapper class for struct `fz_separations`. */
struct Separations
{
	/** == Constructors. */

	/** Constructor using `fz_new_separations()`. */
	/**
		Create a new separations structure (initially empty)
	*/
	FZ_FUNCTION Separations(int controllable);

	/** Copy constructor using `fz_keep_separations()`. */
	FZ_FUNCTION Separations(const Separations& rhs);

	/** operator= using `fz_keep_separations()` and `fz_drop_separations()`. */
	FZ_FUNCTION Separations& operator=(const Separations& rhs);

	/* == Methods. */

	/** Wrapper for `fz_add_separation()`.  */
	/**
		Add a separation (null terminated name, colorspace)
	*/
	FZ_FUNCTION void add_separation(const char *name, const Colorspace& cs, int cs_channel);

	/** Wrapper for `fz_add_separation_equivalents()`.  */
	/**
		Add a separation with equivalents (null terminated name,
		colorspace)
	
		(old, deprecated)
	*/
	FZ_FUNCTION void add_separation_equivalents(uint32_t rgba, uint32_t cmyk, const char *name);

	/** Wrapper for `fz_clone_separations_for_overprint()`.  */
	/**
		Return a separations object with all the spots in the input
		separations object that are set to composite, reset to be
		enabled. If there ARE no spots in the object, this returns
		NULL. If the object already has all its spots enabled, then
		just returns another handle on the same object.
	*/
	FZ_FUNCTION Separations clone_separations_for_overprint();

	/** Wrapper for `fz_count_active_separations()`.  */
	/**
		Return the number of active separations.
	*/
	FZ_FUNCTION int count_active_separations();

	/** Wrapper for `fz_count_separations()`.  */
	FZ_FUNCTION int count_separations();

	/** Wrapper for `fz_separation_equivalent()`.
	
	This method has out-params. Python/C# wrappers look like:
		`separation_equivalent(int idx, fz_colorspace *dst_cs, fz_colorspace *prf, fz_color_params color_params)` => float dst_color
	 */
	/**
		Get the equivalent separation color in a given colorspace.
	*/
	FZ_FUNCTION void separation_equivalent(int idx, const Colorspace& dst_cs, 
			#ifdef SWIG
				float *OUTPUT
			#else
				float *dst_color
			#endif
			, const Colorspace& prf, ColorParams& color_params);

	/** Wrapper for `fz_separation_name()`.  */
	FZ_FUNCTION const char *separation_name(int separation);

	/** Wrapper for `fz_set_separation_behavior()`.  */
	/**
		Control the rendering of a given separation.
	*/
	FZ_FUNCTION void set_separation_behavior(int separation, fz_separation_behavior behavior);

	/** Constructor using raw copy of pre-existing `fz_separations`. */
	FZ_FUNCTION Separations(fz_separations* internal=NULL);

	/** Destructor using fz_drop_separations(). */
	FZ_FUNCTION ~Separations();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_separations* m_internal;
};

/** Wrapper class for struct `fz_sha256`. Not copyable or assignable. */
/**
	Structure definition is public to enable stack
	based allocation. Do not access the members directly.
*/
struct Sha256
{
	/* == Methods. */

	/** Wrapper for `fz_sha256_final()`.  */
	/**
		MD5 finalization. Ends an MD5 message-digest operation, writing
		the message digest and zeroizing the context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void sha256_final(unsigned char digest[32]);

	/** Wrapper for `fz_sha256_init()`.  */
	/**
		SHA256 initialization. Begins an SHA256 operation, initialising
		the supplied context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void sha256_init();

	/** Wrapper for `fz_sha256_update()`.  */
	/**
		SHA256 block update operation. Continues an SHA256 message-
		digest operation, processing another message block, and updating
		the context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void sha256_update(const unsigned char *input, size_t inlen);

	/** Constructor using raw copy of pre-existing `fz_sha256`. */
	FZ_FUNCTION Sha256(fz_sha256* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_sha256* m_internal;

	private:

	/** This class is not copyable or assignable. */
	Sha256(const Sha256& rhs);
	Sha256& operator=(const Sha256& rhs);
};

/** Wrapper class for struct `fz_sha512`. Not copyable or assignable. */
/**
	Structure definition is public to enable stack
	based allocation. Do not access the members directly.
*/
struct Sha512
{
	/* == Methods. */

	/** Wrapper for `fz_sha384_final()`.  */
	/**
		SHA384 finalization. Ends an SHA384 message-digest operation,
		writing the message digest and zeroizing the context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void sha384_final(unsigned char digest[64]);

	/** Wrapper for `fz_sha384_init()`.  */
	/**
		SHA384 initialization. Begins an SHA384 operation, initialising
		the supplied context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void sha384_init();

	/** Wrapper for `fz_sha384_update()`.  */
	/**
		SHA384 block update operation. Continues an SHA384 message-
		digest operation, processing another message block, and updating
		the context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void sha384_update(const unsigned char *input, size_t inlen);

	/** Wrapper for `fz_sha512_final()`.  */
	/**
		SHA512 finalization. Ends an SHA512 message-digest operation,
		writing the message digest and zeroizing the context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void sha512_final(unsigned char digest[64]);

	/** Wrapper for `fz_sha512_init()`.  */
	/**
		SHA512 initialization. Begins an SHA512 operation, initialising
		the supplied context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void sha512_init();

	/** Wrapper for `fz_sha512_update()`.  */
	/**
		SHA512 block update operation. Continues an SHA512 message-
		digest operation, processing another message block, and updating
		the context.
	
		Never throws an exception.
	*/
	FZ_FUNCTION void sha512_update(const unsigned char *input, size_t inlen);

	/** Constructor using raw copy of pre-existing `fz_sha512`. */
	FZ_FUNCTION Sha512(fz_sha512* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_sha512* m_internal;

	private:

	/** This class is not copyable or assignable. */
	Sha512(const Sha512& rhs);
	Sha512& operator=(const Sha512& rhs);
};

/** Wrapper class for struct `fz_shade`. */
/**
	Structure is public to allow derived classes. Do not
	access the members directly.
*/
struct Shade
{
	/** Copy constructor using `fz_keep_shade()`. */
	FZ_FUNCTION Shade(const Shade& rhs);

	/** operator= using `fz_keep_shade()` and `fz_drop_shade()`. */
	FZ_FUNCTION Shade& operator=(const Shade& rhs);

	/* == Methods. */

	/** Wrapper for `fz_bound_shade()`.  */
	/**
		Bound a given shading.
	
		shade: The shade to bound.
	
		ctm: The transform to apply to the shade before bounding.
	
		r: Pointer to storage to put the bounds in.
	
		Returns r, updated to contain the bounds for the shading.
	*/
	FZ_FUNCTION Rect bound_shade(Matrix& ctm);

	/** Wrapper for `fz_paint_shade()`.
	
	This method has out-params. Python/C# wrappers look like:
		`paint_shade(fz_colorspace *override_cs, fz_matrix ctm, fz_pixmap *dest, fz_color_params color_params, fz_irect bbox, const fz_overprint *eop, fz_shade_color_cache **cache)` => 
	 */
	/**
		Render a shade to a given pixmap.
	
		shade: The shade to paint.
	
		override_cs: NULL, or colorspace to override the shades
		inbuilt colorspace.
	
		ctm: The transform to apply.
	
		dest: The pixmap to render into.
	
		color_params: The color rendering settings
	
		bbox: Pointer to a bounding box to limit the rendering
		of the shade.
	
		eop: NULL, or pointer to overprint bitmap.
	
		cache: *cache is used to cache color information. If *cache is NULL it
		is set to point to a new fz_shade_color_cache. If cache is NULL it is
		ignored.
	*/
	FZ_FUNCTION void paint_shade(const Colorspace& override_cs, Matrix& ctm, const Pixmap& dest, ColorParams& color_params, Irect& bbox, const Overprint& eop, ShadeColorCache& cache);

	/** Wrapper for `fz_process_shade()`.  */
	/**
		Process a shade, using supplied callback functions. This
		decomposes the shading to a mesh (even ones that are not
		natively meshes, such as linear or radial shadings), and
		processes triangles from those meshes.
	
		shade: The shade to process.
	
		ctm: The transform to use
	
		prepare: Callback function to 'prepare' each vertex.
		This function is passed an array of floats, and populates
		a fz_vertex structure.
	
		process: This function is passed 3 pointers to vertex
		structures, and actually performs the processing (typically
		filling the area between the vertexes).
	
		process_arg: An opaque argument passed through from caller
		to callback functions.
	*/
	FZ_FUNCTION void process_shade(Matrix& ctm, Rect& scissor, fz_shade_prepare_fn *prepare, fz_shade_process_fn *process, void *process_arg);

	/** Extra wrapper for fz_paint_shade(), passing cache=NULL. */
	FZ_FUNCTION void paint_shade_no_cache(const Colorspace& override_cs, Matrix& ctm, const Pixmap& dest, ColorParams& color_params, Irect& bbox, const Overprint& eop);

	/** Constructor using raw copy of pre-existing `fz_shade`. */
	FZ_FUNCTION Shade(fz_shade* internal);

	/** Destructor using fz_drop_shade(). */
	FZ_FUNCTION ~Shade();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_shade* m_internal;
};

/** Wrapper class for struct `fz_shade_color_cache`. Not copyable or assignable. */
struct ShadeColorCache
{
	/** Constructor that sets m_internal to NULL; can then be passed to Shade::paint_shade(). */
	FZ_FUNCTION ShadeColorCache();

	/** Constructor using raw copy of pre-existing `fz_shade_color_cache`. */
	FZ_FUNCTION ShadeColorCache(fz_shade_color_cache* internal);

	/** Destructor using fz_drop_shade_color_cache(). */
	FZ_FUNCTION ~ShadeColorCache();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_shade_color_cache* m_internal;

	private:

	/** This class is not copyable or assignable. */
	ShadeColorCache(const ShadeColorCache& rhs);
	ShadeColorCache& operator=(const ShadeColorCache& rhs);
};

/** Wrapper class for struct `fz_shaper_data_t`. Not copyable or assignable. */
/**
	In order to shape a given font, we need to
	declare it to a shaper library (harfbuzz, by default, but others
	are possible). To avoid redeclaring it every time we need to
	shape, we hold a shaper handle and the destructor for it within
	the font itself. The handle is initialised by the caller when
	first required and the destructor is called when the fz_font is
	destroyed.
*/
struct ShaperDataT
{
	/** Constructor using raw copy of pre-existing `fz_shaper_data_t`. */
	FZ_FUNCTION ShaperDataT(fz_shaper_data_t* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_shaper_data_t* m_internal;

	private:

	/** This class is not copyable or assignable. */
	ShaperDataT(const ShaperDataT& rhs);
	ShaperDataT& operator=(const ShaperDataT& rhs);
};

struct StextBlockIterator;

/** Wrapper class for struct `fz_stext_block`. */
struct StextBlock
{
	/** We use default copy constructor and operator=. */

	/* == Methods. */

	/** Returns m_internal.u.i.transform if m_internal->type is FZ_STEXT_BLOCK_IMAGE, else throws. */
	FZ_FUNCTION Matrix i_transform();

	/** Returns m_internal.u.i.image if m_internal->type is FZ_STEXT_BLOCK_IMAGE, else throws. */
	FZ_FUNCTION Image i_image();

	/** Used for iteration over linked list of StextLine items starting at fz_stext_line::u.t.first_line. */
	FZ_FUNCTION StextBlockIterator begin();

	/** Used for iteration over linked list of StextLine items starting at fz_stext_line::u.t.first_line. */
	FZ_FUNCTION StextBlockIterator end();

	/** Constructor using raw copy of pre-existing `fz_stext_block`. */
	FZ_FUNCTION StextBlock(fz_stext_block* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_stext_block* m_internal;

	typedef StextBlockIterator iterator;
};

/** Wrapper class for struct `fz_stext_char`. */
/**
	Text extraction device: Used for searching, format conversion etc.

	(In development - Subject to change in future versions)
*/
struct StextChar
{
	/** We use default copy constructor and operator=. */

	/** Constructor using raw copy of pre-existing `fz_stext_char`. */
	FZ_FUNCTION StextChar(fz_stext_char* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_stext_char* m_internal;
};

struct StextLineIterator;

/** Wrapper class for struct `fz_stext_line`. */
struct StextLine
{
	/** We use default copy constructor and operator=. */

	/* == Methods. */

	/** Used for iteration over linked list of StextChar items starting at fz_stext_char::first_char. */
	FZ_FUNCTION StextLineIterator begin();

	/** Used for iteration over linked list of StextChar items starting at fz_stext_char::first_char. */
	FZ_FUNCTION StextLineIterator end();

	/** Constructor using raw copy of pre-existing `fz_stext_line`. */
	FZ_FUNCTION StextLine(fz_stext_line* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_stext_line* m_internal;

	typedef StextLineIterator iterator;
};

/** Wrapper class for struct `fz_stext_options`. */
/**
	Options for creating a pixmap and draw device.
*/
struct StextOptions
{
	/** Construct with .flags set to 0. */
	FZ_FUNCTION StextOptions();

	/** Construct with .flags set to <flags>. */
	FZ_FUNCTION StextOptions(int flags);

	/** We use default copy constructor and operator=. */

	/* == Methods. */

	/** Wrapper for `fz_parse_stext_options()`.  */
	/**
		Parse stext device options from a comma separated key-value
		string.
	*/
	FZ_FUNCTION StextOptions parse_stext_options(const char *string);

	/** Constructor using raw copy of pre-existing `fz_stext_options`. */
	FZ_FUNCTION StextOptions(const fz_stext_options* internal);

	/** Constructor using raw copy of pre-existing `fz_stext_options`. */
	FZ_FUNCTION StextOptions(const fz_stext_options internal);

	/** Access as underlying struct. */
	FZ_FUNCTION fz_stext_options* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const fz_stext_options* internal() const;

	/** We use default destructor. */

	/* == Member data. */

	/* These members are the same as the members of fz_stext_options. */
	int flags;
	float scale;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();
};

/** Writes a StextOptions's underlying fz_stext_options's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const StextOptions& rhs);

struct StextPageIterator;

/** Wrapper class for struct `fz_stext_page`. Not copyable or assignable. */
/**
	A text page is a list of blocks, together with an overall
	bounding box.
*/
struct StextPage
{
	/** == Constructors. */

	/** Constructor using `fz_new_stext_page()`. */
	/**
		Create an empty text page.
	
		The text page is filled out by the text device to contain the
		blocks and lines of text on the page.
	
		mediabox: optional mediabox information.
	*/
	FZ_FUNCTION StextPage(Rect& mediabox);

	/** Constructor using `fz_new_stext_page_from_chapter_page_number()`. */
	FZ_FUNCTION StextPage(const Document& doc, int chapter, int number, StextOptions& options);

	/** Constructor using `fz_new_stext_page_from_display_list()`. */
	FZ_FUNCTION StextPage(const DisplayList& list, StextOptions& options);

	/** Constructor using `fz_new_stext_page_from_page()`. */
	/**
		Extract text from page.
	
		Ownership of the fz_stext_page is returned to the caller.
	*/
	FZ_FUNCTION StextPage(const Page& page, StextOptions& options);

	/** Constructor using `fz_new_stext_page_from_page_number()`. */
	FZ_FUNCTION StextPage(const Document& doc, int number, StextOptions& options);

	/* == Methods. */

	/** Wrapper for `fz_highlight_selection()`.  */
	/**
		Return a list of quads to highlight lines inside the selection
		points.
	*/
	FZ_FUNCTION int highlight_selection(Point& a, Point& b, Quad& quads, int max_quads);

	/** Wrapper for `fz_new_buffer_from_stext_page()`.  */
	/**
		Convert structured text into plain text.
	*/
	FZ_FUNCTION Buffer new_buffer_from_stext_page();

	/** Wrapper for `fz_new_stext_device()`.  */
	/**
		Create a device to extract the text on a page.
	
		Gather the text on a page into blocks and lines.
	
		The reading order is taken from the order the text is drawn in
		the source file, so may not be accurate.
	
		page: The text page to which content should be added. This will
		usually be a newly created (empty) text page, but it can be one
		containing data already (for example when merging multiple
		pages, or watermarking).
	
		options: Options to configure the stext device.
	*/
	FZ_FUNCTION Device new_stext_device(StextOptions& options);

	/** Wrapper for `fz_snap_selection()`.  */
	FZ_FUNCTION Quad snap_selection(Point& ap, Point& bp, int mode);

	/** Wrapper for fz_copy_selection(). */
	FZ_FUNCTION std::string copy_selection(Point& a, Point& b, int crlf);

	/** Wrapper for fz_copy_rectangle(). */
	FZ_FUNCTION std::string copy_rectangle(Rect& area, int crlf);

	/** Wrapper for fz_search_stext_page() that returns vector of Quads. */
	FZ_FUNCTION std::vector<Quad> search_stext_page(const char* needle, int *hit_mark, int max_quads);

	/** Used for iteration over linked list of StextBlock items starting at fz_stext_block::first_block. */
	FZ_FUNCTION StextPageIterator begin();

	/** Used for iteration over linked list of StextBlock items starting at fz_stext_block::first_block. */
	FZ_FUNCTION StextPageIterator end();

	/** Constructor using raw copy of pre-existing `fz_stext_page`. */
	FZ_FUNCTION StextPage(fz_stext_page* internal);

	/** Destructor using fz_drop_stext_page(). */
	FZ_FUNCTION ~StextPage();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_stext_page* m_internal;

	typedef StextPageIterator iterator;

	private:

	/** This class is not copyable or assignable. */
	StextPage(const StextPage& rhs);
	StextPage& operator=(const StextPage& rhs);
};

/** Wrapper class for struct `fz_storable`. */
/**
	Resource store

	MuPDF stores decoded "objects" into a store for potential reuse.
	If the size of the store gets too big, objects stored within it
	can be evicted and freed to recover space. When MuPDF comes to
	decode such an object, it will check to see if a version of this
	object is already in the store - if it is, it will simply reuse
	it. If not, it will decode it and place it into the store.

	All objects that can be placed into the store are derived from
	the fz_storable type (i.e. this should be the first component of
	the objects structure). This allows for consistent (thread safe)
	reference counting, and includes a function that will be called
	to free the object as soon as the reference count reaches zero.

	Most objects offer fz_keep_XXXX/fz_drop_XXXX functions derived
	from fz_keep_storable/fz_drop_storable. Creation of such objects
	includes a call to FZ_INIT_STORABLE to set up the fz_storable
	header.
 */
struct Storable
{
	/** Copy constructor using `fz_keep_storable()`. */
	FZ_FUNCTION Storable(const Storable& rhs);

	/** operator= using `fz_keep_storable()` and `fz_drop_storable()`. */
	FZ_FUNCTION Storable& operator=(const Storable& rhs);

	/** Constructor using raw copy of pre-existing `fz_storable`. */
	FZ_FUNCTION Storable(fz_storable* internal);

	/** Destructor using fz_drop_storable(). */
	FZ_FUNCTION ~Storable();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_storable* m_internal;
};

/** Wrapper class for struct `fz_store`. Not copyable or assignable. */
struct Store
{
	/** Constructor using raw copy of pre-existing `fz_store`. */
	FZ_FUNCTION Store(fz_store* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_store* m_internal;

	private:

	/** This class is not copyable or assignable. */
	Store(const Store& rhs);
	Store& operator=(const Store& rhs);
};

/** Wrapper class for struct `fz_store_hash`. Not copyable or assignable. */
/**
	The store can be seen as a dictionary that maps keys to
	fz_storable values. In order to allow keys of different types to
	be stored, we have a structure full of functions for each key
	'type'; this fz_store_type pointer is stored with each key, and
	tells the store how to perform certain operations (like taking/
	dropping a reference, comparing two keys, outputting details for
	debugging etc).

	The store uses a hash table internally for speed where possible.
	In order for this to work, we need a mechanism for turning a
	generic 'key' into 'a hashable string'. For this purpose the
	type structure contains a make_hash_key function pointer that
	maps from a void * to a fz_store_hash structure. If
	make_hash_key function returns 0, then the key is determined not
	to be hashable, and the value is not stored in the hash table.

	Some objects can be used both as values within the store, and as
	a component of keys within the store. We refer to these objects
	as "key storable" objects. In this case, we need to take
	additional care to ensure that we do not end up keeping an item
	within the store, purely because its value is referred to by
	another key in the store.

	An example of this are fz_images in PDF files. Each fz_image is
	placed into the	store to enable it to be easily reused. When the
	image is rendered, a pixmap is generated from the image, and the
	pixmap is placed into the store so it can be reused on
	subsequent renders. The image forms part of the key for the
	pixmap.

	When we close the pdf document (and any associated pages/display
	lists etc), we drop the images from the store. This may leave us
	in the position of the images having non-zero reference counts
	purely because they are used as part of the keys for the
	pixmaps.

	We therefore use special reference counting functions to keep
	track of these "key storable" items, and hence store the number
	of references to these items that are used in keys.

	When the number of references to an object == the number of
	references to an object from keys in the store, we know that we
	can remove all the items which have that object as part of the
	key. This is done by running a pass over the store, 'reaping'
	those items.

	Reap passes are slower than we would like as they touch every
	item in the store. We therefore provide a way to 'batch' such
	reap passes together, using fz_defer_reap_start/
	fz_defer_reap_end to bracket a region in which many may be
	triggered.
*/
struct StoreHash
{
	/** Constructor using raw copy of pre-existing `fz_store_hash`. */
	FZ_FUNCTION StoreHash(fz_store_hash* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_store_hash* m_internal;

	private:

	/** This class is not copyable or assignable. */
	StoreHash(const StoreHash& rhs);
	StoreHash& operator=(const StoreHash& rhs);
};

/** Wrapper class for struct `fz_store_type`. Not copyable or assignable. */
/**
	Every type of object to be placed into the store defines an
	fz_store_type. This contains the pointers to functions to
	make hashes, manipulate keys, and check for needing reaping.
*/
struct StoreType
{
	/** Constructor using raw copy of pre-existing `fz_store_type`. */
	FZ_FUNCTION StoreType(fz_store_type* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_store_type* m_internal;

	private:

	/** This class is not copyable or assignable. */
	StoreType(const StoreType& rhs);
	StoreType& operator=(const StoreType& rhs);
};

/** Wrapper class for struct `fz_stream`. */
/**
	fz_stream is a buffered reader capable of seeking in both
	directions.

	Streams are reference counted, so references must be dropped
	by a call to fz_drop_stream.

	Only the data between rp and wp is valid.
*/
struct Stream
{
	/** == Constructors. */

	/** Constructor using `fz_new_stream()`. */
	/**
		Create a new stream object with the given
		internal state and function pointers.
	
		state: Internal state (opaque to everything but implementation).
	
		next: Should provide the next set of bytes (up to max) of stream
		data. Return the number of bytes read, or EOF when there is no
		more data.
	
		drop: Should clean up and free the internal state. May not
		throw exceptions.
	*/
	FZ_FUNCTION Stream(void *state, fz_stream_next_fn *next, fz_stream_drop_fn *drop);

	/** Constructor using `fz_open_file()`. */
	/**
		Open the named file and wrap it in a stream.
	
		filename: Path to a file. On non-Windows machines the filename
		should be exactly as it would be passed to fopen(2). On Windows
		machines, the path should be UTF-8 encoded so that non-ASCII
		characters can be represented. Other platforms do the encoding
		as standard anyway (and in most cases, particularly for MacOS
		and Linux, the encoding they use is UTF-8 anyway).
	*/
	FZ_FUNCTION Stream(const char *filename);

	/** Constructor using `fz_open_file_ptr_no_close()`. */
	/**
		Create a stream from a FILE * that will not be closed
		when the stream is dropped.
	*/
	FZ_FUNCTION Stream(FILE *file);

	/** Constructor using `fz_open_memory()`. */
	/**
		Open a block of memory as a stream.
	
		data: Pointer to start of data block. Ownership of the data
		block is NOT passed in.
	
		len: Number of bytes in data block.
	
		Returns pointer to newly created stream. May throw exceptions on
		failure to allocate.
	*/
	FZ_FUNCTION Stream(const unsigned char *data, size_t len);

	/** Construct using fz_open_file(). */
	FZ_FUNCTION Stream(const std::string& filename);

	/** Copy constructor using `fz_keep_stream()`. */
	FZ_FUNCTION Stream(const Stream& rhs);

	/** operator= using `fz_keep_stream()` and `fz_drop_stream()`. */
	FZ_FUNCTION Stream& operator=(const Stream& rhs);

	/* == Methods. */

	/** Wrapper for `fz_available()`.  */
	/**
		Ask how many bytes are available immediately from
		a given stream.
	
		stm: The stream to read from.
	
		max: A hint for the underlying stream; the maximum number of
		bytes that we are sure we will want to read. If you do not know
		this number, give 1.
	
		Returns the number of bytes immediately available between the
		read and write pointers. This number is guaranteed only to be 0
		if we have hit EOF. The number of bytes returned here need have
		no relation to max (could be larger, could be smaller).
	*/
	FZ_FUNCTION size_t available(size_t max);

	/** Wrapper for `fz_decomp_image_from_stream()`.
	
	This method has out-params. Python/C# wrappers look like:
		`decomp_image_from_stream(fz_compressed_image *image, fz_irect *subarea, int indexed, int l2factor)` => `(fz_pixmap *, int l2extra)`
	 */
	/**
		Decode a subarea of a compressed image. l2factor is the amount
		of subsampling inbuilt to the stream (i.e. performed by the
		decoder). If non NULL, l2extra is the extra amount of
		subsampling that should be performed by this routine. This will
		be updated on exit to the amount of subsampling that is still
		required to be done.
	*/
	FZ_FUNCTION Pixmap decomp_image_from_stream(const CompressedImage& image, Irect& subarea, int indexed, int l2factor, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *l2extra
			#endif
			);

	/** Wrapper for `fz_is_eof()`.  */
	/**
		Query if the stream has reached EOF (during normal bytewise
		reading).
	
		See fz_is_eof_bits for the equivalent function for bitwise
		reading.
	*/
	FZ_FUNCTION int is_eof();

	/** Wrapper for `fz_is_eof_bits()`.  */
	/**
		Query if the stream has reached EOF (during bitwise
		reading).
	
		See fz_is_eof for the equivalent function for bytewise
		reading.
	*/
	FZ_FUNCTION int is_eof_bits();

	/** Wrapper for `fz_is_tar_archive()`.  */
	/**
		Detect if stream object is a tar achieve.
	
		Assumes that the stream object is seekable.
	*/
	FZ_FUNCTION int is_tar_archive();

	/** Wrapper for `fz_is_zip_archive()`.  */
	/**
		Detect if stream object is a zip archive.
	
		Assumes that the stream object is seekable.
	*/
	FZ_FUNCTION int is_zip_archive();

	/** Wrapper for `fz_open_a85d()`.  */
	/**
		a85d filter performs ASCII 85 Decoding of data read
		from the chained filter.
	*/
	FZ_FUNCTION Stream open_a85d();

	/** Wrapper for `fz_open_aesd()`.  */
	/**
		aesd filter performs AES decoding of data read from the chained
		filter using the supplied key.
	*/
	FZ_FUNCTION Stream open_aesd(unsigned char *key, unsigned int keylen);

	/** Wrapper for `fz_open_ahxd()`.  */
	/**
		ahxd filter performs ASCII Hex decoding of data read
		from the chained filter.
	*/
	FZ_FUNCTION Stream open_ahxd();

	/** Wrapper for `fz_open_arc4()`.  */
	/**
		arc4 filter performs RC4 decoding of data read from the chained
		filter using the supplied key.
	*/
	FZ_FUNCTION Stream open_arc4(unsigned char *key, unsigned int keylen);

	/** Wrapper for `fz_open_dctd()`.  */
	/**
		dctd filter performs DCT (JPEG) decoding of data read
		from the chained filter.
	
		color_transform implements the PDF color_transform option;
		use -1 (unset) as a default.
	
		For subsampling on decode, set l2factor to the log2 of the
		reduction required (therefore 0 = full size decode).
	
		jpegtables is an optional stream from which the JPEG tables
		can be read. Use NULL if not required.
	*/
	FZ_FUNCTION Stream open_dctd(int color_transform, int l2factor, const Stream& jpegtables);

	/** Wrapper for `fz_open_endstream_filter()`.  */
	/**
		The endstream filter reads a PDF substream, and starts to look
		for an 'endstream' token after the specified length.
	*/
	FZ_FUNCTION Stream open_endstream_filter(uint64_t len, int64_t offset);

	/** Wrapper for `fz_open_faxd()`.  */
	/**
		faxd filter performs FAX decoding of data read from
		the chained filter.
	
		k: see fax specification (fax default is 0).
	
		end_of_line: whether we expect end of line markers (fax default
		is 0).
	
		encoded_byte_align: whether we align to bytes after each line
		(fax default is 0).
	
		columns: how many columns in the image (fax default is 1728).
	
		rows: 0 for unspecified or the number of rows of data to expect.
	
		end_of_block: whether we expect end of block markers (fax
		default is 1).
	
		black_is_1: determines the polarity of the image (fax default is
		0).
	*/
	FZ_FUNCTION Stream open_faxd(int k, int end_of_line, int encoded_byte_align, int columns, int rows, int end_of_block, int black_is_1);

	/** Wrapper for `fz_open_flated()`.  */
	/**
		flated filter performs LZ77 decoding (inflating) of data read
		from the chained filter.
	
		window_bits: How large a decompression window to use. Typically
		15. A negative number, -n, means to use n bits, but to expect
		raw data with no header.
	*/
	FZ_FUNCTION Stream open_flated(int window_bits);

	/** Wrapper for `fz_open_image_decomp_stream()`.
	
	This method has out-params. Python/C# wrappers look like:
		`open_image_decomp_stream(fz_compression_params *arg_1)` => `(fz_stream *, int l2factor)`
	 */
	/**
		Open a stream to read the decompressed version of another stream
		with optional log2 subsampling.
	*/
	FZ_FUNCTION Stream open_image_decomp_stream(const CompressionParams& arg_1, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *l2factor
			#endif
			);

	/** Wrapper for `fz_open_jbig2d()`.  */
	/**
		Open a filter that performs jbig2 decompression on the chained
		stream, using the optional globals record.
	*/
	FZ_FUNCTION Stream open_jbig2d(const Jbig2Globals& globals, int embedded);

	/** Wrapper for `fz_open_leecher()`.  */
	/**
		Attach a filter to a stream that will store any
		characters read from the stream into the supplied buffer.
	
		chain: The underlying stream to leech from.
	
		buf: The buffer into which the read data should be appended.
		The buffer will be resized as required.
	
		Returns pointer to newly created stream. May throw exceptions on
		failure to allocate.
	*/
	FZ_FUNCTION Stream open_leecher(const Buffer& buf);

	/** Wrapper for `fz_open_lzwd()`.  */
	/**
		lzwd filter performs LZW decoding of data read from the chained
		filter.
	
		early_change: (Default 1) specifies whether to change codes 1
		bit early.
	
		min_bits: (Default 9) specifies the minimum number of bits to
		use.
	
		reverse_bits: (Default 0) allows for compatibility with gif and
		old style tiffs (1).
	
		old_tiff: (Default 0) allows for different handling of the clear
		code, as found in old style tiffs.
	*/
	FZ_FUNCTION Stream open_lzwd(int early_change, int min_bits, int reverse_bits, int old_tiff);

	/** Wrapper for `fz_open_null_filter()`.  */
	/**
		The null filter reads a specified amount of data from the
		substream.
	*/
	FZ_FUNCTION Stream open_null_filter(uint64_t len, int64_t offset);

	/** Wrapper for `fz_open_predict()`.  */
	/**
		predict filter performs pixel prediction on data read from
		the chained filter.
	
		predictor: 1 = copy, 2 = tiff, other = inline PNG predictor
	
		columns: width of image in pixels
	
		colors: number of components.
	
		bpc: bits per component (typically 8)
	*/
	FZ_FUNCTION Stream open_predict(int predictor, int columns, int colors, int bpc);

	/** Wrapper for `fz_open_range_filter()`.  */
	/**
		The range filter copies data from specified ranges of the
		chained stream.
	*/
	FZ_FUNCTION Stream open_range_filter(const Range& ranges, int nranges);

	/** Wrapper for `fz_open_rld()`.  */
	/**
		rld filter performs Run Length Decoding of data read
		from the chained filter.
	*/
	FZ_FUNCTION Stream open_rld();

	/** Wrapper for `fz_open_sgilog16()`.  */
	/**
		SGI Log 16bit (greyscale) decode from the chained filter.
		Decodes lines of w pixels to 8bpp greyscale.
	*/
	FZ_FUNCTION Stream open_sgilog16(int w);

	/** Wrapper for `fz_open_sgilog24()`.  */
	/**
		SGI Log 24bit (LUV) decode from the chained filter.
		Decodes lines of w pixels to 8bpc rgb.
	*/
	FZ_FUNCTION Stream open_sgilog24(int w);

	/** Wrapper for `fz_open_sgilog32()`.  */
	/**
		SGI Log 32bit (LUV) decode from the chained filter.
		Decodes lines of w pixels to 8bpc rgb.
	*/
	FZ_FUNCTION Stream open_sgilog32(int w);

	/** Wrapper for `fz_open_thunder()`.  */
	/**
		4bit greyscale Thunderscan decoding from the chained filter.
		Decodes lines of w pixels to 8bpp greyscale.
	*/
	FZ_FUNCTION Stream open_thunder(int w);

	/** Wrapper for `fz_peek_byte()`.  */
	/**
		Peek at the next byte in a stream.
	
		stm: The stream to peek at.
	
		Returns -1 for EOF, or the next byte that will be read.
	*/
	FZ_FUNCTION int peek_byte();

	/** Wrapper for `fz_read()`.  */
	/**
		Read from a stream into a given data block.
	
		stm: The stream to read from.
	
		data: The data block to read into.
	
		len: The length of the data block (in bytes).
	
		Returns the number of bytes read. May throw exceptions.
	*/
	FZ_FUNCTION size_t read(unsigned char *data, size_t len);

	/** Wrapper for `fz_read_all()`.  */
	/**
		Read all of a stream into a buffer.
	
		stm: The stream to read from
	
		initial: Suggested initial size for the buffer.
	
		Returns a buffer created from reading from the stream. May throw
		exceptions on failure to allocate.
	*/
	FZ_FUNCTION Buffer read_all(size_t initial);

	/** Wrapper for `fz_read_best()`.
	
	This method has out-params. Python/C# wrappers look like:
		`read_best(size_t initial)` => `(fz_buffer *, int truncated)`
	 */
	/**
		Attempt to read a stream into a buffer. If truncated
		is NULL behaves as fz_read_all, sets a truncated flag in case of
		error.
	
		stm: The stream to read from.
	
		initial: Suggested initial size for the buffer.
	
		truncated: Flag to store success/failure indication in.
	
		Returns a buffer created from reading from the stream.
	*/
	FZ_FUNCTION Buffer read_best(size_t initial, 
			#ifdef SWIG
				int *OUTPUT
			#else
				int *truncated
			#endif
			);

	/** Wrapper for `fz_read_bits()`.  */
	/**
		Read the next n bits from a stream (assumed to
		be packed most significant bit first).
	
		stm: The stream to read from.
	
		n: The number of bits to read, between 1 and 8*sizeof(int)
		inclusive.
	
		Returns -1 for EOF, or the required number of bits.
	*/
	FZ_FUNCTION unsigned int read_bits(int n);

	/** Wrapper for `fz_read_byte()`.  */
	/**
		Read the next byte from a stream.
	
		stm: The stream t read from.
	
		Returns -1 for end of stream, or the next byte. May
		throw exceptions.
	*/
	FZ_FUNCTION int read_byte();

	/** Wrapper for `fz_read_float()`.  */
	FZ_FUNCTION float read_float();

	/** Wrapper for `fz_read_float_le()`.  */
	FZ_FUNCTION float read_float_le();

	/** Wrapper for `fz_read_int16()`.  */
	FZ_FUNCTION int16_t read_int16();

	/** Wrapper for `fz_read_int16_le()`.  */
	FZ_FUNCTION int16_t read_int16_le();

	/** Wrapper for `fz_read_int32()`.  */
	FZ_FUNCTION int32_t read_int32();

	/** Wrapper for `fz_read_int32_le()`.  */
	FZ_FUNCTION int32_t read_int32_le();

	/** Wrapper for `fz_read_int64()`.  */
	FZ_FUNCTION int64_t read_int64();

	/** Wrapper for `fz_read_int64_le()`.  */
	FZ_FUNCTION int64_t read_int64_le();

	/** Wrapper for `fz_read_line()`.  */
	/**
		Read a line from stream into the buffer until either a
		terminating newline or EOF, which it replaces with a null byte
		('\0').
	
		Returns buf on success, and NULL when end of file occurs while
		no characters have been read.
	*/
	FZ_FUNCTION char *read_line(char *buf, size_t max);

	/** Wrapper for `fz_read_rbits()`.  */
	/**
		Read the next n bits from a stream (assumed to
		be packed least significant bit first).
	
		stm: The stream to read from.
	
		n: The number of bits to read, between 1 and 8*sizeof(int)
		inclusive.
	
		Returns (unsigned int)-1 for EOF, or the required number of bits.
	*/
	FZ_FUNCTION unsigned int read_rbits(int n);

	/** Wrapper for `fz_read_string()`.  */
	/**
		Read a null terminated string from the stream into
		a buffer of a given length. The buffer will be null terminated.
		Throws on failure (including the failure to fit the entire
		string including the terminator into the buffer).
	*/
	FZ_FUNCTION void read_string(char *buffer, int len);

	/** Wrapper for `fz_read_uint16()`.  */
	/**
		fz_read_[u]int(16|24|32|64)(_le)?
	
		Read a 16/32/64 bit signed/unsigned integer from stream,
		in big or little-endian byte orders.
	
		Throws an exception if EOF is encountered.
	*/
	FZ_FUNCTION uint16_t read_uint16();

	/** Wrapper for `fz_read_uint16_le()`.  */
	FZ_FUNCTION uint16_t read_uint16_le();

	/** Wrapper for `fz_read_uint24()`.  */
	FZ_FUNCTION uint32_t read_uint24();

	/** Wrapper for `fz_read_uint24_le()`.  */
	FZ_FUNCTION uint32_t read_uint24_le();

	/** Wrapper for `fz_read_uint32()`.  */
	FZ_FUNCTION uint32_t read_uint32();

	/** Wrapper for `fz_read_uint32_le()`.  */
	FZ_FUNCTION uint32_t read_uint32_le();

	/** Wrapper for `fz_read_uint64()`.  */
	FZ_FUNCTION uint64_t read_uint64();

	/** Wrapper for `fz_read_uint64_le()`.  */
	FZ_FUNCTION uint64_t read_uint64_le();

	/** Wrapper for `fz_seek()`.  */
	/**
		Seek within a stream.
	
		stm: The stream to seek within.
	
		offset: The offset to seek to.
	
		whence: From where the offset is measured (see fseek).
	*/
	FZ_FUNCTION void seek(int64_t offset, int whence);

	/** Wrapper for `fz_skip()`.  */
	/**
		Read from a stream discarding data.
	
		stm: The stream to read from.
	
		len: The number of bytes to read.
	
		Returns the number of bytes read. May throw exceptions.
	*/
	FZ_FUNCTION size_t skip(size_t len);

	/** Wrapper for `fz_skip_space()`.  */
	/**
		Skip over whitespace (bytes <= 32) in a stream.
	*/
	FZ_FUNCTION void skip_space();

	/** Wrapper for `fz_skip_string()`.  */
	/**
		Skip over a given string in a stream. Return 0 if successfully
		skipped, non-zero otherwise. As many characters will be skipped
		over as matched in the string.
	*/
	FZ_FUNCTION int skip_string(const char *str);

	/** Wrapper for `fz_sync_bits()`.  */
	/**
		Called after reading bits to tell the stream
		that we are about to return to reading bytewise. Resyncs
		the stream to whole byte boundaries.
	*/
	FZ_FUNCTION void sync_bits();

	/** Wrapper for `fz_tell()`.  */
	/**
		return the current reading position within a stream
	*/
	FZ_FUNCTION int64_t tell();

	/** Wrapper for `fz_unpack_stream()`.  */
	FZ_FUNCTION Stream unpack_stream(int depth, int w, int h, int n, int indexed, int pad, int skip);

	/** Wrapper for `fz_unread_byte()`.  */
	/**
		Unread the single last byte successfully
		read from a stream. Do not call this without having
		successfully read a byte.
	
		stm: The stream to operate upon.
	*/
	FZ_FUNCTION void unread_byte();

	/** Wrapper for `pdf_load_cmap()`.  */
	FZ_FUNCTION PdfCmap load_cmap();

	/** Wrapper for `pdf_open_crypt()`.  */
	FZ_FUNCTION Stream open_crypt(const PdfCrypt& crypt, int num, int gen);

	/** Wrapper for `pdf_open_crypt_with_filter()`.  */
	FZ_FUNCTION Stream open_crypt_with_filter(const PdfCrypt& crypt, const PdfObj& name, int num, int gen);

	/** Wrapper for `pdf_open_document_with_stream()`.  */
	FZ_FUNCTION PdfDocument open_document_with_stream();

	/** Constructor using raw copy of pre-existing `fz_stream`. */
	FZ_FUNCTION Stream(fz_stream* internal);

	/** Destructor using fz_drop_stream(). */
	FZ_FUNCTION ~Stream();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_stream* m_internal;
};

/** Wrapper class for struct `fz_stroke_state`. */
struct StrokeState
{
	/** == Constructors. */

	/** Constructor using `fz_new_stroke_state()`. */
	/**
		Create a new (empty) stroke state structure (with no dash
		data) and return a reference to it.
	
		Throws exception on failure to allocate.
	*/
	FZ_FUNCTION StrokeState();

	/** Constructor using `fz_new_stroke_state_with_dash_len()`. */
	/**
		Create a new (empty) stroke state structure, with room for
		dash data of the given length, and return a reference to it.
	
		len: The number of dash elements to allow room for.
	
		Throws exception on failure to allocate.
	*/
	FZ_FUNCTION StrokeState(int len);

	/** Copy constructor using `fz_keep_stroke_state()`. */
	FZ_FUNCTION StrokeState(const StrokeState& rhs);

	/** operator= using `fz_keep_stroke_state()` and `fz_drop_stroke_state()`. */
	FZ_FUNCTION StrokeState& operator=(const StrokeState& rhs);

	/* == Methods. */

	/** Wrapper for `fz_clone_stroke_state()`.  */
	/**
		Create an identical stroke_state structure and return a
		reference to it.
	
		stroke: The stroke state reference to clone.
	
		Exceptions may be thrown in the event of a failure to
		allocate.
	*/
	FZ_FUNCTION StrokeState clone_stroke_state();

	/** Wrapper for `fz_unshare_stroke_state()`.  */
	/**
		Given a reference to a (possibly) shared stroke_state structure,
		return a reference to an equivalent stroke_state structure
		that is guaranteed to be unshared (i.e. one that can
		safely be modified).
	
		shared: The reference to a (possibly) shared structure
		to unshare. Ownership of this reference is passed in
		to this function, even in the case of exceptions being
		thrown.
	
		Exceptions may be thrown in the event of failure to
		allocate if required.
	*/
	FZ_FUNCTION StrokeState unshare_stroke_state();

	/** Wrapper for `fz_unshare_stroke_state_with_dash_len()`.  */
	/**
		Given a reference to a (possibly) shared stroke_state structure,
		return a reference to a stroke_state structure (with room for a
		given amount of dash data) that is guaranteed to be unshared
		(i.e. one that can safely be modified).
	
		shared: The reference to a (possibly) shared structure
		to unshare. Ownership of this reference is passed in
		to this function, even in the case of exceptions being
		thrown.
	
		Exceptions may be thrown in the event of failure to
		allocate if required.
	*/
	FZ_FUNCTION StrokeState unshare_stroke_state_with_dash_len(int len);

	/** Constructor using raw copy of pre-existing `fz_stroke_state`. */
	FZ_FUNCTION StrokeState(fz_stroke_state* internal);

	/** Destructor using fz_drop_stroke_state(). */
	FZ_FUNCTION ~StrokeState();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_stroke_state* m_internal;
};

/** Wrapper class for struct `fz_style_context`. Not copyable or assignable. */
struct StyleContext
{
	/** Constructor using raw copy of pre-existing `fz_style_context`. */
	FZ_FUNCTION StyleContext(fz_style_context* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_style_context* m_internal;

	private:

	/** This class is not copyable or assignable. */
	StyleContext(const StyleContext& rhs);
	StyleContext& operator=(const StyleContext& rhs);
};

/** Wrapper class for struct `fz_text`. */
struct Text
{
	/** == Constructors. */

	/** Constructor using `fz_new_text()`. */
	/**
		Create a new empty fz_text object.
	
		Throws exception on failure to allocate.
	*/
	FZ_FUNCTION Text();

	/** Copy constructor using `fz_keep_text()`. */
	FZ_FUNCTION Text(const Text& rhs);

	/** operator= using `fz_keep_text()` and `fz_drop_text()`. */
	FZ_FUNCTION Text& operator=(const Text& rhs);

	/* == Methods. */

	/** Wrapper for `fz_bound_text()`.  */
	/**
		Find the bounds of a given text object.
	
		text: The text object to find the bounds of.
	
		stroke: Pointer to the stroke attributes (for stroked
		text), or NULL (for filled text).
	
		ctm: The matrix in use.
	
		r: pointer to storage for the bounds.
	
		Returns a pointer to r, which is updated to contain the
		bounding box for the text object.
	*/
	FZ_FUNCTION Rect bound_text(const StrokeState& stroke, Matrix& ctm);

	/** Wrapper for `fz_show_glyph()`.  */
	/**
		Add a glyph/unicode value to a text object.
	
		text: Text object to add to.
	
		font: The font the glyph should be added in.
	
		trm: The transform to use for the glyph.
	
		glyph: The glyph id to add.
	
		unicode: The unicode character for the glyph.
	
		wmode: 1 for vertical mode, 0 for horizontal.
	
		bidi_level: The bidirectional level for this glyph.
	
		markup_dir: The direction of the text as specified in the
		markup.
	
		language: The language in use (if known, 0 otherwise)
		(e.g. FZ_LANG_zh_Hans).
	
		Throws exception on failure to allocate.
	*/
	FZ_FUNCTION void show_glyph(const Font& font, Matrix& trm, int glyph, int unicode, int wmode, int bidi_level, fz_bidi_direction markup_dir, fz_text_language language);

	/** Wrapper for `fz_show_string()`.  */
	/**
		Add a UTF8 string to a text object.
	
		text: Text object to add to.
	
		font: The font the string should be added in.
	
		trm: The transform to use.
	
		s: The utf-8 string to add.
	
		wmode: 1 for vertical mode, 0 for horizontal.
	
		bidi_level: The bidirectional level for this glyph.
	
		markup_dir: The direction of the text as specified in the markup.
	
		language: The language in use (if known, 0 otherwise)
			(e.g. FZ_LANG_zh_Hans).
	
		Returns the transform updated with the advance width of the
		string.
	*/
	FZ_FUNCTION Matrix show_string(const Font& font, Matrix& trm, const char *s, int wmode, int bidi_level, fz_bidi_direction markup_dir, fz_text_language language);

	/** Constructor using raw copy of pre-existing `fz_text`. */
	FZ_FUNCTION Text(fz_text* internal);

	/** Destructor using fz_drop_text(). */
	FZ_FUNCTION ~Text();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_text* m_internal;
};

/** Wrapper class for struct `fz_text_item`. Not copyable or assignable. */
/**
	Text buffer.

	The trm field contains the a, b, c and d coefficients.
	The e and f coefficients come from the individual elements,
	together they form the transform matrix for the glyph.

	Glyphs are referenced by glyph ID.
	The Unicode text equivalent is kept in a separate array
	with indexes into the glyph array.
*/
struct TextItem
{
	/** Constructor using raw copy of pre-existing `fz_text_item`. */
	FZ_FUNCTION TextItem(fz_text_item* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_text_item* m_internal;

	private:

	/** This class is not copyable or assignable. */
	TextItem(const TextItem& rhs);
	TextItem& operator=(const TextItem& rhs);
};

/** Wrapper class for struct `fz_text_span`. Not copyable or assignable. */
struct TextSpan
{
	/** Constructor using raw copy of pre-existing `fz_text_span`. */
	FZ_FUNCTION TextSpan(fz_text_span* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_text_span* m_internal;

	private:

	/** This class is not copyable or assignable. */
	TextSpan(const TextSpan& rhs);
	TextSpan& operator=(const TextSpan& rhs);
};

/** Wrapper class for struct `fz_transition`. */
struct Transition
{
	/** We use default copy constructor and operator=. */

	/** Constructor using raw copy of pre-existing `fz_transition`. */
	FZ_FUNCTION Transition(const fz_transition* internal);

	/** Constructor using raw copy of pre-existing `fz_transition`. */
	FZ_FUNCTION Transition(const fz_transition internal);

	/** Access as underlying struct. */
	FZ_FUNCTION fz_transition* internal();

	/** Access as underlying struct. */
	FZ_FUNCTION const fz_transition* internal() const;

	/** We use default destructor. */

	/* == Member data. */

	/* These members are the same as the members of fz_transition. */
	int type;
	float duration;
	int vertical;
	int outwards;
	int direction;
	int state0;
	int state1;

	/** Returns string containing our members, labelled and inside (...), using operator<<. */
	FZ_FUNCTION std::string to_string();
};

/** Writes a Transition's underlying fz_transition's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const Transition& rhs);

/** Wrapper class for struct `fz_tree`. Not copyable or assignable. */
/**
	AA-tree to look up things by strings.
*/
struct Tree
{
	/* == Methods. */

	/** Wrapper for `fz_tree_lookup()`.  */
	/**
		Look for the value of a node in the tree with the given key.
	
		Simple pointer equivalence is used for key.
	
		Returns NULL for no match.
	*/
	FZ_FUNCTION void *tree_lookup(const char *key);

	/** Constructor using raw copy of pre-existing `fz_tree`. */
	FZ_FUNCTION Tree(fz_tree* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_tree* m_internal;

	private:

	/** This class is not copyable or assignable. */
	Tree(const Tree& rhs);
	Tree& operator=(const Tree& rhs);
};

/** Wrapper class for struct `fz_tuning_context`. Not copyable or assignable. */
struct TuningContext
{
	/** Constructor using raw copy of pre-existing `fz_tuning_context`. */
	FZ_FUNCTION TuningContext(fz_tuning_context* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_tuning_context* m_internal;

	private:

	/** This class is not copyable or assignable. */
	TuningContext(const TuningContext& rhs);
	TuningContext& operator=(const TuningContext& rhs);
};

/** Wrapper class for struct `fz_vertex`. Not copyable or assignable. */
/**
 *	Handy routine for processing mesh based shades
 */
struct Vertex
{
	/** Constructor using raw copy of pre-existing `fz_vertex`. */
	FZ_FUNCTION Vertex(fz_vertex* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_vertex* m_internal;

	private:

	/** This class is not copyable or assignable. */
	Vertex(const Vertex& rhs);
	Vertex& operator=(const Vertex& rhs);
};

/** Wrapper class for struct `fz_warn_context`. Not copyable or assignable. */
struct WarnContext
{
	/** Constructor using raw copy of pre-existing `fz_warn_context`. */
	FZ_FUNCTION WarnContext(fz_warn_context* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_warn_context* m_internal;

	private:

	/** This class is not copyable or assignable. */
	WarnContext(const WarnContext& rhs);
	WarnContext& operator=(const WarnContext& rhs);
};

/** Wrapper class for struct `fz_xml`. Not copyable or assignable. */
struct Xml
{
	/* == Methods. */

	/** Wrapper for `fz_debug_xml()`.  */
	/**
		Pretty-print an XML tree to stdout.
	*/
	FZ_FUNCTION void debug_xml(int level);

	/** Wrapper for `fz_xml_att()`.  */
	/**
		Return the value of an attribute of an XML node.
		NULL if the attribute doesn't exist.
	*/
	FZ_FUNCTION char *xml_att(const char *att);

	/** Wrapper for `fz_xml_att_alt()`.  */
	/**
		Return the value of an attribute of an XML node.
		If the first attribute doesn't exist, try the second.
		NULL if neither attribute exists.
	*/
	FZ_FUNCTION char *xml_att_alt(const char *one, const char *two);

	/** Wrapper for `fz_xml_att_eq()`.  */
	/**
		Check for a matching attribute on an XML node.
	
		If the node has the requested attribute (name), and the value
		matches (match) then return 1. Otherwise, 0.
	*/
	FZ_FUNCTION int xml_att_eq(const char *name, const char *match);

	/** Wrapper for `fz_xml_is_tag()`.  */
	/**
		Return true if the tag name matches.
	*/
	FZ_FUNCTION int xml_is_tag(const char *name);

	/** Wrapper for `fz_xml_tag()`.  */
	/**
		Return tag of XML node. Return NULL for text nodes.
	*/
	FZ_FUNCTION char *xml_tag();

	/** Wrapper for `fz_xml_text()`.  */
	/**
		Return the text content of an XML node.
		Return NULL if the node is a tag.
	*/
	FZ_FUNCTION char *xml_text();

	/** Constructor using raw copy of pre-existing `fz_xml`. */
	FZ_FUNCTION Xml(fz_xml* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_xml* m_internal;

	private:

	/** This class is not copyable or assignable. */
	Xml(const Xml& rhs);
	Xml& operator=(const Xml& rhs);
};

/** Wrapper class for struct `fz_xml_doc`. Not copyable or assignable. */
/**
	XML document model
*/
struct XmlDoc
{
	/* == Methods. */

	/** Wrapper for `fz_detach_xml()`.  */
	/**
		Detach a node from the tree, unlinking it from its parent,
		and setting the document root to the node.
	*/
	FZ_FUNCTION void detach_xml(const Xml& node);

	/** Wrapper for `fz_new_display_list_from_svg_xml()`.
	
	This method has out-params. Python/C# wrappers look like:
		`new_display_list_from_svg_xml(fz_xml *xml, const char *base_uri, fz_archive *zip)` => `(fz_display_list *, float w, float h)`
	 */
	/**
		Parse an SVG document into a display-list.
	*/
	FZ_FUNCTION DisplayList new_display_list_from_svg_xml(const Xml& xml, const char *base_uri, const Archive& zip, 
			#ifdef SWIG
				float *OUTPUT
			#else
				float *w
			#endif
			, 
			#ifdef SWIG
				float *OUTPUT
			#else
				float *h
			#endif
			);

	/** Wrapper for `fz_new_image_from_svg_xml()`.  */
	/**
		Create a scalable image from an SVG document.
	*/
	FZ_FUNCTION Image new_image_from_svg_xml(const Xml& xml, const char *base_uri, const Archive& zip);

	/** Constructor using raw copy of pre-existing `fz_xml_doc`. */
	FZ_FUNCTION XmlDoc(fz_xml_doc* internal);

	/** We use default destructor. */

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_xml_doc* m_internal;

	private:

	/** This class is not copyable or assignable. */
	XmlDoc(const XmlDoc& rhs);
	XmlDoc& operator=(const XmlDoc& rhs);
};

/** Wrapper class for struct `fz_zip_writer`. Not copyable or assignable. */
/**
	fz_zip_writer offers methods for creating and writing zip files.
	It can be seen as the reverse of the fz_archive zip
	implementation.
*/
struct ZipWriter
{
	/** == Constructors. */

	/** Constructor using `fz_new_zip_writer()`. */
	/**
		Create a new zip writer that writes to a given file.
	
		Open an archive using a seekable stream object rather than
		opening a file or directory on disk.
	*/
	FZ_FUNCTION ZipWriter(const char *filename);

	/** Constructor using `fz_new_zip_writer_with_output()`. */
	/**
		Create a new zip writer that writes to a given output stream.
	
		Ownership of out passes in immediately upon calling this function.
		The caller should never drop the fz_output, even if this function throws
		an exception.
	*/
	FZ_FUNCTION ZipWriter(const Output& out);

	/* == Methods. */

	/** Wrapper for `fz_close_zip_writer()`.  */
	/**
		Close the zip file for writing.
	
		This flushes any pending data to the file. This can throw
		exceptions.
	*/
	FZ_FUNCTION void close_zip_writer();

	/** Wrapper for `fz_write_zip_entry()`.  */
	/**
		Given a buffer of data, (optionally) compress it, and add it to
		the zip file with the given name.
	*/
	FZ_FUNCTION void write_zip_entry(const char *name, const Buffer& buf, int compress);

	/** Constructor using raw copy of pre-existing `fz_zip_writer`. */
	FZ_FUNCTION ZipWriter(fz_zip_writer* internal);

	/** Destructor using fz_drop_zip_writer(). */
	FZ_FUNCTION ~ZipWriter();

	/** Return numerical value of .m_internal; helps with Python debugging. */
	FZ_FUNCTION long long m_internal_value();

	/* == Member data. */

	/** Pointer to wrapped data. */
	fz_zip_writer* m_internal;

	private:

	/** This class is not copyable or assignable. */
	ZipWriter(const ZipWriter& rhs);
	ZipWriter& operator=(const ZipWriter& rhs);
};

struct LinkIterator
{
	FZ_FUNCTION LinkIterator(const Link& item);
	FZ_FUNCTION LinkIterator& operator++();
	FZ_FUNCTION bool operator==( const LinkIterator& rhs);
	FZ_FUNCTION bool operator!=( const LinkIterator& rhs);
	FZ_FUNCTION Link operator*();
	FZ_FUNCTION Link* operator->();
	private:
	Link m_item;
};

struct StextBlockIterator
{
	FZ_FUNCTION StextBlockIterator(const StextLine& item);
	FZ_FUNCTION StextBlockIterator& operator++();
	FZ_FUNCTION bool operator==( const StextBlockIterator& rhs);
	FZ_FUNCTION bool operator!=( const StextBlockIterator& rhs);
	FZ_FUNCTION StextLine operator*();
	FZ_FUNCTION StextLine* operator->();
	private:
	StextLine m_item;
};

struct StextLineIterator
{
	FZ_FUNCTION StextLineIterator(const StextChar& item);
	FZ_FUNCTION StextLineIterator& operator++();
	FZ_FUNCTION bool operator==( const StextLineIterator& rhs);
	FZ_FUNCTION bool operator!=( const StextLineIterator& rhs);
	FZ_FUNCTION StextChar operator*();
	FZ_FUNCTION StextChar* operator->();
	private:
	StextChar m_item;
};

struct StextPageIterator
{
	FZ_FUNCTION StextPageIterator(const StextBlock& item);
	FZ_FUNCTION StextPageIterator& operator++();
	FZ_FUNCTION bool operator==( const StextPageIterator& rhs);
	FZ_FUNCTION bool operator!=( const StextPageIterator& rhs);
	FZ_FUNCTION StextBlock operator*();
	FZ_FUNCTION StextBlock* operator->();
	private:
	StextBlock m_item;
};

} /* End of namespace mupdf. */

#endif
