/**
This file was auto-generated by mupdfwrap.py.
*/


#include "mupdf/exceptions.h"
#include "mupdf/functions.h"
#include "mupdf/internal.h"

#include <assert.h>
#include <sstream>

#include <string.h>


namespace mupdf
{

FZ_FUNCTION const std::vector<std::string> metadata_keys = {
		"format",
		"encryption",
		"info:Title",
		"info:Author",
		"info:Subject",
		"info:Keywords",
		"info:Creator",
		"info:Producer",
		"info:CreationDate",
		"info:ModDate",
};

static const char* s_trace_s = getenv("MUPDF_trace");
static bool s_trace = (s_trace_s && !strcmp(s_trace_s, "1")) ? true : false;
static const char* s_trace_exceptions_s = getenv("MUPDF_trace_exceptions");
static bool s_trace_exceptions = (s_trace_exceptions_s && !strcmp(s_trace_exceptions_s, "1")) ? true : false;

/** Wrapper for `fz_aa_level()`. */
FZ_FUNCTION int aa_level()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_aa_level():" << " auto_ctx=" << auto_ctx << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_aa_level(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_abs()`. */
FZ_FUNCTION float abs(float f)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_abs():" << " f=" << f << "\n";
	}
	float ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_abs(f);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_absi()`. */
FZ_FUNCTION int absi(int i)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_absi():" << " i=" << i << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_absi(i);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_add_layout_char()`. */
FZ_FUNCTION void add_layout_char(fz_layout_block *block, float x, float w, const char *p)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_add_layout_char():" << " auto_ctx=" << auto_ctx << " block=" << block << " x=" << x << " w=" << w << " p=" << p << "\n";
	}
	fz_try(auto_ctx) {
		::fz_add_layout_char(auto_ctx, block, x, w, p);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_add_layout_line()`. */
FZ_FUNCTION void add_layout_line(fz_layout_block *block, float x, float y, float h, const char *p)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_add_layout_line():" << " auto_ctx=" << auto_ctx << " block=" << block << " x=" << x << " y=" << y << " h=" << h << " p=" << p << "\n";
	}
	fz_try(auto_ctx) {
		::fz_add_layout_line(auto_ctx, block, x, y, h, p);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_add_separation()`. */
FZ_FUNCTION void add_separation(fz_separations *sep, const char *name, fz_colorspace *cs, int cs_channel)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_add_separation():" << " auto_ctx=" << auto_ctx << " sep=" << sep << " name=" << name << " cs=" << cs << " cs_channel=" << cs_channel << "\n";
	}
	fz_try(auto_ctx) {
		::fz_add_separation(auto_ctx, sep, name, cs, cs_channel);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_add_separation_equivalents()`. */
FZ_FUNCTION void add_separation_equivalents(fz_separations *sep, uint32_t rgba, uint32_t cmyk, const char *name)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_add_separation_equivalents():" << " auto_ctx=" << auto_ctx << " sep=" << sep << " rgba=" << rgba << " cmyk=" << cmyk << " name=" << name << "\n";
	}
	fz_try(auto_ctx) {
		::fz_add_separation_equivalents(auto_ctx, sep, rgba, cmyk, name);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_adjust_rect_for_stroke()`. */
FZ_FUNCTION fz_rect adjust_rect_for_stroke(fz_rect rect, const fz_stroke_state *stroke, fz_matrix ctm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_adjust_rect_for_stroke():" << " auto_ctx=" << auto_ctx << " rect=" << rect << " stroke=" << stroke << " ctm=" << ctm << "\n";
	}
	fz_rect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_adjust_rect_for_stroke(auto_ctx, rect, stroke, ctm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_advance_glyph()`. */
FZ_FUNCTION float advance_glyph(fz_font *font, int glyph, int wmode)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_advance_glyph():" << " auto_ctx=" << auto_ctx << " font=" << font << " glyph=" << glyph << " wmode=" << wmode << "\n";
	}
	float ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_advance_glyph(auto_ctx, font, glyph, wmode);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_aes_crypt_cbc()`. */
FZ_FUNCTION void aes_crypt_cbc(fz_aes *ctx, int mode, size_t length, unsigned char iv[16], const unsigned char *input, unsigned char *output)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_aes_crypt_cbc():" << " ctx=" << ctx << " mode=" << mode << " length=" << length << " iv=" << iv << " input=" << (void*) input << " output=" << (void*) output << "\n";
	}
	fz_try(auto_ctx) {
		::fz_aes_crypt_cbc(ctx, mode, length, iv, input, output);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_aes_setkey_dec()`. */
FZ_FUNCTION int aes_setkey_dec(fz_aes *ctx, const unsigned char *key, int keysize)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_aes_setkey_dec():" << " ctx=" << ctx << " key=" << (void*) key << " keysize=" << keysize << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_aes_setkey_dec(ctx, key, keysize);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_aes_setkey_enc()`. */
FZ_FUNCTION int aes_setkey_enc(fz_aes *ctx, const unsigned char *key, int keysize)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_aes_setkey_enc():" << " ctx=" << ctx << " key=" << (void*) key << " keysize=" << keysize << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_aes_setkey_enc(ctx, key, keysize);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_alpha_from_gray()`. */
FZ_FUNCTION fz_pixmap *alpha_from_gray(fz_pixmap *gray)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_alpha_from_gray():" << " auto_ctx=" << auto_ctx << " gray=" << gray << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_alpha_from_gray(auto_ctx, gray);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_append_bits()`. */
FZ_FUNCTION void append_bits(fz_buffer *buf, int value, int count)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_append_bits():" << " auto_ctx=" << auto_ctx << " buf=" << buf << " value=" << value << " count=" << count << "\n";
	}
	fz_try(auto_ctx) {
		::fz_append_bits(auto_ctx, buf, value, count);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_append_bits_pad()`. */
FZ_FUNCTION void append_bits_pad(fz_buffer *buf)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_append_bits_pad():" << " auto_ctx=" << auto_ctx << " buf=" << buf << "\n";
	}
	fz_try(auto_ctx) {
		::fz_append_bits_pad(auto_ctx, buf);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_append_buffer()`. */
FZ_FUNCTION void append_buffer(fz_buffer *destination, fz_buffer *source)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_append_buffer():" << " auto_ctx=" << auto_ctx << " destination=" << destination << " source=" << source << "\n";
	}
	fz_try(auto_ctx) {
		::fz_append_buffer(auto_ctx, destination, source);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_append_byte()`. */
FZ_FUNCTION void append_byte(fz_buffer *buf, int c)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_append_byte():" << " auto_ctx=" << auto_ctx << " buf=" << buf << " c=" << c << "\n";
	}
	fz_try(auto_ctx) {
		::fz_append_byte(auto_ctx, buf, c);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_append_data()`. */
FZ_FUNCTION void append_data(fz_buffer *buf, const void *data, size_t len)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_append_data():" << " auto_ctx=" << auto_ctx << " buf=" << buf << " data=" << (void*) data << " len=" << len << "\n";
	}
	fz_try(auto_ctx) {
		::fz_append_data(auto_ctx, buf, data, len);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_append_int16_be()`. */
FZ_FUNCTION void append_int16_be(fz_buffer *buf, int x)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_append_int16_be():" << " auto_ctx=" << auto_ctx << " buf=" << buf << " x=" << x << "\n";
	}
	fz_try(auto_ctx) {
		::fz_append_int16_be(auto_ctx, buf, x);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_append_int16_le()`. */
FZ_FUNCTION void append_int16_le(fz_buffer *buf, int x)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_append_int16_le():" << " auto_ctx=" << auto_ctx << " buf=" << buf << " x=" << x << "\n";
	}
	fz_try(auto_ctx) {
		::fz_append_int16_le(auto_ctx, buf, x);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_append_int32_be()`. */
FZ_FUNCTION void append_int32_be(fz_buffer *buf, int x)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_append_int32_be():" << " auto_ctx=" << auto_ctx << " buf=" << buf << " x=" << x << "\n";
	}
	fz_try(auto_ctx) {
		::fz_append_int32_be(auto_ctx, buf, x);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_append_int32_le()`. */
FZ_FUNCTION void append_int32_le(fz_buffer *buf, int x)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_append_int32_le():" << " auto_ctx=" << auto_ctx << " buf=" << buf << " x=" << x << "\n";
	}
	fz_try(auto_ctx) {
		::fz_append_int32_le(auto_ctx, buf, x);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_append_pdf_string()`. */
FZ_FUNCTION void append_pdf_string(fz_buffer *buffer, const char *text)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_append_pdf_string():" << " auto_ctx=" << auto_ctx << " buffer=" << buffer << " text=" << text << "\n";
	}
	fz_try(auto_ctx) {
		::fz_append_pdf_string(auto_ctx, buffer, text);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_append_rune()`. */
FZ_FUNCTION void append_rune(fz_buffer *buf, int c)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_append_rune():" << " auto_ctx=" << auto_ctx << " buf=" << buf << " c=" << c << "\n";
	}
	fz_try(auto_ctx) {
		::fz_append_rune(auto_ctx, buf, c);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_append_string()`. */
FZ_FUNCTION void append_string(fz_buffer *buf, const char *data)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_append_string():" << " auto_ctx=" << auto_ctx << " buf=" << buf << " data=" << data << "\n";
	}
	fz_try(auto_ctx) {
		::fz_append_string(auto_ctx, buf, data);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_append_vprintf()`. */
FZ_FUNCTION void append_vprintf(fz_buffer *buffer, const char *fmt, va_list args)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_append_vprintf():" << " auto_ctx=" << auto_ctx << " buffer=" << buffer << " fmt=" << fmt << " args=" << args << "\n";
	}
	fz_try(auto_ctx) {
		::fz_append_vprintf(auto_ctx, buffer, fmt, args);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_arc4_encrypt()`. */
FZ_FUNCTION void arc4_encrypt(fz_arc4 *state, unsigned char *dest, const unsigned char *src, size_t len)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_arc4_encrypt():" << " state=" << state << " dest=" << (void*) dest << " src=" << (void*) src << " len=" << len << "\n";
	}
	fz_try(auto_ctx) {
		::fz_arc4_encrypt(state, dest, src, len);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_arc4_init()`. */
FZ_FUNCTION void arc4_init(fz_arc4 *state, const unsigned char *key, size_t len)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_arc4_init():" << " state=" << state << " key=" << (void*) key << " len=" << len << "\n";
	}
	fz_try(auto_ctx) {
		::fz_arc4_init(state, key, len);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_archive_format()`. */
FZ_FUNCTION const char *archive_format(fz_archive *arch)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_archive_format():" << " auto_ctx=" << auto_ctx << " arch=" << arch << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_archive_format(auto_ctx, arch);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_atof()`. */
FZ_FUNCTION float atof(const char *s)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_atof():" << " s=" << s << "\n";
	}
	float ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_atof(s);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_atoi()`. */
FZ_FUNCTION int atoi(const char *s)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_atoi():" << " s=" << s << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_atoi(s);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_atoi64()`. */
FZ_FUNCTION int64_t atoi64(const char *s)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_atoi64():" << " s=" << s << "\n";
	}
	int64_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_atoi64(s);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_authenticate_password()`. */
FZ_FUNCTION int authenticate_password(fz_document *doc, const char *password)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_authenticate_password():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " password=" << password << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_authenticate_password(auto_ctx, doc, password);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_available()`. */
FZ_FUNCTION size_t available(fz_stream *stm, size_t max)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_available():" << " auto_ctx=" << auto_ctx << " stm=" << stm << " max=" << max << "\n";
	}
	size_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_available(auto_ctx, stm, max);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_begin_group()`. */
FZ_FUNCTION void begin_group(fz_device *dev, fz_rect area, fz_colorspace *cs, int isolated, int knockout, int blendmode, float alpha)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_begin_group():" << " auto_ctx=" << auto_ctx << " dev=" << dev << " area=" << area << " cs=" << cs << " isolated=" << isolated << " knockout=" << knockout << " blendmode=" << blendmode << " alpha=" << alpha << "\n";
	}
	fz_try(auto_ctx) {
		::fz_begin_group(auto_ctx, dev, area, cs, isolated, knockout, blendmode, alpha);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_begin_layer()`. */
FZ_FUNCTION void begin_layer(fz_device *dev, const char *layer_name)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_begin_layer():" << " auto_ctx=" << auto_ctx << " dev=" << dev << " layer_name=" << layer_name << "\n";
	}
	fz_try(auto_ctx) {
		::fz_begin_layer(auto_ctx, dev, layer_name);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_begin_mask()`. */
FZ_FUNCTION void begin_mask(fz_device *dev, fz_rect area, int luminosity, fz_colorspace *colorspace, const float *bc, fz_color_params color_params)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_begin_mask():" << " auto_ctx=" << auto_ctx << " dev=" << dev << " area=" << area << " luminosity=" << luminosity << " colorspace=" << colorspace << " bc=" << (void*) bc << " color_params=" << color_params << "\n";
	}
	fz_try(auto_ctx) {
		::fz_begin_mask(auto_ctx, dev, area, luminosity, colorspace, bc, color_params);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_begin_page()`. */
FZ_FUNCTION fz_device *begin_page(fz_document_writer *wri, fz_rect mediabox)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_begin_page():" << " auto_ctx=" << auto_ctx << " wri=" << wri << " mediabox=" << mediabox << "\n";
	}
	fz_device * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_begin_page(auto_ctx, wri, mediabox);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_begin_tile()`. */
FZ_FUNCTION void begin_tile(fz_device *dev, fz_rect area, fz_rect view, float xstep, float ystep, fz_matrix ctm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_begin_tile():" << " auto_ctx=" << auto_ctx << " dev=" << dev << " area=" << area << " view=" << view << " xstep=" << xstep << " ystep=" << ystep << " ctm=" << ctm << "\n";
	}
	fz_try(auto_ctx) {
		::fz_begin_tile(auto_ctx, dev, area, view, xstep, ystep, ctm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_begin_tile_id()`. */
FZ_FUNCTION int begin_tile_id(fz_device *dev, fz_rect area, fz_rect view, float xstep, float ystep, fz_matrix ctm, int id)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_begin_tile_id():" << " auto_ctx=" << auto_ctx << " dev=" << dev << " area=" << area << " view=" << view << " xstep=" << xstep << " ystep=" << ystep << " ctm=" << ctm << " id=" << id << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_begin_tile_id(auto_ctx, dev, area, view, xstep, ystep, ctm, id);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_bidi_fragment_text()`. */
FZ_FUNCTION void bidi_fragment_text(const uint32_t *text, size_t textlen, fz_bidi_direction *baseDir, fz_bidi_fragment_fn *callback, void *arg, int flags)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_bidi_fragment_text():" << " auto_ctx=" << auto_ctx << " text=" << (void*) text << " textlen=" << textlen << " baseDir=" << (void*) baseDir << " callback=" << (void*) callback << " arg=" << (void*) arg << " flags=" << flags << "\n";
	}
	fz_try(auto_ctx) {
		::fz_bidi_fragment_text(auto_ctx, text, textlen, baseDir, callback, arg, flags);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_bitmap_details()`.

This function has out-params. Python/C# wrappers look like:
	`bitmap_details(fz_bitmap *bitmap)` => `(int w, int h, int n, int stride)`
*/
FZ_FUNCTION void bitmap_details(fz_bitmap *bitmap, int *w, int *h, int *n, int *stride)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_bitmap_details():" << " bitmap=" << bitmap << " w=" << (void*) w << " h=" << (void*) h << " n=" << (void*) n << " stride=" << (void*) stride << "\n";
	}
	fz_try(auto_ctx) {
		::fz_bitmap_details(bitmap, w, h, n, stride);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_blendmode_name()`. */
FZ_FUNCTION const char *blendmode_name(int blendmode)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_blendmode_name():" << " blendmode=" << blendmode << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_blendmode_name(blendmode);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_bound_display_list()`. */
FZ_FUNCTION fz_rect bound_display_list(fz_display_list *list)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_bound_display_list():" << " auto_ctx=" << auto_ctx << " list=" << list << "\n";
	}
	fz_rect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_bound_display_list(auto_ctx, list);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_bound_glyph()`. */
FZ_FUNCTION fz_rect bound_glyph(fz_font *font, int gid, fz_matrix trm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_bound_glyph():" << " auto_ctx=" << auto_ctx << " font=" << font << " gid=" << gid << " trm=" << trm << "\n";
	}
	fz_rect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_bound_glyph(auto_ctx, font, gid, trm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_bound_page()`. */
FZ_FUNCTION fz_rect bound_page(fz_page *page)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_bound_page():" << " auto_ctx=" << auto_ctx << " page=" << page << "\n";
	}
	fz_rect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_bound_page(auto_ctx, page);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_bound_path()`. */
FZ_FUNCTION fz_rect bound_path(const fz_path *path, const fz_stroke_state *stroke, fz_matrix ctm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_bound_path():" << " auto_ctx=" << auto_ctx << " path=" << path << " stroke=" << stroke << " ctm=" << ctm << "\n";
	}
	fz_rect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_bound_path(auto_ctx, path, stroke, ctm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_bound_shade()`. */
FZ_FUNCTION fz_rect bound_shade(fz_shade *shade, fz_matrix ctm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_bound_shade():" << " auto_ctx=" << auto_ctx << " shade=" << shade << " ctm=" << ctm << "\n";
	}
	fz_rect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_bound_shade(auto_ctx, shade, ctm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_bound_text()`. */
FZ_FUNCTION fz_rect bound_text(const fz_text *text, const fz_stroke_state *stroke, fz_matrix ctm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_bound_text():" << " auto_ctx=" << auto_ctx << " text=" << text << " stroke=" << stroke << " ctm=" << ctm << "\n";
	}
	fz_rect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_bound_text(auto_ctx, text, stroke, ctm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_buffer_extract()`.

This function has out-params. Python/C# wrappers look like:
	`buffer_extract(fz_buffer *buf)` => `(size_t, unsigned char *data)`
*/
FZ_FUNCTION size_t buffer_extract(fz_buffer *buf, unsigned char **data)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_buffer_extract():" << " auto_ctx=" << auto_ctx << " buf=" << buf << " data=" << (void*) data << "\n";
	}
	size_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_buffer_extract(auto_ctx, buf, data);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_buffer_storage()`.

This function has out-params. Python/C# wrappers look like:
	`buffer_storage(fz_buffer *buf)` => `(size_t, unsigned char *datap)`
*/
FZ_FUNCTION size_t buffer_storage(fz_buffer *buf, unsigned char **datap)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_buffer_storage():" << " auto_ctx=" << auto_ctx << " buf=" << buf << " datap=" << (void*) datap << "\n";
	}
	size_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_buffer_storage(auto_ctx, buf, datap);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_calloc()`. */
FZ_FUNCTION void *calloc(size_t count, size_t size)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_calloc():" << " auto_ctx=" << auto_ctx << " count=" << count << " size=" << size << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_calloc(auto_ctx, count, size);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_calloc_no_throw()`. */
FZ_FUNCTION void *calloc_no_throw(size_t count, size_t size)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_calloc_no_throw():" << " auto_ctx=" << auto_ctx << " count=" << count << " size=" << size << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_calloc_no_throw(auto_ctx, count, size);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_caught()`. */
FZ_FUNCTION int caught()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_caught():" << " auto_ctx=" << auto_ctx << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_caught(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_caught_message()`. */
FZ_FUNCTION const char *caught_message()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_caught_message():" << " auto_ctx=" << auto_ctx << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_caught_message(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_chartorune()`.

This function has out-params. Python/C# wrappers look like:
	`chartorune(const char *str)` => `(int, int rune)`
*/
FZ_FUNCTION int chartorune(int *rune, const char *str)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_chartorune():" << " rune=" << (void*) rune << " str=" << str << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_chartorune(rune, str);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_clamp()`. */
FZ_FUNCTION float clamp(float f, float min, float max)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_clamp():" << " f=" << f << " min=" << min << " max=" << max << "\n";
	}
	float ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_clamp(f, min, max);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_clamp_color()`.

This function has out-params. Python/C# wrappers look like:
	`clamp_color(fz_colorspace *cs, const float *in)` => float out
*/
FZ_FUNCTION void clamp_color(fz_colorspace *cs, const float *in, float *out)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_clamp_color():" << " auto_ctx=" << auto_ctx << " cs=" << cs << " in=" << (void*) in << " out=" << (void*) out << "\n";
	}
	fz_try(auto_ctx) {
		::fz_clamp_color(auto_ctx, cs, in, out);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_clamp_location()`. */
FZ_FUNCTION fz_location clamp_location(fz_document *doc, fz_location loc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_clamp_location():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " loc=" << loc << "\n";
	}
	fz_location ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_clamp_location(auto_ctx, doc, loc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_clampd()`. */
FZ_FUNCTION double clampd(double d, double min, double max)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_clampd():" << " d=" << d << " min=" << min << " max=" << max << "\n";
	}
	double ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_clampd(d, min, max);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_clampi()`. */
FZ_FUNCTION int clampi(int i, int min, int max)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_clampi():" << " i=" << i << " min=" << min << " max=" << max << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_clampi(i, min, max);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_clampp()`. */
FZ_FUNCTION void *clampp(void *p, void *min, void *max)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_clampp():" << " p=" << (void*) p << " min=" << (void*) min << " max=" << (void*) max << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_clampp(p, min, max);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_cleanname()`. */
FZ_FUNCTION char *cleanname(char *name)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_cleanname():" << " name=" << (void*) name << "\n";
	}
	char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_cleanname(name);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_clear_bitmap()`. */
FZ_FUNCTION void clear_bitmap(fz_bitmap *bit)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_clear_bitmap():" << " auto_ctx=" << auto_ctx << " bit=" << bit << "\n";
	}
	fz_try(auto_ctx) {
		::fz_clear_bitmap(auto_ctx, bit);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_clear_buffer()`. */
FZ_FUNCTION void clear_buffer(fz_buffer *buf)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_clear_buffer():" << " auto_ctx=" << auto_ctx << " buf=" << buf << "\n";
	}
	fz_try(auto_ctx) {
		::fz_clear_buffer(auto_ctx, buf);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_clear_pixmap()`. */
FZ_FUNCTION void clear_pixmap(fz_pixmap *pix)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_clear_pixmap():" << " auto_ctx=" << auto_ctx << " pix=" << pix << "\n";
	}
	fz_try(auto_ctx) {
		::fz_clear_pixmap(auto_ctx, pix);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_clear_pixmap_rect_with_value()`. */
FZ_FUNCTION void clear_pixmap_rect_with_value(fz_pixmap *pix, int value, fz_irect r)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_clear_pixmap_rect_with_value():" << " auto_ctx=" << auto_ctx << " pix=" << pix << " value=" << value << " r=" << r << "\n";
	}
	fz_try(auto_ctx) {
		::fz_clear_pixmap_rect_with_value(auto_ctx, pix, value, r);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_clear_pixmap_with_value()`. */
FZ_FUNCTION void clear_pixmap_with_value(fz_pixmap *pix, int value)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_clear_pixmap_with_value():" << " auto_ctx=" << auto_ctx << " pix=" << pix << " value=" << value << "\n";
	}
	fz_try(auto_ctx) {
		::fz_clear_pixmap_with_value(auto_ctx, pix, value);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_clip_image_mask()`. */
FZ_FUNCTION void clip_image_mask(fz_device *dev, fz_image *image, fz_matrix ctm, fz_rect scissor)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_clip_image_mask():" << " auto_ctx=" << auto_ctx << " dev=" << dev << " image=" << image << " ctm=" << ctm << " scissor=" << scissor << "\n";
	}
	fz_try(auto_ctx) {
		::fz_clip_image_mask(auto_ctx, dev, image, ctm, scissor);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_clip_path()`. */
FZ_FUNCTION void clip_path(fz_device *dev, const fz_path *path, int even_odd, fz_matrix ctm, fz_rect scissor)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_clip_path():" << " auto_ctx=" << auto_ctx << " dev=" << dev << " path=" << path << " even_odd=" << even_odd << " ctm=" << ctm << " scissor=" << scissor << "\n";
	}
	fz_try(auto_ctx) {
		::fz_clip_path(auto_ctx, dev, path, even_odd, ctm, scissor);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_clip_stroke_path()`. */
FZ_FUNCTION void clip_stroke_path(fz_device *dev, const fz_path *path, const fz_stroke_state *stroke, fz_matrix ctm, fz_rect scissor)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_clip_stroke_path():" << " auto_ctx=" << auto_ctx << " dev=" << dev << " path=" << path << " stroke=" << stroke << " ctm=" << ctm << " scissor=" << scissor << "\n";
	}
	fz_try(auto_ctx) {
		::fz_clip_stroke_path(auto_ctx, dev, path, stroke, ctm, scissor);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_clip_stroke_text()`. */
FZ_FUNCTION void clip_stroke_text(fz_device *dev, const fz_text *text, const fz_stroke_state *stroke, fz_matrix ctm, fz_rect scissor)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_clip_stroke_text():" << " auto_ctx=" << auto_ctx << " dev=" << dev << " text=" << text << " stroke=" << stroke << " ctm=" << ctm << " scissor=" << scissor << "\n";
	}
	fz_try(auto_ctx) {
		::fz_clip_stroke_text(auto_ctx, dev, text, stroke, ctm, scissor);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_clip_text()`. */
FZ_FUNCTION void clip_text(fz_device *dev, const fz_text *text, fz_matrix ctm, fz_rect scissor)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_clip_text():" << " auto_ctx=" << auto_ctx << " dev=" << dev << " text=" << text << " ctm=" << ctm << " scissor=" << scissor << "\n";
	}
	fz_try(auto_ctx) {
		::fz_clip_text(auto_ctx, dev, text, ctm, scissor);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_clone_context()`. */
FZ_FUNCTION fz_context *clone_context()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_clone_context():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_context * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_clone_context(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_clone_default_colorspaces()`. */
FZ_FUNCTION fz_default_colorspaces *clone_default_colorspaces(fz_default_colorspaces *base)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_clone_default_colorspaces():" << " auto_ctx=" << auto_ctx << " base=" << base << "\n";
	}
	fz_default_colorspaces * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_clone_default_colorspaces(auto_ctx, base);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_clone_path()`. */
FZ_FUNCTION fz_path *clone_path(fz_path *path)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_clone_path():" << " auto_ctx=" << auto_ctx << " path=" << path << "\n";
	}
	fz_path * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_clone_path(auto_ctx, path);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_clone_pixmap()`. */
FZ_FUNCTION fz_pixmap *clone_pixmap(const fz_pixmap *old)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_clone_pixmap():" << " auto_ctx=" << auto_ctx << " old=" << old << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_clone_pixmap(auto_ctx, old);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_clone_pixmap_area_with_different_seps()`. */
FZ_FUNCTION fz_pixmap *clone_pixmap_area_with_different_seps(fz_pixmap *src, const fz_irect *bbox, fz_colorspace *dcs, fz_separations *seps, fz_color_params color_params, fz_default_colorspaces *default_cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_clone_pixmap_area_with_different_seps():" << " auto_ctx=" << auto_ctx << " src=" << src << " bbox=" << bbox << " dcs=" << dcs << " seps=" << seps << " color_params=" << color_params << " default_cs=" << default_cs << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_clone_pixmap_area_with_different_seps(auto_ctx, src, bbox, dcs, seps, color_params, default_cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_clone_separations_for_overprint()`. */
FZ_FUNCTION fz_separations *clone_separations_for_overprint(fz_separations *seps)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_clone_separations_for_overprint():" << " auto_ctx=" << auto_ctx << " seps=" << seps << "\n";
	}
	fz_separations * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_clone_separations_for_overprint(auto_ctx, seps);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_clone_stroke_state()`. */
FZ_FUNCTION fz_stroke_state *clone_stroke_state(fz_stroke_state *stroke)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_clone_stroke_state():" << " auto_ctx=" << auto_ctx << " stroke=" << stroke << "\n";
	}
	fz_stroke_state * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_clone_stroke_state(auto_ctx, stroke);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_close_band_writer()`. */
FZ_FUNCTION void close_band_writer(fz_band_writer *writer)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_close_band_writer():" << " auto_ctx=" << auto_ctx << " writer=" << writer << "\n";
	}
	fz_try(auto_ctx) {
		::fz_close_band_writer(auto_ctx, writer);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_close_device()`. */
FZ_FUNCTION void close_device(fz_device *dev)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_close_device():" << " auto_ctx=" << auto_ctx << " dev=" << dev << "\n";
	}
	fz_try(auto_ctx) {
		::fz_close_device(auto_ctx, dev);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_close_document_writer()`. */
FZ_FUNCTION void close_document_writer(fz_document_writer *wri)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_close_document_writer():" << " auto_ctx=" << auto_ctx << " wri=" << wri << "\n";
	}
	fz_try(auto_ctx) {
		::fz_close_document_writer(auto_ctx, wri);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_close_output()`. */
FZ_FUNCTION void close_output(fz_output *arg_1)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_close_output():" << " auto_ctx=" << auto_ctx << " arg_1=" << arg_1 << "\n";
	}
	fz_try(auto_ctx) {
		::fz_close_output(auto_ctx, arg_1);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_close_zip_writer()`. */
FZ_FUNCTION void close_zip_writer(fz_zip_writer *zip)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_close_zip_writer():" << " auto_ctx=" << auto_ctx << " zip=" << zip << "\n";
	}
	fz_try(auto_ctx) {
		::fz_close_zip_writer(auto_ctx, zip);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_closepath()`. */
FZ_FUNCTION void closepath(fz_path *path)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_closepath():" << " auto_ctx=" << auto_ctx << " path=" << path << "\n";
	}
	fz_try(auto_ctx) {
		::fz_closepath(auto_ctx, path);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_colorspace_colorant()`. */
FZ_FUNCTION const char *colorspace_colorant(fz_colorspace *cs, int n)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_colorspace_colorant():" << " auto_ctx=" << auto_ctx << " cs=" << cs << " n=" << n << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_colorspace_colorant(auto_ctx, cs, n);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_colorspace_device_n_has_cmyk()`. */
FZ_FUNCTION int colorspace_device_n_has_cmyk(fz_colorspace *cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_colorspace_device_n_has_cmyk():" << " auto_ctx=" << auto_ctx << " cs=" << cs << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_colorspace_device_n_has_cmyk(auto_ctx, cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_colorspace_device_n_has_only_cmyk()`. */
FZ_FUNCTION int colorspace_device_n_has_only_cmyk(fz_colorspace *cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_colorspace_device_n_has_only_cmyk():" << " auto_ctx=" << auto_ctx << " cs=" << cs << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_colorspace_device_n_has_only_cmyk(auto_ctx, cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_colorspace_is_cmyk()`. */
FZ_FUNCTION int colorspace_is_cmyk(fz_colorspace *cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_colorspace_is_cmyk():" << " auto_ctx=" << auto_ctx << " cs=" << cs << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_colorspace_is_cmyk(auto_ctx, cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_colorspace_is_device()`. */
FZ_FUNCTION int colorspace_is_device(fz_colorspace *cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_colorspace_is_device():" << " auto_ctx=" << auto_ctx << " cs=" << cs << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_colorspace_is_device(auto_ctx, cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_colorspace_is_device_cmyk()`. */
FZ_FUNCTION int colorspace_is_device_cmyk(fz_colorspace *cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_colorspace_is_device_cmyk():" << " auto_ctx=" << auto_ctx << " cs=" << cs << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_colorspace_is_device_cmyk(auto_ctx, cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_colorspace_is_device_gray()`. */
FZ_FUNCTION int colorspace_is_device_gray(fz_colorspace *cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_colorspace_is_device_gray():" << " auto_ctx=" << auto_ctx << " cs=" << cs << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_colorspace_is_device_gray(auto_ctx, cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_colorspace_is_device_n()`. */
FZ_FUNCTION int colorspace_is_device_n(fz_colorspace *cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_colorspace_is_device_n():" << " auto_ctx=" << auto_ctx << " cs=" << cs << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_colorspace_is_device_n(auto_ctx, cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_colorspace_is_gray()`. */
FZ_FUNCTION int colorspace_is_gray(fz_colorspace *cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_colorspace_is_gray():" << " auto_ctx=" << auto_ctx << " cs=" << cs << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_colorspace_is_gray(auto_ctx, cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_colorspace_is_indexed()`. */
FZ_FUNCTION int colorspace_is_indexed(fz_colorspace *cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_colorspace_is_indexed():" << " auto_ctx=" << auto_ctx << " cs=" << cs << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_colorspace_is_indexed(auto_ctx, cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_colorspace_is_lab()`. */
FZ_FUNCTION int colorspace_is_lab(fz_colorspace *cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_colorspace_is_lab():" << " auto_ctx=" << auto_ctx << " cs=" << cs << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_colorspace_is_lab(auto_ctx, cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_colorspace_is_lab_icc()`. */
FZ_FUNCTION int colorspace_is_lab_icc(fz_colorspace *cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_colorspace_is_lab_icc():" << " auto_ctx=" << auto_ctx << " cs=" << cs << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_colorspace_is_lab_icc(auto_ctx, cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_colorspace_is_rgb()`. */
FZ_FUNCTION int colorspace_is_rgb(fz_colorspace *cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_colorspace_is_rgb():" << " auto_ctx=" << auto_ctx << " cs=" << cs << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_colorspace_is_rgb(auto_ctx, cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_colorspace_is_subtractive()`. */
FZ_FUNCTION int colorspace_is_subtractive(fz_colorspace *cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_colorspace_is_subtractive():" << " auto_ctx=" << auto_ctx << " cs=" << cs << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_colorspace_is_subtractive(auto_ctx, cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_colorspace_n()`. */
FZ_FUNCTION int colorspace_n(fz_colorspace *cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_colorspace_n():" << " auto_ctx=" << auto_ctx << " cs=" << cs << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_colorspace_n(auto_ctx, cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_colorspace_name()`. */
FZ_FUNCTION const char *colorspace_name(fz_colorspace *cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_colorspace_name():" << " auto_ctx=" << auto_ctx << " cs=" << cs << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_colorspace_name(auto_ctx, cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_colorspace_name_colorant()`. */
FZ_FUNCTION void colorspace_name_colorant(fz_colorspace *cs, int n, const char *name)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_colorspace_name_colorant():" << " auto_ctx=" << auto_ctx << " cs=" << cs << " n=" << n << " name=" << name << "\n";
	}
	fz_try(auto_ctx) {
		::fz_colorspace_name_colorant(auto_ctx, cs, n, name);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_colorspace_type()`. */
FZ_FUNCTION enum fz_colorspace_type colorspace_type(fz_colorspace *cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_colorspace_type():" << " auto_ctx=" << auto_ctx << " cs=" << cs << "\n";
	}
	enum fz_colorspace_type ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_colorspace_type(auto_ctx, cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_compress_ccitt_fax_g3()`. */
FZ_FUNCTION fz_buffer *compress_ccitt_fax_g3(const unsigned char *data, int columns, int rows)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_compress_ccitt_fax_g3():" << " auto_ctx=" << auto_ctx << " data=" << (void*) data << " columns=" << columns << " rows=" << rows << "\n";
	}
	fz_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_compress_ccitt_fax_g3(auto_ctx, data, columns, rows);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_compress_ccitt_fax_g4()`. */
FZ_FUNCTION fz_buffer *compress_ccitt_fax_g4(const unsigned char *data, int columns, int rows)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_compress_ccitt_fax_g4():" << " auto_ctx=" << auto_ctx << " data=" << (void*) data << " columns=" << columns << " rows=" << rows << "\n";
	}
	fz_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_compress_ccitt_fax_g4(auto_ctx, data, columns, rows);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_compressed_buffer_size()`. */
FZ_FUNCTION size_t compressed_buffer_size(fz_compressed_buffer *buffer)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_compressed_buffer_size():" << " buffer=" << buffer << "\n";
	}
	size_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_compressed_buffer_size(buffer);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_compressed_image_buffer()`. */
FZ_FUNCTION fz_compressed_buffer *compressed_image_buffer(fz_image *image)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_compressed_image_buffer():" << " auto_ctx=" << auto_ctx << " image=" << image << "\n";
	}
	fz_compressed_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_compressed_image_buffer(auto_ctx, image);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_concat()`. */
FZ_FUNCTION fz_matrix concat(fz_matrix left, fz_matrix right)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_concat():" << " left=" << left << " right=" << right << "\n";
	}
	fz_matrix ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_concat(left, right);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_concat_push_drop()`. */
FZ_FUNCTION void concat_push_drop(fz_stream *concat, fz_stream *chain)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_concat_push_drop():" << " auto_ctx=" << auto_ctx << " concat=" << concat << " chain=" << chain << "\n";
	}
	fz_try(auto_ctx) {
		::fz_concat_push_drop(auto_ctx, concat, chain);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_contains_rect()`. */
FZ_FUNCTION int contains_rect(fz_rect a, fz_rect b)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_contains_rect():" << " a=" << a << " b=" << b << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_contains_rect(a, b);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_convert_color()`.

This function has out-params. Python/C# wrappers look like:
	`convert_color(fz_colorspace *ss, const float *sv, fz_colorspace *ds, fz_colorspace *is, fz_color_params params)` => float dv
*/
FZ_FUNCTION void convert_color(fz_colorspace *ss, const float *sv, fz_colorspace *ds, float *dv, fz_colorspace *is, fz_color_params params)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_convert_color():" << " auto_ctx=" << auto_ctx << " ss=" << ss << " sv=" << (void*) sv << " ds=" << ds << " dv=" << (void*) dv << " is=" << is << " params=" << params << "\n";
	}
	fz_try(auto_ctx) {
		::fz_convert_color(auto_ctx, ss, sv, ds, dv, is, params);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_convert_indexed_pixmap_to_base()`. */
FZ_FUNCTION fz_pixmap *convert_indexed_pixmap_to_base(const fz_pixmap *src)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_convert_indexed_pixmap_to_base():" << " auto_ctx=" << auto_ctx << " src=" << src << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_convert_indexed_pixmap_to_base(auto_ctx, src);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_convert_pixmap()`. */
FZ_FUNCTION fz_pixmap *convert_pixmap(const fz_pixmap *pix, fz_colorspace *cs_des, fz_colorspace *prf, fz_default_colorspaces *default_cs, fz_color_params color_params, int keep_alpha)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_convert_pixmap():" << " auto_ctx=" << auto_ctx << " pix=" << pix << " cs_des=" << cs_des << " prf=" << prf << " default_cs=" << default_cs << " color_params=" << color_params << " keep_alpha=" << keep_alpha << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_convert_pixmap(auto_ctx, pix, cs_des, prf, default_cs, color_params, keep_alpha);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_convert_separation_colors()`.

This function has out-params. Python/C# wrappers look like:
	`convert_separation_colors(fz_colorspace *src_cs, const float *src_color, fz_separations *dst_seps, fz_colorspace *dst_cs, fz_color_params color_params)` => float dst_color
*/
FZ_FUNCTION void convert_separation_colors(fz_colorspace *src_cs, const float *src_color, fz_separations *dst_seps, fz_colorspace *dst_cs, float *dst_color, fz_color_params color_params)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_convert_separation_colors():" << " auto_ctx=" << auto_ctx << " src_cs=" << src_cs << " src_color=" << (void*) src_color << " dst_seps=" << dst_seps << " dst_cs=" << dst_cs << " dst_color=" << (void*) dst_color << " color_params=" << color_params << "\n";
	}
	fz_try(auto_ctx) {
		::fz_convert_separation_colors(auto_ctx, src_cs, src_color, dst_seps, dst_cs, dst_color, color_params);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_convert_separation_pixmap_to_base()`. */
FZ_FUNCTION fz_pixmap *convert_separation_pixmap_to_base(const fz_pixmap *src)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_convert_separation_pixmap_to_base():" << " auto_ctx=" << auto_ctx << " src=" << src << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_convert_separation_pixmap_to_base(auto_ctx, src);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_copy_option()`. */
FZ_FUNCTION size_t copy_option(const char *val, char *dest, size_t maxlen)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_copy_option():" << " auto_ctx=" << auto_ctx << " val=" << val << " dest=" << (void*) dest << " maxlen=" << maxlen << "\n";
	}
	size_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_copy_option(auto_ctx, val, dest, maxlen);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_copy_rectangle()`. */
FZ_FUNCTION char *copy_rectangle(fz_stext_page *page, fz_rect area, int crlf)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_copy_rectangle():" << " auto_ctx=" << auto_ctx << " page=" << page << " area=" << area << " crlf=" << crlf << "\n";
	}
	char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_copy_rectangle(auto_ctx, page, area, crlf);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_copy_selection()`. */
FZ_FUNCTION char *copy_selection(fz_stext_page *page, fz_point a, fz_point b, int crlf)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_copy_selection():" << " auto_ctx=" << auto_ctx << " page=" << page << " a=" << a << " b=" << b << " crlf=" << crlf << "\n";
	}
	char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_copy_selection(auto_ctx, page, a, b, crlf);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_count_active_separations()`. */
FZ_FUNCTION int count_active_separations(const fz_separations *seps)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_count_active_separations():" << " auto_ctx=" << auto_ctx << " seps=" << seps << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_count_active_separations(auto_ctx, seps);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_count_archive_entries()`. */
FZ_FUNCTION int count_archive_entries(fz_archive *arch)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_count_archive_entries():" << " auto_ctx=" << auto_ctx << " arch=" << arch << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_count_archive_entries(auto_ctx, arch);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_count_chapter_pages()`. */
FZ_FUNCTION int count_chapter_pages(fz_document *doc, int chapter)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_count_chapter_pages():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " chapter=" << chapter << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_count_chapter_pages(auto_ctx, doc, chapter);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_count_chapters()`. */
FZ_FUNCTION int count_chapters(fz_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_count_chapters():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_count_chapters(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_count_pages()`. */
FZ_FUNCTION int count_pages(fz_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_count_pages():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_count_pages(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_count_separations()`. */
FZ_FUNCTION int count_separations(const fz_separations *sep)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_count_separations():" << " auto_ctx=" << auto_ctx << " sep=" << sep << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_count_separations(auto_ctx, sep);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_create_link()`. */
FZ_FUNCTION fz_link *create_link(fz_page *page, fz_rect bbox, const char *uri)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_create_link():" << " auto_ctx=" << auto_ctx << " page=" << page << " bbox=" << bbox << " uri=" << uri << "\n";
	}
	fz_link * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_create_link(auto_ctx, page, bbox, uri);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_currentpoint()`. */
FZ_FUNCTION fz_point currentpoint(fz_path *path)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_currentpoint():" << " auto_ctx=" << auto_ctx << " path=" << path << "\n";
	}
	fz_point ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_currentpoint(auto_ctx, path);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_curveto()`. */
FZ_FUNCTION void curveto(fz_path *path, float x0, float y0, float x1, float y1, float x2, float y2)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_curveto():" << " auto_ctx=" << auto_ctx << " path=" << path << " x0=" << x0 << " y0=" << y0 << " x1=" << x1 << " y1=" << y1 << " x2=" << x2 << " y2=" << y2 << "\n";
	}
	fz_try(auto_ctx) {
		::fz_curveto(auto_ctx, path, x0, y0, x1, y1, x2, y2);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_curvetov()`. */
FZ_FUNCTION void curvetov(fz_path *path, float x1, float y1, float x2, float y2)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_curvetov():" << " auto_ctx=" << auto_ctx << " path=" << path << " x1=" << x1 << " y1=" << y1 << " x2=" << x2 << " y2=" << y2 << "\n";
	}
	fz_try(auto_ctx) {
		::fz_curvetov(auto_ctx, path, x1, y1, x2, y2);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_curvetoy()`. */
FZ_FUNCTION void curvetoy(fz_path *path, float x0, float y0, float x2, float y2)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_curvetoy():" << " auto_ctx=" << auto_ctx << " path=" << path << " x0=" << x0 << " y0=" << y0 << " x2=" << x2 << " y2=" << y2 << "\n";
	}
	fz_try(auto_ctx) {
		::fz_curvetoy(auto_ctx, path, x0, y0, x2, y2);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_debug_store()`. */
FZ_FUNCTION void debug_store(fz_output *out)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_debug_store():" << " auto_ctx=" << auto_ctx << " out=" << out << "\n";
	}
	fz_try(auto_ctx) {
		::fz_debug_store(auto_ctx, out);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_debug_xml()`. */
FZ_FUNCTION void debug_xml(fz_xml *item, int level)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_debug_xml():" << " item=" << item << " level=" << level << "\n";
	}
	fz_try(auto_ctx) {
		::fz_debug_xml(item, level);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_decode_tile()`. */
FZ_FUNCTION void decode_tile(fz_pixmap *pix, const float *decode)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_decode_tile():" << " auto_ctx=" << auto_ctx << " pix=" << pix << " decode=" << (void*) decode << "\n";
	}
	fz_try(auto_ctx) {
		::fz_decode_tile(auto_ctx, pix, decode);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_decomp_image_from_stream()`.

This function has out-params. Python/C# wrappers look like:
	`decomp_image_from_stream(fz_stream *stm, fz_compressed_image *image, fz_irect *subarea, int indexed, int l2factor)` => `(fz_pixmap *, int l2extra)`
*/
FZ_FUNCTION fz_pixmap *decomp_image_from_stream(fz_stream *stm, fz_compressed_image *image, fz_irect *subarea, int indexed, int l2factor, int *l2extra)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_decomp_image_from_stream():" << " auto_ctx=" << auto_ctx << " stm=" << stm << " image=" << image << " subarea=" << subarea << " indexed=" << indexed << " l2factor=" << l2factor << " l2extra=" << (void*) l2extra << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_decomp_image_from_stream(auto_ctx, stm, image, subarea, indexed, l2factor, l2extra);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_decouple_type3_font()`. */
FZ_FUNCTION void decouple_type3_font(fz_font *font, void *t3doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_decouple_type3_font():" << " auto_ctx=" << auto_ctx << " font=" << font << " t3doc=" << (void*) t3doc << "\n";
	}
	fz_try(auto_ctx) {
		::fz_decouple_type3_font(auto_ctx, font, t3doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_default_cmyk()`. */
FZ_FUNCTION fz_colorspace *default_cmyk(const fz_default_colorspaces *default_cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_default_cmyk():" << " auto_ctx=" << auto_ctx << " default_cs=" << default_cs << "\n";
	}
	fz_colorspace * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_default_cmyk(auto_ctx, default_cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_default_error_callback()`. */
FZ_FUNCTION void default_error_callback(void *user, const char *message)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_default_error_callback():" << " user=" << (void*) user << " message=" << message << "\n";
	}
	fz_try(auto_ctx) {
		::fz_default_error_callback(user, message);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_default_gray()`. */
FZ_FUNCTION fz_colorspace *default_gray(const fz_default_colorspaces *default_cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_default_gray():" << " auto_ctx=" << auto_ctx << " default_cs=" << default_cs << "\n";
	}
	fz_colorspace * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_default_gray(auto_ctx, default_cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_default_halftone()`. */
FZ_FUNCTION fz_halftone *default_halftone(int num_comps)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_default_halftone():" << " auto_ctx=" << auto_ctx << " num_comps=" << num_comps << "\n";
	}
	fz_halftone * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_default_halftone(auto_ctx, num_comps);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_default_output_intent()`. */
FZ_FUNCTION fz_colorspace *default_output_intent(const fz_default_colorspaces *default_cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_default_output_intent():" << " auto_ctx=" << auto_ctx << " default_cs=" << default_cs << "\n";
	}
	fz_colorspace * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_default_output_intent(auto_ctx, default_cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_default_rgb()`. */
FZ_FUNCTION fz_colorspace *default_rgb(const fz_default_colorspaces *default_cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_default_rgb():" << " auto_ctx=" << auto_ctx << " default_cs=" << default_cs << "\n";
	}
	fz_colorspace * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_default_rgb(auto_ctx, default_cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_default_warning_callback()`. */
FZ_FUNCTION void default_warning_callback(void *user, const char *message)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_default_warning_callback():" << " user=" << (void*) user << " message=" << message << "\n";
	}
	fz_try(auto_ctx) {
		::fz_default_warning_callback(user, message);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_defer_reap_end()`. */
FZ_FUNCTION void defer_reap_end()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_defer_reap_end():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_try(auto_ctx) {
		::fz_defer_reap_end(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_defer_reap_start()`. */
FZ_FUNCTION void defer_reap_start()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_defer_reap_start():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_try(auto_ctx) {
		::fz_defer_reap_start(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_deflate()`.

This function has out-params. Python/C# wrappers look like:
	`deflate(unsigned char *dest, const unsigned char *source, size_t source_length, fz_deflate_level level)` => size_t compressed_length
*/
FZ_FUNCTION void deflate(unsigned char *dest, size_t *compressed_length, const unsigned char *source, size_t source_length, fz_deflate_level level)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_deflate():" << " auto_ctx=" << auto_ctx << " dest=" << (void*) dest << " compressed_length=" << (void*) compressed_length << " source=" << (void*) source << " source_length=" << source_length << " level=" << level << "\n";
	}
	fz_try(auto_ctx) {
		::fz_deflate(auto_ctx, dest, compressed_length, source, source_length, level);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_deflate_bound()`. */
FZ_FUNCTION size_t deflate_bound(size_t size)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_deflate_bound():" << " auto_ctx=" << auto_ctx << " size=" << size << "\n";
	}
	size_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_deflate_bound(auto_ctx, size);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_detach_xml()`. */
FZ_FUNCTION void detach_xml(fz_xml_doc *xml, fz_xml *node)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_detach_xml():" << " auto_ctx=" << auto_ctx << " xml=" << xml << " node=" << node << "\n";
	}
	fz_try(auto_ctx) {
		::fz_detach_xml(auto_ctx, xml, node);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_device_bgr()`. */
FZ_FUNCTION fz_colorspace *device_bgr()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_device_bgr():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_colorspace * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_device_bgr(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_device_cmyk()`. */
FZ_FUNCTION fz_colorspace *device_cmyk()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_device_cmyk():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_colorspace * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_device_cmyk(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_device_current_scissor()`. */
FZ_FUNCTION fz_rect device_current_scissor(fz_device *dev)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_device_current_scissor():" << " auto_ctx=" << auto_ctx << " dev=" << dev << "\n";
	}
	fz_rect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_device_current_scissor(auto_ctx, dev);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_device_gray()`. */
FZ_FUNCTION fz_colorspace *device_gray()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_device_gray():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_colorspace * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_device_gray(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_device_lab()`. */
FZ_FUNCTION fz_colorspace *device_lab()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_device_lab():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_colorspace * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_device_lab(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_device_rgb()`. */
FZ_FUNCTION fz_colorspace *device_rgb()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_device_rgb():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_colorspace * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_device_rgb(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_dirname()`. */
FZ_FUNCTION void dirname(char *dir, const char *path, size_t dirsize)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_dirname():" << " dir=" << (void*) dir << " path=" << path << " dirsize=" << dirsize << "\n";
	}
	fz_try(auto_ctx) {
		::fz_dirname(dir, path, dirsize);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_disable_device_hints()`. */
FZ_FUNCTION void disable_device_hints(fz_device *dev, int hints)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_disable_device_hints():" << " auto_ctx=" << auto_ctx << " dev=" << dev << " hints=" << hints << "\n";
	}
	fz_try(auto_ctx) {
		::fz_disable_device_hints(auto_ctx, dev, hints);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_disable_icc()`. */
FZ_FUNCTION void disable_icc()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_disable_icc():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_try(auto_ctx) {
		::fz_disable_icc(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_display_list_is_empty()`. */
FZ_FUNCTION int display_list_is_empty(const fz_display_list *list)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_display_list_is_empty():" << " auto_ctx=" << auto_ctx << " list=" << list << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_display_list_is_empty(auto_ctx, list);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_div255()`. */
FZ_FUNCTION int div255(int c, int a)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_div255():" << " c=" << c << " a=" << a << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_div255(c, a);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_do_always()`. */
FZ_FUNCTION int do_always()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_do_always():" << " auto_ctx=" << auto_ctx << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_do_always(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_do_catch()`. */
FZ_FUNCTION int do_catch()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_do_catch():" << " auto_ctx=" << auto_ctx << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_do_catch(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_do_try()`. */
FZ_FUNCTION int do_try()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_do_try():" << " auto_ctx=" << auto_ctx << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_do_try(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_document_output_intent()`. */
FZ_FUNCTION fz_colorspace *document_output_intent(fz_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_document_output_intent():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_colorspace * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_document_output_intent(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_document_supports_accelerator()`. */
FZ_FUNCTION int document_supports_accelerator(fz_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_document_supports_accelerator():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_document_supports_accelerator(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_drop_archive()`. */
FZ_FUNCTION void drop_archive(fz_archive *arch)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_archive():" << " auto_ctx=" << auto_ctx << " arch=" << arch << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_archive(auto_ctx, arch);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_band_writer()`. */
FZ_FUNCTION void drop_band_writer(fz_band_writer *writer)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_band_writer():" << " auto_ctx=" << auto_ctx << " writer=" << writer << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_band_writer(auto_ctx, writer);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_bitmap()`. */
FZ_FUNCTION void drop_bitmap(fz_bitmap *bit)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_bitmap():" << " auto_ctx=" << auto_ctx << " bit=" << bit << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_bitmap(auto_ctx, bit);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_buffer()`. */
FZ_FUNCTION void drop_buffer(fz_buffer *buf)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_buffer():" << " auto_ctx=" << auto_ctx << " buf=" << buf << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_buffer(auto_ctx, buf);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_colorspace()`. */
FZ_FUNCTION void drop_colorspace(fz_colorspace *colorspace)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_colorspace():" << " auto_ctx=" << auto_ctx << " colorspace=" << colorspace << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_colorspace(auto_ctx, colorspace);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_colorspace_imp()`. */
FZ_FUNCTION void drop_colorspace_imp(fz_storable *cs_)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_colorspace_imp():" << " auto_ctx=" << auto_ctx << " cs_=" << cs_ << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_colorspace_imp(auto_ctx, cs_);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_compressed_buffer()`. */
FZ_FUNCTION void drop_compressed_buffer(fz_compressed_buffer *buf)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_compressed_buffer():" << " auto_ctx=" << auto_ctx << " buf=" << buf << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_compressed_buffer(auto_ctx, buf);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_context()`. */
FZ_FUNCTION void drop_context()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_context():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_context(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_default_colorspaces()`. */
FZ_FUNCTION void drop_default_colorspaces(fz_default_colorspaces *default_cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_default_colorspaces():" << " auto_ctx=" << auto_ctx << " default_cs=" << default_cs << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_default_colorspaces(auto_ctx, default_cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_device()`. */
FZ_FUNCTION void drop_device(fz_device *dev)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_device():" << " auto_ctx=" << auto_ctx << " dev=" << dev << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_device(auto_ctx, dev);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_display_list()`. */
FZ_FUNCTION void drop_display_list(fz_display_list *list)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_display_list():" << " auto_ctx=" << auto_ctx << " list=" << list << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_display_list(auto_ctx, list);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_document()`. */
FZ_FUNCTION void drop_document(fz_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_document():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_document(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_document_writer()`. */
FZ_FUNCTION void drop_document_writer(fz_document_writer *wri)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_document_writer():" << " auto_ctx=" << auto_ctx << " wri=" << wri << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_document_writer(auto_ctx, wri);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_font()`. */
FZ_FUNCTION void drop_font(fz_font *font)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_font():" << " auto_ctx=" << auto_ctx << " font=" << font << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_font(auto_ctx, font);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_glyph()`. */
FZ_FUNCTION void drop_glyph(fz_glyph *pix)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_glyph():" << " auto_ctx=" << auto_ctx << " pix=" << pix << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_glyph(auto_ctx, pix);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_halftone()`. */
FZ_FUNCTION void drop_halftone(fz_halftone *ht)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_halftone():" << " auto_ctx=" << auto_ctx << " ht=" << ht << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_halftone(auto_ctx, ht);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_hash_table()`. */
FZ_FUNCTION void drop_hash_table(fz_hash_table *table)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_hash_table():" << " auto_ctx=" << auto_ctx << " table=" << table << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_hash_table(auto_ctx, table);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_image()`. */
FZ_FUNCTION void drop_image(fz_image *image)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_image():" << " auto_ctx=" << auto_ctx << " image=" << image << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_image(auto_ctx, image);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_image_base()`. */
FZ_FUNCTION void drop_image_base(fz_image *image)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_image_base():" << " auto_ctx=" << auto_ctx << " image=" << image << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_image_base(auto_ctx, image);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_image_imp()`. */
FZ_FUNCTION void drop_image_imp(fz_storable *image)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_image_imp():" << " auto_ctx=" << auto_ctx << " image=" << image << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_image_imp(auto_ctx, image);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_image_store_key()`. */
FZ_FUNCTION void drop_image_store_key(fz_image *image)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_image_store_key():" << " auto_ctx=" << auto_ctx << " image=" << image << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_image_store_key(auto_ctx, image);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_imp()`.

This function has out-params. Python/C# wrappers look like:
	`drop_imp(void *p)` => `(int, int refs)`
*/
FZ_FUNCTION int drop_imp(void *p, int *refs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_imp():" << " auto_ctx=" << auto_ctx << " p=" << (void*) p << " refs=" << (void*) refs << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_drop_imp(auto_ctx, p, refs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_drop_imp16()`.

This function has out-params. Python/C# wrappers look like:
	`drop_imp16(void *p)` => `(int, int16_t refs)`
*/
FZ_FUNCTION int drop_imp16(void *p, int16_t *refs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_imp16():" << " auto_ctx=" << auto_ctx << " p=" << (void*) p << " refs=" << (void*) refs << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_drop_imp16(auto_ctx, p, refs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_drop_imp8()`. */
FZ_FUNCTION int drop_imp8(void *p, int8_t *refs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_imp8():" << " auto_ctx=" << auto_ctx << " p=" << (void*) p << " refs=" << (void*) refs << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_drop_imp8(auto_ctx, p, refs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_drop_jbig2_globals()`. */
FZ_FUNCTION void drop_jbig2_globals(fz_jbig2_globals *globals)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_jbig2_globals():" << " auto_ctx=" << auto_ctx << " globals=" << globals << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_jbig2_globals(auto_ctx, globals);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_jbig2_globals_imp()`. */
FZ_FUNCTION void drop_jbig2_globals_imp(fz_storable *globals)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_jbig2_globals_imp():" << " auto_ctx=" << auto_ctx << " globals=" << globals << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_jbig2_globals_imp(auto_ctx, globals);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_key_storable()`. */
FZ_FUNCTION void drop_key_storable(const fz_key_storable *arg_1)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_key_storable():" << " auto_ctx=" << auto_ctx << " arg_1=" << arg_1 << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_key_storable(auto_ctx, arg_1);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_key_storable_key()`. */
FZ_FUNCTION void drop_key_storable_key(const fz_key_storable *arg_1)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_key_storable_key():" << " auto_ctx=" << auto_ctx << " arg_1=" << arg_1 << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_key_storable_key(auto_ctx, arg_1);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_layout()`. */
FZ_FUNCTION void drop_layout(fz_layout_block *block)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_layout():" << " auto_ctx=" << auto_ctx << " block=" << block << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_layout(auto_ctx, block);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_link()`. */
FZ_FUNCTION void drop_link(fz_link *link)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_link():" << " auto_ctx=" << auto_ctx << " link=" << link << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_link(auto_ctx, link);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_outline()`. */
FZ_FUNCTION void drop_outline(fz_outline *outline)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_outline():" << " auto_ctx=" << auto_ctx << " outline=" << outline << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_outline(auto_ctx, outline);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_outline_iterator()`. */
FZ_FUNCTION void drop_outline_iterator(fz_outline_iterator *iter)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_outline_iterator():" << " auto_ctx=" << auto_ctx << " iter=" << iter << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_outline_iterator(auto_ctx, iter);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_output()`. */
FZ_FUNCTION void drop_output(fz_output *arg_1)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_output():" << " auto_ctx=" << auto_ctx << " arg_1=" << arg_1 << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_output(auto_ctx, arg_1);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_page()`. */
FZ_FUNCTION void drop_page(fz_page *page)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_page():" << " auto_ctx=" << auto_ctx << " page=" << page << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_page(auto_ctx, page);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_path()`. */
FZ_FUNCTION void drop_path(const fz_path *path)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_path():" << " auto_ctx=" << auto_ctx << " path=" << path << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_path(auto_ctx, path);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_pixmap()`. */
FZ_FUNCTION void drop_pixmap(fz_pixmap *pix)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_pixmap():" << " auto_ctx=" << auto_ctx << " pix=" << pix << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_pixmap(auto_ctx, pix);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_pool()`. */
FZ_FUNCTION void drop_pool(fz_pool *pool)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_pool():" << " auto_ctx=" << auto_ctx << " pool=" << pool << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_pool(auto_ctx, pool);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_separations()`. */
FZ_FUNCTION void drop_separations(fz_separations *sep)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_separations():" << " auto_ctx=" << auto_ctx << " sep=" << sep << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_separations(auto_ctx, sep);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_shade()`. */
FZ_FUNCTION void drop_shade(fz_shade *shade)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_shade():" << " auto_ctx=" << auto_ctx << " shade=" << shade << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_shade(auto_ctx, shade);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_shade_color_cache()`. */
FZ_FUNCTION void drop_shade_color_cache(fz_shade_color_cache *cache)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_shade_color_cache():" << " auto_ctx=" << auto_ctx << " cache=" << cache << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_shade_color_cache(auto_ctx, cache);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_shade_imp()`. */
FZ_FUNCTION void drop_shade_imp(fz_storable *shade)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_shade_imp():" << " auto_ctx=" << auto_ctx << " shade=" << shade << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_shade_imp(auto_ctx, shade);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_stext_page()`. */
FZ_FUNCTION void drop_stext_page(fz_stext_page *page)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_stext_page():" << " auto_ctx=" << auto_ctx << " page=" << page << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_stext_page(auto_ctx, page);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_storable()`. */
FZ_FUNCTION void drop_storable(const fz_storable *arg_1)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_storable():" << " auto_ctx=" << auto_ctx << " arg_1=" << arg_1 << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_storable(auto_ctx, arg_1);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_store_context()`. */
FZ_FUNCTION void drop_store_context()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_store_context():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_store_context(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_stream()`. */
FZ_FUNCTION void drop_stream(fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_stream():" << " auto_ctx=" << auto_ctx << " stm=" << stm << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_stream(auto_ctx, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_stroke_state()`. */
FZ_FUNCTION void drop_stroke_state(const fz_stroke_state *stroke)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_stroke_state():" << " auto_ctx=" << auto_ctx << " stroke=" << stroke << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_stroke_state(auto_ctx, stroke);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_text()`. */
FZ_FUNCTION void drop_text(const fz_text *text)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_text():" << " auto_ctx=" << auto_ctx << " text=" << text << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_text(auto_ctx, text);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_tree()`. */
FZ_FUNCTION void drop_tree(fz_tree *node, void (*dropfunc)(fz_context *, void *))
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_tree():" << " auto_ctx=" << auto_ctx << " node=" << node << " dropfunc=" << (void*) dropfunc << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_tree(auto_ctx, node, dropfunc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_xml()`. */
FZ_FUNCTION void drop_xml(fz_xml_doc *xml)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_xml():" << " auto_ctx=" << auto_ctx << " xml=" << xml << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_xml(auto_ctx, xml);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_drop_zip_writer()`. */
FZ_FUNCTION void drop_zip_writer(fz_zip_writer *zip)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_drop_zip_writer():" << " auto_ctx=" << auto_ctx << " zip=" << zip << "\n";
	}
	fz_try(auto_ctx) {
		::fz_drop_zip_writer(auto_ctx, zip);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_dump_glyph_cache_stats()`. */
FZ_FUNCTION void dump_glyph_cache_stats(fz_output *out)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_dump_glyph_cache_stats():" << " auto_ctx=" << auto_ctx << " out=" << out << "\n";
	}
	fz_try(auto_ctx) {
		::fz_dump_glyph_cache_stats(auto_ctx, out);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_duplicate_glyph_names_from_unicode()`. */
FZ_FUNCTION const char **duplicate_glyph_names_from_unicode(int unicode)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_duplicate_glyph_names_from_unicode():" << " unicode=" << unicode << "\n";
	}
	const char ** ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_duplicate_glyph_names_from_unicode(unicode);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_empty_store()`. */
FZ_FUNCTION void empty_store()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_empty_store():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_try(auto_ctx) {
		::fz_empty_store(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_enable_device_hints()`. */
FZ_FUNCTION void enable_device_hints(fz_device *dev, int hints)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_enable_device_hints():" << " auto_ctx=" << auto_ctx << " dev=" << dev << " hints=" << hints << "\n";
	}
	fz_try(auto_ctx) {
		::fz_enable_device_hints(auto_ctx, dev, hints);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_enable_icc()`. */
FZ_FUNCTION void enable_icc()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_enable_icc():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_try(auto_ctx) {
		::fz_enable_icc(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_encode_character()`. */
FZ_FUNCTION int encode_character(fz_font *font, int unicode)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_encode_character():" << " auto_ctx=" << auto_ctx << " font=" << font << " unicode=" << unicode << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_encode_character(auto_ctx, font, unicode);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_encode_character_by_glyph_name()`. */
FZ_FUNCTION int encode_character_by_glyph_name(fz_font *font, const char *glyphname)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_encode_character_by_glyph_name():" << " auto_ctx=" << auto_ctx << " font=" << font << " glyphname=" << glyphname << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_encode_character_by_glyph_name(auto_ctx, font, glyphname);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_encode_character_sc()`. */
FZ_FUNCTION int encode_character_sc(fz_font *font, int unicode)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_encode_character_sc():" << " auto_ctx=" << auto_ctx << " font=" << font << " unicode=" << unicode << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_encode_character_sc(auto_ctx, font, unicode);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_encode_character_with_fallback()`.

This function has out-params. Python/C# wrappers look like:
	`encode_character_with_fallback(fz_font *font, int unicode, int script, int language, fz_font **out_font)` => `(int)`
*/
FZ_FUNCTION int encode_character_with_fallback(fz_font *font, int unicode, int script, int language, fz_font **out_font)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_encode_character_with_fallback():" << " auto_ctx=" << auto_ctx << " font=" << font << " unicode=" << unicode << " script=" << script << " language=" << language << " out_font=" << (void*) out_font << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_encode_character_with_fallback(auto_ctx, font, unicode, script, language, out_font);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_end_group()`. */
FZ_FUNCTION void end_group(fz_device *dev)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_end_group():" << " auto_ctx=" << auto_ctx << " dev=" << dev << "\n";
	}
	fz_try(auto_ctx) {
		::fz_end_group(auto_ctx, dev);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_end_layer()`. */
FZ_FUNCTION void end_layer(fz_device *dev)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_end_layer():" << " auto_ctx=" << auto_ctx << " dev=" << dev << "\n";
	}
	fz_try(auto_ctx) {
		::fz_end_layer(auto_ctx, dev);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_end_mask()`. */
FZ_FUNCTION void end_mask(fz_device *dev)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_end_mask():" << " auto_ctx=" << auto_ctx << " dev=" << dev << "\n";
	}
	fz_try(auto_ctx) {
		::fz_end_mask(auto_ctx, dev);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_end_page()`. */
FZ_FUNCTION void end_page(fz_document_writer *wri)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_end_page():" << " auto_ctx=" << auto_ctx << " wri=" << wri << "\n";
	}
	fz_try(auto_ctx) {
		::fz_end_page(auto_ctx, wri);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_end_throw_on_repair()`. */
FZ_FUNCTION void end_throw_on_repair()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_end_throw_on_repair():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_try(auto_ctx) {
		::fz_end_throw_on_repair(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_end_tile()`. */
FZ_FUNCTION void end_tile(fz_device *dev)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_end_tile():" << " auto_ctx=" << auto_ctx << " dev=" << dev << "\n";
	}
	fz_try(auto_ctx) {
		::fz_end_tile(auto_ctx, dev);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_error_callback()`.

This function has out-params. Python/C# wrappers look like:
	`error_callback()` => `(fz_error_cb *, void *user)`
*/
FZ_FUNCTION fz_error_cb *error_callback(void **user)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_error_callback():" << " auto_ctx=" << auto_ctx << " user=" << (void*) user << "\n";
	}
	fz_error_cb * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_error_callback(auto_ctx, user);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_expand_irect()`. */
FZ_FUNCTION fz_irect expand_irect(fz_irect a, int expand)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_expand_irect():" << " a=" << a << " expand=" << expand << "\n";
	}
	fz_irect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_expand_irect(a, expand);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_expand_rect()`. */
FZ_FUNCTION fz_rect expand_rect(fz_rect b, float expand)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_expand_rect():" << " b=" << b << " expand=" << expand << "\n";
	}
	fz_rect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_expand_rect(b, expand);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_file_exists()`. */
FZ_FUNCTION int file_exists(const char *path)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_file_exists():" << " auto_ctx=" << auto_ctx << " path=" << path << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_file_exists(auto_ctx, path);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_fill_image()`. */
FZ_FUNCTION void fill_image(fz_device *dev, fz_image *image, fz_matrix ctm, float alpha, fz_color_params color_params)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_fill_image():" << " auto_ctx=" << auto_ctx << " dev=" << dev << " image=" << image << " ctm=" << ctm << " alpha=" << alpha << " color_params=" << color_params << "\n";
	}
	fz_try(auto_ctx) {
		::fz_fill_image(auto_ctx, dev, image, ctm, alpha, color_params);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_fill_image_mask()`. */
FZ_FUNCTION void fill_image_mask(fz_device *dev, fz_image *image, fz_matrix ctm, fz_colorspace *colorspace, const float *color, float alpha, fz_color_params color_params)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_fill_image_mask():" << " auto_ctx=" << auto_ctx << " dev=" << dev << " image=" << image << " ctm=" << ctm << " colorspace=" << colorspace << " color=" << (void*) color << " alpha=" << alpha << " color_params=" << color_params << "\n";
	}
	fz_try(auto_ctx) {
		::fz_fill_image_mask(auto_ctx, dev, image, ctm, colorspace, color, alpha, color_params);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_fill_path()`. */
FZ_FUNCTION void fill_path(fz_device *dev, const fz_path *path, int even_odd, fz_matrix ctm, fz_colorspace *colorspace, const float *color, float alpha, fz_color_params color_params)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_fill_path():" << " auto_ctx=" << auto_ctx << " dev=" << dev << " path=" << path << " even_odd=" << even_odd << " ctm=" << ctm << " colorspace=" << colorspace << " color=" << (void*) color << " alpha=" << alpha << " color_params=" << color_params << "\n";
	}
	fz_try(auto_ctx) {
		::fz_fill_path(auto_ctx, dev, path, even_odd, ctm, colorspace, color, alpha, color_params);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_fill_pixmap_with_color()`.

This function has out-params. Python/C# wrappers look like:
	`fill_pixmap_with_color(fz_pixmap *pix, fz_colorspace *colorspace, fz_color_params color_params)` => float color
*/
FZ_FUNCTION void fill_pixmap_with_color(fz_pixmap *pix, fz_colorspace *colorspace, float *color, fz_color_params color_params)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_fill_pixmap_with_color():" << " auto_ctx=" << auto_ctx << " pix=" << pix << " colorspace=" << colorspace << " color=" << (void*) color << " color_params=" << color_params << "\n";
	}
	fz_try(auto_ctx) {
		::fz_fill_pixmap_with_color(auto_ctx, pix, colorspace, color, color_params);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_fill_shade()`. */
FZ_FUNCTION void fill_shade(fz_device *dev, fz_shade *shade, fz_matrix ctm, float alpha, fz_color_params color_params)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_fill_shade():" << " auto_ctx=" << auto_ctx << " dev=" << dev << " shade=" << shade << " ctm=" << ctm << " alpha=" << alpha << " color_params=" << color_params << "\n";
	}
	fz_try(auto_ctx) {
		::fz_fill_shade(auto_ctx, dev, shade, ctm, alpha, color_params);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_fill_text()`. */
FZ_FUNCTION void fill_text(fz_device *dev, const fz_text *text, fz_matrix ctm, fz_colorspace *colorspace, const float *color, float alpha, fz_color_params color_params)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_fill_text():" << " auto_ctx=" << auto_ctx << " dev=" << dev << " text=" << text << " ctm=" << ctm << " colorspace=" << colorspace << " color=" << (void*) color << " alpha=" << alpha << " color_params=" << color_params << "\n";
	}
	fz_try(auto_ctx) {
		::fz_fill_text(auto_ctx, dev, text, ctm, colorspace, color, alpha, color_params);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_filter_store()`. */
FZ_FUNCTION void filter_store(fz_store_filter_fn *fn, void *arg, const fz_store_type *type)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_filter_store():" << " auto_ctx=" << auto_ctx << " fn=" << (void*) fn << " arg=" << (void*) arg << " type=" << type << "\n";
	}
	fz_try(auto_ctx) {
		::fz_filter_store(auto_ctx, fn, arg, type);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_find_item()`. */
FZ_FUNCTION void *find_item(fz_store_drop_fn *drop, void *key, const fz_store_type *type)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_find_item():" << " auto_ctx=" << auto_ctx << " drop=" << (void*) drop << " key=" << (void*) key << " type=" << type << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_find_item(auto_ctx, drop, key, type);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_flush_output()`. */
FZ_FUNCTION void flush_output(fz_output *out)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_flush_output():" << " auto_ctx=" << auto_ctx << " out=" << out << "\n";
	}
	fz_try(auto_ctx) {
		::fz_flush_output(auto_ctx, out);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_flush_warnings()`. */
FZ_FUNCTION void flush_warnings()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_flush_warnings():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_try(auto_ctx) {
		::fz_flush_warnings(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_font_ascender()`. */
FZ_FUNCTION float font_ascender(fz_font *font)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_font_ascender():" << " auto_ctx=" << auto_ctx << " font=" << font << "\n";
	}
	float ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_font_ascender(auto_ctx, font);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_font_bbox()`. */
FZ_FUNCTION fz_rect font_bbox(fz_font *font)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_font_bbox():" << " auto_ctx=" << auto_ctx << " font=" << font << "\n";
	}
	fz_rect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_font_bbox(auto_ctx, font);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_font_descender()`. */
FZ_FUNCTION float font_descender(fz_font *font)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_font_descender():" << " auto_ctx=" << auto_ctx << " font=" << font << "\n";
	}
	float ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_font_descender(auto_ctx, font);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_font_digest()`. */
FZ_FUNCTION void font_digest(fz_font *font, unsigned char digest[16])
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_font_digest():" << " auto_ctx=" << auto_ctx << " font=" << font << " digest=" << digest << "\n";
	}
	fz_try(auto_ctx) {
		::fz_font_digest(auto_ctx, font, digest);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_font_flags()`. */
FZ_FUNCTION fz_font_flags_t *font_flags(fz_font *font)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_font_flags():" << " font=" << font << "\n";
	}
	fz_font_flags_t * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_font_flags(font);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_font_ft_face()`. */
FZ_FUNCTION void *font_ft_face(fz_font *font)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_font_ft_face():" << " auto_ctx=" << auto_ctx << " font=" << font << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_font_ft_face(auto_ctx, font);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_font_is_bold()`. */
FZ_FUNCTION int font_is_bold(fz_font *font)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_font_is_bold():" << " auto_ctx=" << auto_ctx << " font=" << font << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_font_is_bold(auto_ctx, font);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_font_is_italic()`. */
FZ_FUNCTION int font_is_italic(fz_font *font)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_font_is_italic():" << " auto_ctx=" << auto_ctx << " font=" << font << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_font_is_italic(auto_ctx, font);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_font_is_monospaced()`. */
FZ_FUNCTION int font_is_monospaced(fz_font *font)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_font_is_monospaced():" << " auto_ctx=" << auto_ctx << " font=" << font << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_font_is_monospaced(auto_ctx, font);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_font_is_serif()`. */
FZ_FUNCTION int font_is_serif(fz_font *font)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_font_is_serif():" << " auto_ctx=" << auto_ctx << " font=" << font << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_font_is_serif(auto_ctx, font);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_font_name()`. */
FZ_FUNCTION const char *font_name(fz_font *font)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_font_name():" << " auto_ctx=" << auto_ctx << " font=" << font << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_font_name(auto_ctx, font);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_font_shaper_data()`. */
FZ_FUNCTION fz_shaper_data_t *font_shaper_data(fz_font *font)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_font_shaper_data():" << " auto_ctx=" << auto_ctx << " font=" << font << "\n";
	}
	fz_shaper_data_t * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_font_shaper_data(auto_ctx, font);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_font_t3_procs()`. */
FZ_FUNCTION fz_buffer **font_t3_procs(fz_font *font)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_font_t3_procs():" << " auto_ctx=" << auto_ctx << " font=" << font << "\n";
	}
	fz_buffer ** ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_font_t3_procs(auto_ctx, font);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_format_link_uri()`. */
FZ_FUNCTION char *format_link_uri(fz_document *doc, fz_link_dest dest)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_format_link_uri():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " &dest=" << &dest << "\n";
	}
	char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_format_link_uri(auto_ctx, doc, dest);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_format_output_path()`. */
FZ_FUNCTION void format_output_path(char *path, size_t size, const char *fmt, int page)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_format_output_path():" << " auto_ctx=" << auto_ctx << " path=" << (void*) path << " size=" << size << " fmt=" << fmt << " page=" << page << "\n";
	}
	fz_try(auto_ctx) {
		::fz_format_output_path(auto_ctx, path, size, fmt, page);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_format_string()`. */
FZ_FUNCTION void format_string(void *user, void (*emit)(fz_context *, void *, int ), const char *fmt, va_list args)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_format_string():" << " auto_ctx=" << auto_ctx << " user=" << (void*) user << " emit=" << (void*) emit << " fmt=" << fmt << " args=" << args << "\n";
	}
	fz_try(auto_ctx) {
		::fz_format_string(auto_ctx, user, emit, fmt, args);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_free()`. */
FZ_FUNCTION void free(void *p)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_free():" << " auto_ctx=" << auto_ctx << " p=" << (void*) p << "\n";
	}
	fz_try(auto_ctx) {
		::fz_free(auto_ctx, p);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_gamma_pixmap()`. */
FZ_FUNCTION void gamma_pixmap(fz_pixmap *pix, float gamma)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_gamma_pixmap():" << " auto_ctx=" << auto_ctx << " pix=" << pix << " gamma=" << gamma << "\n";
	}
	fz_try(auto_ctx) {
		::fz_gamma_pixmap(auto_ctx, pix, gamma);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_generate_transition()`. */
FZ_FUNCTION int generate_transition(fz_pixmap *tpix, fz_pixmap *opix, fz_pixmap *npix, int time, fz_transition *trans)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_generate_transition():" << " auto_ctx=" << auto_ctx << " tpix=" << tpix << " opix=" << opix << " npix=" << npix << " time=" << time << " trans=" << trans << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_generate_transition(auto_ctx, tpix, opix, npix, time, trans);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_get_glyph_name()`. */
FZ_FUNCTION void get_glyph_name(fz_font *font, int glyph, char *buf, int size)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_get_glyph_name():" << " auto_ctx=" << auto_ctx << " font=" << font << " glyph=" << glyph << " buf=" << (void*) buf << " size=" << size << "\n";
	}
	fz_try(auto_ctx) {
		::fz_get_glyph_name(auto_ctx, font, glyph, buf, size);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_get_pixmap_from_image()`.

This function has out-params. Python/C# wrappers look like:
	`get_pixmap_from_image(fz_image *image, const fz_irect *subarea, fz_matrix *ctm)` => `(fz_pixmap *, int w, int h)`
*/
FZ_FUNCTION fz_pixmap *get_pixmap_from_image(fz_image *image, const fz_irect *subarea, fz_matrix *ctm, int *w, int *h)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_get_pixmap_from_image():" << " auto_ctx=" << auto_ctx << " image=" << image << " subarea=" << subarea << " ctm=" << ctm << " w=" << (void*) w << " h=" << (void*) h << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_get_pixmap_from_image(auto_ctx, image, subarea, ctm, w, h);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_get_unscaled_pixmap_from_image()`. */
FZ_FUNCTION fz_pixmap *get_unscaled_pixmap_from_image(fz_image *image)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_get_unscaled_pixmap_from_image():" << " auto_ctx=" << auto_ctx << " image=" << image << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_get_unscaled_pixmap_from_image(auto_ctx, image);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_getopt()`.

This function has out-params. Python/C# wrappers look like:
	`getopt(int nargc, const char *ostr)` => `(int, char *nargv)`
*/
FZ_FUNCTION int getopt(int nargc, char **nargv, const char *ostr)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_getopt():" << " nargc=" << nargc << " nargv=" << (void*) nargv << " ostr=" << ostr << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_getopt(nargc, nargv, ostr);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_glyph_bbox()`. */
FZ_FUNCTION fz_irect glyph_bbox(fz_glyph *glyph)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_glyph_bbox():" << " auto_ctx=" << auto_ctx << " glyph=" << glyph << "\n";
	}
	fz_irect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_glyph_bbox(auto_ctx, glyph);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_glyph_bbox_no_ctx()`. */
FZ_FUNCTION fz_irect glyph_bbox_no_ctx(fz_glyph *src)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_glyph_bbox_no_ctx():" << " src=" << src << "\n";
	}
	fz_irect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_glyph_bbox_no_ctx(src);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_glyph_cacheable()`. */
FZ_FUNCTION int glyph_cacheable(fz_font *font, int gid)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_glyph_cacheable():" << " auto_ctx=" << auto_ctx << " font=" << font << " gid=" << gid << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_glyph_cacheable(auto_ctx, font, gid);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_glyph_height()`. */
FZ_FUNCTION int glyph_height(fz_glyph *glyph)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_glyph_height():" << " auto_ctx=" << auto_ctx << " glyph=" << glyph << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_glyph_height(auto_ctx, glyph);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_glyph_name_from_unicode_sc()`. */
FZ_FUNCTION const char *glyph_name_from_unicode_sc(int unicode)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_glyph_name_from_unicode_sc():" << " unicode=" << unicode << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_glyph_name_from_unicode_sc(unicode);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_glyph_width()`. */
FZ_FUNCTION int glyph_width(fz_glyph *glyph)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_glyph_width():" << " auto_ctx=" << auto_ctx << " glyph=" << glyph << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_glyph_width(auto_ctx, glyph);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_graphics_aa_level()`. */
FZ_FUNCTION int graphics_aa_level()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_graphics_aa_level():" << " auto_ctx=" << auto_ctx << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_graphics_aa_level(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_graphics_min_line_width()`. */
FZ_FUNCTION float graphics_min_line_width()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_graphics_min_line_width():" << " auto_ctx=" << auto_ctx << "\n";
	}
	float ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_graphics_min_line_width(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_gridfit_matrix()`. */
FZ_FUNCTION fz_matrix gridfit_matrix(int as_tiled, fz_matrix m)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_gridfit_matrix():" << " as_tiled=" << as_tiled << " m=" << m << "\n";
	}
	fz_matrix ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_gridfit_matrix(as_tiled, m);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_grisu()`.

This function has out-params. Python/C# wrappers look like:
	`grisu(float f, char *s)` => `(int, int exp)`
*/
FZ_FUNCTION int grisu(float f, char *s, int *exp)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_grisu():" << " f=" << f << " s=" << (void*) s << " exp=" << (void*) exp << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_grisu(f, s, exp);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_grow_buffer()`. */
FZ_FUNCTION void grow_buffer(fz_buffer *buf)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_grow_buffer():" << " auto_ctx=" << auto_ctx << " buf=" << buf << "\n";
	}
	fz_try(auto_ctx) {
		::fz_grow_buffer(auto_ctx, buf);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_has_archive_entry()`. */
FZ_FUNCTION int has_archive_entry(fz_archive *arch, const char *name)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_has_archive_entry():" << " auto_ctx=" << auto_ctx << " arch=" << arch << " name=" << name << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_has_archive_entry(auto_ctx, arch, name);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_has_option()`.

This function has out-params. Python/C# wrappers look like:
	`has_option(const char *opts, const char *key)` => `(int, const char *val)`
*/
FZ_FUNCTION int has_option(const char *opts, const char *key, const char **val)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_has_option():" << " auto_ctx=" << auto_ctx << " opts=" << opts << " key=" << key << " val=" << (void*) val << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_has_option(auto_ctx, opts, key, val);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_has_permission()`. */
FZ_FUNCTION int has_permission(fz_document *doc, fz_permission p)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_has_permission():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " p=" << p << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_has_permission(auto_ctx, doc, p);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_hash_filter()`. */
FZ_FUNCTION void hash_filter(fz_hash_table *table, void *state, fz_hash_table_filter_fn *callback)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_hash_filter():" << " auto_ctx=" << auto_ctx << " table=" << table << " state=" << (void*) state << " callback=" << (void*) callback << "\n";
	}
	fz_try(auto_ctx) {
		::fz_hash_filter(auto_ctx, table, state, callback);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_hash_find()`. */
FZ_FUNCTION void *hash_find(fz_hash_table *table, const void *key)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_hash_find():" << " auto_ctx=" << auto_ctx << " table=" << table << " key=" << (void*) key << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_hash_find(auto_ctx, table, key);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_hash_for_each()`. */
FZ_FUNCTION void hash_for_each(fz_hash_table *table, void *state, fz_hash_table_for_each_fn *callback)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_hash_for_each():" << " auto_ctx=" << auto_ctx << " table=" << table << " state=" << (void*) state << " callback=" << (void*) callback << "\n";
	}
	fz_try(auto_ctx) {
		::fz_hash_for_each(auto_ctx, table, state, callback);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_hash_insert()`. */
FZ_FUNCTION void *hash_insert(fz_hash_table *table, const void *key, void *val)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_hash_insert():" << " auto_ctx=" << auto_ctx << " table=" << table << " key=" << (void*) key << " val=" << (void*) val << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_hash_insert(auto_ctx, table, key, val);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_hash_remove()`. */
FZ_FUNCTION void hash_remove(fz_hash_table *table, const void *key)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_hash_remove():" << " auto_ctx=" << auto_ctx << " table=" << table << " key=" << (void*) key << "\n";
	}
	fz_try(auto_ctx) {
		::fz_hash_remove(auto_ctx, table, key);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_hb_lock()`. */
FZ_FUNCTION void hb_lock()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_hb_lock():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_try(auto_ctx) {
		::fz_hb_lock(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_hb_unlock()`. */
FZ_FUNCTION void hb_unlock()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_hb_unlock():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_try(auto_ctx) {
		::fz_hb_unlock(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_highlight_selection()`. */
FZ_FUNCTION int highlight_selection(fz_stext_page *page, fz_point a, fz_point b, fz_quad *quads, int max_quads)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_highlight_selection():" << " auto_ctx=" << auto_ctx << " page=" << page << " a=" << a << " b=" << b << " quads=" << quads << " max_quads=" << max_quads << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_highlight_selection(auto_ctx, page, a, b, quads, max_quads);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_ignore_text()`. */
FZ_FUNCTION void ignore_text(fz_device *dev, const fz_text *text, fz_matrix ctm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_ignore_text():" << " auto_ctx=" << auto_ctx << " dev=" << dev << " text=" << text << " ctm=" << ctm << "\n";
	}
	fz_try(auto_ctx) {
		::fz_ignore_text(auto_ctx, dev, text, ctm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_image_orientation()`. */
FZ_FUNCTION uint8_t image_orientation(fz_image *image)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_image_orientation():" << " auto_ctx=" << auto_ctx << " image=" << image << "\n";
	}
	uint8_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_image_orientation(auto_ctx, image);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_image_orientation_matrix()`. */
FZ_FUNCTION fz_matrix image_orientation_matrix(fz_image *image)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_image_orientation_matrix():" << " auto_ctx=" << auto_ctx << " image=" << image << "\n";
	}
	fz_matrix ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_image_orientation_matrix(auto_ctx, image);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_image_resolution()`.

This function has out-params. Python/C# wrappers look like:
	`image_resolution(fz_image *image)` => `(int xres, int yres)`
*/
FZ_FUNCTION void image_resolution(fz_image *image, int *xres, int *yres)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_image_resolution():" << " image=" << image << " xres=" << (void*) xres << " yres=" << (void*) yres << "\n";
	}
	fz_try(auto_ctx) {
		::fz_image_resolution(image, xres, yres);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_image_size()`. */
FZ_FUNCTION size_t image_size(fz_image *im)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_image_size():" << " auto_ctx=" << auto_ctx << " im=" << im << "\n";
	}
	size_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_image_size(auto_ctx, im);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_include_point_in_rect()`. */
FZ_FUNCTION fz_rect include_point_in_rect(fz_rect r, fz_point p)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_include_point_in_rect():" << " r=" << r << " p=" << p << "\n";
	}
	fz_rect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_include_point_in_rect(r, p);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_install_load_system_font_funcs()`. */
FZ_FUNCTION void install_load_system_font_funcs(fz_load_system_font_fn *f, fz_load_system_cjk_font_fn *f_cjk, fz_load_system_fallback_font_fn *f_fallback)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_install_load_system_font_funcs():" << " auto_ctx=" << auto_ctx << " f=" << (void*) f << " f_cjk=" << (void*) f_cjk << " f_fallback=" << (void*) f_fallback << "\n";
	}
	fz_try(auto_ctx) {
		::fz_install_load_system_font_funcs(auto_ctx, f, f_cjk, f_fallback);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_intersect_irect()`. */
FZ_FUNCTION fz_irect intersect_irect(fz_irect a, fz_irect b)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_intersect_irect():" << " a=" << a << " b=" << b << "\n";
	}
	fz_irect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_intersect_irect(a, b);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_intersect_rect()`. */
FZ_FUNCTION fz_rect intersect_rect(fz_rect a, fz_rect b)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_intersect_rect():" << " a=" << a << " b=" << b << "\n";
	}
	fz_rect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_intersect_rect(a, b);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_invert_matrix()`. */
FZ_FUNCTION fz_matrix invert_matrix(fz_matrix matrix)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_invert_matrix():" << " matrix=" << matrix << "\n";
	}
	fz_matrix ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_invert_matrix(matrix);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_invert_pixmap()`. */
FZ_FUNCTION void invert_pixmap(fz_pixmap *pix)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_invert_pixmap():" << " auto_ctx=" << auto_ctx << " pix=" << pix << "\n";
	}
	fz_try(auto_ctx) {
		::fz_invert_pixmap(auto_ctx, pix);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_invert_pixmap_alpha()`. */
FZ_FUNCTION void invert_pixmap_alpha(fz_pixmap *pix)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_invert_pixmap_alpha():" << " auto_ctx=" << auto_ctx << " pix=" << pix << "\n";
	}
	fz_try(auto_ctx) {
		::fz_invert_pixmap_alpha(auto_ctx, pix);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_invert_pixmap_luminance()`. */
FZ_FUNCTION void invert_pixmap_luminance(fz_pixmap *pix)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_invert_pixmap_luminance():" << " auto_ctx=" << auto_ctx << " pix=" << pix << "\n";
	}
	fz_try(auto_ctx) {
		::fz_invert_pixmap_luminance(auto_ctx, pix);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_invert_pixmap_rect()`. */
FZ_FUNCTION void invert_pixmap_rect(fz_pixmap *image, fz_irect rect)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_invert_pixmap_rect():" << " auto_ctx=" << auto_ctx << " image=" << image << " rect=" << rect << "\n";
	}
	fz_try(auto_ctx) {
		::fz_invert_pixmap_rect(auto_ctx, image, rect);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_irect_from_rect()`. */
FZ_FUNCTION fz_irect irect_from_rect(fz_rect rect)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_irect_from_rect():" << " rect=" << rect << "\n";
	}
	fz_irect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_irect_from_rect(rect);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_irect_height()`. */
FZ_FUNCTION int irect_height(fz_irect r)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_irect_height():" << " r=" << r << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_irect_height(r);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_irect_width()`. */
FZ_FUNCTION unsigned int irect_width(fz_irect r)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_irect_width():" << " r=" << r << "\n";
	}
	unsigned int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_irect_width(r);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_is_directory()`. */
FZ_FUNCTION int is_directory(const char *path)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_is_directory():" << " auto_ctx=" << auto_ctx << " path=" << path << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_is_directory(auto_ctx, path);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_is_document_reflowable()`. */
FZ_FUNCTION int is_document_reflowable(fz_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_is_document_reflowable():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_is_document_reflowable(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_is_empty_irect()`. */
FZ_FUNCTION int is_empty_irect(fz_irect r)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_is_empty_irect():" << " r=" << r << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_is_empty_irect(r);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_is_empty_rect()`. */
FZ_FUNCTION int is_empty_rect(fz_rect r)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_is_empty_rect():" << " r=" << r << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_is_empty_rect(r);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_is_eof()`. */
FZ_FUNCTION int is_eof(fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_is_eof():" << " auto_ctx=" << auto_ctx << " stm=" << stm << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_is_eof(auto_ctx, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_is_eof_bits()`. */
FZ_FUNCTION int is_eof_bits(fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_is_eof_bits():" << " auto_ctx=" << auto_ctx << " stm=" << stm << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_is_eof_bits(auto_ctx, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_is_external_link()`. */
FZ_FUNCTION int is_external_link(const char *uri)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_is_external_link():" << " auto_ctx=" << auto_ctx << " uri=" << uri << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_is_external_link(auto_ctx, uri);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_is_identity()`. */
FZ_FUNCTION int is_identity(fz_matrix m)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_is_identity():" << " m=" << m << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_is_identity(m);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_is_infinite_irect()`. */
FZ_FUNCTION int is_infinite_irect(fz_irect r)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_is_infinite_irect():" << " r=" << r << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_is_infinite_irect(r);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_is_infinite_rect()`. */
FZ_FUNCTION int is_infinite_rect(fz_rect r)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_is_infinite_rect():" << " r=" << r << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_is_infinite_rect(r);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_is_page_range()`. */
FZ_FUNCTION int is_page_range(const char *s)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_is_page_range():" << " auto_ctx=" << auto_ctx << " s=" << s << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_is_page_range(auto_ctx, s);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_is_pixmap_monochrome()`. */
FZ_FUNCTION int is_pixmap_monochrome(fz_pixmap *pixmap)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_is_pixmap_monochrome():" << " auto_ctx=" << auto_ctx << " pixmap=" << pixmap << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_is_pixmap_monochrome(auto_ctx, pixmap);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_is_point_inside_irect()`. */
FZ_FUNCTION int is_point_inside_irect(int x, int y, fz_irect r)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_is_point_inside_irect():" << " x=" << x << " y=" << y << " r=" << r << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_is_point_inside_irect(x, y, r);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_is_point_inside_quad()`. */
FZ_FUNCTION int is_point_inside_quad(fz_point p, fz_quad q)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_is_point_inside_quad():" << " p=" << p << " q=" << q << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_is_point_inside_quad(p, q);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_is_point_inside_rect()`. */
FZ_FUNCTION int is_point_inside_rect(fz_point p, fz_rect r)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_is_point_inside_rect():" << " p=" << p << " r=" << r << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_is_point_inside_rect(p, r);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_is_pow2()`. */
FZ_FUNCTION int is_pow2(int a)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_is_pow2():" << " a=" << a << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_is_pow2(a);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_is_quad_inside_quad()`. */
FZ_FUNCTION int is_quad_inside_quad(fz_quad needle, fz_quad haystack)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_is_quad_inside_quad():" << " needle=" << needle << " haystack=" << haystack << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_is_quad_inside_quad(needle, haystack);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_is_quad_intersecting_quad()`. */
FZ_FUNCTION int is_quad_intersecting_quad(fz_quad a, fz_quad b)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_is_quad_intersecting_quad():" << " a=" << a << " b=" << b << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_is_quad_intersecting_quad(a, b);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_is_rectilinear()`. */
FZ_FUNCTION int is_rectilinear(fz_matrix m)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_is_rectilinear():" << " m=" << m << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_is_rectilinear(m);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_is_tar_archive()`. */
FZ_FUNCTION int is_tar_archive(fz_stream *file)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_is_tar_archive():" << " auto_ctx=" << auto_ctx << " file=" << file << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_is_tar_archive(auto_ctx, file);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_is_valid_blend_colorspace()`. */
FZ_FUNCTION int is_valid_blend_colorspace(fz_colorspace *cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_is_valid_blend_colorspace():" << " auto_ctx=" << auto_ctx << " cs=" << cs << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_is_valid_blend_colorspace(auto_ctx, cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_is_valid_irect()`. */
FZ_FUNCTION int is_valid_irect(fz_irect r)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_is_valid_irect():" << " r=" << r << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_is_valid_irect(r);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_is_valid_rect()`. */
FZ_FUNCTION int is_valid_rect(fz_rect r)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_is_valid_rect():" << " r=" << r << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_is_valid_rect(r);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_is_zip_archive()`. */
FZ_FUNCTION int is_zip_archive(fz_stream *file)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_is_zip_archive():" << " auto_ctx=" << auto_ctx << " file=" << file << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_is_zip_archive(auto_ctx, file);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_iso8859_1_from_unicode()`. */
FZ_FUNCTION int iso8859_1_from_unicode(int u)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_iso8859_1_from_unicode():" << " u=" << u << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_iso8859_1_from_unicode(u);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_iso8859_7_from_unicode()`. */
FZ_FUNCTION int iso8859_7_from_unicode(int u)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_iso8859_7_from_unicode():" << " u=" << u << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_iso8859_7_from_unicode(u);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_jbig2_globals_data()`. */
FZ_FUNCTION fz_buffer *jbig2_globals_data(fz_jbig2_globals *globals)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_jbig2_globals_data():" << " auto_ctx=" << auto_ctx << " globals=" << globals << "\n";
	}
	fz_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_jbig2_globals_data(auto_ctx, globals);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_bitmap()`. */
FZ_FUNCTION fz_bitmap *keep_bitmap(fz_bitmap *bit)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_bitmap():" << " auto_ctx=" << auto_ctx << " bit=" << bit << "\n";
	}
	fz_bitmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_bitmap(auto_ctx, bit);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_buffer()`. */
FZ_FUNCTION fz_buffer *keep_buffer(fz_buffer *buf)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_buffer():" << " auto_ctx=" << auto_ctx << " buf=" << buf << "\n";
	}
	fz_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_buffer(auto_ctx, buf);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_colorspace()`. */
FZ_FUNCTION fz_colorspace *keep_colorspace(fz_colorspace *colorspace)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_colorspace():" << " auto_ctx=" << auto_ctx << " colorspace=" << colorspace << "\n";
	}
	fz_colorspace * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_colorspace(auto_ctx, colorspace);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_default_colorspaces()`. */
FZ_FUNCTION fz_default_colorspaces *keep_default_colorspaces(fz_default_colorspaces *default_cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_default_colorspaces():" << " auto_ctx=" << auto_ctx << " default_cs=" << default_cs << "\n";
	}
	fz_default_colorspaces * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_default_colorspaces(auto_ctx, default_cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_device()`. */
FZ_FUNCTION fz_device *keep_device(fz_device *dev)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_device():" << " auto_ctx=" << auto_ctx << " dev=" << dev << "\n";
	}
	fz_device * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_device(auto_ctx, dev);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_display_list()`. */
FZ_FUNCTION fz_display_list *keep_display_list(fz_display_list *list)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_display_list():" << " auto_ctx=" << auto_ctx << " list=" << list << "\n";
	}
	fz_display_list * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_display_list(auto_ctx, list);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_document()`. */
FZ_FUNCTION fz_document *keep_document(fz_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_document():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_document * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_document(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_font()`. */
FZ_FUNCTION fz_font *keep_font(fz_font *font)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_font():" << " auto_ctx=" << auto_ctx << " font=" << font << "\n";
	}
	fz_font * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_font(auto_ctx, font);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_glyph()`. */
FZ_FUNCTION fz_glyph *keep_glyph(fz_glyph *pix)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_glyph():" << " auto_ctx=" << auto_ctx << " pix=" << pix << "\n";
	}
	fz_glyph * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_glyph(auto_ctx, pix);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_halftone()`. */
FZ_FUNCTION fz_halftone *keep_halftone(fz_halftone *half)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_halftone():" << " auto_ctx=" << auto_ctx << " half=" << half << "\n";
	}
	fz_halftone * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_halftone(auto_ctx, half);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_image()`. */
FZ_FUNCTION fz_image *keep_image(fz_image *image)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_image():" << " auto_ctx=" << auto_ctx << " image=" << image << "\n";
	}
	fz_image * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_image(auto_ctx, image);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_image_store_key()`. */
FZ_FUNCTION fz_image *keep_image_store_key(fz_image *image)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_image_store_key():" << " auto_ctx=" << auto_ctx << " image=" << image << "\n";
	}
	fz_image * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_image_store_key(auto_ctx, image);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_imp()`.

This function has out-params. Python/C# wrappers look like:
	`keep_imp(void *p)` => `(void *, int refs)`
*/
FZ_FUNCTION void *keep_imp(void *p, int *refs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_imp():" << " auto_ctx=" << auto_ctx << " p=" << (void*) p << " refs=" << (void*) refs << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_imp(auto_ctx, p, refs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_imp16()`.

This function has out-params. Python/C# wrappers look like:
	`keep_imp16(void *p)` => `(void *, int16_t refs)`
*/
FZ_FUNCTION void *keep_imp16(void *p, int16_t *refs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_imp16():" << " auto_ctx=" << auto_ctx << " p=" << (void*) p << " refs=" << (void*) refs << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_imp16(auto_ctx, p, refs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_imp8()`. */
FZ_FUNCTION void *keep_imp8(void *p, int8_t *refs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_imp8():" << " auto_ctx=" << auto_ctx << " p=" << (void*) p << " refs=" << (void*) refs << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_imp8(auto_ctx, p, refs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_imp_locked()`.

This function has out-params. Python/C# wrappers look like:
	`keep_imp_locked(void *p)` => `(void *, int refs)`
*/
FZ_FUNCTION void *keep_imp_locked(void *p, int *refs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_imp_locked():" << " auto_ctx=" << auto_ctx << " p=" << (void*) p << " refs=" << (void*) refs << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_imp_locked(auto_ctx, p, refs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_jbig2_globals()`. */
FZ_FUNCTION fz_jbig2_globals *keep_jbig2_globals(fz_jbig2_globals *globals)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_jbig2_globals():" << " auto_ctx=" << auto_ctx << " globals=" << globals << "\n";
	}
	fz_jbig2_globals * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_jbig2_globals(auto_ctx, globals);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_key_storable()`. */
FZ_FUNCTION void *keep_key_storable(const fz_key_storable *arg_1)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_key_storable():" << " auto_ctx=" << auto_ctx << " arg_1=" << arg_1 << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_key_storable(auto_ctx, arg_1);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_key_storable_key()`. */
FZ_FUNCTION void *keep_key_storable_key(const fz_key_storable *arg_1)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_key_storable_key():" << " auto_ctx=" << auto_ctx << " arg_1=" << arg_1 << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_key_storable_key(auto_ctx, arg_1);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_link()`. */
FZ_FUNCTION fz_link *keep_link(fz_link *link)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_link():" << " auto_ctx=" << auto_ctx << " link=" << link << "\n";
	}
	fz_link * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_link(auto_ctx, link);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_outline()`. */
FZ_FUNCTION fz_outline *keep_outline(fz_outline *outline)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_outline():" << " auto_ctx=" << auto_ctx << " outline=" << outline << "\n";
	}
	fz_outline * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_outline(auto_ctx, outline);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_page()`. */
FZ_FUNCTION fz_page *keep_page(fz_page *page)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_page():" << " auto_ctx=" << auto_ctx << " page=" << page << "\n";
	}
	fz_page * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_page(auto_ctx, page);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_page_locked()`. */
FZ_FUNCTION fz_page *keep_page_locked(fz_page *page)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_page_locked():" << " auto_ctx=" << auto_ctx << " page=" << page << "\n";
	}
	fz_page * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_page_locked(auto_ctx, page);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_path()`. */
FZ_FUNCTION fz_path *keep_path(const fz_path *path)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_path():" << " auto_ctx=" << auto_ctx << " path=" << path << "\n";
	}
	fz_path * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_path(auto_ctx, path);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_pixmap()`. */
FZ_FUNCTION fz_pixmap *keep_pixmap(fz_pixmap *pix)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_pixmap():" << " auto_ctx=" << auto_ctx << " pix=" << pix << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_pixmap(auto_ctx, pix);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_separations()`. */
FZ_FUNCTION fz_separations *keep_separations(fz_separations *sep)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_separations():" << " auto_ctx=" << auto_ctx << " sep=" << sep << "\n";
	}
	fz_separations * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_separations(auto_ctx, sep);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_shade()`. */
FZ_FUNCTION fz_shade *keep_shade(fz_shade *shade)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_shade():" << " auto_ctx=" << auto_ctx << " shade=" << shade << "\n";
	}
	fz_shade * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_shade(auto_ctx, shade);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_storable()`. */
FZ_FUNCTION void *keep_storable(const fz_storable *arg_1)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_storable():" << " auto_ctx=" << auto_ctx << " arg_1=" << arg_1 << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_storable(auto_ctx, arg_1);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_store_context()`. */
FZ_FUNCTION fz_store *keep_store_context()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_store_context():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_store * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_store_context(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_stream()`. */
FZ_FUNCTION fz_stream *keep_stream(fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_stream():" << " auto_ctx=" << auto_ctx << " stm=" << stm << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_stream(auto_ctx, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_stroke_state()`. */
FZ_FUNCTION fz_stroke_state *keep_stroke_state(const fz_stroke_state *stroke)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_stroke_state():" << " auto_ctx=" << auto_ctx << " stroke=" << stroke << "\n";
	}
	fz_stroke_state * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_stroke_state(auto_ctx, stroke);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_keep_text()`. */
FZ_FUNCTION fz_text *keep_text(const fz_text *text)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_keep_text():" << " auto_ctx=" << auto_ctx << " text=" << text << "\n";
	}
	fz_text * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_keep_text(auto_ctx, text);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_koi8u_from_unicode()`. */
FZ_FUNCTION int koi8u_from_unicode(int u)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_koi8u_from_unicode():" << " u=" << u << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_koi8u_from_unicode(u);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_last_page()`. */
FZ_FUNCTION fz_location last_page(fz_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_last_page():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_location ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_last_page(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_layout_document()`. */
FZ_FUNCTION void layout_document(fz_document *doc, float w, float h, float em)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_layout_document():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " w=" << w << " h=" << h << " em=" << em << "\n";
	}
	fz_try(auto_ctx) {
		::fz_layout_document(auto_ctx, doc, w, h, em);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_lineto()`. */
FZ_FUNCTION void lineto(fz_path *path, float x, float y)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_lineto():" << " auto_ctx=" << auto_ctx << " path=" << path << " x=" << x << " y=" << y << "\n";
	}
	fz_try(auto_ctx) {
		::fz_lineto(auto_ctx, path, x, y);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_list_archive_entry()`. */
FZ_FUNCTION const char *list_archive_entry(fz_archive *arch, int idx)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_list_archive_entry():" << " auto_ctx=" << auto_ctx << " arch=" << arch << " idx=" << idx << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_list_archive_entry(auto_ctx, arch, idx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_load_bmp_subimage()`. */
FZ_FUNCTION fz_pixmap *load_bmp_subimage(const unsigned char *buf, size_t len, int subimage)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_load_bmp_subimage():" << " auto_ctx=" << auto_ctx << " buf=" << (void*) buf << " len=" << len << " subimage=" << subimage << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_load_bmp_subimage(auto_ctx, buf, len, subimage);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_load_bmp_subimage_count()`. */
FZ_FUNCTION int load_bmp_subimage_count(const unsigned char *buf, size_t len)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_load_bmp_subimage_count():" << " auto_ctx=" << auto_ctx << " buf=" << (void*) buf << " len=" << len << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_load_bmp_subimage_count(auto_ctx, buf, len);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_load_chapter_page()`. */
FZ_FUNCTION fz_page *load_chapter_page(fz_document *doc, int chapter, int page)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_load_chapter_page():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " chapter=" << chapter << " page=" << page << "\n";
	}
	fz_page * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_load_chapter_page(auto_ctx, doc, chapter, page);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_load_fallback_font()`. */
FZ_FUNCTION fz_font *load_fallback_font(int script, int language, int serif, int bold, int italic)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_load_fallback_font():" << " auto_ctx=" << auto_ctx << " script=" << script << " language=" << language << " serif=" << serif << " bold=" << bold << " italic=" << italic << "\n";
	}
	fz_font * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_load_fallback_font(auto_ctx, script, language, serif, bold, italic);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_load_jbig2_globals()`. */
FZ_FUNCTION fz_jbig2_globals *load_jbig2_globals(fz_buffer *buf)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_load_jbig2_globals():" << " auto_ctx=" << auto_ctx << " buf=" << buf << "\n";
	}
	fz_jbig2_globals * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_load_jbig2_globals(auto_ctx, buf);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_load_jbig2_subimage()`. */
FZ_FUNCTION fz_pixmap *load_jbig2_subimage(const unsigned char *buf, size_t len, int subimage)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_load_jbig2_subimage():" << " auto_ctx=" << auto_ctx << " buf=" << (void*) buf << " len=" << len << " subimage=" << subimage << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_load_jbig2_subimage(auto_ctx, buf, len, subimage);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_load_jbig2_subimage_count()`. */
FZ_FUNCTION int load_jbig2_subimage_count(const unsigned char *buf, size_t len)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_load_jbig2_subimage_count():" << " auto_ctx=" << auto_ctx << " buf=" << (void*) buf << " len=" << len << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_load_jbig2_subimage_count(auto_ctx, buf, len);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_load_jpx()`. */
FZ_FUNCTION fz_pixmap *load_jpx(const unsigned char *data, size_t size, fz_colorspace *cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_load_jpx():" << " auto_ctx=" << auto_ctx << " data=" << (void*) data << " size=" << size << " cs=" << cs << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_load_jpx(auto_ctx, data, size, cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_load_links()`. */
FZ_FUNCTION fz_link *load_links(fz_page *page)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_load_links():" << " auto_ctx=" << auto_ctx << " page=" << page << "\n";
	}
	fz_link * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_load_links(auto_ctx, page);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_load_outline()`. */
FZ_FUNCTION fz_outline *load_outline(fz_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_load_outline():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_outline * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_load_outline(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_load_outline_from_iterator()`. */
FZ_FUNCTION fz_outline *load_outline_from_iterator(fz_outline_iterator *iter)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_load_outline_from_iterator():" << " auto_ctx=" << auto_ctx << " iter=" << iter << "\n";
	}
	fz_outline * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_load_outline_from_iterator(auto_ctx, iter);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_load_page()`. */
FZ_FUNCTION fz_page *load_page(fz_document *doc, int number)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_load_page():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " number=" << number << "\n";
	}
	fz_page * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_load_page(auto_ctx, doc, number);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_load_pnm_subimage()`. */
FZ_FUNCTION fz_pixmap *load_pnm_subimage(const unsigned char *buf, size_t len, int subimage)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_load_pnm_subimage():" << " auto_ctx=" << auto_ctx << " buf=" << (void*) buf << " len=" << len << " subimage=" << subimage << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_load_pnm_subimage(auto_ctx, buf, len, subimage);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_load_pnm_subimage_count()`. */
FZ_FUNCTION int load_pnm_subimage_count(const unsigned char *buf, size_t len)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_load_pnm_subimage_count():" << " auto_ctx=" << auto_ctx << " buf=" << (void*) buf << " len=" << len << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_load_pnm_subimage_count(auto_ctx, buf, len);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_load_system_cjk_font()`. */
FZ_FUNCTION fz_font *load_system_cjk_font(const char *name, int ordering, int serif)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_load_system_cjk_font():" << " auto_ctx=" << auto_ctx << " name=" << name << " ordering=" << ordering << " serif=" << serif << "\n";
	}
	fz_font * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_load_system_cjk_font(auto_ctx, name, ordering, serif);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_load_system_font()`. */
FZ_FUNCTION fz_font *load_system_font(const char *name, int bold, int italic, int needs_exact_metrics)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_load_system_font():" << " auto_ctx=" << auto_ctx << " name=" << name << " bold=" << bold << " italic=" << italic << " needs_exact_metrics=" << needs_exact_metrics << "\n";
	}
	fz_font * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_load_system_font(auto_ctx, name, bold, italic, needs_exact_metrics);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_load_tiff_subimage()`. */
FZ_FUNCTION fz_pixmap *load_tiff_subimage(const unsigned char *buf, size_t len, int subimage)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_load_tiff_subimage():" << " auto_ctx=" << auto_ctx << " buf=" << (void*) buf << " len=" << len << " subimage=" << subimage << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_load_tiff_subimage(auto_ctx, buf, len, subimage);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_load_tiff_subimage_count()`. */
FZ_FUNCTION int load_tiff_subimage_count(const unsigned char *buf, size_t len)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_load_tiff_subimage_count():" << " auto_ctx=" << auto_ctx << " buf=" << (void*) buf << " len=" << len << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_load_tiff_subimage_count(auto_ctx, buf, len);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_location_from_page_number()`. */
FZ_FUNCTION fz_location location_from_page_number(fz_document *doc, int number)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_location_from_page_number():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " number=" << number << "\n";
	}
	fz_location ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_location_from_page_number(auto_ctx, doc, number);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_lock()`. */
FZ_FUNCTION void lock(int lock)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_lock():" << " auto_ctx=" << auto_ctx << " lock=" << lock << "\n";
	}
	fz_try(auto_ctx) {
		::fz_lock(auto_ctx, lock);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_lookup_base14_font()`.

This function has out-params. Python/C# wrappers look like:
	`lookup_base14_font(const char *name)` => `(const unsigned char *, int len)`
*/
FZ_FUNCTION const unsigned char *lookup_base14_font(const char *name, int *len)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_lookup_base14_font():" << " auto_ctx=" << auto_ctx << " name=" << name << " len=" << (void*) len << "\n";
	}
	const unsigned char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_lookup_base14_font(auto_ctx, name, len);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_lookup_blendmode()`. */
FZ_FUNCTION int lookup_blendmode(const char *name)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_lookup_blendmode():" << " name=" << name << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_lookup_blendmode(name);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_lookup_bookmark()`. */
FZ_FUNCTION fz_location lookup_bookmark(fz_document *doc, fz_bookmark mark)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_lookup_bookmark():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " mark=" << mark << "\n";
	}
	fz_location ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_lookup_bookmark(auto_ctx, doc, mark);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_lookup_builtin_font()`.

This function has out-params. Python/C# wrappers look like:
	`lookup_builtin_font(const char *name, int bold, int italic)` => `(const unsigned char *, int len)`
*/
FZ_FUNCTION const unsigned char *lookup_builtin_font(const char *name, int bold, int italic, int *len)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_lookup_builtin_font():" << " auto_ctx=" << auto_ctx << " name=" << name << " bold=" << bold << " italic=" << italic << " len=" << (void*) len << "\n";
	}
	const unsigned char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_lookup_builtin_font(auto_ctx, name, bold, italic, len);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_lookup_cjk_font()`.

This function has out-params. Python/C# wrappers look like:
	`lookup_cjk_font(int ordering)` => `(const unsigned char *, int len, int index)`
*/
FZ_FUNCTION const unsigned char *lookup_cjk_font(int ordering, int *len, int *index)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_lookup_cjk_font():" << " auto_ctx=" << auto_ctx << " ordering=" << ordering << " len=" << (void*) len << " index=" << (void*) index << "\n";
	}
	const unsigned char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_lookup_cjk_font(auto_ctx, ordering, len, index);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_lookup_cjk_font_by_language()`.

This function has out-params. Python/C# wrappers look like:
	`lookup_cjk_font_by_language(const char *lang)` => `(const unsigned char *, int len, int subfont)`
*/
FZ_FUNCTION const unsigned char *lookup_cjk_font_by_language(const char *lang, int *len, int *subfont)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_lookup_cjk_font_by_language():" << " auto_ctx=" << auto_ctx << " lang=" << lang << " len=" << (void*) len << " subfont=" << (void*) subfont << "\n";
	}
	const unsigned char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_lookup_cjk_font_by_language(auto_ctx, lang, len, subfont);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_lookup_cjk_ordering_by_language()`. */
FZ_FUNCTION int lookup_cjk_ordering_by_language(const char *name)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_lookup_cjk_ordering_by_language():" << " name=" << name << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_lookup_cjk_ordering_by_language(name);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_lookup_metadata()`. */
FZ_FUNCTION int lookup_metadata(fz_document *doc, const char *key, char *buf, int size)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_lookup_metadata():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " key=" << key << " buf=" << (void*) buf << " size=" << size << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_lookup_metadata(auto_ctx, doc, key, buf, size);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}


FZ_FUNCTION std::string lookup_metadata(fz_document *doc, const char *key, int* o_out)
{
	/* Find length first. */
	int e = lookup_metadata(doc, key, NULL /*buf*/, 0 /*size*/);
	if (e < 0) {
		// Not found.
		if (o_out)  *o_out = e;
		return "";
	}
	assert(e != 0);
	char* buf = (char*) malloc(e);
	assert(buf);    // mupdf::malloc() throws on error.
	int e2 = lookup_metadata(doc, key, buf, e);
	assert(e2 = e);
	std::string ret = buf;
	free(buf);
	if (o_out)  *o_out = e;
	return ret;
}
/** Wrapper for `fz_lookup_noto_emoji_font()`.

This function has out-params. Python/C# wrappers look like:
	`lookup_noto_emoji_font()` => `(const unsigned char *, int len)`
*/
FZ_FUNCTION const unsigned char *lookup_noto_emoji_font(int *len)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_lookup_noto_emoji_font():" << " auto_ctx=" << auto_ctx << " len=" << (void*) len << "\n";
	}
	const unsigned char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_lookup_noto_emoji_font(auto_ctx, len);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_lookup_noto_font()`.

This function has out-params. Python/C# wrappers look like:
	`lookup_noto_font(int script, int lang)` => `(const unsigned char *, int len, int subfont)`
*/
FZ_FUNCTION const unsigned char *lookup_noto_font(int script, int lang, int *len, int *subfont)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_lookup_noto_font():" << " auto_ctx=" << auto_ctx << " script=" << script << " lang=" << lang << " len=" << (void*) len << " subfont=" << (void*) subfont << "\n";
	}
	const unsigned char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_lookup_noto_font(auto_ctx, script, lang, len, subfont);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_lookup_noto_math_font()`.

This function has out-params. Python/C# wrappers look like:
	`lookup_noto_math_font()` => `(const unsigned char *, int len)`
*/
FZ_FUNCTION const unsigned char *lookup_noto_math_font(int *len)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_lookup_noto_math_font():" << " auto_ctx=" << auto_ctx << " len=" << (void*) len << "\n";
	}
	const unsigned char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_lookup_noto_math_font(auto_ctx, len);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_lookup_noto_music_font()`.

This function has out-params. Python/C# wrappers look like:
	`lookup_noto_music_font()` => `(const unsigned char *, int len)`
*/
FZ_FUNCTION const unsigned char *lookup_noto_music_font(int *len)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_lookup_noto_music_font():" << " auto_ctx=" << auto_ctx << " len=" << (void*) len << "\n";
	}
	const unsigned char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_lookup_noto_music_font(auto_ctx, len);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_lookup_noto_symbol1_font()`.

This function has out-params. Python/C# wrappers look like:
	`lookup_noto_symbol1_font()` => `(const unsigned char *, int len)`
*/
FZ_FUNCTION const unsigned char *lookup_noto_symbol1_font(int *len)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_lookup_noto_symbol1_font():" << " auto_ctx=" << auto_ctx << " len=" << (void*) len << "\n";
	}
	const unsigned char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_lookup_noto_symbol1_font(auto_ctx, len);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_lookup_noto_symbol2_font()`.

This function has out-params. Python/C# wrappers look like:
	`lookup_noto_symbol2_font()` => `(const unsigned char *, int len)`
*/
FZ_FUNCTION const unsigned char *lookup_noto_symbol2_font(int *len)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_lookup_noto_symbol2_font():" << " auto_ctx=" << auto_ctx << " len=" << (void*) len << "\n";
	}
	const unsigned char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_lookup_noto_symbol2_font(auto_ctx, len);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_lookup_rendering_intent()`. */
FZ_FUNCTION int lookup_rendering_intent(const char *name)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_lookup_rendering_intent():" << " name=" << name << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_lookup_rendering_intent(name);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_make_bookmark()`. */
FZ_FUNCTION fz_bookmark make_bookmark(fz_document *doc, fz_location loc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_make_bookmark():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " loc=" << loc << "\n";
	}
	fz_bookmark ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_make_bookmark(auto_ctx, doc, loc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_make_irect()`. */
FZ_FUNCTION fz_irect make_irect(int x0, int y0, int x1, int y1)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_make_irect():" << " x0=" << x0 << " y0=" << y0 << " x1=" << x1 << " y1=" << y1 << "\n";
	}
	fz_irect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_make_irect(x0, y0, x1, y1);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_make_link_dest_none()`. */
FZ_FUNCTION fz_link_dest make_link_dest_none()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_make_link_dest_none():" << "\n";
	}
	fz_link_dest ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_make_link_dest_none();
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_make_link_dest_xyz()`. */
FZ_FUNCTION fz_link_dest make_link_dest_xyz(int chapter, int page, float x, float y, float z)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_make_link_dest_xyz():" << " chapter=" << chapter << " page=" << page << " x=" << x << " y=" << y << " z=" << z << "\n";
	}
	fz_link_dest ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_make_link_dest_xyz(chapter, page, x, y, z);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_make_location()`. */
FZ_FUNCTION fz_location make_location(int chapter, int page)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_make_location():" << " chapter=" << chapter << " page=" << page << "\n";
	}
	fz_location ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_make_location(chapter, page);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_make_matrix()`. */
FZ_FUNCTION fz_matrix make_matrix(float a, float b, float c, float d, float e, float f)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_make_matrix():" << " a=" << a << " b=" << b << " c=" << c << " d=" << d << " e=" << e << " f=" << f << "\n";
	}
	fz_matrix ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_make_matrix(a, b, c, d, e, f);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_make_point()`. */
FZ_FUNCTION fz_point make_point(float x, float y)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_make_point():" << " x=" << x << " y=" << y << "\n";
	}
	fz_point ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_make_point(x, y);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_make_quad()`. */
FZ_FUNCTION fz_quad make_quad(float ul_x, float ul_y, float ur_x, float ur_y, float ll_x, float ll_y, float lr_x, float lr_y)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_make_quad():" << " ul_x=" << ul_x << " ul_y=" << ul_y << " ur_x=" << ur_x << " ur_y=" << ur_y << " ll_x=" << ll_x << " ll_y=" << ll_y << " lr_x=" << lr_x << " lr_y=" << lr_y << "\n";
	}
	fz_quad ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_make_quad(ul_x, ul_y, ur_x, ur_y, ll_x, ll_y, lr_x, lr_y);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_make_rect()`. */
FZ_FUNCTION fz_rect make_rect(float x0, float y0, float x1, float y1)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_make_rect():" << " x0=" << x0 << " y0=" << y0 << " x1=" << x1 << " y1=" << y1 << "\n";
	}
	fz_rect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_make_rect(x0, y0, x1, y1);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_malloc()`. */
FZ_FUNCTION void *malloc(size_t size)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_malloc():" << " auto_ctx=" << auto_ctx << " size=" << size << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_malloc(auto_ctx, size);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_malloc_no_throw()`. */
FZ_FUNCTION void *malloc_no_throw(size_t size)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_malloc_no_throw():" << " auto_ctx=" << auto_ctx << " size=" << size << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_malloc_no_throw(auto_ctx, size);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_matrix_expansion()`. */
FZ_FUNCTION float matrix_expansion(fz_matrix m)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_matrix_expansion():" << " m=" << m << "\n";
	}
	float ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_matrix_expansion(m);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_matrix_max_expansion()`. */
FZ_FUNCTION float matrix_max_expansion(fz_matrix m)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_matrix_max_expansion():" << " m=" << m << "\n";
	}
	float ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_matrix_max_expansion(m);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_max()`. */
FZ_FUNCTION float max(float a, float b)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_max():" << " a=" << a << " b=" << b << "\n";
	}
	float ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_max(a, b);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_maxi()`. */
FZ_FUNCTION int maxi(int a, int b)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_maxi():" << " a=" << a << " b=" << b << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_maxi(a, b);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_maxi64()`. */
FZ_FUNCTION int64_t maxi64(int64_t a, int64_t b)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_maxi64():" << " a=" << a << " b=" << b << "\n";
	}
	int64_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_maxi64(a, b);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_maxz()`. */
FZ_FUNCTION size_t maxz(size_t a, size_t b)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_maxz():" << " a=" << a << " b=" << b << "\n";
	}
	size_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_maxz(a, b);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_md5_buffer()`. */
FZ_FUNCTION void md5_buffer(fz_buffer *buffer, unsigned char digest[16])
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_md5_buffer():" << " auto_ctx=" << auto_ctx << " buffer=" << buffer << " digest=" << digest << "\n";
	}
	fz_try(auto_ctx) {
		::fz_md5_buffer(auto_ctx, buffer, digest);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_md5_final()`. */
FZ_FUNCTION void md5_final(fz_md5 *state, unsigned char digest[16])
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_md5_final():" << " state=" << state << " digest=" << digest << "\n";
	}
	fz_try(auto_ctx) {
		::fz_md5_final(state, digest);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_md5_init()`. */
FZ_FUNCTION void md5_init(fz_md5 *state)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_md5_init():" << " state=" << state << "\n";
	}
	fz_try(auto_ctx) {
		::fz_md5_init(state);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_md5_pixmap()`. */
FZ_FUNCTION void md5_pixmap(fz_pixmap *pixmap, unsigned char digest[16])
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_md5_pixmap():" << " auto_ctx=" << auto_ctx << " pixmap=" << pixmap << " digest=" << digest << "\n";
	}
	fz_try(auto_ctx) {
		::fz_md5_pixmap(auto_ctx, pixmap, digest);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_md5_update()`. */
FZ_FUNCTION void md5_update(fz_md5 *state, const unsigned char *input, size_t inlen)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_md5_update():" << " state=" << state << " input=" << (void*) input << " inlen=" << inlen << "\n";
	}
	fz_try(auto_ctx) {
		::fz_md5_update(state, input, inlen);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_md5_update_int64()`. */
FZ_FUNCTION void md5_update_int64(fz_md5 *state, int64_t i)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_md5_update_int64():" << " state=" << state << " i=" << i << "\n";
	}
	fz_try(auto_ctx) {
		::fz_md5_update_int64(state, i);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_measure_string()`. */
FZ_FUNCTION fz_matrix measure_string(fz_font *user_font, fz_matrix trm, const char *s, int wmode, int bidi_level, fz_bidi_direction markup_dir, fz_text_language language)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_measure_string():" << " auto_ctx=" << auto_ctx << " user_font=" << user_font << " trm=" << trm << " s=" << s << " wmode=" << wmode << " bidi_level=" << bidi_level << " markup_dir=" << markup_dir << " language=" << language << "\n";
	}
	fz_matrix ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_measure_string(auto_ctx, user_font, trm, s, wmode, bidi_level, markup_dir, language);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_memmem()`. */
FZ_FUNCTION void *memmem(const void *haystack, size_t haystacklen, const void *needle, size_t needlelen)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_memmem():" << " haystack=" << (void*) haystack << " haystacklen=" << haystacklen << " needle=" << (void*) needle << " needlelen=" << needlelen << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_memmem(haystack, haystacklen, needle, needlelen);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_memrnd()`. */
FZ_FUNCTION void memrnd(uint8_t *block, int len)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_memrnd():" << " auto_ctx=" << auto_ctx << " block=" << (void*) block << " len=" << len << "\n";
	}
	fz_try(auto_ctx) {
		::fz_memrnd(auto_ctx, block, len);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_min()`. */
FZ_FUNCTION float min(float a, float b)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_min():" << " a=" << a << " b=" << b << "\n";
	}
	float ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_min(a, b);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_mini()`. */
FZ_FUNCTION int mini(int a, int b)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_mini():" << " a=" << a << " b=" << b << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_mini(a, b);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_mini64()`. */
FZ_FUNCTION int64_t mini64(int64_t a, int64_t b)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_mini64():" << " a=" << a << " b=" << b << "\n";
	}
	int64_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_mini64(a, b);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_minz()`. */
FZ_FUNCTION size_t minz(size_t a, size_t b)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_minz():" << " a=" << a << " b=" << b << "\n";
	}
	size_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_minz(a, b);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_moveto()`. */
FZ_FUNCTION void moveto(fz_path *path, float x, float y)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_moveto():" << " auto_ctx=" << auto_ctx << " path=" << path << " x=" << x << " y=" << y << "\n";
	}
	fz_try(auto_ctx) {
		::fz_moveto(auto_ctx, path, x, y);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_mul255()`. */
FZ_FUNCTION int mul255(int a, int b)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_mul255():" << " a=" << a << " b=" << b << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_mul255(a, b);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_needs_password()`. */
FZ_FUNCTION int needs_password(fz_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_needs_password():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_needs_password(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_arc4_output()`. */
FZ_FUNCTION fz_output *new_arc4_output(fz_output *chain, unsigned char *key, size_t keylen)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_arc4_output():" << " auto_ctx=" << auto_ctx << " chain=" << chain << " key=" << (void*) key << " keylen=" << keylen << "\n";
	}
	fz_output * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_arc4_output(auto_ctx, chain, key, keylen);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_archive_of_size()`. */
FZ_FUNCTION fz_archive *new_archive_of_size(fz_stream *file, int size)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_archive_of_size():" << " auto_ctx=" << auto_ctx << " file=" << file << " size=" << size << "\n";
	}
	fz_archive * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_archive_of_size(auto_ctx, file, size);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_ascii85_output()`. */
FZ_FUNCTION fz_output *new_ascii85_output(fz_output *chain)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_ascii85_output():" << " auto_ctx=" << auto_ctx << " chain=" << chain << "\n";
	}
	fz_output * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_ascii85_output(auto_ctx, chain);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_asciihex_output()`. */
FZ_FUNCTION fz_output *new_asciihex_output(fz_output *chain)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_asciihex_output():" << " auto_ctx=" << auto_ctx << " chain=" << chain << "\n";
	}
	fz_output * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_asciihex_output(auto_ctx, chain);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_band_writer_of_size()`. */
FZ_FUNCTION fz_band_writer *new_band_writer_of_size(size_t size, fz_output *out)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_band_writer_of_size():" << " auto_ctx=" << auto_ctx << " size=" << size << " out=" << out << "\n";
	}
	fz_band_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_band_writer_of_size(auto_ctx, size, out);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_base14_font()`. */
FZ_FUNCTION fz_font *new_base14_font(const char *name)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_base14_font():" << " auto_ctx=" << auto_ctx << " name=" << name << "\n";
	}
	fz_font * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_base14_font(auto_ctx, name);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_bbox_device()`. */
FZ_FUNCTION fz_device *new_bbox_device(fz_rect *rectp)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_bbox_device():" << " auto_ctx=" << auto_ctx << " rectp=" << rectp << "\n";
	}
	fz_device * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_bbox_device(auto_ctx, rectp);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_bitmap()`. */
FZ_FUNCTION fz_bitmap *new_bitmap(int w, int h, int n, int xres, int yres)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_bitmap():" << " auto_ctx=" << auto_ctx << " w=" << w << " h=" << h << " n=" << n << " xres=" << xres << " yres=" << yres << "\n";
	}
	fz_bitmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_bitmap(auto_ctx, w, h, n, xres, yres);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_bitmap_from_pixmap()`. */
FZ_FUNCTION fz_bitmap *new_bitmap_from_pixmap(fz_pixmap *pix, fz_halftone *ht)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_bitmap_from_pixmap():" << " auto_ctx=" << auto_ctx << " pix=" << pix << " ht=" << ht << "\n";
	}
	fz_bitmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_bitmap_from_pixmap(auto_ctx, pix, ht);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_bitmap_from_pixmap_band()`. */
FZ_FUNCTION fz_bitmap *new_bitmap_from_pixmap_band(fz_pixmap *pix, fz_halftone *ht, int band_start)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_bitmap_from_pixmap_band():" << " auto_ctx=" << auto_ctx << " pix=" << pix << " ht=" << ht << " band_start=" << band_start << "\n";
	}
	fz_bitmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_bitmap_from_pixmap_band(auto_ctx, pix, ht, band_start);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_buffer()`. */
FZ_FUNCTION fz_buffer *new_buffer(size_t capacity)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_buffer():" << " auto_ctx=" << auto_ctx << " capacity=" << capacity << "\n";
	}
	fz_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_buffer(auto_ctx, capacity);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_buffer_from_base64()`. */
FZ_FUNCTION fz_buffer *new_buffer_from_base64(const char *data, size_t size)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_buffer_from_base64():" << " auto_ctx=" << auto_ctx << " data=" << data << " size=" << size << "\n";
	}
	fz_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_buffer_from_base64(auto_ctx, data, size);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_buffer_from_copied_data()`. */
FZ_FUNCTION fz_buffer *new_buffer_from_copied_data(const unsigned char *data, size_t size)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_buffer_from_copied_data():" << " auto_ctx=" << auto_ctx << " data=" << (void*) data << " size=" << size << "\n";
	}
	fz_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_buffer_from_copied_data(auto_ctx, data, size);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_buffer_from_data()`. */
FZ_FUNCTION fz_buffer *new_buffer_from_data(unsigned char *data, size_t size)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_buffer_from_data():" << " auto_ctx=" << auto_ctx << " data=" << (void*) data << " size=" << size << "\n";
	}
	fz_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_buffer_from_data(auto_ctx, data, size);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_buffer_from_display_list()`. */
FZ_FUNCTION fz_buffer *new_buffer_from_display_list(fz_display_list *list, const fz_stext_options *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_buffer_from_display_list():" << " auto_ctx=" << auto_ctx << " list=" << list << " options=" << options << "\n";
	}
	fz_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_buffer_from_display_list(auto_ctx, list, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_buffer_from_image_as_png()`. */
FZ_FUNCTION fz_buffer *new_buffer_from_image_as_png(fz_image *image, fz_color_params color_params)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_buffer_from_image_as_png():" << " auto_ctx=" << auto_ctx << " image=" << image << " color_params=" << color_params << "\n";
	}
	fz_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_buffer_from_image_as_png(auto_ctx, image, color_params);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_buffer_from_page()`. */
FZ_FUNCTION fz_buffer *new_buffer_from_page(fz_page *page, const fz_stext_options *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_buffer_from_page():" << " auto_ctx=" << auto_ctx << " page=" << page << " options=" << options << "\n";
	}
	fz_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_buffer_from_page(auto_ctx, page, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_buffer_from_page_number()`. */
FZ_FUNCTION fz_buffer *new_buffer_from_page_number(fz_document *doc, int number, const fz_stext_options *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_buffer_from_page_number():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " number=" << number << " options=" << options << "\n";
	}
	fz_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_buffer_from_page_number(auto_ctx, doc, number, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_buffer_from_page_with_format()`. */
FZ_FUNCTION fz_buffer *new_buffer_from_page_with_format(fz_page *page, const char *format, const char *options, fz_matrix transform, fz_cookie *cookie)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_buffer_from_page_with_format():" << " auto_ctx=" << auto_ctx << " page=" << page << " format=" << format << " options=" << options << " transform=" << transform << " cookie=" << cookie << "\n";
	}
	fz_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_buffer_from_page_with_format(auto_ctx, page, format, options, transform, cookie);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_buffer_from_pixmap_as_png()`. */
FZ_FUNCTION fz_buffer *new_buffer_from_pixmap_as_png(fz_pixmap *pixmap, fz_color_params color_params)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_buffer_from_pixmap_as_png():" << " auto_ctx=" << auto_ctx << " pixmap=" << pixmap << " color_params=" << color_params << "\n";
	}
	fz_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_buffer_from_pixmap_as_png(auto_ctx, pixmap, color_params);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_buffer_from_shared_data()`. */
FZ_FUNCTION fz_buffer *new_buffer_from_shared_data(const unsigned char *data, size_t size)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_buffer_from_shared_data():" << " auto_ctx=" << auto_ctx << " data=" << (void*) data << " size=" << size << "\n";
	}
	fz_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_buffer_from_shared_data(auto_ctx, data, size);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_buffer_from_stext_page()`. */
FZ_FUNCTION fz_buffer *new_buffer_from_stext_page(fz_stext_page *text)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_buffer_from_stext_page():" << " auto_ctx=" << auto_ctx << " text=" << text << "\n";
	}
	fz_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_buffer_from_stext_page(auto_ctx, text);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_builtin_font()`. */
FZ_FUNCTION fz_font *new_builtin_font(const char *name, int is_bold, int is_italic)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_builtin_font():" << " auto_ctx=" << auto_ctx << " name=" << name << " is_bold=" << is_bold << " is_italic=" << is_italic << "\n";
	}
	fz_font * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_builtin_font(auto_ctx, name, is_bold, is_italic);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_cal_gray_colorspace()`. */
FZ_FUNCTION fz_colorspace *new_cal_gray_colorspace(float wp[3], float bp[3], float gamma)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_cal_gray_colorspace():" << " auto_ctx=" << auto_ctx << " wp=" << wp << " bp=" << bp << " gamma=" << gamma << "\n";
	}
	fz_colorspace * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_cal_gray_colorspace(auto_ctx, wp, bp, gamma);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_cal_rgb_colorspace()`. */
FZ_FUNCTION fz_colorspace *new_cal_rgb_colorspace(float wp[3], float bp[3], float gamma[3], float matrix[9])
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_cal_rgb_colorspace():" << " auto_ctx=" << auto_ctx << " wp=" << wp << " bp=" << bp << " gamma=" << gamma << " matrix=" << matrix << "\n";
	}
	fz_colorspace * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_cal_rgb_colorspace(auto_ctx, wp, bp, gamma, matrix);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_cbz_writer()`. */
FZ_FUNCTION fz_document_writer *new_cbz_writer(const char *path, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_cbz_writer():" << " auto_ctx=" << auto_ctx << " path=" << path << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_cbz_writer(auto_ctx, path, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_cbz_writer_with_output()`. */
FZ_FUNCTION fz_document_writer *new_cbz_writer_with_output(fz_output *out, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_cbz_writer_with_output():" << " auto_ctx=" << auto_ctx << " out=" << out << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_cbz_writer_with_output(auto_ctx, out, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_cjk_font()`. */
FZ_FUNCTION fz_font *new_cjk_font(int ordering)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_cjk_font():" << " auto_ctx=" << auto_ctx << " ordering=" << ordering << "\n";
	}
	fz_font * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_cjk_font(auto_ctx, ordering);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_color_pcl_band_writer()`. */
FZ_FUNCTION fz_band_writer *new_color_pcl_band_writer(fz_output *out, const fz_pcl_options *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_color_pcl_band_writer():" << " auto_ctx=" << auto_ctx << " out=" << out << " options=" << options << "\n";
	}
	fz_band_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_color_pcl_band_writer(auto_ctx, out, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_colorspace()`. */
FZ_FUNCTION fz_colorspace *new_colorspace(enum fz_colorspace_type type, int flags, int n, const char *name)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_colorspace():" << " auto_ctx=" << auto_ctx << " type=" << type << " flags=" << flags << " n=" << n << " name=" << name << "\n";
	}
	fz_colorspace * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_colorspace(auto_ctx, type, flags, n, name);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_context_imp()`. */
FZ_FUNCTION fz_context *new_context_imp(const fz_alloc_context *alloc, const fz_locks_context *locks, size_t max_store, const char *version)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_context_imp():" << " alloc=" << alloc << " locks=" << locks << " max_store=" << max_store << " version=" << version << "\n";
	}
	fz_context * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_context_imp(alloc, locks, max_store, version);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_default_colorspaces()`. */
FZ_FUNCTION fz_default_colorspaces *new_default_colorspaces()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_default_colorspaces():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_default_colorspaces * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_default_colorspaces(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_deflate_output()`. */
FZ_FUNCTION fz_output *new_deflate_output(fz_output *chain, int effort, int raw)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_deflate_output():" << " auto_ctx=" << auto_ctx << " chain=" << chain << " effort=" << effort << " raw=" << raw << "\n";
	}
	fz_output * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_deflate_output(auto_ctx, chain, effort, raw);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_deflated_data()`.

This function has out-params. Python/C# wrappers look like:
	`new_deflated_data(const unsigned char *source, size_t source_length, fz_deflate_level level)` => `(unsigned char *, size_t compressed_length)`
*/
FZ_FUNCTION unsigned char *new_deflated_data(size_t *compressed_length, const unsigned char *source, size_t source_length, fz_deflate_level level)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_deflated_data():" << " auto_ctx=" << auto_ctx << " compressed_length=" << (void*) compressed_length << " source=" << (void*) source << " source_length=" << source_length << " level=" << level << "\n";
	}
	unsigned char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_deflated_data(auto_ctx, compressed_length, source, source_length, level);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_deflated_data_from_buffer()`.

This function has out-params. Python/C# wrappers look like:
	`new_deflated_data_from_buffer(fz_buffer *buffer, fz_deflate_level level)` => `(unsigned char *, size_t compressed_length)`
*/
FZ_FUNCTION unsigned char *new_deflated_data_from_buffer(size_t *compressed_length, fz_buffer *buffer, fz_deflate_level level)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_deflated_data_from_buffer():" << " auto_ctx=" << auto_ctx << " compressed_length=" << (void*) compressed_length << " buffer=" << buffer << " level=" << level << "\n";
	}
	unsigned char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_deflated_data_from_buffer(auto_ctx, compressed_length, buffer, level);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_device_of_size()`. */
FZ_FUNCTION fz_device *new_device_of_size(int size)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_device_of_size():" << " auto_ctx=" << auto_ctx << " size=" << size << "\n";
	}
	fz_device * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_device_of_size(auto_ctx, size);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_display_list()`. */
FZ_FUNCTION fz_display_list *new_display_list(fz_rect mediabox)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_display_list():" << " auto_ctx=" << auto_ctx << " mediabox=" << mediabox << "\n";
	}
	fz_display_list * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_display_list(auto_ctx, mediabox);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_display_list_from_page()`. */
FZ_FUNCTION fz_display_list *new_display_list_from_page(fz_page *page)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_display_list_from_page():" << " auto_ctx=" << auto_ctx << " page=" << page << "\n";
	}
	fz_display_list * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_display_list_from_page(auto_ctx, page);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_display_list_from_page_contents()`. */
FZ_FUNCTION fz_display_list *new_display_list_from_page_contents(fz_page *page)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_display_list_from_page_contents():" << " auto_ctx=" << auto_ctx << " page=" << page << "\n";
	}
	fz_display_list * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_display_list_from_page_contents(auto_ctx, page);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_display_list_from_page_number()`. */
FZ_FUNCTION fz_display_list *new_display_list_from_page_number(fz_document *doc, int number)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_display_list_from_page_number():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " number=" << number << "\n";
	}
	fz_display_list * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_display_list_from_page_number(auto_ctx, doc, number);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_display_list_from_svg()`.

This function has out-params. Python/C# wrappers look like:
	`new_display_list_from_svg(fz_buffer *buf, const char *base_uri, fz_archive *zip)` => `(fz_display_list *, float w, float h)`
*/
FZ_FUNCTION fz_display_list *new_display_list_from_svg(fz_buffer *buf, const char *base_uri, fz_archive *zip, float *w, float *h)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_display_list_from_svg():" << " auto_ctx=" << auto_ctx << " buf=" << buf << " base_uri=" << base_uri << " zip=" << zip << " w=" << (void*) w << " h=" << (void*) h << "\n";
	}
	fz_display_list * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_display_list_from_svg(auto_ctx, buf, base_uri, zip, w, h);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_display_list_from_svg_xml()`.

This function has out-params. Python/C# wrappers look like:
	`new_display_list_from_svg_xml(fz_xml_doc *xmldoc, fz_xml *xml, const char *base_uri, fz_archive *zip)` => `(fz_display_list *, float w, float h)`
*/
FZ_FUNCTION fz_display_list *new_display_list_from_svg_xml(fz_xml_doc *xmldoc, fz_xml *xml, const char *base_uri, fz_archive *zip, float *w, float *h)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_display_list_from_svg_xml():" << " auto_ctx=" << auto_ctx << " xmldoc=" << xmldoc << " xml=" << xml << " base_uri=" << base_uri << " zip=" << zip << " w=" << (void*) w << " h=" << (void*) h << "\n";
	}
	fz_display_list * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_display_list_from_svg_xml(auto_ctx, xmldoc, xml, base_uri, zip, w, h);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_document_of_size()`. */
FZ_FUNCTION void *new_document_of_size(int size)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_document_of_size():" << " auto_ctx=" << auto_ctx << " size=" << size << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_document_of_size(auto_ctx, size);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_document_writer()`. */
FZ_FUNCTION fz_document_writer *new_document_writer(const char *path, const char *format, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_document_writer():" << " auto_ctx=" << auto_ctx << " path=" << path << " format=" << format << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_document_writer(auto_ctx, path, format, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_document_writer_of_size()`. */
FZ_FUNCTION fz_document_writer *new_document_writer_of_size(size_t size, fz_document_writer_begin_page_fn *begin_page, fz_document_writer_end_page_fn *end_page, fz_document_writer_close_writer_fn *close, fz_document_writer_drop_writer_fn *drop)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_document_writer_of_size():" << " auto_ctx=" << auto_ctx << " size=" << size << " begin_page=" << (void*) begin_page << " end_page=" << (void*) end_page << " close=" << (void*) close << " drop=" << (void*) drop << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_document_writer_of_size(auto_ctx, size, begin_page, end_page, close, drop);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_document_writer_with_output()`. */
FZ_FUNCTION fz_document_writer *new_document_writer_with_output(fz_output *out, const char *format, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_document_writer_with_output():" << " auto_ctx=" << auto_ctx << " out=" << out << " format=" << format << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_document_writer_with_output(auto_ctx, out, format, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_docx_writer()`. */
FZ_FUNCTION fz_document_writer *new_docx_writer(const char *path, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_docx_writer():" << " auto_ctx=" << auto_ctx << " path=" << path << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_docx_writer(auto_ctx, path, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_docx_writer_with_output()`. */
FZ_FUNCTION fz_document_writer *new_docx_writer_with_output(fz_output *out, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_docx_writer_with_output():" << " auto_ctx=" << auto_ctx << " out=" << out << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_docx_writer_with_output(auto_ctx, out, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_draw_device()`. */
FZ_FUNCTION fz_device *new_draw_device(fz_matrix transform, fz_pixmap *dest)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_draw_device():" << " auto_ctx=" << auto_ctx << " transform=" << transform << " dest=" << dest << "\n";
	}
	fz_device * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_draw_device(auto_ctx, transform, dest);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_draw_device_type3()`. */
FZ_FUNCTION fz_device *new_draw_device_type3(fz_matrix transform, fz_pixmap *dest)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_draw_device_type3():" << " auto_ctx=" << auto_ctx << " transform=" << transform << " dest=" << dest << "\n";
	}
	fz_device * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_draw_device_type3(auto_ctx, transform, dest);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_draw_device_with_bbox()`. */
FZ_FUNCTION fz_device *new_draw_device_with_bbox(fz_matrix transform, fz_pixmap *dest, const fz_irect *clip)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_draw_device_with_bbox():" << " auto_ctx=" << auto_ctx << " transform=" << transform << " dest=" << dest << " clip=" << clip << "\n";
	}
	fz_device * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_draw_device_with_bbox(auto_ctx, transform, dest, clip);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_draw_device_with_bbox_proof()`. */
FZ_FUNCTION fz_device *new_draw_device_with_bbox_proof(fz_matrix transform, fz_pixmap *dest, const fz_irect *clip, fz_colorspace *cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_draw_device_with_bbox_proof():" << " auto_ctx=" << auto_ctx << " transform=" << transform << " dest=" << dest << " clip=" << clip << " cs=" << cs << "\n";
	}
	fz_device * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_draw_device_with_bbox_proof(auto_ctx, transform, dest, clip, cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_draw_device_with_options()`.

This function has out-params. Python/C# wrappers look like:
	`new_draw_device_with_options(const fz_draw_options *options, fz_rect mediabox, fz_pixmap **pixmap)` => `(fz_device *)`
*/
FZ_FUNCTION fz_device *new_draw_device_with_options(const fz_draw_options *options, fz_rect mediabox, fz_pixmap **pixmap)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_draw_device_with_options():" << " auto_ctx=" << auto_ctx << " options=" << options << " mediabox=" << mediabox << " pixmap=" << (void*) pixmap << "\n";
	}
	fz_device * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_draw_device_with_options(auto_ctx, options, mediabox, pixmap);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_draw_device_with_proof()`. */
FZ_FUNCTION fz_device *new_draw_device_with_proof(fz_matrix transform, fz_pixmap *dest, fz_colorspace *proof_cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_draw_device_with_proof():" << " auto_ctx=" << auto_ctx << " transform=" << transform << " dest=" << dest << " proof_cs=" << proof_cs << "\n";
	}
	fz_device * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_draw_device_with_proof(auto_ctx, transform, dest, proof_cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_font_from_buffer()`. */
FZ_FUNCTION fz_font *new_font_from_buffer(const char *name, fz_buffer *buffer, int index, int use_glyph_bbox)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_font_from_buffer():" << " auto_ctx=" << auto_ctx << " name=" << name << " buffer=" << buffer << " index=" << index << " use_glyph_bbox=" << use_glyph_bbox << "\n";
	}
	fz_font * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_font_from_buffer(auto_ctx, name, buffer, index, use_glyph_bbox);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_font_from_file()`. */
FZ_FUNCTION fz_font *new_font_from_file(const char *name, const char *path, int index, int use_glyph_bbox)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_font_from_file():" << " auto_ctx=" << auto_ctx << " name=" << name << " path=" << path << " index=" << index << " use_glyph_bbox=" << use_glyph_bbox << "\n";
	}
	fz_font * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_font_from_file(auto_ctx, name, path, index, use_glyph_bbox);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_font_from_memory()`. */
FZ_FUNCTION fz_font *new_font_from_memory(const char *name, const unsigned char *data, int len, int index, int use_glyph_bbox)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_font_from_memory():" << " auto_ctx=" << auto_ctx << " name=" << name << " data=" << (void*) data << " len=" << len << " index=" << index << " use_glyph_bbox=" << use_glyph_bbox << "\n";
	}
	fz_font * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_font_from_memory(auto_ctx, name, data, len, index, use_glyph_bbox);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_hash_table()`. */
FZ_FUNCTION fz_hash_table *new_hash_table(int initialsize, int keylen, int lock, fz_hash_table_drop_fn *drop_val)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_hash_table():" << " auto_ctx=" << auto_ctx << " initialsize=" << initialsize << " keylen=" << keylen << " lock=" << lock << " drop_val=" << (void*) drop_val << "\n";
	}
	fz_hash_table * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_hash_table(auto_ctx, initialsize, keylen, lock, drop_val);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_icc_colorspace()`. */
FZ_FUNCTION fz_colorspace *new_icc_colorspace(enum fz_colorspace_type type, int flags, const char *name, fz_buffer *buf)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_icc_colorspace():" << " auto_ctx=" << auto_ctx << " type=" << type << " flags=" << flags << " name=" << name << " buf=" << buf << "\n";
	}
	fz_colorspace * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_icc_colorspace(auto_ctx, type, flags, name, buf);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_image_from_buffer()`. */
FZ_FUNCTION fz_image *new_image_from_buffer(fz_buffer *buffer)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_image_from_buffer():" << " auto_ctx=" << auto_ctx << " buffer=" << buffer << "\n";
	}
	fz_image * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_image_from_buffer(auto_ctx, buffer);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_image_from_compressed_buffer()`.

This function has out-params. Python/C# wrappers look like:
	`new_image_from_compressed_buffer(int w, int h, int bpc, fz_colorspace *colorspace, int xres, int yres, int interpolate, int imagemask, fz_compressed_buffer *buffer, fz_image *mask)` => `(fz_image *, float decode, int colorkey)`
*/
FZ_FUNCTION fz_image *new_image_from_compressed_buffer(int w, int h, int bpc, fz_colorspace *colorspace, int xres, int yres, int interpolate, int imagemask, float *decode, int *colorkey, fz_compressed_buffer *buffer, fz_image *mask)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_image_from_compressed_buffer():" << " auto_ctx=" << auto_ctx << " w=" << w << " h=" << h << " bpc=" << bpc << " colorspace=" << colorspace << " xres=" << xres << " yres=" << yres << " interpolate=" << interpolate << " imagemask=" << imagemask << " decode=" << (void*) decode << " colorkey=" << (void*) colorkey << " buffer=" << buffer << " mask=" << mask << "\n";
	}
	fz_image * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_image_from_compressed_buffer(auto_ctx, w, h, bpc, colorspace, xres, yres, interpolate, imagemask, decode, colorkey, buffer, mask);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_image_from_display_list()`. */
FZ_FUNCTION fz_image *new_image_from_display_list(float w, float h, fz_display_list *list)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_image_from_display_list():" << " auto_ctx=" << auto_ctx << " w=" << w << " h=" << h << " list=" << list << "\n";
	}
	fz_image * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_image_from_display_list(auto_ctx, w, h, list);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_image_from_file()`. */
FZ_FUNCTION fz_image *new_image_from_file(const char *path)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_image_from_file():" << " auto_ctx=" << auto_ctx << " path=" << path << "\n";
	}
	fz_image * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_image_from_file(auto_ctx, path);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_image_from_pixmap()`. */
FZ_FUNCTION fz_image *new_image_from_pixmap(fz_pixmap *pixmap, fz_image *mask)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_image_from_pixmap():" << " auto_ctx=" << auto_ctx << " pixmap=" << pixmap << " mask=" << mask << "\n";
	}
	fz_image * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_image_from_pixmap(auto_ctx, pixmap, mask);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_image_from_svg()`. */
FZ_FUNCTION fz_image *new_image_from_svg(fz_buffer *buf, const char *base_uri, fz_archive *zip)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_image_from_svg():" << " auto_ctx=" << auto_ctx << " buf=" << buf << " base_uri=" << base_uri << " zip=" << zip << "\n";
	}
	fz_image * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_image_from_svg(auto_ctx, buf, base_uri, zip);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_image_from_svg_xml()`. */
FZ_FUNCTION fz_image *new_image_from_svg_xml(fz_xml_doc *xmldoc, fz_xml *xml, const char *base_uri, fz_archive *zip)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_image_from_svg_xml():" << " auto_ctx=" << auto_ctx << " xmldoc=" << xmldoc << " xml=" << xml << " base_uri=" << base_uri << " zip=" << zip << "\n";
	}
	fz_image * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_image_from_svg_xml(auto_ctx, xmldoc, xml, base_uri, zip);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_image_of_size()`.

This function has out-params. Python/C# wrappers look like:
	`new_image_of_size(int w, int h, int bpc, fz_colorspace *colorspace, int xres, int yres, int interpolate, int imagemask, fz_image *mask, size_t size, fz_image_get_pixmap_fn *get_pixmap, fz_image_get_size_fn *get_size, fz_drop_image_fn *drop)` => `(fz_image *, float decode, int colorkey)`
*/
FZ_FUNCTION fz_image *new_image_of_size(int w, int h, int bpc, fz_colorspace *colorspace, int xres, int yres, int interpolate, int imagemask, float *decode, int *colorkey, fz_image *mask, size_t size, fz_image_get_pixmap_fn *get_pixmap, fz_image_get_size_fn *get_size, fz_drop_image_fn *drop)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_image_of_size():" << " auto_ctx=" << auto_ctx << " w=" << w << " h=" << h << " bpc=" << bpc << " colorspace=" << colorspace << " xres=" << xres << " yres=" << yres << " interpolate=" << interpolate << " imagemask=" << imagemask << " decode=" << (void*) decode << " colorkey=" << (void*) colorkey << " mask=" << mask << " size=" << size << " get_pixmap=" << (void*) get_pixmap << " get_size=" << (void*) get_size << " drop=" << (void*) drop << "\n";
	}
	fz_image * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_image_of_size(auto_ctx, w, h, bpc, colorspace, xres, yres, interpolate, imagemask, decode, colorkey, mask, size, get_pixmap, get_size, drop);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_indexed_colorspace()`. */
FZ_FUNCTION fz_colorspace *new_indexed_colorspace(fz_colorspace *base, int high, unsigned char *lookup)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_indexed_colorspace():" << " auto_ctx=" << auto_ctx << " base=" << base << " high=" << high << " lookup=" << (void*) lookup << "\n";
	}
	fz_colorspace * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_indexed_colorspace(auto_ctx, base, high, lookup);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_layout()`. */
FZ_FUNCTION fz_layout_block *new_layout()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_layout():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_layout_block * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_layout(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_link()`. */
FZ_FUNCTION fz_link *new_link(fz_rect bbox, const char *uri)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_link():" << " auto_ctx=" << auto_ctx << " bbox=" << bbox << " uri=" << uri << "\n";
	}
	fz_link * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_link(auto_ctx, bbox, uri);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_list_device()`. */
FZ_FUNCTION fz_device *new_list_device(fz_display_list *list)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_list_device():" << " auto_ctx=" << auto_ctx << " list=" << list << "\n";
	}
	fz_device * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_list_device(auto_ctx, list);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_log_for_module()`. */
FZ_FUNCTION fz_output *new_log_for_module(const char *module)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_log_for_module():" << " auto_ctx=" << auto_ctx << " module=" << module << "\n";
	}
	fz_output * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_log_for_module(auto_ctx, module);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_mono_pcl_band_writer()`. */
FZ_FUNCTION fz_band_writer *new_mono_pcl_band_writer(fz_output *out, const fz_pcl_options *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_mono_pcl_band_writer():" << " auto_ctx=" << auto_ctx << " out=" << out << " options=" << options << "\n";
	}
	fz_band_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_mono_pcl_band_writer(auto_ctx, out, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_mono_pwg_band_writer()`. */
FZ_FUNCTION fz_band_writer *new_mono_pwg_band_writer(fz_output *out, const fz_pwg_options *pwg)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_mono_pwg_band_writer():" << " auto_ctx=" << auto_ctx << " out=" << out << " pwg=" << pwg << "\n";
	}
	fz_band_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_mono_pwg_band_writer(auto_ctx, out, pwg);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_ocr_device()`. */
FZ_FUNCTION fz_device *new_ocr_device(fz_device *target, fz_matrix ctm, fz_rect mediabox, int with_list, const char *language, const char *datadir, int (*progress)(fz_context *, void *, int ), void *progress_arg)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_ocr_device():" << " auto_ctx=" << auto_ctx << " target=" << target << " ctm=" << ctm << " mediabox=" << mediabox << " with_list=" << with_list << " language=" << language << " datadir=" << datadir << " progress=" << (void*) progress << " progress_arg=" << (void*) progress_arg << "\n";
	}
	fz_device * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_ocr_device(auto_ctx, target, ctm, mediabox, with_list, language, datadir, progress, progress_arg);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_odt_writer()`. */
FZ_FUNCTION fz_document_writer *new_odt_writer(const char *path, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_odt_writer():" << " auto_ctx=" << auto_ctx << " path=" << path << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_odt_writer(auto_ctx, path, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_odt_writer_with_output()`. */
FZ_FUNCTION fz_document_writer *new_odt_writer_with_output(fz_output *out, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_odt_writer_with_output():" << " auto_ctx=" << auto_ctx << " out=" << out << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_odt_writer_with_output(auto_ctx, out, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_outline()`. */
FZ_FUNCTION fz_outline *new_outline()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_outline():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_outline * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_outline(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_outline_iterator()`. */
FZ_FUNCTION fz_outline_iterator *new_outline_iterator(fz_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_outline_iterator():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_outline_iterator * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_outline_iterator(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_outline_iterator_of_size()`. */
FZ_FUNCTION fz_outline_iterator *new_outline_iterator_of_size(size_t size, fz_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_outline_iterator_of_size():" << " auto_ctx=" << auto_ctx << " size=" << size << " doc=" << doc << "\n";
	}
	fz_outline_iterator * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_outline_iterator_of_size(auto_ctx, size, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_output()`. */
FZ_FUNCTION fz_output *new_output(int bufsiz, void *state, fz_output_write_fn *write, fz_output_close_fn *close, fz_output_drop_fn *drop)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_output():" << " auto_ctx=" << auto_ctx << " bufsiz=" << bufsiz << " state=" << (void*) state << " write=" << (void*) write << " close=" << (void*) close << " drop=" << (void*) drop << "\n";
	}
	fz_output * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_output(auto_ctx, bufsiz, state, write, close, drop);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_output_with_buffer()`. */
FZ_FUNCTION fz_output *new_output_with_buffer(fz_buffer *buf)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_output_with_buffer():" << " auto_ctx=" << auto_ctx << " buf=" << buf << "\n";
	}
	fz_output * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_output_with_buffer(auto_ctx, buf);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_output_with_path()`. */
FZ_FUNCTION fz_output *new_output_with_path(const char *filename, int append)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_output_with_path():" << " auto_ctx=" << auto_ctx << " filename=" << filename << " append=" << append << "\n";
	}
	fz_output * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_output_with_path(auto_ctx, filename, append);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_page_of_size()`. */
FZ_FUNCTION fz_page *new_page_of_size(int size, fz_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_page_of_size():" << " auto_ctx=" << auto_ctx << " size=" << size << " doc=" << doc << "\n";
	}
	fz_page * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_page_of_size(auto_ctx, size, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pam_band_writer()`. */
FZ_FUNCTION fz_band_writer *new_pam_band_writer(fz_output *out)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pam_band_writer():" << " auto_ctx=" << auto_ctx << " out=" << out << "\n";
	}
	fz_band_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pam_band_writer(auto_ctx, out);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pam_pixmap_writer()`. */
FZ_FUNCTION fz_document_writer *new_pam_pixmap_writer(const char *path, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pam_pixmap_writer():" << " auto_ctx=" << auto_ctx << " path=" << path << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pam_pixmap_writer(auto_ctx, path, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_path()`. */
FZ_FUNCTION fz_path *new_path()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_path():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_path * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_path(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pbm_band_writer()`. */
FZ_FUNCTION fz_band_writer *new_pbm_band_writer(fz_output *out)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pbm_band_writer():" << " auto_ctx=" << auto_ctx << " out=" << out << "\n";
	}
	fz_band_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pbm_band_writer(auto_ctx, out);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pbm_pixmap_writer()`. */
FZ_FUNCTION fz_document_writer *new_pbm_pixmap_writer(const char *path, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pbm_pixmap_writer():" << " auto_ctx=" << auto_ctx << " path=" << path << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pbm_pixmap_writer(auto_ctx, path, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pcl_writer()`. */
FZ_FUNCTION fz_document_writer *new_pcl_writer(const char *path, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pcl_writer():" << " auto_ctx=" << auto_ctx << " path=" << path << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pcl_writer(auto_ctx, path, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pcl_writer_with_output()`. */
FZ_FUNCTION fz_document_writer *new_pcl_writer_with_output(fz_output *out, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pcl_writer_with_output():" << " auto_ctx=" << auto_ctx << " out=" << out << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pcl_writer_with_output(auto_ctx, out, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pclm_band_writer()`. */
FZ_FUNCTION fz_band_writer *new_pclm_band_writer(fz_output *out, const fz_pclm_options *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pclm_band_writer():" << " auto_ctx=" << auto_ctx << " out=" << out << " options=" << options << "\n";
	}
	fz_band_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pclm_band_writer(auto_ctx, out, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pclm_writer()`. */
FZ_FUNCTION fz_document_writer *new_pclm_writer(const char *path, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pclm_writer():" << " auto_ctx=" << auto_ctx << " path=" << path << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pclm_writer(auto_ctx, path, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pclm_writer_with_output()`. */
FZ_FUNCTION fz_document_writer *new_pclm_writer_with_output(fz_output *out, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pclm_writer_with_output():" << " auto_ctx=" << auto_ctx << " out=" << out << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pclm_writer_with_output(auto_ctx, out, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pdf_writer()`. */
FZ_FUNCTION fz_document_writer *new_pdf_writer(const char *path, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pdf_writer():" << " auto_ctx=" << auto_ctx << " path=" << path << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pdf_writer(auto_ctx, path, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pdf_writer_with_output()`. */
FZ_FUNCTION fz_document_writer *new_pdf_writer_with_output(fz_output *out, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pdf_writer_with_output():" << " auto_ctx=" << auto_ctx << " out=" << out << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pdf_writer_with_output(auto_ctx, out, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pdfocr_band_writer()`. */
FZ_FUNCTION fz_band_writer *new_pdfocr_band_writer(fz_output *out, const fz_pdfocr_options *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pdfocr_band_writer():" << " auto_ctx=" << auto_ctx << " out=" << out << " options=" << options << "\n";
	}
	fz_band_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pdfocr_band_writer(auto_ctx, out, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pdfocr_writer()`. */
FZ_FUNCTION fz_document_writer *new_pdfocr_writer(const char *path, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pdfocr_writer():" << " auto_ctx=" << auto_ctx << " path=" << path << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pdfocr_writer(auto_ctx, path, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pdfocr_writer_with_output()`. */
FZ_FUNCTION fz_document_writer *new_pdfocr_writer_with_output(fz_output *out, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pdfocr_writer_with_output():" << " auto_ctx=" << auto_ctx << " out=" << out << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pdfocr_writer_with_output(auto_ctx, out, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pgm_pixmap_writer()`. */
FZ_FUNCTION fz_document_writer *new_pgm_pixmap_writer(const char *path, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pgm_pixmap_writer():" << " auto_ctx=" << auto_ctx << " path=" << path << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pgm_pixmap_writer(auto_ctx, path, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pixmap()`. */
FZ_FUNCTION fz_pixmap *new_pixmap(fz_colorspace *cs, int w, int h, fz_separations *seps, int alpha)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pixmap():" << " auto_ctx=" << auto_ctx << " cs=" << cs << " w=" << w << " h=" << h << " seps=" << seps << " alpha=" << alpha << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pixmap(auto_ctx, cs, w, h, seps, alpha);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pixmap_from_alpha_channel()`. */
FZ_FUNCTION fz_pixmap *new_pixmap_from_alpha_channel(fz_pixmap *src)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pixmap_from_alpha_channel():" << " auto_ctx=" << auto_ctx << " src=" << src << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pixmap_from_alpha_channel(auto_ctx, src);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pixmap_from_color_and_mask()`. */
FZ_FUNCTION fz_pixmap *new_pixmap_from_color_and_mask(fz_pixmap *color, fz_pixmap *mask)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pixmap_from_color_and_mask():" << " auto_ctx=" << auto_ctx << " color=" << color << " mask=" << mask << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pixmap_from_color_and_mask(auto_ctx, color, mask);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pixmap_from_display_list()`. */
FZ_FUNCTION fz_pixmap *new_pixmap_from_display_list(fz_display_list *list, fz_matrix ctm, fz_colorspace *cs, int alpha)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pixmap_from_display_list():" << " auto_ctx=" << auto_ctx << " list=" << list << " ctm=" << ctm << " cs=" << cs << " alpha=" << alpha << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pixmap_from_display_list(auto_ctx, list, ctm, cs, alpha);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pixmap_from_display_list_with_separations()`. */
FZ_FUNCTION fz_pixmap *new_pixmap_from_display_list_with_separations(fz_display_list *list, fz_matrix ctm, fz_colorspace *cs, fz_separations *seps, int alpha)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pixmap_from_display_list_with_separations():" << " auto_ctx=" << auto_ctx << " list=" << list << " ctm=" << ctm << " cs=" << cs << " seps=" << seps << " alpha=" << alpha << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pixmap_from_display_list_with_separations(auto_ctx, list, ctm, cs, seps, alpha);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pixmap_from_page()`. */
FZ_FUNCTION fz_pixmap *new_pixmap_from_page(fz_page *page, fz_matrix ctm, fz_colorspace *cs, int alpha)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pixmap_from_page():" << " auto_ctx=" << auto_ctx << " page=" << page << " ctm=" << ctm << " cs=" << cs << " alpha=" << alpha << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pixmap_from_page(auto_ctx, page, ctm, cs, alpha);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pixmap_from_page_contents()`. */
FZ_FUNCTION fz_pixmap *new_pixmap_from_page_contents(fz_page *page, fz_matrix ctm, fz_colorspace *cs, int alpha)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pixmap_from_page_contents():" << " auto_ctx=" << auto_ctx << " page=" << page << " ctm=" << ctm << " cs=" << cs << " alpha=" << alpha << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pixmap_from_page_contents(auto_ctx, page, ctm, cs, alpha);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pixmap_from_page_contents_with_separations()`. */
FZ_FUNCTION fz_pixmap *new_pixmap_from_page_contents_with_separations(fz_page *page, fz_matrix ctm, fz_colorspace *cs, fz_separations *seps, int alpha)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pixmap_from_page_contents_with_separations():" << " auto_ctx=" << auto_ctx << " page=" << page << " ctm=" << ctm << " cs=" << cs << " seps=" << seps << " alpha=" << alpha << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pixmap_from_page_contents_with_separations(auto_ctx, page, ctm, cs, seps, alpha);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pixmap_from_page_number()`. */
FZ_FUNCTION fz_pixmap *new_pixmap_from_page_number(fz_document *doc, int number, fz_matrix ctm, fz_colorspace *cs, int alpha)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pixmap_from_page_number():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " number=" << number << " ctm=" << ctm << " cs=" << cs << " alpha=" << alpha << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pixmap_from_page_number(auto_ctx, doc, number, ctm, cs, alpha);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pixmap_from_page_number_with_separations()`. */
FZ_FUNCTION fz_pixmap *new_pixmap_from_page_number_with_separations(fz_document *doc, int number, fz_matrix ctm, fz_colorspace *cs, fz_separations *seps, int alpha)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pixmap_from_page_number_with_separations():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " number=" << number << " ctm=" << ctm << " cs=" << cs << " seps=" << seps << " alpha=" << alpha << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pixmap_from_page_number_with_separations(auto_ctx, doc, number, ctm, cs, seps, alpha);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pixmap_from_page_with_separations()`. */
FZ_FUNCTION fz_pixmap *new_pixmap_from_page_with_separations(fz_page *page, fz_matrix ctm, fz_colorspace *cs, fz_separations *seps, int alpha)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pixmap_from_page_with_separations():" << " auto_ctx=" << auto_ctx << " page=" << page << " ctm=" << ctm << " cs=" << cs << " seps=" << seps << " alpha=" << alpha << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pixmap_from_page_with_separations(auto_ctx, page, ctm, cs, seps, alpha);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pixmap_from_pixmap()`. */
FZ_FUNCTION fz_pixmap *new_pixmap_from_pixmap(fz_pixmap *pixmap, const fz_irect *rect)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pixmap_from_pixmap():" << " auto_ctx=" << auto_ctx << " pixmap=" << pixmap << " rect=" << rect << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pixmap_from_pixmap(auto_ctx, pixmap, rect);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pixmap_with_bbox()`. */
FZ_FUNCTION fz_pixmap *new_pixmap_with_bbox(fz_colorspace *colorspace, fz_irect bbox, fz_separations *seps, int alpha)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pixmap_with_bbox():" << " auto_ctx=" << auto_ctx << " colorspace=" << colorspace << " bbox=" << bbox << " seps=" << seps << " alpha=" << alpha << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pixmap_with_bbox(auto_ctx, colorspace, bbox, seps, alpha);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pixmap_with_bbox_and_data()`. */
FZ_FUNCTION fz_pixmap *new_pixmap_with_bbox_and_data(fz_colorspace *colorspace, fz_irect rect, fz_separations *seps, int alpha, unsigned char *samples)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pixmap_with_bbox_and_data():" << " auto_ctx=" << auto_ctx << " colorspace=" << colorspace << " rect=" << rect << " seps=" << seps << " alpha=" << alpha << " samples=" << (void*) samples << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pixmap_with_bbox_and_data(auto_ctx, colorspace, rect, seps, alpha, samples);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pixmap_with_data()`. */
FZ_FUNCTION fz_pixmap *new_pixmap_with_data(fz_colorspace *colorspace, int w, int h, fz_separations *seps, int alpha, int stride, unsigned char *samples)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pixmap_with_data():" << " auto_ctx=" << auto_ctx << " colorspace=" << colorspace << " w=" << w << " h=" << h << " seps=" << seps << " alpha=" << alpha << " stride=" << stride << " samples=" << (void*) samples << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pixmap_with_data(auto_ctx, colorspace, w, h, seps, alpha, stride, samples);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pixmap_writer()`. */
FZ_FUNCTION fz_document_writer *new_pixmap_writer(const char *path, const char *options, const char *default_path, int n, void (*save)(fz_context *, fz_pixmap *, const char *))
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pixmap_writer():" << " auto_ctx=" << auto_ctx << " path=" << path << " options=" << options << " default_path=" << default_path << " n=" << n << " save=" << (void*) save << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pixmap_writer(auto_ctx, path, options, default_path, n, save);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pkm_band_writer()`. */
FZ_FUNCTION fz_band_writer *new_pkm_band_writer(fz_output *out)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pkm_band_writer():" << " auto_ctx=" << auto_ctx << " out=" << out << "\n";
	}
	fz_band_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pkm_band_writer(auto_ctx, out);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pkm_pixmap_writer()`. */
FZ_FUNCTION fz_document_writer *new_pkm_pixmap_writer(const char *path, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pkm_pixmap_writer():" << " auto_ctx=" << auto_ctx << " path=" << path << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pkm_pixmap_writer(auto_ctx, path, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_png_band_writer()`. */
FZ_FUNCTION fz_band_writer *new_png_band_writer(fz_output *out)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_png_band_writer():" << " auto_ctx=" << auto_ctx << " out=" << out << "\n";
	}
	fz_band_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_png_band_writer(auto_ctx, out);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_png_pixmap_writer()`. */
FZ_FUNCTION fz_document_writer *new_png_pixmap_writer(const char *path, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_png_pixmap_writer():" << " auto_ctx=" << auto_ctx << " path=" << path << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_png_pixmap_writer(auto_ctx, path, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pnm_band_writer()`. */
FZ_FUNCTION fz_band_writer *new_pnm_band_writer(fz_output *out)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pnm_band_writer():" << " auto_ctx=" << auto_ctx << " out=" << out << "\n";
	}
	fz_band_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pnm_band_writer(auto_ctx, out);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pnm_pixmap_writer()`. */
FZ_FUNCTION fz_document_writer *new_pnm_pixmap_writer(const char *path, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pnm_pixmap_writer():" << " auto_ctx=" << auto_ctx << " path=" << path << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pnm_pixmap_writer(auto_ctx, path, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pool()`. */
FZ_FUNCTION fz_pool *new_pool()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pool():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_pool * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pool(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_ppm_pixmap_writer()`. */
FZ_FUNCTION fz_document_writer *new_ppm_pixmap_writer(const char *path, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_ppm_pixmap_writer():" << " auto_ctx=" << auto_ctx << " path=" << path << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_ppm_pixmap_writer(auto_ctx, path, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_ps_band_writer()`. */
FZ_FUNCTION fz_band_writer *new_ps_band_writer(fz_output *out)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_ps_band_writer():" << " auto_ctx=" << auto_ctx << " out=" << out << "\n";
	}
	fz_band_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_ps_band_writer(auto_ctx, out);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_ps_writer()`. */
FZ_FUNCTION fz_document_writer *new_ps_writer(const char *path, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_ps_writer():" << " auto_ctx=" << auto_ctx << " path=" << path << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_ps_writer(auto_ctx, path, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_ps_writer_with_output()`. */
FZ_FUNCTION fz_document_writer *new_ps_writer_with_output(fz_output *out, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_ps_writer_with_output():" << " auto_ctx=" << auto_ctx << " out=" << out << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_ps_writer_with_output(auto_ctx, out, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_psd_band_writer()`. */
FZ_FUNCTION fz_band_writer *new_psd_band_writer(fz_output *out)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_psd_band_writer():" << " auto_ctx=" << auto_ctx << " out=" << out << "\n";
	}
	fz_band_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_psd_band_writer(auto_ctx, out);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pwg_band_writer()`. */
FZ_FUNCTION fz_band_writer *new_pwg_band_writer(fz_output *out, const fz_pwg_options *pwg)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pwg_band_writer():" << " auto_ctx=" << auto_ctx << " out=" << out << " pwg=" << pwg << "\n";
	}
	fz_band_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pwg_band_writer(auto_ctx, out, pwg);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pwg_writer()`. */
FZ_FUNCTION fz_document_writer *new_pwg_writer(const char *path, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pwg_writer():" << " auto_ctx=" << auto_ctx << " path=" << path << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pwg_writer(auto_ctx, path, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_pwg_writer_with_output()`. */
FZ_FUNCTION fz_document_writer *new_pwg_writer_with_output(fz_output *out, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_pwg_writer_with_output():" << " auto_ctx=" << auto_ctx << " out=" << out << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_pwg_writer_with_output(auto_ctx, out, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_rle_output()`. */
FZ_FUNCTION fz_output *new_rle_output(fz_output *chain)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_rle_output():" << " auto_ctx=" << auto_ctx << " chain=" << chain << "\n";
	}
	fz_output * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_rle_output(auto_ctx, chain);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_separations()`. */
FZ_FUNCTION fz_separations *new_separations(int controllable)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_separations():" << " auto_ctx=" << auto_ctx << " controllable=" << controllable << "\n";
	}
	fz_separations * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_separations(auto_ctx, controllable);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_stext_device()`. */
FZ_FUNCTION fz_device *new_stext_device(fz_stext_page *page, const fz_stext_options *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_stext_device():" << " auto_ctx=" << auto_ctx << " page=" << page << " options=" << options << "\n";
	}
	fz_device * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_stext_device(auto_ctx, page, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_stext_page()`. */
FZ_FUNCTION fz_stext_page *new_stext_page(fz_rect mediabox)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_stext_page():" << " auto_ctx=" << auto_ctx << " mediabox=" << mediabox << "\n";
	}
	fz_stext_page * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_stext_page(auto_ctx, mediabox);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_stext_page_from_chapter_page_number()`. */
FZ_FUNCTION fz_stext_page *new_stext_page_from_chapter_page_number(fz_document *doc, int chapter, int number, const fz_stext_options *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_stext_page_from_chapter_page_number():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " chapter=" << chapter << " number=" << number << " options=" << options << "\n";
	}
	fz_stext_page * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_stext_page_from_chapter_page_number(auto_ctx, doc, chapter, number, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_stext_page_from_display_list()`. */
FZ_FUNCTION fz_stext_page *new_stext_page_from_display_list(fz_display_list *list, const fz_stext_options *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_stext_page_from_display_list():" << " auto_ctx=" << auto_ctx << " list=" << list << " options=" << options << "\n";
	}
	fz_stext_page * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_stext_page_from_display_list(auto_ctx, list, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_stext_page_from_page()`. */
FZ_FUNCTION fz_stext_page *new_stext_page_from_page(fz_page *page, const fz_stext_options *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_stext_page_from_page():" << " auto_ctx=" << auto_ctx << " page=" << page << " options=" << options << "\n";
	}
	fz_stext_page * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_stext_page_from_page(auto_ctx, page, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_stext_page_from_page_number()`. */
FZ_FUNCTION fz_stext_page *new_stext_page_from_page_number(fz_document *doc, int number, const fz_stext_options *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_stext_page_from_page_number():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " number=" << number << " options=" << options << "\n";
	}
	fz_stext_page * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_stext_page_from_page_number(auto_ctx, doc, number, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_store_context()`. */
FZ_FUNCTION void new_store_context(size_t max)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_store_context():" << " auto_ctx=" << auto_ctx << " max=" << max << "\n";
	}
	fz_try(auto_ctx) {
		::fz_new_store_context(auto_ctx, max);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_new_stream()`. */
FZ_FUNCTION fz_stream *new_stream(void *state, fz_stream_next_fn *next, fz_stream_drop_fn *drop)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_stream():" << " auto_ctx=" << auto_ctx << " state=" << (void*) state << " next=" << (void*) next << " drop=" << (void*) drop << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_stream(auto_ctx, state, next, drop);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_stroke_state()`. */
FZ_FUNCTION fz_stroke_state *new_stroke_state()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_stroke_state():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_stroke_state * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_stroke_state(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_stroke_state_with_dash_len()`. */
FZ_FUNCTION fz_stroke_state *new_stroke_state_with_dash_len(int len)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_stroke_state_with_dash_len():" << " auto_ctx=" << auto_ctx << " len=" << len << "\n";
	}
	fz_stroke_state * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_stroke_state_with_dash_len(auto_ctx, len);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_svg_device()`. */
FZ_FUNCTION fz_device *new_svg_device(fz_output *out, float page_width, float page_height, int text_format, int reuse_images)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_svg_device():" << " auto_ctx=" << auto_ctx << " out=" << out << " page_width=" << page_width << " page_height=" << page_height << " text_format=" << text_format << " reuse_images=" << reuse_images << "\n";
	}
	fz_device * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_svg_device(auto_ctx, out, page_width, page_height, text_format, reuse_images);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_svg_device_with_id()`.

This function has out-params. Python/C# wrappers look like:
	`new_svg_device_with_id(fz_output *out, float page_width, float page_height, int text_format, int reuse_images)` => `(fz_device *, int id)`
*/
FZ_FUNCTION fz_device *new_svg_device_with_id(fz_output *out, float page_width, float page_height, int text_format, int reuse_images, int *id)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_svg_device_with_id():" << " auto_ctx=" << auto_ctx << " out=" << out << " page_width=" << page_width << " page_height=" << page_height << " text_format=" << text_format << " reuse_images=" << reuse_images << " id=" << (void*) id << "\n";
	}
	fz_device * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_svg_device_with_id(auto_ctx, out, page_width, page_height, text_format, reuse_images, id);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_svg_writer()`. */
FZ_FUNCTION fz_document_writer *new_svg_writer(const char *path, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_svg_writer():" << " auto_ctx=" << auto_ctx << " path=" << path << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_svg_writer(auto_ctx, path, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_test_device()`.

This function has out-params. Python/C# wrappers look like:
	`new_test_device(float threshold, int options, fz_device *passthrough)` => `(fz_device *, int is_color)`
*/
FZ_FUNCTION fz_device *new_test_device(int *is_color, float threshold, int options, fz_device *passthrough)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_test_device():" << " auto_ctx=" << auto_ctx << " is_color=" << (void*) is_color << " threshold=" << threshold << " options=" << options << " passthrough=" << passthrough << "\n";
	}
	fz_device * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_test_device(auto_ctx, is_color, threshold, options, passthrough);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_text()`. */
FZ_FUNCTION fz_text *new_text()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_text():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_text * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_text(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_text_writer()`. */
FZ_FUNCTION fz_document_writer *new_text_writer(const char *format, const char *path, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_text_writer():" << " auto_ctx=" << auto_ctx << " format=" << format << " path=" << path << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_text_writer(auto_ctx, format, path, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_text_writer_with_output()`. */
FZ_FUNCTION fz_document_writer *new_text_writer_with_output(const char *format, fz_output *out, const char *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_text_writer_with_output():" << " auto_ctx=" << auto_ctx << " format=" << format << " out=" << out << " options=" << options << "\n";
	}
	fz_document_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_text_writer_with_output(auto_ctx, format, out, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_trace_device()`. */
FZ_FUNCTION fz_device *new_trace_device(fz_output *out)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_trace_device():" << " auto_ctx=" << auto_ctx << " out=" << out << "\n";
	}
	fz_device * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_trace_device(auto_ctx, out);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_type3_font()`. */
FZ_FUNCTION fz_font *new_type3_font(const char *name, fz_matrix matrix)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_type3_font():" << " auto_ctx=" << auto_ctx << " name=" << name << " matrix=" << matrix << "\n";
	}
	fz_font * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_type3_font(auto_ctx, name, matrix);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_xhtml_document_from_document()`. */
FZ_FUNCTION fz_document *new_xhtml_document_from_document(fz_document *old_doc, const fz_stext_options *opts)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_xhtml_document_from_document():" << " auto_ctx=" << auto_ctx << " old_doc=" << old_doc << " opts=" << opts << "\n";
	}
	fz_document * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_xhtml_document_from_document(auto_ctx, old_doc, opts);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_xmltext_device()`. */
FZ_FUNCTION fz_device *new_xmltext_device(fz_output *out)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_xmltext_device():" << " auto_ctx=" << auto_ctx << " out=" << out << "\n";
	}
	fz_device * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_xmltext_device(auto_ctx, out);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_zip_writer()`. */
FZ_FUNCTION fz_zip_writer *new_zip_writer(const char *filename)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_zip_writer():" << " auto_ctx=" << auto_ctx << " filename=" << filename << "\n";
	}
	fz_zip_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_zip_writer(auto_ctx, filename);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_new_zip_writer_with_output()`. */
FZ_FUNCTION fz_zip_writer *new_zip_writer_with_output(fz_output *out)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_new_zip_writer_with_output():" << " auto_ctx=" << auto_ctx << " out=" << out << "\n";
	}
	fz_zip_writer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_new_zip_writer_with_output(auto_ctx, out);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_next_page()`. */
FZ_FUNCTION fz_location next_page(fz_document *doc, fz_location loc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_next_page():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " loc=" << loc << "\n";
	}
	fz_location ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_next_page(auto_ctx, doc, loc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_normalize_vector()`. */
FZ_FUNCTION fz_point normalize_vector(fz_point p)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_normalize_vector():" << " p=" << p << "\n";
	}
	fz_point ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_normalize_vector(p);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_a85d()`. */
FZ_FUNCTION fz_stream *open_a85d(fz_stream *chain)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_a85d():" << " auto_ctx=" << auto_ctx << " chain=" << chain << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_a85d(auto_ctx, chain);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_accelerated_document()`. */
FZ_FUNCTION fz_document *open_accelerated_document(const char *filename, const char *accel)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_accelerated_document():" << " auto_ctx=" << auto_ctx << " filename=" << filename << " accel=" << accel << "\n";
	}
	fz_document * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_accelerated_document(auto_ctx, filename, accel);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_accelerated_document_with_stream()`. */
FZ_FUNCTION fz_document *open_accelerated_document_with_stream(const char *magic, fz_stream *stream, fz_stream *accel)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_accelerated_document_with_stream():" << " auto_ctx=" << auto_ctx << " magic=" << magic << " stream=" << stream << " accel=" << accel << "\n";
	}
	fz_document * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_accelerated_document_with_stream(auto_ctx, magic, stream, accel);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_aesd()`. */
FZ_FUNCTION fz_stream *open_aesd(fz_stream *chain, unsigned char *key, unsigned int keylen)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_aesd():" << " auto_ctx=" << auto_ctx << " chain=" << chain << " key=" << (void*) key << " keylen=" << keylen << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_aesd(auto_ctx, chain, key, keylen);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_ahxd()`. */
FZ_FUNCTION fz_stream *open_ahxd(fz_stream *chain)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_ahxd():" << " auto_ctx=" << auto_ctx << " chain=" << chain << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_ahxd(auto_ctx, chain);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_arc4()`. */
FZ_FUNCTION fz_stream *open_arc4(fz_stream *chain, unsigned char *key, unsigned int keylen)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_arc4():" << " auto_ctx=" << auto_ctx << " chain=" << chain << " key=" << (void*) key << " keylen=" << keylen << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_arc4(auto_ctx, chain, key, keylen);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_archive()`. */
FZ_FUNCTION fz_archive *open_archive(const char *filename)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_archive():" << " auto_ctx=" << auto_ctx << " filename=" << filename << "\n";
	}
	fz_archive * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_archive(auto_ctx, filename);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_archive_entry()`. */
FZ_FUNCTION fz_stream *open_archive_entry(fz_archive *arch, const char *name)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_archive_entry():" << " auto_ctx=" << auto_ctx << " arch=" << arch << " name=" << name << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_archive_entry(auto_ctx, arch, name);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_archive_with_stream()`. */
FZ_FUNCTION fz_archive *open_archive_with_stream(fz_stream *file)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_archive_with_stream():" << " auto_ctx=" << auto_ctx << " file=" << file << "\n";
	}
	fz_archive * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_archive_with_stream(auto_ctx, file);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_buffer()`. */
FZ_FUNCTION fz_stream *open_buffer(fz_buffer *buf)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_buffer():" << " auto_ctx=" << auto_ctx << " buf=" << buf << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_buffer(auto_ctx, buf);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_compressed_buffer()`. */
FZ_FUNCTION fz_stream *open_compressed_buffer(fz_compressed_buffer *arg_1)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_compressed_buffer():" << " auto_ctx=" << auto_ctx << " arg_1=" << arg_1 << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_compressed_buffer(auto_ctx, arg_1);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_concat()`. */
FZ_FUNCTION fz_stream *open_concat(int max, int pad)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_concat():" << " auto_ctx=" << auto_ctx << " max=" << max << " pad=" << pad << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_concat(auto_ctx, max, pad);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_dctd()`. */
FZ_FUNCTION fz_stream *open_dctd(fz_stream *chain, int color_transform, int l2factor, fz_stream *jpegtables)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_dctd():" << " auto_ctx=" << auto_ctx << " chain=" << chain << " color_transform=" << color_transform << " l2factor=" << l2factor << " jpegtables=" << jpegtables << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_dctd(auto_ctx, chain, color_transform, l2factor, jpegtables);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_directory()`. */
FZ_FUNCTION fz_archive *open_directory(const char *path)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_directory():" << " auto_ctx=" << auto_ctx << " path=" << path << "\n";
	}
	fz_archive * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_directory(auto_ctx, path);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_document()`. */
FZ_FUNCTION fz_document *open_document(const char *filename)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_document():" << " auto_ctx=" << auto_ctx << " filename=" << filename << "\n";
	}
	fz_document * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_document(auto_ctx, filename);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_document_with_stream()`. */
FZ_FUNCTION fz_document *open_document_with_stream(const char *magic, fz_stream *stream)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_document_with_stream():" << " auto_ctx=" << auto_ctx << " magic=" << magic << " stream=" << stream << "\n";
	}
	fz_document * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_document_with_stream(auto_ctx, magic, stream);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_endstream_filter()`. */
FZ_FUNCTION fz_stream *open_endstream_filter(fz_stream *chain, uint64_t len, int64_t offset)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_endstream_filter():" << " auto_ctx=" << auto_ctx << " chain=" << chain << " len=" << len << " offset=" << offset << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_endstream_filter(auto_ctx, chain, len, offset);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_faxd()`. */
FZ_FUNCTION fz_stream *open_faxd(fz_stream *chain, int k, int end_of_line, int encoded_byte_align, int columns, int rows, int end_of_block, int black_is_1)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_faxd():" << " auto_ctx=" << auto_ctx << " chain=" << chain << " k=" << k << " end_of_line=" << end_of_line << " encoded_byte_align=" << encoded_byte_align << " columns=" << columns << " rows=" << rows << " end_of_block=" << end_of_block << " black_is_1=" << black_is_1 << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_faxd(auto_ctx, chain, k, end_of_line, encoded_byte_align, columns, rows, end_of_block, black_is_1);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_file()`. */
FZ_FUNCTION fz_stream *open_file(const char *filename)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_file():" << " auto_ctx=" << auto_ctx << " filename=" << filename << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_file(auto_ctx, filename);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_file_ptr_no_close()`. */
FZ_FUNCTION fz_stream *open_file_ptr_no_close(FILE *file)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_file_ptr_no_close():" << " auto_ctx=" << auto_ctx << " file=" << (void*) file << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_file_ptr_no_close(auto_ctx, file);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_flated()`. */
FZ_FUNCTION fz_stream *open_flated(fz_stream *chain, int window_bits)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_flated():" << " auto_ctx=" << auto_ctx << " chain=" << chain << " window_bits=" << window_bits << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_flated(auto_ctx, chain, window_bits);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_image_decomp_stream()`.

This function has out-params. Python/C# wrappers look like:
	`open_image_decomp_stream(fz_stream *arg_0, fz_compression_params *arg_1)` => `(fz_stream *, int l2factor)`
*/
FZ_FUNCTION fz_stream *open_image_decomp_stream(fz_stream *arg_1, fz_compression_params *arg_2, int *l2factor)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_image_decomp_stream():" << " auto_ctx=" << auto_ctx << " arg_1=" << arg_1 << " arg_2=" << arg_2 << " l2factor=" << (void*) l2factor << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_image_decomp_stream(auto_ctx, arg_1, arg_2, l2factor);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_image_decomp_stream_from_buffer()`.

This function has out-params. Python/C# wrappers look like:
	`open_image_decomp_stream_from_buffer(fz_compressed_buffer *arg_0)` => `(fz_stream *, int l2factor)`
*/
FZ_FUNCTION fz_stream *open_image_decomp_stream_from_buffer(fz_compressed_buffer *arg_1, int *l2factor)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_image_decomp_stream_from_buffer():" << " auto_ctx=" << auto_ctx << " arg_1=" << arg_1 << " l2factor=" << (void*) l2factor << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_image_decomp_stream_from_buffer(auto_ctx, arg_1, l2factor);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_jbig2d()`. */
FZ_FUNCTION fz_stream *open_jbig2d(fz_stream *chain, fz_jbig2_globals *globals, int embedded)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_jbig2d():" << " auto_ctx=" << auto_ctx << " chain=" << chain << " globals=" << globals << " embedded=" << embedded << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_jbig2d(auto_ctx, chain, globals, embedded);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_leecher()`. */
FZ_FUNCTION fz_stream *open_leecher(fz_stream *chain, fz_buffer *buf)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_leecher():" << " auto_ctx=" << auto_ctx << " chain=" << chain << " buf=" << buf << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_leecher(auto_ctx, chain, buf);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_lzwd()`. */
FZ_FUNCTION fz_stream *open_lzwd(fz_stream *chain, int early_change, int min_bits, int reverse_bits, int old_tiff)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_lzwd():" << " auto_ctx=" << auto_ctx << " chain=" << chain << " early_change=" << early_change << " min_bits=" << min_bits << " reverse_bits=" << reverse_bits << " old_tiff=" << old_tiff << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_lzwd(auto_ctx, chain, early_change, min_bits, reverse_bits, old_tiff);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_memory()`. */
FZ_FUNCTION fz_stream *open_memory(const unsigned char *data, size_t len)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_memory():" << " auto_ctx=" << auto_ctx << " data=" << (void*) data << " len=" << len << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_memory(auto_ctx, data, len);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_null_filter()`. */
FZ_FUNCTION fz_stream *open_null_filter(fz_stream *chain, uint64_t len, int64_t offset)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_null_filter():" << " auto_ctx=" << auto_ctx << " chain=" << chain << " len=" << len << " offset=" << offset << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_null_filter(auto_ctx, chain, len, offset);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_predict()`. */
FZ_FUNCTION fz_stream *open_predict(fz_stream *chain, int predictor, int columns, int colors, int bpc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_predict():" << " auto_ctx=" << auto_ctx << " chain=" << chain << " predictor=" << predictor << " columns=" << columns << " colors=" << colors << " bpc=" << bpc << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_predict(auto_ctx, chain, predictor, columns, colors, bpc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_range_filter()`. */
FZ_FUNCTION fz_stream *open_range_filter(fz_stream *chain, fz_range *ranges, int nranges)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_range_filter():" << " auto_ctx=" << auto_ctx << " chain=" << chain << " ranges=" << ranges << " nranges=" << nranges << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_range_filter(auto_ctx, chain, ranges, nranges);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_reflowed_document()`. */
FZ_FUNCTION fz_document *open_reflowed_document(fz_document *underdoc, const fz_stext_options *opts)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_reflowed_document():" << " auto_ctx=" << auto_ctx << " underdoc=" << underdoc << " opts=" << opts << "\n";
	}
	fz_document * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_reflowed_document(auto_ctx, underdoc, opts);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_rld()`. */
FZ_FUNCTION fz_stream *open_rld(fz_stream *chain)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_rld():" << " auto_ctx=" << auto_ctx << " chain=" << chain << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_rld(auto_ctx, chain);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_sgilog16()`. */
FZ_FUNCTION fz_stream *open_sgilog16(fz_stream *chain, int w)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_sgilog16():" << " auto_ctx=" << auto_ctx << " chain=" << chain << " w=" << w << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_sgilog16(auto_ctx, chain, w);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_sgilog24()`. */
FZ_FUNCTION fz_stream *open_sgilog24(fz_stream *chain, int w)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_sgilog24():" << " auto_ctx=" << auto_ctx << " chain=" << chain << " w=" << w << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_sgilog24(auto_ctx, chain, w);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_sgilog32()`. */
FZ_FUNCTION fz_stream *open_sgilog32(fz_stream *chain, int w)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_sgilog32():" << " auto_ctx=" << auto_ctx << " chain=" << chain << " w=" << w << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_sgilog32(auto_ctx, chain, w);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_tar_archive()`. */
FZ_FUNCTION fz_archive *open_tar_archive(const char *filename)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_tar_archive():" << " auto_ctx=" << auto_ctx << " filename=" << filename << "\n";
	}
	fz_archive * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_tar_archive(auto_ctx, filename);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_tar_archive_with_stream()`. */
FZ_FUNCTION fz_archive *open_tar_archive_with_stream(fz_stream *file)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_tar_archive_with_stream():" << " auto_ctx=" << auto_ctx << " file=" << file << "\n";
	}
	fz_archive * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_tar_archive_with_stream(auto_ctx, file);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_thunder()`. */
FZ_FUNCTION fz_stream *open_thunder(fz_stream *chain, int w)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_thunder():" << " auto_ctx=" << auto_ctx << " chain=" << chain << " w=" << w << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_thunder(auto_ctx, chain, w);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_zip_archive()`. */
FZ_FUNCTION fz_archive *open_zip_archive(const char *path)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_zip_archive():" << " auto_ctx=" << auto_ctx << " path=" << path << "\n";
	}
	fz_archive * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_zip_archive(auto_ctx, path);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_open_zip_archive_with_stream()`. */
FZ_FUNCTION fz_archive *open_zip_archive_with_stream(fz_stream *file)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_open_zip_archive_with_stream():" << " auto_ctx=" << auto_ctx << " file=" << file << "\n";
	}
	fz_archive * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_open_zip_archive_with_stream(auto_ctx, file);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_option_eq()`. */
FZ_FUNCTION int option_eq(const char *a, const char *b)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_option_eq():" << " a=" << a << " b=" << b << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_option_eq(a, b);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_outline_glyph()`. */
FZ_FUNCTION fz_path *outline_glyph(fz_font *font, int gid, fz_matrix ctm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_outline_glyph():" << " auto_ctx=" << auto_ctx << " font=" << font << " gid=" << gid << " ctm=" << ctm << "\n";
	}
	fz_path * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_outline_glyph(auto_ctx, font, gid, ctm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_outline_iterator_delete()`. */
FZ_FUNCTION int outline_iterator_delete(fz_outline_iterator *iter)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_outline_iterator_delete():" << " auto_ctx=" << auto_ctx << " iter=" << iter << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_outline_iterator_delete(auto_ctx, iter);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_outline_iterator_down()`. */
FZ_FUNCTION int outline_iterator_down(fz_outline_iterator *iter)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_outline_iterator_down():" << " auto_ctx=" << auto_ctx << " iter=" << iter << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_outline_iterator_down(auto_ctx, iter);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_outline_iterator_from_outline()`. */
FZ_FUNCTION fz_outline_iterator *outline_iterator_from_outline(fz_outline *outline)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_outline_iterator_from_outline():" << " auto_ctx=" << auto_ctx << " outline=" << outline << "\n";
	}
	fz_outline_iterator * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_outline_iterator_from_outline(auto_ctx, outline);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_outline_iterator_insert()`. */
FZ_FUNCTION int outline_iterator_insert(fz_outline_iterator *iter, fz_outline_item *item)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_outline_iterator_insert():" << " auto_ctx=" << auto_ctx << " iter=" << iter << " item=" << item << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_outline_iterator_insert(auto_ctx, iter, item);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_outline_iterator_item()`. */
FZ_FUNCTION fz_outline_item *outline_iterator_item(fz_outline_iterator *iter)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_outline_iterator_item():" << " auto_ctx=" << auto_ctx << " iter=" << iter << "\n";
	}
	fz_outline_item * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_outline_iterator_item(auto_ctx, iter);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_outline_iterator_next()`. */
FZ_FUNCTION int outline_iterator_next(fz_outline_iterator *iter)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_outline_iterator_next():" << " auto_ctx=" << auto_ctx << " iter=" << iter << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_outline_iterator_next(auto_ctx, iter);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_outline_iterator_prev()`. */
FZ_FUNCTION int outline_iterator_prev(fz_outline_iterator *iter)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_outline_iterator_prev():" << " auto_ctx=" << auto_ctx << " iter=" << iter << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_outline_iterator_prev(auto_ctx, iter);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_outline_iterator_up()`. */
FZ_FUNCTION int outline_iterator_up(fz_outline_iterator *iter)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_outline_iterator_up():" << " auto_ctx=" << auto_ctx << " iter=" << iter << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_outline_iterator_up(auto_ctx, iter);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_outline_iterator_update()`. */
FZ_FUNCTION void outline_iterator_update(fz_outline_iterator *iter, fz_outline_item *item)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_outline_iterator_update():" << " auto_ctx=" << auto_ctx << " iter=" << iter << " item=" << item << "\n";
	}
	fz_try(auto_ctx) {
		::fz_outline_iterator_update(auto_ctx, iter, item);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_output_accelerator()`. */
FZ_FUNCTION void output_accelerator(fz_document *doc, fz_output *accel)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_output_accelerator():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " accel=" << accel << "\n";
	}
	fz_try(auto_ctx) {
		::fz_output_accelerator(auto_ctx, doc, accel);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_output_supports_stream()`. */
FZ_FUNCTION int output_supports_stream(fz_output *out)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_output_supports_stream():" << " auto_ctx=" << auto_ctx << " out=" << out << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_output_supports_stream(auto_ctx, out);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_pack_path()`. */
FZ_FUNCTION size_t pack_path(uint8_t *pack, size_t max, const fz_path *path)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_pack_path():" << " auto_ctx=" << auto_ctx << " pack=" << (void*) pack << " max=" << max << " path=" << path << "\n";
	}
	size_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_pack_path(auto_ctx, pack, max, path);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_packed_path_size()`. */
FZ_FUNCTION int packed_path_size(const fz_path *path)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_packed_path_size():" << " path=" << path << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_packed_path_size(path);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_page_number_from_location()`. */
FZ_FUNCTION int page_number_from_location(fz_document *doc, fz_location loc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_page_number_from_location():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " loc=" << loc << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_page_number_from_location(auto_ctx, doc, loc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_page_presentation()`.

This function has out-params. Python/C# wrappers look like:
	`page_presentation(fz_page *page, fz_transition *transition)` => `(fz_transition *, float duration)`
*/
FZ_FUNCTION fz_transition *page_presentation(fz_page *page, fz_transition *transition, float *duration)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_page_presentation():" << " auto_ctx=" << auto_ctx << " page=" << page << " transition=" << transition << " duration=" << (void*) duration << "\n";
	}
	fz_transition * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_page_presentation(auto_ctx, page, transition, duration);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_page_separations()`. */
FZ_FUNCTION fz_separations *page_separations(fz_page *page)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_page_separations():" << " auto_ctx=" << auto_ctx << " page=" << page << "\n";
	}
	fz_separations * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_page_separations(auto_ctx, page);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_page_uses_overprint()`. */
FZ_FUNCTION int page_uses_overprint(fz_page *page)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_page_uses_overprint():" << " auto_ctx=" << auto_ctx << " page=" << page << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_page_uses_overprint(auto_ctx, page);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_paint_shade()`.

This function has out-params. Python/C# wrappers look like:
	`paint_shade(fz_shade *shade, fz_colorspace *override_cs, fz_matrix ctm, fz_pixmap *dest, fz_color_params color_params, fz_irect bbox, const fz_overprint *eop, fz_shade_color_cache **cache)` => 
*/
FZ_FUNCTION void paint_shade(fz_shade *shade, fz_colorspace *override_cs, fz_matrix ctm, fz_pixmap *dest, fz_color_params color_params, fz_irect bbox, const fz_overprint *eop, fz_shade_color_cache **cache)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_paint_shade():" << " auto_ctx=" << auto_ctx << " shade=" << shade << " override_cs=" << override_cs << " ctm=" << ctm << " dest=" << dest << " color_params=" << color_params << " bbox=" << bbox << " eop=" << eop << " cache=" << (void*) cache << "\n";
	}
	fz_try(auto_ctx) {
		::fz_paint_shade(auto_ctx, shade, override_cs, ctm, dest, color_params, bbox, eop, cache);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_parse_draw_options()`. */
FZ_FUNCTION fz_draw_options *parse_draw_options(fz_draw_options *options, const char *string)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_parse_draw_options():" << " auto_ctx=" << auto_ctx << " options=" << options << " string=" << string << "\n";
	}
	fz_draw_options * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_parse_draw_options(auto_ctx, options, string);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_parse_page_range()`.

This function has out-params. Python/C# wrappers look like:
	`parse_page_range(const char *s, int n)` => `(const char *, int a, int b)`
*/
FZ_FUNCTION const char *parse_page_range(const char *s, int *a, int *b, int n)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_parse_page_range():" << " auto_ctx=" << auto_ctx << " s=" << s << " a=" << (void*) a << " b=" << (void*) b << " n=" << n << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_parse_page_range(auto_ctx, s, a, b, n);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_parse_pcl_options()`. */
FZ_FUNCTION fz_pcl_options *parse_pcl_options(fz_pcl_options *opts, const char *args)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_parse_pcl_options():" << " auto_ctx=" << auto_ctx << " opts=" << opts << " args=" << args << "\n";
	}
	fz_pcl_options * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_parse_pcl_options(auto_ctx, opts, args);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_parse_pclm_options()`. */
FZ_FUNCTION fz_pclm_options *parse_pclm_options(fz_pclm_options *opts, const char *args)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_parse_pclm_options():" << " auto_ctx=" << auto_ctx << " opts=" << opts << " args=" << args << "\n";
	}
	fz_pclm_options * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_parse_pclm_options(auto_ctx, opts, args);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_parse_pdfocr_options()`. */
FZ_FUNCTION fz_pdfocr_options *parse_pdfocr_options(fz_pdfocr_options *opts, const char *args)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_parse_pdfocr_options():" << " auto_ctx=" << auto_ctx << " opts=" << opts << " args=" << args << "\n";
	}
	fz_pdfocr_options * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_parse_pdfocr_options(auto_ctx, opts, args);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_parse_stext_options()`. */
FZ_FUNCTION fz_stext_options *parse_stext_options(fz_stext_options *opts, const char *string)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_parse_stext_options():" << " auto_ctx=" << auto_ctx << " opts=" << opts << " string=" << string << "\n";
	}
	fz_stext_options * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_parse_stext_options(auto_ctx, opts, string);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_parse_xml()`. */
FZ_FUNCTION fz_xml_doc *parse_xml(fz_buffer *buf, int preserve_white)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_parse_xml():" << " auto_ctx=" << auto_ctx << " buf=" << buf << " preserve_white=" << preserve_white << "\n";
	}
	fz_xml_doc * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_parse_xml(auto_ctx, buf, preserve_white);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_parse_xml_from_html5()`. */
FZ_FUNCTION fz_xml_doc *parse_xml_from_html5(fz_buffer *buf)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_parse_xml_from_html5():" << " auto_ctx=" << auto_ctx << " buf=" << buf << "\n";
	}
	fz_xml_doc * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_parse_xml_from_html5(auto_ctx, buf);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_pcl_preset()`. */
FZ_FUNCTION void pcl_preset(fz_pcl_options *opts, const char *preset)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_pcl_preset():" << " auto_ctx=" << auto_ctx << " opts=" << opts << " preset=" << preset << "\n";
	}
	fz_try(auto_ctx) {
		::fz_pcl_preset(auto_ctx, opts, preset);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_pdfocr_band_writer_set_progress()`. */
FZ_FUNCTION void pdfocr_band_writer_set_progress(fz_band_writer *writer, fz_pdfocr_progress_fn *progress_fn, void *progress_arg)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_pdfocr_band_writer_set_progress():" << " auto_ctx=" << auto_ctx << " writer=" << writer << " progress_fn=" << (void*) progress_fn << " progress_arg=" << (void*) progress_arg << "\n";
	}
	fz_try(auto_ctx) {
		::fz_pdfocr_band_writer_set_progress(auto_ctx, writer, progress_fn, progress_arg);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_pdfocr_writer_set_progress()`. */
FZ_FUNCTION void pdfocr_writer_set_progress(fz_document_writer *writer, fz_pdfocr_progress_fn *progress, void *arg_3)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_pdfocr_writer_set_progress():" << " auto_ctx=" << auto_ctx << " writer=" << writer << " progress=" << (void*) progress << " arg_3=" << (void*) arg_3 << "\n";
	}
	fz_try(auto_ctx) {
		::fz_pdfocr_writer_set_progress(auto_ctx, writer, progress, arg_3);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_peek_byte()`. */
FZ_FUNCTION int peek_byte(fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_peek_byte():" << " auto_ctx=" << auto_ctx << " stm=" << stm << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_peek_byte(auto_ctx, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_pixmap_alpha()`. */
FZ_FUNCTION int pixmap_alpha(const fz_pixmap *pix)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_pixmap_alpha():" << " auto_ctx=" << auto_ctx << " pix=" << pix << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_pixmap_alpha(auto_ctx, pix);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_pixmap_bbox()`. */
FZ_FUNCTION fz_irect pixmap_bbox(const fz_pixmap *pix)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_pixmap_bbox():" << " auto_ctx=" << auto_ctx << " pix=" << pix << "\n";
	}
	fz_irect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_pixmap_bbox(auto_ctx, pix);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_pixmap_colorants()`. */
FZ_FUNCTION int pixmap_colorants(const fz_pixmap *pix)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_pixmap_colorants():" << " auto_ctx=" << auto_ctx << " pix=" << pix << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_pixmap_colorants(auto_ctx, pix);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_pixmap_colorspace()`. */
FZ_FUNCTION fz_colorspace *pixmap_colorspace(const fz_pixmap *pix)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_pixmap_colorspace():" << " auto_ctx=" << auto_ctx << " pix=" << pix << "\n";
	}
	fz_colorspace * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_pixmap_colorspace(auto_ctx, pix);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_pixmap_components()`. */
FZ_FUNCTION int pixmap_components(const fz_pixmap *pix)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_pixmap_components():" << " auto_ctx=" << auto_ctx << " pix=" << pix << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_pixmap_components(auto_ctx, pix);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_pixmap_height()`. */
FZ_FUNCTION int pixmap_height(const fz_pixmap *pix)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_pixmap_height():" << " auto_ctx=" << auto_ctx << " pix=" << pix << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_pixmap_height(auto_ctx, pix);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_pixmap_image_tile()`. */
FZ_FUNCTION fz_pixmap *pixmap_image_tile(fz_pixmap_image *cimg)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_pixmap_image_tile():" << " auto_ctx=" << auto_ctx << " cimg=" << cimg << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_pixmap_image_tile(auto_ctx, cimg);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_pixmap_samples()`. */
FZ_FUNCTION unsigned char *pixmap_samples(const fz_pixmap *pix)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_pixmap_samples():" << " auto_ctx=" << auto_ctx << " pix=" << pix << "\n";
	}
	unsigned char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_pixmap_samples(auto_ctx, pix);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_pixmap_spots()`. */
FZ_FUNCTION int pixmap_spots(const fz_pixmap *pix)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_pixmap_spots():" << " auto_ctx=" << auto_ctx << " pix=" << pix << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_pixmap_spots(auto_ctx, pix);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_pixmap_stride()`. */
FZ_FUNCTION int pixmap_stride(const fz_pixmap *pix)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_pixmap_stride():" << " auto_ctx=" << auto_ctx << " pix=" << pix << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_pixmap_stride(auto_ctx, pix);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_pixmap_width()`. */
FZ_FUNCTION int pixmap_width(const fz_pixmap *pix)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_pixmap_width():" << " auto_ctx=" << auto_ctx << " pix=" << pix << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_pixmap_width(auto_ctx, pix);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_pixmap_x()`. */
FZ_FUNCTION int pixmap_x(const fz_pixmap *pix)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_pixmap_x():" << " auto_ctx=" << auto_ctx << " pix=" << pix << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_pixmap_x(auto_ctx, pix);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_pixmap_y()`. */
FZ_FUNCTION int pixmap_y(const fz_pixmap *pix)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_pixmap_y():" << " auto_ctx=" << auto_ctx << " pix=" << pix << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_pixmap_y(auto_ctx, pix);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_pool_alloc()`. */
FZ_FUNCTION void *pool_alloc(fz_pool *pool, size_t size)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_pool_alloc():" << " auto_ctx=" << auto_ctx << " pool=" << pool << " size=" << size << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_pool_alloc(auto_ctx, pool, size);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_pool_size()`. */
FZ_FUNCTION size_t pool_size(fz_pool *pool)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_pool_size():" << " auto_ctx=" << auto_ctx << " pool=" << pool << "\n";
	}
	size_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_pool_size(auto_ctx, pool);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_pool_strdup()`. */
FZ_FUNCTION char *pool_strdup(fz_pool *pool, const char *s)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_pool_strdup():" << " auto_ctx=" << auto_ctx << " pool=" << pool << " s=" << s << "\n";
	}
	char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_pool_strdup(auto_ctx, pool, s);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_pop_clip()`. */
FZ_FUNCTION void pop_clip(fz_device *dev)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_pop_clip():" << " auto_ctx=" << auto_ctx << " dev=" << dev << "\n";
	}
	fz_try(auto_ctx) {
		::fz_pop_clip(auto_ctx, dev);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_post_scale()`. */
FZ_FUNCTION fz_matrix post_scale(fz_matrix m, float sx, float sy)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_post_scale():" << " m=" << m << " sx=" << sx << " sy=" << sy << "\n";
	}
	fz_matrix ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_post_scale(m, sx, sy);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_pre_rotate()`. */
FZ_FUNCTION fz_matrix pre_rotate(fz_matrix m, float degrees)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_pre_rotate():" << " m=" << m << " degrees=" << degrees << "\n";
	}
	fz_matrix ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_pre_rotate(m, degrees);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_pre_scale()`. */
FZ_FUNCTION fz_matrix pre_scale(fz_matrix m, float sx, float sy)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_pre_scale():" << " m=" << m << " sx=" << sx << " sy=" << sy << "\n";
	}
	fz_matrix ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_pre_scale(m, sx, sy);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_pre_shear()`. */
FZ_FUNCTION fz_matrix pre_shear(fz_matrix m, float sx, float sy)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_pre_shear():" << " m=" << m << " sx=" << sx << " sy=" << sy << "\n";
	}
	fz_matrix ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_pre_shear(m, sx, sy);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_pre_translate()`. */
FZ_FUNCTION fz_matrix pre_translate(fz_matrix m, float tx, float ty)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_pre_translate():" << " m=" << m << " tx=" << tx << " ty=" << ty << "\n";
	}
	fz_matrix ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_pre_translate(m, tx, ty);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_prepare_t3_glyph()`. */
FZ_FUNCTION void prepare_t3_glyph(fz_font *font, int gid)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_prepare_t3_glyph():" << " auto_ctx=" << auto_ctx << " font=" << font << " gid=" << gid << "\n";
	}
	fz_try(auto_ctx) {
		::fz_prepare_t3_glyph(auto_ctx, font, gid);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_previous_page()`. */
FZ_FUNCTION fz_location previous_page(fz_document *doc, fz_location loc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_previous_page():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " loc=" << loc << "\n";
	}
	fz_location ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_previous_page(auto_ctx, doc, loc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_print_stext_header_as_html()`. */
FZ_FUNCTION void print_stext_header_as_html(fz_output *out)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_print_stext_header_as_html():" << " auto_ctx=" << auto_ctx << " out=" << out << "\n";
	}
	fz_try(auto_ctx) {
		::fz_print_stext_header_as_html(auto_ctx, out);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_print_stext_header_as_xhtml()`. */
FZ_FUNCTION void print_stext_header_as_xhtml(fz_output *out)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_print_stext_header_as_xhtml():" << " auto_ctx=" << auto_ctx << " out=" << out << "\n";
	}
	fz_try(auto_ctx) {
		::fz_print_stext_header_as_xhtml(auto_ctx, out);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_print_stext_page_as_html()`. */
FZ_FUNCTION void print_stext_page_as_html(fz_output *out, fz_stext_page *page, int id)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_print_stext_page_as_html():" << " auto_ctx=" << auto_ctx << " out=" << out << " page=" << page << " id=" << id << "\n";
	}
	fz_try(auto_ctx) {
		::fz_print_stext_page_as_html(auto_ctx, out, page, id);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_print_stext_page_as_json()`. */
FZ_FUNCTION void print_stext_page_as_json(fz_output *out, fz_stext_page *page, float scale)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_print_stext_page_as_json():" << " auto_ctx=" << auto_ctx << " out=" << out << " page=" << page << " scale=" << scale << "\n";
	}
	fz_try(auto_ctx) {
		::fz_print_stext_page_as_json(auto_ctx, out, page, scale);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_print_stext_page_as_text()`. */
FZ_FUNCTION void print_stext_page_as_text(fz_output *out, fz_stext_page *page)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_print_stext_page_as_text():" << " auto_ctx=" << auto_ctx << " out=" << out << " page=" << page << "\n";
	}
	fz_try(auto_ctx) {
		::fz_print_stext_page_as_text(auto_ctx, out, page);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_print_stext_page_as_xhtml()`. */
FZ_FUNCTION void print_stext_page_as_xhtml(fz_output *out, fz_stext_page *page, int id)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_print_stext_page_as_xhtml():" << " auto_ctx=" << auto_ctx << " out=" << out << " page=" << page << " id=" << id << "\n";
	}
	fz_try(auto_ctx) {
		::fz_print_stext_page_as_xhtml(auto_ctx, out, page, id);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_print_stext_page_as_xml()`. */
FZ_FUNCTION void print_stext_page_as_xml(fz_output *out, fz_stext_page *page, int id)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_print_stext_page_as_xml():" << " auto_ctx=" << auto_ctx << " out=" << out << " page=" << page << " id=" << id << "\n";
	}
	fz_try(auto_ctx) {
		::fz_print_stext_page_as_xml(auto_ctx, out, page, id);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_print_stext_trailer_as_html()`. */
FZ_FUNCTION void print_stext_trailer_as_html(fz_output *out)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_print_stext_trailer_as_html():" << " auto_ctx=" << auto_ctx << " out=" << out << "\n";
	}
	fz_try(auto_ctx) {
		::fz_print_stext_trailer_as_html(auto_ctx, out);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_print_stext_trailer_as_xhtml()`. */
FZ_FUNCTION void print_stext_trailer_as_xhtml(fz_output *out)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_print_stext_trailer_as_xhtml():" << " auto_ctx=" << auto_ctx << " out=" << out << "\n";
	}
	fz_try(auto_ctx) {
		::fz_print_stext_trailer_as_xhtml(auto_ctx, out);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_process_opened_pages()`. */
FZ_FUNCTION void *process_opened_pages(fz_document *doc, fz_process_opened_page_fn *process_openend_page, void *state)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_process_opened_pages():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " process_openend_page=" << (void*) process_openend_page << " state=" << (void*) state << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_process_opened_pages(auto_ctx, doc, process_openend_page, state);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_process_shade()`. */
FZ_FUNCTION void process_shade(fz_shade *shade, fz_matrix ctm, fz_rect scissor, fz_shade_prepare_fn *prepare, fz_shade_process_fn *process, void *process_arg)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_process_shade():" << " auto_ctx=" << auto_ctx << " shade=" << shade << " ctm=" << ctm << " scissor=" << scissor << " prepare=" << (void*) prepare << " process=" << (void*) process << " process_arg=" << (void*) process_arg << "\n";
	}
	fz_try(auto_ctx) {
		::fz_process_shade(auto_ctx, shade, ctm, scissor, prepare, process, process_arg);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_purge_glyph_cache()`. */
FZ_FUNCTION void purge_glyph_cache()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_purge_glyph_cache():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_try(auto_ctx) {
		::fz_purge_glyph_cache(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_quad_from_rect()`. */
FZ_FUNCTION fz_quad quad_from_rect(fz_rect r)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_quad_from_rect():" << " r=" << r << "\n";
	}
	fz_quad ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_quad_from_rect(r);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_quadto()`. */
FZ_FUNCTION void quadto(fz_path *path, float x0, float y0, float x1, float y1)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_quadto():" << " auto_ctx=" << auto_ctx << " path=" << path << " x0=" << x0 << " y0=" << y0 << " x1=" << x1 << " y1=" << y1 << "\n";
	}
	fz_try(auto_ctx) {
		::fz_quadto(auto_ctx, path, x0, y0, x1, y1);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_read()`. */
FZ_FUNCTION size_t read(fz_stream *stm, unsigned char *data, size_t len)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_read():" << " auto_ctx=" << auto_ctx << " stm=" << stm << " data=" << (void*) data << " len=" << len << "\n";
	}
	size_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_read(auto_ctx, stm, data, len);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_read_all()`. */
FZ_FUNCTION fz_buffer *read_all(fz_stream *stm, size_t initial)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_read_all():" << " auto_ctx=" << auto_ctx << " stm=" << stm << " initial=" << initial << "\n";
	}
	fz_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_read_all(auto_ctx, stm, initial);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_read_archive_entry()`. */
FZ_FUNCTION fz_buffer *read_archive_entry(fz_archive *arch, const char *name)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_read_archive_entry():" << " auto_ctx=" << auto_ctx << " arch=" << arch << " name=" << name << "\n";
	}
	fz_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_read_archive_entry(auto_ctx, arch, name);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_read_best()`.

This function has out-params. Python/C# wrappers look like:
	`read_best(fz_stream *stm, size_t initial)` => `(fz_buffer *, int truncated)`
*/
FZ_FUNCTION fz_buffer *read_best(fz_stream *stm, size_t initial, int *truncated)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_read_best():" << " auto_ctx=" << auto_ctx << " stm=" << stm << " initial=" << initial << " truncated=" << (void*) truncated << "\n";
	}
	fz_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_read_best(auto_ctx, stm, initial, truncated);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_read_bits()`. */
FZ_FUNCTION unsigned int read_bits(fz_stream *stm, int n)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_read_bits():" << " auto_ctx=" << auto_ctx << " stm=" << stm << " n=" << n << "\n";
	}
	unsigned int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_read_bits(auto_ctx, stm, n);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_read_byte()`. */
FZ_FUNCTION int read_byte(fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_read_byte():" << " auto_ctx=" << auto_ctx << " stm=" << stm << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_read_byte(auto_ctx, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_read_file()`. */
FZ_FUNCTION fz_buffer *read_file(const char *filename)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_read_file():" << " auto_ctx=" << auto_ctx << " filename=" << filename << "\n";
	}
	fz_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_read_file(auto_ctx, filename);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_read_float()`. */
FZ_FUNCTION float read_float(fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_read_float():" << " auto_ctx=" << auto_ctx << " stm=" << stm << "\n";
	}
	float ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_read_float(auto_ctx, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_read_float_le()`. */
FZ_FUNCTION float read_float_le(fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_read_float_le():" << " auto_ctx=" << auto_ctx << " stm=" << stm << "\n";
	}
	float ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_read_float_le(auto_ctx, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_read_int16()`. */
FZ_FUNCTION int16_t read_int16(fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_read_int16():" << " auto_ctx=" << auto_ctx << " stm=" << stm << "\n";
	}
	int16_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_read_int16(auto_ctx, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_read_int16_le()`. */
FZ_FUNCTION int16_t read_int16_le(fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_read_int16_le():" << " auto_ctx=" << auto_ctx << " stm=" << stm << "\n";
	}
	int16_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_read_int16_le(auto_ctx, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_read_int32()`. */
FZ_FUNCTION int32_t read_int32(fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_read_int32():" << " auto_ctx=" << auto_ctx << " stm=" << stm << "\n";
	}
	int32_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_read_int32(auto_ctx, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_read_int32_le()`. */
FZ_FUNCTION int32_t read_int32_le(fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_read_int32_le():" << " auto_ctx=" << auto_ctx << " stm=" << stm << "\n";
	}
	int32_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_read_int32_le(auto_ctx, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_read_int64()`. */
FZ_FUNCTION int64_t read_int64(fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_read_int64():" << " auto_ctx=" << auto_ctx << " stm=" << stm << "\n";
	}
	int64_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_read_int64(auto_ctx, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_read_int64_le()`. */
FZ_FUNCTION int64_t read_int64_le(fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_read_int64_le():" << " auto_ctx=" << auto_ctx << " stm=" << stm << "\n";
	}
	int64_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_read_int64_le(auto_ctx, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_read_line()`. */
FZ_FUNCTION char *read_line(fz_stream *stm, char *buf, size_t max)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_read_line():" << " auto_ctx=" << auto_ctx << " stm=" << stm << " buf=" << (void*) buf << " max=" << max << "\n";
	}
	char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_read_line(auto_ctx, stm, buf, max);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_read_rbits()`. */
FZ_FUNCTION unsigned int read_rbits(fz_stream *stm, int n)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_read_rbits():" << " auto_ctx=" << auto_ctx << " stm=" << stm << " n=" << n << "\n";
	}
	unsigned int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_read_rbits(auto_ctx, stm, n);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_read_string()`. */
FZ_FUNCTION void read_string(fz_stream *stm, char *buffer, int len)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_read_string():" << " auto_ctx=" << auto_ctx << " stm=" << stm << " buffer=" << (void*) buffer << " len=" << len << "\n";
	}
	fz_try(auto_ctx) {
		::fz_read_string(auto_ctx, stm, buffer, len);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_read_uint16()`. */
FZ_FUNCTION uint16_t read_uint16(fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_read_uint16():" << " auto_ctx=" << auto_ctx << " stm=" << stm << "\n";
	}
	uint16_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_read_uint16(auto_ctx, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_read_uint16_le()`. */
FZ_FUNCTION uint16_t read_uint16_le(fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_read_uint16_le():" << " auto_ctx=" << auto_ctx << " stm=" << stm << "\n";
	}
	uint16_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_read_uint16_le(auto_ctx, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_read_uint24()`. */
FZ_FUNCTION uint32_t read_uint24(fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_read_uint24():" << " auto_ctx=" << auto_ctx << " stm=" << stm << "\n";
	}
	uint32_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_read_uint24(auto_ctx, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_read_uint24_le()`. */
FZ_FUNCTION uint32_t read_uint24_le(fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_read_uint24_le():" << " auto_ctx=" << auto_ctx << " stm=" << stm << "\n";
	}
	uint32_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_read_uint24_le(auto_ctx, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_read_uint32()`. */
FZ_FUNCTION uint32_t read_uint32(fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_read_uint32():" << " auto_ctx=" << auto_ctx << " stm=" << stm << "\n";
	}
	uint32_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_read_uint32(auto_ctx, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_read_uint32_le()`. */
FZ_FUNCTION uint32_t read_uint32_le(fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_read_uint32_le():" << " auto_ctx=" << auto_ctx << " stm=" << stm << "\n";
	}
	uint32_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_read_uint32_le(auto_ctx, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_read_uint64()`. */
FZ_FUNCTION uint64_t read_uint64(fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_read_uint64():" << " auto_ctx=" << auto_ctx << " stm=" << stm << "\n";
	}
	uint64_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_read_uint64(auto_ctx, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_read_uint64_le()`. */
FZ_FUNCTION uint64_t read_uint64_le(fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_read_uint64_le():" << " auto_ctx=" << auto_ctx << " stm=" << stm << "\n";
	}
	uint64_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_read_uint64_le(auto_ctx, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_realloc()`. */
FZ_FUNCTION void *realloc(void *p, size_t size)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_realloc():" << " auto_ctx=" << auto_ctx << " p=" << (void*) p << " size=" << size << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_realloc(auto_ctx, p, size);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_realloc_no_throw()`. */
FZ_FUNCTION void *realloc_no_throw(void *p, size_t size)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_realloc_no_throw():" << " auto_ctx=" << auto_ctx << " p=" << (void*) p << " size=" << size << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_realloc_no_throw(auto_ctx, p, size);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_realpath()`. */
FZ_FUNCTION char *realpath(const char *path, char *resolved_path)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_realpath():" << " path=" << path << " resolved_path=" << (void*) resolved_path << "\n";
	}
	char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_realpath(path, resolved_path);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_recognize_document()`. */
FZ_FUNCTION const fz_document_handler *recognize_document(const char *magic)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_recognize_document():" << " auto_ctx=" << auto_ctx << " magic=" << magic << "\n";
	}
	const fz_document_handler * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_recognize_document(auto_ctx, magic);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_recognize_image_format()`. */
FZ_FUNCTION int recognize_image_format(unsigned char p[8])
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_recognize_image_format():" << " auto_ctx=" << auto_ctx << " p=" << p << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_recognize_image_format(auto_ctx, p);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_rect_from_irect()`. */
FZ_FUNCTION fz_rect rect_from_irect(fz_irect bbox)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_rect_from_irect():" << " bbox=" << bbox << "\n";
	}
	fz_rect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_rect_from_irect(bbox);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_rect_from_quad()`. */
FZ_FUNCTION fz_rect rect_from_quad(fz_quad q)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_rect_from_quad():" << " q=" << q << "\n";
	}
	fz_rect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_rect_from_quad(q);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_rectto()`. */
FZ_FUNCTION void rectto(fz_path *path, float x0, float y0, float x1, float y1)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_rectto():" << " auto_ctx=" << auto_ctx << " path=" << path << " x0=" << x0 << " y0=" << y0 << " x1=" << x1 << " y1=" << y1 << "\n";
	}
	fz_try(auto_ctx) {
		::fz_rectto(auto_ctx, path, x0, y0, x1, y1);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_register_document_handler()`. */
FZ_FUNCTION void register_document_handler(const fz_document_handler *handler)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_register_document_handler():" << " auto_ctx=" << auto_ctx << " handler=" << handler << "\n";
	}
	fz_try(auto_ctx) {
		::fz_register_document_handler(auto_ctx, handler);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_register_document_handlers()`. */
FZ_FUNCTION void register_document_handlers()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_register_document_handlers():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_try(auto_ctx) {
		::fz_register_document_handlers(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_remove_item()`. */
FZ_FUNCTION void remove_item(fz_store_drop_fn *drop, void *key, const fz_store_type *type)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_remove_item():" << " auto_ctx=" << auto_ctx << " drop=" << (void*) drop << " key=" << (void*) key << " type=" << type << "\n";
	}
	fz_try(auto_ctx) {
		::fz_remove_item(auto_ctx, drop, key, type);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_render_flags()`. */
FZ_FUNCTION void render_flags(fz_device *dev, int set, int clear)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_render_flags():" << " auto_ctx=" << auto_ctx << " dev=" << dev << " set=" << set << " clear=" << clear << "\n";
	}
	fz_try(auto_ctx) {
		::fz_render_flags(auto_ctx, dev, set, clear);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_render_glyph_pixmap()`. */
FZ_FUNCTION fz_pixmap *render_glyph_pixmap(fz_font *font, int gid, fz_matrix *ctm, const fz_irect *scissor, int aa)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_render_glyph_pixmap():" << " auto_ctx=" << auto_ctx << " font=" << font << " gid=" << gid << " ctm=" << ctm << " scissor=" << scissor << " aa=" << aa << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_render_glyph_pixmap(auto_ctx, font, gid, ctm, scissor, aa);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_render_t3_glyph_direct()`. */
FZ_FUNCTION void render_t3_glyph_direct(fz_device *dev, fz_font *font, int gid, fz_matrix trm, void *gstate, fz_default_colorspaces *def_cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_render_t3_glyph_direct():" << " auto_ctx=" << auto_ctx << " dev=" << dev << " font=" << font << " gid=" << gid << " trm=" << trm << " gstate=" << (void*) gstate << " def_cs=" << def_cs << "\n";
	}
	fz_try(auto_ctx) {
		::fz_render_t3_glyph_direct(auto_ctx, dev, font, gid, trm, gstate, def_cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_rendering_intent_name()`. */
FZ_FUNCTION const char *rendering_intent_name(int ri)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_rendering_intent_name():" << " ri=" << ri << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_rendering_intent_name(ri);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_resize_buffer()`. */
FZ_FUNCTION void resize_buffer(fz_buffer *buf, size_t capacity)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_resize_buffer():" << " auto_ctx=" << auto_ctx << " buf=" << buf << " capacity=" << capacity << "\n";
	}
	fz_try(auto_ctx) {
		::fz_resize_buffer(auto_ctx, buf, capacity);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_resolve_link()`.

This function has out-params. Python/C# wrappers look like:
	`resolve_link(fz_document *doc, const char *uri)` => `(fz_location, float xp, float yp)`
*/
FZ_FUNCTION fz_location resolve_link(fz_document *doc, const char *uri, float *xp, float *yp)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_resolve_link():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " uri=" << uri << " xp=" << (void*) xp << " yp=" << (void*) yp << "\n";
	}
	fz_location ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_resolve_link(auto_ctx, doc, uri, xp, yp);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_resolve_link_dest()`. */
FZ_FUNCTION fz_link_dest resolve_link_dest(fz_document *doc, const char *uri)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_resolve_link_dest():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " uri=" << uri << "\n";
	}
	fz_link_dest ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_resolve_link_dest(auto_ctx, doc, uri);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_rethrow()`. */
FZ_FUNCTION void rethrow()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_rethrow():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_try(auto_ctx) {
		::fz_rethrow(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_rethrow_if()`. */
FZ_FUNCTION void rethrow_if(int errcode)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_rethrow_if():" << " auto_ctx=" << auto_ctx << " errcode=" << errcode << "\n";
	}
	fz_try(auto_ctx) {
		::fz_rethrow_if(auto_ctx, errcode);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_rotate()`. */
FZ_FUNCTION fz_matrix rotate(float degrees)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_rotate():" << " degrees=" << degrees << "\n";
	}
	fz_matrix ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_rotate(degrees);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_round_rect()`. */
FZ_FUNCTION fz_irect round_rect(fz_rect rect)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_round_rect():" << " rect=" << rect << "\n";
	}
	fz_irect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_round_rect(rect);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_run_display_list()`. */
FZ_FUNCTION void run_display_list(fz_display_list *list, fz_device *dev, fz_matrix ctm, fz_rect scissor, fz_cookie *cookie)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_run_display_list():" << " auto_ctx=" << auto_ctx << " list=" << list << " dev=" << dev << " ctm=" << ctm << " scissor=" << scissor << " cookie=" << cookie << "\n";
	}
	fz_try(auto_ctx) {
		::fz_run_display_list(auto_ctx, list, dev, ctm, scissor, cookie);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_run_page()`. */
FZ_FUNCTION void run_page(fz_page *page, fz_device *dev, fz_matrix transform, fz_cookie *cookie)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_run_page():" << " auto_ctx=" << auto_ctx << " page=" << page << " dev=" << dev << " transform=" << transform << " cookie=" << cookie << "\n";
	}
	fz_try(auto_ctx) {
		::fz_run_page(auto_ctx, page, dev, transform, cookie);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_run_page_annots()`. */
FZ_FUNCTION void run_page_annots(fz_page *page, fz_device *dev, fz_matrix transform, fz_cookie *cookie)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_run_page_annots():" << " auto_ctx=" << auto_ctx << " page=" << page << " dev=" << dev << " transform=" << transform << " cookie=" << cookie << "\n";
	}
	fz_try(auto_ctx) {
		::fz_run_page_annots(auto_ctx, page, dev, transform, cookie);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_run_page_contents()`. */
FZ_FUNCTION void run_page_contents(fz_page *page, fz_device *dev, fz_matrix transform, fz_cookie *cookie)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_run_page_contents():" << " auto_ctx=" << auto_ctx << " page=" << page << " dev=" << dev << " transform=" << transform << " cookie=" << cookie << "\n";
	}
	fz_try(auto_ctx) {
		::fz_run_page_contents(auto_ctx, page, dev, transform, cookie);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_run_page_widgets()`. */
FZ_FUNCTION void run_page_widgets(fz_page *page, fz_device *dev, fz_matrix transform, fz_cookie *cookie)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_run_page_widgets():" << " auto_ctx=" << auto_ctx << " page=" << page << " dev=" << dev << " transform=" << transform << " cookie=" << cookie << "\n";
	}
	fz_try(auto_ctx) {
		::fz_run_page_widgets(auto_ctx, page, dev, transform, cookie);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_run_t3_glyph()`. */
FZ_FUNCTION void run_t3_glyph(fz_font *font, int gid, fz_matrix trm, struct fz_device *dev)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_run_t3_glyph():" << " auto_ctx=" << auto_ctx << " font=" << font << " gid=" << gid << " trm=" << trm << " dev=" << dev << "\n";
	}
	fz_try(auto_ctx) {
		::fz_run_t3_glyph(auto_ctx, font, gid, trm, dev);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_runeidx()`. */
FZ_FUNCTION int runeidx(const char *str, const char *p)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_runeidx():" << " str=" << str << " p=" << p << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_runeidx(str, p);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_runelen()`. */
FZ_FUNCTION int runelen(int rune)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_runelen():" << " rune=" << rune << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_runelen(rune);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_runeptr()`. */
FZ_FUNCTION const char *runeptr(const char *str, int idx)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_runeptr():" << " str=" << str << " idx=" << idx << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_runeptr(str, idx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_runetochar()`. */
FZ_FUNCTION int runetochar(char *str, int rune)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_runetochar():" << " str=" << (void*) str << " rune=" << rune << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_runetochar(str, rune);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_save_accelerator()`. */
FZ_FUNCTION void save_accelerator(fz_document *doc, const char *accel)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_save_accelerator():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " accel=" << accel << "\n";
	}
	fz_try(auto_ctx) {
		::fz_save_accelerator(auto_ctx, doc, accel);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_save_bitmap_as_pbm()`. */
FZ_FUNCTION void save_bitmap_as_pbm(fz_bitmap *bitmap, const char *filename)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_save_bitmap_as_pbm():" << " auto_ctx=" << auto_ctx << " bitmap=" << bitmap << " filename=" << filename << "\n";
	}
	fz_try(auto_ctx) {
		::fz_save_bitmap_as_pbm(auto_ctx, bitmap, filename);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_save_bitmap_as_pcl()`. */
FZ_FUNCTION void save_bitmap_as_pcl(fz_bitmap *bitmap, char *filename, int append, const fz_pcl_options *pcl)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_save_bitmap_as_pcl():" << " auto_ctx=" << auto_ctx << " bitmap=" << bitmap << " filename=" << (void*) filename << " append=" << append << " pcl=" << pcl << "\n";
	}
	fz_try(auto_ctx) {
		::fz_save_bitmap_as_pcl(auto_ctx, bitmap, filename, append, pcl);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_save_bitmap_as_pkm()`. */
FZ_FUNCTION void save_bitmap_as_pkm(fz_bitmap *bitmap, const char *filename)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_save_bitmap_as_pkm():" << " auto_ctx=" << auto_ctx << " bitmap=" << bitmap << " filename=" << filename << "\n";
	}
	fz_try(auto_ctx) {
		::fz_save_bitmap_as_pkm(auto_ctx, bitmap, filename);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_save_bitmap_as_pwg()`. */
FZ_FUNCTION void save_bitmap_as_pwg(fz_bitmap *bitmap, char *filename, int append, const fz_pwg_options *pwg)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_save_bitmap_as_pwg():" << " auto_ctx=" << auto_ctx << " bitmap=" << bitmap << " filename=" << (void*) filename << " append=" << append << " pwg=" << pwg << "\n";
	}
	fz_try(auto_ctx) {
		::fz_save_bitmap_as_pwg(auto_ctx, bitmap, filename, append, pwg);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_save_buffer()`. */
FZ_FUNCTION void save_buffer(fz_buffer *buf, const char *filename)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_save_buffer():" << " auto_ctx=" << auto_ctx << " buf=" << buf << " filename=" << filename << "\n";
	}
	fz_try(auto_ctx) {
		::fz_save_buffer(auto_ctx, buf, filename);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_save_pixmap_as_pam()`. */
FZ_FUNCTION void save_pixmap_as_pam(fz_pixmap *pixmap, const char *filename)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_save_pixmap_as_pam():" << " auto_ctx=" << auto_ctx << " pixmap=" << pixmap << " filename=" << filename << "\n";
	}
	fz_try(auto_ctx) {
		::fz_save_pixmap_as_pam(auto_ctx, pixmap, filename);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_save_pixmap_as_pbm()`. */
FZ_FUNCTION void save_pixmap_as_pbm(fz_pixmap *pixmap, const char *filename)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_save_pixmap_as_pbm():" << " auto_ctx=" << auto_ctx << " pixmap=" << pixmap << " filename=" << filename << "\n";
	}
	fz_try(auto_ctx) {
		::fz_save_pixmap_as_pbm(auto_ctx, pixmap, filename);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_save_pixmap_as_pcl()`. */
FZ_FUNCTION void save_pixmap_as_pcl(fz_pixmap *pixmap, char *filename, int append, const fz_pcl_options *pcl)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_save_pixmap_as_pcl():" << " auto_ctx=" << auto_ctx << " pixmap=" << pixmap << " filename=" << (void*) filename << " append=" << append << " pcl=" << pcl << "\n";
	}
	fz_try(auto_ctx) {
		::fz_save_pixmap_as_pcl(auto_ctx, pixmap, filename, append, pcl);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_save_pixmap_as_pclm()`. */
FZ_FUNCTION void save_pixmap_as_pclm(fz_pixmap *pixmap, char *filename, int append, const fz_pclm_options *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_save_pixmap_as_pclm():" << " auto_ctx=" << auto_ctx << " pixmap=" << pixmap << " filename=" << (void*) filename << " append=" << append << " options=" << options << "\n";
	}
	fz_try(auto_ctx) {
		::fz_save_pixmap_as_pclm(auto_ctx, pixmap, filename, append, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_save_pixmap_as_pdfocr()`. */
FZ_FUNCTION void save_pixmap_as_pdfocr(fz_pixmap *pixmap, char *filename, int append, const fz_pdfocr_options *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_save_pixmap_as_pdfocr():" << " auto_ctx=" << auto_ctx << " pixmap=" << pixmap << " filename=" << (void*) filename << " append=" << append << " options=" << options << "\n";
	}
	fz_try(auto_ctx) {
		::fz_save_pixmap_as_pdfocr(auto_ctx, pixmap, filename, append, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_save_pixmap_as_pkm()`. */
FZ_FUNCTION void save_pixmap_as_pkm(fz_pixmap *pixmap, const char *filename)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_save_pixmap_as_pkm():" << " auto_ctx=" << auto_ctx << " pixmap=" << pixmap << " filename=" << filename << "\n";
	}
	fz_try(auto_ctx) {
		::fz_save_pixmap_as_pkm(auto_ctx, pixmap, filename);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_save_pixmap_as_png()`. */
FZ_FUNCTION void save_pixmap_as_png(fz_pixmap *pixmap, const char *filename)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_save_pixmap_as_png():" << " auto_ctx=" << auto_ctx << " pixmap=" << pixmap << " filename=" << filename << "\n";
	}
	fz_try(auto_ctx) {
		::fz_save_pixmap_as_png(auto_ctx, pixmap, filename);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_save_pixmap_as_pnm()`. */
FZ_FUNCTION void save_pixmap_as_pnm(fz_pixmap *pixmap, const char *filename)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_save_pixmap_as_pnm():" << " auto_ctx=" << auto_ctx << " pixmap=" << pixmap << " filename=" << filename << "\n";
	}
	fz_try(auto_ctx) {
		::fz_save_pixmap_as_pnm(auto_ctx, pixmap, filename);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_save_pixmap_as_ps()`. */
FZ_FUNCTION void save_pixmap_as_ps(fz_pixmap *pixmap, char *filename, int append)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_save_pixmap_as_ps():" << " auto_ctx=" << auto_ctx << " pixmap=" << pixmap << " filename=" << (void*) filename << " append=" << append << "\n";
	}
	fz_try(auto_ctx) {
		::fz_save_pixmap_as_ps(auto_ctx, pixmap, filename, append);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_save_pixmap_as_psd()`. */
FZ_FUNCTION void save_pixmap_as_psd(fz_pixmap *pixmap, const char *filename)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_save_pixmap_as_psd():" << " auto_ctx=" << auto_ctx << " pixmap=" << pixmap << " filename=" << filename << "\n";
	}
	fz_try(auto_ctx) {
		::fz_save_pixmap_as_psd(auto_ctx, pixmap, filename);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_save_pixmap_as_pwg()`. */
FZ_FUNCTION void save_pixmap_as_pwg(fz_pixmap *pixmap, char *filename, int append, const fz_pwg_options *pwg)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_save_pixmap_as_pwg():" << " auto_ctx=" << auto_ctx << " pixmap=" << pixmap << " filename=" << (void*) filename << " append=" << append << " pwg=" << pwg << "\n";
	}
	fz_try(auto_ctx) {
		::fz_save_pixmap_as_pwg(auto_ctx, pixmap, filename, append, pwg);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_scale()`. */
FZ_FUNCTION fz_matrix scale(float sx, float sy)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_scale():" << " sx=" << sx << " sy=" << sy << "\n";
	}
	fz_matrix ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_scale(sx, sy);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_search_chapter_page_number()`.

This function has out-params. Python/C# wrappers look like:
	`search_chapter_page_number(fz_document *doc, int chapter, int page, const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
*/
FZ_FUNCTION int search_chapter_page_number(fz_document *doc, int chapter, int page, const char *needle, int *hit_mark, fz_quad *hit_bbox, int hit_max)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_search_chapter_page_number():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " chapter=" << chapter << " page=" << page << " needle=" << needle << " hit_mark=" << (void*) hit_mark << " hit_bbox=" << hit_bbox << " hit_max=" << hit_max << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_search_chapter_page_number(auto_ctx, doc, chapter, page, needle, hit_mark, hit_bbox, hit_max);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_search_display_list()`.

This function has out-params. Python/C# wrappers look like:
	`search_display_list(fz_display_list *list, const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
*/
FZ_FUNCTION int search_display_list(fz_display_list *list, const char *needle, int *hit_mark, fz_quad *hit_bbox, int hit_max)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_search_display_list():" << " auto_ctx=" << auto_ctx << " list=" << list << " needle=" << needle << " hit_mark=" << (void*) hit_mark << " hit_bbox=" << hit_bbox << " hit_max=" << hit_max << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_search_display_list(auto_ctx, list, needle, hit_mark, hit_bbox, hit_max);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_search_page()`.

This function has out-params. Python/C# wrappers look like:
	`search_page(fz_page *page, const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
*/
FZ_FUNCTION int search_page(fz_page *page, const char *needle, int *hit_mark, fz_quad *hit_bbox, int hit_max)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_search_page():" << " auto_ctx=" << auto_ctx << " page=" << page << " needle=" << needle << " hit_mark=" << (void*) hit_mark << " hit_bbox=" << hit_bbox << " hit_max=" << hit_max << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_search_page(auto_ctx, page, needle, hit_mark, hit_bbox, hit_max);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_search_page_number()`.

This function has out-params. Python/C# wrappers look like:
	`search_page_number(fz_document *doc, int number, const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
*/
FZ_FUNCTION int search_page_number(fz_document *doc, int number, const char *needle, int *hit_mark, fz_quad *hit_bbox, int hit_max)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_search_page_number():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " number=" << number << " needle=" << needle << " hit_mark=" << (void*) hit_mark << " hit_bbox=" << hit_bbox << " hit_max=" << hit_max << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_search_page_number(auto_ctx, doc, number, needle, hit_mark, hit_bbox, hit_max);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_search_stext_page()`.

This function has out-params. Python/C# wrappers look like:
	`search_stext_page(fz_stext_page *text, const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
*/
FZ_FUNCTION int search_stext_page(fz_stext_page *text, const char *needle, int *hit_mark, fz_quad *hit_bbox, int hit_max)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_search_stext_page():" << " auto_ctx=" << auto_ctx << " text=" << text << " needle=" << needle << " hit_mark=" << (void*) hit_mark << " hit_bbox=" << hit_bbox << " hit_max=" << hit_max << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_search_stext_page(auto_ctx, text, needle, hit_mark, hit_bbox, hit_max);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_seek()`. */
FZ_FUNCTION void seek(fz_stream *stm, int64_t offset, int whence)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_seek():" << " auto_ctx=" << auto_ctx << " stm=" << stm << " offset=" << offset << " whence=" << whence << "\n";
	}
	fz_try(auto_ctx) {
		::fz_seek(auto_ctx, stm, offset, whence);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_seek_output()`. */
FZ_FUNCTION void seek_output(fz_output *out, int64_t off, int whence)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_seek_output():" << " auto_ctx=" << auto_ctx << " out=" << out << " off=" << off << " whence=" << whence << "\n";
	}
	fz_try(auto_ctx) {
		::fz_seek_output(auto_ctx, out, off, whence);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_separation_current_behavior()`. */
FZ_FUNCTION fz_separation_behavior separation_current_behavior(const fz_separations *sep, int separation)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_separation_current_behavior():" << " auto_ctx=" << auto_ctx << " sep=" << sep << " separation=" << separation << "\n";
	}
	fz_separation_behavior ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_separation_current_behavior(auto_ctx, sep, separation);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_separation_equivalent()`.

This function has out-params. Python/C# wrappers look like:
	`separation_equivalent(const fz_separations *seps, int idx, fz_colorspace *dst_cs, fz_colorspace *prf, fz_color_params color_params)` => float dst_color
*/
FZ_FUNCTION void separation_equivalent(const fz_separations *seps, int idx, fz_colorspace *dst_cs, float *dst_color, fz_colorspace *prf, fz_color_params color_params)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_separation_equivalent():" << " auto_ctx=" << auto_ctx << " seps=" << seps << " idx=" << idx << " dst_cs=" << dst_cs << " dst_color=" << (void*) dst_color << " prf=" << prf << " color_params=" << color_params << "\n";
	}
	fz_try(auto_ctx) {
		::fz_separation_equivalent(auto_ctx, seps, idx, dst_cs, dst_color, prf, color_params);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_separation_name()`. */
FZ_FUNCTION const char *separation_name(const fz_separations *sep, int separation)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_separation_name():" << " auto_ctx=" << auto_ctx << " sep=" << sep << " separation=" << separation << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_separation_name(auto_ctx, sep, separation);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_set_aa_level()`. */
FZ_FUNCTION void set_aa_level(int bits)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_set_aa_level():" << " auto_ctx=" << auto_ctx << " bits=" << bits << "\n";
	}
	fz_try(auto_ctx) {
		::fz_set_aa_level(auto_ctx, bits);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_set_compressed_image_buffer()`. */
FZ_FUNCTION void set_compressed_image_buffer(fz_compressed_image *cimg, fz_compressed_buffer *buf)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_set_compressed_image_buffer():" << " auto_ctx=" << auto_ctx << " cimg=" << cimg << " buf=" << buf << "\n";
	}
	fz_try(auto_ctx) {
		::fz_set_compressed_image_buffer(auto_ctx, cimg, buf);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_set_default_cmyk()`. */
FZ_FUNCTION void set_default_cmyk(fz_default_colorspaces *default_cs, fz_colorspace *cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_set_default_cmyk():" << " auto_ctx=" << auto_ctx << " default_cs=" << default_cs << " cs=" << cs << "\n";
	}
	fz_try(auto_ctx) {
		::fz_set_default_cmyk(auto_ctx, default_cs, cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_set_default_colorspaces()`. */
FZ_FUNCTION void set_default_colorspaces(fz_device *dev, fz_default_colorspaces *default_cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_set_default_colorspaces():" << " auto_ctx=" << auto_ctx << " dev=" << dev << " default_cs=" << default_cs << "\n";
	}
	fz_try(auto_ctx) {
		::fz_set_default_colorspaces(auto_ctx, dev, default_cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_set_default_gray()`. */
FZ_FUNCTION void set_default_gray(fz_default_colorspaces *default_cs, fz_colorspace *cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_set_default_gray():" << " auto_ctx=" << auto_ctx << " default_cs=" << default_cs << " cs=" << cs << "\n";
	}
	fz_try(auto_ctx) {
		::fz_set_default_gray(auto_ctx, default_cs, cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_set_default_output_intent()`. */
FZ_FUNCTION void set_default_output_intent(fz_default_colorspaces *default_cs, fz_colorspace *cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_set_default_output_intent():" << " auto_ctx=" << auto_ctx << " default_cs=" << default_cs << " cs=" << cs << "\n";
	}
	fz_try(auto_ctx) {
		::fz_set_default_output_intent(auto_ctx, default_cs, cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_set_default_rgb()`. */
FZ_FUNCTION void set_default_rgb(fz_default_colorspaces *default_cs, fz_colorspace *cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_set_default_rgb():" << " auto_ctx=" << auto_ctx << " default_cs=" << default_cs << " cs=" << cs << "\n";
	}
	fz_try(auto_ctx) {
		::fz_set_default_rgb(auto_ctx, default_cs, cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_set_error_callback()`. */
FZ_FUNCTION void set_error_callback(fz_error_cb *error_cb, void *user)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_set_error_callback():" << " auto_ctx=" << auto_ctx << " error_cb=" << (void*) error_cb << " user=" << (void*) user << "\n";
	}
	fz_try(auto_ctx) {
		::fz_set_error_callback(auto_ctx, error_cb, user);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_set_font_bbox()`. */
FZ_FUNCTION void set_font_bbox(fz_font *font, float xmin, float ymin, float xmax, float ymax)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_set_font_bbox():" << " auto_ctx=" << auto_ctx << " font=" << font << " xmin=" << xmin << " ymin=" << ymin << " xmax=" << xmax << " ymax=" << ymax << "\n";
	}
	fz_try(auto_ctx) {
		::fz_set_font_bbox(auto_ctx, font, xmin, ymin, xmax, ymax);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_set_graphics_aa_level()`. */
FZ_FUNCTION void set_graphics_aa_level(int bits)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_set_graphics_aa_level():" << " auto_ctx=" << auto_ctx << " bits=" << bits << "\n";
	}
	fz_try(auto_ctx) {
		::fz_set_graphics_aa_level(auto_ctx, bits);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_set_graphics_min_line_width()`. */
FZ_FUNCTION void set_graphics_min_line_width(float min_line_width)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_set_graphics_min_line_width():" << " auto_ctx=" << auto_ctx << " min_line_width=" << min_line_width << "\n";
	}
	fz_try(auto_ctx) {
		::fz_set_graphics_min_line_width(auto_ctx, min_line_width);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_set_metadata()`. */
FZ_FUNCTION void set_metadata(fz_document *doc, const char *key, const char *value)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_set_metadata():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " key=" << key << " value=" << value << "\n";
	}
	fz_try(auto_ctx) {
		::fz_set_metadata(auto_ctx, doc, key, value);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_set_pixmap_image_tile()`. */
FZ_FUNCTION void set_pixmap_image_tile(fz_pixmap_image *cimg, fz_pixmap *pix)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_set_pixmap_image_tile():" << " auto_ctx=" << auto_ctx << " cimg=" << cimg << " pix=" << pix << "\n";
	}
	fz_try(auto_ctx) {
		::fz_set_pixmap_image_tile(auto_ctx, cimg, pix);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_set_pixmap_resolution()`. */
FZ_FUNCTION void set_pixmap_resolution(fz_pixmap *pix, int xres, int yres)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_set_pixmap_resolution():" << " auto_ctx=" << auto_ctx << " pix=" << pix << " xres=" << xres << " yres=" << yres << "\n";
	}
	fz_try(auto_ctx) {
		::fz_set_pixmap_resolution(auto_ctx, pix, xres, yres);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_set_separation_behavior()`. */
FZ_FUNCTION void set_separation_behavior(fz_separations *sep, int separation, fz_separation_behavior behavior)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_set_separation_behavior():" << " auto_ctx=" << auto_ctx << " sep=" << sep << " separation=" << separation << " behavior=" << behavior << "\n";
	}
	fz_try(auto_ctx) {
		::fz_set_separation_behavior(auto_ctx, sep, separation, behavior);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_set_stddbg()`. */
FZ_FUNCTION void set_stddbg(fz_output *out)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_set_stddbg():" << " auto_ctx=" << auto_ctx << " out=" << out << "\n";
	}
	fz_try(auto_ctx) {
		::fz_set_stddbg(auto_ctx, out);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_set_text_aa_level()`. */
FZ_FUNCTION void set_text_aa_level(int bits)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_set_text_aa_level():" << " auto_ctx=" << auto_ctx << " bits=" << bits << "\n";
	}
	fz_try(auto_ctx) {
		::fz_set_text_aa_level(auto_ctx, bits);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_set_use_document_css()`. */
FZ_FUNCTION void set_use_document_css(int use)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_set_use_document_css():" << " auto_ctx=" << auto_ctx << " use=" << use << "\n";
	}
	fz_try(auto_ctx) {
		::fz_set_use_document_css(auto_ctx, use);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_set_user_context()`. */
FZ_FUNCTION void set_user_context(void *user)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_set_user_context():" << " auto_ctx=" << auto_ctx << " user=" << (void*) user << "\n";
	}
	fz_try(auto_ctx) {
		::fz_set_user_context(auto_ctx, user);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_set_user_css()`. */
FZ_FUNCTION void set_user_css(const char *text)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_set_user_css():" << " auto_ctx=" << auto_ctx << " text=" << text << "\n";
	}
	fz_try(auto_ctx) {
		::fz_set_user_css(auto_ctx, text);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_set_warning_callback()`. */
FZ_FUNCTION void set_warning_callback(fz_warning_cb *warning_cb, void *user)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_set_warning_callback():" << " auto_ctx=" << auto_ctx << " warning_cb=" << (void*) warning_cb << " user=" << (void*) user << "\n";
	}
	fz_try(auto_ctx) {
		::fz_set_warning_callback(auto_ctx, warning_cb, user);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_sha256_final()`. */
FZ_FUNCTION void sha256_final(fz_sha256 *state, unsigned char digest[32])
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_sha256_final():" << " state=" << state << " digest=" << digest << "\n";
	}
	fz_try(auto_ctx) {
		::fz_sha256_final(state, digest);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_sha256_init()`. */
FZ_FUNCTION void sha256_init(fz_sha256 *state)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_sha256_init():" << " state=" << state << "\n";
	}
	fz_try(auto_ctx) {
		::fz_sha256_init(state);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_sha256_update()`. */
FZ_FUNCTION void sha256_update(fz_sha256 *state, const unsigned char *input, size_t inlen)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_sha256_update():" << " state=" << state << " input=" << (void*) input << " inlen=" << inlen << "\n";
	}
	fz_try(auto_ctx) {
		::fz_sha256_update(state, input, inlen);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_sha384_final()`. */
FZ_FUNCTION void sha384_final(fz_sha384 *state, unsigned char digest[64])
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_sha384_final():" << " state=" << state << " digest=" << digest << "\n";
	}
	fz_try(auto_ctx) {
		::fz_sha384_final(state, digest);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_sha384_init()`. */
FZ_FUNCTION void sha384_init(fz_sha384 *state)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_sha384_init():" << " state=" << state << "\n";
	}
	fz_try(auto_ctx) {
		::fz_sha384_init(state);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_sha384_update()`. */
FZ_FUNCTION void sha384_update(fz_sha384 *state, const unsigned char *input, size_t inlen)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_sha384_update():" << " state=" << state << " input=" << (void*) input << " inlen=" << inlen << "\n";
	}
	fz_try(auto_ctx) {
		::fz_sha384_update(state, input, inlen);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_sha512_final()`. */
FZ_FUNCTION void sha512_final(fz_sha512 *state, unsigned char digest[64])
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_sha512_final():" << " state=" << state << " digest=" << digest << "\n";
	}
	fz_try(auto_ctx) {
		::fz_sha512_final(state, digest);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_sha512_init()`. */
FZ_FUNCTION void sha512_init(fz_sha512 *state)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_sha512_init():" << " state=" << state << "\n";
	}
	fz_try(auto_ctx) {
		::fz_sha512_init(state);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_sha512_update()`. */
FZ_FUNCTION void sha512_update(fz_sha512 *state, const unsigned char *input, size_t inlen)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_sha512_update():" << " state=" << state << " input=" << (void*) input << " inlen=" << inlen << "\n";
	}
	fz_try(auto_ctx) {
		::fz_sha512_update(state, input, inlen);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_shear()`. */
FZ_FUNCTION fz_matrix shear(float sx, float sy)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_shear():" << " sx=" << sx << " sy=" << sy << "\n";
	}
	fz_matrix ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_shear(sx, sy);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_show_glyph()`. */
FZ_FUNCTION void show_glyph(fz_text *text, fz_font *font, fz_matrix trm, int glyph, int unicode, int wmode, int bidi_level, fz_bidi_direction markup_dir, fz_text_language language)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_show_glyph():" << " auto_ctx=" << auto_ctx << " text=" << text << " font=" << font << " trm=" << trm << " glyph=" << glyph << " unicode=" << unicode << " wmode=" << wmode << " bidi_level=" << bidi_level << " markup_dir=" << markup_dir << " language=" << language << "\n";
	}
	fz_try(auto_ctx) {
		::fz_show_glyph(auto_ctx, text, font, trm, glyph, unicode, wmode, bidi_level, markup_dir, language);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_show_string()`. */
FZ_FUNCTION fz_matrix show_string(fz_text *text, fz_font *font, fz_matrix trm, const char *s, int wmode, int bidi_level, fz_bidi_direction markup_dir, fz_text_language language)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_show_string():" << " auto_ctx=" << auto_ctx << " text=" << text << " font=" << font << " trm=" << trm << " s=" << s << " wmode=" << wmode << " bidi_level=" << bidi_level << " markup_dir=" << markup_dir << " language=" << language << "\n";
	}
	fz_matrix ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_show_string(auto_ctx, text, font, trm, s, wmode, bidi_level, markup_dir, language);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_shrink_store()`. */
FZ_FUNCTION int shrink_store(unsigned int percent)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_shrink_store():" << " auto_ctx=" << auto_ctx << " percent=" << percent << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_shrink_store(auto_ctx, percent);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_skip()`. */
FZ_FUNCTION size_t skip(fz_stream *stm, size_t len)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_skip():" << " auto_ctx=" << auto_ctx << " stm=" << stm << " len=" << len << "\n";
	}
	size_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_skip(auto_ctx, stm, len);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_skip_space()`. */
FZ_FUNCTION void skip_space(fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_skip_space():" << " auto_ctx=" << auto_ctx << " stm=" << stm << "\n";
	}
	fz_try(auto_ctx) {
		::fz_skip_space(auto_ctx, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_skip_string()`. */
FZ_FUNCTION int skip_string(fz_stream *stm, const char *str)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_skip_string():" << " auto_ctx=" << auto_ctx << " stm=" << stm << " str=" << str << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_skip_string(auto_ctx, stm, str);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_snap_selection()`. */
FZ_FUNCTION fz_quad snap_selection(fz_stext_page *page, fz_point *ap, fz_point *bp, int mode)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_snap_selection():" << " auto_ctx=" << auto_ctx << " page=" << page << " ap=" << ap << " bp=" << bp << " mode=" << mode << "\n";
	}
	fz_quad ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_snap_selection(auto_ctx, page, ap, bp, mode);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_start_throw_on_repair()`. */
FZ_FUNCTION void start_throw_on_repair()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_start_throw_on_repair():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_try(auto_ctx) {
		::fz_start_throw_on_repair(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_stat_mtime()`. */
FZ_FUNCTION int64_t stat_mtime(const char *path)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_stat_mtime():" << " path=" << path << "\n";
	}
	int64_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_stat_mtime(path);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_stddbg()`. */
FZ_FUNCTION fz_output *stddbg()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_stddbg():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_output * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_stddbg(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_stderr()`. */
FZ_FUNCTION fz_output *stderr_()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_stderr():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_output * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_stderr(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_stdout()`. */
FZ_FUNCTION fz_output *stdout_()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_stdout():" << " auto_ctx=" << auto_ctx << "\n";
	}
	fz_output * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_stdout(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_store_item()`. */
FZ_FUNCTION void *store_item(void *key, void *val, size_t itemsize, const fz_store_type *type)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_store_item():" << " auto_ctx=" << auto_ctx << " key=" << (void*) key << " val=" << (void*) val << " itemsize=" << itemsize << " type=" << type << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_store_item(auto_ctx, key, val, itemsize, type);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_store_scavenge()`.

This function has out-params. Python/C# wrappers look like:
	`store_scavenge(size_t size)` => `(int, int phase)`
*/
FZ_FUNCTION int store_scavenge(size_t size, int *phase)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_store_scavenge():" << " auto_ctx=" << auto_ctx << " size=" << size << " phase=" << (void*) phase << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_store_scavenge(auto_ctx, size, phase);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_store_scavenge_external()`.

This function has out-params. Python/C# wrappers look like:
	`store_scavenge_external(size_t size)` => `(int, int phase)`
*/
FZ_FUNCTION int store_scavenge_external(size_t size, int *phase)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_store_scavenge_external():" << " auto_ctx=" << auto_ctx << " size=" << size << " phase=" << (void*) phase << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_store_scavenge_external(auto_ctx, size, phase);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_strcasecmp()`. */
FZ_FUNCTION int strcasecmp(const char *a, const char *b)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_strcasecmp():" << " a=" << a << " b=" << b << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_strcasecmp(a, b);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_strdup()`. */
FZ_FUNCTION char *strdup(const char *s)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_strdup():" << " auto_ctx=" << auto_ctx << " s=" << s << "\n";
	}
	char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_strdup(auto_ctx, s);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_stream_from_output()`. */
FZ_FUNCTION fz_stream *stream_from_output(fz_output *arg_1)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_stream_from_output():" << " auto_ctx=" << auto_ctx << " arg_1=" << arg_1 << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_stream_from_output(auto_ctx, arg_1);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_string_from_buffer()`. */
FZ_FUNCTION const char *string_from_buffer(fz_buffer *buf)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_string_from_buffer():" << " auto_ctx=" << auto_ctx << " buf=" << buf << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_string_from_buffer(auto_ctx, buf);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_string_from_text_language()`. */
FZ_FUNCTION char *string_from_text_language(char str[8], fz_text_language lang)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_string_from_text_language():" << " str=" << str << " lang=" << lang << "\n";
	}
	char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_string_from_text_language(str, lang);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_strlcat()`. */
FZ_FUNCTION size_t strlcat(char *dst, const char *src, size_t n)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_strlcat():" << " dst=" << (void*) dst << " src=" << src << " n=" << n << "\n";
	}
	size_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_strlcat(dst, src, n);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_strlcpy()`. */
FZ_FUNCTION size_t strlcpy(char *dst, const char *src, size_t n)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_strlcpy():" << " dst=" << (void*) dst << " src=" << src << " n=" << n << "\n";
	}
	size_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_strlcpy(dst, src, n);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_strncasecmp()`. */
FZ_FUNCTION int strncasecmp(const char *a, const char *b, size_t n)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_strncasecmp():" << " a=" << a << " b=" << b << " n=" << n << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_strncasecmp(a, b, n);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_strnlen()`. */
FZ_FUNCTION size_t strnlen(const char *s, size_t maxlen)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_strnlen():" << " s=" << s << " maxlen=" << maxlen << "\n";
	}
	size_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_strnlen(s, maxlen);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_stroke_path()`. */
FZ_FUNCTION void stroke_path(fz_device *dev, const fz_path *path, const fz_stroke_state *stroke, fz_matrix ctm, fz_colorspace *colorspace, const float *color, float alpha, fz_color_params color_params)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_stroke_path():" << " auto_ctx=" << auto_ctx << " dev=" << dev << " path=" << path << " stroke=" << stroke << " ctm=" << ctm << " colorspace=" << colorspace << " color=" << (void*) color << " alpha=" << alpha << " color_params=" << color_params << "\n";
	}
	fz_try(auto_ctx) {
		::fz_stroke_path(auto_ctx, dev, path, stroke, ctm, colorspace, color, alpha, color_params);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_stroke_text()`. */
FZ_FUNCTION void stroke_text(fz_device *dev, const fz_text *text, const fz_stroke_state *stroke, fz_matrix ctm, fz_colorspace *colorspace, const float *color, float alpha, fz_color_params color_params)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_stroke_text():" << " auto_ctx=" << auto_ctx << " dev=" << dev << " text=" << text << " stroke=" << stroke << " ctm=" << ctm << " colorspace=" << colorspace << " color=" << (void*) color << " alpha=" << alpha << " color_params=" << color_params << "\n";
	}
	fz_try(auto_ctx) {
		::fz_stroke_text(auto_ctx, dev, text, stroke, ctm, colorspace, color, alpha, color_params);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_strsep()`.

This function has out-params. Python/C# wrappers look like:
	`strsep(const char *delim)` => `(char *, char *stringp)`
*/
FZ_FUNCTION char *strsep(char **stringp, const char *delim)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_strsep():" << " stringp=" << (void*) stringp << " delim=" << delim << "\n";
	}
	char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_strsep(stringp, delim);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_strtof()`.

This function has out-params. Python/C# wrappers look like:
	`strtof(const char *s)` => `(float, char *es)`
*/
FZ_FUNCTION float strtof(const char *s, char **es)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_strtof():" << " s=" << s << " es=" << (void*) es << "\n";
	}
	float ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_strtof(s, es);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_subpixel_adjust()`. */
FZ_FUNCTION float subpixel_adjust(fz_matrix *ctm, fz_matrix *subpix_ctm, unsigned char *qe, unsigned char *qf)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_subpixel_adjust():" << " auto_ctx=" << auto_ctx << " ctm=" << ctm << " subpix_ctm=" << subpix_ctm << " qe=" << (void*) qe << " qf=" << (void*) qf << "\n";
	}
	float ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_subpixel_adjust(auto_ctx, ctm, subpix_ctm, qe, qf);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_sync_bits()`. */
FZ_FUNCTION void sync_bits(fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_sync_bits():" << " auto_ctx=" << auto_ctx << " stm=" << stm << "\n";
	}
	fz_try(auto_ctx) {
		::fz_sync_bits(auto_ctx, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_tell()`. */
FZ_FUNCTION int64_t tell(fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_tell():" << " auto_ctx=" << auto_ctx << " stm=" << stm << "\n";
	}
	int64_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_tell(auto_ctx, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_tell_output()`. */
FZ_FUNCTION int64_t tell_output(fz_output *out)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_tell_output():" << " auto_ctx=" << auto_ctx << " out=" << out << "\n";
	}
	int64_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_tell_output(auto_ctx, out);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_terminate_buffer()`. */
FZ_FUNCTION void terminate_buffer(fz_buffer *buf)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_terminate_buffer():" << " auto_ctx=" << auto_ctx << " buf=" << buf << "\n";
	}
	fz_try(auto_ctx) {
		::fz_terminate_buffer(auto_ctx, buf);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_text_aa_level()`. */
FZ_FUNCTION int text_aa_level()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_text_aa_level():" << " auto_ctx=" << auto_ctx << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_text_aa_level(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_text_language_from_string()`. */
FZ_FUNCTION fz_text_language text_language_from_string(const char *str)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_text_language_from_string():" << " str=" << str << "\n";
	}
	fz_text_language ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_text_language_from_string(str);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_tint_pixmap()`. */
FZ_FUNCTION void tint_pixmap(fz_pixmap *pix, int black, int white)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_tint_pixmap():" << " auto_ctx=" << auto_ctx << " pix=" << pix << " black=" << black << " white=" << white << "\n";
	}
	fz_try(auto_ctx) {
		::fz_tint_pixmap(auto_ctx, pix, black, white);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_tolower()`. */
FZ_FUNCTION int tolower(int c)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_tolower():" << " c=" << c << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_tolower(c);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_toupper()`. */
FZ_FUNCTION int toupper(int c)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_toupper():" << " c=" << c << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_toupper(c);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_transform_page()`. */
FZ_FUNCTION fz_matrix transform_page(fz_rect mediabox, float resolution, float rotate)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_transform_page():" << " mediabox=" << mediabox << " resolution=" << resolution << " rotate=" << rotate << "\n";
	}
	fz_matrix ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_transform_page(mediabox, resolution, rotate);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_transform_path()`. */
FZ_FUNCTION void transform_path(fz_path *path, fz_matrix transform)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_transform_path():" << " auto_ctx=" << auto_ctx << " path=" << path << " transform=" << transform << "\n";
	}
	fz_try(auto_ctx) {
		::fz_transform_path(auto_ctx, path, transform);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_transform_point()`. */
FZ_FUNCTION fz_point transform_point(fz_point point, fz_matrix m)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_transform_point():" << " point=" << point << " m=" << m << "\n";
	}
	fz_point ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_transform_point(point, m);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_transform_point_xy()`. */
FZ_FUNCTION fz_point transform_point_xy(float x, float y, fz_matrix m)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_transform_point_xy():" << " x=" << x << " y=" << y << " m=" << m << "\n";
	}
	fz_point ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_transform_point_xy(x, y, m);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_transform_quad()`. */
FZ_FUNCTION fz_quad transform_quad(fz_quad q, fz_matrix m)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_transform_quad():" << " q=" << q << " m=" << m << "\n";
	}
	fz_quad ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_transform_quad(q, m);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_transform_rect()`. */
FZ_FUNCTION fz_rect transform_rect(fz_rect rect, fz_matrix m)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_transform_rect():" << " rect=" << rect << " m=" << m << "\n";
	}
	fz_rect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_transform_rect(rect, m);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_transform_vector()`. */
FZ_FUNCTION fz_point transform_vector(fz_point vector, fz_matrix m)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_transform_vector():" << " vector=" << vector << " m=" << m << "\n";
	}
	fz_point ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_transform_vector(vector, m);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_translate()`. */
FZ_FUNCTION fz_matrix translate(float tx, float ty)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_translate():" << " tx=" << tx << " ty=" << ty << "\n";
	}
	fz_matrix ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_translate(tx, ty);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_translate_irect()`. */
FZ_FUNCTION fz_irect translate_irect(fz_irect a, int xoff, int yoff)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_translate_irect():" << " a=" << a << " xoff=" << xoff << " yoff=" << yoff << "\n";
	}
	fz_irect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_translate_irect(a, xoff, yoff);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_translate_rect()`. */
FZ_FUNCTION fz_rect translate_rect(fz_rect a, float xoff, float yoff)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_translate_rect():" << " a=" << a << " xoff=" << xoff << " yoff=" << yoff << "\n";
	}
	fz_rect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_translate_rect(a, xoff, yoff);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_tree_insert()`. */
FZ_FUNCTION fz_tree *tree_insert(fz_tree *root, const char *key, void *value)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_tree_insert():" << " auto_ctx=" << auto_ctx << " root=" << root << " key=" << key << " value=" << (void*) value << "\n";
	}
	fz_tree * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_tree_insert(auto_ctx, root, key, value);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_tree_lookup()`. */
FZ_FUNCTION void *tree_lookup(fz_tree *node, const char *key)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_tree_lookup():" << " auto_ctx=" << auto_ctx << " node=" << node << " key=" << key << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_tree_lookup(auto_ctx, node, key);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_trim_buffer()`. */
FZ_FUNCTION void trim_buffer(fz_buffer *buf)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_trim_buffer():" << " auto_ctx=" << auto_ctx << " buf=" << buf << "\n";
	}
	fz_try(auto_ctx) {
		::fz_trim_buffer(auto_ctx, buf);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_trim_path()`. */
FZ_FUNCTION void trim_path(fz_path *path)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_trim_path():" << " auto_ctx=" << auto_ctx << " path=" << path << "\n";
	}
	fz_try(auto_ctx) {
		::fz_trim_path(auto_ctx, path);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_truncate_output()`. */
FZ_FUNCTION void truncate_output(fz_output *arg_1)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_truncate_output():" << " auto_ctx=" << auto_ctx << " arg_1=" << arg_1 << "\n";
	}
	fz_try(auto_ctx) {
		::fz_truncate_output(auto_ctx, arg_1);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_try_invert_matrix()`. */
FZ_FUNCTION int try_invert_matrix(fz_matrix *inv, fz_matrix src)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_try_invert_matrix():" << " inv=" << inv << " src=" << src << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_try_invert_matrix(inv, src);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_tune_image_decode()`. */
FZ_FUNCTION void tune_image_decode(fz_tune_image_decode_fn *image_decode, void *arg)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_tune_image_decode():" << " auto_ctx=" << auto_ctx << " image_decode=" << (void*) image_decode << " arg=" << (void*) arg << "\n";
	}
	fz_try(auto_ctx) {
		::fz_tune_image_decode(auto_ctx, image_decode, arg);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_tune_image_scale()`. */
FZ_FUNCTION void tune_image_scale(fz_tune_image_scale_fn *image_scale, void *arg)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_tune_image_scale():" << " auto_ctx=" << auto_ctx << " image_scale=" << (void*) image_scale << " arg=" << (void*) arg << "\n";
	}
	fz_try(auto_ctx) {
		::fz_tune_image_scale(auto_ctx, image_scale, arg);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_unicode_from_glyph_name()`. */
FZ_FUNCTION int unicode_from_glyph_name(const char *name)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_unicode_from_glyph_name():" << " name=" << name << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_unicode_from_glyph_name(name);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_unicode_from_glyph_name_strict()`. */
FZ_FUNCTION int unicode_from_glyph_name_strict(const char *name)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_unicode_from_glyph_name_strict():" << " name=" << name << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_unicode_from_glyph_name_strict(name);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_union_rect()`. */
FZ_FUNCTION fz_rect union_rect(fz_rect a, fz_rect b)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_union_rect():" << " a=" << a << " b=" << b << "\n";
	}
	fz_rect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_union_rect(a, b);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_unlock()`. */
FZ_FUNCTION void unlock(int lock)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_unlock():" << " auto_ctx=" << auto_ctx << " lock=" << lock << "\n";
	}
	fz_try(auto_ctx) {
		::fz_unlock(auto_ctx, lock);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_unpack_stream()`. */
FZ_FUNCTION fz_stream *unpack_stream(fz_stream *src, int depth, int w, int h, int n, int indexed, int pad, int skip)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_unpack_stream():" << " auto_ctx=" << auto_ctx << " src=" << src << " depth=" << depth << " w=" << w << " h=" << h << " n=" << n << " indexed=" << indexed << " pad=" << pad << " skip=" << skip << "\n";
	}
	fz_stream * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_unpack_stream(auto_ctx, src, depth, w, h, n, indexed, pad, skip);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_unread_byte()`. */
FZ_FUNCTION void unread_byte(fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_unread_byte():" << " auto_ctx=" << auto_ctx << " stm=" << stm << "\n";
	}
	fz_try(auto_ctx) {
		::fz_unread_byte(auto_ctx, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_unshare_stroke_state()`. */
FZ_FUNCTION fz_stroke_state *unshare_stroke_state(fz_stroke_state *shared)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_unshare_stroke_state():" << " auto_ctx=" << auto_ctx << " shared=" << shared << "\n";
	}
	fz_stroke_state * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_unshare_stroke_state(auto_ctx, shared);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_unshare_stroke_state_with_dash_len()`. */
FZ_FUNCTION fz_stroke_state *unshare_stroke_state_with_dash_len(fz_stroke_state *shared, int len)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_unshare_stroke_state_with_dash_len():" << " auto_ctx=" << auto_ctx << " shared=" << shared << " len=" << len << "\n";
	}
	fz_stroke_state * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_unshare_stroke_state_with_dash_len(auto_ctx, shared, len);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_urldecode()`. */
FZ_FUNCTION char *urldecode(char *url)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_urldecode():" << " url=" << (void*) url << "\n";
	}
	char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_urldecode(url);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_use_document_css()`. */
FZ_FUNCTION int use_document_css()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_use_document_css():" << " auto_ctx=" << auto_ctx << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_use_document_css(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_user_context()`. */
FZ_FUNCTION void *user_context()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_user_context():" << " auto_ctx=" << auto_ctx << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_user_context(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_user_css()`. */
FZ_FUNCTION const char *user_css()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_user_css():" << " auto_ctx=" << auto_ctx << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_user_css(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_utflen()`. */
FZ_FUNCTION int utflen(const char *s)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_utflen():" << " s=" << s << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_utflen(s);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_var_imp()`. */
FZ_FUNCTION void var_imp(void *arg_0)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_var_imp():" << " arg_0=" << (void*) arg_0 << "\n";
	}
	fz_try(auto_ctx) {
		::fz_var_imp(arg_0);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_vsnprintf()`. */
FZ_FUNCTION size_t vsnprintf(char *buffer, size_t space, const char *fmt, va_list args)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_vsnprintf():" << " buffer=" << (void*) buffer << " space=" << space << " fmt=" << fmt << " args=" << args << "\n";
	}
	size_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_vsnprintf(buffer, space, fmt, args);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_vthrow()`. */
FZ_FUNCTION void vthrow(int errcode, const char *arg_2, va_list ap)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_vthrow():" << " auto_ctx=" << auto_ctx << " errcode=" << errcode << " arg_2=" << arg_2 << " ap=" << ap << "\n";
	}
	fz_try(auto_ctx) {
		::fz_vthrow(auto_ctx, errcode, arg_2, ap);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_vwarn()`. */
FZ_FUNCTION void vwarn(const char *fmt, va_list ap)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_vwarn():" << " auto_ctx=" << auto_ctx << " fmt=" << fmt << " ap=" << ap << "\n";
	}
	fz_try(auto_ctx) {
		::fz_vwarn(auto_ctx, fmt, ap);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_walk_path()`. */
FZ_FUNCTION void walk_path(const fz_path *path, const fz_path_walker *walker, void *arg)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_walk_path():" << " auto_ctx=" << auto_ctx << " path=" << path << " walker=" << walker << " arg=" << (void*) arg << "\n";
	}
	fz_try(auto_ctx) {
		::fz_walk_path(auto_ctx, path, walker, arg);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_warning_callback()`.

This function has out-params. Python/C# wrappers look like:
	`warning_callback()` => `(fz_warning_cb *, void *user)`
*/
FZ_FUNCTION fz_warning_cb *warning_callback(void **user)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_warning_callback():" << " auto_ctx=" << auto_ctx << " user=" << (void*) user << "\n";
	}
	fz_warning_cb * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_warning_callback(auto_ctx, user);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_warp_pixmap()`. */
FZ_FUNCTION fz_pixmap *warp_pixmap(fz_pixmap *src, const fz_point points[4], int width, int height)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_warp_pixmap():" << " auto_ctx=" << auto_ctx << " src=" << src << " points=" << points << " width=" << width << " height=" << height << "\n";
	}
	fz_pixmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_warp_pixmap(auto_ctx, src, points, width, height);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_windows_1250_from_unicode()`. */
FZ_FUNCTION int windows_1250_from_unicode(int u)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_windows_1250_from_unicode():" << " u=" << u << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_windows_1250_from_unicode(u);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_windows_1251_from_unicode()`. */
FZ_FUNCTION int windows_1251_from_unicode(int u)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_windows_1251_from_unicode():" << " u=" << u << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_windows_1251_from_unicode(u);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_windows_1252_from_unicode()`. */
FZ_FUNCTION int windows_1252_from_unicode(int u)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_windows_1252_from_unicode():" << " u=" << u << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_windows_1252_from_unicode(u);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_write_band()`. */
FZ_FUNCTION void write_band(fz_band_writer *writer, int stride, int band_height, const unsigned char *samples)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_band():" << " auto_ctx=" << auto_ctx << " writer=" << writer << " stride=" << stride << " band_height=" << band_height << " samples=" << (void*) samples << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_band(auto_ctx, writer, stride, band_height, samples);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_base64()`. */
FZ_FUNCTION void write_base64(fz_output *out, const unsigned char *data, size_t size, int newline)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_base64():" << " auto_ctx=" << auto_ctx << " out=" << out << " data=" << (void*) data << " size=" << size << " newline=" << newline << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_base64(auto_ctx, out, data, size, newline);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_base64_buffer()`. */
FZ_FUNCTION void write_base64_buffer(fz_output *out, fz_buffer *data, int newline)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_base64_buffer():" << " auto_ctx=" << auto_ctx << " out=" << out << " data=" << data << " newline=" << newline << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_base64_buffer(auto_ctx, out, data, newline);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_bitmap_as_pbm()`. */
FZ_FUNCTION void write_bitmap_as_pbm(fz_output *out, fz_bitmap *bitmap)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_bitmap_as_pbm():" << " auto_ctx=" << auto_ctx << " out=" << out << " bitmap=" << bitmap << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_bitmap_as_pbm(auto_ctx, out, bitmap);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_bitmap_as_pcl()`. */
FZ_FUNCTION void write_bitmap_as_pcl(fz_output *out, const fz_bitmap *bitmap, const fz_pcl_options *pcl)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_bitmap_as_pcl():" << " auto_ctx=" << auto_ctx << " out=" << out << " bitmap=" << bitmap << " pcl=" << pcl << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_bitmap_as_pcl(auto_ctx, out, bitmap, pcl);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_bitmap_as_pkm()`. */
FZ_FUNCTION void write_bitmap_as_pkm(fz_output *out, fz_bitmap *bitmap)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_bitmap_as_pkm():" << " auto_ctx=" << auto_ctx << " out=" << out << " bitmap=" << bitmap << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_bitmap_as_pkm(auto_ctx, out, bitmap);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_bitmap_as_pwg()`. */
FZ_FUNCTION void write_bitmap_as_pwg(fz_output *out, const fz_bitmap *bitmap, const fz_pwg_options *pwg)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_bitmap_as_pwg():" << " auto_ctx=" << auto_ctx << " out=" << out << " bitmap=" << bitmap << " pwg=" << pwg << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_bitmap_as_pwg(auto_ctx, out, bitmap, pwg);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_bitmap_as_pwg_page()`. */
FZ_FUNCTION void write_bitmap_as_pwg_page(fz_output *out, const fz_bitmap *bitmap, const fz_pwg_options *pwg)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_bitmap_as_pwg_page():" << " auto_ctx=" << auto_ctx << " out=" << out << " bitmap=" << bitmap << " pwg=" << pwg << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_bitmap_as_pwg_page(auto_ctx, out, bitmap, pwg);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_byte()`. */
FZ_FUNCTION void write_byte(fz_output *out, unsigned char x)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_byte():" << " auto_ctx=" << auto_ctx << " out=" << out << " x=" << x << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_byte(auto_ctx, out, x);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_char()`. */
FZ_FUNCTION void write_char(fz_output *out, char x)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_char():" << " auto_ctx=" << auto_ctx << " out=" << out << " x=" << x << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_char(auto_ctx, out, x);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_data()`. */
FZ_FUNCTION void write_data(fz_output *out, const void *data, size_t size)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_data():" << " auto_ctx=" << auto_ctx << " out=" << out << " data=" << (void*) data << " size=" << size << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_data(auto_ctx, out, data, size);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_document()`. */
FZ_FUNCTION void write_document(fz_document_writer *wri, fz_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_document():" << " auto_ctx=" << auto_ctx << " wri=" << wri << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_document(auto_ctx, wri, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_float_be()`. */
FZ_FUNCTION void write_float_be(fz_output *out, float f)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_float_be():" << " auto_ctx=" << auto_ctx << " out=" << out << " f=" << f << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_float_be(auto_ctx, out, f);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_float_le()`. */
FZ_FUNCTION void write_float_le(fz_output *out, float f)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_float_le():" << " auto_ctx=" << auto_ctx << " out=" << out << " f=" << f << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_float_le(auto_ctx, out, f);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_header()`. */
FZ_FUNCTION void write_header(fz_band_writer *writer, int w, int h, int n, int alpha, int xres, int yres, int pagenum, fz_colorspace *cs, fz_separations *seps)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_header():" << " auto_ctx=" << auto_ctx << " writer=" << writer << " w=" << w << " h=" << h << " n=" << n << " alpha=" << alpha << " xres=" << xres << " yres=" << yres << " pagenum=" << pagenum << " cs=" << cs << " seps=" << seps << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_header(auto_ctx, writer, w, h, n, alpha, xres, yres, pagenum, cs, seps);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_image_as_data_uri()`. */
FZ_FUNCTION void write_image_as_data_uri(fz_output *out, fz_image *image)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_image_as_data_uri():" << " auto_ctx=" << auto_ctx << " out=" << out << " image=" << image << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_image_as_data_uri(auto_ctx, out, image);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_int16_be()`. */
FZ_FUNCTION void write_int16_be(fz_output *out, int x)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_int16_be():" << " auto_ctx=" << auto_ctx << " out=" << out << " x=" << x << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_int16_be(auto_ctx, out, x);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_int16_le()`. */
FZ_FUNCTION void write_int16_le(fz_output *out, int x)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_int16_le():" << " auto_ctx=" << auto_ctx << " out=" << out << " x=" << x << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_int16_le(auto_ctx, out, x);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_int32_be()`. */
FZ_FUNCTION void write_int32_be(fz_output *out, int x)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_int32_be():" << " auto_ctx=" << auto_ctx << " out=" << out << " x=" << x << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_int32_be(auto_ctx, out, x);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_int32_le()`. */
FZ_FUNCTION void write_int32_le(fz_output *out, int x)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_int32_le():" << " auto_ctx=" << auto_ctx << " out=" << out << " x=" << x << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_int32_le(auto_ctx, out, x);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_pixmap_as_data_uri()`. */
FZ_FUNCTION void write_pixmap_as_data_uri(fz_output *out, fz_pixmap *pixmap)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_pixmap_as_data_uri():" << " auto_ctx=" << auto_ctx << " out=" << out << " pixmap=" << pixmap << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_pixmap_as_data_uri(auto_ctx, out, pixmap);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_pixmap_as_pam()`. */
FZ_FUNCTION void write_pixmap_as_pam(fz_output *out, fz_pixmap *pixmap)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_pixmap_as_pam():" << " auto_ctx=" << auto_ctx << " out=" << out << " pixmap=" << pixmap << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_pixmap_as_pam(auto_ctx, out, pixmap);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_pixmap_as_pcl()`. */
FZ_FUNCTION void write_pixmap_as_pcl(fz_output *out, const fz_pixmap *pixmap, const fz_pcl_options *pcl)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_pixmap_as_pcl():" << " auto_ctx=" << auto_ctx << " out=" << out << " pixmap=" << pixmap << " pcl=" << pcl << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_pixmap_as_pcl(auto_ctx, out, pixmap, pcl);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_pixmap_as_pclm()`. */
FZ_FUNCTION void write_pixmap_as_pclm(fz_output *out, const fz_pixmap *pixmap, const fz_pclm_options *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_pixmap_as_pclm():" << " auto_ctx=" << auto_ctx << " out=" << out << " pixmap=" << pixmap << " options=" << options << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_pixmap_as_pclm(auto_ctx, out, pixmap, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_pixmap_as_pdfocr()`. */
FZ_FUNCTION void write_pixmap_as_pdfocr(fz_output *out, const fz_pixmap *pixmap, const fz_pdfocr_options *options)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_pixmap_as_pdfocr():" << " auto_ctx=" << auto_ctx << " out=" << out << " pixmap=" << pixmap << " options=" << options << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_pixmap_as_pdfocr(auto_ctx, out, pixmap, options);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_pixmap_as_png()`. */
FZ_FUNCTION void write_pixmap_as_png(fz_output *out, const fz_pixmap *pixmap)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_pixmap_as_png():" << " auto_ctx=" << auto_ctx << " out=" << out << " pixmap=" << pixmap << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_pixmap_as_png(auto_ctx, out, pixmap);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_pixmap_as_pnm()`. */
FZ_FUNCTION void write_pixmap_as_pnm(fz_output *out, fz_pixmap *pixmap)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_pixmap_as_pnm():" << " auto_ctx=" << auto_ctx << " out=" << out << " pixmap=" << pixmap << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_pixmap_as_pnm(auto_ctx, out, pixmap);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_pixmap_as_ps()`. */
FZ_FUNCTION void write_pixmap_as_ps(fz_output *out, const fz_pixmap *pixmap)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_pixmap_as_ps():" << " auto_ctx=" << auto_ctx << " out=" << out << " pixmap=" << pixmap << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_pixmap_as_ps(auto_ctx, out, pixmap);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_pixmap_as_psd()`. */
FZ_FUNCTION void write_pixmap_as_psd(fz_output *out, const fz_pixmap *pixmap)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_pixmap_as_psd():" << " auto_ctx=" << auto_ctx << " out=" << out << " pixmap=" << pixmap << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_pixmap_as_psd(auto_ctx, out, pixmap);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_pixmap_as_pwg()`. */
FZ_FUNCTION void write_pixmap_as_pwg(fz_output *out, const fz_pixmap *pixmap, const fz_pwg_options *pwg)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_pixmap_as_pwg():" << " auto_ctx=" << auto_ctx << " out=" << out << " pixmap=" << pixmap << " pwg=" << pwg << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_pixmap_as_pwg(auto_ctx, out, pixmap, pwg);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_pixmap_as_pwg_page()`. */
FZ_FUNCTION void write_pixmap_as_pwg_page(fz_output *out, const fz_pixmap *pixmap, const fz_pwg_options *pwg)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_pixmap_as_pwg_page():" << " auto_ctx=" << auto_ctx << " out=" << out << " pixmap=" << pixmap << " pwg=" << pwg << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_pixmap_as_pwg_page(auto_ctx, out, pixmap, pwg);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_ps_file_header()`. */
FZ_FUNCTION void write_ps_file_header(fz_output *out)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_ps_file_header():" << " auto_ctx=" << auto_ctx << " out=" << out << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_ps_file_header(auto_ctx, out);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_ps_file_trailer()`. */
FZ_FUNCTION void write_ps_file_trailer(fz_output *out, int pages)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_ps_file_trailer():" << " auto_ctx=" << auto_ctx << " out=" << out << " pages=" << pages << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_ps_file_trailer(auto_ctx, out, pages);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_pwg_file_header()`. */
FZ_FUNCTION void write_pwg_file_header(fz_output *out)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_pwg_file_header():" << " auto_ctx=" << auto_ctx << " out=" << out << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_pwg_file_header(auto_ctx, out);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_rune()`. */
FZ_FUNCTION void write_rune(fz_output *out, int rune)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_rune():" << " auto_ctx=" << auto_ctx << " out=" << out << " rune=" << rune << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_rune(auto_ctx, out, rune);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_string()`. */
FZ_FUNCTION void write_string(fz_output *out, const char *s)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_string():" << " auto_ctx=" << auto_ctx << " out=" << out << " s=" << s << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_string(auto_ctx, out, s);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_uint16_be()`. */
FZ_FUNCTION void write_uint16_be(fz_output *out, unsigned int x)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_uint16_be():" << " auto_ctx=" << auto_ctx << " out=" << out << " x=" << x << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_uint16_be(auto_ctx, out, x);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_uint16_le()`. */
FZ_FUNCTION void write_uint16_le(fz_output *out, unsigned int x)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_uint16_le():" << " auto_ctx=" << auto_ctx << " out=" << out << " x=" << x << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_uint16_le(auto_ctx, out, x);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_uint32_be()`. */
FZ_FUNCTION void write_uint32_be(fz_output *out, unsigned int x)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_uint32_be():" << " auto_ctx=" << auto_ctx << " out=" << out << " x=" << x << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_uint32_be(auto_ctx, out, x);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_uint32_le()`. */
FZ_FUNCTION void write_uint32_le(fz_output *out, unsigned int x)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_uint32_le():" << " auto_ctx=" << auto_ctx << " out=" << out << " x=" << x << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_uint32_le(auto_ctx, out, x);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_vprintf()`. */
FZ_FUNCTION void write_vprintf(fz_output *out, const char *fmt, va_list ap)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_vprintf():" << " auto_ctx=" << auto_ctx << " out=" << out << " fmt=" << fmt << " ap=" << ap << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_vprintf(auto_ctx, out, fmt, ap);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_write_zip_entry()`. */
FZ_FUNCTION void write_zip_entry(fz_zip_writer *zip, const char *name, fz_buffer *buf, int compress)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_write_zip_entry():" << " auto_ctx=" << auto_ctx << " zip=" << zip << " name=" << name << " buf=" << buf << " compress=" << compress << "\n";
	}
	fz_try(auto_ctx) {
		::fz_write_zip_entry(auto_ctx, zip, name, buf, compress);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `fz_xml_att()`. */
FZ_FUNCTION char *xml_att(fz_xml *item, const char *att)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_xml_att():" << " item=" << item << " att=" << att << "\n";
	}
	char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_xml_att(item, att);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_xml_att_alt()`. */
FZ_FUNCTION char *xml_att_alt(fz_xml *item, const char *one, const char *two)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_xml_att_alt():" << " item=" << item << " one=" << one << " two=" << two << "\n";
	}
	char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_xml_att_alt(item, one, two);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_xml_att_eq()`. */
FZ_FUNCTION int xml_att_eq(fz_xml *item, const char *name, const char *match)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_xml_att_eq():" << " item=" << item << " name=" << name << " match=" << match << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_xml_att_eq(item, name, match);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_xml_down()`. */
FZ_FUNCTION fz_xml *xml_down(fz_xml *item)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_xml_down():" << " item=" << item << "\n";
	}
	fz_xml * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_xml_down(item);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_xml_find()`. */
FZ_FUNCTION fz_xml *xml_find(fz_xml *item, const char *tag)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_xml_find():" << " item=" << item << " tag=" << tag << "\n";
	}
	fz_xml * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_xml_find(item, tag);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_xml_find_down()`. */
FZ_FUNCTION fz_xml *xml_find_down(fz_xml *item, const char *tag)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_xml_find_down():" << " item=" << item << " tag=" << tag << "\n";
	}
	fz_xml * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_xml_find_down(item, tag);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_xml_find_down_match()`. */
FZ_FUNCTION fz_xml *xml_find_down_match(fz_xml *item, const char *tag, const char *att, const char *match)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_xml_find_down_match():" << " item=" << item << " tag=" << tag << " att=" << att << " match=" << match << "\n";
	}
	fz_xml * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_xml_find_down_match(item, tag, att, match);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_xml_find_match()`. */
FZ_FUNCTION fz_xml *xml_find_match(fz_xml *item, const char *tag, const char *att, const char *match)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_xml_find_match():" << " item=" << item << " tag=" << tag << " att=" << att << " match=" << match << "\n";
	}
	fz_xml * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_xml_find_match(item, tag, att, match);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_xml_find_next()`. */
FZ_FUNCTION fz_xml *xml_find_next(fz_xml *item, const char *tag)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_xml_find_next():" << " item=" << item << " tag=" << tag << "\n";
	}
	fz_xml * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_xml_find_next(item, tag);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_xml_find_next_match()`. */
FZ_FUNCTION fz_xml *xml_find_next_match(fz_xml *item, const char *tag, const char *att, const char *match)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_xml_find_next_match():" << " item=" << item << " tag=" << tag << " att=" << att << " match=" << match << "\n";
	}
	fz_xml * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_xml_find_next_match(item, tag, att, match);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_xml_is_tag()`. */
FZ_FUNCTION int xml_is_tag(fz_xml *item, const char *name)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_xml_is_tag():" << " item=" << item << " name=" << name << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_xml_is_tag(item, name);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_xml_next()`. */
FZ_FUNCTION fz_xml *xml_next(fz_xml *item)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_xml_next():" << " item=" << item << "\n";
	}
	fz_xml * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_xml_next(item);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_xml_prev()`. */
FZ_FUNCTION fz_xml *xml_prev(fz_xml *item)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_xml_prev():" << " item=" << item << "\n";
	}
	fz_xml * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_xml_prev(item);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_xml_root()`. */
FZ_FUNCTION fz_xml *xml_root(fz_xml_doc *xml)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_xml_root():" << " xml=" << xml << "\n";
	}
	fz_xml * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_xml_root(xml);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_xml_tag()`. */
FZ_FUNCTION char *xml_tag(fz_xml *item)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_xml_tag():" << " item=" << item << "\n";
	}
	char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_xml_tag(item);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_xml_text()`. */
FZ_FUNCTION char *xml_text(fz_xml *item)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_xml_text():" << " item=" << item << "\n";
	}
	char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_xml_text(item);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `fz_xml_up()`. */
FZ_FUNCTION fz_xml *xml_up(fz_xml *item)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling fz_xml_up():" << " item=" << item << "\n";
	}
	fz_xml * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::fz_xml_up(item);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_access_alert_event()`. */
FZ_FUNCTION pdf_alert_event *ppdf_access_alert_event(pdf_doc_event *evt)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_access_alert_event():" << " auto_ctx=" << auto_ctx << " evt=" << evt << "\n";
	}
	pdf_alert_event * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_access_alert_event(auto_ctx, evt);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_access_exec_menu_item_event()`. */
FZ_FUNCTION const char *ppdf_access_exec_menu_item_event(pdf_doc_event *evt)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_access_exec_menu_item_event():" << " auto_ctx=" << auto_ctx << " evt=" << evt << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_access_exec_menu_item_event(auto_ctx, evt);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_access_launch_url_event()`. */
FZ_FUNCTION pdf_launch_url_event *ppdf_access_launch_url_event(pdf_doc_event *evt)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_access_launch_url_event():" << " auto_ctx=" << auto_ctx << " evt=" << evt << "\n";
	}
	pdf_launch_url_event * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_access_launch_url_event(auto_ctx, evt);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_access_mail_doc_event()`. */
FZ_FUNCTION pdf_mail_doc_event *ppdf_access_mail_doc_event(pdf_doc_event *evt)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_access_mail_doc_event():" << " auto_ctx=" << auto_ctx << " evt=" << evt << "\n";
	}
	pdf_mail_doc_event * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_access_mail_doc_event(auto_ctx, evt);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_add_annot_ink_list()`. */
FZ_FUNCTION void ppdf_add_annot_ink_list(pdf_annot *annot, int n, fz_point stroke[])
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_add_annot_ink_list():" << " auto_ctx=" << auto_ctx << " annot=" << annot << " n=" << n << " stroke=" << stroke << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_add_annot_ink_list(auto_ctx, annot, n, stroke);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_add_annot_ink_list_stroke()`. */
FZ_FUNCTION void ppdf_add_annot_ink_list_stroke(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_add_annot_ink_list_stroke():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_add_annot_ink_list_stroke(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_add_annot_ink_list_stroke_vertex()`. */
FZ_FUNCTION void ppdf_add_annot_ink_list_stroke_vertex(pdf_annot *annot, fz_point p)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_add_annot_ink_list_stroke_vertex():" << " auto_ctx=" << auto_ctx << " annot=" << annot << " p=" << p << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_add_annot_ink_list_stroke_vertex(auto_ctx, annot, p);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_add_annot_quad_point()`. */
FZ_FUNCTION void ppdf_add_annot_quad_point(pdf_annot *annot, fz_quad quad)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_add_annot_quad_point():" << " auto_ctx=" << auto_ctx << " annot=" << annot << " quad=" << quad << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_add_annot_quad_point(auto_ctx, annot, quad);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_add_annot_vertex()`. */
FZ_FUNCTION void ppdf_add_annot_vertex(pdf_annot *annot, fz_point p)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_add_annot_vertex():" << " auto_ctx=" << auto_ctx << " annot=" << annot << " p=" << p << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_add_annot_vertex(auto_ctx, annot, p);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_add_cid_font()`. */
FZ_FUNCTION pdf_obj *ppdf_add_cid_font(pdf_document *doc, fz_font *font)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_add_cid_font():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " font=" << font << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_add_cid_font(auto_ctx, doc, font);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_add_cjk_font()`. */
FZ_FUNCTION pdf_obj *ppdf_add_cjk_font(pdf_document *doc, fz_font *font, int script, int wmode, int serif)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_add_cjk_font():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " font=" << font << " script=" << script << " wmode=" << wmode << " serif=" << serif << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_add_cjk_font(auto_ctx, doc, font, script, wmode, serif);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_add_codespace()`. */
FZ_FUNCTION void ppdf_add_codespace(pdf_cmap *cmap, unsigned int low, unsigned int high, size_t n)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_add_codespace():" << " auto_ctx=" << auto_ctx << " cmap=" << cmap << " low=" << low << " high=" << high << " n=" << n << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_add_codespace(auto_ctx, cmap, low, high, n);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_add_embedded_file()`. */
FZ_FUNCTION pdf_obj *ppdf_add_embedded_file(pdf_document *doc, const char *filename, const char *mimetype, fz_buffer *contents)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_add_embedded_file():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " filename=" << filename << " mimetype=" << mimetype << " contents=" << contents << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_add_embedded_file(auto_ctx, doc, filename, mimetype, contents);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_add_hmtx()`. */
FZ_FUNCTION void ppdf_add_hmtx(pdf_font_desc *font, int lo, int hi, int w)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_add_hmtx():" << " auto_ctx=" << auto_ctx << " font=" << font << " lo=" << lo << " hi=" << hi << " w=" << w << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_add_hmtx(auto_ctx, font, lo, hi, w);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_add_image()`. */
FZ_FUNCTION pdf_obj *ppdf_add_image(pdf_document *doc, fz_image *image)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_add_image():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " image=" << image << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_add_image(auto_ctx, doc, image);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_add_journal_fragment()`. */
FZ_FUNCTION void ppdf_add_journal_fragment(pdf_document *doc, int parent, pdf_obj *copy, fz_buffer *copy_stream, int newobj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_add_journal_fragment():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " parent=" << parent << " copy=" << copy << " copy_stream=" << copy_stream << " newobj=" << newobj << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_add_journal_fragment(auto_ctx, doc, parent, copy, copy_stream, newobj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_add_new_array()`. */
FZ_FUNCTION pdf_obj *ppdf_add_new_array(pdf_document *doc, int initial)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_add_new_array():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " initial=" << initial << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_add_new_array(auto_ctx, doc, initial);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_add_new_dict()`. */
FZ_FUNCTION pdf_obj *ppdf_add_new_dict(pdf_document *doc, int initial)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_add_new_dict():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " initial=" << initial << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_add_new_dict(auto_ctx, doc, initial);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_add_object()`. */
FZ_FUNCTION pdf_obj *ppdf_add_object(pdf_document *doc, pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_add_object():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " obj=" << obj << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_add_object(auto_ctx, doc, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_add_object_drop()`. */
FZ_FUNCTION pdf_obj *ppdf_add_object_drop(pdf_document *doc, pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_add_object_drop():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " obj=" << obj << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_add_object_drop(auto_ctx, doc, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_add_page()`. */
FZ_FUNCTION pdf_obj *ppdf_add_page(pdf_document *doc, fz_rect mediabox, int rotate, pdf_obj *resources, fz_buffer *contents)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_add_page():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " mediabox=" << mediabox << " rotate=" << rotate << " resources=" << resources << " contents=" << contents << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_add_page(auto_ctx, doc, mediabox, rotate, resources, contents);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_add_simple_font()`. */
FZ_FUNCTION pdf_obj *ppdf_add_simple_font(pdf_document *doc, fz_font *font, int encoding)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_add_simple_font():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " font=" << font << " encoding=" << encoding << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_add_simple_font(auto_ctx, doc, font, encoding);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_add_stream()`. */
FZ_FUNCTION pdf_obj *ppdf_add_stream(pdf_document *doc, fz_buffer *buf, pdf_obj *obj, int compressed)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_add_stream():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " buf=" << buf << " obj=" << obj << " compressed=" << compressed << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_add_stream(auto_ctx, doc, buf, obj, compressed);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_add_substitute_font()`. */
FZ_FUNCTION pdf_obj *ppdf_add_substitute_font(pdf_document *doc, fz_font *font)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_add_substitute_font():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " font=" << font << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_add_substitute_font(auto_ctx, doc, font);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_add_vmtx()`. */
FZ_FUNCTION void ppdf_add_vmtx(pdf_font_desc *font, int lo, int hi, int x, int y, int w)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_add_vmtx():" << " auto_ctx=" << auto_ctx << " font=" << font << " lo=" << lo << " hi=" << hi << " x=" << x << " y=" << y << " w=" << w << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_add_vmtx(auto_ctx, font, lo, hi, x, y, w);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_annot_MK_BC()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_annot_MK_BC(pdf_annot *annot, float color[4])` => int n
*/
FZ_FUNCTION void ppdf_annot_MK_BC(pdf_annot *annot, int *n, float color[4])
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_MK_BC():" << " auto_ctx=" << auto_ctx << " annot=" << annot << " n=" << (void*) n << " color=" << color << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_annot_MK_BC(auto_ctx, annot, n, color);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_annot_MK_BC_rgb()`. */
FZ_FUNCTION int ppdf_annot_MK_BC_rgb(pdf_annot *annot, float rgb[3])
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_MK_BC_rgb():" << " auto_ctx=" << auto_ctx << " annot=" << annot << " rgb=" << rgb << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_MK_BC_rgb(auto_ctx, annot, rgb);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_MK_BG()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_annot_MK_BG(pdf_annot *annot, float color[4])` => int n
*/
FZ_FUNCTION void ppdf_annot_MK_BG(pdf_annot *annot, int *n, float color[4])
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_MK_BG():" << " auto_ctx=" << auto_ctx << " annot=" << annot << " n=" << (void*) n << " color=" << color << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_annot_MK_BG(auto_ctx, annot, n, color);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_annot_MK_BG_rgb()`. */
FZ_FUNCTION int ppdf_annot_MK_BG_rgb(pdf_annot *annot, float rgb[3])
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_MK_BG_rgb():" << " auto_ctx=" << auto_ctx << " annot=" << annot << " rgb=" << rgb << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_MK_BG_rgb(auto_ctx, annot, rgb);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_active()`. */
FZ_FUNCTION int ppdf_annot_active(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_active():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_active(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_ap()`. */
FZ_FUNCTION pdf_obj *ppdf_annot_ap(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_ap():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_ap(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_author()`. */
FZ_FUNCTION const char *ppdf_annot_author(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_author():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_author(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_border()`. */
FZ_FUNCTION float ppdf_annot_border(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_border():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	float ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_border(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_color()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_annot_color(pdf_annot *annot, float color[4])` => int n
*/
FZ_FUNCTION void ppdf_annot_color(pdf_annot *annot, int *n, float color[4])
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_color():" << " auto_ctx=" << auto_ctx << " annot=" << annot << " n=" << (void*) n << " color=" << color << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_annot_color(auto_ctx, annot, n, color);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_annot_contents()`. */
FZ_FUNCTION const char *ppdf_annot_contents(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_contents():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_contents(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_creation_date()`. */
FZ_FUNCTION int64_t ppdf_annot_creation_date(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_creation_date():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	int64_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_creation_date(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_default_appearance()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_annot_default_appearance(pdf_annot *annot, float color[4])` => `(const char *font, float size, int n)`
*/
FZ_FUNCTION void ppdf_annot_default_appearance(pdf_annot *annot, const char **font, float *size, int *n, float color[4])
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_default_appearance():" << " auto_ctx=" << auto_ctx << " annot=" << annot << " font=" << (void*) font << " size=" << (void*) size << " n=" << (void*) n << " color=" << color << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_annot_default_appearance(auto_ctx, annot, font, size, n, color);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_annot_ensure_local_xref()`. */
FZ_FUNCTION void ppdf_annot_ensure_local_xref(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_ensure_local_xref():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_annot_ensure_local_xref(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_annot_event_blur()`. */
FZ_FUNCTION void ppdf_annot_event_blur(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_event_blur():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_annot_event_blur(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_annot_event_down()`. */
FZ_FUNCTION void ppdf_annot_event_down(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_event_down():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_annot_event_down(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_annot_event_enter()`. */
FZ_FUNCTION void ppdf_annot_event_enter(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_event_enter():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_annot_event_enter(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_annot_event_exit()`. */
FZ_FUNCTION void ppdf_annot_event_exit(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_event_exit():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_annot_event_exit(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_annot_event_focus()`. */
FZ_FUNCTION void ppdf_annot_event_focus(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_event_focus():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_annot_event_focus(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_annot_event_page_close()`. */
FZ_FUNCTION void ppdf_annot_event_page_close(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_event_page_close():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_annot_event_page_close(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_annot_event_page_invisible()`. */
FZ_FUNCTION void ppdf_annot_event_page_invisible(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_event_page_invisible():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_annot_event_page_invisible(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_annot_event_page_open()`. */
FZ_FUNCTION void ppdf_annot_event_page_open(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_event_page_open():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_annot_event_page_open(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_annot_event_page_visible()`. */
FZ_FUNCTION void ppdf_annot_event_page_visible(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_event_page_visible():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_annot_event_page_visible(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_annot_event_up()`. */
FZ_FUNCTION void ppdf_annot_event_up(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_event_up():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_annot_event_up(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_annot_field_event_keystroke()`. */
FZ_FUNCTION int ppdf_annot_field_event_keystroke(pdf_document *doc, pdf_annot *annot, pdf_keystroke_event *evt)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_field_event_keystroke():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " annot=" << annot << " evt=" << evt << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_field_event_keystroke(auto_ctx, doc, annot, evt);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_field_flags()`. */
FZ_FUNCTION int ppdf_annot_field_flags(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_field_flags():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_field_flags(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_field_label()`. */
FZ_FUNCTION const char *ppdf_annot_field_label(pdf_annot *widget)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_field_label():" << " auto_ctx=" << auto_ctx << " widget=" << widget << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_field_label(auto_ctx, widget);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_field_value()`. */
FZ_FUNCTION const char *ppdf_annot_field_value(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_field_value():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_field_value(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_flags()`. */
FZ_FUNCTION int ppdf_annot_flags(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_flags():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_flags(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_has_author()`. */
FZ_FUNCTION int ppdf_annot_has_author(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_has_author():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_has_author(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_has_icon_name()`. */
FZ_FUNCTION int ppdf_annot_has_icon_name(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_has_icon_name():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_has_icon_name(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_has_ink_list()`. */
FZ_FUNCTION int ppdf_annot_has_ink_list(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_has_ink_list():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_has_ink_list(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_has_interior_color()`. */
FZ_FUNCTION int ppdf_annot_has_interior_color(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_has_interior_color():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_has_interior_color(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_has_line()`. */
FZ_FUNCTION int ppdf_annot_has_line(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_has_line():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_has_line(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_has_line_ending_styles()`. */
FZ_FUNCTION int ppdf_annot_has_line_ending_styles(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_has_line_ending_styles():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_has_line_ending_styles(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_has_open()`. */
FZ_FUNCTION int ppdf_annot_has_open(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_has_open():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_has_open(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_has_quad_points()`. */
FZ_FUNCTION int ppdf_annot_has_quad_points(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_has_quad_points():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_has_quad_points(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_has_vertices()`. */
FZ_FUNCTION int ppdf_annot_has_vertices(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_has_vertices():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_has_vertices(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_hot()`. */
FZ_FUNCTION int ppdf_annot_hot(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_hot():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_hot(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_icon_name()`. */
FZ_FUNCTION const char *ppdf_annot_icon_name(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_icon_name():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_icon_name(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_ink_list_count()`. */
FZ_FUNCTION int ppdf_annot_ink_list_count(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_ink_list_count():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_ink_list_count(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_ink_list_stroke_count()`. */
FZ_FUNCTION int ppdf_annot_ink_list_stroke_count(pdf_annot *annot, int i)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_ink_list_stroke_count():" << " auto_ctx=" << auto_ctx << " annot=" << annot << " i=" << i << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_ink_list_stroke_count(auto_ctx, annot, i);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_ink_list_stroke_vertex()`. */
FZ_FUNCTION fz_point ppdf_annot_ink_list_stroke_vertex(pdf_annot *annot, int i, int k)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_ink_list_stroke_vertex():" << " auto_ctx=" << auto_ctx << " annot=" << annot << " i=" << i << " k=" << k << "\n";
	}
	fz_point ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_ink_list_stroke_vertex(auto_ctx, annot, i, k);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_interior_color()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_annot_interior_color(pdf_annot *annot, float color[4])` => int n
*/
FZ_FUNCTION void ppdf_annot_interior_color(pdf_annot *annot, int *n, float color[4])
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_interior_color():" << " auto_ctx=" << auto_ctx << " annot=" << annot << " n=" << (void*) n << " color=" << color << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_annot_interior_color(auto_ctx, annot, n, color);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_annot_is_open()`. */
FZ_FUNCTION int ppdf_annot_is_open(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_is_open():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_is_open(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_language()`. */
FZ_FUNCTION fz_text_language ppdf_annot_language(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_language():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_text_language ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_language(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_line()`. */
FZ_FUNCTION void ppdf_annot_line(pdf_annot *annot, fz_point *a, fz_point *b)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_line():" << " auto_ctx=" << auto_ctx << " annot=" << annot << " a=" << a << " b=" << b << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_annot_line(auto_ctx, annot, a, b);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_annot_line_end_style()`. */
FZ_FUNCTION enum pdf_line_ending ppdf_annot_line_end_style(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_line_end_style():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	enum pdf_line_ending ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_line_end_style(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_line_ending_styles()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_annot_line_ending_styles(pdf_annot *annot)` => `(enum pdf_line_ending start_style, enum pdf_line_ending end_style)`
*/
FZ_FUNCTION void ppdf_annot_line_ending_styles(pdf_annot *annot, enum pdf_line_ending *start_style, enum pdf_line_ending *end_style)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_line_ending_styles():" << " auto_ctx=" << auto_ctx << " annot=" << annot << " start_style=" << (void*) start_style << " end_style=" << (void*) end_style << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_annot_line_ending_styles(auto_ctx, annot, start_style, end_style);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_annot_line_start_style()`. */
FZ_FUNCTION enum pdf_line_ending ppdf_annot_line_start_style(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_line_start_style():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	enum pdf_line_ending ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_line_start_style(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_modification_date()`. */
FZ_FUNCTION int64_t ppdf_annot_modification_date(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_modification_date():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	int64_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_modification_date(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_needs_resynthesis()`. */
FZ_FUNCTION int ppdf_annot_needs_resynthesis(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_needs_resynthesis():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_needs_resynthesis(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_obj()`. */
FZ_FUNCTION pdf_obj *ppdf_annot_obj(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_obj():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_obj(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_opacity()`. */
FZ_FUNCTION float ppdf_annot_opacity(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_opacity():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	float ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_opacity(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_page()`. */
FZ_FUNCTION pdf_page *ppdf_annot_page(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_page():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	pdf_page * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_page(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_pop_and_discard_local_xref()`. */
FZ_FUNCTION void ppdf_annot_pop_and_discard_local_xref(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_pop_and_discard_local_xref():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_annot_pop_and_discard_local_xref(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_annot_pop_local_xref()`. */
FZ_FUNCTION void ppdf_annot_pop_local_xref(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_pop_local_xref():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_annot_pop_local_xref(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_annot_popup()`. */
FZ_FUNCTION fz_rect ppdf_annot_popup(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_popup():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_rect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_popup(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_push_local_xref()`. */
FZ_FUNCTION void ppdf_annot_push_local_xref(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_push_local_xref():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_annot_push_local_xref(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_annot_quad_point()`. */
FZ_FUNCTION fz_quad ppdf_annot_quad_point(pdf_annot *annot, int i)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_quad_point():" << " auto_ctx=" << auto_ctx << " annot=" << annot << " i=" << i << "\n";
	}
	fz_quad ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_quad_point(auto_ctx, annot, i);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_quad_point_count()`. */
FZ_FUNCTION int ppdf_annot_quad_point_count(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_quad_point_count():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_quad_point_count(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_quadding()`. */
FZ_FUNCTION int ppdf_annot_quadding(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_quadding():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_quadding(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_rect()`. */
FZ_FUNCTION fz_rect ppdf_annot_rect(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_rect():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_rect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_rect(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_request_resynthesis()`. */
FZ_FUNCTION void ppdf_annot_request_resynthesis(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_request_resynthesis():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_annot_request_resynthesis(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_annot_transform()`. */
FZ_FUNCTION fz_matrix ppdf_annot_transform(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_transform():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_matrix ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_transform(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_type()`. */
FZ_FUNCTION enum pdf_annot_type ppdf_annot_type(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_type():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	enum pdf_annot_type ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_type(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_type_from_string()`. */
FZ_FUNCTION enum pdf_annot_type ppdf_annot_type_from_string(const char *subtype)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_type_from_string():" << " auto_ctx=" << auto_ctx << " subtype=" << subtype << "\n";
	}
	enum pdf_annot_type ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_type_from_string(auto_ctx, subtype);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_vertex()`. */
FZ_FUNCTION fz_point ppdf_annot_vertex(pdf_annot *annot, int i)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_vertex():" << " auto_ctx=" << auto_ctx << " annot=" << annot << " i=" << i << "\n";
	}
	fz_point ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_vertex(auto_ctx, annot, i);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_annot_vertex_count()`. */
FZ_FUNCTION int ppdf_annot_vertex_count(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_annot_vertex_count():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_annot_vertex_count(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_append_token()`. */
FZ_FUNCTION void ppdf_append_token(fz_buffer *buf, int tok, pdf_lexbuf *lex)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_append_token():" << " auto_ctx=" << auto_ctx << " buf=" << buf << " tok=" << tok << " lex=" << lex << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_append_token(auto_ctx, buf, tok, lex);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_array_contains()`. */
FZ_FUNCTION int ppdf_array_contains(pdf_obj *array, pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_contains():" << " auto_ctx=" << auto_ctx << " array=" << array << " obj=" << obj << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_array_contains(auto_ctx, array, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_array_delete()`. */
FZ_FUNCTION void ppdf_array_delete(pdf_obj *array, int index)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_delete():" << " auto_ctx=" << auto_ctx << " array=" << array << " index=" << index << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_array_delete(auto_ctx, array, index);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_array_find()`. */
FZ_FUNCTION int ppdf_array_find(pdf_obj *array, pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_find():" << " auto_ctx=" << auto_ctx << " array=" << array << " obj=" << obj << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_array_find(auto_ctx, array, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_array_get()`. */
FZ_FUNCTION pdf_obj *ppdf_array_get(pdf_obj *array, int i)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_get():" << " auto_ctx=" << auto_ctx << " array=" << array << " i=" << i << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_array_get(auto_ctx, array, i);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_array_get_bool()`. */
FZ_FUNCTION int ppdf_array_get_bool(pdf_obj *array, int index)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_get_bool():" << " auto_ctx=" << auto_ctx << " array=" << array << " index=" << index << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_array_get_bool(auto_ctx, array, index);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_array_get_int()`. */
FZ_FUNCTION int ppdf_array_get_int(pdf_obj *array, int index)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_get_int():" << " auto_ctx=" << auto_ctx << " array=" << array << " index=" << index << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_array_get_int(auto_ctx, array, index);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_array_get_matrix()`. */
FZ_FUNCTION fz_matrix ppdf_array_get_matrix(pdf_obj *array, int index)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_get_matrix():" << " auto_ctx=" << auto_ctx << " array=" << array << " index=" << index << "\n";
	}
	fz_matrix ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_array_get_matrix(auto_ctx, array, index);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_array_get_name()`. */
FZ_FUNCTION const char *ppdf_array_get_name(pdf_obj *array, int index)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_get_name():" << " auto_ctx=" << auto_ctx << " array=" << array << " index=" << index << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_array_get_name(auto_ctx, array, index);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_array_get_real()`. */
FZ_FUNCTION float ppdf_array_get_real(pdf_obj *array, int index)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_get_real():" << " auto_ctx=" << auto_ctx << " array=" << array << " index=" << index << "\n";
	}
	float ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_array_get_real(auto_ctx, array, index);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_array_get_rect()`. */
FZ_FUNCTION fz_rect ppdf_array_get_rect(pdf_obj *array, int index)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_get_rect():" << " auto_ctx=" << auto_ctx << " array=" << array << " index=" << index << "\n";
	}
	fz_rect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_array_get_rect(auto_ctx, array, index);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_array_get_string()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_array_get_string(pdf_obj *array, int index)` => `(const char *, size_t sizep)`
*/
FZ_FUNCTION const char *ppdf_array_get_string(pdf_obj *array, int index, size_t *sizep)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_get_string():" << " auto_ctx=" << auto_ctx << " array=" << array << " index=" << index << " sizep=" << (void*) sizep << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_array_get_string(auto_ctx, array, index, sizep);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_array_get_text_string()`. */
FZ_FUNCTION const char *ppdf_array_get_text_string(pdf_obj *array, int index)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_get_text_string():" << " auto_ctx=" << auto_ctx << " array=" << array << " index=" << index << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_array_get_text_string(auto_ctx, array, index);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_array_insert()`. */
FZ_FUNCTION void ppdf_array_insert(pdf_obj *array, pdf_obj *obj, int index)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_insert():" << " auto_ctx=" << auto_ctx << " array=" << array << " obj=" << obj << " index=" << index << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_array_insert(auto_ctx, array, obj, index);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_array_insert_drop()`. */
FZ_FUNCTION void ppdf_array_insert_drop(pdf_obj *array, pdf_obj *obj, int index)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_insert_drop():" << " auto_ctx=" << auto_ctx << " array=" << array << " obj=" << obj << " index=" << index << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_array_insert_drop(auto_ctx, array, obj, index);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_array_len()`. */
FZ_FUNCTION int ppdf_array_len(pdf_obj *array)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_len():" << " auto_ctx=" << auto_ctx << " array=" << array << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_array_len(auto_ctx, array);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_array_push()`. */
FZ_FUNCTION void ppdf_array_push(pdf_obj *array, pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_push():" << " auto_ctx=" << auto_ctx << " array=" << array << " obj=" << obj << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_array_push(auto_ctx, array, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_array_push_array()`. */
FZ_FUNCTION pdf_obj *ppdf_array_push_array(pdf_obj *array, int initial)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_push_array():" << " auto_ctx=" << auto_ctx << " array=" << array << " initial=" << initial << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_array_push_array(auto_ctx, array, initial);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_array_push_bool()`. */
FZ_FUNCTION void ppdf_array_push_bool(pdf_obj *array, int x)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_push_bool():" << " auto_ctx=" << auto_ctx << " array=" << array << " x=" << x << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_array_push_bool(auto_ctx, array, x);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_array_push_dict()`. */
FZ_FUNCTION pdf_obj *ppdf_array_push_dict(pdf_obj *array, int initial)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_push_dict():" << " auto_ctx=" << auto_ctx << " array=" << array << " initial=" << initial << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_array_push_dict(auto_ctx, array, initial);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_array_push_drop()`. */
FZ_FUNCTION void ppdf_array_push_drop(pdf_obj *array, pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_push_drop():" << " auto_ctx=" << auto_ctx << " array=" << array << " obj=" << obj << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_array_push_drop(auto_ctx, array, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_array_push_int()`. */
FZ_FUNCTION void ppdf_array_push_int(pdf_obj *array, int64_t x)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_push_int():" << " auto_ctx=" << auto_ctx << " array=" << array << " x=" << x << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_array_push_int(auto_ctx, array, x);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_array_push_name()`. */
FZ_FUNCTION void ppdf_array_push_name(pdf_obj *array, const char *x)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_push_name():" << " auto_ctx=" << auto_ctx << " array=" << array << " x=" << x << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_array_push_name(auto_ctx, array, x);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_array_push_real()`. */
FZ_FUNCTION void ppdf_array_push_real(pdf_obj *array, double x)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_push_real():" << " auto_ctx=" << auto_ctx << " array=" << array << " x=" << x << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_array_push_real(auto_ctx, array, x);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_array_push_string()`. */
FZ_FUNCTION void ppdf_array_push_string(pdf_obj *array, const char *x, size_t n)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_push_string():" << " auto_ctx=" << auto_ctx << " array=" << array << " x=" << x << " n=" << n << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_array_push_string(auto_ctx, array, x, n);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_array_push_text_string()`. */
FZ_FUNCTION void ppdf_array_push_text_string(pdf_obj *array, const char *x)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_push_text_string():" << " auto_ctx=" << auto_ctx << " array=" << array << " x=" << x << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_array_push_text_string(auto_ctx, array, x);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_array_put()`. */
FZ_FUNCTION void ppdf_array_put(pdf_obj *array, int i, pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_put():" << " auto_ctx=" << auto_ctx << " array=" << array << " i=" << i << " obj=" << obj << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_array_put(auto_ctx, array, i, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_array_put_drop()`. */
FZ_FUNCTION void ppdf_array_put_drop(pdf_obj *array, int i, pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_array_put_drop():" << " auto_ctx=" << auto_ctx << " array=" << array << " i=" << i << " obj=" << obj << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_array_put_drop(auto_ctx, array, i, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_authenticate_password()`. */
FZ_FUNCTION int ppdf_authenticate_password(pdf_document *doc, const char *pw)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_authenticate_password():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " pw=" << pw << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_authenticate_password(auto_ctx, doc, pw);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_begin_implicit_operation()`. */
FZ_FUNCTION void ppdf_begin_implicit_operation(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_begin_implicit_operation():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_begin_implicit_operation(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_begin_operation()`. */
FZ_FUNCTION void ppdf_begin_operation(pdf_document *doc, const char *operation)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_begin_operation():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " operation=" << operation << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_begin_operation(auto_ctx, doc, operation);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_bound_annot()`. */
FZ_FUNCTION fz_rect ppdf_bound_annot(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_bound_annot():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_rect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_bound_annot(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_bound_page()`. */
FZ_FUNCTION fz_rect ppdf_bound_page(pdf_page *page)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_bound_page():" << " auto_ctx=" << auto_ctx << " page=" << page << "\n";
	}
	fz_rect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_bound_page(auto_ctx, page);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_bound_widget()`. */
FZ_FUNCTION fz_rect ppdf_bound_widget(pdf_annot *widget)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_bound_widget():" << " auto_ctx=" << auto_ctx << " widget=" << widget << "\n";
	}
	fz_rect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_bound_widget(auto_ctx, widget);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_button_field_on_state()`. */
FZ_FUNCTION pdf_obj *ppdf_button_field_on_state(pdf_obj *field)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_button_field_on_state():" << " auto_ctx=" << auto_ctx << " field=" << field << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_button_field_on_state(auto_ctx, field);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_cache_object()`. */
FZ_FUNCTION pdf_xref_entry *ppdf_cache_object(pdf_document *doc, int num)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_cache_object():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " num=" << num << "\n";
	}
	pdf_xref_entry * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_cache_object(auto_ctx, doc, num);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_calculate_form()`. */
FZ_FUNCTION void ppdf_calculate_form(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_calculate_form():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_calculate_form(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_can_be_saved_incrementally()`. */
FZ_FUNCTION int ppdf_can_be_saved_incrementally(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_can_be_saved_incrementally():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_can_be_saved_incrementally(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_can_redo()`. */
FZ_FUNCTION int ppdf_can_redo(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_can_redo():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_can_redo(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_can_undo()`. */
FZ_FUNCTION int ppdf_can_undo(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_can_undo():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_can_undo(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_check_certificate()`. */
FZ_FUNCTION pdf_signature_error ppdf_check_certificate(pdf_pkcs7_verifier *verifier, pdf_document *doc, pdf_obj *signature)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_check_certificate():" << " auto_ctx=" << auto_ctx << " verifier=" << verifier << " doc=" << doc << " signature=" << signature << "\n";
	}
	pdf_signature_error ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_check_certificate(auto_ctx, verifier, doc, signature);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_check_digest()`. */
FZ_FUNCTION pdf_signature_error ppdf_check_digest(pdf_pkcs7_verifier *verifier, pdf_document *doc, pdf_obj *signature)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_check_digest():" << " auto_ctx=" << auto_ctx << " verifier=" << verifier << " doc=" << doc << " signature=" << signature << "\n";
	}
	pdf_signature_error ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_check_digest(auto_ctx, verifier, doc, signature);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_check_signature()`. */
FZ_FUNCTION int ppdf_check_signature(pdf_pkcs7_verifier *verifier, pdf_document *doc, pdf_obj *signature, char *ebuf, size_t ebufsize)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_check_signature():" << " auto_ctx=" << auto_ctx << " verifier=" << verifier << " doc=" << doc << " signature=" << signature << " ebuf=" << (void*) ebuf << " ebufsize=" << ebufsize << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_check_signature(auto_ctx, verifier, doc, signature, ebuf, ebufsize);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_check_widget_certificate()`. */
FZ_FUNCTION pdf_signature_error ppdf_check_widget_certificate(pdf_pkcs7_verifier *verifier, pdf_annot *widget)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_check_widget_certificate():" << " auto_ctx=" << auto_ctx << " verifier=" << verifier << " widget=" << widget << "\n";
	}
	pdf_signature_error ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_check_widget_certificate(auto_ctx, verifier, widget);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_check_widget_digest()`. */
FZ_FUNCTION pdf_signature_error ppdf_check_widget_digest(pdf_pkcs7_verifier *verifier, pdf_annot *widget)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_check_widget_digest():" << " auto_ctx=" << auto_ctx << " verifier=" << verifier << " widget=" << widget << "\n";
	}
	pdf_signature_error ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_check_widget_digest(auto_ctx, verifier, widget);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_choice_field_option()`. */
FZ_FUNCTION const char *ppdf_choice_field_option(pdf_obj *field, int exportval, int i)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_choice_field_option():" << " auto_ctx=" << auto_ctx << " field=" << field << " exportval=" << exportval << " i=" << i << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_choice_field_option(auto_ctx, field, exportval, i);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_choice_field_option_count()`. */
FZ_FUNCTION int ppdf_choice_field_option_count(pdf_obj *field)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_choice_field_option_count():" << " auto_ctx=" << auto_ctx << " field=" << field << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_choice_field_option_count(auto_ctx, field);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_choice_widget_is_multiselect()`. */
FZ_FUNCTION int ppdf_choice_widget_is_multiselect(pdf_annot *tw)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_choice_widget_is_multiselect():" << " auto_ctx=" << auto_ctx << " tw=" << tw << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_choice_widget_is_multiselect(auto_ctx, tw);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_choice_widget_options()`. */
FZ_FUNCTION int ppdf_choice_widget_options(pdf_annot *tw, int exportval, const char *opts[])
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_choice_widget_options():" << " auto_ctx=" << auto_ctx << " tw=" << tw << " exportval=" << exportval << " opts=" << opts << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_choice_widget_options(auto_ctx, tw, exportval, opts);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_choice_widget_set_value()`. */
FZ_FUNCTION void ppdf_choice_widget_set_value(pdf_annot *tw, int n, const char *opts[])
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_choice_widget_set_value():" << " auto_ctx=" << auto_ctx << " tw=" << tw << " n=" << n << " opts=" << opts << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_choice_widget_set_value(auto_ctx, tw, n, opts);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_choice_widget_value()`. */
FZ_FUNCTION int ppdf_choice_widget_value(pdf_annot *tw, const char *opts[])
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_choice_widget_value():" << " auto_ctx=" << auto_ctx << " tw=" << tw << " opts=" << opts << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_choice_widget_value(auto_ctx, tw, opts);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_clean_file()`. */
FZ_FUNCTION void ppdf_clean_file(char *infile, char *outfile, char *password, pdf_write_options *opts, int retainlen, char *retainlist[])
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_clean_file():" << " auto_ctx=" << auto_ctx << " infile=" << (void*) infile << " outfile=" << (void*) outfile << " password=" << (void*) password << " opts=" << opts << " retainlen=" << retainlen << " retainlist=" << retainlist << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_clean_file(auto_ctx, infile, outfile, password, opts, retainlen, retainlist);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_clean_font_name()`. */
FZ_FUNCTION const char *ppdf_clean_font_name(const char *fontname)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_clean_font_name():" << " fontname=" << fontname << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_clean_font_name(fontname);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_clean_obj()`. */
FZ_FUNCTION void ppdf_clean_obj(pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_clean_obj():" << " auto_ctx=" << auto_ctx << " obj=" << obj << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_clean_obj(auto_ctx, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_clear_annot_ink_list()`. */
FZ_FUNCTION void ppdf_clear_annot_ink_list(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_clear_annot_ink_list():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_clear_annot_ink_list(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_clear_annot_quad_points()`. */
FZ_FUNCTION void ppdf_clear_annot_quad_points(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_clear_annot_quad_points():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_clear_annot_quad_points(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_clear_annot_vertices()`. */
FZ_FUNCTION void ppdf_clear_annot_vertices(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_clear_annot_vertices():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_clear_annot_vertices(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_clear_signature()`. */
FZ_FUNCTION void ppdf_clear_signature(pdf_annot *widget)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_clear_signature():" << " auto_ctx=" << auto_ctx << " widget=" << widget << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_clear_signature(auto_ctx, widget);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_clear_xref()`. */
FZ_FUNCTION void ppdf_clear_xref(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_clear_xref():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_clear_xref(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_clear_xref_to_mark()`. */
FZ_FUNCTION void ppdf_clear_xref_to_mark(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_clear_xref_to_mark():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_clear_xref_to_mark(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_close_processor()`. */
FZ_FUNCTION void ppdf_close_processor(pdf_processor *proc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_close_processor():" << " auto_ctx=" << auto_ctx << " proc=" << proc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_close_processor(auto_ctx, proc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_cmap_size()`. */
FZ_FUNCTION size_t ppdf_cmap_size(pdf_cmap *cmap)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_cmap_size():" << " auto_ctx=" << auto_ctx << " cmap=" << cmap << "\n";
	}
	size_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_cmap_size(auto_ctx, cmap);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_cmap_wmode()`. */
FZ_FUNCTION int ppdf_cmap_wmode(pdf_cmap *cmap)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_cmap_wmode():" << " auto_ctx=" << auto_ctx << " cmap=" << cmap << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_cmap_wmode(auto_ctx, cmap);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_copy_array()`. */
FZ_FUNCTION pdf_obj *ppdf_copy_array(pdf_obj *array)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_copy_array():" << " auto_ctx=" << auto_ctx << " array=" << array << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_copy_array(auto_ctx, array);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_copy_dict()`. */
FZ_FUNCTION pdf_obj *ppdf_copy_dict(pdf_obj *dict)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_copy_dict():" << " auto_ctx=" << auto_ctx << " dict=" << dict << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_copy_dict(auto_ctx, dict);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_count_layer_config_ui()`. */
FZ_FUNCTION int ppdf_count_layer_config_ui(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_count_layer_config_ui():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_count_layer_config_ui(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_count_layer_configs()`. */
FZ_FUNCTION int ppdf_count_layer_configs(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_count_layer_configs():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_count_layer_configs(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_count_objects()`. */
FZ_FUNCTION int ppdf_count_objects(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_count_objects():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_count_objects(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_count_pages()`. */
FZ_FUNCTION int ppdf_count_pages(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_count_pages():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_count_pages(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_count_pages_imp()`. */
FZ_FUNCTION int ppdf_count_pages_imp(fz_document *doc, int chapter)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_count_pages_imp():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " chapter=" << chapter << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_count_pages_imp(auto_ctx, doc, chapter);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_count_signatures()`. */
FZ_FUNCTION int ppdf_count_signatures(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_count_signatures():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_count_signatures(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_count_unsaved_versions()`. */
FZ_FUNCTION int ppdf_count_unsaved_versions(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_count_unsaved_versions():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_count_unsaved_versions(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_count_versions()`. */
FZ_FUNCTION int ppdf_count_versions(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_count_versions():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_count_versions(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_create_annot()`. */
FZ_FUNCTION pdf_annot *ppdf_create_annot(pdf_page *page, enum pdf_annot_type type)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_create_annot():" << " auto_ctx=" << auto_ctx << " page=" << page << " type=" << type << "\n";
	}
	pdf_annot * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_create_annot(auto_ctx, page, type);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_create_annot_raw()`. */
FZ_FUNCTION pdf_annot *ppdf_create_annot_raw(pdf_page *page, enum pdf_annot_type type)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_create_annot_raw():" << " auto_ctx=" << auto_ctx << " page=" << page << " type=" << type << "\n";
	}
	pdf_annot * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_create_annot_raw(auto_ctx, page, type);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_create_document()`. */
FZ_FUNCTION pdf_document *ppdf_create_document()
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_create_document():" << " auto_ctx=" << auto_ctx << "\n";
	}
	pdf_document * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_create_document(auto_ctx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_create_field_name()`. */
FZ_FUNCTION void ppdf_create_field_name(pdf_document *doc, const char *prefix, char *buf, size_t len)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_create_field_name():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " prefix=" << prefix << " buf=" << (void*) buf << " len=" << len << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_create_field_name(auto_ctx, doc, prefix, buf, len);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_create_link()`. */
FZ_FUNCTION fz_link *ppdf_create_link(pdf_page *page, fz_rect bbox, const char *uri)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_create_link():" << " auto_ctx=" << auto_ctx << " page=" << page << " bbox=" << bbox << " uri=" << uri << "\n";
	}
	fz_link * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_create_link(auto_ctx, page, bbox, uri);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_create_object()`. */
FZ_FUNCTION int ppdf_create_object(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_create_object():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_create_object(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_create_signature_widget()`. */
FZ_FUNCTION pdf_annot *ppdf_create_signature_widget(pdf_page *page, char *name)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_create_signature_widget():" << " auto_ctx=" << auto_ctx << " page=" << page << " name=" << (void*) name << "\n";
	}
	pdf_annot * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_create_signature_widget(auto_ctx, page, name);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_crypt_encrypt_metadata()`. */
FZ_FUNCTION int ppdf_crypt_encrypt_metadata(pdf_crypt *crypt)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_crypt_encrypt_metadata():" << " auto_ctx=" << auto_ctx << " crypt=" << crypt << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_crypt_encrypt_metadata(auto_ctx, crypt);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_crypt_key()`. */
FZ_FUNCTION unsigned char *ppdf_crypt_key(pdf_crypt *crypt)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_crypt_key():" << " auto_ctx=" << auto_ctx << " crypt=" << crypt << "\n";
	}
	unsigned char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_crypt_key(auto_ctx, crypt);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_crypt_length()`. */
FZ_FUNCTION int ppdf_crypt_length(pdf_crypt *crypt)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_crypt_length():" << " auto_ctx=" << auto_ctx << " crypt=" << crypt << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_crypt_length(auto_ctx, crypt);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_crypt_method()`. */
FZ_FUNCTION char *ppdf_crypt_method(pdf_crypt *crypt)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_crypt_method():" << " auto_ctx=" << auto_ctx << " crypt=" << crypt << "\n";
	}
	char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_crypt_method(auto_ctx, crypt);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_crypt_obj()`. */
FZ_FUNCTION void ppdf_crypt_obj(pdf_crypt *crypt, pdf_obj *obj, int num, int gen)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_crypt_obj():" << " auto_ctx=" << auto_ctx << " crypt=" << crypt << " obj=" << obj << " num=" << num << " gen=" << gen << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_crypt_obj(auto_ctx, crypt, obj, num, gen);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_crypt_owner_encryption()`. */
FZ_FUNCTION unsigned char *ppdf_crypt_owner_encryption(pdf_crypt *crypt)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_crypt_owner_encryption():" << " auto_ctx=" << auto_ctx << " crypt=" << crypt << "\n";
	}
	unsigned char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_crypt_owner_encryption(auto_ctx, crypt);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_crypt_owner_password()`. */
FZ_FUNCTION unsigned char *ppdf_crypt_owner_password(pdf_crypt *crypt)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_crypt_owner_password():" << " auto_ctx=" << auto_ctx << " crypt=" << crypt << "\n";
	}
	unsigned char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_crypt_owner_password(auto_ctx, crypt);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_crypt_permissions()`. */
FZ_FUNCTION int ppdf_crypt_permissions(pdf_crypt *crypt)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_crypt_permissions():" << " auto_ctx=" << auto_ctx << " crypt=" << crypt << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_crypt_permissions(auto_ctx, crypt);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_crypt_permissions_encryption()`. */
FZ_FUNCTION unsigned char *ppdf_crypt_permissions_encryption(pdf_crypt *crypt)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_crypt_permissions_encryption():" << " auto_ctx=" << auto_ctx << " crypt=" << crypt << "\n";
	}
	unsigned char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_crypt_permissions_encryption(auto_ctx, crypt);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_crypt_revision()`. */
FZ_FUNCTION int ppdf_crypt_revision(pdf_crypt *crypt)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_crypt_revision():" << " auto_ctx=" << auto_ctx << " crypt=" << crypt << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_crypt_revision(auto_ctx, crypt);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_crypt_user_encryption()`. */
FZ_FUNCTION unsigned char *ppdf_crypt_user_encryption(pdf_crypt *crypt)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_crypt_user_encryption():" << " auto_ctx=" << auto_ctx << " crypt=" << crypt << "\n";
	}
	unsigned char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_crypt_user_encryption(auto_ctx, crypt);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_crypt_user_password()`. */
FZ_FUNCTION unsigned char *ppdf_crypt_user_password(pdf_crypt *crypt)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_crypt_user_password():" << " auto_ctx=" << auto_ctx << " crypt=" << crypt << "\n";
	}
	unsigned char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_crypt_user_password(auto_ctx, crypt);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_crypt_version()`. */
FZ_FUNCTION int ppdf_crypt_version(pdf_crypt *crypt)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_crypt_version():" << " auto_ctx=" << auto_ctx << " crypt=" << crypt << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_crypt_version(auto_ctx, crypt);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_debug_doc_changes()`. */
FZ_FUNCTION void ppdf_debug_doc_changes(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_debug_doc_changes():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_debug_doc_changes(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_debug_obj()`. */
FZ_FUNCTION void ppdf_debug_obj(pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_debug_obj():" << " auto_ctx=" << auto_ctx << " obj=" << obj << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_debug_obj(auto_ctx, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_debug_ref()`. */
FZ_FUNCTION void ppdf_debug_ref(pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_debug_ref():" << " auto_ctx=" << auto_ctx << " obj=" << obj << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_debug_ref(auto_ctx, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_decode_cmap()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_decode_cmap(pdf_cmap *cmap, unsigned char *s, unsigned char *e)` => `(int, unsigned int cpt)`
*/
FZ_FUNCTION int ppdf_decode_cmap(pdf_cmap *cmap, unsigned char *s, unsigned char *e, unsigned int *cpt)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_decode_cmap():" << " cmap=" << cmap << " s=" << (void*) s << " e=" << (void*) e << " cpt=" << (void*) cpt << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_decode_cmap(cmap, s, e, cpt);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_deep_copy_obj()`. */
FZ_FUNCTION pdf_obj *ppdf_deep_copy_obj(pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_deep_copy_obj():" << " auto_ctx=" << auto_ctx << " obj=" << obj << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_deep_copy_obj(auto_ctx, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_delete_annot()`. */
FZ_FUNCTION void ppdf_delete_annot(pdf_page *page, pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_delete_annot():" << " auto_ctx=" << auto_ctx << " page=" << page << " annot=" << annot << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_delete_annot(auto_ctx, page, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_delete_object()`. */
FZ_FUNCTION void ppdf_delete_object(pdf_document *doc, int num)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_delete_object():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " num=" << num << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_delete_object(auto_ctx, doc, num);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_delete_page()`. */
FZ_FUNCTION void ppdf_delete_page(pdf_document *doc, int number)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_delete_page():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " number=" << number << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_delete_page(auto_ctx, doc, number);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_delete_page_range()`. */
FZ_FUNCTION void ppdf_delete_page_range(pdf_document *doc, int start, int end)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_delete_page_range():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " start=" << start << " end=" << end << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_delete_page_range(auto_ctx, doc, start, end);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_deselect_layer_config_ui()`. */
FZ_FUNCTION void ppdf_deselect_layer_config_ui(pdf_document *doc, int ui)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_deselect_layer_config_ui():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " ui=" << ui << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_deselect_layer_config_ui(auto_ctx, doc, ui);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_deserialise_journal()`. */
FZ_FUNCTION void ppdf_deserialise_journal(pdf_document *doc, fz_stream *stm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_deserialise_journal():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " stm=" << stm << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_deserialise_journal(auto_ctx, doc, stm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_dict_del()`. */
FZ_FUNCTION void ppdf_dict_del(pdf_obj *dict, pdf_obj *key)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_del():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_dict_del(auto_ctx, dict, key);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_dict_dels()`. */
FZ_FUNCTION void ppdf_dict_dels(pdf_obj *dict, const char *key)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_dels():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_dict_dels(auto_ctx, dict, key);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_dict_get()`. */
FZ_FUNCTION pdf_obj *ppdf_dict_get(pdf_obj *dict, pdf_obj *key)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_get():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_dict_get(auto_ctx, dict, key);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_dict_get_bool()`. */
FZ_FUNCTION int ppdf_dict_get_bool(pdf_obj *dict, pdf_obj *key)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_get_bool():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_dict_get_bool(auto_ctx, dict, key);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_dict_get_date()`. */
FZ_FUNCTION int64_t ppdf_dict_get_date(pdf_obj *dict, pdf_obj *key)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_get_date():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << "\n";
	}
	int64_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_dict_get_date(auto_ctx, dict, key);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_dict_get_inheritable()`. */
FZ_FUNCTION pdf_obj *ppdf_dict_get_inheritable(pdf_obj *dict, pdf_obj *key)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_get_inheritable():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_dict_get_inheritable(auto_ctx, dict, key);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_dict_get_int()`. */
FZ_FUNCTION int ppdf_dict_get_int(pdf_obj *dict, pdf_obj *key)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_get_int():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_dict_get_int(auto_ctx, dict, key);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_dict_get_key()`. */
FZ_FUNCTION pdf_obj *ppdf_dict_get_key(pdf_obj *dict, int idx)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_get_key():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " idx=" << idx << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_dict_get_key(auto_ctx, dict, idx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_dict_get_matrix()`. */
FZ_FUNCTION fz_matrix ppdf_dict_get_matrix(pdf_obj *dict, pdf_obj *key)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_get_matrix():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << "\n";
	}
	fz_matrix ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_dict_get_matrix(auto_ctx, dict, key);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_dict_get_name()`. */
FZ_FUNCTION const char *ppdf_dict_get_name(pdf_obj *dict, pdf_obj *key)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_get_name():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_dict_get_name(auto_ctx, dict, key);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_dict_get_put_drop()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_dict_get_put_drop(pdf_obj *dict, pdf_obj *key, pdf_obj *val, pdf_obj **old_val)` => 
*/
FZ_FUNCTION void ppdf_dict_get_put_drop(pdf_obj *dict, pdf_obj *key, pdf_obj *val, pdf_obj **old_val)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_get_put_drop():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << " val=" << val << " old_val=" << (void*) old_val << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_dict_get_put_drop(auto_ctx, dict, key, val, old_val);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_dict_get_real()`. */
FZ_FUNCTION float ppdf_dict_get_real(pdf_obj *dict, pdf_obj *key)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_get_real():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << "\n";
	}
	float ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_dict_get_real(auto_ctx, dict, key);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_dict_get_rect()`. */
FZ_FUNCTION fz_rect ppdf_dict_get_rect(pdf_obj *dict, pdf_obj *key)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_get_rect():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << "\n";
	}
	fz_rect ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_dict_get_rect(auto_ctx, dict, key);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_dict_get_string()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_dict_get_string(pdf_obj *dict, pdf_obj *key)` => `(const char *, size_t sizep)`
*/
FZ_FUNCTION const char *ppdf_dict_get_string(pdf_obj *dict, pdf_obj *key, size_t *sizep)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_get_string():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << " sizep=" << (void*) sizep << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_dict_get_string(auto_ctx, dict, key, sizep);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_dict_get_text_string()`. */
FZ_FUNCTION const char *ppdf_dict_get_text_string(pdf_obj *dict, pdf_obj *key)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_get_text_string():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_dict_get_text_string(auto_ctx, dict, key);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_dict_get_val()`. */
FZ_FUNCTION pdf_obj *ppdf_dict_get_val(pdf_obj *dict, int idx)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_get_val():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " idx=" << idx << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_dict_get_val(auto_ctx, dict, idx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_dict_geta()`. */
FZ_FUNCTION pdf_obj *ppdf_dict_geta(pdf_obj *dict, pdf_obj *key, pdf_obj *abbrev)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_geta():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << " abbrev=" << abbrev << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_dict_geta(auto_ctx, dict, key, abbrev);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_dict_getp()`. */
FZ_FUNCTION pdf_obj *ppdf_dict_getp(pdf_obj *dict, const char *path)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_getp():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " path=" << path << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_dict_getp(auto_ctx, dict, path);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_dict_getp_inheritable()`. */
FZ_FUNCTION pdf_obj *ppdf_dict_getp_inheritable(pdf_obj *dict, const char *path)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_getp_inheritable():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " path=" << path << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_dict_getp_inheritable(auto_ctx, dict, path);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_dict_gets()`. */
FZ_FUNCTION pdf_obj *ppdf_dict_gets(pdf_obj *dict, const char *key)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_gets():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_dict_gets(auto_ctx, dict, key);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_dict_getsa()`. */
FZ_FUNCTION pdf_obj *ppdf_dict_getsa(pdf_obj *dict, const char *key, const char *abbrev)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_getsa():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << " abbrev=" << abbrev << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_dict_getsa(auto_ctx, dict, key, abbrev);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_dict_len()`. */
FZ_FUNCTION int ppdf_dict_len(pdf_obj *dict)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_len():" << " auto_ctx=" << auto_ctx << " dict=" << dict << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_dict_len(auto_ctx, dict);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_dict_put()`. */
FZ_FUNCTION void ppdf_dict_put(pdf_obj *dict, pdf_obj *key, pdf_obj *val)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_put():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << " val=" << val << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_dict_put(auto_ctx, dict, key, val);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_dict_put_array()`. */
FZ_FUNCTION pdf_obj *ppdf_dict_put_array(pdf_obj *dict, pdf_obj *key, int initial)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_put_array():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << " initial=" << initial << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_dict_put_array(auto_ctx, dict, key, initial);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_dict_put_bool()`. */
FZ_FUNCTION void ppdf_dict_put_bool(pdf_obj *dict, pdf_obj *key, int x)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_put_bool():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << " x=" << x << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_dict_put_bool(auto_ctx, dict, key, x);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_dict_put_date()`. */
FZ_FUNCTION void ppdf_dict_put_date(pdf_obj *dict, pdf_obj *key, int64_t time)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_put_date():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << " time=" << time << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_dict_put_date(auto_ctx, dict, key, time);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_dict_put_dict()`. */
FZ_FUNCTION pdf_obj *ppdf_dict_put_dict(pdf_obj *dict, pdf_obj *key, int initial)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_put_dict():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << " initial=" << initial << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_dict_put_dict(auto_ctx, dict, key, initial);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_dict_put_drop()`. */
FZ_FUNCTION void ppdf_dict_put_drop(pdf_obj *dict, pdf_obj *key, pdf_obj *val)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_put_drop():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << " val=" << val << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_dict_put_drop(auto_ctx, dict, key, val);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_dict_put_int()`. */
FZ_FUNCTION void ppdf_dict_put_int(pdf_obj *dict, pdf_obj *key, int64_t x)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_put_int():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << " x=" << x << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_dict_put_int(auto_ctx, dict, key, x);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_dict_put_matrix()`. */
FZ_FUNCTION void ppdf_dict_put_matrix(pdf_obj *dict, pdf_obj *key, fz_matrix x)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_put_matrix():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << " x=" << x << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_dict_put_matrix(auto_ctx, dict, key, x);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_dict_put_name()`. */
FZ_FUNCTION void ppdf_dict_put_name(pdf_obj *dict, pdf_obj *key, const char *x)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_put_name():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << " x=" << x << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_dict_put_name(auto_ctx, dict, key, x);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_dict_put_real()`. */
FZ_FUNCTION void ppdf_dict_put_real(pdf_obj *dict, pdf_obj *key, double x)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_put_real():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << " x=" << x << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_dict_put_real(auto_ctx, dict, key, x);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_dict_put_rect()`. */
FZ_FUNCTION void ppdf_dict_put_rect(pdf_obj *dict, pdf_obj *key, fz_rect x)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_put_rect():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << " x=" << x << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_dict_put_rect(auto_ctx, dict, key, x);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_dict_put_string()`. */
FZ_FUNCTION void ppdf_dict_put_string(pdf_obj *dict, pdf_obj *key, const char *x, size_t n)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_put_string():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << " x=" << x << " n=" << n << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_dict_put_string(auto_ctx, dict, key, x, n);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_dict_put_text_string()`. */
FZ_FUNCTION void ppdf_dict_put_text_string(pdf_obj *dict, pdf_obj *key, const char *x)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_put_text_string():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << " x=" << x << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_dict_put_text_string(auto_ctx, dict, key, x);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_dict_put_val_null()`. */
FZ_FUNCTION void ppdf_dict_put_val_null(pdf_obj *obj, int idx)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_put_val_null():" << " auto_ctx=" << auto_ctx << " obj=" << obj << " idx=" << idx << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_dict_put_val_null(auto_ctx, obj, idx);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_dict_putp()`. */
FZ_FUNCTION void ppdf_dict_putp(pdf_obj *dict, const char *path, pdf_obj *val)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_putp():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " path=" << path << " val=" << val << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_dict_putp(auto_ctx, dict, path, val);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_dict_putp_drop()`. */
FZ_FUNCTION void ppdf_dict_putp_drop(pdf_obj *dict, const char *path, pdf_obj *val)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_putp_drop():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " path=" << path << " val=" << val << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_dict_putp_drop(auto_ctx, dict, path, val);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_dict_puts()`. */
FZ_FUNCTION void ppdf_dict_puts(pdf_obj *dict, const char *key, pdf_obj *val)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_puts():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << " val=" << val << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_dict_puts(auto_ctx, dict, key, val);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_dict_puts_dict()`. */
FZ_FUNCTION pdf_obj *ppdf_dict_puts_dict(pdf_obj *dict, const char *key, int initial)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_puts_dict():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << " initial=" << initial << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_dict_puts_dict(auto_ctx, dict, key, initial);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_dict_puts_drop()`. */
FZ_FUNCTION void ppdf_dict_puts_drop(pdf_obj *dict, const char *key, pdf_obj *val)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dict_puts_drop():" << " auto_ctx=" << auto_ctx << " dict=" << dict << " key=" << key << " val=" << val << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_dict_puts_drop(auto_ctx, dict, key, val);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_dirty_annot()`. */
FZ_FUNCTION void ppdf_dirty_annot(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dirty_annot():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_dirty_annot(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_dirty_obj()`. */
FZ_FUNCTION void ppdf_dirty_obj(pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_dirty_obj():" << " auto_ctx=" << auto_ctx << " obj=" << obj << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_dirty_obj(auto_ctx, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_disable_js()`. */
FZ_FUNCTION void ppdf_disable_js(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_disable_js():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_disable_js(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_discard_journal()`. */
FZ_FUNCTION void ppdf_discard_journal(pdf_journal *journal)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_discard_journal():" << " auto_ctx=" << auto_ctx << " journal=" << journal << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_discard_journal(auto_ctx, journal);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_doc_was_linearized()`. */
FZ_FUNCTION int ppdf_doc_was_linearized(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_doc_was_linearized():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_doc_was_linearized(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_document_event_did_print()`. */
FZ_FUNCTION void ppdf_document_event_did_print(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_document_event_did_print():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_document_event_did_print(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_document_event_did_save()`. */
FZ_FUNCTION void ppdf_document_event_did_save(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_document_event_did_save():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_document_event_did_save(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_document_event_will_close()`. */
FZ_FUNCTION void ppdf_document_event_will_close(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_document_event_will_close():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_document_event_will_close(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_document_event_will_print()`. */
FZ_FUNCTION void ppdf_document_event_will_print(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_document_event_will_print():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_document_event_will_print(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_document_event_will_save()`. */
FZ_FUNCTION void ppdf_document_event_will_save(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_document_event_will_save():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_document_event_will_save(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_document_from_fz_document()`. */
FZ_FUNCTION pdf_document *ppdf_document_from_fz_document(fz_document *ptr)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_document_from_fz_document():" << " auto_ctx=" << auto_ctx << " ptr=" << ptr << "\n";
	}
	pdf_document * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_document_from_fz_document(auto_ctx, ptr);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_document_language()`. */
FZ_FUNCTION fz_text_language ppdf_document_language(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_document_language():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_text_language ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_document_language(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_document_output_intent()`. */
FZ_FUNCTION fz_colorspace *ppdf_document_output_intent(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_document_output_intent():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_colorspace * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_document_output_intent(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_document_permissions()`. */
FZ_FUNCTION int ppdf_document_permissions(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_document_permissions():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_document_permissions(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_drop_annot()`. */
FZ_FUNCTION void ppdf_drop_annot(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_drop_annot():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_drop_annot(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_drop_cmap()`. */
FZ_FUNCTION void ppdf_drop_cmap(pdf_cmap *cmap)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_drop_cmap():" << " auto_ctx=" << auto_ctx << " cmap=" << cmap << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_drop_cmap(auto_ctx, cmap);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_drop_cmap_imp()`. */
FZ_FUNCTION void ppdf_drop_cmap_imp(fz_storable *cmap)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_drop_cmap_imp():" << " auto_ctx=" << auto_ctx << " cmap=" << cmap << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_drop_cmap_imp(auto_ctx, cmap);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_drop_crypt()`. */
FZ_FUNCTION void ppdf_drop_crypt(pdf_crypt *crypt)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_drop_crypt():" << " auto_ctx=" << auto_ctx << " crypt=" << crypt << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_drop_crypt(auto_ctx, crypt);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_drop_document()`. */
FZ_FUNCTION void ppdf_drop_document(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_drop_document():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_drop_document(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_drop_font()`. */
FZ_FUNCTION void ppdf_drop_font(pdf_font_desc *font)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_drop_font():" << " auto_ctx=" << auto_ctx << " font=" << font << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_drop_font(auto_ctx, font);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_drop_function()`. */
FZ_FUNCTION void ppdf_drop_function(pdf_function *func)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_drop_function():" << " auto_ctx=" << auto_ctx << " func=" << func << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_drop_function(auto_ctx, func);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_drop_graft_map()`. */
FZ_FUNCTION void ppdf_drop_graft_map(pdf_graft_map *map)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_drop_graft_map():" << " auto_ctx=" << auto_ctx << " map=" << map << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_drop_graft_map(auto_ctx, map);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_drop_journal()`. */
FZ_FUNCTION void ppdf_drop_journal(pdf_journal *journal)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_drop_journal():" << " auto_ctx=" << auto_ctx << " journal=" << journal << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_drop_journal(auto_ctx, journal);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_drop_js()`. */
FZ_FUNCTION void ppdf_drop_js(pdf_js *js)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_drop_js():" << " auto_ctx=" << auto_ctx << " js=" << js << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_drop_js(auto_ctx, js);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_drop_local_xref()`. */
FZ_FUNCTION void ppdf_drop_local_xref(pdf_xref *xref)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_drop_local_xref():" << " auto_ctx=" << auto_ctx << " xref=" << xref << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_drop_local_xref(auto_ctx, xref);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_drop_local_xref_and_resources()`. */
FZ_FUNCTION void ppdf_drop_local_xref_and_resources(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_drop_local_xref_and_resources():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_drop_local_xref_and_resources(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_drop_locked_fields()`. */
FZ_FUNCTION void ppdf_drop_locked_fields(pdf_locked_fields *locked)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_drop_locked_fields():" << " auto_ctx=" << auto_ctx << " locked=" << locked << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_drop_locked_fields(auto_ctx, locked);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_drop_obj()`. */
FZ_FUNCTION void ppdf_drop_obj(pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_drop_obj():" << " auto_ctx=" << auto_ctx << " obj=" << obj << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_drop_obj(auto_ctx, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_drop_ocg()`. */
FZ_FUNCTION void ppdf_drop_ocg(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_drop_ocg():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_drop_ocg(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_drop_page_tree()`. */
FZ_FUNCTION void ppdf_drop_page_tree(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_drop_page_tree():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_drop_page_tree(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_drop_pattern()`. */
FZ_FUNCTION void ppdf_drop_pattern(pdf_pattern *pat)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_drop_pattern():" << " auto_ctx=" << auto_ctx << " pat=" << pat << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_drop_pattern(auto_ctx, pat);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_drop_processor()`. */
FZ_FUNCTION void ppdf_drop_processor(pdf_processor *proc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_drop_processor():" << " auto_ctx=" << auto_ctx << " proc=" << proc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_drop_processor(auto_ctx, proc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_drop_resource_tables()`. */
FZ_FUNCTION void ppdf_drop_resource_tables(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_drop_resource_tables():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_drop_resource_tables(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_drop_signer()`. */
FZ_FUNCTION void ppdf_drop_signer(pdf_pkcs7_signer *signer)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_drop_signer():" << " auto_ctx=" << auto_ctx << " signer=" << signer << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_drop_signer(auto_ctx, signer);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_drop_verifier()`. */
FZ_FUNCTION void ppdf_drop_verifier(pdf_pkcs7_verifier *verifier)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_drop_verifier():" << " auto_ctx=" << auto_ctx << " verifier=" << verifier << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_drop_verifier(auto_ctx, verifier);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_drop_widget()`. */
FZ_FUNCTION void ppdf_drop_widget(pdf_annot *widget)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_drop_widget():" << " auto_ctx=" << auto_ctx << " widget=" << widget << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_drop_widget(auto_ctx, widget);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_edit_text_field_value()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_edit_text_field_value(pdf_annot *widget, const char *value, const char *change)` => `(int, int selStart, int selEnd, char *newvalue)`
*/
FZ_FUNCTION int ppdf_edit_text_field_value(pdf_annot *widget, const char *value, const char *change, int *selStart, int *selEnd, char **newvalue)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_edit_text_field_value():" << " auto_ctx=" << auto_ctx << " widget=" << widget << " value=" << value << " change=" << change << " selStart=" << (void*) selStart << " selEnd=" << (void*) selEnd << " newvalue=" << (void*) newvalue << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_edit_text_field_value(auto_ctx, widget, value, change, selStart, selEnd, newvalue);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_embedded_file_name()`. */
FZ_FUNCTION const char *ppdf_embedded_file_name(pdf_obj *fs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_embedded_file_name():" << " auto_ctx=" << auto_ctx << " fs=" << fs << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_embedded_file_name(auto_ctx, fs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_embedded_file_stream()`. */
FZ_FUNCTION pdf_obj *ppdf_embedded_file_stream(pdf_obj *fs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_embedded_file_stream():" << " auto_ctx=" << auto_ctx << " fs=" << fs << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_embedded_file_stream(auto_ctx, fs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_embedded_file_type()`. */
FZ_FUNCTION const char *ppdf_embedded_file_type(pdf_obj *fs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_embedded_file_type():" << " auto_ctx=" << auto_ctx << " fs=" << fs << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_embedded_file_type(auto_ctx, fs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_empty_store()`. */
FZ_FUNCTION void ppdf_empty_store(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_empty_store():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_empty_store(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_enable_journal()`. */
FZ_FUNCTION void ppdf_enable_journal(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_enable_journal():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_enable_journal(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_enable_js()`. */
FZ_FUNCTION void ppdf_enable_js(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_enable_js():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_enable_js(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_encrypt_data()`. */
FZ_FUNCTION void ppdf_encrypt_data(pdf_crypt *crypt, int num, int gen, void (*fmt_str_out)(fz_context *, void *, const unsigned char *, size_t ), void *arg, const unsigned char *s, size_t n)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_encrypt_data():" << " auto_ctx=" << auto_ctx << " crypt=" << crypt << " num=" << num << " gen=" << gen << " fmt_str_out=" << (void*) fmt_str_out << " arg=" << (void*) arg << " s=" << (void*) s << " n=" << n << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_encrypt_data(auto_ctx, crypt, num, gen, fmt_str_out, arg, s, n);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_encrypted_len()`. */
FZ_FUNCTION size_t ppdf_encrypted_len(pdf_crypt *crypt, int num, int gen, size_t len)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_encrypted_len():" << " auto_ctx=" << auto_ctx << " crypt=" << crypt << " num=" << num << " gen=" << gen << " len=" << len << "\n";
	}
	size_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_encrypted_len(auto_ctx, crypt, num, gen, len);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_end_hmtx()`. */
FZ_FUNCTION void ppdf_end_hmtx(pdf_font_desc *font)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_end_hmtx():" << " auto_ctx=" << auto_ctx << " font=" << font << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_end_hmtx(auto_ctx, font);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_end_operation()`. */
FZ_FUNCTION void ppdf_end_operation(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_end_operation():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_end_operation(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_end_vmtx()`. */
FZ_FUNCTION void ppdf_end_vmtx(pdf_font_desc *font)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_end_vmtx():" << " auto_ctx=" << auto_ctx << " font=" << font << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_end_vmtx(auto_ctx, font);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_ensure_solid_xref()`. */
FZ_FUNCTION void ppdf_ensure_solid_xref(pdf_document *doc, int num)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_ensure_solid_xref():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " num=" << num << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_ensure_solid_xref(auto_ctx, doc, num);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_eval_function()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_eval_function(pdf_function *func, const float *in, int inlen, int outlen)` => float out
*/
FZ_FUNCTION void ppdf_eval_function(pdf_function *func, const float *in, int inlen, float *out, int outlen)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_eval_function():" << " auto_ctx=" << auto_ctx << " func=" << func << " in=" << (void*) in << " inlen=" << inlen << " out=" << (void*) out << " outlen=" << outlen << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_eval_function(auto_ctx, func, in, inlen, out, outlen);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_event_issue_alert()`. */
FZ_FUNCTION void ppdf_event_issue_alert(pdf_document *doc, pdf_alert_event *evt)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_event_issue_alert():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " evt=" << evt << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_event_issue_alert(auto_ctx, doc, evt);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_event_issue_exec_menu_item()`. */
FZ_FUNCTION void ppdf_event_issue_exec_menu_item(pdf_document *doc, const char *item)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_event_issue_exec_menu_item():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " item=" << item << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_event_issue_exec_menu_item(auto_ctx, doc, item);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_event_issue_launch_url()`. */
FZ_FUNCTION void ppdf_event_issue_launch_url(pdf_document *doc, const char *url, int new_frame)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_event_issue_launch_url():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " url=" << url << " new_frame=" << new_frame << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_event_issue_launch_url(auto_ctx, doc, url, new_frame);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_event_issue_mail_doc()`. */
FZ_FUNCTION void ppdf_event_issue_mail_doc(pdf_document *doc, pdf_mail_doc_event *evt)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_event_issue_mail_doc():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " evt=" << evt << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_event_issue_mail_doc(auto_ctx, doc, evt);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_event_issue_print()`. */
FZ_FUNCTION void ppdf_event_issue_print(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_event_issue_print():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_event_issue_print(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_field_border_style()`. */
FZ_FUNCTION char *ppdf_field_border_style(pdf_obj *field)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_field_border_style():" << " auto_ctx=" << auto_ctx << " field=" << field << "\n";
	}
	char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_field_border_style(auto_ctx, field);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_field_display()`. */
FZ_FUNCTION int ppdf_field_display(pdf_obj *field)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_field_display():" << " auto_ctx=" << auto_ctx << " field=" << field << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_field_display(auto_ctx, field);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_field_event_calculate()`. */
FZ_FUNCTION void ppdf_field_event_calculate(pdf_document *doc, pdf_obj *field)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_field_event_calculate():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " field=" << field << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_field_event_calculate(auto_ctx, doc, field);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_field_event_format()`. */
FZ_FUNCTION char *ppdf_field_event_format(pdf_document *doc, pdf_obj *field)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_field_event_format():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " field=" << field << "\n";
	}
	char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_field_event_format(auto_ctx, doc, field);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_field_event_keystroke()`. */
FZ_FUNCTION int ppdf_field_event_keystroke(pdf_document *doc, pdf_obj *field, pdf_keystroke_event *evt)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_field_event_keystroke():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " field=" << field << " evt=" << evt << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_field_event_keystroke(auto_ctx, doc, field, evt);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_field_event_validate()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_field_event_validate(pdf_document *doc, pdf_obj *field, const char *value)` => `(int, char *newvalue)`
*/
FZ_FUNCTION int ppdf_field_event_validate(pdf_document *doc, pdf_obj *field, const char *value, char **newvalue)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_field_event_validate():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " field=" << field << " value=" << value << " newvalue=" << (void*) newvalue << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_field_event_validate(auto_ctx, doc, field, value, newvalue);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_field_flags()`. */
FZ_FUNCTION int ppdf_field_flags(pdf_obj *field)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_field_flags():" << " auto_ctx=" << auto_ctx << " field=" << field << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_field_flags(auto_ctx, field);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_field_label()`. */
FZ_FUNCTION const char *ppdf_field_label(pdf_obj *field)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_field_label():" << " auto_ctx=" << auto_ctx << " field=" << field << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_field_label(auto_ctx, field);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_field_name()`. */
FZ_FUNCTION char *ppdf_field_name(pdf_obj *field)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_field_name():" << " auto_ctx=" << auto_ctx << " field=" << field << "\n";
	}
	char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_field_name(auto_ctx, field);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_field_reset()`. */
FZ_FUNCTION void ppdf_field_reset(pdf_document *doc, pdf_obj *field)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_field_reset():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " field=" << field << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_field_reset(auto_ctx, doc, field);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_field_set_border_style()`. */
FZ_FUNCTION void ppdf_field_set_border_style(pdf_obj *field, const char *text)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_field_set_border_style():" << " auto_ctx=" << auto_ctx << " field=" << field << " text=" << text << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_field_set_border_style(auto_ctx, field, text);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_field_set_button_caption()`. */
FZ_FUNCTION void ppdf_field_set_button_caption(pdf_obj *field, const char *text)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_field_set_button_caption():" << " auto_ctx=" << auto_ctx << " field=" << field << " text=" << text << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_field_set_button_caption(auto_ctx, field, text);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_field_set_display()`. */
FZ_FUNCTION void ppdf_field_set_display(pdf_obj *field, int d)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_field_set_display():" << " auto_ctx=" << auto_ctx << " field=" << field << " d=" << d << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_field_set_display(auto_ctx, field, d);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_field_set_fill_color()`. */
FZ_FUNCTION void ppdf_field_set_fill_color(pdf_obj *field, pdf_obj *col)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_field_set_fill_color():" << " auto_ctx=" << auto_ctx << " field=" << field << " col=" << col << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_field_set_fill_color(auto_ctx, field, col);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_field_set_text_color()`. */
FZ_FUNCTION void ppdf_field_set_text_color(pdf_obj *field, pdf_obj *col)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_field_set_text_color():" << " auto_ctx=" << auto_ctx << " field=" << field << " col=" << col << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_field_set_text_color(auto_ctx, field, col);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_field_type()`. */
FZ_FUNCTION int ppdf_field_type(pdf_obj *field)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_field_type():" << " auto_ctx=" << auto_ctx << " field=" << field << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_field_type(auto_ctx, field);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_field_type_string()`. */
FZ_FUNCTION const char *ppdf_field_type_string(pdf_obj *field)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_field_type_string():" << " auto_ctx=" << auto_ctx << " field=" << field << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_field_type_string(auto_ctx, field);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_field_value()`. */
FZ_FUNCTION const char *ppdf_field_value(pdf_obj *field)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_field_value():" << " auto_ctx=" << auto_ctx << " field=" << field << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_field_value(auto_ctx, field);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_filter_annot_contents()`. */
FZ_FUNCTION void ppdf_filter_annot_contents(pdf_document *doc, pdf_annot *annot, pdf_filter_options *filter)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_filter_annot_contents():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " annot=" << annot << " filter=" << filter << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_filter_annot_contents(auto_ctx, doc, annot, filter);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_filter_page_contents()`. */
FZ_FUNCTION void ppdf_filter_page_contents(pdf_document *doc, pdf_page *page, pdf_filter_options *filter)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_filter_page_contents():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " page=" << page << " filter=" << filter << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_filter_page_contents(auto_ctx, doc, page, filter);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_filter_xobject_instance()`. */
FZ_FUNCTION pdf_obj *ppdf_filter_xobject_instance(pdf_obj *old_xobj, pdf_obj *page_res, fz_matrix ctm, pdf_filter_options *filter)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_filter_xobject_instance():" << " auto_ctx=" << auto_ctx << " old_xobj=" << old_xobj << " page_res=" << page_res << " ctm=" << ctm << " filter=" << filter << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_filter_xobject_instance(auto_ctx, old_xobj, page_res, ctm, filter);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_find_font_resource()`. */
FZ_FUNCTION pdf_obj *ppdf_find_font_resource(pdf_document *doc, int type, int encoding, fz_font *item, pdf_font_resource_key *key)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_find_font_resource():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " type=" << type << " encoding=" << encoding << " item=" << item << " key=" << key << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_find_font_resource(auto_ctx, doc, type, encoding, item, key);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_find_item()`. */
FZ_FUNCTION void *ppdf_find_item(fz_store_drop_fn *drop, pdf_obj *key)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_find_item():" << " auto_ctx=" << auto_ctx << " drop=" << (void*) drop << " key=" << key << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_find_item(auto_ctx, drop, key);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_find_locked_fields()`. */
FZ_FUNCTION pdf_locked_fields *ppdf_find_locked_fields(pdf_document *doc, int version)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_find_locked_fields():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " version=" << version << "\n";
	}
	pdf_locked_fields * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_find_locked_fields(auto_ctx, doc, version);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_find_locked_fields_for_sig()`. */
FZ_FUNCTION pdf_locked_fields *ppdf_find_locked_fields_for_sig(pdf_document *doc, pdf_obj *sig)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_find_locked_fields_for_sig():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " sig=" << sig << "\n";
	}
	pdf_locked_fields * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_find_locked_fields_for_sig(auto_ctx, doc, sig);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_find_version_for_obj()`. */
FZ_FUNCTION int ppdf_find_version_for_obj(pdf_document *doc, pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_find_version_for_obj():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " obj=" << obj << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_find_version_for_obj(auto_ctx, doc, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_first_annot()`. */
FZ_FUNCTION pdf_annot *ppdf_first_annot(pdf_page *page)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_first_annot():" << " auto_ctx=" << auto_ctx << " page=" << page << "\n";
	}
	pdf_annot * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_first_annot(auto_ctx, page);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_first_widget()`. */
FZ_FUNCTION pdf_annot *ppdf_first_widget(pdf_page *page)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_first_widget():" << " auto_ctx=" << auto_ctx << " page=" << page << "\n";
	}
	pdf_annot * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_first_widget(auto_ctx, page);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_flatten_inheritable_page_items()`. */
FZ_FUNCTION void ppdf_flatten_inheritable_page_items(pdf_obj *page)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_flatten_inheritable_page_items():" << " auto_ctx=" << auto_ctx << " page=" << page << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_flatten_inheritable_page_items(auto_ctx, page);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_font_cid_to_gid()`. */
FZ_FUNCTION int ppdf_font_cid_to_gid(pdf_font_desc *fontdesc, int cid)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_font_cid_to_gid():" << " auto_ctx=" << auto_ctx << " fontdesc=" << fontdesc << " cid=" << cid << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_font_cid_to_gid(auto_ctx, fontdesc, cid);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_font_writing_supported()`. */
FZ_FUNCTION int ppdf_font_writing_supported(fz_font *font)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_font_writing_supported():" << " font=" << font << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_font_writing_supported(font);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_forget_xref()`. */
FZ_FUNCTION void ppdf_forget_xref(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_forget_xref():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_forget_xref(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_format_date()`. */
FZ_FUNCTION char *ppdf_format_date(int64_t time, char *s, size_t n)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_format_date():" << " auto_ctx=" << auto_ctx << " time=" << time << " s=" << (void*) s << " n=" << n << "\n";
	}
	char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_format_date(auto_ctx, time, s, n);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_format_link_uri()`. */
FZ_FUNCTION char *ppdf_format_link_uri(fz_link_dest dest)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_format_link_uri():" << " auto_ctx=" << auto_ctx << " &dest=" << &dest << "\n";
	}
	char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_format_link_uri(auto_ctx, dest);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_format_write_options()`. */
FZ_FUNCTION char *ppdf_format_write_options(char *buffer, size_t buffer_len, const pdf_write_options *opts)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_format_write_options():" << " auto_ctx=" << auto_ctx << " buffer=" << (void*) buffer << " buffer_len=" << buffer_len << " opts=" << opts << "\n";
	}
	char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_format_write_options(auto_ctx, buffer, buffer_len, opts);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_function_size()`. */
FZ_FUNCTION size_t ppdf_function_size(pdf_function *func)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_function_size():" << " auto_ctx=" << auto_ctx << " func=" << func << "\n";
	}
	size_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_function_size(auto_ctx, func);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_get_bound_document()`. */
FZ_FUNCTION pdf_document *ppdf_get_bound_document(pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_get_bound_document():" << " auto_ctx=" << auto_ctx << " obj=" << obj << "\n";
	}
	pdf_document * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_get_bound_document(auto_ctx, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_get_doc_event_callback_data()`. */
FZ_FUNCTION void *ppdf_get_doc_event_callback_data(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_get_doc_event_callback_data():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	void * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_get_doc_event_callback_data(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_get_incremental_xref_entry()`. */
FZ_FUNCTION pdf_xref_entry *ppdf_get_incremental_xref_entry(pdf_document *doc, int i)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_get_incremental_xref_entry():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " i=" << i << "\n";
	}
	pdf_xref_entry * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_get_incremental_xref_entry(auto_ctx, doc, i);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_get_indirect_document()`. */
FZ_FUNCTION pdf_document *ppdf_get_indirect_document(pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_get_indirect_document():" << " auto_ctx=" << auto_ctx << " obj=" << obj << "\n";
	}
	pdf_document * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_get_indirect_document(auto_ctx, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_get_populating_xref_entry()`. */
FZ_FUNCTION pdf_xref_entry *ppdf_get_populating_xref_entry(pdf_document *doc, int i)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_get_populating_xref_entry():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " i=" << i << "\n";
	}
	pdf_xref_entry * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_get_populating_xref_entry(auto_ctx, doc, i);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_get_widget_editing_state()`. */
FZ_FUNCTION int ppdf_get_widget_editing_state(pdf_annot *widget)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_get_widget_editing_state():" << " auto_ctx=" << auto_ctx << " widget=" << widget << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_get_widget_editing_state(auto_ctx, widget);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_get_xref_entry()`. */
FZ_FUNCTION pdf_xref_entry *ppdf_get_xref_entry(pdf_document *doc, int i)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_get_xref_entry():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " i=" << i << "\n";
	}
	pdf_xref_entry * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_get_xref_entry(auto_ctx, doc, i);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_graft_mapped_object()`. */
FZ_FUNCTION pdf_obj *ppdf_graft_mapped_object(pdf_graft_map *map, pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_graft_mapped_object():" << " auto_ctx=" << auto_ctx << " map=" << map << " obj=" << obj << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_graft_mapped_object(auto_ctx, map, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_graft_mapped_page()`. */
FZ_FUNCTION void ppdf_graft_mapped_page(pdf_graft_map *map, int page_to, pdf_document *src, int page_from)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_graft_mapped_page():" << " auto_ctx=" << auto_ctx << " map=" << map << " page_to=" << page_to << " src=" << src << " page_from=" << page_from << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_graft_mapped_page(auto_ctx, map, page_to, src, page_from);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_graft_object()`. */
FZ_FUNCTION pdf_obj *ppdf_graft_object(pdf_document *dst, pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_graft_object():" << " auto_ctx=" << auto_ctx << " dst=" << dst << " obj=" << obj << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_graft_object(auto_ctx, dst, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_graft_page()`. */
FZ_FUNCTION void ppdf_graft_page(pdf_document *dst, int page_to, pdf_document *src, int page_from)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_graft_page():" << " auto_ctx=" << auto_ctx << " dst=" << dst << " page_to=" << page_to << " src=" << src << " page_from=" << page_from << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_graft_page(auto_ctx, dst, page_to, src, page_from);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_guess_mime_type_from_file_name()`. */
FZ_FUNCTION const char *ppdf_guess_mime_type_from_file_name(const char *filename)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_guess_mime_type_from_file_name():" << " auto_ctx=" << auto_ctx << " filename=" << filename << "\n";
	}
	const char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_guess_mime_type_from_file_name(auto_ctx, filename);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_has_permission()`. */
FZ_FUNCTION int ppdf_has_permission(pdf_document *doc, fz_permission p)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_has_permission():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " p=" << p << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_has_permission(auto_ctx, doc, p);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_has_unsaved_changes()`. */
FZ_FUNCTION int ppdf_has_unsaved_changes(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_has_unsaved_changes():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_has_unsaved_changes(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_has_unsaved_sigs()`. */
FZ_FUNCTION int ppdf_has_unsaved_sigs(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_has_unsaved_sigs():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_has_unsaved_sigs(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_insert_font_resource()`. */
FZ_FUNCTION pdf_obj *ppdf_insert_font_resource(pdf_document *doc, pdf_font_resource_key *key, pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_insert_font_resource():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " key=" << key << " obj=" << obj << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_insert_font_resource(auto_ctx, doc, key, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_insert_page()`. */
FZ_FUNCTION void ppdf_insert_page(pdf_document *doc, int at, pdf_obj *page)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_insert_page():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " at=" << at << " page=" << page << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_insert_page(auto_ctx, doc, at, page);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_invalidate_xfa()`. */
FZ_FUNCTION void ppdf_invalidate_xfa(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_invalidate_xfa():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_invalidate_xfa(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_is_array()`. */
FZ_FUNCTION int ppdf_is_array(pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_is_array():" << " auto_ctx=" << auto_ctx << " obj=" << obj << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_is_array(auto_ctx, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_is_bool()`. */
FZ_FUNCTION int ppdf_is_bool(pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_is_bool():" << " auto_ctx=" << auto_ctx << " obj=" << obj << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_is_bool(auto_ctx, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_is_dict()`. */
FZ_FUNCTION int ppdf_is_dict(pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_is_dict():" << " auto_ctx=" << auto_ctx << " obj=" << obj << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_is_dict(auto_ctx, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_is_embedded_file()`. */
FZ_FUNCTION int ppdf_is_embedded_file(pdf_obj *fs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_is_embedded_file():" << " auto_ctx=" << auto_ctx << " fs=" << fs << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_is_embedded_file(auto_ctx, fs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_is_field_locked()`. */
FZ_FUNCTION int ppdf_is_field_locked(pdf_locked_fields *locked, const char *name)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_is_field_locked():" << " auto_ctx=" << auto_ctx << " locked=" << locked << " name=" << name << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_is_field_locked(auto_ctx, locked, name);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_is_indirect()`. */
FZ_FUNCTION int ppdf_is_indirect(pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_is_indirect():" << " auto_ctx=" << auto_ctx << " obj=" << obj << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_is_indirect(auto_ctx, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_is_int()`. */
FZ_FUNCTION int ppdf_is_int(pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_is_int():" << " auto_ctx=" << auto_ctx << " obj=" << obj << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_is_int(auto_ctx, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_is_jpx_image()`. */
FZ_FUNCTION int ppdf_is_jpx_image(pdf_obj *dict)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_is_jpx_image():" << " auto_ctx=" << auto_ctx << " dict=" << dict << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_is_jpx_image(auto_ctx, dict);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_is_local_object()`. */
FZ_FUNCTION int ppdf_is_local_object(pdf_document *doc, pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_is_local_object():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " obj=" << obj << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_is_local_object(auto_ctx, doc, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_is_name()`. */
FZ_FUNCTION int ppdf_is_name(pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_is_name():" << " auto_ctx=" << auto_ctx << " obj=" << obj << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_is_name(auto_ctx, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_is_null()`. */
FZ_FUNCTION int ppdf_is_null(pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_is_null():" << " auto_ctx=" << auto_ctx << " obj=" << obj << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_is_null(auto_ctx, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_is_number()`. */
FZ_FUNCTION int ppdf_is_number(pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_is_number():" << " auto_ctx=" << auto_ctx << " obj=" << obj << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_is_number(auto_ctx, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_is_ocg_hidden()`. */
FZ_FUNCTION int ppdf_is_ocg_hidden(pdf_document *doc, pdf_obj *rdb, const char *usage, pdf_obj *ocg)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_is_ocg_hidden():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " rdb=" << rdb << " usage=" << usage << " ocg=" << ocg << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_is_ocg_hidden(auto_ctx, doc, rdb, usage, ocg);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_is_real()`. */
FZ_FUNCTION int ppdf_is_real(pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_is_real():" << " auto_ctx=" << auto_ctx << " obj=" << obj << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_is_real(auto_ctx, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_is_stream()`. */
FZ_FUNCTION int ppdf_is_stream(pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_is_stream():" << " auto_ctx=" << auto_ctx << " obj=" << obj << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_is_stream(auto_ctx, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_is_string()`. */
FZ_FUNCTION int ppdf_is_string(pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_is_string():" << " auto_ctx=" << auto_ctx << " obj=" << obj << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_is_string(auto_ctx, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_is_tint_colorspace()`. */
FZ_FUNCTION int ppdf_is_tint_colorspace(fz_colorspace *cs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_is_tint_colorspace():" << " auto_ctx=" << auto_ctx << " cs=" << cs << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_is_tint_colorspace(auto_ctx, cs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_js_event_init()`. */
FZ_FUNCTION void ppdf_js_event_init(pdf_js *js, pdf_obj *target, const char *value, int willCommit)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_js_event_init():" << " js=" << js << " target=" << target << " value=" << value << " willCommit=" << willCommit << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_js_event_init(js, target, value, willCommit);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_js_event_init_keystroke()`. */
FZ_FUNCTION void ppdf_js_event_init_keystroke(pdf_js *js, pdf_obj *target, pdf_keystroke_event *evt)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_js_event_init_keystroke():" << " js=" << js << " target=" << target << " evt=" << evt << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_js_event_init_keystroke(js, target, evt);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_js_event_result()`. */
FZ_FUNCTION int ppdf_js_event_result(pdf_js *js)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_js_event_result():" << " js=" << js << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_js_event_result(js);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_js_event_result_keystroke()`. */
FZ_FUNCTION int ppdf_js_event_result_keystroke(pdf_js *js, pdf_keystroke_event *evt)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_js_event_result_keystroke():" << " js=" << js << " evt=" << evt << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_js_event_result_keystroke(js, evt);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_js_event_result_validate()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_js_event_result_validate(pdf_js *js)` => `(int, char *newvalue)`
*/
FZ_FUNCTION int ppdf_js_event_result_validate(pdf_js *js, char **newvalue)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_js_event_result_validate():" << " js=" << js << " newvalue=" << (void*) newvalue << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_js_event_result_validate(js, newvalue);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_js_event_value()`. */
FZ_FUNCTION char *ppdf_js_event_value(pdf_js *js)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_js_event_value():" << " js=" << js << "\n";
	}
	char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_js_event_value(js);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_js_execute()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_js_execute(pdf_js *js, const char *name, const char *code)` => char *result
*/
FZ_FUNCTION void ppdf_js_execute(pdf_js *js, const char *name, const char *code, char **result)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_js_execute():" << " js=" << js << " name=" << name << " code=" << code << " result=" << (void*) result << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_js_execute(js, name, code, result);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_js_get_console()`. */
FZ_FUNCTION pdf_js_console *ppdf_js_get_console(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_js_get_console():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	pdf_js_console * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_js_get_console(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_js_set_console()`. */
FZ_FUNCTION void ppdf_js_set_console(pdf_document *doc, pdf_js_console *console, void *user)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_js_set_console():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " console=" << console << " user=" << (void*) user << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_js_set_console(auto_ctx, doc, console, user);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_js_supported()`. */
FZ_FUNCTION int ppdf_js_supported(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_js_supported():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_js_supported(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_keep_annot()`. */
FZ_FUNCTION pdf_annot *ppdf_keep_annot(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_keep_annot():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	pdf_annot * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_keep_annot(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_keep_cmap()`. */
FZ_FUNCTION pdf_cmap *ppdf_keep_cmap(pdf_cmap *cmap)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_keep_cmap():" << " auto_ctx=" << auto_ctx << " cmap=" << cmap << "\n";
	}
	pdf_cmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_keep_cmap(auto_ctx, cmap);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_keep_document()`. */
FZ_FUNCTION pdf_document *ppdf_keep_document(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_keep_document():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	pdf_document * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_keep_document(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_keep_font()`. */
FZ_FUNCTION pdf_font_desc *ppdf_keep_font(pdf_font_desc *fontdesc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_keep_font():" << " auto_ctx=" << auto_ctx << " fontdesc=" << fontdesc << "\n";
	}
	pdf_font_desc * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_keep_font(auto_ctx, fontdesc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_keep_function()`. */
FZ_FUNCTION pdf_function *ppdf_keep_function(pdf_function *func)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_keep_function():" << " auto_ctx=" << auto_ctx << " func=" << func << "\n";
	}
	pdf_function * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_keep_function(auto_ctx, func);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_keep_graft_map()`. */
FZ_FUNCTION pdf_graft_map *ppdf_keep_graft_map(pdf_graft_map *map)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_keep_graft_map():" << " auto_ctx=" << auto_ctx << " map=" << map << "\n";
	}
	pdf_graft_map * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_keep_graft_map(auto_ctx, map);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_keep_obj()`. */
FZ_FUNCTION pdf_obj *ppdf_keep_obj(pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_keep_obj():" << " auto_ctx=" << auto_ctx << " obj=" << obj << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_keep_obj(auto_ctx, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_keep_pattern()`. */
FZ_FUNCTION pdf_pattern *ppdf_keep_pattern(pdf_pattern *pat)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_keep_pattern():" << " auto_ctx=" << auto_ctx << " pat=" << pat << "\n";
	}
	pdf_pattern * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_keep_pattern(auto_ctx, pat);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_keep_processor()`. */
FZ_FUNCTION pdf_processor *ppdf_keep_processor(pdf_processor *proc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_keep_processor():" << " auto_ctx=" << auto_ctx << " proc=" << proc << "\n";
	}
	pdf_processor * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_keep_processor(auto_ctx, proc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_keep_widget()`. */
FZ_FUNCTION pdf_annot *ppdf_keep_widget(pdf_annot *widget)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_keep_widget():" << " auto_ctx=" << auto_ctx << " widget=" << widget << "\n";
	}
	pdf_annot * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_keep_widget(auto_ctx, widget);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_layer_config_info()`. */
FZ_FUNCTION void ppdf_layer_config_info(pdf_document *doc, int config_num, pdf_layer_config *info)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_layer_config_info():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " config_num=" << config_num << " info=" << info << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_layer_config_info(auto_ctx, doc, config_num, info);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_layer_config_ui_info()`. */
FZ_FUNCTION void ppdf_layer_config_ui_info(pdf_document *doc, int ui, pdf_layer_config_ui *info)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_layer_config_ui_info():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " ui=" << ui << " info=" << info << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_layer_config_ui_info(auto_ctx, doc, ui, info);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_layout_fit_text()`. */
FZ_FUNCTION fz_text *ppdf_layout_fit_text(fz_font *font, fz_text_language lang, const char *str, fz_rect bounds)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_layout_fit_text():" << " auto_ctx=" << auto_ctx << " font=" << font << " lang=" << lang << " str=" << str << " bounds=" << bounds << "\n";
	}
	fz_text * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_layout_fit_text(auto_ctx, font, lang, str, bounds);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_layout_text_widget()`. */
FZ_FUNCTION fz_layout_block *ppdf_layout_text_widget(pdf_annot *annot)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_layout_text_widget():" << " auto_ctx=" << auto_ctx << " annot=" << annot << "\n";
	}
	fz_layout_block * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_layout_text_widget(auto_ctx, annot);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_lex()`. */
FZ_FUNCTION pdf_token ppdf_lex(fz_stream *f, pdf_lexbuf *lexbuf)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_lex():" << " auto_ctx=" << auto_ctx << " f=" << f << " lexbuf=" << lexbuf << "\n";
	}
	pdf_token ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_lex(auto_ctx, f, lexbuf);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_lex_no_string()`. */
FZ_FUNCTION pdf_token ppdf_lex_no_string(fz_stream *f, pdf_lexbuf *lexbuf)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_lex_no_string():" << " auto_ctx=" << auto_ctx << " f=" << f << " lexbuf=" << lexbuf << "\n";
	}
	pdf_token ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_lex_no_string(auto_ctx, f, lexbuf);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_lexbuf_fin()`. */
FZ_FUNCTION void ppdf_lexbuf_fin(pdf_lexbuf *lexbuf)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_lexbuf_fin():" << " auto_ctx=" << auto_ctx << " lexbuf=" << lexbuf << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_lexbuf_fin(auto_ctx, lexbuf);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_lexbuf_grow()`. */
FZ_FUNCTION ptrdiff_t ppdf_lexbuf_grow(pdf_lexbuf *lexbuf)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_lexbuf_grow():" << " auto_ctx=" << auto_ctx << " lexbuf=" << lexbuf << "\n";
	}
	ptrdiff_t ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_lexbuf_grow(auto_ctx, lexbuf);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_lexbuf_init()`. */
FZ_FUNCTION void ppdf_lexbuf_init(pdf_lexbuf *lexbuf, int size)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_lexbuf_init():" << " auto_ctx=" << auto_ctx << " lexbuf=" << lexbuf << " size=" << size << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_lexbuf_init(auto_ctx, lexbuf, size);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_line_ending_from_name()`. */
FZ_FUNCTION enum pdf_line_ending ppdf_line_ending_from_name(pdf_obj *end)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_line_ending_from_name():" << " auto_ctx=" << auto_ctx << " end=" << end << "\n";
	}
	enum pdf_line_ending ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_line_ending_from_name(auto_ctx, end);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_line_ending_from_string()`. */
FZ_FUNCTION enum pdf_line_ending ppdf_line_ending_from_string(const char *end)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_line_ending_from_string():" << " auto_ctx=" << auto_ctx << " end=" << end << "\n";
	}
	enum pdf_line_ending ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_line_ending_from_string(auto_ctx, end);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_builtin_cmap()`. */
FZ_FUNCTION pdf_cmap *ppdf_load_builtin_cmap(const char *name)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_builtin_cmap():" << " auto_ctx=" << auto_ctx << " name=" << name << "\n";
	}
	pdf_cmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_builtin_cmap(auto_ctx, name);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_cmap()`. */
FZ_FUNCTION pdf_cmap *ppdf_load_cmap(fz_stream *file)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_cmap():" << " auto_ctx=" << auto_ctx << " file=" << file << "\n";
	}
	pdf_cmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_cmap(auto_ctx, file);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_colorspace()`. */
FZ_FUNCTION fz_colorspace *ppdf_load_colorspace(pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_colorspace():" << " auto_ctx=" << auto_ctx << " obj=" << obj << "\n";
	}
	fz_colorspace * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_colorspace(auto_ctx, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_compressed_inline_image()`. */
FZ_FUNCTION void ppdf_load_compressed_inline_image(pdf_document *doc, pdf_obj *dict, int length, fz_stream *cstm, int indexed, fz_compressed_image *image)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_compressed_inline_image():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " dict=" << dict << " length=" << length << " cstm=" << cstm << " indexed=" << indexed << " image=" << image << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_load_compressed_inline_image(auto_ctx, doc, dict, length, cstm, indexed, image);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_load_compressed_stream()`. */
FZ_FUNCTION fz_compressed_buffer *ppdf_load_compressed_stream(pdf_document *doc, int num)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_compressed_stream():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " num=" << num << "\n";
	}
	fz_compressed_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_compressed_stream(auto_ctx, doc, num);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_default_colorspaces()`. */
FZ_FUNCTION fz_default_colorspaces *ppdf_load_default_colorspaces(pdf_document *doc, pdf_page *page)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_default_colorspaces():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " page=" << page << "\n";
	}
	fz_default_colorspaces * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_default_colorspaces(auto_ctx, doc, page);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_embedded_cmap()`. */
FZ_FUNCTION pdf_cmap *ppdf_load_embedded_cmap(pdf_document *doc, pdf_obj *ref)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_embedded_cmap():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " ref=" << ref << "\n";
	}
	pdf_cmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_embedded_cmap(auto_ctx, doc, ref);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_embedded_file()`. */
FZ_FUNCTION fz_buffer *ppdf_load_embedded_file(pdf_obj *fs)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_embedded_file():" << " auto_ctx=" << auto_ctx << " fs=" << fs << "\n";
	}
	fz_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_embedded_file(auto_ctx, fs);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_encoding()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_load_encoding(const char *encoding)` => const char *estrings
*/
FZ_FUNCTION void ppdf_load_encoding(const char **estrings, const char *encoding)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_encoding():" << " estrings=" << (void*) estrings << " encoding=" << encoding << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_load_encoding(estrings, encoding);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_load_font()`. */
FZ_FUNCTION pdf_font_desc *ppdf_load_font(pdf_document *doc, pdf_obj *rdb, pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_font():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " rdb=" << rdb << " obj=" << obj << "\n";
	}
	pdf_font_desc * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_font(auto_ctx, doc, rdb, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_function()`. */
FZ_FUNCTION pdf_function *ppdf_load_function(pdf_obj *ref, int in, int out)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_function():" << " auto_ctx=" << auto_ctx << " ref=" << ref << " in=" << in << " out=" << out << "\n";
	}
	pdf_function * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_function(auto_ctx, ref, in, out);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_hail_mary_font()`. */
FZ_FUNCTION pdf_font_desc *ppdf_load_hail_mary_font(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_hail_mary_font():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	pdf_font_desc * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_hail_mary_font(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_image()`. */
FZ_FUNCTION fz_image *ppdf_load_image(pdf_document *doc, pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_image():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " obj=" << obj << "\n";
	}
	fz_image * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_image(auto_ctx, doc, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_inline_image()`. */
FZ_FUNCTION fz_image *ppdf_load_inline_image(pdf_document *doc, pdf_obj *rdb, pdf_obj *dict, fz_stream *file)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_inline_image():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " rdb=" << rdb << " dict=" << dict << " file=" << file << "\n";
	}
	fz_image * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_inline_image(auto_ctx, doc, rdb, dict, file);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_journal()`. */
FZ_FUNCTION void ppdf_load_journal(pdf_document *doc, const char *filename)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_journal():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " filename=" << filename << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_load_journal(auto_ctx, doc, filename);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_load_link_annots()`. */
FZ_FUNCTION fz_link *ppdf_load_link_annots(pdf_document *arg_1, pdf_obj *annots, int pagenum, fz_matrix page_ctm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_link_annots():" << " auto_ctx=" << auto_ctx << " arg_1=" << arg_1 << " annots=" << annots << " pagenum=" << pagenum << " page_ctm=" << page_ctm << "\n";
	}
	fz_link * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_link_annots(auto_ctx, arg_1, annots, pagenum, page_ctm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_links()`. */
FZ_FUNCTION fz_link *ppdf_load_links(pdf_page *page)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_links():" << " auto_ctx=" << auto_ctx << " page=" << page << "\n";
	}
	fz_link * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_links(auto_ctx, page);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_name_tree()`. */
FZ_FUNCTION pdf_obj *ppdf_load_name_tree(pdf_document *doc, pdf_obj *which)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_name_tree():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " which=" << which << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_name_tree(auto_ctx, doc, which);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_object()`. */
FZ_FUNCTION pdf_obj *ppdf_load_object(pdf_document *doc, int num)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_object():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " num=" << num << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_object(auto_ctx, doc, num);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_outline()`. */
FZ_FUNCTION fz_outline *ppdf_load_outline(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_outline():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_outline * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_outline(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_page()`. */
FZ_FUNCTION pdf_page *ppdf_load_page(pdf_document *doc, int number)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_page():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " number=" << number << "\n";
	}
	pdf_page * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_page(auto_ctx, doc, number);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_page_imp()`. */
FZ_FUNCTION fz_page *ppdf_load_page_imp(fz_document *doc, int chapter, int number)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_page_imp():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " chapter=" << chapter << " number=" << number << "\n";
	}
	fz_page * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_page_imp(auto_ctx, doc, chapter, number);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_page_tree()`. */
FZ_FUNCTION void ppdf_load_page_tree(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_page_tree():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_load_page_tree(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_load_pattern()`. */
FZ_FUNCTION pdf_pattern *ppdf_load_pattern(pdf_document *doc, pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_pattern():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " obj=" << obj << "\n";
	}
	pdf_pattern * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_pattern(auto_ctx, doc, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_raw_stream()`. */
FZ_FUNCTION fz_buffer *ppdf_load_raw_stream(pdf_obj *ref)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_raw_stream():" << " auto_ctx=" << auto_ctx << " ref=" << ref << "\n";
	}
	fz_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_raw_stream(auto_ctx, ref);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_raw_stream_number()`. */
FZ_FUNCTION fz_buffer *ppdf_load_raw_stream_number(pdf_document *doc, int num)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_raw_stream_number():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " num=" << num << "\n";
	}
	fz_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_raw_stream_number(auto_ctx, doc, num);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_shading()`. */
FZ_FUNCTION fz_shade *ppdf_load_shading(pdf_document *doc, pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_shading():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " obj=" << obj << "\n";
	}
	fz_shade * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_shading(auto_ctx, doc, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_stream()`. */
FZ_FUNCTION fz_buffer *ppdf_load_stream(pdf_obj *ref)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_stream():" << " auto_ctx=" << auto_ctx << " ref=" << ref << "\n";
	}
	fz_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_stream(auto_ctx, ref);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_stream_number()`. */
FZ_FUNCTION fz_buffer *ppdf_load_stream_number(pdf_document *doc, int num)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_stream_number():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " num=" << num << "\n";
	}
	fz_buffer * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_stream_number(auto_ctx, doc, num);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_stream_or_string_as_utf8()`. */
FZ_FUNCTION char *ppdf_load_stream_or_string_as_utf8(pdf_obj *src)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_stream_or_string_as_utf8():" << " auto_ctx=" << auto_ctx << " src=" << src << "\n";
	}
	char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_stream_or_string_as_utf8(auto_ctx, src);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_system_cmap()`. */
FZ_FUNCTION pdf_cmap *ppdf_load_system_cmap(const char *name)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_system_cmap():" << " auto_ctx=" << auto_ctx << " name=" << name << "\n";
	}
	pdf_cmap * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_system_cmap(auto_ctx, name);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_to_unicode()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_load_to_unicode(pdf_document *doc, pdf_font_desc *font, char *collection, pdf_obj *cmapstm)` => const char *strings
*/
FZ_FUNCTION void ppdf_load_to_unicode(pdf_document *doc, pdf_font_desc *font, const char **strings, char *collection, pdf_obj *cmapstm)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_to_unicode():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " font=" << font << " strings=" << (void*) strings << " collection=" << (void*) collection << " cmapstm=" << cmapstm << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_load_to_unicode(auto_ctx, doc, font, strings, collection, cmapstm);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_load_type3_font()`. */
FZ_FUNCTION pdf_font_desc *ppdf_load_type3_font(pdf_document *doc, pdf_obj *rdb, pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_type3_font():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " rdb=" << rdb << " obj=" << obj << "\n";
	}
	pdf_font_desc * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_type3_font(auto_ctx, doc, rdb, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_load_type3_glyphs()`. */
FZ_FUNCTION void ppdf_load_type3_glyphs(pdf_document *doc, pdf_font_desc *fontdesc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_type3_glyphs():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " fontdesc=" << fontdesc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_load_type3_glyphs(auto_ctx, doc, fontdesc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_load_unencrypted_object()`. */
FZ_FUNCTION pdf_obj *ppdf_load_unencrypted_object(pdf_document *doc, int num)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_load_unencrypted_object():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " num=" << num << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_load_unencrypted_object(auto_ctx, doc, num);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_lookup_anchor()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_lookup_anchor(pdf_document *doc, const char *name)` => `(int, float xp, float yp)`
*/
FZ_FUNCTION int ppdf_lookup_anchor(pdf_document *doc, const char *name, float *xp, float *yp)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_lookup_anchor():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " name=" << name << " xp=" << (void*) xp << " yp=" << (void*) yp << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_lookup_anchor(auto_ctx, doc, name, xp, yp);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_lookup_cmap()`. */
FZ_FUNCTION int ppdf_lookup_cmap(pdf_cmap *cmap, unsigned int cpt)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_lookup_cmap():" << " cmap=" << cmap << " cpt=" << cpt << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_lookup_cmap(cmap, cpt);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_lookup_cmap_full()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_lookup_cmap_full(pdf_cmap *cmap, unsigned int cpt)` => `(int, int out)`
*/
FZ_FUNCTION int ppdf_lookup_cmap_full(pdf_cmap *cmap, unsigned int cpt, int *out)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_lookup_cmap_full():" << " cmap=" << cmap << " cpt=" << cpt << " out=" << (void*) out << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_lookup_cmap_full(cmap, cpt, out);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_lookup_dest()`. */
FZ_FUNCTION pdf_obj *ppdf_lookup_dest(pdf_document *doc, pdf_obj *needle)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_lookup_dest():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " needle=" << needle << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_lookup_dest(auto_ctx, doc, needle);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_lookup_field()`. */
FZ_FUNCTION pdf_obj *ppdf_lookup_field(pdf_obj *form, const char *name)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_lookup_field():" << " auto_ctx=" << auto_ctx << " form=" << form << " name=" << name << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_lookup_field(auto_ctx, form, name);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_lookup_hmtx()`. */
FZ_FUNCTION pdf_hmtx ppdf_lookup_hmtx(pdf_font_desc *font, int cid)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_lookup_hmtx():" << " auto_ctx=" << auto_ctx << " font=" << font << " cid=" << cid << "\n";
	}
	pdf_hmtx ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_lookup_hmtx(auto_ctx, font, cid);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_lookup_metadata()`. */
FZ_FUNCTION int ppdf_lookup_metadata(pdf_document *doc, const char *key, char *ptr, int size)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_lookup_metadata():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " key=" << key << " ptr=" << (void*) ptr << " size=" << size << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_lookup_metadata(auto_ctx, doc, key, ptr, size);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}


FZ_FUNCTION std::string ppdf_lookup_metadata(pdf_document *doc, const char *key, int* o_out)
{
	/* Find length first. */
	int e = ppdf_lookup_metadata(doc, key, NULL /*buf*/, 0 /*size*/);
	if (e < 0) {
		// Not found.
		if (o_out)  *o_out = e;
		return "";
	}
	assert(e != 0);
	char* buf = (char*) malloc(e);
	assert(buf);    // mupdf::malloc() throws on error.
	int e2 = ppdf_lookup_metadata(doc, key, buf, e);
	assert(e2 = e);
	std::string ret = buf;
	free(buf);
	if (o_out)  *o_out = e;
	return ret;
}
/** Wrapper for `pdf_lookup_name()`. */
FZ_FUNCTION pdf_obj *ppdf_lookup_name(pdf_document *doc, pdf_obj *which, pdf_obj *needle)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_lookup_name():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " which=" << which << " needle=" << needle << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_lookup_name(auto_ctx, doc, which, needle);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_lookup_number()`. */
FZ_FUNCTION pdf_obj *ppdf_lookup_number(pdf_obj *root, int needle)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_lookup_number():" << " auto_ctx=" << auto_ctx << " root=" << root << " needle=" << needle << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_lookup_number(auto_ctx, root, needle);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_lookup_page_number()`. */
FZ_FUNCTION int ppdf_lookup_page_number(pdf_document *doc, pdf_obj *pageobj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_lookup_page_number():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " pageobj=" << pageobj << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_lookup_page_number(auto_ctx, doc, pageobj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_lookup_page_obj()`. */
FZ_FUNCTION pdf_obj *ppdf_lookup_page_obj(pdf_document *doc, int needle)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_lookup_page_obj():" << " auto_ctx=" << auto_ctx << " doc=" << doc << " needle=" << needle << "\n";
	}
	pdf_obj * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_lookup_page_obj(auto_ctx, doc, needle);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_lookup_substitute_font()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_lookup_substitute_font(int mono, int serif, int bold, int italic)` => `(const unsigned char *, int len)`
*/
FZ_FUNCTION const unsigned char *ppdf_lookup_substitute_font(int mono, int serif, int bold, int italic, int *len)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_lookup_substitute_font():" << " auto_ctx=" << auto_ctx << " mono=" << mono << " serif=" << serif << " bold=" << bold << " italic=" << italic << " len=" << (void*) len << "\n";
	}
	const unsigned char * ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_lookup_substitute_font(auto_ctx, mono, serif, bold, italic, len);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_lookup_vmtx()`. */
FZ_FUNCTION pdf_vmtx ppdf_lookup_vmtx(pdf_font_desc *font, int cid)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_lookup_vmtx():" << " auto_ctx=" << auto_ctx << " font=" << font << " cid=" << cid << "\n";
	}
	pdf_vmtx ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_lookup_vmtx(auto_ctx, font, cid);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_map_one_to_many()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_map_one_to_many(pdf_cmap *cmap, unsigned int one, size_t len)` => int many
*/
FZ_FUNCTION void ppdf_map_one_to_many(pdf_cmap *cmap, unsigned int one, int *many, size_t len)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_map_one_to_many():" << " auto_ctx=" << auto_ctx << " cmap=" << cmap << " one=" << one << " many=" << (void*) many << " len=" << len << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_map_one_to_many(auto_ctx, cmap, one, many, len);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_map_range_to_range()`. */
FZ_FUNCTION void ppdf_map_range_to_range(pdf_cmap *cmap, unsigned int srclo, unsigned int srchi, int dstlo)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_map_range_to_range():" << " auto_ctx=" << auto_ctx << " cmap=" << cmap << " srclo=" << srclo << " srchi=" << srchi << " dstlo=" << dstlo << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_map_range_to_range(auto_ctx, cmap, srclo, srchi, dstlo);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_mark_list_free()`. */
FZ_FUNCTION void ppdf_mark_list_free(pdf_mark_list *list)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_mark_list_free():" << " auto_ctx=" << auto_ctx << " list=" << list << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_mark_list_free(auto_ctx, list);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_mark_list_init()`. */
FZ_FUNCTION void ppdf_mark_list_init(pdf_mark_list *list)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_mark_list_init():" << " auto_ctx=" << auto_ctx << " list=" << list << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_mark_list_init(auto_ctx, list);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_mark_list_pop()`. */
FZ_FUNCTION void ppdf_mark_list_pop(pdf_mark_list *list)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_mark_list_pop():" << " auto_ctx=" << auto_ctx << " list=" << list << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_mark_list_pop(auto_ctx, list);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `pdf_mark_list_push()`. */
FZ_FUNCTION int ppdf_mark_list_push(pdf_mark_list *list, pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_mark_list_push():" << " auto_ctx=" << auto_ctx << " list=" << list << " obj=" << obj << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_mark_list_push(auto_ctx, list, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_mark_obj()`. */
FZ_FUNCTION int ppdf_mark_obj(pdf_obj *obj)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_mark_obj():" << " auto_ctx=" << auto_ctx << " obj=" << obj << "\n";
	}
	int ret;
	fz_var(ret);
	fz_try(auto_ctx) {
		ret = ::pdf_mark_obj(auto_ctx, obj);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
	return ret;
}

/** Wrapper for `pdf_mark_xref()`. */
FZ_FUNCTION void ppdf_mark_xref(pdf_document *doc)
{
	fz_context* auto_ctx = internal_context_get();
	fz_var(auto_ctx);
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling pdf_mark_xref():" << " auto_ctx=" << auto_ctx << " doc=" << doc << "\n";
	}
	fz_try(auto_ctx) {
		::pdf_mark_xref(auto_ctx, doc);
	}
	fz_catch(auto_ctx) {
		if (s_trace_exceptions) {
			std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): fz_catch() has caught exception.\n";
		}
		internal_throw_exception(auto_ctx);
	}
}

/** Wrapper for `