/**
This file was auto-generated by mupdfwrap.py.
*/


#include "mupdf/exceptions.h"
#include "mupdf/fitz.h"

#include <iostream>

#include <string.h>

static const char* s_trace_exceptions_s = getenv("MUPDF_trace_exceptions");
static bool s_trace_exceptions = (s_trace_exceptions_s && !strcmp(s_trace_exceptions_s, "1")) ? true : false;


namespace mupdf
{

ErrorBase::ErrorBase(int code, const char* text)
: m_code(code)
{
	char    code_text[32];
	snprintf(code_text, sizeof(code_text), "%i", code);
	m_text = std::string("code=") + code_text + ": " + text;
	if (s_trace_exceptions)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): ErrorBase: m_code=" << m_code << " m_text: " << m_text << "\n";
	}
};

const char* ErrorBase::what() const throw()
{
	return m_text.c_str();
};


ErrorNone::ErrorNone(const char* text)
: ErrorBase(FZ_ERROR_NONE, text)
{
	if (s_trace_exceptions)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): ErrorNone constructor, text: " << m_text << "\n";
	}
}


ErrorMemory::ErrorMemory(const char* text)
: ErrorBase(FZ_ERROR_MEMORY, text)
{
	if (s_trace_exceptions)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): ErrorMemory constructor, text: " << m_text << "\n";
	}
}


ErrorGeneric::ErrorGeneric(const char* text)
: ErrorBase(FZ_ERROR_GENERIC, text)
{
	if (s_trace_exceptions)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): ErrorGeneric constructor, text: " << m_text << "\n";
	}
}


ErrorSyntax::ErrorSyntax(const char* text)
: ErrorBase(FZ_ERROR_SYNTAX, text)
{
	if (s_trace_exceptions)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): ErrorSyntax constructor, text: " << m_text << "\n";
	}
}


ErrorMinor::ErrorMinor(const char* text)
: ErrorBase(FZ_ERROR_MINOR, text)
{
	if (s_trace_exceptions)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): ErrorMinor constructor, text: " << m_text << "\n";
	}
}


ErrorTrylater::ErrorTrylater(const char* text)
: ErrorBase(FZ_ERROR_TRYLATER, text)
{
	if (s_trace_exceptions)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): ErrorTrylater constructor, text: " << m_text << "\n";
	}
}


ErrorAbort::ErrorAbort(const char* text)
: ErrorBase(FZ_ERROR_ABORT, text)
{
	if (s_trace_exceptions)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): ErrorAbort constructor, text: " << m_text << "\n";
	}
}


ErrorRepaired::ErrorRepaired(const char* text)
: ErrorBase(FZ_ERROR_REPAIRED, text)
{
	if (s_trace_exceptions)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): ErrorRepaired constructor, text: " << m_text << "\n";
	}
}


ErrorCount::ErrorCount(const char* text)
: ErrorBase(FZ_ERROR_COUNT, text)
{
	if (s_trace_exceptions)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): ErrorCount constructor, text: " << m_text << "\n";
	}
}


void internal_throw_exception(fz_context* ctx)
{
	int code = fz_caught(ctx);
	if (s_trace_exceptions)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): code=" << code << "\n";
	}
	const char* text = fz_caught_message(ctx);
	if (s_trace_exceptions)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): text=" << text << "\n";
	}
	if (code == FZ_ERROR_NONE)     throw ErrorNone    (text);
	if (code == FZ_ERROR_MEMORY)   throw ErrorMemory  (text);
	if (code == FZ_ERROR_GENERIC)  throw ErrorGeneric (text);
	if (code == FZ_ERROR_SYNTAX)   throw ErrorSyntax  (text);
	if (code == FZ_ERROR_MINOR)    throw ErrorMinor   (text);
	if (code == FZ_ERROR_TRYLATER) throw ErrorTrylater(text);
	if (code == FZ_ERROR_ABORT)    throw ErrorAbort   (text);
	if (code == FZ_ERROR_REPAIRED) throw ErrorRepaired(text);
	if (code == FZ_ERROR_COUNT)    throw ErrorCount   (text);
	throw ErrorBase(code, text);
}


} /* End of namespace mupdf. */
