/**
This file was auto-generated by mupdfwrap.py.
*/


#include "mupdf/classes2.h"
#include "mupdf/exceptions.h"
#include "mupdf/internal.h"

#include "mupdf/fitz/geometry.h"

#include <map>
#include <mutex>
#include <sstream>
#include <string.h>
#include <thread>

#include <string.h>

static const char* s_trace_s = getenv("MUPDF_trace");
static bool s_trace = (s_trace_s && !strcmp(s_trace_s, "1")) ? true : false;

namespace mupdf
{

/* Wrapper for `fz_aa_level()`.  */
FZ_FUNCTION int mfz_aa_level()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::aa_level()\n";
	}
	auto ret = mupdf::aa_level();
	return ret;
}


/* Wrapper for `fz_abs()`.  */
FZ_FUNCTION float mfz_abs(float f)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::abs()\n";
	}
	auto ret = mupdf::abs(f);
	return ret;
}


/* Wrapper for `fz_absi()`.  */
FZ_FUNCTION int mfz_absi(int i)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::absi()\n";
	}
	auto ret = mupdf::absi(i);
	return ret;
}


/* Wrapper for `fz_add_layout_char()`.  */
FZ_FUNCTION void mfz_add_layout_char(const LayoutBlock& block, float x, float w, const char *p)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::add_layout_char()\n";
	}
	mupdf::add_layout_char(block.m_internal, x, w, p);
}


/* Wrapper for `fz_add_layout_line()`.  */
FZ_FUNCTION void mfz_add_layout_line(const LayoutBlock& block, float x, float y, float h, const char *p)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::add_layout_line()\n";
	}
	mupdf::add_layout_line(block.m_internal, x, y, h, p);
}


/* Wrapper for `fz_add_separation()`.  */
FZ_FUNCTION void mfz_add_separation(const Separations& sep, const char *name, const Colorspace& cs, int cs_channel)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::add_separation()\n";
	}
	mupdf::add_separation(sep.m_internal, name, cs.m_internal, cs_channel);
}


/* Wrapper for `fz_add_separation_equivalents()`.  */
FZ_FUNCTION void mfz_add_separation_equivalents(const Separations& sep, uint32_t rgba, uint32_t cmyk, const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::add_separation_equivalents()\n";
	}
	mupdf::add_separation_equivalents(sep.m_internal, rgba, cmyk, name);
}


/* Wrapper for `fz_adjust_rect_for_stroke()`.  */
FZ_FUNCTION Rect mfz_adjust_rect_for_stroke(Rect& rect, const StrokeState& stroke, Matrix& ctm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::adjust_rect_for_stroke()\n";
	}
	fz_rect temp = mupdf::adjust_rect_for_stroke(*(fz_rect*) &rect.x0, stroke.m_internal, *(fz_matrix*) &ctm.a);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `fz_advance_glyph()`.  */
FZ_FUNCTION float mfz_advance_glyph(const Font& font, int glyph, int wmode)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::advance_glyph()\n";
	}
	auto ret = mupdf::advance_glyph(font.m_internal, glyph, wmode);
	return ret;
}


/* Wrapper for `fz_aes_crypt_cbc()`.  */
FZ_FUNCTION void mfz_aes_crypt_cbc(const Aes& ctx, int mode, size_t length, unsigned char iv[16], const unsigned char *input, unsigned char *output)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::aes_crypt_cbc()\n";
	}
	mupdf::aes_crypt_cbc(ctx.m_internal, mode, length, iv, input, output);
}


/* Wrapper for `fz_aes_setkey_dec()`.  */
FZ_FUNCTION int mfz_aes_setkey_dec(const Aes& ctx, const unsigned char *key, int keysize)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::aes_setkey_dec()\n";
	}
	auto ret = mupdf::aes_setkey_dec(ctx.m_internal, key, keysize);
	return ret;
}


/* Wrapper for `fz_aes_setkey_enc()`.  */
FZ_FUNCTION int mfz_aes_setkey_enc(const Aes& ctx, const unsigned char *key, int keysize)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::aes_setkey_enc()\n";
	}
	auto ret = mupdf::aes_setkey_enc(ctx.m_internal, key, keysize);
	return ret;
}


/* Wrapper for `fz_alpha_from_gray()`.  */
FZ_FUNCTION Pixmap mfz_alpha_from_gray(const Pixmap& gray)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::alpha_from_gray()\n";
	}
	fz_pixmap* temp = mupdf::alpha_from_gray(gray.m_internal);
	mupdf::keep_pixmap(temp);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_append_bits()`.  */
FZ_FUNCTION void mfz_append_bits(const Buffer& buf, int value, int count)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::append_bits()\n";
	}
	mupdf::append_bits(buf.m_internal, value, count);
}


/* Wrapper for `fz_append_bits_pad()`.  */
FZ_FUNCTION void mfz_append_bits_pad(const Buffer& buf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::append_bits_pad()\n";
	}
	mupdf::append_bits_pad(buf.m_internal);
}


/* Wrapper for `fz_append_buffer()`.  */
FZ_FUNCTION void mfz_append_buffer(const Buffer& destination, const Buffer& source)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::append_buffer()\n";
	}
	mupdf::append_buffer(destination.m_internal, source.m_internal);
}


/* Wrapper for `fz_append_byte()`.  */
FZ_FUNCTION void mfz_append_byte(const Buffer& buf, int c)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::append_byte()\n";
	}
	mupdf::append_byte(buf.m_internal, c);
}


/* Wrapper for `fz_append_data()`.  */
FZ_FUNCTION void mfz_append_data(const Buffer& buf, const void *data, size_t len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::append_data()\n";
	}
	mupdf::append_data(buf.m_internal, data, len);
}


/* Wrapper for `fz_append_int16_be()`.  */
FZ_FUNCTION void mfz_append_int16_be(const Buffer& buf, int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::append_int16_be()\n";
	}
	mupdf::append_int16_be(buf.m_internal, x);
}


/* Wrapper for `fz_append_int16_le()`.  */
FZ_FUNCTION void mfz_append_int16_le(const Buffer& buf, int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::append_int16_le()\n";
	}
	mupdf::append_int16_le(buf.m_internal, x);
}


/* Wrapper for `fz_append_int32_be()`.  */
FZ_FUNCTION void mfz_append_int32_be(const Buffer& buf, int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::append_int32_be()\n";
	}
	mupdf::append_int32_be(buf.m_internal, x);
}


/* Wrapper for `fz_append_int32_le()`.  */
FZ_FUNCTION void mfz_append_int32_le(const Buffer& buf, int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::append_int32_le()\n";
	}
	mupdf::append_int32_le(buf.m_internal, x);
}


/* Wrapper for `fz_append_pdf_string()`.  */
FZ_FUNCTION void mfz_append_pdf_string(const Buffer& buffer, const char *text)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::append_pdf_string()\n";
	}
	mupdf::append_pdf_string(buffer.m_internal, text);
}


/* Wrapper for `fz_append_rune()`.  */
FZ_FUNCTION void mfz_append_rune(const Buffer& buf, int c)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::append_rune()\n";
	}
	mupdf::append_rune(buf.m_internal, c);
}


/* Wrapper for `fz_append_string()`.  */
FZ_FUNCTION void mfz_append_string(const Buffer& buf, const char *data)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::append_string()\n";
	}
	mupdf::append_string(buf.m_internal, data);
}


/* Wrapper for `fz_append_vprintf()`.  */
FZ_FUNCTION void mfz_append_vprintf(const Buffer& buffer, const char *fmt, va_list args)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::append_vprintf()\n";
	}
	mupdf::append_vprintf(buffer.m_internal, fmt, args);
}


/* Wrapper for `fz_arc4_encrypt()`.  */
FZ_FUNCTION void mfz_arc4_encrypt(const Arc4& state, unsigned char *dest, const unsigned char *src, size_t len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::arc4_encrypt()\n";
	}
	mupdf::arc4_encrypt(state.m_internal, dest, src, len);
}


/* Wrapper for `fz_arc4_init()`.  */
FZ_FUNCTION void mfz_arc4_init(const Arc4& state, const unsigned char *key, size_t len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::arc4_init()\n";
	}
	mupdf::arc4_init(state.m_internal, key, len);
}


/* Wrapper for `fz_archive_format()`.  */
FZ_FUNCTION const char *mfz_archive_format(const Archive& arch)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::archive_format()\n";
	}
	auto ret = mupdf::archive_format(arch.m_internal);
	return ret;
}


/* Wrapper for `fz_atof()`.  */
FZ_FUNCTION float mfz_atof(const char *s)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::atof()\n";
	}
	auto ret = mupdf::atof(s);
	return ret;
}


/* Wrapper for `fz_atoi()`.  */
FZ_FUNCTION int mfz_atoi(const char *s)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::atoi()\n";
	}
	auto ret = mupdf::atoi(s);
	return ret;
}


/* Wrapper for `fz_atoi64()`.  */
FZ_FUNCTION int64_t mfz_atoi64(const char *s)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::atoi64()\n";
	}
	auto ret = mupdf::atoi64(s);
	return ret;
}


/* Wrapper for `fz_authenticate_password()`.  */
FZ_FUNCTION int mfz_authenticate_password(const Document& doc, const char *password)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::authenticate_password()\n";
	}
	auto ret = mupdf::authenticate_password(doc.m_internal, password);
	return ret;
}


/* Wrapper for `fz_available()`.  */
FZ_FUNCTION size_t mfz_available(const Stream& stm, size_t max)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::available()\n";
	}
	auto ret = mupdf::available(stm.m_internal, max);
	return ret;
}


/* Wrapper for `fz_begin_group()`.  */
FZ_FUNCTION void mfz_begin_group(const Device& dev, Rect& area, const Colorspace& cs, int isolated, int knockout, int blendmode, float alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::begin_group()\n";
	}
	mupdf::begin_group(dev.m_internal, *(fz_rect*) &area.x0, cs.m_internal, isolated, knockout, blendmode, alpha);
}


/* Wrapper for `fz_begin_layer()`.  */
FZ_FUNCTION void mfz_begin_layer(const Device& dev, const char *layer_name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::begin_layer()\n";
	}
	mupdf::begin_layer(dev.m_internal, layer_name);
}


/* Wrapper for `fz_begin_mask()`.  */
FZ_FUNCTION void mfz_begin_mask(const Device& dev, Rect& area, int luminosity, const Colorspace& colorspace, const float *bc, ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::begin_mask()\n";
	}
	mupdf::begin_mask(dev.m_internal, *(fz_rect*) &area.x0, luminosity, colorspace.m_internal, bc, *(fz_color_params*) &color_params.ri);
}


/* Wrapper for `fz_begin_page()`.  */
FZ_FUNCTION Device mfz_begin_page(const DocumentWriter& wri, Rect& mediabox)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::begin_page()\n";
	}
	fz_device* temp = mupdf::begin_page(wri.m_internal, *(fz_rect*) &mediabox.x0);
	mupdf::keep_device(temp);
	auto ret = Device(temp);
	return ret;
}


/* Wrapper for `fz_begin_tile()`.  */
FZ_FUNCTION void mfz_begin_tile(const Device& dev, Rect& area, Rect& view, float xstep, float ystep, Matrix& ctm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::begin_tile()\n";
	}
	mupdf::begin_tile(dev.m_internal, *(fz_rect*) &area.x0, *(fz_rect*) &view.x0, xstep, ystep, *(fz_matrix*) &ctm.a);
}


/* Wrapper for `fz_begin_tile_id()`.  */
FZ_FUNCTION int mfz_begin_tile_id(const Device& dev, Rect& area, Rect& view, float xstep, float ystep, Matrix& ctm, int id)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::begin_tile_id()\n";
	}
	auto ret = mupdf::begin_tile_id(dev.m_internal, *(fz_rect*) &area.x0, *(fz_rect*) &view.x0, xstep, ystep, *(fz_matrix*) &ctm.a, id);
	return ret;
}


/* Wrapper for `fz_bidi_fragment_text()`.  */
FZ_FUNCTION void mfz_bidi_fragment_text(const uint32_t *text, size_t textlen, fz_bidi_direction *baseDir, fz_bidi_fragment_fn *callback, void *arg, int flags)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::bidi_fragment_text()\n";
	}
	mupdf::bidi_fragment_text(text, textlen, baseDir, callback, arg, flags);
}


/* Wrapper for `fz_bitmap_details()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_bitmap_details(fz_bitmap *bitmap)` => `(int w, int h, int n, int stride)`
	 */
FZ_FUNCTION void mfz_bitmap_details(const Bitmap& bitmap, int *w, int *h, int *n, int *stride)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::bitmap_details()\n";
	}
	mupdf::bitmap_details(bitmap.m_internal, w, h, n, stride);
}


/* Wrapper for `fz_blendmode_name()`.  */
FZ_FUNCTION const char *mfz_blendmode_name(int blendmode)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::blendmode_name()\n";
	}
	auto ret = mupdf::blendmode_name(blendmode);
	return ret;
}


/* Wrapper for `fz_bound_display_list()`.  */
FZ_FUNCTION Rect mfz_bound_display_list(const DisplayList& list)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::bound_display_list()\n";
	}
	fz_rect temp = mupdf::bound_display_list(list.m_internal);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `fz_bound_glyph()`.  */
FZ_FUNCTION Rect mfz_bound_glyph(const Font& font, int gid, Matrix& trm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::bound_glyph()\n";
	}
	fz_rect temp = mupdf::bound_glyph(font.m_internal, gid, *(fz_matrix*) &trm.a);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `fz_bound_page()`.  */
FZ_FUNCTION Rect mfz_bound_page(const Page& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::bound_page()\n";
	}
	fz_rect temp = mupdf::bound_page(page.m_internal);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `fz_bound_path()`.  */
FZ_FUNCTION Rect mfz_bound_path(const Path& path, const StrokeState& stroke, Matrix& ctm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::bound_path()\n";
	}
	fz_rect temp = mupdf::bound_path(path.m_internal, stroke.m_internal, *(fz_matrix*) &ctm.a);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `fz_bound_shade()`.  */
FZ_FUNCTION Rect mfz_bound_shade(const Shade& shade, Matrix& ctm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::bound_shade()\n";
	}
	fz_rect temp = mupdf::bound_shade(shade.m_internal, *(fz_matrix*) &ctm.a);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `fz_bound_text()`.  */
FZ_FUNCTION Rect mfz_bound_text(const Text& text, const StrokeState& stroke, Matrix& ctm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::bound_text()\n";
	}
	fz_rect temp = mupdf::bound_text(text.m_internal, stroke.m_internal, *(fz_matrix*) &ctm.a);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `fz_buffer_extract()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_buffer_extract(fz_buffer *buf)` => `(size_t, unsigned char *data)`
	 */
FZ_FUNCTION size_t mfz_buffer_extract(const Buffer& buf, unsigned char **data)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::buffer_extract()\n";
	}
	auto ret = mupdf::buffer_extract(buf.m_internal, data);
	return ret;
}


/* Wrapper for `fz_buffer_storage()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_buffer_storage(fz_buffer *buf)` => `(size_t, unsigned char *datap)`
	 */
FZ_FUNCTION size_t mfz_buffer_storage(const Buffer& buf, unsigned char **datap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::buffer_storage()\n";
	}
	auto ret = mupdf::buffer_storage(buf.m_internal, datap);
	return ret;
}


/* Wrapper for `fz_calloc()`.  */
FZ_FUNCTION void *mfz_calloc(size_t count, size_t size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::calloc()\n";
	}
	auto ret = mupdf::calloc(count, size);
	return ret;
}


/* Wrapper for `fz_calloc_no_throw()`.  */
FZ_FUNCTION void *mfz_calloc_no_throw(size_t count, size_t size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::calloc_no_throw()\n";
	}
	auto ret = mupdf::calloc_no_throw(count, size);
	return ret;
}


/* Wrapper for `fz_caught()`.  */
FZ_FUNCTION int mfz_caught()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::caught()\n";
	}
	auto ret = mupdf::caught();
	return ret;
}


/* Wrapper for `fz_caught_message()`.  */
FZ_FUNCTION const char *mfz_caught_message()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::caught_message()\n";
	}
	auto ret = mupdf::caught_message();
	return ret;
}


/* Wrapper for `fz_chartorune()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_chartorune(const char *str)` => `(int, int rune)`
	 */
FZ_FUNCTION int mfz_chartorune(int *rune, const char *str)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::chartorune()\n";
	}
	auto ret = mupdf::chartorune(rune, str);
	return ret;
}


/* Wrapper for `fz_clamp()`.  */
FZ_FUNCTION float mfz_clamp(float f, float min, float max)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clamp()\n";
	}
	auto ret = mupdf::clamp(f, min, max);
	return ret;
}


/* Wrapper for `fz_clamp_color()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_clamp_color(fz_colorspace *cs, const float *in)` => float out
	 */
FZ_FUNCTION void mfz_clamp_color(const Colorspace& cs, const float *in, float *out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clamp_color()\n";
	}
	mupdf::clamp_color(cs.m_internal, in, out);
}


/* Wrapper for `fz_clamp_location()`.  */
FZ_FUNCTION Location mfz_clamp_location(const Document& doc, Location& loc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clamp_location()\n";
	}
	fz_location temp = mupdf::clamp_location(doc.m_internal, *(fz_location*) &loc.chapter);
	auto ret = Location(&temp);
	return ret;
}


/* Wrapper for `fz_clampd()`.  */
FZ_FUNCTION double mfz_clampd(double d, double min, double max)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clampd()\n";
	}
	auto ret = mupdf::clampd(d, min, max);
	return ret;
}


/* Wrapper for `fz_clampi()`.  */
FZ_FUNCTION int mfz_clampi(int i, int min, int max)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clampi()\n";
	}
	auto ret = mupdf::clampi(i, min, max);
	return ret;
}


/* Wrapper for `fz_clampp()`.  */
FZ_FUNCTION void *mfz_clampp(void *p, void *min, void *max)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clampp()\n";
	}
	auto ret = mupdf::clampp(p, min, max);
	return ret;
}


/* Wrapper for `fz_cleanname()`.  */
FZ_FUNCTION char *mfz_cleanname(char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::cleanname()\n";
	}
	auto ret = mupdf::cleanname(name);
	return ret;
}


/* Wrapper for `fz_clear_bitmap()`.  */
FZ_FUNCTION void mfz_clear_bitmap(const Bitmap& bit)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clear_bitmap()\n";
	}
	mupdf::clear_bitmap(bit.m_internal);
}


/* Wrapper for `fz_clear_buffer()`.  */
FZ_FUNCTION void mfz_clear_buffer(const Buffer& buf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clear_buffer()\n";
	}
	mupdf::clear_buffer(buf.m_internal);
}


/* Wrapper for `fz_clear_pixmap()`.  */
FZ_FUNCTION void mfz_clear_pixmap(const Pixmap& pix)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clear_pixmap()\n";
	}
	mupdf::clear_pixmap(pix.m_internal);
}


/* Wrapper for `fz_clear_pixmap_rect_with_value()`.  */
FZ_FUNCTION void mfz_clear_pixmap_rect_with_value(const Pixmap& pix, int value, Irect& r)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clear_pixmap_rect_with_value()\n";
	}
	mupdf::clear_pixmap_rect_with_value(pix.m_internal, value, *(fz_irect*) &r.x0);
}


/* Wrapper for `fz_clear_pixmap_with_value()`.  */
FZ_FUNCTION void mfz_clear_pixmap_with_value(const Pixmap& pix, int value)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clear_pixmap_with_value()\n";
	}
	mupdf::clear_pixmap_with_value(pix.m_internal, value);
}


/* Wrapper for `fz_clip_image_mask()`.  */
FZ_FUNCTION void mfz_clip_image_mask(const Device& dev, const Image& image, Matrix& ctm, Rect& scissor)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clip_image_mask()\n";
	}
	mupdf::clip_image_mask(dev.m_internal, image.m_internal, *(fz_matrix*) &ctm.a, *(fz_rect*) &scissor.x0);
}


/* Wrapper for `fz_clip_path()`.  */
FZ_FUNCTION void mfz_clip_path(const Device& dev, const Path& path, int even_odd, Matrix& ctm, Rect& scissor)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clip_path()\n";
	}
	mupdf::clip_path(dev.m_internal, path.m_internal, even_odd, *(fz_matrix*) &ctm.a, *(fz_rect*) &scissor.x0);
}


/* Wrapper for `fz_clip_stroke_path()`.  */
FZ_FUNCTION void mfz_clip_stroke_path(const Device& dev, const Path& path, const StrokeState& stroke, Matrix& ctm, Rect& scissor)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clip_stroke_path()\n";
	}
	mupdf::clip_stroke_path(dev.m_internal, path.m_internal, stroke.m_internal, *(fz_matrix*) &ctm.a, *(fz_rect*) &scissor.x0);
}


/* Wrapper for `fz_clip_stroke_text()`.  */
FZ_FUNCTION void mfz_clip_stroke_text(const Device& dev, const Text& text, const StrokeState& stroke, Matrix& ctm, Rect& scissor)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clip_stroke_text()\n";
	}
	mupdf::clip_stroke_text(dev.m_internal, text.m_internal, stroke.m_internal, *(fz_matrix*) &ctm.a, *(fz_rect*) &scissor.x0);
}


/* Wrapper for `fz_clip_text()`.  */
FZ_FUNCTION void mfz_clip_text(const Device& dev, const Text& text, Matrix& ctm, Rect& scissor)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clip_text()\n";
	}
	mupdf::clip_text(dev.m_internal, text.m_internal, *(fz_matrix*) &ctm.a, *(fz_rect*) &scissor.x0);
}


/* Wrapper for `fz_clone_context()`.  */
FZ_FUNCTION fz_context *mfz_clone_context()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clone_context()\n";
	}
	auto ret = mupdf::clone_context();
	return ret;
}


/* Wrapper for `fz_clone_default_colorspaces()`.  */
FZ_FUNCTION DefaultColorspaces mfz_clone_default_colorspaces(const DefaultColorspaces& base)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clone_default_colorspaces()\n";
	}
	fz_default_colorspaces* temp = mupdf::clone_default_colorspaces(base.m_internal);
	mupdf::keep_default_colorspaces(temp);
	auto ret = DefaultColorspaces(temp);
	return ret;
}


/* Wrapper for `fz_clone_path()`.  */
FZ_FUNCTION Path mfz_clone_path(const Path& path)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clone_path()\n";
	}
	fz_path* temp = mupdf::clone_path(path.m_internal);
	mupdf::keep_path(temp);
	auto ret = Path(temp);
	return ret;
}


/* Wrapper for `fz_clone_pixmap()`.  */
FZ_FUNCTION Pixmap mfz_clone_pixmap(const Pixmap& old)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clone_pixmap()\n";
	}
	fz_pixmap* temp = mupdf::clone_pixmap(old.m_internal);
	mupdf::keep_pixmap(temp);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_clone_pixmap_area_with_different_seps()`.  */
FZ_FUNCTION Pixmap mfz_clone_pixmap_area_with_different_seps(const Pixmap& src, Irect& bbox, const Colorspace& dcs, const Separations& seps, ColorParams& color_params, const DefaultColorspaces& default_cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clone_pixmap_area_with_different_seps()\n";
	}
	fz_pixmap* temp = mupdf::clone_pixmap_area_with_different_seps(src.m_internal, (const fz_irect *) &bbox.x0, dcs.m_internal, seps.m_internal, *(fz_color_params*) &color_params.ri, default_cs.m_internal);
	mupdf::keep_pixmap(temp);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_clone_separations_for_overprint()`.  */
FZ_FUNCTION Separations mfz_clone_separations_for_overprint(const Separations& seps)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clone_separations_for_overprint()\n";
	}
	fz_separations* temp = mupdf::clone_separations_for_overprint(seps.m_internal);
	mupdf::keep_separations(temp);
	auto ret = Separations(temp);
	return ret;
}


/* Wrapper for `fz_clone_stroke_state()`.  */
FZ_FUNCTION StrokeState mfz_clone_stroke_state(const StrokeState& stroke)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clone_stroke_state()\n";
	}
	fz_stroke_state* temp = mupdf::clone_stroke_state(stroke.m_internal);
	mupdf::keep_stroke_state(temp);
	auto ret = StrokeState(temp);
	return ret;
}


/* Wrapper for `fz_close_band_writer()`.  */
FZ_FUNCTION void mfz_close_band_writer(const BandWriter& writer)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::close_band_writer()\n";
	}
	mupdf::close_band_writer(writer.m_internal);
}


/* Wrapper for `fz_close_device()`.  */
FZ_FUNCTION void mfz_close_device(const Device& dev)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::close_device()\n";
	}
	mupdf::close_device(dev.m_internal);
}


/* Wrapper for `fz_close_document_writer()`.  */
FZ_FUNCTION void mfz_close_document_writer(const DocumentWriter& wri)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::close_document_writer()\n";
	}
	mupdf::close_document_writer(wri.m_internal);
}


/* Wrapper for `fz_close_output()`.  */
FZ_FUNCTION void mfz_close_output(const Output& arg_0)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::close_output()\n";
	}
	mupdf::close_output(arg_0.m_internal);
}


/* Wrapper for `fz_close_zip_writer()`.  */
FZ_FUNCTION void mfz_close_zip_writer(const ZipWriter& zip)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::close_zip_writer()\n";
	}
	mupdf::close_zip_writer(zip.m_internal);
}


/* Wrapper for `fz_closepath()`.  */
FZ_FUNCTION void mfz_closepath(const Path& path)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::closepath()\n";
	}
	mupdf::closepath(path.m_internal);
}


/* Wrapper for `fz_colorspace_colorant()`.  */
FZ_FUNCTION const char *mfz_colorspace_colorant(const Colorspace& cs, int n)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_colorant()\n";
	}
	auto ret = mupdf::colorspace_colorant(cs.m_internal, n);
	return ret;
}


/* Wrapper for `fz_colorspace_device_n_has_cmyk()`.  */
FZ_FUNCTION int mfz_colorspace_device_n_has_cmyk(const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_device_n_has_cmyk()\n";
	}
	auto ret = mupdf::colorspace_device_n_has_cmyk(cs.m_internal);
	return ret;
}


/* Wrapper for `fz_colorspace_device_n_has_only_cmyk()`.  */
FZ_FUNCTION int mfz_colorspace_device_n_has_only_cmyk(const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_device_n_has_only_cmyk()\n";
	}
	auto ret = mupdf::colorspace_device_n_has_only_cmyk(cs.m_internal);
	return ret;
}


/* Wrapper for `fz_colorspace_is_cmyk()`.  */
FZ_FUNCTION int mfz_colorspace_is_cmyk(const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_is_cmyk()\n";
	}
	auto ret = mupdf::colorspace_is_cmyk(cs.m_internal);
	return ret;
}


/* Wrapper for `fz_colorspace_is_device()`.  */
FZ_FUNCTION int mfz_colorspace_is_device(const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_is_device()\n";
	}
	auto ret = mupdf::colorspace_is_device(cs.m_internal);
	return ret;
}


/* Wrapper for `fz_colorspace_is_device_cmyk()`.  */
FZ_FUNCTION int mfz_colorspace_is_device_cmyk(const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_is_device_cmyk()\n";
	}
	auto ret = mupdf::colorspace_is_device_cmyk(cs.m_internal);
	return ret;
}


/* Wrapper for `fz_colorspace_is_device_gray()`.  */
FZ_FUNCTION int mfz_colorspace_is_device_gray(const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_is_device_gray()\n";
	}
	auto ret = mupdf::colorspace_is_device_gray(cs.m_internal);
	return ret;
}


/* Wrapper for `fz_colorspace_is_device_n()`.  */
FZ_FUNCTION int mfz_colorspace_is_device_n(const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_is_device_n()\n";
	}
	auto ret = mupdf::colorspace_is_device_n(cs.m_internal);
	return ret;
}


/* Wrapper for `fz_colorspace_is_gray()`.  */
FZ_FUNCTION int mfz_colorspace_is_gray(const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_is_gray()\n";
	}
	auto ret = mupdf::colorspace_is_gray(cs.m_internal);
	return ret;
}


/* Wrapper for `fz_colorspace_is_indexed()`.  */
FZ_FUNCTION int mfz_colorspace_is_indexed(const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_is_indexed()\n";
	}
	auto ret = mupdf::colorspace_is_indexed(cs.m_internal);
	return ret;
}


/* Wrapper for `fz_colorspace_is_lab()`.  */
FZ_FUNCTION int mfz_colorspace_is_lab(const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_is_lab()\n";
	}
	auto ret = mupdf::colorspace_is_lab(cs.m_internal);
	return ret;
}


/* Wrapper for `fz_colorspace_is_lab_icc()`.  */
FZ_FUNCTION int mfz_colorspace_is_lab_icc(const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_is_lab_icc()\n";
	}
	auto ret = mupdf::colorspace_is_lab_icc(cs.m_internal);
	return ret;
}


/* Wrapper for `fz_colorspace_is_rgb()`.  */
FZ_FUNCTION int mfz_colorspace_is_rgb(const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_is_rgb()\n";
	}
	auto ret = mupdf::colorspace_is_rgb(cs.m_internal);
	return ret;
}


/* Wrapper for `fz_colorspace_is_subtractive()`.  */
FZ_FUNCTION int mfz_colorspace_is_subtractive(const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_is_subtractive()\n";
	}
	auto ret = mupdf::colorspace_is_subtractive(cs.m_internal);
	return ret;
}


/* Wrapper for `fz_colorspace_n()`.  */
FZ_FUNCTION int mfz_colorspace_n(const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_n()\n";
	}
	auto ret = mupdf::colorspace_n(cs.m_internal);
	return ret;
}


/* Wrapper for `fz_colorspace_name()`.  */
FZ_FUNCTION const char *mfz_colorspace_name(const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_name()\n";
	}
	auto ret = mupdf::colorspace_name(cs.m_internal);
	return ret;
}


/* Wrapper for `fz_colorspace_name_colorant()`.  */
FZ_FUNCTION void mfz_colorspace_name_colorant(const Colorspace& cs, int n, const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_name_colorant()\n";
	}
	mupdf::colorspace_name_colorant(cs.m_internal, n, name);
}


/* Wrapper for `fz_colorspace_type()`.  */
FZ_FUNCTION enum fz_colorspace_type mfz_colorspace_type(const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_type()\n";
	}
	auto ret = mupdf::colorspace_type(cs.m_internal);
	return ret;
}


/* Wrapper for `fz_compress_ccitt_fax_g3()`.  */
FZ_FUNCTION Buffer mfz_compress_ccitt_fax_g3(const unsigned char *data, int columns, int rows)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::compress_ccitt_fax_g3()\n";
	}
	fz_buffer* temp = mupdf::compress_ccitt_fax_g3(data, columns, rows);
	mupdf::keep_buffer(temp);
	auto ret = Buffer(temp);
	return ret;
}


/* Wrapper for `fz_compress_ccitt_fax_g4()`.  */
FZ_FUNCTION Buffer mfz_compress_ccitt_fax_g4(const unsigned char *data, int columns, int rows)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::compress_ccitt_fax_g4()\n";
	}
	fz_buffer* temp = mupdf::compress_ccitt_fax_g4(data, columns, rows);
	mupdf::keep_buffer(temp);
	auto ret = Buffer(temp);
	return ret;
}


/* Wrapper for `fz_compressed_buffer_size()`.  */
FZ_FUNCTION size_t mfz_compressed_buffer_size(const CompressedBuffer& buffer)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::compressed_buffer_size()\n";
	}
	auto ret = mupdf::compressed_buffer_size(buffer.m_internal);
	return ret;
}


/* Wrapper for `fz_compressed_image_buffer()`.  */
FZ_FUNCTION fz_compressed_buffer *mfz_compressed_image_buffer(const Image& image)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::compressed_image_buffer()\n";
	}
	auto ret = mupdf::compressed_image_buffer(image.m_internal);
	return ret;
}


/* Wrapper for `fz_concat()`.  */
FZ_FUNCTION Matrix mfz_concat(Matrix& left, Matrix& right)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::concat()\n";
	}
	fz_matrix temp = mupdf::concat(*(fz_matrix*) &left.a, *(fz_matrix*) &right.a);
	auto ret = Matrix(&temp);
	return ret;
}


/* Wrapper for `fz_contains_rect()`.  */
FZ_FUNCTION int mfz_contains_rect(Rect& a, Rect& b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::contains_rect()\n";
	}
	auto ret = mupdf::contains_rect(*(fz_rect*) &a.x0, *(fz_rect*) &b.x0);
	return ret;
}


/* Wrapper for `fz_convert_color()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_convert_color(fz_colorspace *ss, const float *sv, fz_colorspace *ds, fz_colorspace *is, fz_color_params params)` => float dv
	 */
FZ_FUNCTION void mfz_convert_color(const Colorspace& ss, const float *sv, const Colorspace& ds, float *dv, const Colorspace& is, ColorParams& params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::convert_color()\n";
	}
	mupdf::convert_color(ss.m_internal, sv, ds.m_internal, dv, is.m_internal, *(fz_color_params*) &params.ri);
}


/* Wrapper for `fz_convert_indexed_pixmap_to_base()`.  */
FZ_FUNCTION Pixmap mfz_convert_indexed_pixmap_to_base(const Pixmap& src)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::convert_indexed_pixmap_to_base()\n";
	}
	fz_pixmap* temp = mupdf::convert_indexed_pixmap_to_base(src.m_internal);
	mupdf::keep_pixmap(temp);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_convert_pixmap()`.  */
FZ_FUNCTION Pixmap mfz_convert_pixmap(const Pixmap& pix, const Colorspace& cs_des, const Colorspace& prf, const DefaultColorspaces& default_cs, ColorParams& color_params, int keep_alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::convert_pixmap()\n";
	}
	fz_pixmap* temp = mupdf::convert_pixmap(pix.m_internal, cs_des.m_internal, prf.m_internal, default_cs.m_internal, *(fz_color_params*) &color_params.ri, keep_alpha);
	mupdf::keep_pixmap(temp);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_convert_separation_colors()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_convert_separation_colors(fz_colorspace *src_cs, const float *src_color, fz_separations *dst_seps, fz_colorspace *dst_cs, fz_color_params color_params)` => float dst_color
	 */
FZ_FUNCTION void mfz_convert_separation_colors(const Colorspace& src_cs, const float *src_color, const Separations& dst_seps, const Colorspace& dst_cs, float *dst_color, ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::convert_separation_colors()\n";
	}
	mupdf::convert_separation_colors(src_cs.m_internal, src_color, dst_seps.m_internal, dst_cs.m_internal, dst_color, *(fz_color_params*) &color_params.ri);
}


/* Wrapper for `fz_convert_separation_pixmap_to_base()`.  */
FZ_FUNCTION Pixmap mfz_convert_separation_pixmap_to_base(const Pixmap& src)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::convert_separation_pixmap_to_base()\n";
	}
	fz_pixmap* temp = mupdf::convert_separation_pixmap_to_base(src.m_internal);
	mupdf::keep_pixmap(temp);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_copy_option()`.  */
FZ_FUNCTION size_t mfz_copy_option(const char *val, char *dest, size_t maxlen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::copy_option()\n";
	}
	auto ret = mupdf::copy_option(val, dest, maxlen);
	return ret;
}


/* Wrapper for `fz_copy_rectangle()`.  */
FZ_FUNCTION char *mfz_copy_rectangle(const StextPage& page, Rect& area, int crlf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::copy_rectangle()\n";
	}
	auto ret = mupdf::copy_rectangle(page.m_internal, *(fz_rect*) &area.x0, crlf);
	return ret;
}


/* Wrapper for `fz_copy_selection()`.  */
FZ_FUNCTION char *mfz_copy_selection(const StextPage& page, Point& a, Point& b, int crlf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::copy_selection()\n";
	}
	auto ret = mupdf::copy_selection(page.m_internal, *(fz_point*) &a.x, *(fz_point*) &b.x, crlf);
	return ret;
}


/* Wrapper for `fz_count_active_separations()`.  */
FZ_FUNCTION int mfz_count_active_separations(const Separations& seps)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::count_active_separations()\n";
	}
	auto ret = mupdf::count_active_separations(seps.m_internal);
	return ret;
}


/* Wrapper for `fz_count_archive_entries()`.  */
FZ_FUNCTION int mfz_count_archive_entries(const Archive& arch)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::count_archive_entries()\n";
	}
	auto ret = mupdf::count_archive_entries(arch.m_internal);
	return ret;
}


/* Wrapper for `fz_count_chapter_pages()`.  */
FZ_FUNCTION int mfz_count_chapter_pages(const Document& doc, int chapter)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::count_chapter_pages()\n";
	}
	auto ret = mupdf::count_chapter_pages(doc.m_internal, chapter);
	return ret;
}


/* Wrapper for `fz_count_chapters()`.  */
FZ_FUNCTION int mfz_count_chapters(const Document& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::count_chapters()\n";
	}
	auto ret = mupdf::count_chapters(doc.m_internal);
	return ret;
}


/* Wrapper for `fz_count_pages()`.  */
FZ_FUNCTION int mfz_count_pages(const Document& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::count_pages()\n";
	}
	auto ret = mupdf::count_pages(doc.m_internal);
	return ret;
}


/* Wrapper for `fz_count_separations()`.  */
FZ_FUNCTION int mfz_count_separations(const Separations& sep)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::count_separations()\n";
	}
	auto ret = mupdf::count_separations(sep.m_internal);
	return ret;
}


/* Wrapper for `fz_create_link()`.  */
FZ_FUNCTION Link mfz_create_link(const Page& page, Rect& bbox, const char *uri)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::create_link()\n";
	}
	fz_link* temp = mupdf::create_link(page.m_internal, *(fz_rect*) &bbox.x0, uri);
	auto ret = Link(temp);
	return ret;
}


/* Wrapper for `fz_currentpoint()`.  */
FZ_FUNCTION Point mfz_currentpoint(const Path& path)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::currentpoint()\n";
	}
	fz_point temp = mupdf::currentpoint(path.m_internal);
	auto ret = Point(&temp);
	return ret;
}


/* Wrapper for `fz_curveto()`.  */
FZ_FUNCTION void mfz_curveto(const Path& path, float x0, float y0, float x1, float y1, float x2, float y2)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::curveto()\n";
	}
	mupdf::curveto(path.m_internal, x0, y0, x1, y1, x2, y2);
}


/* Wrapper for `fz_curvetov()`.  */
FZ_FUNCTION void mfz_curvetov(const Path& path, float x1, float y1, float x2, float y2)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::curvetov()\n";
	}
	mupdf::curvetov(path.m_internal, x1, y1, x2, y2);
}


/* Wrapper for `fz_curvetoy()`.  */
FZ_FUNCTION void mfz_curvetoy(const Path& path, float x0, float y0, float x2, float y2)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::curvetoy()\n";
	}
	mupdf::curvetoy(path.m_internal, x0, y0, x2, y2);
}


/* Wrapper for `fz_debug_store()`.  */
FZ_FUNCTION void mfz_debug_store(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::debug_store()\n";
	}
	mupdf::debug_store(out.m_internal);
}


/* Wrapper for `fz_debug_xml()`.  */
FZ_FUNCTION void mfz_debug_xml(const Xml& item, int level)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::debug_xml()\n";
	}
	mupdf::debug_xml(item.m_internal, level);
}


/* Wrapper for `fz_decode_tile()`.  */
FZ_FUNCTION void mfz_decode_tile(const Pixmap& pix, const float *decode)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::decode_tile()\n";
	}
	mupdf::decode_tile(pix.m_internal, decode);
}


/* Wrapper for `fz_decomp_image_from_stream()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_decomp_image_from_stream(fz_stream *stm, fz_compressed_image *image, fz_irect *subarea, int indexed, int l2factor)` => `(fz_pixmap *, int l2extra)`
	 */
FZ_FUNCTION Pixmap mfz_decomp_image_from_stream(const Stream& stm, const CompressedImage& image, Irect& subarea, int indexed, int l2factor, int *l2extra)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::decomp_image_from_stream()\n";
	}
	fz_pixmap* temp = mupdf::decomp_image_from_stream(stm.m_internal, image.m_internal, (fz_irect *) &subarea.x0, indexed, l2factor, l2extra);
	mupdf::keep_pixmap(temp);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_decouple_type3_font()`.  */
FZ_FUNCTION void mfz_decouple_type3_font(const Font& font, void *t3doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::decouple_type3_font()\n";
	}
	mupdf::decouple_type3_font(font.m_internal, t3doc);
}


/* Wrapper for `fz_default_cmyk()`.  */
FZ_FUNCTION Colorspace mfz_default_cmyk(const DefaultColorspaces& default_cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::default_cmyk()\n";
	}
	fz_colorspace* temp = mupdf::default_cmyk(default_cs.m_internal);
	mupdf::keep_colorspace(temp);
	auto ret = Colorspace(temp);
	return ret;
}


/* Wrapper for `fz_default_error_callback()`.  */
FZ_FUNCTION void mfz_default_error_callback(void *user, const char *message)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::default_error_callback()\n";
	}
	mupdf::default_error_callback(user, message);
}


/* Wrapper for `fz_default_gray()`.  */
FZ_FUNCTION Colorspace mfz_default_gray(const DefaultColorspaces& default_cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::default_gray()\n";
	}
	fz_colorspace* temp = mupdf::default_gray(default_cs.m_internal);
	mupdf::keep_colorspace(temp);
	auto ret = Colorspace(temp);
	return ret;
}


/* Wrapper for `fz_default_halftone()`.  */
FZ_FUNCTION Halftone mfz_default_halftone(int num_comps)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::default_halftone()\n";
	}
	fz_halftone* temp = mupdf::default_halftone(num_comps);
	mupdf::keep_halftone(temp);
	auto ret = Halftone(temp);
	return ret;
}


/* Wrapper for `fz_default_output_intent()`.  */
FZ_FUNCTION Colorspace mfz_default_output_intent(const DefaultColorspaces& default_cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::default_output_intent()\n";
	}
	fz_colorspace* temp = mupdf::default_output_intent(default_cs.m_internal);
	mupdf::keep_colorspace(temp);
	auto ret = Colorspace(temp);
	return ret;
}


/* Wrapper for `fz_default_rgb()`.  */
FZ_FUNCTION Colorspace mfz_default_rgb(const DefaultColorspaces& default_cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::default_rgb()\n";
	}
	fz_colorspace* temp = mupdf::default_rgb(default_cs.m_internal);
	mupdf::keep_colorspace(temp);
	auto ret = Colorspace(temp);
	return ret;
}


/* Wrapper for `fz_default_warning_callback()`.  */
FZ_FUNCTION void mfz_default_warning_callback(void *user, const char *message)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::default_warning_callback()\n";
	}
	mupdf::default_warning_callback(user, message);
}


/* Wrapper for `fz_defer_reap_end()`.  */
FZ_FUNCTION void mfz_defer_reap_end()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::defer_reap_end()\n";
	}
	mupdf::defer_reap_end();
}


/* Wrapper for `fz_defer_reap_start()`.  */
FZ_FUNCTION void mfz_defer_reap_start()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::defer_reap_start()\n";
	}
	mupdf::defer_reap_start();
}


/* Wrapper for `fz_deflate()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_deflate(unsigned char *dest, const unsigned char *source, size_t source_length, fz_deflate_level level)` => size_t compressed_length
	 */
FZ_FUNCTION void mfz_deflate(unsigned char *dest, size_t *compressed_length, const unsigned char *source, size_t source_length, fz_deflate_level level)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::deflate()\n";
	}
	mupdf::deflate(dest, compressed_length, source, source_length, level);
}


/* Wrapper for `fz_deflate_bound()`.  */
FZ_FUNCTION size_t mfz_deflate_bound(size_t size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::deflate_bound()\n";
	}
	auto ret = mupdf::deflate_bound(size);
	return ret;
}


/* Wrapper for `fz_detach_xml()`.  */
FZ_FUNCTION void mfz_detach_xml(const XmlDoc& xml, const Xml& node)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::detach_xml()\n";
	}
	mupdf::detach_xml(xml.m_internal, node.m_internal);
}


/* Wrapper for `fz_device_bgr()`.  */
FZ_FUNCTION Colorspace mfz_device_bgr()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::device_bgr()\n";
	}
	fz_colorspace* temp = mupdf::device_bgr();
	mupdf::keep_colorspace(temp);
	auto ret = Colorspace(temp);
	return ret;
}


/* Wrapper for `fz_device_cmyk()`.  */
FZ_FUNCTION Colorspace mfz_device_cmyk()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::device_cmyk()\n";
	}
	fz_colorspace* temp = mupdf::device_cmyk();
	mupdf::keep_colorspace(temp);
	auto ret = Colorspace(temp);
	return ret;
}


/* Wrapper for `fz_device_current_scissor()`.  */
FZ_FUNCTION Rect mfz_device_current_scissor(const Device& dev)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::device_current_scissor()\n";
	}
	fz_rect temp = mupdf::device_current_scissor(dev.m_internal);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `fz_device_gray()`.  */
FZ_FUNCTION Colorspace mfz_device_gray()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::device_gray()\n";
	}
	fz_colorspace* temp = mupdf::device_gray();
	mupdf::keep_colorspace(temp);
	auto ret = Colorspace(temp);
	return ret;
}


/* Wrapper for `fz_device_lab()`.  */
FZ_FUNCTION Colorspace mfz_device_lab()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::device_lab()\n";
	}
	fz_colorspace* temp = mupdf::device_lab();
	mupdf::keep_colorspace(temp);
	auto ret = Colorspace(temp);
	return ret;
}


/* Wrapper for `fz_device_rgb()`.  */
FZ_FUNCTION Colorspace mfz_device_rgb()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::device_rgb()\n";
	}
	fz_colorspace* temp = mupdf::device_rgb();
	mupdf::keep_colorspace(temp);
	auto ret = Colorspace(temp);
	return ret;
}


/* Wrapper for `fz_dirname()`.  */
FZ_FUNCTION void mfz_dirname(char *dir, const char *path, size_t dirsize)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::dirname()\n";
	}
	mupdf::dirname(dir, path, dirsize);
}


/* Wrapper for `fz_disable_device_hints()`.  */
FZ_FUNCTION void mfz_disable_device_hints(const Device& dev, int hints)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::disable_device_hints()\n";
	}
	mupdf::disable_device_hints(dev.m_internal, hints);
}


/* Wrapper for `fz_disable_icc()`.  */
FZ_FUNCTION void mfz_disable_icc()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::disable_icc()\n";
	}
	mupdf::disable_icc();
}


/* Wrapper for `fz_display_list_is_empty()`.  */
FZ_FUNCTION int mfz_display_list_is_empty(const DisplayList& list)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::display_list_is_empty()\n";
	}
	auto ret = mupdf::display_list_is_empty(list.m_internal);
	return ret;
}


/* Wrapper for `fz_div255()`.  */
FZ_FUNCTION int mfz_div255(int c, int a)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::div255()\n";
	}
	auto ret = mupdf::div255(c, a);
	return ret;
}


/* Wrapper for `fz_do_always()`.  */
FZ_FUNCTION int mfz_do_always()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::do_always()\n";
	}
	auto ret = mupdf::do_always();
	return ret;
}


/* Wrapper for `fz_do_catch()`.  */
FZ_FUNCTION int mfz_do_catch()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::do_catch()\n";
	}
	auto ret = mupdf::do_catch();
	return ret;
}


/* Wrapper for `fz_do_try()`.  */
FZ_FUNCTION int mfz_do_try()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::do_try()\n";
	}
	auto ret = mupdf::do_try();
	return ret;
}


/* Wrapper for `fz_document_output_intent()`.  */
FZ_FUNCTION Colorspace mfz_document_output_intent(const Document& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::document_output_intent()\n";
	}
	fz_colorspace* temp = mupdf::document_output_intent(doc.m_internal);
	mupdf::keep_colorspace(temp);
	auto ret = Colorspace(temp);
	return ret;
}


/* Wrapper for `fz_document_supports_accelerator()`.  */
FZ_FUNCTION int mfz_document_supports_accelerator(const Document& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::document_supports_accelerator()\n";
	}
	auto ret = mupdf::document_supports_accelerator(doc.m_internal);
	return ret;
}


/* Wrapper for `fz_drop_archive()`.  */
FZ_FUNCTION void mfz_drop_archive(const Archive& arch)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_archive()\n";
	}
	mupdf::drop_archive(arch.m_internal);
}


/* Wrapper for `fz_drop_band_writer()`.  */
FZ_FUNCTION void mfz_drop_band_writer(const BandWriter& writer)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_band_writer()\n";
	}
	mupdf::drop_band_writer(writer.m_internal);
}


/* Wrapper for `fz_drop_bitmap()`.  */
FZ_FUNCTION void mfz_drop_bitmap(const Bitmap& bit)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_bitmap()\n";
	}
	mupdf::drop_bitmap(bit.m_internal);
}


/* Wrapper for `fz_drop_buffer()`.  */
FZ_FUNCTION void mfz_drop_buffer(const Buffer& buf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_buffer()\n";
	}
	mupdf::drop_buffer(buf.m_internal);
}


/* Wrapper for `fz_drop_colorspace()`.  */
FZ_FUNCTION void mfz_drop_colorspace(const Colorspace& colorspace)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_colorspace()\n";
	}
	mupdf::drop_colorspace(colorspace.m_internal);
}


/* Wrapper for `fz_drop_colorspace_imp()`.  */
FZ_FUNCTION void mfz_drop_colorspace_imp(const Storable& cs_)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_colorspace_imp()\n";
	}
	mupdf::drop_colorspace_imp(cs_.m_internal);
}


/* Wrapper for `fz_drop_compressed_buffer()`.  */
FZ_FUNCTION void mfz_drop_compressed_buffer(const CompressedBuffer& buf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_compressed_buffer()\n";
	}
	mupdf::drop_compressed_buffer(buf.m_internal);
}


/* Wrapper for `fz_drop_context()`.  */
FZ_FUNCTION void mfz_drop_context()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_context()\n";
	}
	mupdf::drop_context();
}


/* Wrapper for `fz_drop_default_colorspaces()`.  */
FZ_FUNCTION void mfz_drop_default_colorspaces(const DefaultColorspaces& default_cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_default_colorspaces()\n";
	}
	mupdf::drop_default_colorspaces(default_cs.m_internal);
}


/* Wrapper for `fz_drop_device()`.  */
FZ_FUNCTION void mfz_drop_device(const Device& dev)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_device()\n";
	}
	mupdf::drop_device(dev.m_internal);
}


/* Wrapper for `fz_drop_display_list()`.  */
FZ_FUNCTION void mfz_drop_display_list(const DisplayList& list)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_display_list()\n";
	}
	mupdf::drop_display_list(list.m_internal);
}


/* Wrapper for `fz_drop_document()`.  */
FZ_FUNCTION void mfz_drop_document(const Document& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_document()\n";
	}
	mupdf::drop_document(doc.m_internal);
}


/* Wrapper for `fz_drop_document_writer()`.  */
FZ_FUNCTION void mfz_drop_document_writer(const DocumentWriter& wri)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_document_writer()\n";
	}
	mupdf::drop_document_writer(wri.m_internal);
}


/* Wrapper for `fz_drop_font()`.  */
FZ_FUNCTION void mfz_drop_font(const Font& font)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_font()\n";
	}
	mupdf::drop_font(font.m_internal);
}


/* Wrapper for `fz_drop_glyph()`.  */
FZ_FUNCTION void mfz_drop_glyph(const Glyph& pix)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_glyph()\n";
	}
	mupdf::drop_glyph(pix.m_internal);
}


/* Wrapper for `fz_drop_halftone()`.  */
FZ_FUNCTION void mfz_drop_halftone(const Halftone& ht)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_halftone()\n";
	}
	mupdf::drop_halftone(ht.m_internal);
}


/* Wrapper for `fz_drop_hash_table()`.  */
FZ_FUNCTION void mfz_drop_hash_table(const HashTable& table)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_hash_table()\n";
	}
	mupdf::drop_hash_table(table.m_internal);
}


/* Wrapper for `fz_drop_image()`.  */
FZ_FUNCTION void mfz_drop_image(const Image& image)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_image()\n";
	}
	mupdf::drop_image(image.m_internal);
}


/* Wrapper for `fz_drop_image_base()`.  */
FZ_FUNCTION void mfz_drop_image_base(const Image& image)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_image_base()\n";
	}
	mupdf::drop_image_base(image.m_internal);
}


/* Wrapper for `fz_drop_image_imp()`.  */
FZ_FUNCTION void mfz_drop_image_imp(const Storable& image)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_image_imp()\n";
	}
	mupdf::drop_image_imp(image.m_internal);
}


/* Wrapper for `fz_drop_image_store_key()`.  */
FZ_FUNCTION void mfz_drop_image_store_key(const Image& image)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_image_store_key()\n";
	}
	mupdf::drop_image_store_key(image.m_internal);
}


/* Wrapper for `fz_drop_imp()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_drop_imp(void *p)` => `(int, int refs)`
	 */
FZ_FUNCTION int mfz_drop_imp(void *p, int *refs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_imp()\n";
	}
	auto ret = mupdf::drop_imp(p, refs);
	return ret;
}


/* Wrapper for `fz_drop_imp16()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_drop_imp16(void *p)` => `(int, int16_t refs)`
	 */
FZ_FUNCTION int mfz_drop_imp16(void *p, int16_t *refs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_imp16()\n";
	}
	auto ret = mupdf::drop_imp16(p, refs);
	return ret;
}


/* Wrapper for `fz_drop_imp8()`.  */
FZ_FUNCTION int mfz_drop_imp8(void *p, int8_t *refs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_imp8()\n";
	}
	auto ret = mupdf::drop_imp8(p, refs);
	return ret;
}


/* Wrapper for `fz_drop_jbig2_globals()`.  */
FZ_FUNCTION void mfz_drop_jbig2_globals(const Jbig2Globals& globals)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_jbig2_globals()\n";
	}
	mupdf::drop_jbig2_globals(globals.m_internal);
}


/* Wrapper for `fz_drop_jbig2_globals_imp()`.  */
FZ_FUNCTION void mfz_drop_jbig2_globals_imp(const Storable& globals)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_jbig2_globals_imp()\n";
	}
	mupdf::drop_jbig2_globals_imp(globals.m_internal);
}


/* Wrapper for `fz_drop_key_storable()`.  */
FZ_FUNCTION void mfz_drop_key_storable(const KeyStorable& arg_0)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_key_storable()\n";
	}
	mupdf::drop_key_storable(arg_0.m_internal);
}


/* Wrapper for `fz_drop_key_storable_key()`.  */
FZ_FUNCTION void mfz_drop_key_storable_key(const KeyStorable& arg_0)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_key_storable_key()\n";
	}
	mupdf::drop_key_storable_key(arg_0.m_internal);
}


/* Wrapper for `fz_drop_layout()`.  */
FZ_FUNCTION void mfz_drop_layout(const LayoutBlock& block)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_layout()\n";
	}
	mupdf::drop_layout(block.m_internal);
}


/* Wrapper for `fz_drop_link()`.  */
FZ_FUNCTION void mfz_drop_link(const Link& link)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_link()\n";
	}
	mupdf::drop_link(link.m_internal);
}


/* Wrapper for `fz_drop_outline()`.  */
FZ_FUNCTION void mfz_drop_outline(const Outline& outline)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_outline()\n";
	}
	mupdf::drop_outline(outline.m_internal);
}


/* Wrapper for `fz_drop_outline_iterator()`.  */
FZ_FUNCTION void mfz_drop_outline_iterator(const OutlineIterator& iter)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_outline_iterator()\n";
	}
	mupdf::drop_outline_iterator(iter.m_internal);
}


/* Wrapper for `fz_drop_output()`.  */
FZ_FUNCTION void mfz_drop_output(const Output& arg_0)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_output()\n";
	}
	mupdf::drop_output(arg_0.m_internal);
}


/* Wrapper for `fz_drop_page()`.  */
FZ_FUNCTION void mfz_drop_page(const Page& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_page()\n";
	}
	mupdf::drop_page(page.m_internal);
}


/* Wrapper for `fz_drop_path()`.  */
FZ_FUNCTION void mfz_drop_path(const Path& path)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_path()\n";
	}
	mupdf::drop_path(path.m_internal);
}


/* Wrapper for `fz_drop_pixmap()`.  */
FZ_FUNCTION void mfz_drop_pixmap(const Pixmap& pix)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_pixmap()\n";
	}
	mupdf::drop_pixmap(pix.m_internal);
}


/* Wrapper for `fz_drop_pool()`.  */
FZ_FUNCTION void mfz_drop_pool(const Pool& pool)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_pool()\n";
	}
	mupdf::drop_pool(pool.m_internal);
}


/* Wrapper for `fz_drop_separations()`.  */
FZ_FUNCTION void mfz_drop_separations(const Separations& sep)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_separations()\n";
	}
	mupdf::drop_separations(sep.m_internal);
}


/* Wrapper for `fz_drop_shade()`.  */
FZ_FUNCTION void mfz_drop_shade(const Shade& shade)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_shade()\n";
	}
	mupdf::drop_shade(shade.m_internal);
}


/* Wrapper for `fz_drop_shade_color_cache()`.  */
FZ_FUNCTION void mfz_drop_shade_color_cache(const ShadeColorCache& cache)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_shade_color_cache()\n";
	}
	mupdf::drop_shade_color_cache(cache.m_internal);
}


/* Wrapper for `fz_drop_shade_imp()`.  */
FZ_FUNCTION void mfz_drop_shade_imp(const Storable& shade)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_shade_imp()\n";
	}
	mupdf::drop_shade_imp(shade.m_internal);
}


/* Wrapper for `fz_drop_stext_page()`.  */
FZ_FUNCTION void mfz_drop_stext_page(const StextPage& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_stext_page()\n";
	}
	mupdf::drop_stext_page(page.m_internal);
}


/* Wrapper for `fz_drop_storable()`.  */
FZ_FUNCTION void mfz_drop_storable(const Storable& arg_0)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_storable()\n";
	}
	mupdf::drop_storable(arg_0.m_internal);
}


/* Wrapper for `fz_drop_store_context()`.  */
FZ_FUNCTION void mfz_drop_store_context()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_store_context()\n";
	}
	mupdf::drop_store_context();
}


/* Wrapper for `fz_drop_stream()`.  */
FZ_FUNCTION void mfz_drop_stream(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_stream()\n";
	}
	mupdf::drop_stream(stm.m_internal);
}


/* Wrapper for `fz_drop_stroke_state()`.  */
FZ_FUNCTION void mfz_drop_stroke_state(const StrokeState& stroke)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_stroke_state()\n";
	}
	mupdf::drop_stroke_state(stroke.m_internal);
}


/* Wrapper for `fz_drop_text()`.  */
FZ_FUNCTION void mfz_drop_text(const Text& text)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_text()\n";
	}
	mupdf::drop_text(text.m_internal);
}


/* Wrapper for `fz_drop_tree()`.  */
FZ_FUNCTION void mfz_drop_tree(const Tree& node, void (*dropfunc)(fz_context *, void *))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_tree()\n";
	}
	mupdf::drop_tree(node.m_internal, dropfunc);
}


/* Wrapper for `fz_drop_xml()`.  */
FZ_FUNCTION void mfz_drop_xml(const XmlDoc& xml)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_xml()\n";
	}
	mupdf::drop_xml(xml.m_internal);
}


/* Wrapper for `fz_drop_zip_writer()`.  */
FZ_FUNCTION void mfz_drop_zip_writer(const ZipWriter& zip)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_zip_writer()\n";
	}
	mupdf::drop_zip_writer(zip.m_internal);
}


/* Wrapper for `fz_dump_glyph_cache_stats()`.  */
FZ_FUNCTION void mfz_dump_glyph_cache_stats(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::dump_glyph_cache_stats()\n";
	}
	mupdf::dump_glyph_cache_stats(out.m_internal);
}


/* Wrapper for `fz_duplicate_glyph_names_from_unicode()`.  */
FZ_FUNCTION const char **mfz_duplicate_glyph_names_from_unicode(int unicode)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::duplicate_glyph_names_from_unicode()\n";
	}
	auto ret = mupdf::duplicate_glyph_names_from_unicode(unicode);
	return ret;
}


/* Wrapper for `fz_empty_store()`.  */
FZ_FUNCTION void mfz_empty_store()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::empty_store()\n";
	}
	mupdf::empty_store();
}


/* Wrapper for `fz_enable_device_hints()`.  */
FZ_FUNCTION void mfz_enable_device_hints(const Device& dev, int hints)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::enable_device_hints()\n";
	}
	mupdf::enable_device_hints(dev.m_internal, hints);
}


/* Wrapper for `fz_enable_icc()`.  */
FZ_FUNCTION void mfz_enable_icc()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::enable_icc()\n";
	}
	mupdf::enable_icc();
}


/* Wrapper for `fz_encode_character()`.  */
FZ_FUNCTION int mfz_encode_character(const Font& font, int unicode)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::encode_character()\n";
	}
	auto ret = mupdf::encode_character(font.m_internal, unicode);
	return ret;
}


/* Wrapper for `fz_encode_character_by_glyph_name()`.  */
FZ_FUNCTION int mfz_encode_character_by_glyph_name(const Font& font, const char *glyphname)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::encode_character_by_glyph_name()\n";
	}
	auto ret = mupdf::encode_character_by_glyph_name(font.m_internal, glyphname);
	return ret;
}


/* Wrapper for `fz_encode_character_sc()`.  */
FZ_FUNCTION int mfz_encode_character_sc(const Font& font, int unicode)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::encode_character_sc()\n";
	}
	auto ret = mupdf::encode_character_sc(font.m_internal, unicode);
	return ret;
}


/* Wrapper for `fz_encode_character_with_fallback()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_encode_character_with_fallback(fz_font *font, int unicode, int script, int language, fz_font **out_font)` => `(int)`
	 */
FZ_FUNCTION int mfz_encode_character_with_fallback(const Font& font, int unicode, int script, int language, Font& out_font)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::encode_character_with_fallback()\n";
	}
	/* Out-param out_font.m_internal will be overwritten. */
	drop_font(out_font.m_internal);
	out_font.m_internal = nullptr;
	auto ret = mupdf::encode_character_with_fallback(font.m_internal, unicode, script, language, &out_font.m_internal);
	/* We assume that out-param out_font.m_internal is a borrowed reference. */
	keep_font(out_font.m_internal);
	return ret;
}


/* Wrapper for `fz_end_group()`.  */
FZ_FUNCTION void mfz_end_group(const Device& dev)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::end_group()\n";
	}
	mupdf::end_group(dev.m_internal);
}


/* Wrapper for `fz_end_layer()`.  */
FZ_FUNCTION void mfz_end_layer(const Device& dev)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::end_layer()\n";
	}
	mupdf::end_layer(dev.m_internal);
}


/* Wrapper for `fz_end_mask()`.  */
FZ_FUNCTION void mfz_end_mask(const Device& dev)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::end_mask()\n";
	}
	mupdf::end_mask(dev.m_internal);
}


/* Wrapper for `fz_end_page()`.  */
FZ_FUNCTION void mfz_end_page(const DocumentWriter& wri)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::end_page()\n";
	}
	mupdf::end_page(wri.m_internal);
}


/* Wrapper for `fz_end_throw_on_repair()`.  */
FZ_FUNCTION void mfz_end_throw_on_repair()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::end_throw_on_repair()\n";
	}
	mupdf::end_throw_on_repair();
}


/* Wrapper for `fz_end_tile()`.  */
FZ_FUNCTION void mfz_end_tile(const Device& dev)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::end_tile()\n";
	}
	mupdf::end_tile(dev.m_internal);
}


/* Wrapper for `fz_error_callback()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_error_callback()` => `(fz_error_cb *, void *user)`
	 */
FZ_FUNCTION fz_error_cb *mfz_error_callback(void **user)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::error_callback()\n";
	}
	auto ret = mupdf::error_callback(user);
	return ret;
}


/* Wrapper for `fz_expand_irect()`.  */
FZ_FUNCTION Irect mfz_expand_irect(Irect& a, int expand)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::expand_irect()\n";
	}
	fz_irect temp = mupdf::expand_irect(*(fz_irect*) &a.x0, expand);
	auto ret = Irect(&temp);
	return ret;
}


/* Wrapper for `fz_expand_rect()`.  */
FZ_FUNCTION Rect mfz_expand_rect(Rect& b, float expand)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::expand_rect()\n";
	}
	fz_rect temp = mupdf::expand_rect(*(fz_rect*) &b.x0, expand);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `fz_file_exists()`.  */
FZ_FUNCTION int mfz_file_exists(const char *path)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::file_exists()\n";
	}
	auto ret = mupdf::file_exists(path);
	return ret;
}


/* Wrapper for `fz_fill_image()`.  */
FZ_FUNCTION void mfz_fill_image(const Device& dev, const Image& image, Matrix& ctm, float alpha, ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::fill_image()\n";
	}
	mupdf::fill_image(dev.m_internal, image.m_internal, *(fz_matrix*) &ctm.a, alpha, *(fz_color_params*) &color_params.ri);
}


/* Wrapper for `fz_fill_image_mask()`.  */
FZ_FUNCTION void mfz_fill_image_mask(const Device& dev, const Image& image, Matrix& ctm, const Colorspace& colorspace, const float *color, float alpha, ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::fill_image_mask()\n";
	}
	mupdf::fill_image_mask(dev.m_internal, image.m_internal, *(fz_matrix*) &ctm.a, colorspace.m_internal, color, alpha, *(fz_color_params*) &color_params.ri);
}


/* Wrapper for `fz_fill_path()`.  */
FZ_FUNCTION void mfz_fill_path(const Device& dev, const Path& path, int even_odd, Matrix& ctm, const Colorspace& colorspace, const float *color, float alpha, ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::fill_path()\n";
	}
	mupdf::fill_path(dev.m_internal, path.m_internal, even_odd, *(fz_matrix*) &ctm.a, colorspace.m_internal, color, alpha, *(fz_color_params*) &color_params.ri);
}


/* Wrapper for `fz_fill_pixmap_with_color()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_fill_pixmap_with_color(fz_pixmap *pix, fz_colorspace *colorspace, fz_color_params color_params)` => float color
	 */
FZ_FUNCTION void mfz_fill_pixmap_with_color(const Pixmap& pix, const Colorspace& colorspace, float *color, ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::fill_pixmap_with_color()\n";
	}
	mupdf::fill_pixmap_with_color(pix.m_internal, colorspace.m_internal, color, *(fz_color_params*) &color_params.ri);
}


/* Wrapper for `fz_fill_shade()`.  */
FZ_FUNCTION void mfz_fill_shade(const Device& dev, const Shade& shade, Matrix& ctm, float alpha, ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::fill_shade()\n";
	}
	mupdf::fill_shade(dev.m_internal, shade.m_internal, *(fz_matrix*) &ctm.a, alpha, *(fz_color_params*) &color_params.ri);
}


/* Wrapper for `fz_fill_text()`.  */
FZ_FUNCTION void mfz_fill_text(const Device& dev, const Text& text, Matrix& ctm, const Colorspace& colorspace, const float *color, float alpha, ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::fill_text()\n";
	}
	mupdf::fill_text(dev.m_internal, text.m_internal, *(fz_matrix*) &ctm.a, colorspace.m_internal, color, alpha, *(fz_color_params*) &color_params.ri);
}


/* Wrapper for `fz_filter_store()`.  */
FZ_FUNCTION void mfz_filter_store(fz_store_filter_fn *fn, void *arg, const StoreType& type)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::filter_store()\n";
	}
	mupdf::filter_store(fn, arg, type.m_internal);
}


/* Wrapper for `fz_find_item()`.  */
FZ_FUNCTION void *mfz_find_item(fz_store_drop_fn *drop, void *key, const StoreType& type)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::find_item()\n";
	}
	auto ret = mupdf::find_item(drop, key, type.m_internal);
	return ret;
}


/* Wrapper for `fz_flush_output()`.  */
FZ_FUNCTION void mfz_flush_output(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::flush_output()\n";
	}
	mupdf::flush_output(out.m_internal);
}


/* Wrapper for `fz_flush_warnings()`.  */
FZ_FUNCTION void mfz_flush_warnings()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::flush_warnings()\n";
	}
	mupdf::flush_warnings();
}


/* Wrapper for `fz_font_ascender()`.  */
FZ_FUNCTION float mfz_font_ascender(const Font& font)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::font_ascender()\n";
	}
	auto ret = mupdf::font_ascender(font.m_internal);
	return ret;
}


/* Wrapper for `fz_font_bbox()`.  */
FZ_FUNCTION Rect mfz_font_bbox(const Font& font)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::font_bbox()\n";
	}
	fz_rect temp = mupdf::font_bbox(font.m_internal);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `fz_font_descender()`.  */
FZ_FUNCTION float mfz_font_descender(const Font& font)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::font_descender()\n";
	}
	auto ret = mupdf::font_descender(font.m_internal);
	return ret;
}


/* Wrapper for `fz_font_digest()`.  */
FZ_FUNCTION void mfz_font_digest(const Font& font, unsigned char digest[16])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::font_digest()\n";
	}
	mupdf::font_digest(font.m_internal, digest);
}


/* Wrapper for `fz_font_flags()`.  */
FZ_FUNCTION fz_font_flags_t *mfz_font_flags(const Font& font)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::font_flags()\n";
	}
	auto ret = mupdf::font_flags(font.m_internal);
	return ret;
}


/* Wrapper for `fz_font_ft_face()`.  */
FZ_FUNCTION void *mfz_font_ft_face(const Font& font)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::font_ft_face()\n";
	}
	auto ret = mupdf::font_ft_face(font.m_internal);
	return ret;
}


/* Wrapper for `fz_font_is_bold()`.  */
FZ_FUNCTION int mfz_font_is_bold(const Font& font)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::font_is_bold()\n";
	}
	auto ret = mupdf::font_is_bold(font.m_internal);
	return ret;
}


/* Wrapper for `fz_font_is_italic()`.  */
FZ_FUNCTION int mfz_font_is_italic(const Font& font)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::font_is_italic()\n";
	}
	auto ret = mupdf::font_is_italic(font.m_internal);
	return ret;
}


/* Wrapper for `fz_font_is_monospaced()`.  */
FZ_FUNCTION int mfz_font_is_monospaced(const Font& font)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::font_is_monospaced()\n";
	}
	auto ret = mupdf::font_is_monospaced(font.m_internal);
	return ret;
}


/* Wrapper for `fz_font_is_serif()`.  */
FZ_FUNCTION int mfz_font_is_serif(const Font& font)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::font_is_serif()\n";
	}
	auto ret = mupdf::font_is_serif(font.m_internal);
	return ret;
}


/* Wrapper for `fz_font_name()`.  */
FZ_FUNCTION const char *mfz_font_name(const Font& font)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::font_name()\n";
	}
	auto ret = mupdf::font_name(font.m_internal);
	return ret;
}


/* Wrapper for `fz_font_shaper_data()`.  */
FZ_FUNCTION fz_shaper_data_t *mfz_font_shaper_data(const Font& font)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::font_shaper_data()\n";
	}
	auto ret = mupdf::font_shaper_data(font.m_internal);
	return ret;
}


/* Wrapper for `fz_font_t3_procs()`.  */
FZ_FUNCTION fz_buffer **mfz_font_t3_procs(const Font& font)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::font_t3_procs()\n";
	}
	auto ret = mupdf::font_t3_procs(font.m_internal);
	return ret;
}


/* Wrapper for `fz_format_link_uri()`.  */
FZ_FUNCTION char *mfz_format_link_uri(const Document& doc, const LinkDest& dest)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::format_link_uri()\n";
	}
	auto ret = mupdf::format_link_uri(doc.m_internal, *dest.m_internal);
	return ret;
}


/* Wrapper for `fz_format_output_path()`.  */
FZ_FUNCTION void mfz_format_output_path(char *path, size_t size, const char *fmt, int page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::format_output_path()\n";
	}
	mupdf::format_output_path(path, size, fmt, page);
}


/* Wrapper for `fz_format_string()`.  */
FZ_FUNCTION void mfz_format_string(void *user, void (*emit)(fz_context *, void *, int ), const char *fmt, va_list args)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::format_string()\n";
	}
	mupdf::format_string(user, emit, fmt, args);
}


/* Wrapper for `fz_free()`.  */
FZ_FUNCTION void mfz_free(void *p)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::free()\n";
	}
	mupdf::free(p);
}


/* Wrapper for `fz_gamma_pixmap()`.  */
FZ_FUNCTION void mfz_gamma_pixmap(const Pixmap& pix, float gamma)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::gamma_pixmap()\n";
	}
	mupdf::gamma_pixmap(pix.m_internal, gamma);
}


/* Wrapper for `fz_generate_transition()`.  */
FZ_FUNCTION int mfz_generate_transition(const Pixmap& tpix, const Pixmap& opix, const Pixmap& npix, int time, Transition& trans)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::generate_transition()\n";
	}
	auto ret = mupdf::generate_transition(tpix.m_internal, opix.m_internal, npix.m_internal, time, (fz_transition *) &trans.type);
	return ret;
}


/* Wrapper for `fz_get_glyph_name()`.  */
FZ_FUNCTION void mfz_get_glyph_name(const Font& font, int glyph, char *buf, int size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::get_glyph_name()\n";
	}
	mupdf::get_glyph_name(font.m_internal, glyph, buf, size);
}


/* Wrapper for `fz_get_pixmap_from_image()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_get_pixmap_from_image(fz_image *image, const fz_irect *subarea, fz_matrix *ctm)` => `(fz_pixmap *, int w, int h)`
	 */
FZ_FUNCTION Pixmap mfz_get_pixmap_from_image(const Image& image, Irect& subarea, Matrix& ctm, int *w, int *h)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::get_pixmap_from_image()\n";
	}
	fz_pixmap* temp = mupdf::get_pixmap_from_image(image.m_internal, (const fz_irect *) &subarea.x0, (fz_matrix *) &ctm.a, w, h);
	mupdf::keep_pixmap(temp);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_get_unscaled_pixmap_from_image()`.  */
FZ_FUNCTION Pixmap mfz_get_unscaled_pixmap_from_image(const Image& image)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::get_unscaled_pixmap_from_image()\n";
	}
	fz_pixmap* temp = mupdf::get_unscaled_pixmap_from_image(image.m_internal);
	mupdf::keep_pixmap(temp);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_getopt()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_getopt(int nargc, const char *ostr)` => `(int, char *nargv)`
	 */
FZ_FUNCTION int mfz_getopt(int nargc, char **nargv, const char *ostr)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::getopt()\n";
	}
	auto ret = mupdf::getopt(nargc, nargv, ostr);
	return ret;
}


/* Wrapper for `fz_glyph_bbox()`.  */
FZ_FUNCTION Irect mfz_glyph_bbox(const Glyph& glyph)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::glyph_bbox()\n";
	}
	fz_irect temp = mupdf::glyph_bbox(glyph.m_internal);
	auto ret = Irect(&temp);
	return ret;
}


/* Wrapper for `fz_glyph_bbox_no_ctx()`.  */
FZ_FUNCTION Irect mfz_glyph_bbox_no_ctx(const Glyph& src)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::glyph_bbox_no_ctx()\n";
	}
	fz_irect temp = mupdf::glyph_bbox_no_ctx(src.m_internal);
	auto ret = Irect(&temp);
	return ret;
}


/* Wrapper for `fz_glyph_cacheable()`.  */
FZ_FUNCTION int mfz_glyph_cacheable(const Font& font, int gid)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::glyph_cacheable()\n";
	}
	auto ret = mupdf::glyph_cacheable(font.m_internal, gid);
	return ret;
}


/* Wrapper for `fz_glyph_height()`.  */
FZ_FUNCTION int mfz_glyph_height(const Glyph& glyph)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::glyph_height()\n";
	}
	auto ret = mupdf::glyph_height(glyph.m_internal);
	return ret;
}


/* Wrapper for `fz_glyph_name_from_unicode_sc()`.  */
FZ_FUNCTION const char *mfz_glyph_name_from_unicode_sc(int unicode)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::glyph_name_from_unicode_sc()\n";
	}
	auto ret = mupdf::glyph_name_from_unicode_sc(unicode);
	return ret;
}


/* Wrapper for `fz_glyph_width()`.  */
FZ_FUNCTION int mfz_glyph_width(const Glyph& glyph)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::glyph_width()\n";
	}
	auto ret = mupdf::glyph_width(glyph.m_internal);
	return ret;
}


/* Wrapper for `fz_graphics_aa_level()`.  */
FZ_FUNCTION int mfz_graphics_aa_level()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::graphics_aa_level()\n";
	}
	auto ret = mupdf::graphics_aa_level();
	return ret;
}


/* Wrapper for `fz_graphics_min_line_width()`.  */
FZ_FUNCTION float mfz_graphics_min_line_width()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::graphics_min_line_width()\n";
	}
	auto ret = mupdf::graphics_min_line_width();
	return ret;
}


/* Wrapper for `fz_gridfit_matrix()`.  */
FZ_FUNCTION Matrix mfz_gridfit_matrix(int as_tiled, Matrix& m)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::gridfit_matrix()\n";
	}
	fz_matrix temp = mupdf::gridfit_matrix(as_tiled, *(fz_matrix*) &m.a);
	auto ret = Matrix(&temp);
	return ret;
}


/* Wrapper for `fz_grisu()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_grisu(float f, char *s)` => `(int, int exp)`
	 */
FZ_FUNCTION int mfz_grisu(float f, char *s, int *exp)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::grisu()\n";
	}
	auto ret = mupdf::grisu(f, s, exp);
	return ret;
}


/* Wrapper for `fz_grow_buffer()`.  */
FZ_FUNCTION void mfz_grow_buffer(const Buffer& buf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::grow_buffer()\n";
	}
	mupdf::grow_buffer(buf.m_internal);
}


/* Wrapper for `fz_has_archive_entry()`.  */
FZ_FUNCTION int mfz_has_archive_entry(const Archive& arch, const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::has_archive_entry()\n";
	}
	auto ret = mupdf::has_archive_entry(arch.m_internal, name);
	return ret;
}


/* Wrapper for `fz_has_option()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_has_option(const char *opts, const char *key)` => `(int, const char *val)`
	 */
FZ_FUNCTION int mfz_has_option(const char *opts, const char *key, const char **val)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::has_option()\n";
	}
	auto ret = mupdf::has_option(opts, key, val);
	return ret;
}


/* Wrapper for `fz_has_permission()`.  */
FZ_FUNCTION int mfz_has_permission(const Document& doc, fz_permission p)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::has_permission()\n";
	}
	auto ret = mupdf::has_permission(doc.m_internal, p);
	return ret;
}


/* Wrapper for `fz_hash_filter()`.  */
FZ_FUNCTION void mfz_hash_filter(const HashTable& table, void *state, fz_hash_table_filter_fn *callback)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::hash_filter()\n";
	}
	mupdf::hash_filter(table.m_internal, state, callback);
}


/* Wrapper for `fz_hash_find()`.  */
FZ_FUNCTION void *mfz_hash_find(const HashTable& table, const void *key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::hash_find()\n";
	}
	auto ret = mupdf::hash_find(table.m_internal, key);
	return ret;
}


/* Wrapper for `fz_hash_for_each()`.  */
FZ_FUNCTION void mfz_hash_for_each(const HashTable& table, void *state, fz_hash_table_for_each_fn *callback)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::hash_for_each()\n";
	}
	mupdf::hash_for_each(table.m_internal, state, callback);
}


/* Wrapper for `fz_hash_insert()`.  */
FZ_FUNCTION void *mfz_hash_insert(const HashTable& table, const void *key, void *val)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::hash_insert()\n";
	}
	auto ret = mupdf::hash_insert(table.m_internal, key, val);
	return ret;
}


/* Wrapper for `fz_hash_remove()`.  */
FZ_FUNCTION void mfz_hash_remove(const HashTable& table, const void *key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::hash_remove()\n";
	}
	mupdf::hash_remove(table.m_internal, key);
}


/* Wrapper for `fz_hb_lock()`.  */
FZ_FUNCTION void mfz_hb_lock()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::hb_lock()\n";
	}
	mupdf::hb_lock();
}


/* Wrapper for `fz_hb_unlock()`.  */
FZ_FUNCTION void mfz_hb_unlock()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::hb_unlock()\n";
	}
	mupdf::hb_unlock();
}


/* Wrapper for `fz_highlight_selection()`.  */
FZ_FUNCTION int mfz_highlight_selection(const StextPage& page, Point& a, Point& b, Quad& quads, int max_quads)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::highlight_selection()\n";
	}
	auto ret = mupdf::highlight_selection(page.m_internal, *(fz_point*) &a.x, *(fz_point*) &b.x, (fz_quad *) &quads.ul, max_quads);
	return ret;
}


/* Wrapper for `fz_ignore_text()`.  */
FZ_FUNCTION void mfz_ignore_text(const Device& dev, const Text& text, Matrix& ctm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ignore_text()\n";
	}
	mupdf::ignore_text(dev.m_internal, text.m_internal, *(fz_matrix*) &ctm.a);
}


/* Wrapper for `fz_image_orientation()`.  */
FZ_FUNCTION uint8_t mfz_image_orientation(const Image& image)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::image_orientation()\n";
	}
	auto ret = mupdf::image_orientation(image.m_internal);
	return ret;
}


/* Wrapper for `fz_image_orientation_matrix()`.  */
FZ_FUNCTION Matrix mfz_image_orientation_matrix(const Image& image)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::image_orientation_matrix()\n";
	}
	fz_matrix temp = mupdf::image_orientation_matrix(image.m_internal);
	auto ret = Matrix(&temp);
	return ret;
}


/* Wrapper for `fz_image_resolution()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_image_resolution(fz_image *image)` => `(int xres, int yres)`
	 */
FZ_FUNCTION void mfz_image_resolution(const Image& image, int *xres, int *yres)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::image_resolution()\n";
	}
	mupdf::image_resolution(image.m_internal, xres, yres);
}


/* Wrapper for `fz_image_size()`.  */
FZ_FUNCTION size_t mfz_image_size(const Image& im)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::image_size()\n";
	}
	auto ret = mupdf::image_size(im.m_internal);
	return ret;
}


/* Wrapper for `fz_include_point_in_rect()`.  */
FZ_FUNCTION Rect mfz_include_point_in_rect(Rect& r, Point& p)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::include_point_in_rect()\n";
	}
	fz_rect temp = mupdf::include_point_in_rect(*(fz_rect*) &r.x0, *(fz_point*) &p.x);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `fz_install_load_system_font_funcs()`.  */
FZ_FUNCTION void mfz_install_load_system_font_funcs(fz_load_system_font_fn *f, fz_load_system_cjk_font_fn *f_cjk, fz_load_system_fallback_font_fn *f_fallback)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::install_load_system_font_funcs()\n";
	}
	mupdf::install_load_system_font_funcs(f, f_cjk, f_fallback);
}


/* Wrapper for `fz_intersect_irect()`.  */
FZ_FUNCTION Irect mfz_intersect_irect(Irect& a, Irect& b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::intersect_irect()\n";
	}
	fz_irect temp = mupdf::intersect_irect(*(fz_irect*) &a.x0, *(fz_irect*) &b.x0);
	auto ret = Irect(&temp);
	return ret;
}


/* Wrapper for `fz_intersect_rect()`.  */
FZ_FUNCTION Rect mfz_intersect_rect(Rect& a, Rect& b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::intersect_rect()\n";
	}
	fz_rect temp = mupdf::intersect_rect(*(fz_rect*) &a.x0, *(fz_rect*) &b.x0);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `fz_invert_matrix()`.  */
FZ_FUNCTION Matrix mfz_invert_matrix(Matrix& matrix)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::invert_matrix()\n";
	}
	fz_matrix temp = mupdf::invert_matrix(*(fz_matrix*) &matrix.a);
	auto ret = Matrix(&temp);
	return ret;
}


/* Wrapper for `fz_invert_pixmap()`.  */
FZ_FUNCTION void mfz_invert_pixmap(const Pixmap& pix)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::invert_pixmap()\n";
	}
	mupdf::invert_pixmap(pix.m_internal);
}


/* Wrapper for `fz_invert_pixmap_alpha()`.  */
FZ_FUNCTION void mfz_invert_pixmap_alpha(const Pixmap& pix)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::invert_pixmap_alpha()\n";
	}
	mupdf::invert_pixmap_alpha(pix.m_internal);
}


/* Wrapper for `fz_invert_pixmap_luminance()`.  */
FZ_FUNCTION void mfz_invert_pixmap_luminance(const Pixmap& pix)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::invert_pixmap_luminance()\n";
	}
	mupdf::invert_pixmap_luminance(pix.m_internal);
}


/* Wrapper for `fz_invert_pixmap_rect()`.  */
FZ_FUNCTION void mfz_invert_pixmap_rect(const Pixmap& image, Irect& rect)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::invert_pixmap_rect()\n";
	}
	mupdf::invert_pixmap_rect(image.m_internal, *(fz_irect*) &rect.x0);
}


/* Wrapper for `fz_irect_from_rect()`.  */
FZ_FUNCTION Irect mfz_irect_from_rect(Rect& rect)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::irect_from_rect()\n";
	}
	fz_irect temp = mupdf::irect_from_rect(*(fz_rect*) &rect.x0);
	auto ret = Irect(&temp);
	return ret;
}


/* Wrapper for `fz_irect_height()`.  */
FZ_FUNCTION int mfz_irect_height(Irect& r)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::irect_height()\n";
	}
	auto ret = mupdf::irect_height(*(fz_irect*) &r.x0);
	return ret;
}


/* Wrapper for `fz_irect_width()`.  */
FZ_FUNCTION unsigned int mfz_irect_width(Irect& r)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::irect_width()\n";
	}
	auto ret = mupdf::irect_width(*(fz_irect*) &r.x0);
	return ret;
}


/* Wrapper for `fz_is_directory()`.  */
FZ_FUNCTION int mfz_is_directory(const char *path)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_directory()\n";
	}
	auto ret = mupdf::is_directory(path);
	return ret;
}


/* Wrapper for `fz_is_document_reflowable()`.  */
FZ_FUNCTION int mfz_is_document_reflowable(const Document& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_document_reflowable()\n";
	}
	auto ret = mupdf::is_document_reflowable(doc.m_internal);
	return ret;
}


/* Wrapper for `fz_is_empty_irect()`.  */
FZ_FUNCTION int mfz_is_empty_irect(Irect& r)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_empty_irect()\n";
	}
	auto ret = mupdf::is_empty_irect(*(fz_irect*) &r.x0);
	return ret;
}


/* Wrapper for `fz_is_empty_rect()`.  */
FZ_FUNCTION int mfz_is_empty_rect(Rect& r)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_empty_rect()\n";
	}
	auto ret = mupdf::is_empty_rect(*(fz_rect*) &r.x0);
	return ret;
}


/* Wrapper for `fz_is_eof()`.  */
FZ_FUNCTION int mfz_is_eof(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_eof()\n";
	}
	auto ret = mupdf::is_eof(stm.m_internal);
	return ret;
}


/* Wrapper for `fz_is_eof_bits()`.  */
FZ_FUNCTION int mfz_is_eof_bits(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_eof_bits()\n";
	}
	auto ret = mupdf::is_eof_bits(stm.m_internal);
	return ret;
}


/* Wrapper for `fz_is_external_link()`.  */
FZ_FUNCTION int mfz_is_external_link(const char *uri)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_external_link()\n";
	}
	auto ret = mupdf::is_external_link(uri);
	return ret;
}


/* Wrapper for `fz_is_identity()`.  */
FZ_FUNCTION int mfz_is_identity(Matrix& m)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_identity()\n";
	}
	auto ret = mupdf::is_identity(*(fz_matrix*) &m.a);
	return ret;
}


/* Wrapper for `fz_is_infinite_irect()`.  */
FZ_FUNCTION int mfz_is_infinite_irect(Irect& r)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_infinite_irect()\n";
	}
	auto ret = mupdf::is_infinite_irect(*(fz_irect*) &r.x0);
	return ret;
}


/* Wrapper for `fz_is_infinite_rect()`.  */
FZ_FUNCTION int mfz_is_infinite_rect(Rect& r)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_infinite_rect()\n";
	}
	auto ret = mupdf::is_infinite_rect(*(fz_rect*) &r.x0);
	return ret;
}


/* Wrapper for `fz_is_page_range()`.  */
FZ_FUNCTION int mfz_is_page_range(const char *s)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_page_range()\n";
	}
	auto ret = mupdf::is_page_range(s);
	return ret;
}


/* Wrapper for `fz_is_pixmap_monochrome()`.  */
FZ_FUNCTION int mfz_is_pixmap_monochrome(const Pixmap& pixmap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_pixmap_monochrome()\n";
	}
	auto ret = mupdf::is_pixmap_monochrome(pixmap.m_internal);
	return ret;
}


/* Wrapper for `fz_is_point_inside_irect()`.  */
FZ_FUNCTION int mfz_is_point_inside_irect(int x, int y, Irect& r)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_point_inside_irect()\n";
	}
	auto ret = mupdf::is_point_inside_irect(x, y, *(fz_irect*) &r.x0);
	return ret;
}


/* Wrapper for `fz_is_point_inside_quad()`.  */
FZ_FUNCTION int mfz_is_point_inside_quad(Point& p, Quad& q)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_point_inside_quad()\n";
	}
	auto ret = mupdf::is_point_inside_quad(*(fz_point*) &p.x, *(fz_quad*) &q.ul);
	return ret;
}


/* Wrapper for `fz_is_point_inside_rect()`.  */
FZ_FUNCTION int mfz_is_point_inside_rect(Point& p, Rect& r)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_point_inside_rect()\n";
	}
	auto ret = mupdf::is_point_inside_rect(*(fz_point*) &p.x, *(fz_rect*) &r.x0);
	return ret;
}


/* Wrapper for `fz_is_pow2()`.  */
FZ_FUNCTION int mfz_is_pow2(int a)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_pow2()\n";
	}
	auto ret = mupdf::is_pow2(a);
	return ret;
}


/* Wrapper for `fz_is_quad_inside_quad()`.  */
FZ_FUNCTION int mfz_is_quad_inside_quad(Quad& needle, Quad& haystack)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_quad_inside_quad()\n";
	}
	auto ret = mupdf::is_quad_inside_quad(*(fz_quad*) &needle.ul, *(fz_quad*) &haystack.ul);
	return ret;
}


/* Wrapper for `fz_is_quad_intersecting_quad()`.  */
FZ_FUNCTION int mfz_is_quad_intersecting_quad(Quad& a, Quad& b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_quad_intersecting_quad()\n";
	}
	auto ret = mupdf::is_quad_intersecting_quad(*(fz_quad*) &a.ul, *(fz_quad*) &b.ul);
	return ret;
}


/* Wrapper for `fz_is_rectilinear()`.  */
FZ_FUNCTION int mfz_is_rectilinear(Matrix& m)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_rectilinear()\n";
	}
	auto ret = mupdf::is_rectilinear(*(fz_matrix*) &m.a);
	return ret;
}


/* Wrapper for `fz_is_tar_archive()`.  */
FZ_FUNCTION int mfz_is_tar_archive(const Stream& file)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_tar_archive()\n";
	}
	auto ret = mupdf::is_tar_archive(file.m_internal);
	return ret;
}


/* Wrapper for `fz_is_valid_blend_colorspace()`.  */
FZ_FUNCTION int mfz_is_valid_blend_colorspace(const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_valid_blend_colorspace()\n";
	}
	auto ret = mupdf::is_valid_blend_colorspace(cs.m_internal);
	return ret;
}


/* Wrapper for `fz_is_valid_irect()`.  */
FZ_FUNCTION int mfz_is_valid_irect(Irect& r)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_valid_irect()\n";
	}
	auto ret = mupdf::is_valid_irect(*(fz_irect*) &r.x0);
	return ret;
}


/* Wrapper for `fz_is_valid_rect()`.  */
FZ_FUNCTION int mfz_is_valid_rect(Rect& r)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_valid_rect()\n";
	}
	auto ret = mupdf::is_valid_rect(*(fz_rect*) &r.x0);
	return ret;
}


/* Wrapper for `fz_is_zip_archive()`.  */
FZ_FUNCTION int mfz_is_zip_archive(const Stream& file)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_zip_archive()\n";
	}
	auto ret = mupdf::is_zip_archive(file.m_internal);
	return ret;
}


/* Wrapper for `fz_iso8859_1_from_unicode()`.  */
FZ_FUNCTION int mfz_iso8859_1_from_unicode(int u)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::iso8859_1_from_unicode()\n";
	}
	auto ret = mupdf::iso8859_1_from_unicode(u);
	return ret;
}


/* Wrapper for `fz_iso8859_7_from_unicode()`.  */
FZ_FUNCTION int mfz_iso8859_7_from_unicode(int u)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::iso8859_7_from_unicode()\n";
	}
	auto ret = mupdf::iso8859_7_from_unicode(u);
	return ret;
}


/* Wrapper for `fz_jbig2_globals_data()`.  */
FZ_FUNCTION Buffer mfz_jbig2_globals_data(const Jbig2Globals& globals)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::jbig2_globals_data()\n";
	}
	fz_buffer* temp = mupdf::jbig2_globals_data(globals.m_internal);
	mupdf::keep_buffer(temp);
	auto ret = Buffer(temp);
	return ret;
}


/* Wrapper for `fz_keep_bitmap()`.  */
FZ_FUNCTION Bitmap mfz_keep_bitmap(const Bitmap& bit)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_bitmap()\n";
	}
	fz_bitmap* temp = mupdf::keep_bitmap(bit.m_internal);
	auto ret = Bitmap(temp);
	return ret;
}


/* Wrapper for `fz_keep_buffer()`.  */
FZ_FUNCTION Buffer mfz_keep_buffer(const Buffer& buf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_buffer()\n";
	}
	fz_buffer* temp = mupdf::keep_buffer(buf.m_internal);
	auto ret = Buffer(temp);
	return ret;
}


/* Wrapper for `fz_keep_colorspace()`.  */
FZ_FUNCTION Colorspace mfz_keep_colorspace(const Colorspace& colorspace)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_colorspace()\n";
	}
	fz_colorspace* temp = mupdf::keep_colorspace(colorspace.m_internal);
	auto ret = Colorspace(temp);
	return ret;
}


/* Wrapper for `fz_keep_default_colorspaces()`.  */
FZ_FUNCTION DefaultColorspaces mfz_keep_default_colorspaces(const DefaultColorspaces& default_cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_default_colorspaces()\n";
	}
	fz_default_colorspaces* temp = mupdf::keep_default_colorspaces(default_cs.m_internal);
	auto ret = DefaultColorspaces(temp);
	return ret;
}


/* Wrapper for `fz_keep_device()`.  */
FZ_FUNCTION Device mfz_keep_device(const Device& dev)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_device()\n";
	}
	fz_device* temp = mupdf::keep_device(dev.m_internal);
	auto ret = Device(temp);
	return ret;
}


/* Wrapper for `fz_keep_display_list()`.  */
FZ_FUNCTION DisplayList mfz_keep_display_list(const DisplayList& list)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_display_list()\n";
	}
	fz_display_list* temp = mupdf::keep_display_list(list.m_internal);
	auto ret = DisplayList(temp);
	return ret;
}


/* Wrapper for `fz_keep_document()`.  */
FZ_FUNCTION Document mfz_keep_document(const Document& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_document()\n";
	}
	fz_document* temp = mupdf::keep_document(doc.m_internal);
	auto ret = Document(temp);
	return ret;
}


/* Wrapper for `fz_keep_font()`.  */
FZ_FUNCTION Font mfz_keep_font(const Font& font)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_font()\n";
	}
	fz_font* temp = mupdf::keep_font(font.m_internal);
	auto ret = Font(temp);
	return ret;
}


/* Wrapper for `fz_keep_glyph()`.  */
FZ_FUNCTION Glyph mfz_keep_glyph(const Glyph& pix)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_glyph()\n";
	}
	fz_glyph* temp = mupdf::keep_glyph(pix.m_internal);
	auto ret = Glyph(temp);
	return ret;
}


/* Wrapper for `fz_keep_halftone()`.  */
FZ_FUNCTION Halftone mfz_keep_halftone(const Halftone& half)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_halftone()\n";
	}
	fz_halftone* temp = mupdf::keep_halftone(half.m_internal);
	auto ret = Halftone(temp);
	return ret;
}


/* Wrapper for `fz_keep_image()`.  */
FZ_FUNCTION Image mfz_keep_image(const Image& image)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_image()\n";
	}
	fz_image* temp = mupdf::keep_image(image.m_internal);
	auto ret = Image(temp);
	return ret;
}


/* Wrapper for `fz_keep_image_store_key()`.  */
FZ_FUNCTION Image mfz_keep_image_store_key(const Image& image)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_image_store_key()\n";
	}
	fz_image* temp = mupdf::keep_image_store_key(image.m_internal);
	auto ret = Image(temp);
	return ret;
}


/* Wrapper for `fz_keep_imp()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_keep_imp(void *p)` => `(void *, int refs)`
	 */
FZ_FUNCTION void *mfz_keep_imp(void *p, int *refs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_imp()\n";
	}
	auto ret = mupdf::keep_imp(p, refs);
	return ret;
}


/* Wrapper for `fz_keep_imp16()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_keep_imp16(void *p)` => `(void *, int16_t refs)`
	 */
FZ_FUNCTION void *mfz_keep_imp16(void *p, int16_t *refs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_imp16()\n";
	}
	auto ret = mupdf::keep_imp16(p, refs);
	return ret;
}


/* Wrapper for `fz_keep_imp8()`.  */
FZ_FUNCTION void *mfz_keep_imp8(void *p, int8_t *refs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_imp8()\n";
	}
	auto ret = mupdf::keep_imp8(p, refs);
	return ret;
}


/* Wrapper for `fz_keep_imp_locked()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_keep_imp_locked(void *p)` => `(void *, int refs)`
	 */
FZ_FUNCTION void *mfz_keep_imp_locked(void *p, int *refs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_imp_locked()\n";
	}
	auto ret = mupdf::keep_imp_locked(p, refs);
	return ret;
}


/* Wrapper for `fz_keep_jbig2_globals()`.  */
FZ_FUNCTION Jbig2Globals mfz_keep_jbig2_globals(const Jbig2Globals& globals)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_jbig2_globals()\n";
	}
	fz_jbig2_globals* temp = mupdf::keep_jbig2_globals(globals.m_internal);
	auto ret = Jbig2Globals(temp);
	return ret;
}


/* Wrapper for `fz_keep_key_storable()`.  */
FZ_FUNCTION void *mfz_keep_key_storable(const KeyStorable& arg_0)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_key_storable()\n";
	}
	auto ret = mupdf::keep_key_storable(arg_0.m_internal);
	return ret;
}


/* Wrapper for `fz_keep_key_storable_key()`.  */
FZ_FUNCTION void *mfz_keep_key_storable_key(const KeyStorable& arg_0)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_key_storable_key()\n";
	}
	auto ret = mupdf::keep_key_storable_key(arg_0.m_internal);
	return ret;
}


/* Wrapper for `fz_keep_link()`.  */
FZ_FUNCTION Link mfz_keep_link(const Link& link)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_link()\n";
	}
	fz_link* temp = mupdf::keep_link(link.m_internal);
	auto ret = Link(temp);
	return ret;
}


/* Wrapper for `fz_keep_outline()`.  */
FZ_FUNCTION Outline mfz_keep_outline(const Outline& outline)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_outline()\n";
	}
	fz_outline* temp = mupdf::keep_outline(outline.m_internal);
	auto ret = Outline(temp);
	return ret;
}


/* Wrapper for `fz_keep_page()`.  */
FZ_FUNCTION Page mfz_keep_page(const Page& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_page()\n";
	}
	fz_page* temp = mupdf::keep_page(page.m_internal);
	auto ret = Page(temp);
	return ret;
}


/* Wrapper for `fz_keep_page_locked()`.  */
FZ_FUNCTION Page mfz_keep_page_locked(const Page& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_page_locked()\n";
	}
	fz_page* temp = mupdf::keep_page_locked(page.m_internal);
	auto ret = Page(temp);
	return ret;
}


/* Wrapper for `fz_keep_path()`.  */
FZ_FUNCTION Path mfz_keep_path(const Path& path)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_path()\n";
	}
	fz_path* temp = mupdf::keep_path(path.m_internal);
	auto ret = Path(temp);
	return ret;
}


/* Wrapper for `fz_keep_pixmap()`.  */
FZ_FUNCTION Pixmap mfz_keep_pixmap(const Pixmap& pix)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_pixmap()\n";
	}
	fz_pixmap* temp = mupdf::keep_pixmap(pix.m_internal);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_keep_separations()`.  */
FZ_FUNCTION Separations mfz_keep_separations(const Separations& sep)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_separations()\n";
	}
	fz_separations* temp = mupdf::keep_separations(sep.m_internal);
	auto ret = Separations(temp);
	return ret;
}


/* Wrapper for `fz_keep_shade()`.  */
FZ_FUNCTION Shade mfz_keep_shade(const Shade& shade)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_shade()\n";
	}
	fz_shade* temp = mupdf::keep_shade(shade.m_internal);
	auto ret = Shade(temp);
	return ret;
}


/* Wrapper for `fz_keep_storable()`.  */
FZ_FUNCTION void *mfz_keep_storable(const Storable& arg_0)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_storable()\n";
	}
	auto ret = mupdf::keep_storable(arg_0.m_internal);
	return ret;
}


/* Wrapper for `fz_keep_store_context()`.  */
FZ_FUNCTION fz_store *mfz_keep_store_context()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_store_context()\n";
	}
	auto ret = mupdf::keep_store_context();
	return ret;
}


/* Wrapper for `fz_keep_stream()`.  */
FZ_FUNCTION Stream mfz_keep_stream(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_stream()\n";
	}
	fz_stream* temp = mupdf::keep_stream(stm.m_internal);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_keep_stroke_state()`.  */
FZ_FUNCTION StrokeState mfz_keep_stroke_state(const StrokeState& stroke)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_stroke_state()\n";
	}
	fz_stroke_state* temp = mupdf::keep_stroke_state(stroke.m_internal);
	auto ret = StrokeState(temp);
	return ret;
}


/* Wrapper for `fz_keep_text()`.  */
FZ_FUNCTION Text mfz_keep_text(const Text& text)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::keep_text()\n";
	}
	fz_text* temp = mupdf::keep_text(text.m_internal);
	auto ret = Text(temp);
	return ret;
}


/* Wrapper for `fz_koi8u_from_unicode()`.  */
FZ_FUNCTION int mfz_koi8u_from_unicode(int u)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::koi8u_from_unicode()\n";
	}
	auto ret = mupdf::koi8u_from_unicode(u);
	return ret;
}


/* Wrapper for `fz_last_page()`.  */
FZ_FUNCTION Location mfz_last_page(const Document& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::last_page()\n";
	}
	fz_location temp = mupdf::last_page(doc.m_internal);
	auto ret = Location(&temp);
	return ret;
}


/* Wrapper for `fz_layout_document()`.  */
FZ_FUNCTION void mfz_layout_document(const Document& doc, float w, float h, float em)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::layout_document()\n";
	}
	mupdf::layout_document(doc.m_internal, w, h, em);
}


/* Wrapper for `fz_lineto()`.  */
FZ_FUNCTION void mfz_lineto(const Path& path, float x, float y)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::lineto()\n";
	}
	mupdf::lineto(path.m_internal, x, y);
}


/* Wrapper for `fz_list_archive_entry()`.  */
FZ_FUNCTION const char *mfz_list_archive_entry(const Archive& arch, int idx)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::list_archive_entry()\n";
	}
	auto ret = mupdf::list_archive_entry(arch.m_internal, idx);
	return ret;
}


/* Wrapper for `fz_load_bmp_subimage()`.  */
FZ_FUNCTION Pixmap mfz_load_bmp_subimage(const unsigned char *buf, size_t len, int subimage)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_bmp_subimage()\n";
	}
	fz_pixmap* temp = mupdf::load_bmp_subimage(buf, len, subimage);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_load_bmp_subimage_count()`.  */
FZ_FUNCTION int mfz_load_bmp_subimage_count(const unsigned char *buf, size_t len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_bmp_subimage_count()\n";
	}
	auto ret = mupdf::load_bmp_subimage_count(buf, len);
	return ret;
}


/* Wrapper for `fz_load_chapter_page()`.  */
FZ_FUNCTION Page mfz_load_chapter_page(const Document& doc, int chapter, int page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_chapter_page()\n";
	}
	fz_page* temp = mupdf::load_chapter_page(doc.m_internal, chapter, page);
	auto ret = Page(temp);
	return ret;
}


/* Wrapper for `fz_load_fallback_font()`.  */
FZ_FUNCTION Font mfz_load_fallback_font(int script, int language, int serif, int bold, int italic)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_fallback_font()\n";
	}
	fz_font* temp = mupdf::load_fallback_font(script, language, serif, bold, italic);
	auto ret = Font(temp);
	return ret;
}


/* Wrapper for `fz_load_jbig2_globals()`.  */
FZ_FUNCTION Jbig2Globals mfz_load_jbig2_globals(const Buffer& buf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_jbig2_globals()\n";
	}
	fz_jbig2_globals* temp = mupdf::load_jbig2_globals(buf.m_internal);
	auto ret = Jbig2Globals(temp);
	return ret;
}


/* Wrapper for `fz_load_jbig2_subimage()`.  */
FZ_FUNCTION Pixmap mfz_load_jbig2_subimage(const unsigned char *buf, size_t len, int subimage)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_jbig2_subimage()\n";
	}
	fz_pixmap* temp = mupdf::load_jbig2_subimage(buf, len, subimage);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_load_jbig2_subimage_count()`.  */
FZ_FUNCTION int mfz_load_jbig2_subimage_count(const unsigned char *buf, size_t len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_jbig2_subimage_count()\n";
	}
	auto ret = mupdf::load_jbig2_subimage_count(buf, len);
	return ret;
}


/* Wrapper for `fz_load_jpx()`.  */
FZ_FUNCTION Pixmap mfz_load_jpx(const unsigned char *data, size_t size, const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_jpx()\n";
	}
	fz_pixmap* temp = mupdf::load_jpx(data, size, cs.m_internal);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_load_links()`.  */
FZ_FUNCTION Link mfz_load_links(const Page& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_links()\n";
	}
	fz_link* temp = mupdf::load_links(page.m_internal);
	auto ret = Link(temp);
	return ret;
}


/* Wrapper for `fz_load_outline()`.  */
FZ_FUNCTION Outline mfz_load_outline(const Document& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_outline()\n";
	}
	fz_outline* temp = mupdf::load_outline(doc.m_internal);
	auto ret = Outline(temp);
	return ret;
}


/* Wrapper for `fz_load_outline_from_iterator()`.  */
FZ_FUNCTION Outline mfz_load_outline_from_iterator(const OutlineIterator& iter)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_outline_from_iterator()\n";
	}
	fz_outline* temp = mupdf::load_outline_from_iterator(iter.m_internal);
	auto ret = Outline(temp);
	return ret;
}


/* Wrapper for `fz_load_page()`.  */
FZ_FUNCTION Page mfz_load_page(const Document& doc, int number)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_page()\n";
	}
	fz_page* temp = mupdf::load_page(doc.m_internal, number);
	auto ret = Page(temp);
	return ret;
}


/* Wrapper for `fz_load_pnm_subimage()`.  */
FZ_FUNCTION Pixmap mfz_load_pnm_subimage(const unsigned char *buf, size_t len, int subimage)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_pnm_subimage()\n";
	}
	fz_pixmap* temp = mupdf::load_pnm_subimage(buf, len, subimage);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_load_pnm_subimage_count()`.  */
FZ_FUNCTION int mfz_load_pnm_subimage_count(const unsigned char *buf, size_t len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_pnm_subimage_count()\n";
	}
	auto ret = mupdf::load_pnm_subimage_count(buf, len);
	return ret;
}


/* Wrapper for `fz_load_system_cjk_font()`.  */
FZ_FUNCTION Font mfz_load_system_cjk_font(const char *name, int ordering, int serif)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_system_cjk_font()\n";
	}
	fz_font* temp = mupdf::load_system_cjk_font(name, ordering, serif);
	auto ret = Font(temp);
	return ret;
}


/* Wrapper for `fz_load_system_font()`.  */
FZ_FUNCTION Font mfz_load_system_font(const char *name, int bold, int italic, int needs_exact_metrics)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_system_font()\n";
	}
	fz_font* temp = mupdf::load_system_font(name, bold, italic, needs_exact_metrics);
	auto ret = Font(temp);
	return ret;
}


/* Wrapper for `fz_load_tiff_subimage()`.  */
FZ_FUNCTION Pixmap mfz_load_tiff_subimage(const unsigned char *buf, size_t len, int subimage)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_tiff_subimage()\n";
	}
	fz_pixmap* temp = mupdf::load_tiff_subimage(buf, len, subimage);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_load_tiff_subimage_count()`.  */
FZ_FUNCTION int mfz_load_tiff_subimage_count(const unsigned char *buf, size_t len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_tiff_subimage_count()\n";
	}
	auto ret = mupdf::load_tiff_subimage_count(buf, len);
	return ret;
}


/* Wrapper for `fz_location_from_page_number()`.  */
FZ_FUNCTION Location mfz_location_from_page_number(const Document& doc, int number)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::location_from_page_number()\n";
	}
	fz_location temp = mupdf::location_from_page_number(doc.m_internal, number);
	auto ret = Location(&temp);
	return ret;
}


/* Wrapper for `fz_lock()`.  */
FZ_FUNCTION void mfz_lock(int lock)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::lock()\n";
	}
	mupdf::lock(lock);
}


/* Wrapper for `fz_lookup_base14_font()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_lookup_base14_font(const char *name)` => `(const unsigned char *, int len)`
	 */
FZ_FUNCTION const unsigned char *mfz_lookup_base14_font(const char *name, int *len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::lookup_base14_font()\n";
	}
	auto ret = mupdf::lookup_base14_font(name, len);
	return ret;
}


/* Wrapper for `fz_lookup_blendmode()`.  */
FZ_FUNCTION int mfz_lookup_blendmode(const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::lookup_blendmode()\n";
	}
	auto ret = mupdf::lookup_blendmode(name);
	return ret;
}


/* Wrapper for `fz_lookup_bookmark()`.  */
FZ_FUNCTION Location mfz_lookup_bookmark(const Document& doc, fz_bookmark mark)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::lookup_bookmark()\n";
	}
	fz_location temp = mupdf::lookup_bookmark(doc.m_internal, mark);
	auto ret = Location(&temp);
	return ret;
}


/* Wrapper for `fz_lookup_builtin_font()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_lookup_builtin_font(const char *name, int bold, int italic)` => `(const unsigned char *, int len)`
	 */
FZ_FUNCTION const unsigned char *mfz_lookup_builtin_font(const char *name, int bold, int italic, int *len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::lookup_builtin_font()\n";
	}
	auto ret = mupdf::lookup_builtin_font(name, bold, italic, len);
	return ret;
}


/* Wrapper for `fz_lookup_cjk_font()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_lookup_cjk_font(int ordering)` => `(const unsigned char *, int len, int index)`
	 */
FZ_FUNCTION const unsigned char *mfz_lookup_cjk_font(int ordering, int *len, int *index)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::lookup_cjk_font()\n";
	}
	auto ret = mupdf::lookup_cjk_font(ordering, len, index);
	return ret;
}


/* Wrapper for `fz_lookup_cjk_font_by_language()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_lookup_cjk_font_by_language(const char *lang)` => `(const unsigned char *, int len, int subfont)`
	 */
FZ_FUNCTION const unsigned char *mfz_lookup_cjk_font_by_language(const char *lang, int *len, int *subfont)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::lookup_cjk_font_by_language()\n";
	}
	auto ret = mupdf::lookup_cjk_font_by_language(lang, len, subfont);
	return ret;
}


/* Wrapper for `fz_lookup_cjk_ordering_by_language()`.  */
FZ_FUNCTION int mfz_lookup_cjk_ordering_by_language(const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::lookup_cjk_ordering_by_language()\n";
	}
	auto ret = mupdf::lookup_cjk_ordering_by_language(name);
	return ret;
}


/* Wrapper for `fz_lookup_metadata()`.  */
FZ_FUNCTION int mfz_lookup_metadata(const Document& doc, const char *key, char *buf, int size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::lookup_metadata()\n";
	}
	auto ret = mupdf::lookup_metadata(doc.m_internal, key, buf, size);
	return ret;
}


/* Wrapper for `fz_lookup_noto_emoji_font()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_lookup_noto_emoji_font()` => `(const unsigned char *, int len)`
	 */
FZ_FUNCTION const unsigned char *mfz_lookup_noto_emoji_font(int *len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::lookup_noto_emoji_font()\n";
	}
	auto ret = mupdf::lookup_noto_emoji_font(len);
	return ret;
}


/* Wrapper for `fz_lookup_noto_font()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_lookup_noto_font(int script, int lang)` => `(const unsigned char *, int len, int subfont)`
	 */
FZ_FUNCTION const unsigned char *mfz_lookup_noto_font(int script, int lang, int *len, int *subfont)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::lookup_noto_font()\n";
	}
	auto ret = mupdf::lookup_noto_font(script, lang, len, subfont);
	return ret;
}


/* Wrapper for `fz_lookup_noto_math_font()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_lookup_noto_math_font()` => `(const unsigned char *, int len)`
	 */
FZ_FUNCTION const unsigned char *mfz_lookup_noto_math_font(int *len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::lookup_noto_math_font()\n";
	}
	auto ret = mupdf::lookup_noto_math_font(len);
	return ret;
}


/* Wrapper for `fz_lookup_noto_music_font()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_lookup_noto_music_font()` => `(const unsigned char *, int len)`
	 */
FZ_FUNCTION const unsigned char *mfz_lookup_noto_music_font(int *len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::lookup_noto_music_font()\n";
	}
	auto ret = mupdf::lookup_noto_music_font(len);
	return ret;
}


/* Wrapper for `fz_lookup_noto_symbol1_font()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_lookup_noto_symbol1_font()` => `(const unsigned char *, int len)`
	 */
FZ_FUNCTION const unsigned char *mfz_lookup_noto_symbol1_font(int *len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::lookup_noto_symbol1_font()\n";
	}
	auto ret = mupdf::lookup_noto_symbol1_font(len);
	return ret;
}


/* Wrapper for `fz_lookup_noto_symbol2_font()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_lookup_noto_symbol2_font()` => `(const unsigned char *, int len)`
	 */
FZ_FUNCTION const unsigned char *mfz_lookup_noto_symbol2_font(int *len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::lookup_noto_symbol2_font()\n";
	}
	auto ret = mupdf::lookup_noto_symbol2_font(len);
	return ret;
}


/* Wrapper for `fz_lookup_rendering_intent()`.  */
FZ_FUNCTION int mfz_lookup_rendering_intent(const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::lookup_rendering_intent()\n";
	}
	auto ret = mupdf::lookup_rendering_intent(name);
	return ret;
}


/* Wrapper for `fz_make_bookmark()`.  */
FZ_FUNCTION fz_bookmark mfz_make_bookmark(const Document& doc, Location& loc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::make_bookmark()\n";
	}
	auto ret = mupdf::make_bookmark(doc.m_internal, *(fz_location*) &loc.chapter);
	return ret;
}


/* Wrapper for `fz_make_irect()`.  */
FZ_FUNCTION Irect mfz_make_irect(int x0, int y0, int x1, int y1)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::make_irect()\n";
	}
	fz_irect temp = mupdf::make_irect(x0, y0, x1, y1);
	auto ret = Irect(&temp);
	return ret;
}


/* Wrapper for `fz_make_location()`.  */
FZ_FUNCTION Location mfz_make_location(int chapter, int page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::make_location()\n";
	}
	fz_location temp = mupdf::make_location(chapter, page);
	auto ret = Location(&temp);
	return ret;
}


/* Wrapper for `fz_make_matrix()`.  */
FZ_FUNCTION Matrix mfz_make_matrix(float a, float b, float c, float d, float e, float f)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::make_matrix()\n";
	}
	fz_matrix temp = mupdf::make_matrix(a, b, c, d, e, f);
	auto ret = Matrix(&temp);
	return ret;
}


/* Wrapper for `fz_make_point()`.  */
FZ_FUNCTION Point mfz_make_point(float x, float y)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::make_point()\n";
	}
	fz_point temp = mupdf::make_point(x, y);
	auto ret = Point(&temp);
	return ret;
}


/* Wrapper for `fz_make_quad()`.  */
FZ_FUNCTION Quad mfz_make_quad(float ul_x, float ul_y, float ur_x, float ur_y, float ll_x, float ll_y, float lr_x, float lr_y)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::make_quad()\n";
	}
	fz_quad temp = mupdf::make_quad(ul_x, ul_y, ur_x, ur_y, ll_x, ll_y, lr_x, lr_y);
	auto ret = Quad(&temp);
	return ret;
}


/* Wrapper for `fz_make_rect()`.  */
FZ_FUNCTION Rect mfz_make_rect(float x0, float y0, float x1, float y1)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::make_rect()\n";
	}
	fz_rect temp = mupdf::make_rect(x0, y0, x1, y1);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `fz_malloc()`.  */
FZ_FUNCTION void *mfz_malloc(size_t size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::malloc()\n";
	}
	auto ret = mupdf::malloc(size);
	return ret;
}


/* Wrapper for `fz_malloc_no_throw()`.  */
FZ_FUNCTION void *mfz_malloc_no_throw(size_t size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::malloc_no_throw()\n";
	}
	auto ret = mupdf::malloc_no_throw(size);
	return ret;
}


/* Wrapper for `fz_matrix_expansion()`.  */
FZ_FUNCTION float mfz_matrix_expansion(Matrix& m)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::matrix_expansion()\n";
	}
	auto ret = mupdf::matrix_expansion(*(fz_matrix*) &m.a);
	return ret;
}


/* Wrapper for `fz_matrix_max_expansion()`.  */
FZ_FUNCTION float mfz_matrix_max_expansion(Matrix& m)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::matrix_max_expansion()\n";
	}
	auto ret = mupdf::matrix_max_expansion(*(fz_matrix*) &m.a);
	return ret;
}


/* Wrapper for `fz_max()`.  */
FZ_FUNCTION float mfz_max(float a, float b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::max()\n";
	}
	auto ret = mupdf::max(a, b);
	return ret;
}


/* Wrapper for `fz_maxi()`.  */
FZ_FUNCTION int mfz_maxi(int a, int b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::maxi()\n";
	}
	auto ret = mupdf::maxi(a, b);
	return ret;
}


/* Wrapper for `fz_maxi64()`.  */
FZ_FUNCTION int64_t mfz_maxi64(int64_t a, int64_t b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::maxi64()\n";
	}
	auto ret = mupdf::maxi64(a, b);
	return ret;
}


/* Wrapper for `fz_maxz()`.  */
FZ_FUNCTION size_t mfz_maxz(size_t a, size_t b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::maxz()\n";
	}
	auto ret = mupdf::maxz(a, b);
	return ret;
}


/* Wrapper for `fz_md5_buffer()`.  */
FZ_FUNCTION void mfz_md5_buffer(const Buffer& buffer, unsigned char digest[16])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::md5_buffer()\n";
	}
	mupdf::md5_buffer(buffer.m_internal, digest);
}


/* Wrapper for `fz_md5_final()`.  */
FZ_FUNCTION void mfz_md5_final(Md5& state, unsigned char digest[16])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::md5_final()\n";
	}
	mupdf::md5_final(&state.m_internal, digest);
}


/* Wrapper for `fz_md5_init()`.  */
FZ_FUNCTION void mfz_md5_init(Md5& state)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::md5_init()\n";
	}
	mupdf::md5_init(&state.m_internal);
}


/* Wrapper for `fz_md5_pixmap()`.  */
FZ_FUNCTION void mfz_md5_pixmap(const Pixmap& pixmap, unsigned char digest[16])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::md5_pixmap()\n";
	}
	mupdf::md5_pixmap(pixmap.m_internal, digest);
}


/* Wrapper for `fz_md5_update()`.  */
FZ_FUNCTION void mfz_md5_update(Md5& state, const unsigned char *input, size_t inlen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::md5_update()\n";
	}
	mupdf::md5_update(&state.m_internal, input, inlen);
}


/* Wrapper for `fz_md5_update_int64()`.  */
FZ_FUNCTION void mfz_md5_update_int64(Md5& state, int64_t i)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::md5_update_int64()\n";
	}
	mupdf::md5_update_int64(&state.m_internal, i);
}


/* Wrapper for `fz_measure_string()`.  */
FZ_FUNCTION Matrix mfz_measure_string(const Font& user_font, Matrix& trm, const char *s, int wmode, int bidi_level, fz_bidi_direction markup_dir, fz_text_language language)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::measure_string()\n";
	}
	fz_matrix temp = mupdf::measure_string(user_font.m_internal, *(fz_matrix*) &trm.a, s, wmode, bidi_level, markup_dir, language);
	auto ret = Matrix(&temp);
	return ret;
}


/* Wrapper for `fz_memmem()`.  */
FZ_FUNCTION void *mfz_memmem(const void *haystack, size_t haystacklen, const void *needle, size_t needlelen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::memmem()\n";
	}
	auto ret = mupdf::memmem(haystack, haystacklen, needle, needlelen);
	return ret;
}


/* Wrapper for `fz_memrnd()`.  */
FZ_FUNCTION void mfz_memrnd(uint8_t *block, int len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::memrnd()\n";
	}
	mupdf::memrnd(block, len);
}


/* Wrapper for `fz_min()`.  */
FZ_FUNCTION float mfz_min(float a, float b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::min()\n";
	}
	auto ret = mupdf::min(a, b);
	return ret;
}


/* Wrapper for `fz_mini()`.  */
FZ_FUNCTION int mfz_mini(int a, int b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::mini()\n";
	}
	auto ret = mupdf::mini(a, b);
	return ret;
}


/* Wrapper for `fz_mini64()`.  */
FZ_FUNCTION int64_t mfz_mini64(int64_t a, int64_t b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::mini64()\n";
	}
	auto ret = mupdf::mini64(a, b);
	return ret;
}


/* Wrapper for `fz_minz()`.  */
FZ_FUNCTION size_t mfz_minz(size_t a, size_t b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::minz()\n";
	}
	auto ret = mupdf::minz(a, b);
	return ret;
}


/* Wrapper for `fz_moveto()`.  */
FZ_FUNCTION void mfz_moveto(const Path& path, float x, float y)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::moveto()\n";
	}
	mupdf::moveto(path.m_internal, x, y);
}


/* Wrapper for `fz_mul255()`.  */
FZ_FUNCTION int mfz_mul255(int a, int b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::mul255()\n";
	}
	auto ret = mupdf::mul255(a, b);
	return ret;
}


/* Wrapper for `fz_needs_password()`.  */
FZ_FUNCTION int mfz_needs_password(const Document& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::needs_password()\n";
	}
	auto ret = mupdf::needs_password(doc.m_internal);
	return ret;
}


/* Wrapper for `fz_new_arc4_output()`.  */
FZ_FUNCTION fz_output *mfz_new_arc4_output(const Output& chain, unsigned char *key, size_t keylen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_arc4_output()\n";
	}
	auto ret = mupdf::new_arc4_output(chain.m_internal, key, keylen);
	return ret;
}


/* Wrapper for `fz_new_archive_of_size()`.  */
FZ_FUNCTION fz_archive *mfz_new_archive_of_size(const Stream& file, int size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_archive_of_size()\n";
	}
	auto ret = mupdf::new_archive_of_size(file.m_internal, size);
	return ret;
}


/* Wrapper for `fz_new_ascii85_output()`.  */
FZ_FUNCTION fz_output *mfz_new_ascii85_output(const Output& chain)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_ascii85_output()\n";
	}
	auto ret = mupdf::new_ascii85_output(chain.m_internal);
	return ret;
}


/* Wrapper for `fz_new_asciihex_output()`.  */
FZ_FUNCTION fz_output *mfz_new_asciihex_output(const Output& chain)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_asciihex_output()\n";
	}
	auto ret = mupdf::new_asciihex_output(chain.m_internal);
	return ret;
}


/* Wrapper for `fz_new_band_writer_of_size()`.  */
FZ_FUNCTION fz_band_writer *mfz_new_band_writer_of_size(size_t size, const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_band_writer_of_size()\n";
	}
	auto ret = mupdf::new_band_writer_of_size(size, out.m_internal);
	return ret;
}


/* Wrapper for `fz_new_base14_font()`.  */
FZ_FUNCTION Font mfz_new_base14_font(const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_base14_font()\n";
	}
	fz_font* temp = mupdf::new_base14_font(name);
	auto ret = Font(temp);
	return ret;
}


/* Wrapper for `fz_new_bbox_device()`.  */
FZ_FUNCTION Device mfz_new_bbox_device(Rect& rectp)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_bbox_device()\n";
	}
	fz_device* temp = mupdf::new_bbox_device((fz_rect *) &rectp.x0);
	auto ret = Device(temp);
	return ret;
}


/* Wrapper for `fz_new_bitmap()`.  */
FZ_FUNCTION Bitmap mfz_new_bitmap(int w, int h, int n, int xres, int yres)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_bitmap()\n";
	}
	fz_bitmap* temp = mupdf::new_bitmap(w, h, n, xres, yres);
	auto ret = Bitmap(temp);
	return ret;
}


/* Wrapper for `fz_new_bitmap_from_pixmap()`.  */
FZ_FUNCTION Bitmap mfz_new_bitmap_from_pixmap(const Pixmap& pix, const Halftone& ht)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_bitmap_from_pixmap()\n";
	}
	fz_bitmap* temp = mupdf::new_bitmap_from_pixmap(pix.m_internal, ht.m_internal);
	auto ret = Bitmap(temp);
	return ret;
}


/* Wrapper for `fz_new_bitmap_from_pixmap_band()`.  */
FZ_FUNCTION Bitmap mfz_new_bitmap_from_pixmap_band(const Pixmap& pix, const Halftone& ht, int band_start)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_bitmap_from_pixmap_band()\n";
	}
	fz_bitmap* temp = mupdf::new_bitmap_from_pixmap_band(pix.m_internal, ht.m_internal, band_start);
	auto ret = Bitmap(temp);
	return ret;
}


/* Wrapper for `fz_new_buffer()`.  */
FZ_FUNCTION Buffer mfz_new_buffer(size_t capacity)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer()\n";
	}
	fz_buffer* temp = mupdf::new_buffer(capacity);
	auto ret = Buffer(temp);
	return ret;
}


/* Wrapper for `fz_new_buffer_from_base64()`.  */
FZ_FUNCTION Buffer mfz_new_buffer_from_base64(const char *data, size_t size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_base64()\n";
	}
	fz_buffer* temp = mupdf::new_buffer_from_base64(data, size);
	auto ret = Buffer(temp);
	return ret;
}


/* Wrapper for `fz_new_buffer_from_copied_data()`.  */
FZ_FUNCTION Buffer mfz_new_buffer_from_copied_data(const unsigned char *data, size_t size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_copied_data()\n";
	}
	fz_buffer* temp = mupdf::new_buffer_from_copied_data(data, size);
	auto ret = Buffer(temp);
	return ret;
}


/* Wrapper for `fz_new_buffer_from_data()`.  */
FZ_FUNCTION Buffer mfz_new_buffer_from_data(unsigned char *data, size_t size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_data()\n";
	}
	fz_buffer* temp = mupdf::new_buffer_from_data(data, size);
	auto ret = Buffer(temp);
	return ret;
}


/* Wrapper for `fz_new_buffer_from_display_list()`.  */
FZ_FUNCTION Buffer mfz_new_buffer_from_display_list(const DisplayList& list, StextOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_display_list()\n";
	}
	fz_buffer* temp = mupdf::new_buffer_from_display_list(list.m_internal, (const fz_stext_options *) &options.flags);
	auto ret = Buffer(temp);
	return ret;
}


/* Wrapper for `fz_new_buffer_from_image_as_png()`.  */
FZ_FUNCTION Buffer mfz_new_buffer_from_image_as_png(const Image& image, ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_image_as_png()\n";
	}
	fz_buffer* temp = mupdf::new_buffer_from_image_as_png(image.m_internal, *(fz_color_params*) &color_params.ri);
	auto ret = Buffer(temp);
	return ret;
}


/* Wrapper for `fz_new_buffer_from_page()`.  */
FZ_FUNCTION Buffer mfz_new_buffer_from_page(const Page& page, StextOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_page()\n";
	}
	fz_buffer* temp = mupdf::new_buffer_from_page(page.m_internal, (const fz_stext_options *) &options.flags);
	auto ret = Buffer(temp);
	return ret;
}


/* Wrapper for `fz_new_buffer_from_page_number()`.  */
FZ_FUNCTION Buffer mfz_new_buffer_from_page_number(const Document& doc, int number, StextOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_page_number()\n";
	}
	fz_buffer* temp = mupdf::new_buffer_from_page_number(doc.m_internal, number, (const fz_stext_options *) &options.flags);
	auto ret = Buffer(temp);
	return ret;
}


/* Wrapper for `fz_new_buffer_from_page_with_format()`.  */
FZ_FUNCTION Buffer mfz_new_buffer_from_page_with_format(const Page& page, const char *format, const char *options, Matrix& transform, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_page_with_format()\n";
	}
	fz_buffer* temp = mupdf::new_buffer_from_page_with_format(page.m_internal, format, options, *(fz_matrix*) &transform.a, &cookie.m_internal);
	auto ret = Buffer(temp);
	return ret;
}


/* Wrapper for `fz_new_buffer_from_pixmap_as_png()`.  */
FZ_FUNCTION Buffer mfz_new_buffer_from_pixmap_as_png(const Pixmap& pixmap, ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_pixmap_as_png()\n";
	}
	fz_buffer* temp = mupdf::new_buffer_from_pixmap_as_png(pixmap.m_internal, *(fz_color_params*) &color_params.ri);
	auto ret = Buffer(temp);
	return ret;
}


/* Wrapper for `fz_new_buffer_from_shared_data()`.  */
FZ_FUNCTION Buffer mfz_new_buffer_from_shared_data(const unsigned char *data, size_t size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_shared_data()\n";
	}
	fz_buffer* temp = mupdf::new_buffer_from_shared_data(data, size);
	auto ret = Buffer(temp);
	return ret;
}


/* Wrapper for `fz_new_buffer_from_stext_page()`.  */
FZ_FUNCTION Buffer mfz_new_buffer_from_stext_page(const StextPage& text)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_stext_page()\n";
	}
	fz_buffer* temp = mupdf::new_buffer_from_stext_page(text.m_internal);
	auto ret = Buffer(temp);
	return ret;
}


/* Wrapper for `fz_new_builtin_font()`.  */
FZ_FUNCTION Font mfz_new_builtin_font(const char *name, int is_bold, int is_italic)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_builtin_font()\n";
	}
	fz_font* temp = mupdf::new_builtin_font(name, is_bold, is_italic);
	auto ret = Font(temp);
	return ret;
}


/* Wrapper for `fz_new_cal_gray_colorspace()`.  */
FZ_FUNCTION Colorspace mfz_new_cal_gray_colorspace(float wp[3], float bp[3], float gamma)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_cal_gray_colorspace()\n";
	}
	fz_colorspace* temp = mupdf::new_cal_gray_colorspace(wp, bp, gamma);
	auto ret = Colorspace(temp);
	return ret;
}


/* Wrapper for `fz_new_cal_rgb_colorspace()`.  */
FZ_FUNCTION Colorspace mfz_new_cal_rgb_colorspace(float wp[3], float bp[3], float gamma[3], float matrix[9])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_cal_rgb_colorspace()\n";
	}
	fz_colorspace* temp = mupdf::new_cal_rgb_colorspace(wp, bp, gamma, matrix);
	auto ret = Colorspace(temp);
	return ret;
}


/* Wrapper for `fz_new_cbz_writer()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_cbz_writer(const char *path, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_cbz_writer()\n";
	}
	auto ret = mupdf::new_cbz_writer(path, options);
	return ret;
}


/* Wrapper for `fz_new_cbz_writer_with_output()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_cbz_writer_with_output(const Output& out, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_cbz_writer_with_output()\n";
	}
	auto ret = mupdf::new_cbz_writer_with_output(out.m_internal, options);
	return ret;
}


/* Wrapper for `fz_new_cjk_font()`.  */
FZ_FUNCTION Font mfz_new_cjk_font(int ordering)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_cjk_font()\n";
	}
	fz_font* temp = mupdf::new_cjk_font(ordering);
	auto ret = Font(temp);
	return ret;
}


/* Wrapper for `fz_new_color_pcl_band_writer()`.  */
FZ_FUNCTION fz_band_writer *mfz_new_color_pcl_band_writer(const Output& out, const PclOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_color_pcl_band_writer()\n";
	}
	auto ret = mupdf::new_color_pcl_band_writer(out.m_internal, options.m_internal);
	return ret;
}


/* Wrapper for `fz_new_colorspace()`.  */
FZ_FUNCTION Colorspace mfz_new_colorspace(enum fz_colorspace_type type, int flags, int n, const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_colorspace()\n";
	}
	fz_colorspace* temp = mupdf::new_colorspace(type, flags, n, name);
	auto ret = Colorspace(temp);
	return ret;
}


/* Wrapper for `fz_new_context_imp()`.  */
FZ_FUNCTION fz_context *mfz_new_context_imp(const AllocContext& alloc, const LocksContext& locks, size_t max_store, const char *version)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_context_imp()\n";
	}
	auto ret = mupdf::new_context_imp(alloc.m_internal, locks.m_internal, max_store, version);
	return ret;
}


/* Wrapper for `fz_new_default_colorspaces()`.  */
FZ_FUNCTION DefaultColorspaces mfz_new_default_colorspaces()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_default_colorspaces()\n";
	}
	fz_default_colorspaces* temp = mupdf::new_default_colorspaces();
	auto ret = DefaultColorspaces(temp);
	return ret;
}


/* Wrapper for `fz_new_deflate_output()`.  */
FZ_FUNCTION fz_output *mfz_new_deflate_output(const Output& chain, int effort, int raw)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_deflate_output()\n";
	}
	auto ret = mupdf::new_deflate_output(chain.m_internal, effort, raw);
	return ret;
}


/* Wrapper for `fz_new_deflated_data()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_new_deflated_data(const unsigned char *source, size_t source_length, fz_deflate_level level)` => `(unsigned char *, size_t compressed_length)`
	 */
FZ_FUNCTION unsigned char *mfz_new_deflated_data(size_t *compressed_length, const unsigned char *source, size_t source_length, fz_deflate_level level)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_deflated_data()\n";
	}
	auto ret = mupdf::new_deflated_data(compressed_length, source, source_length, level);
	return ret;
}


/* Wrapper for `fz_new_deflated_data_from_buffer()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_new_deflated_data_from_buffer(fz_buffer *buffer, fz_deflate_level level)` => `(unsigned char *, size_t compressed_length)`
	 */
FZ_FUNCTION unsigned char *mfz_new_deflated_data_from_buffer(size_t *compressed_length, const Buffer& buffer, fz_deflate_level level)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_deflated_data_from_buffer()\n";
	}
	auto ret = mupdf::new_deflated_data_from_buffer(compressed_length, buffer.m_internal, level);
	return ret;
}


/* Wrapper for `fz_new_device_of_size()`.  */
FZ_FUNCTION Device mfz_new_device_of_size(int size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_device_of_size()\n";
	}
	fz_device* temp = mupdf::new_device_of_size(size);
	auto ret = Device(temp);
	return ret;
}


/* Wrapper for `fz_new_display_list()`.  */
FZ_FUNCTION DisplayList mfz_new_display_list(Rect& mediabox)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_display_list()\n";
	}
	fz_display_list* temp = mupdf::new_display_list(*(fz_rect*) &mediabox.x0);
	auto ret = DisplayList(temp);
	return ret;
}


/* Wrapper for `fz_new_display_list_from_page()`.  */
FZ_FUNCTION DisplayList mfz_new_display_list_from_page(const Page& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_display_list_from_page()\n";
	}
	fz_display_list* temp = mupdf::new_display_list_from_page(page.m_internal);
	auto ret = DisplayList(temp);
	return ret;
}


/* Wrapper for `fz_new_display_list_from_page_contents()`.  */
FZ_FUNCTION DisplayList mfz_new_display_list_from_page_contents(const Page& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_display_list_from_page_contents()\n";
	}
	fz_display_list* temp = mupdf::new_display_list_from_page_contents(page.m_internal);
	auto ret = DisplayList(temp);
	return ret;
}


/* Wrapper for `fz_new_display_list_from_page_number()`.  */
FZ_FUNCTION DisplayList mfz_new_display_list_from_page_number(const Document& doc, int number)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_display_list_from_page_number()\n";
	}
	fz_display_list* temp = mupdf::new_display_list_from_page_number(doc.m_internal, number);
	auto ret = DisplayList(temp);
	return ret;
}


/* Wrapper for `fz_new_display_list_from_svg()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_new_display_list_from_svg(fz_buffer *buf, const char *base_uri, fz_archive *zip)` => `(fz_display_list *, float w, float h)`
	 */
FZ_FUNCTION DisplayList mfz_new_display_list_from_svg(const Buffer& buf, const char *base_uri, const Archive& zip, float *w, float *h)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_display_list_from_svg()\n";
	}
	fz_display_list* temp = mupdf::new_display_list_from_svg(buf.m_internal, base_uri, zip.m_internal, w, h);
	auto ret = DisplayList(temp);
	return ret;
}


/* Wrapper for `fz_new_display_list_from_svg_xml()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_new_display_list_from_svg_xml(fz_xml_doc *xmldoc, fz_xml *xml, const char *base_uri, fz_archive *zip)` => `(fz_display_list *, float w, float h)`
	 */
FZ_FUNCTION DisplayList mfz_new_display_list_from_svg_xml(const XmlDoc& xmldoc, const Xml& xml, const char *base_uri, const Archive& zip, float *w, float *h)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_display_list_from_svg_xml()\n";
	}
	fz_display_list* temp = mupdf::new_display_list_from_svg_xml(xmldoc.m_internal, xml.m_internal, base_uri, zip.m_internal, w, h);
	auto ret = DisplayList(temp);
	return ret;
}


/* Wrapper for `fz_new_document_of_size()`.  */
FZ_FUNCTION void *mfz_new_document_of_size(int size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_document_of_size()\n";
	}
	auto ret = mupdf::new_document_of_size(size);
	return ret;
}


/* Wrapper for `fz_new_document_writer()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_document_writer(const char *path, const char *format, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_document_writer()\n";
	}
	auto ret = mupdf::new_document_writer(path, format, options);
	return ret;
}


/* Wrapper for `fz_new_document_writer_of_size()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_document_writer_of_size(size_t size, fz_document_writer_begin_page_fn *begin_page, fz_document_writer_end_page_fn *end_page, fz_document_writer_close_writer_fn *close, fz_document_writer_drop_writer_fn *drop)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_document_writer_of_size()\n";
	}
	auto ret = mupdf::new_document_writer_of_size(size, begin_page, end_page, close, drop);
	return ret;
}


/* Wrapper for `fz_new_document_writer_with_output()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_document_writer_with_output(const Output& out, const char *format, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_document_writer_with_output()\n";
	}
	auto ret = mupdf::new_document_writer_with_output(out.m_internal, format, options);
	return ret;
}


/* Wrapper for `fz_new_docx_writer()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_docx_writer(const char *path, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_docx_writer()\n";
	}
	auto ret = mupdf::new_docx_writer(path, options);
	return ret;
}


/* Wrapper for `fz_new_docx_writer_with_output()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_docx_writer_with_output(const Output& out, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_docx_writer_with_output()\n";
	}
	auto ret = mupdf::new_docx_writer_with_output(out.m_internal, options);
	return ret;
}


/* Wrapper for `fz_new_draw_device()`.  */
FZ_FUNCTION Device mfz_new_draw_device(Matrix& transform, const Pixmap& dest)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_draw_device()\n";
	}
	fz_device* temp = mupdf::new_draw_device(*(fz_matrix*) &transform.a, dest.m_internal);
	auto ret = Device(temp);
	return ret;
}


/* Wrapper for `fz_new_draw_device_type3()`.  */
FZ_FUNCTION Device mfz_new_draw_device_type3(Matrix& transform, const Pixmap& dest)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_draw_device_type3()\n";
	}
	fz_device* temp = mupdf::new_draw_device_type3(*(fz_matrix*) &transform.a, dest.m_internal);
	auto ret = Device(temp);
	return ret;
}


/* Wrapper for `fz_new_draw_device_with_bbox()`.  */
FZ_FUNCTION Device mfz_new_draw_device_with_bbox(Matrix& transform, const Pixmap& dest, Irect& clip)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_draw_device_with_bbox()\n";
	}
	fz_device* temp = mupdf::new_draw_device_with_bbox(*(fz_matrix*) &transform.a, dest.m_internal, (const fz_irect *) &clip.x0);
	auto ret = Device(temp);
	return ret;
}


/* Wrapper for `fz_new_draw_device_with_bbox_proof()`.  */
FZ_FUNCTION Device mfz_new_draw_device_with_bbox_proof(Matrix& transform, const Pixmap& dest, Irect& clip, const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_draw_device_with_bbox_proof()\n";
	}
	fz_device* temp = mupdf::new_draw_device_with_bbox_proof(*(fz_matrix*) &transform.a, dest.m_internal, (const fz_irect *) &clip.x0, cs.m_internal);
	auto ret = Device(temp);
	return ret;
}


/* Wrapper for `fz_new_draw_device_with_options()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_new_draw_device_with_options(const fz_draw_options *options, fz_rect mediabox, fz_pixmap **pixmap)` => `(fz_device *)`
	 */
FZ_FUNCTION Device mfz_new_draw_device_with_options(DrawOptions& options, Rect& mediabox, Pixmap& pixmap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_draw_device_with_options()\n";
	}
	/* Out-param pixmap.m_internal will be overwritten. */
	drop_pixmap(pixmap.m_internal);
	pixmap.m_internal = nullptr;
	fz_device* temp = mupdf::new_draw_device_with_options((const fz_draw_options *) &options.rotate, *(fz_rect*) &mediabox.x0, &pixmap.m_internal);
	auto ret = Device(temp);
	/* We assume that out-param pixmap.m_internal is a borrowed reference. */
	keep_pixmap(pixmap.m_internal);
	return ret;
}


/* Wrapper for `fz_new_draw_device_with_proof()`.  */
FZ_FUNCTION Device mfz_new_draw_device_with_proof(Matrix& transform, const Pixmap& dest, const Colorspace& proof_cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_draw_device_with_proof()\n";
	}
	fz_device* temp = mupdf::new_draw_device_with_proof(*(fz_matrix*) &transform.a, dest.m_internal, proof_cs.m_internal);
	auto ret = Device(temp);
	return ret;
}


/* Wrapper for `fz_new_font_from_buffer()`.  */
FZ_FUNCTION Font mfz_new_font_from_buffer(const char *name, const Buffer& buffer, int index, int use_glyph_bbox)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_font_from_buffer()\n";
	}
	fz_font* temp = mupdf::new_font_from_buffer(name, buffer.m_internal, index, use_glyph_bbox);
	auto ret = Font(temp);
	return ret;
}


/* Wrapper for `fz_new_font_from_file()`.  */
FZ_FUNCTION Font mfz_new_font_from_file(const char *name, const char *path, int index, int use_glyph_bbox)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_font_from_file()\n";
	}
	fz_font* temp = mupdf::new_font_from_file(name, path, index, use_glyph_bbox);
	auto ret = Font(temp);
	return ret;
}


/* Wrapper for `fz_new_font_from_memory()`.  */
FZ_FUNCTION Font mfz_new_font_from_memory(const char *name, const unsigned char *data, int len, int index, int use_glyph_bbox)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_font_from_memory()\n";
	}
	fz_font* temp = mupdf::new_font_from_memory(name, data, len, index, use_glyph_bbox);
	auto ret = Font(temp);
	return ret;
}


/* Wrapper for `fz_new_hash_table()`.  */
FZ_FUNCTION fz_hash_table *mfz_new_hash_table(int initialsize, int keylen, int lock, fz_hash_table_drop_fn *drop_val)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_hash_table()\n";
	}
	auto ret = mupdf::new_hash_table(initialsize, keylen, lock, drop_val);
	return ret;
}


/* Wrapper for `fz_new_icc_colorspace()`.  */
FZ_FUNCTION Colorspace mfz_new_icc_colorspace(enum fz_colorspace_type type, int flags, const char *name, const Buffer& buf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_icc_colorspace()\n";
	}
	fz_colorspace* temp = mupdf::new_icc_colorspace(type, flags, name, buf.m_internal);
	auto ret = Colorspace(temp);
	return ret;
}


/* Wrapper for `fz_new_image_from_buffer()`.  */
FZ_FUNCTION Image mfz_new_image_from_buffer(const Buffer& buffer)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_image_from_buffer()\n";
	}
	fz_image* temp = mupdf::new_image_from_buffer(buffer.m_internal);
	auto ret = Image(temp);
	return ret;
}


/* Wrapper for `fz_new_image_from_compressed_buffer()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_new_image_from_compressed_buffer(int w, int h, int bpc, fz_colorspace *colorspace, int xres, int yres, int interpolate, int imagemask, fz_compressed_buffer *buffer, fz_image *mask)` => `(fz_image *, float decode, int colorkey)`
	 */
FZ_FUNCTION Image mfz_new_image_from_compressed_buffer(int w, int h, int bpc, const Colorspace& colorspace, int xres, int yres, int interpolate, int imagemask, float *decode, int *colorkey, const CompressedBuffer& buffer, const Image& mask)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_image_from_compressed_buffer()\n";
	}
	fz_image* temp = mupdf::new_image_from_compressed_buffer(w, h, bpc, colorspace.m_internal, xres, yres, interpolate, imagemask, decode, colorkey, buffer.m_internal, mask.m_internal);
	auto ret = Image(temp);
	return ret;
}


/* Wrapper for `fz_new_image_from_display_list()`.  */
FZ_FUNCTION Image mfz_new_image_from_display_list(float w, float h, const DisplayList& list)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_image_from_display_list()\n";
	}
	fz_image* temp = mupdf::new_image_from_display_list(w, h, list.m_internal);
	auto ret = Image(temp);
	return ret;
}


/* Wrapper for `fz_new_image_from_file()`.  */
FZ_FUNCTION Image mfz_new_image_from_file(const char *path)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_image_from_file()\n";
	}
	fz_image* temp = mupdf::new_image_from_file(path);
	auto ret = Image(temp);
	return ret;
}


/* Wrapper for `fz_new_image_from_pixmap()`.  */
FZ_FUNCTION Image mfz_new_image_from_pixmap(const Pixmap& pixmap, const Image& mask)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_image_from_pixmap()\n";
	}
	fz_image* temp = mupdf::new_image_from_pixmap(pixmap.m_internal, mask.m_internal);
	auto ret = Image(temp);
	return ret;
}


/* Wrapper for `fz_new_image_from_svg()`.  */
FZ_FUNCTION Image mfz_new_image_from_svg(const Buffer& buf, const char *base_uri, const Archive& zip)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_image_from_svg()\n";
	}
	fz_image* temp = mupdf::new_image_from_svg(buf.m_internal, base_uri, zip.m_internal);
	auto ret = Image(temp);
	return ret;
}


/* Wrapper for `fz_new_image_from_svg_xml()`.  */
FZ_FUNCTION Image mfz_new_image_from_svg_xml(const XmlDoc& xmldoc, const Xml& xml, const char *base_uri, const Archive& zip)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_image_from_svg_xml()\n";
	}
	fz_image* temp = mupdf::new_image_from_svg_xml(xmldoc.m_internal, xml.m_internal, base_uri, zip.m_internal);
	auto ret = Image(temp);
	return ret;
}


/* Wrapper for `fz_new_image_of_size()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_new_image_of_size(int w, int h, int bpc, fz_colorspace *colorspace, int xres, int yres, int interpolate, int imagemask, fz_image *mask, size_t size, fz_image_get_pixmap_fn *get_pixmap, fz_image_get_size_fn *get_size, fz_drop_image_fn *drop)` => `(fz_image *, float decode, int colorkey)`
	 */
FZ_FUNCTION Image mfz_new_image_of_size(int w, int h, int bpc, const Colorspace& colorspace, int xres, int yres, int interpolate, int imagemask, float *decode, int *colorkey, const Image& mask, size_t size, fz_image_get_pixmap_fn *get_pixmap, fz_image_get_size_fn *get_size, fz_drop_image_fn *drop)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_image_of_size()\n";
	}
	fz_image* temp = mupdf::new_image_of_size(w, h, bpc, colorspace.m_internal, xres, yres, interpolate, imagemask, decode, colorkey, mask.m_internal, size, get_pixmap, get_size, drop);
	auto ret = Image(temp);
	return ret;
}


/* Wrapper for `fz_new_indexed_colorspace()`.  */
FZ_FUNCTION Colorspace mfz_new_indexed_colorspace(const Colorspace& base, int high, unsigned char *lookup)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_indexed_colorspace()\n";
	}
	fz_colorspace* temp = mupdf::new_indexed_colorspace(base.m_internal, high, lookup);
	auto ret = Colorspace(temp);
	return ret;
}


/* Wrapper for `fz_new_layout()`.  */
FZ_FUNCTION fz_layout_block *mfz_new_layout()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_layout()\n";
	}
	auto ret = mupdf::new_layout();
	return ret;
}


/* Wrapper for `fz_new_link()`.  */
FZ_FUNCTION Link mfz_new_link(Rect& bbox, const char *uri)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_link()\n";
	}
	fz_link* temp = mupdf::new_link(*(fz_rect*) &bbox.x0, uri);
	auto ret = Link(temp);
	return ret;
}


/* Wrapper for `fz_new_list_device()`.  */
FZ_FUNCTION Device mfz_new_list_device(const DisplayList& list)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_list_device()\n";
	}
	fz_device* temp = mupdf::new_list_device(list.m_internal);
	auto ret = Device(temp);
	return ret;
}


/* Wrapper for `fz_new_log_for_module()`.  */
FZ_FUNCTION fz_output *mfz_new_log_for_module(const char *module)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_log_for_module()\n";
	}
	auto ret = mupdf::new_log_for_module(module);
	return ret;
}


/* Wrapper for `fz_new_mono_pcl_band_writer()`.  */
FZ_FUNCTION fz_band_writer *mfz_new_mono_pcl_band_writer(const Output& out, const PclOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_mono_pcl_band_writer()\n";
	}
	auto ret = mupdf::new_mono_pcl_band_writer(out.m_internal, options.m_internal);
	return ret;
}


/* Wrapper for `fz_new_mono_pwg_band_writer()`.  */
FZ_FUNCTION fz_band_writer *mfz_new_mono_pwg_band_writer(const Output& out, PwgOptions& pwg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_mono_pwg_band_writer()\n";
	}
	auto ret = mupdf::new_mono_pwg_band_writer(out.m_internal, &pwg.m_internal);
	return ret;
}


/* Wrapper for `fz_new_ocr_device()`.  */
FZ_FUNCTION Device mfz_new_ocr_device(const Device& target, Matrix& ctm, Rect& mediabox, int with_list, const char *language, const char *datadir, int (*progress)(fz_context *, void *, int ), void *progress_arg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_ocr_device()\n";
	}
	fz_device* temp = mupdf::new_ocr_device(target.m_internal, *(fz_matrix*) &ctm.a, *(fz_rect*) &mediabox.x0, with_list, language, datadir, progress, progress_arg);
	auto ret = Device(temp);
	return ret;
}


/* Wrapper for `fz_new_odt_writer()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_odt_writer(const char *path, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_odt_writer()\n";
	}
	auto ret = mupdf::new_odt_writer(path, options);
	return ret;
}


/* Wrapper for `fz_new_odt_writer_with_output()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_odt_writer_with_output(const Output& out, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_odt_writer_with_output()\n";
	}
	auto ret = mupdf::new_odt_writer_with_output(out.m_internal, options);
	return ret;
}


/* Wrapper for `fz_new_outline()`.  */
FZ_FUNCTION Outline mfz_new_outline()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_outline()\n";
	}
	fz_outline* temp = mupdf::new_outline();
	auto ret = Outline(temp);
	return ret;
}


/* Wrapper for `fz_new_outline_iterator()`.  */
FZ_FUNCTION fz_outline_iterator *mfz_new_outline_iterator(const Document& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_outline_iterator()\n";
	}
	auto ret = mupdf::new_outline_iterator(doc.m_internal);
	return ret;
}


/* Wrapper for `fz_new_outline_iterator_of_size()`.  */
FZ_FUNCTION fz_outline_iterator *mfz_new_outline_iterator_of_size(size_t size, const Document& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_outline_iterator_of_size()\n";
	}
	auto ret = mupdf::new_outline_iterator_of_size(size, doc.m_internal);
	return ret;
}


/* Wrapper for `fz_new_output()`.  */
FZ_FUNCTION fz_output *mfz_new_output(int bufsiz, void *state, fz_output_write_fn *write, fz_output_close_fn *close, fz_output_drop_fn *drop)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_output()\n";
	}
	auto ret = mupdf::new_output(bufsiz, state, write, close, drop);
	return ret;
}


/* Wrapper for `fz_new_output_with_buffer()`.  */
FZ_FUNCTION fz_output *mfz_new_output_with_buffer(const Buffer& buf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_output_with_buffer()\n";
	}
	auto ret = mupdf::new_output_with_buffer(buf.m_internal);
	return ret;
}


/* Wrapper for `fz_new_output_with_path()`.  */
FZ_FUNCTION fz_output *mfz_new_output_with_path(const char *filename, int append)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_output_with_path()\n";
	}
	auto ret = mupdf::new_output_with_path(filename, append);
	return ret;
}


/* Wrapper for `fz_new_page_of_size()`.  */
FZ_FUNCTION Page mfz_new_page_of_size(int size, const Document& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_page_of_size()\n";
	}
	fz_page* temp = mupdf::new_page_of_size(size, doc.m_internal);
	auto ret = Page(temp);
	return ret;
}


/* Wrapper for `fz_new_pam_band_writer()`.  */
FZ_FUNCTION fz_band_writer *mfz_new_pam_band_writer(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pam_band_writer()\n";
	}
	auto ret = mupdf::new_pam_band_writer(out.m_internal);
	return ret;
}


/* Wrapper for `fz_new_pam_pixmap_writer()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_pam_pixmap_writer(const char *path, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pam_pixmap_writer()\n";
	}
	auto ret = mupdf::new_pam_pixmap_writer(path, options);
	return ret;
}


/* Wrapper for `fz_new_path()`.  */
FZ_FUNCTION Path mfz_new_path()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_path()\n";
	}
	fz_path* temp = mupdf::new_path();
	auto ret = Path(temp);
	return ret;
}


/* Wrapper for `fz_new_pbm_band_writer()`.  */
FZ_FUNCTION fz_band_writer *mfz_new_pbm_band_writer(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pbm_band_writer()\n";
	}
	auto ret = mupdf::new_pbm_band_writer(out.m_internal);
	return ret;
}


/* Wrapper for `fz_new_pbm_pixmap_writer()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_pbm_pixmap_writer(const char *path, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pbm_pixmap_writer()\n";
	}
	auto ret = mupdf::new_pbm_pixmap_writer(path, options);
	return ret;
}


/* Wrapper for `fz_new_pcl_writer()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_pcl_writer(const char *path, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pcl_writer()\n";
	}
	auto ret = mupdf::new_pcl_writer(path, options);
	return ret;
}


/* Wrapper for `fz_new_pcl_writer_with_output()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_pcl_writer_with_output(const Output& out, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pcl_writer_with_output()\n";
	}
	auto ret = mupdf::new_pcl_writer_with_output(out.m_internal, options);
	return ret;
}


/* Wrapper for `fz_new_pclm_band_writer()`.  */
FZ_FUNCTION fz_band_writer *mfz_new_pclm_band_writer(const Output& out, const PclmOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pclm_band_writer()\n";
	}
	auto ret = mupdf::new_pclm_band_writer(out.m_internal, options.m_internal);
	return ret;
}


/* Wrapper for `fz_new_pclm_writer()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_pclm_writer(const char *path, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pclm_writer()\n";
	}
	auto ret = mupdf::new_pclm_writer(path, options);
	return ret;
}


/* Wrapper for `fz_new_pclm_writer_with_output()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_pclm_writer_with_output(const Output& out, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pclm_writer_with_output()\n";
	}
	auto ret = mupdf::new_pclm_writer_with_output(out.m_internal, options);
	return ret;
}


/* Wrapper for `fz_new_pdf_writer()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_pdf_writer(const char *path, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pdf_writer()\n";
	}
	auto ret = mupdf::new_pdf_writer(path, options);
	return ret;
}


/* Wrapper for `fz_new_pdf_writer_with_output()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_pdf_writer_with_output(const Output& out, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pdf_writer_with_output()\n";
	}
	auto ret = mupdf::new_pdf_writer_with_output(out.m_internal, options);
	return ret;
}


/* Wrapper for `fz_new_pdfocr_band_writer()`.  */
FZ_FUNCTION fz_band_writer *mfz_new_pdfocr_band_writer(const Output& out, PdfocrOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pdfocr_band_writer()\n";
	}
	auto ret = mupdf::new_pdfocr_band_writer(out.m_internal, (const fz_pdfocr_options *) &options.compress);
	return ret;
}


/* Wrapper for `fz_new_pdfocr_writer()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_pdfocr_writer(const char *path, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pdfocr_writer()\n";
	}
	auto ret = mupdf::new_pdfocr_writer(path, options);
	return ret;
}


/* Wrapper for `fz_new_pdfocr_writer_with_output()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_pdfocr_writer_with_output(const Output& out, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pdfocr_writer_with_output()\n";
	}
	auto ret = mupdf::new_pdfocr_writer_with_output(out.m_internal, options);
	return ret;
}


/* Wrapper for `fz_new_pgm_pixmap_writer()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_pgm_pixmap_writer(const char *path, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pgm_pixmap_writer()\n";
	}
	auto ret = mupdf::new_pgm_pixmap_writer(path, options);
	return ret;
}


/* Wrapper for `fz_new_pixmap()`.  */
FZ_FUNCTION Pixmap mfz_new_pixmap(const Colorspace& cs, int w, int h, const Separations& seps, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap()\n";
	}
	fz_pixmap* temp = mupdf::new_pixmap(cs.m_internal, w, h, seps.m_internal, alpha);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_new_pixmap_from_alpha_channel()`.  */
FZ_FUNCTION Pixmap mfz_new_pixmap_from_alpha_channel(const Pixmap& src)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_alpha_channel()\n";
	}
	fz_pixmap* temp = mupdf::new_pixmap_from_alpha_channel(src.m_internal);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_new_pixmap_from_color_and_mask()`.  */
FZ_FUNCTION Pixmap mfz_new_pixmap_from_color_and_mask(const Pixmap& color, const Pixmap& mask)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_color_and_mask()\n";
	}
	fz_pixmap* temp = mupdf::new_pixmap_from_color_and_mask(color.m_internal, mask.m_internal);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_new_pixmap_from_display_list()`.  */
FZ_FUNCTION Pixmap mfz_new_pixmap_from_display_list(const DisplayList& list, Matrix& ctm, const Colorspace& cs, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_display_list()\n";
	}
	fz_pixmap* temp = mupdf::new_pixmap_from_display_list(list.m_internal, *(fz_matrix*) &ctm.a, cs.m_internal, alpha);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_new_pixmap_from_display_list_with_separations()`.  */
FZ_FUNCTION Pixmap mfz_new_pixmap_from_display_list_with_separations(const DisplayList& list, Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_display_list_with_separations()\n";
	}
	fz_pixmap* temp = mupdf::new_pixmap_from_display_list_with_separations(list.m_internal, *(fz_matrix*) &ctm.a, cs.m_internal, seps.m_internal, alpha);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_new_pixmap_from_page()`.  */
FZ_FUNCTION Pixmap mfz_new_pixmap_from_page(const Page& page, Matrix& ctm, const Colorspace& cs, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_page()\n";
	}
	fz_pixmap* temp = mupdf::new_pixmap_from_page(page.m_internal, *(fz_matrix*) &ctm.a, cs.m_internal, alpha);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_new_pixmap_from_page_contents()`.  */
FZ_FUNCTION Pixmap mfz_new_pixmap_from_page_contents(const Page& page, Matrix& ctm, const Colorspace& cs, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_page_contents()\n";
	}
	fz_pixmap* temp = mupdf::new_pixmap_from_page_contents(page.m_internal, *(fz_matrix*) &ctm.a, cs.m_internal, alpha);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_new_pixmap_from_page_contents_with_separations()`.  */
FZ_FUNCTION Pixmap mfz_new_pixmap_from_page_contents_with_separations(const Page& page, Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_page_contents_with_separations()\n";
	}
	fz_pixmap* temp = mupdf::new_pixmap_from_page_contents_with_separations(page.m_internal, *(fz_matrix*) &ctm.a, cs.m_internal, seps.m_internal, alpha);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_new_pixmap_from_page_number()`.  */
FZ_FUNCTION Pixmap mfz_new_pixmap_from_page_number(const Document& doc, int number, Matrix& ctm, const Colorspace& cs, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_page_number()\n";
	}
	fz_pixmap* temp = mupdf::new_pixmap_from_page_number(doc.m_internal, number, *(fz_matrix*) &ctm.a, cs.m_internal, alpha);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_new_pixmap_from_page_number_with_separations()`.  */
FZ_FUNCTION Pixmap mfz_new_pixmap_from_page_number_with_separations(const Document& doc, int number, Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_page_number_with_separations()\n";
	}
	fz_pixmap* temp = mupdf::new_pixmap_from_page_number_with_separations(doc.m_internal, number, *(fz_matrix*) &ctm.a, cs.m_internal, seps.m_internal, alpha);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_new_pixmap_from_page_with_separations()`.  */
FZ_FUNCTION Pixmap mfz_new_pixmap_from_page_with_separations(const Page& page, Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_page_with_separations()\n";
	}
	fz_pixmap* temp = mupdf::new_pixmap_from_page_with_separations(page.m_internal, *(fz_matrix*) &ctm.a, cs.m_internal, seps.m_internal, alpha);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_new_pixmap_from_pixmap()`.  */
FZ_FUNCTION Pixmap mfz_new_pixmap_from_pixmap(const Pixmap& pixmap, Irect& rect)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_pixmap()\n";
	}
	fz_pixmap* temp = mupdf::new_pixmap_from_pixmap(pixmap.m_internal, (const fz_irect *) &rect.x0);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_new_pixmap_with_bbox()`.  */
FZ_FUNCTION Pixmap mfz_new_pixmap_with_bbox(const Colorspace& colorspace, Irect& bbox, const Separations& seps, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_with_bbox()\n";
	}
	fz_pixmap* temp = mupdf::new_pixmap_with_bbox(colorspace.m_internal, *(fz_irect*) &bbox.x0, seps.m_internal, alpha);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_new_pixmap_with_bbox_and_data()`.  */
FZ_FUNCTION Pixmap mfz_new_pixmap_with_bbox_and_data(const Colorspace& colorspace, Irect& rect, const Separations& seps, int alpha, unsigned char *samples)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_with_bbox_and_data()\n";
	}
	fz_pixmap* temp = mupdf::new_pixmap_with_bbox_and_data(colorspace.m_internal, *(fz_irect*) &rect.x0, seps.m_internal, alpha, samples);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_new_pixmap_with_data()`.  */
FZ_FUNCTION Pixmap mfz_new_pixmap_with_data(const Colorspace& colorspace, int w, int h, const Separations& seps, int alpha, int stride, unsigned char *samples)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_with_data()\n";
	}
	fz_pixmap* temp = mupdf::new_pixmap_with_data(colorspace.m_internal, w, h, seps.m_internal, alpha, stride, samples);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_new_pixmap_writer()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_pixmap_writer(const char *path, const char *options, const char *default_path, int n, void (*save)(fz_context *, fz_pixmap *, const char *))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_writer()\n";
	}
	auto ret = mupdf::new_pixmap_writer(path, options, default_path, n, save);
	return ret;
}


/* Wrapper for `fz_new_pkm_band_writer()`.  */
FZ_FUNCTION fz_band_writer *mfz_new_pkm_band_writer(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pkm_band_writer()\n";
	}
	auto ret = mupdf::new_pkm_band_writer(out.m_internal);
	return ret;
}


/* Wrapper for `fz_new_pkm_pixmap_writer()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_pkm_pixmap_writer(const char *path, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pkm_pixmap_writer()\n";
	}
	auto ret = mupdf::new_pkm_pixmap_writer(path, options);
	return ret;
}


/* Wrapper for `fz_new_png_band_writer()`.  */
FZ_FUNCTION fz_band_writer *mfz_new_png_band_writer(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_png_band_writer()\n";
	}
	auto ret = mupdf::new_png_band_writer(out.m_internal);
	return ret;
}


/* Wrapper for `fz_new_png_pixmap_writer()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_png_pixmap_writer(const char *path, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_png_pixmap_writer()\n";
	}
	auto ret = mupdf::new_png_pixmap_writer(path, options);
	return ret;
}


/* Wrapper for `fz_new_pnm_band_writer()`.  */
FZ_FUNCTION fz_band_writer *mfz_new_pnm_band_writer(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pnm_band_writer()\n";
	}
	auto ret = mupdf::new_pnm_band_writer(out.m_internal);
	return ret;
}


/* Wrapper for `fz_new_pnm_pixmap_writer()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_pnm_pixmap_writer(const char *path, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pnm_pixmap_writer()\n";
	}
	auto ret = mupdf::new_pnm_pixmap_writer(path, options);
	return ret;
}


/* Wrapper for `fz_new_pool()`.  */
FZ_FUNCTION fz_pool *mfz_new_pool()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pool()\n";
	}
	auto ret = mupdf::new_pool();
	return ret;
}


/* Wrapper for `fz_new_ppm_pixmap_writer()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_ppm_pixmap_writer(const char *path, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_ppm_pixmap_writer()\n";
	}
	auto ret = mupdf::new_ppm_pixmap_writer(path, options);
	return ret;
}


/* Wrapper for `fz_new_ps_band_writer()`.  */
FZ_FUNCTION fz_band_writer *mfz_new_ps_band_writer(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_ps_band_writer()\n";
	}
	auto ret = mupdf::new_ps_band_writer(out.m_internal);
	return ret;
}


/* Wrapper for `fz_new_ps_writer()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_ps_writer(const char *path, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_ps_writer()\n";
	}
	auto ret = mupdf::new_ps_writer(path, options);
	return ret;
}


/* Wrapper for `fz_new_ps_writer_with_output()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_ps_writer_with_output(const Output& out, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_ps_writer_with_output()\n";
	}
	auto ret = mupdf::new_ps_writer_with_output(out.m_internal, options);
	return ret;
}


/* Wrapper for `fz_new_psd_band_writer()`.  */
FZ_FUNCTION fz_band_writer *mfz_new_psd_band_writer(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_psd_band_writer()\n";
	}
	auto ret = mupdf::new_psd_band_writer(out.m_internal);
	return ret;
}


/* Wrapper for `fz_new_pwg_band_writer()`.  */
FZ_FUNCTION fz_band_writer *mfz_new_pwg_band_writer(const Output& out, PwgOptions& pwg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pwg_band_writer()\n";
	}
	auto ret = mupdf::new_pwg_band_writer(out.m_internal, &pwg.m_internal);
	return ret;
}


/* Wrapper for `fz_new_pwg_writer()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_pwg_writer(const char *path, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pwg_writer()\n";
	}
	auto ret = mupdf::new_pwg_writer(path, options);
	return ret;
}


/* Wrapper for `fz_new_pwg_writer_with_output()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_pwg_writer_with_output(const Output& out, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pwg_writer_with_output()\n";
	}
	auto ret = mupdf::new_pwg_writer_with_output(out.m_internal, options);
	return ret;
}


/* Wrapper for `fz_new_rle_output()`.  */
FZ_FUNCTION fz_output *mfz_new_rle_output(const Output& chain)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_rle_output()\n";
	}
	auto ret = mupdf::new_rle_output(chain.m_internal);
	return ret;
}


/* Wrapper for `fz_new_separations()`.  */
FZ_FUNCTION Separations mfz_new_separations(int controllable)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_separations()\n";
	}
	fz_separations* temp = mupdf::new_separations(controllable);
	auto ret = Separations(temp);
	return ret;
}


/* Wrapper for `fz_new_stext_device()`.  */
FZ_FUNCTION Device mfz_new_stext_device(const StextPage& page, StextOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_stext_device()\n";
	}
	fz_device* temp = mupdf::new_stext_device(page.m_internal, (const fz_stext_options *) &options.flags);
	auto ret = Device(temp);
	return ret;
}


/* Wrapper for `fz_new_stext_page()`.  */
FZ_FUNCTION fz_stext_page *mfz_new_stext_page(Rect& mediabox)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_stext_page()\n";
	}
	auto ret = mupdf::new_stext_page(*(fz_rect*) &mediabox.x0);
	return ret;
}


/* Wrapper for `fz_new_stext_page_from_chapter_page_number()`.  */
FZ_FUNCTION fz_stext_page *mfz_new_stext_page_from_chapter_page_number(const Document& doc, int chapter, int number, StextOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_stext_page_from_chapter_page_number()\n";
	}
	auto ret = mupdf::new_stext_page_from_chapter_page_number(doc.m_internal, chapter, number, (const fz_stext_options *) &options.flags);
	return ret;
}


/* Wrapper for `fz_new_stext_page_from_display_list()`.  */
FZ_FUNCTION fz_stext_page *mfz_new_stext_page_from_display_list(const DisplayList& list, StextOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_stext_page_from_display_list()\n";
	}
	auto ret = mupdf::new_stext_page_from_display_list(list.m_internal, (const fz_stext_options *) &options.flags);
	return ret;
}


/* Wrapper for `fz_new_stext_page_from_page()`.  */
FZ_FUNCTION fz_stext_page *mfz_new_stext_page_from_page(const Page& page, StextOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_stext_page_from_page()\n";
	}
	auto ret = mupdf::new_stext_page_from_page(page.m_internal, (const fz_stext_options *) &options.flags);
	return ret;
}


/* Wrapper for `fz_new_stext_page_from_page_number()`.  */
FZ_FUNCTION fz_stext_page *mfz_new_stext_page_from_page_number(const Document& doc, int number, StextOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_stext_page_from_page_number()\n";
	}
	auto ret = mupdf::new_stext_page_from_page_number(doc.m_internal, number, (const fz_stext_options *) &options.flags);
	return ret;
}


/* Wrapper for `fz_new_store_context()`.  */
FZ_FUNCTION void mfz_new_store_context(size_t max)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_store_context()\n";
	}
	mupdf::new_store_context(max);
}


/* Wrapper for `fz_new_stream()`.  */
FZ_FUNCTION Stream mfz_new_stream(void *state, fz_stream_next_fn *next, fz_stream_drop_fn *drop)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_stream()\n";
	}
	fz_stream* temp = mupdf::new_stream(state, next, drop);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_new_stroke_state()`.  */
FZ_FUNCTION StrokeState mfz_new_stroke_state()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_stroke_state()\n";
	}
	fz_stroke_state* temp = mupdf::new_stroke_state();
	auto ret = StrokeState(temp);
	return ret;
}


/* Wrapper for `fz_new_stroke_state_with_dash_len()`.  */
FZ_FUNCTION StrokeState mfz_new_stroke_state_with_dash_len(int len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_stroke_state_with_dash_len()\n";
	}
	fz_stroke_state* temp = mupdf::new_stroke_state_with_dash_len(len);
	auto ret = StrokeState(temp);
	return ret;
}


/* Wrapper for `fz_new_svg_device()`.  */
FZ_FUNCTION Device mfz_new_svg_device(const Output& out, float page_width, float page_height, int text_format, int reuse_images)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_svg_device()\n";
	}
	fz_device* temp = mupdf::new_svg_device(out.m_internal, page_width, page_height, text_format, reuse_images);
	auto ret = Device(temp);
	return ret;
}


/* Wrapper for `fz_new_svg_device_with_id()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_new_svg_device_with_id(fz_output *out, float page_width, float page_height, int text_format, int reuse_images)` => `(fz_device *, int id)`
	 */
FZ_FUNCTION Device mfz_new_svg_device_with_id(const Output& out, float page_width, float page_height, int text_format, int reuse_images, int *id)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_svg_device_with_id()\n";
	}
	fz_device* temp = mupdf::new_svg_device_with_id(out.m_internal, page_width, page_height, text_format, reuse_images, id);
	auto ret = Device(temp);
	return ret;
}


/* Wrapper for `fz_new_svg_writer()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_svg_writer(const char *path, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_svg_writer()\n";
	}
	auto ret = mupdf::new_svg_writer(path, options);
	return ret;
}


/* Wrapper for `fz_new_test_device()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_new_test_device(float threshold, int options, fz_device *passthrough)` => `(fz_device *, int is_color)`
	 */
FZ_FUNCTION Device mfz_new_test_device(int *is_color, float threshold, int options, const Device& passthrough)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_test_device()\n";
	}
	fz_device* temp = mupdf::new_test_device(is_color, threshold, options, passthrough.m_internal);
	auto ret = Device(temp);
	return ret;
}


/* Wrapper for `fz_new_text()`.  */
FZ_FUNCTION Text mfz_new_text()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_text()\n";
	}
	fz_text* temp = mupdf::new_text();
	auto ret = Text(temp);
	return ret;
}


/* Wrapper for `fz_new_text_writer()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_text_writer(const char *format, const char *path, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_text_writer()\n";
	}
	auto ret = mupdf::new_text_writer(format, path, options);
	return ret;
}


/* Wrapper for `fz_new_text_writer_with_output()`.  */
FZ_FUNCTION fz_document_writer *mfz_new_text_writer_with_output(const char *format, const Output& out, const char *options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_text_writer_with_output()\n";
	}
	auto ret = mupdf::new_text_writer_with_output(format, out.m_internal, options);
	return ret;
}


/* Wrapper for `fz_new_trace_device()`.  */
FZ_FUNCTION Device mfz_new_trace_device(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_trace_device()\n";
	}
	fz_device* temp = mupdf::new_trace_device(out.m_internal);
	auto ret = Device(temp);
	return ret;
}


/* Wrapper for `fz_new_type3_font()`.  */
FZ_FUNCTION Font mfz_new_type3_font(const char *name, Matrix& matrix)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_type3_font()\n";
	}
	fz_font* temp = mupdf::new_type3_font(name, *(fz_matrix*) &matrix.a);
	auto ret = Font(temp);
	return ret;
}


/* Wrapper for `fz_new_xhtml_document_from_document()`.  */
FZ_FUNCTION Document mfz_new_xhtml_document_from_document(const Document& old_doc, StextOptions& opts)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_xhtml_document_from_document()\n";
	}
	fz_document* temp = mupdf::new_xhtml_document_from_document(old_doc.m_internal, (const fz_stext_options *) &opts.flags);
	auto ret = Document(temp);
	return ret;
}


/* Wrapper for `fz_new_xmltext_device()`.  */
FZ_FUNCTION Device mfz_new_xmltext_device(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_xmltext_device()\n";
	}
	fz_device* temp = mupdf::new_xmltext_device(out.m_internal);
	auto ret = Device(temp);
	return ret;
}


/* Wrapper for `fz_new_zip_writer()`.  */
FZ_FUNCTION fz_zip_writer *mfz_new_zip_writer(const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_zip_writer()\n";
	}
	auto ret = mupdf::new_zip_writer(filename);
	return ret;
}


/* Wrapper for `fz_new_zip_writer_with_output()`.  */
FZ_FUNCTION fz_zip_writer *mfz_new_zip_writer_with_output(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_zip_writer_with_output()\n";
	}
	auto ret = mupdf::new_zip_writer_with_output(out.m_internal);
	return ret;
}


/* Wrapper for `fz_next_page()`.  */
FZ_FUNCTION Location mfz_next_page(const Document& doc, Location& loc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::next_page()\n";
	}
	fz_location temp = mupdf::next_page(doc.m_internal, *(fz_location*) &loc.chapter);
	auto ret = Location(&temp);
	return ret;
}


/* Wrapper for `fz_normalize_vector()`.  */
FZ_FUNCTION Point mfz_normalize_vector(Point& p)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::normalize_vector()\n";
	}
	fz_point temp = mupdf::normalize_vector(*(fz_point*) &p.x);
	auto ret = Point(&temp);
	return ret;
}


/* Wrapper for `fz_open_a85d()`.  */
FZ_FUNCTION Stream mfz_open_a85d(const Stream& chain)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_a85d()\n";
	}
	fz_stream* temp = mupdf::open_a85d(chain.m_internal);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_accelerated_document()`.  */
FZ_FUNCTION Document mfz_open_accelerated_document(const char *filename, const char *accel)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_accelerated_document()\n";
	}
	fz_document* temp = mupdf::open_accelerated_document(filename, accel);
	auto ret = Document(temp);
	return ret;
}


/* Wrapper for `fz_open_accelerated_document_with_stream()`.  */
FZ_FUNCTION Document mfz_open_accelerated_document_with_stream(const char *magic, const Stream& stream, const Stream& accel)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_accelerated_document_with_stream()\n";
	}
	fz_document* temp = mupdf::open_accelerated_document_with_stream(magic, stream.m_internal, accel.m_internal);
	auto ret = Document(temp);
	return ret;
}


/* Wrapper for `fz_open_aesd()`.  */
FZ_FUNCTION Stream mfz_open_aesd(const Stream& chain, unsigned char *key, unsigned int keylen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_aesd()\n";
	}
	fz_stream* temp = mupdf::open_aesd(chain.m_internal, key, keylen);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_ahxd()`.  */
FZ_FUNCTION Stream mfz_open_ahxd(const Stream& chain)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_ahxd()\n";
	}
	fz_stream* temp = mupdf::open_ahxd(chain.m_internal);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_arc4()`.  */
FZ_FUNCTION Stream mfz_open_arc4(const Stream& chain, unsigned char *key, unsigned int keylen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_arc4()\n";
	}
	fz_stream* temp = mupdf::open_arc4(chain.m_internal, key, keylen);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_archive()`.  */
FZ_FUNCTION fz_archive *mfz_open_archive(const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_archive()\n";
	}
	auto ret = mupdf::open_archive(filename);
	return ret;
}


/* Wrapper for `fz_open_archive_entry()`.  */
FZ_FUNCTION Stream mfz_open_archive_entry(const Archive& arch, const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_archive_entry()\n";
	}
	fz_stream* temp = mupdf::open_archive_entry(arch.m_internal, name);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_archive_with_stream()`.  */
FZ_FUNCTION fz_archive *mfz_open_archive_with_stream(const Stream& file)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_archive_with_stream()\n";
	}
	auto ret = mupdf::open_archive_with_stream(file.m_internal);
	return ret;
}


/* Wrapper for `fz_open_buffer()`.  */
FZ_FUNCTION Stream mfz_open_buffer(const Buffer& buf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_buffer()\n";
	}
	fz_stream* temp = mupdf::open_buffer(buf.m_internal);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_compressed_buffer()`.  */
FZ_FUNCTION Stream mfz_open_compressed_buffer(const CompressedBuffer& arg_0)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_compressed_buffer()\n";
	}
	fz_stream* temp = mupdf::open_compressed_buffer(arg_0.m_internal);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_concat()`.  */
FZ_FUNCTION Stream mfz_open_concat(int max, int pad)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_concat()\n";
	}
	fz_stream* temp = mupdf::open_concat(max, pad);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_dctd()`.  */
FZ_FUNCTION Stream mfz_open_dctd(const Stream& chain, int color_transform, int l2factor, const Stream& jpegtables)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_dctd()\n";
	}
	fz_stream* temp = mupdf::open_dctd(chain.m_internal, color_transform, l2factor, jpegtables.m_internal);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_directory()`.  */
FZ_FUNCTION fz_archive *mfz_open_directory(const char *path)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_directory()\n";
	}
	auto ret = mupdf::open_directory(path);
	return ret;
}


/* Wrapper for `fz_open_document()`.  */
FZ_FUNCTION Document mfz_open_document(const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_document()\n";
	}
	fz_document* temp = mupdf::open_document(filename);
	auto ret = Document(temp);
	return ret;
}


/* Wrapper for `fz_open_document_with_stream()`.  */
FZ_FUNCTION Document mfz_open_document_with_stream(const char *magic, const Stream& stream)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_document_with_stream()\n";
	}
	fz_document* temp = mupdf::open_document_with_stream(magic, stream.m_internal);
	auto ret = Document(temp);
	return ret;
}


/* Wrapper for `fz_open_endstream_filter()`.  */
FZ_FUNCTION Stream mfz_open_endstream_filter(const Stream& chain, uint64_t len, int64_t offset)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_endstream_filter()\n";
	}
	fz_stream* temp = mupdf::open_endstream_filter(chain.m_internal, len, offset);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_faxd()`.  */
FZ_FUNCTION Stream mfz_open_faxd(const Stream& chain, int k, int end_of_line, int encoded_byte_align, int columns, int rows, int end_of_block, int black_is_1)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_faxd()\n";
	}
	fz_stream* temp = mupdf::open_faxd(chain.m_internal, k, end_of_line, encoded_byte_align, columns, rows, end_of_block, black_is_1);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_file()`.  */
FZ_FUNCTION Stream mfz_open_file(const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_file()\n";
	}
	fz_stream* temp = mupdf::open_file(filename);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_file_ptr_no_close()`.  */
FZ_FUNCTION Stream mfz_open_file_ptr_no_close(FILE *file)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_file_ptr_no_close()\n";
	}
	fz_stream* temp = mupdf::open_file_ptr_no_close(file);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_flated()`.  */
FZ_FUNCTION Stream mfz_open_flated(const Stream& chain, int window_bits)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_flated()\n";
	}
	fz_stream* temp = mupdf::open_flated(chain.m_internal, window_bits);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_image_decomp_stream()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_open_image_decomp_stream(fz_stream *arg_0, fz_compression_params *arg_1)` => `(fz_stream *, int l2factor)`
	 */
FZ_FUNCTION Stream mfz_open_image_decomp_stream(const Stream& arg_0, const CompressionParams& arg_1, int *l2factor)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_image_decomp_stream()\n";
	}
	fz_stream* temp = mupdf::open_image_decomp_stream(arg_0.m_internal, arg_1.m_internal, l2factor);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_image_decomp_stream_from_buffer()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_open_image_decomp_stream_from_buffer(fz_compressed_buffer *arg_0)` => `(fz_stream *, int l2factor)`
	 */
FZ_FUNCTION Stream mfz_open_image_decomp_stream_from_buffer(const CompressedBuffer& arg_0, int *l2factor)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_image_decomp_stream_from_buffer()\n";
	}
	fz_stream* temp = mupdf::open_image_decomp_stream_from_buffer(arg_0.m_internal, l2factor);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_jbig2d()`.  */
FZ_FUNCTION Stream mfz_open_jbig2d(const Stream& chain, const Jbig2Globals& globals, int embedded)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_jbig2d()\n";
	}
	fz_stream* temp = mupdf::open_jbig2d(chain.m_internal, globals.m_internal, embedded);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_leecher()`.  */
FZ_FUNCTION Stream mfz_open_leecher(const Stream& chain, const Buffer& buf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_leecher()\n";
	}
	fz_stream* temp = mupdf::open_leecher(chain.m_internal, buf.m_internal);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_lzwd()`.  */
FZ_FUNCTION Stream mfz_open_lzwd(const Stream& chain, int early_change, int min_bits, int reverse_bits, int old_tiff)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_lzwd()\n";
	}
	fz_stream* temp = mupdf::open_lzwd(chain.m_internal, early_change, min_bits, reverse_bits, old_tiff);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_memory()`.  */
FZ_FUNCTION Stream mfz_open_memory(const unsigned char *data, size_t len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_memory()\n";
	}
	fz_stream* temp = mupdf::open_memory(data, len);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_null_filter()`.  */
FZ_FUNCTION Stream mfz_open_null_filter(const Stream& chain, uint64_t len, int64_t offset)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_null_filter()\n";
	}
	fz_stream* temp = mupdf::open_null_filter(chain.m_internal, len, offset);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_predict()`.  */
FZ_FUNCTION Stream mfz_open_predict(const Stream& chain, int predictor, int columns, int colors, int bpc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_predict()\n";
	}
	fz_stream* temp = mupdf::open_predict(chain.m_internal, predictor, columns, colors, bpc);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_range_filter()`.  */
FZ_FUNCTION Stream mfz_open_range_filter(const Stream& chain, const Range& ranges, int nranges)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_range_filter()\n";
	}
	fz_stream* temp = mupdf::open_range_filter(chain.m_internal, ranges.m_internal, nranges);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_reflowed_document()`.  */
FZ_FUNCTION Document mfz_open_reflowed_document(const Document& underdoc, StextOptions& opts)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_reflowed_document()\n";
	}
	fz_document* temp = mupdf::open_reflowed_document(underdoc.m_internal, (const fz_stext_options *) &opts.flags);
	auto ret = Document(temp);
	return ret;
}


/* Wrapper for `fz_open_rld()`.  */
FZ_FUNCTION Stream mfz_open_rld(const Stream& chain)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_rld()\n";
	}
	fz_stream* temp = mupdf::open_rld(chain.m_internal);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_sgilog16()`.  */
FZ_FUNCTION Stream mfz_open_sgilog16(const Stream& chain, int w)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_sgilog16()\n";
	}
	fz_stream* temp = mupdf::open_sgilog16(chain.m_internal, w);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_sgilog24()`.  */
FZ_FUNCTION Stream mfz_open_sgilog24(const Stream& chain, int w)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_sgilog24()\n";
	}
	fz_stream* temp = mupdf::open_sgilog24(chain.m_internal, w);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_sgilog32()`.  */
FZ_FUNCTION Stream mfz_open_sgilog32(const Stream& chain, int w)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_sgilog32()\n";
	}
	fz_stream* temp = mupdf::open_sgilog32(chain.m_internal, w);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_tar_archive()`.  */
FZ_FUNCTION fz_archive *mfz_open_tar_archive(const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_tar_archive()\n";
	}
	auto ret = mupdf::open_tar_archive(filename);
	return ret;
}


/* Wrapper for `fz_open_tar_archive_with_stream()`.  */
FZ_FUNCTION fz_archive *mfz_open_tar_archive_with_stream(const Stream& file)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_tar_archive_with_stream()\n";
	}
	auto ret = mupdf::open_tar_archive_with_stream(file.m_internal);
	return ret;
}


/* Wrapper for `fz_open_thunder()`.  */
FZ_FUNCTION Stream mfz_open_thunder(const Stream& chain, int w)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_thunder()\n";
	}
	fz_stream* temp = mupdf::open_thunder(chain.m_internal, w);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_open_zip_archive()`.  */
FZ_FUNCTION fz_archive *mfz_open_zip_archive(const char *path)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_zip_archive()\n";
	}
	auto ret = mupdf::open_zip_archive(path);
	return ret;
}


/* Wrapper for `fz_open_zip_archive_with_stream()`.  */
FZ_FUNCTION fz_archive *mfz_open_zip_archive_with_stream(const Stream& file)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_zip_archive_with_stream()\n";
	}
	auto ret = mupdf::open_zip_archive_with_stream(file.m_internal);
	return ret;
}


/* Wrapper for `fz_option_eq()`.  */
FZ_FUNCTION int mfz_option_eq(const char *a, const char *b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::option_eq()\n";
	}
	auto ret = mupdf::option_eq(a, b);
	return ret;
}


/* Wrapper for `fz_outline_glyph()`.  */
FZ_FUNCTION Path mfz_outline_glyph(const Font& font, int gid, Matrix& ctm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::outline_glyph()\n";
	}
	fz_path* temp = mupdf::outline_glyph(font.m_internal, gid, *(fz_matrix*) &ctm.a);
	mupdf::keep_path(temp);
	auto ret = Path(temp);
	return ret;
}


/* Wrapper for `fz_outline_iterator_delete()`.  */
FZ_FUNCTION int mfz_outline_iterator_delete(const OutlineIterator& iter)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::outline_iterator_delete()\n";
	}
	auto ret = mupdf::outline_iterator_delete(iter.m_internal);
	return ret;
}


/* Wrapper for `fz_outline_iterator_down()`.  */
FZ_FUNCTION int mfz_outline_iterator_down(const OutlineIterator& iter)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::outline_iterator_down()\n";
	}
	auto ret = mupdf::outline_iterator_down(iter.m_internal);
	return ret;
}


/* Wrapper for `fz_outline_iterator_from_outline()`.  */
FZ_FUNCTION fz_outline_iterator *mfz_outline_iterator_from_outline(const Outline& outline)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::outline_iterator_from_outline()\n";
	}
	auto ret = mupdf::outline_iterator_from_outline(outline.m_internal);
	return ret;
}


/* Wrapper for `fz_outline_iterator_item()`.  */
FZ_FUNCTION OutlineItem mfz_outline_iterator_item(const OutlineIterator& iter)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::outline_iterator_item()\n";
	}
	fz_outline_item* temp = mupdf::outline_iterator_item(iter.m_internal);
	auto ret = OutlineItem(temp);
	return ret;
}


/* Wrapper for `fz_outline_iterator_next()`.  */
FZ_FUNCTION int mfz_outline_iterator_next(const OutlineIterator& iter)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::outline_iterator_next()\n";
	}
	auto ret = mupdf::outline_iterator_next(iter.m_internal);
	return ret;
}


/* Wrapper for `fz_outline_iterator_prev()`.  */
FZ_FUNCTION int mfz_outline_iterator_prev(const OutlineIterator& iter)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::outline_iterator_prev()\n";
	}
	auto ret = mupdf::outline_iterator_prev(iter.m_internal);
	return ret;
}


/* Wrapper for `fz_outline_iterator_up()`.  */
FZ_FUNCTION int mfz_outline_iterator_up(const OutlineIterator& iter)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::outline_iterator_up()\n";
	}
	auto ret = mupdf::outline_iterator_up(iter.m_internal);
	return ret;
}


/* Wrapper for `fz_output_accelerator()`.  */
FZ_FUNCTION void mfz_output_accelerator(const Document& doc, const Output& accel)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::output_accelerator()\n";
	}
	mupdf::output_accelerator(doc.m_internal, accel.m_internal);
}


/* Wrapper for `fz_output_supports_stream()`.  */
FZ_FUNCTION int mfz_output_supports_stream(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::output_supports_stream()\n";
	}
	auto ret = mupdf::output_supports_stream(out.m_internal);
	return ret;
}


/* Wrapper for `fz_pack_path()`.  */
FZ_FUNCTION size_t mfz_pack_path(uint8_t *pack, size_t max, const Path& path)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pack_path()\n";
	}
	auto ret = mupdf::pack_path(pack, max, path.m_internal);
	return ret;
}


/* Wrapper for `fz_packed_path_size()`.  */
FZ_FUNCTION int mfz_packed_path_size(const Path& path)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::packed_path_size()\n";
	}
	auto ret = mupdf::packed_path_size(path.m_internal);
	return ret;
}


/* Wrapper for `fz_page_number_from_location()`.  */
FZ_FUNCTION int mfz_page_number_from_location(const Document& doc, Location& loc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::page_number_from_location()\n";
	}
	auto ret = mupdf::page_number_from_location(doc.m_internal, *(fz_location*) &loc.chapter);
	return ret;
}


/* Wrapper for `fz_page_presentation()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_page_presentation(fz_page *page, fz_transition *transition)` => `(fz_transition *, float duration)`
	 */
FZ_FUNCTION Transition mfz_page_presentation(const Page& page, Transition& transition, float *duration)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::page_presentation()\n";
	}
	fz_transition* temp = mupdf::page_presentation(page.m_internal, (fz_transition *) &transition.type, duration);
	auto ret = Transition(temp);
	return ret;
}


/* Wrapper for `fz_page_separations()`.  */
FZ_FUNCTION Separations mfz_page_separations(const Page& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::page_separations()\n";
	}
	fz_separations* temp = mupdf::page_separations(page.m_internal);
	mupdf::keep_separations(temp);
	auto ret = Separations(temp);
	return ret;
}


/* Wrapper for `fz_page_uses_overprint()`.  */
FZ_FUNCTION int mfz_page_uses_overprint(const Page& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::page_uses_overprint()\n";
	}
	auto ret = mupdf::page_uses_overprint(page.m_internal);
	return ret;
}


/* Wrapper for `fz_paint_shade()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_paint_shade(fz_shade *shade, fz_colorspace *override_cs, fz_matrix ctm, fz_pixmap *dest, fz_color_params color_params, fz_irect bbox, const fz_overprint *eop, fz_shade_color_cache **cache)` => 
	 */
FZ_FUNCTION void mfz_paint_shade(const Shade& shade, const Colorspace& override_cs, Matrix& ctm, const Pixmap& dest, ColorParams& color_params, Irect& bbox, const Overprint& eop, ShadeColorCache& cache)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::paint_shade()\n";
	}
	mupdf::paint_shade(shade.m_internal, override_cs.m_internal, *(fz_matrix*) &ctm.a, dest.m_internal, *(fz_color_params*) &color_params.ri, *(fz_irect*) &bbox.x0, eop.m_internal, &cache.m_internal);
}


/* Wrapper for `fz_parse_draw_options()`.  */
FZ_FUNCTION fz_draw_options *mfz_parse_draw_options(DrawOptions& options, const char *string)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::parse_draw_options()\n";
	}
	auto ret = mupdf::parse_draw_options((fz_draw_options *) &options.rotate, string);
	return ret;
}


/* Wrapper for `fz_parse_page_range()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_parse_page_range(const char *s, int n)` => `(const char *, int a, int b)`
	 */
FZ_FUNCTION const char *mfz_parse_page_range(const char *s, int *a, int *b, int n)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::parse_page_range()\n";
	}
	auto ret = mupdf::parse_page_range(s, a, b, n);
	return ret;
}


/* Wrapper for `fz_parse_pcl_options()`.  */
FZ_FUNCTION fz_pcl_options *mfz_parse_pcl_options(const PclOptions& opts, const char *args)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::parse_pcl_options()\n";
	}
	auto ret = mupdf::parse_pcl_options(opts.m_internal, args);
	return ret;
}


/* Wrapper for `fz_parse_pclm_options()`.  */
FZ_FUNCTION fz_pclm_options *mfz_parse_pclm_options(const PclmOptions& opts, const char *args)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::parse_pclm_options()\n";
	}
	auto ret = mupdf::parse_pclm_options(opts.m_internal, args);
	return ret;
}


/* Wrapper for `fz_parse_pdfocr_options()`.  */
FZ_FUNCTION PdfocrOptions mfz_parse_pdfocr_options(PdfocrOptions& opts, const char *args)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::parse_pdfocr_options()\n";
	}
	fz_pdfocr_options* temp = mupdf::parse_pdfocr_options((fz_pdfocr_options *) &opts.compress, args);
	auto ret = PdfocrOptions(temp);
	return ret;
}


/* Wrapper for `fz_parse_stext_options()`.  */
FZ_FUNCTION StextOptions mfz_parse_stext_options(StextOptions& opts, const char *string)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::parse_stext_options()\n";
	}
	fz_stext_options* temp = mupdf::parse_stext_options((fz_stext_options *) &opts.flags, string);
	auto ret = StextOptions(temp);
	return ret;
}


/* Wrapper for `fz_parse_xml()`.  */
FZ_FUNCTION fz_xml_doc *mfz_parse_xml(const Buffer& buf, int preserve_white)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::parse_xml()\n";
	}
	auto ret = mupdf::parse_xml(buf.m_internal, preserve_white);
	return ret;
}


/* Wrapper for `fz_parse_xml_from_html5()`.  */
FZ_FUNCTION fz_xml_doc *mfz_parse_xml_from_html5(const Buffer& buf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::parse_xml_from_html5()\n";
	}
	auto ret = mupdf::parse_xml_from_html5(buf.m_internal);
	return ret;
}


/* Wrapper for `fz_pcl_preset()`.  */
FZ_FUNCTION void mfz_pcl_preset(const PclOptions& opts, const char *preset)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pcl_preset()\n";
	}
	mupdf::pcl_preset(opts.m_internal, preset);
}


/* Wrapper for `fz_pdfocr_band_writer_set_progress()`.  */
FZ_FUNCTION void mfz_pdfocr_band_writer_set_progress(const BandWriter& writer, fz_pdfocr_progress_fn *progress_fn, void *progress_arg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pdfocr_band_writer_set_progress()\n";
	}
	mupdf::pdfocr_band_writer_set_progress(writer.m_internal, progress_fn, progress_arg);
}


/* Wrapper for `fz_pdfocr_writer_set_progress()`.  */
FZ_FUNCTION void mfz_pdfocr_writer_set_progress(const DocumentWriter& writer, fz_pdfocr_progress_fn *progress, void *arg_2)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pdfocr_writer_set_progress()\n";
	}
	mupdf::pdfocr_writer_set_progress(writer.m_internal, progress, arg_2);
}


/* Wrapper for `fz_peek_byte()`.  */
FZ_FUNCTION int mfz_peek_byte(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::peek_byte()\n";
	}
	auto ret = mupdf::peek_byte(stm.m_internal);
	return ret;
}


/* Wrapper for `fz_pixmap_alpha()`.  */
FZ_FUNCTION int mfz_pixmap_alpha(const Pixmap& pix)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pixmap_alpha()\n";
	}
	auto ret = mupdf::pixmap_alpha(pix.m_internal);
	return ret;
}


/* Wrapper for `fz_pixmap_bbox()`.  */
FZ_FUNCTION Irect mfz_pixmap_bbox(const Pixmap& pix)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pixmap_bbox()\n";
	}
	fz_irect temp = mupdf::pixmap_bbox(pix.m_internal);
	auto ret = Irect(&temp);
	return ret;
}


/* Wrapper for `fz_pixmap_colorants()`.  */
FZ_FUNCTION int mfz_pixmap_colorants(const Pixmap& pix)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pixmap_colorants()\n";
	}
	auto ret = mupdf::pixmap_colorants(pix.m_internal);
	return ret;
}


/* Wrapper for `fz_pixmap_colorspace()`.  */
FZ_FUNCTION Colorspace mfz_pixmap_colorspace(const Pixmap& pix)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pixmap_colorspace()\n";
	}
	fz_colorspace* temp = mupdf::pixmap_colorspace(pix.m_internal);
	mupdf::keep_colorspace(temp);
	auto ret = Colorspace(temp);
	return ret;
}


/* Wrapper for `fz_pixmap_components()`.  */
FZ_FUNCTION int mfz_pixmap_components(const Pixmap& pix)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pixmap_components()\n";
	}
	auto ret = mupdf::pixmap_components(pix.m_internal);
	return ret;
}


/* Wrapper for `fz_pixmap_height()`.  */
FZ_FUNCTION int mfz_pixmap_height(const Pixmap& pix)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pixmap_height()\n";
	}
	auto ret = mupdf::pixmap_height(pix.m_internal);
	return ret;
}


/* Wrapper for `fz_pixmap_image_tile()`.  */
FZ_FUNCTION Pixmap mfz_pixmap_image_tile(const PixmapImage& cimg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pixmap_image_tile()\n";
	}
	fz_pixmap* temp = mupdf::pixmap_image_tile(cimg.m_internal);
	mupdf::keep_pixmap(temp);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_pixmap_samples()`.  */
FZ_FUNCTION unsigned char *mfz_pixmap_samples(const Pixmap& pix)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pixmap_samples()\n";
	}
	auto ret = mupdf::pixmap_samples(pix.m_internal);
	return ret;
}


/* Wrapper for `fz_pixmap_spots()`.  */
FZ_FUNCTION int mfz_pixmap_spots(const Pixmap& pix)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pixmap_spots()\n";
	}
	auto ret = mupdf::pixmap_spots(pix.m_internal);
	return ret;
}


/* Wrapper for `fz_pixmap_stride()`.  */
FZ_FUNCTION int mfz_pixmap_stride(const Pixmap& pix)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pixmap_stride()\n";
	}
	auto ret = mupdf::pixmap_stride(pix.m_internal);
	return ret;
}


/* Wrapper for `fz_pixmap_width()`.  */
FZ_FUNCTION int mfz_pixmap_width(const Pixmap& pix)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pixmap_width()\n";
	}
	auto ret = mupdf::pixmap_width(pix.m_internal);
	return ret;
}


/* Wrapper for `fz_pixmap_x()`.  */
FZ_FUNCTION int mfz_pixmap_x(const Pixmap& pix)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pixmap_x()\n";
	}
	auto ret = mupdf::pixmap_x(pix.m_internal);
	return ret;
}


/* Wrapper for `fz_pixmap_y()`.  */
FZ_FUNCTION int mfz_pixmap_y(const Pixmap& pix)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pixmap_y()\n";
	}
	auto ret = mupdf::pixmap_y(pix.m_internal);
	return ret;
}


/* Wrapper for `fz_pool_alloc()`.  */
FZ_FUNCTION void *mfz_pool_alloc(const Pool& pool, size_t size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pool_alloc()\n";
	}
	auto ret = mupdf::pool_alloc(pool.m_internal, size);
	return ret;
}


/* Wrapper for `fz_pool_size()`.  */
FZ_FUNCTION size_t mfz_pool_size(const Pool& pool)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pool_size()\n";
	}
	auto ret = mupdf::pool_size(pool.m_internal);
	return ret;
}


/* Wrapper for `fz_pool_strdup()`.  */
FZ_FUNCTION char *mfz_pool_strdup(const Pool& pool, const char *s)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pool_strdup()\n";
	}
	auto ret = mupdf::pool_strdup(pool.m_internal, s);
	return ret;
}


/* Wrapper for `fz_pop_clip()`.  */
FZ_FUNCTION void mfz_pop_clip(const Device& dev)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pop_clip()\n";
	}
	mupdf::pop_clip(dev.m_internal);
}


/* Wrapper for `fz_post_scale()`.  */
FZ_FUNCTION Matrix mfz_post_scale(Matrix& m, float sx, float sy)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::post_scale()\n";
	}
	fz_matrix temp = mupdf::post_scale(*(fz_matrix*) &m.a, sx, sy);
	auto ret = Matrix(&temp);
	return ret;
}


/* Wrapper for `fz_pre_rotate()`.  */
FZ_FUNCTION Matrix mfz_pre_rotate(Matrix& m, float degrees)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pre_rotate()\n";
	}
	fz_matrix temp = mupdf::pre_rotate(*(fz_matrix*) &m.a, degrees);
	auto ret = Matrix(&temp);
	return ret;
}


/* Wrapper for `fz_pre_scale()`.  */
FZ_FUNCTION Matrix mfz_pre_scale(Matrix& m, float sx, float sy)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pre_scale()\n";
	}
	fz_matrix temp = mupdf::pre_scale(*(fz_matrix*) &m.a, sx, sy);
	auto ret = Matrix(&temp);
	return ret;
}


/* Wrapper for `fz_pre_shear()`.  */
FZ_FUNCTION Matrix mfz_pre_shear(Matrix& m, float sx, float sy)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pre_shear()\n";
	}
	fz_matrix temp = mupdf::pre_shear(*(fz_matrix*) &m.a, sx, sy);
	auto ret = Matrix(&temp);
	return ret;
}


/* Wrapper for `fz_pre_translate()`.  */
FZ_FUNCTION Matrix mfz_pre_translate(Matrix& m, float tx, float ty)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pre_translate()\n";
	}
	fz_matrix temp = mupdf::pre_translate(*(fz_matrix*) &m.a, tx, ty);
	auto ret = Matrix(&temp);
	return ret;
}


/* Wrapper for `fz_prepare_t3_glyph()`.  */
FZ_FUNCTION void mfz_prepare_t3_glyph(const Font& font, int gid)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::prepare_t3_glyph()\n";
	}
	mupdf::prepare_t3_glyph(font.m_internal, gid);
}


/* Wrapper for `fz_previous_page()`.  */
FZ_FUNCTION Location mfz_previous_page(const Document& doc, Location& loc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::previous_page()\n";
	}
	fz_location temp = mupdf::previous_page(doc.m_internal, *(fz_location*) &loc.chapter);
	auto ret = Location(&temp);
	return ret;
}


/* Wrapper for `fz_print_stext_header_as_html()`.  */
FZ_FUNCTION void mfz_print_stext_header_as_html(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::print_stext_header_as_html()\n";
	}
	mupdf::print_stext_header_as_html(out.m_internal);
}


/* Wrapper for `fz_print_stext_header_as_xhtml()`.  */
FZ_FUNCTION void mfz_print_stext_header_as_xhtml(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::print_stext_header_as_xhtml()\n";
	}
	mupdf::print_stext_header_as_xhtml(out.m_internal);
}


/* Wrapper for `fz_print_stext_page_as_html()`.  */
FZ_FUNCTION void mfz_print_stext_page_as_html(const Output& out, const StextPage& page, int id)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::print_stext_page_as_html()\n";
	}
	mupdf::print_stext_page_as_html(out.m_internal, page.m_internal, id);
}


/* Wrapper for `fz_print_stext_page_as_json()`.  */
FZ_FUNCTION void mfz_print_stext_page_as_json(const Output& out, const StextPage& page, float scale)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::print_stext_page_as_json()\n";
	}
	mupdf::print_stext_page_as_json(out.m_internal, page.m_internal, scale);
}


/* Wrapper for `fz_print_stext_page_as_text()`.  */
FZ_FUNCTION void mfz_print_stext_page_as_text(const Output& out, const StextPage& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::print_stext_page_as_text()\n";
	}
	mupdf::print_stext_page_as_text(out.m_internal, page.m_internal);
}


/* Wrapper for `fz_print_stext_page_as_xhtml()`.  */
FZ_FUNCTION void mfz_print_stext_page_as_xhtml(const Output& out, const StextPage& page, int id)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::print_stext_page_as_xhtml()\n";
	}
	mupdf::print_stext_page_as_xhtml(out.m_internal, page.m_internal, id);
}


/* Wrapper for `fz_print_stext_page_as_xml()`.  */
FZ_FUNCTION void mfz_print_stext_page_as_xml(const Output& out, const StextPage& page, int id)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::print_stext_page_as_xml()\n";
	}
	mupdf::print_stext_page_as_xml(out.m_internal, page.m_internal, id);
}


/* Wrapper for `fz_print_stext_trailer_as_html()`.  */
FZ_FUNCTION void mfz_print_stext_trailer_as_html(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::print_stext_trailer_as_html()\n";
	}
	mupdf::print_stext_trailer_as_html(out.m_internal);
}


/* Wrapper for `fz_print_stext_trailer_as_xhtml()`.  */
FZ_FUNCTION void mfz_print_stext_trailer_as_xhtml(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::print_stext_trailer_as_xhtml()\n";
	}
	mupdf::print_stext_trailer_as_xhtml(out.m_internal);
}


/* Wrapper for `fz_process_opened_pages()`.  */
FZ_FUNCTION void *mfz_process_opened_pages(const Document& doc, fz_process_opened_page_fn *process_openend_page, void *state)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::process_opened_pages()\n";
	}
	auto ret = mupdf::process_opened_pages(doc.m_internal, process_openend_page, state);
	return ret;
}


/* Wrapper for `fz_process_shade()`.  */
FZ_FUNCTION void mfz_process_shade(const Shade& shade, Matrix& ctm, Rect& scissor, fz_shade_prepare_fn *prepare, fz_shade_process_fn *process, void *process_arg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::process_shade()\n";
	}
	mupdf::process_shade(shade.m_internal, *(fz_matrix*) &ctm.a, *(fz_rect*) &scissor.x0, prepare, process, process_arg);
}


/* Wrapper for `fz_purge_glyph_cache()`.  */
FZ_FUNCTION void mfz_purge_glyph_cache()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::purge_glyph_cache()\n";
	}
	mupdf::purge_glyph_cache();
}


/* Wrapper for `fz_quad_from_rect()`.  */
FZ_FUNCTION Quad mfz_quad_from_rect(Rect& r)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::quad_from_rect()\n";
	}
	fz_quad temp = mupdf::quad_from_rect(*(fz_rect*) &r.x0);
	auto ret = Quad(&temp);
	return ret;
}


/* Wrapper for `fz_quadto()`.  */
FZ_FUNCTION void mfz_quadto(const Path& path, float x0, float y0, float x1, float y1)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::quadto()\n";
	}
	mupdf::quadto(path.m_internal, x0, y0, x1, y1);
}


/* Wrapper for `fz_read()`.  */
FZ_FUNCTION size_t mfz_read(const Stream& stm, unsigned char *data, size_t len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read()\n";
	}
	auto ret = mupdf::read(stm.m_internal, data, len);
	return ret;
}


/* Wrapper for `fz_read_all()`.  */
FZ_FUNCTION Buffer mfz_read_all(const Stream& stm, size_t initial)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_all()\n";
	}
	fz_buffer* temp = mupdf::read_all(stm.m_internal, initial);
	auto ret = Buffer(temp);
	return ret;
}


/* Wrapper for `fz_read_archive_entry()`.  */
FZ_FUNCTION Buffer mfz_read_archive_entry(const Archive& arch, const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_archive_entry()\n";
	}
	fz_buffer* temp = mupdf::read_archive_entry(arch.m_internal, name);
	auto ret = Buffer(temp);
	return ret;
}


/* Wrapper for `fz_read_best()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_read_best(fz_stream *stm, size_t initial)` => `(fz_buffer *, int truncated)`
	 */
FZ_FUNCTION Buffer mfz_read_best(const Stream& stm, size_t initial, int *truncated)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_best()\n";
	}
	fz_buffer* temp = mupdf::read_best(stm.m_internal, initial, truncated);
	auto ret = Buffer(temp);
	return ret;
}


/* Wrapper for `fz_read_bits()`.  */
FZ_FUNCTION unsigned int mfz_read_bits(const Stream& stm, int n)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_bits()\n";
	}
	auto ret = mupdf::read_bits(stm.m_internal, n);
	return ret;
}


/* Wrapper for `fz_read_byte()`.  */
FZ_FUNCTION int mfz_read_byte(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_byte()\n";
	}
	auto ret = mupdf::read_byte(stm.m_internal);
	return ret;
}


/* Wrapper for `fz_read_file()`.  */
FZ_FUNCTION Buffer mfz_read_file(const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_file()\n";
	}
	fz_buffer* temp = mupdf::read_file(filename);
	auto ret = Buffer(temp);
	return ret;
}


/* Wrapper for `fz_read_float()`.  */
FZ_FUNCTION float mfz_read_float(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_float()\n";
	}
	auto ret = mupdf::read_float(stm.m_internal);
	return ret;
}


/* Wrapper for `fz_read_float_le()`.  */
FZ_FUNCTION float mfz_read_float_le(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_float_le()\n";
	}
	auto ret = mupdf::read_float_le(stm.m_internal);
	return ret;
}


/* Wrapper for `fz_read_int16()`.  */
FZ_FUNCTION int16_t mfz_read_int16(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_int16()\n";
	}
	auto ret = mupdf::read_int16(stm.m_internal);
	return ret;
}


/* Wrapper for `fz_read_int16_le()`.  */
FZ_FUNCTION int16_t mfz_read_int16_le(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_int16_le()\n";
	}
	auto ret = mupdf::read_int16_le(stm.m_internal);
	return ret;
}


/* Wrapper for `fz_read_int32()`.  */
FZ_FUNCTION int32_t mfz_read_int32(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_int32()\n";
	}
	auto ret = mupdf::read_int32(stm.m_internal);
	return ret;
}


/* Wrapper for `fz_read_int32_le()`.  */
FZ_FUNCTION int32_t mfz_read_int32_le(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_int32_le()\n";
	}
	auto ret = mupdf::read_int32_le(stm.m_internal);
	return ret;
}


/* Wrapper for `fz_read_int64()`.  */
FZ_FUNCTION int64_t mfz_read_int64(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_int64()\n";
	}
	auto ret = mupdf::read_int64(stm.m_internal);
	return ret;
}


/* Wrapper for `fz_read_int64_le()`.  */
FZ_FUNCTION int64_t mfz_read_int64_le(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_int64_le()\n";
	}
	auto ret = mupdf::read_int64_le(stm.m_internal);
	return ret;
}


/* Wrapper for `fz_read_line()`.  */
FZ_FUNCTION char *mfz_read_line(const Stream& stm, char *buf, size_t max)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_line()\n";
	}
	auto ret = mupdf::read_line(stm.m_internal, buf, max);
	return ret;
}


/* Wrapper for `fz_read_rbits()`.  */
FZ_FUNCTION unsigned int mfz_read_rbits(const Stream& stm, int n)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_rbits()\n";
	}
	auto ret = mupdf::read_rbits(stm.m_internal, n);
	return ret;
}


/* Wrapper for `fz_read_string()`.  */
FZ_FUNCTION void mfz_read_string(const Stream& stm, char *buffer, int len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_string()\n";
	}
	mupdf::read_string(stm.m_internal, buffer, len);
}


/* Wrapper for `fz_read_uint16()`.  */
FZ_FUNCTION uint16_t mfz_read_uint16(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_uint16()\n";
	}
	auto ret = mupdf::read_uint16(stm.m_internal);
	return ret;
}


/* Wrapper for `fz_read_uint16_le()`.  */
FZ_FUNCTION uint16_t mfz_read_uint16_le(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_uint16_le()\n";
	}
	auto ret = mupdf::read_uint16_le(stm.m_internal);
	return ret;
}


/* Wrapper for `fz_read_uint24()`.  */
FZ_FUNCTION uint32_t mfz_read_uint24(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_uint24()\n";
	}
	auto ret = mupdf::read_uint24(stm.m_internal);
	return ret;
}


/* Wrapper for `fz_read_uint24_le()`.  */
FZ_FUNCTION uint32_t mfz_read_uint24_le(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_uint24_le()\n";
	}
	auto ret = mupdf::read_uint24_le(stm.m_internal);
	return ret;
}


/* Wrapper for `fz_read_uint32()`.  */
FZ_FUNCTION uint32_t mfz_read_uint32(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_uint32()\n";
	}
	auto ret = mupdf::read_uint32(stm.m_internal);
	return ret;
}


/* Wrapper for `fz_read_uint32_le()`.  */
FZ_FUNCTION uint32_t mfz_read_uint32_le(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_uint32_le()\n";
	}
	auto ret = mupdf::read_uint32_le(stm.m_internal);
	return ret;
}


/* Wrapper for `fz_read_uint64()`.  */
FZ_FUNCTION uint64_t mfz_read_uint64(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_uint64()\n";
	}
	auto ret = mupdf::read_uint64(stm.m_internal);
	return ret;
}


/* Wrapper for `fz_read_uint64_le()`.  */
FZ_FUNCTION uint64_t mfz_read_uint64_le(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_uint64_le()\n";
	}
	auto ret = mupdf::read_uint64_le(stm.m_internal);
	return ret;
}


/* Wrapper for `fz_realloc()`.  */
FZ_FUNCTION void *mfz_realloc(void *p, size_t size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::realloc()\n";
	}
	auto ret = mupdf::realloc(p, size);
	return ret;
}


/* Wrapper for `fz_realloc_no_throw()`.  */
FZ_FUNCTION void *mfz_realloc_no_throw(void *p, size_t size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::realloc_no_throw()\n";
	}
	auto ret = mupdf::realloc_no_throw(p, size);
	return ret;
}


/* Wrapper for `fz_realpath()`.  */
FZ_FUNCTION char *mfz_realpath(const char *path, char *resolved_path)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::realpath()\n";
	}
	auto ret = mupdf::realpath(path, resolved_path);
	return ret;
}


/* Wrapper for `fz_recognize_document()`.  */
FZ_FUNCTION const fz_document_handler *mfz_recognize_document(const char *magic)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::recognize_document()\n";
	}
	auto ret = mupdf::recognize_document(magic);
	return ret;
}


/* Wrapper for `fz_recognize_image_format()`.  */
FZ_FUNCTION int mfz_recognize_image_format(unsigned char p[8])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::recognize_image_format()\n";
	}
	auto ret = mupdf::recognize_image_format(p);
	return ret;
}


/* Wrapper for `fz_rect_from_irect()`.  */
FZ_FUNCTION Rect mfz_rect_from_irect(Irect& bbox)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::rect_from_irect()\n";
	}
	fz_rect temp = mupdf::rect_from_irect(*(fz_irect*) &bbox.x0);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `fz_rect_from_quad()`.  */
FZ_FUNCTION Rect mfz_rect_from_quad(Quad& q)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::rect_from_quad()\n";
	}
	fz_rect temp = mupdf::rect_from_quad(*(fz_quad*) &q.ul);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `fz_rectto()`.  */
FZ_FUNCTION void mfz_rectto(const Path& path, float x0, float y0, float x1, float y1)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::rectto()\n";
	}
	mupdf::rectto(path.m_internal, x0, y0, x1, y1);
}


/* Wrapper for `fz_register_document_handler()`.  */
FZ_FUNCTION void mfz_register_document_handler(const DocumentHandler& handler)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::register_document_handler()\n";
	}
	mupdf::register_document_handler(handler.m_internal);
}


/* Wrapper for `fz_register_document_handlers()`.  */
FZ_FUNCTION void mfz_register_document_handlers()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::register_document_handlers()\n";
	}
	mupdf::register_document_handlers();
}


/* Wrapper for `fz_remove_item()`.  */
FZ_FUNCTION void mfz_remove_item(fz_store_drop_fn *drop, void *key, const StoreType& type)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::remove_item()\n";
	}
	mupdf::remove_item(drop, key, type.m_internal);
}


/* Wrapper for `fz_render_flags()`.  */
FZ_FUNCTION void mfz_render_flags(const Device& dev, int set, int clear)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::render_flags()\n";
	}
	mupdf::render_flags(dev.m_internal, set, clear);
}


/* Wrapper for `fz_render_glyph_pixmap()`.  */
FZ_FUNCTION Pixmap mfz_render_glyph_pixmap(const Font& font, int gid, Matrix& ctm, Irect& scissor, int aa)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::render_glyph_pixmap()\n";
	}
	fz_pixmap* temp = mupdf::render_glyph_pixmap(font.m_internal, gid, (fz_matrix *) &ctm.a, (const fz_irect *) &scissor.x0, aa);
	mupdf::keep_pixmap(temp);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_render_t3_glyph_direct()`.  */
FZ_FUNCTION void mfz_render_t3_glyph_direct(const Device& dev, const Font& font, int gid, Matrix& trm, void *gstate, const DefaultColorspaces& def_cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::render_t3_glyph_direct()\n";
	}
	mupdf::render_t3_glyph_direct(dev.m_internal, font.m_internal, gid, *(fz_matrix*) &trm.a, gstate, def_cs.m_internal);
}


/* Wrapper for `fz_rendering_intent_name()`.  */
FZ_FUNCTION const char *mfz_rendering_intent_name(int ri)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::rendering_intent_name()\n";
	}
	auto ret = mupdf::rendering_intent_name(ri);
	return ret;
}


/* Wrapper for `fz_resize_buffer()`.  */
FZ_FUNCTION void mfz_resize_buffer(const Buffer& buf, size_t capacity)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::resize_buffer()\n";
	}
	mupdf::resize_buffer(buf.m_internal, capacity);
}


/* Wrapper for `fz_resolve_link()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_resolve_link(fz_document *doc, const char *uri)` => `(fz_location, float xp, float yp)`
	 */
FZ_FUNCTION Location mfz_resolve_link(const Document& doc, const char *uri, float *xp, float *yp)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::resolve_link()\n";
	}
	fz_location temp = mupdf::resolve_link(doc.m_internal, uri, xp, yp);
	auto ret = Location(&temp);
	return ret;
}


/* Wrapper for `fz_rethrow()`.  */
FZ_FUNCTION void mfz_rethrow()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::rethrow()\n";
	}
	mupdf::rethrow();
}


/* Wrapper for `fz_rethrow_if()`.  */
FZ_FUNCTION void mfz_rethrow_if(int errcode)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::rethrow_if()\n";
	}
	mupdf::rethrow_if(errcode);
}


/* Wrapper for `fz_rotate()`.  */
FZ_FUNCTION Matrix mfz_rotate(float degrees)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::rotate()\n";
	}
	fz_matrix temp = mupdf::rotate(degrees);
	auto ret = Matrix(&temp);
	return ret;
}


/* Wrapper for `fz_round_rect()`.  */
FZ_FUNCTION Irect mfz_round_rect(Rect& rect)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::round_rect()\n";
	}
	fz_irect temp = mupdf::round_rect(*(fz_rect*) &rect.x0);
	auto ret = Irect(&temp);
	return ret;
}


/* Wrapper for `fz_run_display_list()`.  */
FZ_FUNCTION void mfz_run_display_list(const DisplayList& list, const Device& dev, Matrix& ctm, Rect& scissor, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::run_display_list()\n";
	}
	mupdf::run_display_list(list.m_internal, dev.m_internal, *(fz_matrix*) &ctm.a, *(fz_rect*) &scissor.x0, &cookie.m_internal);
}


/* Wrapper for `fz_run_page()`.  */
FZ_FUNCTION void mfz_run_page(const Page& page, const Device& dev, Matrix& transform, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::run_page()\n";
	}
	mupdf::run_page(page.m_internal, dev.m_internal, *(fz_matrix*) &transform.a, &cookie.m_internal);
}


/* Wrapper for `fz_run_page_annots()`.  */
FZ_FUNCTION void mfz_run_page_annots(const Page& page, const Device& dev, Matrix& transform, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::run_page_annots()\n";
	}
	mupdf::run_page_annots(page.m_internal, dev.m_internal, *(fz_matrix*) &transform.a, &cookie.m_internal);
}


/* Wrapper for `fz_run_page_contents()`.  */
FZ_FUNCTION void mfz_run_page_contents(const Page& page, const Device& dev, Matrix& transform, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::run_page_contents()\n";
	}
	mupdf::run_page_contents(page.m_internal, dev.m_internal, *(fz_matrix*) &transform.a, &cookie.m_internal);
}


/* Wrapper for `fz_run_page_widgets()`.  */
FZ_FUNCTION void mfz_run_page_widgets(const Page& page, const Device& dev, Matrix& transform, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::run_page_widgets()\n";
	}
	mupdf::run_page_widgets(page.m_internal, dev.m_internal, *(fz_matrix*) &transform.a, &cookie.m_internal);
}


/* Wrapper for `fz_run_t3_glyph()`.  */
FZ_FUNCTION void mfz_run_t3_glyph(const Font& font, int gid, Matrix& trm, const Device& dev)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::run_t3_glyph()\n";
	}
	mupdf::run_t3_glyph(font.m_internal, gid, *(fz_matrix*) &trm.a, dev.m_internal);
}


/* Wrapper for `fz_runeidx()`.  */
FZ_FUNCTION int mfz_runeidx(const char *str, const char *p)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::runeidx()\n";
	}
	auto ret = mupdf::runeidx(str, p);
	return ret;
}


/* Wrapper for `fz_runelen()`.  */
FZ_FUNCTION int mfz_runelen(int rune)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::runelen()\n";
	}
	auto ret = mupdf::runelen(rune);
	return ret;
}


/* Wrapper for `fz_runeptr()`.  */
FZ_FUNCTION const char *mfz_runeptr(const char *str, int idx)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::runeptr()\n";
	}
	auto ret = mupdf::runeptr(str, idx);
	return ret;
}


/* Wrapper for `fz_runetochar()`.  */
FZ_FUNCTION int mfz_runetochar(char *str, int rune)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::runetochar()\n";
	}
	auto ret = mupdf::runetochar(str, rune);
	return ret;
}


/* Wrapper for `fz_save_accelerator()`.  */
FZ_FUNCTION void mfz_save_accelerator(const Document& doc, const char *accel)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_accelerator()\n";
	}
	mupdf::save_accelerator(doc.m_internal, accel);
}


/* Wrapper for `fz_save_bitmap_as_pbm()`.  */
FZ_FUNCTION void mfz_save_bitmap_as_pbm(const Bitmap& bitmap, const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_bitmap_as_pbm()\n";
	}
	mupdf::save_bitmap_as_pbm(bitmap.m_internal, filename);
}


/* Wrapper for `fz_save_bitmap_as_pcl()`.  */
FZ_FUNCTION void mfz_save_bitmap_as_pcl(const Bitmap& bitmap, char *filename, int append, const PclOptions& pcl)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_bitmap_as_pcl()\n";
	}
	mupdf::save_bitmap_as_pcl(bitmap.m_internal, filename, append, pcl.m_internal);
}


/* Wrapper for `fz_save_bitmap_as_pkm()`.  */
FZ_FUNCTION void mfz_save_bitmap_as_pkm(const Bitmap& bitmap, const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_bitmap_as_pkm()\n";
	}
	mupdf::save_bitmap_as_pkm(bitmap.m_internal, filename);
}


/* Wrapper for `fz_save_bitmap_as_pwg()`.  */
FZ_FUNCTION void mfz_save_bitmap_as_pwg(const Bitmap& bitmap, char *filename, int append, PwgOptions& pwg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_bitmap_as_pwg()\n";
	}
	mupdf::save_bitmap_as_pwg(bitmap.m_internal, filename, append, &pwg.m_internal);
}


/* Wrapper for `fz_save_buffer()`.  */
FZ_FUNCTION void mfz_save_buffer(const Buffer& buf, const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_buffer()\n";
	}
	mupdf::save_buffer(buf.m_internal, filename);
}


/* Wrapper for `fz_save_pixmap_as_pam()`.  */
FZ_FUNCTION void mfz_save_pixmap_as_pam(const Pixmap& pixmap, const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_pixmap_as_pam()\n";
	}
	mupdf::save_pixmap_as_pam(pixmap.m_internal, filename);
}


/* Wrapper for `fz_save_pixmap_as_pbm()`.  */
FZ_FUNCTION void mfz_save_pixmap_as_pbm(const Pixmap& pixmap, const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_pixmap_as_pbm()\n";
	}
	mupdf::save_pixmap_as_pbm(pixmap.m_internal, filename);
}


/* Wrapper for `fz_save_pixmap_as_pcl()`.  */
FZ_FUNCTION void mfz_save_pixmap_as_pcl(const Pixmap& pixmap, char *filename, int append, const PclOptions& pcl)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_pixmap_as_pcl()\n";
	}
	mupdf::save_pixmap_as_pcl(pixmap.m_internal, filename, append, pcl.m_internal);
}


/* Wrapper for `fz_save_pixmap_as_pclm()`.  */
FZ_FUNCTION void mfz_save_pixmap_as_pclm(const Pixmap& pixmap, char *filename, int append, const PclmOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_pixmap_as_pclm()\n";
	}
	mupdf::save_pixmap_as_pclm(pixmap.m_internal, filename, append, options.m_internal);
}


/* Wrapper for `fz_save_pixmap_as_pdfocr()`.  */
FZ_FUNCTION void mfz_save_pixmap_as_pdfocr(const Pixmap& pixmap, char *filename, int append, PdfocrOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_pixmap_as_pdfocr()\n";
	}
	mupdf::save_pixmap_as_pdfocr(pixmap.m_internal, filename, append, (const fz_pdfocr_options *) &options.compress);
}


/* Wrapper for `fz_save_pixmap_as_pkm()`.  */
FZ_FUNCTION void mfz_save_pixmap_as_pkm(const Pixmap& pixmap, const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_pixmap_as_pkm()\n";
	}
	mupdf::save_pixmap_as_pkm(pixmap.m_internal, filename);
}


/* Wrapper for `fz_save_pixmap_as_png()`.  */
FZ_FUNCTION void mfz_save_pixmap_as_png(const Pixmap& pixmap, const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_pixmap_as_png()\n";
	}
	mupdf::save_pixmap_as_png(pixmap.m_internal, filename);
}


/* Wrapper for `fz_save_pixmap_as_pnm()`.  */
FZ_FUNCTION void mfz_save_pixmap_as_pnm(const Pixmap& pixmap, const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_pixmap_as_pnm()\n";
	}
	mupdf::save_pixmap_as_pnm(pixmap.m_internal, filename);
}


/* Wrapper for `fz_save_pixmap_as_ps()`.  */
FZ_FUNCTION void mfz_save_pixmap_as_ps(const Pixmap& pixmap, char *filename, int append)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_pixmap_as_ps()\n";
	}
	mupdf::save_pixmap_as_ps(pixmap.m_internal, filename, append);
}


/* Wrapper for `fz_save_pixmap_as_psd()`.  */
FZ_FUNCTION void mfz_save_pixmap_as_psd(const Pixmap& pixmap, const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_pixmap_as_psd()\n";
	}
	mupdf::save_pixmap_as_psd(pixmap.m_internal, filename);
}


/* Wrapper for `fz_save_pixmap_as_pwg()`.  */
FZ_FUNCTION void mfz_save_pixmap_as_pwg(const Pixmap& pixmap, char *filename, int append, PwgOptions& pwg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_pixmap_as_pwg()\n";
	}
	mupdf::save_pixmap_as_pwg(pixmap.m_internal, filename, append, &pwg.m_internal);
}


/* Wrapper for `fz_scale()`.  */
FZ_FUNCTION Matrix mfz_scale(float sx, float sy)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::scale()\n";
	}
	fz_matrix temp = mupdf::scale(sx, sy);
	auto ret = Matrix(&temp);
	return ret;
}


/* Wrapper for `fz_search_chapter_page_number()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_search_chapter_page_number(fz_document *doc, int chapter, int page, const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
	 */
FZ_FUNCTION int mfz_search_chapter_page_number(const Document& doc, int chapter, int page, const char *needle, int *hit_mark, Quad& hit_bbox, int hit_max)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::search_chapter_page_number()\n";
	}
	auto ret = mupdf::search_chapter_page_number(doc.m_internal, chapter, page, needle, hit_mark, (fz_quad *) &hit_bbox.ul, hit_max);
	return ret;
}


/* Wrapper for `fz_search_display_list()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_search_display_list(fz_display_list *list, const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
	 */
FZ_FUNCTION int mfz_search_display_list(const DisplayList& list, const char *needle, int *hit_mark, Quad& hit_bbox, int hit_max)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::search_display_list()\n";
	}
	auto ret = mupdf::search_display_list(list.m_internal, needle, hit_mark, (fz_quad *) &hit_bbox.ul, hit_max);
	return ret;
}


/* Wrapper for `fz_search_page()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_search_page(fz_page *page, const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
	 */
FZ_FUNCTION int mfz_search_page(const Page& page, const char *needle, int *hit_mark, Quad& hit_bbox, int hit_max)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::search_page()\n";
	}
	auto ret = mupdf::search_page(page.m_internal, needle, hit_mark, (fz_quad *) &hit_bbox.ul, hit_max);
	return ret;
}


/* Wrapper for `fz_search_page_number()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_search_page_number(fz_document *doc, int number, const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
	 */
FZ_FUNCTION int mfz_search_page_number(const Document& doc, int number, const char *needle, int *hit_mark, Quad& hit_bbox, int hit_max)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::search_page_number()\n";
	}
	auto ret = mupdf::search_page_number(doc.m_internal, number, needle, hit_mark, (fz_quad *) &hit_bbox.ul, hit_max);
	return ret;
}


/* Wrapper for `fz_search_stext_page()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_search_stext_page(fz_stext_page *text, const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
	 */
FZ_FUNCTION int mfz_search_stext_page(const StextPage& text, const char *needle, int *hit_mark, Quad& hit_bbox, int hit_max)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::search_stext_page()\n";
	}
	auto ret = mupdf::search_stext_page(text.m_internal, needle, hit_mark, (fz_quad *) &hit_bbox.ul, hit_max);
	return ret;
}


/* Wrapper for `fz_seek()`.  */
FZ_FUNCTION void mfz_seek(const Stream& stm, int64_t offset, int whence)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::seek()\n";
	}
	mupdf::seek(stm.m_internal, offset, whence);
}


/* Wrapper for `fz_seek_output()`.  */
FZ_FUNCTION void mfz_seek_output(const Output& out, int64_t off, int whence)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::seek_output()\n";
	}
	mupdf::seek_output(out.m_internal, off, whence);
}


/* Wrapper for `fz_separation_current_behavior()`.  */
FZ_FUNCTION fz_separation_behavior mfz_separation_current_behavior(const Separations& sep, int separation)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::separation_current_behavior()\n";
	}
	auto ret = mupdf::separation_current_behavior(sep.m_internal, separation);
	return ret;
}


/* Wrapper for `fz_separation_equivalent()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_separation_equivalent(const fz_separations *seps, int idx, fz_colorspace *dst_cs, fz_colorspace *prf, fz_color_params color_params)` => float dst_color
	 */
FZ_FUNCTION void mfz_separation_equivalent(const Separations& seps, int idx, const Colorspace& dst_cs, float *dst_color, const Colorspace& prf, ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::separation_equivalent()\n";
	}
	mupdf::separation_equivalent(seps.m_internal, idx, dst_cs.m_internal, dst_color, prf.m_internal, *(fz_color_params*) &color_params.ri);
}


/* Wrapper for `fz_separation_name()`.  */
FZ_FUNCTION const char *mfz_separation_name(const Separations& sep, int separation)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::separation_name()\n";
	}
	auto ret = mupdf::separation_name(sep.m_internal, separation);
	return ret;
}


/* Wrapper for `fz_set_aa_level()`.  */
FZ_FUNCTION void mfz_set_aa_level(int bits)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_aa_level()\n";
	}
	mupdf::set_aa_level(bits);
}


/* Wrapper for `fz_set_compressed_image_buffer()`.  */
FZ_FUNCTION void mfz_set_compressed_image_buffer(const CompressedImage& cimg, const CompressedBuffer& buf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_compressed_image_buffer()\n";
	}
	mupdf::set_compressed_image_buffer(cimg.m_internal, buf.m_internal);
}


/* Wrapper for `fz_set_default_cmyk()`.  */
FZ_FUNCTION void mfz_set_default_cmyk(const DefaultColorspaces& default_cs, const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_default_cmyk()\n";
	}
	mupdf::set_default_cmyk(default_cs.m_internal, cs.m_internal);
}


/* Wrapper for `fz_set_default_colorspaces()`.  */
FZ_FUNCTION void mfz_set_default_colorspaces(const Device& dev, const DefaultColorspaces& default_cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_default_colorspaces()\n";
	}
	mupdf::set_default_colorspaces(dev.m_internal, default_cs.m_internal);
}


/* Wrapper for `fz_set_default_gray()`.  */
FZ_FUNCTION void mfz_set_default_gray(const DefaultColorspaces& default_cs, const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_default_gray()\n";
	}
	mupdf::set_default_gray(default_cs.m_internal, cs.m_internal);
}


/* Wrapper for `fz_set_default_output_intent()`.  */
FZ_FUNCTION void mfz_set_default_output_intent(const DefaultColorspaces& default_cs, const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_default_output_intent()\n";
	}
	mupdf::set_default_output_intent(default_cs.m_internal, cs.m_internal);
}


/* Wrapper for `fz_set_default_rgb()`.  */
FZ_FUNCTION void mfz_set_default_rgb(const DefaultColorspaces& default_cs, const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_default_rgb()\n";
	}
	mupdf::set_default_rgb(default_cs.m_internal, cs.m_internal);
}


/* Wrapper for `fz_set_error_callback()`.  */
FZ_FUNCTION void mfz_set_error_callback(fz_error_cb *error_cb, void *user)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_error_callback()\n";
	}
	mupdf::set_error_callback(error_cb, user);
}


/* Wrapper for `fz_set_font_bbox()`.  */
FZ_FUNCTION void mfz_set_font_bbox(const Font& font, float xmin, float ymin, float xmax, float ymax)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_font_bbox()\n";
	}
	mupdf::set_font_bbox(font.m_internal, xmin, ymin, xmax, ymax);
}


/* Wrapper for `fz_set_graphics_aa_level()`.  */
FZ_FUNCTION void mfz_set_graphics_aa_level(int bits)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_graphics_aa_level()\n";
	}
	mupdf::set_graphics_aa_level(bits);
}


/* Wrapper for `fz_set_graphics_min_line_width()`.  */
FZ_FUNCTION void mfz_set_graphics_min_line_width(float min_line_width)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_graphics_min_line_width()\n";
	}
	mupdf::set_graphics_min_line_width(min_line_width);
}


/* Wrapper for `fz_set_metadata()`.  */
FZ_FUNCTION void mfz_set_metadata(const Document& doc, const char *key, const char *value)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_metadata()\n";
	}
	mupdf::set_metadata(doc.m_internal, key, value);
}


/* Wrapper for `fz_set_pixmap_image_tile()`.  */
FZ_FUNCTION void mfz_set_pixmap_image_tile(const PixmapImage& cimg, const Pixmap& pix)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_pixmap_image_tile()\n";
	}
	mupdf::set_pixmap_image_tile(cimg.m_internal, pix.m_internal);
}


/* Wrapper for `fz_set_pixmap_resolution()`.  */
FZ_FUNCTION void mfz_set_pixmap_resolution(const Pixmap& pix, int xres, int yres)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_pixmap_resolution()\n";
	}
	mupdf::set_pixmap_resolution(pix.m_internal, xres, yres);
}


/* Wrapper for `fz_set_separation_behavior()`.  */
FZ_FUNCTION void mfz_set_separation_behavior(const Separations& sep, int separation, fz_separation_behavior behavior)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_separation_behavior()\n";
	}
	mupdf::set_separation_behavior(sep.m_internal, separation, behavior);
}


/* Wrapper for `fz_set_stddbg()`.  */
FZ_FUNCTION void mfz_set_stddbg(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_stddbg()\n";
	}
	mupdf::set_stddbg(out.m_internal);
}


/* Wrapper for `fz_set_text_aa_level()`.  */
FZ_FUNCTION void mfz_set_text_aa_level(int bits)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_text_aa_level()\n";
	}
	mupdf::set_text_aa_level(bits);
}


/* Wrapper for `fz_set_use_document_css()`.  */
FZ_FUNCTION void mfz_set_use_document_css(int use)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_use_document_css()\n";
	}
	mupdf::set_use_document_css(use);
}


/* Wrapper for `fz_set_user_context()`.  */
FZ_FUNCTION void mfz_set_user_context(void *user)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_user_context()\n";
	}
	mupdf::set_user_context(user);
}


/* Wrapper for `fz_set_user_css()`.  */
FZ_FUNCTION void mfz_set_user_css(const char *text)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_user_css()\n";
	}
	mupdf::set_user_css(text);
}


/* Wrapper for `fz_set_warning_callback()`.  */
FZ_FUNCTION void mfz_set_warning_callback(fz_warning_cb *warning_cb, void *user)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_warning_callback()\n";
	}
	mupdf::set_warning_callback(warning_cb, user);
}


/* Wrapper for `fz_sha256_final()`.  */
FZ_FUNCTION void mfz_sha256_final(const Sha256& state, unsigned char digest[32])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::sha256_final()\n";
	}
	mupdf::sha256_final(state.m_internal, digest);
}


/* Wrapper for `fz_sha256_init()`.  */
FZ_FUNCTION void mfz_sha256_init(const Sha256& state)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::sha256_init()\n";
	}
	mupdf::sha256_init(state.m_internal);
}


/* Wrapper for `fz_sha256_update()`.  */
FZ_FUNCTION void mfz_sha256_update(const Sha256& state, const unsigned char *input, size_t inlen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::sha256_update()\n";
	}
	mupdf::sha256_update(state.m_internal, input, inlen);
}


/* Wrapper for `fz_sha384_final()`.  */
FZ_FUNCTION void mfz_sha384_final(const Sha512& state, unsigned char digest[64])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::sha384_final()\n";
	}
	mupdf::sha384_final(state.m_internal, digest);
}


/* Wrapper for `fz_sha384_init()`.  */
FZ_FUNCTION void mfz_sha384_init(const Sha512& state)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::sha384_init()\n";
	}
	mupdf::sha384_init(state.m_internal);
}


/* Wrapper for `fz_sha384_update()`.  */
FZ_FUNCTION void mfz_sha384_update(const Sha512& state, const unsigned char *input, size_t inlen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::sha384_update()\n";
	}
	mupdf::sha384_update(state.m_internal, input, inlen);
}


/* Wrapper for `fz_sha512_final()`.  */
FZ_FUNCTION void mfz_sha512_final(const Sha512& state, unsigned char digest[64])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::sha512_final()\n";
	}
	mupdf::sha512_final(state.m_internal, digest);
}


/* Wrapper for `fz_sha512_init()`.  */
FZ_FUNCTION void mfz_sha512_init(const Sha512& state)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::sha512_init()\n";
	}
	mupdf::sha512_init(state.m_internal);
}


/* Wrapper for `fz_sha512_update()`.  */
FZ_FUNCTION void mfz_sha512_update(const Sha512& state, const unsigned char *input, size_t inlen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::sha512_update()\n";
	}
	mupdf::sha512_update(state.m_internal, input, inlen);
}


/* Wrapper for `fz_shear()`.  */
FZ_FUNCTION Matrix mfz_shear(float sx, float sy)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::shear()\n";
	}
	fz_matrix temp = mupdf::shear(sx, sy);
	auto ret = Matrix(&temp);
	return ret;
}


/* Wrapper for `fz_show_glyph()`.  */
FZ_FUNCTION void mfz_show_glyph(const Text& text, const Font& font, Matrix& trm, int glyph, int unicode, int wmode, int bidi_level, fz_bidi_direction markup_dir, fz_text_language language)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::show_glyph()\n";
	}
	mupdf::show_glyph(text.m_internal, font.m_internal, *(fz_matrix*) &trm.a, glyph, unicode, wmode, bidi_level, markup_dir, language);
}


/* Wrapper for `fz_show_string()`.  */
FZ_FUNCTION Matrix mfz_show_string(const Text& text, const Font& font, Matrix& trm, const char *s, int wmode, int bidi_level, fz_bidi_direction markup_dir, fz_text_language language)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::show_string()\n";
	}
	fz_matrix temp = mupdf::show_string(text.m_internal, font.m_internal, *(fz_matrix*) &trm.a, s, wmode, bidi_level, markup_dir, language);
	auto ret = Matrix(&temp);
	return ret;
}


/* Wrapper for `fz_shrink_store()`.  */
FZ_FUNCTION int mfz_shrink_store(unsigned int percent)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::shrink_store()\n";
	}
	auto ret = mupdf::shrink_store(percent);
	return ret;
}


/* Wrapper for `fz_skip()`.  */
FZ_FUNCTION size_t mfz_skip(const Stream& stm, size_t len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::skip()\n";
	}
	auto ret = mupdf::skip(stm.m_internal, len);
	return ret;
}


/* Wrapper for `fz_skip_space()`.  */
FZ_FUNCTION void mfz_skip_space(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::skip_space()\n";
	}
	mupdf::skip_space(stm.m_internal);
}


/* Wrapper for `fz_skip_string()`.  */
FZ_FUNCTION int mfz_skip_string(const Stream& stm, const char *str)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::skip_string()\n";
	}
	auto ret = mupdf::skip_string(stm.m_internal, str);
	return ret;
}


/* Wrapper for `fz_snap_selection()`.  */
FZ_FUNCTION Quad mfz_snap_selection(const StextPage& page, Point& ap, Point& bp, int mode)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::snap_selection()\n";
	}
	fz_quad temp = mupdf::snap_selection(page.m_internal, (fz_point *) &ap.x, (fz_point *) &bp.x, mode);
	auto ret = Quad(&temp);
	return ret;
}


/* Wrapper for `fz_start_throw_on_repair()`.  */
FZ_FUNCTION void mfz_start_throw_on_repair()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::start_throw_on_repair()\n";
	}
	mupdf::start_throw_on_repair();
}


/* Wrapper for `fz_stat_mtime()`.  */
FZ_FUNCTION int64_t mfz_stat_mtime(const char *path)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::stat_mtime()\n";
	}
	auto ret = mupdf::stat_mtime(path);
	return ret;
}


/* Wrapper for `fz_stddbg()`.  */
FZ_FUNCTION fz_output *mfz_stddbg()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::stddbg()\n";
	}
	auto ret = mupdf::stddbg();
	return ret;
}


/* Wrapper for `fz_stderr()`.  */
FZ_FUNCTION fz_output *mfz_stderr()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::stderr_()\n";
	}
	auto ret = mupdf::stderr_();
	return ret;
}


/* Wrapper for `fz_stdout()`.  */
FZ_FUNCTION fz_output *mfz_stdout()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::stdout_()\n";
	}
	auto ret = mupdf::stdout_();
	return ret;
}


/* Wrapper for `fz_store_item()`.  */
FZ_FUNCTION void *mfz_store_item(void *key, void *val, size_t itemsize, const StoreType& type)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::store_item()\n";
	}
	auto ret = mupdf::store_item(key, val, itemsize, type.m_internal);
	return ret;
}


/* Wrapper for `fz_store_scavenge()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_store_scavenge(size_t size)` => `(int, int phase)`
	 */
FZ_FUNCTION int mfz_store_scavenge(size_t size, int *phase)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::store_scavenge()\n";
	}
	auto ret = mupdf::store_scavenge(size, phase);
	return ret;
}


/* Wrapper for `fz_store_scavenge_external()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_store_scavenge_external(size_t size)` => `(int, int phase)`
	 */
FZ_FUNCTION int mfz_store_scavenge_external(size_t size, int *phase)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::store_scavenge_external()\n";
	}
	auto ret = mupdf::store_scavenge_external(size, phase);
	return ret;
}


/* Wrapper for `fz_strcasecmp()`.  */
FZ_FUNCTION int mfz_strcasecmp(const char *a, const char *b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::strcasecmp()\n";
	}
	auto ret = mupdf::strcasecmp(a, b);
	return ret;
}


/* Wrapper for `fz_strdup()`.  */
FZ_FUNCTION char *mfz_strdup(const char *s)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::strdup()\n";
	}
	auto ret = mupdf::strdup(s);
	return ret;
}


/* Wrapper for `fz_stream_from_output()`.  */
FZ_FUNCTION Stream mfz_stream_from_output(const Output& arg_0)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::stream_from_output()\n";
	}
	fz_stream* temp = mupdf::stream_from_output(arg_0.m_internal);
	mupdf::keep_stream(temp);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_string_from_buffer()`.  */
FZ_FUNCTION const char *mfz_string_from_buffer(const Buffer& buf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::string_from_buffer()\n";
	}
	auto ret = mupdf::string_from_buffer(buf.m_internal);
	return ret;
}


/* Wrapper for `fz_string_from_text_language()`.  */
FZ_FUNCTION char *mfz_string_from_text_language(char str[8], fz_text_language lang)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::string_from_text_language()\n";
	}
	auto ret = mupdf::string_from_text_language(str, lang);
	return ret;
}


/* Wrapper for `fz_strlcat()`.  */
FZ_FUNCTION size_t mfz_strlcat(char *dst, const char *src, size_t n)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::strlcat()\n";
	}
	auto ret = mupdf::strlcat(dst, src, n);
	return ret;
}


/* Wrapper for `fz_strlcpy()`.  */
FZ_FUNCTION size_t mfz_strlcpy(char *dst, const char *src, size_t n)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::strlcpy()\n";
	}
	auto ret = mupdf::strlcpy(dst, src, n);
	return ret;
}


/* Wrapper for `fz_strncasecmp()`.  */
FZ_FUNCTION int mfz_strncasecmp(const char *a, const char *b, size_t n)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::strncasecmp()\n";
	}
	auto ret = mupdf::strncasecmp(a, b, n);
	return ret;
}


/* Wrapper for `fz_strnlen()`.  */
FZ_FUNCTION size_t mfz_strnlen(const char *s, size_t maxlen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::strnlen()\n";
	}
	auto ret = mupdf::strnlen(s, maxlen);
	return ret;
}


/* Wrapper for `fz_stroke_path()`.  */
FZ_FUNCTION void mfz_stroke_path(const Device& dev, const Path& path, const StrokeState& stroke, Matrix& ctm, const Colorspace& colorspace, const float *color, float alpha, ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::stroke_path()\n";
	}
	mupdf::stroke_path(dev.m_internal, path.m_internal, stroke.m_internal, *(fz_matrix*) &ctm.a, colorspace.m_internal, color, alpha, *(fz_color_params*) &color_params.ri);
}


/* Wrapper for `fz_stroke_text()`.  */
FZ_FUNCTION void mfz_stroke_text(const Device& dev, const Text& text, const StrokeState& stroke, Matrix& ctm, const Colorspace& colorspace, const float *color, float alpha, ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::stroke_text()\n";
	}
	mupdf::stroke_text(dev.m_internal, text.m_internal, stroke.m_internal, *(fz_matrix*) &ctm.a, colorspace.m_internal, color, alpha, *(fz_color_params*) &color_params.ri);
}


/* Wrapper for `fz_strsep()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_strsep(const char *delim)` => `(char *, char *stringp)`
	 */
FZ_FUNCTION char *mfz_strsep(char **stringp, const char *delim)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::strsep()\n";
	}
	auto ret = mupdf::strsep(stringp, delim);
	return ret;
}


/* Wrapper for `fz_strtof()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_strtof(const char *s)` => `(float, char *es)`
	 */
FZ_FUNCTION float mfz_strtof(const char *s, char **es)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::strtof()\n";
	}
	auto ret = mupdf::strtof(s, es);
	return ret;
}


/* Wrapper for `fz_subpixel_adjust()`.  */
FZ_FUNCTION float mfz_subpixel_adjust(Matrix& ctm, Matrix& subpix_ctm, unsigned char *qe, unsigned char *qf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::subpixel_adjust()\n";
	}
	auto ret = mupdf::subpixel_adjust((fz_matrix *) &ctm.a, (fz_matrix *) &subpix_ctm.a, qe, qf);
	return ret;
}


/* Wrapper for `fz_sync_bits()`.  */
FZ_FUNCTION void mfz_sync_bits(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::sync_bits()\n";
	}
	mupdf::sync_bits(stm.m_internal);
}


/* Wrapper for `fz_tell()`.  */
FZ_FUNCTION int64_t mfz_tell(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::tell()\n";
	}
	auto ret = mupdf::tell(stm.m_internal);
	return ret;
}


/* Wrapper for `fz_tell_output()`.  */
FZ_FUNCTION int64_t mfz_tell_output(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::tell_output()\n";
	}
	auto ret = mupdf::tell_output(out.m_internal);
	return ret;
}


/* Wrapper for `fz_terminate_buffer()`.  */
FZ_FUNCTION void mfz_terminate_buffer(const Buffer& buf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::terminate_buffer()\n";
	}
	mupdf::terminate_buffer(buf.m_internal);
}


/* Wrapper for `fz_text_aa_level()`.  */
FZ_FUNCTION int mfz_text_aa_level()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::text_aa_level()\n";
	}
	auto ret = mupdf::text_aa_level();
	return ret;
}


/* Wrapper for `fz_text_language_from_string()`.  */
FZ_FUNCTION fz_text_language mfz_text_language_from_string(const char *str)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::text_language_from_string()\n";
	}
	auto ret = mupdf::text_language_from_string(str);
	return ret;
}


/* Wrapper for `fz_tint_pixmap()`.  */
FZ_FUNCTION void mfz_tint_pixmap(const Pixmap& pix, int black, int white)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::tint_pixmap()\n";
	}
	mupdf::tint_pixmap(pix.m_internal, black, white);
}


/* Wrapper for `fz_tolower()`.  */
FZ_FUNCTION int mfz_tolower(int c)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::tolower()\n";
	}
	auto ret = mupdf::tolower(c);
	return ret;
}


/* Wrapper for `fz_toupper()`.  */
FZ_FUNCTION int mfz_toupper(int c)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::toupper()\n";
	}
	auto ret = mupdf::toupper(c);
	return ret;
}


/* Wrapper for `fz_transform_page()`.  */
FZ_FUNCTION Matrix mfz_transform_page(Rect& mediabox, float resolution, float rotate)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::transform_page()\n";
	}
	fz_matrix temp = mupdf::transform_page(*(fz_rect*) &mediabox.x0, resolution, rotate);
	auto ret = Matrix(&temp);
	return ret;
}


/* Wrapper for `fz_transform_path()`.  */
FZ_FUNCTION void mfz_transform_path(const Path& path, Matrix& transform)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::transform_path()\n";
	}
	mupdf::transform_path(path.m_internal, *(fz_matrix*) &transform.a);
}


/* Wrapper for `fz_transform_point()`.  */
FZ_FUNCTION Point mfz_transform_point(Point& point, Matrix& m)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::transform_point()\n";
	}
	fz_point temp = mupdf::transform_point(*(fz_point*) &point.x, *(fz_matrix*) &m.a);
	auto ret = Point(&temp);
	return ret;
}


/* Wrapper for `fz_transform_point_xy()`.  */
FZ_FUNCTION Point mfz_transform_point_xy(float x, float y, Matrix& m)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::transform_point_xy()\n";
	}
	fz_point temp = mupdf::transform_point_xy(x, y, *(fz_matrix*) &m.a);
	auto ret = Point(&temp);
	return ret;
}


/* Wrapper for `fz_transform_quad()`.  */
FZ_FUNCTION Quad mfz_transform_quad(Quad& q, Matrix& m)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::transform_quad()\n";
	}
	fz_quad temp = mupdf::transform_quad(*(fz_quad*) &q.ul, *(fz_matrix*) &m.a);
	auto ret = Quad(&temp);
	return ret;
}


/* Wrapper for `fz_transform_rect()`.  */
FZ_FUNCTION Rect mfz_transform_rect(Rect& rect, Matrix& m)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::transform_rect()\n";
	}
	fz_rect temp = mupdf::transform_rect(*(fz_rect*) &rect.x0, *(fz_matrix*) &m.a);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `fz_transform_vector()`.  */
FZ_FUNCTION Point mfz_transform_vector(Point& vector, Matrix& m)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::transform_vector()\n";
	}
	fz_point temp = mupdf::transform_vector(*(fz_point*) &vector.x, *(fz_matrix*) &m.a);
	auto ret = Point(&temp);
	return ret;
}


/* Wrapper for `fz_translate()`.  */
FZ_FUNCTION Matrix mfz_translate(float tx, float ty)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::translate()\n";
	}
	fz_matrix temp = mupdf::translate(tx, ty);
	auto ret = Matrix(&temp);
	return ret;
}


/* Wrapper for `fz_translate_irect()`.  */
FZ_FUNCTION Irect mfz_translate_irect(Irect& a, int xoff, int yoff)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::translate_irect()\n";
	}
	fz_irect temp = mupdf::translate_irect(*(fz_irect*) &a.x0, xoff, yoff);
	auto ret = Irect(&temp);
	return ret;
}


/* Wrapper for `fz_translate_rect()`.  */
FZ_FUNCTION Rect mfz_translate_rect(Rect& a, float xoff, float yoff)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::translate_rect()\n";
	}
	fz_rect temp = mupdf::translate_rect(*(fz_rect*) &a.x0, xoff, yoff);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `fz_tree_insert()`.  */
FZ_FUNCTION fz_tree *mfz_tree_insert(const Tree& root, const char *key, void *value)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::tree_insert()\n";
	}
	auto ret = mupdf::tree_insert(root.m_internal, key, value);
	return ret;
}


/* Wrapper for `fz_tree_lookup()`.  */
FZ_FUNCTION void *mfz_tree_lookup(const Tree& node, const char *key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::tree_lookup()\n";
	}
	auto ret = mupdf::tree_lookup(node.m_internal, key);
	return ret;
}


/* Wrapper for `fz_trim_buffer()`.  */
FZ_FUNCTION void mfz_trim_buffer(const Buffer& buf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::trim_buffer()\n";
	}
	mupdf::trim_buffer(buf.m_internal);
}


/* Wrapper for `fz_trim_path()`.  */
FZ_FUNCTION void mfz_trim_path(const Path& path)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::trim_path()\n";
	}
	mupdf::trim_path(path.m_internal);
}


/* Wrapper for `fz_truncate_output()`.  */
FZ_FUNCTION void mfz_truncate_output(const Output& arg_0)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::truncate_output()\n";
	}
	mupdf::truncate_output(arg_0.m_internal);
}


/* Wrapper for `fz_try_invert_matrix()`.  */
FZ_FUNCTION int mfz_try_invert_matrix(Matrix& inv, Matrix& src)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::try_invert_matrix()\n";
	}
	auto ret = mupdf::try_invert_matrix((fz_matrix *) &inv.a, *(fz_matrix*) &src.a);
	return ret;
}


/* Wrapper for `fz_tune_image_decode()`.  */
FZ_FUNCTION void mfz_tune_image_decode(fz_tune_image_decode_fn *image_decode, void *arg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::tune_image_decode()\n";
	}
	mupdf::tune_image_decode(image_decode, arg);
}


/* Wrapper for `fz_tune_image_scale()`.  */
FZ_FUNCTION void mfz_tune_image_scale(fz_tune_image_scale_fn *image_scale, void *arg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::tune_image_scale()\n";
	}
	mupdf::tune_image_scale(image_scale, arg);
}


/* Wrapper for `fz_unicode_from_glyph_name()`.  */
FZ_FUNCTION int mfz_unicode_from_glyph_name(const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::unicode_from_glyph_name()\n";
	}
	auto ret = mupdf::unicode_from_glyph_name(name);
	return ret;
}


/* Wrapper for `fz_unicode_from_glyph_name_strict()`.  */
FZ_FUNCTION int mfz_unicode_from_glyph_name_strict(const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::unicode_from_glyph_name_strict()\n";
	}
	auto ret = mupdf::unicode_from_glyph_name_strict(name);
	return ret;
}


/* Wrapper for `fz_union_rect()`.  */
FZ_FUNCTION Rect mfz_union_rect(Rect& a, Rect& b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::union_rect()\n";
	}
	fz_rect temp = mupdf::union_rect(*(fz_rect*) &a.x0, *(fz_rect*) &b.x0);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `fz_unlock()`.  */
FZ_FUNCTION void mfz_unlock(int lock)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::unlock()\n";
	}
	mupdf::unlock(lock);
}


/* Wrapper for `fz_unpack_stream()`.  */
FZ_FUNCTION Stream mfz_unpack_stream(const Stream& src, int depth, int w, int h, int n, int indexed, int pad, int skip)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::unpack_stream()\n";
	}
	fz_stream* temp = mupdf::unpack_stream(src.m_internal, depth, w, h, n, indexed, pad, skip);
	mupdf::keep_stream(temp);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `fz_unread_byte()`.  */
FZ_FUNCTION void mfz_unread_byte(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::unread_byte()\n";
	}
	mupdf::unread_byte(stm.m_internal);
}


/* Wrapper for `fz_unshare_stroke_state()`.  */
FZ_FUNCTION StrokeState mfz_unshare_stroke_state(const StrokeState& shared)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::unshare_stroke_state()\n";
	}
	fz_stroke_state* temp = mupdf::unshare_stroke_state(shared.m_internal);
	mupdf::keep_stroke_state(temp);
	auto ret = StrokeState(temp);
	return ret;
}


/* Wrapper for `fz_unshare_stroke_state_with_dash_len()`.  */
FZ_FUNCTION StrokeState mfz_unshare_stroke_state_with_dash_len(const StrokeState& shared, int len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::unshare_stroke_state_with_dash_len()\n";
	}
	fz_stroke_state* temp = mupdf::unshare_stroke_state_with_dash_len(shared.m_internal, len);
	mupdf::keep_stroke_state(temp);
	auto ret = StrokeState(temp);
	return ret;
}


/* Wrapper for `fz_urldecode()`.  */
FZ_FUNCTION char *mfz_urldecode(char *url)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::urldecode()\n";
	}
	auto ret = mupdf::urldecode(url);
	return ret;
}


/* Wrapper for `fz_use_document_css()`.  */
FZ_FUNCTION int mfz_use_document_css()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::use_document_css()\n";
	}
	auto ret = mupdf::use_document_css();
	return ret;
}


/* Wrapper for `fz_user_context()`.  */
FZ_FUNCTION void *mfz_user_context()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::user_context()\n";
	}
	auto ret = mupdf::user_context();
	return ret;
}


/* Wrapper for `fz_user_css()`.  */
FZ_FUNCTION const char *mfz_user_css()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::user_css()\n";
	}
	auto ret = mupdf::user_css();
	return ret;
}


/* Wrapper for `fz_utflen()`.  */
FZ_FUNCTION int mfz_utflen(const char *s)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::utflen()\n";
	}
	auto ret = mupdf::utflen(s);
	return ret;
}


/* Wrapper for `fz_var_imp()`.  */
FZ_FUNCTION void mfz_var_imp(void *arg_0)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::var_imp()\n";
	}
	mupdf::var_imp(arg_0);
}


/* Wrapper for `fz_vsnprintf()`.  */
FZ_FUNCTION size_t mfz_vsnprintf(char *buffer, size_t space, const char *fmt, va_list args)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::vsnprintf()\n";
	}
	auto ret = mupdf::vsnprintf(buffer, space, fmt, args);
	return ret;
}


/* Wrapper for `fz_vthrow()`.  */
FZ_FUNCTION void mfz_vthrow(int errcode, const char *arg_1, va_list ap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::vthrow()\n";
	}
	mupdf::vthrow(errcode, arg_1, ap);
}


/* Wrapper for `fz_vwarn()`.  */
FZ_FUNCTION void mfz_vwarn(const char *fmt, va_list ap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::vwarn()\n";
	}
	mupdf::vwarn(fmt, ap);
}


/* Wrapper for `fz_walk_path()`.  */
FZ_FUNCTION void mfz_walk_path(const Path& path, const PathWalker& walker, void *arg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::walk_path()\n";
	}
	mupdf::walk_path(path.m_internal, walker.m_internal, arg);
}


/* Wrapper for `fz_warning_callback()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mfz_warning_callback()` => `(fz_warning_cb *, void *user)`
	 */
FZ_FUNCTION fz_warning_cb *mfz_warning_callback(void **user)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::warning_callback()\n";
	}
	auto ret = mupdf::warning_callback(user);
	return ret;
}


/* Wrapper for `fz_warp_pixmap()`.  */
FZ_FUNCTION Pixmap mfz_warp_pixmap(const Pixmap& src, const fz_point points[4], int width, int height)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::warp_pixmap()\n";
	}
	fz_pixmap* temp = mupdf::warp_pixmap(src.m_internal, points, width, height);
	mupdf::keep_pixmap(temp);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `fz_windows_1250_from_unicode()`.  */
FZ_FUNCTION int mfz_windows_1250_from_unicode(int u)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::windows_1250_from_unicode()\n";
	}
	auto ret = mupdf::windows_1250_from_unicode(u);
	return ret;
}


/* Wrapper for `fz_windows_1251_from_unicode()`.  */
FZ_FUNCTION int mfz_windows_1251_from_unicode(int u)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::windows_1251_from_unicode()\n";
	}
	auto ret = mupdf::windows_1251_from_unicode(u);
	return ret;
}


/* Wrapper for `fz_windows_1252_from_unicode()`.  */
FZ_FUNCTION int mfz_windows_1252_from_unicode(int u)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::windows_1252_from_unicode()\n";
	}
	auto ret = mupdf::windows_1252_from_unicode(u);
	return ret;
}


/* Wrapper for `fz_write_band()`.  */
FZ_FUNCTION void mfz_write_band(const BandWriter& writer, int stride, int band_height, const unsigned char *samples)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_band()\n";
	}
	mupdf::write_band(writer.m_internal, stride, band_height, samples);
}


/* Wrapper for `fz_write_base64()`.  */
FZ_FUNCTION void mfz_write_base64(const Output& out, const unsigned char *data, size_t size, int newline)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_base64()\n";
	}
	mupdf::write_base64(out.m_internal, data, size, newline);
}


/* Wrapper for `fz_write_base64_buffer()`.  */
FZ_FUNCTION void mfz_write_base64_buffer(const Output& out, const Buffer& data, int newline)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_base64_buffer()\n";
	}
	mupdf::write_base64_buffer(out.m_internal, data.m_internal, newline);
}


/* Wrapper for `fz_write_bitmap_as_pbm()`.  */
FZ_FUNCTION void mfz_write_bitmap_as_pbm(const Output& out, const Bitmap& bitmap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_bitmap_as_pbm()\n";
	}
	mupdf::write_bitmap_as_pbm(out.m_internal, bitmap.m_internal);
}


/* Wrapper for `fz_write_bitmap_as_pcl()`.  */
FZ_FUNCTION void mfz_write_bitmap_as_pcl(const Output& out, const Bitmap& bitmap, const PclOptions& pcl)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_bitmap_as_pcl()\n";
	}
	mupdf::write_bitmap_as_pcl(out.m_internal, bitmap.m_internal, pcl.m_internal);
}


/* Wrapper for `fz_write_bitmap_as_pkm()`.  */
FZ_FUNCTION void mfz_write_bitmap_as_pkm(const Output& out, const Bitmap& bitmap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_bitmap_as_pkm()\n";
	}
	mupdf::write_bitmap_as_pkm(out.m_internal, bitmap.m_internal);
}


/* Wrapper for `fz_write_bitmap_as_pwg()`.  */
FZ_FUNCTION void mfz_write_bitmap_as_pwg(const Output& out, const Bitmap& bitmap, PwgOptions& pwg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_bitmap_as_pwg()\n";
	}
	mupdf::write_bitmap_as_pwg(out.m_internal, bitmap.m_internal, &pwg.m_internal);
}


/* Wrapper for `fz_write_bitmap_as_pwg_page()`.  */
FZ_FUNCTION void mfz_write_bitmap_as_pwg_page(const Output& out, const Bitmap& bitmap, PwgOptions& pwg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_bitmap_as_pwg_page()\n";
	}
	mupdf::write_bitmap_as_pwg_page(out.m_internal, bitmap.m_internal, &pwg.m_internal);
}


/* Wrapper for `fz_write_byte()`.  */
FZ_FUNCTION void mfz_write_byte(const Output& out, unsigned char x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_byte()\n";
	}
	mupdf::write_byte(out.m_internal, x);
}


/* Wrapper for `fz_write_char()`.  */
FZ_FUNCTION void mfz_write_char(const Output& out, char x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_char()\n";
	}
	mupdf::write_char(out.m_internal, x);
}


/* Wrapper for `fz_write_data()`.  */
FZ_FUNCTION void mfz_write_data(const Output& out, const void *data, size_t size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_data()\n";
	}
	mupdf::write_data(out.m_internal, data, size);
}


/* Wrapper for `fz_write_document()`.  */
FZ_FUNCTION void mfz_write_document(const DocumentWriter& wri, const Document& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_document()\n";
	}
	mupdf::write_document(wri.m_internal, doc.m_internal);
}


/* Wrapper for `fz_write_float_be()`.  */
FZ_FUNCTION void mfz_write_float_be(const Output& out, float f)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_float_be()\n";
	}
	mupdf::write_float_be(out.m_internal, f);
}


/* Wrapper for `fz_write_float_le()`.  */
FZ_FUNCTION void mfz_write_float_le(const Output& out, float f)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_float_le()\n";
	}
	mupdf::write_float_le(out.m_internal, f);
}


/* Wrapper for `fz_write_header()`.  */
FZ_FUNCTION void mfz_write_header(const BandWriter& writer, int w, int h, int n, int alpha, int xres, int yres, int pagenum, const Colorspace& cs, const Separations& seps)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_header()\n";
	}
	mupdf::write_header(writer.m_internal, w, h, n, alpha, xres, yres, pagenum, cs.m_internal, seps.m_internal);
}


/* Wrapper for `fz_write_image_as_data_uri()`.  */
FZ_FUNCTION void mfz_write_image_as_data_uri(const Output& out, const Image& image)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_image_as_data_uri()\n";
	}
	mupdf::write_image_as_data_uri(out.m_internal, image.m_internal);
}


/* Wrapper for `fz_write_int16_be()`.  */
FZ_FUNCTION void mfz_write_int16_be(const Output& out, int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_int16_be()\n";
	}
	mupdf::write_int16_be(out.m_internal, x);
}


/* Wrapper for `fz_write_int16_le()`.  */
FZ_FUNCTION void mfz_write_int16_le(const Output& out, int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_int16_le()\n";
	}
	mupdf::write_int16_le(out.m_internal, x);
}


/* Wrapper for `fz_write_int32_be()`.  */
FZ_FUNCTION void mfz_write_int32_be(const Output& out, int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_int32_be()\n";
	}
	mupdf::write_int32_be(out.m_internal, x);
}


/* Wrapper for `fz_write_int32_le()`.  */
FZ_FUNCTION void mfz_write_int32_le(const Output& out, int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_int32_le()\n";
	}
	mupdf::write_int32_le(out.m_internal, x);
}


/* Wrapper for `fz_write_pixmap_as_data_uri()`.  */
FZ_FUNCTION void mfz_write_pixmap_as_data_uri(const Output& out, const Pixmap& pixmap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_pixmap_as_data_uri()\n";
	}
	mupdf::write_pixmap_as_data_uri(out.m_internal, pixmap.m_internal);
}


/* Wrapper for `fz_write_pixmap_as_pam()`.  */
FZ_FUNCTION void mfz_write_pixmap_as_pam(const Output& out, const Pixmap& pixmap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_pixmap_as_pam()\n";
	}
	mupdf::write_pixmap_as_pam(out.m_internal, pixmap.m_internal);
}


/* Wrapper for `fz_write_pixmap_as_pcl()`.  */
FZ_FUNCTION void mfz_write_pixmap_as_pcl(const Output& out, const Pixmap& pixmap, const PclOptions& pcl)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_pixmap_as_pcl()\n";
	}
	mupdf::write_pixmap_as_pcl(out.m_internal, pixmap.m_internal, pcl.m_internal);
}


/* Wrapper for `fz_write_pixmap_as_pclm()`.  */
FZ_FUNCTION void mfz_write_pixmap_as_pclm(const Output& out, const Pixmap& pixmap, const PclmOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_pixmap_as_pclm()\n";
	}
	mupdf::write_pixmap_as_pclm(out.m_internal, pixmap.m_internal, options.m_internal);
}


/* Wrapper for `fz_write_pixmap_as_pdfocr()`.  */
FZ_FUNCTION void mfz_write_pixmap_as_pdfocr(const Output& out, const Pixmap& pixmap, PdfocrOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_pixmap_as_pdfocr()\n";
	}
	mupdf::write_pixmap_as_pdfocr(out.m_internal, pixmap.m_internal, (const fz_pdfocr_options *) &options.compress);
}


/* Wrapper for `fz_write_pixmap_as_png()`.  */
FZ_FUNCTION void mfz_write_pixmap_as_png(const Output& out, const Pixmap& pixmap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_pixmap_as_png()\n";
	}
	mupdf::write_pixmap_as_png(out.m_internal, pixmap.m_internal);
}


/* Wrapper for `fz_write_pixmap_as_pnm()`.  */
FZ_FUNCTION void mfz_write_pixmap_as_pnm(const Output& out, const Pixmap& pixmap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_pixmap_as_pnm()\n";
	}
	mupdf::write_pixmap_as_pnm(out.m_internal, pixmap.m_internal);
}


/* Wrapper for `fz_write_pixmap_as_ps()`.  */
FZ_FUNCTION void mfz_write_pixmap_as_ps(const Output& out, const Pixmap& pixmap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_pixmap_as_ps()\n";
	}
	mupdf::write_pixmap_as_ps(out.m_internal, pixmap.m_internal);
}


/* Wrapper for `fz_write_pixmap_as_psd()`.  */
FZ_FUNCTION void mfz_write_pixmap_as_psd(const Output& out, const Pixmap& pixmap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_pixmap_as_psd()\n";
	}
	mupdf::write_pixmap_as_psd(out.m_internal, pixmap.m_internal);
}


/* Wrapper for `fz_write_pixmap_as_pwg()`.  */
FZ_FUNCTION void mfz_write_pixmap_as_pwg(const Output& out, const Pixmap& pixmap, PwgOptions& pwg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_pixmap_as_pwg()\n";
	}
	mupdf::write_pixmap_as_pwg(out.m_internal, pixmap.m_internal, &pwg.m_internal);
}


/* Wrapper for `fz_write_pixmap_as_pwg_page()`.  */
FZ_FUNCTION void mfz_write_pixmap_as_pwg_page(const Output& out, const Pixmap& pixmap, PwgOptions& pwg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_pixmap_as_pwg_page()\n";
	}
	mupdf::write_pixmap_as_pwg_page(out.m_internal, pixmap.m_internal, &pwg.m_internal);
}


/* Wrapper for `fz_write_ps_file_header()`.  */
FZ_FUNCTION void mfz_write_ps_file_header(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_ps_file_header()\n";
	}
	mupdf::write_ps_file_header(out.m_internal);
}


/* Wrapper for `fz_write_ps_file_trailer()`.  */
FZ_FUNCTION void mfz_write_ps_file_trailer(const Output& out, int pages)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_ps_file_trailer()\n";
	}
	mupdf::write_ps_file_trailer(out.m_internal, pages);
}


/* Wrapper for `fz_write_pwg_file_header()`.  */
FZ_FUNCTION void mfz_write_pwg_file_header(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_pwg_file_header()\n";
	}
	mupdf::write_pwg_file_header(out.m_internal);
}


/* Wrapper for `fz_write_rune()`.  */
FZ_FUNCTION void mfz_write_rune(const Output& out, int rune)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_rune()\n";
	}
	mupdf::write_rune(out.m_internal, rune);
}


/* Wrapper for `fz_write_string()`.  */
FZ_FUNCTION void mfz_write_string(const Output& out, const char *s)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_string()\n";
	}
	mupdf::write_string(out.m_internal, s);
}


/* Wrapper for `fz_write_uint16_be()`.  */
FZ_FUNCTION void mfz_write_uint16_be(const Output& out, unsigned int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_uint16_be()\n";
	}
	mupdf::write_uint16_be(out.m_internal, x);
}


/* Wrapper for `fz_write_uint16_le()`.  */
FZ_FUNCTION void mfz_write_uint16_le(const Output& out, unsigned int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_uint16_le()\n";
	}
	mupdf::write_uint16_le(out.m_internal, x);
}


/* Wrapper for `fz_write_uint32_be()`.  */
FZ_FUNCTION void mfz_write_uint32_be(const Output& out, unsigned int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_uint32_be()\n";
	}
	mupdf::write_uint32_be(out.m_internal, x);
}


/* Wrapper for `fz_write_uint32_le()`.  */
FZ_FUNCTION void mfz_write_uint32_le(const Output& out, unsigned int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_uint32_le()\n";
	}
	mupdf::write_uint32_le(out.m_internal, x);
}


/* Wrapper for `fz_write_vprintf()`.  */
FZ_FUNCTION void mfz_write_vprintf(const Output& out, const char *fmt, va_list ap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_vprintf()\n";
	}
	mupdf::write_vprintf(out.m_internal, fmt, ap);
}


/* Wrapper for `fz_write_zip_entry()`.  */
FZ_FUNCTION void mfz_write_zip_entry(const ZipWriter& zip, const char *name, const Buffer& buf, int compress)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_zip_entry()\n";
	}
	mupdf::write_zip_entry(zip.m_internal, name, buf.m_internal, compress);
}


/* Wrapper for `fz_xml_att()`.  */
FZ_FUNCTION char *mfz_xml_att(const Xml& item, const char *att)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::xml_att()\n";
	}
	auto ret = mupdf::xml_att(item.m_internal, att);
	return ret;
}


/* Wrapper for `fz_xml_att_alt()`.  */
FZ_FUNCTION char *mfz_xml_att_alt(const Xml& item, const char *one, const char *two)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::xml_att_alt()\n";
	}
	auto ret = mupdf::xml_att_alt(item.m_internal, one, two);
	return ret;
}


/* Wrapper for `fz_xml_att_eq()`.  */
FZ_FUNCTION int mfz_xml_att_eq(const Xml& item, const char *name, const char *match)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::xml_att_eq()\n";
	}
	auto ret = mupdf::xml_att_eq(item.m_internal, name, match);
	return ret;
}


/* Wrapper for `fz_xml_down()`.  */
FZ_FUNCTION fz_xml *mfz_xml_down(const Xml& item)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::xml_down()\n";
	}
	auto ret = mupdf::xml_down(item.m_internal);
	return ret;
}


/* Wrapper for `fz_xml_find()`.  */
FZ_FUNCTION fz_xml *mfz_xml_find(const Xml& item, const char *tag)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::xml_find()\n";
	}
	auto ret = mupdf::xml_find(item.m_internal, tag);
	return ret;
}


/* Wrapper for `fz_xml_find_down()`.  */
FZ_FUNCTION fz_xml *mfz_xml_find_down(const Xml& item, const char *tag)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::xml_find_down()\n";
	}
	auto ret = mupdf::xml_find_down(item.m_internal, tag);
	return ret;
}


/* Wrapper for `fz_xml_find_down_match()`.  */
FZ_FUNCTION fz_xml *mfz_xml_find_down_match(const Xml& item, const char *tag, const char *att, const char *match)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::xml_find_down_match()\n";
	}
	auto ret = mupdf::xml_find_down_match(item.m_internal, tag, att, match);
	return ret;
}


/* Wrapper for `fz_xml_find_match()`.  */
FZ_FUNCTION fz_xml *mfz_xml_find_match(const Xml& item, const char *tag, const char *att, const char *match)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::xml_find_match()\n";
	}
	auto ret = mupdf::xml_find_match(item.m_internal, tag, att, match);
	return ret;
}


/* Wrapper for `fz_xml_find_next()`.  */
FZ_FUNCTION fz_xml *mfz_xml_find_next(const Xml& item, const char *tag)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::xml_find_next()\n";
	}
	auto ret = mupdf::xml_find_next(item.m_internal, tag);
	return ret;
}


/* Wrapper for `fz_xml_find_next_match()`.  */
FZ_FUNCTION fz_xml *mfz_xml_find_next_match(const Xml& item, const char *tag, const char *att, const char *match)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::xml_find_next_match()\n";
	}
	auto ret = mupdf::xml_find_next_match(item.m_internal, tag, att, match);
	return ret;
}


/* Wrapper for `fz_xml_is_tag()`.  */
FZ_FUNCTION int mfz_xml_is_tag(const Xml& item, const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::xml_is_tag()\n";
	}
	auto ret = mupdf::xml_is_tag(item.m_internal, name);
	return ret;
}


/* Wrapper for `fz_xml_next()`.  */
FZ_FUNCTION fz_xml *mfz_xml_next(const Xml& item)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::xml_next()\n";
	}
	auto ret = mupdf::xml_next(item.m_internal);
	return ret;
}


/* Wrapper for `fz_xml_prev()`.  */
FZ_FUNCTION fz_xml *mfz_xml_prev(const Xml& item)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::xml_prev()\n";
	}
	auto ret = mupdf::xml_prev(item.m_internal);
	return ret;
}


/* Wrapper for `fz_xml_root()`.  */
FZ_FUNCTION fz_xml *mfz_xml_root(const XmlDoc& xml)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::xml_root()\n";
	}
	auto ret = mupdf::xml_root(xml.m_internal);
	return ret;
}


/* Wrapper for `fz_xml_tag()`.  */
FZ_FUNCTION char *mfz_xml_tag(const Xml& item)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::xml_tag()\n";
	}
	auto ret = mupdf::xml_tag(item.m_internal);
	return ret;
}


/* Wrapper for `fz_xml_text()`.  */
FZ_FUNCTION char *mfz_xml_text(const Xml& item)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::xml_text()\n";
	}
	auto ret = mupdf::xml_text(item.m_internal);
	return ret;
}


/* Wrapper for `fz_xml_up()`.  */
FZ_FUNCTION fz_xml *mfz_xml_up(const Xml& item)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::xml_up()\n";
	}
	auto ret = mupdf::xml_up(item.m_internal);
	return ret;
}


/* Wrapper for `pdf_access_alert_event()`.  */
FZ_FUNCTION pdf_alert_event *mpdf_access_alert_event(const PdfDocEvent& evt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_access_alert_event()\n";
	}
	auto ret = mupdf::ppdf_access_alert_event(evt.m_internal);
	return ret;
}


/* Wrapper for `pdf_access_exec_menu_item_event()`.  */
FZ_FUNCTION const char *mpdf_access_exec_menu_item_event(const PdfDocEvent& evt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_access_exec_menu_item_event()\n";
	}
	auto ret = mupdf::ppdf_access_exec_menu_item_event(evt.m_internal);
	return ret;
}


/* Wrapper for `pdf_access_launch_url_event()`.  */
FZ_FUNCTION pdf_launch_url_event *mpdf_access_launch_url_event(const PdfDocEvent& evt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_access_launch_url_event()\n";
	}
	auto ret = mupdf::ppdf_access_launch_url_event(evt.m_internal);
	return ret;
}


/* Wrapper for `pdf_access_mail_doc_event()`.  */
FZ_FUNCTION pdf_mail_doc_event *mpdf_access_mail_doc_event(const PdfDocEvent& evt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_access_mail_doc_event()\n";
	}
	auto ret = mupdf::ppdf_access_mail_doc_event(evt.m_internal);
	return ret;
}


/* Wrapper for `pdf_add_annot_ink_list()`.  */
FZ_FUNCTION void mpdf_add_annot_ink_list(const PdfAnnot& annot, int n, fz_point stroke[])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_annot_ink_list()\n";
	}
	mupdf::ppdf_add_annot_ink_list(annot.m_internal, n, stroke);
}


/* Wrapper for `pdf_add_annot_ink_list_stroke()`.  */
FZ_FUNCTION void mpdf_add_annot_ink_list_stroke(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_annot_ink_list_stroke()\n";
	}
	mupdf::ppdf_add_annot_ink_list_stroke(annot.m_internal);
}


/* Wrapper for `pdf_add_annot_ink_list_stroke_vertex()`.  */
FZ_FUNCTION void mpdf_add_annot_ink_list_stroke_vertex(const PdfAnnot& annot, Point& p)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_annot_ink_list_stroke_vertex()\n";
	}
	mupdf::ppdf_add_annot_ink_list_stroke_vertex(annot.m_internal, *(fz_point*) &p.x);
}


/* Wrapper for `pdf_add_annot_quad_point()`.  */
FZ_FUNCTION void mpdf_add_annot_quad_point(const PdfAnnot& annot, Quad& quad)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_annot_quad_point()\n";
	}
	mupdf::ppdf_add_annot_quad_point(annot.m_internal, *(fz_quad*) &quad.ul);
}


/* Wrapper for `pdf_add_annot_vertex()`.  */
FZ_FUNCTION void mpdf_add_annot_vertex(const PdfAnnot& annot, Point& p)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_annot_vertex()\n";
	}
	mupdf::ppdf_add_annot_vertex(annot.m_internal, *(fz_point*) &p.x);
}


/* Wrapper for `pdf_add_cid_font()`.  */
FZ_FUNCTION PdfObj mpdf_add_cid_font(const PdfDocument& doc, const Font& font)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_cid_font()\n";
	}
	pdf_obj* temp = mupdf::ppdf_add_cid_font(doc.m_internal, font.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_add_cjk_font()`.  */
FZ_FUNCTION PdfObj mpdf_add_cjk_font(const PdfDocument& doc, const Font& font, int script, int wmode, int serif)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_cjk_font()\n";
	}
	pdf_obj* temp = mupdf::ppdf_add_cjk_font(doc.m_internal, font.m_internal, script, wmode, serif);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_add_codespace()`.  */
FZ_FUNCTION void mpdf_add_codespace(const PdfCmap& cmap, unsigned int low, unsigned int high, size_t n)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_codespace()\n";
	}
	mupdf::ppdf_add_codespace(cmap.m_internal, low, high, n);
}


/* Wrapper for `pdf_add_embedded_file()`.  */
FZ_FUNCTION PdfObj mpdf_add_embedded_file(const PdfDocument& doc, const char *filename, const char *mimetype, const Buffer& contents)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_embedded_file()\n";
	}
	pdf_obj* temp = mupdf::ppdf_add_embedded_file(doc.m_internal, filename, mimetype, contents.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_add_hmtx()`.  */
FZ_FUNCTION void mpdf_add_hmtx(const PdfFontDesc& font, int lo, int hi, int w)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_hmtx()\n";
	}
	mupdf::ppdf_add_hmtx(font.m_internal, lo, hi, w);
}


/* Wrapper for `pdf_add_image()`.  */
FZ_FUNCTION PdfObj mpdf_add_image(const PdfDocument& doc, const Image& image)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_image()\n";
	}
	pdf_obj* temp = mupdf::ppdf_add_image(doc.m_internal, image.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_add_journal_fragment()`.  */
FZ_FUNCTION void mpdf_add_journal_fragment(const PdfDocument& doc, int parent, const PdfObj& copy, const Buffer& copy_stream, int newobj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_journal_fragment()\n";
	}
	mupdf::ppdf_add_journal_fragment(doc.m_internal, parent, copy.m_internal, copy_stream.m_internal, newobj);
}


/* Wrapper for `pdf_add_new_array()`.  */
FZ_FUNCTION PdfObj mpdf_add_new_array(const PdfDocument& doc, int initial)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_new_array()\n";
	}
	pdf_obj* temp = mupdf::ppdf_add_new_array(doc.m_internal, initial);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_add_new_dict()`.  */
FZ_FUNCTION PdfObj mpdf_add_new_dict(const PdfDocument& doc, int initial)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_new_dict()\n";
	}
	pdf_obj* temp = mupdf::ppdf_add_new_dict(doc.m_internal, initial);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_add_object()`.  */
FZ_FUNCTION PdfObj mpdf_add_object(const PdfDocument& doc, const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_object()\n";
	}
	pdf_obj* temp = mupdf::ppdf_add_object(doc.m_internal, obj.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_add_page()`.  */
FZ_FUNCTION PdfObj mpdf_add_page(const PdfDocument& doc, Rect& mediabox, int rotate, const PdfObj& resources, const Buffer& contents)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_page()\n";
	}
	pdf_obj* temp = mupdf::ppdf_add_page(doc.m_internal, *(fz_rect*) &mediabox.x0, rotate, resources.m_internal, contents.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_add_simple_font()`.  */
FZ_FUNCTION PdfObj mpdf_add_simple_font(const PdfDocument& doc, const Font& font, int encoding)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_simple_font()\n";
	}
	pdf_obj* temp = mupdf::ppdf_add_simple_font(doc.m_internal, font.m_internal, encoding);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_add_stream()`.  */
FZ_FUNCTION PdfObj mpdf_add_stream(const PdfDocument& doc, const Buffer& buf, const PdfObj& obj, int compressed)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_stream()\n";
	}
	pdf_obj* temp = mupdf::ppdf_add_stream(doc.m_internal, buf.m_internal, obj.m_internal, compressed);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_add_substitute_font()`.  */
FZ_FUNCTION PdfObj mpdf_add_substitute_font(const PdfDocument& doc, const Font& font)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_substitute_font()\n";
	}
	pdf_obj* temp = mupdf::ppdf_add_substitute_font(doc.m_internal, font.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_add_vmtx()`.  */
FZ_FUNCTION void mpdf_add_vmtx(const PdfFontDesc& font, int lo, int hi, int x, int y, int w)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_vmtx()\n";
	}
	mupdf::ppdf_add_vmtx(font.m_internal, lo, hi, x, y, w);
}


/* Wrapper for `pdf_annot_MK_BC()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_annot_MK_BC(pdf_annot *annot, float color[4])` => int n
	 */
FZ_FUNCTION void mpdf_annot_MK_BC(const PdfAnnot& annot, int *n, float color[4])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_MK_BC()\n";
	}
	mupdf::ppdf_annot_MK_BC(annot.m_internal, n, color);
}


/* Wrapper for `pdf_annot_MK_BC_rgb()`.  */
FZ_FUNCTION int mpdf_annot_MK_BC_rgb(const PdfAnnot& annot, float rgb[3])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_MK_BC_rgb()\n";
	}
	auto ret = mupdf::ppdf_annot_MK_BC_rgb(annot.m_internal, rgb);
	return ret;
}


/* Wrapper for `pdf_annot_MK_BG()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_annot_MK_BG(pdf_annot *annot, float color[4])` => int n
	 */
FZ_FUNCTION void mpdf_annot_MK_BG(const PdfAnnot& annot, int *n, float color[4])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_MK_BG()\n";
	}
	mupdf::ppdf_annot_MK_BG(annot.m_internal, n, color);
}


/* Wrapper for `pdf_annot_MK_BG_rgb()`.  */
FZ_FUNCTION int mpdf_annot_MK_BG_rgb(const PdfAnnot& annot, float rgb[3])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_MK_BG_rgb()\n";
	}
	auto ret = mupdf::ppdf_annot_MK_BG_rgb(annot.m_internal, rgb);
	return ret;
}


/* Wrapper for `pdf_annot_active()`.  */
FZ_FUNCTION int mpdf_annot_active(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_active()\n";
	}
	auto ret = mupdf::ppdf_annot_active(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_ap()`.  */
FZ_FUNCTION PdfObj mpdf_annot_ap(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_ap()\n";
	}
	pdf_obj* temp = mupdf::ppdf_annot_ap(annot.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_annot_author()`.  */
FZ_FUNCTION const char *mpdf_annot_author(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_author()\n";
	}
	auto ret = mupdf::ppdf_annot_author(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_border()`.  */
FZ_FUNCTION float mpdf_annot_border(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_border()\n";
	}
	auto ret = mupdf::ppdf_annot_border(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_color()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_annot_color(pdf_annot *annot, float color[4])` => int n
	 */
FZ_FUNCTION void mpdf_annot_color(const PdfAnnot& annot, int *n, float color[4])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_color()\n";
	}
	mupdf::ppdf_annot_color(annot.m_internal, n, color);
}


/* Wrapper for `pdf_annot_contents()`.  */
FZ_FUNCTION const char *mpdf_annot_contents(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_contents()\n";
	}
	auto ret = mupdf::ppdf_annot_contents(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_creation_date()`.  */
FZ_FUNCTION int64_t mpdf_annot_creation_date(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_creation_date()\n";
	}
	auto ret = mupdf::ppdf_annot_creation_date(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_default_appearance()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_annot_default_appearance(pdf_annot *annot, float color[4])` => `(const char *font, float size, int n)`
	 */
FZ_FUNCTION void mpdf_annot_default_appearance(const PdfAnnot& annot, const char **font, float *size, int *n, float color[4])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_default_appearance()\n";
	}
	mupdf::ppdf_annot_default_appearance(annot.m_internal, font, size, n, color);
}


/* Wrapper for `pdf_annot_ensure_local_xref()`.  */
FZ_FUNCTION void mpdf_annot_ensure_local_xref(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_ensure_local_xref()\n";
	}
	mupdf::ppdf_annot_ensure_local_xref(annot.m_internal);
}


/* Wrapper for `pdf_annot_event_blur()`.  */
FZ_FUNCTION void mpdf_annot_event_blur(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_event_blur()\n";
	}
	mupdf::ppdf_annot_event_blur(annot.m_internal);
}


/* Wrapper for `pdf_annot_event_down()`.  */
FZ_FUNCTION void mpdf_annot_event_down(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_event_down()\n";
	}
	mupdf::ppdf_annot_event_down(annot.m_internal);
}


/* Wrapper for `pdf_annot_event_enter()`.  */
FZ_FUNCTION void mpdf_annot_event_enter(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_event_enter()\n";
	}
	mupdf::ppdf_annot_event_enter(annot.m_internal);
}


/* Wrapper for `pdf_annot_event_exit()`.  */
FZ_FUNCTION void mpdf_annot_event_exit(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_event_exit()\n";
	}
	mupdf::ppdf_annot_event_exit(annot.m_internal);
}


/* Wrapper for `pdf_annot_event_focus()`.  */
FZ_FUNCTION void mpdf_annot_event_focus(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_event_focus()\n";
	}
	mupdf::ppdf_annot_event_focus(annot.m_internal);
}


/* Wrapper for `pdf_annot_event_page_close()`.  */
FZ_FUNCTION void mpdf_annot_event_page_close(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_event_page_close()\n";
	}
	mupdf::ppdf_annot_event_page_close(annot.m_internal);
}


/* Wrapper for `pdf_annot_event_page_invisible()`.  */
FZ_FUNCTION void mpdf_annot_event_page_invisible(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_event_page_invisible()\n";
	}
	mupdf::ppdf_annot_event_page_invisible(annot.m_internal);
}


/* Wrapper for `pdf_annot_event_page_open()`.  */
FZ_FUNCTION void mpdf_annot_event_page_open(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_event_page_open()\n";
	}
	mupdf::ppdf_annot_event_page_open(annot.m_internal);
}


/* Wrapper for `pdf_annot_event_page_visible()`.  */
FZ_FUNCTION void mpdf_annot_event_page_visible(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_event_page_visible()\n";
	}
	mupdf::ppdf_annot_event_page_visible(annot.m_internal);
}


/* Wrapper for `pdf_annot_event_up()`.  */
FZ_FUNCTION void mpdf_annot_event_up(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_event_up()\n";
	}
	mupdf::ppdf_annot_event_up(annot.m_internal);
}


/* Wrapper for `pdf_annot_field_event_keystroke()`.  */
FZ_FUNCTION int mpdf_annot_field_event_keystroke(const PdfDocument& doc, const PdfAnnot& annot, const PdfKeystrokeEvent& evt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_field_event_keystroke()\n";
	}
	auto ret = mupdf::ppdf_annot_field_event_keystroke(doc.m_internal, annot.m_internal, evt.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_field_flags()`.  */
FZ_FUNCTION int mpdf_annot_field_flags(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_field_flags()\n";
	}
	auto ret = mupdf::ppdf_annot_field_flags(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_field_label()`.  */
FZ_FUNCTION const char *mpdf_annot_field_label(const PdfAnnot& widget)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_field_label()\n";
	}
	auto ret = mupdf::ppdf_annot_field_label(widget.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_field_value()`.  */
FZ_FUNCTION const char *mpdf_annot_field_value(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_field_value()\n";
	}
	auto ret = mupdf::ppdf_annot_field_value(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_flags()`.  */
FZ_FUNCTION int mpdf_annot_flags(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_flags()\n";
	}
	auto ret = mupdf::ppdf_annot_flags(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_has_author()`.  */
FZ_FUNCTION int mpdf_annot_has_author(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_has_author()\n";
	}
	auto ret = mupdf::ppdf_annot_has_author(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_has_icon_name()`.  */
FZ_FUNCTION int mpdf_annot_has_icon_name(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_has_icon_name()\n";
	}
	auto ret = mupdf::ppdf_annot_has_icon_name(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_has_ink_list()`.  */
FZ_FUNCTION int mpdf_annot_has_ink_list(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_has_ink_list()\n";
	}
	auto ret = mupdf::ppdf_annot_has_ink_list(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_has_interior_color()`.  */
FZ_FUNCTION int mpdf_annot_has_interior_color(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_has_interior_color()\n";
	}
	auto ret = mupdf::ppdf_annot_has_interior_color(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_has_line()`.  */
FZ_FUNCTION int mpdf_annot_has_line(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_has_line()\n";
	}
	auto ret = mupdf::ppdf_annot_has_line(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_has_line_ending_styles()`.  */
FZ_FUNCTION int mpdf_annot_has_line_ending_styles(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_has_line_ending_styles()\n";
	}
	auto ret = mupdf::ppdf_annot_has_line_ending_styles(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_has_open()`.  */
FZ_FUNCTION int mpdf_annot_has_open(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_has_open()\n";
	}
	auto ret = mupdf::ppdf_annot_has_open(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_has_quad_points()`.  */
FZ_FUNCTION int mpdf_annot_has_quad_points(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_has_quad_points()\n";
	}
	auto ret = mupdf::ppdf_annot_has_quad_points(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_has_vertices()`.  */
FZ_FUNCTION int mpdf_annot_has_vertices(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_has_vertices()\n";
	}
	auto ret = mupdf::ppdf_annot_has_vertices(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_hot()`.  */
FZ_FUNCTION int mpdf_annot_hot(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_hot()\n";
	}
	auto ret = mupdf::ppdf_annot_hot(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_icon_name()`.  */
FZ_FUNCTION const char *mpdf_annot_icon_name(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_icon_name()\n";
	}
	auto ret = mupdf::ppdf_annot_icon_name(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_ink_list_count()`.  */
FZ_FUNCTION int mpdf_annot_ink_list_count(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_ink_list_count()\n";
	}
	auto ret = mupdf::ppdf_annot_ink_list_count(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_ink_list_stroke_count()`.  */
FZ_FUNCTION int mpdf_annot_ink_list_stroke_count(const PdfAnnot& annot, int i)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_ink_list_stroke_count()\n";
	}
	auto ret = mupdf::ppdf_annot_ink_list_stroke_count(annot.m_internal, i);
	return ret;
}


/* Wrapper for `pdf_annot_ink_list_stroke_vertex()`.  */
FZ_FUNCTION Point mpdf_annot_ink_list_stroke_vertex(const PdfAnnot& annot, int i, int k)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_ink_list_stroke_vertex()\n";
	}
	fz_point temp = mupdf::ppdf_annot_ink_list_stroke_vertex(annot.m_internal, i, k);
	auto ret = Point(&temp);
	return ret;
}


/* Wrapper for `pdf_annot_interior_color()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_annot_interior_color(pdf_annot *annot, float color[4])` => int n
	 */
FZ_FUNCTION void mpdf_annot_interior_color(const PdfAnnot& annot, int *n, float color[4])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_interior_color()\n";
	}
	mupdf::ppdf_annot_interior_color(annot.m_internal, n, color);
}


/* Wrapper for `pdf_annot_is_open()`.  */
FZ_FUNCTION int mpdf_annot_is_open(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_is_open()\n";
	}
	auto ret = mupdf::ppdf_annot_is_open(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_language()`.  */
FZ_FUNCTION fz_text_language mpdf_annot_language(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_language()\n";
	}
	auto ret = mupdf::ppdf_annot_language(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_line()`.  */
FZ_FUNCTION void mpdf_annot_line(const PdfAnnot& annot, Point& a, Point& b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_line()\n";
	}
	mupdf::ppdf_annot_line(annot.m_internal, (fz_point *) &a.x, (fz_point *) &b.x);
}


/* Wrapper for `pdf_annot_line_end_style()`.  */
FZ_FUNCTION enum pdf_line_ending mpdf_annot_line_end_style(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_line_end_style()\n";
	}
	auto ret = mupdf::ppdf_annot_line_end_style(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_line_ending_styles()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_annot_line_ending_styles(pdf_annot *annot)` => `(enum pdf_line_ending start_style, enum pdf_line_ending end_style)`
	 */
FZ_FUNCTION void mpdf_annot_line_ending_styles(const PdfAnnot& annot, enum pdf_line_ending *start_style, enum pdf_line_ending *end_style)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_line_ending_styles()\n";
	}
	mupdf::ppdf_annot_line_ending_styles(annot.m_internal, start_style, end_style);
}


/* Wrapper for `pdf_annot_line_start_style()`.  */
FZ_FUNCTION enum pdf_line_ending mpdf_annot_line_start_style(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_line_start_style()\n";
	}
	auto ret = mupdf::ppdf_annot_line_start_style(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_modification_date()`.  */
FZ_FUNCTION int64_t mpdf_annot_modification_date(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_modification_date()\n";
	}
	auto ret = mupdf::ppdf_annot_modification_date(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_needs_resynthesis()`.  */
FZ_FUNCTION int mpdf_annot_needs_resynthesis(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_needs_resynthesis()\n";
	}
	auto ret = mupdf::ppdf_annot_needs_resynthesis(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_obj()`.  */
FZ_FUNCTION PdfObj mpdf_annot_obj(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_obj()\n";
	}
	pdf_obj* temp = mupdf::ppdf_annot_obj(annot.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_annot_opacity()`.  */
FZ_FUNCTION float mpdf_annot_opacity(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_opacity()\n";
	}
	auto ret = mupdf::ppdf_annot_opacity(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_page()`.  */
FZ_FUNCTION PdfPage mpdf_annot_page(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_page()\n";
	}
	pdf_page* temp = mupdf::ppdf_annot_page(annot.m_internal);
	auto ret = PdfPage(temp);
	return ret;
}


/* Wrapper for `pdf_annot_pop_and_discard_local_xref()`.  */
FZ_FUNCTION void mpdf_annot_pop_and_discard_local_xref(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_pop_and_discard_local_xref()\n";
	}
	mupdf::ppdf_annot_pop_and_discard_local_xref(annot.m_internal);
}


/* Wrapper for `pdf_annot_pop_local_xref()`.  */
FZ_FUNCTION void mpdf_annot_pop_local_xref(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_pop_local_xref()\n";
	}
	mupdf::ppdf_annot_pop_local_xref(annot.m_internal);
}


/* Wrapper for `pdf_annot_popup()`.  */
FZ_FUNCTION Rect mpdf_annot_popup(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_popup()\n";
	}
	fz_rect temp = mupdf::ppdf_annot_popup(annot.m_internal);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `pdf_annot_push_local_xref()`.  */
FZ_FUNCTION void mpdf_annot_push_local_xref(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_push_local_xref()\n";
	}
	mupdf::ppdf_annot_push_local_xref(annot.m_internal);
}


/* Wrapper for `pdf_annot_quad_point()`.  */
FZ_FUNCTION Quad mpdf_annot_quad_point(const PdfAnnot& annot, int i)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_quad_point()\n";
	}
	fz_quad temp = mupdf::ppdf_annot_quad_point(annot.m_internal, i);
	auto ret = Quad(&temp);
	return ret;
}


/* Wrapper for `pdf_annot_quad_point_count()`.  */
FZ_FUNCTION int mpdf_annot_quad_point_count(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_quad_point_count()\n";
	}
	auto ret = mupdf::ppdf_annot_quad_point_count(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_quadding()`.  */
FZ_FUNCTION int mpdf_annot_quadding(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_quadding()\n";
	}
	auto ret = mupdf::ppdf_annot_quadding(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_rect()`.  */
FZ_FUNCTION Rect mpdf_annot_rect(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_rect()\n";
	}
	fz_rect temp = mupdf::ppdf_annot_rect(annot.m_internal);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `pdf_annot_request_resynthesis()`.  */
FZ_FUNCTION void mpdf_annot_request_resynthesis(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_request_resynthesis()\n";
	}
	mupdf::ppdf_annot_request_resynthesis(annot.m_internal);
}


/* Wrapper for `pdf_annot_transform()`.  */
FZ_FUNCTION Matrix mpdf_annot_transform(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_transform()\n";
	}
	fz_matrix temp = mupdf::ppdf_annot_transform(annot.m_internal);
	auto ret = Matrix(&temp);
	return ret;
}


/* Wrapper for `pdf_annot_type()`.  */
FZ_FUNCTION enum pdf_annot_type mpdf_annot_type(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_type()\n";
	}
	auto ret = mupdf::ppdf_annot_type(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_annot_type_from_string()`.  */
FZ_FUNCTION enum pdf_annot_type mpdf_annot_type_from_string(const char *subtype)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_type_from_string()\n";
	}
	auto ret = mupdf::ppdf_annot_type_from_string(subtype);
	return ret;
}


/* Wrapper for `pdf_annot_vertex()`.  */
FZ_FUNCTION Point mpdf_annot_vertex(const PdfAnnot& annot, int i)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_vertex()\n";
	}
	fz_point temp = mupdf::ppdf_annot_vertex(annot.m_internal, i);
	auto ret = Point(&temp);
	return ret;
}


/* Wrapper for `pdf_annot_vertex_count()`.  */
FZ_FUNCTION int mpdf_annot_vertex_count(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_vertex_count()\n";
	}
	auto ret = mupdf::ppdf_annot_vertex_count(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_append_token()`.  */
FZ_FUNCTION void mpdf_append_token(const Buffer& buf, int tok, const PdfLexbuf& lex)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_append_token()\n";
	}
	mupdf::ppdf_append_token(buf.m_internal, tok, lex.m_internal);
}


/* Wrapper for `pdf_array_contains()`.  */
FZ_FUNCTION int mpdf_array_contains(const PdfObj& array, const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_contains()\n";
	}
	auto ret = mupdf::ppdf_array_contains(array.m_internal, obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_array_delete()`.  */
FZ_FUNCTION void mpdf_array_delete(const PdfObj& array, int index)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_delete()\n";
	}
	mupdf::ppdf_array_delete(array.m_internal, index);
}


/* Wrapper for `pdf_array_find()`.  */
FZ_FUNCTION int mpdf_array_find(const PdfObj& array, const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_find()\n";
	}
	auto ret = mupdf::ppdf_array_find(array.m_internal, obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_array_get()`.  */
FZ_FUNCTION PdfObj mpdf_array_get(const PdfObj& array, int i)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_get()\n";
	}
	pdf_obj* temp = mupdf::ppdf_array_get(array.m_internal, i);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_array_get_bool()`.  */
FZ_FUNCTION int mpdf_array_get_bool(const PdfObj& array, int index)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_get_bool()\n";
	}
	auto ret = mupdf::ppdf_array_get_bool(array.m_internal, index);
	return ret;
}


/* Wrapper for `pdf_array_get_int()`.  */
FZ_FUNCTION int mpdf_array_get_int(const PdfObj& array, int index)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_get_int()\n";
	}
	auto ret = mupdf::ppdf_array_get_int(array.m_internal, index);
	return ret;
}


/* Wrapper for `pdf_array_get_matrix()`.  */
FZ_FUNCTION Matrix mpdf_array_get_matrix(const PdfObj& array, int index)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_get_matrix()\n";
	}
	fz_matrix temp = mupdf::ppdf_array_get_matrix(array.m_internal, index);
	auto ret = Matrix(&temp);
	return ret;
}


/* Wrapper for `pdf_array_get_name()`.  */
FZ_FUNCTION const char *mpdf_array_get_name(const PdfObj& array, int index)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_get_name()\n";
	}
	auto ret = mupdf::ppdf_array_get_name(array.m_internal, index);
	return ret;
}


/* Wrapper for `pdf_array_get_real()`.  */
FZ_FUNCTION float mpdf_array_get_real(const PdfObj& array, int index)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_get_real()\n";
	}
	auto ret = mupdf::ppdf_array_get_real(array.m_internal, index);
	return ret;
}


/* Wrapper for `pdf_array_get_rect()`.  */
FZ_FUNCTION Rect mpdf_array_get_rect(const PdfObj& array, int index)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_get_rect()\n";
	}
	fz_rect temp = mupdf::ppdf_array_get_rect(array.m_internal, index);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `pdf_array_get_string()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_array_get_string(pdf_obj *array, int index)` => `(const char *, size_t sizep)`
	 */
FZ_FUNCTION const char *mpdf_array_get_string(const PdfObj& array, int index, size_t *sizep)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_get_string()\n";
	}
	auto ret = mupdf::ppdf_array_get_string(array.m_internal, index, sizep);
	return ret;
}


/* Wrapper for `pdf_array_get_text_string()`.  */
FZ_FUNCTION const char *mpdf_array_get_text_string(const PdfObj& array, int index)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_get_text_string()\n";
	}
	auto ret = mupdf::ppdf_array_get_text_string(array.m_internal, index);
	return ret;
}


/* Wrapper for `pdf_array_insert()`.  */
FZ_FUNCTION void mpdf_array_insert(const PdfObj& array, const PdfObj& obj, int index)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_insert()\n";
	}
	mupdf::ppdf_array_insert(array.m_internal, obj.m_internal, index);
}


/* Wrapper for `pdf_array_len()`.  */
FZ_FUNCTION int mpdf_array_len(const PdfObj& array)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_len()\n";
	}
	auto ret = mupdf::ppdf_array_len(array.m_internal);
	return ret;
}


/* Wrapper for `pdf_array_push()`.  */
FZ_FUNCTION void mpdf_array_push(const PdfObj& array, const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_push()\n";
	}
	mupdf::ppdf_array_push(array.m_internal, obj.m_internal);
}


/* Wrapper for `pdf_array_push_array()`.  */
FZ_FUNCTION PdfObj mpdf_array_push_array(const PdfObj& array, int initial)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_push_array()\n";
	}
	pdf_obj* temp = mupdf::ppdf_array_push_array(array.m_internal, initial);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_array_push_bool()`.  */
FZ_FUNCTION void mpdf_array_push_bool(const PdfObj& array, int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_push_bool()\n";
	}
	mupdf::ppdf_array_push_bool(array.m_internal, x);
}


/* Wrapper for `pdf_array_push_dict()`.  */
FZ_FUNCTION PdfObj mpdf_array_push_dict(const PdfObj& array, int initial)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_push_dict()\n";
	}
	pdf_obj* temp = mupdf::ppdf_array_push_dict(array.m_internal, initial);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_array_push_int()`.  */
FZ_FUNCTION void mpdf_array_push_int(const PdfObj& array, int64_t x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_push_int()\n";
	}
	mupdf::ppdf_array_push_int(array.m_internal, x);
}


/* Wrapper for `pdf_array_push_name()`.  */
FZ_FUNCTION void mpdf_array_push_name(const PdfObj& array, const char *x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_push_name()\n";
	}
	mupdf::ppdf_array_push_name(array.m_internal, x);
}


/* Wrapper for `pdf_array_push_real()`.  */
FZ_FUNCTION void mpdf_array_push_real(const PdfObj& array, double x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_push_real()\n";
	}
	mupdf::ppdf_array_push_real(array.m_internal, x);
}


/* Wrapper for `pdf_array_push_string()`.  */
FZ_FUNCTION void mpdf_array_push_string(const PdfObj& array, const char *x, size_t n)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_push_string()\n";
	}
	mupdf::ppdf_array_push_string(array.m_internal, x, n);
}


/* Wrapper for `pdf_array_push_text_string()`.  */
FZ_FUNCTION void mpdf_array_push_text_string(const PdfObj& array, const char *x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_push_text_string()\n";
	}
	mupdf::ppdf_array_push_text_string(array.m_internal, x);
}


/* Wrapper for `pdf_array_put()`.  */
FZ_FUNCTION void mpdf_array_put(const PdfObj& array, int i, const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_put()\n";
	}
	mupdf::ppdf_array_put(array.m_internal, i, obj.m_internal);
}


/* Wrapper for `pdf_authenticate_password()`.  */
FZ_FUNCTION int mpdf_authenticate_password(const PdfDocument& doc, const char *pw)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_authenticate_password()\n";
	}
	auto ret = mupdf::ppdf_authenticate_password(doc.m_internal, pw);
	return ret;
}


/* Wrapper for `pdf_begin_implicit_operation()`.  */
FZ_FUNCTION void mpdf_begin_implicit_operation(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_begin_implicit_operation()\n";
	}
	mupdf::ppdf_begin_implicit_operation(doc.m_internal);
}


/* Wrapper for `pdf_begin_operation()`.  */
FZ_FUNCTION void mpdf_begin_operation(const PdfDocument& doc, const char *operation)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_begin_operation()\n";
	}
	mupdf::ppdf_begin_operation(doc.m_internal, operation);
}


/* Wrapper for `pdf_bound_annot()`.  */
FZ_FUNCTION Rect mpdf_bound_annot(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_bound_annot()\n";
	}
	fz_rect temp = mupdf::ppdf_bound_annot(annot.m_internal);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `pdf_bound_page()`.  */
FZ_FUNCTION Rect mpdf_bound_page(const PdfPage& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_bound_page()\n";
	}
	fz_rect temp = mupdf::ppdf_bound_page(page.m_internal);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `pdf_bound_widget()`.  */
FZ_FUNCTION Rect mpdf_bound_widget(const PdfAnnot& widget)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_bound_widget()\n";
	}
	fz_rect temp = mupdf::ppdf_bound_widget(widget.m_internal);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `pdf_button_field_on_state()`.  */
FZ_FUNCTION PdfObj mpdf_button_field_on_state(const PdfObj& field)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_button_field_on_state()\n";
	}
	pdf_obj* temp = mupdf::ppdf_button_field_on_state(field.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_cache_object()`.  */
FZ_FUNCTION pdf_xref_entry *mpdf_cache_object(const PdfDocument& doc, int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_cache_object()\n";
	}
	auto ret = mupdf::ppdf_cache_object(doc.m_internal, num);
	return ret;
}


/* Wrapper for `pdf_calculate_form()`.  */
FZ_FUNCTION void mpdf_calculate_form(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_calculate_form()\n";
	}
	mupdf::ppdf_calculate_form(doc.m_internal);
}


/* Wrapper for `pdf_can_be_saved_incrementally()`.  */
FZ_FUNCTION int mpdf_can_be_saved_incrementally(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_can_be_saved_incrementally()\n";
	}
	auto ret = mupdf::ppdf_can_be_saved_incrementally(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_can_redo()`.  */
FZ_FUNCTION int mpdf_can_redo(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_can_redo()\n";
	}
	auto ret = mupdf::ppdf_can_redo(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_can_undo()`.  */
FZ_FUNCTION int mpdf_can_undo(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_can_undo()\n";
	}
	auto ret = mupdf::ppdf_can_undo(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_check_certificate()`.  */
FZ_FUNCTION pdf_signature_error mpdf_check_certificate(const PdfPkcs7Verifier& verifier, const PdfDocument& doc, const PdfObj& signature)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_check_certificate()\n";
	}
	auto ret = mupdf::ppdf_check_certificate(verifier.m_internal, doc.m_internal, signature.m_internal);
	return ret;
}


/* Wrapper for `pdf_check_digest()`.  */
FZ_FUNCTION pdf_signature_error mpdf_check_digest(const PdfPkcs7Verifier& verifier, const PdfDocument& doc, const PdfObj& signature)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_check_digest()\n";
	}
	auto ret = mupdf::ppdf_check_digest(verifier.m_internal, doc.m_internal, signature.m_internal);
	return ret;
}


/* Wrapper for `pdf_check_signature()`.  */
FZ_FUNCTION int mpdf_check_signature(const PdfPkcs7Verifier& verifier, const PdfDocument& doc, const PdfObj& signature, char *ebuf, size_t ebufsize)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_check_signature()\n";
	}
	auto ret = mupdf::ppdf_check_signature(verifier.m_internal, doc.m_internal, signature.m_internal, ebuf, ebufsize);
	return ret;
}


/* Wrapper for `pdf_check_widget_certificate()`.  */
FZ_FUNCTION pdf_signature_error mpdf_check_widget_certificate(const PdfPkcs7Verifier& verifier, const PdfAnnot& widget)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_check_widget_certificate()\n";
	}
	auto ret = mupdf::ppdf_check_widget_certificate(verifier.m_internal, widget.m_internal);
	return ret;
}


/* Wrapper for `pdf_check_widget_digest()`.  */
FZ_FUNCTION pdf_signature_error mpdf_check_widget_digest(const PdfPkcs7Verifier& verifier, const PdfAnnot& widget)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_check_widget_digest()\n";
	}
	auto ret = mupdf::ppdf_check_widget_digest(verifier.m_internal, widget.m_internal);
	return ret;
}


/* Wrapper for `pdf_choice_field_option()`.  */
FZ_FUNCTION const char *mpdf_choice_field_option(const PdfObj& field, int exportval, int i)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_choice_field_option()\n";
	}
	auto ret = mupdf::ppdf_choice_field_option(field.m_internal, exportval, i);
	return ret;
}


/* Wrapper for `pdf_choice_field_option_count()`.  */
FZ_FUNCTION int mpdf_choice_field_option_count(const PdfObj& field)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_choice_field_option_count()\n";
	}
	auto ret = mupdf::ppdf_choice_field_option_count(field.m_internal);
	return ret;
}


/* Wrapper for `pdf_choice_widget_is_multiselect()`.  */
FZ_FUNCTION int mpdf_choice_widget_is_multiselect(const PdfAnnot& tw)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_choice_widget_is_multiselect()\n";
	}
	auto ret = mupdf::ppdf_choice_widget_is_multiselect(tw.m_internal);
	return ret;
}


/* Wrapper for `pdf_choice_widget_options()`.  */
FZ_FUNCTION int mpdf_choice_widget_options(const PdfAnnot& tw, int exportval, const char *opts[])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_choice_widget_options()\n";
	}
	auto ret = mupdf::ppdf_choice_widget_options(tw.m_internal, exportval, opts);
	return ret;
}


/* Wrapper for `pdf_choice_widget_set_value()`.  */
FZ_FUNCTION void mpdf_choice_widget_set_value(const PdfAnnot& tw, int n, const char *opts[])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_choice_widget_set_value()\n";
	}
	mupdf::ppdf_choice_widget_set_value(tw.m_internal, n, opts);
}


/* Wrapper for `pdf_choice_widget_value()`.  */
FZ_FUNCTION int mpdf_choice_widget_value(const PdfAnnot& tw, const char *opts[])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_choice_widget_value()\n";
	}
	auto ret = mupdf::ppdf_choice_widget_value(tw.m_internal, opts);
	return ret;
}


/* Wrapper for `pdf_clean_file()`.  */
FZ_FUNCTION void mpdf_clean_file(char *infile, char *outfile, char *password, PdfWriteOptions& opts, int retainlen, char *retainlist[])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_clean_file()\n";
	}
	mupdf::ppdf_clean_file(infile, outfile, password, (pdf_write_options *) &opts.do_incremental, retainlen, retainlist);
}


/* Wrapper for `pdf_clean_font_name()`.  */
FZ_FUNCTION const char *mpdf_clean_font_name(const char *fontname)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_clean_font_name()\n";
	}
	auto ret = mupdf::ppdf_clean_font_name(fontname);
	return ret;
}


/* Wrapper for `pdf_clean_obj()`.  */
FZ_FUNCTION void mpdf_clean_obj(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_clean_obj()\n";
	}
	mupdf::ppdf_clean_obj(obj.m_internal);
}


/* Wrapper for `pdf_clear_annot_ink_list()`.  */
FZ_FUNCTION void mpdf_clear_annot_ink_list(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_clear_annot_ink_list()\n";
	}
	mupdf::ppdf_clear_annot_ink_list(annot.m_internal);
}


/* Wrapper for `pdf_clear_annot_quad_points()`.  */
FZ_FUNCTION void mpdf_clear_annot_quad_points(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_clear_annot_quad_points()\n";
	}
	mupdf::ppdf_clear_annot_quad_points(annot.m_internal);
}


/* Wrapper for `pdf_clear_annot_vertices()`.  */
FZ_FUNCTION void mpdf_clear_annot_vertices(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_clear_annot_vertices()\n";
	}
	mupdf::ppdf_clear_annot_vertices(annot.m_internal);
}


/* Wrapper for `pdf_clear_signature()`.  */
FZ_FUNCTION void mpdf_clear_signature(const PdfAnnot& widget)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_clear_signature()\n";
	}
	mupdf::ppdf_clear_signature(widget.m_internal);
}


/* Wrapper for `pdf_clear_xref()`.  */
FZ_FUNCTION void mpdf_clear_xref(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_clear_xref()\n";
	}
	mupdf::ppdf_clear_xref(doc.m_internal);
}


/* Wrapper for `pdf_clear_xref_to_mark()`.  */
FZ_FUNCTION void mpdf_clear_xref_to_mark(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_clear_xref_to_mark()\n";
	}
	mupdf::ppdf_clear_xref_to_mark(doc.m_internal);
}


/* Wrapper for `pdf_close_processor()`.  */
FZ_FUNCTION void mpdf_close_processor(const PdfProcessor& proc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_close_processor()\n";
	}
	mupdf::ppdf_close_processor(proc.m_internal);
}


/* Wrapper for `pdf_cmap_size()`.  */
FZ_FUNCTION size_t mpdf_cmap_size(const PdfCmap& cmap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_cmap_size()\n";
	}
	auto ret = mupdf::ppdf_cmap_size(cmap.m_internal);
	return ret;
}


/* Wrapper for `pdf_cmap_wmode()`.  */
FZ_FUNCTION int mpdf_cmap_wmode(const PdfCmap& cmap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_cmap_wmode()\n";
	}
	auto ret = mupdf::ppdf_cmap_wmode(cmap.m_internal);
	return ret;
}


/* Wrapper for `pdf_copy_array()`.  */
FZ_FUNCTION PdfObj mpdf_copy_array(const PdfObj& array)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_copy_array()\n";
	}
	pdf_obj* temp = mupdf::ppdf_copy_array(array.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_copy_dict()`.  */
FZ_FUNCTION PdfObj mpdf_copy_dict(const PdfObj& dict)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_copy_dict()\n";
	}
	pdf_obj* temp = mupdf::ppdf_copy_dict(dict.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_count_layer_config_ui()`.  */
FZ_FUNCTION int mpdf_count_layer_config_ui(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_count_layer_config_ui()\n";
	}
	auto ret = mupdf::ppdf_count_layer_config_ui(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_count_layer_configs()`.  */
FZ_FUNCTION int mpdf_count_layer_configs(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_count_layer_configs()\n";
	}
	auto ret = mupdf::ppdf_count_layer_configs(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_count_objects()`.  */
FZ_FUNCTION int mpdf_count_objects(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_count_objects()\n";
	}
	auto ret = mupdf::ppdf_count_objects(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_count_pages()`.  */
FZ_FUNCTION int mpdf_count_pages(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_count_pages()\n";
	}
	auto ret = mupdf::ppdf_count_pages(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_count_pages_imp()`.  */
FZ_FUNCTION int mpdf_count_pages_imp(const Document& doc, int chapter)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_count_pages_imp()\n";
	}
	auto ret = mupdf::ppdf_count_pages_imp(doc.m_internal, chapter);
	return ret;
}


/* Wrapper for `pdf_count_signatures()`.  */
FZ_FUNCTION int mpdf_count_signatures(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_count_signatures()\n";
	}
	auto ret = mupdf::ppdf_count_signatures(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_count_unsaved_versions()`.  */
FZ_FUNCTION int mpdf_count_unsaved_versions(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_count_unsaved_versions()\n";
	}
	auto ret = mupdf::ppdf_count_unsaved_versions(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_count_versions()`.  */
FZ_FUNCTION int mpdf_count_versions(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_count_versions()\n";
	}
	auto ret = mupdf::ppdf_count_versions(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_create_annot()`.  */
FZ_FUNCTION PdfAnnot mpdf_create_annot(const PdfPage& page, enum pdf_annot_type type)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_create_annot()\n";
	}
	pdf_annot* temp = mupdf::ppdf_create_annot(page.m_internal, type);
	auto ret = PdfAnnot(temp);
	return ret;
}


/* Wrapper for `pdf_create_annot_raw()`.  */
FZ_FUNCTION PdfAnnot mpdf_create_annot_raw(const PdfPage& page, enum pdf_annot_type type)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_create_annot_raw()\n";
	}
	pdf_annot* temp = mupdf::ppdf_create_annot_raw(page.m_internal, type);
	auto ret = PdfAnnot(temp);
	return ret;
}


/* Wrapper for `pdf_create_document()`.  */
FZ_FUNCTION PdfDocument mpdf_create_document()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_create_document()\n";
	}
	pdf_document* temp = mupdf::ppdf_create_document();
	auto ret = PdfDocument(temp);
	return ret;
}


/* Wrapper for `pdf_create_field_name()`.  */
FZ_FUNCTION void mpdf_create_field_name(const PdfDocument& doc, const char *prefix, char *buf, size_t len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_create_field_name()\n";
	}
	mupdf::ppdf_create_field_name(doc.m_internal, prefix, buf, len);
}


/* Wrapper for `pdf_create_link()`.  */
FZ_FUNCTION Link mpdf_create_link(const PdfPage& page, Rect& bbox, const char *uri)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_create_link()\n";
	}
	fz_link* temp = mupdf::ppdf_create_link(page.m_internal, *(fz_rect*) &bbox.x0, uri);
	auto ret = Link(temp);
	return ret;
}


/* Wrapper for `pdf_create_object()`.  */
FZ_FUNCTION int mpdf_create_object(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_create_object()\n";
	}
	auto ret = mupdf::ppdf_create_object(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_create_signature_widget()`.  */
FZ_FUNCTION PdfAnnot mpdf_create_signature_widget(const PdfPage& page, char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_create_signature_widget()\n";
	}
	pdf_annot* temp = mupdf::ppdf_create_signature_widget(page.m_internal, name);
	auto ret = PdfAnnot(temp);
	return ret;
}


/* Wrapper for `pdf_crypt_encrypt_metadata()`.  */
FZ_FUNCTION int mpdf_crypt_encrypt_metadata(const PdfCrypt& crypt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_crypt_encrypt_metadata()\n";
	}
	auto ret = mupdf::ppdf_crypt_encrypt_metadata(crypt.m_internal);
	return ret;
}


/* Wrapper for `pdf_crypt_key()`.  */
FZ_FUNCTION unsigned char *mpdf_crypt_key(const PdfCrypt& crypt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_crypt_key()\n";
	}
	auto ret = mupdf::ppdf_crypt_key(crypt.m_internal);
	return ret;
}


/* Wrapper for `pdf_crypt_length()`.  */
FZ_FUNCTION int mpdf_crypt_length(const PdfCrypt& crypt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_crypt_length()\n";
	}
	auto ret = mupdf::ppdf_crypt_length(crypt.m_internal);
	return ret;
}


/* Wrapper for `pdf_crypt_method()`.  */
FZ_FUNCTION char *mpdf_crypt_method(const PdfCrypt& crypt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_crypt_method()\n";
	}
	auto ret = mupdf::ppdf_crypt_method(crypt.m_internal);
	return ret;
}


/* Wrapper for `pdf_crypt_obj()`.  */
FZ_FUNCTION void mpdf_crypt_obj(const PdfCrypt& crypt, const PdfObj& obj, int num, int gen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_crypt_obj()\n";
	}
	mupdf::ppdf_crypt_obj(crypt.m_internal, obj.m_internal, num, gen);
}


/* Wrapper for `pdf_crypt_owner_encryption()`.  */
FZ_FUNCTION unsigned char *mpdf_crypt_owner_encryption(const PdfCrypt& crypt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_crypt_owner_encryption()\n";
	}
	auto ret = mupdf::ppdf_crypt_owner_encryption(crypt.m_internal);
	return ret;
}


/* Wrapper for `pdf_crypt_owner_password()`.  */
FZ_FUNCTION unsigned char *mpdf_crypt_owner_password(const PdfCrypt& crypt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_crypt_owner_password()\n";
	}
	auto ret = mupdf::ppdf_crypt_owner_password(crypt.m_internal);
	return ret;
}


/* Wrapper for `pdf_crypt_permissions()`.  */
FZ_FUNCTION int mpdf_crypt_permissions(const PdfCrypt& crypt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_crypt_permissions()\n";
	}
	auto ret = mupdf::ppdf_crypt_permissions(crypt.m_internal);
	return ret;
}


/* Wrapper for `pdf_crypt_permissions_encryption()`.  */
FZ_FUNCTION unsigned char *mpdf_crypt_permissions_encryption(const PdfCrypt& crypt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_crypt_permissions_encryption()\n";
	}
	auto ret = mupdf::ppdf_crypt_permissions_encryption(crypt.m_internal);
	return ret;
}


/* Wrapper for `pdf_crypt_revision()`.  */
FZ_FUNCTION int mpdf_crypt_revision(const PdfCrypt& crypt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_crypt_revision()\n";
	}
	auto ret = mupdf::ppdf_crypt_revision(crypt.m_internal);
	return ret;
}


/* Wrapper for `pdf_crypt_user_encryption()`.  */
FZ_FUNCTION unsigned char *mpdf_crypt_user_encryption(const PdfCrypt& crypt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_crypt_user_encryption()\n";
	}
	auto ret = mupdf::ppdf_crypt_user_encryption(crypt.m_internal);
	return ret;
}


/* Wrapper for `pdf_crypt_user_password()`.  */
FZ_FUNCTION unsigned char *mpdf_crypt_user_password(const PdfCrypt& crypt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_crypt_user_password()\n";
	}
	auto ret = mupdf::ppdf_crypt_user_password(crypt.m_internal);
	return ret;
}


/* Wrapper for `pdf_crypt_version()`.  */
FZ_FUNCTION int mpdf_crypt_version(const PdfCrypt& crypt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_crypt_version()\n";
	}
	auto ret = mupdf::ppdf_crypt_version(crypt.m_internal);
	return ret;
}


/* Wrapper for `pdf_debug_doc_changes()`.  */
FZ_FUNCTION void mpdf_debug_doc_changes(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_debug_doc_changes()\n";
	}
	mupdf::ppdf_debug_doc_changes(doc.m_internal);
}


/* Wrapper for `pdf_debug_obj()`.  */
FZ_FUNCTION void mpdf_debug_obj(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_debug_obj()\n";
	}
	mupdf::ppdf_debug_obj(obj.m_internal);
}


/* Wrapper for `pdf_debug_ref()`.  */
FZ_FUNCTION void mpdf_debug_ref(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_debug_ref()\n";
	}
	mupdf::ppdf_debug_ref(obj.m_internal);
}


/* Wrapper for `pdf_decode_cmap()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_decode_cmap(pdf_cmap *cmap, unsigned char *s, unsigned char *e)` => `(int, unsigned int cpt)`
	 */
FZ_FUNCTION int mpdf_decode_cmap(const PdfCmap& cmap, unsigned char *s, unsigned char *e, unsigned int *cpt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_decode_cmap()\n";
	}
	auto ret = mupdf::ppdf_decode_cmap(cmap.m_internal, s, e, cpt);
	return ret;
}


/* Wrapper for `pdf_deep_copy_obj()`.  */
FZ_FUNCTION PdfObj mpdf_deep_copy_obj(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_deep_copy_obj()\n";
	}
	pdf_obj* temp = mupdf::ppdf_deep_copy_obj(obj.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_delete_annot()`.  */
FZ_FUNCTION void mpdf_delete_annot(const PdfPage& page, const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_delete_annot()\n";
	}
	mupdf::ppdf_delete_annot(page.m_internal, annot.m_internal);
}


/* Wrapper for `pdf_delete_object()`.  */
FZ_FUNCTION void mpdf_delete_object(const PdfDocument& doc, int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_delete_object()\n";
	}
	mupdf::ppdf_delete_object(doc.m_internal, num);
}


/* Wrapper for `pdf_delete_page()`.  */
FZ_FUNCTION void mpdf_delete_page(const PdfDocument& doc, int number)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_delete_page()\n";
	}
	mupdf::ppdf_delete_page(doc.m_internal, number);
}


/* Wrapper for `pdf_delete_page_range()`.  */
FZ_FUNCTION void mpdf_delete_page_range(const PdfDocument& doc, int start, int end)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_delete_page_range()\n";
	}
	mupdf::ppdf_delete_page_range(doc.m_internal, start, end);
}


/* Wrapper for `pdf_deselect_layer_config_ui()`.  */
FZ_FUNCTION void mpdf_deselect_layer_config_ui(const PdfDocument& doc, int ui)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_deselect_layer_config_ui()\n";
	}
	mupdf::ppdf_deselect_layer_config_ui(doc.m_internal, ui);
}


/* Wrapper for `pdf_deserialise_journal()`.  */
FZ_FUNCTION void mpdf_deserialise_journal(const PdfDocument& doc, const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_deserialise_journal()\n";
	}
	mupdf::ppdf_deserialise_journal(doc.m_internal, stm.m_internal);
}


/* Wrapper for `pdf_dict_del()`.  */
FZ_FUNCTION void mpdf_dict_del(const PdfObj& dict, const PdfObj& key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_del()\n";
	}
	mupdf::ppdf_dict_del(dict.m_internal, key.m_internal);
}


/* Wrapper for `pdf_dict_dels()`.  */
FZ_FUNCTION void mpdf_dict_dels(const PdfObj& dict, const char *key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_dels()\n";
	}
	mupdf::ppdf_dict_dels(dict.m_internal, key);
}


/* Wrapper for `pdf_dict_get()`.  */
FZ_FUNCTION PdfObj mpdf_dict_get(const PdfObj& dict, const PdfObj& key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_get()\n";
	}
	pdf_obj* temp = mupdf::ppdf_dict_get(dict.m_internal, key.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_dict_get_bool()`.  */
FZ_FUNCTION int mpdf_dict_get_bool(const PdfObj& dict, const PdfObj& key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_get_bool()\n";
	}
	auto ret = mupdf::ppdf_dict_get_bool(dict.m_internal, key.m_internal);
	return ret;
}


/* Wrapper for `pdf_dict_get_date()`.  */
FZ_FUNCTION int64_t mpdf_dict_get_date(const PdfObj& dict, const PdfObj& key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_get_date()\n";
	}
	auto ret = mupdf::ppdf_dict_get_date(dict.m_internal, key.m_internal);
	return ret;
}


/* Wrapper for `pdf_dict_get_inheritable()`.  */
FZ_FUNCTION PdfObj mpdf_dict_get_inheritable(const PdfObj& dict, const PdfObj& key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_get_inheritable()\n";
	}
	pdf_obj* temp = mupdf::ppdf_dict_get_inheritable(dict.m_internal, key.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_dict_get_int()`.  */
FZ_FUNCTION int mpdf_dict_get_int(const PdfObj& dict, const PdfObj& key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_get_int()\n";
	}
	auto ret = mupdf::ppdf_dict_get_int(dict.m_internal, key.m_internal);
	return ret;
}


/* Wrapper for `pdf_dict_get_key()`.  */
FZ_FUNCTION PdfObj mpdf_dict_get_key(const PdfObj& dict, int idx)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_get_key()\n";
	}
	pdf_obj* temp = mupdf::ppdf_dict_get_key(dict.m_internal, idx);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_dict_get_matrix()`.  */
FZ_FUNCTION Matrix mpdf_dict_get_matrix(const PdfObj& dict, const PdfObj& key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_get_matrix()\n";
	}
	fz_matrix temp = mupdf::ppdf_dict_get_matrix(dict.m_internal, key.m_internal);
	auto ret = Matrix(&temp);
	return ret;
}


/* Wrapper for `pdf_dict_get_name()`.  */
FZ_FUNCTION const char *mpdf_dict_get_name(const PdfObj& dict, const PdfObj& key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_get_name()\n";
	}
	auto ret = mupdf::ppdf_dict_get_name(dict.m_internal, key.m_internal);
	return ret;
}


/* Wrapper for `pdf_dict_get_real()`.  */
FZ_FUNCTION float mpdf_dict_get_real(const PdfObj& dict, const PdfObj& key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_get_real()\n";
	}
	auto ret = mupdf::ppdf_dict_get_real(dict.m_internal, key.m_internal);
	return ret;
}


/* Wrapper for `pdf_dict_get_rect()`.  */
FZ_FUNCTION Rect mpdf_dict_get_rect(const PdfObj& dict, const PdfObj& key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_get_rect()\n";
	}
	fz_rect temp = mupdf::ppdf_dict_get_rect(dict.m_internal, key.m_internal);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `pdf_dict_get_string()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_dict_get_string(pdf_obj *dict, pdf_obj *key)` => `(const char *, size_t sizep)`
	 */
FZ_FUNCTION const char *mpdf_dict_get_string(const PdfObj& dict, const PdfObj& key, size_t *sizep)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_get_string()\n";
	}
	auto ret = mupdf::ppdf_dict_get_string(dict.m_internal, key.m_internal, sizep);
	return ret;
}


/* Wrapper for `pdf_dict_get_text_string()`.  */
FZ_FUNCTION const char *mpdf_dict_get_text_string(const PdfObj& dict, const PdfObj& key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_get_text_string()\n";
	}
	auto ret = mupdf::ppdf_dict_get_text_string(dict.m_internal, key.m_internal);
	return ret;
}


/* Wrapper for `pdf_dict_get_val()`.  */
FZ_FUNCTION PdfObj mpdf_dict_get_val(const PdfObj& dict, int idx)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_get_val()\n";
	}
	pdf_obj* temp = mupdf::ppdf_dict_get_val(dict.m_internal, idx);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_dict_geta()`.  */
FZ_FUNCTION PdfObj mpdf_dict_geta(const PdfObj& dict, const PdfObj& key, const PdfObj& abbrev)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_geta()\n";
	}
	pdf_obj* temp = mupdf::ppdf_dict_geta(dict.m_internal, key.m_internal, abbrev.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_dict_getp()`.  */
FZ_FUNCTION PdfObj mpdf_dict_getp(const PdfObj& dict, const char *path)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_getp()\n";
	}
	pdf_obj* temp = mupdf::ppdf_dict_getp(dict.m_internal, path);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_dict_getp_inheritable()`.  */
FZ_FUNCTION PdfObj mpdf_dict_getp_inheritable(const PdfObj& dict, const char *path)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_getp_inheritable()\n";
	}
	pdf_obj* temp = mupdf::ppdf_dict_getp_inheritable(dict.m_internal, path);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_dict_gets()`.  */
FZ_FUNCTION PdfObj mpdf_dict_gets(const PdfObj& dict, const char *key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_gets()\n";
	}
	pdf_obj* temp = mupdf::ppdf_dict_gets(dict.m_internal, key);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_dict_getsa()`.  */
FZ_FUNCTION PdfObj mpdf_dict_getsa(const PdfObj& dict, const char *key, const char *abbrev)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_getsa()\n";
	}
	pdf_obj* temp = mupdf::ppdf_dict_getsa(dict.m_internal, key, abbrev);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_dict_len()`.  */
FZ_FUNCTION int mpdf_dict_len(const PdfObj& dict)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_len()\n";
	}
	auto ret = mupdf::ppdf_dict_len(dict.m_internal);
	return ret;
}


/* Wrapper for `pdf_dict_put()`.  */
FZ_FUNCTION void mpdf_dict_put(const PdfObj& dict, const PdfObj& key, const PdfObj& val)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_put()\n";
	}
	mupdf::ppdf_dict_put(dict.m_internal, key.m_internal, val.m_internal);
}


/* Wrapper for `pdf_dict_put_array()`.  */
FZ_FUNCTION PdfObj mpdf_dict_put_array(const PdfObj& dict, const PdfObj& key, int initial)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_put_array()\n";
	}
	pdf_obj* temp = mupdf::ppdf_dict_put_array(dict.m_internal, key.m_internal, initial);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_dict_put_bool()`.  */
FZ_FUNCTION void mpdf_dict_put_bool(const PdfObj& dict, const PdfObj& key, int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_put_bool()\n";
	}
	mupdf::ppdf_dict_put_bool(dict.m_internal, key.m_internal, x);
}


/* Wrapper for `pdf_dict_put_date()`.  */
FZ_FUNCTION void mpdf_dict_put_date(const PdfObj& dict, const PdfObj& key, int64_t time)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_put_date()\n";
	}
	mupdf::ppdf_dict_put_date(dict.m_internal, key.m_internal, time);
}


/* Wrapper for `pdf_dict_put_dict()`.  */
FZ_FUNCTION PdfObj mpdf_dict_put_dict(const PdfObj& dict, const PdfObj& key, int initial)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_put_dict()\n";
	}
	pdf_obj* temp = mupdf::ppdf_dict_put_dict(dict.m_internal, key.m_internal, initial);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_dict_put_int()`.  */
FZ_FUNCTION void mpdf_dict_put_int(const PdfObj& dict, const PdfObj& key, int64_t x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_put_int()\n";
	}
	mupdf::ppdf_dict_put_int(dict.m_internal, key.m_internal, x);
}


/* Wrapper for `pdf_dict_put_matrix()`.  */
FZ_FUNCTION void mpdf_dict_put_matrix(const PdfObj& dict, const PdfObj& key, Matrix& x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_put_matrix()\n";
	}
	mupdf::ppdf_dict_put_matrix(dict.m_internal, key.m_internal, *(fz_matrix*) &x.a);
}


/* Wrapper for `pdf_dict_put_name()`.  */
FZ_FUNCTION void mpdf_dict_put_name(const PdfObj& dict, const PdfObj& key, const char *x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_put_name()\n";
	}
	mupdf::ppdf_dict_put_name(dict.m_internal, key.m_internal, x);
}


/* Wrapper for `pdf_dict_put_real()`.  */
FZ_FUNCTION void mpdf_dict_put_real(const PdfObj& dict, const PdfObj& key, double x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_put_real()\n";
	}
	mupdf::ppdf_dict_put_real(dict.m_internal, key.m_internal, x);
}


/* Wrapper for `pdf_dict_put_rect()`.  */
FZ_FUNCTION void mpdf_dict_put_rect(const PdfObj& dict, const PdfObj& key, Rect& x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_put_rect()\n";
	}
	mupdf::ppdf_dict_put_rect(dict.m_internal, key.m_internal, *(fz_rect*) &x.x0);
}


/* Wrapper for `pdf_dict_put_string()`.  */
FZ_FUNCTION void mpdf_dict_put_string(const PdfObj& dict, const PdfObj& key, const char *x, size_t n)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_put_string()\n";
	}
	mupdf::ppdf_dict_put_string(dict.m_internal, key.m_internal, x, n);
}


/* Wrapper for `pdf_dict_put_text_string()`.  */
FZ_FUNCTION void mpdf_dict_put_text_string(const PdfObj& dict, const PdfObj& key, const char *x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_put_text_string()\n";
	}
	mupdf::ppdf_dict_put_text_string(dict.m_internal, key.m_internal, x);
}


/* Wrapper for `pdf_dict_put_val_null()`.  */
FZ_FUNCTION void mpdf_dict_put_val_null(const PdfObj& obj, int idx)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_put_val_null()\n";
	}
	mupdf::ppdf_dict_put_val_null(obj.m_internal, idx);
}


/* Wrapper for `pdf_dict_putp()`.  */
FZ_FUNCTION void mpdf_dict_putp(const PdfObj& dict, const char *path, const PdfObj& val)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_putp()\n";
	}
	mupdf::ppdf_dict_putp(dict.m_internal, path, val.m_internal);
}


/* Wrapper for `pdf_dict_puts()`.  */
FZ_FUNCTION void mpdf_dict_puts(const PdfObj& dict, const char *key, const PdfObj& val)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_puts()\n";
	}
	mupdf::ppdf_dict_puts(dict.m_internal, key, val.m_internal);
}


/* Wrapper for `pdf_dict_puts_dict()`.  */
FZ_FUNCTION PdfObj mpdf_dict_puts_dict(const PdfObj& dict, const char *key, int initial)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_puts_dict()\n";
	}
	pdf_obj* temp = mupdf::ppdf_dict_puts_dict(dict.m_internal, key, initial);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_dirty_annot()`.  */
FZ_FUNCTION void mpdf_dirty_annot(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dirty_annot()\n";
	}
	mupdf::ppdf_dirty_annot(annot.m_internal);
}


/* Wrapper for `pdf_dirty_obj()`.  */
FZ_FUNCTION void mpdf_dirty_obj(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dirty_obj()\n";
	}
	mupdf::ppdf_dirty_obj(obj.m_internal);
}


/* Wrapper for `pdf_disable_js()`.  */
FZ_FUNCTION void mpdf_disable_js(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_disable_js()\n";
	}
	mupdf::ppdf_disable_js(doc.m_internal);
}


/* Wrapper for `pdf_discard_journal()`.  */
FZ_FUNCTION void mpdf_discard_journal(const PdfJournal& journal)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_discard_journal()\n";
	}
	mupdf::ppdf_discard_journal(journal.m_internal);
}


/* Wrapper for `pdf_doc_was_linearized()`.  */
FZ_FUNCTION int mpdf_doc_was_linearized(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_doc_was_linearized()\n";
	}
	auto ret = mupdf::ppdf_doc_was_linearized(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_document_event_did_print()`.  */
FZ_FUNCTION void mpdf_document_event_did_print(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_document_event_did_print()\n";
	}
	mupdf::ppdf_document_event_did_print(doc.m_internal);
}


/* Wrapper for `pdf_document_event_did_save()`.  */
FZ_FUNCTION void mpdf_document_event_did_save(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_document_event_did_save()\n";
	}
	mupdf::ppdf_document_event_did_save(doc.m_internal);
}


/* Wrapper for `pdf_document_event_will_close()`.  */
FZ_FUNCTION void mpdf_document_event_will_close(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_document_event_will_close()\n";
	}
	mupdf::ppdf_document_event_will_close(doc.m_internal);
}


/* Wrapper for `pdf_document_event_will_print()`.  */
FZ_FUNCTION void mpdf_document_event_will_print(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_document_event_will_print()\n";
	}
	mupdf::ppdf_document_event_will_print(doc.m_internal);
}


/* Wrapper for `pdf_document_event_will_save()`.  */
FZ_FUNCTION void mpdf_document_event_will_save(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_document_event_will_save()\n";
	}
	mupdf::ppdf_document_event_will_save(doc.m_internal);
}


/* Wrapper for `pdf_document_from_fz_document()`.  */
FZ_FUNCTION PdfDocument mpdf_document_from_fz_document(const Document& ptr)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_document_from_fz_document()\n";
	}
	pdf_document* temp = mupdf::ppdf_document_from_fz_document(ptr.m_internal);
	mupdf::ppdf_keep_document(temp);
	auto ret = PdfDocument(temp);
	return ret;
}


/* Wrapper for `pdf_document_language()`.  */
FZ_FUNCTION fz_text_language mpdf_document_language(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_document_language()\n";
	}
	auto ret = mupdf::ppdf_document_language(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_document_output_intent()`.  */
FZ_FUNCTION Colorspace mpdf_document_output_intent(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_document_output_intent()\n";
	}
	fz_colorspace* temp = mupdf::ppdf_document_output_intent(doc.m_internal);
	mupdf::keep_colorspace(temp);
	auto ret = Colorspace(temp);
	return ret;
}


/* Wrapper for `pdf_document_permissions()`.  */
FZ_FUNCTION int mpdf_document_permissions(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_document_permissions()\n";
	}
	auto ret = mupdf::ppdf_document_permissions(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_drop_annot()`.  */
FZ_FUNCTION void mpdf_drop_annot(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_annot()\n";
	}
	mupdf::ppdf_drop_annot(annot.m_internal);
}


/* Wrapper for `pdf_drop_cmap()`.  */
FZ_FUNCTION void mpdf_drop_cmap(const PdfCmap& cmap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_cmap()\n";
	}
	mupdf::ppdf_drop_cmap(cmap.m_internal);
}


/* Wrapper for `pdf_drop_cmap_imp()`.  */
FZ_FUNCTION void mpdf_drop_cmap_imp(const Storable& cmap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_cmap_imp()\n";
	}
	mupdf::ppdf_drop_cmap_imp(cmap.m_internal);
}


/* Wrapper for `pdf_drop_crypt()`.  */
FZ_FUNCTION void mpdf_drop_crypt(const PdfCrypt& crypt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_crypt()\n";
	}
	mupdf::ppdf_drop_crypt(crypt.m_internal);
}


/* Wrapper for `pdf_drop_document()`.  */
FZ_FUNCTION void mpdf_drop_document(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_document()\n";
	}
	mupdf::ppdf_drop_document(doc.m_internal);
}


/* Wrapper for `pdf_drop_font()`.  */
FZ_FUNCTION void mpdf_drop_font(const PdfFontDesc& font)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_font()\n";
	}
	mupdf::ppdf_drop_font(font.m_internal);
}


/* Wrapper for `pdf_drop_function()`.  */
FZ_FUNCTION void mpdf_drop_function(const PdfFunction& func)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_function()\n";
	}
	mupdf::ppdf_drop_function(func.m_internal);
}


/* Wrapper for `pdf_drop_graft_map()`.  */
FZ_FUNCTION void mpdf_drop_graft_map(const PdfGraftMap& map)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_graft_map()\n";
	}
	mupdf::ppdf_drop_graft_map(map.m_internal);
}


/* Wrapper for `pdf_drop_journal()`.  */
FZ_FUNCTION void mpdf_drop_journal(const PdfJournal& journal)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_journal()\n";
	}
	mupdf::ppdf_drop_journal(journal.m_internal);
}


/* Wrapper for `pdf_drop_js()`.  */
FZ_FUNCTION void mpdf_drop_js(const PdfJs& js)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_js()\n";
	}
	mupdf::ppdf_drop_js(js.m_internal);
}


/* Wrapper for `pdf_drop_local_xref()`.  */
FZ_FUNCTION void mpdf_drop_local_xref(const PdfXref& xref)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_local_xref()\n";
	}
	mupdf::ppdf_drop_local_xref(xref.m_internal);
}


/* Wrapper for `pdf_drop_local_xref_and_resources()`.  */
FZ_FUNCTION void mpdf_drop_local_xref_and_resources(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_local_xref_and_resources()\n";
	}
	mupdf::ppdf_drop_local_xref_and_resources(doc.m_internal);
}


/* Wrapper for `pdf_drop_locked_fields()`.  */
FZ_FUNCTION void mpdf_drop_locked_fields(const PdfLockedFields& locked)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_locked_fields()\n";
	}
	mupdf::ppdf_drop_locked_fields(locked.m_internal);
}


/* Wrapper for `pdf_drop_obj()`.  */
FZ_FUNCTION void mpdf_drop_obj(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_obj()\n";
	}
	mupdf::ppdf_drop_obj(obj.m_internal);
}


/* Wrapper for `pdf_drop_ocg()`.  */
FZ_FUNCTION void mpdf_drop_ocg(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_ocg()\n";
	}
	mupdf::ppdf_drop_ocg(doc.m_internal);
}


/* Wrapper for `pdf_drop_page_tree()`.  */
FZ_FUNCTION void mpdf_drop_page_tree(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_page_tree()\n";
	}
	mupdf::ppdf_drop_page_tree(doc.m_internal);
}


/* Wrapper for `pdf_drop_pattern()`.  */
FZ_FUNCTION void mpdf_drop_pattern(const PdfPattern& pat)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_pattern()\n";
	}
	mupdf::ppdf_drop_pattern(pat.m_internal);
}


/* Wrapper for `pdf_drop_processor()`.  */
FZ_FUNCTION void mpdf_drop_processor(const PdfProcessor& proc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_processor()\n";
	}
	mupdf::ppdf_drop_processor(proc.m_internal);
}


/* Wrapper for `pdf_drop_resource_tables()`.  */
FZ_FUNCTION void mpdf_drop_resource_tables(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_resource_tables()\n";
	}
	mupdf::ppdf_drop_resource_tables(doc.m_internal);
}


/* Wrapper for `pdf_drop_signer()`.  */
FZ_FUNCTION void mpdf_drop_signer(const PdfPkcs7Signer& signer)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_signer()\n";
	}
	mupdf::ppdf_drop_signer(signer.m_internal);
}


/* Wrapper for `pdf_drop_verifier()`.  */
FZ_FUNCTION void mpdf_drop_verifier(const PdfPkcs7Verifier& verifier)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_verifier()\n";
	}
	mupdf::ppdf_drop_verifier(verifier.m_internal);
}


/* Wrapper for `pdf_drop_widget()`.  */
FZ_FUNCTION void mpdf_drop_widget(const PdfAnnot& widget)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_widget()\n";
	}
	mupdf::ppdf_drop_widget(widget.m_internal);
}


/* Wrapper for `pdf_edit_text_field_value()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_edit_text_field_value(pdf_annot *widget, const char *value, const char *change)` => `(int, int selStart, int selEnd, char *newvalue)`
	 */
FZ_FUNCTION int mpdf_edit_text_field_value(const PdfAnnot& widget, const char *value, const char *change, int *selStart, int *selEnd, char **newvalue)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_edit_text_field_value()\n";
	}
	auto ret = mupdf::ppdf_edit_text_field_value(widget.m_internal, value, change, selStart, selEnd, newvalue);
	return ret;
}


/* Wrapper for `pdf_embedded_file_name()`.  */
FZ_FUNCTION const char *mpdf_embedded_file_name(const PdfObj& fs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_embedded_file_name()\n";
	}
	auto ret = mupdf::ppdf_embedded_file_name(fs.m_internal);
	return ret;
}


/* Wrapper for `pdf_embedded_file_stream()`.  */
FZ_FUNCTION PdfObj mpdf_embedded_file_stream(const PdfObj& fs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_embedded_file_stream()\n";
	}
	pdf_obj* temp = mupdf::ppdf_embedded_file_stream(fs.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_embedded_file_type()`.  */
FZ_FUNCTION const char *mpdf_embedded_file_type(const PdfObj& fs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_embedded_file_type()\n";
	}
	auto ret = mupdf::ppdf_embedded_file_type(fs.m_internal);
	return ret;
}


/* Wrapper for `pdf_empty_store()`.  */
FZ_FUNCTION void mpdf_empty_store(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_empty_store()\n";
	}
	mupdf::ppdf_empty_store(doc.m_internal);
}


/* Wrapper for `pdf_enable_journal()`.  */
FZ_FUNCTION void mpdf_enable_journal(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_enable_journal()\n";
	}
	mupdf::ppdf_enable_journal(doc.m_internal);
}


/* Wrapper for `pdf_enable_js()`.  */
FZ_FUNCTION void mpdf_enable_js(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_enable_js()\n";
	}
	mupdf::ppdf_enable_js(doc.m_internal);
}


/* Wrapper for `pdf_encrypt_data()`.  */
FZ_FUNCTION void mpdf_encrypt_data(const PdfCrypt& crypt, int num, int gen, void (*fmt_str_out)(fz_context *, void *, const unsigned char *, size_t ), void *arg, const unsigned char *s, size_t n)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_encrypt_data()\n";
	}
	mupdf::ppdf_encrypt_data(crypt.m_internal, num, gen, fmt_str_out, arg, s, n);
}


/* Wrapper for `pdf_encrypted_len()`.  */
FZ_FUNCTION size_t mpdf_encrypted_len(const PdfCrypt& crypt, int num, int gen, size_t len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_encrypted_len()\n";
	}
	auto ret = mupdf::ppdf_encrypted_len(crypt.m_internal, num, gen, len);
	return ret;
}


/* Wrapper for `pdf_end_hmtx()`.  */
FZ_FUNCTION void mpdf_end_hmtx(const PdfFontDesc& font)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_end_hmtx()\n";
	}
	mupdf::ppdf_end_hmtx(font.m_internal);
}


/* Wrapper for `pdf_end_operation()`.  */
FZ_FUNCTION void mpdf_end_operation(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_end_operation()\n";
	}
	mupdf::ppdf_end_operation(doc.m_internal);
}


/* Wrapper for `pdf_end_vmtx()`.  */
FZ_FUNCTION void mpdf_end_vmtx(const PdfFontDesc& font)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_end_vmtx()\n";
	}
	mupdf::ppdf_end_vmtx(font.m_internal);
}


/* Wrapper for `pdf_ensure_solid_xref()`.  */
FZ_FUNCTION void mpdf_ensure_solid_xref(const PdfDocument& doc, int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_ensure_solid_xref()\n";
	}
	mupdf::ppdf_ensure_solid_xref(doc.m_internal, num);
}


/* Wrapper for `pdf_eval_function()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_eval_function(pdf_function *func, const float *in, int inlen, int outlen)` => float out
	 */
FZ_FUNCTION void mpdf_eval_function(const PdfFunction& func, const float *in, int inlen, float *out, int outlen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_eval_function()\n";
	}
	mupdf::ppdf_eval_function(func.m_internal, in, inlen, out, outlen);
}


/* Wrapper for `pdf_event_issue_alert()`.  */
FZ_FUNCTION void mpdf_event_issue_alert(const PdfDocument& doc, const PdfAlertEvent& evt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_event_issue_alert()\n";
	}
	mupdf::ppdf_event_issue_alert(doc.m_internal, evt.m_internal);
}


/* Wrapper for `pdf_event_issue_exec_menu_item()`.  */
FZ_FUNCTION void mpdf_event_issue_exec_menu_item(const PdfDocument& doc, const char *item)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_event_issue_exec_menu_item()\n";
	}
	mupdf::ppdf_event_issue_exec_menu_item(doc.m_internal, item);
}


/* Wrapper for `pdf_event_issue_launch_url()`.  */
FZ_FUNCTION void mpdf_event_issue_launch_url(const PdfDocument& doc, const char *url, int new_frame)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_event_issue_launch_url()\n";
	}
	mupdf::ppdf_event_issue_launch_url(doc.m_internal, url, new_frame);
}


/* Wrapper for `pdf_event_issue_mail_doc()`.  */
FZ_FUNCTION void mpdf_event_issue_mail_doc(const PdfDocument& doc, const PdfMailDocEvent& evt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_event_issue_mail_doc()\n";
	}
	mupdf::ppdf_event_issue_mail_doc(doc.m_internal, evt.m_internal);
}


/* Wrapper for `pdf_event_issue_print()`.  */
FZ_FUNCTION void mpdf_event_issue_print(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_event_issue_print()\n";
	}
	mupdf::ppdf_event_issue_print(doc.m_internal);
}


/* Wrapper for `pdf_field_border_style()`.  */
FZ_FUNCTION char *mpdf_field_border_style(const PdfObj& field)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_border_style()\n";
	}
	auto ret = mupdf::ppdf_field_border_style(field.m_internal);
	return ret;
}


/* Wrapper for `pdf_field_display()`.  */
FZ_FUNCTION int mpdf_field_display(const PdfObj& field)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_display()\n";
	}
	auto ret = mupdf::ppdf_field_display(field.m_internal);
	return ret;
}


/* Wrapper for `pdf_field_event_calculate()`.  */
FZ_FUNCTION void mpdf_field_event_calculate(const PdfDocument& doc, const PdfObj& field)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_event_calculate()\n";
	}
	mupdf::ppdf_field_event_calculate(doc.m_internal, field.m_internal);
}


/* Wrapper for `pdf_field_event_format()`.  */
FZ_FUNCTION char *mpdf_field_event_format(const PdfDocument& doc, const PdfObj& field)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_event_format()\n";
	}
	auto ret = mupdf::ppdf_field_event_format(doc.m_internal, field.m_internal);
	return ret;
}


/* Wrapper for `pdf_field_event_keystroke()`.  */
FZ_FUNCTION int mpdf_field_event_keystroke(const PdfDocument& doc, const PdfObj& field, const PdfKeystrokeEvent& evt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_event_keystroke()\n";
	}
	auto ret = mupdf::ppdf_field_event_keystroke(doc.m_internal, field.m_internal, evt.m_internal);
	return ret;
}


/* Wrapper for `pdf_field_event_validate()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_field_event_validate(pdf_document *doc, pdf_obj *field, const char *value)` => `(int, char *newvalue)`
	 */
FZ_FUNCTION int mpdf_field_event_validate(const PdfDocument& doc, const PdfObj& field, const char *value, char **newvalue)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_event_validate()\n";
	}
	auto ret = mupdf::ppdf_field_event_validate(doc.m_internal, field.m_internal, value, newvalue);
	return ret;
}


/* Wrapper for `pdf_field_flags()`.  */
FZ_FUNCTION int mpdf_field_flags(const PdfObj& field)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_flags()\n";
	}
	auto ret = mupdf::ppdf_field_flags(field.m_internal);
	return ret;
}


/* Wrapper for `pdf_field_label()`.  */
FZ_FUNCTION const char *mpdf_field_label(const PdfObj& field)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_label()\n";
	}
	auto ret = mupdf::ppdf_field_label(field.m_internal);
	return ret;
}


/* Wrapper for `pdf_field_name()`.  */
FZ_FUNCTION char *mpdf_field_name(const PdfObj& field)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_name()\n";
	}
	auto ret = mupdf::ppdf_field_name(field.m_internal);
	return ret;
}


/* Wrapper for `pdf_field_reset()`.  */
FZ_FUNCTION void mpdf_field_reset(const PdfDocument& doc, const PdfObj& field)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_reset()\n";
	}
	mupdf::ppdf_field_reset(doc.m_internal, field.m_internal);
}


/* Wrapper for `pdf_field_set_border_style()`.  */
FZ_FUNCTION void mpdf_field_set_border_style(const PdfObj& field, const char *text)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_set_border_style()\n";
	}
	mupdf::ppdf_field_set_border_style(field.m_internal, text);
}


/* Wrapper for `pdf_field_set_button_caption()`.  */
FZ_FUNCTION void mpdf_field_set_button_caption(const PdfObj& field, const char *text)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_set_button_caption()\n";
	}
	mupdf::ppdf_field_set_button_caption(field.m_internal, text);
}


/* Wrapper for `pdf_field_set_display()`.  */
FZ_FUNCTION void mpdf_field_set_display(const PdfObj& field, int d)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_set_display()\n";
	}
	mupdf::ppdf_field_set_display(field.m_internal, d);
}


/* Wrapper for `pdf_field_set_fill_color()`.  */
FZ_FUNCTION void mpdf_field_set_fill_color(const PdfObj& field, const PdfObj& col)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_set_fill_color()\n";
	}
	mupdf::ppdf_field_set_fill_color(field.m_internal, col.m_internal);
}


/* Wrapper for `pdf_field_set_text_color()`.  */
FZ_FUNCTION void mpdf_field_set_text_color(const PdfObj& field, const PdfObj& col)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_set_text_color()\n";
	}
	mupdf::ppdf_field_set_text_color(field.m_internal, col.m_internal);
}


/* Wrapper for `pdf_field_type()`.  */
FZ_FUNCTION int mpdf_field_type(const PdfObj& field)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_type()\n";
	}
	auto ret = mupdf::ppdf_field_type(field.m_internal);
	return ret;
}


/* Wrapper for `pdf_field_type_string()`.  */
FZ_FUNCTION const char *mpdf_field_type_string(const PdfObj& field)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_type_string()\n";
	}
	auto ret = mupdf::ppdf_field_type_string(field.m_internal);
	return ret;
}


/* Wrapper for `pdf_field_value()`.  */
FZ_FUNCTION const char *mpdf_field_value(const PdfObj& field)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_value()\n";
	}
	auto ret = mupdf::ppdf_field_value(field.m_internal);
	return ret;
}


/* Wrapper for `pdf_filter_annot_contents()`.  */
FZ_FUNCTION void mpdf_filter_annot_contents(const PdfDocument& doc, const PdfAnnot& annot, PdfFilterOptions& filter)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_filter_annot_contents()\n";
	}
	mupdf::ppdf_filter_annot_contents(doc.m_internal, annot.m_internal, (pdf_filter_options *) &filter.opaque);
}


/* Wrapper for `pdf_filter_page_contents()`.  */
FZ_FUNCTION void mpdf_filter_page_contents(const PdfDocument& doc, const PdfPage& page, PdfFilterOptions& filter)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_filter_page_contents()\n";
	}
	mupdf::ppdf_filter_page_contents(doc.m_internal, page.m_internal, (pdf_filter_options *) &filter.opaque);
}


/* Wrapper for `pdf_filter_xobject_instance()`.  */
FZ_FUNCTION PdfObj mpdf_filter_xobject_instance(const PdfObj& old_xobj, const PdfObj& page_res, Matrix& ctm, PdfFilterOptions& filter)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_filter_xobject_instance()\n";
	}
	pdf_obj* temp = mupdf::ppdf_filter_xobject_instance(old_xobj.m_internal, page_res.m_internal, *(fz_matrix*) &ctm.a, (pdf_filter_options *) &filter.opaque);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_find_font_resource()`.  */
FZ_FUNCTION PdfObj mpdf_find_font_resource(const PdfDocument& doc, int type, int encoding, const Font& item, const PdfFontResourceKey& key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_find_font_resource()\n";
	}
	pdf_obj* temp = mupdf::ppdf_find_font_resource(doc.m_internal, type, encoding, item.m_internal, key.m_internal);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_find_item()`.  */
FZ_FUNCTION void *mpdf_find_item(fz_store_drop_fn *drop, const PdfObj& key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_find_item()\n";
	}
	auto ret = mupdf::ppdf_find_item(drop, key.m_internal);
	return ret;
}


/* Wrapper for `pdf_find_locked_fields()`.  */
FZ_FUNCTION pdf_locked_fields *mpdf_find_locked_fields(const PdfDocument& doc, int version)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_find_locked_fields()\n";
	}
	auto ret = mupdf::ppdf_find_locked_fields(doc.m_internal, version);
	return ret;
}


/* Wrapper for `pdf_find_locked_fields_for_sig()`.  */
FZ_FUNCTION pdf_locked_fields *mpdf_find_locked_fields_for_sig(const PdfDocument& doc, const PdfObj& sig)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_find_locked_fields_for_sig()\n";
	}
	auto ret = mupdf::ppdf_find_locked_fields_for_sig(doc.m_internal, sig.m_internal);
	return ret;
}


/* Wrapper for `pdf_find_version_for_obj()`.  */
FZ_FUNCTION int mpdf_find_version_for_obj(const PdfDocument& doc, const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_find_version_for_obj()\n";
	}
	auto ret = mupdf::ppdf_find_version_for_obj(doc.m_internal, obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_first_annot()`.  */
FZ_FUNCTION PdfAnnot mpdf_first_annot(const PdfPage& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_first_annot()\n";
	}
	pdf_annot* temp = mupdf::ppdf_first_annot(page.m_internal);
	mupdf::ppdf_keep_annot(temp);
	auto ret = PdfAnnot(temp);
	return ret;
}


/* Wrapper for `pdf_first_widget()`.  */
FZ_FUNCTION PdfAnnot mpdf_first_widget(const PdfPage& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_first_widget()\n";
	}
	pdf_annot* temp = mupdf::ppdf_first_widget(page.m_internal);
	mupdf::ppdf_keep_annot(temp);
	auto ret = PdfAnnot(temp);
	return ret;
}


/* Wrapper for `pdf_flatten_inheritable_page_items()`.  */
FZ_FUNCTION void mpdf_flatten_inheritable_page_items(const PdfObj& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_flatten_inheritable_page_items()\n";
	}
	mupdf::ppdf_flatten_inheritable_page_items(page.m_internal);
}


/* Wrapper for `pdf_font_cid_to_gid()`.  */
FZ_FUNCTION int mpdf_font_cid_to_gid(const PdfFontDesc& fontdesc, int cid)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_font_cid_to_gid()\n";
	}
	auto ret = mupdf::ppdf_font_cid_to_gid(fontdesc.m_internal, cid);
	return ret;
}


/* Wrapper for `pdf_font_writing_supported()`.  */
FZ_FUNCTION int mpdf_font_writing_supported(const Font& font)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_font_writing_supported()\n";
	}
	auto ret = mupdf::ppdf_font_writing_supported(font.m_internal);
	return ret;
}


/* Wrapper for `pdf_forget_xref()`.  */
FZ_FUNCTION void mpdf_forget_xref(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_forget_xref()\n";
	}
	mupdf::ppdf_forget_xref(doc.m_internal);
}


/* Wrapper for `pdf_format_date()`.  */
FZ_FUNCTION char *mpdf_format_date(int64_t time, char *s, size_t n)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_format_date()\n";
	}
	auto ret = mupdf::ppdf_format_date(time, s, n);
	return ret;
}


/* Wrapper for `pdf_format_link_uri()`.  */
FZ_FUNCTION char *mpdf_format_link_uri(const LinkDest& dest)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_format_link_uri()\n";
	}
	auto ret = mupdf::ppdf_format_link_uri(*dest.m_internal);
	return ret;
}


/* Wrapper for `pdf_format_write_options()`.  */
FZ_FUNCTION char *mpdf_format_write_options(char *buffer, size_t buffer_len, PdfWriteOptions& opts)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_format_write_options()\n";
	}
	auto ret = mupdf::ppdf_format_write_options(buffer, buffer_len, (const pdf_write_options *) &opts.do_incremental);
	return ret;
}


/* Wrapper for `pdf_function_size()`.  */
FZ_FUNCTION size_t mpdf_function_size(const PdfFunction& func)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_function_size()\n";
	}
	auto ret = mupdf::ppdf_function_size(func.m_internal);
	return ret;
}


/* Wrapper for `pdf_get_bound_document()`.  */
FZ_FUNCTION PdfDocument mpdf_get_bound_document(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_get_bound_document()\n";
	}
	pdf_document* temp = mupdf::ppdf_get_bound_document(obj.m_internal);
	mupdf::ppdf_keep_document(temp);
	auto ret = PdfDocument(temp);
	return ret;
}


/* Wrapper for `pdf_get_doc_event_callback_data()`.  */
FZ_FUNCTION void *mpdf_get_doc_event_callback_data(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_get_doc_event_callback_data()\n";
	}
	auto ret = mupdf::ppdf_get_doc_event_callback_data(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_get_incremental_xref_entry()`.  */
FZ_FUNCTION pdf_xref_entry *mpdf_get_incremental_xref_entry(const PdfDocument& doc, int i)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_get_incremental_xref_entry()\n";
	}
	auto ret = mupdf::ppdf_get_incremental_xref_entry(doc.m_internal, i);
	return ret;
}


/* Wrapper for `pdf_get_indirect_document()`.  */
FZ_FUNCTION PdfDocument mpdf_get_indirect_document(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_get_indirect_document()\n";
	}
	pdf_document* temp = mupdf::ppdf_get_indirect_document(obj.m_internal);
	mupdf::ppdf_keep_document(temp);
	auto ret = PdfDocument(temp);
	return ret;
}


/* Wrapper for `pdf_get_populating_xref_entry()`.  */
FZ_FUNCTION pdf_xref_entry *mpdf_get_populating_xref_entry(const PdfDocument& doc, int i)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_get_populating_xref_entry()\n";
	}
	auto ret = mupdf::ppdf_get_populating_xref_entry(doc.m_internal, i);
	return ret;
}


/* Wrapper for `pdf_get_widget_editing_state()`.  */
FZ_FUNCTION int mpdf_get_widget_editing_state(const PdfAnnot& widget)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_get_widget_editing_state()\n";
	}
	auto ret = mupdf::ppdf_get_widget_editing_state(widget.m_internal);
	return ret;
}


/* Wrapper for `pdf_get_xref_entry()`.  */
FZ_FUNCTION pdf_xref_entry *mpdf_get_xref_entry(const PdfDocument& doc, int i)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_get_xref_entry()\n";
	}
	auto ret = mupdf::ppdf_get_xref_entry(doc.m_internal, i);
	return ret;
}


/* Wrapper for `pdf_graft_mapped_object()`.  */
FZ_FUNCTION PdfObj mpdf_graft_mapped_object(const PdfGraftMap& map, const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_graft_mapped_object()\n";
	}
	pdf_obj* temp = mupdf::ppdf_graft_mapped_object(map.m_internal, obj.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_graft_mapped_page()`.  */
FZ_FUNCTION void mpdf_graft_mapped_page(const PdfGraftMap& map, int page_to, const PdfDocument& src, int page_from)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_graft_mapped_page()\n";
	}
	mupdf::ppdf_graft_mapped_page(map.m_internal, page_to, src.m_internal, page_from);
}


/* Wrapper for `pdf_graft_object()`.  */
FZ_FUNCTION PdfObj mpdf_graft_object(const PdfDocument& dst, const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_graft_object()\n";
	}
	pdf_obj* temp = mupdf::ppdf_graft_object(dst.m_internal, obj.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_graft_page()`.  */
FZ_FUNCTION void mpdf_graft_page(const PdfDocument& dst, int page_to, const PdfDocument& src, int page_from)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_graft_page()\n";
	}
	mupdf::ppdf_graft_page(dst.m_internal, page_to, src.m_internal, page_from);
}


/* Wrapper for `pdf_guess_mime_type_from_file_name()`.  */
FZ_FUNCTION const char *mpdf_guess_mime_type_from_file_name(const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_guess_mime_type_from_file_name()\n";
	}
	auto ret = mupdf::ppdf_guess_mime_type_from_file_name(filename);
	return ret;
}


/* Wrapper for `pdf_has_permission()`.  */
FZ_FUNCTION int mpdf_has_permission(const PdfDocument& doc, fz_permission p)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_has_permission()\n";
	}
	auto ret = mupdf::ppdf_has_permission(doc.m_internal, p);
	return ret;
}


/* Wrapper for `pdf_has_unsaved_changes()`.  */
FZ_FUNCTION int mpdf_has_unsaved_changes(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_has_unsaved_changes()\n";
	}
	auto ret = mupdf::ppdf_has_unsaved_changes(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_has_unsaved_sigs()`.  */
FZ_FUNCTION int mpdf_has_unsaved_sigs(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_has_unsaved_sigs()\n";
	}
	auto ret = mupdf::ppdf_has_unsaved_sigs(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_insert_font_resource()`.  */
FZ_FUNCTION PdfObj mpdf_insert_font_resource(const PdfDocument& doc, const PdfFontResourceKey& key, const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_insert_font_resource()\n";
	}
	pdf_obj* temp = mupdf::ppdf_insert_font_resource(doc.m_internal, key.m_internal, obj.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_insert_page()`.  */
FZ_FUNCTION void mpdf_insert_page(const PdfDocument& doc, int at, const PdfObj& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_insert_page()\n";
	}
	mupdf::ppdf_insert_page(doc.m_internal, at, page.m_internal);
}


/* Wrapper for `pdf_invalidate_xfa()`.  */
FZ_FUNCTION void mpdf_invalidate_xfa(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_invalidate_xfa()\n";
	}
	mupdf::ppdf_invalidate_xfa(doc.m_internal);
}


/* Wrapper for `pdf_is_array()`.  */
FZ_FUNCTION int mpdf_is_array(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_array()\n";
	}
	auto ret = mupdf::ppdf_is_array(obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_is_bool()`.  */
FZ_FUNCTION int mpdf_is_bool(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_bool()\n";
	}
	auto ret = mupdf::ppdf_is_bool(obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_is_dict()`.  */
FZ_FUNCTION int mpdf_is_dict(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_dict()\n";
	}
	auto ret = mupdf::ppdf_is_dict(obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_is_embedded_file()`.  */
FZ_FUNCTION int mpdf_is_embedded_file(const PdfObj& fs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_embedded_file()\n";
	}
	auto ret = mupdf::ppdf_is_embedded_file(fs.m_internal);
	return ret;
}


/* Wrapper for `pdf_is_field_locked()`.  */
FZ_FUNCTION int mpdf_is_field_locked(const PdfLockedFields& locked, const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_field_locked()\n";
	}
	auto ret = mupdf::ppdf_is_field_locked(locked.m_internal, name);
	return ret;
}


/* Wrapper for `pdf_is_indirect()`.  */
FZ_FUNCTION int mpdf_is_indirect(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_indirect()\n";
	}
	auto ret = mupdf::ppdf_is_indirect(obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_is_int()`.  */
FZ_FUNCTION int mpdf_is_int(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_int()\n";
	}
	auto ret = mupdf::ppdf_is_int(obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_is_jpx_image()`.  */
FZ_FUNCTION int mpdf_is_jpx_image(const PdfObj& dict)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_jpx_image()\n";
	}
	auto ret = mupdf::ppdf_is_jpx_image(dict.m_internal);
	return ret;
}


/* Wrapper for `pdf_is_local_object()`.  */
FZ_FUNCTION int mpdf_is_local_object(const PdfDocument& doc, const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_local_object()\n";
	}
	auto ret = mupdf::ppdf_is_local_object(doc.m_internal, obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_is_name()`.  */
FZ_FUNCTION int mpdf_is_name(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_name()\n";
	}
	auto ret = mupdf::ppdf_is_name(obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_is_null()`.  */
FZ_FUNCTION int mpdf_is_null(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_null()\n";
	}
	auto ret = mupdf::ppdf_is_null(obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_is_number()`.  */
FZ_FUNCTION int mpdf_is_number(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_number()\n";
	}
	auto ret = mupdf::ppdf_is_number(obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_is_ocg_hidden()`.  */
FZ_FUNCTION int mpdf_is_ocg_hidden(const PdfDocument& doc, const PdfObj& rdb, const char *usage, const PdfObj& ocg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_ocg_hidden()\n";
	}
	auto ret = mupdf::ppdf_is_ocg_hidden(doc.m_internal, rdb.m_internal, usage, ocg.m_internal);
	return ret;
}


/* Wrapper for `pdf_is_real()`.  */
FZ_FUNCTION int mpdf_is_real(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_real()\n";
	}
	auto ret = mupdf::ppdf_is_real(obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_is_stream()`.  */
FZ_FUNCTION int mpdf_is_stream(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_stream()\n";
	}
	auto ret = mupdf::ppdf_is_stream(obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_is_string()`.  */
FZ_FUNCTION int mpdf_is_string(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_string()\n";
	}
	auto ret = mupdf::ppdf_is_string(obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_is_tint_colorspace()`.  */
FZ_FUNCTION int mpdf_is_tint_colorspace(const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_tint_colorspace()\n";
	}
	auto ret = mupdf::ppdf_is_tint_colorspace(cs.m_internal);
	return ret;
}


/* Wrapper for `pdf_js_event_init()`.  */
FZ_FUNCTION void mpdf_js_event_init(const PdfJs& js, const PdfObj& target, const char *value, int willCommit)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_js_event_init()\n";
	}
	mupdf::ppdf_js_event_init(js.m_internal, target.m_internal, value, willCommit);
}


/* Wrapper for `pdf_js_event_init_keystroke()`.  */
FZ_FUNCTION void mpdf_js_event_init_keystroke(const PdfJs& js, const PdfObj& target, const PdfKeystrokeEvent& evt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_js_event_init_keystroke()\n";
	}
	mupdf::ppdf_js_event_init_keystroke(js.m_internal, target.m_internal, evt.m_internal);
}


/* Wrapper for `pdf_js_event_result()`.  */
FZ_FUNCTION int mpdf_js_event_result(const PdfJs& js)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_js_event_result()\n";
	}
	auto ret = mupdf::ppdf_js_event_result(js.m_internal);
	return ret;
}


/* Wrapper for `pdf_js_event_result_keystroke()`.  */
FZ_FUNCTION int mpdf_js_event_result_keystroke(const PdfJs& js, const PdfKeystrokeEvent& evt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_js_event_result_keystroke()\n";
	}
	auto ret = mupdf::ppdf_js_event_result_keystroke(js.m_internal, evt.m_internal);
	return ret;
}


/* Wrapper for `pdf_js_event_result_validate()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_js_event_result_validate(pdf_js *js)` => `(int, char *newvalue)`
	 */
FZ_FUNCTION int mpdf_js_event_result_validate(const PdfJs& js, char **newvalue)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_js_event_result_validate()\n";
	}
	auto ret = mupdf::ppdf_js_event_result_validate(js.m_internal, newvalue);
	return ret;
}


/* Wrapper for `pdf_js_event_value()`.  */
FZ_FUNCTION char *mpdf_js_event_value(const PdfJs& js)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_js_event_value()\n";
	}
	auto ret = mupdf::ppdf_js_event_value(js.m_internal);
	return ret;
}


/* Wrapper for `pdf_js_execute()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_js_execute(pdf_js *js, const char *name, const char *code)` => char *result
	 */
FZ_FUNCTION void mpdf_js_execute(const PdfJs& js, const char *name, const char *code, char **result)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_js_execute()\n";
	}
	mupdf::ppdf_js_execute(js.m_internal, name, code, result);
}


/* Wrapper for `pdf_js_get_console()`.  */
FZ_FUNCTION pdf_js_console *mpdf_js_get_console(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_js_get_console()\n";
	}
	auto ret = mupdf::ppdf_js_get_console(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_js_set_console()`.  */
FZ_FUNCTION void mpdf_js_set_console(const PdfDocument& doc, const PdfJsConsole& console, void *user)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_js_set_console()\n";
	}
	mupdf::ppdf_js_set_console(doc.m_internal, console.m_internal, user);
}


/* Wrapper for `pdf_js_supported()`.  */
FZ_FUNCTION int mpdf_js_supported(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_js_supported()\n";
	}
	auto ret = mupdf::ppdf_js_supported(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_keep_annot()`.  */
FZ_FUNCTION PdfAnnot mpdf_keep_annot(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_keep_annot()\n";
	}
	pdf_annot* temp = mupdf::ppdf_keep_annot(annot.m_internal);
	auto ret = PdfAnnot(temp);
	return ret;
}


/* Wrapper for `pdf_keep_cmap()`.  */
FZ_FUNCTION PdfCmap mpdf_keep_cmap(const PdfCmap& cmap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_keep_cmap()\n";
	}
	pdf_cmap* temp = mupdf::ppdf_keep_cmap(cmap.m_internal);
	auto ret = PdfCmap(temp);
	return ret;
}


/* Wrapper for `pdf_keep_document()`.  */
FZ_FUNCTION PdfDocument mpdf_keep_document(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_keep_document()\n";
	}
	pdf_document* temp = mupdf::ppdf_keep_document(doc.m_internal);
	auto ret = PdfDocument(temp);
	return ret;
}


/* Wrapper for `pdf_keep_font()`.  */
FZ_FUNCTION pdf_font_desc *mpdf_keep_font(const PdfFontDesc& fontdesc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_keep_font()\n";
	}
	auto ret = mupdf::ppdf_keep_font(fontdesc.m_internal);
	return ret;
}


/* Wrapper for `pdf_keep_function()`.  */
FZ_FUNCTION PdfFunction mpdf_keep_function(const PdfFunction& func)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_keep_function()\n";
	}
	pdf_function* temp = mupdf::ppdf_keep_function(func.m_internal);
	auto ret = PdfFunction(temp);
	return ret;
}


/* Wrapper for `pdf_keep_graft_map()`.  */
FZ_FUNCTION PdfGraftMap mpdf_keep_graft_map(const PdfGraftMap& map)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_keep_graft_map()\n";
	}
	pdf_graft_map* temp = mupdf::ppdf_keep_graft_map(map.m_internal);
	auto ret = PdfGraftMap(temp);
	return ret;
}


/* Wrapper for `pdf_keep_obj()`.  */
FZ_FUNCTION PdfObj mpdf_keep_obj(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_keep_obj()\n";
	}
	pdf_obj* temp = mupdf::ppdf_keep_obj(obj.m_internal);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_keep_pattern()`.  */
FZ_FUNCTION PdfPattern mpdf_keep_pattern(const PdfPattern& pat)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_keep_pattern()\n";
	}
	pdf_pattern* temp = mupdf::ppdf_keep_pattern(pat.m_internal);
	auto ret = PdfPattern(temp);
	return ret;
}


/* Wrapper for `pdf_keep_processor()`.  */
FZ_FUNCTION PdfProcessor mpdf_keep_processor(const PdfProcessor& proc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_keep_processor()\n";
	}
	pdf_processor* temp = mupdf::ppdf_keep_processor(proc.m_internal);
	auto ret = PdfProcessor(temp);
	return ret;
}


/* Wrapper for `pdf_keep_widget()`.  */
FZ_FUNCTION PdfAnnot mpdf_keep_widget(const PdfAnnot& widget)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_keep_widget()\n";
	}
	pdf_annot* temp = mupdf::ppdf_keep_widget(widget.m_internal);
	auto ret = PdfAnnot(temp);
	return ret;
}


/* Wrapper for `pdf_layer_config_info()`.  */
FZ_FUNCTION void mpdf_layer_config_info(const PdfDocument& doc, int config_num, PdfLayerConfig& info)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_layer_config_info()\n";
	}
	mupdf::ppdf_layer_config_info(doc.m_internal, config_num, (pdf_layer_config *) &info.name);
}


/* Wrapper for `pdf_layer_config_ui_info()`.  */
FZ_FUNCTION void mpdf_layer_config_ui_info(const PdfDocument& doc, int ui, PdfLayerConfigUi& info)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_layer_config_ui_info()\n";
	}
	mupdf::ppdf_layer_config_ui_info(doc.m_internal, ui, (pdf_layer_config_ui *) &info.text);
}


/* Wrapper for `pdf_layout_fit_text()`.  */
FZ_FUNCTION Text mpdf_layout_fit_text(const Font& font, fz_text_language lang, const char *str, Rect& bounds)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_layout_fit_text()\n";
	}
	fz_text* temp = mupdf::ppdf_layout_fit_text(font.m_internal, lang, str, *(fz_rect*) &bounds.x0);
	mupdf::keep_text(temp);
	auto ret = Text(temp);
	return ret;
}


/* Wrapper for `pdf_layout_text_widget()`.  */
FZ_FUNCTION fz_layout_block *mpdf_layout_text_widget(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_layout_text_widget()\n";
	}
	auto ret = mupdf::ppdf_layout_text_widget(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_lex()`.  */
FZ_FUNCTION pdf_token mpdf_lex(const Stream& f, const PdfLexbuf& lexbuf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lex()\n";
	}
	auto ret = mupdf::ppdf_lex(f.m_internal, lexbuf.m_internal);
	return ret;
}


/* Wrapper for `pdf_lex_no_string()`.  */
FZ_FUNCTION pdf_token mpdf_lex_no_string(const Stream& f, const PdfLexbuf& lexbuf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lex_no_string()\n";
	}
	auto ret = mupdf::ppdf_lex_no_string(f.m_internal, lexbuf.m_internal);
	return ret;
}


/* Wrapper for `pdf_lexbuf_fin()`.  */
FZ_FUNCTION void mpdf_lexbuf_fin(const PdfLexbuf& lexbuf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lexbuf_fin()\n";
	}
	mupdf::ppdf_lexbuf_fin(lexbuf.m_internal);
}


/* Wrapper for `pdf_lexbuf_grow()`.  */
FZ_FUNCTION ptrdiff_t mpdf_lexbuf_grow(const PdfLexbuf& lexbuf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lexbuf_grow()\n";
	}
	auto ret = mupdf::ppdf_lexbuf_grow(lexbuf.m_internal);
	return ret;
}


/* Wrapper for `pdf_lexbuf_init()`.  */
FZ_FUNCTION void mpdf_lexbuf_init(const PdfLexbuf& lexbuf, int size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lexbuf_init()\n";
	}
	mupdf::ppdf_lexbuf_init(lexbuf.m_internal, size);
}


/* Wrapper for `pdf_line_ending_from_name()`.  */
FZ_FUNCTION enum pdf_line_ending mpdf_line_ending_from_name(const PdfObj& end)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_line_ending_from_name()\n";
	}
	auto ret = mupdf::ppdf_line_ending_from_name(end.m_internal);
	return ret;
}


/* Wrapper for `pdf_line_ending_from_string()`.  */
FZ_FUNCTION enum pdf_line_ending mpdf_line_ending_from_string(const char *end)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_line_ending_from_string()\n";
	}
	auto ret = mupdf::ppdf_line_ending_from_string(end);
	return ret;
}


/* Wrapper for `pdf_load_builtin_cmap()`.  */
FZ_FUNCTION PdfCmap mpdf_load_builtin_cmap(const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_builtin_cmap()\n";
	}
	pdf_cmap* temp = mupdf::ppdf_load_builtin_cmap(name);
	auto ret = PdfCmap(temp);
	return ret;
}


/* Wrapper for `pdf_load_cmap()`.  */
FZ_FUNCTION PdfCmap mpdf_load_cmap(const Stream& file)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_cmap()\n";
	}
	pdf_cmap* temp = mupdf::ppdf_load_cmap(file.m_internal);
	auto ret = PdfCmap(temp);
	return ret;
}


/* Wrapper for `pdf_load_colorspace()`.  */
FZ_FUNCTION Colorspace mpdf_load_colorspace(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_colorspace()\n";
	}
	fz_colorspace* temp = mupdf::ppdf_load_colorspace(obj.m_internal);
	auto ret = Colorspace(temp);
	return ret;
}


/* Wrapper for `pdf_load_compressed_inline_image()`.  */
FZ_FUNCTION void mpdf_load_compressed_inline_image(const PdfDocument& doc, const PdfObj& dict, int length, const Stream& cstm, int indexed, const CompressedImage& image)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_compressed_inline_image()\n";
	}
	mupdf::ppdf_load_compressed_inline_image(doc.m_internal, dict.m_internal, length, cstm.m_internal, indexed, image.m_internal);
}


/* Wrapper for `pdf_load_compressed_stream()`.  */
FZ_FUNCTION fz_compressed_buffer *mpdf_load_compressed_stream(const PdfDocument& doc, int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_compressed_stream()\n";
	}
	auto ret = mupdf::ppdf_load_compressed_stream(doc.m_internal, num);
	return ret;
}


/* Wrapper for `pdf_load_default_colorspaces()`.  */
FZ_FUNCTION DefaultColorspaces mpdf_load_default_colorspaces(const PdfDocument& doc, const PdfPage& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_default_colorspaces()\n";
	}
	fz_default_colorspaces* temp = mupdf::ppdf_load_default_colorspaces(doc.m_internal, page.m_internal);
	auto ret = DefaultColorspaces(temp);
	return ret;
}


/* Wrapper for `pdf_load_embedded_cmap()`.  */
FZ_FUNCTION PdfCmap mpdf_load_embedded_cmap(const PdfDocument& doc, const PdfObj& ref)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_embedded_cmap()\n";
	}
	pdf_cmap* temp = mupdf::ppdf_load_embedded_cmap(doc.m_internal, ref.m_internal);
	auto ret = PdfCmap(temp);
	return ret;
}


/* Wrapper for `pdf_load_embedded_file()`.  */
FZ_FUNCTION Buffer mpdf_load_embedded_file(const PdfObj& fs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_embedded_file()\n";
	}
	fz_buffer* temp = mupdf::ppdf_load_embedded_file(fs.m_internal);
	auto ret = Buffer(temp);
	return ret;
}


/* Wrapper for `pdf_load_encoding()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_load_encoding(const char *encoding)` => const char *estrings
	 */
FZ_FUNCTION void mpdf_load_encoding(const char **estrings, const char *encoding)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_encoding()\n";
	}
	mupdf::ppdf_load_encoding(estrings, encoding);
}


/* Wrapper for `pdf_load_font()`.  */
FZ_FUNCTION pdf_font_desc *mpdf_load_font(const PdfDocument& doc, const PdfObj& rdb, const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_font()\n";
	}
	auto ret = mupdf::ppdf_load_font(doc.m_internal, rdb.m_internal, obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_load_function()`.  */
FZ_FUNCTION PdfFunction mpdf_load_function(const PdfObj& ref, int in, int out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_function()\n";
	}
	pdf_function* temp = mupdf::ppdf_load_function(ref.m_internal, in, out);
	auto ret = PdfFunction(temp);
	return ret;
}


/* Wrapper for `pdf_load_hail_mary_font()`.  */
FZ_FUNCTION pdf_font_desc *mpdf_load_hail_mary_font(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_hail_mary_font()\n";
	}
	auto ret = mupdf::ppdf_load_hail_mary_font(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_load_image()`.  */
FZ_FUNCTION Image mpdf_load_image(const PdfDocument& doc, const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_image()\n";
	}
	fz_image* temp = mupdf::ppdf_load_image(doc.m_internal, obj.m_internal);
	auto ret = Image(temp);
	return ret;
}


/* Wrapper for `pdf_load_inline_image()`.  */
FZ_FUNCTION Image mpdf_load_inline_image(const PdfDocument& doc, const PdfObj& rdb, const PdfObj& dict, const Stream& file)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_inline_image()\n";
	}
	fz_image* temp = mupdf::ppdf_load_inline_image(doc.m_internal, rdb.m_internal, dict.m_internal, file.m_internal);
	auto ret = Image(temp);
	return ret;
}


/* Wrapper for `pdf_load_journal()`.  */
FZ_FUNCTION void mpdf_load_journal(const PdfDocument& doc, const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_journal()\n";
	}
	mupdf::ppdf_load_journal(doc.m_internal, filename);
}


/* Wrapper for `pdf_load_link_annots()`.  */
FZ_FUNCTION Link mpdf_load_link_annots(const PdfDocument& arg_0, const PdfObj& annots, int pagenum, Matrix& page_ctm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_link_annots()\n";
	}
	fz_link* temp = mupdf::ppdf_load_link_annots(arg_0.m_internal, annots.m_internal, pagenum, *(fz_matrix*) &page_ctm.a);
	auto ret = Link(temp);
	return ret;
}


/* Wrapper for `pdf_load_links()`.  */
FZ_FUNCTION Link mpdf_load_links(const PdfPage& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_links()\n";
	}
	fz_link* temp = mupdf::ppdf_load_links(page.m_internal);
	auto ret = Link(temp);
	return ret;
}


/* Wrapper for `pdf_load_name_tree()`.  */
FZ_FUNCTION PdfObj mpdf_load_name_tree(const PdfDocument& doc, const PdfObj& which)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_name_tree()\n";
	}
	pdf_obj* temp = mupdf::ppdf_load_name_tree(doc.m_internal, which.m_internal);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_load_object()`.  */
FZ_FUNCTION PdfObj mpdf_load_object(const PdfDocument& doc, int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_object()\n";
	}
	pdf_obj* temp = mupdf::ppdf_load_object(doc.m_internal, num);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_load_outline()`.  */
FZ_FUNCTION Outline mpdf_load_outline(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_outline()\n";
	}
	fz_outline* temp = mupdf::ppdf_load_outline(doc.m_internal);
	auto ret = Outline(temp);
	return ret;
}


/* Wrapper for `pdf_load_page()`.  */
FZ_FUNCTION PdfPage mpdf_load_page(const PdfDocument& doc, int number)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_page()\n";
	}
	pdf_page* temp = mupdf::ppdf_load_page(doc.m_internal, number);
	auto ret = PdfPage(temp);
	return ret;
}


/* Wrapper for `pdf_load_page_imp()`.  */
FZ_FUNCTION Page mpdf_load_page_imp(const Document& doc, int chapter, int number)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_page_imp()\n";
	}
	fz_page* temp = mupdf::ppdf_load_page_imp(doc.m_internal, chapter, number);
	auto ret = Page(temp);
	return ret;
}


/* Wrapper for `pdf_load_page_tree()`.  */
FZ_FUNCTION void mpdf_load_page_tree(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_page_tree()\n";
	}
	mupdf::ppdf_load_page_tree(doc.m_internal);
}


/* Wrapper for `pdf_load_pattern()`.  */
FZ_FUNCTION PdfPattern mpdf_load_pattern(const PdfDocument& doc, const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_pattern()\n";
	}
	pdf_pattern* temp = mupdf::ppdf_load_pattern(doc.m_internal, obj.m_internal);
	auto ret = PdfPattern(temp);
	return ret;
}


/* Wrapper for `pdf_load_raw_stream()`.  */
FZ_FUNCTION Buffer mpdf_load_raw_stream(const PdfObj& ref)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_raw_stream()\n";
	}
	fz_buffer* temp = mupdf::ppdf_load_raw_stream(ref.m_internal);
	auto ret = Buffer(temp);
	return ret;
}


/* Wrapper for `pdf_load_raw_stream_number()`.  */
FZ_FUNCTION Buffer mpdf_load_raw_stream_number(const PdfDocument& doc, int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_raw_stream_number()\n";
	}
	fz_buffer* temp = mupdf::ppdf_load_raw_stream_number(doc.m_internal, num);
	auto ret = Buffer(temp);
	return ret;
}


/* Wrapper for `pdf_load_shading()`.  */
FZ_FUNCTION Shade mpdf_load_shading(const PdfDocument& doc, const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_shading()\n";
	}
	fz_shade* temp = mupdf::ppdf_load_shading(doc.m_internal, obj.m_internal);
	auto ret = Shade(temp);
	return ret;
}


/* Wrapper for `pdf_load_stream()`.  */
FZ_FUNCTION Buffer mpdf_load_stream(const PdfObj& ref)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_stream()\n";
	}
	fz_buffer* temp = mupdf::ppdf_load_stream(ref.m_internal);
	auto ret = Buffer(temp);
	return ret;
}


/* Wrapper for `pdf_load_stream_number()`.  */
FZ_FUNCTION Buffer mpdf_load_stream_number(const PdfDocument& doc, int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_stream_number()\n";
	}
	fz_buffer* temp = mupdf::ppdf_load_stream_number(doc.m_internal, num);
	auto ret = Buffer(temp);
	return ret;
}


/* Wrapper for `pdf_load_stream_or_string_as_utf8()`.  */
FZ_FUNCTION char *mpdf_load_stream_or_string_as_utf8(const PdfObj& src)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_stream_or_string_as_utf8()\n";
	}
	auto ret = mupdf::ppdf_load_stream_or_string_as_utf8(src.m_internal);
	return ret;
}


/* Wrapper for `pdf_load_system_cmap()`.  */
FZ_FUNCTION PdfCmap mpdf_load_system_cmap(const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_system_cmap()\n";
	}
	pdf_cmap* temp = mupdf::ppdf_load_system_cmap(name);
	auto ret = PdfCmap(temp);
	return ret;
}


/* Wrapper for `pdf_load_to_unicode()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_load_to_unicode(pdf_document *doc, pdf_font_desc *font, char *collection, pdf_obj *cmapstm)` => const char *strings
	 */
FZ_FUNCTION void mpdf_load_to_unicode(const PdfDocument& doc, const PdfFontDesc& font, const char **strings, char *collection, const PdfObj& cmapstm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_to_unicode()\n";
	}
	mupdf::ppdf_load_to_unicode(doc.m_internal, font.m_internal, strings, collection, cmapstm.m_internal);
}


/* Wrapper for `pdf_load_type3_font()`.  */
FZ_FUNCTION pdf_font_desc *mpdf_load_type3_font(const PdfDocument& doc, const PdfObj& rdb, const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_type3_font()\n";
	}
	auto ret = mupdf::ppdf_load_type3_font(doc.m_internal, rdb.m_internal, obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_load_type3_glyphs()`.  */
FZ_FUNCTION void mpdf_load_type3_glyphs(const PdfDocument& doc, const PdfFontDesc& fontdesc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_type3_glyphs()\n";
	}
	mupdf::ppdf_load_type3_glyphs(doc.m_internal, fontdesc.m_internal);
}


/* Wrapper for `pdf_load_unencrypted_object()`.  */
FZ_FUNCTION PdfObj mpdf_load_unencrypted_object(const PdfDocument& doc, int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_unencrypted_object()\n";
	}
	pdf_obj* temp = mupdf::ppdf_load_unencrypted_object(doc.m_internal, num);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_lookup_anchor()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_lookup_anchor(pdf_document *doc, const char *name)` => `(int, float xp, float yp)`
	 */
FZ_FUNCTION int mpdf_lookup_anchor(const PdfDocument& doc, const char *name, float *xp, float *yp)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lookup_anchor()\n";
	}
	auto ret = mupdf::ppdf_lookup_anchor(doc.m_internal, name, xp, yp);
	return ret;
}


/* Wrapper for `pdf_lookup_cmap()`.  */
FZ_FUNCTION int mpdf_lookup_cmap(const PdfCmap& cmap, unsigned int cpt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lookup_cmap()\n";
	}
	auto ret = mupdf::ppdf_lookup_cmap(cmap.m_internal, cpt);
	return ret;
}


/* Wrapper for `pdf_lookup_cmap_full()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_lookup_cmap_full(pdf_cmap *cmap, unsigned int cpt)` => `(int, int out)`
	 */
FZ_FUNCTION int mpdf_lookup_cmap_full(const PdfCmap& cmap, unsigned int cpt, int *out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lookup_cmap_full()\n";
	}
	auto ret = mupdf::ppdf_lookup_cmap_full(cmap.m_internal, cpt, out);
	return ret;
}


/* Wrapper for `pdf_lookup_dest()`.  */
FZ_FUNCTION PdfObj mpdf_lookup_dest(const PdfDocument& doc, const PdfObj& needle)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lookup_dest()\n";
	}
	pdf_obj* temp = mupdf::ppdf_lookup_dest(doc.m_internal, needle.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_lookup_field()`.  */
FZ_FUNCTION PdfObj mpdf_lookup_field(const PdfObj& form, const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lookup_field()\n";
	}
	pdf_obj* temp = mupdf::ppdf_lookup_field(form.m_internal, name);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_lookup_metadata()`.  */
FZ_FUNCTION int mpdf_lookup_metadata(const PdfDocument& doc, const char *key, char *ptr, int size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lookup_metadata()\n";
	}
	auto ret = mupdf::ppdf_lookup_metadata(doc.m_internal, key, ptr, size);
	return ret;
}


/* Wrapper for `pdf_lookup_name()`.  */
FZ_FUNCTION PdfObj mpdf_lookup_name(const PdfDocument& doc, const PdfObj& which, const PdfObj& needle)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lookup_name()\n";
	}
	pdf_obj* temp = mupdf::ppdf_lookup_name(doc.m_internal, which.m_internal, needle.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_lookup_number()`.  */
FZ_FUNCTION PdfObj mpdf_lookup_number(const PdfObj& root, int needle)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lookup_number()\n";
	}
	pdf_obj* temp = mupdf::ppdf_lookup_number(root.m_internal, needle);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_lookup_page_number()`.  */
FZ_FUNCTION int mpdf_lookup_page_number(const PdfDocument& doc, const PdfObj& pageobj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lookup_page_number()\n";
	}
	auto ret = mupdf::ppdf_lookup_page_number(doc.m_internal, pageobj.m_internal);
	return ret;
}


/* Wrapper for `pdf_lookup_page_obj()`.  */
FZ_FUNCTION PdfObj mpdf_lookup_page_obj(const PdfDocument& doc, int needle)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lookup_page_obj()\n";
	}
	pdf_obj* temp = mupdf::ppdf_lookup_page_obj(doc.m_internal, needle);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_lookup_substitute_font()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_lookup_substitute_font(int mono, int serif, int bold, int italic)` => `(const unsigned char *, int len)`
	 */
FZ_FUNCTION const unsigned char *mpdf_lookup_substitute_font(int mono, int serif, int bold, int italic, int *len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lookup_substitute_font()\n";
	}
	auto ret = mupdf::ppdf_lookup_substitute_font(mono, serif, bold, italic, len);
	return ret;
}


/* Wrapper for `pdf_map_one_to_many()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_map_one_to_many(pdf_cmap *cmap, unsigned int one, size_t len)` => int many
	 */
FZ_FUNCTION void mpdf_map_one_to_many(const PdfCmap& cmap, unsigned int one, int *many, size_t len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_map_one_to_many()\n";
	}
	mupdf::ppdf_map_one_to_many(cmap.m_internal, one, many, len);
}


/* Wrapper for `pdf_map_range_to_range()`.  */
FZ_FUNCTION void mpdf_map_range_to_range(const PdfCmap& cmap, unsigned int srclo, unsigned int srchi, int dstlo)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_map_range_to_range()\n";
	}
	mupdf::ppdf_map_range_to_range(cmap.m_internal, srclo, srchi, dstlo);
}


/* Wrapper for `pdf_mark_list_free()`.  */
FZ_FUNCTION void mpdf_mark_list_free(const PdfMarkList& list)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_mark_list_free()\n";
	}
	mupdf::ppdf_mark_list_free(list.m_internal);
}


/* Wrapper for `pdf_mark_list_init()`.  */
FZ_FUNCTION void mpdf_mark_list_init(const PdfMarkList& list)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_mark_list_init()\n";
	}
	mupdf::ppdf_mark_list_init(list.m_internal);
}


/* Wrapper for `pdf_mark_list_pop()`.  */
FZ_FUNCTION void mpdf_mark_list_pop(const PdfMarkList& list)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_mark_list_pop()\n";
	}
	mupdf::ppdf_mark_list_pop(list.m_internal);
}


/* Wrapper for `pdf_mark_list_push()`.  */
FZ_FUNCTION int mpdf_mark_list_push(const PdfMarkList& list, const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_mark_list_push()\n";
	}
	auto ret = mupdf::ppdf_mark_list_push(list.m_internal, obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_mark_obj()`.  */
FZ_FUNCTION int mpdf_mark_obj(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_mark_obj()\n";
	}
	auto ret = mupdf::ppdf_mark_obj(obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_mark_xref()`.  */
FZ_FUNCTION void mpdf_mark_xref(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_mark_xref()\n";
	}
	mupdf::ppdf_mark_xref(doc.m_internal);
}


/* Wrapper for `pdf_metadata()`.  */
FZ_FUNCTION PdfObj mpdf_metadata(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_metadata()\n";
	}
	pdf_obj* temp = mupdf::ppdf_metadata(doc.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_name_eq()`.  */
FZ_FUNCTION int mpdf_name_eq(const PdfObj& a, const PdfObj& b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_name_eq()\n";
	}
	auto ret = mupdf::ppdf_name_eq(a.m_internal, b.m_internal);
	return ret;
}


/* Wrapper for `pdf_name_from_line_ending()`.  */
FZ_FUNCTION PdfObj mpdf_name_from_line_ending(enum pdf_line_ending end)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_name_from_line_ending()\n";
	}
	pdf_obj* temp = mupdf::ppdf_name_from_line_ending(end);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_needs_password()`.  */
FZ_FUNCTION int mpdf_needs_password(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_needs_password()\n";
	}
	auto ret = mupdf::ppdf_needs_password(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_new_action_from_link()`.  */
FZ_FUNCTION PdfObj mpdf_new_action_from_link(const PdfDocument& doc, const char *uri)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_action_from_link()\n";
	}
	pdf_obj* temp = mupdf::ppdf_new_action_from_link(doc.m_internal, uri);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_new_array()`.  */
FZ_FUNCTION PdfObj mpdf_new_array(const PdfDocument& doc, int initialcap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_array()\n";
	}
	pdf_obj* temp = mupdf::ppdf_new_array(doc.m_internal, initialcap);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_new_buffer_processor()`.  */
FZ_FUNCTION PdfProcessor mpdf_new_buffer_processor(const Buffer& buffer, int ahxencode)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_buffer_processor()\n";
	}
	pdf_processor* temp = mupdf::ppdf_new_buffer_processor(buffer.m_internal, ahxencode);
	auto ret = PdfProcessor(temp);
	return ret;
}


/* Wrapper for `pdf_new_cmap()`.  */
FZ_FUNCTION PdfCmap mpdf_new_cmap()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_cmap()\n";
	}
	pdf_cmap* temp = mupdf::ppdf_new_cmap();
	auto ret = PdfCmap(temp);
	return ret;
}


/* Wrapper for `pdf_new_crypt()`.  */
FZ_FUNCTION pdf_crypt *mpdf_new_crypt(const PdfObj& enc, const PdfObj& id)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_crypt()\n";
	}
	auto ret = mupdf::ppdf_new_crypt(enc.m_internal, id.m_internal);
	return ret;
}


/* Wrapper for `pdf_new_date()`.  */
FZ_FUNCTION PdfObj mpdf_new_date(const PdfDocument& doc, int64_t time)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_date()\n";
	}
	pdf_obj* temp = mupdf::ppdf_new_date(doc.m_internal, time);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_new_destination_from_link()`.  */
FZ_FUNCTION PdfObj mpdf_new_destination_from_link(const PdfDocument& doc, const char *uri)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_destination_from_link()\n";
	}
	pdf_obj* temp = mupdf::ppdf_new_destination_from_link(doc.m_internal, uri);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_new_dict()`.  */
FZ_FUNCTION PdfObj mpdf_new_dict(const PdfDocument& doc, int initialcap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_dict()\n";
	}
	pdf_obj* temp = mupdf::ppdf_new_dict(doc.m_internal, initialcap);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_new_display_list_from_annot()`.  */
FZ_FUNCTION DisplayList mpdf_new_display_list_from_annot(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_display_list_from_annot()\n";
	}
	fz_display_list* temp = mupdf::ppdf_new_display_list_from_annot(annot.m_internal);
	auto ret = DisplayList(temp);
	return ret;
}


/* Wrapper for `pdf_new_encrypt()`.  */
FZ_FUNCTION pdf_crypt *mpdf_new_encrypt(const char *opwd_utf8, const char *upwd_utf8, const PdfObj& id, int permissions, int algorithm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_encrypt()\n";
	}
	auto ret = mupdf::ppdf_new_encrypt(opwd_utf8, upwd_utf8, id.m_internal, permissions, algorithm);
	return ret;
}


/* Wrapper for `pdf_new_filter_processor()`.  */
FZ_FUNCTION PdfProcessor mpdf_new_filter_processor(const PdfDocument& doc, const PdfProcessor& chain, const PdfObj& old_res, const PdfObj& new_res, int struct_parents, Matrix& transform, PdfFilterOptions& filter)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_filter_processor()\n";
	}
	pdf_processor* temp = mupdf::ppdf_new_filter_processor(doc.m_internal, chain.m_internal, old_res.m_internal, new_res.m_internal, struct_parents, *(fz_matrix*) &transform.a, (pdf_filter_options *) &filter.opaque);
	auto ret = PdfProcessor(temp);
	return ret;
}


/* Wrapper for `pdf_new_font_desc()`.  */
FZ_FUNCTION pdf_font_desc *mpdf_new_font_desc()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_font_desc()\n";
	}
	auto ret = mupdf::ppdf_new_font_desc();
	return ret;
}


/* Wrapper for `pdf_new_graft_map()`.  */
FZ_FUNCTION PdfGraftMap mpdf_new_graft_map(const PdfDocument& dst)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_graft_map()\n";
	}
	pdf_graft_map* temp = mupdf::ppdf_new_graft_map(dst.m_internal);
	auto ret = PdfGraftMap(temp);
	return ret;
}


/* Wrapper for `pdf_new_identity_cmap()`.  */
FZ_FUNCTION PdfCmap mpdf_new_identity_cmap(int wmode, int bytes)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_identity_cmap()\n";
	}
	pdf_cmap* temp = mupdf::ppdf_new_identity_cmap(wmode, bytes);
	auto ret = PdfCmap(temp);
	return ret;
}


/* Wrapper for `pdf_new_indirect()`.  */
FZ_FUNCTION PdfObj mpdf_new_indirect(const PdfDocument& doc, int num, int gen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_indirect()\n";
	}
	pdf_obj* temp = mupdf::ppdf_new_indirect(doc.m_internal, num, gen);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_new_int()`.  */
FZ_FUNCTION PdfObj mpdf_new_int(int64_t i)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_int()\n";
	}
	pdf_obj* temp = mupdf::ppdf_new_int(i);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_new_local_xref()`.  */
FZ_FUNCTION pdf_xref *mpdf_new_local_xref(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_local_xref()\n";
	}
	auto ret = mupdf::ppdf_new_local_xref(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_new_matrix()`.  */
FZ_FUNCTION PdfObj mpdf_new_matrix(const PdfDocument& doc, Matrix& mtx)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_matrix()\n";
	}
	pdf_obj* temp = mupdf::ppdf_new_matrix(doc.m_internal, *(fz_matrix*) &mtx.a);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_new_name()`.  */
FZ_FUNCTION PdfObj mpdf_new_name(const char *str)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_name()\n";
	}
	pdf_obj* temp = mupdf::ppdf_new_name(str);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_new_outline_iterator()`.  */
FZ_FUNCTION fz_outline_iterator *mpdf_new_outline_iterator(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_outline_iterator()\n";
	}
	auto ret = mupdf::ppdf_new_outline_iterator(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_new_output_processor()`.  */
FZ_FUNCTION PdfProcessor mpdf_new_output_processor(const Output& out, int ahxencode)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_output_processor()\n";
	}
	pdf_processor* temp = mupdf::ppdf_new_output_processor(out.m_internal, ahxencode);
	auto ret = PdfProcessor(temp);
	return ret;
}


/* Wrapper for `pdf_new_pdf_device()`.  */
FZ_FUNCTION Device mpdf_new_pdf_device(const PdfDocument& doc, Matrix& topctm, const PdfObj& resources, const Buffer& contents)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_pdf_device()\n";
	}
	fz_device* temp = mupdf::ppdf_new_pdf_device(doc.m_internal, *(fz_matrix*) &topctm.a, resources.m_internal, contents.m_internal);
	auto ret = Device(temp);
	return ret;
}


/* Wrapper for `pdf_new_pixmap_from_annot()`.  */
FZ_FUNCTION Pixmap mpdf_new_pixmap_from_annot(const PdfAnnot& annot, Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_pixmap_from_annot()\n";
	}
	fz_pixmap* temp = mupdf::ppdf_new_pixmap_from_annot(annot.m_internal, *(fz_matrix*) &ctm.a, cs.m_internal, seps.m_internal, alpha);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `pdf_new_pixmap_from_page_contents_with_separations_and_usage()`.  */
FZ_FUNCTION Pixmap mpdf_new_pixmap_from_page_contents_with_separations_and_usage(const PdfPage& page, Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha, const char *usage)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_pixmap_from_page_contents_with_separations_and_usage()\n";
	}
	fz_pixmap* temp = mupdf::ppdf_new_pixmap_from_page_contents_with_separations_and_usage(page.m_internal, *(fz_matrix*) &ctm.a, cs.m_internal, seps.m_internal, alpha, usage);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `pdf_new_pixmap_from_page_contents_with_usage()`.  */
FZ_FUNCTION Pixmap mpdf_new_pixmap_from_page_contents_with_usage(const PdfPage& page, Matrix& ctm, const Colorspace& cs, int alpha, const char *usage)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_pixmap_from_page_contents_with_usage()\n";
	}
	fz_pixmap* temp = mupdf::ppdf_new_pixmap_from_page_contents_with_usage(page.m_internal, *(fz_matrix*) &ctm.a, cs.m_internal, alpha, usage);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `pdf_new_pixmap_from_page_with_separations_and_usage()`.  */
FZ_FUNCTION Pixmap mpdf_new_pixmap_from_page_with_separations_and_usage(const PdfPage& page, Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha, const char *usage)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_pixmap_from_page_with_separations_and_usage()\n";
	}
	fz_pixmap* temp = mupdf::ppdf_new_pixmap_from_page_with_separations_and_usage(page.m_internal, *(fz_matrix*) &ctm.a, cs.m_internal, seps.m_internal, alpha, usage);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `pdf_new_pixmap_from_page_with_usage()`.  */
FZ_FUNCTION Pixmap mpdf_new_pixmap_from_page_with_usage(const PdfPage& page, Matrix& ctm, const Colorspace& cs, int alpha, const char *usage)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_pixmap_from_page_with_usage()\n";
	}
	fz_pixmap* temp = mupdf::ppdf_new_pixmap_from_page_with_usage(page.m_internal, *(fz_matrix*) &ctm.a, cs.m_internal, alpha, usage);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `pdf_new_processor()`.  */
FZ_FUNCTION void *mpdf_new_processor(int size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_processor()\n";
	}
	auto ret = mupdf::ppdf_new_processor(size);
	return ret;
}


/* Wrapper for `pdf_new_real()`.  */
FZ_FUNCTION PdfObj mpdf_new_real(float f)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_real()\n";
	}
	pdf_obj* temp = mupdf::ppdf_new_real(f);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_new_rect()`.  */
FZ_FUNCTION PdfObj mpdf_new_rect(const PdfDocument& doc, Rect& rect)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_rect()\n";
	}
	pdf_obj* temp = mupdf::ppdf_new_rect(doc.m_internal, *(fz_rect*) &rect.x0);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_new_run_processor()`.  */
FZ_FUNCTION PdfProcessor mpdf_new_run_processor(const Device& dev, Matrix& ctm, const char *usage, const PdfGstate& gstate, const DefaultColorspaces& default_cs, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_run_processor()\n";
	}
	pdf_processor* temp = mupdf::ppdf_new_run_processor(dev.m_internal, *(fz_matrix*) &ctm.a, usage, gstate.m_internal, default_cs.m_internal, &cookie.m_internal);
	auto ret = PdfProcessor(temp);
	return ret;
}


/* Wrapper for `pdf_new_stext_page_from_annot()`.  */
FZ_FUNCTION fz_stext_page *mpdf_new_stext_page_from_annot(const PdfAnnot& annot, StextOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_stext_page_from_annot()\n";
	}
	auto ret = mupdf::ppdf_new_stext_page_from_annot(annot.m_internal, (const fz_stext_options *) &options.flags);
	return ret;
}


/* Wrapper for `pdf_new_string()`.  */
FZ_FUNCTION PdfObj mpdf_new_string(const char *str, size_t len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_string()\n";
	}
	pdf_obj* temp = mupdf::ppdf_new_string(str, len);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_new_text_string()`.  */
FZ_FUNCTION PdfObj mpdf_new_text_string(const char *s)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_text_string()\n";
	}
	pdf_obj* temp = mupdf::ppdf_new_text_string(s);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_new_utf8_from_pdf_stream_obj()`.  */
FZ_FUNCTION char *mpdf_new_utf8_from_pdf_stream_obj(const PdfObj& src)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_utf8_from_pdf_stream_obj()\n";
	}
	auto ret = mupdf::ppdf_new_utf8_from_pdf_stream_obj(src.m_internal);
	return ret;
}


/* Wrapper for `pdf_new_utf8_from_pdf_string()`.  */
FZ_FUNCTION char *mpdf_new_utf8_from_pdf_string(const char *srcptr, size_t srclen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_utf8_from_pdf_string()\n";
	}
	auto ret = mupdf::ppdf_new_utf8_from_pdf_string(srcptr, srclen);
	return ret;
}


/* Wrapper for `pdf_new_utf8_from_pdf_string_obj()`.  */
FZ_FUNCTION char *mpdf_new_utf8_from_pdf_string_obj(const PdfObj& src)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_utf8_from_pdf_string_obj()\n";
	}
	auto ret = mupdf::ppdf_new_utf8_from_pdf_string_obj(src.m_internal);
	return ret;
}


/* Wrapper for `pdf_new_xobject()`.  */
FZ_FUNCTION PdfObj mpdf_new_xobject(const PdfDocument& doc, Rect& bbox, Matrix& matrix, const PdfObj& res, const Buffer& buffer)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_xobject()\n";
	}
	pdf_obj* temp = mupdf::ppdf_new_xobject(doc.m_internal, *(fz_rect*) &bbox.x0, *(fz_matrix*) &matrix.a, res.m_internal, buffer.m_internal);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_next_annot()`.  */
FZ_FUNCTION PdfAnnot mpdf_next_annot(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_next_annot()\n";
	}
	pdf_annot* temp = mupdf::ppdf_next_annot(annot.m_internal);
	mupdf::ppdf_keep_annot(temp);
	auto ret = PdfAnnot(temp);
	return ret;
}


/* Wrapper for `pdf_next_widget()`.  */
FZ_FUNCTION PdfAnnot mpdf_next_widget(const PdfAnnot& previous)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_next_widget()\n";
	}
	pdf_annot* temp = mupdf::ppdf_next_widget(previous.m_internal);
	mupdf::ppdf_keep_annot(temp);
	auto ret = PdfAnnot(temp);
	return ret;
}


/* Wrapper for `pdf_obj_is_dirty()`.  */
FZ_FUNCTION int mpdf_obj_is_dirty(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_obj_is_dirty()\n";
	}
	auto ret = mupdf::ppdf_obj_is_dirty(obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_obj_is_incremental()`.  */
FZ_FUNCTION int mpdf_obj_is_incremental(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_obj_is_incremental()\n";
	}
	auto ret = mupdf::ppdf_obj_is_incremental(obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_obj_marked()`.  */
FZ_FUNCTION int mpdf_obj_marked(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_obj_marked()\n";
	}
	auto ret = mupdf::ppdf_obj_marked(obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_obj_memo()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_obj_memo(pdf_obj *obj, int bit)` => `(int, int memo)`
	 */
FZ_FUNCTION int mpdf_obj_memo(const PdfObj& obj, int bit, int *memo)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_obj_memo()\n";
	}
	auto ret = mupdf::ppdf_obj_memo(obj.m_internal, bit, memo);
	return ret;
}


/* Wrapper for `pdf_obj_num_is_stream()`.  */
FZ_FUNCTION int mpdf_obj_num_is_stream(const PdfDocument& doc, int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_obj_num_is_stream()\n";
	}
	auto ret = mupdf::ppdf_obj_num_is_stream(doc.m_internal, num);
	return ret;
}


/* Wrapper for `pdf_obj_parent_num()`.  */
FZ_FUNCTION int mpdf_obj_parent_num(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_obj_parent_num()\n";
	}
	auto ret = mupdf::ppdf_obj_parent_num(obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_obj_refs()`.  */
FZ_FUNCTION int mpdf_obj_refs(const PdfObj& ref)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_obj_refs()\n";
	}
	auto ret = mupdf::ppdf_obj_refs(ref.m_internal);
	return ret;
}


/* Wrapper for `pdf_objcmp()`.  */
FZ_FUNCTION int mpdf_objcmp(const PdfObj& a, const PdfObj& b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_objcmp()\n";
	}
	auto ret = mupdf::ppdf_objcmp(a.m_internal, b.m_internal);
	return ret;
}


/* Wrapper for `pdf_objcmp_resolve()`.  */
FZ_FUNCTION int mpdf_objcmp_resolve(const PdfObj& a, const PdfObj& b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_objcmp_resolve()\n";
	}
	auto ret = mupdf::ppdf_objcmp_resolve(a.m_internal, b.m_internal);
	return ret;
}


/* Wrapper for `pdf_open_contents_stream()`.  */
FZ_FUNCTION Stream mpdf_open_contents_stream(const PdfDocument& doc, const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_open_contents_stream()\n";
	}
	fz_stream* temp = mupdf::ppdf_open_contents_stream(doc.m_internal, obj.m_internal);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `pdf_open_crypt()`.  */
FZ_FUNCTION Stream mpdf_open_crypt(const Stream& chain, const PdfCrypt& crypt, int num, int gen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_open_crypt()\n";
	}
	fz_stream* temp = mupdf::ppdf_open_crypt(chain.m_internal, crypt.m_internal, num, gen);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `pdf_open_crypt_with_filter()`.  */
FZ_FUNCTION Stream mpdf_open_crypt_with_filter(const Stream& chain, const PdfCrypt& crypt, const PdfObj& name, int num, int gen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_open_crypt_with_filter()\n";
	}
	fz_stream* temp = mupdf::ppdf_open_crypt_with_filter(chain.m_internal, crypt.m_internal, name.m_internal, num, gen);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `pdf_open_document()`.  */
FZ_FUNCTION PdfDocument mpdf_open_document(const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_open_document()\n";
	}
	pdf_document* temp = mupdf::ppdf_open_document(filename);
	auto ret = PdfDocument(temp);
	return ret;
}


/* Wrapper for `pdf_open_document_with_stream()`.  */
FZ_FUNCTION PdfDocument mpdf_open_document_with_stream(const Stream& file)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_open_document_with_stream()\n";
	}
	pdf_document* temp = mupdf::ppdf_open_document_with_stream(file.m_internal);
	auto ret = PdfDocument(temp);
	return ret;
}


/* Wrapper for `pdf_open_inline_stream()`.  */
FZ_FUNCTION Stream mpdf_open_inline_stream(const PdfDocument& doc, const PdfObj& stmobj, int length, const Stream& chain, const CompressionParams& params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_open_inline_stream()\n";
	}
	fz_stream* temp = mupdf::ppdf_open_inline_stream(doc.m_internal, stmobj.m_internal, length, chain.m_internal, params.m_internal);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `pdf_open_raw_stream()`.  */
FZ_FUNCTION Stream mpdf_open_raw_stream(const PdfObj& ref)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_open_raw_stream()\n";
	}
	fz_stream* temp = mupdf::ppdf_open_raw_stream(ref.m_internal);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `pdf_open_raw_stream_number()`.  */
FZ_FUNCTION Stream mpdf_open_raw_stream_number(const PdfDocument& doc, int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_open_raw_stream_number()\n";
	}
	fz_stream* temp = mupdf::ppdf_open_raw_stream_number(doc.m_internal, num);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `pdf_open_stream()`.  */
FZ_FUNCTION Stream mpdf_open_stream(const PdfObj& ref)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_open_stream()\n";
	}
	fz_stream* temp = mupdf::ppdf_open_stream(ref.m_internal);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `pdf_open_stream_number()`.  */
FZ_FUNCTION Stream mpdf_open_stream_number(const PdfDocument& doc, int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_open_stream_number()\n";
	}
	fz_stream* temp = mupdf::ppdf_open_stream_number(doc.m_internal, num);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `pdf_open_stream_with_offset()`.  */
FZ_FUNCTION Stream mpdf_open_stream_with_offset(const PdfDocument& doc, int num, const PdfObj& dict, int64_t stm_ofs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_open_stream_with_offset()\n";
	}
	fz_stream* temp = mupdf::ppdf_open_stream_with_offset(doc.m_internal, num, dict.m_internal, stm_ofs);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `pdf_page_contents()`.  */
FZ_FUNCTION PdfObj mpdf_page_contents(const PdfPage& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_page_contents()\n";
	}
	pdf_obj* temp = mupdf::ppdf_page_contents(page.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_page_event_close()`.  */
FZ_FUNCTION void mpdf_page_event_close(const PdfPage& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_page_event_close()\n";
	}
	mupdf::ppdf_page_event_close(page.m_internal);
}


/* Wrapper for `pdf_page_event_open()`.  */
FZ_FUNCTION void mpdf_page_event_open(const PdfPage& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_page_event_open()\n";
	}
	mupdf::ppdf_page_event_open(page.m_internal);
}


/* Wrapper for `pdf_page_from_fz_page()`.  */
FZ_FUNCTION PdfPage mpdf_page_from_fz_page(const Page& ptr)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_page_from_fz_page()\n";
	}
	pdf_page* temp = mupdf::ppdf_page_from_fz_page(ptr.m_internal);
	auto ret = PdfPage(temp);
	return ret;
}


/* Wrapper for `pdf_page_group()`.  */
FZ_FUNCTION PdfObj mpdf_page_group(const PdfPage& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_page_group()\n";
	}
	pdf_obj* temp = mupdf::ppdf_page_group(page.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_page_obj_transform()`.  */
FZ_FUNCTION void mpdf_page_obj_transform(const PdfObj& pageobj, Rect& page_mediabox, Matrix& page_ctm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_page_obj_transform()\n";
	}
	mupdf::ppdf_page_obj_transform(pageobj.m_internal, (fz_rect *) &page_mediabox.x0, (fz_matrix *) &page_ctm.a);
}


/* Wrapper for `pdf_page_presentation()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_page_presentation(pdf_page *page, fz_transition *transition)` => `(fz_transition *, float duration)`
	 */
FZ_FUNCTION Transition mpdf_page_presentation(const PdfPage& page, Transition& transition, float *duration)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_page_presentation()\n";
	}
	fz_transition* temp = mupdf::ppdf_page_presentation(page.m_internal, (fz_transition *) &transition.type, duration);
	auto ret = Transition(temp);
	return ret;
}


/* Wrapper for `pdf_page_resources()`.  */
FZ_FUNCTION PdfObj mpdf_page_resources(const PdfPage& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_page_resources()\n";
	}
	pdf_obj* temp = mupdf::ppdf_page_resources(page.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_page_separations()`.  */
FZ_FUNCTION Separations mpdf_page_separations(const PdfPage& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_page_separations()\n";
	}
	fz_separations* temp = mupdf::ppdf_page_separations(page.m_internal);
	mupdf::keep_separations(temp);
	auto ret = Separations(temp);
	return ret;
}


/* Wrapper for `pdf_page_transform()`.  */
FZ_FUNCTION void mpdf_page_transform(const PdfPage& page, Rect& mediabox, Matrix& ctm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_page_transform()\n";
	}
	mupdf::ppdf_page_transform(page.m_internal, (fz_rect *) &mediabox.x0, (fz_matrix *) &ctm.a);
}


/* Wrapper for `pdf_page_write()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_page_write(pdf_document *doc, fz_rect mediabox, pdf_obj **presources, fz_buffer **pcontents)` => `(fz_device *)`
	 */
FZ_FUNCTION Device mpdf_page_write(const PdfDocument& doc, Rect& mediabox, PdfObj& presources, Buffer& pcontents)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_page_write()\n";
	}
	/* Out-param presources.m_internal will be overwritten. */
	ppdf_drop_obj(presources.m_internal);
	presources.m_internal = nullptr;
	/* Out-param pcontents.m_internal will be overwritten. */
	drop_buffer(pcontents.m_internal);
	pcontents.m_internal = nullptr;
	fz_device* temp = mupdf::ppdf_page_write(doc.m_internal, *(fz_rect*) &mediabox.x0, &presources.m_internal, &pcontents.m_internal);
	mupdf::keep_device(temp);
	auto ret = Device(temp);
	/* We assume that out-param presources.m_internal is a borrowed reference. */
	ppdf_keep_obj(presources.m_internal);
	/* We assume that out-param pcontents.m_internal is a borrowed reference. */
	keep_buffer(pcontents.m_internal);
	return ret;
}


/* Wrapper for `pdf_parse_array()`.  */
FZ_FUNCTION PdfObj mpdf_parse_array(const PdfDocument& doc, const Stream& f, const PdfLexbuf& buf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_parse_array()\n";
	}
	pdf_obj* temp = mupdf::ppdf_parse_array(doc.m_internal, f.m_internal, buf.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_parse_date()`.  */
FZ_FUNCTION int64_t mpdf_parse_date(const char *s)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_parse_date()\n";
	}
	auto ret = mupdf::ppdf_parse_date(s);
	return ret;
}


/* Wrapper for `pdf_parse_default_appearance()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_parse_default_appearance(const char *da, float color[4])` => `(const char *font, float size, int n)`
	 */
FZ_FUNCTION void mpdf_parse_default_appearance(const char *da, const char **font, float *size, int *n, float color[4])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_parse_default_appearance()\n";
	}
	mupdf::ppdf_parse_default_appearance(da, font, size, n, color);
}


/* Wrapper for `pdf_parse_dict()`.  */
FZ_FUNCTION PdfObj mpdf_parse_dict(const PdfDocument& doc, const Stream& f, const PdfLexbuf& buf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_parse_dict()\n";
	}
	pdf_obj* temp = mupdf::ppdf_parse_dict(doc.m_internal, f.m_internal, buf.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_parse_ind_obj()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_parse_ind_obj(pdf_document *doc, fz_stream *f)` => `(pdf_obj *, int num, int gen, int64_t stm_ofs, int try_repair)`
	 */
FZ_FUNCTION PdfObj mpdf_parse_ind_obj(const PdfDocument& doc, const Stream& f, int *num, int *gen, int64_t *stm_ofs, int *try_repair)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_parse_ind_obj()\n";
	}
	pdf_obj* temp = mupdf::ppdf_parse_ind_obj(doc.m_internal, f.m_internal, num, gen, stm_ofs, try_repair);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_parse_journal_obj()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_parse_journal_obj(pdf_document *doc, fz_stream *stm, fz_buffer **ostm)` => `(pdf_obj *, int onum, int newobj)`
	 */
FZ_FUNCTION PdfObj mpdf_parse_journal_obj(const PdfDocument& doc, const Stream& stm, int *onum, Buffer& ostm, int *newobj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_parse_journal_obj()\n";
	}
	/* Out-param ostm.m_internal will be overwritten. */
	drop_buffer(ostm.m_internal);
	ostm.m_internal = nullptr;
	pdf_obj* temp = mupdf::ppdf_parse_journal_obj(doc.m_internal, stm.m_internal, onum, &ostm.m_internal, newobj);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	/* We assume that out-param ostm.m_internal is a borrowed reference. */
	keep_buffer(ostm.m_internal);
	return ret;
}


/* Wrapper for `pdf_parse_link_action()`.  */
FZ_FUNCTION char *mpdf_parse_link_action(const PdfDocument& doc, const PdfObj& obj, int pagenum)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_parse_link_action()\n";
	}
	auto ret = mupdf::ppdf_parse_link_action(doc.m_internal, obj.m_internal, pagenum);
	return ret;
}


/* Wrapper for `pdf_parse_link_dest()`.  */
FZ_FUNCTION char *mpdf_parse_link_dest(const PdfDocument& doc, const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_parse_link_dest()\n";
	}
	auto ret = mupdf::ppdf_parse_link_dest(doc.m_internal, obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_parse_stm_obj()`.  */
FZ_FUNCTION PdfObj mpdf_parse_stm_obj(const PdfDocument& doc, const Stream& f, const PdfLexbuf& buf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_parse_stm_obj()\n";
	}
	pdf_obj* temp = mupdf::ppdf_parse_stm_obj(doc.m_internal, f.m_internal, buf.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_parse_write_options()`.  */
FZ_FUNCTION PdfWriteOptions mpdf_parse_write_options(PdfWriteOptions& opts, const char *args)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_parse_write_options()\n";
	}
	pdf_write_options* temp = mupdf::ppdf_parse_write_options((pdf_write_options *) &opts.do_incremental, args);
	auto ret = PdfWriteOptions(temp);
	return ret;
}


/* Wrapper for `pdf_preview_signature_as_display_list()`.  */
FZ_FUNCTION DisplayList mpdf_preview_signature_as_display_list(float w, float h, fz_text_language lang, const PdfPkcs7Signer& signer, int appearance_flags, const Image& graphic, const char *reason, const char *location)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_preview_signature_as_display_list()\n";
	}
	fz_display_list* temp = mupdf::ppdf_preview_signature_as_display_list(w, h, lang, signer.m_internal, appearance_flags, graphic.m_internal, reason, location);
	mupdf::keep_display_list(temp);
	auto ret = DisplayList(temp);
	return ret;
}


/* Wrapper for `pdf_preview_signature_as_pixmap()`.  */
FZ_FUNCTION Pixmap mpdf_preview_signature_as_pixmap(int w, int h, fz_text_language lang, const PdfPkcs7Signer& signer, int appearance_flags, const Image& graphic, const char *reason, const char *location)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_preview_signature_as_pixmap()\n";
	}
	fz_pixmap* temp = mupdf::ppdf_preview_signature_as_pixmap(w, h, lang, signer.m_internal, appearance_flags, graphic.m_internal, reason, location);
	mupdf::keep_pixmap(temp);
	auto ret = Pixmap(temp);
	return ret;
}


/* Wrapper for `pdf_print_crypt()`.  */
FZ_FUNCTION void mpdf_print_crypt(const Output& out, const PdfCrypt& crypt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_print_crypt()\n";
	}
	mupdf::ppdf_print_crypt(out.m_internal, crypt.m_internal);
}


/* Wrapper for `pdf_print_default_appearance()`.  */
FZ_FUNCTION void mpdf_print_default_appearance(char *buf, int nbuf, const char *font, float size, int n, const float *color)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_print_default_appearance()\n";
	}
	mupdf::ppdf_print_default_appearance(buf, nbuf, font, size, n, color);
}


/* Wrapper for `pdf_print_encrypted_obj()`.  */
FZ_FUNCTION void mpdf_print_encrypted_obj(const Output& out, const PdfObj& obj, int tight, int ascii, const PdfCrypt& crypt, int num, int gen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_print_encrypted_obj()\n";
	}
	mupdf::ppdf_print_encrypted_obj(out.m_internal, obj.m_internal, tight, ascii, crypt.m_internal, num, gen);
}


/* Wrapper for `pdf_print_font()`.  */
FZ_FUNCTION void mpdf_print_font(const Output& out, const PdfFontDesc& fontdesc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_print_font()\n";
	}
	mupdf::ppdf_print_font(out.m_internal, fontdesc.m_internal);
}


/* Wrapper for `pdf_print_obj()`.  */
FZ_FUNCTION void mpdf_print_obj(const Output& out, const PdfObj& obj, int tight, int ascii)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_print_obj()\n";
	}
	mupdf::ppdf_print_obj(out.m_internal, obj.m_internal, tight, ascii);
}


/* Wrapper for `pdf_process_annot()`.  */
FZ_FUNCTION void mpdf_process_annot(const PdfProcessor& proc, const PdfAnnot& annot, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_process_annot()\n";
	}
	mupdf::ppdf_process_annot(proc.m_internal, annot.m_internal, &cookie.m_internal);
}


/* Wrapper for `pdf_process_contents()`.  */
FZ_FUNCTION void mpdf_process_contents(const PdfProcessor& proc, const PdfDocument& doc, const PdfObj& obj, const PdfObj& res, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_process_contents()\n";
	}
	mupdf::ppdf_process_contents(proc.m_internal, doc.m_internal, obj.m_internal, res.m_internal, &cookie.m_internal);
}


/* Wrapper for `pdf_process_glyph()`.  */
FZ_FUNCTION void mpdf_process_glyph(const PdfProcessor& proc, const PdfDocument& doc, const PdfObj& resources, const Buffer& contents)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_process_glyph()\n";
	}
	mupdf::ppdf_process_glyph(proc.m_internal, doc.m_internal, resources.m_internal, contents.m_internal);
}


/* Wrapper for `pdf_progressive_advance()`.  */
FZ_FUNCTION PdfObj mpdf_progressive_advance(const PdfDocument& doc, int pagenum)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_progressive_advance()\n";
	}
	pdf_obj* temp = mupdf::ppdf_progressive_advance(doc.m_internal, pagenum);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_purge_local_font_resources()`.  */
FZ_FUNCTION void mpdf_purge_local_font_resources(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_purge_local_font_resources()\n";
	}
	mupdf::ppdf_purge_local_font_resources(doc.m_internal);
}


/* Wrapper for `pdf_purge_locals_from_store()`.  */
FZ_FUNCTION void mpdf_purge_locals_from_store(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_purge_locals_from_store()\n";
	}
	mupdf::ppdf_purge_locals_from_store(doc.m_internal);
}


/* Wrapper for `pdf_read_journal()`.  */
FZ_FUNCTION void mpdf_read_journal(const PdfDocument& doc, const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_read_journal()\n";
	}
	mupdf::ppdf_read_journal(doc.m_internal, stm.m_internal);
}


/* Wrapper for `pdf_read_ocg()`.  */
FZ_FUNCTION pdf_ocg_descriptor *mpdf_read_ocg(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_read_ocg()\n";
	}
	auto ret = mupdf::ppdf_read_ocg(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_redact_page()`.  */
FZ_FUNCTION int mpdf_redact_page(const PdfDocument& doc, const PdfPage& page, PdfRedactOptions& opts)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_redact_page()\n";
	}
	auto ret = mupdf::ppdf_redact_page(doc.m_internal, page.m_internal, (pdf_redact_options *) &opts.black_boxes);
	return ret;
}


/* Wrapper for `pdf_redo()`.  */
FZ_FUNCTION void mpdf_redo(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_redo()\n";
	}
	mupdf::ppdf_redo(doc.m_internal);
}


/* Wrapper for `pdf_remove_item()`.  */
FZ_FUNCTION void mpdf_remove_item(fz_store_drop_fn *drop, const PdfObj& key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_remove_item()\n";
	}
	mupdf::ppdf_remove_item(drop, key.m_internal);
}


/* Wrapper for `pdf_repair_obj()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_repair_obj(pdf_document *doc, pdf_lexbuf *buf, pdf_obj **encrypt, pdf_obj **id, pdf_obj **page, pdf_obj **root)` => `(int, int64_t stmofsp, int stmlenp, int64_t tmpofs)`
	 */
FZ_FUNCTION int mpdf_repair_obj(const PdfDocument& doc, const PdfLexbuf& buf, int64_t *stmofsp, int *stmlenp, PdfObj& encrypt, PdfObj& id, PdfObj& page, int64_t *tmpofs, PdfObj& root)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_repair_obj()\n";
	}
	/* Out-param encrypt.m_internal will be overwritten. */
	ppdf_drop_obj(encrypt.m_internal);
	encrypt.m_internal = nullptr;
	/* Out-param id.m_internal will be overwritten. */
	ppdf_drop_obj(id.m_internal);
	id.m_internal = nullptr;
	/* Out-param page.m_internal will be overwritten. */
	ppdf_drop_obj(page.m_internal);
	page.m_internal = nullptr;
	/* Out-param root.m_internal will be overwritten. */
	ppdf_drop_obj(root.m_internal);
	root.m_internal = nullptr;
	auto ret = mupdf::ppdf_repair_obj(doc.m_internal, buf.m_internal, stmofsp, stmlenp, &encrypt.m_internal, &id.m_internal, &page.m_internal, tmpofs, &root.m_internal);
	/* We assume that out-param encrypt.m_internal is a borrowed reference. */
	ppdf_keep_obj(encrypt.m_internal);
	/* We assume that out-param id.m_internal is a borrowed reference. */
	ppdf_keep_obj(id.m_internal);
	/* We assume that out-param page.m_internal is a borrowed reference. */
	ppdf_keep_obj(page.m_internal);
	/* We assume that out-param root.m_internal is a borrowed reference. */
	ppdf_keep_obj(root.m_internal);
	return ret;
}


/* Wrapper for `pdf_repair_obj_stms()`.  */
FZ_FUNCTION void mpdf_repair_obj_stms(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_repair_obj_stms()\n";
	}
	mupdf::ppdf_repair_obj_stms(doc.m_internal);
}


/* Wrapper for `pdf_repair_trailer()`.  */
FZ_FUNCTION void mpdf_repair_trailer(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_repair_trailer()\n";
	}
	mupdf::ppdf_repair_trailer(doc.m_internal);
}


/* Wrapper for `pdf_repair_xref()`.  */
FZ_FUNCTION void mpdf_repair_xref(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_repair_xref()\n";
	}
	mupdf::ppdf_repair_xref(doc.m_internal);
}


/* Wrapper for `pdf_replace_xref()`.  */
FZ_FUNCTION void mpdf_replace_xref(const PdfDocument& doc, const PdfXrefEntry& entries, int n)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_replace_xref()\n";
	}
	mupdf::ppdf_replace_xref(doc.m_internal, entries.m_internal, n);
}


/* Wrapper for `pdf_reset_form()`.  */
FZ_FUNCTION void mpdf_reset_form(const PdfDocument& doc, const PdfObj& fields, int exclude)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_reset_form()\n";
	}
	mupdf::ppdf_reset_form(doc.m_internal, fields.m_internal, exclude);
}


/* Wrapper for `pdf_resolve_indirect()`.  */
FZ_FUNCTION PdfObj mpdf_resolve_indirect(const PdfObj& ref)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_resolve_indirect()\n";
	}
	pdf_obj* temp = mupdf::ppdf_resolve_indirect(ref.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_resolve_indirect_chain()`.  */
FZ_FUNCTION PdfObj mpdf_resolve_indirect_chain(const PdfObj& ref)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_resolve_indirect_chain()\n";
	}
	pdf_obj* temp = mupdf::ppdf_resolve_indirect_chain(ref.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_resolve_link()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_resolve_link(pdf_document *doc, const char *uri)` => `(int, float xp, float yp)`
	 */
FZ_FUNCTION int mpdf_resolve_link(const PdfDocument& doc, const char *uri, float *xp, float *yp)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_resolve_link()\n";
	}
	auto ret = mupdf::ppdf_resolve_link(doc.m_internal, uri, xp, yp);
	return ret;
}


/* Wrapper for `pdf_run_annot()`.  */
FZ_FUNCTION void mpdf_run_annot(const PdfAnnot& annot, const Device& dev, Matrix& ctm, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_run_annot()\n";
	}
	mupdf::ppdf_run_annot(annot.m_internal, dev.m_internal, *(fz_matrix*) &ctm.a, &cookie.m_internal);
}


/* Wrapper for `pdf_run_glyph()`.  */
FZ_FUNCTION void mpdf_run_glyph(const PdfDocument& doc, const PdfObj& resources, const Buffer& contents, const Device& dev, Matrix& ctm, void *gstate, const DefaultColorspaces& default_cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_run_glyph()\n";
	}
	mupdf::ppdf_run_glyph(doc.m_internal, resources.m_internal, contents.m_internal, dev.m_internal, *(fz_matrix*) &ctm.a, gstate, default_cs.m_internal);
}


/* Wrapper for `pdf_run_page()`.  */
FZ_FUNCTION void mpdf_run_page(const PdfPage& page, const Device& dev, Matrix& ctm, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_run_page()\n";
	}
	mupdf::ppdf_run_page(page.m_internal, dev.m_internal, *(fz_matrix*) &ctm.a, &cookie.m_internal);
}


/* Wrapper for `pdf_run_page_annots()`.  */
FZ_FUNCTION void mpdf_run_page_annots(const PdfPage& page, const Device& dev, Matrix& ctm, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_run_page_annots()\n";
	}
	mupdf::ppdf_run_page_annots(page.m_internal, dev.m_internal, *(fz_matrix*) &ctm.a, &cookie.m_internal);
}


/* Wrapper for `pdf_run_page_annots_with_usage()`.  */
FZ_FUNCTION void mpdf_run_page_annots_with_usage(const PdfPage& page, const Device& dev, Matrix& ctm, const char *usage, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_run_page_annots_with_usage()\n";
	}
	mupdf::ppdf_run_page_annots_with_usage(page.m_internal, dev.m_internal, *(fz_matrix*) &ctm.a, usage, &cookie.m_internal);
}


/* Wrapper for `pdf_run_page_contents()`.  */
FZ_FUNCTION void mpdf_run_page_contents(const PdfPage& page, const Device& dev, Matrix& ctm, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_run_page_contents()\n";
	}
	mupdf::ppdf_run_page_contents(page.m_internal, dev.m_internal, *(fz_matrix*) &ctm.a, &cookie.m_internal);
}


/* Wrapper for `pdf_run_page_contents_with_usage()`.  */
FZ_FUNCTION void mpdf_run_page_contents_with_usage(const PdfPage& page, const Device& dev, Matrix& ctm, const char *usage, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_run_page_contents_with_usage()\n";
	}
	mupdf::ppdf_run_page_contents_with_usage(page.m_internal, dev.m_internal, *(fz_matrix*) &ctm.a, usage, &cookie.m_internal);
}


/* Wrapper for `pdf_run_page_widgets()`.  */
FZ_FUNCTION void mpdf_run_page_widgets(const PdfPage& page, const Device& dev, Matrix& ctm, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_run_page_widgets()\n";
	}
	mupdf::ppdf_run_page_widgets(page.m_internal, dev.m_internal, *(fz_matrix*) &ctm.a, &cookie.m_internal);
}


/* Wrapper for `pdf_run_page_widgets_with_usage()`.  */
FZ_FUNCTION void mpdf_run_page_widgets_with_usage(const PdfPage& page, const Device& dev, Matrix& ctm, const char *usage, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_run_page_widgets_with_usage()\n";
	}
	mupdf::ppdf_run_page_widgets_with_usage(page.m_internal, dev.m_internal, *(fz_matrix*) &ctm.a, usage, &cookie.m_internal);
}


/* Wrapper for `pdf_run_page_with_usage()`.  */
FZ_FUNCTION void mpdf_run_page_with_usage(const PdfPage& page, const Device& dev, Matrix& ctm, const char *usage, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_run_page_with_usage()\n";
	}
	mupdf::ppdf_run_page_with_usage(page.m_internal, dev.m_internal, *(fz_matrix*) &ctm.a, usage, &cookie.m_internal);
}


/* Wrapper for `pdf_save_document()`.  */
FZ_FUNCTION void mpdf_save_document(const PdfDocument& doc, const char *filename, PdfWriteOptions& opts)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_save_document()\n";
	}
	mupdf::ppdf_save_document(doc.m_internal, filename, (const pdf_write_options *) &opts.do_incremental);
}


/* Wrapper for `pdf_save_journal()`.  */
FZ_FUNCTION void mpdf_save_journal(const PdfDocument& doc, const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_save_journal()\n";
	}
	mupdf::ppdf_save_journal(doc.m_internal, filename);
}


/* Wrapper for `pdf_save_snapshot()`.  */
FZ_FUNCTION void mpdf_save_snapshot(const PdfDocument& doc, const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_save_snapshot()\n";
	}
	mupdf::ppdf_save_snapshot(doc.m_internal, filename);
}


/* Wrapper for `pdf_select_layer_config()`.  */
FZ_FUNCTION void mpdf_select_layer_config(const PdfDocument& doc, int config_num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_select_layer_config()\n";
	}
	mupdf::ppdf_select_layer_config(doc.m_internal, config_num);
}


/* Wrapper for `pdf_select_layer_config_ui()`.  */
FZ_FUNCTION void mpdf_select_layer_config_ui(const PdfDocument& doc, int ui)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_select_layer_config_ui()\n";
	}
	mupdf::ppdf_select_layer_config_ui(doc.m_internal, ui);
}


/* Wrapper for `pdf_serialise_journal()`.  */
FZ_FUNCTION void mpdf_serialise_journal(const PdfDocument& doc, const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_serialise_journal()\n";
	}
	mupdf::ppdf_serialise_journal(doc.m_internal, out.m_internal);
}


/* Wrapper for `pdf_set_annot_active()`.  */
FZ_FUNCTION void mpdf_set_annot_active(const PdfAnnot& annot, int active)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_active()\n";
	}
	mupdf::ppdf_set_annot_active(annot.m_internal, active);
}


/* Wrapper for `pdf_set_annot_appearance()`.  */
FZ_FUNCTION void mpdf_set_annot_appearance(const PdfAnnot& annot, const char *appearance, const char *state, Matrix& ctm, Rect& bbox, const PdfObj& res, const Buffer& contents)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_appearance()\n";
	}
	mupdf::ppdf_set_annot_appearance(annot.m_internal, appearance, state, *(fz_matrix*) &ctm.a, *(fz_rect*) &bbox.x0, res.m_internal, contents.m_internal);
}


/* Wrapper for `pdf_set_annot_appearance_from_display_list()`.  */
FZ_FUNCTION void mpdf_set_annot_appearance_from_display_list(const PdfAnnot& annot, const char *appearance, const char *state, Matrix& ctm, const DisplayList& list)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_appearance_from_display_list()\n";
	}
	mupdf::ppdf_set_annot_appearance_from_display_list(annot.m_internal, appearance, state, *(fz_matrix*) &ctm.a, list.m_internal);
}


/* Wrapper for `pdf_set_annot_author()`.  */
FZ_FUNCTION void mpdf_set_annot_author(const PdfAnnot& annot, const char *author)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_author()\n";
	}
	mupdf::ppdf_set_annot_author(annot.m_internal, author);
}


/* Wrapper for `pdf_set_annot_border()`.  */
FZ_FUNCTION void mpdf_set_annot_border(const PdfAnnot& annot, float width)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_border()\n";
	}
	mupdf::ppdf_set_annot_border(annot.m_internal, width);
}


/* Wrapper for `pdf_set_annot_color()`.  */
FZ_FUNCTION void mpdf_set_annot_color(const PdfAnnot& annot, int n, const float *color)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_color()\n";
	}
	mupdf::ppdf_set_annot_color(annot.m_internal, n, color);
}


/* Wrapper for `pdf_set_annot_contents()`.  */
FZ_FUNCTION void mpdf_set_annot_contents(const PdfAnnot& annot, const char *text)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_contents()\n";
	}
	mupdf::ppdf_set_annot_contents(annot.m_internal, text);
}


/* Wrapper for `pdf_set_annot_creation_date()`.  */
FZ_FUNCTION void mpdf_set_annot_creation_date(const PdfAnnot& annot, int64_t time)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_creation_date()\n";
	}
	mupdf::ppdf_set_annot_creation_date(annot.m_internal, time);
}


/* Wrapper for `pdf_set_annot_default_appearance()`.  */
FZ_FUNCTION void mpdf_set_annot_default_appearance(const PdfAnnot& annot, const char *font, float size, int n, const float *color)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_default_appearance()\n";
	}
	mupdf::ppdf_set_annot_default_appearance(annot.m_internal, font, size, n, color);
}


/* Wrapper for `pdf_set_annot_field_value()`.  */
FZ_FUNCTION int mpdf_set_annot_field_value(const PdfDocument& doc, const PdfAnnot& widget, const char *text, int ignore_trigger_events)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_field_value()\n";
	}
	auto ret = mupdf::ppdf_set_annot_field_value(doc.m_internal, widget.m_internal, text, ignore_trigger_events);
	return ret;
}


/* Wrapper for `pdf_set_annot_flags()`.  */
FZ_FUNCTION void mpdf_set_annot_flags(const PdfAnnot& annot, int flags)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_flags()\n";
	}
	mupdf::ppdf_set_annot_flags(annot.m_internal, flags);
}


/* Wrapper for `pdf_set_annot_hot()`.  */
FZ_FUNCTION void mpdf_set_annot_hot(const PdfAnnot& annot, int hot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_hot()\n";
	}
	mupdf::ppdf_set_annot_hot(annot.m_internal, hot);
}


/* Wrapper for `pdf_set_annot_icon_name()`.  */
FZ_FUNCTION void mpdf_set_annot_icon_name(const PdfAnnot& annot, const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_icon_name()\n";
	}
	mupdf::ppdf_set_annot_icon_name(annot.m_internal, name);
}


/* Wrapper for `pdf_set_annot_ink_list()`.  */
FZ_FUNCTION void mpdf_set_annot_ink_list(const PdfAnnot& annot, int n, const int *count, Point& v)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_ink_list()\n";
	}
	mupdf::ppdf_set_annot_ink_list(annot.m_internal, n, count, (const fz_point *) &v.x);
}


/* Wrapper for `pdf_set_annot_interior_color()`.  */
FZ_FUNCTION void mpdf_set_annot_interior_color(const PdfAnnot& annot, int n, const float *color)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_interior_color()\n";
	}
	mupdf::ppdf_set_annot_interior_color(annot.m_internal, n, color);
}


/* Wrapper for `pdf_set_annot_is_open()`.  */
FZ_FUNCTION void mpdf_set_annot_is_open(const PdfAnnot& annot, int is_open)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_is_open()\n";
	}
	mupdf::ppdf_set_annot_is_open(annot.m_internal, is_open);
}


/* Wrapper for `pdf_set_annot_language()`.  */
FZ_FUNCTION void mpdf_set_annot_language(const PdfAnnot& annot, fz_text_language lang)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_language()\n";
	}
	mupdf::ppdf_set_annot_language(annot.m_internal, lang);
}


/* Wrapper for `pdf_set_annot_line()`.  */
FZ_FUNCTION void mpdf_set_annot_line(const PdfAnnot& annot, Point& a, Point& b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_line()\n";
	}
	mupdf::ppdf_set_annot_line(annot.m_internal, *(fz_point*) &a.x, *(fz_point*) &b.x);
}


/* Wrapper for `pdf_set_annot_line_end_style()`.  */
FZ_FUNCTION void mpdf_set_annot_line_end_style(const PdfAnnot& annot, enum pdf_line_ending e)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_line_end_style()\n";
	}
	mupdf::ppdf_set_annot_line_end_style(annot.m_internal, e);
}


/* Wrapper for `pdf_set_annot_line_ending_styles()`.  */
FZ_FUNCTION void mpdf_set_annot_line_ending_styles(const PdfAnnot& annot, enum pdf_line_ending start_style, enum pdf_line_ending end_style)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_line_ending_styles()\n";
	}
	mupdf::ppdf_set_annot_line_ending_styles(annot.m_internal, start_style, end_style);
}


/* Wrapper for `pdf_set_annot_line_start_style()`.  */
FZ_FUNCTION void mpdf_set_annot_line_start_style(const PdfAnnot& annot, enum pdf_line_ending s)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_line_start_style()\n";
	}
	mupdf::ppdf_set_annot_line_start_style(annot.m_internal, s);
}


/* Wrapper for `pdf_set_annot_modification_date()`.  */
FZ_FUNCTION void mpdf_set_annot_modification_date(const PdfAnnot& annot, int64_t time)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_modification_date()\n";
	}
	mupdf::ppdf_set_annot_modification_date(annot.m_internal, time);
}


/* Wrapper for `pdf_set_annot_opacity()`.  */
FZ_FUNCTION void mpdf_set_annot_opacity(const PdfAnnot& annot, float opacity)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_opacity()\n";
	}
	mupdf::ppdf_set_annot_opacity(annot.m_internal, opacity);
}


/* Wrapper for `pdf_set_annot_popup()`.  */
FZ_FUNCTION void mpdf_set_annot_popup(const PdfAnnot& annot, Rect& rect)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_popup()\n";
	}
	mupdf::ppdf_set_annot_popup(annot.m_internal, *(fz_rect*) &rect.x0);
}


/* Wrapper for `pdf_set_annot_quad_points()`.  */
FZ_FUNCTION void mpdf_set_annot_quad_points(const PdfAnnot& annot, int n, Quad& qv)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_quad_points()\n";
	}
	mupdf::ppdf_set_annot_quad_points(annot.m_internal, n, (const fz_quad *) &qv.ul);
}


/* Wrapper for `pdf_set_annot_quadding()`.  */
FZ_FUNCTION void mpdf_set_annot_quadding(const PdfAnnot& annot, int q)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_quadding()\n";
	}
	mupdf::ppdf_set_annot_quadding(annot.m_internal, q);
}


/* Wrapper for `pdf_set_annot_rect()`.  */
FZ_FUNCTION void mpdf_set_annot_rect(const PdfAnnot& annot, Rect& rect)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_rect()\n";
	}
	mupdf::ppdf_set_annot_rect(annot.m_internal, *(fz_rect*) &rect.x0);
}


/* Wrapper for `pdf_set_annot_resynthesised()`.  */
FZ_FUNCTION void mpdf_set_annot_resynthesised(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_resynthesised()\n";
	}
	mupdf::ppdf_set_annot_resynthesised(annot.m_internal);
}


/* Wrapper for `pdf_set_annot_vertex()`.  */
FZ_FUNCTION void mpdf_set_annot_vertex(const PdfAnnot& annot, int i, Point& p)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_vertex()\n";
	}
	mupdf::ppdf_set_annot_vertex(annot.m_internal, i, *(fz_point*) &p.x);
}


/* Wrapper for `pdf_set_annot_vertices()`.  */
FZ_FUNCTION void mpdf_set_annot_vertices(const PdfAnnot& annot, int n, Point& v)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_vertices()\n";
	}
	mupdf::ppdf_set_annot_vertices(annot.m_internal, n, (const fz_point *) &v.x);
}


/* Wrapper for `pdf_set_choice_field_value()`.  */
FZ_FUNCTION int mpdf_set_choice_field_value(const PdfAnnot& widget, const char *value)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_choice_field_value()\n";
	}
	auto ret = mupdf::ppdf_set_choice_field_value(widget.m_internal, value);
	return ret;
}


/* Wrapper for `pdf_set_cmap_wmode()`.  */
FZ_FUNCTION void mpdf_set_cmap_wmode(const PdfCmap& cmap, int wmode)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_cmap_wmode()\n";
	}
	mupdf::ppdf_set_cmap_wmode(cmap.m_internal, wmode);
}


/* Wrapper for `pdf_set_default_hmtx()`.  */
FZ_FUNCTION void mpdf_set_default_hmtx(const PdfFontDesc& font, int w)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_default_hmtx()\n";
	}
	mupdf::ppdf_set_default_hmtx(font.m_internal, w);
}


/* Wrapper for `pdf_set_default_vmtx()`.  */
FZ_FUNCTION void mpdf_set_default_vmtx(const PdfFontDesc& font, int y, int w)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_default_vmtx()\n";
	}
	mupdf::ppdf_set_default_vmtx(font.m_internal, y, w);
}


/* Wrapper for `pdf_set_doc_event_callback()`.  */
FZ_FUNCTION void mpdf_set_doc_event_callback(const PdfDocument& doc, pdf_doc_event_cb *event_cb, pdf_free_doc_event_data_cb *free_event_data_cb, void *data)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_doc_event_callback()\n";
	}
	mupdf::ppdf_set_doc_event_callback(doc.m_internal, event_cb, free_event_data_cb, data);
}


/* Wrapper for `pdf_set_document_language()`.  */
FZ_FUNCTION void mpdf_set_document_language(const PdfDocument& doc, fz_text_language lang)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_document_language()\n";
	}
	mupdf::ppdf_set_document_language(doc.m_internal, lang);
}


/* Wrapper for `pdf_set_field_value()`.  */
FZ_FUNCTION int mpdf_set_field_value(const PdfDocument& doc, const PdfObj& field, const char *text, int ignore_trigger_events)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_field_value()\n";
	}
	auto ret = mupdf::ppdf_set_field_value(doc.m_internal, field.m_internal, text, ignore_trigger_events);
	return ret;
}


/* Wrapper for `pdf_set_font_wmode()`.  */
FZ_FUNCTION void mpdf_set_font_wmode(const PdfFontDesc& font, int wmode)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_font_wmode()\n";
	}
	mupdf::ppdf_set_font_wmode(font.m_internal, wmode);
}


/* Wrapper for `pdf_set_int()`.  */
FZ_FUNCTION void mpdf_set_int(const PdfObj& obj, int64_t i)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_int()\n";
	}
	mupdf::ppdf_set_int(obj.m_internal, i);
}


/* Wrapper for `pdf_set_layer_config_as_default()`.  */
FZ_FUNCTION void mpdf_set_layer_config_as_default(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_layer_config_as_default()\n";
	}
	mupdf::ppdf_set_layer_config_as_default(doc.m_internal);
}


/* Wrapper for `pdf_set_obj_memo()`.  */
FZ_FUNCTION void mpdf_set_obj_memo(const PdfObj& obj, int bit, int memo)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_obj_memo()\n";
	}
	mupdf::ppdf_set_obj_memo(obj.m_internal, bit, memo);
}


/* Wrapper for `pdf_set_obj_parent()`.  */
FZ_FUNCTION void mpdf_set_obj_parent(const PdfObj& obj, int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_obj_parent()\n";
	}
	mupdf::ppdf_set_obj_parent(obj.m_internal, num);
}


/* Wrapper for `pdf_set_populating_xref_trailer()`.  */
FZ_FUNCTION void mpdf_set_populating_xref_trailer(const PdfDocument& doc, const PdfObj& trailer)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_populating_xref_trailer()\n";
	}
	mupdf::ppdf_set_populating_xref_trailer(doc.m_internal, trailer.m_internal);
}


/* Wrapper for `pdf_set_str_len()`.  */
FZ_FUNCTION void mpdf_set_str_len(const PdfObj& obj, size_t newlen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_str_len()\n";
	}
	mupdf::ppdf_set_str_len(obj.m_internal, newlen);
}


/* Wrapper for `pdf_set_text_field_value()`.  */
FZ_FUNCTION int mpdf_set_text_field_value(const PdfAnnot& widget, const char *value)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_text_field_value()\n";
	}
	auto ret = mupdf::ppdf_set_text_field_value(widget.m_internal, value);
	return ret;
}


/* Wrapper for `pdf_set_usecmap()`.  */
FZ_FUNCTION void mpdf_set_usecmap(const PdfCmap& cmap, const PdfCmap& usecmap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_usecmap()\n";
	}
	mupdf::ppdf_set_usecmap(cmap.m_internal, usecmap.m_internal);
}


/* Wrapper for `pdf_set_widget_editing_state()`.  */
FZ_FUNCTION void mpdf_set_widget_editing_state(const PdfAnnot& widget, int editing)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_widget_editing_state()\n";
	}
	mupdf::ppdf_set_widget_editing_state(widget.m_internal, editing);
}


/* Wrapper for `pdf_sign_signature()`.  */
FZ_FUNCTION void mpdf_sign_signature(const PdfAnnot& widget, const PdfPkcs7Signer& signer, int appearance_flags, const Image& graphic, const char *reason, const char *location)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_sign_signature()\n";
	}
	mupdf::ppdf_sign_signature(widget.m_internal, signer.m_internal, appearance_flags, graphic.m_internal, reason, location);
}


/* Wrapper for `pdf_sign_signature_with_appearance()`.  */
FZ_FUNCTION void mpdf_sign_signature_with_appearance(const PdfAnnot& widget, const PdfPkcs7Signer& signer, int64_t date, const DisplayList& disp_list)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_sign_signature_with_appearance()\n";
	}
	mupdf::ppdf_sign_signature_with_appearance(widget.m_internal, signer.m_internal, date, disp_list.m_internal);
}


/* Wrapper for `pdf_signature_appearance_signed()`.  */
FZ_FUNCTION DisplayList mpdf_signature_appearance_signed(Rect& rect, fz_text_language lang, const Image& img, const char *left_text, const char *right_text, int include_logo)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_signature_appearance_signed()\n";
	}
	fz_display_list* temp = mupdf::ppdf_signature_appearance_signed(*(fz_rect*) &rect.x0, lang, img.m_internal, left_text, right_text, include_logo);
	mupdf::keep_display_list(temp);
	auto ret = DisplayList(temp);
	return ret;
}


/* Wrapper for `pdf_signature_appearance_unsigned()`.  */
FZ_FUNCTION DisplayList mpdf_signature_appearance_unsigned(Rect& rect, fz_text_language lang)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_signature_appearance_unsigned()\n";
	}
	fz_display_list* temp = mupdf::ppdf_signature_appearance_unsigned(*(fz_rect*) &rect.x0, lang);
	mupdf::keep_display_list(temp);
	auto ret = DisplayList(temp);
	return ret;
}


/* Wrapper for `pdf_signature_byte_range()`.  */
FZ_FUNCTION int mpdf_signature_byte_range(const PdfDocument& doc, const PdfObj& signature, const Range& byte_range)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_signature_byte_range()\n";
	}
	auto ret = mupdf::ppdf_signature_byte_range(doc.m_internal, signature.m_internal, byte_range.m_internal);
	return ret;
}


/* Wrapper for `pdf_signature_contents()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_signature_contents(pdf_document *doc, pdf_obj *signature)` => `(size_t, char *contents)`
	 */
FZ_FUNCTION size_t mpdf_signature_contents(const PdfDocument& doc, const PdfObj& signature, char **contents)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_signature_contents()\n";
	}
	auto ret = mupdf::ppdf_signature_contents(doc.m_internal, signature.m_internal, contents);
	return ret;
}


/* Wrapper for `pdf_signature_drop_distinguished_name()`.  */
FZ_FUNCTION void mpdf_signature_drop_distinguished_name(const PdfPkcs7DistinguishedName& name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_signature_drop_distinguished_name()\n";
	}
	mupdf::ppdf_signature_drop_distinguished_name(name.m_internal);
}


/* Wrapper for `pdf_signature_error_description()`.  */
FZ_FUNCTION char *mpdf_signature_error_description(pdf_signature_error err)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_signature_error_description()\n";
	}
	auto ret = mupdf::ppdf_signature_error_description(err);
	return ret;
}


/* Wrapper for `pdf_signature_format_distinguished_name()`.  */
FZ_FUNCTION char *mpdf_signature_format_distinguished_name(const PdfPkcs7DistinguishedName& name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_signature_format_distinguished_name()\n";
	}
	auto ret = mupdf::ppdf_signature_format_distinguished_name(name.m_internal);
	return ret;
}


/* Wrapper for `pdf_signature_get_signatory()`.  */
FZ_FUNCTION pdf_pkcs7_distinguished_name *mpdf_signature_get_signatory(const PdfPkcs7Verifier& verifier, const PdfDocument& doc, const PdfObj& signature)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_signature_get_signatory()\n";
	}
	auto ret = mupdf::ppdf_signature_get_signatory(verifier.m_internal, doc.m_internal, signature.m_internal);
	return ret;
}


/* Wrapper for `pdf_signature_get_widget_signatory()`.  */
FZ_FUNCTION pdf_pkcs7_distinguished_name *mpdf_signature_get_widget_signatory(const PdfPkcs7Verifier& verifier, const PdfAnnot& widget)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_signature_get_widget_signatory()\n";
	}
	auto ret = mupdf::ppdf_signature_get_widget_signatory(verifier.m_internal, widget.m_internal);
	return ret;
}


/* Wrapper for `pdf_signature_hash_bytes()`.  */
FZ_FUNCTION Stream mpdf_signature_hash_bytes(const PdfDocument& doc, const PdfObj& signature)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_signature_hash_bytes()\n";
	}
	fz_stream* temp = mupdf::ppdf_signature_hash_bytes(doc.m_internal, signature.m_internal);
	mupdf::keep_stream(temp);
	auto ret = Stream(temp);
	return ret;
}


/* Wrapper for `pdf_signature_incremental_change_since_signing()`.  */
FZ_FUNCTION int mpdf_signature_incremental_change_since_signing(const PdfDocument& doc, const PdfObj& signature)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_signature_incremental_change_since_signing()\n";
	}
	auto ret = mupdf::ppdf_signature_incremental_change_since_signing(doc.m_internal, signature.m_internal);
	return ret;
}


/* Wrapper for `pdf_signature_info()`.  */
FZ_FUNCTION char *mpdf_signature_info(const char *name, const PdfPkcs7DistinguishedName& dn, const char *reason, const char *location, int64_t date, int include_labels)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_signature_info()\n";
	}
	auto ret = mupdf::ppdf_signature_info(name, dn.m_internal, reason, location, date, include_labels);
	return ret;
}


/* Wrapper for `pdf_signature_is_signed()`.  */
FZ_FUNCTION int mpdf_signature_is_signed(const PdfDocument& doc, const PdfObj& field)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_signature_is_signed()\n";
	}
	auto ret = mupdf::ppdf_signature_is_signed(doc.m_internal, field.m_internal);
	return ret;
}


/* Wrapper for `pdf_signature_set_value()`.  */
FZ_FUNCTION void mpdf_signature_set_value(const PdfDocument& doc, const PdfObj& field, const PdfPkcs7Signer& signer, int64_t stime)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_signature_set_value()\n";
	}
	mupdf::ppdf_signature_set_value(doc.m_internal, field.m_internal, signer.m_internal, stime);
}


/* Wrapper for `pdf_sort_cmap()`.  */
FZ_FUNCTION void mpdf_sort_cmap(const PdfCmap& cmap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_sort_cmap()\n";
	}
	mupdf::ppdf_sort_cmap(cmap.m_internal);
}


/* Wrapper for `pdf_sort_dict()`.  */
FZ_FUNCTION void mpdf_sort_dict(const PdfObj& dict)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_sort_dict()\n";
	}
	mupdf::ppdf_sort_dict(dict.m_internal);
}


/* Wrapper for `pdf_specifics()`.  */
FZ_FUNCTION PdfDocument mpdf_specifics(const Document& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_specifics()\n";
	}
	pdf_document* temp = mupdf::ppdf_specifics(doc.m_internal);
	mupdf::ppdf_keep_document(temp);
	auto ret = PdfDocument(temp);
	return ret;
}


/* Wrapper for `pdf_sprint_obj()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_sprint_obj(char *buf, size_t cap, pdf_obj *obj, int tight, int ascii)` => `(char *, size_t len)`
	 */
FZ_FUNCTION char *mpdf_sprint_obj(char *buf, size_t cap, size_t *len, const PdfObj& obj, int tight, int ascii)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_sprint_obj()\n";
	}
	auto ret = mupdf::ppdf_sprint_obj(buf, cap, len, obj.m_internal, tight, ascii);
	return ret;
}


/* Wrapper for `pdf_store_item()`.  */
FZ_FUNCTION void mpdf_store_item(const PdfObj& key, void *val, size_t itemsize)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_store_item()\n";
	}
	mupdf::ppdf_store_item(key.m_internal, val, itemsize);
}


/* Wrapper for `pdf_string_from_annot_type()`.  */
FZ_FUNCTION const char *mpdf_string_from_annot_type(enum pdf_annot_type type)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_string_from_annot_type()\n";
	}
	auto ret = mupdf::ppdf_string_from_annot_type(type);
	return ret;
}


/* Wrapper for `pdf_string_from_line_ending()`.  */
FZ_FUNCTION const char *mpdf_string_from_line_ending(enum pdf_line_ending end)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_string_from_line_ending()\n";
	}
	auto ret = mupdf::ppdf_string_from_line_ending(end);
	return ret;
}


/* Wrapper for `pdf_text_widget_format()`.  */
FZ_FUNCTION int mpdf_text_widget_format(const PdfAnnot& tw)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_text_widget_format()\n";
	}
	auto ret = mupdf::ppdf_text_widget_format(tw.m_internal);
	return ret;
}


/* Wrapper for `pdf_text_widget_max_len()`.  */
FZ_FUNCTION int mpdf_text_widget_max_len(const PdfAnnot& tw)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_text_widget_max_len()\n";
	}
	auto ret = mupdf::ppdf_text_widget_max_len(tw.m_internal);
	return ret;
}


/* Wrapper for `pdf_to_bool()`.  */
FZ_FUNCTION int mpdf_to_bool(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_bool()\n";
	}
	auto ret = mupdf::ppdf_to_bool(obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_to_date()`.  */
FZ_FUNCTION int64_t mpdf_to_date(const PdfObj& time)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_date()\n";
	}
	auto ret = mupdf::ppdf_to_date(time.m_internal);
	return ret;
}


/* Wrapper for `pdf_to_gen()`.  */
FZ_FUNCTION int mpdf_to_gen(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_gen()\n";
	}
	auto ret = mupdf::ppdf_to_gen(obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_to_int()`.  */
FZ_FUNCTION int mpdf_to_int(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_int()\n";
	}
	auto ret = mupdf::ppdf_to_int(obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_to_int64()`.  */
FZ_FUNCTION int64_t mpdf_to_int64(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_int64()\n";
	}
	auto ret = mupdf::ppdf_to_int64(obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_to_matrix()`.  */
FZ_FUNCTION Matrix mpdf_to_matrix(const PdfObj& array)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_matrix()\n";
	}
	fz_matrix temp = mupdf::ppdf_to_matrix(array.m_internal);
	auto ret = Matrix(&temp);
	return ret;
}


/* Wrapper for `pdf_to_name()`.  */
FZ_FUNCTION const char *mpdf_to_name(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_name()\n";
	}
	auto ret = mupdf::ppdf_to_name(obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_to_num()`.  */
FZ_FUNCTION int mpdf_to_num(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_num()\n";
	}
	auto ret = mupdf::ppdf_to_num(obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_to_quad()`.  */
FZ_FUNCTION Quad mpdf_to_quad(const PdfObj& array, int offset)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_quad()\n";
	}
	fz_quad temp = mupdf::ppdf_to_quad(array.m_internal, offset);
	auto ret = Quad(&temp);
	return ret;
}


/* Wrapper for `pdf_to_real()`.  */
FZ_FUNCTION float mpdf_to_real(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_real()\n";
	}
	auto ret = mupdf::ppdf_to_real(obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_to_rect()`.  */
FZ_FUNCTION Rect mpdf_to_rect(const PdfObj& array)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_rect()\n";
	}
	fz_rect temp = mupdf::ppdf_to_rect(array.m_internal);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `pdf_to_str_buf()`.  */
FZ_FUNCTION char *mpdf_to_str_buf(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_str_buf()\n";
	}
	auto ret = mupdf::ppdf_to_str_buf(obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_to_str_len()`.  */
FZ_FUNCTION size_t mpdf_to_str_len(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_str_len()\n";
	}
	auto ret = mupdf::ppdf_to_str_len(obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_to_string()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_to_string(pdf_obj *obj)` => `(const char *, size_t sizep)`
	 */
FZ_FUNCTION const char *mpdf_to_string(const PdfObj& obj, size_t *sizep)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_string()\n";
	}
	auto ret = mupdf::ppdf_to_string(obj.m_internal, sizep);
	return ret;
}


/* Wrapper for `pdf_to_text_string()`.  */
FZ_FUNCTION const char *mpdf_to_text_string(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_text_string()\n";
	}
	auto ret = mupdf::ppdf_to_text_string(obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_toggle_layer_config_ui()`.  */
FZ_FUNCTION void mpdf_toggle_layer_config_ui(const PdfDocument& doc, int ui)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_toggle_layer_config_ui()\n";
	}
	mupdf::ppdf_toggle_layer_config_ui(doc.m_internal, ui);
}


/* Wrapper for `pdf_toggle_widget()`.  */
FZ_FUNCTION int mpdf_toggle_widget(const PdfAnnot& widget)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_toggle_widget()\n";
	}
	auto ret = mupdf::ppdf_toggle_widget(widget.m_internal);
	return ret;
}


/* Wrapper for `pdf_tos_get_text()`.  */
FZ_FUNCTION Text mpdf_tos_get_text(const PdfTextObjectState& tos)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_tos_get_text()\n";
	}
	fz_text* temp = mupdf::ppdf_tos_get_text(tos.m_internal);
	mupdf::keep_text(temp);
	auto ret = Text(temp);
	return ret;
}


/* Wrapper for `pdf_tos_make_trm()`.  */
FZ_FUNCTION int mpdf_tos_make_trm(const PdfTextObjectState& tos, const PdfTextState& text, const PdfFontDesc& fontdesc, int cid, Matrix& trm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_tos_make_trm()\n";
	}
	auto ret = mupdf::ppdf_tos_make_trm(tos.m_internal, text.m_internal, fontdesc.m_internal, cid, (fz_matrix *) &trm.a);
	return ret;
}


/* Wrapper for `pdf_tos_move_after_char()`.  */
FZ_FUNCTION void mpdf_tos_move_after_char(const PdfTextObjectState& tos)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_tos_move_after_char()\n";
	}
	mupdf::ppdf_tos_move_after_char(tos.m_internal);
}


/* Wrapper for `pdf_tos_newline()`.  */
FZ_FUNCTION void mpdf_tos_newline(const PdfTextObjectState& tos, float leading)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_tos_newline()\n";
	}
	mupdf::ppdf_tos_newline(tos.m_internal, leading);
}


/* Wrapper for `pdf_tos_reset()`.  */
FZ_FUNCTION void mpdf_tos_reset(const PdfTextObjectState& tos, int render)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_tos_reset()\n";
	}
	mupdf::ppdf_tos_reset(tos.m_internal, render);
}


/* Wrapper for `pdf_tos_restore()`.  */
FZ_FUNCTION void mpdf_tos_restore(const PdfTextObjectState& tos, fz_matrix save[2])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_tos_restore()\n";
	}
	mupdf::ppdf_tos_restore(tos.m_internal, save);
}


/* Wrapper for `pdf_tos_save()`.  */
FZ_FUNCTION void mpdf_tos_save(const PdfTextObjectState& tos, fz_matrix save[2])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_tos_save()\n";
	}
	mupdf::ppdf_tos_save(tos.m_internal, save);
}


/* Wrapper for `pdf_tos_set_matrix()`.  */
FZ_FUNCTION void mpdf_tos_set_matrix(const PdfTextObjectState& tos, float a, float b, float c, float d, float e, float f)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_tos_set_matrix()\n";
	}
	mupdf::ppdf_tos_set_matrix(tos.m_internal, a, b, c, d, e, f);
}


/* Wrapper for `pdf_tos_translate()`.  */
FZ_FUNCTION void mpdf_tos_translate(const PdfTextObjectState& tos, float tx, float ty)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_tos_translate()\n";
	}
	mupdf::ppdf_tos_translate(tos.m_internal, tx, ty);
}


/* Wrapper for `pdf_trailer()`.  */
FZ_FUNCTION PdfObj mpdf_trailer(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_trailer()\n";
	}
	pdf_obj* temp = mupdf::ppdf_trailer(doc.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_undo()`.  */
FZ_FUNCTION void mpdf_undo(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_undo()\n";
	}
	mupdf::ppdf_undo(doc.m_internal);
}


/* Wrapper for `pdf_undoredo_state()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_undoredo_state(pdf_document *doc)` => `(int, int steps)`
	 */
FZ_FUNCTION int mpdf_undoredo_state(const PdfDocument& doc, int *steps)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_undoredo_state()\n";
	}
	auto ret = mupdf::ppdf_undoredo_state(doc.m_internal, steps);
	return ret;
}


/* Wrapper for `pdf_undoredo_step()`.  */
FZ_FUNCTION const char *mpdf_undoredo_step(const PdfDocument& doc, int step)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_undoredo_step()\n";
	}
	auto ret = mupdf::ppdf_undoredo_step(doc.m_internal, step);
	return ret;
}


/* Wrapper for `pdf_unmark_obj()`.  */
FZ_FUNCTION void mpdf_unmark_obj(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_unmark_obj()\n";
	}
	mupdf::ppdf_unmark_obj(obj.m_internal);
}


/* Wrapper for `pdf_update_annot()`.  */
FZ_FUNCTION int mpdf_update_annot(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_update_annot()\n";
	}
	auto ret = mupdf::ppdf_update_annot(annot.m_internal);
	return ret;
}


/* Wrapper for `pdf_update_default_colorspaces()`.  */
FZ_FUNCTION DefaultColorspaces mpdf_update_default_colorspaces(const DefaultColorspaces& old_cs, const PdfObj& res)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_update_default_colorspaces()\n";
	}
	fz_default_colorspaces* temp = mupdf::ppdf_update_default_colorspaces(old_cs.m_internal, res.m_internal);
	mupdf::keep_default_colorspaces(temp);
	auto ret = DefaultColorspaces(temp);
	return ret;
}


/* Wrapper for `pdf_update_object()`.  */
FZ_FUNCTION void mpdf_update_object(const PdfDocument& doc, int num, const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_update_object()\n";
	}
	mupdf::ppdf_update_object(doc.m_internal, num, obj.m_internal);
}


/* Wrapper for `pdf_update_page()`.  */
FZ_FUNCTION int mpdf_update_page(const PdfPage& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_update_page()\n";
	}
	auto ret = mupdf::ppdf_update_page(page.m_internal);
	return ret;
}


/* Wrapper for `pdf_update_stream()`.  */
FZ_FUNCTION void mpdf_update_stream(const PdfDocument& doc, const PdfObj& ref, const Buffer& buf, int compressed)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_update_stream()\n";
	}
	mupdf::ppdf_update_stream(doc.m_internal, ref.m_internal, buf.m_internal, compressed);
}


/* Wrapper for `pdf_update_widget()`.  */
FZ_FUNCTION int mpdf_update_widget(const PdfAnnot& widget)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_update_widget()\n";
	}
	auto ret = mupdf::ppdf_update_widget(widget.m_internal);
	return ret;
}


/* Wrapper for `pdf_update_xobject()`.  */
FZ_FUNCTION void mpdf_update_xobject(const PdfDocument& doc, const PdfObj& xobj, Rect& bbox, Matrix& mat, const PdfObj& res, const Buffer& buffer)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_update_xobject()\n";
	}
	mupdf::ppdf_update_xobject(doc.m_internal, xobj.m_internal, *(fz_rect*) &bbox.x0, *(fz_matrix*) &mat.a, res.m_internal, buffer.m_internal);
}


/* Wrapper for `pdf_validate_change_history()`.  */
FZ_FUNCTION int mpdf_validate_change_history(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_validate_change_history()\n";
	}
	auto ret = mupdf::ppdf_validate_change_history(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_validate_changes()`.  */
FZ_FUNCTION int mpdf_validate_changes(const PdfDocument& doc, int version)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_validate_changes()\n";
	}
	auto ret = mupdf::ppdf_validate_changes(doc.m_internal, version);
	return ret;
}


/* Wrapper for `pdf_validate_signature()`.  */
FZ_FUNCTION int mpdf_validate_signature(const PdfAnnot& widget)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_validate_signature()\n";
	}
	auto ret = mupdf::ppdf_validate_signature(widget.m_internal);
	return ret;
}


/* Wrapper for `pdf_version()`.  */
FZ_FUNCTION int mpdf_version(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_version()\n";
	}
	auto ret = mupdf::ppdf_version(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_walk_tree()`.
	
	This function has out-params. Python/C# wrappers look like:
		`mpdf_walk_tree(pdf_obj *tree, pdf_obj *kid_name, void (*arrive)(fz_context *, pdf_obj *, void *, pdf_obj **), void (*leave)(fz_context *, pdf_obj *, void *), void *arg, pdf_obj **names, pdf_obj **values)` => `()`
	 */
FZ_FUNCTION void mpdf_walk_tree(const PdfObj& tree, const PdfObj& kid_name, void (*arrive)(fz_context *, pdf_obj *, void *, pdf_obj **), void (*leave)(fz_context *, pdf_obj *, void *), void *arg, PdfObj& names, PdfObj& values)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_walk_tree()\n";
	}
	/* Out-param names.m_internal will be overwritten. */
	ppdf_drop_obj(names.m_internal);
	names.m_internal = nullptr;
	/* Out-param values.m_internal will be overwritten. */
	ppdf_drop_obj(values.m_internal);
	values.m_internal = nullptr;
	mupdf::ppdf_walk_tree(tree.m_internal, kid_name.m_internal, arrive, leave, arg, &names.m_internal, &values.m_internal);
	/* We assume that out-param names.m_internal is a borrowed reference. */
	ppdf_keep_obj(names.m_internal);
	/* We assume that out-param values.m_internal is a borrowed reference. */
	ppdf_keep_obj(values.m_internal);
}


/* Wrapper for `pdf_was_pure_xfa()`.  */
FZ_FUNCTION int mpdf_was_pure_xfa(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_was_pure_xfa()\n";
	}
	auto ret = mupdf::ppdf_was_pure_xfa(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_was_repaired()`.  */
FZ_FUNCTION int mpdf_was_repaired(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_was_repaired()\n";
	}
	auto ret = mupdf::ppdf_was_repaired(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_widget_is_readonly()`.  */
FZ_FUNCTION int mpdf_widget_is_readonly(const PdfAnnot& widget)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_widget_is_readonly()\n";
	}
	auto ret = mupdf::ppdf_widget_is_readonly(widget.m_internal);
	return ret;
}


/* Wrapper for `pdf_widget_is_signed()`.  */
FZ_FUNCTION int mpdf_widget_is_signed(const PdfAnnot& widget)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_widget_is_signed()\n";
	}
	auto ret = mupdf::ppdf_widget_is_signed(widget.m_internal);
	return ret;
}


/* Wrapper for `pdf_widget_type()`.  */
FZ_FUNCTION enum pdf_widget_type mpdf_widget_type(const PdfAnnot& widget)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_widget_type()\n";
	}
	auto ret = mupdf::ppdf_widget_type(widget.m_internal);
	return ret;
}


/* Wrapper for `pdf_write_digest()`.  */
FZ_FUNCTION void mpdf_write_digest(const Output& out, const PdfObj& byte_range, const PdfObj& field, size_t digest_offset, size_t digest_length, const PdfPkcs7Signer& signer)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_write_digest()\n";
	}
	mupdf::ppdf_write_digest(out.m_internal, byte_range.m_internal, field.m_internal, digest_offset, digest_length, signer.m_internal);
}


/* Wrapper for `pdf_write_document()`.  */
FZ_FUNCTION void mpdf_write_document(const PdfDocument& doc, const Output& out, PdfWriteOptions& opts)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_write_document()\n";
	}
	mupdf::ppdf_write_document(doc.m_internal, out.m_internal, (const pdf_write_options *) &opts.do_incremental);
}


/* Wrapper for `pdf_write_journal()`.  */
FZ_FUNCTION void mpdf_write_journal(const PdfDocument& doc, const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_write_journal()\n";
	}
	mupdf::ppdf_write_journal(doc.m_internal, out.m_internal);
}


/* Wrapper for `pdf_write_snapshot()`.  */
FZ_FUNCTION void mpdf_write_snapshot(const PdfDocument& doc, const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_write_snapshot()\n";
	}
	mupdf::ppdf_write_snapshot(doc.m_internal, out.m_internal);
}


/* Wrapper for `pdf_xobject_bbox()`.  */
FZ_FUNCTION Rect mpdf_xobject_bbox(const PdfObj& xobj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xobject_bbox()\n";
	}
	fz_rect temp = mupdf::ppdf_xobject_bbox(xobj.m_internal);
	auto ret = Rect(&temp);
	return ret;
}


/* Wrapper for `pdf_xobject_colorspace()`.  */
FZ_FUNCTION Colorspace mpdf_xobject_colorspace(const PdfObj& xobj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xobject_colorspace()\n";
	}
	fz_colorspace* temp = mupdf::ppdf_xobject_colorspace(xobj.m_internal);
	mupdf::keep_colorspace(temp);
	auto ret = Colorspace(temp);
	return ret;
}


/* Wrapper for `pdf_xobject_isolated()`.  */
FZ_FUNCTION int mpdf_xobject_isolated(const PdfObj& xobj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xobject_isolated()\n";
	}
	auto ret = mupdf::ppdf_xobject_isolated(xobj.m_internal);
	return ret;
}


/* Wrapper for `pdf_xobject_knockout()`.  */
FZ_FUNCTION int mpdf_xobject_knockout(const PdfObj& xobj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xobject_knockout()\n";
	}
	auto ret = mupdf::ppdf_xobject_knockout(xobj.m_internal);
	return ret;
}


/* Wrapper for `pdf_xobject_matrix()`.  */
FZ_FUNCTION Matrix mpdf_xobject_matrix(const PdfObj& xobj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xobject_matrix()\n";
	}
	fz_matrix temp = mupdf::ppdf_xobject_matrix(xobj.m_internal);
	auto ret = Matrix(&temp);
	return ret;
}


/* Wrapper for `pdf_xobject_resources()`.  */
FZ_FUNCTION PdfObj mpdf_xobject_resources(const PdfObj& xobj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xobject_resources()\n";
	}
	pdf_obj* temp = mupdf::ppdf_xobject_resources(xobj.m_internal);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}


/* Wrapper for `pdf_xobject_transparency()`.  */
FZ_FUNCTION int mpdf_xobject_transparency(const PdfObj& xobj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xobject_transparency()\n";
	}
	auto ret = mupdf::ppdf_xobject_transparency(xobj.m_internal);
	return ret;
}


/* Wrapper for `pdf_xref_ensure_incremental_object()`.  */
FZ_FUNCTION int mpdf_xref_ensure_incremental_object(const PdfDocument& doc, int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xref_ensure_incremental_object()\n";
	}
	auto ret = mupdf::ppdf_xref_ensure_incremental_object(doc.m_internal, num);
	return ret;
}


/* Wrapper for `pdf_xref_ensure_local_object()`.  */
FZ_FUNCTION void mpdf_xref_ensure_local_object(const PdfDocument& doc, int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xref_ensure_local_object()\n";
	}
	mupdf::ppdf_xref_ensure_local_object(doc.m_internal, num);
}


/* Wrapper for `pdf_xref_is_incremental()`.  */
FZ_FUNCTION int mpdf_xref_is_incremental(const PdfDocument& doc, int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xref_is_incremental()\n";
	}
	auto ret = mupdf::ppdf_xref_is_incremental(doc.m_internal, num);
	return ret;
}


/* Wrapper for `pdf_xref_len()`.  */
FZ_FUNCTION int mpdf_xref_len(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xref_len()\n";
	}
	auto ret = mupdf::ppdf_xref_len(doc.m_internal);
	return ret;
}


/* Wrapper for `pdf_xref_obj_is_unsaved_signature()`.  */
FZ_FUNCTION int mpdf_xref_obj_is_unsaved_signature(const PdfDocument& doc, const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xref_obj_is_unsaved_signature()\n";
	}
	auto ret = mupdf::ppdf_xref_obj_is_unsaved_signature(doc.m_internal, obj.m_internal);
	return ret;
}


/* Wrapper for `pdf_xref_remove_unsaved_signature()`.  */
FZ_FUNCTION void mpdf_xref_remove_unsaved_signature(const PdfDocument& doc, const PdfObj& field)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xref_remove_unsaved_signature()\n";
	}
	mupdf::ppdf_xref_remove_unsaved_signature(doc.m_internal, field.m_internal);
}


/* Wrapper for `pdf_xref_store_unsaved_signature()`.  */
FZ_FUNCTION void mpdf_xref_store_unsaved_signature(const PdfDocument& doc, const PdfObj& field, const PdfPkcs7Signer& signer)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xref_store_unsaved_signature()\n";
	}
	mupdf::ppdf_xref_store_unsaved_signature(doc.m_internal, field.m_internal, signer.m_internal);
}


} /* End of namespace mupdf. */
