/**
This file was auto-generated by mupdfwrap.py.
*/


#include "mupdf/classes.h"
#include "mupdf/classes2.h"
#include "mupdf/exceptions.h"
#include "mupdf/internal.h"

#include "mupdf/fitz/geometry.h"

#include <map>
#include <mutex>
#include <sstream>
#include <string.h>
#include <thread>

#include <string.h>

static const char* s_trace_s = getenv("MUPDF_trace");
static const char* s_trace_director_s = getenv("MUPDF_trace_director");
static bool s_trace = (s_trace_s && !strcmp(s_trace_s, "1")) ? true : false;
static bool s_trace_director = (s_trace_director_s && !strcmp(s_trace_director_s, "1")) ? true : false;

namespace mupdf
{

/* Support for checking that reference counts of underlying
MuPDF structs are not smaller than the number of wrapper class
instances. Enable at runtime by setting environmental variable
MUPDF_check_refs to "1". */

static const char*  s_check_refs_s = getenv("MUPDF_check_refs");
static bool         s_check_refs = (s_check_refs_s && !strcmp(s_check_refs_s, "1")) ? true : false;

/* For each MuPDF struct that has an 'int refs' member, we create
a static instance of this class template with T set to our wrapper
class, for example:

	static RefsCheck<fz_document, Document> s_Document_refs_check;

Then if s_check_refs is true, each constructor function calls
.add(), the destructor calls .remove() and other class functions
call .check(). This ensures that we check reference counting after
each class operation.

If <allow_int_this> is true, we allow _this->m_internal to be
an invalid pointer less than 4096, in which case we don't try
to check refs. This is used for_pdf_obj because in Python the
enums PDF_ENUM_NAME_* are converted to mupdf.PdfObj's containg
.m_internal's which are the enum values cast to (for_pdf_obj*), so
that they can be used directly.
*/
template<typename Struct, typename ClassWrapper, bool allow_int_this=false>
struct RefsCheck
{
	std::mutex              m_mutex;
	int                     m_offset;
	int                     m_size;
	std::map<Struct*, int>  m_this_to_num;

	RefsCheck(int offset, int size)
	: m_offset(offset), m_size(size)
	{
		assert(m_size == 32 || m_size == 16 || m_size == 8);
	}

	void change( const ClassWrapper* this_, const char* file, int line, const char* fn, int delta)
	{
		assert( s_check_refs);
		if (!this_->m_internal) return;
		if (allow_int_this)
		{
			if (0) std::cerr << __FILE__ << ":" << __LINE__
					<< " " << file << ":" << line << ":" << fn << ":"
					<< " this_->m_internal=" << this_->m_internal
					<< "\n";
			if ((intptr_t) this_->m_internal < 4096)
			{
				if (0) std::cerr << __FILE__ << ":" << __LINE__
						<< " " << file << ":" << line << ":" << fn << ":"
						<< " Ignoring this_->m_internal=" << this_->m_internal
						<< "\n";
				return;
			}
		}
		std::lock_guard< std::mutex> lock( m_mutex);
		/* Our lock doesn't make our access to
		this_->m_internal->refs thead-safe - other threads
		could be modifying it via fz_keep_<Struct>() or
		fz_drop_<Struct>(). But hopefully our read will be atomic
		in practise anyway? */
		void* refs_ptr = (char*) this_->m_internal + m_offset;
		int refs;
		if (m_size == 32)   refs = *(int32_t*) refs_ptr;
		if (m_size == 16)   refs = *(int16_t*) refs_ptr;
		if (m_size ==  8)   refs = *(int8_t* ) refs_ptr;

		int& n = m_this_to_num[ this_->m_internal];
		int n_prev = n;
		assert( n >= 0);
		n += delta;
		std::cerr << file << ":" << line << ":" << fn << "():"
				// << " " << typeid(ClassWrapper).name() << ":"
				<< " this_=" << this_
				<< " this_->m_internal=" << this_->m_internal
				<< " refs=" << refs
				<< " n: " << n_prev << " => " << n
				<< "\n";
		if ( n < 0)
		{
			std::cerr << file << ":" << line << ":" << fn << "():"
					// << " " << typeid(ClassWrapper).name() << ":"
					<< " this_=" << this_
					<< " this_->m_internal=" << this_->m_internal
					<< " bad n: " << n_prev << " => " << n
					<< "\n";
			abort();
		}
		if ( n && refs < n)
		{
			std::cerr << file << ":" << line << ":" << fn << "():"
				// << " " << typeid(ClassWrapper).name() << ":"
					<< " this_=" << this_
					<< " this_->m_internal=" << this_->m_internal
					<< " refs=" << refs
					<< " n: " << n_prev << " => " << n
					<< " refs mismatch (refs<n):"
					<< "\n";
			abort();
		}
		if (n && ::abs( refs - n) > 1000)
		{
			/* This traps case where n > 0 but underlying struct is
			freed and .ref is set to bogus value by fz_free() or
			similar. */
			std::cerr << file << ":" << line << ":" << fn << "(): " << ": " << typeid(ClassWrapper).name()
					<< " bad change to refs."
					<< " this_=" << this_
					<< " refs=" << refs
					<< " n: " << n_prev << " => " << n
					<< "\n";
			abort();
		}
		if (n == 0) m_this_to_num.erase( this_->m_internal);
	}
	void add( const ClassWrapper* this_, const char* file, int line, const char* fn)
	{
		change( this_, file, line, fn, +1);
	}
	void remove( const ClassWrapper* this_, const char* file, int line, const char* fn)
	{
		change( this_, file, line, fn, -1);
	}
	void check( const ClassWrapper* this_, const char* file, int line, const char* fn)
	{
		change( this_, file, line, fn, 0);
	}
};


/* Implementation of methods for AaContext (wrapper for fz_aa_context). */

FZ_FUNCTION AaContext::AaContext(const fz_aa_context* internal)
{
	this->hscale = internal->hscale;
	this->vscale = internal->vscale;
	this->scale = internal->scale;
	this->bits = internal->bits;
	this->text_bits = internal->text_bits;
	this->min_line_width = internal->min_line_width;
}

FZ_FUNCTION AaContext::AaContext(const fz_aa_context internal)
{
	this->hscale = internal.hscale;
	this->vscale = internal.vscale;
	this->scale = internal.scale;
	this->bits = internal.bits;
	this->text_bits = internal.text_bits;
	this->min_line_width = internal.min_line_width;
}

/** Constructor using raw copy of pre-existing `fz_aa_context`. */
FZ_FUNCTION fz_aa_context* AaContext::internal()
{
	auto ret = (fz_aa_context*) &this->hscale;
	return ret;
}

/** Constructor using raw copy of pre-existing `fz_aa_context`. */
FZ_FUNCTION const fz_aa_context* AaContext::internal() const
{
	auto ret = (const fz_aa_context*) &this->hscale;
	return ret;
}

FZ_FUNCTION std::string AaContext::to_string()
{
	std::ostringstream buffer;
	buffer << *this;
	return buffer.str();
}


FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const AaContext& rhs)
{
	return out << *rhs.internal();
}

/* Implementation of methods for Aes (wrapper for fz_aes). */

/* Wrapper for `fz_aes_crypt_cbc()`.  */
FZ_FUNCTION void Aes::aes_crypt_cbc(int mode, size_t length, unsigned char iv[16], const unsigned char *input, unsigned char *output)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::aes_crypt_cbc()\n";
	}
	mupdf::mfz_aes_crypt_cbc(*this, mode, length, iv, input, output);
}

/* Wrapper for `fz_aes_setkey_dec()`.  */
FZ_FUNCTION int Aes::aes_setkey_dec(const unsigned char *key, int keysize)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::aes_setkey_dec()\n";
	}
	auto ret = mupdf::mfz_aes_setkey_dec(*this, key, keysize);
	return ret;
}

/* Wrapper for `fz_aes_setkey_enc()`.  */
FZ_FUNCTION int Aes::aes_setkey_enc(const unsigned char *key, int keysize)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::aes_setkey_enc()\n";
	}
	auto ret = mupdf::mfz_aes_setkey_enc(*this, key, keysize);
	return ret;
}

FZ_FUNCTION Aes::Aes(fz_aes* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long Aes::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for AllocContext (wrapper for fz_alloc_context). */

FZ_FUNCTION AllocContext::AllocContext(fz_alloc_context* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long AllocContext::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Arc4 (wrapper for fz_arc4). */

/* Wrapper for `fz_arc4_encrypt()`.  */
FZ_FUNCTION void Arc4::arc4_encrypt(unsigned char *dest, const unsigned char *src, size_t len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::arc4_encrypt()\n";
	}
	mupdf::mfz_arc4_encrypt(*this, dest, src, len);
}

/* Wrapper for `fz_arc4_init()`.  */
FZ_FUNCTION void Arc4::arc4_init(const unsigned char *key, size_t len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::arc4_init()\n";
	}
	mupdf::mfz_arc4_init(*this, key, len);
}

FZ_FUNCTION Arc4::Arc4(fz_arc4* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long Arc4::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Archive (wrapper for fz_archive). */

/* Constructor using `fz_new_archive_of_size()`. */
FZ_FUNCTION Archive::Archive(const Stream& file, int size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_archive_of_size()\n";
	}
	this->m_internal = mupdf::new_archive_of_size(file.m_internal, size);
}

/* Wrapper for `fz_archive_format()`.  */
FZ_FUNCTION const char *Archive::archive_format()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::archive_format()\n";
	}
	auto ret = mupdf::mfz_archive_format(*this);
	return ret;
}

/* Wrapper for `fz_count_archive_entries()`.  */
FZ_FUNCTION int Archive::count_archive_entries()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::count_archive_entries()\n";
	}
	auto ret = mupdf::mfz_count_archive_entries(*this);
	return ret;
}

/* Wrapper for `fz_has_archive_entry()`.  */
FZ_FUNCTION int Archive::has_archive_entry(const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::has_archive_entry()\n";
	}
	auto ret = mupdf::mfz_has_archive_entry(*this, name);
	return ret;
}

/* Wrapper for `fz_list_archive_entry()`.  */
FZ_FUNCTION const char *Archive::list_archive_entry(int idx)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::list_archive_entry()\n";
	}
	auto ret = mupdf::mfz_list_archive_entry(*this, idx);
	return ret;
}

/* Wrapper for `fz_open_archive_entry()`.  */
FZ_FUNCTION Stream Archive::open_archive_entry(const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_archive_entry()\n";
	}
	auto ret = mupdf::mfz_open_archive_entry(*this, name);
	return ret;
}

/* Wrapper for `fz_read_archive_entry()`.  */
FZ_FUNCTION Buffer Archive::read_archive_entry(const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_archive_entry()\n";
	}
	auto ret = mupdf::mfz_read_archive_entry(*this, name);
	return ret;
}

FZ_FUNCTION Archive::Archive(fz_archive* internal)
: m_internal(internal)
{
}

FZ_FUNCTION Archive::~Archive()
{
	mupdf::drop_archive(m_internal);
}

/** Custom method. */
FZ_FUNCTION long long Archive::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for BandWriter (wrapper for fz_band_writer). */

/* Constructor using `fz_new_band_writer_of_size()`. */
FZ_FUNCTION BandWriter::BandWriter(size_t size, const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_band_writer_of_size()\n";
	}
	this->m_internal = mupdf::new_band_writer_of_size(size, out.m_internal);
}

/* Constructor using `fz_new_color_pcl_band_writer()`. */
/* Disabled because same args as fz_new_mono_pcl_band_writer.
FZ_FUNCTION BandWriter::BandWriter(const Output& out, const PclOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_color_pcl_band_writer()\n";
	}
	this->m_internal = mupdf::new_color_pcl_band_writer(out.m_internal, options.m_internal);
}

*/
/* Constructor using `fz_new_mono_pcl_band_writer()`. */
FZ_FUNCTION BandWriter::BandWriter(const Output& out, const PclOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_mono_pcl_band_writer()\n";
	}
	this->m_internal = mupdf::new_mono_pcl_band_writer(out.m_internal, options.m_internal);
}

/* Constructor using `fz_new_mono_pwg_band_writer()`. */
FZ_FUNCTION BandWriter::BandWriter(const Output& out, PwgOptions& pwg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_mono_pwg_band_writer()\n";
	}
	this->m_internal = mupdf::new_mono_pwg_band_writer(out.m_internal, &pwg.m_internal);
}

/* Constructor using `fz_new_pam_band_writer()`. */
/* Disabled because same args as fz_new_png_band_writer.
FZ_FUNCTION BandWriter::BandWriter(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pam_band_writer()\n";
	}
	this->m_internal = mupdf::new_pam_band_writer(out.m_internal);
}

*/
/* Constructor using `fz_new_pbm_band_writer()`. */
/* Disabled because same args as fz_new_png_band_writer.
FZ_FUNCTION BandWriter::BandWriter(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pbm_band_writer()\n";
	}
	this->m_internal = mupdf::new_pbm_band_writer(out.m_internal);
}

*/
/* Constructor using `fz_new_pclm_band_writer()`. */
FZ_FUNCTION BandWriter::BandWriter(const Output& out, const PclmOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pclm_band_writer()\n";
	}
	this->m_internal = mupdf::new_pclm_band_writer(out.m_internal, options.m_internal);
}

/* Constructor using `fz_new_pdfocr_band_writer()`. */
FZ_FUNCTION BandWriter::BandWriter(const Output& out, PdfocrOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pdfocr_band_writer()\n";
	}
	this->m_internal = mupdf::new_pdfocr_band_writer(out.m_internal, (const fz_pdfocr_options *) &options.compress);
}

/* Constructor using `fz_new_pkm_band_writer()`. */
/* Disabled because same args as fz_new_png_band_writer.
FZ_FUNCTION BandWriter::BandWriter(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pkm_band_writer()\n";
	}
	this->m_internal = mupdf::new_pkm_band_writer(out.m_internal);
}

*/
/* Constructor using `fz_new_png_band_writer()`. */
FZ_FUNCTION BandWriter::BandWriter(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_png_band_writer()\n";
	}
	this->m_internal = mupdf::new_png_band_writer(out.m_internal);
}

/* Constructor using `fz_new_pnm_band_writer()`. */
/* Disabled because same args as fz_new_png_band_writer.
FZ_FUNCTION BandWriter::BandWriter(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pnm_band_writer()\n";
	}
	this->m_internal = mupdf::new_pnm_band_writer(out.m_internal);
}

*/
/* Constructor using `fz_new_ps_band_writer()`. */
/* Disabled because same args as fz_new_png_band_writer.
FZ_FUNCTION BandWriter::BandWriter(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_ps_band_writer()\n";
	}
	this->m_internal = mupdf::new_ps_band_writer(out.m_internal);
}

*/
/* Constructor using `fz_new_psd_band_writer()`. */
/* Disabled because same args as fz_new_png_band_writer.
FZ_FUNCTION BandWriter::BandWriter(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_psd_band_writer()\n";
	}
	this->m_internal = mupdf::new_psd_band_writer(out.m_internal);
}

*/
/* Constructor using `fz_new_pwg_band_writer()`. */
/* Disabled because same args as fz_new_mono_pwg_band_writer.
FZ_FUNCTION BandWriter::BandWriter(const Output& out, PwgOptions& pwg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pwg_band_writer()\n";
	}
	this->m_internal = mupdf::new_pwg_band_writer(out.m_internal, &pwg.m_internal);
}

*/
/** Custom constructor. */
FZ_FUNCTION BandWriter::BandWriter(Output& out, Cm cm, const PclOptions& options)
{
	fz_output*              out2 = out.m_internal;
	const fz_pcl_options*   options2 = options.m_internal;
	if (0)  {}
	else if (cm == MONO)    m_internal = mupdf::new_mono_pcl_band_writer( out2, options2);
	else if (cm == COLOR)   m_internal = mupdf::new_color_pcl_band_writer( out2, options2);
	else throw std::runtime_error( "Unrecognised fz_band_writer_s Cm type");
}

/** Custom constructor. */
FZ_FUNCTION BandWriter::BandWriter(Output& out, P p)
{
	fz_output*              out2 = out.m_internal;
	if (0)  {}
	else if (p == PNG)  m_internal = mupdf::new_png_band_writer( out2);
	else if (p == PNM)  m_internal = mupdf::new_pnm_band_writer( out2);
	else if (p == PAM)  m_internal = mupdf::new_pam_band_writer( out2);
	else if (p == PBM)  m_internal = mupdf::new_pbm_band_writer( out2);
	else if (p == PKM)  m_internal = mupdf::new_pkm_band_writer( out2);
	else if (p == PS)   m_internal = mupdf::new_ps_band_writer( out2);
	else if (p == PSD)  m_internal = mupdf::new_psd_band_writer( out2);
	else throw std::runtime_error( "Unrecognised fz_band_writer_s P type");
}

/** Custom constructor. */
FZ_FUNCTION BandWriter::BandWriter(Output& out, Cm cm, const PwgOptions& options)
{
	fz_output*              out2 = out.m_internal;
	const fz_pwg_options*   options2 = &options.m_internal;
	if (0)  {}
	else if (cm == MONO)    m_internal = mupdf::new_mono_pwg_band_writer( out2, options2);
	else if (cm == COLOR)   m_internal = mupdf::new_pwg_band_writer( out2, options2);
	else throw std::runtime_error( "Unrecognised fz_band_writer_s Cm type");
}

/* Wrapper for `fz_close_band_writer()`.  */
FZ_FUNCTION void BandWriter::close_band_writer()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::close_band_writer()\n";
	}
	mupdf::mfz_close_band_writer(*this);
}

/* Wrapper for `fz_pdfocr_band_writer_set_progress()`.  */
FZ_FUNCTION void BandWriter::pdfocr_band_writer_set_progress(fz_pdfocr_progress_fn *progress_fn, void *progress_arg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pdfocr_band_writer_set_progress()\n";
	}
	mupdf::mfz_pdfocr_band_writer_set_progress(*this, progress_fn, progress_arg);
}

/* Wrapper for `fz_write_band()`.  */
FZ_FUNCTION void BandWriter::write_band(int stride, int band_height, const unsigned char *samples)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_band()\n";
	}
	mupdf::mfz_write_band(*this, stride, band_height, samples);
}

/* Wrapper for `fz_write_header()`.  */
FZ_FUNCTION void BandWriter::write_header(int w, int h, int n, int alpha, int xres, int yres, int pagenum, const Colorspace& cs, const Separations& seps)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_header()\n";
	}
	mupdf::mfz_write_header(*this, w, h, n, alpha, xres, yres, pagenum, cs, seps);
}

FZ_FUNCTION BandWriter::BandWriter(fz_band_writer* internal)
: m_internal(internal)
{
}

FZ_FUNCTION BandWriter::~BandWriter()
{
	mupdf::drop_band_writer(m_internal);
}

/** Custom method. */
FZ_FUNCTION long long BandWriter::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Bitmap (wrapper for fz_bitmap). */

static RefsCheck<fz_bitmap, Bitmap> s_Bitmap_refs_check(offsetof(fz_bitmap, refs), 32);

/* Constructor using `fz_new_bitmap()`. */
FZ_FUNCTION Bitmap::Bitmap(int w, int h, int n, int xres, int yres)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_bitmap()\n";
	}
	this->m_internal = mupdf::new_bitmap(w, h, n, xres, yres);
	if (s_check_refs)
	{
		s_Bitmap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_bitmap_from_pixmap()`. */
FZ_FUNCTION Bitmap::Bitmap(const Pixmap& pix, const Halftone& ht)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_bitmap_from_pixmap()\n";
	}
	this->m_internal = mupdf::new_bitmap_from_pixmap(pix.m_internal, ht.m_internal);
	if (s_check_refs)
	{
		s_Bitmap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_bitmap_from_pixmap_band()`. */
FZ_FUNCTION Bitmap::Bitmap(const Pixmap& pix, const Halftone& ht, int band_start)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_bitmap_from_pixmap_band()\n";
	}
	this->m_internal = mupdf::new_bitmap_from_pixmap_band(pix.m_internal, ht.m_internal, band_start);
	if (s_check_refs)
	{
		s_Bitmap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Copy constructor using `fz_keep_bitmap()`. */
FZ_FUNCTION Bitmap::Bitmap(const Bitmap& rhs)
: m_internal(mupdf::keep_bitmap(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_bitmap(this->m_internal) and mupdf::keep_bitmap(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_Bitmap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `fz_keep_bitmap()` and `fz_drop_bitmap()`. */
FZ_FUNCTION Bitmap& Bitmap::operator=(const Bitmap& rhs)
{
	mupdf::drop_bitmap(this->m_internal);
	mupdf::keep_bitmap(rhs.m_internal);
	if (s_check_refs)
	{
		s_Bitmap_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_Bitmap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/* Wrapper for `fz_bitmap_details()`.
	
	This method has out-params. Python/C# wrappers look like:
		`bitmap_details()` => `(int w, int h, int n, int stride)`
	 */
FZ_FUNCTION void Bitmap::bitmap_details(int *w, int *h, int *n, int *stride)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::bitmap_details()\n";
	}
	mupdf::mfz_bitmap_details(*this, w, h, n, stride);
	if (s_check_refs)
	{
		s_Bitmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_clear_bitmap()`.  */
FZ_FUNCTION void Bitmap::clear_bitmap()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clear_bitmap()\n";
	}
	mupdf::mfz_clear_bitmap(*this);
	if (s_check_refs)
	{
		s_Bitmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_save_bitmap_as_pbm()`.  */
FZ_FUNCTION void Bitmap::save_bitmap_as_pbm(const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_bitmap_as_pbm()\n";
	}
	mupdf::mfz_save_bitmap_as_pbm(*this, filename);
	if (s_check_refs)
	{
		s_Bitmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_save_bitmap_as_pcl()`.  */
FZ_FUNCTION void Bitmap::save_bitmap_as_pcl(char *filename, int append, const PclOptions& pcl)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_bitmap_as_pcl()\n";
	}
	mupdf::mfz_save_bitmap_as_pcl(*this, filename, append, pcl);
	if (s_check_refs)
	{
		s_Bitmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_save_bitmap_as_pkm()`.  */
FZ_FUNCTION void Bitmap::save_bitmap_as_pkm(const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_bitmap_as_pkm()\n";
	}
	mupdf::mfz_save_bitmap_as_pkm(*this, filename);
	if (s_check_refs)
	{
		s_Bitmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_save_bitmap_as_pwg()`.  */
FZ_FUNCTION void Bitmap::save_bitmap_as_pwg(char *filename, int append, PwgOptions& pwg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_bitmap_as_pwg()\n";
	}
	mupdf::mfz_save_bitmap_as_pwg(*this, filename, append, pwg);
	if (s_check_refs)
	{
		s_Bitmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION Bitmap::Bitmap(fz_bitmap* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_Bitmap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION int Bitmap::refs()
{
	return m_internal->refs;
}

FZ_FUNCTION int Bitmap::w()
{
	return m_internal->w;
}

FZ_FUNCTION int Bitmap::h()
{
	return m_internal->h;
}

FZ_FUNCTION int Bitmap::stride()
{
	return m_internal->stride;
}

FZ_FUNCTION int Bitmap::n()
{
	return m_internal->n;
}

FZ_FUNCTION int Bitmap::xres()
{
	return m_internal->xres;
}

FZ_FUNCTION int Bitmap::yres()
{
	return m_internal->yres;
}

FZ_FUNCTION const unsigned char *Bitmap::samples()
{
	return m_internal->samples;
}

FZ_FUNCTION Bitmap::~Bitmap()
{
	mupdf::drop_bitmap(m_internal);
	if (s_check_refs)
	{
		s_Bitmap_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long Bitmap::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Buffer (wrapper for fz_buffer). */

static RefsCheck<fz_buffer, Buffer> s_Buffer_refs_check(offsetof(fz_buffer, refs), 32);

/* Constructor using `fz_new_buffer()`. */
FZ_FUNCTION Buffer::Buffer(size_t capacity)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer()\n";
	}
	this->m_internal = mupdf::new_buffer(capacity);
	if (s_check_refs)
	{
		s_Buffer_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_buffer_from_base64()`. */
FZ_FUNCTION Buffer::Buffer(const char *data, size_t size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_base64()\n";
	}
	this->m_internal = mupdf::new_buffer_from_base64(data, size);
	if (s_check_refs)
	{
		s_Buffer_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_buffer_from_data()`. */
FZ_FUNCTION Buffer::Buffer(unsigned char *data, size_t size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_data()\n";
	}
	this->m_internal = mupdf::new_buffer_from_data(data, size);
	if (s_check_refs)
	{
		s_Buffer_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_buffer_from_display_list()`. */
FZ_FUNCTION Buffer::Buffer(const DisplayList& list, StextOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_display_list()\n";
	}
	this->m_internal = mupdf::new_buffer_from_display_list(list.m_internal, (const fz_stext_options *) &options.flags);
	if (s_check_refs)
	{
		s_Buffer_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_buffer_from_image_as_png()`. */
FZ_FUNCTION Buffer::Buffer(const Image& image, ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_image_as_png()\n";
	}
	this->m_internal = mupdf::new_buffer_from_image_as_png(image.m_internal, *(fz_color_params*) &color_params.ri);
	if (s_check_refs)
	{
		s_Buffer_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_buffer_from_page()`. */
FZ_FUNCTION Buffer::Buffer(const Page& page, StextOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_page()\n";
	}
	this->m_internal = mupdf::new_buffer_from_page(page.m_internal, (const fz_stext_options *) &options.flags);
	if (s_check_refs)
	{
		s_Buffer_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_buffer_from_page_number()`. */
FZ_FUNCTION Buffer::Buffer(const Document& doc, int number, StextOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_page_number()\n";
	}
	this->m_internal = mupdf::new_buffer_from_page_number(doc.m_internal, number, (const fz_stext_options *) &options.flags);
	if (s_check_refs)
	{
		s_Buffer_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_buffer_from_page_with_format()`. */
FZ_FUNCTION Buffer::Buffer(const Page& page, const char *format, const char *options, Matrix& transform, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_page_with_format()\n";
	}
	this->m_internal = mupdf::new_buffer_from_page_with_format(page.m_internal, format, options, *(fz_matrix*) &transform.a, &cookie.m_internal);
	if (s_check_refs)
	{
		s_Buffer_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_buffer_from_pixmap_as_png()`. */
FZ_FUNCTION Buffer::Buffer(const Pixmap& pixmap, ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_pixmap_as_png()\n";
	}
	this->m_internal = mupdf::new_buffer_from_pixmap_as_png(pixmap.m_internal, *(fz_color_params*) &color_params.ri);
	if (s_check_refs)
	{
		s_Buffer_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_buffer_from_shared_data()`. */
FZ_FUNCTION Buffer::Buffer(const unsigned char *data, size_t size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_shared_data()\n";
	}
	this->m_internal = mupdf::new_buffer_from_shared_data(data, size);
	if (s_check_refs)
	{
		s_Buffer_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_buffer_from_stext_page()`. */
FZ_FUNCTION Buffer::Buffer(const StextPage& text)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_stext_page()\n";
	}
	this->m_internal = mupdf::new_buffer_from_stext_page(text.m_internal);
	if (s_check_refs)
	{
		s_Buffer_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_read_file()`. */
FZ_FUNCTION Buffer::Buffer(const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_file()\n";
	}
	this->m_internal = mupdf::read_file(filename);
	if (s_check_refs)
	{
		s_Buffer_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Copy constructor using `fz_keep_buffer()`. */
FZ_FUNCTION Buffer::Buffer(const Buffer& rhs)
: m_internal(mupdf::keep_buffer(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_buffer(this->m_internal) and mupdf::keep_buffer(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_Buffer_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `fz_keep_buffer()` and `fz_drop_buffer()`. */
FZ_FUNCTION Buffer& Buffer::operator=(const Buffer& rhs)
{
	mupdf::drop_buffer(this->m_internal);
	mupdf::keep_buffer(rhs.m_internal);
	if (s_check_refs)
	{
		s_Buffer_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_Buffer_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/* Wrapper for `fz_new_buffer_from_copied_data()`.  */
FZ_FUNCTION Buffer Buffer::new_buffer_from_copied_data(const unsigned char *data, size_t size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_copied_data()\n";
	}
	auto ret = mupdf::mfz_new_buffer_from_copied_data(data, size);
	return ret;
}

/* Wrapper for `fz_append_bits()`.  */
FZ_FUNCTION void Buffer::append_bits(int value, int count)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::append_bits()\n";
	}
	mupdf::mfz_append_bits(*this, value, count);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_append_bits_pad()`.  */
FZ_FUNCTION void Buffer::append_bits_pad()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::append_bits_pad()\n";
	}
	mupdf::mfz_append_bits_pad(*this);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_append_buffer()`.  */
FZ_FUNCTION void Buffer::append_buffer(const Buffer& source)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::append_buffer()\n";
	}
	mupdf::mfz_append_buffer(*this, source);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_append_byte()`.  */
FZ_FUNCTION void Buffer::append_byte(int c)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::append_byte()\n";
	}
	mupdf::mfz_append_byte(*this, c);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_append_data()`.  */
FZ_FUNCTION void Buffer::append_data(const void *data, size_t len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::append_data()\n";
	}
	mupdf::mfz_append_data(*this, data, len);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_append_int16_be()`.  */
FZ_FUNCTION void Buffer::append_int16_be(int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::append_int16_be()\n";
	}
	mupdf::mfz_append_int16_be(*this, x);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_append_int16_le()`.  */
FZ_FUNCTION void Buffer::append_int16_le(int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::append_int16_le()\n";
	}
	mupdf::mfz_append_int16_le(*this, x);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_append_int32_be()`.  */
FZ_FUNCTION void Buffer::append_int32_be(int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::append_int32_be()\n";
	}
	mupdf::mfz_append_int32_be(*this, x);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_append_int32_le()`.  */
FZ_FUNCTION void Buffer::append_int32_le(int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::append_int32_le()\n";
	}
	mupdf::mfz_append_int32_le(*this, x);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_append_pdf_string()`.  */
FZ_FUNCTION void Buffer::append_pdf_string(const char *text)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::append_pdf_string()\n";
	}
	mupdf::mfz_append_pdf_string(*this, text);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_append_rune()`.  */
FZ_FUNCTION void Buffer::append_rune(int c)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::append_rune()\n";
	}
	mupdf::mfz_append_rune(*this, c);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_append_string()`.  */
FZ_FUNCTION void Buffer::append_string(const char *data)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::append_string()\n";
	}
	mupdf::mfz_append_string(*this, data);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_append_vprintf()`.  */
FZ_FUNCTION void Buffer::append_vprintf(const char *fmt, va_list args)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::append_vprintf()\n";
	}
	mupdf::mfz_append_vprintf(*this, fmt, args);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_buffer_extract()`.
	
	This method has out-params. Python/C# wrappers look like:
		`buffer_extract()` => `(size_t, unsigned char *data)`
	 */
FZ_FUNCTION size_t Buffer::buffer_extract(unsigned char **data)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::buffer_extract()\n";
	}
	auto ret = mupdf::mfz_buffer_extract(*this, data);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_buffer_storage()`.
	
	This method has out-params. Python/C# wrappers look like:
		`buffer_storage()` => `(size_t, unsigned char *datap)`
	 */
FZ_FUNCTION size_t Buffer::buffer_storage(unsigned char **datap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::buffer_storage()\n";
	}
	auto ret = mupdf::mfz_buffer_storage(*this, datap);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_clear_buffer()`.  */
FZ_FUNCTION void Buffer::clear_buffer()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clear_buffer()\n";
	}
	mupdf::mfz_clear_buffer(*this);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_grow_buffer()`.  */
FZ_FUNCTION void Buffer::grow_buffer()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::grow_buffer()\n";
	}
	mupdf::mfz_grow_buffer(*this);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_load_jbig2_globals()`.  */
FZ_FUNCTION Jbig2Globals Buffer::load_jbig2_globals()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_jbig2_globals()\n";
	}
	auto ret = mupdf::mfz_load_jbig2_globals(*this);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_md5_buffer()`.  */
FZ_FUNCTION void Buffer::md5_buffer(unsigned char digest[16])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::md5_buffer()\n";
	}
	mupdf::mfz_md5_buffer(*this, digest);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_new_display_list_from_svg()`.
	
	This method has out-params. Python/C# wrappers look like:
		`new_display_list_from_svg(const char *base_uri, fz_archive *zip)` => `(fz_display_list *, float w, float h)`
	 */
FZ_FUNCTION DisplayList Buffer::new_display_list_from_svg(const char *base_uri, const Archive& zip, float *w, float *h)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_display_list_from_svg()\n";
	}
	auto ret = mupdf::mfz_new_display_list_from_svg(*this, base_uri, zip, w, h);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_image_from_buffer()`.  */
FZ_FUNCTION Image Buffer::new_image_from_buffer()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_image_from_buffer()\n";
	}
	auto ret = mupdf::mfz_new_image_from_buffer(*this);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_image_from_svg()`.  */
FZ_FUNCTION Image Buffer::new_image_from_svg(const char *base_uri, const Archive& zip)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_image_from_svg()\n";
	}
	auto ret = mupdf::mfz_new_image_from_svg(*this, base_uri, zip);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_open_buffer()`.  */
FZ_FUNCTION Stream Buffer::open_buffer()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_buffer()\n";
	}
	auto ret = mupdf::mfz_open_buffer(*this);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_resize_buffer()`.  */
FZ_FUNCTION void Buffer::resize_buffer(size_t capacity)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::resize_buffer()\n";
	}
	mupdf::mfz_resize_buffer(*this, capacity);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_save_buffer()`.  */
FZ_FUNCTION void Buffer::save_buffer(const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_buffer()\n";
	}
	mupdf::mfz_save_buffer(*this, filename);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_string_from_buffer()`.  */
FZ_FUNCTION const char *Buffer::string_from_buffer()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::string_from_buffer()\n";
	}
	auto ret = mupdf::mfz_string_from_buffer(*this);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_terminate_buffer()`.  */
FZ_FUNCTION void Buffer::terminate_buffer()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::terminate_buffer()\n";
	}
	mupdf::mfz_terminate_buffer(*this);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_trim_buffer()`.  */
FZ_FUNCTION void Buffer::trim_buffer()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::trim_buffer()\n";
	}
	mupdf::mfz_trim_buffer(*this);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_append_token()`.  */
FZ_FUNCTION void Buffer::append_token(int tok, const PdfLexbuf& lex)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_append_token()\n";
	}
	mupdf::mpdf_append_token(*this, tok, lex);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_new_buffer_processor()`.  */
FZ_FUNCTION PdfProcessor Buffer::new_buffer_processor(int ahxencode)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_buffer_processor()\n";
	}
	auto ret = mupdf::mpdf_new_buffer_processor(*this, ahxencode);
	if (s_check_refs)
	{
		s_Buffer_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

FZ_FUNCTION Buffer::Buffer(fz_buffer* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_Buffer_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION Buffer::~Buffer()
{
	mupdf::drop_buffer(m_internal);
	if (s_check_refs)
	{
		s_Buffer_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long Buffer::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for ColorParams (wrapper for fz_color_params). */

/** Custom constructor. */
FZ_FUNCTION ColorParams::ColorParams()
{
	this->ri = fz_default_color_params.ri;
	this->bp = fz_default_color_params.bp;
	this->op = fz_default_color_params.op;
	this->opm = fz_default_color_params.opm;
}

FZ_FUNCTION ColorParams::ColorParams(const fz_color_params* internal)
{
	this->ri = internal->ri;
	this->bp = internal->bp;
	this->op = internal->op;
	this->opm = internal->opm;
}

FZ_FUNCTION ColorParams::ColorParams(const fz_color_params internal)
{
	this->ri = internal.ri;
	this->bp = internal.bp;
	this->op = internal.op;
	this->opm = internal.opm;
}

/** Constructor using raw copy of pre-existing `fz_color_params`. */
FZ_FUNCTION fz_color_params* ColorParams::internal()
{
	auto ret = (fz_color_params*) &this->ri;
	return ret;
}

/** Constructor using raw copy of pre-existing `fz_color_params`. */
FZ_FUNCTION const fz_color_params* ColorParams::internal() const
{
	auto ret = (const fz_color_params*) &this->ri;
	return ret;
}

FZ_FUNCTION std::string ColorParams::to_string()
{
	std::ostringstream buffer;
	buffer << *this;
	return buffer.str();
}


FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const ColorParams& rhs)
{
	return out << *rhs.internal();
}

/* Implementation of methods for Colorspace (wrapper for fz_colorspace). */

static RefsCheck<fz_colorspace, Colorspace> s_Colorspace_refs_check(offsetof(fz_colorspace, key_storable.storable.refs), 32);

/* Constructor using `fz_new_cal_gray_colorspace()`. */
FZ_FUNCTION Colorspace::Colorspace(float wp[3], float bp[3], float gamma)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_cal_gray_colorspace()\n";
	}
	this->m_internal = mupdf::new_cal_gray_colorspace(wp, bp, gamma);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_cal_rgb_colorspace()`. */
FZ_FUNCTION Colorspace::Colorspace(float wp[3], float bp[3], float gamma[3], float matrix[9])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_cal_rgb_colorspace()\n";
	}
	this->m_internal = mupdf::new_cal_rgb_colorspace(wp, bp, gamma, matrix);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_colorspace()`. */
FZ_FUNCTION Colorspace::Colorspace(enum fz_colorspace_type type, int flags, int n, const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_colorspace()\n";
	}
	this->m_internal = mupdf::new_colorspace(type, flags, n, name);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_icc_colorspace()`. */
FZ_FUNCTION Colorspace::Colorspace(enum fz_colorspace_type type, int flags, const char *name, const Buffer& buf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_icc_colorspace()\n";
	}
	this->m_internal = mupdf::new_icc_colorspace(type, flags, name, buf.m_internal);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_indexed_colorspace()`. */
FZ_FUNCTION Colorspace::Colorspace(const Colorspace& base, int high, unsigned char *lookup)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_indexed_colorspace()\n";
	}
	this->m_internal = mupdf::new_indexed_colorspace(base.m_internal, high, lookup);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom constructor. */
FZ_FUNCTION Colorspace::Colorspace(Fixed fixed)
{
	if (0) {}
	else if ( fixed == Fixed_GRAY)  m_internal = mupdf::device_gray();
	else if ( fixed == Fixed_RGB)   m_internal = mupdf::device_rgb();
	else if ( fixed == Fixed_BGR)   m_internal = mupdf::device_bgr();
	else if ( fixed == Fixed_CMYK)  m_internal = mupdf::device_cmyk();
	else if ( fixed == Fixed_LAB)   m_internal = mupdf::device_lab();
	else {
		std::string message = "Unrecognised fixed colorspace id";
		throw ErrorGeneric(message.c_str());
	}
	mupdf::keep_colorspace(m_internal);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom constructor. */
FZ_FUNCTION Colorspace::Colorspace()
: m_internal( NULL)
{
	if (s_check_refs)
	{
		s_Colorspace_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Copy constructor using `fz_keep_colorspace()`. */
FZ_FUNCTION Colorspace::Colorspace(const Colorspace& rhs)
: m_internal(mupdf::keep_colorspace(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_colorspace(this->m_internal) and mupdf::keep_colorspace(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_Colorspace_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `fz_keep_colorspace()` and `fz_drop_colorspace()`. */
FZ_FUNCTION Colorspace& Colorspace::operator=(const Colorspace& rhs)
{
	mupdf::drop_colorspace(this->m_internal);
	mupdf::keep_colorspace(rhs.m_internal);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_Colorspace_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/* Wrapper for `fz_clamp_color()`.
	
	This method has out-params. Python/C# wrappers look like:
		`clamp_color(const float *in)` => float out
	 */
FZ_FUNCTION void Colorspace::clamp_color(const float *in, float *out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clamp_color()\n";
	}
	mupdf::mfz_clamp_color(*this, in, out);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_colorspace_colorant()`.  */
FZ_FUNCTION const char *Colorspace::colorspace_colorant(int n)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_colorant()\n";
	}
	auto ret = mupdf::mfz_colorspace_colorant(*this, n);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_colorspace_device_n_has_cmyk()`.  */
FZ_FUNCTION int Colorspace::colorspace_device_n_has_cmyk()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_device_n_has_cmyk()\n";
	}
	auto ret = mupdf::mfz_colorspace_device_n_has_cmyk(*this);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_colorspace_device_n_has_only_cmyk()`.  */
FZ_FUNCTION int Colorspace::colorspace_device_n_has_only_cmyk()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_device_n_has_only_cmyk()\n";
	}
	auto ret = mupdf::mfz_colorspace_device_n_has_only_cmyk(*this);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_colorspace_is_cmyk()`.  */
FZ_FUNCTION int Colorspace::colorspace_is_cmyk()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_is_cmyk()\n";
	}
	auto ret = mupdf::mfz_colorspace_is_cmyk(*this);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_colorspace_is_device()`.  */
FZ_FUNCTION int Colorspace::colorspace_is_device()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_is_device()\n";
	}
	auto ret = mupdf::mfz_colorspace_is_device(*this);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_colorspace_is_device_cmyk()`.  */
FZ_FUNCTION int Colorspace::colorspace_is_device_cmyk()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_is_device_cmyk()\n";
	}
	auto ret = mupdf::mfz_colorspace_is_device_cmyk(*this);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_colorspace_is_device_gray()`.  */
FZ_FUNCTION int Colorspace::colorspace_is_device_gray()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_is_device_gray()\n";
	}
	auto ret = mupdf::mfz_colorspace_is_device_gray(*this);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_colorspace_is_device_n()`.  */
FZ_FUNCTION int Colorspace::colorspace_is_device_n()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_is_device_n()\n";
	}
	auto ret = mupdf::mfz_colorspace_is_device_n(*this);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_colorspace_is_gray()`.  */
FZ_FUNCTION int Colorspace::colorspace_is_gray()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_is_gray()\n";
	}
	auto ret = mupdf::mfz_colorspace_is_gray(*this);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_colorspace_is_indexed()`.  */
FZ_FUNCTION int Colorspace::colorspace_is_indexed()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_is_indexed()\n";
	}
	auto ret = mupdf::mfz_colorspace_is_indexed(*this);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_colorspace_is_lab()`.  */
FZ_FUNCTION int Colorspace::colorspace_is_lab()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_is_lab()\n";
	}
	auto ret = mupdf::mfz_colorspace_is_lab(*this);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_colorspace_is_lab_icc()`.  */
FZ_FUNCTION int Colorspace::colorspace_is_lab_icc()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_is_lab_icc()\n";
	}
	auto ret = mupdf::mfz_colorspace_is_lab_icc(*this);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_colorspace_is_rgb()`.  */
FZ_FUNCTION int Colorspace::colorspace_is_rgb()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_is_rgb()\n";
	}
	auto ret = mupdf::mfz_colorspace_is_rgb(*this);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_colorspace_is_subtractive()`.  */
FZ_FUNCTION int Colorspace::colorspace_is_subtractive()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_is_subtractive()\n";
	}
	auto ret = mupdf::mfz_colorspace_is_subtractive(*this);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_colorspace_n()`.  */
FZ_FUNCTION int Colorspace::colorspace_n()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_n()\n";
	}
	auto ret = mupdf::mfz_colorspace_n(*this);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_colorspace_name()`.  */
FZ_FUNCTION const char *Colorspace::colorspace_name()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_name()\n";
	}
	auto ret = mupdf::mfz_colorspace_name(*this);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_colorspace_name_colorant()`.  */
FZ_FUNCTION void Colorspace::colorspace_name_colorant(int n, const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_name_colorant()\n";
	}
	mupdf::mfz_colorspace_name_colorant(*this, n, name);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_colorspace_type()`.  */
FZ_FUNCTION enum fz_colorspace_type Colorspace::colorspace_type()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::colorspace_type()\n";
	}
	auto ret = mupdf::mfz_colorspace_type(*this);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_convert_color()`.
	
	This method has out-params. Python/C# wrappers look like:
		`convert_color(const float *sv, fz_colorspace *ds, fz_colorspace *is, fz_color_params params)` => float dv
	 */
FZ_FUNCTION void Colorspace::convert_color(const float *sv, const Colorspace& ds, float *dv, const Colorspace& is, ColorParams& params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::convert_color()\n";
	}
	mupdf::mfz_convert_color(*this, sv, ds, dv, is, params);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_convert_separation_colors()`.
	
	This method has out-params. Python/C# wrappers look like:
		`convert_separation_colors(const float *src_color, fz_separations *dst_seps, fz_colorspace *dst_cs, fz_color_params color_params)` => float dst_color
	 */
FZ_FUNCTION void Colorspace::convert_separation_colors(const float *src_color, const Separations& dst_seps, const Colorspace& dst_cs, float *dst_color, ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::convert_separation_colors()\n";
	}
	mupdf::mfz_convert_separation_colors(*this, src_color, dst_seps, dst_cs, dst_color, color_params);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_is_valid_blend_colorspace()`.  */
FZ_FUNCTION int Colorspace::is_valid_blend_colorspace()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_valid_blend_colorspace()\n";
	}
	auto ret = mupdf::mfz_is_valid_blend_colorspace(*this);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_indexed_colorspace()`.  */
FZ_FUNCTION Colorspace Colorspace::new_indexed_colorspace(int high, unsigned char *lookup)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_indexed_colorspace()\n";
	}
	auto ret = mupdf::mfz_new_indexed_colorspace(*this, high, lookup);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_pixmap()`.  */
FZ_FUNCTION Pixmap Colorspace::new_pixmap(int w, int h, const Separations& seps, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap()\n";
	}
	auto ret = mupdf::mfz_new_pixmap(*this, w, h, seps, alpha);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_pixmap_with_bbox()`.  */
FZ_FUNCTION Pixmap Colorspace::new_pixmap_with_bbox(Irect& bbox, const Separations& seps, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_with_bbox()\n";
	}
	auto ret = mupdf::mfz_new_pixmap_with_bbox(*this, bbox, seps, alpha);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_pixmap_with_bbox_and_data()`.  */
FZ_FUNCTION Pixmap Colorspace::new_pixmap_with_bbox_and_data(Irect& rect, const Separations& seps, int alpha, unsigned char *samples)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_with_bbox_and_data()\n";
	}
	auto ret = mupdf::mfz_new_pixmap_with_bbox_and_data(*this, rect, seps, alpha, samples);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_pixmap_with_data()`.  */
FZ_FUNCTION Pixmap Colorspace::new_pixmap_with_data(int w, int h, const Separations& seps, int alpha, int stride, unsigned char *samples)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_with_data()\n";
	}
	auto ret = mupdf::mfz_new_pixmap_with_data(*this, w, h, seps, alpha, stride, samples);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_is_tint_colorspace()`.  */
FZ_FUNCTION int Colorspace::is_tint_colorspace()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_tint_colorspace()\n";
	}
	auto ret = mupdf::mpdf_is_tint_colorspace(*this);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

FZ_FUNCTION Colorspace::Colorspace(fz_colorspace* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_Colorspace_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION Colorspace::~Colorspace()
{
	mupdf::drop_colorspace(m_internal);
	if (s_check_refs)
	{
		s_Colorspace_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long Colorspace::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for ColorspaceContext (wrapper for fz_colorspace_context). */

FZ_FUNCTION ColorspaceContext::ColorspaceContext(fz_colorspace_context* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long ColorspaceContext::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for CompressedBuffer (wrapper for fz_compressed_buffer). */

/* Wrapper for `fz_compressed_buffer_size()`.  */
FZ_FUNCTION size_t CompressedBuffer::compressed_buffer_size()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::compressed_buffer_size()\n";
	}
	auto ret = mupdf::mfz_compressed_buffer_size(*this);
	return ret;
}

/* Wrapper for `fz_open_compressed_buffer()`.  */
FZ_FUNCTION Stream CompressedBuffer::open_compressed_buffer()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_compressed_buffer()\n";
	}
	auto ret = mupdf::mfz_open_compressed_buffer(*this);
	return ret;
}

/* Wrapper for `fz_open_image_decomp_stream_from_buffer()`.
	
	This method has out-params. Python/C# wrappers look like:
		`open_image_decomp_stream_from_buffer()` => `(fz_stream *, int l2factor)`
	 */
FZ_FUNCTION Stream CompressedBuffer::open_image_decomp_stream_from_buffer(int *l2factor)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_image_decomp_stream_from_buffer()\n";
	}
	auto ret = mupdf::mfz_open_image_decomp_stream_from_buffer(*this, l2factor);
	return ret;
}

FZ_FUNCTION CompressedBuffer::CompressedBuffer(fz_compressed_buffer* internal)
: m_internal(internal)
{
}

FZ_FUNCTION CompressedBuffer::~CompressedBuffer()
{
	mupdf::drop_compressed_buffer(m_internal);
}

/** Custom method. */
FZ_FUNCTION long long CompressedBuffer::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for CompressedImage (wrapper for fz_compressed_image). */

/* Wrapper for `fz_set_compressed_image_buffer()`.  */
FZ_FUNCTION void CompressedImage::set_compressed_image_buffer(const CompressedBuffer& buf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_compressed_image_buffer()\n";
	}
	mupdf::mfz_set_compressed_image_buffer(*this, buf);
}

FZ_FUNCTION CompressedImage::CompressedImage(fz_compressed_image* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long CompressedImage::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for CompressionParams (wrapper for fz_compression_params). */

FZ_FUNCTION CompressionParams::CompressionParams(fz_compression_params* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long CompressionParams::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Context (wrapper for fz_context). */

/* Constructor using `fz_new_context_imp()`. */
FZ_FUNCTION Context::Context(const AllocContext& alloc, const LocksContext& locks, size_t max_store, const char *version)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_context_imp()\n";
	}
	this->m_internal = mupdf::new_context_imp(alloc.m_internal, locks.m_internal, max_store, version);
}

FZ_FUNCTION Context::Context(fz_context* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long Context::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Cookie (wrapper for fz_cookie). */

/** Custom constructor. */
FZ_FUNCTION Cookie::Cookie()
{
	this->m_internal.abort = 0;
	this->m_internal.progress = 0;
	this->m_internal.progress_max = (size_t) -1;
	this->m_internal.errors = 0;
	this->m_internal.incomplete = 0;
}

/** Custom method. */
FZ_FUNCTION void Cookie::set_abort(){ m_internal.abort = 1; }

/** Custom method. */
FZ_FUNCTION void Cookie::increment_errors(int delta){ m_internal.errors += delta; }

FZ_FUNCTION int Cookie::abort()
{
	return m_internal.abort;
}

FZ_FUNCTION int Cookie::progress()
{
	return m_internal.progress;
}

FZ_FUNCTION size_t Cookie::progress_max()
{
	return m_internal.progress_max;
}

FZ_FUNCTION int Cookie::errors()
{
	return m_internal.errors;
}

FZ_FUNCTION int Cookie::incomplete()
{
	return m_internal.incomplete;
}

FZ_FUNCTION std::string Cookie::to_string()
{
	std::ostringstream buffer;
	buffer << *this;
	return buffer.str();
}


FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const Cookie& rhs)
{
	return out << rhs.m_internal;
}

/* Implementation of methods for DefaultColorspaces (wrapper for fz_default_colorspaces). */

static RefsCheck<fz_default_colorspaces, DefaultColorspaces> s_DefaultColorspaces_refs_check(offsetof(fz_default_colorspaces, refs), 32);

/* Constructor using `fz_new_default_colorspaces()`. */
FZ_FUNCTION DefaultColorspaces::DefaultColorspaces()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_default_colorspaces()\n";
	}
	this->m_internal = mupdf::new_default_colorspaces();
	if (s_check_refs)
	{
		s_DefaultColorspaces_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Copy constructor using `fz_keep_default_colorspaces()`. */
FZ_FUNCTION DefaultColorspaces::DefaultColorspaces(const DefaultColorspaces& rhs)
: m_internal(mupdf::keep_default_colorspaces(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_default_colorspaces(this->m_internal) and mupdf::keep_default_colorspaces(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_DefaultColorspaces_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `fz_keep_default_colorspaces()` and `fz_drop_default_colorspaces()`. */
FZ_FUNCTION DefaultColorspaces& DefaultColorspaces::operator=(const DefaultColorspaces& rhs)
{
	mupdf::drop_default_colorspaces(this->m_internal);
	mupdf::keep_default_colorspaces(rhs.m_internal);
	if (s_check_refs)
	{
		s_DefaultColorspaces_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_DefaultColorspaces_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/* Wrapper for `fz_clone_default_colorspaces()`.  */
FZ_FUNCTION DefaultColorspaces DefaultColorspaces::clone_default_colorspaces()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clone_default_colorspaces()\n";
	}
	auto ret = mupdf::mfz_clone_default_colorspaces(*this);
	if (s_check_refs)
	{
		s_DefaultColorspaces_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_default_cmyk()`.  */
FZ_FUNCTION Colorspace DefaultColorspaces::default_cmyk()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::default_cmyk()\n";
	}
	auto ret = mupdf::mfz_default_cmyk(*this);
	if (s_check_refs)
	{
		s_DefaultColorspaces_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_default_gray()`.  */
FZ_FUNCTION Colorspace DefaultColorspaces::default_gray()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::default_gray()\n";
	}
	auto ret = mupdf::mfz_default_gray(*this);
	if (s_check_refs)
	{
		s_DefaultColorspaces_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_default_output_intent()`.  */
FZ_FUNCTION Colorspace DefaultColorspaces::default_output_intent()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::default_output_intent()\n";
	}
	auto ret = mupdf::mfz_default_output_intent(*this);
	if (s_check_refs)
	{
		s_DefaultColorspaces_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_default_rgb()`.  */
FZ_FUNCTION Colorspace DefaultColorspaces::default_rgb()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::default_rgb()\n";
	}
	auto ret = mupdf::mfz_default_rgb(*this);
	if (s_check_refs)
	{
		s_DefaultColorspaces_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_set_default_cmyk()`.  */
FZ_FUNCTION void DefaultColorspaces::set_default_cmyk(const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_default_cmyk()\n";
	}
	mupdf::mfz_set_default_cmyk(*this, cs);
	if (s_check_refs)
	{
		s_DefaultColorspaces_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_set_default_gray()`.  */
FZ_FUNCTION void DefaultColorspaces::set_default_gray(const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_default_gray()\n";
	}
	mupdf::mfz_set_default_gray(*this, cs);
	if (s_check_refs)
	{
		s_DefaultColorspaces_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_set_default_output_intent()`.  */
FZ_FUNCTION void DefaultColorspaces::set_default_output_intent(const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_default_output_intent()\n";
	}
	mupdf::mfz_set_default_output_intent(*this, cs);
	if (s_check_refs)
	{
		s_DefaultColorspaces_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_set_default_rgb()`.  */
FZ_FUNCTION void DefaultColorspaces::set_default_rgb(const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_default_rgb()\n";
	}
	mupdf::mfz_set_default_rgb(*this, cs);
	if (s_check_refs)
	{
		s_DefaultColorspaces_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_update_default_colorspaces()`.  */
FZ_FUNCTION DefaultColorspaces DefaultColorspaces::update_default_colorspaces(const PdfObj& res)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_update_default_colorspaces()\n";
	}
	auto ret = mupdf::mpdf_update_default_colorspaces(*this, res);
	if (s_check_refs)
	{
		s_DefaultColorspaces_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

FZ_FUNCTION DefaultColorspaces::DefaultColorspaces(fz_default_colorspaces* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_DefaultColorspaces_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION DefaultColorspaces::~DefaultColorspaces()
{
	mupdf::drop_default_colorspaces(m_internal);
	if (s_check_refs)
	{
		s_DefaultColorspaces_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long DefaultColorspaces::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Device (wrapper for fz_device). */

static RefsCheck<fz_device, Device> s_Device_refs_check(offsetof(fz_device, refs), 32);

/* Constructor using `fz_new_bbox_device()`. */
FZ_FUNCTION Device::Device(Rect& rectp)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_bbox_device()\n";
	}
	this->m_internal = mupdf::new_bbox_device((fz_rect *) &rectp.x0);
	if (s_check_refs)
	{
		s_Device_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_device_of_size()`. */
FZ_FUNCTION Device::Device(int size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_device_of_size()\n";
	}
	this->m_internal = mupdf::new_device_of_size(size);
	if (s_check_refs)
	{
		s_Device_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_draw_device()`. */
FZ_FUNCTION Device::Device(Matrix& transform, const Pixmap& dest)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_draw_device()\n";
	}
	this->m_internal = mupdf::new_draw_device(*(fz_matrix*) &transform.a, dest.m_internal);
	if (s_check_refs)
	{
		s_Device_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_draw_device_with_bbox()`. */
FZ_FUNCTION Device::Device(Matrix& transform, const Pixmap& dest, Irect& clip)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_draw_device_with_bbox()\n";
	}
	this->m_internal = mupdf::new_draw_device_with_bbox(*(fz_matrix*) &transform.a, dest.m_internal, (const fz_irect *) &clip.x0);
	if (s_check_refs)
	{
		s_Device_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_draw_device_with_bbox_proof()`. */
FZ_FUNCTION Device::Device(Matrix& transform, const Pixmap& dest, Irect& clip, const Colorspace& cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_draw_device_with_bbox_proof()\n";
	}
	this->m_internal = mupdf::new_draw_device_with_bbox_proof(*(fz_matrix*) &transform.a, dest.m_internal, (const fz_irect *) &clip.x0, cs.m_internal);
	if (s_check_refs)
	{
		s_Device_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_draw_device_with_proof()`. */
FZ_FUNCTION Device::Device(Matrix& transform, const Pixmap& dest, const Colorspace& proof_cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_draw_device_with_proof()\n";
	}
	this->m_internal = mupdf::new_draw_device_with_proof(*(fz_matrix*) &transform.a, dest.m_internal, proof_cs.m_internal);
	if (s_check_refs)
	{
		s_Device_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_list_device()`. */
FZ_FUNCTION Device::Device(const DisplayList& list)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_list_device()\n";
	}
	this->m_internal = mupdf::new_list_device(list.m_internal);
	if (s_check_refs)
	{
		s_Device_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_ocr_device()`. */
FZ_FUNCTION Device::Device(const Device& target, Matrix& ctm, Rect& mediabox, int with_list, const char *language, const char *datadir, int (*progress)(fz_context *, void *, int ), void *progress_arg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_ocr_device()\n";
	}
	this->m_internal = mupdf::new_ocr_device(target.m_internal, *(fz_matrix*) &ctm.a, *(fz_rect*) &mediabox.x0, with_list, language, datadir, progress, progress_arg);
	if (s_check_refs)
	{
		s_Device_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_stext_device()`. */
FZ_FUNCTION Device::Device(const StextPage& page, StextOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_stext_device()\n";
	}
	this->m_internal = mupdf::new_stext_device(page.m_internal, (const fz_stext_options *) &options.flags);
	if (s_check_refs)
	{
		s_Device_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_svg_device()`. */
FZ_FUNCTION Device::Device(const Output& out, float page_width, float page_height, int text_format, int reuse_images)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_svg_device()\n";
	}
	this->m_internal = mupdf::new_svg_device(out.m_internal, page_width, page_height, text_format, reuse_images);
	if (s_check_refs)
	{
		s_Device_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_svg_device_with_id()`. */
FZ_FUNCTION Device::Device(const Output& out, float page_width, float page_height, int text_format, int reuse_images, int *id)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_svg_device_with_id()\n";
	}
	this->m_internal = mupdf::new_svg_device_with_id(out.m_internal, page_width, page_height, text_format, reuse_images, id);
	if (s_check_refs)
	{
		s_Device_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_test_device()`. */
FZ_FUNCTION Device::Device(int *is_color, float threshold, int options, const Device& passthrough)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_test_device()\n";
	}
	this->m_internal = mupdf::new_test_device(is_color, threshold, options, passthrough.m_internal);
	if (s_check_refs)
	{
		s_Device_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_trace_device()`. */
FZ_FUNCTION Device::Device(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_trace_device()\n";
	}
	this->m_internal = mupdf::new_trace_device(out.m_internal);
	if (s_check_refs)
	{
		s_Device_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom constructor. */
FZ_FUNCTION Device::Device()
: m_internal( NULL)
{
	if (s_check_refs)
	{
		s_Device_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	if (s_check_refs)
	{
		s_Device_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Copy constructor using `fz_keep_device()`. */
FZ_FUNCTION Device::Device(const Device& rhs)
: m_internal(mupdf::keep_device(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_device(this->m_internal) and mupdf::keep_device(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_Device_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `fz_keep_device()` and `fz_drop_device()`. */
FZ_FUNCTION Device& Device::operator=(const Device& rhs)
{
	mupdf::drop_device(this->m_internal);
	mupdf::keep_device(rhs.m_internal);
	if (s_check_refs)
	{
		s_Device_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_Device_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/* Wrapper for `fz_new_xmltext_device()`.  */
FZ_FUNCTION Device Device::new_xmltext_device(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_xmltext_device()\n";
	}
	auto ret = mupdf::mfz_new_xmltext_device(out);
	return ret;
}

/* Wrapper for `fz_new_draw_device_type3()`.  */
FZ_FUNCTION Device Device::new_draw_device_type3(Matrix& transform, const Pixmap& dest)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_draw_device_type3()\n";
	}
	auto ret = mupdf::mfz_new_draw_device_type3(transform, dest);
	return ret;
}

/* Wrapper for `fz_begin_group()`.  */
FZ_FUNCTION void Device::begin_group(Rect& area, const Colorspace& cs, int isolated, int knockout, int blendmode, float alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::begin_group()\n";
	}
	mupdf::mfz_begin_group(*this, area, cs, isolated, knockout, blendmode, alpha);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_begin_layer()`.  */
FZ_FUNCTION void Device::begin_layer(const char *layer_name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::begin_layer()\n";
	}
	mupdf::mfz_begin_layer(*this, layer_name);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_begin_mask()`.  */
FZ_FUNCTION void Device::begin_mask(Rect& area, int luminosity, const Colorspace& colorspace, const float *bc, ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::begin_mask()\n";
	}
	mupdf::mfz_begin_mask(*this, area, luminosity, colorspace, bc, color_params);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_begin_tile()`.  */
FZ_FUNCTION void Device::begin_tile(Rect& area, Rect& view, float xstep, float ystep, Matrix& ctm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::begin_tile()\n";
	}
	mupdf::mfz_begin_tile(*this, area, view, xstep, ystep, ctm);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_begin_tile_id()`.  */
FZ_FUNCTION int Device::begin_tile_id(Rect& area, Rect& view, float xstep, float ystep, Matrix& ctm, int id)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::begin_tile_id()\n";
	}
	auto ret = mupdf::mfz_begin_tile_id(*this, area, view, xstep, ystep, ctm, id);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_clip_image_mask()`.  */
FZ_FUNCTION void Device::clip_image_mask(const Image& image, Matrix& ctm, Rect& scissor)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clip_image_mask()\n";
	}
	mupdf::mfz_clip_image_mask(*this, image, ctm, scissor);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_clip_path()`.  */
FZ_FUNCTION void Device::clip_path(const Path& path, int even_odd, Matrix& ctm, Rect& scissor)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clip_path()\n";
	}
	mupdf::mfz_clip_path(*this, path, even_odd, ctm, scissor);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_clip_stroke_path()`.  */
FZ_FUNCTION void Device::clip_stroke_path(const Path& path, const StrokeState& stroke, Matrix& ctm, Rect& scissor)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clip_stroke_path()\n";
	}
	mupdf::mfz_clip_stroke_path(*this, path, stroke, ctm, scissor);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_clip_stroke_text()`.  */
FZ_FUNCTION void Device::clip_stroke_text(const Text& text, const StrokeState& stroke, Matrix& ctm, Rect& scissor)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clip_stroke_text()\n";
	}
	mupdf::mfz_clip_stroke_text(*this, text, stroke, ctm, scissor);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_clip_text()`.  */
FZ_FUNCTION void Device::clip_text(const Text& text, Matrix& ctm, Rect& scissor)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clip_text()\n";
	}
	mupdf::mfz_clip_text(*this, text, ctm, scissor);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_close_device()`.  */
FZ_FUNCTION void Device::close_device()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::close_device()\n";
	}
	mupdf::mfz_close_device(*this);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_device_current_scissor()`.  */
FZ_FUNCTION Rect Device::device_current_scissor()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::device_current_scissor()\n";
	}
	auto ret = mupdf::mfz_device_current_scissor(*this);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_disable_device_hints()`.  */
FZ_FUNCTION void Device::disable_device_hints(int hints)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::disable_device_hints()\n";
	}
	mupdf::mfz_disable_device_hints(*this, hints);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_enable_device_hints()`.  */
FZ_FUNCTION void Device::enable_device_hints(int hints)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::enable_device_hints()\n";
	}
	mupdf::mfz_enable_device_hints(*this, hints);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_end_group()`.  */
FZ_FUNCTION void Device::end_group()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::end_group()\n";
	}
	mupdf::mfz_end_group(*this);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_end_layer()`.  */
FZ_FUNCTION void Device::end_layer()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::end_layer()\n";
	}
	mupdf::mfz_end_layer(*this);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_end_mask()`.  */
FZ_FUNCTION void Device::end_mask()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::end_mask()\n";
	}
	mupdf::mfz_end_mask(*this);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_end_tile()`.  */
FZ_FUNCTION void Device::end_tile()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::end_tile()\n";
	}
	mupdf::mfz_end_tile(*this);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_fill_image()`.  */
FZ_FUNCTION void Device::fill_image(const Image& image, Matrix& ctm, float alpha, ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::fill_image()\n";
	}
	mupdf::mfz_fill_image(*this, image, ctm, alpha, color_params);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_fill_image_mask()`.  */
FZ_FUNCTION void Device::fill_image_mask(const Image& image, Matrix& ctm, const Colorspace& colorspace, const float *color, float alpha, ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::fill_image_mask()\n";
	}
	mupdf::mfz_fill_image_mask(*this, image, ctm, colorspace, color, alpha, color_params);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_fill_path()`.  */
FZ_FUNCTION void Device::fill_path(const Path& path, int even_odd, Matrix& ctm, const Colorspace& colorspace, const float *color, float alpha, ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::fill_path()\n";
	}
	mupdf::mfz_fill_path(*this, path, even_odd, ctm, colorspace, color, alpha, color_params);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_fill_shade()`.  */
FZ_FUNCTION void Device::fill_shade(const Shade& shade, Matrix& ctm, float alpha, ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::fill_shade()\n";
	}
	mupdf::mfz_fill_shade(*this, shade, ctm, alpha, color_params);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_fill_text()`.  */
FZ_FUNCTION void Device::fill_text(const Text& text, Matrix& ctm, const Colorspace& colorspace, const float *color, float alpha, ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::fill_text()\n";
	}
	mupdf::mfz_fill_text(*this, text, ctm, colorspace, color, alpha, color_params);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_ignore_text()`.  */
FZ_FUNCTION void Device::ignore_text(const Text& text, Matrix& ctm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ignore_text()\n";
	}
	mupdf::mfz_ignore_text(*this, text, ctm);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_new_ocr_device()`.  */
FZ_FUNCTION Device Device::new_ocr_device(Matrix& ctm, Rect& mediabox, int with_list, const char *language, const char *datadir, int (*progress)(fz_context *, void *, int ), void *progress_arg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_ocr_device()\n";
	}
	auto ret = mupdf::mfz_new_ocr_device(*this, ctm, mediabox, with_list, language, datadir, progress, progress_arg);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_pop_clip()`.  */
FZ_FUNCTION void Device::pop_clip()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pop_clip()\n";
	}
	mupdf::mfz_pop_clip(*this);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_render_flags()`.  */
FZ_FUNCTION void Device::render_flags(int set, int clear)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::render_flags()\n";
	}
	mupdf::mfz_render_flags(*this, set, clear);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_render_t3_glyph_direct()`.  */
FZ_FUNCTION void Device::render_t3_glyph_direct(const Font& font, int gid, Matrix& trm, void *gstate, const DefaultColorspaces& def_cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::render_t3_glyph_direct()\n";
	}
	mupdf::mfz_render_t3_glyph_direct(*this, font, gid, trm, gstate, def_cs);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_set_default_colorspaces()`.  */
FZ_FUNCTION void Device::set_default_colorspaces(const DefaultColorspaces& default_cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_default_colorspaces()\n";
	}
	mupdf::mfz_set_default_colorspaces(*this, default_cs);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_stroke_path()`.  */
FZ_FUNCTION void Device::stroke_path(const Path& path, const StrokeState& stroke, Matrix& ctm, const Colorspace& colorspace, const float *color, float alpha, ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::stroke_path()\n";
	}
	mupdf::mfz_stroke_path(*this, path, stroke, ctm, colorspace, color, alpha, color_params);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_stroke_text()`.  */
FZ_FUNCTION void Device::stroke_text(const Text& text, const StrokeState& stroke, Matrix& ctm, const Colorspace& colorspace, const float *color, float alpha, ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::stroke_text()\n";
	}
	mupdf::mfz_stroke_text(*this, text, stroke, ctm, colorspace, color, alpha, color_params);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_new_run_processor()`.  */
FZ_FUNCTION PdfProcessor Device::new_run_processor(Matrix& ctm, const char *usage, const PdfGstate& gstate, const DefaultColorspaces& default_cs, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_run_processor()\n";
	}
	auto ret = mupdf::mpdf_new_run_processor(*this, ctm, usage, gstate, default_cs, cookie);
	if (s_check_refs)
	{
		s_Device_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

FZ_FUNCTION Device::Device(fz_device* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_Device_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION Device::~Device()
{
	mupdf::drop_device(m_internal);
	if (s_check_refs)
	{
		s_Device_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long Device::m_internal_value()
{
	return (uintptr_t) m_internal;
}

/* Implementation of methods for `Device2`, virtual_fnptrs wrapper for `fz_device`). */


FZ_FUNCTION Device2::Device2()
{

	m_internal = mupdf::new_device_of_size(sizeof(*m_internal) + sizeof(Device2*));
	*((Device2**) (m_internal + 1)) = this;
	
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2::Device2(); this=" << this << "\n";
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2::Device2(): m_internal=" << m_internal << "\n";
		Device2* self = (*(Device2**) (m_internal + 1));
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2::Device2(): self=" << self << "\n";
	}
}
/* Static callback, calls self->close_device(). */
static void Device2_s_close_device(fz_context *arg_0, fz_device *arg_1)
{
	Device2* self = (*(Device2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2_s_close_device(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->close_device();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->drop_device(). */
static void Device2_s_drop_device(fz_context *arg_0, fz_device *arg_1)
{
	Device2* self = (*(Device2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2_s_drop_device(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->drop_device();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->fill_path(). */
static void Device2_s_fill_path(fz_context *arg_0, fz_device *arg_1, const fz_path *arg_2, int arg_3, fz_matrix arg_4, fz_colorspace *arg_5, const float *arg_6, float arg_7, fz_color_params arg_8)
{
	Device2* self = (*(Device2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2_s_fill_path(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->fill_path(arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->stroke_path(). */
static void Device2_s_stroke_path(fz_context *arg_0, fz_device *arg_1, const fz_path *arg_2, const fz_stroke_state *arg_3, fz_matrix arg_4, fz_colorspace *arg_5, const float *arg_6, float arg_7, fz_color_params arg_8)
{
	Device2* self = (*(Device2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2_s_stroke_path(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->stroke_path(arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->clip_path(). */
static void Device2_s_clip_path(fz_context *arg_0, fz_device *arg_1, const fz_path *arg_2, int arg_3, fz_matrix arg_4, fz_rect arg_5)
{
	Device2* self = (*(Device2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2_s_clip_path(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->clip_path(arg_2, arg_3, arg_4, arg_5);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->clip_stroke_path(). */
static void Device2_s_clip_stroke_path(fz_context *arg_0, fz_device *arg_1, const fz_path *arg_2, const fz_stroke_state *arg_3, fz_matrix arg_4, fz_rect arg_5)
{
	Device2* self = (*(Device2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2_s_clip_stroke_path(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->clip_stroke_path(arg_2, arg_3, arg_4, arg_5);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->fill_text(). */
static void Device2_s_fill_text(fz_context *arg_0, fz_device *arg_1, const fz_text *arg_2, fz_matrix arg_3, fz_colorspace *arg_4, const float *arg_5, float arg_6, fz_color_params arg_7)
{
	Device2* self = (*(Device2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2_s_fill_text(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->fill_text(arg_2, arg_3, arg_4, arg_5, arg_6, arg_7);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->stroke_text(). */
static void Device2_s_stroke_text(fz_context *arg_0, fz_device *arg_1, const fz_text *arg_2, const fz_stroke_state *arg_3, fz_matrix arg_4, fz_colorspace *arg_5, const float *arg_6, float arg_7, fz_color_params arg_8)
{
	Device2* self = (*(Device2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2_s_stroke_text(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->stroke_text(arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->clip_text(). */
static void Device2_s_clip_text(fz_context *arg_0, fz_device *arg_1, const fz_text *arg_2, fz_matrix arg_3, fz_rect arg_4)
{
	Device2* self = (*(Device2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2_s_clip_text(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->clip_text(arg_2, arg_3, arg_4);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->clip_stroke_text(). */
static void Device2_s_clip_stroke_text(fz_context *arg_0, fz_device *arg_1, const fz_text *arg_2, const fz_stroke_state *arg_3, fz_matrix arg_4, fz_rect arg_5)
{
	Device2* self = (*(Device2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2_s_clip_stroke_text(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->clip_stroke_text(arg_2, arg_3, arg_4, arg_5);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->ignore_text(). */
static void Device2_s_ignore_text(fz_context *arg_0, fz_device *arg_1, const fz_text *arg_2, fz_matrix arg_3)
{
	Device2* self = (*(Device2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2_s_ignore_text(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->ignore_text(arg_2, arg_3);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->fill_shade(). */
static void Device2_s_fill_shade(fz_context *arg_0, fz_device *arg_1, fz_shade *arg_2, fz_matrix arg_3, float arg_4, fz_color_params arg_5)
{
	Device2* self = (*(Device2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2_s_fill_shade(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->fill_shade(arg_2, arg_3, arg_4, arg_5);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->fill_image(). */
static void Device2_s_fill_image(fz_context *arg_0, fz_device *arg_1, fz_image *arg_2, fz_matrix arg_3, float arg_4, fz_color_params arg_5)
{
	Device2* self = (*(Device2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2_s_fill_image(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->fill_image(arg_2, arg_3, arg_4, arg_5);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->fill_image_mask(). */
static void Device2_s_fill_image_mask(fz_context *arg_0, fz_device *arg_1, fz_image *arg_2, fz_matrix arg_3, fz_colorspace *arg_4, const float *arg_5, float arg_6, fz_color_params arg_7)
{
	Device2* self = (*(Device2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2_s_fill_image_mask(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->fill_image_mask(arg_2, arg_3, arg_4, arg_5, arg_6, arg_7);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->clip_image_mask(). */
static void Device2_s_clip_image_mask(fz_context *arg_0, fz_device *arg_1, fz_image *arg_2, fz_matrix arg_3, fz_rect arg_4)
{
	Device2* self = (*(Device2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2_s_clip_image_mask(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->clip_image_mask(arg_2, arg_3, arg_4);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->pop_clip(). */
static void Device2_s_pop_clip(fz_context *arg_0, fz_device *arg_1)
{
	Device2* self = (*(Device2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2_s_pop_clip(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->pop_clip();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->begin_mask(). */
static void Device2_s_begin_mask(fz_context *arg_0, fz_device *arg_1, fz_rect arg_2, int arg_3, fz_colorspace *arg_4, const float *arg_5, fz_color_params arg_6)
{
	Device2* self = (*(Device2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2_s_begin_mask(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->begin_mask(arg_2, arg_3, arg_4, arg_5, arg_6);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->end_mask(). */
static void Device2_s_end_mask(fz_context *arg_0, fz_device *arg_1)
{
	Device2* self = (*(Device2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2_s_end_mask(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->end_mask();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->begin_group(). */
static void Device2_s_begin_group(fz_context *arg_0, fz_device *arg_1, fz_rect arg_2, fz_colorspace *arg_3, int arg_4, int arg_5, int arg_6, float arg_7)
{
	Device2* self = (*(Device2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2_s_begin_group(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->begin_group(arg_2, arg_3, arg_4, arg_5, arg_6, arg_7);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->end_group(). */
static void Device2_s_end_group(fz_context *arg_0, fz_device *arg_1)
{
	Device2* self = (*(Device2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2_s_end_group(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->end_group();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->begin_tile(). */
static int Device2_s_begin_tile(fz_context *arg_0, fz_device *arg_1, fz_rect arg_2, fz_rect arg_3, float arg_4, float arg_5, fz_matrix arg_6, int arg_7)
{
	Device2* self = (*(Device2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2_s_begin_tile(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->begin_tile(arg_2, arg_3, arg_4, arg_5, arg_6, arg_7);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->end_tile(). */
static void Device2_s_end_tile(fz_context *arg_0, fz_device *arg_1)
{
	Device2* self = (*(Device2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2_s_end_tile(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->end_tile();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->render_flags(). */
static void Device2_s_render_flags(fz_context *arg_0, fz_device *arg_1, int arg_2, int arg_3)
{
	Device2* self = (*(Device2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2_s_render_flags(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->render_flags(arg_2, arg_3);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->set_default_colorspaces(). */
static void Device2_s_set_default_colorspaces(fz_context *arg_0, fz_device *arg_1, fz_default_colorspaces *arg_2)
{
	Device2* self = (*(Device2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2_s_set_default_colorspaces(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->set_default_colorspaces(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->begin_layer(). */
static void Device2_s_begin_layer(fz_context *arg_0, fz_device *arg_1, const char *arg_2)
{
	Device2* self = (*(Device2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2_s_begin_layer(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->begin_layer(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->end_layer(). */
static void Device2_s_end_layer(fz_context *arg_0, fz_device *arg_1)
{
	Device2* self = (*(Device2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Device2_s_end_layer(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->end_layer();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
FZ_FUNCTION void Device2::use_virtual_close_device( bool use)
{
	m_internal->close_device = (use) ? Device2_s_close_device : nullptr;
}
FZ_FUNCTION void Device2::use_virtual_drop_device( bool use)
{
	m_internal->drop_device = (use) ? Device2_s_drop_device : nullptr;
}
FZ_FUNCTION void Device2::use_virtual_fill_path( bool use)
{
	m_internal->fill_path = (use) ? Device2_s_fill_path : nullptr;
}
FZ_FUNCTION void Device2::use_virtual_stroke_path( bool use)
{
	m_internal->stroke_path = (use) ? Device2_s_stroke_path : nullptr;
}
FZ_FUNCTION void Device2::use_virtual_clip_path( bool use)
{
	m_internal->clip_path = (use) ? Device2_s_clip_path : nullptr;
}
FZ_FUNCTION void Device2::use_virtual_clip_stroke_path( bool use)
{
	m_internal->clip_stroke_path = (use) ? Device2_s_clip_stroke_path : nullptr;
}
FZ_FUNCTION void Device2::use_virtual_fill_text( bool use)
{
	m_internal->fill_text = (use) ? Device2_s_fill_text : nullptr;
}
FZ_FUNCTION void Device2::use_virtual_stroke_text( bool use)
{
	m_internal->stroke_text = (use) ? Device2_s_stroke_text : nullptr;
}
FZ_FUNCTION void Device2::use_virtual_clip_text( bool use)
{
	m_internal->clip_text = (use) ? Device2_s_clip_text : nullptr;
}
FZ_FUNCTION void Device2::use_virtual_clip_stroke_text( bool use)
{
	m_internal->clip_stroke_text = (use) ? Device2_s_clip_stroke_text : nullptr;
}
FZ_FUNCTION void Device2::use_virtual_ignore_text( bool use)
{
	m_internal->ignore_text = (use) ? Device2_s_ignore_text : nullptr;
}
FZ_FUNCTION void Device2::use_virtual_fill_shade( bool use)
{
	m_internal->fill_shade = (use) ? Device2_s_fill_shade : nullptr;
}
FZ_FUNCTION void Device2::use_virtual_fill_image( bool use)
{
	m_internal->fill_image = (use) ? Device2_s_fill_image : nullptr;
}
FZ_FUNCTION void Device2::use_virtual_fill_image_mask( bool use)
{
	m_internal->fill_image_mask = (use) ? Device2_s_fill_image_mask : nullptr;
}
FZ_FUNCTION void Device2::use_virtual_clip_image_mask( bool use)
{
	m_internal->clip_image_mask = (use) ? Device2_s_clip_image_mask : nullptr;
}
FZ_FUNCTION void Device2::use_virtual_pop_clip( bool use)
{
	m_internal->pop_clip = (use) ? Device2_s_pop_clip : nullptr;
}
FZ_FUNCTION void Device2::use_virtual_begin_mask( bool use)
{
	m_internal->begin_mask = (use) ? Device2_s_begin_mask : nullptr;
}
FZ_FUNCTION void Device2::use_virtual_end_mask( bool use)
{
	m_internal->end_mask = (use) ? Device2_s_end_mask : nullptr;
}
FZ_FUNCTION void Device2::use_virtual_begin_group( bool use)
{
	m_internal->begin_group = (use) ? Device2_s_begin_group : nullptr;
}
FZ_FUNCTION void Device2::use_virtual_end_group( bool use)
{
	m_internal->end_group = (use) ? Device2_s_end_group : nullptr;
}
FZ_FUNCTION void Device2::use_virtual_begin_tile( bool use)
{
	m_internal->begin_tile = (use) ? Device2_s_begin_tile : nullptr;
}
FZ_FUNCTION void Device2::use_virtual_end_tile( bool use)
{
	m_internal->end_tile = (use) ? Device2_s_end_tile : nullptr;
}
FZ_FUNCTION void Device2::use_virtual_render_flags( bool use)
{
	m_internal->render_flags = (use) ? Device2_s_render_flags : nullptr;
}
FZ_FUNCTION void Device2::use_virtual_set_default_colorspaces( bool use)
{
	m_internal->set_default_colorspaces = (use) ? Device2_s_set_default_colorspaces : nullptr;
}
FZ_FUNCTION void Device2::use_virtual_begin_layer( bool use)
{
	m_internal->begin_layer = (use) ? Device2_s_begin_layer : nullptr;
}
FZ_FUNCTION void Device2::use_virtual_end_layer( bool use)
{
	m_internal->end_layer = (use) ? Device2_s_end_layer : nullptr;
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Device2::close_device()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Device2::close_device().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Device2::drop_device()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Device2::drop_device().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Device2::fill_path(const struct fz_path *arg_2, int arg_3, fz_matrix arg_4, struct fz_colorspace *arg_5, const float *arg_6, float arg_7, fz_color_params arg_8)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Device2::fill_path().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Device2::stroke_path(const struct fz_path *arg_2, const fz_stroke_state *arg_3, fz_matrix arg_4, struct fz_colorspace *arg_5, const float *arg_6, float arg_7, fz_color_params arg_8)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Device2::stroke_path().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Device2::clip_path(const struct fz_path *arg_2, int arg_3, fz_matrix arg_4, fz_rect arg_5)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Device2::clip_path().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Device2::clip_stroke_path(const struct fz_path *arg_2, const fz_stroke_state *arg_3, fz_matrix arg_4, fz_rect arg_5)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Device2::clip_stroke_path().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Device2::fill_text(const fz_text *arg_2, fz_matrix arg_3, struct fz_colorspace *arg_4, const float *arg_5, float arg_6, fz_color_params arg_7)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Device2::fill_text().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Device2::stroke_text(const fz_text *arg_2, const fz_stroke_state *arg_3, fz_matrix arg_4, struct fz_colorspace *arg_5, const float *arg_6, float arg_7, fz_color_params arg_8)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Device2::stroke_text().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Device2::clip_text(const fz_text *arg_2, fz_matrix arg_3, fz_rect arg_4)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Device2::clip_text().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Device2::clip_stroke_text(const fz_text *arg_2, const fz_stroke_state *arg_3, fz_matrix arg_4, fz_rect arg_5)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Device2::clip_stroke_text().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Device2::ignore_text(const fz_text *arg_2, fz_matrix arg_3)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Device2::ignore_text().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Device2::fill_shade(fz_shade *arg_2, fz_matrix arg_3, float arg_4, fz_color_params arg_5)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Device2::fill_shade().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Device2::fill_image(struct fz_image *arg_2, fz_matrix arg_3, float arg_4, fz_color_params arg_5)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Device2::fill_image().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Device2::fill_image_mask(struct fz_image *arg_2, fz_matrix arg_3, struct fz_colorspace *arg_4, const float *arg_5, float arg_6, fz_color_params arg_7)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Device2::fill_image_mask().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Device2::clip_image_mask(struct fz_image *arg_2, fz_matrix arg_3, fz_rect arg_4)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Device2::clip_image_mask().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Device2::pop_clip()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Device2::pop_clip().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Device2::begin_mask(fz_rect arg_2, int arg_3, struct fz_colorspace *arg_4, const float *arg_5, fz_color_params arg_6)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Device2::begin_mask().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Device2::end_mask()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Device2::end_mask().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Device2::begin_group(fz_rect arg_2, struct fz_colorspace *arg_3, int arg_4, int arg_5, int arg_6, float arg_7)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Device2::begin_group().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Device2::end_group()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Device2::end_group().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION int Device2::begin_tile(fz_rect arg_2, fz_rect arg_3, float arg_4, float arg_5, fz_matrix arg_6, int arg_7)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Device2::begin_tile().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Device2::end_tile()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Device2::end_tile().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Device2::render_flags(int arg_2, int arg_3)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Device2::render_flags().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Device2::set_default_colorspaces(fz_default_colorspaces *arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Device2::set_default_colorspaces().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Device2::begin_layer(const char *arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Device2::begin_layer().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Device2::end_layer()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Device2::end_layer().");
}

/* Implementation of methods for DeviceContainerStack (wrapper for fz_device_container_stack). */

FZ_FUNCTION DeviceContainerStack::DeviceContainerStack(fz_device_container_stack* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long DeviceContainerStack::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for DisplayList (wrapper for fz_display_list). */

static RefsCheck<fz_display_list, DisplayList> s_DisplayList_refs_check(0, 32);

/* Constructor using `fz_new_display_list()`. */
FZ_FUNCTION DisplayList::DisplayList(Rect& mediabox)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_display_list()\n";
	}
	this->m_internal = mupdf::new_display_list(*(fz_rect*) &mediabox.x0);
	if (s_check_refs)
	{
		s_DisplayList_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_display_list_from_page()`. */
FZ_FUNCTION DisplayList::DisplayList(const Page& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_display_list_from_page()\n";
	}
	this->m_internal = mupdf::new_display_list_from_page(page.m_internal);
	if (s_check_refs)
	{
		s_DisplayList_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_display_list_from_page_number()`. */
FZ_FUNCTION DisplayList::DisplayList(const Document& doc, int number)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_display_list_from_page_number()\n";
	}
	this->m_internal = mupdf::new_display_list_from_page_number(doc.m_internal, number);
	if (s_check_refs)
	{
		s_DisplayList_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_display_list_from_svg()`. */
FZ_FUNCTION DisplayList::DisplayList(const Buffer& buf, const char *base_uri, const Archive& zip, float *w, float *h)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_display_list_from_svg()\n";
	}
	this->m_internal = mupdf::new_display_list_from_svg(buf.m_internal, base_uri, zip.m_internal, w, h);
	if (s_check_refs)
	{
		s_DisplayList_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_display_list_from_svg_xml()`. */
FZ_FUNCTION DisplayList::DisplayList(const XmlDoc& xmldoc, const Xml& xml, const char *base_uri, const Archive& zip, float *w, float *h)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_display_list_from_svg_xml()\n";
	}
	this->m_internal = mupdf::new_display_list_from_svg_xml(xmldoc.m_internal, xml.m_internal, base_uri, zip.m_internal, w, h);
	if (s_check_refs)
	{
		s_DisplayList_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Copy constructor using `fz_keep_display_list()`. */
FZ_FUNCTION DisplayList::DisplayList(const DisplayList& rhs)
: m_internal(mupdf::keep_display_list(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_display_list(this->m_internal) and mupdf::keep_display_list(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_DisplayList_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `fz_keep_display_list()` and `fz_drop_display_list()`. */
FZ_FUNCTION DisplayList& DisplayList::operator=(const DisplayList& rhs)
{
	mupdf::drop_display_list(this->m_internal);
	mupdf::keep_display_list(rhs.m_internal);
	if (s_check_refs)
	{
		s_DisplayList_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_DisplayList_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/* Wrapper for `fz_new_display_list_from_page_contents()`.  */
FZ_FUNCTION DisplayList DisplayList::new_display_list_from_page_contents(const Page& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_display_list_from_page_contents()\n";
	}
	auto ret = mupdf::mfz_new_display_list_from_page_contents(page);
	return ret;
}

/* Wrapper for `fz_bound_display_list()`.  */
FZ_FUNCTION Rect DisplayList::bound_display_list()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::bound_display_list()\n";
	}
	auto ret = mupdf::mfz_bound_display_list(*this);
	if (s_check_refs)
	{
		s_DisplayList_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_display_list_is_empty()`.  */
FZ_FUNCTION int DisplayList::display_list_is_empty()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::display_list_is_empty()\n";
	}
	auto ret = mupdf::mfz_display_list_is_empty(*this);
	if (s_check_refs)
	{
		s_DisplayList_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_buffer_from_display_list()`.  */
FZ_FUNCTION Buffer DisplayList::new_buffer_from_display_list(StextOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_display_list()\n";
	}
	auto ret = mupdf::mfz_new_buffer_from_display_list(*this, options);
	if (s_check_refs)
	{
		s_DisplayList_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_list_device()`.  */
FZ_FUNCTION Device DisplayList::new_list_device()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_list_device()\n";
	}
	auto ret = mupdf::mfz_new_list_device(*this);
	if (s_check_refs)
	{
		s_DisplayList_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_pixmap_from_display_list()`.  */
FZ_FUNCTION Pixmap DisplayList::new_pixmap_from_display_list(Matrix& ctm, const Colorspace& cs, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_display_list()\n";
	}
	auto ret = mupdf::mfz_new_pixmap_from_display_list(*this, ctm, cs, alpha);
	if (s_check_refs)
	{
		s_DisplayList_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_pixmap_from_display_list_with_separations()`.  */
FZ_FUNCTION Pixmap DisplayList::new_pixmap_from_display_list_with_separations(Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_display_list_with_separations()\n";
	}
	auto ret = mupdf::mfz_new_pixmap_from_display_list_with_separations(*this, ctm, cs, seps, alpha);
	if (s_check_refs)
	{
		s_DisplayList_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_run_display_list()`.  */
FZ_FUNCTION void DisplayList::run_display_list(const Device& dev, Matrix& ctm, Rect& scissor, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::run_display_list()\n";
	}
	mupdf::mfz_run_display_list(*this, dev, ctm, scissor, cookie);
	if (s_check_refs)
	{
		s_DisplayList_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_search_display_list()`.
	
	This method has out-params. Python/C# wrappers look like:
		`search_display_list(const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
	 */
FZ_FUNCTION int DisplayList::search_display_list(const char *needle, int *hit_mark, Quad& hit_bbox, int hit_max)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::search_display_list()\n";
	}
	auto ret = mupdf::mfz_search_display_list(*this, needle, hit_mark, hit_bbox, hit_max);
	if (s_check_refs)
	{
		s_DisplayList_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

FZ_FUNCTION DisplayList::DisplayList(fz_display_list* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_DisplayList_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION DisplayList::~DisplayList()
{
	mupdf::drop_display_list(m_internal);
	if (s_check_refs)
	{
		s_DisplayList_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long DisplayList::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Document (wrapper for fz_document). */

static RefsCheck<fz_document, Document> s_Document_refs_check(offsetof(fz_document, refs), 32);

/* Constructor using `fz_open_accelerated_document()`. */
FZ_FUNCTION Document::Document(const char *filename, const char *accel)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_accelerated_document()\n";
	}
	this->m_internal = mupdf::open_accelerated_document(filename, accel);
	if (s_check_refs)
	{
		s_Document_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_open_accelerated_document_with_stream()`. */
FZ_FUNCTION Document::Document(const char *magic, const Stream& stream, const Stream& accel)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_accelerated_document_with_stream()\n";
	}
	this->m_internal = mupdf::open_accelerated_document_with_stream(magic, stream.m_internal, accel.m_internal);
	if (s_check_refs)
	{
		s_Document_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_open_document()`. */
FZ_FUNCTION Document::Document(const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_document()\n";
	}
	this->m_internal = mupdf::open_document(filename);
	if (s_check_refs)
	{
		s_Document_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_open_document_with_stream()`. */
FZ_FUNCTION Document::Document(const char *magic, const Stream& stream)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_document_with_stream()\n";
	}
	this->m_internal = mupdf::open_document_with_stream(magic, stream.m_internal);
	if (s_check_refs)
	{
		s_Document_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom constructor. */
FZ_FUNCTION Document::Document(PdfDocument& pdfdocument)
{
	m_internal = mupdf::keep_document(&pdfdocument.m_internal->super);
	if (s_check_refs)
	{
		s_Document_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Copy constructor using `fz_keep_document()`. */
FZ_FUNCTION Document::Document(const Document& rhs)
: m_internal(mupdf::keep_document(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_document(this->m_internal) and mupdf::keep_document(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_Document_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `fz_keep_document()` and `fz_drop_document()`. */
FZ_FUNCTION Document& Document::operator=(const Document& rhs)
{
	mupdf::drop_document(this->m_internal);
	mupdf::keep_document(rhs.m_internal);
	if (s_check_refs)
	{
		s_Document_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_Document_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/* Wrapper for `fz_new_xhtml_document_from_document()`.  */
FZ_FUNCTION Document Document::new_xhtml_document_from_document(const Document& old_doc, StextOptions& opts)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_xhtml_document_from_document()\n";
	}
	auto ret = mupdf::mfz_new_xhtml_document_from_document(old_doc, opts);
	return ret;
}

/* Wrapper for `fz_authenticate_password()`.  */
FZ_FUNCTION int Document::authenticate_password(const char *password)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::authenticate_password()\n";
	}
	auto ret = mupdf::mfz_authenticate_password(*this, password);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_clamp_location()`.  */
FZ_FUNCTION Location Document::clamp_location(Location& loc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clamp_location()\n";
	}
	auto ret = mupdf::mfz_clamp_location(*this, loc);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_count_chapter_pages()`.  */
FZ_FUNCTION int Document::count_chapter_pages(int chapter)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::count_chapter_pages()\n";
	}
	auto ret = mupdf::mfz_count_chapter_pages(*this, chapter);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_count_chapters()`.  */
FZ_FUNCTION int Document::count_chapters()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::count_chapters()\n";
	}
	auto ret = mupdf::mfz_count_chapters(*this);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_count_pages()`.  */
FZ_FUNCTION int Document::count_pages()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::count_pages()\n";
	}
	auto ret = mupdf::mfz_count_pages(*this);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_document_output_intent()`.  */
FZ_FUNCTION Colorspace Document::document_output_intent()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::document_output_intent()\n";
	}
	auto ret = mupdf::mfz_document_output_intent(*this);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_document_supports_accelerator()`.  */
FZ_FUNCTION int Document::document_supports_accelerator()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::document_supports_accelerator()\n";
	}
	auto ret = mupdf::mfz_document_supports_accelerator(*this);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_format_link_uri()`.  */
FZ_FUNCTION char *Document::format_link_uri(const LinkDest& dest)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::format_link_uri()\n";
	}
	auto ret = mupdf::mfz_format_link_uri(*this, dest);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_has_permission()`.  */
FZ_FUNCTION int Document::has_permission(fz_permission p)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::has_permission()\n";
	}
	auto ret = mupdf::mfz_has_permission(*this, p);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_is_document_reflowable()`.  */
FZ_FUNCTION int Document::is_document_reflowable()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_document_reflowable()\n";
	}
	auto ret = mupdf::mfz_is_document_reflowable(*this);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_last_page()`.  */
FZ_FUNCTION Location Document::last_page()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::last_page()\n";
	}
	auto ret = mupdf::mfz_last_page(*this);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_layout_document()`.  */
FZ_FUNCTION void Document::layout_document(float w, float h, float em)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::layout_document()\n";
	}
	mupdf::mfz_layout_document(*this, w, h, em);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_load_chapter_page()`.  */
FZ_FUNCTION Page Document::load_chapter_page(int chapter, int page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_chapter_page()\n";
	}
	auto ret = mupdf::mfz_load_chapter_page(*this, chapter, page);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_load_outline()`.  */
FZ_FUNCTION Outline Document::load_outline()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_outline()\n";
	}
	auto ret = mupdf::mfz_load_outline(*this);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_load_page()`.  */
FZ_FUNCTION Page Document::load_page(int number)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_page()\n";
	}
	auto ret = mupdf::mfz_load_page(*this, number);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_location_from_page_number()`.  */
FZ_FUNCTION Location Document::location_from_page_number(int number)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::location_from_page_number()\n";
	}
	auto ret = mupdf::mfz_location_from_page_number(*this, number);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_lookup_bookmark()`.  */
FZ_FUNCTION Location Document::lookup_bookmark(fz_bookmark mark)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::lookup_bookmark()\n";
	}
	auto ret = mupdf::mfz_lookup_bookmark(*this, mark);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_make_bookmark()`.  */
FZ_FUNCTION fz_bookmark Document::make_bookmark(Location& loc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::make_bookmark()\n";
	}
	auto ret = mupdf::mfz_make_bookmark(*this, loc);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_needs_password()`.  */
FZ_FUNCTION int Document::needs_password()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::needs_password()\n";
	}
	auto ret = mupdf::mfz_needs_password(*this);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_buffer_from_page_number()`.  */
FZ_FUNCTION Buffer Document::new_buffer_from_page_number(int number, StextOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_page_number()\n";
	}
	auto ret = mupdf::mfz_new_buffer_from_page_number(*this, number, options);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_display_list_from_page_number()`.  */
FZ_FUNCTION DisplayList Document::new_display_list_from_page_number(int number)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_display_list_from_page_number()\n";
	}
	auto ret = mupdf::mfz_new_display_list_from_page_number(*this, number);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_pixmap_from_page_number()`.  */
FZ_FUNCTION Pixmap Document::new_pixmap_from_page_number(int number, Matrix& ctm, const Colorspace& cs, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_page_number()\n";
	}
	auto ret = mupdf::mfz_new_pixmap_from_page_number(*this, number, ctm, cs, alpha);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_pixmap_from_page_number_with_separations()`.  */
FZ_FUNCTION Pixmap Document::new_pixmap_from_page_number_with_separations(int number, Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_page_number_with_separations()\n";
	}
	auto ret = mupdf::mfz_new_pixmap_from_page_number_with_separations(*this, number, ctm, cs, seps, alpha);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_xhtml_document_from_document()`.  */
FZ_FUNCTION Document Document::new_xhtml_document_from_document(StextOptions& opts)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_xhtml_document_from_document()\n";
	}
	auto ret = mupdf::mfz_new_xhtml_document_from_document(*this, opts);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_next_page()`.  */
FZ_FUNCTION Location Document::next_page(Location& loc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::next_page()\n";
	}
	auto ret = mupdf::mfz_next_page(*this, loc);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_open_reflowed_document()`.  */
FZ_FUNCTION Document Document::open_reflowed_document(StextOptions& opts)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_reflowed_document()\n";
	}
	auto ret = mupdf::mfz_open_reflowed_document(*this, opts);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_output_accelerator()`.  */
FZ_FUNCTION void Document::output_accelerator(const Output& accel)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::output_accelerator()\n";
	}
	mupdf::mfz_output_accelerator(*this, accel);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_page_number_from_location()`.  */
FZ_FUNCTION int Document::page_number_from_location(Location& loc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::page_number_from_location()\n";
	}
	auto ret = mupdf::mfz_page_number_from_location(*this, loc);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_previous_page()`.  */
FZ_FUNCTION Location Document::previous_page(Location& loc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::previous_page()\n";
	}
	auto ret = mupdf::mfz_previous_page(*this, loc);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_process_opened_pages()`.  */
FZ_FUNCTION void *Document::process_opened_pages(fz_process_opened_page_fn *process_openend_page, void *state)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::process_opened_pages()\n";
	}
	auto ret = mupdf::mfz_process_opened_pages(*this, process_openend_page, state);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_resolve_link()`.
	
	This method has out-params. Python/C# wrappers look like:
		`resolve_link(const char *uri)` => `(fz_location, float xp, float yp)`
	 */
FZ_FUNCTION Location Document::resolve_link(const char *uri, float *xp, float *yp)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::resolve_link()\n";
	}
	auto ret = mupdf::mfz_resolve_link(*this, uri, xp, yp);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_save_accelerator()`.  */
FZ_FUNCTION void Document::save_accelerator(const char *accel)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_accelerator()\n";
	}
	mupdf::mfz_save_accelerator(*this, accel);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_search_chapter_page_number()`.
	
	This method has out-params. Python/C# wrappers look like:
		`search_chapter_page_number(int chapter, int page, const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
	 */
FZ_FUNCTION int Document::search_chapter_page_number(int chapter, int page, const char *needle, int *hit_mark, Quad& hit_bbox, int hit_max)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::search_chapter_page_number()\n";
	}
	auto ret = mupdf::mfz_search_chapter_page_number(*this, chapter, page, needle, hit_mark, hit_bbox, hit_max);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_search_page_number()`.
	
	This method has out-params. Python/C# wrappers look like:
		`search_page_number(int number, const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
	 */
FZ_FUNCTION int Document::search_page_number(int number, const char *needle, int *hit_mark, Quad& hit_bbox, int hit_max)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::search_page_number()\n";
	}
	auto ret = mupdf::mfz_search_page_number(*this, number, needle, hit_mark, hit_bbox, hit_max);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_set_metadata()`.  */
FZ_FUNCTION void Document::set_metadata(const char *key, const char *value)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_metadata()\n";
	}
	mupdf::mfz_set_metadata(*this, key, value);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_count_pages_imp()`.  */
FZ_FUNCTION int Document::count_pages_imp(int chapter)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_count_pages_imp()\n";
	}
	auto ret = mupdf::mpdf_count_pages_imp(*this, chapter);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_document_from_fz_document()`.  */
FZ_FUNCTION PdfDocument Document::document_from_fz_document()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_document_from_fz_document()\n";
	}
	auto ret = mupdf::mpdf_document_from_fz_document(*this);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_load_page_imp()`.  */
FZ_FUNCTION Page Document::load_page_imp(int chapter, int number)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_page_imp()\n";
	}
	auto ret = mupdf::mpdf_load_page_imp(*this, chapter, number);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_specifics()`.  */
FZ_FUNCTION PdfDocument Document::specifics()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_specifics()\n";
	}
	auto ret = mupdf::mpdf_specifics(*this);
	if (s_check_refs)
	{
		s_Document_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/** Custom method. */
FZ_FUNCTION std::string Document::lookup_metadata(const char* key, int* o_out)
{
	return mupdf::lookup_metadata(m_internal, key, o_out);
}

FZ_FUNCTION Document::Document(fz_document* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_Document_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION Document::~Document()
{
	mupdf::drop_document(m_internal);
	if (s_check_refs)
	{
		s_Document_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long Document::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for DocumentHandler (wrapper for fz_document_handler). */

/* Wrapper for `fz_register_document_handler()`.  */
FZ_FUNCTION void DocumentHandler::register_document_handler()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::register_document_handler()\n";
	}
	mupdf::mfz_register_document_handler(*this);
}

FZ_FUNCTION DocumentHandler::DocumentHandler(fz_document_handler* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long DocumentHandler::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for DocumentHandlerContext (wrapper for fz_document_handler_context). */

FZ_FUNCTION DocumentHandlerContext::DocumentHandlerContext(fz_document_handler_context* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long DocumentHandlerContext::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for DocumentWriter (wrapper for fz_document_writer). */

/* Constructor using `fz_new_document_writer_of_size()`. */
FZ_FUNCTION DocumentWriter::DocumentWriter(size_t size, fz_document_writer_begin_page_fn *begin_page, fz_document_writer_end_page_fn *end_page, fz_document_writer_close_writer_fn *close, fz_document_writer_drop_writer_fn *drop)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_document_writer_of_size()\n";
	}
	this->m_internal = mupdf::new_document_writer_of_size(size, begin_page, end_page, close, drop);
}

/* Constructor using `fz_new_pixmap_writer()`. */
FZ_FUNCTION DocumentWriter::DocumentWriter(const char *path, const char *options, const char *default_path, int n, void (*save)(fz_context *, fz_pixmap *, const char *))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_writer()\n";
	}
	this->m_internal = mupdf::new_pixmap_writer(path, options, default_path, n, save);
}

/** Custom constructor. */
FZ_FUNCTION DocumentWriter::DocumentWriter(const char *path, const char *options, PathType path_type)
{
	if (0) {}
	else if (path_type == PathType_CBZ)         m_internal = mupdf::new_cbz_writer(path, options);
	else if (path_type == PathType_DOCX)        m_internal = mupdf::new_docx_writer(path, options);
	else if (path_type == PathType_ODT)         m_internal = mupdf::new_odt_writer(path, options);
	else if (path_type == PathType_PAM_PIXMAP)  m_internal = mupdf::new_pam_pixmap_writer(path, options);
	else if (path_type == PathType_PBM_PIXMAP)  m_internal = mupdf::new_pbm_pixmap_writer(path, options);
	else if (path_type == PathType_PCL)         m_internal = mupdf::new_pcl_writer(path, options);
	else if (path_type == PathType_PCLM)        m_internal = mupdf::new_pclm_writer(path, options);
	else if (path_type == PathType_PDF)         m_internal = mupdf::new_pdf_writer(path, options);
	else if (path_type == PathType_PDFOCR)      m_internal = mupdf::new_pdfocr_writer(path, options);
	else if (path_type == PathType_PGM_PIXMAP)  m_internal = mupdf::new_pgm_pixmap_writer(path, options);
	else if (path_type == PathType_PKM_PIXMAP)  m_internal = mupdf::new_pkm_pixmap_writer(path, options);
	else if (path_type == PathType_PNG_PIXMAP)  m_internal = mupdf::new_png_pixmap_writer(path, options);
	else if (path_type == PathType_PNM_PIXMAP)  m_internal = mupdf::new_pnm_pixmap_writer(path, options);
	else if (path_type == PathType_PPM_PIXMAP)  m_internal = mupdf::new_ppm_pixmap_writer(path, options);
	else if (path_type == PathType_PS)          m_internal = mupdf::new_ps_writer(path, options);
	else if (path_type == PathType_PWG)         m_internal = mupdf::new_pwg_writer(path, options);
	else if (path_type == PathType_SVG)         m_internal = mupdf::new_svg_writer(path, options);
	else throw ErrorAbort( "Unrecognised Type value");
}

/** Custom constructor. */
FZ_FUNCTION DocumentWriter::DocumentWriter(Output& out, const char *options, OutputType output_type)
{
	/* All fz_new_*_writer_with_output() functions take
	ownership of the fz_output, even if they throw an
	exception. So we need to set out.m_internal to null
	here so its destructor does nothing. */
	fz_output* out2 = out.m_internal;
	out.m_internal = NULL;
	if (0) {}
	else if (output_type == OutputType_CBZ)     m_internal = mupdf::new_cbz_writer_with_output(out2, options);
	else if (output_type == OutputType_DOCX)    m_internal = mupdf::new_docx_writer_with_output(out2, options);
	else if (output_type == OutputType_ODT)     m_internal = mupdf::new_odt_writer_with_output(out2, options);
	else if (output_type == OutputType_PCL)     m_internal = mupdf::new_pcl_writer_with_output(out2, options);
	else if (output_type == OutputType_PCLM)    m_internal = mupdf::new_pclm_writer_with_output(out2, options);
	else if (output_type == OutputType_PDF)     m_internal = mupdf::new_pdf_writer_with_output(out2, options);
	else if (output_type == OutputType_PDFOCR)  m_internal = mupdf::new_pdfocr_writer_with_output(out2, options);
	else if (output_type == OutputType_PS)      m_internal = mupdf::new_ps_writer_with_output(out2, options);
	else if (output_type == OutputType_PWG)     m_internal = mupdf::new_pwg_writer_with_output(out2, options);
	else
	{
		/* Ensure that out2 is dropped before we return. */
		mupdf::drop_output(out2);
		throw ErrorAbort( "Unrecognised OutputType value");
	}
}

/** Custom constructor. */
FZ_FUNCTION DocumentWriter::DocumentWriter(const char *format, const char *path, const char *options, FormatPathType format_path_type)
{
	if (0) {}
	else if (format_path_type == FormatPathType_DOCUMENT)   m_internal = mupdf::new_document_writer(format, path, options);
	else if (format_path_type == FormatPathType_TEXT)       m_internal = mupdf::new_text_writer(format, path, options);
	else throw ErrorAbort( "Unrecognised OutputType value");
}

/** Custom constructor. */
FZ_FUNCTION DocumentWriter::DocumentWriter(Output& out, const char *format, const char *options)
{
	/* Need to transfer ownership of <out>. */
	fz_output* out2 = out.m_internal;
	out.m_internal = NULL;
	m_internal = mupdf::new_document_writer_with_output(out2, format, options);
}

/** Custom constructor. */
FZ_FUNCTION DocumentWriter::DocumentWriter(const char *format, Output& out, const char *options)
{
	/* Need to transfer ownership of <out>. */
	fz_output* out2 = out.m_internal;
	out.m_internal = NULL;
	m_internal = mupdf::new_text_writer_with_output(format, out2, options);
}

/* Wrapper for `fz_close_document_writer()`.  */
FZ_FUNCTION void DocumentWriter::close_document_writer()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::close_document_writer()\n";
	}
	mupdf::mfz_close_document_writer(*this);
}

/* Wrapper for `fz_end_page()`.  */
FZ_FUNCTION void DocumentWriter::end_page()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::end_page()\n";
	}
	mupdf::mfz_end_page(*this);
}

/* Wrapper for `fz_pdfocr_writer_set_progress()`.  */
FZ_FUNCTION void DocumentWriter::pdfocr_writer_set_progress(fz_pdfocr_progress_fn *progress, void *arg_2)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pdfocr_writer_set_progress()\n";
	}
	mupdf::mfz_pdfocr_writer_set_progress(*this, progress, arg_2);
}

/* Wrapper for `fz_write_document()`.  */
FZ_FUNCTION void DocumentWriter::write_document(const Document& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_document()\n";
	}
	mupdf::mfz_write_document(*this, doc);
}

/** Custom method. */
FZ_FUNCTION Device DocumentWriter::begin_page(Rect& mediabox)
{
	/* fz_begin_page() doesn't transfer ownership, so
	we have to call fz_keep_device() before creating
	the Device instance. */
	fz_device* dev = mupdf::begin_page(m_internal, *(fz_rect*) &mediabox.x0);
	dev = mupdf::keep_device(dev);
	return Device(dev);
}

FZ_FUNCTION DocumentWriter::DocumentWriter(fz_document_writer* internal)
: m_internal(internal)
{
}

FZ_FUNCTION DocumentWriter::~DocumentWriter()
{
	mupdf::drop_document_writer(m_internal);
}

/** Custom method. */
FZ_FUNCTION long long DocumentWriter::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for DrawOptions (wrapper for fz_draw_options). */

/* Constructor using `fz_parse_draw_options()`. */
FZ_FUNCTION DrawOptions::DrawOptions(DrawOptions& options, const char *string)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::parse_draw_options()\n";
	}
	*(fz_draw_options*) &this->rotate = *mupdf::parse_draw_options((fz_draw_options *) &options.rotate, string);
}

FZ_FUNCTION DrawOptions::DrawOptions(const fz_draw_options* internal)
{
	this->rotate = internal->rotate;
	this->x_resolution = internal->x_resolution;
	this->y_resolution = internal->y_resolution;
	this->width = internal->width;
	this->height = internal->height;
	this->colorspace = internal->colorspace;
	this->alpha = internal->alpha;
	this->graphics = internal->graphics;
	this->text = internal->text;
}

FZ_FUNCTION DrawOptions::DrawOptions(const fz_draw_options internal)
{
	this->rotate = internal.rotate;
	this->x_resolution = internal.x_resolution;
	this->y_resolution = internal.y_resolution;
	this->width = internal.width;
	this->height = internal.height;
	this->colorspace = internal.colorspace;
	this->alpha = internal.alpha;
	this->graphics = internal.graphics;
	this->text = internal.text;
}

/** Constructor using raw copy of pre-existing `fz_draw_options`. */
FZ_FUNCTION fz_draw_options* DrawOptions::internal()
{
	auto ret = (fz_draw_options*) &this->rotate;
	return ret;
}

/** Constructor using raw copy of pre-existing `fz_draw_options`. */
FZ_FUNCTION const fz_draw_options* DrawOptions::internal() const
{
	auto ret = (const fz_draw_options*) &this->rotate;
	return ret;
}

FZ_FUNCTION std::string DrawOptions::to_string()
{
	std::ostringstream buffer;
	buffer << *this;
	return buffer.str();
}


FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const DrawOptions& rhs)
{
	return out << *rhs.internal();
}

/* Implementation of methods for ErrorContext (wrapper for fz_error_context). */

FZ_FUNCTION ErrorContext::ErrorContext(fz_error_context* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long ErrorContext::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for ErrorStackSlot (wrapper for fz_error_stack_slot). */

FZ_FUNCTION ErrorStackSlot::ErrorStackSlot(fz_error_stack_slot* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long ErrorStackSlot::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Font (wrapper for fz_font). */

static RefsCheck<fz_font, Font> s_Font_refs_check(offsetof(fz_font, refs), 32);

/* Constructor using `fz_new_base14_font()`. */
FZ_FUNCTION Font::Font(const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_base14_font()\n";
	}
	this->m_internal = mupdf::new_base14_font(name);
	if (s_check_refs)
	{
		s_Font_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_builtin_font()`. */
FZ_FUNCTION Font::Font(const char *name, int is_bold, int is_italic)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_builtin_font()\n";
	}
	this->m_internal = mupdf::new_builtin_font(name, is_bold, is_italic);
	if (s_check_refs)
	{
		s_Font_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_cjk_font()`. */
FZ_FUNCTION Font::Font(int ordering)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_cjk_font()\n";
	}
	this->m_internal = mupdf::new_cjk_font(ordering);
	if (s_check_refs)
	{
		s_Font_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_font_from_buffer()`. */
FZ_FUNCTION Font::Font(const char *name, const Buffer& buffer, int index, int use_glyph_bbox)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_font_from_buffer()\n";
	}
	this->m_internal = mupdf::new_font_from_buffer(name, buffer.m_internal, index, use_glyph_bbox);
	if (s_check_refs)
	{
		s_Font_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_font_from_file()`. */
FZ_FUNCTION Font::Font(const char *name, const char *path, int index, int use_glyph_bbox)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_font_from_file()\n";
	}
	this->m_internal = mupdf::new_font_from_file(name, path, index, use_glyph_bbox);
	if (s_check_refs)
	{
		s_Font_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_font_from_memory()`. */
FZ_FUNCTION Font::Font(const char *name, const unsigned char *data, int len, int index, int use_glyph_bbox)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_font_from_memory()\n";
	}
	this->m_internal = mupdf::new_font_from_memory(name, data, len, index, use_glyph_bbox);
	if (s_check_refs)
	{
		s_Font_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_type3_font()`. */
FZ_FUNCTION Font::Font(const char *name, Matrix& matrix)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_type3_font()\n";
	}
	this->m_internal = mupdf::new_type3_font(name, *(fz_matrix*) &matrix.a);
	if (s_check_refs)
	{
		s_Font_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Copy constructor using `fz_keep_font()`. */
FZ_FUNCTION Font::Font(const Font& rhs)
: m_internal(mupdf::keep_font(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_font(this->m_internal) and mupdf::keep_font(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_Font_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `fz_keep_font()` and `fz_drop_font()`. */
FZ_FUNCTION Font& Font::operator=(const Font& rhs)
{
	mupdf::drop_font(this->m_internal);
	mupdf::keep_font(rhs.m_internal);
	if (s_check_refs)
	{
		s_Font_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_Font_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/* Wrapper for `fz_advance_glyph()`.  */
FZ_FUNCTION float Font::advance_glyph(int glyph, int wmode)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::advance_glyph()\n";
	}
	auto ret = mupdf::mfz_advance_glyph(*this, glyph, wmode);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_bound_glyph()`.  */
FZ_FUNCTION Rect Font::bound_glyph(int gid, Matrix& trm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::bound_glyph()\n";
	}
	auto ret = mupdf::mfz_bound_glyph(*this, gid, trm);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_decouple_type3_font()`.  */
FZ_FUNCTION void Font::decouple_type3_font(void *t3doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::decouple_type3_font()\n";
	}
	mupdf::mfz_decouple_type3_font(*this, t3doc);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_encode_character()`.  */
FZ_FUNCTION int Font::encode_character(int unicode)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::encode_character()\n";
	}
	auto ret = mupdf::mfz_encode_character(*this, unicode);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_encode_character_by_glyph_name()`.  */
FZ_FUNCTION int Font::encode_character_by_glyph_name(const char *glyphname)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::encode_character_by_glyph_name()\n";
	}
	auto ret = mupdf::mfz_encode_character_by_glyph_name(*this, glyphname);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_encode_character_sc()`.  */
FZ_FUNCTION int Font::encode_character_sc(int unicode)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::encode_character_sc()\n";
	}
	auto ret = mupdf::mfz_encode_character_sc(*this, unicode);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_font_ascender()`.  */
FZ_FUNCTION float Font::font_ascender()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::font_ascender()\n";
	}
	auto ret = mupdf::mfz_font_ascender(*this);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_font_bbox()`.  */
FZ_FUNCTION Rect Font::font_bbox()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::font_bbox()\n";
	}
	auto ret = mupdf::mfz_font_bbox(*this);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_font_descender()`.  */
FZ_FUNCTION float Font::font_descender()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::font_descender()\n";
	}
	auto ret = mupdf::mfz_font_descender(*this);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_font_digest()`.  */
FZ_FUNCTION void Font::font_digest(unsigned char digest[16])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::font_digest()\n";
	}
	mupdf::mfz_font_digest(*this, digest);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_font_ft_face()`.  */
FZ_FUNCTION void *Font::font_ft_face()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::font_ft_face()\n";
	}
	auto ret = mupdf::mfz_font_ft_face(*this);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_font_is_bold()`.  */
FZ_FUNCTION int Font::font_is_bold()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::font_is_bold()\n";
	}
	auto ret = mupdf::mfz_font_is_bold(*this);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_font_is_italic()`.  */
FZ_FUNCTION int Font::font_is_italic()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::font_is_italic()\n";
	}
	auto ret = mupdf::mfz_font_is_italic(*this);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_font_is_monospaced()`.  */
FZ_FUNCTION int Font::font_is_monospaced()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::font_is_monospaced()\n";
	}
	auto ret = mupdf::mfz_font_is_monospaced(*this);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_font_is_serif()`.  */
FZ_FUNCTION int Font::font_is_serif()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::font_is_serif()\n";
	}
	auto ret = mupdf::mfz_font_is_serif(*this);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_font_name()`.  */
FZ_FUNCTION const char *Font::font_name()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::font_name()\n";
	}
	auto ret = mupdf::mfz_font_name(*this);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_font_t3_procs()`.  */
FZ_FUNCTION fz_buffer **Font::font_t3_procs()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::font_t3_procs()\n";
	}
	auto ret = mupdf::mfz_font_t3_procs(*this);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_get_glyph_name()`.  */
FZ_FUNCTION void Font::get_glyph_name(int glyph, char *buf, int size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::get_glyph_name()\n";
	}
	mupdf::mfz_get_glyph_name(*this, glyph, buf, size);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_glyph_cacheable()`.  */
FZ_FUNCTION int Font::glyph_cacheable(int gid)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::glyph_cacheable()\n";
	}
	auto ret = mupdf::mfz_glyph_cacheable(*this, gid);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_measure_string()`.  */
FZ_FUNCTION Matrix Font::measure_string(Matrix& trm, const char *s, int wmode, int bidi_level, fz_bidi_direction markup_dir, fz_text_language language)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::measure_string()\n";
	}
	auto ret = mupdf::mfz_measure_string(*this, trm, s, wmode, bidi_level, markup_dir, language);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_outline_glyph()`.  */
FZ_FUNCTION Path Font::outline_glyph(int gid, Matrix& ctm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::outline_glyph()\n";
	}
	auto ret = mupdf::mfz_outline_glyph(*this, gid, ctm);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_prepare_t3_glyph()`.  */
FZ_FUNCTION void Font::prepare_t3_glyph(int gid)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::prepare_t3_glyph()\n";
	}
	mupdf::mfz_prepare_t3_glyph(*this, gid);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_render_glyph_pixmap()`.  */
FZ_FUNCTION Pixmap Font::render_glyph_pixmap(int gid, Matrix& ctm, Irect& scissor, int aa)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::render_glyph_pixmap()\n";
	}
	auto ret = mupdf::mfz_render_glyph_pixmap(*this, gid, ctm, scissor, aa);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_run_t3_glyph()`.  */
FZ_FUNCTION void Font::run_t3_glyph(int gid, Matrix& trm, const Device& dev)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::run_t3_glyph()\n";
	}
	mupdf::mfz_run_t3_glyph(*this, gid, trm, dev);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_set_font_bbox()`.  */
FZ_FUNCTION void Font::set_font_bbox(float xmin, float ymin, float xmax, float ymax)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_font_bbox()\n";
	}
	mupdf::mfz_set_font_bbox(*this, xmin, ymin, xmax, ymax);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_font_writing_supported()`.  */
FZ_FUNCTION int Font::font_writing_supported()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_font_writing_supported()\n";
	}
	auto ret = mupdf::mpdf_font_writing_supported(*this);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_layout_fit_text()`.  */
FZ_FUNCTION Text Font::layout_fit_text(fz_text_language lang, const char *str, Rect& bounds)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_layout_fit_text()\n";
	}
	auto ret = mupdf::mpdf_layout_fit_text(*this, lang, str, bounds);
	if (s_check_refs)
	{
		s_Font_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

FZ_FUNCTION Font::Font(fz_font* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_Font_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION Font::~Font()
{
	mupdf::drop_font(m_internal);
	if (s_check_refs)
	{
		s_Font_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long Font::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for FontContext (wrapper for fz_font_context). */

FZ_FUNCTION FontContext::FontContext(fz_font_context* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long FontContext::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for FontFlagsT (wrapper for fz_font_flags_t). */

FZ_FUNCTION FontFlagsT::FontFlagsT(fz_font_flags_t* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long FontFlagsT::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Glyph (wrapper for fz_glyph). */

static RefsCheck<fz_glyph, Glyph> s_Glyph_refs_check(0, 32);

/** Copy constructor using `fz_keep_glyph()`. */
FZ_FUNCTION Glyph::Glyph(const Glyph& rhs)
: m_internal(mupdf::keep_glyph(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_glyph(this->m_internal) and mupdf::keep_glyph(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_Glyph_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `fz_keep_glyph()` and `fz_drop_glyph()`. */
FZ_FUNCTION Glyph& Glyph::operator=(const Glyph& rhs)
{
	mupdf::drop_glyph(this->m_internal);
	mupdf::keep_glyph(rhs.m_internal);
	if (s_check_refs)
	{
		s_Glyph_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_Glyph_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/* Wrapper for `fz_glyph_bbox()`.  */
FZ_FUNCTION Irect Glyph::glyph_bbox()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::glyph_bbox()\n";
	}
	auto ret = mupdf::mfz_glyph_bbox(*this);
	if (s_check_refs)
	{
		s_Glyph_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_glyph_bbox_no_ctx()`.  */
FZ_FUNCTION Irect Glyph::glyph_bbox_no_ctx()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::glyph_bbox_no_ctx()\n";
	}
	auto ret = mupdf::mfz_glyph_bbox_no_ctx(*this);
	if (s_check_refs)
	{
		s_Glyph_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_glyph_height()`.  */
FZ_FUNCTION int Glyph::glyph_height()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::glyph_height()\n";
	}
	auto ret = mupdf::mfz_glyph_height(*this);
	if (s_check_refs)
	{
		s_Glyph_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_glyph_width()`.  */
FZ_FUNCTION int Glyph::glyph_width()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::glyph_width()\n";
	}
	auto ret = mupdf::mfz_glyph_width(*this);
	if (s_check_refs)
	{
		s_Glyph_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

FZ_FUNCTION Glyph::Glyph(fz_glyph* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_Glyph_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION Glyph::~Glyph()
{
	mupdf::drop_glyph(m_internal);
	if (s_check_refs)
	{
		s_Glyph_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long Glyph::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for GlyphCache (wrapper for fz_glyph_cache). */

FZ_FUNCTION GlyphCache::GlyphCache(fz_glyph_cache* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long GlyphCache::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Halftone (wrapper for fz_halftone). */

static RefsCheck<fz_halftone, Halftone> s_Halftone_refs_check(0, 32);

/** Copy constructor using `fz_keep_halftone()`. */
FZ_FUNCTION Halftone::Halftone(const Halftone& rhs)
: m_internal(mupdf::keep_halftone(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_halftone(this->m_internal) and mupdf::keep_halftone(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_Halftone_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `fz_keep_halftone()` and `fz_drop_halftone()`. */
FZ_FUNCTION Halftone& Halftone::operator=(const Halftone& rhs)
{
	mupdf::drop_halftone(this->m_internal);
	mupdf::keep_halftone(rhs.m_internal);
	if (s_check_refs)
	{
		s_Halftone_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_Halftone_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

FZ_FUNCTION Halftone::Halftone(fz_halftone* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_Halftone_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION Halftone::~Halftone()
{
	mupdf::drop_halftone(m_internal);
	if (s_check_refs)
	{
		s_Halftone_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long Halftone::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for HashTable (wrapper for fz_hash_table). */

/* Constructor using `fz_new_hash_table()`. */
FZ_FUNCTION HashTable::HashTable(int initialsize, int keylen, int lock, fz_hash_table_drop_fn *drop_val)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_hash_table()\n";
	}
	this->m_internal = mupdf::new_hash_table(initialsize, keylen, lock, drop_val);
}

/* Wrapper for `fz_hash_filter()`.  */
FZ_FUNCTION void HashTable::hash_filter(void *state, fz_hash_table_filter_fn *callback)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::hash_filter()\n";
	}
	mupdf::mfz_hash_filter(*this, state, callback);
}

/* Wrapper for `fz_hash_find()`.  */
FZ_FUNCTION void *HashTable::hash_find(const void *key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::hash_find()\n";
	}
	auto ret = mupdf::mfz_hash_find(*this, key);
	return ret;
}

/* Wrapper for `fz_hash_for_each()`.  */
FZ_FUNCTION void HashTable::hash_for_each(void *state, fz_hash_table_for_each_fn *callback)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::hash_for_each()\n";
	}
	mupdf::mfz_hash_for_each(*this, state, callback);
}

/* Wrapper for `fz_hash_insert()`.  */
FZ_FUNCTION void *HashTable::hash_insert(const void *key, void *val)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::hash_insert()\n";
	}
	auto ret = mupdf::mfz_hash_insert(*this, key, val);
	return ret;
}

/* Wrapper for `fz_hash_remove()`.  */
FZ_FUNCTION void HashTable::hash_remove(const void *key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::hash_remove()\n";
	}
	mupdf::mfz_hash_remove(*this, key);
}

FZ_FUNCTION HashTable::HashTable(fz_hash_table* internal)
: m_internal(internal)
{
}

FZ_FUNCTION HashTable::~HashTable()
{
	mupdf::drop_hash_table(m_internal);
}

/** Custom method. */
FZ_FUNCTION long long HashTable::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for IccProfile (wrapper for fz_icc_profile). */

FZ_FUNCTION IccProfile::IccProfile(fz_icc_profile* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long IccProfile::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Image (wrapper for fz_image). */

static RefsCheck<fz_image, Image> s_Image_refs_check(offsetof(fz_image, key_storable.storable.refs), 32);

/* Constructor using `fz_new_image_from_buffer()`. */
FZ_FUNCTION Image::Image(const Buffer& buffer)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_image_from_buffer()\n";
	}
	this->m_internal = mupdf::new_image_from_buffer(buffer.m_internal);
	if (s_check_refs)
	{
		s_Image_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_image_from_compressed_buffer()`. */
FZ_FUNCTION Image::Image(int w, int h, int bpc, const Colorspace& colorspace, int xres, int yres, int interpolate, int imagemask, float *decode, int *colorkey, const CompressedBuffer& buffer, const Image& mask)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_image_from_compressed_buffer()\n";
	}
	this->m_internal = mupdf::new_image_from_compressed_buffer(w, h, bpc, colorspace.m_internal, xres, yres, interpolate, imagemask, decode, colorkey, buffer.m_internal, mask.m_internal);
	if (s_check_refs)
	{
		s_Image_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_image_from_display_list()`. */
FZ_FUNCTION Image::Image(float w, float h, const DisplayList& list)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_image_from_display_list()\n";
	}
	this->m_internal = mupdf::new_image_from_display_list(w, h, list.m_internal);
	if (s_check_refs)
	{
		s_Image_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_image_from_file()`. */
FZ_FUNCTION Image::Image(const char *path)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_image_from_file()\n";
	}
	this->m_internal = mupdf::new_image_from_file(path);
	if (s_check_refs)
	{
		s_Image_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_image_from_pixmap()`. */
FZ_FUNCTION Image::Image(const Pixmap& pixmap, const Image& mask)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_image_from_pixmap()\n";
	}
	this->m_internal = mupdf::new_image_from_pixmap(pixmap.m_internal, mask.m_internal);
	if (s_check_refs)
	{
		s_Image_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_image_from_svg()`. */
FZ_FUNCTION Image::Image(const Buffer& buf, const char *base_uri, const Archive& zip)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_image_from_svg()\n";
	}
	this->m_internal = mupdf::new_image_from_svg(buf.m_internal, base_uri, zip.m_internal);
	if (s_check_refs)
	{
		s_Image_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_image_from_svg_xml()`. */
FZ_FUNCTION Image::Image(const XmlDoc& xmldoc, const Xml& xml, const char *base_uri, const Archive& zip)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_image_from_svg_xml()\n";
	}
	this->m_internal = mupdf::new_image_from_svg_xml(xmldoc.m_internal, xml.m_internal, base_uri, zip.m_internal);
	if (s_check_refs)
	{
		s_Image_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_image_of_size()`. */
FZ_FUNCTION Image::Image(int w, int h, int bpc, const Colorspace& colorspace, int xres, int yres, int interpolate, int imagemask, float *decode, int *colorkey, const Image& mask, size_t size, fz_image_get_pixmap_fn *get_pixmap, fz_image_get_size_fn *get_size, fz_drop_image_fn *drop)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_image_of_size()\n";
	}
	this->m_internal = mupdf::new_image_of_size(w, h, bpc, colorspace.m_internal, xres, yres, interpolate, imagemask, decode, colorkey, mask.m_internal, size, get_pixmap, get_size, drop);
	if (s_check_refs)
	{
		s_Image_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom constructor. */
FZ_FUNCTION Image::Image()
{
	m_internal = nullptr;
	if (s_check_refs)
	{
		s_Image_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Copy constructor using `fz_keep_image()`. */
FZ_FUNCTION Image::Image(const Image& rhs)
: m_internal(mupdf::keep_image(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_image(this->m_internal) and mupdf::keep_image(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_Image_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `fz_keep_image()` and `fz_drop_image()`. */
FZ_FUNCTION Image& Image::operator=(const Image& rhs)
{
	mupdf::drop_image(this->m_internal);
	mupdf::keep_image(rhs.m_internal);
	if (s_check_refs)
	{
		s_Image_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_Image_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/* Wrapper for `fz_get_pixmap_from_image()`.
	
	This method has out-params. Python/C# wrappers look like:
		`get_pixmap_from_image(const fz_irect *subarea, fz_matrix *ctm)` => `(fz_pixmap *, int w, int h)`
	 */
FZ_FUNCTION Pixmap Image::get_pixmap_from_image(Irect& subarea, Matrix& ctm, int *w, int *h)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::get_pixmap_from_image()\n";
	}
	auto ret = mupdf::mfz_get_pixmap_from_image(*this, subarea, ctm, w, h);
	if (s_check_refs)
	{
		s_Image_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_get_unscaled_pixmap_from_image()`.  */
FZ_FUNCTION Pixmap Image::get_unscaled_pixmap_from_image()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::get_unscaled_pixmap_from_image()\n";
	}
	auto ret = mupdf::mfz_get_unscaled_pixmap_from_image(*this);
	if (s_check_refs)
	{
		s_Image_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_image_orientation()`.  */
FZ_FUNCTION uint8_t Image::image_orientation()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::image_orientation()\n";
	}
	auto ret = mupdf::mfz_image_orientation(*this);
	if (s_check_refs)
	{
		s_Image_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_image_orientation_matrix()`.  */
FZ_FUNCTION Matrix Image::image_orientation_matrix()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::image_orientation_matrix()\n";
	}
	auto ret = mupdf::mfz_image_orientation_matrix(*this);
	if (s_check_refs)
	{
		s_Image_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_image_resolution()`.
	
	This method has out-params. Python/C# wrappers look like:
		`image_resolution()` => `(int xres, int yres)`
	 */
FZ_FUNCTION void Image::image_resolution(int *xres, int *yres)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::image_resolution()\n";
	}
	mupdf::mfz_image_resolution(*this, xres, yres);
	if (s_check_refs)
	{
		s_Image_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_image_size()`.  */
FZ_FUNCTION size_t Image::image_size()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::image_size()\n";
	}
	auto ret = mupdf::mfz_image_size(*this);
	if (s_check_refs)
	{
		s_Image_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_buffer_from_image_as_png()`.  */
FZ_FUNCTION Buffer Image::new_buffer_from_image_as_png(ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_image_as_png()\n";
	}
	auto ret = mupdf::mfz_new_buffer_from_image_as_png(*this, color_params);
	if (s_check_refs)
	{
		s_Image_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

FZ_FUNCTION Image::Image(fz_image* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_Image_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION fz_key_storable Image::key_storable()
{
	return m_internal->key_storable;
}

FZ_FUNCTION int Image::w()
{
	return m_internal->w;
}

FZ_FUNCTION int Image::h()
{
	return m_internal->h;
}

FZ_FUNCTION int Image::n()
{
	return m_internal->n;
}

FZ_FUNCTION int Image::bpc()
{
	return m_internal->bpc;
}

FZ_FUNCTION unsigned int Image::imagemask()
{
	return m_internal->imagemask;
}

FZ_FUNCTION unsigned int Image::interpolate()
{
	return m_internal->interpolate;
}

FZ_FUNCTION unsigned int Image::use_colorkey()
{
	return m_internal->use_colorkey;
}

FZ_FUNCTION unsigned int Image::use_decode()
{
	return m_internal->use_decode;
}

FZ_FUNCTION unsigned int Image::invert_cmyk_jpeg()
{
	return m_internal->invert_cmyk_jpeg;
}

FZ_FUNCTION unsigned int Image::decoded()
{
	return m_internal->decoded;
}

FZ_FUNCTION unsigned int Image::scalable()
{
	return m_internal->scalable;
}

FZ_FUNCTION int Image::orientation()
{
	return m_internal->orientation;
}

FZ_FUNCTION Image Image::mask()
{
	mupdf::keep_image(m_internal->mask);
	return m_internal->mask;
}

FZ_FUNCTION int Image::xres()
{
	return m_internal->xres;
}

FZ_FUNCTION int Image::yres()
{
	return m_internal->yres;
}

FZ_FUNCTION Colorspace Image::colorspace()
{
	mupdf::keep_colorspace(m_internal->colorspace);
	return m_internal->colorspace;
}

FZ_FUNCTION int * Image::colorkey()
{
	return m_internal->colorkey;
}

FZ_FUNCTION float * Image::decode()
{
	return m_internal->decode;
}

FZ_FUNCTION Image::~Image()
{
	mupdf::drop_image(m_internal);
	if (s_check_refs)
	{
		s_Image_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long Image::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Irect (wrapper for fz_irect). */

/* Constructor using `fz_irect_from_rect()`. */
FZ_FUNCTION Irect::Irect(Rect& rect)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::irect_from_rect()\n";
	}
	*(fz_irect*) &this->x0 = mupdf::irect_from_rect(*(fz_rect*) &rect.x0);
}

/* Constructor using `fz_make_irect()`. */
FZ_FUNCTION Irect::Irect(int x0, int y0, int x1, int y1)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::make_irect()\n";
	}
	*(fz_irect*) &this->x0 = mupdf::make_irect(x0, y0, x1, y1);
}

/* Wrapper for `fz_expand_irect()`.  */
FZ_FUNCTION Irect Irect::expand_irect(int expand)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::expand_irect()\n";
	}
	auto ret = mupdf::mfz_expand_irect(*this, expand);
	return ret;
}

/* Wrapper for `fz_intersect_irect()`.  */
FZ_FUNCTION Irect Irect::intersect_irect(Irect& b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::intersect_irect()\n";
	}
	auto ret = mupdf::mfz_intersect_irect(*this, b);
	return ret;
}

/* Wrapper for `fz_irect_height()`.  */
FZ_FUNCTION int Irect::irect_height()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::irect_height()\n";
	}
	auto ret = mupdf::mfz_irect_height(*this);
	return ret;
}

/* Wrapper for `fz_irect_width()`.  */
FZ_FUNCTION unsigned int Irect::irect_width()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::irect_width()\n";
	}
	auto ret = mupdf::mfz_irect_width(*this);
	return ret;
}

/* Wrapper for `fz_is_empty_irect()`.  */
FZ_FUNCTION int Irect::is_empty_irect()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_empty_irect()\n";
	}
	auto ret = mupdf::mfz_is_empty_irect(*this);
	return ret;
}

/* Wrapper for `fz_is_infinite_irect()`.  */
FZ_FUNCTION int Irect::is_infinite_irect()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_infinite_irect()\n";
	}
	auto ret = mupdf::mfz_is_infinite_irect(*this);
	return ret;
}

/* Wrapper for `fz_is_valid_irect()`.  */
FZ_FUNCTION int Irect::is_valid_irect()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_valid_irect()\n";
	}
	auto ret = mupdf::mfz_is_valid_irect(*this);
	return ret;
}

/* Wrapper for `fz_rect_from_irect()`.  */
FZ_FUNCTION Rect Irect::rect_from_irect()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::rect_from_irect()\n";
	}
	auto ret = mupdf::mfz_rect_from_irect(*this);
	return ret;
}

/* Wrapper for `fz_translate_irect()`.  */
FZ_FUNCTION Irect Irect::translate_irect(int xoff, int yoff)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::translate_irect()\n";
	}
	auto ret = mupdf::mfz_translate_irect(*this, xoff, yoff);
	return ret;
}

FZ_FUNCTION Irect::Irect(const fz_irect* internal)
{
	this->x0 = internal->x0;
	this->y0 = internal->y0;
	this->x1 = internal->x1;
	this->y1 = internal->y1;
}

FZ_FUNCTION Irect::Irect(const fz_irect internal)
{
	this->x0 = internal.x0;
	this->y0 = internal.y0;
	this->x1 = internal.x1;
	this->y1 = internal.y1;
}

/** Constructor using raw copy of pre-existing `fz_irect`. */
FZ_FUNCTION fz_irect* Irect::internal()
{
	auto ret = (fz_irect*) &this->x0;
	return ret;
}

/** Constructor using raw copy of pre-existing `fz_irect`. */
FZ_FUNCTION const fz_irect* Irect::internal() const
{
	auto ret = (const fz_irect*) &this->x0;
	return ret;
}

FZ_FUNCTION std::string Irect::to_string()
{
	std::ostringstream buffer;
	buffer << *this;
	return buffer.str();
}


FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const Irect& rhs)
{
	return out << *rhs.internal();
}

/* Implementation of methods for Jbig2Globals (wrapper for fz_jbig2_globals). */

static RefsCheck<fz_jbig2_globals, Jbig2Globals> s_Jbig2Globals_refs_check(0, 32);

/** Copy constructor using `fz_keep_jbig2_globals()`. */
FZ_FUNCTION Jbig2Globals::Jbig2Globals(const Jbig2Globals& rhs)
: m_internal(mupdf::keep_jbig2_globals(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_jbig2_globals(this->m_internal) and mupdf::keep_jbig2_globals(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_Jbig2Globals_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `fz_keep_jbig2_globals()` and `fz_drop_jbig2_globals()`. */
FZ_FUNCTION Jbig2Globals& Jbig2Globals::operator=(const Jbig2Globals& rhs)
{
	mupdf::drop_jbig2_globals(this->m_internal);
	mupdf::keep_jbig2_globals(rhs.m_internal);
	if (s_check_refs)
	{
		s_Jbig2Globals_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_Jbig2Globals_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/* Wrapper for `fz_jbig2_globals_data()`.  */
FZ_FUNCTION Buffer Jbig2Globals::jbig2_globals_data()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::jbig2_globals_data()\n";
	}
	auto ret = mupdf::mfz_jbig2_globals_data(*this);
	if (s_check_refs)
	{
		s_Jbig2Globals_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

FZ_FUNCTION Jbig2Globals::Jbig2Globals(fz_jbig2_globals* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_Jbig2Globals_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION Jbig2Globals::~Jbig2Globals()
{
	mupdf::drop_jbig2_globals(m_internal);
	if (s_check_refs)
	{
		s_Jbig2Globals_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long Jbig2Globals::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for KeyStorable (wrapper for fz_key_storable). */

static RefsCheck<fz_key_storable, KeyStorable> s_KeyStorable_refs_check(offsetof(fz_key_storable, storable.refs), 32);

/** Copy constructor using `fz_keep_key_storable()`. */
FZ_FUNCTION KeyStorable::KeyStorable(const KeyStorable& rhs)
: m_internal((fz_key_storable*) mupdf::keep_key_storable(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_key_storable(this->m_internal) and mupdf::keep_key_storable(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_KeyStorable_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `fz_keep_key_storable()` and `fz_drop_key_storable()`. */
FZ_FUNCTION KeyStorable& KeyStorable::operator=(const KeyStorable& rhs)
{
	mupdf::drop_key_storable(this->m_internal);
	mupdf::keep_key_storable(rhs.m_internal);
	if (s_check_refs)
	{
		s_KeyStorable_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = (fz_key_storable*) rhs.m_internal;
	if (s_check_refs)
	{
		s_KeyStorable_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

FZ_FUNCTION KeyStorable::KeyStorable(fz_key_storable* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_KeyStorable_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION KeyStorable::~KeyStorable()
{
	mupdf::drop_key_storable(m_internal);
	if (s_check_refs)
	{
		s_KeyStorable_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long KeyStorable::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for LayoutBlock (wrapper for fz_layout_block). */

/* Constructor using `fz_new_layout()`. */
FZ_FUNCTION LayoutBlock::LayoutBlock()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_layout()\n";
	}
	this->m_internal = mupdf::new_layout();
}

/* Wrapper for `fz_add_layout_char()`.  */
FZ_FUNCTION void LayoutBlock::add_layout_char(float x, float w, const char *p)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::add_layout_char()\n";
	}
	mupdf::mfz_add_layout_char(*this, x, w, p);
}

/* Wrapper for `fz_add_layout_line()`.  */
FZ_FUNCTION void LayoutBlock::add_layout_line(float x, float y, float h, const char *p)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::add_layout_line()\n";
	}
	mupdf::mfz_add_layout_line(*this, x, y, h, p);
}

FZ_FUNCTION LayoutBlock::LayoutBlock(fz_layout_block* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long LayoutBlock::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for LayoutChar (wrapper for fz_layout_char). */

FZ_FUNCTION LayoutChar::LayoutChar(fz_layout_char* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long LayoutChar::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for LayoutLine (wrapper for fz_layout_line). */

FZ_FUNCTION LayoutLine::LayoutLine(fz_layout_line* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long LayoutLine::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Link (wrapper for fz_link). */

static RefsCheck<fz_link, Link> s_Link_refs_check(offsetof(fz_link, refs), 32);

/* Constructor using `fz_new_link()`. */
FZ_FUNCTION Link::Link(Rect& bbox, const char *uri)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_link()\n";
	}
	this->m_internal = mupdf::new_link(*(fz_rect*) &bbox.x0, uri);
	if (s_check_refs)
	{
		s_Link_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Copy constructor using `fz_keep_link()`. */
FZ_FUNCTION Link::Link(const Link& rhs)
: m_internal(mupdf::keep_link(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_link(this->m_internal) and mupdf::keep_link(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_Link_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `fz_keep_link()` and `fz_drop_link()`. */
FZ_FUNCTION Link& Link::operator=(const Link& rhs)
{
	mupdf::drop_link(this->m_internal);
	mupdf::keep_link(rhs.m_internal);
	if (s_check_refs)
	{
		s_Link_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_Link_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/** Custom method. */
FZ_FUNCTION LinkIterator Link::begin()
{
	auto ret = LinkIterator(*this);
	#if 1
	if (s_check_refs)
	{
		s_Link_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	#endif
	return ret;
}

/** Custom method. */
FZ_FUNCTION LinkIterator Link::end()
{
	auto ret = LinkIterator(NULL);
	#if 1
	if (s_check_refs)
	{
		s_Link_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	#endif
	return ret;
}

FZ_FUNCTION Link::Link(fz_link* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_Link_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION int Link::refs()
{
	return m_internal->refs;
}

FZ_FUNCTION Link Link::next()
{
	mupdf::keep_link(m_internal->next);
	return m_internal->next;
}

FZ_FUNCTION fz_rect Link::rect()
{
	return m_internal->rect;
}

FZ_FUNCTION const char *Link::uri()
{
	return m_internal->uri;
}

FZ_FUNCTION Link::~Link()
{
	mupdf::drop_link(m_internal);
	if (s_check_refs)
	{
		s_Link_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long Link::m_internal_value()
{
	return (uintptr_t) m_internal;
}


FZ_FUNCTION LinkIterator::LinkIterator(const Link& item)
: m_item( item)
{
}
FZ_FUNCTION LinkIterator& LinkIterator::operator++()
{
	mupdf::keep_link(m_item.m_internal->next);
	m_item = Link(m_item.m_internal->next);
	return *this;
}
FZ_FUNCTION bool LinkIterator::operator==( const LinkIterator& rhs)
{
	return m_item.m_internal == rhs.m_item.m_internal;
}
FZ_FUNCTION bool LinkIterator::operator!=( const LinkIterator& rhs)
{
	return m_item.m_internal != rhs.m_item.m_internal;
}
FZ_FUNCTION Link LinkIterator::operator*()
{
	return m_item;
}
FZ_FUNCTION Link* LinkIterator::operator->()
{
	return &m_item;
}


/* Implementation of methods for LinkDest (wrapper for fz_link_dest). */

/* Wrapper for `pdf_format_link_uri()`.  */
FZ_FUNCTION char *LinkDest::format_link_uri()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_format_link_uri()\n";
	}
	auto ret = mupdf::mpdf_format_link_uri(*this);
	return ret;
}

FZ_FUNCTION LinkDest::LinkDest(fz_link_dest* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long LinkDest::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Location (wrapper for fz_location). */

/* Constructor using `fz_make_location()`. */
FZ_FUNCTION Location::Location(int chapter, int page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::make_location()\n";
	}
	*(fz_location*) &this->chapter = mupdf::make_location(chapter, page);
}

FZ_FUNCTION Location::Location(const fz_location* internal)
{
	this->chapter = internal->chapter;
	this->page = internal->page;
}

FZ_FUNCTION Location::Location(const fz_location internal)
{
	this->chapter = internal.chapter;
	this->page = internal.page;
}

/** Constructor using raw copy of pre-existing `fz_location`. */
FZ_FUNCTION fz_location* Location::internal()
{
	auto ret = (fz_location*) &this->chapter;
	return ret;
}

/** Constructor using raw copy of pre-existing `fz_location`. */
FZ_FUNCTION const fz_location* Location::internal() const
{
	auto ret = (const fz_location*) &this->chapter;
	return ret;
}

FZ_FUNCTION std::string Location::to_string()
{
	std::ostringstream buffer;
	buffer << *this;
	return buffer.str();
}


FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const Location& rhs)
{
	return out << *rhs.internal();
}

/* Implementation of methods for LocksContext (wrapper for fz_locks_context). */

FZ_FUNCTION LocksContext::LocksContext(fz_locks_context* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long LocksContext::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Matrix (wrapper for fz_matrix). */

/* Constructor using `fz_make_matrix()`. */
FZ_FUNCTION Matrix::Matrix(float a, float b, float c, float d, float e, float f)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::make_matrix()\n";
	}
	*(fz_matrix*) &this->a = mupdf::make_matrix(a, b, c, d, e, f);
}

/** Custom constructor. */
FZ_FUNCTION Matrix::Matrix()
: a(1), b(0), c(0), d(1), e(0), f(0)
{
}

/* Wrapper for `fz_concat()`.  */
FZ_FUNCTION Matrix Matrix::concat(Matrix& left, Matrix& right)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::concat()\n";
	}
	auto ret = mupdf::mfz_concat(left, right);
	return ret;
}

/* Wrapper for `fz_scale()`.  */
FZ_FUNCTION Matrix Matrix::scale(float sx, float sy)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::scale()\n";
	}
	auto ret = mupdf::mfz_scale(sx, sy);
	return ret;
}

/* Wrapper for `fz_shear()`.  */
FZ_FUNCTION Matrix Matrix::shear(float sx, float sy)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::shear()\n";
	}
	auto ret = mupdf::mfz_shear(sx, sy);
	return ret;
}

/* Wrapper for `fz_rotate()`.  */
FZ_FUNCTION Matrix Matrix::rotate(float degrees)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::rotate()\n";
	}
	auto ret = mupdf::mfz_rotate(degrees);
	return ret;
}

/* Wrapper for `fz_translate()`.  */
FZ_FUNCTION Matrix Matrix::translate(float tx, float ty)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::translate()\n";
	}
	auto ret = mupdf::mfz_translate(tx, ty);
	return ret;
}

/* Wrapper for `fz_transform_page()`.  */
FZ_FUNCTION Matrix Matrix::transform_page(Rect& mediabox, float resolution, float rotate)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::transform_page()\n";
	}
	auto ret = mupdf::mfz_transform_page(mediabox, resolution, rotate);
	return ret;
}

/* Wrapper for `fz_concat()`.  */
FZ_FUNCTION Matrix Matrix::concat(Matrix& right)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::concat()\n";
	}
	auto ret = mupdf::mfz_concat(*this, right);
	return ret;
}

/* Wrapper for `fz_invert_matrix()`.  */
FZ_FUNCTION Matrix Matrix::invert_matrix()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::invert_matrix()\n";
	}
	auto ret = mupdf::mfz_invert_matrix(*this);
	return ret;
}

/* Wrapper for `fz_is_identity()`.  */
FZ_FUNCTION int Matrix::is_identity()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_identity()\n";
	}
	auto ret = mupdf::mfz_is_identity(*this);
	return ret;
}

/* Wrapper for `fz_is_rectilinear()`.  */
FZ_FUNCTION int Matrix::is_rectilinear()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_rectilinear()\n";
	}
	auto ret = mupdf::mfz_is_rectilinear(*this);
	return ret;
}

/* Wrapper for `fz_matrix_expansion()`.  */
FZ_FUNCTION float Matrix::matrix_expansion()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::matrix_expansion()\n";
	}
	auto ret = mupdf::mfz_matrix_expansion(*this);
	return ret;
}

/* Wrapper for `fz_matrix_max_expansion()`.  */
FZ_FUNCTION float Matrix::matrix_max_expansion()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::matrix_max_expansion()\n";
	}
	auto ret = mupdf::mfz_matrix_max_expansion(*this);
	return ret;
}

/* Wrapper for `fz_post_scale()`.  */
FZ_FUNCTION Matrix Matrix::post_scale(float sx, float sy)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::post_scale()\n";
	}
	auto ret = mupdf::mfz_post_scale(*this, sx, sy);
	return ret;
}

/* Wrapper for `fz_pre_rotate()`.  */
FZ_FUNCTION Matrix Matrix::pre_rotate(float degrees)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pre_rotate()\n";
	}
	auto ret = mupdf::mfz_pre_rotate(*this, degrees);
	return ret;
}

/* Wrapper for `fz_pre_scale()`.  */
FZ_FUNCTION Matrix Matrix::pre_scale(float sx, float sy)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pre_scale()\n";
	}
	auto ret = mupdf::mfz_pre_scale(*this, sx, sy);
	return ret;
}

/* Wrapper for `fz_pre_shear()`.  */
FZ_FUNCTION Matrix Matrix::pre_shear(float sx, float sy)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pre_shear()\n";
	}
	auto ret = mupdf::mfz_pre_shear(*this, sx, sy);
	return ret;
}

/* Wrapper for `fz_pre_translate()`.  */
FZ_FUNCTION Matrix Matrix::pre_translate(float tx, float ty)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pre_translate()\n";
	}
	auto ret = mupdf::mfz_pre_translate(*this, tx, ty);
	return ret;
}

/* Wrapper for `fz_subpixel_adjust()`.  */
FZ_FUNCTION float Matrix::subpixel_adjust(Matrix& subpix_ctm, unsigned char *qe, unsigned char *qf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::subpixel_adjust()\n";
	}
	auto ret = mupdf::mfz_subpixel_adjust(*this, subpix_ctm, qe, qf);
	return ret;
}

/* Wrapper for `fz_try_invert_matrix()`.  */
FZ_FUNCTION int Matrix::try_invert_matrix(Matrix& src)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::try_invert_matrix()\n";
	}
	auto ret = mupdf::mfz_try_invert_matrix(*this, src);
	return ret;
}

FZ_FUNCTION Matrix::Matrix(const fz_matrix* internal)
{
	this->a = internal->a;
	this->b = internal->b;
	this->c = internal->c;
	this->d = internal->d;
	this->e = internal->e;
	this->f = internal->f;
}

FZ_FUNCTION Matrix::Matrix(const fz_matrix internal)
{
	this->a = internal.a;
	this->b = internal.b;
	this->c = internal.c;
	this->d = internal.d;
	this->e = internal.e;
	this->f = internal.f;
}

/** Constructor using raw copy of pre-existing `fz_matrix`. */
FZ_FUNCTION fz_matrix* Matrix::internal()
{
	auto ret = (fz_matrix*) &this->a;
	return ret;
}

/** Constructor using raw copy of pre-existing `fz_matrix`. */
FZ_FUNCTION const fz_matrix* Matrix::internal() const
{
	auto ret = (const fz_matrix*) &this->a;
	return ret;
}

FZ_FUNCTION std::string Matrix::to_string()
{
	std::ostringstream buffer;
	buffer << *this;
	return buffer.str();
}


FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const Matrix& rhs)
{
	return out << *rhs.internal();
}

/* Implementation of methods for Md5 (wrapper for fz_md5). */

/** Custom constructor. */
FZ_FUNCTION Md5::Md5()
{
	md5_init();
}

/* Wrapper for `fz_md5_final()`.  */
FZ_FUNCTION void Md5::md5_final(unsigned char digest[16])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::md5_final()\n";
	}
	mupdf::mfz_md5_final(*this, digest);
}

/* Wrapper for `fz_md5_init()`.  */
FZ_FUNCTION void Md5::md5_init()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::md5_init()\n";
	}
	mupdf::mfz_md5_init(*this);
}

/* Wrapper for `fz_md5_update()`.  */
FZ_FUNCTION void Md5::md5_update(const unsigned char *input, size_t inlen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::md5_update()\n";
	}
	mupdf::mfz_md5_update(*this, input, inlen);
}

/* Wrapper for `fz_md5_update_int64()`.  */
FZ_FUNCTION void Md5::md5_update_int64(int64_t i)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::md5_update_int64()\n";
	}
	mupdf::mfz_md5_update_int64(*this, i);
}

/** Custom method. */
FZ_FUNCTION std::vector<unsigned char> Md5::md5_final2()
{
	std::vector<unsigned char>  ret(16);
	mupdf::md5_final( &m_internal, &ret[0]);
	return ret;
}

FZ_FUNCTION Md5::Md5(const fz_md5* internal)
: m_internal(*internal)
{
}

FZ_FUNCTION uint32_t Md5::lo()
{
	return m_internal.lo;
}

FZ_FUNCTION uint32_t Md5::hi()
{
	return m_internal.hi;
}

FZ_FUNCTION uint32_t Md5::a()
{
	return m_internal.a;
}

FZ_FUNCTION uint32_t Md5::b()
{
	return m_internal.b;
}

FZ_FUNCTION uint32_t Md5::c()
{
	return m_internal.c;
}

FZ_FUNCTION uint32_t Md5::d()
{
	return m_internal.d;
}

FZ_FUNCTION unsigned char * Md5::buffer()
{
	return m_internal.buffer;
}

FZ_FUNCTION std::string Md5::to_string()
{
	std::ostringstream buffer;
	buffer << *this;
	return buffer.str();
}


FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const Md5& rhs)
{
	return out << rhs.m_internal;
}

/* Implementation of methods for Outline (wrapper for fz_outline). */

static RefsCheck<fz_outline, Outline> s_Outline_refs_check(offsetof(fz_outline, refs), 32);

/* Constructor using `fz_load_outline()`. */
FZ_FUNCTION Outline::Outline(const Document& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_outline()\n";
	}
	this->m_internal = mupdf::load_outline(doc.m_internal);
	if (s_check_refs)
	{
		s_Outline_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_load_outline_from_iterator()`. */
FZ_FUNCTION Outline::Outline(const OutlineIterator& iter)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_outline_from_iterator()\n";
	}
	this->m_internal = mupdf::load_outline_from_iterator(iter.m_internal);
	if (s_check_refs)
	{
		s_Outline_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_outline()`. */
FZ_FUNCTION Outline::Outline()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_outline()\n";
	}
	this->m_internal = mupdf::new_outline();
	if (s_check_refs)
	{
		s_Outline_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Copy constructor using `fz_keep_outline()`. */
FZ_FUNCTION Outline::Outline(const Outline& rhs)
: m_internal(mupdf::keep_outline(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_outline(this->m_internal) and mupdf::keep_outline(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_Outline_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `fz_keep_outline()` and `fz_drop_outline()`. */
FZ_FUNCTION Outline& Outline::operator=(const Outline& rhs)
{
	mupdf::drop_outline(this->m_internal);
	mupdf::keep_outline(rhs.m_internal);
	if (s_check_refs)
	{
		s_Outline_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_Outline_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

FZ_FUNCTION Outline::Outline(fz_outline* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_Outline_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION int Outline::refs()
{
	return m_internal->refs;
}

FZ_FUNCTION const char *Outline::title()
{
	return m_internal->title;
}

FZ_FUNCTION const char *Outline::uri()
{
	return m_internal->uri;
}

FZ_FUNCTION fz_location Outline::page()
{
	return m_internal->page;
}

FZ_FUNCTION float Outline::x()
{
	return m_internal->x;
}

FZ_FUNCTION float Outline::y()
{
	return m_internal->y;
}

FZ_FUNCTION Outline Outline::next()
{
	mupdf::keep_outline(m_internal->next);
	return m_internal->next;
}

FZ_FUNCTION Outline Outline::down()
{
	mupdf::keep_outline(m_internal->down);
	return m_internal->down;
}

FZ_FUNCTION int Outline::is_open()
{
	return m_internal->is_open;
}

FZ_FUNCTION Outline::~Outline()
{
	mupdf::drop_outline(m_internal);
	if (s_check_refs)
	{
		s_Outline_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long Outline::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for OutlineItem (wrapper for fz_outline_item). */


FZ_FUNCTION OutlineItem::OutlineItem(const fz_outline_item* item)
{
	if (item)
	{
		m_valid = true;
		m_title = item->title;
		m_uri = item->uri;
		m_is_open = item->is_open;
	}
	else
	{
		m_valid = false;
	}
}
FZ_FUNCTION bool OutlineItem::valid() const
{
	return m_valid;
}
FZ_FUNCTION const std::string& OutlineItem::title() const
{
	if (!m_valid) throw ErrorGeneric("fz_outline_item is invalid");
	return m_title;
}
FZ_FUNCTION const std::string& OutlineItem::uri() const
{
	if (!m_valid) throw ErrorGeneric("fz_outline_item is invalid");
	return m_uri;
}
FZ_FUNCTION int OutlineItem::is_open() const
{
	if (!m_valid) throw ErrorGeneric("fz_outline_item is invalid");
	return m_is_open;
}

/* Implementation of methods for OutlineIterator (wrapper for fz_outline_iterator). */

/* Constructor using `fz_new_outline_iterator()`. */
FZ_FUNCTION OutlineIterator::OutlineIterator(const Document& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_outline_iterator()\n";
	}
	this->m_internal = mupdf::new_outline_iterator(doc.m_internal);
}

/* Constructor using `fz_new_outline_iterator_of_size()`. */
FZ_FUNCTION OutlineIterator::OutlineIterator(size_t size, const Document& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_outline_iterator_of_size()\n";
	}
	this->m_internal = mupdf::new_outline_iterator_of_size(size, doc.m_internal);
}

/* Wrapper for `fz_load_outline_from_iterator()`.  */
FZ_FUNCTION Outline OutlineIterator::load_outline_from_iterator()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_outline_from_iterator()\n";
	}
	auto ret = mupdf::mfz_load_outline_from_iterator(*this);
	return ret;
}

/* Wrapper for `fz_outline_iterator_delete()`.  */
FZ_FUNCTION int OutlineIterator::outline_iterator_delete()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::outline_iterator_delete()\n";
	}
	auto ret = mupdf::mfz_outline_iterator_delete(*this);
	return ret;
}

/* Wrapper for `fz_outline_iterator_down()`.  */
FZ_FUNCTION int OutlineIterator::outline_iterator_down()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::outline_iterator_down()\n";
	}
	auto ret = mupdf::mfz_outline_iterator_down(*this);
	return ret;
}

/* Wrapper for `fz_outline_iterator_item()`.  */
FZ_FUNCTION OutlineItem OutlineIterator::outline_iterator_item()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::outline_iterator_item()\n";
	}
	auto ret = mupdf::mfz_outline_iterator_item(*this);
	return ret;
}

/* Wrapper for `fz_outline_iterator_next()`.  */
FZ_FUNCTION int OutlineIterator::outline_iterator_next()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::outline_iterator_next()\n";
	}
	auto ret = mupdf::mfz_outline_iterator_next(*this);
	return ret;
}

/* Wrapper for `fz_outline_iterator_prev()`.  */
FZ_FUNCTION int OutlineIterator::outline_iterator_prev()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::outline_iterator_prev()\n";
	}
	auto ret = mupdf::mfz_outline_iterator_prev(*this);
	return ret;
}

/* Wrapper for `fz_outline_iterator_up()`.  */
FZ_FUNCTION int OutlineIterator::outline_iterator_up()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::outline_iterator_up()\n";
	}
	auto ret = mupdf::mfz_outline_iterator_up(*this);
	return ret;
}

/** Custom method. */
FZ_FUNCTION int OutlineIterator::outline_iterator_insert(OutlineItem& item)
{
	/* Create a temporary fz_outline_item. */
	fz_outline_item item2;
	item2.title = (char*) item.title().c_str();
	item2.uri = (char*) item.uri().c_str();
	item2.is_open = item.is_open();
	return mupdf::outline_iterator_insert(m_internal, &item2);
}

/** Custom method. */
FZ_FUNCTION void OutlineIterator::outline_iterator_update(OutlineItem& item)
{
	/* Create a temporary fz_outline_item. */
	fz_outline_item item2;
	item2.title = (char*) item.title().c_str();
	item2.uri = (char*) item.uri().c_str();
	item2.is_open = item.is_open();
	return mupdf::outline_iterator_update(m_internal, &item2);
}

FZ_FUNCTION OutlineIterator::OutlineIterator(fz_outline_iterator* internal)
: m_internal(internal)
{
}

FZ_FUNCTION OutlineIterator::~OutlineIterator()
{
	mupdf::drop_outline_iterator(m_internal);
}

/** Custom method. */
FZ_FUNCTION long long OutlineIterator::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Output (wrapper for fz_output). */

/* Constructor using `fz_new_arc4_output()`. */
FZ_FUNCTION Output::Output(const Output& chain, unsigned char *key, size_t keylen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_arc4_output()\n";
	}
	this->m_internal = mupdf::new_arc4_output(chain.m_internal, key, keylen);
}

/* Constructor using `fz_new_deflate_output()`. */
FZ_FUNCTION Output::Output(const Output& chain, int effort, int raw)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_deflate_output()\n";
	}
	this->m_internal = mupdf::new_deflate_output(chain.m_internal, effort, raw);
}

/* Constructor using `fz_new_log_for_module()`. */
FZ_FUNCTION Output::Output(const char *module)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_log_for_module()\n";
	}
	this->m_internal = mupdf::new_log_for_module(module);
}

/* Constructor using `fz_new_output()`. */
FZ_FUNCTION Output::Output(int bufsiz, void *state, fz_output_write_fn *write, fz_output_close_fn *close, fz_output_drop_fn *drop)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_output()\n";
	}
	this->m_internal = mupdf::new_output(bufsiz, state, write, close, drop);
}

/* Constructor using `fz_new_output_with_buffer()`. */
FZ_FUNCTION Output::Output(const Buffer& buf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_output_with_buffer()\n";
	}
	this->m_internal = mupdf::new_output_with_buffer(buf.m_internal);
}

/* Constructor using `fz_new_output_with_path()`. */
FZ_FUNCTION Output::Output(const char *filename, int append)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_output_with_path()\n";
	}
	this->m_internal = mupdf::new_output_with_path(filename, append);
}

/** Custom constructor. */
FZ_FUNCTION Output::Output(Fixed out)
{
	if (0)  {}
	else if (out == Fixed_STDOUT) {
		m_internal = mupdf::stdout_();
	}
	else if (out == Fixed_STDERR) {
		m_internal = mupdf::stderr_();
	}
	else {
		throw ErrorAbort("Unrecognised Fixed value");
	}
}

/** Custom constructor. */
FZ_FUNCTION Output::Output(const Output& chain, Filter filter)
{
	if (0)  {}
	else if (filter == Filter_HEX) {
		m_internal = mupdf::new_asciihex_output(chain.m_internal);
	}
	else if (filter == Filter_85) {
		m_internal = mupdf::new_ascii85_output(chain.m_internal);
	}
	else if (filter == Filter_RLE) {
		m_internal = mupdf::new_rle_output(chain.m_internal);
	}
	else {
		throw ErrorAbort("Unrecognised Filter value");
	}
}

/* Wrapper for `fz_close_output()`.  */
FZ_FUNCTION void Output::close_output()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::close_output()\n";
	}
	mupdf::mfz_close_output(*this);
}

/* Wrapper for `fz_debug_store()`.  */
FZ_FUNCTION void Output::debug_store()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::debug_store()\n";
	}
	mupdf::mfz_debug_store(*this);
}

/* Wrapper for `fz_dump_glyph_cache_stats()`.  */
FZ_FUNCTION void Output::dump_glyph_cache_stats()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::dump_glyph_cache_stats()\n";
	}
	mupdf::mfz_dump_glyph_cache_stats(*this);
}

/* Wrapper for `fz_flush_output()`.  */
FZ_FUNCTION void Output::flush_output()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::flush_output()\n";
	}
	mupdf::mfz_flush_output(*this);
}

/* Wrapper for `fz_new_svg_device()`.  */
FZ_FUNCTION Device Output::new_svg_device(float page_width, float page_height, int text_format, int reuse_images)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_svg_device()\n";
	}
	auto ret = mupdf::mfz_new_svg_device(*this, page_width, page_height, text_format, reuse_images);
	return ret;
}

/* Wrapper for `fz_new_svg_device_with_id()`.
	
	This method has out-params. Python/C# wrappers look like:
		`new_svg_device_with_id(float page_width, float page_height, int text_format, int reuse_images)` => `(fz_device *, int id)`
	 */
FZ_FUNCTION Device Output::new_svg_device_with_id(float page_width, float page_height, int text_format, int reuse_images, int *id)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_svg_device_with_id()\n";
	}
	auto ret = mupdf::mfz_new_svg_device_with_id(*this, page_width, page_height, text_format, reuse_images, id);
	return ret;
}

/* Wrapper for `fz_new_trace_device()`.  */
FZ_FUNCTION Device Output::new_trace_device()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_trace_device()\n";
	}
	auto ret = mupdf::mfz_new_trace_device(*this);
	return ret;
}

/* Wrapper for `fz_new_xmltext_device()`.  */
FZ_FUNCTION Device Output::new_xmltext_device()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_xmltext_device()\n";
	}
	auto ret = mupdf::mfz_new_xmltext_device(*this);
	return ret;
}

/* Wrapper for `fz_output_supports_stream()`.  */
FZ_FUNCTION int Output::output_supports_stream()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::output_supports_stream()\n";
	}
	auto ret = mupdf::mfz_output_supports_stream(*this);
	return ret;
}

/* Wrapper for `fz_print_stext_header_as_html()`.  */
FZ_FUNCTION void Output::print_stext_header_as_html()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::print_stext_header_as_html()\n";
	}
	mupdf::mfz_print_stext_header_as_html(*this);
}

/* Wrapper for `fz_print_stext_header_as_xhtml()`.  */
FZ_FUNCTION void Output::print_stext_header_as_xhtml()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::print_stext_header_as_xhtml()\n";
	}
	mupdf::mfz_print_stext_header_as_xhtml(*this);
}

/* Wrapper for `fz_print_stext_page_as_html()`.  */
FZ_FUNCTION void Output::print_stext_page_as_html(const StextPage& page, int id)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::print_stext_page_as_html()\n";
	}
	mupdf::mfz_print_stext_page_as_html(*this, page, id);
}

/* Wrapper for `fz_print_stext_page_as_json()`.  */
FZ_FUNCTION void Output::print_stext_page_as_json(const StextPage& page, float scale)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::print_stext_page_as_json()\n";
	}
	mupdf::mfz_print_stext_page_as_json(*this, page, scale);
}

/* Wrapper for `fz_print_stext_page_as_text()`.  */
FZ_FUNCTION void Output::print_stext_page_as_text(const StextPage& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::print_stext_page_as_text()\n";
	}
	mupdf::mfz_print_stext_page_as_text(*this, page);
}

/* Wrapper for `fz_print_stext_page_as_xhtml()`.  */
FZ_FUNCTION void Output::print_stext_page_as_xhtml(const StextPage& page, int id)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::print_stext_page_as_xhtml()\n";
	}
	mupdf::mfz_print_stext_page_as_xhtml(*this, page, id);
}

/* Wrapper for `fz_print_stext_page_as_xml()`.  */
FZ_FUNCTION void Output::print_stext_page_as_xml(const StextPage& page, int id)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::print_stext_page_as_xml()\n";
	}
	mupdf::mfz_print_stext_page_as_xml(*this, page, id);
}

/* Wrapper for `fz_print_stext_trailer_as_html()`.  */
FZ_FUNCTION void Output::print_stext_trailer_as_html()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::print_stext_trailer_as_html()\n";
	}
	mupdf::mfz_print_stext_trailer_as_html(*this);
}

/* Wrapper for `fz_print_stext_trailer_as_xhtml()`.  */
FZ_FUNCTION void Output::print_stext_trailer_as_xhtml()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::print_stext_trailer_as_xhtml()\n";
	}
	mupdf::mfz_print_stext_trailer_as_xhtml(*this);
}

/* Wrapper for `fz_seek_output()`.  */
FZ_FUNCTION void Output::seek_output(int64_t off, int whence)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::seek_output()\n";
	}
	mupdf::mfz_seek_output(*this, off, whence);
}

/* Wrapper for `fz_set_stddbg()`.  */
FZ_FUNCTION void Output::set_stddbg()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_stddbg()\n";
	}
	mupdf::mfz_set_stddbg(*this);
}

/* Wrapper for `fz_stream_from_output()`.  */
FZ_FUNCTION Stream Output::stream_from_output()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::stream_from_output()\n";
	}
	auto ret = mupdf::mfz_stream_from_output(*this);
	return ret;
}

/* Wrapper for `fz_tell_output()`.  */
FZ_FUNCTION int64_t Output::tell_output()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::tell_output()\n";
	}
	auto ret = mupdf::mfz_tell_output(*this);
	return ret;
}

/* Wrapper for `fz_truncate_output()`.  */
FZ_FUNCTION void Output::truncate_output()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::truncate_output()\n";
	}
	mupdf::mfz_truncate_output(*this);
}

/* Wrapper for `fz_write_base64()`.  */
FZ_FUNCTION void Output::write_base64(const unsigned char *data, size_t size, int newline)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_base64()\n";
	}
	mupdf::mfz_write_base64(*this, data, size, newline);
}

/* Wrapper for `fz_write_base64_buffer()`.  */
FZ_FUNCTION void Output::write_base64_buffer(const Buffer& data, int newline)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_base64_buffer()\n";
	}
	mupdf::mfz_write_base64_buffer(*this, data, newline);
}

/* Wrapper for `fz_write_bitmap_as_pbm()`.  */
FZ_FUNCTION void Output::write_bitmap_as_pbm(const Bitmap& bitmap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_bitmap_as_pbm()\n";
	}
	mupdf::mfz_write_bitmap_as_pbm(*this, bitmap);
}

/* Wrapper for `fz_write_bitmap_as_pcl()`.  */
FZ_FUNCTION void Output::write_bitmap_as_pcl(const Bitmap& bitmap, const PclOptions& pcl)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_bitmap_as_pcl()\n";
	}
	mupdf::mfz_write_bitmap_as_pcl(*this, bitmap, pcl);
}

/* Wrapper for `fz_write_bitmap_as_pkm()`.  */
FZ_FUNCTION void Output::write_bitmap_as_pkm(const Bitmap& bitmap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_bitmap_as_pkm()\n";
	}
	mupdf::mfz_write_bitmap_as_pkm(*this, bitmap);
}

/* Wrapper for `fz_write_bitmap_as_pwg()`.  */
FZ_FUNCTION void Output::write_bitmap_as_pwg(const Bitmap& bitmap, PwgOptions& pwg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_bitmap_as_pwg()\n";
	}
	mupdf::mfz_write_bitmap_as_pwg(*this, bitmap, pwg);
}

/* Wrapper for `fz_write_bitmap_as_pwg_page()`.  */
FZ_FUNCTION void Output::write_bitmap_as_pwg_page(const Bitmap& bitmap, PwgOptions& pwg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_bitmap_as_pwg_page()\n";
	}
	mupdf::mfz_write_bitmap_as_pwg_page(*this, bitmap, pwg);
}

/* Wrapper for `fz_write_byte()`.  */
FZ_FUNCTION void Output::write_byte(unsigned char x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_byte()\n";
	}
	mupdf::mfz_write_byte(*this, x);
}

/* Wrapper for `fz_write_char()`.  */
FZ_FUNCTION void Output::write_char(char x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_char()\n";
	}
	mupdf::mfz_write_char(*this, x);
}

/* Wrapper for `fz_write_data()`.  */
FZ_FUNCTION void Output::write_data(const void *data, size_t size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_data()\n";
	}
	mupdf::mfz_write_data(*this, data, size);
}

/* Wrapper for `fz_write_float_be()`.  */
FZ_FUNCTION void Output::write_float_be(float f)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_float_be()\n";
	}
	mupdf::mfz_write_float_be(*this, f);
}

/* Wrapper for `fz_write_float_le()`.  */
FZ_FUNCTION void Output::write_float_le(float f)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_float_le()\n";
	}
	mupdf::mfz_write_float_le(*this, f);
}

/* Wrapper for `fz_write_image_as_data_uri()`.  */
FZ_FUNCTION void Output::write_image_as_data_uri(const Image& image)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_image_as_data_uri()\n";
	}
	mupdf::mfz_write_image_as_data_uri(*this, image);
}

/* Wrapper for `fz_write_int16_be()`.  */
FZ_FUNCTION void Output::write_int16_be(int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_int16_be()\n";
	}
	mupdf::mfz_write_int16_be(*this, x);
}

/* Wrapper for `fz_write_int16_le()`.  */
FZ_FUNCTION void Output::write_int16_le(int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_int16_le()\n";
	}
	mupdf::mfz_write_int16_le(*this, x);
}

/* Wrapper for `fz_write_int32_be()`.  */
FZ_FUNCTION void Output::write_int32_be(int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_int32_be()\n";
	}
	mupdf::mfz_write_int32_be(*this, x);
}

/* Wrapper for `fz_write_int32_le()`.  */
FZ_FUNCTION void Output::write_int32_le(int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_int32_le()\n";
	}
	mupdf::mfz_write_int32_le(*this, x);
}

/* Wrapper for `fz_write_pixmap_as_data_uri()`.  */
FZ_FUNCTION void Output::write_pixmap_as_data_uri(const Pixmap& pixmap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_pixmap_as_data_uri()\n";
	}
	mupdf::mfz_write_pixmap_as_data_uri(*this, pixmap);
}

/* Wrapper for `fz_write_pixmap_as_pam()`.  */
FZ_FUNCTION void Output::write_pixmap_as_pam(const Pixmap& pixmap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_pixmap_as_pam()\n";
	}
	mupdf::mfz_write_pixmap_as_pam(*this, pixmap);
}

/* Wrapper for `fz_write_pixmap_as_pcl()`.  */
FZ_FUNCTION void Output::write_pixmap_as_pcl(const Pixmap& pixmap, const PclOptions& pcl)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_pixmap_as_pcl()\n";
	}
	mupdf::mfz_write_pixmap_as_pcl(*this, pixmap, pcl);
}

/* Wrapper for `fz_write_pixmap_as_pclm()`.  */
FZ_FUNCTION void Output::write_pixmap_as_pclm(const Pixmap& pixmap, const PclmOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_pixmap_as_pclm()\n";
	}
	mupdf::mfz_write_pixmap_as_pclm(*this, pixmap, options);
}

/* Wrapper for `fz_write_pixmap_as_pdfocr()`.  */
FZ_FUNCTION void Output::write_pixmap_as_pdfocr(const Pixmap& pixmap, PdfocrOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_pixmap_as_pdfocr()\n";
	}
	mupdf::mfz_write_pixmap_as_pdfocr(*this, pixmap, options);
}

/* Wrapper for `fz_write_pixmap_as_png()`.  */
FZ_FUNCTION void Output::write_pixmap_as_png(const Pixmap& pixmap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_pixmap_as_png()\n";
	}
	mupdf::mfz_write_pixmap_as_png(*this, pixmap);
}

/* Wrapper for `fz_write_pixmap_as_pnm()`.  */
FZ_FUNCTION void Output::write_pixmap_as_pnm(const Pixmap& pixmap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_pixmap_as_pnm()\n";
	}
	mupdf::mfz_write_pixmap_as_pnm(*this, pixmap);
}

/* Wrapper for `fz_write_pixmap_as_ps()`.  */
FZ_FUNCTION void Output::write_pixmap_as_ps(const Pixmap& pixmap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_pixmap_as_ps()\n";
	}
	mupdf::mfz_write_pixmap_as_ps(*this, pixmap);
}

/* Wrapper for `fz_write_pixmap_as_psd()`.  */
FZ_FUNCTION void Output::write_pixmap_as_psd(const Pixmap& pixmap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_pixmap_as_psd()\n";
	}
	mupdf::mfz_write_pixmap_as_psd(*this, pixmap);
}

/* Wrapper for `fz_write_pixmap_as_pwg()`.  */
FZ_FUNCTION void Output::write_pixmap_as_pwg(const Pixmap& pixmap, PwgOptions& pwg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_pixmap_as_pwg()\n";
	}
	mupdf::mfz_write_pixmap_as_pwg(*this, pixmap, pwg);
}

/* Wrapper for `fz_write_pixmap_as_pwg_page()`.  */
FZ_FUNCTION void Output::write_pixmap_as_pwg_page(const Pixmap& pixmap, PwgOptions& pwg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_pixmap_as_pwg_page()\n";
	}
	mupdf::mfz_write_pixmap_as_pwg_page(*this, pixmap, pwg);
}

/* Wrapper for `fz_write_ps_file_header()`.  */
FZ_FUNCTION void Output::write_ps_file_header()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_ps_file_header()\n";
	}
	mupdf::mfz_write_ps_file_header(*this);
}

/* Wrapper for `fz_write_ps_file_trailer()`.  */
FZ_FUNCTION void Output::write_ps_file_trailer(int pages)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_ps_file_trailer()\n";
	}
	mupdf::mfz_write_ps_file_trailer(*this, pages);
}

/* Wrapper for `fz_write_pwg_file_header()`.  */
FZ_FUNCTION void Output::write_pwg_file_header()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_pwg_file_header()\n";
	}
	mupdf::mfz_write_pwg_file_header(*this);
}

/* Wrapper for `fz_write_rune()`.  */
FZ_FUNCTION void Output::write_rune(int rune)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_rune()\n";
	}
	mupdf::mfz_write_rune(*this, rune);
}

/* Wrapper for `fz_write_string()`.  */
FZ_FUNCTION void Output::write_string(const char *s)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_string()\n";
	}
	mupdf::mfz_write_string(*this, s);
}

/* Wrapper for `fz_write_uint16_be()`.  */
FZ_FUNCTION void Output::write_uint16_be(unsigned int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_uint16_be()\n";
	}
	mupdf::mfz_write_uint16_be(*this, x);
}

/* Wrapper for `fz_write_uint16_le()`.  */
FZ_FUNCTION void Output::write_uint16_le(unsigned int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_uint16_le()\n";
	}
	mupdf::mfz_write_uint16_le(*this, x);
}

/* Wrapper for `fz_write_uint32_be()`.  */
FZ_FUNCTION void Output::write_uint32_be(unsigned int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_uint32_be()\n";
	}
	mupdf::mfz_write_uint32_be(*this, x);
}

/* Wrapper for `fz_write_uint32_le()`.  */
FZ_FUNCTION void Output::write_uint32_le(unsigned int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_uint32_le()\n";
	}
	mupdf::mfz_write_uint32_le(*this, x);
}

/* Wrapper for `fz_write_vprintf()`.  */
FZ_FUNCTION void Output::write_vprintf(const char *fmt, va_list ap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_vprintf()\n";
	}
	mupdf::mfz_write_vprintf(*this, fmt, ap);
}

/* Wrapper for `pdf_new_output_processor()`.  */
FZ_FUNCTION PdfProcessor Output::new_output_processor(int ahxencode)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_output_processor()\n";
	}
	auto ret = mupdf::mpdf_new_output_processor(*this, ahxencode);
	return ret;
}

/* Wrapper for `pdf_print_crypt()`.  */
FZ_FUNCTION void Output::print_crypt(const PdfCrypt& crypt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_print_crypt()\n";
	}
	mupdf::mpdf_print_crypt(*this, crypt);
}

/* Wrapper for `pdf_print_encrypted_obj()`.  */
FZ_FUNCTION void Output::print_encrypted_obj(const PdfObj& obj, int tight, int ascii, const PdfCrypt& crypt, int num, int gen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_print_encrypted_obj()\n";
	}
	mupdf::mpdf_print_encrypted_obj(*this, obj, tight, ascii, crypt, num, gen);
}

/* Wrapper for `pdf_print_font()`.  */
FZ_FUNCTION void Output::print_font(const PdfFontDesc& fontdesc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_print_font()\n";
	}
	mupdf::mpdf_print_font(*this, fontdesc);
}

/* Wrapper for `pdf_print_obj()`.  */
FZ_FUNCTION void Output::print_obj(const PdfObj& obj, int tight, int ascii)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_print_obj()\n";
	}
	mupdf::mpdf_print_obj(*this, obj, tight, ascii);
}

/* Wrapper for `pdf_write_digest()`.  */
FZ_FUNCTION void Output::write_digest(const PdfObj& byte_range, const PdfObj& field, size_t digest_offset, size_t digest_length, const PdfPkcs7Signer& signer)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_write_digest()\n";
	}
	mupdf::mpdf_write_digest(*this, byte_range, field, digest_offset, digest_length, signer);
}

FZ_FUNCTION Output::Output(fz_output* internal)
: m_internal(internal)
{
}

FZ_FUNCTION Output::~Output()
{
	mupdf::drop_output(m_internal);
}

/** Custom method. */
FZ_FUNCTION long long Output::m_internal_value()
{
	return (uintptr_t) m_internal;
}

/* Implementation of methods for `Output2`, virtual_fnptrs wrapper for `fz_output`). */


FZ_FUNCTION Output2::Output2()
{

	m_internal = mupdf::new_output(0 /*bufsize*/, this /*state*/, nullptr /*write*/, nullptr /*close*/, nullptr /*drop*/);
	
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Output2::Output2(); this=" << this << "\n";
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Output2::Output2(): m_internal=" << m_internal << "\n";
		Output2* self = (Output2*) m_internal;
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Output2::Output2(): self=" << self << "\n";
	}
}
/* Static callback, calls self->write(). */
static void Output2_s_write(fz_context *arg_0, void *arg_1, const void *arg_2, size_t arg_3)
{
	Output2* self = (Output2*) arg_1;
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Output2_s_write(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->write(arg_2, arg_3);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->seek(). */
static void Output2_s_seek(fz_context *arg_0, void *arg_1, int64_t arg_2, int arg_3)
{
	Output2* self = (Output2*) arg_1;
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Output2_s_seek(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->seek(arg_2, arg_3);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->tell(). */
static int64_t Output2_s_tell(fz_context *arg_0, void *arg_1)
{
	Output2* self = (Output2*) arg_1;
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Output2_s_tell(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->tell();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->close(). */
static void Output2_s_close(fz_context *arg_0, void *arg_1)
{
	Output2* self = (Output2*) arg_1;
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Output2_s_close(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->close();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->drop(). */
static void Output2_s_drop(fz_context *arg_0, void *arg_1)
{
	Output2* self = (Output2*) arg_1;
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Output2_s_drop(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->drop();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->as_stream(). */
static fz_stream * Output2_s_as_stream(fz_context *arg_0, void *arg_1)
{
	Output2* self = (Output2*) arg_1;
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Output2_s_as_stream(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->as_stream();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->truncate(). */
static void Output2_s_truncate(fz_context *arg_0, void *arg_1)
{
	Output2* self = (Output2*) arg_1;
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": Output2_s_truncate(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->truncate();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
FZ_FUNCTION void Output2::use_virtual_write( bool use)
{
	m_internal->write = (use) ? Output2_s_write : nullptr;
}
FZ_FUNCTION void Output2::use_virtual_seek( bool use)
{
	m_internal->seek = (use) ? Output2_s_seek : nullptr;
}
FZ_FUNCTION void Output2::use_virtual_tell( bool use)
{
	m_internal->tell = (use) ? Output2_s_tell : nullptr;
}
FZ_FUNCTION void Output2::use_virtual_close( bool use)
{
	m_internal->close = (use) ? Output2_s_close : nullptr;
}
FZ_FUNCTION void Output2::use_virtual_drop( bool use)
{
	m_internal->drop = (use) ? Output2_s_drop : nullptr;
}
FZ_FUNCTION void Output2::use_virtual_as_stream( bool use)
{
	m_internal->as_stream = (use) ? Output2_s_as_stream : nullptr;
}
FZ_FUNCTION void Output2::use_virtual_truncate( bool use)
{
	m_internal->truncate = (use) ? Output2_s_truncate : nullptr;
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Output2::write(const void *arg_2, unsigned long arg_3)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Output2::write().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Output2::seek(long long arg_2, int arg_3)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Output2::seek().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION long long Output2::tell()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Output2::tell().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Output2::close()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Output2::close().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Output2::drop()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Output2::drop().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION struct fz_stream * Output2::as_stream()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Output2::as_stream().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void Output2::truncate()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn Output2::truncate().");
}

/* Implementation of methods for Overprint (wrapper for fz_overprint). */

FZ_FUNCTION Overprint::Overprint(fz_overprint* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long Overprint::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Page (wrapper for fz_page). */

static RefsCheck<fz_page, Page> s_Page_refs_check(offsetof(fz_page, refs), 32);

/* Constructor using `fz_load_chapter_page()`. */
FZ_FUNCTION Page::Page(const Document& doc, int chapter, int page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_chapter_page()\n";
	}
	this->m_internal = mupdf::load_chapter_page(doc.m_internal, chapter, page);
	if (s_check_refs)
	{
		s_Page_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_load_page()`. */
FZ_FUNCTION Page::Page(const Document& doc, int number)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_page()\n";
	}
	this->m_internal = mupdf::load_page(doc.m_internal, number);
	if (s_check_refs)
	{
		s_Page_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_page_of_size()`. */
FZ_FUNCTION Page::Page(int size, const Document& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_page_of_size()\n";
	}
	this->m_internal = mupdf::new_page_of_size(size, doc.m_internal);
	if (s_check_refs)
	{
		s_Page_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom constructor. */
FZ_FUNCTION Page::Page(PdfPage& pdfpage)
{
	m_internal = mupdf::keep_page(&pdfpage.m_internal->super);
	if (s_check_refs)
	{
		s_Page_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Copy constructor using `fz_keep_page()`. */
FZ_FUNCTION Page::Page(const Page& rhs)
: m_internal(mupdf::keep_page(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_page(this->m_internal) and mupdf::keep_page(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_Page_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `fz_keep_page()` and `fz_drop_page()`. */
FZ_FUNCTION Page& Page::operator=(const Page& rhs)
{
	mupdf::drop_page(this->m_internal);
	mupdf::keep_page(rhs.m_internal);
	if (s_check_refs)
	{
		s_Page_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_Page_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/* Wrapper for `fz_bound_page()`.  */
FZ_FUNCTION Rect Page::bound_page()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::bound_page()\n";
	}
	auto ret = mupdf::mfz_bound_page(*this);
	if (s_check_refs)
	{
		s_Page_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_create_link()`.  */
FZ_FUNCTION Link Page::create_link(Rect& bbox, const char *uri)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::create_link()\n";
	}
	auto ret = mupdf::mfz_create_link(*this, bbox, uri);
	if (s_check_refs)
	{
		s_Page_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_load_links()`.  */
FZ_FUNCTION Link Page::load_links()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::load_links()\n";
	}
	auto ret = mupdf::mfz_load_links(*this);
	if (s_check_refs)
	{
		s_Page_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_buffer_from_page()`.  */
FZ_FUNCTION Buffer Page::new_buffer_from_page(StextOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_page()\n";
	}
	auto ret = mupdf::mfz_new_buffer_from_page(*this, options);
	if (s_check_refs)
	{
		s_Page_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_buffer_from_page_with_format()`.  */
FZ_FUNCTION Buffer Page::new_buffer_from_page_with_format(const char *format, const char *options, Matrix& transform, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_page_with_format()\n";
	}
	auto ret = mupdf::mfz_new_buffer_from_page_with_format(*this, format, options, transform, cookie);
	if (s_check_refs)
	{
		s_Page_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_display_list_from_page()`.  */
FZ_FUNCTION DisplayList Page::new_display_list_from_page()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_display_list_from_page()\n";
	}
	auto ret = mupdf::mfz_new_display_list_from_page(*this);
	if (s_check_refs)
	{
		s_Page_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_display_list_from_page_contents()`.  */
FZ_FUNCTION DisplayList Page::new_display_list_from_page_contents()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_display_list_from_page_contents()\n";
	}
	auto ret = mupdf::mfz_new_display_list_from_page_contents(*this);
	if (s_check_refs)
	{
		s_Page_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_pixmap_from_page()`.  */
FZ_FUNCTION Pixmap Page::new_pixmap_from_page(Matrix& ctm, const Colorspace& cs, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_page()\n";
	}
	auto ret = mupdf::mfz_new_pixmap_from_page(*this, ctm, cs, alpha);
	if (s_check_refs)
	{
		s_Page_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_pixmap_from_page_contents()`.  */
FZ_FUNCTION Pixmap Page::new_pixmap_from_page_contents(Matrix& ctm, const Colorspace& cs, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_page_contents()\n";
	}
	auto ret = mupdf::mfz_new_pixmap_from_page_contents(*this, ctm, cs, alpha);
	if (s_check_refs)
	{
		s_Page_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_pixmap_from_page_contents_with_separations()`.  */
FZ_FUNCTION Pixmap Page::new_pixmap_from_page_contents_with_separations(Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_page_contents_with_separations()\n";
	}
	auto ret = mupdf::mfz_new_pixmap_from_page_contents_with_separations(*this, ctm, cs, seps, alpha);
	if (s_check_refs)
	{
		s_Page_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_pixmap_from_page_with_separations()`.  */
FZ_FUNCTION Pixmap Page::new_pixmap_from_page_with_separations(Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_page_with_separations()\n";
	}
	auto ret = mupdf::mfz_new_pixmap_from_page_with_separations(*this, ctm, cs, seps, alpha);
	if (s_check_refs)
	{
		s_Page_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_page_presentation()`.
	
	This method has out-params. Python/C# wrappers look like:
		`page_presentation(fz_transition *transition)` => `(fz_transition *, float duration)`
	 */
FZ_FUNCTION Transition Page::page_presentation(Transition& transition, float *duration)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::page_presentation()\n";
	}
	auto ret = mupdf::mfz_page_presentation(*this, transition, duration);
	if (s_check_refs)
	{
		s_Page_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_page_separations()`.  */
FZ_FUNCTION Separations Page::page_separations()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::page_separations()\n";
	}
	auto ret = mupdf::mfz_page_separations(*this);
	if (s_check_refs)
	{
		s_Page_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_page_uses_overprint()`.  */
FZ_FUNCTION int Page::page_uses_overprint()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::page_uses_overprint()\n";
	}
	auto ret = mupdf::mfz_page_uses_overprint(*this);
	if (s_check_refs)
	{
		s_Page_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_run_page()`.  */
FZ_FUNCTION void Page::run_page(const Device& dev, Matrix& transform, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::run_page()\n";
	}
	mupdf::mfz_run_page(*this, dev, transform, cookie);
	if (s_check_refs)
	{
		s_Page_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_run_page_annots()`.  */
FZ_FUNCTION void Page::run_page_annots(const Device& dev, Matrix& transform, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::run_page_annots()\n";
	}
	mupdf::mfz_run_page_annots(*this, dev, transform, cookie);
	if (s_check_refs)
	{
		s_Page_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_run_page_contents()`.  */
FZ_FUNCTION void Page::run_page_contents(const Device& dev, Matrix& transform, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::run_page_contents()\n";
	}
	mupdf::mfz_run_page_contents(*this, dev, transform, cookie);
	if (s_check_refs)
	{
		s_Page_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_run_page_widgets()`.  */
FZ_FUNCTION void Page::run_page_widgets(const Device& dev, Matrix& transform, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::run_page_widgets()\n";
	}
	mupdf::mfz_run_page_widgets(*this, dev, transform, cookie);
	if (s_check_refs)
	{
		s_Page_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_page_from_fz_page()`.  */
FZ_FUNCTION PdfPage Page::page_from_fz_page()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_page_from_fz_page()\n";
	}
	auto ret = mupdf::mpdf_page_from_fz_page(*this);
	if (s_check_refs)
	{
		s_Page_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/** Custom method. */
FZ_FUNCTION std::vector<Quad> Page::search_page(const char* needle, int *hit_mark, int max)
{
	std::vector<Quad> ret(max);
	fz_quad* hit_bbox = ret[0].internal();
	int n = mupdf::search_page(m_internal, needle, hit_mark, hit_bbox, (int) ret.size());
	ret.resize(n);
	return ret;
}

/** Custom method. */
FZ_FUNCTION Document Page::doc()
{
	return Document( mupdf::keep_document( m_internal->doc));
}

FZ_FUNCTION Page::Page(fz_page* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_Page_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION Page::~Page()
{
	mupdf::drop_page(m_internal);
	if (s_check_refs)
	{
		s_Page_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long Page::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Path (wrapper for fz_path). */

static RefsCheck<fz_path, Path> s_Path_refs_check(0, 8);

/* Constructor using `fz_new_path()`. */
FZ_FUNCTION Path::Path()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_path()\n";
	}
	this->m_internal = mupdf::new_path();
	if (s_check_refs)
	{
		s_Path_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Copy constructor using `fz_keep_path()`. */
FZ_FUNCTION Path::Path(const Path& rhs)
: m_internal(mupdf::keep_path(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_path(this->m_internal) and mupdf::keep_path(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_Path_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `fz_keep_path()` and `fz_drop_path()`. */
FZ_FUNCTION Path& Path::operator=(const Path& rhs)
{
	mupdf::drop_path(this->m_internal);
	mupdf::keep_path(rhs.m_internal);
	if (s_check_refs)
	{
		s_Path_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_Path_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/* Wrapper for `fz_bound_path()`.  */
FZ_FUNCTION Rect Path::bound_path(const StrokeState& stroke, Matrix& ctm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::bound_path()\n";
	}
	auto ret = mupdf::mfz_bound_path(*this, stroke, ctm);
	if (s_check_refs)
	{
		s_Path_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_clone_path()`.  */
FZ_FUNCTION Path Path::clone_path()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clone_path()\n";
	}
	auto ret = mupdf::mfz_clone_path(*this);
	if (s_check_refs)
	{
		s_Path_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_closepath()`.  */
FZ_FUNCTION void Path::closepath()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::closepath()\n";
	}
	mupdf::mfz_closepath(*this);
	if (s_check_refs)
	{
		s_Path_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_currentpoint()`.  */
FZ_FUNCTION Point Path::currentpoint()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::currentpoint()\n";
	}
	auto ret = mupdf::mfz_currentpoint(*this);
	if (s_check_refs)
	{
		s_Path_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_curveto()`.  */
FZ_FUNCTION void Path::curveto(float x0, float y0, float x1, float y1, float x2, float y2)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::curveto()\n";
	}
	mupdf::mfz_curveto(*this, x0, y0, x1, y1, x2, y2);
	if (s_check_refs)
	{
		s_Path_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_curvetov()`.  */
FZ_FUNCTION void Path::curvetov(float x1, float y1, float x2, float y2)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::curvetov()\n";
	}
	mupdf::mfz_curvetov(*this, x1, y1, x2, y2);
	if (s_check_refs)
	{
		s_Path_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_curvetoy()`.  */
FZ_FUNCTION void Path::curvetoy(float x0, float y0, float x2, float y2)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::curvetoy()\n";
	}
	mupdf::mfz_curvetoy(*this, x0, y0, x2, y2);
	if (s_check_refs)
	{
		s_Path_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_lineto()`.  */
FZ_FUNCTION void Path::lineto(float x, float y)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::lineto()\n";
	}
	mupdf::mfz_lineto(*this, x, y);
	if (s_check_refs)
	{
		s_Path_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_moveto()`.  */
FZ_FUNCTION void Path::moveto(float x, float y)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::moveto()\n";
	}
	mupdf::mfz_moveto(*this, x, y);
	if (s_check_refs)
	{
		s_Path_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_packed_path_size()`.  */
FZ_FUNCTION int Path::packed_path_size()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::packed_path_size()\n";
	}
	auto ret = mupdf::mfz_packed_path_size(*this);
	if (s_check_refs)
	{
		s_Path_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_quadto()`.  */
FZ_FUNCTION void Path::quadto(float x0, float y0, float x1, float y1)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::quadto()\n";
	}
	mupdf::mfz_quadto(*this, x0, y0, x1, y1);
	if (s_check_refs)
	{
		s_Path_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_rectto()`.  */
FZ_FUNCTION void Path::rectto(float x0, float y0, float x1, float y1)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::rectto()\n";
	}
	mupdf::mfz_rectto(*this, x0, y0, x1, y1);
	if (s_check_refs)
	{
		s_Path_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_transform_path()`.  */
FZ_FUNCTION void Path::transform_path(Matrix& transform)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::transform_path()\n";
	}
	mupdf::mfz_transform_path(*this, transform);
	if (s_check_refs)
	{
		s_Path_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_trim_path()`.  */
FZ_FUNCTION void Path::trim_path()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::trim_path()\n";
	}
	mupdf::mfz_trim_path(*this);
	if (s_check_refs)
	{
		s_Path_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_walk_path()`.  */
FZ_FUNCTION void Path::walk_path(const PathWalker& walker, void *arg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::walk_path()\n";
	}
	mupdf::mfz_walk_path(*this, walker, arg);
	if (s_check_refs)
	{
		s_Path_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION Path::Path(fz_path* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_Path_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION Path::~Path()
{
	mupdf::drop_path(m_internal);
	if (s_check_refs)
	{
		s_Path_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long Path::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PathWalker (wrapper for fz_path_walker). */

FZ_FUNCTION PathWalker::PathWalker(fz_path_walker* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PathWalker::m_internal_value()
{
	return (uintptr_t) m_internal;
}

/* Implementation of methods for `PathWalker2`, virtual_fnptrs wrapper for `fz_path_walker`). */


FZ_FUNCTION PathWalker2::PathWalker2()
{

	
	m_internal = (fz_path_walker*) mupdf::calloc(1, sizeof(*m_internal) + sizeof(PathWalker2*));
	*(PathWalker2**) (m_internal + 1) = this;
	
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PathWalker2::PathWalker2(); this=" << this << "\n";
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PathWalker2::PathWalker2(): m_internal=" << m_internal << "\n";
		PathWalker2* self = *(PathWalker2**) ((fz_path_walker*) m_internal + 1);
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PathWalker2::PathWalker2(): self=" << self << "\n";
	}
}

FZ_FUNCTION PathWalker2::~PathWalker2()
{
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": ~PathWalker2(): this=" << this << "\n";
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": ~{classname}2(): m_internal=" << m_internal << "\n";
	}
	mupdf::free(m_internal);

}
/* Static callback, calls self->moveto(). */
static void PathWalker2_s_moveto(fz_context *arg_0, void *arg_1, float arg_2, float arg_3)
{
	PathWalker2* self = *(PathWalker2**) ((fz_path_walker*) arg_1 + 1);
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PathWalker2_s_moveto(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->moveto(arg_2, arg_3);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->lineto(). */
static void PathWalker2_s_lineto(fz_context *arg_0, void *arg_1, float arg_2, float arg_3)
{
	PathWalker2* self = *(PathWalker2**) ((fz_path_walker*) arg_1 + 1);
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PathWalker2_s_lineto(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->lineto(arg_2, arg_3);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->curveto(). */
static void PathWalker2_s_curveto(fz_context *arg_0, void *arg_1, float arg_2, float arg_3, float arg_4, float arg_5, float arg_6, float arg_7)
{
	PathWalker2* self = *(PathWalker2**) ((fz_path_walker*) arg_1 + 1);
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PathWalker2_s_curveto(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->curveto(arg_2, arg_3, arg_4, arg_5, arg_6, arg_7);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->closepath(). */
static void PathWalker2_s_closepath(fz_context *arg_0, void *arg_1)
{
	PathWalker2* self = *(PathWalker2**) ((fz_path_walker*) arg_1 + 1);
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PathWalker2_s_closepath(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->closepath();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->quadto(). */
static void PathWalker2_s_quadto(fz_context *arg_0, void *arg_1, float arg_2, float arg_3, float arg_4, float arg_5)
{
	PathWalker2* self = *(PathWalker2**) ((fz_path_walker*) arg_1 + 1);
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PathWalker2_s_quadto(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->quadto(arg_2, arg_3, arg_4, arg_5);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->curvetov(). */
static void PathWalker2_s_curvetov(fz_context *arg_0, void *arg_1, float arg_2, float arg_3, float arg_4, float arg_5)
{
	PathWalker2* self = *(PathWalker2**) ((fz_path_walker*) arg_1 + 1);
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PathWalker2_s_curvetov(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->curvetov(arg_2, arg_3, arg_4, arg_5);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->curvetoy(). */
static void PathWalker2_s_curvetoy(fz_context *arg_0, void *arg_1, float arg_2, float arg_3, float arg_4, float arg_5)
{
	PathWalker2* self = *(PathWalker2**) ((fz_path_walker*) arg_1 + 1);
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PathWalker2_s_curvetoy(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->curvetoy(arg_2, arg_3, arg_4, arg_5);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->rectto(). */
static void PathWalker2_s_rectto(fz_context *arg_0, void *arg_1, float arg_2, float arg_3, float arg_4, float arg_5)
{
	PathWalker2* self = *(PathWalker2**) ((fz_path_walker*) arg_1 + 1);
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PathWalker2_s_rectto(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->rectto(arg_2, arg_3, arg_4, arg_5);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
FZ_FUNCTION void PathWalker2::use_virtual_moveto( bool use)
{
	m_internal->moveto = (use) ? PathWalker2_s_moveto : nullptr;
}
FZ_FUNCTION void PathWalker2::use_virtual_lineto( bool use)
{
	m_internal->lineto = (use) ? PathWalker2_s_lineto : nullptr;
}
FZ_FUNCTION void PathWalker2::use_virtual_curveto( bool use)
{
	m_internal->curveto = (use) ? PathWalker2_s_curveto : nullptr;
}
FZ_FUNCTION void PathWalker2::use_virtual_closepath( bool use)
{
	m_internal->closepath = (use) ? PathWalker2_s_closepath : nullptr;
}
FZ_FUNCTION void PathWalker2::use_virtual_quadto( bool use)
{
	m_internal->quadto = (use) ? PathWalker2_s_quadto : nullptr;
}
FZ_FUNCTION void PathWalker2::use_virtual_curvetov( bool use)
{
	m_internal->curvetov = (use) ? PathWalker2_s_curvetov : nullptr;
}
FZ_FUNCTION void PathWalker2::use_virtual_curvetoy( bool use)
{
	m_internal->curvetoy = (use) ? PathWalker2_s_curvetoy : nullptr;
}
FZ_FUNCTION void PathWalker2::use_virtual_rectto( bool use)
{
	m_internal->rectto = (use) ? PathWalker2_s_rectto : nullptr;
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PathWalker2::moveto(float arg_2, float arg_3)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PathWalker2::moveto().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PathWalker2::lineto(float arg_2, float arg_3)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PathWalker2::lineto().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PathWalker2::curveto(float arg_2, float arg_3, float arg_4, float arg_5, float arg_6, float arg_7)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PathWalker2::curveto().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PathWalker2::closepath()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PathWalker2::closepath().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PathWalker2::quadto(float arg_2, float arg_3, float arg_4, float arg_5)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PathWalker2::quadto().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PathWalker2::curvetov(float arg_2, float arg_3, float arg_4, float arg_5)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PathWalker2::curvetov().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PathWalker2::curvetoy(float arg_2, float arg_3, float arg_4, float arg_5)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PathWalker2::curvetoy().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PathWalker2::rectto(float arg_2, float arg_3, float arg_4, float arg_5)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PathWalker2::rectto().");
}

/* Implementation of methods for PclOptions (wrapper for fz_pcl_options). */

/* Constructor using `fz_parse_pcl_options()`. */
FZ_FUNCTION PclOptions::PclOptions(const PclOptions& opts, const char *args)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::parse_pcl_options()\n";
	}
	this->m_internal = mupdf::parse_pcl_options(opts.m_internal, args);
}

/* Wrapper for `fz_pcl_preset()`.  */
FZ_FUNCTION void PclOptions::pcl_preset(const char *preset)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pcl_preset()\n";
	}
	mupdf::mfz_pcl_preset(*this, preset);
}

FZ_FUNCTION PclOptions::PclOptions(fz_pcl_options* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PclOptions::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PclmOptions (wrapper for fz_pclm_options). */

/* Constructor using `fz_parse_pclm_options()`. */
FZ_FUNCTION PclmOptions::PclmOptions(const PclmOptions& opts, const char *args)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::parse_pclm_options()\n";
	}
	this->m_internal = mupdf::parse_pclm_options(opts.m_internal, args);
}

/** Custom constructor. */
FZ_FUNCTION PclmOptions::PclmOptions(const char *args)
{
	mupdf::parse_pclm_options(m_internal, args);
}

FZ_FUNCTION PclmOptions::PclmOptions(fz_pclm_options* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PclmOptions::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfAlertEvent (wrapper for pdf_alert_event). */

FZ_FUNCTION PdfAlertEvent::PdfAlertEvent(pdf_alert_event* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfAlertEvent::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfAnnot (wrapper for pdf_annot). */

static RefsCheck<pdf_annot, PdfAnnot> s_PdfAnnot_refs_check(0, 32);

/** Copy constructor using `pdf_keep_annot()`. */
FZ_FUNCTION PdfAnnot::PdfAnnot(const PdfAnnot& rhs)
: m_internal(mupdf::ppdf_keep_annot(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_annot(this->m_internal) and mupdf::ppdf_keep_annot(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `pdf_keep_annot()` and `pdf_drop_annot()`. */
FZ_FUNCTION PdfAnnot& PdfAnnot::operator=(const PdfAnnot& rhs)
{
	mupdf::ppdf_drop_annot(this->m_internal);
	mupdf::ppdf_keep_annot(rhs.m_internal);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/* Wrapper for `pdf_add_annot_ink_list_stroke()`.  */
FZ_FUNCTION void PdfAnnot::add_annot_ink_list_stroke()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_annot_ink_list_stroke()\n";
	}
	mupdf::mpdf_add_annot_ink_list_stroke(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_add_annot_ink_list_stroke_vertex()`.  */
FZ_FUNCTION void PdfAnnot::add_annot_ink_list_stroke_vertex(Point& p)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_annot_ink_list_stroke_vertex()\n";
	}
	mupdf::mpdf_add_annot_ink_list_stroke_vertex(*this, p);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_add_annot_quad_point()`.  */
FZ_FUNCTION void PdfAnnot::add_annot_quad_point(Quad& quad)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_annot_quad_point()\n";
	}
	mupdf::mpdf_add_annot_quad_point(*this, quad);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_add_annot_vertex()`.  */
FZ_FUNCTION void PdfAnnot::add_annot_vertex(Point& p)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_annot_vertex()\n";
	}
	mupdf::mpdf_add_annot_vertex(*this, p);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_annot_MK_BC()`.
	
	This method has out-params. Python/C# wrappers look like:
		`annot_MK_BC(float color[4])` => int n
	 */
FZ_FUNCTION void PdfAnnot::annot_MK_BC(int *n, float color[4])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_MK_BC()\n";
	}
	mupdf::mpdf_annot_MK_BC(*this, n, color);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_annot_MK_BC_rgb()`.  */
FZ_FUNCTION int PdfAnnot::annot_MK_BC_rgb(float rgb[3])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_MK_BC_rgb()\n";
	}
	auto ret = mupdf::mpdf_annot_MK_BC_rgb(*this, rgb);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_MK_BG()`.
	
	This method has out-params. Python/C# wrappers look like:
		`annot_MK_BG(float color[4])` => int n
	 */
FZ_FUNCTION void PdfAnnot::annot_MK_BG(int *n, float color[4])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_MK_BG()\n";
	}
	mupdf::mpdf_annot_MK_BG(*this, n, color);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_annot_MK_BG_rgb()`.  */
FZ_FUNCTION int PdfAnnot::annot_MK_BG_rgb(float rgb[3])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_MK_BG_rgb()\n";
	}
	auto ret = mupdf::mpdf_annot_MK_BG_rgb(*this, rgb);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_active()`.  */
FZ_FUNCTION int PdfAnnot::annot_active()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_active()\n";
	}
	auto ret = mupdf::mpdf_annot_active(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_ap()`.  */
FZ_FUNCTION PdfObj PdfAnnot::annot_ap()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_ap()\n";
	}
	auto ret = mupdf::mpdf_annot_ap(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_author()`.  */
FZ_FUNCTION const char *PdfAnnot::annot_author()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_author()\n";
	}
	auto ret = mupdf::mpdf_annot_author(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_border()`.  */
FZ_FUNCTION float PdfAnnot::annot_border()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_border()\n";
	}
	auto ret = mupdf::mpdf_annot_border(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_color()`.
	
	This method has out-params. Python/C# wrappers look like:
		`annot_color(float color[4])` => int n
	 */
FZ_FUNCTION void PdfAnnot::annot_color(int *n, float color[4])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_color()\n";
	}
	mupdf::mpdf_annot_color(*this, n, color);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_annot_contents()`.  */
FZ_FUNCTION const char *PdfAnnot::annot_contents()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_contents()\n";
	}
	auto ret = mupdf::mpdf_annot_contents(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_creation_date()`.  */
FZ_FUNCTION int64_t PdfAnnot::annot_creation_date()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_creation_date()\n";
	}
	auto ret = mupdf::mpdf_annot_creation_date(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_default_appearance()`.
	
	This method has out-params. Python/C# wrappers look like:
		`annot_default_appearance(float color[4])` => `(const char *font, float size, int n)`
	 */
FZ_FUNCTION void PdfAnnot::annot_default_appearance(const char **font, float *size, int *n, float color[4])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_default_appearance()\n";
	}
	mupdf::mpdf_annot_default_appearance(*this, font, size, n, color);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_annot_ensure_local_xref()`.  */
FZ_FUNCTION void PdfAnnot::annot_ensure_local_xref()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_ensure_local_xref()\n";
	}
	mupdf::mpdf_annot_ensure_local_xref(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_annot_event_blur()`.  */
FZ_FUNCTION void PdfAnnot::annot_event_blur()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_event_blur()\n";
	}
	mupdf::mpdf_annot_event_blur(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_annot_event_down()`.  */
FZ_FUNCTION void PdfAnnot::annot_event_down()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_event_down()\n";
	}
	mupdf::mpdf_annot_event_down(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_annot_event_enter()`.  */
FZ_FUNCTION void PdfAnnot::annot_event_enter()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_event_enter()\n";
	}
	mupdf::mpdf_annot_event_enter(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_annot_event_exit()`.  */
FZ_FUNCTION void PdfAnnot::annot_event_exit()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_event_exit()\n";
	}
	mupdf::mpdf_annot_event_exit(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_annot_event_focus()`.  */
FZ_FUNCTION void PdfAnnot::annot_event_focus()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_event_focus()\n";
	}
	mupdf::mpdf_annot_event_focus(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_annot_event_page_close()`.  */
FZ_FUNCTION void PdfAnnot::annot_event_page_close()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_event_page_close()\n";
	}
	mupdf::mpdf_annot_event_page_close(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_annot_event_page_invisible()`.  */
FZ_FUNCTION void PdfAnnot::annot_event_page_invisible()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_event_page_invisible()\n";
	}
	mupdf::mpdf_annot_event_page_invisible(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_annot_event_page_open()`.  */
FZ_FUNCTION void PdfAnnot::annot_event_page_open()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_event_page_open()\n";
	}
	mupdf::mpdf_annot_event_page_open(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_annot_event_page_visible()`.  */
FZ_FUNCTION void PdfAnnot::annot_event_page_visible()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_event_page_visible()\n";
	}
	mupdf::mpdf_annot_event_page_visible(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_annot_event_up()`.  */
FZ_FUNCTION void PdfAnnot::annot_event_up()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_event_up()\n";
	}
	mupdf::mpdf_annot_event_up(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_annot_field_flags()`.  */
FZ_FUNCTION int PdfAnnot::annot_field_flags()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_field_flags()\n";
	}
	auto ret = mupdf::mpdf_annot_field_flags(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_field_label()`.  */
FZ_FUNCTION const char *PdfAnnot::annot_field_label()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_field_label()\n";
	}
	auto ret = mupdf::mpdf_annot_field_label(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_field_value()`.  */
FZ_FUNCTION const char *PdfAnnot::annot_field_value()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_field_value()\n";
	}
	auto ret = mupdf::mpdf_annot_field_value(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_flags()`.  */
FZ_FUNCTION int PdfAnnot::annot_flags()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_flags()\n";
	}
	auto ret = mupdf::mpdf_annot_flags(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_has_author()`.  */
FZ_FUNCTION int PdfAnnot::annot_has_author()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_has_author()\n";
	}
	auto ret = mupdf::mpdf_annot_has_author(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_has_icon_name()`.  */
FZ_FUNCTION int PdfAnnot::annot_has_icon_name()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_has_icon_name()\n";
	}
	auto ret = mupdf::mpdf_annot_has_icon_name(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_has_ink_list()`.  */
FZ_FUNCTION int PdfAnnot::annot_has_ink_list()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_has_ink_list()\n";
	}
	auto ret = mupdf::mpdf_annot_has_ink_list(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_has_interior_color()`.  */
FZ_FUNCTION int PdfAnnot::annot_has_interior_color()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_has_interior_color()\n";
	}
	auto ret = mupdf::mpdf_annot_has_interior_color(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_has_line()`.  */
FZ_FUNCTION int PdfAnnot::annot_has_line()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_has_line()\n";
	}
	auto ret = mupdf::mpdf_annot_has_line(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_has_line_ending_styles()`.  */
FZ_FUNCTION int PdfAnnot::annot_has_line_ending_styles()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_has_line_ending_styles()\n";
	}
	auto ret = mupdf::mpdf_annot_has_line_ending_styles(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_has_open()`.  */
FZ_FUNCTION int PdfAnnot::annot_has_open()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_has_open()\n";
	}
	auto ret = mupdf::mpdf_annot_has_open(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_has_quad_points()`.  */
FZ_FUNCTION int PdfAnnot::annot_has_quad_points()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_has_quad_points()\n";
	}
	auto ret = mupdf::mpdf_annot_has_quad_points(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_has_vertices()`.  */
FZ_FUNCTION int PdfAnnot::annot_has_vertices()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_has_vertices()\n";
	}
	auto ret = mupdf::mpdf_annot_has_vertices(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_hot()`.  */
FZ_FUNCTION int PdfAnnot::annot_hot()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_hot()\n";
	}
	auto ret = mupdf::mpdf_annot_hot(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_icon_name()`.  */
FZ_FUNCTION const char *PdfAnnot::annot_icon_name()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_icon_name()\n";
	}
	auto ret = mupdf::mpdf_annot_icon_name(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_ink_list_count()`.  */
FZ_FUNCTION int PdfAnnot::annot_ink_list_count()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_ink_list_count()\n";
	}
	auto ret = mupdf::mpdf_annot_ink_list_count(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_ink_list_stroke_count()`.  */
FZ_FUNCTION int PdfAnnot::annot_ink_list_stroke_count(int i)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_ink_list_stroke_count()\n";
	}
	auto ret = mupdf::mpdf_annot_ink_list_stroke_count(*this, i);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_ink_list_stroke_vertex()`.  */
FZ_FUNCTION Point PdfAnnot::annot_ink_list_stroke_vertex(int i, int k)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_ink_list_stroke_vertex()\n";
	}
	auto ret = mupdf::mpdf_annot_ink_list_stroke_vertex(*this, i, k);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_interior_color()`.
	
	This method has out-params. Python/C# wrappers look like:
		`annot_interior_color(float color[4])` => int n
	 */
FZ_FUNCTION void PdfAnnot::annot_interior_color(int *n, float color[4])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_interior_color()\n";
	}
	mupdf::mpdf_annot_interior_color(*this, n, color);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_annot_is_open()`.  */
FZ_FUNCTION int PdfAnnot::annot_is_open()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_is_open()\n";
	}
	auto ret = mupdf::mpdf_annot_is_open(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_line()`.  */
FZ_FUNCTION void PdfAnnot::annot_line(Point& a, Point& b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_line()\n";
	}
	mupdf::mpdf_annot_line(*this, a, b);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_annot_line_end_style()`.  */
FZ_FUNCTION enum pdf_line_ending PdfAnnot::annot_line_end_style()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_line_end_style()\n";
	}
	auto ret = mupdf::mpdf_annot_line_end_style(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_line_ending_styles()`.
	
	This method has out-params. Python/C# wrappers look like:
		`annot_line_ending_styles()` => `(enum pdf_line_ending start_style, enum pdf_line_ending end_style)`
	 */
FZ_FUNCTION void PdfAnnot::annot_line_ending_styles(enum pdf_line_ending *start_style, enum pdf_line_ending *end_style)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_line_ending_styles()\n";
	}
	mupdf::mpdf_annot_line_ending_styles(*this, start_style, end_style);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_annot_line_start_style()`.  */
FZ_FUNCTION enum pdf_line_ending PdfAnnot::annot_line_start_style()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_line_start_style()\n";
	}
	auto ret = mupdf::mpdf_annot_line_start_style(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_modification_date()`.  */
FZ_FUNCTION int64_t PdfAnnot::annot_modification_date()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_modification_date()\n";
	}
	auto ret = mupdf::mpdf_annot_modification_date(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_needs_resynthesis()`.  */
FZ_FUNCTION int PdfAnnot::annot_needs_resynthesis()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_needs_resynthesis()\n";
	}
	auto ret = mupdf::mpdf_annot_needs_resynthesis(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_obj()`.  */
FZ_FUNCTION PdfObj PdfAnnot::annot_obj()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_obj()\n";
	}
	auto ret = mupdf::mpdf_annot_obj(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_opacity()`.  */
FZ_FUNCTION float PdfAnnot::annot_opacity()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_opacity()\n";
	}
	auto ret = mupdf::mpdf_annot_opacity(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_page()`.  */
FZ_FUNCTION PdfPage PdfAnnot::annot_page()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_page()\n";
	}
	auto ret = mupdf::mpdf_annot_page(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_pop_and_discard_local_xref()`.  */
FZ_FUNCTION void PdfAnnot::annot_pop_and_discard_local_xref()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_pop_and_discard_local_xref()\n";
	}
	mupdf::mpdf_annot_pop_and_discard_local_xref(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_annot_pop_local_xref()`.  */
FZ_FUNCTION void PdfAnnot::annot_pop_local_xref()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_pop_local_xref()\n";
	}
	mupdf::mpdf_annot_pop_local_xref(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_annot_popup()`.  */
FZ_FUNCTION Rect PdfAnnot::annot_popup()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_popup()\n";
	}
	auto ret = mupdf::mpdf_annot_popup(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_push_local_xref()`.  */
FZ_FUNCTION void PdfAnnot::annot_push_local_xref()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_push_local_xref()\n";
	}
	mupdf::mpdf_annot_push_local_xref(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_annot_quad_point()`.  */
FZ_FUNCTION Quad PdfAnnot::annot_quad_point(int i)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_quad_point()\n";
	}
	auto ret = mupdf::mpdf_annot_quad_point(*this, i);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_quad_point_count()`.  */
FZ_FUNCTION int PdfAnnot::annot_quad_point_count()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_quad_point_count()\n";
	}
	auto ret = mupdf::mpdf_annot_quad_point_count(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_quadding()`.  */
FZ_FUNCTION int PdfAnnot::annot_quadding()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_quadding()\n";
	}
	auto ret = mupdf::mpdf_annot_quadding(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_rect()`.  */
FZ_FUNCTION Rect PdfAnnot::annot_rect()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_rect()\n";
	}
	auto ret = mupdf::mpdf_annot_rect(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_request_resynthesis()`.  */
FZ_FUNCTION void PdfAnnot::annot_request_resynthesis()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_request_resynthesis()\n";
	}
	mupdf::mpdf_annot_request_resynthesis(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_annot_transform()`.  */
FZ_FUNCTION Matrix PdfAnnot::annot_transform()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_transform()\n";
	}
	auto ret = mupdf::mpdf_annot_transform(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_type()`.  */
FZ_FUNCTION enum pdf_annot_type PdfAnnot::annot_type()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_type()\n";
	}
	auto ret = mupdf::mpdf_annot_type(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_vertex()`.  */
FZ_FUNCTION Point PdfAnnot::annot_vertex(int i)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_vertex()\n";
	}
	auto ret = mupdf::mpdf_annot_vertex(*this, i);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_vertex_count()`.  */
FZ_FUNCTION int PdfAnnot::annot_vertex_count()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_vertex_count()\n";
	}
	auto ret = mupdf::mpdf_annot_vertex_count(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_bound_annot()`.  */
FZ_FUNCTION Rect PdfAnnot::bound_annot()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_bound_annot()\n";
	}
	auto ret = mupdf::mpdf_bound_annot(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_bound_widget()`.  */
FZ_FUNCTION Rect PdfAnnot::bound_widget()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_bound_widget()\n";
	}
	auto ret = mupdf::mpdf_bound_widget(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_choice_widget_is_multiselect()`.  */
FZ_FUNCTION int PdfAnnot::choice_widget_is_multiselect()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_choice_widget_is_multiselect()\n";
	}
	auto ret = mupdf::mpdf_choice_widget_is_multiselect(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_choice_widget_options()`.  */
FZ_FUNCTION int PdfAnnot::choice_widget_options(int exportval, const char *opts[])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_choice_widget_options()\n";
	}
	auto ret = mupdf::mpdf_choice_widget_options(*this, exportval, opts);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_choice_widget_set_value()`.  */
FZ_FUNCTION void PdfAnnot::choice_widget_set_value(int n, const char *opts[])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_choice_widget_set_value()\n";
	}
	mupdf::mpdf_choice_widget_set_value(*this, n, opts);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_choice_widget_value()`.  */
FZ_FUNCTION int PdfAnnot::choice_widget_value(const char *opts[])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_choice_widget_value()\n";
	}
	auto ret = mupdf::mpdf_choice_widget_value(*this, opts);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_clear_annot_ink_list()`.  */
FZ_FUNCTION void PdfAnnot::clear_annot_ink_list()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_clear_annot_ink_list()\n";
	}
	mupdf::mpdf_clear_annot_ink_list(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_clear_annot_quad_points()`.  */
FZ_FUNCTION void PdfAnnot::clear_annot_quad_points()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_clear_annot_quad_points()\n";
	}
	mupdf::mpdf_clear_annot_quad_points(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_clear_annot_vertices()`.  */
FZ_FUNCTION void PdfAnnot::clear_annot_vertices()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_clear_annot_vertices()\n";
	}
	mupdf::mpdf_clear_annot_vertices(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_clear_signature()`.  */
FZ_FUNCTION void PdfAnnot::clear_signature()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_clear_signature()\n";
	}
	mupdf::mpdf_clear_signature(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_dirty_annot()`.  */
FZ_FUNCTION void PdfAnnot::dirty_annot()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dirty_annot()\n";
	}
	mupdf::mpdf_dirty_annot(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_edit_text_field_value()`.
	
	This method has out-params. Python/C# wrappers look like:
		`edit_text_field_value(const char *value, const char *change)` => `(int, int selStart, int selEnd, char *newvalue)`
	 */
FZ_FUNCTION int PdfAnnot::edit_text_field_value(const char *value, const char *change, int *selStart, int *selEnd, char **newvalue)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_edit_text_field_value()\n";
	}
	auto ret = mupdf::mpdf_edit_text_field_value(*this, value, change, selStart, selEnd, newvalue);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_get_widget_editing_state()`.  */
FZ_FUNCTION int PdfAnnot::get_widget_editing_state()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_get_widget_editing_state()\n";
	}
	auto ret = mupdf::mpdf_get_widget_editing_state(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_new_display_list_from_annot()`.  */
FZ_FUNCTION DisplayList PdfAnnot::new_display_list_from_annot()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_display_list_from_annot()\n";
	}
	auto ret = mupdf::mpdf_new_display_list_from_annot(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_new_pixmap_from_annot()`.  */
FZ_FUNCTION Pixmap PdfAnnot::new_pixmap_from_annot(Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_pixmap_from_annot()\n";
	}
	auto ret = mupdf::mpdf_new_pixmap_from_annot(*this, ctm, cs, seps, alpha);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_next_annot()`.  */
FZ_FUNCTION PdfAnnot PdfAnnot::next_annot()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_next_annot()\n";
	}
	auto ret = mupdf::mpdf_next_annot(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_next_widget()`.  */
FZ_FUNCTION PdfAnnot PdfAnnot::next_widget()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_next_widget()\n";
	}
	auto ret = mupdf::mpdf_next_widget(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_run_annot()`.  */
FZ_FUNCTION void PdfAnnot::run_annot(const Device& dev, Matrix& ctm, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_run_annot()\n";
	}
	mupdf::mpdf_run_annot(*this, dev, ctm, cookie);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_active()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_active(int active)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_active()\n";
	}
	mupdf::mpdf_set_annot_active(*this, active);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_appearance()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_appearance(const char *appearance, const char *state, Matrix& ctm, Rect& bbox, const PdfObj& res, const Buffer& contents)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_appearance()\n";
	}
	mupdf::mpdf_set_annot_appearance(*this, appearance, state, ctm, bbox, res, contents);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_appearance_from_display_list()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_appearance_from_display_list(const char *appearance, const char *state, Matrix& ctm, const DisplayList& list)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_appearance_from_display_list()\n";
	}
	mupdf::mpdf_set_annot_appearance_from_display_list(*this, appearance, state, ctm, list);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_author()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_author(const char *author)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_author()\n";
	}
	mupdf::mpdf_set_annot_author(*this, author);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_border()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_border(float width)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_border()\n";
	}
	mupdf::mpdf_set_annot_border(*this, width);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_color()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_color(int n, const float *color)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_color()\n";
	}
	mupdf::mpdf_set_annot_color(*this, n, color);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_contents()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_contents(const char *text)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_contents()\n";
	}
	mupdf::mpdf_set_annot_contents(*this, text);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_creation_date()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_creation_date(int64_t time)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_creation_date()\n";
	}
	mupdf::mpdf_set_annot_creation_date(*this, time);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_default_appearance()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_default_appearance(const char *font, float size, int n, const float *color)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_default_appearance()\n";
	}
	mupdf::mpdf_set_annot_default_appearance(*this, font, size, n, color);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_flags()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_flags(int flags)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_flags()\n";
	}
	mupdf::mpdf_set_annot_flags(*this, flags);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_hot()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_hot(int hot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_hot()\n";
	}
	mupdf::mpdf_set_annot_hot(*this, hot);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_icon_name()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_icon_name(const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_icon_name()\n";
	}
	mupdf::mpdf_set_annot_icon_name(*this, name);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_ink_list()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_ink_list(int n, const int *count, Point& v)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_ink_list()\n";
	}
	mupdf::mpdf_set_annot_ink_list(*this, n, count, v);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_interior_color()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_interior_color(int n, const float *color)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_interior_color()\n";
	}
	mupdf::mpdf_set_annot_interior_color(*this, n, color);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_is_open()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_is_open(int is_open)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_is_open()\n";
	}
	mupdf::mpdf_set_annot_is_open(*this, is_open);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_language()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_language(fz_text_language lang)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_language()\n";
	}
	mupdf::mpdf_set_annot_language(*this, lang);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_line()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_line(Point& a, Point& b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_line()\n";
	}
	mupdf::mpdf_set_annot_line(*this, a, b);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_line_end_style()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_line_end_style(enum pdf_line_ending e)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_line_end_style()\n";
	}
	mupdf::mpdf_set_annot_line_end_style(*this, e);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_line_ending_styles()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_line_ending_styles(enum pdf_line_ending start_style, enum pdf_line_ending end_style)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_line_ending_styles()\n";
	}
	mupdf::mpdf_set_annot_line_ending_styles(*this, start_style, end_style);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_line_start_style()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_line_start_style(enum pdf_line_ending s)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_line_start_style()\n";
	}
	mupdf::mpdf_set_annot_line_start_style(*this, s);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_modification_date()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_modification_date(int64_t time)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_modification_date()\n";
	}
	mupdf::mpdf_set_annot_modification_date(*this, time);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_opacity()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_opacity(float opacity)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_opacity()\n";
	}
	mupdf::mpdf_set_annot_opacity(*this, opacity);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_popup()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_popup(Rect& rect)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_popup()\n";
	}
	mupdf::mpdf_set_annot_popup(*this, rect);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_quad_points()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_quad_points(int n, Quad& qv)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_quad_points()\n";
	}
	mupdf::mpdf_set_annot_quad_points(*this, n, qv);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_quadding()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_quadding(int q)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_quadding()\n";
	}
	mupdf::mpdf_set_annot_quadding(*this, q);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_rect()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_rect(Rect& rect)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_rect()\n";
	}
	mupdf::mpdf_set_annot_rect(*this, rect);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_resynthesised()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_resynthesised()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_resynthesised()\n";
	}
	mupdf::mpdf_set_annot_resynthesised(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_vertex()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_vertex(int i, Point& p)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_vertex()\n";
	}
	mupdf::mpdf_set_annot_vertex(*this, i, p);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_vertices()`.  */
FZ_FUNCTION void PdfAnnot::set_annot_vertices(int n, Point& v)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_vertices()\n";
	}
	mupdf::mpdf_set_annot_vertices(*this, n, v);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_choice_field_value()`.  */
FZ_FUNCTION int PdfAnnot::set_choice_field_value(const char *value)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_choice_field_value()\n";
	}
	auto ret = mupdf::mpdf_set_choice_field_value(*this, value);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_set_text_field_value()`.  */
FZ_FUNCTION int PdfAnnot::set_text_field_value(const char *value)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_text_field_value()\n";
	}
	auto ret = mupdf::mpdf_set_text_field_value(*this, value);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_set_widget_editing_state()`.  */
FZ_FUNCTION void PdfAnnot::set_widget_editing_state(int editing)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_widget_editing_state()\n";
	}
	mupdf::mpdf_set_widget_editing_state(*this, editing);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_sign_signature()`.  */
FZ_FUNCTION void PdfAnnot::sign_signature(const PdfPkcs7Signer& signer, int appearance_flags, const Image& graphic, const char *reason, const char *location)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_sign_signature()\n";
	}
	mupdf::mpdf_sign_signature(*this, signer, appearance_flags, graphic, reason, location);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_sign_signature_with_appearance()`.  */
FZ_FUNCTION void PdfAnnot::sign_signature_with_appearance(const PdfPkcs7Signer& signer, int64_t date, const DisplayList& disp_list)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_sign_signature_with_appearance()\n";
	}
	mupdf::mpdf_sign_signature_with_appearance(*this, signer, date, disp_list);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_text_widget_format()`.  */
FZ_FUNCTION int PdfAnnot::text_widget_format()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_text_widget_format()\n";
	}
	auto ret = mupdf::mpdf_text_widget_format(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_text_widget_max_len()`.  */
FZ_FUNCTION int PdfAnnot::text_widget_max_len()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_text_widget_max_len()\n";
	}
	auto ret = mupdf::mpdf_text_widget_max_len(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_toggle_widget()`.  */
FZ_FUNCTION int PdfAnnot::toggle_widget()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_toggle_widget()\n";
	}
	auto ret = mupdf::mpdf_toggle_widget(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_update_annot()`.  */
FZ_FUNCTION int PdfAnnot::update_annot()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_update_annot()\n";
	}
	auto ret = mupdf::mpdf_update_annot(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_update_widget()`.  */
FZ_FUNCTION int PdfAnnot::update_widget()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_update_widget()\n";
	}
	auto ret = mupdf::mpdf_update_widget(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_validate_signature()`.  */
FZ_FUNCTION int PdfAnnot::validate_signature()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_validate_signature()\n";
	}
	auto ret = mupdf::mpdf_validate_signature(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_widget_is_readonly()`.  */
FZ_FUNCTION int PdfAnnot::widget_is_readonly()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_widget_is_readonly()\n";
	}
	auto ret = mupdf::mpdf_widget_is_readonly(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_widget_is_signed()`.  */
FZ_FUNCTION int PdfAnnot::widget_is_signed()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_widget_is_signed()\n";
	}
	auto ret = mupdf::mpdf_widget_is_signed(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_widget_type()`.  */
FZ_FUNCTION enum pdf_widget_type PdfAnnot::widget_type()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_widget_type()\n";
	}
	auto ret = mupdf::mpdf_widget_type(*this);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

FZ_FUNCTION PdfAnnot::PdfAnnot(pdf_annot* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION PdfAnnot::~PdfAnnot()
{
	mupdf::ppdf_drop_annot(m_internal);
	if (s_check_refs)
	{
		s_PdfAnnot_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long PdfAnnot::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfCmap (wrapper for pdf_cmap). */

static RefsCheck<pdf_cmap, PdfCmap> s_PdfCmap_refs_check(offsetof(pdf_cmap, storable.refs), 32);

/* Constructor using `pdf_new_cmap()`. */
FZ_FUNCTION PdfCmap::PdfCmap()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_cmap()\n";
	}
	this->m_internal = mupdf::ppdf_new_cmap();
	if (s_check_refs)
	{
		s_PdfCmap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `pdf_new_identity_cmap()`. */
FZ_FUNCTION PdfCmap::PdfCmap(int wmode, int bytes)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_identity_cmap()\n";
	}
	this->m_internal = mupdf::ppdf_new_identity_cmap(wmode, bytes);
	if (s_check_refs)
	{
		s_PdfCmap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Copy constructor using `pdf_keep_cmap()`. */
FZ_FUNCTION PdfCmap::PdfCmap(const PdfCmap& rhs)
: m_internal(mupdf::ppdf_keep_cmap(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_cmap(this->m_internal) and mupdf::ppdf_keep_cmap(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_PdfCmap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `pdf_keep_cmap()` and `pdf_drop_cmap()`. */
FZ_FUNCTION PdfCmap& PdfCmap::operator=(const PdfCmap& rhs)
{
	mupdf::ppdf_drop_cmap(this->m_internal);
	mupdf::ppdf_keep_cmap(rhs.m_internal);
	if (s_check_refs)
	{
		s_PdfCmap_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_PdfCmap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/* Wrapper for `pdf_add_codespace()`.  */
FZ_FUNCTION void PdfCmap::add_codespace(unsigned int low, unsigned int high, size_t n)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_codespace()\n";
	}
	mupdf::mpdf_add_codespace(*this, low, high, n);
	if (s_check_refs)
	{
		s_PdfCmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_cmap_size()`.  */
FZ_FUNCTION size_t PdfCmap::cmap_size()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_cmap_size()\n";
	}
	auto ret = mupdf::mpdf_cmap_size(*this);
	if (s_check_refs)
	{
		s_PdfCmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_cmap_wmode()`.  */
FZ_FUNCTION int PdfCmap::cmap_wmode()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_cmap_wmode()\n";
	}
	auto ret = mupdf::mpdf_cmap_wmode(*this);
	if (s_check_refs)
	{
		s_PdfCmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_decode_cmap()`.
	
	This method has out-params. Python/C# wrappers look like:
		`decode_cmap(unsigned char *s, unsigned char *e)` => `(int, unsigned int cpt)`
	 */
FZ_FUNCTION int PdfCmap::decode_cmap(unsigned char *s, unsigned char *e, unsigned int *cpt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_decode_cmap()\n";
	}
	auto ret = mupdf::mpdf_decode_cmap(*this, s, e, cpt);
	if (s_check_refs)
	{
		s_PdfCmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_lookup_cmap()`.  */
FZ_FUNCTION int PdfCmap::lookup_cmap(unsigned int cpt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lookup_cmap()\n";
	}
	auto ret = mupdf::mpdf_lookup_cmap(*this, cpt);
	if (s_check_refs)
	{
		s_PdfCmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_lookup_cmap_full()`.
	
	This method has out-params. Python/C# wrappers look like:
		`lookup_cmap_full(unsigned int cpt)` => `(int, int out)`
	 */
FZ_FUNCTION int PdfCmap::lookup_cmap_full(unsigned int cpt, int *out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lookup_cmap_full()\n";
	}
	auto ret = mupdf::mpdf_lookup_cmap_full(*this, cpt, out);
	if (s_check_refs)
	{
		s_PdfCmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_map_one_to_many()`.
	
	This method has out-params. Python/C# wrappers look like:
		`map_one_to_many(unsigned int one, size_t len)` => int many
	 */
FZ_FUNCTION void PdfCmap::map_one_to_many(unsigned int one, int *many, size_t len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_map_one_to_many()\n";
	}
	mupdf::mpdf_map_one_to_many(*this, one, many, len);
	if (s_check_refs)
	{
		s_PdfCmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_map_range_to_range()`.  */
FZ_FUNCTION void PdfCmap::map_range_to_range(unsigned int srclo, unsigned int srchi, int dstlo)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_map_range_to_range()\n";
	}
	mupdf::mpdf_map_range_to_range(*this, srclo, srchi, dstlo);
	if (s_check_refs)
	{
		s_PdfCmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_cmap_wmode()`.  */
FZ_FUNCTION void PdfCmap::set_cmap_wmode(int wmode)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_cmap_wmode()\n";
	}
	mupdf::mpdf_set_cmap_wmode(*this, wmode);
	if (s_check_refs)
	{
		s_PdfCmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_usecmap()`.  */
FZ_FUNCTION void PdfCmap::set_usecmap(const PdfCmap& usecmap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_usecmap()\n";
	}
	mupdf::mpdf_set_usecmap(*this, usecmap);
	if (s_check_refs)
	{
		s_PdfCmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_sort_cmap()`.  */
FZ_FUNCTION void PdfCmap::sort_cmap()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_sort_cmap()\n";
	}
	mupdf::mpdf_sort_cmap(*this);
	if (s_check_refs)
	{
		s_PdfCmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION PdfCmap::PdfCmap(pdf_cmap* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_PdfCmap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION PdfCmap::~PdfCmap()
{
	mupdf::ppdf_drop_cmap(m_internal);
	if (s_check_refs)
	{
		s_PdfCmap_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long PdfCmap::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfCrypt (wrapper for pdf_crypt). */

/* Constructor using `pdf_new_crypt()`. */
FZ_FUNCTION PdfCrypt::PdfCrypt(const PdfObj& enc, const PdfObj& id)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_crypt()\n";
	}
	this->m_internal = mupdf::ppdf_new_crypt(enc.m_internal, id.m_internal);
}

/* Constructor using `pdf_new_encrypt()`. */
FZ_FUNCTION PdfCrypt::PdfCrypt(const char *opwd_utf8, const char *upwd_utf8, const PdfObj& id, int permissions, int algorithm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_encrypt()\n";
	}
	this->m_internal = mupdf::ppdf_new_encrypt(opwd_utf8, upwd_utf8, id.m_internal, permissions, algorithm);
}

/* Wrapper for `pdf_crypt_encrypt_metadata()`.  */
FZ_FUNCTION int PdfCrypt::crypt_encrypt_metadata()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_crypt_encrypt_metadata()\n";
	}
	auto ret = mupdf::mpdf_crypt_encrypt_metadata(*this);
	return ret;
}

/* Wrapper for `pdf_crypt_key()`.  */
FZ_FUNCTION unsigned char *PdfCrypt::crypt_key()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_crypt_key()\n";
	}
	auto ret = mupdf::mpdf_crypt_key(*this);
	return ret;
}

/* Wrapper for `pdf_crypt_length()`.  */
FZ_FUNCTION int PdfCrypt::crypt_length()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_crypt_length()\n";
	}
	auto ret = mupdf::mpdf_crypt_length(*this);
	return ret;
}

/* Wrapper for `pdf_crypt_method()`.  */
FZ_FUNCTION char *PdfCrypt::crypt_method()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_crypt_method()\n";
	}
	auto ret = mupdf::mpdf_crypt_method(*this);
	return ret;
}

/* Wrapper for `pdf_crypt_obj()`.  */
FZ_FUNCTION void PdfCrypt::crypt_obj(const PdfObj& obj, int num, int gen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_crypt_obj()\n";
	}
	mupdf::mpdf_crypt_obj(*this, obj, num, gen);
}

/* Wrapper for `pdf_crypt_owner_encryption()`.  */
FZ_FUNCTION unsigned char *PdfCrypt::crypt_owner_encryption()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_crypt_owner_encryption()\n";
	}
	auto ret = mupdf::mpdf_crypt_owner_encryption(*this);
	return ret;
}

/* Wrapper for `pdf_crypt_owner_password()`.  */
FZ_FUNCTION unsigned char *PdfCrypt::crypt_owner_password()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_crypt_owner_password()\n";
	}
	auto ret = mupdf::mpdf_crypt_owner_password(*this);
	return ret;
}

/* Wrapper for `pdf_crypt_permissions()`.  */
FZ_FUNCTION int PdfCrypt::crypt_permissions()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_crypt_permissions()\n";
	}
	auto ret = mupdf::mpdf_crypt_permissions(*this);
	return ret;
}

/* Wrapper for `pdf_crypt_permissions_encryption()`.  */
FZ_FUNCTION unsigned char *PdfCrypt::crypt_permissions_encryption()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_crypt_permissions_encryption()\n";
	}
	auto ret = mupdf::mpdf_crypt_permissions_encryption(*this);
	return ret;
}

/* Wrapper for `pdf_crypt_revision()`.  */
FZ_FUNCTION int PdfCrypt::crypt_revision()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_crypt_revision()\n";
	}
	auto ret = mupdf::mpdf_crypt_revision(*this);
	return ret;
}

/* Wrapper for `pdf_crypt_user_encryption()`.  */
FZ_FUNCTION unsigned char *PdfCrypt::crypt_user_encryption()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_crypt_user_encryption()\n";
	}
	auto ret = mupdf::mpdf_crypt_user_encryption(*this);
	return ret;
}

/* Wrapper for `pdf_crypt_user_password()`.  */
FZ_FUNCTION unsigned char *PdfCrypt::crypt_user_password()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_crypt_user_password()\n";
	}
	auto ret = mupdf::mpdf_crypt_user_password(*this);
	return ret;
}

/* Wrapper for `pdf_crypt_version()`.  */
FZ_FUNCTION int PdfCrypt::crypt_version()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_crypt_version()\n";
	}
	auto ret = mupdf::mpdf_crypt_version(*this);
	return ret;
}

/* Wrapper for `pdf_encrypt_data()`.  */
FZ_FUNCTION void PdfCrypt::encrypt_data(int num, int gen, void (*fmt_str_out)(fz_context *, void *, const unsigned char *, size_t ), void *arg, const unsigned char *s, size_t n)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_encrypt_data()\n";
	}
	mupdf::mpdf_encrypt_data(*this, num, gen, fmt_str_out, arg, s, n);
}

/* Wrapper for `pdf_encrypted_len()`.  */
FZ_FUNCTION size_t PdfCrypt::encrypted_len(int num, int gen, size_t len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_encrypted_len()\n";
	}
	auto ret = mupdf::mpdf_encrypted_len(*this, num, gen, len);
	return ret;
}

FZ_FUNCTION PdfCrypt::PdfCrypt(pdf_crypt* internal)
: m_internal(internal)
{
}

FZ_FUNCTION PdfCrypt::~PdfCrypt()
{
	mupdf::ppdf_drop_crypt(m_internal);
}

/** Custom method. */
FZ_FUNCTION long long PdfCrypt::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfCsi (wrapper for pdf_csi). */

FZ_FUNCTION PdfCsi::PdfCsi(pdf_csi* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfCsi::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfDocEvent (wrapper for pdf_doc_event). */

/* Wrapper for `pdf_access_exec_menu_item_event()`.  */
FZ_FUNCTION const char *PdfDocEvent::access_exec_menu_item_event()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_access_exec_menu_item_event()\n";
	}
	auto ret = mupdf::mpdf_access_exec_menu_item_event(*this);
	return ret;
}

FZ_FUNCTION PdfDocEvent::PdfDocEvent(pdf_doc_event* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfDocEvent::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfDocument (wrapper for pdf_document). */

static RefsCheck<pdf_document, PdfDocument> s_PdfDocument_refs_check(offsetof(pdf_document, super.refs), 32);

/* Constructor using `pdf_create_document()`. */
FZ_FUNCTION PdfDocument::PdfDocument()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_create_document()\n";
	}
	this->m_internal = mupdf::ppdf_create_document();
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `pdf_document_from_fz_document()`. */
FZ_FUNCTION PdfDocument::PdfDocument(const Document& ptr)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_document_from_fz_document()\n";
	}
	this->m_internal = mupdf::ppdf_document_from_fz_document(ptr.m_internal);
	mupdf::ppdf_keep_document(this->m_internal);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `pdf_open_document()`. */
FZ_FUNCTION PdfDocument::PdfDocument(const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_open_document()\n";
	}
	this->m_internal = mupdf::ppdf_open_document(filename);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `pdf_open_document_with_stream()`. */
FZ_FUNCTION PdfDocument::PdfDocument(const Stream& file)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_open_document_with_stream()\n";
	}
	this->m_internal = mupdf::ppdf_open_document_with_stream(file.m_internal);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Copy constructor using `pdf_keep_document()`. */
FZ_FUNCTION PdfDocument::PdfDocument(const PdfDocument& rhs)
: m_internal(mupdf::ppdf_keep_document(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_document(this->m_internal) and mupdf::ppdf_keep_document(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `pdf_keep_document()` and `pdf_drop_document()`. */
FZ_FUNCTION PdfDocument& PdfDocument::operator=(const PdfDocument& rhs)
{
	mupdf::ppdf_drop_document(this->m_internal);
	mupdf::ppdf_keep_document(rhs.m_internal);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/* Wrapper for `pdf_add_cid_font()`.  */
FZ_FUNCTION PdfObj PdfDocument::add_cid_font(const Font& font)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_cid_font()\n";
	}
	auto ret = mupdf::mpdf_add_cid_font(*this, font);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_add_cjk_font()`.  */
FZ_FUNCTION PdfObj PdfDocument::add_cjk_font(const Font& font, int script, int wmode, int serif)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_cjk_font()\n";
	}
	auto ret = mupdf::mpdf_add_cjk_font(*this, font, script, wmode, serif);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_add_embedded_file()`.  */
FZ_FUNCTION PdfObj PdfDocument::add_embedded_file(const char *filename, const char *mimetype, const Buffer& contents)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_embedded_file()\n";
	}
	auto ret = mupdf::mpdf_add_embedded_file(*this, filename, mimetype, contents);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_add_image()`.  */
FZ_FUNCTION PdfObj PdfDocument::add_image(const Image& image)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_image()\n";
	}
	auto ret = mupdf::mpdf_add_image(*this, image);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_add_journal_fragment()`.  */
FZ_FUNCTION void PdfDocument::add_journal_fragment(int parent, const PdfObj& copy, const Buffer& copy_stream, int newobj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_journal_fragment()\n";
	}
	mupdf::mpdf_add_journal_fragment(*this, parent, copy, copy_stream, newobj);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_add_new_array()`.  */
FZ_FUNCTION PdfObj PdfDocument::add_new_array(int initial)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_new_array()\n";
	}
	auto ret = mupdf::mpdf_add_new_array(*this, initial);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_add_new_dict()`.  */
FZ_FUNCTION PdfObj PdfDocument::add_new_dict(int initial)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_new_dict()\n";
	}
	auto ret = mupdf::mpdf_add_new_dict(*this, initial);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_add_object()`.  */
FZ_FUNCTION PdfObj PdfDocument::add_object(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_object()\n";
	}
	auto ret = mupdf::mpdf_add_object(*this, obj);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_add_page()`.  */
FZ_FUNCTION PdfObj PdfDocument::add_page(Rect& mediabox, int rotate, const PdfObj& resources, const Buffer& contents)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_page()\n";
	}
	auto ret = mupdf::mpdf_add_page(*this, mediabox, rotate, resources, contents);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_add_simple_font()`.  */
FZ_FUNCTION PdfObj PdfDocument::add_simple_font(const Font& font, int encoding)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_simple_font()\n";
	}
	auto ret = mupdf::mpdf_add_simple_font(*this, font, encoding);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_add_stream()`.  */
FZ_FUNCTION PdfObj PdfDocument::add_stream(const Buffer& buf, const PdfObj& obj, int compressed)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_stream()\n";
	}
	auto ret = mupdf::mpdf_add_stream(*this, buf, obj, compressed);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_add_substitute_font()`.  */
FZ_FUNCTION PdfObj PdfDocument::add_substitute_font(const Font& font)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_substitute_font()\n";
	}
	auto ret = mupdf::mpdf_add_substitute_font(*this, font);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_annot_field_event_keystroke()`.  */
FZ_FUNCTION int PdfDocument::annot_field_event_keystroke(const PdfAnnot& annot, const PdfKeystrokeEvent& evt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_annot_field_event_keystroke()\n";
	}
	auto ret = mupdf::mpdf_annot_field_event_keystroke(*this, annot, evt);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_authenticate_password()`.  */
FZ_FUNCTION int PdfDocument::authenticate_password(const char *pw)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_authenticate_password()\n";
	}
	auto ret = mupdf::mpdf_authenticate_password(*this, pw);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_begin_implicit_operation()`.  */
FZ_FUNCTION void PdfDocument::begin_implicit_operation()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_begin_implicit_operation()\n";
	}
	mupdf::mpdf_begin_implicit_operation(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_begin_operation()`.  */
FZ_FUNCTION void PdfDocument::begin_operation(const char *operation)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_begin_operation()\n";
	}
	mupdf::mpdf_begin_operation(*this, operation);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_calculate_form()`.  */
FZ_FUNCTION void PdfDocument::calculate_form()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_calculate_form()\n";
	}
	mupdf::mpdf_calculate_form(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_can_be_saved_incrementally()`.  */
FZ_FUNCTION int PdfDocument::can_be_saved_incrementally()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_can_be_saved_incrementally()\n";
	}
	auto ret = mupdf::mpdf_can_be_saved_incrementally(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_can_redo()`.  */
FZ_FUNCTION int PdfDocument::can_redo()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_can_redo()\n";
	}
	auto ret = mupdf::mpdf_can_redo(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_can_undo()`.  */
FZ_FUNCTION int PdfDocument::can_undo()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_can_undo()\n";
	}
	auto ret = mupdf::mpdf_can_undo(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_clear_xref()`.  */
FZ_FUNCTION void PdfDocument::clear_xref()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_clear_xref()\n";
	}
	mupdf::mpdf_clear_xref(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_clear_xref_to_mark()`.  */
FZ_FUNCTION void PdfDocument::clear_xref_to_mark()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_clear_xref_to_mark()\n";
	}
	mupdf::mpdf_clear_xref_to_mark(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_count_layer_config_ui()`.  */
FZ_FUNCTION int PdfDocument::count_layer_config_ui()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_count_layer_config_ui()\n";
	}
	auto ret = mupdf::mpdf_count_layer_config_ui(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_count_layer_configs()`.  */
FZ_FUNCTION int PdfDocument::count_layer_configs()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_count_layer_configs()\n";
	}
	auto ret = mupdf::mpdf_count_layer_configs(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_count_objects()`.  */
FZ_FUNCTION int PdfDocument::count_objects()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_count_objects()\n";
	}
	auto ret = mupdf::mpdf_count_objects(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_count_pages()`.  */
FZ_FUNCTION int PdfDocument::count_pages()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_count_pages()\n";
	}
	auto ret = mupdf::mpdf_count_pages(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_count_signatures()`.  */
FZ_FUNCTION int PdfDocument::count_signatures()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_count_signatures()\n";
	}
	auto ret = mupdf::mpdf_count_signatures(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_count_unsaved_versions()`.  */
FZ_FUNCTION int PdfDocument::count_unsaved_versions()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_count_unsaved_versions()\n";
	}
	auto ret = mupdf::mpdf_count_unsaved_versions(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_count_versions()`.  */
FZ_FUNCTION int PdfDocument::count_versions()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_count_versions()\n";
	}
	auto ret = mupdf::mpdf_count_versions(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_create_field_name()`.  */
FZ_FUNCTION void PdfDocument::create_field_name(const char *prefix, char *buf, size_t len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_create_field_name()\n";
	}
	mupdf::mpdf_create_field_name(*this, prefix, buf, len);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_create_object()`.  */
FZ_FUNCTION int PdfDocument::create_object()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_create_object()\n";
	}
	auto ret = mupdf::mpdf_create_object(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_debug_doc_changes()`.  */
FZ_FUNCTION void PdfDocument::debug_doc_changes()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_debug_doc_changes()\n";
	}
	mupdf::mpdf_debug_doc_changes(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_delete_object()`.  */
FZ_FUNCTION void PdfDocument::delete_object(int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_delete_object()\n";
	}
	mupdf::mpdf_delete_object(*this, num);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_delete_page()`.  */
FZ_FUNCTION void PdfDocument::delete_page(int number)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_delete_page()\n";
	}
	mupdf::mpdf_delete_page(*this, number);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_delete_page_range()`.  */
FZ_FUNCTION void PdfDocument::delete_page_range(int start, int end)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_delete_page_range()\n";
	}
	mupdf::mpdf_delete_page_range(*this, start, end);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_deselect_layer_config_ui()`.  */
FZ_FUNCTION void PdfDocument::deselect_layer_config_ui(int ui)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_deselect_layer_config_ui()\n";
	}
	mupdf::mpdf_deselect_layer_config_ui(*this, ui);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_deserialise_journal()`.  */
FZ_FUNCTION void PdfDocument::deserialise_journal(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_deserialise_journal()\n";
	}
	mupdf::mpdf_deserialise_journal(*this, stm);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_disable_js()`.  */
FZ_FUNCTION void PdfDocument::disable_js()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_disable_js()\n";
	}
	mupdf::mpdf_disable_js(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_doc_was_linearized()`.  */
FZ_FUNCTION int PdfDocument::doc_was_linearized()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_doc_was_linearized()\n";
	}
	auto ret = mupdf::mpdf_doc_was_linearized(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_document_event_did_print()`.  */
FZ_FUNCTION void PdfDocument::document_event_did_print()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_document_event_did_print()\n";
	}
	mupdf::mpdf_document_event_did_print(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_document_event_did_save()`.  */
FZ_FUNCTION void PdfDocument::document_event_did_save()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_document_event_did_save()\n";
	}
	mupdf::mpdf_document_event_did_save(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_document_event_will_close()`.  */
FZ_FUNCTION void PdfDocument::document_event_will_close()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_document_event_will_close()\n";
	}
	mupdf::mpdf_document_event_will_close(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_document_event_will_print()`.  */
FZ_FUNCTION void PdfDocument::document_event_will_print()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_document_event_will_print()\n";
	}
	mupdf::mpdf_document_event_will_print(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_document_event_will_save()`.  */
FZ_FUNCTION void PdfDocument::document_event_will_save()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_document_event_will_save()\n";
	}
	mupdf::mpdf_document_event_will_save(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_document_output_intent()`.  */
FZ_FUNCTION Colorspace PdfDocument::document_output_intent()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_document_output_intent()\n";
	}
	auto ret = mupdf::mpdf_document_output_intent(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_document_permissions()`.  */
FZ_FUNCTION int PdfDocument::document_permissions()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_document_permissions()\n";
	}
	auto ret = mupdf::mpdf_document_permissions(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_empty_store()`.  */
FZ_FUNCTION void PdfDocument::empty_store()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_empty_store()\n";
	}
	mupdf::mpdf_empty_store(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_enable_journal()`.  */
FZ_FUNCTION void PdfDocument::enable_journal()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_enable_journal()\n";
	}
	mupdf::mpdf_enable_journal(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_enable_js()`.  */
FZ_FUNCTION void PdfDocument::enable_js()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_enable_js()\n";
	}
	mupdf::mpdf_enable_js(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_end_operation()`.  */
FZ_FUNCTION void PdfDocument::end_operation()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_end_operation()\n";
	}
	mupdf::mpdf_end_operation(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_ensure_solid_xref()`.  */
FZ_FUNCTION void PdfDocument::ensure_solid_xref(int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_ensure_solid_xref()\n";
	}
	mupdf::mpdf_ensure_solid_xref(*this, num);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_event_issue_alert()`.  */
FZ_FUNCTION void PdfDocument::event_issue_alert(const PdfAlertEvent& evt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_event_issue_alert()\n";
	}
	mupdf::mpdf_event_issue_alert(*this, evt);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_event_issue_exec_menu_item()`.  */
FZ_FUNCTION void PdfDocument::event_issue_exec_menu_item(const char *item)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_event_issue_exec_menu_item()\n";
	}
	mupdf::mpdf_event_issue_exec_menu_item(*this, item);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_event_issue_launch_url()`.  */
FZ_FUNCTION void PdfDocument::event_issue_launch_url(const char *url, int new_frame)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_event_issue_launch_url()\n";
	}
	mupdf::mpdf_event_issue_launch_url(*this, url, new_frame);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_event_issue_mail_doc()`.  */
FZ_FUNCTION void PdfDocument::event_issue_mail_doc(const PdfMailDocEvent& evt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_event_issue_mail_doc()\n";
	}
	mupdf::mpdf_event_issue_mail_doc(*this, evt);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_event_issue_print()`.  */
FZ_FUNCTION void PdfDocument::event_issue_print()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_event_issue_print()\n";
	}
	mupdf::mpdf_event_issue_print(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_field_event_calculate()`.  */
FZ_FUNCTION void PdfDocument::field_event_calculate(const PdfObj& field)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_event_calculate()\n";
	}
	mupdf::mpdf_field_event_calculate(*this, field);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_field_event_format()`.  */
FZ_FUNCTION char *PdfDocument::field_event_format(const PdfObj& field)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_event_format()\n";
	}
	auto ret = mupdf::mpdf_field_event_format(*this, field);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_field_event_keystroke()`.  */
FZ_FUNCTION int PdfDocument::field_event_keystroke(const PdfObj& field, const PdfKeystrokeEvent& evt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_event_keystroke()\n";
	}
	auto ret = mupdf::mpdf_field_event_keystroke(*this, field, evt);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_field_event_validate()`.
	
	This method has out-params. Python/C# wrappers look like:
		`field_event_validate(pdf_obj *field, const char *value)` => `(int, char *newvalue)`
	 */
FZ_FUNCTION int PdfDocument::field_event_validate(const PdfObj& field, const char *value, char **newvalue)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_event_validate()\n";
	}
	auto ret = mupdf::mpdf_field_event_validate(*this, field, value, newvalue);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_field_reset()`.  */
FZ_FUNCTION void PdfDocument::field_reset(const PdfObj& field)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_reset()\n";
	}
	mupdf::mpdf_field_reset(*this, field);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_filter_annot_contents()`.  */
FZ_FUNCTION void PdfDocument::filter_annot_contents(const PdfAnnot& annot, PdfFilterOptions& filter)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_filter_annot_contents()\n";
	}
	mupdf::mpdf_filter_annot_contents(*this, annot, filter);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_filter_page_contents()`.  */
FZ_FUNCTION void PdfDocument::filter_page_contents(const PdfPage& page, PdfFilterOptions& filter)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_filter_page_contents()\n";
	}
	mupdf::mpdf_filter_page_contents(*this, page, filter);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_find_font_resource()`.  */
FZ_FUNCTION PdfObj PdfDocument::find_font_resource(int type, int encoding, const Font& item, const PdfFontResourceKey& key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_find_font_resource()\n";
	}
	auto ret = mupdf::mpdf_find_font_resource(*this, type, encoding, item, key);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_find_version_for_obj()`.  */
FZ_FUNCTION int PdfDocument::find_version_for_obj(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_find_version_for_obj()\n";
	}
	auto ret = mupdf::mpdf_find_version_for_obj(*this, obj);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_forget_xref()`.  */
FZ_FUNCTION void PdfDocument::forget_xref()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_forget_xref()\n";
	}
	mupdf::mpdf_forget_xref(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_get_doc_event_callback_data()`.  */
FZ_FUNCTION void *PdfDocument::get_doc_event_callback_data()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_get_doc_event_callback_data()\n";
	}
	auto ret = mupdf::mpdf_get_doc_event_callback_data(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_graft_object()`.  */
FZ_FUNCTION PdfObj PdfDocument::graft_object(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_graft_object()\n";
	}
	auto ret = mupdf::mpdf_graft_object(*this, obj);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_graft_page()`.  */
FZ_FUNCTION void PdfDocument::graft_page(int page_to, const PdfDocument& src, int page_from)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_graft_page()\n";
	}
	mupdf::mpdf_graft_page(*this, page_to, src, page_from);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_has_permission()`.  */
FZ_FUNCTION int PdfDocument::has_permission(fz_permission p)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_has_permission()\n";
	}
	auto ret = mupdf::mpdf_has_permission(*this, p);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_has_unsaved_changes()`.  */
FZ_FUNCTION int PdfDocument::has_unsaved_changes()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_has_unsaved_changes()\n";
	}
	auto ret = mupdf::mpdf_has_unsaved_changes(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_has_unsaved_sigs()`.  */
FZ_FUNCTION int PdfDocument::has_unsaved_sigs()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_has_unsaved_sigs()\n";
	}
	auto ret = mupdf::mpdf_has_unsaved_sigs(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_insert_font_resource()`.  */
FZ_FUNCTION PdfObj PdfDocument::insert_font_resource(const PdfFontResourceKey& key, const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_insert_font_resource()\n";
	}
	auto ret = mupdf::mpdf_insert_font_resource(*this, key, obj);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_insert_page()`.  */
FZ_FUNCTION void PdfDocument::insert_page(int at, const PdfObj& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_insert_page()\n";
	}
	mupdf::mpdf_insert_page(*this, at, page);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_invalidate_xfa()`.  */
FZ_FUNCTION void PdfDocument::invalidate_xfa()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_invalidate_xfa()\n";
	}
	mupdf::mpdf_invalidate_xfa(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_is_local_object()`.  */
FZ_FUNCTION int PdfDocument::is_local_object(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_local_object()\n";
	}
	auto ret = mupdf::mpdf_is_local_object(*this, obj);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_is_ocg_hidden()`.  */
FZ_FUNCTION int PdfDocument::is_ocg_hidden(const PdfObj& rdb, const char *usage, const PdfObj& ocg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_ocg_hidden()\n";
	}
	auto ret = mupdf::mpdf_is_ocg_hidden(*this, rdb, usage, ocg);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_js_set_console()`.  */
FZ_FUNCTION void PdfDocument::js_set_console(const PdfJsConsole& console, void *user)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_js_set_console()\n";
	}
	mupdf::mpdf_js_set_console(*this, console, user);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_js_supported()`.  */
FZ_FUNCTION int PdfDocument::js_supported()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_js_supported()\n";
	}
	auto ret = mupdf::mpdf_js_supported(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_layer_config_info()`.  */
FZ_FUNCTION void PdfDocument::layer_config_info(int config_num, PdfLayerConfig& info)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_layer_config_info()\n";
	}
	mupdf::mpdf_layer_config_info(*this, config_num, info);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_layer_config_ui_info()`.  */
FZ_FUNCTION void PdfDocument::layer_config_ui_info(int ui, PdfLayerConfigUi& info)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_layer_config_ui_info()\n";
	}
	mupdf::mpdf_layer_config_ui_info(*this, ui, info);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_load_compressed_inline_image()`.  */
FZ_FUNCTION void PdfDocument::load_compressed_inline_image(const PdfObj& dict, int length, const Stream& cstm, int indexed, const CompressedImage& image)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_compressed_inline_image()\n";
	}
	mupdf::mpdf_load_compressed_inline_image(*this, dict, length, cstm, indexed, image);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_load_default_colorspaces()`.  */
FZ_FUNCTION DefaultColorspaces PdfDocument::load_default_colorspaces(const PdfPage& page)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_default_colorspaces()\n";
	}
	auto ret = mupdf::mpdf_load_default_colorspaces(*this, page);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_load_embedded_cmap()`.  */
FZ_FUNCTION PdfCmap PdfDocument::load_embedded_cmap(const PdfObj& ref)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_embedded_cmap()\n";
	}
	auto ret = mupdf::mpdf_load_embedded_cmap(*this, ref);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_load_image()`.  */
FZ_FUNCTION Image PdfDocument::load_image(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_image()\n";
	}
	auto ret = mupdf::mpdf_load_image(*this, obj);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_load_inline_image()`.  */
FZ_FUNCTION Image PdfDocument::load_inline_image(const PdfObj& rdb, const PdfObj& dict, const Stream& file)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_inline_image()\n";
	}
	auto ret = mupdf::mpdf_load_inline_image(*this, rdb, dict, file);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_load_journal()`.  */
FZ_FUNCTION void PdfDocument::load_journal(const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_journal()\n";
	}
	mupdf::mpdf_load_journal(*this, filename);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_load_link_annots()`.  */
FZ_FUNCTION Link PdfDocument::load_link_annots(const PdfObj& annots, int pagenum, Matrix& page_ctm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_link_annots()\n";
	}
	auto ret = mupdf::mpdf_load_link_annots(*this, annots, pagenum, page_ctm);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_load_name_tree()`.  */
FZ_FUNCTION PdfObj PdfDocument::load_name_tree(const PdfObj& which)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_name_tree()\n";
	}
	auto ret = mupdf::mpdf_load_name_tree(*this, which);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_load_object()`.  */
FZ_FUNCTION PdfObj PdfDocument::load_object(int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_object()\n";
	}
	auto ret = mupdf::mpdf_load_object(*this, num);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_load_outline()`.  */
FZ_FUNCTION Outline PdfDocument::load_outline()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_outline()\n";
	}
	auto ret = mupdf::mpdf_load_outline(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_load_page()`.  */
FZ_FUNCTION PdfPage PdfDocument::load_page(int number)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_page()\n";
	}
	auto ret = mupdf::mpdf_load_page(*this, number);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_load_page_tree()`.  */
FZ_FUNCTION void PdfDocument::load_page_tree()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_page_tree()\n";
	}
	mupdf::mpdf_load_page_tree(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_load_pattern()`.  */
FZ_FUNCTION PdfPattern PdfDocument::load_pattern(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_pattern()\n";
	}
	auto ret = mupdf::mpdf_load_pattern(*this, obj);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_load_raw_stream_number()`.  */
FZ_FUNCTION Buffer PdfDocument::load_raw_stream_number(int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_raw_stream_number()\n";
	}
	auto ret = mupdf::mpdf_load_raw_stream_number(*this, num);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_load_shading()`.  */
FZ_FUNCTION Shade PdfDocument::load_shading(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_shading()\n";
	}
	auto ret = mupdf::mpdf_load_shading(*this, obj);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_load_stream_number()`.  */
FZ_FUNCTION Buffer PdfDocument::load_stream_number(int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_stream_number()\n";
	}
	auto ret = mupdf::mpdf_load_stream_number(*this, num);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_load_to_unicode()`.
	
	This method has out-params. Python/C# wrappers look like:
		`load_to_unicode(pdf_font_desc *font, char *collection, pdf_obj *cmapstm)` => const char *strings
	 */
FZ_FUNCTION void PdfDocument::load_to_unicode(const PdfFontDesc& font, const char **strings, char *collection, const PdfObj& cmapstm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_to_unicode()\n";
	}
	mupdf::mpdf_load_to_unicode(*this, font, strings, collection, cmapstm);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_load_type3_glyphs()`.  */
FZ_FUNCTION void PdfDocument::load_type3_glyphs(const PdfFontDesc& fontdesc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_type3_glyphs()\n";
	}
	mupdf::mpdf_load_type3_glyphs(*this, fontdesc);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_load_unencrypted_object()`.  */
FZ_FUNCTION PdfObj PdfDocument::load_unencrypted_object(int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_unencrypted_object()\n";
	}
	auto ret = mupdf::mpdf_load_unencrypted_object(*this, num);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_lookup_anchor()`.
	
	This method has out-params. Python/C# wrappers look like:
		`lookup_anchor(const char *name)` => `(int, float xp, float yp)`
	 */
FZ_FUNCTION int PdfDocument::lookup_anchor(const char *name, float *xp, float *yp)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lookup_anchor()\n";
	}
	auto ret = mupdf::mpdf_lookup_anchor(*this, name, xp, yp);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_lookup_dest()`.  */
FZ_FUNCTION PdfObj PdfDocument::lookup_dest(const PdfObj& needle)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lookup_dest()\n";
	}
	auto ret = mupdf::mpdf_lookup_dest(*this, needle);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_lookup_metadata()`.  */
FZ_FUNCTION int PdfDocument::lookup_metadata(const char *key, char *ptr, int size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lookup_metadata()\n";
	}
	auto ret = mupdf::mpdf_lookup_metadata(*this, key, ptr, size);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_lookup_name()`.  */
FZ_FUNCTION PdfObj PdfDocument::lookup_name(const PdfObj& which, const PdfObj& needle)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lookup_name()\n";
	}
	auto ret = mupdf::mpdf_lookup_name(*this, which, needle);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_lookup_page_number()`.  */
FZ_FUNCTION int PdfDocument::lookup_page_number(const PdfObj& pageobj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lookup_page_number()\n";
	}
	auto ret = mupdf::mpdf_lookup_page_number(*this, pageobj);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_lookup_page_obj()`.  */
FZ_FUNCTION PdfObj PdfDocument::lookup_page_obj(int needle)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lookup_page_obj()\n";
	}
	auto ret = mupdf::mpdf_lookup_page_obj(*this, needle);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_mark_xref()`.  */
FZ_FUNCTION void PdfDocument::mark_xref()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_mark_xref()\n";
	}
	mupdf::mpdf_mark_xref(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_metadata()`.  */
FZ_FUNCTION PdfObj PdfDocument::metadata()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_metadata()\n";
	}
	auto ret = mupdf::mpdf_metadata(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_needs_password()`.  */
FZ_FUNCTION int PdfDocument::needs_password()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_needs_password()\n";
	}
	auto ret = mupdf::mpdf_needs_password(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_new_action_from_link()`.  */
FZ_FUNCTION PdfObj PdfDocument::new_action_from_link(const char *uri)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_action_from_link()\n";
	}
	auto ret = mupdf::mpdf_new_action_from_link(*this, uri);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_new_array()`.  */
FZ_FUNCTION PdfObj PdfDocument::new_array(int initialcap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_array()\n";
	}
	auto ret = mupdf::mpdf_new_array(*this, initialcap);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_new_date()`.  */
FZ_FUNCTION PdfObj PdfDocument::new_date(int64_t time)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_date()\n";
	}
	auto ret = mupdf::mpdf_new_date(*this, time);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_new_destination_from_link()`.  */
FZ_FUNCTION PdfObj PdfDocument::new_destination_from_link(const char *uri)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_destination_from_link()\n";
	}
	auto ret = mupdf::mpdf_new_destination_from_link(*this, uri);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_new_dict()`.  */
FZ_FUNCTION PdfObj PdfDocument::new_dict(int initialcap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_dict()\n";
	}
	auto ret = mupdf::mpdf_new_dict(*this, initialcap);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_new_filter_processor()`.  */
FZ_FUNCTION PdfProcessor PdfDocument::new_filter_processor(const PdfProcessor& chain, const PdfObj& old_res, const PdfObj& new_res, int struct_parents, Matrix& transform, PdfFilterOptions& filter)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_filter_processor()\n";
	}
	auto ret = mupdf::mpdf_new_filter_processor(*this, chain, old_res, new_res, struct_parents, transform, filter);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_new_graft_map()`.  */
FZ_FUNCTION PdfGraftMap PdfDocument::new_graft_map()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_graft_map()\n";
	}
	auto ret = mupdf::mpdf_new_graft_map(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_new_indirect()`.  */
FZ_FUNCTION PdfObj PdfDocument::new_indirect(int num, int gen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_indirect()\n";
	}
	auto ret = mupdf::mpdf_new_indirect(*this, num, gen);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_new_matrix()`.  */
FZ_FUNCTION PdfObj PdfDocument::new_matrix(Matrix& mtx)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_matrix()\n";
	}
	auto ret = mupdf::mpdf_new_matrix(*this, mtx);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_new_pdf_device()`.  */
FZ_FUNCTION Device PdfDocument::new_pdf_device(Matrix& topctm, const PdfObj& resources, const Buffer& contents)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_pdf_device()\n";
	}
	auto ret = mupdf::mpdf_new_pdf_device(*this, topctm, resources, contents);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_new_rect()`.  */
FZ_FUNCTION PdfObj PdfDocument::new_rect(Rect& rect)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_rect()\n";
	}
	auto ret = mupdf::mpdf_new_rect(*this, rect);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_new_xobject()`.  */
FZ_FUNCTION PdfObj PdfDocument::new_xobject(Rect& bbox, Matrix& matrix, const PdfObj& res, const Buffer& buffer)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_xobject()\n";
	}
	auto ret = mupdf::mpdf_new_xobject(*this, bbox, matrix, res, buffer);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_obj_num_is_stream()`.  */
FZ_FUNCTION int PdfDocument::obj_num_is_stream(int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_obj_num_is_stream()\n";
	}
	auto ret = mupdf::mpdf_obj_num_is_stream(*this, num);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_open_contents_stream()`.  */
FZ_FUNCTION Stream PdfDocument::open_contents_stream(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_open_contents_stream()\n";
	}
	auto ret = mupdf::mpdf_open_contents_stream(*this, obj);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_open_inline_stream()`.  */
FZ_FUNCTION Stream PdfDocument::open_inline_stream(const PdfObj& stmobj, int length, const Stream& chain, const CompressionParams& params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_open_inline_stream()\n";
	}
	auto ret = mupdf::mpdf_open_inline_stream(*this, stmobj, length, chain, params);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_open_raw_stream_number()`.  */
FZ_FUNCTION Stream PdfDocument::open_raw_stream_number(int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_open_raw_stream_number()\n";
	}
	auto ret = mupdf::mpdf_open_raw_stream_number(*this, num);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_open_stream_number()`.  */
FZ_FUNCTION Stream PdfDocument::open_stream_number(int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_open_stream_number()\n";
	}
	auto ret = mupdf::mpdf_open_stream_number(*this, num);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_open_stream_with_offset()`.  */
FZ_FUNCTION Stream PdfDocument::open_stream_with_offset(int num, const PdfObj& dict, int64_t stm_ofs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_open_stream_with_offset()\n";
	}
	auto ret = mupdf::mpdf_open_stream_with_offset(*this, num, dict, stm_ofs);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_page_write()`.
	
	This method has out-params. Python/C# wrappers look like:
		`page_write(fz_rect mediabox, pdf_obj **presources, fz_buffer **pcontents)` => `(fz_device *)`
	 */
FZ_FUNCTION Device PdfDocument::page_write(Rect& mediabox, PdfObj& presources, Buffer& pcontents)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_page_write()\n";
	}
	auto ret = mupdf::mpdf_page_write(*this, mediabox, presources, pcontents);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_parse_array()`.  */
FZ_FUNCTION PdfObj PdfDocument::parse_array(const Stream& f, const PdfLexbuf& buf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_parse_array()\n";
	}
	auto ret = mupdf::mpdf_parse_array(*this, f, buf);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_parse_dict()`.  */
FZ_FUNCTION PdfObj PdfDocument::parse_dict(const Stream& f, const PdfLexbuf& buf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_parse_dict()\n";
	}
	auto ret = mupdf::mpdf_parse_dict(*this, f, buf);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_parse_ind_obj()`.
	
	This method has out-params. Python/C# wrappers look like:
		`parse_ind_obj(fz_stream *f)` => `(pdf_obj *, int num, int gen, int64_t stm_ofs, int try_repair)`
	 */
FZ_FUNCTION PdfObj PdfDocument::parse_ind_obj(const Stream& f, int *num, int *gen, int64_t *stm_ofs, int *try_repair)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_parse_ind_obj()\n";
	}
	auto ret = mupdf::mpdf_parse_ind_obj(*this, f, num, gen, stm_ofs, try_repair);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_parse_journal_obj()`.
	
	This method has out-params. Python/C# wrappers look like:
		`parse_journal_obj(fz_stream *stm, fz_buffer **ostm)` => `(pdf_obj *, int onum, int newobj)`
	 */
FZ_FUNCTION PdfObj PdfDocument::parse_journal_obj(const Stream& stm, int *onum, Buffer& ostm, int *newobj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_parse_journal_obj()\n";
	}
	auto ret = mupdf::mpdf_parse_journal_obj(*this, stm, onum, ostm, newobj);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_parse_link_action()`.  */
FZ_FUNCTION char *PdfDocument::parse_link_action(const PdfObj& obj, int pagenum)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_parse_link_action()\n";
	}
	auto ret = mupdf::mpdf_parse_link_action(*this, obj, pagenum);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_parse_link_dest()`.  */
FZ_FUNCTION char *PdfDocument::parse_link_dest(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_parse_link_dest()\n";
	}
	auto ret = mupdf::mpdf_parse_link_dest(*this, obj);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_parse_stm_obj()`.  */
FZ_FUNCTION PdfObj PdfDocument::parse_stm_obj(const Stream& f, const PdfLexbuf& buf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_parse_stm_obj()\n";
	}
	auto ret = mupdf::mpdf_parse_stm_obj(*this, f, buf);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_progressive_advance()`.  */
FZ_FUNCTION PdfObj PdfDocument::progressive_advance(int pagenum)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_progressive_advance()\n";
	}
	auto ret = mupdf::mpdf_progressive_advance(*this, pagenum);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_purge_local_font_resources()`.  */
FZ_FUNCTION void PdfDocument::purge_local_font_resources()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_purge_local_font_resources()\n";
	}
	mupdf::mpdf_purge_local_font_resources(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_purge_locals_from_store()`.  */
FZ_FUNCTION void PdfDocument::purge_locals_from_store()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_purge_locals_from_store()\n";
	}
	mupdf::mpdf_purge_locals_from_store(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_read_journal()`.  */
FZ_FUNCTION void PdfDocument::read_journal(const Stream& stm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_read_journal()\n";
	}
	mupdf::mpdf_read_journal(*this, stm);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_redact_page()`.  */
FZ_FUNCTION int PdfDocument::redact_page(const PdfPage& page, PdfRedactOptions& opts)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_redact_page()\n";
	}
	auto ret = mupdf::mpdf_redact_page(*this, page, opts);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_redo()`.  */
FZ_FUNCTION void PdfDocument::redo()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_redo()\n";
	}
	mupdf::mpdf_redo(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_repair_obj()`.
	
	This method has out-params. Python/C# wrappers look like:
		`repair_obj(pdf_lexbuf *buf, pdf_obj **encrypt, pdf_obj **id, pdf_obj **page, pdf_obj **root)` => `(int, int64_t stmofsp, int stmlenp, int64_t tmpofs)`
	 */
FZ_FUNCTION int PdfDocument::repair_obj(const PdfLexbuf& buf, int64_t *stmofsp, int *stmlenp, PdfObj& encrypt, PdfObj& id, PdfObj& page, int64_t *tmpofs, PdfObj& root)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_repair_obj()\n";
	}
	auto ret = mupdf::mpdf_repair_obj(*this, buf, stmofsp, stmlenp, encrypt, id, page, tmpofs, root);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_repair_obj_stms()`.  */
FZ_FUNCTION void PdfDocument::repair_obj_stms()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_repair_obj_stms()\n";
	}
	mupdf::mpdf_repair_obj_stms(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_repair_trailer()`.  */
FZ_FUNCTION void PdfDocument::repair_trailer()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_repair_trailer()\n";
	}
	mupdf::mpdf_repair_trailer(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_repair_xref()`.  */
FZ_FUNCTION void PdfDocument::repair_xref()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_repair_xref()\n";
	}
	mupdf::mpdf_repair_xref(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_replace_xref()`.  */
FZ_FUNCTION void PdfDocument::replace_xref(const PdfXrefEntry& entries, int n)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_replace_xref()\n";
	}
	mupdf::mpdf_replace_xref(*this, entries, n);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_reset_form()`.  */
FZ_FUNCTION void PdfDocument::reset_form(const PdfObj& fields, int exclude)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_reset_form()\n";
	}
	mupdf::mpdf_reset_form(*this, fields, exclude);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_resolve_link()`.
	
	This method has out-params. Python/C# wrappers look like:
		`resolve_link(const char *uri)` => `(int, float xp, float yp)`
	 */
FZ_FUNCTION int PdfDocument::resolve_link(const char *uri, float *xp, float *yp)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_resolve_link()\n";
	}
	auto ret = mupdf::mpdf_resolve_link(*this, uri, xp, yp);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_run_glyph()`.  */
FZ_FUNCTION void PdfDocument::run_glyph(const PdfObj& resources, const Buffer& contents, const Device& dev, Matrix& ctm, void *gstate, const DefaultColorspaces& default_cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_run_glyph()\n";
	}
	mupdf::mpdf_run_glyph(*this, resources, contents, dev, ctm, gstate, default_cs);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_save_document()`.  */
FZ_FUNCTION void PdfDocument::save_document(const char *filename, PdfWriteOptions& opts)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_save_document()\n";
	}
	mupdf::mpdf_save_document(*this, filename, opts);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_save_journal()`.  */
FZ_FUNCTION void PdfDocument::save_journal(const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_save_journal()\n";
	}
	mupdf::mpdf_save_journal(*this, filename);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_save_snapshot()`.  */
FZ_FUNCTION void PdfDocument::save_snapshot(const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_save_snapshot()\n";
	}
	mupdf::mpdf_save_snapshot(*this, filename);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_select_layer_config()`.  */
FZ_FUNCTION void PdfDocument::select_layer_config(int config_num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_select_layer_config()\n";
	}
	mupdf::mpdf_select_layer_config(*this, config_num);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_select_layer_config_ui()`.  */
FZ_FUNCTION void PdfDocument::select_layer_config_ui(int ui)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_select_layer_config_ui()\n";
	}
	mupdf::mpdf_select_layer_config_ui(*this, ui);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_serialise_journal()`.  */
FZ_FUNCTION void PdfDocument::serialise_journal(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_serialise_journal()\n";
	}
	mupdf::mpdf_serialise_journal(*this, out);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_annot_field_value()`.  */
FZ_FUNCTION int PdfDocument::set_annot_field_value(const PdfAnnot& widget, const char *text, int ignore_trigger_events)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_annot_field_value()\n";
	}
	auto ret = mupdf::mpdf_set_annot_field_value(*this, widget, text, ignore_trigger_events);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_set_doc_event_callback()`.  */
FZ_FUNCTION void PdfDocument::set_doc_event_callback(pdf_doc_event_cb *event_cb, pdf_free_doc_event_data_cb *free_event_data_cb, void *data)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_doc_event_callback()\n";
	}
	mupdf::mpdf_set_doc_event_callback(*this, event_cb, free_event_data_cb, data);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_document_language()`.  */
FZ_FUNCTION void PdfDocument::set_document_language(fz_text_language lang)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_document_language()\n";
	}
	mupdf::mpdf_set_document_language(*this, lang);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_field_value()`.  */
FZ_FUNCTION int PdfDocument::set_field_value(const PdfObj& field, const char *text, int ignore_trigger_events)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_field_value()\n";
	}
	auto ret = mupdf::mpdf_set_field_value(*this, field, text, ignore_trigger_events);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_set_layer_config_as_default()`.  */
FZ_FUNCTION void PdfDocument::set_layer_config_as_default()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_layer_config_as_default()\n";
	}
	mupdf::mpdf_set_layer_config_as_default(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_populating_xref_trailer()`.  */
FZ_FUNCTION void PdfDocument::set_populating_xref_trailer(const PdfObj& trailer)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_populating_xref_trailer()\n";
	}
	mupdf::mpdf_set_populating_xref_trailer(*this, trailer);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_signature_byte_range()`.  */
FZ_FUNCTION int PdfDocument::signature_byte_range(const PdfObj& signature, const Range& byte_range)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_signature_byte_range()\n";
	}
	auto ret = mupdf::mpdf_signature_byte_range(*this, signature, byte_range);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_signature_contents()`.
	
	This method has out-params. Python/C# wrappers look like:
		`signature_contents(pdf_obj *signature)` => `(size_t, char *contents)`
	 */
FZ_FUNCTION size_t PdfDocument::signature_contents(const PdfObj& signature, char **contents)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_signature_contents()\n";
	}
	auto ret = mupdf::mpdf_signature_contents(*this, signature, contents);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_signature_hash_bytes()`.  */
FZ_FUNCTION Stream PdfDocument::signature_hash_bytes(const PdfObj& signature)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_signature_hash_bytes()\n";
	}
	auto ret = mupdf::mpdf_signature_hash_bytes(*this, signature);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_signature_incremental_change_since_signing()`.  */
FZ_FUNCTION int PdfDocument::signature_incremental_change_since_signing(const PdfObj& signature)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_signature_incremental_change_since_signing()\n";
	}
	auto ret = mupdf::mpdf_signature_incremental_change_since_signing(*this, signature);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_signature_is_signed()`.  */
FZ_FUNCTION int PdfDocument::signature_is_signed(const PdfObj& field)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_signature_is_signed()\n";
	}
	auto ret = mupdf::mpdf_signature_is_signed(*this, field);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_signature_set_value()`.  */
FZ_FUNCTION void PdfDocument::signature_set_value(const PdfObj& field, const PdfPkcs7Signer& signer, int64_t stime)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_signature_set_value()\n";
	}
	mupdf::mpdf_signature_set_value(*this, field, signer, stime);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_toggle_layer_config_ui()`.  */
FZ_FUNCTION void PdfDocument::toggle_layer_config_ui(int ui)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_toggle_layer_config_ui()\n";
	}
	mupdf::mpdf_toggle_layer_config_ui(*this, ui);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_trailer()`.  */
FZ_FUNCTION PdfObj PdfDocument::trailer()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_trailer()\n";
	}
	auto ret = mupdf::mpdf_trailer(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_undo()`.  */
FZ_FUNCTION void PdfDocument::undo()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_undo()\n";
	}
	mupdf::mpdf_undo(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_undoredo_state()`.
	
	This method has out-params. Python/C# wrappers look like:
		`undoredo_state()` => `(int, int steps)`
	 */
FZ_FUNCTION int PdfDocument::undoredo_state(int *steps)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_undoredo_state()\n";
	}
	auto ret = mupdf::mpdf_undoredo_state(*this, steps);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_undoredo_step()`.  */
FZ_FUNCTION const char *PdfDocument::undoredo_step(int step)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_undoredo_step()\n";
	}
	auto ret = mupdf::mpdf_undoredo_step(*this, step);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_update_object()`.  */
FZ_FUNCTION void PdfDocument::update_object(int num, const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_update_object()\n";
	}
	mupdf::mpdf_update_object(*this, num, obj);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_update_stream()`.  */
FZ_FUNCTION void PdfDocument::update_stream(const PdfObj& ref, const Buffer& buf, int compressed)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_update_stream()\n";
	}
	mupdf::mpdf_update_stream(*this, ref, buf, compressed);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_update_xobject()`.  */
FZ_FUNCTION void PdfDocument::update_xobject(const PdfObj& xobj, Rect& bbox, Matrix& mat, const PdfObj& res, const Buffer& buffer)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_update_xobject()\n";
	}
	mupdf::mpdf_update_xobject(*this, xobj, bbox, mat, res, buffer);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_validate_change_history()`.  */
FZ_FUNCTION int PdfDocument::validate_change_history()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_validate_change_history()\n";
	}
	auto ret = mupdf::mpdf_validate_change_history(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_validate_changes()`.  */
FZ_FUNCTION int PdfDocument::validate_changes(int version)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_validate_changes()\n";
	}
	auto ret = mupdf::mpdf_validate_changes(*this, version);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_version()`.  */
FZ_FUNCTION int PdfDocument::version()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_version()\n";
	}
	auto ret = mupdf::mpdf_version(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_was_pure_xfa()`.  */
FZ_FUNCTION int PdfDocument::was_pure_xfa()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_was_pure_xfa()\n";
	}
	auto ret = mupdf::mpdf_was_pure_xfa(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_was_repaired()`.  */
FZ_FUNCTION int PdfDocument::was_repaired()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_was_repaired()\n";
	}
	auto ret = mupdf::mpdf_was_repaired(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_write_document()`.  */
FZ_FUNCTION void PdfDocument::write_document(const Output& out, PdfWriteOptions& opts)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_write_document()\n";
	}
	mupdf::mpdf_write_document(*this, out, opts);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_write_journal()`.  */
FZ_FUNCTION void PdfDocument::write_journal(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_write_journal()\n";
	}
	mupdf::mpdf_write_journal(*this, out);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_write_snapshot()`.  */
FZ_FUNCTION void PdfDocument::write_snapshot(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_write_snapshot()\n";
	}
	mupdf::mpdf_write_snapshot(*this, out);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_xref_ensure_incremental_object()`.  */
FZ_FUNCTION int PdfDocument::xref_ensure_incremental_object(int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xref_ensure_incremental_object()\n";
	}
	auto ret = mupdf::mpdf_xref_ensure_incremental_object(*this, num);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_xref_ensure_local_object()`.  */
FZ_FUNCTION void PdfDocument::xref_ensure_local_object(int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xref_ensure_local_object()\n";
	}
	mupdf::mpdf_xref_ensure_local_object(*this, num);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_xref_is_incremental()`.  */
FZ_FUNCTION int PdfDocument::xref_is_incremental(int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xref_is_incremental()\n";
	}
	auto ret = mupdf::mpdf_xref_is_incremental(*this, num);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_xref_len()`.  */
FZ_FUNCTION int PdfDocument::xref_len()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xref_len()\n";
	}
	auto ret = mupdf::mpdf_xref_len(*this);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_xref_obj_is_unsaved_signature()`.  */
FZ_FUNCTION int PdfDocument::xref_obj_is_unsaved_signature(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xref_obj_is_unsaved_signature()\n";
	}
	auto ret = mupdf::mpdf_xref_obj_is_unsaved_signature(*this, obj);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_xref_remove_unsaved_signature()`.  */
FZ_FUNCTION void PdfDocument::xref_remove_unsaved_signature(const PdfObj& field)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xref_remove_unsaved_signature()\n";
	}
	mupdf::mpdf_xref_remove_unsaved_signature(*this, field);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_xref_store_unsaved_signature()`.  */
FZ_FUNCTION void PdfDocument::xref_store_unsaved_signature(const PdfObj& field, const PdfPkcs7Signer& signer)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xref_store_unsaved_signature()\n";
	}
	mupdf::mpdf_xref_store_unsaved_signature(*this, field, signer);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION std::string PdfDocument::lookup_metadata(const char* key, int* o_out)
{
	return mupdf::ppdf_lookup_metadata(m_internal, key, o_out);
}

/** Custom method. */
FZ_FUNCTION Document PdfDocument::super()
{
	return Document( mupdf::keep_document( &m_internal->super));
}

FZ_FUNCTION PdfDocument::PdfDocument(pdf_document* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION PdfDocument::~PdfDocument()
{
	mupdf::ppdf_drop_document(m_internal);
	if (s_check_refs)
	{
		s_PdfDocument_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long PdfDocument::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfFilterOptions (wrapper for pdf_filter_options). */

/** Custom constructor. */
FZ_FUNCTION PdfFilterOptions::PdfFilterOptions()
{
	this->image_filter = nullptr;
	this->text_filter = nullptr;
	this->after_text_object = nullptr;
	this->end_page = nullptr;
	this->recurse = 0;
	this->instance_forms = 0;
	this->sanitize = 0;
	this->ascii = 0;
}

FZ_FUNCTION PdfFilterOptions::PdfFilterOptions(const pdf_filter_options* internal)
{
	this->opaque = internal->opaque;
	this->image_filter = internal->image_filter;
	this->text_filter = internal->text_filter;
	this->after_text_object = internal->after_text_object;
	this->end_page = internal->end_page;
	this->recurse = internal->recurse;
	this->instance_forms = internal->instance_forms;
	this->sanitize = internal->sanitize;
	this->ascii = internal->ascii;
}

FZ_FUNCTION PdfFilterOptions::PdfFilterOptions(const pdf_filter_options internal)
{
	this->opaque = internal.opaque;
	this->image_filter = internal.image_filter;
	this->text_filter = internal.text_filter;
	this->after_text_object = internal.after_text_object;
	this->end_page = internal.end_page;
	this->recurse = internal.recurse;
	this->instance_forms = internal.instance_forms;
	this->sanitize = internal.sanitize;
	this->ascii = internal.ascii;
}

/** Constructor using raw copy of pre-existing `pdf_filter_options`. */
FZ_FUNCTION pdf_filter_options* PdfFilterOptions::internal()
{
	auto ret = (pdf_filter_options*) &this->opaque;
	return ret;
}

/** Constructor using raw copy of pre-existing `pdf_filter_options`. */
FZ_FUNCTION const pdf_filter_options* PdfFilterOptions::internal() const
{
	auto ret = (const pdf_filter_options*) &this->opaque;
	return ret;
}

FZ_FUNCTION std::string PdfFilterOptions::to_string()
{
	std::ostringstream buffer;
	buffer << *this;
	return buffer.str();
}


FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const PdfFilterOptions& rhs)
{
	return out << *rhs.internal();
}
/* Implementation of methods for `PdfFilterOptions2`, virtual_fnptrs wrapper for `pdf_filter_options`). */


FZ_FUNCTION PdfFilterOptions2::PdfFilterOptions2()
{

	this->opaque = this;
	
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfFilterOptions2::PdfFilterOptions2(); this=" << this << "\n";
	}
}
/* Static callback, calls self->image_filter(). */
static fz_image * PdfFilterOptions2_s_image_filter(fz_context *arg_0, void *arg_1, fz_matrix arg_2, const char *arg_3, fz_image *arg_4)
{
	PdfFilterOptions2* self = (PdfFilterOptions2*) arg_1;
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfFilterOptions2_s_image_filter(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->image_filter(arg_2, arg_3, arg_4);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->text_filter(). */
static int PdfFilterOptions2_s_text_filter(fz_context *arg_0, void *arg_1, int *arg_2, int arg_3, fz_matrix arg_4, fz_matrix arg_5, fz_rect arg_6)
{
	PdfFilterOptions2* self = (PdfFilterOptions2*) arg_1;
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfFilterOptions2_s_text_filter(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->text_filter(arg_2, arg_3, arg_4, arg_5, arg_6);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->after_text_object(). */
static void PdfFilterOptions2_s_after_text_object(fz_context *arg_0, void *arg_1, pdf_document *arg_2, pdf_processor *arg_3, fz_matrix arg_4)
{
	PdfFilterOptions2* self = (PdfFilterOptions2*) arg_1;
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfFilterOptions2_s_after_text_object(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->after_text_object(arg_2, arg_3, arg_4);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->end_page(). */
static void PdfFilterOptions2_s_end_page(fz_context *arg_0, fz_buffer *arg_1, void *arg_2)
{
	PdfFilterOptions2* self = (PdfFilterOptions2*) arg_1;
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfFilterOptions2_s_end_page(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->end_page(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
FZ_FUNCTION void PdfFilterOptions2::use_virtual_image_filter( bool use)
{
	PdfFilterOptions::image_filter = (use) ? PdfFilterOptions2_s_image_filter : nullptr;
}
FZ_FUNCTION void PdfFilterOptions2::use_virtual_text_filter( bool use)
{
	PdfFilterOptions::text_filter = (use) ? PdfFilterOptions2_s_text_filter : nullptr;
}
FZ_FUNCTION void PdfFilterOptions2::use_virtual_after_text_object( bool use)
{
	PdfFilterOptions::after_text_object = (use) ? PdfFilterOptions2_s_after_text_object : nullptr;
}
FZ_FUNCTION void PdfFilterOptions2::use_virtual_end_page( bool use)
{
	PdfFilterOptions::end_page = (use) ? PdfFilterOptions2_s_end_page : nullptr;
}
/* Default implementation of virtual method. */
FZ_FUNCTION struct fz_image * PdfFilterOptions2::image_filter(fz_matrix arg_2, const char *arg_3, struct fz_image *arg_4)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfFilterOptions2::image_filter().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION int PdfFilterOptions2::text_filter(int *arg_2, int arg_3, fz_matrix arg_4, fz_matrix arg_5, fz_rect arg_6)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfFilterOptions2::text_filter().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfFilterOptions2::after_text_object(struct pdf_document *arg_2, struct pdf_processor *arg_3, fz_matrix arg_4)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfFilterOptions2::after_text_object().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfFilterOptions2::end_page(void *arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfFilterOptions2::end_page().");
}

/* Implementation of methods for PdfFontDesc (wrapper for pdf_font_desc). */

/* Constructor using `pdf_new_font_desc()`. */
FZ_FUNCTION PdfFontDesc::PdfFontDesc()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_font_desc()\n";
	}
	this->m_internal = mupdf::ppdf_new_font_desc();
}

/* Wrapper for `pdf_add_hmtx()`.  */
FZ_FUNCTION void PdfFontDesc::add_hmtx(int lo, int hi, int w)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_hmtx()\n";
	}
	mupdf::mpdf_add_hmtx(*this, lo, hi, w);
}

/* Wrapper for `pdf_add_vmtx()`.  */
FZ_FUNCTION void PdfFontDesc::add_vmtx(int lo, int hi, int x, int y, int w)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_add_vmtx()\n";
	}
	mupdf::mpdf_add_vmtx(*this, lo, hi, x, y, w);
}

/* Wrapper for `pdf_end_hmtx()`.  */
FZ_FUNCTION void PdfFontDesc::end_hmtx()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_end_hmtx()\n";
	}
	mupdf::mpdf_end_hmtx(*this);
}

/* Wrapper for `pdf_end_vmtx()`.  */
FZ_FUNCTION void PdfFontDesc::end_vmtx()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_end_vmtx()\n";
	}
	mupdf::mpdf_end_vmtx(*this);
}

/* Wrapper for `pdf_font_cid_to_gid()`.  */
FZ_FUNCTION int PdfFontDesc::font_cid_to_gid(int cid)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_font_cid_to_gid()\n";
	}
	auto ret = mupdf::mpdf_font_cid_to_gid(*this, cid);
	return ret;
}

/* Wrapper for `pdf_set_default_hmtx()`.  */
FZ_FUNCTION void PdfFontDesc::set_default_hmtx(int w)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_default_hmtx()\n";
	}
	mupdf::mpdf_set_default_hmtx(*this, w);
}

/* Wrapper for `pdf_set_default_vmtx()`.  */
FZ_FUNCTION void PdfFontDesc::set_default_vmtx(int y, int w)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_default_vmtx()\n";
	}
	mupdf::mpdf_set_default_vmtx(*this, y, w);
}

/* Wrapper for `pdf_set_font_wmode()`.  */
FZ_FUNCTION void PdfFontDesc::set_font_wmode(int wmode)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_font_wmode()\n";
	}
	mupdf::mpdf_set_font_wmode(*this, wmode);
}

FZ_FUNCTION PdfFontDesc::PdfFontDesc(pdf_font_desc* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfFontDesc::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfFontResourceKey (wrapper for pdf_font_resource_key). */

FZ_FUNCTION PdfFontResourceKey::PdfFontResourceKey(pdf_font_resource_key* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfFontResourceKey::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfFunction (wrapper for pdf_function). */

static RefsCheck<pdf_function, PdfFunction> s_PdfFunction_refs_check(0, 32);

/** Copy constructor using `pdf_keep_function()`. */
FZ_FUNCTION PdfFunction::PdfFunction(const PdfFunction& rhs)
: m_internal(mupdf::ppdf_keep_function(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_function(this->m_internal) and mupdf::ppdf_keep_function(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_PdfFunction_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `pdf_keep_function()` and `pdf_drop_function()`. */
FZ_FUNCTION PdfFunction& PdfFunction::operator=(const PdfFunction& rhs)
{
	mupdf::ppdf_drop_function(this->m_internal);
	mupdf::ppdf_keep_function(rhs.m_internal);
	if (s_check_refs)
	{
		s_PdfFunction_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_PdfFunction_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/* Wrapper for `pdf_eval_function()`.
	
	This method has out-params. Python/C# wrappers look like:
		`eval_function(const float *in, int inlen, int outlen)` => float out
	 */
FZ_FUNCTION void PdfFunction::eval_function(const float *in, int inlen, float *out, int outlen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_eval_function()\n";
	}
	mupdf::mpdf_eval_function(*this, in, inlen, out, outlen);
	if (s_check_refs)
	{
		s_PdfFunction_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_function_size()`.  */
FZ_FUNCTION size_t PdfFunction::function_size()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_function_size()\n";
	}
	auto ret = mupdf::mpdf_function_size(*this);
	if (s_check_refs)
	{
		s_PdfFunction_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

FZ_FUNCTION PdfFunction::PdfFunction(pdf_function* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_PdfFunction_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION PdfFunction::~PdfFunction()
{
	mupdf::ppdf_drop_function(m_internal);
	if (s_check_refs)
	{
		s_PdfFunction_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long PdfFunction::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfGraftMap (wrapper for pdf_graft_map). */

static RefsCheck<pdf_graft_map, PdfGraftMap> s_PdfGraftMap_refs_check(0, 32);

/* Constructor using `pdf_new_graft_map()`. */
FZ_FUNCTION PdfGraftMap::PdfGraftMap(const PdfDocument& dst)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_graft_map()\n";
	}
	this->m_internal = mupdf::ppdf_new_graft_map(dst.m_internal);
	if (s_check_refs)
	{
		s_PdfGraftMap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Copy constructor using `pdf_keep_graft_map()`. */
FZ_FUNCTION PdfGraftMap::PdfGraftMap(const PdfGraftMap& rhs)
: m_internal(mupdf::ppdf_keep_graft_map(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_graft_map(this->m_internal) and mupdf::ppdf_keep_graft_map(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_PdfGraftMap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `pdf_keep_graft_map()` and `pdf_drop_graft_map()`. */
FZ_FUNCTION PdfGraftMap& PdfGraftMap::operator=(const PdfGraftMap& rhs)
{
	mupdf::ppdf_drop_graft_map(this->m_internal);
	mupdf::ppdf_keep_graft_map(rhs.m_internal);
	if (s_check_refs)
	{
		s_PdfGraftMap_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_PdfGraftMap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/* Wrapper for `pdf_graft_mapped_object()`.  */
FZ_FUNCTION PdfObj PdfGraftMap::graft_mapped_object(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_graft_mapped_object()\n";
	}
	auto ret = mupdf::mpdf_graft_mapped_object(*this, obj);
	if (s_check_refs)
	{
		s_PdfGraftMap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_graft_mapped_page()`.  */
FZ_FUNCTION void PdfGraftMap::graft_mapped_page(int page_to, const PdfDocument& src, int page_from)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_graft_mapped_page()\n";
	}
	mupdf::mpdf_graft_mapped_page(*this, page_to, src, page_from);
	if (s_check_refs)
	{
		s_PdfGraftMap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION PdfGraftMap::PdfGraftMap(pdf_graft_map* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_PdfGraftMap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION PdfGraftMap::~PdfGraftMap()
{
	mupdf::ppdf_drop_graft_map(m_internal);
	if (s_check_refs)
	{
		s_PdfGraftMap_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long PdfGraftMap::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfGstate (wrapper for pdf_gstate). */

FZ_FUNCTION PdfGstate::PdfGstate(pdf_gstate* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfGstate::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfHintPage (wrapper for pdf_hint_page). */

FZ_FUNCTION PdfHintPage::PdfHintPage(pdf_hint_page* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfHintPage::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfHintShared (wrapper for pdf_hint_shared). */

FZ_FUNCTION PdfHintShared::PdfHintShared(pdf_hint_shared* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfHintShared::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfHmtx (wrapper for pdf_hmtx). */

FZ_FUNCTION PdfHmtx::PdfHmtx(pdf_hmtx* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfHmtx::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfJournal (wrapper for pdf_journal). */

/* Wrapper for `pdf_discard_journal()`.  */
FZ_FUNCTION void PdfJournal::discard_journal()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_discard_journal()\n";
	}
	mupdf::mpdf_discard_journal(*this);
}

FZ_FUNCTION PdfJournal::PdfJournal(pdf_journal* internal)
: m_internal(internal)
{
}

FZ_FUNCTION PdfJournal::~PdfJournal()
{
	mupdf::ppdf_drop_journal(m_internal);
}

/** Custom method. */
FZ_FUNCTION long long PdfJournal::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfJs (wrapper for pdf_js). */

/* Wrapper for `pdf_js_event_init()`.  */
FZ_FUNCTION void PdfJs::js_event_init(const PdfObj& target, const char *value, int willCommit)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_js_event_init()\n";
	}
	mupdf::mpdf_js_event_init(*this, target, value, willCommit);
}

/* Wrapper for `pdf_js_event_init_keystroke()`.  */
FZ_FUNCTION void PdfJs::js_event_init_keystroke(const PdfObj& target, const PdfKeystrokeEvent& evt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_js_event_init_keystroke()\n";
	}
	mupdf::mpdf_js_event_init_keystroke(*this, target, evt);
}

/* Wrapper for `pdf_js_event_result()`.  */
FZ_FUNCTION int PdfJs::js_event_result()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_js_event_result()\n";
	}
	auto ret = mupdf::mpdf_js_event_result(*this);
	return ret;
}

/* Wrapper for `pdf_js_event_result_keystroke()`.  */
FZ_FUNCTION int PdfJs::js_event_result_keystroke(const PdfKeystrokeEvent& evt)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_js_event_result_keystroke()\n";
	}
	auto ret = mupdf::mpdf_js_event_result_keystroke(*this, evt);
	return ret;
}

/* Wrapper for `pdf_js_event_result_validate()`.
	
	This method has out-params. Python/C# wrappers look like:
		`js_event_result_validate()` => `(int, char *newvalue)`
	 */
FZ_FUNCTION int PdfJs::js_event_result_validate(char **newvalue)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_js_event_result_validate()\n";
	}
	auto ret = mupdf::mpdf_js_event_result_validate(*this, newvalue);
	return ret;
}

/* Wrapper for `pdf_js_event_value()`.  */
FZ_FUNCTION char *PdfJs::js_event_value()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_js_event_value()\n";
	}
	auto ret = mupdf::mpdf_js_event_value(*this);
	return ret;
}

/* Wrapper for `pdf_js_execute()`.
	
	This method has out-params. Python/C# wrappers look like:
		`js_execute(const char *name, const char *code)` => char *result
	 */
FZ_FUNCTION void PdfJs::js_execute(const char *name, const char *code, char **result)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_js_execute()\n";
	}
	mupdf::mpdf_js_execute(*this, name, code, result);
}

FZ_FUNCTION PdfJs::PdfJs(pdf_js* internal)
: m_internal(internal)
{
}

FZ_FUNCTION PdfJs::~PdfJs()
{
	mupdf::ppdf_drop_js(m_internal);
}

/** Custom method. */
FZ_FUNCTION long long PdfJs::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfJsConsole (wrapper for pdf_js_console). */

FZ_FUNCTION PdfJsConsole::PdfJsConsole(pdf_js_console* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfJsConsole::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfKeystrokeEvent (wrapper for pdf_keystroke_event). */

FZ_FUNCTION PdfKeystrokeEvent::PdfKeystrokeEvent(pdf_keystroke_event* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfKeystrokeEvent::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfLaunchUrlEvent (wrapper for pdf_launch_url_event). */

FZ_FUNCTION PdfLaunchUrlEvent::PdfLaunchUrlEvent(pdf_launch_url_event* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfLaunchUrlEvent::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfLayerConfig (wrapper for pdf_layer_config). */

/** Custom constructor. */
FZ_FUNCTION PdfLayerConfig::PdfLayerConfig()
{
	this->name = nullptr;
	this->creator = nullptr;
}

FZ_FUNCTION PdfLayerConfig::PdfLayerConfig(const pdf_layer_config* internal)
{
	this->name = internal->name;
	this->creator = internal->creator;
}

FZ_FUNCTION PdfLayerConfig::PdfLayerConfig(const pdf_layer_config internal)
{
	this->name = internal.name;
	this->creator = internal.creator;
}

/** Constructor using raw copy of pre-existing `pdf_layer_config`. */
FZ_FUNCTION pdf_layer_config* PdfLayerConfig::internal()
{
	auto ret = (pdf_layer_config*) &this->name;
	return ret;
}

/** Constructor using raw copy of pre-existing `pdf_layer_config`. */
FZ_FUNCTION const pdf_layer_config* PdfLayerConfig::internal() const
{
	auto ret = (const pdf_layer_config*) &this->name;
	return ret;
}

FZ_FUNCTION std::string PdfLayerConfig::to_string()
{
	std::ostringstream buffer;
	buffer << *this;
	return buffer.str();
}


FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const PdfLayerConfig& rhs)
{
	return out << *rhs.internal();
}

/* Implementation of methods for PdfLayerConfigUi (wrapper for pdf_layer_config_ui). */

/** Custom constructor. */
FZ_FUNCTION PdfLayerConfigUi::PdfLayerConfigUi()
{
	this->text = nullptr;
	this->depth = 0;
	this->type = PDF_LAYER_UI_LABEL;
	this->selected = 0;
	this->locked = 0;
}

FZ_FUNCTION PdfLayerConfigUi::PdfLayerConfigUi(const pdf_layer_config_ui* internal)
{
	this->text = internal->text;
	this->depth = internal->depth;
	this->type = internal->type;
	this->selected = internal->selected;
	this->locked = internal->locked;
}

FZ_FUNCTION PdfLayerConfigUi::PdfLayerConfigUi(const pdf_layer_config_ui internal)
{
	this->text = internal.text;
	this->depth = internal.depth;
	this->type = internal.type;
	this->selected = internal.selected;
	this->locked = internal.locked;
}

/** Constructor using raw copy of pre-existing `pdf_layer_config_ui`. */
FZ_FUNCTION pdf_layer_config_ui* PdfLayerConfigUi::internal()
{
	auto ret = (pdf_layer_config_ui*) &this->text;
	return ret;
}

/** Constructor using raw copy of pre-existing `pdf_layer_config_ui`. */
FZ_FUNCTION const pdf_layer_config_ui* PdfLayerConfigUi::internal() const
{
	auto ret = (const pdf_layer_config_ui*) &this->text;
	return ret;
}

FZ_FUNCTION std::string PdfLayerConfigUi::to_string()
{
	std::ostringstream buffer;
	buffer << *this;
	return buffer.str();
}


FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const PdfLayerConfigUi& rhs)
{
	return out << *rhs.internal();
}

/* Implementation of methods for PdfLexbuf (wrapper for pdf_lexbuf). */

/** Custom constructor. */
FZ_FUNCTION PdfLexbuf::PdfLexbuf(int size)
{
	m_internal = new pdf_lexbuf;
	mupdf::ppdf_lexbuf_init(m_internal, size);
}

/* Wrapper for `pdf_lexbuf_fin()`.  */
FZ_FUNCTION void PdfLexbuf::lexbuf_fin()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lexbuf_fin()\n";
	}
	mupdf::mpdf_lexbuf_fin(*this);
}

/* Wrapper for `pdf_lexbuf_grow()`.  */
FZ_FUNCTION ptrdiff_t PdfLexbuf::lexbuf_grow()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lexbuf_grow()\n";
	}
	auto ret = mupdf::mpdf_lexbuf_grow(*this);
	return ret;
}

/* Wrapper for `pdf_lexbuf_init()`.  */
FZ_FUNCTION void PdfLexbuf::lexbuf_init(int size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lexbuf_init()\n";
	}
	mupdf::mpdf_lexbuf_init(*this, size);
}

/** Custom destructor. */
FZ_FUNCTION PdfLexbuf::~PdfLexbuf()
{
	mupdf::ppdf_lexbuf_fin(m_internal);
	delete m_internal;
}

FZ_FUNCTION PdfLexbuf::PdfLexbuf(pdf_lexbuf* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfLexbuf::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfLexbufLarge (wrapper for pdf_lexbuf_large). */

FZ_FUNCTION PdfLexbufLarge::PdfLexbufLarge(pdf_lexbuf_large* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfLexbufLarge::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfLockedFields (wrapper for pdf_locked_fields). */

/* Wrapper for `pdf_is_field_locked()`.  */
FZ_FUNCTION int PdfLockedFields::is_field_locked(const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_field_locked()\n";
	}
	auto ret = mupdf::mpdf_is_field_locked(*this, name);
	return ret;
}

FZ_FUNCTION PdfLockedFields::PdfLockedFields(pdf_locked_fields* internal)
: m_internal(internal)
{
}

FZ_FUNCTION PdfLockedFields::~PdfLockedFields()
{
	mupdf::ppdf_drop_locked_fields(m_internal);
}

/** Custom method. */
FZ_FUNCTION long long PdfLockedFields::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfMailDocEvent (wrapper for pdf_mail_doc_event). */

FZ_FUNCTION PdfMailDocEvent::PdfMailDocEvent(pdf_mail_doc_event* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfMailDocEvent::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfMarkList (wrapper for pdf_mark_list). */

/* Wrapper for `pdf_mark_list_free()`.  */
FZ_FUNCTION void PdfMarkList::mark_list_free()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_mark_list_free()\n";
	}
	mupdf::mpdf_mark_list_free(*this);
}

/* Wrapper for `pdf_mark_list_init()`.  */
FZ_FUNCTION void PdfMarkList::mark_list_init()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_mark_list_init()\n";
	}
	mupdf::mpdf_mark_list_init(*this);
}

/* Wrapper for `pdf_mark_list_pop()`.  */
FZ_FUNCTION void PdfMarkList::mark_list_pop()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_mark_list_pop()\n";
	}
	mupdf::mpdf_mark_list_pop(*this);
}

/* Wrapper for `pdf_mark_list_push()`.  */
FZ_FUNCTION int PdfMarkList::mark_list_push(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_mark_list_push()\n";
	}
	auto ret = mupdf::mpdf_mark_list_push(*this, obj);
	return ret;
}

FZ_FUNCTION PdfMarkList::PdfMarkList(pdf_mark_list* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfMarkList::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfMrange (wrapper for pdf_mrange). */

FZ_FUNCTION PdfMrange::PdfMrange(pdf_mrange* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfMrange::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfObj (wrapper for pdf_obj). */

static RefsCheck<pdf_obj, PdfObj, true /*allow_int_this*/> s_PdfObj_refs_check(0, 16);

/* Constructor using `pdf_new_array()`. */
FZ_FUNCTION PdfObj::PdfObj(const PdfDocument& doc, int initialcap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_array()\n";
	}
	this->m_internal = mupdf::ppdf_new_array(doc.m_internal, initialcap);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `pdf_new_date()`. */
FZ_FUNCTION PdfObj::PdfObj(const PdfDocument& doc, int64_t time)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_date()\n";
	}
	this->m_internal = mupdf::ppdf_new_date(doc.m_internal, time);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `pdf_new_destination_from_link()`. */
FZ_FUNCTION PdfObj::PdfObj(const PdfDocument& doc, const char *uri)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_destination_from_link()\n";
	}
	this->m_internal = mupdf::ppdf_new_destination_from_link(doc.m_internal, uri);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `pdf_new_indirect()`. */
FZ_FUNCTION PdfObj::PdfObj(const PdfDocument& doc, int num, int gen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_indirect()\n";
	}
	this->m_internal = mupdf::ppdf_new_indirect(doc.m_internal, num, gen);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `pdf_new_int()`. */
FZ_FUNCTION PdfObj::PdfObj(int64_t i)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_int()\n";
	}
	this->m_internal = mupdf::ppdf_new_int(i);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `pdf_new_matrix()`. */
FZ_FUNCTION PdfObj::PdfObj(const PdfDocument& doc, Matrix& mtx)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_matrix()\n";
	}
	this->m_internal = mupdf::ppdf_new_matrix(doc.m_internal, *(fz_matrix*) &mtx.a);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `pdf_new_name()`. */
FZ_FUNCTION PdfObj::PdfObj(const char *str)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_name()\n";
	}
	this->m_internal = mupdf::ppdf_new_name(str);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `pdf_new_real()`. */
FZ_FUNCTION PdfObj::PdfObj(float f)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_real()\n";
	}
	this->m_internal = mupdf::ppdf_new_real(f);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `pdf_new_rect()`. */
FZ_FUNCTION PdfObj::PdfObj(const PdfDocument& doc, Rect& rect)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_rect()\n";
	}
	this->m_internal = mupdf::ppdf_new_rect(doc.m_internal, *(fz_rect*) &rect.x0);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `pdf_new_string()`. */
FZ_FUNCTION PdfObj::PdfObj(const char *str, size_t len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_string()\n";
	}
	this->m_internal = mupdf::ppdf_new_string(str, len);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `pdf_new_xobject()`. */
FZ_FUNCTION PdfObj::PdfObj(const PdfDocument& doc, Rect& bbox, Matrix& matrix, const PdfObj& res, const Buffer& buffer)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_xobject()\n";
	}
	this->m_internal = mupdf::ppdf_new_xobject(doc.m_internal, *(fz_rect*) &bbox.x0, *(fz_matrix*) &matrix.a, res.m_internal, buffer.m_internal);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Copy constructor using `pdf_keep_obj()`. */
FZ_FUNCTION PdfObj::PdfObj(const PdfObj& rhs)
: m_internal(mupdf::ppdf_keep_obj(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_obj(this->m_internal) and mupdf::ppdf_keep_obj(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_PdfObj_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `pdf_keep_obj()` and `pdf_drop_obj()`. */
FZ_FUNCTION PdfObj& PdfObj::operator=(const PdfObj& rhs)
{
	mupdf::ppdf_drop_obj(this->m_internal);
	mupdf::ppdf_keep_obj(rhs.m_internal);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_PdfObj_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/* Wrapper for `pdf_new_text_string()`.  */
FZ_FUNCTION PdfObj PdfObj::new_text_string(const char *s)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_text_string()\n";
	}
	auto ret = mupdf::mpdf_new_text_string(s);
	return ret;
}

/* Wrapper for `pdf_new_dict()`.  */
FZ_FUNCTION PdfObj PdfObj::new_dict(const PdfDocument& doc, int initialcap)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_dict()\n";
	}
	auto ret = mupdf::mpdf_new_dict(doc, initialcap);
	return ret;
}

/* Wrapper for `pdf_new_action_from_link()`.  */
FZ_FUNCTION PdfObj PdfObj::new_action_from_link(const PdfDocument& doc, const char *uri)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_action_from_link()\n";
	}
	auto ret = mupdf::mpdf_new_action_from_link(doc, uri);
	return ret;
}

/* Wrapper for `pdf_array_contains()`.  */
FZ_FUNCTION int PdfObj::array_contains(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_contains()\n";
	}
	auto ret = mupdf::mpdf_array_contains(*this, obj);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_array_delete()`.  */
FZ_FUNCTION void PdfObj::array_delete(int index)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_delete()\n";
	}
	mupdf::mpdf_array_delete(*this, index);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_array_find()`.  */
FZ_FUNCTION int PdfObj::array_find(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_find()\n";
	}
	auto ret = mupdf::mpdf_array_find(*this, obj);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_array_get()`.  */
FZ_FUNCTION PdfObj PdfObj::array_get(int i)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_get()\n";
	}
	auto ret = mupdf::mpdf_array_get(*this, i);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_array_get_bool()`.  */
FZ_FUNCTION int PdfObj::array_get_bool(int index)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_get_bool()\n";
	}
	auto ret = mupdf::mpdf_array_get_bool(*this, index);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_array_get_int()`.  */
FZ_FUNCTION int PdfObj::array_get_int(int index)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_get_int()\n";
	}
	auto ret = mupdf::mpdf_array_get_int(*this, index);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_array_get_matrix()`.  */
FZ_FUNCTION Matrix PdfObj::array_get_matrix(int index)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_get_matrix()\n";
	}
	auto ret = mupdf::mpdf_array_get_matrix(*this, index);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_array_get_name()`.  */
FZ_FUNCTION const char *PdfObj::array_get_name(int index)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_get_name()\n";
	}
	auto ret = mupdf::mpdf_array_get_name(*this, index);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_array_get_real()`.  */
FZ_FUNCTION float PdfObj::array_get_real(int index)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_get_real()\n";
	}
	auto ret = mupdf::mpdf_array_get_real(*this, index);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_array_get_rect()`.  */
FZ_FUNCTION Rect PdfObj::array_get_rect(int index)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_get_rect()\n";
	}
	auto ret = mupdf::mpdf_array_get_rect(*this, index);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_array_get_string()`.
	
	This method has out-params. Python/C# wrappers look like:
		`array_get_string(int index)` => `(const char *, size_t sizep)`
	 */
FZ_FUNCTION const char *PdfObj::array_get_string(int index, size_t *sizep)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_get_string()\n";
	}
	auto ret = mupdf::mpdf_array_get_string(*this, index, sizep);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_array_get_text_string()`.  */
FZ_FUNCTION const char *PdfObj::array_get_text_string(int index)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_get_text_string()\n";
	}
	auto ret = mupdf::mpdf_array_get_text_string(*this, index);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_array_insert()`.  */
FZ_FUNCTION void PdfObj::array_insert(const PdfObj& obj, int index)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_insert()\n";
	}
	mupdf::mpdf_array_insert(*this, obj, index);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_array_len()`.  */
FZ_FUNCTION int PdfObj::array_len()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_len()\n";
	}
	auto ret = mupdf::mpdf_array_len(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_array_push()`.  */
FZ_FUNCTION void PdfObj::array_push(const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_push()\n";
	}
	mupdf::mpdf_array_push(*this, obj);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_array_push_array()`.  */
FZ_FUNCTION PdfObj PdfObj::array_push_array(int initial)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_push_array()\n";
	}
	auto ret = mupdf::mpdf_array_push_array(*this, initial);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_array_push_bool()`.  */
FZ_FUNCTION void PdfObj::array_push_bool(int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_push_bool()\n";
	}
	mupdf::mpdf_array_push_bool(*this, x);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_array_push_dict()`.  */
FZ_FUNCTION PdfObj PdfObj::array_push_dict(int initial)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_push_dict()\n";
	}
	auto ret = mupdf::mpdf_array_push_dict(*this, initial);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_array_push_int()`.  */
FZ_FUNCTION void PdfObj::array_push_int(int64_t x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_push_int()\n";
	}
	mupdf::mpdf_array_push_int(*this, x);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_array_push_name()`.  */
FZ_FUNCTION void PdfObj::array_push_name(const char *x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_push_name()\n";
	}
	mupdf::mpdf_array_push_name(*this, x);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_array_push_real()`.  */
FZ_FUNCTION void PdfObj::array_push_real(double x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_push_real()\n";
	}
	mupdf::mpdf_array_push_real(*this, x);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_array_push_string()`.  */
FZ_FUNCTION void PdfObj::array_push_string(const char *x, size_t n)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_push_string()\n";
	}
	mupdf::mpdf_array_push_string(*this, x, n);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_array_push_text_string()`.  */
FZ_FUNCTION void PdfObj::array_push_text_string(const char *x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_push_text_string()\n";
	}
	mupdf::mpdf_array_push_text_string(*this, x);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_array_put()`.  */
FZ_FUNCTION void PdfObj::array_put(int i, const PdfObj& obj)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_array_put()\n";
	}
	mupdf::mpdf_array_put(*this, i, obj);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_button_field_on_state()`.  */
FZ_FUNCTION PdfObj PdfObj::button_field_on_state()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_button_field_on_state()\n";
	}
	auto ret = mupdf::mpdf_button_field_on_state(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_choice_field_option()`.  */
FZ_FUNCTION const char *PdfObj::choice_field_option(int exportval, int i)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_choice_field_option()\n";
	}
	auto ret = mupdf::mpdf_choice_field_option(*this, exportval, i);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_choice_field_option_count()`.  */
FZ_FUNCTION int PdfObj::choice_field_option_count()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_choice_field_option_count()\n";
	}
	auto ret = mupdf::mpdf_choice_field_option_count(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_clean_obj()`.  */
FZ_FUNCTION void PdfObj::clean_obj()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_clean_obj()\n";
	}
	mupdf::mpdf_clean_obj(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_copy_array()`.  */
FZ_FUNCTION PdfObj PdfObj::copy_array()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_copy_array()\n";
	}
	auto ret = mupdf::mpdf_copy_array(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_copy_dict()`.  */
FZ_FUNCTION PdfObj PdfObj::copy_dict()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_copy_dict()\n";
	}
	auto ret = mupdf::mpdf_copy_dict(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_debug_obj()`.  */
FZ_FUNCTION void PdfObj::debug_obj()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_debug_obj()\n";
	}
	mupdf::mpdf_debug_obj(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_debug_ref()`.  */
FZ_FUNCTION void PdfObj::debug_ref()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_debug_ref()\n";
	}
	mupdf::mpdf_debug_ref(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_deep_copy_obj()`.  */
FZ_FUNCTION PdfObj PdfObj::deep_copy_obj()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_deep_copy_obj()\n";
	}
	auto ret = mupdf::mpdf_deep_copy_obj(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_dict_del()`.  */
FZ_FUNCTION void PdfObj::dict_del(const PdfObj& key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_del()\n";
	}
	mupdf::mpdf_dict_del(*this, key);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_dict_dels()`.  */
FZ_FUNCTION void PdfObj::dict_dels(const char *key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_dels()\n";
	}
	mupdf::mpdf_dict_dels(*this, key);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_dict_get()`.  */
FZ_FUNCTION PdfObj PdfObj::dict_get(const PdfObj& key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_get()\n";
	}
	auto ret = mupdf::mpdf_dict_get(*this, key);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_dict_get_bool()`.  */
FZ_FUNCTION int PdfObj::dict_get_bool(const PdfObj& key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_get_bool()\n";
	}
	auto ret = mupdf::mpdf_dict_get_bool(*this, key);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_dict_get_date()`.  */
FZ_FUNCTION int64_t PdfObj::dict_get_date(const PdfObj& key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_get_date()\n";
	}
	auto ret = mupdf::mpdf_dict_get_date(*this, key);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_dict_get_inheritable()`.  */
FZ_FUNCTION PdfObj PdfObj::dict_get_inheritable(const PdfObj& key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_get_inheritable()\n";
	}
	auto ret = mupdf::mpdf_dict_get_inheritable(*this, key);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_dict_get_int()`.  */
FZ_FUNCTION int PdfObj::dict_get_int(const PdfObj& key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_get_int()\n";
	}
	auto ret = mupdf::mpdf_dict_get_int(*this, key);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_dict_get_key()`.  */
FZ_FUNCTION PdfObj PdfObj::dict_get_key(int idx)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_get_key()\n";
	}
	auto ret = mupdf::mpdf_dict_get_key(*this, idx);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_dict_get_matrix()`.  */
FZ_FUNCTION Matrix PdfObj::dict_get_matrix(const PdfObj& key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_get_matrix()\n";
	}
	auto ret = mupdf::mpdf_dict_get_matrix(*this, key);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_dict_get_name()`.  */
FZ_FUNCTION const char *PdfObj::dict_get_name(const PdfObj& key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_get_name()\n";
	}
	auto ret = mupdf::mpdf_dict_get_name(*this, key);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_dict_get_real()`.  */
FZ_FUNCTION float PdfObj::dict_get_real(const PdfObj& key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_get_real()\n";
	}
	auto ret = mupdf::mpdf_dict_get_real(*this, key);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_dict_get_rect()`.  */
FZ_FUNCTION Rect PdfObj::dict_get_rect(const PdfObj& key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_get_rect()\n";
	}
	auto ret = mupdf::mpdf_dict_get_rect(*this, key);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_dict_get_string()`.
	
	This method has out-params. Python/C# wrappers look like:
		`dict_get_string(pdf_obj *key)` => `(const char *, size_t sizep)`
	 */
FZ_FUNCTION const char *PdfObj::dict_get_string(const PdfObj& key, size_t *sizep)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_get_string()\n";
	}
	auto ret = mupdf::mpdf_dict_get_string(*this, key, sizep);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_dict_get_text_string()`.  */
FZ_FUNCTION const char *PdfObj::dict_get_text_string(const PdfObj& key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_get_text_string()\n";
	}
	auto ret = mupdf::mpdf_dict_get_text_string(*this, key);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_dict_get_val()`.  */
FZ_FUNCTION PdfObj PdfObj::dict_get_val(int idx)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_get_val()\n";
	}
	auto ret = mupdf::mpdf_dict_get_val(*this, idx);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_dict_geta()`.  */
FZ_FUNCTION PdfObj PdfObj::dict_geta(const PdfObj& key, const PdfObj& abbrev)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_geta()\n";
	}
	auto ret = mupdf::mpdf_dict_geta(*this, key, abbrev);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_dict_getp()`.  */
FZ_FUNCTION PdfObj PdfObj::dict_getp(const char *path)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_getp()\n";
	}
	auto ret = mupdf::mpdf_dict_getp(*this, path);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_dict_getp_inheritable()`.  */
FZ_FUNCTION PdfObj PdfObj::dict_getp_inheritable(const char *path)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_getp_inheritable()\n";
	}
	auto ret = mupdf::mpdf_dict_getp_inheritable(*this, path);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_dict_gets()`.  */
FZ_FUNCTION PdfObj PdfObj::dict_gets(const char *key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_gets()\n";
	}
	auto ret = mupdf::mpdf_dict_gets(*this, key);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_dict_getsa()`.  */
FZ_FUNCTION PdfObj PdfObj::dict_getsa(const char *key, const char *abbrev)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_getsa()\n";
	}
	auto ret = mupdf::mpdf_dict_getsa(*this, key, abbrev);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_dict_len()`.  */
FZ_FUNCTION int PdfObj::dict_len()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_len()\n";
	}
	auto ret = mupdf::mpdf_dict_len(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_dict_put()`.  */
FZ_FUNCTION void PdfObj::dict_put(const PdfObj& key, const PdfObj& val)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_put()\n";
	}
	mupdf::mpdf_dict_put(*this, key, val);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_dict_put_array()`.  */
FZ_FUNCTION PdfObj PdfObj::dict_put_array(const PdfObj& key, int initial)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_put_array()\n";
	}
	auto ret = mupdf::mpdf_dict_put_array(*this, key, initial);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_dict_put_bool()`.  */
FZ_FUNCTION void PdfObj::dict_put_bool(const PdfObj& key, int x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_put_bool()\n";
	}
	mupdf::mpdf_dict_put_bool(*this, key, x);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_dict_put_date()`.  */
FZ_FUNCTION void PdfObj::dict_put_date(const PdfObj& key, int64_t time)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_put_date()\n";
	}
	mupdf::mpdf_dict_put_date(*this, key, time);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_dict_put_dict()`.  */
FZ_FUNCTION PdfObj PdfObj::dict_put_dict(const PdfObj& key, int initial)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_put_dict()\n";
	}
	auto ret = mupdf::mpdf_dict_put_dict(*this, key, initial);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_dict_put_int()`.  */
FZ_FUNCTION void PdfObj::dict_put_int(const PdfObj& key, int64_t x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_put_int()\n";
	}
	mupdf::mpdf_dict_put_int(*this, key, x);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_dict_put_matrix()`.  */
FZ_FUNCTION void PdfObj::dict_put_matrix(const PdfObj& key, Matrix& x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_put_matrix()\n";
	}
	mupdf::mpdf_dict_put_matrix(*this, key, x);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_dict_put_name()`.  */
FZ_FUNCTION void PdfObj::dict_put_name(const PdfObj& key, const char *x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_put_name()\n";
	}
	mupdf::mpdf_dict_put_name(*this, key, x);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_dict_put_real()`.  */
FZ_FUNCTION void PdfObj::dict_put_real(const PdfObj& key, double x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_put_real()\n";
	}
	mupdf::mpdf_dict_put_real(*this, key, x);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_dict_put_rect()`.  */
FZ_FUNCTION void PdfObj::dict_put_rect(const PdfObj& key, Rect& x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_put_rect()\n";
	}
	mupdf::mpdf_dict_put_rect(*this, key, x);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_dict_put_string()`.  */
FZ_FUNCTION void PdfObj::dict_put_string(const PdfObj& key, const char *x, size_t n)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_put_string()\n";
	}
	mupdf::mpdf_dict_put_string(*this, key, x, n);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_dict_put_text_string()`.  */
FZ_FUNCTION void PdfObj::dict_put_text_string(const PdfObj& key, const char *x)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_put_text_string()\n";
	}
	mupdf::mpdf_dict_put_text_string(*this, key, x);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_dict_put_val_null()`.  */
FZ_FUNCTION void PdfObj::dict_put_val_null(int idx)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_put_val_null()\n";
	}
	mupdf::mpdf_dict_put_val_null(*this, idx);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_dict_putp()`.  */
FZ_FUNCTION void PdfObj::dict_putp(const char *path, const PdfObj& val)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_putp()\n";
	}
	mupdf::mpdf_dict_putp(*this, path, val);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_dict_puts()`.  */
FZ_FUNCTION void PdfObj::dict_puts(const char *key, const PdfObj& val)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_puts()\n";
	}
	mupdf::mpdf_dict_puts(*this, key, val);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_dict_puts_dict()`.  */
FZ_FUNCTION PdfObj PdfObj::dict_puts_dict(const char *key, int initial)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dict_puts_dict()\n";
	}
	auto ret = mupdf::mpdf_dict_puts_dict(*this, key, initial);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_dirty_obj()`.  */
FZ_FUNCTION void PdfObj::dirty_obj()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_dirty_obj()\n";
	}
	mupdf::mpdf_dirty_obj(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_embedded_file_name()`.  */
FZ_FUNCTION const char *PdfObj::embedded_file_name()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_embedded_file_name()\n";
	}
	auto ret = mupdf::mpdf_embedded_file_name(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_embedded_file_stream()`.  */
FZ_FUNCTION PdfObj PdfObj::embedded_file_stream()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_embedded_file_stream()\n";
	}
	auto ret = mupdf::mpdf_embedded_file_stream(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_embedded_file_type()`.  */
FZ_FUNCTION const char *PdfObj::embedded_file_type()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_embedded_file_type()\n";
	}
	auto ret = mupdf::mpdf_embedded_file_type(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_field_border_style()`.  */
FZ_FUNCTION char *PdfObj::field_border_style()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_border_style()\n";
	}
	auto ret = mupdf::mpdf_field_border_style(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_field_display()`.  */
FZ_FUNCTION int PdfObj::field_display()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_display()\n";
	}
	auto ret = mupdf::mpdf_field_display(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_field_flags()`.  */
FZ_FUNCTION int PdfObj::field_flags()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_flags()\n";
	}
	auto ret = mupdf::mpdf_field_flags(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_field_label()`.  */
FZ_FUNCTION const char *PdfObj::field_label()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_label()\n";
	}
	auto ret = mupdf::mpdf_field_label(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_field_name()`.  */
FZ_FUNCTION char *PdfObj::field_name()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_name()\n";
	}
	auto ret = mupdf::mpdf_field_name(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_field_set_border_style()`.  */
FZ_FUNCTION void PdfObj::field_set_border_style(const char *text)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_set_border_style()\n";
	}
	mupdf::mpdf_field_set_border_style(*this, text);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_field_set_button_caption()`.  */
FZ_FUNCTION void PdfObj::field_set_button_caption(const char *text)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_set_button_caption()\n";
	}
	mupdf::mpdf_field_set_button_caption(*this, text);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_field_set_display()`.  */
FZ_FUNCTION void PdfObj::field_set_display(int d)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_set_display()\n";
	}
	mupdf::mpdf_field_set_display(*this, d);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_field_set_fill_color()`.  */
FZ_FUNCTION void PdfObj::field_set_fill_color(const PdfObj& col)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_set_fill_color()\n";
	}
	mupdf::mpdf_field_set_fill_color(*this, col);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_field_set_text_color()`.  */
FZ_FUNCTION void PdfObj::field_set_text_color(const PdfObj& col)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_set_text_color()\n";
	}
	mupdf::mpdf_field_set_text_color(*this, col);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_field_type()`.  */
FZ_FUNCTION int PdfObj::field_type()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_type()\n";
	}
	auto ret = mupdf::mpdf_field_type(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_field_type_string()`.  */
FZ_FUNCTION const char *PdfObj::field_type_string()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_type_string()\n";
	}
	auto ret = mupdf::mpdf_field_type_string(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_field_value()`.  */
FZ_FUNCTION const char *PdfObj::field_value()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_field_value()\n";
	}
	auto ret = mupdf::mpdf_field_value(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_filter_xobject_instance()`.  */
FZ_FUNCTION PdfObj PdfObj::filter_xobject_instance(const PdfObj& page_res, Matrix& ctm, PdfFilterOptions& filter)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_filter_xobject_instance()\n";
	}
	auto ret = mupdf::mpdf_filter_xobject_instance(*this, page_res, ctm, filter);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_flatten_inheritable_page_items()`.  */
FZ_FUNCTION void PdfObj::flatten_inheritable_page_items()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_flatten_inheritable_page_items()\n";
	}
	mupdf::mpdf_flatten_inheritable_page_items(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_get_bound_document()`.  */
FZ_FUNCTION PdfDocument PdfObj::get_bound_document()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_get_bound_document()\n";
	}
	auto ret = mupdf::mpdf_get_bound_document(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_get_indirect_document()`.  */
FZ_FUNCTION PdfDocument PdfObj::get_indirect_document()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_get_indirect_document()\n";
	}
	auto ret = mupdf::mpdf_get_indirect_document(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_is_array()`.  */
FZ_FUNCTION int PdfObj::is_array()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_array()\n";
	}
	auto ret = mupdf::mpdf_is_array(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_is_bool()`.  */
FZ_FUNCTION int PdfObj::is_bool()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_bool()\n";
	}
	auto ret = mupdf::mpdf_is_bool(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_is_dict()`.  */
FZ_FUNCTION int PdfObj::is_dict()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_dict()\n";
	}
	auto ret = mupdf::mpdf_is_dict(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_is_embedded_file()`.  */
FZ_FUNCTION int PdfObj::is_embedded_file()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_embedded_file()\n";
	}
	auto ret = mupdf::mpdf_is_embedded_file(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_is_indirect()`.  */
FZ_FUNCTION int PdfObj::is_indirect()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_indirect()\n";
	}
	auto ret = mupdf::mpdf_is_indirect(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_is_int()`.  */
FZ_FUNCTION int PdfObj::is_int()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_int()\n";
	}
	auto ret = mupdf::mpdf_is_int(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_is_jpx_image()`.  */
FZ_FUNCTION int PdfObj::is_jpx_image()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_jpx_image()\n";
	}
	auto ret = mupdf::mpdf_is_jpx_image(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_is_name()`.  */
FZ_FUNCTION int PdfObj::is_name()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_name()\n";
	}
	auto ret = mupdf::mpdf_is_name(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_is_null()`.  */
FZ_FUNCTION int PdfObj::is_null()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_null()\n";
	}
	auto ret = mupdf::mpdf_is_null(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_is_number()`.  */
FZ_FUNCTION int PdfObj::is_number()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_number()\n";
	}
	auto ret = mupdf::mpdf_is_number(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_is_real()`.  */
FZ_FUNCTION int PdfObj::is_real()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_real()\n";
	}
	auto ret = mupdf::mpdf_is_real(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_is_stream()`.  */
FZ_FUNCTION int PdfObj::is_stream()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_stream()\n";
	}
	auto ret = mupdf::mpdf_is_stream(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_is_string()`.  */
FZ_FUNCTION int PdfObj::is_string()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_is_string()\n";
	}
	auto ret = mupdf::mpdf_is_string(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_line_ending_from_name()`.  */
FZ_FUNCTION enum pdf_line_ending PdfObj::line_ending_from_name()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_line_ending_from_name()\n";
	}
	auto ret = mupdf::mpdf_line_ending_from_name(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_load_colorspace()`.  */
FZ_FUNCTION Colorspace PdfObj::load_colorspace()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_colorspace()\n";
	}
	auto ret = mupdf::mpdf_load_colorspace(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_load_embedded_file()`.  */
FZ_FUNCTION Buffer PdfObj::load_embedded_file()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_embedded_file()\n";
	}
	auto ret = mupdf::mpdf_load_embedded_file(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_load_function()`.  */
FZ_FUNCTION PdfFunction PdfObj::load_function(int in, int out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_function()\n";
	}
	auto ret = mupdf::mpdf_load_function(*this, in, out);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_load_raw_stream()`.  */
FZ_FUNCTION Buffer PdfObj::load_raw_stream()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_raw_stream()\n";
	}
	auto ret = mupdf::mpdf_load_raw_stream(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_load_stream()`.  */
FZ_FUNCTION Buffer PdfObj::load_stream()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_stream()\n";
	}
	auto ret = mupdf::mpdf_load_stream(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_load_stream_or_string_as_utf8()`.  */
FZ_FUNCTION char *PdfObj::load_stream_or_string_as_utf8()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_stream_or_string_as_utf8()\n";
	}
	auto ret = mupdf::mpdf_load_stream_or_string_as_utf8(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_lookup_field()`.  */
FZ_FUNCTION PdfObj PdfObj::lookup_field(const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lookup_field()\n";
	}
	auto ret = mupdf::mpdf_lookup_field(*this, name);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_lookup_number()`.  */
FZ_FUNCTION PdfObj PdfObj::lookup_number(int needle)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_lookup_number()\n";
	}
	auto ret = mupdf::mpdf_lookup_number(*this, needle);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_mark_obj()`.  */
FZ_FUNCTION int PdfObj::mark_obj()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_mark_obj()\n";
	}
	auto ret = mupdf::mpdf_mark_obj(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_name_eq()`.  */
FZ_FUNCTION int PdfObj::name_eq(const PdfObj& b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_name_eq()\n";
	}
	auto ret = mupdf::mpdf_name_eq(*this, b);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_new_utf8_from_pdf_stream_obj()`.  */
FZ_FUNCTION char *PdfObj::new_utf8_from_pdf_stream_obj()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_utf8_from_pdf_stream_obj()\n";
	}
	auto ret = mupdf::mpdf_new_utf8_from_pdf_stream_obj(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_new_utf8_from_pdf_string_obj()`.  */
FZ_FUNCTION char *PdfObj::new_utf8_from_pdf_string_obj()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_utf8_from_pdf_string_obj()\n";
	}
	auto ret = mupdf::mpdf_new_utf8_from_pdf_string_obj(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_obj_is_dirty()`.  */
FZ_FUNCTION int PdfObj::obj_is_dirty()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_obj_is_dirty()\n";
	}
	auto ret = mupdf::mpdf_obj_is_dirty(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_obj_is_incremental()`.  */
FZ_FUNCTION int PdfObj::obj_is_incremental()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_obj_is_incremental()\n";
	}
	auto ret = mupdf::mpdf_obj_is_incremental(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_obj_marked()`.  */
FZ_FUNCTION int PdfObj::obj_marked()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_obj_marked()\n";
	}
	auto ret = mupdf::mpdf_obj_marked(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_obj_memo()`.
	
	This method has out-params. Python/C# wrappers look like:
		`obj_memo(int bit)` => `(int, int memo)`
	 */
FZ_FUNCTION int PdfObj::obj_memo(int bit, int *memo)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_obj_memo()\n";
	}
	auto ret = mupdf::mpdf_obj_memo(*this, bit, memo);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_obj_parent_num()`.  */
FZ_FUNCTION int PdfObj::obj_parent_num()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_obj_parent_num()\n";
	}
	auto ret = mupdf::mpdf_obj_parent_num(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_obj_refs()`.  */
FZ_FUNCTION int PdfObj::obj_refs()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_obj_refs()\n";
	}
	auto ret = mupdf::mpdf_obj_refs(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_objcmp()`.  */
FZ_FUNCTION int PdfObj::objcmp(const PdfObj& b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_objcmp()\n";
	}
	auto ret = mupdf::mpdf_objcmp(*this, b);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_objcmp_resolve()`.  */
FZ_FUNCTION int PdfObj::objcmp_resolve(const PdfObj& b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_objcmp_resolve()\n";
	}
	auto ret = mupdf::mpdf_objcmp_resolve(*this, b);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_open_raw_stream()`.  */
FZ_FUNCTION Stream PdfObj::open_raw_stream()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_open_raw_stream()\n";
	}
	auto ret = mupdf::mpdf_open_raw_stream(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_open_stream()`.  */
FZ_FUNCTION Stream PdfObj::open_stream()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_open_stream()\n";
	}
	auto ret = mupdf::mpdf_open_stream(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_page_obj_transform()`.  */
FZ_FUNCTION void PdfObj::page_obj_transform(Rect& page_mediabox, Matrix& page_ctm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_page_obj_transform()\n";
	}
	mupdf::mpdf_page_obj_transform(*this, page_mediabox, page_ctm);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_resolve_indirect()`.  */
FZ_FUNCTION PdfObj PdfObj::resolve_indirect()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_resolve_indirect()\n";
	}
	auto ret = mupdf::mpdf_resolve_indirect(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_resolve_indirect_chain()`.  */
FZ_FUNCTION PdfObj PdfObj::resolve_indirect_chain()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_resolve_indirect_chain()\n";
	}
	auto ret = mupdf::mpdf_resolve_indirect_chain(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_set_int()`.  */
FZ_FUNCTION void PdfObj::set_int(int64_t i)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_int()\n";
	}
	mupdf::mpdf_set_int(*this, i);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_obj_memo()`.  */
FZ_FUNCTION void PdfObj::set_obj_memo(int bit, int memo)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_obj_memo()\n";
	}
	mupdf::mpdf_set_obj_memo(*this, bit, memo);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_obj_parent()`.  */
FZ_FUNCTION void PdfObj::set_obj_parent(int num)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_obj_parent()\n";
	}
	mupdf::mpdf_set_obj_parent(*this, num);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_set_str_len()`.  */
FZ_FUNCTION void PdfObj::set_str_len(size_t newlen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_set_str_len()\n";
	}
	mupdf::mpdf_set_str_len(*this, newlen);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_sort_dict()`.  */
FZ_FUNCTION void PdfObj::sort_dict()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_sort_dict()\n";
	}
	mupdf::mpdf_sort_dict(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_store_item()`.  */
FZ_FUNCTION void PdfObj::store_item(void *val, size_t itemsize)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_store_item()\n";
	}
	mupdf::mpdf_store_item(*this, val, itemsize);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_to_bool()`.  */
FZ_FUNCTION int PdfObj::to_bool()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_bool()\n";
	}
	auto ret = mupdf::mpdf_to_bool(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_to_date()`.  */
FZ_FUNCTION int64_t PdfObj::to_date()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_date()\n";
	}
	auto ret = mupdf::mpdf_to_date(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_to_gen()`.  */
FZ_FUNCTION int PdfObj::to_gen()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_gen()\n";
	}
	auto ret = mupdf::mpdf_to_gen(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_to_int()`.  */
FZ_FUNCTION int PdfObj::to_int()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_int()\n";
	}
	auto ret = mupdf::mpdf_to_int(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_to_int64()`.  */
FZ_FUNCTION int64_t PdfObj::to_int64()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_int64()\n";
	}
	auto ret = mupdf::mpdf_to_int64(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_to_matrix()`.  */
FZ_FUNCTION Matrix PdfObj::to_matrix()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_matrix()\n";
	}
	auto ret = mupdf::mpdf_to_matrix(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_to_name()`.  */
FZ_FUNCTION const char *PdfObj::to_name()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_name()\n";
	}
	auto ret = mupdf::mpdf_to_name(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_to_num()`.  */
FZ_FUNCTION int PdfObj::to_num()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_num()\n";
	}
	auto ret = mupdf::mpdf_to_num(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_to_quad()`.  */
FZ_FUNCTION Quad PdfObj::to_quad(int offset)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_quad()\n";
	}
	auto ret = mupdf::mpdf_to_quad(*this, offset);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_to_real()`.  */
FZ_FUNCTION float PdfObj::to_real()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_real()\n";
	}
	auto ret = mupdf::mpdf_to_real(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_to_rect()`.  */
FZ_FUNCTION Rect PdfObj::to_rect()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_rect()\n";
	}
	auto ret = mupdf::mpdf_to_rect(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_to_str_buf()`.  */
FZ_FUNCTION char *PdfObj::to_str_buf()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_str_buf()\n";
	}
	auto ret = mupdf::mpdf_to_str_buf(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_to_str_len()`.  */
FZ_FUNCTION size_t PdfObj::to_str_len()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_str_len()\n";
	}
	auto ret = mupdf::mpdf_to_str_len(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_to_string()`.
	
	This method has out-params. Python/C# wrappers look like:
		`to_string()` => `(const char *, size_t sizep)`
	 */
FZ_FUNCTION const char *PdfObj::to_string(size_t *sizep)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_string()\n";
	}
	auto ret = mupdf::mpdf_to_string(*this, sizep);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_to_text_string()`.  */
FZ_FUNCTION const char *PdfObj::to_text_string()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_to_text_string()\n";
	}
	auto ret = mupdf::mpdf_to_text_string(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_unmark_obj()`.  */
FZ_FUNCTION void PdfObj::unmark_obj()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_unmark_obj()\n";
	}
	mupdf::mpdf_unmark_obj(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_walk_tree()`.
	
	This method has out-params. Python/C# wrappers look like:
		`walk_tree(pdf_obj *kid_name, void (*arrive)(fz_context *, pdf_obj *, void *, pdf_obj **), void (*leave)(fz_context *, pdf_obj *, void *), void *arg, pdf_obj **names, pdf_obj **values)` => `()`
	 */
FZ_FUNCTION void PdfObj::walk_tree(const PdfObj& kid_name, void (*arrive)(fz_context *, pdf_obj *, void *, pdf_obj **), void (*leave)(fz_context *, pdf_obj *, void *), void *arg, PdfObj& names, PdfObj& values)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_walk_tree()\n";
	}
	mupdf::mpdf_walk_tree(*this, kid_name, arrive, leave, arg, names, values);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_xobject_bbox()`.  */
FZ_FUNCTION Rect PdfObj::xobject_bbox()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xobject_bbox()\n";
	}
	auto ret = mupdf::mpdf_xobject_bbox(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_xobject_colorspace()`.  */
FZ_FUNCTION Colorspace PdfObj::xobject_colorspace()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xobject_colorspace()\n";
	}
	auto ret = mupdf::mpdf_xobject_colorspace(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_xobject_isolated()`.  */
FZ_FUNCTION int PdfObj::xobject_isolated()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xobject_isolated()\n";
	}
	auto ret = mupdf::mpdf_xobject_isolated(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_xobject_knockout()`.  */
FZ_FUNCTION int PdfObj::xobject_knockout()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xobject_knockout()\n";
	}
	auto ret = mupdf::mpdf_xobject_knockout(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_xobject_matrix()`.  */
FZ_FUNCTION Matrix PdfObj::xobject_matrix()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xobject_matrix()\n";
	}
	auto ret = mupdf::mpdf_xobject_matrix(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_xobject_resources()`.  */
FZ_FUNCTION PdfObj PdfObj::xobject_resources()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xobject_resources()\n";
	}
	auto ret = mupdf::mpdf_xobject_resources(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_xobject_transparency()`.  */
FZ_FUNCTION int PdfObj::xobject_transparency()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_xobject_transparency()\n";
	}
	auto ret = mupdf::mpdf_xobject_transparency(*this);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/** Custom method. */
FZ_FUNCTION PdfObj PdfObj::dict_get(int key)
{
	pdf_obj* temp = mupdf::ppdf_dict_get(this->m_internal, (pdf_obj*)(uintptr_t) key);
	mupdf::ppdf_keep_obj(temp);
	auto ret = PdfObj(temp);
	return ret;
}

FZ_FUNCTION PdfObj::PdfObj(pdf_obj* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_PdfObj_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION PdfObj::~PdfObj()
{
	mupdf::ppdf_drop_obj(m_internal);
	if (s_check_refs)
	{
		s_PdfObj_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long PdfObj::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfOcgDescriptor (wrapper for pdf_ocg_descriptor). */

FZ_FUNCTION PdfOcgDescriptor::PdfOcgDescriptor(pdf_ocg_descriptor* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfOcgDescriptor::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfPage (wrapper for pdf_page). */

/* Wrapper for `pdf_bound_page()`.  */
FZ_FUNCTION Rect PdfPage::bound_page()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_bound_page()\n";
	}
	auto ret = mupdf::mpdf_bound_page(*this);
	return ret;
}

/* Wrapper for `pdf_create_annot()`.  */
FZ_FUNCTION PdfAnnot PdfPage::create_annot(enum pdf_annot_type type)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_create_annot()\n";
	}
	auto ret = mupdf::mpdf_create_annot(*this, type);
	return ret;
}

/* Wrapper for `pdf_create_annot_raw()`.  */
FZ_FUNCTION PdfAnnot PdfPage::create_annot_raw(enum pdf_annot_type type)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_create_annot_raw()\n";
	}
	auto ret = mupdf::mpdf_create_annot_raw(*this, type);
	return ret;
}

/* Wrapper for `pdf_create_link()`.  */
FZ_FUNCTION Link PdfPage::create_link(Rect& bbox, const char *uri)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_create_link()\n";
	}
	auto ret = mupdf::mpdf_create_link(*this, bbox, uri);
	return ret;
}

/* Wrapper for `pdf_create_signature_widget()`.  */
FZ_FUNCTION PdfAnnot PdfPage::create_signature_widget(char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_create_signature_widget()\n";
	}
	auto ret = mupdf::mpdf_create_signature_widget(*this, name);
	return ret;
}

/* Wrapper for `pdf_delete_annot()`.  */
FZ_FUNCTION void PdfPage::delete_annot(const PdfAnnot& annot)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_delete_annot()\n";
	}
	mupdf::mpdf_delete_annot(*this, annot);
}

/* Wrapper for `pdf_first_annot()`.  */
FZ_FUNCTION PdfAnnot PdfPage::first_annot()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_first_annot()\n";
	}
	auto ret = mupdf::mpdf_first_annot(*this);
	return ret;
}

/* Wrapper for `pdf_first_widget()`.  */
FZ_FUNCTION PdfAnnot PdfPage::first_widget()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_first_widget()\n";
	}
	auto ret = mupdf::mpdf_first_widget(*this);
	return ret;
}

/* Wrapper for `pdf_load_links()`.  */
FZ_FUNCTION Link PdfPage::load_links()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_links()\n";
	}
	auto ret = mupdf::mpdf_load_links(*this);
	return ret;
}

/* Wrapper for `pdf_new_pixmap_from_page_contents_with_separations_and_usage()`.  */
FZ_FUNCTION Pixmap PdfPage::new_pixmap_from_page_contents_with_separations_and_usage(Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha, const char *usage)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_pixmap_from_page_contents_with_separations_and_usage()\n";
	}
	auto ret = mupdf::mpdf_new_pixmap_from_page_contents_with_separations_and_usage(*this, ctm, cs, seps, alpha, usage);
	return ret;
}

/* Wrapper for `pdf_new_pixmap_from_page_contents_with_usage()`.  */
FZ_FUNCTION Pixmap PdfPage::new_pixmap_from_page_contents_with_usage(Matrix& ctm, const Colorspace& cs, int alpha, const char *usage)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_pixmap_from_page_contents_with_usage()\n";
	}
	auto ret = mupdf::mpdf_new_pixmap_from_page_contents_with_usage(*this, ctm, cs, alpha, usage);
	return ret;
}

/* Wrapper for `pdf_new_pixmap_from_page_with_separations_and_usage()`.  */
FZ_FUNCTION Pixmap PdfPage::new_pixmap_from_page_with_separations_and_usage(Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha, const char *usage)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_pixmap_from_page_with_separations_and_usage()\n";
	}
	auto ret = mupdf::mpdf_new_pixmap_from_page_with_separations_and_usage(*this, ctm, cs, seps, alpha, usage);
	return ret;
}

/* Wrapper for `pdf_new_pixmap_from_page_with_usage()`.  */
FZ_FUNCTION Pixmap PdfPage::new_pixmap_from_page_with_usage(Matrix& ctm, const Colorspace& cs, int alpha, const char *usage)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_pixmap_from_page_with_usage()\n";
	}
	auto ret = mupdf::mpdf_new_pixmap_from_page_with_usage(*this, ctm, cs, alpha, usage);
	return ret;
}

/* Wrapper for `pdf_page_contents()`.  */
FZ_FUNCTION PdfObj PdfPage::page_contents()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_page_contents()\n";
	}
	auto ret = mupdf::mpdf_page_contents(*this);
	return ret;
}

/* Wrapper for `pdf_page_event_close()`.  */
FZ_FUNCTION void PdfPage::page_event_close()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_page_event_close()\n";
	}
	mupdf::mpdf_page_event_close(*this);
}

/* Wrapper for `pdf_page_event_open()`.  */
FZ_FUNCTION void PdfPage::page_event_open()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_page_event_open()\n";
	}
	mupdf::mpdf_page_event_open(*this);
}

/* Wrapper for `pdf_page_group()`.  */
FZ_FUNCTION PdfObj PdfPage::page_group()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_page_group()\n";
	}
	auto ret = mupdf::mpdf_page_group(*this);
	return ret;
}

/* Wrapper for `pdf_page_presentation()`.
	
	This method has out-params. Python/C# wrappers look like:
		`page_presentation(fz_transition *transition)` => `(fz_transition *, float duration)`
	 */
FZ_FUNCTION Transition PdfPage::page_presentation(Transition& transition, float *duration)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_page_presentation()\n";
	}
	auto ret = mupdf::mpdf_page_presentation(*this, transition, duration);
	return ret;
}

/* Wrapper for `pdf_page_resources()`.  */
FZ_FUNCTION PdfObj PdfPage::page_resources()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_page_resources()\n";
	}
	auto ret = mupdf::mpdf_page_resources(*this);
	return ret;
}

/* Wrapper for `pdf_page_separations()`.  */
FZ_FUNCTION Separations PdfPage::page_separations()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_page_separations()\n";
	}
	auto ret = mupdf::mpdf_page_separations(*this);
	return ret;
}

/* Wrapper for `pdf_page_transform()`.  */
FZ_FUNCTION void PdfPage::page_transform(Rect& mediabox, Matrix& ctm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_page_transform()\n";
	}
	mupdf::mpdf_page_transform(*this, mediabox, ctm);
}

/* Wrapper for `pdf_run_page()`.  */
FZ_FUNCTION void PdfPage::run_page(const Device& dev, Matrix& ctm, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_run_page()\n";
	}
	mupdf::mpdf_run_page(*this, dev, ctm, cookie);
}

/* Wrapper for `pdf_run_page_annots()`.  */
FZ_FUNCTION void PdfPage::run_page_annots(const Device& dev, Matrix& ctm, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_run_page_annots()\n";
	}
	mupdf::mpdf_run_page_annots(*this, dev, ctm, cookie);
}

/* Wrapper for `pdf_run_page_annots_with_usage()`.  */
FZ_FUNCTION void PdfPage::run_page_annots_with_usage(const Device& dev, Matrix& ctm, const char *usage, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_run_page_annots_with_usage()\n";
	}
	mupdf::mpdf_run_page_annots_with_usage(*this, dev, ctm, usage, cookie);
}

/* Wrapper for `pdf_run_page_contents()`.  */
FZ_FUNCTION void PdfPage::run_page_contents(const Device& dev, Matrix& ctm, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_run_page_contents()\n";
	}
	mupdf::mpdf_run_page_contents(*this, dev, ctm, cookie);
}

/* Wrapper for `pdf_run_page_contents_with_usage()`.  */
FZ_FUNCTION void PdfPage::run_page_contents_with_usage(const Device& dev, Matrix& ctm, const char *usage, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_run_page_contents_with_usage()\n";
	}
	mupdf::mpdf_run_page_contents_with_usage(*this, dev, ctm, usage, cookie);
}

/* Wrapper for `pdf_run_page_widgets()`.  */
FZ_FUNCTION void PdfPage::run_page_widgets(const Device& dev, Matrix& ctm, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_run_page_widgets()\n";
	}
	mupdf::mpdf_run_page_widgets(*this, dev, ctm, cookie);
}

/* Wrapper for `pdf_run_page_widgets_with_usage()`.  */
FZ_FUNCTION void PdfPage::run_page_widgets_with_usage(const Device& dev, Matrix& ctm, const char *usage, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_run_page_widgets_with_usage()\n";
	}
	mupdf::mpdf_run_page_widgets_with_usage(*this, dev, ctm, usage, cookie);
}

/* Wrapper for `pdf_run_page_with_usage()`.  */
FZ_FUNCTION void PdfPage::run_page_with_usage(const Device& dev, Matrix& ctm, const char *usage, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_run_page_with_usage()\n";
	}
	mupdf::mpdf_run_page_with_usage(*this, dev, ctm, usage, cookie);
}

/* Wrapper for `pdf_update_page()`.  */
FZ_FUNCTION int PdfPage::update_page()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_update_page()\n";
	}
	auto ret = mupdf::mpdf_update_page(*this);
	return ret;
}

/** Custom method. */
FZ_FUNCTION Page PdfPage::super()
{
	return Page( mupdf::keep_page( &m_internal->super));
}

/** Custom method. */
FZ_FUNCTION PdfDocument PdfPage::doc()
{
	return PdfDocument( mupdf::ppdf_keep_document( m_internal->doc));
}

/** Custom method. */
FZ_FUNCTION PdfObj PdfPage::obj()
{
	return PdfObj( mupdf::ppdf_keep_obj( m_internal->obj));
}

FZ_FUNCTION PdfPage::PdfPage(pdf_page* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfPage::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfPattern (wrapper for pdf_pattern). */

static RefsCheck<pdf_pattern, PdfPattern> s_PdfPattern_refs_check(offsetof(pdf_pattern, storable.refs), 32);

/** Copy constructor using `pdf_keep_pattern()`. */
FZ_FUNCTION PdfPattern::PdfPattern(const PdfPattern& rhs)
: m_internal(mupdf::ppdf_keep_pattern(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_pattern(this->m_internal) and mupdf::ppdf_keep_pattern(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_PdfPattern_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `pdf_keep_pattern()` and `pdf_drop_pattern()`. */
FZ_FUNCTION PdfPattern& PdfPattern::operator=(const PdfPattern& rhs)
{
	mupdf::ppdf_drop_pattern(this->m_internal);
	mupdf::ppdf_keep_pattern(rhs.m_internal);
	if (s_check_refs)
	{
		s_PdfPattern_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_PdfPattern_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

FZ_FUNCTION PdfPattern::PdfPattern(pdf_pattern* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_PdfPattern_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION PdfPattern::~PdfPattern()
{
	mupdf::ppdf_drop_pattern(m_internal);
	if (s_check_refs)
	{
		s_PdfPattern_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long PdfPattern::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfPkcs7DistinguishedName (wrapper for pdf_pkcs7_distinguished_name). */

/* Wrapper for `pdf_signature_drop_distinguished_name()`.  */
FZ_FUNCTION void PdfPkcs7DistinguishedName::signature_drop_distinguished_name()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_signature_drop_distinguished_name()\n";
	}
	mupdf::mpdf_signature_drop_distinguished_name(*this);
}

/* Wrapper for `pdf_signature_format_distinguished_name()`.  */
FZ_FUNCTION char *PdfPkcs7DistinguishedName::signature_format_distinguished_name()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_signature_format_distinguished_name()\n";
	}
	auto ret = mupdf::mpdf_signature_format_distinguished_name(*this);
	return ret;
}

FZ_FUNCTION PdfPkcs7DistinguishedName::PdfPkcs7DistinguishedName(pdf_pkcs7_distinguished_name* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfPkcs7DistinguishedName::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfPkcs7Signer (wrapper for pdf_pkcs7_signer). */

FZ_FUNCTION PdfPkcs7Signer::PdfPkcs7Signer(pdf_pkcs7_signer* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfPkcs7Signer::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfPkcs7Verifier (wrapper for pdf_pkcs7_verifier). */

/* Wrapper for `pdf_check_signature()`.  */
FZ_FUNCTION int PdfPkcs7Verifier::check_signature(const PdfDocument& doc, const PdfObj& signature, char *ebuf, size_t ebufsize)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_check_signature()\n";
	}
	auto ret = mupdf::mpdf_check_signature(*this, doc, signature, ebuf, ebufsize);
	return ret;
}

FZ_FUNCTION PdfPkcs7Verifier::PdfPkcs7Verifier(pdf_pkcs7_verifier* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfPkcs7Verifier::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfProcessor (wrapper for pdf_processor). */

static RefsCheck<pdf_processor, PdfProcessor> s_PdfProcessor_refs_check(offsetof(pdf_processor, refs), 32);

/* Constructor using `pdf_new_buffer_processor()`. */
FZ_FUNCTION PdfProcessor::PdfProcessor(const Buffer& buffer, int ahxencode)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_buffer_processor()\n";
	}
	this->m_internal = mupdf::ppdf_new_buffer_processor(buffer.m_internal, ahxencode);
	if (s_check_refs)
	{
		s_PdfProcessor_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `pdf_new_filter_processor()`. */
FZ_FUNCTION PdfProcessor::PdfProcessor(const PdfDocument& doc, const PdfProcessor& chain, const PdfObj& old_res, const PdfObj& new_res, int struct_parents, Matrix& transform, PdfFilterOptions& filter)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_filter_processor()\n";
	}
	this->m_internal = mupdf::ppdf_new_filter_processor(doc.m_internal, chain.m_internal, old_res.m_internal, new_res.m_internal, struct_parents, *(fz_matrix*) &transform.a, (pdf_filter_options *) &filter.opaque);
	if (s_check_refs)
	{
		s_PdfProcessor_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `pdf_new_output_processor()`. */
FZ_FUNCTION PdfProcessor::PdfProcessor(const Output& out, int ahxencode)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_output_processor()\n";
	}
	this->m_internal = mupdf::ppdf_new_output_processor(out.m_internal, ahxencode);
	if (s_check_refs)
	{
		s_PdfProcessor_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `pdf_new_run_processor()`. */
FZ_FUNCTION PdfProcessor::PdfProcessor(const Device& dev, Matrix& ctm, const char *usage, const PdfGstate& gstate, const DefaultColorspaces& default_cs, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_run_processor()\n";
	}
	this->m_internal = mupdf::ppdf_new_run_processor(dev.m_internal, *(fz_matrix*) &ctm.a, usage, gstate.m_internal, default_cs.m_internal, &cookie.m_internal);
	if (s_check_refs)
	{
		s_PdfProcessor_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom constructor. */
FZ_FUNCTION PdfProcessor::PdfProcessor()
: m_internal( NULL)
{
	if (s_check_refs)
	{
		s_PdfProcessor_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	if (s_check_refs)
	{
		s_PdfProcessor_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Copy constructor using `pdf_keep_processor()`. */
FZ_FUNCTION PdfProcessor::PdfProcessor(const PdfProcessor& rhs)
: m_internal(mupdf::ppdf_keep_processor(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_drop_processor(this->m_internal) and mupdf::ppdf_keep_processor(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_PdfProcessor_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `pdf_keep_processor()` and `pdf_drop_processor()`. */
FZ_FUNCTION PdfProcessor& PdfProcessor::operator=(const PdfProcessor& rhs)
{
	mupdf::ppdf_drop_processor(this->m_internal);
	mupdf::ppdf_keep_processor(rhs.m_internal);
	if (s_check_refs)
	{
		s_PdfProcessor_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_PdfProcessor_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/* Wrapper for `pdf_close_processor()`.  */
FZ_FUNCTION void PdfProcessor::close_processor()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_close_processor()\n";
	}
	mupdf::mpdf_close_processor(*this);
	if (s_check_refs)
	{
		s_PdfProcessor_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_process_annot()`.  */
FZ_FUNCTION void PdfProcessor::process_annot(const PdfAnnot& annot, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_process_annot()\n";
	}
	mupdf::mpdf_process_annot(*this, annot, cookie);
	if (s_check_refs)
	{
		s_PdfProcessor_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_process_contents()`.  */
FZ_FUNCTION void PdfProcessor::process_contents(const PdfDocument& doc, const PdfObj& obj, const PdfObj& res, Cookie& cookie)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_process_contents()\n";
	}
	mupdf::mpdf_process_contents(*this, doc, obj, res, cookie);
	if (s_check_refs)
	{
		s_PdfProcessor_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_process_glyph()`.  */
FZ_FUNCTION void PdfProcessor::process_glyph(const PdfDocument& doc, const PdfObj& resources, const Buffer& contents)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_process_glyph()\n";
	}
	mupdf::mpdf_process_glyph(*this, doc, resources, contents);
	if (s_check_refs)
	{
		s_PdfProcessor_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION PdfProcessor::PdfProcessor(pdf_processor* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_PdfProcessor_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION PdfProcessor::~PdfProcessor()
{
	mupdf::ppdf_drop_processor(m_internal);
	if (s_check_refs)
	{
		s_PdfProcessor_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long PdfProcessor::m_internal_value()
{
	return (uintptr_t) m_internal;
}

/* Implementation of methods for `PdfProcessor2`, virtual_fnptrs wrapper for `pdf_processor`). */


FZ_FUNCTION PdfProcessor2::PdfProcessor2()
{

	m_internal = (pdf_processor*) mupdf::ppdf_new_processor(sizeof(*m_internal) + sizeof(PdfProcessor2*));
	*((PdfProcessor2**) (m_internal + 1)) = this;
	
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2::PdfProcessor2(); this=" << this << "\n";
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2::PdfProcessor2(): m_internal=" << m_internal << "\n";
		PdfProcessor2* self = (*(PdfProcessor2**) (m_internal + 1));
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2::PdfProcessor2(): self=" << self << "\n";
	}
}
/* Static callback, calls self->close_processor(). */
static void PdfProcessor2_s_close_processor(fz_context *arg_0, pdf_processor *arg_1)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_close_processor(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->close_processor();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->drop_processor(). */
static void PdfProcessor2_s_drop_processor(fz_context *arg_0, pdf_processor *arg_1)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_drop_processor(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->drop_processor();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_w(). */
static void PdfProcessor2_s_op_w(fz_context *arg_0, pdf_processor *arg_1, float arg_2)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_w(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_w(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_j(). */
static void PdfProcessor2_s_op_j(fz_context *arg_0, pdf_processor *arg_1, int arg_2)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_j(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_j(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_J(). */
static void PdfProcessor2_s_op_J(fz_context *arg_0, pdf_processor *arg_1, int arg_2)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_J(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_J(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_M(). */
static void PdfProcessor2_s_op_M(fz_context *arg_0, pdf_processor *arg_1, float arg_2)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_M(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_M(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_d(). */
static void PdfProcessor2_s_op_d(fz_context *arg_0, pdf_processor *arg_1, pdf_obj *arg_2, float arg_3)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_d(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_d(arg_2, arg_3);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_ri(). */
static void PdfProcessor2_s_op_ri(fz_context *arg_0, pdf_processor *arg_1, const char *arg_2)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_ri(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_ri(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_i(). */
static void PdfProcessor2_s_op_i(fz_context *arg_0, pdf_processor *arg_1, float arg_2)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_i(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_i(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_gs_begin(). */
static void PdfProcessor2_s_op_gs_begin(fz_context *arg_0, pdf_processor *arg_1, const char *arg_2, pdf_obj *arg_3)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_gs_begin(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_gs_begin(arg_2, arg_3);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_gs_BM(). */
static void PdfProcessor2_s_op_gs_BM(fz_context *arg_0, pdf_processor *arg_1, const char *arg_2)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_gs_BM(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_gs_BM(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_gs_ca(). */
static void PdfProcessor2_s_op_gs_ca(fz_context *arg_0, pdf_processor *arg_1, float arg_2)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_gs_ca(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_gs_ca(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_gs_CA(). */
static void PdfProcessor2_s_op_gs_CA(fz_context *arg_0, pdf_processor *arg_1, float arg_2)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_gs_CA(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_gs_CA(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_gs_SMask(). */
static void PdfProcessor2_s_op_gs_SMask(fz_context *arg_0, pdf_processor *arg_1, pdf_obj *arg_2, pdf_obj *arg_3, float *arg_4, int arg_5)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_gs_SMask(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_gs_SMask(arg_2, arg_3, arg_4, arg_5);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_gs_end(). */
static void PdfProcessor2_s_op_gs_end(fz_context *arg_0, pdf_processor *arg_1)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_gs_end(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_gs_end();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_q(). */
static void PdfProcessor2_s_op_q(fz_context *arg_0, pdf_processor *arg_1)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_q(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_q();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_Q(). */
static void PdfProcessor2_s_op_Q(fz_context *arg_0, pdf_processor *arg_1)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_Q(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_Q();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_cm(). */
static void PdfProcessor2_s_op_cm(fz_context *arg_0, pdf_processor *arg_1, float arg_2, float arg_3, float arg_4, float arg_5, float arg_6, float arg_7)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_cm(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_cm(arg_2, arg_3, arg_4, arg_5, arg_6, arg_7);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_m(). */
static void PdfProcessor2_s_op_m(fz_context *arg_0, pdf_processor *arg_1, float arg_2, float arg_3)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_m(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_m(arg_2, arg_3);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_l(). */
static void PdfProcessor2_s_op_l(fz_context *arg_0, pdf_processor *arg_1, float arg_2, float arg_3)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_l(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_l(arg_2, arg_3);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_c(). */
static void PdfProcessor2_s_op_c(fz_context *arg_0, pdf_processor *arg_1, float arg_2, float arg_3, float arg_4, float arg_5, float arg_6, float arg_7)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_c(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_c(arg_2, arg_3, arg_4, arg_5, arg_6, arg_7);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_v(). */
static void PdfProcessor2_s_op_v(fz_context *arg_0, pdf_processor *arg_1, float arg_2, float arg_3, float arg_4, float arg_5)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_v(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_v(arg_2, arg_3, arg_4, arg_5);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_y(). */
static void PdfProcessor2_s_op_y(fz_context *arg_0, pdf_processor *arg_1, float arg_2, float arg_3, float arg_4, float arg_5)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_y(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_y(arg_2, arg_3, arg_4, arg_5);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_h(). */
static void PdfProcessor2_s_op_h(fz_context *arg_0, pdf_processor *arg_1)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_h(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_h();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_re(). */
static void PdfProcessor2_s_op_re(fz_context *arg_0, pdf_processor *arg_1, float arg_2, float arg_3, float arg_4, float arg_5)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_re(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_re(arg_2, arg_3, arg_4, arg_5);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_S(). */
static void PdfProcessor2_s_op_S(fz_context *arg_0, pdf_processor *arg_1)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_S(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_S();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_s(). */
static void PdfProcessor2_s_op_s(fz_context *arg_0, pdf_processor *arg_1)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_s(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_s();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_F(). */
static void PdfProcessor2_s_op_F(fz_context *arg_0, pdf_processor *arg_1)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_F(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_F();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_f(). */
static void PdfProcessor2_s_op_f(fz_context *arg_0, pdf_processor *arg_1)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_f(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_f();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_fstar(). */
static void PdfProcessor2_s_op_fstar(fz_context *arg_0, pdf_processor *arg_1)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_fstar(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_fstar();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_B(). */
static void PdfProcessor2_s_op_B(fz_context *arg_0, pdf_processor *arg_1)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_B(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_B();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_Bstar(). */
static void PdfProcessor2_s_op_Bstar(fz_context *arg_0, pdf_processor *arg_1)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_Bstar(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_Bstar();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_b(). */
static void PdfProcessor2_s_op_b(fz_context *arg_0, pdf_processor *arg_1)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_b(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_b();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_bstar(). */
static void PdfProcessor2_s_op_bstar(fz_context *arg_0, pdf_processor *arg_1)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_bstar(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_bstar();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_n(). */
static void PdfProcessor2_s_op_n(fz_context *arg_0, pdf_processor *arg_1)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_n(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_n();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_W(). */
static void PdfProcessor2_s_op_W(fz_context *arg_0, pdf_processor *arg_1)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_W(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_W();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_Wstar(). */
static void PdfProcessor2_s_op_Wstar(fz_context *arg_0, pdf_processor *arg_1)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_Wstar(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_Wstar();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_BT(). */
static void PdfProcessor2_s_op_BT(fz_context *arg_0, pdf_processor *arg_1)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_BT(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_BT();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_ET(). */
static void PdfProcessor2_s_op_ET(fz_context *arg_0, pdf_processor *arg_1)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_ET(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_ET();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_Tc(). */
static void PdfProcessor2_s_op_Tc(fz_context *arg_0, pdf_processor *arg_1, float arg_2)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_Tc(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_Tc(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_Tw(). */
static void PdfProcessor2_s_op_Tw(fz_context *arg_0, pdf_processor *arg_1, float arg_2)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_Tw(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_Tw(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_Tz(). */
static void PdfProcessor2_s_op_Tz(fz_context *arg_0, pdf_processor *arg_1, float arg_2)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_Tz(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_Tz(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_TL(). */
static void PdfProcessor2_s_op_TL(fz_context *arg_0, pdf_processor *arg_1, float arg_2)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_TL(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_TL(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_Tf(). */
static void PdfProcessor2_s_op_Tf(fz_context *arg_0, pdf_processor *arg_1, const char *arg_2, pdf_font_desc *arg_3, float arg_4)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_Tf(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_Tf(arg_2, arg_3, arg_4);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_Tr(). */
static void PdfProcessor2_s_op_Tr(fz_context *arg_0, pdf_processor *arg_1, int arg_2)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_Tr(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_Tr(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_Ts(). */
static void PdfProcessor2_s_op_Ts(fz_context *arg_0, pdf_processor *arg_1, float arg_2)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_Ts(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_Ts(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_Td(). */
static void PdfProcessor2_s_op_Td(fz_context *arg_0, pdf_processor *arg_1, float arg_2, float arg_3)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_Td(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_Td(arg_2, arg_3);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_TD(). */
static void PdfProcessor2_s_op_TD(fz_context *arg_0, pdf_processor *arg_1, float arg_2, float arg_3)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_TD(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_TD(arg_2, arg_3);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_Tm(). */
static void PdfProcessor2_s_op_Tm(fz_context *arg_0, pdf_processor *arg_1, float arg_2, float arg_3, float arg_4, float arg_5, float arg_6, float arg_7)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_Tm(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_Tm(arg_2, arg_3, arg_4, arg_5, arg_6, arg_7);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_Tstar(). */
static void PdfProcessor2_s_op_Tstar(fz_context *arg_0, pdf_processor *arg_1)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_Tstar(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_Tstar();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_TJ(). */
static void PdfProcessor2_s_op_TJ(fz_context *arg_0, pdf_processor *arg_1, pdf_obj *arg_2)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_TJ(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_TJ(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_Tj(). */
static void PdfProcessor2_s_op_Tj(fz_context *arg_0, pdf_processor *arg_1, char *arg_2, size_t arg_3)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_Tj(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_Tj(arg_2, arg_3);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_squote(). */
static void PdfProcessor2_s_op_squote(fz_context *arg_0, pdf_processor *arg_1, char *arg_2, size_t arg_3)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_squote(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_squote(arg_2, arg_3);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_dquote(). */
static void PdfProcessor2_s_op_dquote(fz_context *arg_0, pdf_processor *arg_1, float arg_2, float arg_3, char *arg_4, size_t arg_5)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_dquote(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_dquote(arg_2, arg_3, arg_4, arg_5);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_d0(). */
static void PdfProcessor2_s_op_d0(fz_context *arg_0, pdf_processor *arg_1, float arg_2, float arg_3)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_d0(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_d0(arg_2, arg_3);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_d1(). */
static void PdfProcessor2_s_op_d1(fz_context *arg_0, pdf_processor *arg_1, float arg_2, float arg_3, float arg_4, float arg_5, float arg_6, float arg_7)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_d1(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_d1(arg_2, arg_3, arg_4, arg_5, arg_6, arg_7);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_CS(). */
static void PdfProcessor2_s_op_CS(fz_context *arg_0, pdf_processor *arg_1, const char *arg_2, fz_colorspace *arg_3)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_CS(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_CS(arg_2, arg_3);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_cs(). */
static void PdfProcessor2_s_op_cs(fz_context *arg_0, pdf_processor *arg_1, const char *arg_2, fz_colorspace *arg_3)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_cs(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_cs(arg_2, arg_3);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_SC_pattern(). */
static void PdfProcessor2_s_op_SC_pattern(fz_context *arg_0, pdf_processor *arg_1, const char *arg_2, pdf_pattern *arg_3, int arg_4, float *arg_5)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_SC_pattern(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_SC_pattern(arg_2, arg_3, arg_4, arg_5);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_sc_pattern(). */
static void PdfProcessor2_s_op_sc_pattern(fz_context *arg_0, pdf_processor *arg_1, const char *arg_2, pdf_pattern *arg_3, int arg_4, float *arg_5)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_sc_pattern(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_sc_pattern(arg_2, arg_3, arg_4, arg_5);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_SC_shade(). */
static void PdfProcessor2_s_op_SC_shade(fz_context *arg_0, pdf_processor *arg_1, const char *arg_2, fz_shade *arg_3)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_SC_shade(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_SC_shade(arg_2, arg_3);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_sc_shade(). */
static void PdfProcessor2_s_op_sc_shade(fz_context *arg_0, pdf_processor *arg_1, const char *arg_2, fz_shade *arg_3)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_sc_shade(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_sc_shade(arg_2, arg_3);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_SC_color(). */
static void PdfProcessor2_s_op_SC_color(fz_context *arg_0, pdf_processor *arg_1, int arg_2, float *arg_3)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_SC_color(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_SC_color(arg_2, arg_3);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_sc_color(). */
static void PdfProcessor2_s_op_sc_color(fz_context *arg_0, pdf_processor *arg_1, int arg_2, float *arg_3)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_sc_color(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_sc_color(arg_2, arg_3);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_G(). */
static void PdfProcessor2_s_op_G(fz_context *arg_0, pdf_processor *arg_1, float arg_2)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_G(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_G(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_g(). */
static void PdfProcessor2_s_op_g(fz_context *arg_0, pdf_processor *arg_1, float arg_2)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_g(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_g(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_RG(). */
static void PdfProcessor2_s_op_RG(fz_context *arg_0, pdf_processor *arg_1, float arg_2, float arg_3, float arg_4)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_RG(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_RG(arg_2, arg_3, arg_4);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_rg(). */
static void PdfProcessor2_s_op_rg(fz_context *arg_0, pdf_processor *arg_1, float arg_2, float arg_3, float arg_4)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_rg(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_rg(arg_2, arg_3, arg_4);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_K(). */
static void PdfProcessor2_s_op_K(fz_context *arg_0, pdf_processor *arg_1, float arg_2, float arg_3, float arg_4, float arg_5)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_K(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_K(arg_2, arg_3, arg_4, arg_5);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_k(). */
static void PdfProcessor2_s_op_k(fz_context *arg_0, pdf_processor *arg_1, float arg_2, float arg_3, float arg_4, float arg_5)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_k(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_k(arg_2, arg_3, arg_4, arg_5);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_BI(). */
static void PdfProcessor2_s_op_BI(fz_context *arg_0, pdf_processor *arg_1, fz_image *arg_2, const char *arg_3)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_BI(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_BI(arg_2, arg_3);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_sh(). */
static void PdfProcessor2_s_op_sh(fz_context *arg_0, pdf_processor *arg_1, const char *arg_2, fz_shade *arg_3)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_sh(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_sh(arg_2, arg_3);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_Do_image(). */
static void PdfProcessor2_s_op_Do_image(fz_context *arg_0, pdf_processor *arg_1, const char *arg_2, fz_image *arg_3)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_Do_image(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_Do_image(arg_2, arg_3);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_Do_form(). */
static void PdfProcessor2_s_op_Do_form(fz_context *arg_0, pdf_processor *arg_1, const char *arg_2, pdf_obj *arg_3, pdf_obj *arg_4)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_Do_form(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_Do_form(arg_2, arg_3, arg_4);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_MP(). */
static void PdfProcessor2_s_op_MP(fz_context *arg_0, pdf_processor *arg_1, const char *arg_2)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_MP(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_MP(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_DP(). */
static void PdfProcessor2_s_op_DP(fz_context *arg_0, pdf_processor *arg_1, const char *arg_2, pdf_obj *arg_3, pdf_obj *arg_4)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_DP(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_DP(arg_2, arg_3, arg_4);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_BMC(). */
static void PdfProcessor2_s_op_BMC(fz_context *arg_0, pdf_processor *arg_1, const char *arg_2)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_BMC(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_BMC(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_BDC(). */
static void PdfProcessor2_s_op_BDC(fz_context *arg_0, pdf_processor *arg_1, const char *arg_2, pdf_obj *arg_3, pdf_obj *arg_4)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_BDC(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_BDC(arg_2, arg_3, arg_4);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_EMC(). */
static void PdfProcessor2_s_op_EMC(fz_context *arg_0, pdf_processor *arg_1)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_EMC(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_EMC();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_BX(). */
static void PdfProcessor2_s_op_BX(fz_context *arg_0, pdf_processor *arg_1)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_BX(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_BX();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_EX(). */
static void PdfProcessor2_s_op_EX(fz_context *arg_0, pdf_processor *arg_1)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_EX(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_EX();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_gs_OP(). */
static void PdfProcessor2_s_op_gs_OP(fz_context *arg_0, pdf_processor *arg_1, int arg_2)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_gs_OP(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_gs_OP(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_gs_op(). */
static void PdfProcessor2_s_op_gs_op(fz_context *arg_0, pdf_processor *arg_1, int arg_2)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_gs_op(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_gs_op(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_gs_OPM(). */
static void PdfProcessor2_s_op_gs_OPM(fz_context *arg_0, pdf_processor *arg_1, int arg_2)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_gs_OPM(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_gs_OPM(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_gs_UseBlackPtComp(). */
static void PdfProcessor2_s_op_gs_UseBlackPtComp(fz_context *arg_0, pdf_processor *arg_1, pdf_obj *arg_2)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_gs_UseBlackPtComp(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_gs_UseBlackPtComp(arg_2);
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
/* Static callback, calls self->op_END(). */
static void PdfProcessor2_s_op_END(fz_context *arg_0, pdf_processor *arg_1)
{
	PdfProcessor2* self = (*(PdfProcessor2**) (arg_1 + 1));
	if (s_trace_director)
	{
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": PdfProcessor2_s_op_END(): arg_1=" << arg_1 << " self=" << self << "\n";
	}
	try
	{
		return self->op_END();
	}
	catch (std::exception& e)
	{
		fz_throw(arg_0, FZ_ERROR_GENERIC, "%s", e.what());
	}
}
FZ_FUNCTION void PdfProcessor2::use_virtual_close_processor( bool use)
{
	m_internal->close_processor = (use) ? PdfProcessor2_s_close_processor : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_drop_processor( bool use)
{
	m_internal->drop_processor = (use) ? PdfProcessor2_s_drop_processor : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_w( bool use)
{
	m_internal->op_w = (use) ? PdfProcessor2_s_op_w : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_j( bool use)
{
	m_internal->op_j = (use) ? PdfProcessor2_s_op_j : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_J( bool use)
{
	m_internal->op_J = (use) ? PdfProcessor2_s_op_J : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_M( bool use)
{
	m_internal->op_M = (use) ? PdfProcessor2_s_op_M : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_d( bool use)
{
	m_internal->op_d = (use) ? PdfProcessor2_s_op_d : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_ri( bool use)
{
	m_internal->op_ri = (use) ? PdfProcessor2_s_op_ri : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_i( bool use)
{
	m_internal->op_i = (use) ? PdfProcessor2_s_op_i : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_gs_begin( bool use)
{
	m_internal->op_gs_begin = (use) ? PdfProcessor2_s_op_gs_begin : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_gs_BM( bool use)
{
	m_internal->op_gs_BM = (use) ? PdfProcessor2_s_op_gs_BM : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_gs_ca( bool use)
{
	m_internal->op_gs_ca = (use) ? PdfProcessor2_s_op_gs_ca : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_gs_CA( bool use)
{
	m_internal->op_gs_CA = (use) ? PdfProcessor2_s_op_gs_CA : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_gs_SMask( bool use)
{
	m_internal->op_gs_SMask = (use) ? PdfProcessor2_s_op_gs_SMask : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_gs_end( bool use)
{
	m_internal->op_gs_end = (use) ? PdfProcessor2_s_op_gs_end : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_q( bool use)
{
	m_internal->op_q = (use) ? PdfProcessor2_s_op_q : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_Q( bool use)
{
	m_internal->op_Q = (use) ? PdfProcessor2_s_op_Q : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_cm( bool use)
{
	m_internal->op_cm = (use) ? PdfProcessor2_s_op_cm : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_m( bool use)
{
	m_internal->op_m = (use) ? PdfProcessor2_s_op_m : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_l( bool use)
{
	m_internal->op_l = (use) ? PdfProcessor2_s_op_l : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_c( bool use)
{
	m_internal->op_c = (use) ? PdfProcessor2_s_op_c : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_v( bool use)
{
	m_internal->op_v = (use) ? PdfProcessor2_s_op_v : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_y( bool use)
{
	m_internal->op_y = (use) ? PdfProcessor2_s_op_y : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_h( bool use)
{
	m_internal->op_h = (use) ? PdfProcessor2_s_op_h : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_re( bool use)
{
	m_internal->op_re = (use) ? PdfProcessor2_s_op_re : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_S( bool use)
{
	m_internal->op_S = (use) ? PdfProcessor2_s_op_S : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_s( bool use)
{
	m_internal->op_s = (use) ? PdfProcessor2_s_op_s : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_F( bool use)
{
	m_internal->op_F = (use) ? PdfProcessor2_s_op_F : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_f( bool use)
{
	m_internal->op_f = (use) ? PdfProcessor2_s_op_f : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_fstar( bool use)
{
	m_internal->op_fstar = (use) ? PdfProcessor2_s_op_fstar : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_B( bool use)
{
	m_internal->op_B = (use) ? PdfProcessor2_s_op_B : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_Bstar( bool use)
{
	m_internal->op_Bstar = (use) ? PdfProcessor2_s_op_Bstar : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_b( bool use)
{
	m_internal->op_b = (use) ? PdfProcessor2_s_op_b : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_bstar( bool use)
{
	m_internal->op_bstar = (use) ? PdfProcessor2_s_op_bstar : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_n( bool use)
{
	m_internal->op_n = (use) ? PdfProcessor2_s_op_n : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_W( bool use)
{
	m_internal->op_W = (use) ? PdfProcessor2_s_op_W : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_Wstar( bool use)
{
	m_internal->op_Wstar = (use) ? PdfProcessor2_s_op_Wstar : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_BT( bool use)
{
	m_internal->op_BT = (use) ? PdfProcessor2_s_op_BT : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_ET( bool use)
{
	m_internal->op_ET = (use) ? PdfProcessor2_s_op_ET : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_Tc( bool use)
{
	m_internal->op_Tc = (use) ? PdfProcessor2_s_op_Tc : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_Tw( bool use)
{
	m_internal->op_Tw = (use) ? PdfProcessor2_s_op_Tw : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_Tz( bool use)
{
	m_internal->op_Tz = (use) ? PdfProcessor2_s_op_Tz : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_TL( bool use)
{
	m_internal->op_TL = (use) ? PdfProcessor2_s_op_TL : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_Tf( bool use)
{
	m_internal->op_Tf = (use) ? PdfProcessor2_s_op_Tf : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_Tr( bool use)
{
	m_internal->op_Tr = (use) ? PdfProcessor2_s_op_Tr : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_Ts( bool use)
{
	m_internal->op_Ts = (use) ? PdfProcessor2_s_op_Ts : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_Td( bool use)
{
	m_internal->op_Td = (use) ? PdfProcessor2_s_op_Td : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_TD( bool use)
{
	m_internal->op_TD = (use) ? PdfProcessor2_s_op_TD : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_Tm( bool use)
{
	m_internal->op_Tm = (use) ? PdfProcessor2_s_op_Tm : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_Tstar( bool use)
{
	m_internal->op_Tstar = (use) ? PdfProcessor2_s_op_Tstar : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_TJ( bool use)
{
	m_internal->op_TJ = (use) ? PdfProcessor2_s_op_TJ : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_Tj( bool use)
{
	m_internal->op_Tj = (use) ? PdfProcessor2_s_op_Tj : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_squote( bool use)
{
	m_internal->op_squote = (use) ? PdfProcessor2_s_op_squote : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_dquote( bool use)
{
	m_internal->op_dquote = (use) ? PdfProcessor2_s_op_dquote : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_d0( bool use)
{
	m_internal->op_d0 = (use) ? PdfProcessor2_s_op_d0 : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_d1( bool use)
{
	m_internal->op_d1 = (use) ? PdfProcessor2_s_op_d1 : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_CS( bool use)
{
	m_internal->op_CS = (use) ? PdfProcessor2_s_op_CS : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_cs( bool use)
{
	m_internal->op_cs = (use) ? PdfProcessor2_s_op_cs : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_SC_pattern( bool use)
{
	m_internal->op_SC_pattern = (use) ? PdfProcessor2_s_op_SC_pattern : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_sc_pattern( bool use)
{
	m_internal->op_sc_pattern = (use) ? PdfProcessor2_s_op_sc_pattern : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_SC_shade( bool use)
{
	m_internal->op_SC_shade = (use) ? PdfProcessor2_s_op_SC_shade : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_sc_shade( bool use)
{
	m_internal->op_sc_shade = (use) ? PdfProcessor2_s_op_sc_shade : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_SC_color( bool use)
{
	m_internal->op_SC_color = (use) ? PdfProcessor2_s_op_SC_color : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_sc_color( bool use)
{
	m_internal->op_sc_color = (use) ? PdfProcessor2_s_op_sc_color : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_G( bool use)
{
	m_internal->op_G = (use) ? PdfProcessor2_s_op_G : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_g( bool use)
{
	m_internal->op_g = (use) ? PdfProcessor2_s_op_g : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_RG( bool use)
{
	m_internal->op_RG = (use) ? PdfProcessor2_s_op_RG : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_rg( bool use)
{
	m_internal->op_rg = (use) ? PdfProcessor2_s_op_rg : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_K( bool use)
{
	m_internal->op_K = (use) ? PdfProcessor2_s_op_K : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_k( bool use)
{
	m_internal->op_k = (use) ? PdfProcessor2_s_op_k : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_BI( bool use)
{
	m_internal->op_BI = (use) ? PdfProcessor2_s_op_BI : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_sh( bool use)
{
	m_internal->op_sh = (use) ? PdfProcessor2_s_op_sh : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_Do_image( bool use)
{
	m_internal->op_Do_image = (use) ? PdfProcessor2_s_op_Do_image : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_Do_form( bool use)
{
	m_internal->op_Do_form = (use) ? PdfProcessor2_s_op_Do_form : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_MP( bool use)
{
	m_internal->op_MP = (use) ? PdfProcessor2_s_op_MP : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_DP( bool use)
{
	m_internal->op_DP = (use) ? PdfProcessor2_s_op_DP : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_BMC( bool use)
{
	m_internal->op_BMC = (use) ? PdfProcessor2_s_op_BMC : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_BDC( bool use)
{
	m_internal->op_BDC = (use) ? PdfProcessor2_s_op_BDC : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_EMC( bool use)
{
	m_internal->op_EMC = (use) ? PdfProcessor2_s_op_EMC : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_BX( bool use)
{
	m_internal->op_BX = (use) ? PdfProcessor2_s_op_BX : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_EX( bool use)
{
	m_internal->op_EX = (use) ? PdfProcessor2_s_op_EX : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_gs_OP( bool use)
{
	m_internal->op_gs_OP = (use) ? PdfProcessor2_s_op_gs_OP : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_gs_op( bool use)
{
	m_internal->op_gs_op = (use) ? PdfProcessor2_s_op_gs_op : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_gs_OPM( bool use)
{
	m_internal->op_gs_OPM = (use) ? PdfProcessor2_s_op_gs_OPM : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_gs_UseBlackPtComp( bool use)
{
	m_internal->op_gs_UseBlackPtComp = (use) ? PdfProcessor2_s_op_gs_UseBlackPtComp : nullptr;
}
FZ_FUNCTION void PdfProcessor2::use_virtual_op_END( bool use)
{
	m_internal->op_END = (use) ? PdfProcessor2_s_op_END : nullptr;
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::close_processor()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::close_processor().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::drop_processor()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::drop_processor().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_w(float arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_w().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_j(int arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_j().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_J(int arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_J().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_M(float arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_M().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_d(struct pdf_obj *arg_2, float arg_3)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_d().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_ri(const char *arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_ri().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_i(float arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_i().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_gs_begin(const char *arg_2, struct pdf_obj *arg_3)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_gs_begin().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_gs_BM(const char *arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_gs_BM().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_gs_ca(float arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_gs_ca().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_gs_CA(float arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_gs_CA().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_gs_SMask(struct pdf_obj *arg_2, struct pdf_obj *arg_3, float *arg_4, int arg_5)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_gs_SMask().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_gs_end()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_gs_end().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_q()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_q().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_Q()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_Q().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_cm(float arg_2, float arg_3, float arg_4, float arg_5, float arg_6, float arg_7)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_cm().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_m(float arg_2, float arg_3)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_m().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_l(float arg_2, float arg_3)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_l().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_c(float arg_2, float arg_3, float arg_4, float arg_5, float arg_6, float arg_7)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_c().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_v(float arg_2, float arg_3, float arg_4, float arg_5)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_v().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_y(float arg_2, float arg_3, float arg_4, float arg_5)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_y().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_h()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_h().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_re(float arg_2, float arg_3, float arg_4, float arg_5)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_re().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_S()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_S().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_s()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_s().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_F()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_F().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_f()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_f().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_fstar()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_fstar().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_B()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_B().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_Bstar()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_Bstar().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_b()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_b().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_bstar()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_bstar().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_n()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_n().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_W()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_W().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_Wstar()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_Wstar().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_BT()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_BT().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_ET()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_ET().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_Tc(float arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_Tc().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_Tw(float arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_Tw().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_Tz(float arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_Tz().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_TL(float arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_TL().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_Tf(const char *arg_2, pdf_font_desc *arg_3, float arg_4)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_Tf().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_Tr(int arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_Tr().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_Ts(float arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_Ts().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_Td(float arg_2, float arg_3)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_Td().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_TD(float arg_2, float arg_3)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_TD().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_Tm(float arg_2, float arg_3, float arg_4, float arg_5, float arg_6, float arg_7)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_Tm().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_Tstar()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_Tstar().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_TJ(struct pdf_obj *arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_TJ().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_Tj(char *arg_2, unsigned long arg_3)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_Tj().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_squote(char *arg_2, unsigned long arg_3)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_squote().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_dquote(float arg_2, float arg_3, char *arg_4, unsigned long arg_5)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_dquote().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_d0(float arg_2, float arg_3)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_d0().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_d1(float arg_2, float arg_3, float arg_4, float arg_5, float arg_6, float arg_7)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_d1().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_CS(const char *arg_2, struct fz_colorspace *arg_3)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_CS().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_cs(const char *arg_2, struct fz_colorspace *arg_3)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_cs().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_SC_pattern(const char *arg_2, pdf_pattern *arg_3, int arg_4, float *arg_5)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_SC_pattern().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_sc_pattern(const char *arg_2, pdf_pattern *arg_3, int arg_4, float *arg_5)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_sc_pattern().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_SC_shade(const char *arg_2, fz_shade *arg_3)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_SC_shade().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_sc_shade(const char *arg_2, fz_shade *arg_3)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_sc_shade().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_SC_color(int arg_2, float *arg_3)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_SC_color().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_sc_color(int arg_2, float *arg_3)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_sc_color().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_G(float arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_G().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_g(float arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_g().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_RG(float arg_2, float arg_3, float arg_4)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_RG().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_rg(float arg_2, float arg_3, float arg_4)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_rg().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_K(float arg_2, float arg_3, float arg_4, float arg_5)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_K().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_k(float arg_2, float arg_3, float arg_4, float arg_5)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_k().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_BI(struct fz_image *arg_2, const char *arg_3)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_BI().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_sh(const char *arg_2, fz_shade *arg_3)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_sh().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_Do_image(const char *arg_2, struct fz_image *arg_3)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_Do_image().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_Do_form(const char *arg_2, struct pdf_obj *arg_3, struct pdf_obj *arg_4)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_Do_form().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_MP(const char *arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_MP().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_DP(const char *arg_2, struct pdf_obj *arg_3, struct pdf_obj *arg_4)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_DP().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_BMC(const char *arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_BMC().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_BDC(const char *arg_2, struct pdf_obj *arg_3, struct pdf_obj *arg_4)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_BDC().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_EMC()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_EMC().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_BX()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_BX().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_EX()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_EX().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_gs_OP(int arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_gs_OP().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_gs_op(int arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_gs_op().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_gs_OPM(int arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_gs_OPM().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_gs_UseBlackPtComp(struct pdf_obj *arg_2)
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_gs_UseBlackPtComp().");
}
/* Default implementation of virtual method. */
FZ_FUNCTION void PdfProcessor2::op_END()
{
	throw std::runtime_error( "Unexpected call of unimplemented virtual_fnptrs fn PdfProcessor2::op_END().");
}

/* Implementation of methods for PdfRange (wrapper for pdf_range). */

FZ_FUNCTION PdfRange::PdfRange(pdf_range* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfRange::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfRedactOptions (wrapper for pdf_redact_options). */

/** Custom constructor. */
FZ_FUNCTION PdfRedactOptions::PdfRedactOptions()
{
	this->black_boxes = 0;
	this->image_method = 0;
}

FZ_FUNCTION PdfRedactOptions::PdfRedactOptions(const pdf_redact_options* internal)
{
	this->black_boxes = internal->black_boxes;
	this->image_method = internal->image_method;
}

FZ_FUNCTION PdfRedactOptions::PdfRedactOptions(const pdf_redact_options internal)
{
	this->black_boxes = internal.black_boxes;
	this->image_method = internal.image_method;
}

/** Constructor using raw copy of pre-existing `pdf_redact_options`. */
FZ_FUNCTION pdf_redact_options* PdfRedactOptions::internal()
{
	auto ret = (pdf_redact_options*) &this->black_boxes;
	return ret;
}

/** Constructor using raw copy of pre-existing `pdf_redact_options`. */
FZ_FUNCTION const pdf_redact_options* PdfRedactOptions::internal() const
{
	auto ret = (const pdf_redact_options*) &this->black_boxes;
	return ret;
}

FZ_FUNCTION std::string PdfRedactOptions::to_string()
{
	std::ostringstream buffer;
	buffer << *this;
	return buffer.str();
}


FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const PdfRedactOptions& rhs)
{
	return out << *rhs.internal();
}

/* Implementation of methods for PdfRevPageMap (wrapper for pdf_rev_page_map). */

FZ_FUNCTION PdfRevPageMap::PdfRevPageMap(pdf_rev_page_map* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfRevPageMap::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfTextObjectState (wrapper for pdf_text_object_state). */

/* Wrapper for `pdf_tos_get_text()`.  */
FZ_FUNCTION Text PdfTextObjectState::tos_get_text()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_tos_get_text()\n";
	}
	auto ret = mupdf::mpdf_tos_get_text(*this);
	return ret;
}

/* Wrapper for `pdf_tos_make_trm()`.  */
FZ_FUNCTION int PdfTextObjectState::tos_make_trm(const PdfTextState& text, const PdfFontDesc& fontdesc, int cid, Matrix& trm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_tos_make_trm()\n";
	}
	auto ret = mupdf::mpdf_tos_make_trm(*this, text, fontdesc, cid, trm);
	return ret;
}

/* Wrapper for `pdf_tos_move_after_char()`.  */
FZ_FUNCTION void PdfTextObjectState::tos_move_after_char()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_tos_move_after_char()\n";
	}
	mupdf::mpdf_tos_move_after_char(*this);
}

/* Wrapper for `pdf_tos_newline()`.  */
FZ_FUNCTION void PdfTextObjectState::tos_newline(float leading)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_tos_newline()\n";
	}
	mupdf::mpdf_tos_newline(*this, leading);
}

/* Wrapper for `pdf_tos_reset()`.  */
FZ_FUNCTION void PdfTextObjectState::tos_reset(int render)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_tos_reset()\n";
	}
	mupdf::mpdf_tos_reset(*this, render);
}

/* Wrapper for `pdf_tos_set_matrix()`.  */
FZ_FUNCTION void PdfTextObjectState::tos_set_matrix(float a, float b, float c, float d, float e, float f)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_tos_set_matrix()\n";
	}
	mupdf::mpdf_tos_set_matrix(*this, a, b, c, d, e, f);
}

/* Wrapper for `pdf_tos_translate()`.  */
FZ_FUNCTION void PdfTextObjectState::tos_translate(float tx, float ty)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_tos_translate()\n";
	}
	mupdf::mpdf_tos_translate(*this, tx, ty);
}

FZ_FUNCTION PdfTextObjectState::PdfTextObjectState(pdf_text_object_state* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfTextObjectState::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfTextState (wrapper for pdf_text_state). */

FZ_FUNCTION PdfTextState::PdfTextState(pdf_text_state* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfTextState::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfUnsavedSig (wrapper for pdf_unsaved_sig). */

FZ_FUNCTION PdfUnsavedSig::PdfUnsavedSig(pdf_unsaved_sig* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfUnsavedSig::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfVmtx (wrapper for pdf_vmtx). */

FZ_FUNCTION PdfVmtx::PdfVmtx(pdf_vmtx* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfVmtx::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfWriteOptions (wrapper for pdf_write_options). */

/** Custom constructor. */
FZ_FUNCTION PdfWriteOptions::PdfWriteOptions()
{
	/* Use memcpy() otherwise we get 'invalid array assignment' errors. */
	memcpy(this->internal(), &pdf_default_write_options, sizeof(*this->internal()));
}

/** Custom constructor. */
FZ_FUNCTION PdfWriteOptions::PdfWriteOptions(const PdfWriteOptions& rhs)
{
	/* Use memcpy() otherwise we get 'invalid array assignment' errors. */
	*this = rhs;
}

/* Wrapper for `pdf_parse_write_options()`.  */
FZ_FUNCTION PdfWriteOptions PdfWriteOptions::parse_write_options(const char *args)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_parse_write_options()\n";
	}
	auto ret = mupdf::mpdf_parse_write_options(*this, args);
	return ret;
}

/** Custom method. */
FZ_FUNCTION PdfWriteOptions& PdfWriteOptions::operator=(const PdfWriteOptions& rhs)
{
	memcpy(this->internal(), rhs.internal(), sizeof(*this->internal()));
	return *this;
}

/** Custom method. */
FZ_FUNCTION void PdfWriteOptions::opwd_utf8_set_value(const std::string& text)
{
	size_t len = std::min(text.size(), sizeof(opwd_utf8) - 1);
	memcpy(opwd_utf8, text.c_str(), len);
	opwd_utf8[len] = 0;
}

/** Custom method. */
FZ_FUNCTION void PdfWriteOptions::upwd_utf8_set_value(const std::string& text)
{
	size_t len = std::min(text.size(), sizeof(upwd_utf8) - 1);
	memcpy(upwd_utf8, text.c_str(), len);
	upwd_utf8[len] = 0;
}

FZ_FUNCTION PdfWriteOptions::PdfWriteOptions(const pdf_write_options* internal)
{
	this->do_incremental = internal->do_incremental;
	this->do_pretty = internal->do_pretty;
	this->do_ascii = internal->do_ascii;
	this->do_compress = internal->do_compress;
	this->do_compress_images = internal->do_compress_images;
	this->do_compress_fonts = internal->do_compress_fonts;
	this->do_decompress = internal->do_decompress;
	this->do_garbage = internal->do_garbage;
	this->do_linear = internal->do_linear;
	this->do_clean = internal->do_clean;
	this->do_sanitize = internal->do_sanitize;
	this->do_appearance = internal->do_appearance;
	this->do_encrypt = internal->do_encrypt;
	this->dont_regenerate_id = internal->dont_regenerate_id;
	this->permissions = internal->permissions;
	memcpy(this->opwd_utf8, internal->opwd_utf8, sizeof(this->opwd_utf8));
	memcpy(this->upwd_utf8, internal->upwd_utf8, sizeof(this->upwd_utf8));
	this->do_snapshot = internal->do_snapshot;
	this->do_preserve_metadata = internal->do_preserve_metadata;
}

FZ_FUNCTION PdfWriteOptions::PdfWriteOptions(const pdf_write_options internal)
{
	this->do_incremental = internal.do_incremental;
	this->do_pretty = internal.do_pretty;
	this->do_ascii = internal.do_ascii;
	this->do_compress = internal.do_compress;
	this->do_compress_images = internal.do_compress_images;
	this->do_compress_fonts = internal.do_compress_fonts;
	this->do_decompress = internal.do_decompress;
	this->do_garbage = internal.do_garbage;
	this->do_linear = internal.do_linear;
	this->do_clean = internal.do_clean;
	this->do_sanitize = internal.do_sanitize;
	this->do_appearance = internal.do_appearance;
	this->do_encrypt = internal.do_encrypt;
	this->dont_regenerate_id = internal.dont_regenerate_id;
	this->permissions = internal.permissions;
	memcpy(this->opwd_utf8, &internal.opwd_utf8, sizeof(this->opwd_utf8));
	memcpy(this->upwd_utf8, &internal.upwd_utf8, sizeof(this->upwd_utf8));
	this->do_snapshot = internal.do_snapshot;
	this->do_preserve_metadata = internal.do_preserve_metadata;
}

/** Constructor using raw copy of pre-existing `pdf_write_options`. */
FZ_FUNCTION pdf_write_options* PdfWriteOptions::internal()
{
	auto ret = (pdf_write_options*) &this->do_incremental;
	return ret;
}

/** Constructor using raw copy of pre-existing `pdf_write_options`. */
FZ_FUNCTION const pdf_write_options* PdfWriteOptions::internal() const
{
	auto ret = (const pdf_write_options*) &this->do_incremental;
	return ret;
}

FZ_FUNCTION std::string PdfWriteOptions::to_string()
{
	std::ostringstream buffer;
	buffer << *this;
	return buffer.str();
}


FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const PdfWriteOptions& rhs)
{
	return out << *rhs.internal();
}

/* Implementation of methods for PdfXrange (wrapper for pdf_xrange). */

FZ_FUNCTION PdfXrange::PdfXrange(pdf_xrange* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfXrange::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfXref (wrapper for pdf_xref). */

/* Constructor using `pdf_new_local_xref()`. */
FZ_FUNCTION PdfXref::PdfXref(const PdfDocument& doc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_new_local_xref()\n";
	}
	this->m_internal = mupdf::ppdf_new_local_xref(doc.m_internal);
}

FZ_FUNCTION PdfXref::PdfXref(pdf_xref* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfXref::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfXrefEntry (wrapper for pdf_xref_entry). */

FZ_FUNCTION PdfXrefEntry::PdfXrefEntry(pdf_xref_entry* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfXrefEntry::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfXrefSubsec (wrapper for pdf_xref_subsec). */

FZ_FUNCTION PdfXrefSubsec::PdfXrefSubsec(pdf_xref_subsec* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PdfXrefSubsec::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PdfocrOptions (wrapper for fz_pdfocr_options). */

/** Custom constructor. */
FZ_FUNCTION PdfocrOptions::PdfocrOptions()
{
	this->compress = 0;
	this->strip_height = 0;
	this->language[0] = 0;
	this->datadir[0] = 0;
}

/* Wrapper for `fz_parse_pdfocr_options()`.  */
FZ_FUNCTION PdfocrOptions PdfocrOptions::parse_pdfocr_options(const char *args)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::parse_pdfocr_options()\n";
	}
	auto ret = mupdf::mfz_parse_pdfocr_options(*this, args);
	return ret;
}

/** Custom method. */
FZ_FUNCTION void PdfocrOptions::language_set2(const char* language)
{
	fz_strlcpy(this->language, language, sizeof(this->language));
}

/** Custom method. */
FZ_FUNCTION void PdfocrOptions::datadir_set2(const char* datadir)
{
	fz_strlcpy(this->datadir, datadir, sizeof(this->datadir));
}

FZ_FUNCTION PdfocrOptions::PdfocrOptions(const fz_pdfocr_options* internal)
{
	this->compress = internal->compress;
	this->strip_height = internal->strip_height;
	memcpy(this->language, internal->language, sizeof(this->language));
	memcpy(this->datadir, internal->datadir, sizeof(this->datadir));
	this->page_count = internal->page_count;
}

FZ_FUNCTION PdfocrOptions::PdfocrOptions(const fz_pdfocr_options internal)
{
	this->compress = internal.compress;
	this->strip_height = internal.strip_height;
	memcpy(this->language, &internal.language, sizeof(this->language));
	memcpy(this->datadir, &internal.datadir, sizeof(this->datadir));
	this->page_count = internal.page_count;
}

/** Constructor using raw copy of pre-existing `fz_pdfocr_options`. */
FZ_FUNCTION fz_pdfocr_options* PdfocrOptions::internal()
{
	auto ret = (fz_pdfocr_options*) &this->compress;
	return ret;
}

/** Constructor using raw copy of pre-existing `fz_pdfocr_options`. */
FZ_FUNCTION const fz_pdfocr_options* PdfocrOptions::internal() const
{
	auto ret = (const fz_pdfocr_options*) &this->compress;
	return ret;
}

FZ_FUNCTION std::string PdfocrOptions::to_string()
{
	std::ostringstream buffer;
	buffer << *this;
	return buffer.str();
}


FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const PdfocrOptions& rhs)
{
	return out << *rhs.internal();
}

/* Implementation of methods for Pixmap (wrapper for fz_pixmap). */

static RefsCheck<fz_pixmap, Pixmap> s_Pixmap_refs_check(offsetof(fz_pixmap, storable.refs), 32);

/* Constructor using `fz_new_pixmap()`. */
FZ_FUNCTION Pixmap::Pixmap(const Colorspace& cs, int w, int h, const Separations& seps, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap()\n";
	}
	this->m_internal = mupdf::new_pixmap(cs.m_internal, w, h, seps.m_internal, alpha);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_pixmap_from_color_and_mask()`. */
FZ_FUNCTION Pixmap::Pixmap(const Pixmap& color, const Pixmap& mask)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_color_and_mask()\n";
	}
	this->m_internal = mupdf::new_pixmap_from_color_and_mask(color.m_internal, mask.m_internal);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_pixmap_from_display_list()`. */
FZ_FUNCTION Pixmap::Pixmap(const DisplayList& list, Matrix& ctm, const Colorspace& cs, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_display_list()\n";
	}
	this->m_internal = mupdf::new_pixmap_from_display_list(list.m_internal, *(fz_matrix*) &ctm.a, cs.m_internal, alpha);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_pixmap_from_display_list_with_separations()`. */
FZ_FUNCTION Pixmap::Pixmap(const DisplayList& list, Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_display_list_with_separations()\n";
	}
	this->m_internal = mupdf::new_pixmap_from_display_list_with_separations(list.m_internal, *(fz_matrix*) &ctm.a, cs.m_internal, seps.m_internal, alpha);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_pixmap_from_page()`. */
FZ_FUNCTION Pixmap::Pixmap(const Page& page, Matrix& ctm, const Colorspace& cs, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_page()\n";
	}
	this->m_internal = mupdf::new_pixmap_from_page(page.m_internal, *(fz_matrix*) &ctm.a, cs.m_internal, alpha);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_pixmap_from_page_number()`. */
FZ_FUNCTION Pixmap::Pixmap(const Document& doc, int number, Matrix& ctm, const Colorspace& cs, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_page_number()\n";
	}
	this->m_internal = mupdf::new_pixmap_from_page_number(doc.m_internal, number, *(fz_matrix*) &ctm.a, cs.m_internal, alpha);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_pixmap_from_page_number_with_separations()`. */
FZ_FUNCTION Pixmap::Pixmap(const Document& doc, int number, Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_page_number_with_separations()\n";
	}
	this->m_internal = mupdf::new_pixmap_from_page_number_with_separations(doc.m_internal, number, *(fz_matrix*) &ctm.a, cs.m_internal, seps.m_internal, alpha);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_pixmap_from_page_with_separations()`. */
FZ_FUNCTION Pixmap::Pixmap(const Page& page, Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_page_with_separations()\n";
	}
	this->m_internal = mupdf::new_pixmap_from_page_with_separations(page.m_internal, *(fz_matrix*) &ctm.a, cs.m_internal, seps.m_internal, alpha);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_pixmap_from_pixmap()`. */
FZ_FUNCTION Pixmap::Pixmap(const Pixmap& pixmap, Irect& rect)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_pixmap()\n";
	}
	this->m_internal = mupdf::new_pixmap_from_pixmap(pixmap.m_internal, (const fz_irect *) &rect.x0);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_pixmap_with_bbox()`. */
FZ_FUNCTION Pixmap::Pixmap(const Colorspace& colorspace, Irect& bbox, const Separations& seps, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_with_bbox()\n";
	}
	this->m_internal = mupdf::new_pixmap_with_bbox(colorspace.m_internal, *(fz_irect*) &bbox.x0, seps.m_internal, alpha);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_pixmap_with_bbox_and_data()`. */
FZ_FUNCTION Pixmap::Pixmap(const Colorspace& colorspace, Irect& rect, const Separations& seps, int alpha, unsigned char *samples)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_with_bbox_and_data()\n";
	}
	this->m_internal = mupdf::new_pixmap_with_bbox_and_data(colorspace.m_internal, *(fz_irect*) &rect.x0, seps.m_internal, alpha, samples);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_pixmap_with_data()`. */
FZ_FUNCTION Pixmap::Pixmap(const Colorspace& colorspace, int w, int h, const Separations& seps, int alpha, int stride, unsigned char *samples)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_with_data()\n";
	}
	this->m_internal = mupdf::new_pixmap_with_data(colorspace.m_internal, w, h, seps.m_internal, alpha, stride, samples);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Copy constructor using `fz_keep_pixmap()`. */
FZ_FUNCTION Pixmap::Pixmap(const Pixmap& rhs)
: m_internal(mupdf::keep_pixmap(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_pixmap(this->m_internal) and mupdf::keep_pixmap(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_Pixmap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `fz_keep_pixmap()` and `fz_drop_pixmap()`. */
FZ_FUNCTION Pixmap& Pixmap::operator=(const Pixmap& rhs)
{
	mupdf::drop_pixmap(this->m_internal);
	mupdf::keep_pixmap(rhs.m_internal);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_Pixmap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/* Wrapper for `fz_new_pixmap_from_page_contents()`.  */
FZ_FUNCTION Pixmap Pixmap::new_pixmap_from_page_contents(const Page& page, Matrix& ctm, const Colorspace& cs, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_page_contents()\n";
	}
	auto ret = mupdf::mfz_new_pixmap_from_page_contents(page, ctm, cs, alpha);
	return ret;
}

/* Wrapper for `fz_new_pixmap_from_page_contents_with_separations()`.  */
FZ_FUNCTION Pixmap Pixmap::new_pixmap_from_page_contents_with_separations(const Page& page, Matrix& ctm, const Colorspace& cs, const Separations& seps, int alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_page_contents_with_separations()\n";
	}
	auto ret = mupdf::mfz_new_pixmap_from_page_contents_with_separations(page, ctm, cs, seps, alpha);
	return ret;
}

/* Wrapper for `fz_alpha_from_gray()`.  */
FZ_FUNCTION Pixmap Pixmap::alpha_from_gray()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::alpha_from_gray()\n";
	}
	auto ret = mupdf::mfz_alpha_from_gray(*this);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_clear_pixmap()`.  */
FZ_FUNCTION void Pixmap::clear_pixmap()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clear_pixmap()\n";
	}
	mupdf::mfz_clear_pixmap(*this);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_clear_pixmap_rect_with_value()`.  */
FZ_FUNCTION void Pixmap::clear_pixmap_rect_with_value(int value, Irect& r)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clear_pixmap_rect_with_value()\n";
	}
	mupdf::mfz_clear_pixmap_rect_with_value(*this, value, r);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_clear_pixmap_with_value()`.  */
FZ_FUNCTION void Pixmap::clear_pixmap_with_value(int value)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clear_pixmap_with_value()\n";
	}
	mupdf::mfz_clear_pixmap_with_value(*this, value);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_clone_pixmap()`.  */
FZ_FUNCTION Pixmap Pixmap::clone_pixmap()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clone_pixmap()\n";
	}
	auto ret = mupdf::mfz_clone_pixmap(*this);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_clone_pixmap_area_with_different_seps()`.  */
FZ_FUNCTION Pixmap Pixmap::clone_pixmap_area_with_different_seps(Irect& bbox, const Colorspace& dcs, const Separations& seps, ColorParams& color_params, const DefaultColorspaces& default_cs)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clone_pixmap_area_with_different_seps()\n";
	}
	auto ret = mupdf::mfz_clone_pixmap_area_with_different_seps(*this, bbox, dcs, seps, color_params, default_cs);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_convert_indexed_pixmap_to_base()`.  */
FZ_FUNCTION Pixmap Pixmap::convert_indexed_pixmap_to_base()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::convert_indexed_pixmap_to_base()\n";
	}
	auto ret = mupdf::mfz_convert_indexed_pixmap_to_base(*this);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_convert_pixmap()`.  */
FZ_FUNCTION Pixmap Pixmap::convert_pixmap(const Colorspace& cs_des, const Colorspace& prf, const DefaultColorspaces& default_cs, ColorParams& color_params, int keep_alpha)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::convert_pixmap()\n";
	}
	auto ret = mupdf::mfz_convert_pixmap(*this, cs_des, prf, default_cs, color_params, keep_alpha);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_convert_separation_pixmap_to_base()`.  */
FZ_FUNCTION Pixmap Pixmap::convert_separation_pixmap_to_base()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::convert_separation_pixmap_to_base()\n";
	}
	auto ret = mupdf::mfz_convert_separation_pixmap_to_base(*this);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_decode_tile()`.  */
FZ_FUNCTION void Pixmap::decode_tile(const float *decode)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::decode_tile()\n";
	}
	mupdf::mfz_decode_tile(*this, decode);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_fill_pixmap_with_color()`.
	
	This method has out-params. Python/C# wrappers look like:
		`fill_pixmap_with_color(fz_colorspace *colorspace, fz_color_params color_params)` => float color
	 */
FZ_FUNCTION void Pixmap::fill_pixmap_with_color(const Colorspace& colorspace, float *color, ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::fill_pixmap_with_color()\n";
	}
	mupdf::mfz_fill_pixmap_with_color(*this, colorspace, color, color_params);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_gamma_pixmap()`.  */
FZ_FUNCTION void Pixmap::gamma_pixmap(float gamma)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::gamma_pixmap()\n";
	}
	mupdf::mfz_gamma_pixmap(*this, gamma);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_generate_transition()`.  */
FZ_FUNCTION int Pixmap::generate_transition(const Pixmap& opix, const Pixmap& npix, int time, Transition& trans)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::generate_transition()\n";
	}
	auto ret = mupdf::mfz_generate_transition(*this, opix, npix, time, trans);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_invert_pixmap()`.  */
FZ_FUNCTION void Pixmap::invert_pixmap()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::invert_pixmap()\n";
	}
	mupdf::mfz_invert_pixmap(*this);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_invert_pixmap_alpha()`.  */
FZ_FUNCTION void Pixmap::invert_pixmap_alpha()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::invert_pixmap_alpha()\n";
	}
	mupdf::mfz_invert_pixmap_alpha(*this);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_invert_pixmap_luminance()`.  */
FZ_FUNCTION void Pixmap::invert_pixmap_luminance()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::invert_pixmap_luminance()\n";
	}
	mupdf::mfz_invert_pixmap_luminance(*this);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_invert_pixmap_rect()`.  */
FZ_FUNCTION void Pixmap::invert_pixmap_rect(Irect& rect)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::invert_pixmap_rect()\n";
	}
	mupdf::mfz_invert_pixmap_rect(*this, rect);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_is_pixmap_monochrome()`.  */
FZ_FUNCTION int Pixmap::is_pixmap_monochrome()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_pixmap_monochrome()\n";
	}
	auto ret = mupdf::mfz_is_pixmap_monochrome(*this);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_bitmap_from_pixmap()`.  */
FZ_FUNCTION Bitmap Pixmap::new_bitmap_from_pixmap(const Halftone& ht)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_bitmap_from_pixmap()\n";
	}
	auto ret = mupdf::mfz_new_bitmap_from_pixmap(*this, ht);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_bitmap_from_pixmap_band()`.  */
FZ_FUNCTION Bitmap Pixmap::new_bitmap_from_pixmap_band(const Halftone& ht, int band_start)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_bitmap_from_pixmap_band()\n";
	}
	auto ret = mupdf::mfz_new_bitmap_from_pixmap_band(*this, ht, band_start);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_buffer_from_pixmap_as_png()`.  */
FZ_FUNCTION Buffer Pixmap::new_buffer_from_pixmap_as_png(ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_pixmap_as_png()\n";
	}
	auto ret = mupdf::mfz_new_buffer_from_pixmap_as_png(*this, color_params);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_image_from_pixmap()`.  */
FZ_FUNCTION Image Pixmap::new_image_from_pixmap(const Image& mask)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_image_from_pixmap()\n";
	}
	auto ret = mupdf::mfz_new_image_from_pixmap(*this, mask);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_pixmap_from_alpha_channel()`.  */
FZ_FUNCTION Pixmap Pixmap::new_pixmap_from_alpha_channel()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_alpha_channel()\n";
	}
	auto ret = mupdf::mfz_new_pixmap_from_alpha_channel(*this);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_pixmap_from_color_and_mask()`.  */
FZ_FUNCTION Pixmap Pixmap::new_pixmap_from_color_and_mask(const Pixmap& mask)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_color_and_mask()\n";
	}
	auto ret = mupdf::mfz_new_pixmap_from_color_and_mask(*this, mask);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_new_pixmap_from_pixmap()`.  */
FZ_FUNCTION Pixmap Pixmap::new_pixmap_from_pixmap(Irect& rect)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pixmap_from_pixmap()\n";
	}
	auto ret = mupdf::mfz_new_pixmap_from_pixmap(*this, rect);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_pixmap_alpha()`.  */
FZ_FUNCTION int Pixmap::pixmap_alpha()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pixmap_alpha()\n";
	}
	auto ret = mupdf::mfz_pixmap_alpha(*this);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_pixmap_bbox()`.  */
FZ_FUNCTION Irect Pixmap::pixmap_bbox()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pixmap_bbox()\n";
	}
	auto ret = mupdf::mfz_pixmap_bbox(*this);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_pixmap_colorants()`.  */
FZ_FUNCTION int Pixmap::pixmap_colorants()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pixmap_colorants()\n";
	}
	auto ret = mupdf::mfz_pixmap_colorants(*this);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_pixmap_colorspace()`.  */
FZ_FUNCTION Colorspace Pixmap::pixmap_colorspace()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pixmap_colorspace()\n";
	}
	auto ret = mupdf::mfz_pixmap_colorspace(*this);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_pixmap_components()`.  */
FZ_FUNCTION int Pixmap::pixmap_components()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pixmap_components()\n";
	}
	auto ret = mupdf::mfz_pixmap_components(*this);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_pixmap_height()`.  */
FZ_FUNCTION int Pixmap::pixmap_height()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pixmap_height()\n";
	}
	auto ret = mupdf::mfz_pixmap_height(*this);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_pixmap_samples()`.  */
FZ_FUNCTION unsigned char *Pixmap::pixmap_samples()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pixmap_samples()\n";
	}
	auto ret = mupdf::mfz_pixmap_samples(*this);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_pixmap_spots()`.  */
FZ_FUNCTION int Pixmap::pixmap_spots()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pixmap_spots()\n";
	}
	auto ret = mupdf::mfz_pixmap_spots(*this);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_pixmap_stride()`.  */
FZ_FUNCTION int Pixmap::pixmap_stride()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pixmap_stride()\n";
	}
	auto ret = mupdf::mfz_pixmap_stride(*this);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_pixmap_width()`.  */
FZ_FUNCTION int Pixmap::pixmap_width()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pixmap_width()\n";
	}
	auto ret = mupdf::mfz_pixmap_width(*this);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_pixmap_x()`.  */
FZ_FUNCTION int Pixmap::pixmap_x()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pixmap_x()\n";
	}
	auto ret = mupdf::mfz_pixmap_x(*this);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_pixmap_y()`.  */
FZ_FUNCTION int Pixmap::pixmap_y()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pixmap_y()\n";
	}
	auto ret = mupdf::mfz_pixmap_y(*this);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_save_pixmap_as_pam()`.  */
FZ_FUNCTION void Pixmap::save_pixmap_as_pam(const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_pixmap_as_pam()\n";
	}
	mupdf::mfz_save_pixmap_as_pam(*this, filename);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_save_pixmap_as_pbm()`.  */
FZ_FUNCTION void Pixmap::save_pixmap_as_pbm(const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_pixmap_as_pbm()\n";
	}
	mupdf::mfz_save_pixmap_as_pbm(*this, filename);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_save_pixmap_as_pcl()`.  */
FZ_FUNCTION void Pixmap::save_pixmap_as_pcl(char *filename, int append, const PclOptions& pcl)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_pixmap_as_pcl()\n";
	}
	mupdf::mfz_save_pixmap_as_pcl(*this, filename, append, pcl);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_save_pixmap_as_pclm()`.  */
FZ_FUNCTION void Pixmap::save_pixmap_as_pclm(char *filename, int append, const PclmOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_pixmap_as_pclm()\n";
	}
	mupdf::mfz_save_pixmap_as_pclm(*this, filename, append, options);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_save_pixmap_as_pdfocr()`.  */
FZ_FUNCTION void Pixmap::save_pixmap_as_pdfocr(char *filename, int append, PdfocrOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_pixmap_as_pdfocr()\n";
	}
	mupdf::mfz_save_pixmap_as_pdfocr(*this, filename, append, options);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_save_pixmap_as_pkm()`.  */
FZ_FUNCTION void Pixmap::save_pixmap_as_pkm(const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_pixmap_as_pkm()\n";
	}
	mupdf::mfz_save_pixmap_as_pkm(*this, filename);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_save_pixmap_as_png()`.  */
FZ_FUNCTION void Pixmap::save_pixmap_as_png(const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_pixmap_as_png()\n";
	}
	mupdf::mfz_save_pixmap_as_png(*this, filename);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_save_pixmap_as_pnm()`.  */
FZ_FUNCTION void Pixmap::save_pixmap_as_pnm(const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_pixmap_as_pnm()\n";
	}
	mupdf::mfz_save_pixmap_as_pnm(*this, filename);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_save_pixmap_as_ps()`.  */
FZ_FUNCTION void Pixmap::save_pixmap_as_ps(char *filename, int append)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_pixmap_as_ps()\n";
	}
	mupdf::mfz_save_pixmap_as_ps(*this, filename, append);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_save_pixmap_as_psd()`.  */
FZ_FUNCTION void Pixmap::save_pixmap_as_psd(const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_pixmap_as_psd()\n";
	}
	mupdf::mfz_save_pixmap_as_psd(*this, filename);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_save_pixmap_as_pwg()`.  */
FZ_FUNCTION void Pixmap::save_pixmap_as_pwg(char *filename, int append, PwgOptions& pwg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::save_pixmap_as_pwg()\n";
	}
	mupdf::mfz_save_pixmap_as_pwg(*this, filename, append, pwg);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_set_pixmap_resolution()`.  */
FZ_FUNCTION void Pixmap::set_pixmap_resolution(int xres, int yres)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_pixmap_resolution()\n";
	}
	mupdf::mfz_set_pixmap_resolution(*this, xres, yres);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_tint_pixmap()`.  */
FZ_FUNCTION void Pixmap::tint_pixmap(int black, int white)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::tint_pixmap()\n";
	}
	mupdf::mfz_tint_pixmap(*this, black, white);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION std::vector<unsigned char> Pixmap::md5_pixmap()
{
	std::vector<unsigned char>  ret(16);
	mupdf::md5_pixmap( m_internal, &ret[0]);
	return ret;
}

/** Custom method. */
FZ_FUNCTION long long Pixmap::pixmap_samples_int()
{
	long long ret = (intptr_t) samples();
	return ret;
}

/** Custom method. */
FZ_FUNCTION int Pixmap::samples_get(int offset)
{
	return m_internal->samples[offset];
}

/** Custom method. */
FZ_FUNCTION void Pixmap::samples_set(int offset, int value)
{
	m_internal->samples[offset] = value;
}

FZ_FUNCTION Pixmap::Pixmap(fz_pixmap* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_Pixmap_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION fz_storable Pixmap::storable()
{
	return m_internal->storable;
}

FZ_FUNCTION int Pixmap::x()
{
	return m_internal->x;
}

FZ_FUNCTION int Pixmap::y()
{
	return m_internal->y;
}

FZ_FUNCTION int Pixmap::w()
{
	return m_internal->w;
}

FZ_FUNCTION int Pixmap::h()
{
	return m_internal->h;
}

FZ_FUNCTION unsigned char Pixmap::n()
{
	return m_internal->n;
}

FZ_FUNCTION unsigned char Pixmap::s()
{
	return m_internal->s;
}

FZ_FUNCTION unsigned char Pixmap::alpha()
{
	return m_internal->alpha;
}

FZ_FUNCTION unsigned char Pixmap::flags()
{
	return m_internal->flags;
}

FZ_FUNCTION ptrdiff_t Pixmap::stride()
{
	return m_internal->stride;
}

FZ_FUNCTION Separations Pixmap::seps()
{
	mupdf::keep_separations(m_internal->seps);
	return m_internal->seps;
}

FZ_FUNCTION int Pixmap::xres()
{
	return m_internal->xres;
}

FZ_FUNCTION int Pixmap::yres()
{
	return m_internal->yres;
}

FZ_FUNCTION Colorspace Pixmap::colorspace()
{
	mupdf::keep_colorspace(m_internal->colorspace);
	return m_internal->colorspace;
}

FZ_FUNCTION const unsigned char *Pixmap::samples()
{
	return m_internal->samples;
}

FZ_FUNCTION Pixmap Pixmap::underlying()
{
	mupdf::keep_pixmap(m_internal->underlying);
	return m_internal->underlying;
}

FZ_FUNCTION Pixmap::~Pixmap()
{
	mupdf::drop_pixmap(m_internal);
	if (s_check_refs)
	{
		s_Pixmap_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long Pixmap::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PixmapImage (wrapper for fz_pixmap_image). */

/* Wrapper for `fz_pixmap_image_tile()`.  */
FZ_FUNCTION Pixmap PixmapImage::pixmap_image_tile()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pixmap_image_tile()\n";
	}
	auto ret = mupdf::mfz_pixmap_image_tile(*this);
	return ret;
}

/* Wrapper for `fz_set_pixmap_image_tile()`.  */
FZ_FUNCTION void PixmapImage::set_pixmap_image_tile(const Pixmap& pix)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_pixmap_image_tile()\n";
	}
	mupdf::mfz_set_pixmap_image_tile(*this, pix);
}

FZ_FUNCTION PixmapImage::PixmapImage(fz_pixmap_image* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long PixmapImage::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Point (wrapper for fz_point). */

/** Custom constructor. */
FZ_FUNCTION Point::Point(float x, float y)
: x(x), y(y)
{
}

/* Wrapper for `fz_transform_point()`.  */
FZ_FUNCTION Point Point::transform_point(Point& point, Matrix& m)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::transform_point()\n";
	}
	auto ret = mupdf::mfz_transform_point(point, m);
	return ret;
}

/* Wrapper for `fz_transform_point_xy()`.  */
FZ_FUNCTION Point Point::transform_point_xy(float x, float y, Matrix& m)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::transform_point_xy()\n";
	}
	auto ret = mupdf::mfz_transform_point_xy(x, y, m);
	return ret;
}

/* Wrapper for `fz_transform_vector()`.  */
FZ_FUNCTION Point Point::transform_vector(Point& vector, Matrix& m)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::transform_vector()\n";
	}
	auto ret = mupdf::mfz_transform_vector(vector, m);
	return ret;
}

/* Wrapper for `fz_is_point_inside_quad()`.  */
FZ_FUNCTION int Point::is_point_inside_quad(Quad& q)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_point_inside_quad()\n";
	}
	auto ret = mupdf::mfz_is_point_inside_quad(*this, q);
	return ret;
}

/* Wrapper for `fz_is_point_inside_rect()`.  */
FZ_FUNCTION int Point::is_point_inside_rect(Rect& r)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_point_inside_rect()\n";
	}
	auto ret = mupdf::mfz_is_point_inside_rect(*this, r);
	return ret;
}

/* Wrapper for `fz_normalize_vector()`.  */
FZ_FUNCTION Point Point::normalize_vector()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::normalize_vector()\n";
	}
	auto ret = mupdf::mfz_normalize_vector(*this);
	return ret;
}

/* Wrapper for `fz_transform_point()`.  */
FZ_FUNCTION Point Point::transform_point(Matrix& m)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::transform_point()\n";
	}
	auto ret = mupdf::mfz_transform_point(*this, m);
	return ret;
}

/* Wrapper for `fz_transform_vector()`.  */
FZ_FUNCTION Point Point::transform_vector(Matrix& m)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::transform_vector()\n";
	}
	auto ret = mupdf::mfz_transform_vector(*this, m);
	return ret;
}

/** Custom method. */
FZ_FUNCTION Point& Point::transform(const Matrix& m)
{
	double  old_x = x;
	x = old_x * m.a + y * m.c + m.e;
	y = old_x * m.b + y * m.d + m.f;
	return *this;
}

FZ_FUNCTION Point::Point(const fz_point* internal)
{
	this->x = internal->x;
	this->y = internal->y;
}

FZ_FUNCTION Point::Point(const fz_point internal)
{
	this->x = internal.x;
	this->y = internal.y;
}

/** Constructor using raw copy of pre-existing `fz_point`. */
FZ_FUNCTION fz_point* Point::internal()
{
	auto ret = (fz_point*) &this->x;
	return ret;
}

/** Constructor using raw copy of pre-existing `fz_point`. */
FZ_FUNCTION const fz_point* Point::internal() const
{
	auto ret = (const fz_point*) &this->x;
	return ret;
}

FZ_FUNCTION std::string Point::to_string()
{
	std::ostringstream buffer;
	buffer << *this;
	return buffer.str();
}


FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const Point& rhs)
{
	return out << *rhs.internal();
}

/* Implementation of methods for Pool (wrapper for fz_pool). */

/* Constructor using `fz_new_pool()`. */
FZ_FUNCTION Pool::Pool()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_pool()\n";
	}
	this->m_internal = mupdf::new_pool();
}

/* Wrapper for `fz_pool_alloc()`.  */
FZ_FUNCTION void *Pool::pool_alloc(size_t size)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pool_alloc()\n";
	}
	auto ret = mupdf::mfz_pool_alloc(*this, size);
	return ret;
}

/* Wrapper for `fz_pool_size()`.  */
FZ_FUNCTION size_t Pool::pool_size()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pool_size()\n";
	}
	auto ret = mupdf::mfz_pool_size(*this);
	return ret;
}

/* Wrapper for `fz_pool_strdup()`.  */
FZ_FUNCTION char *Pool::pool_strdup(const char *s)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::pool_strdup()\n";
	}
	auto ret = mupdf::mfz_pool_strdup(*this, s);
	return ret;
}

FZ_FUNCTION Pool::Pool(fz_pool* internal)
: m_internal(internal)
{
}

FZ_FUNCTION Pool::~Pool()
{
	mupdf::drop_pool(m_internal);
}

/** Custom method. */
FZ_FUNCTION long long Pool::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for PwgOptions (wrapper for fz_pwg_options). */

FZ_FUNCTION PwgOptions::PwgOptions(const fz_pwg_options* internal)
: m_internal(*internal)
{
}

FZ_FUNCTION char * PwgOptions::media_class()
{
	return m_internal.media_class;
}

FZ_FUNCTION char * PwgOptions::media_color()
{
	return m_internal.media_color;
}

FZ_FUNCTION char * PwgOptions::media_type()
{
	return m_internal.media_type;
}

FZ_FUNCTION char * PwgOptions::output_type()
{
	return m_internal.output_type;
}

FZ_FUNCTION unsigned int PwgOptions::advance_distance()
{
	return m_internal.advance_distance;
}

FZ_FUNCTION int PwgOptions::advance_media()
{
	return m_internal.advance_media;
}

FZ_FUNCTION int PwgOptions::collate()
{
	return m_internal.collate;
}

FZ_FUNCTION int PwgOptions::cut_media()
{
	return m_internal.cut_media;
}

FZ_FUNCTION int PwgOptions::duplex()
{
	return m_internal.duplex;
}

FZ_FUNCTION int PwgOptions::insert_sheet()
{
	return m_internal.insert_sheet;
}

FZ_FUNCTION int PwgOptions::jog()
{
	return m_internal.jog;
}

FZ_FUNCTION int PwgOptions::leading_edge()
{
	return m_internal.leading_edge;
}

FZ_FUNCTION int PwgOptions::manual_feed()
{
	return m_internal.manual_feed;
}

FZ_FUNCTION unsigned int PwgOptions::media_position()
{
	return m_internal.media_position;
}

FZ_FUNCTION unsigned int PwgOptions::media_weight()
{
	return m_internal.media_weight;
}

FZ_FUNCTION int PwgOptions::mirror_print()
{
	return m_internal.mirror_print;
}

FZ_FUNCTION int PwgOptions::negative_print()
{
	return m_internal.negative_print;
}

FZ_FUNCTION unsigned int PwgOptions::num_copies()
{
	return m_internal.num_copies;
}

FZ_FUNCTION int PwgOptions::orientation()
{
	return m_internal.orientation;
}

FZ_FUNCTION int PwgOptions::output_face_up()
{
	return m_internal.output_face_up;
}

FZ_FUNCTION unsigned int * PwgOptions::PageSize()
{
	return m_internal.PageSize;
}

FZ_FUNCTION int PwgOptions::separations()
{
	return m_internal.separations;
}

FZ_FUNCTION int PwgOptions::tray_switch()
{
	return m_internal.tray_switch;
}

FZ_FUNCTION int PwgOptions::tumble()
{
	return m_internal.tumble;
}

FZ_FUNCTION int PwgOptions::media_type_num()
{
	return m_internal.media_type_num;
}

FZ_FUNCTION int PwgOptions::compression()
{
	return m_internal.compression;
}

FZ_FUNCTION unsigned int PwgOptions::row_count()
{
	return m_internal.row_count;
}

FZ_FUNCTION unsigned int PwgOptions::row_feed()
{
	return m_internal.row_feed;
}

FZ_FUNCTION unsigned int PwgOptions::row_step()
{
	return m_internal.row_step;
}

FZ_FUNCTION char * PwgOptions::rendering_intent()
{
	return m_internal.rendering_intent;
}

FZ_FUNCTION char * PwgOptions::page_size_name()
{
	return m_internal.page_size_name;
}

FZ_FUNCTION std::string PwgOptions::to_string()
{
	std::ostringstream buffer;
	buffer << *this;
	return buffer.str();
}


FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const PwgOptions& rhs)
{
	return out << rhs.m_internal;
}

/* Implementation of methods for Quad (wrapper for fz_quad). */

/* Constructor using `fz_quad_from_rect()`. */
FZ_FUNCTION Quad::Quad(Rect& r)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::quad_from_rect()\n";
	}
	*(fz_quad*) &this->ul = mupdf::quad_from_rect(*(fz_rect*) &r.x0);
}

/* Constructor using `fz_transform_quad()`. */
FZ_FUNCTION Quad::Quad(Quad& q, Matrix& m)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::transform_quad()\n";
	}
	*(fz_quad*) &this->ul = mupdf::transform_quad(*(fz_quad*) &q.ul, *(fz_matrix*) &m.a);
}

/** Custom constructor. */
FZ_FUNCTION Quad::Quad()
: ul{0,0}, ur{0,0}, ll{0,0}, lr{0,0}
{
}
/* Wrapper for `fz_is_quad_inside_quad()`.  */
FZ_FUNCTION int Quad::is_quad_inside_quad(Quad& haystack)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_quad_inside_quad()\n";
	}
	auto ret = mupdf::mfz_is_quad_inside_quad(*this, haystack);
	return ret;
}

/* Wrapper for `fz_is_quad_intersecting_quad()`.  */
FZ_FUNCTION int Quad::is_quad_intersecting_quad(Quad& b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_quad_intersecting_quad()\n";
	}
	auto ret = mupdf::mfz_is_quad_intersecting_quad(*this, b);
	return ret;
}

/* Wrapper for `fz_rect_from_quad()`.  */
FZ_FUNCTION Rect Quad::rect_from_quad()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::rect_from_quad()\n";
	}
	auto ret = mupdf::mfz_rect_from_quad(*this);
	return ret;
}

/* Wrapper for `fz_transform_quad()`.  */
FZ_FUNCTION Quad Quad::transform_quad(Matrix& m)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::transform_quad()\n";
	}
	auto ret = mupdf::mfz_transform_quad(*this, m);
	return ret;
}

FZ_FUNCTION Quad::Quad(const fz_quad* internal)
{
	this->ul = internal->ul;
	this->ur = internal->ur;
	this->ll = internal->ll;
	this->lr = internal->lr;
}

FZ_FUNCTION Quad::Quad(const fz_quad internal)
{
	this->ul = internal.ul;
	this->ur = internal.ur;
	this->ll = internal.ll;
	this->lr = internal.lr;
}

/** Constructor using raw copy of pre-existing `fz_quad`. */
FZ_FUNCTION fz_quad* Quad::internal()
{
	auto ret = (fz_quad*) &this->ul;
	return ret;
}

/** Constructor using raw copy of pre-existing `fz_quad`. */
FZ_FUNCTION const fz_quad* Quad::internal() const
{
	auto ret = (const fz_quad*) &this->ul;
	return ret;
}

FZ_FUNCTION std::string Quad::to_string()
{
	std::ostringstream buffer;
	buffer << *this;
	return buffer.str();
}


FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const Quad& rhs)
{
	return out << *rhs.internal();
}

/* Implementation of methods for Range (wrapper for fz_range). */

FZ_FUNCTION Range::Range(fz_range* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long Range::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Rect (wrapper for fz_rect). */

/* Constructor using `fz_bound_display_list()`. */
FZ_FUNCTION Rect::Rect(const DisplayList& list)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::bound_display_list()\n";
	}
	*(fz_rect*) &this->x0 = mupdf::bound_display_list(list.m_internal);
}

/* Constructor using `fz_rect_from_irect()`. */
FZ_FUNCTION Rect::Rect(Irect& bbox)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::rect_from_irect()\n";
	}
	*(fz_rect*) &this->x0 = mupdf::rect_from_irect(*(fz_irect*) &bbox.x0);
}

/* Constructor using `fz_rect_from_quad()`. */
FZ_FUNCTION Rect::Rect(Quad& q)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::rect_from_quad()\n";
	}
	*(fz_rect*) &this->x0 = mupdf::rect_from_quad(*(fz_quad*) &q.ul);
}

/* Constructor using `fz_transform_rect()`. */
FZ_FUNCTION Rect::Rect(Rect& rect, Matrix& m)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::transform_rect()\n";
	}
	*(fz_rect*) &this->x0 = mupdf::transform_rect(*(fz_rect*) &rect.x0, *(fz_matrix*) &m.a);
}

/** Custom constructor. */
FZ_FUNCTION Rect::Rect(double x0, double y0, double x1, double y1)
:
x0(x0),
x1(x1),
y0(y0),
y1(y1)
{
}

/** Custom constructor. */
FZ_FUNCTION Rect::Rect(const Rect& rhs)
:
x0(rhs.x0),
x1(rhs.x1),
y0(rhs.y0),
y1(rhs.y1)
{
}

/** Custom constructor. */
FZ_FUNCTION Rect::Rect(Fixed fixed)
{
	if (0)  {}
	else if (fixed == Fixed_UNIT)       *this->internal() = ::fz_unit_rect;
	else if (fixed == Fixed_EMPTY)      *this->internal() = ::fz_empty_rect;
	else if (fixed == Fixed_INFINITE)   *this->internal() = ::fz_infinite_rect;
	else throw ErrorAbort( "Unrecognised From value");
}

/* Wrapper for `fz_intersect_rect()`.  */
FZ_FUNCTION Rect Rect::intersect_rect(Rect& a, Rect& b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::intersect_rect()\n";
	}
	auto ret = mupdf::mfz_intersect_rect(a, b);
	return ret;
}

/* Wrapper for `fz_union_rect()`.  */
FZ_FUNCTION Rect Rect::union_rect(Rect& a, Rect& b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::union_rect()\n";
	}
	auto ret = mupdf::mfz_union_rect(a, b);
	return ret;
}

/* Wrapper for `fz_adjust_rect_for_stroke()`.  */
FZ_FUNCTION Rect Rect::adjust_rect_for_stroke(const StrokeState& stroke, Matrix& ctm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::adjust_rect_for_stroke()\n";
	}
	auto ret = mupdf::mfz_adjust_rect_for_stroke(*this, stroke, ctm);
	return ret;
}

/* Wrapper for `fz_contains_rect()`.  */
FZ_FUNCTION int Rect::contains_rect(Rect& b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::contains_rect()\n";
	}
	auto ret = mupdf::mfz_contains_rect(*this, b);
	return ret;
}

/* Wrapper for `fz_expand_rect()`.  */
FZ_FUNCTION Rect Rect::expand_rect(float expand)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::expand_rect()\n";
	}
	auto ret = mupdf::mfz_expand_rect(*this, expand);
	return ret;
}

/* Wrapper for `fz_include_point_in_rect()`.  */
FZ_FUNCTION Rect Rect::include_point_in_rect(Point& p)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::include_point_in_rect()\n";
	}
	auto ret = mupdf::mfz_include_point_in_rect(*this, p);
	return ret;
}

/* Wrapper for `fz_intersect_rect()`.  */
FZ_FUNCTION Rect Rect::intersect_rect(Rect& b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::intersect_rect()\n";
	}
	auto ret = mupdf::mfz_intersect_rect(*this, b);
	return ret;
}

/* Wrapper for `fz_irect_from_rect()`.  */
FZ_FUNCTION Irect Rect::irect_from_rect()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::irect_from_rect()\n";
	}
	auto ret = mupdf::mfz_irect_from_rect(*this);
	return ret;
}

/* Wrapper for `fz_is_empty_rect()`.  */
FZ_FUNCTION int Rect::is_empty_rect()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_empty_rect()\n";
	}
	auto ret = mupdf::mfz_is_empty_rect(*this);
	return ret;
}

/* Wrapper for `fz_is_infinite_rect()`.  */
FZ_FUNCTION int Rect::is_infinite_rect()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_infinite_rect()\n";
	}
	auto ret = mupdf::mfz_is_infinite_rect(*this);
	return ret;
}

/* Wrapper for `fz_is_valid_rect()`.  */
FZ_FUNCTION int Rect::is_valid_rect()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_valid_rect()\n";
	}
	auto ret = mupdf::mfz_is_valid_rect(*this);
	return ret;
}

/* Wrapper for `fz_new_bbox_device()`.  */
FZ_FUNCTION Device Rect::new_bbox_device()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_bbox_device()\n";
	}
	auto ret = mupdf::mfz_new_bbox_device(*this);
	return ret;
}

/* Wrapper for `fz_new_display_list()`.  */
FZ_FUNCTION DisplayList Rect::new_display_list()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_display_list()\n";
	}
	auto ret = mupdf::mfz_new_display_list(*this);
	return ret;
}

/* Wrapper for `fz_new_link()`.  */
FZ_FUNCTION Link Rect::new_link(const char *uri)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_link()\n";
	}
	auto ret = mupdf::mfz_new_link(*this, uri);
	return ret;
}

/* Wrapper for `fz_quad_from_rect()`.  */
FZ_FUNCTION Quad Rect::quad_from_rect()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::quad_from_rect()\n";
	}
	auto ret = mupdf::mfz_quad_from_rect(*this);
	return ret;
}

/* Wrapper for `fz_round_rect()`.  */
FZ_FUNCTION Irect Rect::round_rect()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::round_rect()\n";
	}
	auto ret = mupdf::mfz_round_rect(*this);
	return ret;
}

/* Wrapper for `fz_transform_page()`.  */
FZ_FUNCTION Matrix Rect::transform_page(float resolution, float rotate)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::transform_page()\n";
	}
	auto ret = mupdf::mfz_transform_page(*this, resolution, rotate);
	return ret;
}

/* Wrapper for `fz_transform_rect()`.  */
FZ_FUNCTION Rect Rect::transform_rect(Matrix& m)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::transform_rect()\n";
	}
	auto ret = mupdf::mfz_transform_rect(*this, m);
	return ret;
}

/* Wrapper for `fz_translate_rect()`.  */
FZ_FUNCTION Rect Rect::translate_rect(float xoff, float yoff)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::translate_rect()\n";
	}
	auto ret = mupdf::mfz_translate_rect(*this, xoff, yoff);
	return ret;
}

/* Wrapper for `fz_union_rect()`.  */
FZ_FUNCTION Rect Rect::union_rect(Rect& b)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::union_rect()\n";
	}
	auto ret = mupdf::mfz_union_rect(*this, b);
	return ret;
}

/* Wrapper for `pdf_signature_appearance_signed()`.  */
FZ_FUNCTION DisplayList Rect::signature_appearance_signed(fz_text_language lang, const Image& img, const char *left_text, const char *right_text, int include_logo)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_signature_appearance_signed()\n";
	}
	auto ret = mupdf::mpdf_signature_appearance_signed(*this, lang, img, left_text, right_text, include_logo);
	return ret;
}

/* Wrapper for `pdf_signature_appearance_unsigned()`.  */
FZ_FUNCTION DisplayList Rect::signature_appearance_unsigned(fz_text_language lang)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_signature_appearance_unsigned()\n";
	}
	auto ret = mupdf::mpdf_signature_appearance_unsigned(*this, lang);
	return ret;
}

/** Custom method. */
FZ_FUNCTION void Rect::transform(const Matrix& m)
{
	*(fz_rect*) &this->x0 = ::fz_transform_rect(*(fz_rect*) &this->x0, *(fz_matrix*) &m.a);
}

/** Custom method. */
FZ_FUNCTION bool Rect::contains(double x, double y)
{
	if (is_empty()) {
		return false;
	}
	return true
			&& x >= x0
			&& x < x1
			&& y >= y0
			&& y < y1
			;
}

/** Custom method. */
FZ_FUNCTION bool Rect::contains(Rect& rhs)
{
	return ::fz_contains_rect(*(fz_rect*) &x0, *(fz_rect*) &rhs.x0);
}

/** Custom method. */
FZ_FUNCTION bool Rect::is_empty()
{
	return ::fz_is_empty_rect(*(fz_rect*) &x0);
}

/** Custom method. */
FZ_FUNCTION void Rect::union_(Rect& rhs)
{
	*(fz_rect*) &x0 = ::fz_union_rect(*(fz_rect*) &x0, *(fz_rect*) &rhs.x0);
}

FZ_FUNCTION Rect::Rect(const fz_rect* internal)
{
	this->x0 = internal->x0;
	this->y0 = internal->y0;
	this->x1 = internal->x1;
	this->y1 = internal->y1;
}

FZ_FUNCTION Rect::Rect(const fz_rect internal)
{
	this->x0 = internal.x0;
	this->y0 = internal.y0;
	this->x1 = internal.x1;
	this->y1 = internal.y1;
}

/** Constructor using raw copy of pre-existing `fz_rect`. */
FZ_FUNCTION fz_rect* Rect::internal()
{
	auto ret = (fz_rect*) &this->x0;
	return ret;
}

/** Constructor using raw copy of pre-existing `fz_rect`. */
FZ_FUNCTION const fz_rect* Rect::internal() const
{
	auto ret = (const fz_rect*) &this->x0;
	return ret;
}

FZ_FUNCTION std::string Rect::to_string()
{
	std::ostringstream buffer;
	buffer << *this;
	return buffer.str();
}


FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const Rect& rhs)
{
	return out << *rhs.internal();
}

/* Implementation of methods for Separations (wrapper for fz_separations). */

static RefsCheck<fz_separations, Separations> s_Separations_refs_check(0, 32);

/* Constructor using `fz_new_separations()`. */
FZ_FUNCTION Separations::Separations(int controllable)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_separations()\n";
	}
	this->m_internal = mupdf::new_separations(controllable);
	if (s_check_refs)
	{
		s_Separations_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Copy constructor using `fz_keep_separations()`. */
FZ_FUNCTION Separations::Separations(const Separations& rhs)
: m_internal(mupdf::keep_separations(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_separations(this->m_internal) and mupdf::keep_separations(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_Separations_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `fz_keep_separations()` and `fz_drop_separations()`. */
FZ_FUNCTION Separations& Separations::operator=(const Separations& rhs)
{
	mupdf::drop_separations(this->m_internal);
	mupdf::keep_separations(rhs.m_internal);
	if (s_check_refs)
	{
		s_Separations_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_Separations_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/* Wrapper for `fz_add_separation()`.  */
FZ_FUNCTION void Separations::add_separation(const char *name, const Colorspace& cs, int cs_channel)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::add_separation()\n";
	}
	mupdf::mfz_add_separation(*this, name, cs, cs_channel);
	if (s_check_refs)
	{
		s_Separations_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_add_separation_equivalents()`.  */
FZ_FUNCTION void Separations::add_separation_equivalents(uint32_t rgba, uint32_t cmyk, const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::add_separation_equivalents()\n";
	}
	mupdf::mfz_add_separation_equivalents(*this, rgba, cmyk, name);
	if (s_check_refs)
	{
		s_Separations_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_clone_separations_for_overprint()`.  */
FZ_FUNCTION Separations Separations::clone_separations_for_overprint()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clone_separations_for_overprint()\n";
	}
	auto ret = mupdf::mfz_clone_separations_for_overprint(*this);
	if (s_check_refs)
	{
		s_Separations_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_count_active_separations()`.  */
FZ_FUNCTION int Separations::count_active_separations()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::count_active_separations()\n";
	}
	auto ret = mupdf::mfz_count_active_separations(*this);
	if (s_check_refs)
	{
		s_Separations_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_count_separations()`.  */
FZ_FUNCTION int Separations::count_separations()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::count_separations()\n";
	}
	auto ret = mupdf::mfz_count_separations(*this);
	if (s_check_refs)
	{
		s_Separations_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_separation_equivalent()`.
	
	This method has out-params. Python/C# wrappers look like:
		`separation_equivalent(int idx, fz_colorspace *dst_cs, fz_colorspace *prf, fz_color_params color_params)` => float dst_color
	 */
FZ_FUNCTION void Separations::separation_equivalent(int idx, const Colorspace& dst_cs, float *dst_color, const Colorspace& prf, ColorParams& color_params)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::separation_equivalent()\n";
	}
	mupdf::mfz_separation_equivalent(*this, idx, dst_cs, dst_color, prf, color_params);
	if (s_check_refs)
	{
		s_Separations_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_separation_name()`.  */
FZ_FUNCTION const char *Separations::separation_name(int separation)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::separation_name()\n";
	}
	auto ret = mupdf::mfz_separation_name(*this, separation);
	if (s_check_refs)
	{
		s_Separations_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_set_separation_behavior()`.  */
FZ_FUNCTION void Separations::set_separation_behavior(int separation, fz_separation_behavior behavior)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::set_separation_behavior()\n";
	}
	mupdf::mfz_set_separation_behavior(*this, separation, behavior);
	if (s_check_refs)
	{
		s_Separations_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION Separations::Separations(fz_separations* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_Separations_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION Separations::~Separations()
{
	mupdf::drop_separations(m_internal);
	if (s_check_refs)
	{
		s_Separations_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long Separations::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Sha256 (wrapper for fz_sha256). */

/* Wrapper for `fz_sha256_final()`.  */
FZ_FUNCTION void Sha256::sha256_final(unsigned char digest[32])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::sha256_final()\n";
	}
	mupdf::mfz_sha256_final(*this, digest);
}

/* Wrapper for `fz_sha256_init()`.  */
FZ_FUNCTION void Sha256::sha256_init()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::sha256_init()\n";
	}
	mupdf::mfz_sha256_init(*this);
}

/* Wrapper for `fz_sha256_update()`.  */
FZ_FUNCTION void Sha256::sha256_update(const unsigned char *input, size_t inlen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::sha256_update()\n";
	}
	mupdf::mfz_sha256_update(*this, input, inlen);
}

FZ_FUNCTION Sha256::Sha256(fz_sha256* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long Sha256::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Sha512 (wrapper for fz_sha512). */

/* Wrapper for `fz_sha384_final()`.  */
FZ_FUNCTION void Sha512::sha384_final(unsigned char digest[64])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::sha384_final()\n";
	}
	mupdf::mfz_sha384_final(*this, digest);
}

/* Wrapper for `fz_sha384_init()`.  */
FZ_FUNCTION void Sha512::sha384_init()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::sha384_init()\n";
	}
	mupdf::mfz_sha384_init(*this);
}

/* Wrapper for `fz_sha384_update()`.  */
FZ_FUNCTION void Sha512::sha384_update(const unsigned char *input, size_t inlen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::sha384_update()\n";
	}
	mupdf::mfz_sha384_update(*this, input, inlen);
}

/* Wrapper for `fz_sha512_final()`.  */
FZ_FUNCTION void Sha512::sha512_final(unsigned char digest[64])
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::sha512_final()\n";
	}
	mupdf::mfz_sha512_final(*this, digest);
}

/* Wrapper for `fz_sha512_init()`.  */
FZ_FUNCTION void Sha512::sha512_init()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::sha512_init()\n";
	}
	mupdf::mfz_sha512_init(*this);
}

/* Wrapper for `fz_sha512_update()`.  */
FZ_FUNCTION void Sha512::sha512_update(const unsigned char *input, size_t inlen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::sha512_update()\n";
	}
	mupdf::mfz_sha512_update(*this, input, inlen);
}

FZ_FUNCTION Sha512::Sha512(fz_sha512* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long Sha512::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Shade (wrapper for fz_shade). */

static RefsCheck<fz_shade, Shade> s_Shade_refs_check(offsetof(fz_shade, storable.refs), 32);

/** Copy constructor using `fz_keep_shade()`. */
FZ_FUNCTION Shade::Shade(const Shade& rhs)
: m_internal(mupdf::keep_shade(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_shade(this->m_internal) and mupdf::keep_shade(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_Shade_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `fz_keep_shade()` and `fz_drop_shade()`. */
FZ_FUNCTION Shade& Shade::operator=(const Shade& rhs)
{
	mupdf::drop_shade(this->m_internal);
	mupdf::keep_shade(rhs.m_internal);
	if (s_check_refs)
	{
		s_Shade_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_Shade_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/* Wrapper for `fz_bound_shade()`.  */
FZ_FUNCTION Rect Shade::bound_shade(Matrix& ctm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::bound_shade()\n";
	}
	auto ret = mupdf::mfz_bound_shade(*this, ctm);
	if (s_check_refs)
	{
		s_Shade_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_paint_shade()`.
	
	This method has out-params. Python/C# wrappers look like:
		`paint_shade(fz_colorspace *override_cs, fz_matrix ctm, fz_pixmap *dest, fz_color_params color_params, fz_irect bbox, const fz_overprint *eop, fz_shade_color_cache **cache)` => 
	 */
FZ_FUNCTION void Shade::paint_shade(const Colorspace& override_cs, Matrix& ctm, const Pixmap& dest, ColorParams& color_params, Irect& bbox, const Overprint& eop, ShadeColorCache& cache)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::paint_shade()\n";
	}
	mupdf::mfz_paint_shade(*this, override_cs, ctm, dest, color_params, bbox, eop, cache);
	if (s_check_refs)
	{
		s_Shade_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_process_shade()`.  */
FZ_FUNCTION void Shade::process_shade(Matrix& ctm, Rect& scissor, fz_shade_prepare_fn *prepare, fz_shade_process_fn *process, void *process_arg)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::process_shade()\n";
	}
	mupdf::mfz_process_shade(*this, ctm, scissor, prepare, process, process_arg);
	if (s_check_refs)
	{
		s_Shade_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION void Shade::paint_shade_no_cache(const Colorspace& override_cs, Matrix& ctm, const Pixmap& dest, ColorParams& color_params, Irect& bbox, const Overprint& eop)
{
	return mupdf::paint_shade(
			this->m_internal,
			override_cs.m_internal,
			*(fz_matrix*) &ctm.a,
			dest.m_internal,
			*(fz_color_params*) &color_params.ri,
			*(fz_irect*) &bbox.x0,
			eop.m_internal,
			NULL /*cache*/
			);
}

FZ_FUNCTION Shade::Shade(fz_shade* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_Shade_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION Shade::~Shade()
{
	mupdf::drop_shade(m_internal);
	if (s_check_refs)
	{
		s_Shade_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long Shade::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for ShadeColorCache (wrapper for fz_shade_color_cache). */

/** Custom constructor. */
FZ_FUNCTION ShadeColorCache::ShadeColorCache()
: m_internal( NULL)
{
}

FZ_FUNCTION ShadeColorCache::ShadeColorCache(fz_shade_color_cache* internal)
: m_internal(internal)
{
}

FZ_FUNCTION ShadeColorCache::~ShadeColorCache()
{
	mupdf::drop_shade_color_cache(m_internal);
}

/** Custom method. */
FZ_FUNCTION long long ShadeColorCache::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for ShaperDataT (wrapper for fz_shaper_data_t). */

FZ_FUNCTION ShaperDataT::ShaperDataT(fz_shaper_data_t* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long ShaperDataT::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for StextBlock (wrapper for fz_stext_block). */

/** Custom method. */
FZ_FUNCTION Matrix StextBlock::i_transform()
{
	if (m_internal->type != FZ_STEXT_BLOCK_IMAGE) {
		throw std::runtime_error("Not an image");
	}
	return m_internal->u.i.transform;
}

/** Custom method. */
FZ_FUNCTION Image StextBlock::i_image()
{
	if (m_internal->type != FZ_STEXT_BLOCK_IMAGE) {
		throw std::runtime_error("Not an image");
	}
	return keep_image(m_internal->u.i.image);
}

/** Custom method. */
FZ_FUNCTION StextBlockIterator StextBlock::begin()
{
	auto ret = StextBlockIterator(m_internal->u.t.first_line);
	#if 0
	if (s_check_refs)
	{
		s_StextBlock_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	#endif
	return ret;
}

/** Custom method. */
FZ_FUNCTION StextBlockIterator StextBlock::end()
{
	auto ret = StextBlockIterator(NULL);
	#if 0
	if (s_check_refs)
	{
		s_StextBlock_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	#endif
	return ret;
}

FZ_FUNCTION StextBlock::StextBlock(fz_stext_block* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long StextBlock::m_internal_value()
{
	return (uintptr_t) m_internal;
}


FZ_FUNCTION StextBlockIterator::StextBlockIterator(const StextLine& item)
: m_item( item)
{
}
FZ_FUNCTION StextBlockIterator& StextBlockIterator::operator++()
{

	m_item = StextLine(m_item.m_internal->next);
	return *this;
}
FZ_FUNCTION bool StextBlockIterator::operator==( const StextBlockIterator& rhs)
{
	return m_item.m_internal == rhs.m_item.m_internal;
}
FZ_FUNCTION bool StextBlockIterator::operator!=( const StextBlockIterator& rhs)
{
	return m_item.m_internal != rhs.m_item.m_internal;
}
FZ_FUNCTION StextLine StextBlockIterator::operator*()
{
	return m_item;
}
FZ_FUNCTION StextLine* StextBlockIterator::operator->()
{
	return &m_item;
}


/* Implementation of methods for StextChar (wrapper for fz_stext_char). */

FZ_FUNCTION StextChar::StextChar(fz_stext_char* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long StextChar::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for StextLine (wrapper for fz_stext_line). */

/** Custom method. */
FZ_FUNCTION StextLineIterator StextLine::begin()
{
	auto ret = StextLineIterator(m_internal->first_char);
	#if 0
	if (s_check_refs)
	{
		s_StextLine_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	#endif
	return ret;
}

/** Custom method. */
FZ_FUNCTION StextLineIterator StextLine::end()
{
	auto ret = StextLineIterator(NULL);
	#if 0
	if (s_check_refs)
	{
		s_StextLine_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	#endif
	return ret;
}

FZ_FUNCTION StextLine::StextLine(fz_stext_line* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long StextLine::m_internal_value()
{
	return (uintptr_t) m_internal;
}


FZ_FUNCTION StextLineIterator::StextLineIterator(const StextChar& item)
: m_item( item)
{
}
FZ_FUNCTION StextLineIterator& StextLineIterator::operator++()
{

	m_item = StextChar(m_item.m_internal->next);
	return *this;
}
FZ_FUNCTION bool StextLineIterator::operator==( const StextLineIterator& rhs)
{
	return m_item.m_internal == rhs.m_item.m_internal;
}
FZ_FUNCTION bool StextLineIterator::operator!=( const StextLineIterator& rhs)
{
	return m_item.m_internal != rhs.m_item.m_internal;
}
FZ_FUNCTION StextChar StextLineIterator::operator*()
{
	return m_item;
}
FZ_FUNCTION StextChar* StextLineIterator::operator->()
{
	return &m_item;
}


/* Implementation of methods for StextOptions (wrapper for fz_stext_options). */

/** Custom constructor. */
FZ_FUNCTION StextOptions::StextOptions()
: flags( 0)
{
}

/** Custom constructor. */
FZ_FUNCTION StextOptions::StextOptions(int flags)
: flags( flags)
{
}

/* Wrapper for `fz_parse_stext_options()`.  */
FZ_FUNCTION StextOptions StextOptions::parse_stext_options(const char *string)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::parse_stext_options()\n";
	}
	auto ret = mupdf::mfz_parse_stext_options(*this, string);
	return ret;
}

FZ_FUNCTION StextOptions::StextOptions(const fz_stext_options* internal)
{
	this->flags = internal->flags;
	this->scale = internal->scale;
}

FZ_FUNCTION StextOptions::StextOptions(const fz_stext_options internal)
{
	this->flags = internal.flags;
	this->scale = internal.scale;
}

/** Constructor using raw copy of pre-existing `fz_stext_options`. */
FZ_FUNCTION fz_stext_options* StextOptions::internal()
{
	auto ret = (fz_stext_options*) &this->flags;
	return ret;
}

/** Constructor using raw copy of pre-existing `fz_stext_options`. */
FZ_FUNCTION const fz_stext_options* StextOptions::internal() const
{
	auto ret = (const fz_stext_options*) &this->flags;
	return ret;
}

FZ_FUNCTION std::string StextOptions::to_string()
{
	std::ostringstream buffer;
	buffer << *this;
	return buffer.str();
}


FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const StextOptions& rhs)
{
	return out << *rhs.internal();
}

/* Implementation of methods for StextPage (wrapper for fz_stext_page). */

/* Constructor using `fz_new_stext_page()`. */
FZ_FUNCTION StextPage::StextPage(Rect& mediabox)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_stext_page()\n";
	}
	this->m_internal = mupdf::new_stext_page(*(fz_rect*) &mediabox.x0);
}

/* Constructor using `fz_new_stext_page_from_chapter_page_number()`. */
FZ_FUNCTION StextPage::StextPage(const Document& doc, int chapter, int number, StextOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_stext_page_from_chapter_page_number()\n";
	}
	this->m_internal = mupdf::new_stext_page_from_chapter_page_number(doc.m_internal, chapter, number, (const fz_stext_options *) &options.flags);
}

/* Constructor using `fz_new_stext_page_from_display_list()`. */
FZ_FUNCTION StextPage::StextPage(const DisplayList& list, StextOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_stext_page_from_display_list()\n";
	}
	this->m_internal = mupdf::new_stext_page_from_display_list(list.m_internal, (const fz_stext_options *) &options.flags);
}

/* Constructor using `fz_new_stext_page_from_page()`. */
FZ_FUNCTION StextPage::StextPage(const Page& page, StextOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_stext_page_from_page()\n";
	}
	this->m_internal = mupdf::new_stext_page_from_page(page.m_internal, (const fz_stext_options *) &options.flags);
}

/* Constructor using `fz_new_stext_page_from_page_number()`. */
FZ_FUNCTION StextPage::StextPage(const Document& doc, int number, StextOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_stext_page_from_page_number()\n";
	}
	this->m_internal = mupdf::new_stext_page_from_page_number(doc.m_internal, number, (const fz_stext_options *) &options.flags);
}

/* Wrapper for `fz_highlight_selection()`.  */
FZ_FUNCTION int StextPage::highlight_selection(Point& a, Point& b, Quad& quads, int max_quads)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::highlight_selection()\n";
	}
	auto ret = mupdf::mfz_highlight_selection(*this, a, b, quads, max_quads);
	return ret;
}

/* Wrapper for `fz_new_buffer_from_stext_page()`.  */
FZ_FUNCTION Buffer StextPage::new_buffer_from_stext_page()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_buffer_from_stext_page()\n";
	}
	auto ret = mupdf::mfz_new_buffer_from_stext_page(*this);
	return ret;
}

/* Wrapper for `fz_new_stext_device()`.  */
FZ_FUNCTION Device StextPage::new_stext_device(StextOptions& options)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_stext_device()\n";
	}
	auto ret = mupdf::mfz_new_stext_device(*this, options);
	return ret;
}

/* Wrapper for `fz_snap_selection()`.  */
FZ_FUNCTION Quad StextPage::snap_selection(Point& ap, Point& bp, int mode)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::snap_selection()\n";
	}
	auto ret = mupdf::mfz_snap_selection(*this, ap, bp, mode);
	return ret;
}

/** Custom method. */
FZ_FUNCTION std::string StextPage::copy_selection(Point& a, Point& b, int crlf)
{
	char* text = mupdf::copy_selection(m_internal, *(fz_point *) &a.x, *(fz_point *) &b.x, crlf);
	std::string ret(text);
	mupdf::free(text);
	return ret;
}

/** Custom method. */
FZ_FUNCTION std::string StextPage::copy_rectangle(Rect& area, int crlf)
{
	char* text = mupdf::copy_rectangle(m_internal, *(fz_rect*) &area.x0, crlf);
	std::string ret(text);
	mupdf::free(text);
	return ret;
}

/** Custom method. */
FZ_FUNCTION std::vector<Quad> StextPage::search_stext_page(const char* needle, int *hit_mark, int max_quads)
{
	std::vector<Quad> ret(max_quads);
	int n = mupdf::search_stext_page(m_internal, needle, hit_mark, ret[0].internal(), max_quads);
	ret.resize(n);
	return ret;
}

/** Custom method. */
FZ_FUNCTION StextPageIterator StextPage::begin()
{
	auto ret = StextPageIterator(m_internal->first_block);
	#if 0
	if (s_check_refs)
	{
		s_StextPage_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	#endif
	return ret;
}

/** Custom method. */
FZ_FUNCTION StextPageIterator StextPage::end()
{
	auto ret = StextPageIterator(NULL);
	#if 0
	if (s_check_refs)
	{
		s_StextPage_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	#endif
	return ret;
}

FZ_FUNCTION StextPage::StextPage(fz_stext_page* internal)
: m_internal(internal)
{
}

FZ_FUNCTION StextPage::~StextPage()
{
	mupdf::drop_stext_page(m_internal);
}

/** Custom method. */
FZ_FUNCTION long long StextPage::m_internal_value()
{
	return (uintptr_t) m_internal;
}


FZ_FUNCTION StextPageIterator::StextPageIterator(const StextBlock& item)
: m_item( item)
{
}
FZ_FUNCTION StextPageIterator& StextPageIterator::operator++()
{

	m_item = StextBlock(m_item.m_internal->next);
	return *this;
}
FZ_FUNCTION bool StextPageIterator::operator==( const StextPageIterator& rhs)
{
	return m_item.m_internal == rhs.m_item.m_internal;
}
FZ_FUNCTION bool StextPageIterator::operator!=( const StextPageIterator& rhs)
{
	return m_item.m_internal != rhs.m_item.m_internal;
}
FZ_FUNCTION StextBlock StextPageIterator::operator*()
{
	return m_item;
}
FZ_FUNCTION StextBlock* StextPageIterator::operator->()
{
	return &m_item;
}


/* Implementation of methods for Storable (wrapper for fz_storable). */

static RefsCheck<fz_storable, Storable> s_Storable_refs_check(offsetof(fz_storable, refs), 32);

/** Copy constructor using `fz_keep_storable()`. */
FZ_FUNCTION Storable::Storable(const Storable& rhs)
: m_internal((fz_storable*) mupdf::keep_storable(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_storable(this->m_internal) and mupdf::keep_storable(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_Storable_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `fz_keep_storable()` and `fz_drop_storable()`. */
FZ_FUNCTION Storable& Storable::operator=(const Storable& rhs)
{
	mupdf::drop_storable(this->m_internal);
	mupdf::keep_storable(rhs.m_internal);
	if (s_check_refs)
	{
		s_Storable_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = (fz_storable*) rhs.m_internal;
	if (s_check_refs)
	{
		s_Storable_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

FZ_FUNCTION Storable::Storable(fz_storable* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_Storable_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION Storable::~Storable()
{
	mupdf::drop_storable(m_internal);
	if (s_check_refs)
	{
		s_Storable_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long Storable::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Store (wrapper for fz_store). */

FZ_FUNCTION Store::Store(fz_store* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long Store::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for StoreHash (wrapper for fz_store_hash). */

FZ_FUNCTION StoreHash::StoreHash(fz_store_hash* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long StoreHash::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for StoreType (wrapper for fz_store_type). */

FZ_FUNCTION StoreType::StoreType(fz_store_type* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long StoreType::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Stream (wrapper for fz_stream). */

static RefsCheck<fz_stream, Stream> s_Stream_refs_check(offsetof(fz_stream, refs), 32);

/* Constructor using `fz_new_stream()`. */
FZ_FUNCTION Stream::Stream(void *state, fz_stream_next_fn *next, fz_stream_drop_fn *drop)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_stream()\n";
	}
	this->m_internal = mupdf::new_stream(state, next, drop);
	if (s_check_refs)
	{
		s_Stream_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_open_file()`. */
FZ_FUNCTION Stream::Stream(const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_file()\n";
	}
	this->m_internal = mupdf::open_file(filename);
	if (s_check_refs)
	{
		s_Stream_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_open_file_ptr_no_close()`. */
FZ_FUNCTION Stream::Stream(FILE *file)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_file_ptr_no_close()\n";
	}
	this->m_internal = mupdf::open_file_ptr_no_close(file);
	if (s_check_refs)
	{
		s_Stream_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_open_memory()`. */
FZ_FUNCTION Stream::Stream(const unsigned char *data, size_t len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_memory()\n";
	}
	this->m_internal = mupdf::open_memory(data, len);
	if (s_check_refs)
	{
		s_Stream_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom constructor. */
FZ_FUNCTION Stream::Stream(const std::string& filename)
: m_internal(mupdf::open_file(filename.c_str()))
{
	if (s_check_refs)
	{
		s_Stream_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Copy constructor using `fz_keep_stream()`. */
FZ_FUNCTION Stream::Stream(const Stream& rhs)
: m_internal(mupdf::keep_stream(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_stream(this->m_internal) and mupdf::keep_stream(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_Stream_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `fz_keep_stream()` and `fz_drop_stream()`. */
FZ_FUNCTION Stream& Stream::operator=(const Stream& rhs)
{
	mupdf::drop_stream(this->m_internal);
	mupdf::keep_stream(rhs.m_internal);
	if (s_check_refs)
	{
		s_Stream_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_Stream_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/* Wrapper for `fz_available()`.  */
FZ_FUNCTION size_t Stream::available(size_t max)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::available()\n";
	}
	auto ret = mupdf::mfz_available(*this, max);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_decomp_image_from_stream()`.
	
	This method has out-params. Python/C# wrappers look like:
		`decomp_image_from_stream(fz_compressed_image *image, fz_irect *subarea, int indexed, int l2factor)` => `(fz_pixmap *, int l2extra)`
	 */
FZ_FUNCTION Pixmap Stream::decomp_image_from_stream(const CompressedImage& image, Irect& subarea, int indexed, int l2factor, int *l2extra)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::decomp_image_from_stream()\n";
	}
	auto ret = mupdf::mfz_decomp_image_from_stream(*this, image, subarea, indexed, l2factor, l2extra);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_is_eof()`.  */
FZ_FUNCTION int Stream::is_eof()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_eof()\n";
	}
	auto ret = mupdf::mfz_is_eof(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_is_eof_bits()`.  */
FZ_FUNCTION int Stream::is_eof_bits()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_eof_bits()\n";
	}
	auto ret = mupdf::mfz_is_eof_bits(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_is_tar_archive()`.  */
FZ_FUNCTION int Stream::is_tar_archive()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_tar_archive()\n";
	}
	auto ret = mupdf::mfz_is_tar_archive(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_is_zip_archive()`.  */
FZ_FUNCTION int Stream::is_zip_archive()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::is_zip_archive()\n";
	}
	auto ret = mupdf::mfz_is_zip_archive(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_open_a85d()`.  */
FZ_FUNCTION Stream Stream::open_a85d()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_a85d()\n";
	}
	auto ret = mupdf::mfz_open_a85d(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_open_aesd()`.  */
FZ_FUNCTION Stream Stream::open_aesd(unsigned char *key, unsigned int keylen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_aesd()\n";
	}
	auto ret = mupdf::mfz_open_aesd(*this, key, keylen);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_open_ahxd()`.  */
FZ_FUNCTION Stream Stream::open_ahxd()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_ahxd()\n";
	}
	auto ret = mupdf::mfz_open_ahxd(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_open_arc4()`.  */
FZ_FUNCTION Stream Stream::open_arc4(unsigned char *key, unsigned int keylen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_arc4()\n";
	}
	auto ret = mupdf::mfz_open_arc4(*this, key, keylen);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_open_dctd()`.  */
FZ_FUNCTION Stream Stream::open_dctd(int color_transform, int l2factor, const Stream& jpegtables)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_dctd()\n";
	}
	auto ret = mupdf::mfz_open_dctd(*this, color_transform, l2factor, jpegtables);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_open_endstream_filter()`.  */
FZ_FUNCTION Stream Stream::open_endstream_filter(uint64_t len, int64_t offset)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_endstream_filter()\n";
	}
	auto ret = mupdf::mfz_open_endstream_filter(*this, len, offset);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_open_faxd()`.  */
FZ_FUNCTION Stream Stream::open_faxd(int k, int end_of_line, int encoded_byte_align, int columns, int rows, int end_of_block, int black_is_1)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_faxd()\n";
	}
	auto ret = mupdf::mfz_open_faxd(*this, k, end_of_line, encoded_byte_align, columns, rows, end_of_block, black_is_1);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_open_flated()`.  */
FZ_FUNCTION Stream Stream::open_flated(int window_bits)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_flated()\n";
	}
	auto ret = mupdf::mfz_open_flated(*this, window_bits);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_open_image_decomp_stream()`.
	
	This method has out-params. Python/C# wrappers look like:
		`open_image_decomp_stream(fz_compression_params *arg_1)` => `(fz_stream *, int l2factor)`
	 */
FZ_FUNCTION Stream Stream::open_image_decomp_stream(const CompressionParams& arg_1, int *l2factor)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_image_decomp_stream()\n";
	}
	auto ret = mupdf::mfz_open_image_decomp_stream(*this, arg_1, l2factor);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_open_jbig2d()`.  */
FZ_FUNCTION Stream Stream::open_jbig2d(const Jbig2Globals& globals, int embedded)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_jbig2d()\n";
	}
	auto ret = mupdf::mfz_open_jbig2d(*this, globals, embedded);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_open_leecher()`.  */
FZ_FUNCTION Stream Stream::open_leecher(const Buffer& buf)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_leecher()\n";
	}
	auto ret = mupdf::mfz_open_leecher(*this, buf);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_open_lzwd()`.  */
FZ_FUNCTION Stream Stream::open_lzwd(int early_change, int min_bits, int reverse_bits, int old_tiff)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_lzwd()\n";
	}
	auto ret = mupdf::mfz_open_lzwd(*this, early_change, min_bits, reverse_bits, old_tiff);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_open_null_filter()`.  */
FZ_FUNCTION Stream Stream::open_null_filter(uint64_t len, int64_t offset)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_null_filter()\n";
	}
	auto ret = mupdf::mfz_open_null_filter(*this, len, offset);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_open_predict()`.  */
FZ_FUNCTION Stream Stream::open_predict(int predictor, int columns, int colors, int bpc)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_predict()\n";
	}
	auto ret = mupdf::mfz_open_predict(*this, predictor, columns, colors, bpc);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_open_range_filter()`.  */
FZ_FUNCTION Stream Stream::open_range_filter(const Range& ranges, int nranges)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_range_filter()\n";
	}
	auto ret = mupdf::mfz_open_range_filter(*this, ranges, nranges);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_open_rld()`.  */
FZ_FUNCTION Stream Stream::open_rld()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_rld()\n";
	}
	auto ret = mupdf::mfz_open_rld(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_open_sgilog16()`.  */
FZ_FUNCTION Stream Stream::open_sgilog16(int w)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_sgilog16()\n";
	}
	auto ret = mupdf::mfz_open_sgilog16(*this, w);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_open_sgilog24()`.  */
FZ_FUNCTION Stream Stream::open_sgilog24(int w)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_sgilog24()\n";
	}
	auto ret = mupdf::mfz_open_sgilog24(*this, w);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_open_sgilog32()`.  */
FZ_FUNCTION Stream Stream::open_sgilog32(int w)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_sgilog32()\n";
	}
	auto ret = mupdf::mfz_open_sgilog32(*this, w);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_open_thunder()`.  */
FZ_FUNCTION Stream Stream::open_thunder(int w)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::open_thunder()\n";
	}
	auto ret = mupdf::mfz_open_thunder(*this, w);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_peek_byte()`.  */
FZ_FUNCTION int Stream::peek_byte()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::peek_byte()\n";
	}
	auto ret = mupdf::mfz_peek_byte(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_read()`.  */
FZ_FUNCTION size_t Stream::read(unsigned char *data, size_t len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read()\n";
	}
	auto ret = mupdf::mfz_read(*this, data, len);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_read_all()`.  */
FZ_FUNCTION Buffer Stream::read_all(size_t initial)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_all()\n";
	}
	auto ret = mupdf::mfz_read_all(*this, initial);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_read_best()`.
	
	This method has out-params. Python/C# wrappers look like:
		`read_best(size_t initial)` => `(fz_buffer *, int truncated)`
	 */
FZ_FUNCTION Buffer Stream::read_best(size_t initial, int *truncated)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_best()\n";
	}
	auto ret = mupdf::mfz_read_best(*this, initial, truncated);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_read_bits()`.  */
FZ_FUNCTION unsigned int Stream::read_bits(int n)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_bits()\n";
	}
	auto ret = mupdf::mfz_read_bits(*this, n);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_read_byte()`.  */
FZ_FUNCTION int Stream::read_byte()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_byte()\n";
	}
	auto ret = mupdf::mfz_read_byte(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_read_float()`.  */
FZ_FUNCTION float Stream::read_float()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_float()\n";
	}
	auto ret = mupdf::mfz_read_float(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_read_float_le()`.  */
FZ_FUNCTION float Stream::read_float_le()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_float_le()\n";
	}
	auto ret = mupdf::mfz_read_float_le(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_read_int16()`.  */
FZ_FUNCTION int16_t Stream::read_int16()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_int16()\n";
	}
	auto ret = mupdf::mfz_read_int16(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_read_int16_le()`.  */
FZ_FUNCTION int16_t Stream::read_int16_le()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_int16_le()\n";
	}
	auto ret = mupdf::mfz_read_int16_le(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_read_int32()`.  */
FZ_FUNCTION int32_t Stream::read_int32()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_int32()\n";
	}
	auto ret = mupdf::mfz_read_int32(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_read_int32_le()`.  */
FZ_FUNCTION int32_t Stream::read_int32_le()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_int32_le()\n";
	}
	auto ret = mupdf::mfz_read_int32_le(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_read_int64()`.  */
FZ_FUNCTION int64_t Stream::read_int64()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_int64()\n";
	}
	auto ret = mupdf::mfz_read_int64(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_read_int64_le()`.  */
FZ_FUNCTION int64_t Stream::read_int64_le()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_int64_le()\n";
	}
	auto ret = mupdf::mfz_read_int64_le(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_read_line()`.  */
FZ_FUNCTION char *Stream::read_line(char *buf, size_t max)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_line()\n";
	}
	auto ret = mupdf::mfz_read_line(*this, buf, max);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_read_rbits()`.  */
FZ_FUNCTION unsigned int Stream::read_rbits(int n)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_rbits()\n";
	}
	auto ret = mupdf::mfz_read_rbits(*this, n);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_read_string()`.  */
FZ_FUNCTION void Stream::read_string(char *buffer, int len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_string()\n";
	}
	mupdf::mfz_read_string(*this, buffer, len);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_read_uint16()`.  */
FZ_FUNCTION uint16_t Stream::read_uint16()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_uint16()\n";
	}
	auto ret = mupdf::mfz_read_uint16(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_read_uint16_le()`.  */
FZ_FUNCTION uint16_t Stream::read_uint16_le()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_uint16_le()\n";
	}
	auto ret = mupdf::mfz_read_uint16_le(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_read_uint24()`.  */
FZ_FUNCTION uint32_t Stream::read_uint24()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_uint24()\n";
	}
	auto ret = mupdf::mfz_read_uint24(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_read_uint24_le()`.  */
FZ_FUNCTION uint32_t Stream::read_uint24_le()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_uint24_le()\n";
	}
	auto ret = mupdf::mfz_read_uint24_le(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_read_uint32()`.  */
FZ_FUNCTION uint32_t Stream::read_uint32()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_uint32()\n";
	}
	auto ret = mupdf::mfz_read_uint32(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_read_uint32_le()`.  */
FZ_FUNCTION uint32_t Stream::read_uint32_le()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_uint32_le()\n";
	}
	auto ret = mupdf::mfz_read_uint32_le(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_read_uint64()`.  */
FZ_FUNCTION uint64_t Stream::read_uint64()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_uint64()\n";
	}
	auto ret = mupdf::mfz_read_uint64(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_read_uint64_le()`.  */
FZ_FUNCTION uint64_t Stream::read_uint64_le()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::read_uint64_le()\n";
	}
	auto ret = mupdf::mfz_read_uint64_le(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_seek()`.  */
FZ_FUNCTION void Stream::seek(int64_t offset, int whence)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::seek()\n";
	}
	mupdf::mfz_seek(*this, offset, whence);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_skip()`.  */
FZ_FUNCTION size_t Stream::skip(size_t len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::skip()\n";
	}
	auto ret = mupdf::mfz_skip(*this, len);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_skip_space()`.  */
FZ_FUNCTION void Stream::skip_space()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::skip_space()\n";
	}
	mupdf::mfz_skip_space(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_skip_string()`.  */
FZ_FUNCTION int Stream::skip_string(const char *str)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::skip_string()\n";
	}
	auto ret = mupdf::mfz_skip_string(*this, str);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_sync_bits()`.  */
FZ_FUNCTION void Stream::sync_bits()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::sync_bits()\n";
	}
	mupdf::mfz_sync_bits(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_tell()`.  */
FZ_FUNCTION int64_t Stream::tell()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::tell()\n";
	}
	auto ret = mupdf::mfz_tell(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_unpack_stream()`.  */
FZ_FUNCTION Stream Stream::unpack_stream(int depth, int w, int h, int n, int indexed, int pad, int skip)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::unpack_stream()\n";
	}
	auto ret = mupdf::mfz_unpack_stream(*this, depth, w, h, n, indexed, pad, skip);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_unread_byte()`.  */
FZ_FUNCTION void Stream::unread_byte()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::unread_byte()\n";
	}
	mupdf::mfz_unread_byte(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `pdf_load_cmap()`.  */
FZ_FUNCTION PdfCmap Stream::load_cmap()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_load_cmap()\n";
	}
	auto ret = mupdf::mpdf_load_cmap(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_open_crypt()`.  */
FZ_FUNCTION Stream Stream::open_crypt(const PdfCrypt& crypt, int num, int gen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_open_crypt()\n";
	}
	auto ret = mupdf::mpdf_open_crypt(*this, crypt, num, gen);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_open_crypt_with_filter()`.  */
FZ_FUNCTION Stream Stream::open_crypt_with_filter(const PdfCrypt& crypt, const PdfObj& name, int num, int gen)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_open_crypt_with_filter()\n";
	}
	auto ret = mupdf::mpdf_open_crypt_with_filter(*this, crypt, name, num, gen);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `pdf_open_document_with_stream()`.  */
FZ_FUNCTION PdfDocument Stream::open_document_with_stream()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::ppdf_open_document_with_stream()\n";
	}
	auto ret = mupdf::mpdf_open_document_with_stream(*this);
	if (s_check_refs)
	{
		s_Stream_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

FZ_FUNCTION Stream::Stream(fz_stream* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_Stream_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION Stream::~Stream()
{
	mupdf::drop_stream(m_internal);
	if (s_check_refs)
	{
		s_Stream_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long Stream::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for StrokeState (wrapper for fz_stroke_state). */

static RefsCheck<fz_stroke_state, StrokeState> s_StrokeState_refs_check(offsetof(fz_stroke_state, refs), 32);

/* Constructor using `fz_new_stroke_state()`. */
FZ_FUNCTION StrokeState::StrokeState()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_stroke_state()\n";
	}
	this->m_internal = mupdf::new_stroke_state();
	if (s_check_refs)
	{
		s_StrokeState_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Constructor using `fz_new_stroke_state_with_dash_len()`. */
FZ_FUNCTION StrokeState::StrokeState(int len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_stroke_state_with_dash_len()\n";
	}
	this->m_internal = mupdf::new_stroke_state_with_dash_len(len);
	if (s_check_refs)
	{
		s_StrokeState_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Copy constructor using `fz_keep_stroke_state()`. */
FZ_FUNCTION StrokeState::StrokeState(const StrokeState& rhs)
: m_internal(mupdf::keep_stroke_state(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_stroke_state(this->m_internal) and mupdf::keep_stroke_state(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_StrokeState_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `fz_keep_stroke_state()` and `fz_drop_stroke_state()`. */
FZ_FUNCTION StrokeState& StrokeState::operator=(const StrokeState& rhs)
{
	mupdf::drop_stroke_state(this->m_internal);
	mupdf::keep_stroke_state(rhs.m_internal);
	if (s_check_refs)
	{
		s_StrokeState_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_StrokeState_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/* Wrapper for `fz_clone_stroke_state()`.  */
FZ_FUNCTION StrokeState StrokeState::clone_stroke_state()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::clone_stroke_state()\n";
	}
	auto ret = mupdf::mfz_clone_stroke_state(*this);
	if (s_check_refs)
	{
		s_StrokeState_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_unshare_stroke_state()`.  */
FZ_FUNCTION StrokeState StrokeState::unshare_stroke_state()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::unshare_stroke_state()\n";
	}
	auto ret = mupdf::mfz_unshare_stroke_state(*this);
	if (s_check_refs)
	{
		s_StrokeState_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_unshare_stroke_state_with_dash_len()`.  */
FZ_FUNCTION StrokeState StrokeState::unshare_stroke_state_with_dash_len(int len)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::unshare_stroke_state_with_dash_len()\n";
	}
	auto ret = mupdf::mfz_unshare_stroke_state_with_dash_len(*this, len);
	if (s_check_refs)
	{
		s_StrokeState_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

FZ_FUNCTION StrokeState::StrokeState(fz_stroke_state* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_StrokeState_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION StrokeState::~StrokeState()
{
	mupdf::drop_stroke_state(m_internal);
	if (s_check_refs)
	{
		s_StrokeState_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long StrokeState::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for StyleContext (wrapper for fz_style_context). */

FZ_FUNCTION StyleContext::StyleContext(fz_style_context* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long StyleContext::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Text (wrapper for fz_text). */

static RefsCheck<fz_text, Text> s_Text_refs_check(offsetof(fz_text, refs), 32);

/* Constructor using `fz_new_text()`. */
FZ_FUNCTION Text::Text()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_text()\n";
	}
	this->m_internal = mupdf::new_text();
	if (s_check_refs)
	{
		s_Text_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Copy constructor using `fz_keep_text()`. */
FZ_FUNCTION Text::Text(const Text& rhs)
: m_internal(mupdf::keep_text(rhs.m_internal))
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::drop_text(this->m_internal) and mupdf::keep_text(rhs.m_internal)\n";
	}
	if (s_check_refs)
	{
		s_Text_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* operator= using `fz_keep_text()` and `fz_drop_text()`. */
FZ_FUNCTION Text& Text::operator=(const Text& rhs)
{
	mupdf::drop_text(this->m_internal);
	mupdf::keep_text(rhs.m_internal);
	if (s_check_refs)
	{
		s_Text_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
	this->m_internal = rhs.m_internal;
	if (s_check_refs)
	{
		s_Text_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return *this;
}

/* Wrapper for `fz_bound_text()`.  */
FZ_FUNCTION Rect Text::bound_text(const StrokeState& stroke, Matrix& ctm)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::bound_text()\n";
	}
	auto ret = mupdf::mfz_bound_text(*this, stroke, ctm);
	if (s_check_refs)
	{
		s_Text_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

/* Wrapper for `fz_show_glyph()`.  */
FZ_FUNCTION void Text::show_glyph(const Font& font, Matrix& trm, int glyph, int unicode, int wmode, int bidi_level, fz_bidi_direction markup_dir, fz_text_language language)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::show_glyph()\n";
	}
	mupdf::mfz_show_glyph(*this, font, trm, glyph, unicode, wmode, bidi_level, markup_dir, language);
	if (s_check_refs)
	{
		s_Text_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/* Wrapper for `fz_show_string()`.  */
FZ_FUNCTION Matrix Text::show_string(const Font& font, Matrix& trm, const char *s, int wmode, int bidi_level, fz_bidi_direction markup_dir, fz_text_language language)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::show_string()\n";
	}
	auto ret = mupdf::mfz_show_string(*this, font, trm, s, wmode, bidi_level, markup_dir, language);
	if (s_check_refs)
	{
		s_Text_refs_check.check( this, __FILE__, __LINE__, __FUNCTION__);
	}
	return ret;
}

FZ_FUNCTION Text::Text(fz_text* internal)
: m_internal(internal)
{
	if (s_check_refs)
	{
		s_Text_refs_check.add( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

FZ_FUNCTION Text::~Text()
{
	mupdf::drop_text(m_internal);
	if (s_check_refs)
	{
		s_Text_refs_check.remove( this, __FILE__, __LINE__, __FUNCTION__);
	}
}

/** Custom method. */
FZ_FUNCTION long long Text::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for TextItem (wrapper for fz_text_item). */

FZ_FUNCTION TextItem::TextItem(fz_text_item* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long TextItem::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for TextSpan (wrapper for fz_text_span). */

FZ_FUNCTION TextSpan::TextSpan(fz_text_span* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long TextSpan::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Transition (wrapper for fz_transition). */

FZ_FUNCTION Transition::Transition(const fz_transition* internal)
{
	this->type = internal->type;
	this->duration = internal->duration;
	this->vertical = internal->vertical;
	this->outwards = internal->outwards;
	this->direction = internal->direction;
	this->state0 = internal->state0;
	this->state1 = internal->state1;
}

FZ_FUNCTION Transition::Transition(const fz_transition internal)
{
	this->type = internal.type;
	this->duration = internal.duration;
	this->vertical = internal.vertical;
	this->outwards = internal.outwards;
	this->direction = internal.direction;
	this->state0 = internal.state0;
	this->state1 = internal.state1;
}

/** Constructor using raw copy of pre-existing `fz_transition`. */
FZ_FUNCTION fz_transition* Transition::internal()
{
	auto ret = (fz_transition*) &this->type;
	return ret;
}

/** Constructor using raw copy of pre-existing `fz_transition`. */
FZ_FUNCTION const fz_transition* Transition::internal() const
{
	auto ret = (const fz_transition*) &this->type;
	return ret;
}

FZ_FUNCTION std::string Transition::to_string()
{
	std::ostringstream buffer;
	buffer << *this;
	return buffer.str();
}


FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const Transition& rhs)
{
	return out << *rhs.internal();
}

/* Implementation of methods for Tree (wrapper for fz_tree). */

/* Wrapper for `fz_tree_lookup()`.  */
FZ_FUNCTION void *Tree::tree_lookup(const char *key)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::tree_lookup()\n";
	}
	auto ret = mupdf::mfz_tree_lookup(*this, key);
	return ret;
}

FZ_FUNCTION Tree::Tree(fz_tree* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long Tree::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for TuningContext (wrapper for fz_tuning_context). */

FZ_FUNCTION TuningContext::TuningContext(fz_tuning_context* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long TuningContext::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Vertex (wrapper for fz_vertex). */

FZ_FUNCTION Vertex::Vertex(fz_vertex* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long Vertex::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for WarnContext (wrapper for fz_warn_context). */

FZ_FUNCTION WarnContext::WarnContext(fz_warn_context* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long WarnContext::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for Xml (wrapper for fz_xml). */

/* Wrapper for `fz_debug_xml()`.  */
FZ_FUNCTION void Xml::debug_xml(int level)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::debug_xml()\n";
	}
	mupdf::mfz_debug_xml(*this, level);
}

/* Wrapper for `fz_xml_att()`.  */
FZ_FUNCTION char *Xml::xml_att(const char *att)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::xml_att()\n";
	}
	auto ret = mupdf::mfz_xml_att(*this, att);
	return ret;
}

/* Wrapper for `fz_xml_att_alt()`.  */
FZ_FUNCTION char *Xml::xml_att_alt(const char *one, const char *two)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::xml_att_alt()\n";
	}
	auto ret = mupdf::mfz_xml_att_alt(*this, one, two);
	return ret;
}

/* Wrapper for `fz_xml_att_eq()`.  */
FZ_FUNCTION int Xml::xml_att_eq(const char *name, const char *match)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::xml_att_eq()\n";
	}
	auto ret = mupdf::mfz_xml_att_eq(*this, name, match);
	return ret;
}

/* Wrapper for `fz_xml_is_tag()`.  */
FZ_FUNCTION int Xml::xml_is_tag(const char *name)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::xml_is_tag()\n";
	}
	auto ret = mupdf::mfz_xml_is_tag(*this, name);
	return ret;
}

/* Wrapper for `fz_xml_tag()`.  */
FZ_FUNCTION char *Xml::xml_tag()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::xml_tag()\n";
	}
	auto ret = mupdf::mfz_xml_tag(*this);
	return ret;
}

/* Wrapper for `fz_xml_text()`.  */
FZ_FUNCTION char *Xml::xml_text()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::xml_text()\n";
	}
	auto ret = mupdf::mfz_xml_text(*this);
	return ret;
}

FZ_FUNCTION Xml::Xml(fz_xml* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long Xml::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for XmlDoc (wrapper for fz_xml_doc). */

/* Wrapper for `fz_detach_xml()`.  */
FZ_FUNCTION void XmlDoc::detach_xml(const Xml& node)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::detach_xml()\n";
	}
	mupdf::mfz_detach_xml(*this, node);
}

/* Wrapper for `fz_new_display_list_from_svg_xml()`.
	
	This method has out-params. Python/C# wrappers look like:
		`new_display_list_from_svg_xml(fz_xml *xml, const char *base_uri, fz_archive *zip)` => `(fz_display_list *, float w, float h)`
	 */
FZ_FUNCTION DisplayList XmlDoc::new_display_list_from_svg_xml(const Xml& xml, const char *base_uri, const Archive& zip, float *w, float *h)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_display_list_from_svg_xml()\n";
	}
	auto ret = mupdf::mfz_new_display_list_from_svg_xml(*this, xml, base_uri, zip, w, h);
	return ret;
}

/* Wrapper for `fz_new_image_from_svg_xml()`.  */
FZ_FUNCTION Image XmlDoc::new_image_from_svg_xml(const Xml& xml, const char *base_uri, const Archive& zip)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_image_from_svg_xml()\n";
	}
	auto ret = mupdf::mfz_new_image_from_svg_xml(*this, xml, base_uri, zip);
	return ret;
}

FZ_FUNCTION XmlDoc::XmlDoc(fz_xml_doc* internal)
: m_internal(internal)
{
}

/** Custom method. */
FZ_FUNCTION long long XmlDoc::m_internal_value()
{
	return (uintptr_t) m_internal;
}


/* Implementation of methods for ZipWriter (wrapper for fz_zip_writer). */

/* Constructor using `fz_new_zip_writer()`. */
FZ_FUNCTION ZipWriter::ZipWriter(const char *filename)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_zip_writer()\n";
	}
	this->m_internal = mupdf::new_zip_writer(filename);
}

/* Constructor using `fz_new_zip_writer_with_output()`. */
FZ_FUNCTION ZipWriter::ZipWriter(const Output& out)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::new_zip_writer_with_output()\n";
	}
	this->m_internal = mupdf::new_zip_writer_with_output(out.m_internal);
}

/* Wrapper for `fz_close_zip_writer()`.  */
FZ_FUNCTION void ZipWriter::close_zip_writer()
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::close_zip_writer()\n";
	}
	mupdf::mfz_close_zip_writer(*this);
}

/* Wrapper for `fz_write_zip_entry()`.  */
FZ_FUNCTION void ZipWriter::write_zip_entry(const char *name, const Buffer& buf, int compress)
{
	if (s_trace) {
		std::cerr << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): calling mupdf::write_zip_entry()\n";
	}
	mupdf::mfz_write_zip_entry(*this, name, buf, compress);
}

FZ_FUNCTION ZipWriter::ZipWriter(fz_zip_writer* internal)
: m_internal(internal)
{
}

FZ_FUNCTION ZipWriter::~ZipWriter()
{
	mupdf::drop_zip_writer(m_internal);
}

/** Custom method. */
FZ_FUNCTION long long ZipWriter::m_internal_value()
{
	return (uintptr_t) m_internal;
}


} /* End of namespace mupdf. */
