/**
This file was auto-generated by mupdfwrap.py.
*/

#ifndef MUPDF_FUNCTIONS_H
#define MUPDF_FUNCTIONS_H


#include "mupdf/fitz.h"
#include "mupdf/pdf.h"

#include <iostream>
#include <string>
#include <vector>


namespace mupdf
{

/*
The keys that are defined for fz_lookup_metadata().
*/
FZ_DATA extern const std::vector<std::string> metadata_keys;

/** Wrapper for `fz_aa_level()`. */
/**
	Get the number of bits of antialiasing we are
	using (for graphics). Between 0 and 8.
*/
FZ_FUNCTION int aa_level();

/** Wrapper for `fz_abs()`. */
/**
	Some standard math functions, done as static inlines for speed.
	People with compilers that do not adequately implement inline
	may like to reimplement these using macros.
*/
FZ_FUNCTION float abs(float f);

/** Wrapper for `fz_absi()`. */
FZ_FUNCTION int absi(int i);

/** Wrapper for `fz_add_layout_char()`. */
/**
	Add a new char to the line at the end of the layout block.
*/
FZ_FUNCTION void add_layout_char(fz_layout_block *block, float x, float w, const char *p);

/** Wrapper for `fz_add_layout_line()`. */
/**
	Add a new line to the end of the layout block.
*/
FZ_FUNCTION void add_layout_line(fz_layout_block *block, float x, float y, float h, const char *p);

/** Wrapper for `fz_add_separation()`. */
/**
	Add a separation (null terminated name, colorspace)
*/
FZ_FUNCTION void add_separation(fz_separations *sep, const char *name, fz_colorspace *cs, int cs_channel);

/** Wrapper for `fz_add_separation_equivalents()`. */
/**
	Add a separation with equivalents (null terminated name,
	colorspace)

	(old, deprecated)
*/
FZ_FUNCTION void add_separation_equivalents(fz_separations *sep, uint32_t rgba, uint32_t cmyk, const char *name);

/** Wrapper for `fz_adjust_rect_for_stroke()`. */
/**
	Given a rectangle (assumed to be the bounding box for a path),
	expand it to allow for the expansion of the bbox that would be
	seen by stroking the path with the given stroke state and
	transform.
*/
FZ_FUNCTION fz_rect adjust_rect_for_stroke(fz_rect rect, const fz_stroke_state *stroke, fz_matrix ctm);

/** Wrapper for `fz_advance_glyph()`. */
/**
	Return the advance for a given glyph.

	font: The font to look for the glyph in.

	glyph: The glyph to find the advance for.

	wmode: 1 for vertical mode, 0 for horizontal.

	Returns the advance for the glyph.
*/
FZ_FUNCTION float advance_glyph(fz_font *font, int glyph, int wmode);

/** Wrapper for `fz_aes_crypt_cbc()`. */
/**
	AES block processing. Encrypts or Decrypts (according to mode,
	which must match what was initially set up) length bytes (which
	must be a multiple of 16), using (and modifying) the insertion
	vector iv, reading from input, and writing to output.

	Never throws an exception.
*/
FZ_FUNCTION void aes_crypt_cbc(fz_aes *ctx, int mode, size_t length, unsigned char iv[16], const unsigned char *input, unsigned char *output);

/** Wrapper for `fz_aes_setkey_dec()`. */
/**
	AES decryption intialisation. Fills in the supplied context
	and prepares for decryption using the given key.

	Returns non-zero for error (key size other than 128/192/256).

	Never throws an exception.
*/
FZ_FUNCTION int aes_setkey_dec(fz_aes *ctx, const unsigned char *key, int keysize);

/** Wrapper for `fz_aes_setkey_enc()`. */
/**
	AES encryption intialisation. Fills in the supplied context
	and prepares for encryption using the given key.

	Returns non-zero for error (key size other than 128/192/256).

	Never throws an exception.
*/
FZ_FUNCTION int aes_setkey_enc(fz_aes *ctx, const unsigned char *key, int keysize);

/** Wrapper for `fz_alpha_from_gray()`. */
FZ_FUNCTION fz_pixmap *alpha_from_gray(fz_pixmap *gray);

/** Wrapper for `fz_append_bits()`. */
FZ_FUNCTION void append_bits(fz_buffer *buf, int value, int count);

/** Wrapper for `fz_append_bits_pad()`. */
FZ_FUNCTION void append_bits_pad(fz_buffer *buf);

/** Wrapper for `fz_append_buffer()`. */
/**
	Append the contents of the source buffer onto the end of the
	destination buffer, extending automatically as required.

	Ownership of buffers does not change.
*/
FZ_FUNCTION void append_buffer(fz_buffer *destination, fz_buffer *source);

/** Wrapper for `fz_append_byte()`. */
FZ_FUNCTION void append_byte(fz_buffer *buf, int c);

/** Wrapper for `fz_append_data()`. */
/**
	fz_append_*: Append data to a buffer.

	The buffer will automatically grow as required.
*/
FZ_FUNCTION void append_data(fz_buffer *buf, const void *data, size_t len);

/** Wrapper for `fz_append_int16_be()`. */
FZ_FUNCTION void append_int16_be(fz_buffer *buf, int x);

/** Wrapper for `fz_append_int16_le()`. */
FZ_FUNCTION void append_int16_le(fz_buffer *buf, int x);

/** Wrapper for `fz_append_int32_be()`. */
FZ_FUNCTION void append_int32_be(fz_buffer *buf, int x);

/** Wrapper for `fz_append_int32_le()`. */
FZ_FUNCTION void append_int32_le(fz_buffer *buf, int x);

/** Wrapper for `fz_append_pdf_string()`. */
/**
	fz_append_pdf_string: Append a string with PDF syntax quotes and
	escapes.

	The buffer will automatically grow as required.
*/
FZ_FUNCTION void append_pdf_string(fz_buffer *buffer, const char *text);

/** Wrapper for `fz_append_rune()`. */
FZ_FUNCTION void append_rune(fz_buffer *buf, int c);

/** Wrapper for `fz_append_string()`. */
FZ_FUNCTION void append_string(fz_buffer *buf, const char *data);

/** Wrapper for `fz_append_vprintf()`. */
/**
	fz_append_vprintf: Format and append data to buffer using
	printf-like formatting with varargs (see fz_vsnprintf).
*/
FZ_FUNCTION void append_vprintf(fz_buffer *buffer, const char *fmt, va_list args);

/** Wrapper for `fz_arc4_encrypt()`. */
/**
	RC4 block encrypt operation; encrypt src into dst (both of
	length len) updating the RC4 state as we go.

	Never throws an exception.
*/
FZ_FUNCTION void arc4_encrypt(fz_arc4 *state, unsigned char *dest, const unsigned char *src, size_t len);

/** Wrapper for `fz_arc4_init()`. */
/**
	RC4 initialization. Begins an RC4 operation, writing a new
	context.

	Never throws an exception.
*/
FZ_FUNCTION void arc4_init(fz_arc4 *state, const unsigned char *key, size_t len);

/** Wrapper for `fz_archive_format()`. */
/**
	Return a pointer to a string describing the format of the
	archive.

	The lifetime of the string is unspecified (in current
	implementations the string will persist until the archive
	is closed, but this is not guaranteed).
*/
FZ_FUNCTION const char *archive_format(fz_archive *arch);

/** Wrapper for `fz_atof()`. */
/**
	Range checking atof
*/
FZ_FUNCTION float atof(const char *s);

/** Wrapper for `fz_atoi()`. */
/**
	atoi that copes with NULL
*/
FZ_FUNCTION int atoi(const char *s);

/** Wrapper for `fz_atoi64()`. */
/**
	64bit atoi that copes with NULL
*/
FZ_FUNCTION int64_t atoi64(const char *s);

/** Wrapper for `fz_authenticate_password()`. */
/**
	Test if the given password can decrypt the document.

	password: The password string to be checked. Some document
	specifications do not specify any particular text encoding, so
	neither do we.

	Returns 0 for failure to authenticate, non-zero for success.

	For PDF documents, further information can be given by examining
	the bits in the return code.

		Bit 0 => No password required
		Bit 1 => User password authenticated
		Bit 2 => Owner password authenticated
*/
FZ_FUNCTION int authenticate_password(fz_document *doc, const char *password);

/** Wrapper for `fz_available()`. */
/**
	Ask how many bytes are available immediately from
	a given stream.

	stm: The stream to read from.

	max: A hint for the underlying stream; the maximum number of
	bytes that we are sure we will want to read. If you do not know
	this number, give 1.

	Returns the number of bytes immediately available between the
	read and write pointers. This number is guaranteed only to be 0
	if we have hit EOF. The number of bytes returned here need have
	no relation to max (could be larger, could be smaller).
*/
FZ_FUNCTION size_t available(fz_stream *stm, size_t max);

/** Wrapper for `fz_begin_group()`. */
FZ_FUNCTION void begin_group(fz_device *dev, fz_rect area, fz_colorspace *cs, int isolated, int knockout, int blendmode, float alpha);

/** Wrapper for `fz_begin_layer()`. */
FZ_FUNCTION void begin_layer(fz_device *dev, const char *layer_name);

/** Wrapper for `fz_begin_mask()`. */
FZ_FUNCTION void begin_mask(fz_device *dev, fz_rect area, int luminosity, fz_colorspace *colorspace, const float *bc, fz_color_params color_params);

/** Wrapper for `fz_begin_page()`. */
/**
	Called to start the process of writing a page to
	a document.

	mediabox: page size rectangle in points.

	Returns a borrowed fz_device to write page contents to. This
	should be kept if required, and only dropped if it was kept.
*/
FZ_FUNCTION fz_device *begin_page(fz_document_writer *wri, fz_rect mediabox);

/** Wrapper for `fz_begin_tile()`. */
FZ_FUNCTION void begin_tile(fz_device *dev, fz_rect area, fz_rect view, float xstep, float ystep, fz_matrix ctm);

/** Wrapper for `fz_begin_tile_id()`. */
FZ_FUNCTION int begin_tile_id(fz_device *dev, fz_rect area, fz_rect view, float xstep, float ystep, fz_matrix ctm, int id);

/** Wrapper for `fz_bidi_fragment_text()`. */
/**
	Partitions the given Unicode sequence into one or more
	unidirectional fragments and invokes the given callback
	function for each fragment.

	For example, if directionality of text is:
			0123456789
			rrlllrrrrr,
	we'll invoke callback with:
			&text[0], length == 2
			&text[2], length == 3
			&text[5], length == 5

	@param[in] text	start of Unicode sequence
	@param[in] textlen   number of Unicodes to analyse
	@param[in] baseDir   direction of paragraph (specify FZ_BIDI_NEUTRAL to force auto-detection)
	@param[in] callback  function to be called for each fragment
	@param[in] arg	data to be passed to the callback function
	@param[in] flags     flags to control operation (see fz_bidi_flags above)
*/
FZ_FUNCTION void bidi_fragment_text(const uint32_t *text, size_t textlen, fz_bidi_direction *baseDir, fz_bidi_fragment_fn *callback, void *arg, int flags);

/** Wrapper for `fz_bitmap_details()`.

This function has out-params. Python/C# wrappers look like:
	`bitmap_details(fz_bitmap *bitmap)` => `(int w, int h, int n, int stride)`
*/
/**
	Retrieve details of a given bitmap.

	bitmap: The bitmap to query.

	w: Pointer to storage to retrieve width (or NULL).

	h: Pointer to storage to retrieve height (or NULL).

	n: Pointer to storage to retrieve number of color components (or
	NULL).

	stride: Pointer to storage to retrieve bitmap stride (or NULL).
*/
FZ_FUNCTION void bitmap_details(fz_bitmap *bitmap, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *w
		#endif
		, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *h
		#endif
		, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *n
		#endif
		, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *stride
		#endif
		);

/** Wrapper for `fz_blendmode_name()`. */
/**
	Map from enumeration to blend mode string.

	The string is static, with arbitrary lifespan.
*/
FZ_FUNCTION const char *blendmode_name(int blendmode);

/** Wrapper for `fz_bound_display_list()`. */
/**
	Return the bounding box of the page recorded in a display list.
*/
FZ_FUNCTION fz_rect bound_display_list(fz_display_list *list);

/** Wrapper for `fz_bound_glyph()`. */
/**
	Return a bbox for a given glyph in a font.

	font: The font to look for the glyph in.

	gid: The glyph to bound.

	trm: The matrix to apply to the glyph before bounding.

	Returns rectangle by value containing the bounds of the given
	glyph.
*/
FZ_FUNCTION fz_rect bound_glyph(fz_font *font, int gid, fz_matrix trm);

/** Wrapper for `fz_bound_page()`. */
/**
	Determine the size of a page at 72 dpi.
*/
FZ_FUNCTION fz_rect bound_page(fz_page *page);

/** Wrapper for `fz_bound_path()`. */
/**
	Return a bounding rectangle for a path.

	path: The path to bound.

	stroke: If NULL, the bounding rectangle given is for
	the filled path. If non-NULL the bounding rectangle
	given is for the path stroked with the given attributes.

	ctm: The matrix to apply to the path during stroking.

	r: Pointer to a fz_rect which will be used to hold
	the result.

	Returns r, updated to contain the bounding rectangle.
*/
FZ_FUNCTION fz_rect bound_path(const fz_path *path, const fz_stroke_state *stroke, fz_matrix ctm);

/** Wrapper for `fz_bound_shade()`. */
/**
	Bound a given shading.

	shade: The shade to bound.

	ctm: The transform to apply to the shade before bounding.

	r: Pointer to storage to put the bounds in.

	Returns r, updated to contain the bounds for the shading.
*/
FZ_FUNCTION fz_rect bound_shade(fz_shade *shade, fz_matrix ctm);

/** Wrapper for `fz_bound_text()`. */
/**
	Find the bounds of a given text object.

	text: The text object to find the bounds of.

	stroke: Pointer to the stroke attributes (for stroked
	text), or NULL (for filled text).

	ctm: The matrix in use.

	r: pointer to storage for the bounds.

	Returns a pointer to r, which is updated to contain the
	bounding box for the text object.
*/
FZ_FUNCTION fz_rect bound_text(const fz_text *text, const fz_stroke_state *stroke, fz_matrix ctm);

/** Wrapper for `fz_buffer_extract()`.

This function has out-params. Python/C# wrappers look like:
	`buffer_extract(fz_buffer *buf)` => `(size_t, unsigned char *data)`
*/
/**
	Take ownership of buffer contents.

	Performs the same task as fz_buffer_storage, but ownership of
	the data buffer returns with this call. The buffer is left
	empty.

	Note: Bad things may happen if this is called on a buffer with
	multiple references that is being used from multiple threads.

	data: Pointer to place to retrieve data pointer.

	Returns length of stream.
*/
FZ_FUNCTION size_t buffer_extract(fz_buffer *buf, 
		#ifdef SWIG
			unsigned char **OUTPUT
		#else
			unsigned char **data
		#endif
		);

/** Wrapper for `fz_buffer_storage()`.

This function has out-params. Python/C# wrappers look like:
	`buffer_storage(fz_buffer *buf)` => `(size_t, unsigned char *datap)`
*/
/**
	Retrieve internal memory of buffer.

	datap: Output parameter that will be pointed to the data.

	Returns the current size of the data in bytes.
*/
FZ_FUNCTION size_t buffer_storage(fz_buffer *buf, 
		#ifdef SWIG
			unsigned char **OUTPUT
		#else
			unsigned char **datap
		#endif
		);

/** Wrapper for `fz_calloc()`. */
/**
	Allocate array of memory of count entries of size bytes.
	Clears the memory to zero.

	Throws exception in the event of failure to allocate.
*/
FZ_FUNCTION void *calloc(size_t count, size_t size);

/** Wrapper for `fz_calloc_no_throw()`. */
/**
	fz_calloc equivalent that returns NULL rather than throwing
	exceptions.
*/
FZ_FUNCTION void *calloc_no_throw(size_t count, size_t size);

/** Wrapper for `fz_caught()`. */
FZ_FUNCTION int caught();

/** Wrapper for `fz_caught_message()`. */
FZ_FUNCTION const char *caught_message();

/** Wrapper for `fz_chartorune()`.

This function has out-params. Python/C# wrappers look like:
	`chartorune(const char *str)` => `(int, int rune)`
*/
/**
	UTF8 decode a single rune from a sequence of chars.

	rune: Pointer to an int to assign the decoded 'rune' to.

	str: Pointer to a UTF8 encoded string.

	Returns the number of bytes consumed.
*/
FZ_FUNCTION int chartorune(
		#ifdef SWIG
			int *OUTPUT
		#else
			int *rune
		#endif
		, const char *str);

/** Wrapper for `fz_clamp()`. */
FZ_FUNCTION float clamp(float f, float min, float max);

/** Wrapper for `fz_clamp_color()`.

This function has out-params. Python/C# wrappers look like:
	`clamp_color(fz_colorspace *cs, const float *in)` => float out
*/
/**
	Clamp the samples in a color to the correct ranges for a
	given colorspace.
*/
FZ_FUNCTION void clamp_color(fz_colorspace *cs, const float *in, 
		#ifdef SWIG
			float *OUTPUT
		#else
			float *out
		#endif
		);

/** Wrapper for `fz_clamp_location()`. */
/**
	Clamps a location into valid chapter/page range. (First clamps
	the chapter into range, then the page into range).
*/
FZ_FUNCTION fz_location clamp_location(fz_document *doc, fz_location loc);

/** Wrapper for `fz_clampd()`. */
FZ_FUNCTION double clampd(double d, double min, double max);

/** Wrapper for `fz_clampi()`. */
FZ_FUNCTION int clampi(int i, int min, int max);

/** Wrapper for `fz_clampp()`. */
FZ_FUNCTION void *clampp(void *p, void *min, void *max);

/** Wrapper for `fz_cleanname()`. */
/**
	rewrite path to the shortest string that names the same path.

	Eliminates multiple and trailing slashes, interprets "." and
	"..". Overwrites the string in place.
*/
FZ_FUNCTION char *cleanname(char *name);

/** Wrapper for `fz_clear_bitmap()`. */
/**
	Set the entire bitmap to 0.

	Never throws exceptions.
*/
FZ_FUNCTION void clear_bitmap(fz_bitmap *bit);

/** Wrapper for `fz_clear_buffer()`. */
/**
	Empties the buffer. Storage is not freed, but is held ready
	to be reused as the buffer is refilled.

	Never throws exceptions.
*/
FZ_FUNCTION void clear_buffer(fz_buffer *buf);

/** Wrapper for `fz_clear_pixmap()`. */
/**
	Sets all components (including alpha) of
	all pixels in a pixmap to 0.

	pix: The pixmap to clear.
*/
FZ_FUNCTION void clear_pixmap(fz_pixmap *pix);

/** Wrapper for `fz_clear_pixmap_rect_with_value()`. */
/**
	Clears a subrect of a pixmap with the given value.

	pix: The pixmap to clear.

	value: Values in the range 0 to 255 are valid. Each component
	sample for each pixel in the pixmap will be set to this value,
	while alpha will always be set to 255 (non-transparent).

	r: the rectangle.
*/
FZ_FUNCTION void clear_pixmap_rect_with_value(fz_pixmap *pix, int value, fz_irect r);

/** Wrapper for `fz_clear_pixmap_with_value()`. */
/**
	Clears a pixmap with the given value.

	pix: The pixmap to clear.

	value: Values in the range 0 to 255 are valid. Each component
	sample for each pixel in the pixmap will be set to this value,
	while alpha will always be set to 255 (non-transparent).

	This function is horrible, and should be removed from the
	API and replaced with a less magic one.
*/
FZ_FUNCTION void clear_pixmap_with_value(fz_pixmap *pix, int value);

/** Wrapper for `fz_clip_image_mask()`. */
FZ_FUNCTION void clip_image_mask(fz_device *dev, fz_image *image, fz_matrix ctm, fz_rect scissor);

/** Wrapper for `fz_clip_path()`. */
FZ_FUNCTION void clip_path(fz_device *dev, const fz_path *path, int even_odd, fz_matrix ctm, fz_rect scissor);

/** Wrapper for `fz_clip_stroke_path()`. */
FZ_FUNCTION void clip_stroke_path(fz_device *dev, const fz_path *path, const fz_stroke_state *stroke, fz_matrix ctm, fz_rect scissor);

/** Wrapper for `fz_clip_stroke_text()`. */
FZ_FUNCTION void clip_stroke_text(fz_device *dev, const fz_text *text, const fz_stroke_state *stroke, fz_matrix ctm, fz_rect scissor);

/** Wrapper for `fz_clip_text()`. */
FZ_FUNCTION void clip_text(fz_device *dev, const fz_text *text, fz_matrix ctm, fz_rect scissor);

/** Wrapper for `fz_clone_context()`. */
/**
	Make a clone of an existing context.

	This function is meant to be used in multi-threaded
	applications where each thread requires its own context, yet
	parts of the global state, for example caching, are shared.

	ctx: Context obtained from fz_new_context to make a copy of.
	ctx must have had locks and lock/functions setup when created.
	The two contexts will share the memory allocator, resource
	store, locks and lock/unlock functions. They will each have
	their own exception stacks though.

	May return NULL.
*/
FZ_FUNCTION fz_context *clone_context();

/** Wrapper for `fz_clone_default_colorspaces()`. */
/**
	Returns a reference to a newly cloned default colorspaces
	structure.

	The new clone may safely be altered without fear of race
	conditions as the caller is the only reference holder.
*/
FZ_FUNCTION fz_default_colorspaces *clone_default_colorspaces(fz_default_colorspaces *base);

/** Wrapper for `fz_clone_path()`. */
/**
	Clone the data for a path.

	This is used in preference to fz_keep_path when a whole
	new copy of a path is required, rather than just a shared
	pointer. This probably indicates that the path is about to
	be modified.

	path: path to clone.

	Throws exceptions on failure to allocate.
*/
FZ_FUNCTION fz_path *clone_path(fz_path *path);

/** Wrapper for `fz_clone_pixmap()`. */
/**
	Clone a pixmap, copying the pixels and associated data to new
	storage.

	The reference count of 'old' is unchanged.
*/
FZ_FUNCTION fz_pixmap *clone_pixmap(const fz_pixmap *old);

/** Wrapper for `fz_clone_pixmap_area_with_different_seps()`. */
FZ_FUNCTION fz_pixmap *clone_pixmap_area_with_different_seps(fz_pixmap *src, const fz_irect *bbox, fz_colorspace *dcs, fz_separations *seps, fz_color_params color_params, fz_default_colorspaces *default_cs);

/** Wrapper for `fz_clone_separations_for_overprint()`. */
/**
	Return a separations object with all the spots in the input
	separations object that are set to composite, reset to be
	enabled. If there ARE no spots in the object, this returns
	NULL. If the object already has all its spots enabled, then
	just returns another handle on the same object.
*/
FZ_FUNCTION fz_separations *clone_separations_for_overprint(fz_separations *seps);

/** Wrapper for `fz_clone_stroke_state()`. */
/**
	Create an identical stroke_state structure and return a
	reference to it.

	stroke: The stroke state reference to clone.

	Exceptions may be thrown in the event of a failure to
	allocate.
*/
FZ_FUNCTION fz_stroke_state *clone_stroke_state(fz_stroke_state *stroke);

/** Wrapper for `fz_close_band_writer()`. */
/**
	Finishes up the output and closes the band writer. After this
	call no more headers or bands may be written.
*/
FZ_FUNCTION void close_band_writer(fz_band_writer *writer);

/** Wrapper for `fz_close_device()`. */
/**
	Signal the end of input, and flush any buffered output.
	This is NOT called implicitly on fz_drop_device. This
	may throw exceptions.
*/
FZ_FUNCTION void close_device(fz_device *dev);

/** Wrapper for `fz_close_document_writer()`. */
/**
	Called to end the process of writing
	pages to a document.

	This writes any file level trailers required. After this
	completes successfully the file is up to date and complete.
*/
FZ_FUNCTION void close_document_writer(fz_document_writer *wri);

/** Wrapper for `fz_close_output()`. */
/**
	Flush pending output and close an output stream.
*/
FZ_FUNCTION void close_output(fz_output *arg_1);

/** Wrapper for `fz_close_zip_writer()`. */
/**
	Close the zip file for writing.

	This flushes any pending data to the file. This can throw
	exceptions.
*/
FZ_FUNCTION void close_zip_writer(fz_zip_writer *zip);

/** Wrapper for `fz_closepath()`. */
/**
	Close the current subpath.

	path: The path to modify.

	Throws exceptions on failure to allocate, attempting to modify
	a packed path, and illegal path closes (i.e. closing a non open
	path).
*/
FZ_FUNCTION void closepath(fz_path *path);

/** Wrapper for `fz_colorspace_colorant()`. */
/**
	Retrieve a the name for a colorant.

	Returns a pointer with the same lifespan as the colorspace.
*/
FZ_FUNCTION const char *colorspace_colorant(fz_colorspace *cs, int n);

/** Wrapper for `fz_colorspace_device_n_has_cmyk()`. */
/**
	True if DeviceN color space has cyan magenta yellow or black as
	one of its colorants.
*/
FZ_FUNCTION int colorspace_device_n_has_cmyk(fz_colorspace *cs);

/** Wrapper for `fz_colorspace_device_n_has_only_cmyk()`. */
/**
	True if DeviceN color space has only colorants from the CMYK set.
*/
FZ_FUNCTION int colorspace_device_n_has_only_cmyk(fz_colorspace *cs);

/** Wrapper for `fz_colorspace_is_cmyk()`. */
FZ_FUNCTION int colorspace_is_cmyk(fz_colorspace *cs);

/** Wrapper for `fz_colorspace_is_device()`. */
FZ_FUNCTION int colorspace_is_device(fz_colorspace *cs);

/** Wrapper for `fz_colorspace_is_device_cmyk()`. */
FZ_FUNCTION int colorspace_is_device_cmyk(fz_colorspace *cs);

/** Wrapper for `fz_colorspace_is_device_gray()`. */
FZ_FUNCTION int colorspace_is_device_gray(fz_colorspace *cs);

/** Wrapper for `fz_colorspace_is_device_n()`. */
FZ_FUNCTION int colorspace_is_device_n(fz_colorspace *cs);

/** Wrapper for `fz_colorspace_is_gray()`. */
/**
	Tests for particular types of colorspaces
*/
FZ_FUNCTION int colorspace_is_gray(fz_colorspace *cs);

/** Wrapper for `fz_colorspace_is_indexed()`. */
FZ_FUNCTION int colorspace_is_indexed(fz_colorspace *cs);

/** Wrapper for `fz_colorspace_is_lab()`. */
FZ_FUNCTION int colorspace_is_lab(fz_colorspace *cs);

/** Wrapper for `fz_colorspace_is_lab_icc()`. */
FZ_FUNCTION int colorspace_is_lab_icc(fz_colorspace *cs);

/** Wrapper for `fz_colorspace_is_rgb()`. */
FZ_FUNCTION int colorspace_is_rgb(fz_colorspace *cs);

/** Wrapper for `fz_colorspace_is_subtractive()`. */
/**
	True for CMYK, Separation and DeviceN colorspaces.
*/
FZ_FUNCTION int colorspace_is_subtractive(fz_colorspace *cs);

/** Wrapper for `fz_colorspace_n()`. */
/**
	Query the number of colorants in a colorspace.
*/
FZ_FUNCTION int colorspace_n(fz_colorspace *cs);

/** Wrapper for `fz_colorspace_name()`. */
/**
	Query the name of a colorspace.

	The returned string has the same lifespan as the colorspace
	does. Caller should not free it.
*/
FZ_FUNCTION const char *colorspace_name(fz_colorspace *cs);

/** Wrapper for `fz_colorspace_name_colorant()`. */
/**
	Assign a name for a given colorant in a colorspace.

	Used while initially setting up a colorspace. The string is
	copied into local storage, so need not be retained by the
	caller.
*/
FZ_FUNCTION void colorspace_name_colorant(fz_colorspace *cs, int n, const char *name);

/** Wrapper for `fz_colorspace_type()`. */
/**
	Query the type of colorspace.
*/
FZ_FUNCTION enum fz_colorspace_type colorspace_type(fz_colorspace *cs);

/** Wrapper for `fz_compress_ccitt_fax_g3()`. */
/**
	Compress bitmap data as CCITT Group 3 1D fax image.
	Creates a stream assuming the default PDF parameters,
	except the number of columns.
*/
FZ_FUNCTION fz_buffer *compress_ccitt_fax_g3(const unsigned char *data, int columns, int rows);

/** Wrapper for `fz_compress_ccitt_fax_g4()`. */
/**
	Compress bitmap data as CCITT Group 4 2D fax image.
	Creates a stream assuming the default PDF parameters, except
	K=-1 and the number of columns.
*/
FZ_FUNCTION fz_buffer *compress_ccitt_fax_g4(const unsigned char *data, int columns, int rows);

/** Wrapper for `fz_compressed_buffer_size()`. */
/**
	Return the storage size used for a buffer and its data.
	Used in implementing store handling.

	Never throws exceptions.
*/
FZ_FUNCTION size_t compressed_buffer_size(fz_compressed_buffer *buffer);

/** Wrapper for `fz_compressed_image_buffer()`. */
/**
	Retrieve the underlying compressed data for an image.

	Returns a pointer to the underlying data buffer for an image,
	or NULL if this image is not based upon a compressed data
	buffer.

	This is not a reference counted structure, so no reference is
	returned. Lifespan is limited to that of the image itself.
*/
FZ_FUNCTION fz_compressed_buffer *compressed_image_buffer(fz_image *image);

/** Wrapper for `fz_concat()`. */
/**
	Multiply two matrices.

	The order of the two matrices are important since matrix
	multiplication is not commutative.

	Returns result.
*/
FZ_FUNCTION fz_matrix concat(fz_matrix left, fz_matrix right);

/** Wrapper for `fz_concat_push_drop()`. */
/**
	Add a chained stream to the end of the concatenate filter.

	Ownership of chain is passed in.
*/
FZ_FUNCTION void concat_push_drop(fz_stream *concat, fz_stream *chain);

/** Wrapper for `fz_contains_rect()`. */
/**
	Test rectangle inclusion.

	Return true if a entirely contains b.
*/
FZ_FUNCTION int contains_rect(fz_rect a, fz_rect b);

/** Wrapper for `fz_convert_color()`.

This function has out-params. Python/C# wrappers look like:
	`convert_color(fz_colorspace *ss, const float *sv, fz_colorspace *ds, fz_colorspace *is, fz_color_params params)` => float dv
*/
/**
	Convert color values sv from colorspace ss into colorvalues dv
	for colorspace ds, via an optional intervening space is,
	respecting the given color_params.
*/
FZ_FUNCTION void convert_color(fz_colorspace *ss, const float *sv, fz_colorspace *ds, 
		#ifdef SWIG
			float *OUTPUT
		#else
			float *dv
		#endif
		, fz_colorspace *is, fz_color_params params);

/** Wrapper for `fz_convert_indexed_pixmap_to_base()`. */
/**
	Convert pixmap from indexed to base colorspace.

	This creates a new bitmap containing the converted pixmap data.
 */
FZ_FUNCTION fz_pixmap *convert_indexed_pixmap_to_base(const fz_pixmap *src);

/** Wrapper for `fz_convert_pixmap()`. */
/**
	Convert an existing pixmap to a desired
	colorspace. Other properties of the pixmap, such as resolution
	and position are copied to the converted pixmap.

	pix: The pixmap to convert.

	default_cs: If NULL pix->colorspace is used. It is possible that
	the data may need to be interpreted as one of the color spaces
	in default_cs.

	cs_des: Desired colorspace, may be NULL to denote alpha-only.

	prf: Proofing color space through which we need to convert.

	color_params: Parameters that may be used in conversion (e.g.
	ri).

	keep_alpha: If 0 any alpha component is removed, otherwise
	alpha is kept if present in the pixmap.
*/
FZ_FUNCTION fz_pixmap *convert_pixmap(const fz_pixmap *pix, fz_colorspace *cs_des, fz_colorspace *prf, fz_default_colorspaces *default_cs, fz_color_params color_params, int keep_alpha);

/** Wrapper for `fz_convert_separation_colors()`.

This function has out-params. Python/C# wrappers look like:
	`convert_separation_colors(fz_colorspace *src_cs, const float *src_color, fz_separations *dst_seps, fz_colorspace *dst_cs, fz_color_params color_params)` => float dst_color
*/
/**
	Convert a color given in terms of one colorspace,
	to a color in terms of another colorspace/separations.
*/
FZ_FUNCTION void convert_separation_colors(fz_colorspace *src_cs, const float *src_color, fz_separations *dst_seps, fz_colorspace *dst_cs, 
		#ifdef SWIG
			float *OUTPUT
		#else
			float *dst_color
		#endif
		, fz_color_params color_params);

/** Wrapper for `fz_convert_separation_pixmap_to_base()`. */
/**
	Convert pixmap from DeviceN/Separation to base colorspace.

	This creates a new bitmap containing the converted pixmap data.
*/
FZ_FUNCTION fz_pixmap *convert_separation_pixmap_to_base(const fz_pixmap *src);

/** Wrapper for `fz_copy_option()`. */
/**
	Copy an option (val) into a destination buffer (dest), of maxlen
	bytes.

	Returns the number of bytes (including terminator) that did not
	fit. If val is maxlen or greater bytes in size, it will be left
	unterminated.
*/
FZ_FUNCTION size_t copy_option(const char *val, char *dest, size_t maxlen);

/** Wrapper for `fz_copy_rectangle()`. */
/**
	Return a newly allocated UTF-8 string with the text for a given
	selection rectangle.

	crlf: If true, write "\r\n" style line endings (otherwise "\n"
	only).
*/
FZ_FUNCTION char *copy_rectangle(fz_stext_page *page, fz_rect area, int crlf);

/** Wrapper for `fz_copy_selection()`. */
/**
	Return a newly allocated UTF-8 string with the text for a given
	selection.

	crlf: If true, write "\r\n" style line endings (otherwise "\n"
	only).
*/
FZ_FUNCTION char *copy_selection(fz_stext_page *page, fz_point a, fz_point b, int crlf);

/** Wrapper for `fz_count_active_separations()`. */
/**
	Return the number of active separations.
*/
FZ_FUNCTION int count_active_separations(const fz_separations *seps);

/** Wrapper for `fz_count_archive_entries()`. */
/**
	Number of entries in archive.

	Will always return a value >= 0.

	May throw an exception if this type of archive cannot count the
	entries (such as a directory).
*/
FZ_FUNCTION int count_archive_entries(fz_archive *arch);

/** Wrapper for `fz_count_chapter_pages()`. */
/**
	Return the number of pages in a chapter.
	May return 0.
*/
FZ_FUNCTION int count_chapter_pages(fz_document *doc, int chapter);

/** Wrapper for `fz_count_chapters()`. */
/**
	Return the number of chapters in the document.
	At least 1.
*/
FZ_FUNCTION int count_chapters(fz_document *doc);

/** Wrapper for `fz_count_pages()`. */
/**
	Return the number of pages in document

	May return 0 for documents with no pages.
*/
FZ_FUNCTION int count_pages(fz_document *doc);

/** Wrapper for `fz_count_separations()`. */
FZ_FUNCTION int count_separations(const fz_separations *sep);

/** Wrapper for `fz_create_link()`. */
/**
	Create a new link on a page.
*/
FZ_FUNCTION fz_link *create_link(fz_page *page, fz_rect bbox, const char *uri);

/** Wrapper for `fz_currentpoint()`. */
/**
	Return the current point that a path has
	reached or (0,0) if empty.

	path: path to return the current point of.
*/
FZ_FUNCTION fz_point currentpoint(fz_path *path);

/** Wrapper for `fz_curveto()`. */
/**
	Append a 'curveto' command to an open path. (For a
	cubic bezier).

	path: The path to modify.

	x0, y0: The coordinates of the first control point for the
	curve.

	x1, y1: The coordinates of the second control point for the
	curve.

	x2, y2: The end coordinates for the curve.

	Throws exceptions on failure to allocate, or attempting to
	modify a packed path.
*/
FZ_FUNCTION void curveto(fz_path *path, float x0, float y0, float x1, float y1, float x2, float y2);

/** Wrapper for `fz_curvetov()`. */
/**
	Append a 'curvetov' command to an open path. (For a
	cubic bezier with the first control coordinate equal to
	the start point).

	path: The path to modify.

	x1, y1: The coordinates of the second control point for the
	curve.

	x2, y2: The end coordinates for the curve.

	Throws exceptions on failure to allocate, or attempting to
	modify a packed path.
*/
FZ_FUNCTION void curvetov(fz_path *path, float x1, float y1, float x2, float y2);

/** Wrapper for `fz_curvetoy()`. */
/**
	Append a 'curvetoy' command to an open path. (For a
	cubic bezier with the second control coordinate equal to
	the end point).

	path: The path to modify.

	x0, y0: The coordinates of the first control point for the
	curve.

	x2, y2: The end coordinates for the curve (and the second
	control coordinate).

	Throws exceptions on failure to allocate, or attempting to
	modify a packed path.
*/
FZ_FUNCTION void curvetoy(fz_path *path, float x0, float y0, float x2, float y2);

/** Wrapper for `fz_debug_store()`. */
/**
	Output debugging information for the current state of the store
	to the given output channel.
*/
FZ_FUNCTION void debug_store(fz_output *out);

/** Wrapper for `fz_debug_xml()`. */
/**
	Pretty-print an XML tree to stdout.
*/
FZ_FUNCTION void debug_xml(fz_xml *item, int level);

/** Wrapper for `fz_decode_tile()`. */
FZ_FUNCTION void decode_tile(fz_pixmap *pix, const float *decode);

/** Wrapper for `fz_decomp_image_from_stream()`.

This function has out-params. Python/C# wrappers look like:
	`decomp_image_from_stream(fz_stream *stm, fz_compressed_image *image, fz_irect *subarea, int indexed, int l2factor)` => `(fz_pixmap *, int l2extra)`
*/
/**
	Decode a subarea of a compressed image. l2factor is the amount
	of subsampling inbuilt to the stream (i.e. performed by the
	decoder). If non NULL, l2extra is the extra amount of
	subsampling that should be performed by this routine. This will
	be updated on exit to the amount of subsampling that is still
	required to be done.
*/
FZ_FUNCTION fz_pixmap *decomp_image_from_stream(fz_stream *stm, fz_compressed_image *image, fz_irect *subarea, int indexed, int l2factor, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *l2extra
		#endif
		);

/** Wrapper for `fz_decouple_type3_font()`. */
FZ_FUNCTION void decouple_type3_font(fz_font *font, void *t3doc);

/** Wrapper for `fz_default_cmyk()`. */
FZ_FUNCTION fz_colorspace *default_cmyk(const fz_default_colorspaces *default_cs);

/** Wrapper for `fz_default_error_callback()`. */
/**
	FIXME: Better not to expose fz_default_error_callback, and
	fz_default_warning callback and to allow 'NULL' to be used
	int fz_set_xxxx_callback to mean "defaults".

	FIXME: Do we need/want functions like
	fz_error_callback(ctx, message) to allow callers to inject
	stuff into the error/warning streams?
*/
/**
	The default error callback. Declared publicly just so that the
	error callback can be set back to this after it has been
	overridden.
*/
FZ_FUNCTION void default_error_callback(void *user, const char *message);

/** Wrapper for `fz_default_gray()`. */
/**
	Retrieve default colorspaces (typically page local).

	If default_cs is non NULL, the default is retrieved from there,
	otherwise the global default is retrieved.

	These return borrowed references that should not be dropped,
	unless they are kept first.
*/
FZ_FUNCTION fz_colorspace *default_gray(const fz_default_colorspaces *default_cs);

/** Wrapper for `fz_default_halftone()`. */
/**
	Create a 'default' halftone structure
	for the given number of components.

	num_comps: The number of components to use.

	Returns a simple default halftone. The default halftone uses
	the same halftone tile for each plane, which may not be ideal
	for all purposes.
*/
FZ_FUNCTION fz_halftone *default_halftone(int num_comps);

/** Wrapper for `fz_default_output_intent()`. */
FZ_FUNCTION fz_colorspace *default_output_intent(const fz_default_colorspaces *default_cs);

/** Wrapper for `fz_default_rgb()`. */
FZ_FUNCTION fz_colorspace *default_rgb(const fz_default_colorspaces *default_cs);

/** Wrapper for `fz_default_warning_callback()`. */
/**
	The default warning callback. Declared publicly just so that
	the warning callback can be set back to this after it has been
	overridden.
*/
FZ_FUNCTION void default_warning_callback(void *user, const char *message);

/** Wrapper for `fz_defer_reap_end()`. */
/**
	Decrement the defer reap count.

	If the defer reap count returns to 0, and the store
	has reapable objects in, a reap pass will begin.

	Call this at the end of a process during which you
	potentially might drop many reapable objects.

	It is vital that every fz_defer_reap_start is matched
	by a fz_defer_reap_end call.
*/
FZ_FUNCTION void defer_reap_end();

/** Wrapper for `fz_defer_reap_start()`. */
/**
	Increment the defer reap count.

	No reap operations will take place (except for those
	triggered by an immediate failed malloc) until the
	defer reap count returns to 0.

	Call this at the start of a process during which you
	potentially might drop many reapable objects.

	It is vital that every fz_defer_reap_start is matched
	by a fz_defer_reap_end call.
*/
FZ_FUNCTION void defer_reap_start();

/** Wrapper for `fz_deflate()`.

This function has out-params. Python/C# wrappers look like:
	`deflate(unsigned char *dest, const unsigned char *source, size_t source_length, fz_deflate_level level)` => size_t compressed_length
*/
/**
	Compress source_length bytes of data starting
	at source, into a buffer of length *destLen, starting at dest.
	*compressed_length will be updated on exit to contain the size
	actually used.
 */
FZ_FUNCTION void deflate(unsigned char *dest, 
		#ifdef SWIG
			size_t *OUTPUT
		#else
			size_t *compressed_length
		#endif
		, const unsigned char *source, size_t source_length, fz_deflate_level level);

/** Wrapper for `fz_deflate_bound()`. */
/**
	Returns the upper bound on the
	size of flated data of length size.
 */
FZ_FUNCTION size_t deflate_bound(size_t size);

/** Wrapper for `fz_detach_xml()`. */
/**
	Detach a node from the tree, unlinking it from its parent,
	and setting the document root to the node.
*/
FZ_FUNCTION void detach_xml(fz_xml_doc *xml, fz_xml *node);

/** Wrapper for `fz_device_bgr()`. */
FZ_FUNCTION fz_colorspace *device_bgr();

/** Wrapper for `fz_device_cmyk()`. */
FZ_FUNCTION fz_colorspace *device_cmyk();

/** Wrapper for `fz_device_current_scissor()`. */
/**
	Find current scissor region as tracked by the device.
*/
FZ_FUNCTION fz_rect device_current_scissor(fz_device *dev);

/** Wrapper for `fz_device_gray()`. */
/**
	Retrieve global default colorspaces.

	These return borrowed references that should not be dropped,
	unless they are kept first.
*/
FZ_FUNCTION fz_colorspace *device_gray();

/** Wrapper for `fz_device_lab()`. */
FZ_FUNCTION fz_colorspace *device_lab();

/** Wrapper for `fz_device_rgb()`. */
FZ_FUNCTION fz_colorspace *device_rgb();

/** Wrapper for `fz_dirname()`. */
/**
	extract the directory component from a path.
*/
FZ_FUNCTION void dirname(char *dir, const char *path, size_t dirsize);

/** Wrapper for `fz_disable_device_hints()`. */
/**
	Disable (clear) hint bits within the hint bitfield for a device.
*/
FZ_FUNCTION void disable_device_hints(fz_device *dev, int hints);

/** Wrapper for `fz_disable_icc()`. */
/**
	Disable icc profile based operation.
*/
FZ_FUNCTION void disable_icc();

/** Wrapper for `fz_display_list_is_empty()`. */
/**
	Check for a display list being empty

	list: The list to check.

	Returns true if empty, false otherwise.
*/
FZ_FUNCTION int display_list_is_empty(const fz_display_list *list);

/** Wrapper for `fz_div255()`. */
/**
	Undo alpha premultiplication.
*/
FZ_FUNCTION int div255(int c, int a);

/** Wrapper for `fz_do_always()`. */
FZ_FUNCTION int do_always();

/** Wrapper for `fz_do_catch()`. */
FZ_FUNCTION int do_catch();

/** Wrapper for `fz_do_try()`. */
FZ_FUNCTION int do_try();

/** Wrapper for `fz_document_output_intent()`. */
/**
	Find the output intent colorspace if the document has defined
	one.

	Returns a borrowed reference that should not be dropped, unless
	it is kept first.
*/
FZ_FUNCTION fz_colorspace *document_output_intent(fz_document *doc);

/** Wrapper for `fz_document_supports_accelerator()`. */
/**
	Query if the document supports the saving of accelerator data.
*/
FZ_FUNCTION int document_supports_accelerator(fz_document *doc);

/** Wrapper for `fz_drop_archive()`. */
/**
	Drop the reference to an archive.

	Closes and releases any memory or filehandles associated
	with the archive.
*/
FZ_FUNCTION void drop_archive(fz_archive *arch);

/** Wrapper for `fz_drop_band_writer()`. */
/**
	Drop the reference to the band writer, causing it to be
	destroyed.

	Never throws an exception.
*/
FZ_FUNCTION void drop_band_writer(fz_band_writer *writer);

/** Wrapper for `fz_drop_bitmap()`. */
/**
	Drop a reference to the bitmap. When the reference count reaches
	zero, the bitmap will be destroyed.

	Never throws exceptions.
*/
FZ_FUNCTION void drop_bitmap(fz_bitmap *bit);

/** Wrapper for `fz_drop_buffer()`. */
/**
	Drop a reference to the buffer. When the reference count reaches
	zero, the buffer is destroyed.

	Never throws exceptions.
*/
FZ_FUNCTION void drop_buffer(fz_buffer *buf);

/** Wrapper for `fz_drop_colorspace()`. */
/**
	Drops a reference to the colorspace.

	When the reference count reaches zero, the colorspace is
	destroyed.
*/
FZ_FUNCTION void drop_colorspace(fz_colorspace *colorspace);

/** Wrapper for `fz_drop_colorspace_imp()`. */
FZ_FUNCTION void drop_colorspace_imp(fz_storable *cs_);

/** Wrapper for `fz_drop_compressed_buffer()`. */
/**
	Drop a reference to a compressed buffer. Destroys the buffer
	and frees any storage/other references held by it.

	Never throws exceptions.
*/
FZ_FUNCTION void drop_compressed_buffer(fz_compressed_buffer *buf);

/** Wrapper for `fz_drop_context()`. */
/**
	Free a context and its global state.

	The context and all of its global state is freed, and any
	buffered warnings are flushed (see fz_flush_warnings). If NULL
	is passed in nothing will happen.

	Must not be called for a context that is being used in an active
	fz_try(), fz_always() or fz_catch() block.
*/
FZ_FUNCTION void drop_context();

/** Wrapper for `fz_drop_default_colorspaces()`. */
/**
	Drop a reference to the default colorspaces structure. When the
	reference count reaches 0, the references it holds internally
	to the underlying colorspaces will be dropped, and the structure
	will be destroyed.

	Never throws exceptions.
*/
FZ_FUNCTION void drop_default_colorspaces(fz_default_colorspaces *default_cs);

/** Wrapper for `fz_drop_device()`. */
/**
	Reduce the reference count on a device. When the reference count
	reaches zero, the device and its resources will be freed.
	Don't forget to call fz_close_device before dropping the device,
	or you may get incomplete output!

	Never throws exceptions.
*/
FZ_FUNCTION void drop_device(fz_device *dev);

/** Wrapper for `fz_drop_display_list()`. */
/**
	Decrement the reference count for a display list. When the
	reference count reaches zero, all the references in the display
	list itself are dropped, and the display list is freed.

	Never throws exceptions.
*/
FZ_FUNCTION void drop_display_list(fz_display_list *list);

/** Wrapper for `fz_drop_document()`. */
/**
	Decrement the document reference count. When the reference
	count reaches 0, the document and all it's references are
	freed.

	Never throws exceptions.
*/
FZ_FUNCTION void drop_document(fz_document *doc);

/** Wrapper for `fz_drop_document_writer()`. */
/**
	Called to discard a fz_document_writer.
	This may be called at any time during the process to release all
	the resources owned by the writer.

	Calling drop without having previously called close may leave
	the file in an inconsistent state.
*/
FZ_FUNCTION void drop_document_writer(fz_document_writer *wri);

/** Wrapper for `fz_drop_font()`. */
/**
	Drop a reference to a fz_font, destroying the
	font when the last reference is dropped.

	font: The font to drop a reference to.
*/
FZ_FUNCTION void drop_font(fz_font *font);

/** Wrapper for `fz_drop_glyph()`. */
/**
	Drop a reference and free a glyph.

	Decrement the reference count for the glyph. When no
	references remain the glyph will be freed.
*/
FZ_FUNCTION void drop_glyph(fz_glyph *pix);

/** Wrapper for `fz_drop_halftone()`. */
/**
	Drop a reference to the halftone. When the reference count
	reaches zero, the halftone is destroyed.

	Never throws exceptions.
*/
FZ_FUNCTION void drop_halftone(fz_halftone *ht);

/** Wrapper for `fz_drop_hash_table()`. */
/**
	Destroy the hash table.

	Values are dropped using the drop function.
*/
FZ_FUNCTION void drop_hash_table(fz_hash_table *table);

/** Wrapper for `fz_drop_image()`. */
/**
	Decrement the (normal) reference count for an image. When the
	total (normal + key) reference count reaches zero, the image and
	its resources are freed.

	Never throws exceptions.
*/
FZ_FUNCTION void drop_image(fz_image *image);

/** Wrapper for `fz_drop_image_base()`. */
/**
	Internal destructor for the base image class members.

	Exposed to allow derived image classes to be written.
*/
FZ_FUNCTION void drop_image_base(fz_image *image);

/** Wrapper for `fz_drop_image_imp()`. */
/**
	Internal destructor exposed for fz_store integration.
*/
FZ_FUNCTION void drop_image_imp(fz_storable *image);

/** Wrapper for `fz_drop_image_store_key()`. */
/**
	Decrement the store key reference count for an image. When the
	total (normal + key) reference count reaches zero, the image and
	its resources are freed.

	Never throws exceptions.
*/
FZ_FUNCTION void drop_image_store_key(fz_image *image);

/** Wrapper for `fz_drop_imp()`.

This function has out-params. Python/C# wrappers look like:
	`drop_imp(void *p)` => `(int, int refs)`
*/
FZ_FUNCTION int drop_imp(void *p, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *refs
		#endif
		);

/** Wrapper for `fz_drop_imp16()`.

This function has out-params. Python/C# wrappers look like:
	`drop_imp16(void *p)` => `(int, int16_t refs)`
*/
FZ_FUNCTION int drop_imp16(void *p, 
		#ifdef SWIG
			int16_t *OUTPUT
		#else
			int16_t *refs
		#endif
		);

/** Wrapper for `fz_drop_imp8()`. */
FZ_FUNCTION int drop_imp8(void *p, int8_t *refs);

/** Wrapper for `fz_drop_jbig2_globals()`. */
/**
	Decrement the reference count for a jbig2 globals record.
	When the reference count hits zero, the record is freed.

	Never throws an exception.
*/
FZ_FUNCTION void drop_jbig2_globals(fz_jbig2_globals *globals);

/** Wrapper for `fz_drop_jbig2_globals_imp()`. */
/**
	Special jbig2 globals drop function for use in implementing
	store support.
*/
FZ_FUNCTION void drop_jbig2_globals_imp(fz_storable *globals);

/** Wrapper for `fz_drop_key_storable()`. */
/**
	Decrement the (normal) reference count for a storable object.
	When the total reference count hits zero, the drop function for
	that object is called to free the object.

	Never throws exceptions.
*/
FZ_FUNCTION void drop_key_storable(const fz_key_storable *arg_1);

/** Wrapper for `fz_drop_key_storable_key()`. */
/**
	Decrement the (key) reference count for a storable object.
	When the total reference count hits zero, the drop function for
	that object is called to free the object.

	Never throws exceptions.
*/
FZ_FUNCTION void drop_key_storable_key(const fz_key_storable *arg_1);

/** Wrapper for `fz_drop_layout()`. */
/**
	Drop layout block. Free the pool, and linked blocks.

	Never throws exceptions.
*/
FZ_FUNCTION void drop_layout(fz_layout_block *block);

/** Wrapper for `fz_drop_link()`. */
/**
	Decrement the reference count for a link. When the reference
	count reaches zero, the link is destroyed.

	When a link is freed, the reference for any linked link (next)
	is dropped too, thus an entire linked list of fz_link's can be
	freed by just dropping the head.
*/
FZ_FUNCTION void drop_link(fz_link *link);

/** Wrapper for `fz_drop_outline()`. */
/**
	Decrements the reference count. When the reference point
	reaches zero, the outline is freed.

	When freed, it will drop linked	outline entries (next and down)
	too, thus a whole outline structure can be dropped by dropping
	the top entry.

	Never throws exceptions.
*/
FZ_FUNCTION void drop_outline(fz_outline *outline);

/** Wrapper for `fz_drop_outline_iterator()`. */
/**
	Drop the current iterator.
*/
FZ_FUNCTION void drop_outline_iterator(fz_outline_iterator *iter);

/** Wrapper for `fz_drop_output()`. */
/**
	Free an output stream. Don't forget to close it first!
*/
FZ_FUNCTION void drop_output(fz_output *arg_1);

/** Wrapper for `fz_drop_page()`. */
/**
	Decrements the reference count for the page. When the reference
	count hits 0, the page and its references are freed.

	Never throws exceptions.
*/
FZ_FUNCTION void drop_page(fz_page *page);

/** Wrapper for `fz_drop_path()`. */
/**
	Decrement the reference count. When the reference count hits
	zero, free the path.

	All paths can be dropped, regardless of their packing type.
	Packed paths do not own the blocks into which they are packed
	so dropping them does not free those blocks.

	Never throws exceptions.
*/
FZ_FUNCTION void drop_path(const fz_path *path);

/** Wrapper for `fz_drop_pixmap()`. */
/**
	Decrement the reference count for the pixmap. When the
	reference count hits 0, the pixmap is freed.

	Never throws exceptions.
*/
FZ_FUNCTION void drop_pixmap(fz_pixmap *pix);

/** Wrapper for `fz_drop_pool()`. */
/**
	Drop a pool, freeing and invalidating all storage returned from
	the pool.
*/
FZ_FUNCTION void drop_pool(fz_pool *pool);

/** Wrapper for `fz_drop_separations()`. */
/**
	Decrement the reference count for a separations structure.
	When the reference count hits zero, the separations structure
	is freed.

	Never throws exceptions.
*/
FZ_FUNCTION void drop_separations(fz_separations *sep);

/** Wrapper for `fz_drop_shade()`. */
/**
	Decrement the reference count for the shade structure. When
	the reference count hits zero, the structure is freed.

	Never throws exceptions.
*/
FZ_FUNCTION void drop_shade(fz_shade *shade);

/** Wrapper for `fz_drop_shade_color_cache()`. */
FZ_FUNCTION void drop_shade_color_cache(fz_shade_color_cache *cache);

/** Wrapper for `fz_drop_shade_imp()`. */
/**
	Internal function to destroy a
	shade. Only exposed for use with the fz_store.

	shade: The reference to destroy.
*/
FZ_FUNCTION void drop_shade_imp(fz_storable *shade);

/** Wrapper for `fz_drop_stext_page()`. */
FZ_FUNCTION void drop_stext_page(fz_stext_page *page);

/** Wrapper for `fz_drop_storable()`. */
/**
	Decrement the reference count for a storable object. When the
	reference count hits zero, the drop function for that object
	is called to free the object.

	Never throws exceptions.
*/
FZ_FUNCTION void drop_storable(const fz_storable *arg_1);

/** Wrapper for `fz_drop_store_context()`. */
/**
	Decrement the reference count for the store context. When the
	reference count hits zero, the store context is freed.

	Never throws exceptions.
*/
FZ_FUNCTION void drop_store_context();

/** Wrapper for `fz_drop_stream()`. */
/**
	Decrements the reference count for a stream.

	When the reference count for the stream hits zero, frees the
	storage used for the fz_stream itself, and (usually)
	releases the underlying resources that the stream is based upon
	(depends on the method used to open the stream initially).
*/
FZ_FUNCTION void drop_stream(fz_stream *stm);

/** Wrapper for `fz_drop_stroke_state()`. */
/**
	Drop a reference to a stroke state structure, destroying the
	structure if it is the last reference.
*/
FZ_FUNCTION void drop_stroke_state(const fz_stroke_state *stroke);

/** Wrapper for `fz_drop_text()`. */
/**
	Decrement the reference count for the text object. When the
	reference count hits zero, the text object is freed.

	Never throws exceptions.
*/
FZ_FUNCTION void drop_text(const fz_text *text);

/** Wrapper for `fz_drop_tree()`. */
/**
	Drop the tree.

	The storage used by the tree is freed, and each value has
	dropfunc called on it.
*/
FZ_FUNCTION void drop_tree(fz_tree *node, void (*dropfunc)(fz_context *, void *));

/** Wrapper for `fz_drop_xml()`. */
/**
	Free the XML node and all its children and siblings.
*/
FZ_FUNCTION void drop_xml(fz_xml_doc *xml);

/** Wrapper for `fz_drop_zip_writer()`. */
/**
	Drop the reference to the zipfile.

	In common with other 'drop' methods, this will never throw an
	exception.
*/
FZ_FUNCTION void drop_zip_writer(fz_zip_writer *zip);

/** Wrapper for `fz_dump_glyph_cache_stats()`. */
/**
	Dump debug statistics for the glyph cache.
*/
FZ_FUNCTION void dump_glyph_cache_stats(fz_output *out);

/** Wrapper for `fz_duplicate_glyph_names_from_unicode()`. */
FZ_FUNCTION const char **duplicate_glyph_names_from_unicode(int unicode);

/** Wrapper for `fz_empty_store()`. */
/**
	Evict every item from the store.
*/
FZ_FUNCTION void empty_store();

/** Wrapper for `fz_enable_device_hints()`. */
/**
	Enable (set) hint bits within the hint bitfield for a device.
*/
FZ_FUNCTION void enable_device_hints(fz_device *dev, int hints);

/** Wrapper for `fz_enable_icc()`. */
/**
	Enable icc profile based operation.
*/
FZ_FUNCTION void enable_icc();

/** Wrapper for `fz_encode_character()`. */
/**
	Find the glyph id for a given unicode
	character within a font.

	font: The font to look for the unicode character in.

	unicode: The unicode character to encode.

	Returns the glyph id for the given unicode value, or 0 if
	unknown.
*/
FZ_FUNCTION int encode_character(fz_font *font, int unicode);

/** Wrapper for `fz_encode_character_by_glyph_name()`. */
/**
	Encode character.

	Either by direct lookup of glyphname within a font, or, failing
	that, by mapping glyphname to unicode and thence to the glyph
	index within the given font.

	Returns zero for type3 fonts.
*/
FZ_FUNCTION int encode_character_by_glyph_name(fz_font *font, const char *glyphname);

/** Wrapper for `fz_encode_character_sc()`. */
/**
	Encode character, preferring small-caps variant if available.

	font: The font to look for the unicode character in.

	unicode: The unicode character to encode.

	Returns the glyph id for the given unicode value, or 0 if
	unknown.
*/
FZ_FUNCTION int encode_character_sc(fz_font *font, int unicode);

/** Wrapper for `fz_encode_character_with_fallback()`.

This function has out-params. Python/C# wrappers look like:
	`encode_character_with_fallback(fz_font *font, int unicode, int script, int language, fz_font **out_font)` => `(int)`
*/
/**
	Find the glyph id for
	a given unicode character within a font, falling back to
	an alternative if not found.

	font: The font to look for the unicode character in.

	unicode: The unicode character to encode.

	script: The script in use.

	language: The language in use.

	out_font: The font handle in which the given glyph represents
	the requested unicode character. The caller does not own the
	reference it is passed, so should call fz_keep_font if it is
	not simply to be used immediately.

	Returns the glyph id for the given unicode value in the supplied
	font (and sets *out_font to font) if it is present. Otherwise
	an alternative fallback font (based on script/language) is
	searched for. If the glyph is found therein, *out_font is set
	to this reference, and the glyph reference is returned. If it
	cannot be found anywhere, the function returns 0.
*/
FZ_FUNCTION int encode_character_with_fallback(fz_font *font, int unicode, int script, int language, 
		#ifdef SWIG
			fz_font **OUTPUT
		#else
			fz_font **out_font
		#endif
		);

/** Wrapper for `fz_end_group()`. */
FZ_FUNCTION void end_group(fz_device *dev);

/** Wrapper for `fz_end_layer()`. */
FZ_FUNCTION void end_layer(fz_device *dev);

/** Wrapper for `fz_end_mask()`. */
FZ_FUNCTION void end_mask(fz_device *dev);

/** Wrapper for `fz_end_page()`. */
/**
	Called to end the process of writing a page to a
	document.
*/
FZ_FUNCTION void end_page(fz_document_writer *wri);

/** Wrapper for `fz_end_throw_on_repair()`. */
FZ_FUNCTION void end_throw_on_repair();

/** Wrapper for `fz_end_tile()`. */
FZ_FUNCTION void end_tile(fz_device *dev);

/** Wrapper for `fz_error_callback()`.

This function has out-params. Python/C# wrappers look like:
	`error_callback()` => `(fz_error_cb *, void *user)`
*/
/**
	Retrieve the currently set error callback, or NULL if none
	has been set. Optionally, if user is non-NULL, the user pointer
	given when the warning callback was set is also passed back to
	the caller.
*/
FZ_FUNCTION fz_error_cb *error_callback(
		#ifdef SWIG
			void **OUTPUT
		#else
			void **user
		#endif
		);

/** Wrapper for `fz_expand_irect()`. */
FZ_FUNCTION fz_irect expand_irect(fz_irect a, int expand);

/** Wrapper for `fz_expand_rect()`. */
/**
	Expand a bbox by a given amount in all directions.
*/
FZ_FUNCTION fz_rect expand_rect(fz_rect b, float expand);

/** Wrapper for `fz_file_exists()`. */
/**
	Return true if the named file exists and is readable.
*/
FZ_FUNCTION int file_exists(const char *path);

/** Wrapper for `fz_fill_image()`. */
FZ_FUNCTION void fill_image(fz_device *dev, fz_image *image, fz_matrix ctm, float alpha, fz_color_params color_params);

/** Wrapper for `fz_fill_image_mask()`. */
FZ_FUNCTION void fill_image_mask(fz_device *dev, fz_image *image, fz_matrix ctm, fz_colorspace *colorspace, const float *color, float alpha, fz_color_params color_params);

/** Wrapper for `fz_fill_path()`. */
/**
	Device calls; graphics primitives and containers.
*/
FZ_FUNCTION void fill_path(fz_device *dev, const fz_path *path, int even_odd, fz_matrix ctm, fz_colorspace *colorspace, const float *color, float alpha, fz_color_params color_params);

/** Wrapper for `fz_fill_pixmap_with_color()`.

This function has out-params. Python/C# wrappers look like:
	`fill_pixmap_with_color(fz_pixmap *pix, fz_colorspace *colorspace, fz_color_params color_params)` => float color
*/
/**
	Fill pixmap with solid color.
*/
FZ_FUNCTION void fill_pixmap_with_color(fz_pixmap *pix, fz_colorspace *colorspace, 
		#ifdef SWIG
			float *OUTPUT
		#else
			float *color
		#endif
		, fz_color_params color_params);

/** Wrapper for `fz_fill_shade()`. */
FZ_FUNCTION void fill_shade(fz_device *dev, fz_shade *shade, fz_matrix ctm, float alpha, fz_color_params color_params);

/** Wrapper for `fz_fill_text()`. */
FZ_FUNCTION void fill_text(fz_device *dev, const fz_text *text, fz_matrix ctm, fz_colorspace *colorspace, const float *color, float alpha, fz_color_params color_params);

/** Wrapper for `fz_filter_store()`. */
/**
	Filter every element in the store with a matching type with the
	given function.

	If the function returns 1 for an element, drop the element.
*/
FZ_FUNCTION void filter_store(fz_store_filter_fn *fn, void *arg, const fz_store_type *type);

/** Wrapper for `fz_find_item()`. */
/**
	Find an item within the store.

	drop: The function used to free the value (to ensure we get a
	value of the correct type).

	key: The key used to index the item.

	type: Functions used to manipulate the key.

	Returns NULL for not found, otherwise returns a pointer to the
	value indexed by key to which a reference has been taken.
*/
FZ_FUNCTION void *find_item(fz_store_drop_fn *drop, void *key, const fz_store_type *type);

/** Wrapper for `fz_flush_output()`. */
/**
	Flush unwritten data.
*/
FZ_FUNCTION void flush_output(fz_output *out);

/** Wrapper for `fz_flush_warnings()`. */
/**
	Flush any repeated warnings.

	Repeated warnings are buffered, counted and eventually printed
	along with the number of repetitions. Call fz_flush_warnings
	to force printing of the latest buffered warning and the
	number of repetitions, for example to make sure that all
	warnings are printed before exiting an application.
*/
FZ_FUNCTION void flush_warnings();

/** Wrapper for `fz_font_ascender()`. */
/**
	Retrieve font ascender in ems.
*/
FZ_FUNCTION float font_ascender(fz_font *font);

/** Wrapper for `fz_font_bbox()`. */
/**
	Retrieve the font bbox.

	font: The font to query.

	Returns the font bbox by value; it is valid only if
	fz_font_flags(font)->invalid_bbox is zero.
*/
FZ_FUNCTION fz_rect font_bbox(fz_font *font);

/** Wrapper for `fz_font_descender()`. */
/**
	Retrieve font descender in ems.
*/
FZ_FUNCTION float font_descender(fz_font *font);

/** Wrapper for `fz_font_digest()`. */
/**
	Retrieve the MD5 digest for the font's data.
*/
FZ_FUNCTION void font_digest(fz_font *font, unsigned char digest[16]);

/** Wrapper for `fz_font_flags()`. */
/**
	Retrieve a pointer to the font flags
	for a given font. These can then be updated as required.

	font: The font to query

	Returns a pointer to the flags structure (or NULL, if
	the font is NULL).
*/
FZ_FUNCTION fz_font_flags_t *font_flags(fz_font *font);

/** Wrapper for `fz_font_ft_face()`. */
/**
	Retrieve the FT_Face handle
	for the font.

	font: The font to query

	Returns the FT_Face handle for the font, or NULL
	if not a freetype handled font. (Cast to void *
	to avoid nasty header exposure).
*/
FZ_FUNCTION void *font_ft_face(fz_font *font);

/** Wrapper for `fz_font_is_bold()`. */
/**
	Query whether the font flags say that this font is bold.
*/
FZ_FUNCTION int font_is_bold(fz_font *font);

/** Wrapper for `fz_font_is_italic()`. */
/**
	Query whether the font flags say that this font is italic.
*/
FZ_FUNCTION int font_is_italic(fz_font *font);

/** Wrapper for `fz_font_is_monospaced()`. */
/**
	Query whether the font flags say that this font is monospaced.
*/
FZ_FUNCTION int font_is_monospaced(fz_font *font);

/** Wrapper for `fz_font_is_serif()`. */
/**
	Query whether the font flags say that this font is serif.
*/
FZ_FUNCTION int font_is_serif(fz_font *font);

/** Wrapper for `fz_font_name()`. */
/**
	Retrieve a pointer to the name of the font.

	font: The font to query.

	Returns a pointer to an internal copy of the font name.
	Will never be NULL, but may be the empty string.
*/
FZ_FUNCTION const char *font_name(fz_font *font);

/** Wrapper for `fz_font_shaper_data()`. */
/**
	Retrieve a pointer to the shaper data
	structure for the given font.

	font: The font to query.

	Returns a pointer to the shaper data structure (or NULL if
	font is NULL).
*/
FZ_FUNCTION fz_shaper_data_t *font_shaper_data(fz_font *font);

/** Wrapper for `fz_font_t3_procs()`. */
/**
	Retrieve the Type3 procs
	for a font.

	font: The font to query

	Returns the t3_procs pointer. Will be NULL for a
	non type-3 font.
*/
FZ_FUNCTION fz_buffer **font_t3_procs(fz_font *font);

/** Wrapper for `fz_format_link_uri()`. */
/**
	Format an internal link to a page number, location, and possible viewing parameters,
	suitable for use with fz_create_link.

	Returns a newly allocated string that the caller must free.
*/
FZ_FUNCTION char *format_link_uri(fz_document *doc, fz_link_dest dest);

/** Wrapper for `fz_format_output_path()`. */
/**
	create output file name using a template.

	If the path contains %[0-9]*d, the first such pattern will be
	replaced with the page number. If the template does not contain
	such a pattern, the page number will be inserted before the
	filename extension. If the template does not have a filename
	extension, the page number will be added to the end.
*/
FZ_FUNCTION void format_output_path(char *path, size_t size, const char *fmt, int page);

/** Wrapper for `fz_format_string()`. */
/**
	Our customised 'printf'-like string formatter.
	Takes %c, %d, %s, %u, %x, as usual.
	Modifiers are not supported except for zero-padding ints (e.g.
	%02d, %03u, %04x, etc).
	%g output in "as short as possible hopefully lossless
	non-exponent" form, see fz_ftoa for specifics.
	%f and %e output as usual.
	%C outputs a utf8 encoded int.
	%M outputs a fz_matrix*.
	%R outputs a fz_rect*.
	%P outputs a fz_point*.
	%n outputs a PDF name (with appropriate escaping).
	%q and %( output escaped strings in C/PDF syntax.
	%l{d,u,x} indicates that the values are int64_t.
	%z{d,u,x} indicates that the value is a size_t.

	user: An opaque pointer that is passed to the emit function.

	emit: A function pointer called to emit output bytes as the
	string is being formatted.
*/
FZ_FUNCTION void format_string(void *user, void (*emit)(fz_context *, void *, int ), const char *fmt, va_list args);

/** Wrapper for `fz_free()`. */
/**
	Free a previously allocated block of memory.

	fz_free(ctx, NULL) does nothing.

	Never throws exceptions.
*/
FZ_FUNCTION void free(void *p);

/** Wrapper for `fz_gamma_pixmap()`. */
/**
	Apply gamma correction to a pixmap. All components
	of all pixels are modified (except alpha, which is unchanged).

	gamma: The gamma value to apply; 1.0 for no change.
*/
FZ_FUNCTION void gamma_pixmap(fz_pixmap *pix, float gamma);

/** Wrapper for `fz_generate_transition()`. */
/**
	Generate a frame of a transition.

	tpix: Target pixmap
	opix: Old pixmap
	npix: New pixmap
	time: Position within the transition (0 to 256)
	trans: Transition details

	Returns 1 if successfully generated a frame.

	Note: Pixmaps must include alpha.
*/
FZ_FUNCTION int generate_transition(fz_pixmap *tpix, fz_pixmap *opix, fz_pixmap *npix, int time, fz_transition *trans);

/** Wrapper for `fz_get_glyph_name()`. */
/**
	Find the name of a glyph

	font: The font to look for the glyph in.

	glyph: The glyph id to look for.

	buf: Pointer to a buffer for the name to be inserted into.

	size: The size of the buffer.

	If a font contains a name table, then the name of the glyph
	will be returned in the supplied buffer. Otherwise a name
	is synthesised. The name will be truncated to fit in
	the buffer.
*/
FZ_FUNCTION void get_glyph_name(fz_font *font, int glyph, char *buf, int size);

/** Wrapper for `fz_get_pixmap_from_image()`.

This function has out-params. Python/C# wrappers look like:
	`get_pixmap_from_image(fz_image *image, const fz_irect *subarea, fz_matrix *ctm)` => `(fz_pixmap *, int w, int h)`
*/
/**
	Called to get a handle to a pixmap from an image.

	image: The image to retrieve a pixmap from.

	subarea: The subarea of the image that we actually care about
	(or NULL to indicate the whole image).

	ctm: Optional, unless subarea is given. If given, then on
	entry this is the transform that will be applied to the complete
	image. It should be updated on exit to the transform to apply to
	the given subarea of the image. This is used to calculate the
	desired width/height for subsampling.

	w: If non-NULL, a pointer to an int to be updated on exit to the
	width (in pixels) that the scaled output will cover.

	h: If non-NULL, a pointer to an int to be updated on exit to the
	height (in pixels) that the scaled output will cover.

	Returns a non NULL pixmap pointer. May throw exceptions.
*/
FZ_FUNCTION fz_pixmap *get_pixmap_from_image(fz_image *image, const fz_irect *subarea, fz_matrix *ctm, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *w
		#endif
		, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *h
		#endif
		);

/** Wrapper for `fz_get_unscaled_pixmap_from_image()`. */
/**
	Calls fz_get_pixmap_from_image() with ctm, subarea, w and h all set to NULL.
*/
FZ_FUNCTION fz_pixmap *get_unscaled_pixmap_from_image(fz_image *image);

/** Wrapper for `fz_getopt()`.

This function has out-params. Python/C# wrappers look like:
	`getopt(int nargc, const char *ostr)` => `(int, char *nargv)`
*/
/**
	Simple functions/variables for use in tools.
*/
FZ_FUNCTION int getopt(int nargc, 
		#ifdef SWIG
			char **OUTPUT
		#else
			char **nargv
		#endif
		, const char *ostr);

/** Wrapper for `fz_glyph_bbox()`. */
/**
	Return the bounding box of the glyph in pixels.
*/
FZ_FUNCTION fz_irect glyph_bbox(fz_glyph *glyph);

/** Wrapper for `fz_glyph_bbox_no_ctx()`. */
FZ_FUNCTION fz_irect glyph_bbox_no_ctx(fz_glyph *src);

/** Wrapper for `fz_glyph_cacheable()`. */
/**
	Determine if a given glyph in a font
	is cacheable. Certain glyphs in a type 3 font cannot safely
	be cached, as their appearance depends on the enclosing
	graphic state.

	font: The font to look for the glyph in.

	gif: The glyph to query.

	Returns non-zero if cacheable, 0 if not.
*/
FZ_FUNCTION int glyph_cacheable(fz_font *font, int gid);

/** Wrapper for `fz_glyph_height()`. */
/**
	Return the height of the glyph in pixels.
*/
FZ_FUNCTION int glyph_height(fz_glyph *glyph);

/** Wrapper for `fz_glyph_name_from_unicode_sc()`. */
FZ_FUNCTION const char *glyph_name_from_unicode_sc(int unicode);

/** Wrapper for `fz_glyph_width()`. */
/**
	Return the width of the glyph in pixels.
*/
FZ_FUNCTION int glyph_width(fz_glyph *glyph);

/** Wrapper for `fz_graphics_aa_level()`. */
/**
	Get the number of bits of antialiasing we are
	using for graphics. Between 0 and 8.
*/
FZ_FUNCTION int graphics_aa_level();

/** Wrapper for `fz_graphics_min_line_width()`. */
/**
	Get the minimum line width to be
	used for stroked lines.

	min_line_width: The minimum line width to use (in pixels).
*/
FZ_FUNCTION float graphics_min_line_width();

/** Wrapper for `fz_gridfit_matrix()`. */
/**
	Grid fit a matrix.

	as_tiled = 0 => adjust the matrix so that the image of the unit
	square completely covers any pixel that was touched by the
	image of the unit square under the original matrix.

	as_tiled = 1 => adjust the matrix so that the corners of the
	image of the unit square align with the closest integer corner
	of the image of the unit square under the original matrix.
*/
FZ_FUNCTION fz_matrix gridfit_matrix(int as_tiled, fz_matrix m);

/** Wrapper for `fz_grisu()`.

This function has out-params. Python/C# wrappers look like:
	`grisu(float f, char *s)` => `(int, int exp)`
*/
FZ_FUNCTION int grisu(float f, char *s, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *exp
		#endif
		);

/** Wrapper for `fz_grow_buffer()`. */
/**
	Make some space within a buffer (i.e. ensure that
	capacity > size).
*/
FZ_FUNCTION void grow_buffer(fz_buffer *buf);

/** Wrapper for `fz_has_archive_entry()`. */
/**
	Check if entry by given name exists.

	If named entry does not exist 0 will be returned, if it does
	exist 1 is returned.

	name: Entry name to look for, this must be an exact match to
	the entry name in the archive.
*/
FZ_FUNCTION int has_archive_entry(fz_archive *arch, const char *name);

/** Wrapper for `fz_has_option()`.

This function has out-params. Python/C# wrappers look like:
	`has_option(const char *opts, const char *key)` => `(int, const char *val)`
*/
/**
	Look for a given option (key) in the opts string. Return 1 if
	it has it, and update *val to point to the value within opts.
*/
FZ_FUNCTION int has_option(const char *opts, const char *key, 
		#ifdef SWIG
			const char **OUTPUT
		#else
			const char **val
		#endif
		);

/** Wrapper for `fz_has_permission()`. */
/**
	Check permission flags on document.
*/
FZ_FUNCTION int has_permission(fz_document *doc, fz_permission p);

/** Wrapper for `fz_hash_filter()`. */
/**
	Iterate over the entries in a hash table, removing all the ones where callback returns true.
	Does NOT free the value of the entry, so the caller is expected to take care of this.
*/
FZ_FUNCTION void hash_filter(fz_hash_table *table, void *state, fz_hash_table_filter_fn *callback);

/** Wrapper for `fz_hash_find()`. */
/**
	Search for a matching hash within the table, and return the
	associated value.
*/
FZ_FUNCTION void *hash_find(fz_hash_table *table, const void *key);

/** Wrapper for `fz_hash_for_each()`. */
/**
	Iterate over the entries in a hash table.
*/
FZ_FUNCTION void hash_for_each(fz_hash_table *table, void *state, fz_hash_table_for_each_fn *callback);

/** Wrapper for `fz_hash_insert()`. */
/**
	Insert a new key/value pair into the hash table.

	If an existing entry with the same key is found, no change is
	made to the hash table, and a pointer to the existing value is
	returned.

	If no existing entry with the same key is found, ownership of
	val passes in, key is copied, and NULL is returned.
*/
FZ_FUNCTION void *hash_insert(fz_hash_table *table, const void *key, void *val);

/** Wrapper for `fz_hash_remove()`. */
/**
	Remove the entry for a given key.

	The value is NOT freed, so the caller is expected to take care
	of this.
*/
FZ_FUNCTION void hash_remove(fz_hash_table *table, const void *key);

/** Wrapper for `fz_hb_lock()`. */
/**
	Lock against Harfbuzz being called
	simultaneously in several threads. This reuses
	FZ_LOCK_FREETYPE.
*/
FZ_FUNCTION void hb_lock();

/** Wrapper for `fz_hb_unlock()`. */
/**
	Unlock after a Harfbuzz call. This reuses
	FZ_LOCK_FREETYPE.
*/
FZ_FUNCTION void hb_unlock();

/** Wrapper for `fz_highlight_selection()`. */
/**
	Return a list of quads to highlight lines inside the selection
	points.
*/
FZ_FUNCTION int highlight_selection(fz_stext_page *page, fz_point a, fz_point b, fz_quad *quads, int max_quads);

/** Wrapper for `fz_ignore_text()`. */
FZ_FUNCTION void ignore_text(fz_device *dev, const fz_text *text, fz_matrix ctm);

/** Wrapper for `fz_image_orientation()`. */
/**
	Request the natural orientation of an image.

	This is for images (such as JPEG) that can contain internal
	specifications of rotation/flips. This is ignored by all the
	internal decode/rendering routines, but can be used by callers
	(such as the image document handler) to respect such
	specifications.

	The values used by MuPDF are as follows, with the equivalent
	Exif specifications given for information:

	0: Undefined
	1: 0 degree ccw rotation. (Exif = 1)
	2: 90 degree ccw rotation. (Exif = 8)
	3: 180 degree ccw rotation. (Exif = 3)
	4: 270 degree ccw rotation. (Exif = 6)
	5: flip on X. (Exif = 2)
	6: flip on X, then rotate ccw by 90 degrees. (Exif = 5)
	7: flip on X, then rotate ccw by 180 degrees. (Exif = 4)
	8: flip on X, then rotate ccw by 270 degrees. (Exif = 7)
*/
FZ_FUNCTION uint8_t image_orientation(fz_image *image);

/** Wrapper for `fz_image_orientation_matrix()`. */
FZ_FUNCTION fz_matrix image_orientation_matrix(fz_image *image);

/** Wrapper for `fz_image_resolution()`.

This function has out-params. Python/C# wrappers look like:
	`image_resolution(fz_image *image)` => `(int xres, int yres)`
*/
/**
	Request the natural resolution
	of an image.

	xres, yres: Pointers to ints to be updated with the
	natural resolution of an image (or a sensible default
	if not encoded).
*/
FZ_FUNCTION void image_resolution(fz_image *image, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *xres
		#endif
		, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *yres
		#endif
		);

/** Wrapper for `fz_image_size()`. */
/**
	Return the size of the storage used by an image.
*/
FZ_FUNCTION size_t image_size(fz_image *im);

/** Wrapper for `fz_include_point_in_rect()`. */
/**
	Expand a bbox to include a given point.
	To create a rectangle that encompasses a sequence of points, the
	rectangle must first be set to be the empty rectangle at one of
	the points before including the others.
*/
FZ_FUNCTION fz_rect include_point_in_rect(fz_rect r, fz_point p);

/** Wrapper for `fz_install_load_system_font_funcs()`. */
/**
	Install functions to allow MuPDF to request fonts from the
	system.

	Only one set of hooks can be in use at a time.
*/
FZ_FUNCTION void install_load_system_font_funcs(fz_load_system_font_fn *f, fz_load_system_cjk_font_fn *f_cjk, fz_load_system_fallback_font_fn *f_fallback);

/** Wrapper for `fz_intersect_irect()`. */
/**
	Compute intersection of two bounding boxes.

	Similar to fz_intersect_rect but operates on two bounding
	boxes instead of two rectangles.
*/
FZ_FUNCTION fz_irect intersect_irect(fz_irect a, fz_irect b);

/** Wrapper for `fz_intersect_rect()`. */
/**
	Compute intersection of two rectangles.

	Given two rectangles, update the first to be the smallest
	axis-aligned rectangle that covers the area covered by both
	given rectangles. If either rectangle is empty then the
	intersection is also empty. If either rectangle is infinite
	then the intersection is simply the non-infinite rectangle.
	Should both rectangles be infinite, then the intersection is
	also infinite.
*/
FZ_FUNCTION fz_rect intersect_rect(fz_rect a, fz_rect b);

/** Wrapper for `fz_invert_matrix()`. */
/**
	Create an inverse matrix.

	inverse: Place to store inverse matrix.

	matrix: Matrix to invert. A degenerate matrix, where the
	determinant is equal to zero, can not be inverted and the
	original matrix is returned instead.

	Returns inverse.
*/
FZ_FUNCTION fz_matrix invert_matrix(fz_matrix matrix);

/** Wrapper for `fz_invert_pixmap()`. */
/**
	Invert all the pixels in a pixmap. All components (process and
	spots) of all pixels are inverted (except alpha, which is
	unchanged).
*/
FZ_FUNCTION void invert_pixmap(fz_pixmap *pix);

/** Wrapper for `fz_invert_pixmap_alpha()`. */
/**
	Invert the alpha fo all the pixels in a pixmap.
*/
FZ_FUNCTION void invert_pixmap_alpha(fz_pixmap *pix);

/** Wrapper for `fz_invert_pixmap_luminance()`. */
/**
	Transform the pixels in a pixmap so that luminance of each
	pixel is inverted, and the chrominance remains unchanged (as
	much as accuracy allows).

	All components of all pixels are inverted (except alpha, which
	is unchanged). Only supports Grey and RGB bitmaps.
*/
FZ_FUNCTION void invert_pixmap_luminance(fz_pixmap *pix);

/** Wrapper for `fz_invert_pixmap_rect()`. */
/**
	Invert all the pixels in a given rectangle of a
	pixmap. All components of all pixels in the rectangle are
	inverted (except alpha, which is unchanged).
*/
FZ_FUNCTION void invert_pixmap_rect(fz_pixmap *image, fz_irect rect);

/** Wrapper for `fz_irect_from_rect()`. */
/**
	Convert a rect into the minimal bounding box
	that covers the rectangle.

	Coordinates in a bounding box are integers, so rounding of the
	rects coordinates takes place. The top left corner is rounded
	upwards and left while the bottom right corner is rounded
	downwards and to the right.
*/
FZ_FUNCTION fz_irect irect_from_rect(fz_rect rect);

/** Wrapper for `fz_irect_height()`. */
/**
	Return the height of an irect. Invalid irects return 0.
*/
FZ_FUNCTION int irect_height(fz_irect r);

/** Wrapper for `fz_irect_width()`. */
/**
	Return the width of an irect. Invalid irects return 0.
*/
FZ_FUNCTION unsigned int irect_width(fz_irect r);

/** Wrapper for `fz_is_directory()`. */
/**
	Determine if a given path is a directory.
*/
FZ_FUNCTION int is_directory(const char *path);

/** Wrapper for `fz_is_document_reflowable()`. */
/**
	Is the document reflowable.

	Returns 1 to indicate reflowable documents, otherwise 0.
*/
FZ_FUNCTION int is_document_reflowable(fz_document *doc);

/** Wrapper for `fz_is_empty_irect()`. */
FZ_FUNCTION int is_empty_irect(fz_irect r);

/** Wrapper for `fz_is_empty_rect()`. */
/**
	Check if rectangle is empty.

	An empty rectangle is defined as one whose area is zero.
	All invalid rectangles are empty.
*/
FZ_FUNCTION int is_empty_rect(fz_rect r);

/** Wrapper for `fz_is_eof()`. */
/**
	Query if the stream has reached EOF (during normal bytewise
	reading).

	See fz_is_eof_bits for the equivalent function for bitwise
	reading.
*/
FZ_FUNCTION int is_eof(fz_stream *stm);

/** Wrapper for `fz_is_eof_bits()`. */
/**
	Query if the stream has reached EOF (during bitwise
	reading).

	See fz_is_eof for the equivalent function for bytewise
	reading.
*/
FZ_FUNCTION int is_eof_bits(fz_stream *stm);

/** Wrapper for `fz_is_external_link()`. */
/**
	Query whether a link is external to a document (determined by
	uri containing a ':', intended to match with '://' which
	separates the scheme from the scheme specific parts in URIs).
*/
FZ_FUNCTION int is_external_link(const char *uri);

/** Wrapper for `fz_is_identity()`. */
FZ_FUNCTION int is_identity(fz_matrix m);

/** Wrapper for `fz_is_infinite_irect()`. */
/**
	Check if an integer rectangle
	is infinite.
*/
FZ_FUNCTION int is_infinite_irect(fz_irect r);

/** Wrapper for `fz_is_infinite_rect()`. */
/**
	Check if rectangle is infinite.
*/
FZ_FUNCTION int is_infinite_rect(fz_rect r);

/** Wrapper for `fz_is_page_range()`. */
/**
	Check and parse string into page ranges:
		/,?(-?\d+|N)(-(-?\d+|N))?/
*/
FZ_FUNCTION int is_page_range(const char *s);

/** Wrapper for `fz_is_pixmap_monochrome()`. */
/**
	Check if the pixmap is a 1-channel image containing samples with
	only values 0 and 255
*/
FZ_FUNCTION int is_pixmap_monochrome(fz_pixmap *pixmap);

/** Wrapper for `fz_is_point_inside_irect()`. */
/**
	Inclusion test for irects. (Rect is assumed to be open, i.e.
	top right corner is not included).
*/
FZ_FUNCTION int is_point_inside_irect(int x, int y, fz_irect r);

/** Wrapper for `fz_is_point_inside_quad()`. */
/**
	Inclusion test for quads.
*/
FZ_FUNCTION int is_point_inside_quad(fz_point p, fz_quad q);

/** Wrapper for `fz_is_point_inside_rect()`. */
/**
	Inclusion test for rects. (Rect is assumed to be open, i.e.
	top right corner is not included).
*/
FZ_FUNCTION int is_point_inside_rect(fz_point p, fz_rect r);

/** Wrapper for `fz_is_pow2()`. */
FZ_FUNCTION int is_pow2(int a);

/** Wrapper for `fz_is_quad_inside_quad()`. */
/**
	Inclusion test for quad in quad.

	This may break down if quads are not 'well formed'.
*/
FZ_FUNCTION int is_quad_inside_quad(fz_quad needle, fz_quad haystack);

/** Wrapper for `fz_is_quad_intersecting_quad()`. */
/**
	Intersection test for quads.

	This may break down if quads are not 'well formed'.
*/
FZ_FUNCTION int is_quad_intersecting_quad(fz_quad a, fz_quad b);

/** Wrapper for `fz_is_rectilinear()`. */
/**
	Check if a transformation is rectilinear.

	Rectilinear means that no shearing is present and that any
	rotations present are a multiple of 90 degrees. Usually this
	is used to make sure that axis-aligned rectangles before the
	transformation are still axis-aligned rectangles afterwards.
*/
FZ_FUNCTION int is_rectilinear(fz_matrix m);

/** Wrapper for `fz_is_tar_archive()`. */
/**
	Detect if stream object is a tar achieve.

	Assumes that the stream object is seekable.
*/
FZ_FUNCTION int is_tar_archive(fz_stream *file);

/** Wrapper for `fz_is_valid_blend_colorspace()`. */
/**
	Check to see that a colorspace is appropriate to be used as
	a blending space (i.e. only grey, rgb or cmyk).
*/
FZ_FUNCTION int is_valid_blend_colorspace(fz_colorspace *cs);

/** Wrapper for `fz_is_valid_irect()`. */
/**
	Check if an integer rectangle is valid.
*/
FZ_FUNCTION int is_valid_irect(fz_irect r);

/** Wrapper for `fz_is_valid_rect()`. */
/**
	Check if rectangle is valid.
*/
FZ_FUNCTION int is_valid_rect(fz_rect r);

/** Wrapper for `fz_is_zip_archive()`. */
/**
	Detect if stream object is a zip archive.

	Assumes that the stream object is seekable.
*/
FZ_FUNCTION int is_zip_archive(fz_stream *file);

/** Wrapper for `fz_iso8859_1_from_unicode()`. */
FZ_FUNCTION int iso8859_1_from_unicode(int u);

/** Wrapper for `fz_iso8859_7_from_unicode()`. */
FZ_FUNCTION int iso8859_7_from_unicode(int u);

/** Wrapper for `fz_jbig2_globals_data()`. */
/**
	Return buffer containing jbig2 globals data stream.
*/
FZ_FUNCTION fz_buffer *jbig2_globals_data(fz_jbig2_globals *globals);

/** Wrapper for `fz_keep_bitmap()`. */
/**
	Take an additional reference to the bitmap. The same pointer
	is returned.

	Never throws exceptions.
*/
FZ_FUNCTION fz_bitmap *keep_bitmap(fz_bitmap *bit);

/** Wrapper for `fz_keep_buffer()`. */
/**
	Take an additional reference to the buffer. The same pointer
	is returned.

	Never throws exceptions.
*/
FZ_FUNCTION fz_buffer *keep_buffer(fz_buffer *buf);

/** Wrapper for `fz_keep_colorspace()`. */
/**
	Increment the reference count for the colorspace.

	Returns the same pointer. Never throws an exception.
*/
FZ_FUNCTION fz_colorspace *keep_colorspace(fz_colorspace *colorspace);

/** Wrapper for `fz_keep_default_colorspaces()`. */
/**
	Keep an additional reference to the default colorspaces
	structure.

	Never throws exceptions.
*/
FZ_FUNCTION fz_default_colorspaces *keep_default_colorspaces(fz_default_colorspaces *default_cs);

/** Wrapper for `fz_keep_device()`. */
/**
	Increment the reference count for a device. Returns the same
	pointer.

	Never throws exceptions.
*/
FZ_FUNCTION fz_device *keep_device(fz_device *dev);

/** Wrapper for `fz_keep_display_list()`. */
/**
	Increment the reference count for a display list. Returns the
	same pointer.

	Never throws exceptions.
*/
FZ_FUNCTION fz_display_list *keep_display_list(fz_display_list *list);

/** Wrapper for `fz_keep_document()`. */
/**
	Increment the document reference count. The same pointer is
	returned.

	Never throws exceptions.
*/
FZ_FUNCTION fz_document *keep_document(fz_document *doc);

/** Wrapper for `fz_keep_font()`. */
/**
	Add a reference to an existing fz_font.

	font: The font to add a reference to.

	Returns the same font.
*/
FZ_FUNCTION fz_font *keep_font(fz_font *font);

/** Wrapper for `fz_keep_glyph()`. */
/**
	Take a reference to a glyph.

	pix: The glyph to increment the reference for.

	Returns pix.
*/
FZ_FUNCTION fz_glyph *keep_glyph(fz_glyph *pix);

/** Wrapper for `fz_keep_halftone()`. */
/**
	Take an additional reference to the halftone. The same pointer
	is returned.

	Never throws exceptions.
*/
FZ_FUNCTION fz_halftone *keep_halftone(fz_halftone *half);

/** Wrapper for `fz_keep_image()`. */
/**
	Increment the (normal) reference count for an image. Returns the
	same pointer.

	Never throws exceptions.
*/
FZ_FUNCTION fz_image *keep_image(fz_image *image);

/** Wrapper for `fz_keep_image_store_key()`. */
/**
	Increment the store key reference for an image. Returns the same
	pointer. (This is the count of references for an image held by
	keys in the image store).

	Never throws exceptions.
*/
FZ_FUNCTION fz_image *keep_image_store_key(fz_image *image);

/** Wrapper for `fz_keep_imp()`.

This function has out-params. Python/C# wrappers look like:
	`keep_imp(void *p)` => `(void *, int refs)`
*/
FZ_FUNCTION void *keep_imp(void *p, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *refs
		#endif
		);

/** Wrapper for `fz_keep_imp16()`.

This function has out-params. Python/C# wrappers look like:
	`keep_imp16(void *p)` => `(void *, int16_t refs)`
*/
FZ_FUNCTION void *keep_imp16(void *p, 
		#ifdef SWIG
			int16_t *OUTPUT
		#else
			int16_t *refs
		#endif
		);

/** Wrapper for `fz_keep_imp8()`. */
FZ_FUNCTION void *keep_imp8(void *p, int8_t *refs);

/** Wrapper for `fz_keep_imp_locked()`.

This function has out-params. Python/C# wrappers look like:
	`keep_imp_locked(void *p)` => `(void *, int refs)`
*/
FZ_FUNCTION void *keep_imp_locked(void *p, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *refs
		#endif
		);

/** Wrapper for `fz_keep_jbig2_globals()`. */
/**
	Increment the reference count for a jbig2 globals record.

	Never throws an exception.
*/
FZ_FUNCTION fz_jbig2_globals *keep_jbig2_globals(fz_jbig2_globals *globals);

/** Wrapper for `fz_keep_key_storable()`. */
/**
	Increment the (normal) reference count for a key storable
	object. Returns the same pointer.

	Never throws exceptions.
*/
FZ_FUNCTION void *keep_key_storable(const fz_key_storable *arg_1);

/** Wrapper for `fz_keep_key_storable_key()`. */
/**
	Increment the (key) reference count for a key storable
	object. Returns the same pointer.

	Never throws exceptions.
*/
FZ_FUNCTION void *keep_key_storable_key(const fz_key_storable *arg_1);

/** Wrapper for `fz_keep_link()`. */
/**
	Increment the reference count for a link. The same pointer is
	returned.

	Never throws exceptions.
*/
FZ_FUNCTION fz_link *keep_link(fz_link *link);

/** Wrapper for `fz_keep_outline()`. */
/**
	Increment the reference count. Returns the same pointer.

	Never throws exceptions.
*/
FZ_FUNCTION fz_outline *keep_outline(fz_outline *outline);

/** Wrapper for `fz_keep_page()`. */
/**
	Increment the reference count for the page. Returns the same
	pointer.

	Never throws exceptions.
*/
FZ_FUNCTION fz_page *keep_page(fz_page *page);

/** Wrapper for `fz_keep_page_locked()`. */
/**
	Increment the reference count for the page. Returns the same
	pointer. Must only be used when the alloc lock is already taken.

	Never throws exceptions.
*/
FZ_FUNCTION fz_page *keep_page_locked(fz_page *page);

/** Wrapper for `fz_keep_path()`. */
/**
	Increment the reference count. Returns the same pointer.

	All paths can be kept, regardless of their packing type.

	Never throws exceptions.
*/
FZ_FUNCTION fz_path *keep_path(const fz_path *path);

/** Wrapper for `fz_keep_pixmap()`. */
/**
	Increment the reference count for the pixmap. The same pointer
	is returned.

	Never throws exceptions.
*/
FZ_FUNCTION fz_pixmap *keep_pixmap(fz_pixmap *pix);

/** Wrapper for `fz_keep_separations()`. */
/**
	Increment the reference count for a separations structure.
	Returns the same pointer.

	Never throws exceptions.
*/
FZ_FUNCTION fz_separations *keep_separations(fz_separations *sep);

/** Wrapper for `fz_keep_shade()`. */
/**
	Increment the reference count for the shade structure. The
	same pointer is returned.

	Never throws exceptions.
*/
FZ_FUNCTION fz_shade *keep_shade(fz_shade *shade);

/** Wrapper for `fz_keep_storable()`. */
/**
	Increment the reference count for a storable object.
	Returns the same pointer.

	Never throws exceptions.
*/
FZ_FUNCTION void *keep_storable(const fz_storable *arg_1);

/** Wrapper for `fz_keep_store_context()`. */
/**
	Increment the reference count for the store context. Returns
	the same pointer.

	Never throws exceptions.
*/
FZ_FUNCTION fz_store *keep_store_context();

/** Wrapper for `fz_keep_stream()`. */
/**
	Increments the reference count for a stream. Returns the same
	pointer.

	Never throws exceptions.
*/
FZ_FUNCTION fz_stream *keep_stream(fz_stream *stm);

/** Wrapper for `fz_keep_stroke_state()`. */
/**
	Take an additional reference to a stroke state structure.

	No modifications should be carried out on a stroke
	state to which more than one reference is held, as
	this can cause race conditions.
*/
FZ_FUNCTION fz_stroke_state *keep_stroke_state(const fz_stroke_state *stroke);

/** Wrapper for `fz_keep_text()`. */
/**
	Increment the reference count for the text object. The same
	pointer is returned.

	Never throws exceptions.
*/
FZ_FUNCTION fz_text *keep_text(const fz_text *text);

/** Wrapper for `fz_koi8u_from_unicode()`. */
FZ_FUNCTION int koi8u_from_unicode(int u);

/** Wrapper for `fz_last_page()`. */
/**
	Function to get the location for the last page in the document.
	Using this can be far more efficient in some cases than calling
	fz_count_pages and using the page number.
*/
FZ_FUNCTION fz_location last_page(fz_document *doc);

/** Wrapper for `fz_layout_document()`. */
/**
	Layout reflowable document types.

	w, h: Page size in points.
	em: Default font size in points.
*/
FZ_FUNCTION void layout_document(fz_document *doc, float w, float h, float em);

/** Wrapper for `fz_lineto()`. */
/**
	Append a 'lineto' command to an open path.

	path: The path to modify.

	x, y: The coordinate to line to.

	Throws exceptions on failure to allocate, or attempting to
	modify a packed path.
*/
FZ_FUNCTION void lineto(fz_path *path, float x, float y);

/** Wrapper for `fz_list_archive_entry()`. */
/**
	Get listed name of entry position idx.

	idx: Must be a value >= 0 < return value from
	fz_count_archive_entries. If not in range NULL will be
	returned.

	May throw an exception if this type of archive cannot list the
	entries (such as a directory).
*/
FZ_FUNCTION const char *list_archive_entry(fz_archive *arch, int idx);

/** Wrapper for `fz_load_bmp_subimage()`. */
FZ_FUNCTION fz_pixmap *load_bmp_subimage(const unsigned char *buf, size_t len, int subimage);

/** Wrapper for `fz_load_bmp_subimage_count()`. */
FZ_FUNCTION int load_bmp_subimage_count(const unsigned char *buf, size_t len);

/** Wrapper for `fz_load_chapter_page()`. */
/**
	Load a page.

	After fz_load_page is it possible to retrieve the size of the
	page using fz_bound_page, or to render the page using
	fz_run_page_*. Free the page by calling fz_drop_page.

	chapter: chapter number, 0 is the first chapter of the document.
	number: page number, 0 is the first page of the chapter.
*/
FZ_FUNCTION fz_page *load_chapter_page(fz_document *doc, int chapter, int page);

/** Wrapper for `fz_load_fallback_font()`. */
/**
	Try to load a fallback font for the
	given combination of font attributes. Whether a font is
	present or not will depend on the configuration in which
	MuPDF is built.

	script: The script desired (e.g. UCDN_SCRIPT_KATAKANA).

	language: The language desired (e.g. FZ_LANG_ja).

	serif: 1 if serif desired, 0 otherwise.

	bold: 1 if bold desired, 0 otherwise.

	italic: 1 if italic desired, 0 otherwise.

	Returns a new font handle, or NULL if not available.
*/
FZ_FUNCTION fz_font *load_fallback_font(int script, int language, int serif, int bold, int italic);

/** Wrapper for `fz_load_jbig2_globals()`. */
/**
	Create a jbig2 globals record from a buffer.

	Immutable once created.
*/
FZ_FUNCTION fz_jbig2_globals *load_jbig2_globals(fz_buffer *buf);

/** Wrapper for `fz_load_jbig2_subimage()`. */
FZ_FUNCTION fz_pixmap *load_jbig2_subimage(const unsigned char *buf, size_t len, int subimage);

/** Wrapper for `fz_load_jbig2_subimage_count()`. */
FZ_FUNCTION int load_jbig2_subimage_count(const unsigned char *buf, size_t len);

/** Wrapper for `fz_load_jpx()`. */
/**
	Exposed for PDF.
*/
FZ_FUNCTION fz_pixmap *load_jpx(const unsigned char *data, size_t size, fz_colorspace *cs);

/** Wrapper for `fz_load_links()`. */
/**
	Load the list of links for a page.

	Returns a linked list of all the links on the page, each with
	its clickable region and link destination. Each link is
	reference counted so drop and free the list of links by
	calling fz_drop_link on the pointer return from fz_load_links.

	page: Page obtained from fz_load_page.
*/
FZ_FUNCTION fz_link *load_links(fz_page *page);

/** Wrapper for `fz_load_outline()`. */
/**
	Load the hierarchical document outline.

	Should be freed by fz_drop_outline.
*/
FZ_FUNCTION fz_outline *load_outline(fz_document *doc);

/** Wrapper for `fz_load_outline_from_iterator()`. */
/**
	Routine to implement the old Structure based API from an iterator.
*/
FZ_FUNCTION fz_outline *load_outline_from_iterator(fz_outline_iterator *iter);

/** Wrapper for `fz_load_page()`. */
/**
	Load a given page number from a document. This may be much less
	efficient than loading by location (chapter+page) for some
	document types.
*/
FZ_FUNCTION fz_page *load_page(fz_document *doc, int number);

/** Wrapper for `fz_load_pnm_subimage()`. */
FZ_FUNCTION fz_pixmap *load_pnm_subimage(const unsigned char *buf, size_t len, int subimage);

/** Wrapper for `fz_load_pnm_subimage_count()`. */
FZ_FUNCTION int load_pnm_subimage_count(const unsigned char *buf, size_t len);

/** Wrapper for `fz_load_system_cjk_font()`. */
/**
	Attempt to load a given font from
	the system.

	name: The name of the desired font.

	ordering: The ordering to load the font from (e.g. FZ_ADOBE_KOREA)

	serif: 1 if serif desired, 0 otherwise.

	Returns a new font handle, or NULL if no matching font was found
	(or on error).
*/
FZ_FUNCTION fz_font *load_system_cjk_font(const char *name, int ordering, int serif);

/** Wrapper for `fz_load_system_font()`. */
/**
	Attempt to load a given font from the system.

	name: The name of the desired font.

	bold: 1 if bold desired, 0 otherwise.

	italic: 1 if italic desired, 0 otherwise.

	needs_exact_metrics: 1 if an exact metrical match is required,
	0 otherwise.

	Returns a new font handle, or NULL if no matching font was found
	(or on error).
*/
FZ_FUNCTION fz_font *load_system_font(const char *name, int bold, int italic, int needs_exact_metrics);

/** Wrapper for `fz_load_tiff_subimage()`. */
FZ_FUNCTION fz_pixmap *load_tiff_subimage(const unsigned char *buf, size_t len, int subimage);

/** Wrapper for `fz_load_tiff_subimage_count()`. */
/**
	Exposed for CBZ.
*/
FZ_FUNCTION int load_tiff_subimage_count(const unsigned char *buf, size_t len);

/** Wrapper for `fz_location_from_page_number()`. */
/**
	Converts from page number to chapter+page. This may cause many
	chapters to be laid out in order to calculate the number of
	pages within those chapters.
*/
FZ_FUNCTION fz_location location_from_page_number(fz_document *doc, int number);

/** Wrapper for `fz_lock()`. */
/**
	Lock one of the user supplied mutexes.
*/
FZ_FUNCTION void lock(int lock);

/** Wrapper for `fz_lookup_base14_font()`.

This function has out-params. Python/C# wrappers look like:
	`lookup_base14_font(const char *name)` => `(const unsigned char *, int len)`
*/
/**
	Search the builtin base14 fonts for a match.
	Whether a given font is present or not will depend on the
	configuration in which MuPDF is built.

	name: The name of the font desired.

	len: Pointer to a place to receive the length of the discovered
	font buffer.

	Returns a pointer to the font file data, or NULL if not present.
*/
FZ_FUNCTION const unsigned char *lookup_base14_font(const char *name, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *len
		#endif
		);

/** Wrapper for `fz_lookup_blendmode()`. */
/**
	Map from (case sensitive) blend mode string to enumeration.
*/
FZ_FUNCTION int lookup_blendmode(const char *name);

/** Wrapper for `fz_lookup_bookmark()`. */
/**
	Find a bookmark and return its page number.
*/
FZ_FUNCTION fz_location lookup_bookmark(fz_document *doc, fz_bookmark mark);

/** Wrapper for `fz_lookup_builtin_font()`.

This function has out-params. Python/C# wrappers look like:
	`lookup_builtin_font(const char *name, int bold, int italic)` => `(const unsigned char *, int len)`
*/
/**
	Search the builtin fonts for a match.
	Whether a given font is present or not will depend on the
	configuration in which MuPDF is built.

	name: The name of the font desired.

	bold: 1 if bold desired, 0 otherwise.

	italic: 1 if italic desired, 0 otherwise.

	len: Pointer to a place to receive the length of the discovered
	font buffer.

	Returns a pointer to the font file data, or NULL if not present.
*/
FZ_FUNCTION const unsigned char *lookup_builtin_font(const char *name, int bold, int italic, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *len
		#endif
		);

/** Wrapper for `fz_lookup_cjk_font()`.

This function has out-params. Python/C# wrappers look like:
	`lookup_cjk_font(int ordering)` => `(const unsigned char *, int len, int index)`
*/
/**
	Search the builtin cjk fonts for a match.
	Whether a font is present or not will depend on the
	configuration in which MuPDF is built.

	ordering: The desired ordering of the font (e.g. FZ_ADOBE_KOREA).

	len: Pointer to a place to receive the length of the discovered
	font buffer.

	Returns a pointer to the font file data, or NULL if not present.
*/
FZ_FUNCTION const unsigned char *lookup_cjk_font(int ordering, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *len
		#endif
		, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *index
		#endif
		);

/** Wrapper for `fz_lookup_cjk_font_by_language()`.

This function has out-params. Python/C# wrappers look like:
	`lookup_cjk_font_by_language(const char *lang)` => `(const unsigned char *, int len, int subfont)`
*/
/**
	Search the builtin cjk fonts for a match for a given language.
	Whether a font is present or not will depend on the
	configuration in which MuPDF is built.

	lang: Pointer to a (case sensitive) language string (e.g.
	"ja", "ko", "zh-Hant" etc).

	len: Pointer to a place to receive the length of the discovered
	font buffer.

	subfont: Pointer to a place to store the subfont index of the
	discovered font.

	Returns a pointer to the font file data, or NULL if not present.
*/
FZ_FUNCTION const unsigned char *lookup_cjk_font_by_language(const char *lang, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *len
		#endif
		, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *subfont
		#endif
		);

/** Wrapper for `fz_lookup_cjk_ordering_by_language()`. */
/**
	Return the matching FZ_ADOBE_* ordering
	for the given language tag, such as "zh-Hant", "zh-Hans", "ja", or "ko".
*/
FZ_FUNCTION int lookup_cjk_ordering_by_language(const char *name);

/** Wrapper for `fz_lookup_metadata()`. */
/**
	Retrieve document meta data strings.

	doc: The document to query.

	key: Which meta data key to retrieve...

	Basic information:
		'format'	-- Document format and version.
		'encryption'	-- Description of the encryption used.

	From the document information dictionary:
		'info:Title'
		'info:Author'
		'info:Subject'
		'info:Keywords'
		'info:Creator'
		'info:Producer'
		'info:CreationDate'
		'info:ModDate'

	buf: The buffer to hold the results (a nul-terminated UTF-8
	string).

	size: Size of 'buf'.

	Returns the number of bytes need to store the string plus terminator
	(will be larger than 'size' if the output was truncated), or -1 if the
	key is not recognized or found.
*/
FZ_FUNCTION int lookup_metadata(fz_document *doc, const char *key, char *buf, int size);


/** Extra wrapper for `fz_lookup_metadata()` that returns a std::string and sets
*o_out to length of string plus one. If <key> is not found, returns empty
string with *o_out=-1. <o_out> can be NULL if caller is not interested in
error information. */
FZ_FUNCTION std::string lookup_metadata(fz_document *doc, const char *key, int* o_out=NULL);

/** Wrapper for `fz_lookup_noto_emoji_font()`.

This function has out-params. Python/C# wrappers look like:
	`lookup_noto_emoji_font()` => `(const unsigned char *, int len)`
*/
FZ_FUNCTION const unsigned char *lookup_noto_emoji_font(
		#ifdef SWIG
			int *OUTPUT
		#else
			int *len
		#endif
		);

/** Wrapper for `fz_lookup_noto_font()`.

This function has out-params. Python/C# wrappers look like:
	`lookup_noto_font(int script, int lang)` => `(const unsigned char *, int len, int subfont)`
*/
/**
	Search the builtin noto fonts for a match.
	Whether a font is present or not will depend on the
	configuration in which MuPDF is built.

	script: The script desired (e.g. UCDN_SCRIPT_KATAKANA).

	lang: The language desired (e.g. FZ_LANG_ja).

	len: Pointer to a place to receive the length of the discovered
	font buffer.

	Returns a pointer to the font file data, or NULL if not present.
*/
FZ_FUNCTION const unsigned char *lookup_noto_font(int script, int lang, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *len
		#endif
		, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *subfont
		#endif
		);

/** Wrapper for `fz_lookup_noto_math_font()`.

This function has out-params. Python/C# wrappers look like:
	`lookup_noto_math_font()` => `(const unsigned char *, int len)`
*/
/**
	Search the builtin noto fonts specific symbol fonts.
	Whether a font is present or not will depend on the
	configuration in which MuPDF is built.
*/
FZ_FUNCTION const unsigned char *lookup_noto_math_font(
		#ifdef SWIG
			int *OUTPUT
		#else
			int *len
		#endif
		);

/** Wrapper for `fz_lookup_noto_music_font()`.

This function has out-params. Python/C# wrappers look like:
	`lookup_noto_music_font()` => `(const unsigned char *, int len)`
*/
FZ_FUNCTION const unsigned char *lookup_noto_music_font(
		#ifdef SWIG
			int *OUTPUT
		#else
			int *len
		#endif
		);

/** Wrapper for `fz_lookup_noto_symbol1_font()`.

This function has out-params. Python/C# wrappers look like:
	`lookup_noto_symbol1_font()` => `(const unsigned char *, int len)`
*/
FZ_FUNCTION const unsigned char *lookup_noto_symbol1_font(
		#ifdef SWIG
			int *OUTPUT
		#else
			int *len
		#endif
		);

/** Wrapper for `fz_lookup_noto_symbol2_font()`.

This function has out-params. Python/C# wrappers look like:
	`lookup_noto_symbol2_font()` => `(const unsigned char *, int len)`
*/
FZ_FUNCTION const unsigned char *lookup_noto_symbol2_font(
		#ifdef SWIG
			int *OUTPUT
		#else
			int *len
		#endif
		);

/** Wrapper for `fz_lookup_rendering_intent()`. */
/**
	Map from (case sensitive) rendering intent string to enumeration
	value.
*/
FZ_FUNCTION int lookup_rendering_intent(const char *name);

/** Wrapper for `fz_make_bookmark()`. */
/**
	Create a bookmark for the given page, which can be used to find
	the same location after the document has been laid out with
	different parameters.
*/
FZ_FUNCTION fz_bookmark make_bookmark(fz_document *doc, fz_location loc);

/** Wrapper for `fz_make_irect()`. */
FZ_FUNCTION fz_irect make_irect(int x0, int y0, int x1, int y1);

/** Wrapper for `fz_make_link_dest_none()`. */
FZ_FUNCTION fz_link_dest make_link_dest_none();

/** Wrapper for `fz_make_link_dest_xyz()`. */
FZ_FUNCTION fz_link_dest make_link_dest_xyz(int chapter, int page, float x, float y, float z);

/** Wrapper for `fz_make_location()`. */
/**
	Simple constructor for fz_locations.
*/
FZ_FUNCTION fz_location make_location(int chapter, int page);

/** Wrapper for `fz_make_matrix()`. */
FZ_FUNCTION fz_matrix make_matrix(float a, float b, float c, float d, float e, float f);

/** Wrapper for `fz_make_point()`. */
FZ_FUNCTION fz_point make_point(float x, float y);

/** Wrapper for `fz_make_quad()`. */
/**
	Inline convenience construction function.
*/
FZ_FUNCTION fz_quad make_quad(float ul_x, float ul_y, float ur_x, float ur_y, float ll_x, float ll_y, float lr_x, float lr_y);

/** Wrapper for `fz_make_rect()`. */
FZ_FUNCTION fz_rect make_rect(float x0, float y0, float x1, float y1);

/** Wrapper for `fz_malloc()`. */
/**
	Allocate uninitialized memory of a given size.
	Does NOT clear the memory!

	May return NULL for size = 0.

	Throws exception in the event of failure to allocate.
*/
FZ_FUNCTION void *malloc(size_t size);

/** Wrapper for `fz_malloc_no_throw()`. */
/**
	fz_malloc equivalent that returns NULL rather than throwing
	exceptions.
*/
FZ_FUNCTION void *malloc_no_throw(size_t size);

/** Wrapper for `fz_matrix_expansion()`. */
/**
	Calculate average scaling factor of matrix.
*/
FZ_FUNCTION float matrix_expansion(fz_matrix m);

/** Wrapper for `fz_matrix_max_expansion()`. */
/**
	Find the largest expansion performed by this matrix.
	(i.e. max(abs(m.a),abs(m.b),abs(m.c),abs(m.d))
*/
FZ_FUNCTION float matrix_max_expansion(fz_matrix m);

/** Wrapper for `fz_max()`. */
FZ_FUNCTION float max(float a, float b);

/** Wrapper for `fz_maxi()`. */
FZ_FUNCTION int maxi(int a, int b);

/** Wrapper for `fz_maxi64()`. */
FZ_FUNCTION int64_t maxi64(int64_t a, int64_t b);

/** Wrapper for `fz_maxz()`. */
FZ_FUNCTION size_t maxz(size_t a, size_t b);

/** Wrapper for `fz_md5_buffer()`. */
/**
	Create an MD5 digest from buffer contents.

	Never throws exceptions.
*/
FZ_FUNCTION void md5_buffer(fz_buffer *buffer, unsigned char digest[16]);

/** Wrapper for `fz_md5_final()`. */
/**
	MD5 finalization. Ends an MD5 message-digest operation, writing
	the message digest and zeroizing the context.

	Never throws an exception.
*/
FZ_FUNCTION void md5_final(fz_md5 *state, unsigned char digest[16]);

/** Wrapper for `fz_md5_init()`. */
/**
	MD5 initialization. Begins an MD5 operation, writing a new
	context.

	Never throws an exception.
*/
FZ_FUNCTION void md5_init(fz_md5 *state);

/** Wrapper for `fz_md5_pixmap()`. */
FZ_FUNCTION void md5_pixmap(fz_pixmap *pixmap, unsigned char digest[16]);

/** Wrapper for `fz_md5_update()`. */
/**
	MD5 block update operation. Continues an MD5 message-digest
	operation, processing another message block, and updating the
	context.

	Never throws an exception.
*/
FZ_FUNCTION void md5_update(fz_md5 *state, const unsigned char *input, size_t inlen);

/** Wrapper for `fz_md5_update_int64()`. */
/**
	MD5 block update operation. Continues an MD5 message-digest
	operation, processing an int64, and updating the context.

	Never throws an exception.
*/
FZ_FUNCTION void md5_update_int64(fz_md5 *state, int64_t i);

/** Wrapper for `fz_measure_string()`. */
/**
	Measure the advance width of a UTF8 string should it be added to a text object.

	This uses the same layout algorithms as fz_show_string, and can be used
	to calculate text alignment adjustments.
*/
FZ_FUNCTION fz_matrix measure_string(fz_font *user_font, fz_matrix trm, const char *s, int wmode, int bidi_level, fz_bidi_direction markup_dir, fz_text_language language);

/** Wrapper for `fz_memmem()`. */
/**
	Find the start of the first occurrence of the substring needle in haystack.
*/
FZ_FUNCTION void *memmem(const void *haystack, size_t haystacklen, const void *needle, size_t needlelen);

/** Wrapper for `fz_memrnd()`. */
/**
	Fill block with len bytes of pseudo-randomness.
*/
FZ_FUNCTION void memrnd(uint8_t *block, int len);

/** Wrapper for `fz_min()`. */
FZ_FUNCTION float min(float a, float b);

/** Wrapper for `fz_mini()`. */
FZ_FUNCTION int mini(int a, int b);

/** Wrapper for `fz_mini64()`. */
FZ_FUNCTION int64_t mini64(int64_t a, int64_t b);

/** Wrapper for `fz_minz()`. */
FZ_FUNCTION size_t minz(size_t a, size_t b);

/** Wrapper for `fz_moveto()`. */
/**
	Append a 'moveto' command to a path.
	This 'opens' a path.

	path: The path to modify.

	x, y: The coordinate to move to.

	Throws exceptions on failure to allocate, or attempting to
	modify a packed path.
*/
FZ_FUNCTION void moveto(fz_path *path, float x, float y);

/** Wrapper for `fz_mul255()`. */
/**
	Multiply scaled two integers in the 0..255 range
*/
FZ_FUNCTION int mul255(int a, int b);

/** Wrapper for `fz_needs_password()`. */
/**
	Check if a document is encrypted with a
	non-blank password.
*/
FZ_FUNCTION int needs_password(fz_document *doc);

/** Wrapper for `fz_new_arc4_output()`. */
FZ_FUNCTION fz_output *new_arc4_output(fz_output *chain, unsigned char *key, size_t keylen);

/** Wrapper for `fz_new_archive_of_size()`. */
FZ_FUNCTION fz_archive *new_archive_of_size(fz_stream *file, int size);

/** Wrapper for `fz_new_ascii85_output()`. */
FZ_FUNCTION fz_output *new_ascii85_output(fz_output *chain);

/** Wrapper for `fz_new_asciihex_output()`. */
/**
	Compression and other filtering outputs.

	These outputs write encoded data to another output. Create a
	filter output with the destination, write to the filter, then
	close and drop it when you're done. These can also be chained
	together, for example to write ASCII Hex encoded, Deflate
	compressed, and RC4 encrypted data to a buffer output.

	Output streams don't use reference counting, so make sure to
	close all of the filters in the reverse order of creation so
	that data is flushed properly.

	Accordingly, ownership of 'chain' is never passed into the
	following functions, but remains with the caller, whose
	responsibility it is to ensure they exist at least until
	the returned fz_output is dropped.
*/
FZ_FUNCTION fz_output *new_asciihex_output(fz_output *chain);

/** Wrapper for `fz_new_band_writer_of_size()`. */
FZ_FUNCTION fz_band_writer *new_band_writer_of_size(size_t size, fz_output *out);

/** Wrapper for `fz_new_base14_font()`. */
/**
	Create a new font from one of the built-in fonts.
*/
FZ_FUNCTION fz_font *new_base14_font(const char *name);

/** Wrapper for `fz_new_bbox_device()`. */
/**
	Create a device to compute the bounding
	box of all marks on a page.

	The returned bounding box will be the union of all bounding
	boxes of all objects on a page.
*/
FZ_FUNCTION fz_device *new_bbox_device(fz_rect *rectp);

/** Wrapper for `fz_new_bitmap()`. */
/**
	Create a new bitmap.

	w, h: Width and Height for the bitmap

	n: Number of color components (assumed to be a divisor of 8)

	xres, yres: X and Y resolutions (in pixels per inch).

	Returns pointer to created bitmap structure. The bitmap
	data is uninitialised.
*/
FZ_FUNCTION fz_bitmap *new_bitmap(int w, int h, int n, int xres, int yres);

/** Wrapper for `fz_new_bitmap_from_pixmap()`. */
/**
	Make a bitmap from a pixmap and a halftone.

	pix: The pixmap to generate from. Currently must be a single
	color component with no alpha.

	ht: The halftone to use. NULL implies the default halftone.

	Returns the resultant bitmap. Throws exceptions in the case of
	failure to allocate.
*/
FZ_FUNCTION fz_bitmap *new_bitmap_from_pixmap(fz_pixmap *pix, fz_halftone *ht);

/** Wrapper for `fz_new_bitmap_from_pixmap_band()`. */
/**
	Make a bitmap from a pixmap and a
	halftone, allowing for the position of the pixmap within an
	overall banded rendering.

	pix: The pixmap to generate from. Currently must be a single
	color component with no alpha.

	ht: The halftone to use. NULL implies the default halftone.

	band_start: Vertical offset within the overall banded rendering
	(in pixels)

	Returns the resultant bitmap. Throws exceptions in the case of
	failure to allocate.
*/
FZ_FUNCTION fz_bitmap *new_bitmap_from_pixmap_band(fz_pixmap *pix, fz_halftone *ht, int band_start);

/** Wrapper for `fz_new_buffer()`. */
FZ_FUNCTION fz_buffer *new_buffer(size_t capacity);

/** Wrapper for `fz_new_buffer_from_base64()`. */
/**
	Create a new buffer with data decoded from a base64 input string.
*/
FZ_FUNCTION fz_buffer *new_buffer_from_base64(const char *data, size_t size);

/** Wrapper for `fz_new_buffer_from_copied_data()`. */
/**
	Create a new buffer containing a copy of the passed data.
*/
FZ_FUNCTION fz_buffer *new_buffer_from_copied_data(const unsigned char *data, size_t size);

/** Wrapper for `fz_new_buffer_from_data()`. */
/**
	Create a new buffer with existing data.

	data: Pointer to existing data.
	size: Size of existing data.

	Takes ownership of data. Does not make a copy. Calls fz_free on
	the data when the buffer is deallocated. Do not use 'data' after
	passing to this function.

	Returns pointer to new buffer. Throws exception on allocation
	failure.
*/
FZ_FUNCTION fz_buffer *new_buffer_from_data(unsigned char *data, size_t size);

/** Wrapper for `fz_new_buffer_from_display_list()`. */
FZ_FUNCTION fz_buffer *new_buffer_from_display_list(fz_display_list *list, const fz_stext_options *options);

/** Wrapper for `fz_new_buffer_from_image_as_png()`. */
/**
	Reencode a given image as a PNG into a buffer.

	Ownership of the buffer is returned.
*/
FZ_FUNCTION fz_buffer *new_buffer_from_image_as_png(fz_image *image, fz_color_params color_params);

/** Wrapper for `fz_new_buffer_from_page()`. */
FZ_FUNCTION fz_buffer *new_buffer_from_page(fz_page *page, const fz_stext_options *options);

/** Wrapper for `fz_new_buffer_from_page_number()`. */
FZ_FUNCTION fz_buffer *new_buffer_from_page_number(fz_document *doc, int number, const fz_stext_options *options);

/** Wrapper for `fz_new_buffer_from_page_with_format()`. */
/**
	Returns an fz_buffer containing a page after conversion to specified format.

	page: The page to convert.
	format, options: Passed to fz_new_document_writer_with_output() internally.
	transform, cookie: Passed to fz_run_page() internally.
*/
FZ_FUNCTION fz_buffer *new_buffer_from_page_with_format(fz_page *page, const char *format, const char *options, fz_matrix transform, fz_cookie *cookie);

/** Wrapper for `fz_new_buffer_from_pixmap_as_png()`. */
/**
	Reencode a given pixmap as a PNG into a buffer.

	Ownership of the buffer is returned.
*/
FZ_FUNCTION fz_buffer *new_buffer_from_pixmap_as_png(fz_pixmap *pixmap, fz_color_params color_params);

/** Wrapper for `fz_new_buffer_from_shared_data()`. */
/**
	Like fz_new_buffer, but does not take ownership.
*/
FZ_FUNCTION fz_buffer *new_buffer_from_shared_data(const unsigned char *data, size_t size);

/** Wrapper for `fz_new_buffer_from_stext_page()`. */
/**
	Convert structured text into plain text.
*/
FZ_FUNCTION fz_buffer *new_buffer_from_stext_page(fz_stext_page *text);

/** Wrapper for `fz_new_builtin_font()`. */
FZ_FUNCTION fz_font *new_builtin_font(const char *name, int is_bold, int is_italic);

/** Wrapper for `fz_new_cal_gray_colorspace()`. */
/**
	Create a calibrated gray colorspace.

	The returned reference should be dropped when it is finished
	with.

	Colorspaces are immutable once created.
*/
FZ_FUNCTION fz_colorspace *new_cal_gray_colorspace(float wp[3], float bp[3], float gamma);

/** Wrapper for `fz_new_cal_rgb_colorspace()`. */
/**
	Create a calibrated rgb colorspace.

	The returned reference should be dropped when it is finished
	with.

	Colorspaces are immutable once created.
*/
FZ_FUNCTION fz_colorspace *new_cal_rgb_colorspace(float wp[3], float bp[3], float gamma[3], float matrix[9]);

/** Wrapper for `fz_new_cbz_writer()`. */
FZ_FUNCTION fz_document_writer *new_cbz_writer(const char *path, const char *options);

/** Wrapper for `fz_new_cbz_writer_with_output()`. */
FZ_FUNCTION fz_document_writer *new_cbz_writer_with_output(fz_output *out, const char *options);

/** Wrapper for `fz_new_cjk_font()`. */
FZ_FUNCTION fz_font *new_cjk_font(int ordering);

/** Wrapper for `fz_new_color_pcl_band_writer()`. */
/**
	Create a new band writer, outputing color pcl.
*/
FZ_FUNCTION fz_band_writer *new_color_pcl_band_writer(fz_output *out, const fz_pcl_options *options);

/** Wrapper for `fz_new_colorspace()`. */
/**
	Creates a new colorspace instance and returns a reference.

	No internal checking is done that the colorspace type (e.g.
	CMYK) matches with the flags (e.g. FZ_COLORSPACE_HAS_CMYK) or
	colorant count (n) or name.

	The reference should be dropped when it is finished with.

	Colorspaces are immutable once created (with the exception of
	setting up colorant names for separation spaces).
*/
FZ_FUNCTION fz_colorspace *new_colorspace(enum fz_colorspace_type type, int flags, int n, const char *name);

/** Wrapper for `fz_new_context_imp()`. */
FZ_FUNCTION fz_context *new_context_imp(const fz_alloc_context *alloc, const fz_locks_context *locks, size_t max_store, const char *version);

/** Wrapper for `fz_new_default_colorspaces()`. */
/**
	Create a new default colorspace structure with values inherited
	from the context, and return a reference to it.

	These can be overridden using fz_set_default_xxxx.

	These should not be overridden while more than one caller has
	the reference for fear of race conditions.

	The caller should drop this reference once finished with it.
*/
FZ_FUNCTION fz_default_colorspaces *new_default_colorspaces();

/** Wrapper for `fz_new_deflate_output()`. */
FZ_FUNCTION fz_output *new_deflate_output(fz_output *chain, int effort, int raw);

/** Wrapper for `fz_new_deflated_data()`.

This function has out-params. Python/C# wrappers look like:
	`new_deflated_data(const unsigned char *source, size_t source_length, fz_deflate_level level)` => `(unsigned char *, size_t compressed_length)`
*/
/**
	Compress source_length bytes of data starting
	at source, into a new memory block malloced for that purpose.
	*compressed_length is updated on exit to contain the size used.
	Ownership of the block is returned from this function, and the
	caller is therefore responsible for freeing it. The block may be
	considerably larger than is actually required. The caller is
	free to fz_realloc it down if it wants to.
*/
FZ_FUNCTION unsigned char *new_deflated_data(
		#ifdef SWIG
			size_t *OUTPUT
		#else
			size_t *compressed_length
		#endif
		, const unsigned char *source, size_t source_length, fz_deflate_level level);

/** Wrapper for `fz_new_deflated_data_from_buffer()`.

This function has out-params. Python/C# wrappers look like:
	`new_deflated_data_from_buffer(fz_buffer *buffer, fz_deflate_level level)` => `(unsigned char *, size_t compressed_length)`
*/
/**
	Compress the contents of a fz_buffer into a
	new block malloced for that purpose. *compressed_length is
	updated on exit to contain the size used. Ownership of the block
	is returned from this function, and the caller is therefore
	responsible for freeing it. The block may be considerably larger
	than is actually required. The caller is free to fz_realloc it
	down if it wants to.
*/
FZ_FUNCTION unsigned char *new_deflated_data_from_buffer(
		#ifdef SWIG
			size_t *OUTPUT
		#else
			size_t *compressed_length
		#endif
		, fz_buffer *buffer, fz_deflate_level level);

/** Wrapper for `fz_new_device_of_size()`. */
/**
	Devices are created by calls to device implementations, for
	instance: foo_new_device(). These will be implemented by calling
	fz_new_derived_device(ctx, foo_device) where foo_device is a
	structure "derived from" fz_device, for instance
	typedef struct { fz_device base;  ...extras...} foo_device;
*/
FZ_FUNCTION fz_device *new_device_of_size(int size);

/** Wrapper for `fz_new_display_list()`. */
/**
	Create an empty display list.

	A display list contains drawing commands (text, images, etc.).
	Use fz_new_list_device for populating the list.

	mediabox: Bounds of the page (in points) represented by the
	display list.
*/
FZ_FUNCTION fz_display_list *new_display_list(fz_rect mediabox);

/** Wrapper for `fz_new_display_list_from_page()`. */
/**
	Create a display list.

	Ownership of the display list is returned to the caller.
*/
FZ_FUNCTION fz_display_list *new_display_list_from_page(fz_page *page);

/** Wrapper for `fz_new_display_list_from_page_contents()`. */
/**
	Create a display list from page contents (no annotations).

	Ownership of the display list is returned to the caller.
*/
FZ_FUNCTION fz_display_list *new_display_list_from_page_contents(fz_page *page);

/** Wrapper for `fz_new_display_list_from_page_number()`. */
FZ_FUNCTION fz_display_list *new_display_list_from_page_number(fz_document *doc, int number);

/** Wrapper for `fz_new_display_list_from_svg()`.

This function has out-params. Python/C# wrappers look like:
	`new_display_list_from_svg(fz_buffer *buf, const char *base_uri, fz_archive *zip)` => `(fz_display_list *, float w, float h)`
*/
/**
	Parse an SVG document into a display-list.
*/
FZ_FUNCTION fz_display_list *new_display_list_from_svg(fz_buffer *buf, const char *base_uri, fz_archive *zip, 
		#ifdef SWIG
			float *OUTPUT
		#else
			float *w
		#endif
		, 
		#ifdef SWIG
			float *OUTPUT
		#else
			float *h
		#endif
		);

/** Wrapper for `fz_new_display_list_from_svg_xml()`.

This function has out-params. Python/C# wrappers look like:
	`new_display_list_from_svg_xml(fz_xml_doc *xmldoc, fz_xml *xml, const char *base_uri, fz_archive *zip)` => `(fz_display_list *, float w, float h)`
*/
/**
	Parse an SVG document into a display-list.
*/
FZ_FUNCTION fz_display_list *new_display_list_from_svg_xml(fz_xml_doc *xmldoc, fz_xml *xml, const char *base_uri, fz_archive *zip, 
		#ifdef SWIG
			float *OUTPUT
		#else
			float *w
		#endif
		, 
		#ifdef SWIG
			float *OUTPUT
		#else
			float *h
		#endif
		);

/** Wrapper for `fz_new_document_of_size()`. */
/**
	New documents are typically created by calls like
	foo_new_document(fz_context *ctx, ...). These work by
	deriving a new document type from fz_document, for instance:
	typedef struct { fz_document base; ...extras... } foo_document;
	These are allocated by calling
	fz_new_derived_document(ctx, foo_document)
*/
FZ_FUNCTION void *new_document_of_size(int size);

/** Wrapper for `fz_new_document_writer()`. */
/**
	Create a new fz_document_writer, for a
	file of the given type.

	path: The document name to write (or NULL for default)

	format: Which format to write (currently cbz, html, pdf, pam,
	pbm, pgm, pkm, png, ppm, pnm, svg, text, xhtml, docx, odt)

	options: NULL, or pointer to comma separated string to control
	file generation.
*/
FZ_FUNCTION fz_document_writer *new_document_writer(const char *path, const char *format, const char *options);

/** Wrapper for `fz_new_document_writer_of_size()`. */
/**
	Internal function to allocate a
	block for a derived document_writer structure, with the base
	structure's function pointers populated correctly, and the extra
	space zero initialised.
*/
FZ_FUNCTION fz_document_writer *new_document_writer_of_size(size_t size, fz_document_writer_begin_page_fn *begin_page, fz_document_writer_end_page_fn *end_page, fz_document_writer_close_writer_fn *close, fz_document_writer_drop_writer_fn *drop);

/** Wrapper for `fz_new_document_writer_with_output()`. */
/**
	Like fz_new_document_writer but takes a fz_output for writing
	the result. Only works for multi-page formats.
*/
FZ_FUNCTION fz_document_writer *new_document_writer_with_output(fz_output *out, const char *format, const char *options);

/** Wrapper for `fz_new_docx_writer()`. */
FZ_FUNCTION fz_document_writer *new_docx_writer(const char *path, const char *options);

/** Wrapper for `fz_new_docx_writer_with_output()`. */
FZ_FUNCTION fz_document_writer *new_docx_writer_with_output(fz_output *out, const char *options);

/** Wrapper for `fz_new_draw_device()`. */
/**
	Create a device to draw on a pixmap.

	dest: Target pixmap for the draw device. See fz_new_pixmap*
	for how to obtain a pixmap. The pixmap is not cleared by the
	draw device, see fz_clear_pixmap* for how to clear it prior to
	calling fz_new_draw_device. Free the device by calling
	fz_drop_device.

	transform: Transform from user space in points to device space
	in pixels.
*/
FZ_FUNCTION fz_device *new_draw_device(fz_matrix transform, fz_pixmap *dest);

/** Wrapper for `fz_new_draw_device_type3()`. */
FZ_FUNCTION fz_device *new_draw_device_type3(fz_matrix transform, fz_pixmap *dest);

/** Wrapper for `fz_new_draw_device_with_bbox()`. */
/**
	Create a device to draw on a pixmap.

	dest: Target pixmap for the draw device. See fz_new_pixmap*
	for how to obtain a pixmap. The pixmap is not cleared by the
	draw device, see fz_clear_pixmap* for how to clear it prior to
	calling fz_new_draw_device. Free the device by calling
	fz_drop_device.

	transform: Transform from user space in points to device space
	in pixels.

	clip: Bounding box to restrict any marking operations of the
	draw device.
*/
FZ_FUNCTION fz_device *new_draw_device_with_bbox(fz_matrix transform, fz_pixmap *dest, const fz_irect *clip);

/** Wrapper for `fz_new_draw_device_with_bbox_proof()`. */
/**
	Create a device to draw on a pixmap.

	dest: Target pixmap for the draw device. See fz_new_pixmap*
	for how to obtain a pixmap. The pixmap is not cleared by the
	draw device, see fz_clear_pixmap* for how to clear it prior to
	calling fz_new_draw_device. Free the device by calling
	fz_drop_device.

	transform: Transform from user space in points to device space
	in pixels.

	clip: Bounding box to restrict any marking operations of the
	draw device.

	proof_cs: Color space to render to prior to mapping to color
	space defined by pixmap.
*/
FZ_FUNCTION fz_device *new_draw_device_with_bbox_proof(fz_matrix transform, fz_pixmap *dest, const fz_irect *clip, fz_colorspace *cs);

/** Wrapper for `fz_new_draw_device_with_options()`.

This function has out-params. Python/C# wrappers look like:
	`new_draw_device_with_options(const fz_draw_options *options, fz_rect mediabox, fz_pixmap **pixmap)` => `(fz_device *)`
*/
/**
	Create a new pixmap and draw device, using the specified options.

	options: Options to configure the draw device, and choose the
	resolution and colorspace.

	mediabox: The bounds of the page in points.

	pixmap: An out parameter containing the newly created pixmap.
*/
FZ_FUNCTION fz_device *new_draw_device_with_options(const fz_draw_options *options, fz_rect mediabox, 
		#ifdef SWIG
			fz_pixmap **OUTPUT
		#else
			fz_pixmap **pixmap
		#endif
		);

/** Wrapper for `fz_new_draw_device_with_proof()`. */
/**
	Create a device to draw on a pixmap.

	dest: Target pixmap for the draw device. See fz_new_pixmap*
	for how to obtain a pixmap. The pixmap is not cleared by the
	draw device, see fz_clear_pixmap* for how to clear it prior to
	calling fz_new_draw_device. Free the device by calling
	fz_drop_device.

	transform: Transform from user space in points to device space
	in pixels.

	proof_cs: Intermediate color space to map though when mapping to
	color space defined by pixmap.
*/
FZ_FUNCTION fz_device *new_draw_device_with_proof(fz_matrix transform, fz_pixmap *dest, fz_colorspace *proof_cs);

/** Wrapper for `fz_new_font_from_buffer()`. */
/**
	Create a new font from a font file in a fz_buffer.

	name: Name of font (leave NULL to use name from font).

	buffer: Buffer to load from.

	index: Which font from the file to load (0 for default).

	use_glyph_box: 1 if we should use the glyph bbox, 0 otherwise.

	Returns new font handle, or throws exception on error.
*/
FZ_FUNCTION fz_font *new_font_from_buffer(const char *name, fz_buffer *buffer, int index, int use_glyph_bbox);

/** Wrapper for `fz_new_font_from_file()`. */
/**
	Create a new font from a font file.

	name: Name of font (leave NULL to use name from font).

	path: File path to load from.

	index: Which font from the file to load (0 for default).

	use_glyph_box: 1 if we should use the glyph bbox, 0 otherwise.

	Returns new font handle, or throws exception on error.
*/
FZ_FUNCTION fz_font *new_font_from_file(const char *name, const char *path, int index, int use_glyph_bbox);

/** Wrapper for `fz_new_font_from_memory()`. */
/**
	Create a new font from a font
	file in memory.

	name: Name of font (leave NULL to use name from font).

	data: Pointer to the font file data.

	len: Length of the font file data.

	index: Which font from the file to load (0 for default).

	use_glyph_box: 1 if we should use the glyph bbox, 0 otherwise.

	Returns new font handle, or throws exception on error.
*/
FZ_FUNCTION fz_font *new_font_from_memory(const char *name, const unsigned char *data, int len, int index, int use_glyph_bbox);

/** Wrapper for `fz_new_hash_table()`. */
/**
	Create a new hash table.

	initialsize: The initial size of the hashtable. The hashtable
	may grow (double in size) if it starts to get crowded (80%
	full).

	keylen: byte length for each key.

	lock: -1 for no lock, otherwise the FZ_LOCK to use to protect
	this table.

	drop_val: Function to use to destroy values on table drop.
*/
FZ_FUNCTION fz_hash_table *new_hash_table(int initialsize, int keylen, int lock, fz_hash_table_drop_fn *drop_val);

/** Wrapper for `fz_new_icc_colorspace()`. */
/**
	Create a colorspace from an ICC profile supplied in buf.

	Limited checking is done to ensure that the colorspace type is
	appropriate for the supplied ICC profile.

	An additional reference is taken to buf, which will be dropped
	on destruction. Ownership is NOT passed in.

	The returned reference should be dropped when it is finished
	with.

	Colorspaces are immutable once created.
*/
FZ_FUNCTION fz_colorspace *new_icc_colorspace(enum fz_colorspace_type type, int flags, const char *name, fz_buffer *buf);

/** Wrapper for `fz_new_image_from_buffer()`. */
/**
	Create a new image from a
	buffer of data, inferring its type from the format
	of the data.
*/
FZ_FUNCTION fz_image *new_image_from_buffer(fz_buffer *buffer);

/** Wrapper for `fz_new_image_from_compressed_buffer()`.

This function has out-params. Python/C# wrappers look like:
	`new_image_from_compressed_buffer(int w, int h, int bpc, fz_colorspace *colorspace, int xres, int yres, int interpolate, int imagemask, fz_compressed_buffer *buffer, fz_image *mask)` => `(fz_image *, float decode, int colorkey)`
*/
/**
	Create an image based on
	the data in the supplied compressed buffer.

	w,h: Width and height of the created image.

	bpc: Bits per component.

	colorspace: The colorspace (determines the number of components,
	and any color conversions required while decoding).

	xres, yres: The X and Y resolutions respectively.

	interpolate: 1 if interpolation should be used when decoding
	this image, 0 otherwise.

	imagemask: 1 if this is an imagemask (i.e. transparency bitmap
	mask), 0 otherwise.

	decode: NULL, or a pointer to to a decode array. The default
	decode array is [0 1] (repeated n times, for n color components).

	colorkey: NULL, or a pointer to a colorkey array. The default
	colorkey array is [0 255] (repeated n times, for n color
	components).

	buffer: Buffer of compressed data and compression parameters.
	Ownership of this reference is passed in.

	mask: NULL, or another image to use as a mask for this one.
	A new reference is taken to this image. Supplying a masked
	image as a mask to another image is illegal!
*/
FZ_FUNCTION fz_image *new_image_from_compressed_buffer(int w, int h, int bpc, fz_colorspace *colorspace, int xres, int yres, int interpolate, int imagemask, 
		#ifdef SWIG
			float *OUTPUT
		#else
			float *decode
		#endif
		, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *colorkey
		#endif
		, fz_compressed_buffer *buffer, fz_image *mask);

/** Wrapper for `fz_new_image_from_display_list()`. */
/**
	Create a new image from a display list.

	w, h: The conceptual width/height of the image.

	transform: The matrix that needs to be applied to the given
	list to make it render to the unit square.

	list: The display list.
*/
FZ_FUNCTION fz_image *new_image_from_display_list(float w, float h, fz_display_list *list);

/** Wrapper for `fz_new_image_from_file()`. */
/**
	Create a new image from the contents
	of a file, inferring its type from the format of the
	data.
*/
FZ_FUNCTION fz_image *new_image_from_file(const char *path);

/** Wrapper for `fz_new_image_from_pixmap()`. */
/**
	Create an image from the given
	pixmap.

	pixmap: The pixmap to base the image upon. A new reference
	to this is taken.

	mask: NULL, or another image to use as a mask for this one.
	A new reference is taken to this image. Supplying a masked
	image as a mask to another image is illegal!
*/
FZ_FUNCTION fz_image *new_image_from_pixmap(fz_pixmap *pixmap, fz_image *mask);

/** Wrapper for `fz_new_image_from_svg()`. */
/**
	Create a scalable image from an SVG document.
*/
FZ_FUNCTION fz_image *new_image_from_svg(fz_buffer *buf, const char *base_uri, fz_archive *zip);

/** Wrapper for `fz_new_image_from_svg_xml()`. */
/**
	Create a scalable image from an SVG document.
*/
FZ_FUNCTION fz_image *new_image_from_svg_xml(fz_xml_doc *xmldoc, fz_xml *xml, const char *base_uri, fz_archive *zip);

/** Wrapper for `fz_new_image_of_size()`.

This function has out-params. Python/C# wrappers look like:
	`new_image_of_size(int w, int h, int bpc, fz_colorspace *colorspace, int xres, int yres, int interpolate, int imagemask, fz_image *mask, size_t size, fz_image_get_pixmap_fn *get_pixmap, fz_image_get_size_fn *get_size, fz_drop_image_fn *drop)` => `(fz_image *, float decode, int colorkey)`
*/
/**
	Internal function to make a new fz_image structure
	for a derived class.

	w,h: Width and height of the created image.

	bpc: Bits per component.

	colorspace: The colorspace (determines the number of components,
	and any color conversions required while decoding).

	xres, yres: The X and Y resolutions respectively.

	interpolate: 1 if interpolation should be used when decoding
	this image, 0 otherwise.

	imagemask: 1 if this is an imagemask (i.e. transparent), 0
	otherwise.

	decode: NULL, or a pointer to to a decode array. The default
	decode array is [0 1] (repeated n times, for n color components).

	colorkey: NULL, or a pointer to a colorkey array. The default
	colorkey array is [0 255] (repeated n times, for n color
	components).

	mask: NULL, or another image to use as a mask for this one.
	A new reference is taken to this image. Supplying a masked
	image as a mask to another image is illegal!

	size: The size of the required allocated structure (the size of
	the derived structure).

	get: The function to be called to obtain a decoded pixmap.

	get_size: The function to be called to return the storage size
	used by this image.

	drop: The function to be called to dispose of this image once
	the last reference is dropped.

	Returns a pointer to an allocated structure of the required size,
	with the first sizeof(fz_image) bytes initialised as appropriate
	given the supplied parameters, and the other bytes set to zero.
*/
FZ_FUNCTION fz_image *new_image_of_size(int w, int h, int bpc, fz_colorspace *colorspace, int xres, int yres, int interpolate, int imagemask, 
		#ifdef SWIG
			float *OUTPUT
		#else
			float *decode
		#endif
		, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *colorkey
		#endif
		, fz_image *mask, size_t size, fz_image_get_pixmap_fn *get_pixmap, fz_image_get_size_fn *get_size, fz_drop_image_fn *drop);

/** Wrapper for `fz_new_indexed_colorspace()`. */
/**
	Create an indexed colorspace.

	The supplied lookup table is high palette entries long. Each
	entry is n bytes long, where n is given by the number of
	colorants in the base colorspace, one byte per colorant.

	Ownership of lookup is passed it; it will be freed on
	destruction, so must be heap allocated.

	The colorspace will keep an additional reference to the base
	colorspace that will be dropped on destruction.

	The returned reference should be dropped when it is finished
	with.

	Colorspaces are immutable once created.
*/
FZ_FUNCTION fz_colorspace *new_indexed_colorspace(fz_colorspace *base, int high, unsigned char *lookup);

/** Wrapper for `fz_new_layout()`. */
/**
	Create a new layout block, with new allocation pool, zero
	matrices, and initialise linked pointers.
*/
FZ_FUNCTION fz_layout_block *new_layout();

/** Wrapper for `fz_new_link()`. */
/**
	Create a new link record.

	next is set to NULL with the expectation that the caller will
	handle the linked list setup.

	Internal function.
*/
FZ_FUNCTION fz_link *new_link(fz_rect bbox, const char *uri);

/** Wrapper for `fz_new_list_device()`. */
/**
	Create a rendering device for a display list.

	When the device is rendering a page it will populate the
	display list with drawing commands (text, images, etc.). The
	display list can later be reused to render a page many times
	without having to re-interpret the page from the document file
	for each rendering. Once the device is no longer needed, free
	it with fz_drop_device.

	list: A display list that the list device takes a reference to.
*/
FZ_FUNCTION fz_device *new_list_device(fz_display_list *list);

/** Wrapper for `fz_new_log_for_module()`. */
/**
	Internal function to actually do the opening of the logfile.

	Caller should close/drop the output when finished with it.
*/
FZ_FUNCTION fz_output *new_log_for_module(const char *module);

/** Wrapper for `fz_new_mono_pcl_band_writer()`. */
/**
	Create a new band writer, outputing monochrome pcl.
*/
FZ_FUNCTION fz_band_writer *new_mono_pcl_band_writer(fz_output *out, const fz_pcl_options *options);

/** Wrapper for `fz_new_mono_pwg_band_writer()`. */
/**
	Create a new monochrome pwg band writer.
*/
FZ_FUNCTION fz_band_writer *new_mono_pwg_band_writer(fz_output *out, const fz_pwg_options *pwg);

/** Wrapper for `fz_new_ocr_device()`. */
/**
	Create a device to OCR the text on the page.

	Renders the page internally to a bitmap that is then OCRd. Text
	is then forwarded onto the target device.

	target: The target device to receive the OCRd text.

	ctm: The transform to apply to the mediabox to get the size for
	the rendered page image. Also used to calculate the resolution
	for the page image. In general, this will be the same as the CTM
	that you pass to fz_run_page (or fz_run_display_list) to feed
	this device.

	mediabox: The mediabox (in points). Combined with the CTM to get
	the bounds of the pixmap used internally for the rendered page
	image.

	with_list: If with_list is false, then all non-text operations
	are forwarded instantly to the target device. This results in
	the target device seeing all NON-text operations, followed by
	all the text operations (derived from OCR).

	If with_list is true, then all the marking operations are
	collated into a display list which is then replayed to the
	target device at the end.

	language: NULL (for "eng"), or a pointer to a string to describe
	the languages/scripts that should be used for OCR (e.g.
	"eng,ara").

	datadir: NULL (for ""), or a pointer to a path string otherwise
	provided to Tesseract in the TESSDATA_PREFIX environment variable.

	progress: NULL, or function to be called periodically to indicate
	progress. Return 0 to continue, or 1 to cancel. progress_arg is
	returned as the void *. The int is a value between 0 and 100 to
	indicate progress.

	progress_arg: A void * value to be parrotted back to the progress
	function.
*/
FZ_FUNCTION fz_device *new_ocr_device(fz_device *target, fz_matrix ctm, fz_rect mediabox, int with_list, const char *language, const char *datadir, int (*progress)(fz_context *, void *, int ), void *progress_arg);

/** Wrapper for `fz_new_odt_writer()`. */
FZ_FUNCTION fz_document_writer *new_odt_writer(const char *path, const char *options);

/** Wrapper for `fz_new_odt_writer_with_output()`. */
FZ_FUNCTION fz_document_writer *new_odt_writer_with_output(fz_output *out, const char *options);

/** Wrapper for `fz_new_outline()`. */
/**
	Create a new outline entry with zeroed fields for the caller
	to fill in.
*/
FZ_FUNCTION fz_outline *new_outline();

/** Wrapper for `fz_new_outline_iterator()`. */
/**
	Get an iterator for the document outline.

	Should be freed by fz_drop_outline_iterator.
*/
FZ_FUNCTION fz_outline_iterator *new_outline_iterator(fz_document *doc);

/** Wrapper for `fz_new_outline_iterator_of_size()`. */
FZ_FUNCTION fz_outline_iterator *new_outline_iterator_of_size(size_t size, fz_document *doc);

/** Wrapper for `fz_new_output()`. */
/**
	Create a new output object with the given
	internal state and function pointers.

	state: Internal state (opaque to everything but implementation).

	write: Function to output a given buffer.

	close: Cleanup function to destroy state when output closed.
	May permissibly be null.
*/
FZ_FUNCTION fz_output *new_output(int bufsiz, void *state, fz_output_write_fn *write, fz_output_close_fn *close, fz_output_drop_fn *drop);

/** Wrapper for `fz_new_output_with_buffer()`. */
/**
	Open an output stream that appends
	to a buffer.

	buf: The buffer to append to.
*/
FZ_FUNCTION fz_output *new_output_with_buffer(fz_buffer *buf);

/** Wrapper for `fz_new_output_with_path()`. */
/**
	Open an output stream that writes to a
	given path.

	filename: The filename to write to (specified in UTF-8).

	append: non-zero if we should append to the file, rather than
	overwriting it.
*/
FZ_FUNCTION fz_output *new_output_with_path(const char *filename, int append);

/** Wrapper for `fz_new_page_of_size()`. */
/**
	Different document types will be implemented by deriving from
	fz_page. This macro allocates such derived structures, and
	initialises the base sections.
*/
FZ_FUNCTION fz_page *new_page_of_size(int size, fz_document *doc);

/** Wrapper for `fz_new_pam_band_writer()`. */
/**
	Create a band writer targetting pnm (greyscale, rgb or cmyk,
	with or without alpha).
*/
FZ_FUNCTION fz_band_writer *new_pam_band_writer(fz_output *out);

/** Wrapper for `fz_new_pam_pixmap_writer()`. */
FZ_FUNCTION fz_document_writer *new_pam_pixmap_writer(const char *path, const char *options);

/** Wrapper for `fz_new_path()`. */
/**
	Create a new (empty) path structure.
*/
FZ_FUNCTION fz_path *new_path();

/** Wrapper for `fz_new_pbm_band_writer()`. */
/**
	Create a new band writer, targetting pbm.
*/
FZ_FUNCTION fz_band_writer *new_pbm_band_writer(fz_output *out);

/** Wrapper for `fz_new_pbm_pixmap_writer()`. */
FZ_FUNCTION fz_document_writer *new_pbm_pixmap_writer(const char *path, const char *options);

/** Wrapper for `fz_new_pcl_writer()`. */
FZ_FUNCTION fz_document_writer *new_pcl_writer(const char *path, const char *options);

/** Wrapper for `fz_new_pcl_writer_with_output()`. */
FZ_FUNCTION fz_document_writer *new_pcl_writer_with_output(fz_output *out, const char *options);

/** Wrapper for `fz_new_pclm_band_writer()`. */
/**
	Create a new band writer, outputing pclm
*/
FZ_FUNCTION fz_band_writer *new_pclm_band_writer(fz_output *out, const fz_pclm_options *options);

/** Wrapper for `fz_new_pclm_writer()`. */
FZ_FUNCTION fz_document_writer *new_pclm_writer(const char *path, const char *options);

/** Wrapper for `fz_new_pclm_writer_with_output()`. */
FZ_FUNCTION fz_document_writer *new_pclm_writer_with_output(fz_output *out, const char *options);

/** Wrapper for `fz_new_pdf_writer()`. */
/**
	Document writers for various possible output formats.

	All of the "_with_output" variants pass the ownership of out in
	immediately upon calling. The writers are responsible for
	dropping the fz_output when they are finished with it (even
	if they throw an exception during creation).
*/
FZ_FUNCTION fz_document_writer *new_pdf_writer(const char *path, const char *options);

/** Wrapper for `fz_new_pdf_writer_with_output()`. */
FZ_FUNCTION fz_document_writer *new_pdf_writer_with_output(fz_output *out, const char *options);

/** Wrapper for `fz_new_pdfocr_band_writer()`. */
/**
	Create a new band writer, outputing pdfocr.

	Ownership of output stays with the caller, the band writer
	borrows the reference. The caller must keep the output around
	for the duration of the band writer, and then close/drop as
	appropriate.
*/
FZ_FUNCTION fz_band_writer *new_pdfocr_band_writer(fz_output *out, const fz_pdfocr_options *options);

/** Wrapper for `fz_new_pdfocr_writer()`. */
FZ_FUNCTION fz_document_writer *new_pdfocr_writer(const char *path, const char *options);

/** Wrapper for `fz_new_pdfocr_writer_with_output()`. */
FZ_FUNCTION fz_document_writer *new_pdfocr_writer_with_output(fz_output *out, const char *options);

/** Wrapper for `fz_new_pgm_pixmap_writer()`. */
FZ_FUNCTION fz_document_writer *new_pgm_pixmap_writer(const char *path, const char *options);

/** Wrapper for `fz_new_pixmap()`. */
/**
	Create a new pixmap, with its origin at (0,0)

	cs: The colorspace to use for the pixmap, or NULL for an alpha
	plane/mask.

	w: The width of the pixmap (in pixels)

	h: The height of the pixmap (in pixels)

	seps: Details of separations.

	alpha: 0 for no alpha, 1 for alpha.

	Returns a pointer to the new pixmap. Throws exception on failure
	to allocate.
*/
FZ_FUNCTION fz_pixmap *new_pixmap(fz_colorspace *cs, int w, int h, fz_separations *seps, int alpha);

/** Wrapper for `fz_new_pixmap_from_alpha_channel()`. */
FZ_FUNCTION fz_pixmap *new_pixmap_from_alpha_channel(fz_pixmap *src);

/** Wrapper for `fz_new_pixmap_from_color_and_mask()`. */
FZ_FUNCTION fz_pixmap *new_pixmap_from_color_and_mask(fz_pixmap *color, fz_pixmap *mask);

/** Wrapper for `fz_new_pixmap_from_display_list()`. */
/**
	Render the page to a pixmap using the transform and colorspace.

	Ownership of the pixmap is returned to the caller.
*/
FZ_FUNCTION fz_pixmap *new_pixmap_from_display_list(fz_display_list *list, fz_matrix ctm, fz_colorspace *cs, int alpha);

/** Wrapper for `fz_new_pixmap_from_display_list_with_separations()`. */
/**
	Render the page contents with control over spot colors.

	Ownership of the pixmap is returned to the caller.
*/
FZ_FUNCTION fz_pixmap *new_pixmap_from_display_list_with_separations(fz_display_list *list, fz_matrix ctm, fz_colorspace *cs, fz_separations *seps, int alpha);

/** Wrapper for `fz_new_pixmap_from_page()`. */
FZ_FUNCTION fz_pixmap *new_pixmap_from_page(fz_page *page, fz_matrix ctm, fz_colorspace *cs, int alpha);

/** Wrapper for `fz_new_pixmap_from_page_contents()`. */
/**
	Render the page contents without annotations.

	Ownership of the pixmap is returned to the caller.
*/
FZ_FUNCTION fz_pixmap *new_pixmap_from_page_contents(fz_page *page, fz_matrix ctm, fz_colorspace *cs, int alpha);

/** Wrapper for `fz_new_pixmap_from_page_contents_with_separations()`. */
FZ_FUNCTION fz_pixmap *new_pixmap_from_page_contents_with_separations(fz_page *page, fz_matrix ctm, fz_colorspace *cs, fz_separations *seps, int alpha);

/** Wrapper for `fz_new_pixmap_from_page_number()`. */
FZ_FUNCTION fz_pixmap *new_pixmap_from_page_number(fz_document *doc, int number, fz_matrix ctm, fz_colorspace *cs, int alpha);

/** Wrapper for `fz_new_pixmap_from_page_number_with_separations()`. */
FZ_FUNCTION fz_pixmap *new_pixmap_from_page_number_with_separations(fz_document *doc, int number, fz_matrix ctm, fz_colorspace *cs, fz_separations *seps, int alpha);

/** Wrapper for `fz_new_pixmap_from_page_with_separations()`. */
FZ_FUNCTION fz_pixmap *new_pixmap_from_page_with_separations(fz_page *page, fz_matrix ctm, fz_colorspace *cs, fz_separations *seps, int alpha);

/** Wrapper for `fz_new_pixmap_from_pixmap()`. */
/**
	Create a new pixmap that represents a subarea of the specified
	pixmap. A reference is taken to this pixmap that will be dropped
	on destruction.

	The supplied rectangle must be wholly contained within the
	original pixmap.

	Returns a pointer to the new pixmap. Throws exception on failure
	to allocate.
*/
FZ_FUNCTION fz_pixmap *new_pixmap_from_pixmap(fz_pixmap *pixmap, const fz_irect *rect);

/** Wrapper for `fz_new_pixmap_with_bbox()`. */
/**
	Create a pixmap of a given size, location and pixel format.

	The bounding box specifies the size of the created pixmap and
	where it will be located. The colorspace determines the number
	of components per pixel. Alpha is always present. Pixmaps are
	reference counted, so drop references using fz_drop_pixmap.

	colorspace: Colorspace format used for the created pixmap. The
	pixmap will keep a reference to the colorspace.

	bbox: Bounding box specifying location/size of created pixmap.

	seps: Details of separations.

	alpha: 0 for no alpha, 1 for alpha.

	Returns a pointer to the new pixmap. Throws exception on failure
	to allocate.
*/
FZ_FUNCTION fz_pixmap *new_pixmap_with_bbox(fz_colorspace *colorspace, fz_irect bbox, fz_separations *seps, int alpha);

/** Wrapper for `fz_new_pixmap_with_bbox_and_data()`. */
/**
	Create a pixmap of a given size, location and pixel format,
	using the supplied data block.

	The bounding box specifies the size of the created pixmap and
	where it will be located. The colorspace determines the number
	of components per pixel. Alpha is always present. Pixmaps are
	reference counted, so drop references using fz_drop_pixmap.

	colorspace: Colorspace format used for the created pixmap. The
	pixmap will keep a reference to the colorspace.

	rect: Bounding box specifying location/size of created pixmap.

	seps: Details of separations.

	alpha: Number of alpha planes (0 or 1).

	samples: The data block to keep the samples in.

	Returns a pointer to the new pixmap. Throws exception on failure
	to allocate.
*/
FZ_FUNCTION fz_pixmap *new_pixmap_with_bbox_and_data(fz_colorspace *colorspace, fz_irect rect, fz_separations *seps, int alpha, unsigned char *samples);

/** Wrapper for `fz_new_pixmap_with_data()`. */
/**
	Create a new pixmap, with its origin at
	(0,0) using the supplied data block.

	cs: The colorspace to use for the pixmap, or NULL for an alpha
	plane/mask.

	w: The width of the pixmap (in pixels)

	h: The height of the pixmap (in pixels)

	seps: Details of separations.

	alpha: 0 for no alpha, 1 for alpha.

	stride: The byte offset from the pixel data in a row to the
	pixel data in the next row.

	samples: The data block to keep the samples in.

	Returns a pointer to the new pixmap. Throws exception on failure to
	allocate.
*/
FZ_FUNCTION fz_pixmap *new_pixmap_with_data(fz_colorspace *colorspace, int w, int h, fz_separations *seps, int alpha, int stride, unsigned char *samples);

/** Wrapper for `fz_new_pixmap_writer()`. */
FZ_FUNCTION fz_document_writer *new_pixmap_writer(const char *path, const char *options, const char *default_path, int n, void (*save)(fz_context *, fz_pixmap *, const char *));

/** Wrapper for `fz_new_pkm_band_writer()`. */
/**
	Create a new pkm band writer for CMYK pixmaps.
*/
FZ_FUNCTION fz_band_writer *new_pkm_band_writer(fz_output *out);

/** Wrapper for `fz_new_pkm_pixmap_writer()`. */
FZ_FUNCTION fz_document_writer *new_pkm_pixmap_writer(const char *path, const char *options);

/** Wrapper for `fz_new_png_band_writer()`. */
/**
	Create a new png band writer (greyscale or RGB, with or without
	alpha).
*/
FZ_FUNCTION fz_band_writer *new_png_band_writer(fz_output *out);

/** Wrapper for `fz_new_png_pixmap_writer()`. */
FZ_FUNCTION fz_document_writer *new_png_pixmap_writer(const char *path, const char *options);

/** Wrapper for `fz_new_pnm_band_writer()`. */
/**
	Create a band writer targetting pnm (greyscale or rgb, no
	alpha).
*/
FZ_FUNCTION fz_band_writer *new_pnm_band_writer(fz_output *out);

/** Wrapper for `fz_new_pnm_pixmap_writer()`. */
FZ_FUNCTION fz_document_writer *new_pnm_pixmap_writer(const char *path, const char *options);

/** Wrapper for `fz_new_pool()`. */
/**
	Create a new pool to allocate from.
*/
FZ_FUNCTION fz_pool *new_pool();

/** Wrapper for `fz_new_ppm_pixmap_writer()`. */
FZ_FUNCTION fz_document_writer *new_ppm_pixmap_writer(const char *path, const char *options);

/** Wrapper for `fz_new_ps_band_writer()`. */
/**
	Create a postscript band writer for gray, rgb, or cmyk, no
	alpha.
*/
FZ_FUNCTION fz_band_writer *new_ps_band_writer(fz_output *out);

/** Wrapper for `fz_new_ps_writer()`. */
FZ_FUNCTION fz_document_writer *new_ps_writer(const char *path, const char *options);

/** Wrapper for `fz_new_ps_writer_with_output()`. */
FZ_FUNCTION fz_document_writer *new_ps_writer_with_output(fz_output *out, const char *options);

/** Wrapper for `fz_new_psd_band_writer()`. */
/**
	Open a PSD band writer.
*/
FZ_FUNCTION fz_band_writer *new_psd_band_writer(fz_output *out);

/** Wrapper for `fz_new_pwg_band_writer()`. */
/**
	Create a new color pwg band writer.
*/
FZ_FUNCTION fz_band_writer *new_pwg_band_writer(fz_output *out, const fz_pwg_options *pwg);

/** Wrapper for `fz_new_pwg_writer()`. */
FZ_FUNCTION fz_document_writer *new_pwg_writer(const char *path, const char *options);

/** Wrapper for `fz_new_pwg_writer_with_output()`. */
FZ_FUNCTION fz_document_writer *new_pwg_writer_with_output(fz_output *out, const char *options);

/** Wrapper for `fz_new_rle_output()`. */
FZ_FUNCTION fz_output *new_rle_output(fz_output *chain);

/** Wrapper for `fz_new_separations()`. */
/**
	Create a new separations structure (initially empty)
*/
FZ_FUNCTION fz_separations *new_separations(int controllable);

/** Wrapper for `fz_new_stext_device()`. */
/**
	Create a device to extract the text on a page.

	Gather the text on a page into blocks and lines.

	The reading order is taken from the order the text is drawn in
	the source file, so may not be accurate.

	page: The text page to which content should be added. This will
	usually be a newly created (empty) text page, but it can be one
	containing data already (for example when merging multiple
	pages, or watermarking).

	options: Options to configure the stext device.
*/
FZ_FUNCTION fz_device *new_stext_device(fz_stext_page *page, const fz_stext_options *options);

/** Wrapper for `fz_new_stext_page()`. */
/**
	Create an empty text page.

	The text page is filled out by the text device to contain the
	blocks and lines of text on the page.

	mediabox: optional mediabox information.
*/
FZ_FUNCTION fz_stext_page *new_stext_page(fz_rect mediabox);

/** Wrapper for `fz_new_stext_page_from_chapter_page_number()`. */
FZ_FUNCTION fz_stext_page *new_stext_page_from_chapter_page_number(fz_document *doc, int chapter, int number, const fz_stext_options *options);

/** Wrapper for `fz_new_stext_page_from_display_list()`. */
FZ_FUNCTION fz_stext_page *new_stext_page_from_display_list(fz_display_list *list, const fz_stext_options *options);

/** Wrapper for `fz_new_stext_page_from_page()`. */
/**
	Extract text from page.

	Ownership of the fz_stext_page is returned to the caller.
*/
FZ_FUNCTION fz_stext_page *new_stext_page_from_page(fz_page *page, const fz_stext_options *options);

/** Wrapper for `fz_new_stext_page_from_page_number()`. */
FZ_FUNCTION fz_stext_page *new_stext_page_from_page_number(fz_document *doc, int number, const fz_stext_options *options);

/** Wrapper for `fz_new_store_context()`. */
/**
	Create a new store inside the context

	max: The maximum size (in bytes) that the store is allowed to
	grow to. FZ_STORE_UNLIMITED means no limit.
*/
FZ_FUNCTION void new_store_context(size_t max);

/** Wrapper for `fz_new_stream()`. */
/**
	Create a new stream object with the given
	internal state and function pointers.

	state: Internal state (opaque to everything but implementation).

	next: Should provide the next set of bytes (up to max) of stream
	data. Return the number of bytes read, or EOF when there is no
	more data.

	drop: Should clean up and free the internal state. May not
	throw exceptions.
*/
FZ_FUNCTION fz_stream *new_stream(void *state, fz_stream_next_fn *next, fz_stream_drop_fn *drop);

/** Wrapper for `fz_new_stroke_state()`. */
/**
	Create a new (empty) stroke state structure (with no dash
	data) and return a reference to it.

	Throws exception on failure to allocate.
*/
FZ_FUNCTION fz_stroke_state *new_stroke_state();

/** Wrapper for `fz_new_stroke_state_with_dash_len()`. */
/**
	Create a new (empty) stroke state structure, with room for
	dash data of the given length, and return a reference to it.

	len: The number of dash elements to allow room for.

	Throws exception on failure to allocate.
*/
FZ_FUNCTION fz_stroke_state *new_stroke_state_with_dash_len(int len);

/** Wrapper for `fz_new_svg_device()`. */
/**
	Create a device that outputs (single page) SVG files to
	the given output stream.

	Equivalent to fz_new_svg_device_with_id passing id = NULL.
*/
FZ_FUNCTION fz_device *new_svg_device(fz_output *out, float page_width, float page_height, int text_format, int reuse_images);

/** Wrapper for `fz_new_svg_device_with_id()`.

This function has out-params. Python/C# wrappers look like:
	`new_svg_device_with_id(fz_output *out, float page_width, float page_height, int text_format, int reuse_images)` => `(fz_device *, int id)`
*/
/**
	Create a device that outputs (single page) SVG files to
	the given output stream.

	output: The output stream to send the constructed SVG page to.

	page_width, page_height: The page dimensions to use (in points).

	text_format: How to emit text. One of the following values:
		FZ_SVG_TEXT_AS_TEXT: As <text> elements with possible
		layout errors and mismatching fonts.
		FZ_SVG_TEXT_AS_PATH: As <path> elements with exact
		visual appearance.

	reuse_images: Share image resources using <symbol> definitions.

	id: ID parameter to keep generated IDs unique across SVG files.
*/
FZ_FUNCTION fz_device *new_svg_device_with_id(fz_output *out, float page_width, float page_height, int text_format, int reuse_images, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *id
		#endif
		);

/** Wrapper for `fz_new_svg_writer()`. */
FZ_FUNCTION fz_document_writer *new_svg_writer(const char *path, const char *options);

/** Wrapper for `fz_new_test_device()`.

This function has out-params. Python/C# wrappers look like:
	`new_test_device(float threshold, int options, fz_device *passthrough)` => `(fz_device *, int is_color)`
*/
/**
	Create a device to test for features.

	Currently only tests for the presence of non-grayscale colors.

	is_color: Possible values returned:
		0: Definitely greyscale
		1: Probably color (all colors were grey, but there
		were images or shadings in a non grey colorspace).
		2: Definitely color

	threshold: The difference from grayscale that will be tolerated.
	Typical values to use are either 0 (be exact) and 0.02 (allow an
	imperceptible amount of slop).

	options: A set of bitfield options, from the FZ_TEST_OPT set.

	passthrough: A device to pass all calls through to, or NULL.
	If set, then the test device can both test and pass through to
	an underlying device (like, say, the display list device). This
	means that a display list can be created and at the end we'll
	know if it's colored or not.

	In the absence of a passthrough device, the device will throw
	an exception to stop page interpretation when color is found.
*/
FZ_FUNCTION fz_device *new_test_device(
		#ifdef SWIG
			int *OUTPUT
		#else
			int *is_color
		#endif
		, float threshold, int options, fz_device *passthrough);

/** Wrapper for `fz_new_text()`. */
/**
	Create a new empty fz_text object.

	Throws exception on failure to allocate.
*/
FZ_FUNCTION fz_text *new_text();

/** Wrapper for `fz_new_text_writer()`. */
FZ_FUNCTION fz_document_writer *new_text_writer(const char *format, const char *path, const char *options);

/** Wrapper for `fz_new_text_writer_with_output()`. */
FZ_FUNCTION fz_document_writer *new_text_writer_with_output(const char *format, fz_output *out, const char *options);

/** Wrapper for `fz_new_trace_device()`. */
/**
	Create a device to print a debug trace of all device calls.
*/
FZ_FUNCTION fz_device *new_trace_device(fz_output *out);

/** Wrapper for `fz_new_type3_font()`. */
/**
	Create a new (empty) type3 font.

	name: Name of font (or NULL).

	matrix: Font matrix.

	Returns a new font handle, or throws exception on
	allocation failure.
*/
FZ_FUNCTION fz_font *new_type3_font(const char *name, fz_matrix matrix);

/** Wrapper for `fz_new_xhtml_document_from_document()`. */
/**
	Use text extraction to convert the input document into XHTML,
	then open the result as a new document that can be reflowed.
*/
FZ_FUNCTION fz_document *new_xhtml_document_from_document(fz_document *old_doc, const fz_stext_options *opts);

/** Wrapper for `fz_new_xmltext_device()`. */
/**
	Create a device to output raw information.
*/
FZ_FUNCTION fz_device *new_xmltext_device(fz_output *out);

/** Wrapper for `fz_new_zip_writer()`. */
/**
	Create a new zip writer that writes to a given file.

	Open an archive using a seekable stream object rather than
	opening a file or directory on disk.
*/
FZ_FUNCTION fz_zip_writer *new_zip_writer(const char *filename);

/** Wrapper for `fz_new_zip_writer_with_output()`. */
/**
	Create a new zip writer that writes to a given output stream.

	Ownership of out passes in immediately upon calling this function.
	The caller should never drop the fz_output, even if this function throws
	an exception.
*/
FZ_FUNCTION fz_zip_writer *new_zip_writer_with_output(fz_output *out);

/** Wrapper for `fz_next_page()`. */
/**
	Function to get the location of the next page (allowing for the
	end of chapters etc). If at the end of the document, returns the
	current location.
*/
FZ_FUNCTION fz_location next_page(fz_document *doc, fz_location loc);

/** Wrapper for `fz_normalize_vector()`. */
/**
	Normalize a vector to length one.
*/
FZ_FUNCTION fz_point normalize_vector(fz_point p);

/** Wrapper for `fz_open_a85d()`. */
/**
	a85d filter performs ASCII 85 Decoding of data read
	from the chained filter.
*/
FZ_FUNCTION fz_stream *open_a85d(fz_stream *chain);

/** Wrapper for `fz_open_accelerated_document()`. */
/**
	Open a document file and read its basic structure so pages and
	objects can be located. MuPDF will try to repair broken
	documents (without actually changing the file contents).

	The returned fz_document is used when calling most other
	document related functions.

	filename: a path to a file as it would be given to open(2).
*/
FZ_FUNCTION fz_document *open_accelerated_document(const char *filename, const char *accel);

/** Wrapper for `fz_open_accelerated_document_with_stream()`. */
/**
	Open a document using the specified stream object rather than
	opening a file on disk.

	magic: a string used to detect document type; either a file name
	or mime-type.
*/
FZ_FUNCTION fz_document *open_accelerated_document_with_stream(const char *magic, fz_stream *stream, fz_stream *accel);

/** Wrapper for `fz_open_aesd()`. */
/**
	aesd filter performs AES decoding of data read from the chained
	filter using the supplied key.
*/
FZ_FUNCTION fz_stream *open_aesd(fz_stream *chain, unsigned char *key, unsigned int keylen);

/** Wrapper for `fz_open_ahxd()`. */
/**
	ahxd filter performs ASCII Hex decoding of data read
	from the chained filter.
*/
FZ_FUNCTION fz_stream *open_ahxd(fz_stream *chain);

/** Wrapper for `fz_open_arc4()`. */
/**
	arc4 filter performs RC4 decoding of data read from the chained
	filter using the supplied key.
*/
FZ_FUNCTION fz_stream *open_arc4(fz_stream *chain, unsigned char *key, unsigned int keylen);

/** Wrapper for `fz_open_archive()`. */
/**
	Open a zip or tar archive

	Open a file and identify its archive type based on the archive
	signature contained inside.

	filename: a path to a file as it would be given to open(2).
*/
FZ_FUNCTION fz_archive *open_archive(const char *filename);

/** Wrapper for `fz_open_archive_entry()`. */
/**
	Opens an archive entry as a stream.

	name: Entry name to look for, this must be an exact match to
	the entry name in the archive.
*/
FZ_FUNCTION fz_stream *open_archive_entry(fz_archive *arch, const char *name);

/** Wrapper for `fz_open_archive_with_stream()`. */
/**
	Open zip or tar archive stream.

	Open an archive using a seekable stream object rather than
	opening a file or directory on disk.
*/
FZ_FUNCTION fz_archive *open_archive_with_stream(fz_stream *file);

/** Wrapper for `fz_open_buffer()`. */
/**
	Open a buffer as a stream.

	buf: The buffer to open. Ownership of the buffer is NOT passed
	in (this function takes its own reference).

	Returns pointer to newly created stream. May throw exceptions on
	failure to allocate.
*/
FZ_FUNCTION fz_stream *open_buffer(fz_buffer *buf);

/** Wrapper for `fz_open_compressed_buffer()`. */
/**
	Open a stream to read the decompressed version of a buffer.
*/
FZ_FUNCTION fz_stream *open_compressed_buffer(fz_compressed_buffer *arg_1);

/** Wrapper for `fz_open_concat()`. */
/**
	Concat filter concatenates several streams into one.
*/
FZ_FUNCTION fz_stream *open_concat(int max, int pad);

/** Wrapper for `fz_open_dctd()`. */
/**
	dctd filter performs DCT (JPEG) decoding of data read
	from the chained filter.

	color_transform implements the PDF color_transform option;
	use -1 (unset) as a default.

	For subsampling on decode, set l2factor to the log2 of the
	reduction required (therefore 0 = full size decode).

	jpegtables is an optional stream from which the JPEG tables
	can be read. Use NULL if not required.
*/
FZ_FUNCTION fz_stream *open_dctd(fz_stream *chain, int color_transform, int l2factor, fz_stream *jpegtables);

/** Wrapper for `fz_open_directory()`. */
/**
	Open a directory as if it was an archive.

	A special case where a directory is opened as if it was an
	archive.

	Note that for directories it is not possible to retrieve the
	number of entries or list the entries. It is however possible
	to check if the archive has a particular entry.

	path: a path to a directory as it would be given to opendir(3).
*/
FZ_FUNCTION fz_archive *open_directory(const char *path);

/** Wrapper for `fz_open_document()`. */
/**
	Open a document file and read its basic structure so pages and
	objects can be located. MuPDF will try to repair broken
	documents (without actually changing the file contents).

	The returned fz_document is used when calling most other
	document related functions.

	filename: a path to a file as it would be given to open(2).
*/
FZ_FUNCTION fz_document *open_document(const char *filename);

/** Wrapper for `fz_open_document_with_stream()`. */
/**
	Open a document using the specified stream object rather than
	opening a file on disk.

	magic: a string used to detect document type; either a file name
	or mime-type.
*/
FZ_FUNCTION fz_document *open_document_with_stream(const char *magic, fz_stream *stream);

/** Wrapper for `fz_open_endstream_filter()`. */
/**
	The endstream filter reads a PDF substream, and starts to look
	for an 'endstream' token after the specified length.
*/
FZ_FUNCTION fz_stream *open_endstream_filter(fz_stream *chain, uint64_t len, int64_t offset);

/** Wrapper for `fz_open_faxd()`. */
/**
	faxd filter performs FAX decoding of data read from
	the chained filter.

	k: see fax specification (fax default is 0).

	end_of_line: whether we expect end of line markers (fax default
	is 0).

	encoded_byte_align: whether we align to bytes after each line
	(fax default is 0).

	columns: how many columns in the image (fax default is 1728).

	rows: 0 for unspecified or the number of rows of data to expect.

	end_of_block: whether we expect end of block markers (fax
	default is 1).

	black_is_1: determines the polarity of the image (fax default is
	0).
*/
FZ_FUNCTION fz_stream *open_faxd(fz_stream *chain, int k, int end_of_line, int encoded_byte_align, int columns, int rows, int end_of_block, int black_is_1);

/** Wrapper for `fz_open_file()`. */
/**
	Open the named file and wrap it in a stream.

	filename: Path to a file. On non-Windows machines the filename
	should be exactly as it would be passed to fopen(2). On Windows
	machines, the path should be UTF-8 encoded so that non-ASCII
	characters can be represented. Other platforms do the encoding
	as standard anyway (and in most cases, particularly for MacOS
	and Linux, the encoding they use is UTF-8 anyway).
*/
FZ_FUNCTION fz_stream *open_file(const char *filename);

/** Wrapper for `fz_open_file_ptr_no_close()`. */
/**
	Create a stream from a FILE * that will not be closed
	when the stream is dropped.
*/
FZ_FUNCTION fz_stream *open_file_ptr_no_close(FILE *file);

/** Wrapper for `fz_open_flated()`. */
/**
	flated filter performs LZ77 decoding (inflating) of data read
	from the chained filter.

	window_bits: How large a decompression window to use. Typically
	15. A negative number, -n, means to use n bits, but to expect
	raw data with no header.
*/
FZ_FUNCTION fz_stream *open_flated(fz_stream *chain, int window_bits);

/** Wrapper for `fz_open_image_decomp_stream()`.

This function has out-params. Python/C# wrappers look like:
	`open_image_decomp_stream(fz_stream *arg_0, fz_compression_params *arg_1)` => `(fz_stream *, int l2factor)`
*/
/**
	Open a stream to read the decompressed version of another stream
	with optional log2 subsampling.
*/
FZ_FUNCTION fz_stream *open_image_decomp_stream(fz_stream *arg_1, fz_compression_params *arg_2, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *l2factor
		#endif
		);

/** Wrapper for `fz_open_image_decomp_stream_from_buffer()`.

This function has out-params. Python/C# wrappers look like:
	`open_image_decomp_stream_from_buffer(fz_compressed_buffer *arg_0)` => `(fz_stream *, int l2factor)`
*/
/**
	Open a stream to read the decompressed version of a buffer,
	with optional log2 subsampling.

	l2factor = NULL for no subsampling, or a pointer to an integer
	containing the maximum log2 subsample factor acceptable (0 =
	none, 1 = halve dimensions, 2 = quarter dimensions etc). If
	non-NULL, then *l2factor will be updated on exit with the actual
	log2 subsample factor achieved.
*/
FZ_FUNCTION fz_stream *open_image_decomp_stream_from_buffer(fz_compressed_buffer *arg_1, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *l2factor
		#endif
		);

/** Wrapper for `fz_open_jbig2d()`. */
/**
	Open a filter that performs jbig2 decompression on the chained
	stream, using the optional globals record.
*/
FZ_FUNCTION fz_stream *open_jbig2d(fz_stream *chain, fz_jbig2_globals *globals, int embedded);

/** Wrapper for `fz_open_leecher()`. */
/**
	Attach a filter to a stream that will store any
	characters read from the stream into the supplied buffer.

	chain: The underlying stream to leech from.

	buf: The buffer into which the read data should be appended.
	The buffer will be resized as required.

	Returns pointer to newly created stream. May throw exceptions on
	failure to allocate.
*/
FZ_FUNCTION fz_stream *open_leecher(fz_stream *chain, fz_buffer *buf);

/** Wrapper for `fz_open_lzwd()`. */
/**
	lzwd filter performs LZW decoding of data read from the chained
	filter.

	early_change: (Default 1) specifies whether to change codes 1
	bit early.

	min_bits: (Default 9) specifies the minimum number of bits to
	use.

	reverse_bits: (Default 0) allows for compatibility with gif and
	old style tiffs (1).

	old_tiff: (Default 0) allows for different handling of the clear
	code, as found in old style tiffs.
*/
FZ_FUNCTION fz_stream *open_lzwd(fz_stream *chain, int early_change, int min_bits, int reverse_bits, int old_tiff);

/** Wrapper for `fz_open_memory()`. */
/**
	Open a block of memory as a stream.

	data: Pointer to start of data block. Ownership of the data
	block is NOT passed in.

	len: Number of bytes in data block.

	Returns pointer to newly created stream. May throw exceptions on
	failure to allocate.
*/
FZ_FUNCTION fz_stream *open_memory(const unsigned char *data, size_t len);

/** Wrapper for `fz_open_null_filter()`. */
/**
	The null filter reads a specified amount of data from the
	substream.
*/
FZ_FUNCTION fz_stream *open_null_filter(fz_stream *chain, uint64_t len, int64_t offset);

/** Wrapper for `fz_open_predict()`. */
/**
	predict filter performs pixel prediction on data read from
	the chained filter.

	predictor: 1 = copy, 2 = tiff, other = inline PNG predictor

	columns: width of image in pixels

	colors: number of components.

	bpc: bits per component (typically 8)
*/
FZ_FUNCTION fz_stream *open_predict(fz_stream *chain, int predictor, int columns, int colors, int bpc);

/** Wrapper for `fz_open_range_filter()`. */
/**
	The range filter copies data from specified ranges of the
	chained stream.
*/
FZ_FUNCTION fz_stream *open_range_filter(fz_stream *chain, fz_range *ranges, int nranges);

/** Wrapper for `fz_open_reflowed_document()`. */
FZ_FUNCTION fz_document *open_reflowed_document(fz_document *underdoc, const fz_stext_options *opts);

/** Wrapper for `fz_open_rld()`. */
/**
	rld filter performs Run Length Decoding of data read
	from the chained filter.
*/
FZ_FUNCTION fz_stream *open_rld(fz_stream *chain);

/** Wrapper for `fz_open_sgilog16()`. */
/**
	SGI Log 16bit (greyscale) decode from the chained filter.
	Decodes lines of w pixels to 8bpp greyscale.
*/
FZ_FUNCTION fz_stream *open_sgilog16(fz_stream *chain, int w);

/** Wrapper for `fz_open_sgilog24()`. */
/**
	SGI Log 24bit (LUV) decode from the chained filter.
	Decodes lines of w pixels to 8bpc rgb.
*/
FZ_FUNCTION fz_stream *open_sgilog24(fz_stream *chain, int w);

/** Wrapper for `fz_open_sgilog32()`. */
/**
	SGI Log 32bit (LUV) decode from the chained filter.
	Decodes lines of w pixels to 8bpc rgb.
*/
FZ_FUNCTION fz_stream *open_sgilog32(fz_stream *chain, int w);

/** Wrapper for `fz_open_tar_archive()`. */
/**
	Open a tar archive file.

	An exception is throw if the file is not a tar archive as
	indicated by the presence of a tar signature.

	filename: a path to a tar archive file as it would be given to
	open(2).
*/
FZ_FUNCTION fz_archive *open_tar_archive(const char *filename);

/** Wrapper for `fz_open_tar_archive_with_stream()`. */
/**
	Open a tar archive stream.

	Open an archive using a seekable stream object rather than
	opening a file or directory on disk.

	An exception is throw if the stream is not a tar archive as
	indicated by the presence of a tar signature.

*/
FZ_FUNCTION fz_archive *open_tar_archive_with_stream(fz_stream *file);

/** Wrapper for `fz_open_thunder()`. */
/**
	4bit greyscale Thunderscan decoding from the chained filter.
	Decodes lines of w pixels to 8bpp greyscale.
*/
FZ_FUNCTION fz_stream *open_thunder(fz_stream *chain, int w);

/** Wrapper for `fz_open_zip_archive()`. */
/**
	Open a zip archive file.

	An exception is throw if the file is not a zip archive as
	indicated by the presence of a zip signature.

	filename: a path to a zip archive file as it would be given to
	open(2).
*/
FZ_FUNCTION fz_archive *open_zip_archive(const char *path);

/** Wrapper for `fz_open_zip_archive_with_stream()`. */
/**
	Open a zip archive stream.

	Open an archive using a seekable stream object rather than
	opening a file or directory on disk.

	An exception is throw if the stream is not a zip archive as
	indicated by the presence of a zip signature.

*/
FZ_FUNCTION fz_archive *open_zip_archive_with_stream(fz_stream *file);

/** Wrapper for `fz_option_eq()`. */
/**
	Check to see if an option, a, from a string matches a reference
	option, b.

	(i.e. a could be 'foo' or 'foo,bar...' etc, but b can only be
	'foo'.)
*/
FZ_FUNCTION int option_eq(const char *a, const char *b);

/** Wrapper for `fz_outline_glyph()`. */
/**
	Look a glyph up from a font, and return the outline of the
	glyph using the given transform.

	The caller owns the returned path, and so is responsible for
	ensuring that it eventually gets dropped.
*/
FZ_FUNCTION fz_path *outline_glyph(fz_font *font, int gid, fz_matrix ctm);

/** Wrapper for `fz_outline_iterator_delete()`. */
/**
	Delete the current item.

	This implicitly moves us to the 'next' item, and the return code is as for fz_outline_iterator_next.
*/
FZ_FUNCTION int outline_iterator_delete(fz_outline_iterator *iter);

/** Wrapper for `fz_outline_iterator_down()`. */
FZ_FUNCTION int outline_iterator_down(fz_outline_iterator *iter);

/** Wrapper for `fz_outline_iterator_from_outline()`. */
FZ_FUNCTION fz_outline_iterator *outline_iterator_from_outline(fz_outline *outline);

/** Wrapper for `fz_outline_iterator_insert()`. */
/**
	Call to insert a new item BEFORE the current point.

	Ownership of pointers are retained by the caller. The item data will be copied.

	After an insert, we do not change where we are pointing.
	The return code is the same as for next, it indicates the current iterator position.
*/
FZ_FUNCTION int outline_iterator_insert(fz_outline_iterator *iter, fz_outline_item *item);

/** Wrapper for `fz_outline_iterator_item()`. */
/**
	Call to get the current outline item.

	Can return NULL. The item is only valid until the next call.
*/
FZ_FUNCTION fz_outline_item *outline_iterator_item(fz_outline_iterator *iter);

/** Wrapper for `fz_outline_iterator_next()`. */
/**
	Calls to move the iterator position.

	A negative return value means we could not move as requested. Otherwise:
	0 = the final position has a valid item.
	1 = not a valid item, but we can insert an item here.
*/
FZ_FUNCTION int outline_iterator_next(fz_outline_iterator *iter);

/** Wrapper for `fz_outline_iterator_prev()`. */
FZ_FUNCTION int outline_iterator_prev(fz_outline_iterator *iter);

/** Wrapper for `fz_outline_iterator_up()`. */
FZ_FUNCTION int outline_iterator_up(fz_outline_iterator *iter);

/** Wrapper for `fz_outline_iterator_update()`. */
/**
	Update the current item properties according to the given item.
*/
FZ_FUNCTION void outline_iterator_update(fz_outline_iterator *iter, fz_outline_item *item);

/** Wrapper for `fz_output_accelerator()`. */
/**
	Output accelerator data for the document to a given output
	stream.
*/
FZ_FUNCTION void output_accelerator(fz_document *doc, fz_output *accel);

/** Wrapper for `fz_output_supports_stream()`. */
/**
	Query whether a given fz_output supports fz_stream_from_output.
*/
FZ_FUNCTION int output_supports_stream(fz_output *out);

/** Wrapper for `fz_pack_path()`. */
/**
	Pack a path into the given block.
	To minimise the size of paths, this function allows them to be
	packed into a buffer with other information. Paths can be used
	interchangeably regardless of how they are packed.

	pack: Pointer to a block of data to pack the path into. Should
	be aligned by the caller to the same alignment as required for
	a fz_path pointer.

	max: The number of bytes available in the block.
	If max < sizeof(fz_path) then an exception will
	be thrown. If max >= the value returned by
	fz_packed_path_size, then this call will never
	fail, except in low memory situations with large
	paths.

	path: The path to pack.

	Returns the number of bytes within the block used. Callers can
	access the packed path data by casting the value of pack on
	entry to be a fz_path *.

	Throws exceptions on failure to allocate, or if
	max < sizeof(fz_path).

	Implementation details: Paths can be 'unpacked', 'flat', or
	'open'. Standard paths, as created are 'unpacked'. Paths that
	will pack into less than max bytes will be packed as 'flat',
	unless they are too large (where large indicates that they
	exceed some private implementation defined limits, currently
	including having more than 256 coordinates or commands).

	Large paths are 'open' packed as a header into the given block,
	plus pointers to other data blocks.

	Users should not have to care about whether paths are 'open'
	or 'flat' packed. Simply pack a path (if required), and then
	forget about the details.
*/
FZ_FUNCTION size_t pack_path(uint8_t *pack, size_t max, const fz_path *path);

/** Wrapper for `fz_packed_path_size()`. */
/**
	Return the number of bytes required to pack a path.
*/
FZ_FUNCTION int packed_path_size(const fz_path *path);

/** Wrapper for `fz_page_number_from_location()`. */
/**
	Converts from chapter+page to page number. This may cause many
	chapters to be laid out in order to calculate the number of
	pages within those chapters.
*/
FZ_FUNCTION int page_number_from_location(fz_document *doc, fz_location loc);

/** Wrapper for `fz_page_presentation()`.

This function has out-params. Python/C# wrappers look like:
	`page_presentation(fz_page *page, fz_transition *transition)` => `(fz_transition *, float duration)`
*/
/**
	Get the presentation details for a given page.

	transition: A pointer to a transition struct to fill out.

	duration: A pointer to a place to set the page duration in
	seconds. Will be set to 0 if no transition is specified for the
	page.

	Returns: a pointer to the transition structure, or NULL if there
	is no transition specified for the page.
*/
FZ_FUNCTION fz_transition *page_presentation(fz_page *page, fz_transition *transition, 
		#ifdef SWIG
			float *OUTPUT
		#else
			float *duration
		#endif
		);

/** Wrapper for `fz_page_separations()`. */
/**
	Get the separations details for a page.
	This will be NULL, unless the format specifically supports
	separations (such as PDF files). May be NULL even
	so, if there are no separations on a page.

	Returns a reference that must be dropped.
*/
FZ_FUNCTION fz_separations *page_separations(fz_page *page);

/** Wrapper for `fz_page_uses_overprint()`. */
/**
	Query if a given page requires overprint.
*/
FZ_FUNCTION int page_uses_overprint(fz_page *page);

/** Wrapper for `fz_paint_shade()`.

This function has out-params. Python/C# wrappers look like:
	`paint_shade(fz_shade *shade, fz_colorspace *override_cs, fz_matrix ctm, fz_pixmap *dest, fz_color_params color_params, fz_irect bbox, const fz_overprint *eop, fz_shade_color_cache **cache)` => 
*/
/**
	Render a shade to a given pixmap.

	shade: The shade to paint.

	override_cs: NULL, or colorspace to override the shades
	inbuilt colorspace.

	ctm: The transform to apply.

	dest: The pixmap to render into.

	color_params: The color rendering settings

	bbox: Pointer to a bounding box to limit the rendering
	of the shade.

	eop: NULL, or pointer to overprint bitmap.

	cache: *cache is used to cache color information. If *cache is NULL it
	is set to point to a new fz_shade_color_cache. If cache is NULL it is
	ignored.
*/
FZ_FUNCTION void paint_shade(fz_shade *shade, fz_colorspace *override_cs, fz_matrix ctm, fz_pixmap *dest, fz_color_params color_params, fz_irect bbox, const fz_overprint *eop, 
		#ifdef SWIG
			fz_shade_color_cache **OUTPUT
		#else
			fz_shade_color_cache **cache
		#endif
		);

/** Wrapper for `fz_parse_draw_options()`. */
/**
	Parse draw device options from a comma separated key-value string.
*/
FZ_FUNCTION fz_draw_options *parse_draw_options(fz_draw_options *options, const char *string);

/** Wrapper for `fz_parse_page_range()`.

This function has out-params. Python/C# wrappers look like:
	`parse_page_range(const char *s, int n)` => `(const char *, int a, int b)`
*/
FZ_FUNCTION const char *parse_page_range(const char *s, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *a
		#endif
		, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *b
		#endif
		, int n);

/** Wrapper for `fz_parse_pcl_options()`. */
/**
	Parse PCL options.

	Currently defined options and values are as follows:

		preset=X	Either "generic" or one of the presets as for fz_pcl_preset.
		spacing=0	No vertical spacing capability
		spacing=1	PCL 3 spacing (<ESC>*p+<n>Y)
		spacing=2	PCL 4 spacing (<ESC>*b<n>Y)
		spacing=3	PCL 5 spacing (<ESC>*b<n>Y and clear seed row)
		mode2		Disable/Enable mode 2 graphics compression
		mode3		Disable/Enable mode 3 graphics compression
		eog_reset	End of graphics (<ESC>*rB) resets all parameters
		has_duplex	Duplex supported (<ESC>&l<duplex>S)
		has_papersize	Papersize setting supported (<ESC>&l<sizecode>A)
		has_copies	Number of copies supported (<ESC>&l<copies>X)
		is_ljet4pjl	Disable/Enable HP 4PJL model-specific output
		is_oce9050	Disable/Enable Oce 9050 model-specific output
*/
FZ_FUNCTION fz_pcl_options *parse_pcl_options(fz_pcl_options *opts, const char *args);

/** Wrapper for `fz_parse_pclm_options()`. */
/**
	Parse PCLm options.

	Currently defined options and values are as follows:

		compression=none: No compression
		compression=flate: Flate compression
		strip-height=n: Strip height (default 16)
*/
FZ_FUNCTION fz_pclm_options *parse_pclm_options(fz_pclm_options *opts, const char *args);

/** Wrapper for `fz_parse_pdfocr_options()`. */
/**
	Parse PDFOCR options.

	Currently defined options and values are as follows:

		compression=none: No compression
		compression=flate: Flate compression
		strip-height=n: Strip height (default 16)
		ocr-language=<lang>: OCR Language (default eng)
		ocr-datadir=<datadir>: OCR data path (default rely on TESSDATA_PREFIX)
*/
FZ_FUNCTION fz_pdfocr_options *parse_pdfocr_options(fz_pdfocr_options *opts, const char *args);

/** Wrapper for `fz_parse_stext_options()`. */
/**
	Parse stext device options from a comma separated key-value
	string.
*/
FZ_FUNCTION fz_stext_options *parse_stext_options(fz_stext_options *opts, const char *string);

/** Wrapper for `fz_parse_xml()`. */
/**
	Parse the contents of buffer into a tree of xml nodes.

	preserve_white: whether to keep or delete all-whitespace nodes.
*/
FZ_FUNCTION fz_xml_doc *parse_xml(fz_buffer *buf, int preserve_white);

/** Wrapper for `fz_parse_xml_from_html5()`. */
/**
	Parse the contents of a buffer into a tree of XML nodes,
	using the HTML5 parsing algorithm.
*/
FZ_FUNCTION fz_xml_doc *parse_xml_from_html5(fz_buffer *buf);

/** Wrapper for `fz_pcl_preset()`. */
/**
	Initialize PCL option struct for a given preset.

	Currently defined presets include:

		generic	Generic PCL printer
		ljet4	HP DeskJet
		dj500	HP DeskJet 500
		fs600	Kyocera FS-600
		lj	HP LaserJet, HP LaserJet Plus
		lj2	HP LaserJet IIp, HP LaserJet IId
		lj3	HP LaserJet III
		lj3d	HP LaserJet IIId
		lj4	HP LaserJet 4
		lj4pl	HP LaserJet 4 PL
		lj4d	HP LaserJet 4d
		lp2563b	HP 2563B line printer
		oce9050	Oce 9050 Line printer
*/
FZ_FUNCTION void pcl_preset(fz_pcl_options *opts, const char *preset);

/** Wrapper for `fz_pdfocr_band_writer_set_progress()`. */
/**
	Set the progress callback for a pdfocr bandwriter.
*/
FZ_FUNCTION void pdfocr_band_writer_set_progress(fz_band_writer *writer, fz_pdfocr_progress_fn *progress_fn, void *progress_arg);

/** Wrapper for `fz_pdfocr_writer_set_progress()`. */
FZ_FUNCTION void pdfocr_writer_set_progress(fz_document_writer *writer, fz_pdfocr_progress_fn *progress, void *arg_3);

/** Wrapper for `fz_peek_byte()`. */
/**
	Peek at the next byte in a stream.

	stm: The stream to peek at.

	Returns -1 for EOF, or the next byte that will be read.
*/
FZ_FUNCTION int peek_byte(fz_stream *stm);

/** Wrapper for `fz_pixmap_alpha()`. */
/**
	Return the number of alpha planes in a pixmap.

	Returns the number of alphas. Does not throw exceptions.
*/
FZ_FUNCTION int pixmap_alpha(const fz_pixmap *pix);

/** Wrapper for `fz_pixmap_bbox()`. */
/**
	Return the bounding box for a pixmap.
*/
FZ_FUNCTION fz_irect pixmap_bbox(const fz_pixmap *pix);

/** Wrapper for `fz_pixmap_colorants()`. */
/**
	Return the number of colorants in a pixmap.

	Returns the number of colorants (components, less any spots and
	alpha).
*/
FZ_FUNCTION int pixmap_colorants(const fz_pixmap *pix);

/** Wrapper for `fz_pixmap_colorspace()`. */
/**
	Return the colorspace of a pixmap

	Returns colorspace.
*/
FZ_FUNCTION fz_colorspace *pixmap_colorspace(const fz_pixmap *pix);

/** Wrapper for `fz_pixmap_components()`. */
/**
	Return the number of components in a pixmap.

	Returns the number of components (including spots and alpha).
*/
FZ_FUNCTION int pixmap_components(const fz_pixmap *pix);

/** Wrapper for `fz_pixmap_height()`. */
/**
	Return the height of the pixmap in pixels.
*/
FZ_FUNCTION int pixmap_height(const fz_pixmap *pix);

/** Wrapper for `fz_pixmap_image_tile()`. */
/**
	Retrieve the underlying fz_pixmap for an image.

	Returns a pointer to the underlying fz_pixmap for an image,
	or NULL if this image is not based upon an fz_pixmap.

	No reference is returned. Lifespan is limited to that of
	the image itself. If required, use fz_keep_pixmap to take
	a reference to keep it longer.
*/
FZ_FUNCTION fz_pixmap *pixmap_image_tile(fz_pixmap_image *cimg);

/** Wrapper for `fz_pixmap_samples()`. */
/**
	Returns a pointer to the pixel data of a pixmap.

	Returns the pointer.
*/
FZ_FUNCTION unsigned char *pixmap_samples(const fz_pixmap *pix);

/** Wrapper for `fz_pixmap_spots()`. */
/**
	Return the number of spots in a pixmap.

	Returns the number of spots (components, less colorants and
	alpha). Does not throw exceptions.
*/
FZ_FUNCTION int pixmap_spots(const fz_pixmap *pix);

/** Wrapper for `fz_pixmap_stride()`. */
/**
	Return the number of bytes in a row in the pixmap.
*/
FZ_FUNCTION int pixmap_stride(const fz_pixmap *pix);

/** Wrapper for `fz_pixmap_width()`. */
/**
	Return the width of the pixmap in pixels.
*/
FZ_FUNCTION int pixmap_width(const fz_pixmap *pix);

/** Wrapper for `fz_pixmap_x()`. */
/**
	Return the x value of the pixmap in pixels.
*/
FZ_FUNCTION int pixmap_x(const fz_pixmap *pix);

/** Wrapper for `fz_pixmap_y()`. */
/**
	Return the y value of the pixmap in pixels.
*/
FZ_FUNCTION int pixmap_y(const fz_pixmap *pix);

/** Wrapper for `fz_pool_alloc()`. */
/**
	Allocate a block of size bytes from the pool.
*/
FZ_FUNCTION void *pool_alloc(fz_pool *pool, size_t size);

/** Wrapper for `fz_pool_size()`. */
/**
	The current size of the pool.

	The number of bytes of storage currently allocated to the pool.
	This is the total of the storage used for the blocks making
	up the pool, rather then total of the allocated blocks so far,
	so it will increase in 'lumps'.
	from the pool, then the pool size may still be X
*/
FZ_FUNCTION size_t pool_size(fz_pool *pool);

/** Wrapper for `fz_pool_strdup()`. */
/**
	strdup equivalent allocating from the pool.
*/
FZ_FUNCTION char *pool_strdup(fz_pool *pool, const char *s);

/** Wrapper for `fz_pop_clip()`. */
FZ_FUNCTION void pop_clip(fz_device *dev);

/** Wrapper for `fz_post_scale()`. */
/**
	Scale a matrix by postmultiplication.

	m: Pointer to the matrix to scale

	sx, sy: Scaling factors along the X- and Y-axes. A scaling
	factor of 1.0 will not cause any scaling along the relevant
	axis.

	Returns m (updated).
*/
FZ_FUNCTION fz_matrix post_scale(fz_matrix m, float sx, float sy);

/** Wrapper for `fz_pre_rotate()`. */
/**
	Rotate a transformation by premultiplying.

	The premultiplied matrix is of the form
	[ cos(deg) sin(deg) -sin(deg) cos(deg) 0 0 ].

	m: Pointer to matrix to premultiply.

	degrees: Degrees of counter clockwise rotation. Values less
	than zero and greater than 360 are handled as expected.

	Returns m (updated).
*/
FZ_FUNCTION fz_matrix pre_rotate(fz_matrix m, float degrees);

/** Wrapper for `fz_pre_scale()`. */
/**
	Scale a matrix by premultiplication.

	m: Pointer to the matrix to scale

	sx, sy: Scaling factors along the X- and Y-axes. A scaling
	factor of 1.0 will not cause any scaling along the relevant
	axis.

	Returns m (updated).
*/
FZ_FUNCTION fz_matrix pre_scale(fz_matrix m, float sx, float sy);

/** Wrapper for `fz_pre_shear()`. */
/**
	Premultiply a matrix with a shearing matrix.

	The shearing matrix is of the form [ 1 sy sx 1 0 0 ].

	m: pointer to matrix to premultiply

	sx, sy: Shearing factors. A shearing factor of 0.0 will not
	cause any shearing along the relevant axis.

	Returns m (updated).
*/
FZ_FUNCTION fz_matrix pre_shear(fz_matrix m, float sx, float sy);

/** Wrapper for `fz_pre_translate()`. */
/**
	Translate a matrix by premultiplication.

	m: The matrix to translate

	tx, ty: Translation distances along the X- and Y-axes. A
	translation of 0 will not cause any translation along the
	relevant axis.

	Returns m.
*/
FZ_FUNCTION fz_matrix pre_translate(fz_matrix m, float tx, float ty);

/** Wrapper for `fz_prepare_t3_glyph()`. */
/**
	Force a type3 font to cache the displaylist for a given glyph
	id.

	This caching can involve reading the underlying file, so must
	happen ahead of time, so we aren't suddenly forced to read the
	file while playing a displaylist back.
*/
FZ_FUNCTION void prepare_t3_glyph(fz_font *font, int gid);

/** Wrapper for `fz_previous_page()`. */
/**
	Function to get the location of the previous page (allowing for
	the end of chapters etc). If already at the start of the
	document, returns the current page.
*/
FZ_FUNCTION fz_location previous_page(fz_document *doc, fz_location loc);

/** Wrapper for `fz_print_stext_header_as_html()`. */
FZ_FUNCTION void print_stext_header_as_html(fz_output *out);

/** Wrapper for `fz_print_stext_header_as_xhtml()`. */
FZ_FUNCTION void print_stext_header_as_xhtml(fz_output *out);

/** Wrapper for `fz_print_stext_page_as_html()`. */
/**
	Output structured text to a file in HTML (visual) format.
*/
FZ_FUNCTION void print_stext_page_as_html(fz_output *out, fz_stext_page *page, int id);

/** Wrapper for `fz_print_stext_page_as_json()`. */
/**
	Output structured text to a file in JSON format.
*/
FZ_FUNCTION void print_stext_page_as_json(fz_output *out, fz_stext_page *page, float scale);

/** Wrapper for `fz_print_stext_page_as_text()`. */
/**
	Output structured text to a file in plain-text UTF-8 format.
*/
FZ_FUNCTION void print_stext_page_as_text(fz_output *out, fz_stext_page *page);

/** Wrapper for `fz_print_stext_page_as_xhtml()`. */
/**
	Output structured text to a file in XHTML (semantic) format.
*/
FZ_FUNCTION void print_stext_page_as_xhtml(fz_output *out, fz_stext_page *page, int id);

/** Wrapper for `fz_print_stext_page_as_xml()`. */
/**
	Output structured text to a file in XML format.
*/
FZ_FUNCTION void print_stext_page_as_xml(fz_output *out, fz_stext_page *page, int id);

/** Wrapper for `fz_print_stext_trailer_as_html()`. */
FZ_FUNCTION void print_stext_trailer_as_html(fz_output *out);

/** Wrapper for `fz_print_stext_trailer_as_xhtml()`. */
FZ_FUNCTION void print_stext_trailer_as_xhtml(fz_output *out);

/** Wrapper for `fz_process_opened_pages()`. */
/**
	Iterates over all opened pages of the document, calling the
	provided callback for each page for processing. If the callback
	returns non-NULL then the iteration stops and that value is returned
	to the called of fz_process_opened_pages().

	The state pointer provided to fz_process_opened_pages() is
	passed on to the callback but is owned by the caller.

	Returns the first non-NULL value returned by the callback,
	or NULL if the callback returned NULL for all opened pages.
*/
FZ_FUNCTION void *process_opened_pages(fz_document *doc, fz_process_opened_page_fn *process_openend_page, void *state);

/** Wrapper for `fz_process_shade()`. */
/**
	Process a shade, using supplied callback functions. This
	decomposes the shading to a mesh (even ones that are not
	natively meshes, such as linear or radial shadings), and
	processes triangles from those meshes.

	shade: The shade to process.

	ctm: The transform to use

	prepare: Callback function to 'prepare' each vertex.
	This function is passed an array of floats, and populates
	a fz_vertex structure.

	process: This function is passed 3 pointers to vertex
	structures, and actually performs the processing (typically
	filling the area between the vertexes).

	process_arg: An opaque argument passed through from caller
	to callback functions.
*/
FZ_FUNCTION void process_shade(fz_shade *shade, fz_matrix ctm, fz_rect scissor, fz_shade_prepare_fn *prepare, fz_shade_process_fn *process, void *process_arg);

/** Wrapper for `fz_purge_glyph_cache()`. */
/**
	Purge all the glyphs from the cache.
*/
FZ_FUNCTION void purge_glyph_cache();

/** Wrapper for `fz_quad_from_rect()`. */
/**
	Convert a rect to a quad (losslessly).
*/
FZ_FUNCTION fz_quad quad_from_rect(fz_rect r);

/** Wrapper for `fz_quadto()`. */
/**
	Append a 'quadto' command to an open path. (For a
	quadratic bezier).

	path: The path to modify.

	x0, y0: The control coordinates for the quadratic curve.

	x1, y1: The end coordinates for the quadratic curve.

	Throws exceptions on failure to allocate, or attempting to
	modify a packed path.
*/
FZ_FUNCTION void quadto(fz_path *path, float x0, float y0, float x1, float y1);

/** Wrapper for `fz_read()`. */
/**
	Read from a stream into a given data block.

	stm: The stream to read from.

	data: The data block to read into.

	len: The length of the data block (in bytes).

	Returns the number of bytes read. May throw exceptions.
*/
FZ_FUNCTION size_t read(fz_stream *stm, unsigned char *data, size_t len);

/** Wrapper for `fz_read_all()`. */
/**
	Read all of a stream into a buffer.

	stm: The stream to read from

	initial: Suggested initial size for the buffer.

	Returns a buffer created from reading from the stream. May throw
	exceptions on failure to allocate.
*/
FZ_FUNCTION fz_buffer *read_all(fz_stream *stm, size_t initial);

/** Wrapper for `fz_read_archive_entry()`. */
/**
	Reads all bytes in an archive entry
	into a buffer.

	name: Entry name to look for, this must be an exact match to
	the entry name in the archive.
*/
FZ_FUNCTION fz_buffer *read_archive_entry(fz_archive *arch, const char *name);

/** Wrapper for `fz_read_best()`.

This function has out-params. Python/C# wrappers look like:
	`read_best(fz_stream *stm, size_t initial)` => `(fz_buffer *, int truncated)`
*/
/**
	Attempt to read a stream into a buffer. If truncated
	is NULL behaves as fz_read_all, sets a truncated flag in case of
	error.

	stm: The stream to read from.

	initial: Suggested initial size for the buffer.

	truncated: Flag to store success/failure indication in.

	Returns a buffer created from reading from the stream.
*/
FZ_FUNCTION fz_buffer *read_best(fz_stream *stm, size_t initial, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *truncated
		#endif
		);

/** Wrapper for `fz_read_bits()`. */
/**
	Read the next n bits from a stream (assumed to
	be packed most significant bit first).

	stm: The stream to read from.

	n: The number of bits to read, between 1 and 8*sizeof(int)
	inclusive.

	Returns -1 for EOF, or the required number of bits.
*/
FZ_FUNCTION unsigned int read_bits(fz_stream *stm, int n);

/** Wrapper for `fz_read_byte()`. */
/**
	Read the next byte from a stream.

	stm: The stream t read from.

	Returns -1 for end of stream, or the next byte. May
	throw exceptions.
*/
FZ_FUNCTION int read_byte(fz_stream *stm);

/** Wrapper for `fz_read_file()`. */
/**
	Read all the contents of a file into a buffer.
*/
FZ_FUNCTION fz_buffer *read_file(const char *filename);

/** Wrapper for `fz_read_float()`. */
FZ_FUNCTION float read_float(fz_stream *stm);

/** Wrapper for `fz_read_float_le()`. */
FZ_FUNCTION float read_float_le(fz_stream *stm);

/** Wrapper for `fz_read_int16()`. */
FZ_FUNCTION int16_t read_int16(fz_stream *stm);

/** Wrapper for `fz_read_int16_le()`. */
FZ_FUNCTION int16_t read_int16_le(fz_stream *stm);

/** Wrapper for `fz_read_int32()`. */
FZ_FUNCTION int32_t read_int32(fz_stream *stm);

/** Wrapper for `fz_read_int32_le()`. */
FZ_FUNCTION int32_t read_int32_le(fz_stream *stm);

/** Wrapper for `fz_read_int64()`. */
FZ_FUNCTION int64_t read_int64(fz_stream *stm);

/** Wrapper for `fz_read_int64_le()`. */
FZ_FUNCTION int64_t read_int64_le(fz_stream *stm);

/** Wrapper for `fz_read_line()`. */
/**
	Read a line from stream into the buffer until either a
	terminating newline or EOF, which it replaces with a null byte
	('\0').

	Returns buf on success, and NULL when end of file occurs while
	no characters have been read.
*/
FZ_FUNCTION char *read_line(fz_stream *stm, char *buf, size_t max);

/** Wrapper for `fz_read_rbits()`. */
/**
	Read the next n bits from a stream (assumed to
	be packed least significant bit first).

	stm: The stream to read from.

	n: The number of bits to read, between 1 and 8*sizeof(int)
	inclusive.

	Returns (unsigned int)-1 for EOF, or the required number of bits.
*/
FZ_FUNCTION unsigned int read_rbits(fz_stream *stm, int n);

/** Wrapper for `fz_read_string()`. */
/**
	Read a null terminated string from the stream into
	a buffer of a given length. The buffer will be null terminated.
	Throws on failure (including the failure to fit the entire
	string including the terminator into the buffer).
*/
FZ_FUNCTION void read_string(fz_stream *stm, char *buffer, int len);

/** Wrapper for `fz_read_uint16()`. */
/**
	fz_read_[u]int(16|24|32|64)(_le)?

	Read a 16/32/64 bit signed/unsigned integer from stream,
	in big or little-endian byte orders.

	Throws an exception if EOF is encountered.
*/
FZ_FUNCTION uint16_t read_uint16(fz_stream *stm);

/** Wrapper for `fz_read_uint16_le()`. */
FZ_FUNCTION uint16_t read_uint16_le(fz_stream *stm);

/** Wrapper for `fz_read_uint24()`. */
FZ_FUNCTION uint32_t read_uint24(fz_stream *stm);

/** Wrapper for `fz_read_uint24_le()`. */
FZ_FUNCTION uint32_t read_uint24_le(fz_stream *stm);

/** Wrapper for `fz_read_uint32()`. */
FZ_FUNCTION uint32_t read_uint32(fz_stream *stm);

/** Wrapper for `fz_read_uint32_le()`. */
FZ_FUNCTION uint32_t read_uint32_le(fz_stream *stm);

/** Wrapper for `fz_read_uint64()`. */
FZ_FUNCTION uint64_t read_uint64(fz_stream *stm);

/** Wrapper for `fz_read_uint64_le()`. */
FZ_FUNCTION uint64_t read_uint64_le(fz_stream *stm);

/** Wrapper for `fz_realloc()`. */
/**
	Reallocates a block of memory to given size. Existing contents
	up to min(old_size,new_size) are maintained. The rest of the
	block is uninitialised.

	fz_realloc(ctx, NULL, size) behaves like fz_malloc(ctx, size).

	fz_realloc(ctx, p, 0); behaves like fz_free(ctx, p).

	Throws exception in the event of failure to allocate.
*/
FZ_FUNCTION void *realloc(void *p, size_t size);

/** Wrapper for `fz_realloc_no_throw()`. */
/**
	fz_realloc equivalent that returns NULL rather than throwing
	exceptions.
*/
FZ_FUNCTION void *realloc_no_throw(void *p, size_t size);

/** Wrapper for `fz_realpath()`. */
/**
	Resolve a path to an absolute file name.
	The resolved path buffer must be of at least PATH_MAX size.
*/
FZ_FUNCTION char *realpath(const char *path, char *resolved_path);

/** Wrapper for `fz_recognize_document()`. */
/**
	Given a magic find a document handler that can handle a
	document of this type.

	magic: Can be a filename extension (including initial period) or
	a mimetype.
*/
FZ_FUNCTION const fz_document_handler *recognize_document(const char *magic);

/** Wrapper for `fz_recognize_image_format()`. */
/**
	Recognise image format strings in the first 8 bytes from image
	data.
*/
FZ_FUNCTION int recognize_image_format(unsigned char p[8]);

/** Wrapper for `fz_rect_from_irect()`. */
/**
	Convert a bbox into a rect.

	For our purposes, a rect can represent all the values we meet in
	a bbox, so nothing can go wrong.

	rect: A place to store the generated rectangle.

	bbox: The bbox to convert.

	Returns rect (updated).
*/
FZ_FUNCTION fz_rect rect_from_irect(fz_irect bbox);

/** Wrapper for `fz_rect_from_quad()`. */
/**
	Convert a quad to the smallest rect that covers it.
*/
FZ_FUNCTION fz_rect rect_from_quad(fz_quad q);

/** Wrapper for `fz_rectto()`. */
/**
	Append a 'rectto' command to an open path.

	The rectangle is equivalent to:
		moveto x0 y0
		lineto x1 y0
		lineto x1 y1
		lineto x0 y1
		closepath

	path: The path to modify.

	x0, y0: First corner of the rectangle.

	x1, y1: Second corner of the rectangle.

	Throws exceptions on failure to allocate, or attempting to
	modify a packed path.
*/
FZ_FUNCTION void rectto(fz_path *path, float x0, float y0, float x1, float y1);

/** Wrapper for `fz_register_document_handler()`. */
/**
	Register a handler for a document type.

	handler: The handler to register.
*/
FZ_FUNCTION void register_document_handler(const fz_document_handler *handler);

/** Wrapper for `fz_register_document_handlers()`. */
/**
	Register handlers
	for all the standard document types supported in
	this build.
*/
FZ_FUNCTION void register_document_handlers();

/** Wrapper for `fz_remove_item()`. */
/**
	Remove an item from the store.

	If an item indexed by the given key exists in the store, remove
	it.

	drop: The function used to free the value (to ensure we get a
	value of the correct type).

	key: The key used to find the item to remove.

	type: Functions used to manipulate the key.
*/
FZ_FUNCTION void remove_item(fz_store_drop_fn *drop, void *key, const fz_store_type *type);

/** Wrapper for `fz_render_flags()`. */
FZ_FUNCTION void render_flags(fz_device *dev, int set, int clear);

/** Wrapper for `fz_render_glyph_pixmap()`. */
/**
	Create a pixmap containing a rendered glyph.

	Lookup gid from font, clip it with scissor, and rendering it
	with aa bits of antialiasing into a new pixmap.

	The caller takes ownership of the pixmap and so must free it.

	Note: This function is no longer used for normal rendering
	operations, and is kept around just because we use it in the
	app. It should be considered "at risk" of removal from the API.
*/
FZ_FUNCTION fz_pixmap *render_glyph_pixmap(fz_font *font, int gid, fz_matrix *ctm, const fz_irect *scissor, int aa);

/** Wrapper for `fz_render_t3_glyph_direct()`. */
/**
	Nasty PDF interpreter specific hernia, required to allow the
	interpreter to replay glyphs from a type3 font directly into
	the target device.

	This is only used in exceptional circumstances (such as type3
	glyphs that inherit current graphics state, or nested type3
	glyphs).
*/
FZ_FUNCTION void render_t3_glyph_direct(fz_device *dev, fz_font *font, int gid, fz_matrix trm, void *gstate, fz_default_colorspaces *def_cs);

/** Wrapper for `fz_rendering_intent_name()`. */
/**
	Map from enumerated rendering intent to string.

	The returned string is static and therefore must not be freed.
*/
FZ_FUNCTION const char *rendering_intent_name(int ri);

/** Wrapper for `fz_resize_buffer()`. */
/**
	Ensure that a buffer has a given capacity,
	truncating data if required.

	capacity: The desired capacity for the buffer. If the current
	size of the buffer contents is smaller than capacity, it is
	truncated.
*/
FZ_FUNCTION void resize_buffer(fz_buffer *buf, size_t capacity);

/** Wrapper for `fz_resolve_link()`.

This function has out-params. Python/C# wrappers look like:
	`resolve_link(fz_document *doc, const char *uri)` => `(fz_location, float xp, float yp)`
*/
/**
	Resolve an internal link to a page number.

	xp, yp: Pointer to store coordinate of destination on the page.

	Returns (-1,-1) if the URI cannot be resolved.
*/
FZ_FUNCTION fz_location resolve_link(fz_document *doc, const char *uri, 
		#ifdef SWIG
			float *OUTPUT
		#else
			float *xp
		#endif
		, 
		#ifdef SWIG
			float *OUTPUT
		#else
			float *yp
		#endif
		);

/** Wrapper for `fz_resolve_link_dest()`. */
/**
	Resolve an internal link to a page number, location, and possible viewing parameters.

	Returns location (-1,-1) if the URI cannot be resolved.
*/
FZ_FUNCTION fz_link_dest resolve_link_dest(fz_document *doc, const char *uri);

/** Wrapper for `fz_rethrow()`. */
FZ_FUNCTION void rethrow();

/** Wrapper for `fz_rethrow_if()`. */
FZ_FUNCTION void rethrow_if(int errcode);

/** Wrapper for `fz_rotate()`. */
/**
	Create a rotation matrix.

	The returned matrix is of the form
	[ cos(deg) sin(deg) -sin(deg) cos(deg) 0 0 ].

	m: Pointer to place to store matrix

	degrees: Degrees of counter clockwise rotation. Values less
	than zero and greater than 360 are handled as expected.

	Returns m.
*/
FZ_FUNCTION fz_matrix rotate(float degrees);

/** Wrapper for `fz_round_rect()`. */
/**
	Round rectangle coordinates.

	Coordinates in a bounding box are integers, so rounding of the
	rects coordinates takes place. The top left corner is rounded
	upwards and left while the bottom right corner is rounded
	downwards and to the right.

	This differs from fz_irect_from_rect, in that fz_irect_from_rect
	slavishly follows the numbers (i.e any slight over/under
	calculations can cause whole extra pixels to be added).
	fz_round_rect allows for a small amount of rounding error when
	calculating the bbox.
*/
FZ_FUNCTION fz_irect round_rect(fz_rect rect);

/** Wrapper for `fz_run_display_list()`. */
/**
	(Re)-run a display list through a device.

	list: A display list, created by fz_new_display_list and
	populated with objects from a page by running fz_run_page on a
	device obtained from fz_new_list_device.

	ctm: Transform to apply to display list contents. May include
	for example scaling and rotation, see fz_scale, fz_rotate and
	fz_concat. Set to fz_identity if no transformation is desired.

	scissor: Only the part of the contents of the display list
	visible within this area will be considered when the list is
	run through the device. This does not imply for tile objects
	contained in the display list.

	cookie: Communication mechanism between caller and library
	running the page. Intended for multi-threaded applications,
	while single-threaded applications set cookie to NULL. The
	caller may abort an ongoing page run. Cookie also communicates
	progress information back to the caller. The fields inside
	cookie are continually updated while the page is being run.
*/
FZ_FUNCTION void run_display_list(fz_display_list *list, fz_device *dev, fz_matrix ctm, fz_rect scissor, fz_cookie *cookie);

/** Wrapper for `fz_run_page()`. */
/**
	Run a page through a device.

	page: Page obtained from fz_load_page.

	dev: Device obtained from fz_new_*_device.

	transform: Transform to apply to page. May include for example
	scaling and rotation, see fz_scale, fz_rotate and fz_concat.
	Set to fz_identity if no transformation is desired.

	cookie: Communication mechanism between caller and library
	rendering the page. Intended for multi-threaded applications,
	while single-threaded applications set cookie to NULL. The
	caller may abort an ongoing rendering of a page. Cookie also
	communicates progress information back to the caller. The
	fields inside cookie are continually updated while the page is
	rendering.
*/
FZ_FUNCTION void run_page(fz_page *page, fz_device *dev, fz_matrix transform, fz_cookie *cookie);

/** Wrapper for `fz_run_page_annots()`. */
/**
	Run the annotations on a page through a device.
*/
FZ_FUNCTION void run_page_annots(fz_page *page, fz_device *dev, fz_matrix transform, fz_cookie *cookie);

/** Wrapper for `fz_run_page_contents()`. */
/**
	Run a page through a device. Just the main
	page content, without the annotations, if any.

	page: Page obtained from fz_load_page.

	dev: Device obtained from fz_new_*_device.

	transform: Transform to apply to page. May include for example
	scaling and rotation, see fz_scale, fz_rotate and fz_concat.
	Set to fz_identity if no transformation is desired.

	cookie: Communication mechanism between caller and library
	rendering the page. Intended for multi-threaded applications,
	while single-threaded applications set cookie to NULL. The
	caller may abort an ongoing rendering of a page. Cookie also
	communicates progress information back to the caller. The
	fields inside cookie are continually updated while the page is
	rendering.
*/
FZ_FUNCTION void run_page_contents(fz_page *page, fz_device *dev, fz_matrix transform, fz_cookie *cookie);

/** Wrapper for `fz_run_page_widgets()`. */
/**
	Run the widgets on a page through a device.
*/
FZ_FUNCTION void run_page_widgets(fz_page *page, fz_device *dev, fz_matrix transform, fz_cookie *cookie);

/** Wrapper for `fz_run_t3_glyph()`. */
/**
	Run a glyph from a Type3 font to
	a given device.

	font: The font to find the glyph in.

	gid: The glyph to run.

	trm: The transform to apply.

	dev: The device to render onto.
*/
FZ_FUNCTION void run_t3_glyph(fz_font *font, int gid, fz_matrix trm, struct fz_device *dev);

/** Wrapper for `fz_runeidx()`. */
/**
	Compute the index of a rune in a string.

	str: Pointer to beginning of a string.

	p: Pointer to a char in str.

	Returns the index of the rune pointed to by p in str.
*/
FZ_FUNCTION int runeidx(const char *str, const char *p);

/** Wrapper for `fz_runelen()`. */
/**
	Count how many chars are required to represent a rune.

	rune: The rune to encode.

	Returns the number of bytes required to represent this run in
	UTF8.
*/
FZ_FUNCTION int runelen(int rune);

/** Wrapper for `fz_runeptr()`. */
/**
	Obtain a pointer to the char representing the rune
	at a given index.

	str: Pointer to beginning of a string.

	idx: Index of a rune to return a char pointer to.

	Returns a pointer to the char where the desired rune starts,
	or NULL if the string ends before the index is reached.
*/
FZ_FUNCTION const char *runeptr(const char *str, int idx);

/** Wrapper for `fz_runetochar()`. */
/**
	UTF8 encode a rune to a sequence of chars.

	str: Pointer to a place to put the UTF8 encoded character.

	rune: Pointer to a 'rune'.

	Returns the number of bytes the rune took to output.
*/
FZ_FUNCTION int runetochar(char *str, int rune);

/** Wrapper for `fz_save_accelerator()`. */
/**
	Save accelerator data for the document to a given file.
*/
FZ_FUNCTION void save_accelerator(fz_document *doc, const char *accel);

/** Wrapper for `fz_save_bitmap_as_pbm()`. */
/**
	Save a bitmap as a pbm.
*/
FZ_FUNCTION void save_bitmap_as_pbm(fz_bitmap *bitmap, const char *filename);

/** Wrapper for `fz_save_bitmap_as_pcl()`. */
/**
	Save a bitmap as mono PCL.
*/
FZ_FUNCTION void save_bitmap_as_pcl(fz_bitmap *bitmap, char *filename, int append, const fz_pcl_options *pcl);

/** Wrapper for `fz_save_bitmap_as_pkm()`. */
/**
	Save a CMYK bitmap as a pkm.
*/
FZ_FUNCTION void save_bitmap_as_pkm(fz_bitmap *bitmap, const char *filename);

/** Wrapper for `fz_save_bitmap_as_pwg()`. */
/**
	Save a bitmap as a PWG.
*/
FZ_FUNCTION void save_bitmap_as_pwg(fz_bitmap *bitmap, char *filename, int append, const fz_pwg_options *pwg);

/** Wrapper for `fz_save_buffer()`. */
/**
	Save the contents of a buffer to a file.
*/
FZ_FUNCTION void save_buffer(fz_buffer *buf, const char *filename);

/** Wrapper for `fz_save_pixmap_as_pam()`. */
/**
	Save a pixmap as a pnm (greyscale, rgb or cmyk, with or without
	alpha).
*/
FZ_FUNCTION void save_pixmap_as_pam(fz_pixmap *pixmap, const char *filename);

/** Wrapper for `fz_save_pixmap_as_pbm()`. */
/**
	Save a pixmap as a pbm. (Performing halftoning).
*/
FZ_FUNCTION void save_pixmap_as_pbm(fz_pixmap *pixmap, const char *filename);

/** Wrapper for `fz_save_pixmap_as_pcl()`. */
/**
	Save an (RGB) pixmap as color PCL.
*/
FZ_FUNCTION void save_pixmap_as_pcl(fz_pixmap *pixmap, char *filename, int append, const fz_pcl_options *pcl);

/** Wrapper for `fz_save_pixmap_as_pclm()`. */
/**
	Save a (Greyscale or RGB) pixmap as pclm.
*/
FZ_FUNCTION void save_pixmap_as_pclm(fz_pixmap *pixmap, char *filename, int append, const fz_pclm_options *options);

/** Wrapper for `fz_save_pixmap_as_pdfocr()`. */
/**
	Save a (Greyscale or RGB) pixmap as pdfocr.
*/
FZ_FUNCTION void save_pixmap_as_pdfocr(fz_pixmap *pixmap, char *filename, int append, const fz_pdfocr_options *options);

/** Wrapper for `fz_save_pixmap_as_pkm()`. */
/**
	Save a CMYK pixmap as a pkm. (Performing halftoning).
*/
FZ_FUNCTION void save_pixmap_as_pkm(fz_pixmap *pixmap, const char *filename);

/** Wrapper for `fz_save_pixmap_as_png()`. */
/**
	Save a (Greyscale or RGB) pixmap as a png.
*/
FZ_FUNCTION void save_pixmap_as_png(fz_pixmap *pixmap, const char *filename);

/** Wrapper for `fz_save_pixmap_as_pnm()`. */
/**
	Save a pixmap as a pnm (greyscale or rgb, no alpha).
*/
FZ_FUNCTION void save_pixmap_as_pnm(fz_pixmap *pixmap, const char *filename);

/** Wrapper for `fz_save_pixmap_as_ps()`. */
/**
	Save a (gray, rgb, or cmyk, no alpha) pixmap out as postscript.
*/
FZ_FUNCTION void save_pixmap_as_ps(fz_pixmap *pixmap, char *filename, int append);

/** Wrapper for `fz_save_pixmap_as_psd()`. */
/**
	Save a pixmap as a PSD file.
*/
FZ_FUNCTION void save_pixmap_as_psd(fz_pixmap *pixmap, const char *filename);

/** Wrapper for `fz_save_pixmap_as_pwg()`. */
/**
	Save a pixmap as a PWG.
*/
FZ_FUNCTION void save_pixmap_as_pwg(fz_pixmap *pixmap, char *filename, int append, const fz_pwg_options *pwg);

/** Wrapper for `fz_scale()`. */
/**
	Create a scaling matrix.

	The returned matrix is of the form [ sx 0 0 sy 0 0 ].

	m: Pointer to the matrix to populate

	sx, sy: Scaling factors along the X- and Y-axes. A scaling
	factor of 1.0 will not cause any scaling along the relevant
	axis.

	Returns m.
*/
FZ_FUNCTION fz_matrix scale(float sx, float sy);

/** Wrapper for `fz_search_chapter_page_number()`.

This function has out-params. Python/C# wrappers look like:
	`search_chapter_page_number(fz_document *doc, int chapter, int page, const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
*/
FZ_FUNCTION int search_chapter_page_number(fz_document *doc, int chapter, int page, const char *needle, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *hit_mark
		#endif
		, fz_quad *hit_bbox, int hit_max);

/** Wrapper for `fz_search_display_list()`.

This function has out-params. Python/C# wrappers look like:
	`search_display_list(fz_display_list *list, const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
*/
FZ_FUNCTION int search_display_list(fz_display_list *list, const char *needle, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *hit_mark
		#endif
		, fz_quad *hit_bbox, int hit_max);

/** Wrapper for `fz_search_page()`.

This function has out-params. Python/C# wrappers look like:
	`search_page(fz_page *page, const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
*/
/**
	Search for the 'needle' text on the page.
	Record the hits in the hit_bbox array and return the number of
	hits. Will stop looking once it has filled hit_max rectangles.
*/
FZ_FUNCTION int search_page(fz_page *page, const char *needle, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *hit_mark
		#endif
		, fz_quad *hit_bbox, int hit_max);

/** Wrapper for `fz_search_page_number()`.

This function has out-params. Python/C# wrappers look like:
	`search_page_number(fz_document *doc, int number, const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
*/
FZ_FUNCTION int search_page_number(fz_document *doc, int number, const char *needle, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *hit_mark
		#endif
		, fz_quad *hit_bbox, int hit_max);

/** Wrapper for `fz_search_stext_page()`.

This function has out-params. Python/C# wrappers look like:
	`search_stext_page(fz_stext_page *text, const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
*/
/**
	Search for occurrence of 'needle' in text page.

	Return the number of hits and store hit quads in the passed in
	array.

	NOTE: This is an experimental interface and subject to change
	without notice.
*/
FZ_FUNCTION int search_stext_page(fz_stext_page *text, const char *needle, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *hit_mark
		#endif
		, fz_quad *hit_bbox, int hit_max);

/** Wrapper for `fz_seek()`. */
/**
	Seek within a stream.

	stm: The stream to seek within.

	offset: The offset to seek to.

	whence: From where the offset is measured (see fseek).
*/
FZ_FUNCTION void seek(fz_stream *stm, int64_t offset, int whence);

/** Wrapper for `fz_seek_output()`. */
/**
	Seek to the specified file position.
	See fseek for arguments.

	Throw an error on unseekable outputs.
*/
FZ_FUNCTION void seek_output(fz_output *out, int64_t off, int whence);

/** Wrapper for `fz_separation_current_behavior()`. */
/**
	Test for the current behavior of a separation.
*/
FZ_FUNCTION fz_separation_behavior separation_current_behavior(const fz_separations *sep, int separation);

/** Wrapper for `fz_separation_equivalent()`.

This function has out-params. Python/C# wrappers look like:
	`separation_equivalent(const fz_separations *seps, int idx, fz_colorspace *dst_cs, fz_colorspace *prf, fz_color_params color_params)` => float dst_color
*/
/**
	Get the equivalent separation color in a given colorspace.
*/
FZ_FUNCTION void separation_equivalent(const fz_separations *seps, int idx, fz_colorspace *dst_cs, 
		#ifdef SWIG
			float *OUTPUT
		#else
			float *dst_color
		#endif
		, fz_colorspace *prf, fz_color_params color_params);

/** Wrapper for `fz_separation_name()`. */
FZ_FUNCTION const char *separation_name(const fz_separations *sep, int separation);

/** Wrapper for `fz_set_aa_level()`. */
/**
	Set the number of bits of antialiasing we should
	use (for both text and graphics).

	bits: The number of bits of antialiasing to use (values are
	clamped to within the 0 to 8 range).
*/
FZ_FUNCTION void set_aa_level(int bits);

/** Wrapper for `fz_set_compressed_image_buffer()`. */
FZ_FUNCTION void set_compressed_image_buffer(fz_compressed_image *cimg, fz_compressed_buffer *buf);

/** Wrapper for `fz_set_default_cmyk()`. */
FZ_FUNCTION void set_default_cmyk(fz_default_colorspaces *default_cs, fz_colorspace *cs);

/** Wrapper for `fz_set_default_colorspaces()`. */
FZ_FUNCTION void set_default_colorspaces(fz_device *dev, fz_default_colorspaces *default_cs);

/** Wrapper for `fz_set_default_gray()`. */
/**
	Set new defaults within the default colorspace structure.

	New references are taken to the new default, and references to
	the old defaults dropped.

	Never throws exceptions.
*/
FZ_FUNCTION void set_default_gray(fz_default_colorspaces *default_cs, fz_colorspace *cs);

/** Wrapper for `fz_set_default_output_intent()`. */
FZ_FUNCTION void set_default_output_intent(fz_default_colorspaces *default_cs, fz_colorspace *cs);

/** Wrapper for `fz_set_default_rgb()`. */
FZ_FUNCTION void set_default_rgb(fz_default_colorspaces *default_cs, fz_colorspace *cs);

/** Wrapper for `fz_set_error_callback()`. */
/**
	Set the error callback. This will be called as part of the
	exception handling.

	The callback must not throw exceptions!
*/
FZ_FUNCTION void set_error_callback(fz_error_cb *error_cb, void *user);

/** Wrapper for `fz_set_font_bbox()`. */
/**
	Set the font bbox.

	font: The font to set the bbox for.

	xmin, ymin, xmax, ymax: The bounding box.
*/
FZ_FUNCTION void set_font_bbox(fz_font *font, float xmin, float ymin, float xmax, float ymax);

/** Wrapper for `fz_set_graphics_aa_level()`. */
/**
	Set the number of bits of antialiasing we
	should use for graphics.

	bits: The number of bits of antialiasing to use (values are
	clamped to within the 0 to 8 range).
*/
FZ_FUNCTION void set_graphics_aa_level(int bits);

/** Wrapper for `fz_set_graphics_min_line_width()`. */
/**
	Set the minimum line width to be
	used for stroked lines.

	min_line_width: The minimum line width to use (in pixels).
*/
FZ_FUNCTION void set_graphics_min_line_width(float min_line_width);

/** Wrapper for `fz_set_metadata()`. */
FZ_FUNCTION void set_metadata(fz_document *doc, const char *key, const char *value);

/** Wrapper for `fz_set_pixmap_image_tile()`. */
FZ_FUNCTION void set_pixmap_image_tile(fz_pixmap_image *cimg, fz_pixmap *pix);

/** Wrapper for `fz_set_pixmap_resolution()`. */
/**
	Set the pixels per inch resolution of the pixmap.
*/
FZ_FUNCTION void set_pixmap_resolution(fz_pixmap *pix, int xres, int yres);

/** Wrapper for `fz_set_separation_behavior()`. */
/**
	Control the rendering of a given separation.
*/
FZ_FUNCTION void set_separation_behavior(fz_separations *sep, int separation, fz_separation_behavior behavior);

/** Wrapper for `fz_set_stddbg()`. */
/**
	Set the output stream to be used for fz_stddbg. Set to NULL to
	reset to default (stderr).
*/
FZ_FUNCTION void set_stddbg(fz_output *out);

/** Wrapper for `fz_set_text_aa_level()`. */
/**
	Set the number of bits of antialiasing we
	should use for text.

	bits: The number of bits of antialiasing to use (values are
	clamped to within the 0 to 8 range).
*/
FZ_FUNCTION void set_text_aa_level(int bits);

/** Wrapper for `fz_set_use_document_css()`. */
/**
	Toggle whether to respect document styles in HTML and EPUB.
*/
FZ_FUNCTION void set_use_document_css(int use);

/** Wrapper for `fz_set_user_context()`. */
/**
	Set the user field in the context.

	NULL initially, this field can be set to any opaque value
	required by the user. It is copied on clones.
*/
FZ_FUNCTION void set_user_context(void *user);

/** Wrapper for `fz_set_user_css()`. */
/**
	Set the user stylesheet source text for use with HTML and EPUB.
*/
FZ_FUNCTION void set_user_css(const char *text);

/** Wrapper for `fz_set_warning_callback()`. */
/**
	Set the warning callback. This will be called as part of the
	exception handling.

	The callback must not throw exceptions!
*/
FZ_FUNCTION void set_warning_callback(fz_warning_cb *warning_cb, void *user);

/** Wrapper for `fz_sha256_final()`. */
/**
	MD5 finalization. Ends an MD5 message-digest operation, writing
	the message digest and zeroizing the context.

	Never throws an exception.
*/
FZ_FUNCTION void sha256_final(fz_sha256 *state, unsigned char digest[32]);

/** Wrapper for `fz_sha256_init()`. */
/**
	SHA256 initialization. Begins an SHA256 operation, initialising
	the supplied context.

	Never throws an exception.
*/
FZ_FUNCTION void sha256_init(fz_sha256 *state);

/** Wrapper for `fz_sha256_update()`. */
/**
	SHA256 block update operation. Continues an SHA256 message-
	digest operation, processing another message block, and updating
	the context.

	Never throws an exception.
*/
FZ_FUNCTION void sha256_update(fz_sha256 *state, const unsigned char *input, size_t inlen);

/** Wrapper for `fz_sha384_final()`. */
/**
	SHA384 finalization. Ends an SHA384 message-digest operation,
	writing the message digest and zeroizing the context.

	Never throws an exception.
*/
FZ_FUNCTION void sha384_final(fz_sha384 *state, unsigned char digest[64]);

/** Wrapper for `fz_sha384_init()`. */
/**
	SHA384 initialization. Begins an SHA384 operation, initialising
	the supplied context.

	Never throws an exception.
*/
FZ_FUNCTION void sha384_init(fz_sha384 *state);

/** Wrapper for `fz_sha384_update()`. */
/**
	SHA384 block update operation. Continues an SHA384 message-
	digest operation, processing another message block, and updating
	the context.

	Never throws an exception.
*/
FZ_FUNCTION void sha384_update(fz_sha384 *state, const unsigned char *input, size_t inlen);

/** Wrapper for `fz_sha512_final()`. */
/**
	SHA512 finalization. Ends an SHA512 message-digest operation,
	writing the message digest and zeroizing the context.

	Never throws an exception.
*/
FZ_FUNCTION void sha512_final(fz_sha512 *state, unsigned char digest[64]);

/** Wrapper for `fz_sha512_init()`. */
/**
	SHA512 initialization. Begins an SHA512 operation, initialising
	the supplied context.

	Never throws an exception.
*/
FZ_FUNCTION void sha512_init(fz_sha512 *state);

/** Wrapper for `fz_sha512_update()`. */
/**
	SHA512 block update operation. Continues an SHA512 message-
	digest operation, processing another message block, and updating
	the context.

	Never throws an exception.
*/
FZ_FUNCTION void sha512_update(fz_sha512 *state, const unsigned char *input, size_t inlen);

/** Wrapper for `fz_shear()`. */
/**
	Create a shearing matrix.

	The returned matrix is of the form [ 1 sy sx 1 0 0 ].

	m: pointer to place to store returned matrix

	sx, sy: Shearing factors. A shearing factor of 0.0 will not
	cause any shearing along the relevant axis.

	Returns m.
*/
FZ_FUNCTION fz_matrix shear(float sx, float sy);

/** Wrapper for `fz_show_glyph()`. */
/**
	Add a glyph/unicode value to a text object.

	text: Text object to add to.

	font: The font the glyph should be added in.

	trm: The transform to use for the glyph.

	glyph: The glyph id to add.

	unicode: The unicode character for the glyph.

	wmode: 1 for vertical mode, 0 for horizontal.

	bidi_level: The bidirectional level for this glyph.

	markup_dir: The direction of the text as specified in the
	markup.

	language: The language in use (if known, 0 otherwise)
	(e.g. FZ_LANG_zh_Hans).

	Throws exception on failure to allocate.
*/
FZ_FUNCTION void show_glyph(fz_text *text, fz_font *font, fz_matrix trm, int glyph, int unicode, int wmode, int bidi_level, fz_bidi_direction markup_dir, fz_text_language language);

/** Wrapper for `fz_show_string()`. */
/**
	Add a UTF8 string to a text object.

	text: Text object to add to.

	font: The font the string should be added in.

	trm: The transform to use.

	s: The utf-8 string to add.

	wmode: 1 for vertical mode, 0 for horizontal.

	bidi_level: The bidirectional level for this glyph.

	markup_dir: The direction of the text as specified in the markup.

	language: The language in use (if known, 0 otherwise)
		(e.g. FZ_LANG_zh_Hans).

	Returns the transform updated with the advance width of the
	string.
*/
FZ_FUNCTION fz_matrix show_string(fz_text *text, fz_font *font, fz_matrix trm, const char *s, int wmode, int bidi_level, fz_bidi_direction markup_dir, fz_text_language language);

/** Wrapper for `fz_shrink_store()`. */
/**
	Evict items from the store until the total size of
	the objects in the store is reduced to a given percentage of its
	current size.

	percent: %age of current size to reduce the store to.

	Returns non zero if we managed to free enough memory, zero
	otherwise.
*/
FZ_FUNCTION int shrink_store(unsigned int percent);

/** Wrapper for `fz_skip()`. */
/**
	Read from a stream discarding data.

	stm: The stream to read from.

	len: The number of bytes to read.

	Returns the number of bytes read. May throw exceptions.
*/
FZ_FUNCTION size_t skip(fz_stream *stm, size_t len);

/** Wrapper for `fz_skip_space()`. */
/**
	Skip over whitespace (bytes <= 32) in a stream.
*/
FZ_FUNCTION void skip_space(fz_stream *stm);

/** Wrapper for `fz_skip_string()`. */
/**
	Skip over a given string in a stream. Return 0 if successfully
	skipped, non-zero otherwise. As many characters will be skipped
	over as matched in the string.
*/
FZ_FUNCTION int skip_string(fz_stream *stm, const char *str);

/** Wrapper for `fz_snap_selection()`. */
FZ_FUNCTION fz_quad snap_selection(fz_stext_page *page, fz_point *ap, fz_point *bp, int mode);

/** Wrapper for `fz_start_throw_on_repair()`. */
FZ_FUNCTION void start_throw_on_repair();

/** Wrapper for `fz_stat_mtime()`. */
FZ_FUNCTION int64_t stat_mtime(const char *path);

/** Wrapper for `fz_stddbg()`. */
/**
	Retrieve an fz_output for the default debugging stream. On
	Windows this will be OutputDebugString for non-console apps.
	Otherwise, it is always fz_stderr.

	Optionally may be fz_dropped when finished with.
*/
FZ_FUNCTION fz_output *stddbg();

/** Wrapper for `fz_stderr()`. */
/**
	Retrieve an fz_output that directs to stdout.

	Optionally may be fz_dropped when finished with.
*/
FZ_FUNCTION fz_output *stderr_();

/** Wrapper for `fz_stdout()`. */
/**
	Retrieve an fz_output that directs to stdout.

	Optionally may be fz_dropped when finished with.
*/
FZ_FUNCTION fz_output *stdout_();

/** Wrapper for `fz_store_item()`. */
/**
	Add an item to the store.

	Add an item into the store, returning NULL for success. If an
	item with the same key is found in the store, then our item will
	not be inserted, and the function will return a pointer to that
	value instead. This function takes its own reference to val, as
	required (i.e. the caller maintains ownership of its own
	reference).

	key: The key used to index the item.

	val: The value to store.

	itemsize: The size in bytes of the value (as counted towards the
	store size).

	type: Functions used to manipulate the key.
*/
FZ_FUNCTION void *store_item(void *key, void *val, size_t itemsize, const fz_store_type *type);

/** Wrapper for `fz_store_scavenge()`.

This function has out-params. Python/C# wrappers look like:
	`store_scavenge(size_t size)` => `(int, int phase)`
*/
/**
	Internal function used as part of the scavenging
	allocator; when we fail to allocate memory, before returning a
	failure to the caller, we try to scavenge space within the store
	by evicting at least 'size' bytes. The allocator then retries.

	size: The number of bytes we are trying to have free.

	phase: What phase of the scavenge we are in. Updated on exit.

	Returns non zero if we managed to free any memory.
*/
FZ_FUNCTION int store_scavenge(size_t size, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *phase
		#endif
		);

/** Wrapper for `fz_store_scavenge_external()`.

This function has out-params. Python/C# wrappers look like:
	`store_scavenge_external(size_t size)` => `(int, int phase)`
*/
/**
	External function for callers to use
	to scavenge while trying allocations.

	size: The number of bytes we are trying to have free.

	phase: What phase of the scavenge we are in. Updated on exit.

	Returns non zero if we managed to free any memory.
*/
FZ_FUNCTION int store_scavenge_external(size_t size, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *phase
		#endif
		);

/** Wrapper for `fz_strcasecmp()`. */
/**
	Case insensitive (ASCII only) string comparison.
*/
FZ_FUNCTION int strcasecmp(const char *a, const char *b);

/** Wrapper for `fz_strdup()`. */
/**
	Portable strdup implementation, using fz allocators.
*/
FZ_FUNCTION char *strdup(const char *s);

/** Wrapper for `fz_stream_from_output()`. */
/**
	Obtain the fz_output in the form of a fz_stream.

	This allows data to be read back from some forms of fz_output
	object. When finished reading, the fz_stream should be released
	by calling fz_drop_stream. Until the fz_stream is dropped, no
	further operations should be performed on the fz_output object.
*/
FZ_FUNCTION fz_stream *stream_from_output(fz_output *arg_1);

/** Wrapper for `fz_string_from_buffer()`. */
/**
	Ensure that a buffer's data ends in a
	0 byte, and return a pointer to it.
*/
FZ_FUNCTION const char *string_from_buffer(fz_buffer *buf);

/** Wrapper for `fz_string_from_text_language()`. */
/**
	Recover ISO 639 (639-{1,2,3,5}) language specification
	strings losslessly from a 15 bit fz_text_language code.

	No validation is carried out. See note above.
*/
FZ_FUNCTION char *string_from_text_language(char str[8], fz_text_language lang);

/** Wrapper for `fz_strlcat()`. */
/**
	Concatenate 2 strings, with a maximum length.

	dst: pointer to first string in a buffer of n bytes.

	src: pointer to string to concatenate.

	n: Size (in bytes) of buffer that dst is in.

	Returns the real length that a concatenated dst + src would have
	been (not including terminator).
*/
FZ_FUNCTION size_t strlcat(char *dst, const char *src, size_t n);

/** Wrapper for `fz_strlcpy()`. */
/**
	Copy at most n-1 chars of a string into a destination
	buffer with null termination, returning the real length of the
	initial string (excluding terminator).

	dst: Destination buffer, at least n bytes long.

	src: C string (non-NULL).

	n: Size of dst buffer in bytes.

	Returns the length (excluding terminator) of src.
*/
FZ_FUNCTION size_t strlcpy(char *dst, const char *src, size_t n);

/** Wrapper for `fz_strncasecmp()`. */
FZ_FUNCTION int strncasecmp(const char *a, const char *b, size_t n);

/** Wrapper for `fz_strnlen()`. */
/**
	Return strlen(s), if that is less than maxlen, or maxlen if
	there is no null byte ('\0') among the first maxlen bytes.
*/
FZ_FUNCTION size_t strnlen(const char *s, size_t maxlen);

/** Wrapper for `fz_stroke_path()`. */
FZ_FUNCTION void stroke_path(fz_device *dev, const fz_path *path, const fz_stroke_state *stroke, fz_matrix ctm, fz_colorspace *colorspace, const float *color, float alpha, fz_color_params color_params);

/** Wrapper for `fz_stroke_text()`. */
FZ_FUNCTION void stroke_text(fz_device *dev, const fz_text *text, const fz_stroke_state *stroke, fz_matrix ctm, fz_colorspace *colorspace, const float *color, float alpha, fz_color_params color_params);

/** Wrapper for `fz_strsep()`.

This function has out-params. Python/C# wrappers look like:
	`strsep(const char *delim)` => `(char *, char *stringp)`
*/
/**
	Given a pointer to a C string (or a pointer to NULL) break
	it at the first occurrence of a delimiter char (from a given
	set).

	stringp: Pointer to a C string pointer (or NULL). Updated on
	exit to point to the first char of the string after the
	delimiter that was found. The string pointed to by stringp will
	be corrupted by this call (as the found delimiter will be
	overwritten by 0).

	delim: A C string of acceptable delimiter characters.

	Returns a pointer to a C string containing the chars of stringp
	up to the first delimiter char (or the end of the string), or
	NULL.
*/
FZ_FUNCTION char *strsep(
		#ifdef SWIG
			char **OUTPUT
		#else
			char **stringp
		#endif
		, const char *delim);

/** Wrapper for `fz_strtof()`.

This function has out-params. Python/C# wrappers look like:
	`strtof(const char *s)` => `(float, char *es)`
*/
/**
	Locale-independent decimal to binary conversion. On overflow
	return (-)INFINITY and set errno to ERANGE. On underflow return
	0 and set errno to ERANGE. Special inputs (case insensitive):
	"NAN", "INF" or "INFINITY".
*/
FZ_FUNCTION float strtof(const char *s, 
		#ifdef SWIG
			char **OUTPUT
		#else
			char **es
		#endif
		);

/** Wrapper for `fz_subpixel_adjust()`. */
/**
	Perform subpixel quantisation and adjustment on a glyph matrix.

	ctm: On entry, the desired 'ideal' transformation for a glyph.
	On exit, adjusted to a (very similar) transformation quantised
	for subpixel caching.

	subpix_ctm: Initialised by the routine to the transform that
	should be used to render the glyph.

	qe, qf: which subpixel position we quantised to.

	Returns: the size of the glyph.

	Note: This is currently only exposed for use in our app. It
	should be considered "at risk" of removal from the API.
*/
FZ_FUNCTION float subpixel_adjust(fz_matrix *ctm, fz_matrix *subpix_ctm, unsigned char *qe, unsigned char *qf);

/** Wrapper for `fz_sync_bits()`. */
/**
	Called after reading bits to tell the stream
	that we are about to return to reading bytewise. Resyncs
	the stream to whole byte boundaries.
*/
FZ_FUNCTION void sync_bits(fz_stream *stm);

/** Wrapper for `fz_tell()`. */
/**
	return the current reading position within a stream
*/
FZ_FUNCTION int64_t tell(fz_stream *stm);

/** Wrapper for `fz_tell_output()`. */
/**
	Return the current file position.

	Throw an error on untellable outputs.
*/
FZ_FUNCTION int64_t tell_output(fz_output *out);

/** Wrapper for `fz_terminate_buffer()`. */
/**
	Zero-terminate buffer in order to use as a C string.

	This byte is invisible and does not affect the length of the
	buffer as returned by fz_buffer_storage. The zero byte is
	written *after* the data, and subsequent writes will overwrite
	the terminating byte.

	Subsequent changes to the size of the buffer (such as by
	fz_buffer_trim, fz_buffer_grow, fz_resize_buffer, etc) may
	invalidate this.
*/
FZ_FUNCTION void terminate_buffer(fz_buffer *buf);

/** Wrapper for `fz_text_aa_level()`. */
/**
	Get the number of bits of antialiasing we are
	using for text. Between 0 and 8.
*/
FZ_FUNCTION int text_aa_level();

/** Wrapper for `fz_text_language_from_string()`. */
/**
	Convert ISO 639 (639-{1,2,3,5}) language specification
	strings losslessly to a 15 bit fz_text_language code.

	No validation is carried out. Obviously invalid (out
	of spec) codes will be mapped to FZ_LANG_UNSET, but
	well-formed (but undefined) codes will be blithely
	accepted.
*/
FZ_FUNCTION fz_text_language text_language_from_string(const char *str);

/** Wrapper for `fz_tint_pixmap()`. */
/**
	Tint all the pixels in an RGB, BGR, or Gray pixmap.

	black: Map black to this hexadecimal RGB color.

	white: Map white to this hexadecimal RGB color.
*/
FZ_FUNCTION void tint_pixmap(fz_pixmap *pix, int black, int white);

/** Wrapper for `fz_tolower()`. */
/**
	Unicode aware tolower and toupper functions.
*/
FZ_FUNCTION int tolower(int c);

/** Wrapper for `fz_toupper()`. */
FZ_FUNCTION int toupper(int c);

/** Wrapper for `fz_transform_page()`. */
/**
	Create transform matrix to draw page
	at a given resolution and rotation. Adjusts the scaling
	factors so that the page covers whole number of
	pixels and adjust the page origin to be at 0,0.
*/
FZ_FUNCTION fz_matrix transform_page(fz_rect mediabox, float resolution, float rotate);

/** Wrapper for `fz_transform_path()`. */
/**
	Transform a path by a given
	matrix.

	path: The path to modify (must not be a packed path).

	transform: The transform to apply.

	Throws exceptions if the path is packed, or on failure
	to allocate.
*/
FZ_FUNCTION void transform_path(fz_path *path, fz_matrix transform);

/** Wrapper for `fz_transform_point()`. */
/**
	Apply a transformation to a point.

	transform: Transformation matrix to apply. See fz_concat,
	fz_scale, fz_rotate and fz_translate for how to create a
	matrix.

	point: Pointer to point to update.

	Returns transform (unchanged).
*/
FZ_FUNCTION fz_point transform_point(fz_point point, fz_matrix m);

/** Wrapper for `fz_transform_point_xy()`. */
FZ_FUNCTION fz_point transform_point_xy(float x, float y, fz_matrix m);

/** Wrapper for `fz_transform_quad()`. */
/**
	Transform a quad by a matrix.
*/
FZ_FUNCTION fz_quad transform_quad(fz_quad q, fz_matrix m);

/** Wrapper for `fz_transform_rect()`. */
/**
	Apply a transform to a rectangle.

	After the four corner points of the axis-aligned rectangle
	have been transformed it may not longer be axis-aligned. So a
	new axis-aligned rectangle is created covering at least the
	area of the transformed rectangle.

	transform: Transformation matrix to apply. See fz_concat,
	fz_scale and fz_rotate for how to create a matrix.

	rect: Rectangle to be transformed. The two special cases
	fz_empty_rect and fz_infinite_rect, may be used but are
	returned unchanged as expected.
*/
FZ_FUNCTION fz_rect transform_rect(fz_rect rect, fz_matrix m);

/** Wrapper for `fz_transform_vector()`. */
/**
	Apply a transformation to a vector.

	transform: Transformation matrix to apply. See fz_concat,
	fz_scale and fz_rotate for how to create a matrix. Any
	translation will be ignored.

	vector: Pointer to vector to update.
*/
FZ_FUNCTION fz_point transform_vector(fz_point vector, fz_matrix m);

/** Wrapper for `fz_translate()`. */
/**
	Create a translation matrix.

	The returned matrix is of the form [ 1 0 0 1 tx ty ].

	m: A place to store the created matrix.

	tx, ty: Translation distances along the X- and Y-axes. A
	translation of 0 will not cause any translation along the
	relevant axis.

	Returns m.
*/
FZ_FUNCTION fz_matrix translate(float tx, float ty);

/** Wrapper for `fz_translate_irect()`. */
FZ_FUNCTION fz_irect translate_irect(fz_irect a, int xoff, int yoff);

/** Wrapper for `fz_translate_rect()`. */
/**
	Translate bounding box.

	Translate a bbox by a given x and y offset. Allows for overflow.
*/
FZ_FUNCTION fz_rect translate_rect(fz_rect a, float xoff, float yoff);

/** Wrapper for `fz_tree_insert()`. */
/**
	Insert a new key/value pair and rebalance the tree.
	Return the new root of the tree after inserting and rebalancing.
	May be called with a NULL root to create a new tree.

	No data is copied into the tree structure; key and value are
	merely kept as pointers.
*/
FZ_FUNCTION fz_tree *tree_insert(fz_tree *root, const char *key, void *value);

/** Wrapper for `fz_tree_lookup()`. */
/**
	Look for the value of a node in the tree with the given key.

	Simple pointer equivalence is used for key.

	Returns NULL for no match.
*/
FZ_FUNCTION void *tree_lookup(fz_tree *node, const char *key);

/** Wrapper for `fz_trim_buffer()`. */
/**
	Trim wasted capacity from a buffer by resizing internal memory.
*/
FZ_FUNCTION void trim_buffer(fz_buffer *buf);

/** Wrapper for `fz_trim_path()`. */
/**
	Minimise the internal storage used by a path.

	As paths are constructed, the internal buffers
	grow. To avoid repeated reallocations they
	grow with some spare space. Once a path has
	been fully constructed, this call allows the
	excess space to be trimmed.
*/
FZ_FUNCTION void trim_path(fz_path *path);

/** Wrapper for `fz_truncate_output()`. */
/**
	Truncate the output at the current position.

	This allows output streams which have seeked back from the end
	of their storage to be truncated at the current point.
*/
FZ_FUNCTION void truncate_output(fz_output *arg_1);

/** Wrapper for `fz_try_invert_matrix()`. */
/**
	Attempt to create an inverse matrix.

	inverse: Place to store inverse matrix.

	matrix: Matrix to invert. A degenerate matrix, where the
	determinant is equal to zero, can not be inverted.

	Returns 1 if matrix is degenerate (singular), or 0 otherwise.
*/
FZ_FUNCTION int try_invert_matrix(fz_matrix *inv, fz_matrix src);

/** Wrapper for `fz_tune_image_decode()`. */
/**
	Set the tuning function to use for
	image decode.

	image_decode: Function to use.

	arg: Opaque argument to be passed to tuning function.
*/
FZ_FUNCTION void tune_image_decode(fz_tune_image_decode_fn *image_decode, void *arg);

/** Wrapper for `fz_tune_image_scale()`. */
/**
	Set the tuning function to use for
	image scaling.

	image_scale: Function to use.

	arg: Opaque argument to be passed to tuning function.
*/
FZ_FUNCTION void tune_image_scale(fz_tune_image_scale_fn *image_scale, void *arg);

/** Wrapper for `fz_unicode_from_glyph_name()`. */
FZ_FUNCTION int unicode_from_glyph_name(const char *name);

/** Wrapper for `fz_unicode_from_glyph_name_strict()`. */
FZ_FUNCTION int unicode_from_glyph_name_strict(const char *name);

/** Wrapper for `fz_union_rect()`. */
/**
	Compute union of two rectangles.

	Given two rectangles, update the first to be the smallest
	axis-aligned rectangle that encompasses both given rectangles.
	If either rectangle is infinite then the union is also infinite.
	If either rectangle is empty then the union is simply the
	non-empty rectangle. Should both rectangles be empty, then the
	union is also empty.
*/
FZ_FUNCTION fz_rect union_rect(fz_rect a, fz_rect b);

/** Wrapper for `fz_unlock()`. */
/**
	Unlock one of the user supplied mutexes.
*/
FZ_FUNCTION void unlock(int lock);

/** Wrapper for `fz_unpack_stream()`. */
FZ_FUNCTION fz_stream *unpack_stream(fz_stream *src, int depth, int w, int h, int n, int indexed, int pad, int skip);

/** Wrapper for `fz_unread_byte()`. */
/**
	Unread the single last byte successfully
	read from a stream. Do not call this without having
	successfully read a byte.

	stm: The stream to operate upon.
*/
FZ_FUNCTION void unread_byte(fz_stream *stm);

/** Wrapper for `fz_unshare_stroke_state()`. */
/**
	Given a reference to a (possibly) shared stroke_state structure,
	return a reference to an equivalent stroke_state structure
	that is guaranteed to be unshared (i.e. one that can
	safely be modified).

	shared: The reference to a (possibly) shared structure
	to unshare. Ownership of this reference is passed in
	to this function, even in the case of exceptions being
	thrown.

	Exceptions may be thrown in the event of failure to
	allocate if required.
*/
FZ_FUNCTION fz_stroke_state *unshare_stroke_state(fz_stroke_state *shared);

/** Wrapper for `fz_unshare_stroke_state_with_dash_len()`. */
/**
	Given a reference to a (possibly) shared stroke_state structure,
	return a reference to a stroke_state structure (with room for a
	given amount of dash data) that is guaranteed to be unshared
	(i.e. one that can safely be modified).

	shared: The reference to a (possibly) shared structure
	to unshare. Ownership of this reference is passed in
	to this function, even in the case of exceptions being
	thrown.

	Exceptions may be thrown in the event of failure to
	allocate if required.
*/
FZ_FUNCTION fz_stroke_state *unshare_stroke_state_with_dash_len(fz_stroke_state *shared, int len);

/** Wrapper for `fz_urldecode()`. */
/**
	decode url escapes.
*/
FZ_FUNCTION char *urldecode(char *url);

/** Wrapper for `fz_use_document_css()`. */
/**
	Return whether to respect document styles in HTML and EPUB.
*/
FZ_FUNCTION int use_document_css();

/** Wrapper for `fz_user_context()`. */
/**
	Read the user field from the context.
*/
FZ_FUNCTION void *user_context();

/** Wrapper for `fz_user_css()`. */
/**
	Get the user stylesheet source text.
*/
FZ_FUNCTION const char *user_css();

/** Wrapper for `fz_utflen()`. */
/**
	Count how many runes the UTF-8 encoded string
	consists of.

	s: The UTF-8 encoded, NUL-terminated text string.

	Returns the number of runes in the string.
*/
FZ_FUNCTION int utflen(const char *s);

/** Wrapper for `fz_var_imp()`. */
FZ_FUNCTION void var_imp(void *arg_0);

/** Wrapper for `fz_vsnprintf()`. */
/**
	A vsnprintf work-alike, using our custom formatter.
*/
FZ_FUNCTION size_t vsnprintf(char *buffer, size_t space, const char *fmt, va_list args);

/** Wrapper for `fz_vthrow()`. */
FZ_FUNCTION void vthrow(int errcode, const char *arg_2, va_list ap);

/** Wrapper for `fz_vwarn()`. */
FZ_FUNCTION void vwarn(const char *fmt, va_list ap);

/** Wrapper for `fz_walk_path()`. */
/**
	Walk the segments of a path, calling the
	appropriate callback function from a given set for each
	segment of the path.

	path: The path to walk.

	walker: The set of callback functions to use. The first
	4 callback pointers in the set must be non-NULL. The
	subsequent ones can either be supplied, or can be left
	as NULL, in which case the top 4 functions will be
	called as appropriate to simulate them.

	arg: An opaque argument passed in to each callback.

	Exceptions will only be thrown if the underlying callback
	functions throw them.
*/
FZ_FUNCTION void walk_path(const fz_path *path, const fz_path_walker *walker, void *arg);

/** Wrapper for `fz_warning_callback()`.

This function has out-params. Python/C# wrappers look like:
	`warning_callback()` => `(fz_warning_cb *, void *user)`
*/
/**
	Retrieve the currently set warning callback, or NULL if none
	has been set. Optionally, if user is non-NULL, the user pointer
	given when the warning callback was set is also passed back to
	the caller.
*/
FZ_FUNCTION fz_warning_cb *warning_callback(
		#ifdef SWIG
			void **OUTPUT
		#else
			void **user
		#endif
		);

/** Wrapper for `fz_warp_pixmap()`. */
FZ_FUNCTION fz_pixmap *warp_pixmap(fz_pixmap *src, const fz_point points[4], int width, int height);

/** Wrapper for `fz_windows_1250_from_unicode()`. */
FZ_FUNCTION int windows_1250_from_unicode(int u);

/** Wrapper for `fz_windows_1251_from_unicode()`. */
FZ_FUNCTION int windows_1251_from_unicode(int u);

/** Wrapper for `fz_windows_1252_from_unicode()`. */
FZ_FUNCTION int windows_1252_from_unicode(int u);

/** Wrapper for `fz_write_band()`. */
/**
	Cause a band writer to write the next band
	of data for an image.

	stride: The byte offset from the first byte of the data
	for a pixel to the first byte of the data for the same pixel
	on the row below.

	band_height: The number of lines in this band.

	samples: Pointer to first byte of the data.
*/
FZ_FUNCTION void write_band(fz_band_writer *writer, int stride, int band_height, const unsigned char *samples);

/** Wrapper for `fz_write_base64()`. */
/**
	Write a base64 encoded data block, optionally with periodic
	newlines.
*/
FZ_FUNCTION void write_base64(fz_output *out, const unsigned char *data, size_t size, int newline);

/** Wrapper for `fz_write_base64_buffer()`. */
/**
	Write a base64 encoded fz_buffer, optionally with periodic
	newlines.
*/
FZ_FUNCTION void write_base64_buffer(fz_output *out, fz_buffer *data, int newline);

/** Wrapper for `fz_write_bitmap_as_pbm()`. */
/**
	Write a bitmap as a pbm.
*/
FZ_FUNCTION void write_bitmap_as_pbm(fz_output *out, fz_bitmap *bitmap);

/** Wrapper for `fz_write_bitmap_as_pcl()`. */
/**
	Write a bitmap as mono PCL.
*/
FZ_FUNCTION void write_bitmap_as_pcl(fz_output *out, const fz_bitmap *bitmap, const fz_pcl_options *pcl);

/** Wrapper for `fz_write_bitmap_as_pkm()`. */
/**
	Write a CMYK bitmap as a pkm.
*/
FZ_FUNCTION void write_bitmap_as_pkm(fz_output *out, fz_bitmap *bitmap);

/** Wrapper for `fz_write_bitmap_as_pwg()`. */
/**
	Write a bitmap as a PWG.
*/
FZ_FUNCTION void write_bitmap_as_pwg(fz_output *out, const fz_bitmap *bitmap, const fz_pwg_options *pwg);

/** Wrapper for `fz_write_bitmap_as_pwg_page()`. */
/**
	Write a bitmap as a PWG page.

	Caller should provide a file header by calling
	fz_write_pwg_file_header, but can then write several pages to
	the same file.
*/
FZ_FUNCTION void write_bitmap_as_pwg_page(fz_output *out, const fz_bitmap *bitmap, const fz_pwg_options *pwg);

/** Wrapper for `fz_write_byte()`. */
FZ_FUNCTION void write_byte(fz_output *out, unsigned char x);

/** Wrapper for `fz_write_char()`. */
FZ_FUNCTION void write_char(fz_output *out, char x);

/** Wrapper for `fz_write_data()`. */
/**
	Write data to output.

	data: Pointer to data to write.
	size: Size of data to write in bytes.
*/
FZ_FUNCTION void write_data(fz_output *out, const void *data, size_t size);

/** Wrapper for `fz_write_document()`. */
/**
	Convenience function to feed all the pages of a document to
	fz_begin_page/fz_run_page/fz_end_page.
*/
FZ_FUNCTION void write_document(fz_document_writer *wri, fz_document *doc);

/** Wrapper for `fz_write_float_be()`. */
FZ_FUNCTION void write_float_be(fz_output *out, float f);

/** Wrapper for `fz_write_float_le()`. */
FZ_FUNCTION void write_float_le(fz_output *out, float f);

/** Wrapper for `fz_write_header()`. */
/**
	Cause a band writer to write the header for
	a banded image with the given properties/dimensions etc. This
	also configures the bandwriter for the format of the data to be
	passed in future calls.

	w, h: Width and Height of the entire page.

	n: Number of components (including spots and alphas).

	alpha: Number of alpha components.

	xres, yres: X and Y resolutions in dpi.

	cs: Colorspace (NULL for bitmaps)

	seps: Separation details (or NULL).
*/
FZ_FUNCTION void write_header(fz_band_writer *writer, int w, int h, int n, int alpha, int xres, int yres, int pagenum, fz_colorspace *cs, fz_separations *seps);

/** Wrapper for `fz_write_image_as_data_uri()`. */
/**
	Write image as a data URI (for HTML and SVG output).
*/
FZ_FUNCTION void write_image_as_data_uri(fz_output *out, fz_image *image);

/** Wrapper for `fz_write_int16_be()`. */
FZ_FUNCTION void write_int16_be(fz_output *out, int x);

/** Wrapper for `fz_write_int16_le()`. */
FZ_FUNCTION void write_int16_le(fz_output *out, int x);

/** Wrapper for `fz_write_int32_be()`. */
/**
	Write different sized data to an output stream.
*/
FZ_FUNCTION void write_int32_be(fz_output *out, int x);

/** Wrapper for `fz_write_int32_le()`. */
FZ_FUNCTION void write_int32_le(fz_output *out, int x);

/** Wrapper for `fz_write_pixmap_as_data_uri()`. */
FZ_FUNCTION void write_pixmap_as_data_uri(fz_output *out, fz_pixmap *pixmap);

/** Wrapper for `fz_write_pixmap_as_pam()`. */
/**
	Write a pixmap as a pnm (greyscale, rgb or cmyk, with or without
	alpha).
*/
FZ_FUNCTION void write_pixmap_as_pam(fz_output *out, fz_pixmap *pixmap);

/** Wrapper for `fz_write_pixmap_as_pcl()`. */
/**
	Write an (RGB) pixmap as color PCL.
*/
FZ_FUNCTION void write_pixmap_as_pcl(fz_output *out, const fz_pixmap *pixmap, const fz_pcl_options *pcl);

/** Wrapper for `fz_write_pixmap_as_pclm()`. */
/**
	Write a (Greyscale or RGB) pixmap as pclm.
*/
FZ_FUNCTION void write_pixmap_as_pclm(fz_output *out, const fz_pixmap *pixmap, const fz_pclm_options *options);

/** Wrapper for `fz_write_pixmap_as_pdfocr()`. */
/**
	Write a (Greyscale or RGB) pixmap as pdfocr.
*/
FZ_FUNCTION void write_pixmap_as_pdfocr(fz_output *out, const fz_pixmap *pixmap, const fz_pdfocr_options *options);

/** Wrapper for `fz_write_pixmap_as_png()`. */
/**
	Write a (Greyscale or RGB) pixmap as a png.
*/
FZ_FUNCTION void write_pixmap_as_png(fz_output *out, const fz_pixmap *pixmap);

/** Wrapper for `fz_write_pixmap_as_pnm()`. */
/**
	Write a pixmap as a pnm (greyscale or rgb, no alpha).
*/
FZ_FUNCTION void write_pixmap_as_pnm(fz_output *out, fz_pixmap *pixmap);

/** Wrapper for `fz_write_pixmap_as_ps()`. */
/**
	Write a (gray, rgb, or cmyk, no alpha) pixmap out as postscript.
*/
FZ_FUNCTION void write_pixmap_as_ps(fz_output *out, const fz_pixmap *pixmap);

/** Wrapper for `fz_write_pixmap_as_psd()`. */
/**
	Write a pixmap as a PSD file.
*/
FZ_FUNCTION void write_pixmap_as_psd(fz_output *out, const fz_pixmap *pixmap);

/** Wrapper for `fz_write_pixmap_as_pwg()`. */
/**
	Write a pixmap as a PWG.
*/
FZ_FUNCTION void write_pixmap_as_pwg(fz_output *out, const fz_pixmap *pixmap, const fz_pwg_options *pwg);

/** Wrapper for `fz_write_pixmap_as_pwg_page()`. */
/**
	Write a pixmap as a PWG page.

	Caller should provide a file header by calling
	fz_write_pwg_file_header, but can then write several pages to
	the same file.
*/
FZ_FUNCTION void write_pixmap_as_pwg_page(fz_output *out, const fz_pixmap *pixmap, const fz_pwg_options *pwg);

/** Wrapper for `fz_write_ps_file_header()`. */
/**
	Write the file level header for ps band writer output.
*/
FZ_FUNCTION void write_ps_file_header(fz_output *out);

/** Wrapper for `fz_write_ps_file_trailer()`. */
/**
	Write the file level trailer for ps band writer output.
*/
FZ_FUNCTION void write_ps_file_trailer(fz_output *out, int pages);

/** Wrapper for `fz_write_pwg_file_header()`. */
/**
	Output the file header to a pwg stream, ready for pages to follow it.
*/
FZ_FUNCTION void write_pwg_file_header(fz_output *out);

/** Wrapper for `fz_write_rune()`. */
/**
	Write a UTF-8 encoded unicode character.
*/
FZ_FUNCTION void write_rune(fz_output *out, int rune);

/** Wrapper for `fz_write_string()`. */
/**
	Write a string. Does not write zero terminator.
*/
FZ_FUNCTION void write_string(fz_output *out, const char *s);

/** Wrapper for `fz_write_uint16_be()`. */
FZ_FUNCTION void write_uint16_be(fz_output *out, unsigned int x);

/** Wrapper for `fz_write_uint16_le()`. */
FZ_FUNCTION void write_uint16_le(fz_output *out, unsigned int x);

/** Wrapper for `fz_write_uint32_be()`. */
FZ_FUNCTION void write_uint32_be(fz_output *out, unsigned int x);

/** Wrapper for `fz_write_uint32_le()`. */
FZ_FUNCTION void write_uint32_le(fz_output *out, unsigned int x);

/** Wrapper for `fz_write_vprintf()`. */
/**
	va_list version of fz_write_printf.
*/
FZ_FUNCTION void write_vprintf(fz_output *out, const char *fmt, va_list ap);

/** Wrapper for `fz_write_zip_entry()`. */
/**
	Given a buffer of data, (optionally) compress it, and add it to
	the zip file with the given name.
*/
FZ_FUNCTION void write_zip_entry(fz_zip_writer *zip, const char *name, fz_buffer *buf, int compress);

/** Wrapper for `fz_xml_att()`. */
/**
	Return the value of an attribute of an XML node.
	NULL if the attribute doesn't exist.
*/
FZ_FUNCTION char *xml_att(fz_xml *item, const char *att);

/** Wrapper for `fz_xml_att_alt()`. */
/**
	Return the value of an attribute of an XML node.
	If the first attribute doesn't exist, try the second.
	NULL if neither attribute exists.
*/
FZ_FUNCTION char *xml_att_alt(fz_xml *item, const char *one, const char *two);

/** Wrapper for `fz_xml_att_eq()`. */
/**
	Check for a matching attribute on an XML node.

	If the node has the requested attribute (name), and the value
	matches (match) then return 1. Otherwise, 0.
*/
FZ_FUNCTION int xml_att_eq(fz_xml *item, const char *name, const char *match);

/** Wrapper for `fz_xml_down()`. */
/**
	Return first child of XML node.
*/
FZ_FUNCTION fz_xml *xml_down(fz_xml *item);

/** Wrapper for `fz_xml_find()`. */
/**
	Search the siblings of XML nodes starting with item looking for
	the first with the given tag.

	Return NULL if none found.
*/
FZ_FUNCTION fz_xml *xml_find(fz_xml *item, const char *tag);

/** Wrapper for `fz_xml_find_down()`. */
/**
	Search the siblings of XML nodes starting with the first child
	of item looking for the first with the given tag.

	Return NULL if none found.
*/
FZ_FUNCTION fz_xml *xml_find_down(fz_xml *item, const char *tag);

/** Wrapper for `fz_xml_find_down_match()`. */
/**
	Search the siblings of XML nodes starting with the first child
	of item looking for the first with the given tag, and with a
	matching attribute.

	Return NULL if none found.
*/
FZ_FUNCTION fz_xml *xml_find_down_match(fz_xml *item, const char *tag, const char *att, const char *match);

/** Wrapper for `fz_xml_find_match()`. */
/**
	Search the siblings of XML nodes starting with item looking for
	the first with the given tag, and with a matching attribute.

	Return NULL if none found.
*/
FZ_FUNCTION fz_xml *xml_find_match(fz_xml *item, const char *tag, const char *att, const char *match);

/** Wrapper for `fz_xml_find_next()`. */
/**
	Search the siblings of XML nodes starting with the first sibling
	of item looking for the first with the given tag.

	Return NULL if none found.
*/
FZ_FUNCTION fz_xml *xml_find_next(fz_xml *item, const char *tag);

/** Wrapper for `fz_xml_find_next_match()`. */
/**
	Search the siblings of XML nodes starting with the first sibling
	of item looking for the first with the given tag, and with a
	matching attribute.

	Return NULL if none found.
*/
FZ_FUNCTION fz_xml *xml_find_next_match(fz_xml *item, const char *tag, const char *att, const char *match);

/** Wrapper for `fz_xml_is_tag()`. */
/**
	Return true if the tag name matches.
*/
FZ_FUNCTION int xml_is_tag(fz_xml *item, const char *name);

/** Wrapper for `fz_xml_next()`. */
/**
	Return next sibling of XML node.
*/
FZ_FUNCTION fz_xml *xml_next(fz_xml *item);

/** Wrapper for `fz_xml_prev()`. */
/**
	Return previous sibling of XML node.
*/
FZ_FUNCTION fz_xml *xml_prev(fz_xml *item);

/** Wrapper for `fz_xml_root()`. */
/**
	Return the topmost XML node of a document.
*/
FZ_FUNCTION fz_xml *xml_root(fz_xml_doc *xml);

/** Wrapper for `fz_xml_tag()`. */
/**
	Return tag of XML node. Return NULL for text nodes.
*/
FZ_FUNCTION char *xml_tag(fz_xml *item);

/** Wrapper for `fz_xml_text()`. */
/**
	Return the text content of an XML node.
	Return NULL if the node is a tag.
*/
FZ_FUNCTION char *xml_text(fz_xml *item);

/** Wrapper for `fz_xml_up()`. */
/**
	Return parent of XML node.
*/
FZ_FUNCTION fz_xml *xml_up(fz_xml *item);

/** Wrapper for `pdf_access_alert_event()`. */
FZ_FUNCTION pdf_alert_event *ppdf_access_alert_event(pdf_doc_event *evt);

/** Wrapper for `pdf_access_exec_menu_item_event()`. */
FZ_FUNCTION const char *ppdf_access_exec_menu_item_event(pdf_doc_event *evt);

/** Wrapper for `pdf_access_launch_url_event()`. */
FZ_FUNCTION pdf_launch_url_event *ppdf_access_launch_url_event(pdf_doc_event *evt);

/** Wrapper for `pdf_access_mail_doc_event()`. */
FZ_FUNCTION pdf_mail_doc_event *ppdf_access_mail_doc_event(pdf_doc_event *evt);

/** Wrapper for `pdf_add_annot_ink_list()`. */
FZ_FUNCTION void ppdf_add_annot_ink_list(pdf_annot *annot, int n, fz_point stroke[]);

/** Wrapper for `pdf_add_annot_ink_list_stroke()`. */
FZ_FUNCTION void ppdf_add_annot_ink_list_stroke(pdf_annot *annot);

/** Wrapper for `pdf_add_annot_ink_list_stroke_vertex()`. */
FZ_FUNCTION void ppdf_add_annot_ink_list_stroke_vertex(pdf_annot *annot, fz_point p);

/** Wrapper for `pdf_add_annot_quad_point()`. */
FZ_FUNCTION void ppdf_add_annot_quad_point(pdf_annot *annot, fz_quad quad);

/** Wrapper for `pdf_add_annot_vertex()`. */
FZ_FUNCTION void ppdf_add_annot_vertex(pdf_annot *annot, fz_point p);

/** Wrapper for `pdf_add_cid_font()`. */
FZ_FUNCTION pdf_obj *ppdf_add_cid_font(pdf_document *doc, fz_font *font);

/** Wrapper for `pdf_add_cjk_font()`. */
FZ_FUNCTION pdf_obj *ppdf_add_cjk_font(pdf_document *doc, fz_font *font, int script, int wmode, int serif);

/** Wrapper for `pdf_add_codespace()`. */
FZ_FUNCTION void ppdf_add_codespace(pdf_cmap *cmap, unsigned int low, unsigned int high, size_t n);

/** Wrapper for `pdf_add_embedded_file()`. */
FZ_FUNCTION pdf_obj *ppdf_add_embedded_file(pdf_document *doc, const char *filename, const char *mimetype, fz_buffer *contents);

/** Wrapper for `pdf_add_hmtx()`. */
FZ_FUNCTION void ppdf_add_hmtx(pdf_font_desc *font, int lo, int hi, int w);

/** Wrapper for `pdf_add_image()`. */
FZ_FUNCTION pdf_obj *ppdf_add_image(pdf_document *doc, fz_image *image);

/** Wrapper for `pdf_add_journal_fragment()`. */
FZ_FUNCTION void ppdf_add_journal_fragment(pdf_document *doc, int parent, pdf_obj *copy, fz_buffer *copy_stream, int newobj);

/** Wrapper for `pdf_add_new_array()`. */
FZ_FUNCTION pdf_obj *ppdf_add_new_array(pdf_document *doc, int initial);

/** Wrapper for `pdf_add_new_dict()`. */
FZ_FUNCTION pdf_obj *ppdf_add_new_dict(pdf_document *doc, int initial);

/** Wrapper for `pdf_add_object()`. */
FZ_FUNCTION pdf_obj *ppdf_add_object(pdf_document *doc, pdf_obj *obj);

/** Wrapper for `pdf_add_object_drop()`. */
FZ_FUNCTION pdf_obj *ppdf_add_object_drop(pdf_document *doc, pdf_obj *obj);

/** Wrapper for `pdf_add_page()`. */
FZ_FUNCTION pdf_obj *ppdf_add_page(pdf_document *doc, fz_rect mediabox, int rotate, pdf_obj *resources, fz_buffer *contents);

/** Wrapper for `pdf_add_simple_font()`. */
FZ_FUNCTION pdf_obj *ppdf_add_simple_font(pdf_document *doc, fz_font *font, int encoding);

/** Wrapper for `pdf_add_stream()`. */
FZ_FUNCTION pdf_obj *ppdf_add_stream(pdf_document *doc, fz_buffer *buf, pdf_obj *obj, int compressed);

/** Wrapper for `pdf_add_substitute_font()`. */
FZ_FUNCTION pdf_obj *ppdf_add_substitute_font(pdf_document *doc, fz_font *font);

/** Wrapper for `pdf_add_vmtx()`. */
FZ_FUNCTION void ppdf_add_vmtx(pdf_font_desc *font, int lo, int hi, int x, int y, int w);

/** Wrapper for `pdf_annot_MK_BC()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_annot_MK_BC(pdf_annot *annot, float color[4])` => int n
*/
FZ_FUNCTION void ppdf_annot_MK_BC(pdf_annot *annot, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *n
		#endif
		, float color[4]);

/** Wrapper for `pdf_annot_MK_BC_rgb()`. */
FZ_FUNCTION int ppdf_annot_MK_BC_rgb(pdf_annot *annot, float rgb[3]);

/** Wrapper for `pdf_annot_MK_BG()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_annot_MK_BG(pdf_annot *annot, float color[4])` => int n
*/
FZ_FUNCTION void ppdf_annot_MK_BG(pdf_annot *annot, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *n
		#endif
		, float color[4]);

/** Wrapper for `pdf_annot_MK_BG_rgb()`. */
FZ_FUNCTION int ppdf_annot_MK_BG_rgb(pdf_annot *annot, float rgb[3]);

/** Wrapper for `pdf_annot_active()`. */
FZ_FUNCTION int ppdf_annot_active(pdf_annot *annot);

/** Wrapper for `pdf_annot_ap()`. */
FZ_FUNCTION pdf_obj *ppdf_annot_ap(pdf_annot *annot);

/** Wrapper for `pdf_annot_author()`. */
FZ_FUNCTION const char *ppdf_annot_author(pdf_annot *annot);

/** Wrapper for `pdf_annot_border()`. */
FZ_FUNCTION float ppdf_annot_border(pdf_annot *annot);

/** Wrapper for `pdf_annot_color()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_annot_color(pdf_annot *annot, float color[4])` => int n
*/
FZ_FUNCTION void ppdf_annot_color(pdf_annot *annot, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *n
		#endif
		, float color[4]);

/** Wrapper for `pdf_annot_contents()`. */
FZ_FUNCTION const char *ppdf_annot_contents(pdf_annot *annot);

/** Wrapper for `pdf_annot_creation_date()`. */
FZ_FUNCTION int64_t ppdf_annot_creation_date(pdf_annot *annot);

/** Wrapper for `pdf_annot_default_appearance()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_annot_default_appearance(pdf_annot *annot, float color[4])` => `(const char *font, float size, int n)`
*/
FZ_FUNCTION void ppdf_annot_default_appearance(pdf_annot *annot, 
		#ifdef SWIG
			const char **OUTPUT
		#else
			const char **font
		#endif
		, 
		#ifdef SWIG
			float *OUTPUT
		#else
			float *size
		#endif
		, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *n
		#endif
		, float color[4]);

/** Wrapper for `pdf_annot_ensure_local_xref()`. */
FZ_FUNCTION void ppdf_annot_ensure_local_xref(pdf_annot *annot);

/** Wrapper for `pdf_annot_event_blur()`. */
FZ_FUNCTION void ppdf_annot_event_blur(pdf_annot *annot);

/** Wrapper for `pdf_annot_event_down()`. */
FZ_FUNCTION void ppdf_annot_event_down(pdf_annot *annot);

/** Wrapper for `pdf_annot_event_enter()`. */
FZ_FUNCTION void ppdf_annot_event_enter(pdf_annot *annot);

/** Wrapper for `pdf_annot_event_exit()`. */
FZ_FUNCTION void ppdf_annot_event_exit(pdf_annot *annot);

/** Wrapper for `pdf_annot_event_focus()`. */
FZ_FUNCTION void ppdf_annot_event_focus(pdf_annot *annot);

/** Wrapper for `pdf_annot_event_page_close()`. */
FZ_FUNCTION void ppdf_annot_event_page_close(pdf_annot *annot);

/** Wrapper for `pdf_annot_event_page_invisible()`. */
FZ_FUNCTION void ppdf_annot_event_page_invisible(pdf_annot *annot);

/** Wrapper for `pdf_annot_event_page_open()`. */
FZ_FUNCTION void ppdf_annot_event_page_open(pdf_annot *annot);

/** Wrapper for `pdf_annot_event_page_visible()`. */
FZ_FUNCTION void ppdf_annot_event_page_visible(pdf_annot *annot);

/** Wrapper for `pdf_annot_event_up()`. */
FZ_FUNCTION void ppdf_annot_event_up(pdf_annot *annot);

/** Wrapper for `pdf_annot_field_event_keystroke()`. */
FZ_FUNCTION int ppdf_annot_field_event_keystroke(pdf_document *doc, pdf_annot *annot, pdf_keystroke_event *evt);

/** Wrapper for `pdf_annot_field_flags()`. */
FZ_FUNCTION int ppdf_annot_field_flags(pdf_annot *annot);

/** Wrapper for `pdf_annot_field_label()`. */
FZ_FUNCTION const char *ppdf_annot_field_label(pdf_annot *widget);

/** Wrapper for `pdf_annot_field_value()`. */
FZ_FUNCTION const char *ppdf_annot_field_value(pdf_annot *annot);

/** Wrapper for `pdf_annot_flags()`. */
FZ_FUNCTION int ppdf_annot_flags(pdf_annot *annot);

/** Wrapper for `pdf_annot_has_author()`. */
FZ_FUNCTION int ppdf_annot_has_author(pdf_annot *annot);

/** Wrapper for `pdf_annot_has_icon_name()`. */
FZ_FUNCTION int ppdf_annot_has_icon_name(pdf_annot *annot);

/** Wrapper for `pdf_annot_has_ink_list()`. */
FZ_FUNCTION int ppdf_annot_has_ink_list(pdf_annot *annot);

/** Wrapper for `pdf_annot_has_interior_color()`. */
FZ_FUNCTION int ppdf_annot_has_interior_color(pdf_annot *annot);

/** Wrapper for `pdf_annot_has_line()`. */
FZ_FUNCTION int ppdf_annot_has_line(pdf_annot *annot);

/** Wrapper for `pdf_annot_has_line_ending_styles()`. */
FZ_FUNCTION int ppdf_annot_has_line_ending_styles(pdf_annot *annot);

/** Wrapper for `pdf_annot_has_open()`. */
FZ_FUNCTION int ppdf_annot_has_open(pdf_annot *annot);

/** Wrapper for `pdf_annot_has_quad_points()`. */
FZ_FUNCTION int ppdf_annot_has_quad_points(pdf_annot *annot);

/** Wrapper for `pdf_annot_has_vertices()`. */
FZ_FUNCTION int ppdf_annot_has_vertices(pdf_annot *annot);

/** Wrapper for `pdf_annot_hot()`. */
FZ_FUNCTION int ppdf_annot_hot(pdf_annot *annot);

/** Wrapper for `pdf_annot_icon_name()`. */
FZ_FUNCTION const char *ppdf_annot_icon_name(pdf_annot *annot);

/** Wrapper for `pdf_annot_ink_list_count()`. */
FZ_FUNCTION int ppdf_annot_ink_list_count(pdf_annot *annot);

/** Wrapper for `pdf_annot_ink_list_stroke_count()`. */
FZ_FUNCTION int ppdf_annot_ink_list_stroke_count(pdf_annot *annot, int i);

/** Wrapper for `pdf_annot_ink_list_stroke_vertex()`. */
FZ_FUNCTION fz_point ppdf_annot_ink_list_stroke_vertex(pdf_annot *annot, int i, int k);

/** Wrapper for `pdf_annot_interior_color()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_annot_interior_color(pdf_annot *annot, float color[4])` => int n
*/
FZ_FUNCTION void ppdf_annot_interior_color(pdf_annot *annot, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *n
		#endif
		, float color[4]);

/** Wrapper for `pdf_annot_is_open()`. */
FZ_FUNCTION int ppdf_annot_is_open(pdf_annot *annot);

/** Wrapper for `pdf_annot_language()`. */
FZ_FUNCTION fz_text_language ppdf_annot_language(pdf_annot *annot);

/** Wrapper for `pdf_annot_line()`. */
FZ_FUNCTION void ppdf_annot_line(pdf_annot *annot, fz_point *a, fz_point *b);

/** Wrapper for `pdf_annot_line_end_style()`. */
FZ_FUNCTION enum pdf_line_ending ppdf_annot_line_end_style(pdf_annot *annot);

/** Wrapper for `pdf_annot_line_ending_styles()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_annot_line_ending_styles(pdf_annot *annot)` => `(enum pdf_line_ending start_style, enum pdf_line_ending end_style)`
*/
FZ_FUNCTION void ppdf_annot_line_ending_styles(pdf_annot *annot, 
		#ifdef SWIG
			enum pdf_line_ending *OUTPUT
		#else
			enum pdf_line_ending *start_style
		#endif
		, 
		#ifdef SWIG
			enum pdf_line_ending *OUTPUT
		#else
			enum pdf_line_ending *end_style
		#endif
		);

/** Wrapper for `pdf_annot_line_start_style()`. */
FZ_FUNCTION enum pdf_line_ending ppdf_annot_line_start_style(pdf_annot *annot);

/** Wrapper for `pdf_annot_modification_date()`. */
FZ_FUNCTION int64_t ppdf_annot_modification_date(pdf_annot *annot);

/** Wrapper for `pdf_annot_needs_resynthesis()`. */
FZ_FUNCTION int ppdf_annot_needs_resynthesis(pdf_annot *annot);

/** Wrapper for `pdf_annot_obj()`. */
FZ_FUNCTION pdf_obj *ppdf_annot_obj(pdf_annot *annot);

/** Wrapper for `pdf_annot_opacity()`. */
FZ_FUNCTION float ppdf_annot_opacity(pdf_annot *annot);

/** Wrapper for `pdf_annot_page()`. */
FZ_FUNCTION pdf_page *ppdf_annot_page(pdf_annot *annot);

/** Wrapper for `pdf_annot_pop_and_discard_local_xref()`. */
FZ_FUNCTION void ppdf_annot_pop_and_discard_local_xref(pdf_annot *annot);

/** Wrapper for `pdf_annot_pop_local_xref()`. */
FZ_FUNCTION void ppdf_annot_pop_local_xref(pdf_annot *annot);

/** Wrapper for `pdf_annot_popup()`. */
FZ_FUNCTION fz_rect ppdf_annot_popup(pdf_annot *annot);

/** Wrapper for `pdf_annot_push_local_xref()`. */
FZ_FUNCTION void ppdf_annot_push_local_xref(pdf_annot *annot);

/** Wrapper for `pdf_annot_quad_point()`. */
FZ_FUNCTION fz_quad ppdf_annot_quad_point(pdf_annot *annot, int i);

/** Wrapper for `pdf_annot_quad_point_count()`. */
FZ_FUNCTION int ppdf_annot_quad_point_count(pdf_annot *annot);

/** Wrapper for `pdf_annot_quadding()`. */
FZ_FUNCTION int ppdf_annot_quadding(pdf_annot *annot);

/** Wrapper for `pdf_annot_rect()`. */
FZ_FUNCTION fz_rect ppdf_annot_rect(pdf_annot *annot);

/** Wrapper for `pdf_annot_request_resynthesis()`. */
FZ_FUNCTION void ppdf_annot_request_resynthesis(pdf_annot *annot);

/** Wrapper for `pdf_annot_transform()`. */
FZ_FUNCTION fz_matrix ppdf_annot_transform(pdf_annot *annot);

/** Wrapper for `pdf_annot_type()`. */
FZ_FUNCTION enum pdf_annot_type ppdf_annot_type(pdf_annot *annot);

/** Wrapper for `pdf_annot_type_from_string()`. */
FZ_FUNCTION enum pdf_annot_type ppdf_annot_type_from_string(const char *subtype);

/** Wrapper for `pdf_annot_vertex()`. */
FZ_FUNCTION fz_point ppdf_annot_vertex(pdf_annot *annot, int i);

/** Wrapper for `pdf_annot_vertex_count()`. */
FZ_FUNCTION int ppdf_annot_vertex_count(pdf_annot *annot);

/** Wrapper for `pdf_append_token()`. */
FZ_FUNCTION void ppdf_append_token(fz_buffer *buf, int tok, pdf_lexbuf *lex);

/** Wrapper for `pdf_array_contains()`. */
FZ_FUNCTION int ppdf_array_contains(pdf_obj *array, pdf_obj *obj);

/** Wrapper for `pdf_array_delete()`. */
FZ_FUNCTION void ppdf_array_delete(pdf_obj *array, int index);

/** Wrapper for `pdf_array_find()`. */
FZ_FUNCTION int ppdf_array_find(pdf_obj *array, pdf_obj *obj);

/** Wrapper for `pdf_array_get()`. */
FZ_FUNCTION pdf_obj *ppdf_array_get(pdf_obj *array, int i);

/** Wrapper for `pdf_array_get_bool()`. */
FZ_FUNCTION int ppdf_array_get_bool(pdf_obj *array, int index);

/** Wrapper for `pdf_array_get_int()`. */
FZ_FUNCTION int ppdf_array_get_int(pdf_obj *array, int index);

/** Wrapper for `pdf_array_get_matrix()`. */
FZ_FUNCTION fz_matrix ppdf_array_get_matrix(pdf_obj *array, int index);

/** Wrapper for `pdf_array_get_name()`. */
FZ_FUNCTION const char *ppdf_array_get_name(pdf_obj *array, int index);

/** Wrapper for `pdf_array_get_real()`. */
FZ_FUNCTION float ppdf_array_get_real(pdf_obj *array, int index);

/** Wrapper for `pdf_array_get_rect()`. */
FZ_FUNCTION fz_rect ppdf_array_get_rect(pdf_obj *array, int index);

/** Wrapper for `pdf_array_get_string()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_array_get_string(pdf_obj *array, int index)` => `(const char *, size_t sizep)`
*/
FZ_FUNCTION const char *ppdf_array_get_string(pdf_obj *array, int index, 
		#ifdef SWIG
			size_t *OUTPUT
		#else
			size_t *sizep
		#endif
		);

/** Wrapper for `pdf_array_get_text_string()`. */
FZ_FUNCTION const char *ppdf_array_get_text_string(pdf_obj *array, int index);

/** Wrapper for `pdf_array_insert()`. */
FZ_FUNCTION void ppdf_array_insert(pdf_obj *array, pdf_obj *obj, int index);

/** Wrapper for `pdf_array_insert_drop()`. */
FZ_FUNCTION void ppdf_array_insert_drop(pdf_obj *array, pdf_obj *obj, int index);

/** Wrapper for `pdf_array_len()`. */
FZ_FUNCTION int ppdf_array_len(pdf_obj *array);

/** Wrapper for `pdf_array_push()`. */
FZ_FUNCTION void ppdf_array_push(pdf_obj *array, pdf_obj *obj);

/** Wrapper for `pdf_array_push_array()`. */
FZ_FUNCTION pdf_obj *ppdf_array_push_array(pdf_obj *array, int initial);

/** Wrapper for `pdf_array_push_bool()`. */
FZ_FUNCTION void ppdf_array_push_bool(pdf_obj *array, int x);

/** Wrapper for `pdf_array_push_dict()`. */
FZ_FUNCTION pdf_obj *ppdf_array_push_dict(pdf_obj *array, int initial);

/** Wrapper for `pdf_array_push_drop()`. */
FZ_FUNCTION void ppdf_array_push_drop(pdf_obj *array, pdf_obj *obj);

/** Wrapper for `pdf_array_push_int()`. */
FZ_FUNCTION void ppdf_array_push_int(pdf_obj *array, int64_t x);

/** Wrapper for `pdf_array_push_name()`. */
FZ_FUNCTION void ppdf_array_push_name(pdf_obj *array, const char *x);

/** Wrapper for `pdf_array_push_real()`. */
FZ_FUNCTION void ppdf_array_push_real(pdf_obj *array, double x);

/** Wrapper for `pdf_array_push_string()`. */
FZ_FUNCTION void ppdf_array_push_string(pdf_obj *array, const char *x, size_t n);

/** Wrapper for `pdf_array_push_text_string()`. */
FZ_FUNCTION void ppdf_array_push_text_string(pdf_obj *array, const char *x);

/** Wrapper for `pdf_array_put()`. */
FZ_FUNCTION void ppdf_array_put(pdf_obj *array, int i, pdf_obj *obj);

/** Wrapper for `pdf_array_put_drop()`. */
FZ_FUNCTION void ppdf_array_put_drop(pdf_obj *array, int i, pdf_obj *obj);

/** Wrapper for `pdf_authenticate_password()`. */
FZ_FUNCTION int ppdf_authenticate_password(pdf_document *doc, const char *pw);

/** Wrapper for `pdf_begin_implicit_operation()`. */
FZ_FUNCTION void ppdf_begin_implicit_operation(pdf_document *doc);

/** Wrapper for `pdf_begin_operation()`. */
FZ_FUNCTION void ppdf_begin_operation(pdf_document *doc, const char *operation);

/** Wrapper for `pdf_bound_annot()`. */
FZ_FUNCTION fz_rect ppdf_bound_annot(pdf_annot *annot);

/** Wrapper for `pdf_bound_page()`. */
FZ_FUNCTION fz_rect ppdf_bound_page(pdf_page *page);

/** Wrapper for `pdf_bound_widget()`. */
FZ_FUNCTION fz_rect ppdf_bound_widget(pdf_annot *widget);

/** Wrapper for `pdf_button_field_on_state()`. */
FZ_FUNCTION pdf_obj *ppdf_button_field_on_state(pdf_obj *field);

/** Wrapper for `pdf_cache_object()`. */
FZ_FUNCTION pdf_xref_entry *ppdf_cache_object(pdf_document *doc, int num);

/** Wrapper for `pdf_calculate_form()`. */
FZ_FUNCTION void ppdf_calculate_form(pdf_document *doc);

/** Wrapper for `pdf_can_be_saved_incrementally()`. */
FZ_FUNCTION int ppdf_can_be_saved_incrementally(pdf_document *doc);

/** Wrapper for `pdf_can_redo()`. */
FZ_FUNCTION int ppdf_can_redo(pdf_document *doc);

/** Wrapper for `pdf_can_undo()`. */
FZ_FUNCTION int ppdf_can_undo(pdf_document *doc);

/** Wrapper for `pdf_check_certificate()`. */
FZ_FUNCTION pdf_signature_error ppdf_check_certificate(pdf_pkcs7_verifier *verifier, pdf_document *doc, pdf_obj *signature);

/** Wrapper for `pdf_check_digest()`. */
FZ_FUNCTION pdf_signature_error ppdf_check_digest(pdf_pkcs7_verifier *verifier, pdf_document *doc, pdf_obj *signature);

/** Wrapper for `pdf_check_signature()`. */
FZ_FUNCTION int ppdf_check_signature(pdf_pkcs7_verifier *verifier, pdf_document *doc, pdf_obj *signature, char *ebuf, size_t ebufsize);

/** Wrapper for `pdf_check_widget_certificate()`. */
FZ_FUNCTION pdf_signature_error ppdf_check_widget_certificate(pdf_pkcs7_verifier *verifier, pdf_annot *widget);

/** Wrapper for `pdf_check_widget_digest()`. */
FZ_FUNCTION pdf_signature_error ppdf_check_widget_digest(pdf_pkcs7_verifier *verifier, pdf_annot *widget);

/** Wrapper for `pdf_choice_field_option()`. */
FZ_FUNCTION const char *ppdf_choice_field_option(pdf_obj *field, int exportval, int i);

/** Wrapper for `pdf_choice_field_option_count()`. */
FZ_FUNCTION int ppdf_choice_field_option_count(pdf_obj *field);

/** Wrapper for `pdf_choice_widget_is_multiselect()`. */
FZ_FUNCTION int ppdf_choice_widget_is_multiselect(pdf_annot *tw);

/** Wrapper for `pdf_choice_widget_options()`. */
FZ_FUNCTION int ppdf_choice_widget_options(pdf_annot *tw, int exportval, const char *opts[]);

/** Wrapper for `pdf_choice_widget_set_value()`. */
FZ_FUNCTION void ppdf_choice_widget_set_value(pdf_annot *tw, int n, const char *opts[]);

/** Wrapper for `pdf_choice_widget_value()`. */
FZ_FUNCTION int ppdf_choice_widget_value(pdf_annot *tw, const char *opts[]);

/** Wrapper for `pdf_clean_file()`. */
FZ_FUNCTION void ppdf_clean_file(char *infile, char *outfile, char *password, pdf_write_options *opts, int retainlen, char *retainlist[]);

/** Wrapper for `pdf_clean_font_name()`. */
FZ_FUNCTION const char *ppdf_clean_font_name(const char *fontname);

/** Wrapper for `pdf_clean_obj()`. */
FZ_FUNCTION void ppdf_clean_obj(pdf_obj *obj);

/** Wrapper for `pdf_clear_annot_ink_list()`. */
FZ_FUNCTION void ppdf_clear_annot_ink_list(pdf_annot *annot);

/** Wrapper for `pdf_clear_annot_quad_points()`. */
FZ_FUNCTION void ppdf_clear_annot_quad_points(pdf_annot *annot);

/** Wrapper for `pdf_clear_annot_vertices()`. */
FZ_FUNCTION void ppdf_clear_annot_vertices(pdf_annot *annot);

/** Wrapper for `pdf_clear_signature()`. */
FZ_FUNCTION void ppdf_clear_signature(pdf_annot *widget);

/** Wrapper for `pdf_clear_xref()`. */
FZ_FUNCTION void ppdf_clear_xref(pdf_document *doc);

/** Wrapper for `pdf_clear_xref_to_mark()`. */
FZ_FUNCTION void ppdf_clear_xref_to_mark(pdf_document *doc);

/** Wrapper for `pdf_close_processor()`. */
FZ_FUNCTION void ppdf_close_processor(pdf_processor *proc);

/** Wrapper for `pdf_cmap_size()`. */
FZ_FUNCTION size_t ppdf_cmap_size(pdf_cmap *cmap);

/** Wrapper for `pdf_cmap_wmode()`. */
FZ_FUNCTION int ppdf_cmap_wmode(pdf_cmap *cmap);

/** Wrapper for `pdf_copy_array()`. */
FZ_FUNCTION pdf_obj *ppdf_copy_array(pdf_obj *array);

/** Wrapper for `pdf_copy_dict()`. */
FZ_FUNCTION pdf_obj *ppdf_copy_dict(pdf_obj *dict);

/** Wrapper for `pdf_count_layer_config_ui()`. */
FZ_FUNCTION int ppdf_count_layer_config_ui(pdf_document *doc);

/** Wrapper for `pdf_count_layer_configs()`. */
FZ_FUNCTION int ppdf_count_layer_configs(pdf_document *doc);

/** Wrapper for `pdf_count_objects()`. */
FZ_FUNCTION int ppdf_count_objects(pdf_document *doc);

/** Wrapper for `pdf_count_pages()`. */
FZ_FUNCTION int ppdf_count_pages(pdf_document *doc);

/** Wrapper for `pdf_count_pages_imp()`. */
FZ_FUNCTION int ppdf_count_pages_imp(fz_document *doc, int chapter);

/** Wrapper for `pdf_count_signatures()`. */
FZ_FUNCTION int ppdf_count_signatures(pdf_document *doc);

/** Wrapper for `pdf_count_unsaved_versions()`. */
FZ_FUNCTION int ppdf_count_unsaved_versions(pdf_document *doc);

/** Wrapper for `pdf_count_versions()`. */
FZ_FUNCTION int ppdf_count_versions(pdf_document *doc);

/** Wrapper for `pdf_create_annot()`. */
FZ_FUNCTION pdf_annot *ppdf_create_annot(pdf_page *page, enum pdf_annot_type type);

/** Wrapper for `pdf_create_annot_raw()`. */
FZ_FUNCTION pdf_annot *ppdf_create_annot_raw(pdf_page *page, enum pdf_annot_type type);

/** Wrapper for `pdf_create_document()`. */
FZ_FUNCTION pdf_document *ppdf_create_document();

/** Wrapper for `pdf_create_field_name()`. */
FZ_FUNCTION void ppdf_create_field_name(pdf_document *doc, const char *prefix, char *buf, size_t len);

/** Wrapper for `pdf_create_link()`. */
FZ_FUNCTION fz_link *ppdf_create_link(pdf_page *page, fz_rect bbox, const char *uri);

/** Wrapper for `pdf_create_object()`. */
FZ_FUNCTION int ppdf_create_object(pdf_document *doc);

/** Wrapper for `pdf_create_signature_widget()`. */
FZ_FUNCTION pdf_annot *ppdf_create_signature_widget(pdf_page *page, char *name);

/** Wrapper for `pdf_crypt_encrypt_metadata()`. */
FZ_FUNCTION int ppdf_crypt_encrypt_metadata(pdf_crypt *crypt);

/** Wrapper for `pdf_crypt_key()`. */
FZ_FUNCTION unsigned char *ppdf_crypt_key(pdf_crypt *crypt);

/** Wrapper for `pdf_crypt_length()`. */
FZ_FUNCTION int ppdf_crypt_length(pdf_crypt *crypt);

/** Wrapper for `pdf_crypt_method()`. */
FZ_FUNCTION char *ppdf_crypt_method(pdf_crypt *crypt);

/** Wrapper for `pdf_crypt_obj()`. */
FZ_FUNCTION void ppdf_crypt_obj(pdf_crypt *crypt, pdf_obj *obj, int num, int gen);

/** Wrapper for `pdf_crypt_owner_encryption()`. */
FZ_FUNCTION unsigned char *ppdf_crypt_owner_encryption(pdf_crypt *crypt);

/** Wrapper for `pdf_crypt_owner_password()`. */
FZ_FUNCTION unsigned char *ppdf_crypt_owner_password(pdf_crypt *crypt);

/** Wrapper for `pdf_crypt_permissions()`. */
FZ_FUNCTION int ppdf_crypt_permissions(pdf_crypt *crypt);

/** Wrapper for `pdf_crypt_permissions_encryption()`. */
FZ_FUNCTION unsigned char *ppdf_crypt_permissions_encryption(pdf_crypt *crypt);

/** Wrapper for `pdf_crypt_revision()`. */
FZ_FUNCTION int ppdf_crypt_revision(pdf_crypt *crypt);

/** Wrapper for `pdf_crypt_user_encryption()`. */
FZ_FUNCTION unsigned char *ppdf_crypt_user_encryption(pdf_crypt *crypt);

/** Wrapper for `pdf_crypt_user_password()`. */
FZ_FUNCTION unsigned char *ppdf_crypt_user_password(pdf_crypt *crypt);

/** Wrapper for `pdf_crypt_version()`. */
FZ_FUNCTION int ppdf_crypt_version(pdf_crypt *crypt);

/** Wrapper for `pdf_debug_doc_changes()`. */
FZ_FUNCTION void ppdf_debug_doc_changes(pdf_document *doc);

/** Wrapper for `pdf_debug_obj()`. */
FZ_FUNCTION void ppdf_debug_obj(pdf_obj *obj);

/** Wrapper for `pdf_debug_ref()`. */
FZ_FUNCTION void ppdf_debug_ref(pdf_obj *obj);

/** Wrapper for `pdf_decode_cmap()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_decode_cmap(pdf_cmap *cmap, unsigned char *s, unsigned char *e)` => `(int, unsigned int cpt)`
*/
FZ_FUNCTION int ppdf_decode_cmap(pdf_cmap *cmap, unsigned char *s, unsigned char *e, 
		#ifdef SWIG
			unsigned int *OUTPUT
		#else
			unsigned int *cpt
		#endif
		);

/** Wrapper for `pdf_deep_copy_obj()`. */
FZ_FUNCTION pdf_obj *ppdf_deep_copy_obj(pdf_obj *obj);

/** Wrapper for `pdf_delete_annot()`. */
FZ_FUNCTION void ppdf_delete_annot(pdf_page *page, pdf_annot *annot);

/** Wrapper for `pdf_delete_object()`. */
FZ_FUNCTION void ppdf_delete_object(pdf_document *doc, int num);

/** Wrapper for `pdf_delete_page()`. */
FZ_FUNCTION void ppdf_delete_page(pdf_document *doc, int number);

/** Wrapper for `pdf_delete_page_range()`. */
FZ_FUNCTION void ppdf_delete_page_range(pdf_document *doc, int start, int end);

/** Wrapper for `pdf_deselect_layer_config_ui()`. */
FZ_FUNCTION void ppdf_deselect_layer_config_ui(pdf_document *doc, int ui);

/** Wrapper for `pdf_deserialise_journal()`. */
FZ_FUNCTION void ppdf_deserialise_journal(pdf_document *doc, fz_stream *stm);

/** Wrapper for `pdf_dict_del()`. */
FZ_FUNCTION void ppdf_dict_del(pdf_obj *dict, pdf_obj *key);

/** Wrapper for `pdf_dict_dels()`. */
FZ_FUNCTION void ppdf_dict_dels(pdf_obj *dict, const char *key);

/** Wrapper for `pdf_dict_get()`. */
FZ_FUNCTION pdf_obj *ppdf_dict_get(pdf_obj *dict, pdf_obj *key);

/** Wrapper for `pdf_dict_get_bool()`. */
FZ_FUNCTION int ppdf_dict_get_bool(pdf_obj *dict, pdf_obj *key);

/** Wrapper for `pdf_dict_get_date()`. */
FZ_FUNCTION int64_t ppdf_dict_get_date(pdf_obj *dict, pdf_obj *key);

/** Wrapper for `pdf_dict_get_inheritable()`. */
FZ_FUNCTION pdf_obj *ppdf_dict_get_inheritable(pdf_obj *dict, pdf_obj *key);

/** Wrapper for `pdf_dict_get_int()`. */
FZ_FUNCTION int ppdf_dict_get_int(pdf_obj *dict, pdf_obj *key);

/** Wrapper for `pdf_dict_get_key()`. */
FZ_FUNCTION pdf_obj *ppdf_dict_get_key(pdf_obj *dict, int idx);

/** Wrapper for `pdf_dict_get_matrix()`. */
FZ_FUNCTION fz_matrix ppdf_dict_get_matrix(pdf_obj *dict, pdf_obj *key);

/** Wrapper for `pdf_dict_get_name()`. */
FZ_FUNCTION const char *ppdf_dict_get_name(pdf_obj *dict, pdf_obj *key);

/** Wrapper for `pdf_dict_get_put_drop()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_dict_get_put_drop(pdf_obj *dict, pdf_obj *key, pdf_obj *val, pdf_obj **old_val)` => 
*/
FZ_FUNCTION void ppdf_dict_get_put_drop(pdf_obj *dict, pdf_obj *key, pdf_obj *val, 
		#ifdef SWIG
			pdf_obj **OUTPUT
		#else
			pdf_obj **old_val
		#endif
		);

/** Wrapper for `pdf_dict_get_real()`. */
FZ_FUNCTION float ppdf_dict_get_real(pdf_obj *dict, pdf_obj *key);

/** Wrapper for `pdf_dict_get_rect()`. */
FZ_FUNCTION fz_rect ppdf_dict_get_rect(pdf_obj *dict, pdf_obj *key);

/** Wrapper for `pdf_dict_get_string()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_dict_get_string(pdf_obj *dict, pdf_obj *key)` => `(const char *, size_t sizep)`
*/
FZ_FUNCTION const char *ppdf_dict_get_string(pdf_obj *dict, pdf_obj *key, 
		#ifdef SWIG
			size_t *OUTPUT
		#else
			size_t *sizep
		#endif
		);

/** Wrapper for `pdf_dict_get_text_string()`. */
FZ_FUNCTION const char *ppdf_dict_get_text_string(pdf_obj *dict, pdf_obj *key);

/** Wrapper for `pdf_dict_get_val()`. */
FZ_FUNCTION pdf_obj *ppdf_dict_get_val(pdf_obj *dict, int idx);

/** Wrapper for `pdf_dict_geta()`. */
FZ_FUNCTION pdf_obj *ppdf_dict_geta(pdf_obj *dict, pdf_obj *key, pdf_obj *abbrev);

/** Wrapper for `pdf_dict_getp()`. */
FZ_FUNCTION pdf_obj *ppdf_dict_getp(pdf_obj *dict, const char *path);

/** Wrapper for `pdf_dict_getp_inheritable()`. */
FZ_FUNCTION pdf_obj *ppdf_dict_getp_inheritable(pdf_obj *dict, const char *path);

/** Wrapper for `pdf_dict_gets()`. */
FZ_FUNCTION pdf_obj *ppdf_dict_gets(pdf_obj *dict, const char *key);

/** Wrapper for `pdf_dict_getsa()`. */
FZ_FUNCTION pdf_obj *ppdf_dict_getsa(pdf_obj *dict, const char *key, const char *abbrev);

/** Wrapper for `pdf_dict_len()`. */
FZ_FUNCTION int ppdf_dict_len(pdf_obj *dict);

/** Wrapper for `pdf_dict_put()`. */
FZ_FUNCTION void ppdf_dict_put(pdf_obj *dict, pdf_obj *key, pdf_obj *val);

/** Wrapper for `pdf_dict_put_array()`. */
FZ_FUNCTION pdf_obj *ppdf_dict_put_array(pdf_obj *dict, pdf_obj *key, int initial);

/** Wrapper for `pdf_dict_put_bool()`. */
FZ_FUNCTION void ppdf_dict_put_bool(pdf_obj *dict, pdf_obj *key, int x);

/** Wrapper for `pdf_dict_put_date()`. */
FZ_FUNCTION void ppdf_dict_put_date(pdf_obj *dict, pdf_obj *key, int64_t time);

/** Wrapper for `pdf_dict_put_dict()`. */
FZ_FUNCTION pdf_obj *ppdf_dict_put_dict(pdf_obj *dict, pdf_obj *key, int initial);

/** Wrapper for `pdf_dict_put_drop()`. */
FZ_FUNCTION void ppdf_dict_put_drop(pdf_obj *dict, pdf_obj *key, pdf_obj *val);

/** Wrapper for `pdf_dict_put_int()`. */
FZ_FUNCTION void ppdf_dict_put_int(pdf_obj *dict, pdf_obj *key, int64_t x);

/** Wrapper for `pdf_dict_put_matrix()`. */
FZ_FUNCTION void ppdf_dict_put_matrix(pdf_obj *dict, pdf_obj *key, fz_matrix x);

/** Wrapper for `pdf_dict_put_name()`. */
FZ_FUNCTION void ppdf_dict_put_name(pdf_obj *dict, pdf_obj *key, const char *x);

/** Wrapper for `pdf_dict_put_real()`. */
FZ_FUNCTION void ppdf_dict_put_real(pdf_obj *dict, pdf_obj *key, double x);

/** Wrapper for `pdf_dict_put_rect()`. */
FZ_FUNCTION void ppdf_dict_put_rect(pdf_obj *dict, pdf_obj *key, fz_rect x);

/** Wrapper for `pdf_dict_put_string()`. */
FZ_FUNCTION void ppdf_dict_put_string(pdf_obj *dict, pdf_obj *key, const char *x, size_t n);

/** Wrapper for `pdf_dict_put_text_string()`. */
FZ_FUNCTION void ppdf_dict_put_text_string(pdf_obj *dict, pdf_obj *key, const char *x);

/** Wrapper for `pdf_dict_put_val_null()`. */
FZ_FUNCTION void ppdf_dict_put_val_null(pdf_obj *obj, int idx);

/** Wrapper for `pdf_dict_putp()`. */
FZ_FUNCTION void ppdf_dict_putp(pdf_obj *dict, const char *path, pdf_obj *val);

/** Wrapper for `pdf_dict_putp_drop()`. */
FZ_FUNCTION void ppdf_dict_putp_drop(pdf_obj *dict, const char *path, pdf_obj *val);

/** Wrapper for `pdf_dict_puts()`. */
FZ_FUNCTION void ppdf_dict_puts(pdf_obj *dict, const char *key, pdf_obj *val);

/** Wrapper for `pdf_dict_puts_dict()`. */
FZ_FUNCTION pdf_obj *ppdf_dict_puts_dict(pdf_obj *dict, const char *key, int initial);

/** Wrapper for `pdf_dict_puts_drop()`. */
FZ_FUNCTION void ppdf_dict_puts_drop(pdf_obj *dict, const char *key, pdf_obj *val);

/** Wrapper for `pdf_dirty_annot()`. */
FZ_FUNCTION void ppdf_dirty_annot(pdf_annot *annot);

/** Wrapper for `pdf_dirty_obj()`. */
FZ_FUNCTION void ppdf_dirty_obj(pdf_obj *obj);

/** Wrapper for `pdf_disable_js()`. */
FZ_FUNCTION void ppdf_disable_js(pdf_document *doc);

/** Wrapper for `pdf_discard_journal()`. */
FZ_FUNCTION void ppdf_discard_journal(pdf_journal *journal);

/** Wrapper for `pdf_doc_was_linearized()`. */
FZ_FUNCTION int ppdf_doc_was_linearized(pdf_document *doc);

/** Wrapper for `pdf_document_event_did_print()`. */
FZ_FUNCTION void ppdf_document_event_did_print(pdf_document *doc);

/** Wrapper for `pdf_document_event_did_save()`. */
FZ_FUNCTION void ppdf_document_event_did_save(pdf_document *doc);

/** Wrapper for `pdf_document_event_will_close()`. */
FZ_FUNCTION void ppdf_document_event_will_close(pdf_document *doc);

/** Wrapper for `pdf_document_event_will_print()`. */
FZ_FUNCTION void ppdf_document_event_will_print(pdf_document *doc);

/** Wrapper for `pdf_document_event_will_save()`. */
FZ_FUNCTION void ppdf_document_event_will_save(pdf_document *doc);

/** Wrapper for `pdf_document_from_fz_document()`. */
FZ_FUNCTION pdf_document *ppdf_document_from_fz_document(fz_document *ptr);

/** Wrapper for `pdf_document_language()`. */
FZ_FUNCTION fz_text_language ppdf_document_language(pdf_document *doc);

/** Wrapper for `pdf_document_output_intent()`. */
FZ_FUNCTION fz_colorspace *ppdf_document_output_intent(pdf_document *doc);

/** Wrapper for `pdf_document_permissions()`. */
FZ_FUNCTION int ppdf_document_permissions(pdf_document *doc);

/** Wrapper for `pdf_drop_annot()`. */
FZ_FUNCTION void ppdf_drop_annot(pdf_annot *annot);

/** Wrapper for `pdf_drop_cmap()`. */
FZ_FUNCTION void ppdf_drop_cmap(pdf_cmap *cmap);

/** Wrapper for `pdf_drop_cmap_imp()`. */
FZ_FUNCTION void ppdf_drop_cmap_imp(fz_storable *cmap);

/** Wrapper for `pdf_drop_crypt()`. */
FZ_FUNCTION void ppdf_drop_crypt(pdf_crypt *crypt);

/** Wrapper for `pdf_drop_document()`. */
FZ_FUNCTION void ppdf_drop_document(pdf_document *doc);

/** Wrapper for `pdf_drop_font()`. */
FZ_FUNCTION void ppdf_drop_font(pdf_font_desc *font);

/** Wrapper for `pdf_drop_function()`. */
FZ_FUNCTION void ppdf_drop_function(pdf_function *func);

/** Wrapper for `pdf_drop_graft_map()`. */
FZ_FUNCTION void ppdf_drop_graft_map(pdf_graft_map *map);

/** Wrapper for `pdf_drop_journal()`. */
FZ_FUNCTION void ppdf_drop_journal(pdf_journal *journal);

/** Wrapper for `pdf_drop_js()`. */
FZ_FUNCTION void ppdf_drop_js(pdf_js *js);

/** Wrapper for `pdf_drop_local_xref()`. */
FZ_FUNCTION void ppdf_drop_local_xref(pdf_xref *xref);

/** Wrapper for `pdf_drop_local_xref_and_resources()`. */
FZ_FUNCTION void ppdf_drop_local_xref_and_resources(pdf_document *doc);

/** Wrapper for `pdf_drop_locked_fields()`. */
FZ_FUNCTION void ppdf_drop_locked_fields(pdf_locked_fields *locked);

/** Wrapper for `pdf_drop_obj()`. */
FZ_FUNCTION void ppdf_drop_obj(pdf_obj *obj);

/** Wrapper for `pdf_drop_ocg()`. */
FZ_FUNCTION void ppdf_drop_ocg(pdf_document *doc);

/** Wrapper for `pdf_drop_page_tree()`. */
FZ_FUNCTION void ppdf_drop_page_tree(pdf_document *doc);

/** Wrapper for `pdf_drop_pattern()`. */
FZ_FUNCTION void ppdf_drop_pattern(pdf_pattern *pat);

/** Wrapper for `pdf_drop_processor()`. */
FZ_FUNCTION void ppdf_drop_processor(pdf_processor *proc);

/** Wrapper for `pdf_drop_resource_tables()`. */
FZ_FUNCTION void ppdf_drop_resource_tables(pdf_document *doc);

/** Wrapper for `pdf_drop_signer()`. */
FZ_FUNCTION void ppdf_drop_signer(pdf_pkcs7_signer *signer);

/** Wrapper for `pdf_drop_verifier()`. */
FZ_FUNCTION void ppdf_drop_verifier(pdf_pkcs7_verifier *verifier);

/** Wrapper for `pdf_drop_widget()`. */
FZ_FUNCTION void ppdf_drop_widget(pdf_annot *widget);

/** Wrapper for `pdf_edit_text_field_value()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_edit_text_field_value(pdf_annot *widget, const char *value, const char *change)` => `(int, int selStart, int selEnd, char *newvalue)`
*/
FZ_FUNCTION int ppdf_edit_text_field_value(pdf_annot *widget, const char *value, const char *change, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *selStart
		#endif
		, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *selEnd
		#endif
		, 
		#ifdef SWIG
			char **OUTPUT
		#else
			char **newvalue
		#endif
		);

/** Wrapper for `pdf_embedded_file_name()`. */
FZ_FUNCTION const char *ppdf_embedded_file_name(pdf_obj *fs);

/** Wrapper for `pdf_embedded_file_stream()`. */
FZ_FUNCTION pdf_obj *ppdf_embedded_file_stream(pdf_obj *fs);

/** Wrapper for `pdf_embedded_file_type()`. */
FZ_FUNCTION const char *ppdf_embedded_file_type(pdf_obj *fs);

/** Wrapper for `pdf_empty_store()`. */
FZ_FUNCTION void ppdf_empty_store(pdf_document *doc);

/** Wrapper for `pdf_enable_journal()`. */
FZ_FUNCTION void ppdf_enable_journal(pdf_document *doc);

/** Wrapper for `pdf_enable_js()`. */
FZ_FUNCTION void ppdf_enable_js(pdf_document *doc);

/** Wrapper for `pdf_encrypt_data()`. */
FZ_FUNCTION void ppdf_encrypt_data(pdf_crypt *crypt, int num, int gen, void (*fmt_str_out)(fz_context *, void *, const unsigned char *, size_t ), void *arg, const unsigned char *s, size_t n);

/** Wrapper for `pdf_encrypted_len()`. */
FZ_FUNCTION size_t ppdf_encrypted_len(pdf_crypt *crypt, int num, int gen, size_t len);

/** Wrapper for `pdf_end_hmtx()`. */
FZ_FUNCTION void ppdf_end_hmtx(pdf_font_desc *font);

/** Wrapper for `pdf_end_operation()`. */
FZ_FUNCTION void ppdf_end_operation(pdf_document *doc);

/** Wrapper for `pdf_end_vmtx()`. */
FZ_FUNCTION void ppdf_end_vmtx(pdf_font_desc *font);

/** Wrapper for `pdf_ensure_solid_xref()`. */
FZ_FUNCTION void ppdf_ensure_solid_xref(pdf_document *doc, int num);

/** Wrapper for `pdf_eval_function()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_eval_function(pdf_function *func, const float *in, int inlen, int outlen)` => float out
*/
FZ_FUNCTION void ppdf_eval_function(pdf_function *func, const float *in, int inlen, 
		#ifdef SWIG
			float *OUTPUT
		#else
			float *out
		#endif
		, int outlen);

/** Wrapper for `pdf_event_issue_alert()`. */
FZ_FUNCTION void ppdf_event_issue_alert(pdf_document *doc, pdf_alert_event *evt);

/** Wrapper for `pdf_event_issue_exec_menu_item()`. */
FZ_FUNCTION void ppdf_event_issue_exec_menu_item(pdf_document *doc, const char *item);

/** Wrapper for `pdf_event_issue_launch_url()`. */
FZ_FUNCTION void ppdf_event_issue_launch_url(pdf_document *doc, const char *url, int new_frame);

/** Wrapper for `pdf_event_issue_mail_doc()`. */
FZ_FUNCTION void ppdf_event_issue_mail_doc(pdf_document *doc, pdf_mail_doc_event *evt);

/** Wrapper for `pdf_event_issue_print()`. */
FZ_FUNCTION void ppdf_event_issue_print(pdf_document *doc);

/** Wrapper for `pdf_field_border_style()`. */
FZ_FUNCTION char *ppdf_field_border_style(pdf_obj *field);

/** Wrapper for `pdf_field_display()`. */
FZ_FUNCTION int ppdf_field_display(pdf_obj *field);

/** Wrapper for `pdf_field_event_calculate()`. */
FZ_FUNCTION void ppdf_field_event_calculate(pdf_document *doc, pdf_obj *field);

/** Wrapper for `pdf_field_event_format()`. */
FZ_FUNCTION char *ppdf_field_event_format(pdf_document *doc, pdf_obj *field);

/** Wrapper for `pdf_field_event_keystroke()`. */
FZ_FUNCTION int ppdf_field_event_keystroke(pdf_document *doc, pdf_obj *field, pdf_keystroke_event *evt);

/** Wrapper for `pdf_field_event_validate()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_field_event_validate(pdf_document *doc, pdf_obj *field, const char *value)` => `(int, char *newvalue)`
*/
FZ_FUNCTION int ppdf_field_event_validate(pdf_document *doc, pdf_obj *field, const char *value, 
		#ifdef SWIG
			char **OUTPUT
		#else
			char **newvalue
		#endif
		);

/** Wrapper for `pdf_field_flags()`. */
FZ_FUNCTION int ppdf_field_flags(pdf_obj *field);

/** Wrapper for `pdf_field_label()`. */
FZ_FUNCTION const char *ppdf_field_label(pdf_obj *field);

/** Wrapper for `pdf_field_name()`. */
FZ_FUNCTION char *ppdf_field_name(pdf_obj *field);

/** Wrapper for `pdf_field_reset()`. */
FZ_FUNCTION void ppdf_field_reset(pdf_document *doc, pdf_obj *field);

/** Wrapper for `pdf_field_set_border_style()`. */
FZ_FUNCTION void ppdf_field_set_border_style(pdf_obj *field, const char *text);

/** Wrapper for `pdf_field_set_button_caption()`. */
FZ_FUNCTION void ppdf_field_set_button_caption(pdf_obj *field, const char *text);

/** Wrapper for `pdf_field_set_display()`. */
FZ_FUNCTION void ppdf_field_set_display(pdf_obj *field, int d);

/** Wrapper for `pdf_field_set_fill_color()`. */
FZ_FUNCTION void ppdf_field_set_fill_color(pdf_obj *field, pdf_obj *col);

/** Wrapper for `pdf_field_set_text_color()`. */
FZ_FUNCTION void ppdf_field_set_text_color(pdf_obj *field, pdf_obj *col);

/** Wrapper for `pdf_field_type()`. */
FZ_FUNCTION int ppdf_field_type(pdf_obj *field);

/** Wrapper for `pdf_field_type_string()`. */
FZ_FUNCTION const char *ppdf_field_type_string(pdf_obj *field);

/** Wrapper for `pdf_field_value()`. */
FZ_FUNCTION const char *ppdf_field_value(pdf_obj *field);

/** Wrapper for `pdf_filter_annot_contents()`. */
FZ_FUNCTION void ppdf_filter_annot_contents(pdf_document *doc, pdf_annot *annot, pdf_filter_options *filter);

/** Wrapper for `pdf_filter_page_contents()`. */
FZ_FUNCTION void ppdf_filter_page_contents(pdf_document *doc, pdf_page *page, pdf_filter_options *filter);

/** Wrapper for `pdf_filter_xobject_instance()`. */
FZ_FUNCTION pdf_obj *ppdf_filter_xobject_instance(pdf_obj *old_xobj, pdf_obj *page_res, fz_matrix ctm, pdf_filter_options *filter);

/** Wrapper for `pdf_find_font_resource()`. */
FZ_FUNCTION pdf_obj *ppdf_find_font_resource(pdf_document *doc, int type, int encoding, fz_font *item, pdf_font_resource_key *key);

/** Wrapper for `pdf_find_item()`. */
FZ_FUNCTION void *ppdf_find_item(fz_store_drop_fn *drop, pdf_obj *key);

/** Wrapper for `pdf_find_locked_fields()`. */
FZ_FUNCTION pdf_locked_fields *ppdf_find_locked_fields(pdf_document *doc, int version);

/** Wrapper for `pdf_find_locked_fields_for_sig()`. */
FZ_FUNCTION pdf_locked_fields *ppdf_find_locked_fields_for_sig(pdf_document *doc, pdf_obj *sig);

/** Wrapper for `pdf_find_version_for_obj()`. */
FZ_FUNCTION int ppdf_find_version_for_obj(pdf_document *doc, pdf_obj *obj);

/** Wrapper for `pdf_first_annot()`. */
FZ_FUNCTION pdf_annot *ppdf_first_annot(pdf_page *page);

/** Wrapper for `pdf_first_widget()`. */
FZ_FUNCTION pdf_annot *ppdf_first_widget(pdf_page *page);

/** Wrapper for `pdf_flatten_inheritable_page_items()`. */
FZ_FUNCTION void ppdf_flatten_inheritable_page_items(pdf_obj *page);

/** Wrapper for `pdf_font_cid_to_gid()`. */
FZ_FUNCTION int ppdf_font_cid_to_gid(pdf_font_desc *fontdesc, int cid);

/** Wrapper for `pdf_font_writing_supported()`. */
FZ_FUNCTION int ppdf_font_writing_supported(fz_font *font);

/** Wrapper for `pdf_forget_xref()`. */
FZ_FUNCTION void ppdf_forget_xref(pdf_document *doc);

/** Wrapper for `pdf_format_date()`. */
FZ_FUNCTION char *ppdf_format_date(int64_t time, char *s, size_t n);

/** Wrapper for `pdf_format_link_uri()`. */
FZ_FUNCTION char *ppdf_format_link_uri(fz_link_dest dest);

/** Wrapper for `pdf_format_write_options()`. */
FZ_FUNCTION char *ppdf_format_write_options(char *buffer, size_t buffer_len, const pdf_write_options *opts);

/** Wrapper for `pdf_function_size()`. */
FZ_FUNCTION size_t ppdf_function_size(pdf_function *func);

/** Wrapper for `pdf_get_bound_document()`. */
FZ_FUNCTION pdf_document *ppdf_get_bound_document(pdf_obj *obj);

/** Wrapper for `pdf_get_doc_event_callback_data()`. */
FZ_FUNCTION void *ppdf_get_doc_event_callback_data(pdf_document *doc);

/** Wrapper for `pdf_get_incremental_xref_entry()`. */
FZ_FUNCTION pdf_xref_entry *ppdf_get_incremental_xref_entry(pdf_document *doc, int i);

/** Wrapper for `pdf_get_indirect_document()`. */
FZ_FUNCTION pdf_document *ppdf_get_indirect_document(pdf_obj *obj);

/** Wrapper for `pdf_get_populating_xref_entry()`. */
FZ_FUNCTION pdf_xref_entry *ppdf_get_populating_xref_entry(pdf_document *doc, int i);

/** Wrapper for `pdf_get_widget_editing_state()`. */
FZ_FUNCTION int ppdf_get_widget_editing_state(pdf_annot *widget);

/** Wrapper for `pdf_get_xref_entry()`. */
FZ_FUNCTION pdf_xref_entry *ppdf_get_xref_entry(pdf_document *doc, int i);

/** Wrapper for `pdf_graft_mapped_object()`. */
FZ_FUNCTION pdf_obj *ppdf_graft_mapped_object(pdf_graft_map *map, pdf_obj *obj);

/** Wrapper for `pdf_graft_mapped_page()`. */
FZ_FUNCTION void ppdf_graft_mapped_page(pdf_graft_map *map, int page_to, pdf_document *src, int page_from);

/** Wrapper for `pdf_graft_object()`. */
FZ_FUNCTION pdf_obj *ppdf_graft_object(pdf_document *dst, pdf_obj *obj);

/** Wrapper for `pdf_graft_page()`. */
FZ_FUNCTION void ppdf_graft_page(pdf_document *dst, int page_to, pdf_document *src, int page_from);

/** Wrapper for `pdf_guess_mime_type_from_file_name()`. */
FZ_FUNCTION const char *ppdf_guess_mime_type_from_file_name(const char *filename);

/** Wrapper for `pdf_has_permission()`. */
FZ_FUNCTION int ppdf_has_permission(pdf_document *doc, fz_permission p);

/** Wrapper for `pdf_has_unsaved_changes()`. */
FZ_FUNCTION int ppdf_has_unsaved_changes(pdf_document *doc);

/** Wrapper for `pdf_has_unsaved_sigs()`. */
FZ_FUNCTION int ppdf_has_unsaved_sigs(pdf_document *doc);

/** Wrapper for `pdf_insert_font_resource()`. */
FZ_FUNCTION pdf_obj *ppdf_insert_font_resource(pdf_document *doc, pdf_font_resource_key *key, pdf_obj *obj);

/** Wrapper for `pdf_insert_page()`. */
FZ_FUNCTION void ppdf_insert_page(pdf_document *doc, int at, pdf_obj *page);

/** Wrapper for `pdf_invalidate_xfa()`. */
FZ_FUNCTION void ppdf_invalidate_xfa(pdf_document *doc);

/** Wrapper for `pdf_is_array()`. */
FZ_FUNCTION int ppdf_is_array(pdf_obj *obj);

/** Wrapper for `pdf_is_bool()`. */
FZ_FUNCTION int ppdf_is_bool(pdf_obj *obj);

/** Wrapper for `pdf_is_dict()`. */
FZ_FUNCTION int ppdf_is_dict(pdf_obj *obj);

/** Wrapper for `pdf_is_embedded_file()`. */
FZ_FUNCTION int ppdf_is_embedded_file(pdf_obj *fs);

/** Wrapper for `pdf_is_field_locked()`. */
FZ_FUNCTION int ppdf_is_field_locked(pdf_locked_fields *locked, const char *name);

/** Wrapper for `pdf_is_indirect()`. */
FZ_FUNCTION int ppdf_is_indirect(pdf_obj *obj);

/** Wrapper for `pdf_is_int()`. */
FZ_FUNCTION int ppdf_is_int(pdf_obj *obj);

/** Wrapper for `pdf_is_jpx_image()`. */
FZ_FUNCTION int ppdf_is_jpx_image(pdf_obj *dict);

/** Wrapper for `pdf_is_local_object()`. */
FZ_FUNCTION int ppdf_is_local_object(pdf_document *doc, pdf_obj *obj);

/** Wrapper for `pdf_is_name()`. */
FZ_FUNCTION int ppdf_is_name(pdf_obj *obj);

/** Wrapper for `pdf_is_null()`. */
FZ_FUNCTION int ppdf_is_null(pdf_obj *obj);

/** Wrapper for `pdf_is_number()`. */
FZ_FUNCTION int ppdf_is_number(pdf_obj *obj);

/** Wrapper for `pdf_is_ocg_hidden()`. */
FZ_FUNCTION int ppdf_is_ocg_hidden(pdf_document *doc, pdf_obj *rdb, const char *usage, pdf_obj *ocg);

/** Wrapper for `pdf_is_real()`. */
FZ_FUNCTION int ppdf_is_real(pdf_obj *obj);

/** Wrapper for `pdf_is_stream()`. */
FZ_FUNCTION int ppdf_is_stream(pdf_obj *obj);

/** Wrapper for `pdf_is_string()`. */
FZ_FUNCTION int ppdf_is_string(pdf_obj *obj);

/** Wrapper for `pdf_is_tint_colorspace()`. */
FZ_FUNCTION int ppdf_is_tint_colorspace(fz_colorspace *cs);

/** Wrapper for `pdf_js_event_init()`. */
FZ_FUNCTION void ppdf_js_event_init(pdf_js *js, pdf_obj *target, const char *value, int willCommit);

/** Wrapper for `pdf_js_event_init_keystroke()`. */
FZ_FUNCTION void ppdf_js_event_init_keystroke(pdf_js *js, pdf_obj *target, pdf_keystroke_event *evt);

/** Wrapper for `pdf_js_event_result()`. */
FZ_FUNCTION int ppdf_js_event_result(pdf_js *js);

/** Wrapper for `pdf_js_event_result_keystroke()`. */
FZ_FUNCTION int ppdf_js_event_result_keystroke(pdf_js *js, pdf_keystroke_event *evt);

/** Wrapper for `pdf_js_event_result_validate()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_js_event_result_validate(pdf_js *js)` => `(int, char *newvalue)`
*/
FZ_FUNCTION int ppdf_js_event_result_validate(pdf_js *js, 
		#ifdef SWIG
			char **OUTPUT
		#else
			char **newvalue
		#endif
		);

/** Wrapper for `pdf_js_event_value()`. */
FZ_FUNCTION char *ppdf_js_event_value(pdf_js *js);

/** Wrapper for `pdf_js_execute()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_js_execute(pdf_js *js, const char *name, const char *code)` => char *result
*/
FZ_FUNCTION void ppdf_js_execute(pdf_js *js, const char *name, const char *code, 
		#ifdef SWIG
			char **OUTPUT
		#else
			char **result
		#endif
		);

/** Wrapper for `pdf_js_get_console()`. */
FZ_FUNCTION pdf_js_console *ppdf_js_get_console(pdf_document *doc);

/** Wrapper for `pdf_js_set_console()`. */
FZ_FUNCTION void ppdf_js_set_console(pdf_document *doc, pdf_js_console *console, void *user);

/** Wrapper for `pdf_js_supported()`. */
FZ_FUNCTION int ppdf_js_supported(pdf_document *doc);

/** Wrapper for `pdf_keep_annot()`. */
FZ_FUNCTION pdf_annot *ppdf_keep_annot(pdf_annot *annot);

/** Wrapper for `pdf_keep_cmap()`. */
FZ_FUNCTION pdf_cmap *ppdf_keep_cmap(pdf_cmap *cmap);

/** Wrapper for `pdf_keep_document()`. */
FZ_FUNCTION pdf_document *ppdf_keep_document(pdf_document *doc);

/** Wrapper for `pdf_keep_font()`. */
FZ_FUNCTION pdf_font_desc *ppdf_keep_font(pdf_font_desc *fontdesc);

/** Wrapper for `pdf_keep_function()`. */
FZ_FUNCTION pdf_function *ppdf_keep_function(pdf_function *func);

/** Wrapper for `pdf_keep_graft_map()`. */
FZ_FUNCTION pdf_graft_map *ppdf_keep_graft_map(pdf_graft_map *map);

/** Wrapper for `pdf_keep_obj()`. */
FZ_FUNCTION pdf_obj *ppdf_keep_obj(pdf_obj *obj);

/** Wrapper for `pdf_keep_pattern()`. */
FZ_FUNCTION pdf_pattern *ppdf_keep_pattern(pdf_pattern *pat);

/** Wrapper for `pdf_keep_processor()`. */
FZ_FUNCTION pdf_processor *ppdf_keep_processor(pdf_processor *proc);

/** Wrapper for `pdf_keep_widget()`. */
FZ_FUNCTION pdf_annot *ppdf_keep_widget(pdf_annot *widget);

/** Wrapper for `pdf_layer_config_info()`. */
FZ_FUNCTION void ppdf_layer_config_info(pdf_document *doc, int config_num, pdf_layer_config *info);

/** Wrapper for `pdf_layer_config_ui_info()`. */
FZ_FUNCTION void ppdf_layer_config_ui_info(pdf_document *doc, int ui, pdf_layer_config_ui *info);

/** Wrapper for `pdf_layout_fit_text()`. */
FZ_FUNCTION fz_text *ppdf_layout_fit_text(fz_font *font, fz_text_language lang, const char *str, fz_rect bounds);

/** Wrapper for `pdf_layout_text_widget()`. */
FZ_FUNCTION fz_layout_block *ppdf_layout_text_widget(pdf_annot *annot);

/** Wrapper for `pdf_lex()`. */
FZ_FUNCTION pdf_token ppdf_lex(fz_stream *f, pdf_lexbuf *lexbuf);

/** Wrapper for `pdf_lex_no_string()`. */
FZ_FUNCTION pdf_token ppdf_lex_no_string(fz_stream *f, pdf_lexbuf *lexbuf);

/** Wrapper for `pdf_lexbuf_fin()`. */
FZ_FUNCTION void ppdf_lexbuf_fin(pdf_lexbuf *lexbuf);

/** Wrapper for `pdf_lexbuf_grow()`. */
FZ_FUNCTION ptrdiff_t ppdf_lexbuf_grow(pdf_lexbuf *lexbuf);

/** Wrapper for `pdf_lexbuf_init()`. */
FZ_FUNCTION void ppdf_lexbuf_init(pdf_lexbuf *lexbuf, int size);

/** Wrapper for `pdf_line_ending_from_name()`. */
FZ_FUNCTION enum pdf_line_ending ppdf_line_ending_from_name(pdf_obj *end);

/** Wrapper for `pdf_line_ending_from_string()`. */
FZ_FUNCTION enum pdf_line_ending ppdf_line_ending_from_string(const char *end);

/** Wrapper for `pdf_load_builtin_cmap()`. */
FZ_FUNCTION pdf_cmap *ppdf_load_builtin_cmap(const char *name);

/** Wrapper for `pdf_load_cmap()`. */
FZ_FUNCTION pdf_cmap *ppdf_load_cmap(fz_stream *file);

/** Wrapper for `pdf_load_colorspace()`. */
FZ_FUNCTION fz_colorspace *ppdf_load_colorspace(pdf_obj *obj);

/** Wrapper for `pdf_load_compressed_inline_image()`. */
FZ_FUNCTION void ppdf_load_compressed_inline_image(pdf_document *doc, pdf_obj *dict, int length, fz_stream *cstm, int indexed, fz_compressed_image *image);

/** Wrapper for `pdf_load_compressed_stream()`. */
FZ_FUNCTION fz_compressed_buffer *ppdf_load_compressed_stream(pdf_document *doc, int num);

/** Wrapper for `pdf_load_default_colorspaces()`. */
FZ_FUNCTION fz_default_colorspaces *ppdf_load_default_colorspaces(pdf_document *doc, pdf_page *page);

/** Wrapper for `pdf_load_embedded_cmap()`. */
FZ_FUNCTION pdf_cmap *ppdf_load_embedded_cmap(pdf_document *doc, pdf_obj *ref);

/** Wrapper for `pdf_load_embedded_file()`. */
FZ_FUNCTION fz_buffer *ppdf_load_embedded_file(pdf_obj *fs);

/** Wrapper for `pdf_load_encoding()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_load_encoding(const char *encoding)` => const char *estrings
*/
FZ_FUNCTION void ppdf_load_encoding(
		#ifdef SWIG
			const char **OUTPUT
		#else
			const char **estrings
		#endif
		, const char *encoding);

/** Wrapper for `pdf_load_font()`. */
FZ_FUNCTION pdf_font_desc *ppdf_load_font(pdf_document *doc, pdf_obj *rdb, pdf_obj *obj);

/** Wrapper for `pdf_load_function()`. */
FZ_FUNCTION pdf_function *ppdf_load_function(pdf_obj *ref, int in, int out);

/** Wrapper for `pdf_load_hail_mary_font()`. */
FZ_FUNCTION pdf_font_desc *ppdf_load_hail_mary_font(pdf_document *doc);

/** Wrapper for `pdf_load_image()`. */
FZ_FUNCTION fz_image *ppdf_load_image(pdf_document *doc, pdf_obj *obj);

/** Wrapper for `pdf_load_inline_image()`. */
FZ_FUNCTION fz_image *ppdf_load_inline_image(pdf_document *doc, pdf_obj *rdb, pdf_obj *dict, fz_stream *file);

/** Wrapper for `pdf_load_journal()`. */
FZ_FUNCTION void ppdf_load_journal(pdf_document *doc, const char *filename);

/** Wrapper for `pdf_load_link_annots()`. */
FZ_FUNCTION fz_link *ppdf_load_link_annots(pdf_document *arg_1, pdf_obj *annots, int pagenum, fz_matrix page_ctm);

/** Wrapper for `pdf_load_links()`. */
FZ_FUNCTION fz_link *ppdf_load_links(pdf_page *page);

/** Wrapper for `pdf_load_name_tree()`. */
FZ_FUNCTION pdf_obj *ppdf_load_name_tree(pdf_document *doc, pdf_obj *which);

/** Wrapper for `pdf_load_object()`. */
FZ_FUNCTION pdf_obj *ppdf_load_object(pdf_document *doc, int num);

/** Wrapper for `pdf_load_outline()`. */
FZ_FUNCTION fz_outline *ppdf_load_outline(pdf_document *doc);

/** Wrapper for `pdf_load_page()`. */
FZ_FUNCTION pdf_page *ppdf_load_page(pdf_document *doc, int number);

/** Wrapper for `pdf_load_page_imp()`. */
FZ_FUNCTION fz_page *ppdf_load_page_imp(fz_document *doc, int chapter, int number);

/** Wrapper for `pdf_load_page_tree()`. */
FZ_FUNCTION void ppdf_load_page_tree(pdf_document *doc);

/** Wrapper for `pdf_load_pattern()`. */
FZ_FUNCTION pdf_pattern *ppdf_load_pattern(pdf_document *doc, pdf_obj *obj);

/** Wrapper for `pdf_load_raw_stream()`. */
FZ_FUNCTION fz_buffer *ppdf_load_raw_stream(pdf_obj *ref);

/** Wrapper for `pdf_load_raw_stream_number()`. */
FZ_FUNCTION fz_buffer *ppdf_load_raw_stream_number(pdf_document *doc, int num);

/** Wrapper for `pdf_load_shading()`. */
FZ_FUNCTION fz_shade *ppdf_load_shading(pdf_document *doc, pdf_obj *obj);

/** Wrapper for `pdf_load_stream()`. */
FZ_FUNCTION fz_buffer *ppdf_load_stream(pdf_obj *ref);

/** Wrapper for `pdf_load_stream_number()`. */
FZ_FUNCTION fz_buffer *ppdf_load_stream_number(pdf_document *doc, int num);

/** Wrapper for `pdf_load_stream_or_string_as_utf8()`. */
FZ_FUNCTION char *ppdf_load_stream_or_string_as_utf8(pdf_obj *src);

/** Wrapper for `pdf_load_system_cmap()`. */
FZ_FUNCTION pdf_cmap *ppdf_load_system_cmap(const char *name);

/** Wrapper for `pdf_load_to_unicode()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_load_to_unicode(pdf_document *doc, pdf_font_desc *font, char *collection, pdf_obj *cmapstm)` => const char *strings
*/
FZ_FUNCTION void ppdf_load_to_unicode(pdf_document *doc, pdf_font_desc *font, 
		#ifdef SWIG
			const char **OUTPUT
		#else
			const char **strings
		#endif
		, char *collection, pdf_obj *cmapstm);

/** Wrapper for `pdf_load_type3_font()`. */
FZ_FUNCTION pdf_font_desc *ppdf_load_type3_font(pdf_document *doc, pdf_obj *rdb, pdf_obj *obj);

/** Wrapper for `pdf_load_type3_glyphs()`. */
FZ_FUNCTION void ppdf_load_type3_glyphs(pdf_document *doc, pdf_font_desc *fontdesc);

/** Wrapper for `pdf_load_unencrypted_object()`. */
FZ_FUNCTION pdf_obj *ppdf_load_unencrypted_object(pdf_document *doc, int num);

/** Wrapper for `pdf_lookup_anchor()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_lookup_anchor(pdf_document *doc, const char *name)` => `(int, float xp, float yp)`
*/
FZ_FUNCTION int ppdf_lookup_anchor(pdf_document *doc, const char *name, 
		#ifdef SWIG
			float *OUTPUT
		#else
			float *xp
		#endif
		, 
		#ifdef SWIG
			float *OUTPUT
		#else
			float *yp
		#endif
		);

/** Wrapper for `pdf_lookup_cmap()`. */
FZ_FUNCTION int ppdf_lookup_cmap(pdf_cmap *cmap, unsigned int cpt);

/** Wrapper for `pdf_lookup_cmap_full()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_lookup_cmap_full(pdf_cmap *cmap, unsigned int cpt)` => `(int, int out)`
*/
FZ_FUNCTION int ppdf_lookup_cmap_full(pdf_cmap *cmap, unsigned int cpt, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *out
		#endif
		);

/** Wrapper for `pdf_lookup_dest()`. */
FZ_FUNCTION pdf_obj *ppdf_lookup_dest(pdf_document *doc, pdf_obj *needle);

/** Wrapper for `pdf_lookup_field()`. */
FZ_FUNCTION pdf_obj *ppdf_lookup_field(pdf_obj *form, const char *name);

/** Wrapper for `pdf_lookup_hmtx()`. */
FZ_FUNCTION pdf_hmtx ppdf_lookup_hmtx(pdf_font_desc *font, int cid);

/** Wrapper for `pdf_lookup_metadata()`. */
FZ_FUNCTION int ppdf_lookup_metadata(pdf_document *doc, const char *key, char *ptr, int size);


/** Extra wrapper for `pdf_lookup_metadata()` that returns a std::string and sets
*o_out to length of string plus one. If <key> is not found, returns empty
string with *o_out=-1. <o_out> can be NULL if caller is not interested in
error information. */
FZ_FUNCTION std::string ppdf_lookup_metadata(pdf_document *doc, const char *key, int* o_out=NULL);

/** Wrapper for `pdf_lookup_name()`. */
FZ_FUNCTION pdf_obj *ppdf_lookup_name(pdf_document *doc, pdf_obj *which, pdf_obj *needle);

/** Wrapper for `pdf_lookup_number()`. */
FZ_FUNCTION pdf_obj *ppdf_lookup_number(pdf_obj *root, int needle);

/** Wrapper for `pdf_lookup_page_number()`. */
FZ_FUNCTION int ppdf_lookup_page_number(pdf_document *doc, pdf_obj *pageobj);

/** Wrapper for `pdf_lookup_page_obj()`. */
FZ_FUNCTION pdf_obj *ppdf_lookup_page_obj(pdf_document *doc, int needle);

/** Wrapper for `pdf_lookup_substitute_font()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_lookup_substitute_font(int mono, int serif, int bold, int italic)` => `(const unsigned char *, int len)`
*/
FZ_FUNCTION const unsigned char *ppdf_lookup_substitute_font(int mono, int serif, int bold, int italic, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *len
		#endif
		);

/** Wrapper for `pdf_lookup_vmtx()`. */
FZ_FUNCTION pdf_vmtx ppdf_lookup_vmtx(pdf_font_desc *font, int cid);

/** Wrapper for `pdf_map_one_to_many()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_map_one_to_many(pdf_cmap *cmap, unsigned int one, size_t len)` => int many
*/
FZ_FUNCTION void ppdf_map_one_to_many(pdf_cmap *cmap, unsigned int one, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *many
		#endif
		, size_t len);

/** Wrapper for `pdf_map_range_to_range()`. */
FZ_FUNCTION void ppdf_map_range_to_range(pdf_cmap *cmap, unsigned int srclo, unsigned int srchi, int dstlo);

/** Wrapper for `pdf_mark_list_free()`. */
FZ_FUNCTION void ppdf_mark_list_free(pdf_mark_list *list);

/** Wrapper for `pdf_mark_list_init()`. */
FZ_FUNCTION void ppdf_mark_list_init(pdf_mark_list *list);

/** Wrapper for `pdf_mark_list_pop()`. */
FZ_FUNCTION void ppdf_mark_list_pop(pdf_mark_list *list);

/** Wrapper for `pdf_mark_list_push()`. */
FZ_FUNCTION int ppdf_mark_list_push(pdf_mark_list *list, pdf_obj *obj);

/** Wrapper for `pdf_mark_obj()`. */
FZ_FUNCTION int ppdf_mark_obj(pdf_obj *obj);

/** Wrapper for `pdf_mark_xref()`. */
FZ_FUNCTION void ppdf_mark_xref(pdf_document *doc);

/** Wrapper for `pdf_metadata()`. */
FZ_FUNCTION pdf_obj *ppdf_metadata(pdf_document *doc);

/** Wrapper for `pdf_name_eq()`. */
FZ_FUNCTION int ppdf_name_eq(pdf_obj *a, pdf_obj *b);

/** Wrapper for `pdf_name_from_line_ending()`. */
FZ_FUNCTION pdf_obj *ppdf_name_from_line_ending(enum pdf_line_ending end);

/** Wrapper for `pdf_needs_password()`. */
FZ_FUNCTION int ppdf_needs_password(pdf_document *doc);

/** Wrapper for `pdf_new_action_from_link()`. */
FZ_FUNCTION pdf_obj *ppdf_new_action_from_link(pdf_document *doc, const char *uri);

/** Wrapper for `pdf_new_array()`. */
FZ_FUNCTION pdf_obj *ppdf_new_array(pdf_document *doc, int initialcap);

/** Wrapper for `pdf_new_buffer_processor()`. */
FZ_FUNCTION pdf_processor *ppdf_new_buffer_processor(fz_buffer *buffer, int ahxencode);

/** Wrapper for `pdf_new_cmap()`. */
FZ_FUNCTION pdf_cmap *ppdf_new_cmap();

/** Wrapper for `pdf_new_crypt()`. */
FZ_FUNCTION pdf_crypt *ppdf_new_crypt(pdf_obj *enc, pdf_obj *id);

/** Wrapper for `pdf_new_date()`. */
FZ_FUNCTION pdf_obj *ppdf_new_date(pdf_document *doc, int64_t time);

/** Wrapper for `pdf_new_destination_from_link()`. */
FZ_FUNCTION pdf_obj *ppdf_new_destination_from_link(pdf_document *doc, const char *uri);

/** Wrapper for `pdf_new_dict()`. */
FZ_FUNCTION pdf_obj *ppdf_new_dict(pdf_document *doc, int initialcap);

/** Wrapper for `pdf_new_display_list_from_annot()`. */
FZ_FUNCTION fz_display_list *ppdf_new_display_list_from_annot(pdf_annot *annot);

/** Wrapper for `pdf_new_encrypt()`. */
FZ_FUNCTION pdf_crypt *ppdf_new_encrypt(const char *opwd_utf8, const char *upwd_utf8, pdf_obj *id, int permissions, int algorithm);

/** Wrapper for `pdf_new_filter_processor()`. */
FZ_FUNCTION pdf_processor *ppdf_new_filter_processor(pdf_document *doc, pdf_processor *chain, pdf_obj *old_res, pdf_obj *new_res, int struct_parents, fz_matrix transform, pdf_filter_options *filter);

/** Wrapper for `pdf_new_font_desc()`. */
FZ_FUNCTION pdf_font_desc *ppdf_new_font_desc();

/** Wrapper for `pdf_new_graft_map()`. */
FZ_FUNCTION pdf_graft_map *ppdf_new_graft_map(pdf_document *dst);

/** Wrapper for `pdf_new_identity_cmap()`. */
FZ_FUNCTION pdf_cmap *ppdf_new_identity_cmap(int wmode, int bytes);

/** Wrapper for `pdf_new_indirect()`. */
FZ_FUNCTION pdf_obj *ppdf_new_indirect(pdf_document *doc, int num, int gen);

/** Wrapper for `pdf_new_int()`. */
FZ_FUNCTION pdf_obj *ppdf_new_int(int64_t i);

/** Wrapper for `pdf_new_local_xref()`. */
FZ_FUNCTION pdf_xref *ppdf_new_local_xref(pdf_document *doc);

/** Wrapper for `pdf_new_matrix()`. */
FZ_FUNCTION pdf_obj *ppdf_new_matrix(pdf_document *doc, fz_matrix mtx);

/** Wrapper for `pdf_new_name()`. */
FZ_FUNCTION pdf_obj *ppdf_new_name(const char *str);

/** Wrapper for `pdf_new_outline_iterator()`. */
FZ_FUNCTION fz_outline_iterator *ppdf_new_outline_iterator(pdf_document *doc);

/** Wrapper for `pdf_new_output_processor()`. */
FZ_FUNCTION pdf_processor *ppdf_new_output_processor(fz_output *out, int ahxencode);

/** Wrapper for `pdf_new_pdf_device()`. */
FZ_FUNCTION fz_device *ppdf_new_pdf_device(pdf_document *doc, fz_matrix topctm, pdf_obj *resources, fz_buffer *contents);

/** Wrapper for `pdf_new_pixmap_from_annot()`. */
FZ_FUNCTION fz_pixmap *ppdf_new_pixmap_from_annot(pdf_annot *annot, fz_matrix ctm, fz_colorspace *cs, fz_separations *seps, int alpha);

/** Wrapper for `pdf_new_pixmap_from_page_contents_with_separations_and_usage()`. */
FZ_FUNCTION fz_pixmap *ppdf_new_pixmap_from_page_contents_with_separations_and_usage(pdf_page *page, fz_matrix ctm, fz_colorspace *cs, fz_separations *seps, int alpha, const char *usage);

/** Wrapper for `pdf_new_pixmap_from_page_contents_with_usage()`. */
FZ_FUNCTION fz_pixmap *ppdf_new_pixmap_from_page_contents_with_usage(pdf_page *page, fz_matrix ctm, fz_colorspace *cs, int alpha, const char *usage);

/** Wrapper for `pdf_new_pixmap_from_page_with_separations_and_usage()`. */
FZ_FUNCTION fz_pixmap *ppdf_new_pixmap_from_page_with_separations_and_usage(pdf_page *page, fz_matrix ctm, fz_colorspace *cs, fz_separations *seps, int alpha, const char *usage);

/** Wrapper for `pdf_new_pixmap_from_page_with_usage()`. */
FZ_FUNCTION fz_pixmap *ppdf_new_pixmap_from_page_with_usage(pdf_page *page, fz_matrix ctm, fz_colorspace *cs, int alpha, const char *usage);

/** Wrapper for `pdf_new_processor()`. */
FZ_FUNCTION void *ppdf_new_processor(int size);

/** Wrapper for `pdf_new_real()`. */
FZ_FUNCTION pdf_obj *ppdf_new_real(float f);

/** Wrapper for `pdf_new_rect()`. */
FZ_FUNCTION pdf_obj *ppdf_new_rect(pdf_document *doc, fz_rect rect);

/** Wrapper for `pdf_new_run_processor()`. */
FZ_FUNCTION pdf_processor *ppdf_new_run_processor(fz_device *dev, fz_matrix ctm, const char *usage, pdf_gstate *gstate, fz_default_colorspaces *default_cs, fz_cookie *cookie);

/** Wrapper for `pdf_new_stext_page_from_annot()`. */
FZ_FUNCTION fz_stext_page *ppdf_new_stext_page_from_annot(pdf_annot *annot, const fz_stext_options *options);

/** Wrapper for `pdf_new_string()`. */
FZ_FUNCTION pdf_obj *ppdf_new_string(const char *str, size_t len);

/** Wrapper for `pdf_new_text_string()`. */
FZ_FUNCTION pdf_obj *ppdf_new_text_string(const char *s);

/** Wrapper for `pdf_new_utf8_from_pdf_stream_obj()`. */
FZ_FUNCTION char *ppdf_new_utf8_from_pdf_stream_obj(pdf_obj *src);

/** Wrapper for `pdf_new_utf8_from_pdf_string()`. */
FZ_FUNCTION char *ppdf_new_utf8_from_pdf_string(const char *srcptr, size_t srclen);

/** Wrapper for `pdf_new_utf8_from_pdf_string_obj()`. */
FZ_FUNCTION char *ppdf_new_utf8_from_pdf_string_obj(pdf_obj *src);

/** Wrapper for `pdf_new_xobject()`. */
FZ_FUNCTION pdf_obj *ppdf_new_xobject(pdf_document *doc, fz_rect bbox, fz_matrix matrix, pdf_obj *res, fz_buffer *buffer);

/** Wrapper for `pdf_next_annot()`. */
FZ_FUNCTION pdf_annot *ppdf_next_annot(pdf_annot *annot);

/** Wrapper for `pdf_next_widget()`. */
FZ_FUNCTION pdf_annot *ppdf_next_widget(pdf_annot *previous);

/** Wrapper for `pdf_obj_is_dirty()`. */
FZ_FUNCTION int ppdf_obj_is_dirty(pdf_obj *obj);

/** Wrapper for `pdf_obj_is_incremental()`. */
FZ_FUNCTION int ppdf_obj_is_incremental(pdf_obj *obj);

/** Wrapper for `pdf_obj_marked()`. */
FZ_FUNCTION int ppdf_obj_marked(pdf_obj *obj);

/** Wrapper for `pdf_obj_memo()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_obj_memo(pdf_obj *obj, int bit)` => `(int, int memo)`
*/
FZ_FUNCTION int ppdf_obj_memo(pdf_obj *obj, int bit, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *memo
		#endif
		);

/** Wrapper for `pdf_obj_num_is_stream()`. */
FZ_FUNCTION int ppdf_obj_num_is_stream(pdf_document *doc, int num);

/** Wrapper for `pdf_obj_parent_num()`. */
FZ_FUNCTION int ppdf_obj_parent_num(pdf_obj *obj);

/** Wrapper for `pdf_obj_refs()`. */
FZ_FUNCTION int ppdf_obj_refs(pdf_obj *ref);

/** Wrapper for `pdf_objcmp()`. */
FZ_FUNCTION int ppdf_objcmp(pdf_obj *a, pdf_obj *b);

/** Wrapper for `pdf_objcmp_resolve()`. */
FZ_FUNCTION int ppdf_objcmp_resolve(pdf_obj *a, pdf_obj *b);

/** Wrapper for `pdf_open_contents_stream()`. */
FZ_FUNCTION fz_stream *ppdf_open_contents_stream(pdf_document *doc, pdf_obj *obj);

/** Wrapper for `pdf_open_crypt()`. */
FZ_FUNCTION fz_stream *ppdf_open_crypt(fz_stream *chain, pdf_crypt *crypt, int num, int gen);

/** Wrapper for `pdf_open_crypt_with_filter()`. */
FZ_FUNCTION fz_stream *ppdf_open_crypt_with_filter(fz_stream *chain, pdf_crypt *crypt, pdf_obj *name, int num, int gen);

/** Wrapper for `pdf_open_document()`. */
FZ_FUNCTION pdf_document *ppdf_open_document(const char *filename);

/** Wrapper for `pdf_open_document_with_stream()`. */
FZ_FUNCTION pdf_document *ppdf_open_document_with_stream(fz_stream *file);

/** Wrapper for `pdf_open_inline_stream()`. */
FZ_FUNCTION fz_stream *ppdf_open_inline_stream(pdf_document *doc, pdf_obj *stmobj, int length, fz_stream *chain, fz_compression_params *params);

/** Wrapper for `pdf_open_raw_stream()`. */
FZ_FUNCTION fz_stream *ppdf_open_raw_stream(pdf_obj *ref);

/** Wrapper for `pdf_open_raw_stream_number()`. */
FZ_FUNCTION fz_stream *ppdf_open_raw_stream_number(pdf_document *doc, int num);

/** Wrapper for `pdf_open_stream()`. */
FZ_FUNCTION fz_stream *ppdf_open_stream(pdf_obj *ref);

/** Wrapper for `pdf_open_stream_number()`. */
FZ_FUNCTION fz_stream *ppdf_open_stream_number(pdf_document *doc, int num);

/** Wrapper for `pdf_open_stream_with_offset()`. */
FZ_FUNCTION fz_stream *ppdf_open_stream_with_offset(pdf_document *doc, int num, pdf_obj *dict, int64_t stm_ofs);

/** Wrapper for `pdf_page_contents()`. */
FZ_FUNCTION pdf_obj *ppdf_page_contents(pdf_page *page);

/** Wrapper for `pdf_page_event_close()`. */
FZ_FUNCTION void ppdf_page_event_close(pdf_page *page);

/** Wrapper for `pdf_page_event_open()`. */
FZ_FUNCTION void ppdf_page_event_open(pdf_page *page);

/** Wrapper for `pdf_page_from_fz_page()`. */
FZ_FUNCTION pdf_page *ppdf_page_from_fz_page(fz_page *ptr);

/** Wrapper for `pdf_page_group()`. */
FZ_FUNCTION pdf_obj *ppdf_page_group(pdf_page *page);

/** Wrapper for `pdf_page_obj_transform()`. */
FZ_FUNCTION void ppdf_page_obj_transform(pdf_obj *pageobj, fz_rect *page_mediabox, fz_matrix *page_ctm);

/** Wrapper for `pdf_page_presentation()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_page_presentation(pdf_page *page, fz_transition *transition)` => `(fz_transition *, float duration)`
*/
FZ_FUNCTION fz_transition *ppdf_page_presentation(pdf_page *page, fz_transition *transition, 
		#ifdef SWIG
			float *OUTPUT
		#else
			float *duration
		#endif
		);

/** Wrapper for `pdf_page_resources()`. */
FZ_FUNCTION pdf_obj *ppdf_page_resources(pdf_page *page);

/** Wrapper for `pdf_page_separations()`. */
FZ_FUNCTION fz_separations *ppdf_page_separations(pdf_page *page);

/** Wrapper for `pdf_page_transform()`. */
FZ_FUNCTION void ppdf_page_transform(pdf_page *page, fz_rect *mediabox, fz_matrix *ctm);

/** Wrapper for `pdf_page_write()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_page_write(pdf_document *doc, fz_rect mediabox, pdf_obj **presources, fz_buffer **pcontents)` => `(fz_device *)`
*/
FZ_FUNCTION fz_device *ppdf_page_write(pdf_document *doc, fz_rect mediabox, 
		#ifdef SWIG
			pdf_obj **OUTPUT
		#else
			pdf_obj **presources
		#endif
		, 
		#ifdef SWIG
			fz_buffer **OUTPUT
		#else
			fz_buffer **pcontents
		#endif
		);

/** Wrapper for `pdf_parse_array()`. */
FZ_FUNCTION pdf_obj *ppdf_parse_array(pdf_document *doc, fz_stream *f, pdf_lexbuf *buf);

/** Wrapper for `pdf_parse_date()`. */
FZ_FUNCTION int64_t ppdf_parse_date(const char *s);

/** Wrapper for `pdf_parse_default_appearance()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_parse_default_appearance(const char *da, float color[4])` => `(const char *font, float size, int n)`
*/
FZ_FUNCTION void ppdf_parse_default_appearance(const char *da, 
		#ifdef SWIG
			const char **OUTPUT
		#else
			const char **font
		#endif
		, 
		#ifdef SWIG
			float *OUTPUT
		#else
			float *size
		#endif
		, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *n
		#endif
		, float color[4]);

/** Wrapper for `pdf_parse_dict()`. */
FZ_FUNCTION pdf_obj *ppdf_parse_dict(pdf_document *doc, fz_stream *f, pdf_lexbuf *buf);

/** Wrapper for `pdf_parse_ind_obj()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_parse_ind_obj(pdf_document *doc, fz_stream *f)` => `(pdf_obj *, int num, int gen, int64_t stm_ofs, int try_repair)`
*/
FZ_FUNCTION pdf_obj *ppdf_parse_ind_obj(pdf_document *doc, fz_stream *f, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *num
		#endif
		, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *gen
		#endif
		, 
		#ifdef SWIG
			int64_t *OUTPUT
		#else
			int64_t *stm_ofs
		#endif
		, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *try_repair
		#endif
		);

/** Wrapper for `pdf_parse_journal_obj()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_parse_journal_obj(pdf_document *doc, fz_stream *stm, fz_buffer **ostm)` => `(pdf_obj *, int onum, int newobj)`
*/
FZ_FUNCTION pdf_obj *ppdf_parse_journal_obj(pdf_document *doc, fz_stream *stm, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *onum
		#endif
		, 
		#ifdef SWIG
			fz_buffer **OUTPUT
		#else
			fz_buffer **ostm
		#endif
		, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *newobj
		#endif
		);

/** Wrapper for `pdf_parse_link_action()`. */
FZ_FUNCTION char *ppdf_parse_link_action(pdf_document *doc, pdf_obj *obj, int pagenum);

/** Wrapper for `pdf_parse_link_dest()`. */
FZ_FUNCTION char *ppdf_parse_link_dest(pdf_document *doc, pdf_obj *obj);

/** Wrapper for `pdf_parse_link_uri()`. */
FZ_FUNCTION fz_link_dest ppdf_parse_link_uri(const char *uri);

/** Wrapper for `pdf_parse_stm_obj()`. */
FZ_FUNCTION pdf_obj *ppdf_parse_stm_obj(pdf_document *doc, fz_stream *f, pdf_lexbuf *buf);

/** Wrapper for `pdf_parse_write_options()`. */
FZ_FUNCTION pdf_write_options *ppdf_parse_write_options(pdf_write_options *opts, const char *args);

/** Wrapper for `pdf_preview_signature_as_display_list()`. */
FZ_FUNCTION fz_display_list *ppdf_preview_signature_as_display_list(float w, float h, fz_text_language lang, pdf_pkcs7_signer *signer, int appearance_flags, fz_image *graphic, const char *reason, const char *location);

/** Wrapper for `pdf_preview_signature_as_pixmap()`. */
FZ_FUNCTION fz_pixmap *ppdf_preview_signature_as_pixmap(int w, int h, fz_text_language lang, pdf_pkcs7_signer *signer, int appearance_flags, fz_image *graphic, const char *reason, const char *location);

/** Wrapper for `pdf_print_crypt()`. */
FZ_FUNCTION void ppdf_print_crypt(fz_output *out, pdf_crypt *crypt);

/** Wrapper for `pdf_print_default_appearance()`. */
FZ_FUNCTION void ppdf_print_default_appearance(char *buf, int nbuf, const char *font, float size, int n, const float *color);

/** Wrapper for `pdf_print_encrypted_obj()`. */
FZ_FUNCTION void ppdf_print_encrypted_obj(fz_output *out, pdf_obj *obj, int tight, int ascii, pdf_crypt *crypt, int num, int gen);

/** Wrapper for `pdf_print_font()`. */
FZ_FUNCTION void ppdf_print_font(fz_output *out, pdf_font_desc *fontdesc);

/** Wrapper for `pdf_print_obj()`. */
FZ_FUNCTION void ppdf_print_obj(fz_output *out, pdf_obj *obj, int tight, int ascii);

/** Wrapper for `pdf_process_annot()`. */
FZ_FUNCTION void ppdf_process_annot(pdf_processor *proc, pdf_annot *annot, fz_cookie *cookie);

/** Wrapper for `pdf_process_contents()`. */
FZ_FUNCTION void ppdf_process_contents(pdf_processor *proc, pdf_document *doc, pdf_obj *obj, pdf_obj *res, fz_cookie *cookie);

/** Wrapper for `pdf_process_glyph()`. */
FZ_FUNCTION void ppdf_process_glyph(pdf_processor *proc, pdf_document *doc, pdf_obj *resources, fz_buffer *contents);

/** Wrapper for `pdf_progressive_advance()`. */
FZ_FUNCTION pdf_obj *ppdf_progressive_advance(pdf_document *doc, int pagenum);

/** Wrapper for `pdf_purge_local_font_resources()`. */
FZ_FUNCTION void ppdf_purge_local_font_resources(pdf_document *doc);

/** Wrapper for `pdf_purge_locals_from_store()`. */
FZ_FUNCTION void ppdf_purge_locals_from_store(pdf_document *doc);

/** Wrapper for `pdf_read_journal()`. */
FZ_FUNCTION void ppdf_read_journal(pdf_document *doc, fz_stream *stm);

/** Wrapper for `pdf_read_ocg()`. */
FZ_FUNCTION pdf_ocg_descriptor *ppdf_read_ocg(pdf_document *doc);

/** Wrapper for `pdf_redact_page()`. */
FZ_FUNCTION int ppdf_redact_page(pdf_document *doc, pdf_page *page, pdf_redact_options *opts);

/** Wrapper for `pdf_redo()`. */
FZ_FUNCTION void ppdf_redo(pdf_document *doc);

/** Wrapper for `pdf_remove_item()`. */
FZ_FUNCTION void ppdf_remove_item(fz_store_drop_fn *drop, pdf_obj *key);

/** Wrapper for `pdf_repair_obj()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_repair_obj(pdf_document *doc, pdf_lexbuf *buf, pdf_obj **encrypt, pdf_obj **id, pdf_obj **page, pdf_obj **root)` => `(int, int64_t stmofsp, int stmlenp, int64_t tmpofs)`
*/
FZ_FUNCTION int ppdf_repair_obj(pdf_document *doc, pdf_lexbuf *buf, 
		#ifdef SWIG
			int64_t *OUTPUT
		#else
			int64_t *stmofsp
		#endif
		, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *stmlenp
		#endif
		, 
		#ifdef SWIG
			pdf_obj **OUTPUT
		#else
			pdf_obj **encrypt
		#endif
		, 
		#ifdef SWIG
			pdf_obj **OUTPUT
		#else
			pdf_obj **id
		#endif
		, 
		#ifdef SWIG
			pdf_obj **OUTPUT
		#else
			pdf_obj **page
		#endif
		, 
		#ifdef SWIG
			int64_t *OUTPUT
		#else
			int64_t *tmpofs
		#endif
		, 
		#ifdef SWIG
			pdf_obj **OUTPUT
		#else
			pdf_obj **root
		#endif
		);

/** Wrapper for `pdf_repair_obj_stms()`. */
FZ_FUNCTION void ppdf_repair_obj_stms(pdf_document *doc);

/** Wrapper for `pdf_repair_trailer()`. */
FZ_FUNCTION void ppdf_repair_trailer(pdf_document *doc);

/** Wrapper for `pdf_repair_xref()`. */
FZ_FUNCTION void ppdf_repair_xref(pdf_document *doc);

/** Wrapper for `pdf_replace_xref()`. */
FZ_FUNCTION void ppdf_replace_xref(pdf_document *doc, pdf_xref_entry *entries, int n);

/** Wrapper for `pdf_reset_form()`. */
FZ_FUNCTION void ppdf_reset_form(pdf_document *doc, pdf_obj *fields, int exclude);

/** Wrapper for `pdf_resolve_indirect()`. */
FZ_FUNCTION pdf_obj *ppdf_resolve_indirect(pdf_obj *ref);

/** Wrapper for `pdf_resolve_indirect_chain()`. */
FZ_FUNCTION pdf_obj *ppdf_resolve_indirect_chain(pdf_obj *ref);

/** Wrapper for `pdf_resolve_link()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_resolve_link(pdf_document *doc, const char *uri)` => `(int, float xp, float yp)`
*/
FZ_FUNCTION int ppdf_resolve_link(pdf_document *doc, const char *uri, 
		#ifdef SWIG
			float *OUTPUT
		#else
			float *xp
		#endif
		, 
		#ifdef SWIG
			float *OUTPUT
		#else
			float *yp
		#endif
		);

/** Wrapper for `pdf_resolve_link_dest()`. */
FZ_FUNCTION fz_link_dest ppdf_resolve_link_dest(pdf_document *doc, const char *uri);

/** Wrapper for `pdf_run_annot()`. */
FZ_FUNCTION void ppdf_run_annot(pdf_annot *annot, fz_device *dev, fz_matrix ctm, fz_cookie *cookie);

/** Wrapper for `pdf_run_glyph()`. */
FZ_FUNCTION void ppdf_run_glyph(pdf_document *doc, pdf_obj *resources, fz_buffer *contents, fz_device *dev, fz_matrix ctm, void *gstate, fz_default_colorspaces *default_cs);

/** Wrapper for `pdf_run_page()`. */
FZ_FUNCTION void ppdf_run_page(pdf_page *page, fz_device *dev, fz_matrix ctm, fz_cookie *cookie);

/** Wrapper for `pdf_run_page_annots()`. */
FZ_FUNCTION void ppdf_run_page_annots(pdf_page *page, fz_device *dev, fz_matrix ctm, fz_cookie *cookie);

/** Wrapper for `pdf_run_page_annots_with_usage()`. */
FZ_FUNCTION void ppdf_run_page_annots_with_usage(pdf_page *page, fz_device *dev, fz_matrix ctm, const char *usage, fz_cookie *cookie);

/** Wrapper for `pdf_run_page_contents()`. */
FZ_FUNCTION void ppdf_run_page_contents(pdf_page *page, fz_device *dev, fz_matrix ctm, fz_cookie *cookie);

/** Wrapper for `pdf_run_page_contents_with_usage()`. */
FZ_FUNCTION void ppdf_run_page_contents_with_usage(pdf_page *page, fz_device *dev, fz_matrix ctm, const char *usage, fz_cookie *cookie);

/** Wrapper for `pdf_run_page_widgets()`. */
FZ_FUNCTION void ppdf_run_page_widgets(pdf_page *page, fz_device *dev, fz_matrix ctm, fz_cookie *cookie);

/** Wrapper for `pdf_run_page_widgets_with_usage()`. */
FZ_FUNCTION void ppdf_run_page_widgets_with_usage(pdf_page *page, fz_device *dev, fz_matrix ctm, const char *usage, fz_cookie *cookie);

/** Wrapper for `pdf_run_page_with_usage()`. */
FZ_FUNCTION void ppdf_run_page_with_usage(pdf_page *page, fz_device *dev, fz_matrix ctm, const char *usage, fz_cookie *cookie);

/** Wrapper for `pdf_save_document()`. */
FZ_FUNCTION void ppdf_save_document(pdf_document *doc, const char *filename, const pdf_write_options *opts);

/** Wrapper for `pdf_save_journal()`. */
FZ_FUNCTION void ppdf_save_journal(pdf_document *doc, const char *filename);

/** Wrapper for `pdf_save_snapshot()`. */
FZ_FUNCTION void ppdf_save_snapshot(pdf_document *doc, const char *filename);

/** Wrapper for `pdf_select_layer_config()`. */
FZ_FUNCTION void ppdf_select_layer_config(pdf_document *doc, int config_num);

/** Wrapper for `pdf_select_layer_config_ui()`. */
FZ_FUNCTION void ppdf_select_layer_config_ui(pdf_document *doc, int ui);

/** Wrapper for `pdf_serialise_journal()`. */
FZ_FUNCTION void ppdf_serialise_journal(pdf_document *doc, fz_output *out);

/** Wrapper for `pdf_set_annot_active()`. */
FZ_FUNCTION void ppdf_set_annot_active(pdf_annot *annot, int active);

/** Wrapper for `pdf_set_annot_appearance()`. */
FZ_FUNCTION void ppdf_set_annot_appearance(pdf_annot *annot, const char *appearance, const char *state, fz_matrix ctm, fz_rect bbox, pdf_obj *res, fz_buffer *contents);

/** Wrapper for `pdf_set_annot_appearance_from_display_list()`. */
FZ_FUNCTION void ppdf_set_annot_appearance_from_display_list(pdf_annot *annot, const char *appearance, const char *state, fz_matrix ctm, fz_display_list *list);

/** Wrapper for `pdf_set_annot_author()`. */
FZ_FUNCTION void ppdf_set_annot_author(pdf_annot *annot, const char *author);

/** Wrapper for `pdf_set_annot_border()`. */
FZ_FUNCTION void ppdf_set_annot_border(pdf_annot *annot, float width);

/** Wrapper for `pdf_set_annot_color()`. */
FZ_FUNCTION void ppdf_set_annot_color(pdf_annot *annot, int n, const float *color);

/** Wrapper for `pdf_set_annot_contents()`. */
FZ_FUNCTION void ppdf_set_annot_contents(pdf_annot *annot, const char *text);

/** Wrapper for `pdf_set_annot_creation_date()`. */
FZ_FUNCTION void ppdf_set_annot_creation_date(pdf_annot *annot, int64_t time);

/** Wrapper for `pdf_set_annot_default_appearance()`. */
FZ_FUNCTION void ppdf_set_annot_default_appearance(pdf_annot *annot, const char *font, float size, int n, const float *color);

/** Wrapper for `pdf_set_annot_field_value()`. */
FZ_FUNCTION int ppdf_set_annot_field_value(pdf_document *doc, pdf_annot *widget, const char *text, int ignore_trigger_events);

/** Wrapper for `pdf_set_annot_flags()`. */
FZ_FUNCTION void ppdf_set_annot_flags(pdf_annot *annot, int flags);

/** Wrapper for `pdf_set_annot_hot()`. */
FZ_FUNCTION void ppdf_set_annot_hot(pdf_annot *annot, int hot);

/** Wrapper for `pdf_set_annot_icon_name()`. */
FZ_FUNCTION void ppdf_set_annot_icon_name(pdf_annot *annot, const char *name);

/** Wrapper for `pdf_set_annot_ink_list()`. */
FZ_FUNCTION void ppdf_set_annot_ink_list(pdf_annot *annot, int n, const int *count, const fz_point *v);

/** Wrapper for `pdf_set_annot_interior_color()`. */
FZ_FUNCTION void ppdf_set_annot_interior_color(pdf_annot *annot, int n, const float *color);

/** Wrapper for `pdf_set_annot_is_open()`. */
FZ_FUNCTION void ppdf_set_annot_is_open(pdf_annot *annot, int is_open);

/** Wrapper for `pdf_set_annot_language()`. */
FZ_FUNCTION void ppdf_set_annot_language(pdf_annot *annot, fz_text_language lang);

/** Wrapper for `pdf_set_annot_line()`. */
FZ_FUNCTION void ppdf_set_annot_line(pdf_annot *annot, fz_point a, fz_point b);

/** Wrapper for `pdf_set_annot_line_end_style()`. */
FZ_FUNCTION void ppdf_set_annot_line_end_style(pdf_annot *annot, enum pdf_line_ending e);

/** Wrapper for `pdf_set_annot_line_ending_styles()`. */
FZ_FUNCTION void ppdf_set_annot_line_ending_styles(pdf_annot *annot, enum pdf_line_ending start_style, enum pdf_line_ending end_style);

/** Wrapper for `pdf_set_annot_line_start_style()`. */
FZ_FUNCTION void ppdf_set_annot_line_start_style(pdf_annot *annot, enum pdf_line_ending s);

/** Wrapper for `pdf_set_annot_modification_date()`. */
FZ_FUNCTION void ppdf_set_annot_modification_date(pdf_annot *annot, int64_t time);

/** Wrapper for `pdf_set_annot_opacity()`. */
FZ_FUNCTION void ppdf_set_annot_opacity(pdf_annot *annot, float opacity);

/** Wrapper for `pdf_set_annot_popup()`. */
FZ_FUNCTION void ppdf_set_annot_popup(pdf_annot *annot, fz_rect rect);

/** Wrapper for `pdf_set_annot_quad_points()`. */
FZ_FUNCTION void ppdf_set_annot_quad_points(pdf_annot *annot, int n, const fz_quad *qv);

/** Wrapper for `pdf_set_annot_quadding()`. */
FZ_FUNCTION void ppdf_set_annot_quadding(pdf_annot *annot, int q);

/** Wrapper for `pdf_set_annot_rect()`. */
FZ_FUNCTION void ppdf_set_annot_rect(pdf_annot *annot, fz_rect rect);

/** Wrapper for `pdf_set_annot_resynthesised()`. */
FZ_FUNCTION void ppdf_set_annot_resynthesised(pdf_annot *annot);

/** Wrapper for `pdf_set_annot_vertex()`. */
FZ_FUNCTION void ppdf_set_annot_vertex(pdf_annot *annot, int i, fz_point p);

/** Wrapper for `pdf_set_annot_vertices()`. */
FZ_FUNCTION void ppdf_set_annot_vertices(pdf_annot *annot, int n, const fz_point *v);

/** Wrapper for `pdf_set_choice_field_value()`. */
FZ_FUNCTION int ppdf_set_choice_field_value(pdf_annot *widget, const char *value);

/** Wrapper for `pdf_set_cmap_wmode()`. */
FZ_FUNCTION void ppdf_set_cmap_wmode(pdf_cmap *cmap, int wmode);

/** Wrapper for `pdf_set_default_hmtx()`. */
FZ_FUNCTION void ppdf_set_default_hmtx(pdf_font_desc *font, int w);

/** Wrapper for `pdf_set_default_vmtx()`. */
FZ_FUNCTION void ppdf_set_default_vmtx(pdf_font_desc *font, int y, int w);

/** Wrapper for `pdf_set_doc_event_callback()`. */
FZ_FUNCTION void ppdf_set_doc_event_callback(pdf_document *doc, pdf_doc_event_cb *event_cb, pdf_free_doc_event_data_cb *free_event_data_cb, void *data);

/** Wrapper for `pdf_set_document_language()`. */
FZ_FUNCTION void ppdf_set_document_language(pdf_document *doc, fz_text_language lang);

/** Wrapper for `pdf_set_field_value()`. */
FZ_FUNCTION int ppdf_set_field_value(pdf_document *doc, pdf_obj *field, const char *text, int ignore_trigger_events);

/** Wrapper for `pdf_set_font_wmode()`. */
FZ_FUNCTION void ppdf_set_font_wmode(pdf_font_desc *font, int wmode);

/** Wrapper for `pdf_set_int()`. */
FZ_FUNCTION void ppdf_set_int(pdf_obj *obj, int64_t i);

/** Wrapper for `pdf_set_layer_config_as_default()`. */
FZ_FUNCTION void ppdf_set_layer_config_as_default(pdf_document *doc);

/** Wrapper for `pdf_set_obj_memo()`. */
FZ_FUNCTION void ppdf_set_obj_memo(pdf_obj *obj, int bit, int memo);

/** Wrapper for `pdf_set_obj_parent()`. */
FZ_FUNCTION void ppdf_set_obj_parent(pdf_obj *obj, int num);

/** Wrapper for `pdf_set_populating_xref_trailer()`. */
FZ_FUNCTION void ppdf_set_populating_xref_trailer(pdf_document *doc, pdf_obj *trailer);

/** Wrapper for `pdf_set_str_len()`. */
FZ_FUNCTION void ppdf_set_str_len(pdf_obj *obj, size_t newlen);

/** Wrapper for `pdf_set_text_field_value()`. */
FZ_FUNCTION int ppdf_set_text_field_value(pdf_annot *widget, const char *value);

/** Wrapper for `pdf_set_usecmap()`. */
FZ_FUNCTION void ppdf_set_usecmap(pdf_cmap *cmap, pdf_cmap *usecmap);

/** Wrapper for `pdf_set_widget_editing_state()`. */
FZ_FUNCTION void ppdf_set_widget_editing_state(pdf_annot *widget, int editing);

/** Wrapper for `pdf_sign_signature()`. */
FZ_FUNCTION void ppdf_sign_signature(pdf_annot *widget, pdf_pkcs7_signer *signer, int appearance_flags, fz_image *graphic, const char *reason, const char *location);

/** Wrapper for `pdf_sign_signature_with_appearance()`. */
FZ_FUNCTION void ppdf_sign_signature_with_appearance(pdf_annot *widget, pdf_pkcs7_signer *signer, int64_t date, fz_display_list *disp_list);

/** Wrapper for `pdf_signature_appearance_signed()`. */
FZ_FUNCTION fz_display_list *ppdf_signature_appearance_signed(fz_rect rect, fz_text_language lang, fz_image *img, const char *left_text, const char *right_text, int include_logo);

/** Wrapper for `pdf_signature_appearance_unsigned()`. */
FZ_FUNCTION fz_display_list *ppdf_signature_appearance_unsigned(fz_rect rect, fz_text_language lang);

/** Wrapper for `pdf_signature_byte_range()`. */
FZ_FUNCTION int ppdf_signature_byte_range(pdf_document *doc, pdf_obj *signature, fz_range *byte_range);

/** Wrapper for `pdf_signature_contents()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_signature_contents(pdf_document *doc, pdf_obj *signature)` => `(size_t, char *contents)`
*/
FZ_FUNCTION size_t ppdf_signature_contents(pdf_document *doc, pdf_obj *signature, 
		#ifdef SWIG
			char **OUTPUT
		#else
			char **contents
		#endif
		);

/** Wrapper for `pdf_signature_drop_distinguished_name()`. */
FZ_FUNCTION void ppdf_signature_drop_distinguished_name(pdf_pkcs7_distinguished_name *name);

/** Wrapper for `pdf_signature_error_description()`. */
FZ_FUNCTION char *ppdf_signature_error_description(pdf_signature_error err);

/** Wrapper for `pdf_signature_format_distinguished_name()`. */
FZ_FUNCTION char *ppdf_signature_format_distinguished_name(pdf_pkcs7_distinguished_name *name);

/** Wrapper for `pdf_signature_get_signatory()`. */
FZ_FUNCTION pdf_pkcs7_distinguished_name *ppdf_signature_get_signatory(pdf_pkcs7_verifier *verifier, pdf_document *doc, pdf_obj *signature);

/** Wrapper for `pdf_signature_get_widget_signatory()`. */
FZ_FUNCTION pdf_pkcs7_distinguished_name *ppdf_signature_get_widget_signatory(pdf_pkcs7_verifier *verifier, pdf_annot *widget);

/** Wrapper for `pdf_signature_hash_bytes()`. */
FZ_FUNCTION fz_stream *ppdf_signature_hash_bytes(pdf_document *doc, pdf_obj *signature);

/** Wrapper for `pdf_signature_incremental_change_since_signing()`. */
FZ_FUNCTION int ppdf_signature_incremental_change_since_signing(pdf_document *doc, pdf_obj *signature);

/** Wrapper for `pdf_signature_info()`. */
FZ_FUNCTION char *ppdf_signature_info(const char *name, pdf_pkcs7_distinguished_name *dn, const char *reason, const char *location, int64_t date, int include_labels);

/** Wrapper for `pdf_signature_is_signed()`. */
FZ_FUNCTION int ppdf_signature_is_signed(pdf_document *doc, pdf_obj *field);

/** Wrapper for `pdf_signature_set_value()`. */
FZ_FUNCTION void ppdf_signature_set_value(pdf_document *doc, pdf_obj *field, pdf_pkcs7_signer *signer, int64_t stime);

/** Wrapper for `pdf_sort_cmap()`. */
FZ_FUNCTION void ppdf_sort_cmap(pdf_cmap *cmap);

/** Wrapper for `pdf_sort_dict()`. */
FZ_FUNCTION void ppdf_sort_dict(pdf_obj *dict);

/** Wrapper for `pdf_specifics()`. */
FZ_FUNCTION pdf_document *ppdf_specifics(fz_document *doc);

/** Wrapper for `pdf_sprint_obj()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_sprint_obj(char *buf, size_t cap, pdf_obj *obj, int tight, int ascii)` => `(char *, size_t len)`
*/
FZ_FUNCTION char *ppdf_sprint_obj(char *buf, size_t cap, 
		#ifdef SWIG
			size_t *OUTPUT
		#else
			size_t *len
		#endif
		, pdf_obj *obj, int tight, int ascii);

/** Wrapper for `pdf_store_item()`. */
FZ_FUNCTION void ppdf_store_item(pdf_obj *key, void *val, size_t itemsize);

/** Wrapper for `pdf_string_from_annot_type()`. */
FZ_FUNCTION const char *ppdf_string_from_annot_type(enum pdf_annot_type type);

/** Wrapper for `pdf_string_from_line_ending()`. */
FZ_FUNCTION const char *ppdf_string_from_line_ending(enum pdf_line_ending end);

/** Wrapper for `pdf_text_widget_format()`. */
FZ_FUNCTION int ppdf_text_widget_format(pdf_annot *tw);

/** Wrapper for `pdf_text_widget_max_len()`. */
FZ_FUNCTION int ppdf_text_widget_max_len(pdf_annot *tw);

/** Wrapper for `pdf_to_bool()`. */
FZ_FUNCTION int ppdf_to_bool(pdf_obj *obj);

/** Wrapper for `pdf_to_date()`. */
FZ_FUNCTION int64_t ppdf_to_date(pdf_obj *time);

/** Wrapper for `pdf_to_gen()`. */
FZ_FUNCTION int ppdf_to_gen(pdf_obj *obj);

/** Wrapper for `pdf_to_int()`. */
FZ_FUNCTION int ppdf_to_int(pdf_obj *obj);

/** Wrapper for `pdf_to_int64()`. */
FZ_FUNCTION int64_t ppdf_to_int64(pdf_obj *obj);

/** Wrapper for `pdf_to_matrix()`. */
FZ_FUNCTION fz_matrix ppdf_to_matrix(pdf_obj *array);

/** Wrapper for `pdf_to_name()`. */
FZ_FUNCTION const char *ppdf_to_name(pdf_obj *obj);

/** Wrapper for `pdf_to_num()`. */
FZ_FUNCTION int ppdf_to_num(pdf_obj *obj);

/** Wrapper for `pdf_to_quad()`. */
FZ_FUNCTION fz_quad ppdf_to_quad(pdf_obj *array, int offset);

/** Wrapper for `pdf_to_real()`. */
FZ_FUNCTION float ppdf_to_real(pdf_obj *obj);

/** Wrapper for `pdf_to_rect()`. */
FZ_FUNCTION fz_rect ppdf_to_rect(pdf_obj *array);

/** Wrapper for `pdf_to_str_buf()`. */
FZ_FUNCTION char *ppdf_to_str_buf(pdf_obj *obj);

/** Wrapper for `pdf_to_str_len()`. */
FZ_FUNCTION size_t ppdf_to_str_len(pdf_obj *obj);

/** Wrapper for `pdf_to_string()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_to_string(pdf_obj *obj)` => `(const char *, size_t sizep)`
*/
FZ_FUNCTION const char *ppdf_to_string(pdf_obj *obj, 
		#ifdef SWIG
			size_t *OUTPUT
		#else
			size_t *sizep
		#endif
		);

/** Wrapper for `pdf_to_text_string()`. */
FZ_FUNCTION const char *ppdf_to_text_string(pdf_obj *obj);

/** Wrapper for `pdf_toggle_layer_config_ui()`. */
FZ_FUNCTION void ppdf_toggle_layer_config_ui(pdf_document *doc, int ui);

/** Wrapper for `pdf_toggle_widget()`. */
FZ_FUNCTION int ppdf_toggle_widget(pdf_annot *widget);

/** Wrapper for `pdf_tos_get_text()`. */
FZ_FUNCTION fz_text *ppdf_tos_get_text(pdf_text_object_state *tos);

/** Wrapper for `pdf_tos_make_trm()`. */
FZ_FUNCTION int ppdf_tos_make_trm(pdf_text_object_state *tos, pdf_text_state *text, pdf_font_desc *fontdesc, int cid, fz_matrix *trm);

/** Wrapper for `pdf_tos_move_after_char()`. */
FZ_FUNCTION void ppdf_tos_move_after_char(pdf_text_object_state *tos);

/** Wrapper for `pdf_tos_newline()`. */
FZ_FUNCTION void ppdf_tos_newline(pdf_text_object_state *tos, float leading);

/** Wrapper for `pdf_tos_reset()`. */
FZ_FUNCTION void ppdf_tos_reset(pdf_text_object_state *tos, int render);

/** Wrapper for `pdf_tos_restore()`. */
FZ_FUNCTION void ppdf_tos_restore(pdf_text_object_state *tos, fz_matrix save[2]);

/** Wrapper for `pdf_tos_save()`. */
FZ_FUNCTION void ppdf_tos_save(pdf_text_object_state *tos, fz_matrix save[2]);

/** Wrapper for `pdf_tos_set_matrix()`. */
FZ_FUNCTION void ppdf_tos_set_matrix(pdf_text_object_state *tos, float a, float b, float c, float d, float e, float f);

/** Wrapper for `pdf_tos_translate()`. */
FZ_FUNCTION void ppdf_tos_translate(pdf_text_object_state *tos, float tx, float ty);

/** Wrapper for `pdf_trailer()`. */
FZ_FUNCTION pdf_obj *ppdf_trailer(pdf_document *doc);

/** Wrapper for `pdf_undo()`. */
FZ_FUNCTION void ppdf_undo(pdf_document *doc);

/** Wrapper for `pdf_undoredo_state()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_undoredo_state(pdf_document *doc)` => `(int, int steps)`
*/
FZ_FUNCTION int ppdf_undoredo_state(pdf_document *doc, 
		#ifdef SWIG
			int *OUTPUT
		#else
			int *steps
		#endif
		);

/** Wrapper for `pdf_undoredo_step()`. */
FZ_FUNCTION const char *ppdf_undoredo_step(pdf_document *doc, int step);

/** Wrapper for `pdf_unmark_obj()`. */
FZ_FUNCTION void ppdf_unmark_obj(pdf_obj *obj);

/** Wrapper for `pdf_update_annot()`. */
FZ_FUNCTION int ppdf_update_annot(pdf_annot *annot);

/** Wrapper for `pdf_update_default_colorspaces()`. */
FZ_FUNCTION fz_default_colorspaces *ppdf_update_default_colorspaces(fz_default_colorspaces *old_cs, pdf_obj *res);

/** Wrapper for `pdf_update_object()`. */
FZ_FUNCTION void ppdf_update_object(pdf_document *doc, int num, pdf_obj *obj);

/** Wrapper for `pdf_update_page()`. */
FZ_FUNCTION int ppdf_update_page(pdf_page *page);

/** Wrapper for `pdf_update_stream()`. */
FZ_FUNCTION void ppdf_update_stream(pdf_document *doc, pdf_obj *ref, fz_buffer *buf, int compressed);

/** Wrapper for `pdf_update_widget()`. */
FZ_FUNCTION int ppdf_update_widget(pdf_annot *widget);

/** Wrapper for `pdf_update_xobject()`. */
FZ_FUNCTION void ppdf_update_xobject(pdf_document *doc, pdf_obj *xobj, fz_rect bbox, fz_matrix mat, pdf_obj *res, fz_buffer *buffer);

/** Wrapper for `pdf_validate_change_history()`. */
FZ_FUNCTION int ppdf_validate_change_history(pdf_document *doc);

/** Wrapper for `pdf_validate_changes()`. */
FZ_FUNCTION int ppdf_validate_changes(pdf_document *doc, int version);

/** Wrapper for `pdf_validate_signature()`. */
FZ_FUNCTION int ppdf_validate_signature(pdf_annot *widget);

/** Wrapper for `pdf_version()`. */
FZ_FUNCTION int ppdf_version(pdf_document *doc);

/** Wrapper for `pdf_walk_tree()`.

This function has out-params. Python/C# wrappers look like:
	`ppdf_walk_tree(pdf_obj *tree, pdf_obj *kid_name, void (*arrive)(fz_context *, pdf_obj *, void *, pdf_obj **), void (*leave)(fz_context *, pdf_obj *, void *), void *arg, pdf_obj **names, pdf_obj **values)` => `()`
*/
FZ_FUNCTION void ppdf_walk_tree(pdf_obj *tree, pdf_obj *kid_name, void (*arrive)(fz_context *, pdf_obj *, void *, pdf_obj **), void (*leave)(fz_context *, pdf_obj *, void *), void *arg, 
		#ifdef SWIG
			pdf_obj **OUTPUT
		#else
			pdf_obj **names
		#endif
		, 
		#ifdef SWIG
			pdf_obj **OUTPUT
		#else
			pdf_obj **values
		#endif
		);

/** Wrapper for `pdf_was_pure_xfa()`. */
FZ_FUNCTION int ppdf_was_pure_xfa(pdf_document *doc);

/** Wrapper for `pdf_was_repaired()`. */
FZ_FUNCTION int ppdf_was_repaired(pdf_document *doc);

/** Wrapper for `pdf_widget_is_readonly()`. */
FZ_FUNCTION int ppdf_widget_is_readonly(pdf_annot *widget);

/** Wrapper for `pdf_widget_is_signed()`. */
FZ_FUNCTION int ppdf_widget_is_signed(pdf_annot *widget);

/** Wrapper for `pdf_widget_type()`. */
FZ_FUNCTION enum pdf_widget_type ppdf_widget_type(pdf_annot *widget);

/** Wrapper for `pdf_write_digest()`. */
FZ_FUNCTION void ppdf_write_digest(fz_output *out, pdf_obj *byte_range, pdf_obj *field, size_t digest_offset, size_t digest_length, pdf_pkcs7_signer *signer);

/** Wrapper for `pdf_write_document()`. */
FZ_FUNCTION void ppdf_write_document(pdf_document *doc, fz_output *out, const pdf_write_options *opts);

/** Wrapper for `pdf_write_journal()`. */
FZ_FUNCTION void ppdf_write_journal(pdf_document *doc, fz_output *out);

/** Wrapper for `pdf_write_snapshot()`. */
FZ_FUNCTION void ppdf_write_snapshot(pdf_document *doc, fz_output *out);

/** Wrapper for `pdf_xobject_bbox()`. */
FZ_FUNCTION fz_rect ppdf_xobject_bbox(pdf_obj *xobj);

/** Wrapper for `pdf_xobject_colorspace()`. */
FZ_FUNCTION fz_colorspace *ppdf_xobject_colorspace(pdf_obj *xobj);

/** Wrapper for `pdf_xobject_isolated()`. */
FZ_FUNCTION int ppdf_xobject_isolated(pdf_obj *xobj);

/** Wrapper for `pdf_xobject_knockout()`. */
FZ_FUNCTION int ppdf_xobject_knockout(pdf_obj *xobj);

/** Wrapper for `pdf_xobject_matrix()`. */
FZ_FUNCTION fz_matrix ppdf_xobject_matrix(pdf_obj *xobj);

/** Wrapper for `pdf_xobject_resources()`. */
FZ_FUNCTION pdf_obj *ppdf_xobject_resources(pdf_obj *xobj);

/** Wrapper for `pdf_xobject_transparency()`. */
FZ_FUNCTION int ppdf_xobject_transparency(pdf_obj *xobj);

/** Wrapper for `pdf_xref_ensure_incremental_object()`. */
FZ_FUNCTION int ppdf_xref_ensure_incremental_object(pdf_document *doc, int num);

/** Wrapper for `pdf_xref_ensure_local_object()`. */
FZ_FUNCTION void ppdf_xref_ensure_local_object(pdf_document *doc, int num);

/** Wrapper for `pdf_xref_is_incremental()`. */
FZ_FUNCTION int ppdf_xref_is_incremental(pdf_document *doc, int num);

/** Wrapper for `pdf_xref_len()`. */
FZ_FUNCTION int ppdf_xref_len(pdf_document *doc);

/** Wrapper for `pdf_xref_obj_is_unsaved_signature()`. */
FZ_FUNCTION int ppdf_xref_obj_is_unsaved_signature(pdf_document *doc, pdf_obj *obj);

/** Wrapper for `pdf_xref_remove_unsaved_signature()`. */
FZ_FUNCTION void ppdf_xref_remove_unsaved_signature(pdf_document *doc, pdf_obj *field);

/** Wrapper for `pdf_xref_store_unsaved_signature()`. */
FZ_FUNCTION void ppdf_xref_store_unsaved_signature(pdf_document *doc, pdf_obj *field, pdf_pkcs7_signer *signer);


/** Returns string containing a fz_aa_context's members, labelled and inside (...), using operator<<. */
FZ_FUNCTION std::string to_string_fz_aa_context(const fz_aa_context& s);

/** Returns string containing a fz_aa_context's members, labelled and inside (...), using operator<<.
(Convenience overload). */
FZ_FUNCTION std::string to_string(const fz_aa_context& s);

/** Returns string containing a fz_color_params's members, labelled and inside (...), using operator<<. */
FZ_FUNCTION std::string to_string_fz_color_params(const fz_color_params& s);

/** Returns string containing a fz_color_params's members, labelled and inside (...), using operator<<.
(Convenience overload). */
FZ_FUNCTION std::string to_string(const fz_color_params& s);

/** Returns string containing a fz_cookie's members, labelled and inside (...), using operator<<. */
FZ_FUNCTION std::string to_string_fz_cookie(const fz_cookie& s);

/** Returns string containing a fz_cookie's members, labelled and inside (...), using operator<<.
(Convenience overload). */
FZ_FUNCTION std::string to_string(const fz_cookie& s);

/** Returns string containing a fz_draw_options's members, labelled and inside (...), using operator<<. */
FZ_FUNCTION std::string to_string_fz_draw_options(const fz_draw_options& s);

/** Returns string containing a fz_draw_options's members, labelled and inside (...), using operator<<.
(Convenience overload). */
FZ_FUNCTION std::string to_string(const fz_draw_options& s);

/** Returns string containing a fz_irect's members, labelled and inside (...), using operator<<. */
FZ_FUNCTION std::string to_string_fz_irect(const fz_irect& s);

/** Returns string containing a fz_irect's members, labelled and inside (...), using operator<<.
(Convenience overload). */
FZ_FUNCTION std::string to_string(const fz_irect& s);

/** Returns string containing a fz_location's members, labelled and inside (...), using operator<<. */
FZ_FUNCTION std::string to_string_fz_location(const fz_location& s);

/** Returns string containing a fz_location's members, labelled and inside (...), using operator<<.
(Convenience overload). */
FZ_FUNCTION std::string to_string(const fz_location& s);

/** Returns string containing a fz_matrix's members, labelled and inside (...), using operator<<. */
FZ_FUNCTION std::string to_string_fz_matrix(const fz_matrix& s);

/** Returns string containing a fz_matrix's members, labelled and inside (...), using operator<<.
(Convenience overload). */
FZ_FUNCTION std::string to_string(const fz_matrix& s);

/** Returns string containing a fz_md5's members, labelled and inside (...), using operator<<. */
FZ_FUNCTION std::string to_string_fz_md5(const fz_md5& s);

/** Returns string containing a fz_md5's members, labelled and inside (...), using operator<<.
(Convenience overload). */
FZ_FUNCTION std::string to_string(const fz_md5& s);

/** Returns string containing a fz_outline_item's members, labelled and inside (...), using operator<<. */
FZ_FUNCTION std::string to_string_fz_outline_item(const fz_outline_item& s);

/** Returns string containing a fz_outline_item's members, labelled and inside (...), using operator<<.
(Convenience overload). */
FZ_FUNCTION std::string to_string(const fz_outline_item& s);

/** Returns string containing a pdf_filter_options's members, labelled and inside (...), using operator<<. */
FZ_FUNCTION std::string to_string_pdf_filter_options(const pdf_filter_options& s);

/** Returns string containing a pdf_filter_options's members, labelled and inside (...), using operator<<.
(Convenience overload). */
FZ_FUNCTION std::string to_string(const pdf_filter_options& s);

/** Returns string containing a pdf_layer_config's members, labelled and inside (...), using operator<<. */
FZ_FUNCTION std::string to_string_pdf_layer_config(const pdf_layer_config& s);

/** Returns string containing a pdf_layer_config's members, labelled and inside (...), using operator<<.
(Convenience overload). */
FZ_FUNCTION std::string to_string(const pdf_layer_config& s);

/** Returns string containing a pdf_layer_config_ui's members, labelled and inside (...), using operator<<. */
FZ_FUNCTION std::string to_string_pdf_layer_config_ui(const pdf_layer_config_ui& s);

/** Returns string containing a pdf_layer_config_ui's members, labelled and inside (...), using operator<<.
(Convenience overload). */
FZ_FUNCTION std::string to_string(const pdf_layer_config_ui& s);

/** Returns string containing a pdf_redact_options's members, labelled and inside (...), using operator<<. */
FZ_FUNCTION std::string to_string_pdf_redact_options(const pdf_redact_options& s);

/** Returns string containing a pdf_redact_options's members, labelled and inside (...), using operator<<.
(Convenience overload). */
FZ_FUNCTION std::string to_string(const pdf_redact_options& s);

/** Returns string containing a pdf_write_options's members, labelled and inside (...), using operator<<. */
FZ_FUNCTION std::string to_string_pdf_write_options(const pdf_write_options& s);

/** Returns string containing a pdf_write_options's members, labelled and inside (...), using operator<<.
(Convenience overload). */
FZ_FUNCTION std::string to_string(const pdf_write_options& s);

/** Returns string containing a fz_pdfocr_options's members, labelled and inside (...), using operator<<. */
FZ_FUNCTION std::string to_string_fz_pdfocr_options(const fz_pdfocr_options& s);

/** Returns string containing a fz_pdfocr_options's members, labelled and inside (...), using operator<<.
(Convenience overload). */
FZ_FUNCTION std::string to_string(const fz_pdfocr_options& s);

/** Returns string containing a fz_point's members, labelled and inside (...), using operator<<. */
FZ_FUNCTION std::string to_string_fz_point(const fz_point& s);

/** Returns string containing a fz_point's members, labelled and inside (...), using operator<<.
(Convenience overload). */
FZ_FUNCTION std::string to_string(const fz_point& s);

/** Returns string containing a fz_pwg_options's members, labelled and inside (...), using operator<<. */
FZ_FUNCTION std::string to_string_fz_pwg_options(const fz_pwg_options& s);

/** Returns string containing a fz_pwg_options's members, labelled and inside (...), using operator<<.
(Convenience overload). */
FZ_FUNCTION std::string to_string(const fz_pwg_options& s);

/** Returns string containing a fz_quad's members, labelled and inside (...), using operator<<. */
FZ_FUNCTION std::string to_string_fz_quad(const fz_quad& s);

/** Returns string containing a fz_quad's members, labelled and inside (...), using operator<<.
(Convenience overload). */
FZ_FUNCTION std::string to_string(const fz_quad& s);

/** Returns string containing a fz_rect's members, labelled and inside (...), using operator<<. */
FZ_FUNCTION std::string to_string_fz_rect(const fz_rect& s);

/** Returns string containing a fz_rect's members, labelled and inside (...), using operator<<.
(Convenience overload). */
FZ_FUNCTION std::string to_string(const fz_rect& s);

/** Returns string containing a fz_stext_options's members, labelled and inside (...), using operator<<. */
FZ_FUNCTION std::string to_string_fz_stext_options(const fz_stext_options& s);

/** Returns string containing a fz_stext_options's members, labelled and inside (...), using operator<<.
(Convenience overload). */
FZ_FUNCTION std::string to_string(const fz_stext_options& s);

/** Returns string containing a fz_transition's members, labelled and inside (...), using operator<<. */
FZ_FUNCTION std::string to_string_fz_transition(const fz_transition& s);

/** Returns string containing a fz_transition's members, labelled and inside (...), using operator<<.
(Convenience overload). */
FZ_FUNCTION std::string to_string(const fz_transition& s);

} /* End of namespace mupdf. */

/** Writes fz_aa_context's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const fz_aa_context& rhs);

/** Writes fz_color_params's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const fz_color_params& rhs);

/** Writes fz_cookie's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const fz_cookie& rhs);

/** Writes fz_draw_options's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const fz_draw_options& rhs);

/** Writes fz_irect's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const fz_irect& rhs);

/** Writes fz_location's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const fz_location& rhs);

/** Writes fz_matrix's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const fz_matrix& rhs);

/** Writes fz_md5's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const fz_md5& rhs);

/** Writes fz_outline_item's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const fz_outline_item& rhs);

/** Writes pdf_filter_options's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const pdf_filter_options& rhs);

/** Writes pdf_layer_config's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const pdf_layer_config& rhs);

/** Writes pdf_layer_config_ui's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const pdf_layer_config_ui& rhs);

/** Writes pdf_redact_options's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const pdf_redact_options& rhs);

/** Writes pdf_write_options's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const pdf_write_options& rhs);

/** Writes fz_pdfocr_options's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const fz_pdfocr_options& rhs);

/** Writes fz_point's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const fz_point& rhs);

/** Writes fz_pwg_options's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const fz_pwg_options& rhs);

/** Writes fz_quad's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const fz_quad& rhs);

/** Writes fz_rect's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const fz_rect& rhs);

/** Writes fz_stext_options's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const fz_stext_options& rhs);

/** Writes fz_transition's members, labelled and inside (...), to a stream. */
FZ_FUNCTION std::ostream& operator<< (std::ostream& out, const fz_transition& rhs);

#endif
