
import ctypes
import os
import importlib

# The required .so's are in the same directory as this
# Python file. On OpenBSD we can explicitly load these
# .so's here using ctypes.cdll.LoadLibrary(), which
# avoids the need for LD_LIBRARY_PATH to be defined.
#
# Unfortunately this doesn't work on Linux.
#
for leaf in ('libmupdf.so', 'libmupdfcpp.so', '_mupdf.so'):
    path = os.path.abspath(f'{__file__}/../{leaf}')
    #print(f'path={path}')
    #print(f'exists={os.path.exists(path)}')
    ctypes.cdll.LoadLibrary( path)
    #print(f'have loaded {path}')
# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _mupdf
else:
    import _mupdf

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import weakref


def cdata(ptr, nelements=1):
    return _mupdf.cdata(ptr, nelements)

def memmove(data, indata):
    return _mupdf.memmove(data, indata)
class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _mupdf.delete_SwigPyIterator

    def value(self):
        return _mupdf.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _mupdf.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _mupdf.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _mupdf.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _mupdf.SwigPyIterator_equal(self, x)

    def copy(self):
        return _mupdf.SwigPyIterator_copy(self)

    def next(self):
        return _mupdf.SwigPyIterator_next(self)

    def __next__(self):
        return _mupdf.SwigPyIterator___next__(self)

    def previous(self):
        return _mupdf.SwigPyIterator_previous(self)

    def advance(self, n):
        return _mupdf.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _mupdf.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _mupdf.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _mupdf.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _mupdf.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _mupdf.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _mupdf.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _mupdf:
_mupdf.SwigPyIterator_swigregister(SwigPyIterator)

class uchar_array(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, nelements):
        _mupdf.uchar_array_swiginit(self, _mupdf.new_uchar_array(nelements))
    __swig_destroy__ = _mupdf.delete_uchar_array

    def __getitem__(self, index):
        return _mupdf.uchar_array___getitem__(self, index)

    def __setitem__(self, index, value):
        return _mupdf.uchar_array___setitem__(self, index, value)

    def cast(self):
        return _mupdf.uchar_array_cast(self)

    @staticmethod
    def frompointer(t):
        return _mupdf.uchar_array_frompointer(t)

# Register uchar_array in _mupdf:
_mupdf.uchar_array_swigregister(uchar_array)

def uchar_array_frompointer(t):
    return _mupdf.uchar_array_frompointer(t)

class vectoruc(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _mupdf.vectoruc_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _mupdf.vectoruc___nonzero__(self)

    def __bool__(self):
        return _mupdf.vectoruc___bool__(self)

    def __len__(self):
        return _mupdf.vectoruc___len__(self)

    def __getslice__(self, i, j):
        return _mupdf.vectoruc___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _mupdf.vectoruc___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _mupdf.vectoruc___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _mupdf.vectoruc___delitem__(self, *args)

    def __getitem__(self, *args):
        return _mupdf.vectoruc___getitem__(self, *args)

    def __setitem__(self, *args):
        return _mupdf.vectoruc___setitem__(self, *args)

    def pop(self):
        return _mupdf.vectoruc_pop(self)

    def append(self, x):
        return _mupdf.vectoruc_append(self, x)

    def empty(self):
        return _mupdf.vectoruc_empty(self)

    def size(self):
        return _mupdf.vectoruc_size(self)

    def swap(self, v):
        return _mupdf.vectoruc_swap(self, v)

    def begin(self):
        return _mupdf.vectoruc_begin(self)

    def end(self):
        return _mupdf.vectoruc_end(self)

    def rbegin(self):
        return _mupdf.vectoruc_rbegin(self)

    def rend(self):
        return _mupdf.vectoruc_rend(self)

    def clear(self):
        return _mupdf.vectoruc_clear(self)

    def get_allocator(self):
        return _mupdf.vectoruc_get_allocator(self)

    def pop_back(self):
        return _mupdf.vectoruc_pop_back(self)

    def erase(self, *args):
        return _mupdf.vectoruc_erase(self, *args)

    def __init__(self, *args):
        _mupdf.vectoruc_swiginit(self, _mupdf.new_vectoruc(*args))

    def push_back(self, x):
        return _mupdf.vectoruc_push_back(self, x)

    def front(self):
        return _mupdf.vectoruc_front(self)

    def back(self):
        return _mupdf.vectoruc_back(self)

    def assign(self, n, x):
        return _mupdf.vectoruc_assign(self, n, x)

    def resize(self, *args):
        return _mupdf.vectoruc_resize(self, *args)

    def insert(self, *args):
        return _mupdf.vectoruc_insert(self, *args)

    def reserve(self, n):
        return _mupdf.vectoruc_reserve(self, n)

    def capacity(self):
        return _mupdf.vectoruc_capacity(self)
    __swig_destroy__ = _mupdf.delete_vectoruc

# Register vectoruc in _mupdf:
_mupdf.vectoruc_swigregister(vectoruc)

class vectori(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _mupdf.vectori_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _mupdf.vectori___nonzero__(self)

    def __bool__(self):
        return _mupdf.vectori___bool__(self)

    def __len__(self):
        return _mupdf.vectori___len__(self)

    def __getslice__(self, i, j):
        return _mupdf.vectori___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _mupdf.vectori___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _mupdf.vectori___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _mupdf.vectori___delitem__(self, *args)

    def __getitem__(self, *args):
        return _mupdf.vectori___getitem__(self, *args)

    def __setitem__(self, *args):
        return _mupdf.vectori___setitem__(self, *args)

    def pop(self):
        return _mupdf.vectori_pop(self)

    def append(self, x):
        return _mupdf.vectori_append(self, x)

    def empty(self):
        return _mupdf.vectori_empty(self)

    def size(self):
        return _mupdf.vectori_size(self)

    def swap(self, v):
        return _mupdf.vectori_swap(self, v)

    def begin(self):
        return _mupdf.vectori_begin(self)

    def end(self):
        return _mupdf.vectori_end(self)

    def rbegin(self):
        return _mupdf.vectori_rbegin(self)

    def rend(self):
        return _mupdf.vectori_rend(self)

    def clear(self):
        return _mupdf.vectori_clear(self)

    def get_allocator(self):
        return _mupdf.vectori_get_allocator(self)

    def pop_back(self):
        return _mupdf.vectori_pop_back(self)

    def erase(self, *args):
        return _mupdf.vectori_erase(self, *args)

    def __init__(self, *args):
        _mupdf.vectori_swiginit(self, _mupdf.new_vectori(*args))

    def push_back(self, x):
        return _mupdf.vectori_push_back(self, x)

    def front(self):
        return _mupdf.vectori_front(self)

    def back(self):
        return _mupdf.vectori_back(self)

    def assign(self, n, x):
        return _mupdf.vectori_assign(self, n, x)

    def resize(self, *args):
        return _mupdf.vectori_resize(self, *args)

    def insert(self, *args):
        return _mupdf.vectori_insert(self, *args)

    def reserve(self, n):
        return _mupdf.vectori_reserve(self, n)

    def capacity(self):
        return _mupdf.vectori_capacity(self)
    __swig_destroy__ = _mupdf.delete_vectori

# Register vectori in _mupdf:
_mupdf.vectori_swigregister(vectori)

class vectors(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _mupdf.vectors_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _mupdf.vectors___nonzero__(self)

    def __bool__(self):
        return _mupdf.vectors___bool__(self)

    def __len__(self):
        return _mupdf.vectors___len__(self)

    def __getslice__(self, i, j):
        return _mupdf.vectors___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _mupdf.vectors___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _mupdf.vectors___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _mupdf.vectors___delitem__(self, *args)

    def __getitem__(self, *args):
        return _mupdf.vectors___getitem__(self, *args)

    def __setitem__(self, *args):
        return _mupdf.vectors___setitem__(self, *args)

    def pop(self):
        return _mupdf.vectors_pop(self)

    def append(self, x):
        return _mupdf.vectors_append(self, x)

    def empty(self):
        return _mupdf.vectors_empty(self)

    def size(self):
        return _mupdf.vectors_size(self)

    def swap(self, v):
        return _mupdf.vectors_swap(self, v)

    def begin(self):
        return _mupdf.vectors_begin(self)

    def end(self):
        return _mupdf.vectors_end(self)

    def rbegin(self):
        return _mupdf.vectors_rbegin(self)

    def rend(self):
        return _mupdf.vectors_rend(self)

    def clear(self):
        return _mupdf.vectors_clear(self)

    def get_allocator(self):
        return _mupdf.vectors_get_allocator(self)

    def pop_back(self):
        return _mupdf.vectors_pop_back(self)

    def erase(self, *args):
        return _mupdf.vectors_erase(self, *args)

    def __init__(self, *args):
        _mupdf.vectors_swiginit(self, _mupdf.new_vectors(*args))

    def push_back(self, x):
        return _mupdf.vectors_push_back(self, x)

    def front(self):
        return _mupdf.vectors_front(self)

    def back(self):
        return _mupdf.vectors_back(self)

    def assign(self, n, x):
        return _mupdf.vectors_assign(self, n, x)

    def resize(self, *args):
        return _mupdf.vectors_resize(self, *args)

    def insert(self, *args):
        return _mupdf.vectors_insert(self, *args)

    def reserve(self, n):
        return _mupdf.vectors_reserve(self, n)

    def capacity(self):
        return _mupdf.vectors_capacity(self)
    __swig_destroy__ = _mupdf.delete_vectors

# Register vectors in _mupdf:
_mupdf.vectors_swigregister(vectors)

class vectorq(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _mupdf.vectorq_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _mupdf.vectorq___nonzero__(self)

    def __bool__(self):
        return _mupdf.vectorq___bool__(self)

    def __len__(self):
        return _mupdf.vectorq___len__(self)

    def __getslice__(self, i, j):
        return _mupdf.vectorq___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _mupdf.vectorq___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _mupdf.vectorq___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _mupdf.vectorq___delitem__(self, *args)

    def __getitem__(self, *args):
        return _mupdf.vectorq___getitem__(self, *args)

    def __setitem__(self, *args):
        return _mupdf.vectorq___setitem__(self, *args)

    def pop(self):
        return _mupdf.vectorq_pop(self)

    def append(self, x):
        return _mupdf.vectorq_append(self, x)

    def empty(self):
        return _mupdf.vectorq_empty(self)

    def size(self):
        return _mupdf.vectorq_size(self)

    def swap(self, v):
        return _mupdf.vectorq_swap(self, v)

    def begin(self):
        return _mupdf.vectorq_begin(self)

    def end(self):
        return _mupdf.vectorq_end(self)

    def rbegin(self):
        return _mupdf.vectorq_rbegin(self)

    def rend(self):
        return _mupdf.vectorq_rend(self)

    def clear(self):
        return _mupdf.vectorq_clear(self)

    def get_allocator(self):
        return _mupdf.vectorq_get_allocator(self)

    def pop_back(self):
        return _mupdf.vectorq_pop_back(self)

    def erase(self, *args):
        return _mupdf.vectorq_erase(self, *args)

    def __init__(self, *args):
        _mupdf.vectorq_swiginit(self, _mupdf.new_vectorq(*args))

    def push_back(self, x):
        return _mupdf.vectorq_push_back(self, x)

    def front(self):
        return _mupdf.vectorq_front(self)

    def back(self):
        return _mupdf.vectorq_back(self)

    def assign(self, n, x):
        return _mupdf.vectorq_assign(self, n, x)

    def resize(self, *args):
        return _mupdf.vectorq_resize(self, *args)

    def insert(self, *args):
        return _mupdf.vectorq_insert(self, *args)

    def reserve(self, n):
        return _mupdf.vectorq_reserve(self, n)

    def capacity(self):
        return _mupdf.vectorq_capacity(self)
    __swig_destroy__ = _mupdf.delete_vectorq

# Register vectorq in _mupdf:
_mupdf.vectorq_swigregister(vectorq)


def new_bytes(nelements):
    return _mupdf.new_bytes(nelements)

def delete_bytes(ary):
    return _mupdf.delete_bytes(ary)

def bytes_getitem(ary, index):
    return _mupdf.bytes_getitem(ary, index)

def bytes_setitem(ary, index, value):
    return _mupdf.bytes_setitem(ary, index, value)
FZ_VERSION = _mupdf.FZ_VERSION
r"""This file was auto-generated by mupdfwrap.py."""
FZ_VERSION_MAJOR = _mupdf.FZ_VERSION_MAJOR
FZ_VERSION_MINOR = _mupdf.FZ_VERSION_MINOR
FZ_VERSION_PATCH = _mupdf.FZ_VERSION_PATCH
FZ_ENABLE_SPOT_RENDERING = _mupdf.FZ_ENABLE_SPOT_RENDERING
r"""
    Enable the following for spot (and hence overprint/overprint
    simulation) capable rendering. This forces FZ_PLOTTERS_N on.

    Choose which plotters we need.
    By default we build all the plotters in. To avoid building
    plotters in that aren't needed, define the unwanted
    FZ_PLOTTERS_... define to 0.

    Choose which document agents to include.
    By default all are enabled. To avoid building unwanted
    ones, define FZ_ENABLE_... to 0.

    Choose which document writers to include.
    By default all are enabled. To avoid building unwanted
    ones, define FZ_ENABLE_..._OUTPUT to 0.

    Choose whether to enable ICC color profiles.

    Choose whether to enable JPEG2000 decoding.
    By default, it is enabled, but due to frequent security
    issues with the third party libraries we support disabling
    it with this flag.

    Choose whether to enable JavaScript.
    By default JavaScript is enabled both for mutool and PDF
    interactivity.

    Choose which fonts to include.
    By default we include the base 14 PDF fonts,
    DroidSansFallback from Android for CJK, and
    Charis SIL from SIL for epub/html.
    Enable the following defines to AVOID including
    unwanted fonts.
    """
FZ_PLOTTERS_N = _mupdf.FZ_PLOTTERS_N
FZ_PLOTTERS_G = _mupdf.FZ_PLOTTERS_G
FZ_PLOTTERS_RGB = _mupdf.FZ_PLOTTERS_RGB
FZ_PLOTTERS_CMYK = _mupdf.FZ_PLOTTERS_CMYK
FZ_ENABLE_PDF = _mupdf.FZ_ENABLE_PDF
FZ_ENABLE_XPS = _mupdf.FZ_ENABLE_XPS
FZ_ENABLE_SVG = _mupdf.FZ_ENABLE_SVG
FZ_ENABLE_CBZ = _mupdf.FZ_ENABLE_CBZ
FZ_ENABLE_IMG = _mupdf.FZ_ENABLE_IMG
FZ_ENABLE_HTML = _mupdf.FZ_ENABLE_HTML
FZ_ENABLE_EPUB = _mupdf.FZ_ENABLE_EPUB
FZ_ENABLE_OCR_OUTPUT = _mupdf.FZ_ENABLE_OCR_OUTPUT
FZ_ENABLE_ODT_OUTPUT = _mupdf.FZ_ENABLE_ODT_OUTPUT
FZ_ENABLE_DOCX_OUTPUT = _mupdf.FZ_ENABLE_DOCX_OUTPUT
FZ_ENABLE_JPX = _mupdf.FZ_ENABLE_JPX
FZ_ENABLE_JS = _mupdf.FZ_ENABLE_JS
FZ_ENABLE_ICC = _mupdf.FZ_ENABLE_ICC
MEMENTO_PREFILL = _mupdf.MEMENTO_PREFILL
MEMENTO_POSTFILL = _mupdf.MEMENTO_POSTFILL
MEMENTO_ALLOCFILL = _mupdf.MEMENTO_ALLOCFILL
MEMENTO_FREEFILL = _mupdf.MEMENTO_FREEFILL
MEMENTO_FREELIST_MAX = _mupdf.MEMENTO_FREELIST_MAX
FZ_PI = _mupdf.FZ_PI
FZ_RADIAN = _mupdf.FZ_RADIAN
FZ_DEGREE = _mupdf.FZ_DEGREE
FZ_SQRT2 = _mupdf.FZ_SQRT2
FZ_LN2 = _mupdf.FZ_LN2
HAVE_SIGSETJMP = _mupdf.HAVE_SIGSETJMP
r"""
    Spot architectures where we have optimisations.

    Some differences in libc can be smoothed over
    """
EOF = _mupdf.EOF
SEEK_SET = _mupdf.SEEK_SET
SEEK_CUR = _mupdf.SEEK_CUR
SEEK_END = _mupdf.SEEK_END
class fz_point(object):
    r"""	fz_point is a point in a two-dimensional space."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    x = property(_mupdf.fz_point_x_get, _mupdf.fz_point_x_set)
    y = property(_mupdf.fz_point_y_get, _mupdf.fz_point_y_set)

    def __init__(self):
        _mupdf.fz_point_swiginit(self, _mupdf.new_fz_point())
    __swig_destroy__ = _mupdf.delete_fz_point

# Register fz_point in _mupdf:
_mupdf.fz_point_swigregister(fz_point)

class fz_rect(object):
    r"""
    fz_rect is a rectangle represented by two diagonally opposite
    corners at arbitrary coordinates.

    Rectangles are always axis-aligned with the X- and Y- axes. We
    wish to distinguish rectangles in 3 categories; infinite, finite,
    and invalid. Zero area rectangles are a sub-category of finite
    ones.

    For all valid rectangles, x0 <= x1 and y0 <= y1 in all cases.
    Infinite rectangles have x0 = y0 = FZ_MIN_INF_RECT,
    x1 = y1 = FZ_MAX_INF_RECT. For any non infinite valid rectangle,
    the area is defined as (x1 - x0) * (y1 - y0).

    To check for empty or infinite rectangles use fz_is_empty_rect
    and fz_is_infinite_rect. To check for valid rectangles use
    fz_is_valid_rect.

    We choose this representation, so that we can easily distinguish
    the difference between intersecting 2 valid rectangles and
    getting an invalid one, as opposed to getting a zero area one
    (which nonetheless has valid bounds within the plane).

    x0, y0: The top left corner.

    x1, y1: The bottom right corner.

    We choose FZ_{MIN,MAX}_INF_RECT to be the largest 32bit signed
    integer values that survive roundtripping to floats.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    x0 = property(_mupdf.fz_rect_x0_get, _mupdf.fz_rect_x0_set)
    y0 = property(_mupdf.fz_rect_y0_get, _mupdf.fz_rect_y0_set)
    x1 = property(_mupdf.fz_rect_x1_get, _mupdf.fz_rect_x1_set)
    y1 = property(_mupdf.fz_rect_y1_get, _mupdf.fz_rect_y1_set)

    def __init__(self):
        _mupdf.fz_rect_swiginit(self, _mupdf.new_fz_rect())
    __swig_destroy__ = _mupdf.delete_fz_rect

# Register fz_rect in _mupdf:
_mupdf.fz_rect_swigregister(fz_rect)

class fz_irect(object):
    r"""
    fz_irect is a rectangle using integers instead of floats.

    It's used in the draw device and for pixmap dimensions.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    x0 = property(_mupdf.fz_irect_x0_get, _mupdf.fz_irect_x0_set)
    y0 = property(_mupdf.fz_irect_y0_get, _mupdf.fz_irect_y0_set)
    x1 = property(_mupdf.fz_irect_x1_get, _mupdf.fz_irect_x1_set)
    y1 = property(_mupdf.fz_irect_y1_get, _mupdf.fz_irect_y1_set)

    def __init__(self):
        _mupdf.fz_irect_swiginit(self, _mupdf.new_fz_irect())
    __swig_destroy__ = _mupdf.delete_fz_irect

# Register fz_irect in _mupdf:
_mupdf.fz_irect_swigregister(fz_irect)

class fz_matrix(object):
    r"""
    	fz_matrix is a row-major 3x3 matrix used for representing
    	transformations of coordinates throughout MuPDF.

    	Since all points reside in a two-dimensional space, one vector
    	is always a constant unit vector; hence only some elements may
    	vary in a matrix. Below is how the elements map between
    	different representations.

    a b 0
    	| c d 0 | normally represented as [ a b c d e f ].
    	\ e f 1 /
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    a = property(_mupdf.fz_matrix_a_get, _mupdf.fz_matrix_a_set)
    b = property(_mupdf.fz_matrix_b_get, _mupdf.fz_matrix_b_set)
    c = property(_mupdf.fz_matrix_c_get, _mupdf.fz_matrix_c_set)
    d = property(_mupdf.fz_matrix_d_get, _mupdf.fz_matrix_d_set)
    e = property(_mupdf.fz_matrix_e_get, _mupdf.fz_matrix_e_set)
    f = property(_mupdf.fz_matrix_f_get, _mupdf.fz_matrix_f_set)

    def __init__(self):
        _mupdf.fz_matrix_swiginit(self, _mupdf.new_fz_matrix())
    __swig_destroy__ = _mupdf.delete_fz_matrix

# Register fz_matrix in _mupdf:
_mupdf.fz_matrix_swigregister(fz_matrix)
cvar = _mupdf.cvar
fz_unit_rect = cvar.fz_unit_rect
fz_empty_rect = cvar.fz_empty_rect
fz_empty_irect = cvar.fz_empty_irect
fz_infinite_rect = cvar.fz_infinite_rect
fz_infinite_irect = cvar.fz_infinite_irect

class fz_quad(object):
    r"""
    A representation for a region defined by 4 points.

    The significant difference between quads and rects is that
    the edges of quads are not axis aligned.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    ul = property(_mupdf.fz_quad_ul_get, _mupdf.fz_quad_ul_set)
    ur = property(_mupdf.fz_quad_ur_get, _mupdf.fz_quad_ur_set)
    ll = property(_mupdf.fz_quad_ll_get, _mupdf.fz_quad_ll_set)
    lr = property(_mupdf.fz_quad_lr_get, _mupdf.fz_quad_lr_set)

    def __init__(self):
        _mupdf.fz_quad_swiginit(self, _mupdf.new_fz_quad())
    __swig_destroy__ = _mupdf.delete_fz_quad

# Register fz_quad in _mupdf:
_mupdf.fz_quad_swigregister(fz_quad)
fz_identity = cvar.fz_identity

class fz_alloc_context(object):
    r"""	Allocator structure; holds callbacks and private data pointer."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    user = property(_mupdf.fz_alloc_context_user_get, _mupdf.fz_alloc_context_user_set)

    def __init__(self):
        _mupdf.fz_alloc_context_swiginit(self, _mupdf.new_fz_alloc_context())
    __swig_destroy__ = _mupdf.delete_fz_alloc_context

# Register fz_alloc_context in _mupdf:
_mupdf.fz_alloc_context_swigregister(fz_alloc_context)

FZ_ERROR_NONE = _mupdf.FZ_ERROR_NONE
FZ_ERROR_MEMORY = _mupdf.FZ_ERROR_MEMORY
FZ_ERROR_GENERIC = _mupdf.FZ_ERROR_GENERIC
FZ_ERROR_SYNTAX = _mupdf.FZ_ERROR_SYNTAX
FZ_ERROR_MINOR = _mupdf.FZ_ERROR_MINOR
FZ_ERROR_TRYLATER = _mupdf.FZ_ERROR_TRYLATER
FZ_ERROR_ABORT = _mupdf.FZ_ERROR_ABORT
FZ_ERROR_REPAIRED = _mupdf.FZ_ERROR_REPAIRED
FZ_ERROR_COUNT = _mupdf.FZ_ERROR_COUNT
class fz_locks_context(object):
    r"""
    Locking functions

    MuPDF is kept deliberately free of any knowledge of particular
    threading systems. As such, in order for safe multi-threaded
    operation, we rely on callbacks to client provided functions.

    A client is expected to provide FZ_LOCK_MAX number of mutexes,
    and a function to lock/unlock each of them. These may be
    recursive mutexes, but do not have to be.

    If a client does not intend to use multiple threads, then it
    may pass NULL instead of a lock structure.

    In order to avoid deadlocks, we have one simple rule
    internally as to how we use locks: We can never take lock n
    when we already hold any lock i, where 0 <= i <= n. In order
    to verify this, we have some debugging code, that can be
    enabled by defining FITZ_DEBUG_LOCKING.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    user = property(_mupdf.fz_locks_context_user_get, _mupdf.fz_locks_context_user_set)
    lock = property(_mupdf.fz_locks_context_lock_get, _mupdf.fz_locks_context_lock_set)
    unlock = property(_mupdf.fz_locks_context_unlock_get, _mupdf.fz_locks_context_unlock_set)

    def __init__(self):
        _mupdf.fz_locks_context_swiginit(self, _mupdf.new_fz_locks_context())
    __swig_destroy__ = _mupdf.delete_fz_locks_context

# Register fz_locks_context in _mupdf:
_mupdf.fz_locks_context_swigregister(fz_locks_context)

FZ_LOCK_ALLOC = _mupdf.FZ_LOCK_ALLOC
FZ_LOCK_FREETYPE = _mupdf.FZ_LOCK_FREETYPE
FZ_LOCK_GLYPHCACHE = _mupdf.FZ_LOCK_GLYPHCACHE
FZ_LOCK_MAX = _mupdf.FZ_LOCK_MAX
FZ_STORE_UNLIMITED = _mupdf.FZ_STORE_UNLIMITED
FZ_STORE_DEFAULT = _mupdf.FZ_STORE_DEFAULT
FZ_JMPBUF_ALIGN = _mupdf.FZ_JMPBUF_ALIGN
class fz_error_context(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    top = property(_mupdf.fz_error_context_top_get, _mupdf.fz_error_context_top_set)
    stack = property(_mupdf.fz_error_context_stack_get, _mupdf.fz_error_context_stack_set)
    padding = property(_mupdf.fz_error_context_padding_get, _mupdf.fz_error_context_padding_set)
    stack_base = property(_mupdf.fz_error_context_stack_base_get, _mupdf.fz_error_context_stack_base_set)
    errcode = property(_mupdf.fz_error_context_errcode_get, _mupdf.fz_error_context_errcode_set)
    print_user = property(_mupdf.fz_error_context_print_user_get, _mupdf.fz_error_context_print_user_set)
    _print = property(_mupdf.fz_error_context__print_get, _mupdf.fz_error_context__print_set)
    message = property(_mupdf.fz_error_context_message_get, _mupdf.fz_error_context_message_set)

    def __init__(self):
        _mupdf.fz_error_context_swiginit(self, _mupdf.new_fz_error_context())
    __swig_destroy__ = _mupdf.delete_fz_error_context

# Register fz_error_context in _mupdf:
_mupdf.fz_error_context_swigregister(fz_error_context)

class fz_warn_context(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    print_user = property(_mupdf.fz_warn_context_print_user_get, _mupdf.fz_warn_context_print_user_set)
    _print = property(_mupdf.fz_warn_context__print_get, _mupdf.fz_warn_context__print_set)
    count = property(_mupdf.fz_warn_context_count_get, _mupdf.fz_warn_context_count_set)
    message = property(_mupdf.fz_warn_context_message_get, _mupdf.fz_warn_context_message_set)

    def __init__(self):
        _mupdf.fz_warn_context_swiginit(self, _mupdf.new_fz_warn_context())
    __swig_destroy__ = _mupdf.delete_fz_warn_context

# Register fz_warn_context in _mupdf:
_mupdf.fz_warn_context_swigregister(fz_warn_context)

class fz_aa_context(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    hscale = property(_mupdf.fz_aa_context_hscale_get, _mupdf.fz_aa_context_hscale_set)
    vscale = property(_mupdf.fz_aa_context_vscale_get, _mupdf.fz_aa_context_vscale_set)
    scale = property(_mupdf.fz_aa_context_scale_get, _mupdf.fz_aa_context_scale_set)
    bits = property(_mupdf.fz_aa_context_bits_get, _mupdf.fz_aa_context_bits_set)
    text_bits = property(_mupdf.fz_aa_context_text_bits_get, _mupdf.fz_aa_context_text_bits_set)
    min_line_width = property(_mupdf.fz_aa_context_min_line_width_get, _mupdf.fz_aa_context_min_line_width_set)

    def __init__(self):
        _mupdf.fz_aa_context_swiginit(self, _mupdf.new_fz_aa_context())
    __swig_destroy__ = _mupdf.delete_fz_aa_context

# Register fz_aa_context in _mupdf:
_mupdf.fz_aa_context_swigregister(fz_aa_context)

class fz_context(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    user = property(_mupdf.fz_context_user_get, _mupdf.fz_context_user_set)
    alloc = property(_mupdf.fz_context_alloc_get, _mupdf.fz_context_alloc_set)
    locks = property(_mupdf.fz_context_locks_get, _mupdf.fz_context_locks_set)
    error = property(_mupdf.fz_context_error_get, _mupdf.fz_context_error_set)
    warn = property(_mupdf.fz_context_warn_get, _mupdf.fz_context_warn_set)
    aa = property(_mupdf.fz_context_aa_get, _mupdf.fz_context_aa_set)
    icc_enabled = property(_mupdf.fz_context_icc_enabled_get, _mupdf.fz_context_icc_enabled_set)
    throw_on_repair = property(_mupdf.fz_context_throw_on_repair_get, _mupdf.fz_context_throw_on_repair_set)
    handler = property(_mupdf.fz_context_handler_get, _mupdf.fz_context_handler_set)
    style = property(_mupdf.fz_context_style_get, _mupdf.fz_context_style_set)
    tuning = property(_mupdf.fz_context_tuning_get, _mupdf.fz_context_tuning_set)
    stddbg = property(_mupdf.fz_context_stddbg_get, _mupdf.fz_context_stddbg_set)
    font = property(_mupdf.fz_context_font_get, _mupdf.fz_context_font_set)
    colorspace = property(_mupdf.fz_context_colorspace_get, _mupdf.fz_context_colorspace_set)
    store = property(_mupdf.fz_context_store_get, _mupdf.fz_context_store_set)
    glyph_cache = property(_mupdf.fz_context_glyph_cache_get, _mupdf.fz_context_glyph_cache_set)

    def __init__(self):
        _mupdf.fz_context_swiginit(self, _mupdf.new_fz_context())
    __swig_destroy__ = _mupdf.delete_fz_context

# Register fz_context in _mupdf:
_mupdf.fz_context_swigregister(fz_context)

class fz_buffer(object):
    r"""
    fz_buffer is a wrapper around a dynamically allocated array of
    bytes.

    Buffers have a capacity (the number of bytes storage immediately
    available) and a current size.

    The contents of the structure are considered implementation
    details and are subject to change. Users should use the accessor
    functions in preference.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    refs = property(_mupdf.fz_buffer_refs_get, _mupdf.fz_buffer_refs_set)
    data = property(_mupdf.fz_buffer_data_get, _mupdf.fz_buffer_data_set)
    cap = property(_mupdf.fz_buffer_cap_get, _mupdf.fz_buffer_cap_set)
    len = property(_mupdf.fz_buffer_len_get, _mupdf.fz_buffer_len_set)
    unused_bits = property(_mupdf.fz_buffer_unused_bits_get, _mupdf.fz_buffer_unused_bits_set)
    shared = property(_mupdf.fz_buffer_shared_get, _mupdf.fz_buffer_shared_set)

    def __init__(self):
        _mupdf.fz_buffer_swiginit(self, _mupdf.new_fz_buffer())
    __swig_destroy__ = _mupdf.delete_fz_buffer

# Register fz_buffer in _mupdf:
_mupdf.fz_buffer_swigregister(fz_buffer)

FZ_REPLACEMENT_CHARACTER = _mupdf.FZ_REPLACEMENT_CHARACTER
FZ_UTFMAX = _mupdf.FZ_UTFMAX
class fz_stream(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    refs = property(_mupdf.fz_stream_refs_get, _mupdf.fz_stream_refs_set)
    error = property(_mupdf.fz_stream_error_get, _mupdf.fz_stream_error_set)
    eof = property(_mupdf.fz_stream_eof_get, _mupdf.fz_stream_eof_set)
    progressive = property(_mupdf.fz_stream_progressive_get, _mupdf.fz_stream_progressive_set)
    pos = property(_mupdf.fz_stream_pos_get, _mupdf.fz_stream_pos_set)
    avail = property(_mupdf.fz_stream_avail_get, _mupdf.fz_stream_avail_set)
    bits = property(_mupdf.fz_stream_bits_get, _mupdf.fz_stream_bits_set)
    rp = property(_mupdf.fz_stream_rp_get, _mupdf.fz_stream_rp_set)
    wp = property(_mupdf.fz_stream_wp_get, _mupdf.fz_stream_wp_set)
    state = property(_mupdf.fz_stream_state_get, _mupdf.fz_stream_state_set)
    next = property(_mupdf.fz_stream_next_get, _mupdf.fz_stream_next_set)
    drop = property(_mupdf.fz_stream_drop_get, _mupdf.fz_stream_drop_set)
    seek = property(_mupdf.fz_stream_seek_get, _mupdf.fz_stream_seek_set)

    def __init__(self):
        _mupdf.fz_stream_swiginit(self, _mupdf.new_fz_stream())
    __swig_destroy__ = _mupdf.delete_fz_stream

# Register fz_stream in _mupdf:
_mupdf.fz_stream_swigregister(fz_stream)

class fz_output(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    state = property(_mupdf.fz_output_state_get, _mupdf.fz_output_state_set)
    write = property(_mupdf.fz_output_write_get, _mupdf.fz_output_write_set)
    seek = property(_mupdf.fz_output_seek_get, _mupdf.fz_output_seek_set)
    tell = property(_mupdf.fz_output_tell_get, _mupdf.fz_output_tell_set)
    close = property(_mupdf.fz_output_close_get, _mupdf.fz_output_close_set)
    drop = property(_mupdf.fz_output_drop_get, _mupdf.fz_output_drop_set)
    as_stream = property(_mupdf.fz_output_as_stream_get, _mupdf.fz_output_as_stream_set)
    bp = property(_mupdf.fz_output_bp_get, _mupdf.fz_output_bp_set)
    wp = property(_mupdf.fz_output_wp_get, _mupdf.fz_output_wp_set)
    ep = property(_mupdf.fz_output_ep_get, _mupdf.fz_output_ep_set)

    def __init__(self):
        _mupdf.fz_output_swiginit(self, _mupdf.new_fz_output())
    __swig_destroy__ = _mupdf.delete_fz_output

# Register fz_output in _mupdf:
_mupdf.fz_output_swigregister(fz_output)

class fz_md5(object):
    r"""
    Structure definition is public to enable stack
    based allocation. Do not access the members directly.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    lo = property(_mupdf.fz_md5_lo_get, _mupdf.fz_md5_lo_set)
    hi = property(_mupdf.fz_md5_hi_get, _mupdf.fz_md5_hi_set)
    a = property(_mupdf.fz_md5_a_get, _mupdf.fz_md5_a_set)
    b = property(_mupdf.fz_md5_b_get, _mupdf.fz_md5_b_set)
    c = property(_mupdf.fz_md5_c_get, _mupdf.fz_md5_c_set)
    d = property(_mupdf.fz_md5_d_get, _mupdf.fz_md5_d_set)
    buffer = property(_mupdf.fz_md5_buffer_get, _mupdf.fz_md5_buffer_set)

    def __init__(self):
        _mupdf.fz_md5_swiginit(self, _mupdf.new_fz_md5())
    __swig_destroy__ = _mupdf.delete_fz_md5

# Register fz_md5 in _mupdf:
_mupdf.fz_md5_swigregister(fz_md5)

class fz_sha256(object):
    r"""
    Structure definition is public to enable stack
    based allocation. Do not access the members directly.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    state = property(_mupdf.fz_sha256_state_get, _mupdf.fz_sha256_state_set)
    count = property(_mupdf.fz_sha256_count_get, _mupdf.fz_sha256_count_set)

    def __init__(self):
        _mupdf.fz_sha256_swiginit(self, _mupdf.new_fz_sha256())
    __swig_destroy__ = _mupdf.delete_fz_sha256

# Register fz_sha256 in _mupdf:
_mupdf.fz_sha256_swigregister(fz_sha256)

class fz_sha512(object):
    r"""
    Structure definition is public to enable stack
    based allocation. Do not access the members directly.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    state = property(_mupdf.fz_sha512_state_get, _mupdf.fz_sha512_state_set)
    count = property(_mupdf.fz_sha512_count_get, _mupdf.fz_sha512_count_set)

    def __init__(self):
        _mupdf.fz_sha512_swiginit(self, _mupdf.new_fz_sha512())
    __swig_destroy__ = _mupdf.delete_fz_sha512

# Register fz_sha512 in _mupdf:
_mupdf.fz_sha512_swigregister(fz_sha512)

class fz_arc4(object):
    r"""
    Structure definition is public to enable stack
    based allocation. Do not access the members directly.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    x = property(_mupdf.fz_arc4_x_get, _mupdf.fz_arc4_x_set)
    y = property(_mupdf.fz_arc4_y_get, _mupdf.fz_arc4_y_set)
    state = property(_mupdf.fz_arc4_state_get, _mupdf.fz_arc4_state_set)

    def __init__(self):
        _mupdf.fz_arc4_swiginit(self, _mupdf.new_fz_arc4())
    __swig_destroy__ = _mupdf.delete_fz_arc4

# Register fz_arc4 in _mupdf:
_mupdf.fz_arc4_swigregister(fz_arc4)

class fz_aes(object):
    r"""
    Structure definitions are public to enable stack
    based allocation. Do not access the members directly.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    nr = property(_mupdf.fz_aes_nr_get, _mupdf.fz_aes_nr_set)
    rk = property(_mupdf.fz_aes_rk_get, _mupdf.fz_aes_rk_set)
    buf = property(_mupdf.fz_aes_buf_get, _mupdf.fz_aes_buf_set)

    def __init__(self):
        _mupdf.fz_aes_swiginit(self, _mupdf.new_fz_aes())
    __swig_destroy__ = _mupdf.delete_fz_aes

# Register fz_aes in _mupdf:
_mupdf.fz_aes_swigregister(fz_aes)

FZ_AES_DECRYPT = _mupdf.FZ_AES_DECRYPT
FZ_AES_ENCRYPT = _mupdf.FZ_AES_ENCRYPT
FZ_HASH_TABLE_KEY_LENGTH = _mupdf.FZ_HASH_TABLE_KEY_LENGTH
FZ_BIDI_LTR = _mupdf.FZ_BIDI_LTR
FZ_BIDI_RTL = _mupdf.FZ_BIDI_RTL
FZ_BIDI_NEUTRAL = _mupdf.FZ_BIDI_NEUTRAL
FZ_BIDI_CLASSIFY_WHITE_SPACE = _mupdf.FZ_BIDI_CLASSIFY_WHITE_SPACE
FZ_BIDI_REPLACE_TAB = _mupdf.FZ_BIDI_REPLACE_TAB
FZ_DEFLATE_NONE = _mupdf.FZ_DEFLATE_NONE
FZ_DEFLATE_BEST_SPEED = _mupdf.FZ_DEFLATE_BEST_SPEED
FZ_DEFLATE_BEST = _mupdf.FZ_DEFLATE_BEST
FZ_DEFLATE_DEFAULT = _mupdf.FZ_DEFLATE_DEFAULT
class fz_storable(object):
    r"""
    Any storable object should include an fz_storable structure
    at the start (by convention at least) of their structure.
    (Unless it starts with an fz_key_storable, see below).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    refs = property(_mupdf.fz_storable_refs_get, _mupdf.fz_storable_refs_set)
    drop = property(_mupdf.fz_storable_drop_get, _mupdf.fz_storable_drop_set)

    def __init__(self):
        _mupdf.fz_storable_swiginit(self, _mupdf.new_fz_storable())
    __swig_destroy__ = _mupdf.delete_fz_storable

# Register fz_storable in _mupdf:
_mupdf.fz_storable_swigregister(fz_storable)

class fz_key_storable(object):
    r"""
    Any storable object that can appear in the key of another
    storable object should include an fz_key_storable structure
    at the start (by convention at least) of their structure.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    storable = property(_mupdf.fz_key_storable_storable_get, _mupdf.fz_key_storable_storable_set)
    store_key_refs = property(_mupdf.fz_key_storable_store_key_refs_get, _mupdf.fz_key_storable_store_key_refs_set)

    def __init__(self):
        _mupdf.fz_key_storable_swiginit(self, _mupdf.new_fz_key_storable())
    __swig_destroy__ = _mupdf.delete_fz_key_storable

# Register fz_key_storable in _mupdf:
_mupdf.fz_key_storable_swigregister(fz_key_storable)

class fz_store_hash(object):
    r"""
    The store can be seen as a dictionary that maps keys to
    fz_storable values. In order to allow keys of different types to
    be stored, we have a structure full of functions for each key
    'type'; this fz_store_type pointer is stored with each key, and
    tells the store how to perform certain operations (like taking/
    dropping a reference, comparing two keys, outputting details for
    debugging etc).

    The store uses a hash table internally for speed where possible.
    In order for this to work, we need a mechanism for turning a
    generic 'key' into 'a hashable string'. For this purpose the
    type structure contains a make_hash_key function pointer that
    maps from a void * to a fz_store_hash structure. If
    make_hash_key function returns 0, then the key is determined not
    to be hashable, and the value is not stored in the hash table.

    Some objects can be used both as values within the store, and as
    a component of keys within the store. We refer to these objects
    as "key storable" objects. In this case, we need to take
    additional care to ensure that we do not end up keeping an item
    within the store, purely because its value is referred to by
    another key in the store.

    An example of this are fz_images in PDF files. Each fz_image is
    placed into the	store to enable it to be easily reused. When the
    image is rendered, a pixmap is generated from the image, and the
    pixmap is placed into the store so it can be reused on
    subsequent renders. The image forms part of the key for the
    pixmap.

    When we close the pdf document (and any associated pages/display
    lists etc), we drop the images from the store. This may leave us
    in the position of the images having non-zero reference counts
    purely because they are used as part of the keys for the
    pixmaps.

    We therefore use special reference counting functions to keep
    track of these "key storable" items, and hence store the number
    of references to these items that are used in keys.

    When the number of references to an object == the number of
    references to an object from keys in the store, we know that we
    can remove all the items which have that object as part of the
    key. This is done by running a pass over the store, 'reaping'
    those items.

    Reap passes are slower than we would like as they touch every
    item in the store. We therefore provide a way to 'batch' such
    reap passes together, using fz_defer_reap_start/
    fz_defer_reap_end to bracket a region in which many may be
    triggered.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    drop = property(_mupdf.fz_store_hash_drop_get, _mupdf.fz_store_hash_drop_set)

    def __init__(self):
        _mupdf.fz_store_hash_swiginit(self, _mupdf.new_fz_store_hash())
    __swig_destroy__ = _mupdf.delete_fz_store_hash

# Register fz_store_hash in _mupdf:
_mupdf.fz_store_hash_swigregister(fz_store_hash)

class fz_store_type(object):
    r"""
    Every type of object to be placed into the store defines an
    fz_store_type. This contains the pointers to functions to
    make hashes, manipulate keys, and check for needing reaping.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    name = property(_mupdf.fz_store_type_name_get, _mupdf.fz_store_type_name_set)
    make_hash_key = property(_mupdf.fz_store_type_make_hash_key_get, _mupdf.fz_store_type_make_hash_key_set)
    keep_key = property(_mupdf.fz_store_type_keep_key_get, _mupdf.fz_store_type_keep_key_set)
    drop_key = property(_mupdf.fz_store_type_drop_key_get, _mupdf.fz_store_type_drop_key_set)
    cmp_key = property(_mupdf.fz_store_type_cmp_key_get, _mupdf.fz_store_type_cmp_key_set)
    format_key = property(_mupdf.fz_store_type_format_key_get, _mupdf.fz_store_type_format_key_set)
    needs_reap = property(_mupdf.fz_store_type_needs_reap_get, _mupdf.fz_store_type_needs_reap_set)

    def __init__(self):
        _mupdf.fz_store_type_swiginit(self, _mupdf.new_fz_store_type())
    __swig_destroy__ = _mupdf.delete_fz_store_type

# Register fz_store_type in _mupdf:
_mupdf.fz_store_type_swigregister(fz_store_type)

class fz_range(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    offset = property(_mupdf.fz_range_offset_get, _mupdf.fz_range_offset_set)
    length = property(_mupdf.fz_range_length_get, _mupdf.fz_range_length_set)

    def __init__(self):
        _mupdf.fz_range_swiginit(self, _mupdf.new_fz_range())
    __swig_destroy__ = _mupdf.delete_fz_range

# Register fz_range in _mupdf:
_mupdf.fz_range_swigregister(fz_range)

class fz_compression_params(object):
    r"""
    Compression parameters used for buffers of compressed data;
    typically for the source data for images.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    type = property(_mupdf.fz_compression_params_type_get, _mupdf.fz_compression_params_type_set)

    def __init__(self):
        _mupdf.fz_compression_params_swiginit(self, _mupdf.new_fz_compression_params())
    __swig_destroy__ = _mupdf.delete_fz_compression_params

# Register fz_compression_params in _mupdf:
_mupdf.fz_compression_params_swigregister(fz_compression_params)

class fz_compressed_buffer(object):
    r"""
    Buffers of compressed data; typically for the source data
    for images.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    params = property(_mupdf.fz_compressed_buffer_params_get, _mupdf.fz_compressed_buffer_params_set)
    buffer = property(_mupdf.fz_compressed_buffer_buffer_get, _mupdf.fz_compressed_buffer_buffer_set)

    def __init__(self):
        _mupdf.fz_compressed_buffer_swiginit(self, _mupdf.new_fz_compressed_buffer())
    __swig_destroy__ = _mupdf.delete_fz_compressed_buffer

# Register fz_compressed_buffer in _mupdf:
_mupdf.fz_compressed_buffer_swigregister(fz_compressed_buffer)

FZ_IMAGE_UNKNOWN = _mupdf.FZ_IMAGE_UNKNOWN
FZ_IMAGE_RAW = _mupdf.FZ_IMAGE_RAW
FZ_IMAGE_FAX = _mupdf.FZ_IMAGE_FAX
FZ_IMAGE_FLATE = _mupdf.FZ_IMAGE_FLATE
FZ_IMAGE_LZW = _mupdf.FZ_IMAGE_LZW
FZ_IMAGE_RLD = _mupdf.FZ_IMAGE_RLD
FZ_IMAGE_BMP = _mupdf.FZ_IMAGE_BMP
FZ_IMAGE_GIF = _mupdf.FZ_IMAGE_GIF
FZ_IMAGE_JBIG2 = _mupdf.FZ_IMAGE_JBIG2
FZ_IMAGE_JPEG = _mupdf.FZ_IMAGE_JPEG
FZ_IMAGE_JPX = _mupdf.FZ_IMAGE_JPX
FZ_IMAGE_JXR = _mupdf.FZ_IMAGE_JXR
FZ_IMAGE_PNG = _mupdf.FZ_IMAGE_PNG
FZ_IMAGE_PNM = _mupdf.FZ_IMAGE_PNM
FZ_IMAGE_TIFF = _mupdf.FZ_IMAGE_TIFF
class fz_archive(object):
    r"""	Implementation details: Subject to change."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    file = property(_mupdf.fz_archive_file_get, _mupdf.fz_archive_file_set)
    format = property(_mupdf.fz_archive_format_get, _mupdf.fz_archive_format_set)
    drop_archive = property(_mupdf.fz_archive_drop_archive_get, _mupdf.fz_archive_drop_archive_set)
    count_entries = property(_mupdf.fz_archive_count_entries_get, _mupdf.fz_archive_count_entries_set)
    list_entry = property(_mupdf.fz_archive_list_entry_get, _mupdf.fz_archive_list_entry_set)
    has_entry = property(_mupdf.fz_archive_has_entry_get, _mupdf.fz_archive_has_entry_set)
    read_entry = property(_mupdf.fz_archive_read_entry_get, _mupdf.fz_archive_read_entry_set)
    open_entry = property(_mupdf.fz_archive_open_entry_get, _mupdf.fz_archive_open_entry_set)

    def __init__(self):
        _mupdf.fz_archive_swiginit(self, _mupdf.new_fz_archive())
    __swig_destroy__ = _mupdf.delete_fz_archive

# Register fz_archive in _mupdf:
_mupdf.fz_archive_swigregister(fz_archive)

FZ_RI_PERCEPTUAL = _mupdf.FZ_RI_PERCEPTUAL
FZ_RI_RELATIVE_COLORIMETRIC = _mupdf.FZ_RI_RELATIVE_COLORIMETRIC
FZ_RI_SATURATION = _mupdf.FZ_RI_SATURATION
FZ_RI_ABSOLUTE_COLORIMETRIC = _mupdf.FZ_RI_ABSOLUTE_COLORIMETRIC
class fz_color_params(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    ri = property(_mupdf.fz_color_params_ri_get, _mupdf.fz_color_params_ri_set)
    bp = property(_mupdf.fz_color_params_bp_get, _mupdf.fz_color_params_bp_set)
    op = property(_mupdf.fz_color_params_op_get, _mupdf.fz_color_params_op_set)
    opm = property(_mupdf.fz_color_params_opm_get, _mupdf.fz_color_params_opm_set)

    def __init__(self):
        _mupdf.fz_color_params_swiginit(self, _mupdf.new_fz_color_params())
    __swig_destroy__ = _mupdf.delete_fz_color_params

# Register fz_color_params in _mupdf:
_mupdf.fz_color_params_swigregister(fz_color_params)

FZ_MAX_COLORS = _mupdf.FZ_MAX_COLORS
FZ_COLORSPACE_IS_DEVICE = _mupdf.FZ_COLORSPACE_IS_DEVICE
FZ_COLORSPACE_IS_ICC = _mupdf.FZ_COLORSPACE_IS_ICC
FZ_COLORSPACE_HAS_CMYK = _mupdf.FZ_COLORSPACE_HAS_CMYK
FZ_COLORSPACE_HAS_SPOTS = _mupdf.FZ_COLORSPACE_HAS_SPOTS
FZ_COLORSPACE_HAS_CMYK_AND_SPOTS = _mupdf.FZ_COLORSPACE_HAS_CMYK_AND_SPOTS
class fz_default_colorspaces(object):
    r"""	Structure to hold default colorspaces."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    refs = property(_mupdf.fz_default_colorspaces_refs_get, _mupdf.fz_default_colorspaces_refs_set)
    gray = property(_mupdf.fz_default_colorspaces_gray_get, _mupdf.fz_default_colorspaces_gray_set)
    rgb = property(_mupdf.fz_default_colorspaces_rgb_get, _mupdf.fz_default_colorspaces_rgb_set)
    cmyk = property(_mupdf.fz_default_colorspaces_cmyk_get, _mupdf.fz_default_colorspaces_cmyk_set)
    oi = property(_mupdf.fz_default_colorspaces_oi_get, _mupdf.fz_default_colorspaces_oi_set)

    def __init__(self):
        _mupdf.fz_default_colorspaces_swiginit(self, _mupdf.new_fz_default_colorspaces())
    __swig_destroy__ = _mupdf.delete_fz_default_colorspaces

# Register fz_default_colorspaces in _mupdf:
_mupdf.fz_default_colorspaces_swigregister(fz_default_colorspaces)
fz_default_color_params = cvar.fz_default_color_params

class fz_colorspace(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    key_storable = property(_mupdf.fz_colorspace_key_storable_get, _mupdf.fz_colorspace_key_storable_set)
    type = property(_mupdf.fz_colorspace_type_get, _mupdf.fz_colorspace_type_set)
    flags = property(_mupdf.fz_colorspace_flags_get, _mupdf.fz_colorspace_flags_set)
    n = property(_mupdf.fz_colorspace_n_get, _mupdf.fz_colorspace_n_set)
    name = property(_mupdf.fz_colorspace_name_get, _mupdf.fz_colorspace_name_set)

    def __init__(self):
        _mupdf.fz_colorspace_swiginit(self, _mupdf.new_fz_colorspace())
    __swig_destroy__ = _mupdf.delete_fz_colorspace

# Register fz_colorspace in _mupdf:
_mupdf.fz_colorspace_swigregister(fz_colorspace)

FZ_MAX_SEPARATIONS = _mupdf.FZ_MAX_SEPARATIONS
FZ_SEPARATION_COMPOSITE = _mupdf.FZ_SEPARATION_COMPOSITE
FZ_SEPARATION_SPOT = _mupdf.FZ_SEPARATION_SPOT
FZ_SEPARATION_DISABLED = _mupdf.FZ_SEPARATION_DISABLED
class fz_pixmap(object):
    r"""
    Pixmaps represent a set of pixels for a 2 dimensional region of
    a plane. Each pixel has n components per pixel. The components
    are in the order process-components, spot-colors, alpha, where
    there can be 0 of any of those types. The data is in
    premultiplied alpha when rendering, but non-premultiplied for
    colorspace conversions and rescaling.

    x, y: The minimum x and y coord of the region in pixels.

    w, h: The width and height of the region in pixels.

    n: The number of color components in the image.
    	n = num composite colors + num spots + num alphas

    s: The number of spot channels in the image.

    alpha: 0 for no alpha, 1 for alpha present.

    flags: flag bits.
    	Bit 0: If set, draw the image with linear interpolation.
    	Bit 1: If set, free the samples buffer when the pixmap
    	is destroyed.

    stride: The byte offset from the data for any given pixel
    to the data for the same pixel on the row below.

    seps: NULL, or a pointer to a separations structure. If NULL,
    s should be 0.

    xres, yres: Image resolution in dpi. Default is 96 dpi.

    colorspace: Pointer to a colorspace object describing the
    colorspace the pixmap is in. If NULL, the image is a mask.

    samples: Pointer to the first byte of the pixmap sample data.
    This is typically a simple block of memory w * h * n bytes of
    memory in which the components are stored linearly, but with the
    use of appropriate stride values, scanlines can be stored in
    different orders, and have different amounts of padding. The
    first n bytes are components 0 to n-1 for the pixel at (x,y).
    Each successive n bytes gives another pixel in scanline order
    as we move across the line. The start of each scanline is offset
    the start of the previous one by stride bytes.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    storable = property(_mupdf.fz_pixmap_storable_get, _mupdf.fz_pixmap_storable_set)
    x = property(_mupdf.fz_pixmap_x_get, _mupdf.fz_pixmap_x_set)
    y = property(_mupdf.fz_pixmap_y_get, _mupdf.fz_pixmap_y_set)
    w = property(_mupdf.fz_pixmap_w_get, _mupdf.fz_pixmap_w_set)
    h = property(_mupdf.fz_pixmap_h_get, _mupdf.fz_pixmap_h_set)
    n = property(_mupdf.fz_pixmap_n_get, _mupdf.fz_pixmap_n_set)
    s = property(_mupdf.fz_pixmap_s_get, _mupdf.fz_pixmap_s_set)
    alpha = property(_mupdf.fz_pixmap_alpha_get, _mupdf.fz_pixmap_alpha_set)
    flags = property(_mupdf.fz_pixmap_flags_get, _mupdf.fz_pixmap_flags_set)
    stride = property(_mupdf.fz_pixmap_stride_get, _mupdf.fz_pixmap_stride_set)
    seps = property(_mupdf.fz_pixmap_seps_get, _mupdf.fz_pixmap_seps_set)
    xres = property(_mupdf.fz_pixmap_xres_get, _mupdf.fz_pixmap_xres_set)
    yres = property(_mupdf.fz_pixmap_yres_get, _mupdf.fz_pixmap_yres_set)
    colorspace = property(_mupdf.fz_pixmap_colorspace_get, _mupdf.fz_pixmap_colorspace_set)
    samples = property(_mupdf.fz_pixmap_samples_get, _mupdf.fz_pixmap_samples_set)
    underlying = property(_mupdf.fz_pixmap_underlying_get, _mupdf.fz_pixmap_underlying_set)

    def __init__(self):
        _mupdf.fz_pixmap_swiginit(self, _mupdf.new_fz_pixmap())
    __swig_destroy__ = _mupdf.delete_fz_pixmap

# Register fz_pixmap in _mupdf:
_mupdf.fz_pixmap_swigregister(fz_pixmap)

FZ_PIXMAP_FLAG_INTERPOLATE = _mupdf.FZ_PIXMAP_FLAG_INTERPOLATE
FZ_PIXMAP_FLAG_FREE_SAMPLES = _mupdf.FZ_PIXMAP_FLAG_FREE_SAMPLES
class fz_bitmap(object):
    r"""
    Bitmaps have 1 bit per component. Only used for creating
    halftoned versions of contone buffers, and saving out. Samples
    are stored msb first, akin to pbms.

    The internals of this struct are considered implementation
    details and subject to change. Where possible, accessor
    functions should be used in preference.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    refs = property(_mupdf.fz_bitmap_refs_get, _mupdf.fz_bitmap_refs_set)
    w = property(_mupdf.fz_bitmap_w_get, _mupdf.fz_bitmap_w_set)
    h = property(_mupdf.fz_bitmap_h_get, _mupdf.fz_bitmap_h_set)
    stride = property(_mupdf.fz_bitmap_stride_get, _mupdf.fz_bitmap_stride_set)
    n = property(_mupdf.fz_bitmap_n_get, _mupdf.fz_bitmap_n_set)
    xres = property(_mupdf.fz_bitmap_xres_get, _mupdf.fz_bitmap_xres_set)
    yres = property(_mupdf.fz_bitmap_yres_get, _mupdf.fz_bitmap_yres_set)
    samples = property(_mupdf.fz_bitmap_samples_get, _mupdf.fz_bitmap_samples_set)

    def __init__(self):
        _mupdf.fz_bitmap_swiginit(self, _mupdf.new_fz_bitmap())
    __swig_destroy__ = _mupdf.delete_fz_bitmap

# Register fz_bitmap in _mupdf:
_mupdf.fz_bitmap_swigregister(fz_bitmap)

class fz_image(object):
    r"""
    Structure is public to allow other structures to
    be derived from it. Do not access members directly.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    key_storable = property(_mupdf.fz_image_key_storable_get, _mupdf.fz_image_key_storable_set)
    w = property(_mupdf.fz_image_w_get, _mupdf.fz_image_w_set)
    h = property(_mupdf.fz_image_h_get, _mupdf.fz_image_h_set)
    n = property(_mupdf.fz_image_n_get, _mupdf.fz_image_n_set)
    bpc = property(_mupdf.fz_image_bpc_get, _mupdf.fz_image_bpc_set)
    imagemask = property(_mupdf.fz_image_imagemask_get, _mupdf.fz_image_imagemask_set)
    interpolate = property(_mupdf.fz_image_interpolate_get, _mupdf.fz_image_interpolate_set)
    use_colorkey = property(_mupdf.fz_image_use_colorkey_get, _mupdf.fz_image_use_colorkey_set)
    use_decode = property(_mupdf.fz_image_use_decode_get, _mupdf.fz_image_use_decode_set)
    invert_cmyk_jpeg = property(_mupdf.fz_image_invert_cmyk_jpeg_get, _mupdf.fz_image_invert_cmyk_jpeg_set)
    decoded = property(_mupdf.fz_image_decoded_get, _mupdf.fz_image_decoded_set)
    scalable = property(_mupdf.fz_image_scalable_get, _mupdf.fz_image_scalable_set)
    orientation = property(_mupdf.fz_image_orientation_get, _mupdf.fz_image_orientation_set)
    mask = property(_mupdf.fz_image_mask_get, _mupdf.fz_image_mask_set)
    xres = property(_mupdf.fz_image_xres_get, _mupdf.fz_image_xres_set)
    yres = property(_mupdf.fz_image_yres_get, _mupdf.fz_image_yres_set)
    colorspace = property(_mupdf.fz_image_colorspace_get, _mupdf.fz_image_colorspace_set)
    drop_image = property(_mupdf.fz_image_drop_image_get, _mupdf.fz_image_drop_image_set)
    get_pixmap = property(_mupdf.fz_image_get_pixmap_get, _mupdf.fz_image_get_pixmap_set)
    get_size = property(_mupdf.fz_image_get_size_get, _mupdf.fz_image_get_size_set)
    colorkey = property(_mupdf.fz_image_colorkey_get, _mupdf.fz_image_colorkey_set)
    decode = property(_mupdf.fz_image_decode_get, _mupdf.fz_image_decode_set)

    def __init__(self):
        _mupdf.fz_image_swiginit(self, _mupdf.new_fz_image())
    __swig_destroy__ = _mupdf.delete_fz_image

# Register fz_image in _mupdf:
_mupdf.fz_image_swigregister(fz_image)

FZ_FUNCTION_BASED = _mupdf.FZ_FUNCTION_BASED
FZ_LINEAR = _mupdf.FZ_LINEAR
FZ_RADIAL = _mupdf.FZ_RADIAL
FZ_MESH_TYPE4 = _mupdf.FZ_MESH_TYPE4
FZ_MESH_TYPE5 = _mupdf.FZ_MESH_TYPE5
FZ_MESH_TYPE6 = _mupdf.FZ_MESH_TYPE6
FZ_MESH_TYPE7 = _mupdf.FZ_MESH_TYPE7
class fz_shade(object):
    r"""
    Structure is public to allow derived classes. Do not
    access the members directly.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    storable = property(_mupdf.fz_shade_storable_get, _mupdf.fz_shade_storable_set)
    bbox = property(_mupdf.fz_shade_bbox_get, _mupdf.fz_shade_bbox_set)
    colorspace = property(_mupdf.fz_shade_colorspace_get, _mupdf.fz_shade_colorspace_set)
    matrix = property(_mupdf.fz_shade_matrix_get, _mupdf.fz_shade_matrix_set)
    use_background = property(_mupdf.fz_shade_use_background_get, _mupdf.fz_shade_use_background_set)
    background = property(_mupdf.fz_shade_background_get, _mupdf.fz_shade_background_set)
    use_function = property(_mupdf.fz_shade_use_function_get, _mupdf.fz_shade_use_function_set)
    function = property(_mupdf.fz_shade_function_get, _mupdf.fz_shade_function_set)
    type = property(_mupdf.fz_shade_type_get, _mupdf.fz_shade_type_set)
    buffer = property(_mupdf.fz_shade_buffer_get, _mupdf.fz_shade_buffer_set)

    def __init__(self):
        _mupdf.fz_shade_swiginit(self, _mupdf.new_fz_shade())
    __swig_destroy__ = _mupdf.delete_fz_shade

# Register fz_shade in _mupdf:
_mupdf.fz_shade_swigregister(fz_shade)

class fz_vertex(object):
    r"""	Handy routine for processing mesh based shades"""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    p = property(_mupdf.fz_vertex_p_get, _mupdf.fz_vertex_p_set)
    c = property(_mupdf.fz_vertex_c_get, _mupdf.fz_vertex_c_set)

    def __init__(self):
        _mupdf.fz_vertex_swiginit(self, _mupdf.new_fz_vertex())
    __swig_destroy__ = _mupdf.delete_fz_vertex

# Register fz_vertex in _mupdf:
_mupdf.fz_vertex_swigregister(fz_vertex)

FZ_ADOBE_CNS = _mupdf.FZ_ADOBE_CNS
FZ_ADOBE_GB = _mupdf.FZ_ADOBE_GB
FZ_ADOBE_JAPAN = _mupdf.FZ_ADOBE_JAPAN
FZ_ADOBE_KOREA = _mupdf.FZ_ADOBE_KOREA
class fz_font_flags_t(object):
    r"""
    Every fz_font carries a set of flags
    within it, in a fz_font_flags_t structure.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    is_mono = property(_mupdf.fz_font_flags_t_is_mono_get, _mupdf.fz_font_flags_t_is_mono_set)
    is_serif = property(_mupdf.fz_font_flags_t_is_serif_get, _mupdf.fz_font_flags_t_is_serif_set)
    is_bold = property(_mupdf.fz_font_flags_t_is_bold_get, _mupdf.fz_font_flags_t_is_bold_set)
    is_italic = property(_mupdf.fz_font_flags_t_is_italic_get, _mupdf.fz_font_flags_t_is_italic_set)
    ft_substitute = property(_mupdf.fz_font_flags_t_ft_substitute_get, _mupdf.fz_font_flags_t_ft_substitute_set)
    ft_stretch = property(_mupdf.fz_font_flags_t_ft_stretch_get, _mupdf.fz_font_flags_t_ft_stretch_set)
    fake_bold = property(_mupdf.fz_font_flags_t_fake_bold_get, _mupdf.fz_font_flags_t_fake_bold_set)
    fake_italic = property(_mupdf.fz_font_flags_t_fake_italic_get, _mupdf.fz_font_flags_t_fake_italic_set)
    has_opentype = property(_mupdf.fz_font_flags_t_has_opentype_get, _mupdf.fz_font_flags_t_has_opentype_set)
    invalid_bbox = property(_mupdf.fz_font_flags_t_invalid_bbox_get, _mupdf.fz_font_flags_t_invalid_bbox_set)
    cjk = property(_mupdf.fz_font_flags_t_cjk_get, _mupdf.fz_font_flags_t_cjk_set)
    cjk_lang = property(_mupdf.fz_font_flags_t_cjk_lang_get, _mupdf.fz_font_flags_t_cjk_lang_set)

    def __init__(self):
        _mupdf.fz_font_flags_t_swiginit(self, _mupdf.new_fz_font_flags_t())
    __swig_destroy__ = _mupdf.delete_fz_font_flags_t

# Register fz_font_flags_t in _mupdf:
_mupdf.fz_font_flags_t_swigregister(fz_font_flags_t)
fz_unicode_from_iso8859_1 = cvar.fz_unicode_from_iso8859_1
fz_unicode_from_iso8859_7 = cvar.fz_unicode_from_iso8859_7
fz_unicode_from_koi8u = cvar.fz_unicode_from_koi8u
fz_unicode_from_pdf_doc_encoding = cvar.fz_unicode_from_pdf_doc_encoding
fz_unicode_from_windows_1250 = cvar.fz_unicode_from_windows_1250
fz_unicode_from_windows_1251 = cvar.fz_unicode_from_windows_1251
fz_unicode_from_windows_1252 = cvar.fz_unicode_from_windows_1252

class fz_shaper_data_t(object):
    r"""
    In order to shape a given font, we need to
    declare it to a shaper library (harfbuzz, by default, but others
    are possible). To avoid redeclaring it every time we need to
    shape, we hold a shaper handle and the destructor for it within
    the font itself. The handle is initialised by the caller when
    first required and the destructor is called when the fz_font is
    destroyed.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    shaper_handle = property(_mupdf.fz_shaper_data_t_shaper_handle_get, _mupdf.fz_shaper_data_t_shaper_handle_set)
    destroy = property(_mupdf.fz_shaper_data_t_destroy_get, _mupdf.fz_shaper_data_t_destroy_set)

    def __init__(self):
        _mupdf.fz_shaper_data_t_swiginit(self, _mupdf.new_fz_shaper_data_t())
    __swig_destroy__ = _mupdf.delete_fz_shaper_data_t

# Register fz_shaper_data_t in _mupdf:
_mupdf.fz_shaper_data_t_swigregister(fz_shaper_data_t)

class fz_font(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    refs = property(_mupdf.fz_font_refs_get, _mupdf.fz_font_refs_set)
    name = property(_mupdf.fz_font_name_get, _mupdf.fz_font_name_set)
    buffer = property(_mupdf.fz_font_buffer_get, _mupdf.fz_font_buffer_set)
    flags = property(_mupdf.fz_font_flags_get, _mupdf.fz_font_flags_set)
    ft_face = property(_mupdf.fz_font_ft_face_get, _mupdf.fz_font_ft_face_set)
    shaper_data = property(_mupdf.fz_font_shaper_data_get, _mupdf.fz_font_shaper_data_set)
    t3matrix = property(_mupdf.fz_font_t3matrix_get, _mupdf.fz_font_t3matrix_set)
    t3resources = property(_mupdf.fz_font_t3resources_get, _mupdf.fz_font_t3resources_set)
    t3procs = property(_mupdf.fz_font_t3procs_get, _mupdf.fz_font_t3procs_set)
    t3lists = property(_mupdf.fz_font_t3lists_get, _mupdf.fz_font_t3lists_set)
    t3widths = property(_mupdf.fz_font_t3widths_get, _mupdf.fz_font_t3widths_set)
    t3flags = property(_mupdf.fz_font_t3flags_get, _mupdf.fz_font_t3flags_set)
    t3doc = property(_mupdf.fz_font_t3doc_get, _mupdf.fz_font_t3doc_set)
    t3run = property(_mupdf.fz_font_t3run_get, _mupdf.fz_font_t3run_set)
    t3freeres = property(_mupdf.fz_font_t3freeres_get, _mupdf.fz_font_t3freeres_set)
    bbox = property(_mupdf.fz_font_bbox_get, _mupdf.fz_font_bbox_set)
    glyph_count = property(_mupdf.fz_font_glyph_count_get, _mupdf.fz_font_glyph_count_set)
    bbox_table = property(_mupdf.fz_font_bbox_table_get, _mupdf.fz_font_bbox_table_set)
    use_glyph_bbox = property(_mupdf.fz_font_use_glyph_bbox_get, _mupdf.fz_font_use_glyph_bbox_set)
    width_count = property(_mupdf.fz_font_width_count_get, _mupdf.fz_font_width_count_set)
    width_default = property(_mupdf.fz_font_width_default_get, _mupdf.fz_font_width_default_set)
    width_table = property(_mupdf.fz_font_width_table_get, _mupdf.fz_font_width_table_set)
    advance_cache = property(_mupdf.fz_font_advance_cache_get, _mupdf.fz_font_advance_cache_set)
    encoding_cache = property(_mupdf.fz_font_encoding_cache_get, _mupdf.fz_font_encoding_cache_set)
    has_digest = property(_mupdf.fz_font_has_digest_get, _mupdf.fz_font_has_digest_set)
    digest = property(_mupdf.fz_font_digest_get, _mupdf.fz_font_digest_set)

    def __init__(self):
        _mupdf.fz_font_swiginit(self, _mupdf.new_fz_font())
    __swig_destroy__ = _mupdf.delete_fz_font

# Register fz_font in _mupdf:
_mupdf.fz_font_swigregister(fz_font)

FZ_LINECAP_BUTT = _mupdf.FZ_LINECAP_BUTT
FZ_LINECAP_ROUND = _mupdf.FZ_LINECAP_ROUND
FZ_LINECAP_SQUARE = _mupdf.FZ_LINECAP_SQUARE
FZ_LINECAP_TRIANGLE = _mupdf.FZ_LINECAP_TRIANGLE
FZ_LINEJOIN_MITER = _mupdf.FZ_LINEJOIN_MITER
FZ_LINEJOIN_ROUND = _mupdf.FZ_LINEJOIN_ROUND
FZ_LINEJOIN_BEVEL = _mupdf.FZ_LINEJOIN_BEVEL
FZ_LINEJOIN_MITER_XPS = _mupdf.FZ_LINEJOIN_MITER_XPS
class fz_stroke_state(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    refs = property(_mupdf.fz_stroke_state_refs_get, _mupdf.fz_stroke_state_refs_set)
    start_cap = property(_mupdf.fz_stroke_state_start_cap_get, _mupdf.fz_stroke_state_start_cap_set)
    dash_cap = property(_mupdf.fz_stroke_state_dash_cap_get, _mupdf.fz_stroke_state_dash_cap_set)
    end_cap = property(_mupdf.fz_stroke_state_end_cap_get, _mupdf.fz_stroke_state_end_cap_set)
    linejoin = property(_mupdf.fz_stroke_state_linejoin_get, _mupdf.fz_stroke_state_linejoin_set)
    linewidth = property(_mupdf.fz_stroke_state_linewidth_get, _mupdf.fz_stroke_state_linewidth_set)
    miterlimit = property(_mupdf.fz_stroke_state_miterlimit_get, _mupdf.fz_stroke_state_miterlimit_set)
    dash_phase = property(_mupdf.fz_stroke_state_dash_phase_get, _mupdf.fz_stroke_state_dash_phase_set)
    dash_len = property(_mupdf.fz_stroke_state_dash_len_get, _mupdf.fz_stroke_state_dash_len_set)
    dash_list = property(_mupdf.fz_stroke_state_dash_list_get, _mupdf.fz_stroke_state_dash_list_set)

    def __init__(self):
        _mupdf.fz_stroke_state_swiginit(self, _mupdf.new_fz_stroke_state())
    __swig_destroy__ = _mupdf.delete_fz_stroke_state

# Register fz_stroke_state in _mupdf:
_mupdf.fz_stroke_state_swigregister(fz_stroke_state)

class fz_path_walker(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    moveto = property(_mupdf.fz_path_walker_moveto_get, _mupdf.fz_path_walker_moveto_set)
    lineto = property(_mupdf.fz_path_walker_lineto_get, _mupdf.fz_path_walker_lineto_set)
    curveto = property(_mupdf.fz_path_walker_curveto_get, _mupdf.fz_path_walker_curveto_set)
    closepath = property(_mupdf.fz_path_walker_closepath_get, _mupdf.fz_path_walker_closepath_set)
    quadto = property(_mupdf.fz_path_walker_quadto_get, _mupdf.fz_path_walker_quadto_set)
    curvetov = property(_mupdf.fz_path_walker_curvetov_get, _mupdf.fz_path_walker_curvetov_set)
    curvetoy = property(_mupdf.fz_path_walker_curvetoy_get, _mupdf.fz_path_walker_curvetoy_set)
    rectto = property(_mupdf.fz_path_walker_rectto_get, _mupdf.fz_path_walker_rectto_set)

    def __init__(self):
        _mupdf.fz_path_walker_swiginit(self, _mupdf.new_fz_path_walker())
    __swig_destroy__ = _mupdf.delete_fz_path_walker

# Register fz_path_walker in _mupdf:
_mupdf.fz_path_walker_swigregister(fz_path_walker)

class fz_text_item(object):
    r"""
    Text buffer.

    The trm field contains the a, b, c and d coefficients.
    The e and f coefficients come from the individual elements,
    together they form the transform matrix for the glyph.

    Glyphs are referenced by glyph ID.
    The Unicode text equivalent is kept in a separate array
    with indexes into the glyph array.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    x = property(_mupdf.fz_text_item_x_get, _mupdf.fz_text_item_x_set)
    y = property(_mupdf.fz_text_item_y_get, _mupdf.fz_text_item_y_set)
    gid = property(_mupdf.fz_text_item_gid_get, _mupdf.fz_text_item_gid_set)
    ucs = property(_mupdf.fz_text_item_ucs_get, _mupdf.fz_text_item_ucs_set)

    def __init__(self):
        _mupdf.fz_text_item_swiginit(self, _mupdf.new_fz_text_item())
    __swig_destroy__ = _mupdf.delete_fz_text_item

# Register fz_text_item in _mupdf:
_mupdf.fz_text_item_swigregister(fz_text_item)
fz_default_stroke_state = cvar.fz_default_stroke_state

FZ_LANG_UNSET = _mupdf.FZ_LANG_UNSET
FZ_LANG_ur = _mupdf.FZ_LANG_ur
FZ_LANG_urd = _mupdf.FZ_LANG_urd
FZ_LANG_ko = _mupdf.FZ_LANG_ko
FZ_LANG_ja = _mupdf.FZ_LANG_ja
FZ_LANG_zh = _mupdf.FZ_LANG_zh
FZ_LANG_zh_Hans = _mupdf.FZ_LANG_zh_Hans
FZ_LANG_zh_Hant = _mupdf.FZ_LANG_zh_Hant
class fz_text_span(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    font = property(_mupdf.fz_text_span_font_get, _mupdf.fz_text_span_font_set)
    trm = property(_mupdf.fz_text_span_trm_get, _mupdf.fz_text_span_trm_set)
    wmode = property(_mupdf.fz_text_span_wmode_get, _mupdf.fz_text_span_wmode_set)
    bidi_level = property(_mupdf.fz_text_span_bidi_level_get, _mupdf.fz_text_span_bidi_level_set)
    markup_dir = property(_mupdf.fz_text_span_markup_dir_get, _mupdf.fz_text_span_markup_dir_set)
    language = property(_mupdf.fz_text_span_language_get, _mupdf.fz_text_span_language_set)
    len = property(_mupdf.fz_text_span_len_get, _mupdf.fz_text_span_len_set)
    cap = property(_mupdf.fz_text_span_cap_get, _mupdf.fz_text_span_cap_set)
    items = property(_mupdf.fz_text_span_items_get, _mupdf.fz_text_span_items_set)
    next = property(_mupdf.fz_text_span_next_get, _mupdf.fz_text_span_next_set)

    def __init__(self):
        _mupdf.fz_text_span_swiginit(self, _mupdf.new_fz_text_span())
    __swig_destroy__ = _mupdf.delete_fz_text_span

# Register fz_text_span in _mupdf:
_mupdf.fz_text_span_swigregister(fz_text_span)

class fz_text(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    refs = property(_mupdf.fz_text_refs_get, _mupdf.fz_text_refs_set)
    head = property(_mupdf.fz_text_head_get, _mupdf.fz_text_head_set)
    tail = property(_mupdf.fz_text_tail_get, _mupdf.fz_text_tail_set)

    def __init__(self):
        _mupdf.fz_text_swiginit(self, _mupdf.new_fz_text())
    __swig_destroy__ = _mupdf.delete_fz_text

# Register fz_text in _mupdf:
_mupdf.fz_text_swigregister(fz_text)

FZ_DEVFLAG_MASK = _mupdf.FZ_DEVFLAG_MASK
FZ_DEVFLAG_COLOR = _mupdf.FZ_DEVFLAG_COLOR
FZ_DEVFLAG_UNCACHEABLE = _mupdf.FZ_DEVFLAG_UNCACHEABLE
FZ_DEVFLAG_FILLCOLOR_UNDEFINED = _mupdf.FZ_DEVFLAG_FILLCOLOR_UNDEFINED
FZ_DEVFLAG_STROKECOLOR_UNDEFINED = _mupdf.FZ_DEVFLAG_STROKECOLOR_UNDEFINED
FZ_DEVFLAG_STARTCAP_UNDEFINED = _mupdf.FZ_DEVFLAG_STARTCAP_UNDEFINED
FZ_DEVFLAG_DASHCAP_UNDEFINED = _mupdf.FZ_DEVFLAG_DASHCAP_UNDEFINED
FZ_DEVFLAG_ENDCAP_UNDEFINED = _mupdf.FZ_DEVFLAG_ENDCAP_UNDEFINED
FZ_DEVFLAG_LINEJOIN_UNDEFINED = _mupdf.FZ_DEVFLAG_LINEJOIN_UNDEFINED
FZ_DEVFLAG_MITERLIMIT_UNDEFINED = _mupdf.FZ_DEVFLAG_MITERLIMIT_UNDEFINED
FZ_DEVFLAG_LINEWIDTH_UNDEFINED = _mupdf.FZ_DEVFLAG_LINEWIDTH_UNDEFINED
FZ_DEVFLAG_BBOX_DEFINED = _mupdf.FZ_DEVFLAG_BBOX_DEFINED
FZ_DEVFLAG_GRIDFIT_AS_TILED = _mupdf.FZ_DEVFLAG_GRIDFIT_AS_TILED
FZ_BLEND_NORMAL = _mupdf.FZ_BLEND_NORMAL
FZ_BLEND_MULTIPLY = _mupdf.FZ_BLEND_MULTIPLY
FZ_BLEND_SCREEN = _mupdf.FZ_BLEND_SCREEN
FZ_BLEND_OVERLAY = _mupdf.FZ_BLEND_OVERLAY
FZ_BLEND_DARKEN = _mupdf.FZ_BLEND_DARKEN
FZ_BLEND_LIGHTEN = _mupdf.FZ_BLEND_LIGHTEN
FZ_BLEND_COLOR_DODGE = _mupdf.FZ_BLEND_COLOR_DODGE
FZ_BLEND_COLOR_BURN = _mupdf.FZ_BLEND_COLOR_BURN
FZ_BLEND_HARD_LIGHT = _mupdf.FZ_BLEND_HARD_LIGHT
FZ_BLEND_SOFT_LIGHT = _mupdf.FZ_BLEND_SOFT_LIGHT
FZ_BLEND_DIFFERENCE = _mupdf.FZ_BLEND_DIFFERENCE
FZ_BLEND_EXCLUSION = _mupdf.FZ_BLEND_EXCLUSION
FZ_BLEND_HUE = _mupdf.FZ_BLEND_HUE
FZ_BLEND_SATURATION = _mupdf.FZ_BLEND_SATURATION
FZ_BLEND_COLOR = _mupdf.FZ_BLEND_COLOR
FZ_BLEND_LUMINOSITY = _mupdf.FZ_BLEND_LUMINOSITY
FZ_BLEND_MODEMASK = _mupdf.FZ_BLEND_MODEMASK
FZ_BLEND_ISOLATED = _mupdf.FZ_BLEND_ISOLATED
FZ_BLEND_KNOCKOUT = _mupdf.FZ_BLEND_KNOCKOUT
class fz_device_container_stack(object):
    r"""
    The device structure is public to allow devices to be
    implemented outside of fitz.

    Device methods should always be called using e.g.
    fz_fill_path(ctx, dev, ...) rather than
    dev->fill_path(ctx, dev, ...)

    Devices can keep track of containers (clips/masks/groups/tiles)
    as they go to save callers having to do it.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    scissor = property(_mupdf.fz_device_container_stack_scissor_get, _mupdf.fz_device_container_stack_scissor_set)
    type = property(_mupdf.fz_device_container_stack_type_get, _mupdf.fz_device_container_stack_type_set)
    user = property(_mupdf.fz_device_container_stack_user_get, _mupdf.fz_device_container_stack_user_set)

    def __init__(self):
        _mupdf.fz_device_container_stack_swiginit(self, _mupdf.new_fz_device_container_stack())
    __swig_destroy__ = _mupdf.delete_fz_device_container_stack

# Register fz_device_container_stack in _mupdf:
_mupdf.fz_device_container_stack_swigregister(fz_device_container_stack)

fz_device_container_stack_is_clip = _mupdf.fz_device_container_stack_is_clip
fz_device_container_stack_is_mask = _mupdf.fz_device_container_stack_is_mask
fz_device_container_stack_is_group = _mupdf.fz_device_container_stack_is_group
fz_device_container_stack_is_tile = _mupdf.fz_device_container_stack_is_tile
class fz_device(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    refs = property(_mupdf.fz_device_refs_get, _mupdf.fz_device_refs_set)
    hints = property(_mupdf.fz_device_hints_get, _mupdf.fz_device_hints_set)
    flags = property(_mupdf.fz_device_flags_get, _mupdf.fz_device_flags_set)
    close_device = property(_mupdf.fz_device_close_device_get, _mupdf.fz_device_close_device_set)
    drop_device = property(_mupdf.fz_device_drop_device_get, _mupdf.fz_device_drop_device_set)
    fill_path = property(_mupdf.fz_device_fill_path_get, _mupdf.fz_device_fill_path_set)
    stroke_path = property(_mupdf.fz_device_stroke_path_get, _mupdf.fz_device_stroke_path_set)
    clip_path = property(_mupdf.fz_device_clip_path_get, _mupdf.fz_device_clip_path_set)
    clip_stroke_path = property(_mupdf.fz_device_clip_stroke_path_get, _mupdf.fz_device_clip_stroke_path_set)
    fill_text = property(_mupdf.fz_device_fill_text_get, _mupdf.fz_device_fill_text_set)
    stroke_text = property(_mupdf.fz_device_stroke_text_get, _mupdf.fz_device_stroke_text_set)
    clip_text = property(_mupdf.fz_device_clip_text_get, _mupdf.fz_device_clip_text_set)
    clip_stroke_text = property(_mupdf.fz_device_clip_stroke_text_get, _mupdf.fz_device_clip_stroke_text_set)
    ignore_text = property(_mupdf.fz_device_ignore_text_get, _mupdf.fz_device_ignore_text_set)
    fill_shade = property(_mupdf.fz_device_fill_shade_get, _mupdf.fz_device_fill_shade_set)
    fill_image = property(_mupdf.fz_device_fill_image_get, _mupdf.fz_device_fill_image_set)
    fill_image_mask = property(_mupdf.fz_device_fill_image_mask_get, _mupdf.fz_device_fill_image_mask_set)
    clip_image_mask = property(_mupdf.fz_device_clip_image_mask_get, _mupdf.fz_device_clip_image_mask_set)
    pop_clip = property(_mupdf.fz_device_pop_clip_get, _mupdf.fz_device_pop_clip_set)
    begin_mask = property(_mupdf.fz_device_begin_mask_get, _mupdf.fz_device_begin_mask_set)
    end_mask = property(_mupdf.fz_device_end_mask_get, _mupdf.fz_device_end_mask_set)
    begin_group = property(_mupdf.fz_device_begin_group_get, _mupdf.fz_device_begin_group_set)
    end_group = property(_mupdf.fz_device_end_group_get, _mupdf.fz_device_end_group_set)
    begin_tile = property(_mupdf.fz_device_begin_tile_get, _mupdf.fz_device_begin_tile_set)
    end_tile = property(_mupdf.fz_device_end_tile_get, _mupdf.fz_device_end_tile_set)
    render_flags = property(_mupdf.fz_device_render_flags_get, _mupdf.fz_device_render_flags_set)
    set_default_colorspaces = property(_mupdf.fz_device_set_default_colorspaces_get, _mupdf.fz_device_set_default_colorspaces_set)
    begin_layer = property(_mupdf.fz_device_begin_layer_get, _mupdf.fz_device_begin_layer_set)
    end_layer = property(_mupdf.fz_device_end_layer_get, _mupdf.fz_device_end_layer_set)
    d1_rect = property(_mupdf.fz_device_d1_rect_get, _mupdf.fz_device_d1_rect_set)
    container_len = property(_mupdf.fz_device_container_len_get, _mupdf.fz_device_container_len_set)
    container_cap = property(_mupdf.fz_device_container_cap_get, _mupdf.fz_device_container_cap_set)
    container = property(_mupdf.fz_device_container_get, _mupdf.fz_device_container_set)

    def __init__(self):
        _mupdf.fz_device_swiginit(self, _mupdf.new_fz_device())
    __swig_destroy__ = _mupdf.delete_fz_device

# Register fz_device in _mupdf:
_mupdf.fz_device_swigregister(fz_device)

FZ_DONT_INTERPOLATE_IMAGES = _mupdf.FZ_DONT_INTERPOLATE_IMAGES
FZ_NO_CACHE = _mupdf.FZ_NO_CACHE
class fz_cookie(object):
    r"""
    Cookie support - simple communication channel between app/library.

    Provide two-way communication between application and library.
    Intended for multi-threaded applications where one thread is
    rendering pages and another thread wants to read progress
    feedback or abort a job that takes a long time to finish. The
    communication is unsynchronized without locking.

    abort: The application should set this field to 0 before
    calling fz_run_page to render a page. At any point when the
    page is being rendered the application my set this field to 1
    which will cause the rendering to finish soon. This field is
    checked periodically when the page is rendered, but exactly
    when is not known, therefore there is no upper bound on
    exactly when the rendering will abort. If the application
    did not provide a set of locks to fz_new_context, it must also
    await the completion of fz_run_page before issuing another
    call to fz_run_page. Note that once the application has set
    this field to 1 after it called fz_run_page it may not change
    the value again.

    progress: Communicates rendering progress back to the
    application and is read only. Increments as a page is being
    rendered. The value starts out at 0 and is limited to less
    than or equal to progress_max, unless progress_max is -1.

    progress_max: Communicates the known upper bound of rendering
    back to the application and is read only. The maximum value
    that the progress field may take. If there is no known upper
    bound on how long the rendering may take this value is -1 and
    progress is not limited. Note that the value of progress_max
    may change from -1 to a positive value once an upper bound is
    known, so take this into consideration when comparing the
    value of progress to that of progress_max.

    errors: count of errors during current rendering.

    incomplete: Initially should be set to 0. Will be set to
    non-zero if a TRYLATER error is thrown during rendering.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    progress = property(_mupdf.fz_cookie_progress_get, _mupdf.fz_cookie_progress_set)
    progress_max = property(_mupdf.fz_cookie_progress_max_get, _mupdf.fz_cookie_progress_max_set)
    errors = property(_mupdf.fz_cookie_errors_get, _mupdf.fz_cookie_errors_set)
    incomplete = property(_mupdf.fz_cookie_incomplete_get, _mupdf.fz_cookie_incomplete_set)

    def __init__(self):
        _mupdf.fz_cookie_swiginit(self, _mupdf.new_fz_cookie())
    __swig_destroy__ = _mupdf.delete_fz_cookie

# Register fz_cookie in _mupdf:
_mupdf.fz_cookie_swigregister(fz_cookie)

FZ_TEST_OPT_IMAGES = _mupdf.FZ_TEST_OPT_IMAGES
FZ_TEST_OPT_SHADINGS = _mupdf.FZ_TEST_OPT_SHADINGS
class fz_draw_options(object):
    r"""
    struct fz_draw_options: Options for creating a pixmap and draw
    device.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    rotate = property(_mupdf.fz_draw_options_rotate_get, _mupdf.fz_draw_options_rotate_set)
    x_resolution = property(_mupdf.fz_draw_options_x_resolution_get, _mupdf.fz_draw_options_x_resolution_set)
    y_resolution = property(_mupdf.fz_draw_options_y_resolution_get, _mupdf.fz_draw_options_y_resolution_set)
    width = property(_mupdf.fz_draw_options_width_get, _mupdf.fz_draw_options_width_set)
    height = property(_mupdf.fz_draw_options_height_get, _mupdf.fz_draw_options_height_set)
    colorspace = property(_mupdf.fz_draw_options_colorspace_get, _mupdf.fz_draw_options_colorspace_set)
    alpha = property(_mupdf.fz_draw_options_alpha_get, _mupdf.fz_draw_options_alpha_set)
    graphics = property(_mupdf.fz_draw_options_graphics_get, _mupdf.fz_draw_options_graphics_set)
    text = property(_mupdf.fz_draw_options_text_get, _mupdf.fz_draw_options_text_set)

    def __init__(self):
        _mupdf.fz_draw_options_swiginit(self, _mupdf.new_fz_draw_options())
    __swig_destroy__ = _mupdf.delete_fz_draw_options

# Register fz_draw_options in _mupdf:
_mupdf.fz_draw_options_swigregister(fz_draw_options)

class fz_location(object):
    r"""
    Locations within the document are referred to in terms of
    chapter and page, rather than just a page number. For some
    documents (such as epub documents with large numbers of pages
    broken into many chapters) this can make navigation much faster
    as only the required chapter needs to be decoded at a time.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    chapter = property(_mupdf.fz_location_chapter_get, _mupdf.fz_location_chapter_set)
    page = property(_mupdf.fz_location_page_get, _mupdf.fz_location_page_set)

    def __init__(self):
        _mupdf.fz_location_swiginit(self, _mupdf.new_fz_location())
    __swig_destroy__ = _mupdf.delete_fz_location

# Register fz_location in _mupdf:
_mupdf.fz_location_swigregister(fz_location)

class fz_layout_char(object):
    r"""	Simple text layout (for use with annotation editing primarily)."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    x = property(_mupdf.fz_layout_char_x_get, _mupdf.fz_layout_char_x_set)
    advance = property(_mupdf.fz_layout_char_advance_get, _mupdf.fz_layout_char_advance_set)
    p = property(_mupdf.fz_layout_char_p_get, _mupdf.fz_layout_char_p_set)
    next = property(_mupdf.fz_layout_char_next_get, _mupdf.fz_layout_char_next_set)

    def __init__(self):
        _mupdf.fz_layout_char_swiginit(self, _mupdf.new_fz_layout_char())
    __swig_destroy__ = _mupdf.delete_fz_layout_char

# Register fz_layout_char in _mupdf:
_mupdf.fz_layout_char_swigregister(fz_layout_char)

class fz_layout_line(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    x = property(_mupdf.fz_layout_line_x_get, _mupdf.fz_layout_line_x_set)
    y = property(_mupdf.fz_layout_line_y_get, _mupdf.fz_layout_line_y_set)
    font_size = property(_mupdf.fz_layout_line_font_size_get, _mupdf.fz_layout_line_font_size_set)
    p = property(_mupdf.fz_layout_line_p_get, _mupdf.fz_layout_line_p_set)
    text = property(_mupdf.fz_layout_line_text_get, _mupdf.fz_layout_line_text_set)
    next = property(_mupdf.fz_layout_line_next_get, _mupdf.fz_layout_line_next_set)

    def __init__(self):
        _mupdf.fz_layout_line_swiginit(self, _mupdf.new_fz_layout_line())
    __swig_destroy__ = _mupdf.delete_fz_layout_line

# Register fz_layout_line in _mupdf:
_mupdf.fz_layout_line_swigregister(fz_layout_line)

class fz_layout_block(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pool = property(_mupdf.fz_layout_block_pool_get, _mupdf.fz_layout_block_pool_set)
    matrix = property(_mupdf.fz_layout_block_matrix_get, _mupdf.fz_layout_block_matrix_set)
    inv_matrix = property(_mupdf.fz_layout_block_inv_matrix_get, _mupdf.fz_layout_block_inv_matrix_set)
    head = property(_mupdf.fz_layout_block_head_get, _mupdf.fz_layout_block_head_set)
    tailp = property(_mupdf.fz_layout_block_tailp_get, _mupdf.fz_layout_block_tailp_set)
    text_tailp = property(_mupdf.fz_layout_block_text_tailp_get, _mupdf.fz_layout_block_text_tailp_set)

    def __init__(self):
        _mupdf.fz_layout_block_swiginit(self, _mupdf.new_fz_layout_block())
    __swig_destroy__ = _mupdf.delete_fz_layout_block

# Register fz_layout_block in _mupdf:
_mupdf.fz_layout_block_swigregister(fz_layout_block)

FZ_STEXT_PRESERVE_LIGATURES = _mupdf.FZ_STEXT_PRESERVE_LIGATURES
FZ_STEXT_PRESERVE_WHITESPACE = _mupdf.FZ_STEXT_PRESERVE_WHITESPACE
FZ_STEXT_PRESERVE_IMAGES = _mupdf.FZ_STEXT_PRESERVE_IMAGES
FZ_STEXT_INHIBIT_SPACES = _mupdf.FZ_STEXT_INHIBIT_SPACES
FZ_STEXT_DEHYPHENATE = _mupdf.FZ_STEXT_DEHYPHENATE
FZ_STEXT_PRESERVE_SPANS = _mupdf.FZ_STEXT_PRESERVE_SPANS
FZ_STEXT_MEDIABOX_CLIP = _mupdf.FZ_STEXT_MEDIABOX_CLIP
class fz_stext_page(object):
    r"""
    A text page is a list of blocks, together with an overall
    bounding box.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pool = property(_mupdf.fz_stext_page_pool_get, _mupdf.fz_stext_page_pool_set)
    mediabox = property(_mupdf.fz_stext_page_mediabox_get, _mupdf.fz_stext_page_mediabox_set)
    first_block = property(_mupdf.fz_stext_page_first_block_get, _mupdf.fz_stext_page_first_block_set)
    last_block = property(_mupdf.fz_stext_page_last_block_get, _mupdf.fz_stext_page_last_block_set)

    def __init__(self):
        _mupdf.fz_stext_page_swiginit(self, _mupdf.new_fz_stext_page())
    __swig_destroy__ = _mupdf.delete_fz_stext_page

# Register fz_stext_page in _mupdf:
_mupdf.fz_stext_page_swigregister(fz_stext_page)

FZ_STEXT_BLOCK_TEXT = _mupdf.FZ_STEXT_BLOCK_TEXT
FZ_STEXT_BLOCK_IMAGE = _mupdf.FZ_STEXT_BLOCK_IMAGE
class fz_stext_block(object):
    r"""
    A text block is a list of lines of text (typically a paragraph),
    or an image.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    type = property(_mupdf.fz_stext_block_type_get, _mupdf.fz_stext_block_type_set)
    bbox = property(_mupdf.fz_stext_block_bbox_get, _mupdf.fz_stext_block_bbox_set)
    prev = property(_mupdf.fz_stext_block_prev_get, _mupdf.fz_stext_block_prev_set)
    next = property(_mupdf.fz_stext_block_next_get, _mupdf.fz_stext_block_next_set)

    def __init__(self):
        _mupdf.fz_stext_block_swiginit(self, _mupdf.new_fz_stext_block())
    __swig_destroy__ = _mupdf.delete_fz_stext_block

# Register fz_stext_block in _mupdf:
_mupdf.fz_stext_block_swigregister(fz_stext_block)

class fz_stext_line(object):
    r"""	A text line is a list of characters that share a common baseline."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    wmode = property(_mupdf.fz_stext_line_wmode_get, _mupdf.fz_stext_line_wmode_set)
    dir = property(_mupdf.fz_stext_line_dir_get, _mupdf.fz_stext_line_dir_set)
    bbox = property(_mupdf.fz_stext_line_bbox_get, _mupdf.fz_stext_line_bbox_set)
    first_char = property(_mupdf.fz_stext_line_first_char_get, _mupdf.fz_stext_line_first_char_set)
    last_char = property(_mupdf.fz_stext_line_last_char_get, _mupdf.fz_stext_line_last_char_set)
    prev = property(_mupdf.fz_stext_line_prev_get, _mupdf.fz_stext_line_prev_set)
    next = property(_mupdf.fz_stext_line_next_get, _mupdf.fz_stext_line_next_set)

    def __init__(self):
        _mupdf.fz_stext_line_swiginit(self, _mupdf.new_fz_stext_line())
    __swig_destroy__ = _mupdf.delete_fz_stext_line

# Register fz_stext_line in _mupdf:
_mupdf.fz_stext_line_swigregister(fz_stext_line)

class fz_stext_char(object):
    r"""
    A text char is a unicode character, the style in which is
    appears, and the point at which it is positioned.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    c = property(_mupdf.fz_stext_char_c_get, _mupdf.fz_stext_char_c_set)
    color = property(_mupdf.fz_stext_char_color_get, _mupdf.fz_stext_char_color_set)
    origin = property(_mupdf.fz_stext_char_origin_get, _mupdf.fz_stext_char_origin_set)
    quad = property(_mupdf.fz_stext_char_quad_get, _mupdf.fz_stext_char_quad_set)
    size = property(_mupdf.fz_stext_char_size_get, _mupdf.fz_stext_char_size_set)
    font = property(_mupdf.fz_stext_char_font_get, _mupdf.fz_stext_char_font_set)
    next = property(_mupdf.fz_stext_char_next_get, _mupdf.fz_stext_char_next_set)

    def __init__(self):
        _mupdf.fz_stext_char_swiginit(self, _mupdf.new_fz_stext_char())
    __swig_destroy__ = _mupdf.delete_fz_stext_char

# Register fz_stext_char in _mupdf:
_mupdf.fz_stext_char_swigregister(fz_stext_char)

FZ_SELECT_CHARS = _mupdf.FZ_SELECT_CHARS
FZ_SELECT_WORDS = _mupdf.FZ_SELECT_WORDS
FZ_SELECT_LINES = _mupdf.FZ_SELECT_LINES
class fz_stext_options(object):
    r"""	Options for creating a pixmap and draw device."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    flags = property(_mupdf.fz_stext_options_flags_get, _mupdf.fz_stext_options_flags_set)
    scale = property(_mupdf.fz_stext_options_scale_get, _mupdf.fz_stext_options_scale_set)

    def __init__(self):
        _mupdf.fz_stext_options_swiginit(self, _mupdf.new_fz_stext_options())
    __swig_destroy__ = _mupdf.delete_fz_stext_options

# Register fz_stext_options in _mupdf:
_mupdf.fz_stext_options_swigregister(fz_stext_options)

FZ_TRANSITION_NONE = _mupdf.FZ_TRANSITION_NONE
FZ_TRANSITION_SPLIT = _mupdf.FZ_TRANSITION_SPLIT
FZ_TRANSITION_BLINDS = _mupdf.FZ_TRANSITION_BLINDS
FZ_TRANSITION_BOX = _mupdf.FZ_TRANSITION_BOX
FZ_TRANSITION_WIPE = _mupdf.FZ_TRANSITION_WIPE
FZ_TRANSITION_DISSOLVE = _mupdf.FZ_TRANSITION_DISSOLVE
FZ_TRANSITION_GLITTER = _mupdf.FZ_TRANSITION_GLITTER
FZ_TRANSITION_FLY = _mupdf.FZ_TRANSITION_FLY
FZ_TRANSITION_PUSH = _mupdf.FZ_TRANSITION_PUSH
FZ_TRANSITION_COVER = _mupdf.FZ_TRANSITION_COVER
FZ_TRANSITION_UNCOVER = _mupdf.FZ_TRANSITION_UNCOVER
FZ_TRANSITION_FADE = _mupdf.FZ_TRANSITION_FADE
class fz_transition(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    type = property(_mupdf.fz_transition_type_get, _mupdf.fz_transition_type_set)
    duration = property(_mupdf.fz_transition_duration_get, _mupdf.fz_transition_duration_set)
    vertical = property(_mupdf.fz_transition_vertical_get, _mupdf.fz_transition_vertical_set)
    outwards = property(_mupdf.fz_transition_outwards_get, _mupdf.fz_transition_outwards_set)
    direction = property(_mupdf.fz_transition_direction_get, _mupdf.fz_transition_direction_set)
    state0 = property(_mupdf.fz_transition_state0_get, _mupdf.fz_transition_state0_set)
    state1 = property(_mupdf.fz_transition_state1_get, _mupdf.fz_transition_state1_set)

    def __init__(self):
        _mupdf.fz_transition_swiginit(self, _mupdf.new_fz_transition())
    __swig_destroy__ = _mupdf.delete_fz_transition

# Register fz_transition in _mupdf:
_mupdf.fz_transition_swigregister(fz_transition)

class fz_link(object):
    r"""
    fz_link is a list of interactive links on a page.

    There is no relation between the order of the links in the
    list and the order they appear on the page. The list of links
    for a given page can be obtained from fz_load_links.

    A link is reference counted. Dropping a reference to a link is
    done by calling fz_drop_link.

    rect: The hot zone. The area that can be clicked in
    untransformed coordinates.

    uri: Link destinations come in two forms: internal and external.
    Internal links refer to other pages in the same document.
    External links are URLs to other documents.

    next: A pointer to the next link on the same page.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    refs = property(_mupdf.fz_link_refs_get, _mupdf.fz_link_refs_set)
    next = property(_mupdf.fz_link_next_get, _mupdf.fz_link_next_set)
    rect = property(_mupdf.fz_link_rect_get, _mupdf.fz_link_rect_set)
    uri = property(_mupdf.fz_link_uri_get, _mupdf.fz_link_uri_set)

    def __init__(self):
        _mupdf.fz_link_swiginit(self, _mupdf.new_fz_link())
    __swig_destroy__ = _mupdf.delete_fz_link

# Register fz_link in _mupdf:
_mupdf.fz_link_swigregister(fz_link)

FZ_LINK_DEST_FIT = _mupdf.FZ_LINK_DEST_FIT
FZ_LINK_DEST_FIT_B = _mupdf.FZ_LINK_DEST_FIT_B
FZ_LINK_DEST_FIT_H = _mupdf.FZ_LINK_DEST_FIT_H
FZ_LINK_DEST_FIT_BH = _mupdf.FZ_LINK_DEST_FIT_BH
FZ_LINK_DEST_FIT_V = _mupdf.FZ_LINK_DEST_FIT_V
FZ_LINK_DEST_FIT_BV = _mupdf.FZ_LINK_DEST_FIT_BV
FZ_LINK_DEST_FIT_R = _mupdf.FZ_LINK_DEST_FIT_R
FZ_LINK_DEST_XYZ = _mupdf.FZ_LINK_DEST_XYZ
class fz_link_dest(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    loc = property(_mupdf.fz_link_dest_loc_get, _mupdf.fz_link_dest_loc_set)
    type = property(_mupdf.fz_link_dest_type_get, _mupdf.fz_link_dest_type_set)
    x = property(_mupdf.fz_link_dest_x_get, _mupdf.fz_link_dest_x_set)
    y = property(_mupdf.fz_link_dest_y_get, _mupdf.fz_link_dest_y_set)
    w = property(_mupdf.fz_link_dest_w_get, _mupdf.fz_link_dest_w_set)
    h = property(_mupdf.fz_link_dest_h_get, _mupdf.fz_link_dest_h_set)
    zoom = property(_mupdf.fz_link_dest_zoom_get, _mupdf.fz_link_dest_zoom_set)

    def __init__(self):
        _mupdf.fz_link_dest_swiginit(self, _mupdf.new_fz_link_dest())
    __swig_destroy__ = _mupdf.delete_fz_link_dest

# Register fz_link_dest in _mupdf:
_mupdf.fz_link_dest_swigregister(fz_link_dest)

class fz_outline_item(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    title = property(_mupdf.fz_outline_item_title_get, _mupdf.fz_outline_item_title_set)
    uri = property(_mupdf.fz_outline_item_uri_get, _mupdf.fz_outline_item_uri_set)
    is_open = property(_mupdf.fz_outline_item_is_open_get, _mupdf.fz_outline_item_is_open_set)

    def __init__(self):
        _mupdf.fz_outline_item_swiginit(self, _mupdf.new_fz_outline_item())
    __swig_destroy__ = _mupdf.delete_fz_outline_item

# Register fz_outline_item in _mupdf:
_mupdf.fz_outline_item_swigregister(fz_outline_item)

class fz_outline(object):
    r"""
    Structure based API
    fz_outline is a tree of the outline of a document (also known
    as table of contents).

    title: Title of outline item using UTF-8 encoding. May be NULL
    if the outline item has no text string.

    uri: Destination in the document to be displayed when this
    outline item is activated. May be an internal or external
    link, or NULL if the outline item does not have a destination.

    page: The page number of an internal link, or -1 for external
    links or links with no destination.

    next: The next outline item at the same level as this outline
    item. May be NULL if no more outline items exist at this level.

    down: The outline items immediate children in the hierarchy.
    May be NULL if no children exist.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    refs = property(_mupdf.fz_outline_refs_get, _mupdf.fz_outline_refs_set)
    title = property(_mupdf.fz_outline_title_get, _mupdf.fz_outline_title_set)
    uri = property(_mupdf.fz_outline_uri_get, _mupdf.fz_outline_uri_set)
    page = property(_mupdf.fz_outline_page_get, _mupdf.fz_outline_page_set)
    x = property(_mupdf.fz_outline_x_get, _mupdf.fz_outline_x_set)
    y = property(_mupdf.fz_outline_y_get, _mupdf.fz_outline_y_set)
    next = property(_mupdf.fz_outline_next_get, _mupdf.fz_outline_next_set)
    down = property(_mupdf.fz_outline_down_get, _mupdf.fz_outline_down_set)
    is_open = property(_mupdf.fz_outline_is_open_get, _mupdf.fz_outline_is_open_set)

    def __init__(self):
        _mupdf.fz_outline_swiginit(self, _mupdf.new_fz_outline())
    __swig_destroy__ = _mupdf.delete_fz_outline

# Register fz_outline in _mupdf:
_mupdf.fz_outline_swigregister(fz_outline)

class fz_outline_iterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    drop = property(_mupdf.fz_outline_iterator_drop_get, _mupdf.fz_outline_iterator_drop_set)
    item = property(_mupdf.fz_outline_iterator_item_get, _mupdf.fz_outline_iterator_item_set)
    next = property(_mupdf.fz_outline_iterator_next_get, _mupdf.fz_outline_iterator_next_set)
    prev = property(_mupdf.fz_outline_iterator_prev_get, _mupdf.fz_outline_iterator_prev_set)
    up = property(_mupdf.fz_outline_iterator_up_get, _mupdf.fz_outline_iterator_up_set)
    down = property(_mupdf.fz_outline_iterator_down_get, _mupdf.fz_outline_iterator_down_set)
    insert = property(_mupdf.fz_outline_iterator_insert_get, _mupdf.fz_outline_iterator_insert_set)
    update = property(_mupdf.fz_outline_iterator_update_get, _mupdf.fz_outline_iterator_update_set)
    _del = property(_mupdf.fz_outline_iterator__del_get, _mupdf.fz_outline_iterator__del_set)
    doc = property(_mupdf.fz_outline_iterator_doc_get, _mupdf.fz_outline_iterator_doc_set)

    def __init__(self):
        _mupdf.fz_outline_iterator_swiginit(self, _mupdf.new_fz_outline_iterator())
    __swig_destroy__ = _mupdf.delete_fz_outline_iterator

# Register fz_outline_iterator in _mupdf:
_mupdf.fz_outline_iterator_swigregister(fz_outline_iterator)

FZ_LAYOUT_KINDLE_W = _mupdf.FZ_LAYOUT_KINDLE_W
FZ_LAYOUT_KINDLE_H = _mupdf.FZ_LAYOUT_KINDLE_H
FZ_LAYOUT_KINDLE_EM = _mupdf.FZ_LAYOUT_KINDLE_EM
FZ_LAYOUT_US_POCKET_W = _mupdf.FZ_LAYOUT_US_POCKET_W
FZ_LAYOUT_US_POCKET_H = _mupdf.FZ_LAYOUT_US_POCKET_H
FZ_LAYOUT_US_POCKET_EM = _mupdf.FZ_LAYOUT_US_POCKET_EM
FZ_LAYOUT_US_TRADE_W = _mupdf.FZ_LAYOUT_US_TRADE_W
FZ_LAYOUT_US_TRADE_H = _mupdf.FZ_LAYOUT_US_TRADE_H
FZ_LAYOUT_US_TRADE_EM = _mupdf.FZ_LAYOUT_US_TRADE_EM
FZ_LAYOUT_UK_A_FORMAT_W = _mupdf.FZ_LAYOUT_UK_A_FORMAT_W
FZ_LAYOUT_UK_A_FORMAT_H = _mupdf.FZ_LAYOUT_UK_A_FORMAT_H
FZ_LAYOUT_UK_A_FORMAT_EM = _mupdf.FZ_LAYOUT_UK_A_FORMAT_EM
FZ_LAYOUT_UK_B_FORMAT_W = _mupdf.FZ_LAYOUT_UK_B_FORMAT_W
FZ_LAYOUT_UK_B_FORMAT_H = _mupdf.FZ_LAYOUT_UK_B_FORMAT_H
FZ_LAYOUT_UK_B_FORMAT_EM = _mupdf.FZ_LAYOUT_UK_B_FORMAT_EM
FZ_LAYOUT_UK_C_FORMAT_W = _mupdf.FZ_LAYOUT_UK_C_FORMAT_W
FZ_LAYOUT_UK_C_FORMAT_H = _mupdf.FZ_LAYOUT_UK_C_FORMAT_H
FZ_LAYOUT_UK_C_FORMAT_EM = _mupdf.FZ_LAYOUT_UK_C_FORMAT_EM
FZ_LAYOUT_A5_W = _mupdf.FZ_LAYOUT_A5_W
FZ_LAYOUT_A5_H = _mupdf.FZ_LAYOUT_A5_H
FZ_LAYOUT_A5_EM = _mupdf.FZ_LAYOUT_A5_EM
FZ_DEFAULT_LAYOUT_W = _mupdf.FZ_DEFAULT_LAYOUT_W
FZ_DEFAULT_LAYOUT_H = _mupdf.FZ_DEFAULT_LAYOUT_H
FZ_DEFAULT_LAYOUT_EM = _mupdf.FZ_DEFAULT_LAYOUT_EM
FZ_PERMISSION_PRINT = _mupdf.FZ_PERMISSION_PRINT
FZ_PERMISSION_COPY = _mupdf.FZ_PERMISSION_COPY
FZ_PERMISSION_EDIT = _mupdf.FZ_PERMISSION_EDIT
FZ_PERMISSION_ANNOTATE = _mupdf.FZ_PERMISSION_ANNOTATE
FZ_META_FORMAT = _mupdf.FZ_META_FORMAT
FZ_META_ENCRYPTION = _mupdf.FZ_META_ENCRYPTION
FZ_META_INFO = _mupdf.FZ_META_INFO
FZ_META_INFO_TITLE = _mupdf.FZ_META_INFO_TITLE
FZ_META_INFO_AUTHOR = _mupdf.FZ_META_INFO_AUTHOR
FZ_META_INFO_SUBJECT = _mupdf.FZ_META_INFO_SUBJECT
FZ_META_INFO_KEYWORDS = _mupdf.FZ_META_INFO_KEYWORDS
FZ_META_INFO_CREATOR = _mupdf.FZ_META_INFO_CREATOR
FZ_META_INFO_PRODUCER = _mupdf.FZ_META_INFO_PRODUCER
FZ_META_INFO_CREATIONDATE = _mupdf.FZ_META_INFO_CREATIONDATE
FZ_META_INFO_MODIFICATIONDATE = _mupdf.FZ_META_INFO_MODIFICATIONDATE
class fz_page(object):
    r"""
    Structure definition is public so other classes can
    derive from it. Do not access the members directly.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    refs = property(_mupdf.fz_page_refs_get, _mupdf.fz_page_refs_set)
    doc = property(_mupdf.fz_page_doc_get, _mupdf.fz_page_doc_set)
    chapter = property(_mupdf.fz_page_chapter_get, _mupdf.fz_page_chapter_set)
    number = property(_mupdf.fz_page_number_get, _mupdf.fz_page_number_set)
    incomplete = property(_mupdf.fz_page_incomplete_get, _mupdf.fz_page_incomplete_set)
    drop_page = property(_mupdf.fz_page_drop_page_get, _mupdf.fz_page_drop_page_set)
    bound_page = property(_mupdf.fz_page_bound_page_get, _mupdf.fz_page_bound_page_set)
    run_page_contents = property(_mupdf.fz_page_run_page_contents_get, _mupdf.fz_page_run_page_contents_set)
    run_page_annots = property(_mupdf.fz_page_run_page_annots_get, _mupdf.fz_page_run_page_annots_set)
    run_page_widgets = property(_mupdf.fz_page_run_page_widgets_get, _mupdf.fz_page_run_page_widgets_set)
    load_links = property(_mupdf.fz_page_load_links_get, _mupdf.fz_page_load_links_set)
    page_presentation = property(_mupdf.fz_page_page_presentation_get, _mupdf.fz_page_page_presentation_set)
    control_separation = property(_mupdf.fz_page_control_separation_get, _mupdf.fz_page_control_separation_set)
    separation_disabled = property(_mupdf.fz_page_separation_disabled_get, _mupdf.fz_page_separation_disabled_set)
    separations = property(_mupdf.fz_page_separations_get, _mupdf.fz_page_separations_set)
    overprint = property(_mupdf.fz_page_overprint_get, _mupdf.fz_page_overprint_set)
    create_link = property(_mupdf.fz_page_create_link_get, _mupdf.fz_page_create_link_set)
    prev = property(_mupdf.fz_page_prev_get, _mupdf.fz_page_prev_set)
    next = property(_mupdf.fz_page_next_get, _mupdf.fz_page_next_set)

    def __init__(self):
        _mupdf.fz_page_swiginit(self, _mupdf.new_fz_page())
    __swig_destroy__ = _mupdf.delete_fz_page

# Register fz_page in _mupdf:
_mupdf.fz_page_swigregister(fz_page)

class fz_document(object):
    r"""
    Structure definition is public so other classes can
    derive from it. Callers should not access the members
    directly, though implementations will need initialize
    functions directly.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    refs = property(_mupdf.fz_document_refs_get, _mupdf.fz_document_refs_set)
    drop_document = property(_mupdf.fz_document_drop_document_get, _mupdf.fz_document_drop_document_set)
    needs_password = property(_mupdf.fz_document_needs_password_get, _mupdf.fz_document_needs_password_set)
    authenticate_password = property(_mupdf.fz_document_authenticate_password_get, _mupdf.fz_document_authenticate_password_set)
    has_permission = property(_mupdf.fz_document_has_permission_get, _mupdf.fz_document_has_permission_set)
    load_outline = property(_mupdf.fz_document_load_outline_get, _mupdf.fz_document_load_outline_set)
    outline_iterator = property(_mupdf.fz_document_outline_iterator_get, _mupdf.fz_document_outline_iterator_set)
    layout = property(_mupdf.fz_document_layout_get, _mupdf.fz_document_layout_set)
    make_bookmark = property(_mupdf.fz_document_make_bookmark_get, _mupdf.fz_document_make_bookmark_set)
    lookup_bookmark = property(_mupdf.fz_document_lookup_bookmark_get, _mupdf.fz_document_lookup_bookmark_set)
    resolve_link_dest = property(_mupdf.fz_document_resolve_link_dest_get, _mupdf.fz_document_resolve_link_dest_set)
    format_link_uri = property(_mupdf.fz_document_format_link_uri_get, _mupdf.fz_document_format_link_uri_set)
    count_chapters = property(_mupdf.fz_document_count_chapters_get, _mupdf.fz_document_count_chapters_set)
    count_pages = property(_mupdf.fz_document_count_pages_get, _mupdf.fz_document_count_pages_set)
    load_page = property(_mupdf.fz_document_load_page_get, _mupdf.fz_document_load_page_set)
    lookup_metadata = property(_mupdf.fz_document_lookup_metadata_get, _mupdf.fz_document_lookup_metadata_set)
    set_metadata = property(_mupdf.fz_document_set_metadata_get, _mupdf.fz_document_set_metadata_set)
    get_output_intent = property(_mupdf.fz_document_get_output_intent_get, _mupdf.fz_document_get_output_intent_set)
    output_accelerator = property(_mupdf.fz_document_output_accelerator_get, _mupdf.fz_document_output_accelerator_set)
    did_layout = property(_mupdf.fz_document_did_layout_get, _mupdf.fz_document_did_layout_set)
    is_reflowable = property(_mupdf.fz_document_is_reflowable_get, _mupdf.fz_document_is_reflowable_set)
    open = property(_mupdf.fz_document_open_get, _mupdf.fz_document_open_set)

    def __init__(self):
        _mupdf.fz_document_swiginit(self, _mupdf.new_fz_document())
    __swig_destroy__ = _mupdf.delete_fz_document

# Register fz_document in _mupdf:
_mupdf.fz_document_swigregister(fz_document)

class fz_document_handler(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    recognize = property(_mupdf.fz_document_handler_recognize_get, _mupdf.fz_document_handler_recognize_set)
    open = property(_mupdf.fz_document_handler_open_get, _mupdf.fz_document_handler_open_set)
    open_with_stream = property(_mupdf.fz_document_handler_open_with_stream_get, _mupdf.fz_document_handler_open_with_stream_set)
    extensions = property(_mupdf.fz_document_handler_extensions_get, _mupdf.fz_document_handler_extensions_set)
    mimetypes = property(_mupdf.fz_document_handler_mimetypes_get, _mupdf.fz_document_handler_mimetypes_set)
    open_accel = property(_mupdf.fz_document_handler_open_accel_get, _mupdf.fz_document_handler_open_accel_set)
    open_accel_with_stream = property(_mupdf.fz_document_handler_open_accel_with_stream_get, _mupdf.fz_document_handler_open_accel_with_stream_set)

    def __init__(self):
        _mupdf.fz_document_handler_swiginit(self, _mupdf.new_fz_document_handler())
    __swig_destroy__ = _mupdf.delete_fz_document_handler

# Register fz_document_handler in _mupdf:
_mupdf.fz_document_handler_swigregister(fz_document_handler)

class fz_document_writer(object):
    r"""
    Structure is public to allow other structures to
    be derived from it. Do not access members directly.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    begin_page = property(_mupdf.fz_document_writer_begin_page_get, _mupdf.fz_document_writer_begin_page_set)
    end_page = property(_mupdf.fz_document_writer_end_page_get, _mupdf.fz_document_writer_end_page_set)
    close_writer = property(_mupdf.fz_document_writer_close_writer_get, _mupdf.fz_document_writer_close_writer_set)
    drop_writer = property(_mupdf.fz_document_writer_drop_writer_get, _mupdf.fz_document_writer_drop_writer_set)
    dev = property(_mupdf.fz_document_writer_dev_get, _mupdf.fz_document_writer_dev_set)

    def __init__(self):
        _mupdf.fz_document_writer_swiginit(self, _mupdf.new_fz_document_writer())
    __swig_destroy__ = _mupdf.delete_fz_document_writer

# Register fz_document_writer in _mupdf:
_mupdf.fz_document_writer_swigregister(fz_document_writer)

class fz_band_writer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    drop = property(_mupdf.fz_band_writer_drop_get, _mupdf.fz_band_writer_drop_set)
    close = property(_mupdf.fz_band_writer_close_get, _mupdf.fz_band_writer_close_set)
    header = property(_mupdf.fz_band_writer_header_get, _mupdf.fz_band_writer_header_set)
    band = property(_mupdf.fz_band_writer_band_get, _mupdf.fz_band_writer_band_set)
    trailer = property(_mupdf.fz_band_writer_trailer_get, _mupdf.fz_band_writer_trailer_set)
    out = property(_mupdf.fz_band_writer_out_get, _mupdf.fz_band_writer_out_set)
    w = property(_mupdf.fz_band_writer_w_get, _mupdf.fz_band_writer_w_set)
    h = property(_mupdf.fz_band_writer_h_get, _mupdf.fz_band_writer_h_set)
    n = property(_mupdf.fz_band_writer_n_get, _mupdf.fz_band_writer_n_set)
    s = property(_mupdf.fz_band_writer_s_get, _mupdf.fz_band_writer_s_set)
    alpha = property(_mupdf.fz_band_writer_alpha_get, _mupdf.fz_band_writer_alpha_set)
    xres = property(_mupdf.fz_band_writer_xres_get, _mupdf.fz_band_writer_xres_set)
    yres = property(_mupdf.fz_band_writer_yres_get, _mupdf.fz_band_writer_yres_set)
    pagenum = property(_mupdf.fz_band_writer_pagenum_get, _mupdf.fz_band_writer_pagenum_set)
    line = property(_mupdf.fz_band_writer_line_get, _mupdf.fz_band_writer_line_set)
    seps = property(_mupdf.fz_band_writer_seps_get, _mupdf.fz_band_writer_seps_set)

    def __init__(self):
        _mupdf.fz_band_writer_swiginit(self, _mupdf.new_fz_band_writer())
    __swig_destroy__ = _mupdf.delete_fz_band_writer

# Register fz_band_writer in _mupdf:
_mupdf.fz_band_writer_swigregister(fz_band_writer)

class fz_pcl_options(object):
    r"""	PCL output"""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    features = property(_mupdf.fz_pcl_options_features_get, _mupdf.fz_pcl_options_features_set)
    odd_page_init = property(_mupdf.fz_pcl_options_odd_page_init_get, _mupdf.fz_pcl_options_odd_page_init_set)
    even_page_init = property(_mupdf.fz_pcl_options_even_page_init_get, _mupdf.fz_pcl_options_even_page_init_set)
    tumble = property(_mupdf.fz_pcl_options_tumble_get, _mupdf.fz_pcl_options_tumble_set)
    duplex_set = property(_mupdf.fz_pcl_options_duplex_set_get, _mupdf.fz_pcl_options_duplex_set_set)
    duplex = property(_mupdf.fz_pcl_options_duplex_get, _mupdf.fz_pcl_options_duplex_set)
    paper_size = property(_mupdf.fz_pcl_options_paper_size_get, _mupdf.fz_pcl_options_paper_size_set)
    manual_feed_set = property(_mupdf.fz_pcl_options_manual_feed_set_get, _mupdf.fz_pcl_options_manual_feed_set_set)
    manual_feed = property(_mupdf.fz_pcl_options_manual_feed_get, _mupdf.fz_pcl_options_manual_feed_set)
    media_position_set = property(_mupdf.fz_pcl_options_media_position_set_get, _mupdf.fz_pcl_options_media_position_set_set)
    media_position = property(_mupdf.fz_pcl_options_media_position_get, _mupdf.fz_pcl_options_media_position_set)
    orientation = property(_mupdf.fz_pcl_options_orientation_get, _mupdf.fz_pcl_options_orientation_set)
    page_count = property(_mupdf.fz_pcl_options_page_count_get, _mupdf.fz_pcl_options_page_count_set)

    def __init__(self):
        _mupdf.fz_pcl_options_swiginit(self, _mupdf.new_fz_pcl_options())
    __swig_destroy__ = _mupdf.delete_fz_pcl_options

# Register fz_pcl_options in _mupdf:
_mupdf.fz_pcl_options_swigregister(fz_pcl_options)

class fz_pclm_options(object):
    r"""	PCLm output"""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    compress = property(_mupdf.fz_pclm_options_compress_get, _mupdf.fz_pclm_options_compress_set)
    strip_height = property(_mupdf.fz_pclm_options_strip_height_get, _mupdf.fz_pclm_options_strip_height_set)
    page_count = property(_mupdf.fz_pclm_options_page_count_get, _mupdf.fz_pclm_options_page_count_set)

    def __init__(self):
        _mupdf.fz_pclm_options_swiginit(self, _mupdf.new_fz_pclm_options())
    __swig_destroy__ = _mupdf.delete_fz_pclm_options

# Register fz_pclm_options in _mupdf:
_mupdf.fz_pclm_options_swigregister(fz_pclm_options)

class fz_pdfocr_options(object):
    r"""	PDFOCR output"""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    compress = property(_mupdf.fz_pdfocr_options_compress_get, _mupdf.fz_pdfocr_options_compress_set)
    strip_height = property(_mupdf.fz_pdfocr_options_strip_height_get, _mupdf.fz_pdfocr_options_strip_height_set)
    language = property(_mupdf.fz_pdfocr_options_language_get, _mupdf.fz_pdfocr_options_language_set)
    datadir = property(_mupdf.fz_pdfocr_options_datadir_get, _mupdf.fz_pdfocr_options_datadir_set)
    page_count = property(_mupdf.fz_pdfocr_options_page_count_get, _mupdf.fz_pdfocr_options_page_count_set)

    def __init__(self):
        _mupdf.fz_pdfocr_options_swiginit(self, _mupdf.new_fz_pdfocr_options())
    __swig_destroy__ = _mupdf.delete_fz_pdfocr_options

# Register fz_pdfocr_options in _mupdf:
_mupdf.fz_pdfocr_options_swigregister(fz_pdfocr_options)

class fz_pwg_options(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    media_class = property(_mupdf.fz_pwg_options_media_class_get, _mupdf.fz_pwg_options_media_class_set)
    media_color = property(_mupdf.fz_pwg_options_media_color_get, _mupdf.fz_pwg_options_media_color_set)
    media_type = property(_mupdf.fz_pwg_options_media_type_get, _mupdf.fz_pwg_options_media_type_set)
    output_type = property(_mupdf.fz_pwg_options_output_type_get, _mupdf.fz_pwg_options_output_type_set)
    advance_distance = property(_mupdf.fz_pwg_options_advance_distance_get, _mupdf.fz_pwg_options_advance_distance_set)
    advance_media = property(_mupdf.fz_pwg_options_advance_media_get, _mupdf.fz_pwg_options_advance_media_set)
    collate = property(_mupdf.fz_pwg_options_collate_get, _mupdf.fz_pwg_options_collate_set)
    cut_media = property(_mupdf.fz_pwg_options_cut_media_get, _mupdf.fz_pwg_options_cut_media_set)
    duplex = property(_mupdf.fz_pwg_options_duplex_get, _mupdf.fz_pwg_options_duplex_set)
    insert_sheet = property(_mupdf.fz_pwg_options_insert_sheet_get, _mupdf.fz_pwg_options_insert_sheet_set)
    jog = property(_mupdf.fz_pwg_options_jog_get, _mupdf.fz_pwg_options_jog_set)
    leading_edge = property(_mupdf.fz_pwg_options_leading_edge_get, _mupdf.fz_pwg_options_leading_edge_set)
    manual_feed = property(_mupdf.fz_pwg_options_manual_feed_get, _mupdf.fz_pwg_options_manual_feed_set)
    media_position = property(_mupdf.fz_pwg_options_media_position_get, _mupdf.fz_pwg_options_media_position_set)
    media_weight = property(_mupdf.fz_pwg_options_media_weight_get, _mupdf.fz_pwg_options_media_weight_set)
    mirror_print = property(_mupdf.fz_pwg_options_mirror_print_get, _mupdf.fz_pwg_options_mirror_print_set)
    negative_print = property(_mupdf.fz_pwg_options_negative_print_get, _mupdf.fz_pwg_options_negative_print_set)
    num_copies = property(_mupdf.fz_pwg_options_num_copies_get, _mupdf.fz_pwg_options_num_copies_set)
    orientation = property(_mupdf.fz_pwg_options_orientation_get, _mupdf.fz_pwg_options_orientation_set)
    output_face_up = property(_mupdf.fz_pwg_options_output_face_up_get, _mupdf.fz_pwg_options_output_face_up_set)
    PageSize = property(_mupdf.fz_pwg_options_PageSize_get, _mupdf.fz_pwg_options_PageSize_set)
    separations = property(_mupdf.fz_pwg_options_separations_get, _mupdf.fz_pwg_options_separations_set)
    tray_switch = property(_mupdf.fz_pwg_options_tray_switch_get, _mupdf.fz_pwg_options_tray_switch_set)
    tumble = property(_mupdf.fz_pwg_options_tumble_get, _mupdf.fz_pwg_options_tumble_set)
    media_type_num = property(_mupdf.fz_pwg_options_media_type_num_get, _mupdf.fz_pwg_options_media_type_num_set)
    compression = property(_mupdf.fz_pwg_options_compression_get, _mupdf.fz_pwg_options_compression_set)
    row_count = property(_mupdf.fz_pwg_options_row_count_get, _mupdf.fz_pwg_options_row_count_set)
    row_feed = property(_mupdf.fz_pwg_options_row_feed_get, _mupdf.fz_pwg_options_row_feed_set)
    row_step = property(_mupdf.fz_pwg_options_row_step_get, _mupdf.fz_pwg_options_row_step_set)
    rendering_intent = property(_mupdf.fz_pwg_options_rendering_intent_get, _mupdf.fz_pwg_options_rendering_intent_set)
    page_size_name = property(_mupdf.fz_pwg_options_page_size_name_get, _mupdf.fz_pwg_options_page_size_name_set)

    def __init__(self):
        _mupdf.fz_pwg_options_swiginit(self, _mupdf.new_fz_pwg_options())
    __swig_destroy__ = _mupdf.delete_fz_pwg_options

# Register fz_pwg_options in _mupdf:
_mupdf.fz_pwg_options_swigregister(fz_pwg_options)

FZ_SVG_TEXT_AS_PATH = _mupdf.FZ_SVG_TEXT_AS_PATH
FZ_SVG_TEXT_AS_TEXT = _mupdf.FZ_SVG_TEXT_AS_TEXT
PDF_MAX_OBJECT_NUMBER = _mupdf.PDF_MAX_OBJECT_NUMBER
PDF_MAX_GEN_NUMBER = _mupdf.PDF_MAX_GEN_NUMBER
class pdf_mark_list(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    len = property(_mupdf.pdf_mark_list_len_get, _mupdf.pdf_mark_list_len_set)
    max = property(_mupdf.pdf_mark_list_max_get, _mupdf.pdf_mark_list_max_set)
    list = property(_mupdf.pdf_mark_list_list_get, _mupdf.pdf_mark_list_list_set)

    def __init__(self):
        _mupdf.pdf_mark_list_swiginit(self, _mupdf.new_pdf_mark_list())
    __swig_destroy__ = _mupdf.delete_pdf_mark_list

# Register pdf_mark_list in _mupdf:
_mupdf.pdf_mark_list_swigregister(pdf_mark_list)

PDF_ENUM_NULL = _mupdf.PDF_ENUM_NULL
PDF_ENUM_TRUE = _mupdf.PDF_ENUM_TRUE
PDF_ENUM_FALSE = _mupdf.PDF_ENUM_FALSE
PDF_ENUM_NAME_1_2 = _mupdf.PDF_ENUM_NAME_1_2
PDF_ENUM_NAME_3D = _mupdf.PDF_ENUM_NAME_3D
PDF_ENUM_NAME_A = _mupdf.PDF_ENUM_NAME_A
PDF_ENUM_NAME_A85 = _mupdf.PDF_ENUM_NAME_A85
PDF_ENUM_NAME_AA = _mupdf.PDF_ENUM_NAME_AA
PDF_ENUM_NAME_AC = _mupdf.PDF_ENUM_NAME_AC
PDF_ENUM_NAME_AESV2 = _mupdf.PDF_ENUM_NAME_AESV2
PDF_ENUM_NAME_AESV3 = _mupdf.PDF_ENUM_NAME_AESV3
PDF_ENUM_NAME_AHx = _mupdf.PDF_ENUM_NAME_AHx
PDF_ENUM_NAME_AP = _mupdf.PDF_ENUM_NAME_AP
PDF_ENUM_NAME_AS = _mupdf.PDF_ENUM_NAME_AS
PDF_ENUM_NAME_ASCII85Decode = _mupdf.PDF_ENUM_NAME_ASCII85Decode
PDF_ENUM_NAME_ASCIIHexDecode = _mupdf.PDF_ENUM_NAME_ASCIIHexDecode
PDF_ENUM_NAME_AcroForm = _mupdf.PDF_ENUM_NAME_AcroForm
PDF_ENUM_NAME_Action = _mupdf.PDF_ENUM_NAME_Action
PDF_ENUM_NAME_ActualText = _mupdf.PDF_ENUM_NAME_ActualText
PDF_ENUM_NAME_Adobe_PPKLite = _mupdf.PDF_ENUM_NAME_Adobe_PPKLite
PDF_ENUM_NAME_All = _mupdf.PDF_ENUM_NAME_All
PDF_ENUM_NAME_AllOff = _mupdf.PDF_ENUM_NAME_AllOff
PDF_ENUM_NAME_AllOn = _mupdf.PDF_ENUM_NAME_AllOn
PDF_ENUM_NAME_Alpha = _mupdf.PDF_ENUM_NAME_Alpha
PDF_ENUM_NAME_Alt = _mupdf.PDF_ENUM_NAME_Alt
PDF_ENUM_NAME_Alternate = _mupdf.PDF_ENUM_NAME_Alternate
PDF_ENUM_NAME_Annot = _mupdf.PDF_ENUM_NAME_Annot
PDF_ENUM_NAME_Annots = _mupdf.PDF_ENUM_NAME_Annots
PDF_ENUM_NAME_AnyOff = _mupdf.PDF_ENUM_NAME_AnyOff
PDF_ENUM_NAME_App = _mupdf.PDF_ENUM_NAME_App
PDF_ENUM_NAME_Approved = _mupdf.PDF_ENUM_NAME_Approved
PDF_ENUM_NAME_ArtBox = _mupdf.PDF_ENUM_NAME_ArtBox
PDF_ENUM_NAME_AsIs = _mupdf.PDF_ENUM_NAME_AsIs
PDF_ENUM_NAME_Ascent = _mupdf.PDF_ENUM_NAME_Ascent
PDF_ENUM_NAME_AuthEvent = _mupdf.PDF_ENUM_NAME_AuthEvent
PDF_ENUM_NAME_Author = _mupdf.PDF_ENUM_NAME_Author
PDF_ENUM_NAME_B = _mupdf.PDF_ENUM_NAME_B
PDF_ENUM_NAME_BBox = _mupdf.PDF_ENUM_NAME_BBox
PDF_ENUM_NAME_BC = _mupdf.PDF_ENUM_NAME_BC
PDF_ENUM_NAME_BE = _mupdf.PDF_ENUM_NAME_BE
PDF_ENUM_NAME_BG = _mupdf.PDF_ENUM_NAME_BG
PDF_ENUM_NAME_BM = _mupdf.PDF_ENUM_NAME_BM
PDF_ENUM_NAME_BPC = _mupdf.PDF_ENUM_NAME_BPC
PDF_ENUM_NAME_BS = _mupdf.PDF_ENUM_NAME_BS
PDF_ENUM_NAME_Background = _mupdf.PDF_ENUM_NAME_Background
PDF_ENUM_NAME_BaseEncoding = _mupdf.PDF_ENUM_NAME_BaseEncoding
PDF_ENUM_NAME_BaseFont = _mupdf.PDF_ENUM_NAME_BaseFont
PDF_ENUM_NAME_BaseState = _mupdf.PDF_ENUM_NAME_BaseState
PDF_ENUM_NAME_BitsPerComponent = _mupdf.PDF_ENUM_NAME_BitsPerComponent
PDF_ENUM_NAME_BitsPerCoordinate = _mupdf.PDF_ENUM_NAME_BitsPerCoordinate
PDF_ENUM_NAME_BitsPerFlag = _mupdf.PDF_ENUM_NAME_BitsPerFlag
PDF_ENUM_NAME_BitsPerSample = _mupdf.PDF_ENUM_NAME_BitsPerSample
PDF_ENUM_NAME_BlackIs1 = _mupdf.PDF_ENUM_NAME_BlackIs1
PDF_ENUM_NAME_BlackPoint = _mupdf.PDF_ENUM_NAME_BlackPoint
PDF_ENUM_NAME_BleedBox = _mupdf.PDF_ENUM_NAME_BleedBox
PDF_ENUM_NAME_Blinds = _mupdf.PDF_ENUM_NAME_Blinds
PDF_ENUM_NAME_Border = _mupdf.PDF_ENUM_NAME_Border
PDF_ENUM_NAME_Bounds = _mupdf.PDF_ENUM_NAME_Bounds
PDF_ENUM_NAME_Box = _mupdf.PDF_ENUM_NAME_Box
PDF_ENUM_NAME_Bt = _mupdf.PDF_ENUM_NAME_Bt
PDF_ENUM_NAME_Btn = _mupdf.PDF_ENUM_NAME_Btn
PDF_ENUM_NAME_Butt = _mupdf.PDF_ENUM_NAME_Butt
PDF_ENUM_NAME_ByteRange = _mupdf.PDF_ENUM_NAME_ByteRange
PDF_ENUM_NAME_C = _mupdf.PDF_ENUM_NAME_C
PDF_ENUM_NAME_C0 = _mupdf.PDF_ENUM_NAME_C0
PDF_ENUM_NAME_C1 = _mupdf.PDF_ENUM_NAME_C1
PDF_ENUM_NAME_CA = _mupdf.PDF_ENUM_NAME_CA
PDF_ENUM_NAME_CCF = _mupdf.PDF_ENUM_NAME_CCF
PDF_ENUM_NAME_CCITTFaxDecode = _mupdf.PDF_ENUM_NAME_CCITTFaxDecode
PDF_ENUM_NAME_CF = _mupdf.PDF_ENUM_NAME_CF
PDF_ENUM_NAME_CFM = _mupdf.PDF_ENUM_NAME_CFM
PDF_ENUM_NAME_CI = _mupdf.PDF_ENUM_NAME_CI
PDF_ENUM_NAME_CIDFontType0 = _mupdf.PDF_ENUM_NAME_CIDFontType0
PDF_ENUM_NAME_CIDFontType0C = _mupdf.PDF_ENUM_NAME_CIDFontType0C
PDF_ENUM_NAME_CIDFontType2 = _mupdf.PDF_ENUM_NAME_CIDFontType2
PDF_ENUM_NAME_CIDSystemInfo = _mupdf.PDF_ENUM_NAME_CIDSystemInfo
PDF_ENUM_NAME_CIDToGIDMap = _mupdf.PDF_ENUM_NAME_CIDToGIDMap
PDF_ENUM_NAME_CMYK = _mupdf.PDF_ENUM_NAME_CMYK
PDF_ENUM_NAME_CS = _mupdf.PDF_ENUM_NAME_CS
PDF_ENUM_NAME_CalCMYK = _mupdf.PDF_ENUM_NAME_CalCMYK
PDF_ENUM_NAME_CalGray = _mupdf.PDF_ENUM_NAME_CalGray
PDF_ENUM_NAME_CalRGB = _mupdf.PDF_ENUM_NAME_CalRGB
PDF_ENUM_NAME_CapHeight = _mupdf.PDF_ENUM_NAME_CapHeight
PDF_ENUM_NAME_Caret = _mupdf.PDF_ENUM_NAME_Caret
PDF_ENUM_NAME_Catalog = _mupdf.PDF_ENUM_NAME_Catalog
PDF_ENUM_NAME_Cert = _mupdf.PDF_ENUM_NAME_Cert
PDF_ENUM_NAME_Ch = _mupdf.PDF_ENUM_NAME_Ch
PDF_ENUM_NAME_Changes = _mupdf.PDF_ENUM_NAME_Changes
PDF_ENUM_NAME_CharProcs = _mupdf.PDF_ENUM_NAME_CharProcs
PDF_ENUM_NAME_Circle = _mupdf.PDF_ENUM_NAME_Circle
PDF_ENUM_NAME_ClosedArrow = _mupdf.PDF_ENUM_NAME_ClosedArrow
PDF_ENUM_NAME_Collection = _mupdf.PDF_ENUM_NAME_Collection
PDF_ENUM_NAME_ColorSpace = _mupdf.PDF_ENUM_NAME_ColorSpace
PDF_ENUM_NAME_ColorTransform = _mupdf.PDF_ENUM_NAME_ColorTransform
PDF_ENUM_NAME_Colorants = _mupdf.PDF_ENUM_NAME_Colorants
PDF_ENUM_NAME_Colors = _mupdf.PDF_ENUM_NAME_Colors
PDF_ENUM_NAME_Columns = _mupdf.PDF_ENUM_NAME_Columns
PDF_ENUM_NAME_Confidential = _mupdf.PDF_ENUM_NAME_Confidential
PDF_ENUM_NAME_Configs = _mupdf.PDF_ENUM_NAME_Configs
PDF_ENUM_NAME_ContactInfo = _mupdf.PDF_ENUM_NAME_ContactInfo
PDF_ENUM_NAME_Contents = _mupdf.PDF_ENUM_NAME_Contents
PDF_ENUM_NAME_Coords = _mupdf.PDF_ENUM_NAME_Coords
PDF_ENUM_NAME_Count = _mupdf.PDF_ENUM_NAME_Count
PDF_ENUM_NAME_Cover = _mupdf.PDF_ENUM_NAME_Cover
PDF_ENUM_NAME_CreationDate = _mupdf.PDF_ENUM_NAME_CreationDate
PDF_ENUM_NAME_Creator = _mupdf.PDF_ENUM_NAME_Creator
PDF_ENUM_NAME_CropBox = _mupdf.PDF_ENUM_NAME_CropBox
PDF_ENUM_NAME_Crypt = _mupdf.PDF_ENUM_NAME_Crypt
PDF_ENUM_NAME_D = _mupdf.PDF_ENUM_NAME_D
PDF_ENUM_NAME_DA = _mupdf.PDF_ENUM_NAME_DA
PDF_ENUM_NAME_DC = _mupdf.PDF_ENUM_NAME_DC
PDF_ENUM_NAME_DCT = _mupdf.PDF_ENUM_NAME_DCT
PDF_ENUM_NAME_DCTDecode = _mupdf.PDF_ENUM_NAME_DCTDecode
PDF_ENUM_NAME_DL = _mupdf.PDF_ENUM_NAME_DL
PDF_ENUM_NAME_DOS = _mupdf.PDF_ENUM_NAME_DOS
PDF_ENUM_NAME_DP = _mupdf.PDF_ENUM_NAME_DP
PDF_ENUM_NAME_DR = _mupdf.PDF_ENUM_NAME_DR
PDF_ENUM_NAME_DS = _mupdf.PDF_ENUM_NAME_DS
PDF_ENUM_NAME_DV = _mupdf.PDF_ENUM_NAME_DV
PDF_ENUM_NAME_DW = _mupdf.PDF_ENUM_NAME_DW
PDF_ENUM_NAME_DW2 = _mupdf.PDF_ENUM_NAME_DW2
PDF_ENUM_NAME_DamagedRowsBeforeError = _mupdf.PDF_ENUM_NAME_DamagedRowsBeforeError
PDF_ENUM_NAME_Data = _mupdf.PDF_ENUM_NAME_Data
PDF_ENUM_NAME_Date = _mupdf.PDF_ENUM_NAME_Date
PDF_ENUM_NAME_Decode = _mupdf.PDF_ENUM_NAME_Decode
PDF_ENUM_NAME_DecodeParms = _mupdf.PDF_ENUM_NAME_DecodeParms
PDF_ENUM_NAME_Default = _mupdf.PDF_ENUM_NAME_Default
PDF_ENUM_NAME_DefaultCMYK = _mupdf.PDF_ENUM_NAME_DefaultCMYK
PDF_ENUM_NAME_DefaultGray = _mupdf.PDF_ENUM_NAME_DefaultGray
PDF_ENUM_NAME_DefaultRGB = _mupdf.PDF_ENUM_NAME_DefaultRGB
PDF_ENUM_NAME_Departmental = _mupdf.PDF_ENUM_NAME_Departmental
PDF_ENUM_NAME_Desc = _mupdf.PDF_ENUM_NAME_Desc
PDF_ENUM_NAME_DescendantFonts = _mupdf.PDF_ENUM_NAME_DescendantFonts
PDF_ENUM_NAME_Descent = _mupdf.PDF_ENUM_NAME_Descent
PDF_ENUM_NAME_Design = _mupdf.PDF_ENUM_NAME_Design
PDF_ENUM_NAME_Dest = _mupdf.PDF_ENUM_NAME_Dest
PDF_ENUM_NAME_DestOutputProfile = _mupdf.PDF_ENUM_NAME_DestOutputProfile
PDF_ENUM_NAME_Dests = _mupdf.PDF_ENUM_NAME_Dests
PDF_ENUM_NAME_DeviceCMYK = _mupdf.PDF_ENUM_NAME_DeviceCMYK
PDF_ENUM_NAME_DeviceGray = _mupdf.PDF_ENUM_NAME_DeviceGray
PDF_ENUM_NAME_DeviceN = _mupdf.PDF_ENUM_NAME_DeviceN
PDF_ENUM_NAME_DeviceRGB = _mupdf.PDF_ENUM_NAME_DeviceRGB
PDF_ENUM_NAME_Di = _mupdf.PDF_ENUM_NAME_Di
PDF_ENUM_NAME_Diamond = _mupdf.PDF_ENUM_NAME_Diamond
PDF_ENUM_NAME_Differences = _mupdf.PDF_ENUM_NAME_Differences
PDF_ENUM_NAME_DigestLocation = _mupdf.PDF_ENUM_NAME_DigestLocation
PDF_ENUM_NAME_DigestMethod = _mupdf.PDF_ENUM_NAME_DigestMethod
PDF_ENUM_NAME_DigestValue = _mupdf.PDF_ENUM_NAME_DigestValue
PDF_ENUM_NAME_Dissolve = _mupdf.PDF_ENUM_NAME_Dissolve
PDF_ENUM_NAME_Dm = _mupdf.PDF_ENUM_NAME_Dm
PDF_ENUM_NAME_DocMDP = _mupdf.PDF_ENUM_NAME_DocMDP
PDF_ENUM_NAME_Document = _mupdf.PDF_ENUM_NAME_Document
PDF_ENUM_NAME_Domain = _mupdf.PDF_ENUM_NAME_Domain
PDF_ENUM_NAME_Draft = _mupdf.PDF_ENUM_NAME_Draft
PDF_ENUM_NAME_Dur = _mupdf.PDF_ENUM_NAME_Dur
PDF_ENUM_NAME_E = _mupdf.PDF_ENUM_NAME_E
PDF_ENUM_NAME_EF = _mupdf.PDF_ENUM_NAME_EF
PDF_ENUM_NAME_EarlyChange = _mupdf.PDF_ENUM_NAME_EarlyChange
PDF_ENUM_NAME_EmbeddedFile = _mupdf.PDF_ENUM_NAME_EmbeddedFile
PDF_ENUM_NAME_EmbeddedFiles = _mupdf.PDF_ENUM_NAME_EmbeddedFiles
PDF_ENUM_NAME_Encode = _mupdf.PDF_ENUM_NAME_Encode
PDF_ENUM_NAME_EncodedByteAlign = _mupdf.PDF_ENUM_NAME_EncodedByteAlign
PDF_ENUM_NAME_Encoding = _mupdf.PDF_ENUM_NAME_Encoding
PDF_ENUM_NAME_Encrypt = _mupdf.PDF_ENUM_NAME_Encrypt
PDF_ENUM_NAME_EncryptMetadata = _mupdf.PDF_ENUM_NAME_EncryptMetadata
PDF_ENUM_NAME_EndOfBlock = _mupdf.PDF_ENUM_NAME_EndOfBlock
PDF_ENUM_NAME_EndOfLine = _mupdf.PDF_ENUM_NAME_EndOfLine
PDF_ENUM_NAME_Exclude = _mupdf.PDF_ENUM_NAME_Exclude
PDF_ENUM_NAME_Experimental = _mupdf.PDF_ENUM_NAME_Experimental
PDF_ENUM_NAME_Expired = _mupdf.PDF_ENUM_NAME_Expired
PDF_ENUM_NAME_ExtGState = _mupdf.PDF_ENUM_NAME_ExtGState
PDF_ENUM_NAME_Extend = _mupdf.PDF_ENUM_NAME_Extend
PDF_ENUM_NAME_F = _mupdf.PDF_ENUM_NAME_F
PDF_ENUM_NAME_FL = _mupdf.PDF_ENUM_NAME_FL
PDF_ENUM_NAME_FRM = _mupdf.PDF_ENUM_NAME_FRM
PDF_ENUM_NAME_FS = _mupdf.PDF_ENUM_NAME_FS
PDF_ENUM_NAME_FT = _mupdf.PDF_ENUM_NAME_FT
PDF_ENUM_NAME_Fade = _mupdf.PDF_ENUM_NAME_Fade
PDF_ENUM_NAME_Ff = _mupdf.PDF_ENUM_NAME_Ff
PDF_ENUM_NAME_FieldMDP = _mupdf.PDF_ENUM_NAME_FieldMDP
PDF_ENUM_NAME_Fields = _mupdf.PDF_ENUM_NAME_Fields
PDF_ENUM_NAME_FileAttachment = _mupdf.PDF_ENUM_NAME_FileAttachment
PDF_ENUM_NAME_FileSize = _mupdf.PDF_ENUM_NAME_FileSize
PDF_ENUM_NAME_Filespec = _mupdf.PDF_ENUM_NAME_Filespec
PDF_ENUM_NAME_Filter = _mupdf.PDF_ENUM_NAME_Filter
PDF_ENUM_NAME_Final = _mupdf.PDF_ENUM_NAME_Final
PDF_ENUM_NAME_Fingerprint = _mupdf.PDF_ENUM_NAME_Fingerprint
PDF_ENUM_NAME_First = _mupdf.PDF_ENUM_NAME_First
PDF_ENUM_NAME_FirstChar = _mupdf.PDF_ENUM_NAME_FirstChar
PDF_ENUM_NAME_FirstPage = _mupdf.PDF_ENUM_NAME_FirstPage
PDF_ENUM_NAME_Fit = _mupdf.PDF_ENUM_NAME_Fit
PDF_ENUM_NAME_FitB = _mupdf.PDF_ENUM_NAME_FitB
PDF_ENUM_NAME_FitBH = _mupdf.PDF_ENUM_NAME_FitBH
PDF_ENUM_NAME_FitBV = _mupdf.PDF_ENUM_NAME_FitBV
PDF_ENUM_NAME_FitH = _mupdf.PDF_ENUM_NAME_FitH
PDF_ENUM_NAME_FitR = _mupdf.PDF_ENUM_NAME_FitR
PDF_ENUM_NAME_FitV = _mupdf.PDF_ENUM_NAME_FitV
PDF_ENUM_NAME_Fl = _mupdf.PDF_ENUM_NAME_Fl
PDF_ENUM_NAME_Flags = _mupdf.PDF_ENUM_NAME_Flags
PDF_ENUM_NAME_FlateDecode = _mupdf.PDF_ENUM_NAME_FlateDecode
PDF_ENUM_NAME_Fly = _mupdf.PDF_ENUM_NAME_Fly
PDF_ENUM_NAME_Font = _mupdf.PDF_ENUM_NAME_Font
PDF_ENUM_NAME_FontBBox = _mupdf.PDF_ENUM_NAME_FontBBox
PDF_ENUM_NAME_FontDescriptor = _mupdf.PDF_ENUM_NAME_FontDescriptor
PDF_ENUM_NAME_FontFile = _mupdf.PDF_ENUM_NAME_FontFile
PDF_ENUM_NAME_FontFile2 = _mupdf.PDF_ENUM_NAME_FontFile2
PDF_ENUM_NAME_FontFile3 = _mupdf.PDF_ENUM_NAME_FontFile3
PDF_ENUM_NAME_FontMatrix = _mupdf.PDF_ENUM_NAME_FontMatrix
PDF_ENUM_NAME_FontName = _mupdf.PDF_ENUM_NAME_FontName
PDF_ENUM_NAME_ForComment = _mupdf.PDF_ENUM_NAME_ForComment
PDF_ENUM_NAME_ForPublicRelease = _mupdf.PDF_ENUM_NAME_ForPublicRelease
PDF_ENUM_NAME_Form = _mupdf.PDF_ENUM_NAME_Form
PDF_ENUM_NAME_FormEx = _mupdf.PDF_ENUM_NAME_FormEx
PDF_ENUM_NAME_FormType = _mupdf.PDF_ENUM_NAME_FormType
PDF_ENUM_NAME_FreeText = _mupdf.PDF_ENUM_NAME_FreeText
PDF_ENUM_NAME_Function = _mupdf.PDF_ENUM_NAME_Function
PDF_ENUM_NAME_FunctionType = _mupdf.PDF_ENUM_NAME_FunctionType
PDF_ENUM_NAME_Functions = _mupdf.PDF_ENUM_NAME_Functions
PDF_ENUM_NAME_G = _mupdf.PDF_ENUM_NAME_G
PDF_ENUM_NAME_Gamma = _mupdf.PDF_ENUM_NAME_Gamma
PDF_ENUM_NAME_Glitter = _mupdf.PDF_ENUM_NAME_Glitter
PDF_ENUM_NAME_GoTo = _mupdf.PDF_ENUM_NAME_GoTo
PDF_ENUM_NAME_GoToR = _mupdf.PDF_ENUM_NAME_GoToR
PDF_ENUM_NAME_Group = _mupdf.PDF_ENUM_NAME_Group
PDF_ENUM_NAME_H = _mupdf.PDF_ENUM_NAME_H
PDF_ENUM_NAME_Height = _mupdf.PDF_ENUM_NAME_Height
PDF_ENUM_NAME_Helv = _mupdf.PDF_ENUM_NAME_Helv
PDF_ENUM_NAME_Highlight = _mupdf.PDF_ENUM_NAME_Highlight
PDF_ENUM_NAME_HistoryPos = _mupdf.PDF_ENUM_NAME_HistoryPos
PDF_ENUM_NAME_I = _mupdf.PDF_ENUM_NAME_I
PDF_ENUM_NAME_IC = _mupdf.PDF_ENUM_NAME_IC
PDF_ENUM_NAME_ICCBased = _mupdf.PDF_ENUM_NAME_ICCBased
PDF_ENUM_NAME_ID = _mupdf.PDF_ENUM_NAME_ID
PDF_ENUM_NAME_IM = _mupdf.PDF_ENUM_NAME_IM
PDF_ENUM_NAME_IRT = _mupdf.PDF_ENUM_NAME_IRT
PDF_ENUM_NAME_Identity = _mupdf.PDF_ENUM_NAME_Identity
PDF_ENUM_NAME_Identity_H = _mupdf.PDF_ENUM_NAME_Identity_H
PDF_ENUM_NAME_Identity_V = _mupdf.PDF_ENUM_NAME_Identity_V
PDF_ENUM_NAME_Image = _mupdf.PDF_ENUM_NAME_Image
PDF_ENUM_NAME_ImageMask = _mupdf.PDF_ENUM_NAME_ImageMask
PDF_ENUM_NAME_Include = _mupdf.PDF_ENUM_NAME_Include
PDF_ENUM_NAME_Index = _mupdf.PDF_ENUM_NAME_Index
PDF_ENUM_NAME_Indexed = _mupdf.PDF_ENUM_NAME_Indexed
PDF_ENUM_NAME_Info = _mupdf.PDF_ENUM_NAME_Info
PDF_ENUM_NAME_Ink = _mupdf.PDF_ENUM_NAME_Ink
PDF_ENUM_NAME_InkList = _mupdf.PDF_ENUM_NAME_InkList
PDF_ENUM_NAME_Intent = _mupdf.PDF_ENUM_NAME_Intent
PDF_ENUM_NAME_Interpolate = _mupdf.PDF_ENUM_NAME_Interpolate
PDF_ENUM_NAME_IsMap = _mupdf.PDF_ENUM_NAME_IsMap
PDF_ENUM_NAME_ItalicAngle = _mupdf.PDF_ENUM_NAME_ItalicAngle
PDF_ENUM_NAME_JBIG2Decode = _mupdf.PDF_ENUM_NAME_JBIG2Decode
PDF_ENUM_NAME_JBIG2Globals = _mupdf.PDF_ENUM_NAME_JBIG2Globals
PDF_ENUM_NAME_JPXDecode = _mupdf.PDF_ENUM_NAME_JPXDecode
PDF_ENUM_NAME_JS = _mupdf.PDF_ENUM_NAME_JS
PDF_ENUM_NAME_JavaScript = _mupdf.PDF_ENUM_NAME_JavaScript
PDF_ENUM_NAME_K = _mupdf.PDF_ENUM_NAME_K
PDF_ENUM_NAME_Keywords = _mupdf.PDF_ENUM_NAME_Keywords
PDF_ENUM_NAME_Kids = _mupdf.PDF_ENUM_NAME_Kids
PDF_ENUM_NAME_L = _mupdf.PDF_ENUM_NAME_L
PDF_ENUM_NAME_LC = _mupdf.PDF_ENUM_NAME_LC
PDF_ENUM_NAME_LE = _mupdf.PDF_ENUM_NAME_LE
PDF_ENUM_NAME_LJ = _mupdf.PDF_ENUM_NAME_LJ
PDF_ENUM_NAME_LW = _mupdf.PDF_ENUM_NAME_LW
PDF_ENUM_NAME_LZ = _mupdf.PDF_ENUM_NAME_LZ
PDF_ENUM_NAME_LZW = _mupdf.PDF_ENUM_NAME_LZW
PDF_ENUM_NAME_LZWDecode = _mupdf.PDF_ENUM_NAME_LZWDecode
PDF_ENUM_NAME_Lab = _mupdf.PDF_ENUM_NAME_Lab
PDF_ENUM_NAME_Lang = _mupdf.PDF_ENUM_NAME_Lang
PDF_ENUM_NAME_Last = _mupdf.PDF_ENUM_NAME_Last
PDF_ENUM_NAME_LastChar = _mupdf.PDF_ENUM_NAME_LastChar
PDF_ENUM_NAME_LastPage = _mupdf.PDF_ENUM_NAME_LastPage
PDF_ENUM_NAME_Launch = _mupdf.PDF_ENUM_NAME_Launch
PDF_ENUM_NAME_Length = _mupdf.PDF_ENUM_NAME_Length
PDF_ENUM_NAME_Length1 = _mupdf.PDF_ENUM_NAME_Length1
PDF_ENUM_NAME_Length2 = _mupdf.PDF_ENUM_NAME_Length2
PDF_ENUM_NAME_Length3 = _mupdf.PDF_ENUM_NAME_Length3
PDF_ENUM_NAME_Limits = _mupdf.PDF_ENUM_NAME_Limits
PDF_ENUM_NAME_Line = _mupdf.PDF_ENUM_NAME_Line
PDF_ENUM_NAME_Linearized = _mupdf.PDF_ENUM_NAME_Linearized
PDF_ENUM_NAME_Link = _mupdf.PDF_ENUM_NAME_Link
PDF_ENUM_NAME_Location = _mupdf.PDF_ENUM_NAME_Location
PDF_ENUM_NAME_Lock = _mupdf.PDF_ENUM_NAME_Lock
PDF_ENUM_NAME_Locked = _mupdf.PDF_ENUM_NAME_Locked
PDF_ENUM_NAME_Luminosity = _mupdf.PDF_ENUM_NAME_Luminosity
PDF_ENUM_NAME_M = _mupdf.PDF_ENUM_NAME_M
PDF_ENUM_NAME_MCID = _mupdf.PDF_ENUM_NAME_MCID
PDF_ENUM_NAME_MK = _mupdf.PDF_ENUM_NAME_MK
PDF_ENUM_NAME_ML = _mupdf.PDF_ENUM_NAME_ML
PDF_ENUM_NAME_MMType1 = _mupdf.PDF_ENUM_NAME_MMType1
PDF_ENUM_NAME_Mac = _mupdf.PDF_ENUM_NAME_Mac
PDF_ENUM_NAME_Mask = _mupdf.PDF_ENUM_NAME_Mask
PDF_ENUM_NAME_Matrix = _mupdf.PDF_ENUM_NAME_Matrix
PDF_ENUM_NAME_Matte = _mupdf.PDF_ENUM_NAME_Matte
PDF_ENUM_NAME_MaxLen = _mupdf.PDF_ENUM_NAME_MaxLen
PDF_ENUM_NAME_MediaBox = _mupdf.PDF_ENUM_NAME_MediaBox
PDF_ENUM_NAME_Metadata = _mupdf.PDF_ENUM_NAME_Metadata
PDF_ENUM_NAME_MissingWidth = _mupdf.PDF_ENUM_NAME_MissingWidth
PDF_ENUM_NAME_ModDate = _mupdf.PDF_ENUM_NAME_ModDate
PDF_ENUM_NAME_Movie = _mupdf.PDF_ENUM_NAME_Movie
PDF_ENUM_NAME_Msg = _mupdf.PDF_ENUM_NAME_Msg
PDF_ENUM_NAME_Multiply = _mupdf.PDF_ENUM_NAME_Multiply
PDF_ENUM_NAME_N = _mupdf.PDF_ENUM_NAME_N
PDF_ENUM_NAME_Name = _mupdf.PDF_ENUM_NAME_Name
PDF_ENUM_NAME_Named = _mupdf.PDF_ENUM_NAME_Named
PDF_ENUM_NAME_Names = _mupdf.PDF_ENUM_NAME_Names
PDF_ENUM_NAME_NewWindow = _mupdf.PDF_ENUM_NAME_NewWindow
PDF_ENUM_NAME_Next = _mupdf.PDF_ENUM_NAME_Next
PDF_ENUM_NAME_NextPage = _mupdf.PDF_ENUM_NAME_NextPage
PDF_ENUM_NAME_NonEFontNoWarn = _mupdf.PDF_ENUM_NAME_NonEFontNoWarn
PDF_ENUM_NAME_None = _mupdf.PDF_ENUM_NAME_None
PDF_ENUM_NAME_Normal = _mupdf.PDF_ENUM_NAME_Normal
PDF_ENUM_NAME_NotApproved = _mupdf.PDF_ENUM_NAME_NotApproved
PDF_ENUM_NAME_NotForPublicRelease = _mupdf.PDF_ENUM_NAME_NotForPublicRelease
PDF_ENUM_NAME_NumSections = _mupdf.PDF_ENUM_NAME_NumSections
PDF_ENUM_NAME_Nums = _mupdf.PDF_ENUM_NAME_Nums
PDF_ENUM_NAME_O = _mupdf.PDF_ENUM_NAME_O
PDF_ENUM_NAME_OC = _mupdf.PDF_ENUM_NAME_OC
PDF_ENUM_NAME_OCG = _mupdf.PDF_ENUM_NAME_OCG
PDF_ENUM_NAME_OCGs = _mupdf.PDF_ENUM_NAME_OCGs
PDF_ENUM_NAME_OCMD = _mupdf.PDF_ENUM_NAME_OCMD
PDF_ENUM_NAME_OCProperties = _mupdf.PDF_ENUM_NAME_OCProperties
PDF_ENUM_NAME_OE = _mupdf.PDF_ENUM_NAME_OE
PDF_ENUM_NAME_OFF = _mupdf.PDF_ENUM_NAME_OFF
PDF_ENUM_NAME_ON = _mupdf.PDF_ENUM_NAME_ON
PDF_ENUM_NAME_OP = _mupdf.PDF_ENUM_NAME_OP
PDF_ENUM_NAME_OPM = _mupdf.PDF_ENUM_NAME_OPM
PDF_ENUM_NAME_OS = _mupdf.PDF_ENUM_NAME_OS
PDF_ENUM_NAME_ObjStm = _mupdf.PDF_ENUM_NAME_ObjStm
PDF_ENUM_NAME_Of = _mupdf.PDF_ENUM_NAME_Of
PDF_ENUM_NAME_Off = _mupdf.PDF_ENUM_NAME_Off
PDF_ENUM_NAME_Open = _mupdf.PDF_ENUM_NAME_Open
PDF_ENUM_NAME_OpenArrow = _mupdf.PDF_ENUM_NAME_OpenArrow
PDF_ENUM_NAME_OpenType = _mupdf.PDF_ENUM_NAME_OpenType
PDF_ENUM_NAME_Opt = _mupdf.PDF_ENUM_NAME_Opt
PDF_ENUM_NAME_Order = _mupdf.PDF_ENUM_NAME_Order
PDF_ENUM_NAME_Ordering = _mupdf.PDF_ENUM_NAME_Ordering
PDF_ENUM_NAME_Outlines = _mupdf.PDF_ENUM_NAME_Outlines
PDF_ENUM_NAME_OutputIntents = _mupdf.PDF_ENUM_NAME_OutputIntents
PDF_ENUM_NAME_P = _mupdf.PDF_ENUM_NAME_P
PDF_ENUM_NAME_PDF = _mupdf.PDF_ENUM_NAME_PDF
PDF_ENUM_NAME_PS = _mupdf.PDF_ENUM_NAME_PS
PDF_ENUM_NAME_Page = _mupdf.PDF_ENUM_NAME_Page
PDF_ENUM_NAME_PageMode = _mupdf.PDF_ENUM_NAME_PageMode
PDF_ENUM_NAME_Pages = _mupdf.PDF_ENUM_NAME_Pages
PDF_ENUM_NAME_PaintType = _mupdf.PDF_ENUM_NAME_PaintType
PDF_ENUM_NAME_Params = _mupdf.PDF_ENUM_NAME_Params
PDF_ENUM_NAME_Parent = _mupdf.PDF_ENUM_NAME_Parent
PDF_ENUM_NAME_Pattern = _mupdf.PDF_ENUM_NAME_Pattern
PDF_ENUM_NAME_PatternType = _mupdf.PDF_ENUM_NAME_PatternType
PDF_ENUM_NAME_Perms = _mupdf.PDF_ENUM_NAME_Perms
PDF_ENUM_NAME_PolyLine = _mupdf.PDF_ENUM_NAME_PolyLine
PDF_ENUM_NAME_Polygon = _mupdf.PDF_ENUM_NAME_Polygon
PDF_ENUM_NAME_Popup = _mupdf.PDF_ENUM_NAME_Popup
PDF_ENUM_NAME_PreRelease = _mupdf.PDF_ENUM_NAME_PreRelease
PDF_ENUM_NAME_Predictor = _mupdf.PDF_ENUM_NAME_Predictor
PDF_ENUM_NAME_Prev = _mupdf.PDF_ENUM_NAME_Prev
PDF_ENUM_NAME_PrevPage = _mupdf.PDF_ENUM_NAME_PrevPage
PDF_ENUM_NAME_Preview = _mupdf.PDF_ENUM_NAME_Preview
PDF_ENUM_NAME_Print = _mupdf.PDF_ENUM_NAME_Print
PDF_ENUM_NAME_PrinterMark = _mupdf.PDF_ENUM_NAME_PrinterMark
PDF_ENUM_NAME_ProcSet = _mupdf.PDF_ENUM_NAME_ProcSet
PDF_ENUM_NAME_Producer = _mupdf.PDF_ENUM_NAME_Producer
PDF_ENUM_NAME_Properties = _mupdf.PDF_ENUM_NAME_Properties
PDF_ENUM_NAME_Prop_AuthTime = _mupdf.PDF_ENUM_NAME_Prop_AuthTime
PDF_ENUM_NAME_Prop_AuthType = _mupdf.PDF_ENUM_NAME_Prop_AuthType
PDF_ENUM_NAME_Prop_Build = _mupdf.PDF_ENUM_NAME_Prop_Build
PDF_ENUM_NAME_PubSec = _mupdf.PDF_ENUM_NAME_PubSec
PDF_ENUM_NAME_Push = _mupdf.PDF_ENUM_NAME_Push
PDF_ENUM_NAME_Q = _mupdf.PDF_ENUM_NAME_Q
PDF_ENUM_NAME_QuadPoints = _mupdf.PDF_ENUM_NAME_QuadPoints
PDF_ENUM_NAME_R = _mupdf.PDF_ENUM_NAME_R
PDF_ENUM_NAME_RBGroups = _mupdf.PDF_ENUM_NAME_RBGroups
PDF_ENUM_NAME_RC = _mupdf.PDF_ENUM_NAME_RC
PDF_ENUM_NAME_RClosedArrow = _mupdf.PDF_ENUM_NAME_RClosedArrow
PDF_ENUM_NAME_REx = _mupdf.PDF_ENUM_NAME_REx
PDF_ENUM_NAME_RGB = _mupdf.PDF_ENUM_NAME_RGB
PDF_ENUM_NAME_RI = _mupdf.PDF_ENUM_NAME_RI
PDF_ENUM_NAME_RL = _mupdf.PDF_ENUM_NAME_RL
PDF_ENUM_NAME_ROpenArrow = _mupdf.PDF_ENUM_NAME_ROpenArrow
PDF_ENUM_NAME_Range = _mupdf.PDF_ENUM_NAME_Range
PDF_ENUM_NAME_Reason = _mupdf.PDF_ENUM_NAME_Reason
PDF_ENUM_NAME_Rect = _mupdf.PDF_ENUM_NAME_Rect
PDF_ENUM_NAME_Redact = _mupdf.PDF_ENUM_NAME_Redact
PDF_ENUM_NAME_Ref = _mupdf.PDF_ENUM_NAME_Ref
PDF_ENUM_NAME_Reference = _mupdf.PDF_ENUM_NAME_Reference
PDF_ENUM_NAME_Registry = _mupdf.PDF_ENUM_NAME_Registry
PDF_ENUM_NAME_ResetForm = _mupdf.PDF_ENUM_NAME_ResetForm
PDF_ENUM_NAME_Resources = _mupdf.PDF_ENUM_NAME_Resources
PDF_ENUM_NAME_Root = _mupdf.PDF_ENUM_NAME_Root
PDF_ENUM_NAME_Rotate = _mupdf.PDF_ENUM_NAME_Rotate
PDF_ENUM_NAME_Rows = _mupdf.PDF_ENUM_NAME_Rows
PDF_ENUM_NAME_RunLengthDecode = _mupdf.PDF_ENUM_NAME_RunLengthDecode
PDF_ENUM_NAME_S = _mupdf.PDF_ENUM_NAME_S
PDF_ENUM_NAME_SMask = _mupdf.PDF_ENUM_NAME_SMask
PDF_ENUM_NAME_SMaskInData = _mupdf.PDF_ENUM_NAME_SMaskInData
PDF_ENUM_NAME_Schema = _mupdf.PDF_ENUM_NAME_Schema
PDF_ENUM_NAME_Screen = _mupdf.PDF_ENUM_NAME_Screen
PDF_ENUM_NAME_Separation = _mupdf.PDF_ENUM_NAME_Separation
PDF_ENUM_NAME_Shading = _mupdf.PDF_ENUM_NAME_Shading
PDF_ENUM_NAME_ShadingType = _mupdf.PDF_ENUM_NAME_ShadingType
PDF_ENUM_NAME_Si = _mupdf.PDF_ENUM_NAME_Si
PDF_ENUM_NAME_Sig = _mupdf.PDF_ENUM_NAME_Sig
PDF_ENUM_NAME_SigFlags = _mupdf.PDF_ENUM_NAME_SigFlags
PDF_ENUM_NAME_SigQ = _mupdf.PDF_ENUM_NAME_SigQ
PDF_ENUM_NAME_SigRef = _mupdf.PDF_ENUM_NAME_SigRef
PDF_ENUM_NAME_Size = _mupdf.PDF_ENUM_NAME_Size
PDF_ENUM_NAME_Slash = _mupdf.PDF_ENUM_NAME_Slash
PDF_ENUM_NAME_Sold = _mupdf.PDF_ENUM_NAME_Sold
PDF_ENUM_NAME_Sound = _mupdf.PDF_ENUM_NAME_Sound
PDF_ENUM_NAME_Split = _mupdf.PDF_ENUM_NAME_Split
PDF_ENUM_NAME_Square = _mupdf.PDF_ENUM_NAME_Square
PDF_ENUM_NAME_Squiggly = _mupdf.PDF_ENUM_NAME_Squiggly
PDF_ENUM_NAME_Stamp = _mupdf.PDF_ENUM_NAME_Stamp
PDF_ENUM_NAME_Standard = _mupdf.PDF_ENUM_NAME_Standard
PDF_ENUM_NAME_StdCF = _mupdf.PDF_ENUM_NAME_StdCF
PDF_ENUM_NAME_StemV = _mupdf.PDF_ENUM_NAME_StemV
PDF_ENUM_NAME_StmF = _mupdf.PDF_ENUM_NAME_StmF
PDF_ENUM_NAME_StrF = _mupdf.PDF_ENUM_NAME_StrF
PDF_ENUM_NAME_StrikeOut = _mupdf.PDF_ENUM_NAME_StrikeOut
PDF_ENUM_NAME_StructParent = _mupdf.PDF_ENUM_NAME_StructParent
PDF_ENUM_NAME_StructParents = _mupdf.PDF_ENUM_NAME_StructParents
PDF_ENUM_NAME_SubFilter = _mupdf.PDF_ENUM_NAME_SubFilter
PDF_ENUM_NAME_Subject = _mupdf.PDF_ENUM_NAME_Subject
PDF_ENUM_NAME_Subtype = _mupdf.PDF_ENUM_NAME_Subtype
PDF_ENUM_NAME_Subtype2 = _mupdf.PDF_ENUM_NAME_Subtype2
PDF_ENUM_NAME_Supplement = _mupdf.PDF_ENUM_NAME_Supplement
PDF_ENUM_NAME_Symb = _mupdf.PDF_ENUM_NAME_Symb
PDF_ENUM_NAME_T = _mupdf.PDF_ENUM_NAME_T
PDF_ENUM_NAME_TI = _mupdf.PDF_ENUM_NAME_TI
PDF_ENUM_NAME_TR = _mupdf.PDF_ENUM_NAME_TR
PDF_ENUM_NAME_TR2 = _mupdf.PDF_ENUM_NAME_TR2
PDF_ENUM_NAME_TU = _mupdf.PDF_ENUM_NAME_TU
PDF_ENUM_NAME_Text = _mupdf.PDF_ENUM_NAME_Text
PDF_ENUM_NAME_TilingType = _mupdf.PDF_ENUM_NAME_TilingType
PDF_ENUM_NAME_Times = _mupdf.PDF_ENUM_NAME_Times
PDF_ENUM_NAME_Title = _mupdf.PDF_ENUM_NAME_Title
PDF_ENUM_NAME_ToUnicode = _mupdf.PDF_ENUM_NAME_ToUnicode
PDF_ENUM_NAME_TopSecret = _mupdf.PDF_ENUM_NAME_TopSecret
PDF_ENUM_NAME_Trans = _mupdf.PDF_ENUM_NAME_Trans
PDF_ENUM_NAME_TransformMethod = _mupdf.PDF_ENUM_NAME_TransformMethod
PDF_ENUM_NAME_TransformParams = _mupdf.PDF_ENUM_NAME_TransformParams
PDF_ENUM_NAME_Transparency = _mupdf.PDF_ENUM_NAME_Transparency
PDF_ENUM_NAME_TrapNet = _mupdf.PDF_ENUM_NAME_TrapNet
PDF_ENUM_NAME_TrimBox = _mupdf.PDF_ENUM_NAME_TrimBox
PDF_ENUM_NAME_TrueType = _mupdf.PDF_ENUM_NAME_TrueType
PDF_ENUM_NAME_TrustedMode = _mupdf.PDF_ENUM_NAME_TrustedMode
PDF_ENUM_NAME_Tx = _mupdf.PDF_ENUM_NAME_Tx
PDF_ENUM_NAME_Type = _mupdf.PDF_ENUM_NAME_Type
PDF_ENUM_NAME_Type0 = _mupdf.PDF_ENUM_NAME_Type0
PDF_ENUM_NAME_Type1 = _mupdf.PDF_ENUM_NAME_Type1
PDF_ENUM_NAME_Type1C = _mupdf.PDF_ENUM_NAME_Type1C
PDF_ENUM_NAME_Type3 = _mupdf.PDF_ENUM_NAME_Type3
PDF_ENUM_NAME_U = _mupdf.PDF_ENUM_NAME_U
PDF_ENUM_NAME_UE = _mupdf.PDF_ENUM_NAME_UE
PDF_ENUM_NAME_UF = _mupdf.PDF_ENUM_NAME_UF
PDF_ENUM_NAME_URI = _mupdf.PDF_ENUM_NAME_URI
PDF_ENUM_NAME_URL = _mupdf.PDF_ENUM_NAME_URL
PDF_ENUM_NAME_Unchanged = _mupdf.PDF_ENUM_NAME_Unchanged
PDF_ENUM_NAME_Uncover = _mupdf.PDF_ENUM_NAME_Uncover
PDF_ENUM_NAME_Underline = _mupdf.PDF_ENUM_NAME_Underline
PDF_ENUM_NAME_Unix = _mupdf.PDF_ENUM_NAME_Unix
PDF_ENUM_NAME_Usage = _mupdf.PDF_ENUM_NAME_Usage
PDF_ENUM_NAME_UseBlackPtComp = _mupdf.PDF_ENUM_NAME_UseBlackPtComp
PDF_ENUM_NAME_UseCMap = _mupdf.PDF_ENUM_NAME_UseCMap
PDF_ENUM_NAME_UseOutlines = _mupdf.PDF_ENUM_NAME_UseOutlines
PDF_ENUM_NAME_UserUnit = _mupdf.PDF_ENUM_NAME_UserUnit
PDF_ENUM_NAME_V = _mupdf.PDF_ENUM_NAME_V
PDF_ENUM_NAME_V2 = _mupdf.PDF_ENUM_NAME_V2
PDF_ENUM_NAME_VE = _mupdf.PDF_ENUM_NAME_VE
PDF_ENUM_NAME_Version = _mupdf.PDF_ENUM_NAME_Version
PDF_ENUM_NAME_Vertices = _mupdf.PDF_ENUM_NAME_Vertices
PDF_ENUM_NAME_VerticesPerRow = _mupdf.PDF_ENUM_NAME_VerticesPerRow
PDF_ENUM_NAME_View = _mupdf.PDF_ENUM_NAME_View
PDF_ENUM_NAME_W = _mupdf.PDF_ENUM_NAME_W
PDF_ENUM_NAME_W2 = _mupdf.PDF_ENUM_NAME_W2
PDF_ENUM_NAME_WMode = _mupdf.PDF_ENUM_NAME_WMode
PDF_ENUM_NAME_Watermark = _mupdf.PDF_ENUM_NAME_Watermark
PDF_ENUM_NAME_WhitePoint = _mupdf.PDF_ENUM_NAME_WhitePoint
PDF_ENUM_NAME_Widget = _mupdf.PDF_ENUM_NAME_Widget
PDF_ENUM_NAME_Width = _mupdf.PDF_ENUM_NAME_Width
PDF_ENUM_NAME_Widths = _mupdf.PDF_ENUM_NAME_Widths
PDF_ENUM_NAME_WinAnsiEncoding = _mupdf.PDF_ENUM_NAME_WinAnsiEncoding
PDF_ENUM_NAME_Wipe = _mupdf.PDF_ENUM_NAME_Wipe
PDF_ENUM_NAME_XFA = _mupdf.PDF_ENUM_NAME_XFA
PDF_ENUM_NAME_XHeight = _mupdf.PDF_ENUM_NAME_XHeight
PDF_ENUM_NAME_XML = _mupdf.PDF_ENUM_NAME_XML
PDF_ENUM_NAME_XObject = _mupdf.PDF_ENUM_NAME_XObject
PDF_ENUM_NAME_XRef = _mupdf.PDF_ENUM_NAME_XRef
PDF_ENUM_NAME_XRefStm = _mupdf.PDF_ENUM_NAME_XRefStm
PDF_ENUM_NAME_XStep = _mupdf.PDF_ENUM_NAME_XStep
PDF_ENUM_NAME_XYZ = _mupdf.PDF_ENUM_NAME_XYZ
PDF_ENUM_NAME_YStep = _mupdf.PDF_ENUM_NAME_YStep
PDF_ENUM_NAME_Yes = _mupdf.PDF_ENUM_NAME_Yes
PDF_ENUM_NAME_ZaDb = _mupdf.PDF_ENUM_NAME_ZaDb
PDF_ENUM_NAME_adbe_pkcs7_detached = _mupdf.PDF_ENUM_NAME_adbe_pkcs7_detached
PDF_ENUM_NAME_ca = _mupdf.PDF_ENUM_NAME_ca
PDF_ENUM_NAME_n0 = _mupdf.PDF_ENUM_NAME_n0
PDF_ENUM_NAME_n1 = _mupdf.PDF_ENUM_NAME_n1
PDF_ENUM_NAME_n2 = _mupdf.PDF_ENUM_NAME_n2
PDF_ENUM_NAME_op = _mupdf.PDF_ENUM_NAME_op
PDF_ENUM_LIMIT = _mupdf.PDF_ENUM_LIMIT
PDF_LEXBUF_SMALL = _mupdf.PDF_LEXBUF_SMALL
PDF_LEXBUF_LARGE = _mupdf.PDF_LEXBUF_LARGE
class pdf_lexbuf(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    size = property(_mupdf.pdf_lexbuf_size_get, _mupdf.pdf_lexbuf_size_set)
    base_size = property(_mupdf.pdf_lexbuf_base_size_get, _mupdf.pdf_lexbuf_base_size_set)
    len = property(_mupdf.pdf_lexbuf_len_get, _mupdf.pdf_lexbuf_len_set)
    i = property(_mupdf.pdf_lexbuf_i_get, _mupdf.pdf_lexbuf_i_set)
    f = property(_mupdf.pdf_lexbuf_f_get, _mupdf.pdf_lexbuf_f_set)
    scratch = property(_mupdf.pdf_lexbuf_scratch_get, _mupdf.pdf_lexbuf_scratch_set)
    buffer = property(_mupdf.pdf_lexbuf_buffer_get, _mupdf.pdf_lexbuf_buffer_set)

    def __init__(self):
        _mupdf.pdf_lexbuf_swiginit(self, _mupdf.new_pdf_lexbuf())
    __swig_destroy__ = _mupdf.delete_pdf_lexbuf

# Register pdf_lexbuf in _mupdf:
_mupdf.pdf_lexbuf_swigregister(pdf_lexbuf)

class pdf_lexbuf_large(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    base = property(_mupdf.pdf_lexbuf_large_base_get, _mupdf.pdf_lexbuf_large_base_set)
    buffer = property(_mupdf.pdf_lexbuf_large_buffer_get, _mupdf.pdf_lexbuf_large_buffer_set)

    def __init__(self):
        _mupdf.pdf_lexbuf_large_swiginit(self, _mupdf.new_pdf_lexbuf_large())
    __swig_destroy__ = _mupdf.delete_pdf_lexbuf_large

# Register pdf_lexbuf_large in _mupdf:
_mupdf.pdf_lexbuf_large_swigregister(pdf_lexbuf_large)

class pdf_js_console(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    drop = property(_mupdf.pdf_js_console_drop_get, _mupdf.pdf_js_console_drop_set)
    show = property(_mupdf.pdf_js_console_show_get, _mupdf.pdf_js_console_show_set)
    hide = property(_mupdf.pdf_js_console_hide_get, _mupdf.pdf_js_console_hide_set)
    clear = property(_mupdf.pdf_js_console_clear_get, _mupdf.pdf_js_console_clear_set)
    write = property(_mupdf.pdf_js_console_write_get, _mupdf.pdf_js_console_write_set)

    def __init__(self):
        _mupdf.pdf_js_console_swiginit(self, _mupdf.new_pdf_js_console())
    __swig_destroy__ = _mupdf.delete_pdf_js_console

# Register pdf_js_console in _mupdf:
_mupdf.pdf_js_console_swigregister(pdf_js_console)

class pdf_layer_config(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    name = property(_mupdf.pdf_layer_config_name_get, _mupdf.pdf_layer_config_name_set)
    creator = property(_mupdf.pdf_layer_config_creator_get, _mupdf.pdf_layer_config_creator_set)

    def __init__(self):
        _mupdf.pdf_layer_config_swiginit(self, _mupdf.new_pdf_layer_config())
    __swig_destroy__ = _mupdf.delete_pdf_layer_config

# Register pdf_layer_config in _mupdf:
_mupdf.pdf_layer_config_swigregister(pdf_layer_config)

PDF_LAYER_UI_LABEL = _mupdf.PDF_LAYER_UI_LABEL
PDF_LAYER_UI_CHECKBOX = _mupdf.PDF_LAYER_UI_CHECKBOX
PDF_LAYER_UI_RADIOBOX = _mupdf.PDF_LAYER_UI_RADIOBOX
class pdf_layer_config_ui(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    text = property(_mupdf.pdf_layer_config_ui_text_get, _mupdf.pdf_layer_config_ui_text_set)
    depth = property(_mupdf.pdf_layer_config_ui_depth_get, _mupdf.pdf_layer_config_ui_depth_set)
    type = property(_mupdf.pdf_layer_config_ui_type_get, _mupdf.pdf_layer_config_ui_type_set)
    selected = property(_mupdf.pdf_layer_config_ui_selected_get, _mupdf.pdf_layer_config_ui_selected_set)
    locked = property(_mupdf.pdf_layer_config_ui_locked_get, _mupdf.pdf_layer_config_ui_locked_set)

    def __init__(self):
        _mupdf.pdf_layer_config_ui_swiginit(self, _mupdf.new_pdf_layer_config_ui())
    __swig_destroy__ = _mupdf.delete_pdf_layer_config_ui

# Register pdf_layer_config_ui in _mupdf:
_mupdf.pdf_layer_config_ui_swigregister(pdf_layer_config_ui)

class pdf_unsaved_sig(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    field = property(_mupdf.pdf_unsaved_sig_field_get, _mupdf.pdf_unsaved_sig_field_set)
    byte_range_start = property(_mupdf.pdf_unsaved_sig_byte_range_start_get, _mupdf.pdf_unsaved_sig_byte_range_start_set)
    byte_range_end = property(_mupdf.pdf_unsaved_sig_byte_range_end_get, _mupdf.pdf_unsaved_sig_byte_range_end_set)
    contents_start = property(_mupdf.pdf_unsaved_sig_contents_start_get, _mupdf.pdf_unsaved_sig_contents_start_set)
    contents_end = property(_mupdf.pdf_unsaved_sig_contents_end_get, _mupdf.pdf_unsaved_sig_contents_end_set)
    signer = property(_mupdf.pdf_unsaved_sig_signer_get, _mupdf.pdf_unsaved_sig_signer_set)
    next = property(_mupdf.pdf_unsaved_sig_next_get, _mupdf.pdf_unsaved_sig_next_set)

    def __init__(self):
        _mupdf.pdf_unsaved_sig_swiginit(self, _mupdf.new_pdf_unsaved_sig())
    __swig_destroy__ = _mupdf.delete_pdf_unsaved_sig

# Register pdf_unsaved_sig in _mupdf:
_mupdf.pdf_unsaved_sig_swigregister(pdf_unsaved_sig)

class pdf_rev_page_map(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    page = property(_mupdf.pdf_rev_page_map_page_get, _mupdf.pdf_rev_page_map_page_set)
    object = property(_mupdf.pdf_rev_page_map_object_get, _mupdf.pdf_rev_page_map_object_set)

    def __init__(self):
        _mupdf.pdf_rev_page_map_swiginit(self, _mupdf.new_pdf_rev_page_map())
    __swig_destroy__ = _mupdf.delete_pdf_rev_page_map

# Register pdf_rev_page_map in _mupdf:
_mupdf.pdf_rev_page_map_swigregister(pdf_rev_page_map)

class pdf_hint_page(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    number = property(_mupdf.pdf_hint_page_number_get, _mupdf.pdf_hint_page_number_set)
    offset = property(_mupdf.pdf_hint_page_offset_get, _mupdf.pdf_hint_page_offset_set)
    index = property(_mupdf.pdf_hint_page_index_get, _mupdf.pdf_hint_page_index_set)

    def __init__(self):
        _mupdf.pdf_hint_page_swiginit(self, _mupdf.new_pdf_hint_page())
    __swig_destroy__ = _mupdf.delete_pdf_hint_page

# Register pdf_hint_page in _mupdf:
_mupdf.pdf_hint_page_swigregister(pdf_hint_page)

class pdf_hint_shared(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    number = property(_mupdf.pdf_hint_shared_number_get, _mupdf.pdf_hint_shared_number_set)
    offset = property(_mupdf.pdf_hint_shared_offset_get, _mupdf.pdf_hint_shared_offset_set)

    def __init__(self):
        _mupdf.pdf_hint_shared_swiginit(self, _mupdf.new_pdf_hint_shared())
    __swig_destroy__ = _mupdf.delete_pdf_hint_shared

# Register pdf_hint_shared in _mupdf:
_mupdf.pdf_hint_shared_swigregister(pdf_hint_shared)

class pdf_document(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    super = property(_mupdf.pdf_document_super_get, _mupdf.pdf_document_super_set)
    file = property(_mupdf.pdf_document_file_get, _mupdf.pdf_document_file_set)
    version = property(_mupdf.pdf_document_version_get, _mupdf.pdf_document_version_set)
    startxref = property(_mupdf.pdf_document_startxref_get, _mupdf.pdf_document_startxref_set)
    file_size = property(_mupdf.pdf_document_file_size_get, _mupdf.pdf_document_file_size_set)
    crypt = property(_mupdf.pdf_document_crypt_get, _mupdf.pdf_document_crypt_set)
    ocg = property(_mupdf.pdf_document_ocg_get, _mupdf.pdf_document_ocg_set)
    oi = property(_mupdf.pdf_document_oi_get, _mupdf.pdf_document_oi_set)
    max_xref_len = property(_mupdf.pdf_document_max_xref_len_get, _mupdf.pdf_document_max_xref_len_set)
    num_xref_sections = property(_mupdf.pdf_document_num_xref_sections_get, _mupdf.pdf_document_num_xref_sections_set)
    saved_num_xref_sections = property(_mupdf.pdf_document_saved_num_xref_sections_get, _mupdf.pdf_document_saved_num_xref_sections_set)
    num_incremental_sections = property(_mupdf.pdf_document_num_incremental_sections_get, _mupdf.pdf_document_num_incremental_sections_set)
    xref_base = property(_mupdf.pdf_document_xref_base_get, _mupdf.pdf_document_xref_base_set)
    disallow_new_increments = property(_mupdf.pdf_document_disallow_new_increments_get, _mupdf.pdf_document_disallow_new_increments_set)
    local_xref = property(_mupdf.pdf_document_local_xref_get, _mupdf.pdf_document_local_xref_set)
    local_xref_nesting = property(_mupdf.pdf_document_local_xref_nesting_get, _mupdf.pdf_document_local_xref_nesting_set)
    xref_sections = property(_mupdf.pdf_document_xref_sections_get, _mupdf.pdf_document_xref_sections_set)
    saved_xref_sections = property(_mupdf.pdf_document_saved_xref_sections_get, _mupdf.pdf_document_saved_xref_sections_set)
    xref_index = property(_mupdf.pdf_document_xref_index_get, _mupdf.pdf_document_xref_index_set)
    save_in_progress = property(_mupdf.pdf_document_save_in_progress_get, _mupdf.pdf_document_save_in_progress_set)
    has_xref_streams = property(_mupdf.pdf_document_has_xref_streams_get, _mupdf.pdf_document_has_xref_streams_set)
    has_old_style_xrefs = property(_mupdf.pdf_document_has_old_style_xrefs_get, _mupdf.pdf_document_has_old_style_xrefs_set)
    has_linearization_object = property(_mupdf.pdf_document_has_linearization_object_get, _mupdf.pdf_document_has_linearization_object_set)
    rev_page_count = property(_mupdf.pdf_document_rev_page_count_get, _mupdf.pdf_document_rev_page_count_set)
    rev_page_map = property(_mupdf.pdf_document_rev_page_map_get, _mupdf.pdf_document_rev_page_map_set)
    repair_attempted = property(_mupdf.pdf_document_repair_attempted_get, _mupdf.pdf_document_repair_attempted_set)
    repair_in_progress = property(_mupdf.pdf_document_repair_in_progress_get, _mupdf.pdf_document_repair_in_progress_set)
    file_reading_linearly = property(_mupdf.pdf_document_file_reading_linearly_get, _mupdf.pdf_document_file_reading_linearly_set)
    file_length = property(_mupdf.pdf_document_file_length_get, _mupdf.pdf_document_file_length_set)
    linear_page_count = property(_mupdf.pdf_document_linear_page_count_get, _mupdf.pdf_document_linear_page_count_set)
    linear_obj = property(_mupdf.pdf_document_linear_obj_get, _mupdf.pdf_document_linear_obj_set)
    linear_page_refs = property(_mupdf.pdf_document_linear_page_refs_get, _mupdf.pdf_document_linear_page_refs_set)
    linear_page1_obj_num = property(_mupdf.pdf_document_linear_page1_obj_num_get, _mupdf.pdf_document_linear_page1_obj_num_set)
    linear_pos = property(_mupdf.pdf_document_linear_pos_get, _mupdf.pdf_document_linear_pos_set)
    linear_page_num = property(_mupdf.pdf_document_linear_page_num_get, _mupdf.pdf_document_linear_page_num_set)
    hint_object_offset = property(_mupdf.pdf_document_hint_object_offset_get, _mupdf.pdf_document_hint_object_offset_set)
    hint_object_length = property(_mupdf.pdf_document_hint_object_length_get, _mupdf.pdf_document_hint_object_length_set)
    hints_loaded = property(_mupdf.pdf_document_hints_loaded_get, _mupdf.pdf_document_hints_loaded_set)
    hint_page = property(_mupdf.pdf_document_hint_page_get, _mupdf.pdf_document_hint_page_set)
    hint_shared_ref = property(_mupdf.pdf_document_hint_shared_ref_get, _mupdf.pdf_document_hint_shared_ref_set)
    hint_shared = property(_mupdf.pdf_document_hint_shared_get, _mupdf.pdf_document_hint_shared_set)
    hint_obj_offsets_max = property(_mupdf.pdf_document_hint_obj_offsets_max_get, _mupdf.pdf_document_hint_obj_offsets_max_set)
    hint_obj_offsets = property(_mupdf.pdf_document_hint_obj_offsets_get, _mupdf.pdf_document_hint_obj_offsets_set)
    resources_localised = property(_mupdf.pdf_document_resources_localised_get, _mupdf.pdf_document_resources_localised_set)
    lexbuf = property(_mupdf.pdf_document_lexbuf_get, _mupdf.pdf_document_lexbuf_set)
    js = property(_mupdf.pdf_document_js_get, _mupdf.pdf_document_js_set)
    recalculate = property(_mupdf.pdf_document_recalculate_get, _mupdf.pdf_document_recalculate_set)
    redacted = property(_mupdf.pdf_document_redacted_get, _mupdf.pdf_document_redacted_set)
    resynth_required = property(_mupdf.pdf_document_resynth_required_get, _mupdf.pdf_document_resynth_required_set)
    event_cb = property(_mupdf.pdf_document_event_cb_get, _mupdf.pdf_document_event_cb_set)
    free_event_data_cb = property(_mupdf.pdf_document_free_event_data_cb_get, _mupdf.pdf_document_free_event_data_cb_set)
    event_cb_data = property(_mupdf.pdf_document_event_cb_data_get, _mupdf.pdf_document_event_cb_data_set)
    num_type3_fonts = property(_mupdf.pdf_document_num_type3_fonts_get, _mupdf.pdf_document_num_type3_fonts_set)
    max_type3_fonts = property(_mupdf.pdf_document_max_type3_fonts_get, _mupdf.pdf_document_max_type3_fonts_set)
    type3_fonts = property(_mupdf.pdf_document_type3_fonts_get, _mupdf.pdf_document_type3_fonts_set)
    orphans_max = property(_mupdf.pdf_document_orphans_max_get, _mupdf.pdf_document_orphans_max_set)
    orphans_count = property(_mupdf.pdf_document_orphans_count_get, _mupdf.pdf_document_orphans_count_set)
    orphans = property(_mupdf.pdf_document_orphans_get, _mupdf.pdf_document_orphans_set)
    xfa = property(_mupdf.pdf_document_xfa_get, _mupdf.pdf_document_xfa_set)
    journal = property(_mupdf.pdf_document_journal_get, _mupdf.pdf_document_journal_set)

    def __init__(self):
        _mupdf.pdf_document_swiginit(self, _mupdf.new_pdf_document())
    __swig_destroy__ = _mupdf.delete_pdf_document

# Register pdf_document in _mupdf:
_mupdf.pdf_document_swigregister(pdf_document)

class pdf_write_options(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    do_incremental = property(_mupdf.pdf_write_options_do_incremental_get, _mupdf.pdf_write_options_do_incremental_set)
    do_pretty = property(_mupdf.pdf_write_options_do_pretty_get, _mupdf.pdf_write_options_do_pretty_set)
    do_ascii = property(_mupdf.pdf_write_options_do_ascii_get, _mupdf.pdf_write_options_do_ascii_set)
    do_compress = property(_mupdf.pdf_write_options_do_compress_get, _mupdf.pdf_write_options_do_compress_set)
    do_compress_images = property(_mupdf.pdf_write_options_do_compress_images_get, _mupdf.pdf_write_options_do_compress_images_set)
    do_compress_fonts = property(_mupdf.pdf_write_options_do_compress_fonts_get, _mupdf.pdf_write_options_do_compress_fonts_set)
    do_decompress = property(_mupdf.pdf_write_options_do_decompress_get, _mupdf.pdf_write_options_do_decompress_set)
    do_garbage = property(_mupdf.pdf_write_options_do_garbage_get, _mupdf.pdf_write_options_do_garbage_set)
    do_linear = property(_mupdf.pdf_write_options_do_linear_get, _mupdf.pdf_write_options_do_linear_set)
    do_clean = property(_mupdf.pdf_write_options_do_clean_get, _mupdf.pdf_write_options_do_clean_set)
    do_sanitize = property(_mupdf.pdf_write_options_do_sanitize_get, _mupdf.pdf_write_options_do_sanitize_set)
    do_appearance = property(_mupdf.pdf_write_options_do_appearance_get, _mupdf.pdf_write_options_do_appearance_set)
    do_encrypt = property(_mupdf.pdf_write_options_do_encrypt_get, _mupdf.pdf_write_options_do_encrypt_set)
    dont_regenerate_id = property(_mupdf.pdf_write_options_dont_regenerate_id_get, _mupdf.pdf_write_options_dont_regenerate_id_set)
    permissions = property(_mupdf.pdf_write_options_permissions_get, _mupdf.pdf_write_options_permissions_set)
    opwd_utf8 = property(_mupdf.pdf_write_options_opwd_utf8_get, _mupdf.pdf_write_options_opwd_utf8_set)
    upwd_utf8 = property(_mupdf.pdf_write_options_upwd_utf8_get, _mupdf.pdf_write_options_upwd_utf8_set)
    do_snapshot = property(_mupdf.pdf_write_options_do_snapshot_get, _mupdf.pdf_write_options_do_snapshot_set)
    do_preserve_metadata = property(_mupdf.pdf_write_options_do_preserve_metadata_get, _mupdf.pdf_write_options_do_preserve_metadata_set)

    def __init__(self):
        _mupdf.pdf_write_options_swiginit(self, _mupdf.new_pdf_write_options())
    __swig_destroy__ = _mupdf.delete_pdf_write_options

# Register pdf_write_options in _mupdf:
_mupdf.pdf_write_options_swigregister(pdf_write_options)

PDF_TOK_ERROR = _mupdf.PDF_TOK_ERROR
PDF_TOK_EOF = _mupdf.PDF_TOK_EOF
PDF_TOK_OPEN_ARRAY = _mupdf.PDF_TOK_OPEN_ARRAY
PDF_TOK_CLOSE_ARRAY = _mupdf.PDF_TOK_CLOSE_ARRAY
PDF_TOK_OPEN_DICT = _mupdf.PDF_TOK_OPEN_DICT
PDF_TOK_CLOSE_DICT = _mupdf.PDF_TOK_CLOSE_DICT
PDF_TOK_OPEN_BRACE = _mupdf.PDF_TOK_OPEN_BRACE
PDF_TOK_CLOSE_BRACE = _mupdf.PDF_TOK_CLOSE_BRACE
PDF_TOK_NAME = _mupdf.PDF_TOK_NAME
PDF_TOK_INT = _mupdf.PDF_TOK_INT
PDF_TOK_REAL = _mupdf.PDF_TOK_REAL
PDF_TOK_STRING = _mupdf.PDF_TOK_STRING
PDF_TOK_KEYWORD = _mupdf.PDF_TOK_KEYWORD
PDF_TOK_R = _mupdf.PDF_TOK_R
PDF_TOK_TRUE = _mupdf.PDF_TOK_TRUE
PDF_TOK_FALSE = _mupdf.PDF_TOK_FALSE
PDF_TOK_NULL = _mupdf.PDF_TOK_NULL
PDF_TOK_OBJ = _mupdf.PDF_TOK_OBJ
PDF_TOK_ENDOBJ = _mupdf.PDF_TOK_ENDOBJ
PDF_TOK_STREAM = _mupdf.PDF_TOK_STREAM
PDF_TOK_ENDSTREAM = _mupdf.PDF_TOK_ENDSTREAM
PDF_TOK_XREF = _mupdf.PDF_TOK_XREF
PDF_TOK_TRAILER = _mupdf.PDF_TOK_TRAILER
PDF_TOK_STARTXREF = _mupdf.PDF_TOK_STARTXREF
PDF_TOK_NEWOBJ = _mupdf.PDF_TOK_NEWOBJ
PDF_NUM_TOKENS = _mupdf.PDF_NUM_TOKENS
class pdf_xref_entry(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    type = property(_mupdf.pdf_xref_entry_type_get, _mupdf.pdf_xref_entry_type_set)
    marked = property(_mupdf.pdf_xref_entry_marked_get, _mupdf.pdf_xref_entry_marked_set)
    gen = property(_mupdf.pdf_xref_entry_gen_get, _mupdf.pdf_xref_entry_gen_set)
    num = property(_mupdf.pdf_xref_entry_num_get, _mupdf.pdf_xref_entry_num_set)
    ofs = property(_mupdf.pdf_xref_entry_ofs_get, _mupdf.pdf_xref_entry_ofs_set)
    stm_ofs = property(_mupdf.pdf_xref_entry_stm_ofs_get, _mupdf.pdf_xref_entry_stm_ofs_set)
    stm_buf = property(_mupdf.pdf_xref_entry_stm_buf_get, _mupdf.pdf_xref_entry_stm_buf_set)
    obj = property(_mupdf.pdf_xref_entry_obj_get, _mupdf.pdf_xref_entry_obj_set)

    def __init__(self):
        _mupdf.pdf_xref_entry_swiginit(self, _mupdf.new_pdf_xref_entry())
    __swig_destroy__ = _mupdf.delete_pdf_xref_entry

# Register pdf_xref_entry in _mupdf:
_mupdf.pdf_xref_entry_swigregister(pdf_xref_entry)
pdf_default_write_options = cvar.pdf_default_write_options

class pdf_xref_subsec(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    next = property(_mupdf.pdf_xref_subsec_next_get, _mupdf.pdf_xref_subsec_next_set)
    len = property(_mupdf.pdf_xref_subsec_len_get, _mupdf.pdf_xref_subsec_len_set)
    start = property(_mupdf.pdf_xref_subsec_start_get, _mupdf.pdf_xref_subsec_start_set)
    table = property(_mupdf.pdf_xref_subsec_table_get, _mupdf.pdf_xref_subsec_table_set)

    def __init__(self):
        _mupdf.pdf_xref_subsec_swiginit(self, _mupdf.new_pdf_xref_subsec())
    __swig_destroy__ = _mupdf.delete_pdf_xref_subsec

# Register pdf_xref_subsec in _mupdf:
_mupdf.pdf_xref_subsec_swigregister(pdf_xref_subsec)

class pdf_xref(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    num_objects = property(_mupdf.pdf_xref_num_objects_get, _mupdf.pdf_xref_num_objects_set)
    subsec = property(_mupdf.pdf_xref_subsec_get, _mupdf.pdf_xref_subsec_set)
    trailer = property(_mupdf.pdf_xref_trailer_get, _mupdf.pdf_xref_trailer_set)
    pre_repair_trailer = property(_mupdf.pdf_xref_pre_repair_trailer_get, _mupdf.pdf_xref_pre_repair_trailer_set)
    unsaved_sigs = property(_mupdf.pdf_xref_unsaved_sigs_get, _mupdf.pdf_xref_unsaved_sigs_set)
    unsaved_sigs_end = property(_mupdf.pdf_xref_unsaved_sigs_end_get, _mupdf.pdf_xref_unsaved_sigs_end_set)
    end_ofs = property(_mupdf.pdf_xref_end_ofs_get, _mupdf.pdf_xref_end_ofs_set)

    def __init__(self):
        _mupdf.pdf_xref_swiginit(self, _mupdf.new_pdf_xref())
    __swig_destroy__ = _mupdf.delete_pdf_xref

# Register pdf_xref in _mupdf:
_mupdf.pdf_xref_swigregister(pdf_xref)

PDF_ENCRYPT_KEEP = _mupdf.PDF_ENCRYPT_KEEP
PDF_ENCRYPT_NONE = _mupdf.PDF_ENCRYPT_NONE
PDF_ENCRYPT_RC4_40 = _mupdf.PDF_ENCRYPT_RC4_40
PDF_ENCRYPT_RC4_128 = _mupdf.PDF_ENCRYPT_RC4_128
PDF_ENCRYPT_AES_128 = _mupdf.PDF_ENCRYPT_AES_128
PDF_ENCRYPT_AES_256 = _mupdf.PDF_ENCRYPT_AES_256
PDF_ENCRYPT_UNKNOWN = _mupdf.PDF_ENCRYPT_UNKNOWN
PDF_PERM_PRINT = _mupdf.PDF_PERM_PRINT
PDF_PERM_MODIFY = _mupdf.PDF_PERM_MODIFY
PDF_PERM_COPY = _mupdf.PDF_PERM_COPY
PDF_PERM_ANNOTATE = _mupdf.PDF_PERM_ANNOTATE
PDF_PERM_FORM = _mupdf.PDF_PERM_FORM
PDF_PERM_ACCESSIBILITY = _mupdf.PDF_PERM_ACCESSIBILITY
PDF_PERM_ASSEMBLE = _mupdf.PDF_PERM_ASSEMBLE
PDF_PERM_PRINT_HQ = _mupdf.PDF_PERM_PRINT_HQ
PDF_MRANGE_CAP = _mupdf.PDF_MRANGE_CAP
class pdf_range(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    low = property(_mupdf.pdf_range_low_get, _mupdf.pdf_range_low_set)
    high = property(_mupdf.pdf_range_high_get, _mupdf.pdf_range_high_set)
    out = property(_mupdf.pdf_range_out_get, _mupdf.pdf_range_out_set)

    def __init__(self):
        _mupdf.pdf_range_swiginit(self, _mupdf.new_pdf_range())
    __swig_destroy__ = _mupdf.delete_pdf_range

# Register pdf_range in _mupdf:
_mupdf.pdf_range_swigregister(pdf_range)

class pdf_xrange(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    low = property(_mupdf.pdf_xrange_low_get, _mupdf.pdf_xrange_low_set)
    high = property(_mupdf.pdf_xrange_high_get, _mupdf.pdf_xrange_high_set)
    out = property(_mupdf.pdf_xrange_out_get, _mupdf.pdf_xrange_out_set)

    def __init__(self):
        _mupdf.pdf_xrange_swiginit(self, _mupdf.new_pdf_xrange())
    __swig_destroy__ = _mupdf.delete_pdf_xrange

# Register pdf_xrange in _mupdf:
_mupdf.pdf_xrange_swigregister(pdf_xrange)

class pdf_mrange(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    low = property(_mupdf.pdf_mrange_low_get, _mupdf.pdf_mrange_low_set)
    out = property(_mupdf.pdf_mrange_out_get, _mupdf.pdf_mrange_out_set)

    def __init__(self):
        _mupdf.pdf_mrange_swiginit(self, _mupdf.new_pdf_mrange())
    __swig_destroy__ = _mupdf.delete_pdf_mrange

# Register pdf_mrange in _mupdf:
_mupdf.pdf_mrange_swigregister(pdf_mrange)

class pdf_cmap(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    storable = property(_mupdf.pdf_cmap_storable_get, _mupdf.pdf_cmap_storable_set)
    cmap_name = property(_mupdf.pdf_cmap_cmap_name_get, _mupdf.pdf_cmap_cmap_name_set)
    usecmap_name = property(_mupdf.pdf_cmap_usecmap_name_get, _mupdf.pdf_cmap_usecmap_name_set)
    usecmap = property(_mupdf.pdf_cmap_usecmap_get, _mupdf.pdf_cmap_usecmap_set)
    wmode = property(_mupdf.pdf_cmap_wmode_get, _mupdf.pdf_cmap_wmode_set)
    codespace_len = property(_mupdf.pdf_cmap_codespace_len_get, _mupdf.pdf_cmap_codespace_len_set)
    rlen = property(_mupdf.pdf_cmap_rlen_get, _mupdf.pdf_cmap_rlen_set)
    rcap = property(_mupdf.pdf_cmap_rcap_get, _mupdf.pdf_cmap_rcap_set)
    ranges = property(_mupdf.pdf_cmap_ranges_get, _mupdf.pdf_cmap_ranges_set)
    xlen = property(_mupdf.pdf_cmap_xlen_get, _mupdf.pdf_cmap_xlen_set)
    xcap = property(_mupdf.pdf_cmap_xcap_get, _mupdf.pdf_cmap_xcap_set)
    xranges = property(_mupdf.pdf_cmap_xranges_get, _mupdf.pdf_cmap_xranges_set)
    mlen = property(_mupdf.pdf_cmap_mlen_get, _mupdf.pdf_cmap_mlen_set)
    mcap = property(_mupdf.pdf_cmap_mcap_get, _mupdf.pdf_cmap_mcap_set)
    mranges = property(_mupdf.pdf_cmap_mranges_get, _mupdf.pdf_cmap_mranges_set)
    dlen = property(_mupdf.pdf_cmap_dlen_get, _mupdf.pdf_cmap_dlen_set)
    dcap = property(_mupdf.pdf_cmap_dcap_get, _mupdf.pdf_cmap_dcap_set)
    dict = property(_mupdf.pdf_cmap_dict_get, _mupdf.pdf_cmap_dict_set)
    tlen = property(_mupdf.pdf_cmap_tlen_get, _mupdf.pdf_cmap_tlen_set)
    tcap = property(_mupdf.pdf_cmap_tcap_get, _mupdf.pdf_cmap_tcap_set)
    ttop = property(_mupdf.pdf_cmap_ttop_get, _mupdf.pdf_cmap_ttop_set)
    tree = property(_mupdf.pdf_cmap_tree_get, _mupdf.pdf_cmap_tree_set)

    def __init__(self):
        _mupdf.pdf_cmap_swiginit(self, _mupdf.new_pdf_cmap())
    __swig_destroy__ = _mupdf.delete_pdf_cmap

# Register pdf_cmap in _mupdf:
_mupdf.pdf_cmap_swigregister(pdf_cmap)

PDF_FD_FIXED_PITCH = _mupdf.PDF_FD_FIXED_PITCH
PDF_FD_SERIF = _mupdf.PDF_FD_SERIF
PDF_FD_SYMBOLIC = _mupdf.PDF_FD_SYMBOLIC
PDF_FD_SCRIPT = _mupdf.PDF_FD_SCRIPT
PDF_FD_NONSYMBOLIC = _mupdf.PDF_FD_NONSYMBOLIC
PDF_FD_ITALIC = _mupdf.PDF_FD_ITALIC
PDF_FD_ALL_CAP = _mupdf.PDF_FD_ALL_CAP
PDF_FD_SMALL_CAP = _mupdf.PDF_FD_SMALL_CAP
PDF_FD_FORCE_BOLD = _mupdf.PDF_FD_FORCE_BOLD
class pdf_hmtx(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    lo = property(_mupdf.pdf_hmtx_lo_get, _mupdf.pdf_hmtx_lo_set)
    hi = property(_mupdf.pdf_hmtx_hi_get, _mupdf.pdf_hmtx_hi_set)
    w = property(_mupdf.pdf_hmtx_w_get, _mupdf.pdf_hmtx_w_set)

    def __init__(self):
        _mupdf.pdf_hmtx_swiginit(self, _mupdf.new_pdf_hmtx())
    __swig_destroy__ = _mupdf.delete_pdf_hmtx

# Register pdf_hmtx in _mupdf:
_mupdf.pdf_hmtx_swigregister(pdf_hmtx)

class pdf_vmtx(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    lo = property(_mupdf.pdf_vmtx_lo_get, _mupdf.pdf_vmtx_lo_set)
    hi = property(_mupdf.pdf_vmtx_hi_get, _mupdf.pdf_vmtx_hi_set)
    x = property(_mupdf.pdf_vmtx_x_get, _mupdf.pdf_vmtx_x_set)
    y = property(_mupdf.pdf_vmtx_y_get, _mupdf.pdf_vmtx_y_set)
    w = property(_mupdf.pdf_vmtx_w_get, _mupdf.pdf_vmtx_w_set)

    def __init__(self):
        _mupdf.pdf_vmtx_swiginit(self, _mupdf.new_pdf_vmtx())
    __swig_destroy__ = _mupdf.delete_pdf_vmtx

# Register pdf_vmtx in _mupdf:
_mupdf.pdf_vmtx_swigregister(pdf_vmtx)

class pdf_font_desc(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    storable = property(_mupdf.pdf_font_desc_storable_get, _mupdf.pdf_font_desc_storable_set)
    size = property(_mupdf.pdf_font_desc_size_get, _mupdf.pdf_font_desc_size_set)
    font = property(_mupdf.pdf_font_desc_font_get, _mupdf.pdf_font_desc_font_set)
    flags = property(_mupdf.pdf_font_desc_flags_get, _mupdf.pdf_font_desc_flags_set)
    italic_angle = property(_mupdf.pdf_font_desc_italic_angle_get, _mupdf.pdf_font_desc_italic_angle_set)
    ascent = property(_mupdf.pdf_font_desc_ascent_get, _mupdf.pdf_font_desc_ascent_set)
    descent = property(_mupdf.pdf_font_desc_descent_get, _mupdf.pdf_font_desc_descent_set)
    cap_height = property(_mupdf.pdf_font_desc_cap_height_get, _mupdf.pdf_font_desc_cap_height_set)
    x_height = property(_mupdf.pdf_font_desc_x_height_get, _mupdf.pdf_font_desc_x_height_set)
    missing_width = property(_mupdf.pdf_font_desc_missing_width_get, _mupdf.pdf_font_desc_missing_width_set)
    encoding = property(_mupdf.pdf_font_desc_encoding_get, _mupdf.pdf_font_desc_encoding_set)
    to_ttf_cmap = property(_mupdf.pdf_font_desc_to_ttf_cmap_get, _mupdf.pdf_font_desc_to_ttf_cmap_set)
    cid_to_gid_len = property(_mupdf.pdf_font_desc_cid_to_gid_len_get, _mupdf.pdf_font_desc_cid_to_gid_len_set)
    cid_to_gid = property(_mupdf.pdf_font_desc_cid_to_gid_get, _mupdf.pdf_font_desc_cid_to_gid_set)
    to_unicode = property(_mupdf.pdf_font_desc_to_unicode_get, _mupdf.pdf_font_desc_to_unicode_set)
    cid_to_ucs_len = property(_mupdf.pdf_font_desc_cid_to_ucs_len_get, _mupdf.pdf_font_desc_cid_to_ucs_len_set)
    cid_to_ucs = property(_mupdf.pdf_font_desc_cid_to_ucs_get, _mupdf.pdf_font_desc_cid_to_ucs_set)
    wmode = property(_mupdf.pdf_font_desc_wmode_get, _mupdf.pdf_font_desc_wmode_set)
    hmtx_len = property(_mupdf.pdf_font_desc_hmtx_len_get, _mupdf.pdf_font_desc_hmtx_len_set)
    hmtx_cap = property(_mupdf.pdf_font_desc_hmtx_cap_get, _mupdf.pdf_font_desc_hmtx_cap_set)
    dhmtx = property(_mupdf.pdf_font_desc_dhmtx_get, _mupdf.pdf_font_desc_dhmtx_set)
    hmtx = property(_mupdf.pdf_font_desc_hmtx_get, _mupdf.pdf_font_desc_hmtx_set)
    vmtx_len = property(_mupdf.pdf_font_desc_vmtx_len_get, _mupdf.pdf_font_desc_vmtx_len_set)
    vmtx_cap = property(_mupdf.pdf_font_desc_vmtx_cap_get, _mupdf.pdf_font_desc_vmtx_cap_set)
    dvmtx = property(_mupdf.pdf_font_desc_dvmtx_get, _mupdf.pdf_font_desc_dvmtx_set)
    vmtx = property(_mupdf.pdf_font_desc_vmtx_get, _mupdf.pdf_font_desc_vmtx_set)
    is_embedded = property(_mupdf.pdf_font_desc_is_embedded_get, _mupdf.pdf_font_desc_is_embedded_set)

    def __init__(self):
        _mupdf.pdf_font_desc_swiginit(self, _mupdf.new_pdf_font_desc())
    __swig_destroy__ = _mupdf.delete_pdf_font_desc

# Register pdf_font_desc in _mupdf:
_mupdf.pdf_font_desc_swigregister(pdf_font_desc)

PDF_SIMPLE_FONT_RESOURCE = _mupdf.PDF_SIMPLE_FONT_RESOURCE
PDF_CID_FONT_RESOURCE = _mupdf.PDF_CID_FONT_RESOURCE
PDF_CJK_FONT_RESOURCE = _mupdf.PDF_CJK_FONT_RESOURCE
PDF_SIMPLE_ENCODING_LATIN = _mupdf.PDF_SIMPLE_ENCODING_LATIN
PDF_SIMPLE_ENCODING_GREEK = _mupdf.PDF_SIMPLE_ENCODING_GREEK
PDF_SIMPLE_ENCODING_CYRILLIC = _mupdf.PDF_SIMPLE_ENCODING_CYRILLIC
class pdf_font_resource_key(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    digest = property(_mupdf.pdf_font_resource_key_digest_get, _mupdf.pdf_font_resource_key_digest_set)
    type = property(_mupdf.pdf_font_resource_key_type_get, _mupdf.pdf_font_resource_key_type_set)
    encoding = property(_mupdf.pdf_font_resource_key_encoding_get, _mupdf.pdf_font_resource_key_encoding_set)
    local_xref = property(_mupdf.pdf_font_resource_key_local_xref_get, _mupdf.pdf_font_resource_key_local_xref_set)

    def __init__(self):
        _mupdf.pdf_font_resource_key_swiginit(self, _mupdf.new_pdf_font_resource_key())
    __swig_destroy__ = _mupdf.delete_pdf_font_resource_key

# Register pdf_font_resource_key in _mupdf:
_mupdf.pdf_font_resource_key_swigregister(pdf_font_resource_key)

class pdf_pattern(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    storable = property(_mupdf.pdf_pattern_storable_get, _mupdf.pdf_pattern_storable_set)
    ismask = property(_mupdf.pdf_pattern_ismask_get, _mupdf.pdf_pattern_ismask_set)
    xstep = property(_mupdf.pdf_pattern_xstep_get, _mupdf.pdf_pattern_xstep_set)
    ystep = property(_mupdf.pdf_pattern_ystep_get, _mupdf.pdf_pattern_ystep_set)
    matrix = property(_mupdf.pdf_pattern_matrix_get, _mupdf.pdf_pattern_matrix_set)
    bbox = property(_mupdf.pdf_pattern_bbox_get, _mupdf.pdf_pattern_bbox_set)
    document = property(_mupdf.pdf_pattern_document_get, _mupdf.pdf_pattern_document_set)
    resources = property(_mupdf.pdf_pattern_resources_get, _mupdf.pdf_pattern_resources_set)
    contents = property(_mupdf.pdf_pattern_contents_get, _mupdf.pdf_pattern_contents_set)
    id = property(_mupdf.pdf_pattern_id_get, _mupdf.pdf_pattern_id_set)

    def __init__(self):
        _mupdf.pdf_pattern_swiginit(self, _mupdf.new_pdf_pattern())
    __swig_destroy__ = _mupdf.delete_pdf_pattern

# Register pdf_pattern in _mupdf:
_mupdf.pdf_pattern_swigregister(pdf_pattern)

class pdf_processor(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    refs = property(_mupdf.pdf_processor_refs_get, _mupdf.pdf_processor_refs_set)
    close_processor = property(_mupdf.pdf_processor_close_processor_get, _mupdf.pdf_processor_close_processor_set)
    drop_processor = property(_mupdf.pdf_processor_drop_processor_get, _mupdf.pdf_processor_drop_processor_set)
    op_w = property(_mupdf.pdf_processor_op_w_get, _mupdf.pdf_processor_op_w_set)
    op_j = property(_mupdf.pdf_processor_op_j_get, _mupdf.pdf_processor_op_j_set)
    op_J = property(_mupdf.pdf_processor_op_J_get, _mupdf.pdf_processor_op_J_set)
    op_M = property(_mupdf.pdf_processor_op_M_get, _mupdf.pdf_processor_op_M_set)
    op_d = property(_mupdf.pdf_processor_op_d_get, _mupdf.pdf_processor_op_d_set)
    op_ri = property(_mupdf.pdf_processor_op_ri_get, _mupdf.pdf_processor_op_ri_set)
    op_i = property(_mupdf.pdf_processor_op_i_get, _mupdf.pdf_processor_op_i_set)
    op_gs_begin = property(_mupdf.pdf_processor_op_gs_begin_get, _mupdf.pdf_processor_op_gs_begin_set)
    op_gs_BM = property(_mupdf.pdf_processor_op_gs_BM_get, _mupdf.pdf_processor_op_gs_BM_set)
    op_gs_ca = property(_mupdf.pdf_processor_op_gs_ca_get, _mupdf.pdf_processor_op_gs_ca_set)
    op_gs_CA = property(_mupdf.pdf_processor_op_gs_CA_get, _mupdf.pdf_processor_op_gs_CA_set)
    op_gs_SMask = property(_mupdf.pdf_processor_op_gs_SMask_get, _mupdf.pdf_processor_op_gs_SMask_set)
    op_gs_end = property(_mupdf.pdf_processor_op_gs_end_get, _mupdf.pdf_processor_op_gs_end_set)
    op_q = property(_mupdf.pdf_processor_op_q_get, _mupdf.pdf_processor_op_q_set)
    op_Q = property(_mupdf.pdf_processor_op_Q_get, _mupdf.pdf_processor_op_Q_set)
    op_cm = property(_mupdf.pdf_processor_op_cm_get, _mupdf.pdf_processor_op_cm_set)
    op_m = property(_mupdf.pdf_processor_op_m_get, _mupdf.pdf_processor_op_m_set)
    op_l = property(_mupdf.pdf_processor_op_l_get, _mupdf.pdf_processor_op_l_set)
    op_c = property(_mupdf.pdf_processor_op_c_get, _mupdf.pdf_processor_op_c_set)
    op_v = property(_mupdf.pdf_processor_op_v_get, _mupdf.pdf_processor_op_v_set)
    op_y = property(_mupdf.pdf_processor_op_y_get, _mupdf.pdf_processor_op_y_set)
    op_h = property(_mupdf.pdf_processor_op_h_get, _mupdf.pdf_processor_op_h_set)
    op_re = property(_mupdf.pdf_processor_op_re_get, _mupdf.pdf_processor_op_re_set)
    op_S = property(_mupdf.pdf_processor_op_S_get, _mupdf.pdf_processor_op_S_set)
    op_s = property(_mupdf.pdf_processor_op_s_get, _mupdf.pdf_processor_op_s_set)
    op_F = property(_mupdf.pdf_processor_op_F_get, _mupdf.pdf_processor_op_F_set)
    op_f = property(_mupdf.pdf_processor_op_f_get, _mupdf.pdf_processor_op_f_set)
    op_fstar = property(_mupdf.pdf_processor_op_fstar_get, _mupdf.pdf_processor_op_fstar_set)
    op_B = property(_mupdf.pdf_processor_op_B_get, _mupdf.pdf_processor_op_B_set)
    op_Bstar = property(_mupdf.pdf_processor_op_Bstar_get, _mupdf.pdf_processor_op_Bstar_set)
    op_b = property(_mupdf.pdf_processor_op_b_get, _mupdf.pdf_processor_op_b_set)
    op_bstar = property(_mupdf.pdf_processor_op_bstar_get, _mupdf.pdf_processor_op_bstar_set)
    op_n = property(_mupdf.pdf_processor_op_n_get, _mupdf.pdf_processor_op_n_set)
    op_W = property(_mupdf.pdf_processor_op_W_get, _mupdf.pdf_processor_op_W_set)
    op_Wstar = property(_mupdf.pdf_processor_op_Wstar_get, _mupdf.pdf_processor_op_Wstar_set)
    op_BT = property(_mupdf.pdf_processor_op_BT_get, _mupdf.pdf_processor_op_BT_set)
    op_ET = property(_mupdf.pdf_processor_op_ET_get, _mupdf.pdf_processor_op_ET_set)
    op_Tc = property(_mupdf.pdf_processor_op_Tc_get, _mupdf.pdf_processor_op_Tc_set)
    op_Tw = property(_mupdf.pdf_processor_op_Tw_get, _mupdf.pdf_processor_op_Tw_set)
    op_Tz = property(_mupdf.pdf_processor_op_Tz_get, _mupdf.pdf_processor_op_Tz_set)
    op_TL = property(_mupdf.pdf_processor_op_TL_get, _mupdf.pdf_processor_op_TL_set)
    op_Tf = property(_mupdf.pdf_processor_op_Tf_get, _mupdf.pdf_processor_op_Tf_set)
    op_Tr = property(_mupdf.pdf_processor_op_Tr_get, _mupdf.pdf_processor_op_Tr_set)
    op_Ts = property(_mupdf.pdf_processor_op_Ts_get, _mupdf.pdf_processor_op_Ts_set)
    op_Td = property(_mupdf.pdf_processor_op_Td_get, _mupdf.pdf_processor_op_Td_set)
    op_TD = property(_mupdf.pdf_processor_op_TD_get, _mupdf.pdf_processor_op_TD_set)
    op_Tm = property(_mupdf.pdf_processor_op_Tm_get, _mupdf.pdf_processor_op_Tm_set)
    op_Tstar = property(_mupdf.pdf_processor_op_Tstar_get, _mupdf.pdf_processor_op_Tstar_set)
    op_TJ = property(_mupdf.pdf_processor_op_TJ_get, _mupdf.pdf_processor_op_TJ_set)
    op_Tj = property(_mupdf.pdf_processor_op_Tj_get, _mupdf.pdf_processor_op_Tj_set)
    op_squote = property(_mupdf.pdf_processor_op_squote_get, _mupdf.pdf_processor_op_squote_set)
    op_dquote = property(_mupdf.pdf_processor_op_dquote_get, _mupdf.pdf_processor_op_dquote_set)
    op_d0 = property(_mupdf.pdf_processor_op_d0_get, _mupdf.pdf_processor_op_d0_set)
    op_d1 = property(_mupdf.pdf_processor_op_d1_get, _mupdf.pdf_processor_op_d1_set)
    op_CS = property(_mupdf.pdf_processor_op_CS_get, _mupdf.pdf_processor_op_CS_set)
    op_cs = property(_mupdf.pdf_processor_op_cs_get, _mupdf.pdf_processor_op_cs_set)
    op_SC_pattern = property(_mupdf.pdf_processor_op_SC_pattern_get, _mupdf.pdf_processor_op_SC_pattern_set)
    op_sc_pattern = property(_mupdf.pdf_processor_op_sc_pattern_get, _mupdf.pdf_processor_op_sc_pattern_set)
    op_SC_shade = property(_mupdf.pdf_processor_op_SC_shade_get, _mupdf.pdf_processor_op_SC_shade_set)
    op_sc_shade = property(_mupdf.pdf_processor_op_sc_shade_get, _mupdf.pdf_processor_op_sc_shade_set)
    op_SC_color = property(_mupdf.pdf_processor_op_SC_color_get, _mupdf.pdf_processor_op_SC_color_set)
    op_sc_color = property(_mupdf.pdf_processor_op_sc_color_get, _mupdf.pdf_processor_op_sc_color_set)
    op_G = property(_mupdf.pdf_processor_op_G_get, _mupdf.pdf_processor_op_G_set)
    op_g = property(_mupdf.pdf_processor_op_g_get, _mupdf.pdf_processor_op_g_set)
    op_RG = property(_mupdf.pdf_processor_op_RG_get, _mupdf.pdf_processor_op_RG_set)
    op_rg = property(_mupdf.pdf_processor_op_rg_get, _mupdf.pdf_processor_op_rg_set)
    op_K = property(_mupdf.pdf_processor_op_K_get, _mupdf.pdf_processor_op_K_set)
    op_k = property(_mupdf.pdf_processor_op_k_get, _mupdf.pdf_processor_op_k_set)
    op_BI = property(_mupdf.pdf_processor_op_BI_get, _mupdf.pdf_processor_op_BI_set)
    op_sh = property(_mupdf.pdf_processor_op_sh_get, _mupdf.pdf_processor_op_sh_set)
    op_Do_image = property(_mupdf.pdf_processor_op_Do_image_get, _mupdf.pdf_processor_op_Do_image_set)
    op_Do_form = property(_mupdf.pdf_processor_op_Do_form_get, _mupdf.pdf_processor_op_Do_form_set)
    op_MP = property(_mupdf.pdf_processor_op_MP_get, _mupdf.pdf_processor_op_MP_set)
    op_DP = property(_mupdf.pdf_processor_op_DP_get, _mupdf.pdf_processor_op_DP_set)
    op_BMC = property(_mupdf.pdf_processor_op_BMC_get, _mupdf.pdf_processor_op_BMC_set)
    op_BDC = property(_mupdf.pdf_processor_op_BDC_get, _mupdf.pdf_processor_op_BDC_set)
    op_EMC = property(_mupdf.pdf_processor_op_EMC_get, _mupdf.pdf_processor_op_EMC_set)
    op_BX = property(_mupdf.pdf_processor_op_BX_get, _mupdf.pdf_processor_op_BX_set)
    op_EX = property(_mupdf.pdf_processor_op_EX_get, _mupdf.pdf_processor_op_EX_set)
    op_gs_OP = property(_mupdf.pdf_processor_op_gs_OP_get, _mupdf.pdf_processor_op_gs_OP_set)
    op_gs_op = property(_mupdf.pdf_processor_op_gs_op_get, _mupdf.pdf_processor_op_gs_op_set)
    op_gs_OPM = property(_mupdf.pdf_processor_op_gs_OPM_get, _mupdf.pdf_processor_op_gs_OPM_set)
    op_gs_UseBlackPtComp = property(_mupdf.pdf_processor_op_gs_UseBlackPtComp_get, _mupdf.pdf_processor_op_gs_UseBlackPtComp_set)
    op_END = property(_mupdf.pdf_processor_op_END_get, _mupdf.pdf_processor_op_END_set)
    usage = property(_mupdf.pdf_processor_usage_get, _mupdf.pdf_processor_usage_set)
    hidden = property(_mupdf.pdf_processor_hidden_get, _mupdf.pdf_processor_hidden_set)

    def __init__(self):
        _mupdf.pdf_processor_swiginit(self, _mupdf.new_pdf_processor())
    __swig_destroy__ = _mupdf.delete_pdf_processor

# Register pdf_processor in _mupdf:
_mupdf.pdf_processor_swigregister(pdf_processor)

class pdf_csi(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    doc = property(_mupdf.pdf_csi_doc_get, _mupdf.pdf_csi_doc_set)
    rdb = property(_mupdf.pdf_csi_rdb_get, _mupdf.pdf_csi_rdb_set)
    buf = property(_mupdf.pdf_csi_buf_get, _mupdf.pdf_csi_buf_set)
    cookie = property(_mupdf.pdf_csi_cookie_get, _mupdf.pdf_csi_cookie_set)
    gstate = property(_mupdf.pdf_csi_gstate_get, _mupdf.pdf_csi_gstate_set)
    xbalance = property(_mupdf.pdf_csi_xbalance_get, _mupdf.pdf_csi_xbalance_set)
    in_text = property(_mupdf.pdf_csi_in_text_get, _mupdf.pdf_csi_in_text_set)
    d1_rect = property(_mupdf.pdf_csi_d1_rect_get, _mupdf.pdf_csi_d1_rect_set)
    obj = property(_mupdf.pdf_csi_obj_get, _mupdf.pdf_csi_obj_set)
    name = property(_mupdf.pdf_csi_name_get, _mupdf.pdf_csi_name_set)
    string = property(_mupdf.pdf_csi_string_get, _mupdf.pdf_csi_string_set)
    string_len = property(_mupdf.pdf_csi_string_len_get, _mupdf.pdf_csi_string_len_set)
    top = property(_mupdf.pdf_csi_top_get, _mupdf.pdf_csi_top_set)
    stack = property(_mupdf.pdf_csi_stack_get, _mupdf.pdf_csi_stack_set)

    def __init__(self):
        _mupdf.pdf_csi_swiginit(self, _mupdf.new_pdf_csi())
    __swig_destroy__ = _mupdf.delete_pdf_csi

# Register pdf_csi in _mupdf:
_mupdf.pdf_csi_swigregister(pdf_csi)

class pdf_filter_options(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    opaque = property(_mupdf.pdf_filter_options_opaque_get, _mupdf.pdf_filter_options_opaque_set)
    image_filter = property(_mupdf.pdf_filter_options_image_filter_get, _mupdf.pdf_filter_options_image_filter_set)
    text_filter = property(_mupdf.pdf_filter_options_text_filter_get, _mupdf.pdf_filter_options_text_filter_set)
    after_text_object = property(_mupdf.pdf_filter_options_after_text_object_get, _mupdf.pdf_filter_options_after_text_object_set)
    end_page = property(_mupdf.pdf_filter_options_end_page_get, _mupdf.pdf_filter_options_end_page_set)
    recurse = property(_mupdf.pdf_filter_options_recurse_get, _mupdf.pdf_filter_options_recurse_set)
    instance_forms = property(_mupdf.pdf_filter_options_instance_forms_get, _mupdf.pdf_filter_options_instance_forms_set)
    sanitize = property(_mupdf.pdf_filter_options_sanitize_get, _mupdf.pdf_filter_options_sanitize_set)
    ascii = property(_mupdf.pdf_filter_options_ascii_get, _mupdf.pdf_filter_options_ascii_set)

    def __init__(self):
        _mupdf.pdf_filter_options_swiginit(self, _mupdf.new_pdf_filter_options())
    __swig_destroy__ = _mupdf.delete_pdf_filter_options

# Register pdf_filter_options in _mupdf:
_mupdf.pdf_filter_options_swigregister(pdf_filter_options)

class pdf_text_state(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    char_space = property(_mupdf.pdf_text_state_char_space_get, _mupdf.pdf_text_state_char_space_set)
    word_space = property(_mupdf.pdf_text_state_word_space_get, _mupdf.pdf_text_state_word_space_set)
    scale = property(_mupdf.pdf_text_state_scale_get, _mupdf.pdf_text_state_scale_set)
    leading = property(_mupdf.pdf_text_state_leading_get, _mupdf.pdf_text_state_leading_set)
    font = property(_mupdf.pdf_text_state_font_get, _mupdf.pdf_text_state_font_set)
    size = property(_mupdf.pdf_text_state_size_get, _mupdf.pdf_text_state_size_set)
    render = property(_mupdf.pdf_text_state_render_get, _mupdf.pdf_text_state_render_set)
    rise = property(_mupdf.pdf_text_state_rise_get, _mupdf.pdf_text_state_rise_set)

    def __init__(self):
        _mupdf.pdf_text_state_swiginit(self, _mupdf.new_pdf_text_state())
    __swig_destroy__ = _mupdf.delete_pdf_text_state

# Register pdf_text_state in _mupdf:
_mupdf.pdf_text_state_swigregister(pdf_text_state)

class pdf_text_object_state(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    text = property(_mupdf.pdf_text_object_state_text_get, _mupdf.pdf_text_object_state_text_set)
    text_bbox = property(_mupdf.pdf_text_object_state_text_bbox_get, _mupdf.pdf_text_object_state_text_bbox_set)
    tlm = property(_mupdf.pdf_text_object_state_tlm_get, _mupdf.pdf_text_object_state_tlm_set)
    tm = property(_mupdf.pdf_text_object_state_tm_get, _mupdf.pdf_text_object_state_tm_set)
    text_mode = property(_mupdf.pdf_text_object_state_text_mode_get, _mupdf.pdf_text_object_state_text_mode_set)
    cid = property(_mupdf.pdf_text_object_state_cid_get, _mupdf.pdf_text_object_state_cid_set)
    gid = property(_mupdf.pdf_text_object_state_gid_get, _mupdf.pdf_text_object_state_gid_set)
    char_bbox = property(_mupdf.pdf_text_object_state_char_bbox_get, _mupdf.pdf_text_object_state_char_bbox_set)
    fontdesc = property(_mupdf.pdf_text_object_state_fontdesc_get, _mupdf.pdf_text_object_state_fontdesc_set)
    char_tx = property(_mupdf.pdf_text_object_state_char_tx_get, _mupdf.pdf_text_object_state_char_tx_set)
    char_ty = property(_mupdf.pdf_text_object_state_char_ty_get, _mupdf.pdf_text_object_state_char_ty_set)

    def __init__(self):
        _mupdf.pdf_text_object_state_swiginit(self, _mupdf.new_pdf_text_object_state())
    __swig_destroy__ = _mupdf.delete_pdf_text_object_state

# Register pdf_text_object_state in _mupdf:
_mupdf.pdf_text_object_state_swigregister(pdf_text_object_state)

PDF_REDACT_IMAGE_NONE = _mupdf.PDF_REDACT_IMAGE_NONE
PDF_REDACT_IMAGE_REMOVE = _mupdf.PDF_REDACT_IMAGE_REMOVE
PDF_REDACT_IMAGE_PIXELS = _mupdf.PDF_REDACT_IMAGE_PIXELS
class pdf_redact_options(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    black_boxes = property(_mupdf.pdf_redact_options_black_boxes_get, _mupdf.pdf_redact_options_black_boxes_set)
    image_method = property(_mupdf.pdf_redact_options_image_method_get, _mupdf.pdf_redact_options_image_method_set)

    def __init__(self):
        _mupdf.pdf_redact_options_swiginit(self, _mupdf.new_pdf_redact_options())
    __swig_destroy__ = _mupdf.delete_pdf_redact_options

# Register pdf_redact_options in _mupdf:
_mupdf.pdf_redact_options_swigregister(pdf_redact_options)

class pdf_page(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    super = property(_mupdf.pdf_page_super_get, _mupdf.pdf_page_super_set)
    doc = property(_mupdf.pdf_page_doc_get, _mupdf.pdf_page_doc_set)
    obj = property(_mupdf.pdf_page_obj_get, _mupdf.pdf_page_obj_set)
    transparency = property(_mupdf.pdf_page_transparency_get, _mupdf.pdf_page_transparency_set)
    overprint = property(_mupdf.pdf_page_overprint_get, _mupdf.pdf_page_overprint_set)
    links = property(_mupdf.pdf_page_links_get, _mupdf.pdf_page_links_set)
    annots = property(_mupdf.pdf_page_annots_get, _mupdf.pdf_page_annots_set)
    annot_tailp = property(_mupdf.pdf_page_annot_tailp_get, _mupdf.pdf_page_annot_tailp_set)
    widgets = property(_mupdf.pdf_page_widgets_get, _mupdf.pdf_page_widgets_set)
    widget_tailp = property(_mupdf.pdf_page_widget_tailp_get, _mupdf.pdf_page_widget_tailp_set)

    def __init__(self):
        _mupdf.pdf_page_swiginit(self, _mupdf.new_pdf_page())
    __swig_destroy__ = _mupdf.delete_pdf_page

# Register pdf_page in _mupdf:
_mupdf.pdf_page_swigregister(pdf_page)

PDF_ANNOT_TEXT = _mupdf.PDF_ANNOT_TEXT
PDF_ANNOT_LINK = _mupdf.PDF_ANNOT_LINK
PDF_ANNOT_FREE_TEXT = _mupdf.PDF_ANNOT_FREE_TEXT
PDF_ANNOT_LINE = _mupdf.PDF_ANNOT_LINE
PDF_ANNOT_SQUARE = _mupdf.PDF_ANNOT_SQUARE
PDF_ANNOT_CIRCLE = _mupdf.PDF_ANNOT_CIRCLE
PDF_ANNOT_POLYGON = _mupdf.PDF_ANNOT_POLYGON
PDF_ANNOT_POLY_LINE = _mupdf.PDF_ANNOT_POLY_LINE
PDF_ANNOT_HIGHLIGHT = _mupdf.PDF_ANNOT_HIGHLIGHT
PDF_ANNOT_UNDERLINE = _mupdf.PDF_ANNOT_UNDERLINE
PDF_ANNOT_SQUIGGLY = _mupdf.PDF_ANNOT_SQUIGGLY
PDF_ANNOT_STRIKE_OUT = _mupdf.PDF_ANNOT_STRIKE_OUT
PDF_ANNOT_REDACT = _mupdf.PDF_ANNOT_REDACT
PDF_ANNOT_STAMP = _mupdf.PDF_ANNOT_STAMP
PDF_ANNOT_CARET = _mupdf.PDF_ANNOT_CARET
PDF_ANNOT_INK = _mupdf.PDF_ANNOT_INK
PDF_ANNOT_POPUP = _mupdf.PDF_ANNOT_POPUP
PDF_ANNOT_FILE_ATTACHMENT = _mupdf.PDF_ANNOT_FILE_ATTACHMENT
PDF_ANNOT_SOUND = _mupdf.PDF_ANNOT_SOUND
PDF_ANNOT_MOVIE = _mupdf.PDF_ANNOT_MOVIE
PDF_ANNOT_RICH_MEDIA = _mupdf.PDF_ANNOT_RICH_MEDIA
PDF_ANNOT_WIDGET = _mupdf.PDF_ANNOT_WIDGET
PDF_ANNOT_SCREEN = _mupdf.PDF_ANNOT_SCREEN
PDF_ANNOT_PRINTER_MARK = _mupdf.PDF_ANNOT_PRINTER_MARK
PDF_ANNOT_TRAP_NET = _mupdf.PDF_ANNOT_TRAP_NET
PDF_ANNOT_WATERMARK = _mupdf.PDF_ANNOT_WATERMARK
PDF_ANNOT_3D = _mupdf.PDF_ANNOT_3D
PDF_ANNOT_PROJECTION = _mupdf.PDF_ANNOT_PROJECTION
PDF_ANNOT_UNKNOWN = _mupdf.PDF_ANNOT_UNKNOWN
PDF_ANNOT_IS_INVISIBLE = _mupdf.PDF_ANNOT_IS_INVISIBLE
PDF_ANNOT_IS_HIDDEN = _mupdf.PDF_ANNOT_IS_HIDDEN
PDF_ANNOT_IS_PRINT = _mupdf.PDF_ANNOT_IS_PRINT
PDF_ANNOT_IS_NO_ZOOM = _mupdf.PDF_ANNOT_IS_NO_ZOOM
PDF_ANNOT_IS_NO_ROTATE = _mupdf.PDF_ANNOT_IS_NO_ROTATE
PDF_ANNOT_IS_NO_VIEW = _mupdf.PDF_ANNOT_IS_NO_VIEW
PDF_ANNOT_IS_READ_ONLY = _mupdf.PDF_ANNOT_IS_READ_ONLY
PDF_ANNOT_IS_LOCKED = _mupdf.PDF_ANNOT_IS_LOCKED
PDF_ANNOT_IS_TOGGLE_NO_VIEW = _mupdf.PDF_ANNOT_IS_TOGGLE_NO_VIEW
PDF_ANNOT_IS_LOCKED_CONTENTS = _mupdf.PDF_ANNOT_IS_LOCKED_CONTENTS
PDF_ANNOT_LE_NONE = _mupdf.PDF_ANNOT_LE_NONE
PDF_ANNOT_LE_SQUARE = _mupdf.PDF_ANNOT_LE_SQUARE
PDF_ANNOT_LE_CIRCLE = _mupdf.PDF_ANNOT_LE_CIRCLE
PDF_ANNOT_LE_DIAMOND = _mupdf.PDF_ANNOT_LE_DIAMOND
PDF_ANNOT_LE_OPEN_ARROW = _mupdf.PDF_ANNOT_LE_OPEN_ARROW
PDF_ANNOT_LE_CLOSED_ARROW = _mupdf.PDF_ANNOT_LE_CLOSED_ARROW
PDF_ANNOT_LE_BUTT = _mupdf.PDF_ANNOT_LE_BUTT
PDF_ANNOT_LE_R_OPEN_ARROW = _mupdf.PDF_ANNOT_LE_R_OPEN_ARROW
PDF_ANNOT_LE_R_CLOSED_ARROW = _mupdf.PDF_ANNOT_LE_R_CLOSED_ARROW
PDF_ANNOT_LE_SLASH = _mupdf.PDF_ANNOT_LE_SLASH
PDF_ANNOT_Q_LEFT = _mupdf.PDF_ANNOT_Q_LEFT
PDF_ANNOT_Q_CENTER = _mupdf.PDF_ANNOT_Q_CENTER
PDF_ANNOT_Q_RIGHT = _mupdf.PDF_ANNOT_Q_RIGHT
PDF_WIDGET_TYPE_UNKNOWN = _mupdf.PDF_WIDGET_TYPE_UNKNOWN
PDF_WIDGET_TYPE_BUTTON = _mupdf.PDF_WIDGET_TYPE_BUTTON
PDF_WIDGET_TYPE_CHECKBOX = _mupdf.PDF_WIDGET_TYPE_CHECKBOX
PDF_WIDGET_TYPE_COMBOBOX = _mupdf.PDF_WIDGET_TYPE_COMBOBOX
PDF_WIDGET_TYPE_LISTBOX = _mupdf.PDF_WIDGET_TYPE_LISTBOX
PDF_WIDGET_TYPE_RADIOBUTTON = _mupdf.PDF_WIDGET_TYPE_RADIOBUTTON
PDF_WIDGET_TYPE_SIGNATURE = _mupdf.PDF_WIDGET_TYPE_SIGNATURE
PDF_WIDGET_TYPE_TEXT = _mupdf.PDF_WIDGET_TYPE_TEXT
PDF_WIDGET_TX_FORMAT_NONE = _mupdf.PDF_WIDGET_TX_FORMAT_NONE
PDF_WIDGET_TX_FORMAT_NUMBER = _mupdf.PDF_WIDGET_TX_FORMAT_NUMBER
PDF_WIDGET_TX_FORMAT_SPECIAL = _mupdf.PDF_WIDGET_TX_FORMAT_SPECIAL
PDF_WIDGET_TX_FORMAT_DATE = _mupdf.PDF_WIDGET_TX_FORMAT_DATE
PDF_WIDGET_TX_FORMAT_TIME = _mupdf.PDF_WIDGET_TX_FORMAT_TIME
PDF_FIELD_IS_READ_ONLY = _mupdf.PDF_FIELD_IS_READ_ONLY
PDF_FIELD_IS_REQUIRED = _mupdf.PDF_FIELD_IS_REQUIRED
PDF_FIELD_IS_NO_EXPORT = _mupdf.PDF_FIELD_IS_NO_EXPORT
PDF_TX_FIELD_IS_MULTILINE = _mupdf.PDF_TX_FIELD_IS_MULTILINE
PDF_TX_FIELD_IS_PASSWORD = _mupdf.PDF_TX_FIELD_IS_PASSWORD
PDF_TX_FIELD_IS_FILE_SELECT = _mupdf.PDF_TX_FIELD_IS_FILE_SELECT
PDF_TX_FIELD_IS_DO_NOT_SPELL_CHECK = _mupdf.PDF_TX_FIELD_IS_DO_NOT_SPELL_CHECK
PDF_TX_FIELD_IS_DO_NOT_SCROLL = _mupdf.PDF_TX_FIELD_IS_DO_NOT_SCROLL
PDF_TX_FIELD_IS_COMB = _mupdf.PDF_TX_FIELD_IS_COMB
PDF_TX_FIELD_IS_RICH_TEXT = _mupdf.PDF_TX_FIELD_IS_RICH_TEXT
PDF_BTN_FIELD_IS_NO_TOGGLE_TO_OFF = _mupdf.PDF_BTN_FIELD_IS_NO_TOGGLE_TO_OFF
PDF_BTN_FIELD_IS_RADIO = _mupdf.PDF_BTN_FIELD_IS_RADIO
PDF_BTN_FIELD_IS_PUSHBUTTON = _mupdf.PDF_BTN_FIELD_IS_PUSHBUTTON
PDF_BTN_FIELD_IS_RADIOS_IN_UNISON = _mupdf.PDF_BTN_FIELD_IS_RADIOS_IN_UNISON
PDF_CH_FIELD_IS_COMBO = _mupdf.PDF_CH_FIELD_IS_COMBO
PDF_CH_FIELD_IS_EDIT = _mupdf.PDF_CH_FIELD_IS_EDIT
PDF_CH_FIELD_IS_SORT = _mupdf.PDF_CH_FIELD_IS_SORT
PDF_CH_FIELD_IS_MULTI_SELECT = _mupdf.PDF_CH_FIELD_IS_MULTI_SELECT
PDF_CH_FIELD_IS_DO_NOT_SPELL_CHECK = _mupdf.PDF_CH_FIELD_IS_DO_NOT_SPELL_CHECK
PDF_CH_FIELD_IS_COMMIT_ON_SEL_CHANGE = _mupdf.PDF_CH_FIELD_IS_COMMIT_ON_SEL_CHANGE
class pdf_pkcs7_distinguished_name(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    cn = property(_mupdf.pdf_pkcs7_distinguished_name_cn_get, _mupdf.pdf_pkcs7_distinguished_name_cn_set)
    o = property(_mupdf.pdf_pkcs7_distinguished_name_o_get, _mupdf.pdf_pkcs7_distinguished_name_o_set)
    ou = property(_mupdf.pdf_pkcs7_distinguished_name_ou_get, _mupdf.pdf_pkcs7_distinguished_name_ou_set)
    email = property(_mupdf.pdf_pkcs7_distinguished_name_email_get, _mupdf.pdf_pkcs7_distinguished_name_email_set)
    c = property(_mupdf.pdf_pkcs7_distinguished_name_c_get, _mupdf.pdf_pkcs7_distinguished_name_c_set)

    def __init__(self):
        _mupdf.pdf_pkcs7_distinguished_name_swiginit(self, _mupdf.new_pdf_pkcs7_distinguished_name())
    __swig_destroy__ = _mupdf.delete_pdf_pkcs7_distinguished_name

# Register pdf_pkcs7_distinguished_name in _mupdf:
_mupdf.pdf_pkcs7_distinguished_name_swigregister(pdf_pkcs7_distinguished_name)

PDF_SIGNATURE_ERROR_OKAY = _mupdf.PDF_SIGNATURE_ERROR_OKAY
PDF_SIGNATURE_ERROR_NO_SIGNATURES = _mupdf.PDF_SIGNATURE_ERROR_NO_SIGNATURES
PDF_SIGNATURE_ERROR_NO_CERTIFICATE = _mupdf.PDF_SIGNATURE_ERROR_NO_CERTIFICATE
PDF_SIGNATURE_ERROR_DIGEST_FAILURE = _mupdf.PDF_SIGNATURE_ERROR_DIGEST_FAILURE
PDF_SIGNATURE_ERROR_SELF_SIGNED = _mupdf.PDF_SIGNATURE_ERROR_SELF_SIGNED
PDF_SIGNATURE_ERROR_SELF_SIGNED_IN_CHAIN = _mupdf.PDF_SIGNATURE_ERROR_SELF_SIGNED_IN_CHAIN
PDF_SIGNATURE_ERROR_NOT_TRUSTED = _mupdf.PDF_SIGNATURE_ERROR_NOT_TRUSTED
PDF_SIGNATURE_ERROR_UNKNOWN = _mupdf.PDF_SIGNATURE_ERROR_UNKNOWN
class pdf_pkcs7_signer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    keep = property(_mupdf.pdf_pkcs7_signer_keep_get, _mupdf.pdf_pkcs7_signer_keep_set)
    drop = property(_mupdf.pdf_pkcs7_signer_drop_get, _mupdf.pdf_pkcs7_signer_drop_set)
    get_signing_name = property(_mupdf.pdf_pkcs7_signer_get_signing_name_get, _mupdf.pdf_pkcs7_signer_get_signing_name_set)
    max_digest_size = property(_mupdf.pdf_pkcs7_signer_max_digest_size_get, _mupdf.pdf_pkcs7_signer_max_digest_size_set)
    create_digest = property(_mupdf.pdf_pkcs7_signer_create_digest_get, _mupdf.pdf_pkcs7_signer_create_digest_set)

    def __init__(self):
        _mupdf.pdf_pkcs7_signer_swiginit(self, _mupdf.new_pdf_pkcs7_signer())
    __swig_destroy__ = _mupdf.delete_pdf_pkcs7_signer

# Register pdf_pkcs7_signer in _mupdf:
_mupdf.pdf_pkcs7_signer_swigregister(pdf_pkcs7_signer)

class pdf_pkcs7_verifier(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    drop = property(_mupdf.pdf_pkcs7_verifier_drop_get, _mupdf.pdf_pkcs7_verifier_drop_set)
    check_certificate = property(_mupdf.pdf_pkcs7_verifier_check_certificate_get, _mupdf.pdf_pkcs7_verifier_check_certificate_set)
    check_digest = property(_mupdf.pdf_pkcs7_verifier_check_digest_get, _mupdf.pdf_pkcs7_verifier_check_digest_set)
    get_signatory = property(_mupdf.pdf_pkcs7_verifier_get_signatory_get, _mupdf.pdf_pkcs7_verifier_get_signatory_set)

    def __init__(self):
        _mupdf.pdf_pkcs7_verifier_swiginit(self, _mupdf.new_pdf_pkcs7_verifier())
    __swig_destroy__ = _mupdf.delete_pdf_pkcs7_verifier

# Register pdf_pkcs7_verifier in _mupdf:
_mupdf.pdf_pkcs7_verifier_swigregister(pdf_pkcs7_verifier)

PDF_SIGNATURE_SHOW_LABELS = _mupdf.PDF_SIGNATURE_SHOW_LABELS
PDF_SIGNATURE_SHOW_DN = _mupdf.PDF_SIGNATURE_SHOW_DN
PDF_SIGNATURE_SHOW_DATE = _mupdf.PDF_SIGNATURE_SHOW_DATE
PDF_SIGNATURE_SHOW_TEXT_NAME = _mupdf.PDF_SIGNATURE_SHOW_TEXT_NAME
PDF_SIGNATURE_SHOW_GRAPHIC_NAME = _mupdf.PDF_SIGNATURE_SHOW_GRAPHIC_NAME
PDF_SIGNATURE_SHOW_LOGO = _mupdf.PDF_SIGNATURE_SHOW_LOGO
class pdf_keystroke_event(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    value = property(_mupdf.pdf_keystroke_event_value_get, _mupdf.pdf_keystroke_event_value_set)
    change = property(_mupdf.pdf_keystroke_event_change_get, _mupdf.pdf_keystroke_event_change_set)
    selStart = property(_mupdf.pdf_keystroke_event_selStart_get, _mupdf.pdf_keystroke_event_selStart_set)
    selEnd = property(_mupdf.pdf_keystroke_event_selEnd_get, _mupdf.pdf_keystroke_event_selEnd_set)
    willCommit = property(_mupdf.pdf_keystroke_event_willCommit_get, _mupdf.pdf_keystroke_event_willCommit_set)
    newChange = property(_mupdf.pdf_keystroke_event_newChange_get, _mupdf.pdf_keystroke_event_newChange_set)
    newValue = property(_mupdf.pdf_keystroke_event_newValue_get, _mupdf.pdf_keystroke_event_newValue_set)

    def __init__(self):
        _mupdf.pdf_keystroke_event_swiginit(self, _mupdf.new_pdf_keystroke_event())
    __swig_destroy__ = _mupdf.delete_pdf_keystroke_event

# Register pdf_keystroke_event in _mupdf:
_mupdf.pdf_keystroke_event_swigregister(pdf_keystroke_event)

class pdf_doc_event(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    type = property(_mupdf.pdf_doc_event_type_get, _mupdf.pdf_doc_event_type_set)

    def __init__(self):
        _mupdf.pdf_doc_event_swiginit(self, _mupdf.new_pdf_doc_event())
    __swig_destroy__ = _mupdf.delete_pdf_doc_event

# Register pdf_doc_event in _mupdf:
_mupdf.pdf_doc_event_swigregister(pdf_doc_event)

PDF_DOCUMENT_EVENT_ALERT = _mupdf.PDF_DOCUMENT_EVENT_ALERT
PDF_DOCUMENT_EVENT_PRINT = _mupdf.PDF_DOCUMENT_EVENT_PRINT
PDF_DOCUMENT_EVENT_LAUNCH_URL = _mupdf.PDF_DOCUMENT_EVENT_LAUNCH_URL
PDF_DOCUMENT_EVENT_MAIL_DOC = _mupdf.PDF_DOCUMENT_EVENT_MAIL_DOC
PDF_DOCUMENT_EVENT_SUBMIT = _mupdf.PDF_DOCUMENT_EVENT_SUBMIT
PDF_DOCUMENT_EVENT_EXEC_MENU_ITEM = _mupdf.PDF_DOCUMENT_EVENT_EXEC_MENU_ITEM
class pdf_alert_event(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    doc = property(_mupdf.pdf_alert_event_doc_get, _mupdf.pdf_alert_event_doc_set)
    message = property(_mupdf.pdf_alert_event_message_get, _mupdf.pdf_alert_event_message_set)
    icon_type = property(_mupdf.pdf_alert_event_icon_type_get, _mupdf.pdf_alert_event_icon_type_set)
    button_group_type = property(_mupdf.pdf_alert_event_button_group_type_get, _mupdf.pdf_alert_event_button_group_type_set)
    title = property(_mupdf.pdf_alert_event_title_get, _mupdf.pdf_alert_event_title_set)
    check_box_message = property(_mupdf.pdf_alert_event_check_box_message_get, _mupdf.pdf_alert_event_check_box_message_set)
    initially_checked = property(_mupdf.pdf_alert_event_initially_checked_get, _mupdf.pdf_alert_event_initially_checked_set)
    finally_checked = property(_mupdf.pdf_alert_event_finally_checked_get, _mupdf.pdf_alert_event_finally_checked_set)
    button_pressed = property(_mupdf.pdf_alert_event_button_pressed_get, _mupdf.pdf_alert_event_button_pressed_set)

    def __init__(self):
        _mupdf.pdf_alert_event_swiginit(self, _mupdf.new_pdf_alert_event())
    __swig_destroy__ = _mupdf.delete_pdf_alert_event

# Register pdf_alert_event in _mupdf:
_mupdf.pdf_alert_event_swigregister(pdf_alert_event)

PDF_ALERT_ICON_ERROR = _mupdf.PDF_ALERT_ICON_ERROR
PDF_ALERT_ICON_WARNING = _mupdf.PDF_ALERT_ICON_WARNING
PDF_ALERT_ICON_QUESTION = _mupdf.PDF_ALERT_ICON_QUESTION
PDF_ALERT_ICON_STATUS = _mupdf.PDF_ALERT_ICON_STATUS
PDF_ALERT_BUTTON_GROUP_OK = _mupdf.PDF_ALERT_BUTTON_GROUP_OK
PDF_ALERT_BUTTON_GROUP_OK_CANCEL = _mupdf.PDF_ALERT_BUTTON_GROUP_OK_CANCEL
PDF_ALERT_BUTTON_GROUP_YES_NO = _mupdf.PDF_ALERT_BUTTON_GROUP_YES_NO
PDF_ALERT_BUTTON_GROUP_YES_NO_CANCEL = _mupdf.PDF_ALERT_BUTTON_GROUP_YES_NO_CANCEL
PDF_ALERT_BUTTON_NONE = _mupdf.PDF_ALERT_BUTTON_NONE
PDF_ALERT_BUTTON_OK = _mupdf.PDF_ALERT_BUTTON_OK
PDF_ALERT_BUTTON_CANCEL = _mupdf.PDF_ALERT_BUTTON_CANCEL
PDF_ALERT_BUTTON_NO = _mupdf.PDF_ALERT_BUTTON_NO
PDF_ALERT_BUTTON_YES = _mupdf.PDF_ALERT_BUTTON_YES
class pdf_launch_url_event(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    url = property(_mupdf.pdf_launch_url_event_url_get, _mupdf.pdf_launch_url_event_url_set)
    new_frame = property(_mupdf.pdf_launch_url_event_new_frame_get, _mupdf.pdf_launch_url_event_new_frame_set)

    def __init__(self):
        _mupdf.pdf_launch_url_event_swiginit(self, _mupdf.new_pdf_launch_url_event())
    __swig_destroy__ = _mupdf.delete_pdf_launch_url_event

# Register pdf_launch_url_event in _mupdf:
_mupdf.pdf_launch_url_event_swigregister(pdf_launch_url_event)

class pdf_mail_doc_event(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    ask_user = property(_mupdf.pdf_mail_doc_event_ask_user_get, _mupdf.pdf_mail_doc_event_ask_user_set)
    to = property(_mupdf.pdf_mail_doc_event_to_get, _mupdf.pdf_mail_doc_event_to_set)
    cc = property(_mupdf.pdf_mail_doc_event_cc_get, _mupdf.pdf_mail_doc_event_cc_set)
    bcc = property(_mupdf.pdf_mail_doc_event_bcc_get, _mupdf.pdf_mail_doc_event_bcc_set)
    subject = property(_mupdf.pdf_mail_doc_event_subject_get, _mupdf.pdf_mail_doc_event_subject_set)
    message = property(_mupdf.pdf_mail_doc_event_message_get, _mupdf.pdf_mail_doc_event_message_set)

    def __init__(self):
        _mupdf.pdf_mail_doc_event_swiginit(self, _mupdf.new_pdf_mail_doc_event())
    __swig_destroy__ = _mupdf.delete_pdf_mail_doc_event

# Register pdf_mail_doc_event in _mupdf:
_mupdf.pdf_mail_doc_event_swigregister(pdf_mail_doc_event)


def aa_level():
    r"""
    Wrapper for `fz_aa_level()`.
    Get the number of bits of antialiasing we are
    using (for graphics). Between 0 and 8.
    """
    return _mupdf.aa_level()

def absi(i):
    r""" Wrapper for `fz_absi()`."""
    return _mupdf.absi(i)

def add_layout_char(block, x, w, p):
    r"""
    Wrapper for `fz_add_layout_char()`.
    Add a new char to the line at the end of the layout block.
    """
    return _mupdf.add_layout_char(block, x, w, p)

def add_layout_line(block, x, y, h, p):
    r"""
    Wrapper for `fz_add_layout_line()`.
    Add a new line to the end of the layout block.
    """
    return _mupdf.add_layout_line(block, x, y, h, p)

def add_separation(sep, name, cs, cs_channel):
    r"""
    Wrapper for `fz_add_separation()`.
    Add a separation (null terminated name, colorspace)
    """
    return _mupdf.add_separation(sep, name, cs, cs_channel)

def add_separation_equivalents(sep, rgba, cmyk, name):
    r"""
    Wrapper for `fz_add_separation_equivalents()`.
    Add a separation with equivalents (null terminated name,
    colorspace)

    (old, deprecated)
    """
    return _mupdf.add_separation_equivalents(sep, rgba, cmyk, name)

def adjust_rect_for_stroke(rect, stroke, ctm):
    r"""
    Wrapper for `fz_adjust_rect_for_stroke()`.
    Given a rectangle (assumed to be the bounding box for a path),
    expand it to allow for the expansion of the bbox that would be
    seen by stroking the path with the given stroke state and
    transform.
    """
    return _mupdf.adjust_rect_for_stroke(rect, stroke, ctm)

def advance_glyph(font, glyph, wmode):
    r"""
    Wrapper for `fz_advance_glyph()`.
    Return the advance for a given glyph.

    font: The font to look for the glyph in.

    glyph: The glyph to find the advance for.

    wmode: 1 for vertical mode, 0 for horizontal.

    Returns the advance for the glyph.
    """
    return _mupdf.advance_glyph(font, glyph, wmode)

def aes_crypt_cbc(ctx, mode, length, iv, input, output):
    r"""
    Wrapper for `fz_aes_crypt_cbc()`.
    AES block processing. Encrypts or Decrypts (according to mode,
    which must match what was initially set up) length bytes (which
    must be a multiple of 16), using (and modifying) the insertion
    vector iv, reading from input, and writing to output.

    Never throws an exception.
    """
    return _mupdf.aes_crypt_cbc(ctx, mode, length, iv, input, output)

def aes_setkey_dec(ctx, key, keysize):
    r"""
    Wrapper for `fz_aes_setkey_dec()`.
    AES decryption intialisation. Fills in the supplied context
    and prepares for decryption using the given key.

    Returns non-zero for error (key size other than 128/192/256).

    Never throws an exception.
    """
    return _mupdf.aes_setkey_dec(ctx, key, keysize)

def aes_setkey_enc(ctx, key, keysize):
    r"""
    Wrapper for `fz_aes_setkey_enc()`.
    AES encryption intialisation. Fills in the supplied context
    and prepares for encryption using the given key.

    Returns non-zero for error (key size other than 128/192/256).

    Never throws an exception.
    """
    return _mupdf.aes_setkey_enc(ctx, key, keysize)

def alpha_from_gray(gray):
    r""" Wrapper for `fz_alpha_from_gray()`."""
    return _mupdf.alpha_from_gray(gray)

def append_bits(buf, value, count):
    r""" Wrapper for `fz_append_bits()`."""
    return _mupdf.append_bits(buf, value, count)

def append_bits_pad(buf):
    r""" Wrapper for `fz_append_bits_pad()`."""
    return _mupdf.append_bits_pad(buf)

def append_buffer(destination, source):
    r"""
    Wrapper for `fz_append_buffer()`.
    Append the contents of the source buffer onto the end of the
    destination buffer, extending automatically as required.

    Ownership of buffers does not change.
    """
    return _mupdf.append_buffer(destination, source)

def append_byte(buf, c):
    r""" Wrapper for `fz_append_byte()`."""
    return _mupdf.append_byte(buf, c)

def append_data(buf, data, len):
    r"""
    Wrapper for `fz_append_data()`.
    fz_append_*: Append data to a buffer.

    The buffer will automatically grow as required.
    """
    return _mupdf.append_data(buf, data, len)

def append_int16_be(buf, x):
    r""" Wrapper for `fz_append_int16_be()`."""
    return _mupdf.append_int16_be(buf, x)

def append_int16_le(buf, x):
    r""" Wrapper for `fz_append_int16_le()`."""
    return _mupdf.append_int16_le(buf, x)

def append_int32_be(buf, x):
    r""" Wrapper for `fz_append_int32_be()`."""
    return _mupdf.append_int32_be(buf, x)

def append_int32_le(buf, x):
    r""" Wrapper for `fz_append_int32_le()`."""
    return _mupdf.append_int32_le(buf, x)

def append_pdf_string(buffer, text):
    r"""
    Wrapper for `fz_append_pdf_string()`.
    fz_append_pdf_string: Append a string with PDF syntax quotes and
    escapes.

    The buffer will automatically grow as required.
    """
    return _mupdf.append_pdf_string(buffer, text)

def append_rune(buf, c):
    r""" Wrapper for `fz_append_rune()`."""
    return _mupdf.append_rune(buf, c)

def append_string(buf, data):
    r""" Wrapper for `fz_append_string()`."""
    return _mupdf.append_string(buf, data)

def arc4_encrypt(state, dest, src, len):
    r"""
    Wrapper for `fz_arc4_encrypt()`.
    RC4 block encrypt operation; encrypt src into dst (both of
    length len) updating the RC4 state as we go.

    Never throws an exception.
    """
    return _mupdf.arc4_encrypt(state, dest, src, len)

def arc4_init(state, key, len):
    r"""
    Wrapper for `fz_arc4_init()`.
    RC4 initialization. Begins an RC4 operation, writing a new
    context.

    Never throws an exception.
    """
    return _mupdf.arc4_init(state, key, len)

def archive_format(arch):
    r"""
    Wrapper for `fz_archive_format()`.
    Return a pointer to a string describing the format of the
    archive.

    The lifetime of the string is unspecified (in current
    implementations the string will persist until the archive
    is closed, but this is not guaranteed).
    """
    return _mupdf.archive_format(arch)

def atoi64(s):
    r"""
    Wrapper for `fz_atoi64()`.
    64bit atoi that copes with NULL
    """
    return _mupdf.atoi64(s)

def authenticate_password(doc, password):
    r"""
    Wrapper for `fz_authenticate_password()`.
    Test if the given password can decrypt the document.

    password: The password string to be checked. Some document
    specifications do not specify any particular text encoding, so
    neither do we.

    Returns 0 for failure to authenticate, non-zero for success.

    For PDF documents, further information can be given by examining
    the bits in the return code.

    	Bit 0 => No password required
    	Bit 1 => User password authenticated
    	Bit 2 => Owner password authenticated
    """
    return _mupdf.authenticate_password(doc, password)

def available(stm, max):
    r"""
    Wrapper for `fz_available()`.
    Ask how many bytes are available immediately from
    a given stream.

    stm: The stream to read from.

    max: A hint for the underlying stream; the maximum number of
    bytes that we are sure we will want to read. If you do not know
    this number, give 1.

    Returns the number of bytes immediately available between the
    read and write pointers. This number is guaranteed only to be 0
    if we have hit EOF. The number of bytes returned here need have
    no relation to max (could be larger, could be smaller).
    """
    return _mupdf.available(stm, max)

def begin_group(dev, area, cs, isolated, knockout, blendmode, alpha):
    r""" Wrapper for `fz_begin_group()`."""
    return _mupdf.begin_group(dev, area, cs, isolated, knockout, blendmode, alpha)

def begin_layer(dev, layer_name):
    r""" Wrapper for `fz_begin_layer()`."""
    return _mupdf.begin_layer(dev, layer_name)

def begin_mask(dev, area, luminosity, colorspace, bc, color_params):
    r""" Wrapper for `fz_begin_mask()`."""
    return _mupdf.begin_mask(dev, area, luminosity, colorspace, bc, color_params)

def begin_page(wri, mediabox):
    r"""
    Wrapper for `fz_begin_page()`.
    Called to start the process of writing a page to
    a document.

    mediabox: page size rectangle in points.

    Returns a borrowed fz_device to write page contents to. This
    should be kept if required, and only dropped if it was kept.
    """
    return _mupdf.begin_page(wri, mediabox)

def begin_tile(dev, area, view, xstep, ystep, ctm):
    r""" Wrapper for `fz_begin_tile()`."""
    return _mupdf.begin_tile(dev, area, view, xstep, ystep, ctm)

def begin_tile_id(dev, area, view, xstep, ystep, ctm, id):
    r""" Wrapper for `fz_begin_tile_id()`."""
    return _mupdf.begin_tile_id(dev, area, view, xstep, ystep, ctm, id)

def bidi_fragment_text(text, textlen, baseDir, callback, arg, flags):
    r"""
     Wrapper for `fz_bidi_fragment_text()`.
    	Partitions the given Unicode sequence into one or more
    	unidirectional fragments and invokes the given callback
    	function for each fragment.

    	For example, if directionality of text is:
    			0123456789
    			rrlllrrrrr,
    	we'll invoke callback with:
    			&text[0], length == 2
    			&text[2], length == 3
    			&text[5], length == 5

    	:type text: int, in
    :param text:	start of Unicode sequence
        	:type textlen: int, in
    :param textlen:   number of Unicodes to analyse
        	:type baseDir: int, in
    :param baseDir:   direction of paragraph (specify FZ_BIDI_NEUTRAL to force auto-detection)
        	:type callback: fz_bidi_fragment_fn, in
    :param callback:  function to be called for each fragment
        	:type arg: void, in
    :param arg:	data to be passed to the callback function
        	:type flags: int, in
    :param flags:     flags to control operation (see fz_bidi_flags above)
    """
    return _mupdf.bidi_fragment_text(text, textlen, baseDir, callback, arg, flags)

def bitmap_details(bitmap):
    r"""
     Wrapper for `fz_bitmap_details()`.

    This function has out-params. Python/C# wrappers look like:
    	`bitmap_details(fz_bitmap *bitmap)` => `(int w, int h, int n, int stride)`

    	Retrieve details of a given bitmap.

    	bitmap: The bitmap to query.

    	w: Pointer to storage to retrieve width (or NULL).

    	h: Pointer to storage to retrieve height (or NULL).

    	n: Pointer to storage to retrieve number of color components (or
    	NULL).

    	stride: Pointer to storage to retrieve bitmap stride (or NULL).
    """
    return _mupdf.bitmap_details(bitmap)

def blendmode_name(blendmode):
    r"""
    Wrapper for `fz_blendmode_name()`.
    Map from enumeration to blend mode string.

    The string is static, with arbitrary lifespan.
    """
    return _mupdf.blendmode_name(blendmode)

def bound_display_list(list):
    r"""
    Wrapper for `fz_bound_display_list()`.
    Return the bounding box of the page recorded in a display list.
    """
    return _mupdf.bound_display_list(list)

def bound_glyph(font, gid, trm):
    r"""
    Wrapper for `fz_bound_glyph()`.
    Return a bbox for a given glyph in a font.

    font: The font to look for the glyph in.

    gid: The glyph to bound.

    trm: The matrix to apply to the glyph before bounding.

    Returns rectangle by value containing the bounds of the given
    glyph.
    """
    return _mupdf.bound_glyph(font, gid, trm)

def bound_page(page):
    r"""
    Wrapper for `fz_bound_page()`.
    Determine the size of a page at 72 dpi.
    """
    return _mupdf.bound_page(page)

def bound_path(path, stroke, ctm):
    r"""
    Wrapper for `fz_bound_path()`.
    Return a bounding rectangle for a path.

    path: The path to bound.

    stroke: If NULL, the bounding rectangle given is for
    the filled path. If non-NULL the bounding rectangle
    given is for the path stroked with the given attributes.

    ctm: The matrix to apply to the path during stroking.

    r: Pointer to a fz_rect which will be used to hold
    the result.

    Returns r, updated to contain the bounding rectangle.
    """
    return _mupdf.bound_path(path, stroke, ctm)

def bound_shade(shade, ctm):
    r"""
    Wrapper for `fz_bound_shade()`.
    Bound a given shading.

    shade: The shade to bound.

    ctm: The transform to apply to the shade before bounding.

    r: Pointer to storage to put the bounds in.

    Returns r, updated to contain the bounds for the shading.
    """
    return _mupdf.bound_shade(shade, ctm)

def bound_text(text, stroke, ctm):
    r"""
    Wrapper for `fz_bound_text()`.
    Find the bounds of a given text object.

    text: The text object to find the bounds of.

    stroke: Pointer to the stroke attributes (for stroked
    text), or NULL (for filled text).

    ctm: The matrix in use.

    r: pointer to storage for the bounds.

    Returns a pointer to r, which is updated to contain the
    bounding box for the text object.
    """
    return _mupdf.bound_text(text, stroke, ctm)

def buffer_extract(buf, OUTPUT):
    r"""
     Wrapper for `fz_buffer_extract()`.

    This function has out-params. Python/C# wrappers look like:
    	`buffer_extract(fz_buffer *buf)` => `(size_t, unsigned char *data)`

    	Take ownership of buffer contents.

    	Performs the same task as fz_buffer_storage, but ownership of
    	the data buffer returns with this call. The buffer is left
    	empty.

    	Note: Bad things may happen if this is called on a buffer with
    	multiple references that is being used from multiple threads.

    	data: Pointer to place to retrieve data pointer.

    	Returns length of stream.
    """
    return _mupdf.buffer_extract(buf, OUTPUT)

def buffer_storage(buf, OUTPUT):
    r"""
     Wrapper for `fz_buffer_storage()`.

    This function has out-params. Python/C# wrappers look like:
    	`buffer_storage(fz_buffer *buf)` => `(size_t, unsigned char *datap)`

    	Retrieve internal memory of buffer.

    	datap: Output parameter that will be pointed to the data.

    	Returns the current size of the data in bytes.
    """
    return _mupdf.buffer_storage(buf, OUTPUT)

def calloc_no_throw(count, size):
    r"""
    Wrapper for `fz_calloc_no_throw()`.
    fz_calloc equivalent that returns NULL rather than throwing
    exceptions.
    """
    return _mupdf.calloc_no_throw(count, size)

def caught():
    r""" Wrapper for `fz_caught()`."""
    return _mupdf.caught()

def caught_message():
    r""" Wrapper for `fz_caught_message()`."""
    return _mupdf.caught_message()

def chartorune(str):
    r"""
     Wrapper for `fz_chartorune()`.

    This function has out-params. Python/C# wrappers look like:
    	`chartorune(const char *str)` => `(int, int rune)`

    	UTF8 decode a single rune from a sequence of chars.

    	rune: Pointer to an int to assign the decoded 'rune' to.

    	str: Pointer to a UTF8 encoded string.

    	Returns the number of bytes consumed.
    """
    return _mupdf.chartorune(str)

def clamp(f, min, max):
    r""" Wrapper for `fz_clamp()`."""
    return _mupdf.clamp(f, min, max)

def clamp_color(cs, _in):
    r"""
     Wrapper for `fz_clamp_color()`.

    This function has out-params. Python/C# wrappers look like:
    	`clamp_color(fz_colorspace *cs, const float *in)` => float out

    	Clamp the samples in a color to the correct ranges for a
    	given colorspace.
    """
    return _mupdf.clamp_color(cs, _in)

def clamp_location(doc, loc):
    r"""
    Wrapper for `fz_clamp_location()`.
    Clamps a location into valid chapter/page range. (First clamps
    the chapter into range, then the page into range).
    """
    return _mupdf.clamp_location(doc, loc)

def clampd(d, min, max):
    r""" Wrapper for `fz_clampd()`."""
    return _mupdf.clampd(d, min, max)

def clampi(i, min, max):
    r""" Wrapper for `fz_clampi()`."""
    return _mupdf.clampi(i, min, max)

def clampp(p, min, max):
    r""" Wrapper for `fz_clampp()`."""
    return _mupdf.clampp(p, min, max)

def cleanname(name):
    r"""
    Wrapper for `fz_cleanname()`.
    rewrite path to the shortest string that names the same path.

    Eliminates multiple and trailing slashes, interprets "." and
    "..". Overwrites the string in place.
    """
    return _mupdf.cleanname(name)

def clear_bitmap(bit):
    r"""
    Wrapper for `fz_clear_bitmap()`.
    Set the entire bitmap to 0.

    Never throws exceptions.
    """
    return _mupdf.clear_bitmap(bit)

def clear_buffer(buf):
    r"""
    Wrapper for `fz_clear_buffer()`.
    Empties the buffer. Storage is not freed, but is held ready
    to be reused as the buffer is refilled.

    Never throws exceptions.
    """
    return _mupdf.clear_buffer(buf)

def clear_pixmap(pix):
    r"""
    Wrapper for `fz_clear_pixmap()`.
    Sets all components (including alpha) of
    all pixels in a pixmap to 0.

    pix: The pixmap to clear.
    """
    return _mupdf.clear_pixmap(pix)

def clear_pixmap_rect_with_value(pix, value, r):
    r"""
    Wrapper for `fz_clear_pixmap_rect_with_value()`.
    Clears a subrect of a pixmap with the given value.

    pix: The pixmap to clear.

    value: Values in the range 0 to 255 are valid. Each component
    sample for each pixel in the pixmap will be set to this value,
    while alpha will always be set to 255 (non-transparent).

    r: the rectangle.
    """
    return _mupdf.clear_pixmap_rect_with_value(pix, value, r)

def clear_pixmap_with_value(pix, value):
    r"""
    Wrapper for `fz_clear_pixmap_with_value()`.
    Clears a pixmap with the given value.

    pix: The pixmap to clear.

    value: Values in the range 0 to 255 are valid. Each component
    sample for each pixel in the pixmap will be set to this value,
    while alpha will always be set to 255 (non-transparent).

    This function is horrible, and should be removed from the
    API and replaced with a less magic one.
    """
    return _mupdf.clear_pixmap_with_value(pix, value)

def clip_image_mask(dev, image, ctm, scissor):
    r""" Wrapper for `fz_clip_image_mask()`."""
    return _mupdf.clip_image_mask(dev, image, ctm, scissor)

def clip_path(dev, path, even_odd, ctm, scissor):
    r""" Wrapper for `fz_clip_path()`."""
    return _mupdf.clip_path(dev, path, even_odd, ctm, scissor)

def clip_stroke_path(dev, path, stroke, ctm, scissor):
    r""" Wrapper for `fz_clip_stroke_path()`."""
    return _mupdf.clip_stroke_path(dev, path, stroke, ctm, scissor)

def clip_stroke_text(dev, text, stroke, ctm, scissor):
    r""" Wrapper for `fz_clip_stroke_text()`."""
    return _mupdf.clip_stroke_text(dev, text, stroke, ctm, scissor)

def clip_text(dev, text, ctm, scissor):
    r""" Wrapper for `fz_clip_text()`."""
    return _mupdf.clip_text(dev, text, ctm, scissor)

def clone_context():
    r"""
    Wrapper for `fz_clone_context()`.
    Make a clone of an existing context.

    This function is meant to be used in multi-threaded
    applications where each thread requires its own context, yet
    parts of the global state, for example caching, are shared.

    ctx: Context obtained from fz_new_context to make a copy of.
    ctx must have had locks and lock/functions setup when created.
    The two contexts will share the memory allocator, resource
    store, locks and lock/unlock functions. They will each have
    their own exception stacks though.

    May return NULL.
    """
    return _mupdf.clone_context()

def clone_default_colorspaces(base):
    r"""
    Wrapper for `fz_clone_default_colorspaces()`.
    Returns a reference to a newly cloned default colorspaces
    structure.

    The new clone may safely be altered without fear of race
    conditions as the caller is the only reference holder.
    """
    return _mupdf.clone_default_colorspaces(base)

def clone_path(path):
    r"""
    Wrapper for `fz_clone_path()`.
    Clone the data for a path.

    This is used in preference to fz_keep_path when a whole
    new copy of a path is required, rather than just a shared
    pointer. This probably indicates that the path is about to
    be modified.

    path: path to clone.

    Throws exceptions on failure to allocate.
    """
    return _mupdf.clone_path(path)

def clone_pixmap(old):
    r"""
    Wrapper for `fz_clone_pixmap()`.
    Clone a pixmap, copying the pixels and associated data to new
    storage.

    The reference count of 'old' is unchanged.
    """
    return _mupdf.clone_pixmap(old)

def clone_pixmap_area_with_different_seps(src, bbox, dcs, seps, color_params, default_cs):
    r""" Wrapper for `fz_clone_pixmap_area_with_different_seps()`."""
    return _mupdf.clone_pixmap_area_with_different_seps(src, bbox, dcs, seps, color_params, default_cs)

def clone_separations_for_overprint(seps):
    r"""
    Wrapper for `fz_clone_separations_for_overprint()`.
    Return a separations object with all the spots in the input
    separations object that are set to composite, reset to be
    enabled. If there ARE no spots in the object, this returns
    NULL. If the object already has all its spots enabled, then
    just returns another handle on the same object.
    """
    return _mupdf.clone_separations_for_overprint(seps)

def clone_stroke_state(stroke):
    r"""
    Wrapper for `fz_clone_stroke_state()`.
    Create an identical stroke_state structure and return a
    reference to it.

    stroke: The stroke state reference to clone.

    Exceptions may be thrown in the event of a failure to
    allocate.
    """
    return _mupdf.clone_stroke_state(stroke)

def close_band_writer(writer):
    r"""
    Wrapper for `fz_close_band_writer()`.
    Finishes up the output and closes the band writer. After this
    call no more headers or bands may be written.
    """
    return _mupdf.close_band_writer(writer)

def close_device(dev):
    r"""
    Wrapper for `fz_close_device()`.
    Signal the end of input, and flush any buffered output.
    This is NOT called implicitly on fz_drop_device. This
    may throw exceptions.
    """
    return _mupdf.close_device(dev)

def close_document_writer(wri):
    r"""
    Wrapper for `fz_close_document_writer()`.
    Called to end the process of writing
    pages to a document.

    This writes any file level trailers required. After this
    completes successfully the file is up to date and complete.
    """
    return _mupdf.close_document_writer(wri)

def close_output(arg_1):
    r"""
    Wrapper for `fz_close_output()`.
    Flush pending output and close an output stream.
    """
    return _mupdf.close_output(arg_1)

def close_zip_writer(zip):
    r"""
    Wrapper for `fz_close_zip_writer()`.
    Close the zip file for writing.

    This flushes any pending data to the file. This can throw
    exceptions.
    """
    return _mupdf.close_zip_writer(zip)

def closepath(path):
    r"""
    Wrapper for `fz_closepath()`.
    Close the current subpath.

    path: The path to modify.

    Throws exceptions on failure to allocate, attempting to modify
    a packed path, and illegal path closes (i.e. closing a non open
    path).
    """
    return _mupdf.closepath(path)

def colorspace_colorant(cs, n):
    r"""
    Wrapper for `fz_colorspace_colorant()`.
    Retrieve a the name for a colorant.

    Returns a pointer with the same lifespan as the colorspace.
    """
    return _mupdf.colorspace_colorant(cs, n)

def colorspace_device_n_has_cmyk(cs):
    r"""
    Wrapper for `fz_colorspace_device_n_has_cmyk()`.
    True if DeviceN color space has cyan magenta yellow or black as
    one of its colorants.
    """
    return _mupdf.colorspace_device_n_has_cmyk(cs)

def colorspace_device_n_has_only_cmyk(cs):
    r"""
    Wrapper for `fz_colorspace_device_n_has_only_cmyk()`.
    True if DeviceN color space has only colorants from the CMYK set.
    """
    return _mupdf.colorspace_device_n_has_only_cmyk(cs)

def colorspace_is_cmyk(cs):
    r""" Wrapper for `fz_colorspace_is_cmyk()`."""
    return _mupdf.colorspace_is_cmyk(cs)

def colorspace_is_device(cs):
    r""" Wrapper for `fz_colorspace_is_device()`."""
    return _mupdf.colorspace_is_device(cs)

def colorspace_is_device_cmyk(cs):
    r""" Wrapper for `fz_colorspace_is_device_cmyk()`."""
    return _mupdf.colorspace_is_device_cmyk(cs)

def colorspace_is_device_gray(cs):
    r""" Wrapper for `fz_colorspace_is_device_gray()`."""
    return _mupdf.colorspace_is_device_gray(cs)

def colorspace_is_device_n(cs):
    r""" Wrapper for `fz_colorspace_is_device_n()`."""
    return _mupdf.colorspace_is_device_n(cs)

def colorspace_is_gray(cs):
    r"""
    Wrapper for `fz_colorspace_is_gray()`.
    Tests for particular types of colorspaces
    """
    return _mupdf.colorspace_is_gray(cs)

def colorspace_is_indexed(cs):
    r""" Wrapper for `fz_colorspace_is_indexed()`."""
    return _mupdf.colorspace_is_indexed(cs)

def colorspace_is_lab(cs):
    r""" Wrapper for `fz_colorspace_is_lab()`."""
    return _mupdf.colorspace_is_lab(cs)

def colorspace_is_lab_icc(cs):
    r""" Wrapper for `fz_colorspace_is_lab_icc()`."""
    return _mupdf.colorspace_is_lab_icc(cs)

def colorspace_is_rgb(cs):
    r""" Wrapper for `fz_colorspace_is_rgb()`."""
    return _mupdf.colorspace_is_rgb(cs)

def colorspace_is_subtractive(cs):
    r"""
    Wrapper for `fz_colorspace_is_subtractive()`.
    True for CMYK, Separation and DeviceN colorspaces.
    """
    return _mupdf.colorspace_is_subtractive(cs)

def colorspace_n(cs):
    r"""
    Wrapper for `fz_colorspace_n()`.
    Query the number of colorants in a colorspace.
    """
    return _mupdf.colorspace_n(cs)

def colorspace_name(cs):
    r"""
    Wrapper for `fz_colorspace_name()`.
    Query the name of a colorspace.

    The returned string has the same lifespan as the colorspace
    does. Caller should not free it.
    """
    return _mupdf.colorspace_name(cs)

def colorspace_name_colorant(cs, n, name):
    r"""
    Wrapper for `fz_colorspace_name_colorant()`.
    Assign a name for a given colorant in a colorspace.

    Used while initially setting up a colorspace. The string is
    copied into local storage, so need not be retained by the
    caller.
    """
    return _mupdf.colorspace_name_colorant(cs, n, name)

def colorspace_type(cs):
    r"""
    Wrapper for `fz_colorspace_type()`.
    Query the type of colorspace.
    """
    return _mupdf.colorspace_type(cs)

def compress_ccitt_fax_g3(data, columns, rows):
    r"""
    Wrapper for `fz_compress_ccitt_fax_g3()`.
    Compress bitmap data as CCITT Group 3 1D fax image.
    Creates a stream assuming the default PDF parameters,
    except the number of columns.
    """
    return _mupdf.compress_ccitt_fax_g3(data, columns, rows)

def compress_ccitt_fax_g4(data, columns, rows):
    r"""
    Wrapper for `fz_compress_ccitt_fax_g4()`.
    Compress bitmap data as CCITT Group 4 2D fax image.
    Creates a stream assuming the default PDF parameters, except
    K=-1 and the number of columns.
    """
    return _mupdf.compress_ccitt_fax_g4(data, columns, rows)

def compressed_buffer_size(buffer):
    r"""
    Wrapper for `fz_compressed_buffer_size()`.
    Return the storage size used for a buffer and its data.
    Used in implementing store handling.

    Never throws exceptions.
    """
    return _mupdf.compressed_buffer_size(buffer)

def compressed_image_buffer(image):
    r"""
    Wrapper for `fz_compressed_image_buffer()`.
    Retrieve the underlying compressed data for an image.

    Returns a pointer to the underlying data buffer for an image,
    or NULL if this image is not based upon a compressed data
    buffer.

    This is not a reference counted structure, so no reference is
    returned. Lifespan is limited to that of the image itself.
    """
    return _mupdf.compressed_image_buffer(image)

def concat(left, right):
    r"""
    Wrapper for `fz_concat()`.
    Multiply two matrices.

    The order of the two matrices are important since matrix
    multiplication is not commutative.

    Returns result.
    """
    return _mupdf.concat(left, right)

def concat_push_drop(concat, chain):
    r"""
    Wrapper for `fz_concat_push_drop()`.
    Add a chained stream to the end of the concatenate filter.

    Ownership of chain is passed in.
    """
    return _mupdf.concat_push_drop(concat, chain)

def contains_rect(a, b):
    r"""
    Wrapper for `fz_contains_rect()`.
    Test rectangle inclusion.

    Return true if a entirely contains b.
    """
    return _mupdf.contains_rect(a, b)

def convert_color(ss, sv, ds, _is, params):
    r"""
     Wrapper for `fz_convert_color()`.

    This function has out-params. Python/C# wrappers look like:
    	`convert_color(fz_colorspace *ss, const float *sv, fz_colorspace *ds, fz_colorspace *is, fz_color_params params)` => float dv

    	Convert color values sv from colorspace ss into colorvalues dv
    	for colorspace ds, via an optional intervening space is,
    	respecting the given color_params.
    """
    return _mupdf.convert_color(ss, sv, ds, _is, params)

def convert_indexed_pixmap_to_base(src):
    r"""
    Wrapper for `fz_convert_indexed_pixmap_to_base()`.
    Convert pixmap from indexed to base colorspace.

    This creates a new bitmap containing the converted pixmap data.
    """
    return _mupdf.convert_indexed_pixmap_to_base(src)

def convert_pixmap(pix, cs_des, prf, default_cs, color_params, keep_alpha):
    r"""
    Wrapper for `fz_convert_pixmap()`.
    Convert an existing pixmap to a desired
    colorspace. Other properties of the pixmap, such as resolution
    and position are copied to the converted pixmap.

    pix: The pixmap to convert.

    default_cs: If NULL pix->colorspace is used. It is possible that
    the data may need to be interpreted as one of the color spaces
    in default_cs.

    cs_des: Desired colorspace, may be NULL to denote alpha-only.

    prf: Proofing color space through which we need to convert.

    color_params: Parameters that may be used in conversion (e.g.
    ri).

    keep_alpha: If 0 any alpha component is removed, otherwise
    alpha is kept if present in the pixmap.
    """
    return _mupdf.convert_pixmap(pix, cs_des, prf, default_cs, color_params, keep_alpha)

def convert_separation_colors(src_cs, src_color, dst_seps, dst_cs, color_params):
    r"""
     Wrapper for `fz_convert_separation_colors()`.

    This function has out-params. Python/C# wrappers look like:
    	`convert_separation_colors(fz_colorspace *src_cs, const float *src_color, fz_separations *dst_seps, fz_colorspace *dst_cs, fz_color_params color_params)` => float dst_color

    	Convert a color given in terms of one colorspace,
    	to a color in terms of another colorspace/separations.
    """
    return _mupdf.convert_separation_colors(src_cs, src_color, dst_seps, dst_cs, color_params)

def convert_separation_pixmap_to_base(src):
    r"""
    Wrapper for `fz_convert_separation_pixmap_to_base()`.
    Convert pixmap from DeviceN/Separation to base colorspace.

    This creates a new bitmap containing the converted pixmap data.
    """
    return _mupdf.convert_separation_pixmap_to_base(src)

def copy_option(val, dest, maxlen):
    r"""
    Wrapper for `fz_copy_option()`.
    Copy an option (val) into a destination buffer (dest), of maxlen
    bytes.

    Returns the number of bytes (including terminator) that did not
    fit. If val is maxlen or greater bytes in size, it will be left
    unterminated.
    """
    return _mupdf.copy_option(val, dest, maxlen)

def copy_rectangle(page, area, crlf):
    r"""
    Wrapper for `fz_copy_rectangle()`.
    Return a newly allocated UTF-8 string with the text for a given
    selection rectangle.

    crlf: If true, write "\r\n" style line endings (otherwise "\n"
    only).
    """
    return _mupdf.copy_rectangle(page, area, crlf)

def copy_selection(page, a, b, crlf):
    r"""
    Wrapper for `fz_copy_selection()`.
    Return a newly allocated UTF-8 string with the text for a given
    selection.

    crlf: If true, write "\r\n" style line endings (otherwise "\n"
    only).
    """
    return _mupdf.copy_selection(page, a, b, crlf)

def count_active_separations(seps):
    r"""
    Wrapper for `fz_count_active_separations()`.
    Return the number of active separations.
    """
    return _mupdf.count_active_separations(seps)

def count_archive_entries(arch):
    r"""
    Wrapper for `fz_count_archive_entries()`.
    Number of entries in archive.

    Will always return a value >= 0.

    May throw an exception if this type of archive cannot count the
    entries (such as a directory).
    """
    return _mupdf.count_archive_entries(arch)

def count_chapter_pages(doc, chapter):
    r"""
    Wrapper for `fz_count_chapter_pages()`.
    Return the number of pages in a chapter.
    May return 0.
    """
    return _mupdf.count_chapter_pages(doc, chapter)

def count_chapters(doc):
    r"""
    Wrapper for `fz_count_chapters()`.
    Return the number of chapters in the document.
    At least 1.
    """
    return _mupdf.count_chapters(doc)

def count_pages(doc):
    r"""
    Wrapper for `fz_count_pages()`.
    Return the number of pages in document

    May return 0 for documents with no pages.
    """
    return _mupdf.count_pages(doc)

def count_separations(sep):
    r""" Wrapper for `fz_count_separations()`."""
    return _mupdf.count_separations(sep)

def create_link(page, bbox, uri):
    r"""
    Wrapper for `fz_create_link()`.
    Create a new link on a page.
    """
    return _mupdf.create_link(page, bbox, uri)

def currentpoint(path):
    r"""
    Wrapper for `fz_currentpoint()`.
    Return the current point that a path has
    reached or (0,0) if empty.

    path: path to return the current point of.
    """
    return _mupdf.currentpoint(path)

def curveto(path, x0, y0, x1, y1, x2, y2):
    r"""
    Wrapper for `fz_curveto()`.
    Append a 'curveto' command to an open path. (For a
    cubic bezier).

    path: The path to modify.

    x0, y0: The coordinates of the first control point for the
    curve.

    x1, y1: The coordinates of the second control point for the
    curve.

    x2, y2: The end coordinates for the curve.

    Throws exceptions on failure to allocate, or attempting to
    modify a packed path.
    """
    return _mupdf.curveto(path, x0, y0, x1, y1, x2, y2)

def curvetov(path, x1, y1, x2, y2):
    r"""
    Wrapper for `fz_curvetov()`.
    Append a 'curvetov' command to an open path. (For a
    cubic bezier with the first control coordinate equal to
    the start point).

    path: The path to modify.

    x1, y1: The coordinates of the second control point for the
    curve.

    x2, y2: The end coordinates for the curve.

    Throws exceptions on failure to allocate, or attempting to
    modify a packed path.
    """
    return _mupdf.curvetov(path, x1, y1, x2, y2)

def curvetoy(path, x0, y0, x2, y2):
    r"""
    Wrapper for `fz_curvetoy()`.
    Append a 'curvetoy' command to an open path. (For a
    cubic bezier with the second control coordinate equal to
    the end point).

    path: The path to modify.

    x0, y0: The coordinates of the first control point for the
    curve.

    x2, y2: The end coordinates for the curve (and the second
    control coordinate).

    Throws exceptions on failure to allocate, or attempting to
    modify a packed path.
    """
    return _mupdf.curvetoy(path, x0, y0, x2, y2)

def debug_store(out):
    r"""
    Wrapper for `fz_debug_store()`.
    Output debugging information for the current state of the store
    to the given output channel.
    """
    return _mupdf.debug_store(out)

def debug_xml(item, level):
    r"""
    Wrapper for `fz_debug_xml()`.
    Pretty-print an XML tree to stdout.
    """
    return _mupdf.debug_xml(item, level)

def decode_tile(pix, decode):
    r""" Wrapper for `fz_decode_tile()`."""
    return _mupdf.decode_tile(pix, decode)

def decomp_image_from_stream(stm, image, subarea, indexed, l2factor):
    r"""
     Wrapper for `fz_decomp_image_from_stream()`.

    This function has out-params. Python/C# wrappers look like:
    	`decomp_image_from_stream(fz_stream *stm, fz_compressed_image *image, fz_irect *subarea, int indexed, int l2factor)` => `(fz_pixmap *, int l2extra)`

    	Decode a subarea of a compressed image. l2factor is the amount
    	of subsampling inbuilt to the stream (i.e. performed by the
    	decoder). If non NULL, l2extra is the extra amount of
    	subsampling that should be performed by this routine. This will
    	be updated on exit to the amount of subsampling that is still
    	required to be done.
    """
    return _mupdf.decomp_image_from_stream(stm, image, subarea, indexed, l2factor)

def decouple_type3_font(font, t3doc):
    r""" Wrapper for `fz_decouple_type3_font()`."""
    return _mupdf.decouple_type3_font(font, t3doc)

def default_cmyk(default_cs):
    r""" Wrapper for `fz_default_cmyk()`."""
    return _mupdf.default_cmyk(default_cs)

def default_error_callback(user, message):
    r"""
    Wrapper for `fz_default_error_callback()`.
    FIXME: Better not to expose fz_default_error_callback, and
    fz_default_warning callback and to allow 'NULL' to be used
    int fz_set_xxxx_callback to mean "defaults".

    FIXME: Do we need/want functions like
    fz_error_callback(ctx, message) to allow callers to inject
    stuff into the error/warning streams?

    The default error callback. Declared publicly just so that the
    error callback can be set back to this after it has been
    overridden.
    """
    return _mupdf.default_error_callback(user, message)

def default_gray(default_cs):
    r"""
    Wrapper for `fz_default_gray()`.
    Retrieve default colorspaces (typically page local).

    If default_cs is non NULL, the default is retrieved from there,
    otherwise the global default is retrieved.

    These return borrowed references that should not be dropped,
    unless they are kept first.
    """
    return _mupdf.default_gray(default_cs)

def default_halftone(num_comps):
    r"""
    Wrapper for `fz_default_halftone()`.
    Create a 'default' halftone structure
    for the given number of components.

    num_comps: The number of components to use.

    Returns a simple default halftone. The default halftone uses
    the same halftone tile for each plane, which may not be ideal
    for all purposes.
    """
    return _mupdf.default_halftone(num_comps)

def default_output_intent(default_cs):
    r""" Wrapper for `fz_default_output_intent()`."""
    return _mupdf.default_output_intent(default_cs)

def default_rgb(default_cs):
    r""" Wrapper for `fz_default_rgb()`."""
    return _mupdf.default_rgb(default_cs)

def default_warning_callback(user, message):
    r"""
    Wrapper for `fz_default_warning_callback()`.
    The default warning callback. Declared publicly just so that
    the warning callback can be set back to this after it has been
    overridden.
    """
    return _mupdf.default_warning_callback(user, message)

def defer_reap_end():
    r"""
    Wrapper for `fz_defer_reap_end()`.
    Decrement the defer reap count.

    If the defer reap count returns to 0, and the store
    has reapable objects in, a reap pass will begin.

    Call this at the end of a process during which you
    potentially might drop many reapable objects.

    It is vital that every fz_defer_reap_start is matched
    by a fz_defer_reap_end call.
    """
    return _mupdf.defer_reap_end()

def defer_reap_start():
    r"""
    Wrapper for `fz_defer_reap_start()`.
    Increment the defer reap count.

    No reap operations will take place (except for those
    triggered by an immediate failed malloc) until the
    defer reap count returns to 0.

    Call this at the start of a process during which you
    potentially might drop many reapable objects.

    It is vital that every fz_defer_reap_start is matched
    by a fz_defer_reap_end call.
    """
    return _mupdf.defer_reap_start()

def deflate(dest, source, source_length, level):
    r"""
     Wrapper for `fz_deflate()`.

    This function has out-params. Python/C# wrappers look like:
    	`deflate(unsigned char *dest, const unsigned char *source, size_t source_length, fz_deflate_level level)` => size_t compressed_length

    	Compress source_length bytes of data starting
    	at source, into a buffer of length *destLen, starting at dest.
    compressed_length will be updated on exit to contain the size
    	actually used.
    """
    return _mupdf.deflate(dest, source, source_length, level)

def deflate_bound(size):
    r"""
    Wrapper for `fz_deflate_bound()`.
    Returns the upper bound on the
    size of flated data of length size.
    """
    return _mupdf.deflate_bound(size)

def detach_xml(xml, node):
    r"""
    Wrapper for `fz_detach_xml()`.
    Detach a node from the tree, unlinking it from its parent,
    and setting the document root to the node.
    """
    return _mupdf.detach_xml(xml, node)

def device_bgr():
    r""" Wrapper for `fz_device_bgr()`."""
    return _mupdf.device_bgr()

def device_cmyk():
    r""" Wrapper for `fz_device_cmyk()`."""
    return _mupdf.device_cmyk()

def device_current_scissor(dev):
    r"""
    Wrapper for `fz_device_current_scissor()`.
    Find current scissor region as tracked by the device.
    """
    return _mupdf.device_current_scissor(dev)

def device_gray():
    r"""
    Wrapper for `fz_device_gray()`.
    Retrieve global default colorspaces.

    These return borrowed references that should not be dropped,
    unless they are kept first.
    """
    return _mupdf.device_gray()

def device_lab():
    r""" Wrapper for `fz_device_lab()`."""
    return _mupdf.device_lab()

def device_rgb():
    r""" Wrapper for `fz_device_rgb()`."""
    return _mupdf.device_rgb()

def dirname(dir, path, dirsize):
    r"""
    Wrapper for `fz_dirname()`.
    extract the directory component from a path.
    """
    return _mupdf.dirname(dir, path, dirsize)

def disable_device_hints(dev, hints):
    r"""
    Wrapper for `fz_disable_device_hints()`.
    Disable (clear) hint bits within the hint bitfield for a device.
    """
    return _mupdf.disable_device_hints(dev, hints)

def disable_icc():
    r"""
    Wrapper for `fz_disable_icc()`.
    Disable icc profile based operation.
    """
    return _mupdf.disable_icc()

def display_list_is_empty(list):
    r"""
    Wrapper for `fz_display_list_is_empty()`.
    Check for a display list being empty

    list: The list to check.

    Returns true if empty, false otherwise.
    """
    return _mupdf.display_list_is_empty(list)

def div255(c, a):
    r"""
    Wrapper for `fz_div255()`.
    Undo alpha premultiplication.
    """
    return _mupdf.div255(c, a)

def do_always():
    r""" Wrapper for `fz_do_always()`."""
    return _mupdf.do_always()

def do_catch():
    r""" Wrapper for `fz_do_catch()`."""
    return _mupdf.do_catch()

def do_try():
    r""" Wrapper for `fz_do_try()`."""
    return _mupdf.do_try()

def document_output_intent(doc):
    r"""
    Wrapper for `fz_document_output_intent()`.
    Find the output intent colorspace if the document has defined
    one.

    Returns a borrowed reference that should not be dropped, unless
    it is kept first.
    """
    return _mupdf.document_output_intent(doc)

def document_supports_accelerator(doc):
    r"""
    Wrapper for `fz_document_supports_accelerator()`.
    Query if the document supports the saving of accelerator data.
    """
    return _mupdf.document_supports_accelerator(doc)

def drop_archive(arch):
    r"""
    Wrapper for `fz_drop_archive()`.
    Drop the reference to an archive.

    Closes and releases any memory or filehandles associated
    with the archive.
    """
    return _mupdf.drop_archive(arch)

def drop_band_writer(writer):
    r"""
    Wrapper for `fz_drop_band_writer()`.
    Drop the reference to the band writer, causing it to be
    destroyed.

    Never throws an exception.
    """
    return _mupdf.drop_band_writer(writer)

def drop_bitmap(bit):
    r"""
    Wrapper for `fz_drop_bitmap()`.
    Drop a reference to the bitmap. When the reference count reaches
    zero, the bitmap will be destroyed.

    Never throws exceptions.
    """
    return _mupdf.drop_bitmap(bit)

def drop_buffer(buf):
    r"""
    Wrapper for `fz_drop_buffer()`.
    Drop a reference to the buffer. When the reference count reaches
    zero, the buffer is destroyed.

    Never throws exceptions.
    """
    return _mupdf.drop_buffer(buf)

def drop_colorspace(colorspace):
    r"""
    Wrapper for `fz_drop_colorspace()`.
    Drops a reference to the colorspace.

    When the reference count reaches zero, the colorspace is
    destroyed.
    """
    return _mupdf.drop_colorspace(colorspace)

def drop_colorspace_imp(cs_):
    r""" Wrapper for `fz_drop_colorspace_imp()`."""
    return _mupdf.drop_colorspace_imp(cs_)

def drop_compressed_buffer(buf):
    r"""
    Wrapper for `fz_drop_compressed_buffer()`.
    Drop a reference to a compressed buffer. Destroys the buffer
    and frees any storage/other references held by it.

    Never throws exceptions.
    """
    return _mupdf.drop_compressed_buffer(buf)

def drop_context():
    r"""
    Wrapper for `fz_drop_context()`.
    Free a context and its global state.

    The context and all of its global state is freed, and any
    buffered warnings are flushed (see fz_flush_warnings). If NULL
    is passed in nothing will happen.

    Must not be called for a context that is being used in an active
    fz_try(), fz_always() or fz_catch() block.
    """
    return _mupdf.drop_context()

def drop_default_colorspaces(default_cs):
    r"""
    Wrapper for `fz_drop_default_colorspaces()`.
    Drop a reference to the default colorspaces structure. When the
    reference count reaches 0, the references it holds internally
    to the underlying colorspaces will be dropped, and the structure
    will be destroyed.

    Never throws exceptions.
    """
    return _mupdf.drop_default_colorspaces(default_cs)

def drop_device(dev):
    r"""
    Wrapper for `fz_drop_device()`.
    Reduce the reference count on a device. When the reference count
    reaches zero, the device and its resources will be freed.
    Don't forget to call fz_close_device before dropping the device,
    or you may get incomplete output!

    Never throws exceptions.
    """
    return _mupdf.drop_device(dev)

def drop_display_list(list):
    r"""
    Wrapper for `fz_drop_display_list()`.
    Decrement the reference count for a display list. When the
    reference count reaches zero, all the references in the display
    list itself are dropped, and the display list is freed.

    Never throws exceptions.
    """
    return _mupdf.drop_display_list(list)

def drop_document(doc):
    r"""
    Wrapper for `fz_drop_document()`.
    Decrement the document reference count. When the reference
    count reaches 0, the document and all it's references are
    freed.

    Never throws exceptions.
    """
    return _mupdf.drop_document(doc)

def drop_document_writer(wri):
    r"""
    Wrapper for `fz_drop_document_writer()`.
    Called to discard a fz_document_writer.
    This may be called at any time during the process to release all
    the resources owned by the writer.

    Calling drop without having previously called close may leave
    the file in an inconsistent state.
    """
    return _mupdf.drop_document_writer(wri)

def drop_font(font):
    r"""
    Wrapper for `fz_drop_font()`.
    Drop a reference to a fz_font, destroying the
    font when the last reference is dropped.

    font: The font to drop a reference to.
    """
    return _mupdf.drop_font(font)

def drop_glyph(pix):
    r"""
    Wrapper for `fz_drop_glyph()`.
    Drop a reference and free a glyph.

    Decrement the reference count for the glyph. When no
    references remain the glyph will be freed.
    """
    return _mupdf.drop_glyph(pix)

def drop_halftone(ht):
    r"""
    Wrapper for `fz_drop_halftone()`.
    Drop a reference to the halftone. When the reference count
    reaches zero, the halftone is destroyed.

    Never throws exceptions.
    """
    return _mupdf.drop_halftone(ht)

def drop_hash_table(table):
    r"""
    Wrapper for `fz_drop_hash_table()`.
    Destroy the hash table.

    Values are dropped using the drop function.
    """
    return _mupdf.drop_hash_table(table)

def drop_image(image):
    r"""
    Wrapper for `fz_drop_image()`.
    Decrement the (normal) reference count for an image. When the
    total (normal + key) reference count reaches zero, the image and
    its resources are freed.

    Never throws exceptions.
    """
    return _mupdf.drop_image(image)

def drop_image_base(image):
    r"""
    Wrapper for `fz_drop_image_base()`.
    Internal destructor for the base image class members.

    Exposed to allow derived image classes to be written.
    """
    return _mupdf.drop_image_base(image)

def drop_image_imp(image):
    r"""
    Wrapper for `fz_drop_image_imp()`.
    Internal destructor exposed for fz_store integration.
    """
    return _mupdf.drop_image_imp(image)

def drop_image_store_key(image):
    r"""
    Wrapper for `fz_drop_image_store_key()`.
    Decrement the store key reference count for an image. When the
    total (normal + key) reference count reaches zero, the image and
    its resources are freed.

    Never throws exceptions.
    """
    return _mupdf.drop_image_store_key(image)

def drop_imp(p):
    r"""
     Wrapper for `fz_drop_imp()`.

    This function has out-params. Python/C# wrappers look like:
    	`drop_imp(void *p)` => `(int, int refs)`
    """
    return _mupdf.drop_imp(p)

def drop_imp16(p):
    r"""
     Wrapper for `fz_drop_imp16()`.

    This function has out-params. Python/C# wrappers look like:
    	`drop_imp16(void *p)` => `(int, int16_t refs)`
    """
    return _mupdf.drop_imp16(p)

def drop_imp8(p, refs):
    r""" Wrapper for `fz_drop_imp8()`."""
    return _mupdf.drop_imp8(p, refs)

def drop_jbig2_globals(globals):
    r"""
    Wrapper for `fz_drop_jbig2_globals()`.
    Decrement the reference count for a jbig2 globals record.
    When the reference count hits zero, the record is freed.

    Never throws an exception.
    """
    return _mupdf.drop_jbig2_globals(globals)

def drop_jbig2_globals_imp(globals):
    r"""
    Wrapper for `fz_drop_jbig2_globals_imp()`.
    Special jbig2 globals drop function for use in implementing
    store support.
    """
    return _mupdf.drop_jbig2_globals_imp(globals)

def drop_key_storable(arg_1):
    r"""
    Wrapper for `fz_drop_key_storable()`.
    Decrement the (normal) reference count for a storable object.
    When the total reference count hits zero, the drop function for
    that object is called to free the object.

    Never throws exceptions.
    """
    return _mupdf.drop_key_storable(arg_1)

def drop_key_storable_key(arg_1):
    r"""
    Wrapper for `fz_drop_key_storable_key()`.
    Decrement the (key) reference count for a storable object.
    When the total reference count hits zero, the drop function for
    that object is called to free the object.

    Never throws exceptions.
    """
    return _mupdf.drop_key_storable_key(arg_1)

def drop_layout(block):
    r"""
    Wrapper for `fz_drop_layout()`.
    Drop layout block. Free the pool, and linked blocks.

    Never throws exceptions.
    """
    return _mupdf.drop_layout(block)

def drop_link(link):
    r"""
    Wrapper for `fz_drop_link()`.
    Decrement the reference count for a link. When the reference
    count reaches zero, the link is destroyed.

    When a link is freed, the reference for any linked link (next)
    is dropped too, thus an entire linked list of fz_link's can be
    freed by just dropping the head.
    """
    return _mupdf.drop_link(link)

def drop_outline(outline):
    r"""
    Wrapper for `fz_drop_outline()`.
    Decrements the reference count. When the reference point
    reaches zero, the outline is freed.

    When freed, it will drop linked	outline entries (next and down)
    too, thus a whole outline structure can be dropped by dropping
    the top entry.

    Never throws exceptions.
    """
    return _mupdf.drop_outline(outline)

def drop_outline_iterator(iter):
    r"""
    Wrapper for `fz_drop_outline_iterator()`.
    Drop the current iterator.
    """
    return _mupdf.drop_outline_iterator(iter)

def drop_output(arg_1):
    r"""
    Wrapper for `fz_drop_output()`.
    Free an output stream. Don't forget to close it first!
    """
    return _mupdf.drop_output(arg_1)

def drop_page(page):
    r"""
    Wrapper for `fz_drop_page()`.
    Decrements the reference count for the page. When the reference
    count hits 0, the page and its references are freed.

    Never throws exceptions.
    """
    return _mupdf.drop_page(page)

def drop_path(path):
    r"""
    Wrapper for `fz_drop_path()`.
    Decrement the reference count. When the reference count hits
    zero, free the path.

    All paths can be dropped, regardless of their packing type.
    Packed paths do not own the blocks into which they are packed
    so dropping them does not free those blocks.

    Never throws exceptions.
    """
    return _mupdf.drop_path(path)

def drop_pixmap(pix):
    r"""
    Wrapper for `fz_drop_pixmap()`.
    Decrement the reference count for the pixmap. When the
    reference count hits 0, the pixmap is freed.

    Never throws exceptions.
    """
    return _mupdf.drop_pixmap(pix)

def drop_pool(pool):
    r"""
    Wrapper for `fz_drop_pool()`.
    Drop a pool, freeing and invalidating all storage returned from
    the pool.
    """
    return _mupdf.drop_pool(pool)

def drop_separations(sep):
    r"""
    Wrapper for `fz_drop_separations()`.
    Decrement the reference count for a separations structure.
    When the reference count hits zero, the separations structure
    is freed.

    Never throws exceptions.
    """
    return _mupdf.drop_separations(sep)

def drop_shade(shade):
    r"""
    Wrapper for `fz_drop_shade()`.
    Decrement the reference count for the shade structure. When
    the reference count hits zero, the structure is freed.

    Never throws exceptions.
    """
    return _mupdf.drop_shade(shade)

def drop_shade_color_cache(cache):
    r""" Wrapper for `fz_drop_shade_color_cache()`."""
    return _mupdf.drop_shade_color_cache(cache)

def drop_shade_imp(shade):
    r"""
    Wrapper for `fz_drop_shade_imp()`.
    Internal function to destroy a
    shade. Only exposed for use with the fz_store.

    shade: The reference to destroy.
    """
    return _mupdf.drop_shade_imp(shade)

def drop_stext_page(page):
    r""" Wrapper for `fz_drop_stext_page()`."""
    return _mupdf.drop_stext_page(page)

def drop_storable(arg_1):
    r"""
    Wrapper for `fz_drop_storable()`.
    Decrement the reference count for a storable object. When the
    reference count hits zero, the drop function for that object
    is called to free the object.

    Never throws exceptions.
    """
    return _mupdf.drop_storable(arg_1)

def drop_store_context():
    r"""
    Wrapper for `fz_drop_store_context()`.
    Decrement the reference count for the store context. When the
    reference count hits zero, the store context is freed.

    Never throws exceptions.
    """
    return _mupdf.drop_store_context()

def drop_stream(stm):
    r"""
    Wrapper for `fz_drop_stream()`.
    Decrements the reference count for a stream.

    When the reference count for the stream hits zero, frees the
    storage used for the fz_stream itself, and (usually)
    releases the underlying resources that the stream is based upon
    (depends on the method used to open the stream initially).
    """
    return _mupdf.drop_stream(stm)

def drop_stroke_state(stroke):
    r"""
    Wrapper for `fz_drop_stroke_state()`.
    Drop a reference to a stroke state structure, destroying the
    structure if it is the last reference.
    """
    return _mupdf.drop_stroke_state(stroke)

def drop_text(text):
    r"""
    Wrapper for `fz_drop_text()`.
    Decrement the reference count for the text object. When the
    reference count hits zero, the text object is freed.

    Never throws exceptions.
    """
    return _mupdf.drop_text(text)

def drop_tree(node, dropfunc):
    r"""
    Wrapper for `fz_drop_tree()`.
    Drop the tree.

    The storage used by the tree is freed, and each value has
    dropfunc called on it.
    """
    return _mupdf.drop_tree(node, dropfunc)

def drop_xml(xml):
    r"""
    Wrapper for `fz_drop_xml()`.
    Free the XML node and all its children and siblings.
    """
    return _mupdf.drop_xml(xml)

def drop_zip_writer(zip):
    r"""
    Wrapper for `fz_drop_zip_writer()`.
    Drop the reference to the zipfile.

    In common with other 'drop' methods, this will never throw an
    exception.
    """
    return _mupdf.drop_zip_writer(zip)

def dump_glyph_cache_stats(out):
    r"""
    Wrapper for `fz_dump_glyph_cache_stats()`.
    Dump debug statistics for the glyph cache.
    """
    return _mupdf.dump_glyph_cache_stats(out)

def duplicate_glyph_names_from_unicode(unicode):
    r""" Wrapper for `fz_duplicate_glyph_names_from_unicode()`."""
    return _mupdf.duplicate_glyph_names_from_unicode(unicode)

def empty_store():
    r"""
    Wrapper for `fz_empty_store()`.
    Evict every item from the store.
    """
    return _mupdf.empty_store()

def enable_device_hints(dev, hints):
    r"""
    Wrapper for `fz_enable_device_hints()`.
    Enable (set) hint bits within the hint bitfield for a device.
    """
    return _mupdf.enable_device_hints(dev, hints)

def enable_icc():
    r"""
    Wrapper for `fz_enable_icc()`.
    Enable icc profile based operation.
    """
    return _mupdf.enable_icc()

def encode_character(font, unicode):
    r"""
    Wrapper for `fz_encode_character()`.
    Find the glyph id for a given unicode
    character within a font.

    font: The font to look for the unicode character in.

    unicode: The unicode character to encode.

    Returns the glyph id for the given unicode value, or 0 if
    unknown.
    """
    return _mupdf.encode_character(font, unicode)

def encode_character_by_glyph_name(font, glyphname):
    r"""
    Wrapper for `fz_encode_character_by_glyph_name()`.
    Encode character.

    Either by direct lookup of glyphname within a font, or, failing
    that, by mapping glyphname to unicode and thence to the glyph
    index within the given font.

    Returns zero for type3 fonts.
    """
    return _mupdf.encode_character_by_glyph_name(font, glyphname)

def encode_character_sc(font, unicode):
    r"""
    Wrapper for `fz_encode_character_sc()`.
    Encode character, preferring small-caps variant if available.

    font: The font to look for the unicode character in.

    unicode: The unicode character to encode.

    Returns the glyph id for the given unicode value, or 0 if
    unknown.
    """
    return _mupdf.encode_character_sc(font, unicode)

def encode_character_with_fallback(font, unicode, script, language, OUTPUT):
    r"""
     Wrapper for `fz_encode_character_with_fallback()`.

    This function has out-params. Python/C# wrappers look like:
    	`encode_character_with_fallback(fz_font *font, int unicode, int script, int language, fz_font **out_font)` => `(int)`

    	Find the glyph id for
    	a given unicode character within a font, falling back to
    	an alternative if not found.

    	font: The font to look for the unicode character in.

    	unicode: The unicode character to encode.

    	script: The script in use.

    	language: The language in use.

    	out_font: The font handle in which the given glyph represents
    	the requested unicode character. The caller does not own the
    	reference it is passed, so should call fz_keep_font if it is
    	not simply to be used immediately.

    	Returns the glyph id for the given unicode value in the supplied
    	font (and sets *out_font to font) if it is present. Otherwise
    	an alternative fallback font (based on script/language) is
    	searched for. If the glyph is found therein, *out_font is set
    	to this reference, and the glyph reference is returned. If it
    	cannot be found anywhere, the function returns 0.
    """
    return _mupdf.encode_character_with_fallback(font, unicode, script, language, OUTPUT)

def end_group(dev):
    r""" Wrapper for `fz_end_group()`."""
    return _mupdf.end_group(dev)

def end_layer(dev):
    r""" Wrapper for `fz_end_layer()`."""
    return _mupdf.end_layer(dev)

def end_mask(dev):
    r""" Wrapper for `fz_end_mask()`."""
    return _mupdf.end_mask(dev)

def end_page(wri):
    r"""
    Wrapper for `fz_end_page()`.
    Called to end the process of writing a page to a
    document.
    """
    return _mupdf.end_page(wri)

def end_throw_on_repair():
    r""" Wrapper for `fz_end_throw_on_repair()`."""
    return _mupdf.end_throw_on_repair()

def end_tile(dev):
    r""" Wrapper for `fz_end_tile()`."""
    return _mupdf.end_tile(dev)

def error_callback(OUTPUT):
    r"""
     Wrapper for `fz_error_callback()`.

    This function has out-params. Python/C# wrappers look like:
    	`error_callback()` => `(fz_error_cb *, void *user)`

    	Retrieve the currently set error callback, or NULL if none
    	has been set. Optionally, if user is non-NULL, the user pointer
    	given when the warning callback was set is also passed back to
    	the caller.
    """
    return _mupdf.error_callback(OUTPUT)

def expand_irect(a, expand):
    r""" Wrapper for `fz_expand_irect()`."""
    return _mupdf.expand_irect(a, expand)

def expand_rect(b, expand):
    r"""
    Wrapper for `fz_expand_rect()`.
    Expand a bbox by a given amount in all directions.
    """
    return _mupdf.expand_rect(b, expand)

def file_exists(path):
    r"""
    Wrapper for `fz_file_exists()`.
    Return true if the named file exists and is readable.
    """
    return _mupdf.file_exists(path)

def fill_image(dev, image, ctm, alpha, color_params):
    r""" Wrapper for `fz_fill_image()`."""
    return _mupdf.fill_image(dev, image, ctm, alpha, color_params)

def fill_image_mask(dev, image, ctm, colorspace, color, alpha, color_params):
    r""" Wrapper for `fz_fill_image_mask()`."""
    return _mupdf.fill_image_mask(dev, image, ctm, colorspace, color, alpha, color_params)

def fill_path(dev, path, even_odd, ctm, colorspace, color, alpha, color_params):
    r"""
    Wrapper for `fz_fill_path()`.
    Device calls; graphics primitives and containers.
    """
    return _mupdf.fill_path(dev, path, even_odd, ctm, colorspace, color, alpha, color_params)

def fill_pixmap_with_color(pix, colorspace, color_params):
    r"""
     Wrapper for `fz_fill_pixmap_with_color()`.

    This function has out-params. Python/C# wrappers look like:
    	`fill_pixmap_with_color(fz_pixmap *pix, fz_colorspace *colorspace, fz_color_params color_params)` => float color

    	Fill pixmap with solid color.
    """
    return _mupdf.fill_pixmap_with_color(pix, colorspace, color_params)

def fill_shade(dev, shade, ctm, alpha, color_params):
    r""" Wrapper for `fz_fill_shade()`."""
    return _mupdf.fill_shade(dev, shade, ctm, alpha, color_params)

def fill_text(dev, text, ctm, colorspace, color, alpha, color_params):
    r""" Wrapper for `fz_fill_text()`."""
    return _mupdf.fill_text(dev, text, ctm, colorspace, color, alpha, color_params)

def filter_store(fn, arg, type):
    r"""
    Wrapper for `fz_filter_store()`.
    Filter every element in the store with a matching type with the
    given function.

    If the function returns 1 for an element, drop the element.
    """
    return _mupdf.filter_store(fn, arg, type)

def find_item(drop, key, type):
    r"""
    Wrapper for `fz_find_item()`.
    Find an item within the store.

    drop: The function used to free the value (to ensure we get a
    value of the correct type).

    key: The key used to index the item.

    type: Functions used to manipulate the key.

    Returns NULL for not found, otherwise returns a pointer to the
    value indexed by key to which a reference has been taken.
    """
    return _mupdf.find_item(drop, key, type)

def flush_output(out):
    r"""
    Wrapper for `fz_flush_output()`.
    Flush unwritten data.
    """
    return _mupdf.flush_output(out)

def flush_warnings():
    r"""
    Wrapper for `fz_flush_warnings()`.
    Flush any repeated warnings.

    Repeated warnings are buffered, counted and eventually printed
    along with the number of repetitions. Call fz_flush_warnings
    to force printing of the latest buffered warning and the
    number of repetitions, for example to make sure that all
    warnings are printed before exiting an application.
    """
    return _mupdf.flush_warnings()

def font_ascender(font):
    r"""
    Wrapper for `fz_font_ascender()`.
    Retrieve font ascender in ems.
    """
    return _mupdf.font_ascender(font)

def font_bbox(font):
    r"""
    Wrapper for `fz_font_bbox()`.
    Retrieve the font bbox.

    font: The font to query.

    Returns the font bbox by value; it is valid only if
    fz_font_flags(font)->invalid_bbox is zero.
    """
    return _mupdf.font_bbox(font)

def font_descender(font):
    r"""
    Wrapper for `fz_font_descender()`.
    Retrieve font descender in ems.
    """
    return _mupdf.font_descender(font)

def font_digest(font, digest):
    r"""
    Wrapper for `fz_font_digest()`.
    Retrieve the MD5 digest for the font's data.
    """
    return _mupdf.font_digest(font, digest)

def font_flags(font):
    r"""
    Wrapper for `fz_font_flags()`.
    Retrieve a pointer to the font flags
    for a given font. These can then be updated as required.

    font: The font to query

    Returns a pointer to the flags structure (or NULL, if
    the font is NULL).
    """
    return _mupdf.font_flags(font)

def font_ft_face(font):
    r"""
    Wrapper for `fz_font_ft_face()`.
    Retrieve the FT_Face handle
    for the font.

    font: The font to query

    Returns the FT_Face handle for the font, or NULL
    if not a freetype handled font. (Cast to void *
    to avoid nasty header exposure).
    """
    return _mupdf.font_ft_face(font)

def font_is_bold(font):
    r"""
    Wrapper for `fz_font_is_bold()`.
    Query whether the font flags say that this font is bold.
    """
    return _mupdf.font_is_bold(font)

def font_is_italic(font):
    r"""
    Wrapper for `fz_font_is_italic()`.
    Query whether the font flags say that this font is italic.
    """
    return _mupdf.font_is_italic(font)

def font_is_monospaced(font):
    r"""
    Wrapper for `fz_font_is_monospaced()`.
    Query whether the font flags say that this font is monospaced.
    """
    return _mupdf.font_is_monospaced(font)

def font_is_serif(font):
    r"""
    Wrapper for `fz_font_is_serif()`.
    Query whether the font flags say that this font is serif.
    """
    return _mupdf.font_is_serif(font)

def font_name(font):
    r"""
    Wrapper for `fz_font_name()`.
    Retrieve a pointer to the name of the font.

    font: The font to query.

    Returns a pointer to an internal copy of the font name.
    Will never be NULL, but may be the empty string.
    """
    return _mupdf.font_name(font)

def font_shaper_data(font):
    r"""
    Wrapper for `fz_font_shaper_data()`.
    Retrieve a pointer to the shaper data
    structure for the given font.

    font: The font to query.

    Returns a pointer to the shaper data structure (or NULL if
    font is NULL).
    """
    return _mupdf.font_shaper_data(font)

def font_t3_procs(font):
    r"""
    Wrapper for `fz_font_t3_procs()`.
    Retrieve the Type3 procs
    for a font.

    font: The font to query

    Returns the t3_procs pointer. Will be NULL for a
    non type-3 font.
    """
    return _mupdf.font_t3_procs(font)

def format_link_uri(doc, dest):
    r"""
    Wrapper for `fz_format_link_uri()`.
    Format an internal link to a page number, location, and possible viewing parameters,
    suitable for use with fz_create_link.

    Returns a newly allocated string that the caller must free.
    """
    return _mupdf.format_link_uri(doc, dest)

def format_output_path(path, size, fmt, page):
    r"""
    Wrapper for `fz_format_output_path()`.
    create output file name using a template.

    If the path contains %[0-9]*d, the first such pattern will be
    replaced with the page number. If the template does not contain
    such a pattern, the page number will be inserted before the
    filename extension. If the template does not have a filename
    extension, the page number will be added to the end.
    """
    return _mupdf.format_output_path(path, size, fmt, page)

def gamma_pixmap(pix, gamma):
    r"""
    Wrapper for `fz_gamma_pixmap()`.
    Apply gamma correction to a pixmap. All components
    of all pixels are modified (except alpha, which is unchanged).

    gamma: The gamma value to apply; 1.0 for no change.
    """
    return _mupdf.gamma_pixmap(pix, gamma)

def generate_transition(tpix, opix, npix, time, trans):
    r"""
    Wrapper for `fz_generate_transition()`.
    Generate a frame of a transition.

    tpix: Target pixmap
    opix: Old pixmap
    npix: New pixmap
    time: Position within the transition (0 to 256)
    trans: Transition details

    Returns 1 if successfully generated a frame.

    Note: Pixmaps must include alpha.
    """
    return _mupdf.generate_transition(tpix, opix, npix, time, trans)

def get_glyph_name(font, glyph, buf, size):
    r"""
    Wrapper for `fz_get_glyph_name()`.
    Find the name of a glyph

    font: The font to look for the glyph in.

    glyph: The glyph id to look for.

    buf: Pointer to a buffer for the name to be inserted into.

    size: The size of the buffer.

    If a font contains a name table, then the name of the glyph
    will be returned in the supplied buffer. Otherwise a name
    is synthesised. The name will be truncated to fit in
    the buffer.
    """
    return _mupdf.get_glyph_name(font, glyph, buf, size)

def get_pixmap_from_image(image, subarea, ctm):
    r"""
     Wrapper for `fz_get_pixmap_from_image()`.

    This function has out-params. Python/C# wrappers look like:
    	`get_pixmap_from_image(fz_image *image, const fz_irect *subarea, fz_matrix *ctm)` => `(fz_pixmap *, int w, int h)`

    	Called to get a handle to a pixmap from an image.

    	image: The image to retrieve a pixmap from.

    	subarea: The subarea of the image that we actually care about
    	(or NULL to indicate the whole image).

    	ctm: Optional, unless subarea is given. If given, then on
    	entry this is the transform that will be applied to the complete
    	image. It should be updated on exit to the transform to apply to
    	the given subarea of the image. This is used to calculate the
    	desired width/height for subsampling.

    	w: If non-NULL, a pointer to an int to be updated on exit to the
    	width (in pixels) that the scaled output will cover.

    	h: If non-NULL, a pointer to an int to be updated on exit to the
    	height (in pixels) that the scaled output will cover.

    	Returns a non NULL pixmap pointer. May throw exceptions.
    """
    return _mupdf.get_pixmap_from_image(image, subarea, ctm)

def get_unscaled_pixmap_from_image(image):
    r"""
    Wrapper for `fz_get_unscaled_pixmap_from_image()`.
    Calls fz_get_pixmap_from_image() with ctm, subarea, w and h all set to NULL.
    """
    return _mupdf.get_unscaled_pixmap_from_image(image)

def getopt(nargc, ostr):
    r"""
     Wrapper for `fz_getopt()`.

    This function has out-params. Python/C# wrappers look like:
    	`getopt(int nargc, const char *ostr)` => `(int, char *nargv)`

    	Simple functions/variables for use in tools.
    """
    return _mupdf.getopt(nargc, ostr)

def glyph_bbox(glyph):
    r"""
    Wrapper for `fz_glyph_bbox()`.
    Return the bounding box of the glyph in pixels.
    """
    return _mupdf.glyph_bbox(glyph)

def glyph_bbox_no_ctx(src):
    r""" Wrapper for `fz_glyph_bbox_no_ctx()`."""
    return _mupdf.glyph_bbox_no_ctx(src)

def glyph_cacheable(font, gid):
    r"""
    Wrapper for `fz_glyph_cacheable()`.
    Determine if a given glyph in a font
    is cacheable. Certain glyphs in a type 3 font cannot safely
    be cached, as their appearance depends on the enclosing
    graphic state.

    font: The font to look for the glyph in.

    gif: The glyph to query.

    Returns non-zero if cacheable, 0 if not.
    """
    return _mupdf.glyph_cacheable(font, gid)

def glyph_height(glyph):
    r"""
    Wrapper for `fz_glyph_height()`.
    Return the height of the glyph in pixels.
    """
    return _mupdf.glyph_height(glyph)

def glyph_name_from_unicode_sc(unicode):
    r""" Wrapper for `fz_glyph_name_from_unicode_sc()`."""
    return _mupdf.glyph_name_from_unicode_sc(unicode)

def glyph_width(glyph):
    r"""
    Wrapper for `fz_glyph_width()`.
    Return the width of the glyph in pixels.
    """
    return _mupdf.glyph_width(glyph)

def graphics_aa_level():
    r"""
    Wrapper for `fz_graphics_aa_level()`.
    Get the number of bits of antialiasing we are
    using for graphics. Between 0 and 8.
    """
    return _mupdf.graphics_aa_level()

def graphics_min_line_width():
    r"""
    Wrapper for `fz_graphics_min_line_width()`.
    Get the minimum line width to be
    used for stroked lines.

    min_line_width: The minimum line width to use (in pixels).
    """
    return _mupdf.graphics_min_line_width()

def gridfit_matrix(as_tiled, m):
    r"""
    Wrapper for `fz_gridfit_matrix()`.
    Grid fit a matrix.

    as_tiled = 0 => adjust the matrix so that the image of the unit
    square completely covers any pixel that was touched by the
    image of the unit square under the original matrix.

    as_tiled = 1 => adjust the matrix so that the corners of the
    image of the unit square align with the closest integer corner
    of the image of the unit square under the original matrix.
    """
    return _mupdf.gridfit_matrix(as_tiled, m)

def grisu(f, s):
    r"""
     Wrapper for `fz_grisu()`.

    This function has out-params. Python/C# wrappers look like:
    	`grisu(float f, char *s)` => `(int, int exp)`
    """
    return _mupdf.grisu(f, s)

def grow_buffer(buf):
    r"""
    Wrapper for `fz_grow_buffer()`.
    Make some space within a buffer (i.e. ensure that
    capacity > size).
    """
    return _mupdf.grow_buffer(buf)

def has_archive_entry(arch, name):
    r"""
    Wrapper for `fz_has_archive_entry()`.
    Check if entry by given name exists.

    If named entry does not exist 0 will be returned, if it does
    exist 1 is returned.

    name: Entry name to look for, this must be an exact match to
    the entry name in the archive.
    """
    return _mupdf.has_archive_entry(arch, name)

def has_option(opts, key):
    r"""
     Wrapper for `fz_has_option()`.

    This function has out-params. Python/C# wrappers look like:
    	`has_option(const char *opts, const char *key)` => `(int, const char *val)`

    	Look for a given option (key) in the opts string. Return 1 if
    	it has it, and update *val to point to the value within opts.
    """
    return _mupdf.has_option(opts, key)

def has_permission(doc, p):
    r"""
    Wrapper for `fz_has_permission()`.
    Check permission flags on document.
    """
    return _mupdf.has_permission(doc, p)

def hash_filter(table, state, callback):
    r"""
    Wrapper for `fz_hash_filter()`.
    Iterate over the entries in a hash table, removing all the ones where callback returns true.
    Does NOT free the value of the entry, so the caller is expected to take care of this.
    """
    return _mupdf.hash_filter(table, state, callback)

def hash_find(table, key):
    r"""
    Wrapper for `fz_hash_find()`.
    Search for a matching hash within the table, and return the
    associated value.
    """
    return _mupdf.hash_find(table, key)

def hash_for_each(table, state, callback):
    r"""
    Wrapper for `fz_hash_for_each()`.
    Iterate over the entries in a hash table.
    """
    return _mupdf.hash_for_each(table, state, callback)

def hash_insert(table, key, val):
    r"""
    Wrapper for `fz_hash_insert()`.
    Insert a new key/value pair into the hash table.

    If an existing entry with the same key is found, no change is
    made to the hash table, and a pointer to the existing value is
    returned.

    If no existing entry with the same key is found, ownership of
    val passes in, key is copied, and NULL is returned.
    """
    return _mupdf.hash_insert(table, key, val)

def hash_remove(table, key):
    r"""
    Wrapper for `fz_hash_remove()`.
    Remove the entry for a given key.

    The value is NOT freed, so the caller is expected to take care
    of this.
    """
    return _mupdf.hash_remove(table, key)

def hb_lock():
    r"""
    Wrapper for `fz_hb_lock()`.
    Lock against Harfbuzz being called
    simultaneously in several threads. This reuses
    FZ_LOCK_FREETYPE.
    """
    return _mupdf.hb_lock()

def hb_unlock():
    r"""
    Wrapper for `fz_hb_unlock()`.
    Unlock after a Harfbuzz call. This reuses
    FZ_LOCK_FREETYPE.
    """
    return _mupdf.hb_unlock()

def highlight_selection(page, a, b, quads, max_quads):
    r"""
    Wrapper for `fz_highlight_selection()`.
    Return a list of quads to highlight lines inside the selection
    points.
    """
    return _mupdf.highlight_selection(page, a, b, quads, max_quads)

def ignore_text(dev, text, ctm):
    r""" Wrapper for `fz_ignore_text()`."""
    return _mupdf.ignore_text(dev, text, ctm)

def image_orientation(image):
    r"""
    Wrapper for `fz_image_orientation()`.
    Request the natural orientation of an image.

    This is for images (such as JPEG) that can contain internal
    specifications of rotation/flips. This is ignored by all the
    internal decode/rendering routines, but can be used by callers
    (such as the image document handler) to respect such
    specifications.

    The values used by MuPDF are as follows, with the equivalent
    Exif specifications given for information:

    0: Undefined
    1: 0 degree ccw rotation. (Exif = 1)
    2: 90 degree ccw rotation. (Exif = 8)
    3: 180 degree ccw rotation. (Exif = 3)
    4: 270 degree ccw rotation. (Exif = 6)
    5: flip on X. (Exif = 2)
    6: flip on X, then rotate ccw by 90 degrees. (Exif = 5)
    7: flip on X, then rotate ccw by 180 degrees. (Exif = 4)
    8: flip on X, then rotate ccw by 270 degrees. (Exif = 7)
    """
    return _mupdf.image_orientation(image)

def image_orientation_matrix(image):
    r""" Wrapper for `fz_image_orientation_matrix()`."""
    return _mupdf.image_orientation_matrix(image)

def image_resolution(image):
    r"""
     Wrapper for `fz_image_resolution()`.

    This function has out-params. Python/C# wrappers look like:
    	`image_resolution(fz_image *image)` => `(int xres, int yres)`

    	Request the natural resolution
    	of an image.

    	xres, yres: Pointers to ints to be updated with the
    	natural resolution of an image (or a sensible default
    	if not encoded).
    """
    return _mupdf.image_resolution(image)

def image_size(im):
    r"""
    Wrapper for `fz_image_size()`.
    Return the size of the storage used by an image.
    """
    return _mupdf.image_size(im)

def include_point_in_rect(r, p):
    r"""
    Wrapper for `fz_include_point_in_rect()`.
    Expand a bbox to include a given point.
    To create a rectangle that encompasses a sequence of points, the
    rectangle must first be set to be the empty rectangle at one of
    the points before including the others.
    """
    return _mupdf.include_point_in_rect(r, p)

def install_load_system_font_funcs(f, f_cjk, f_fallback):
    r"""
    Wrapper for `fz_install_load_system_font_funcs()`.
    Install functions to allow MuPDF to request fonts from the
    system.

    Only one set of hooks can be in use at a time.
    """
    return _mupdf.install_load_system_font_funcs(f, f_cjk, f_fallback)

def intersect_irect(a, b):
    r"""
    Wrapper for `fz_intersect_irect()`.
    Compute intersection of two bounding boxes.

    Similar to fz_intersect_rect but operates on two bounding
    boxes instead of two rectangles.
    """
    return _mupdf.intersect_irect(a, b)

def intersect_rect(a, b):
    r"""
    Wrapper for `fz_intersect_rect()`.
    Compute intersection of two rectangles.

    Given two rectangles, update the first to be the smallest
    axis-aligned rectangle that covers the area covered by both
    given rectangles. If either rectangle is empty then the
    intersection is also empty. If either rectangle is infinite
    then the intersection is simply the non-infinite rectangle.
    Should both rectangles be infinite, then the intersection is
    also infinite.
    """
    return _mupdf.intersect_rect(a, b)

def invert_matrix(matrix):
    r"""
    Wrapper for `fz_invert_matrix()`.
    Create an inverse matrix.

    inverse: Place to store inverse matrix.

    matrix: Matrix to invert. A degenerate matrix, where the
    determinant is equal to zero, can not be inverted and the
    original matrix is returned instead.

    Returns inverse.
    """
    return _mupdf.invert_matrix(matrix)

def invert_pixmap(pix):
    r"""
    Wrapper for `fz_invert_pixmap()`.
    Invert all the pixels in a pixmap. All components (process and
    spots) of all pixels are inverted (except alpha, which is
    unchanged).
    """
    return _mupdf.invert_pixmap(pix)

def invert_pixmap_alpha(pix):
    r"""
    Wrapper for `fz_invert_pixmap_alpha()`.
    Invert the alpha fo all the pixels in a pixmap.
    """
    return _mupdf.invert_pixmap_alpha(pix)

def invert_pixmap_luminance(pix):
    r"""
    Wrapper for `fz_invert_pixmap_luminance()`.
    Transform the pixels in a pixmap so that luminance of each
    pixel is inverted, and the chrominance remains unchanged (as
    much as accuracy allows).

    All components of all pixels are inverted (except alpha, which
    is unchanged). Only supports Grey and RGB bitmaps.
    """
    return _mupdf.invert_pixmap_luminance(pix)

def invert_pixmap_rect(image, rect):
    r"""
    Wrapper for `fz_invert_pixmap_rect()`.
    Invert all the pixels in a given rectangle of a
    pixmap. All components of all pixels in the rectangle are
    inverted (except alpha, which is unchanged).
    """
    return _mupdf.invert_pixmap_rect(image, rect)

def irect_from_rect(rect):
    r"""
    Wrapper for `fz_irect_from_rect()`.
    Convert a rect into the minimal bounding box
    that covers the rectangle.

    Coordinates in a bounding box are integers, so rounding of the
    rects coordinates takes place. The top left corner is rounded
    upwards and left while the bottom right corner is rounded
    downwards and to the right.
    """
    return _mupdf.irect_from_rect(rect)

def irect_height(r):
    r"""
    Wrapper for `fz_irect_height()`.
    Return the height of an irect. Invalid irects return 0.
    """
    return _mupdf.irect_height(r)

def irect_width(r):
    r"""
    Wrapper for `fz_irect_width()`.
    Return the width of an irect. Invalid irects return 0.
    """
    return _mupdf.irect_width(r)

def is_directory(path):
    r"""
    Wrapper for `fz_is_directory()`.
    Determine if a given path is a directory.
    """
    return _mupdf.is_directory(path)

def is_document_reflowable(doc):
    r"""
    Wrapper for `fz_is_document_reflowable()`.
    Is the document reflowable.

    Returns 1 to indicate reflowable documents, otherwise 0.
    """
    return _mupdf.is_document_reflowable(doc)

def is_empty_irect(r):
    r""" Wrapper for `fz_is_empty_irect()`."""
    return _mupdf.is_empty_irect(r)

def is_empty_rect(r):
    r"""
    Wrapper for `fz_is_empty_rect()`.
    Check if rectangle is empty.

    An empty rectangle is defined as one whose area is zero.
    All invalid rectangles are empty.
    """
    return _mupdf.is_empty_rect(r)

def is_eof(stm):
    r"""
    Wrapper for `fz_is_eof()`.
    Query if the stream has reached EOF (during normal bytewise
    reading).

    See fz_is_eof_bits for the equivalent function for bitwise
    reading.
    """
    return _mupdf.is_eof(stm)

def is_eof_bits(stm):
    r"""
    Wrapper for `fz_is_eof_bits()`.
    Query if the stream has reached EOF (during bitwise
    reading).

    See fz_is_eof for the equivalent function for bytewise
    reading.
    """
    return _mupdf.is_eof_bits(stm)

def is_external_link(uri):
    r"""
    Wrapper for `fz_is_external_link()`.
    Query whether a link is external to a document (determined by
    uri containing a ':', intended to match with '://' which
    separates the scheme from the scheme specific parts in URIs).
    """
    return _mupdf.is_external_link(uri)

def is_identity(m):
    r""" Wrapper for `fz_is_identity()`."""
    return _mupdf.is_identity(m)

def is_infinite_irect(r):
    r"""
    Wrapper for `fz_is_infinite_irect()`.
    Check if an integer rectangle
    is infinite.
    """
    return _mupdf.is_infinite_irect(r)

def is_infinite_rect(r):
    r"""
    Wrapper for `fz_is_infinite_rect()`.
    Check if rectangle is infinite.
    """
    return _mupdf.is_infinite_rect(r)

def is_page_range(s):
    r"""
     Wrapper for `fz_is_page_range()`.
    	Check and parse string into page ranges:
    ,?(-?+|N)(-(-?+|N))?/
    """
    return _mupdf.is_page_range(s)

def is_pixmap_monochrome(pixmap):
    r"""
    Wrapper for `fz_is_pixmap_monochrome()`.
    Check if the pixmap is a 1-channel image containing samples with
    only values 0 and 255
    """
    return _mupdf.is_pixmap_monochrome(pixmap)

def is_point_inside_irect(x, y, r):
    r"""
    Wrapper for `fz_is_point_inside_irect()`.
    Inclusion test for irects. (Rect is assumed to be open, i.e.
    top right corner is not included).
    """
    return _mupdf.is_point_inside_irect(x, y, r)

def is_point_inside_quad(p, q):
    r"""
    Wrapper for `fz_is_point_inside_quad()`.
    Inclusion test for quads.
    """
    return _mupdf.is_point_inside_quad(p, q)

def is_point_inside_rect(p, r):
    r"""
    Wrapper for `fz_is_point_inside_rect()`.
    Inclusion test for rects. (Rect is assumed to be open, i.e.
    top right corner is not included).
    """
    return _mupdf.is_point_inside_rect(p, r)

def is_pow2(a):
    r""" Wrapper for `fz_is_pow2()`."""
    return _mupdf.is_pow2(a)

def is_quad_inside_quad(needle, haystack):
    r"""
    Wrapper for `fz_is_quad_inside_quad()`.
    Inclusion test for quad in quad.

    This may break down if quads are not 'well formed'.
    """
    return _mupdf.is_quad_inside_quad(needle, haystack)

def is_quad_intersecting_quad(a, b):
    r"""
    Wrapper for `fz_is_quad_intersecting_quad()`.
    Intersection test for quads.

    This may break down if quads are not 'well formed'.
    """
    return _mupdf.is_quad_intersecting_quad(a, b)

def is_rectilinear(m):
    r"""
    Wrapper for `fz_is_rectilinear()`.
    Check if a transformation is rectilinear.

    Rectilinear means that no shearing is present and that any
    rotations present are a multiple of 90 degrees. Usually this
    is used to make sure that axis-aligned rectangles before the
    transformation are still axis-aligned rectangles afterwards.
    """
    return _mupdf.is_rectilinear(m)

def is_tar_archive(file):
    r"""
    Wrapper for `fz_is_tar_archive()`.
    Detect if stream object is a tar achieve.

    Assumes that the stream object is seekable.
    """
    return _mupdf.is_tar_archive(file)

def is_valid_blend_colorspace(cs):
    r"""
    Wrapper for `fz_is_valid_blend_colorspace()`.
    Check to see that a colorspace is appropriate to be used as
    a blending space (i.e. only grey, rgb or cmyk).
    """
    return _mupdf.is_valid_blend_colorspace(cs)

def is_valid_irect(r):
    r"""
    Wrapper for `fz_is_valid_irect()`.
    Check if an integer rectangle is valid.
    """
    return _mupdf.is_valid_irect(r)

def is_valid_rect(r):
    r"""
    Wrapper for `fz_is_valid_rect()`.
    Check if rectangle is valid.
    """
    return _mupdf.is_valid_rect(r)

def is_zip_archive(file):
    r"""
    Wrapper for `fz_is_zip_archive()`.
    Detect if stream object is a zip archive.

    Assumes that the stream object is seekable.
    """
    return _mupdf.is_zip_archive(file)

def iso8859_1_from_unicode(u):
    r""" Wrapper for `fz_iso8859_1_from_unicode()`."""
    return _mupdf.iso8859_1_from_unicode(u)

def iso8859_7_from_unicode(u):
    r""" Wrapper for `fz_iso8859_7_from_unicode()`."""
    return _mupdf.iso8859_7_from_unicode(u)

def jbig2_globals_data(globals):
    r"""
    Wrapper for `fz_jbig2_globals_data()`.
    Return buffer containing jbig2 globals data stream.
    """
    return _mupdf.jbig2_globals_data(globals)

def keep_bitmap(bit):
    r"""
    Wrapper for `fz_keep_bitmap()`.
    Take an additional reference to the bitmap. The same pointer
    is returned.

    Never throws exceptions.
    """
    return _mupdf.keep_bitmap(bit)

def keep_buffer(buf):
    r"""
    Wrapper for `fz_keep_buffer()`.
    Take an additional reference to the buffer. The same pointer
    is returned.

    Never throws exceptions.
    """
    return _mupdf.keep_buffer(buf)

def keep_colorspace(colorspace):
    r"""
    Wrapper for `fz_keep_colorspace()`.
    Increment the reference count for the colorspace.

    Returns the same pointer. Never throws an exception.
    """
    return _mupdf.keep_colorspace(colorspace)

def keep_default_colorspaces(default_cs):
    r"""
    Wrapper for `fz_keep_default_colorspaces()`.
    Keep an additional reference to the default colorspaces
    structure.

    Never throws exceptions.
    """
    return _mupdf.keep_default_colorspaces(default_cs)

def keep_device(dev):
    r"""
    Wrapper for `fz_keep_device()`.
    Increment the reference count for a device. Returns the same
    pointer.

    Never throws exceptions.
    """
    return _mupdf.keep_device(dev)

def keep_display_list(list):
    r"""
    Wrapper for `fz_keep_display_list()`.
    Increment the reference count for a display list. Returns the
    same pointer.

    Never throws exceptions.
    """
    return _mupdf.keep_display_list(list)

def keep_document(doc):
    r"""
    Wrapper for `fz_keep_document()`.
    Increment the document reference count. The same pointer is
    returned.

    Never throws exceptions.
    """
    return _mupdf.keep_document(doc)

def keep_font(font):
    r"""
    Wrapper for `fz_keep_font()`.
    Add a reference to an existing fz_font.

    font: The font to add a reference to.

    Returns the same font.
    """
    return _mupdf.keep_font(font)

def keep_glyph(pix):
    r"""
    Wrapper for `fz_keep_glyph()`.
    Take a reference to a glyph.

    pix: The glyph to increment the reference for.

    Returns pix.
    """
    return _mupdf.keep_glyph(pix)

def keep_halftone(half):
    r"""
    Wrapper for `fz_keep_halftone()`.
    Take an additional reference to the halftone. The same pointer
    is returned.

    Never throws exceptions.
    """
    return _mupdf.keep_halftone(half)

def keep_image(image):
    r"""
    Wrapper for `fz_keep_image()`.
    Increment the (normal) reference count for an image. Returns the
    same pointer.

    Never throws exceptions.
    """
    return _mupdf.keep_image(image)

def keep_image_store_key(image):
    r"""
    Wrapper for `fz_keep_image_store_key()`.
    Increment the store key reference for an image. Returns the same
    pointer. (This is the count of references for an image held by
    keys in the image store).

    Never throws exceptions.
    """
    return _mupdf.keep_image_store_key(image)

def keep_imp(p):
    r"""
     Wrapper for `fz_keep_imp()`.

    This function has out-params. Python/C# wrappers look like:
    	`keep_imp(void *p)` => `(void *, int refs)`
    """
    return _mupdf.keep_imp(p)

def keep_imp16(p):
    r"""
     Wrapper for `fz_keep_imp16()`.

    This function has out-params. Python/C# wrappers look like:
    	`keep_imp16(void *p)` => `(void *, int16_t refs)`
    """
    return _mupdf.keep_imp16(p)

def keep_imp8(p, refs):
    r""" Wrapper for `fz_keep_imp8()`."""
    return _mupdf.keep_imp8(p, refs)

def keep_imp_locked(p):
    r"""
     Wrapper for `fz_keep_imp_locked()`.

    This function has out-params. Python/C# wrappers look like:
    	`keep_imp_locked(void *p)` => `(void *, int refs)`
    """
    return _mupdf.keep_imp_locked(p)

def keep_jbig2_globals(globals):
    r"""
    Wrapper for `fz_keep_jbig2_globals()`.
    Increment the reference count for a jbig2 globals record.

    Never throws an exception.
    """
    return _mupdf.keep_jbig2_globals(globals)

def keep_key_storable(arg_1):
    r"""
    Wrapper for `fz_keep_key_storable()`.
    Increment the (normal) reference count for a key storable
    object. Returns the same pointer.

    Never throws exceptions.
    """
    return _mupdf.keep_key_storable(arg_1)

def keep_key_storable_key(arg_1):
    r"""
    Wrapper for `fz_keep_key_storable_key()`.
    Increment the (key) reference count for a key storable
    object. Returns the same pointer.

    Never throws exceptions.
    """
    return _mupdf.keep_key_storable_key(arg_1)

def keep_link(link):
    r"""
    Wrapper for `fz_keep_link()`.
    Increment the reference count for a link. The same pointer is
    returned.

    Never throws exceptions.
    """
    return _mupdf.keep_link(link)

def keep_outline(outline):
    r"""
    Wrapper for `fz_keep_outline()`.
    Increment the reference count. Returns the same pointer.

    Never throws exceptions.
    """
    return _mupdf.keep_outline(outline)

def keep_page(page):
    r"""
    Wrapper for `fz_keep_page()`.
    Increment the reference count for the page. Returns the same
    pointer.

    Never throws exceptions.
    """
    return _mupdf.keep_page(page)

def keep_page_locked(page):
    r"""
    Wrapper for `fz_keep_page_locked()`.
    Increment the reference count for the page. Returns the same
    pointer. Must only be used when the alloc lock is already taken.

    Never throws exceptions.
    """
    return _mupdf.keep_page_locked(page)

def keep_path(path):
    r"""
    Wrapper for `fz_keep_path()`.
    Increment the reference count. Returns the same pointer.

    All paths can be kept, regardless of their packing type.

    Never throws exceptions.
    """
    return _mupdf.keep_path(path)

def keep_pixmap(pix):
    r"""
    Wrapper for `fz_keep_pixmap()`.
    Increment the reference count for the pixmap. The same pointer
    is returned.

    Never throws exceptions.
    """
    return _mupdf.keep_pixmap(pix)

def keep_separations(sep):
    r"""
    Wrapper for `fz_keep_separations()`.
    Increment the reference count for a separations structure.
    Returns the same pointer.

    Never throws exceptions.
    """
    return _mupdf.keep_separations(sep)

def keep_shade(shade):
    r"""
    Wrapper for `fz_keep_shade()`.
    Increment the reference count for the shade structure. The
    same pointer is returned.

    Never throws exceptions.
    """
    return _mupdf.keep_shade(shade)

def keep_storable(arg_1):
    r"""
    Wrapper for `fz_keep_storable()`.
    Increment the reference count for a storable object.
    Returns the same pointer.

    Never throws exceptions.
    """
    return _mupdf.keep_storable(arg_1)

def keep_store_context():
    r"""
    Wrapper for `fz_keep_store_context()`.
    Increment the reference count for the store context. Returns
    the same pointer.

    Never throws exceptions.
    """
    return _mupdf.keep_store_context()

def keep_stream(stm):
    r"""
    Wrapper for `fz_keep_stream()`.
    Increments the reference count for a stream. Returns the same
    pointer.

    Never throws exceptions.
    """
    return _mupdf.keep_stream(stm)

def keep_stroke_state(stroke):
    r"""
    Wrapper for `fz_keep_stroke_state()`.
    Take an additional reference to a stroke state structure.

    No modifications should be carried out on a stroke
    state to which more than one reference is held, as
    this can cause race conditions.
    """
    return _mupdf.keep_stroke_state(stroke)

def keep_text(text):
    r"""
    Wrapper for `fz_keep_text()`.
    Increment the reference count for the text object. The same
    pointer is returned.

    Never throws exceptions.
    """
    return _mupdf.keep_text(text)

def koi8u_from_unicode(u):
    r""" Wrapper for `fz_koi8u_from_unicode()`."""
    return _mupdf.koi8u_from_unicode(u)

def last_page(doc):
    r"""
    Wrapper for `fz_last_page()`.
    Function to get the location for the last page in the document.
    Using this can be far more efficient in some cases than calling
    fz_count_pages and using the page number.
    """
    return _mupdf.last_page(doc)

def layout_document(doc, w, h, em):
    r"""
    Wrapper for `fz_layout_document()`.
    Layout reflowable document types.

    w, h: Page size in points.
    em: Default font size in points.
    """
    return _mupdf.layout_document(doc, w, h, em)

def lineto(path, x, y):
    r"""
    Wrapper for `fz_lineto()`.
    Append a 'lineto' command to an open path.

    path: The path to modify.

    x, y: The coordinate to line to.

    Throws exceptions on failure to allocate, or attempting to
    modify a packed path.
    """
    return _mupdf.lineto(path, x, y)

def list_archive_entry(arch, idx):
    r"""
    Wrapper for `fz_list_archive_entry()`.
    Get listed name of entry position idx.

    idx: Must be a value >= 0 < return value from
    fz_count_archive_entries. If not in range NULL will be
    returned.

    May throw an exception if this type of archive cannot list the
    entries (such as a directory).
    """
    return _mupdf.list_archive_entry(arch, idx)

def load_bmp_subimage(buf, len, subimage):
    r""" Wrapper for `fz_load_bmp_subimage()`."""
    return _mupdf.load_bmp_subimage(buf, len, subimage)

def load_bmp_subimage_count(buf, len):
    r""" Wrapper for `fz_load_bmp_subimage_count()`."""
    return _mupdf.load_bmp_subimage_count(buf, len)

def load_chapter_page(doc, chapter, page):
    r"""
    Wrapper for `fz_load_chapter_page()`.
    Load a page.

    After fz_load_page is it possible to retrieve the size of the
    page using fz_bound_page, or to render the page using
    fz_run_page_*. Free the page by calling fz_drop_page.

    chapter: chapter number, 0 is the first chapter of the document.
    number: page number, 0 is the first page of the chapter.
    """
    return _mupdf.load_chapter_page(doc, chapter, page)

def load_fallback_font(script, language, serif, bold, italic):
    r"""
    Wrapper for `fz_load_fallback_font()`.
    Try to load a fallback font for the
    given combination of font attributes. Whether a font is
    present or not will depend on the configuration in which
    MuPDF is built.

    script: The script desired (e.g. UCDN_SCRIPT_KATAKANA).

    language: The language desired (e.g. FZ_LANG_ja).

    serif: 1 if serif desired, 0 otherwise.

    bold: 1 if bold desired, 0 otherwise.

    italic: 1 if italic desired, 0 otherwise.

    Returns a new font handle, or NULL if not available.
    """
    return _mupdf.load_fallback_font(script, language, serif, bold, italic)

def load_jbig2_globals(buf):
    r"""
    Wrapper for `fz_load_jbig2_globals()`.
    Create a jbig2 globals record from a buffer.

    Immutable once created.
    """
    return _mupdf.load_jbig2_globals(buf)

def load_jbig2_subimage(buf, len, subimage):
    r""" Wrapper for `fz_load_jbig2_subimage()`."""
    return _mupdf.load_jbig2_subimage(buf, len, subimage)

def load_jbig2_subimage_count(buf, len):
    r""" Wrapper for `fz_load_jbig2_subimage_count()`."""
    return _mupdf.load_jbig2_subimage_count(buf, len)

def load_jpx(data, size, cs):
    r"""
    Wrapper for `fz_load_jpx()`.
    Exposed for PDF.
    """
    return _mupdf.load_jpx(data, size, cs)

def load_links(page):
    r"""
    Wrapper for `fz_load_links()`.
    Load the list of links for a page.

    Returns a linked list of all the links on the page, each with
    its clickable region and link destination. Each link is
    reference counted so drop and free the list of links by
    calling fz_drop_link on the pointer return from fz_load_links.

    page: Page obtained from fz_load_page.
    """
    return _mupdf.load_links(page)

def load_outline(doc):
    r"""
    Wrapper for `fz_load_outline()`.
    Load the hierarchical document outline.

    Should be freed by fz_drop_outline.
    """
    return _mupdf.load_outline(doc)

def load_outline_from_iterator(iter):
    r"""
    Wrapper for `fz_load_outline_from_iterator()`.
    Routine to implement the old Structure based API from an iterator.
    """
    return _mupdf.load_outline_from_iterator(iter)

def load_page(doc, number):
    r"""
    Wrapper for `fz_load_page()`.
    Load a given page number from a document. This may be much less
    efficient than loading by location (chapter+page) for some
    document types.
    """
    return _mupdf.load_page(doc, number)

def load_pnm_subimage(buf, len, subimage):
    r""" Wrapper for `fz_load_pnm_subimage()`."""
    return _mupdf.load_pnm_subimage(buf, len, subimage)

def load_pnm_subimage_count(buf, len):
    r""" Wrapper for `fz_load_pnm_subimage_count()`."""
    return _mupdf.load_pnm_subimage_count(buf, len)

def load_system_cjk_font(name, ordering, serif):
    r"""
    Wrapper for `fz_load_system_cjk_font()`.
    Attempt to load a given font from
    the system.

    name: The name of the desired font.

    ordering: The ordering to load the font from (e.g. FZ_ADOBE_KOREA)

    serif: 1 if serif desired, 0 otherwise.

    Returns a new font handle, or NULL if no matching font was found
    (or on error).
    """
    return _mupdf.load_system_cjk_font(name, ordering, serif)

def load_system_font(name, bold, italic, needs_exact_metrics):
    r"""
    Wrapper for `fz_load_system_font()`.
    Attempt to load a given font from the system.

    name: The name of the desired font.

    bold: 1 if bold desired, 0 otherwise.

    italic: 1 if italic desired, 0 otherwise.

    needs_exact_metrics: 1 if an exact metrical match is required,
    0 otherwise.

    Returns a new font handle, or NULL if no matching font was found
    (or on error).
    """
    return _mupdf.load_system_font(name, bold, italic, needs_exact_metrics)

def load_tiff_subimage(buf, len, subimage):
    r""" Wrapper for `fz_load_tiff_subimage()`."""
    return _mupdf.load_tiff_subimage(buf, len, subimage)

def load_tiff_subimage_count(buf, len):
    r"""
    Wrapper for `fz_load_tiff_subimage_count()`.
    Exposed for CBZ.
    """
    return _mupdf.load_tiff_subimage_count(buf, len)

def location_from_page_number(doc, number):
    r"""
    Wrapper for `fz_location_from_page_number()`.
    Converts from page number to chapter+page. This may cause many
    chapters to be laid out in order to calculate the number of
    pages within those chapters.
    """
    return _mupdf.location_from_page_number(doc, number)

def lock(lock):
    r"""
    Wrapper for `fz_lock()`.
    Lock one of the user supplied mutexes.
    """
    return _mupdf.lock(lock)

def lookup_base14_font(name):
    r"""
     Wrapper for `fz_lookup_base14_font()`.

    This function has out-params. Python/C# wrappers look like:
    	`lookup_base14_font(const char *name)` => `(const unsigned char *, int len)`

    	Search the builtin base14 fonts for a match.
    	Whether a given font is present or not will depend on the
    	configuration in which MuPDF is built.

    	name: The name of the font desired.

    	len: Pointer to a place to receive the length of the discovered
    	font buffer.

    	Returns a pointer to the font file data, or NULL if not present.
    """
    return _mupdf.lookup_base14_font(name)

def lookup_blendmode(name):
    r"""
    Wrapper for `fz_lookup_blendmode()`.
    Map from (case sensitive) blend mode string to enumeration.
    """
    return _mupdf.lookup_blendmode(name)

def lookup_bookmark(doc, mark):
    r"""
    Wrapper for `fz_lookup_bookmark()`.
    Find a bookmark and return its page number.
    """
    return _mupdf.lookup_bookmark(doc, mark)

def lookup_builtin_font(name, bold, italic):
    r"""
     Wrapper for `fz_lookup_builtin_font()`.

    This function has out-params. Python/C# wrappers look like:
    	`lookup_builtin_font(const char *name, int bold, int italic)` => `(const unsigned char *, int len)`

    	Search the builtin fonts for a match.
    	Whether a given font is present or not will depend on the
    	configuration in which MuPDF is built.

    	name: The name of the font desired.

    	bold: 1 if bold desired, 0 otherwise.

    	italic: 1 if italic desired, 0 otherwise.

    	len: Pointer to a place to receive the length of the discovered
    	font buffer.

    	Returns a pointer to the font file data, or NULL if not present.
    """
    return _mupdf.lookup_builtin_font(name, bold, italic)

def lookup_cjk_font(ordering):
    r"""
     Wrapper for `fz_lookup_cjk_font()`.

    This function has out-params. Python/C# wrappers look like:
    	`lookup_cjk_font(int ordering)` => `(const unsigned char *, int len, int index)`

    	Search the builtin cjk fonts for a match.
    	Whether a font is present or not will depend on the
    	configuration in which MuPDF is built.

    	ordering: The desired ordering of the font (e.g. FZ_ADOBE_KOREA).

    	len: Pointer to a place to receive the length of the discovered
    	font buffer.

    	Returns a pointer to the font file data, or NULL if not present.
    """
    return _mupdf.lookup_cjk_font(ordering)

def lookup_cjk_font_by_language(lang):
    r"""
     Wrapper for `fz_lookup_cjk_font_by_language()`.

    This function has out-params. Python/C# wrappers look like:
    	`lookup_cjk_font_by_language(const char *lang)` => `(const unsigned char *, int len, int subfont)`

    	Search the builtin cjk fonts for a match for a given language.
    	Whether a font is present or not will depend on the
    	configuration in which MuPDF is built.

    	lang: Pointer to a (case sensitive) language string (e.g.
    	"ja", "ko", "zh-Hant" etc).

    	len: Pointer to a place to receive the length of the discovered
    	font buffer.

    	subfont: Pointer to a place to store the subfont index of the
    	discovered font.

    	Returns a pointer to the font file data, or NULL if not present.
    """
    return _mupdf.lookup_cjk_font_by_language(lang)

def lookup_cjk_ordering_by_language(name):
    r"""
    Wrapper for `fz_lookup_cjk_ordering_by_language()`.
    Return the matching FZ_ADOBE_* ordering
    for the given language tag, such as "zh-Hant", "zh-Hans", "ja", or "ko".
    """
    return _mupdf.lookup_cjk_ordering_by_language(name)

def lookup_metadata(*args):
    r"""
    *Overload 1:*
     Wrapper for `fz_lookup_metadata()`.
    	Retrieve document meta data strings.

    	doc: The document to query.

    	key: Which meta data key to retrieve...

    	Basic information:
    		'format'	-- Document format and version.
    		'encryption'	-- Description of the encryption used.

    	From the document information dictionary:
    		'info:Title'
    		'info:Author'
    		'info:Subject'
    		'info:Keywords'
    		'info:Creator'
    		'info:Producer'
    		'info:CreationDate'
    		'info:ModDate'

    	buf: The buffer to hold the results (a nul-terminated UTF-8
    	string).

    	size: Size of 'buf'.

    	Returns the number of bytes need to store the string plus terminator
    	(will be larger than 'size' if the output was truncated), or -1 if the
    	key is not recognized or found.


    |

    *Overload 2:*
     Extra wrapper for `fz_lookup_metadata()` that returns a std::string and sets
    o_out to length of string plus one. If <key> is not found, returns empty
    string with *o_out=-1. <o_out> can be NULL if caller is not interested in
    error information.

    |

    *Overload 3:*
     Extra wrapper for `fz_lookup_metadata()` that returns a std::string and sets
    o_out to length of string plus one. If <key> is not found, returns empty
    string with *o_out=-1. <o_out> can be NULL if caller is not interested in
    error information.
    """
    return _mupdf.lookup_metadata(*args)

def lookup_noto_emoji_font():
    r"""
     Wrapper for `fz_lookup_noto_emoji_font()`.

    This function has out-params. Python/C# wrappers look like:
    	`lookup_noto_emoji_font()` => `(const unsigned char *, int len)`
    """
    return _mupdf.lookup_noto_emoji_font()

def lookup_noto_font(script, lang):
    r"""
     Wrapper for `fz_lookup_noto_font()`.

    This function has out-params. Python/C# wrappers look like:
    	`lookup_noto_font(int script, int lang)` => `(const unsigned char *, int len, int subfont)`

    	Search the builtin noto fonts for a match.
    	Whether a font is present or not will depend on the
    	configuration in which MuPDF is built.

    	script: The script desired (e.g. UCDN_SCRIPT_KATAKANA).

    	lang: The language desired (e.g. FZ_LANG_ja).

    	len: Pointer to a place to receive the length of the discovered
    	font buffer.

    	Returns a pointer to the font file data, or NULL if not present.
    """
    return _mupdf.lookup_noto_font(script, lang)

def lookup_noto_math_font():
    r"""
     Wrapper for `fz_lookup_noto_math_font()`.

    This function has out-params. Python/C# wrappers look like:
    	`lookup_noto_math_font()` => `(const unsigned char *, int len)`

    	Search the builtin noto fonts specific symbol fonts.
    	Whether a font is present or not will depend on the
    	configuration in which MuPDF is built.
    """
    return _mupdf.lookup_noto_math_font()

def lookup_noto_music_font():
    r"""
     Wrapper for `fz_lookup_noto_music_font()`.

    This function has out-params. Python/C# wrappers look like:
    	`lookup_noto_music_font()` => `(const unsigned char *, int len)`
    """
    return _mupdf.lookup_noto_music_font()

def lookup_noto_symbol1_font():
    r"""
     Wrapper for `fz_lookup_noto_symbol1_font()`.

    This function has out-params. Python/C# wrappers look like:
    	`lookup_noto_symbol1_font()` => `(const unsigned char *, int len)`
    """
    return _mupdf.lookup_noto_symbol1_font()

def lookup_noto_symbol2_font():
    r"""
     Wrapper for `fz_lookup_noto_symbol2_font()`.

    This function has out-params. Python/C# wrappers look like:
    	`lookup_noto_symbol2_font()` => `(const unsigned char *, int len)`
    """
    return _mupdf.lookup_noto_symbol2_font()

def lookup_rendering_intent(name):
    r"""
    Wrapper for `fz_lookup_rendering_intent()`.
    Map from (case sensitive) rendering intent string to enumeration
    value.
    """
    return _mupdf.lookup_rendering_intent(name)

def make_bookmark(doc, loc):
    r"""
    Wrapper for `fz_make_bookmark()`.
    Create a bookmark for the given page, which can be used to find
    the same location after the document has been laid out with
    different parameters.
    """
    return _mupdf.make_bookmark(doc, loc)

def make_irect(x0, y0, x1, y1):
    r""" Wrapper for `fz_make_irect()`."""
    return _mupdf.make_irect(x0, y0, x1, y1)

def make_link_dest_none():
    r""" Wrapper for `fz_make_link_dest_none()`."""
    return _mupdf.make_link_dest_none()

def make_link_dest_xyz(chapter, page, x, y, z):
    r""" Wrapper for `fz_make_link_dest_xyz()`."""
    return _mupdf.make_link_dest_xyz(chapter, page, x, y, z)

def make_location(chapter, page):
    r"""
    Wrapper for `fz_make_location()`.
    Simple constructor for fz_locations.
    """
    return _mupdf.make_location(chapter, page)

def make_matrix(a, b, c, d, e, f):
    r""" Wrapper for `fz_make_matrix()`."""
    return _mupdf.make_matrix(a, b, c, d, e, f)

def make_point(x, y):
    r""" Wrapper for `fz_make_point()`."""
    return _mupdf.make_point(x, y)

def make_quad(ul_x, ul_y, ur_x, ur_y, ll_x, ll_y, lr_x, lr_y):
    r"""
    Wrapper for `fz_make_quad()`.
    Inline convenience construction function.
    """
    return _mupdf.make_quad(ul_x, ul_y, ur_x, ur_y, ll_x, ll_y, lr_x, lr_y)

def make_rect(x0, y0, x1, y1):
    r""" Wrapper for `fz_make_rect()`."""
    return _mupdf.make_rect(x0, y0, x1, y1)

def malloc_no_throw(size):
    r"""
    Wrapper for `fz_malloc_no_throw()`.
    fz_malloc equivalent that returns NULL rather than throwing
    exceptions.
    """
    return _mupdf.malloc_no_throw(size)

def matrix_expansion(m):
    r"""
    Wrapper for `fz_matrix_expansion()`.
    Calculate average scaling factor of matrix.
    """
    return _mupdf.matrix_expansion(m)

def matrix_max_expansion(m):
    r"""
    Wrapper for `fz_matrix_max_expansion()`.
    Find the largest expansion performed by this matrix.
    (i.e. max(abs(m.a),abs(m.b),abs(m.c),abs(m.d))
    """
    return _mupdf.matrix_max_expansion(m)

def max(a, b):
    r""" Wrapper for `fz_max()`."""
    return _mupdf.max(a, b)

def maxi(a, b):
    r""" Wrapper for `fz_maxi()`."""
    return _mupdf.maxi(a, b)

def maxi64(a, b):
    r""" Wrapper for `fz_maxi64()`."""
    return _mupdf.maxi64(a, b)

def maxz(a, b):
    r""" Wrapper for `fz_maxz()`."""
    return _mupdf.maxz(a, b)

def md5_buffer(buffer, digest):
    r"""
    Wrapper for `fz_md5_buffer()`.
    Create an MD5 digest from buffer contents.

    Never throws exceptions.
    """
    return _mupdf.md5_buffer(buffer, digest)

def md5_final(state, digest):
    r"""
    Wrapper for `fz_md5_final()`.
    MD5 finalization. Ends an MD5 message-digest operation, writing
    the message digest and zeroizing the context.

    Never throws an exception.
    """
    return _mupdf.md5_final(state, digest)

def md5_init(state):
    r"""
    Wrapper for `fz_md5_init()`.
    MD5 initialization. Begins an MD5 operation, writing a new
    context.

    Never throws an exception.
    """
    return _mupdf.md5_init(state)

def md5_pixmap(pixmap, digest):
    r""" Wrapper for `fz_md5_pixmap()`."""
    return _mupdf.md5_pixmap(pixmap, digest)

def md5_update(state, input, inlen):
    r"""
    Wrapper for `fz_md5_update()`.
    MD5 block update operation. Continues an MD5 message-digest
    operation, processing another message block, and updating the
    context.

    Never throws an exception.
    """
    return _mupdf.md5_update(state, input, inlen)

def md5_update_int64(state, i):
    r"""
    Wrapper for `fz_md5_update_int64()`.
    MD5 block update operation. Continues an MD5 message-digest
    operation, processing an int64, and updating the context.

    Never throws an exception.
    """
    return _mupdf.md5_update_int64(state, i)

def measure_string(user_font, trm, s, wmode, bidi_level, markup_dir, language):
    r"""
    Wrapper for `fz_measure_string()`.
    Measure the advance width of a UTF8 string should it be added to a text object.

    This uses the same layout algorithms as fz_show_string, and can be used
    to calculate text alignment adjustments.
    """
    return _mupdf.measure_string(user_font, trm, s, wmode, bidi_level, markup_dir, language)

def memmem(haystack, haystacklen, needle, needlelen):
    r"""
    Wrapper for `fz_memmem()`.
    Find the start of the first occurrence of the substring needle in haystack.
    """
    return _mupdf.memmem(haystack, haystacklen, needle, needlelen)

def memrnd(block, len):
    r"""
    Wrapper for `fz_memrnd()`.
    Fill block with len bytes of pseudo-randomness.
    """
    return _mupdf.memrnd(block, len)

def min(a, b):
    r""" Wrapper for `fz_min()`."""
    return _mupdf.min(a, b)

def mini(a, b):
    r""" Wrapper for `fz_mini()`."""
    return _mupdf.mini(a, b)

def mini64(a, b):
    r""" Wrapper for `fz_mini64()`."""
    return _mupdf.mini64(a, b)

def minz(a, b):
    r""" Wrapper for `fz_minz()`."""
    return _mupdf.minz(a, b)

def moveto(path, x, y):
    r"""
    Wrapper for `fz_moveto()`.
    Append a 'moveto' command to a path.
    This 'opens' a path.

    path: The path to modify.

    x, y: The coordinate to move to.

    Throws exceptions on failure to allocate, or attempting to
    modify a packed path.
    """
    return _mupdf.moveto(path, x, y)

def mul255(a, b):
    r"""
    Wrapper for `fz_mul255()`.
    Multiply scaled two integers in the 0..255 range
    """
    return _mupdf.mul255(a, b)

def needs_password(doc):
    r"""
    Wrapper for `fz_needs_password()`.
    Check if a document is encrypted with a
    non-blank password.
    """
    return _mupdf.needs_password(doc)

def new_arc4_output(chain, key, keylen):
    r""" Wrapper for `fz_new_arc4_output()`."""
    return _mupdf.new_arc4_output(chain, key, keylen)

def new_archive_of_size(file, size):
    r""" Wrapper for `fz_new_archive_of_size()`."""
    return _mupdf.new_archive_of_size(file, size)

def new_ascii85_output(chain):
    r""" Wrapper for `fz_new_ascii85_output()`."""
    return _mupdf.new_ascii85_output(chain)

def new_asciihex_output(chain):
    r"""
    Wrapper for `fz_new_asciihex_output()`.
    Compression and other filtering outputs.

    These outputs write encoded data to another output. Create a
    filter output with the destination, write to the filter, then
    close and drop it when you're done. These can also be chained
    together, for example to write ASCII Hex encoded, Deflate
    compressed, and RC4 encrypted data to a buffer output.

    Output streams don't use reference counting, so make sure to
    close all of the filters in the reverse order of creation so
    that data is flushed properly.

    Accordingly, ownership of 'chain' is never passed into the
    following functions, but remains with the caller, whose
    responsibility it is to ensure they exist at least until
    the returned fz_output is dropped.
    """
    return _mupdf.new_asciihex_output(chain)

def new_band_writer_of_size(size, out):
    r""" Wrapper for `fz_new_band_writer_of_size()`."""
    return _mupdf.new_band_writer_of_size(size, out)

def new_base14_font(name):
    r"""
    Wrapper for `fz_new_base14_font()`.
    Create a new font from one of the built-in fonts.
    """
    return _mupdf.new_base14_font(name)

def new_bbox_device(rectp):
    r"""
    Wrapper for `fz_new_bbox_device()`.
    Create a device to compute the bounding
    box of all marks on a page.

    The returned bounding box will be the union of all bounding
    boxes of all objects on a page.
    """
    return _mupdf.new_bbox_device(rectp)

def new_bitmap(w, h, n, xres, yres):
    r"""
    Wrapper for `fz_new_bitmap()`.
    Create a new bitmap.

    w, h: Width and Height for the bitmap

    n: Number of color components (assumed to be a divisor of 8)

    xres, yres: X and Y resolutions (in pixels per inch).

    Returns pointer to created bitmap structure. The bitmap
    data is uninitialised.
    """
    return _mupdf.new_bitmap(w, h, n, xres, yres)

def new_bitmap_from_pixmap(pix, ht):
    r"""
    Wrapper for `fz_new_bitmap_from_pixmap()`.
    Make a bitmap from a pixmap and a halftone.

    pix: The pixmap to generate from. Currently must be a single
    color component with no alpha.

    ht: The halftone to use. NULL implies the default halftone.

    Returns the resultant bitmap. Throws exceptions in the case of
    failure to allocate.
    """
    return _mupdf.new_bitmap_from_pixmap(pix, ht)

def new_bitmap_from_pixmap_band(pix, ht, band_start):
    r"""
    Wrapper for `fz_new_bitmap_from_pixmap_band()`.
    Make a bitmap from a pixmap and a
    halftone, allowing for the position of the pixmap within an
    overall banded rendering.

    pix: The pixmap to generate from. Currently must be a single
    color component with no alpha.

    ht: The halftone to use. NULL implies the default halftone.

    band_start: Vertical offset within the overall banded rendering
    (in pixels)

    Returns the resultant bitmap. Throws exceptions in the case of
    failure to allocate.
    """
    return _mupdf.new_bitmap_from_pixmap_band(pix, ht, band_start)

def new_buffer(capacity):
    r""" Wrapper for `fz_new_buffer()`."""
    return _mupdf.new_buffer(capacity)

def new_buffer_from_base64(data, size):
    r"""
    Wrapper for `fz_new_buffer_from_base64()`.
    Create a new buffer with data decoded from a base64 input string.
    """
    return _mupdf.new_buffer_from_base64(data, size)

def new_buffer_from_copied_data(data, size):
    r"""
    Wrapper for `fz_new_buffer_from_copied_data()`.
    Create a new buffer containing a copy of the passed data.
    """
    return _mupdf.new_buffer_from_copied_data(data, size)

def new_buffer_from_data(data, size):
    r"""
    Wrapper for `fz_new_buffer_from_data()`.
    Create a new buffer with existing data.

    data: Pointer to existing data.
    size: Size of existing data.

    Takes ownership of data. Does not make a copy. Calls fz_free on
    the data when the buffer is deallocated. Do not use 'data' after
    passing to this function.

    Returns pointer to new buffer. Throws exception on allocation
    failure.
    """
    return _mupdf.new_buffer_from_data(data, size)

def new_buffer_from_display_list(list, options):
    r""" Wrapper for `fz_new_buffer_from_display_list()`."""
    return _mupdf.new_buffer_from_display_list(list, options)

def new_buffer_from_image_as_png(image, color_params):
    r"""
    Wrapper for `fz_new_buffer_from_image_as_png()`.
    Reencode a given image as a PNG into a buffer.

    Ownership of the buffer is returned.
    """
    return _mupdf.new_buffer_from_image_as_png(image, color_params)

def new_buffer_from_page(page, options):
    r""" Wrapper for `fz_new_buffer_from_page()`."""
    return _mupdf.new_buffer_from_page(page, options)

def new_buffer_from_page_number(doc, number, options):
    r""" Wrapper for `fz_new_buffer_from_page_number()`."""
    return _mupdf.new_buffer_from_page_number(doc, number, options)

def new_buffer_from_page_with_format(page, format, options, transform, cookie):
    r"""
    Wrapper for `fz_new_buffer_from_page_with_format()`.
    Returns an fz_buffer containing a page after conversion to specified format.

    page: The page to convert.
    format, options: Passed to fz_new_document_writer_with_output() internally.
    transform, cookie: Passed to fz_run_page() internally.
    """
    return _mupdf.new_buffer_from_page_with_format(page, format, options, transform, cookie)

def new_buffer_from_pixmap_as_png(pixmap, color_params):
    r"""
    Wrapper for `fz_new_buffer_from_pixmap_as_png()`.
    Reencode a given pixmap as a PNG into a buffer.

    Ownership of the buffer is returned.
    """
    return _mupdf.new_buffer_from_pixmap_as_png(pixmap, color_params)

def new_buffer_from_shared_data(data, size):
    r"""
    Wrapper for `fz_new_buffer_from_shared_data()`.
    Like fz_new_buffer, but does not take ownership.
    """
    return _mupdf.new_buffer_from_shared_data(data, size)

def new_buffer_from_stext_page(text):
    r"""
    Wrapper for `fz_new_buffer_from_stext_page()`.
    Convert structured text into plain text.
    """
    return _mupdf.new_buffer_from_stext_page(text)

def new_builtin_font(name, is_bold, is_italic):
    r""" Wrapper for `fz_new_builtin_font()`."""
    return _mupdf.new_builtin_font(name, is_bold, is_italic)

def new_cal_gray_colorspace(wp, bp, gamma):
    r"""
    Wrapper for `fz_new_cal_gray_colorspace()`.
    Create a calibrated gray colorspace.

    The returned reference should be dropped when it is finished
    with.

    Colorspaces are immutable once created.
    """
    return _mupdf.new_cal_gray_colorspace(wp, bp, gamma)

def new_cal_rgb_colorspace(wp, bp, gamma, matrix):
    r"""
    Wrapper for `fz_new_cal_rgb_colorspace()`.
    Create a calibrated rgb colorspace.

    The returned reference should be dropped when it is finished
    with.

    Colorspaces are immutable once created.
    """
    return _mupdf.new_cal_rgb_colorspace(wp, bp, gamma, matrix)

def new_cbz_writer(path, options):
    r""" Wrapper for `fz_new_cbz_writer()`."""
    return _mupdf.new_cbz_writer(path, options)

def new_cbz_writer_with_output(out, options):
    r""" Wrapper for `fz_new_cbz_writer_with_output()`."""
    return _mupdf.new_cbz_writer_with_output(out, options)

def new_cjk_font(ordering):
    r""" Wrapper for `fz_new_cjk_font()`."""
    return _mupdf.new_cjk_font(ordering)

def new_color_pcl_band_writer(out, options):
    r"""
    Wrapper for `fz_new_color_pcl_band_writer()`.
    Create a new band writer, outputing color pcl.
    """
    return _mupdf.new_color_pcl_band_writer(out, options)

def new_colorspace(type, flags, n, name):
    r"""
    Wrapper for `fz_new_colorspace()`.
    Creates a new colorspace instance and returns a reference.

    No internal checking is done that the colorspace type (e.g.
    CMYK) matches with the flags (e.g. FZ_COLORSPACE_HAS_CMYK) or
    colorant count (n) or name.

    The reference should be dropped when it is finished with.

    Colorspaces are immutable once created (with the exception of
    setting up colorant names for separation spaces).
    """
    return _mupdf.new_colorspace(type, flags, n, name)

def new_context_imp(alloc, locks, max_store, version):
    r""" Wrapper for `fz_new_context_imp()`."""
    return _mupdf.new_context_imp(alloc, locks, max_store, version)

def new_default_colorspaces():
    r"""
    Wrapper for `fz_new_default_colorspaces()`.
    Create a new default colorspace structure with values inherited
    from the context, and return a reference to it.

    These can be overridden using fz_set_default_xxxx.

    These should not be overridden while more than one caller has
    the reference for fear of race conditions.

    The caller should drop this reference once finished with it.
    """
    return _mupdf.new_default_colorspaces()

def new_deflate_output(chain, effort, raw):
    r""" Wrapper for `fz_new_deflate_output()`."""
    return _mupdf.new_deflate_output(chain, effort, raw)

def new_deflated_data(source, source_length, level):
    r"""
     Wrapper for `fz_new_deflated_data()`.

    This function has out-params. Python/C# wrappers look like:
    	`new_deflated_data(const unsigned char *source, size_t source_length, fz_deflate_level level)` => `(unsigned char *, size_t compressed_length)`

    	Compress source_length bytes of data starting
    	at source, into a new memory block malloced for that purpose.
    compressed_length is updated on exit to contain the size used.
    	Ownership of the block is returned from this function, and the
    	caller is therefore responsible for freeing it. The block may be
    	considerably larger than is actually required. The caller is
    	free to fz_realloc it down if it wants to.
    """
    return _mupdf.new_deflated_data(source, source_length, level)

def new_deflated_data_from_buffer(buffer, level):
    r"""
     Wrapper for `fz_new_deflated_data_from_buffer()`.

    This function has out-params. Python/C# wrappers look like:
    	`new_deflated_data_from_buffer(fz_buffer *buffer, fz_deflate_level level)` => `(unsigned char *, size_t compressed_length)`

    	Compress the contents of a fz_buffer into a
    	new block malloced for that purpose. *compressed_length is
    	updated on exit to contain the size used. Ownership of the block
    	is returned from this function, and the caller is therefore
    	responsible for freeing it. The block may be considerably larger
    	than is actually required. The caller is free to fz_realloc it
    	down if it wants to.
    """
    return _mupdf.new_deflated_data_from_buffer(buffer, level)

def new_device_of_size(size):
    r"""
    Wrapper for `fz_new_device_of_size()`.
    Devices are created by calls to device implementations, for
    instance: foo_new_device(). These will be implemented by calling
    fz_new_derived_device(ctx, foo_device) where foo_device is a
    structure "derived from" fz_device, for instance
    typedef struct { fz_device base;  ...extras...} foo_device;
    """
    return _mupdf.new_device_of_size(size)

def new_display_list(mediabox):
    r"""
    Wrapper for `fz_new_display_list()`.
    Create an empty display list.

    A display list contains drawing commands (text, images, etc.).
    Use fz_new_list_device for populating the list.

    mediabox: Bounds of the page (in points) represented by the
    display list.
    """
    return _mupdf.new_display_list(mediabox)

def new_display_list_from_page(page):
    r"""
    Wrapper for `fz_new_display_list_from_page()`.
    Create a display list.

    Ownership of the display list is returned to the caller.
    """
    return _mupdf.new_display_list_from_page(page)

def new_display_list_from_page_contents(page):
    r"""
    Wrapper for `fz_new_display_list_from_page_contents()`.
    Create a display list from page contents (no annotations).

    Ownership of the display list is returned to the caller.
    """
    return _mupdf.new_display_list_from_page_contents(page)

def new_display_list_from_page_number(doc, number):
    r""" Wrapper for `fz_new_display_list_from_page_number()`."""
    return _mupdf.new_display_list_from_page_number(doc, number)

def new_display_list_from_svg(buf, base_uri, zip):
    r"""
     Wrapper for `fz_new_display_list_from_svg()`.

    This function has out-params. Python/C# wrappers look like:
    	`new_display_list_from_svg(fz_buffer *buf, const char *base_uri, fz_archive *zip)` => `(fz_display_list *, float w, float h)`

    	Parse an SVG document into a display-list.
    """
    return _mupdf.new_display_list_from_svg(buf, base_uri, zip)

def new_display_list_from_svg_xml(xmldoc, xml, base_uri, zip):
    r"""
     Wrapper for `fz_new_display_list_from_svg_xml()`.

    This function has out-params. Python/C# wrappers look like:
    	`new_display_list_from_svg_xml(fz_xml_doc *xmldoc, fz_xml *xml, const char *base_uri, fz_archive *zip)` => `(fz_display_list *, float w, float h)`

    	Parse an SVG document into a display-list.
    """
    return _mupdf.new_display_list_from_svg_xml(xmldoc, xml, base_uri, zip)

def new_document_of_size(size):
    r"""
    Wrapper for `fz_new_document_of_size()`.
    New documents are typically created by calls like
    foo_new_document(fz_context *ctx, ...). These work by
    deriving a new document type from fz_document, for instance:
    typedef struct { fz_document base; ...extras... } foo_document;
    These are allocated by calling
    fz_new_derived_document(ctx, foo_document)
    """
    return _mupdf.new_document_of_size(size)

def new_document_writer(path, format, options):
    r"""
    Wrapper for `fz_new_document_writer()`.
    Create a new fz_document_writer, for a
    file of the given type.

    path: The document name to write (or NULL for default)

    format: Which format to write (currently cbz, html, pdf, pam,
    pbm, pgm, pkm, png, ppm, pnm, svg, text, xhtml, docx, odt)

    options: NULL, or pointer to comma separated string to control
    file generation.
    """
    return _mupdf.new_document_writer(path, format, options)

def new_document_writer_of_size(size, begin_page, end_page, close, drop):
    r"""
    Wrapper for `fz_new_document_writer_of_size()`.
    Internal function to allocate a
    block for a derived document_writer structure, with the base
    structure's function pointers populated correctly, and the extra
    space zero initialised.
    """
    return _mupdf.new_document_writer_of_size(size, begin_page, end_page, close, drop)

def new_document_writer_with_output(out, format, options):
    r"""
    Wrapper for `fz_new_document_writer_with_output()`.
    Like fz_new_document_writer but takes a fz_output for writing
    the result. Only works for multi-page formats.
    """
    return _mupdf.new_document_writer_with_output(out, format, options)

def new_docx_writer(path, options):
    r""" Wrapper for `fz_new_docx_writer()`."""
    return _mupdf.new_docx_writer(path, options)

def new_docx_writer_with_output(out, options):
    r""" Wrapper for `fz_new_docx_writer_with_output()`."""
    return _mupdf.new_docx_writer_with_output(out, options)

def new_draw_device(transform, dest):
    r"""
    Wrapper for `fz_new_draw_device()`.
    Create a device to draw on a pixmap.

    dest: Target pixmap for the draw device. See fz_new_pixmap*
    for how to obtain a pixmap. The pixmap is not cleared by the
    draw device, see fz_clear_pixmap* for how to clear it prior to
    calling fz_new_draw_device. Free the device by calling
    fz_drop_device.

    transform: Transform from user space in points to device space
    in pixels.
    """
    return _mupdf.new_draw_device(transform, dest)

def new_draw_device_type3(transform, dest):
    r""" Wrapper for `fz_new_draw_device_type3()`."""
    return _mupdf.new_draw_device_type3(transform, dest)

def new_draw_device_with_bbox(transform, dest, clip):
    r"""
    Wrapper for `fz_new_draw_device_with_bbox()`.
    Create a device to draw on a pixmap.

    dest: Target pixmap for the draw device. See fz_new_pixmap*
    for how to obtain a pixmap. The pixmap is not cleared by the
    draw device, see fz_clear_pixmap* for how to clear it prior to
    calling fz_new_draw_device. Free the device by calling
    fz_drop_device.

    transform: Transform from user space in points to device space
    in pixels.

    clip: Bounding box to restrict any marking operations of the
    draw device.
    """
    return _mupdf.new_draw_device_with_bbox(transform, dest, clip)

def new_draw_device_with_bbox_proof(transform, dest, clip, cs):
    r"""
    Wrapper for `fz_new_draw_device_with_bbox_proof()`.
    Create a device to draw on a pixmap.

    dest: Target pixmap for the draw device. See fz_new_pixmap*
    for how to obtain a pixmap. The pixmap is not cleared by the
    draw device, see fz_clear_pixmap* for how to clear it prior to
    calling fz_new_draw_device. Free the device by calling
    fz_drop_device.

    transform: Transform from user space in points to device space
    in pixels.

    clip: Bounding box to restrict any marking operations of the
    draw device.

    proof_cs: Color space to render to prior to mapping to color
    space defined by pixmap.
    """
    return _mupdf.new_draw_device_with_bbox_proof(transform, dest, clip, cs)

def new_draw_device_with_options(options, mediabox, OUTPUT):
    r"""
     Wrapper for `fz_new_draw_device_with_options()`.

    This function has out-params. Python/C# wrappers look like:
    	`new_draw_device_with_options(const fz_draw_options *options, fz_rect mediabox, fz_pixmap **pixmap)` => `(fz_device *)`

    	Create a new pixmap and draw device, using the specified options.

    	options: Options to configure the draw device, and choose the
    	resolution and colorspace.

    	mediabox: The bounds of the page in points.

    	pixmap: An out parameter containing the newly created pixmap.
    """
    return _mupdf.new_draw_device_with_options(options, mediabox, OUTPUT)

def new_draw_device_with_proof(transform, dest, proof_cs):
    r"""
    Wrapper for `fz_new_draw_device_with_proof()`.
    Create a device to draw on a pixmap.

    dest: Target pixmap for the draw device. See fz_new_pixmap*
    for how to obtain a pixmap. The pixmap is not cleared by the
    draw device, see fz_clear_pixmap* for how to clear it prior to
    calling fz_new_draw_device. Free the device by calling
    fz_drop_device.

    transform: Transform from user space in points to device space
    in pixels.

    proof_cs: Intermediate color space to map though when mapping to
    color space defined by pixmap.
    """
    return _mupdf.new_draw_device_with_proof(transform, dest, proof_cs)

def new_font_from_buffer(name, buffer, index, use_glyph_bbox):
    r"""
    Wrapper for `fz_new_font_from_buffer()`.
    Create a new font from a font file in a fz_buffer.

    name: Name of font (leave NULL to use name from font).

    buffer: Buffer to load from.

    index: Which font from the file to load (0 for default).

    use_glyph_box: 1 if we should use the glyph bbox, 0 otherwise.

    Returns new font handle, or throws exception on error.
    """
    return _mupdf.new_font_from_buffer(name, buffer, index, use_glyph_bbox)

def new_font_from_file(name, path, index, use_glyph_bbox):
    r"""
    Wrapper for `fz_new_font_from_file()`.
    Create a new font from a font file.

    name: Name of font (leave NULL to use name from font).

    path: File path to load from.

    index: Which font from the file to load (0 for default).

    use_glyph_box: 1 if we should use the glyph bbox, 0 otherwise.

    Returns new font handle, or throws exception on error.
    """
    return _mupdf.new_font_from_file(name, path, index, use_glyph_bbox)

def new_font_from_memory(name, data, len, index, use_glyph_bbox):
    r"""
    Wrapper for `fz_new_font_from_memory()`.
    Create a new font from a font
    file in memory.

    name: Name of font (leave NULL to use name from font).

    data: Pointer to the font file data.

    len: Length of the font file data.

    index: Which font from the file to load (0 for default).

    use_glyph_box: 1 if we should use the glyph bbox, 0 otherwise.

    Returns new font handle, or throws exception on error.
    """
    return _mupdf.new_font_from_memory(name, data, len, index, use_glyph_bbox)

def new_hash_table(initialsize, keylen, lock, drop_val):
    r"""
    Wrapper for `fz_new_hash_table()`.
    Create a new hash table.

    initialsize: The initial size of the hashtable. The hashtable
    may grow (double in size) if it starts to get crowded (80%
    full).

    keylen: byte length for each key.

    lock: -1 for no lock, otherwise the FZ_LOCK to use to protect
    this table.

    drop_val: Function to use to destroy values on table drop.
    """
    return _mupdf.new_hash_table(initialsize, keylen, lock, drop_val)

def new_icc_colorspace(type, flags, name, buf):
    r"""
    Wrapper for `fz_new_icc_colorspace()`.
    Create a colorspace from an ICC profile supplied in buf.

    Limited checking is done to ensure that the colorspace type is
    appropriate for the supplied ICC profile.

    An additional reference is taken to buf, which will be dropped
    on destruction. Ownership is NOT passed in.

    The returned reference should be dropped when it is finished
    with.

    Colorspaces are immutable once created.
    """
    return _mupdf.new_icc_colorspace(type, flags, name, buf)

def new_image_from_buffer(buffer):
    r"""
    Wrapper for `fz_new_image_from_buffer()`.
    Create a new image from a
    buffer of data, inferring its type from the format
    of the data.
    """
    return _mupdf.new_image_from_buffer(buffer)

def new_image_from_compressed_buffer(w, h, bpc, colorspace, xres, yres, interpolate, imagemask, buffer, mask):
    r"""
     Wrapper for `fz_new_image_from_compressed_buffer()`.

    This function has out-params. Python/C# wrappers look like:
    	`new_image_from_compressed_buffer(int w, int h, int bpc, fz_colorspace *colorspace, int xres, int yres, int interpolate, int imagemask, fz_compressed_buffer *buffer, fz_image *mask)` => `(fz_image *, float decode, int colorkey)`

    	Create an image based on
    	the data in the supplied compressed buffer.

    	w,h: Width and height of the created image.

    	bpc: Bits per component.

    	colorspace: The colorspace (determines the number of components,
    	and any color conversions required while decoding).

    	xres, yres: The X and Y resolutions respectively.

    	interpolate: 1 if interpolation should be used when decoding
    	this image, 0 otherwise.

    	imagemask: 1 if this is an imagemask (i.e. transparency bitmap
    	mask), 0 otherwise.

    	decode: NULL, or a pointer to to a decode array. The default
    	decode array is [0 1] (repeated n times, for n color components).

    	colorkey: NULL, or a pointer to a colorkey array. The default
    	colorkey array is [0 255] (repeated n times, for n color
    	components).

    	buffer: Buffer of compressed data and compression parameters.
    	Ownership of this reference is passed in.

    	mask: NULL, or another image to use as a mask for this one.
    	A new reference is taken to this image. Supplying a masked
    	image as a mask to another image is illegal!
    """
    return _mupdf.new_image_from_compressed_buffer(w, h, bpc, colorspace, xres, yres, interpolate, imagemask, buffer, mask)

def new_image_from_display_list(w, h, list):
    r"""
    Wrapper for `fz_new_image_from_display_list()`.
    Create a new image from a display list.

    w, h: The conceptual width/height of the image.

    transform: The matrix that needs to be applied to the given
    list to make it render to the unit square.

    list: The display list.
    """
    return _mupdf.new_image_from_display_list(w, h, list)

def new_image_from_file(path):
    r"""
    Wrapper for `fz_new_image_from_file()`.
    Create a new image from the contents
    of a file, inferring its type from the format of the
    data.
    """
    return _mupdf.new_image_from_file(path)

def new_image_from_pixmap(pixmap, mask):
    r"""
    Wrapper for `fz_new_image_from_pixmap()`.
    Create an image from the given
    pixmap.

    pixmap: The pixmap to base the image upon. A new reference
    to this is taken.

    mask: NULL, or another image to use as a mask for this one.
    A new reference is taken to this image. Supplying a masked
    image as a mask to another image is illegal!
    """
    return _mupdf.new_image_from_pixmap(pixmap, mask)

def new_image_from_svg(buf, base_uri, zip):
    r"""
    Wrapper for `fz_new_image_from_svg()`.
    Create a scalable image from an SVG document.
    """
    return _mupdf.new_image_from_svg(buf, base_uri, zip)

def new_image_from_svg_xml(xmldoc, xml, base_uri, zip):
    r"""
    Wrapper for `fz_new_image_from_svg_xml()`.
    Create a scalable image from an SVG document.
    """
    return _mupdf.new_image_from_svg_xml(xmldoc, xml, base_uri, zip)

def new_image_of_size(w, h, bpc, colorspace, xres, yres, interpolate, imagemask, mask, size, get_pixmap, get_size, drop):
    r"""
     Wrapper for `fz_new_image_of_size()`.

    This function has out-params. Python/C# wrappers look like:
    	`new_image_of_size(int w, int h, int bpc, fz_colorspace *colorspace, int xres, int yres, int interpolate, int imagemask, fz_image *mask, size_t size, fz_image_get_pixmap_fn *get_pixmap, fz_image_get_size_fn *get_size, fz_drop_image_fn *drop)` => `(fz_image *, float decode, int colorkey)`

    	Internal function to make a new fz_image structure
    	for a derived class.

    	w,h: Width and height of the created image.

    	bpc: Bits per component.

    	colorspace: The colorspace (determines the number of components,
    	and any color conversions required while decoding).

    	xres, yres: The X and Y resolutions respectively.

    	interpolate: 1 if interpolation should be used when decoding
    	this image, 0 otherwise.

    	imagemask: 1 if this is an imagemask (i.e. transparent), 0
    	otherwise.

    	decode: NULL, or a pointer to to a decode array. The default
    	decode array is [0 1] (repeated n times, for n color components).

    	colorkey: NULL, or a pointer to a colorkey array. The default
    	colorkey array is [0 255] (repeated n times, for n color
    	components).

    	mask: NULL, or another image to use as a mask for this one.
    	A new reference is taken to this image. Supplying a masked
    	image as a mask to another image is illegal!

    	size: The size of the required allocated structure (the size of
    	the derived structure).

    	get: The function to be called to obtain a decoded pixmap.

    	get_size: The function to be called to return the storage size
    	used by this image.

    	drop: The function to be called to dispose of this image once
    	the last reference is dropped.

    	Returns a pointer to an allocated structure of the required size,
    	with the first sizeof(fz_image) bytes initialised as appropriate
    	given the supplied parameters, and the other bytes set to zero.
    """
    return _mupdf.new_image_of_size(w, h, bpc, colorspace, xres, yres, interpolate, imagemask, mask, size, get_pixmap, get_size, drop)

def new_indexed_colorspace(base, high, lookup):
    r"""
    Wrapper for `fz_new_indexed_colorspace()`.
    Create an indexed colorspace.

    The supplied lookup table is high palette entries long. Each
    entry is n bytes long, where n is given by the number of
    colorants in the base colorspace, one byte per colorant.

    Ownership of lookup is passed it; it will be freed on
    destruction, so must be heap allocated.

    The colorspace will keep an additional reference to the base
    colorspace that will be dropped on destruction.

    The returned reference should be dropped when it is finished
    with.

    Colorspaces are immutable once created.
    """
    return _mupdf.new_indexed_colorspace(base, high, lookup)

def new_layout():
    r"""
    Wrapper for `fz_new_layout()`.
    Create a new layout block, with new allocation pool, zero
    matrices, and initialise linked pointers.
    """
    return _mupdf.new_layout()

def new_link(bbox, uri):
    r"""
    Wrapper for `fz_new_link()`.
    Create a new link record.

    next is set to NULL with the expectation that the caller will
    handle the linked list setup.

    Internal function.
    """
    return _mupdf.new_link(bbox, uri)

def new_list_device(list):
    r"""
    Wrapper for `fz_new_list_device()`.
    Create a rendering device for a display list.

    When the device is rendering a page it will populate the
    display list with drawing commands (text, images, etc.). The
    display list can later be reused to render a page many times
    without having to re-interpret the page from the document file
    for each rendering. Once the device is no longer needed, free
    it with fz_drop_device.

    list: A display list that the list device takes a reference to.
    """
    return _mupdf.new_list_device(list)

def new_log_for_module(module):
    r"""
    Wrapper for `fz_new_log_for_module()`.
    Internal function to actually do the opening of the logfile.

    Caller should close/drop the output when finished with it.
    """
    return _mupdf.new_log_for_module(module)

def new_mono_pcl_band_writer(out, options):
    r"""
    Wrapper for `fz_new_mono_pcl_band_writer()`.
    Create a new band writer, outputing monochrome pcl.
    """
    return _mupdf.new_mono_pcl_band_writer(out, options)

def new_mono_pwg_band_writer(out, pwg):
    r"""
    Wrapper for `fz_new_mono_pwg_band_writer()`.
    Create a new monochrome pwg band writer.
    """
    return _mupdf.new_mono_pwg_band_writer(out, pwg)

def new_ocr_device(target, ctm, mediabox, with_list, language, datadir, progress, progress_arg):
    r"""
    Wrapper for `fz_new_ocr_device()`.
    Create a device to OCR the text on the page.

    Renders the page internally to a bitmap that is then OCRd. Text
    is then forwarded onto the target device.

    target: The target device to receive the OCRd text.

    ctm: The transform to apply to the mediabox to get the size for
    the rendered page image. Also used to calculate the resolution
    for the page image. In general, this will be the same as the CTM
    that you pass to fz_run_page (or fz_run_display_list) to feed
    this device.

    mediabox: The mediabox (in points). Combined with the CTM to get
    the bounds of the pixmap used internally for the rendered page
    image.

    with_list: If with_list is false, then all non-text operations
    are forwarded instantly to the target device. This results in
    the target device seeing all NON-text operations, followed by
    all the text operations (derived from OCR).

    If with_list is true, then all the marking operations are
    collated into a display list which is then replayed to the
    target device at the end.

    language: NULL (for "eng"), or a pointer to a string to describe
    the languages/scripts that should be used for OCR (e.g.
    "eng,ara").

    datadir: NULL (for ""), or a pointer to a path string otherwise
    provided to Tesseract in the TESSDATA_PREFIX environment variable.

    progress: NULL, or function to be called periodically to indicate
    progress. Return 0 to continue, or 1 to cancel. progress_arg is
    returned as the void *. The int is a value between 0 and 100 to
    indicate progress.

    progress_arg: A void * value to be parrotted back to the progress
    function.
    """
    return _mupdf.new_ocr_device(target, ctm, mediabox, with_list, language, datadir, progress, progress_arg)

def new_odt_writer(path, options):
    r""" Wrapper for `fz_new_odt_writer()`."""
    return _mupdf.new_odt_writer(path, options)

def new_odt_writer_with_output(out, options):
    r""" Wrapper for `fz_new_odt_writer_with_output()`."""
    return _mupdf.new_odt_writer_with_output(out, options)

def new_outline():
    r"""
    Wrapper for `fz_new_outline()`.
    Create a new outline entry with zeroed fields for the caller
    to fill in.
    """
    return _mupdf.new_outline()

def new_outline_iterator(doc):
    r"""
    Wrapper for `fz_new_outline_iterator()`.
    Get an iterator for the document outline.

    Should be freed by fz_drop_outline_iterator.
    """
    return _mupdf.new_outline_iterator(doc)

def new_outline_iterator_of_size(size, doc):
    r""" Wrapper for `fz_new_outline_iterator_of_size()`."""
    return _mupdf.new_outline_iterator_of_size(size, doc)

def new_output(bufsiz, state, write, close, drop):
    r"""
    Wrapper for `fz_new_output()`.
    Create a new output object with the given
    internal state and function pointers.

    state: Internal state (opaque to everything but implementation).

    write: Function to output a given buffer.

    close: Cleanup function to destroy state when output closed.
    May permissibly be null.
    """
    return _mupdf.new_output(bufsiz, state, write, close, drop)

def new_output_with_buffer(buf):
    r"""
    Wrapper for `fz_new_output_with_buffer()`.
    Open an output stream that appends
    to a buffer.

    buf: The buffer to append to.
    """
    return _mupdf.new_output_with_buffer(buf)

def new_output_with_path(filename, append):
    r"""
    Wrapper for `fz_new_output_with_path()`.
    Open an output stream that writes to a
    given path.

    filename: The filename to write to (specified in UTF-8).

    append: non-zero if we should append to the file, rather than
    overwriting it.
    """
    return _mupdf.new_output_with_path(filename, append)

def new_page_of_size(size, doc):
    r"""
    Wrapper for `fz_new_page_of_size()`.
    Different document types will be implemented by deriving from
    fz_page. This macro allocates such derived structures, and
    initialises the base sections.
    """
    return _mupdf.new_page_of_size(size, doc)

def new_pam_band_writer(out):
    r"""
    Wrapper for `fz_new_pam_band_writer()`.
    Create a band writer targetting pnm (greyscale, rgb or cmyk,
    with or without alpha).
    """
    return _mupdf.new_pam_band_writer(out)

def new_pam_pixmap_writer(path, options):
    r""" Wrapper for `fz_new_pam_pixmap_writer()`."""
    return _mupdf.new_pam_pixmap_writer(path, options)

def new_path():
    r"""
    Wrapper for `fz_new_path()`.
    Create a new (empty) path structure.
    """
    return _mupdf.new_path()

def new_pbm_band_writer(out):
    r"""
    Wrapper for `fz_new_pbm_band_writer()`.
    Create a new band writer, targetting pbm.
    """
    return _mupdf.new_pbm_band_writer(out)

def new_pbm_pixmap_writer(path, options):
    r""" Wrapper for `fz_new_pbm_pixmap_writer()`."""
    return _mupdf.new_pbm_pixmap_writer(path, options)

def new_pcl_writer(path, options):
    r""" Wrapper for `fz_new_pcl_writer()`."""
    return _mupdf.new_pcl_writer(path, options)

def new_pcl_writer_with_output(out, options):
    r""" Wrapper for `fz_new_pcl_writer_with_output()`."""
    return _mupdf.new_pcl_writer_with_output(out, options)

def new_pclm_band_writer(out, options):
    r"""
    Wrapper for `fz_new_pclm_band_writer()`.
    Create a new band writer, outputing pclm
    """
    return _mupdf.new_pclm_band_writer(out, options)

def new_pclm_writer(path, options):
    r""" Wrapper for `fz_new_pclm_writer()`."""
    return _mupdf.new_pclm_writer(path, options)

def new_pclm_writer_with_output(out, options):
    r""" Wrapper for `fz_new_pclm_writer_with_output()`."""
    return _mupdf.new_pclm_writer_with_output(out, options)

def new_pdf_writer(path, options):
    r"""
    Wrapper for `fz_new_pdf_writer()`.
    Document writers for various possible output formats.

    All of the "_with_output" variants pass the ownership of out in
    immediately upon calling. The writers are responsible for
    dropping the fz_output when they are finished with it (even
    if they throw an exception during creation).
    """
    return _mupdf.new_pdf_writer(path, options)

def new_pdf_writer_with_output(out, options):
    r""" Wrapper for `fz_new_pdf_writer_with_output()`."""
    return _mupdf.new_pdf_writer_with_output(out, options)

def new_pdfocr_band_writer(out, options):
    r"""
    Wrapper for `fz_new_pdfocr_band_writer()`.
    Create a new band writer, outputing pdfocr.

    Ownership of output stays with the caller, the band writer
    borrows the reference. The caller must keep the output around
    for the duration of the band writer, and then close/drop as
    appropriate.
    """
    return _mupdf.new_pdfocr_band_writer(out, options)

def new_pdfocr_writer(path, options):
    r""" Wrapper for `fz_new_pdfocr_writer()`."""
    return _mupdf.new_pdfocr_writer(path, options)

def new_pdfocr_writer_with_output(out, options):
    r""" Wrapper for `fz_new_pdfocr_writer_with_output()`."""
    return _mupdf.new_pdfocr_writer_with_output(out, options)

def new_pgm_pixmap_writer(path, options):
    r""" Wrapper for `fz_new_pgm_pixmap_writer()`."""
    return _mupdf.new_pgm_pixmap_writer(path, options)

def new_pixmap(cs, w, h, seps, alpha):
    r"""
    Wrapper for `fz_new_pixmap()`.
    Create a new pixmap, with its origin at (0,0)

    cs: The colorspace to use for the pixmap, or NULL for an alpha
    plane/mask.

    w: The width of the pixmap (in pixels)

    h: The height of the pixmap (in pixels)

    seps: Details of separations.

    alpha: 0 for no alpha, 1 for alpha.

    Returns a pointer to the new pixmap. Throws exception on failure
    to allocate.
    """
    return _mupdf.new_pixmap(cs, w, h, seps, alpha)

def new_pixmap_from_alpha_channel(src):
    r""" Wrapper for `fz_new_pixmap_from_alpha_channel()`."""
    return _mupdf.new_pixmap_from_alpha_channel(src)

def new_pixmap_from_color_and_mask(color, mask):
    r""" Wrapper for `fz_new_pixmap_from_color_and_mask()`."""
    return _mupdf.new_pixmap_from_color_and_mask(color, mask)

def new_pixmap_from_display_list(list, ctm, cs, alpha):
    r"""
    Wrapper for `fz_new_pixmap_from_display_list()`.
    Render the page to a pixmap using the transform and colorspace.

    Ownership of the pixmap is returned to the caller.
    """
    return _mupdf.new_pixmap_from_display_list(list, ctm, cs, alpha)

def new_pixmap_from_display_list_with_separations(list, ctm, cs, seps, alpha):
    r"""
    Wrapper for `fz_new_pixmap_from_display_list_with_separations()`.
    Render the page contents with control over spot colors.

    Ownership of the pixmap is returned to the caller.
    """
    return _mupdf.new_pixmap_from_display_list_with_separations(list, ctm, cs, seps, alpha)

def new_pixmap_from_page(page, ctm, cs, alpha):
    r""" Wrapper for `fz_new_pixmap_from_page()`."""
    return _mupdf.new_pixmap_from_page(page, ctm, cs, alpha)

def new_pixmap_from_page_contents(page, ctm, cs, alpha):
    r"""
    Wrapper for `fz_new_pixmap_from_page_contents()`.
    Render the page contents without annotations.

    Ownership of the pixmap is returned to the caller.
    """
    return _mupdf.new_pixmap_from_page_contents(page, ctm, cs, alpha)

def new_pixmap_from_page_contents_with_separations(page, ctm, cs, seps, alpha):
    r""" Wrapper for `fz_new_pixmap_from_page_contents_with_separations()`."""
    return _mupdf.new_pixmap_from_page_contents_with_separations(page, ctm, cs, seps, alpha)

def new_pixmap_from_page_number(doc, number, ctm, cs, alpha):
    r""" Wrapper for `fz_new_pixmap_from_page_number()`."""
    return _mupdf.new_pixmap_from_page_number(doc, number, ctm, cs, alpha)

def new_pixmap_from_page_number_with_separations(doc, number, ctm, cs, seps, alpha):
    r""" Wrapper for `fz_new_pixmap_from_page_number_with_separations()`."""
    return _mupdf.new_pixmap_from_page_number_with_separations(doc, number, ctm, cs, seps, alpha)

def new_pixmap_from_page_with_separations(page, ctm, cs, seps, alpha):
    r""" Wrapper for `fz_new_pixmap_from_page_with_separations()`."""
    return _mupdf.new_pixmap_from_page_with_separations(page, ctm, cs, seps, alpha)

def new_pixmap_from_pixmap(pixmap, rect):
    r"""
    Wrapper for `fz_new_pixmap_from_pixmap()`.
    Create a new pixmap that represents a subarea of the specified
    pixmap. A reference is taken to this pixmap that will be dropped
    on destruction.

    The supplied rectangle must be wholly contained within the
    original pixmap.

    Returns a pointer to the new pixmap. Throws exception on failure
    to allocate.
    """
    return _mupdf.new_pixmap_from_pixmap(pixmap, rect)

def new_pixmap_with_bbox(colorspace, bbox, seps, alpha):
    r"""
    Wrapper for `fz_new_pixmap_with_bbox()`.
    Create a pixmap of a given size, location and pixel format.

    The bounding box specifies the size of the created pixmap and
    where it will be located. The colorspace determines the number
    of components per pixel. Alpha is always present. Pixmaps are
    reference counted, so drop references using fz_drop_pixmap.

    colorspace: Colorspace format used for the created pixmap. The
    pixmap will keep a reference to the colorspace.

    bbox: Bounding box specifying location/size of created pixmap.

    seps: Details of separations.

    alpha: 0 for no alpha, 1 for alpha.

    Returns a pointer to the new pixmap. Throws exception on failure
    to allocate.
    """
    return _mupdf.new_pixmap_with_bbox(colorspace, bbox, seps, alpha)

def new_pixmap_with_bbox_and_data(colorspace, rect, seps, alpha, samples):
    r"""
    Wrapper for `fz_new_pixmap_with_bbox_and_data()`.
    Create a pixmap of a given size, location and pixel format,
    using the supplied data block.

    The bounding box specifies the size of the created pixmap and
    where it will be located. The colorspace determines the number
    of components per pixel. Alpha is always present. Pixmaps are
    reference counted, so drop references using fz_drop_pixmap.

    colorspace: Colorspace format used for the created pixmap. The
    pixmap will keep a reference to the colorspace.

    rect: Bounding box specifying location/size of created pixmap.

    seps: Details of separations.

    alpha: Number of alpha planes (0 or 1).

    samples: The data block to keep the samples in.

    Returns a pointer to the new pixmap. Throws exception on failure
    to allocate.
    """
    return _mupdf.new_pixmap_with_bbox_and_data(colorspace, rect, seps, alpha, samples)

def new_pixmap_with_data(colorspace, w, h, seps, alpha, stride, samples):
    r"""
    Wrapper for `fz_new_pixmap_with_data()`.
    Create a new pixmap, with its origin at
    (0,0) using the supplied data block.

    cs: The colorspace to use for the pixmap, or NULL for an alpha
    plane/mask.

    w: The width of the pixmap (in pixels)

    h: The height of the pixmap (in pixels)

    seps: Details of separations.

    alpha: 0 for no alpha, 1 for alpha.

    stride: The byte offset from the pixel data in a row to the
    pixel data in the next row.

    samples: The data block to keep the samples in.

    Returns a pointer to the new pixmap. Throws exception on failure to
    allocate.
    """
    return _mupdf.new_pixmap_with_data(colorspace, w, h, seps, alpha, stride, samples)

def new_pixmap_writer(path, options, default_path, n, save):
    r""" Wrapper for `fz_new_pixmap_writer()`."""
    return _mupdf.new_pixmap_writer(path, options, default_path, n, save)

def new_pkm_band_writer(out):
    r"""
    Wrapper for `fz_new_pkm_band_writer()`.
    Create a new pkm band writer for CMYK pixmaps.
    """
    return _mupdf.new_pkm_band_writer(out)

def new_pkm_pixmap_writer(path, options):
    r""" Wrapper for `fz_new_pkm_pixmap_writer()`."""
    return _mupdf.new_pkm_pixmap_writer(path, options)

def new_png_band_writer(out):
    r"""
    Wrapper for `fz_new_png_band_writer()`.
    Create a new png band writer (greyscale or RGB, with or without
    alpha).
    """
    return _mupdf.new_png_band_writer(out)

def new_png_pixmap_writer(path, options):
    r""" Wrapper for `fz_new_png_pixmap_writer()`."""
    return _mupdf.new_png_pixmap_writer(path, options)

def new_pnm_band_writer(out):
    r"""
    Wrapper for `fz_new_pnm_band_writer()`.
    Create a band writer targetting pnm (greyscale or rgb, no
    alpha).
    """
    return _mupdf.new_pnm_band_writer(out)

def new_pnm_pixmap_writer(path, options):
    r""" Wrapper for `fz_new_pnm_pixmap_writer()`."""
    return _mupdf.new_pnm_pixmap_writer(path, options)

def new_pool():
    r"""
    Wrapper for `fz_new_pool()`.
    Create a new pool to allocate from.
    """
    return _mupdf.new_pool()

def new_ppm_pixmap_writer(path, options):
    r""" Wrapper for `fz_new_ppm_pixmap_writer()`."""
    return _mupdf.new_ppm_pixmap_writer(path, options)

def new_ps_band_writer(out):
    r"""
    Wrapper for `fz_new_ps_band_writer()`.
    Create a postscript band writer for gray, rgb, or cmyk, no
    alpha.
    """
    return _mupdf.new_ps_band_writer(out)

def new_ps_writer(path, options):
    r""" Wrapper for `fz_new_ps_writer()`."""
    return _mupdf.new_ps_writer(path, options)

def new_ps_writer_with_output(out, options):
    r""" Wrapper for `fz_new_ps_writer_with_output()`."""
    return _mupdf.new_ps_writer_with_output(out, options)

def new_psd_band_writer(out):
    r"""
    Wrapper for `fz_new_psd_band_writer()`.
    Open a PSD band writer.
    """
    return _mupdf.new_psd_band_writer(out)

def new_pwg_band_writer(out, pwg):
    r"""
    Wrapper for `fz_new_pwg_band_writer()`.
    Create a new color pwg band writer.
    """
    return _mupdf.new_pwg_band_writer(out, pwg)

def new_pwg_writer(path, options):
    r""" Wrapper for `fz_new_pwg_writer()`."""
    return _mupdf.new_pwg_writer(path, options)

def new_pwg_writer_with_output(out, options):
    r""" Wrapper for `fz_new_pwg_writer_with_output()`."""
    return _mupdf.new_pwg_writer_with_output(out, options)

def new_rle_output(chain):
    r""" Wrapper for `fz_new_rle_output()`."""
    return _mupdf.new_rle_output(chain)

def new_separations(controllable):
    r"""
    Wrapper for `fz_new_separations()`.
    Create a new separations structure (initially empty)
    """
    return _mupdf.new_separations(controllable)

def new_stext_device(page, options):
    r"""
    Wrapper for `fz_new_stext_device()`.
    Create a device to extract the text on a page.

    Gather the text on a page into blocks and lines.

    The reading order is taken from the order the text is drawn in
    the source file, so may not be accurate.

    page: The text page to which content should be added. This will
    usually be a newly created (empty) text page, but it can be one
    containing data already (for example when merging multiple
    pages, or watermarking).

    options: Options to configure the stext device.
    """
    return _mupdf.new_stext_device(page, options)

def new_stext_page(mediabox):
    r"""
    Wrapper for `fz_new_stext_page()`.
    Create an empty text page.

    The text page is filled out by the text device to contain the
    blocks and lines of text on the page.

    mediabox: optional mediabox information.
    """
    return _mupdf.new_stext_page(mediabox)

def new_stext_page_from_chapter_page_number(doc, chapter, number, options):
    r""" Wrapper for `fz_new_stext_page_from_chapter_page_number()`."""
    return _mupdf.new_stext_page_from_chapter_page_number(doc, chapter, number, options)

def new_stext_page_from_display_list(list, options):
    r""" Wrapper for `fz_new_stext_page_from_display_list()`."""
    return _mupdf.new_stext_page_from_display_list(list, options)

def new_stext_page_from_page(page, options):
    r"""
    Wrapper for `fz_new_stext_page_from_page()`.
    Extract text from page.

    Ownership of the fz_stext_page is returned to the caller.
    """
    return _mupdf.new_stext_page_from_page(page, options)

def new_stext_page_from_page_number(doc, number, options):
    r""" Wrapper for `fz_new_stext_page_from_page_number()`."""
    return _mupdf.new_stext_page_from_page_number(doc, number, options)

def new_store_context(max):
    r"""
    Wrapper for `fz_new_store_context()`.
    Create a new store inside the context

    max: The maximum size (in bytes) that the store is allowed to
    grow to. FZ_STORE_UNLIMITED means no limit.
    """
    return _mupdf.new_store_context(max)

def new_stream(state, next, drop):
    r"""
    Wrapper for `fz_new_stream()`.
    Create a new stream object with the given
    internal state and function pointers.

    state: Internal state (opaque to everything but implementation).

    next: Should provide the next set of bytes (up to max) of stream
    data. Return the number of bytes read, or EOF when there is no
    more data.

    drop: Should clean up and free the internal state. May not
    throw exceptions.
    """
    return _mupdf.new_stream(state, next, drop)

def new_stroke_state():
    r"""
    Wrapper for `fz_new_stroke_state()`.
    Create a new (empty) stroke state structure (with no dash
    data) and return a reference to it.

    Throws exception on failure to allocate.
    """
    return _mupdf.new_stroke_state()

def new_stroke_state_with_dash_len(len):
    r"""
    Wrapper for `fz_new_stroke_state_with_dash_len()`.
    Create a new (empty) stroke state structure, with room for
    dash data of the given length, and return a reference to it.

    len: The number of dash elements to allow room for.

    Throws exception on failure to allocate.
    """
    return _mupdf.new_stroke_state_with_dash_len(len)

def new_svg_device(out, page_width, page_height, text_format, reuse_images):
    r"""
    Wrapper for `fz_new_svg_device()`.
    Create a device that outputs (single page) SVG files to
    the given output stream.

    Equivalent to fz_new_svg_device_with_id passing id = NULL.
    """
    return _mupdf.new_svg_device(out, page_width, page_height, text_format, reuse_images)

def new_svg_device_with_id(out, page_width, page_height, text_format, reuse_images):
    r"""
     Wrapper for `fz_new_svg_device_with_id()`.

    This function has out-params. Python/C# wrappers look like:
    	`new_svg_device_with_id(fz_output *out, float page_width, float page_height, int text_format, int reuse_images)` => `(fz_device *, int id)`

    	Create a device that outputs (single page) SVG files to
    	the given output stream.

    	output: The output stream to send the constructed SVG page to.

    	page_width, page_height: The page dimensions to use (in points).

    	text_format: How to emit text. One of the following values:
    		FZ_SVG_TEXT_AS_TEXT: As <text> elements with possible
    		layout errors and mismatching fonts.
    		FZ_SVG_TEXT_AS_PATH: As <path> elements with exact
    		visual appearance.

    	reuse_images: Share image resources using <symbol> definitions.

    	id: ID parameter to keep generated IDs unique across SVG files.
    """
    return _mupdf.new_svg_device_with_id(out, page_width, page_height, text_format, reuse_images)

def new_svg_writer(path, options):
    r""" Wrapper for `fz_new_svg_writer()`."""
    return _mupdf.new_svg_writer(path, options)

def new_test_device(threshold, options, passthrough):
    r"""
     Wrapper for `fz_new_test_device()`.

    This function has out-params. Python/C# wrappers look like:
    	`new_test_device(float threshold, int options, fz_device *passthrough)` => `(fz_device *, int is_color)`

    	Create a device to test for features.

    	Currently only tests for the presence of non-grayscale colors.

    	is_color: Possible values returned:
    		0: Definitely greyscale
    		1: Probably color (all colors were grey, but there
    		were images or shadings in a non grey colorspace).
    		2: Definitely color

    	threshold: The difference from grayscale that will be tolerated.
    	Typical values to use are either 0 (be exact) and 0.02 (allow an
    	imperceptible amount of slop).

    	options: A set of bitfield options, from the FZ_TEST_OPT set.

    	passthrough: A device to pass all calls through to, or NULL.
    	If set, then the test device can both test and pass through to
    	an underlying device (like, say, the display list device). This
    	means that a display list can be created and at the end we'll
    	know if it's colored or not.

    	In the absence of a passthrough device, the device will throw
    	an exception to stop page interpretation when color is found.
    """
    return _mupdf.new_test_device(threshold, options, passthrough)

def new_text():
    r"""
    Wrapper for `fz_new_text()`.
    Create a new empty fz_text object.

    Throws exception on failure to allocate.
    """
    return _mupdf.new_text()

def new_text_writer(format, path, options):
    r""" Wrapper for `fz_new_text_writer()`."""
    return _mupdf.new_text_writer(format, path, options)

def new_text_writer_with_output(format, out, options):
    r""" Wrapper for `fz_new_text_writer_with_output()`."""
    return _mupdf.new_text_writer_with_output(format, out, options)

def new_trace_device(out):
    r"""
    Wrapper for `fz_new_trace_device()`.
    Create a device to print a debug trace of all device calls.
    """
    return _mupdf.new_trace_device(out)

def new_type3_font(name, matrix):
    r"""
    Wrapper for `fz_new_type3_font()`.
    Create a new (empty) type3 font.

    name: Name of font (or NULL).

    matrix: Font matrix.

    Returns a new font handle, or throws exception on
    allocation failure.
    """
    return _mupdf.new_type3_font(name, matrix)

def new_xhtml_document_from_document(old_doc, opts):
    r"""
    Wrapper for `fz_new_xhtml_document_from_document()`.
    Use text extraction to convert the input document into XHTML,
    then open the result as a new document that can be reflowed.
    """
    return _mupdf.new_xhtml_document_from_document(old_doc, opts)

def new_xmltext_device(out):
    r"""
    Wrapper for `fz_new_xmltext_device()`.
    Create a device to output raw information.
    """
    return _mupdf.new_xmltext_device(out)

def new_zip_writer(filename):
    r"""
    Wrapper for `fz_new_zip_writer()`.
    Create a new zip writer that writes to a given file.

    Open an archive using a seekable stream object rather than
    opening a file or directory on disk.
    """
    return _mupdf.new_zip_writer(filename)

def new_zip_writer_with_output(out):
    r"""
    Wrapper for `fz_new_zip_writer_with_output()`.
    Create a new zip writer that writes to a given output stream.

    Ownership of out passes in immediately upon calling this function.
    The caller should never drop the fz_output, even if this function throws
    an exception.
    """
    return _mupdf.new_zip_writer_with_output(out)

def next_page(doc, loc):
    r"""
    Wrapper for `fz_next_page()`.
    Function to get the location of the next page (allowing for the
    end of chapters etc). If at the end of the document, returns the
    current location.
    """
    return _mupdf.next_page(doc, loc)

def normalize_vector(p):
    r"""
    Wrapper for `fz_normalize_vector()`.
    Normalize a vector to length one.
    """
    return _mupdf.normalize_vector(p)

def open_a85d(chain):
    r"""
    Wrapper for `fz_open_a85d()`.
    a85d filter performs ASCII 85 Decoding of data read
    from the chained filter.
    """
    return _mupdf.open_a85d(chain)

def open_accelerated_document(filename, accel):
    r"""
    Wrapper for `fz_open_accelerated_document()`.
    Open a document file and read its basic structure so pages and
    objects can be located. MuPDF will try to repair broken
    documents (without actually changing the file contents).

    The returned fz_document is used when calling most other
    document related functions.

    filename: a path to a file as it would be given to open(2).
    """
    return _mupdf.open_accelerated_document(filename, accel)

def open_accelerated_document_with_stream(magic, stream, accel):
    r"""
    Wrapper for `fz_open_accelerated_document_with_stream()`.
    Open a document using the specified stream object rather than
    opening a file on disk.

    magic: a string used to detect document type; either a file name
    or mime-type.
    """
    return _mupdf.open_accelerated_document_with_stream(magic, stream, accel)

def open_aesd(chain, key, keylen):
    r"""
    Wrapper for `fz_open_aesd()`.
    aesd filter performs AES decoding of data read from the chained
    filter using the supplied key.
    """
    return _mupdf.open_aesd(chain, key, keylen)

def open_ahxd(chain):
    r"""
    Wrapper for `fz_open_ahxd()`.
    ahxd filter performs ASCII Hex decoding of data read
    from the chained filter.
    """
    return _mupdf.open_ahxd(chain)

def open_arc4(chain, key, keylen):
    r"""
    Wrapper for `fz_open_arc4()`.
    arc4 filter performs RC4 decoding of data read from the chained
    filter using the supplied key.
    """
    return _mupdf.open_arc4(chain, key, keylen)

def open_archive(filename):
    r"""
    Wrapper for `fz_open_archive()`.
    Open a zip or tar archive

    Open a file and identify its archive type based on the archive
    signature contained inside.

    filename: a path to a file as it would be given to open(2).
    """
    return _mupdf.open_archive(filename)

def open_archive_entry(arch, name):
    r"""
    Wrapper for `fz_open_archive_entry()`.
    Opens an archive entry as a stream.

    name: Entry name to look for, this must be an exact match to
    the entry name in the archive.
    """
    return _mupdf.open_archive_entry(arch, name)

def open_archive_with_stream(file):
    r"""
    Wrapper for `fz_open_archive_with_stream()`.
    Open zip or tar archive stream.

    Open an archive using a seekable stream object rather than
    opening a file or directory on disk.
    """
    return _mupdf.open_archive_with_stream(file)

def open_buffer(buf):
    r"""
    Wrapper for `fz_open_buffer()`.
    Open a buffer as a stream.

    buf: The buffer to open. Ownership of the buffer is NOT passed
    in (this function takes its own reference).

    Returns pointer to newly created stream. May throw exceptions on
    failure to allocate.
    """
    return _mupdf.open_buffer(buf)

def open_compressed_buffer(arg_1):
    r"""
    Wrapper for `fz_open_compressed_buffer()`.
    Open a stream to read the decompressed version of a buffer.
    """
    return _mupdf.open_compressed_buffer(arg_1)

def open_concat(max, pad):
    r"""
    Wrapper for `fz_open_concat()`.
    Concat filter concatenates several streams into one.
    """
    return _mupdf.open_concat(max, pad)

def open_dctd(chain, color_transform, l2factor, jpegtables):
    r"""
    Wrapper for `fz_open_dctd()`.
    dctd filter performs DCT (JPEG) decoding of data read
    from the chained filter.

    color_transform implements the PDF color_transform option;
    use -1 (unset) as a default.

    For subsampling on decode, set l2factor to the log2 of the
    reduction required (therefore 0 = full size decode).

    jpegtables is an optional stream from which the JPEG tables
    can be read. Use NULL if not required.
    """
    return _mupdf.open_dctd(chain, color_transform, l2factor, jpegtables)

def open_directory(path):
    r"""
    Wrapper for `fz_open_directory()`.
    Open a directory as if it was an archive.

    A special case where a directory is opened as if it was an
    archive.

    Note that for directories it is not possible to retrieve the
    number of entries or list the entries. It is however possible
    to check if the archive has a particular entry.

    path: a path to a directory as it would be given to opendir(3).
    """
    return _mupdf.open_directory(path)

def open_document(filename):
    r"""
    Wrapper for `fz_open_document()`.
    Open a document file and read its basic structure so pages and
    objects can be located. MuPDF will try to repair broken
    documents (without actually changing the file contents).

    The returned fz_document is used when calling most other
    document related functions.

    filename: a path to a file as it would be given to open(2).
    """
    return _mupdf.open_document(filename)

def open_document_with_stream(magic, stream):
    r"""
    Wrapper for `fz_open_document_with_stream()`.
    Open a document using the specified stream object rather than
    opening a file on disk.

    magic: a string used to detect document type; either a file name
    or mime-type.
    """
    return _mupdf.open_document_with_stream(magic, stream)

def open_endstream_filter(chain, len, offset):
    r"""
    Wrapper for `fz_open_endstream_filter()`.
    The endstream filter reads a PDF substream, and starts to look
    for an 'endstream' token after the specified length.
    """
    return _mupdf.open_endstream_filter(chain, len, offset)

def open_faxd(chain, k, end_of_line, encoded_byte_align, columns, rows, end_of_block, black_is_1):
    r"""
    Wrapper for `fz_open_faxd()`.
    faxd filter performs FAX decoding of data read from
    the chained filter.

    k: see fax specification (fax default is 0).

    end_of_line: whether we expect end of line markers (fax default
    is 0).

    encoded_byte_align: whether we align to bytes after each line
    (fax default is 0).

    columns: how many columns in the image (fax default is 1728).

    rows: 0 for unspecified or the number of rows of data to expect.

    end_of_block: whether we expect end of block markers (fax
    default is 1).

    black_is_1: determines the polarity of the image (fax default is
    0).
    """
    return _mupdf.open_faxd(chain, k, end_of_line, encoded_byte_align, columns, rows, end_of_block, black_is_1)

def open_file(filename):
    r"""
    Wrapper for `fz_open_file()`.
    Open the named file and wrap it in a stream.

    filename: Path to a file. On non-Windows machines the filename
    should be exactly as it would be passed to fopen(2). On Windows
    machines, the path should be UTF-8 encoded so that non-ASCII
    characters can be represented. Other platforms do the encoding
    as standard anyway (and in most cases, particularly for MacOS
    and Linux, the encoding they use is UTF-8 anyway).
    """
    return _mupdf.open_file(filename)

def open_file_ptr_no_close(file):
    r"""
    Wrapper for `fz_open_file_ptr_no_close()`.
    Create a stream from a FILE * that will not be closed
    when the stream is dropped.
    """
    return _mupdf.open_file_ptr_no_close(file)

def open_flated(chain, window_bits):
    r"""
    Wrapper for `fz_open_flated()`.
    flated filter performs LZ77 decoding (inflating) of data read
    from the chained filter.

    window_bits: How large a decompression window to use. Typically
    15. A negative number, -n, means to use n bits, but to expect
    raw data with no header.
    """
    return _mupdf.open_flated(chain, window_bits)

def open_image_decomp_stream(arg_1, arg_2):
    r"""
     Wrapper for `fz_open_image_decomp_stream()`.

    This function has out-params. Python/C# wrappers look like:
    	`open_image_decomp_stream(fz_stream *arg_0, fz_compression_params *arg_1)` => `(fz_stream *, int l2factor)`

    	Open a stream to read the decompressed version of another stream
    	with optional log2 subsampling.
    """
    return _mupdf.open_image_decomp_stream(arg_1, arg_2)

def open_image_decomp_stream_from_buffer(arg_1):
    r"""
     Wrapper for `fz_open_image_decomp_stream_from_buffer()`.

    This function has out-params. Python/C# wrappers look like:
    	`open_image_decomp_stream_from_buffer(fz_compressed_buffer *arg_0)` => `(fz_stream *, int l2factor)`

    	Open a stream to read the decompressed version of a buffer,
    	with optional log2 subsampling.

    	l2factor = NULL for no subsampling, or a pointer to an integer
    	containing the maximum log2 subsample factor acceptable (0 =
    	none, 1 = halve dimensions, 2 = quarter dimensions etc). If
    	non-NULL, then *l2factor will be updated on exit with the actual
    	log2 subsample factor achieved.
    """
    return _mupdf.open_image_decomp_stream_from_buffer(arg_1)

def open_jbig2d(chain, globals, embedded):
    r"""
    Wrapper for `fz_open_jbig2d()`.
    Open a filter that performs jbig2 decompression on the chained
    stream, using the optional globals record.
    """
    return _mupdf.open_jbig2d(chain, globals, embedded)

def open_leecher(chain, buf):
    r"""
    Wrapper for `fz_open_leecher()`.
    Attach a filter to a stream that will store any
    characters read from the stream into the supplied buffer.

    chain: The underlying stream to leech from.

    buf: The buffer into which the read data should be appended.
    The buffer will be resized as required.

    Returns pointer to newly created stream. May throw exceptions on
    failure to allocate.
    """
    return _mupdf.open_leecher(chain, buf)

def open_lzwd(chain, early_change, min_bits, reverse_bits, old_tiff):
    r"""
    Wrapper for `fz_open_lzwd()`.
    lzwd filter performs LZW decoding of data read from the chained
    filter.

    early_change: (Default 1) specifies whether to change codes 1
    bit early.

    min_bits: (Default 9) specifies the minimum number of bits to
    use.

    reverse_bits: (Default 0) allows for compatibility with gif and
    old style tiffs (1).

    old_tiff: (Default 0) allows for different handling of the clear
    code, as found in old style tiffs.
    """
    return _mupdf.open_lzwd(chain, early_change, min_bits, reverse_bits, old_tiff)

def open_memory(data, len):
    r"""
    Wrapper for `fz_open_memory()`.
    Open a block of memory as a stream.

    data: Pointer to start of data block. Ownership of the data
    block is NOT passed in.

    len: Number of bytes in data block.

    Returns pointer to newly created stream. May throw exceptions on
    failure to allocate.
    """
    return _mupdf.open_memory(data, len)

def open_null_filter(chain, len, offset):
    r"""
    Wrapper for `fz_open_null_filter()`.
    The null filter reads a specified amount of data from the
    substream.
    """
    return _mupdf.open_null_filter(chain, len, offset)

def open_predict(chain, predictor, columns, colors, bpc):
    r"""
    Wrapper for `fz_open_predict()`.
    predict filter performs pixel prediction on data read from
    the chained filter.

    predictor: 1 = copy, 2 = tiff, other = inline PNG predictor

    columns: width of image in pixels

    colors: number of components.

    bpc: bits per component (typically 8)
    """
    return _mupdf.open_predict(chain, predictor, columns, colors, bpc)

def open_range_filter(chain, ranges, nranges):
    r"""
    Wrapper for `fz_open_range_filter()`.
    The range filter copies data from specified ranges of the
    chained stream.
    """
    return _mupdf.open_range_filter(chain, ranges, nranges)

def open_reflowed_document(underdoc, opts):
    r""" Wrapper for `fz_open_reflowed_document()`."""
    return _mupdf.open_reflowed_document(underdoc, opts)

def open_rld(chain):
    r"""
    Wrapper for `fz_open_rld()`.
    rld filter performs Run Length Decoding of data read
    from the chained filter.
    """
    return _mupdf.open_rld(chain)

def open_sgilog16(chain, w):
    r"""
    Wrapper for `fz_open_sgilog16()`.
    SGI Log 16bit (greyscale) decode from the chained filter.
    Decodes lines of w pixels to 8bpp greyscale.
    """
    return _mupdf.open_sgilog16(chain, w)

def open_sgilog24(chain, w):
    r"""
    Wrapper for `fz_open_sgilog24()`.
    SGI Log 24bit (LUV) decode from the chained filter.
    Decodes lines of w pixels to 8bpc rgb.
    """
    return _mupdf.open_sgilog24(chain, w)

def open_sgilog32(chain, w):
    r"""
    Wrapper for `fz_open_sgilog32()`.
    SGI Log 32bit (LUV) decode from the chained filter.
    Decodes lines of w pixels to 8bpc rgb.
    """
    return _mupdf.open_sgilog32(chain, w)

def open_tar_archive(filename):
    r"""
    Wrapper for `fz_open_tar_archive()`.
    Open a tar archive file.

    An exception is throw if the file is not a tar archive as
    indicated by the presence of a tar signature.

    filename: a path to a tar archive file as it would be given to
    open(2).
    """
    return _mupdf.open_tar_archive(filename)

def open_tar_archive_with_stream(file):
    r"""
    Wrapper for `fz_open_tar_archive_with_stream()`.
    Open a tar archive stream.

    Open an archive using a seekable stream object rather than
    opening a file or directory on disk.

    An exception is throw if the stream is not a tar archive as
    indicated by the presence of a tar signature.

    """
    return _mupdf.open_tar_archive_with_stream(file)

def open_thunder(chain, w):
    r"""
    Wrapper for `fz_open_thunder()`.
    4bit greyscale Thunderscan decoding from the chained filter.
    Decodes lines of w pixels to 8bpp greyscale.
    """
    return _mupdf.open_thunder(chain, w)

def open_zip_archive(path):
    r"""
    Wrapper for `fz_open_zip_archive()`.
    Open a zip archive file.

    An exception is throw if the file is not a zip archive as
    indicated by the presence of a zip signature.

    filename: a path to a zip archive file as it would be given to
    open(2).
    """
    return _mupdf.open_zip_archive(path)

def open_zip_archive_with_stream(file):
    r"""
    Wrapper for `fz_open_zip_archive_with_stream()`.
    Open a zip archive stream.

    Open an archive using a seekable stream object rather than
    opening a file or directory on disk.

    An exception is throw if the stream is not a zip archive as
    indicated by the presence of a zip signature.

    """
    return _mupdf.open_zip_archive_with_stream(file)

def option_eq(a, b):
    r"""
    Wrapper for `fz_option_eq()`.
    Check to see if an option, a, from a string matches a reference
    option, b.

    (i.e. a could be 'foo' or 'foo,bar...' etc, but b can only be
    'foo'.)
    """
    return _mupdf.option_eq(a, b)

def outline_glyph(font, gid, ctm):
    r"""
    Wrapper for `fz_outline_glyph()`.
    Look a glyph up from a font, and return the outline of the
    glyph using the given transform.

    The caller owns the returned path, and so is responsible for
    ensuring that it eventually gets dropped.
    """
    return _mupdf.outline_glyph(font, gid, ctm)

def outline_iterator_delete(iter):
    r"""
    Wrapper for `fz_outline_iterator_delete()`.
    Delete the current item.

    This implicitly moves us to the 'next' item, and the return code is as for fz_outline_iterator_next.
    """
    return _mupdf.outline_iterator_delete(iter)

def outline_iterator_down(iter):
    r""" Wrapper for `fz_outline_iterator_down()`."""
    return _mupdf.outline_iterator_down(iter)

def outline_iterator_from_outline(outline):
    r""" Wrapper for `fz_outline_iterator_from_outline()`."""
    return _mupdf.outline_iterator_from_outline(outline)

def outline_iterator_insert(iter, item):
    r"""
    Wrapper for `fz_outline_iterator_insert()`.
    Call to insert a new item BEFORE the current point.

    Ownership of pointers are retained by the caller. The item data will be copied.

    After an insert, we do not change where we are pointing.
    The return code is the same as for next, it indicates the current iterator position.
    """
    return _mupdf.outline_iterator_insert(iter, item)

def outline_iterator_item(iter):
    r"""
    Wrapper for `fz_outline_iterator_item()`.
    Call to get the current outline item.

    Can return NULL. The item is only valid until the next call.
    """
    return _mupdf.outline_iterator_item(iter)

def outline_iterator_next(iter):
    r"""
    Wrapper for `fz_outline_iterator_next()`.
    Calls to move the iterator position.

    A negative return value means we could not move as requested. Otherwise:
    0 = the final position has a valid item.
    1 = not a valid item, but we can insert an item here.
    """
    return _mupdf.outline_iterator_next(iter)

def outline_iterator_prev(iter):
    r""" Wrapper for `fz_outline_iterator_prev()`."""
    return _mupdf.outline_iterator_prev(iter)

def outline_iterator_up(iter):
    r""" Wrapper for `fz_outline_iterator_up()`."""
    return _mupdf.outline_iterator_up(iter)

def outline_iterator_update(iter, item):
    r"""
    Wrapper for `fz_outline_iterator_update()`.
    Update the current item properties according to the given item.
    """
    return _mupdf.outline_iterator_update(iter, item)

def output_accelerator(doc, accel):
    r"""
    Wrapper for `fz_output_accelerator()`.
    Output accelerator data for the document to a given output
    stream.
    """
    return _mupdf.output_accelerator(doc, accel)

def output_supports_stream(out):
    r"""
    Wrapper for `fz_output_supports_stream()`.
    Query whether a given fz_output supports fz_stream_from_output.
    """
    return _mupdf.output_supports_stream(out)

def pack_path(pack, max, path):
    r"""
    Wrapper for `fz_pack_path()`.
    Pack a path into the given block.
    To minimise the size of paths, this function allows them to be
    packed into a buffer with other information. Paths can be used
    interchangeably regardless of how they are packed.

    pack: Pointer to a block of data to pack the path into. Should
    be aligned by the caller to the same alignment as required for
    a fz_path pointer.

    max: The number of bytes available in the block.
    If max < sizeof(fz_path) then an exception will
    be thrown. If max >= the value returned by
    fz_packed_path_size, then this call will never
    fail, except in low memory situations with large
    paths.

    path: The path to pack.

    Returns the number of bytes within the block used. Callers can
    access the packed path data by casting the value of pack on
    entry to be a fz_path *.

    Throws exceptions on failure to allocate, or if
    max < sizeof(fz_path).

    Implementation details: Paths can be 'unpacked', 'flat', or
    'open'. Standard paths, as created are 'unpacked'. Paths that
    will pack into less than max bytes will be packed as 'flat',
    unless they are too large (where large indicates that they
    exceed some private implementation defined limits, currently
    including having more than 256 coordinates or commands).

    Large paths are 'open' packed as a header into the given block,
    plus pointers to other data blocks.

    Users should not have to care about whether paths are 'open'
    or 'flat' packed. Simply pack a path (if required), and then
    forget about the details.
    """
    return _mupdf.pack_path(pack, max, path)

def packed_path_size(path):
    r"""
    Wrapper for `fz_packed_path_size()`.
    Return the number of bytes required to pack a path.
    """
    return _mupdf.packed_path_size(path)

def page_number_from_location(doc, loc):
    r"""
    Wrapper for `fz_page_number_from_location()`.
    Converts from chapter+page to page number. This may cause many
    chapters to be laid out in order to calculate the number of
    pages within those chapters.
    """
    return _mupdf.page_number_from_location(doc, loc)

def page_presentation(page, transition):
    r"""
     Wrapper for `fz_page_presentation()`.

    This function has out-params. Python/C# wrappers look like:
    	`page_presentation(fz_page *page, fz_transition *transition)` => `(fz_transition *, float duration)`

    	Get the presentation details for a given page.

    	transition: A pointer to a transition struct to fill out.

    	duration: A pointer to a place to set the page duration in
    	seconds. Will be set to 0 if no transition is specified for the
    	page.

    	Returns: a pointer to the transition structure, or NULL if there
    	is no transition specified for the page.
    """
    return _mupdf.page_presentation(page, transition)

def page_separations(page):
    r"""
    Wrapper for `fz_page_separations()`.
    Get the separations details for a page.
    This will be NULL, unless the format specifically supports
    separations (such as PDF files). May be NULL even
    so, if there are no separations on a page.

    Returns a reference that must be dropped.
    """
    return _mupdf.page_separations(page)

def page_uses_overprint(page):
    r"""
    Wrapper for `fz_page_uses_overprint()`.
    Query if a given page requires overprint.
    """
    return _mupdf.page_uses_overprint(page)

def paint_shade(shade, override_cs, ctm, dest, color_params, bbox, eop, OUTPUT):
    r"""
     Wrapper for `fz_paint_shade()`.

    This function has out-params. Python/C# wrappers look like:
    	`paint_shade(fz_shade *shade, fz_colorspace *override_cs, fz_matrix ctm, fz_pixmap *dest, fz_color_params color_params, fz_irect bbox, const fz_overprint *eop, fz_shade_color_cache **cache)` =>

    	Render a shade to a given pixmap.

    	shade: The shade to paint.

    	override_cs: NULL, or colorspace to override the shades
    	inbuilt colorspace.

    	ctm: The transform to apply.

    	dest: The pixmap to render into.

    	color_params: The color rendering settings

    	bbox: Pointer to a bounding box to limit the rendering
    	of the shade.

    	eop: NULL, or pointer to overprint bitmap.

    	cache: *cache is used to cache color information. If *cache is NULL it
    	is set to point to a new fz_shade_color_cache. If cache is NULL it is
    	ignored.
    """
    return _mupdf.paint_shade(shade, override_cs, ctm, dest, color_params, bbox, eop, OUTPUT)

def parse_draw_options(options, string):
    r"""
    Wrapper for `fz_parse_draw_options()`.
    Parse draw device options from a comma separated key-value string.
    """
    return _mupdf.parse_draw_options(options, string)

def parse_page_range(s, n):
    r"""
     Wrapper for `fz_parse_page_range()`.

    This function has out-params. Python/C# wrappers look like:
    	`parse_page_range(const char *s, int n)` => `(const char *, int a, int b)`
    """
    return _mupdf.parse_page_range(s, n)

def parse_pcl_options(opts, args):
    r"""
    Wrapper for `fz_parse_pcl_options()`.
    Parse PCL options.

    Currently defined options and values are as follows:

    	preset=X	Either "generic" or one of the presets as for fz_pcl_preset.
    	spacing=0	No vertical spacing capability
    	spacing=1	PCL 3 spacing (<ESC>*p+<n>Y)
    	spacing=2	PCL 4 spacing (<ESC>*b<n>Y)
    	spacing=3	PCL 5 spacing (<ESC>*b<n>Y and clear seed row)
    	mode2		Disable/Enable mode 2 graphics compression
    	mode3		Disable/Enable mode 3 graphics compression
    	eog_reset	End of graphics (<ESC>*rB) resets all parameters
    	has_duplex	Duplex supported (<ESC>&l<duplex>S)
    	has_papersize	Papersize setting supported (<ESC>&l<sizecode>A)
    	has_copies	Number of copies supported (<ESC>&l<copies>X)
    	is_ljet4pjl	Disable/Enable HP 4PJL model-specific output
    	is_oce9050	Disable/Enable Oce 9050 model-specific output
    """
    return _mupdf.parse_pcl_options(opts, args)

def parse_pclm_options(opts, args):
    r"""
    Wrapper for `fz_parse_pclm_options()`.
    Parse PCLm options.

    Currently defined options and values are as follows:

    	compression=none: No compression
    	compression=flate: Flate compression
    	strip-height=n: Strip height (default 16)
    """
    return _mupdf.parse_pclm_options(opts, args)

def parse_pdfocr_options(opts, args):
    r"""
    Wrapper for `fz_parse_pdfocr_options()`.
    Parse PDFOCR options.

    Currently defined options and values are as follows:

    	compression=none: No compression
    	compression=flate: Flate compression
    	strip-height=n: Strip height (default 16)
    	ocr-language=<lang>: OCR Language (default eng)
    	ocr-datadir=<datadir>: OCR data path (default rely on TESSDATA_PREFIX)
    """
    return _mupdf.parse_pdfocr_options(opts, args)

def parse_stext_options(opts, string):
    r"""
    Wrapper for `fz_parse_stext_options()`.
    Parse stext device options from a comma separated key-value
    string.
    """
    return _mupdf.parse_stext_options(opts, string)

def parse_xml(buf, preserve_white):
    r"""
    Wrapper for `fz_parse_xml()`.
    Parse the contents of buffer into a tree of xml nodes.

    preserve_white: whether to keep or delete all-whitespace nodes.
    """
    return _mupdf.parse_xml(buf, preserve_white)

def parse_xml_from_html5(buf):
    r"""
    Wrapper for `fz_parse_xml_from_html5()`.
    Parse the contents of a buffer into a tree of XML nodes,
    using the HTML5 parsing algorithm.
    """
    return _mupdf.parse_xml_from_html5(buf)

def pcl_preset(opts, preset):
    r"""
    Wrapper for `fz_pcl_preset()`.
    Initialize PCL option struct for a given preset.

    Currently defined presets include:

    	generic	Generic PCL printer
    	ljet4	HP DeskJet
    	dj500	HP DeskJet 500
    	fs600	Kyocera FS-600
    	lj	HP LaserJet, HP LaserJet Plus
    	lj2	HP LaserJet IIp, HP LaserJet IId
    	lj3	HP LaserJet III
    	lj3d	HP LaserJet IIId
    	lj4	HP LaserJet 4
    	lj4pl	HP LaserJet 4 PL
    	lj4d	HP LaserJet 4d
    	lp2563b	HP 2563B line printer
    	oce9050	Oce 9050 Line printer
    """
    return _mupdf.pcl_preset(opts, preset)

def pdfocr_band_writer_set_progress(writer, progress_fn, progress_arg):
    r"""
    Wrapper for `fz_pdfocr_band_writer_set_progress()`.
    Set the progress callback for a pdfocr bandwriter.
    """
    return _mupdf.pdfocr_band_writer_set_progress(writer, progress_fn, progress_arg)

def pdfocr_writer_set_progress(writer, progress, arg_3):
    r""" Wrapper for `fz_pdfocr_writer_set_progress()`."""
    return _mupdf.pdfocr_writer_set_progress(writer, progress, arg_3)

def peek_byte(stm):
    r"""
    Wrapper for `fz_peek_byte()`.
    Peek at the next byte in a stream.

    stm: The stream to peek at.

    Returns -1 for EOF, or the next byte that will be read.
    """
    return _mupdf.peek_byte(stm)

def pixmap_alpha(pix):
    r"""
    Wrapper for `fz_pixmap_alpha()`.
    Return the number of alpha planes in a pixmap.

    Returns the number of alphas. Does not throw exceptions.
    """
    return _mupdf.pixmap_alpha(pix)

def pixmap_bbox(pix):
    r"""
    Wrapper for `fz_pixmap_bbox()`.
    Return the bounding box for a pixmap.
    """
    return _mupdf.pixmap_bbox(pix)

def pixmap_colorants(pix):
    r"""
    Wrapper for `fz_pixmap_colorants()`.
    Return the number of colorants in a pixmap.

    Returns the number of colorants (components, less any spots and
    alpha).
    """
    return _mupdf.pixmap_colorants(pix)

def pixmap_colorspace(pix):
    r"""
    Wrapper for `fz_pixmap_colorspace()`.
    Return the colorspace of a pixmap

    Returns colorspace.
    """
    return _mupdf.pixmap_colorspace(pix)

def pixmap_components(pix):
    r"""
    Wrapper for `fz_pixmap_components()`.
    Return the number of components in a pixmap.

    Returns the number of components (including spots and alpha).
    """
    return _mupdf.pixmap_components(pix)

def pixmap_height(pix):
    r"""
    Wrapper for `fz_pixmap_height()`.
    Return the height of the pixmap in pixels.
    """
    return _mupdf.pixmap_height(pix)

def pixmap_image_tile(cimg):
    r"""
    Wrapper for `fz_pixmap_image_tile()`.
    Retrieve the underlying fz_pixmap for an image.

    Returns a pointer to the underlying fz_pixmap for an image,
    or NULL if this image is not based upon an fz_pixmap.

    No reference is returned. Lifespan is limited to that of
    the image itself. If required, use fz_keep_pixmap to take
    a reference to keep it longer.
    """
    return _mupdf.pixmap_image_tile(cimg)

def pixmap_samples(pix):
    r"""
    Wrapper for `fz_pixmap_samples()`.
    Returns a pointer to the pixel data of a pixmap.

    Returns the pointer.
    """
    return _mupdf.pixmap_samples(pix)

def pixmap_spots(pix):
    r"""
    Wrapper for `fz_pixmap_spots()`.
    Return the number of spots in a pixmap.

    Returns the number of spots (components, less colorants and
    alpha). Does not throw exceptions.
    """
    return _mupdf.pixmap_spots(pix)

def pixmap_stride(pix):
    r"""
    Wrapper for `fz_pixmap_stride()`.
    Return the number of bytes in a row in the pixmap.
    """
    return _mupdf.pixmap_stride(pix)

def pixmap_width(pix):
    r"""
    Wrapper for `fz_pixmap_width()`.
    Return the width of the pixmap in pixels.
    """
    return _mupdf.pixmap_width(pix)

def pixmap_x(pix):
    r"""
    Wrapper for `fz_pixmap_x()`.
    Return the x value of the pixmap in pixels.
    """
    return _mupdf.pixmap_x(pix)

def pixmap_y(pix):
    r"""
    Wrapper for `fz_pixmap_y()`.
    Return the y value of the pixmap in pixels.
    """
    return _mupdf.pixmap_y(pix)

def pool_alloc(pool, size):
    r"""
    Wrapper for `fz_pool_alloc()`.
    Allocate a block of size bytes from the pool.
    """
    return _mupdf.pool_alloc(pool, size)

def pool_size(pool):
    r"""
    Wrapper for `fz_pool_size()`.
    The current size of the pool.

    The number of bytes of storage currently allocated to the pool.
    This is the total of the storage used for the blocks making
    up the pool, rather then total of the allocated blocks so far,
    so it will increase in 'lumps'.
    from the pool, then the pool size may still be X
    """
    return _mupdf.pool_size(pool)

def pool_strdup(pool, s):
    r"""
    Wrapper for `fz_pool_strdup()`.
    strdup equivalent allocating from the pool.
    """
    return _mupdf.pool_strdup(pool, s)

def pop_clip(dev):
    r""" Wrapper for `fz_pop_clip()`."""
    return _mupdf.pop_clip(dev)

def post_scale(m, sx, sy):
    r"""
    Wrapper for `fz_post_scale()`.
    Scale a matrix by postmultiplication.

    m: Pointer to the matrix to scale

    sx, sy: Scaling factors along the X- and Y-axes. A scaling
    factor of 1.0 will not cause any scaling along the relevant
    axis.

    Returns m (updated).
    """
    return _mupdf.post_scale(m, sx, sy)

def pre_rotate(m, degrees):
    r"""
    Wrapper for `fz_pre_rotate()`.
    Rotate a transformation by premultiplying.

    The premultiplied matrix is of the form
    [ cos(deg) sin(deg) -sin(deg) cos(deg) 0 0 ].

    m: Pointer to matrix to premultiply.

    degrees: Degrees of counter clockwise rotation. Values less
    than zero and greater than 360 are handled as expected.

    Returns m (updated).
    """
    return _mupdf.pre_rotate(m, degrees)

def pre_scale(m, sx, sy):
    r"""
    Wrapper for `fz_pre_scale()`.
    Scale a matrix by premultiplication.

    m: Pointer to the matrix to scale

    sx, sy: Scaling factors along the X- and Y-axes. A scaling
    factor of 1.0 will not cause any scaling along the relevant
    axis.

    Returns m (updated).
    """
    return _mupdf.pre_scale(m, sx, sy)

def pre_shear(m, sx, sy):
    r"""
    Wrapper for `fz_pre_shear()`.
    Premultiply a matrix with a shearing matrix.

    The shearing matrix is of the form [ 1 sy sx 1 0 0 ].

    m: pointer to matrix to premultiply

    sx, sy: Shearing factors. A shearing factor of 0.0 will not
    cause any shearing along the relevant axis.

    Returns m (updated).
    """
    return _mupdf.pre_shear(m, sx, sy)

def pre_translate(m, tx, ty):
    r"""
    Wrapper for `fz_pre_translate()`.
    Translate a matrix by premultiplication.

    m: The matrix to translate

    tx, ty: Translation distances along the X- and Y-axes. A
    translation of 0 will not cause any translation along the
    relevant axis.

    Returns m.
    """
    return _mupdf.pre_translate(m, tx, ty)

def prepare_t3_glyph(font, gid):
    r"""
    Wrapper for `fz_prepare_t3_glyph()`.
    Force a type3 font to cache the displaylist for a given glyph
    id.

    This caching can involve reading the underlying file, so must
    happen ahead of time, so we aren't suddenly forced to read the
    file while playing a displaylist back.
    """
    return _mupdf.prepare_t3_glyph(font, gid)

def previous_page(doc, loc):
    r"""
    Wrapper for `fz_previous_page()`.
    Function to get the location of the previous page (allowing for
    the end of chapters etc). If already at the start of the
    document, returns the current page.
    """
    return _mupdf.previous_page(doc, loc)

def print_stext_header_as_html(out):
    r""" Wrapper for `fz_print_stext_header_as_html()`."""
    return _mupdf.print_stext_header_as_html(out)

def print_stext_header_as_xhtml(out):
    r""" Wrapper for `fz_print_stext_header_as_xhtml()`."""
    return _mupdf.print_stext_header_as_xhtml(out)

def print_stext_page_as_html(out, page, id):
    r"""
    Wrapper for `fz_print_stext_page_as_html()`.
    Output structured text to a file in HTML (visual) format.
    """
    return _mupdf.print_stext_page_as_html(out, page, id)

def print_stext_page_as_json(out, page, scale):
    r"""
    Wrapper for `fz_print_stext_page_as_json()`.
    Output structured text to a file in JSON format.
    """
    return _mupdf.print_stext_page_as_json(out, page, scale)

def print_stext_page_as_text(out, page):
    r"""
    Wrapper for `fz_print_stext_page_as_text()`.
    Output structured text to a file in plain-text UTF-8 format.
    """
    return _mupdf.print_stext_page_as_text(out, page)

def print_stext_page_as_xhtml(out, page, id):
    r"""
    Wrapper for `fz_print_stext_page_as_xhtml()`.
    Output structured text to a file in XHTML (semantic) format.
    """
    return _mupdf.print_stext_page_as_xhtml(out, page, id)

def print_stext_page_as_xml(out, page, id):
    r"""
    Wrapper for `fz_print_stext_page_as_xml()`.
    Output structured text to a file in XML format.
    """
    return _mupdf.print_stext_page_as_xml(out, page, id)

def print_stext_trailer_as_html(out):
    r""" Wrapper for `fz_print_stext_trailer_as_html()`."""
    return _mupdf.print_stext_trailer_as_html(out)

def print_stext_trailer_as_xhtml(out):
    r""" Wrapper for `fz_print_stext_trailer_as_xhtml()`."""
    return _mupdf.print_stext_trailer_as_xhtml(out)

def process_opened_pages(doc, process_openend_page, state):
    r"""
    Wrapper for `fz_process_opened_pages()`.
    Iterates over all opened pages of the document, calling the
    provided callback for each page for processing. If the callback
    returns non-NULL then the iteration stops and that value is returned
    to the called of fz_process_opened_pages().

    The state pointer provided to fz_process_opened_pages() is
    passed on to the callback but is owned by the caller.

    Returns the first non-NULL value returned by the callback,
    or NULL if the callback returned NULL for all opened pages.
    """
    return _mupdf.process_opened_pages(doc, process_openend_page, state)

def process_shade(shade, ctm, scissor, prepare, process, process_arg):
    r"""
    Wrapper for `fz_process_shade()`.
    Process a shade, using supplied callback functions. This
    decomposes the shading to a mesh (even ones that are not
    natively meshes, such as linear or radial shadings), and
    processes triangles from those meshes.

    shade: The shade to process.

    ctm: The transform to use

    prepare: Callback function to 'prepare' each vertex.
    This function is passed an array of floats, and populates
    a fz_vertex structure.

    process: This function is passed 3 pointers to vertex
    structures, and actually performs the processing (typically
    filling the area between the vertexes).

    process_arg: An opaque argument passed through from caller
    to callback functions.
    """
    return _mupdf.process_shade(shade, ctm, scissor, prepare, process, process_arg)

def purge_glyph_cache():
    r"""
    Wrapper for `fz_purge_glyph_cache()`.
    Purge all the glyphs from the cache.
    """
    return _mupdf.purge_glyph_cache()

def quad_from_rect(r):
    r"""
    Wrapper for `fz_quad_from_rect()`.
    Convert a rect to a quad (losslessly).
    """
    return _mupdf.quad_from_rect(r)

def quadto(path, x0, y0, x1, y1):
    r"""
    Wrapper for `fz_quadto()`.
    Append a 'quadto' command to an open path. (For a
    quadratic bezier).

    path: The path to modify.

    x0, y0: The control coordinates for the quadratic curve.

    x1, y1: The end coordinates for the quadratic curve.

    Throws exceptions on failure to allocate, or attempting to
    modify a packed path.
    """
    return _mupdf.quadto(path, x0, y0, x1, y1)

def read(stm, data, len):
    r"""
    Wrapper for `fz_read()`.
    Read from a stream into a given data block.

    stm: The stream to read from.

    data: The data block to read into.

    len: The length of the data block (in bytes).

    Returns the number of bytes read. May throw exceptions.
    """
    return _mupdf.read(stm, data, len)

def read_all(stm, initial):
    r"""
    Wrapper for `fz_read_all()`.
    Read all of a stream into a buffer.

    stm: The stream to read from

    initial: Suggested initial size for the buffer.

    Returns a buffer created from reading from the stream. May throw
    exceptions on failure to allocate.
    """
    return _mupdf.read_all(stm, initial)

def read_archive_entry(arch, name):
    r"""
    Wrapper for `fz_read_archive_entry()`.
    Reads all bytes in an archive entry
    into a buffer.

    name: Entry name to look for, this must be an exact match to
    the entry name in the archive.
    """
    return _mupdf.read_archive_entry(arch, name)

def read_best(stm, initial):
    r"""
     Wrapper for `fz_read_best()`.

    This function has out-params. Python/C# wrappers look like:
    	`read_best(fz_stream *stm, size_t initial)` => `(fz_buffer *, int truncated)`

    	Attempt to read a stream into a buffer. If truncated
    	is NULL behaves as fz_read_all, sets a truncated flag in case of
    	error.

    	stm: The stream to read from.

    	initial: Suggested initial size for the buffer.

    	truncated: Flag to store success/failure indication in.

    	Returns a buffer created from reading from the stream.
    """
    return _mupdf.read_best(stm, initial)

def read_bits(stm, n):
    r"""
    Wrapper for `fz_read_bits()`.
    Read the next n bits from a stream (assumed to
    be packed most significant bit first).

    stm: The stream to read from.

    n: The number of bits to read, between 1 and 8*sizeof(int)
    inclusive.

    Returns -1 for EOF, or the required number of bits.
    """
    return _mupdf.read_bits(stm, n)

def read_byte(stm):
    r"""
    Wrapper for `fz_read_byte()`.
    Read the next byte from a stream.

    stm: The stream t read from.

    Returns -1 for end of stream, or the next byte. May
    throw exceptions.
    """
    return _mupdf.read_byte(stm)

def read_file(filename):
    r"""
    Wrapper for `fz_read_file()`.
    Read all the contents of a file into a buffer.
    """
    return _mupdf.read_file(filename)

def read_float(stm):
    r""" Wrapper for `fz_read_float()`."""
    return _mupdf.read_float(stm)

def read_float_le(stm):
    r""" Wrapper for `fz_read_float_le()`."""
    return _mupdf.read_float_le(stm)

def read_int16(stm):
    r""" Wrapper for `fz_read_int16()`."""
    return _mupdf.read_int16(stm)

def read_int16_le(stm):
    r""" Wrapper for `fz_read_int16_le()`."""
    return _mupdf.read_int16_le(stm)

def read_int32(stm):
    r""" Wrapper for `fz_read_int32()`."""
    return _mupdf.read_int32(stm)

def read_int32_le(stm):
    r""" Wrapper for `fz_read_int32_le()`."""
    return _mupdf.read_int32_le(stm)

def read_int64(stm):
    r""" Wrapper for `fz_read_int64()`."""
    return _mupdf.read_int64(stm)

def read_int64_le(stm):
    r""" Wrapper for `fz_read_int64_le()`."""
    return _mupdf.read_int64_le(stm)

def read_line(stm, buf, max):
    r"""
    Wrapper for `fz_read_line()`.
    Read a line from stream into the buffer until either a
    terminating newline or EOF, which it replaces with a null byte
    ('').

    Returns buf on success, and NULL when end of file occurs while
    no characters have been read.
    """
    return _mupdf.read_line(stm, buf, max)

def read_rbits(stm, n):
    r"""
    Wrapper for `fz_read_rbits()`.
    Read the next n bits from a stream (assumed to
    be packed least significant bit first).

    stm: The stream to read from.

    n: The number of bits to read, between 1 and 8*sizeof(int)
    inclusive.

    Returns (unsigned int)-1 for EOF, or the required number of bits.
    """
    return _mupdf.read_rbits(stm, n)

def read_string(stm, buffer, len):
    r"""
    Wrapper for `fz_read_string()`.
    Read a null terminated string from the stream into
    a buffer of a given length. The buffer will be null terminated.
    Throws on failure (including the failure to fit the entire
    string including the terminator into the buffer).
    """
    return _mupdf.read_string(stm, buffer, len)

def read_uint16(stm):
    r"""
    Wrapper for `fz_read_uint16()`.
    fz_read_[u]int(16|24|32|64)(_le)?

    Read a 16/32/64 bit signed/unsigned integer from stream,
    in big or little-endian byte orders.

    Throws an exception if EOF is encountered.
    """
    return _mupdf.read_uint16(stm)

def read_uint16_le(stm):
    r""" Wrapper for `fz_read_uint16_le()`."""
    return _mupdf.read_uint16_le(stm)

def read_uint24(stm):
    r""" Wrapper for `fz_read_uint24()`."""
    return _mupdf.read_uint24(stm)

def read_uint24_le(stm):
    r""" Wrapper for `fz_read_uint24_le()`."""
    return _mupdf.read_uint24_le(stm)

def read_uint32(stm):
    r""" Wrapper for `fz_read_uint32()`."""
    return _mupdf.read_uint32(stm)

def read_uint32_le(stm):
    r""" Wrapper for `fz_read_uint32_le()`."""
    return _mupdf.read_uint32_le(stm)

def read_uint64(stm):
    r""" Wrapper for `fz_read_uint64()`."""
    return _mupdf.read_uint64(stm)

def read_uint64_le(stm):
    r""" Wrapper for `fz_read_uint64_le()`."""
    return _mupdf.read_uint64_le(stm)

def realloc_no_throw(p, size):
    r"""
    Wrapper for `fz_realloc_no_throw()`.
    fz_realloc equivalent that returns NULL rather than throwing
    exceptions.
    """
    return _mupdf.realloc_no_throw(p, size)

def recognize_document(magic):
    r"""
    Wrapper for `fz_recognize_document()`.
    Given a magic find a document handler that can handle a
    document of this type.

    magic: Can be a filename extension (including initial period) or
    a mimetype.
    """
    return _mupdf.recognize_document(magic)

def recognize_image_format(p):
    r"""
    Wrapper for `fz_recognize_image_format()`.
    Recognise image format strings in the first 8 bytes from image
    data.
    """
    return _mupdf.recognize_image_format(p)

def rect_from_irect(bbox):
    r"""
    Wrapper for `fz_rect_from_irect()`.
    Convert a bbox into a rect.

    For our purposes, a rect can represent all the values we meet in
    a bbox, so nothing can go wrong.

    rect: A place to store the generated rectangle.

    bbox: The bbox to convert.

    Returns rect (updated).
    """
    return _mupdf.rect_from_irect(bbox)

def rect_from_quad(q):
    r"""
    Wrapper for `fz_rect_from_quad()`.
    Convert a quad to the smallest rect that covers it.
    """
    return _mupdf.rect_from_quad(q)

def rectto(path, x0, y0, x1, y1):
    r"""
    Wrapper for `fz_rectto()`.
    Append a 'rectto' command to an open path.

    The rectangle is equivalent to:
    	moveto x0 y0
    	lineto x1 y0
    	lineto x1 y1
    	lineto x0 y1
    	closepath

    path: The path to modify.

    x0, y0: First corner of the rectangle.

    x1, y1: Second corner of the rectangle.

    Throws exceptions on failure to allocate, or attempting to
    modify a packed path.
    """
    return _mupdf.rectto(path, x0, y0, x1, y1)

def register_document_handler(handler):
    r"""
    Wrapper for `fz_register_document_handler()`.
    Register a handler for a document type.

    handler: The handler to register.
    """
    return _mupdf.register_document_handler(handler)

def register_document_handlers():
    r"""
    Wrapper for `fz_register_document_handlers()`.
    Register handlers
    for all the standard document types supported in
    this build.
    """
    return _mupdf.register_document_handlers()

def remove_item(drop, key, type):
    r"""
    Wrapper for `fz_remove_item()`.
    Remove an item from the store.

    If an item indexed by the given key exists in the store, remove
    it.

    drop: The function used to free the value (to ensure we get a
    value of the correct type).

    key: The key used to find the item to remove.

    type: Functions used to manipulate the key.
    """
    return _mupdf.remove_item(drop, key, type)

def render_flags(dev, set, clear):
    r""" Wrapper for `fz_render_flags()`."""
    return _mupdf.render_flags(dev, set, clear)

def render_glyph_pixmap(font, gid, ctm, scissor, aa):
    r"""
    Wrapper for `fz_render_glyph_pixmap()`.
    Create a pixmap containing a rendered glyph.

    Lookup gid from font, clip it with scissor, and rendering it
    with aa bits of antialiasing into a new pixmap.

    The caller takes ownership of the pixmap and so must free it.

    Note: This function is no longer used for normal rendering
    operations, and is kept around just because we use it in the
    app. It should be considered "at risk" of removal from the API.
    """
    return _mupdf.render_glyph_pixmap(font, gid, ctm, scissor, aa)

def render_t3_glyph_direct(dev, font, gid, trm, gstate, def_cs):
    r"""
    Wrapper for `fz_render_t3_glyph_direct()`.
    Nasty PDF interpreter specific hernia, required to allow the
    interpreter to replay glyphs from a type3 font directly into
    the target device.

    This is only used in exceptional circumstances (such as type3
    glyphs that inherit current graphics state, or nested type3
    glyphs).
    """
    return _mupdf.render_t3_glyph_direct(dev, font, gid, trm, gstate, def_cs)

def rendering_intent_name(ri):
    r"""
    Wrapper for `fz_rendering_intent_name()`.
    Map from enumerated rendering intent to string.

    The returned string is static and therefore must not be freed.
    """
    return _mupdf.rendering_intent_name(ri)

def resize_buffer(buf, capacity):
    r"""
    Wrapper for `fz_resize_buffer()`.
    Ensure that a buffer has a given capacity,
    truncating data if required.

    capacity: The desired capacity for the buffer. If the current
    size of the buffer contents is smaller than capacity, it is
    truncated.
    """
    return _mupdf.resize_buffer(buf, capacity)

def resolve_link(doc, uri):
    r"""
     Wrapper for `fz_resolve_link()`.

    This function has out-params. Python/C# wrappers look like:
    	`resolve_link(fz_document *doc, const char *uri)` => `(fz_location, float xp, float yp)`

    	Resolve an internal link to a page number.

    	xp, yp: Pointer to store coordinate of destination on the page.

    	Returns (-1,-1) if the URI cannot be resolved.
    """
    return _mupdf.resolve_link(doc, uri)

def resolve_link_dest(doc, uri):
    r"""
    Wrapper for `fz_resolve_link_dest()`.
    Resolve an internal link to a page number, location, and possible viewing parameters.

    Returns location (-1,-1) if the URI cannot be resolved.
    """
    return _mupdf.resolve_link_dest(doc, uri)

def rethrow():
    r""" Wrapper for `fz_rethrow()`."""
    return _mupdf.rethrow()

def rethrow_if(errcode):
    r""" Wrapper for `fz_rethrow_if()`."""
    return _mupdf.rethrow_if(errcode)

def rotate(degrees):
    r"""
    Wrapper for `fz_rotate()`.
    Create a rotation matrix.

    The returned matrix is of the form
    [ cos(deg) sin(deg) -sin(deg) cos(deg) 0 0 ].

    m: Pointer to place to store matrix

    degrees: Degrees of counter clockwise rotation. Values less
    than zero and greater than 360 are handled as expected.

    Returns m.
    """
    return _mupdf.rotate(degrees)

def round_rect(rect):
    r"""
    Wrapper for `fz_round_rect()`.
    Round rectangle coordinates.

    Coordinates in a bounding box are integers, so rounding of the
    rects coordinates takes place. The top left corner is rounded
    upwards and left while the bottom right corner is rounded
    downwards and to the right.

    This differs from fz_irect_from_rect, in that fz_irect_from_rect
    slavishly follows the numbers (i.e any slight over/under
    calculations can cause whole extra pixels to be added).
    fz_round_rect allows for a small amount of rounding error when
    calculating the bbox.
    """
    return _mupdf.round_rect(rect)

def run_display_list(list, dev, ctm, scissor, cookie):
    r"""
    Wrapper for `fz_run_display_list()`.
    (Re)-run a display list through a device.

    list: A display list, created by fz_new_display_list and
    populated with objects from a page by running fz_run_page on a
    device obtained from fz_new_list_device.

    ctm: Transform to apply to display list contents. May include
    for example scaling and rotation, see fz_scale, fz_rotate and
    fz_concat. Set to fz_identity if no transformation is desired.

    scissor: Only the part of the contents of the display list
    visible within this area will be considered when the list is
    run through the device. This does not imply for tile objects
    contained in the display list.

    cookie: Communication mechanism between caller and library
    running the page. Intended for multi-threaded applications,
    while single-threaded applications set cookie to NULL. The
    caller may abort an ongoing page run. Cookie also communicates
    progress information back to the caller. The fields inside
    cookie are continually updated while the page is being run.
    """
    return _mupdf.run_display_list(list, dev, ctm, scissor, cookie)

def run_page(page, dev, transform, cookie):
    r"""
    Wrapper for `fz_run_page()`.
    Run a page through a device.

    page: Page obtained from fz_load_page.

    dev: Device obtained from fz_new_*_device.

    transform: Transform to apply to page. May include for example
    scaling and rotation, see fz_scale, fz_rotate and fz_concat.
    Set to fz_identity if no transformation is desired.

    cookie: Communication mechanism between caller and library
    rendering the page. Intended for multi-threaded applications,
    while single-threaded applications set cookie to NULL. The
    caller may abort an ongoing rendering of a page. Cookie also
    communicates progress information back to the caller. The
    fields inside cookie are continually updated while the page is
    rendering.
    """
    return _mupdf.run_page(page, dev, transform, cookie)

def run_page_annots(page, dev, transform, cookie):
    r"""
    Wrapper for `fz_run_page_annots()`.
    Run the annotations on a page through a device.
    """
    return _mupdf.run_page_annots(page, dev, transform, cookie)

def run_page_contents(page, dev, transform, cookie):
    r"""
    Wrapper for `fz_run_page_contents()`.
    Run a page through a device. Just the main
    page content, without the annotations, if any.

    page: Page obtained from fz_load_page.

    dev: Device obtained from fz_new_*_device.

    transform: Transform to apply to page. May include for example
    scaling and rotation, see fz_scale, fz_rotate and fz_concat.
    Set to fz_identity if no transformation is desired.

    cookie: Communication mechanism between caller and library
    rendering the page. Intended for multi-threaded applications,
    while single-threaded applications set cookie to NULL. The
    caller may abort an ongoing rendering of a page. Cookie also
    communicates progress information back to the caller. The
    fields inside cookie are continually updated while the page is
    rendering.
    """
    return _mupdf.run_page_contents(page, dev, transform, cookie)

def run_page_widgets(page, dev, transform, cookie):
    r"""
    Wrapper for `fz_run_page_widgets()`.
    Run the widgets on a page through a device.
    """
    return _mupdf.run_page_widgets(page, dev, transform, cookie)

def run_t3_glyph(font, gid, trm, dev):
    r"""
    Wrapper for `fz_run_t3_glyph()`.
    Run a glyph from a Type3 font to
    a given device.

    font: The font to find the glyph in.

    gid: The glyph to run.

    trm: The transform to apply.

    dev: The device to render onto.
    """
    return _mupdf.run_t3_glyph(font, gid, trm, dev)

def runeidx(str, p):
    r"""
    Wrapper for `fz_runeidx()`.
    Compute the index of a rune in a string.

    str: Pointer to beginning of a string.

    p: Pointer to a char in str.

    Returns the index of the rune pointed to by p in str.
    """
    return _mupdf.runeidx(str, p)

def runelen(rune):
    r"""
    Wrapper for `fz_runelen()`.
    Count how many chars are required to represent a rune.

    rune: The rune to encode.

    Returns the number of bytes required to represent this run in
    UTF8.
    """
    return _mupdf.runelen(rune)

def runeptr(str, idx):
    r"""
    Wrapper for `fz_runeptr()`.
    Obtain a pointer to the char representing the rune
    at a given index.

    str: Pointer to beginning of a string.

    idx: Index of a rune to return a char pointer to.

    Returns a pointer to the char where the desired rune starts,
    or NULL if the string ends before the index is reached.
    """
    return _mupdf.runeptr(str, idx)

def runetochar(str, rune):
    r"""
    Wrapper for `fz_runetochar()`.
    UTF8 encode a rune to a sequence of chars.

    str: Pointer to a place to put the UTF8 encoded character.

    rune: Pointer to a 'rune'.

    Returns the number of bytes the rune took to output.
    """
    return _mupdf.runetochar(str, rune)

def save_accelerator(doc, accel):
    r"""
    Wrapper for `fz_save_accelerator()`.
    Save accelerator data for the document to a given file.
    """
    return _mupdf.save_accelerator(doc, accel)

def save_bitmap_as_pbm(bitmap, filename):
    r"""
    Wrapper for `fz_save_bitmap_as_pbm()`.
    Save a bitmap as a pbm.
    """
    return _mupdf.save_bitmap_as_pbm(bitmap, filename)

def save_bitmap_as_pcl(bitmap, filename, append, pcl):
    r"""
    Wrapper for `fz_save_bitmap_as_pcl()`.
    Save a bitmap as mono PCL.
    """
    return _mupdf.save_bitmap_as_pcl(bitmap, filename, append, pcl)

def save_bitmap_as_pkm(bitmap, filename):
    r"""
    Wrapper for `fz_save_bitmap_as_pkm()`.
    Save a CMYK bitmap as a pkm.
    """
    return _mupdf.save_bitmap_as_pkm(bitmap, filename)

def save_bitmap_as_pwg(bitmap, filename, append, pwg):
    r"""
    Wrapper for `fz_save_bitmap_as_pwg()`.
    Save a bitmap as a PWG.
    """
    return _mupdf.save_bitmap_as_pwg(bitmap, filename, append, pwg)

def save_buffer(buf, filename):
    r"""
    Wrapper for `fz_save_buffer()`.
    Save the contents of a buffer to a file.
    """
    return _mupdf.save_buffer(buf, filename)

def save_pixmap_as_pam(pixmap, filename):
    r"""
    Wrapper for `fz_save_pixmap_as_pam()`.
    Save a pixmap as a pnm (greyscale, rgb or cmyk, with or without
    alpha).
    """
    return _mupdf.save_pixmap_as_pam(pixmap, filename)

def save_pixmap_as_pbm(pixmap, filename):
    r"""
    Wrapper for `fz_save_pixmap_as_pbm()`.
    Save a pixmap as a pbm. (Performing halftoning).
    """
    return _mupdf.save_pixmap_as_pbm(pixmap, filename)

def save_pixmap_as_pcl(pixmap, filename, append, pcl):
    r"""
    Wrapper for `fz_save_pixmap_as_pcl()`.
    Save an (RGB) pixmap as color PCL.
    """
    return _mupdf.save_pixmap_as_pcl(pixmap, filename, append, pcl)

def save_pixmap_as_pclm(pixmap, filename, append, options):
    r"""
    Wrapper for `fz_save_pixmap_as_pclm()`.
    Save a (Greyscale or RGB) pixmap as pclm.
    """
    return _mupdf.save_pixmap_as_pclm(pixmap, filename, append, options)

def save_pixmap_as_pdfocr(pixmap, filename, append, options):
    r"""
    Wrapper for `fz_save_pixmap_as_pdfocr()`.
    Save a (Greyscale or RGB) pixmap as pdfocr.
    """
    return _mupdf.save_pixmap_as_pdfocr(pixmap, filename, append, options)

def save_pixmap_as_pkm(pixmap, filename):
    r"""
    Wrapper for `fz_save_pixmap_as_pkm()`.
    Save a CMYK pixmap as a pkm. (Performing halftoning).
    """
    return _mupdf.save_pixmap_as_pkm(pixmap, filename)

def save_pixmap_as_png(pixmap, filename):
    r"""
    Wrapper for `fz_save_pixmap_as_png()`.
    Save a (Greyscale or RGB) pixmap as a png.
    """
    return _mupdf.save_pixmap_as_png(pixmap, filename)

def save_pixmap_as_pnm(pixmap, filename):
    r"""
    Wrapper for `fz_save_pixmap_as_pnm()`.
    Save a pixmap as a pnm (greyscale or rgb, no alpha).
    """
    return _mupdf.save_pixmap_as_pnm(pixmap, filename)

def save_pixmap_as_ps(pixmap, filename, append):
    r"""
    Wrapper for `fz_save_pixmap_as_ps()`.
    Save a (gray, rgb, or cmyk, no alpha) pixmap out as postscript.
    """
    return _mupdf.save_pixmap_as_ps(pixmap, filename, append)

def save_pixmap_as_psd(pixmap, filename):
    r"""
    Wrapper for `fz_save_pixmap_as_psd()`.
    Save a pixmap as a PSD file.
    """
    return _mupdf.save_pixmap_as_psd(pixmap, filename)

def save_pixmap_as_pwg(pixmap, filename, append, pwg):
    r"""
    Wrapper for `fz_save_pixmap_as_pwg()`.
    Save a pixmap as a PWG.
    """
    return _mupdf.save_pixmap_as_pwg(pixmap, filename, append, pwg)

def scale(sx, sy):
    r"""
    Wrapper for `fz_scale()`.
    Create a scaling matrix.

    The returned matrix is of the form [ sx 0 0 sy 0 0 ].

    m: Pointer to the matrix to populate

    sx, sy: Scaling factors along the X- and Y-axes. A scaling
    factor of 1.0 will not cause any scaling along the relevant
    axis.

    Returns m.
    """
    return _mupdf.scale(sx, sy)

def search_chapter_page_number(doc, chapter, page, needle, hit_bbox, hit_max):
    r"""
     Wrapper for `fz_search_chapter_page_number()`.

    This function has out-params. Python/C# wrappers look like:
    	`search_chapter_page_number(fz_document *doc, int chapter, int page, const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
    """
    return _mupdf.search_chapter_page_number(doc, chapter, page, needle, hit_bbox, hit_max)

def search_display_list(list, needle, hit_bbox, hit_max):
    r"""
     Wrapper for `fz_search_display_list()`.

    This function has out-params. Python/C# wrappers look like:
    	`search_display_list(fz_display_list *list, const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
    """
    return _mupdf.search_display_list(list, needle, hit_bbox, hit_max)

def search_page(page, needle, hit_bbox, hit_max):
    r"""
     Wrapper for `fz_search_page()`.

    This function has out-params. Python/C# wrappers look like:
    	`search_page(fz_page *page, const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`

    	Search for the 'needle' text on the page.
    	Record the hits in the hit_bbox array and return the number of
    	hits. Will stop looking once it has filled hit_max rectangles.
    """
    return _mupdf.search_page(page, needle, hit_bbox, hit_max)

def search_page_number(doc, number, needle, hit_bbox, hit_max):
    r"""
     Wrapper for `fz_search_page_number()`.

    This function has out-params. Python/C# wrappers look like:
    	`search_page_number(fz_document *doc, int number, const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
    """
    return _mupdf.search_page_number(doc, number, needle, hit_bbox, hit_max)

def search_stext_page(text, needle, hit_bbox, hit_max):
    r"""
     Wrapper for `fz_search_stext_page()`.

    This function has out-params. Python/C# wrappers look like:
    	`search_stext_page(fz_stext_page *text, const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`

    	Search for occurrence of 'needle' in text page.

    	Return the number of hits and store hit quads in the passed in
    	array.

    	NOTE: This is an experimental interface and subject to change
    	without notice.
    """
    return _mupdf.search_stext_page(text, needle, hit_bbox, hit_max)

def seek(stm, offset, whence):
    r"""
    Wrapper for `fz_seek()`.
    Seek within a stream.

    stm: The stream to seek within.

    offset: The offset to seek to.

    whence: From where the offset is measured (see fseek).
    """
    return _mupdf.seek(stm, offset, whence)

def seek_output(out, off, whence):
    r"""
    Wrapper for `fz_seek_output()`.
    Seek to the specified file position.
    See fseek for arguments.

    Throw an error on unseekable outputs.
    """
    return _mupdf.seek_output(out, off, whence)

def separation_current_behavior(sep, separation):
    r"""
    Wrapper for `fz_separation_current_behavior()`.
    Test for the current behavior of a separation.
    """
    return _mupdf.separation_current_behavior(sep, separation)

def separation_equivalent(seps, idx, dst_cs, prf, color_params):
    r"""
     Wrapper for `fz_separation_equivalent()`.

    This function has out-params. Python/C# wrappers look like:
    	`separation_equivalent(const fz_separations *seps, int idx, fz_colorspace *dst_cs, fz_colorspace *prf, fz_color_params color_params)` => float dst_color

    	Get the equivalent separation color in a given colorspace.
    """
    return _mupdf.separation_equivalent(seps, idx, dst_cs, prf, color_params)

def separation_name(sep, separation):
    r""" Wrapper for `fz_separation_name()`."""
    return _mupdf.separation_name(sep, separation)

def set_aa_level(bits):
    r"""
    Wrapper for `fz_set_aa_level()`.
    Set the number of bits of antialiasing we should
    use (for both text and graphics).

    bits: The number of bits of antialiasing to use (values are
    clamped to within the 0 to 8 range).
    """
    return _mupdf.set_aa_level(bits)

def set_compressed_image_buffer(cimg, buf):
    r""" Wrapper for `fz_set_compressed_image_buffer()`."""
    return _mupdf.set_compressed_image_buffer(cimg, buf)

def set_default_cmyk(default_cs, cs):
    r""" Wrapper for `fz_set_default_cmyk()`."""
    return _mupdf.set_default_cmyk(default_cs, cs)

def set_default_colorspaces(dev, default_cs):
    r""" Wrapper for `fz_set_default_colorspaces()`."""
    return _mupdf.set_default_colorspaces(dev, default_cs)

def set_default_gray(default_cs, cs):
    r"""
    Wrapper for `fz_set_default_gray()`.
    Set new defaults within the default colorspace structure.

    New references are taken to the new default, and references to
    the old defaults dropped.

    Never throws exceptions.
    """
    return _mupdf.set_default_gray(default_cs, cs)

def set_default_output_intent(default_cs, cs):
    r""" Wrapper for `fz_set_default_output_intent()`."""
    return _mupdf.set_default_output_intent(default_cs, cs)

def set_default_rgb(default_cs, cs):
    r""" Wrapper for `fz_set_default_rgb()`."""
    return _mupdf.set_default_rgb(default_cs, cs)

def set_error_callback(error_cb, user):
    r"""
    Wrapper for `fz_set_error_callback()`.
    Set the error callback. This will be called as part of the
    exception handling.

    The callback must not throw exceptions!
    """
    return _mupdf.set_error_callback(error_cb, user)

def set_font_bbox(font, xmin, ymin, xmax, ymax):
    r"""
    Wrapper for `fz_set_font_bbox()`.
    Set the font bbox.

    font: The font to set the bbox for.

    xmin, ymin, xmax, ymax: The bounding box.
    """
    return _mupdf.set_font_bbox(font, xmin, ymin, xmax, ymax)

def set_graphics_aa_level(bits):
    r"""
    Wrapper for `fz_set_graphics_aa_level()`.
    Set the number of bits of antialiasing we
    should use for graphics.

    bits: The number of bits of antialiasing to use (values are
    clamped to within the 0 to 8 range).
    """
    return _mupdf.set_graphics_aa_level(bits)

def set_graphics_min_line_width(min_line_width):
    r"""
    Wrapper for `fz_set_graphics_min_line_width()`.
    Set the minimum line width to be
    used for stroked lines.

    min_line_width: The minimum line width to use (in pixels).
    """
    return _mupdf.set_graphics_min_line_width(min_line_width)

def set_metadata(doc, key, value):
    r""" Wrapper for `fz_set_metadata()`."""
    return _mupdf.set_metadata(doc, key, value)

def set_pixmap_image_tile(cimg, pix):
    r""" Wrapper for `fz_set_pixmap_image_tile()`."""
    return _mupdf.set_pixmap_image_tile(cimg, pix)

def set_pixmap_resolution(pix, xres, yres):
    r"""
    Wrapper for `fz_set_pixmap_resolution()`.
    Set the pixels per inch resolution of the pixmap.
    """
    return _mupdf.set_pixmap_resolution(pix, xres, yres)

def set_separation_behavior(sep, separation, behavior):
    r"""
    Wrapper for `fz_set_separation_behavior()`.
    Control the rendering of a given separation.
    """
    return _mupdf.set_separation_behavior(sep, separation, behavior)

def set_stddbg(out):
    r"""
    Wrapper for `fz_set_stddbg()`.
    Set the output stream to be used for fz_stddbg. Set to NULL to
    reset to default (stderr).
    """
    return _mupdf.set_stddbg(out)

def set_text_aa_level(bits):
    r"""
    Wrapper for `fz_set_text_aa_level()`.
    Set the number of bits of antialiasing we
    should use for text.

    bits: The number of bits of antialiasing to use (values are
    clamped to within the 0 to 8 range).
    """
    return _mupdf.set_text_aa_level(bits)

def set_use_document_css(use):
    r"""
    Wrapper for `fz_set_use_document_css()`.
    Toggle whether to respect document styles in HTML and EPUB.
    """
    return _mupdf.set_use_document_css(use)

def set_user_context(user):
    r"""
    Wrapper for `fz_set_user_context()`.
    Set the user field in the context.

    NULL initially, this field can be set to any opaque value
    required by the user. It is copied on clones.
    """
    return _mupdf.set_user_context(user)

def set_user_css(text):
    r"""
    Wrapper for `fz_set_user_css()`.
    Set the user stylesheet source text for use with HTML and EPUB.
    """
    return _mupdf.set_user_css(text)

def set_warning_callback(warning_cb, user):
    r"""
    Wrapper for `fz_set_warning_callback()`.
    Set the warning callback. This will be called as part of the
    exception handling.

    The callback must not throw exceptions!
    """
    return _mupdf.set_warning_callback(warning_cb, user)

def sha256_final(state, digest):
    r"""
    Wrapper for `fz_sha256_final()`.
    MD5 finalization. Ends an MD5 message-digest operation, writing
    the message digest and zeroizing the context.

    Never throws an exception.
    """
    return _mupdf.sha256_final(state, digest)

def sha256_init(state):
    r"""
    Wrapper for `fz_sha256_init()`.
    SHA256 initialization. Begins an SHA256 operation, initialising
    the supplied context.

    Never throws an exception.
    """
    return _mupdf.sha256_init(state)

def sha256_update(state, input, inlen):
    r"""
    Wrapper for `fz_sha256_update()`.
    SHA256 block update operation. Continues an SHA256 message-
    digest operation, processing another message block, and updating
    the context.

    Never throws an exception.
    """
    return _mupdf.sha256_update(state, input, inlen)

def sha384_final(state, digest):
    r"""
    Wrapper for `fz_sha384_final()`.
    SHA384 finalization. Ends an SHA384 message-digest operation,
    writing the message digest and zeroizing the context.

    Never throws an exception.
    """
    return _mupdf.sha384_final(state, digest)

def sha384_init(state):
    r"""
    Wrapper for `fz_sha384_init()`.
    SHA384 initialization. Begins an SHA384 operation, initialising
    the supplied context.

    Never throws an exception.
    """
    return _mupdf.sha384_init(state)

def sha384_update(state, input, inlen):
    r"""
    Wrapper for `fz_sha384_update()`.
    SHA384 block update operation. Continues an SHA384 message-
    digest operation, processing another message block, and updating
    the context.

    Never throws an exception.
    """
    return _mupdf.sha384_update(state, input, inlen)

def sha512_final(state, digest):
    r"""
    Wrapper for `fz_sha512_final()`.
    SHA512 finalization. Ends an SHA512 message-digest operation,
    writing the message digest and zeroizing the context.

    Never throws an exception.
    """
    return _mupdf.sha512_final(state, digest)

def sha512_init(state):
    r"""
    Wrapper for `fz_sha512_init()`.
    SHA512 initialization. Begins an SHA512 operation, initialising
    the supplied context.

    Never throws an exception.
    """
    return _mupdf.sha512_init(state)

def sha512_update(state, input, inlen):
    r"""
    Wrapper for `fz_sha512_update()`.
    SHA512 block update operation. Continues an SHA512 message-
    digest operation, processing another message block, and updating
    the context.

    Never throws an exception.
    """
    return _mupdf.sha512_update(state, input, inlen)

def shear(sx, sy):
    r"""
    Wrapper for `fz_shear()`.
    Create a shearing matrix.

    The returned matrix is of the form [ 1 sy sx 1 0 0 ].

    m: pointer to place to store returned matrix

    sx, sy: Shearing factors. A shearing factor of 0.0 will not
    cause any shearing along the relevant axis.

    Returns m.
    """
    return _mupdf.shear(sx, sy)

def show_glyph(text, font, trm, glyph, unicode, wmode, bidi_level, markup_dir, language):
    r"""
    Wrapper for `fz_show_glyph()`.
    Add a glyph/unicode value to a text object.

    text: Text object to add to.

    font: The font the glyph should be added in.

    trm: The transform to use for the glyph.

    glyph: The glyph id to add.

    unicode: The unicode character for the glyph.

    wmode: 1 for vertical mode, 0 for horizontal.

    bidi_level: The bidirectional level for this glyph.

    markup_dir: The direction of the text as specified in the
    markup.

    language: The language in use (if known, 0 otherwise)
    (e.g. FZ_LANG_zh_Hans).

    Throws exception on failure to allocate.
    """
    return _mupdf.show_glyph(text, font, trm, glyph, unicode, wmode, bidi_level, markup_dir, language)

def show_string(text, font, trm, s, wmode, bidi_level, markup_dir, language):
    r"""
    Wrapper for `fz_show_string()`.
    Add a UTF8 string to a text object.

    text: Text object to add to.

    font: The font the string should be added in.

    trm: The transform to use.

    s: The utf-8 string to add.

    wmode: 1 for vertical mode, 0 for horizontal.

    bidi_level: The bidirectional level for this glyph.

    markup_dir: The direction of the text as specified in the markup.

    language: The language in use (if known, 0 otherwise)
    	(e.g. FZ_LANG_zh_Hans).

    Returns the transform updated with the advance width of the
    string.
    """
    return _mupdf.show_string(text, font, trm, s, wmode, bidi_level, markup_dir, language)

def shrink_store(percent):
    r"""
    Wrapper for `fz_shrink_store()`.
    Evict items from the store until the total size of
    the objects in the store is reduced to a given percentage of its
    current size.

    percent: %age of current size to reduce the store to.

    Returns non zero if we managed to free enough memory, zero
    otherwise.
    """
    return _mupdf.shrink_store(percent)

def skip(stm, len):
    r"""
    Wrapper for `fz_skip()`.
    Read from a stream discarding data.

    stm: The stream to read from.

    len: The number of bytes to read.

    Returns the number of bytes read. May throw exceptions.
    """
    return _mupdf.skip(stm, len)

def skip_space(stm):
    r"""
    Wrapper for `fz_skip_space()`.
    Skip over whitespace (bytes <= 32) in a stream.
    """
    return _mupdf.skip_space(stm)

def skip_string(stm, str):
    r"""
    Wrapper for `fz_skip_string()`.
    Skip over a given string in a stream. Return 0 if successfully
    skipped, non-zero otherwise. As many characters will be skipped
    over as matched in the string.
    """
    return _mupdf.skip_string(stm, str)

def snap_selection(page, ap, bp, mode):
    r""" Wrapper for `fz_snap_selection()`."""
    return _mupdf.snap_selection(page, ap, bp, mode)

def start_throw_on_repair():
    r""" Wrapper for `fz_start_throw_on_repair()`."""
    return _mupdf.start_throw_on_repair()

def stat_mtime(path):
    r""" Wrapper for `fz_stat_mtime()`."""
    return _mupdf.stat_mtime(path)

def stddbg():
    r"""
    Wrapper for `fz_stddbg()`.
    Retrieve an fz_output for the default debugging stream. On
    Windows this will be OutputDebugString for non-console apps.
    Otherwise, it is always fz_stderr.

    Optionally may be fz_dropped when finished with.
    """
    return _mupdf.stddbg()

def stderr_():
    r"""
    Wrapper for `fz_stderr()`.
    Retrieve an fz_output that directs to stdout.

    Optionally may be fz_dropped when finished with.
    """
    return _mupdf.stderr_()

def stdout_():
    r"""
    Wrapper for `fz_stdout()`.
    Retrieve an fz_output that directs to stdout.

    Optionally may be fz_dropped when finished with.
    """
    return _mupdf.stdout_()

def store_item(key, val, itemsize, type):
    r"""
    Wrapper for `fz_store_item()`.
    Add an item to the store.

    Add an item into the store, returning NULL for success. If an
    item with the same key is found in the store, then our item will
    not be inserted, and the function will return a pointer to that
    value instead. This function takes its own reference to val, as
    required (i.e. the caller maintains ownership of its own
    reference).

    key: The key used to index the item.

    val: The value to store.

    itemsize: The size in bytes of the value (as counted towards the
    store size).

    type: Functions used to manipulate the key.
    """
    return _mupdf.store_item(key, val, itemsize, type)

def store_scavenge(size):
    r"""
     Wrapper for `fz_store_scavenge()`.

    This function has out-params. Python/C# wrappers look like:
    	`store_scavenge(size_t size)` => `(int, int phase)`

    	Internal function used as part of the scavenging
    	allocator; when we fail to allocate memory, before returning a
    	failure to the caller, we try to scavenge space within the store
    	by evicting at least 'size' bytes. The allocator then retries.

    	size: The number of bytes we are trying to have free.

    	phase: What phase of the scavenge we are in. Updated on exit.

    	Returns non zero if we managed to free any memory.
    """
    return _mupdf.store_scavenge(size)

def store_scavenge_external(size):
    r"""
     Wrapper for `fz_store_scavenge_external()`.

    This function has out-params. Python/C# wrappers look like:
    	`store_scavenge_external(size_t size)` => `(int, int phase)`

    	External function for callers to use
    	to scavenge while trying allocations.

    	size: The number of bytes we are trying to have free.

    	phase: What phase of the scavenge we are in. Updated on exit.

    	Returns non zero if we managed to free any memory.
    """
    return _mupdf.store_scavenge_external(size)

def strcasecmp(a, b):
    r"""
    Wrapper for `fz_strcasecmp()`.
    Case insensitive (ASCII only) string comparison.
    """
    return _mupdf.strcasecmp(a, b)

def strdup(s):
    r"""
    Wrapper for `fz_strdup()`.
    Portable strdup implementation, using fz allocators.
    """
    return _mupdf.strdup(s)

def stream_from_output(arg_1):
    r"""
    Wrapper for `fz_stream_from_output()`.
    Obtain the fz_output in the form of a fz_stream.

    This allows data to be read back from some forms of fz_output
    object. When finished reading, the fz_stream should be released
    by calling fz_drop_stream. Until the fz_stream is dropped, no
    further operations should be performed on the fz_output object.
    """
    return _mupdf.stream_from_output(arg_1)

def string_from_buffer(buf):
    r"""
    Wrapper for `fz_string_from_buffer()`.
    Ensure that a buffer's data ends in a
    0 byte, and return a pointer to it.
    """
    return _mupdf.string_from_buffer(buf)

def string_from_text_language(str, lang):
    r"""
    Wrapper for `fz_string_from_text_language()`.
    Recover ISO 639 (639-{1,2,3,5}) language specification
    strings losslessly from a 15 bit fz_text_language code.

    No validation is carried out. See note above.
    """
    return _mupdf.string_from_text_language(str, lang)

def strlcat(dst, src, n):
    r"""
    Wrapper for `fz_strlcat()`.
    Concatenate 2 strings, with a maximum length.

    dst: pointer to first string in a buffer of n bytes.

    src: pointer to string to concatenate.

    n: Size (in bytes) of buffer that dst is in.

    Returns the real length that a concatenated dst + src would have
    been (not including terminator).
    """
    return _mupdf.strlcat(dst, src, n)

def strlcpy(dst, src, n):
    r"""
    Wrapper for `fz_strlcpy()`.
    Copy at most n-1 chars of a string into a destination
    buffer with null termination, returning the real length of the
    initial string (excluding terminator).

    dst: Destination buffer, at least n bytes long.

    src: C string (non-NULL).

    n: Size of dst buffer in bytes.

    Returns the length (excluding terminator) of src.
    """
    return _mupdf.strlcpy(dst, src, n)

def strncasecmp(a, b, n):
    r""" Wrapper for `fz_strncasecmp()`."""
    return _mupdf.strncasecmp(a, b, n)

def strnlen(s, maxlen):
    r"""
    Wrapper for `fz_strnlen()`.
    Return strlen(s), if that is less than maxlen, or maxlen if
    there is no null byte ('') among the first maxlen bytes.
    """
    return _mupdf.strnlen(s, maxlen)

def stroke_path(dev, path, stroke, ctm, colorspace, color, alpha, color_params):
    r""" Wrapper for `fz_stroke_path()`."""
    return _mupdf.stroke_path(dev, path, stroke, ctm, colorspace, color, alpha, color_params)

def stroke_text(dev, text, stroke, ctm, colorspace, color, alpha, color_params):
    r""" Wrapper for `fz_stroke_text()`."""
    return _mupdf.stroke_text(dev, text, stroke, ctm, colorspace, color, alpha, color_params)

def strsep(delim):
    r"""
     Wrapper for `fz_strsep()`.

    This function has out-params. Python/C# wrappers look like:
    	`strsep(const char *delim)` => `(char *, char *stringp)`

    	Given a pointer to a C string (or a pointer to NULL) break
    	it at the first occurrence of a delimiter char (from a given
    	set).

    	stringp: Pointer to a C string pointer (or NULL). Updated on
    	exit to point to the first char of the string after the
    	delimiter that was found. The string pointed to by stringp will
    	be corrupted by this call (as the found delimiter will be
    	overwritten by 0).

    	delim: A C string of acceptable delimiter characters.

    	Returns a pointer to a C string containing the chars of stringp
    	up to the first delimiter char (or the end of the string), or
    	NULL.
    """
    return _mupdf.strsep(delim)

def subpixel_adjust(ctm, subpix_ctm, qe, qf):
    r"""
    Wrapper for `fz_subpixel_adjust()`.
    Perform subpixel quantisation and adjustment on a glyph matrix.

    ctm: On entry, the desired 'ideal' transformation for a glyph.
    On exit, adjusted to a (very similar) transformation quantised
    for subpixel caching.

    subpix_ctm: Initialised by the routine to the transform that
    should be used to render the glyph.

    qe, qf: which subpixel position we quantised to.

    Returns: the size of the glyph.

    Note: This is currently only exposed for use in our app. It
    should be considered "at risk" of removal from the API.
    """
    return _mupdf.subpixel_adjust(ctm, subpix_ctm, qe, qf)

def sync_bits(stm):
    r"""
    Wrapper for `fz_sync_bits()`.
    Called after reading bits to tell the stream
    that we are about to return to reading bytewise. Resyncs
    the stream to whole byte boundaries.
    """
    return _mupdf.sync_bits(stm)

def tell(stm):
    r"""
    Wrapper for `fz_tell()`.
    return the current reading position within a stream
    """
    return _mupdf.tell(stm)

def tell_output(out):
    r"""
    Wrapper for `fz_tell_output()`.
    Return the current file position.

    Throw an error on untellable outputs.
    """
    return _mupdf.tell_output(out)

def terminate_buffer(buf):
    r"""
    Wrapper for `fz_terminate_buffer()`.
    Zero-terminate buffer in order to use as a C string.

    This byte is invisible and does not affect the length of the
    buffer as returned by fz_buffer_storage. The zero byte is
    written *after* the data, and subsequent writes will overwrite
    the terminating byte.

    Subsequent changes to the size of the buffer (such as by
    fz_buffer_trim, fz_buffer_grow, fz_resize_buffer, etc) may
    invalidate this.
    """
    return _mupdf.terminate_buffer(buf)

def text_aa_level():
    r"""
    Wrapper for `fz_text_aa_level()`.
    Get the number of bits of antialiasing we are
    using for text. Between 0 and 8.
    """
    return _mupdf.text_aa_level()

def text_language_from_string(str):
    r"""
    Wrapper for `fz_text_language_from_string()`.
    Convert ISO 639 (639-{1,2,3,5}) language specification
    strings losslessly to a 15 bit fz_text_language code.

    No validation is carried out. Obviously invalid (out
    of spec) codes will be mapped to FZ_LANG_UNSET, but
    well-formed (but undefined) codes will be blithely
    accepted.
    """
    return _mupdf.text_language_from_string(str)

def tint_pixmap(pix, black, white):
    r"""
    Wrapper for `fz_tint_pixmap()`.
    Tint all the pixels in an RGB, BGR, or Gray pixmap.

    black: Map black to this hexadecimal RGB color.

    white: Map white to this hexadecimal RGB color.
    """
    return _mupdf.tint_pixmap(pix, black, white)

def tolower(c):
    r"""
    Wrapper for `fz_tolower()`.
    Unicode aware tolower and toupper functions.
    """
    return _mupdf.tolower(c)

def toupper(c):
    r""" Wrapper for `fz_toupper()`."""
    return _mupdf.toupper(c)

def transform_page(mediabox, resolution, rotate):
    r"""
    Wrapper for `fz_transform_page()`.
    Create transform matrix to draw page
    at a given resolution and rotation. Adjusts the scaling
    factors so that the page covers whole number of
    pixels and adjust the page origin to be at 0,0.
    """
    return _mupdf.transform_page(mediabox, resolution, rotate)

def transform_path(path, transform):
    r"""
    Wrapper for `fz_transform_path()`.
    Transform a path by a given
    matrix.

    path: The path to modify (must not be a packed path).

    transform: The transform to apply.

    Throws exceptions if the path is packed, or on failure
    to allocate.
    """
    return _mupdf.transform_path(path, transform)

def transform_point(point, m):
    r"""
    Wrapper for `fz_transform_point()`.
    Apply a transformation to a point.

    transform: Transformation matrix to apply. See fz_concat,
    fz_scale, fz_rotate and fz_translate for how to create a
    matrix.

    point: Pointer to point to update.

    Returns transform (unchanged).
    """
    return _mupdf.transform_point(point, m)

def transform_point_xy(x, y, m):
    r""" Wrapper for `fz_transform_point_xy()`."""
    return _mupdf.transform_point_xy(x, y, m)

def transform_quad(q, m):
    r"""
    Wrapper for `fz_transform_quad()`.
    Transform a quad by a matrix.
    """
    return _mupdf.transform_quad(q, m)

def transform_rect(rect, m):
    r"""
    Wrapper for `fz_transform_rect()`.
    Apply a transform to a rectangle.

    After the four corner points of the axis-aligned rectangle
    have been transformed it may not longer be axis-aligned. So a
    new axis-aligned rectangle is created covering at least the
    area of the transformed rectangle.

    transform: Transformation matrix to apply. See fz_concat,
    fz_scale and fz_rotate for how to create a matrix.

    rect: Rectangle to be transformed. The two special cases
    fz_empty_rect and fz_infinite_rect, may be used but are
    returned unchanged as expected.
    """
    return _mupdf.transform_rect(rect, m)

def transform_vector(vector, m):
    r"""
    Wrapper for `fz_transform_vector()`.
    Apply a transformation to a vector.

    transform: Transformation matrix to apply. See fz_concat,
    fz_scale and fz_rotate for how to create a matrix. Any
    translation will be ignored.

    vector: Pointer to vector to update.
    """
    return _mupdf.transform_vector(vector, m)

def translate(tx, ty):
    r"""
    Wrapper for `fz_translate()`.
    Create a translation matrix.

    The returned matrix is of the form [ 1 0 0 1 tx ty ].

    m: A place to store the created matrix.

    tx, ty: Translation distances along the X- and Y-axes. A
    translation of 0 will not cause any translation along the
    relevant axis.

    Returns m.
    """
    return _mupdf.translate(tx, ty)

def translate_irect(a, xoff, yoff):
    r""" Wrapper for `fz_translate_irect()`."""
    return _mupdf.translate_irect(a, xoff, yoff)

def translate_rect(a, xoff, yoff):
    r"""
    Wrapper for `fz_translate_rect()`.
    Translate bounding box.

    Translate a bbox by a given x and y offset. Allows for overflow.
    """
    return _mupdf.translate_rect(a, xoff, yoff)

def tree_insert(root, key, value):
    r"""
    Wrapper for `fz_tree_insert()`.
    Insert a new key/value pair and rebalance the tree.
    Return the new root of the tree after inserting and rebalancing.
    May be called with a NULL root to create a new tree.

    No data is copied into the tree structure; key and value are
    merely kept as pointers.
    """
    return _mupdf.tree_insert(root, key, value)

def tree_lookup(node, key):
    r"""
    Wrapper for `fz_tree_lookup()`.
    Look for the value of a node in the tree with the given key.

    Simple pointer equivalence is used for key.

    Returns NULL for no match.
    """
    return _mupdf.tree_lookup(node, key)

def trim_buffer(buf):
    r"""
    Wrapper for `fz_trim_buffer()`.
    Trim wasted capacity from a buffer by resizing internal memory.
    """
    return _mupdf.trim_buffer(buf)

def trim_path(path):
    r"""
    Wrapper for `fz_trim_path()`.
    Minimise the internal storage used by a path.

    As paths are constructed, the internal buffers
    grow. To avoid repeated reallocations they
    grow with some spare space. Once a path has
    been fully constructed, this call allows the
    excess space to be trimmed.
    """
    return _mupdf.trim_path(path)

def truncate_output(arg_1):
    r"""
    Wrapper for `fz_truncate_output()`.
    Truncate the output at the current position.

    This allows output streams which have seeked back from the end
    of their storage to be truncated at the current point.
    """
    return _mupdf.truncate_output(arg_1)

def try_invert_matrix(inv, src):
    r"""
    Wrapper for `fz_try_invert_matrix()`.
    Attempt to create an inverse matrix.

    inverse: Place to store inverse matrix.

    matrix: Matrix to invert. A degenerate matrix, where the
    determinant is equal to zero, can not be inverted.

    Returns 1 if matrix is degenerate (singular), or 0 otherwise.
    """
    return _mupdf.try_invert_matrix(inv, src)

def tune_image_decode(image_decode, arg):
    r"""
    Wrapper for `fz_tune_image_decode()`.
    Set the tuning function to use for
    image decode.

    image_decode: Function to use.

    arg: Opaque argument to be passed to tuning function.
    """
    return _mupdf.tune_image_decode(image_decode, arg)

def tune_image_scale(image_scale, arg):
    r"""
    Wrapper for `fz_tune_image_scale()`.
    Set the tuning function to use for
    image scaling.

    image_scale: Function to use.

    arg: Opaque argument to be passed to tuning function.
    """
    return _mupdf.tune_image_scale(image_scale, arg)

def unicode_from_glyph_name(name):
    r""" Wrapper for `fz_unicode_from_glyph_name()`."""
    return _mupdf.unicode_from_glyph_name(name)

def unicode_from_glyph_name_strict(name):
    r""" Wrapper for `fz_unicode_from_glyph_name_strict()`."""
    return _mupdf.unicode_from_glyph_name_strict(name)

def union_rect(a, b):
    r"""
    Wrapper for `fz_union_rect()`.
    Compute union of two rectangles.

    Given two rectangles, update the first to be the smallest
    axis-aligned rectangle that encompasses both given rectangles.
    If either rectangle is infinite then the union is also infinite.
    If either rectangle is empty then the union is simply the
    non-empty rectangle. Should both rectangles be empty, then the
    union is also empty.
    """
    return _mupdf.union_rect(a, b)

def unlock(lock):
    r"""
    Wrapper for `fz_unlock()`.
    Unlock one of the user supplied mutexes.
    """
    return _mupdf.unlock(lock)

def unpack_stream(src, depth, w, h, n, indexed, pad, skip):
    r""" Wrapper for `fz_unpack_stream()`."""
    return _mupdf.unpack_stream(src, depth, w, h, n, indexed, pad, skip)

def unread_byte(stm):
    r"""
    Wrapper for `fz_unread_byte()`.
    Unread the single last byte successfully
    read from a stream. Do not call this without having
    successfully read a byte.

    stm: The stream to operate upon.
    """
    return _mupdf.unread_byte(stm)

def unshare_stroke_state(shared):
    r"""
    Wrapper for `fz_unshare_stroke_state()`.
    Given a reference to a (possibly) shared stroke_state structure,
    return a reference to an equivalent stroke_state structure
    that is guaranteed to be unshared (i.e. one that can
    safely be modified).

    shared: The reference to a (possibly) shared structure
    to unshare. Ownership of this reference is passed in
    to this function, even in the case of exceptions being
    thrown.

    Exceptions may be thrown in the event of failure to
    allocate if required.
    """
    return _mupdf.unshare_stroke_state(shared)

def unshare_stroke_state_with_dash_len(shared, len):
    r"""
    Wrapper for `fz_unshare_stroke_state_with_dash_len()`.
    Given a reference to a (possibly) shared stroke_state structure,
    return a reference to a stroke_state structure (with room for a
    given amount of dash data) that is guaranteed to be unshared
    (i.e. one that can safely be modified).

    shared: The reference to a (possibly) shared structure
    to unshare. Ownership of this reference is passed in
    to this function, even in the case of exceptions being
    thrown.

    Exceptions may be thrown in the event of failure to
    allocate if required.
    """
    return _mupdf.unshare_stroke_state_with_dash_len(shared, len)

def urldecode(url):
    r"""
    Wrapper for `fz_urldecode()`.
    decode url escapes.
    """
    return _mupdf.urldecode(url)

def use_document_css():
    r"""
    Wrapper for `fz_use_document_css()`.
    Return whether to respect document styles in HTML and EPUB.
    """
    return _mupdf.use_document_css()

def user_context():
    r"""
    Wrapper for `fz_user_context()`.
    Read the user field from the context.
    """
    return _mupdf.user_context()

def user_css():
    r"""
    Wrapper for `fz_user_css()`.
    Get the user stylesheet source text.
    """
    return _mupdf.user_css()

def utflen(s):
    r"""
    Wrapper for `fz_utflen()`.
    Count how many runes the UTF-8 encoded string
    consists of.

    s: The UTF-8 encoded, NUL-terminated text string.

    Returns the number of runes in the string.
    """
    return _mupdf.utflen(s)

def var_imp(arg_0):
    r""" Wrapper for `fz_var_imp()`."""
    return _mupdf.var_imp(arg_0)

def walk_path(path, walker, arg):
    r"""
    Wrapper for `fz_walk_path()`.
    Walk the segments of a path, calling the
    appropriate callback function from a given set for each
    segment of the path.

    path: The path to walk.

    walker: The set of callback functions to use. The first
    4 callback pointers in the set must be non-NULL. The
    subsequent ones can either be supplied, or can be left
    as NULL, in which case the top 4 functions will be
    called as appropriate to simulate them.

    arg: An opaque argument passed in to each callback.

    Exceptions will only be thrown if the underlying callback
    functions throw them.
    """
    return _mupdf.walk_path(path, walker, arg)

def warning_callback(OUTPUT):
    r"""
     Wrapper for `fz_warning_callback()`.

    This function has out-params. Python/C# wrappers look like:
    	`warning_callback()` => `(fz_warning_cb *, void *user)`

    	Retrieve the currently set warning callback, or NULL if none
    	has been set. Optionally, if user is non-NULL, the user pointer
    	given when the warning callback was set is also passed back to
    	the caller.
    """
    return _mupdf.warning_callback(OUTPUT)

def warp_pixmap(src, points, width, height):
    r""" Wrapper for `fz_warp_pixmap()`."""
    return _mupdf.warp_pixmap(src, points, width, height)

def windows_1250_from_unicode(u):
    r""" Wrapper for `fz_windows_1250_from_unicode()`."""
    return _mupdf.windows_1250_from_unicode(u)

def windows_1251_from_unicode(u):
    r""" Wrapper for `fz_windows_1251_from_unicode()`."""
    return _mupdf.windows_1251_from_unicode(u)

def windows_1252_from_unicode(u):
    r""" Wrapper for `fz_windows_1252_from_unicode()`."""
    return _mupdf.windows_1252_from_unicode(u)

def write_band(writer, stride, band_height, samples):
    r"""
    Wrapper for `fz_write_band()`.
    Cause a band writer to write the next band
    of data for an image.

    stride: The byte offset from the first byte of the data
    for a pixel to the first byte of the data for the same pixel
    on the row below.

    band_height: The number of lines in this band.

    samples: Pointer to first byte of the data.
    """
    return _mupdf.write_band(writer, stride, band_height, samples)

def write_base64(out, data, size, newline):
    r"""
    Wrapper for `fz_write_base64()`.
    Write a base64 encoded data block, optionally with periodic
    newlines.
    """
    return _mupdf.write_base64(out, data, size, newline)

def write_base64_buffer(out, data, newline):
    r"""
    Wrapper for `fz_write_base64_buffer()`.
    Write a base64 encoded fz_buffer, optionally with periodic
    newlines.
    """
    return _mupdf.write_base64_buffer(out, data, newline)

def write_bitmap_as_pbm(out, bitmap):
    r"""
    Wrapper for `fz_write_bitmap_as_pbm()`.
    Write a bitmap as a pbm.
    """
    return _mupdf.write_bitmap_as_pbm(out, bitmap)

def write_bitmap_as_pcl(out, bitmap, pcl):
    r"""
    Wrapper for `fz_write_bitmap_as_pcl()`.
    Write a bitmap as mono PCL.
    """
    return _mupdf.write_bitmap_as_pcl(out, bitmap, pcl)

def write_bitmap_as_pkm(out, bitmap):
    r"""
    Wrapper for `fz_write_bitmap_as_pkm()`.
    Write a CMYK bitmap as a pkm.
    """
    return _mupdf.write_bitmap_as_pkm(out, bitmap)

def write_bitmap_as_pwg(out, bitmap, pwg):
    r"""
    Wrapper for `fz_write_bitmap_as_pwg()`.
    Write a bitmap as a PWG.
    """
    return _mupdf.write_bitmap_as_pwg(out, bitmap, pwg)

def write_bitmap_as_pwg_page(out, bitmap, pwg):
    r"""
    Wrapper for `fz_write_bitmap_as_pwg_page()`.
    Write a bitmap as a PWG page.

    Caller should provide a file header by calling
    fz_write_pwg_file_header, but can then write several pages to
    the same file.
    """
    return _mupdf.write_bitmap_as_pwg_page(out, bitmap, pwg)

def write_byte(out, x):
    r""" Wrapper for `fz_write_byte()`."""
    return _mupdf.write_byte(out, x)

def write_char(out, x):
    r""" Wrapper for `fz_write_char()`."""
    return _mupdf.write_char(out, x)

def write_data(out, data, size):
    r"""
    Wrapper for `fz_write_data()`.
    Write data to output.

    data: Pointer to data to write.
    size: Size of data to write in bytes.
    """
    return _mupdf.write_data(out, data, size)

def write_document(wri, doc):
    r"""
    Wrapper for `fz_write_document()`.
    Convenience function to feed all the pages of a document to
    fz_begin_page/fz_run_page/fz_end_page.
    """
    return _mupdf.write_document(wri, doc)

def write_float_be(out, f):
    r""" Wrapper for `fz_write_float_be()`."""
    return _mupdf.write_float_be(out, f)

def write_float_le(out, f):
    r""" Wrapper for `fz_write_float_le()`."""
    return _mupdf.write_float_le(out, f)

def write_header(writer, w, h, n, alpha, xres, yres, pagenum, cs, seps):
    r"""
    Wrapper for `fz_write_header()`.
    Cause a band writer to write the header for
    a banded image with the given properties/dimensions etc. This
    also configures the bandwriter for the format of the data to be
    passed in future calls.

    w, h: Width and Height of the entire page.

    n: Number of components (including spots and alphas).

    alpha: Number of alpha components.

    xres, yres: X and Y resolutions in dpi.

    cs: Colorspace (NULL for bitmaps)

    seps: Separation details (or NULL).
    """
    return _mupdf.write_header(writer, w, h, n, alpha, xres, yres, pagenum, cs, seps)

def write_image_as_data_uri(out, image):
    r"""
    Wrapper for `fz_write_image_as_data_uri()`.
    Write image as a data URI (for HTML and SVG output).
    """
    return _mupdf.write_image_as_data_uri(out, image)

def write_int16_be(out, x):
    r""" Wrapper for `fz_write_int16_be()`."""
    return _mupdf.write_int16_be(out, x)

def write_int16_le(out, x):
    r""" Wrapper for `fz_write_int16_le()`."""
    return _mupdf.write_int16_le(out, x)

def write_int32_be(out, x):
    r"""
    Wrapper for `fz_write_int32_be()`.
    Write different sized data to an output stream.
    """
    return _mupdf.write_int32_be(out, x)

def write_int32_le(out, x):
    r""" Wrapper for `fz_write_int32_le()`."""
    return _mupdf.write_int32_le(out, x)

def write_pixmap_as_data_uri(out, pixmap):
    r""" Wrapper for `fz_write_pixmap_as_data_uri()`."""
    return _mupdf.write_pixmap_as_data_uri(out, pixmap)

def write_pixmap_as_pam(out, pixmap):
    r"""
    Wrapper for `fz_write_pixmap_as_pam()`.
    Write a pixmap as a pnm (greyscale, rgb or cmyk, with or without
    alpha).
    """
    return _mupdf.write_pixmap_as_pam(out, pixmap)

def write_pixmap_as_pcl(out, pixmap, pcl):
    r"""
    Wrapper for `fz_write_pixmap_as_pcl()`.
    Write an (RGB) pixmap as color PCL.
    """
    return _mupdf.write_pixmap_as_pcl(out, pixmap, pcl)

def write_pixmap_as_pclm(out, pixmap, options):
    r"""
    Wrapper for `fz_write_pixmap_as_pclm()`.
    Write a (Greyscale or RGB) pixmap as pclm.
    """
    return _mupdf.write_pixmap_as_pclm(out, pixmap, options)

def write_pixmap_as_pdfocr(out, pixmap, options):
    r"""
    Wrapper for `fz_write_pixmap_as_pdfocr()`.
    Write a (Greyscale or RGB) pixmap as pdfocr.
    """
    return _mupdf.write_pixmap_as_pdfocr(out, pixmap, options)

def write_pixmap_as_png(out, pixmap):
    r"""
    Wrapper for `fz_write_pixmap_as_png()`.
    Write a (Greyscale or RGB) pixmap as a png.
    """
    return _mupdf.write_pixmap_as_png(out, pixmap)

def write_pixmap_as_pnm(out, pixmap):
    r"""
    Wrapper for `fz_write_pixmap_as_pnm()`.
    Write a pixmap as a pnm (greyscale or rgb, no alpha).
    """
    return _mupdf.write_pixmap_as_pnm(out, pixmap)

def write_pixmap_as_ps(out, pixmap):
    r"""
    Wrapper for `fz_write_pixmap_as_ps()`.
    Write a (gray, rgb, or cmyk, no alpha) pixmap out as postscript.
    """
    return _mupdf.write_pixmap_as_ps(out, pixmap)

def write_pixmap_as_psd(out, pixmap):
    r"""
    Wrapper for `fz_write_pixmap_as_psd()`.
    Write a pixmap as a PSD file.
    """
    return _mupdf.write_pixmap_as_psd(out, pixmap)

def write_pixmap_as_pwg(out, pixmap, pwg):
    r"""
    Wrapper for `fz_write_pixmap_as_pwg()`.
    Write a pixmap as a PWG.
    """
    return _mupdf.write_pixmap_as_pwg(out, pixmap, pwg)

def write_pixmap_as_pwg_page(out, pixmap, pwg):
    r"""
    Wrapper for `fz_write_pixmap_as_pwg_page()`.
    Write a pixmap as a PWG page.

    Caller should provide a file header by calling
    fz_write_pwg_file_header, but can then write several pages to
    the same file.
    """
    return _mupdf.write_pixmap_as_pwg_page(out, pixmap, pwg)

def write_ps_file_header(out):
    r"""
    Wrapper for `fz_write_ps_file_header()`.
    Write the file level header for ps band writer output.
    """
    return _mupdf.write_ps_file_header(out)

def write_ps_file_trailer(out, pages):
    r"""
    Wrapper for `fz_write_ps_file_trailer()`.
    Write the file level trailer for ps band writer output.
    """
    return _mupdf.write_ps_file_trailer(out, pages)

def write_pwg_file_header(out):
    r"""
    Wrapper for `fz_write_pwg_file_header()`.
    Output the file header to a pwg stream, ready for pages to follow it.
    """
    return _mupdf.write_pwg_file_header(out)

def write_rune(out, rune):
    r"""
    Wrapper for `fz_write_rune()`.
    Write a UTF-8 encoded unicode character.
    """
    return _mupdf.write_rune(out, rune)

def write_string(out, s):
    r"""
    Wrapper for `fz_write_string()`.
    Write a string. Does not write zero terminator.
    """
    return _mupdf.write_string(out, s)

def write_uint16_be(out, x):
    r""" Wrapper for `fz_write_uint16_be()`."""
    return _mupdf.write_uint16_be(out, x)

def write_uint16_le(out, x):
    r""" Wrapper for `fz_write_uint16_le()`."""
    return _mupdf.write_uint16_le(out, x)

def write_uint32_be(out, x):
    r""" Wrapper for `fz_write_uint32_be()`."""
    return _mupdf.write_uint32_be(out, x)

def write_uint32_le(out, x):
    r""" Wrapper for `fz_write_uint32_le()`."""
    return _mupdf.write_uint32_le(out, x)

def write_zip_entry(zip, name, buf, compress):
    r"""
    Wrapper for `fz_write_zip_entry()`.
    Given a buffer of data, (optionally) compress it, and add it to
    the zip file with the given name.
    """
    return _mupdf.write_zip_entry(zip, name, buf, compress)

def xml_att(item, att):
    r"""
    Wrapper for `fz_xml_att()`.
    Return the value of an attribute of an XML node.
    NULL if the attribute doesn't exist.
    """
    return _mupdf.xml_att(item, att)

def xml_att_alt(item, one, two):
    r"""
    Wrapper for `fz_xml_att_alt()`.
    Return the value of an attribute of an XML node.
    If the first attribute doesn't exist, try the second.
    NULL if neither attribute exists.
    """
    return _mupdf.xml_att_alt(item, one, two)

def xml_att_eq(item, name, match):
    r"""
    Wrapper for `fz_xml_att_eq()`.
    Check for a matching attribute on an XML node.

    If the node has the requested attribute (name), and the value
    matches (match) then return 1. Otherwise, 0.
    """
    return _mupdf.xml_att_eq(item, name, match)

def xml_down(item):
    r"""
    Wrapper for `fz_xml_down()`.
    Return first child of XML node.
    """
    return _mupdf.xml_down(item)

def xml_find(item, tag):
    r"""
    Wrapper for `fz_xml_find()`.
    Search the siblings of XML nodes starting with item looking for
    the first with the given tag.

    Return NULL if none found.
    """
    return _mupdf.xml_find(item, tag)

def xml_find_down(item, tag):
    r"""
    Wrapper for `fz_xml_find_down()`.
    Search the siblings of XML nodes starting with the first child
    of item looking for the first with the given tag.

    Return NULL if none found.
    """
    return _mupdf.xml_find_down(item, tag)

def xml_find_down_match(item, tag, att, match):
    r"""
    Wrapper for `fz_xml_find_down_match()`.
    Search the siblings of XML nodes starting with the first child
    of item looking for the first with the given tag, and with a
    matching attribute.

    Return NULL if none found.
    """
    return _mupdf.xml_find_down_match(item, tag, att, match)

def xml_find_match(item, tag, att, match):
    r"""
    Wrapper for `fz_xml_find_match()`.
    Search the siblings of XML nodes starting with item looking for
    the first with the given tag, and with a matching attribute.

    Return NULL if none found.
    """
    return _mupdf.xml_find_match(item, tag, att, match)

def xml_find_next(item, tag):
    r"""
    Wrapper for `fz_xml_find_next()`.
    Search the siblings of XML nodes starting with the first sibling
    of item looking for the first with the given tag.

    Return NULL if none found.
    """
    return _mupdf.xml_find_next(item, tag)

def xml_find_next_match(item, tag, att, match):
    r"""
    Wrapper for `fz_xml_find_next_match()`.
    Search the siblings of XML nodes starting with the first sibling
    of item looking for the first with the given tag, and with a
    matching attribute.

    Return NULL if none found.
    """
    return _mupdf.xml_find_next_match(item, tag, att, match)

def xml_is_tag(item, name):
    r"""
    Wrapper for `fz_xml_is_tag()`.
    Return true if the tag name matches.
    """
    return _mupdf.xml_is_tag(item, name)

def xml_next(item):
    r"""
    Wrapper for `fz_xml_next()`.
    Return next sibling of XML node.
    """
    return _mupdf.xml_next(item)

def xml_prev(item):
    r"""
    Wrapper for `fz_xml_prev()`.
    Return previous sibling of XML node.
    """
    return _mupdf.xml_prev(item)

def xml_root(xml):
    r"""
    Wrapper for `fz_xml_root()`.
    Return the topmost XML node of a document.
    """
    return _mupdf.xml_root(xml)

def xml_tag(item):
    r"""
    Wrapper for `fz_xml_tag()`.
    Return tag of XML node. Return NULL for text nodes.
    """
    return _mupdf.xml_tag(item)

def xml_text(item):
    r"""
    Wrapper for `fz_xml_text()`.
    Return the text content of an XML node.
    Return NULL if the node is a tag.
    """
    return _mupdf.xml_text(item)

def xml_up(item):
    r"""
    Wrapper for `fz_xml_up()`.
    Return parent of XML node.
    """
    return _mupdf.xml_up(item)

def ppdf_access_alert_event(evt):
    r""" Wrapper for `pdf_access_alert_event()`."""
    return _mupdf.ppdf_access_alert_event(evt)

def ppdf_access_exec_menu_item_event(evt):
    r""" Wrapper for `pdf_access_exec_menu_item_event()`."""
    return _mupdf.ppdf_access_exec_menu_item_event(evt)

def ppdf_access_launch_url_event(evt):
    r""" Wrapper for `pdf_access_launch_url_event()`."""
    return _mupdf.ppdf_access_launch_url_event(evt)

def ppdf_access_mail_doc_event(evt):
    r""" Wrapper for `pdf_access_mail_doc_event()`."""
    return _mupdf.ppdf_access_mail_doc_event(evt)

def ppdf_add_annot_ink_list(annot, n, stroke):
    r""" Wrapper for `pdf_add_annot_ink_list()`."""
    return _mupdf.ppdf_add_annot_ink_list(annot, n, stroke)

def ppdf_add_annot_ink_list_stroke(annot):
    r""" Wrapper for `pdf_add_annot_ink_list_stroke()`."""
    return _mupdf.ppdf_add_annot_ink_list_stroke(annot)

def ppdf_add_annot_ink_list_stroke_vertex(annot, p):
    r""" Wrapper for `pdf_add_annot_ink_list_stroke_vertex()`."""
    return _mupdf.ppdf_add_annot_ink_list_stroke_vertex(annot, p)

def ppdf_add_annot_quad_point(annot, quad):
    r""" Wrapper for `pdf_add_annot_quad_point()`."""
    return _mupdf.ppdf_add_annot_quad_point(annot, quad)

def ppdf_add_annot_vertex(annot, p):
    r""" Wrapper for `pdf_add_annot_vertex()`."""
    return _mupdf.ppdf_add_annot_vertex(annot, p)

def ppdf_add_cid_font(doc, font):
    r""" Wrapper for `pdf_add_cid_font()`."""
    return _mupdf.ppdf_add_cid_font(doc, font)

def ppdf_add_cjk_font(doc, font, script, wmode, serif):
    r""" Wrapper for `pdf_add_cjk_font()`."""
    return _mupdf.ppdf_add_cjk_font(doc, font, script, wmode, serif)

def ppdf_add_codespace(cmap, low, high, n):
    r""" Wrapper for `pdf_add_codespace()`."""
    return _mupdf.ppdf_add_codespace(cmap, low, high, n)

def ppdf_add_embedded_file(doc, filename, mimetype, contents):
    r""" Wrapper for `pdf_add_embedded_file()`."""
    return _mupdf.ppdf_add_embedded_file(doc, filename, mimetype, contents)

def ppdf_add_hmtx(font, lo, hi, w):
    r""" Wrapper for `pdf_add_hmtx()`."""
    return _mupdf.ppdf_add_hmtx(font, lo, hi, w)

def ppdf_add_image(doc, image):
    r""" Wrapper for `pdf_add_image()`."""
    return _mupdf.ppdf_add_image(doc, image)

def ppdf_add_journal_fragment(doc, parent, copy, copy_stream, newobj):
    r""" Wrapper for `pdf_add_journal_fragment()`."""
    return _mupdf.ppdf_add_journal_fragment(doc, parent, copy, copy_stream, newobj)

def ppdf_add_new_array(doc, initial):
    r""" Wrapper for `pdf_add_new_array()`."""
    return _mupdf.ppdf_add_new_array(doc, initial)

def ppdf_add_new_dict(doc, initial):
    r""" Wrapper for `pdf_add_new_dict()`."""
    return _mupdf.ppdf_add_new_dict(doc, initial)

def ppdf_add_object(doc, obj):
    r""" Wrapper for `pdf_add_object()`."""
    return _mupdf.ppdf_add_object(doc, obj)

def ppdf_add_object_drop(doc, obj):
    r""" Wrapper for `pdf_add_object_drop()`."""
    return _mupdf.ppdf_add_object_drop(doc, obj)

def ppdf_add_page(doc, mediabox, rotate, resources, contents):
    r""" Wrapper for `pdf_add_page()`."""
    return _mupdf.ppdf_add_page(doc, mediabox, rotate, resources, contents)

def ppdf_add_simple_font(doc, font, encoding):
    r""" Wrapper for `pdf_add_simple_font()`."""
    return _mupdf.ppdf_add_simple_font(doc, font, encoding)

def ppdf_add_stream(doc, buf, obj, compressed):
    r""" Wrapper for `pdf_add_stream()`."""
    return _mupdf.ppdf_add_stream(doc, buf, obj, compressed)

def ppdf_add_substitute_font(doc, font):
    r""" Wrapper for `pdf_add_substitute_font()`."""
    return _mupdf.ppdf_add_substitute_font(doc, font)

def ppdf_add_vmtx(font, lo, hi, x, y, w):
    r""" Wrapper for `pdf_add_vmtx()`."""
    return _mupdf.ppdf_add_vmtx(font, lo, hi, x, y, w)

def ppdf_annot_MK_BC(annot, color):
    r"""
     Wrapper for `pdf_annot_MK_BC()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_annot_MK_BC(pdf_annot *annot, float color[4])` => int n
    """
    return _mupdf.ppdf_annot_MK_BC(annot, color)

def ppdf_annot_MK_BC_rgb(annot, rgb):
    r""" Wrapper for `pdf_annot_MK_BC_rgb()`."""
    return _mupdf.ppdf_annot_MK_BC_rgb(annot, rgb)

def ppdf_annot_MK_BG(annot, color):
    r"""
     Wrapper for `pdf_annot_MK_BG()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_annot_MK_BG(pdf_annot *annot, float color[4])` => int n
    """
    return _mupdf.ppdf_annot_MK_BG(annot, color)

def ppdf_annot_MK_BG_rgb(annot, rgb):
    r""" Wrapper for `pdf_annot_MK_BG_rgb()`."""
    return _mupdf.ppdf_annot_MK_BG_rgb(annot, rgb)

def ppdf_annot_active(annot):
    r""" Wrapper for `pdf_annot_active()`."""
    return _mupdf.ppdf_annot_active(annot)

def ppdf_annot_ap(annot):
    r""" Wrapper for `pdf_annot_ap()`."""
    return _mupdf.ppdf_annot_ap(annot)

def ppdf_annot_author(annot):
    r""" Wrapper for `pdf_annot_author()`."""
    return _mupdf.ppdf_annot_author(annot)

def ppdf_annot_border(annot):
    r""" Wrapper for `pdf_annot_border()`."""
    return _mupdf.ppdf_annot_border(annot)

def ppdf_annot_color(annot, color):
    r"""
     Wrapper for `pdf_annot_color()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_annot_color(pdf_annot *annot, float color[4])` => int n
    """
    return _mupdf.ppdf_annot_color(annot, color)

def ppdf_annot_contents(annot):
    r""" Wrapper for `pdf_annot_contents()`."""
    return _mupdf.ppdf_annot_contents(annot)

def ppdf_annot_creation_date(annot):
    r""" Wrapper for `pdf_annot_creation_date()`."""
    return _mupdf.ppdf_annot_creation_date(annot)

def ppdf_annot_default_appearance(annot, color):
    r"""
     Wrapper for `pdf_annot_default_appearance()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_annot_default_appearance(pdf_annot *annot, float color[4])` => `(const char *font, float size, int n)`
    """
    return _mupdf.ppdf_annot_default_appearance(annot, color)

def ppdf_annot_ensure_local_xref(annot):
    r""" Wrapper for `pdf_annot_ensure_local_xref()`."""
    return _mupdf.ppdf_annot_ensure_local_xref(annot)

def ppdf_annot_event_blur(annot):
    r""" Wrapper for `pdf_annot_event_blur()`."""
    return _mupdf.ppdf_annot_event_blur(annot)

def ppdf_annot_event_down(annot):
    r""" Wrapper for `pdf_annot_event_down()`."""
    return _mupdf.ppdf_annot_event_down(annot)

def ppdf_annot_event_enter(annot):
    r""" Wrapper for `pdf_annot_event_enter()`."""
    return _mupdf.ppdf_annot_event_enter(annot)

def ppdf_annot_event_exit(annot):
    r""" Wrapper for `pdf_annot_event_exit()`."""
    return _mupdf.ppdf_annot_event_exit(annot)

def ppdf_annot_event_focus(annot):
    r""" Wrapper for `pdf_annot_event_focus()`."""
    return _mupdf.ppdf_annot_event_focus(annot)

def ppdf_annot_event_page_close(annot):
    r""" Wrapper for `pdf_annot_event_page_close()`."""
    return _mupdf.ppdf_annot_event_page_close(annot)

def ppdf_annot_event_page_invisible(annot):
    r""" Wrapper for `pdf_annot_event_page_invisible()`."""
    return _mupdf.ppdf_annot_event_page_invisible(annot)

def ppdf_annot_event_page_open(annot):
    r""" Wrapper for `pdf_annot_event_page_open()`."""
    return _mupdf.ppdf_annot_event_page_open(annot)

def ppdf_annot_event_page_visible(annot):
    r""" Wrapper for `pdf_annot_event_page_visible()`."""
    return _mupdf.ppdf_annot_event_page_visible(annot)

def ppdf_annot_event_up(annot):
    r""" Wrapper for `pdf_annot_event_up()`."""
    return _mupdf.ppdf_annot_event_up(annot)

def ppdf_annot_field_event_keystroke(doc, annot, evt):
    r""" Wrapper for `pdf_annot_field_event_keystroke()`."""
    return _mupdf.ppdf_annot_field_event_keystroke(doc, annot, evt)

def ppdf_annot_field_flags(annot):
    r""" Wrapper for `pdf_annot_field_flags()`."""
    return _mupdf.ppdf_annot_field_flags(annot)

def ppdf_annot_field_label(widget):
    r""" Wrapper for `pdf_annot_field_label()`."""
    return _mupdf.ppdf_annot_field_label(widget)

def ppdf_annot_field_value(annot):
    r""" Wrapper for `pdf_annot_field_value()`."""
    return _mupdf.ppdf_annot_field_value(annot)

def ppdf_annot_flags(annot):
    r""" Wrapper for `pdf_annot_flags()`."""
    return _mupdf.ppdf_annot_flags(annot)

def ppdf_annot_has_author(annot):
    r""" Wrapper for `pdf_annot_has_author()`."""
    return _mupdf.ppdf_annot_has_author(annot)

def ppdf_annot_has_icon_name(annot):
    r""" Wrapper for `pdf_annot_has_icon_name()`."""
    return _mupdf.ppdf_annot_has_icon_name(annot)

def ppdf_annot_has_ink_list(annot):
    r""" Wrapper for `pdf_annot_has_ink_list()`."""
    return _mupdf.ppdf_annot_has_ink_list(annot)

def ppdf_annot_has_interior_color(annot):
    r""" Wrapper for `pdf_annot_has_interior_color()`."""
    return _mupdf.ppdf_annot_has_interior_color(annot)

def ppdf_annot_has_line(annot):
    r""" Wrapper for `pdf_annot_has_line()`."""
    return _mupdf.ppdf_annot_has_line(annot)

def ppdf_annot_has_line_ending_styles(annot):
    r""" Wrapper for `pdf_annot_has_line_ending_styles()`."""
    return _mupdf.ppdf_annot_has_line_ending_styles(annot)

def ppdf_annot_has_open(annot):
    r""" Wrapper for `pdf_annot_has_open()`."""
    return _mupdf.ppdf_annot_has_open(annot)

def ppdf_annot_has_quad_points(annot):
    r""" Wrapper for `pdf_annot_has_quad_points()`."""
    return _mupdf.ppdf_annot_has_quad_points(annot)

def ppdf_annot_has_vertices(annot):
    r""" Wrapper for `pdf_annot_has_vertices()`."""
    return _mupdf.ppdf_annot_has_vertices(annot)

def ppdf_annot_hot(annot):
    r""" Wrapper for `pdf_annot_hot()`."""
    return _mupdf.ppdf_annot_hot(annot)

def ppdf_annot_icon_name(annot):
    r""" Wrapper for `pdf_annot_icon_name()`."""
    return _mupdf.ppdf_annot_icon_name(annot)

def ppdf_annot_ink_list_count(annot):
    r""" Wrapper for `pdf_annot_ink_list_count()`."""
    return _mupdf.ppdf_annot_ink_list_count(annot)

def ppdf_annot_ink_list_stroke_count(annot, i):
    r""" Wrapper for `pdf_annot_ink_list_stroke_count()`."""
    return _mupdf.ppdf_annot_ink_list_stroke_count(annot, i)

def ppdf_annot_ink_list_stroke_vertex(annot, i, k):
    r""" Wrapper for `pdf_annot_ink_list_stroke_vertex()`."""
    return _mupdf.ppdf_annot_ink_list_stroke_vertex(annot, i, k)

def ppdf_annot_interior_color(annot, color):
    r"""
     Wrapper for `pdf_annot_interior_color()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_annot_interior_color(pdf_annot *annot, float color[4])` => int n
    """
    return _mupdf.ppdf_annot_interior_color(annot, color)

def ppdf_annot_is_open(annot):
    r""" Wrapper for `pdf_annot_is_open()`."""
    return _mupdf.ppdf_annot_is_open(annot)

def ppdf_annot_language(annot):
    r""" Wrapper for `pdf_annot_language()`."""
    return _mupdf.ppdf_annot_language(annot)

def ppdf_annot_line(annot, a, b):
    r""" Wrapper for `pdf_annot_line()`."""
    return _mupdf.ppdf_annot_line(annot, a, b)

def ppdf_annot_line_end_style(annot):
    r""" Wrapper for `pdf_annot_line_end_style()`."""
    return _mupdf.ppdf_annot_line_end_style(annot)

def ppdf_annot_line_ending_styles(annot, arg2, arg3):
    r"""
     Wrapper for `pdf_annot_line_ending_styles()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_annot_line_ending_styles(pdf_annot *annot)` => `(enum pdf_line_ending start_style, enum pdf_line_ending end_style)`
    """
    return _mupdf.ppdf_annot_line_ending_styles(annot, arg2, arg3)

def ppdf_annot_line_start_style(annot):
    r""" Wrapper for `pdf_annot_line_start_style()`."""
    return _mupdf.ppdf_annot_line_start_style(annot)

def ppdf_annot_modification_date(annot):
    r""" Wrapper for `pdf_annot_modification_date()`."""
    return _mupdf.ppdf_annot_modification_date(annot)

def ppdf_annot_needs_resynthesis(annot):
    r""" Wrapper for `pdf_annot_needs_resynthesis()`."""
    return _mupdf.ppdf_annot_needs_resynthesis(annot)

def ppdf_annot_obj(annot):
    r""" Wrapper for `pdf_annot_obj()`."""
    return _mupdf.ppdf_annot_obj(annot)

def ppdf_annot_opacity(annot):
    r""" Wrapper for `pdf_annot_opacity()`."""
    return _mupdf.ppdf_annot_opacity(annot)

def ppdf_annot_page(annot):
    r""" Wrapper for `pdf_annot_page()`."""
    return _mupdf.ppdf_annot_page(annot)

def ppdf_annot_pop_and_discard_local_xref(annot):
    r""" Wrapper for `pdf_annot_pop_and_discard_local_xref()`."""
    return _mupdf.ppdf_annot_pop_and_discard_local_xref(annot)

def ppdf_annot_pop_local_xref(annot):
    r""" Wrapper for `pdf_annot_pop_local_xref()`."""
    return _mupdf.ppdf_annot_pop_local_xref(annot)

def ppdf_annot_popup(annot):
    r""" Wrapper for `pdf_annot_popup()`."""
    return _mupdf.ppdf_annot_popup(annot)

def ppdf_annot_push_local_xref(annot):
    r""" Wrapper for `pdf_annot_push_local_xref()`."""
    return _mupdf.ppdf_annot_push_local_xref(annot)

def ppdf_annot_quad_point(annot, i):
    r""" Wrapper for `pdf_annot_quad_point()`."""
    return _mupdf.ppdf_annot_quad_point(annot, i)

def ppdf_annot_quad_point_count(annot):
    r""" Wrapper for `pdf_annot_quad_point_count()`."""
    return _mupdf.ppdf_annot_quad_point_count(annot)

def ppdf_annot_quadding(annot):
    r""" Wrapper for `pdf_annot_quadding()`."""
    return _mupdf.ppdf_annot_quadding(annot)

def ppdf_annot_rect(annot):
    r""" Wrapper for `pdf_annot_rect()`."""
    return _mupdf.ppdf_annot_rect(annot)

def ppdf_annot_request_resynthesis(annot):
    r""" Wrapper for `pdf_annot_request_resynthesis()`."""
    return _mupdf.ppdf_annot_request_resynthesis(annot)

def ppdf_annot_transform(annot):
    r""" Wrapper for `pdf_annot_transform()`."""
    return _mupdf.ppdf_annot_transform(annot)

def ppdf_annot_type(annot):
    r""" Wrapper for `pdf_annot_type()`."""
    return _mupdf.ppdf_annot_type(annot)

def ppdf_annot_type_from_string(subtype):
    r""" Wrapper for `pdf_annot_type_from_string()`."""
    return _mupdf.ppdf_annot_type_from_string(subtype)

def ppdf_annot_vertex(annot, i):
    r""" Wrapper for `pdf_annot_vertex()`."""
    return _mupdf.ppdf_annot_vertex(annot, i)

def ppdf_annot_vertex_count(annot):
    r""" Wrapper for `pdf_annot_vertex_count()`."""
    return _mupdf.ppdf_annot_vertex_count(annot)

def ppdf_append_token(buf, tok, lex):
    r""" Wrapper for `pdf_append_token()`."""
    return _mupdf.ppdf_append_token(buf, tok, lex)

def ppdf_array_contains(array, obj):
    r""" Wrapper for `pdf_array_contains()`."""
    return _mupdf.ppdf_array_contains(array, obj)

def ppdf_array_delete(array, index):
    r""" Wrapper for `pdf_array_delete()`."""
    return _mupdf.ppdf_array_delete(array, index)

def ppdf_array_find(array, obj):
    r""" Wrapper for `pdf_array_find()`."""
    return _mupdf.ppdf_array_find(array, obj)

def ppdf_array_get(array, i):
    r""" Wrapper for `pdf_array_get()`."""
    return _mupdf.ppdf_array_get(array, i)

def ppdf_array_get_bool(array, index):
    r""" Wrapper for `pdf_array_get_bool()`."""
    return _mupdf.ppdf_array_get_bool(array, index)

def ppdf_array_get_int(array, index):
    r""" Wrapper for `pdf_array_get_int()`."""
    return _mupdf.ppdf_array_get_int(array, index)

def ppdf_array_get_matrix(array, index):
    r""" Wrapper for `pdf_array_get_matrix()`."""
    return _mupdf.ppdf_array_get_matrix(array, index)

def ppdf_array_get_name(array, index):
    r""" Wrapper for `pdf_array_get_name()`."""
    return _mupdf.ppdf_array_get_name(array, index)

def ppdf_array_get_real(array, index):
    r""" Wrapper for `pdf_array_get_real()`."""
    return _mupdf.ppdf_array_get_real(array, index)

def ppdf_array_get_rect(array, index):
    r""" Wrapper for `pdf_array_get_rect()`."""
    return _mupdf.ppdf_array_get_rect(array, index)

def ppdf_array_get_string(array, index):
    r"""
     Wrapper for `pdf_array_get_string()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_array_get_string(pdf_obj *array, int index)` => `(const char *, size_t sizep)`
    """
    return _mupdf.ppdf_array_get_string(array, index)

def ppdf_array_get_text_string(array, index):
    r""" Wrapper for `pdf_array_get_text_string()`."""
    return _mupdf.ppdf_array_get_text_string(array, index)

def ppdf_array_insert(array, obj, index):
    r""" Wrapper for `pdf_array_insert()`."""
    return _mupdf.ppdf_array_insert(array, obj, index)

def ppdf_array_insert_drop(array, obj, index):
    r""" Wrapper for `pdf_array_insert_drop()`."""
    return _mupdf.ppdf_array_insert_drop(array, obj, index)

def ppdf_array_len(array):
    r""" Wrapper for `pdf_array_len()`."""
    return _mupdf.ppdf_array_len(array)

def ppdf_array_push(array, obj):
    r""" Wrapper for `pdf_array_push()`."""
    return _mupdf.ppdf_array_push(array, obj)

def ppdf_array_push_array(array, initial):
    r""" Wrapper for `pdf_array_push_array()`."""
    return _mupdf.ppdf_array_push_array(array, initial)

def ppdf_array_push_bool(array, x):
    r""" Wrapper for `pdf_array_push_bool()`."""
    return _mupdf.ppdf_array_push_bool(array, x)

def ppdf_array_push_dict(array, initial):
    r""" Wrapper for `pdf_array_push_dict()`."""
    return _mupdf.ppdf_array_push_dict(array, initial)

def ppdf_array_push_drop(array, obj):
    r""" Wrapper for `pdf_array_push_drop()`."""
    return _mupdf.ppdf_array_push_drop(array, obj)

def ppdf_array_push_int(array, x):
    r""" Wrapper for `pdf_array_push_int()`."""
    return _mupdf.ppdf_array_push_int(array, x)

def ppdf_array_push_name(array, x):
    r""" Wrapper for `pdf_array_push_name()`."""
    return _mupdf.ppdf_array_push_name(array, x)

def ppdf_array_push_real(array, x):
    r""" Wrapper for `pdf_array_push_real()`."""
    return _mupdf.ppdf_array_push_real(array, x)

def ppdf_array_push_string(array, x, n):
    r""" Wrapper for `pdf_array_push_string()`."""
    return _mupdf.ppdf_array_push_string(array, x, n)

def ppdf_array_push_text_string(array, x):
    r""" Wrapper for `pdf_array_push_text_string()`."""
    return _mupdf.ppdf_array_push_text_string(array, x)

def ppdf_array_put(array, i, obj):
    r""" Wrapper for `pdf_array_put()`."""
    return _mupdf.ppdf_array_put(array, i, obj)

def ppdf_array_put_drop(array, i, obj):
    r""" Wrapper for `pdf_array_put_drop()`."""
    return _mupdf.ppdf_array_put_drop(array, i, obj)

def ppdf_authenticate_password(doc, pw):
    r""" Wrapper for `pdf_authenticate_password()`."""
    return _mupdf.ppdf_authenticate_password(doc, pw)

def ppdf_begin_implicit_operation(doc):
    r""" Wrapper for `pdf_begin_implicit_operation()`."""
    return _mupdf.ppdf_begin_implicit_operation(doc)

def ppdf_begin_operation(doc, operation):
    r""" Wrapper for `pdf_begin_operation()`."""
    return _mupdf.ppdf_begin_operation(doc, operation)

def ppdf_bound_annot(annot):
    r""" Wrapper for `pdf_bound_annot()`."""
    return _mupdf.ppdf_bound_annot(annot)

def ppdf_bound_page(page):
    r""" Wrapper for `pdf_bound_page()`."""
    return _mupdf.ppdf_bound_page(page)

def ppdf_bound_widget(widget):
    r""" Wrapper for `pdf_bound_widget()`."""
    return _mupdf.ppdf_bound_widget(widget)

def ppdf_button_field_on_state(field):
    r""" Wrapper for `pdf_button_field_on_state()`."""
    return _mupdf.ppdf_button_field_on_state(field)

def ppdf_cache_object(doc, num):
    r""" Wrapper for `pdf_cache_object()`."""
    return _mupdf.ppdf_cache_object(doc, num)

def ppdf_calculate_form(doc):
    r""" Wrapper for `pdf_calculate_form()`."""
    return _mupdf.ppdf_calculate_form(doc)

def ppdf_can_be_saved_incrementally(doc):
    r""" Wrapper for `pdf_can_be_saved_incrementally()`."""
    return _mupdf.ppdf_can_be_saved_incrementally(doc)

def ppdf_can_redo(doc):
    r""" Wrapper for `pdf_can_redo()`."""
    return _mupdf.ppdf_can_redo(doc)

def ppdf_can_undo(doc):
    r""" Wrapper for `pdf_can_undo()`."""
    return _mupdf.ppdf_can_undo(doc)

def ppdf_check_certificate(verifier, doc, signature):
    r""" Wrapper for `pdf_check_certificate()`."""
    return _mupdf.ppdf_check_certificate(verifier, doc, signature)

def ppdf_check_digest(verifier, doc, signature):
    r""" Wrapper for `pdf_check_digest()`."""
    return _mupdf.ppdf_check_digest(verifier, doc, signature)

def ppdf_check_signature(verifier, doc, signature, ebuf, ebufsize):
    r""" Wrapper for `pdf_check_signature()`."""
    return _mupdf.ppdf_check_signature(verifier, doc, signature, ebuf, ebufsize)

def ppdf_check_widget_certificate(verifier, widget):
    r""" Wrapper for `pdf_check_widget_certificate()`."""
    return _mupdf.ppdf_check_widget_certificate(verifier, widget)

def ppdf_check_widget_digest(verifier, widget):
    r""" Wrapper for `pdf_check_widget_digest()`."""
    return _mupdf.ppdf_check_widget_digest(verifier, widget)

def ppdf_choice_field_option(field, exportval, i):
    r""" Wrapper for `pdf_choice_field_option()`."""
    return _mupdf.ppdf_choice_field_option(field, exportval, i)

def ppdf_choice_field_option_count(field):
    r""" Wrapper for `pdf_choice_field_option_count()`."""
    return _mupdf.ppdf_choice_field_option_count(field)

def ppdf_choice_widget_is_multiselect(tw):
    r""" Wrapper for `pdf_choice_widget_is_multiselect()`."""
    return _mupdf.ppdf_choice_widget_is_multiselect(tw)

def ppdf_choice_widget_options(tw, exportval, opts):
    r""" Wrapper for `pdf_choice_widget_options()`."""
    return _mupdf.ppdf_choice_widget_options(tw, exportval, opts)

def ppdf_choice_widget_set_value(tw, n, opts):
    r""" Wrapper for `pdf_choice_widget_set_value()`."""
    return _mupdf.ppdf_choice_widget_set_value(tw, n, opts)

def ppdf_choice_widget_value(tw, opts):
    r""" Wrapper for `pdf_choice_widget_value()`."""
    return _mupdf.ppdf_choice_widget_value(tw, opts)

def ppdf_clean_file(infile, outfile, password, opts, retainlen):
    r""" Wrapper for `pdf_clean_file()`."""
    return _mupdf.ppdf_clean_file(infile, outfile, password, opts, retainlen)

def ppdf_clean_font_name(fontname):
    r""" Wrapper for `pdf_clean_font_name()`."""
    return _mupdf.ppdf_clean_font_name(fontname)

def ppdf_clean_obj(obj):
    r""" Wrapper for `pdf_clean_obj()`."""
    return _mupdf.ppdf_clean_obj(obj)

def ppdf_clear_annot_ink_list(annot):
    r""" Wrapper for `pdf_clear_annot_ink_list()`."""
    return _mupdf.ppdf_clear_annot_ink_list(annot)

def ppdf_clear_annot_quad_points(annot):
    r""" Wrapper for `pdf_clear_annot_quad_points()`."""
    return _mupdf.ppdf_clear_annot_quad_points(annot)

def ppdf_clear_annot_vertices(annot):
    r""" Wrapper for `pdf_clear_annot_vertices()`."""
    return _mupdf.ppdf_clear_annot_vertices(annot)

def ppdf_clear_signature(widget):
    r""" Wrapper for `pdf_clear_signature()`."""
    return _mupdf.ppdf_clear_signature(widget)

def ppdf_clear_xref(doc):
    r""" Wrapper for `pdf_clear_xref()`."""
    return _mupdf.ppdf_clear_xref(doc)

def ppdf_clear_xref_to_mark(doc):
    r""" Wrapper for `pdf_clear_xref_to_mark()`."""
    return _mupdf.ppdf_clear_xref_to_mark(doc)

def ppdf_close_processor(proc):
    r""" Wrapper for `pdf_close_processor()`."""
    return _mupdf.ppdf_close_processor(proc)

def ppdf_cmap_size(cmap):
    r""" Wrapper for `pdf_cmap_size()`."""
    return _mupdf.ppdf_cmap_size(cmap)

def ppdf_cmap_wmode(cmap):
    r""" Wrapper for `pdf_cmap_wmode()`."""
    return _mupdf.ppdf_cmap_wmode(cmap)

def ppdf_copy_array(array):
    r""" Wrapper for `pdf_copy_array()`."""
    return _mupdf.ppdf_copy_array(array)

def ppdf_copy_dict(dict):
    r""" Wrapper for `pdf_copy_dict()`."""
    return _mupdf.ppdf_copy_dict(dict)

def ppdf_count_layer_config_ui(doc):
    r""" Wrapper for `pdf_count_layer_config_ui()`."""
    return _mupdf.ppdf_count_layer_config_ui(doc)

def ppdf_count_layer_configs(doc):
    r""" Wrapper for `pdf_count_layer_configs()`."""
    return _mupdf.ppdf_count_layer_configs(doc)

def ppdf_count_objects(doc):
    r""" Wrapper for `pdf_count_objects()`."""
    return _mupdf.ppdf_count_objects(doc)

def ppdf_count_pages(doc):
    r""" Wrapper for `pdf_count_pages()`."""
    return _mupdf.ppdf_count_pages(doc)

def ppdf_count_pages_imp(doc, chapter):
    r""" Wrapper for `pdf_count_pages_imp()`."""
    return _mupdf.ppdf_count_pages_imp(doc, chapter)

def ppdf_count_signatures(doc):
    r""" Wrapper for `pdf_count_signatures()`."""
    return _mupdf.ppdf_count_signatures(doc)

def ppdf_count_unsaved_versions(doc):
    r""" Wrapper for `pdf_count_unsaved_versions()`."""
    return _mupdf.ppdf_count_unsaved_versions(doc)

def ppdf_count_versions(doc):
    r""" Wrapper for `pdf_count_versions()`."""
    return _mupdf.ppdf_count_versions(doc)

def ppdf_create_annot(page, type):
    r""" Wrapper for `pdf_create_annot()`."""
    return _mupdf.ppdf_create_annot(page, type)

def ppdf_create_annot_raw(page, type):
    r""" Wrapper for `pdf_create_annot_raw()`."""
    return _mupdf.ppdf_create_annot_raw(page, type)

def ppdf_create_document():
    r""" Wrapper for `pdf_create_document()`."""
    return _mupdf.ppdf_create_document()

def ppdf_create_field_name(doc, prefix, buf, len):
    r""" Wrapper for `pdf_create_field_name()`."""
    return _mupdf.ppdf_create_field_name(doc, prefix, buf, len)

def ppdf_create_link(page, bbox, uri):
    r""" Wrapper for `pdf_create_link()`."""
    return _mupdf.ppdf_create_link(page, bbox, uri)

def ppdf_create_object(doc):
    r""" Wrapper for `pdf_create_object()`."""
    return _mupdf.ppdf_create_object(doc)

def ppdf_create_signature_widget(page, name):
    r""" Wrapper for `pdf_create_signature_widget()`."""
    return _mupdf.ppdf_create_signature_widget(page, name)

def ppdf_crypt_encrypt_metadata(crypt):
    r""" Wrapper for `pdf_crypt_encrypt_metadata()`."""
    return _mupdf.ppdf_crypt_encrypt_metadata(crypt)

def ppdf_crypt_key(crypt):
    r""" Wrapper for `pdf_crypt_key()`."""
    return _mupdf.ppdf_crypt_key(crypt)

def ppdf_crypt_length(crypt):
    r""" Wrapper for `pdf_crypt_length()`."""
    return _mupdf.ppdf_crypt_length(crypt)

def ppdf_crypt_method(crypt):
    r""" Wrapper for `pdf_crypt_method()`."""
    return _mupdf.ppdf_crypt_method(crypt)

def ppdf_crypt_obj(crypt, obj, num, gen):
    r""" Wrapper for `pdf_crypt_obj()`."""
    return _mupdf.ppdf_crypt_obj(crypt, obj, num, gen)

def ppdf_crypt_owner_encryption(crypt):
    r""" Wrapper for `pdf_crypt_owner_encryption()`."""
    return _mupdf.ppdf_crypt_owner_encryption(crypt)

def ppdf_crypt_owner_password(crypt):
    r""" Wrapper for `pdf_crypt_owner_password()`."""
    return _mupdf.ppdf_crypt_owner_password(crypt)

def ppdf_crypt_permissions(crypt):
    r""" Wrapper for `pdf_crypt_permissions()`."""
    return _mupdf.ppdf_crypt_permissions(crypt)

def ppdf_crypt_permissions_encryption(crypt):
    r""" Wrapper for `pdf_crypt_permissions_encryption()`."""
    return _mupdf.ppdf_crypt_permissions_encryption(crypt)

def ppdf_crypt_revision(crypt):
    r""" Wrapper for `pdf_crypt_revision()`."""
    return _mupdf.ppdf_crypt_revision(crypt)

def ppdf_crypt_user_encryption(crypt):
    r""" Wrapper for `pdf_crypt_user_encryption()`."""
    return _mupdf.ppdf_crypt_user_encryption(crypt)

def ppdf_crypt_user_password(crypt):
    r""" Wrapper for `pdf_crypt_user_password()`."""
    return _mupdf.ppdf_crypt_user_password(crypt)

def ppdf_crypt_version(crypt):
    r""" Wrapper for `pdf_crypt_version()`."""
    return _mupdf.ppdf_crypt_version(crypt)

def ppdf_debug_doc_changes(doc):
    r""" Wrapper for `pdf_debug_doc_changes()`."""
    return _mupdf.ppdf_debug_doc_changes(doc)

def ppdf_debug_obj(obj):
    r""" Wrapper for `pdf_debug_obj()`."""
    return _mupdf.ppdf_debug_obj(obj)

def ppdf_debug_ref(obj):
    r""" Wrapper for `pdf_debug_ref()`."""
    return _mupdf.ppdf_debug_ref(obj)

def ppdf_decode_cmap(cmap, s, e):
    r"""
     Wrapper for `pdf_decode_cmap()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_decode_cmap(pdf_cmap *cmap, unsigned char *s, unsigned char *e)` => `(int, unsigned int cpt)`
    """
    return _mupdf.ppdf_decode_cmap(cmap, s, e)

def ppdf_deep_copy_obj(obj):
    r""" Wrapper for `pdf_deep_copy_obj()`."""
    return _mupdf.ppdf_deep_copy_obj(obj)

def ppdf_delete_annot(page, annot):
    r""" Wrapper for `pdf_delete_annot()`."""
    return _mupdf.ppdf_delete_annot(page, annot)

def ppdf_delete_object(doc, num):
    r""" Wrapper for `pdf_delete_object()`."""
    return _mupdf.ppdf_delete_object(doc, num)

def ppdf_delete_page(doc, number):
    r""" Wrapper for `pdf_delete_page()`."""
    return _mupdf.ppdf_delete_page(doc, number)

def ppdf_delete_page_range(doc, start, end):
    r""" Wrapper for `pdf_delete_page_range()`."""
    return _mupdf.ppdf_delete_page_range(doc, start, end)

def ppdf_deselect_layer_config_ui(doc, ui):
    r""" Wrapper for `pdf_deselect_layer_config_ui()`."""
    return _mupdf.ppdf_deselect_layer_config_ui(doc, ui)

def ppdf_deserialise_journal(doc, stm):
    r""" Wrapper for `pdf_deserialise_journal()`."""
    return _mupdf.ppdf_deserialise_journal(doc, stm)

def ppdf_dict_del(dict, key):
    r""" Wrapper for `pdf_dict_del()`."""
    return _mupdf.ppdf_dict_del(dict, key)

def ppdf_dict_dels(dict, key):
    r""" Wrapper for `pdf_dict_dels()`."""
    return _mupdf.ppdf_dict_dels(dict, key)

def ppdf_dict_get(dict, key):
    r""" Wrapper for `pdf_dict_get()`."""
    return _mupdf.ppdf_dict_get(dict, key)

def ppdf_dict_get_bool(dict, key):
    r""" Wrapper for `pdf_dict_get_bool()`."""
    return _mupdf.ppdf_dict_get_bool(dict, key)

def ppdf_dict_get_date(dict, key):
    r""" Wrapper for `pdf_dict_get_date()`."""
    return _mupdf.ppdf_dict_get_date(dict, key)

def ppdf_dict_get_inheritable(dict, key):
    r""" Wrapper for `pdf_dict_get_inheritable()`."""
    return _mupdf.ppdf_dict_get_inheritable(dict, key)

def ppdf_dict_get_int(dict, key):
    r""" Wrapper for `pdf_dict_get_int()`."""
    return _mupdf.ppdf_dict_get_int(dict, key)

def ppdf_dict_get_key(dict, idx):
    r""" Wrapper for `pdf_dict_get_key()`."""
    return _mupdf.ppdf_dict_get_key(dict, idx)

def ppdf_dict_get_matrix(dict, key):
    r""" Wrapper for `pdf_dict_get_matrix()`."""
    return _mupdf.ppdf_dict_get_matrix(dict, key)

def ppdf_dict_get_name(dict, key):
    r""" Wrapper for `pdf_dict_get_name()`."""
    return _mupdf.ppdf_dict_get_name(dict, key)

def ppdf_dict_get_put_drop(dict, key, val, OUTPUT):
    r"""
     Wrapper for `pdf_dict_get_put_drop()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_dict_get_put_drop(pdf_obj *dict, pdf_obj *key, pdf_obj *val, pdf_obj **old_val)` =>
    """
    return _mupdf.ppdf_dict_get_put_drop(dict, key, val, OUTPUT)

def ppdf_dict_get_real(dict, key):
    r""" Wrapper for `pdf_dict_get_real()`."""
    return _mupdf.ppdf_dict_get_real(dict, key)

def ppdf_dict_get_rect(dict, key):
    r""" Wrapper for `pdf_dict_get_rect()`."""
    return _mupdf.ppdf_dict_get_rect(dict, key)

def ppdf_dict_get_string(dict, key):
    r"""
     Wrapper for `pdf_dict_get_string()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_dict_get_string(pdf_obj *dict, pdf_obj *key)` => `(const char *, size_t sizep)`
    """
    return _mupdf.ppdf_dict_get_string(dict, key)

def ppdf_dict_get_text_string(dict, key):
    r""" Wrapper for `pdf_dict_get_text_string()`."""
    return _mupdf.ppdf_dict_get_text_string(dict, key)

def ppdf_dict_get_val(dict, idx):
    r""" Wrapper for `pdf_dict_get_val()`."""
    return _mupdf.ppdf_dict_get_val(dict, idx)

def ppdf_dict_geta(dict, key, abbrev):
    r""" Wrapper for `pdf_dict_geta()`."""
    return _mupdf.ppdf_dict_geta(dict, key, abbrev)

def ppdf_dict_getp(dict, path):
    r""" Wrapper for `pdf_dict_getp()`."""
    return _mupdf.ppdf_dict_getp(dict, path)

def ppdf_dict_getp_inheritable(dict, path):
    r""" Wrapper for `pdf_dict_getp_inheritable()`."""
    return _mupdf.ppdf_dict_getp_inheritable(dict, path)

def ppdf_dict_gets(dict, key):
    r""" Wrapper for `pdf_dict_gets()`."""
    return _mupdf.ppdf_dict_gets(dict, key)

def ppdf_dict_getsa(dict, key, abbrev):
    r""" Wrapper for `pdf_dict_getsa()`."""
    return _mupdf.ppdf_dict_getsa(dict, key, abbrev)

def ppdf_dict_len(dict):
    r""" Wrapper for `pdf_dict_len()`."""
    return _mupdf.ppdf_dict_len(dict)

def ppdf_dict_put(dict, key, val):
    r""" Wrapper for `pdf_dict_put()`."""
    return _mupdf.ppdf_dict_put(dict, key, val)

def ppdf_dict_put_array(dict, key, initial):
    r""" Wrapper for `pdf_dict_put_array()`."""
    return _mupdf.ppdf_dict_put_array(dict, key, initial)

def ppdf_dict_put_bool(dict, key, x):
    r""" Wrapper for `pdf_dict_put_bool()`."""
    return _mupdf.ppdf_dict_put_bool(dict, key, x)

def ppdf_dict_put_date(dict, key, time):
    r""" Wrapper for `pdf_dict_put_date()`."""
    return _mupdf.ppdf_dict_put_date(dict, key, time)

def ppdf_dict_put_dict(dict, key, initial):
    r""" Wrapper for `pdf_dict_put_dict()`."""
    return _mupdf.ppdf_dict_put_dict(dict, key, initial)

def ppdf_dict_put_drop(dict, key, val):
    r""" Wrapper for `pdf_dict_put_drop()`."""
    return _mupdf.ppdf_dict_put_drop(dict, key, val)

def ppdf_dict_put_int(dict, key, x):
    r""" Wrapper for `pdf_dict_put_int()`."""
    return _mupdf.ppdf_dict_put_int(dict, key, x)

def ppdf_dict_put_matrix(dict, key, x):
    r""" Wrapper for `pdf_dict_put_matrix()`."""
    return _mupdf.ppdf_dict_put_matrix(dict, key, x)

def ppdf_dict_put_name(dict, key, x):
    r""" Wrapper for `pdf_dict_put_name()`."""
    return _mupdf.ppdf_dict_put_name(dict, key, x)

def ppdf_dict_put_real(dict, key, x):
    r""" Wrapper for `pdf_dict_put_real()`."""
    return _mupdf.ppdf_dict_put_real(dict, key, x)

def ppdf_dict_put_rect(dict, key, x):
    r""" Wrapper for `pdf_dict_put_rect()`."""
    return _mupdf.ppdf_dict_put_rect(dict, key, x)

def ppdf_dict_put_string(dict, key, x, n):
    r""" Wrapper for `pdf_dict_put_string()`."""
    return _mupdf.ppdf_dict_put_string(dict, key, x, n)

def ppdf_dict_put_text_string(dict, key, x):
    r""" Wrapper for `pdf_dict_put_text_string()`."""
    return _mupdf.ppdf_dict_put_text_string(dict, key, x)

def ppdf_dict_put_val_null(obj, idx):
    r""" Wrapper for `pdf_dict_put_val_null()`."""
    return _mupdf.ppdf_dict_put_val_null(obj, idx)

def ppdf_dict_putp(dict, path, val):
    r""" Wrapper for `pdf_dict_putp()`."""
    return _mupdf.ppdf_dict_putp(dict, path, val)

def ppdf_dict_putp_drop(dict, path, val):
    r""" Wrapper for `pdf_dict_putp_drop()`."""
    return _mupdf.ppdf_dict_putp_drop(dict, path, val)

def ppdf_dict_puts(dict, key, val):
    r""" Wrapper for `pdf_dict_puts()`."""
    return _mupdf.ppdf_dict_puts(dict, key, val)

def ppdf_dict_puts_dict(dict, key, initial):
    r""" Wrapper for `pdf_dict_puts_dict()`."""
    return _mupdf.ppdf_dict_puts_dict(dict, key, initial)

def ppdf_dict_puts_drop(dict, key, val):
    r""" Wrapper for `pdf_dict_puts_drop()`."""
    return _mupdf.ppdf_dict_puts_drop(dict, key, val)

def ppdf_dirty_annot(annot):
    r""" Wrapper for `pdf_dirty_annot()`."""
    return _mupdf.ppdf_dirty_annot(annot)

def ppdf_dirty_obj(obj):
    r""" Wrapper for `pdf_dirty_obj()`."""
    return _mupdf.ppdf_dirty_obj(obj)

def ppdf_disable_js(doc):
    r""" Wrapper for `pdf_disable_js()`."""
    return _mupdf.ppdf_disable_js(doc)

def ppdf_discard_journal(journal):
    r""" Wrapper for `pdf_discard_journal()`."""
    return _mupdf.ppdf_discard_journal(journal)

def ppdf_doc_was_linearized(doc):
    r""" Wrapper for `pdf_doc_was_linearized()`."""
    return _mupdf.ppdf_doc_was_linearized(doc)

def ppdf_document_event_did_print(doc):
    r""" Wrapper for `pdf_document_event_did_print()`."""
    return _mupdf.ppdf_document_event_did_print(doc)

def ppdf_document_event_did_save(doc):
    r""" Wrapper for `pdf_document_event_did_save()`."""
    return _mupdf.ppdf_document_event_did_save(doc)

def ppdf_document_event_will_close(doc):
    r""" Wrapper for `pdf_document_event_will_close()`."""
    return _mupdf.ppdf_document_event_will_close(doc)

def ppdf_document_event_will_print(doc):
    r""" Wrapper for `pdf_document_event_will_print()`."""
    return _mupdf.ppdf_document_event_will_print(doc)

def ppdf_document_event_will_save(doc):
    r""" Wrapper for `pdf_document_event_will_save()`."""
    return _mupdf.ppdf_document_event_will_save(doc)

def ppdf_document_from_fz_document(ptr):
    r""" Wrapper for `pdf_document_from_fz_document()`."""
    return _mupdf.ppdf_document_from_fz_document(ptr)

def ppdf_document_language(doc):
    r""" Wrapper for `pdf_document_language()`."""
    return _mupdf.ppdf_document_language(doc)

def ppdf_document_output_intent(doc):
    r""" Wrapper for `pdf_document_output_intent()`."""
    return _mupdf.ppdf_document_output_intent(doc)

def ppdf_document_permissions(doc):
    r""" Wrapper for `pdf_document_permissions()`."""
    return _mupdf.ppdf_document_permissions(doc)

def ppdf_drop_annot(annot):
    r""" Wrapper for `pdf_drop_annot()`."""
    return _mupdf.ppdf_drop_annot(annot)

def ppdf_drop_cmap(cmap):
    r""" Wrapper for `pdf_drop_cmap()`."""
    return _mupdf.ppdf_drop_cmap(cmap)

def ppdf_drop_cmap_imp(cmap):
    r""" Wrapper for `pdf_drop_cmap_imp()`."""
    return _mupdf.ppdf_drop_cmap_imp(cmap)

def ppdf_drop_crypt(crypt):
    r""" Wrapper for `pdf_drop_crypt()`."""
    return _mupdf.ppdf_drop_crypt(crypt)

def ppdf_drop_document(doc):
    r""" Wrapper for `pdf_drop_document()`."""
    return _mupdf.ppdf_drop_document(doc)

def ppdf_drop_font(font):
    r""" Wrapper for `pdf_drop_font()`."""
    return _mupdf.ppdf_drop_font(font)

def ppdf_drop_function(func):
    r""" Wrapper for `pdf_drop_function()`."""
    return _mupdf.ppdf_drop_function(func)

def ppdf_drop_graft_map(map):
    r""" Wrapper for `pdf_drop_graft_map()`."""
    return _mupdf.ppdf_drop_graft_map(map)

def ppdf_drop_journal(journal):
    r""" Wrapper for `pdf_drop_journal()`."""
    return _mupdf.ppdf_drop_journal(journal)

def ppdf_drop_js(js):
    r""" Wrapper for `pdf_drop_js()`."""
    return _mupdf.ppdf_drop_js(js)

def ppdf_drop_local_xref(xref):
    r""" Wrapper for `pdf_drop_local_xref()`."""
    return _mupdf.ppdf_drop_local_xref(xref)

def ppdf_drop_local_xref_and_resources(doc):
    r""" Wrapper for `pdf_drop_local_xref_and_resources()`."""
    return _mupdf.ppdf_drop_local_xref_and_resources(doc)

def ppdf_drop_locked_fields(locked):
    r""" Wrapper for `pdf_drop_locked_fields()`."""
    return _mupdf.ppdf_drop_locked_fields(locked)

def ppdf_drop_obj(obj):
    r""" Wrapper for `pdf_drop_obj()`."""
    return _mupdf.ppdf_drop_obj(obj)

def ppdf_drop_ocg(doc):
    r""" Wrapper for `pdf_drop_ocg()`."""
    return _mupdf.ppdf_drop_ocg(doc)

def ppdf_drop_page_tree(doc):
    r""" Wrapper for `pdf_drop_page_tree()`."""
    return _mupdf.ppdf_drop_page_tree(doc)

def ppdf_drop_pattern(pat):
    r""" Wrapper for `pdf_drop_pattern()`."""
    return _mupdf.ppdf_drop_pattern(pat)

def ppdf_drop_processor(proc):
    r""" Wrapper for `pdf_drop_processor()`."""
    return _mupdf.ppdf_drop_processor(proc)

def ppdf_drop_resource_tables(doc):
    r""" Wrapper for `pdf_drop_resource_tables()`."""
    return _mupdf.ppdf_drop_resource_tables(doc)

def ppdf_drop_signer(signer):
    r""" Wrapper for `pdf_drop_signer()`."""
    return _mupdf.ppdf_drop_signer(signer)

def ppdf_drop_verifier(verifier):
    r""" Wrapper for `pdf_drop_verifier()`."""
    return _mupdf.ppdf_drop_verifier(verifier)

def ppdf_drop_widget(widget):
    r""" Wrapper for `pdf_drop_widget()`."""
    return _mupdf.ppdf_drop_widget(widget)

def ppdf_edit_text_field_value(widget, value, change):
    r"""
     Wrapper for `pdf_edit_text_field_value()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_edit_text_field_value(pdf_annot *widget, const char *value, const char *change)` => `(int, int selStart, int selEnd, char *newvalue)`
    """
    return _mupdf.ppdf_edit_text_field_value(widget, value, change)

def ppdf_embedded_file_name(fs):
    r""" Wrapper for `pdf_embedded_file_name()`."""
    return _mupdf.ppdf_embedded_file_name(fs)

def ppdf_embedded_file_stream(fs):
    r""" Wrapper for `pdf_embedded_file_stream()`."""
    return _mupdf.ppdf_embedded_file_stream(fs)

def ppdf_embedded_file_type(fs):
    r""" Wrapper for `pdf_embedded_file_type()`."""
    return _mupdf.ppdf_embedded_file_type(fs)

def ppdf_empty_store(doc):
    r""" Wrapper for `pdf_empty_store()`."""
    return _mupdf.ppdf_empty_store(doc)

def ppdf_enable_journal(doc):
    r""" Wrapper for `pdf_enable_journal()`."""
    return _mupdf.ppdf_enable_journal(doc)

def ppdf_enable_js(doc):
    r""" Wrapper for `pdf_enable_js()`."""
    return _mupdf.ppdf_enable_js(doc)

def ppdf_encrypt_data(crypt, num, gen, fmt_str_out, arg, s, n):
    r""" Wrapper for `pdf_encrypt_data()`."""
    return _mupdf.ppdf_encrypt_data(crypt, num, gen, fmt_str_out, arg, s, n)

def ppdf_encrypted_len(crypt, num, gen, len):
    r""" Wrapper for `pdf_encrypted_len()`."""
    return _mupdf.ppdf_encrypted_len(crypt, num, gen, len)

def ppdf_end_hmtx(font):
    r""" Wrapper for `pdf_end_hmtx()`."""
    return _mupdf.ppdf_end_hmtx(font)

def ppdf_end_operation(doc):
    r""" Wrapper for `pdf_end_operation()`."""
    return _mupdf.ppdf_end_operation(doc)

def ppdf_end_vmtx(font):
    r""" Wrapper for `pdf_end_vmtx()`."""
    return _mupdf.ppdf_end_vmtx(font)

def ppdf_ensure_solid_xref(doc, num):
    r""" Wrapper for `pdf_ensure_solid_xref()`."""
    return _mupdf.ppdf_ensure_solid_xref(doc, num)

def ppdf_eval_function(func, _in, inlen, outlen):
    r"""
     Wrapper for `pdf_eval_function()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_eval_function(pdf_function *func, const float *in, int inlen, int outlen)` => float out
    """
    return _mupdf.ppdf_eval_function(func, _in, inlen, outlen)

def ppdf_event_issue_alert(doc, evt):
    r""" Wrapper for `pdf_event_issue_alert()`."""
    return _mupdf.ppdf_event_issue_alert(doc, evt)

def ppdf_event_issue_exec_menu_item(doc, item):
    r""" Wrapper for `pdf_event_issue_exec_menu_item()`."""
    return _mupdf.ppdf_event_issue_exec_menu_item(doc, item)

def ppdf_event_issue_launch_url(doc, url, new_frame):
    r""" Wrapper for `pdf_event_issue_launch_url()`."""
    return _mupdf.ppdf_event_issue_launch_url(doc, url, new_frame)

def ppdf_event_issue_mail_doc(doc, evt):
    r""" Wrapper for `pdf_event_issue_mail_doc()`."""
    return _mupdf.ppdf_event_issue_mail_doc(doc, evt)

def ppdf_event_issue_print(doc):
    r""" Wrapper for `pdf_event_issue_print()`."""
    return _mupdf.ppdf_event_issue_print(doc)

def ppdf_field_border_style(field):
    r""" Wrapper for `pdf_field_border_style()`."""
    return _mupdf.ppdf_field_border_style(field)

def ppdf_field_display(field):
    r""" Wrapper for `pdf_field_display()`."""
    return _mupdf.ppdf_field_display(field)

def ppdf_field_event_calculate(doc, field):
    r""" Wrapper for `pdf_field_event_calculate()`."""
    return _mupdf.ppdf_field_event_calculate(doc, field)

def ppdf_field_event_format(doc, field):
    r""" Wrapper for `pdf_field_event_format()`."""
    return _mupdf.ppdf_field_event_format(doc, field)

def ppdf_field_event_keystroke(doc, field, evt):
    r""" Wrapper for `pdf_field_event_keystroke()`."""
    return _mupdf.ppdf_field_event_keystroke(doc, field, evt)

def ppdf_field_event_validate(doc, field, value):
    r"""
     Wrapper for `pdf_field_event_validate()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_field_event_validate(pdf_document *doc, pdf_obj *field, const char *value)` => `(int, char *newvalue)`
    """
    return _mupdf.ppdf_field_event_validate(doc, field, value)

def ppdf_field_flags(field):
    r""" Wrapper for `pdf_field_flags()`."""
    return _mupdf.ppdf_field_flags(field)

def ppdf_field_label(field):
    r""" Wrapper for `pdf_field_label()`."""
    return _mupdf.ppdf_field_label(field)

def ppdf_field_name(field):
    r""" Wrapper for `pdf_field_name()`."""
    return _mupdf.ppdf_field_name(field)

def ppdf_field_reset(doc, field):
    r""" Wrapper for `pdf_field_reset()`."""
    return _mupdf.ppdf_field_reset(doc, field)

def ppdf_field_set_border_style(field, text):
    r""" Wrapper for `pdf_field_set_border_style()`."""
    return _mupdf.ppdf_field_set_border_style(field, text)

def ppdf_field_set_button_caption(field, text):
    r""" Wrapper for `pdf_field_set_button_caption()`."""
    return _mupdf.ppdf_field_set_button_caption(field, text)

def ppdf_field_set_display(field, d):
    r""" Wrapper for `pdf_field_set_display()`."""
    return _mupdf.ppdf_field_set_display(field, d)

def ppdf_field_set_fill_color(field, col):
    r""" Wrapper for `pdf_field_set_fill_color()`."""
    return _mupdf.ppdf_field_set_fill_color(field, col)

def ppdf_field_set_text_color(field, col):
    r""" Wrapper for `pdf_field_set_text_color()`."""
    return _mupdf.ppdf_field_set_text_color(field, col)

def ppdf_field_type(field):
    r""" Wrapper for `pdf_field_type()`."""
    return _mupdf.ppdf_field_type(field)

def ppdf_field_type_string(field):
    r""" Wrapper for `pdf_field_type_string()`."""
    return _mupdf.ppdf_field_type_string(field)

def ppdf_field_value(field):
    r""" Wrapper for `pdf_field_value()`."""
    return _mupdf.ppdf_field_value(field)

def ppdf_filter_annot_contents(doc, annot, filter):
    r""" Wrapper for `pdf_filter_annot_contents()`."""
    return _mupdf.ppdf_filter_annot_contents(doc, annot, filter)

def ppdf_filter_page_contents(doc, page, filter):
    r""" Wrapper for `pdf_filter_page_contents()`."""
    return _mupdf.ppdf_filter_page_contents(doc, page, filter)

def ppdf_filter_xobject_instance(old_xobj, page_res, ctm, filter):
    r""" Wrapper for `pdf_filter_xobject_instance()`."""
    return _mupdf.ppdf_filter_xobject_instance(old_xobj, page_res, ctm, filter)

def ppdf_find_font_resource(doc, type, encoding, item, key):
    r""" Wrapper for `pdf_find_font_resource()`."""
    return _mupdf.ppdf_find_font_resource(doc, type, encoding, item, key)

def ppdf_find_item(drop, key):
    r""" Wrapper for `pdf_find_item()`."""
    return _mupdf.ppdf_find_item(drop, key)

def ppdf_find_locked_fields(doc, version):
    r""" Wrapper for `pdf_find_locked_fields()`."""
    return _mupdf.ppdf_find_locked_fields(doc, version)

def ppdf_find_locked_fields_for_sig(doc, sig):
    r""" Wrapper for `pdf_find_locked_fields_for_sig()`."""
    return _mupdf.ppdf_find_locked_fields_for_sig(doc, sig)

def ppdf_find_version_for_obj(doc, obj):
    r""" Wrapper for `pdf_find_version_for_obj()`."""
    return _mupdf.ppdf_find_version_for_obj(doc, obj)

def ppdf_first_annot(page):
    r""" Wrapper for `pdf_first_annot()`."""
    return _mupdf.ppdf_first_annot(page)

def ppdf_first_widget(page):
    r""" Wrapper for `pdf_first_widget()`."""
    return _mupdf.ppdf_first_widget(page)

def ppdf_flatten_inheritable_page_items(page):
    r""" Wrapper for `pdf_flatten_inheritable_page_items()`."""
    return _mupdf.ppdf_flatten_inheritable_page_items(page)

def ppdf_font_cid_to_gid(fontdesc, cid):
    r""" Wrapper for `pdf_font_cid_to_gid()`."""
    return _mupdf.ppdf_font_cid_to_gid(fontdesc, cid)

def ppdf_font_writing_supported(font):
    r""" Wrapper for `pdf_font_writing_supported()`."""
    return _mupdf.ppdf_font_writing_supported(font)

def ppdf_forget_xref(doc):
    r""" Wrapper for `pdf_forget_xref()`."""
    return _mupdf.ppdf_forget_xref(doc)

def ppdf_format_date(time, s, n):
    r""" Wrapper for `pdf_format_date()`."""
    return _mupdf.ppdf_format_date(time, s, n)

def ppdf_format_link_uri(dest):
    r""" Wrapper for `pdf_format_link_uri()`."""
    return _mupdf.ppdf_format_link_uri(dest)

def ppdf_format_write_options(buffer, buffer_len, opts):
    r""" Wrapper for `pdf_format_write_options()`."""
    return _mupdf.ppdf_format_write_options(buffer, buffer_len, opts)

def ppdf_function_size(func):
    r""" Wrapper for `pdf_function_size()`."""
    return _mupdf.ppdf_function_size(func)

def ppdf_get_bound_document(obj):
    r""" Wrapper for `pdf_get_bound_document()`."""
    return _mupdf.ppdf_get_bound_document(obj)

def ppdf_get_doc_event_callback_data(doc):
    r""" Wrapper for `pdf_get_doc_event_callback_data()`."""
    return _mupdf.ppdf_get_doc_event_callback_data(doc)

def ppdf_get_incremental_xref_entry(doc, i):
    r""" Wrapper for `pdf_get_incremental_xref_entry()`."""
    return _mupdf.ppdf_get_incremental_xref_entry(doc, i)

def ppdf_get_indirect_document(obj):
    r""" Wrapper for `pdf_get_indirect_document()`."""
    return _mupdf.ppdf_get_indirect_document(obj)

def ppdf_get_populating_xref_entry(doc, i):
    r""" Wrapper for `pdf_get_populating_xref_entry()`."""
    return _mupdf.ppdf_get_populating_xref_entry(doc, i)

def ppdf_get_widget_editing_state(widget):
    r""" Wrapper for `pdf_get_widget_editing_state()`."""
    return _mupdf.ppdf_get_widget_editing_state(widget)

def ppdf_get_xref_entry(doc, i):
    r""" Wrapper for `pdf_get_xref_entry()`."""
    return _mupdf.ppdf_get_xref_entry(doc, i)

def ppdf_graft_mapped_object(map, obj):
    r""" Wrapper for `pdf_graft_mapped_object()`."""
    return _mupdf.ppdf_graft_mapped_object(map, obj)

def ppdf_graft_mapped_page(map, page_to, src, page_from):
    r""" Wrapper for `pdf_graft_mapped_page()`."""
    return _mupdf.ppdf_graft_mapped_page(map, page_to, src, page_from)

def ppdf_graft_object(dst, obj):
    r""" Wrapper for `pdf_graft_object()`."""
    return _mupdf.ppdf_graft_object(dst, obj)

def ppdf_graft_page(dst, page_to, src, page_from):
    r""" Wrapper for `pdf_graft_page()`."""
    return _mupdf.ppdf_graft_page(dst, page_to, src, page_from)

def ppdf_guess_mime_type_from_file_name(filename):
    r""" Wrapper for `pdf_guess_mime_type_from_file_name()`."""
    return _mupdf.ppdf_guess_mime_type_from_file_name(filename)

def ppdf_has_permission(doc, p):
    r""" Wrapper for `pdf_has_permission()`."""
    return _mupdf.ppdf_has_permission(doc, p)

def ppdf_has_unsaved_changes(doc):
    r""" Wrapper for `pdf_has_unsaved_changes()`."""
    return _mupdf.ppdf_has_unsaved_changes(doc)

def ppdf_has_unsaved_sigs(doc):
    r""" Wrapper for `pdf_has_unsaved_sigs()`."""
    return _mupdf.ppdf_has_unsaved_sigs(doc)

def ppdf_insert_font_resource(doc, key, obj):
    r""" Wrapper for `pdf_insert_font_resource()`."""
    return _mupdf.ppdf_insert_font_resource(doc, key, obj)

def ppdf_insert_page(doc, at, page):
    r""" Wrapper for `pdf_insert_page()`."""
    return _mupdf.ppdf_insert_page(doc, at, page)

def ppdf_invalidate_xfa(doc):
    r""" Wrapper for `pdf_invalidate_xfa()`."""
    return _mupdf.ppdf_invalidate_xfa(doc)

def ppdf_is_array(obj):
    r""" Wrapper for `pdf_is_array()`."""
    return _mupdf.ppdf_is_array(obj)

def ppdf_is_bool(obj):
    r""" Wrapper for `pdf_is_bool()`."""
    return _mupdf.ppdf_is_bool(obj)

def ppdf_is_dict(obj):
    r""" Wrapper for `pdf_is_dict()`."""
    return _mupdf.ppdf_is_dict(obj)

def ppdf_is_embedded_file(fs):
    r""" Wrapper for `pdf_is_embedded_file()`."""
    return _mupdf.ppdf_is_embedded_file(fs)

def ppdf_is_field_locked(locked, name):
    r""" Wrapper for `pdf_is_field_locked()`."""
    return _mupdf.ppdf_is_field_locked(locked, name)

def ppdf_is_indirect(obj):
    r""" Wrapper for `pdf_is_indirect()`."""
    return _mupdf.ppdf_is_indirect(obj)

def ppdf_is_int(obj):
    r""" Wrapper for `pdf_is_int()`."""
    return _mupdf.ppdf_is_int(obj)

def ppdf_is_jpx_image(dict):
    r""" Wrapper for `pdf_is_jpx_image()`."""
    return _mupdf.ppdf_is_jpx_image(dict)

def ppdf_is_local_object(doc, obj):
    r""" Wrapper for `pdf_is_local_object()`."""
    return _mupdf.ppdf_is_local_object(doc, obj)

def ppdf_is_name(obj):
    r""" Wrapper for `pdf_is_name()`."""
    return _mupdf.ppdf_is_name(obj)

def ppdf_is_null(obj):
    r""" Wrapper for `pdf_is_null()`."""
    return _mupdf.ppdf_is_null(obj)

def ppdf_is_number(obj):
    r""" Wrapper for `pdf_is_number()`."""
    return _mupdf.ppdf_is_number(obj)

def ppdf_is_ocg_hidden(doc, rdb, usage, ocg):
    r""" Wrapper for `pdf_is_ocg_hidden()`."""
    return _mupdf.ppdf_is_ocg_hidden(doc, rdb, usage, ocg)

def ppdf_is_real(obj):
    r""" Wrapper for `pdf_is_real()`."""
    return _mupdf.ppdf_is_real(obj)

def ppdf_is_stream(obj):
    r""" Wrapper for `pdf_is_stream()`."""
    return _mupdf.ppdf_is_stream(obj)

def ppdf_is_string(obj):
    r""" Wrapper for `pdf_is_string()`."""
    return _mupdf.ppdf_is_string(obj)

def ppdf_is_tint_colorspace(cs):
    r""" Wrapper for `pdf_is_tint_colorspace()`."""
    return _mupdf.ppdf_is_tint_colorspace(cs)

def ppdf_js_event_init(js, target, value, willCommit):
    r""" Wrapper for `pdf_js_event_init()`."""
    return _mupdf.ppdf_js_event_init(js, target, value, willCommit)

def ppdf_js_event_init_keystroke(js, target, evt):
    r""" Wrapper for `pdf_js_event_init_keystroke()`."""
    return _mupdf.ppdf_js_event_init_keystroke(js, target, evt)

def ppdf_js_event_result(js):
    r""" Wrapper for `pdf_js_event_result()`."""
    return _mupdf.ppdf_js_event_result(js)

def ppdf_js_event_result_keystroke(js, evt):
    r""" Wrapper for `pdf_js_event_result_keystroke()`."""
    return _mupdf.ppdf_js_event_result_keystroke(js, evt)

def ppdf_js_event_result_validate(js):
    r"""
     Wrapper for `pdf_js_event_result_validate()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_js_event_result_validate(pdf_js *js)` => `(int, char *newvalue)`
    """
    return _mupdf.ppdf_js_event_result_validate(js)

def ppdf_js_event_value(js):
    r""" Wrapper for `pdf_js_event_value()`."""
    return _mupdf.ppdf_js_event_value(js)

def ppdf_js_execute(js, name, code):
    r"""
     Wrapper for `pdf_js_execute()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_js_execute(pdf_js *js, const char *name, const char *code)` => char *result
    """
    return _mupdf.ppdf_js_execute(js, name, code)

def ppdf_js_get_console(doc):
    r""" Wrapper for `pdf_js_get_console()`."""
    return _mupdf.ppdf_js_get_console(doc)

def ppdf_js_set_console(doc, console, user):
    r""" Wrapper for `pdf_js_set_console()`."""
    return _mupdf.ppdf_js_set_console(doc, console, user)

def ppdf_js_supported(doc):
    r""" Wrapper for `pdf_js_supported()`."""
    return _mupdf.ppdf_js_supported(doc)

def ppdf_keep_annot(annot):
    r""" Wrapper for `pdf_keep_annot()`."""
    return _mupdf.ppdf_keep_annot(annot)

def ppdf_keep_cmap(cmap):
    r""" Wrapper for `pdf_keep_cmap()`."""
    return _mupdf.ppdf_keep_cmap(cmap)

def ppdf_keep_document(doc):
    r""" Wrapper for `pdf_keep_document()`."""
    return _mupdf.ppdf_keep_document(doc)

def ppdf_keep_font(fontdesc):
    r""" Wrapper for `pdf_keep_font()`."""
    return _mupdf.ppdf_keep_font(fontdesc)

def ppdf_keep_function(func):
    r""" Wrapper for `pdf_keep_function()`."""
    return _mupdf.ppdf_keep_function(func)

def ppdf_keep_graft_map(map):
    r""" Wrapper for `pdf_keep_graft_map()`."""
    return _mupdf.ppdf_keep_graft_map(map)

def ppdf_keep_obj(obj):
    r""" Wrapper for `pdf_keep_obj()`."""
    return _mupdf.ppdf_keep_obj(obj)

def ppdf_keep_pattern(pat):
    r""" Wrapper for `pdf_keep_pattern()`."""
    return _mupdf.ppdf_keep_pattern(pat)

def ppdf_keep_processor(proc):
    r""" Wrapper for `pdf_keep_processor()`."""
    return _mupdf.ppdf_keep_processor(proc)

def ppdf_keep_widget(widget):
    r""" Wrapper for `pdf_keep_widget()`."""
    return _mupdf.ppdf_keep_widget(widget)

def ppdf_layer_config_info(doc, config_num, info):
    r""" Wrapper for `pdf_layer_config_info()`."""
    return _mupdf.ppdf_layer_config_info(doc, config_num, info)

def ppdf_layer_config_ui_info(doc, ui, info):
    r""" Wrapper for `pdf_layer_config_ui_info()`."""
    return _mupdf.ppdf_layer_config_ui_info(doc, ui, info)

def ppdf_layout_fit_text(font, lang, str, bounds):
    r""" Wrapper for `pdf_layout_fit_text()`."""
    return _mupdf.ppdf_layout_fit_text(font, lang, str, bounds)

def ppdf_layout_text_widget(annot):
    r""" Wrapper for `pdf_layout_text_widget()`."""
    return _mupdf.ppdf_layout_text_widget(annot)

def ppdf_lex(f, lexbuf):
    r""" Wrapper for `pdf_lex()`."""
    return _mupdf.ppdf_lex(f, lexbuf)

def ppdf_lex_no_string(f, lexbuf):
    r""" Wrapper for `pdf_lex_no_string()`."""
    return _mupdf.ppdf_lex_no_string(f, lexbuf)

def ppdf_lexbuf_fin(lexbuf):
    r""" Wrapper for `pdf_lexbuf_fin()`."""
    return _mupdf.ppdf_lexbuf_fin(lexbuf)

def ppdf_lexbuf_grow(lexbuf):
    r""" Wrapper for `pdf_lexbuf_grow()`."""
    return _mupdf.ppdf_lexbuf_grow(lexbuf)

def ppdf_lexbuf_init(lexbuf, size):
    r""" Wrapper for `pdf_lexbuf_init()`."""
    return _mupdf.ppdf_lexbuf_init(lexbuf, size)

def ppdf_line_ending_from_name(end):
    r""" Wrapper for `pdf_line_ending_from_name()`."""
    return _mupdf.ppdf_line_ending_from_name(end)

def ppdf_line_ending_from_string(end):
    r""" Wrapper for `pdf_line_ending_from_string()`."""
    return _mupdf.ppdf_line_ending_from_string(end)

def ppdf_load_builtin_cmap(name):
    r""" Wrapper for `pdf_load_builtin_cmap()`."""
    return _mupdf.ppdf_load_builtin_cmap(name)

def ppdf_load_cmap(file):
    r""" Wrapper for `pdf_load_cmap()`."""
    return _mupdf.ppdf_load_cmap(file)

def ppdf_load_colorspace(obj):
    r""" Wrapper for `pdf_load_colorspace()`."""
    return _mupdf.ppdf_load_colorspace(obj)

def ppdf_load_compressed_inline_image(doc, dict, length, cstm, indexed, image):
    r""" Wrapper for `pdf_load_compressed_inline_image()`."""
    return _mupdf.ppdf_load_compressed_inline_image(doc, dict, length, cstm, indexed, image)

def ppdf_load_compressed_stream(doc, num):
    r""" Wrapper for `pdf_load_compressed_stream()`."""
    return _mupdf.ppdf_load_compressed_stream(doc, num)

def ppdf_load_default_colorspaces(doc, page):
    r""" Wrapper for `pdf_load_default_colorspaces()`."""
    return _mupdf.ppdf_load_default_colorspaces(doc, page)

def ppdf_load_embedded_cmap(doc, ref):
    r""" Wrapper for `pdf_load_embedded_cmap()`."""
    return _mupdf.ppdf_load_embedded_cmap(doc, ref)

def ppdf_load_embedded_file(fs):
    r""" Wrapper for `pdf_load_embedded_file()`."""
    return _mupdf.ppdf_load_embedded_file(fs)

def ppdf_load_encoding(encoding):
    r"""
     Wrapper for `pdf_load_encoding()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_load_encoding(const char *encoding)` => const char *estrings
    """
    return _mupdf.ppdf_load_encoding(encoding)

def ppdf_load_font(doc, rdb, obj):
    r""" Wrapper for `pdf_load_font()`."""
    return _mupdf.ppdf_load_font(doc, rdb, obj)

def ppdf_load_function(ref, _in, out):
    r""" Wrapper for `pdf_load_function()`."""
    return _mupdf.ppdf_load_function(ref, _in, out)

def ppdf_load_hail_mary_font(doc):
    r""" Wrapper for `pdf_load_hail_mary_font()`."""
    return _mupdf.ppdf_load_hail_mary_font(doc)

def ppdf_load_image(doc, obj):
    r""" Wrapper for `pdf_load_image()`."""
    return _mupdf.ppdf_load_image(doc, obj)

def ppdf_load_inline_image(doc, rdb, dict, file):
    r""" Wrapper for `pdf_load_inline_image()`."""
    return _mupdf.ppdf_load_inline_image(doc, rdb, dict, file)

def ppdf_load_journal(doc, filename):
    r""" Wrapper for `pdf_load_journal()`."""
    return _mupdf.ppdf_load_journal(doc, filename)

def ppdf_load_link_annots(arg_1, annots, pagenum, page_ctm):
    r""" Wrapper for `pdf_load_link_annots()`."""
    return _mupdf.ppdf_load_link_annots(arg_1, annots, pagenum, page_ctm)

def ppdf_load_links(page):
    r""" Wrapper for `pdf_load_links()`."""
    return _mupdf.ppdf_load_links(page)

def ppdf_load_name_tree(doc, which):
    r""" Wrapper for `pdf_load_name_tree()`."""
    return _mupdf.ppdf_load_name_tree(doc, which)

def ppdf_load_object(doc, num):
    r""" Wrapper for `pdf_load_object()`."""
    return _mupdf.ppdf_load_object(doc, num)

def ppdf_load_outline(doc):
    r""" Wrapper for `pdf_load_outline()`."""
    return _mupdf.ppdf_load_outline(doc)

def ppdf_load_page(doc, number):
    r""" Wrapper for `pdf_load_page()`."""
    return _mupdf.ppdf_load_page(doc, number)

def ppdf_load_page_imp(doc, chapter, number):
    r""" Wrapper for `pdf_load_page_imp()`."""
    return _mupdf.ppdf_load_page_imp(doc, chapter, number)

def ppdf_load_page_tree(doc):
    r""" Wrapper for `pdf_load_page_tree()`."""
    return _mupdf.ppdf_load_page_tree(doc)

def ppdf_load_pattern(doc, obj):
    r""" Wrapper for `pdf_load_pattern()`."""
    return _mupdf.ppdf_load_pattern(doc, obj)

def ppdf_load_raw_stream(ref):
    r""" Wrapper for `pdf_load_raw_stream()`."""
    return _mupdf.ppdf_load_raw_stream(ref)

def ppdf_load_raw_stream_number(doc, num):
    r""" Wrapper for `pdf_load_raw_stream_number()`."""
    return _mupdf.ppdf_load_raw_stream_number(doc, num)

def ppdf_load_shading(doc, obj):
    r""" Wrapper for `pdf_load_shading()`."""
    return _mupdf.ppdf_load_shading(doc, obj)

def ppdf_load_stream(ref):
    r""" Wrapper for `pdf_load_stream()`."""
    return _mupdf.ppdf_load_stream(ref)

def ppdf_load_stream_number(doc, num):
    r""" Wrapper for `pdf_load_stream_number()`."""
    return _mupdf.ppdf_load_stream_number(doc, num)

def ppdf_load_stream_or_string_as_utf8(src):
    r""" Wrapper for `pdf_load_stream_or_string_as_utf8()`."""
    return _mupdf.ppdf_load_stream_or_string_as_utf8(src)

def ppdf_load_system_cmap(name):
    r""" Wrapper for `pdf_load_system_cmap()`."""
    return _mupdf.ppdf_load_system_cmap(name)

def ppdf_load_to_unicode(doc, font, collection, cmapstm):
    r"""
     Wrapper for `pdf_load_to_unicode()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_load_to_unicode(pdf_document *doc, pdf_font_desc *font, char *collection, pdf_obj *cmapstm)` => const char *strings
    """
    return _mupdf.ppdf_load_to_unicode(doc, font, collection, cmapstm)

def ppdf_load_type3_font(doc, rdb, obj):
    r""" Wrapper for `pdf_load_type3_font()`."""
    return _mupdf.ppdf_load_type3_font(doc, rdb, obj)

def ppdf_load_type3_glyphs(doc, fontdesc):
    r""" Wrapper for `pdf_load_type3_glyphs()`."""
    return _mupdf.ppdf_load_type3_glyphs(doc, fontdesc)

def ppdf_load_unencrypted_object(doc, num):
    r""" Wrapper for `pdf_load_unencrypted_object()`."""
    return _mupdf.ppdf_load_unencrypted_object(doc, num)

def ppdf_lookup_anchor(doc, name):
    r"""
     Wrapper for `pdf_lookup_anchor()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_lookup_anchor(pdf_document *doc, const char *name)` => `(int, float xp, float yp)`
    """
    return _mupdf.ppdf_lookup_anchor(doc, name)

def ppdf_lookup_cmap(cmap, cpt):
    r""" Wrapper for `pdf_lookup_cmap()`."""
    return _mupdf.ppdf_lookup_cmap(cmap, cpt)

def ppdf_lookup_cmap_full(cmap, cpt):
    r"""
     Wrapper for `pdf_lookup_cmap_full()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_lookup_cmap_full(pdf_cmap *cmap, unsigned int cpt)` => `(int, int out)`
    """
    return _mupdf.ppdf_lookup_cmap_full(cmap, cpt)

def ppdf_lookup_dest(doc, needle):
    r""" Wrapper for `pdf_lookup_dest()`."""
    return _mupdf.ppdf_lookup_dest(doc, needle)

def ppdf_lookup_field(form, name):
    r""" Wrapper for `pdf_lookup_field()`."""
    return _mupdf.ppdf_lookup_field(form, name)

def ppdf_lookup_hmtx(font, cid):
    r""" Wrapper for `pdf_lookup_hmtx()`."""
    return _mupdf.ppdf_lookup_hmtx(font, cid)

def ppdf_lookup_metadata(*args):
    r"""
    *Overload 1:*
     Wrapper for `pdf_lookup_metadata()`.

    |

    *Overload 2:*
     Extra wrapper for `pdf_lookup_metadata()` that returns a std::string and sets
    o_out to length of string plus one. If <key> is not found, returns empty
    string with *o_out=-1. <o_out> can be NULL if caller is not interested in
    error information.

    |

    *Overload 3:*
     Extra wrapper for `pdf_lookup_metadata()` that returns a std::string and sets
    o_out to length of string plus one. If <key> is not found, returns empty
    string with *o_out=-1. <o_out> can be NULL if caller is not interested in
    error information.
    """
    return _mupdf.ppdf_lookup_metadata(*args)

def ppdf_lookup_name(doc, which, needle):
    r""" Wrapper for `pdf_lookup_name()`."""
    return _mupdf.ppdf_lookup_name(doc, which, needle)

def ppdf_lookup_number(root, needle):
    r""" Wrapper for `pdf_lookup_number()`."""
    return _mupdf.ppdf_lookup_number(root, needle)

def ppdf_lookup_page_number(doc, pageobj):
    r""" Wrapper for `pdf_lookup_page_number()`."""
    return _mupdf.ppdf_lookup_page_number(doc, pageobj)

def ppdf_lookup_page_obj(doc, needle):
    r""" Wrapper for `pdf_lookup_page_obj()`."""
    return _mupdf.ppdf_lookup_page_obj(doc, needle)

def ppdf_lookup_substitute_font(mono, serif, bold, italic):
    r"""
     Wrapper for `pdf_lookup_substitute_font()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_lookup_substitute_font(int mono, int serif, int bold, int italic)` => `(const unsigned char *, int len)`
    """
    return _mupdf.ppdf_lookup_substitute_font(mono, serif, bold, italic)

def ppdf_lookup_vmtx(font, cid):
    r""" Wrapper for `pdf_lookup_vmtx()`."""
    return _mupdf.ppdf_lookup_vmtx(font, cid)

def ppdf_map_one_to_many(cmap, one, len):
    r"""
     Wrapper for `pdf_map_one_to_many()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_map_one_to_many(pdf_cmap *cmap, unsigned int one, size_t len)` => int many
    """
    return _mupdf.ppdf_map_one_to_many(cmap, one, len)

def ppdf_map_range_to_range(cmap, srclo, srchi, dstlo):
    r""" Wrapper for `pdf_map_range_to_range()`."""
    return _mupdf.ppdf_map_range_to_range(cmap, srclo, srchi, dstlo)

def ppdf_mark_list_free(list):
    r""" Wrapper for `pdf_mark_list_free()`."""
    return _mupdf.ppdf_mark_list_free(list)

def ppdf_mark_list_init(list):
    r""" Wrapper for `pdf_mark_list_init()`."""
    return _mupdf.ppdf_mark_list_init(list)

def ppdf_mark_list_pop(list):
    r""" Wrapper for `pdf_mark_list_pop()`."""
    return _mupdf.ppdf_mark_list_pop(list)

def ppdf_mark_list_push(list, obj):
    r""" Wrapper for `pdf_mark_list_push()`."""
    return _mupdf.ppdf_mark_list_push(list, obj)

def ppdf_mark_obj(obj):
    r""" Wrapper for `pdf_mark_obj()`."""
    return _mupdf.ppdf_mark_obj(obj)

def ppdf_mark_xref(doc):
    r""" Wrapper for `pdf_mark_xref()`."""
    return _mupdf.ppdf_mark_xref(doc)

def ppdf_metadata(doc):
    r""" Wrapper for `pdf_metadata()`."""
    return _mupdf.ppdf_metadata(doc)

def ppdf_name_eq(a, b):
    r""" Wrapper for `pdf_name_eq()`."""
    return _mupdf.ppdf_name_eq(a, b)

def ppdf_name_from_line_ending(end):
    r""" Wrapper for `pdf_name_from_line_ending()`."""
    return _mupdf.ppdf_name_from_line_ending(end)

def ppdf_needs_password(doc):
    r""" Wrapper for `pdf_needs_password()`."""
    return _mupdf.ppdf_needs_password(doc)

def ppdf_new_action_from_link(doc, uri):
    r""" Wrapper for `pdf_new_action_from_link()`."""
    return _mupdf.ppdf_new_action_from_link(doc, uri)

def ppdf_new_array(doc, initialcap):
    r""" Wrapper for `pdf_new_array()`."""
    return _mupdf.ppdf_new_array(doc, initialcap)

def ppdf_new_buffer_processor(buffer, ahxencode):
    r""" Wrapper for `pdf_new_buffer_processor()`."""
    return _mupdf.ppdf_new_buffer_processor(buffer, ahxencode)

def ppdf_new_cmap():
    r""" Wrapper for `pdf_new_cmap()`."""
    return _mupdf.ppdf_new_cmap()

def ppdf_new_crypt(enc, id):
    r""" Wrapper for `pdf_new_crypt()`."""
    return _mupdf.ppdf_new_crypt(enc, id)

def ppdf_new_date(doc, time):
    r""" Wrapper for `pdf_new_date()`."""
    return _mupdf.ppdf_new_date(doc, time)

def ppdf_new_destination_from_link(doc, uri):
    r""" Wrapper for `pdf_new_destination_from_link()`."""
    return _mupdf.ppdf_new_destination_from_link(doc, uri)

def ppdf_new_dict(doc, initialcap):
    r""" Wrapper for `pdf_new_dict()`."""
    return _mupdf.ppdf_new_dict(doc, initialcap)

def ppdf_new_display_list_from_annot(annot):
    r""" Wrapper for `pdf_new_display_list_from_annot()`."""
    return _mupdf.ppdf_new_display_list_from_annot(annot)

def ppdf_new_encrypt(opwd_utf8, upwd_utf8, id, permissions, algorithm):
    r""" Wrapper for `pdf_new_encrypt()`."""
    return _mupdf.ppdf_new_encrypt(opwd_utf8, upwd_utf8, id, permissions, algorithm)

def ppdf_new_filter_processor(doc, chain, old_res, new_res, struct_parents, transform, filter):
    r""" Wrapper for `pdf_new_filter_processor()`."""
    return _mupdf.ppdf_new_filter_processor(doc, chain, old_res, new_res, struct_parents, transform, filter)

def ppdf_new_font_desc():
    r""" Wrapper for `pdf_new_font_desc()`."""
    return _mupdf.ppdf_new_font_desc()

def ppdf_new_graft_map(dst):
    r""" Wrapper for `pdf_new_graft_map()`."""
    return _mupdf.ppdf_new_graft_map(dst)

def ppdf_new_identity_cmap(wmode, bytes):
    r""" Wrapper for `pdf_new_identity_cmap()`."""
    return _mupdf.ppdf_new_identity_cmap(wmode, bytes)

def ppdf_new_indirect(doc, num, gen):
    r""" Wrapper for `pdf_new_indirect()`."""
    return _mupdf.ppdf_new_indirect(doc, num, gen)

def ppdf_new_int(i):
    r""" Wrapper for `pdf_new_int()`."""
    return _mupdf.ppdf_new_int(i)

def ppdf_new_local_xref(doc):
    r""" Wrapper for `pdf_new_local_xref()`."""
    return _mupdf.ppdf_new_local_xref(doc)

def ppdf_new_matrix(doc, mtx):
    r""" Wrapper for `pdf_new_matrix()`."""
    return _mupdf.ppdf_new_matrix(doc, mtx)

def ppdf_new_name(str):
    r""" Wrapper for `pdf_new_name()`."""
    return _mupdf.ppdf_new_name(str)

def ppdf_new_outline_iterator(doc):
    r""" Wrapper for `pdf_new_outline_iterator()`."""
    return _mupdf.ppdf_new_outline_iterator(doc)

def ppdf_new_output_processor(out, ahxencode):
    r""" Wrapper for `pdf_new_output_processor()`."""
    return _mupdf.ppdf_new_output_processor(out, ahxencode)

def ppdf_new_pdf_device(doc, topctm, resources, contents):
    r""" Wrapper for `pdf_new_pdf_device()`."""
    return _mupdf.ppdf_new_pdf_device(doc, topctm, resources, contents)

def ppdf_new_pixmap_from_annot(annot, ctm, cs, seps, alpha):
    r""" Wrapper for `pdf_new_pixmap_from_annot()`."""
    return _mupdf.ppdf_new_pixmap_from_annot(annot, ctm, cs, seps, alpha)

def ppdf_new_pixmap_from_page_contents_with_separations_and_usage(page, ctm, cs, seps, alpha, usage):
    r""" Wrapper for `pdf_new_pixmap_from_page_contents_with_separations_and_usage()`."""
    return _mupdf.ppdf_new_pixmap_from_page_contents_with_separations_and_usage(page, ctm, cs, seps, alpha, usage)

def ppdf_new_pixmap_from_page_contents_with_usage(page, ctm, cs, alpha, usage):
    r""" Wrapper for `pdf_new_pixmap_from_page_contents_with_usage()`."""
    return _mupdf.ppdf_new_pixmap_from_page_contents_with_usage(page, ctm, cs, alpha, usage)

def ppdf_new_pixmap_from_page_with_separations_and_usage(page, ctm, cs, seps, alpha, usage):
    r""" Wrapper for `pdf_new_pixmap_from_page_with_separations_and_usage()`."""
    return _mupdf.ppdf_new_pixmap_from_page_with_separations_and_usage(page, ctm, cs, seps, alpha, usage)

def ppdf_new_pixmap_from_page_with_usage(page, ctm, cs, alpha, usage):
    r""" Wrapper for `pdf_new_pixmap_from_page_with_usage()`."""
    return _mupdf.ppdf_new_pixmap_from_page_with_usage(page, ctm, cs, alpha, usage)

def ppdf_new_processor(size):
    r""" Wrapper for `pdf_new_processor()`."""
    return _mupdf.ppdf_new_processor(size)

def ppdf_new_real(f):
    r""" Wrapper for `pdf_new_real()`."""
    return _mupdf.ppdf_new_real(f)

def ppdf_new_rect(doc, rect):
    r""" Wrapper for `pdf_new_rect()`."""
    return _mupdf.ppdf_new_rect(doc, rect)

def ppdf_new_run_processor(dev, ctm, usage, gstate, default_cs, cookie):
    r""" Wrapper for `pdf_new_run_processor()`."""
    return _mupdf.ppdf_new_run_processor(dev, ctm, usage, gstate, default_cs, cookie)

def ppdf_new_stext_page_from_annot(annot, options):
    r""" Wrapper for `pdf_new_stext_page_from_annot()`."""
    return _mupdf.ppdf_new_stext_page_from_annot(annot, options)

def ppdf_new_string(str, len):
    r""" Wrapper for `pdf_new_string()`."""
    return _mupdf.ppdf_new_string(str, len)

def ppdf_new_text_string(s):
    r""" Wrapper for `pdf_new_text_string()`."""
    return _mupdf.ppdf_new_text_string(s)

def ppdf_new_utf8_from_pdf_stream_obj(src):
    r""" Wrapper for `pdf_new_utf8_from_pdf_stream_obj()`."""
    return _mupdf.ppdf_new_utf8_from_pdf_stream_obj(src)

def ppdf_new_utf8_from_pdf_string(srcptr, srclen):
    r""" Wrapper for `pdf_new_utf8_from_pdf_string()`."""
    return _mupdf.ppdf_new_utf8_from_pdf_string(srcptr, srclen)

def ppdf_new_utf8_from_pdf_string_obj(src):
    r""" Wrapper for `pdf_new_utf8_from_pdf_string_obj()`."""
    return _mupdf.ppdf_new_utf8_from_pdf_string_obj(src)

def ppdf_new_xobject(doc, bbox, matrix, res, buffer):
    r""" Wrapper for `pdf_new_xobject()`."""
    return _mupdf.ppdf_new_xobject(doc, bbox, matrix, res, buffer)

def ppdf_next_annot(annot):
    r""" Wrapper for `pdf_next_annot()`."""
    return _mupdf.ppdf_next_annot(annot)

def ppdf_next_widget(previous):
    r""" Wrapper for `pdf_next_widget()`."""
    return _mupdf.ppdf_next_widget(previous)

def ppdf_obj_is_dirty(obj):
    r""" Wrapper for `pdf_obj_is_dirty()`."""
    return _mupdf.ppdf_obj_is_dirty(obj)

def ppdf_obj_is_incremental(obj):
    r""" Wrapper for `pdf_obj_is_incremental()`."""
    return _mupdf.ppdf_obj_is_incremental(obj)

def ppdf_obj_marked(obj):
    r""" Wrapper for `pdf_obj_marked()`."""
    return _mupdf.ppdf_obj_marked(obj)

def ppdf_obj_memo(obj, bit):
    r"""
     Wrapper for `pdf_obj_memo()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_obj_memo(pdf_obj *obj, int bit)` => `(int, int memo)`
    """
    return _mupdf.ppdf_obj_memo(obj, bit)

def ppdf_obj_num_is_stream(doc, num):
    r""" Wrapper for `pdf_obj_num_is_stream()`."""
    return _mupdf.ppdf_obj_num_is_stream(doc, num)

def ppdf_obj_parent_num(obj):
    r""" Wrapper for `pdf_obj_parent_num()`."""
    return _mupdf.ppdf_obj_parent_num(obj)

def ppdf_obj_refs(ref):
    r""" Wrapper for `pdf_obj_refs()`."""
    return _mupdf.ppdf_obj_refs(ref)

def ppdf_objcmp(a, b):
    r""" Wrapper for `pdf_objcmp()`."""
    return _mupdf.ppdf_objcmp(a, b)

def ppdf_objcmp_resolve(a, b):
    r""" Wrapper for `pdf_objcmp_resolve()`."""
    return _mupdf.ppdf_objcmp_resolve(a, b)

def ppdf_open_contents_stream(doc, obj):
    r""" Wrapper for `pdf_open_contents_stream()`."""
    return _mupdf.ppdf_open_contents_stream(doc, obj)

def ppdf_open_crypt(chain, crypt, num, gen):
    r""" Wrapper for `pdf_open_crypt()`."""
    return _mupdf.ppdf_open_crypt(chain, crypt, num, gen)

def ppdf_open_crypt_with_filter(chain, crypt, name, num, gen):
    r""" Wrapper for `pdf_open_crypt_with_filter()`."""
    return _mupdf.ppdf_open_crypt_with_filter(chain, crypt, name, num, gen)

def ppdf_open_document(filename):
    r""" Wrapper for `pdf_open_document()`."""
    return _mupdf.ppdf_open_document(filename)

def ppdf_open_document_with_stream(file):
    r""" Wrapper for `pdf_open_document_with_stream()`."""
    return _mupdf.ppdf_open_document_with_stream(file)

def ppdf_open_inline_stream(doc, stmobj, length, chain, params):
    r""" Wrapper for `pdf_open_inline_stream()`."""
    return _mupdf.ppdf_open_inline_stream(doc, stmobj, length, chain, params)

def ppdf_open_raw_stream(ref):
    r""" Wrapper for `pdf_open_raw_stream()`."""
    return _mupdf.ppdf_open_raw_stream(ref)

def ppdf_open_raw_stream_number(doc, num):
    r""" Wrapper for `pdf_open_raw_stream_number()`."""
    return _mupdf.ppdf_open_raw_stream_number(doc, num)

def ppdf_open_stream(ref):
    r""" Wrapper for `pdf_open_stream()`."""
    return _mupdf.ppdf_open_stream(ref)

def ppdf_open_stream_number(doc, num):
    r""" Wrapper for `pdf_open_stream_number()`."""
    return _mupdf.ppdf_open_stream_number(doc, num)

def ppdf_open_stream_with_offset(doc, num, dict, stm_ofs):
    r""" Wrapper for `pdf_open_stream_with_offset()`."""
    return _mupdf.ppdf_open_stream_with_offset(doc, num, dict, stm_ofs)

def ppdf_page_contents(page):
    r""" Wrapper for `pdf_page_contents()`."""
    return _mupdf.ppdf_page_contents(page)

def ppdf_page_event_close(page):
    r""" Wrapper for `pdf_page_event_close()`."""
    return _mupdf.ppdf_page_event_close(page)

def ppdf_page_event_open(page):
    r""" Wrapper for `pdf_page_event_open()`."""
    return _mupdf.ppdf_page_event_open(page)

def ppdf_page_from_fz_page(ptr):
    r""" Wrapper for `pdf_page_from_fz_page()`."""
    return _mupdf.ppdf_page_from_fz_page(ptr)

def ppdf_page_group(page):
    r""" Wrapper for `pdf_page_group()`."""
    return _mupdf.ppdf_page_group(page)

def ppdf_page_obj_transform(pageobj, page_mediabox, page_ctm):
    r""" Wrapper for `pdf_page_obj_transform()`."""
    return _mupdf.ppdf_page_obj_transform(pageobj, page_mediabox, page_ctm)

def ppdf_page_presentation(page, transition):
    r"""
     Wrapper for `pdf_page_presentation()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_page_presentation(pdf_page *page, fz_transition *transition)` => `(fz_transition *, float duration)`
    """
    return _mupdf.ppdf_page_presentation(page, transition)

def ppdf_page_resources(page):
    r""" Wrapper for `pdf_page_resources()`."""
    return _mupdf.ppdf_page_resources(page)

def ppdf_page_separations(page):
    r""" Wrapper for `pdf_page_separations()`."""
    return _mupdf.ppdf_page_separations(page)

def ppdf_page_transform(page, mediabox, ctm):
    r""" Wrapper for `pdf_page_transform()`."""
    return _mupdf.ppdf_page_transform(page, mediabox, ctm)

def ppdf_page_write(doc, mediabox, arg3, arg4):
    r"""
     Wrapper for `pdf_page_write()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_page_write(pdf_document *doc, fz_rect mediabox, pdf_obj **presources, fz_buffer **pcontents)` => `(fz_device *)`
    """
    return _mupdf.ppdf_page_write(doc, mediabox, arg3, arg4)

def ppdf_parse_array(doc, f, buf):
    r""" Wrapper for `pdf_parse_array()`."""
    return _mupdf.ppdf_parse_array(doc, f, buf)

def ppdf_parse_date(s):
    r""" Wrapper for `pdf_parse_date()`."""
    return _mupdf.ppdf_parse_date(s)

def ppdf_parse_default_appearance(da, color):
    r"""
     Wrapper for `pdf_parse_default_appearance()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_parse_default_appearance(const char *da, float color[4])` => `(const char *font, float size, int n)`
    """
    return _mupdf.ppdf_parse_default_appearance(da, color)

def ppdf_parse_dict(doc, f, buf):
    r""" Wrapper for `pdf_parse_dict()`."""
    return _mupdf.ppdf_parse_dict(doc, f, buf)

def ppdf_parse_ind_obj(doc, f):
    r"""
     Wrapper for `pdf_parse_ind_obj()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_parse_ind_obj(pdf_document *doc, fz_stream *f)` => `(pdf_obj *, int num, int gen, int64_t stm_ofs, int try_repair)`
    """
    return _mupdf.ppdf_parse_ind_obj(doc, f)

def ppdf_parse_journal_obj(doc, stm, arg3):
    r"""
     Wrapper for `pdf_parse_journal_obj()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_parse_journal_obj(pdf_document *doc, fz_stream *stm, fz_buffer **ostm)` => `(pdf_obj *, int onum, int newobj)`
    """
    return _mupdf.ppdf_parse_journal_obj(doc, stm, arg3)

def ppdf_parse_link_action(doc, obj, pagenum):
    r""" Wrapper for `pdf_parse_link_action()`."""
    return _mupdf.ppdf_parse_link_action(doc, obj, pagenum)

def ppdf_parse_link_dest(doc, obj):
    r""" Wrapper for `pdf_parse_link_dest()`."""
    return _mupdf.ppdf_parse_link_dest(doc, obj)

def ppdf_parse_link_uri(uri):
    r""" Wrapper for `pdf_parse_link_uri()`."""
    return _mupdf.ppdf_parse_link_uri(uri)

def ppdf_parse_stm_obj(doc, f, buf):
    r""" Wrapper for `pdf_parse_stm_obj()`."""
    return _mupdf.ppdf_parse_stm_obj(doc, f, buf)

def ppdf_parse_write_options(opts, args):
    r""" Wrapper for `pdf_parse_write_options()`."""
    return _mupdf.ppdf_parse_write_options(opts, args)

def ppdf_preview_signature_as_display_list(w, h, lang, signer, appearance_flags, graphic, reason, location):
    r""" Wrapper for `pdf_preview_signature_as_display_list()`."""
    return _mupdf.ppdf_preview_signature_as_display_list(w, h, lang, signer, appearance_flags, graphic, reason, location)

def ppdf_preview_signature_as_pixmap(w, h, lang, signer, appearance_flags, graphic, reason, location):
    r""" Wrapper for `pdf_preview_signature_as_pixmap()`."""
    return _mupdf.ppdf_preview_signature_as_pixmap(w, h, lang, signer, appearance_flags, graphic, reason, location)

def ppdf_print_crypt(out, crypt):
    r""" Wrapper for `pdf_print_crypt()`."""
    return _mupdf.ppdf_print_crypt(out, crypt)

def ppdf_print_default_appearance(buf, nbuf, font, size, n, color):
    r""" Wrapper for `pdf_print_default_appearance()`."""
    return _mupdf.ppdf_print_default_appearance(buf, nbuf, font, size, n, color)

def ppdf_print_encrypted_obj(out, obj, tight, ascii, crypt, num, gen):
    r""" Wrapper for `pdf_print_encrypted_obj()`."""
    return _mupdf.ppdf_print_encrypted_obj(out, obj, tight, ascii, crypt, num, gen)

def ppdf_print_font(out, fontdesc):
    r""" Wrapper for `pdf_print_font()`."""
    return _mupdf.ppdf_print_font(out, fontdesc)

def ppdf_print_obj(out, obj, tight, ascii):
    r""" Wrapper for `pdf_print_obj()`."""
    return _mupdf.ppdf_print_obj(out, obj, tight, ascii)

def ppdf_process_annot(proc, annot, cookie):
    r""" Wrapper for `pdf_process_annot()`."""
    return _mupdf.ppdf_process_annot(proc, annot, cookie)

def ppdf_process_contents(proc, doc, obj, res, cookie):
    r""" Wrapper for `pdf_process_contents()`."""
    return _mupdf.ppdf_process_contents(proc, doc, obj, res, cookie)

def ppdf_process_glyph(proc, doc, resources, contents):
    r""" Wrapper for `pdf_process_glyph()`."""
    return _mupdf.ppdf_process_glyph(proc, doc, resources, contents)

def ppdf_progressive_advance(doc, pagenum):
    r""" Wrapper for `pdf_progressive_advance()`."""
    return _mupdf.ppdf_progressive_advance(doc, pagenum)

def ppdf_purge_local_font_resources(doc):
    r""" Wrapper for `pdf_purge_local_font_resources()`."""
    return _mupdf.ppdf_purge_local_font_resources(doc)

def ppdf_purge_locals_from_store(doc):
    r""" Wrapper for `pdf_purge_locals_from_store()`."""
    return _mupdf.ppdf_purge_locals_from_store(doc)

def ppdf_read_journal(doc, stm):
    r""" Wrapper for `pdf_read_journal()`."""
    return _mupdf.ppdf_read_journal(doc, stm)

def ppdf_read_ocg(doc):
    r""" Wrapper for `pdf_read_ocg()`."""
    return _mupdf.ppdf_read_ocg(doc)

def ppdf_redact_page(doc, page, opts):
    r""" Wrapper for `pdf_redact_page()`."""
    return _mupdf.ppdf_redact_page(doc, page, opts)

def ppdf_redo(doc):
    r""" Wrapper for `pdf_redo()`."""
    return _mupdf.ppdf_redo(doc)

def ppdf_remove_item(drop, key):
    r""" Wrapper for `pdf_remove_item()`."""
    return _mupdf.ppdf_remove_item(drop, key)

def ppdf_repair_obj(doc, buf, arg3, arg4, arg5, arg6):
    r"""
     Wrapper for `pdf_repair_obj()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_repair_obj(pdf_document *doc, pdf_lexbuf *buf, pdf_obj **encrypt, pdf_obj **id, pdf_obj **page, pdf_obj **root)` => `(int, int64_t stmofsp, int stmlenp, int64_t tmpofs)`
    """
    return _mupdf.ppdf_repair_obj(doc, buf, arg3, arg4, arg5, arg6)

def ppdf_repair_obj_stms(doc):
    r""" Wrapper for `pdf_repair_obj_stms()`."""
    return _mupdf.ppdf_repair_obj_stms(doc)

def ppdf_repair_trailer(doc):
    r""" Wrapper for `pdf_repair_trailer()`."""
    return _mupdf.ppdf_repair_trailer(doc)

def ppdf_repair_xref(doc):
    r""" Wrapper for `pdf_repair_xref()`."""
    return _mupdf.ppdf_repair_xref(doc)

def ppdf_replace_xref(doc, entries, n):
    r""" Wrapper for `pdf_replace_xref()`."""
    return _mupdf.ppdf_replace_xref(doc, entries, n)

def ppdf_reset_form(doc, fields, exclude):
    r""" Wrapper for `pdf_reset_form()`."""
    return _mupdf.ppdf_reset_form(doc, fields, exclude)

def ppdf_resolve_indirect(ref):
    r""" Wrapper for `pdf_resolve_indirect()`."""
    return _mupdf.ppdf_resolve_indirect(ref)

def ppdf_resolve_indirect_chain(ref):
    r""" Wrapper for `pdf_resolve_indirect_chain()`."""
    return _mupdf.ppdf_resolve_indirect_chain(ref)

def ppdf_resolve_link(doc, uri):
    r"""
     Wrapper for `pdf_resolve_link()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_resolve_link(pdf_document *doc, const char *uri)` => `(int, float xp, float yp)`
    """
    return _mupdf.ppdf_resolve_link(doc, uri)

def ppdf_resolve_link_dest(doc, uri):
    r""" Wrapper for `pdf_resolve_link_dest()`."""
    return _mupdf.ppdf_resolve_link_dest(doc, uri)

def ppdf_run_annot(annot, dev, ctm, cookie):
    r""" Wrapper for `pdf_run_annot()`."""
    return _mupdf.ppdf_run_annot(annot, dev, ctm, cookie)

def ppdf_run_glyph(doc, resources, contents, dev, ctm, gstate, default_cs):
    r""" Wrapper for `pdf_run_glyph()`."""
    return _mupdf.ppdf_run_glyph(doc, resources, contents, dev, ctm, gstate, default_cs)

def ppdf_run_page(page, dev, ctm, cookie):
    r""" Wrapper for `pdf_run_page()`."""
    return _mupdf.ppdf_run_page(page, dev, ctm, cookie)

def ppdf_run_page_annots(page, dev, ctm, cookie):
    r""" Wrapper for `pdf_run_page_annots()`."""
    return _mupdf.ppdf_run_page_annots(page, dev, ctm, cookie)

def ppdf_run_page_annots_with_usage(page, dev, ctm, usage, cookie):
    r""" Wrapper for `pdf_run_page_annots_with_usage()`."""
    return _mupdf.ppdf_run_page_annots_with_usage(page, dev, ctm, usage, cookie)

def ppdf_run_page_contents(page, dev, ctm, cookie):
    r""" Wrapper for `pdf_run_page_contents()`."""
    return _mupdf.ppdf_run_page_contents(page, dev, ctm, cookie)

def ppdf_run_page_contents_with_usage(page, dev, ctm, usage, cookie):
    r""" Wrapper for `pdf_run_page_contents_with_usage()`."""
    return _mupdf.ppdf_run_page_contents_with_usage(page, dev, ctm, usage, cookie)

def ppdf_run_page_widgets(page, dev, ctm, cookie):
    r""" Wrapper for `pdf_run_page_widgets()`."""
    return _mupdf.ppdf_run_page_widgets(page, dev, ctm, cookie)

def ppdf_run_page_widgets_with_usage(page, dev, ctm, usage, cookie):
    r""" Wrapper for `pdf_run_page_widgets_with_usage()`."""
    return _mupdf.ppdf_run_page_widgets_with_usage(page, dev, ctm, usage, cookie)

def ppdf_run_page_with_usage(page, dev, ctm, usage, cookie):
    r""" Wrapper for `pdf_run_page_with_usage()`."""
    return _mupdf.ppdf_run_page_with_usage(page, dev, ctm, usage, cookie)

def ppdf_save_document(doc, filename, opts):
    r""" Wrapper for `pdf_save_document()`."""
    return _mupdf.ppdf_save_document(doc, filename, opts)

def ppdf_save_journal(doc, filename):
    r""" Wrapper for `pdf_save_journal()`."""
    return _mupdf.ppdf_save_journal(doc, filename)

def ppdf_save_snapshot(doc, filename):
    r""" Wrapper for `pdf_save_snapshot()`."""
    return _mupdf.ppdf_save_snapshot(doc, filename)

def ppdf_select_layer_config(doc, config_num):
    r""" Wrapper for `pdf_select_layer_config()`."""
    return _mupdf.ppdf_select_layer_config(doc, config_num)

def ppdf_select_layer_config_ui(doc, ui):
    r""" Wrapper for `pdf_select_layer_config_ui()`."""
    return _mupdf.ppdf_select_layer_config_ui(doc, ui)

def ppdf_serialise_journal(doc, out):
    r""" Wrapper for `pdf_serialise_journal()`."""
    return _mupdf.ppdf_serialise_journal(doc, out)

def ppdf_set_annot_active(annot, active):
    r""" Wrapper for `pdf_set_annot_active()`."""
    return _mupdf.ppdf_set_annot_active(annot, active)

def ppdf_set_annot_appearance(annot, appearance, state, ctm, bbox, res, contents):
    r""" Wrapper for `pdf_set_annot_appearance()`."""
    return _mupdf.ppdf_set_annot_appearance(annot, appearance, state, ctm, bbox, res, contents)

def ppdf_set_annot_appearance_from_display_list(annot, appearance, state, ctm, list):
    r""" Wrapper for `pdf_set_annot_appearance_from_display_list()`."""
    return _mupdf.ppdf_set_annot_appearance_from_display_list(annot, appearance, state, ctm, list)

def ppdf_set_annot_author(annot, author):
    r""" Wrapper for `pdf_set_annot_author()`."""
    return _mupdf.ppdf_set_annot_author(annot, author)

def ppdf_set_annot_border(annot, width):
    r""" Wrapper for `pdf_set_annot_border()`."""
    return _mupdf.ppdf_set_annot_border(annot, width)

def ppdf_set_annot_color(annot, n, color):
    r""" Wrapper for `pdf_set_annot_color()`."""
    return _mupdf.ppdf_set_annot_color(annot, n, color)

def ppdf_set_annot_contents(annot, text):
    r""" Wrapper for `pdf_set_annot_contents()`."""
    return _mupdf.ppdf_set_annot_contents(annot, text)

def ppdf_set_annot_creation_date(annot, time):
    r""" Wrapper for `pdf_set_annot_creation_date()`."""
    return _mupdf.ppdf_set_annot_creation_date(annot, time)

def ppdf_set_annot_default_appearance(annot, font, size, n, color):
    r""" Wrapper for `pdf_set_annot_default_appearance()`."""
    return _mupdf.ppdf_set_annot_default_appearance(annot, font, size, n, color)

def ppdf_set_annot_field_value(doc, widget, text, ignore_trigger_events):
    r""" Wrapper for `pdf_set_annot_field_value()`."""
    return _mupdf.ppdf_set_annot_field_value(doc, widget, text, ignore_trigger_events)

def ppdf_set_annot_flags(annot, flags):
    r""" Wrapper for `pdf_set_annot_flags()`."""
    return _mupdf.ppdf_set_annot_flags(annot, flags)

def ppdf_set_annot_hot(annot, hot):
    r""" Wrapper for `pdf_set_annot_hot()`."""
    return _mupdf.ppdf_set_annot_hot(annot, hot)

def ppdf_set_annot_icon_name(annot, name):
    r""" Wrapper for `pdf_set_annot_icon_name()`."""
    return _mupdf.ppdf_set_annot_icon_name(annot, name)

def ppdf_set_annot_ink_list(annot, n, count, v):
    r""" Wrapper for `pdf_set_annot_ink_list()`."""
    return _mupdf.ppdf_set_annot_ink_list(annot, n, count, v)

def ppdf_set_annot_interior_color(annot, n, color):
    r""" Wrapper for `pdf_set_annot_interior_color()`."""
    return _mupdf.ppdf_set_annot_interior_color(annot, n, color)

def ppdf_set_annot_is_open(annot, is_open):
    r""" Wrapper for `pdf_set_annot_is_open()`."""
    return _mupdf.ppdf_set_annot_is_open(annot, is_open)

def ppdf_set_annot_language(annot, lang):
    r""" Wrapper for `pdf_set_annot_language()`."""
    return _mupdf.ppdf_set_annot_language(annot, lang)

def ppdf_set_annot_line(annot, a, b):
    r""" Wrapper for `pdf_set_annot_line()`."""
    return _mupdf.ppdf_set_annot_line(annot, a, b)

def ppdf_set_annot_line_end_style(annot, e):
    r""" Wrapper for `pdf_set_annot_line_end_style()`."""
    return _mupdf.ppdf_set_annot_line_end_style(annot, e)

def ppdf_set_annot_line_ending_styles(annot, start_style, end_style):
    r""" Wrapper for `pdf_set_annot_line_ending_styles()`."""
    return _mupdf.ppdf_set_annot_line_ending_styles(annot, start_style, end_style)

def ppdf_set_annot_line_start_style(annot, s):
    r""" Wrapper for `pdf_set_annot_line_start_style()`."""
    return _mupdf.ppdf_set_annot_line_start_style(annot, s)

def ppdf_set_annot_modification_date(annot, time):
    r""" Wrapper for `pdf_set_annot_modification_date()`."""
    return _mupdf.ppdf_set_annot_modification_date(annot, time)

def ppdf_set_annot_opacity(annot, opacity):
    r""" Wrapper for `pdf_set_annot_opacity()`."""
    return _mupdf.ppdf_set_annot_opacity(annot, opacity)

def ppdf_set_annot_popup(annot, rect):
    r""" Wrapper for `pdf_set_annot_popup()`."""
    return _mupdf.ppdf_set_annot_popup(annot, rect)

def ppdf_set_annot_quad_points(annot, n, qv):
    r""" Wrapper for `pdf_set_annot_quad_points()`."""
    return _mupdf.ppdf_set_annot_quad_points(annot, n, qv)

def ppdf_set_annot_quadding(annot, q):
    r""" Wrapper for `pdf_set_annot_quadding()`."""
    return _mupdf.ppdf_set_annot_quadding(annot, q)

def ppdf_set_annot_rect(annot, rect):
    r""" Wrapper for `pdf_set_annot_rect()`."""
    return _mupdf.ppdf_set_annot_rect(annot, rect)

def ppdf_set_annot_resynthesised(annot):
    r""" Wrapper for `pdf_set_annot_resynthesised()`."""
    return _mupdf.ppdf_set_annot_resynthesised(annot)

def ppdf_set_annot_vertex(annot, i, p):
    r""" Wrapper for `pdf_set_annot_vertex()`."""
    return _mupdf.ppdf_set_annot_vertex(annot, i, p)

def ppdf_set_annot_vertices(annot, n, v):
    r""" Wrapper for `pdf_set_annot_vertices()`."""
    return _mupdf.ppdf_set_annot_vertices(annot, n, v)

def ppdf_set_choice_field_value(widget, value):
    r""" Wrapper for `pdf_set_choice_field_value()`."""
    return _mupdf.ppdf_set_choice_field_value(widget, value)

def ppdf_set_cmap_wmode(cmap, wmode):
    r""" Wrapper for `pdf_set_cmap_wmode()`."""
    return _mupdf.ppdf_set_cmap_wmode(cmap, wmode)

def ppdf_set_default_hmtx(font, w):
    r""" Wrapper for `pdf_set_default_hmtx()`."""
    return _mupdf.ppdf_set_default_hmtx(font, w)

def ppdf_set_default_vmtx(font, y, w):
    r""" Wrapper for `pdf_set_default_vmtx()`."""
    return _mupdf.ppdf_set_default_vmtx(font, y, w)

def ppdf_set_doc_event_callback(doc, event_cb, free_event_data_cb, data):
    r""" Wrapper for `pdf_set_doc_event_callback()`."""
    return _mupdf.ppdf_set_doc_event_callback(doc, event_cb, free_event_data_cb, data)

def ppdf_set_document_language(doc, lang):
    r""" Wrapper for `pdf_set_document_language()`."""
    return _mupdf.ppdf_set_document_language(doc, lang)

def ppdf_set_field_value(doc, field, text, ignore_trigger_events):
    r""" Wrapper for `pdf_set_field_value()`."""
    return _mupdf.ppdf_set_field_value(doc, field, text, ignore_trigger_events)

def ppdf_set_font_wmode(font, wmode):
    r""" Wrapper for `pdf_set_font_wmode()`."""
    return _mupdf.ppdf_set_font_wmode(font, wmode)

def ppdf_set_int(obj, i):
    r""" Wrapper for `pdf_set_int()`."""
    return _mupdf.ppdf_set_int(obj, i)

def ppdf_set_layer_config_as_default(doc):
    r""" Wrapper for `pdf_set_layer_config_as_default()`."""
    return _mupdf.ppdf_set_layer_config_as_default(doc)

def ppdf_set_obj_memo(obj, bit, memo):
    r""" Wrapper for `pdf_set_obj_memo()`."""
    return _mupdf.ppdf_set_obj_memo(obj, bit, memo)

def ppdf_set_obj_parent(obj, num):
    r""" Wrapper for `pdf_set_obj_parent()`."""
    return _mupdf.ppdf_set_obj_parent(obj, num)

def ppdf_set_populating_xref_trailer(doc, trailer):
    r""" Wrapper for `pdf_set_populating_xref_trailer()`."""
    return _mupdf.ppdf_set_populating_xref_trailer(doc, trailer)

def ppdf_set_str_len(obj, newlen):
    r""" Wrapper for `pdf_set_str_len()`."""
    return _mupdf.ppdf_set_str_len(obj, newlen)

def ppdf_set_text_field_value(widget, value):
    r""" Wrapper for `pdf_set_text_field_value()`."""
    return _mupdf.ppdf_set_text_field_value(widget, value)

def ppdf_set_usecmap(cmap, usecmap):
    r""" Wrapper for `pdf_set_usecmap()`."""
    return _mupdf.ppdf_set_usecmap(cmap, usecmap)

def ppdf_set_widget_editing_state(widget, editing):
    r""" Wrapper for `pdf_set_widget_editing_state()`."""
    return _mupdf.ppdf_set_widget_editing_state(widget, editing)

def ppdf_sign_signature(widget, signer, appearance_flags, graphic, reason, location):
    r""" Wrapper for `pdf_sign_signature()`."""
    return _mupdf.ppdf_sign_signature(widget, signer, appearance_flags, graphic, reason, location)

def ppdf_sign_signature_with_appearance(widget, signer, date, disp_list):
    r""" Wrapper for `pdf_sign_signature_with_appearance()`."""
    return _mupdf.ppdf_sign_signature_with_appearance(widget, signer, date, disp_list)

def ppdf_signature_appearance_signed(rect, lang, img, left_text, right_text, include_logo):
    r""" Wrapper for `pdf_signature_appearance_signed()`."""
    return _mupdf.ppdf_signature_appearance_signed(rect, lang, img, left_text, right_text, include_logo)

def ppdf_signature_appearance_unsigned(rect, lang):
    r""" Wrapper for `pdf_signature_appearance_unsigned()`."""
    return _mupdf.ppdf_signature_appearance_unsigned(rect, lang)

def ppdf_signature_byte_range(doc, signature, byte_range):
    r""" Wrapper for `pdf_signature_byte_range()`."""
    return _mupdf.ppdf_signature_byte_range(doc, signature, byte_range)

def ppdf_signature_contents(doc, signature):
    r"""
     Wrapper for `pdf_signature_contents()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_signature_contents(pdf_document *doc, pdf_obj *signature)` => `(size_t, char *contents)`
    """
    return _mupdf.ppdf_signature_contents(doc, signature)

def ppdf_signature_drop_distinguished_name(name):
    r""" Wrapper for `pdf_signature_drop_distinguished_name()`."""
    return _mupdf.ppdf_signature_drop_distinguished_name(name)

def ppdf_signature_error_description(err):
    r""" Wrapper for `pdf_signature_error_description()`."""
    return _mupdf.ppdf_signature_error_description(err)

def ppdf_signature_format_distinguished_name(name):
    r""" Wrapper for `pdf_signature_format_distinguished_name()`."""
    return _mupdf.ppdf_signature_format_distinguished_name(name)

def ppdf_signature_get_signatory(verifier, doc, signature):
    r""" Wrapper for `pdf_signature_get_signatory()`."""
    return _mupdf.ppdf_signature_get_signatory(verifier, doc, signature)

def ppdf_signature_get_widget_signatory(verifier, widget):
    r""" Wrapper for `pdf_signature_get_widget_signatory()`."""
    return _mupdf.ppdf_signature_get_widget_signatory(verifier, widget)

def ppdf_signature_hash_bytes(doc, signature):
    r""" Wrapper for `pdf_signature_hash_bytes()`."""
    return _mupdf.ppdf_signature_hash_bytes(doc, signature)

def ppdf_signature_incremental_change_since_signing(doc, signature):
    r""" Wrapper for `pdf_signature_incremental_change_since_signing()`."""
    return _mupdf.ppdf_signature_incremental_change_since_signing(doc, signature)

def ppdf_signature_info(name, dn, reason, location, date, include_labels):
    r""" Wrapper for `pdf_signature_info()`."""
    return _mupdf.ppdf_signature_info(name, dn, reason, location, date, include_labels)

def ppdf_signature_is_signed(doc, field):
    r""" Wrapper for `pdf_signature_is_signed()`."""
    return _mupdf.ppdf_signature_is_signed(doc, field)

def ppdf_signature_set_value(doc, field, signer, stime):
    r""" Wrapper for `pdf_signature_set_value()`."""
    return _mupdf.ppdf_signature_set_value(doc, field, signer, stime)

def ppdf_sort_cmap(cmap):
    r""" Wrapper for `pdf_sort_cmap()`."""
    return _mupdf.ppdf_sort_cmap(cmap)

def ppdf_sort_dict(dict):
    r""" Wrapper for `pdf_sort_dict()`."""
    return _mupdf.ppdf_sort_dict(dict)

def ppdf_specifics(doc):
    r""" Wrapper for `pdf_specifics()`."""
    return _mupdf.ppdf_specifics(doc)

def ppdf_sprint_obj(buf, cap, obj, tight, ascii):
    r"""
     Wrapper for `pdf_sprint_obj()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_sprint_obj(char *buf, size_t cap, pdf_obj *obj, int tight, int ascii)` => `(char *, size_t len)`
    """
    return _mupdf.ppdf_sprint_obj(buf, cap, obj, tight, ascii)

def ppdf_store_item(key, val, itemsize):
    r""" Wrapper for `pdf_store_item()`."""
    return _mupdf.ppdf_store_item(key, val, itemsize)

def ppdf_string_from_annot_type(type):
    r""" Wrapper for `pdf_string_from_annot_type()`."""
    return _mupdf.ppdf_string_from_annot_type(type)

def ppdf_string_from_line_ending(end):
    r""" Wrapper for `pdf_string_from_line_ending()`."""
    return _mupdf.ppdf_string_from_line_ending(end)

def ppdf_text_widget_format(tw):
    r""" Wrapper for `pdf_text_widget_format()`."""
    return _mupdf.ppdf_text_widget_format(tw)

def ppdf_text_widget_max_len(tw):
    r""" Wrapper for `pdf_text_widget_max_len()`."""
    return _mupdf.ppdf_text_widget_max_len(tw)

def ppdf_to_bool(obj):
    r""" Wrapper for `pdf_to_bool()`."""
    return _mupdf.ppdf_to_bool(obj)

def ppdf_to_date(time):
    r""" Wrapper for `pdf_to_date()`."""
    return _mupdf.ppdf_to_date(time)

def ppdf_to_gen(obj):
    r""" Wrapper for `pdf_to_gen()`."""
    return _mupdf.ppdf_to_gen(obj)

def ppdf_to_int(obj):
    r""" Wrapper for `pdf_to_int()`."""
    return _mupdf.ppdf_to_int(obj)

def ppdf_to_int64(obj):
    r""" Wrapper for `pdf_to_int64()`."""
    return _mupdf.ppdf_to_int64(obj)

def ppdf_to_matrix(array):
    r""" Wrapper for `pdf_to_matrix()`."""
    return _mupdf.ppdf_to_matrix(array)

def ppdf_to_name(obj):
    r""" Wrapper for `pdf_to_name()`."""
    return _mupdf.ppdf_to_name(obj)

def ppdf_to_num(obj):
    r""" Wrapper for `pdf_to_num()`."""
    return _mupdf.ppdf_to_num(obj)

def ppdf_to_quad(array, offset):
    r""" Wrapper for `pdf_to_quad()`."""
    return _mupdf.ppdf_to_quad(array, offset)

def ppdf_to_real(obj):
    r""" Wrapper for `pdf_to_real()`."""
    return _mupdf.ppdf_to_real(obj)

def ppdf_to_rect(array):
    r""" Wrapper for `pdf_to_rect()`."""
    return _mupdf.ppdf_to_rect(array)

def ppdf_to_str_buf(obj):
    r""" Wrapper for `pdf_to_str_buf()`."""
    return _mupdf.ppdf_to_str_buf(obj)

def ppdf_to_str_len(obj):
    r""" Wrapper for `pdf_to_str_len()`."""
    return _mupdf.ppdf_to_str_len(obj)

def ppdf_to_string(obj):
    r"""
     Wrapper for `pdf_to_string()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_to_string(pdf_obj *obj)` => `(const char *, size_t sizep)`
    """
    return _mupdf.ppdf_to_string(obj)

def ppdf_to_text_string(obj):
    r""" Wrapper for `pdf_to_text_string()`."""
    return _mupdf.ppdf_to_text_string(obj)

def ppdf_toggle_layer_config_ui(doc, ui):
    r""" Wrapper for `pdf_toggle_layer_config_ui()`."""
    return _mupdf.ppdf_toggle_layer_config_ui(doc, ui)

def ppdf_toggle_widget(widget):
    r""" Wrapper for `pdf_toggle_widget()`."""
    return _mupdf.ppdf_toggle_widget(widget)

def ppdf_tos_get_text(tos):
    r""" Wrapper for `pdf_tos_get_text()`."""
    return _mupdf.ppdf_tos_get_text(tos)

def ppdf_tos_make_trm(tos, text, fontdesc, cid, trm):
    r""" Wrapper for `pdf_tos_make_trm()`."""
    return _mupdf.ppdf_tos_make_trm(tos, text, fontdesc, cid, trm)

def ppdf_tos_move_after_char(tos):
    r""" Wrapper for `pdf_tos_move_after_char()`."""
    return _mupdf.ppdf_tos_move_after_char(tos)

def ppdf_tos_newline(tos, leading):
    r""" Wrapper for `pdf_tos_newline()`."""
    return _mupdf.ppdf_tos_newline(tos, leading)

def ppdf_tos_reset(tos, render):
    r""" Wrapper for `pdf_tos_reset()`."""
    return _mupdf.ppdf_tos_reset(tos, render)

def ppdf_tos_restore(tos, save):
    r""" Wrapper for `pdf_tos_restore()`."""
    return _mupdf.ppdf_tos_restore(tos, save)

def ppdf_tos_save(tos, save):
    r""" Wrapper for `pdf_tos_save()`."""
    return _mupdf.ppdf_tos_save(tos, save)

def ppdf_tos_set_matrix(tos, a, b, c, d, e, f):
    r""" Wrapper for `pdf_tos_set_matrix()`."""
    return _mupdf.ppdf_tos_set_matrix(tos, a, b, c, d, e, f)

def ppdf_tos_translate(tos, tx, ty):
    r""" Wrapper for `pdf_tos_translate()`."""
    return _mupdf.ppdf_tos_translate(tos, tx, ty)

def ppdf_trailer(doc):
    r""" Wrapper for `pdf_trailer()`."""
    return _mupdf.ppdf_trailer(doc)

def ppdf_undo(doc):
    r""" Wrapper for `pdf_undo()`."""
    return _mupdf.ppdf_undo(doc)

def ppdf_undoredo_state(doc):
    r"""
     Wrapper for `pdf_undoredo_state()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_undoredo_state(pdf_document *doc)` => `(int, int steps)`
    """
    return _mupdf.ppdf_undoredo_state(doc)

def ppdf_undoredo_step(doc, step):
    r""" Wrapper for `pdf_undoredo_step()`."""
    return _mupdf.ppdf_undoredo_step(doc, step)

def ppdf_unmark_obj(obj):
    r""" Wrapper for `pdf_unmark_obj()`."""
    return _mupdf.ppdf_unmark_obj(obj)

def ppdf_update_annot(annot):
    r""" Wrapper for `pdf_update_annot()`."""
    return _mupdf.ppdf_update_annot(annot)

def ppdf_update_default_colorspaces(old_cs, res):
    r""" Wrapper for `pdf_update_default_colorspaces()`."""
    return _mupdf.ppdf_update_default_colorspaces(old_cs, res)

def ppdf_update_object(doc, num, obj):
    r""" Wrapper for `pdf_update_object()`."""
    return _mupdf.ppdf_update_object(doc, num, obj)

def ppdf_update_page(page):
    r""" Wrapper for `pdf_update_page()`."""
    return _mupdf.ppdf_update_page(page)

def ppdf_update_stream(doc, ref, buf, compressed):
    r""" Wrapper for `pdf_update_stream()`."""
    return _mupdf.ppdf_update_stream(doc, ref, buf, compressed)

def ppdf_update_widget(widget):
    r""" Wrapper for `pdf_update_widget()`."""
    return _mupdf.ppdf_update_widget(widget)

def ppdf_update_xobject(doc, xobj, bbox, mat, res, buffer):
    r""" Wrapper for `pdf_update_xobject()`."""
    return _mupdf.ppdf_update_xobject(doc, xobj, bbox, mat, res, buffer)

def ppdf_validate_change_history(doc):
    r""" Wrapper for `pdf_validate_change_history()`."""
    return _mupdf.ppdf_validate_change_history(doc)

def ppdf_validate_changes(doc, version):
    r""" Wrapper for `pdf_validate_changes()`."""
    return _mupdf.ppdf_validate_changes(doc, version)

def ppdf_validate_signature(widget):
    r""" Wrapper for `pdf_validate_signature()`."""
    return _mupdf.ppdf_validate_signature(widget)

def ppdf_version(doc):
    r""" Wrapper for `pdf_version()`."""
    return _mupdf.ppdf_version(doc)

def ppdf_walk_tree(tree, kid_name, arrive, leave, arg, arg6, arg7):
    r"""
     Wrapper for `pdf_walk_tree()`.

    This function has out-params. Python/C# wrappers look like:
    	`ppdf_walk_tree(pdf_obj *tree, pdf_obj *kid_name, void (*arrive)(fz_context *, pdf_obj *, void *, pdf_obj **), void (*leave)(fz_context *, pdf_obj *, void *), void *arg, pdf_obj **names, pdf_obj **values)` => `()`
    """
    return _mupdf.ppdf_walk_tree(tree, kid_name, arrive, leave, arg, arg6, arg7)

def ppdf_was_pure_xfa(doc):
    r""" Wrapper for `pdf_was_pure_xfa()`."""
    return _mupdf.ppdf_was_pure_xfa(doc)

def ppdf_was_repaired(doc):
    r""" Wrapper for `pdf_was_repaired()`."""
    return _mupdf.ppdf_was_repaired(doc)

def ppdf_widget_is_readonly(widget):
    r""" Wrapper for `pdf_widget_is_readonly()`."""
    return _mupdf.ppdf_widget_is_readonly(widget)

def ppdf_widget_is_signed(widget):
    r""" Wrapper for `pdf_widget_is_signed()`."""
    return _mupdf.ppdf_widget_is_signed(widget)

def ppdf_widget_type(widget):
    r""" Wrapper for `pdf_widget_type()`."""
    return _mupdf.ppdf_widget_type(widget)

def ppdf_write_digest(out, byte_range, field, digest_offset, digest_length, signer):
    r""" Wrapper for `pdf_write_digest()`."""
    return _mupdf.ppdf_write_digest(out, byte_range, field, digest_offset, digest_length, signer)

def ppdf_write_document(doc, out, opts):
    r""" Wrapper for `pdf_write_document()`."""
    return _mupdf.ppdf_write_document(doc, out, opts)

def ppdf_write_journal(doc, out):
    r""" Wrapper for `pdf_write_journal()`."""
    return _mupdf.ppdf_write_journal(doc, out)

def ppdf_write_snapshot(doc, out):
    r""" Wrapper for `pdf_write_snapshot()`."""
    return _mupdf.ppdf_write_snapshot(doc, out)

def ppdf_xobject_bbox(xobj):
    r""" Wrapper for `pdf_xobject_bbox()`."""
    return _mupdf.ppdf_xobject_bbox(xobj)

def ppdf_xobject_colorspace(xobj):
    r""" Wrapper for `pdf_xobject_colorspace()`."""
    return _mupdf.ppdf_xobject_colorspace(xobj)

def ppdf_xobject_isolated(xobj):
    r""" Wrapper for `pdf_xobject_isolated()`."""
    return _mupdf.ppdf_xobject_isolated(xobj)

def ppdf_xobject_knockout(xobj):
    r""" Wrapper for `pdf_xobject_knockout()`."""
    return _mupdf.ppdf_xobject_knockout(xobj)

def ppdf_xobject_matrix(xobj):
    r""" Wrapper for `pdf_xobject_matrix()`."""
    return _mupdf.ppdf_xobject_matrix(xobj)

def ppdf_xobject_resources(xobj):
    r""" Wrapper for `pdf_xobject_resources()`."""
    return _mupdf.ppdf_xobject_resources(xobj)

def ppdf_xobject_transparency(xobj):
    r""" Wrapper for `pdf_xobject_transparency()`."""
    return _mupdf.ppdf_xobject_transparency(xobj)

def ppdf_xref_ensure_incremental_object(doc, num):
    r""" Wrapper for `pdf_xref_ensure_incremental_object()`."""
    return _mupdf.ppdf_xref_ensure_incremental_object(doc, num)

def ppdf_xref_ensure_local_object(doc, num):
    r""" Wrapper for `pdf_xref_ensure_local_object()`."""
    return _mupdf.ppdf_xref_ensure_local_object(doc, num)

def ppdf_xref_is_incremental(doc, num):
    r""" Wrapper for `pdf_xref_is_incremental()`."""
    return _mupdf.ppdf_xref_is_incremental(doc, num)

def ppdf_xref_len(doc):
    r""" Wrapper for `pdf_xref_len()`."""
    return _mupdf.ppdf_xref_len(doc)

def ppdf_xref_obj_is_unsaved_signature(doc, obj):
    r""" Wrapper for `pdf_xref_obj_is_unsaved_signature()`."""
    return _mupdf.ppdf_xref_obj_is_unsaved_signature(doc, obj)

def ppdf_xref_remove_unsaved_signature(doc, field):
    r""" Wrapper for `pdf_xref_remove_unsaved_signature()`."""
    return _mupdf.ppdf_xref_remove_unsaved_signature(doc, field)

def ppdf_xref_store_unsaved_signature(doc, field, signer):
    r""" Wrapper for `pdf_xref_store_unsaved_signature()`."""
    return _mupdf.ppdf_xref_store_unsaved_signature(doc, field, signer)

def to_string_fz_aa_context(s):
    r""" Returns string containing a fz_aa_context's members, labelled and inside (...), using operator<<."""
    return _mupdf.to_string_fz_aa_context(s)

def to_string_fz_color_params(s):
    r""" Returns string containing a fz_color_params's members, labelled and inside (...), using operator<<."""
    return _mupdf.to_string_fz_color_params(s)

def to_string_fz_cookie(s):
    r""" Returns string containing a fz_cookie's members, labelled and inside (...), using operator<<."""
    return _mupdf.to_string_fz_cookie(s)

def to_string_fz_draw_options(s):
    r""" Returns string containing a fz_draw_options's members, labelled and inside (...), using operator<<."""
    return _mupdf.to_string_fz_draw_options(s)

def to_string_fz_irect(s):
    r""" Returns string containing a fz_irect's members, labelled and inside (...), using operator<<."""
    return _mupdf.to_string_fz_irect(s)

def to_string_fz_location(s):
    r""" Returns string containing a fz_location's members, labelled and inside (...), using operator<<."""
    return _mupdf.to_string_fz_location(s)

def to_string_fz_matrix(s):
    r""" Returns string containing a fz_matrix's members, labelled and inside (...), using operator<<."""
    return _mupdf.to_string_fz_matrix(s)

def to_string_fz_md5(s):
    r""" Returns string containing a fz_md5's members, labelled and inside (...), using operator<<."""
    return _mupdf.to_string_fz_md5(s)

def to_string_fz_outline_item(s):
    r""" Returns string containing a fz_outline_item's members, labelled and inside (...), using operator<<."""
    return _mupdf.to_string_fz_outline_item(s)

def to_string_pdf_filter_options(s):
    r""" Returns string containing a pdf_filter_options's members, labelled and inside (...), using operator<<."""
    return _mupdf.to_string_pdf_filter_options(s)

def to_string_pdf_layer_config(s):
    r""" Returns string containing a pdf_layer_config's members, labelled and inside (...), using operator<<."""
    return _mupdf.to_string_pdf_layer_config(s)

def to_string_pdf_layer_config_ui(s):
    r""" Returns string containing a pdf_layer_config_ui's members, labelled and inside (...), using operator<<."""
    return _mupdf.to_string_pdf_layer_config_ui(s)

def to_string_pdf_redact_options(s):
    r""" Returns string containing a pdf_redact_options's members, labelled and inside (...), using operator<<."""
    return _mupdf.to_string_pdf_redact_options(s)

def to_string_pdf_write_options(s):
    r""" Returns string containing a pdf_write_options's members, labelled and inside (...), using operator<<."""
    return _mupdf.to_string_pdf_write_options(s)

def to_string_fz_pdfocr_options(s):
    r""" Returns string containing a fz_pdfocr_options's members, labelled and inside (...), using operator<<."""
    return _mupdf.to_string_fz_pdfocr_options(s)

def to_string_fz_point(s):
    r""" Returns string containing a fz_point's members, labelled and inside (...), using operator<<."""
    return _mupdf.to_string_fz_point(s)

def to_string_fz_pwg_options(s):
    r""" Returns string containing a fz_pwg_options's members, labelled and inside (...), using operator<<."""
    return _mupdf.to_string_fz_pwg_options(s)

def to_string_fz_quad(s):
    r""" Returns string containing a fz_quad's members, labelled and inside (...), using operator<<."""
    return _mupdf.to_string_fz_quad(s)

def to_string_fz_rect(s):
    r""" Returns string containing a fz_rect's members, labelled and inside (...), using operator<<."""
    return _mupdf.to_string_fz_rect(s)

def to_string_fz_stext_options(s):
    r""" Returns string containing a fz_stext_options's members, labelled and inside (...), using operator<<."""
    return _mupdf.to_string_fz_stext_options(s)

def to_string_fz_transition(s):
    r""" Returns string containing a fz_transition's members, labelled and inside (...), using operator<<."""
    return _mupdf.to_string_fz_transition(s)

def to_string(*args):
    r"""
    *Overload 1:*
     Returns string containing a fz_aa_context's members, labelled and inside (...), using operator<<.
    (Convenience overload).

    |

    *Overload 2:*
     Returns string containing a fz_color_params's members, labelled and inside (...), using operator<<.
    (Convenience overload).

    |

    *Overload 3:*
     Returns string containing a fz_cookie's members, labelled and inside (...), using operator<<.
    (Convenience overload).

    |

    *Overload 4:*
     Returns string containing a fz_draw_options's members, labelled and inside (...), using operator<<.
    (Convenience overload).

    |

    *Overload 5:*
     Returns string containing a fz_irect's members, labelled and inside (...), using operator<<.
    (Convenience overload).

    |

    *Overload 6:*
     Returns string containing a fz_location's members, labelled and inside (...), using operator<<.
    (Convenience overload).

    |

    *Overload 7:*
     Returns string containing a fz_matrix's members, labelled and inside (...), using operator<<.
    (Convenience overload).

    |

    *Overload 8:*
     Returns string containing a fz_md5's members, labelled and inside (...), using operator<<.
    (Convenience overload).

    |

    *Overload 9:*
     Returns string containing a fz_outline_item's members, labelled and inside (...), using operator<<.
    (Convenience overload).

    |

    *Overload 10:*
     Returns string containing a pdf_filter_options's members, labelled and inside (...), using operator<<.
    (Convenience overload).

    |

    *Overload 11:*
     Returns string containing a pdf_layer_config's members, labelled and inside (...), using operator<<.
    (Convenience overload).

    |

    *Overload 12:*
     Returns string containing a pdf_layer_config_ui's members, labelled and inside (...), using operator<<.
    (Convenience overload).

    |

    *Overload 13:*
     Returns string containing a pdf_redact_options's members, labelled and inside (...), using operator<<.
    (Convenience overload).

    |

    *Overload 14:*
     Returns string containing a pdf_write_options's members, labelled and inside (...), using operator<<.
    (Convenience overload).

    |

    *Overload 15:*
     Returns string containing a fz_pdfocr_options's members, labelled and inside (...), using operator<<.
    (Convenience overload).

    |

    *Overload 16:*
     Returns string containing a fz_point's members, labelled and inside (...), using operator<<.
    (Convenience overload).

    |

    *Overload 17:*
     Returns string containing a fz_pwg_options's members, labelled and inside (...), using operator<<.
    (Convenience overload).

    |

    *Overload 18:*
     Returns string containing a fz_quad's members, labelled and inside (...), using operator<<.
    (Convenience overload).

    |

    *Overload 19:*
     Returns string containing a fz_rect's members, labelled and inside (...), using operator<<.
    (Convenience overload).

    |

    *Overload 20:*
     Returns string containing a fz_stext_options's members, labelled and inside (...), using operator<<.
    (Convenience overload).

    |

    *Overload 21:*
     Returns string containing a fz_transition's members, labelled and inside (...), using operator<<.
    (Convenience overload).
    """
    return _mupdf.to_string(*args)
class AaContext(object):
    r""" Wrapper class for struct `fz_aa_context`."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*
        We use default copy constructor and operator=.  Constructor using raw copy of pre-existing `fz_aa_context`.

        |

        *Overload 2:*
        Constructor using raw copy of pre-existing `fz_aa_context`.
        """
        _mupdf.AaContext_swiginit(self, _mupdf.new_AaContext(*args))

    def internal(self, *args):
        r"""
        *Overload 1:*
        Access as underlying struct.

        |

        *Overload 2:*
        Access as underlying struct.
        """
        return _mupdf.AaContext_internal(self, *args)
    hscale = property(_mupdf.AaContext_hscale_get, _mupdf.AaContext_hscale_set, doc=r""" We use default destructor.""")
    vscale = property(_mupdf.AaContext_vscale_get, _mupdf.AaContext_vscale_set)
    scale = property(_mupdf.AaContext_scale_get, _mupdf.AaContext_scale_set)
    bits = property(_mupdf.AaContext_bits_get, _mupdf.AaContext_bits_set)
    text_bits = property(_mupdf.AaContext_text_bits_get, _mupdf.AaContext_text_bits_set)
    min_line_width = property(_mupdf.AaContext_min_line_width_get, _mupdf.AaContext_min_line_width_set)

    def to_string(self):
        r""" Returns string containing our members, labelled and inside (...), using operator<<."""
        return _mupdf.AaContext_to_string(self)
    __swig_destroy__ = _mupdf.delete_AaContext

# Register AaContext in _mupdf:
_mupdf.AaContext_swigregister(AaContext)
metadata_keys = cvar.metadata_keys

class Aes(object):
    r"""
    Wrapper class for struct `fz_aes`. Not copyable or assignable.
    Structure definitions are public to enable stack
    based allocation. Do not access the members directly.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def aes_crypt_cbc(self, mode, length, iv, input, output):
        r"""
        Wrapper for `fz_aes_crypt_cbc()`.
        	AES block processing. Encrypts or Decrypts (according to mode,
        	which must match what was initially set up) length bytes (which
        	must be a multiple of 16), using (and modifying) the insertion
        	vector iv, reading from input, and writing to output.

        	Never throws an exception.
        """
        return _mupdf.Aes_aes_crypt_cbc(self, mode, length, iv, input, output)

    def aes_setkey_dec(self, key, keysize):
        r"""
        Wrapper for `fz_aes_setkey_dec()`.
        	AES decryption intialisation. Fills in the supplied context
        	and prepares for decryption using the given key.

        	Returns non-zero for error (key size other than 128/192/256).

        	Never throws an exception.
        """
        return _mupdf.Aes_aes_setkey_dec(self, key, keysize)

    def aes_setkey_enc(self, key, keysize):
        r"""
        Wrapper for `fz_aes_setkey_enc()`.
        	AES encryption intialisation. Fills in the supplied context
        	and prepares for encryption using the given key.

        	Returns non-zero for error (key size other than 128/192/256).

        	Never throws an exception.
        """
        return _mupdf.Aes_aes_setkey_enc(self, key, keysize)

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `fz_aes`."""
        _mupdf.Aes_swiginit(self, _mupdf.new_Aes(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.Aes_m_internal_value(self)
    m_internal = property(_mupdf.Aes_m_internal_get, _mupdf.Aes_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_Aes

# Register Aes in _mupdf:
_mupdf.Aes_swigregister(Aes)

class AllocContext(object):
    r"""
    Wrapper class for struct `fz_alloc_context`. Not copyable or assignable.
    Allocator structure; holds callbacks and private data pointer.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `fz_alloc_context`."""
        _mupdf.AllocContext_swiginit(self, _mupdf.new_AllocContext(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.AllocContext_m_internal_value(self)
    m_internal = property(_mupdf.AllocContext_m_internal_get, _mupdf.AllocContext_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_AllocContext

# Register AllocContext in _mupdf:
_mupdf.AllocContext_swigregister(AllocContext)

class Arc4(object):
    r"""
    Wrapper class for struct `fz_arc4`. Not copyable or assignable.
    Structure definition is public to enable stack
    based allocation. Do not access the members directly.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def arc4_encrypt(self, dest, src, len):
        r"""
        Wrapper for `fz_arc4_encrypt()`.
        	RC4 block encrypt operation; encrypt src into dst (both of
        	length len) updating the RC4 state as we go.

        	Never throws an exception.
        """
        return _mupdf.Arc4_arc4_encrypt(self, dest, src, len)

    def arc4_init(self, key, len):
        r"""
        Wrapper for `fz_arc4_init()`.
        	RC4 initialization. Begins an RC4 operation, writing a new
        	context.

        	Never throws an exception.
        """
        return _mupdf.Arc4_arc4_init(self, key, len)

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `fz_arc4`."""
        _mupdf.Arc4_swiginit(self, _mupdf.new_Arc4(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.Arc4_m_internal_value(self)
    m_internal = property(_mupdf.Arc4_m_internal_get, _mupdf.Arc4_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_Arc4

# Register Arc4 in _mupdf:
_mupdf.Arc4_swigregister(Arc4)

class Archive(object):
    r"""
    Wrapper class for struct `fz_archive`. Not copyable or assignable.
    fz_archive:

    fz_archive provides methods for accessing "archive" files.
    An archive file is a conceptual entity that contains multiple
    files, which can be counted, enumerated, and read.

    Implementations of fz_archive based upon directories, zip
    and tar files are included.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def archive_format(self):
        r"""
        Wrapper for `fz_archive_format()`.
        	Return a pointer to a string describing the format of the
        	archive.

        	The lifetime of the string is unspecified (in current
        	implementations the string will persist until the archive
        	is closed, but this is not guaranteed).
        """
        return _mupdf.Archive_archive_format(self)

    def count_archive_entries(self):
        r"""
        Wrapper for `fz_count_archive_entries()`.
        	Number of entries in archive.

        	Will always return a value >= 0.

        	May throw an exception if this type of archive cannot count the
        	entries (such as a directory).
        """
        return _mupdf.Archive_count_archive_entries(self)

    def has_archive_entry(self, name):
        r"""
        Wrapper for `fz_has_archive_entry()`.
        	Check if entry by given name exists.

        	If named entry does not exist 0 will be returned, if it does
        	exist 1 is returned.

        	name: Entry name to look for, this must be an exact match to
        	the entry name in the archive.
        """
        return _mupdf.Archive_has_archive_entry(self, name)

    def list_archive_entry(self, idx):
        r"""
        Wrapper for `fz_list_archive_entry()`.
        	Get listed name of entry position idx.

        	idx: Must be a value >= 0 < return value from
        	fz_count_archive_entries. If not in range NULL will be
        	returned.

        	May throw an exception if this type of archive cannot list the
        	entries (such as a directory).
        """
        return _mupdf.Archive_list_archive_entry(self, idx)

    def open_archive_entry(self, name):
        r"""
        Wrapper for `fz_open_archive_entry()`.
        	Opens an archive entry as a stream.

        	name: Entry name to look for, this must be an exact match to
        	the entry name in the archive.
        """
        return _mupdf.Archive_open_archive_entry(self, name)

    def read_archive_entry(self, name):
        r"""
        Wrapper for `fz_read_archive_entry()`.
        	Reads all bytes in an archive entry
        	into a buffer.

        	name: Entry name to look for, this must be an exact match to
        	the entry name in the archive.
        """
        return _mupdf.Archive_read_archive_entry(self, name)

    def __init__(self, *args):
        r"""
        *Overload 1:*
        == Constructors.  Constructor using `fz_new_archive_of_size()`.

        |

        *Overload 2:*
        Constructor using raw copy of pre-existing `fz_archive`.
        """
        _mupdf.Archive_swiginit(self, _mupdf.new_Archive(*args))
    __swig_destroy__ = _mupdf.delete_Archive

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.Archive_m_internal_value(self)
    m_internal = property(_mupdf.Archive_m_internal_get, _mupdf.Archive_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register Archive in _mupdf:
_mupdf.Archive_swigregister(Archive)

class BandWriter(object):
    r"""
    Wrapper class for struct `fz_band_writer`. Not copyable or assignable.
    fz_band_writer
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    MONO = _mupdf.BandWriter_MONO
    COLOR = _mupdf.BandWriter_COLOR
    PNG = _mupdf.BandWriter_PNG
    PNM = _mupdf.BandWriter_PNM
    PAM = _mupdf.BandWriter_PAM
    PBM = _mupdf.BandWriter_PBM
    PKM = _mupdf.BandWriter_PKM
    PS = _mupdf.BandWriter_PS
    PSD = _mupdf.BandWriter_PSD

    def close_band_writer(self):
        r"""
        Wrapper for `fz_close_band_writer()`.
        	Finishes up the output and closes the band writer. After this
        	call no more headers or bands may be written.
        """
        return _mupdf.BandWriter_close_band_writer(self)

    def pdfocr_band_writer_set_progress(self, progress_fn, progress_arg):
        r"""
        Wrapper for `fz_pdfocr_band_writer_set_progress()`.
        	Set the progress callback for a pdfocr bandwriter.
        """
        return _mupdf.BandWriter_pdfocr_band_writer_set_progress(self, progress_fn, progress_arg)

    def write_band(self, stride, band_height, samples):
        r"""
        Wrapper for `fz_write_band()`.
        	Cause a band writer to write the next band
        	of data for an image.

        	stride: The byte offset from the first byte of the data
        	for a pixel to the first byte of the data for the same pixel
        	on the row below.

        	band_height: The number of lines in this band.

        	samples: Pointer to first byte of the data.
        """
        return _mupdf.BandWriter_write_band(self, stride, band_height, samples)

    def write_header(self, w, h, n, alpha, xres, yres, pagenum, cs, seps):
        r"""
        Wrapper for `fz_write_header()`.
        	Cause a band writer to write the header for
        	a banded image with the given properties/dimensions etc. This
        	also configures the bandwriter for the format of the data to be
        	passed in future calls.

        	w, h: Width and Height of the entire page.

        	n: Number of components (including spots and alphas).

        	alpha: Number of alpha components.

        	xres, yres: X and Y resolutions in dpi.

        	cs: Colorspace (NULL for bitmaps)

        	seps: Separation details (or NULL).
        """
        return _mupdf.BandWriter_write_header(self, w, h, n, alpha, xres, yres, pagenum, cs, seps)

    def __init__(self, *args):
        r"""
        *Overload 1:*
         == Constructors.  Constructor using `fz_new_band_writer_of_size()`.

        |

        *Overload 2:*
         Constructor using `fz_new_color_pcl_band_writer()`.
        		Create a new band writer, outputing color pcl.
        	 Constructor using `fz_new_mono_pcl_band_writer()`.
        		Create a new band writer, outputing monochrome pcl.


        |

        *Overload 3:*
         Constructor using `fz_new_mono_pwg_band_writer()`.
        		Create a new monochrome pwg band writer.


        |

        *Overload 4:*
         Constructor using `fz_new_pam_band_writer()`.
        		Create a band writer targetting pnm (greyscale, rgb or cmyk,
        		with or without alpha).
        	 Constructor using `fz_new_pbm_band_writer()`.
        		Create a new band writer, targetting pbm.
        	 Constructor using `fz_new_pclm_band_writer()`.
        		Create a new band writer, outputing pclm


        |

        *Overload 5:*
         Constructor using `fz_new_pdfocr_band_writer()`.
        		Create a new band writer, outputing pdfocr.

        		Ownership of output stays with the caller, the band writer
        		borrows the reference. The caller must keep the output around
        		for the duration of the band writer, and then close/drop as
        		appropriate.


        |

        *Overload 6:*
         Constructor using `fz_new_pkm_band_writer()`.
        		Create a new pkm band writer for CMYK pixmaps.
        	 Constructor using `fz_new_png_band_writer()`.
        		Create a new png band writer (greyscale or RGB, with or without
        		alpha).


        |

        *Overload 7:*
         Constructor using `fz_new_pnm_band_writer()`.
        		Create a band writer targetting pnm (greyscale or rgb, no
        		alpha).
        	 Constructor using `fz_new_ps_band_writer()`.
        		Create a postscript band writer for gray, rgb, or cmyk, no
        		alpha.
        	 Constructor using `fz_new_psd_band_writer()`.
        		Open a PSD band writer.
        	 Constructor using `fz_new_pwg_band_writer()`.
        		Create a new color pwg band writer.
        	 Calls fz_new_mono_pcl_band_writer() or fz_new_color_pcl_band_writer().

        |

        *Overload 8:*
         Calls fz_new_p*_band_writer().

        |

        *Overload 9:*
         Calls fz_new_mono_pwg_band_writer() or fz_new_pwg_band_writer().

        |

        *Overload 10:*
         Constructor using raw copy of pre-existing `fz_band_writer`.
        """
        _mupdf.BandWriter_swiginit(self, _mupdf.new_BandWriter(*args))
    __swig_destroy__ = _mupdf.delete_BandWriter

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.BandWriter_m_internal_value(self)
    m_internal = property(_mupdf.BandWriter_m_internal_get, _mupdf.BandWriter_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register BandWriter in _mupdf:
_mupdf.BandWriter_swigregister(BandWriter)

class Bitmap(object):
    r"""
    Wrapper class for struct `fz_bitmap`.
    Bitmaps have 1 bit per component. Only used for creating
    halftoned versions of contone buffers, and saving out. Samples
    are stored msb first, akin to pbms.

    The internals of this struct are considered implementation
    details and subject to change. Where possible, accessor
    functions should be used in preference.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def bitmap_details(self):
        r"""
        Wrapper for `fz_bitmap_details()`.

        This method has out-params. Python/C# wrappers look like:
        	`bitmap_details()` => `(int w, int h, int n, int stride)`

        	Retrieve details of a given bitmap.

        	bitmap: The bitmap to query.

        	w: Pointer to storage to retrieve width (or NULL).

        	h: Pointer to storage to retrieve height (or NULL).

        	n: Pointer to storage to retrieve number of color components (or
        	NULL).

        	stride: Pointer to storage to retrieve bitmap stride (or NULL).
        """
        return _mupdf.Bitmap_bitmap_details(self)

    def clear_bitmap(self):
        r"""
        Wrapper for `fz_clear_bitmap()`.
        	Set the entire bitmap to 0.

        	Never throws exceptions.
        """
        return _mupdf.Bitmap_clear_bitmap(self)

    def save_bitmap_as_pbm(self, filename):
        r"""
        Wrapper for `fz_save_bitmap_as_pbm()`.
        	Save a bitmap as a pbm.
        """
        return _mupdf.Bitmap_save_bitmap_as_pbm(self, filename)

    def save_bitmap_as_pcl(self, filename, append, pcl):
        r"""
        Wrapper for `fz_save_bitmap_as_pcl()`.
        	Save a bitmap as mono PCL.
        """
        return _mupdf.Bitmap_save_bitmap_as_pcl(self, filename, append, pcl)

    def save_bitmap_as_pkm(self, filename):
        r"""
        Wrapper for `fz_save_bitmap_as_pkm()`.
        	Save a CMYK bitmap as a pkm.
        """
        return _mupdf.Bitmap_save_bitmap_as_pkm(self, filename)

    def save_bitmap_as_pwg(self, filename, append, pwg):
        r"""
        Wrapper for `fz_save_bitmap_as_pwg()`.
        	Save a bitmap as a PWG.
        """
        return _mupdf.Bitmap_save_bitmap_as_pwg(self, filename, append, pwg)

    def __init__(self, *args):
        r"""
        *Overload 1:*
         == Constructors.  Constructor using `fz_new_bitmap()`.
        		Create a new bitmap.

        		w, h: Width and Height for the bitmap

        		n: Number of color components (assumed to be a divisor of 8)

        		xres, yres: X and Y resolutions (in pixels per inch).

        		Returns pointer to created bitmap structure. The bitmap
        		data is uninitialised.


        |

        *Overload 2:*
         Constructor using `fz_new_bitmap_from_pixmap()`.
        		Make a bitmap from a pixmap and a halftone.

        		pix: The pixmap to generate from. Currently must be a single
        		color component with no alpha.

        		ht: The halftone to use. NULL implies the default halftone.

        		Returns the resultant bitmap. Throws exceptions in the case of
        		failure to allocate.


        |

        *Overload 3:*
         Constructor using `fz_new_bitmap_from_pixmap_band()`.
        		Make a bitmap from a pixmap and a
        		halftone, allowing for the position of the pixmap within an
        		overall banded rendering.

        		pix: The pixmap to generate from. Currently must be a single
        		color component with no alpha.

        		ht: The halftone to use. NULL implies the default halftone.

        		band_start: Vertical offset within the overall banded rendering
        		(in pixels)

        		Returns the resultant bitmap. Throws exceptions in the case of
        		failure to allocate.


        |

        *Overload 4:*
         Copy constructor using `fz_keep_bitmap()`.

        |

        *Overload 5:*
         Constructor using raw copy of pre-existing `fz_bitmap`.
        """
        _mupdf.Bitmap_swiginit(self, _mupdf.new_Bitmap(*args))

    def refs(self):
        return _mupdf.Bitmap_refs(self)

    def w(self):
        return _mupdf.Bitmap_w(self)

    def h(self):
        return _mupdf.Bitmap_h(self)

    def stride(self):
        return _mupdf.Bitmap_stride(self)

    def n(self):
        return _mupdf.Bitmap_n(self)

    def xres(self):
        return _mupdf.Bitmap_xres(self)

    def yres(self):
        return _mupdf.Bitmap_yres(self)

    def samples(self):
        return _mupdf.Bitmap_samples(self)
    __swig_destroy__ = _mupdf.delete_Bitmap

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.Bitmap_m_internal_value(self)
    m_internal = property(_mupdf.Bitmap_m_internal_get, _mupdf.Bitmap_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register Bitmap in _mupdf:
_mupdf.Bitmap_swigregister(Bitmap)

class Buffer(object):
    r"""
    Wrapper class for struct `fz_buffer`.
    fz_buffer is a wrapper around a dynamically allocated array of
    bytes.

    Buffers have a capacity (the number of bytes storage immediately
    available) and a current size.

    The contents of the structure are considered implementation
    details and are subject to change. Users should use the accessor
    functions in preference.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def new_buffer_from_copied_data(data, size):
        r"""
        Wrapper for `fz_new_buffer_from_copied_data()`.
        	Create a new buffer containing a copy of the passed data.
        """
        return _mupdf.Buffer_new_buffer_from_copied_data(data, size)

    def append_bits(self, value, count):
        r""" Wrapper for `fz_append_bits()`."""
        return _mupdf.Buffer_append_bits(self, value, count)

    def append_bits_pad(self):
        r""" Wrapper for `fz_append_bits_pad()`."""
        return _mupdf.Buffer_append_bits_pad(self)

    def append_buffer(self, source):
        r"""
        Wrapper for `fz_append_buffer()`.
        	Append the contents of the source buffer onto the end of the
        	destination buffer, extending automatically as required.

        	Ownership of buffers does not change.
        """
        return _mupdf.Buffer_append_buffer(self, source)

    def append_byte(self, c):
        r""" Wrapper for `fz_append_byte()`."""
        return _mupdf.Buffer_append_byte(self, c)

    def append_data(self, data, len):
        r"""
        Wrapper for `fz_append_data()`.
        	fz_append_*: Append data to a buffer.

        	The buffer will automatically grow as required.
        """
        return _mupdf.Buffer_append_data(self, data, len)

    def append_int16_be(self, x):
        r""" Wrapper for `fz_append_int16_be()`."""
        return _mupdf.Buffer_append_int16_be(self, x)

    def append_int16_le(self, x):
        r""" Wrapper for `fz_append_int16_le()`."""
        return _mupdf.Buffer_append_int16_le(self, x)

    def append_int32_be(self, x):
        r""" Wrapper for `fz_append_int32_be()`."""
        return _mupdf.Buffer_append_int32_be(self, x)

    def append_int32_le(self, x):
        r""" Wrapper for `fz_append_int32_le()`."""
        return _mupdf.Buffer_append_int32_le(self, x)

    def append_pdf_string(self, text):
        r"""
        Wrapper for `fz_append_pdf_string()`.
        	fz_append_pdf_string: Append a string with PDF syntax quotes and
        	escapes.

        	The buffer will automatically grow as required.
        """
        return _mupdf.Buffer_append_pdf_string(self, text)

    def append_rune(self, c):
        r""" Wrapper for `fz_append_rune()`."""
        return _mupdf.Buffer_append_rune(self, c)

    def append_string(self, data):
        r""" Wrapper for `fz_append_string()`."""
        return _mupdf.Buffer_append_string(self, data)

    def buffer_extract(self, OUTPUT):
        r"""
        Wrapper for `fz_buffer_extract()`.

        This method has out-params. Python/C# wrappers look like:
        	`buffer_extract()` => `(size_t, unsigned char *data)`

        	Take ownership of buffer contents.

        	Performs the same task as fz_buffer_storage, but ownership of
        	the data buffer returns with this call. The buffer is left
        	empty.

        	Note: Bad things may happen if this is called on a buffer with
        	multiple references that is being used from multiple threads.

        	data: Pointer to place to retrieve data pointer.

        	Returns length of stream.
        """
        return _mupdf.Buffer_buffer_extract(self, OUTPUT)

    def buffer_storage(self, OUTPUT):
        r"""
        Wrapper for `fz_buffer_storage()`.

        This method has out-params. Python/C# wrappers look like:
        	`buffer_storage()` => `(size_t, unsigned char *datap)`

        	Retrieve internal memory of buffer.

        	datap: Output parameter that will be pointed to the data.

        	Returns the current size of the data in bytes.
        """
        return _mupdf.Buffer_buffer_storage(self, OUTPUT)

    def clear_buffer(self):
        r"""
        Wrapper for `fz_clear_buffer()`.
        	Empties the buffer. Storage is not freed, but is held ready
        	to be reused as the buffer is refilled.

        	Never throws exceptions.
        """
        return _mupdf.Buffer_clear_buffer(self)

    def grow_buffer(self):
        r"""
        Wrapper for `fz_grow_buffer()`.
        	Make some space within a buffer (i.e. ensure that
        	capacity > size).
        """
        return _mupdf.Buffer_grow_buffer(self)

    def load_jbig2_globals(self):
        r"""
        Wrapper for `fz_load_jbig2_globals()`.
        	Create a jbig2 globals record from a buffer.

        	Immutable once created.
        """
        return _mupdf.Buffer_load_jbig2_globals(self)

    def md5_buffer(self, digest):
        r"""
        Wrapper for `fz_md5_buffer()`.
        	Create an MD5 digest from buffer contents.

        	Never throws exceptions.
        """
        return _mupdf.Buffer_md5_buffer(self, digest)

    def new_display_list_from_svg(self, base_uri, zip):
        r"""
        Wrapper for `fz_new_display_list_from_svg()`.

        This method has out-params. Python/C# wrappers look like:
        	`new_display_list_from_svg(const char *base_uri, fz_archive *zip)` => `(fz_display_list *, float w, float h)`

        	Parse an SVG document into a display-list.
        """
        return _mupdf.Buffer_new_display_list_from_svg(self, base_uri, zip)

    def new_image_from_buffer(self):
        r"""
        Wrapper for `fz_new_image_from_buffer()`.
        	Create a new image from a
        	buffer of data, inferring its type from the format
        	of the data.
        """
        return _mupdf.Buffer_new_image_from_buffer(self)

    def new_image_from_svg(self, base_uri, zip):
        r"""
        Wrapper for `fz_new_image_from_svg()`.
        	Create a scalable image from an SVG document.
        """
        return _mupdf.Buffer_new_image_from_svg(self, base_uri, zip)

    def open_buffer(self):
        r"""
        Wrapper for `fz_open_buffer()`.
        	Open a buffer as a stream.

        	buf: The buffer to open. Ownership of the buffer is NOT passed
        	in (this function takes its own reference).

        	Returns pointer to newly created stream. May throw exceptions on
        	failure to allocate.
        """
        return _mupdf.Buffer_open_buffer(self)

    def resize_buffer(self, capacity):
        r"""
        Wrapper for `fz_resize_buffer()`.
        	Ensure that a buffer has a given capacity,
        	truncating data if required.

        	capacity: The desired capacity for the buffer. If the current
        	size of the buffer contents is smaller than capacity, it is
        	truncated.
        """
        return _mupdf.Buffer_resize_buffer(self, capacity)

    def save_buffer(self, filename):
        r"""
        Wrapper for `fz_save_buffer()`.
        	Save the contents of a buffer to a file.
        """
        return _mupdf.Buffer_save_buffer(self, filename)

    def string_from_buffer(self):
        r"""
        Wrapper for `fz_string_from_buffer()`.
        	Ensure that a buffer's data ends in a
        	0 byte, and return a pointer to it.
        """
        return _mupdf.Buffer_string_from_buffer(self)

    def terminate_buffer(self):
        r"""
        Wrapper for `fz_terminate_buffer()`.
        	Zero-terminate buffer in order to use as a C string.

        	This byte is invisible and does not affect the length of the
        	buffer as returned by fz_buffer_storage. The zero byte is
        	written *after* the data, and subsequent writes will overwrite
        	the terminating byte.

        	Subsequent changes to the size of the buffer (such as by
        	fz_buffer_trim, fz_buffer_grow, fz_resize_buffer, etc) may
        	invalidate this.
        """
        return _mupdf.Buffer_terminate_buffer(self)

    def trim_buffer(self):
        r"""
        Wrapper for `fz_trim_buffer()`.
        	Trim wasted capacity from a buffer by resizing internal memory.
        """
        return _mupdf.Buffer_trim_buffer(self)

    def append_token(self, tok, lex):
        r""" Wrapper for `pdf_append_token()`."""
        return _mupdf.Buffer_append_token(self, tok, lex)

    def new_buffer_processor(self, ahxencode):
        r""" Wrapper for `pdf_new_buffer_processor()`."""
        return _mupdf.Buffer_new_buffer_processor(self, ahxencode)

    def __init__(self, *args):
        r"""
        *Overload 1:*
         == Constructors.  Constructor using `fz_new_buffer()`.

        |

        *Overload 2:*
         Constructor using `fz_new_buffer_from_base64()`.
        		Create a new buffer with data decoded from a base64 input string.


        |

        *Overload 3:*
         Constructor using `fz_new_buffer_from_data()`.
        		Create a new buffer with existing data.

        		data: Pointer to existing data.
        		size: Size of existing data.

        		Takes ownership of data. Does not make a copy. Calls fz_free on
        		the data when the buffer is deallocated. Do not use 'data' after
        		passing to this function.

        		Returns pointer to new buffer. Throws exception on allocation
        		failure.


        |

        *Overload 4:*
         Constructor using `fz_new_buffer_from_display_list()`.

        |

        *Overload 5:*
         Constructor using `fz_new_buffer_from_image_as_png()`.
        		Reencode a given image as a PNG into a buffer.

        		Ownership of the buffer is returned.


        |

        *Overload 6:*
         Constructor using `fz_new_buffer_from_page()`.

        |

        *Overload 7:*
         Constructor using `fz_new_buffer_from_page_number()`.

        |

        *Overload 8:*
         Constructor using `fz_new_buffer_from_page_with_format()`.
        		Returns an fz_buffer containing a page after conversion to specified format.

        		page: The page to convert.
        		format, options: Passed to fz_new_document_writer_with_output() internally.
        		transform, cookie: Passed to fz_run_page() internally.


        |

        *Overload 9:*
         Constructor using `fz_new_buffer_from_pixmap_as_png()`.
        		Reencode a given pixmap as a PNG into a buffer.

        		Ownership of the buffer is returned.


        |

        *Overload 10:*
         Constructor using `fz_new_buffer_from_shared_data()`.
        		Like fz_new_buffer, but does not take ownership.


        |

        *Overload 11:*
         Constructor using `fz_new_buffer_from_stext_page()`.
        		Convert structured text into plain text.


        |

        *Overload 12:*
         Constructor using `fz_read_file()`.
        		Read all the contents of a file into a buffer.


        |

        *Overload 13:*
         Copy constructor using `fz_keep_buffer()`.

        |

        *Overload 14:*
         Constructor using raw copy of pre-existing `fz_buffer`.

        |

        *Overload 15:*
         Constructor using raw copy of pre-existing `fz_buffer`.
        """
        _mupdf.Buffer_swiginit(self, _mupdf.new_Buffer(*args))
    __swig_destroy__ = _mupdf.delete_Buffer

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.Buffer_m_internal_value(self)
    m_internal = property(_mupdf.Buffer_m_internal_get, _mupdf.Buffer_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register Buffer in _mupdf:
_mupdf.Buffer_swigregister(Buffer)

def Buffer_new_buffer_from_copied_data(data, size):
    r"""
    Wrapper for `fz_new_buffer_from_copied_data()`.
    	Create a new buffer containing a copy of the passed data.
    """
    return _mupdf.Buffer_new_buffer_from_copied_data(data, size)

class ColorParams(object):
    r""" Wrapper class for struct `fz_color_params`."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*
        Equivalent to fz_default_color_params.

        |

        *Overload 2:*
        We use default copy constructor and operator=.  Constructor using raw copy of pre-existing `fz_color_params`.

        |

        *Overload 3:*
        Constructor using raw copy of pre-existing `fz_color_params`.
        """
        _mupdf.ColorParams_swiginit(self, _mupdf.new_ColorParams(*args))

    def internal(self, *args):
        r"""
        *Overload 1:*
        Access as underlying struct.

        |

        *Overload 2:*
        Access as underlying struct.
        """
        return _mupdf.ColorParams_internal(self, *args)
    ri = property(_mupdf.ColorParams_ri_get, _mupdf.ColorParams_ri_set, doc=r""" We use default destructor.""")
    bp = property(_mupdf.ColorParams_bp_get, _mupdf.ColorParams_bp_set)
    op = property(_mupdf.ColorParams_op_get, _mupdf.ColorParams_op_set)
    opm = property(_mupdf.ColorParams_opm_get, _mupdf.ColorParams_opm_set)

    def to_string(self):
        r""" Returns string containing our members, labelled and inside (...), using operator<<."""
        return _mupdf.ColorParams_to_string(self)
    __swig_destroy__ = _mupdf.delete_ColorParams

# Register ColorParams in _mupdf:
_mupdf.ColorParams_swigregister(ColorParams)

class Colorspace(object):
    r"""
    Wrapper class for struct `fz_colorspace`.
    Describes a given colorspace.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    Fixed_GRAY = _mupdf.Colorspace_Fixed_GRAY
    Fixed_RGB = _mupdf.Colorspace_Fixed_RGB
    Fixed_BGR = _mupdf.Colorspace_Fixed_BGR
    Fixed_CMYK = _mupdf.Colorspace_Fixed_CMYK
    Fixed_LAB = _mupdf.Colorspace_Fixed_LAB

    def clamp_color(self, _in):
        r"""
        Wrapper for `fz_clamp_color()`.

        This method has out-params. Python/C# wrappers look like:
        	`clamp_color(const float *in)` => float out

        	Clamp the samples in a color to the correct ranges for a
        	given colorspace.
        """
        return _mupdf.Colorspace_clamp_color(self, _in)

    def colorspace_colorant(self, n):
        r"""
        Wrapper for `fz_colorspace_colorant()`.
        	Retrieve a the name for a colorant.

        	Returns a pointer with the same lifespan as the colorspace.
        """
        return _mupdf.Colorspace_colorspace_colorant(self, n)

    def colorspace_device_n_has_cmyk(self):
        r"""
        Wrapper for `fz_colorspace_device_n_has_cmyk()`.
        	True if DeviceN color space has cyan magenta yellow or black as
        	one of its colorants.
        """
        return _mupdf.Colorspace_colorspace_device_n_has_cmyk(self)

    def colorspace_device_n_has_only_cmyk(self):
        r"""
        Wrapper for `fz_colorspace_device_n_has_only_cmyk()`.
        	True if DeviceN color space has only colorants from the CMYK set.
        """
        return _mupdf.Colorspace_colorspace_device_n_has_only_cmyk(self)

    def colorspace_is_cmyk(self):
        r""" Wrapper for `fz_colorspace_is_cmyk()`."""
        return _mupdf.Colorspace_colorspace_is_cmyk(self)

    def colorspace_is_device(self):
        r""" Wrapper for `fz_colorspace_is_device()`."""
        return _mupdf.Colorspace_colorspace_is_device(self)

    def colorspace_is_device_cmyk(self):
        r""" Wrapper for `fz_colorspace_is_device_cmyk()`."""
        return _mupdf.Colorspace_colorspace_is_device_cmyk(self)

    def colorspace_is_device_gray(self):
        r""" Wrapper for `fz_colorspace_is_device_gray()`."""
        return _mupdf.Colorspace_colorspace_is_device_gray(self)

    def colorspace_is_device_n(self):
        r""" Wrapper for `fz_colorspace_is_device_n()`."""
        return _mupdf.Colorspace_colorspace_is_device_n(self)

    def colorspace_is_gray(self):
        r"""
        Wrapper for `fz_colorspace_is_gray()`.
        	Tests for particular types of colorspaces
        """
        return _mupdf.Colorspace_colorspace_is_gray(self)

    def colorspace_is_indexed(self):
        r""" Wrapper for `fz_colorspace_is_indexed()`."""
        return _mupdf.Colorspace_colorspace_is_indexed(self)

    def colorspace_is_lab(self):
        r""" Wrapper for `fz_colorspace_is_lab()`."""
        return _mupdf.Colorspace_colorspace_is_lab(self)

    def colorspace_is_lab_icc(self):
        r""" Wrapper for `fz_colorspace_is_lab_icc()`."""
        return _mupdf.Colorspace_colorspace_is_lab_icc(self)

    def colorspace_is_rgb(self):
        r""" Wrapper for `fz_colorspace_is_rgb()`."""
        return _mupdf.Colorspace_colorspace_is_rgb(self)

    def colorspace_is_subtractive(self):
        r"""
        Wrapper for `fz_colorspace_is_subtractive()`.
        	True for CMYK, Separation and DeviceN colorspaces.
        """
        return _mupdf.Colorspace_colorspace_is_subtractive(self)

    def colorspace_n(self):
        r"""
        Wrapper for `fz_colorspace_n()`.
        	Query the number of colorants in a colorspace.
        """
        return _mupdf.Colorspace_colorspace_n(self)

    def colorspace_name(self):
        r"""
        Wrapper for `fz_colorspace_name()`.
        	Query the name of a colorspace.

        	The returned string has the same lifespan as the colorspace
        	does. Caller should not free it.
        """
        return _mupdf.Colorspace_colorspace_name(self)

    def colorspace_name_colorant(self, n, name):
        r"""
        Wrapper for `fz_colorspace_name_colorant()`.
        	Assign a name for a given colorant in a colorspace.

        	Used while initially setting up a colorspace. The string is
        	copied into local storage, so need not be retained by the
        	caller.
        """
        return _mupdf.Colorspace_colorspace_name_colorant(self, n, name)

    def colorspace_type(self):
        r"""
        Wrapper for `fz_colorspace_type()`.
        	Query the type of colorspace.
        """
        return _mupdf.Colorspace_colorspace_type(self)

    def convert_color(self, sv, ds, _is, params):
        r"""
        Wrapper for `fz_convert_color()`.

        This method has out-params. Python/C# wrappers look like:
        	`convert_color(const float *sv, fz_colorspace *ds, fz_colorspace *is, fz_color_params params)` => float dv

        	Convert color values sv from colorspace ss into colorvalues dv
        	for colorspace ds, via an optional intervening space is,
        	respecting the given color_params.
        """
        return _mupdf.Colorspace_convert_color(self, sv, ds, _is, params)

    def convert_separation_colors(self, src_color, dst_seps, dst_cs, color_params):
        r"""
        Wrapper for `fz_convert_separation_colors()`.

        This method has out-params. Python/C# wrappers look like:
        	`convert_separation_colors(const float *src_color, fz_separations *dst_seps, fz_colorspace *dst_cs, fz_color_params color_params)` => float dst_color

        	Convert a color given in terms of one colorspace,
        	to a color in terms of another colorspace/separations.
        """
        return _mupdf.Colorspace_convert_separation_colors(self, src_color, dst_seps, dst_cs, color_params)

    def is_valid_blend_colorspace(self):
        r"""
        Wrapper for `fz_is_valid_blend_colorspace()`.
        	Check to see that a colorspace is appropriate to be used as
        	a blending space (i.e. only grey, rgb or cmyk).
        """
        return _mupdf.Colorspace_is_valid_blend_colorspace(self)

    def new_indexed_colorspace(self, high, lookup):
        r"""
        Wrapper for `fz_new_indexed_colorspace()`.
        	Create an indexed colorspace.

        	The supplied lookup table is high palette entries long. Each
        	entry is n bytes long, where n is given by the number of
        	colorants in the base colorspace, one byte per colorant.

        	Ownership of lookup is passed it; it will be freed on
        	destruction, so must be heap allocated.

        	The colorspace will keep an additional reference to the base
        	colorspace that will be dropped on destruction.

        	The returned reference should be dropped when it is finished
        	with.

        	Colorspaces are immutable once created.
        """
        return _mupdf.Colorspace_new_indexed_colorspace(self, high, lookup)

    def new_pixmap(self, w, h, seps, alpha):
        r"""
        Wrapper for `fz_new_pixmap()`.
        	Create a new pixmap, with its origin at (0,0)

        	cs: The colorspace to use for the pixmap, or NULL for an alpha
        	plane/mask.

        	w: The width of the pixmap (in pixels)

        	h: The height of the pixmap (in pixels)

        	seps: Details of separations.

        	alpha: 0 for no alpha, 1 for alpha.

        	Returns a pointer to the new pixmap. Throws exception on failure
        	to allocate.
        """
        return _mupdf.Colorspace_new_pixmap(self, w, h, seps, alpha)

    def new_pixmap_with_bbox(self, bbox, seps, alpha):
        r"""
        Wrapper for `fz_new_pixmap_with_bbox()`.
        	Create a pixmap of a given size, location and pixel format.

        	The bounding box specifies the size of the created pixmap and
        	where it will be located. The colorspace determines the number
        	of components per pixel. Alpha is always present. Pixmaps are
        	reference counted, so drop references using fz_drop_pixmap.

        	colorspace: Colorspace format used for the created pixmap. The
        	pixmap will keep a reference to the colorspace.

        	bbox: Bounding box specifying location/size of created pixmap.

        	seps: Details of separations.

        	alpha: 0 for no alpha, 1 for alpha.

        	Returns a pointer to the new pixmap. Throws exception on failure
        	to allocate.
        """
        return _mupdf.Colorspace_new_pixmap_with_bbox(self, bbox, seps, alpha)

    def new_pixmap_with_bbox_and_data(self, rect, seps, alpha, samples):
        r"""
        Wrapper for `fz_new_pixmap_with_bbox_and_data()`.
        	Create a pixmap of a given size, location and pixel format,
        	using the supplied data block.

        	The bounding box specifies the size of the created pixmap and
        	where it will be located. The colorspace determines the number
        	of components per pixel. Alpha is always present. Pixmaps are
        	reference counted, so drop references using fz_drop_pixmap.

        	colorspace: Colorspace format used for the created pixmap. The
        	pixmap will keep a reference to the colorspace.

        	rect: Bounding box specifying location/size of created pixmap.

        	seps: Details of separations.

        	alpha: Number of alpha planes (0 or 1).

        	samples: The data block to keep the samples in.

        	Returns a pointer to the new pixmap. Throws exception on failure
        	to allocate.
        """
        return _mupdf.Colorspace_new_pixmap_with_bbox_and_data(self, rect, seps, alpha, samples)

    def new_pixmap_with_data(self, w, h, seps, alpha, stride, samples):
        r"""
        Wrapper for `fz_new_pixmap_with_data()`.
        	Create a new pixmap, with its origin at
        	(0,0) using the supplied data block.

        	cs: The colorspace to use for the pixmap, or NULL for an alpha
        	plane/mask.

        	w: The width of the pixmap (in pixels)

        	h: The height of the pixmap (in pixels)

        	seps: Details of separations.

        	alpha: 0 for no alpha, 1 for alpha.

        	stride: The byte offset from the pixel data in a row to the
        	pixel data in the next row.

        	samples: The data block to keep the samples in.

        	Returns a pointer to the new pixmap. Throws exception on failure to
        	allocate.
        """
        return _mupdf.Colorspace_new_pixmap_with_data(self, w, h, seps, alpha, stride, samples)

    def is_tint_colorspace(self):
        r""" Wrapper for `pdf_is_tint_colorspace()`."""
        return _mupdf.Colorspace_is_tint_colorspace(self)

    def __init__(self, *args):
        r"""
        *Overload 1:*
         == Constructors.  Constructor using `fz_new_cal_gray_colorspace()`.
        		Create a calibrated gray colorspace.

        		The returned reference should be dropped when it is finished
        		with.

        		Colorspaces are immutable once created.


        |

        *Overload 2:*
         Constructor using `fz_new_cal_rgb_colorspace()`.
        		Create a calibrated rgb colorspace.

        		The returned reference should be dropped when it is finished
        		with.

        		Colorspaces are immutable once created.


        |

        *Overload 3:*
         Constructor using `fz_new_colorspace()`.
        		Creates a new colorspace instance and returns a reference.

        		No internal checking is done that the colorspace type (e.g.
        		CMYK) matches with the flags (e.g. FZ_COLORSPACE_HAS_CMYK) or
        		colorant count (n) or name.

        		The reference should be dropped when it is finished with.

        		Colorspaces are immutable once created (with the exception of
        		setting up colorant names for separation spaces).


        |

        *Overload 4:*
         Constructor using `fz_new_icc_colorspace()`.
        		Create a colorspace from an ICC profile supplied in buf.

        		Limited checking is done to ensure that the colorspace type is
        		appropriate for the supplied ICC profile.

        		An additional reference is taken to buf, which will be dropped
        		on destruction. Ownership is NOT passed in.

        		The returned reference should be dropped when it is finished
        		with.

        		Colorspaces are immutable once created.


        |

        *Overload 5:*
         Constructor using `fz_new_indexed_colorspace()`.
        		Create an indexed colorspace.

        		The supplied lookup table is high palette entries long. Each
        		entry is n bytes long, where n is given by the number of
        		colorants in the base colorspace, one byte per colorant.

        		Ownership of lookup is passed it; it will be freed on
        		destruction, so must be heap allocated.

        		The colorspace will keep an additional reference to the base
        		colorspace that will be dropped on destruction.

        		The returned reference should be dropped when it is finished
        		with.

        		Colorspaces are immutable once created.


        |

        *Overload 6:*
         Construct using one of: fz_device_gray(), fz_device_rgb(), fz_device_bgr(), fz_device_cmyk(), fz_device_lab().

        |

        *Overload 7:*
         Sets m_internal = NULL.

        |

        *Overload 8:*
         Copy constructor using `fz_keep_colorspace()`.

        |

        *Overload 9:*
         Constructor using raw copy of pre-existing `fz_colorspace`.
        """
        _mupdf.Colorspace_swiginit(self, _mupdf.new_Colorspace(*args))
    __swig_destroy__ = _mupdf.delete_Colorspace

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.Colorspace_m_internal_value(self)
    m_internal = property(_mupdf.Colorspace_m_internal_get, _mupdf.Colorspace_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register Colorspace in _mupdf:
_mupdf.Colorspace_swigregister(Colorspace)

class ColorspaceContext(object):
    r""" Wrapper class for struct `fz_colorspace_context`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `fz_colorspace_context`."""
        _mupdf.ColorspaceContext_swiginit(self, _mupdf.new_ColorspaceContext(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.ColorspaceContext_m_internal_value(self)
    m_internal = property(_mupdf.ColorspaceContext_m_internal_get, _mupdf.ColorspaceContext_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_ColorspaceContext

# Register ColorspaceContext in _mupdf:
_mupdf.ColorspaceContext_swigregister(ColorspaceContext)

class CompressedBuffer(object):
    r"""
    Wrapper class for struct `fz_compressed_buffer`. Not copyable or assignable.
    Buffers of compressed data; typically for the source data
    for images.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def compressed_buffer_size(self):
        r"""
        Wrapper for `fz_compressed_buffer_size()`.
        	Return the storage size used for a buffer and its data.
        	Used in implementing store handling.

        	Never throws exceptions.
        """
        return _mupdf.CompressedBuffer_compressed_buffer_size(self)

    def open_compressed_buffer(self):
        r"""
        Wrapper for `fz_open_compressed_buffer()`.
        	Open a stream to read the decompressed version of a buffer.
        """
        return _mupdf.CompressedBuffer_open_compressed_buffer(self)

    def open_image_decomp_stream_from_buffer(self):
        r"""
        Wrapper for `fz_open_image_decomp_stream_from_buffer()`.

        This method has out-params. Python/C# wrappers look like:
        	`open_image_decomp_stream_from_buffer()` => `(fz_stream *, int l2factor)`

        	Open a stream to read the decompressed version of a buffer,
        	with optional log2 subsampling.

        	l2factor = NULL for no subsampling, or a pointer to an integer
        	containing the maximum log2 subsample factor acceptable (0 =
        	none, 1 = halve dimensions, 2 = quarter dimensions etc). If
        	non-NULL, then *l2factor will be updated on exit with the actual
        	log2 subsample factor achieved.
        """
        return _mupdf.CompressedBuffer_open_image_decomp_stream_from_buffer(self)

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `fz_compressed_buffer`."""
        _mupdf.CompressedBuffer_swiginit(self, _mupdf.new_CompressedBuffer(internal))
    __swig_destroy__ = _mupdf.delete_CompressedBuffer

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.CompressedBuffer_m_internal_value(self)
    m_internal = property(_mupdf.CompressedBuffer_m_internal_get, _mupdf.CompressedBuffer_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register CompressedBuffer in _mupdf:
_mupdf.CompressedBuffer_swigregister(CompressedBuffer)

class CompressedImage(object):
    r""" Wrapper class for struct `fz_compressed_image`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def set_compressed_image_buffer(self, buf):
        r""" Wrapper for `fz_set_compressed_image_buffer()`."""
        return _mupdf.CompressedImage_set_compressed_image_buffer(self, buf)

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `fz_compressed_image`."""
        _mupdf.CompressedImage_swiginit(self, _mupdf.new_CompressedImage(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.CompressedImage_m_internal_value(self)
    m_internal = property(_mupdf.CompressedImage_m_internal_get, _mupdf.CompressedImage_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_CompressedImage

# Register CompressedImage in _mupdf:
_mupdf.CompressedImage_swigregister(CompressedImage)

class CompressionParams(object):
    r"""
    Wrapper class for struct `fz_compression_params`. Not copyable or assignable.
    Compression parameters used for buffers of compressed data;
    typically for the source data for images.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `fz_compression_params`."""
        _mupdf.CompressionParams_swiginit(self, _mupdf.new_CompressionParams(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.CompressionParams_m_internal_value(self)
    m_internal = property(_mupdf.CompressionParams_m_internal_get, _mupdf.CompressionParams_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_CompressionParams

# Register CompressionParams in _mupdf:
_mupdf.CompressionParams_swigregister(CompressionParams)

class Context(object):
    r""" Wrapper class for struct `fz_context`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*
        == Constructors.  Constructor using `fz_new_context_imp()`.

        |

        *Overload 2:*
        Constructor using raw copy of pre-existing `fz_context`.
        """
        _mupdf.Context_swiginit(self, _mupdf.new_Context(*args))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.Context_m_internal_value(self)
    m_internal = property(_mupdf.Context_m_internal_get, _mupdf.Context_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_Context

# Register Context in _mupdf:
_mupdf.Context_swigregister(Context)

class Cookie(object):
    r"""
    Wrapper class for struct `fz_cookie`. Not copyable or assignable.
    Provide two-way communication between application and library.
    Intended for multi-threaded applications where one thread is
    rendering pages and another thread wants to read progress
    feedback or abort a job that takes a long time to finish. The
    communication is unsynchronized without locking.

    abort: The application should set this field to 0 before
    calling fz_run_page to render a page. At any point when the
    page is being rendered the application my set this field to 1
    which will cause the rendering to finish soon. This field is
    checked periodically when the page is rendered, but exactly
    when is not known, therefore there is no upper bound on
    exactly when the rendering will abort. If the application
    did not provide a set of locks to fz_new_context, it must also
    await the completion of fz_run_page before issuing another
    call to fz_run_page. Note that once the application has set
    this field to 1 after it called fz_run_page it may not change
    the value again.

    progress: Communicates rendering progress back to the
    application and is read only. Increments as a page is being
    rendered. The value starts out at 0 and is limited to less
    than or equal to progress_max, unless progress_max is -1.

    progress_max: Communicates the known upper bound of rendering
    back to the application and is read only. The maximum value
    that the progress field may take. If there is no known upper
    bound on how long the rendering may take this value is -1 and
    progress is not limited. Note that the value of progress_max
    may change from -1 to a positive value once an upper bound is
    known, so take this into consideration when comparing the
    value of progress to that of progress_max.

    errors: count of errors during current rendering.

    incomplete: Initially should be set to 0. Will be set to
    non-zero if a TRYLATER error is thrown during rendering.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" Sets all fields to default values."""
        _mupdf.Cookie_swiginit(self, _mupdf.new_Cookie())

    def set_abort(self):
        r""" Sets m_internal.abort to 1."""
        return _mupdf.Cookie_set_abort(self)

    def increment_errors(self, delta):
        r""" Increments m_internal.errors by <delta>."""
        return _mupdf.Cookie_increment_errors(self, delta)

    def progress(self):
        return _mupdf.Cookie_progress(self)

    def progress_max(self):
        return _mupdf.Cookie_progress_max(self)

    def errors(self):
        return _mupdf.Cookie_errors(self)

    def incomplete(self):
        return _mupdf.Cookie_incomplete(self)
    m_internal = property(_mupdf.Cookie_m_internal_get, _mupdf.Cookie_m_internal_set, doc=r""" We use default destructor.""")

    def to_string(self):
        r""" Wrapped data is held by value.  Returns string containing our members, labelled and inside (...), using operator<<."""
        return _mupdf.Cookie_to_string(self)
    __swig_destroy__ = _mupdf.delete_Cookie

# Register Cookie in _mupdf:
_mupdf.Cookie_swigregister(Cookie)

class DefaultColorspaces(object):
    r"""
    Wrapper class for struct `fz_default_colorspaces`.
    Structure to hold default colorspaces.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def clone_default_colorspaces(self):
        r"""
        Wrapper for `fz_clone_default_colorspaces()`.
        	Returns a reference to a newly cloned default colorspaces
        	structure.

        	The new clone may safely be altered without fear of race
        	conditions as the caller is the only reference holder.
        """
        return _mupdf.DefaultColorspaces_clone_default_colorspaces(self)

    def default_cmyk(self):
        r""" Wrapper for `fz_default_cmyk()`."""
        return _mupdf.DefaultColorspaces_default_cmyk(self)

    def default_gray(self):
        r"""
        Wrapper for `fz_default_gray()`.
        	Retrieve default colorspaces (typically page local).

        	If default_cs is non NULL, the default is retrieved from there,
        	otherwise the global default is retrieved.

        	These return borrowed references that should not be dropped,
        	unless they are kept first.
        """
        return _mupdf.DefaultColorspaces_default_gray(self)

    def default_output_intent(self):
        r""" Wrapper for `fz_default_output_intent()`."""
        return _mupdf.DefaultColorspaces_default_output_intent(self)

    def default_rgb(self):
        r""" Wrapper for `fz_default_rgb()`."""
        return _mupdf.DefaultColorspaces_default_rgb(self)

    def set_default_cmyk(self, cs):
        r""" Wrapper for `fz_set_default_cmyk()`."""
        return _mupdf.DefaultColorspaces_set_default_cmyk(self, cs)

    def set_default_gray(self, cs):
        r"""
        Wrapper for `fz_set_default_gray()`.
        	Set new defaults within the default colorspace structure.

        	New references are taken to the new default, and references to
        	the old defaults dropped.

        	Never throws exceptions.
        """
        return _mupdf.DefaultColorspaces_set_default_gray(self, cs)

    def set_default_output_intent(self, cs):
        r""" Wrapper for `fz_set_default_output_intent()`."""
        return _mupdf.DefaultColorspaces_set_default_output_intent(self, cs)

    def set_default_rgb(self, cs):
        r""" Wrapper for `fz_set_default_rgb()`."""
        return _mupdf.DefaultColorspaces_set_default_rgb(self, cs)

    def update_default_colorspaces(self, res):
        r""" Wrapper for `pdf_update_default_colorspaces()`."""
        return _mupdf.DefaultColorspaces_update_default_colorspaces(self, res)

    def __init__(self, *args):
        r"""
        *Overload 1:*
         == Constructors.  Constructor using `fz_new_default_colorspaces()`.
        		Create a new default colorspace structure with values inherited
        		from the context, and return a reference to it.

        		These can be overridden using fz_set_default_xxxx.

        		These should not be overridden while more than one caller has
        		the reference for fear of race conditions.

        		The caller should drop this reference once finished with it.


        |

        *Overload 2:*
         Copy constructor using `fz_keep_default_colorspaces()`.

        |

        *Overload 3:*
         Constructor using raw copy of pre-existing `fz_default_colorspaces`.
        """
        _mupdf.DefaultColorspaces_swiginit(self, _mupdf.new_DefaultColorspaces(*args))
    __swig_destroy__ = _mupdf.delete_DefaultColorspaces

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.DefaultColorspaces_m_internal_value(self)
    m_internal = property(_mupdf.DefaultColorspaces_m_internal_get, _mupdf.DefaultColorspaces_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register DefaultColorspaces in _mupdf:
_mupdf.DefaultColorspaces_swigregister(DefaultColorspaces)

class Device(object):
    r"""
    Wrapper class for struct `fz_device`.
    The different format handlers (pdf, xps etc) interpret pages to
    a device. These devices can then process the stream of calls
    they receive in various ways:
    	The trace device outputs debugging information for the calls.
    	The draw device will render them.
    	The list device stores them in a list to play back later.
    	The text device performs text extraction and searching.
    	The bbox device calculates the bounding box for the page.
    Other devices can (and will) be written in the future.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def new_xmltext_device(out):
        r"""
        Wrapper for `fz_new_xmltext_device()`.
        	Create a device to output raw information.
        """
        return _mupdf.Device_new_xmltext_device(out)

    @staticmethod
    def new_draw_device_type3(transform, dest):
        r""" Wrapper for `fz_new_draw_device_type3()`."""
        return _mupdf.Device_new_draw_device_type3(transform, dest)

    def begin_group(self, area, cs, isolated, knockout, blendmode, alpha):
        r""" Wrapper for `fz_begin_group()`."""
        return _mupdf.Device_begin_group(self, area, cs, isolated, knockout, blendmode, alpha)

    def begin_layer(self, layer_name):
        r""" Wrapper for `fz_begin_layer()`."""
        return _mupdf.Device_begin_layer(self, layer_name)

    def begin_mask(self, area, luminosity, colorspace, bc, color_params):
        r""" Wrapper for `fz_begin_mask()`."""
        return _mupdf.Device_begin_mask(self, area, luminosity, colorspace, bc, color_params)

    def begin_tile(self, area, view, xstep, ystep, ctm):
        r""" Wrapper for `fz_begin_tile()`."""
        return _mupdf.Device_begin_tile(self, area, view, xstep, ystep, ctm)

    def begin_tile_id(self, area, view, xstep, ystep, ctm, id):
        r""" Wrapper for `fz_begin_tile_id()`."""
        return _mupdf.Device_begin_tile_id(self, area, view, xstep, ystep, ctm, id)

    def clip_image_mask(self, image, ctm, scissor):
        r""" Wrapper for `fz_clip_image_mask()`."""
        return _mupdf.Device_clip_image_mask(self, image, ctm, scissor)

    def clip_path(self, path, even_odd, ctm, scissor):
        r""" Wrapper for `fz_clip_path()`."""
        return _mupdf.Device_clip_path(self, path, even_odd, ctm, scissor)

    def clip_stroke_path(self, path, stroke, ctm, scissor):
        r""" Wrapper for `fz_clip_stroke_path()`."""
        return _mupdf.Device_clip_stroke_path(self, path, stroke, ctm, scissor)

    def clip_stroke_text(self, text, stroke, ctm, scissor):
        r""" Wrapper for `fz_clip_stroke_text()`."""
        return _mupdf.Device_clip_stroke_text(self, text, stroke, ctm, scissor)

    def clip_text(self, text, ctm, scissor):
        r""" Wrapper for `fz_clip_text()`."""
        return _mupdf.Device_clip_text(self, text, ctm, scissor)

    def close_device(self):
        r"""
        Wrapper for `fz_close_device()`.
        	Signal the end of input, and flush any buffered output.
        	This is NOT called implicitly on fz_drop_device. This
        	may throw exceptions.
        """
        return _mupdf.Device_close_device(self)

    def device_current_scissor(self):
        r"""
        Wrapper for `fz_device_current_scissor()`.
        	Find current scissor region as tracked by the device.
        """
        return _mupdf.Device_device_current_scissor(self)

    def disable_device_hints(self, hints):
        r"""
        Wrapper for `fz_disable_device_hints()`.
        	Disable (clear) hint bits within the hint bitfield for a device.
        """
        return _mupdf.Device_disable_device_hints(self, hints)

    def enable_device_hints(self, hints):
        r"""
        Wrapper for `fz_enable_device_hints()`.
        	Enable (set) hint bits within the hint bitfield for a device.
        """
        return _mupdf.Device_enable_device_hints(self, hints)

    def end_group(self):
        r""" Wrapper for `fz_end_group()`."""
        return _mupdf.Device_end_group(self)

    def end_layer(self):
        r""" Wrapper for `fz_end_layer()`."""
        return _mupdf.Device_end_layer(self)

    def end_mask(self):
        r""" Wrapper for `fz_end_mask()`."""
        return _mupdf.Device_end_mask(self)

    def end_tile(self):
        r""" Wrapper for `fz_end_tile()`."""
        return _mupdf.Device_end_tile(self)

    def fill_image(self, image, ctm, alpha, color_params):
        r""" Wrapper for `fz_fill_image()`."""
        return _mupdf.Device_fill_image(self, image, ctm, alpha, color_params)

    def fill_image_mask(self, image, ctm, colorspace, color, alpha, color_params):
        r""" Wrapper for `fz_fill_image_mask()`."""
        return _mupdf.Device_fill_image_mask(self, image, ctm, colorspace, color, alpha, color_params)

    def fill_path(self, path, even_odd, ctm, colorspace, color, alpha, color_params):
        r"""
        Wrapper for `fz_fill_path()`.
        	Device calls; graphics primitives and containers.
        """
        return _mupdf.Device_fill_path(self, path, even_odd, ctm, colorspace, color, alpha, color_params)

    def fill_shade(self, shade, ctm, alpha, color_params):
        r""" Wrapper for `fz_fill_shade()`."""
        return _mupdf.Device_fill_shade(self, shade, ctm, alpha, color_params)

    def fill_text(self, text, ctm, colorspace, color, alpha, color_params):
        r""" Wrapper for `fz_fill_text()`."""
        return _mupdf.Device_fill_text(self, text, ctm, colorspace, color, alpha, color_params)

    def ignore_text(self, text, ctm):
        r""" Wrapper for `fz_ignore_text()`."""
        return _mupdf.Device_ignore_text(self, text, ctm)

    def new_ocr_device(self, ctm, mediabox, with_list, language, datadir, progress, progress_arg):
        r"""
        Wrapper for `fz_new_ocr_device()`.
        	Create a device to OCR the text on the page.

        	Renders the page internally to a bitmap that is then OCRd. Text
        	is then forwarded onto the target device.

        	target: The target device to receive the OCRd text.

        	ctm: The transform to apply to the mediabox to get the size for
        	the rendered page image. Also used to calculate the resolution
        	for the page image. In general, this will be the same as the CTM
        	that you pass to fz_run_page (or fz_run_display_list) to feed
        	this device.

        	mediabox: The mediabox (in points). Combined with the CTM to get
        	the bounds of the pixmap used internally for the rendered page
        	image.

        	with_list: If with_list is false, then all non-text operations
        	are forwarded instantly to the target device. This results in
        	the target device seeing all NON-text operations, followed by
        	all the text operations (derived from OCR).

        	If with_list is true, then all the marking operations are
        	collated into a display list which is then replayed to the
        	target device at the end.

        	language: NULL (for "eng"), or a pointer to a string to describe
        	the languages/scripts that should be used for OCR (e.g.
        	"eng,ara").

        	datadir: NULL (for ""), or a pointer to a path string otherwise
        	provided to Tesseract in the TESSDATA_PREFIX environment variable.

        	progress: NULL, or function to be called periodically to indicate
        	progress. Return 0 to continue, or 1 to cancel. progress_arg is
        	returned as the void *. The int is a value between 0 and 100 to
        	indicate progress.

        	progress_arg: A void * value to be parrotted back to the progress
        	function.
        """
        return _mupdf.Device_new_ocr_device(self, ctm, mediabox, with_list, language, datadir, progress, progress_arg)

    def pop_clip(self):
        r""" Wrapper for `fz_pop_clip()`."""
        return _mupdf.Device_pop_clip(self)

    def render_flags(self, set, clear):
        r""" Wrapper for `fz_render_flags()`."""
        return _mupdf.Device_render_flags(self, set, clear)

    def render_t3_glyph_direct(self, font, gid, trm, gstate, def_cs):
        r"""
        Wrapper for `fz_render_t3_glyph_direct()`.
        	Nasty PDF interpreter specific hernia, required to allow the
        	interpreter to replay glyphs from a type3 font directly into
        	the target device.

        	This is only used in exceptional circumstances (such as type3
        	glyphs that inherit current graphics state, or nested type3
        	glyphs).
        """
        return _mupdf.Device_render_t3_glyph_direct(self, font, gid, trm, gstate, def_cs)

    def set_default_colorspaces(self, default_cs):
        r""" Wrapper for `fz_set_default_colorspaces()`."""
        return _mupdf.Device_set_default_colorspaces(self, default_cs)

    def stroke_path(self, path, stroke, ctm, colorspace, color, alpha, color_params):
        r""" Wrapper for `fz_stroke_path()`."""
        return _mupdf.Device_stroke_path(self, path, stroke, ctm, colorspace, color, alpha, color_params)

    def stroke_text(self, text, stroke, ctm, colorspace, color, alpha, color_params):
        r""" Wrapper for `fz_stroke_text()`."""
        return _mupdf.Device_stroke_text(self, text, stroke, ctm, colorspace, color, alpha, color_params)

    def new_run_processor(self, ctm, usage, gstate, default_cs, cookie):
        r""" Wrapper for `pdf_new_run_processor()`."""
        return _mupdf.Device_new_run_processor(self, ctm, usage, gstate, default_cs, cookie)

    def __init__(self, *args):
        r"""
        *Overload 1:*
         == Constructors.  Constructor using `fz_new_bbox_device()`.
        		Create a device to compute the bounding
        		box of all marks on a page.

        		The returned bounding box will be the union of all bounding
        		boxes of all objects on a page.


        |

        *Overload 2:*
         Constructor using `fz_new_device_of_size()`.
        		Devices are created by calls to device implementations, for
        		instance: foo_new_device(). These will be implemented by calling
        		fz_new_derived_device(ctx, foo_device) where foo_device is a
        		structure "derived from" fz_device, for instance
        		typedef struct { fz_device base;  ...extras...} foo_device;


        |

        *Overload 3:*
         Constructor using `fz_new_draw_device()`.
        		Create a device to draw on a pixmap.

        		dest: Target pixmap for the draw device. See fz_new_pixmap*
        		for how to obtain a pixmap. The pixmap is not cleared by the
        		draw device, see fz_clear_pixmap* for how to clear it prior to
        		calling fz_new_draw_device. Free the device by calling
        		fz_drop_device.

        		transform: Transform from user space in points to device space
        		in pixels.


        |

        *Overload 4:*
         Constructor using `fz_new_draw_device_with_bbox()`.
        		Create a device to draw on a pixmap.

        		dest: Target pixmap for the draw device. See fz_new_pixmap*
        		for how to obtain a pixmap. The pixmap is not cleared by the
        		draw device, see fz_clear_pixmap* for how to clear it prior to
        		calling fz_new_draw_device. Free the device by calling
        		fz_drop_device.

        		transform: Transform from user space in points to device space
        		in pixels.

        		clip: Bounding box to restrict any marking operations of the
        		draw device.


        |

        *Overload 5:*
         Constructor using `fz_new_draw_device_with_bbox_proof()`.
        		Create a device to draw on a pixmap.

        		dest: Target pixmap for the draw device. See fz_new_pixmap*
        		for how to obtain a pixmap. The pixmap is not cleared by the
        		draw device, see fz_clear_pixmap* for how to clear it prior to
        		calling fz_new_draw_device. Free the device by calling
        		fz_drop_device.

        		transform: Transform from user space in points to device space
        		in pixels.

        		clip: Bounding box to restrict any marking operations of the
        		draw device.

        		proof_cs: Color space to render to prior to mapping to color
        		space defined by pixmap.


        |

        *Overload 6:*
         Constructor using `fz_new_draw_device_with_proof()`.
        		Create a device to draw on a pixmap.

        		dest: Target pixmap for the draw device. See fz_new_pixmap*
        		for how to obtain a pixmap. The pixmap is not cleared by the
        		draw device, see fz_clear_pixmap* for how to clear it prior to
        		calling fz_new_draw_device. Free the device by calling
        		fz_drop_device.

        		transform: Transform from user space in points to device space
        		in pixels.

        		proof_cs: Intermediate color space to map though when mapping to
        		color space defined by pixmap.


        |

        *Overload 7:*
         Constructor using `fz_new_list_device()`.
        		Create a rendering device for a display list.

        		When the device is rendering a page it will populate the
        		display list with drawing commands (text, images, etc.). The
        		display list can later be reused to render a page many times
        		without having to re-interpret the page from the document file
        		for each rendering. Once the device is no longer needed, free
        		it with fz_drop_device.

        		list: A display list that the list device takes a reference to.


        |

        *Overload 8:*
         Constructor using `fz_new_ocr_device()`.
        		Create a device to OCR the text on the page.

        		Renders the page internally to a bitmap that is then OCRd. Text
        		is then forwarded onto the target device.

        		target: The target device to receive the OCRd text.

        		ctm: The transform to apply to the mediabox to get the size for
        		the rendered page image. Also used to calculate the resolution
        		for the page image. In general, this will be the same as the CTM
        		that you pass to fz_run_page (or fz_run_display_list) to feed
        		this device.

        		mediabox: The mediabox (in points). Combined with the CTM to get
        		the bounds of the pixmap used internally for the rendered page
        		image.

        		with_list: If with_list is false, then all non-text operations
        		are forwarded instantly to the target device. This results in
        		the target device seeing all NON-text operations, followed by
        		all the text operations (derived from OCR).

        		If with_list is true, then all the marking operations are
        		collated into a display list which is then replayed to the
        		target device at the end.

        		language: NULL (for "eng"), or a pointer to a string to describe
        		the languages/scripts that should be used for OCR (e.g.
        		"eng,ara").

        		datadir: NULL (for ""), or a pointer to a path string otherwise
        		provided to Tesseract in the TESSDATA_PREFIX environment variable.

        		progress: NULL, or function to be called periodically to indicate
        		progress. Return 0 to continue, or 1 to cancel. progress_arg is
        		returned as the void *. The int is a value between 0 and 100 to
        		indicate progress.

        		progress_arg: A void * value to be parrotted back to the progress
        		function.


        |

        *Overload 9:*
         Constructor using `fz_new_stext_device()`.
        		Create a device to extract the text on a page.

        		Gather the text on a page into blocks and lines.

        		The reading order is taken from the order the text is drawn in
        		the source file, so may not be accurate.

        		page: The text page to which content should be added. This will
        		usually be a newly created (empty) text page, but it can be one
        		containing data already (for example when merging multiple
        		pages, or watermarking).

        		options: Options to configure the stext device.


        |

        *Overload 10:*
         Constructor using `fz_new_svg_device()`.
        		Create a device that outputs (single page) SVG files to
        		the given output stream.

        		Equivalent to fz_new_svg_device_with_id passing id = NULL.


        |

        *Overload 11:*
         Constructor using `fz_new_svg_device_with_id()`.
        		Create a device that outputs (single page) SVG files to
        		the given output stream.

        		output: The output stream to send the constructed SVG page to.

        		page_width, page_height: The page dimensions to use (in points).

        		text_format: How to emit text. One of the following values:
        			FZ_SVG_TEXT_AS_TEXT: As <text> elements with possible
        			layout errors and mismatching fonts.
        			FZ_SVG_TEXT_AS_PATH: As <path> elements with exact
        			visual appearance.

        		reuse_images: Share image resources using <symbol> definitions.

        		id: ID parameter to keep generated IDs unique across SVG files.


        |

        *Overload 12:*
         Constructor using `fz_new_test_device()`.
        		Create a device to test for features.

        		Currently only tests for the presence of non-grayscale colors.

        		is_color: Possible values returned:
        			0: Definitely greyscale
        			1: Probably color (all colors were grey, but there
        			were images or shadings in a non grey colorspace).
        			2: Definitely color

        		threshold: The difference from grayscale that will be tolerated.
        		Typical values to use are either 0 (be exact) and 0.02 (allow an
        		imperceptible amount of slop).

        		options: A set of bitfield options, from the FZ_TEST_OPT set.

        		passthrough: A device to pass all calls through to, or NULL.
        		If set, then the test device can both test and pass through to
        		an underlying device (like, say, the display list device). This
        		means that a display list can be created and at the end we'll
        		know if it's colored or not.

        		In the absence of a passthrough device, the device will throw
        		an exception to stop page interpretation when color is found.


        |

        *Overload 13:*
         Constructor using `fz_new_trace_device()`.
        		Create a device to print a debug trace of all device calls.


        |

        *Overload 14:*
         Sets m_internal = NULL.

        |

        *Overload 15:*
         Copy constructor using `fz_keep_device()`.

        |

        *Overload 16:*
         Constructor using raw copy of pre-existing `fz_device`.
        """
        _mupdf.Device_swiginit(self, _mupdf.new_Device(*args))
    __swig_destroy__ = _mupdf.delete_Device

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.Device_m_internal_value(self)
    m_internal = property(_mupdf.Device_m_internal_get, _mupdf.Device_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register Device in _mupdf:
_mupdf.Device_swigregister(Device)

def Device_new_xmltext_device(out):
    r"""
    Wrapper for `fz_new_xmltext_device()`.
    	Create a device to output raw information.
    """
    return _mupdf.Device_new_xmltext_device(out)

def Device_new_draw_device_type3(transform, dest):
    r""" Wrapper for `fz_new_draw_device_type3()`."""
    return _mupdf.Device_new_draw_device_type3(transform, dest)

class Device2(Device):
    r""" Wrapper class for struct fz_device with virtual fns for each fnptr; this is for use as a SWIG Director class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" == Constructor."""
        if self.__class__ == Device2:
            _self = None
        else:
            _self = self
        _mupdf.Device2_swiginit(self, _mupdf.new_Device2(_self, ))

    def use_virtual_close_device(self, use=True):
        r"""
        These methods set the function pointers in *m_internal
        to point to internal callbacks that call our virtual methods.
        """
        return _mupdf.Device2_use_virtual_close_device(self, use)

    def use_virtual_drop_device(self, use=True):
        return _mupdf.Device2_use_virtual_drop_device(self, use)

    def use_virtual_fill_path(self, use=True):
        return _mupdf.Device2_use_virtual_fill_path(self, use)

    def use_virtual_stroke_path(self, use=True):
        return _mupdf.Device2_use_virtual_stroke_path(self, use)

    def use_virtual_clip_path(self, use=True):
        return _mupdf.Device2_use_virtual_clip_path(self, use)

    def use_virtual_clip_stroke_path(self, use=True):
        return _mupdf.Device2_use_virtual_clip_stroke_path(self, use)

    def use_virtual_fill_text(self, use=True):
        return _mupdf.Device2_use_virtual_fill_text(self, use)

    def use_virtual_stroke_text(self, use=True):
        return _mupdf.Device2_use_virtual_stroke_text(self, use)

    def use_virtual_clip_text(self, use=True):
        return _mupdf.Device2_use_virtual_clip_text(self, use)

    def use_virtual_clip_stroke_text(self, use=True):
        return _mupdf.Device2_use_virtual_clip_stroke_text(self, use)

    def use_virtual_ignore_text(self, use=True):
        return _mupdf.Device2_use_virtual_ignore_text(self, use)

    def use_virtual_fill_shade(self, use=True):
        return _mupdf.Device2_use_virtual_fill_shade(self, use)

    def use_virtual_fill_image(self, use=True):
        return _mupdf.Device2_use_virtual_fill_image(self, use)

    def use_virtual_fill_image_mask(self, use=True):
        return _mupdf.Device2_use_virtual_fill_image_mask(self, use)

    def use_virtual_clip_image_mask(self, use=True):
        return _mupdf.Device2_use_virtual_clip_image_mask(self, use)

    def use_virtual_pop_clip(self, use=True):
        return _mupdf.Device2_use_virtual_pop_clip(self, use)

    def use_virtual_begin_mask(self, use=True):
        return _mupdf.Device2_use_virtual_begin_mask(self, use)

    def use_virtual_end_mask(self, use=True):
        return _mupdf.Device2_use_virtual_end_mask(self, use)

    def use_virtual_begin_group(self, use=True):
        return _mupdf.Device2_use_virtual_begin_group(self, use)

    def use_virtual_end_group(self, use=True):
        return _mupdf.Device2_use_virtual_end_group(self, use)

    def use_virtual_begin_tile(self, use=True):
        return _mupdf.Device2_use_virtual_begin_tile(self, use)

    def use_virtual_end_tile(self, use=True):
        return _mupdf.Device2_use_virtual_end_tile(self, use)

    def use_virtual_render_flags(self, use=True):
        return _mupdf.Device2_use_virtual_render_flags(self, use)

    def use_virtual_set_default_colorspaces(self, use=True):
        return _mupdf.Device2_use_virtual_set_default_colorspaces(self, use)

    def use_virtual_begin_layer(self, use=True):
        return _mupdf.Device2_use_virtual_begin_layer(self, use)

    def use_virtual_end_layer(self, use=True):
        return _mupdf.Device2_use_virtual_end_layer(self, use)

    def close_device(self):
        r""" Default virtual method implementations; these all throw an exception."""
        return _mupdf.Device2_close_device(self)

    def drop_device(self):
        return _mupdf.Device2_drop_device(self)

    def fill_path(self, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8):
        return _mupdf.Device2_fill_path(self, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8)

    def stroke_path(self, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8):
        return _mupdf.Device2_stroke_path(self, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8)

    def clip_path(self, arg_2, arg_3, arg_4, arg_5):
        return _mupdf.Device2_clip_path(self, arg_2, arg_3, arg_4, arg_5)

    def clip_stroke_path(self, arg_2, arg_3, arg_4, arg_5):
        return _mupdf.Device2_clip_stroke_path(self, arg_2, arg_3, arg_4, arg_5)

    def fill_text(self, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7):
        return _mupdf.Device2_fill_text(self, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7)

    def stroke_text(self, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8):
        return _mupdf.Device2_stroke_text(self, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8)

    def clip_text(self, arg_2, arg_3, arg_4):
        return _mupdf.Device2_clip_text(self, arg_2, arg_3, arg_4)

    def clip_stroke_text(self, arg_2, arg_3, arg_4, arg_5):
        return _mupdf.Device2_clip_stroke_text(self, arg_2, arg_3, arg_4, arg_5)

    def ignore_text(self, arg_2, arg_3):
        return _mupdf.Device2_ignore_text(self, arg_2, arg_3)

    def fill_shade(self, arg_2, arg_3, arg_4, arg_5):
        return _mupdf.Device2_fill_shade(self, arg_2, arg_3, arg_4, arg_5)

    def fill_image(self, arg_2, arg_3, arg_4, arg_5):
        return _mupdf.Device2_fill_image(self, arg_2, arg_3, arg_4, arg_5)

    def fill_image_mask(self, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7):
        return _mupdf.Device2_fill_image_mask(self, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7)

    def clip_image_mask(self, arg_2, arg_3, arg_4):
        return _mupdf.Device2_clip_image_mask(self, arg_2, arg_3, arg_4)

    def pop_clip(self):
        return _mupdf.Device2_pop_clip(self)

    def begin_mask(self, arg_2, arg_3, arg_4, arg_5, arg_6):
        return _mupdf.Device2_begin_mask(self, arg_2, arg_3, arg_4, arg_5, arg_6)

    def end_mask(self):
        return _mupdf.Device2_end_mask(self)

    def begin_group(self, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7):
        return _mupdf.Device2_begin_group(self, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7)

    def end_group(self):
        return _mupdf.Device2_end_group(self)

    def begin_tile(self, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7):
        return _mupdf.Device2_begin_tile(self, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7)

    def end_tile(self):
        return _mupdf.Device2_end_tile(self)

    def render_flags(self, arg_2, arg_3):
        return _mupdf.Device2_render_flags(self, arg_2, arg_3)

    def set_default_colorspaces(self, arg_2):
        return _mupdf.Device2_set_default_colorspaces(self, arg_2)

    def begin_layer(self, arg_2):
        return _mupdf.Device2_begin_layer(self, arg_2)

    def end_layer(self):
        return _mupdf.Device2_end_layer(self)
    __swig_destroy__ = _mupdf.delete_Device2
    def __disown__(self):
        self.this.disown()
        _mupdf.disown_Device2(self)
        return weakref.proxy(self)

# Register Device2 in _mupdf:
_mupdf.Device2_swigregister(Device2)

class DeviceContainerStack(object):
    r"""
    Wrapper class for struct `fz_device_container_stack`. Not copyable or assignable.
    Devices can keep track of containers (clips/masks/groups/tiles)
    as they go to save callers having to do it.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `fz_device_container_stack`."""
        _mupdf.DeviceContainerStack_swiginit(self, _mupdf.new_DeviceContainerStack(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.DeviceContainerStack_m_internal_value(self)
    m_internal = property(_mupdf.DeviceContainerStack_m_internal_get, _mupdf.DeviceContainerStack_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_DeviceContainerStack

# Register DeviceContainerStack in _mupdf:
_mupdf.DeviceContainerStack_swigregister(DeviceContainerStack)

class DisplayList(object):
    r"""
    Wrapper class for struct `fz_display_list`.
    fz_display_list is a list containing drawing commands (text,
    images, etc.). The intent is two-fold: as a caching-mechanism
    to reduce parsing of a page, and to be used as a data
    structure in multi-threading where one thread parses the page
    and another renders pages.

    Create a display list with fz_new_display_list, hand it over to
    fz_new_list_device to have it populated, and later replay the
    list (once or many times) by calling fz_run_display_list. When
    the list is no longer needed drop it with fz_drop_display_list.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def new_display_list_from_page_contents(page):
        r"""
        Wrapper for `fz_new_display_list_from_page_contents()`.
        	Create a display list from page contents (no annotations).

        	Ownership of the display list is returned to the caller.
        """
        return _mupdf.DisplayList_new_display_list_from_page_contents(page)

    def bound_display_list(self):
        r"""
        Wrapper for `fz_bound_display_list()`.
        	Return the bounding box of the page recorded in a display list.
        """
        return _mupdf.DisplayList_bound_display_list(self)

    def display_list_is_empty(self):
        r"""
        Wrapper for `fz_display_list_is_empty()`.
        	Check for a display list being empty

        	list: The list to check.

        	Returns true if empty, false otherwise.
        """
        return _mupdf.DisplayList_display_list_is_empty(self)

    def new_buffer_from_display_list(self, options):
        r""" Wrapper for `fz_new_buffer_from_display_list()`."""
        return _mupdf.DisplayList_new_buffer_from_display_list(self, options)

    def new_list_device(self):
        r"""
        Wrapper for `fz_new_list_device()`.
        	Create a rendering device for a display list.

        	When the device is rendering a page it will populate the
        	display list with drawing commands (text, images, etc.). The
        	display list can later be reused to render a page many times
        	without having to re-interpret the page from the document file
        	for each rendering. Once the device is no longer needed, free
        	it with fz_drop_device.

        	list: A display list that the list device takes a reference to.
        """
        return _mupdf.DisplayList_new_list_device(self)

    def new_pixmap_from_display_list(self, ctm, cs, alpha):
        r"""
        Wrapper for `fz_new_pixmap_from_display_list()`.
        	Render the page to a pixmap using the transform and colorspace.

        	Ownership of the pixmap is returned to the caller.
        """
        return _mupdf.DisplayList_new_pixmap_from_display_list(self, ctm, cs, alpha)

    def new_pixmap_from_display_list_with_separations(self, ctm, cs, seps, alpha):
        r"""
        Wrapper for `fz_new_pixmap_from_display_list_with_separations()`.
        	Render the page contents with control over spot colors.

        	Ownership of the pixmap is returned to the caller.
        """
        return _mupdf.DisplayList_new_pixmap_from_display_list_with_separations(self, ctm, cs, seps, alpha)

    def run_display_list(self, dev, ctm, scissor, cookie):
        r"""
        Wrapper for `fz_run_display_list()`.
        	(Re)-run a display list through a device.

        	list: A display list, created by fz_new_display_list and
        	populated with objects from a page by running fz_run_page on a
        	device obtained from fz_new_list_device.

        	ctm: Transform to apply to display list contents. May include
        	for example scaling and rotation, see fz_scale, fz_rotate and
        	fz_concat. Set to fz_identity if no transformation is desired.

        	scissor: Only the part of the contents of the display list
        	visible within this area will be considered when the list is
        	run through the device. This does not imply for tile objects
        	contained in the display list.

        	cookie: Communication mechanism between caller and library
        	running the page. Intended for multi-threaded applications,
        	while single-threaded applications set cookie to NULL. The
        	caller may abort an ongoing page run. Cookie also communicates
        	progress information back to the caller. The fields inside
        	cookie are continually updated while the page is being run.
        """
        return _mupdf.DisplayList_run_display_list(self, dev, ctm, scissor, cookie)

    def search_display_list(self, needle, hit_bbox, hit_max):
        r"""
        Wrapper for `fz_search_display_list()`.

        This method has out-params. Python/C# wrappers look like:
        	`search_display_list(const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
        """
        return _mupdf.DisplayList_search_display_list(self, needle, hit_bbox, hit_max)

    def __init__(self, *args):
        r"""
        *Overload 1:*
         == Constructors.  Constructor using `fz_new_display_list()`.
        		Create an empty display list.

        		A display list contains drawing commands (text, images, etc.).
        		Use fz_new_list_device for populating the list.

        		mediabox: Bounds of the page (in points) represented by the
        		display list.


        |

        *Overload 2:*
         Constructor using `fz_new_display_list_from_page()`.
        		Create a display list.

        		Ownership of the display list is returned to the caller.


        |

        *Overload 3:*
         Constructor using `fz_new_display_list_from_page_number()`.

        |

        *Overload 4:*
         Constructor using `fz_new_display_list_from_svg()`.
        		Parse an SVG document into a display-list.


        |

        *Overload 5:*
         Constructor using `fz_new_display_list_from_svg_xml()`.
        		Parse an SVG document into a display-list.


        |

        *Overload 6:*
         Copy constructor using `fz_keep_display_list()`.

        |

        *Overload 7:*
         Constructor using raw copy of pre-existing `fz_display_list`.
        """
        _mupdf.DisplayList_swiginit(self, _mupdf.new_DisplayList(*args))
    __swig_destroy__ = _mupdf.delete_DisplayList

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.DisplayList_m_internal_value(self)
    m_internal = property(_mupdf.DisplayList_m_internal_get, _mupdf.DisplayList_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register DisplayList in _mupdf:
_mupdf.DisplayList_swigregister(DisplayList)

def DisplayList_new_display_list_from_page_contents(page):
    r"""
    Wrapper for `fz_new_display_list_from_page_contents()`.
    	Create a display list from page contents (no annotations).

    	Ownership of the display list is returned to the caller.
    """
    return _mupdf.DisplayList_new_display_list_from_page_contents(page)

class Document(object):
    r""" Wrapper class for struct `fz_document`."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def authenticate_password(self, password):
        r"""
        Wrapper for `fz_authenticate_password()`.
        	Test if the given password can decrypt the document.

        	password: The password string to be checked. Some document
        	specifications do not specify any particular text encoding, so
        	neither do we.

        	Returns 0 for failure to authenticate, non-zero for success.

        	For PDF documents, further information can be given by examining
        	the bits in the return code.

        		Bit 0 => No password required
        		Bit 1 => User password authenticated
        		Bit 2 => Owner password authenticated
        """
        return _mupdf.Document_authenticate_password(self, password)

    def clamp_location(self, loc):
        r"""
        Wrapper for `fz_clamp_location()`.
        	Clamps a location into valid chapter/page range. (First clamps
        	the chapter into range, then the page into range).
        """
        return _mupdf.Document_clamp_location(self, loc)

    def count_chapter_pages(self, chapter):
        r"""
        Wrapper for `fz_count_chapter_pages()`.
        	Return the number of pages in a chapter.
        	May return 0.
        """
        return _mupdf.Document_count_chapter_pages(self, chapter)

    def count_chapters(self):
        r"""
        Wrapper for `fz_count_chapters()`.
        	Return the number of chapters in the document.
        	At least 1.
        """
        return _mupdf.Document_count_chapters(self)

    def count_pages(self):
        r"""
        Wrapper for `fz_count_pages()`.
        	Return the number of pages in document

        	May return 0 for documents with no pages.
        """
        return _mupdf.Document_count_pages(self)

    def document_output_intent(self):
        r"""
        Wrapper for `fz_document_output_intent()`.
        	Find the output intent colorspace if the document has defined
        	one.

        	Returns a borrowed reference that should not be dropped, unless
        	it is kept first.
        """
        return _mupdf.Document_document_output_intent(self)

    def document_supports_accelerator(self):
        r"""
        Wrapper for `fz_document_supports_accelerator()`.
        	Query if the document supports the saving of accelerator data.
        """
        return _mupdf.Document_document_supports_accelerator(self)

    def format_link_uri(self, dest):
        r"""
        Wrapper for `fz_format_link_uri()`.
        	Format an internal link to a page number, location, and possible viewing parameters,
        	suitable for use with fz_create_link.

        	Returns a newly allocated string that the caller must free.
        """
        return _mupdf.Document_format_link_uri(self, dest)

    def has_permission(self, p):
        r"""
        Wrapper for `fz_has_permission()`.
        	Check permission flags on document.
        """
        return _mupdf.Document_has_permission(self, p)

    def is_document_reflowable(self):
        r"""
        Wrapper for `fz_is_document_reflowable()`.
        	Is the document reflowable.

        	Returns 1 to indicate reflowable documents, otherwise 0.
        """
        return _mupdf.Document_is_document_reflowable(self)

    def last_page(self):
        r"""
        Wrapper for `fz_last_page()`.
        	Function to get the location for the last page in the document.
        	Using this can be far more efficient in some cases than calling
        	fz_count_pages and using the page number.
        """
        return _mupdf.Document_last_page(self)

    def layout_document(self, w, h, em):
        r"""
        Wrapper for `fz_layout_document()`.
        	Layout reflowable document types.

        	w, h: Page size in points.
        	em: Default font size in points.
        """
        return _mupdf.Document_layout_document(self, w, h, em)

    def load_chapter_page(self, chapter, page):
        r"""
        Wrapper for `fz_load_chapter_page()`.
        	Load a page.

        	After fz_load_page is it possible to retrieve the size of the
        	page using fz_bound_page, or to render the page using
        	fz_run_page_*. Free the page by calling fz_drop_page.

        	chapter: chapter number, 0 is the first chapter of the document.
        	number: page number, 0 is the first page of the chapter.
        """
        return _mupdf.Document_load_chapter_page(self, chapter, page)

    def load_outline(self):
        r"""
        Wrapper for `fz_load_outline()`.
        	Load the hierarchical document outline.

        	Should be freed by fz_drop_outline.
        """
        return _mupdf.Document_load_outline(self)

    def load_page(self, number):
        r"""
        Wrapper for `fz_load_page()`.
        	Load a given page number from a document. This may be much less
        	efficient than loading by location (chapter+page) for some
        	document types.
        """
        return _mupdf.Document_load_page(self, number)

    def location_from_page_number(self, number):
        r"""
        Wrapper for `fz_location_from_page_number()`.
        	Converts from page number to chapter+page. This may cause many
        	chapters to be laid out in order to calculate the number of
        	pages within those chapters.
        """
        return _mupdf.Document_location_from_page_number(self, number)

    def lookup_bookmark(self, mark):
        r"""
        Wrapper for `fz_lookup_bookmark()`.
        	Find a bookmark and return its page number.
        """
        return _mupdf.Document_lookup_bookmark(self, mark)

    def make_bookmark(self, loc):
        r"""
        Wrapper for `fz_make_bookmark()`.
        	Create a bookmark for the given page, which can be used to find
        	the same location after the document has been laid out with
        	different parameters.
        """
        return _mupdf.Document_make_bookmark(self, loc)

    def needs_password(self):
        r"""
        Wrapper for `fz_needs_password()`.
        	Check if a document is encrypted with a
        	non-blank password.
        """
        return _mupdf.Document_needs_password(self)

    def new_buffer_from_page_number(self, number, options):
        r""" Wrapper for `fz_new_buffer_from_page_number()`."""
        return _mupdf.Document_new_buffer_from_page_number(self, number, options)

    def new_display_list_from_page_number(self, number):
        r""" Wrapper for `fz_new_display_list_from_page_number()`."""
        return _mupdf.Document_new_display_list_from_page_number(self, number)

    def new_pixmap_from_page_number(self, number, ctm, cs, alpha):
        r""" Wrapper for `fz_new_pixmap_from_page_number()`."""
        return _mupdf.Document_new_pixmap_from_page_number(self, number, ctm, cs, alpha)

    def new_pixmap_from_page_number_with_separations(self, number, ctm, cs, seps, alpha):
        r""" Wrapper for `fz_new_pixmap_from_page_number_with_separations()`."""
        return _mupdf.Document_new_pixmap_from_page_number_with_separations(self, number, ctm, cs, seps, alpha)

    def new_xhtml_document_from_document(self, *args):
        r"""
        *Overload 1:*
         Wrapper for `fz_new_xhtml_document_from_document()`.
        		Use text extraction to convert the input document into XHTML,
        		then open the result as a new document that can be reflowed.


        |

        *Overload 2:*
         Wrapper for `fz_new_xhtml_document_from_document()`.
        		Use text extraction to convert the input document into XHTML,
        		then open the result as a new document that can be reflowed.
        """
        return _mupdf.Document_new_xhtml_document_from_document(self, *args)

    def next_page(self, loc):
        r"""
        Wrapper for `fz_next_page()`.
        	Function to get the location of the next page (allowing for the
        	end of chapters etc). If at the end of the document, returns the
        	current location.
        """
        return _mupdf.Document_next_page(self, loc)

    def open_reflowed_document(self, opts):
        r""" Wrapper for `fz_open_reflowed_document()`."""
        return _mupdf.Document_open_reflowed_document(self, opts)

    def output_accelerator(self, accel):
        r"""
        Wrapper for `fz_output_accelerator()`.
        	Output accelerator data for the document to a given output
        	stream.
        """
        return _mupdf.Document_output_accelerator(self, accel)

    def page_number_from_location(self, loc):
        r"""
        Wrapper for `fz_page_number_from_location()`.
        	Converts from chapter+page to page number. This may cause many
        	chapters to be laid out in order to calculate the number of
        	pages within those chapters.
        """
        return _mupdf.Document_page_number_from_location(self, loc)

    def previous_page(self, loc):
        r"""
        Wrapper for `fz_previous_page()`.
        	Function to get the location of the previous page (allowing for
        	the end of chapters etc). If already at the start of the
        	document, returns the current page.
        """
        return _mupdf.Document_previous_page(self, loc)

    def process_opened_pages(self, process_openend_page, state):
        r"""
        Wrapper for `fz_process_opened_pages()`.
        	Iterates over all opened pages of the document, calling the
        	provided callback for each page for processing. If the callback
        	returns non-NULL then the iteration stops and that value is returned
        	to the called of fz_process_opened_pages().

        	The state pointer provided to fz_process_opened_pages() is
        	passed on to the callback but is owned by the caller.

        	Returns the first non-NULL value returned by the callback,
        	or NULL if the callback returned NULL for all opened pages.
        """
        return _mupdf.Document_process_opened_pages(self, process_openend_page, state)

    def resolve_link(self, uri):
        r"""
        Wrapper for `fz_resolve_link()`.

        This method has out-params. Python/C# wrappers look like:
        	`resolve_link(const char *uri)` => `(fz_location, float xp, float yp)`

        	Resolve an internal link to a page number.

        	xp, yp: Pointer to store coordinate of destination on the page.

        	Returns (-1,-1) if the URI cannot be resolved.
        """
        return _mupdf.Document_resolve_link(self, uri)

    def save_accelerator(self, accel):
        r"""
        Wrapper for `fz_save_accelerator()`.
        	Save accelerator data for the document to a given file.
        """
        return _mupdf.Document_save_accelerator(self, accel)

    def search_chapter_page_number(self, chapter, page, needle, hit_bbox, hit_max):
        r"""
        Wrapper for `fz_search_chapter_page_number()`.

        This method has out-params. Python/C# wrappers look like:
        	`search_chapter_page_number(int chapter, int page, const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
        """
        return _mupdf.Document_search_chapter_page_number(self, chapter, page, needle, hit_bbox, hit_max)

    def search_page_number(self, number, needle, hit_bbox, hit_max):
        r"""
        Wrapper for `fz_search_page_number()`.

        This method has out-params. Python/C# wrappers look like:
        	`search_page_number(int number, const char *needle, fz_quad *hit_bbox, int hit_max)` => `(int, int hit_mark)`
        """
        return _mupdf.Document_search_page_number(self, number, needle, hit_bbox, hit_max)

    def set_metadata(self, key, value):
        r""" Wrapper for `fz_set_metadata()`."""
        return _mupdf.Document_set_metadata(self, key, value)

    def count_pages_imp(self, chapter):
        r""" Wrapper for `pdf_count_pages_imp()`."""
        return _mupdf.Document_count_pages_imp(self, chapter)

    def document_from_fz_document(self):
        r""" Wrapper for `pdf_document_from_fz_document()`."""
        return _mupdf.Document_document_from_fz_document(self)

    def load_page_imp(self, chapter, number):
        r""" Wrapper for `pdf_load_page_imp()`."""
        return _mupdf.Document_load_page_imp(self, chapter, number)

    def specifics(self):
        r""" Wrapper for `pdf_specifics()`."""
        return _mupdf.Document_specifics(self)

    def lookup_metadata(self, key, o_out=None):
        r"""
         Wrapper for fz_lookup_metadata() that returns a std::string and sets
        o_out to length of string plus one. If <key> is not found, returns empty
        	string with *o_out=-1. <o_out> can be NULL if caller is not interested in
        	error information.
        """
        return _mupdf.Document_lookup_metadata(self, key, o_out)

    def __init__(self, *args):
        r"""
        *Overload 1:*
         == Constructors.  Constructor using `fz_open_accelerated_document()`.
        		Open a document file and read its basic structure so pages and
        		objects can be located. MuPDF will try to repair broken
        		documents (without actually changing the file contents).

        		The returned fz_document is used when calling most other
        		document related functions.

        		filename: a path to a file as it would be given to open(2).


        |

        *Overload 2:*
         Constructor using `fz_open_accelerated_document_with_stream()`.
        		Open a document using the specified stream object rather than
        		opening a file on disk.

        		magic: a string used to detect document type; either a file name
        		or mime-type.


        |

        *Overload 3:*
         Constructor using `fz_open_document()`.
        		Open a document file and read its basic structure so pages and
        		objects can be located. MuPDF will try to repair broken
        		documents (without actually changing the file contents).

        		The returned fz_document is used when calling most other
        		document related functions.

        		filename: a path to a file as it would be given to open(2).


        |

        *Overload 4:*
         Constructor using `fz_open_document_with_stream()`.
        		Open a document using the specified stream object rather than
        		opening a file on disk.

        		magic: a string used to detect document type; either a file name
        		or mime-type.


        |

        *Overload 5:*
         Return Document for pdfdocument.m_internal.super.

        |

        *Overload 6:*
         Copy constructor using `fz_keep_document()`.

        |

        *Overload 7:*
         Constructor using raw copy of pre-existing `fz_document`.
        """
        _mupdf.Document_swiginit(self, _mupdf.new_Document(*args))
    __swig_destroy__ = _mupdf.delete_Document

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.Document_m_internal_value(self)
    m_internal = property(_mupdf.Document_m_internal_get, _mupdf.Document_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register Document in _mupdf:
_mupdf.Document_swigregister(Document)

class DocumentHandler(object):
    r""" Wrapper class for struct `fz_document_handler`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def register_document_handler(self):
        r"""
        Wrapper for `fz_register_document_handler()`.
        	Register a handler for a document type.

        	handler: The handler to register.
        """
        return _mupdf.DocumentHandler_register_document_handler(self)

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `fz_document_handler`."""
        _mupdf.DocumentHandler_swiginit(self, _mupdf.new_DocumentHandler(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.DocumentHandler_m_internal_value(self)
    m_internal = property(_mupdf.DocumentHandler_m_internal_get, _mupdf.DocumentHandler_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_DocumentHandler

# Register DocumentHandler in _mupdf:
_mupdf.DocumentHandler_swigregister(DocumentHandler)

class DocumentHandlerContext(object):
    r""" Wrapper class for struct `fz_document_handler_context`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `fz_document_handler_context`."""
        _mupdf.DocumentHandlerContext_swiginit(self, _mupdf.new_DocumentHandlerContext(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.DocumentHandlerContext_m_internal_value(self)
    m_internal = property(_mupdf.DocumentHandlerContext_m_internal_get, _mupdf.DocumentHandlerContext_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_DocumentHandlerContext

# Register DocumentHandlerContext in _mupdf:
_mupdf.DocumentHandlerContext_swigregister(DocumentHandlerContext)

class DocumentWriter(object):
    r""" Wrapper class for struct `fz_document_writer`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    PathType_CBZ = _mupdf.DocumentWriter_PathType_CBZ
    PathType_DOCX = _mupdf.DocumentWriter_PathType_DOCX
    PathType_ODT = _mupdf.DocumentWriter_PathType_ODT
    PathType_PAM_PIXMAP = _mupdf.DocumentWriter_PathType_PAM_PIXMAP
    PathType_PBM_PIXMAP = _mupdf.DocumentWriter_PathType_PBM_PIXMAP
    PathType_PCL = _mupdf.DocumentWriter_PathType_PCL
    PathType_PCLM = _mupdf.DocumentWriter_PathType_PCLM
    PathType_PDF = _mupdf.DocumentWriter_PathType_PDF
    PathType_PDFOCR = _mupdf.DocumentWriter_PathType_PDFOCR
    PathType_PGM_PIXMAP = _mupdf.DocumentWriter_PathType_PGM_PIXMAP
    PathType_PKM_PIXMAP = _mupdf.DocumentWriter_PathType_PKM_PIXMAP
    PathType_PNG_PIXMAP = _mupdf.DocumentWriter_PathType_PNG_PIXMAP
    PathType_PNM_PIXMAP = _mupdf.DocumentWriter_PathType_PNM_PIXMAP
    PathType_PPM_PIXMAP = _mupdf.DocumentWriter_PathType_PPM_PIXMAP
    PathType_PS = _mupdf.DocumentWriter_PathType_PS
    PathType_PWG = _mupdf.DocumentWriter_PathType_PWG
    PathType_SVG = _mupdf.DocumentWriter_PathType_SVG
    OutputType_CBZ = _mupdf.DocumentWriter_OutputType_CBZ
    OutputType_DOCX = _mupdf.DocumentWriter_OutputType_DOCX
    OutputType_ODT = _mupdf.DocumentWriter_OutputType_ODT
    OutputType_PCL = _mupdf.DocumentWriter_OutputType_PCL
    OutputType_PCLM = _mupdf.DocumentWriter_OutputType_PCLM
    OutputType_PDF = _mupdf.DocumentWriter_OutputType_PDF
    OutputType_PDFOCR = _mupdf.DocumentWriter_OutputType_PDFOCR
    OutputType_PS = _mupdf.DocumentWriter_OutputType_PS
    OutputType_PWG = _mupdf.DocumentWriter_OutputType_PWG
    FormatPathType_DOCUMENT = _mupdf.DocumentWriter_FormatPathType_DOCUMENT
    FormatPathType_TEXT = _mupdf.DocumentWriter_FormatPathType_TEXT

    def close_document_writer(self):
        r"""
        Wrapper for `fz_close_document_writer()`.
        	Called to end the process of writing
        	pages to a document.

        	This writes any file level trailers required. After this
        	completes successfully the file is up to date and complete.
        """
        return _mupdf.DocumentWriter_close_document_writer(self)

    def end_page(self):
        r"""
        Wrapper for `fz_end_page()`.
        	Called to end the process of writing a page to a
        	document.
        """
        return _mupdf.DocumentWriter_end_page(self)

    def pdfocr_writer_set_progress(self, progress, arg_2):
        r""" Wrapper for `fz_pdfocr_writer_set_progress()`."""
        return _mupdf.DocumentWriter_pdfocr_writer_set_progress(self, progress, arg_2)

    def write_document(self, doc):
        r"""
        Wrapper for `fz_write_document()`.
        	Convenience function to feed all the pages of a document to
        	fz_begin_page/fz_run_page/fz_end_page.
        """
        return _mupdf.DocumentWriter_write_document(self, doc)

    def begin_page(self, mediabox):
        return _mupdf.DocumentWriter_begin_page(self, mediabox)

    def __init__(self, *args):
        r"""
        *Overload 1:*
         == Constructors.  Constructor using `fz_new_document_writer_of_size()`.
        		Internal function to allocate a
        		block for a derived document_writer structure, with the base
        		structure's function pointers populated correctly, and the extra
        		space zero initialised.


        |

        *Overload 2:*
         Constructor using `fz_new_pixmap_writer()`.

        |

        *Overload 3:*
         Constructor using one of:
        		fz_new_cbz_writer()
        		fz_new_docx_writer()
        		fz_new_odt_writer()
        		fz_new_pam_pixmap_writer()
        		fz_new_pbm_pixmap_writer()
        		fz_new_pcl_writer()
        		fz_new_pclm_writer()
        		fz_new_pdf_writer()
        		fz_new_pdfocr_writer()
        		fz_new_pgm_pixmap_writer()
        		fz_new_pkm_pixmap_writer()
        		fz_new_png_pixmap_writer()
        		fz_new_pnm_pixmap_writer()
        		fz_new_ppm_pixmap_writer()
        		fz_new_ps_writer()
        		fz_new_pwg_writer()
        		fz_new_svg_writer()


        |

        *Overload 4:*
         Constructor using one of:
        		fz_new_cbz_writer_with_output()
        		fz_new_docx_writer_with_output()
        		fz_new_odt_writer_with_output()
        		fz_new_pcl_writer_with_output()
        		fz_new_pclm_writer_with_output()
        		fz_new_pdf_writer_with_output()
        		fz_new_pdfocr_writer_with_output()
        		fz_new_ps_writer_with_output()
        		fz_new_pwg_writer_with_output()

        	This constructor takes ownership of <out> -
        	out.m_internal is set to NULL after this constructor
        	returns so <out> must not be used again.


        |

        *Overload 5:*
         Constructor using one of:
        		fz_new_document_writer()
        		fz_new_text_writer()


        |

        *Overload 6:*
         Constructor using fz_new_document_writer_with_output().

        	This constructor takes ownership of <out> -
        	out.m_internal is set to NULL after this constructor
        	returns so <out> must not be used again.


        |

        *Overload 7:*
         Constructor using fz_new_text_writer_with_output().

        	This constructor takes ownership of <out> -
        	out.m_internal is set to NULL after this constructor
        	returns so <out> must not be used again.


        |

        *Overload 8:*
         Constructor using raw copy of pre-existing `fz_document_writer`.
        """
        _mupdf.DocumentWriter_swiginit(self, _mupdf.new_DocumentWriter(*args))
    __swig_destroy__ = _mupdf.delete_DocumentWriter

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.DocumentWriter_m_internal_value(self)
    m_internal = property(_mupdf.DocumentWriter_m_internal_get, _mupdf.DocumentWriter_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register DocumentWriter in _mupdf:
_mupdf.DocumentWriter_swigregister(DocumentWriter)

class DrawOptions(object):
    r"""
    Wrapper class for struct `fz_draw_options`. Not copyable or assignable.
    struct fz_draw_options: Options for creating a pixmap and draw
    device.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*
         == Constructors.  Constructor using `fz_parse_draw_options()`.
        		Parse draw device options from a comma separated key-value string.


        |

        *Overload 2:*
         Constructor using raw copy of pre-existing `fz_draw_options`.

        |

        *Overload 3:*
         Constructor using raw copy of pre-existing `fz_draw_options`.
        """
        _mupdf.DrawOptions_swiginit(self, _mupdf.new_DrawOptions(*args))

    def internal(self, *args):
        r"""
        *Overload 1:*
        Access as underlying struct.

        |

        *Overload 2:*
        Access as underlying struct.
        """
        return _mupdf.DrawOptions_internal(self, *args)
    rotate = property(_mupdf.DrawOptions_rotate_get, _mupdf.DrawOptions_rotate_set, doc=r""" We use default destructor.""")
    x_resolution = property(_mupdf.DrawOptions_x_resolution_get, _mupdf.DrawOptions_x_resolution_set)
    y_resolution = property(_mupdf.DrawOptions_y_resolution_get, _mupdf.DrawOptions_y_resolution_set)
    width = property(_mupdf.DrawOptions_width_get, _mupdf.DrawOptions_width_set)
    height = property(_mupdf.DrawOptions_height_get, _mupdf.DrawOptions_height_set)
    colorspace = property(_mupdf.DrawOptions_colorspace_get, _mupdf.DrawOptions_colorspace_set)
    alpha = property(_mupdf.DrawOptions_alpha_get, _mupdf.DrawOptions_alpha_set)
    graphics = property(_mupdf.DrawOptions_graphics_get, _mupdf.DrawOptions_graphics_set)
    text = property(_mupdf.DrawOptions_text_get, _mupdf.DrawOptions_text_set)

    def to_string(self):
        r""" Returns string containing our members, labelled and inside (...), using operator<<."""
        return _mupdf.DrawOptions_to_string(self)
    __swig_destroy__ = _mupdf.delete_DrawOptions

# Register DrawOptions in _mupdf:
_mupdf.DrawOptions_swigregister(DrawOptions)

class ErrorContext(object):
    r""" Wrapper class for struct `fz_error_context`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `fz_error_context`."""
        _mupdf.ErrorContext_swiginit(self, _mupdf.new_ErrorContext(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.ErrorContext_m_internal_value(self)
    m_internal = property(_mupdf.ErrorContext_m_internal_get, _mupdf.ErrorContext_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_ErrorContext

# Register ErrorContext in _mupdf:
_mupdf.ErrorContext_swigregister(ErrorContext)

class ErrorStackSlot(object):
    r""" Wrapper class for struct `fz_error_stack_slot`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `fz_error_stack_slot`."""
        _mupdf.ErrorStackSlot_swiginit(self, _mupdf.new_ErrorStackSlot(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.ErrorStackSlot_m_internal_value(self)
    m_internal = property(_mupdf.ErrorStackSlot_m_internal_get, _mupdf.ErrorStackSlot_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_ErrorStackSlot

# Register ErrorStackSlot in _mupdf:
_mupdf.ErrorStackSlot_swigregister(ErrorStackSlot)

class Font(object):
    r"""
    Wrapper class for struct `fz_font`.
    An abstract font handle.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def advance_glyph(self, glyph, wmode):
        r"""
        Wrapper for `fz_advance_glyph()`.
        	Return the advance for a given glyph.

        	font: The font to look for the glyph in.

        	glyph: The glyph to find the advance for.

        	wmode: 1 for vertical mode, 0 for horizontal.

        	Returns the advance for the glyph.
        """
        return _mupdf.Font_advance_glyph(self, glyph, wmode)

    def bound_glyph(self, gid, trm):
        r"""
        Wrapper for `fz_bound_glyph()`.
        	Return a bbox for a given glyph in a font.

        	font: The font to look for the glyph in.

        	gid: The glyph to bound.

        	trm: The matrix to apply to the glyph before bounding.

        	Returns rectangle by value containing the bounds of the given
        	glyph.
        """
        return _mupdf.Font_bound_glyph(self, gid, trm)

    def decouple_type3_font(self, t3doc):
        r""" Wrapper for `fz_decouple_type3_font()`."""
        return _mupdf.Font_decouple_type3_font(self, t3doc)

    def encode_character(self, unicode):
        r"""
        Wrapper for `fz_encode_character()`.
        	Find the glyph id for a given unicode
        	character within a font.

        	font: The font to look for the unicode character in.

        	unicode: The unicode character to encode.

        	Returns the glyph id for the given unicode value, or 0 if
        	unknown.
        """
        return _mupdf.Font_encode_character(self, unicode)

    def encode_character_by_glyph_name(self, glyphname):
        r"""
        Wrapper for `fz_encode_character_by_glyph_name()`.
        	Encode character.

        	Either by direct lookup of glyphname within a font, or, failing
        	that, by mapping glyphname to unicode and thence to the glyph
        	index within the given font.

        	Returns zero for type3 fonts.
        """
        return _mupdf.Font_encode_character_by_glyph_name(self, glyphname)

    def encode_character_sc(self, unicode):
        r"""
        Wrapper for `fz_encode_character_sc()`.
        	Encode character, preferring small-caps variant if available.

        	font: The font to look for the unicode character in.

        	unicode: The unicode character to encode.

        	Returns the glyph id for the given unicode value, or 0 if
        	unknown.
        """
        return _mupdf.Font_encode_character_sc(self, unicode)

    def font_ascender(self):
        r"""
        Wrapper for `fz_font_ascender()`.
        	Retrieve font ascender in ems.
        """
        return _mupdf.Font_font_ascender(self)

    def font_bbox(self):
        r"""
        Wrapper for `fz_font_bbox()`.
        	Retrieve the font bbox.

        	font: The font to query.

        	Returns the font bbox by value; it is valid only if
        	fz_font_flags(font)->invalid_bbox is zero.
        """
        return _mupdf.Font_font_bbox(self)

    def font_descender(self):
        r"""
        Wrapper for `fz_font_descender()`.
        	Retrieve font descender in ems.
        """
        return _mupdf.Font_font_descender(self)

    def font_digest(self, digest):
        r"""
        Wrapper for `fz_font_digest()`.
        	Retrieve the MD5 digest for the font's data.
        """
        return _mupdf.Font_font_digest(self, digest)

    def font_ft_face(self):
        r"""
        Wrapper for `fz_font_ft_face()`.
        	Retrieve the FT_Face handle
        	for the font.

        	font: The font to query

        	Returns the FT_Face handle for the font, or NULL
        	if not a freetype handled font. (Cast to void *
        	to avoid nasty header exposure).
        """
        return _mupdf.Font_font_ft_face(self)

    def font_is_bold(self):
        r"""
        Wrapper for `fz_font_is_bold()`.
        	Query whether the font flags say that this font is bold.
        """
        return _mupdf.Font_font_is_bold(self)

    def font_is_italic(self):
        r"""
        Wrapper for `fz_font_is_italic()`.
        	Query whether the font flags say that this font is italic.
        """
        return _mupdf.Font_font_is_italic(self)

    def font_is_monospaced(self):
        r"""
        Wrapper for `fz_font_is_monospaced()`.
        	Query whether the font flags say that this font is monospaced.
        """
        return _mupdf.Font_font_is_monospaced(self)

    def font_is_serif(self):
        r"""
        Wrapper for `fz_font_is_serif()`.
        	Query whether the font flags say that this font is serif.
        """
        return _mupdf.Font_font_is_serif(self)

    def font_name(self):
        r"""
        Wrapper for `fz_font_name()`.
        	Retrieve a pointer to the name of the font.

        	font: The font to query.

        	Returns a pointer to an internal copy of the font name.
        	Will never be NULL, but may be the empty string.
        """
        return _mupdf.Font_font_name(self)

    def font_t3_procs(self):
        r"""
        Wrapper for `fz_font_t3_procs()`.
        	Retrieve the Type3 procs
        	for a font.

        	font: The font to query

        	Returns the t3_procs pointer. Will be NULL for a
        	non type-3 font.
        """
        return _mupdf.Font_font_t3_procs(self)

    def get_glyph_name(self, glyph, buf, size):
        r"""
        Wrapper for `fz_get_glyph_name()`.
        	Find the name of a glyph

        	font: The font to look for the glyph in.

        	glyph: The glyph id to look for.

        	buf: Pointer to a buffer for the name to be inserted into.

        	size: The size of the buffer.

        	If a font contains a name table, then the name of the glyph
        	will be returned in the supplied buffer. Otherwise a name
        	is synthesised. The name will be truncated to fit in
        	the buffer.
        """
        return _mupdf.Font_get_glyph_name(self, glyph, buf, size)

    def glyph_cacheable(self, gid):
        r"""
        Wrapper for `fz_glyph_cacheable()`.
        	Determine if a given glyph in a font
        	is cacheable. Certain glyphs in a type 3 font cannot safely
        	be cached, as their appearance depends on the enclosing
        	graphic state.

        	font: The font to look for the glyph in.

        	gif: The glyph to query.

        	Returns non-zero if cacheable, 0 if not.
        """
        return _mupdf.Font_glyph_cacheable(self, gid)

    def measure_string(self, trm, s, wmode, bidi_level, markup_dir, language):
        r"""
        Wrapper for `fz_measure_string()`.
        	Measure the advance width of a UTF8 string should it be added to a text object.

        	This uses the same layout algorithms as fz_show_string, and can be used
        	to calculate text alignment adjustments.
        """
        return _mupdf.Font_measure_string(self, trm, s, wmode, bidi_level, markup_dir, language)

    def outline_glyph(self, gid, ctm):
        r"""
        Wrapper for `fz_outline_glyph()`.
        	Look a glyph up from a font, and return the outline of the
        	glyph using the given transform.

        	The caller owns the returned path, and so is responsible for
        	ensuring that it eventually gets dropped.
        """
        return _mupdf.Font_outline_glyph(self, gid, ctm)

    def prepare_t3_glyph(self, gid):
        r"""
        Wrapper for `fz_prepare_t3_glyph()`.
        	Force a type3 font to cache the displaylist for a given glyph
        	id.

        	This caching can involve reading the underlying file, so must
        	happen ahead of time, so we aren't suddenly forced to read the
        	file while playing a displaylist back.
        """
        return _mupdf.Font_prepare_t3_glyph(self, gid)

    def render_glyph_pixmap(self, gid, ctm, scissor, aa):
        r"""
        Wrapper for `fz_render_glyph_pixmap()`.
        	Create a pixmap containing a rendered glyph.

        	Lookup gid from font, clip it with scissor, and rendering it
        	with aa bits of antialiasing into a new pixmap.

        	The caller takes ownership of the pixmap and so must free it.

        	Note: This function is no longer used for normal rendering
        	operations, and is kept around just because we use it in the
        	app. It should be considered "at risk" of removal from the API.
        """
        return _mupdf.Font_render_glyph_pixmap(self, gid, ctm, scissor, aa)

    def run_t3_glyph(self, gid, trm, dev):
        r"""
        Wrapper for `fz_run_t3_glyph()`.
        	Run a glyph from a Type3 font to
        	a given device.

        	font: The font to find the glyph in.

        	gid: The glyph to run.

        	trm: The transform to apply.

        	dev: The device to render onto.
        """
        return _mupdf.Font_run_t3_glyph(self, gid, trm, dev)

    def set_font_bbox(self, xmin, ymin, xmax, ymax):
        r"""
        Wrapper for `fz_set_font_bbox()`.
        	Set the font bbox.

        	font: The font to set the bbox for.

        	xmin, ymin, xmax, ymax: The bounding box.
        """
        return _mupdf.Font_set_font_bbox(self, xmin, ymin, xmax, ymax)

    def font_writing_supported(self):
        r""" Wrapper for `pdf_font_writing_supported()`."""
        return _mupdf.Font_font_writing_supported(self)

    def layout_fit_text(self, lang, str, bounds):
        r""" Wrapper for `pdf_layout_fit_text()`."""
        return _mupdf.Font_layout_fit_text(self, lang, str, bounds)

    def __init__(self, *args):
        r"""
        *Overload 1:*
         == Constructors.  Constructor using `fz_new_base14_font()`.
        		Create a new font from one of the built-in fonts.


        |

        *Overload 2:*
         Constructor using `fz_new_builtin_font()`.

        |

        *Overload 3:*
         Constructor using `fz_new_cjk_font()`.

        |

        *Overload 4:*
         Constructor using `fz_new_font_from_buffer()`.
        		Create a new font from a font file in a fz_buffer.

        		name: Name of font (leave NULL to use name from font).

        		buffer: Buffer to load from.

        		index: Which font from the file to load (0 for default).

        		use_glyph_box: 1 if we should use the glyph bbox, 0 otherwise.

        		Returns new font handle, or throws exception on error.


        |

        *Overload 5:*
         Constructor using `fz_new_font_from_file()`.
        		Create a new font from a font file.

        		name: Name of font (leave NULL to use name from font).

        		path: File path to load from.

        		index: Which font from the file to load (0 for default).

        		use_glyph_box: 1 if we should use the glyph bbox, 0 otherwise.

        		Returns new font handle, or throws exception on error.


        |

        *Overload 6:*
         Constructor using `fz_new_font_from_memory()`.
        		Create a new font from a font
        		file in memory.

        		name: Name of font (leave NULL to use name from font).

        		data: Pointer to the font file data.

        		len: Length of the font file data.

        		index: Which font from the file to load (0 for default).

        		use_glyph_box: 1 if we should use the glyph bbox, 0 otherwise.

        		Returns new font handle, or throws exception on error.


        |

        *Overload 7:*
         Constructor using `fz_new_type3_font()`.
        		Create a new (empty) type3 font.

        		name: Name of font (or NULL).

        		matrix: Font matrix.

        		Returns a new font handle, or throws exception on
        		allocation failure.


        |

        *Overload 8:*
         Copy constructor using `fz_keep_font()`.

        |

        *Overload 9:*
         Constructor using raw copy of pre-existing `fz_font`.
        """
        _mupdf.Font_swiginit(self, _mupdf.new_Font(*args))
    __swig_destroy__ = _mupdf.delete_Font

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.Font_m_internal_value(self)
    m_internal = property(_mupdf.Font_m_internal_get, _mupdf.Font_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register Font in _mupdf:
_mupdf.Font_swigregister(Font)

class FontContext(object):
    r""" Wrapper class for struct `fz_font_context`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `fz_font_context`."""
        _mupdf.FontContext_swiginit(self, _mupdf.new_FontContext(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.FontContext_m_internal_value(self)
    m_internal = property(_mupdf.FontContext_m_internal_get, _mupdf.FontContext_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_FontContext

# Register FontContext in _mupdf:
_mupdf.FontContext_swigregister(FontContext)

class FontFlagsT(object):
    r"""
    Wrapper class for struct `fz_font_flags_t`. Not copyable or assignable.
    Every fz_font carries a set of flags
    within it, in a fz_font_flags_t structure.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `fz_font_flags_t`."""
        _mupdf.FontFlagsT_swiginit(self, _mupdf.new_FontFlagsT(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.FontFlagsT_m_internal_value(self)
    m_internal = property(_mupdf.FontFlagsT_m_internal_get, _mupdf.FontFlagsT_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_FontFlagsT

# Register FontFlagsT in _mupdf:
_mupdf.FontFlagsT_swigregister(FontFlagsT)

class Glyph(object):
    r"""
    Wrapper class for struct `fz_glyph`.
    Glyphs represent a run length encoded set of pixels for a 2
    dimensional region of a plane.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def glyph_bbox(self):
        r"""
        Wrapper for `fz_glyph_bbox()`.
        	Return the bounding box of the glyph in pixels.
        """
        return _mupdf.Glyph_glyph_bbox(self)

    def glyph_bbox_no_ctx(self):
        r""" Wrapper for `fz_glyph_bbox_no_ctx()`."""
        return _mupdf.Glyph_glyph_bbox_no_ctx(self)

    def glyph_height(self):
        r"""
        Wrapper for `fz_glyph_height()`.
        	Return the height of the glyph in pixels.
        """
        return _mupdf.Glyph_glyph_height(self)

    def glyph_width(self):
        r"""
        Wrapper for `fz_glyph_width()`.
        	Return the width of the glyph in pixels.
        """
        return _mupdf.Glyph_glyph_width(self)

    def __init__(self, *args):
        r"""
        *Overload 1:*
        Copy constructor using `fz_keep_glyph()`.

        |

        *Overload 2:*
        Constructor using raw copy of pre-existing `fz_glyph`.
        """
        _mupdf.Glyph_swiginit(self, _mupdf.new_Glyph(*args))
    __swig_destroy__ = _mupdf.delete_Glyph

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.Glyph_m_internal_value(self)
    m_internal = property(_mupdf.Glyph_m_internal_get, _mupdf.Glyph_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register Glyph in _mupdf:
_mupdf.Glyph_swigregister(Glyph)

class GlyphCache(object):
    r""" Wrapper class for struct `fz_glyph_cache`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `fz_glyph_cache`."""
        _mupdf.GlyphCache_swiginit(self, _mupdf.new_GlyphCache(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.GlyphCache_m_internal_value(self)
    m_internal = property(_mupdf.GlyphCache_m_internal_get, _mupdf.GlyphCache_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_GlyphCache

# Register GlyphCache in _mupdf:
_mupdf.GlyphCache_swigregister(GlyphCache)

class Halftone(object):
    r"""
    Wrapper class for struct `fz_halftone`.
    A halftone is a set of threshold tiles, one per component. Each
    threshold tile is a pixmap, possibly of varying sizes and
    phases. Currently, we only provide one 'default' halftone tile
    for operating on 1 component plus alpha pixmaps (where the alpha
    is ignored). This is signified by a fz_halftone pointer to NULL.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*
        Copy constructor using `fz_keep_halftone()`.

        |

        *Overload 2:*
        Constructor using raw copy of pre-existing `fz_halftone`.

        |

        *Overload 3:*
        Constructor using raw copy of pre-existing `fz_halftone`.
        """
        _mupdf.Halftone_swiginit(self, _mupdf.new_Halftone(*args))
    __swig_destroy__ = _mupdf.delete_Halftone

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.Halftone_m_internal_value(self)
    m_internal = property(_mupdf.Halftone_m_internal_get, _mupdf.Halftone_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register Halftone in _mupdf:
_mupdf.Halftone_swigregister(Halftone)

class HashTable(object):
    r"""
    Wrapper class for struct `fz_hash_table`. Not copyable or assignable.
    Generic hash-table with fixed-length keys.

    The keys and values are NOT reference counted by the hash table.
    Callers are responsible for taking care the reference counts are
    correct. Inserting a duplicate entry will NOT overwrite the old
    value, and will return the old value.

    The drop_val callback function is only used to release values
    when the hash table is destroyed.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def hash_filter(self, state, callback):
        r"""
        Wrapper for `fz_hash_filter()`.
        	Iterate over the entries in a hash table, removing all the ones where callback returns true.
        	Does NOT free the value of the entry, so the caller is expected to take care of this.
        """
        return _mupdf.HashTable_hash_filter(self, state, callback)

    def hash_find(self, key):
        r"""
        Wrapper for `fz_hash_find()`.
        	Search for a matching hash within the table, and return the
        	associated value.
        """
        return _mupdf.HashTable_hash_find(self, key)

    def hash_for_each(self, state, callback):
        r"""
        Wrapper for `fz_hash_for_each()`.
        	Iterate over the entries in a hash table.
        """
        return _mupdf.HashTable_hash_for_each(self, state, callback)

    def hash_insert(self, key, val):
        r"""
        Wrapper for `fz_hash_insert()`.
        	Insert a new key/value pair into the hash table.

        	If an existing entry with the same key is found, no change is
        	made to the hash table, and a pointer to the existing value is
        	returned.

        	If no existing entry with the same key is found, ownership of
        	val passes in, key is copied, and NULL is returned.
        """
        return _mupdf.HashTable_hash_insert(self, key, val)

    def hash_remove(self, key):
        r"""
        Wrapper for `fz_hash_remove()`.
        	Remove the entry for a given key.

        	The value is NOT freed, so the caller is expected to take care
        	of this.
        """
        return _mupdf.HashTable_hash_remove(self, key)

    def __init__(self, *args):
        r"""
        *Overload 1:*
         == Constructors.  Constructor using `fz_new_hash_table()`.
        		Create a new hash table.

        		initialsize: The initial size of the hashtable. The hashtable
        		may grow (double in size) if it starts to get crowded (80%
        		full).

        		keylen: byte length for each key.

        		lock: -1 for no lock, otherwise the FZ_LOCK to use to protect
        		this table.

        		drop_val: Function to use to destroy values on table drop.


        |

        *Overload 2:*
         Constructor using raw copy of pre-existing `fz_hash_table`.
        """
        _mupdf.HashTable_swiginit(self, _mupdf.new_HashTable(*args))
    __swig_destroy__ = _mupdf.delete_HashTable

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.HashTable_m_internal_value(self)
    m_internal = property(_mupdf.HashTable_m_internal_get, _mupdf.HashTable_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register HashTable in _mupdf:
_mupdf.HashTable_swigregister(HashTable)

class IccProfile(object):
    r"""
    Wrapper class for struct `fz_icc_profile`. Not copyable or assignable.
    Opaque type for an ICC Profile.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `fz_icc_profile`."""
        _mupdf.IccProfile_swiginit(self, _mupdf.new_IccProfile(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.IccProfile_m_internal_value(self)
    m_internal = property(_mupdf.IccProfile_m_internal_get, _mupdf.IccProfile_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_IccProfile

# Register IccProfile in _mupdf:
_mupdf.IccProfile_swigregister(IccProfile)

class Image(object):
    r"""
    Wrapper class for struct `fz_image`.
    Images are storable objects from which we can obtain fz_pixmaps.
    These may be implemented as simple wrappers around a pixmap, or
    as more complex things that decode at different subsample
    settings on demand.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def get_pixmap_from_image(self, subarea, ctm):
        r"""
        Wrapper for `fz_get_pixmap_from_image()`.

        This method has out-params. Python/C# wrappers look like:
        	`get_pixmap_from_image(const fz_irect *subarea, fz_matrix *ctm)` => `(fz_pixmap *, int w, int h)`

        	Called to get a handle to a pixmap from an image.

        	image: The image to retrieve a pixmap from.

        	subarea: The subarea of the image that we actually care about
        	(or NULL to indicate the whole image).

        	ctm: Optional, unless subarea is given. If given, then on
        	entry this is the transform that will be applied to the complete
        	image. It should be updated on exit to the transform to apply to
        	the given subarea of the image. This is used to calculate the
        	desired width/height for subsampling.

        	w: If non-NULL, a pointer to an int to be updated on exit to the
        	width (in pixels) that the scaled output will cover.

        	h: If non-NULL, a pointer to an int to be updated on exit to the
        	height (in pixels) that the scaled output will cover.

        	Returns a non NULL pixmap pointer. May throw exceptions.
        """
        return _mupdf.Image_get_pixmap_from_image(self, subarea, ctm)

    def get_unscaled_pixmap_from_image(self):
        r"""
        Wrapper for `fz_get_unscaled_pixmap_from_image()`.
        	Calls fz_get_pixmap_from_image() with ctm, subarea, w and h all set to NULL.
        """
        return _mupdf.Image_get_unscaled_pixmap_from_image(self)

    def image_orientation(self):
        r"""
        Wrapper for `fz_image_orientation()`.
        	Request the natural orientation of an image.

        	This is for images (such as JPEG) that can contain internal
        	specifications of rotation/flips. This is ignored by all the
        	internal decode/rendering routines, but can be used by callers
        	(such as the image document handler) to respect such
        	specifications.

        	The values used by MuPDF are as follows, with the equivalent
        	Exif specifications given for information:

        	0: Undefined
        	1: 0 degree ccw rotation. (Exif = 1)
        	2: 90 degree ccw rotation. (Exif = 8)
        	3: 180 degree ccw rotation. (Exif = 3)
        	4: 270 degree ccw rotation. (Exif = 6)
        	5: flip on X. (Exif = 2)
        	6: flip on X, then rotate ccw by 90 degrees. (Exif = 5)
        	7: flip on X, then rotate ccw by 180 degrees. (Exif = 4)
        	8: flip on X, then rotate ccw by 270 degrees. (Exif = 7)
        """
        return _mupdf.Image_image_orientation(self)

    def image_orientation_matrix(self):
        r""" Wrapper for `fz_image_orientation_matrix()`."""
        return _mupdf.Image_image_orientation_matrix(self)

    def image_resolution(self):
        r"""
        Wrapper for `fz_image_resolution()`.

        This method has out-params. Python/C# wrappers look like:
        	`image_resolution()` => `(int xres, int yres)`

        	Request the natural resolution
        	of an image.

        	xres, yres: Pointers to ints to be updated with the
        	natural resolution of an image (or a sensible default
        	if not encoded).
        """
        return _mupdf.Image_image_resolution(self)

    def image_size(self):
        r"""
        Wrapper for `fz_image_size()`.
        	Return the size of the storage used by an image.
        """
        return _mupdf.Image_image_size(self)

    def new_buffer_from_image_as_png(self, color_params):
        r"""
        Wrapper for `fz_new_buffer_from_image_as_png()`.
        	Reencode a given image as a PNG into a buffer.

        	Ownership of the buffer is returned.
        """
        return _mupdf.Image_new_buffer_from_image_as_png(self, color_params)

    def __init__(self, *args):
        r"""
        *Overload 1:*
         == Constructors.  Constructor using `fz_new_image_from_buffer()`.
        		Create a new image from a
        		buffer of data, inferring its type from the format
        		of the data.


        |

        *Overload 2:*
         Constructor using `fz_new_image_from_compressed_buffer()`.
        		Create an image based on
        		the data in the supplied compressed buffer.

        		w,h: Width and height of the created image.

        		bpc: Bits per component.

        		colorspace: The colorspace (determines the number of components,
        		and any color conversions required while decoding).

        		xres, yres: The X and Y resolutions respectively.

        		interpolate: 1 if interpolation should be used when decoding
        		this image, 0 otherwise.

        		imagemask: 1 if this is an imagemask (i.e. transparency bitmap
        		mask), 0 otherwise.

        		decode: NULL, or a pointer to to a decode array. The default
        		decode array is [0 1] (repeated n times, for n color components).

        		colorkey: NULL, or a pointer to a colorkey array. The default
        		colorkey array is [0 255] (repeated n times, for n color
        		components).

        		buffer: Buffer of compressed data and compression parameters.
        		Ownership of this reference is passed in.

        		mask: NULL, or another image to use as a mask for this one.
        		A new reference is taken to this image. Supplying a masked
        		image as a mask to another image is illegal!


        |

        *Overload 3:*
         Constructor using `fz_new_image_from_display_list()`.
        		Create a new image from a display list.

        		w, h: The conceptual width/height of the image.

        		transform: The matrix that needs to be applied to the given
        		list to make it render to the unit square.

        		list: The display list.


        |

        *Overload 4:*
         Constructor using `fz_new_image_from_file()`.
        		Create a new image from the contents
        		of a file, inferring its type from the format of the
        		data.


        |

        *Overload 5:*
         Constructor using `fz_new_image_from_pixmap()`.
        		Create an image from the given
        		pixmap.

        		pixmap: The pixmap to base the image upon. A new reference
        		to this is taken.

        		mask: NULL, or another image to use as a mask for this one.
        		A new reference is taken to this image. Supplying a masked
        		image as a mask to another image is illegal!


        |

        *Overload 6:*
         Constructor using `fz_new_image_from_svg()`.
        		Create a scalable image from an SVG document.


        |

        *Overload 7:*
         Constructor using `fz_new_image_from_svg_xml()`.
        		Create a scalable image from an SVG document.


        |

        *Overload 8:*
         Constructor using `fz_new_image_of_size()`.
        		Internal function to make a new fz_image structure
        		for a derived class.

        		w,h: Width and height of the created image.

        		bpc: Bits per component.

        		colorspace: The colorspace (determines the number of components,
        		and any color conversions required while decoding).

        		xres, yres: The X and Y resolutions respectively.

        		interpolate: 1 if interpolation should be used when decoding
        		this image, 0 otherwise.

        		imagemask: 1 if this is an imagemask (i.e. transparent), 0
        		otherwise.

        		decode: NULL, or a pointer to to a decode array. The default
        		decode array is [0 1] (repeated n times, for n color components).

        		colorkey: NULL, or a pointer to a colorkey array. The default
        		colorkey array is [0 255] (repeated n times, for n color
        		components).

        		mask: NULL, or another image to use as a mask for this one.
        		A new reference is taken to this image. Supplying a masked
        		image as a mask to another image is illegal!

        		size: The size of the required allocated structure (the size of
        		the derived structure).

        		get: The function to be called to obtain a decoded pixmap.

        		get_size: The function to be called to return the storage size
        		used by this image.

        		drop: The function to be called to dispose of this image once
        		the last reference is dropped.

        		Returns a pointer to an allocated structure of the required size,
        		with the first sizeof(fz_image) bytes initialised as appropriate
        		given the supplied parameters, and the other bytes set to zero.


        |

        *Overload 9:*
         Construct with m_internal set to null.

        |

        *Overload 10:*
         Copy constructor using `fz_keep_image()`.

        |

        *Overload 11:*
         Constructor using raw copy of pre-existing `fz_image`.
        """
        _mupdf.Image_swiginit(self, _mupdf.new_Image(*args))

    def key_storable(self):
        return _mupdf.Image_key_storable(self)

    def w(self):
        return _mupdf.Image_w(self)

    def h(self):
        return _mupdf.Image_h(self)

    def n(self):
        return _mupdf.Image_n(self)

    def bpc(self):
        return _mupdf.Image_bpc(self)

    def imagemask(self):
        return _mupdf.Image_imagemask(self)

    def interpolate(self):
        return _mupdf.Image_interpolate(self)

    def use_colorkey(self):
        return _mupdf.Image_use_colorkey(self)

    def use_decode(self):
        return _mupdf.Image_use_decode(self)

    def invert_cmyk_jpeg(self):
        return _mupdf.Image_invert_cmyk_jpeg(self)

    def decoded(self):
        return _mupdf.Image_decoded(self)

    def scalable(self):
        return _mupdf.Image_scalable(self)

    def orientation(self):
        return _mupdf.Image_orientation(self)

    def mask(self):
        return _mupdf.Image_mask(self)

    def xres(self):
        return _mupdf.Image_xres(self)

    def yres(self):
        return _mupdf.Image_yres(self)

    def colorspace(self):
        return _mupdf.Image_colorspace(self)

    def colorkey(self):
        return _mupdf.Image_colorkey(self)

    def decode(self):
        return _mupdf.Image_decode(self)
    __swig_destroy__ = _mupdf.delete_Image

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.Image_m_internal_value(self)
    m_internal = property(_mupdf.Image_m_internal_get, _mupdf.Image_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register Image in _mupdf:
_mupdf.Image_swigregister(Image)

class Irect(object):
    r"""
    Wrapper class for struct `fz_irect`.
    fz_irect is a rectangle using integers instead of floats.

    It's used in the draw device and for pixmap dimensions.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def expand_irect(self, expand):
        r""" We use default copy constructor and operator=.  Wrapper for `fz_expand_irect()`."""
        return _mupdf.Irect_expand_irect(self, expand)

    def intersect_irect(self, b):
        r"""
        Wrapper for `fz_intersect_irect()`.
        	Compute intersection of two bounding boxes.

        	Similar to fz_intersect_rect but operates on two bounding
        	boxes instead of two rectangles.
        """
        return _mupdf.Irect_intersect_irect(self, b)

    def irect_height(self):
        r"""
        Wrapper for `fz_irect_height()`.
        	Return the height of an irect. Invalid irects return 0.
        """
        return _mupdf.Irect_irect_height(self)

    def irect_width(self):
        r"""
        Wrapper for `fz_irect_width()`.
        	Return the width of an irect. Invalid irects return 0.
        """
        return _mupdf.Irect_irect_width(self)

    def is_empty_irect(self):
        r""" Wrapper for `fz_is_empty_irect()`."""
        return _mupdf.Irect_is_empty_irect(self)

    def is_infinite_irect(self):
        r"""
        Wrapper for `fz_is_infinite_irect()`.
        	Check if an integer rectangle
        	is infinite.
        """
        return _mupdf.Irect_is_infinite_irect(self)

    def is_valid_irect(self):
        r"""
        Wrapper for `fz_is_valid_irect()`.
        	Check if an integer rectangle is valid.
        """
        return _mupdf.Irect_is_valid_irect(self)

    def rect_from_irect(self):
        r"""
        Wrapper for `fz_rect_from_irect()`.
        	Convert a bbox into a rect.

        	For our purposes, a rect can represent all the values we meet in
        	a bbox, so nothing can go wrong.

        	rect: A place to store the generated rectangle.

        	bbox: The bbox to convert.

        	Returns rect (updated).
        """
        return _mupdf.Irect_rect_from_irect(self)

    def translate_irect(self, xoff, yoff):
        r""" Wrapper for `fz_translate_irect()`."""
        return _mupdf.Irect_translate_irect(self, xoff, yoff)

    def __init__(self, *args):
        r"""
        *Overload 1:*
         == Constructors.  Constructor using `fz_irect_from_rect()`.
        		Convert a rect into the minimal bounding box
        		that covers the rectangle.

        		Coordinates in a bounding box are integers, so rounding of the
        		rects coordinates takes place. The top left corner is rounded
        		upwards and left while the bottom right corner is rounded
        		downwards and to the right.


        |

        *Overload 2:*
         Constructor using `fz_make_irect()`.

        |

        *Overload 3:*
         Constructor using raw copy of pre-existing `fz_irect`.

        |

        *Overload 4:*
         Constructor using raw copy of pre-existing `fz_irect`.
        """
        _mupdf.Irect_swiginit(self, _mupdf.new_Irect(*args))

    def internal(self, *args):
        r"""
        *Overload 1:*
        Access as underlying struct.

        |

        *Overload 2:*
        Access as underlying struct.
        """
        return _mupdf.Irect_internal(self, *args)
    x0 = property(_mupdf.Irect_x0_get, _mupdf.Irect_x0_set, doc=r""" We use default destructor.""")
    y0 = property(_mupdf.Irect_y0_get, _mupdf.Irect_y0_set)
    x1 = property(_mupdf.Irect_x1_get, _mupdf.Irect_x1_set)
    y1 = property(_mupdf.Irect_y1_get, _mupdf.Irect_y1_set)

    def to_string(self):
        r""" Returns string containing our members, labelled and inside (...), using operator<<."""
        return _mupdf.Irect_to_string(self)
    __swig_destroy__ = _mupdf.delete_Irect

# Register Irect in _mupdf:
_mupdf.Irect_swigregister(Irect)

class Jbig2Globals(object):
    r""" Wrapper class for struct `fz_jbig2_globals`."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def jbig2_globals_data(self):
        r"""
        Wrapper for `fz_jbig2_globals_data()`.
        	Return buffer containing jbig2 globals data stream.
        """
        return _mupdf.Jbig2Globals_jbig2_globals_data(self)

    def __init__(self, *args):
        r"""
        *Overload 1:*
        Copy constructor using `fz_keep_jbig2_globals()`.

        |

        *Overload 2:*
        Constructor using raw copy of pre-existing `fz_jbig2_globals`.
        """
        _mupdf.Jbig2Globals_swiginit(self, _mupdf.new_Jbig2Globals(*args))
    __swig_destroy__ = _mupdf.delete_Jbig2Globals

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.Jbig2Globals_m_internal_value(self)
    m_internal = property(_mupdf.Jbig2Globals_m_internal_get, _mupdf.Jbig2Globals_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register Jbig2Globals in _mupdf:
_mupdf.Jbig2Globals_swigregister(Jbig2Globals)

class KeyStorable(object):
    r"""
    Wrapper class for struct `fz_key_storable`.
    Any storable object that can appear in the key of another
    storable object should include an fz_key_storable structure
    at the start (by convention at least) of their structure.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*
        Copy constructor using `fz_keep_key_storable()`.

        |

        *Overload 2:*
        Constructor using raw copy of pre-existing `fz_key_storable`.
        """
        _mupdf.KeyStorable_swiginit(self, _mupdf.new_KeyStorable(*args))
    __swig_destroy__ = _mupdf.delete_KeyStorable

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.KeyStorable_m_internal_value(self)
    m_internal = property(_mupdf.KeyStorable_m_internal_get, _mupdf.KeyStorable_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register KeyStorable in _mupdf:
_mupdf.KeyStorable_swigregister(KeyStorable)

class LayoutBlock(object):
    r""" Wrapper class for struct `fz_layout_block`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def add_layout_char(self, x, w, p):
        r"""
        Wrapper for `fz_add_layout_char()`.
        	Add a new char to the line at the end of the layout block.
        """
        return _mupdf.LayoutBlock_add_layout_char(self, x, w, p)

    def add_layout_line(self, x, y, h, p):
        r"""
        Wrapper for `fz_add_layout_line()`.
        	Add a new line to the end of the layout block.
        """
        return _mupdf.LayoutBlock_add_layout_line(self, x, y, h, p)

    def __init__(self, *args):
        r"""
        *Overload 1:*
         == Constructors.  Constructor using `fz_new_layout()`.
        		Create a new layout block, with new allocation pool, zero
        		matrices, and initialise linked pointers.


        |

        *Overload 2:*
         Constructor using raw copy of pre-existing `fz_layout_block`.
        """
        _mupdf.LayoutBlock_swiginit(self, _mupdf.new_LayoutBlock(*args))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.LayoutBlock_m_internal_value(self)
    m_internal = property(_mupdf.LayoutBlock_m_internal_get, _mupdf.LayoutBlock_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_LayoutBlock

# Register LayoutBlock in _mupdf:
_mupdf.LayoutBlock_swigregister(LayoutBlock)

class LayoutChar(object):
    r"""
    Wrapper class for struct `fz_layout_char`. Not copyable or assignable.
    Simple text layout (for use with annotation editing primarily).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `fz_layout_char`."""
        _mupdf.LayoutChar_swiginit(self, _mupdf.new_LayoutChar(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.LayoutChar_m_internal_value(self)
    m_internal = property(_mupdf.LayoutChar_m_internal_get, _mupdf.LayoutChar_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_LayoutChar

# Register LayoutChar in _mupdf:
_mupdf.LayoutChar_swigregister(LayoutChar)

class LayoutLine(object):
    r""" Wrapper class for struct `fz_layout_line`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `fz_layout_line`."""
        _mupdf.LayoutLine_swiginit(self, _mupdf.new_LayoutLine(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.LayoutLine_m_internal_value(self)
    m_internal = property(_mupdf.LayoutLine_m_internal_get, _mupdf.LayoutLine_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_LayoutLine

# Register LayoutLine in _mupdf:
_mupdf.LayoutLine_swigregister(LayoutLine)

class Link(object):
    r"""
    Wrapper class for struct `fz_link`.
    fz_link is a list of interactive links on a page.

    There is no relation between the order of the links in the
    list and the order they appear on the page. The list of links
    for a given page can be obtained from fz_load_links.

    A link is reference counted. Dropping a reference to a link is
    done by calling fz_drop_link.

    rect: The hot zone. The area that can be clicked in
    untransformed coordinates.

    uri: Link destinations come in two forms: internal and external.
    Internal links refer to other pages in the same document.
    External links are URLs to other documents.

    next: A pointer to the next link on the same page.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        r""" Used for iteration over linked list of Link items starting at fz_link::."""
        return _mupdf.Link_begin(self)

    def end(self):
        r""" Used for iteration over linked list of Link items starting at fz_link::."""
        return _mupdf.Link_end(self)

    def __init__(self, *args):
        r"""
        *Overload 1:*
         == Constructors.  Constructor using `fz_new_link()`.
        		Create a new link record.

        		next is set to NULL with the expectation that the caller will
        		handle the linked list setup.

        		Internal function.


        |

        *Overload 2:*
         Copy constructor using `fz_keep_link()`.

        |

        *Overload 3:*
         Constructor using raw copy of pre-existing `fz_link`.
        """
        _mupdf.Link_swiginit(self, _mupdf.new_Link(*args))

    def refs(self):
        return _mupdf.Link_refs(self)

    def next(self):
        return _mupdf.Link_next(self)

    def rect(self):
        return _mupdf.Link_rect(self)

    def uri(self):
        return _mupdf.Link_uri(self)
    __swig_destroy__ = _mupdf.delete_Link

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.Link_m_internal_value(self)
    m_internal = property(_mupdf.Link_m_internal_get, _mupdf.Link_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register Link in _mupdf:
_mupdf.Link_swigregister(Link)

class LinkDest(object):
    r""" Wrapper class for struct `fz_link_dest`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def format_link_uri(self):
        r""" Wrapper for `pdf_format_link_uri()`."""
        return _mupdf.LinkDest_format_link_uri(self)

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `fz_link_dest`."""
        _mupdf.LinkDest_swiginit(self, _mupdf.new_LinkDest(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.LinkDest_m_internal_value(self)
    m_internal = property(_mupdf.LinkDest_m_internal_get, _mupdf.LinkDest_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_LinkDest

# Register LinkDest in _mupdf:
_mupdf.LinkDest_swigregister(LinkDest)

class Location(object):
    r"""
    Wrapper class for struct `fz_location`.
    Locations within the document are referred to in terms of
    chapter and page, rather than just a page number. For some
    documents (such as epub documents with large numbers of pages
    broken into many chapters) this can make navigation much faster
    as only the required chapter needs to be decoded at a time.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*
         == Constructors.  Constructor using `fz_make_location()`.
        		Simple constructor for fz_locations.


        |

        *Overload 2:*
         We use default copy constructor and operator=.  Constructor using raw copy of pre-existing `fz_location`.

        |

        *Overload 3:*
         Constructor using raw copy of pre-existing `fz_location`.
        """
        _mupdf.Location_swiginit(self, _mupdf.new_Location(*args))

    def internal(self, *args):
        r"""
        *Overload 1:*
        Access as underlying struct.

        |

        *Overload 2:*
        Access as underlying struct.
        """
        return _mupdf.Location_internal(self, *args)
    chapter = property(_mupdf.Location_chapter_get, _mupdf.Location_chapter_set, doc=r""" We use default destructor.""")
    page = property(_mupdf.Location_page_get, _mupdf.Location_page_set)

    def to_string(self):
        r""" Returns string containing our members, labelled and inside (...), using operator<<."""
        return _mupdf.Location_to_string(self)
    __swig_destroy__ = _mupdf.delete_Location

# Register Location in _mupdf:
_mupdf.Location_swigregister(Location)

class LocksContext(object):
    r"""
    Wrapper class for struct `fz_locks_context`. Not copyable or assignable.
    Locking functions

    MuPDF is kept deliberately free of any knowledge of particular
    threading systems. As such, in order for safe multi-threaded
    operation, we rely on callbacks to client provided functions.

    A client is expected to provide FZ_LOCK_MAX number of mutexes,
    and a function to lock/unlock each of them. These may be
    recursive mutexes, but do not have to be.

    If a client does not intend to use multiple threads, then it
    may pass NULL instead of a lock structure.

    In order to avoid deadlocks, we have one simple rule
    internally as to how we use locks: We can never take lock n
    when we already hold any lock i, where 0 <= i <= n. In order
    to verify this, we have some debugging code, that can be
    enabled by defining FITZ_DEBUG_LOCKING.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `fz_locks_context`."""
        _mupdf.LocksContext_swiginit(self, _mupdf.new_LocksContext(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.LocksContext_m_internal_value(self)
    m_internal = property(_mupdf.LocksContext_m_internal_get, _mupdf.LocksContext_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_LocksContext

# Register LocksContext in _mupdf:
_mupdf.LocksContext_swigregister(LocksContext)

class Matrix(object):
    r"""
     Wrapper class for struct `fz_matrix`.
    	fz_matrix is a row-major 3x3 matrix used for representing
    	transformations of coordinates throughout MuPDF.

    	Since all points reside in a two-dimensional space, one vector
    	is always a constant unit vector; hence only some elements may
    	vary in a matrix. Below is how the elements map between
    	different representations.

    a b 0
    	| c d 0 | normally represented as [ a b c d e f ].
    	\ e f 1 /
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def scale(sx, sy):
        r"""
        Wrapper for `fz_scale()`.
        	Create a scaling matrix.

        	The returned matrix is of the form [ sx 0 0 sy 0 0 ].

        	m: Pointer to the matrix to populate

        	sx, sy: Scaling factors along the X- and Y-axes. A scaling
        	factor of 1.0 will not cause any scaling along the relevant
        	axis.

        	Returns m.
        """
        return _mupdf.Matrix_scale(sx, sy)

    @staticmethod
    def shear(sx, sy):
        r"""
        Wrapper for `fz_shear()`.
        	Create a shearing matrix.

        	The returned matrix is of the form [ 1 sy sx 1 0 0 ].

        	m: pointer to place to store returned matrix

        	sx, sy: Shearing factors. A shearing factor of 0.0 will not
        	cause any shearing along the relevant axis.

        	Returns m.
        """
        return _mupdf.Matrix_shear(sx, sy)

    @staticmethod
    def rotate(degrees):
        r"""
        Wrapper for `fz_rotate()`.
        	Create a rotation matrix.

        	The returned matrix is of the form
        	[ cos(deg) sin(deg) -sin(deg) cos(deg) 0 0 ].

        	m: Pointer to place to store matrix

        	degrees: Degrees of counter clockwise rotation. Values less
        	than zero and greater than 360 are handled as expected.

        	Returns m.
        """
        return _mupdf.Matrix_rotate(degrees)

    @staticmethod
    def translate(tx, ty):
        r"""
        Wrapper for `fz_translate()`.
        	Create a translation matrix.

        	The returned matrix is of the form [ 1 0 0 1 tx ty ].

        	m: A place to store the created matrix.

        	tx, ty: Translation distances along the X- and Y-axes. A
        	translation of 0 will not cause any translation along the
        	relevant axis.

        	Returns m.
        """
        return _mupdf.Matrix_translate(tx, ty)

    @staticmethod
    def transform_page(mediabox, resolution, rotate):
        r"""
        Wrapper for `fz_transform_page()`.
        	Create transform matrix to draw page
        	at a given resolution and rotation. Adjusts the scaling
        	factors so that the page covers whole number of
        	pixels and adjust the page origin to be at 0,0.
        """
        return _mupdf.Matrix_transform_page(mediabox, resolution, rotate)

    def concat(self, *args):
        r"""
        *Overload 1:*
         We use default copy constructor and operator=.  Wrapper for `fz_concat()`.
        		Multiply two matrices.

        		The order of the two matrices are important since matrix
        		multiplication is not commutative.

        		Returns result.


        |

        *Overload 2:*
         Wrapper for `fz_concat()`.
        		Multiply two matrices.

        		The order of the two matrices are important since matrix
        		multiplication is not commutative.

        		Returns result.
        """
        return _mupdf.Matrix_concat(self, *args)

    def invert_matrix(self):
        r"""
        Wrapper for `fz_invert_matrix()`.
        	Create an inverse matrix.

        	inverse: Place to store inverse matrix.

        	matrix: Matrix to invert. A degenerate matrix, where the
        	determinant is equal to zero, can not be inverted and the
        	original matrix is returned instead.

        	Returns inverse.
        """
        return _mupdf.Matrix_invert_matrix(self)

    def is_identity(self):
        r""" Wrapper for `fz_is_identity()`."""
        return _mupdf.Matrix_is_identity(self)

    def is_rectilinear(self):
        r"""
        Wrapper for `fz_is_rectilinear()`.
        	Check if a transformation is rectilinear.

        	Rectilinear means that no shearing is present and that any
        	rotations present are a multiple of 90 degrees. Usually this
        	is used to make sure that axis-aligned rectangles before the
        	transformation are still axis-aligned rectangles afterwards.
        """
        return _mupdf.Matrix_is_rectilinear(self)

    def matrix_expansion(self):
        r"""
        Wrapper for `fz_matrix_expansion()`.
        	Calculate average scaling factor of matrix.
        """
        return _mupdf.Matrix_matrix_expansion(self)

    def matrix_max_expansion(self):
        r"""
        Wrapper for `fz_matrix_max_expansion()`.
        	Find the largest expansion performed by this matrix.
        	(i.e. max(abs(m.a),abs(m.b),abs(m.c),abs(m.d))
        """
        return _mupdf.Matrix_matrix_max_expansion(self)

    def post_scale(self, sx, sy):
        r"""
        Wrapper for `fz_post_scale()`.
        	Scale a matrix by postmultiplication.

        	m: Pointer to the matrix to scale

        	sx, sy: Scaling factors along the X- and Y-axes. A scaling
        	factor of 1.0 will not cause any scaling along the relevant
        	axis.

        	Returns m (updated).
        """
        return _mupdf.Matrix_post_scale(self, sx, sy)

    def pre_rotate(self, degrees):
        r"""
        Wrapper for `fz_pre_rotate()`.
        	Rotate a transformation by premultiplying.

        	The premultiplied matrix is of the form
        	[ cos(deg) sin(deg) -sin(deg) cos(deg) 0 0 ].

        	m: Pointer to matrix to premultiply.

        	degrees: Degrees of counter clockwise rotation. Values less
        	than zero and greater than 360 are handled as expected.

        	Returns m (updated).
        """
        return _mupdf.Matrix_pre_rotate(self, degrees)

    def pre_scale(self, sx, sy):
        r"""
        Wrapper for `fz_pre_scale()`.
        	Scale a matrix by premultiplication.

        	m: Pointer to the matrix to scale

        	sx, sy: Scaling factors along the X- and Y-axes. A scaling
        	factor of 1.0 will not cause any scaling along the relevant
        	axis.

        	Returns m (updated).
        """
        return _mupdf.Matrix_pre_scale(self, sx, sy)

    def pre_shear(self, sx, sy):
        r"""
        Wrapper for `fz_pre_shear()`.
        	Premultiply a matrix with a shearing matrix.

        	The shearing matrix is of the form [ 1 sy sx 1 0 0 ].

        	m: pointer to matrix to premultiply

        	sx, sy: Shearing factors. A shearing factor of 0.0 will not
        	cause any shearing along the relevant axis.

        	Returns m (updated).
        """
        return _mupdf.Matrix_pre_shear(self, sx, sy)

    def pre_translate(self, tx, ty):
        r"""
        Wrapper for `fz_pre_translate()`.
        	Translate a matrix by premultiplication.

        	m: The matrix to translate

        	tx, ty: Translation distances along the X- and Y-axes. A
        	translation of 0 will not cause any translation along the
        	relevant axis.

        	Returns m.
        """
        return _mupdf.Matrix_pre_translate(self, tx, ty)

    def subpixel_adjust(self, subpix_ctm, qe, qf):
        r"""
        Wrapper for `fz_subpixel_adjust()`.
        	Perform subpixel quantisation and adjustment on a glyph matrix.

        	ctm: On entry, the desired 'ideal' transformation for a glyph.
        	On exit, adjusted to a (very similar) transformation quantised
        	for subpixel caching.

        	subpix_ctm: Initialised by the routine to the transform that
        	should be used to render the glyph.

        	qe, qf: which subpixel position we quantised to.

        	Returns: the size of the glyph.

        	Note: This is currently only exposed for use in our app. It
        	should be considered "at risk" of removal from the API.
        """
        return _mupdf.Matrix_subpixel_adjust(self, subpix_ctm, qe, qf)

    def try_invert_matrix(self, src):
        r"""
        Wrapper for `fz_try_invert_matrix()`.
        	Attempt to create an inverse matrix.

        	inverse: Place to store inverse matrix.

        	matrix: Matrix to invert. A degenerate matrix, where the
        	determinant is equal to zero, can not be inverted.

        	Returns 1 if matrix is degenerate (singular), or 0 otherwise.
        """
        return _mupdf.Matrix_try_invert_matrix(self, src)

    def __init__(self, *args):
        r"""
        *Overload 1:*
        == Constructors.  Constructor using `fz_make_matrix()`.

        |

        *Overload 2:*
        Constructs identity matrix (like fz_identity).

        |

        *Overload 3:*
        Constructor using raw copy of pre-existing `fz_matrix`.

        |

        *Overload 4:*
        Constructor using raw copy of pre-existing `fz_matrix`.
        """
        _mupdf.Matrix_swiginit(self, _mupdf.new_Matrix(*args))

    def internal(self, *args):
        r"""
        *Overload 1:*
        Access as underlying struct.

        |

        *Overload 2:*
        Access as underlying struct.
        """
        return _mupdf.Matrix_internal(self, *args)
    a = property(_mupdf.Matrix_a_get, _mupdf.Matrix_a_set, doc=r""" We use default destructor.""")
    b = property(_mupdf.Matrix_b_get, _mupdf.Matrix_b_set)
    c = property(_mupdf.Matrix_c_get, _mupdf.Matrix_c_set)
    d = property(_mupdf.Matrix_d_get, _mupdf.Matrix_d_set)
    e = property(_mupdf.Matrix_e_get, _mupdf.Matrix_e_set)
    f = property(_mupdf.Matrix_f_get, _mupdf.Matrix_f_set)

    def to_string(self):
        r""" Returns string containing our members, labelled and inside (...), using operator<<."""
        return _mupdf.Matrix_to_string(self)
    __swig_destroy__ = _mupdf.delete_Matrix

# Register Matrix in _mupdf:
_mupdf.Matrix_swigregister(Matrix)

def Matrix_scale(sx, sy):
    r"""
    Wrapper for `fz_scale()`.
    	Create a scaling matrix.

    	The returned matrix is of the form [ sx 0 0 sy 0 0 ].

    	m: Pointer to the matrix to populate

    	sx, sy: Scaling factors along the X- and Y-axes. A scaling
    	factor of 1.0 will not cause any scaling along the relevant
    	axis.

    	Returns m.
    """
    return _mupdf.Matrix_scale(sx, sy)

def Matrix_shear(sx, sy):
    r"""
    Wrapper for `fz_shear()`.
    	Create a shearing matrix.

    	The returned matrix is of the form [ 1 sy sx 1 0 0 ].

    	m: pointer to place to store returned matrix

    	sx, sy: Shearing factors. A shearing factor of 0.0 will not
    	cause any shearing along the relevant axis.

    	Returns m.
    """
    return _mupdf.Matrix_shear(sx, sy)

def Matrix_rotate(degrees):
    r"""
    Wrapper for `fz_rotate()`.
    	Create a rotation matrix.

    	The returned matrix is of the form
    	[ cos(deg) sin(deg) -sin(deg) cos(deg) 0 0 ].

    	m: Pointer to place to store matrix

    	degrees: Degrees of counter clockwise rotation. Values less
    	than zero and greater than 360 are handled as expected.

    	Returns m.
    """
    return _mupdf.Matrix_rotate(degrees)

def Matrix_translate(tx, ty):
    r"""
    Wrapper for `fz_translate()`.
    	Create a translation matrix.

    	The returned matrix is of the form [ 1 0 0 1 tx ty ].

    	m: A place to store the created matrix.

    	tx, ty: Translation distances along the X- and Y-axes. A
    	translation of 0 will not cause any translation along the
    	relevant axis.

    	Returns m.
    """
    return _mupdf.Matrix_translate(tx, ty)

def Matrix_transform_page(mediabox, resolution, rotate):
    r"""
    Wrapper for `fz_transform_page()`.
    	Create transform matrix to draw page
    	at a given resolution and rotation. Adjusts the scaling
    	factors so that the page covers whole number of
    	pixels and adjust the page origin to be at 0,0.
    """
    return _mupdf.Matrix_transform_page(mediabox, resolution, rotate)

class Md5(object):
    r"""
    Wrapper class for struct `fz_md5`.
    Structure definition is public to enable stack
    based allocation. Do not access the members directly.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def md5_final(self, digest):
        r"""
        We use default copy constructor and operator=.  Wrapper for `fz_md5_final()`.
        	MD5 finalization. Ends an MD5 message-digest operation, writing
        	the message digest and zeroizing the context.

        	Never throws an exception.
        """
        return _mupdf.Md5_md5_final(self, digest)

    def md5_init(self):
        r"""
        Wrapper for `fz_md5_init()`.
        	MD5 initialization. Begins an MD5 operation, writing a new
        	context.

        	Never throws an exception.
        """
        return _mupdf.Md5_md5_init(self)

    def md5_update(self, input, inlen):
        r"""
        Wrapper for `fz_md5_update()`.
        	MD5 block update operation. Continues an MD5 message-digest
        	operation, processing another message block, and updating the
        	context.

        	Never throws an exception.
        """
        return _mupdf.Md5_md5_update(self, input, inlen)

    def md5_update_int64(self, i):
        r"""
        Wrapper for `fz_md5_update_int64()`.
        	MD5 block update operation. Continues an MD5 message-digest
        	operation, processing an int64, and updating the context.

        	Never throws an exception.
        """
        return _mupdf.Md5_md5_update_int64(self, i)

    def md5_final2(self):
        r""" Wrapper for fz_md5_final() that returns the digest by value."""
        return _mupdf.Md5_md5_final2(self)

    def __init__(self, *args):
        r"""
        *Overload 1:*
        Default constructor calls md5_init().

        |

        *Overload 2:*
        Constructor using raw copy of pre-existing `fz_md5`.
        """
        _mupdf.Md5_swiginit(self, _mupdf.new_Md5(*args))

    def lo(self):
        return _mupdf.Md5_lo(self)

    def hi(self):
        return _mupdf.Md5_hi(self)

    def a(self):
        return _mupdf.Md5_a(self)

    def b(self):
        return _mupdf.Md5_b(self)

    def c(self):
        return _mupdf.Md5_c(self)

    def d(self):
        return _mupdf.Md5_d(self)

    def buffer(self):
        return _mupdf.Md5_buffer(self)
    m_internal = property(_mupdf.Md5_m_internal_get, _mupdf.Md5_m_internal_set, doc=r""" We use default destructor.""")

    def to_string(self):
        r""" Wrapped data is held by value.  Returns string containing our members, labelled and inside (...), using operator<<."""
        return _mupdf.Md5_to_string(self)
    __swig_destroy__ = _mupdf.delete_Md5

# Register Md5 in _mupdf:
_mupdf.Md5_swigregister(Md5)

class Outline(object):
    r"""
    Wrapper class for struct `fz_outline`.
    fz_outline is a tree of the outline of a document (also known
    as table of contents).

    title: Title of outline item using UTF-8 encoding. May be NULL
    if the outline item has no text string.

    uri: Destination in the document to be displayed when this
    outline item is activated. May be an internal or external
    link, or NULL if the outline item does not have a destination.

    page: The page number of an internal link, or -1 for external
    links or links with no destination.

    next: The next outline item at the same level as this outline
    item. May be NULL if no more outline items exist at this level.

    down: The outline items immediate children in the hierarchy.
    May be NULL if no children exist.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*
         == Constructors.  Constructor using `fz_load_outline()`.
        		Load the hierarchical document outline.

        		Should be freed by fz_drop_outline.


        |

        *Overload 2:*
         Constructor using `fz_load_outline_from_iterator()`.
        		Routine to implement the old Structure based API from an iterator.


        |

        *Overload 3:*
         Constructor using `fz_new_outline()`.
        		Create a new outline entry with zeroed fields for the caller
        		to fill in.


        |

        *Overload 4:*
         Copy constructor using `fz_keep_outline()`.

        |

        *Overload 5:*
         Constructor using raw copy of pre-existing `fz_outline`.
        """
        _mupdf.Outline_swiginit(self, _mupdf.new_Outline(*args))

    def refs(self):
        return _mupdf.Outline_refs(self)

    def title(self):
        return _mupdf.Outline_title(self)

    def uri(self):
        return _mupdf.Outline_uri(self)

    def page(self):
        return _mupdf.Outline_page(self)

    def x(self):
        return _mupdf.Outline_x(self)

    def y(self):
        return _mupdf.Outline_y(self)

    def next(self):
        return _mupdf.Outline_next(self)

    def down(self):
        return _mupdf.Outline_down(self)

    def is_open(self):
        return _mupdf.Outline_is_open(self)
    __swig_destroy__ = _mupdf.delete_Outline

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.Outline_m_internal_value(self)
    m_internal = property(_mupdf.Outline_m_internal_get, _mupdf.Outline_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register Outline in _mupdf:
_mupdf.Outline_swigregister(Outline)

class OutlineItem(object):
    r""" Wrapper class for struct `fz_outline_item`."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def valid(self):
        return _mupdf.OutlineItem_valid(self)

    def title(self):
        return _mupdf.OutlineItem_title(self)

    def uri(self):
        return _mupdf.OutlineItem_uri(self)

    def is_open(self):
        return _mupdf.OutlineItem_is_open(self)

    def __init__(self, internal):
        r""" We use default copy constructor and operator=.  Constructor using raw copy of pre-existing `fz_outline_item`."""
        _mupdf.OutlineItem_swiginit(self, _mupdf.new_OutlineItem(internal))
    __swig_destroy__ = _mupdf.delete_OutlineItem

# Register OutlineItem in _mupdf:
_mupdf.OutlineItem_swigregister(OutlineItem)

class OutlineIterator(object):
    r""" Wrapper class for struct `fz_outline_iterator`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def load_outline_from_iterator(self):
        r"""
        Wrapper for `fz_load_outline_from_iterator()`.
        	Routine to implement the old Structure based API from an iterator.
        """
        return _mupdf.OutlineIterator_load_outline_from_iterator(self)

    def outline_iterator_delete(self):
        r"""
        Wrapper for `fz_outline_iterator_delete()`.
        	Delete the current item.

        	This implicitly moves us to the 'next' item, and the return code is as for fz_outline_iterator_next.
        """
        return _mupdf.OutlineIterator_outline_iterator_delete(self)

    def outline_iterator_down(self):
        r""" Wrapper for `fz_outline_iterator_down()`."""
        return _mupdf.OutlineIterator_outline_iterator_down(self)

    def outline_iterator_item(self):
        r"""
        Wrapper for `fz_outline_iterator_item()`.
        	Call to get the current outline item.

        	Can return NULL. The item is only valid until the next call.
        """
        return _mupdf.OutlineIterator_outline_iterator_item(self)

    def outline_iterator_next(self):
        r"""
        Wrapper for `fz_outline_iterator_next()`.
        	Calls to move the iterator position.

        	A negative return value means we could not move as requested. Otherwise:
        	0 = the final position has a valid item.
        	1 = not a valid item, but we can insert an item here.
        """
        return _mupdf.OutlineIterator_outline_iterator_next(self)

    def outline_iterator_prev(self):
        r""" Wrapper for `fz_outline_iterator_prev()`."""
        return _mupdf.OutlineIterator_outline_iterator_prev(self)

    def outline_iterator_up(self):
        r""" Wrapper for `fz_outline_iterator_up()`."""
        return _mupdf.OutlineIterator_outline_iterator_up(self)

    def outline_iterator_insert(self, item):
        r""" Custom wrapper for fz_outline_iterator_insert()."""
        return _mupdf.OutlineIterator_outline_iterator_insert(self, item)

    def outline_iterator_update(self, item):
        r""" Custom wrapper for fz_outline_iterator_update()."""
        return _mupdf.OutlineIterator_outline_iterator_update(self, item)

    def __init__(self, *args):
        r"""
        *Overload 1:*
         == Constructors.  Constructor using `fz_new_outline_iterator()`.
        		Get an iterator for the document outline.

        		Should be freed by fz_drop_outline_iterator.


        |

        *Overload 2:*
         Constructor using `fz_new_outline_iterator_of_size()`.

        |

        *Overload 3:*
         Constructor using raw copy of pre-existing `fz_outline_iterator`.
        """
        _mupdf.OutlineIterator_swiginit(self, _mupdf.new_OutlineIterator(*args))
    __swig_destroy__ = _mupdf.delete_OutlineIterator

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.OutlineIterator_m_internal_value(self)
    m_internal = property(_mupdf.OutlineIterator_m_internal_get, _mupdf.OutlineIterator_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register OutlineIterator in _mupdf:
_mupdf.OutlineIterator_swigregister(OutlineIterator)

class Output(object):
    r""" Wrapper class for struct `fz_output`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    Fixed_STDOUT = _mupdf.Output_Fixed_STDOUT
    Fixed_STDERR = _mupdf.Output_Fixed_STDERR
    Filter_HEX = _mupdf.Output_Filter_HEX
    Filter_85 = _mupdf.Output_Filter_85
    Filter_RLE = _mupdf.Output_Filter_RLE

    def close_output(self):
        r"""
        Wrapper for `fz_close_output()`.
        	Flush pending output and close an output stream.
        """
        return _mupdf.Output_close_output(self)

    def debug_store(self):
        r"""
        Wrapper for `fz_debug_store()`.
        	Output debugging information for the current state of the store
        	to the given output channel.
        """
        return _mupdf.Output_debug_store(self)

    def dump_glyph_cache_stats(self):
        r"""
        Wrapper for `fz_dump_glyph_cache_stats()`.
        	Dump debug statistics for the glyph cache.
        """
        return _mupdf.Output_dump_glyph_cache_stats(self)

    def flush_output(self):
        r"""
        Wrapper for `fz_flush_output()`.
        	Flush unwritten data.
        """
        return _mupdf.Output_flush_output(self)

    def new_svg_device(self, page_width, page_height, text_format, reuse_images):
        r"""
        Wrapper for `fz_new_svg_device()`.
        	Create a device that outputs (single page) SVG files to
        	the given output stream.

        	Equivalent to fz_new_svg_device_with_id passing id = NULL.
        """
        return _mupdf.Output_new_svg_device(self, page_width, page_height, text_format, reuse_images)

    def new_svg_device_with_id(self, page_width, page_height, text_format, reuse_images):
        r"""
        Wrapper for `fz_new_svg_device_with_id()`.

        This method has out-params. Python/C# wrappers look like:
        	`new_svg_device_with_id(float page_width, float page_height, int text_format, int reuse_images)` => `(fz_device *, int id)`

        	Create a device that outputs (single page) SVG files to
        	the given output stream.

        	output: The output stream to send the constructed SVG page to.

        	page_width, page_height: The page dimensions to use (in points).

        	text_format: How to emit text. One of the following values:
        		FZ_SVG_TEXT_AS_TEXT: As <text> elements with possible
        		layout errors and mismatching fonts.
        		FZ_SVG_TEXT_AS_PATH: As <path> elements with exact
        		visual appearance.

        	reuse_images: Share image resources using <symbol> definitions.

        	id: ID parameter to keep generated IDs unique across SVG files.
        """
        return _mupdf.Output_new_svg_device_with_id(self, page_width, page_height, text_format, reuse_images)

    def new_trace_device(self):
        r"""
        Wrapper for `fz_new_trace_device()`.
        	Create a device to print a debug trace of all device calls.
        """
        return _mupdf.Output_new_trace_device(self)

    def new_xmltext_device(self):
        r"""
        Wrapper for `fz_new_xmltext_device()`.
        	Create a device to output raw information.
        """
        return _mupdf.Output_new_xmltext_device(self)

    def output_supports_stream(self):
        r"""
        Wrapper for `fz_output_supports_stream()`.
        	Query whether a given fz_output supports fz_stream_from_output.
        """
        return _mupdf.Output_output_supports_stream(self)

    def print_stext_header_as_html(self):
        r""" Wrapper for `fz_print_stext_header_as_html()`."""
        return _mupdf.Output_print_stext_header_as_html(self)

    def print_stext_header_as_xhtml(self):
        r""" Wrapper for `fz_print_stext_header_as_xhtml()`."""
        return _mupdf.Output_print_stext_header_as_xhtml(self)

    def print_stext_page_as_html(self, page, id):
        r"""
        Wrapper for `fz_print_stext_page_as_html()`.
        	Output structured text to a file in HTML (visual) format.
        """
        return _mupdf.Output_print_stext_page_as_html(self, page, id)

    def print_stext_page_as_json(self, page, scale):
        r"""
        Wrapper for `fz_print_stext_page_as_json()`.
        	Output structured text to a file in JSON format.
        """
        return _mupdf.Output_print_stext_page_as_json(self, page, scale)

    def print_stext_page_as_text(self, page):
        r"""
        Wrapper for `fz_print_stext_page_as_text()`.
        	Output structured text to a file in plain-text UTF-8 format.
        """
        return _mupdf.Output_print_stext_page_as_text(self, page)

    def print_stext_page_as_xhtml(self, page, id):
        r"""
        Wrapper for `fz_print_stext_page_as_xhtml()`.
        	Output structured text to a file in XHTML (semantic) format.
        """
        return _mupdf.Output_print_stext_page_as_xhtml(self, page, id)

    def print_stext_page_as_xml(self, page, id):
        r"""
        Wrapper for `fz_print_stext_page_as_xml()`.
        	Output structured text to a file in XML format.
        """
        return _mupdf.Output_print_stext_page_as_xml(self, page, id)

    def print_stext_trailer_as_html(self):
        r""" Wrapper for `fz_print_stext_trailer_as_html()`."""
        return _mupdf.Output_print_stext_trailer_as_html(self)

    def print_stext_trailer_as_xhtml(self):
        r""" Wrapper for `fz_print_stext_trailer_as_xhtml()`."""
        return _mupdf.Output_print_stext_trailer_as_xhtml(self)

    def seek_output(self, off, whence):
        r"""
        Wrapper for `fz_seek_output()`.
        	Seek to the specified file position.
        	See fseek for arguments.

        	Throw an error on unseekable outputs.
        """
        return _mupdf.Output_seek_output(self, off, whence)

    def set_stddbg(self):
        r"""
        Wrapper for `fz_set_stddbg()`.
        	Set the output stream to be used for fz_stddbg. Set to NULL to
        	reset to default (stderr).
        """
        return _mupdf.Output_set_stddbg(self)

    def stream_from_output(self):
        r"""
        Wrapper for `fz_stream_from_output()`.
        	Obtain the fz_output in the form of a fz_stream.

        	This allows data to be read back from some forms of fz_output
        	object. When finished reading, the fz_stream should be released
        	by calling fz_drop_stream. Until the fz_stream is dropped, no
        	further operations should be performed on the fz_output object.
        """
        return _mupdf.Output_stream_from_output(self)

    def tell_output(self):
        r"""
        Wrapper for `fz_tell_output()`.
        	Return the current file position.

        	Throw an error on untellable outputs.
        """
        return _mupdf.Output_tell_output(self)

    def truncate_output(self):
        r"""
        Wrapper for `fz_truncate_output()`.
        	Truncate the output at the current position.

        	This allows output streams which have seeked back from the end
        	of their storage to be truncated at the current point.
        """
        return _mupdf.Output_truncate_output(self)

    def write_base64(self, data, size, newline):
        r"""
        Wrapper for `fz_write_base64()`.
        	Write a base64 encoded data block, optionally with periodic
        	newlines.
        """
        return _mupdf.Output_write_base64(self, data, size, newline)

    def write_base64_buffer(self, data, newline):
        r"""
        Wrapper for `fz_write_base64_buffer()`.
        	Write a base64 encoded fz_buffer, optionally with periodic
        	newlines.
        """
        return _mupdf.Output_write_base64_buffer(self, data, newline)

    def write_bitmap_as_pbm(self, bitmap):
        r"""
        Wrapper for `fz_write_bitmap_as_pbm()`.
        	Write a bitmap as a pbm.
        """
        return _mupdf.Output_write_bitmap_as_pbm(self, bitmap)

    def write_bitmap_as_pcl(self, bitmap, pcl):
        r"""
        Wrapper for `fz_write_bitmap_as_pcl()`.
        	Write a bitmap as mono PCL.
        """
        return _mupdf.Output_write_bitmap_as_pcl(self, bitmap, pcl)

    def write_bitmap_as_pkm(self, bitmap):
        r"""
        Wrapper for `fz_write_bitmap_as_pkm()`.
        	Write a CMYK bitmap as a pkm.
        """
        return _mupdf.Output_write_bitmap_as_pkm(self, bitmap)

    def write_bitmap_as_pwg(self, bitmap, pwg):
        r"""
        Wrapper for `fz_write_bitmap_as_pwg()`.
        	Write a bitmap as a PWG.
        """
        return _mupdf.Output_write_bitmap_as_pwg(self, bitmap, pwg)

    def write_bitmap_as_pwg_page(self, bitmap, pwg):
        r"""
        Wrapper for `fz_write_bitmap_as_pwg_page()`.
        	Write a bitmap as a PWG page.

        	Caller should provide a file header by calling
        	fz_write_pwg_file_header, but can then write several pages to
        	the same file.
        """
        return _mupdf.Output_write_bitmap_as_pwg_page(self, bitmap, pwg)

    def write_byte(self, x):
        r""" Wrapper for `fz_write_byte()`."""
        return _mupdf.Output_write_byte(self, x)

    def write_char(self, x):
        r""" Wrapper for `fz_write_char()`."""
        return _mupdf.Output_write_char(self, x)

    def write_data(self, data, size):
        r"""
        Wrapper for `fz_write_data()`.
        	Write data to output.

        	data: Pointer to data to write.
        	size: Size of data to write in bytes.
        """
        return _mupdf.Output_write_data(self, data, size)

    def write_float_be(self, f):
        r""" Wrapper for `fz_write_float_be()`."""
        return _mupdf.Output_write_float_be(self, f)

    def write_float_le(self, f):
        r""" Wrapper for `fz_write_float_le()`."""
        return _mupdf.Output_write_float_le(self, f)

    def write_image_as_data_uri(self, image):
        r"""
        Wrapper for `fz_write_image_as_data_uri()`.
        	Write image as a data URI (for HTML and SVG output).
        """
        return _mupdf.Output_write_image_as_data_uri(self, image)

    def write_int16_be(self, x):
        r""" Wrapper for `fz_write_int16_be()`."""
        return _mupdf.Output_write_int16_be(self, x)

    def write_int16_le(self, x):
        r""" Wrapper for `fz_write_int16_le()`."""
        return _mupdf.Output_write_int16_le(self, x)

    def write_int32_be(self, x):
        r"""
        Wrapper for `fz_write_int32_be()`.
        	Write different sized data to an output stream.
        """
        return _mupdf.Output_write_int32_be(self, x)

    def write_int32_le(self, x):
        r""" Wrapper for `fz_write_int32_le()`."""
        return _mupdf.Output_write_int32_le(self, x)

    def write_pixmap_as_data_uri(self, pixmap):
        r""" Wrapper for `fz_write_pixmap_as_data_uri()`."""
        return _mupdf.Output_write_pixmap_as_data_uri(self, pixmap)

    def write_pixmap_as_pam(self, pixmap):
        r"""
        Wrapper for `fz_write_pixmap_as_pam()`.
        	Write a pixmap as a pnm (greyscale, rgb or cmyk, with or without
        	alpha).
        """
        return _mupdf.Output_write_pixmap_as_pam(self, pixmap)

    def write_pixmap_as_pcl(self, pixmap, pcl):
        r"""
        Wrapper for `fz_write_pixmap_as_pcl()`.
        	Write an (RGB) pixmap as color PCL.
        """
        return _mupdf.Output_write_pixmap_as_pcl(self, pixmap, pcl)

    def write_pixmap_as_pclm(self, pixmap, options):
        r"""
        Wrapper for `fz_write_pixmap_as_pclm()`.
        	Write a (Greyscale or RGB) pixmap as pclm.
        """
        return _mupdf.Output_write_pixmap_as_pclm(self, pixmap, options)

    def write_pixmap_as_pdfocr(self, pixmap, options):
        r"""
        Wrapper for `fz_write_pixmap_as_pdfocr()`.
        	Write a (Greyscale or RGB) pixmap as pdfocr.
        """
        return _mupdf.Output_write_pixmap_as_pdfocr(self, pixmap, options)

    def write_pixmap_as_png(self, pixmap):
        r"""
        Wrapper for `fz_write_pixmap_as_png()`.
        	Write a (Greyscale or RGB) pixmap as a png.
        """
        return _mupdf.Output_write_pixmap_as_png(self, pixmap)

    def write_pixmap_as_pnm(self, pixmap):
        r"""
        Wrapper for `fz_write_pixmap_as_pnm()`.
        	Write a pixmap as a pnm (greyscale or rgb, no alpha).
        """
        return _mupdf.Output_write_pixmap_as_pnm(self, pixmap)

    def write_pixmap_as_ps(self, pixmap):
        r"""
        Wrapper for `fz_write_pixmap_as_ps()`.
        	Write a (gray, rgb, or cmyk, no alpha) pixmap out as postscript.
        """
        return _mupdf.Output_write_pixmap_as_ps(self, pixmap)

    def write_pixmap_as_psd(self, pixmap):
        r"""
        Wrapper for `fz_write_pixmap_as_psd()`.
        	Write a pixmap as a PSD file.
        """
        return _mupdf.Output_write_pixmap_as_psd(self, pixmap)

    def write_pixmap_as_pwg(self, pixmap, pwg):
        r"""
        Wrapper for `fz_write_pixmap_as_pwg()`.
        	Write a pixmap as a PWG.
        """
        return _mupdf.Output_write_pixmap_as_pwg(self, pixmap, pwg)

    def write_pixmap_as_pwg_page(self, pixmap, pwg):
        r"""
        Wrapper for `fz_write_pixmap_as_pwg_page()`.
        	Write a pixmap as a PWG page.

        	Caller should provide a file header by calling
        	fz_write_pwg_file_header, but can then write several pages to
        	the same file.
        """
        return _mupdf.Output_write_pixmap_as_pwg_page(self, pixmap, pwg)

    def write_ps_file_header(self):
        r"""
        Wrapper for `fz_write_ps_file_header()`.
        	Write the file level header for ps band writer output.
        """
        return _mupdf.Output_write_ps_file_header(self)

    def write_ps_file_trailer(self, pages):
        r"""
        Wrapper for `fz_write_ps_file_trailer()`.
        	Write the file level trailer for ps band writer output.
        """
        return _mupdf.Output_write_ps_file_trailer(self, pages)

    def write_pwg_file_header(self):
        r"""
        Wrapper for `fz_write_pwg_file_header()`.
        	Output the file header to a pwg stream, ready for pages to follow it.
        """
        return _mupdf.Output_write_pwg_file_header(self)

    def write_rune(self, rune):
        r"""
        Wrapper for `fz_write_rune()`.
        	Write a UTF-8 encoded unicode character.
        """
        return _mupdf.Output_write_rune(self, rune)

    def write_string(self, s):
        r"""
        Wrapper for `fz_write_string()`.
        	Write a string. Does not write zero terminator.
        """
        return _mupdf.Output_write_string(self, s)

    def write_uint16_be(self, x):
        r""" Wrapper for `fz_write_uint16_be()`."""
        return _mupdf.Output_write_uint16_be(self, x)

    def write_uint16_le(self, x):
        r""" Wrapper for `fz_write_uint16_le()`."""
        return _mupdf.Output_write_uint16_le(self, x)

    def write_uint32_be(self, x):
        r""" Wrapper for `fz_write_uint32_be()`."""
        return _mupdf.Output_write_uint32_be(self, x)

    def write_uint32_le(self, x):
        r""" Wrapper for `fz_write_uint32_le()`."""
        return _mupdf.Output_write_uint32_le(self, x)

    def new_output_processor(self, ahxencode):
        r""" Wrapper for `pdf_new_output_processor()`."""
        return _mupdf.Output_new_output_processor(self, ahxencode)

    def print_crypt(self, crypt):
        r""" Wrapper for `pdf_print_crypt()`."""
        return _mupdf.Output_print_crypt(self, crypt)

    def print_encrypted_obj(self, obj, tight, ascii, crypt, num, gen):
        r""" Wrapper for `pdf_print_encrypted_obj()`."""
        return _mupdf.Output_print_encrypted_obj(self, obj, tight, ascii, crypt, num, gen)

    def print_font(self, fontdesc):
        r""" Wrapper for `pdf_print_font()`."""
        return _mupdf.Output_print_font(self, fontdesc)

    def print_obj(self, obj, tight, ascii):
        r""" Wrapper for `pdf_print_obj()`."""
        return _mupdf.Output_print_obj(self, obj, tight, ascii)

    def write_digest(self, byte_range, field, digest_offset, digest_length, signer):
        r""" Wrapper for `pdf_write_digest()`."""
        return _mupdf.Output_write_digest(self, byte_range, field, digest_offset, digest_length, signer)

    def __init__(self, *args):
        r"""
        *Overload 1:*
         == Constructors.  Constructor using `fz_new_arc4_output()`.

        |

        *Overload 2:*
         Constructor using `fz_new_deflate_output()`.

        |

        *Overload 3:*
         Constructor using `fz_new_log_for_module()`.
        		Internal function to actually do the opening of the logfile.

        		Caller should close/drop the output when finished with it.


        |

        *Overload 4:*
         Constructor using `fz_new_output()`.
        		Create a new output object with the given
        		internal state and function pointers.

        		state: Internal state (opaque to everything but implementation).

        		write: Function to output a given buffer.

        		close: Cleanup function to destroy state when output closed.
        		May permissibly be null.


        |

        *Overload 5:*
         Constructor using `fz_new_output_with_buffer()`.
        		Open an output stream that appends
        		to a buffer.

        		buf: The buffer to append to.


        |

        *Overload 6:*
         Constructor using `fz_new_output_with_path()`.
        		Open an output stream that writes to a
        		given path.

        		filename: The filename to write to (specified in UTF-8).

        		append: non-zero if we should append to the file, rather than
        		overwriting it.


        |

        *Overload 7:*
         Uses fz_stdout() or fz_stderr().

        |

        *Overload 8:*
         Calls one of: fz_new_asciihex_output(), fz_new_ascii85_output(), fz_new_rle_output().

        |

        *Overload 9:*
         Constructor using raw copy of pre-existing `fz_output`.

        |

        *Overload 10:*
         Constructor using raw copy of pre-existing `fz_output`.
        """
        _mupdf.Output_swiginit(self, _mupdf.new_Output(*args))
    __swig_destroy__ = _mupdf.delete_Output

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.Output_m_internal_value(self)
    m_internal = property(_mupdf.Output_m_internal_get, _mupdf.Output_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register Output in _mupdf:
_mupdf.Output_swigregister(Output)

class Output2(Output):
    r""" Wrapper class for struct fz_output with virtual fns for each fnptr; this is for use as a SWIG Director class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" == Constructor."""
        if self.__class__ == Output2:
            _self = None
        else:
            _self = self
        _mupdf.Output2_swiginit(self, _mupdf.new_Output2(_self, ))

    def use_virtual_write(self, use=True):
        r"""
        These methods set the function pointers in *m_internal
        to point to internal callbacks that call our virtual methods.
        """
        return _mupdf.Output2_use_virtual_write(self, use)

    def use_virtual_seek(self, use=True):
        return _mupdf.Output2_use_virtual_seek(self, use)

    def use_virtual_tell(self, use=True):
        return _mupdf.Output2_use_virtual_tell(self, use)

    def use_virtual_close(self, use=True):
        return _mupdf.Output2_use_virtual_close(self, use)

    def use_virtual_drop(self, use=True):
        return _mupdf.Output2_use_virtual_drop(self, use)

    def use_virtual_as_stream(self, use=True):
        return _mupdf.Output2_use_virtual_as_stream(self, use)

    def use_virtual_truncate(self, use=True):
        return _mupdf.Output2_use_virtual_truncate(self, use)

    def write(self, arg_2, arg_3):
        r""" Default virtual method implementations; these all throw an exception."""
        return _mupdf.Output2_write(self, arg_2, arg_3)

    def seek(self, arg_2, arg_3):
        return _mupdf.Output2_seek(self, arg_2, arg_3)

    def tell(self):
        return _mupdf.Output2_tell(self)

    def close(self):
        return _mupdf.Output2_close(self)

    def drop(self):
        return _mupdf.Output2_drop(self)

    def as_stream(self):
        return _mupdf.Output2_as_stream(self)
    __swig_destroy__ = _mupdf.delete_Output2
    def __disown__(self):
        self.this.disown()
        _mupdf.disown_Output2(self)
        return weakref.proxy(self)

# Register Output2 in _mupdf:
_mupdf.Output2_swigregister(Output2)

class Overprint(object):
    r"""
    Wrapper class for struct `fz_overprint`. Not copyable or assignable.
    Pixmaps represent a set of pixels for a 2 dimensional region of
    a plane. Each pixel has n components per pixel. The components
    are in the order process-components, spot-colors, alpha, where
    there can be 0 of any of those types. The data is in
    premultiplied alpha when rendering, but non-premultiplied for
    colorspace conversions and rescaling.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `fz_overprint`."""
        _mupdf.Overprint_swiginit(self, _mupdf.new_Overprint(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.Overprint_m_internal_value(self)
    m_internal = property(_mupdf.Overprint_m_internal_get, _mupdf.Overprint_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_Overprint

# Register Overprint in _mupdf:
_mupdf.Overprint_swigregister(Overprint)

class Page(object):
    r""" Wrapper class for struct `fz_page`."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def bound_page(self):
        r"""
        Wrapper for `fz_bound_page()`.
        	Determine the size of a page at 72 dpi.
        """
        return _mupdf.Page_bound_page(self)

    def create_link(self, bbox, uri):
        r"""
        Wrapper for `fz_create_link()`.
        	Create a new link on a page.
        """
        return _mupdf.Page_create_link(self, bbox, uri)

    def load_links(self):
        r"""
        Wrapper for `fz_load_links()`.
        	Load the list of links for a page.

        	Returns a linked list of all the links on the page, each with
        	its clickable region and link destination. Each link is
        	reference counted so drop and free the list of links by
        	calling fz_drop_link on the pointer return from fz_load_links.

        	page: Page obtained from fz_load_page.
        """
        return _mupdf.Page_load_links(self)

    def new_buffer_from_page(self, options):
        r""" Wrapper for `fz_new_buffer_from_page()`."""
        return _mupdf.Page_new_buffer_from_page(self, options)

    def new_buffer_from_page_with_format(self, format, options, transform, cookie):
        r"""
        Wrapper for `fz_new_buffer_from_page_with_format()`.
        	Returns an fz_buffer containing a page after conversion to specified format.

        	page: The page to convert.
        	format, options: Passed to fz_new_document_writer_with_output() internally.
        	transform, cookie: Passed to fz_run_page() internally.
        """
        return _mupdf.Page_new_buffer_from_page_with_format(self, format, options, transform, cookie)

    def new_display_list_from_page(self):
        r"""
        Wrapper for `fz_new_display_list_from_page()`.
        	Create a display list.

        	Ownership of the display list is returned to the caller.
        """
        return _mupdf.Page_new_display_list_from_page(self)

    def new_display_list_from_page_contents(self):
        r"""
        Wrapper for `fz_new_display_list_from_page_contents()`.
        	Create a display list from page contents (no annotations).

        	Ownership of the display list is returned to the caller.
        """
        return _mupdf.Page_new_display_list_from_page_contents(self)

    def new_pixmap_from_page(self, ctm, cs, alpha):
        r""" Wrapper for `fz_new_pixmap_from_page()`."""
        return _mupdf.Page_new_pixmap_from_page(self, ctm, cs, alpha)

    def new_pixmap_from_page_contents(self, ctm, cs, alpha):
        r"""
        Wrapper for `fz_new_pixmap_from_page_contents()`.
        	Render the page contents without annotations.

        	Ownership of the pixmap is returned to the caller.
        """
        return _mupdf.Page_new_pixmap_from_page_contents(self, ctm, cs, alpha)

    def new_pixmap_from_page_contents_with_separations(self, ctm, cs, seps, alpha):
        r""" Wrapper for `fz_new_pixmap_from_page_contents_with_separations()`."""
        return _mupdf.Page_new_pixmap_from_page_contents_with_separations(self, ctm, cs, seps, alpha)

    def new_pixmap_from_page_with_separations(self, ctm, cs, seps, alpha):
        r""" Wrapper for `fz_new_pixmap_from_page_with_separations()`."""
        return _mupdf.Page_new_pixmap_from_page_with_separations(self, ctm, cs, seps, alpha)

    def page_presentation(self, transition):
        r"""
        Wrapper for `fz_page_presentation()`.

        This method has out-params. Python/C# wrappers look like:
        	`page_presentation(fz_transition *transition)` => `(fz_transition *, float duration)`

        	Get the presentation details for a given page.

        	transition: A pointer to a transition struct to fill out.

        	duration: A pointer to a place to set the page duration in
        	seconds. Will be set to 0 if no transition is specified for the
        	page.

        	Returns: a pointer to the transition structure, or NULL if there
        	is no transition specified for the page.
        """
        return _mupdf.Page_page_presentation(self, transition)

    def page_separations(self):
        r"""
        Wrapper for `fz_page_separations()`.
        	Get the separations details for a page.
        	This will be NULL, unless the format specifically supports
        	separations (such as PDF files). May be NULL even
        	so, if there are no separations on a page.

        	Returns a reference that must be dropped.
        """
        return _mupdf.Page_page_separations(self)

    def page_uses_overprint(self):
        r"""
        Wrapper for `fz_page_uses_overprint()`.
        	Query if a given page requires overprint.
        """
        return _mupdf.Page_page_uses_overprint(self)

    def run_page(self, dev, transform, cookie):
        r"""
        Wrapper for `fz_run_page()`.
        	Run a page through a device.

        	page: Page obtained from fz_load_page.

        	dev: Device obtained from fz_new_*_device.

        	transform: Transform to apply to page. May include for example
        	scaling and rotation, see fz_scale, fz_rotate and fz_concat.
        	Set to fz_identity if no transformation is desired.

        	cookie: Communication mechanism between caller and library
        	rendering the page. Intended for multi-threaded applications,
        	while single-threaded applications set cookie to NULL. The
        	caller may abort an ongoing rendering of a page. Cookie also
        	communicates progress information back to the caller. The
        	fields inside cookie are continually updated while the page is
        	rendering.
        """
        return _mupdf.Page_run_page(self, dev, transform, cookie)

    def run_page_annots(self, dev, transform, cookie):
        r"""
        Wrapper for `fz_run_page_annots()`.
        	Run the annotations on a page through a device.
        """
        return _mupdf.Page_run_page_annots(self, dev, transform, cookie)

    def run_page_contents(self, dev, transform, cookie):
        r"""
        Wrapper for `fz_run_page_contents()`.
        	Run a page through a device. Just the main
        	page content, without the annotations, if any.

        	page: Page obtained from fz_load_page.

        	dev: Device obtained from fz_new_*_device.

        	transform: Transform to apply to page. May include for example
        	scaling and rotation, see fz_scale, fz_rotate and fz_concat.
        	Set to fz_identity if no transformation is desired.

        	cookie: Communication mechanism between caller and library
        	rendering the page. Intended for multi-threaded applications,
        	while single-threaded applications set cookie to NULL. The
        	caller may abort an ongoing rendering of a page. Cookie also
        	communicates progress information back to the caller. The
        	fields inside cookie are continually updated while the page is
        	rendering.
        """
        return _mupdf.Page_run_page_contents(self, dev, transform, cookie)

    def run_page_widgets(self, dev, transform, cookie):
        r"""
        Wrapper for `fz_run_page_widgets()`.
        	Run the widgets on a page through a device.
        """
        return _mupdf.Page_run_page_widgets(self, dev, transform, cookie)

    def page_from_fz_page(self):
        r""" Wrapper for `pdf_page_from_fz_page()`."""
        return _mupdf.Page_page_from_fz_page(self)

    def search_page(self, needle, hit_mark, max):
        r""" Wrapper for fz_search_page()."""
        return _mupdf.Page_search_page(self, needle, hit_mark, max)

    def doc(self):
        r""" Returns wrapper for .doc member."""
        return _mupdf.Page_doc(self)

    def __init__(self, *args):
        r"""
        *Overload 1:*
         == Constructors.  Constructor using `fz_load_chapter_page()`.
        		Load a page.

        		After fz_load_page is it possible to retrieve the size of the
        		page using fz_bound_page, or to render the page using
        		fz_run_page_*. Free the page by calling fz_drop_page.

        		chapter: chapter number, 0 is the first chapter of the document.
        		number: page number, 0 is the first page of the chapter.


        |

        *Overload 2:*
         Constructor using `fz_load_page()`.
        		Load a given page number from a document. This may be much less
        		efficient than loading by location (chapter+page) for some
        		document types.


        |

        *Overload 3:*
         Constructor using `fz_new_page_of_size()`.
        		Different document types will be implemented by deriving from
        		fz_page. This macro allocates such derived structures, and
        		initialises the base sections.


        |

        *Overload 4:*
         Return Page for pdfpage.m_internal.super.

        |

        *Overload 5:*
         Copy constructor using `fz_keep_page()`.

        |

        *Overload 6:*
         Constructor using raw copy of pre-existing `fz_page`.
        """
        _mupdf.Page_swiginit(self, _mupdf.new_Page(*args))
    __swig_destroy__ = _mupdf.delete_Page

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.Page_m_internal_value(self)
    m_internal = property(_mupdf.Page_m_internal_get, _mupdf.Page_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register Page in _mupdf:
_mupdf.Page_swigregister(Page)

class Path(object):
    r"""
     Wrapper class for struct `fz_path`.
    Vector path buffer.
    It can be stroked and dashed, or be filled.
    It has a fill rule (nonzero or even_odd).

    When rendering, they are flattened, stroked and dashed straight
    into the Global Edge List.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def bound_path(self, stroke, ctm):
        r"""
        Wrapper for `fz_bound_path()`.
        	Return a bounding rectangle for a path.

        	path: The path to bound.

        	stroke: If NULL, the bounding rectangle given is for
        	the filled path. If non-NULL the bounding rectangle
        	given is for the path stroked with the given attributes.

        	ctm: The matrix to apply to the path during stroking.

        	r: Pointer to a fz_rect which will be used to hold
        	the result.

        	Returns r, updated to contain the bounding rectangle.
        """
        return _mupdf.Path_bound_path(self, stroke, ctm)

    def clone_path(self):
        r"""
        Wrapper for `fz_clone_path()`.
        	Clone the data for a path.

        	This is used in preference to fz_keep_path when a whole
        	new copy of a path is required, rather than just a shared
        	pointer. This probably indicates that the path is about to
        	be modified.

        	path: path to clone.

        	Throws exceptions on failure to allocate.
        """
        return _mupdf.Path_clone_path(self)

    def closepath(self):
        r"""
        Wrapper for `fz_closepath()`.
        	Close the current subpath.

        	path: The path to modify.

        	Throws exceptions on failure to allocate, attempting to modify
        	a packed path, and illegal path closes (i.e. closing a non open
        	path).
        """
        return _mupdf.Path_closepath(self)

    def currentpoint(self):
        r"""
        Wrapper for `fz_currentpoint()`.
        	Return the current point that a path has
        	reached or (0,0) if empty.

        	path: path to return the current point of.
        """
        return _mupdf.Path_currentpoint(self)

    def curveto(self, x0, y0, x1, y1, x2, y2):
        r"""
        Wrapper for `fz_curveto()`.
        	Append a 'curveto' command to an open path. (For a
        	cubic bezier).

        	path: The path to modify.

        	x0, y0: The coordinates of the first control point for the
        	curve.

        	x1, y1: The coordinates of the second control point for the
        	curve.

        	x2, y2: The end coordinates for the curve.

        	Throws exceptions on failure to allocate, or attempting to
        	modify a packed path.
        """
        return _mupdf.Path_curveto(self, x0, y0, x1, y1, x2, y2)

    def curvetov(self, x1, y1, x2, y2):
        r"""
        Wrapper for `fz_curvetov()`.
        	Append a 'curvetov' command to an open path. (For a
        	cubic bezier with the first control coordinate equal to
        	the start point).

        	path: The path to modify.

        	x1, y1: The coordinates of the second control point for the
        	curve.

        	x2, y2: The end coordinates for the curve.

        	Throws exceptions on failure to allocate, or attempting to
        	modify a packed path.
        """
        return _mupdf.Path_curvetov(self, x1, y1, x2, y2)

    def curvetoy(self, x0, y0, x2, y2):
        r"""
        Wrapper for `fz_curvetoy()`.
        	Append a 'curvetoy' command to an open path. (For a
        	cubic bezier with the second control coordinate equal to
        	the end point).

        	path: The path to modify.

        	x0, y0: The coordinates of the first control point for the
        	curve.

        	x2, y2: The end coordinates for the curve (and the second
        	control coordinate).

        	Throws exceptions on failure to allocate, or attempting to
        	modify a packed path.
        """
        return _mupdf.Path_curvetoy(self, x0, y0, x2, y2)

    def lineto(self, x, y):
        r"""
        Wrapper for `fz_lineto()`.
        	Append a 'lineto' command to an open path.

        	path: The path to modify.

        	x, y: The coordinate to line to.

        	Throws exceptions on failure to allocate, or attempting to
        	modify a packed path.
        """
        return _mupdf.Path_lineto(self, x, y)

    def moveto(self, x, y):
        r"""
        Wrapper for `fz_moveto()`.
        	Append a 'moveto' command to a path.
        	This 'opens' a path.

        	path: The path to modify.

        	x, y: The coordinate to move to.

        	Throws exceptions on failure to allocate, or attempting to
        	modify a packed path.
        """
        return _mupdf.Path_moveto(self, x, y)

    def packed_path_size(self):
        r"""
        Wrapper for `fz_packed_path_size()`.
        	Return the number of bytes required to pack a path.
        """
        return _mupdf.Path_packed_path_size(self)

    def quadto(self, x0, y0, x1, y1):
        r"""
        Wrapper for `fz_quadto()`.
        	Append a 'quadto' command to an open path. (For a
        	quadratic bezier).

        	path: The path to modify.

        	x0, y0: The control coordinates for the quadratic curve.

        	x1, y1: The end coordinates for the quadratic curve.

        	Throws exceptions on failure to allocate, or attempting to
        	modify a packed path.
        """
        return _mupdf.Path_quadto(self, x0, y0, x1, y1)

    def rectto(self, x0, y0, x1, y1):
        r"""
        Wrapper for `fz_rectto()`.
        	Append a 'rectto' command to an open path.

        	The rectangle is equivalent to:
        		moveto x0 y0
        		lineto x1 y0
        		lineto x1 y1
        		lineto x0 y1
        		closepath

        	path: The path to modify.

        	x0, y0: First corner of the rectangle.

        	x1, y1: Second corner of the rectangle.

        	Throws exceptions on failure to allocate, or attempting to
        	modify a packed path.
        """
        return _mupdf.Path_rectto(self, x0, y0, x1, y1)

    def transform_path(self, transform):
        r"""
        Wrapper for `fz_transform_path()`.
        	Transform a path by a given
        	matrix.

        	path: The path to modify (must not be a packed path).

        	transform: The transform to apply.

        	Throws exceptions if the path is packed, or on failure
        	to allocate.
        """
        return _mupdf.Path_transform_path(self, transform)

    def trim_path(self):
        r"""
        Wrapper for `fz_trim_path()`.
        	Minimise the internal storage used by a path.

        	As paths are constructed, the internal buffers
        	grow. To avoid repeated reallocations they
        	grow with some spare space. Once a path has
        	been fully constructed, this call allows the
        	excess space to be trimmed.
        """
        return _mupdf.Path_trim_path(self)

    def walk_path(self, walker, arg):
        r"""
        Wrapper for `fz_walk_path()`.
        	Walk the segments of a path, calling the
        	appropriate callback function from a given set for each
        	segment of the path.

        	path: The path to walk.

        	walker: The set of callback functions to use. The first
        	4 callback pointers in the set must be non-NULL. The
        	subsequent ones can either be supplied, or can be left
        	as NULL, in which case the top 4 functions will be
        	called as appropriate to simulate them.

        	arg: An opaque argument passed in to each callback.

        	Exceptions will only be thrown if the underlying callback
        	functions throw them.
        """
        return _mupdf.Path_walk_path(self, walker, arg)

    def __init__(self, *args):
        r"""
        *Overload 1:*
         == Constructors.  Constructor using `fz_new_path()`.
        		Create a new (empty) path structure.


        |

        *Overload 2:*
         Copy constructor using `fz_keep_path()`.

        |

        *Overload 3:*
         Constructor using raw copy of pre-existing `fz_path`.
        """
        _mupdf.Path_swiginit(self, _mupdf.new_Path(*args))
    __swig_destroy__ = _mupdf.delete_Path

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.Path_m_internal_value(self)
    m_internal = property(_mupdf.Path_m_internal_get, _mupdf.Path_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register Path in _mupdf:
_mupdf.Path_swigregister(Path)

class PathWalker(object):
    r""" Wrapper class for struct `fz_path_walker`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal=None):
        r""" Constructor using raw copy of pre-existing `fz_path_walker`."""
        _mupdf.PathWalker_swiginit(self, _mupdf.new_PathWalker(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PathWalker_m_internal_value(self)
    m_internal = property(_mupdf.PathWalker_m_internal_get, _mupdf.PathWalker_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_PathWalker

# Register PathWalker in _mupdf:
_mupdf.PathWalker_swigregister(PathWalker)

class PathWalker2(PathWalker):
    r""" Wrapper class for struct fz_path_walker with virtual fns for each fnptr; this is for use as a SWIG Director class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" == Constructor."""
        if self.__class__ == PathWalker2:
            _self = None
        else:
            _self = self
        _mupdf.PathWalker2_swiginit(self, _mupdf.new_PathWalker2(_self, ))
    __swig_destroy__ = _mupdf.delete_PathWalker2

    def use_virtual_moveto(self, use=True):
        r"""
        These methods set the function pointers in *m_internal
        to point to internal callbacks that call our virtual methods.
        """
        return _mupdf.PathWalker2_use_virtual_moveto(self, use)

    def use_virtual_lineto(self, use=True):
        return _mupdf.PathWalker2_use_virtual_lineto(self, use)

    def use_virtual_curveto(self, use=True):
        return _mupdf.PathWalker2_use_virtual_curveto(self, use)

    def use_virtual_closepath(self, use=True):
        return _mupdf.PathWalker2_use_virtual_closepath(self, use)

    def use_virtual_quadto(self, use=True):
        return _mupdf.PathWalker2_use_virtual_quadto(self, use)

    def use_virtual_curvetov(self, use=True):
        return _mupdf.PathWalker2_use_virtual_curvetov(self, use)

    def use_virtual_curvetoy(self, use=True):
        return _mupdf.PathWalker2_use_virtual_curvetoy(self, use)

    def use_virtual_rectto(self, use=True):
        return _mupdf.PathWalker2_use_virtual_rectto(self, use)

    def moveto(self, arg_2, arg_3):
        r""" Default virtual method implementations; these all throw an exception."""
        return _mupdf.PathWalker2_moveto(self, arg_2, arg_3)

    def lineto(self, arg_2, arg_3):
        return _mupdf.PathWalker2_lineto(self, arg_2, arg_3)

    def curveto(self, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7):
        return _mupdf.PathWalker2_curveto(self, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7)

    def closepath(self):
        return _mupdf.PathWalker2_closepath(self)

    def quadto(self, arg_2, arg_3, arg_4, arg_5):
        return _mupdf.PathWalker2_quadto(self, arg_2, arg_3, arg_4, arg_5)

    def curvetov(self, arg_2, arg_3, arg_4, arg_5):
        return _mupdf.PathWalker2_curvetov(self, arg_2, arg_3, arg_4, arg_5)

    def curvetoy(self, arg_2, arg_3, arg_4, arg_5):
        return _mupdf.PathWalker2_curvetoy(self, arg_2, arg_3, arg_4, arg_5)

    def rectto(self, arg_2, arg_3, arg_4, arg_5):
        return _mupdf.PathWalker2_rectto(self, arg_2, arg_3, arg_4, arg_5)
    def __disown__(self):
        self.this.disown()
        _mupdf.disown_PathWalker2(self)
        return weakref.proxy(self)

# Register PathWalker2 in _mupdf:
_mupdf.PathWalker2_swigregister(PathWalker2)

class PclOptions(object):
    r"""
    Wrapper class for struct `fz_pcl_options`. Not copyable or assignable.
    PCL output
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def pcl_preset(self, preset):
        r"""
        Wrapper for `fz_pcl_preset()`.
        	Initialize PCL option struct for a given preset.

        	Currently defined presets include:

        		generic	Generic PCL printer
        		ljet4	HP DeskJet
        		dj500	HP DeskJet 500
        		fs600	Kyocera FS-600
        		lj	HP LaserJet, HP LaserJet Plus
        		lj2	HP LaserJet IIp, HP LaserJet IId
        		lj3	HP LaserJet III
        		lj3d	HP LaserJet IIId
        		lj4	HP LaserJet 4
        		lj4pl	HP LaserJet 4 PL
        		lj4d	HP LaserJet 4d
        		lp2563b	HP 2563B line printer
        		oce9050	Oce 9050 Line printer
        """
        return _mupdf.PclOptions_pcl_preset(self, preset)

    def __init__(self, *args):
        r"""
        *Overload 1:*
         == Constructors.  Constructor using `fz_parse_pcl_options()`.
        		Parse PCL options.

        		Currently defined options and values are as follows:

        			preset=X	Either "generic" or one of the presets as for fz_pcl_preset.
        			spacing=0	No vertical spacing capability
        			spacing=1	PCL 3 spacing (<ESC>*p+<n>Y)
        			spacing=2	PCL 4 spacing (<ESC>*b<n>Y)
        			spacing=3	PCL 5 spacing (<ESC>*b<n>Y and clear seed row)
        			mode2		Disable/Enable mode 2 graphics compression
        			mode3		Disable/Enable mode 3 graphics compression
        			eog_reset	End of graphics (<ESC>*rB) resets all parameters
        			has_duplex	Duplex supported (<ESC>&l<duplex>S)
        			has_papersize	Papersize setting supported (<ESC>&l<sizecode>A)
        			has_copies	Number of copies supported (<ESC>&l<copies>X)
        			is_ljet4pjl	Disable/Enable HP 4PJL model-specific output
        			is_oce9050	Disable/Enable Oce 9050 model-specific output


        |

        *Overload 2:*
         Constructor using raw copy of pre-existing `fz_pcl_options`.
        """
        _mupdf.PclOptions_swiginit(self, _mupdf.new_PclOptions(*args))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PclOptions_m_internal_value(self)
    m_internal = property(_mupdf.PclOptions_m_internal_get, _mupdf.PclOptions_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_PclOptions

# Register PclOptions in _mupdf:
_mupdf.PclOptions_swigregister(PclOptions)

class PclmOptions(object):
    r"""
    Wrapper class for struct `fz_pclm_options`. Not copyable or assignable.
    PCLm output
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*
         == Constructors.  Constructor using `fz_parse_pclm_options()`.
        		Parse PCLm options.

        		Currently defined options and values are as follows:

        			compression=none: No compression
        			compression=flate: Flate compression
        			strip-height=n: Strip height (default 16)


        |

        *Overload 2:*
         Construct using fz_parse_pclm_options().

        |

        *Overload 3:*
         Constructor using raw copy of pre-existing `fz_pclm_options`.
        """
        _mupdf.PclmOptions_swiginit(self, _mupdf.new_PclmOptions(*args))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PclmOptions_m_internal_value(self)
    m_internal = property(_mupdf.PclmOptions_m_internal_get, _mupdf.PclmOptions_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_PclmOptions

# Register PclmOptions in _mupdf:
_mupdf.PclmOptions_swigregister(PclmOptions)

class PdfAlertEvent(object):
    r""" Wrapper class for struct `pdf_alert_event`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `pdf_alert_event`."""
        _mupdf.PdfAlertEvent_swiginit(self, _mupdf.new_PdfAlertEvent(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfAlertEvent_m_internal_value(self)
    m_internal = property(_mupdf.PdfAlertEvent_m_internal_get, _mupdf.PdfAlertEvent_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_PdfAlertEvent

# Register PdfAlertEvent in _mupdf:
_mupdf.PdfAlertEvent_swigregister(PdfAlertEvent)

class PdfAnnot(object):
    r""" Wrapper class for struct `pdf_annot`."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def add_annot_ink_list_stroke(self):
        r""" Wrapper for `pdf_add_annot_ink_list_stroke()`."""
        return _mupdf.PdfAnnot_add_annot_ink_list_stroke(self)

    def add_annot_ink_list_stroke_vertex(self, p):
        r""" Wrapper for `pdf_add_annot_ink_list_stroke_vertex()`."""
        return _mupdf.PdfAnnot_add_annot_ink_list_stroke_vertex(self, p)

    def add_annot_quad_point(self, quad):
        r""" Wrapper for `pdf_add_annot_quad_point()`."""
        return _mupdf.PdfAnnot_add_annot_quad_point(self, quad)

    def add_annot_vertex(self, p):
        r""" Wrapper for `pdf_add_annot_vertex()`."""
        return _mupdf.PdfAnnot_add_annot_vertex(self, p)

    def annot_MK_BC(self, color):
        r"""
        Wrapper for `pdf_annot_MK_BC()`.

        This method has out-params. Python/C# wrappers look like:
        	`annot_MK_BC(float color[4])` => int n
        """
        return _mupdf.PdfAnnot_annot_MK_BC(self, color)

    def annot_MK_BC_rgb(self, rgb):
        r""" Wrapper for `pdf_annot_MK_BC_rgb()`."""
        return _mupdf.PdfAnnot_annot_MK_BC_rgb(self, rgb)

    def annot_MK_BG(self, color):
        r"""
        Wrapper for `pdf_annot_MK_BG()`.

        This method has out-params. Python/C# wrappers look like:
        	`annot_MK_BG(float color[4])` => int n
        """
        return _mupdf.PdfAnnot_annot_MK_BG(self, color)

    def annot_MK_BG_rgb(self, rgb):
        r""" Wrapper for `pdf_annot_MK_BG_rgb()`."""
        return _mupdf.PdfAnnot_annot_MK_BG_rgb(self, rgb)

    def annot_active(self):
        r""" Wrapper for `pdf_annot_active()`."""
        return _mupdf.PdfAnnot_annot_active(self)

    def annot_ap(self):
        r""" Wrapper for `pdf_annot_ap()`."""
        return _mupdf.PdfAnnot_annot_ap(self)

    def annot_author(self):
        r""" Wrapper for `pdf_annot_author()`."""
        return _mupdf.PdfAnnot_annot_author(self)

    def annot_border(self):
        r""" Wrapper for `pdf_annot_border()`."""
        return _mupdf.PdfAnnot_annot_border(self)

    def annot_color(self, color):
        r"""
        Wrapper for `pdf_annot_color()`.

        This method has out-params. Python/C# wrappers look like:
        	`annot_color(float color[4])` => int n
        """
        return _mupdf.PdfAnnot_annot_color(self, color)

    def annot_contents(self):
        r""" Wrapper for `pdf_annot_contents()`."""
        return _mupdf.PdfAnnot_annot_contents(self)

    def annot_creation_date(self):
        r""" Wrapper for `pdf_annot_creation_date()`."""
        return _mupdf.PdfAnnot_annot_creation_date(self)

    def annot_default_appearance(self, color):
        r"""
        Wrapper for `pdf_annot_default_appearance()`.

        This method has out-params. Python/C# wrappers look like:
        	`annot_default_appearance(float color[4])` => `(const char *font, float size, int n)`
        """
        return _mupdf.PdfAnnot_annot_default_appearance(self, color)

    def annot_ensure_local_xref(self):
        r""" Wrapper for `pdf_annot_ensure_local_xref()`."""
        return _mupdf.PdfAnnot_annot_ensure_local_xref(self)

    def annot_event_blur(self):
        r""" Wrapper for `pdf_annot_event_blur()`."""
        return _mupdf.PdfAnnot_annot_event_blur(self)

    def annot_event_down(self):
        r""" Wrapper for `pdf_annot_event_down()`."""
        return _mupdf.PdfAnnot_annot_event_down(self)

    def annot_event_enter(self):
        r""" Wrapper for `pdf_annot_event_enter()`."""
        return _mupdf.PdfAnnot_annot_event_enter(self)

    def annot_event_exit(self):
        r""" Wrapper for `pdf_annot_event_exit()`."""
        return _mupdf.PdfAnnot_annot_event_exit(self)

    def annot_event_focus(self):
        r""" Wrapper for `pdf_annot_event_focus()`."""
        return _mupdf.PdfAnnot_annot_event_focus(self)

    def annot_event_page_close(self):
        r""" Wrapper for `pdf_annot_event_page_close()`."""
        return _mupdf.PdfAnnot_annot_event_page_close(self)

    def annot_event_page_invisible(self):
        r""" Wrapper for `pdf_annot_event_page_invisible()`."""
        return _mupdf.PdfAnnot_annot_event_page_invisible(self)

    def annot_event_page_open(self):
        r""" Wrapper for `pdf_annot_event_page_open()`."""
        return _mupdf.PdfAnnot_annot_event_page_open(self)

    def annot_event_page_visible(self):
        r""" Wrapper for `pdf_annot_event_page_visible()`."""
        return _mupdf.PdfAnnot_annot_event_page_visible(self)

    def annot_event_up(self):
        r""" Wrapper for `pdf_annot_event_up()`."""
        return _mupdf.PdfAnnot_annot_event_up(self)

    def annot_field_flags(self):
        r""" Wrapper for `pdf_annot_field_flags()`."""
        return _mupdf.PdfAnnot_annot_field_flags(self)

    def annot_field_label(self):
        r""" Wrapper for `pdf_annot_field_label()`."""
        return _mupdf.PdfAnnot_annot_field_label(self)

    def annot_field_value(self):
        r""" Wrapper for `pdf_annot_field_value()`."""
        return _mupdf.PdfAnnot_annot_field_value(self)

    def annot_flags(self):
        r""" Wrapper for `pdf_annot_flags()`."""
        return _mupdf.PdfAnnot_annot_flags(self)

    def annot_has_author(self):
        r""" Wrapper for `pdf_annot_has_author()`."""
        return _mupdf.PdfAnnot_annot_has_author(self)

    def annot_has_icon_name(self):
        r""" Wrapper for `pdf_annot_has_icon_name()`."""
        return _mupdf.PdfAnnot_annot_has_icon_name(self)

    def annot_has_ink_list(self):
        r""" Wrapper for `pdf_annot_has_ink_list()`."""
        return _mupdf.PdfAnnot_annot_has_ink_list(self)

    def annot_has_interior_color(self):
        r""" Wrapper for `pdf_annot_has_interior_color()`."""
        return _mupdf.PdfAnnot_annot_has_interior_color(self)

    def annot_has_line(self):
        r""" Wrapper for `pdf_annot_has_line()`."""
        return _mupdf.PdfAnnot_annot_has_line(self)

    def annot_has_line_ending_styles(self):
        r""" Wrapper for `pdf_annot_has_line_ending_styles()`."""
        return _mupdf.PdfAnnot_annot_has_line_ending_styles(self)

    def annot_has_open(self):
        r""" Wrapper for `pdf_annot_has_open()`."""
        return _mupdf.PdfAnnot_annot_has_open(self)

    def annot_has_quad_points(self):
        r""" Wrapper for `pdf_annot_has_quad_points()`."""
        return _mupdf.PdfAnnot_annot_has_quad_points(self)

    def annot_has_vertices(self):
        r""" Wrapper for `pdf_annot_has_vertices()`."""
        return _mupdf.PdfAnnot_annot_has_vertices(self)

    def annot_hot(self):
        r""" Wrapper for `pdf_annot_hot()`."""
        return _mupdf.PdfAnnot_annot_hot(self)

    def annot_icon_name(self):
        r""" Wrapper for `pdf_annot_icon_name()`."""
        return _mupdf.PdfAnnot_annot_icon_name(self)

    def annot_ink_list_count(self):
        r""" Wrapper for `pdf_annot_ink_list_count()`."""
        return _mupdf.PdfAnnot_annot_ink_list_count(self)

    def annot_ink_list_stroke_count(self, i):
        r""" Wrapper for `pdf_annot_ink_list_stroke_count()`."""
        return _mupdf.PdfAnnot_annot_ink_list_stroke_count(self, i)

    def annot_ink_list_stroke_vertex(self, i, k):
        r""" Wrapper for `pdf_annot_ink_list_stroke_vertex()`."""
        return _mupdf.PdfAnnot_annot_ink_list_stroke_vertex(self, i, k)

    def annot_interior_color(self, color):
        r"""
        Wrapper for `pdf_annot_interior_color()`.

        This method has out-params. Python/C# wrappers look like:
        	`annot_interior_color(float color[4])` => int n
        """
        return _mupdf.PdfAnnot_annot_interior_color(self, color)

    def annot_is_open(self):
        r""" Wrapper for `pdf_annot_is_open()`."""
        return _mupdf.PdfAnnot_annot_is_open(self)

    def annot_line(self, a, b):
        r""" Wrapper for `pdf_annot_line()`."""
        return _mupdf.PdfAnnot_annot_line(self, a, b)

    def annot_line_end_style(self):
        r""" Wrapper for `pdf_annot_line_end_style()`."""
        return _mupdf.PdfAnnot_annot_line_end_style(self)

    def annot_line_ending_styles(self, arg2, arg3):
        r"""
        Wrapper for `pdf_annot_line_ending_styles()`.

        This method has out-params. Python/C# wrappers look like:
        	`annot_line_ending_styles()` => `(enum pdf_line_ending start_style, enum pdf_line_ending end_style)`
        """
        return _mupdf.PdfAnnot_annot_line_ending_styles(self, arg2, arg3)

    def annot_line_start_style(self):
        r""" Wrapper for `pdf_annot_line_start_style()`."""
        return _mupdf.PdfAnnot_annot_line_start_style(self)

    def annot_modification_date(self):
        r""" Wrapper for `pdf_annot_modification_date()`."""
        return _mupdf.PdfAnnot_annot_modification_date(self)

    def annot_needs_resynthesis(self):
        r""" Wrapper for `pdf_annot_needs_resynthesis()`."""
        return _mupdf.PdfAnnot_annot_needs_resynthesis(self)

    def annot_obj(self):
        r""" Wrapper for `pdf_annot_obj()`."""
        return _mupdf.PdfAnnot_annot_obj(self)

    def annot_opacity(self):
        r""" Wrapper for `pdf_annot_opacity()`."""
        return _mupdf.PdfAnnot_annot_opacity(self)

    def annot_page(self):
        r""" Wrapper for `pdf_annot_page()`."""
        return _mupdf.PdfAnnot_annot_page(self)

    def annot_pop_and_discard_local_xref(self):
        r""" Wrapper for `pdf_annot_pop_and_discard_local_xref()`."""
        return _mupdf.PdfAnnot_annot_pop_and_discard_local_xref(self)

    def annot_pop_local_xref(self):
        r""" Wrapper for `pdf_annot_pop_local_xref()`."""
        return _mupdf.PdfAnnot_annot_pop_local_xref(self)

    def annot_popup(self):
        r""" Wrapper for `pdf_annot_popup()`."""
        return _mupdf.PdfAnnot_annot_popup(self)

    def annot_push_local_xref(self):
        r""" Wrapper for `pdf_annot_push_local_xref()`."""
        return _mupdf.PdfAnnot_annot_push_local_xref(self)

    def annot_quad_point(self, i):
        r""" Wrapper for `pdf_annot_quad_point()`."""
        return _mupdf.PdfAnnot_annot_quad_point(self, i)

    def annot_quad_point_count(self):
        r""" Wrapper for `pdf_annot_quad_point_count()`."""
        return _mupdf.PdfAnnot_annot_quad_point_count(self)

    def annot_quadding(self):
        r""" Wrapper for `pdf_annot_quadding()`."""
        return _mupdf.PdfAnnot_annot_quadding(self)

    def annot_rect(self):
        r""" Wrapper for `pdf_annot_rect()`."""
        return _mupdf.PdfAnnot_annot_rect(self)

    def annot_request_resynthesis(self):
        r""" Wrapper for `pdf_annot_request_resynthesis()`."""
        return _mupdf.PdfAnnot_annot_request_resynthesis(self)

    def annot_transform(self):
        r""" Wrapper for `pdf_annot_transform()`."""
        return _mupdf.PdfAnnot_annot_transform(self)

    def annot_type(self):
        r""" Wrapper for `pdf_annot_type()`."""
        return _mupdf.PdfAnnot_annot_type(self)

    def annot_vertex(self, i):
        r""" Wrapper for `pdf_annot_vertex()`."""
        return _mupdf.PdfAnnot_annot_vertex(self, i)

    def annot_vertex_count(self):
        r""" Wrapper for `pdf_annot_vertex_count()`."""
        return _mupdf.PdfAnnot_annot_vertex_count(self)

    def bound_annot(self):
        r""" Wrapper for `pdf_bound_annot()`."""
        return _mupdf.PdfAnnot_bound_annot(self)

    def bound_widget(self):
        r""" Wrapper for `pdf_bound_widget()`."""
        return _mupdf.PdfAnnot_bound_widget(self)

    def choice_widget_is_multiselect(self):
        r""" Wrapper for `pdf_choice_widget_is_multiselect()`."""
        return _mupdf.PdfAnnot_choice_widget_is_multiselect(self)

    def choice_widget_options(self, exportval, opts):
        r""" Wrapper for `pdf_choice_widget_options()`."""
        return _mupdf.PdfAnnot_choice_widget_options(self, exportval, opts)

    def choice_widget_set_value(self, n, opts):
        r""" Wrapper for `pdf_choice_widget_set_value()`."""
        return _mupdf.PdfAnnot_choice_widget_set_value(self, n, opts)

    def choice_widget_value(self, opts):
        r""" Wrapper for `pdf_choice_widget_value()`."""
        return _mupdf.PdfAnnot_choice_widget_value(self, opts)

    def clear_annot_ink_list(self):
        r""" Wrapper for `pdf_clear_annot_ink_list()`."""
        return _mupdf.PdfAnnot_clear_annot_ink_list(self)

    def clear_annot_quad_points(self):
        r""" Wrapper for `pdf_clear_annot_quad_points()`."""
        return _mupdf.PdfAnnot_clear_annot_quad_points(self)

    def clear_annot_vertices(self):
        r""" Wrapper for `pdf_clear_annot_vertices()`."""
        return _mupdf.PdfAnnot_clear_annot_vertices(self)

    def clear_signature(self):
        r""" Wrapper for `pdf_clear_signature()`."""
        return _mupdf.PdfAnnot_clear_signature(self)

    def dirty_annot(self):
        r""" Wrapper for `pdf_dirty_annot()`."""
        return _mupdf.PdfAnnot_dirty_annot(self)

    def edit_text_field_value(self, value, change):
        r"""
        Wrapper for `pdf_edit_text_field_value()`.

        This method has out-params. Python/C# wrappers look like:
        	`edit_text_field_value(const char *value, const char *change)` => `(int, int selStart, int selEnd, char *newvalue)`
        """
        return _mupdf.PdfAnnot_edit_text_field_value(self, value, change)

    def get_widget_editing_state(self):
        r""" Wrapper for `pdf_get_widget_editing_state()`."""
        return _mupdf.PdfAnnot_get_widget_editing_state(self)

    def new_display_list_from_annot(self):
        r""" Wrapper for `pdf_new_display_list_from_annot()`."""
        return _mupdf.PdfAnnot_new_display_list_from_annot(self)

    def new_pixmap_from_annot(self, ctm, cs, seps, alpha):
        r""" Wrapper for `pdf_new_pixmap_from_annot()`."""
        return _mupdf.PdfAnnot_new_pixmap_from_annot(self, ctm, cs, seps, alpha)

    def next_annot(self):
        r""" Wrapper for `pdf_next_annot()`."""
        return _mupdf.PdfAnnot_next_annot(self)

    def next_widget(self):
        r""" Wrapper for `pdf_next_widget()`."""
        return _mupdf.PdfAnnot_next_widget(self)

    def run_annot(self, dev, ctm, cookie):
        r""" Wrapper for `pdf_run_annot()`."""
        return _mupdf.PdfAnnot_run_annot(self, dev, ctm, cookie)

    def set_annot_active(self, active):
        r""" Wrapper for `pdf_set_annot_active()`."""
        return _mupdf.PdfAnnot_set_annot_active(self, active)

    def set_annot_appearance(self, appearance, state, ctm, bbox, res, contents):
        r""" Wrapper for `pdf_set_annot_appearance()`."""
        return _mupdf.PdfAnnot_set_annot_appearance(self, appearance, state, ctm, bbox, res, contents)

    def set_annot_appearance_from_display_list(self, appearance, state, ctm, list):
        r""" Wrapper for `pdf_set_annot_appearance_from_display_list()`."""
        return _mupdf.PdfAnnot_set_annot_appearance_from_display_list(self, appearance, state, ctm, list)

    def set_annot_author(self, author):
        r""" Wrapper for `pdf_set_annot_author()`."""
        return _mupdf.PdfAnnot_set_annot_author(self, author)

    def set_annot_border(self, width):
        r""" Wrapper for `pdf_set_annot_border()`."""
        return _mupdf.PdfAnnot_set_annot_border(self, width)

    def set_annot_color(self, n, color):
        r""" Wrapper for `pdf_set_annot_color()`."""
        return _mupdf.PdfAnnot_set_annot_color(self, n, color)

    def set_annot_contents(self, text):
        r""" Wrapper for `pdf_set_annot_contents()`."""
        return _mupdf.PdfAnnot_set_annot_contents(self, text)

    def set_annot_creation_date(self, time):
        r""" Wrapper for `pdf_set_annot_creation_date()`."""
        return _mupdf.PdfAnnot_set_annot_creation_date(self, time)

    def set_annot_default_appearance(self, font, size, n, color):
        r""" Wrapper for `pdf_set_annot_default_appearance()`."""
        return _mupdf.PdfAnnot_set_annot_default_appearance(self, font, size, n, color)

    def set_annot_flags(self, flags):
        r""" Wrapper for `pdf_set_annot_flags()`."""
        return _mupdf.PdfAnnot_set_annot_flags(self, flags)

    def set_annot_hot(self, hot):
        r""" Wrapper for `pdf_set_annot_hot()`."""
        return _mupdf.PdfAnnot_set_annot_hot(self, hot)

    def set_annot_icon_name(self, name):
        r""" Wrapper for `pdf_set_annot_icon_name()`."""
        return _mupdf.PdfAnnot_set_annot_icon_name(self, name)

    def set_annot_ink_list(self, n, count, v):
        r""" Wrapper for `pdf_set_annot_ink_list()`."""
        return _mupdf.PdfAnnot_set_annot_ink_list(self, n, count, v)

    def set_annot_interior_color(self, n, color):
        r""" Wrapper for `pdf_set_annot_interior_color()`."""
        return _mupdf.PdfAnnot_set_annot_interior_color(self, n, color)

    def set_annot_is_open(self, is_open):
        r""" Wrapper for `pdf_set_annot_is_open()`."""
        return _mupdf.PdfAnnot_set_annot_is_open(self, is_open)

    def set_annot_language(self, lang):
        r""" Wrapper for `pdf_set_annot_language()`."""
        return _mupdf.PdfAnnot_set_annot_language(self, lang)

    def set_annot_line(self, a, b):
        r""" Wrapper for `pdf_set_annot_line()`."""
        return _mupdf.PdfAnnot_set_annot_line(self, a, b)

    def set_annot_line_end_style(self, e):
        r""" Wrapper for `pdf_set_annot_line_end_style()`."""
        return _mupdf.PdfAnnot_set_annot_line_end_style(self, e)

    def set_annot_line_ending_styles(self, start_style, end_style):
        r""" Wrapper for `pdf_set_annot_line_ending_styles()`."""
        return _mupdf.PdfAnnot_set_annot_line_ending_styles(self, start_style, end_style)

    def set_annot_line_start_style(self, s):
        r""" Wrapper for `pdf_set_annot_line_start_style()`."""
        return _mupdf.PdfAnnot_set_annot_line_start_style(self, s)

    def set_annot_modification_date(self, time):
        r""" Wrapper for `pdf_set_annot_modification_date()`."""
        return _mupdf.PdfAnnot_set_annot_modification_date(self, time)

    def set_annot_opacity(self, opacity):
        r""" Wrapper for `pdf_set_annot_opacity()`."""
        return _mupdf.PdfAnnot_set_annot_opacity(self, opacity)

    def set_annot_popup(self, rect):
        r""" Wrapper for `pdf_set_annot_popup()`."""
        return _mupdf.PdfAnnot_set_annot_popup(self, rect)

    def set_annot_quad_points(self, n, qv):
        r""" Wrapper for `pdf_set_annot_quad_points()`."""
        return _mupdf.PdfAnnot_set_annot_quad_points(self, n, qv)

    def set_annot_quadding(self, q):
        r""" Wrapper for `pdf_set_annot_quadding()`."""
        return _mupdf.PdfAnnot_set_annot_quadding(self, q)

    def set_annot_rect(self, rect):
        r""" Wrapper for `pdf_set_annot_rect()`."""
        return _mupdf.PdfAnnot_set_annot_rect(self, rect)

    def set_annot_resynthesised(self):
        r""" Wrapper for `pdf_set_annot_resynthesised()`."""
        return _mupdf.PdfAnnot_set_annot_resynthesised(self)

    def set_annot_vertex(self, i, p):
        r""" Wrapper for `pdf_set_annot_vertex()`."""
        return _mupdf.PdfAnnot_set_annot_vertex(self, i, p)

    def set_annot_vertices(self, n, v):
        r""" Wrapper for `pdf_set_annot_vertices()`."""
        return _mupdf.PdfAnnot_set_annot_vertices(self, n, v)

    def set_choice_field_value(self, value):
        r""" Wrapper for `pdf_set_choice_field_value()`."""
        return _mupdf.PdfAnnot_set_choice_field_value(self, value)

    def set_text_field_value(self, value):
        r""" Wrapper for `pdf_set_text_field_value()`."""
        return _mupdf.PdfAnnot_set_text_field_value(self, value)

    def set_widget_editing_state(self, editing):
        r""" Wrapper for `pdf_set_widget_editing_state()`."""
        return _mupdf.PdfAnnot_set_widget_editing_state(self, editing)

    def sign_signature(self, signer, appearance_flags, graphic, reason, location):
        r""" Wrapper for `pdf_sign_signature()`."""
        return _mupdf.PdfAnnot_sign_signature(self, signer, appearance_flags, graphic, reason, location)

    def sign_signature_with_appearance(self, signer, date, disp_list):
        r""" Wrapper for `pdf_sign_signature_with_appearance()`."""
        return _mupdf.PdfAnnot_sign_signature_with_appearance(self, signer, date, disp_list)

    def text_widget_format(self):
        r""" Wrapper for `pdf_text_widget_format()`."""
        return _mupdf.PdfAnnot_text_widget_format(self)

    def text_widget_max_len(self):
        r""" Wrapper for `pdf_text_widget_max_len()`."""
        return _mupdf.PdfAnnot_text_widget_max_len(self)

    def toggle_widget(self):
        r""" Wrapper for `pdf_toggle_widget()`."""
        return _mupdf.PdfAnnot_toggle_widget(self)

    def update_annot(self):
        r""" Wrapper for `pdf_update_annot()`."""
        return _mupdf.PdfAnnot_update_annot(self)

    def update_widget(self):
        r""" Wrapper for `pdf_update_widget()`."""
        return _mupdf.PdfAnnot_update_widget(self)

    def validate_signature(self):
        r""" Wrapper for `pdf_validate_signature()`."""
        return _mupdf.PdfAnnot_validate_signature(self)

    def widget_is_readonly(self):
        r""" Wrapper for `pdf_widget_is_readonly()`."""
        return _mupdf.PdfAnnot_widget_is_readonly(self)

    def widget_is_signed(self):
        r""" Wrapper for `pdf_widget_is_signed()`."""
        return _mupdf.PdfAnnot_widget_is_signed(self)

    def widget_type(self):
        r""" Wrapper for `pdf_widget_type()`."""
        return _mupdf.PdfAnnot_widget_type(self)

    def __init__(self, *args):
        r"""
        *Overload 1:*
        Copy constructor using `pdf_keep_annot()`.

        |

        *Overload 2:*
        Constructor using raw copy of pre-existing `pdf_annot`.
        """
        _mupdf.PdfAnnot_swiginit(self, _mupdf.new_PdfAnnot(*args))
    __swig_destroy__ = _mupdf.delete_PdfAnnot

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfAnnot_m_internal_value(self)
    m_internal = property(_mupdf.PdfAnnot_m_internal_get, _mupdf.PdfAnnot_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register PdfAnnot in _mupdf:
_mupdf.PdfAnnot_swigregister(PdfAnnot)

class PdfCmap(object):
    r""" Wrapper class for struct `pdf_cmap`."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def add_codespace(self, low, high, n):
        r""" Wrapper for `pdf_add_codespace()`."""
        return _mupdf.PdfCmap_add_codespace(self, low, high, n)

    def cmap_size(self):
        r""" Wrapper for `pdf_cmap_size()`."""
        return _mupdf.PdfCmap_cmap_size(self)

    def cmap_wmode(self):
        r""" Wrapper for `pdf_cmap_wmode()`."""
        return _mupdf.PdfCmap_cmap_wmode(self)

    def decode_cmap(self, s, e):
        r"""
        Wrapper for `pdf_decode_cmap()`.

        This method has out-params. Python/C# wrappers look like:
        	`decode_cmap(unsigned char *s, unsigned char *e)` => `(int, unsigned int cpt)`
        """
        return _mupdf.PdfCmap_decode_cmap(self, s, e)

    def lookup_cmap(self, cpt):
        r""" Wrapper for `pdf_lookup_cmap()`."""
        return _mupdf.PdfCmap_lookup_cmap(self, cpt)

    def lookup_cmap_full(self, cpt):
        r"""
        Wrapper for `pdf_lookup_cmap_full()`.

        This method has out-params. Python/C# wrappers look like:
        	`lookup_cmap_full(unsigned int cpt)` => `(int, int out)`
        """
        return _mupdf.PdfCmap_lookup_cmap_full(self, cpt)

    def map_one_to_many(self, one, len):
        r"""
        Wrapper for `pdf_map_one_to_many()`.

        This method has out-params. Python/C# wrappers look like:
        	`map_one_to_many(unsigned int one, size_t len)` => int many
        """
        return _mupdf.PdfCmap_map_one_to_many(self, one, len)

    def map_range_to_range(self, srclo, srchi, dstlo):
        r""" Wrapper for `pdf_map_range_to_range()`."""
        return _mupdf.PdfCmap_map_range_to_range(self, srclo, srchi, dstlo)

    def set_cmap_wmode(self, wmode):
        r""" Wrapper for `pdf_set_cmap_wmode()`."""
        return _mupdf.PdfCmap_set_cmap_wmode(self, wmode)

    def set_usecmap(self, usecmap):
        r""" Wrapper for `pdf_set_usecmap()`."""
        return _mupdf.PdfCmap_set_usecmap(self, usecmap)

    def sort_cmap(self):
        r""" Wrapper for `pdf_sort_cmap()`."""
        return _mupdf.PdfCmap_sort_cmap(self)

    def __init__(self, *args):
        r"""
        *Overload 1:*
        == Constructors.  Constructor using `pdf_new_cmap()`.

        |

        *Overload 2:*
        Constructor using `pdf_new_identity_cmap()`.

        |

        *Overload 3:*
        Copy constructor using `pdf_keep_cmap()`.

        |

        *Overload 4:*
        Constructor using raw copy of pre-existing `pdf_cmap`.
        """
        _mupdf.PdfCmap_swiginit(self, _mupdf.new_PdfCmap(*args))
    __swig_destroy__ = _mupdf.delete_PdfCmap

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfCmap_m_internal_value(self)
    m_internal = property(_mupdf.PdfCmap_m_internal_get, _mupdf.PdfCmap_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register PdfCmap in _mupdf:
_mupdf.PdfCmap_swigregister(PdfCmap)

class PdfCrypt(object):
    r""" Wrapper class for struct `pdf_crypt`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def crypt_encrypt_metadata(self):
        r""" Wrapper for `pdf_crypt_encrypt_metadata()`."""
        return _mupdf.PdfCrypt_crypt_encrypt_metadata(self)

    def crypt_key(self):
        r""" Wrapper for `pdf_crypt_key()`."""
        return _mupdf.PdfCrypt_crypt_key(self)

    def crypt_length(self):
        r""" Wrapper for `pdf_crypt_length()`."""
        return _mupdf.PdfCrypt_crypt_length(self)

    def crypt_method(self):
        r""" Wrapper for `pdf_crypt_method()`."""
        return _mupdf.PdfCrypt_crypt_method(self)

    def crypt_obj(self, obj, num, gen):
        r""" Wrapper for `pdf_crypt_obj()`."""
        return _mupdf.PdfCrypt_crypt_obj(self, obj, num, gen)

    def crypt_owner_encryption(self):
        r""" Wrapper for `pdf_crypt_owner_encryption()`."""
        return _mupdf.PdfCrypt_crypt_owner_encryption(self)

    def crypt_owner_password(self):
        r""" Wrapper for `pdf_crypt_owner_password()`."""
        return _mupdf.PdfCrypt_crypt_owner_password(self)

    def crypt_permissions(self):
        r""" Wrapper for `pdf_crypt_permissions()`."""
        return _mupdf.PdfCrypt_crypt_permissions(self)

    def crypt_permissions_encryption(self):
        r""" Wrapper for `pdf_crypt_permissions_encryption()`."""
        return _mupdf.PdfCrypt_crypt_permissions_encryption(self)

    def crypt_revision(self):
        r""" Wrapper for `pdf_crypt_revision()`."""
        return _mupdf.PdfCrypt_crypt_revision(self)

    def crypt_user_encryption(self):
        r""" Wrapper for `pdf_crypt_user_encryption()`."""
        return _mupdf.PdfCrypt_crypt_user_encryption(self)

    def crypt_user_password(self):
        r""" Wrapper for `pdf_crypt_user_password()`."""
        return _mupdf.PdfCrypt_crypt_user_password(self)

    def crypt_version(self):
        r""" Wrapper for `pdf_crypt_version()`."""
        return _mupdf.PdfCrypt_crypt_version(self)

    def encrypt_data(self, num, gen, fmt_str_out, arg, s, n):
        r""" Wrapper for `pdf_encrypt_data()`."""
        return _mupdf.PdfCrypt_encrypt_data(self, num, gen, fmt_str_out, arg, s, n)

    def encrypted_len(self, num, gen, len):
        r""" Wrapper for `pdf_encrypted_len()`."""
        return _mupdf.PdfCrypt_encrypted_len(self, num, gen, len)

    def __init__(self, *args):
        r"""
        *Overload 1:*
        == Constructors.  Constructor using `pdf_new_crypt()`.

        |

        *Overload 2:*
        Constructor using `pdf_new_encrypt()`.

        |

        *Overload 3:*
        Constructor using raw copy of pre-existing `pdf_crypt`.
        """
        _mupdf.PdfCrypt_swiginit(self, _mupdf.new_PdfCrypt(*args))
    __swig_destroy__ = _mupdf.delete_PdfCrypt

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfCrypt_m_internal_value(self)
    m_internal = property(_mupdf.PdfCrypt_m_internal_get, _mupdf.PdfCrypt_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register PdfCrypt in _mupdf:
_mupdf.PdfCrypt_swigregister(PdfCrypt)

class PdfCsi(object):
    r""" Wrapper class for struct `pdf_csi`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `pdf_csi`."""
        _mupdf.PdfCsi_swiginit(self, _mupdf.new_PdfCsi(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfCsi_m_internal_value(self)
    m_internal = property(_mupdf.PdfCsi_m_internal_get, _mupdf.PdfCsi_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_PdfCsi

# Register PdfCsi in _mupdf:
_mupdf.PdfCsi_swigregister(PdfCsi)

class PdfDocEvent(object):
    r""" Wrapper class for struct `pdf_doc_event`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def access_exec_menu_item_event(self):
        r""" Wrapper for `pdf_access_exec_menu_item_event()`."""
        return _mupdf.PdfDocEvent_access_exec_menu_item_event(self)

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `pdf_doc_event`."""
        _mupdf.PdfDocEvent_swiginit(self, _mupdf.new_PdfDocEvent(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfDocEvent_m_internal_value(self)
    m_internal = property(_mupdf.PdfDocEvent_m_internal_get, _mupdf.PdfDocEvent_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_PdfDocEvent

# Register PdfDocEvent in _mupdf:
_mupdf.PdfDocEvent_swigregister(PdfDocEvent)

class PdfDocument(object):
    r""" Wrapper class for struct `pdf_document`."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def add_cid_font(self, font):
        r""" Wrapper for `pdf_add_cid_font()`."""
        return _mupdf.PdfDocument_add_cid_font(self, font)

    def add_cjk_font(self, font, script, wmode, serif):
        r""" Wrapper for `pdf_add_cjk_font()`."""
        return _mupdf.PdfDocument_add_cjk_font(self, font, script, wmode, serif)

    def add_embedded_file(self, filename, mimetype, contents):
        r""" Wrapper for `pdf_add_embedded_file()`."""
        return _mupdf.PdfDocument_add_embedded_file(self, filename, mimetype, contents)

    def add_image(self, image):
        r""" Wrapper for `pdf_add_image()`."""
        return _mupdf.PdfDocument_add_image(self, image)

    def add_journal_fragment(self, parent, copy, copy_stream, newobj):
        r""" Wrapper for `pdf_add_journal_fragment()`."""
        return _mupdf.PdfDocument_add_journal_fragment(self, parent, copy, copy_stream, newobj)

    def add_new_array(self, initial):
        r""" Wrapper for `pdf_add_new_array()`."""
        return _mupdf.PdfDocument_add_new_array(self, initial)

    def add_new_dict(self, initial):
        r""" Wrapper for `pdf_add_new_dict()`."""
        return _mupdf.PdfDocument_add_new_dict(self, initial)

    def add_object(self, obj):
        r""" Wrapper for `pdf_add_object()`."""
        return _mupdf.PdfDocument_add_object(self, obj)

    def add_page(self, mediabox, rotate, resources, contents):
        r""" Wrapper for `pdf_add_page()`."""
        return _mupdf.PdfDocument_add_page(self, mediabox, rotate, resources, contents)

    def add_simple_font(self, font, encoding):
        r""" Wrapper for `pdf_add_simple_font()`."""
        return _mupdf.PdfDocument_add_simple_font(self, font, encoding)

    def add_stream(self, buf, obj, compressed):
        r""" Wrapper for `pdf_add_stream()`."""
        return _mupdf.PdfDocument_add_stream(self, buf, obj, compressed)

    def add_substitute_font(self, font):
        r""" Wrapper for `pdf_add_substitute_font()`."""
        return _mupdf.PdfDocument_add_substitute_font(self, font)

    def annot_field_event_keystroke(self, annot, evt):
        r""" Wrapper for `pdf_annot_field_event_keystroke()`."""
        return _mupdf.PdfDocument_annot_field_event_keystroke(self, annot, evt)

    def authenticate_password(self, pw):
        r""" Wrapper for `pdf_authenticate_password()`."""
        return _mupdf.PdfDocument_authenticate_password(self, pw)

    def begin_implicit_operation(self):
        r""" Wrapper for `pdf_begin_implicit_operation()`."""
        return _mupdf.PdfDocument_begin_implicit_operation(self)

    def begin_operation(self, operation):
        r""" Wrapper for `pdf_begin_operation()`."""
        return _mupdf.PdfDocument_begin_operation(self, operation)

    def calculate_form(self):
        r""" Wrapper for `pdf_calculate_form()`."""
        return _mupdf.PdfDocument_calculate_form(self)

    def can_be_saved_incrementally(self):
        r""" Wrapper for `pdf_can_be_saved_incrementally()`."""
        return _mupdf.PdfDocument_can_be_saved_incrementally(self)

    def can_redo(self):
        r""" Wrapper for `pdf_can_redo()`."""
        return _mupdf.PdfDocument_can_redo(self)

    def can_undo(self):
        r""" Wrapper for `pdf_can_undo()`."""
        return _mupdf.PdfDocument_can_undo(self)

    def clear_xref(self):
        r""" Wrapper for `pdf_clear_xref()`."""
        return _mupdf.PdfDocument_clear_xref(self)

    def clear_xref_to_mark(self):
        r""" Wrapper for `pdf_clear_xref_to_mark()`."""
        return _mupdf.PdfDocument_clear_xref_to_mark(self)

    def count_layer_config_ui(self):
        r""" Wrapper for `pdf_count_layer_config_ui()`."""
        return _mupdf.PdfDocument_count_layer_config_ui(self)

    def count_layer_configs(self):
        r""" Wrapper for `pdf_count_layer_configs()`."""
        return _mupdf.PdfDocument_count_layer_configs(self)

    def count_objects(self):
        r""" Wrapper for `pdf_count_objects()`."""
        return _mupdf.PdfDocument_count_objects(self)

    def count_pages(self):
        r""" Wrapper for `pdf_count_pages()`."""
        return _mupdf.PdfDocument_count_pages(self)

    def count_signatures(self):
        r""" Wrapper for `pdf_count_signatures()`."""
        return _mupdf.PdfDocument_count_signatures(self)

    def count_unsaved_versions(self):
        r""" Wrapper for `pdf_count_unsaved_versions()`."""
        return _mupdf.PdfDocument_count_unsaved_versions(self)

    def count_versions(self):
        r""" Wrapper for `pdf_count_versions()`."""
        return _mupdf.PdfDocument_count_versions(self)

    def create_field_name(self, prefix, buf, len):
        r""" Wrapper for `pdf_create_field_name()`."""
        return _mupdf.PdfDocument_create_field_name(self, prefix, buf, len)

    def create_object(self):
        r""" Wrapper for `pdf_create_object()`."""
        return _mupdf.PdfDocument_create_object(self)

    def debug_doc_changes(self):
        r""" Wrapper for `pdf_debug_doc_changes()`."""
        return _mupdf.PdfDocument_debug_doc_changes(self)

    def delete_object(self, num):
        r""" Wrapper for `pdf_delete_object()`."""
        return _mupdf.PdfDocument_delete_object(self, num)

    def delete_page(self, number):
        r""" Wrapper for `pdf_delete_page()`."""
        return _mupdf.PdfDocument_delete_page(self, number)

    def delete_page_range(self, start, end):
        r""" Wrapper for `pdf_delete_page_range()`."""
        return _mupdf.PdfDocument_delete_page_range(self, start, end)

    def deselect_layer_config_ui(self, ui):
        r""" Wrapper for `pdf_deselect_layer_config_ui()`."""
        return _mupdf.PdfDocument_deselect_layer_config_ui(self, ui)

    def deserialise_journal(self, stm):
        r""" Wrapper for `pdf_deserialise_journal()`."""
        return _mupdf.PdfDocument_deserialise_journal(self, stm)

    def disable_js(self):
        r""" Wrapper for `pdf_disable_js()`."""
        return _mupdf.PdfDocument_disable_js(self)

    def doc_was_linearized(self):
        r""" Wrapper for `pdf_doc_was_linearized()`."""
        return _mupdf.PdfDocument_doc_was_linearized(self)

    def document_event_did_print(self):
        r""" Wrapper for `pdf_document_event_did_print()`."""
        return _mupdf.PdfDocument_document_event_did_print(self)

    def document_event_did_save(self):
        r""" Wrapper for `pdf_document_event_did_save()`."""
        return _mupdf.PdfDocument_document_event_did_save(self)

    def document_event_will_close(self):
        r""" Wrapper for `pdf_document_event_will_close()`."""
        return _mupdf.PdfDocument_document_event_will_close(self)

    def document_event_will_print(self):
        r""" Wrapper for `pdf_document_event_will_print()`."""
        return _mupdf.PdfDocument_document_event_will_print(self)

    def document_event_will_save(self):
        r""" Wrapper for `pdf_document_event_will_save()`."""
        return _mupdf.PdfDocument_document_event_will_save(self)

    def document_output_intent(self):
        r""" Wrapper for `pdf_document_output_intent()`."""
        return _mupdf.PdfDocument_document_output_intent(self)

    def document_permissions(self):
        r""" Wrapper for `pdf_document_permissions()`."""
        return _mupdf.PdfDocument_document_permissions(self)

    def empty_store(self):
        r""" Wrapper for `pdf_empty_store()`."""
        return _mupdf.PdfDocument_empty_store(self)

    def enable_journal(self):
        r""" Wrapper for `pdf_enable_journal()`."""
        return _mupdf.PdfDocument_enable_journal(self)

    def enable_js(self):
        r""" Wrapper for `pdf_enable_js()`."""
        return _mupdf.PdfDocument_enable_js(self)

    def end_operation(self):
        r""" Wrapper for `pdf_end_operation()`."""
        return _mupdf.PdfDocument_end_operation(self)

    def ensure_solid_xref(self, num):
        r""" Wrapper for `pdf_ensure_solid_xref()`."""
        return _mupdf.PdfDocument_ensure_solid_xref(self, num)

    def event_issue_alert(self, evt):
        r""" Wrapper for `pdf_event_issue_alert()`."""
        return _mupdf.PdfDocument_event_issue_alert(self, evt)

    def event_issue_exec_menu_item(self, item):
        r""" Wrapper for `pdf_event_issue_exec_menu_item()`."""
        return _mupdf.PdfDocument_event_issue_exec_menu_item(self, item)

    def event_issue_launch_url(self, url, new_frame):
        r""" Wrapper for `pdf_event_issue_launch_url()`."""
        return _mupdf.PdfDocument_event_issue_launch_url(self, url, new_frame)

    def event_issue_mail_doc(self, evt):
        r""" Wrapper for `pdf_event_issue_mail_doc()`."""
        return _mupdf.PdfDocument_event_issue_mail_doc(self, evt)

    def event_issue_print(self):
        r""" Wrapper for `pdf_event_issue_print()`."""
        return _mupdf.PdfDocument_event_issue_print(self)

    def field_event_calculate(self, field):
        r""" Wrapper for `pdf_field_event_calculate()`."""
        return _mupdf.PdfDocument_field_event_calculate(self, field)

    def field_event_format(self, field):
        r""" Wrapper for `pdf_field_event_format()`."""
        return _mupdf.PdfDocument_field_event_format(self, field)

    def field_event_keystroke(self, field, evt):
        r""" Wrapper for `pdf_field_event_keystroke()`."""
        return _mupdf.PdfDocument_field_event_keystroke(self, field, evt)

    def field_event_validate(self, field, value):
        r"""
        Wrapper for `pdf_field_event_validate()`.

        This method has out-params. Python/C# wrappers look like:
        	`field_event_validate(pdf_obj *field, const char *value)` => `(int, char *newvalue)`
        """
        return _mupdf.PdfDocument_field_event_validate(self, field, value)

    def field_reset(self, field):
        r""" Wrapper for `pdf_field_reset()`."""
        return _mupdf.PdfDocument_field_reset(self, field)

    def filter_annot_contents(self, annot, filter):
        r""" Wrapper for `pdf_filter_annot_contents()`."""
        return _mupdf.PdfDocument_filter_annot_contents(self, annot, filter)

    def filter_page_contents(self, page, filter):
        r""" Wrapper for `pdf_filter_page_contents()`."""
        return _mupdf.PdfDocument_filter_page_contents(self, page, filter)

    def find_font_resource(self, type, encoding, item, key):
        r""" Wrapper for `pdf_find_font_resource()`."""
        return _mupdf.PdfDocument_find_font_resource(self, type, encoding, item, key)

    def find_version_for_obj(self, obj):
        r""" Wrapper for `pdf_find_version_for_obj()`."""
        return _mupdf.PdfDocument_find_version_for_obj(self, obj)

    def forget_xref(self):
        r""" Wrapper for `pdf_forget_xref()`."""
        return _mupdf.PdfDocument_forget_xref(self)

    def get_doc_event_callback_data(self):
        r""" Wrapper for `pdf_get_doc_event_callback_data()`."""
        return _mupdf.PdfDocument_get_doc_event_callback_data(self)

    def graft_object(self, obj):
        r""" Wrapper for `pdf_graft_object()`."""
        return _mupdf.PdfDocument_graft_object(self, obj)

    def graft_page(self, page_to, src, page_from):
        r""" Wrapper for `pdf_graft_page()`."""
        return _mupdf.PdfDocument_graft_page(self, page_to, src, page_from)

    def has_permission(self, p):
        r""" Wrapper for `pdf_has_permission()`."""
        return _mupdf.PdfDocument_has_permission(self, p)

    def has_unsaved_changes(self):
        r""" Wrapper for `pdf_has_unsaved_changes()`."""
        return _mupdf.PdfDocument_has_unsaved_changes(self)

    def has_unsaved_sigs(self):
        r""" Wrapper for `pdf_has_unsaved_sigs()`."""
        return _mupdf.PdfDocument_has_unsaved_sigs(self)

    def insert_font_resource(self, key, obj):
        r""" Wrapper for `pdf_insert_font_resource()`."""
        return _mupdf.PdfDocument_insert_font_resource(self, key, obj)

    def insert_page(self, at, page):
        r""" Wrapper for `pdf_insert_page()`."""
        return _mupdf.PdfDocument_insert_page(self, at, page)

    def invalidate_xfa(self):
        r""" Wrapper for `pdf_invalidate_xfa()`."""
        return _mupdf.PdfDocument_invalidate_xfa(self)

    def is_local_object(self, obj):
        r""" Wrapper for `pdf_is_local_object()`."""
        return _mupdf.PdfDocument_is_local_object(self, obj)

    def is_ocg_hidden(self, rdb, usage, ocg):
        r""" Wrapper for `pdf_is_ocg_hidden()`."""
        return _mupdf.PdfDocument_is_ocg_hidden(self, rdb, usage, ocg)

    def js_set_console(self, console, user):
        r""" Wrapper for `pdf_js_set_console()`."""
        return _mupdf.PdfDocument_js_set_console(self, console, user)

    def js_supported(self):
        r""" Wrapper for `pdf_js_supported()`."""
        return _mupdf.PdfDocument_js_supported(self)

    def layer_config_info(self, config_num, info):
        r""" Wrapper for `pdf_layer_config_info()`."""
        return _mupdf.PdfDocument_layer_config_info(self, config_num, info)

    def layer_config_ui_info(self, ui, info):
        r""" Wrapper for `pdf_layer_config_ui_info()`."""
        return _mupdf.PdfDocument_layer_config_ui_info(self, ui, info)

    def load_compressed_inline_image(self, dict, length, cstm, indexed, image):
        r""" Wrapper for `pdf_load_compressed_inline_image()`."""
        return _mupdf.PdfDocument_load_compressed_inline_image(self, dict, length, cstm, indexed, image)

    def load_default_colorspaces(self, page):
        r""" Wrapper for `pdf_load_default_colorspaces()`."""
        return _mupdf.PdfDocument_load_default_colorspaces(self, page)

    def load_embedded_cmap(self, ref):
        r""" Wrapper for `pdf_load_embedded_cmap()`."""
        return _mupdf.PdfDocument_load_embedded_cmap(self, ref)

    def load_image(self, obj):
        r""" Wrapper for `pdf_load_image()`."""
        return _mupdf.PdfDocument_load_image(self, obj)

    def load_inline_image(self, rdb, dict, file):
        r""" Wrapper for `pdf_load_inline_image()`."""
        return _mupdf.PdfDocument_load_inline_image(self, rdb, dict, file)

    def load_journal(self, filename):
        r""" Wrapper for `pdf_load_journal()`."""
        return _mupdf.PdfDocument_load_journal(self, filename)

    def load_link_annots(self, annots, pagenum, page_ctm):
        r""" Wrapper for `pdf_load_link_annots()`."""
        return _mupdf.PdfDocument_load_link_annots(self, annots, pagenum, page_ctm)

    def load_name_tree(self, which):
        r""" Wrapper for `pdf_load_name_tree()`."""
        return _mupdf.PdfDocument_load_name_tree(self, which)

    def load_object(self, num):
        r""" Wrapper for `pdf_load_object()`."""
        return _mupdf.PdfDocument_load_object(self, num)

    def load_outline(self):
        r""" Wrapper for `pdf_load_outline()`."""
        return _mupdf.PdfDocument_load_outline(self)

    def load_page(self, number):
        r""" Wrapper for `pdf_load_page()`."""
        return _mupdf.PdfDocument_load_page(self, number)

    def load_page_tree(self):
        r""" Wrapper for `pdf_load_page_tree()`."""
        return _mupdf.PdfDocument_load_page_tree(self)

    def load_pattern(self, obj):
        r""" Wrapper for `pdf_load_pattern()`."""
        return _mupdf.PdfDocument_load_pattern(self, obj)

    def load_raw_stream_number(self, num):
        r""" Wrapper for `pdf_load_raw_stream_number()`."""
        return _mupdf.PdfDocument_load_raw_stream_number(self, num)

    def load_shading(self, obj):
        r""" Wrapper for `pdf_load_shading()`."""
        return _mupdf.PdfDocument_load_shading(self, obj)

    def load_stream_number(self, num):
        r""" Wrapper for `pdf_load_stream_number()`."""
        return _mupdf.PdfDocument_load_stream_number(self, num)

    def load_to_unicode(self, font, collection, cmapstm):
        r"""
        Wrapper for `pdf_load_to_unicode()`.

        This method has out-params. Python/C# wrappers look like:
        	`load_to_unicode(pdf_font_desc *font, char *collection, pdf_obj *cmapstm)` => const char *strings
        """
        return _mupdf.PdfDocument_load_to_unicode(self, font, collection, cmapstm)

    def load_type3_glyphs(self, fontdesc):
        r""" Wrapper for `pdf_load_type3_glyphs()`."""
        return _mupdf.PdfDocument_load_type3_glyphs(self, fontdesc)

    def load_unencrypted_object(self, num):
        r""" Wrapper for `pdf_load_unencrypted_object()`."""
        return _mupdf.PdfDocument_load_unencrypted_object(self, num)

    def lookup_anchor(self, name):
        r"""
        Wrapper for `pdf_lookup_anchor()`.

        This method has out-params. Python/C# wrappers look like:
        	`lookup_anchor(const char *name)` => `(int, float xp, float yp)`
        """
        return _mupdf.PdfDocument_lookup_anchor(self, name)

    def lookup_dest(self, needle):
        r""" Wrapper for `pdf_lookup_dest()`."""
        return _mupdf.PdfDocument_lookup_dest(self, needle)

    def lookup_name(self, which, needle):
        r""" Wrapper for `pdf_lookup_name()`."""
        return _mupdf.PdfDocument_lookup_name(self, which, needle)

    def lookup_page_number(self, pageobj):
        r""" Wrapper for `pdf_lookup_page_number()`."""
        return _mupdf.PdfDocument_lookup_page_number(self, pageobj)

    def lookup_page_obj(self, needle):
        r""" Wrapper for `pdf_lookup_page_obj()`."""
        return _mupdf.PdfDocument_lookup_page_obj(self, needle)

    def mark_xref(self):
        r""" Wrapper for `pdf_mark_xref()`."""
        return _mupdf.PdfDocument_mark_xref(self)

    def metadata(self):
        r""" Wrapper for `pdf_metadata()`."""
        return _mupdf.PdfDocument_metadata(self)

    def needs_password(self):
        r""" Wrapper for `pdf_needs_password()`."""
        return _mupdf.PdfDocument_needs_password(self)

    def new_action_from_link(self, uri):
        r""" Wrapper for `pdf_new_action_from_link()`."""
        return _mupdf.PdfDocument_new_action_from_link(self, uri)

    def new_array(self, initialcap):
        r""" Wrapper for `pdf_new_array()`."""
        return _mupdf.PdfDocument_new_array(self, initialcap)

    def new_date(self, time):
        r""" Wrapper for `pdf_new_date()`."""
        return _mupdf.PdfDocument_new_date(self, time)

    def new_destination_from_link(self, uri):
        r""" Wrapper for `pdf_new_destination_from_link()`."""
        return _mupdf.PdfDocument_new_destination_from_link(self, uri)

    def new_dict(self, initialcap):
        r""" Wrapper for `pdf_new_dict()`."""
        return _mupdf.PdfDocument_new_dict(self, initialcap)

    def new_filter_processor(self, chain, old_res, new_res, struct_parents, transform, filter):
        r""" Wrapper for `pdf_new_filter_processor()`."""
        return _mupdf.PdfDocument_new_filter_processor(self, chain, old_res, new_res, struct_parents, transform, filter)

    def new_graft_map(self):
        r""" Wrapper for `pdf_new_graft_map()`."""
        return _mupdf.PdfDocument_new_graft_map(self)

    def new_indirect(self, num, gen):
        r""" Wrapper for `pdf_new_indirect()`."""
        return _mupdf.PdfDocument_new_indirect(self, num, gen)

    def new_matrix(self, mtx):
        r""" Wrapper for `pdf_new_matrix()`."""
        return _mupdf.PdfDocument_new_matrix(self, mtx)

    def new_pdf_device(self, topctm, resources, contents):
        r""" Wrapper for `pdf_new_pdf_device()`."""
        return _mupdf.PdfDocument_new_pdf_device(self, topctm, resources, contents)

    def new_rect(self, rect):
        r""" Wrapper for `pdf_new_rect()`."""
        return _mupdf.PdfDocument_new_rect(self, rect)

    def new_xobject(self, bbox, matrix, res, buffer):
        r""" Wrapper for `pdf_new_xobject()`."""
        return _mupdf.PdfDocument_new_xobject(self, bbox, matrix, res, buffer)

    def obj_num_is_stream(self, num):
        r""" Wrapper for `pdf_obj_num_is_stream()`."""
        return _mupdf.PdfDocument_obj_num_is_stream(self, num)

    def open_contents_stream(self, obj):
        r""" Wrapper for `pdf_open_contents_stream()`."""
        return _mupdf.PdfDocument_open_contents_stream(self, obj)

    def open_inline_stream(self, stmobj, length, chain, params):
        r""" Wrapper for `pdf_open_inline_stream()`."""
        return _mupdf.PdfDocument_open_inline_stream(self, stmobj, length, chain, params)

    def open_raw_stream_number(self, num):
        r""" Wrapper for `pdf_open_raw_stream_number()`."""
        return _mupdf.PdfDocument_open_raw_stream_number(self, num)

    def open_stream_number(self, num):
        r""" Wrapper for `pdf_open_stream_number()`."""
        return _mupdf.PdfDocument_open_stream_number(self, num)

    def open_stream_with_offset(self, num, dict, stm_ofs):
        r""" Wrapper for `pdf_open_stream_with_offset()`."""
        return _mupdf.PdfDocument_open_stream_with_offset(self, num, dict, stm_ofs)

    def page_write(self, mediabox, presources, pcontents):
        r"""
        Wrapper for `pdf_page_write()`.

        This method has out-params. Python/C# wrappers look like:
        	`page_write(fz_rect mediabox, pdf_obj **presources, fz_buffer **pcontents)` => `(fz_device *)`
        """
        return _mupdf.PdfDocument_page_write(self, mediabox, presources, pcontents)

    def parse_array(self, f, buf):
        r""" Wrapper for `pdf_parse_array()`."""
        return _mupdf.PdfDocument_parse_array(self, f, buf)

    def parse_dict(self, f, buf):
        r""" Wrapper for `pdf_parse_dict()`."""
        return _mupdf.PdfDocument_parse_dict(self, f, buf)

    def parse_ind_obj(self, f):
        r"""
        Wrapper for `pdf_parse_ind_obj()`.

        This method has out-params. Python/C# wrappers look like:
        	`parse_ind_obj(fz_stream *f)` => `(pdf_obj *, int num, int gen, int64_t stm_ofs, int try_repair)`
        """
        return _mupdf.PdfDocument_parse_ind_obj(self, f)

    def parse_journal_obj(self, stm, ostm):
        r"""
        Wrapper for `pdf_parse_journal_obj()`.

        This method has out-params. Python/C# wrappers look like:
        	`parse_journal_obj(fz_stream *stm, fz_buffer **ostm)` => `(pdf_obj *, int onum, int newobj)`
        """
        return _mupdf.PdfDocument_parse_journal_obj(self, stm, ostm)

    def parse_link_action(self, obj, pagenum):
        r""" Wrapper for `pdf_parse_link_action()`."""
        return _mupdf.PdfDocument_parse_link_action(self, obj, pagenum)

    def parse_link_dest(self, obj):
        r""" Wrapper for `pdf_parse_link_dest()`."""
        return _mupdf.PdfDocument_parse_link_dest(self, obj)

    def parse_stm_obj(self, f, buf):
        r""" Wrapper for `pdf_parse_stm_obj()`."""
        return _mupdf.PdfDocument_parse_stm_obj(self, f, buf)

    def progressive_advance(self, pagenum):
        r""" Wrapper for `pdf_progressive_advance()`."""
        return _mupdf.PdfDocument_progressive_advance(self, pagenum)

    def purge_local_font_resources(self):
        r""" Wrapper for `pdf_purge_local_font_resources()`."""
        return _mupdf.PdfDocument_purge_local_font_resources(self)

    def purge_locals_from_store(self):
        r""" Wrapper for `pdf_purge_locals_from_store()`."""
        return _mupdf.PdfDocument_purge_locals_from_store(self)

    def read_journal(self, stm):
        r""" Wrapper for `pdf_read_journal()`."""
        return _mupdf.PdfDocument_read_journal(self, stm)

    def redact_page(self, page, opts):
        r""" Wrapper for `pdf_redact_page()`."""
        return _mupdf.PdfDocument_redact_page(self, page, opts)

    def redo(self):
        r""" Wrapper for `pdf_redo()`."""
        return _mupdf.PdfDocument_redo(self)

    def repair_obj(self, buf, encrypt, id, page, root):
        r"""
        Wrapper for `pdf_repair_obj()`.

        This method has out-params. Python/C# wrappers look like:
        	`repair_obj(pdf_lexbuf *buf, pdf_obj **encrypt, pdf_obj **id, pdf_obj **page, pdf_obj **root)` => `(int, int64_t stmofsp, int stmlenp, int64_t tmpofs)`
        """
        return _mupdf.PdfDocument_repair_obj(self, buf, encrypt, id, page, root)

    def repair_obj_stms(self):
        r""" Wrapper for `pdf_repair_obj_stms()`."""
        return _mupdf.PdfDocument_repair_obj_stms(self)

    def repair_trailer(self):
        r""" Wrapper for `pdf_repair_trailer()`."""
        return _mupdf.PdfDocument_repair_trailer(self)

    def repair_xref(self):
        r""" Wrapper for `pdf_repair_xref()`."""
        return _mupdf.PdfDocument_repair_xref(self)

    def replace_xref(self, entries, n):
        r""" Wrapper for `pdf_replace_xref()`."""
        return _mupdf.PdfDocument_replace_xref(self, entries, n)

    def reset_form(self, fields, exclude):
        r""" Wrapper for `pdf_reset_form()`."""
        return _mupdf.PdfDocument_reset_form(self, fields, exclude)

    def resolve_link(self, uri):
        r"""
        Wrapper for `pdf_resolve_link()`.

        This method has out-params. Python/C# wrappers look like:
        	`resolve_link(const char *uri)` => `(int, float xp, float yp)`
        """
        return _mupdf.PdfDocument_resolve_link(self, uri)

    def run_glyph(self, resources, contents, dev, ctm, gstate, default_cs):
        r""" Wrapper for `pdf_run_glyph()`."""
        return _mupdf.PdfDocument_run_glyph(self, resources, contents, dev, ctm, gstate, default_cs)

    def save_document(self, filename, opts):
        r""" Wrapper for `pdf_save_document()`."""
        return _mupdf.PdfDocument_save_document(self, filename, opts)

    def save_journal(self, filename):
        r""" Wrapper for `pdf_save_journal()`."""
        return _mupdf.PdfDocument_save_journal(self, filename)

    def save_snapshot(self, filename):
        r""" Wrapper for `pdf_save_snapshot()`."""
        return _mupdf.PdfDocument_save_snapshot(self, filename)

    def select_layer_config(self, config_num):
        r""" Wrapper for `pdf_select_layer_config()`."""
        return _mupdf.PdfDocument_select_layer_config(self, config_num)

    def select_layer_config_ui(self, ui):
        r""" Wrapper for `pdf_select_layer_config_ui()`."""
        return _mupdf.PdfDocument_select_layer_config_ui(self, ui)

    def serialise_journal(self, out):
        r""" Wrapper for `pdf_serialise_journal()`."""
        return _mupdf.PdfDocument_serialise_journal(self, out)

    def set_annot_field_value(self, widget, text, ignore_trigger_events):
        r""" Wrapper for `pdf_set_annot_field_value()`."""
        return _mupdf.PdfDocument_set_annot_field_value(self, widget, text, ignore_trigger_events)

    def set_doc_event_callback(self, event_cb, free_event_data_cb, data):
        r""" Wrapper for `pdf_set_doc_event_callback()`."""
        return _mupdf.PdfDocument_set_doc_event_callback(self, event_cb, free_event_data_cb, data)

    def set_document_language(self, lang):
        r""" Wrapper for `pdf_set_document_language()`."""
        return _mupdf.PdfDocument_set_document_language(self, lang)

    def set_field_value(self, field, text, ignore_trigger_events):
        r""" Wrapper for `pdf_set_field_value()`."""
        return _mupdf.PdfDocument_set_field_value(self, field, text, ignore_trigger_events)

    def set_layer_config_as_default(self):
        r""" Wrapper for `pdf_set_layer_config_as_default()`."""
        return _mupdf.PdfDocument_set_layer_config_as_default(self)

    def set_populating_xref_trailer(self, trailer):
        r""" Wrapper for `pdf_set_populating_xref_trailer()`."""
        return _mupdf.PdfDocument_set_populating_xref_trailer(self, trailer)

    def signature_byte_range(self, signature, byte_range):
        r""" Wrapper for `pdf_signature_byte_range()`."""
        return _mupdf.PdfDocument_signature_byte_range(self, signature, byte_range)

    def signature_contents(self, signature):
        r"""
        Wrapper for `pdf_signature_contents()`.

        This method has out-params. Python/C# wrappers look like:
        	`signature_contents(pdf_obj *signature)` => `(size_t, char *contents)`
        """
        return _mupdf.PdfDocument_signature_contents(self, signature)

    def signature_hash_bytes(self, signature):
        r""" Wrapper for `pdf_signature_hash_bytes()`."""
        return _mupdf.PdfDocument_signature_hash_bytes(self, signature)

    def signature_incremental_change_since_signing(self, signature):
        r""" Wrapper for `pdf_signature_incremental_change_since_signing()`."""
        return _mupdf.PdfDocument_signature_incremental_change_since_signing(self, signature)

    def signature_is_signed(self, field):
        r""" Wrapper for `pdf_signature_is_signed()`."""
        return _mupdf.PdfDocument_signature_is_signed(self, field)

    def signature_set_value(self, field, signer, stime):
        r""" Wrapper for `pdf_signature_set_value()`."""
        return _mupdf.PdfDocument_signature_set_value(self, field, signer, stime)

    def toggle_layer_config_ui(self, ui):
        r""" Wrapper for `pdf_toggle_layer_config_ui()`."""
        return _mupdf.PdfDocument_toggle_layer_config_ui(self, ui)

    def trailer(self):
        r""" Wrapper for `pdf_trailer()`."""
        return _mupdf.PdfDocument_trailer(self)

    def undo(self):
        r""" Wrapper for `pdf_undo()`."""
        return _mupdf.PdfDocument_undo(self)

    def undoredo_state(self):
        r"""
        Wrapper for `pdf_undoredo_state()`.

        This method has out-params. Python/C# wrappers look like:
        	`undoredo_state()` => `(int, int steps)`
        """
        return _mupdf.PdfDocument_undoredo_state(self)

    def undoredo_step(self, step):
        r""" Wrapper for `pdf_undoredo_step()`."""
        return _mupdf.PdfDocument_undoredo_step(self, step)

    def update_object(self, num, obj):
        r""" Wrapper for `pdf_update_object()`."""
        return _mupdf.PdfDocument_update_object(self, num, obj)

    def update_stream(self, ref, buf, compressed):
        r""" Wrapper for `pdf_update_stream()`."""
        return _mupdf.PdfDocument_update_stream(self, ref, buf, compressed)

    def update_xobject(self, xobj, bbox, mat, res, buffer):
        r""" Wrapper for `pdf_update_xobject()`."""
        return _mupdf.PdfDocument_update_xobject(self, xobj, bbox, mat, res, buffer)

    def validate_change_history(self):
        r""" Wrapper for `pdf_validate_change_history()`."""
        return _mupdf.PdfDocument_validate_change_history(self)

    def validate_changes(self, version):
        r""" Wrapper for `pdf_validate_changes()`."""
        return _mupdf.PdfDocument_validate_changes(self, version)

    def version(self):
        r""" Wrapper for `pdf_version()`."""
        return _mupdf.PdfDocument_version(self)

    def was_pure_xfa(self):
        r""" Wrapper for `pdf_was_pure_xfa()`."""
        return _mupdf.PdfDocument_was_pure_xfa(self)

    def was_repaired(self):
        r""" Wrapper for `pdf_was_repaired()`."""
        return _mupdf.PdfDocument_was_repaired(self)

    def write_document(self, out, opts):
        r""" Wrapper for `pdf_write_document()`."""
        return _mupdf.PdfDocument_write_document(self, out, opts)

    def write_journal(self, out):
        r""" Wrapper for `pdf_write_journal()`."""
        return _mupdf.PdfDocument_write_journal(self, out)

    def write_snapshot(self, out):
        r""" Wrapper for `pdf_write_snapshot()`."""
        return _mupdf.PdfDocument_write_snapshot(self, out)

    def xref_ensure_incremental_object(self, num):
        r""" Wrapper for `pdf_xref_ensure_incremental_object()`."""
        return _mupdf.PdfDocument_xref_ensure_incremental_object(self, num)

    def xref_ensure_local_object(self, num):
        r""" Wrapper for `pdf_xref_ensure_local_object()`."""
        return _mupdf.PdfDocument_xref_ensure_local_object(self, num)

    def xref_is_incremental(self, num):
        r""" Wrapper for `pdf_xref_is_incremental()`."""
        return _mupdf.PdfDocument_xref_is_incremental(self, num)

    def xref_len(self):
        r""" Wrapper for `pdf_xref_len()`."""
        return _mupdf.PdfDocument_xref_len(self)

    def xref_obj_is_unsaved_signature(self, obj):
        r""" Wrapper for `pdf_xref_obj_is_unsaved_signature()`."""
        return _mupdf.PdfDocument_xref_obj_is_unsaved_signature(self, obj)

    def xref_remove_unsaved_signature(self, field):
        r""" Wrapper for `pdf_xref_remove_unsaved_signature()`."""
        return _mupdf.PdfDocument_xref_remove_unsaved_signature(self, field)

    def xref_store_unsaved_signature(self, field, signer):
        r""" Wrapper for `pdf_xref_store_unsaved_signature()`."""
        return _mupdf.PdfDocument_xref_store_unsaved_signature(self, field, signer)

    def lookup_metadata(self, *args):
        r"""
        *Overload 1:*
         Wrapper for `pdf_lookup_metadata()`.

        |

        *Overload 2:*
         Wrapper for pdf_lookup_metadata() that returns a std::string and sets
        o_out to length of string plus one. If <key> is not found, returns empty
        	string with *o_out=-1. <o_out> can be NULL if caller is not interested in
        	error information.

        |

        *Overload 3:*
         Wrapper for pdf_lookup_metadata() that returns a std::string and sets
        o_out to length of string plus one. If <key> is not found, returns empty
        	string with *o_out=-1. <o_out> can be NULL if caller is not interested in
        	error information.
        """
        return _mupdf.PdfDocument_lookup_metadata(self, *args)

    def super(self):
        r""" Returns wrapper for .super member."""
        return _mupdf.PdfDocument_super(self)

    def __init__(self, *args):
        r"""
        *Overload 1:*
        == Constructors.  Constructor using `pdf_create_document()`.

        |

        *Overload 2:*
        Constructor using `pdf_document_from_fz_document()`.

        |

        *Overload 3:*
        Constructor using `pdf_open_document()`.

        |

        *Overload 4:*
        Constructor using `pdf_open_document_with_stream()`.

        |

        *Overload 5:*
        Copy constructor using `pdf_keep_document()`.

        |

        *Overload 6:*
        Constructor using raw copy of pre-existing `pdf_document`.
        """
        _mupdf.PdfDocument_swiginit(self, _mupdf.new_PdfDocument(*args))
    __swig_destroy__ = _mupdf.delete_PdfDocument

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfDocument_m_internal_value(self)
    m_internal = property(_mupdf.PdfDocument_m_internal_get, _mupdf.PdfDocument_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register PdfDocument in _mupdf:
_mupdf.PdfDocument_swigregister(PdfDocument)

class PdfFilterOptions(object):
    r""" Wrapper class for struct `pdf_filter_options`."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*
        Default constructor initialises all fields to null/zero.

        |

        *Overload 2:*
        We use default copy constructor and operator=.  Constructor using raw copy of pre-existing `pdf_filter_options`.

        |

        *Overload 3:*
        Constructor using raw copy of pre-existing `pdf_filter_options`.
        """
        _mupdf.PdfFilterOptions_swiginit(self, _mupdf.new_PdfFilterOptions(*args))

    def internal(self, *args):
        r"""
        *Overload 1:*
        Access as underlying struct.

        |

        *Overload 2:*
        Access as underlying struct.
        """
        return _mupdf.PdfFilterOptions_internal(self, *args)
    opaque = property(_mupdf.PdfFilterOptions_opaque_get, _mupdf.PdfFilterOptions_opaque_set, doc=r""" We use default destructor.""")
    image_filter = property(_mupdf.PdfFilterOptions_image_filter_get, _mupdf.PdfFilterOptions_image_filter_set)
    text_filter = property(_mupdf.PdfFilterOptions_text_filter_get, _mupdf.PdfFilterOptions_text_filter_set)
    after_text_object = property(_mupdf.PdfFilterOptions_after_text_object_get, _mupdf.PdfFilterOptions_after_text_object_set)
    end_page = property(_mupdf.PdfFilterOptions_end_page_get, _mupdf.PdfFilterOptions_end_page_set)
    recurse = property(_mupdf.PdfFilterOptions_recurse_get, _mupdf.PdfFilterOptions_recurse_set)
    instance_forms = property(_mupdf.PdfFilterOptions_instance_forms_get, _mupdf.PdfFilterOptions_instance_forms_set)
    sanitize = property(_mupdf.PdfFilterOptions_sanitize_get, _mupdf.PdfFilterOptions_sanitize_set)
    ascii = property(_mupdf.PdfFilterOptions_ascii_get, _mupdf.PdfFilterOptions_ascii_set)

    def to_string(self):
        r""" Returns string containing our members, labelled and inside (...), using operator<<."""
        return _mupdf.PdfFilterOptions_to_string(self)
    __swig_destroy__ = _mupdf.delete_PdfFilterOptions

# Register PdfFilterOptions in _mupdf:
_mupdf.PdfFilterOptions_swigregister(PdfFilterOptions)

class PdfFilterOptions2(PdfFilterOptions):
    r""" Wrapper class for struct pdf_filter_options with virtual fns for each fnptr; this is for use as a SWIG Director class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" == Constructor."""
        if self.__class__ == PdfFilterOptions2:
            _self = None
        else:
            _self = self
        _mupdf.PdfFilterOptions2_swiginit(self, _mupdf.new_PdfFilterOptions2(_self, ))

    def use_virtual_image_filter(self, use=True):
        r"""
        These methods set the function pointers in *m_internal
        to point to internal callbacks that call our virtual methods.
        """
        return _mupdf.PdfFilterOptions2_use_virtual_image_filter(self, use)

    def use_virtual_text_filter(self, use=True):
        return _mupdf.PdfFilterOptions2_use_virtual_text_filter(self, use)

    def use_virtual_after_text_object(self, use=True):
        return _mupdf.PdfFilterOptions2_use_virtual_after_text_object(self, use)

    def use_virtual_end_page(self, use=True):
        return _mupdf.PdfFilterOptions2_use_virtual_end_page(self, use)

    def image_filter(self, arg_2, arg_3, arg_4):
        r""" Default virtual method implementations; these all throw an exception."""
        return _mupdf.PdfFilterOptions2_image_filter(self, arg_2, arg_3, arg_4)

    def text_filter(self, arg_2, arg_3, arg_4, arg_5, arg_6):
        return _mupdf.PdfFilterOptions2_text_filter(self, arg_2, arg_3, arg_4, arg_5, arg_6)

    def after_text_object(self, arg_2, arg_3, arg_4):
        return _mupdf.PdfFilterOptions2_after_text_object(self, arg_2, arg_3, arg_4)

    def end_page(self, arg_2):
        return _mupdf.PdfFilterOptions2_end_page(self, arg_2)
    __swig_destroy__ = _mupdf.delete_PdfFilterOptions2
    def __disown__(self):
        self.this.disown()
        _mupdf.disown_PdfFilterOptions2(self)
        return weakref.proxy(self)

# Register PdfFilterOptions2 in _mupdf:
_mupdf.PdfFilterOptions2_swigregister(PdfFilterOptions2)

class PdfFontDesc(object):
    r""" Wrapper class for struct `pdf_font_desc`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def add_hmtx(self, lo, hi, w):
        r""" Wrapper for `pdf_add_hmtx()`."""
        return _mupdf.PdfFontDesc_add_hmtx(self, lo, hi, w)

    def add_vmtx(self, lo, hi, x, y, w):
        r""" Wrapper for `pdf_add_vmtx()`."""
        return _mupdf.PdfFontDesc_add_vmtx(self, lo, hi, x, y, w)

    def end_hmtx(self):
        r""" Wrapper for `pdf_end_hmtx()`."""
        return _mupdf.PdfFontDesc_end_hmtx(self)

    def end_vmtx(self):
        r""" Wrapper for `pdf_end_vmtx()`."""
        return _mupdf.PdfFontDesc_end_vmtx(self)

    def font_cid_to_gid(self, cid):
        r""" Wrapper for `pdf_font_cid_to_gid()`."""
        return _mupdf.PdfFontDesc_font_cid_to_gid(self, cid)

    def set_default_hmtx(self, w):
        r""" Wrapper for `pdf_set_default_hmtx()`."""
        return _mupdf.PdfFontDesc_set_default_hmtx(self, w)

    def set_default_vmtx(self, y, w):
        r""" Wrapper for `pdf_set_default_vmtx()`."""
        return _mupdf.PdfFontDesc_set_default_vmtx(self, y, w)

    def set_font_wmode(self, wmode):
        r""" Wrapper for `pdf_set_font_wmode()`."""
        return _mupdf.PdfFontDesc_set_font_wmode(self, wmode)

    def __init__(self, *args):
        r"""
        *Overload 1:*
        == Constructors.  Constructor using `pdf_new_font_desc()`.

        |

        *Overload 2:*
        Constructor using raw copy of pre-existing `pdf_font_desc`.
        """
        _mupdf.PdfFontDesc_swiginit(self, _mupdf.new_PdfFontDesc(*args))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfFontDesc_m_internal_value(self)
    m_internal = property(_mupdf.PdfFontDesc_m_internal_get, _mupdf.PdfFontDesc_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_PdfFontDesc

# Register PdfFontDesc in _mupdf:
_mupdf.PdfFontDesc_swigregister(PdfFontDesc)

class PdfFontResourceKey(object):
    r""" Wrapper class for struct `pdf_font_resource_key`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `pdf_font_resource_key`."""
        _mupdf.PdfFontResourceKey_swiginit(self, _mupdf.new_PdfFontResourceKey(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfFontResourceKey_m_internal_value(self)
    m_internal = property(_mupdf.PdfFontResourceKey_m_internal_get, _mupdf.PdfFontResourceKey_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_PdfFontResourceKey

# Register PdfFontResourceKey in _mupdf:
_mupdf.PdfFontResourceKey_swigregister(PdfFontResourceKey)

class PdfFunction(object):
    r""" Wrapper class for struct `pdf_function`."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def eval_function(self, _in, inlen, outlen):
        r"""
        Wrapper for `pdf_eval_function()`.

        This method has out-params. Python/C# wrappers look like:
        	`eval_function(const float *in, int inlen, int outlen)` => float out
        """
        return _mupdf.PdfFunction_eval_function(self, _in, inlen, outlen)

    def function_size(self):
        r""" Wrapper for `pdf_function_size()`."""
        return _mupdf.PdfFunction_function_size(self)

    def __init__(self, *args):
        r"""
        *Overload 1:*
        Copy constructor using `pdf_keep_function()`.

        |

        *Overload 2:*
        Constructor using raw copy of pre-existing `pdf_function`.
        """
        _mupdf.PdfFunction_swiginit(self, _mupdf.new_PdfFunction(*args))
    __swig_destroy__ = _mupdf.delete_PdfFunction

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfFunction_m_internal_value(self)
    m_internal = property(_mupdf.PdfFunction_m_internal_get, _mupdf.PdfFunction_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register PdfFunction in _mupdf:
_mupdf.PdfFunction_swigregister(PdfFunction)

class PdfGraftMap(object):
    r""" Wrapper class for struct `pdf_graft_map`."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def graft_mapped_object(self, obj):
        r""" Wrapper for `pdf_graft_mapped_object()`."""
        return _mupdf.PdfGraftMap_graft_mapped_object(self, obj)

    def graft_mapped_page(self, page_to, src, page_from):
        r""" Wrapper for `pdf_graft_mapped_page()`."""
        return _mupdf.PdfGraftMap_graft_mapped_page(self, page_to, src, page_from)

    def __init__(self, *args):
        r"""
        *Overload 1:*
        == Constructors.  Constructor using `pdf_new_graft_map()`.

        |

        *Overload 2:*
        Copy constructor using `pdf_keep_graft_map()`.

        |

        *Overload 3:*
        Constructor using raw copy of pre-existing `pdf_graft_map`.
        """
        _mupdf.PdfGraftMap_swiginit(self, _mupdf.new_PdfGraftMap(*args))
    __swig_destroy__ = _mupdf.delete_PdfGraftMap

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfGraftMap_m_internal_value(self)
    m_internal = property(_mupdf.PdfGraftMap_m_internal_get, _mupdf.PdfGraftMap_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register PdfGraftMap in _mupdf:
_mupdf.PdfGraftMap_swigregister(PdfGraftMap)

class PdfGstate(object):
    r""" Wrapper class for struct `pdf_gstate`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `pdf_gstate`."""
        _mupdf.PdfGstate_swiginit(self, _mupdf.new_PdfGstate(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfGstate_m_internal_value(self)
    m_internal = property(_mupdf.PdfGstate_m_internal_get, _mupdf.PdfGstate_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_PdfGstate

# Register PdfGstate in _mupdf:
_mupdf.PdfGstate_swigregister(PdfGstate)

class PdfHintPage(object):
    r""" Wrapper class for struct `pdf_hint_page`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `pdf_hint_page`."""
        _mupdf.PdfHintPage_swiginit(self, _mupdf.new_PdfHintPage(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfHintPage_m_internal_value(self)
    m_internal = property(_mupdf.PdfHintPage_m_internal_get, _mupdf.PdfHintPage_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_PdfHintPage

# Register PdfHintPage in _mupdf:
_mupdf.PdfHintPage_swigregister(PdfHintPage)

class PdfHintShared(object):
    r""" Wrapper class for struct `pdf_hint_shared`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `pdf_hint_shared`."""
        _mupdf.PdfHintShared_swiginit(self, _mupdf.new_PdfHintShared(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfHintShared_m_internal_value(self)
    m_internal = property(_mupdf.PdfHintShared_m_internal_get, _mupdf.PdfHintShared_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_PdfHintShared

# Register PdfHintShared in _mupdf:
_mupdf.PdfHintShared_swigregister(PdfHintShared)

class PdfHmtx(object):
    r""" Wrapper class for struct `pdf_hmtx`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `pdf_hmtx`."""
        _mupdf.PdfHmtx_swiginit(self, _mupdf.new_PdfHmtx(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfHmtx_m_internal_value(self)
    m_internal = property(_mupdf.PdfHmtx_m_internal_get, _mupdf.PdfHmtx_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_PdfHmtx

# Register PdfHmtx in _mupdf:
_mupdf.PdfHmtx_swigregister(PdfHmtx)

class PdfJournal(object):
    r""" Wrapper class for struct `pdf_journal`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def discard_journal(self):
        r""" Wrapper for `pdf_discard_journal()`."""
        return _mupdf.PdfJournal_discard_journal(self)

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `pdf_journal`."""
        _mupdf.PdfJournal_swiginit(self, _mupdf.new_PdfJournal(internal))
    __swig_destroy__ = _mupdf.delete_PdfJournal

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfJournal_m_internal_value(self)
    m_internal = property(_mupdf.PdfJournal_m_internal_get, _mupdf.PdfJournal_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register PdfJournal in _mupdf:
_mupdf.PdfJournal_swigregister(PdfJournal)

class PdfJs(object):
    r""" Wrapper class for struct `pdf_js`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def js_event_init(self, target, value, willCommit):
        r""" Wrapper for `pdf_js_event_init()`."""
        return _mupdf.PdfJs_js_event_init(self, target, value, willCommit)

    def js_event_init_keystroke(self, target, evt):
        r""" Wrapper for `pdf_js_event_init_keystroke()`."""
        return _mupdf.PdfJs_js_event_init_keystroke(self, target, evt)

    def js_event_result(self):
        r""" Wrapper for `pdf_js_event_result()`."""
        return _mupdf.PdfJs_js_event_result(self)

    def js_event_result_keystroke(self, evt):
        r""" Wrapper for `pdf_js_event_result_keystroke()`."""
        return _mupdf.PdfJs_js_event_result_keystroke(self, evt)

    def js_event_result_validate(self):
        r"""
        Wrapper for `pdf_js_event_result_validate()`.

        This method has out-params. Python/C# wrappers look like:
        	`js_event_result_validate()` => `(int, char *newvalue)`
        """
        return _mupdf.PdfJs_js_event_result_validate(self)

    def js_event_value(self):
        r""" Wrapper for `pdf_js_event_value()`."""
        return _mupdf.PdfJs_js_event_value(self)

    def js_execute(self, name, code):
        r"""
        Wrapper for `pdf_js_execute()`.

        This method has out-params. Python/C# wrappers look like:
        	`js_execute(const char *name, const char *code)` => char *result
        """
        return _mupdf.PdfJs_js_execute(self, name, code)

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `pdf_js`."""
        _mupdf.PdfJs_swiginit(self, _mupdf.new_PdfJs(internal))
    __swig_destroy__ = _mupdf.delete_PdfJs

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfJs_m_internal_value(self)
    m_internal = property(_mupdf.PdfJs_m_internal_get, _mupdf.PdfJs_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register PdfJs in _mupdf:
_mupdf.PdfJs_swigregister(PdfJs)

class PdfJsConsole(object):
    r""" Wrapper class for struct `pdf_js_console`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `pdf_js_console`."""
        _mupdf.PdfJsConsole_swiginit(self, _mupdf.new_PdfJsConsole(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfJsConsole_m_internal_value(self)
    m_internal = property(_mupdf.PdfJsConsole_m_internal_get, _mupdf.PdfJsConsole_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_PdfJsConsole

# Register PdfJsConsole in _mupdf:
_mupdf.PdfJsConsole_swigregister(PdfJsConsole)

class PdfKeystrokeEvent(object):
    r""" Wrapper class for struct `pdf_keystroke_event`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `pdf_keystroke_event`."""
        _mupdf.PdfKeystrokeEvent_swiginit(self, _mupdf.new_PdfKeystrokeEvent(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfKeystrokeEvent_m_internal_value(self)
    m_internal = property(_mupdf.PdfKeystrokeEvent_m_internal_get, _mupdf.PdfKeystrokeEvent_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_PdfKeystrokeEvent

# Register PdfKeystrokeEvent in _mupdf:
_mupdf.PdfKeystrokeEvent_swigregister(PdfKeystrokeEvent)

class PdfLaunchUrlEvent(object):
    r""" Wrapper class for struct `pdf_launch_url_event`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `pdf_launch_url_event`."""
        _mupdf.PdfLaunchUrlEvent_swiginit(self, _mupdf.new_PdfLaunchUrlEvent(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfLaunchUrlEvent_m_internal_value(self)
    m_internal = property(_mupdf.PdfLaunchUrlEvent_m_internal_get, _mupdf.PdfLaunchUrlEvent_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_PdfLaunchUrlEvent

# Register PdfLaunchUrlEvent in _mupdf:
_mupdf.PdfLaunchUrlEvent_swigregister(PdfLaunchUrlEvent)

class PdfLayerConfig(object):
    r""" Wrapper class for struct `pdf_layer_config`."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*
        Default constructor sets .name and .creator to null.

        |

        *Overload 2:*
        We use default copy constructor and operator=.  Constructor using raw copy of pre-existing `pdf_layer_config`.

        |

        *Overload 3:*
        Constructor using raw copy of pre-existing `pdf_layer_config`.
        """
        _mupdf.PdfLayerConfig_swiginit(self, _mupdf.new_PdfLayerConfig(*args))

    def internal(self, *args):
        r"""
        *Overload 1:*
        Access as underlying struct.

        |

        *Overload 2:*
        Access as underlying struct.
        """
        return _mupdf.PdfLayerConfig_internal(self, *args)
    name = property(_mupdf.PdfLayerConfig_name_get, _mupdf.PdfLayerConfig_name_set, doc=r""" We use default destructor.""")
    creator = property(_mupdf.PdfLayerConfig_creator_get, _mupdf.PdfLayerConfig_creator_set)

    def to_string(self):
        r""" Returns string containing our members, labelled and inside (...), using operator<<."""
        return _mupdf.PdfLayerConfig_to_string(self)
    __swig_destroy__ = _mupdf.delete_PdfLayerConfig

# Register PdfLayerConfig in _mupdf:
_mupdf.PdfLayerConfig_swigregister(PdfLayerConfig)

class PdfLayerConfigUi(object):
    r""" Wrapper class for struct `pdf_layer_config_ui`."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*
        Default constructor sets all .text to null and other fields to zero.

        |

        *Overload 2:*
        We use default copy constructor and operator=.  Constructor using raw copy of pre-existing `pdf_layer_config_ui`.

        |

        *Overload 3:*
        Constructor using raw copy of pre-existing `pdf_layer_config_ui`.
        """
        _mupdf.PdfLayerConfigUi_swiginit(self, _mupdf.new_PdfLayerConfigUi(*args))

    def internal(self, *args):
        r"""
        *Overload 1:*
        Access as underlying struct.

        |

        *Overload 2:*
        Access as underlying struct.
        """
        return _mupdf.PdfLayerConfigUi_internal(self, *args)
    text = property(_mupdf.PdfLayerConfigUi_text_get, _mupdf.PdfLayerConfigUi_text_set, doc=r""" We use default destructor.""")
    depth = property(_mupdf.PdfLayerConfigUi_depth_get, _mupdf.PdfLayerConfigUi_depth_set)
    type = property(_mupdf.PdfLayerConfigUi_type_get, _mupdf.PdfLayerConfigUi_type_set)
    selected = property(_mupdf.PdfLayerConfigUi_selected_get, _mupdf.PdfLayerConfigUi_selected_set)
    locked = property(_mupdf.PdfLayerConfigUi_locked_get, _mupdf.PdfLayerConfigUi_locked_set)

    def to_string(self):
        r""" Returns string containing our members, labelled and inside (...), using operator<<."""
        return _mupdf.PdfLayerConfigUi_to_string(self)
    __swig_destroy__ = _mupdf.delete_PdfLayerConfigUi

# Register PdfLayerConfigUi in _mupdf:
_mupdf.PdfLayerConfigUi_swigregister(PdfLayerConfigUi)

class PdfLexbuf(object):
    r""" Wrapper class for struct `pdf_lexbuf`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def lexbuf_fin(self):
        r""" Wrapper for `pdf_lexbuf_fin()`."""
        return _mupdf.PdfLexbuf_lexbuf_fin(self)

    def lexbuf_grow(self):
        r""" Wrapper for `pdf_lexbuf_grow()`."""
        return _mupdf.PdfLexbuf_lexbuf_grow(self)

    def lexbuf_init(self, size):
        r""" Wrapper for `pdf_lexbuf_init()`."""
        return _mupdf.PdfLexbuf_lexbuf_init(self, size)
    __swig_destroy__ = _mupdf.delete_PdfLexbuf

    def __init__(self, *args):
        r"""
        *Overload 1:*
        Constructor that calls pdf_lexbuf_init(size)

        |

        *Overload 2:*
        Constructor using raw copy of pre-existing `pdf_lexbuf`.
        """
        _mupdf.PdfLexbuf_swiginit(self, _mupdf.new_PdfLexbuf(*args))

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfLexbuf_m_internal_value(self)
    m_internal = property(_mupdf.PdfLexbuf_m_internal_get, _mupdf.PdfLexbuf_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register PdfLexbuf in _mupdf:
_mupdf.PdfLexbuf_swigregister(PdfLexbuf)

class PdfLexbufLarge(object):
    r""" Wrapper class for struct `pdf_lexbuf_large`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `pdf_lexbuf_large`."""
        _mupdf.PdfLexbufLarge_swiginit(self, _mupdf.new_PdfLexbufLarge(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfLexbufLarge_m_internal_value(self)
    m_internal = property(_mupdf.PdfLexbufLarge_m_internal_get, _mupdf.PdfLexbufLarge_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_PdfLexbufLarge

# Register PdfLexbufLarge in _mupdf:
_mupdf.PdfLexbufLarge_swigregister(PdfLexbufLarge)

class PdfLockedFields(object):
    r""" Wrapper class for struct `pdf_locked_fields`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def is_field_locked(self, name):
        r""" Wrapper for `pdf_is_field_locked()`."""
        return _mupdf.PdfLockedFields_is_field_locked(self, name)

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `pdf_locked_fields`."""
        _mupdf.PdfLockedFields_swiginit(self, _mupdf.new_PdfLockedFields(internal))
    __swig_destroy__ = _mupdf.delete_PdfLockedFields

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfLockedFields_m_internal_value(self)
    m_internal = property(_mupdf.PdfLockedFields_m_internal_get, _mupdf.PdfLockedFields_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register PdfLockedFields in _mupdf:
_mupdf.PdfLockedFields_swigregister(PdfLockedFields)

class PdfMailDocEvent(object):
    r""" Wrapper class for struct `pdf_mail_doc_event`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `pdf_mail_doc_event`."""
        _mupdf.PdfMailDocEvent_swiginit(self, _mupdf.new_PdfMailDocEvent(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfMailDocEvent_m_internal_value(self)
    m_internal = property(_mupdf.PdfMailDocEvent_m_internal_get, _mupdf.PdfMailDocEvent_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_PdfMailDocEvent

# Register PdfMailDocEvent in _mupdf:
_mupdf.PdfMailDocEvent_swigregister(PdfMailDocEvent)

class PdfMarkList(object):
    r""" Wrapper class for struct `pdf_mark_list`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def mark_list_free(self):
        r""" Wrapper for `pdf_mark_list_free()`."""
        return _mupdf.PdfMarkList_mark_list_free(self)

    def mark_list_init(self):
        r""" Wrapper for `pdf_mark_list_init()`."""
        return _mupdf.PdfMarkList_mark_list_init(self)

    def mark_list_pop(self):
        r""" Wrapper for `pdf_mark_list_pop()`."""
        return _mupdf.PdfMarkList_mark_list_pop(self)

    def mark_list_push(self, obj):
        r""" Wrapper for `pdf_mark_list_push()`."""
        return _mupdf.PdfMarkList_mark_list_push(self, obj)

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `pdf_mark_list`."""
        _mupdf.PdfMarkList_swiginit(self, _mupdf.new_PdfMarkList(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfMarkList_m_internal_value(self)
    m_internal = property(_mupdf.PdfMarkList_m_internal_get, _mupdf.PdfMarkList_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_PdfMarkList

# Register PdfMarkList in _mupdf:
_mupdf.PdfMarkList_swigregister(PdfMarkList)

class PdfMrange(object):
    r""" Wrapper class for struct `pdf_mrange`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `pdf_mrange`."""
        _mupdf.PdfMrange_swiginit(self, _mupdf.new_PdfMrange(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfMrange_m_internal_value(self)
    m_internal = property(_mupdf.PdfMrange_m_internal_get, _mupdf.PdfMrange_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_PdfMrange

# Register PdfMrange in _mupdf:
_mupdf.PdfMrange_swigregister(PdfMrange)

class PdfObj(object):
    r""" Wrapper class for struct `pdf_obj`."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def new_text_string(s):
        r""" Wrapper for `pdf_new_text_string()`."""
        return _mupdf.PdfObj_new_text_string(s)

    @staticmethod
    def new_dict(doc, initialcap):
        r""" Wrapper for `pdf_new_dict()`."""
        return _mupdf.PdfObj_new_dict(doc, initialcap)

    @staticmethod
    def new_action_from_link(doc, uri):
        r""" Wrapper for `pdf_new_action_from_link()`."""
        return _mupdf.PdfObj_new_action_from_link(doc, uri)

    def array_contains(self, obj):
        r""" Wrapper for `pdf_array_contains()`."""
        return _mupdf.PdfObj_array_contains(self, obj)

    def array_delete(self, index):
        r""" Wrapper for `pdf_array_delete()`."""
        return _mupdf.PdfObj_array_delete(self, index)

    def array_find(self, obj):
        r""" Wrapper for `pdf_array_find()`."""
        return _mupdf.PdfObj_array_find(self, obj)

    def array_get(self, i):
        r""" Wrapper for `pdf_array_get()`."""
        return _mupdf.PdfObj_array_get(self, i)

    def array_get_bool(self, index):
        r""" Wrapper for `pdf_array_get_bool()`."""
        return _mupdf.PdfObj_array_get_bool(self, index)

    def array_get_int(self, index):
        r""" Wrapper for `pdf_array_get_int()`."""
        return _mupdf.PdfObj_array_get_int(self, index)

    def array_get_matrix(self, index):
        r""" Wrapper for `pdf_array_get_matrix()`."""
        return _mupdf.PdfObj_array_get_matrix(self, index)

    def array_get_name(self, index):
        r""" Wrapper for `pdf_array_get_name()`."""
        return _mupdf.PdfObj_array_get_name(self, index)

    def array_get_real(self, index):
        r""" Wrapper for `pdf_array_get_real()`."""
        return _mupdf.PdfObj_array_get_real(self, index)

    def array_get_rect(self, index):
        r""" Wrapper for `pdf_array_get_rect()`."""
        return _mupdf.PdfObj_array_get_rect(self, index)

    def array_get_string(self, index):
        r"""
        Wrapper for `pdf_array_get_string()`.

        This method has out-params. Python/C# wrappers look like:
        	`array_get_string(int index)` => `(const char *, size_t sizep)`
        """
        return _mupdf.PdfObj_array_get_string(self, index)

    def array_get_text_string(self, index):
        r""" Wrapper for `pdf_array_get_text_string()`."""
        return _mupdf.PdfObj_array_get_text_string(self, index)

    def array_insert(self, obj, index):
        r""" Wrapper for `pdf_array_insert()`."""
        return _mupdf.PdfObj_array_insert(self, obj, index)

    def array_len(self):
        r""" Wrapper for `pdf_array_len()`."""
        return _mupdf.PdfObj_array_len(self)

    def array_push(self, obj):
        r""" Wrapper for `pdf_array_push()`."""
        return _mupdf.PdfObj_array_push(self, obj)

    def array_push_array(self, initial):
        r""" Wrapper for `pdf_array_push_array()`."""
        return _mupdf.PdfObj_array_push_array(self, initial)

    def array_push_bool(self, x):
        r""" Wrapper for `pdf_array_push_bool()`."""
        return _mupdf.PdfObj_array_push_bool(self, x)

    def array_push_dict(self, initial):
        r""" Wrapper for `pdf_array_push_dict()`."""
        return _mupdf.PdfObj_array_push_dict(self, initial)

    def array_push_int(self, x):
        r""" Wrapper for `pdf_array_push_int()`."""
        return _mupdf.PdfObj_array_push_int(self, x)

    def array_push_name(self, x):
        r""" Wrapper for `pdf_array_push_name()`."""
        return _mupdf.PdfObj_array_push_name(self, x)

    def array_push_real(self, x):
        r""" Wrapper for `pdf_array_push_real()`."""
        return _mupdf.PdfObj_array_push_real(self, x)

    def array_push_string(self, x, n):
        r""" Wrapper for `pdf_array_push_string()`."""
        return _mupdf.PdfObj_array_push_string(self, x, n)

    def array_push_text_string(self, x):
        r""" Wrapper for `pdf_array_push_text_string()`."""
        return _mupdf.PdfObj_array_push_text_string(self, x)

    def array_put(self, i, obj):
        r""" Wrapper for `pdf_array_put()`."""
        return _mupdf.PdfObj_array_put(self, i, obj)

    def button_field_on_state(self):
        r""" Wrapper for `pdf_button_field_on_state()`."""
        return _mupdf.PdfObj_button_field_on_state(self)

    def choice_field_option(self, exportval, i):
        r""" Wrapper for `pdf_choice_field_option()`."""
        return _mupdf.PdfObj_choice_field_option(self, exportval, i)

    def choice_field_option_count(self):
        r""" Wrapper for `pdf_choice_field_option_count()`."""
        return _mupdf.PdfObj_choice_field_option_count(self)

    def clean_obj(self):
        r""" Wrapper for `pdf_clean_obj()`."""
        return _mupdf.PdfObj_clean_obj(self)

    def copy_array(self):
        r""" Wrapper for `pdf_copy_array()`."""
        return _mupdf.PdfObj_copy_array(self)

    def copy_dict(self):
        r""" Wrapper for `pdf_copy_dict()`."""
        return _mupdf.PdfObj_copy_dict(self)

    def debug_obj(self):
        r""" Wrapper for `pdf_debug_obj()`."""
        return _mupdf.PdfObj_debug_obj(self)

    def debug_ref(self):
        r""" Wrapper for `pdf_debug_ref()`."""
        return _mupdf.PdfObj_debug_ref(self)

    def deep_copy_obj(self):
        r""" Wrapper for `pdf_deep_copy_obj()`."""
        return _mupdf.PdfObj_deep_copy_obj(self)

    def dict_del(self, key):
        r""" Wrapper for `pdf_dict_del()`."""
        return _mupdf.PdfObj_dict_del(self, key)

    def dict_dels(self, key):
        r""" Wrapper for `pdf_dict_dels()`."""
        return _mupdf.PdfObj_dict_dels(self, key)

    def dict_get_bool(self, key):
        r""" Wrapper for `pdf_dict_get_bool()`."""
        return _mupdf.PdfObj_dict_get_bool(self, key)

    def dict_get_date(self, key):
        r""" Wrapper for `pdf_dict_get_date()`."""
        return _mupdf.PdfObj_dict_get_date(self, key)

    def dict_get_inheritable(self, key):
        r""" Wrapper for `pdf_dict_get_inheritable()`."""
        return _mupdf.PdfObj_dict_get_inheritable(self, key)

    def dict_get_int(self, key):
        r""" Wrapper for `pdf_dict_get_int()`."""
        return _mupdf.PdfObj_dict_get_int(self, key)

    def dict_get_key(self, idx):
        r""" Wrapper for `pdf_dict_get_key()`."""
        return _mupdf.PdfObj_dict_get_key(self, idx)

    def dict_get_matrix(self, key):
        r""" Wrapper for `pdf_dict_get_matrix()`."""
        return _mupdf.PdfObj_dict_get_matrix(self, key)

    def dict_get_name(self, key):
        r""" Wrapper for `pdf_dict_get_name()`."""
        return _mupdf.PdfObj_dict_get_name(self, key)

    def dict_get_real(self, key):
        r""" Wrapper for `pdf_dict_get_real()`."""
        return _mupdf.PdfObj_dict_get_real(self, key)

    def dict_get_rect(self, key):
        r""" Wrapper for `pdf_dict_get_rect()`."""
        return _mupdf.PdfObj_dict_get_rect(self, key)

    def dict_get_string(self, key):
        r"""
        Wrapper for `pdf_dict_get_string()`.

        This method has out-params. Python/C# wrappers look like:
        	`dict_get_string(pdf_obj *key)` => `(const char *, size_t sizep)`
        """
        return _mupdf.PdfObj_dict_get_string(self, key)

    def dict_get_text_string(self, key):
        r""" Wrapper for `pdf_dict_get_text_string()`."""
        return _mupdf.PdfObj_dict_get_text_string(self, key)

    def dict_get_val(self, idx):
        r""" Wrapper for `pdf_dict_get_val()`."""
        return _mupdf.PdfObj_dict_get_val(self, idx)

    def dict_geta(self, key, abbrev):
        r""" Wrapper for `pdf_dict_geta()`."""
        return _mupdf.PdfObj_dict_geta(self, key, abbrev)

    def dict_getp(self, path):
        r""" Wrapper for `pdf_dict_getp()`."""
        return _mupdf.PdfObj_dict_getp(self, path)

    def dict_getp_inheritable(self, path):
        r""" Wrapper for `pdf_dict_getp_inheritable()`."""
        return _mupdf.PdfObj_dict_getp_inheritable(self, path)

    def dict_gets(self, key):
        r""" Wrapper for `pdf_dict_gets()`."""
        return _mupdf.PdfObj_dict_gets(self, key)

    def dict_getsa(self, key, abbrev):
        r""" Wrapper for `pdf_dict_getsa()`."""
        return _mupdf.PdfObj_dict_getsa(self, key, abbrev)

    def dict_len(self):
        r""" Wrapper for `pdf_dict_len()`."""
        return _mupdf.PdfObj_dict_len(self)

    def dict_put(self, key, val):
        r""" Wrapper for `pdf_dict_put()`."""
        return _mupdf.PdfObj_dict_put(self, key, val)

    def dict_put_array(self, key, initial):
        r""" Wrapper for `pdf_dict_put_array()`."""
        return _mupdf.PdfObj_dict_put_array(self, key, initial)

    def dict_put_bool(self, key, x):
        r""" Wrapper for `pdf_dict_put_bool()`."""
        return _mupdf.PdfObj_dict_put_bool(self, key, x)

    def dict_put_date(self, key, time):
        r""" Wrapper for `pdf_dict_put_date()`."""
        return _mupdf.PdfObj_dict_put_date(self, key, time)

    def dict_put_dict(self, key, initial):
        r""" Wrapper for `pdf_dict_put_dict()`."""
        return _mupdf.PdfObj_dict_put_dict(self, key, initial)

    def dict_put_int(self, key, x):
        r""" Wrapper for `pdf_dict_put_int()`."""
        return _mupdf.PdfObj_dict_put_int(self, key, x)

    def dict_put_matrix(self, key, x):
        r""" Wrapper for `pdf_dict_put_matrix()`."""
        return _mupdf.PdfObj_dict_put_matrix(self, key, x)

    def dict_put_name(self, key, x):
        r""" Wrapper for `pdf_dict_put_name()`."""
        return _mupdf.PdfObj_dict_put_name(self, key, x)

    def dict_put_real(self, key, x):
        r""" Wrapper for `pdf_dict_put_real()`."""
        return _mupdf.PdfObj_dict_put_real(self, key, x)

    def dict_put_rect(self, key, x):
        r""" Wrapper for `pdf_dict_put_rect()`."""
        return _mupdf.PdfObj_dict_put_rect(self, key, x)

    def dict_put_string(self, key, x, n):
        r""" Wrapper for `pdf_dict_put_string()`."""
        return _mupdf.PdfObj_dict_put_string(self, key, x, n)

    def dict_put_text_string(self, key, x):
        r""" Wrapper for `pdf_dict_put_text_string()`."""
        return _mupdf.PdfObj_dict_put_text_string(self, key, x)

    def dict_put_val_null(self, idx):
        r""" Wrapper for `pdf_dict_put_val_null()`."""
        return _mupdf.PdfObj_dict_put_val_null(self, idx)

    def dict_putp(self, path, val):
        r""" Wrapper for `pdf_dict_putp()`."""
        return _mupdf.PdfObj_dict_putp(self, path, val)

    def dict_puts(self, key, val):
        r""" Wrapper for `pdf_dict_puts()`."""
        return _mupdf.PdfObj_dict_puts(self, key, val)

    def dict_puts_dict(self, key, initial):
        r""" Wrapper for `pdf_dict_puts_dict()`."""
        return _mupdf.PdfObj_dict_puts_dict(self, key, initial)

    def dirty_obj(self):
        r""" Wrapper for `pdf_dirty_obj()`."""
        return _mupdf.PdfObj_dirty_obj(self)

    def embedded_file_name(self):
        r""" Wrapper for `pdf_embedded_file_name()`."""
        return _mupdf.PdfObj_embedded_file_name(self)

    def embedded_file_stream(self):
        r""" Wrapper for `pdf_embedded_file_stream()`."""
        return _mupdf.PdfObj_embedded_file_stream(self)

    def embedded_file_type(self):
        r""" Wrapper for `pdf_embedded_file_type()`."""
        return _mupdf.PdfObj_embedded_file_type(self)

    def field_border_style(self):
        r""" Wrapper for `pdf_field_border_style()`."""
        return _mupdf.PdfObj_field_border_style(self)

    def field_display(self):
        r""" Wrapper for `pdf_field_display()`."""
        return _mupdf.PdfObj_field_display(self)

    def field_flags(self):
        r""" Wrapper for `pdf_field_flags()`."""
        return _mupdf.PdfObj_field_flags(self)

    def field_label(self):
        r""" Wrapper for `pdf_field_label()`."""
        return _mupdf.PdfObj_field_label(self)

    def field_name(self):
        r""" Wrapper for `pdf_field_name()`."""
        return _mupdf.PdfObj_field_name(self)

    def field_set_border_style(self, text):
        r""" Wrapper for `pdf_field_set_border_style()`."""
        return _mupdf.PdfObj_field_set_border_style(self, text)

    def field_set_button_caption(self, text):
        r""" Wrapper for `pdf_field_set_button_caption()`."""
        return _mupdf.PdfObj_field_set_button_caption(self, text)

    def field_set_display(self, d):
        r""" Wrapper for `pdf_field_set_display()`."""
        return _mupdf.PdfObj_field_set_display(self, d)

    def field_set_fill_color(self, col):
        r""" Wrapper for `pdf_field_set_fill_color()`."""
        return _mupdf.PdfObj_field_set_fill_color(self, col)

    def field_set_text_color(self, col):
        r""" Wrapper for `pdf_field_set_text_color()`."""
        return _mupdf.PdfObj_field_set_text_color(self, col)

    def field_type(self):
        r""" Wrapper for `pdf_field_type()`."""
        return _mupdf.PdfObj_field_type(self)

    def field_type_string(self):
        r""" Wrapper for `pdf_field_type_string()`."""
        return _mupdf.PdfObj_field_type_string(self)

    def field_value(self):
        r""" Wrapper for `pdf_field_value()`."""
        return _mupdf.PdfObj_field_value(self)

    def filter_xobject_instance(self, page_res, ctm, filter):
        r""" Wrapper for `pdf_filter_xobject_instance()`."""
        return _mupdf.PdfObj_filter_xobject_instance(self, page_res, ctm, filter)

    def flatten_inheritable_page_items(self):
        r""" Wrapper for `pdf_flatten_inheritable_page_items()`."""
        return _mupdf.PdfObj_flatten_inheritable_page_items(self)

    def get_bound_document(self):
        r""" Wrapper for `pdf_get_bound_document()`."""
        return _mupdf.PdfObj_get_bound_document(self)

    def get_indirect_document(self):
        r""" Wrapper for `pdf_get_indirect_document()`."""
        return _mupdf.PdfObj_get_indirect_document(self)

    def is_array(self):
        r""" Wrapper for `pdf_is_array()`."""
        return _mupdf.PdfObj_is_array(self)

    def is_bool(self):
        r""" Wrapper for `pdf_is_bool()`."""
        return _mupdf.PdfObj_is_bool(self)

    def is_dict(self):
        r""" Wrapper for `pdf_is_dict()`."""
        return _mupdf.PdfObj_is_dict(self)

    def is_embedded_file(self):
        r""" Wrapper for `pdf_is_embedded_file()`."""
        return _mupdf.PdfObj_is_embedded_file(self)

    def is_indirect(self):
        r""" Wrapper for `pdf_is_indirect()`."""
        return _mupdf.PdfObj_is_indirect(self)

    def is_int(self):
        r""" Wrapper for `pdf_is_int()`."""
        return _mupdf.PdfObj_is_int(self)

    def is_jpx_image(self):
        r""" Wrapper for `pdf_is_jpx_image()`."""
        return _mupdf.PdfObj_is_jpx_image(self)

    def is_name(self):
        r""" Wrapper for `pdf_is_name()`."""
        return _mupdf.PdfObj_is_name(self)

    def is_null(self):
        r""" Wrapper for `pdf_is_null()`."""
        return _mupdf.PdfObj_is_null(self)

    def is_number(self):
        r""" Wrapper for `pdf_is_number()`."""
        return _mupdf.PdfObj_is_number(self)

    def is_real(self):
        r""" Wrapper for `pdf_is_real()`."""
        return _mupdf.PdfObj_is_real(self)

    def is_stream(self):
        r""" Wrapper for `pdf_is_stream()`."""
        return _mupdf.PdfObj_is_stream(self)

    def is_string(self):
        r""" Wrapper for `pdf_is_string()`."""
        return _mupdf.PdfObj_is_string(self)

    def line_ending_from_name(self):
        r""" Wrapper for `pdf_line_ending_from_name()`."""
        return _mupdf.PdfObj_line_ending_from_name(self)

    def load_colorspace(self):
        r""" Wrapper for `pdf_load_colorspace()`."""
        return _mupdf.PdfObj_load_colorspace(self)

    def load_embedded_file(self):
        r""" Wrapper for `pdf_load_embedded_file()`."""
        return _mupdf.PdfObj_load_embedded_file(self)

    def load_function(self, _in, out):
        r""" Wrapper for `pdf_load_function()`."""
        return _mupdf.PdfObj_load_function(self, _in, out)

    def load_raw_stream(self):
        r""" Wrapper for `pdf_load_raw_stream()`."""
        return _mupdf.PdfObj_load_raw_stream(self)

    def load_stream(self):
        r""" Wrapper for `pdf_load_stream()`."""
        return _mupdf.PdfObj_load_stream(self)

    def load_stream_or_string_as_utf8(self):
        r""" Wrapper for `pdf_load_stream_or_string_as_utf8()`."""
        return _mupdf.PdfObj_load_stream_or_string_as_utf8(self)

    def lookup_field(self, name):
        r""" Wrapper for `pdf_lookup_field()`."""
        return _mupdf.PdfObj_lookup_field(self, name)

    def lookup_number(self, needle):
        r""" Wrapper for `pdf_lookup_number()`."""
        return _mupdf.PdfObj_lookup_number(self, needle)

    def mark_obj(self):
        r""" Wrapper for `pdf_mark_obj()`."""
        return _mupdf.PdfObj_mark_obj(self)

    def name_eq(self, b):
        r""" Wrapper for `pdf_name_eq()`."""
        return _mupdf.PdfObj_name_eq(self, b)

    def new_utf8_from_pdf_stream_obj(self):
        r""" Wrapper for `pdf_new_utf8_from_pdf_stream_obj()`."""
        return _mupdf.PdfObj_new_utf8_from_pdf_stream_obj(self)

    def new_utf8_from_pdf_string_obj(self):
        r""" Wrapper for `pdf_new_utf8_from_pdf_string_obj()`."""
        return _mupdf.PdfObj_new_utf8_from_pdf_string_obj(self)

    def obj_is_dirty(self):
        r""" Wrapper for `pdf_obj_is_dirty()`."""
        return _mupdf.PdfObj_obj_is_dirty(self)

    def obj_is_incremental(self):
        r""" Wrapper for `pdf_obj_is_incremental()`."""
        return _mupdf.PdfObj_obj_is_incremental(self)

    def obj_marked(self):
        r""" Wrapper for `pdf_obj_marked()`."""
        return _mupdf.PdfObj_obj_marked(self)

    def obj_memo(self, bit):
        r"""
        Wrapper for `pdf_obj_memo()`.

        This method has out-params. Python/C# wrappers look like:
        	`obj_memo(int bit)` => `(int, int memo)`
        """
        return _mupdf.PdfObj_obj_memo(self, bit)

    def obj_parent_num(self):
        r""" Wrapper for `pdf_obj_parent_num()`."""
        return _mupdf.PdfObj_obj_parent_num(self)

    def obj_refs(self):
        r""" Wrapper for `pdf_obj_refs()`."""
        return _mupdf.PdfObj_obj_refs(self)

    def objcmp(self, b):
        r""" Wrapper for `pdf_objcmp()`."""
        return _mupdf.PdfObj_objcmp(self, b)

    def objcmp_resolve(self, b):
        r""" Wrapper for `pdf_objcmp_resolve()`."""
        return _mupdf.PdfObj_objcmp_resolve(self, b)

    def open_raw_stream(self):
        r""" Wrapper for `pdf_open_raw_stream()`."""
        return _mupdf.PdfObj_open_raw_stream(self)

    def open_stream(self):
        r""" Wrapper for `pdf_open_stream()`."""
        return _mupdf.PdfObj_open_stream(self)

    def page_obj_transform(self, page_mediabox, page_ctm):
        r""" Wrapper for `pdf_page_obj_transform()`."""
        return _mupdf.PdfObj_page_obj_transform(self, page_mediabox, page_ctm)

    def resolve_indirect(self):
        r""" Wrapper for `pdf_resolve_indirect()`."""
        return _mupdf.PdfObj_resolve_indirect(self)

    def resolve_indirect_chain(self):
        r""" Wrapper for `pdf_resolve_indirect_chain()`."""
        return _mupdf.PdfObj_resolve_indirect_chain(self)

    def set_int(self, i):
        r""" Wrapper for `pdf_set_int()`."""
        return _mupdf.PdfObj_set_int(self, i)

    def set_obj_memo(self, bit, memo):
        r""" Wrapper for `pdf_set_obj_memo()`."""
        return _mupdf.PdfObj_set_obj_memo(self, bit, memo)

    def set_obj_parent(self, num):
        r""" Wrapper for `pdf_set_obj_parent()`."""
        return _mupdf.PdfObj_set_obj_parent(self, num)

    def set_str_len(self, newlen):
        r""" Wrapper for `pdf_set_str_len()`."""
        return _mupdf.PdfObj_set_str_len(self, newlen)

    def sort_dict(self):
        r""" Wrapper for `pdf_sort_dict()`."""
        return _mupdf.PdfObj_sort_dict(self)

    def store_item(self, val, itemsize):
        r""" Wrapper for `pdf_store_item()`."""
        return _mupdf.PdfObj_store_item(self, val, itemsize)

    def to_bool(self):
        r""" Wrapper for `pdf_to_bool()`."""
        return _mupdf.PdfObj_to_bool(self)

    def to_date(self):
        r""" Wrapper for `pdf_to_date()`."""
        return _mupdf.PdfObj_to_date(self)

    def to_gen(self):
        r""" Wrapper for `pdf_to_gen()`."""
        return _mupdf.PdfObj_to_gen(self)

    def to_int(self):
        r""" Wrapper for `pdf_to_int()`."""
        return _mupdf.PdfObj_to_int(self)

    def to_int64(self):
        r""" Wrapper for `pdf_to_int64()`."""
        return _mupdf.PdfObj_to_int64(self)

    def to_matrix(self):
        r""" Wrapper for `pdf_to_matrix()`."""
        return _mupdf.PdfObj_to_matrix(self)

    def to_name(self):
        r""" Wrapper for `pdf_to_name()`."""
        return _mupdf.PdfObj_to_name(self)

    def to_num(self):
        r""" Wrapper for `pdf_to_num()`."""
        return _mupdf.PdfObj_to_num(self)

    def to_quad(self, offset):
        r""" Wrapper for `pdf_to_quad()`."""
        return _mupdf.PdfObj_to_quad(self, offset)

    def to_real(self):
        r""" Wrapper for `pdf_to_real()`."""
        return _mupdf.PdfObj_to_real(self)

    def to_rect(self):
        r""" Wrapper for `pdf_to_rect()`."""
        return _mupdf.PdfObj_to_rect(self)

    def to_str_buf(self):
        r""" Wrapper for `pdf_to_str_buf()`."""
        return _mupdf.PdfObj_to_str_buf(self)

    def to_str_len(self):
        r""" Wrapper for `pdf_to_str_len()`."""
        return _mupdf.PdfObj_to_str_len(self)

    def to_string(self):
        r"""
        Wrapper for `pdf_to_string()`.

        This method has out-params. Python/C# wrappers look like:
        	`to_string()` => `(const char *, size_t sizep)`
        """
        return _mupdf.PdfObj_to_string(self)

    def to_text_string(self):
        r""" Wrapper for `pdf_to_text_string()`."""
        return _mupdf.PdfObj_to_text_string(self)

    def unmark_obj(self):
        r""" Wrapper for `pdf_unmark_obj()`."""
        return _mupdf.PdfObj_unmark_obj(self)

    def walk_tree(self, kid_name, arrive, leave, arg, names, values):
        r"""
        Wrapper for `pdf_walk_tree()`.

        This method has out-params. Python/C# wrappers look like:
        	`walk_tree(pdf_obj *kid_name, void (*arrive)(fz_context *, pdf_obj *, void *, pdf_obj **), void (*leave)(fz_context *, pdf_obj *, void *), void *arg, pdf_obj **names, pdf_obj **values)` => `()`
        """
        return _mupdf.PdfObj_walk_tree(self, kid_name, arrive, leave, arg, names, values)

    def xobject_bbox(self):
        r""" Wrapper for `pdf_xobject_bbox()`."""
        return _mupdf.PdfObj_xobject_bbox(self)

    def xobject_colorspace(self):
        r""" Wrapper for `pdf_xobject_colorspace()`."""
        return _mupdf.PdfObj_xobject_colorspace(self)

    def xobject_isolated(self):
        r""" Wrapper for `pdf_xobject_isolated()`."""
        return _mupdf.PdfObj_xobject_isolated(self)

    def xobject_knockout(self):
        r""" Wrapper for `pdf_xobject_knockout()`."""
        return _mupdf.PdfObj_xobject_knockout(self)

    def xobject_matrix(self):
        r""" Wrapper for `pdf_xobject_matrix()`."""
        return _mupdf.PdfObj_xobject_matrix(self)

    def xobject_resources(self):
        r""" Wrapper for `pdf_xobject_resources()`."""
        return _mupdf.PdfObj_xobject_resources(self)

    def xobject_transparency(self):
        r""" Wrapper for `pdf_xobject_transparency()`."""
        return _mupdf.PdfObj_xobject_transparency(self)

    def dict_get(self, *args):
        r"""
        *Overload 1:*
        Wrapper for `pdf_dict_get()`.

        |

        *Overload 2:*
        Typesafe wrapper for looking up things such as PDF_ENUM_NAME_Annots.
        """
        return _mupdf.PdfObj_dict_get(self, *args)

    def __init__(self, *args):
        r"""
        *Overload 1:*
        == Constructors.  Constructor using `pdf_new_array()`.

        |

        *Overload 2:*
        Constructor using `pdf_new_date()`.

        |

        *Overload 3:*
        Constructor using `pdf_new_destination_from_link()`.

        |

        *Overload 4:*
        Constructor using `pdf_new_indirect()`.

        |

        *Overload 5:*
        Constructor using `pdf_new_int()`.

        |

        *Overload 6:*
        Constructor using `pdf_new_matrix()`.

        |

        *Overload 7:*
        Constructor using `pdf_new_name()`.

        |

        *Overload 8:*
        Constructor using `pdf_new_real()`.

        |

        *Overload 9:*
        Constructor using `pdf_new_rect()`.

        |

        *Overload 10:*
        Constructor using `pdf_new_string()`.

        |

        *Overload 11:*
        Constructor using `pdf_new_xobject()`.

        |

        *Overload 12:*
        Copy constructor using `pdf_keep_obj()`.

        |

        *Overload 13:*
        Constructor using raw copy of pre-existing `pdf_obj`.

        |

        *Overload 14:*
        Constructor using raw copy of pre-existing `pdf_obj`.
        """
        _mupdf.PdfObj_swiginit(self, _mupdf.new_PdfObj(*args))
    __swig_destroy__ = _mupdf.delete_PdfObj

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfObj_m_internal_value(self)
    m_internal = property(_mupdf.PdfObj_m_internal_get, _mupdf.PdfObj_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register PdfObj in _mupdf:
_mupdf.PdfObj_swigregister(PdfObj)

def PdfObj_new_text_string(s):
    r""" Wrapper for `pdf_new_text_string()`."""
    return _mupdf.PdfObj_new_text_string(s)

def PdfObj_new_dict(doc, initialcap):
    r""" Wrapper for `pdf_new_dict()`."""
    return _mupdf.PdfObj_new_dict(doc, initialcap)

def PdfObj_new_action_from_link(doc, uri):
    r""" Wrapper for `pdf_new_action_from_link()`."""
    return _mupdf.PdfObj_new_action_from_link(doc, uri)

class PdfOcgDescriptor(object):
    r""" Wrapper class for struct `pdf_ocg_descriptor`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `pdf_ocg_descriptor`."""
        _mupdf.PdfOcgDescriptor_swiginit(self, _mupdf.new_PdfOcgDescriptor(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfOcgDescriptor_m_internal_value(self)
    m_internal = property(_mupdf.PdfOcgDescriptor_m_internal_get, _mupdf.PdfOcgDescriptor_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_PdfOcgDescriptor

# Register PdfOcgDescriptor in _mupdf:
_mupdf.PdfOcgDescriptor_swigregister(PdfOcgDescriptor)

class PdfPage(object):
    r""" Wrapper class for struct `pdf_page`."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def bound_page(self):
        r""" We use default copy constructor and operator=.  Wrapper for `pdf_bound_page()`."""
        return _mupdf.PdfPage_bound_page(self)

    def create_annot(self, type):
        r""" Wrapper for `pdf_create_annot()`."""
        return _mupdf.PdfPage_create_annot(self, type)

    def create_annot_raw(self, type):
        r""" Wrapper for `pdf_create_annot_raw()`."""
        return _mupdf.PdfPage_create_annot_raw(self, type)

    def create_link(self, bbox, uri):
        r""" Wrapper for `pdf_create_link()`."""
        return _mupdf.PdfPage_create_link(self, bbox, uri)

    def create_signature_widget(self, name):
        r""" Wrapper for `pdf_create_signature_widget()`."""
        return _mupdf.PdfPage_create_signature_widget(self, name)

    def delete_annot(self, annot):
        r""" Wrapper for `pdf_delete_annot()`."""
        return _mupdf.PdfPage_delete_annot(self, annot)

    def first_annot(self):
        r""" Wrapper for `pdf_first_annot()`."""
        return _mupdf.PdfPage_first_annot(self)

    def first_widget(self):
        r""" Wrapper for `pdf_first_widget()`."""
        return _mupdf.PdfPage_first_widget(self)

    def load_links(self):
        r""" Wrapper for `pdf_load_links()`."""
        return _mupdf.PdfPage_load_links(self)

    def new_pixmap_from_page_contents_with_separations_and_usage(self, ctm, cs, seps, alpha, usage):
        r""" Wrapper for `pdf_new_pixmap_from_page_contents_with_separations_and_usage()`."""
        return _mupdf.PdfPage_new_pixmap_from_page_contents_with_separations_and_usage(self, ctm, cs, seps, alpha, usage)

    def new_pixmap_from_page_contents_with_usage(self, ctm, cs, alpha, usage):
        r""" Wrapper for `pdf_new_pixmap_from_page_contents_with_usage()`."""
        return _mupdf.PdfPage_new_pixmap_from_page_contents_with_usage(self, ctm, cs, alpha, usage)

    def new_pixmap_from_page_with_separations_and_usage(self, ctm, cs, seps, alpha, usage):
        r""" Wrapper for `pdf_new_pixmap_from_page_with_separations_and_usage()`."""
        return _mupdf.PdfPage_new_pixmap_from_page_with_separations_and_usage(self, ctm, cs, seps, alpha, usage)

    def new_pixmap_from_page_with_usage(self, ctm, cs, alpha, usage):
        r""" Wrapper for `pdf_new_pixmap_from_page_with_usage()`."""
        return _mupdf.PdfPage_new_pixmap_from_page_with_usage(self, ctm, cs, alpha, usage)

    def page_contents(self):
        r""" Wrapper for `pdf_page_contents()`."""
        return _mupdf.PdfPage_page_contents(self)

    def page_event_close(self):
        r""" Wrapper for `pdf_page_event_close()`."""
        return _mupdf.PdfPage_page_event_close(self)

    def page_event_open(self):
        r""" Wrapper for `pdf_page_event_open()`."""
        return _mupdf.PdfPage_page_event_open(self)

    def page_group(self):
        r""" Wrapper for `pdf_page_group()`."""
        return _mupdf.PdfPage_page_group(self)

    def page_presentation(self, transition):
        r"""
        Wrapper for `pdf_page_presentation()`.

        This method has out-params. Python/C# wrappers look like:
        	`page_presentation(fz_transition *transition)` => `(fz_transition *, float duration)`
        """
        return _mupdf.PdfPage_page_presentation(self, transition)

    def page_resources(self):
        r""" Wrapper for `pdf_page_resources()`."""
        return _mupdf.PdfPage_page_resources(self)

    def page_separations(self):
        r""" Wrapper for `pdf_page_separations()`."""
        return _mupdf.PdfPage_page_separations(self)

    def page_transform(self, mediabox, ctm):
        r""" Wrapper for `pdf_page_transform()`."""
        return _mupdf.PdfPage_page_transform(self, mediabox, ctm)

    def run_page(self, dev, ctm, cookie):
        r""" Wrapper for `pdf_run_page()`."""
        return _mupdf.PdfPage_run_page(self, dev, ctm, cookie)

    def run_page_annots(self, dev, ctm, cookie):
        r""" Wrapper for `pdf_run_page_annots()`."""
        return _mupdf.PdfPage_run_page_annots(self, dev, ctm, cookie)

    def run_page_annots_with_usage(self, dev, ctm, usage, cookie):
        r""" Wrapper for `pdf_run_page_annots_with_usage()`."""
        return _mupdf.PdfPage_run_page_annots_with_usage(self, dev, ctm, usage, cookie)

    def run_page_contents(self, dev, ctm, cookie):
        r""" Wrapper for `pdf_run_page_contents()`."""
        return _mupdf.PdfPage_run_page_contents(self, dev, ctm, cookie)

    def run_page_contents_with_usage(self, dev, ctm, usage, cookie):
        r""" Wrapper for `pdf_run_page_contents_with_usage()`."""
        return _mupdf.PdfPage_run_page_contents_with_usage(self, dev, ctm, usage, cookie)

    def run_page_widgets(self, dev, ctm, cookie):
        r""" Wrapper for `pdf_run_page_widgets()`."""
        return _mupdf.PdfPage_run_page_widgets(self, dev, ctm, cookie)

    def run_page_widgets_with_usage(self, dev, ctm, usage, cookie):
        r""" Wrapper for `pdf_run_page_widgets_with_usage()`."""
        return _mupdf.PdfPage_run_page_widgets_with_usage(self, dev, ctm, usage, cookie)

    def run_page_with_usage(self, dev, ctm, usage, cookie):
        r""" Wrapper for `pdf_run_page_with_usage()`."""
        return _mupdf.PdfPage_run_page_with_usage(self, dev, ctm, usage, cookie)

    def update_page(self):
        r""" Wrapper for `pdf_update_page()`."""
        return _mupdf.PdfPage_update_page(self)

    def super(self):
        r""" Returns wrapper for .super member."""
        return _mupdf.PdfPage_super(self)

    def doc(self):
        r""" Returns wrapper for .doc member."""
        return _mupdf.PdfPage_doc(self)

    def obj(self):
        r""" Returns wrapper for .obj member."""
        return _mupdf.PdfPage_obj(self)

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `pdf_page`."""
        _mupdf.PdfPage_swiginit(self, _mupdf.new_PdfPage(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfPage_m_internal_value(self)
    m_internal = property(_mupdf.PdfPage_m_internal_get, _mupdf.PdfPage_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_PdfPage

# Register PdfPage in _mupdf:
_mupdf.PdfPage_swigregister(PdfPage)

class PdfPattern(object):
    r""" Wrapper class for struct `pdf_pattern`."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*
        Copy constructor using `pdf_keep_pattern()`.

        |

        *Overload 2:*
        Constructor using raw copy of pre-existing `pdf_pattern`.
        """
        _mupdf.PdfPattern_swiginit(self, _mupdf.new_PdfPattern(*args))
    __swig_destroy__ = _mupdf.delete_PdfPattern

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfPattern_m_internal_value(self)
    m_internal = property(_mupdf.PdfPattern_m_internal_get, _mupdf.PdfPattern_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register PdfPattern in _mupdf:
_mupdf.PdfPattern_swigregister(PdfPattern)

class PdfPkcs7DistinguishedName(object):
    r""" Wrapper class for struct `pdf_pkcs7_distinguished_name`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def signature_drop_distinguished_name(self):
        r""" Wrapper for `pdf_signature_drop_distinguished_name()`."""
        return _mupdf.PdfPkcs7DistinguishedName_signature_drop_distinguished_name(self)

    def signature_format_distinguished_name(self):
        r""" Wrapper for `pdf_signature_format_distinguished_name()`."""
        return _mupdf.PdfPkcs7DistinguishedName_signature_format_distinguished_name(self)

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `pdf_pkcs7_distinguished_name`."""
        _mupdf.PdfPkcs7DistinguishedName_swiginit(self, _mupdf.new_PdfPkcs7DistinguishedName(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfPkcs7DistinguishedName_m_internal_value(self)
    m_internal = property(_mupdf.PdfPkcs7DistinguishedName_m_internal_get, _mupdf.PdfPkcs7DistinguishedName_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_PdfPkcs7DistinguishedName

# Register PdfPkcs7DistinguishedName in _mupdf:
_mupdf.PdfPkcs7DistinguishedName_swigregister(PdfPkcs7DistinguishedName)

class PdfPkcs7Signer(object):
    r""" Wrapper class for struct `pdf_pkcs7_signer`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `pdf_pkcs7_signer`."""
        _mupdf.PdfPkcs7Signer_swiginit(self, _mupdf.new_PdfPkcs7Signer(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfPkcs7Signer_m_internal_value(self)
    m_internal = property(_mupdf.PdfPkcs7Signer_m_internal_get, _mupdf.PdfPkcs7Signer_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_PdfPkcs7Signer

# Register PdfPkcs7Signer in _mupdf:
_mupdf.PdfPkcs7Signer_swigregister(PdfPkcs7Signer)

class PdfPkcs7Verifier(object):
    r""" Wrapper class for struct `pdf_pkcs7_verifier`. Not copyable or assignable."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def check_signature(self, doc, signature, ebuf, ebufsize):
        r""" Wrapper for `pdf_check_signature()`."""
        return _mupdf.PdfPkcs7Verifier_check_signature(self, doc, signature, ebuf, ebufsize)

    def __init__(self, internal):
        r""" Constructor using raw copy of pre-existing `pdf_pkcs7_verifier`."""
        _mupdf.PdfPkcs7Verifier_swiginit(self, _mupdf.new_PdfPkcs7Verifier(internal))

    def m_internal_value(self):
        r""" We use default destructor.  Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfPkcs7Verifier_m_internal_value(self)
    m_internal = property(_mupdf.PdfPkcs7Verifier_m_internal_get, _mupdf.PdfPkcs7Verifier_m_internal_set, doc=r""" Pointer to wrapped data.""")
    __swig_destroy__ = _mupdf.delete_PdfPkcs7Verifier

# Register PdfPkcs7Verifier in _mupdf:
_mupdf.PdfPkcs7Verifier_swigregister(PdfPkcs7Verifier)

class PdfProcessor(object):
    r""" Wrapper class for struct `pdf_processor`."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def close_processor(self):
        r""" Wrapper for `pdf_close_processor()`."""
        return _mupdf.PdfProcessor_close_processor(self)

    def process_annot(self, annot, cookie):
        r""" Wrapper for `pdf_process_annot()`."""
        return _mupdf.PdfProcessor_process_annot(self, annot, cookie)

    def process_contents(self, doc, obj, res, cookie):
        r""" Wrapper for `pdf_process_contents()`."""
        return _mupdf.PdfProcessor_process_contents(self, doc, obj, res, cookie)

    def process_glyph(self, doc, resources, contents):
        r""" Wrapper for `pdf_process_glyph()`."""
        return _mupdf.PdfProcessor_process_glyph(self, doc, resources, contents)

    def __init__(self, *args):
        r"""
        *Overload 1:*
        == Constructors.  Constructor using `pdf_new_buffer_processor()`.

        |

        *Overload 2:*
        Constructor using `pdf_new_filter_processor()`.

        |

        *Overload 3:*
        Constructor using `pdf_new_output_processor()`.

        |

        *Overload 4:*
        Constructor using `pdf_new_run_processor()`.

        |

        *Overload 5:*
        Sets m_internal = NULL.

        |

        *Overload 6:*
        Copy constructor using `pdf_keep_processor()`.

        |

        *Overload 7:*
        Constructor using raw copy of pre-existing `pdf_processor`.
        """
        _mupdf.PdfProcessor_swiginit(self, _mupdf.new_PdfProcessor(*args))
    __swig_destroy__ = _mupdf.delete_PdfProcessor

    def m_internal_value(self):
        r""" Return numerical value of .m_internal; helps with Python debugging."""
        return _mupdf.PdfProcessor_m_internal_value(self)
    m_internal = property(_mupdf.PdfProcessor_m_internal_get, _mupdf.PdfProcessor_m_internal_set, doc=r""" Pointer to wrapped data.""")

# Register PdfProcessor in _mupdf:
_mupdf.PdfProcessor_swigregister(PdfProcessor)

class PdfProcessor2(PdfProcessor):
    r""" Wrapper class for struct pdf_processor with virtual fns for each fnptr; this is for use as a SWIG Director class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" == Constructor."""
        if self.__class__ == PdfProcessor2:
            _self = None
        else:
            _self = self
        _mupdf.PdfProcessor2_swiginit(self, _mupdf.new_PdfProcessor2(_self, ))

    def use_virtual_close_processor(self, use=True):
        r"""
        These methods set the function pointers in *m_internal
        to point to internal callbacks that call our virtual methods.
        """
        return _mupdf.PdfProcessor2_use_virtual_close_processor(self, use)

    def use_virtual_drop_processor(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_drop_processor(self, use)

    def use_virtual_op_w(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_w(self, use)

    def use_virtual_op_j(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_j(self, use)

    def use_virtual_op_J(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_J(self, use)

    def use_virtual_op_M(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_M(self, use)

    def use_virtual_op_d(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_d(self, use)

    def use_virtual_op_ri(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_ri(self, use)

    def use_virtual_op_i(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_i(self, use)

    def use_virtual_op_gs_begin(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_gs_begin(self, use)

    def use_virtual_op_gs_BM(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_gs_BM(self, use)

    def use_virtual_op_gs_ca(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_gs_ca(self, use)

    def use_virtual_op_gs_CA(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_gs_CA(self, use)

    def use_virtual_op_gs_SMask(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_gs_SMask(self, use)

    def use_virtual_op_gs_end(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_gs_end(self, use)

    def use_virtual_op_q(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_q(self, use)

    def use_virtual_op_Q(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_Q(self, use)

    def use_virtual_op_cm(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_cm(self, use)

    def use_virtual_op_m(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_m(self, use)

    def use_virtual_op_l(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_l(self, use)

    def use_virtual_op_c(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_c(self, use)

    def use_virtual_op_v(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_v(self, use)

    def use_virtual_op_y(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_y(self, use)

    def use_virtual_op_h(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_h(self, use)

    def use_virtual_op_re(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_re(self, use)

    def use_virtual_op_S(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_S(self, use)

    def use_virtual_op_s(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_s(self, use)

    def use_virtual_op_F(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_F(self, use)

    def use_virtual_op_f(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_f(self, use)

    def use_virtual_op_fstar(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_fstar(self, use)

    def use_virtual_op_B(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_B(self, use)

    def use_virtual_op_Bstar(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_Bstar(self, use)

    def use_virtual_op_b(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_b(self, use)

    def use_virtual_op_bstar(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_bstar(self, use)

    def use_virtual_op_n(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_n(self, use)

    def use_virtual_op_W(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_W(self, use)

    def use_virtual_op_Wstar(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_Wstar(self, use)

    def use_virtual_op_BT(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_BT(self, use)

    def use_virtual_op_ET(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_ET(self, use)

    def use_virtual_op_Tc(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_Tc(self, use)

    def use_virtual_op_Tw(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_Tw(self, use)

    def use_virtual_op_Tz(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_Tz(self, use)

    def use_virtual_op_TL(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_TL(self, use)

    def use_virtual_op_Tf(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_Tf(self, use)

    def use_virtual_op_Tr(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_Tr(self, use)

    def use_virtual_op_Ts(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_Ts(self, use)

    def use_virtual_op_Td(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_Td(self, use)

    def use_virtual_op_TD(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_TD(self, use)

    def use_virtual_op_Tm(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_Tm(self, use)

    def use_virtual_op_Tstar(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_Tstar(self, use)

    def use_virtual_op_TJ(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_TJ(self, use)

    def use_virtual_op_Tj(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_Tj(self, use)

    def use_virtual_op_squote(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_squote(self, use)

    def use_virtual_op_dquote(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_dquote(self, use)

    def use_virtual_op_d0(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_d0(self, use)

    def use_virtual_op_d1(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_d1(self, use)

    def use_virtual_op_CS(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_CS(self, use)

    def use_virtual_op_cs(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_cs(self, use)

    def use_virtual_op_SC_pattern(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_SC_pattern(self, use)

    def use_virtual_op_sc_pattern(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_sc_pattern(self, use)

    def use_virtual_op_SC_shade(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_SC_shade(self, use)

    def use_virtual_op_sc_shade(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_sc_shade(self, use)

    def use_virtual_op_SC_color(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_SC_color(self, use)

    def use_virtual_op_sc_color(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_sc_color(self, use)

    def use_virtual_op_G(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_G(self, use)

    def use_virtual_op_g(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_g(self, use)

    def use_virtual_op_RG(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_RG(self, use)

    def use_virtual_op_rg(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_rg(self, use)

    def use_virtual_op_K(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_K(self, use)

    def use_virtual_op_k(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_k(self, use)

    def use_virtual_op_BI(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_BI(self, use)

    def use_virtual_op_sh(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_sh(self, use)

    def use_virtual_op_Do_image(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_Do_image(self, use)

    def use_virtual_op_Do_form(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_Do_form(self, use)

    def use_virtual_op_MP(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_MP(self, use)

    def use_virtual_op_DP(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_DP(self, use)

    def use_virtual_op_BMC(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_BMC(self, use)

    def use_virtual_op_BDC(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_BDC(self, use)

    def use_virtual_op_EMC(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_EMC(self, use)

    def use_virtual_op_BX(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_BX(self, use)

    def use_virtual_op_EX(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_EX(self, use)

    def use_virtual_op_gs_OP(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_gs_OP(self, use)

    def use_virtual_op_gs_op(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_gs_op(self, use)

    def use_virtual_op_gs_OPM(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_gs_OPM(self, use)

    def use_virtual_op_gs_UseBlackPtComp(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_gs_UseBlackPtComp(self, use)

    def use_virtual_op_END(self, use=True):
        return _mupdf.PdfProcessor2_use_virtual_op_END(self, use)

    def close_processor(self):
        r""" Default virtual method implementations; these all throw an exception."""
        return _mupdf.PdfProcessor2_close_processor(self)

    def drop_processor(self):
        return _mupdf.PdfProcessor2_drop_processor(self)

    def op_w(self, arg_2):
        return _mupdf.PdfProcessor2_op_w(self, arg_2)

    def op_j(self, arg_2):
        return _mupdf.PdfProcessor2_op_j(self, arg_2)

    def op_J(self, arg_2):
        return _mupdf.PdfProcessor2_op_J(self, arg_2)

    def op_M(self, arg_2):
        return _mupdf.PdfProcessor2_op_M(self, arg_2)

    def op_d(self, arg_2, arg_3):
        return _mupdf.PdfProcessor2_op_d(self, arg_2, arg_3)

    def op_ri(self, arg_2):
        return _mupdf.PdfProcessor2_op_ri(self, arg_2)

    def op_i(self, arg_2):
        return _mupdf.PdfProcessor2_op_i(self, arg_2)

    def op_gs_begin(self, arg_2, arg_3):
        return _mupdf.PdfProcessor2_op_gs_begin(self, arg_2, arg_3)

    def op_gs_BM(self, arg_2):
        return _mupdf.PdfProcessor2_op_gs_BM(self, arg_2)

    def op_gs_ca(self, arg_2):
        return _mupdf.PdfProcessor2_op_gs_ca(self, arg_2)

    def op_gs_CA(self, arg_2):
        return _mupdf.PdfProcessor2_op_gs_CA(self, arg_2)

    def op_gs_SMask(self, arg_2, arg_3, arg_4, arg_5):
        return _mupdf.PdfProcessor2_op_gs_SMask(self, arg_2, arg_3, arg_4, arg_5)

    def op_gs_end(self):
        return _mupdf.PdfProcessor2_op_gs_end(self)

    def op_q(self):
        return _mupdf.PdfProcessor2_op_q(self)

    def op_Q(self):
        return _mupdf.PdfProcessor2_op_Q(self)

    def op_cm(self, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7):
        return _mupdf.PdfProcessor2_op_cm(self, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7)

    def op_m(self, arg_2, arg_3):
        return _mupdf.PdfProcessor2_op_m(self, arg_2, arg_3)

    def op_l(self, arg_2, arg_3):
        return _mupdf.PdfProcessor2_op_l(self, arg_2, arg_3)

    def op_c(self, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7):
        return _mupdf.PdfProcessor2_op_c(self, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7)

    def op_v(self, arg_2, arg_3, arg_4, arg_5):
        return _mupdf.PdfProcessor2_op_v(self, arg_2, arg_3, arg_4, arg_5)

    def op_y(self, arg_2, arg_3, arg_4, arg_5):
        return _mupdf.PdfProcessor2_op_y(self, arg_2, arg_3, arg_4, arg_5)

    def op_h(self):
        return _mupdf.PdfProcessor2_op_h(self)

    def op_re(self, arg_2, arg_3, arg_4, arg_5):
        return _mupdf.PdfProcessor2_op_re(self, arg_2, arg_3, arg_4, arg_5)

    def op_S(self):
        return _mupdf.PdfProcessor2_op_S(self)

    def op_s(self):
        return _mupdf.PdfProcessor2_op_s(self)

    def op_F(self):
        return _mupdf.PdfProcessor2_op_F(self)

    def op_f(self):
        return _mupdf.PdfProcessor2_op_f(self)

    def op_fstar(self):
        return _mupdf.PdfProcessor2_op_fstar(self)

    def op_B(self):
        return _mupdf.PdfProcessor2_op_B(self)

    def op_Bstar(self):
        return _mupdf.PdfProcessor2_op_Bstar(self)

    def op_b(self):
        return _mupdf.PdfProcessor2_op_b(self)

    def op_bstar(self):
        return _mupdf.PdfProcessor2_op_bstar(self)

    def op_n(self):
        return _mupdf.PdfProcessor2_op_n(self)

    def op_W(self):
        return _mupdf.PdfProcessor2_op_W(self)

    def op_Wstar(self):
        return _mupdf.PdfProcessor2_op_Wstar(self)

    def op_BT(self):
        return _mupdf.PdfProcessor2_op_BT(self)

    def op_ET(self):
        return _mupdf.PdfProcessor2_op_ET(self)

    def op_Tc(self, arg_2):
        return _mupdf.PdfProcessor2_op_Tc(self, arg_2)

    def op_Tw(self, arg_2):
        return _mupdf.PdfProcessor2_op_Tw(self, arg_2)

    def op_Tz(self, arg_2):
        return _mupdf.PdfProcessor2_op_Tz(self, arg_2)

    def op_TL(self, arg_2):
        return _mupdf.PdfProcessor2_op_TL(self, arg_2)

    def op_Tf(self, arg_2, arg_3, arg_4):
        return _mupdf.PdfProcessor2_op_Tf(self, arg_2, arg_3, arg_4)

    def op_Tr(self, arg_2):
        return _mupdf.PdfProcessor2_op_Tr(self, arg_2)

    def op_Ts(self, arg_2):
        return _mupdf.PdfProcessor2_op_Ts(self, arg_2)

    def op_Td(self, arg_2, arg_3):
        return _mupdf.PdfProcessor2_op_Td(self, arg_2, arg_3)

    def op_TD(self, arg_2, arg_3):
        return _mupdf.PdfProcessor2_op_TD(self, arg_2, arg_3)

    def op_Tm(self, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7):
        return _mupdf.PdfProcessor2_op_Tm(self, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7)

    def op_Tstar(self):
        return _mupdf.PdfProcessor2_op_Tstar(self)

    def op_TJ(self, arg_2):
        return _mupdf.PdfProcessor2_op_TJ(self, arg_2)

    def op_Tj(self, arg_2, arg_3):
        return _mupdf.PdfProcessor2_op_Tj(self, arg_2, arg_3)

    def op_squote(self, arg_2, arg_3):
        return _mupdf.PdfProcessor2_op_squote(self, arg_2, arg_3)

    def op_dquote(self, arg_2, arg_3, arg_4, arg_5):
        return _mupdf.PdfProcessor2_op_dquote(self, arg_2, arg_3, arg_4, arg_5)

    def op_d0(self, arg_2, arg_3):
        return _mupdf.PdfProcessor2_op_d0(self, arg_2, arg_3)

    def op_d1(self, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7):
        return _mupdf.PdfProcessor2_op_d1(self, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7)

    def op_CS(self, arg_2, arg_3):
        return _mupdf.PdfProcessor2_op_CS(self, arg_2, arg_3)

    def op_cs(self, arg_2, arg_3):
        return _mupdf.PdfProcessor2_op_cs(self, arg_2, arg_3)

    def op_SC_pattern(self, arg_2, arg_3, arg_4, arg_5):
        return _mupdf.PdfProcessor2_op_SC_pattern(self, arg_2, arg_3, arg_4, arg_5)

    def op_sc_pattern(self, arg_2, arg_3, arg_4, arg_5):
        return _mupdf.PdfProcessor2_op_sc_pattern(self, arg_2, arg_3, arg_4, arg_5)

    def op_SC_shade(self, arg_2, arg_3):
        return _mupdf.PdfProcessor2_op_SC_shade(self, arg_2, arg_3)

    def op_sc_shade(self, arg_2, arg_3):
        return _mupdf.PdfProcessor2_op_sc_shade(self, arg_2, arg_3)

    def op_SC_color(self, arg_2, arg_3):
        return _mupdf.PdfProcessor2_op_SC_color(self, arg_2, arg_3)

    def op_sc_color(self, arg_2, arg_3):
        return _mupdf.PdfProcessor2_op_sc_color(self, arg_2, arg_3)

    def op_G(self, arg_2):
        return _mupdf.PdfProce