from django.conf import settings
from django.db import migrations, models

import mezzanine.core.fields
import mezzanine.utils.models


class Migration(migrations.Migration):

    dependencies = [
        ("sites", "0001_initial"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="BlogCategory",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("title", models.CharField(max_length=500, verbose_name="Title")),
                (
                    "slug",
                    models.CharField(
                        help_text="Leave blank to have the URL auto-generated from the title.",
                        max_length=2000,
                        null=True,
                        verbose_name="URL",
                        blank=True,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False, to="sites.Site", on_delete=models.CASCADE
                    ),
                ),
            ],
            options={
                "ordering": ("title",),
                "verbose_name": "Blog Category",
                "verbose_name_plural": "Blog Categories",
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="BlogPost",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("comments_count", models.IntegerField(default=0, editable=False)),
                (
                    "keywords_string",
                    models.CharField(max_length=500, editable=False, blank=True),
                ),
                ("rating_count", models.IntegerField(default=0, editable=False)),
                ("rating_sum", models.IntegerField(default=0, editable=False)),
                ("rating_average", models.FloatField(default=0, editable=False)),
                ("title", models.CharField(max_length=500, verbose_name="Title")),
                (
                    "slug",
                    models.CharField(
                        help_text="Leave blank to have the URL auto-generated from the title.",
                        max_length=2000,
                        null=True,
                        verbose_name="URL",
                        blank=True,
                    ),
                ),
                (
                    "_meta_title",
                    models.CharField(
                        help_text="Optional title to be used in the HTML title tag. If left blank, the main title field will be used.",
                        max_length=500,
                        null=True,
                        verbose_name="Title",
                        blank=True,
                    ),
                ),
                (
                    "description",
                    models.TextField(verbose_name="Description", blank=True),
                ),
                (
                    "gen_description",
                    models.BooleanField(
                        default=True,
                        help_text="If checked, the description will be automatically generated from content. Uncheck if you want to manually set a custom description.",
                        verbose_name="Generate description",
                    ),
                ),
                ("created", models.DateTimeField(null=True, editable=False)),
                ("updated", models.DateTimeField(null=True, editable=False)),
                (
                    "status",
                    models.IntegerField(
                        default=2,
                        help_text="With Draft chosen, will only be shown for admin users on the site.",
                        verbose_name="Status",
                        choices=[(1, "Draft"), (2, "Published")],
                    ),
                ),
                (
                    "publish_date",
                    models.DateTimeField(
                        help_text="With Published chosen, won't be shown until this time",
                        null=True,
                        verbose_name="Published from",
                        blank=True,
                    ),
                ),
                (
                    "expiry_date",
                    models.DateTimeField(
                        help_text="With Published chosen, won't be shown after this time",
                        null=True,
                        verbose_name="Expires on",
                        blank=True,
                    ),
                ),
                ("short_url", models.URLField(null=True, blank=True)),
                (
                    "in_sitemap",
                    models.BooleanField(default=True, verbose_name="Show in sitemap"),
                ),
                (
                    "content",
                    mezzanine.core.fields.RichTextField(verbose_name="Content"),
                ),
                (
                    "allow_comments",
                    models.BooleanField(default=True, verbose_name="Allow comments"),
                ),
                (
                    "featured_image",
                    mezzanine.core.fields.FileField(
                        max_length=255,
                        null=True,
                        verbose_name="Featured Image",
                        blank=True,
                    ),
                ),
                (
                    "categories",
                    models.ManyToManyField(
                        related_name="blogposts",
                        verbose_name="Categories",
                        to="blog.BlogCategory",
                        blank=True,
                    ),
                ),
                (
                    "related_posts",
                    models.ManyToManyField(
                        related_name="related_posts_rel_+",
                        verbose_name="Related posts",
                        to="blog.BlogPost",
                        blank=True,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False, to="sites.Site", on_delete=models.CASCADE
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        related_name="blogposts",
                        verbose_name="Author",
                        to=settings.AUTH_USER_MODEL,
                        on_delete=models.CASCADE,
                    ),
                ),
            ],
            options={
                "ordering": ("-publish_date",),
                "verbose_name": "Blog post",
                "verbose_name_plural": "Blog posts",
            },
            bases=(models.Model, mezzanine.utils.models.AdminThumbMixin),
        ),
    ]
