/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
import { ECS } from 'aws-sdk';
import { LambdaContext } from '../lib/aws-lambda';
import { CfnRequestEvent, SimpleCustomResource } from '../lib/custom-resource';
export interface WaitForStableServiceResourceProps {
    /**
     * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to describe.
     */
    readonly cluster: string;
    /**
     * A list of services to describe. You may specify up to 10 services to describe in a single operation.
     */
    readonly services: string[];
    /**
     * A random string that forces the Lambda to run again and check if ECS is stable.
     */
    readonly forceRun?: string;
}
/**
 * A custom resource used to save Spot Event Plugin server data and configurations.
 */
export declare class WaitForStableServiceResource extends SimpleCustomResource {
    protected readonly ecsClient: ECS;
    constructor(ecsClient: ECS);
    /**
     * @inheritdoc
     */
    validateInput(data: object): boolean;
    /**
     * @inheritdoc
     */
    doCreate(_physicalId: string, resourceProperties: WaitForStableServiceResourceProps): Promise<object | undefined>;
    /**
     * @inheritdoc
     */
    doDelete(_physicalId: string, _resourceProperties: WaitForStableServiceResourceProps): Promise<void>;
    private implementsWaitForStableServiceResourceProps;
}
/**
 * The lambda handler that is used to log in to MongoDB and perform some configuration actions.
 */
export declare function wait(event: CfnRequestEvent, context: LambdaContext): Promise<string>;
