/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * Verifies that the path given in the argument exists and is a directory.
 * @param location
 */
export declare function ensureIsDirectory(location: string): Promise<void>;
/**
 * Given a filename that is assumed to be numeric, return the next numeric
 * filename in increasing order padded out to 5 digits.
 * @param filename
 * @returns
 */
export declare function nextSequentialFile(filename: string): string;
/**
 * List all of the names in the given directory that are numeric.
 * @param location Path of the directory to list. Assumed to be a directory.
 * @returns Array of the names of numeric contents in the directory, sorted into increasing order.
 */
export declare function listNumberedFiles(location: string): Promise<string[]>;
/**
 * Invoke "du -sh -BM" on the given location, to determine the total size in MB stored
 * in the filesystem location.
 * @param location Directory location.
 * @returns Filesystem size under the location, in MiB.
 */
export declare function diskUsage(location: string): Promise<number>;
/**
 * Inspect the filenames in the given directory location, and return the next highest numeric
 * filename that does not already exist.
 * e.g.
 *  i) Empty dir -> 00000
 *  ii) '00000', '00002' -> '00003'
 * @param location Directory to inspect.
 * @returns
 */
export declare function determineNextSequentialFilename(location: string): Promise<string>;
/**
 * Writes a file of zeroes to the given location.
 * @param filename Name of the file to create.
 * @param filesize Size of the file in MiB. Must be a multiple of 10.
 */
export declare function writePaddingFile(filename: string, filesize: number): Promise<void>;
