/**
 * The allocation strategy for the Spot Instances in your Spot Fleet determines how it fulfills your Spot Fleet request from the possible Spot Instance pools represented by its launch specifications.
 *
 * See https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#ec2-fleet-allocation-strategy
 *
 * @stability stable
 */
export declare enum SpotFleetAllocationStrategy {
    /**
     * Spot Fleet launches instances from the Spot Instance pools with the lowest price.
     *
     * @stability stable
     */
    LOWEST_PRICE = "lowestPrice",
    /**
     * Spot Fleet launches instances from all the Spot Instance pools that you specify.
     *
     * @stability stable
     */
    DIVERSIFIED = "diversified",
    /**
     * Spot Fleet launches instances from Spot Instance pools with optimal capacity for the number of instances that are launching.
     *
     * @stability stable
     */
    CAPACITY_OPTIMIZED = "capacityOptimized"
}
/**
 * Resource types that presently support tag on create.
 *
 * @stability stable
 */
export declare enum SpotFleetResourceType {
    /**
     * EC2 Instances.
     *
     * @stability stable
     */
    INSTANCE = "instance",
    /**
     * Spot fleet requests.
     *
     * @stability stable
     */
    SPOT_FLEET_REQUEST = "spot-fleet-request"
}
/**
 * The type of request. Indicates whether the Spot Fleet only requests the target capacity or also attempts to maintain it.
 * Only 'maintain' is currently supported.
 */
export declare enum SpotFleetRequestType {
    /**
     * The type of request.
     *
     * Indicates whether the Spot Fleet only requests the target capacity or also attempts to maintain it.
     * Only 'maintain' is currently supported.
     *
     * @stability stable
     */
    MAINTAIN = "maintain"
}
