# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2019-03-21 12:18
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('surveys', '__first__'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('questions', '__first__'),
    ]

    operations = [
        migrations.CreateModel(
            name='Answer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('custom', models.TextField(blank=True, default=None, null=True, verbose_name='custom')),
                ('created', models.DateTimeField(default=django.utils.timezone.now, verbose_name='created')),
                ('modified', models.DateTimeField(verbose_name='modified')),
                ('option', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to='questions.Option', verbose_name='option')),
                ('option_column', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='option_column', to='questions.Option', verbose_name='option column')),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='questions.Question', verbose_name='question')),
            ],
            options={
                'ordering': ('-created',),
                'db_table': 'votebase_answers',
                'verbose_name': 'answer',
                'verbose_name_plural': 'answers',
            },
        ),
        migrations.CreateModel(
            name='VotedQuestion',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('weight', models.PositiveIntegerField(db_index=True, default=0, verbose_name='weight')),
                ('page', models.PositiveIntegerField(default=1, verbose_name='page')),
                ('quiz_result', models.FloatField(blank=True, db_index=True, default=None, null=True, verbose_name='quiz result')),
                ('created', models.DateTimeField(default=django.utils.timezone.now, verbose_name='created')),
                ('modified', models.DateTimeField(verbose_name='modified')),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='questions.Question', verbose_name='question')),
            ],
            options={
                'ordering': ('weight', 'pk'),
                'db_table': 'votebase_voted_questions',
                'verbose_name': 'voted question',
                'verbose_name_plural': 'voted questions',
            },
        ),
        migrations.CreateModel(
            name='Voter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('quiz_result', models.FloatField(blank=True, db_index=True, default=None, null=True, verbose_name='quiz result')),
                ('hash_key', models.CharField(blank=True, db_index=True, default=None, max_length=255, null=True, verbose_name='hash key')),
                ('ip_address', models.CharField(max_length=255, verbose_name='IP address')),
                ('latitude', models.CharField(blank=True, default=None, max_length=255, null=True, verbose_name='latitude')),
                ('longitude', models.CharField(blank=True, default=None, max_length=255, null=True, verbose_name='longitude')),
                ('continent_code', models.CharField(blank=True, default=None, max_length=255, null=True, verbose_name='continent code')),
                ('country_name', models.CharField(blank=True, default=None, max_length=255, null=True, verbose_name='country name')),
                ('country_code', models.CharField(blank=True, default=None, max_length=255, null=True, verbose_name='country code')),
                ('city', models.CharField(blank=True, default=None, max_length=255, null=True, verbose_name='city')),
                ('area_code', models.CharField(blank=True, default=None, max_length=255, null=True, verbose_name='area code')),
                ('voting_started', models.DateTimeField(blank=True, default=None, null=True, verbose_name='voting started')),
                ('voting_ended', models.DateTimeField(blank=True, default=None, null=True, verbose_name='voting ended')),
                ('voting_duration', models.PositiveIntegerField(blank=True, db_index=True, default=None, null=True, verbose_name='voting duration')),
                ('flag', models.CharField(blank=True, default=None, max_length=256, null=True, verbose_name='custom flag')),
                ('is_quiz_result_sent', models.BooleanField(db_index=True, default=False, verbose_name='quiz result sent')),
                ('is_api_voter', models.BooleanField(default=False, verbose_name='API voter')),
                ('is_irrelevant', models.BooleanField(default=False, verbose_name='irrelevant')),
                ('created', models.DateTimeField(default=django.utils.timezone.now, verbose_name='created')),
                ('modified', models.DateTimeField(verbose_name='modified')),
                ('round', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='surveys.Round', verbose_name='segment')),
                ('survey', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='surveys.Survey', verbose_name='survey')),
                ('user', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
            options={
                'ordering': ('-created',),
                'db_table': 'votebase_voters',
                'verbose_name': 'voter',
                'verbose_name_plural': 'voters',
            },
        ),
        migrations.AddField(
            model_name='votedquestion',
            name='voter',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='voting.Voter', verbose_name='voter'),
        ),
        migrations.AddField(
            model_name='answer',
            name='voter',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='voting.Voter', verbose_name='voter'),
        ),
    ]
