# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2019-03-21 12:19
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import votebase.core.surveys.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='BrandingImage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', models.ImageField(upload_to=votebase.core.surveys.models.brandingimage_upload_to_image, verbose_name='Image')),
                ('created', models.DateTimeField(default=django.utils.timezone.now, verbose_name='created')),
                ('modified', models.DateTimeField(verbose_name='modified')),
            ],
            options={
                'db_table': 'votebase_brandingimages',
                'verbose_name': 'branding image',
                'verbose_name_plural': 'branding images',
            },
        ),
        migrations.CreateModel(
            name='Round',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(default='Default segment', max_length=70, verbose_name='title')),
                ('slug', models.SlugField(blank=True, default=None, help_text='Slug used to customize sharing URL. For example my-segment. Keep blank to be autogenerated by segment title.', max_length=80, null=True, verbose_name='URL alias')),
                ('hash_key', models.CharField(blank=True, default=None, max_length=255, null=True, verbose_name='hash key')),
                ('duration', models.PositiveIntegerField(blank=True, default=0, help_text='Set the voting duration in minutes or keep the default         value (0) for infinite.', null=True, verbose_name='voting duration')),
                ('date_from', models.DateTimeField(blank=True, db_index=True, default=django.utils.timezone.now, help_text='Users can start voting beginning this date.', null=True, verbose_name='valid from')),
                ('date_to', models.DateTimeField(blank=True, db_index=True, default=None, help_text='Users will be able to vote until this date. Keep blank to unlimited.', null=True, verbose_name='valid to')),
                ('password', models.CharField(blank=True, default=None, max_length=255, null=True, verbose_name='password')),
                ('permission_level', models.CharField(choices=[(b'PUBLIC', 'Public - for everyone'), (b'REGISTERED', 'Registered users only')], default=b'PUBLIC', max_length=255, verbose_name='permission level')),
                ('statistics_policy', models.CharField(choices=[(b'PUBLIC', 'Public - for everyone'), (b'SECRET', 'Secret - for voters only'), (b'PRIVATE', 'Private - for creator only')], default=b'PRIVATE', max_length=255, verbose_name='statistics policy')),
                ('count_questions', models.PositiveIntegerField(blank=True, default=None, help_text='Number of questions served to voter. Keep blank to serve all questions.', null=True, verbose_name='count of questions')),
                ('finish_url', models.URLField(blank=True, default=None, help_text='Fill in if you want to show custom finish URL to voter after voting.', max_length=255, null=True, verbose_name='Finish URL')),
                ('finish_url_title', models.CharField(blank=True, default=None, max_length=255, null=True, verbose_name='Finish URL title')),
                ('email_treshold', models.PositiveIntegerField(blank=True, default=1, help_text='Determine when do you want to receive email about new voters.', null=True, verbose_name='Email threshold')),
                ('is_active', models.BooleanField(db_index=True, default=True, help_text='Current segment status. Users will not be able to start voting if inactive.', verbose_name='active')),
                ('is_anonymous', models.BooleanField(db_index=True, default=False, help_text="Set checked if you         don't want to public the names of responders in the statistics.", verbose_name='anonymous')),
                ('is_repeatable', models.BooleanField(db_index=True, default=False, help_text='Set checked if         users can vote multiple times in survey.', verbose_name='repeatable voting')),
                ('is_quiz_result_visible', models.BooleanField(db_index=True, default=False, help_text='Set checked         if you want to show quiz results in percentage to voters.', verbose_name='show quiz results')),
                ('is_quiz_correct_options_visible', models.BooleanField(db_index=True, default=False, help_text='Set checked         if you want to show correct options to voters.', verbose_name='show quiz correct options')),
                ('is_viewable', models.BooleanField(default=True, help_text='Set checked if         users can see survey questions without voting.', verbose_name='view survey')),
                ('is_shuffle', models.BooleanField(default=False, verbose_name='Shuffle')),
                ('created', models.DateTimeField(default=django.utils.timezone.now, verbose_name='created')),
                ('modified', models.DateTimeField(verbose_name='modified')),
                ('ancestor', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to='surveys.Round', verbose_name='ancestor')),
            ],
            options={
                'ordering': ('-created',),
                'db_table': 'votebase_rounds',
                'verbose_name': 'segment',
                'verbose_name_plural': 'segments',
            },
        ),
        migrations.CreateModel(
            name='Survey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=150, verbose_name='title')),
                ('hash_key', models.CharField(blank=True, db_index=True, default=None, max_length=255, null=True, verbose_name='hash key')),
                ('preface', models.TextField(blank=True, default='Your opinion means a lot to us. Thank you for it.', null=True, verbose_name='preface')),
                ('postface', models.TextField(blank=True, default='Thank you for participating in the survey.', null=True, verbose_name='postface')),
                ('css', models.TextField(blank=True, default=None, null=True, verbose_name='CSS')),
                ('is_visible', models.BooleanField(default=False, verbose_name='visibility')),
                ('created', models.DateTimeField(default=django.utils.timezone.now, verbose_name='created')),
                ('modified', models.DateTimeField(verbose_name='modified')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
            options={
                'ordering': ('-created',),
                'db_table': 'votebase_surveys',
                'verbose_name': 'survey',
                'verbose_name_plural': 'surveys',
            },
        ),
        migrations.AddField(
            model_name='round',
            name='survey',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='surveys.Survey', verbose_name='survey'),
        ),
        migrations.AddField(
            model_name='brandingimage',
            name='survey',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='surveys.Survey', verbose_name='survey'),
        ),
        migrations.AddField(
            model_name='brandingimage',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='survey'),
        ),
    ]
