# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2019-03-21 12:19
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import votebase.core.questions.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('surveys', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Option',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=512, verbose_name='title')),
                ('image', models.ImageField(blank=True, default=None, height_field=b'image_height', null=True, upload_to=votebase.core.questions.models.option_upload_to_image, verbose_name='image', width_field=b'image_width')),
                ('image_width', models.IntegerField(blank=True, default=None, null=True, verbose_name='width')),
                ('image_height', models.IntegerField(blank=True, default=None, null=True, verbose_name='height')),
                ('image_position', models.CharField(choices=[(b'TOP', 'Top'), (b'RIGHT', 'Right'), (b'BOTTOM', 'Bottom'), (b'LEFT', 'Left')], default=b'LEFT', max_length=255, verbose_name='image position')),
                ('orientation', models.CharField(choices=[(b'ROW', 'Row'), (b'ROW', 'Column')], default=b'ROW', max_length=255, verbose_name='orientation')),
                ('is_correct', models.BooleanField(db_index=True, default=False, verbose_name='correct')),
                ('weight', models.PositiveIntegerField(db_index=True, default=0, verbose_name='weight')),
                ('created', models.DateTimeField(default=django.utils.timezone.now, verbose_name='created')),
                ('modified', models.DateTimeField(verbose_name='modified')),
            ],
            options={
                'ordering': ('weight', 'created'),
                'db_table': 'votebase_options',
                'verbose_name': 'option',
                'verbose_name_plural': 'options',
            },
        ),
        migrations.CreateModel(
            name='Question',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('kind', models.CharField(choices=[(b'RADIO', 'Radio'), (b'GENDER', 'Gender'), (b'CHECKBOX', 'Checkbox'), (b'TEXTFIELD', 'Textfield'), (b'TEXTAREA', 'Textarea'), (b'EMAIL', 'E-mail'), (b'PHONE', 'Phone'), (b'MATRIX_RADIO', 'Matrix radio'), (b'MATRIX_CHECKBOX', 'Matrix checkbox'), (b'SELECT_SINGLE', 'Select single'), (b'SELECT_MULTIPLE', 'Select multiple'), (b'TRUE_FALSE', 'True/False'), (b'STARS', 'Rating stars'), (b'THUMBS', 'Rating thumbs'), (b'DATE', 'Date'), (b'TIME', 'Time')], db_index=True, max_length=15, verbose_name='kind')),
                ('title', models.TextField(verbose_name='title')),
                ('category', models.CharField(blank=True, db_index=True, default=None, max_length=255, null=True, verbose_name='category')),
                ('image', models.ImageField(blank=True, default=None, height_field=b'image_height', null=True, upload_to=votebase.core.questions.models.question_upload_to_image, verbose_name='image attachement', width_field=b'image_width')),
                ('image_width', models.IntegerField(blank=True, default=None, null=True, verbose_name='width')),
                ('image_height', models.IntegerField(blank=True, default=None, null=True, verbose_name='height')),
                ('image_position', models.CharField(choices=[(b'TOP', 'Top'), (b'RIGHT', 'Right'), (b'BOTTOM', 'Bottom'), (b'LEFT', 'Left')], default=b'LEFT', max_length=255, verbose_name='image position')),
                ('image_size', models.CharField(choices=[(b'ORIGINAL', 'original'), (b'30_PERCENT', '30%'), (b'50_PERCENT', '50%'), (b'80_PERCENT', '80%'), (b'100_PERCENT', '100%')], default=b'ORIGINAL', max_length=20, verbose_name='image size')),
                ('weight', models.PositiveIntegerField(db_index=True, default=0, verbose_name='weight')),
                ('true_label', models.CharField(default='True', max_length=20, verbose_name='true label')),
                ('false_label', models.CharField(default='False', max_length=20, verbose_name='false label')),
                ('is_required', models.BooleanField(default=False, verbose_name='mandatory')),
                ('is_quiz', models.BooleanField(db_index=True, default=False, verbose_name='quiz')),
                ('is_unique_answers', models.BooleanField(default=False, help_text='for matrix questions', verbose_name='unique answers')),
                ('is_empty_row_enabled', models.BooleanField(default=True, help_text='for matrix questions with required answer', verbose_name='enabled empty rows')),
                ('created', models.DateTimeField(default=django.utils.timezone.now, verbose_name='created')),
                ('modified', models.DateTimeField(verbose_name='modified')),
                ('survey', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='surveys.Survey', verbose_name='survey')),
            ],
            options={
                'ordering': ('weight', 'created'),
                'db_table': 'votebase_questions',
                'verbose_name': 'question',
                'verbose_name_plural': 'questions',
            },
        ),
        migrations.AddField(
            model_name='option',
            name='question',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='questions.Question', verbose_name='question'),
        ),
    ]
