# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2019-03-21 12:18
from __future__ import unicode_literals

from django.conf import settings
import django.contrib.auth.models
import django.contrib.auth.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0008_alter_user_username_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(error_messages={'unique': 'A user with that username already exists.'}, help_text='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.', max_length=150, unique=True, validators=[django.contrib.auth.validators.ASCIIUsernameValidator()], verbose_name='username')),
                ('first_name', models.CharField(blank=True, max_length=30, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, max_length=30, verbose_name='last name')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='email address')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions')),
            ],
            options={
                'db_table': 'auth_user',
                'verbose_name': 'user',
                'verbose_name_plural': 'user',
            },
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='Profile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('_package', models.CharField(choices=[(b'BASIC', 'Basic'), (b'STANDARD', 'Standard'), (b'PREMIUM', 'Premium')], db_column=b'package', default=b'BASIC', max_length=32, verbose_name='package')),
                ('package_valid_to', models.DateTimeField(default=django.utils.timezone.now, verbose_name='package valid to')),
                ('activation_hash', models.CharField(blank=True, default=None, max_length=255, null=True, verbose_name='activation hash')),
                ('api_key', models.CharField(blank=True, default=None, max_length=255, null=True, verbose_name='API key')),
                ('slug', models.SlugField(max_length=60, unique=True, verbose_name='URL alias')),
                ('first_name', models.CharField(blank=True, default=None, max_length=30, null=True, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, default=None, max_length=30, null=True, verbose_name='last name')),
                ('last_seen_surveys', models.DateTimeField(default=django.utils.timezone.now, verbose_name='last seen surveys')),
                ('date_of_birth', models.DateField(blank=True, null=True)),
                ('gender', models.CharField(blank=True, choices=[(b'm', b'Male'), (b'f', b'Female')], max_length=1, null=True)),
                ('created', models.DateTimeField(default=django.utils.timezone.now, verbose_name='created')),
                ('modified', models.DateTimeField(verbose_name='modified')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
            options={
                'ordering': ('-created',),
                'db_table': 'votebase_profiles',
                'verbose_name': 'profile',
                'verbose_name_plural': 'profiles',
            },
        ),
    ]
