/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(self["webpackChunk_JUPYTERLAB_CORE_OUTPUT"] = self["webpackChunk_JUPYTERLAB_CORE_OUTPUT"] || []).push([["vendors-node_modules_lumino_dragdrop_dist_index_es6_js"],{

/***/ "../node_modules/@lumino/dragdrop/dist/index.es6.js":
/*!**********************************************************!*\
  !*** ../node_modules/@lumino/dragdrop/dist/index.es6.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Drag\": () => /* binding */ Drag\n/* harmony export */ });\n/* harmony import */ var _lumino_disposable__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/disposable */ \"webpack/sharing/consume/default/@lumino/disposable/@lumino/disposable\");\n/* harmony import */ var _lumino_disposable__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_disposable__WEBPACK_IMPORTED_MODULE_0__);\n\n\n/**\n * An object which manages a drag-drop operation.\n *\n * A drag object dispatches four different events to drop targets:\n *\n * - `'lm-dragenter'` - Dispatched when the mouse enters the target\n *   element. This event must be canceled in order to receive any\n *   of the other events.\n *\n * - `'lm-dragover'` - Dispatched when the mouse moves over the drop\n *   target. It must cancel the event and set the `dropAction` to one\n *   of the supported actions in order to receive drop events.\n *\n * - `'lm-dragleave'` - Dispatched when the mouse leaves the target\n *   element. This includes moving the mouse into child elements.\n *\n * - `'lm-drop'`- Dispatched when the mouse is released over the target\n *   element when the target indicates an appropriate drop action. If\n *   the event is canceled, the indicated drop action is returned to\n *   the initiator through the resolved promise.\n *\n * A drag operation can be terminated at any time by pressing `Escape`\n * or by disposing the drag object.\n *\n * A drag object has the ability to automatically scroll a scrollable\n * element when the mouse is hovered near one of its edges. To enable\n * this, add the `data-lm-dragscroll` attribute to any element which\n * the drag object should consider for scrolling.\n *\n * #### Notes\n * This class is designed to be used when dragging and dropping custom\n * data *within* a single application. It is *not* a replacement for\n * the native drag-drop API. Instead, it provides an API which allows\n * drag operations to be initiated programmatically and enables the\n * transfer of arbitrary non-string objects; features which are not\n * possible with the native drag-drop API.\n */\nvar Drag = /** @class */ (function () {\n    /**\n     * Construct a new drag object.\n     *\n     * @param options - The options for initializing the drag.\n     */\n    function Drag(options) {\n        var _this = this;\n        /**\n         * The scroll loop handler function.\n         */\n        this._onScrollFrame = function () {\n            // Bail early if there is no scroll target.\n            if (!_this._scrollTarget) {\n                return;\n            }\n            // Unpack the scroll target.\n            var _a = _this._scrollTarget, element = _a.element, edge = _a.edge, distance = _a.distance;\n            // Calculate the scroll delta using nonlinear acceleration.\n            var d = Private.SCROLL_EDGE_SIZE - distance;\n            var f = Math.pow(d / Private.SCROLL_EDGE_SIZE, 2);\n            var s = Math.max(1, Math.round(f * Private.SCROLL_EDGE_SIZE));\n            // Scroll the element in the specified direction.\n            switch (edge) {\n                case 'top':\n                    element.scrollTop -= s;\n                    break;\n                case 'left':\n                    element.scrollLeft -= s;\n                    break;\n                case 'right':\n                    element.scrollLeft += s;\n                    break;\n                case 'bottom':\n                    element.scrollTop += s;\n                    break;\n            }\n            // Request the next cycle of the scroll loop.\n            requestAnimationFrame(_this._onScrollFrame);\n        };\n        this._disposed = false;\n        this._dropAction = 'none';\n        this._override = null;\n        this._currentTarget = null;\n        this._currentElement = null;\n        this._promise = null;\n        this._scrollTarget = null;\n        this._resolve = null;\n        this.mimeData = options.mimeData;\n        this.dragImage = options.dragImage || null;\n        this.proposedAction = options.proposedAction || 'copy';\n        this.supportedActions = options.supportedActions || 'all';\n        this.source = options.source || null;\n    }\n    /**\n     * Dispose of the resources held by the drag object.\n     *\n     * #### Notes\n     * This will cancel the drag operation if it is active.\n     */\n    Drag.prototype.dispose = function () {\n        // Do nothing if the drag object is already disposed.\n        if (this._disposed) {\n            return;\n        }\n        this._disposed = true;\n        // If there is a current target, dispatch a drag leave event.\n        if (this._currentTarget) {\n            var event_1 = Private.createMouseEvent('mouseup', -1, -1);\n            Private.dispatchDragLeave(this, this._currentTarget, null, event_1);\n        }\n        // Finalize the drag object with `'none'`.\n        this._finalize('none');\n    };\n    Object.defineProperty(Drag.prototype, \"isDisposed\", {\n        /**\n         * Test whether the drag object is disposed.\n         */\n        get: function () {\n            return this._disposed;\n        },\n        enumerable: true,\n        configurable: true\n    });\n    /**\n     * Start the drag operation at the specified client position.\n     *\n     * @param clientX - The client X position for the drag start.\n     *\n     * @param clientY - The client Y position for the drag start.\n     *\n     * @returns A promise which resolves to the result of the drag.\n     *\n     * #### Notes\n     * If the drag has already been started, the promise created by the\n     * first call to `start` is returned.\n     *\n     * If the drag operation has ended, or if the drag object has been\n     * disposed, the returned promise will resolve to `'none'`.\n     *\n     * The drag object will be automatically disposed when drag operation\n     * completes. This means `Drag` objects are for single-use only.\n     *\n     * This method assumes the left mouse button is already held down.\n     */\n    Drag.prototype.start = function (clientX, clientY) {\n        var _this = this;\n        // If the drag object is already disposed, resolve to `None`.\n        if (this._disposed) {\n            return Promise.resolve('none');\n        }\n        // If the drag has already been started, return the promise.\n        if (this._promise) {\n            return this._promise;\n        }\n        // Install the document listeners for the drag object.\n        this._addListeners();\n        // Attach the drag image at the specified client position.\n        this._attachDragImage(clientX, clientY);\n        // Create the promise which will be resolved on completion.\n        this._promise = new Promise(function (resolve, reject) {\n            _this._resolve = resolve;\n        });\n        // Trigger a fake move event to kick off the drag operation.\n        var event = Private.createMouseEvent('mousemove', clientX, clientY);\n        document.dispatchEvent(event);\n        // Return the pending promise for the drag operation.\n        return this._promise;\n    };\n    /**\n     * Handle the DOM events for the drag operation.\n     *\n     * @param event - The DOM event sent to the drag object.\n     *\n     * #### Notes\n     * This method implements the DOM `EventListener` interface and is\n     * called in response to events on the document. It should not be\n     * called directly by user code.\n     */\n    Drag.prototype.handleEvent = function (event) {\n        switch (event.type) {\n            case 'mousemove':\n                this._evtMouseMove(event);\n                break;\n            case 'mouseup':\n                this._evtMouseUp(event);\n                break;\n            case 'keydown':\n                this._evtKeyDown(event);\n                break;\n            default:\n                // Stop all other events during drag-drop.\n                event.preventDefault();\n                event.stopPropagation();\n                break;\n        }\n    };\n    /**\n     * Move the drag image element to the specified location.\n     *\n     * This is a no-op if there is no drag image element.\n     */\n    Drag.prototype.moveDragImage = function (clientX, clientY) {\n        if (!this.dragImage) {\n            return;\n        }\n        var style = this.dragImage.style;\n        style.top = clientY + \"px\";\n        style.left = clientX + \"px\";\n    };\n    /**\n     * Handle the `'mousemove'` event for the drag object.\n     */\n    Drag.prototype._evtMouseMove = function (event) {\n        // Stop all input events during drag-drop.\n        event.preventDefault();\n        event.stopPropagation();\n        // Update the current target node and dispatch enter/leave events.\n        this._updateCurrentTarget(event);\n        // Update the drag scroll element.\n        this._updateDragScroll(event);\n        // Move the drag image to the specified client position. This is\n        // performed *after* dispatching to prevent unnecessary reflows.\n        this.moveDragImage(event.clientX, event.clientY);\n    };\n    /**\n     * Handle the `'mouseup'` event for the drag object.\n     */\n    Drag.prototype._evtMouseUp = function (event) {\n        // Stop all input events during drag-drop.\n        event.preventDefault();\n        event.stopPropagation();\n        // Do nothing if the left button is not released.\n        if (event.button !== 0) {\n            return;\n        }\n        // Update the current target node and dispatch enter/leave events.\n        // This prevents a subtle issue where the DOM mutates under the\n        // cursor after the last move event but before the drop event.\n        this._updateCurrentTarget(event);\n        // If there is no current target, finalize with `'none'`.\n        if (!this._currentTarget) {\n            this._finalize('none');\n            return;\n        }\n        // If the last drop action was `'none'`, dispatch a leave event\n        // to the current target and finalize the drag with `'none'`.\n        if (this._dropAction === 'none') {\n            Private.dispatchDragLeave(this, this._currentTarget, null, event);\n            this._finalize('none');\n            return;\n        }\n        // Dispatch the drop event at the current target and finalize\n        // with the resulting drop action.\n        var action = Private.dispatchDrop(this, this._currentTarget, event);\n        this._finalize(action);\n    };\n    /**\n     * Handle the `'keydown'` event for the drag object.\n     */\n    Drag.prototype._evtKeyDown = function (event) {\n        // Stop all input events during drag-drop.\n        event.preventDefault();\n        event.stopPropagation();\n        // Cancel the drag if `Escape` is pressed.\n        if (event.keyCode === 27) {\n            this.dispose();\n        }\n    };\n    /**\n     * Add the document event listeners for the drag object.\n     */\n    Drag.prototype._addListeners = function () {\n        document.addEventListener('mousedown', this, true);\n        document.addEventListener('mousemove', this, true);\n        document.addEventListener('mouseup', this, true);\n        document.addEventListener('mouseenter', this, true);\n        document.addEventListener('mouseleave', this, true);\n        document.addEventListener('mouseover', this, true);\n        document.addEventListener('mouseout', this, true);\n        document.addEventListener('keydown', this, true);\n        document.addEventListener('keyup', this, true);\n        document.addEventListener('keypress', this, true);\n        document.addEventListener('contextmenu', this, true);\n    };\n    /**\n     * Remove the document event listeners for the drag object.\n     */\n    Drag.prototype._removeListeners = function () {\n        document.removeEventListener('mousedown', this, true);\n        document.removeEventListener('mousemove', this, true);\n        document.removeEventListener('mouseup', this, true);\n        document.removeEventListener('mouseenter', this, true);\n        document.removeEventListener('mouseleave', this, true);\n        document.removeEventListener('mouseover', this, true);\n        document.removeEventListener('mouseout', this, true);\n        document.removeEventListener('keydown', this, true);\n        document.removeEventListener('keyup', this, true);\n        document.removeEventListener('keypress', this, true);\n        document.removeEventListener('contextmenu', this, true);\n    };\n    /**\n     * Update the drag scroll element under the mouse.\n     */\n    Drag.prototype._updateDragScroll = function (event) {\n        // Find the scroll target under the mouse.\n        var target = Private.findScrollTarget(event);\n        // Bail if there is nothing to scroll.\n        if (!this._scrollTarget && !target) {\n            return;\n        }\n        // Start the scroll loop if needed.\n        if (!this._scrollTarget) {\n            setTimeout(this._onScrollFrame, 500);\n        }\n        // Update the scroll target.\n        this._scrollTarget = target;\n    };\n    /**\n     * Update the current target node using the given mouse event.\n     */\n    Drag.prototype._updateCurrentTarget = function (event) {\n        // Fetch common local state.\n        var prevTarget = this._currentTarget;\n        var currTarget = this._currentTarget;\n        var prevElem = this._currentElement;\n        // Find the current indicated element at the given position.\n        var currElem = document.elementFromPoint(event.clientX, event.clientY);\n        // Update the current element reference.\n        this._currentElement = currElem;\n        // If the indicated element changes from the previous iteration,\n        // and is different from the current target, dispatch the exit\n        // event to the target.\n        if (currElem !== prevElem && currElem !== currTarget) {\n            Private.dispatchDragExit(this, currTarget, currElem, event);\n        }\n        // If the indicated element changes from the previous iteration,\n        // and is different from the current target, dispatch the enter\n        // event and compute the new target element.\n        if (currElem !== prevElem && currElem !== currTarget) {\n            currTarget = Private.dispatchDragEnter(this, currElem, currTarget, event);\n        }\n        // If the current target element has changed, update the current\n        // target reference and dispatch the leave event to the old target.\n        if (currTarget !== prevTarget) {\n            this._currentTarget = currTarget;\n            Private.dispatchDragLeave(this, prevTarget, currTarget, event);\n        }\n        // Dispatch the drag over event and update the drop action.\n        var action = Private.dispatchDragOver(this, currTarget, event);\n        this._setDropAction(action);\n    };\n    /**\n     * Attach the drag image element at the specified location.\n     *\n     * This is a no-op if there is no drag image element.\n     */\n    Drag.prototype._attachDragImage = function (clientX, clientY) {\n        if (!this.dragImage) {\n            return;\n        }\n        this.dragImage.classList.add('lm-mod-drag-image');\n        /* <DEPRECATED> */\n        this.dragImage.classList.add('p-mod-drag-image');\n        /* </DEPRECATED> */\n        var style = this.dragImage.style;\n        style.pointerEvents = 'none';\n        style.position = 'fixed';\n        style.top = clientY + \"px\";\n        style.left = clientX + \"px\";\n        document.body.appendChild(this.dragImage);\n    };\n    /**\n     * Detach the drag image element from the DOM.\n     *\n     * This is a no-op if there is no drag image element.\n     */\n    Drag.prototype._detachDragImage = function () {\n        if (!this.dragImage) {\n            return;\n        }\n        var parent = this.dragImage.parentNode;\n        if (!parent) {\n            return;\n        }\n        parent.removeChild(this.dragImage);\n    };\n    /**\n     * Set the internal drop action state and update the drag cursor.\n     */\n    Drag.prototype._setDropAction = function (action) {\n        action = Private.validateAction(action, this.supportedActions);\n        if (this._override && this._dropAction === action) {\n            return;\n        }\n        switch (action) {\n            case 'none':\n                this._dropAction = action;\n                this._override = Drag.overrideCursor('no-drop');\n                break;\n            case 'copy':\n                this._dropAction = action;\n                this._override = Drag.overrideCursor('copy');\n                break;\n            case 'link':\n                this._dropAction = action;\n                this._override = Drag.overrideCursor('alias');\n                break;\n            case 'move':\n                this._dropAction = action;\n                this._override = Drag.overrideCursor('move');\n                break;\n        }\n    };\n    /**\n     * Finalize the drag operation and resolve the drag promise.\n     */\n    Drag.prototype._finalize = function (action) {\n        // Store the resolve function as a temp variable.\n        var resolve = this._resolve;\n        // Remove the document event listeners.\n        this._removeListeners();\n        // Detach the drag image.\n        this._detachDragImage();\n        // Dispose of the cursor override.\n        if (this._override) {\n            this._override.dispose();\n            this._override = null;\n        }\n        // Clear the mime data.\n        this.mimeData.clear();\n        // Clear the rest of the internal drag state.\n        this._disposed = true;\n        this._dropAction = 'none';\n        this._currentTarget = null;\n        this._currentElement = null;\n        this._scrollTarget = null;\n        this._promise = null;\n        this._resolve = null;\n        // Finally, resolve the promise to the given drop action.\n        if (resolve) {\n            resolve(action);\n        }\n    };\n    return Drag;\n}());\n/**\n * The namespace for the `Drag` class statics.\n */\n(function (Drag) {\n    /**\n     * Override the cursor icon for the entire document.\n     *\n     * @param cursor - The string representing the cursor style.\n     *\n     * @returns A disposable which will clear the override when disposed.\n     *\n     * #### Notes\n     * The most recent call to `overrideCursor` takes precedence.\n     * Disposing an old override has no effect on the current override.\n     *\n     * This utility function is used by the `Drag` class to override the\n     * mouse cursor during a drag-drop operation, but it can also be used\n     * by other classes to fix the cursor icon during normal mouse drags.\n     *\n     * #### Example\n     * ```typescript\n     * import { Drag } from '@lumino/dragdrop';\n     *\n     * // Force the cursor to be 'wait' for the entire document.\n     * let override = Drag.overrideCursor('wait');\n     *\n     * // Clear the override by disposing the return value.\n     * override.dispose();\n     * ```\n     */\n    function overrideCursor(cursor) {\n        var id = ++overrideCursorID;\n        document.body.style.cursor = cursor;\n        document.body.classList.add('lm-mod-override-cursor');\n        /* <DEPRECATED> */\n        document.body.classList.add('p-mod-override-cursor');\n        /* </DEPRECATED> */\n        return new _lumino_disposable__WEBPACK_IMPORTED_MODULE_0__.DisposableDelegate(function () {\n            if (id === overrideCursorID) {\n                document.body.style.cursor = '';\n                document.body.classList.remove('lm-mod-override-cursor');\n                /* <DEPRECATED> */\n                document.body.classList.remove('p-mod-override-cursor');\n                /* </DEPRECATED> */\n            }\n        });\n    }\n    Drag.overrideCursor = overrideCursor;\n    /**\n     * The internal id for the active cursor override.\n     */\n    var overrideCursorID = 0;\n})(Drag || (Drag = {}));\n/**\n * The namespace for the module implementation details.\n */\nvar Private;\n(function (Private) {\n    /**\n     * The size of a drag scroll edge, in pixels.\n     */\n    Private.SCROLL_EDGE_SIZE = 20;\n    /**\n     * Validate the given action is one of the supported actions.\n     *\n     * Returns the given action or `'none'` if the action is unsupported.\n     */\n    function validateAction(action, supported) {\n        return (actionTable[action] & supportedTable[supported]) ? action : 'none';\n    }\n    Private.validateAction = validateAction;\n    /**\n     * Create a left mouse event at the given position.\n     *\n     * @param type - The event type for the mouse event.\n     *\n     * @param clientX - The client X position.\n     *\n     * @param clientY - The client Y position.\n     *\n     * @returns A newly created and initialized mouse event.\n     */\n    function createMouseEvent(type, clientX, clientY) {\n        var event = document.createEvent('MouseEvent');\n        event.initMouseEvent(type, true, true, window, 0, 0, 0, clientX, clientY, false, false, false, false, 0, null);\n        return event;\n    }\n    Private.createMouseEvent = createMouseEvent;\n    /**\n     * Find the drag scroll target under the mouse, if any.\n     */\n    function findScrollTarget(event) {\n        // Look up the client mouse position.\n        var x = event.clientX;\n        var y = event.clientY;\n        // Get the element under the mouse.\n        var element = document.elementFromPoint(x, y);\n        // Search for a scrollable target based on the mouse position.\n        // The null assert in third clause of for-loop is required due to:\n        // https://github.com/Microsoft/TypeScript/issues/14143\n        for (; element; element = element.parentElement) {\n            // Ignore elements which are not marked as scrollable.\n            var scrollable = element.hasAttribute('data-lm-dragscroll');\n            /* <DEPRECATED> */\n            scrollable = scrollable || element.hasAttribute('data-p-dragscroll');\n            /* </DEPRECATED> */\n            if (!scrollable) {\n                continue;\n            }\n            // Set up the coordinate offsets for the element.\n            var offsetX = 0;\n            var offsetY = 0;\n            if (element === document.body) {\n                offsetX = window.pageXOffset;\n                offsetY = window.pageYOffset;\n            }\n            // Get the element bounds in viewport coordinates.\n            var r = element.getBoundingClientRect();\n            var top_1 = r.top + offsetY;\n            var left = r.left + offsetX;\n            var right = left + r.width;\n            var bottom = top_1 + r.height;\n            // Skip the element if it's not under the mouse.\n            if (x < left || x >= right || y < top_1 || y >= bottom) {\n                continue;\n            }\n            // Compute the distance to each edge.\n            var dl = x - left + 1;\n            var dt = y - top_1 + 1;\n            var dr = right - x;\n            var db = bottom - y;\n            // Find the smallest of the edge distances.\n            var distance = Math.min(dl, dt, dr, db);\n            // Skip the element if the mouse is not within a scroll edge.\n            if (distance > Private.SCROLL_EDGE_SIZE) {\n                continue;\n            }\n            // Set up the edge result variable.\n            var edge = void 0;\n            // Find the edge for the computed distance.\n            switch (distance) {\n                case db:\n                    edge = 'bottom';\n                    break;\n                case dt:\n                    edge = 'top';\n                    break;\n                case dr:\n                    edge = 'right';\n                    break;\n                case dl:\n                    edge = 'left';\n                    break;\n                default:\n                    throw 'unreachable';\n            }\n            // Compute how much the element can scroll in width and height.\n            var dsw = element.scrollWidth - element.clientWidth;\n            var dsh = element.scrollHeight - element.clientHeight;\n            // Determine if the element should be scrolled for the edge.\n            var shouldScroll = void 0;\n            switch (edge) {\n                case 'top':\n                    shouldScroll = dsh > 0 && element.scrollTop > 0;\n                    break;\n                case 'left':\n                    shouldScroll = dsw > 0 && element.scrollLeft > 0;\n                    break;\n                case 'right':\n                    shouldScroll = dsw > 0 && element.scrollLeft < dsw;\n                    break;\n                case 'bottom':\n                    shouldScroll = dsh > 0 && element.scrollTop < dsh;\n                    break;\n                default:\n                    throw 'unreachable';\n            }\n            // Skip the element if it should not be scrolled.\n            if (!shouldScroll) {\n                continue;\n            }\n            // Return the drag scroll target.\n            return { element: element, edge: edge, distance: distance };\n        }\n        // No drag scroll target was found.\n        return null;\n    }\n    Private.findScrollTarget = findScrollTarget;\n    /**\n     * Dispatch a drag enter event to the indicated element.\n     *\n     * @param drag - The drag object associated with the action.\n     *\n     * @param currElem - The currently indicated element, or `null`. This\n     *   is the \"immediate user selection\" from the whatwg spec.\n     *\n     * @param currTarget - The current drag target element, or `null`. This\n     *   is the \"current target element\" from the whatwg spec.\n     *\n     * @param event - The mouse event related to the action.\n     *\n     * @returns The element to use as the current drag target. This is the\n     *   \"current target element\" from the whatwg spec, and may be `null`.\n     *\n     * #### Notes\n     * This largely implements the drag enter portion of the whatwg spec:\n     * https://html.spec.whatwg.org/multipage/interaction.html#drag-and-drop-processing-model\n     */\n    function dispatchDragEnter(drag, currElem, currTarget, event) {\n        // If the current element is null, return null as the new target.\n        if (!currElem) {\n            return null;\n        }\n        // Dispatch a drag enter event to the current element.\n        var dragEvent = createDragEvent('lm-dragenter', drag, event, currTarget);\n        var canceled = !currElem.dispatchEvent(dragEvent);\n        // If the event was canceled, use the current element as the new target.\n        if (canceled) {\n            return currElem;\n        }\n        /* <DEPRECATED> */\n        dragEvent = createDragEvent('p-dragenter', drag, event, currTarget);\n        canceled = !currElem.dispatchEvent(dragEvent);\n        if (canceled) {\n            return currElem;\n        }\n        /* </DEPRECATED> */\n        // If the current element is the document body, keep the original target.\n        if (currElem === document.body) {\n            return currTarget;\n        }\n        // Dispatch a drag enter event on the document body.\n        dragEvent = createDragEvent('lm-dragenter', drag, event, currTarget);\n        document.body.dispatchEvent(dragEvent);\n        /* <DEPRECATED> */\n        dragEvent = createDragEvent('p-dragenter', drag, event, currTarget);\n        document.body.dispatchEvent(dragEvent);\n        /* </DEPRECATED> */\n        // Ignore the event cancellation, and use the body as the new target.\n        return document.body;\n    }\n    Private.dispatchDragEnter = dispatchDragEnter;\n    /**\n     * Dispatch a drag exit event to the indicated element.\n     *\n     * @param drag - The drag object associated with the action.\n     *\n     * @param prevTarget - The previous target element, or `null`. This\n     *   is the previous \"current target element\" from the whatwg spec.\n     *\n     * @param currTarget - The current drag target element, or `null`. This\n     *   is the \"current target element\" from the whatwg spec.\n     *\n     * @param event - The mouse event related to the action.\n     *\n     * #### Notes\n     * This largely implements the drag exit portion of the whatwg spec:\n     * https://html.spec.whatwg.org/multipage/interaction.html#drag-and-drop-processing-model\n     */\n    function dispatchDragExit(drag, prevTarget, currTarget, event) {\n        // If the previous target is null, do nothing.\n        if (!prevTarget) {\n            return;\n        }\n        // Dispatch the drag exit event to the previous target.\n        var dragEvent = createDragEvent('lm-dragexit', drag, event, currTarget);\n        prevTarget.dispatchEvent(dragEvent);\n        /* <DEPRECATED> */\n        dragEvent = createDragEvent('p-dragexit', drag, event, currTarget);\n        prevTarget.dispatchEvent(dragEvent);\n        /* </DEPRECATED> */\n    }\n    Private.dispatchDragExit = dispatchDragExit;\n    /**\n     * Dispatch a drag leave event to the indicated element.\n     *\n     * @param drag - The drag object associated with the action.\n     *\n     * @param prevTarget - The previous target element, or `null`. This\n     *   is the previous \"current target element\" from the whatwg spec.\n     *\n     * @param currTarget - The current drag target element, or `null`. This\n     *   is the \"current target element\" from the whatwg spec.\n     *\n     * @param event - The mouse event related to the action.\n     *\n     * #### Notes\n     * This largely implements the drag leave portion of the whatwg spec:\n     * https://html.spec.whatwg.org/multipage/interaction.html#drag-and-drop-processing-model\n     */\n    function dispatchDragLeave(drag, prevTarget, currTarget, event) {\n        // If the previous target is null, do nothing.\n        if (!prevTarget) {\n            return;\n        }\n        // Dispatch the drag leave event to the previous target.\n        var dragEvent = createDragEvent('lm-dragleave', drag, event, currTarget);\n        prevTarget.dispatchEvent(dragEvent);\n        /* <DEPRECATED> */\n        dragEvent = createDragEvent('p-dragleave', drag, event, currTarget);\n        prevTarget.dispatchEvent(dragEvent);\n        /* </DEPRECATED> */\n    }\n    Private.dispatchDragLeave = dispatchDragLeave;\n    /**\n     * Dispatch a drag over event to the indicated element.\n     *\n     * @param drag - The drag object associated with the action.\n     *\n     * @param currTarget - The current drag target element, or `null`. This\n     *   is the \"current target element\" from the whatwg spec.\n     *\n     * @param event - The mouse event related to the action.\n     *\n     * @returns The `DropAction` result of the drag over event.\n     *\n     * #### Notes\n     * This largely implements the drag over portion of the whatwg spec:\n     * https://html.spec.whatwg.org/multipage/interaction.html#drag-and-drop-processing-model\n     */\n    function dispatchDragOver(drag, currTarget, event) {\n        // If there is no current target, the drop action is none.\n        if (!currTarget) {\n            return 'none';\n        }\n        // Dispatch the drag over event to the current target.\n        var dragEvent = createDragEvent('lm-dragover', drag, event, null);\n        var canceled = !currTarget.dispatchEvent(dragEvent);\n        // If the event was canceled, return the drop action result.\n        if (canceled) {\n            return dragEvent.dropAction;\n        }\n        /* <DEPRECATED> */\n        dragEvent = createDragEvent('p-dragover', drag, event, null);\n        canceled = !currTarget.dispatchEvent(dragEvent);\n        if (canceled) {\n            return dragEvent.dropAction;\n        }\n        /* </DEPRECATED> */\n        // Otherwise, the effective drop action is none.\n        return 'none';\n    }\n    Private.dispatchDragOver = dispatchDragOver;\n    /**\n     * Dispatch a drop event to the indicated element.\n     *\n     * @param drag - The drag object associated with the action.\n     *\n     * @param currTarget - The current drag target element, or `null`. This\n     *   is the \"current target element\" from the whatwg spec.\n     *\n     * @param event - The mouse event related to the action.\n     *\n     * @returns The `DropAction` result of the drop event.\n     *\n     * #### Notes\n     * This largely implements the drag over portion of the whatwg spec:\n     * https://html.spec.whatwg.org/multipage/interaction.html#drag-and-drop-processing-model\n     */\n    function dispatchDrop(drag, currTarget, event) {\n        // If there is no current target, the drop action is none.\n        if (!currTarget) {\n            return 'none';\n        }\n        // Dispatch the drop event to the current target.\n        var dragEvent = createDragEvent('lm-drop', drag, event, null);\n        var canceled = !currTarget.dispatchEvent(dragEvent);\n        // If the event was canceled, return the drop action result.\n        if (canceled) {\n            return dragEvent.dropAction;\n        }\n        /* <DEPRECATED> */\n        dragEvent = createDragEvent('p-drop', drag, event, null);\n        canceled = !currTarget.dispatchEvent(dragEvent);\n        if (canceled) {\n            return dragEvent.dropAction;\n        }\n        /* </DEPRECATED> */\n        // Otherwise, the effective drop action is none.\n        return 'none';\n    }\n    Private.dispatchDrop = dispatchDrop;\n    /**\n     * A lookup table from drop action to bit value.\n     */\n    var actionTable = {\n        'none': 0x0,\n        'copy': 0x1,\n        'link': 0x2,\n        'move': 0x4\n    };\n    /**\n     * A lookup table from supported action to drop action bit mask.\n     */\n    var supportedTable = {\n        'none': actionTable['none'],\n        'copy': actionTable['copy'],\n        'link': actionTable['link'],\n        'move': actionTable['move'],\n        'copy-link': actionTable['copy'] | actionTable['link'],\n        'copy-move': actionTable['copy'] | actionTable['move'],\n        'link-move': actionTable['link'] | actionTable['move'],\n        'all': actionTable['copy'] | actionTable['link'] | actionTable['move']\n    };\n    /**\n     * Create a new initialized `IDragEvent` from the given data.\n     *\n     * @param type - The event type for the drag event.\n     *\n     * @param drag - The drag object to use for seeding the drag data.\n     *\n     * @param event - The mouse event to use for seeding the mouse data.\n     *\n     * @param related - The related target for the event, or `null`.\n     *\n     * @returns A new object which implements `IDragEvent`.\n     */\n    function createDragEvent(type, drag, event, related) {\n        // Create a new mouse event to use as the drag event. Currently,\n        // JS engines do now allow user-defined Event subclasses.\n        var dragEvent = document.createEvent('MouseEvent');\n        // Initialize the mouse event data.\n        dragEvent.initMouseEvent(type, true, true, window, 0, event.screenX, event.screenY, event.clientX, event.clientY, event.ctrlKey, event.altKey, event.shiftKey, event.metaKey, event.button, related);\n        // Forcefully add the custom drag event properties.\n        dragEvent.dropAction = 'none';\n        dragEvent.mimeData = drag.mimeData;\n        dragEvent.proposedAction = drag.proposedAction;\n        dragEvent.supportedActions = drag.supportedActions;\n        dragEvent.source = drag.source;\n        // Return the fully initialized drag event.\n        return dragEvent;\n    }\n})(Private || (Private = {}));\n\n\n//# sourceMappingURL=index.es6.js.map\n\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@lumino/dragdrop/dist/index.es6.js?");

/***/ })

}]);