# dict-from-dragonmapper

[![PyPI](https://img.shields.io/pypi/v/dict-from-dragonmapper.svg)](https://pypi.python.org/pypi/dict-from-dragonmapper)
[![PyPI](https://img.shields.io/pypi/pyversions/dict-from-dragonmapper.svg)](https://pypi.python.org/pypi/dict-from-dragonmapper)
[![MIT](https://img.shields.io/github/license/stefantaubert/dict-from-dragonmapper.svg)](https://github.com/stefantaubert/dict-from-dragonmapper/blob/master/LICENSE)
[![PyPI](https://img.shields.io/pypi/wheel/dict-from-dragonmapper.svg)](https://pypi.python.org/pypi/dict-from-dragonmapper)
[![PyPI](https://img.shields.io/pypi/implementation/dict-from-dragonmapper.svg)](https://pypi.python.org/pypi/dict-from-dragonmapper)

Command-line interface (CLI) to create a pronunciation dictionary by looking up IPA transcriptions using [dragonmapper](https://github.com/tsroten/dragonmapper) including the possibility of ignoring punctuation and splitting words on hyphens before transcribing them.
Instead of attaching the tones to the syllable the tones are attached to the vowel of the syllable.

## Installation

```sh
pip install dict-from-dragonmapper --user
```

## Usage

```sh
dict-from-dragonmapper-cli
```

### Example

```sh
# Create example vocabulary
cat > /tmp/vocabulary.txt << EOF
社会语言学？
㐻，
『㑐
鲜-亮。
『占斌？
『机具-机呀？
EOF

# Create dictionary from vocabulary and example dictionary
dict-from-dragonmapper-cli \
  /tmp/vocabulary.txt \
  /tmp/result.dict \
  --split-on-hyphen \
  --n-jobs 4

cat /tmp/result.dict
```

Output:

```txt
社会语言学？  ʂ ɤ˥˩ x w e ɪ˥˩ y˧˩˧ j ɛ˧˥ n ɕ ɥ œ˧˥ ？
㐻，  n e ɪ˥˩ ，
『㑐  『 ʂ u˥
鲜-亮。  ɕ j ɛ˥ n - l j ɑ˥˩ ŋ 。
『占斌？  『 ʈ ʂ a˥˩ n p i˥ n ？
『机具-机呀？  『 t ɕ i˥ t ɕ y˥˩ - t ɕ i˥ j a ？
```

## Dependencies

- `pronunciation-dictionary >= 0.0.4`
- `ordered-set >= 4.1.0`
- `word-to-pronunciation >= 0.0.1`
- `dragonmapper >=0.2.6, < 0.3`
- `tqdm`

## License

MIT License

## Acknowledgments

[dragonmapper](https://github.com/tsroten/dragonmapper)

Funded by the Deutsche Forschungsgemeinschaft (DFG, German Research Foundation) – Project-ID 416228727 – CRC 1410

## Citation

If you want to cite this repo, you can use this BibTeX-entry generated by GitHub (see *About => Cite this repository*).
