"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
// CDK parameters
const STACK_NAME = 'aws-cdk-dynamodb';
// DynamoDB table parameters
const TABLE = 'Table';
const TABLE_WITH_GLOBAL_AND_LOCAL_SECONDARY_INDEX = 'TableWithGlobalAndLocalSecondaryIndex';
const TABLE_WITH_GLOBAL_SECONDARY_INDEX = 'TableWithGlobalSecondaryIndex';
const TABLE_WITH_LOCAL_SECONDARY_INDEX = 'TableWithLocalSecondaryIndex';
const TABLE_PARTITION_KEY = { name: 'hashKey', type: lib_1.AttributeType.STRING };
const TABLE_SORT_KEY = { name: 'sortKey', type: lib_1.AttributeType.NUMBER };
// DynamoDB global secondary index parameters
const GSI_TEST_CASE_1 = 'GSI-PartitionKeyOnly';
const GSI_TEST_CASE_2 = 'GSI-PartitionAndSortKeyWithReadAndWriteCapacity';
const GSI_TEST_CASE_3 = 'GSI-ProjectionTypeKeysOnly';
const GSI_TEST_CASE_4 = 'GSI-ProjectionTypeInclude';
const GSI_TEST_CASE_5 = 'GSI-InverseTableKeySchema';
const GSI_PARTITION_KEY = { name: 'gsiHashKey', type: lib_1.AttributeType.STRING };
const GSI_SORT_KEY = { name: 'gsiSortKey', type: lib_1.AttributeType.NUMBER };
const GSI_NON_KEY = [];
for (let i = 0; i < 10; i++) { // 'A' to 'J'
    GSI_NON_KEY.push(String.fromCharCode(65 + i));
}
// DynamoDB local secondary index parameters
const LSI_TEST_CASE_1 = 'LSI-PartitionAndSortKey';
const LSI_TEST_CASE_2 = 'LSI-PartitionAndTableSortKey';
const LSI_TEST_CASE_3 = 'LSI-ProjectionTypeKeysOnly';
const LSI_TEST_CASE_4 = 'LSI-ProjectionTypeInclude';
const LSI_SORT_KEY = { name: 'lsiSortKey', type: lib_1.AttributeType.NUMBER };
const LSI_NON_KEY = [];
for (let i = 0; i < 10; i++) { // 'K' to 'T'
    LSI_NON_KEY.push(String.fromCharCode(75 + i));
}
const app = new core_1.App();
const stack = new core_1.Stack(app, STACK_NAME);
const table = new lib_1.Table(stack, TABLE, {
    partitionKey: TABLE_PARTITION_KEY,
    removalPolicy: core_1.RemovalPolicy.DESTROY,
});
const tableWithGlobalAndLocalSecondaryIndex = new lib_1.Table(stack, TABLE_WITH_GLOBAL_AND_LOCAL_SECONDARY_INDEX, {
    pointInTimeRecovery: true,
    serverSideEncryption: true,
    stream: lib_1.StreamViewType.KEYS_ONLY,
    timeToLiveAttribute: 'timeToLive',
    partitionKey: TABLE_PARTITION_KEY,
    sortKey: TABLE_SORT_KEY,
    removalPolicy: core_1.RemovalPolicy.DESTROY,
});
tableWithGlobalAndLocalSecondaryIndex.node.applyAspect(new core_1.Tag('Environment', 'Production'));
tableWithGlobalAndLocalSecondaryIndex.addGlobalSecondaryIndex({
    indexName: GSI_TEST_CASE_1,
    partitionKey: GSI_PARTITION_KEY,
});
tableWithGlobalAndLocalSecondaryIndex.addGlobalSecondaryIndex({
    indexName: GSI_TEST_CASE_2,
    partitionKey: GSI_PARTITION_KEY,
    sortKey: GSI_SORT_KEY,
    readCapacity: 10,
    writeCapacity: 10,
});
tableWithGlobalAndLocalSecondaryIndex.addGlobalSecondaryIndex({
    indexName: GSI_TEST_CASE_3,
    partitionKey: GSI_PARTITION_KEY,
    sortKey: GSI_SORT_KEY,
    projectionType: lib_1.ProjectionType.KEYS_ONLY,
});
tableWithGlobalAndLocalSecondaryIndex.addGlobalSecondaryIndex({
    indexName: GSI_TEST_CASE_4,
    partitionKey: GSI_PARTITION_KEY,
    sortKey: GSI_SORT_KEY,
    projectionType: lib_1.ProjectionType.INCLUDE,
    nonKeyAttributes: GSI_NON_KEY,
});
tableWithGlobalAndLocalSecondaryIndex.addGlobalSecondaryIndex({
    indexName: GSI_TEST_CASE_5,
    partitionKey: TABLE_SORT_KEY,
    sortKey: TABLE_PARTITION_KEY,
});
tableWithGlobalAndLocalSecondaryIndex.addLocalSecondaryIndex({
    indexName: LSI_TEST_CASE_2,
    sortKey: LSI_SORT_KEY,
});
tableWithGlobalAndLocalSecondaryIndex.addLocalSecondaryIndex({
    indexName: LSI_TEST_CASE_1,
    sortKey: TABLE_SORT_KEY,
});
tableWithGlobalAndLocalSecondaryIndex.addLocalSecondaryIndex({
    indexName: LSI_TEST_CASE_3,
    sortKey: LSI_SORT_KEY,
    projectionType: lib_1.ProjectionType.KEYS_ONLY,
});
tableWithGlobalAndLocalSecondaryIndex.addLocalSecondaryIndex({
    indexName: LSI_TEST_CASE_4,
    sortKey: LSI_SORT_KEY,
    projectionType: lib_1.ProjectionType.INCLUDE,
    nonKeyAttributes: LSI_NON_KEY,
});
const tableWithGlobalSecondaryIndex = new lib_1.Table(stack, TABLE_WITH_GLOBAL_SECONDARY_INDEX, {
    partitionKey: TABLE_PARTITION_KEY,
    removalPolicy: core_1.RemovalPolicy.DESTROY,
});
tableWithGlobalSecondaryIndex.addGlobalSecondaryIndex({
    indexName: GSI_TEST_CASE_1,
    partitionKey: GSI_PARTITION_KEY,
});
const tableWithLocalSecondaryIndex = new lib_1.Table(stack, TABLE_WITH_LOCAL_SECONDARY_INDEX, {
    partitionKey: TABLE_PARTITION_KEY,
    sortKey: TABLE_SORT_KEY,
    removalPolicy: core_1.RemovalPolicy.DESTROY,
});
tableWithLocalSecondaryIndex.addLocalSecondaryIndex({
    indexName: LSI_TEST_CASE_1,
    sortKey: LSI_SORT_KEY,
});
const user = new iam.User(stack, 'User');
table.grantReadData(user);
tableWithGlobalAndLocalSecondaryIndex.grantReadData(user);
app.synth();
//# sourceMappingURL=data:application/json;base64,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