"""Constants for each device, e.g. tutorial_simulator, washington, aspen-m-2"""
"""
Dictionary keys:
'no_qubits': the total number of qubits in the device
'edges_in_layout': the graph edges present in device layout
'layout': the x, y, z coordinates of the vertices (qubits); z should always be 0
'vertex_labels': the labels of consecutive qubits (in principle they don't have to be consecutive integers,
                see e.g. Rigetti aspen-m-2 device)
'scale': regulates how big the device is plotted in the picture and can be set to 1.0 by default
"""
tutorial_simulator = {'no_qubits': 5,
                      'edges_in_layout': [(0, 1), (1, 2), (1, 3), (3, 4)],
                      'layout': {0: [0, 0, 0],
                                 1: [1, 0, 0],
                                 2: [2, 0, 0],
                                 3: [1, 1, 0],
                                 4: [1, 2, 0]},
                      'vertex_labels': [0, 1, 2, 3, 4],
                      'scale': 1.0}

washington = {'no_qubits': 127,
              'edges_in_layout': [(0, 1), (0, 14), (1, 2), (2, 3), (3, 4), (4, 15), (4, 5), (5, 6), (6, 7), (7, 8),
                                  (8, 16), (9, 10), (10, 11), (11, 12), (12, 13), (12, 17), (14, 18), (15, 22),
                                  (16, 26), (17, 30), (18, 19), (19, 20), (20, 21), (20, 33), (21, 22), (22, 23),
                                  (23, 24), (24, 25), (24, 34), (25, 26), (26, 27), (27, 28), (28, 35), (28, 29),
                                  (29, 30), (30, 31), (31, 32), (32, 36), (33, 39), (34, 43), (35, 47), (36, 51),
                                  (37, 38), (37, 52), (38, 39), (39, 40), (40, 41), (41, 53), (41, 42), (42, 43),
                                  (43, 44), (44, 45), (45, 46), (45, 54), (46, 47), (47, 48), (48, 49), (49, 50),
                                  (49, 55), (50, 51), (52, 56), (53, 60), (54, 64), (55, 68), (56, 57), (57, 58),
                                  (58, 71), (58, 59), (59, 60), (60, 61), (61, 62), (62, 72), (62, 63), (63, 64),
                                  (64, 65), (65, 66), (66, 73), (66, 67), (67, 68), (68, 69), (69, 70), (70, 74),
                                  (71, 77), (72, 81), (73, 85), (74, 89), (75, 76), (75, 90), (76, 77), (77, 78),
                                  (78, 79), (79, 80), (79, 91), (80, 81), (81, 82), (82, 83), (83, 84), (83, 92),
                                  (84, 85), (85, 86), (86, 87), (87, 93), (87, 88), (88, 89), (90, 94), (91, 98),
                                  (92, 102), (93, 106), (94, 95), (95, 96), (96, 97), (96, 109), (97, 98), (98, 99),
                                  (99, 100), (100, 101), (100, 110), (101, 102), (102, 103), (103, 104), (104, 111),
                                  (104, 105), (105, 106), (106, 107), (107, 108), (108, 112), (110, 118), (111, 122),
                                  (112, 126), (113, 114), (114, 115), (115, 116), (116, 117), (117, 118), (118, 119),
                                  (119, 120), (120, 121), (121, 122), (122, 123), (123, 124), (124, 125), (125, 126)],
              'layout': {0: [-7, 6, 0], 1: [-6, 6, 0], 2: [-5, 6, 0], 3: [-4, 6, 0], 4: [-3, 6, 0], 5: [-2, 6, 0],
                         6: [-1, 6, 0], 7: [0, 6, 0], 8: [1, 6, 0], 9: [2, 6, 0], 10: [3, 6, 0], 11: [4, 6, 0],
                         12: [5, 6, 0], 13: [6, 6, 0], 14: [-7, 5, 0], 15: [-3, 5, 0], 16: [1, 5, 0], 17: [5, 5, 0],
                         18: [-7, 4, 0], 19: [-6, 4, 0], 20: [-5, 4, 0], 21: [-4, 4, 0], 22: [-3, 4, 0], 23: [-2, 4, 0],
                         24: [-1, 4, 0], 25: [0, 4, 0], 26: [1, 4, 0], 27: [2, 4, 0], 28: [3, 4, 0], 29: [4, 4, 0],
                         30: [5, 4, 0], 31: [6, 4, 0], 32: [7, 4, 0], 33: [-5, 3, 0], 34: [-1, 3, 0], 35: [3, 3, 0],
                         36: [7, 3, 0], 37: [-7, 2, 0], 38: [-6, 2, 0], 39: [-5, 2, 0], 40: [-4, 2, 0], 41: [-3, 2, 0],
                         42: [-2, 2, 0], 43: [-1, 2, 0], 44: [0, 2, 0], 45: [1, 2, 0], 46: [2, 2, 0], 47: [3, 2, 0],
                         48: [4, 2, 0], 49: [5, 2, 0], 50: [6, 2, 0], 51: [7, 2, 0], 52: [-7, 1, 0], 53: [-3, 1, 0],
                         54: [1, 1, 0], 55: [5, 1, 0], 56: [-7, 0, 0], 57: [-6, 0, 0], 58: [-5, 0, 0], 59: [-4, 0, 0],
                         60: [-3, 0, 0], 61: [-2, 0, 0], 62: [-1, 0, 0], 63: [0, 0, 0], 64: [1, 0, 0], 65: [2, 0, 0],
                         66: [3, 0, 0], 67: [4, 0, 0], 68: [5, 0, 0], 69: [6, 0, 0], 70: [7, 0, 0], 71: [-5, -1, 0],
                         72: [-1, -1, 0], 73: [3, -1, 0], 74: [7, -1, 0], 75: [-7, -2, 0], 76: [-6, -2, 0],
                         77: [-5, -2, 0], 78: [-4, -2, 0], 79: [-3, -2, 0], 80: [-2, -2, 0], 81: [-1, -2, 0],
                         82: [0, -2, 0], 83: [1, -2, 0], 84: [2, -2, 0], 85: [3, -2, 0], 86: [4, -2, 0], 87: [5, -2, 0],
                         88: [6, -2, 0], 89: [7, -2, 0], 90: [-7, -3, 0], 91: [-3, -3, 0], 92: [1, -3, 0],
                         93: [5, -3, 0], 94: [-7, -4, 0], 95: [-6, -4, 0], 96: [-5, -4, 0], 97: [-4, -4, 0],
                         98: [-3, -4, 0], 99: [-2, -4, 0], 100: [-1, -4, 0], 101: [0, -4, 0], 102: [1, -4, 0],
                         103: [2, -4, 0], 104: [3, -4, 0], 105: [4, -4, 0], 106: [5, -4, 0], 107: [6, -4, 0],
                         108: [7, -4, 0], 109: [-5, -5, 0], 110: [-1, -5, 0], 111: [3, -5, 0], 112: [7, -5, 0],
                         113: [-6, -6, 0], 114: [-5, -6, 0], 115: [-4, -6, 0], 116: [-3, -6, 0], 117: [-2, -6, 0],
                         118: [-1, -6, 0], 119: [0, -6, 0], 120: [1, -6, 0], 121: [2, -6, 0], 122: [3, -6, 0],
                         123: [4, -6, 0], 124: [5, -6, 0], 125: [6, -6, 0], 126: [7, -6, 0]},
              'vertex_labels': [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
                                24,
                                25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46,
                                47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68,
                                69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90,
                                91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109,
                                110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126],
              'scale': 0.5}

aspen_m_2 = {'no_qubits': 80,
             'edges_in_layout': [(0, 1), (0, 43), (7, 44), (1, 2), (1, 14), (2, 13), (2, 3), (3, 4), (4, 5), (5, 6),
                                 (6, 7), (0, 7), (8, 9), (8, 51), (15, 52), (9, 10), (9, 22), (10, 21), (10, 11),
                                 (11, 12), (12, 13), (13, 14), (14, 15), (8, 15), (16, 17), (16, 59), (23, 60),
                                 (17, 18), (17, 30), (18, 29), (18, 19), (19, 20), (20, 21), (21, 22), (22, 23),
                                 (16, 23), (24, 25), (24, 67), (31, 68), (25, 26), (25, 38), (26, 37), (26, 27),
                                 (27, 28), (28, 29), (29, 30), (30, 31), (24, 31), (32, 33), (32, 75), (39, 76),
                                 (33, 34), (34, 35), (35, 36), (36, 37), (37, 38), (38, 39), (32, 39), (40, 41),
                                 (41, 42), (41, 54), (42, 53), (42, 43), (43, 44), (44, 45), (45, 46), (46, 47),
                                 (40, 47), (48, 49), (49, 50), (49, 62), (50, 61), (50, 51), (51, 52), (52, 53),
                                 (53, 54), (54, 55), (48, 55), (56, 57), (57, 58), (57, 70), (58, 69), (58, 59),
                                 (59, 60), (60, 61), (61, 62), (62, 63), (56, 63), (64, 65), (65, 66), (65, 78),
                                 (66, 77), (66, 67), (67, 68), (68, 69), (69, 70), (70, 71), (64, 71), (72, 73),
                                 (73, 74), (74, 75), (75, 76), (76, 77), (77, 78), (78, 79), (72, 79)],

             'layout': {0: [-6.0599140527801465, 0.33753853761202035, 0],
                        1: [-5.437538537612021, 0.9599140527801466, 0],
                        2: [-5.437538537612021, 1.8400859472198532, 0],
                        3: [-6.0599140527801465, 2.4624614623879797, 0],
                        4: [-6.9400859472198535, 2.4624614623879797, 0],
                        5: [-7.562461462387979, 1.8400859472198532, 0],
                        6: [-7.562461462387979, 0.9599140527801469, 0],
                        7: [-6.9400859472198535, 0.3375385376120206, 0],
                        8: [-3.0599140527801465, 0.33753853761202035, 0],
                        9: [-2.4375385376120207, 0.9599140527801466, 0],
                        10: [-2.4375385376120207, 1.8400859472198532, 0],
                        11: [-3.0599140527801465, 2.4624614623879797, 0],
                        12: [-3.940085947219853, 2.4624614623879797, 0],
                        13: [-4.562461462387979, 1.8400859472198532, 0],
                        14: [-4.562461462387979, 0.9599140527801469, 0],
                        15: [-3.940085947219854, 0.3375385376120206, 0],
                        16: [-0.05991405278014672, 0.33753853761202035, 0],
                        17: [0.5624614623879796, 0.9599140527801466, 0],
                        18: [0.5624614623879796, 1.8400859472198532, 0],
                        19: [-0.05991405278014672, 2.4624614623879797, 0],
                        20: [-0.9400859472198532, 2.4624614623879797, 0],
                        21: [-1.5624614623879796, 1.8400859472198532, 0],
                        22: [-1.5624614623879798, 0.9599140527801469, 0],
                        23: [-0.9400859472198538, 0.3375385376120206, 0],
                        24: [2.9400859472198535, 0.33753853761202035, 0],
                        25: [3.5624614623879793, 0.9599140527801466, 0],
                        26: [3.5624614623879793, 1.8400859472198532, 0],
                        27: [2.9400859472198535, 2.4624614623879797, 0],
                        28: [2.059914052780147, 2.4624614623879797, 0],
                        29: [1.4375385376120204, 1.8400859472198532, 0],
                        30: [1.4375385376120202, 0.9599140527801469, 0],
                        31: [2.059914052780146, 0.3375385376120206, 0],
                        32: [5.9400859472198535, 0.33753853761202035, 0],
                        33: [6.562461462387979, 0.9599140527801466, 0],
                        34: [6.562461462387979, 1.8400859472198532, 0],
                        35: [5.9400859472198535, 2.4624614623879797, 0],
                        36: [5.0599140527801465, 2.4624614623879797, 0],
                        37: [4.437538537612021, 1.8400859472198532, 0],
                        38: [4.437538537612021, 0.9599140527801469, 0],
                        39: [5.0599140527801465, 0.3375385376120206, 0],
                        40: [-6.0599140527801465, -2.66246146238798, 0],
                        41: [-5.437538537612021, -2.040085947219853, 0],
                        42: [-5.437538537612021, -1.1599140527801468, 0],
                        43: [-6.0599140527801465, -0.5375385376120205, 0],
                        44: [-6.9400859472198535, -0.5375385376120205, 0],
                        45: [-7.562461462387979, -1.1599140527801468, 0],
                        46: [-7.562461462387979, -2.040085947219853, 0],
                        47: [-6.9400859472198535, -2.6624614623879794, 0],
                        48: [-3.0599140527801465, -2.66246146238798, 0],
                        49: [-2.4375385376120207, -2.040085947219853, 0],
                        50: [-2.4375385376120207, -1.1599140527801468, 0],
                        51: [-3.0599140527801465, -0.5375385376120205, 0],
                        52: [-3.940085947219853, -0.5375385376120205, 0],
                        53: [-4.562461462387979, -1.1599140527801468, 0],
                        54: [-4.562461462387979, -2.040085947219853, 0],
                        55: [-3.940085947219854, -2.6624614623879794, 0],
                        56: [-0.05991405278014672, -2.66246146238798, 0],
                        57: [0.5624614623879796, -2.040085947219853, 0],
                        58: [0.5624614623879796, -1.1599140527801468, 0],
                        59: [-0.05991405278014672, -0.5375385376120205, 0],
                        60: [-0.9400859472198532, -0.5375385376120205, 0],
                        61: [-1.5624614623879796, -1.1599140527801468, 0],
                        62: [-1.5624614623879798, -2.040085947219853, 0],
                        63: [-0.9400859472198538, -2.6624614623879794, 0],
                        64: [2.9400859472198535, -2.66246146238798, 0],
                        65: [3.5624614623879793, -2.040085947219853, 0],
                        66: [3.5624614623879793, -1.1599140527801468, 0],
                        67: [2.9400859472198535, -0.5375385376120205, 0],
                        68: [2.059914052780147, -0.5375385376120205, 0],
                        69: [1.4375385376120204, -1.1599140527801468, 0],
                        70: [1.4375385376120202, -2.040085947219853, 0],
                        71: [2.059914052780146, -2.6624614623879794, 0],
                        72: [5.9400859472198535, -2.66246146238798, 0],
                        73: [6.562461462387979, -2.040085947219853, 0],
                        74: [6.562461462387979, -1.1599140527801468, 0],
                        75: [5.9400859472198535, -0.5375385376120205, 0],
                        76: [5.0599140527801465, -0.5375385376120205, 0],
                        77: [4.437538537612021, -1.1599140527801468, 0],
                        78: [4.437538537612021, -2.040085947219853, 0],
                        79: [5.0599140527801465, -2.6624614623879794, 0]},
             'vertex_labels': [0, 1, 2, 3, 4, 5, 6, 7, 10, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 23, 24, 25, 26, 27,
                               30, 31, 32, 33, 34, 35, 36, 37, 40, 41, 42, 43, 44, 45, 46, 47, 100, 101, 102, 103, 104,
                               105, 106, 107, 110, 111, 112, 113, 114, 115, 116, 117, 120, 121, 122, 123, 124, 125, 126,
                               127, 130, 131, 132, 133, 134, 135, 136, 137, 140, 141, 142, 143, 144, 145, 146, 147],
             'scale': 0.7}
