"""
@author: Filip Maciejewski
@contact: filip.b.maciejewski@gmail.com
"""
import numpy as np
from qrem.functions_qrem import functions_standarized_directories as dirs, ancillary_functions as anf
import networkx as nx




__ibm__washington_coupling_map = [[0, 1], [0, 14], [1, 0], [1, 2], [2, 1], [2, 3], [3, 2], [3, 4], [4, 3], [4, 5], [4, 15], [5, 4], [5, 6], [6, 5], [6, 7], [7, 6], [7, 8], [8, 7], [8, 16], [9, 10], [10, 9], [10, 11], [11, 10], [11, 12], [12, 11], [12, 13], [12, 17], [13, 12], [14, 0], [14, 18], [15, 4], [15, 22], [16, 8], [16, 26], [17, 12], [17, 30], [18, 14], [18, 19], [19, 18], [19, 20], [20, 19], [20, 21], [20, 33], [21, 20], [21, 22], [22, 15], [22, 21], [22, 23], [23, 22], [23, 24], [24, 23], [24, 25], [24, 34], [25, 24], [25, 26], [26, 16], [26, 25], [26, 27], [27, 26], [27, 28], [28, 27], [28, 29], [28, 35], [29, 28], [29, 30], [30, 17], [30, 29], [30, 31], [31, 30], [31, 32], [32, 31], [32, 36], [33, 20], [33, 39], [34, 24], [34, 43], [35, 28], [35, 47], [36, 32], [36, 51], [37, 38], [37, 52], [38, 37], [38, 39], [39, 33], [39, 38], [39, 40], [40, 39], [40, 41], [41, 40], [41, 42], [41, 53], [42, 41], [42, 43], [43, 34], [43, 42], [43, 44], [44, 43], [44, 45], [45, 44], [45, 46], [45, 54], [46, 45], [46, 47], [47, 35], [47, 46], [47, 48], [48, 47], [48, 49], [49, 48], [49, 50], [49, 55], [50, 49], [50, 51], [51, 36], [51, 50], [52, 37], [52, 56], [53, 41], [53, 60], [54, 45], [54, 64], [55, 49], [55, 68], [56, 52], [56, 57], [57, 56], [57, 58], [58, 57], [58, 59], [58, 71], [59, 58], [59, 60], [60, 53], [60, 59], [60, 61], [61, 60], [61, 62], [62, 61], [62, 63], [62, 72], [63, 62], [63, 64], [64, 54], [64, 63], [64, 65], [65, 64], [65, 66], [66, 65], [66, 67], [66, 73], [67, 66], [67, 68], [68, 55], [68, 67], [68, 69], [69, 68], [69, 70], [70, 69], [70, 74], [71, 58], [71, 77], [72, 62], [72, 81], [73, 66], [73, 85], [74, 70], [74, 89], [75, 76], [75, 90], [76, 75], [76, 77], [77, 71], [77, 76], [77, 78], [78, 77], [78, 79], [79, 78], [79, 80], [79, 91], [80, 79], [80, 81], [81, 72], [81, 80], [81, 82], [82, 81], [82, 83], [83, 82], [83, 84], [83, 92], [84, 83], [84, 85], [85, 73], [85, 84], [85, 86], [86, 85], [86, 87], [87, 86], [87, 88], [87, 93], [88, 87], [88, 89], [89, 74], [89, 88], [90, 75], [90, 94], [91, 79], [91, 98], [92, 83], [92, 102], [93, 87], [93, 106], [94, 90], [94, 95], [95, 94], [95, 96], [96, 95], [96, 97], [96, 109], [97, 96], [97, 98], [98, 91], [98, 97], [98, 99], [99, 98], [99, 100], [100, 99], [100, 101], [100, 110], [101, 100], [101, 102], [102, 92], [102, 101], [102, 103], [103, 102], [103, 104], [104, 103], [104, 105], [104, 111], [105, 104], [105, 106], [106, 93], [106, 105], [106, 107], [107, 106], [107, 108], [108, 107], [108, 112], [109, 96], [110, 100], [110, 118], [111, 104], [111, 122], [112, 108], [112, 126], [113, 114], [114, 113], [114, 115], [115, 114], [115, 116], [116, 115], [116, 117], [117, 116], [117, 118], [118, 110], [118, 117], [118, 119], [119, 118], [119, 120], [120, 119], [120, 121], [121, 120], [121, 122], [122, 111], [122, 121], [122, 123], [123, 122], [123, 124], [124, 123], [124, 125], [125, 124], [125, 126], [126, 112], [126, 125]]
__rigetti_aspen_m_1_coupling_map = [(0, 1), (0, 103), (0, 7), (1, 16), (1, 2), (10, 11), (10, 113), (10, 17), (100, 101), (100, 107), (101, 102), (101, 116), (102, 103), (102, 115), (103, 104), (105, 106), (106, 107), (11, 12), (11, 26), (110, 111), (110, 117), (111, 112), (111, 126), (112, 113), (112, 125), (113, 114), (114, 115), (115, 116), (116, 117), (12, 13), (12, 25), (120, 121), (120, 127), (121, 122), (121, 136), (122, 123), (122, 135), (123, 124), (124, 125), (125, 126), (126, 127), (13, 14), (130, 131), (130, 137), (131, 132), (131, 146), (132, 133), (132, 145), (133, 134), (134, 135), (135, 136), (136, 137), (14, 15), (140, 141), (140, 147), (141, 142), (142, 143), (143, 144), (144, 145), (145, 146), (146, 147), (15, 16), (16, 17), (17, 114), (2, 15), (20, 123), (20, 21), (20, 27), (21, 22), (21, 36), (22, 23), (22, 35), (23, 24), (24, 25), (25, 26), (26, 27), (27, 124), (3, 4), (30, 133), (30, 31), (30, 37), (31, 32), (31, 46), (32, 33), (32, 45), (33, 34), (34, 35), (35, 36), (36, 37), (37, 134), (4, 5), (40, 143), (40, 41), (40, 47), (41, 42), (42, 43), (43, 44), (44, 45), (45, 46), (46, 47), (47, 144), (5, 6), (6, 7)]

#
#
#
#
# aspen_m_1_dict_specs = {
#   "braketSchemaHeader": {
#     "name": "braket.device_schema.rigetti.rigetti_provider_properties",
#     "version": "1"
#   },
#   "specs": {
#     "1Q": {
#       "0": {
#         "T1": 0.000019646323998978588,
#         "T2": 0.00003101787334872534,
#         "f1QRB": 0.9985669301541129,
#         "f1QRB_std_err": 0.0004092835114091019,
#         "f1Q_simultaneous_RB": 0.9974455736726459,
#         "f1Q_simultaneous_RB_std_err": 0.0002732084009138191,
#         "fActiveReset": 0.9975,
#         "fRO": 0.981
#       },
#       "1": {
#         "T1": 0.00029765217499133634,
#         "T2": 0.000007824067129096629,
#         "f1QRB": 0.9981823659437071,
#         "f1QRB_std_err": 0.0005329657288556576,
#         "f1Q_simultaneous_RB": 0.9881643563517251,
#         "f1Q_simultaneous_RB_std_err": 0.0016390992780561128,
#         "fActiveReset": 0.978,
#         "fRO": 0.875
#       },
#       "2": {
#         "T1": 0.000020973434416093895,
#         "T2": 0.000028838545223748203,
#         "f1QRB": 0.9965570461292947,
#         "f1QRB_std_err": 0.0004890350921266794,
#         "f1Q_simultaneous_RB": 0.9973660788877458,
#         "f1Q_simultaneous_RB_std_err": 0.00039704497988451884,
#         "fActiveReset": 0.995,
#         "fRO": 0.964
#       },
#       "3": {
#         "T1": 0.00007247924269626616,
#         "T2": 0.000029764829001654715,
#         "f1QRB": 0.9995,
#         "f1QRB_std_err": 0.001,
#         "f1Q_simultaneous_RB": 0.9986074547719821,
#         "f1Q_simultaneous_RB_std_err": 0.00023027235230065784,
#         "fActiveReset": 0.993,
#         "fRO": 0.948
#       },
#       "4": {
#         "T1": 0.000009478591782352552,
#         "T2": 0.000004806817051155559,
#         "f1QRB": 0.9923858720157849,
#         "f1QRB_std_err": 0.00024439249949140956,
#         "f1Q_simultaneous_RB": 0.9772895821911745,
#         "f1Q_simultaneous_RB_std_err": 0.0017235359304540302,
#         "fActiveReset": 0.9985,
#         "fRO": 0.9019999999999999
#       },
#       "5": {
#         "T1": 0.000022015055703317188,
#         "T2": 0.00004228408078452582,
#         "f1QRB": 0.9781148245291562,
#         "f1QRB_std_err": 0.004848444133672503,
#         "f1Q_simultaneous_RB": 0.9979286714471133,
#         "f1Q_simultaneous_RB_std_err": 0.00022608710447659725,
#         "fActiveReset": 0.998,
#         "fRO": 0.968
#       },
#       "6": {
#         "T1": 0.00001503507888434008,
#         "T2": 0.000026188631330216828,
#         "f1QRB": 0.9967029995207599,
#         "f1QRB_std_err": 0.0003552371997835362,
#         "f1Q_simultaneous_RB": 0.9978454781117014,
#         "f1Q_simultaneous_RB_std_err": 0.0002698681923614063,
#         "fActiveReset": 0.9995,
#         "fRO": 0.987
#       },
#       "7": {
#         "T1": 0.00007027707059137356,
#         "T2": 0.00001650773721346848,
#         "f1QRB": 0.9977338486663703,
#         "f1QRB_std_err": 0.00011794671873175128,
#         "f1Q_simultaneous_RB": 0.9860182926084821,
#         "f1Q_simultaneous_RB_std_err": 0.0011404403679687435,
#         "fActiveReset": 0.9995,
#         "fRO": 0.966
#       },
#       "10": {
#         "T1": 0.000018149876371609253,
#         "T2": 0.0000224135878659342,
#         "f1QRB": 0.9972871708055486,
#         "f1QRB_std_err": 0.00026244975727162686,
#         "f1Q_simultaneous_RB": 0.996828588675706,
#         "f1Q_simultaneous_RB_std_err": 0.00028483853350204456,
#         "fActiveReset": 0.951,
#         "fRO": 0.987
#       },
#       "11": {
#         "T1": 0.00005714632423314825,
#         "T2": 0.00007001552962088477,
#         "f1QRB": 0.991370933457359,
#         "f1QRB_std_err": 0.0014081734730062975,
#         "f1Q_simultaneous_RB": 0.9981967072807207,
#         "f1Q_simultaneous_RB_std_err": 0.0003600152061873542,
#         "fActiveReset": 0.996,
#         "fRO": 0.97
#       },
#       "12": {
#         "T1": 0.000028789424806774377,
#         "T2": 0.000010103932862256378,
#         "f1QRB": 0.9991227486932124,
#         "f1QRB_std_err": 0.00008975660334841619,
#         "f1Q_simultaneous_RB": 0.9976001180481953,
#         "f1Q_simultaneous_RB_std_err": 0.00020136173492813297,
#         "fActiveReset": 0.9985,
#         "fRO": 0.97
#       },
#       "13": {
#         "T1": 0.00009393253394662793,
#         "T2": 0.000008555463260854438,
#         "f1QRB": 0.995312817103458,
#         "f1QRB_std_err": 0.00011319337551723124,
#         "f1Q_simultaneous_RB": 0.9876193294406863,
#         "f1Q_simultaneous_RB_std_err": 0.00034203900952458103,
#         "fActiveReset": 0.9990000000000001,
#         "fRO": 0.9789999999999999
#       },
#       "14": {
#         "T1": 0.00004228899186675683,
#         "T2": 0.000050285340905820985,
#         "f1QRB": 0.9828523284589196,
#         "f1QRB_std_err": 0.0030240327182633926,
#         "f1Q_simultaneous_RB": 0.9982905510843952,
#         "f1Q_simultaneous_RB_std_err": 0.00014517216382602707,
#         "fActiveReset": 0.9995,
#         "fRO": 0.9689999999999999
#       },
#       "15": {
#         "T1": 0.000021605015003034467,
#         "T2": 0.000019278534326813695,
#         "f1QRB": 0.9986973311046958,
#         "f1QRB_std_err": 0.0004863021908146925,
#         "f1Q_simultaneous_RB": 0.9976873882649187,
#         "f1Q_simultaneous_RB_std_err": 0.0002840669200922086,
#         "fActiveReset": 0.9990000000000001,
#         "fRO": 0.9840000000000001
#       },
#       "16": {
#         "T1": 0.00003962450440009313,
#         "T2": 0.00004980622437913914,
#         "f1QRB": 0.9994735228583047,
#         "f1QRB_std_err": 0.00018921101815104192,
#         "f1Q_simultaneous_RB": 0.997256601065907,
#         "f1Q_simultaneous_RB_std_err": 0.00009910514330986505,
#         "fActiveReset": 0.9965,
#         "fRO": 0.993
#       },
#       "17": {
#         "T1": 0.00004412886976012942,
#         "T2": 0.00005891076293175497,
#         "f1QRB": 0.9989696410230016,
#         "f1QRB_std_err": 0.00029587767198649287,
#         "f1Q_simultaneous_RB": 0.9989842282812017,
#         "f1Q_simultaneous_RB_std_err": 0.0002958728405362475,
#         "fActiveReset": 0.9995,
#         "fRO": 0.973
#       },
#       "20": {
#         "T1": 0.000023601294355302116,
#         "T2": 0.000018636008029777868,
#         "f1QRB": 0.9048477267364443,
#         "f1QRB_std_err": 0.02621152329740977,
#         "f1Q_simultaneous_RB": 0.9967825300953553,
#         "f1Q_simultaneous_RB_std_err": 0.00027664545358632443,
#         "fActiveReset": 0.991,
#         "fRO": 0.966
#       },
#       "21": {
#         "T1": 0.000032261113644072026,
#         "T2": 0.00001649892294654465,
#         "f1QRB": 0.9930688409216346,
#         "f1QRB_std_err": 0.00840020339612702,
#         "f1Q_simultaneous_RB": 0.9974646439883973,
#         "f1Q_simultaneous_RB_std_err": 0.00028932039628789006,
#         "fActiveReset": 0.8965,
#         "fRO": 0.949
#       },
#       "22": {
#         "T1": 0.000013880395478560459,
#         "T2": 0.0000011945374836581608,
#         "f1QRB": 0.9893882635816784,
#         "f1QRB_std_err": 0.0008601709521286108,
#         "f1Q_simultaneous_RB": 0.9745612147072112,
#         "f1Q_simultaneous_RB_std_err": 0.0020249682947979116,
#         "fActiveReset": 0.964,
#         "fRO": 0.93
#       },
#       "23": {
#         "T1": 0.00002711906452823598,
#         "T2": 0.000012354806549584131,
#         "f1QRB": 0.9990895217827006,
#         "f1QRB_std_err": 0.0003523638665146971,
#         "f1Q_simultaneous_RB": 0.9985141865922711,
#         "f1Q_simultaneous_RB_std_err": 0.000629949993481523,
#         "fActiveReset": 0.9935,
#         "fRO": 0.9319999999999999
#       },
#       "24": {
#         "T1": 0.000051452081734737476,
#         "T2": 0.000019995381646173805,
#         "f1QRB": 0.9981295862815902,
#         "f1QRB_std_err": 0.0004141458064528873,
#         "f1Q_simultaneous_RB": 0.9983516564699932,
#         "f1Q_simultaneous_RB_std_err": 0.00016298567392959714,
#         "fActiveReset": 0.998,
#         "fRO": 0.987
#       },
#       "25": {
#         "T1": 0.000051674687296943134,
#         "T2": 0.00007863314268879422,
#         "f1QRB": 0.9986122224910698,
#         "f1QRB_std_err": 0.0005482977326738393,
#         "f1Q_simultaneous_RB": 0.995671150979901,
#         "f1Q_simultaneous_RB_std_err": 0.00007121466348511394,
#         "fActiveReset": 0.9975,
#         "fRO": 0.987
#       },
#       "26": {
#         "T1": 0.000020757167665585996,
#         "T2": 0.000029078546939967022,
#         "f1QRB": 0.9982985149824632,
#         "f1QRB_std_err": 0.00018323095698506166,
#         "f1Q_simultaneous_RB": 0.9950848897035992,
#         "f1Q_simultaneous_RB_std_err": 0.00016841633959682452,
#         "fActiveReset": 0.9895,
#         "fRO": 0.9840000000000001
#       },
#       "27": {
#         "T1": 0.000013317775324317438,
#         "T2": 0.000008016179288469908,
#         "f1QRB": 0.9994666831403609,
#         "f1QRB_std_err": 0.0002951657803055349,
#         "f1Q_simultaneous_RB": 0.9922115119533537,
#         "f1Q_simultaneous_RB_std_err": 0.00023553793424997756,
#         "fActiveReset": 0.991,
#         "fRO": 0.9510000000000001
#       },
#       "30": {
#         "T1": 0.00002863781907946894,
#         "T2": 0.00003858696208667374,
#         "f1QRB": 0.9980672511324596,
#         "f1QRB_std_err": 0.00019652280989344712,
#         "f1Q_simultaneous_RB": 0.997446674520883,
#         "f1Q_simultaneous_RB_std_err": 0.0002581519856354435,
#         "fActiveReset": 0.991,
#         "fRO": 0.924
#       },
#       "31": {
#         "T1": 0.00007371768765840336,
#         "T2": 0.00005755897056294106,
#         "f1QRB": 0.9986208281983529,
#         "f1QRB_std_err": 0.0005331879876766579,
#         "f1Q_simultaneous_RB": 0.9892095692092009,
#         "f1Q_simultaneous_RB_std_err": 0.0009386965013434565,
#         "fActiveReset": 0.995,
#         "fRO": 0.956
#       },
#       "32": {
#         "T1": 0.00002548274064251288,
#         "T2": 0.000025597100976728473,
#         "f1QRB": 0.9936781795902043,
#         "f1QRB_std_err": 0.000592298211885191,
#         "f1Q_simultaneous_RB": 0.9942866213018988,
#         "f1Q_simultaneous_RB_std_err": 0.0005084196453930158,
#         "fActiveReset": 0.996,
#         "fRO": 0.944
#       },
#       "33": {
#         "T1": 0.000012634358486085517,
#         "T2": 0.000007187205899605385,
#         "f1QRB": 0.9939119711901402,
#         "f1QRB_std_err": 0.00042150445057843975,
#         "f1Q_simultaneous_RB": 0.9912420372806836,
#         "f1Q_simultaneous_RB_std_err": 0.0004450352346539071,
#         "fActiveReset": 0.9990000000000001,
#         "fRO": 0.975
#       },
#       "34": {
#         "T1": 0.000039269017093612746,
#         "T2": 0.000004774079263101018,
#         "f1QRB": 0.9990216324800094,
#         "f1QRB_std_err": 0.00023976547231512762,
#         "f1Q_simultaneous_RB": 0.9919613098713889,
#         "f1Q_simultaneous_RB_std_err": 0.0002394429252761076,
#         "fActiveReset": 0.9975,
#         "fRO": 0.9510000000000001
#       },
#       "35": {
#         "T1": 0.000035698818804164034,
#         "T2": 0.00003211848163318965,
#         "f1QRB": 0.9988960386393323,
#         "f1QRB_std_err": 0.0004093656504796565,
#         "f1Q_simultaneous_RB": 0.998164194031893,
#         "f1Q_simultaneous_RB_std_err": 0.00015582481523267666,
#         "fActiveReset": 0.997,
#         "fRO": 0.986
#       },
#       "36": {
#         "T1": 0.000038154909014709304,
#         "T2": 0.000023861520456714602,
#         "f1QRB": 0.9936782027257146,
#         "f1QRB_std_err": 0.0006060933990219555,
#         "f1Q_simultaneous_RB": 0.9489761151705565,
#         "f1Q_simultaneous_RB_std_err": 0.005303788983187187,
#         "fActiveReset": 0.9704999999999999,
#         "fRO": 0.8960000000000001
#       },
#       "37": {
#         "T1": 0.000026693471818717285,
#         "T2": 0.00002236684521574554,
#         "f1QRB": 0.9981856144714789,
#         "f1QRB_std_err": 0.0003192246425017005,
#         "f1Q_simultaneous_RB": 0.997925710792774,
#         "f1Q_simultaneous_RB_std_err": 0.0002167260968053652,
#         "fActiveReset": 0.9995,
#         "fRO": 0.987
#       },
#       "40": {
#         "T1": 0.00003712030358138385,
#         "T2": 0.000031267935194694726,
#         "f1QRB": 0.998793863435051,
#         "f1QRB_std_err": 0.00008464923664565378,
#         "f1Q_simultaneous_RB": 0.9931769174271469,
#         "f1Q_simultaneous_RB_std_err": 0.00028658451508838,
#         "fActiveReset": 0.9845,
#         "fRO": 0.968
#       },
#       "41": {
#         "T1": 0.000020155142119726577,
#         "T2": 0.000013125593246219873,
#         "f1QRB": 0.9991516622963384,
#         "f1QRB_std_err": 0.00012818205884081887,
#         "f1Q_simultaneous_RB": 0.998447714201831,
#         "f1Q_simultaneous_RB_std_err": 0.00015460354513663335,
#         "fActiveReset": 0.9965,
#         "fRO": 0.985
#       },
#       "42": {
#         "T1": 0.000041528630948972634,
#         "T2": 0.0000451195626487103,
#         "f1QRB": 0.9976369874123826,
#         "f1QRB_std_err": 0.00017755475392954953,
#         "f1Q_simultaneous_RB": 0.9983850674694768,
#         "f1Q_simultaneous_RB_std_err": 0.0001300736677688277,
#         "fActiveReset": 0.9985,
#         "fRO": 0.982
#       },
#       "43": {
#         "T1": 0.000009870894633889904,
#         "T2": 0.00000837458289109483,
#         "f1QRB": 0.9964424390848596,
#         "f1QRB_std_err": 0.0003394521508666461,
#         "f1Q_simultaneous_RB": 0.9929833600645694,
#         "f1Q_simultaneous_RB_std_err": 0.00020983197713435951,
#         "fActiveReset": 0.9955000000000002,
#         "fRO": 0.9670000000000001
#       },
#       "44": {
#         "T1": 0.0000035127778468257986,
#         "T2": 0.000002256433838699275,
#         "f1QRB": 0.991506649544108,
#         "f1QRB_std_err": 0.0003956601631836801,
#         "f1Q_simultaneous_RB": 0.9823699638002212,
#         "f1Q_simultaneous_RB_std_err": 0.0010523316379679893,
#         "fActiveReset": 0.9685000000000001,
#         "fRO": 0.9530000000000001
#       },
#       "45": {
#         "T1": 0.00002157837913929761,
#         "T2": 0.000029038211203478625,
#         "f1QRB": 0.9988101863592861,
#         "f1QRB_std_err": 0.0002341343328876186,
#         "f1Q_simultaneous_RB": 0.9626444571933943,
#         "f1Q_simultaneous_RB_std_err": 0.00432096112148708,
#         "fActiveReset": 0.9990000000000001,
#         "fRO": 0.94
#       },
#       "46": {
#         "T1": 0.0000586905893922296,
#         "T2": 0.00001338575324050609,
#         "f1QRB": 0.99668451200255,
#         "f1QRB_std_err": 0.00010264313436570575,
#         "f1Q_simultaneous_RB": 0.9533889546754801,
#         "f1Q_simultaneous_RB_std_err": 0.005664863810721469,
#         "fActiveReset": 0.9965,
#         "fRO": 0.909
#       },
#       "47": {
#         "T1": 0.000029499697045354267,
#         "T2": 0.000007476657849951612,
#         "f1QRB": 0.9984971657040118,
#         "f1QRB_std_err": 0.0001362610076405577,
#         "f1Q_simultaneous_RB": 0.9556411395865685,
#         "f1Q_simultaneous_RB_std_err": 0.008265726259416661,
#         "fActiveReset": 0.995,
#         "fRO": 0.97
#       },
#       "100": {
#         "T1": 0.00002786814194255527,
#         "T2": 0.000032827677584981385,
#         "f1QRB": 0.9983267619945417,
#         "f1QRB_std_err": 0.00013245412597755253,
#         "f1Q_simultaneous_RB": 0.997537530537315,
#         "f1Q_simultaneous_RB_std_err": 0.00018730437566902205,
#         "fActiveReset": 0.9990000000000001,
#         "fRO": 0.975
#       },
#       "101": {
#         "T1": 0.000046554901348860867,
#         "T2": 0.00003847109666021761,
#         "f1QRB": 0.9970137500023071,
#         "f1QRB_std_err": 0.00018350751877424857,
#         "f1Q_simultaneous_RB": 0.9932025637503908,
#         "f1Q_simultaneous_RB_std_err": 0.00011479550757505214,
#         "fActiveReset": 0.96,
#         "fRO": 0.992
#       },
#       "102": {
#         "T1": 0.000060677796061003875,
#         "T2": 0.00002371205092254403,
#         "f1QRB": 0.9223864336705296,
#         "f1QRB_std_err": 0.010027655060148325,
#         "f1Q_simultaneous_RB": 0.9972254358419087,
#         "f1Q_simultaneous_RB_std_err": 0.000224396029637908,
#         "fActiveReset": 0.9905000000000002,
#         "fRO": 0.983
#       },
#       "103": {
#         "T1": 0.00006402224420742897,
#         "T2": 0.0000467003103961811,
#         "f1QRB": 0.952524280690339,
#         "f1QRB_std_err": 0.03503890765241047,
#         "f1Q_simultaneous_RB": 0.9988016862304449,
#         "f1Q_simultaneous_RB_std_err": 0.00016888385205313417,
#         "fActiveReset": 0.9945,
#         "fRO": 0.9890000000000001
#       },
#       "104": {
#         "T1": 0.0000030620486337618047,
#         "T2": 0.000002748606695607821,
#         "f1QRB": 0.9856104605451634,
#         "f1QRB_std_err": 0.0037192754378516293,
#         "f1Q_simultaneous_RB": 0.9857627660467868,
#         "f1Q_simultaneous_RB_std_err": 0.001281529535906844,
#         "fActiveReset": 0.982,
#         "fRO": 0.8680000000000001
#       },
#       "105": {
#         "T1": 0.000028655878858474537,
#         "T2": 0.000028821826513032627,
#         "f1QRB": 0.9974519072969024,
#         "f1QRB_std_err": 0.000097163491742933,
#         "f1Q_simultaneous_RB": 0.9975514994208449,
#         "f1Q_simultaneous_RB_std_err": 0.00041249872928438805,
#         "fActiveReset": 0.9990000000000001,
#         "fRO": 0.986
#       },
#       "106": {
#         "T1": 0.000026298832720650367,
#         "T2": 0.00001425355163954987,
#         "f1QRB": 0.9987320007114223,
#         "f1QRB_std_err": 0.0002161079812468806,
#         "f1Q_simultaneous_RB": 0.9949815899839988,
#         "f1Q_simultaneous_RB_std_err": 0.00029560245764919237,
#         "fActiveReset": 0.988,
#         "fRO": 0.966
#       },
#       "107": {
#         "T1": 0.0000018833559480846418,
#         "T2": 0.00001749664221159139,
#         "f1QRB": 0.9974908421927973,
#         "f1QRB_std_err": 0.0003433316861430358,
#         "f1Q_simultaneous_RB": 0.9974696524345704,
#         "f1Q_simultaneous_RB_std_err": 0.00015873784571424383,
#         "fActiveReset": 0.9975,
#         "fRO": 0.995
#       },
#       "110": {
#         "T1": 0.00004082769981450518,
#         "T2": 0.000055594597556333154,
#         "f1QRB": 0.9988177700197205,
#         "f1QRB_std_err": 0.00029078087565488387,
#         "f1Q_simultaneous_RB": 0.9975038781480139,
#         "f1Q_simultaneous_RB_std_err": 0.00044218831258908866,
#         "fActiveReset": 0.9990000000000001,
#         "fRO": 0.9519999999999998
#       },
#       "111": {
#         "T1": 0.000043259805299955545,
#         "T2": 0.000028757601060106715,
#         "f1QRB": 0.7808915294130563,
#         "f1QRB_std_err": 0.45322728152014735,
#         "f1Q_simultaneous_RB": 0.9982788088965,
#         "f1Q_simultaneous_RB_std_err": 0.00030376566482440283,
#         "fActiveReset": 0.9465,
#         "fRO": 0.965
#       },
#       "112": {
#         "T1": 0.0000371520772228795,
#         "T2": 0.00003815050100677042,
#         "f1QRB": 0.9980570113248138,
#         "f1QRB_std_err": 0.00012846903884968446,
#         "f1Q_simultaneous_RB": 0.996422875319473,
#         "f1Q_simultaneous_RB_std_err": 0.000516349809227836,
#         "fActiveReset": 0.9965,
#         "fRO": 0.9739999999999999
#       },
#       "113": {
#         "T1": 0.000037275015002169454,
#         "T2": 0.00003057772019105291,
#         "f1QRB": 0.9985685357729734,
#         "f1QRB_std_err": 0.0003845551897913834,
#         "f1Q_simultaneous_RB": 0.9935563046038545,
#         "f1Q_simultaneous_RB_std_err": 0.0005980336940628701,
#         "fActiveReset": 0.998,
#         "fRO": 0.981
#       },
#       "114": {
#         "T1": 0.0000139829240930478,
#         "T2": 0.000012985951435479027,
#         "f1QRB": 0.9981222300515986,
#         "f1QRB_std_err": 0.0001474410774602763,
#         "f1Q_simultaneous_RB": 0.9948881562251966,
#         "f1Q_simultaneous_RB_std_err": 0.0009328220370621517,
#         "fActiveReset": 0.9990000000000001,
#         "fRO": 0.972
#       },
#       "115": {
#         "T1": 0.00007880781266766945,
#         "T2": 0.00004540467119316242,
#         "f1QRB": 0.962085506055663,
#         "f1QRB_std_err": 0.0046718537459249,
#         "f1Q_simultaneous_RB": 0.9980418526764068,
#         "f1Q_simultaneous_RB_std_err": 0.0006158080185654563,
#         "fActiveReset": 0.9990000000000001,
#         "fRO": 0.966
#       },
#       "116": {
#         "T1": 0.000010036304881833047,
#         "T2": 0.00004388777446758693,
#         "f1QRB": 0.9987742270418412,
#         "f1QRB_std_err": 0.0000950911137246889,
#         "f1Q_simultaneous_RB": 0.9965828595073829,
#         "f1Q_simultaneous_RB_std_err": 0.0007611812862671149,
#         "fActiveReset": 0.9995,
#         "fRO": 0.973
#       },
#       "117": {
#         "T1": 0.00002350214063917555,
#         "T2": 0.000008727367469956327,
#         "f1QRB": 0.961552247006636,
#         "f1QRB_std_err": 0.004673188459792453,
#         "f1Q_simultaneous_RB": 0.9741651169890307,
#         "f1Q_simultaneous_RB_std_err": 0.0031598846191826183,
#         "fActiveReset": 0.958,
#         "fRO": 0.964
#       },
#       "120": {
#         "T1": 0.00003748911059497928,
#         "T2": 0.00004887764101753125,
#         "f1QRB": 0.9979931685659458,
#         "f1QRB_std_err": 0.0002528318058781427,
#         "f1Q_simultaneous_RB": 0.9978002451139036,
#         "f1Q_simultaneous_RB_std_err": 0.0001566684039810393,
#         "fActiveReset": 0.9875,
#         "fRO": 0.919
#       },
#       "121": {
#         "T1": 0.000028959624987612287,
#         "T2": 0.000038221681014652255,
#         "f1QRB": 0.9989741773965328,
#         "f1QRB_std_err": 0.000090048673264869,
#         "f1Q_simultaneous_RB": 0.994925438238431,
#         "f1Q_simultaneous_RB_std_err": 0.0002420686635802564,
#         "fActiveReset": 0.98,
#         "fRO": 0.9620000000000001
#       },
#       "122": {
#         "T1": 0.000025260932182025186,
#         "T2": 0.000023529249512154,
#         "f1QRB": 0.9985841120211902,
#         "f1QRB_std_err": 0.00007349310537613475,
#         "f1Q_simultaneous_RB": 0.9976308806993643,
#         "f1Q_simultaneous_RB_std_err": 0.00014866122481643553,
#         "fActiveReset": 0.9955000000000002,
#         "fRO": 0.975
#       },
#       "123": {
#         "T1": 0.000052041086110232726,
#         "T2": 0.00003407848840235797,
#         "f1QRB": 0.999379923468011,
#         "f1QRB_std_err": 0.00016206201337674154,
#         "f1Q_simultaneous_RB": 0.9978077171762303,
#         "f1Q_simultaneous_RB_std_err": 0.00039866133517265837,
#         "fActiveReset": 0.998,
#         "fRO": 0.95
#       },
#       "124": {
#         "T1": 0.00002812542069263735,
#         "T2": 0.00000863639081220663,
#         "f1QRB": 0.998991664466877,
#         "f1QRB_std_err": 0.00020624429964102278,
#         "f1Q_simultaneous_RB": 0.9976941092676845,
#         "f1Q_simultaneous_RB_std_err": 0.00013358283552342823,
#         "fActiveReset": 0.9975,
#         "fRO": 0.987
#       },
#       "125": {
#         "T1": 0.000016667747052112603,
#         "T2": 0.00001106906311481597,
#         "f1QRB": 0.9994008055237724,
#         "f1QRB_std_err": 0.000644758971384886,
#         "f1Q_simultaneous_RB": 0.9907316846719836,
#         "f1Q_simultaneous_RB_std_err": 0.00044717365468667915,
#         "fActiveReset": 0.99,
#         "fRO": 0.9670000000000001
#       },
#       "126": {
#         "T1": 0.00002261778351231314,
#         "T2": 0.00000951161067095876,
#         "f1QRB": 0.9981033574342519,
#         "f1QRB_std_err": 0.00013395046643754937,
#         "f1Q_simultaneous_RB": 0.9967324303790965,
#         "f1Q_simultaneous_RB_std_err": 0.00018600605236030818,
#         "fActiveReset": 0.9990000000000001,
#         "fRO": 0.944
#       },
#       "127": {
#         "T1": 0.000008193410413248614,
#         "T2": 0.00001037634677390102,
#         "f1QRB": 0.9738364450123013,
#         "f1QRB_std_err": 0.009366824626477116,
#         "f1Q_simultaneous_RB": 0.9906378506686263,
#         "f1Q_simultaneous_RB_std_err": 0.0006454167408322341,
#         "fActiveReset": 0.986,
#         "fRO": 0.96
#       },
#       "130": {
#         "T1": 0.000010649256023009812,
#         "T2": 0.00000887650662574256,
#         "f1QRB": 0.9968422133887005,
#         "f1QRB_std_err": 0.00010895560584175077,
#         "f1Q_simultaneous_RB": 0.9952263396109058,
#         "f1Q_simultaneous_RB_std_err": 0.00022956118308232632,
#         "fActiveReset": 0.997,
#         "fRO": 0.975
#       },
#       "131": {
#         "T1": 0.00006578836755233297,
#         "T2": 0.00007057403797006593,
#         "f1QRB": 0.9992499196476688,
#         "f1QRB_std_err": 0.00025075218085488074,
#         "f1Q_simultaneous_RB": 0.9977671596276406,
#         "f1Q_simultaneous_RB_std_err": 0.00021852032007840173,
#         "fActiveReset": 0.9990000000000001,
#         "fRO": 0.981
#       },
#       "132": {
#         "T1": 0.000036004231834585454,
#         "T2": 0.000019112003219211172,
#         "f1QRB": 0.9958825370286079,
#         "f1QRB_std_err": 0.0001585428425166147,
#         "f1Q_simultaneous_RB": 0.9980609824206017,
#         "f1Q_simultaneous_RB_std_err": 0.00021297421675573906,
#         "fActiveReset": 0.9990000000000001,
#         "fRO": 0.97
#       },
#       "133": {
#         "T1": 0.00005872751747770799,
#         "T2": 0.00003118143439533471,
#         "f1QRB": 0.999206730664677,
#         "f1QRB_std_err": 0.00017732498453173362,
#         "f1Q_simultaneous_RB": 0.9983286206754388,
#         "f1Q_simultaneous_RB_std_err": 0.0002776916878331608,
#         "fActiveReset": 0.9955000000000002,
#         "fRO": 0.968
#       },
#       "134": {
#         "T1": 0.000037538550042182095,
#         "T2": 0.00002252183290359099,
#         "f1QRB": 0.9994757237619826,
#         "f1QRB_std_err": 0.00014062281625659028,
#         "f1Q_simultaneous_RB": 0.9985597351158563,
#         "f1Q_simultaneous_RB_std_err": 0.0004854173843619419,
#         "fActiveReset": 0.9995,
#         "fRO": 0.98
#       },
#       "135": {
#         "T1": 0.00003874113617730046,
#         "T2": 0.000006103128655678081,
#         "f1QRB": 0.9460232413099076,
#         "f1QRB_std_err": 0.002651100207132977,
#         "f1Q_simultaneous_RB": 0.9706729736997066,
#         "f1Q_simultaneous_RB_std_err": 0.0022503888747544,
#         "fActiveReset": 0.9995,
#         "fRO": 0.9739999999999999
#       },
#       "136": {
#         "T1": 0.000008843167962568899,
#         "T2": 0.000009300410168462931,
#         "f1QRB": 0.9983768322573878,
#         "f1QRB_std_err": 0.00008363796137084942,
#         "f1Q_simultaneous_RB": 0.9743477781901287,
#         "f1Q_simultaneous_RB_std_err": 0.004252029239076787,
#         "fActiveReset": 0.917,
#         "fRO": 0.97
#       },
#       "137": {
#         "T1": 0.000031788572928181935,
#         "T2": 0.000014888569011161774,
#         "f1QRB": 0.9989788316390569,
#         "f1QRB_std_err": 0.00011355609427364718,
#         "f1Q_simultaneous_RB": 0.9966911280394577,
#         "f1Q_simultaneous_RB_std_err": 0.0005844431602624138,
#         "fActiveReset": 0.998,
#         "fRO": 0.9239999999999999
#       },
#       "140": {
#         "T1": 0.000013382444568721397,
#         "T2": 0.000006661036059682376,
#         "f1QRB": 0.9958364339851258,
#         "f1QRB_std_err": 0.00014673610272204377,
#         "f1Q_simultaneous_RB": 0.9914334608096256,
#         "f1Q_simultaneous_RB_std_err": 0.00035653205289417467,
#         "fActiveReset": 0.9885,
#         "fRO": 0.965
#       },
#       "141": {
#         "T1": 0.00006593426554313275,
#         "T2": 0.00004539431994149328,
#         "f1QRB": 0.9978061637346046,
#         "f1QRB_std_err": 0.0004527652923353465,
#         "f1Q_simultaneous_RB": 0.9972333928804544,
#         "f1Q_simultaneous_RB_std_err": 0.00016024501614867912,
#         "fActiveReset": 0.9995,
#         "fRO": 0.99
#       },
#       "142": {
#         "T1": 0.000016023202643156154,
#         "T2": 0.000016900620689453825,
#         "f1QRB": 0.9960589009089673,
#         "f1QRB_std_err": 0.00044847086952288606,
#         "f1Q_simultaneous_RB": 0.980458303433432,
#         "f1Q_simultaneous_RB_std_err": 0.0014705625330331566,
#         "fActiveReset": 0.981,
#         "fRO": 0.9490000000000001
#       },
#       "143": {
#         "T1": 0.00005858375510969793,
#         "T2": 0.000008045719885932893,
#         "f1QRB": 0.9953651783528372,
#         "f1QRB_std_err": 0.0003691188929983052,
#         "f1Q_simultaneous_RB": 0.9970353845895664,
#         "f1Q_simultaneous_RB_std_err": 0.0002110971274147628,
#         "fActiveReset": 0.9955000000000002,
#         "fRO": 0.9739999999999999
#       },
#       "144": {
#         "T1": 0.000004429699463681658,
#         "T2": 0.000007359978193070336,
#         "f1QRB": 0.9934248182574081,
#         "f1QRB_std_err": 0.0003778643070026194,
#         "f1Q_simultaneous_RB": 0.9895573055923702,
#         "f1Q_simultaneous_RB_std_err": 0.00043815163379004677,
#         "fActiveReset": 0.9925,
#         "fRO": 0.968
#       },
#       "145": {
#         "T1": 0.00003333456558807235,
#         "T2": 0.000016654423608235014,
#         "f1QRB": 0.9972883010896755,
#         "f1QRB_std_err": 0.00018318701459170512,
#         "f1Q_simultaneous_RB": 0.9976809919049097,
#         "f1Q_simultaneous_RB_std_err": 0.000189833217634097,
#         "fActiveReset": 0.9990000000000001,
#         "fRO": 0.983
#       },
#       "146": {
#         "T1": 0.00003637835889391816,
#         "T2": 0.00003817873920836466,
#         "f1QRB": 0.9936420408338698,
#         "f1QRB_std_err": 0.0003424517857229046,
#         "f1Q_simultaneous_RB": 0.9987054157572863,
#         "f1Q_simultaneous_RB_std_err": 0.00008377503151661105,
#         "fActiveReset": 0.9995,
#         "fRO": 0.97
#       },
#       "147": {
#         "T1": 0.000022187887742219914,
#         "T2": 0.000015432059648586513,
#         "f1QRB": 0.9941732766863549,
#         "f1QRB_std_err": 0.0004010534266169523,
#         "f1Q_simultaneous_RB": 0.9942685436383251,
#         "f1Q_simultaneous_RB_std_err": 0.0002787004786255648,
#         "fActiveReset": 0.9995,
#         "fRO": 0.9840000000000001
#       }
#     },
#     "2Q": {
#       "0-1": {
#         "fCPHASE": 0.8977502956762041,
#         "fCPHASE_std_err": 0.006325328311692047,
#         "fCZ": 0.9198494040820251,
#         "fCZ_std_err": 0.011555591364656942,
#         "fXY": 0.843455759140691,
#         "fXY_std_err": 0.012904572309213571
#       },
#       "0-103": {
#         "fCPHASE": 0.95,
#         "fCPHASE_std_err": 0.01,
#         "fCZ": 0.970826155158194,
#         "fCZ_std_err": 0.007580832350024377,
#         "fXY": 0.966499243714615,
#         "fXY_std_err": 0.012681961838658183
#       },
#       "0-7": {
#         "fCPHASE": 0.878447853842411,
#         "fCPHASE_std_err": 0.004853866832488396,
#         "fCZ": 0.8800651018724256,
#         "fCZ_std_err": 0.005445130840429071,
#         "fXY": 0.9799866165594486,
#         "fXY_std_err": 0.0048133638383464124
#       },
#       "1-16": {
#         "fCPHASE": 0.7454591987427932,
#         "fCPHASE_std_err": 0.024427817003304205,
#         "fCZ": 0.9714729815249885,
#         "fCZ_std_err": 0.00532502199000443,
#         "fXY": 0.9865640926114022,
#         "fXY_std_err": 0.006252439752104388
#       },
#       "1-2": {
#         "fCPHASE": 0.8537202780507162,
#         "fCPHASE_std_err": 0.007696045114745687,
#         "fCZ": 0.8643158065810859,
#         "fCZ_std_err": 0.007993362236818107
#       },
#       "10-11": {
#         "fCPHASE": 0.9761083189016362,
#         "fCPHASE_std_err": 0.003313268824534835,
#         "fCZ": 0.9936820149129786,
#         "fCZ_std_err": 0.004192359941822202,
#         "fXY": 0.9912590073550851,
#         "fXY_std_err": 0.00378255202148357
#       },
#       "10-113": {
#         "fCPHASE": 0.95,
#         "fCPHASE_std_err": 0.0063378127110447465,
#         "fCZ": 0.9589994261912663,
#         "fCZ_std_err": 0.008889484041348627,
#         "fXY": 0.9576935094191638,
#         "fXY_std_err": 0.00983703213805024
#       },
#       "10-17": {
#         "fCPHASE": 0.9728623561128926,
#         "fCPHASE_std_err": 0.00442955877279954,
#         "fCZ": 0.9844992558296992,
#         "fCZ_std_err": 0.004795259006723922,
#         "fXY": 0.9812509808603386,
#         "fXY_std_err": 0.006753103554023112
#       },
#       "100-101": {
#         "fCPHASE": 0.9669200409572855,
#         "fCPHASE_std_err": 0.007346392367540571,
#         "fCZ": 0.9467888036424585,
#         "fCZ_std_err": 0.008642090719867048,
#         "fXY": 0.9575226139763866,
#         "fXY_std_err": 0.008067107317861002
#       },
#       "100-107": {
#         "fCPHASE": 0.9386035478755804,
#         "fCPHASE_std_err": 0.010229676283098716,
#         "fCZ": 0.933826081054606,
#         "fCZ_std_err": 0.012385561673300525,
#         "fXY": 0.9765651318286701,
#         "fXY_std_err": 0.004066427078415164
#       },
#       "101-102": {
#         "fCPHASE": 0.8357888931043527,
#         "fCPHASE_std_err": 0.014214935149609835,
#         "fCZ": 0.8296852511923425,
#         "fCZ_std_err": 0.013685968519269322,
#         "fXY": 0.8045372185140351,
#         "fXY_std_err": 0.014596843093108568
#       },
#       "101-116": {
#         "fCPHASE": 0.8122084618300431,
#         "fCPHASE_std_err": 0.014226343467388549,
#         "fCZ": 0.8283059396621801,
#         "fCZ_std_err": 0.018670103462164165,
#         "fXY": 0.9704165782857462,
#         "fXY_std_err": 0.004795061458237962
#       },
#       "102-103": {
#         "fCPHASE": 0.9420994203071639,
#         "fCPHASE_std_err": 0.010094755237690798,
#         "fCZ": 0.9543607859360043,
#         "fCZ_std_err": 0.006359360398720804,
#         "fXY": 0.8815907377352875,
#         "fXY_std_err": 0.005400006719254658
#       },
#       "102-115": {
#         "fCPHASE": 0.7496632486188287,
#         "fCPHASE_std_err": 0.01218945861512367,
#         "fCZ": 0.9059121438770057,
#         "fCZ_std_err": 0.019949429789151506,
#         "fXY": 0.7972775765111723,
#         "fXY_std_err": 0.012740922364834949
#       },
#       "103-104": {
#         "fCPHASE": 0.776983637904652,
#         "fCPHASE_std_err": 0.017103041687594835,
#         "fCZ": 0.8116550492617111,
#         "fCZ_std_err": 0.013576936484543538,
#         "fXY": 0.8316099501645001,
#         "fXY_std_err": 0.011568727029934202
#       },
#       "105-106": {
#         "fCPHASE": 0.8248413652611568,
#         "fCPHASE_std_err": 0.009993436562014676,
#         "fCZ": 0.8859770877754197,
#         "fCZ_std_err": 0.006220375603220849,
#         "fXY": 0.8957082029101098,
#         "fXY_std_err": 0.004539894943482403
#       },
#       "106-107": {
#         "fCPHASE": 0.8763158347549314,
#         "fCPHASE_std_err": 0.006432264483364783,
#         "fCZ": 0.9638684980815065,
#         "fCZ_std_err": 0.009581392948442834
#       },
#       "11-12": {
#         "fCPHASE": 0.8068077005951636,
#         "fCPHASE_std_err": 0.010677360106421254,
#         "fCZ": 0.9549964322157917,
#         "fCZ_std_err": 0.007534965746236689,
#         "fXY": 0.9076234490665841,
#         "fXY_std_err": 0.0035844278316906784
#       },
#       "11-26": {
#         "fCPHASE": 0.8288302047966951,
#         "fCPHASE_std_err": 0.010896187543582014,
#         "fCZ": 0.9592517185227968,
#         "fCZ_std_err": 0.006391823847697566,
#         "fXY": 0.8558818596861671,
#         "fXY_std_err": 0.006251619812933073
#       },
#       "110-111": {
#         "fCPHASE": 0.9659219220864006,
#         "fCPHASE_std_err": 0.004323939966976367,
#         "fCZ": 0.9837908211844106,
#         "fCZ_std_err": 0.0032678608935356457,
#         "fXY": 0.9878012646965745,
#         "fXY_std_err": 0.003566960386898927
#       },
#       "110-117": {
#         "fCPHASE": 0.898883228678898,
#         "fCPHASE_std_err": 0.005786145945461976,
#         "fCZ": 0.9411234251215965,
#         "fCZ_std_err": 0.009634972828599122,
#         "fXY": 0.88431622864547,
#         "fXY_std_err": 0.00649801364603991
#       },
#       "111-112": {
#         "fCPHASE": 0.9754888593207722,
#         "fCPHASE_std_err": 0.006152304693544482,
#         "fCZ": 0.9880767220019072,
#         "fCZ_std_err": 0.0026086810551386357,
#         "fXY": 0.9704778014858377,
#         "fXY_std_err": 0.003986608664416076
#       },
#       "111-126": {
#         "fCPHASE": 0.9040593053647187,
#         "fCPHASE_std_err": 0.004620936380577603,
#         "fCZ": 0.8805538627783442,
#         "fCZ_std_err": 0.007282013685540161,
#         "fXY": 0.7381246023543037,
#         "fXY_std_err": 0.009504069586797712
#       },
#       "112-113": {
#         "fCPHASE": 0.9626569518122433,
#         "fCPHASE_std_err": 0.00730316526438217,
#         "fCZ": 0.9869947607862162,
#         "fCZ_std_err": 0.003050870608314724,
#         "fXY": 0.9563641701956116,
#         "fXY_std_err": 0.005669242441748331
#       },
#       "112-125": {
#         "fCPHASE": 0.975309224953574,
#         "fCPHASE_std_err": 0.0064321561158222455,
#         "fCZ": 0.9555563474589919,
#         "fCZ_std_err": 0.006911906940517377,
#         "fXY": 0.952755679515433,
#         "fXY_std_err": 0.006950823842104388
#       },
#       "113-114": {
#         "fCPHASE": 0.9680795985598486,
#         "fCPHASE_std_err": 0.007598082533888311,
#         "fCZ": 0.9634273694481714,
#         "fCZ_std_err": 0.00794820709577192,
#         "fXY": 0.9826177392195397,
#         "fXY_std_err": 0.0037539685910055183
#       },
#       "114-115": {
#         "fCPHASE": 0.8633166182489631,
#         "fCPHASE_std_err": 0.012062641503925178,
#         "fCZ": 0.9033905067223743,
#         "fCZ_std_err": 0.016197531253486615,
#         "fXY": 0.9816866119923471,
#         "fXY_std_err": 0.005816391327133585
#       },
#       "115-116": {
#         "fCPHASE": 0.8965653521478818,
#         "fCPHASE_std_err": 0.006931848624434989,
#         "fCZ": 0.7258647353297285,
#         "fCZ_std_err": 0.024617495727503012,
#         "fXY": 0.8739757546064161,
#         "fXY_std_err": 0.005215772877687906
#       },
#       "116-117": {
#         "fCPHASE": 0.900332261730584,
#         "fCPHASE_std_err": 0.0044178678751386645,
#         "fCZ": 0.8982635345478631,
#         "fCZ_std_err": 0.0059297346175183376,
#         "fXY": 0.8653026482743402,
#         "fXY_std_err": 0.007912267562602361
#       },
#       "12-13": {
#         "fCPHASE": 0.8116573878272262,
#         "fCPHASE_std_err": 0.01173615505651156,
#         "fCZ": 0.8305247570575393,
#         "fCZ_std_err": 0.011569950916885403,
#         "fXY": 0.8775750159805027,
#         "fXY_std_err": 0.0066971600048546165
#       },
#       "12-25": {
#         "fCPHASE": 0.8442453269101953,
#         "fCPHASE_std_err": 0.00993431315474608,
#         "fCZ": 0.8015193736677084,
#         "fCZ_std_err": 0.011918860661733055,
#         "fXY": 0.900475582245461,
#         "fXY_std_err": 0.00358998001830533
#       },
#       "120-121": {
#         "fCPHASE": 0.9755039289342488,
#         "fCPHASE_std_err": 0.005430071632963102,
#         "fCZ": 0.9809984250479121,
#         "fCZ_std_err": 0.0031504192293250657,
#         "fXY": 0.9714484620041965,
#         "fXY_std_err": 0.00466303695771225
#       },
#       "120-127": {
#         "fCPHASE": 0.8662181572933172,
#         "fCPHASE_std_err": 0.0075188312176281665,
#         "fCZ": 0.7953467493051762,
#         "fCZ_std_err": 0.015765869413099494,
#         "fXY": 0.9712728601240833,
#         "fXY_std_err": 0.007418029478219076
#       },
#       "121-122": {
#         "fCPHASE": 0.9188857229167463,
#         "fCPHASE_std_err": 0.011851795576056248,
#         "fCZ": 0.9522094475012755,
#         "fCZ_std_err": 0.010625436411130855,
#         "fXY": 0.9688620559646282,
#         "fXY_std_err": 0.004722677012775054
#       },
#       "121-136": {
#         "fCPHASE": 0.8055715072921958,
#         "fCPHASE_std_err": 0.010860707248101295,
#         "fCZ": 0.8899326563177948,
#         "fCZ_std_err": 0.007956575807093776,
#         "fXY": 0.9763823776769089,
#         "fXY_std_err": 0.0054777837732819905
#       },
#       "122-123": {
#         "fCPHASE": 0.8947400815782213,
#         "fCPHASE_std_err": 0.007642759503025508,
#         "fCZ": 0.9762047007091224,
#         "fCZ_std_err": 0.0034927024863839144,
#         "fXY": 0.9843509679072869,
#         "fXY_std_err": 0.004678211749195064
#       },
#       "122-135": {
#         "fXY": 0.816570134120319,
#         "fXY_std_err": 0.013401118302531188
#       },
#       "123-124": {
#         "fCPHASE": 0.8088508198231014,
#         "fCPHASE_std_err": 0.011143840135171635,
#         "fCZ": 0.8684157022104797,
#         "fCZ_std_err": 0.0072203020525419435,
#         "fXY": 0.8738208847574023,
#         "fXY_std_err": 0.005515907576318525
#       },
#       "124-125": {
#         "fCPHASE": 0.8796302250870883,
#         "fCPHASE_std_err": 0.005403435175703562,
#         "fCZ": 0.9037510917814479,
#         "fCZ_std_err": 0.0036060550588162487,
#         "fXY": 0.83904746352877,
#         "fXY_std_err": 0.0070472130968967095
#       },
#       "125-126": {
#         "fXY": 0.8711673258690165,
#         "fXY_std_err": 0.005900653463212532
#       },
#       "126-127": {
#         "fCPHASE": 0.8286492041722195,
#         "fCPHASE_std_err": 0.008720112009977193,
#         "fCZ": 0.8300702272113248,
#         "fCZ_std_err": 0.010411038352638508,
#         "fXY": 0.8476964427419402,
#         "fXY_std_err": 0.0074497554305178685
#       },
#       "13-14": {
#         "fCPHASE": 0.830192548760063,
#         "fCPHASE_std_err": 0.00824168127500398,
#         "fCZ": 0.9049554602899993,
#         "fCZ_std_err": 0.004413478166551366,
#         "fXY": 0.9061604934354787,
#         "fXY_std_err": 0.0031095717273184873
#       },
#       "130-131": {
#         "fCPHASE": 0.8673118176745922,
#         "fCPHASE_std_err": 0.009670150450787925,
#         "fCZ": 0.9456136908682506,
#         "fCZ_std_err": 0.008260063030968434,
#         "fXY": 0.9683186786013154,
#         "fXY_std_err": 0.004723592938201695
#       },
#       "130-137": {
#         "fCPHASE": 0.8088089734470796,
#         "fCPHASE_std_err": 0.010271549881913321,
#         "fCZ": 0.7956046448109174,
#         "fCZ_std_err": 0.010996609368860509,
#         "fXY": 0.9552159893948519,
#         "fXY_std_err": 0.008352169598857264
#       },
#       "131-132": {
#         "fCPHASE": 0.9750354399185646,
#         "fCPHASE_std_err": 0.004781004864872557,
#         "fCZ": 0.9794066639805221,
#         "fCZ_std_err": 0.003398876679892927,
#         "fXY": 0.9604676502874958,
#         "fXY_std_err": 0.007358267620509796
#       },
#       "131-146": {
#         "fCPHASE": 0.9837791549716379,
#         "fCPHASE_std_err": 0.004856105065080514,
#         "fCZ": 0.9765311131670051,
#         "fCZ_std_err": 0.004566931397844811,
#         "fXY": 0.9465174245011486,
#         "fXY_std_err": 0.010334420373491547
#       },
#       "132-133": {
#         "fCPHASE": 0.9161088018348845,
#         "fCPHASE_std_err": 0.015672760374403766,
#         "fCZ": 0.9825072628174693,
#         "fCZ_std_err": 0.0037639583368645267,
#         "fXY": 0.9820085362570932,
#         "fXY_std_err": 0.003910578428634678
#       },
#       "132-145": {
#         "fCPHASE": 0.8589136974919023,
#         "fCPHASE_std_err": 0.009771426441414804,
#         "fCZ": 0.9775112416042098,
#         "fCZ_std_err": 0.0042634865130233845,
#         "fXY": 0.9684922354554597,
#         "fXY_std_err": 0.005716658262696874
#       },
#       "133-134": {
#         "fXY": 0.9643202161115991,
#         "fXY_std_err": 0.005313158100985515
#       },
#       "134-135": {
#         "fCPHASE": 0.8759076249879598,
#         "fCPHASE_std_err": 0.005951930676341058,
#         "fCZ": 0.880772375716458,
#         "fCZ_std_err": 0.005383083039562359,
#         "fXY": 0.826768469517144,
#         "fXY_std_err": 0.012275230284444058
#       },
#       "135-136": {
#         "fXY": 0.8823573762669987,
#         "fXY_std_err": 0.004362903672808411
#       },
#       "136-137": {
#         "fCPHASE": 0.779906507369305,
#         "fCPHASE_std_err": 0.014083675451787856,
#         "fCZ": 0.8597055301117816,
#         "fCZ_std_err": 0.009267103126163113,
#         "fXY": 0.9394924696317184,
#         "fXY_std_err": 0.009026267705916457
#       },
#       "14-15": {
#         "fCPHASE": 0.8766662342219608,
#         "fCPHASE_std_err": 0.006880799348668107,
#         "fCZ": 0.8861901021702794,
#         "fCZ_std_err": 0.007769342618245871,
#         "fXY": 0.9557891655547845,
#         "fXY_std_err": 0.00568201253269481
#       },
#       "140-141": {
#         "fCPHASE": 0.8559837232374333,
#         "fCPHASE_std_err": 0.007851740045821322,
#         "fCZ": 0.85549632306629,
#         "fCZ_std_err": 0.009182656411288324,
#         "fXY": 0.7832164051593833,
#         "fXY_std_err": 0.013643430696459706
#       },
#       "140-147": {
#         "fCPHASE": 0.8197636960728523,
#         "fCPHASE_std_err": 0.010912596759619475,
#         "fCZ": 0.8611208710099344,
#         "fCZ_std_err": 0.007782280433813801
#       },
#       "141-142": {
#         "fCPHASE": 0.8379212136374757,
#         "fCPHASE_std_err": 0.009436708941327367,
#         "fCZ": 0.9897773553792817,
#         "fCZ_std_err": 0.004653510421380266,
#         "fXY": 0.8898433247007064,
#         "fXY_std_err": 0.00683904620994882
#       },
#       "142-143": {
#         "fCPHASE": 0.8938529671250793,
#         "fCPHASE_std_err": 0.005715860097572686,
#         "fCZ": 0.9420979046100509,
#         "fCZ_std_err": 0.008011040693591945,
#         "fXY": 0.8837645681322148,
#         "fXY_std_err": 0.00849878096413794
#       },
#       "143-144": {
#         "fCPHASE": 0.7399327378614615,
#         "fCPHASE_std_err": 0.012102652494013148,
#         "fCZ": 0.8461104834663259,
#         "fCZ_std_err": 0.010228255851404425,
#         "fXY": 0.9415869203171845,
#         "fXY_std_err": 0.009043461604621576
#       },
#       "144-145": {
#         "fCPHASE": 0.9739440307604926,
#         "fCPHASE_std_err": 0.004748048876974891,
#         "fCZ": 0.9876510119891195,
#         "fCZ_std_err": 0.0034572482252872945,
#         "fXY": 0.9767178524071835,
#         "fXY_std_err": 0.005070489763124349
#       },
#       "145-146": {
#         "fCPHASE": 0.8114378164712522,
#         "fCPHASE_std_err": 0.0158085436667583,
#         "fCZ": 0.7618196974476183,
#         "fCZ_std_err": 0.016990595224361495,
#         "fXY": 0.956849400003389,
#         "fXY_std_err": 0.006325856280412038
#       },
#       "146-147": {
#         "fCPHASE": 0.8790413996724529,
#         "fCPHASE_std_err": 0.008185093886850778,
#         "fCZ": 0.970268664871968,
#         "fCZ_std_err": 0.005168586741643974,
#         "fXY": 0.9714740851091758,
#         "fXY_std_err": 0.005830191462889508
#       },
#       "15-16": {
#         "fCPHASE": 0.9801204937925481,
#         "fCPHASE_std_err": 0.005234197470795671,
#         "fCZ": 0.999813236502312,
#         "fCZ_std_err": 0.004832863907631671,
#         "fXY": 0.9879318124600067,
#         "fXY_std_err": 0.005267134105008754
#       },
#       "16-17": {
#         "fCPHASE": 0.9780789598666724,
#         "fCPHASE_std_err": 0.004130748973790723,
#         "fCZ": 0.9799267884561031,
#         "fCZ_std_err": 0.005884637014320713,
#         "fXY": 0.9770338230460228,
#         "fXY_std_err": 0.004117800529806798
#       },
#       "17-114": {
#         "fCPHASE": 0.9720203820738731,
#         "fCPHASE_std_err": 0.009514143268534971,
#         "fCZ": 0.9806081122648821,
#         "fCZ_std_err": 0.0037469654062792716,
#         "fXY": 0.9776531703852921,
#         "fXY_std_err": 0.003672292031732763
#       },
#       "2-15": {
#         "fCPHASE": 0.8081350335584996,
#         "fCPHASE_std_err": 0.013285854378159788,
#         "fCZ": 0.8548335634835879,
#         "fCZ_std_err": 0.008976779571509452
#       },
#       "20-123": {
#         "fCPHASE": 0.8193502371164366,
#         "fCPHASE_std_err": 0.009421108362489269,
#         "fCZ": 0.7854198851136105,
#         "fCZ_std_err": 0.015963577104694236,
#         "fXY": 0.8615517081844309,
#         "fXY_std_err": 0.005030805786365584
#       },
#       "20-21": {
#         "fCPHASE": 0.8065113262231896,
#         "fCPHASE_std_err": 0.01340762291758278,
#         "fCZ": 0.8441826202571918,
#         "fCZ_std_err": 0.009661381701394413,
#         "fXY": 0.8000408545394901,
#         "fXY_std_err": 0.010773041511467064
#       },
#       "20-27": {
#         "fCPHASE": 0.7932941056068699,
#         "fCPHASE_std_err": 0.012403872724967895,
#         "fCZ": 0.8304106814805514,
#         "fCZ_std_err": 0.012215024558658751,
#         "fXY": 0.8728772273868042,
#         "fXY_std_err": 0.006491268406431691
#       },
#       "21-22": {
#         "fCPHASE": 0.9343485327784542,
#         "fCPHASE_std_err": 0.014193004541805465,
#         "fCZ": 0.9624446064291415,
#         "fCZ_std_err": 0.0072612409585653655,
#         "fXY": 0.9742749972830153,
#         "fXY_std_err": 0.004984900508640702
#       },
#       "21-36": {
#         "fCPHASE": 0.9424028973999168,
#         "fCPHASE_std_err": 0.011266504724314334,
#         "fCZ": 0.8715205649411927,
#         "fCZ_std_err": 0.00583962984420262,
#         "fXY": 0.8305215167838699,
#         "fXY_std_err": 0.009109259127847314
#       },
#       "22-23": {
#         "fCPHASE": 0.7426303576542967,
#         "fCPHASE_std_err": 0.029821492591707088,
#         "fCZ": 0.9537032924702344,
#         "fCZ_std_err": 0.007913207226960574,
#         "fXY": 0.9010746174801185,
#         "fXY_std_err": 0.005461982214267914
#       },
#       "22-35": {
#         "fCPHASE": 0.8827204391252941,
#         "fCPHASE_std_err": 0.0068386176636143926,
#         "fCZ": 0.949580842988059,
#         "fCZ_std_err": 0.009354890389720899,
#         "fXY": 0.9675942434591304,
#         "fXY_std_err": 0.0061443189003539
#       },
#       "23-24": {
#         "fCPHASE": 0.9429599584674209,
#         "fCPHASE_std_err": 0.00845005228810343,
#         "fCZ": 0.9733458158366463,
#         "fCZ_std_err": 0.004219598256182439,
#         "fXY": 0.9793971890770338,
#         "fXY_std_err": 0.0050598703302057865
#       },
#       "24-25": {
#         "fCPHASE": 0.9670741151913572,
#         "fCPHASE_std_err": 0.006234099833016856,
#         "fCZ": 0.976794165600524,
#         "fCZ_std_err": 0.0037639292452073775,
#         "fXY": 0.9652914938680959,
#         "fXY_std_err": 0.005406601394132546
#       },
#       "25-26": {
#         "fCPHASE": 0.9616642822124157,
#         "fCPHASE_std_err": 0.005622276264141014,
#         "fCZ": 0.9289920074032798,
#         "fCZ_std_err": 0.01053846003226153,
#         "fXY": 0.9633512307496161,
#         "fXY_std_err": 0.011735755979834329
#       },
#       "26-27": {
#         "fCPHASE": 0.8800125836482163,
#         "fCPHASE_std_err": 0.006026486479284393,
#         "fCZ": 0.9485266970698227,
#         "fCZ_std_err": 0.008462684152622442,
#         "fXY": 0.953645166443807,
#         "fXY_std_err": 0.007495906362728493
#       },
#       "27-124": {
#         "fCPHASE": 0.8508197902543639,
#         "fCPHASE_std_err": 0.00888005658627029,
#         "fCZ": 0.8897303257434233,
#         "fCZ_std_err": 0.00569786709740811,
#         "fXY": 0.8329017177096557,
#         "fXY_std_err": 0.006918358980676659
#       },
#       "3-4": {
#         "fXY": 0.8746081975879367,
#         "fXY_std_err": 0.006968553577876266
#       },
#       "30-133": {
#         "fCPHASE": 0.965319712305048,
#         "fCPHASE_std_err": 0.00467255629993315,
#         "fCZ": 0.9578527539896746,
#         "fCZ_std_err": 0.010219011708921241,
#         "fXY": 0.9897511917132819,
#         "fXY_std_err": 0.008476102553867984
#       },
#       "30-31": {
#         "fCPHASE": 0.9778241920782966,
#         "fCPHASE_std_err": 0.0038702813616620702,
#         "fCZ": 0.9772385473421125,
#         "fCZ_std_err": 0.004324684034535245,
#         "fXY": 0.9816702881058795,
#         "fXY_std_err": 0.00578338777292095
#       },
#       "30-37": {
#         "fCPHASE": 0.981483593565438,
#         "fCPHASE_std_err": 0.003877200035110973,
#         "fCZ": 0.9723199974116761,
#         "fCZ_std_err": 0.004655566826333854,
#         "fXY": 0.9873360142926402,
#         "fXY_std_err": 0.003250454508332072
#       },
#       "31-32": {
#         "fCPHASE": 0.9590337302580081,
#         "fCPHASE_std_err": 0.009787616186874024,
#         "fCZ": 0.93650318276968,
#         "fCZ_std_err": 0.009933298725986904,
#         "fXY": 0.9723306362743247,
#         "fXY_std_err": 0.006553731261397885
#       },
#       "31-46": {
#         "fCPHASE": 0.8086087284533889,
#         "fCPHASE_std_err": 0.012868907275654014,
#         "fCZ": 0.8397816897419554,
#         "fCZ_std_err": 0.009005366554017988,
#         "fXY": 0.7989703513989906,
#         "fXY_std_err": 0.013492544557093578
#       },
#       "32-33": {
#         "fCPHASE": 0.9485063613293234,
#         "fCPHASE_std_err": 0.008422722428695668,
#         "fCZ": 0.9706948351026117,
#         "fCZ_std_err": 0.0055849782919549775,
#         "fXY": 0.833856526414466,
#         "fXY_std_err": 0.008964148173566397
#       },
#       "32-45": {
#         "fCPHASE": 0.8630508882390163,
#         "fCPHASE_std_err": 0.00763303051543229,
#         "fCZ": 0.9438609482715019,
#         "fCZ_std_err": 0.009078191235137612,
#         "fXY": 0.9624654292433399,
#         "fXY_std_err": 0.006155105782348377
#       },
#       "33-34": {
#         "fCPHASE": 0.8898267201949828,
#         "fCPHASE_std_err": 0.004147496916862115,
#         "fCZ": 0.8836528937894599,
#         "fCZ_std_err": 0.005959268175043224,
#         "fXY": 0.9422603627388502,
#         "fXY_std_err": 0.00655220853344758
#       },
#       "34-35": {
#         "fCPHASE": 0.9640331066692065,
#         "fCPHASE_std_err": 0.005965274350912715,
#         "fCZ": 0.9151179027848709,
#         "fCZ_std_err": 0.004296668003671502,
#         "fXY": 0.8510681372217245,
#         "fXY_std_err": 0.008099241369238062
#       },
#       "35-36": {
#         "fCPHASE": 0.9505396989236936,
#         "fCPHASE_std_err": 0.009712166248820892,
#         "fCZ": 0.8910981692338348,
#         "fCZ_std_err": 0.004473507546975717,
#         "fXY": 0.8935459374466123,
#         "fXY_std_err": 0.004385813026143935
#       },
#       "36-37": {
#         "fCPHASE": 0.9626784351445532,
#         "fCPHASE_std_err": 0.00764287981774085,
#         "fCZ": 0.8422121611879764,
#         "fCZ_std_err": 0.007261671234140392,
#         "fXY": 0.8061012990933851,
#         "fXY_std_err": 0.0070843996754806245
#       },
#       "37-134": {
#         "fCPHASE": 0.7859543348798605,
#         "fCPHASE_std_err": 0.01811566663633528,
#         "fCZ": 0.8903258320210687,
#         "fCZ_std_err": 0.008829920336258035,
#         "fXY": 0.9787908065008031,
#         "fXY_std_err": 0.003626364466654866
#       },
#       "4-5": {
#         "fCPHASE": 0.8699093339532215,
#         "fCPHASE_std_err": 0.007057662622021383,
#         "fCZ": 0.8501156912731619,
#         "fCZ_std_err": 0.008100907253946405,
#         "fXY": 0.8850625852130382,
#         "fXY_std_err": 0.005688320958097048
#       },
#       "40-143": {
#         "fCPHASE": 0.9275350651452505,
#         "fCPHASE_std_err": 0.00910019842404175,
#         "fCZ": 0.9383649332606057,
#         "fCZ_std_err": 0.010088882777519494,
#         "fXY": 0.9594361594124685,
#         "fXY_std_err": 0.006955962931293036
#       },
#       "40-41": {
#         "fCPHASE": 0.9646225764891221,
#         "fCPHASE_std_err": 0.005079123223953213,
#         "fCZ": 0.9748069742862184,
#         "fCZ_std_err": 0.005300135474538388,
#         "fXY": 0.9795373110884122,
#         "fXY_std_err": 0.004091576234223601
#       },
#       "40-47": {
#         "fCPHASE": 0.8559065271569043,
#         "fCPHASE_std_err": 0.00828788398515153,
#         "fCZ": 0.9636026410885461,
#         "fCZ_std_err": 0.0076667131840061605,
#         "fXY": 0.9755410166511793,
#         "fXY_std_err": 0.005297284725332546
#       },
#       "41-42": {
#         "fCPHASE": 0.8924835539613558,
#         "fCPHASE_std_err": 0.006193476733077125,
#         "fCZ": 0.9092248387918991,
#         "fCZ_std_err": 0.01565102307846908,
#         "fXY": 0.9732773147914001,
#         "fXY_std_err": 0.005035631818534339
#       },
#       "42-43": {
#         "fCPHASE": 0.9453152330006671,
#         "fCPHASE_std_err": 0.0106101599885008,
#         "fCZ": 0.9466994355297302,
#         "fCZ_std_err": 0.007812000051422815,
#         "fXY": 0.9664288104517061,
#         "fXY_std_err": 0.006571944751899266
#       },
#       "43-44": {
#         "fCPHASE": 0.8437265276695008,
#         "fCPHASE_std_err": 0.008428101757331786,
#         "fCZ": 0.8440064284852733,
#         "fCZ_std_err": 0.007684485666374366,
#         "fXY": 0.7773601925214096,
#         "fXY_std_err": 0.011220984958551778
#       },
#       "44-45": {
#         "fCPHASE": 0.8051381551389488,
#         "fCPHASE_std_err": 0.009615201111119326,
#         "fCZ": 0.7927504718368023,
#         "fCZ_std_err": 0.009927569490247364,
#         "fXY": 0.8202243615354277,
#         "fXY_std_err": 0.010111405082715989
#       },
#       "45-46": {
#         "fXY": 0.7959292456843362,
#         "fXY_std_err": 0.011855774090243456
#       },
#       "46-47": {
#         "fCPHASE": 0.829407369735475,
#         "fCPHASE_std_err": 0.011397208966417988,
#         "fCZ": 0.8575147917083225,
#         "fCZ_std_err": 0.01078459615622291
#       },
#       "47-144": {
#         "fCPHASE": 0.8369079556276485,
#         "fCPHASE_std_err": 0.010057333735365168,
#         "fCZ": 0.9142870347786882,
#         "fCZ_std_err": 0.004779190710712458,
#         "fXY": 0.9662715327951293,
#         "fXY_std_err": 0.01054847285829954
#       },
#       "5-6": {
#         "fCPHASE": 0.9863396959589366,
#         "fCPHASE_std_err": 0.003721295796625958,
#         "fCZ": 0.980953802611956,
#         "fCZ_std_err": 0.003007115590267146,
#         "fXY": 0.9790258154995428,
#         "fXY_std_err": 0.004299906953703585
#       },
#       "6-7": {
#         "fCPHASE": 0.896797254022512,
#         "fCPHASE_std_err": 0.007292262113693537,
#         "fCZ": 0.9076151409824482,
#         "fCZ_std_err": 0.0172726074925553,
#         "fXY": 0.9771281510423225,
#         "fXY_std_err": 0.004309789753583227
#       }
#     }
#   }
# }
#
# specs_2q = aspen_m_1_dict_specs['specs']['2Q']
#
# __rigetti_aspen_m_1_coupling_map = [[int(x) for x in edge_key.split('-')] for edge_key in specs_2q.keys()]
#
# print(__rigetti_aspen_m_1_coupling_map)


def get_devices_graph(number_of_qubits,
                      coupling_map):
    device_graph = nx.Graph()
    device_graph.add_nodes_from(list(range(number_of_qubits)))
    for edge in coupling_map:
        device_graph.add_edge(edge[0], edge[1])
    return device_graph

_ibm_washington_graph = get_devices_graph(number_of_qubits=127,
                                          coupling_map=__ibm__washington_coupling_map)

_aspen_m_1_graph = get_devices_graph(number_of_qubits=80,
                                          coupling_map=__rigetti_aspen_m_1_coupling_map)


def get_nodes_distances_dictionary(backend_name):

    if backend_name.lower() in ['ibm_washington']:
        graph = _ibm_washington_graph
    elif backend_name.lower() in ['aspen-m-1']:
        graph = _aspen_m_1_graph
    else:
        raise ValueError("Only washington and aspen-m-1 for now")


    return dict(nx.algorithms.shortest_path_length(graph))



