# -*- coding: utf-8 -*-
# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from google.cloud.compute import gapic_version as package_version

__version__ = package_version.__version__


from google.cloud.compute_v1.services.accelerator_types.client import (
    AcceleratorTypesClient,
)
from google.cloud.compute_v1.services.addresses.client import AddressesClient
from google.cloud.compute_v1.services.autoscalers.client import AutoscalersClient
from google.cloud.compute_v1.services.backend_buckets.client import BackendBucketsClient
from google.cloud.compute_v1.services.backend_services.client import (
    BackendServicesClient,
)
from google.cloud.compute_v1.services.disk_types.client import DiskTypesClient
from google.cloud.compute_v1.services.disks.client import DisksClient
from google.cloud.compute_v1.services.external_vpn_gateways.client import (
    ExternalVpnGatewaysClient,
)
from google.cloud.compute_v1.services.firewall_policies.client import (
    FirewallPoliciesClient,
)
from google.cloud.compute_v1.services.firewalls.client import FirewallsClient
from google.cloud.compute_v1.services.forwarding_rules.client import (
    ForwardingRulesClient,
)
from google.cloud.compute_v1.services.global_addresses.client import (
    GlobalAddressesClient,
)
from google.cloud.compute_v1.services.global_forwarding_rules.client import (
    GlobalForwardingRulesClient,
)
from google.cloud.compute_v1.services.global_network_endpoint_groups.client import (
    GlobalNetworkEndpointGroupsClient,
)
from google.cloud.compute_v1.services.global_operations.client import (
    GlobalOperationsClient,
)
from google.cloud.compute_v1.services.global_organization_operations.client import (
    GlobalOrganizationOperationsClient,
)
from google.cloud.compute_v1.services.global_public_delegated_prefixes.client import (
    GlobalPublicDelegatedPrefixesClient,
)
from google.cloud.compute_v1.services.health_checks.client import HealthChecksClient
from google.cloud.compute_v1.services.image_family_views.client import (
    ImageFamilyViewsClient,
)
from google.cloud.compute_v1.services.images.client import ImagesClient
from google.cloud.compute_v1.services.instance_group_manager_resize_requests.client import (
    InstanceGroupManagerResizeRequestsClient,
)
from google.cloud.compute_v1.services.instance_group_managers.client import (
    InstanceGroupManagersClient,
)
from google.cloud.compute_v1.services.instance_groups.client import InstanceGroupsClient
from google.cloud.compute_v1.services.instance_settings_service.client import (
    InstanceSettingsServiceClient,
)
from google.cloud.compute_v1.services.instance_templates.client import (
    InstanceTemplatesClient,
)
from google.cloud.compute_v1.services.instances.client import InstancesClient
from google.cloud.compute_v1.services.instant_snapshots.client import (
    InstantSnapshotsClient,
)
from google.cloud.compute_v1.services.interconnect_attachment_groups.client import (
    InterconnectAttachmentGroupsClient,
)
from google.cloud.compute_v1.services.interconnect_attachments.client import (
    InterconnectAttachmentsClient,
)
from google.cloud.compute_v1.services.interconnect_groups.client import (
    InterconnectGroupsClient,
)
from google.cloud.compute_v1.services.interconnect_locations.client import (
    InterconnectLocationsClient,
)
from google.cloud.compute_v1.services.interconnect_remote_locations.client import (
    InterconnectRemoteLocationsClient,
)
from google.cloud.compute_v1.services.interconnects.client import InterconnectsClient
from google.cloud.compute_v1.services.license_codes.client import LicenseCodesClient
from google.cloud.compute_v1.services.licenses.client import LicensesClient
from google.cloud.compute_v1.services.machine_images.client import MachineImagesClient
from google.cloud.compute_v1.services.machine_types.client import MachineTypesClient
from google.cloud.compute_v1.services.network_attachments.client import (
    NetworkAttachmentsClient,
)
from google.cloud.compute_v1.services.network_edge_security_services.client import (
    NetworkEdgeSecurityServicesClient,
)
from google.cloud.compute_v1.services.network_endpoint_groups.client import (
    NetworkEndpointGroupsClient,
)
from google.cloud.compute_v1.services.network_firewall_policies.client import (
    NetworkFirewallPoliciesClient,
)
from google.cloud.compute_v1.services.network_profiles.client import (
    NetworkProfilesClient,
)
from google.cloud.compute_v1.services.networks.client import NetworksClient
from google.cloud.compute_v1.services.node_groups.client import NodeGroupsClient
from google.cloud.compute_v1.services.node_templates.client import NodeTemplatesClient
from google.cloud.compute_v1.services.node_types.client import NodeTypesClient
from google.cloud.compute_v1.services.packet_mirrorings.client import (
    PacketMirroringsClient,
)
from google.cloud.compute_v1.services.projects.client import ProjectsClient
from google.cloud.compute_v1.services.public_advertised_prefixes.client import (
    PublicAdvertisedPrefixesClient,
)
from google.cloud.compute_v1.services.public_delegated_prefixes.client import (
    PublicDelegatedPrefixesClient,
)
from google.cloud.compute_v1.services.region_autoscalers.client import (
    RegionAutoscalersClient,
)
from google.cloud.compute_v1.services.region_backend_services.client import (
    RegionBackendServicesClient,
)
from google.cloud.compute_v1.services.region_commitments.client import (
    RegionCommitmentsClient,
)
from google.cloud.compute_v1.services.region_disk_types.client import (
    RegionDiskTypesClient,
)
from google.cloud.compute_v1.services.region_disks.client import RegionDisksClient
from google.cloud.compute_v1.services.region_health_check_services.client import (
    RegionHealthCheckServicesClient,
)
from google.cloud.compute_v1.services.region_health_checks.client import (
    RegionHealthChecksClient,
)
from google.cloud.compute_v1.services.region_instance_group_managers.client import (
    RegionInstanceGroupManagersClient,
)
from google.cloud.compute_v1.services.region_instance_groups.client import (
    RegionInstanceGroupsClient,
)
from google.cloud.compute_v1.services.region_instance_templates.client import (
    RegionInstanceTemplatesClient,
)
from google.cloud.compute_v1.services.region_instances.client import (
    RegionInstancesClient,
)
from google.cloud.compute_v1.services.region_instant_snapshots.client import (
    RegionInstantSnapshotsClient,
)
from google.cloud.compute_v1.services.region_network_endpoint_groups.client import (
    RegionNetworkEndpointGroupsClient,
)
from google.cloud.compute_v1.services.region_network_firewall_policies.client import (
    RegionNetworkFirewallPoliciesClient,
)
from google.cloud.compute_v1.services.region_notification_endpoints.client import (
    RegionNotificationEndpointsClient,
)
from google.cloud.compute_v1.services.region_operations.client import (
    RegionOperationsClient,
)
from google.cloud.compute_v1.services.region_security_policies.client import (
    RegionSecurityPoliciesClient,
)
from google.cloud.compute_v1.services.region_ssl_certificates.client import (
    RegionSslCertificatesClient,
)
from google.cloud.compute_v1.services.region_ssl_policies.client import (
    RegionSslPoliciesClient,
)
from google.cloud.compute_v1.services.region_target_http_proxies.client import (
    RegionTargetHttpProxiesClient,
)
from google.cloud.compute_v1.services.region_target_https_proxies.client import (
    RegionTargetHttpsProxiesClient,
)
from google.cloud.compute_v1.services.region_target_tcp_proxies.client import (
    RegionTargetTcpProxiesClient,
)
from google.cloud.compute_v1.services.region_url_maps.client import RegionUrlMapsClient
from google.cloud.compute_v1.services.region_zones.client import RegionZonesClient
from google.cloud.compute_v1.services.regions.client import RegionsClient
from google.cloud.compute_v1.services.reservation_blocks.client import (
    ReservationBlocksClient,
)
from google.cloud.compute_v1.services.reservation_sub_blocks.client import (
    ReservationSubBlocksClient,
)
from google.cloud.compute_v1.services.reservations.client import ReservationsClient
from google.cloud.compute_v1.services.resource_policies.client import (
    ResourcePoliciesClient,
)
from google.cloud.compute_v1.services.routers.client import RoutersClient
from google.cloud.compute_v1.services.routes.client import RoutesClient
from google.cloud.compute_v1.services.security_policies.client import (
    SecurityPoliciesClient,
)
from google.cloud.compute_v1.services.service_attachments.client import (
    ServiceAttachmentsClient,
)
from google.cloud.compute_v1.services.snapshot_settings_service.client import (
    SnapshotSettingsServiceClient,
)
from google.cloud.compute_v1.services.snapshots.client import SnapshotsClient
from google.cloud.compute_v1.services.ssl_certificates.client import (
    SslCertificatesClient,
)
from google.cloud.compute_v1.services.ssl_policies.client import SslPoliciesClient
from google.cloud.compute_v1.services.storage_pool_types.client import (
    StoragePoolTypesClient,
)
from google.cloud.compute_v1.services.storage_pools.client import StoragePoolsClient
from google.cloud.compute_v1.services.subnetworks.client import SubnetworksClient
from google.cloud.compute_v1.services.target_grpc_proxies.client import (
    TargetGrpcProxiesClient,
)
from google.cloud.compute_v1.services.target_http_proxies.client import (
    TargetHttpProxiesClient,
)
from google.cloud.compute_v1.services.target_https_proxies.client import (
    TargetHttpsProxiesClient,
)
from google.cloud.compute_v1.services.target_instances.client import (
    TargetInstancesClient,
)
from google.cloud.compute_v1.services.target_pools.client import TargetPoolsClient
from google.cloud.compute_v1.services.target_ssl_proxies.client import (
    TargetSslProxiesClient,
)
from google.cloud.compute_v1.services.target_tcp_proxies.client import (
    TargetTcpProxiesClient,
)
from google.cloud.compute_v1.services.target_vpn_gateways.client import (
    TargetVpnGatewaysClient,
)
from google.cloud.compute_v1.services.url_maps.client import UrlMapsClient
from google.cloud.compute_v1.services.vpn_gateways.client import VpnGatewaysClient
from google.cloud.compute_v1.services.vpn_tunnels.client import VpnTunnelsClient
from google.cloud.compute_v1.services.zone_operations.client import ZoneOperationsClient
from google.cloud.compute_v1.services.zones.client import ZonesClient
from google.cloud.compute_v1.types.compute import (
    AbandonInstancesInstanceGroupManagerRequest,
    AbandonInstancesRegionInstanceGroupManagerRequest,
    AcceleratorConfig,
    Accelerators,
    AcceleratorType,
    AcceleratorTypeAggregatedList,
    AcceleratorTypeList,
    AcceleratorTypesScopedList,
    AccessConfig,
    AddAccessConfigInstanceRequest,
    AddAssociationFirewallPolicyRequest,
    AddAssociationNetworkFirewallPolicyRequest,
    AddAssociationRegionNetworkFirewallPolicyRequest,
    AddHealthCheckTargetPoolRequest,
    AddInstancesInstanceGroupRequest,
    AddInstanceTargetPoolRequest,
    AddNodesNodeGroupRequest,
    AddPacketMirroringRuleNetworkFirewallPolicyRequest,
    AddPeeringNetworkRequest,
    AddResourcePoliciesDiskRequest,
    AddResourcePoliciesInstanceRequest,
    AddResourcePoliciesRegionDiskRequest,
    Address,
    AddressAggregatedList,
    AddressesScopedList,
    AddressList,
    AddRuleFirewallPolicyRequest,
    AddRuleNetworkFirewallPolicyRequest,
    AddRuleRegionNetworkFirewallPolicyRequest,
    AddRuleRegionSecurityPolicyRequest,
    AddRuleSecurityPolicyRequest,
    AddSignedUrlKeyBackendBucketRequest,
    AddSignedUrlKeyBackendServiceRequest,
    AdvancedMachineFeatures,
    AggregatedListAcceleratorTypesRequest,
    AggregatedListAddressesRequest,
    AggregatedListAutoscalersRequest,
    AggregatedListBackendServicesRequest,
    AggregatedListDisksRequest,
    AggregatedListDiskTypesRequest,
    AggregatedListForwardingRulesRequest,
    AggregatedListGlobalOperationsRequest,
    AggregatedListHealthChecksRequest,
    AggregatedListInstanceGroupManagersRequest,
    AggregatedListInstanceGroupsRequest,
    AggregatedListInstancesRequest,
    AggregatedListInstanceTemplatesRequest,
    AggregatedListInstantSnapshotsRequest,
    AggregatedListInterconnectAttachmentsRequest,
    AggregatedListMachineTypesRequest,
    AggregatedListNetworkAttachmentsRequest,
    AggregatedListNetworkEdgeSecurityServicesRequest,
    AggregatedListNetworkEndpointGroupsRequest,
    AggregatedListNetworkFirewallPoliciesRequest,
    AggregatedListNodeGroupsRequest,
    AggregatedListNodeTemplatesRequest,
    AggregatedListNodeTypesRequest,
    AggregatedListPacketMirroringsRequest,
    AggregatedListPublicDelegatedPrefixesRequest,
    AggregatedListRegionCommitmentsRequest,
    AggregatedListReservationsRequest,
    AggregatedListResourcePoliciesRequest,
    AggregatedListRoutersRequest,
    AggregatedListSecurityPoliciesRequest,
    AggregatedListServiceAttachmentsRequest,
    AggregatedListSslCertificatesRequest,
    AggregatedListSslPoliciesRequest,
    AggregatedListStoragePoolsRequest,
    AggregatedListStoragePoolTypesRequest,
    AggregatedListSubnetworksRequest,
    AggregatedListTargetHttpProxiesRequest,
    AggregatedListTargetHttpsProxiesRequest,
    AggregatedListTargetInstancesRequest,
    AggregatedListTargetPoolsRequest,
    AggregatedListTargetTcpProxiesRequest,
    AggregatedListTargetVpnGatewaysRequest,
    AggregatedListUrlMapsRequest,
    AggregatedListVpnGatewaysRequest,
    AggregatedListVpnTunnelsRequest,
    AliasIpRange,
    AllocationAggregateReservation,
    AllocationAggregateReservationReservedResourceInfo,
    AllocationAggregateReservationReservedResourceInfoAccelerator,
    AllocationReservationSharingPolicy,
    AllocationResourceStatus,
    AllocationResourceStatusHealthInfo,
    AllocationResourceStatusSpecificSKUAllocation,
    AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk,
    AllocationSpecificSKUAllocationReservedInstanceProperties,
    AllocationSpecificSKUReservation,
    Allowed,
    AnnouncePublicAdvertisedPrefixeRequest,
    AnnouncePublicDelegatedPrefixeRequest,
    ApplyUpdatesToInstancesInstanceGroupManagerRequest,
    ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest,
    AttachDiskInstanceRequest,
    AttachedDisk,
    AttachedDiskInitializeParams,
    AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest,
    AttachNetworkEndpointsNetworkEndpointGroupRequest,
    AttachNetworkEndpointsRegionNetworkEndpointGroupRequest,
    AuditConfig,
    AuditLogConfig,
    Autoscaler,
    AutoscalerAggregatedList,
    AutoscalerList,
    AutoscalersScopedList,
    AutoscalerStatusDetails,
    AutoscalingPolicy,
    AutoscalingPolicyCpuUtilization,
    AutoscalingPolicyCustomMetricUtilization,
    AutoscalingPolicyLoadBalancingUtilization,
    AutoscalingPolicyScaleInControl,
    AutoscalingPolicyScalingSchedule,
    AWSV4Signature,
    Backend,
    BackendBucket,
    BackendBucketCdnPolicy,
    BackendBucketCdnPolicyBypassCacheOnRequestHeader,
    BackendBucketCdnPolicyCacheKeyPolicy,
    BackendBucketCdnPolicyNegativeCachingPolicy,
    BackendBucketList,
    BackendBucketParams,
    BackendBucketUsedBy,
    BackendCustomMetric,
    BackendService,
    BackendServiceAggregatedList,
    BackendServiceCdnPolicy,
    BackendServiceCdnPolicyBypassCacheOnRequestHeader,
    BackendServiceCdnPolicyNegativeCachingPolicy,
    BackendServiceConnectionTrackingPolicy,
    BackendServiceCustomMetric,
    BackendServiceFailoverPolicy,
    BackendServiceGroupHealth,
    BackendServiceHAPolicy,
    BackendServiceHAPolicyLeader,
    BackendServiceHAPolicyLeaderNetworkEndpoint,
    BackendServiceHttpCookie,
    BackendServiceIAP,
    BackendServiceList,
    BackendServiceListUsable,
    BackendServiceLocalityLoadBalancingPolicyConfig,
    BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy,
    BackendServiceLocalityLoadBalancingPolicyConfigPolicy,
    BackendServiceLogConfig,
    BackendServiceParams,
    BackendServiceReference,
    BackendServicesScopedList,
    BackendServiceTlsSettings,
    BackendServiceTlsSettingsSubjectAltName,
    BackendServiceUsedBy,
    BfdPacket,
    BfdStatus,
    BfdStatusPacketCounts,
    BgpRoute,
    BgpRouteAsPath,
    BgpRouteNetworkLayerReachabilityInformation,
    Binding,
    BulkInsertDiskRequest,
    BulkInsertDiskResource,
    BulkInsertInstanceRequest,
    BulkInsertInstanceResource,
    BulkInsertInstanceResourcePerInstanceProperties,
    BulkInsertOperationStatus,
    BulkInsertRegionDiskRequest,
    BulkInsertRegionInstanceRequest,
    BulkSetLabelsDiskRequest,
    BulkSetLabelsRequest,
    BulkZoneSetLabelsRequest,
    CacheInvalidationRule,
    CacheKeyPolicy,
    CancelInstanceGroupManagerResizeRequestRequest,
    CircuitBreakers,
    CloneRulesFirewallPolicyRequest,
    CloneRulesNetworkFirewallPolicyRequest,
    CloneRulesRegionNetworkFirewallPolicyRequest,
    Commitment,
    CommitmentAggregatedList,
    CommitmentList,
    CommitmentResourceStatus,
    CommitmentsScopedList,
    ConfidentialInstanceConfig,
    ConnectionDraining,
    ConsistentHashLoadBalancerSettings,
    ConsistentHashLoadBalancerSettingsHttpCookie,
    CorsPolicy,
    CreateInstancesInstanceGroupManagerRequest,
    CreateInstancesRegionInstanceGroupManagerRequest,
    CreateMembersInterconnectGroupRequest,
    CreateSnapshotDiskRequest,
    CreateSnapshotRegionDiskRequest,
    CustomerEncryptionKey,
    CustomerEncryptionKeyProtectedDisk,
    CustomErrorResponsePolicy,
    CustomErrorResponsePolicyCustomErrorResponseRule,
    Data,
    DeleteAccessConfigInstanceRequest,
    DeleteAddressRequest,
    DeleteAutoscalerRequest,
    DeleteBackendBucketRequest,
    DeleteBackendServiceRequest,
    DeleteDiskRequest,
    DeleteExternalVpnGatewayRequest,
    DeleteFirewallPolicyRequest,
    DeleteFirewallRequest,
    DeleteForwardingRuleRequest,
    DeleteGlobalAddressRequest,
    DeleteGlobalForwardingRuleRequest,
    DeleteGlobalNetworkEndpointGroupRequest,
    DeleteGlobalOperationRequest,
    DeleteGlobalOperationResponse,
    DeleteGlobalOrganizationOperationRequest,
    DeleteGlobalOrganizationOperationResponse,
    DeleteGlobalPublicDelegatedPrefixeRequest,
    DeleteHealthCheckRequest,
    DeleteImageRequest,
    DeleteInstanceGroupManagerRequest,
    DeleteInstanceGroupManagerResizeRequestRequest,
    DeleteInstanceGroupRequest,
    DeleteInstanceRequest,
    DeleteInstancesInstanceGroupManagerRequest,
    DeleteInstancesRegionInstanceGroupManagerRequest,
    DeleteInstanceTemplateRequest,
    DeleteInstantSnapshotRequest,
    DeleteInterconnectAttachmentGroupRequest,
    DeleteInterconnectAttachmentRequest,
    DeleteInterconnectGroupRequest,
    DeleteInterconnectRequest,
    DeleteLicenseRequest,
    DeleteMachineImageRequest,
    DeleteNetworkAttachmentRequest,
    DeleteNetworkEdgeSecurityServiceRequest,
    DeleteNetworkEndpointGroupRequest,
    DeleteNetworkFirewallPolicyRequest,
    DeleteNetworkRequest,
    DeleteNodeGroupRequest,
    DeleteNodesNodeGroupRequest,
    DeleteNodeTemplateRequest,
    DeletePacketMirroringRequest,
    DeletePerInstanceConfigsInstanceGroupManagerRequest,
    DeletePerInstanceConfigsRegionInstanceGroupManagerRequest,
    DeletePublicAdvertisedPrefixeRequest,
    DeletePublicDelegatedPrefixeRequest,
    DeleteRegionAutoscalerRequest,
    DeleteRegionBackendServiceRequest,
    DeleteRegionDiskRequest,
    DeleteRegionHealthCheckRequest,
    DeleteRegionHealthCheckServiceRequest,
    DeleteRegionInstanceGroupManagerRequest,
    DeleteRegionInstanceTemplateRequest,
    DeleteRegionInstantSnapshotRequest,
    DeleteRegionNetworkEndpointGroupRequest,
    DeleteRegionNetworkFirewallPolicyRequest,
    DeleteRegionNotificationEndpointRequest,
    DeleteRegionOperationRequest,
    DeleteRegionOperationResponse,
    DeleteRegionSecurityPolicyRequest,
    DeleteRegionSslCertificateRequest,
    DeleteRegionSslPolicyRequest,
    DeleteRegionTargetHttpProxyRequest,
    DeleteRegionTargetHttpsProxyRequest,
    DeleteRegionTargetTcpProxyRequest,
    DeleteRegionUrlMapRequest,
    DeleteReservationRequest,
    DeleteResourcePolicyRequest,
    DeleteRoutePolicyRouterRequest,
    DeleteRouteRequest,
    DeleteRouterRequest,
    DeleteSecurityPolicyRequest,
    DeleteServiceAttachmentRequest,
    DeleteSignedUrlKeyBackendBucketRequest,
    DeleteSignedUrlKeyBackendServiceRequest,
    DeleteSnapshotRequest,
    DeleteSslCertificateRequest,
    DeleteSslPolicyRequest,
    DeleteStoragePoolRequest,
    DeleteSubnetworkRequest,
    DeleteTargetGrpcProxyRequest,
    DeleteTargetHttpProxyRequest,
    DeleteTargetHttpsProxyRequest,
    DeleteTargetInstanceRequest,
    DeleteTargetPoolRequest,
    DeleteTargetSslProxyRequest,
    DeleteTargetTcpProxyRequest,
    DeleteTargetVpnGatewayRequest,
    DeleteUrlMapRequest,
    DeleteVpnGatewayRequest,
    DeleteVpnTunnelRequest,
    DeleteZoneOperationRequest,
    DeleteZoneOperationResponse,
    Denied,
    DeprecateImageRequest,
    DeprecationStatus,
    DetachDiskInstanceRequest,
    DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest,
    DetachNetworkEndpointsNetworkEndpointGroupRequest,
    DetachNetworkEndpointsRegionNetworkEndpointGroupRequest,
    DisableXpnHostProjectRequest,
    DisableXpnResourceProjectRequest,
    Disk,
    DiskAggregatedList,
    DiskAsyncReplication,
    DiskAsyncReplicationList,
    DiskInstantiationConfig,
    DiskList,
    DiskMoveRequest,
    DiskParams,
    DiskResourceStatus,
    DiskResourceStatusAsyncReplicationStatus,
    DisksAddResourcePoliciesRequest,
    DisksRemoveResourcePoliciesRequest,
    DisksResizeRequest,
    DisksScopedList,
    DisksStartAsyncReplicationRequest,
    DisksStopGroupAsyncReplicationResource,
    DiskType,
    DiskTypeAggregatedList,
    DiskTypeList,
    DiskTypesScopedList,
    DisplayDevice,
    DistributionPolicy,
    DistributionPolicyZoneConfiguration,
    Duration,
    EnableXpnHostProjectRequest,
    EnableXpnResourceProjectRequest,
    Error,
    ErrorDetails,
    ErrorInfo,
    Errors,
    ExchangedPeeringRoute,
    ExchangedPeeringRoutesList,
    ExpandIpCidrRangeSubnetworkRequest,
    Expr,
    ExternalVpnGateway,
    ExternalVpnGatewayInterface,
    ExternalVpnGatewayList,
    FileContentBuffer,
    Firewall,
    FirewallList,
    FirewallLogConfig,
    FirewallParams,
    FirewallPoliciesListAssociationsResponse,
    FirewallPoliciesScopedList,
    FirewallPolicy,
    FirewallPolicyAssociation,
    FirewallPolicyList,
    FirewallPolicyRule,
    FirewallPolicyRuleMatcher,
    FirewallPolicyRuleMatcherLayer4Config,
    FirewallPolicyRuleSecureTag,
    FixedOrPercent,
    ForwardingRule,
    ForwardingRuleAggregatedList,
    ForwardingRuleList,
    ForwardingRuleReference,
    ForwardingRuleServiceDirectoryRegistration,
    ForwardingRulesScopedList,
    GetAcceleratorTypeRequest,
    GetAddressRequest,
    GetAssociationFirewallPolicyRequest,
    GetAssociationNetworkFirewallPolicyRequest,
    GetAssociationRegionNetworkFirewallPolicyRequest,
    GetAutoscalerRequest,
    GetBackendBucketRequest,
    GetBackendServiceRequest,
    GetDiagnosticsInterconnectRequest,
    GetDiskRequest,
    GetDiskTypeRequest,
    GetEffectiveFirewallsInstanceRequest,
    GetEffectiveFirewallsNetworkRequest,
    GetEffectiveFirewallsRegionNetworkFirewallPolicyRequest,
    GetExternalVpnGatewayRequest,
    GetFirewallPolicyRequest,
    GetFirewallRequest,
    GetForwardingRuleRequest,
    GetFromFamilyImageRequest,
    GetGlobalAddressRequest,
    GetGlobalForwardingRuleRequest,
    GetGlobalNetworkEndpointGroupRequest,
    GetGlobalOperationRequest,
    GetGlobalOrganizationOperationRequest,
    GetGlobalPublicDelegatedPrefixeRequest,
    GetGuestAttributesInstanceRequest,
    GetHealthBackendServiceRequest,
    GetHealthCheckRequest,
    GetHealthRegionBackendServiceRequest,
    GetHealthTargetPoolRequest,
    GetIamPolicyBackendBucketRequest,
    GetIamPolicyBackendServiceRequest,
    GetIamPolicyDiskRequest,
    GetIamPolicyFirewallPolicyRequest,
    GetIamPolicyImageRequest,
    GetIamPolicyInstanceRequest,
    GetIamPolicyInstanceTemplateRequest,
    GetIamPolicyInstantSnapshotRequest,
    GetIamPolicyInterconnectAttachmentGroupRequest,
    GetIamPolicyInterconnectGroupRequest,
    GetIamPolicyLicenseRequest,
    GetIamPolicyMachineImageRequest,
    GetIamPolicyNetworkAttachmentRequest,
    GetIamPolicyNetworkFirewallPolicyRequest,
    GetIamPolicyNodeGroupRequest,
    GetIamPolicyNodeTemplateRequest,
    GetIamPolicyRegionBackendServiceRequest,
    GetIamPolicyRegionDiskRequest,
    GetIamPolicyRegionInstantSnapshotRequest,
    GetIamPolicyRegionNetworkFirewallPolicyRequest,
    GetIamPolicyReservationRequest,
    GetIamPolicyResourcePolicyRequest,
    GetIamPolicyServiceAttachmentRequest,
    GetIamPolicySnapshotRequest,
    GetIamPolicyStoragePoolRequest,
    GetIamPolicySubnetworkRequest,
    GetImageFamilyViewRequest,
    GetImageRequest,
    GetInstanceGroupManagerRequest,
    GetInstanceGroupManagerResizeRequestRequest,
    GetInstanceGroupRequest,
    GetInstanceRequest,
    GetInstanceSettingRequest,
    GetInstanceTemplateRequest,
    GetInstantSnapshotRequest,
    GetInterconnectAttachmentGroupRequest,
    GetInterconnectAttachmentRequest,
    GetInterconnectGroupRequest,
    GetInterconnectLocationRequest,
    GetInterconnectRemoteLocationRequest,
    GetInterconnectRequest,
    GetLicenseCodeRequest,
    GetLicenseRequest,
    GetMachineImageRequest,
    GetMachineTypeRequest,
    GetMacsecConfigInterconnectRequest,
    GetNatIpInfoRouterRequest,
    GetNatMappingInfoRoutersRequest,
    GetNetworkAttachmentRequest,
    GetNetworkEdgeSecurityServiceRequest,
    GetNetworkEndpointGroupRequest,
    GetNetworkFirewallPolicyRequest,
    GetNetworkProfileRequest,
    GetNetworkRequest,
    GetNodeGroupRequest,
    GetNodeTemplateRequest,
    GetNodeTypeRequest,
    GetOperationalStatusInterconnectAttachmentGroupRequest,
    GetOperationalStatusInterconnectGroupRequest,
    GetPacketMirroringRequest,
    GetPacketMirroringRuleNetworkFirewallPolicyRequest,
    GetProjectRequest,
    GetPublicAdvertisedPrefixeRequest,
    GetPublicDelegatedPrefixeRequest,
    GetRegionAutoscalerRequest,
    GetRegionBackendServiceRequest,
    GetRegionCommitmentRequest,
    GetRegionDiskRequest,
    GetRegionDiskTypeRequest,
    GetRegionHealthCheckRequest,
    GetRegionHealthCheckServiceRequest,
    GetRegionInstanceGroupManagerRequest,
    GetRegionInstanceGroupRequest,
    GetRegionInstanceTemplateRequest,
    GetRegionInstantSnapshotRequest,
    GetRegionNetworkEndpointGroupRequest,
    GetRegionNetworkFirewallPolicyRequest,
    GetRegionNotificationEndpointRequest,
    GetRegionOperationRequest,
    GetRegionRequest,
    GetRegionSecurityPolicyRequest,
    GetRegionSslCertificateRequest,
    GetRegionSslPolicyRequest,
    GetRegionTargetHttpProxyRequest,
    GetRegionTargetHttpsProxyRequest,
    GetRegionTargetTcpProxyRequest,
    GetRegionUrlMapRequest,
    GetReservationBlockRequest,
    GetReservationRequest,
    GetReservationSubBlockRequest,
    GetResourcePolicyRequest,
    GetRoutePolicyRouterRequest,
    GetRouteRequest,
    GetRouterRequest,
    GetRouterStatusRouterRequest,
    GetRuleFirewallPolicyRequest,
    GetRuleNetworkFirewallPolicyRequest,
    GetRuleRegionNetworkFirewallPolicyRequest,
    GetRuleRegionSecurityPolicyRequest,
    GetRuleSecurityPolicyRequest,
    GetScreenshotInstanceRequest,
    GetSecurityPolicyRequest,
    GetSerialPortOutputInstanceRequest,
    GetServiceAttachmentRequest,
    GetShieldedInstanceIdentityInstanceRequest,
    GetSnapshotRequest,
    GetSnapshotSettingRequest,
    GetSslCertificateRequest,
    GetSslPolicyRequest,
    GetStatusVpnGatewayRequest,
    GetStoragePoolRequest,
    GetStoragePoolTypeRequest,
    GetSubnetworkRequest,
    GetTargetGrpcProxyRequest,
    GetTargetHttpProxyRequest,
    GetTargetHttpsProxyRequest,
    GetTargetInstanceRequest,
    GetTargetPoolRequest,
    GetTargetSslProxyRequest,
    GetTargetTcpProxyRequest,
    GetTargetVpnGatewayRequest,
    GetUrlMapRequest,
    GetVpnGatewayRequest,
    GetVpnTunnelRequest,
    GetXpnHostProjectRequest,
    GetXpnResourcesProjectsRequest,
    GetZoneOperationRequest,
    GetZoneRequest,
    GlobalAddressesMoveRequest,
    GlobalNetworkEndpointGroupsAttachEndpointsRequest,
    GlobalNetworkEndpointGroupsDetachEndpointsRequest,
    GlobalOrganizationSetPolicyRequest,
    GlobalSetLabelsRequest,
    GlobalSetPolicyRequest,
    GroupMaintenanceInfo,
    GRPCHealthCheck,
    GuestAttributes,
    GuestAttributesEntry,
    GuestAttributesValue,
    GuestOsFeature,
    HealthCheck,
    HealthCheckList,
    HealthCheckLogConfig,
    HealthCheckReference,
    HealthChecksAggregatedList,
    HealthCheckService,
    HealthCheckServiceReference,
    HealthCheckServicesList,
    HealthChecksScopedList,
    HealthStatus,
    HealthStatusForNetworkEndpoint,
    Help,
    HelpLink,
    HostRule,
    HTTP2HealthCheck,
    HttpFaultAbort,
    HttpFaultDelay,
    HttpFaultInjection,
    HttpHeaderAction,
    HttpHeaderMatch,
    HttpHeaderOption,
    HTTPHealthCheck,
    HttpQueryParameterMatch,
    HttpRedirectAction,
    HttpRetryPolicy,
    HttpRouteAction,
    HttpRouteRule,
    HttpRouteRuleMatch,
    HTTPSHealthCheck,
    Image,
    ImageFamilyView,
    ImageList,
    InitialStateConfig,
    InsertAddressRequest,
    InsertAutoscalerRequest,
    InsertBackendBucketRequest,
    InsertBackendServiceRequest,
    InsertDiskRequest,
    InsertExternalVpnGatewayRequest,
    InsertFirewallPolicyRequest,
    InsertFirewallRequest,
    InsertForwardingRuleRequest,
    InsertGlobalAddressRequest,
    InsertGlobalForwardingRuleRequest,
    InsertGlobalNetworkEndpointGroupRequest,
    InsertGlobalPublicDelegatedPrefixeRequest,
    InsertHealthCheckRequest,
    InsertImageRequest,
    InsertInstanceGroupManagerRequest,
    InsertInstanceGroupManagerResizeRequestRequest,
    InsertInstanceGroupRequest,
    InsertInstanceRequest,
    InsertInstanceTemplateRequest,
    InsertInstantSnapshotRequest,
    InsertInterconnectAttachmentGroupRequest,
    InsertInterconnectAttachmentRequest,
    InsertInterconnectGroupRequest,
    InsertInterconnectRequest,
    InsertLicenseRequest,
    InsertMachineImageRequest,
    InsertNetworkAttachmentRequest,
    InsertNetworkEdgeSecurityServiceRequest,
    InsertNetworkEndpointGroupRequest,
    InsertNetworkFirewallPolicyRequest,
    InsertNetworkRequest,
    InsertNodeGroupRequest,
    InsertNodeTemplateRequest,
    InsertPacketMirroringRequest,
    InsertPublicAdvertisedPrefixeRequest,
    InsertPublicDelegatedPrefixeRequest,
    InsertRegionAutoscalerRequest,
    InsertRegionBackendServiceRequest,
    InsertRegionCommitmentRequest,
    InsertRegionDiskRequest,
    InsertRegionHealthCheckRequest,
    InsertRegionHealthCheckServiceRequest,
    InsertRegionInstanceGroupManagerRequest,
    InsertRegionInstanceTemplateRequest,
    InsertRegionInstantSnapshotRequest,
    InsertRegionNetworkEndpointGroupRequest,
    InsertRegionNetworkFirewallPolicyRequest,
    InsertRegionNotificationEndpointRequest,
    InsertRegionSecurityPolicyRequest,
    InsertRegionSslCertificateRequest,
    InsertRegionSslPolicyRequest,
    InsertRegionTargetHttpProxyRequest,
    InsertRegionTargetHttpsProxyRequest,
    InsertRegionTargetTcpProxyRequest,
    InsertRegionUrlMapRequest,
    InsertReservationRequest,
    InsertResourcePolicyRequest,
    InsertRouteRequest,
    InsertRouterRequest,
    InsertSecurityPolicyRequest,
    InsertServiceAttachmentRequest,
    InsertSnapshotRequest,
    InsertSslCertificateRequest,
    InsertSslPolicyRequest,
    InsertStoragePoolRequest,
    InsertSubnetworkRequest,
    InsertTargetGrpcProxyRequest,
    InsertTargetHttpProxyRequest,
    InsertTargetHttpsProxyRequest,
    InsertTargetInstanceRequest,
    InsertTargetPoolRequest,
    InsertTargetSslProxyRequest,
    InsertTargetTcpProxyRequest,
    InsertTargetVpnGatewayRequest,
    InsertUrlMapRequest,
    InsertVpnGatewayRequest,
    InsertVpnTunnelRequest,
    Instance,
    InstanceAggregatedList,
    InstanceConsumptionData,
    InstanceConsumptionInfo,
    InstanceGroup,
    InstanceGroupAggregatedList,
    InstanceGroupList,
    InstanceGroupManager,
    InstanceGroupManagerActionsSummary,
    InstanceGroupManagerAggregatedList,
    InstanceGroupManagerAllInstancesConfig,
    InstanceGroupManagerAutoHealingPolicy,
    InstanceGroupManagerInstanceFlexibilityPolicy,
    InstanceGroupManagerInstanceFlexibilityPolicyInstanceSelection,
    InstanceGroupManagerInstanceLifecyclePolicy,
    InstanceGroupManagerList,
    InstanceGroupManagerResizeRequest,
    InstanceGroupManagerResizeRequestsListResponse,
    InstanceGroupManagerResizeRequestStatus,
    InstanceGroupManagerResizeRequestStatusLastAttempt,
    InstanceGroupManagerResourcePolicies,
    InstanceGroupManagersAbandonInstancesRequest,
    InstanceGroupManagersApplyUpdatesRequest,
    InstanceGroupManagersCreateInstancesRequest,
    InstanceGroupManagersDeleteInstancesRequest,
    InstanceGroupManagersDeletePerInstanceConfigsReq,
    InstanceGroupManagersListErrorsResponse,
    InstanceGroupManagersListManagedInstancesResponse,
    InstanceGroupManagersListPerInstanceConfigsResp,
    InstanceGroupManagersPatchPerInstanceConfigsReq,
    InstanceGroupManagersRecreateInstancesRequest,
    InstanceGroupManagersResumeInstancesRequest,
    InstanceGroupManagersScopedList,
    InstanceGroupManagersSetInstanceTemplateRequest,
    InstanceGroupManagersSetTargetPoolsRequest,
    InstanceGroupManagersStartInstancesRequest,
    InstanceGroupManagersStopInstancesRequest,
    InstanceGroupManagersSuspendInstancesRequest,
    InstanceGroupManagerStandbyPolicy,
    InstanceGroupManagerStatus,
    InstanceGroupManagerStatusAllInstancesConfig,
    InstanceGroupManagerStatusStateful,
    InstanceGroupManagerStatusStatefulPerInstanceConfigs,
    InstanceGroupManagerStatusVersionTarget,
    InstanceGroupManagersUpdatePerInstanceConfigsReq,
    InstanceGroupManagerUpdatePolicy,
    InstanceGroupManagerVersion,
    InstanceGroupsAddInstancesRequest,
    InstanceGroupsListInstances,
    InstanceGroupsListInstancesRequest,
    InstanceGroupsRemoveInstancesRequest,
    InstanceGroupsScopedList,
    InstanceGroupsSetNamedPortsRequest,
    InstanceList,
    InstanceListReferrers,
    InstanceManagedByIgmError,
    InstanceManagedByIgmErrorInstanceActionDetails,
    InstanceManagedByIgmErrorManagedInstanceError,
    InstanceMoveRequest,
    InstanceParams,
    InstanceProperties,
    InstancePropertiesPatch,
    InstanceReference,
    InstancesAddResourcePoliciesRequest,
    InstancesBulkInsertOperationMetadata,
    InstanceSettings,
    InstanceSettingsMetadata,
    InstancesGetEffectiveFirewallsResponse,
    InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy,
    InstancesRemoveResourcePoliciesRequest,
    InstancesReportHostAsFaultyRequest,
    InstancesReportHostAsFaultyRequestFaultReason,
    InstancesScopedList,
    InstancesSetLabelsRequest,
    InstancesSetMachineResourcesRequest,
    InstancesSetMachineTypeRequest,
    InstancesSetMinCpuPlatformRequest,
    InstancesSetNameRequest,
    InstancesSetSecurityPolicyRequest,
    InstancesSetServiceAccountRequest,
    InstancesStartWithEncryptionKeyRequest,
    InstanceTemplate,
    InstanceTemplateAggregatedList,
    InstanceTemplateList,
    InstanceTemplatesScopedList,
    InstanceWithNamedPorts,
    InstantSnapshot,
    InstantSnapshotAggregatedList,
    InstantSnapshotList,
    InstantSnapshotResourceStatus,
    InstantSnapshotsScopedList,
    Int64RangeMatch,
    Interconnect,
    InterconnectApplicationAwareInterconnect,
    InterconnectApplicationAwareInterconnectBandwidthPercentage,
    InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy,
    InterconnectApplicationAwareInterconnectStrictPriorityPolicy,
    InterconnectAttachment,
    InterconnectAttachmentAggregatedList,
    InterconnectAttachmentConfigurationConstraints,
    InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange,
    InterconnectAttachmentGroup,
    InterconnectAttachmentGroupAttachment,
    InterconnectAttachmentGroupConfigured,
    InterconnectAttachmentGroupConfiguredAvailabilitySLA,
    InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers,
    InterconnectAttachmentGroupIntent,
    InterconnectAttachmentGroupLogicalStructure,
    InterconnectAttachmentGroupLogicalStructureRegion,
    InterconnectAttachmentGroupLogicalStructureRegionMetro,
    InterconnectAttachmentGroupLogicalStructureRegionMetroFacility,
    InterconnectAttachmentGroupLogicalStructureRegionMetroFacilityZone,
    InterconnectAttachmentGroupsGetOperationalStatusResponse,
    InterconnectAttachmentGroupsListResponse,
    InterconnectAttachmentGroupsOperationalStatus,
    InterconnectAttachmentGroupsOperationalStatusAttachmentStatus,
    InterconnectAttachmentList,
    InterconnectAttachmentPartnerMetadata,
    InterconnectAttachmentPrivateInfo,
    InterconnectAttachmentsScopedList,
    InterconnectCircuitInfo,
    InterconnectDiagnostics,
    InterconnectDiagnosticsARPEntry,
    InterconnectDiagnosticsLinkLACPStatus,
    InterconnectDiagnosticsLinkOpticalPower,
    InterconnectDiagnosticsLinkStatus,
    InterconnectDiagnosticsMacsecStatus,
    InterconnectGroup,
    InterconnectGroupConfigured,
    InterconnectGroupConfiguredTopologyCapability,
    InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers,
    InterconnectGroupIntent,
    InterconnectGroupInterconnect,
    InterconnectGroupPhysicalStructure,
    InterconnectGroupPhysicalStructureMetros,
    InterconnectGroupPhysicalStructureMetrosFacilities,
    InterconnectGroupPhysicalStructureMetrosFacilitiesZones,
    InterconnectGroupsCreateMembers,
    InterconnectGroupsCreateMembersInterconnectInput,
    InterconnectGroupsCreateMembersRequest,
    InterconnectGroupsGetOperationalStatusResponse,
    InterconnectGroupsListResponse,
    InterconnectGroupsOperationalStatus,
    InterconnectGroupsOperationalStatusInterconnectStatus,
    InterconnectList,
    InterconnectLocation,
    InterconnectLocationList,
    InterconnectLocationRegionInfo,
    InterconnectMacsec,
    InterconnectMacsecConfig,
    InterconnectMacsecConfigPreSharedKey,
    InterconnectMacsecPreSharedKey,
    InterconnectOutageNotification,
    InterconnectRemoteLocation,
    InterconnectRemoteLocationConstraints,
    InterconnectRemoteLocationConstraintsSubnetLengthRange,
    InterconnectRemoteLocationList,
    InterconnectRemoteLocationPermittedConnections,
    InterconnectsGetDiagnosticsResponse,
    InterconnectsGetMacsecConfigResponse,
    InvalidateCacheUrlMapRequest,
    Items,
    License,
    LicenseCode,
    LicenseCodeLicenseAlias,
    LicenseResourceCommitment,
    LicenseResourceRequirements,
    LicensesListResponse,
    ListAcceleratorTypesRequest,
    ListAddressesRequest,
    ListAssociationsFirewallPolicyRequest,
    ListAutoscalersRequest,
    ListAvailableFeaturesRegionSslPoliciesRequest,
    ListAvailableFeaturesSslPoliciesRequest,
    ListBackendBucketsRequest,
    ListBackendServicesRequest,
    ListBgpRoutesRoutersRequest,
    ListDisksRequest,
    ListDisksStoragePoolsRequest,
    ListDiskTypesRequest,
    ListErrorsInstanceGroupManagersRequest,
    ListErrorsRegionInstanceGroupManagersRequest,
    ListExternalVpnGatewaysRequest,
    ListFirewallPoliciesRequest,
    ListFirewallsRequest,
    ListForwardingRulesRequest,
    ListGlobalAddressesRequest,
    ListGlobalForwardingRulesRequest,
    ListGlobalNetworkEndpointGroupsRequest,
    ListGlobalOperationsRequest,
    ListGlobalOrganizationOperationsRequest,
    ListGlobalPublicDelegatedPrefixesRequest,
    ListHealthChecksRequest,
    ListImagesRequest,
    ListInstanceGroupManagerResizeRequestsRequest,
    ListInstanceGroupManagersRequest,
    ListInstanceGroupsRequest,
    ListInstancesInstanceGroupsRequest,
    ListInstancesRegionInstanceGroupsRequest,
    ListInstancesRequest,
    ListInstanceTemplatesRequest,
    ListInstantSnapshotsRequest,
    ListInterconnectAttachmentGroupsRequest,
    ListInterconnectAttachmentsRequest,
    ListInterconnectGroupsRequest,
    ListInterconnectLocationsRequest,
    ListInterconnectRemoteLocationsRequest,
    ListInterconnectsRequest,
    ListLicensesRequest,
    ListMachineImagesRequest,
    ListMachineTypesRequest,
    ListManagedInstancesInstanceGroupManagersRequest,
    ListManagedInstancesRegionInstanceGroupManagersRequest,
    ListNetworkAttachmentsRequest,
    ListNetworkEndpointGroupsRequest,
    ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest,
    ListNetworkEndpointsNetworkEndpointGroupsRequest,
    ListNetworkEndpointsRegionNetworkEndpointGroupsRequest,
    ListNetworkFirewallPoliciesRequest,
    ListNetworkProfilesRequest,
    ListNetworksRequest,
    ListNodeGroupsRequest,
    ListNodesNodeGroupsRequest,
    ListNodeTemplatesRequest,
    ListNodeTypesRequest,
    ListPacketMirroringsRequest,
    ListPeeringRoutesNetworksRequest,
    ListPerInstanceConfigsInstanceGroupManagersRequest,
    ListPerInstanceConfigsRegionInstanceGroupManagersRequest,
    ListPreconfiguredExpressionSetsSecurityPoliciesRequest,
    ListPublicAdvertisedPrefixesRequest,
    ListPublicDelegatedPrefixesRequest,
    ListReferrersInstancesRequest,
    ListRegionAutoscalersRequest,
    ListRegionBackendServicesRequest,
    ListRegionCommitmentsRequest,
    ListRegionDisksRequest,
    ListRegionDiskTypesRequest,
    ListRegionHealthCheckServicesRequest,
    ListRegionHealthChecksRequest,
    ListRegionInstanceGroupManagersRequest,
    ListRegionInstanceGroupsRequest,
    ListRegionInstanceTemplatesRequest,
    ListRegionInstantSnapshotsRequest,
    ListRegionNetworkEndpointGroupsRequest,
    ListRegionNetworkFirewallPoliciesRequest,
    ListRegionNotificationEndpointsRequest,
    ListRegionOperationsRequest,
    ListRegionSecurityPoliciesRequest,
    ListRegionsRequest,
    ListRegionSslCertificatesRequest,
    ListRegionSslPoliciesRequest,
    ListRegionTargetHttpProxiesRequest,
    ListRegionTargetHttpsProxiesRequest,
    ListRegionTargetTcpProxiesRequest,
    ListRegionUrlMapsRequest,
    ListRegionZonesRequest,
    ListReservationBlocksRequest,
    ListReservationsRequest,
    ListReservationSubBlocksRequest,
    ListResourcePoliciesRequest,
    ListRoutePoliciesRoutersRequest,
    ListRoutersRequest,
    ListRoutesRequest,
    ListSecurityPoliciesRequest,
    ListServiceAttachmentsRequest,
    ListSnapshotsRequest,
    ListSslCertificatesRequest,
    ListSslPoliciesRequest,
    ListStoragePoolsRequest,
    ListStoragePoolTypesRequest,
    ListSubnetworksRequest,
    ListTargetGrpcProxiesRequest,
    ListTargetHttpProxiesRequest,
    ListTargetHttpsProxiesRequest,
    ListTargetInstancesRequest,
    ListTargetPoolsRequest,
    ListTargetSslProxiesRequest,
    ListTargetTcpProxiesRequest,
    ListTargetVpnGatewaysRequest,
    ListUrlMapsRequest,
    ListUsableBackendServicesRequest,
    ListUsableRegionBackendServicesRequest,
    ListUsableSubnetworksRequest,
    ListVpnGatewaysRequest,
    ListVpnTunnelsRequest,
    ListXpnHostsProjectsRequest,
    ListZoneOperationsRequest,
    ListZonesRequest,
    LocalDisk,
    LocalizedMessage,
    LocationPolicy,
    LocationPolicyLocation,
    LocationPolicyLocationConstraints,
    MachineImage,
    MachineImageList,
    MachineType,
    MachineTypeAggregatedList,
    MachineTypeList,
    MachineTypesScopedList,
    ManagedInstance,
    ManagedInstanceInstanceHealth,
    ManagedInstanceLastAttempt,
    ManagedInstanceLastAttemptErrors,
    ManagedInstancePropertiesFromFlexibilityPolicy,
    ManagedInstanceVersion,
    Metadata,
    MetadataFilter,
    MetadataFilterLabelMatch,
    MoveAddressRequest,
    MoveDiskProjectRequest,
    MoveFirewallPolicyRequest,
    MoveGlobalAddressRequest,
    MoveInstanceProjectRequest,
    NamedPort,
    NatIpInfo,
    NatIpInfoNatIpInfoMapping,
    NatIpInfoResponse,
    Network,
    NetworkAttachment,
    NetworkAttachmentAggregatedList,
    NetworkAttachmentConnectedEndpoint,
    NetworkAttachmentList,
    NetworkAttachmentsScopedList,
    NetworkEdgeSecurityService,
    NetworkEdgeSecurityServiceAggregatedList,
    NetworkEdgeSecurityServicesScopedList,
    NetworkEndpoint,
    NetworkEndpointGroup,
    NetworkEndpointGroupAggregatedList,
    NetworkEndpointGroupAppEngine,
    NetworkEndpointGroupCloudFunction,
    NetworkEndpointGroupCloudRun,
    NetworkEndpointGroupList,
    NetworkEndpointGroupPscData,
    NetworkEndpointGroupsAttachEndpointsRequest,
    NetworkEndpointGroupsDetachEndpointsRequest,
    NetworkEndpointGroupsListEndpointsRequest,
    NetworkEndpointGroupsListNetworkEndpoints,
    NetworkEndpointGroupsScopedList,
    NetworkEndpointWithHealthStatus,
    NetworkFirewallPolicyAggregatedList,
    NetworkInterface,
    NetworkList,
    NetworkParams,
    NetworkPeering,
    NetworkPeeringConnectionStatus,
    NetworkPeeringConnectionStatusConsensusState,
    NetworkPeeringConnectionStatusTrafficConfiguration,
    NetworkPerformanceConfig,
    NetworkProfile,
    NetworkProfileLocation,
    NetworkProfileNetworkFeatures,
    NetworkProfilesListResponse,
    NetworkRoutingConfig,
    NetworksAddPeeringRequest,
    NetworksGetEffectiveFirewallsResponse,
    NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy,
    NetworksRemovePeeringRequest,
    NetworksRequestRemovePeeringRequest,
    NetworksUpdatePeeringRequest,
    NodeGroup,
    NodeGroupAggregatedList,
    NodeGroupAutoscalingPolicy,
    NodeGroupList,
    NodeGroupMaintenanceWindow,
    NodeGroupNode,
    NodeGroupsAddNodesRequest,
    NodeGroupsDeleteNodesRequest,
    NodeGroupsListNodes,
    NodeGroupsPerformMaintenanceRequest,
    NodeGroupsScopedList,
    NodeGroupsSetNodeTemplateRequest,
    NodeGroupsSimulateMaintenanceEventRequest,
    NodeTemplate,
    NodeTemplateAggregatedList,
    NodeTemplateList,
    NodeTemplateNodeTypeFlexibility,
    NodeTemplatesScopedList,
    NodeType,
    NodeTypeAggregatedList,
    NodeTypeList,
    NodeTypesScopedList,
    NotificationEndpoint,
    NotificationEndpointGrpcSettings,
    NotificationEndpointList,
    Operation,
    OperationAggregatedList,
    OperationList,
    OperationsScopedList,
    OutlierDetection,
    PacketIntervals,
    PacketMirroring,
    PacketMirroringAggregatedList,
    PacketMirroringFilter,
    PacketMirroringForwardingRuleInfo,
    PacketMirroringList,
    PacketMirroringMirroredResourceInfo,
    PacketMirroringMirroredResourceInfoInstanceInfo,
    PacketMirroringMirroredResourceInfoSubnetInfo,
    PacketMirroringNetworkInfo,
    PacketMirroringsScopedList,
    PatchAutoscalerRequest,
    PatchBackendBucketRequest,
    PatchBackendServiceRequest,
    PatchFirewallPolicyRequest,
    PatchFirewallRequest,
    PatchForwardingRuleRequest,
    PatchGlobalForwardingRuleRequest,
    PatchGlobalPublicDelegatedPrefixeRequest,
    PatchHealthCheckRequest,
    PatchImageRequest,
    PatchInstanceGroupManagerRequest,
    PatchInstanceSettingRequest,
    PatchInterconnectAttachmentGroupRequest,
    PatchInterconnectAttachmentRequest,
    PatchInterconnectGroupRequest,
    PatchInterconnectRequest,
    PatchNetworkAttachmentRequest,
    PatchNetworkEdgeSecurityServiceRequest,
    PatchNetworkFirewallPolicyRequest,
    PatchNetworkRequest,
    PatchNodeGroupRequest,
    PatchPacketMirroringRequest,
    PatchPacketMirroringRuleNetworkFirewallPolicyRequest,
    PatchPerInstanceConfigsInstanceGroupManagerRequest,
    PatchPerInstanceConfigsRegionInstanceGroupManagerRequest,
    PatchPublicAdvertisedPrefixeRequest,
    PatchPublicDelegatedPrefixeRequest,
    PatchRegionAutoscalerRequest,
    PatchRegionBackendServiceRequest,
    PatchRegionHealthCheckRequest,
    PatchRegionHealthCheckServiceRequest,
    PatchRegionInstanceGroupManagerRequest,
    PatchRegionNetworkFirewallPolicyRequest,
    PatchRegionSecurityPolicyRequest,
    PatchRegionSslPolicyRequest,
    PatchRegionTargetHttpsProxyRequest,
    PatchRegionUrlMapRequest,
    PatchResourcePolicyRequest,
    PatchRoutePolicyRouterRequest,
    PatchRouterRequest,
    PatchRuleFirewallPolicyRequest,
    PatchRuleNetworkFirewallPolicyRequest,
    PatchRuleRegionNetworkFirewallPolicyRequest,
    PatchRuleRegionSecurityPolicyRequest,
    PatchRuleSecurityPolicyRequest,
    PatchSecurityPolicyRequest,
    PatchServiceAttachmentRequest,
    PatchSnapshotSettingRequest,
    PatchSslPolicyRequest,
    PatchSubnetworkRequest,
    PatchTargetGrpcProxyRequest,
    PatchTargetHttpProxyRequest,
    PatchTargetHttpsProxyRequest,
    PatchUrlMapRequest,
    PathMatcher,
    PathRule,
    PerformMaintenanceInstanceRequest,
    PerformMaintenanceNodeGroupRequest,
    PerformMaintenanceReservationBlockRequest,
    PerformMaintenanceReservationRequest,
    PerformMaintenanceReservationSubBlockRequest,
    PerInstanceConfig,
    Policy,
    PreconfiguredWafSet,
    PreservedState,
    PreservedStatePreservedDisk,
    PreservedStatePreservedNetworkIp,
    PreservedStatePreservedNetworkIpIpAddress,
    PreviewRouterRequest,
    Project,
    ProjectsDisableXpnResourceRequest,
    ProjectsEnableXpnResourceRequest,
    ProjectsGetXpnResources,
    ProjectsListXpnHostsRequest,
    ProjectsSetCloudArmorTierRequest,
    ProjectsSetDefaultNetworkTierRequest,
    PublicAdvertisedPrefix,
    PublicAdvertisedPrefixList,
    PublicAdvertisedPrefixPublicDelegatedPrefix,
    PublicDelegatedPrefix,
    PublicDelegatedPrefixAggregatedList,
    PublicDelegatedPrefixesScopedList,
    PublicDelegatedPrefixList,
    PublicDelegatedPrefixPublicDelegatedSubPrefix,
    Quota,
    QuotaExceededInfo,
    QuotaStatusWarning,
    RawDisk,
    RecreateInstancesInstanceGroupManagerRequest,
    RecreateInstancesRegionInstanceGroupManagerRequest,
    Reference,
    Region,
    RegionAddressesMoveRequest,
    RegionAutoscalerList,
    RegionDisksAddResourcePoliciesRequest,
    RegionDisksRemoveResourcePoliciesRequest,
    RegionDisksResizeRequest,
    RegionDisksStartAsyncReplicationRequest,
    RegionDiskTypeList,
    RegionInstanceGroupList,
    RegionInstanceGroupManagerDeleteInstanceConfigReq,
    RegionInstanceGroupManagerList,
    RegionInstanceGroupManagerPatchInstanceConfigReq,
    RegionInstanceGroupManagersAbandonInstancesRequest,
    RegionInstanceGroupManagersApplyUpdatesRequest,
    RegionInstanceGroupManagersCreateInstancesRequest,
    RegionInstanceGroupManagersDeleteInstancesRequest,
    RegionInstanceGroupManagersListErrorsResponse,
    RegionInstanceGroupManagersListInstanceConfigsResp,
    RegionInstanceGroupManagersListInstancesResponse,
    RegionInstanceGroupManagersRecreateRequest,
    RegionInstanceGroupManagersResumeInstancesRequest,
    RegionInstanceGroupManagersSetTargetPoolsRequest,
    RegionInstanceGroupManagersSetTemplateRequest,
    RegionInstanceGroupManagersStartInstancesRequest,
    RegionInstanceGroupManagersStopInstancesRequest,
    RegionInstanceGroupManagersSuspendInstancesRequest,
    RegionInstanceGroupManagerUpdateInstanceConfigReq,
    RegionInstanceGroupsListInstances,
    RegionInstanceGroupsListInstancesRequest,
    RegionInstanceGroupsSetNamedPortsRequest,
    RegionList,
    RegionNetworkEndpointGroupsAttachEndpointsRequest,
    RegionNetworkEndpointGroupsDetachEndpointsRequest,
    RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse,
    RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy,
    RegionSetLabelsRequest,
    RegionSetPolicyRequest,
    RegionTargetHttpsProxiesSetSslCertificatesRequest,
    RegionUrlMapsValidateRequest,
    RemoveAssociationFirewallPolicyRequest,
    RemoveAssociationNetworkFirewallPolicyRequest,
    RemoveAssociationRegionNetworkFirewallPolicyRequest,
    RemoveHealthCheckTargetPoolRequest,
    RemoveInstancesInstanceGroupRequest,
    RemoveInstanceTargetPoolRequest,
    RemovePacketMirroringRuleNetworkFirewallPolicyRequest,
    RemovePeeringNetworkRequest,
    RemoveResourcePoliciesDiskRequest,
    RemoveResourcePoliciesInstanceRequest,
    RemoveResourcePoliciesRegionDiskRequest,
    RemoveRuleFirewallPolicyRequest,
    RemoveRuleNetworkFirewallPolicyRequest,
    RemoveRuleRegionNetworkFirewallPolicyRequest,
    RemoveRuleRegionSecurityPolicyRequest,
    RemoveRuleSecurityPolicyRequest,
    ReportHostAsFaultyInstanceRequest,
    RequestMirrorPolicy,
    RequestRemovePeeringNetworkRequest,
    Reservation,
    ReservationAdvancedDeploymentControl,
    ReservationAffinity,
    ReservationAggregatedList,
    ReservationBlock,
    ReservationBlockHealthInfo,
    ReservationBlockPhysicalTopology,
    ReservationBlockPhysicalTopologyInstance,
    ReservationBlockPhysicalTopologyInstancePhysicalHostTopology,
    ReservationBlocksGetResponse,
    ReservationBlocksListResponse,
    ReservationList,
    ReservationsBlocksPerformMaintenanceRequest,
    ReservationsPerformMaintenanceRequest,
    ReservationsResizeRequest,
    ReservationsScopedList,
    ReservationSubBlock,
    ReservationSubBlockHealthInfo,
    ReservationSubBlockPhysicalTopology,
    ReservationSubBlocksGetResponse,
    ReservationSubBlocksListResponse,
    ResetInstanceRequest,
    ResizeDiskRequest,
    ResizeInstanceGroupManagerRequest,
    ResizeRegionDiskRequest,
    ResizeRegionInstanceGroupManagerRequest,
    ResizeReservationRequest,
    ResourceCommitment,
    ResourceGroupReference,
    ResourcePoliciesScopedList,
    ResourcePolicy,
    ResourcePolicyAggregatedList,
    ResourcePolicyDailyCycle,
    ResourcePolicyDiskConsistencyGroupPolicy,
    ResourcePolicyGroupPlacementPolicy,
    ResourcePolicyHourlyCycle,
    ResourcePolicyInstanceSchedulePolicy,
    ResourcePolicyInstanceSchedulePolicySchedule,
    ResourcePolicyList,
    ResourcePolicyResourceStatus,
    ResourcePolicyResourceStatusInstanceSchedulePolicyStatus,
    ResourcePolicySnapshotSchedulePolicy,
    ResourcePolicySnapshotSchedulePolicyRetentionPolicy,
    ResourcePolicySnapshotSchedulePolicySchedule,
    ResourcePolicySnapshotSchedulePolicySnapshotProperties,
    ResourcePolicyWeeklyCycle,
    ResourcePolicyWeeklyCycleDayOfWeek,
    ResourcePolicyWorkloadPolicy,
    ResourceStatus,
    ResourceStatusPhysicalHostTopology,
    ResourceStatusScheduling,
    ResumeInstanceRequest,
    ResumeInstancesInstanceGroupManagerRequest,
    ResumeInstancesRegionInstanceGroupManagerRequest,
    Route,
    RouteAsPath,
    RouteList,
    RouteParams,
    RoutePolicy,
    RoutePolicyPolicyTerm,
    Router,
    RouterAdvertisedIpRange,
    RouterAggregatedList,
    RouterBgp,
    RouterBgpPeer,
    RouterBgpPeerBfd,
    RouterBgpPeerCustomLearnedIpRange,
    RouterInterface,
    RouterList,
    RouterMd5AuthenticationKey,
    RouterNat,
    RouterNatLogConfig,
    RouterNatRule,
    RouterNatRuleAction,
    RouterNatSubnetworkToNat,
    RouterNatSubnetworkToNat64,
    RoutersGetRoutePolicyResponse,
    RoutersListBgpRoutes,
    RoutersListRoutePolicies,
    RoutersPreviewResponse,
    RoutersScopedList,
    RouterStatus,
    RouterStatusBgpPeerStatus,
    RouterStatusNatStatus,
    RouterStatusNatStatusNatRuleStatus,
    RouterStatusResponse,
    SavedAttachedDisk,
    SavedDisk,
    ScalingScheduleStatus,
    Scheduling,
    SchedulingNodeAffinity,
    SchedulingOnInstanceStopAction,
    Screenshot,
    SecurityPoliciesAggregatedList,
    SecurityPoliciesListPreconfiguredExpressionSetsResponse,
    SecurityPoliciesScopedList,
    SecurityPoliciesWafConfig,
    SecurityPolicy,
    SecurityPolicyAdaptiveProtectionConfig,
    SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig,
    SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig,
    SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfigTrafficGranularityConfig,
    SecurityPolicyAdvancedOptionsConfig,
    SecurityPolicyAdvancedOptionsConfigJsonCustomConfig,
    SecurityPolicyDdosProtectionConfig,
    SecurityPolicyList,
    SecurityPolicyRecaptchaOptionsConfig,
    SecurityPolicyReference,
    SecurityPolicyRule,
    SecurityPolicyRuleHttpHeaderAction,
    SecurityPolicyRuleHttpHeaderActionHttpHeaderOption,
    SecurityPolicyRuleMatcher,
    SecurityPolicyRuleMatcherConfig,
    SecurityPolicyRuleMatcherExprOptions,
    SecurityPolicyRuleMatcherExprOptionsRecaptchaOptions,
    SecurityPolicyRuleNetworkMatcher,
    SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch,
    SecurityPolicyRulePreconfiguredWafConfig,
    SecurityPolicyRulePreconfiguredWafConfigExclusion,
    SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams,
    SecurityPolicyRuleRateLimitOptions,
    SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig,
    SecurityPolicyRuleRateLimitOptionsThreshold,
    SecurityPolicyRuleRedirectOptions,
    SecurityPolicyUserDefinedField,
    SecuritySettings,
    SendDiagnosticInterruptInstanceRequest,
    SendDiagnosticInterruptInstanceResponse,
    SerialPortOutput,
    ServerBinding,
    ServiceAccount,
    ServiceAttachment,
    ServiceAttachmentAggregatedList,
    ServiceAttachmentConnectedEndpoint,
    ServiceAttachmentConsumerProjectLimit,
    ServiceAttachmentList,
    ServiceAttachmentsScopedList,
    SetBackendServiceTargetSslProxyRequest,
    SetBackendServiceTargetTcpProxyRequest,
    SetBackupTargetPoolRequest,
    SetCertificateMapTargetHttpsProxyRequest,
    SetCertificateMapTargetSslProxyRequest,
    SetCloudArmorTierProjectRequest,
    SetCommonInstanceMetadataOperationMetadata,
    SetCommonInstanceMetadataOperationMetadataPerLocationOperationInfo,
    SetCommonInstanceMetadataProjectRequest,
    SetDefaultNetworkTierProjectRequest,
    SetDeletionProtectionInstanceRequest,
    SetDiskAutoDeleteInstanceRequest,
    SetEdgeSecurityPolicyBackendBucketRequest,
    SetEdgeSecurityPolicyBackendServiceRequest,
    SetIamPolicyBackendBucketRequest,
    SetIamPolicyBackendServiceRequest,
    SetIamPolicyDiskRequest,
    SetIamPolicyFirewallPolicyRequest,
    SetIamPolicyImageRequest,
    SetIamPolicyInstanceRequest,
    SetIamPolicyInstanceTemplateRequest,
    SetIamPolicyInstantSnapshotRequest,
    SetIamPolicyInterconnectAttachmentGroupRequest,
    SetIamPolicyInterconnectGroupRequest,
    SetIamPolicyLicenseRequest,
    SetIamPolicyMachineImageRequest,
    SetIamPolicyNetworkAttachmentRequest,
    SetIamPolicyNetworkFirewallPolicyRequest,
    SetIamPolicyNodeGroupRequest,
    SetIamPolicyNodeTemplateRequest,
    SetIamPolicyRegionBackendServiceRequest,
    SetIamPolicyRegionDiskRequest,
    SetIamPolicyRegionInstantSnapshotRequest,
    SetIamPolicyRegionNetworkFirewallPolicyRequest,
    SetIamPolicyReservationRequest,
    SetIamPolicyResourcePolicyRequest,
    SetIamPolicyServiceAttachmentRequest,
    SetIamPolicySnapshotRequest,
    SetIamPolicyStoragePoolRequest,
    SetIamPolicySubnetworkRequest,
    SetInstanceTemplateInstanceGroupManagerRequest,
    SetInstanceTemplateRegionInstanceGroupManagerRequest,
    SetLabelsAddressRequest,
    SetLabelsDiskRequest,
    SetLabelsExternalVpnGatewayRequest,
    SetLabelsForwardingRuleRequest,
    SetLabelsGlobalAddressRequest,
    SetLabelsGlobalForwardingRuleRequest,
    SetLabelsImageRequest,
    SetLabelsInstanceRequest,
    SetLabelsInstantSnapshotRequest,
    SetLabelsInterconnectAttachmentRequest,
    SetLabelsInterconnectRequest,
    SetLabelsMachineImageRequest,
    SetLabelsRegionDiskRequest,
    SetLabelsRegionInstantSnapshotRequest,
    SetLabelsRegionSecurityPolicyRequest,
    SetLabelsSecurityPolicyRequest,
    SetLabelsSnapshotRequest,
    SetLabelsTargetVpnGatewayRequest,
    SetLabelsVpnGatewayRequest,
    SetLabelsVpnTunnelRequest,
    SetMachineResourcesInstanceRequest,
    SetMachineTypeInstanceRequest,
    SetMetadataInstanceRequest,
    SetMinCpuPlatformInstanceRequest,
    SetNamedPortsInstanceGroupRequest,
    SetNamedPortsRegionInstanceGroupRequest,
    SetNameInstanceRequest,
    SetNodeTemplateNodeGroupRequest,
    SetPrivateIpGoogleAccessSubnetworkRequest,
    SetProxyHeaderTargetSslProxyRequest,
    SetProxyHeaderTargetTcpProxyRequest,
    SetQuicOverrideTargetHttpsProxyRequest,
    SetSchedulingInstanceRequest,
    SetSecurityPolicyBackendServiceRequest,
    SetSecurityPolicyInstanceRequest,
    SetSecurityPolicyRegionBackendServiceRequest,
    SetSecurityPolicyTargetInstanceRequest,
    SetSecurityPolicyTargetPoolRequest,
    SetServiceAccountInstanceRequest,
    SetShieldedInstanceIntegrityPolicyInstanceRequest,
    SetSslCertificatesRegionTargetHttpsProxyRequest,
    SetSslCertificatesTargetHttpsProxyRequest,
    SetSslCertificatesTargetSslProxyRequest,
    SetSslPolicyTargetHttpsProxyRequest,
    SetSslPolicyTargetSslProxyRequest,
    SetTagsInstanceRequest,
    SetTargetForwardingRuleRequest,
    SetTargetGlobalForwardingRuleRequest,
    SetTargetPoolsInstanceGroupManagerRequest,
    SetTargetPoolsRegionInstanceGroupManagerRequest,
    SetUrlMapRegionTargetHttpProxyRequest,
    SetUrlMapRegionTargetHttpsProxyRequest,
    SetUrlMapTargetHttpProxyRequest,
    SetUrlMapTargetHttpsProxyRequest,
    SetUsageExportBucketProjectRequest,
    ShareSettings,
    ShareSettingsProjectConfig,
    ShieldedInstanceConfig,
    ShieldedInstanceIdentity,
    ShieldedInstanceIdentityEntry,
    ShieldedInstanceIntegrityPolicy,
    SignedUrlKey,
    SimulateMaintenanceEventInstanceRequest,
    SimulateMaintenanceEventNodeGroupRequest,
    Snapshot,
    SnapshotList,
    SnapshotSettings,
    SnapshotSettingsStorageLocationSettings,
    SnapshotSettingsStorageLocationSettingsStorageLocationPreference,
    SourceDiskEncryptionKey,
    SourceInstanceParams,
    SourceInstanceProperties,
    SslCertificate,
    SslCertificateAggregatedList,
    SslCertificateList,
    SslCertificateManagedSslCertificate,
    SslCertificateSelfManagedSslCertificate,
    SslCertificatesScopedList,
    SSLHealthCheck,
    SslPoliciesAggregatedList,
    SslPoliciesList,
    SslPoliciesListAvailableFeaturesResponse,
    SslPoliciesScopedList,
    SslPolicy,
    SslPolicyReference,
    StartAsyncReplicationDiskRequest,
    StartAsyncReplicationRegionDiskRequest,
    StartInstanceRequest,
    StartInstancesInstanceGroupManagerRequest,
    StartInstancesRegionInstanceGroupManagerRequest,
    StartWithEncryptionKeyInstanceRequest,
    StatefulPolicy,
    StatefulPolicyPreservedState,
    StatefulPolicyPreservedStateDiskDevice,
    StatefulPolicyPreservedStateNetworkIp,
    Status,
    StopAsyncReplicationDiskRequest,
    StopAsyncReplicationRegionDiskRequest,
    StopGroupAsyncReplicationDiskRequest,
    StopGroupAsyncReplicationRegionDiskRequest,
    StopInstanceRequest,
    StopInstancesInstanceGroupManagerRequest,
    StopInstancesRegionInstanceGroupManagerRequest,
    StoragePool,
    StoragePoolAggregatedList,
    StoragePoolDisk,
    StoragePoolList,
    StoragePoolListDisks,
    StoragePoolResourceStatus,
    StoragePoolsScopedList,
    StoragePoolType,
    StoragePoolTypeAggregatedList,
    StoragePoolTypeList,
    StoragePoolTypesScopedList,
    Subnetwork,
    SubnetworkAggregatedList,
    SubnetworkList,
    SubnetworkLogConfig,
    SubnetworkParams,
    SubnetworkSecondaryRange,
    SubnetworksExpandIpCidrRangeRequest,
    SubnetworksScopedList,
    SubnetworksScopedWarning,
    SubnetworksSetPrivateIpGoogleAccessRequest,
    Subsetting,
    SuspendInstanceRequest,
    SuspendInstancesInstanceGroupManagerRequest,
    SuspendInstancesRegionInstanceGroupManagerRequest,
    SwitchToCustomModeNetworkRequest,
    Tags,
    TargetGrpcProxy,
    TargetGrpcProxyList,
    TargetHttpProxiesScopedList,
    TargetHttpProxy,
    TargetHttpProxyAggregatedList,
    TargetHttpProxyList,
    TargetHttpsProxiesScopedList,
    TargetHttpsProxiesSetCertificateMapRequest,
    TargetHttpsProxiesSetQuicOverrideRequest,
    TargetHttpsProxiesSetSslCertificatesRequest,
    TargetHttpsProxy,
    TargetHttpsProxyAggregatedList,
    TargetHttpsProxyList,
    TargetInstance,
    TargetInstanceAggregatedList,
    TargetInstanceList,
    TargetInstancesScopedList,
    TargetPool,
    TargetPoolAggregatedList,
    TargetPoolInstanceHealth,
    TargetPoolList,
    TargetPoolsAddHealthCheckRequest,
    TargetPoolsAddInstanceRequest,
    TargetPoolsRemoveHealthCheckRequest,
    TargetPoolsRemoveInstanceRequest,
    TargetPoolsScopedList,
    TargetReference,
    TargetSslProxiesSetBackendServiceRequest,
    TargetSslProxiesSetCertificateMapRequest,
    TargetSslProxiesSetProxyHeaderRequest,
    TargetSslProxiesSetSslCertificatesRequest,
    TargetSslProxy,
    TargetSslProxyList,
    TargetTcpProxiesScopedList,
    TargetTcpProxiesSetBackendServiceRequest,
    TargetTcpProxiesSetProxyHeaderRequest,
    TargetTcpProxy,
    TargetTcpProxyAggregatedList,
    TargetTcpProxyList,
    TargetVpnGateway,
    TargetVpnGatewayAggregatedList,
    TargetVpnGatewayList,
    TargetVpnGatewaysScopedList,
    TCPHealthCheck,
    TestFailure,
    TestIamPermissionsBackendBucketRequest,
    TestIamPermissionsBackendServiceRequest,
    TestIamPermissionsDiskRequest,
    TestIamPermissionsExternalVpnGatewayRequest,
    TestIamPermissionsFirewallPolicyRequest,
    TestIamPermissionsImageRequest,
    TestIamPermissionsInstanceRequest,
    TestIamPermissionsInstanceTemplateRequest,
    TestIamPermissionsInstantSnapshotRequest,
    TestIamPermissionsInterconnectAttachmentGroupRequest,
    TestIamPermissionsInterconnectGroupRequest,
    TestIamPermissionsLicenseCodeRequest,
    TestIamPermissionsLicenseRequest,
    TestIamPermissionsMachineImageRequest,
    TestIamPermissionsNetworkAttachmentRequest,
    TestIamPermissionsNetworkEndpointGroupRequest,
    TestIamPermissionsNetworkFirewallPolicyRequest,
    TestIamPermissionsNodeGroupRequest,
    TestIamPermissionsNodeTemplateRequest,
    TestIamPermissionsPacketMirroringRequest,
    TestIamPermissionsRegionBackendServiceRequest,
    TestIamPermissionsRegionDiskRequest,
    TestIamPermissionsRegionInstantSnapshotRequest,
    TestIamPermissionsRegionNetworkFirewallPolicyRequest,
    TestIamPermissionsReservationRequest,
    TestIamPermissionsResourcePolicyRequest,
    TestIamPermissionsServiceAttachmentRequest,
    TestIamPermissionsSnapshotRequest,
    TestIamPermissionsStoragePoolRequest,
    TestIamPermissionsSubnetworkRequest,
    TestIamPermissionsVpnGatewayRequest,
    TestPermissionsRequest,
    TestPermissionsResponse,
    Uint128,
    UpcomingMaintenance,
    UpdateAccessConfigInstanceRequest,
    UpdateAutoscalerRequest,
    UpdateBackendBucketRequest,
    UpdateBackendServiceRequest,
    UpdateDiskRequest,
    UpdateDisplayDeviceInstanceRequest,
    UpdateFirewallRequest,
    UpdateHealthCheckRequest,
    UpdateInstanceRequest,
    UpdateLicenseRequest,
    UpdateNetworkInterfaceInstanceRequest,
    UpdatePeeringNetworkRequest,
    UpdatePerInstanceConfigsInstanceGroupManagerRequest,
    UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest,
    UpdateRegionAutoscalerRequest,
    UpdateRegionBackendServiceRequest,
    UpdateRegionCommitmentRequest,
    UpdateRegionDiskRequest,
    UpdateRegionHealthCheckRequest,
    UpdateRegionUrlMapRequest,
    UpdateReservationRequest,
    UpdateRoutePolicyRouterRequest,
    UpdateRouterRequest,
    UpdateShieldedInstanceConfigInstanceRequest,
    UpdateStoragePoolRequest,
    UpdateUrlMapRequest,
    UrlMap,
    UrlMapList,
    UrlMapReference,
    UrlMapsAggregatedList,
    UrlMapsScopedList,
    UrlMapsValidateRequest,
    UrlMapsValidateResponse,
    UrlMapTest,
    UrlMapTestHeader,
    UrlMapValidationResult,
    UrlRewrite,
    UsableSubnetwork,
    UsableSubnetworksAggregatedList,
    UsableSubnetworkSecondaryRange,
    UsageExportLocation,
    ValidateRegionUrlMapRequest,
    ValidateUrlMapRequest,
    VmEndpointNatMappings,
    VmEndpointNatMappingsInterfaceNatMappings,
    VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings,
    VmEndpointNatMappingsList,
    VpnGateway,
    VpnGatewayAggregatedList,
    VpnGatewayList,
    VpnGatewaysGetStatusResponse,
    VpnGatewaysScopedList,
    VpnGatewayStatus,
    VpnGatewayStatusHighAvailabilityRequirementState,
    VpnGatewayStatusTunnel,
    VpnGatewayStatusVpnConnection,
    VpnGatewayVpnGatewayInterface,
    VpnTunnel,
    VpnTunnelAggregatedList,
    VpnTunnelList,
    VpnTunnelsScopedList,
    WafExpressionSet,
    WafExpressionSetExpression,
    WaitGlobalOperationRequest,
    WaitRegionOperationRequest,
    WaitZoneOperationRequest,
    Warning,
    Warnings,
    WeightedBackendService,
    WithdrawPublicAdvertisedPrefixeRequest,
    WithdrawPublicDelegatedPrefixeRequest,
    XpnHostList,
    XpnResourceId,
    Zone,
    ZoneList,
    ZoneSetLabelsRequest,
    ZoneSetPolicyRequest,
)

__all__ = (
    "AcceleratorTypesClient",
    "AddressesClient",
    "AutoscalersClient",
    "BackendBucketsClient",
    "BackendServicesClient",
    "DisksClient",
    "DiskTypesClient",
    "ExternalVpnGatewaysClient",
    "FirewallPoliciesClient",
    "FirewallsClient",
    "ForwardingRulesClient",
    "GlobalAddressesClient",
    "GlobalForwardingRulesClient",
    "GlobalNetworkEndpointGroupsClient",
    "GlobalOperationsClient",
    "GlobalOrganizationOperationsClient",
    "GlobalPublicDelegatedPrefixesClient",
    "HealthChecksClient",
    "ImageFamilyViewsClient",
    "ImagesClient",
    "InstanceGroupManagerResizeRequestsClient",
    "InstanceGroupManagersClient",
    "InstanceGroupsClient",
    "InstancesClient",
    "InstanceSettingsServiceClient",
    "InstanceTemplatesClient",
    "InstantSnapshotsClient",
    "InterconnectAttachmentGroupsClient",
    "InterconnectAttachmentsClient",
    "InterconnectGroupsClient",
    "InterconnectLocationsClient",
    "InterconnectRemoteLocationsClient",
    "InterconnectsClient",
    "LicenseCodesClient",
    "LicensesClient",
    "MachineImagesClient",
    "MachineTypesClient",
    "NetworkAttachmentsClient",
    "NetworkEdgeSecurityServicesClient",
    "NetworkEndpointGroupsClient",
    "NetworkFirewallPoliciesClient",
    "NetworkProfilesClient",
    "NetworksClient",
    "NodeGroupsClient",
    "NodeTemplatesClient",
    "NodeTypesClient",
    "PacketMirroringsClient",
    "ProjectsClient",
    "PublicAdvertisedPrefixesClient",
    "PublicDelegatedPrefixesClient",
    "RegionAutoscalersClient",
    "RegionBackendServicesClient",
    "RegionCommitmentsClient",
    "RegionDisksClient",
    "RegionDiskTypesClient",
    "RegionHealthChecksClient",
    "RegionHealthCheckServicesClient",
    "RegionInstanceGroupManagersClient",
    "RegionInstanceGroupsClient",
    "RegionInstancesClient",
    "RegionInstanceTemplatesClient",
    "RegionInstantSnapshotsClient",
    "RegionNetworkEndpointGroupsClient",
    "RegionNetworkFirewallPoliciesClient",
    "RegionNotificationEndpointsClient",
    "RegionOperationsClient",
    "RegionsClient",
    "RegionSecurityPoliciesClient",
    "RegionSslCertificatesClient",
    "RegionSslPoliciesClient",
    "RegionTargetHttpProxiesClient",
    "RegionTargetHttpsProxiesClient",
    "RegionTargetTcpProxiesClient",
    "RegionUrlMapsClient",
    "RegionZonesClient",
    "ReservationBlocksClient",
    "ReservationsClient",
    "ReservationSubBlocksClient",
    "ResourcePoliciesClient",
    "RoutersClient",
    "RoutesClient",
    "SecurityPoliciesClient",
    "ServiceAttachmentsClient",
    "SnapshotsClient",
    "SnapshotSettingsServiceClient",
    "SslCertificatesClient",
    "SslPoliciesClient",
    "StoragePoolsClient",
    "StoragePoolTypesClient",
    "SubnetworksClient",
    "TargetGrpcProxiesClient",
    "TargetHttpProxiesClient",
    "TargetHttpsProxiesClient",
    "TargetInstancesClient",
    "TargetPoolsClient",
    "TargetSslProxiesClient",
    "TargetTcpProxiesClient",
    "TargetVpnGatewaysClient",
    "UrlMapsClient",
    "VpnGatewaysClient",
    "VpnTunnelsClient",
    "ZoneOperationsClient",
    "ZonesClient",
    "AbandonInstancesInstanceGroupManagerRequest",
    "AbandonInstancesRegionInstanceGroupManagerRequest",
    "AcceleratorConfig",
    "Accelerators",
    "AcceleratorType",
    "AcceleratorTypeAggregatedList",
    "AcceleratorTypeList",
    "AcceleratorTypesScopedList",
    "AccessConfig",
    "AddAccessConfigInstanceRequest",
    "AddAssociationFirewallPolicyRequest",
    "AddAssociationNetworkFirewallPolicyRequest",
    "AddAssociationRegionNetworkFirewallPolicyRequest",
    "AddHealthCheckTargetPoolRequest",
    "AddInstancesInstanceGroupRequest",
    "AddInstanceTargetPoolRequest",
    "AddNodesNodeGroupRequest",
    "AddPacketMirroringRuleNetworkFirewallPolicyRequest",
    "AddPeeringNetworkRequest",
    "AddResourcePoliciesDiskRequest",
    "AddResourcePoliciesInstanceRequest",
    "AddResourcePoliciesRegionDiskRequest",
    "Address",
    "AddressAggregatedList",
    "AddressesScopedList",
    "AddressList",
    "AddRuleFirewallPolicyRequest",
    "AddRuleNetworkFirewallPolicyRequest",
    "AddRuleRegionNetworkFirewallPolicyRequest",
    "AddRuleRegionSecurityPolicyRequest",
    "AddRuleSecurityPolicyRequest",
    "AddSignedUrlKeyBackendBucketRequest",
    "AddSignedUrlKeyBackendServiceRequest",
    "AdvancedMachineFeatures",
    "AggregatedListAcceleratorTypesRequest",
    "AggregatedListAddressesRequest",
    "AggregatedListAutoscalersRequest",
    "AggregatedListBackendServicesRequest",
    "AggregatedListDisksRequest",
    "AggregatedListDiskTypesRequest",
    "AggregatedListForwardingRulesRequest",
    "AggregatedListGlobalOperationsRequest",
    "AggregatedListHealthChecksRequest",
    "AggregatedListInstanceGroupManagersRequest",
    "AggregatedListInstanceGroupsRequest",
    "AggregatedListInstancesRequest",
    "AggregatedListInstanceTemplatesRequest",
    "AggregatedListInstantSnapshotsRequest",
    "AggregatedListInterconnectAttachmentsRequest",
    "AggregatedListMachineTypesRequest",
    "AggregatedListNetworkAttachmentsRequest",
    "AggregatedListNetworkEdgeSecurityServicesRequest",
    "AggregatedListNetworkEndpointGroupsRequest",
    "AggregatedListNetworkFirewallPoliciesRequest",
    "AggregatedListNodeGroupsRequest",
    "AggregatedListNodeTemplatesRequest",
    "AggregatedListNodeTypesRequest",
    "AggregatedListPacketMirroringsRequest",
    "AggregatedListPublicDelegatedPrefixesRequest",
    "AggregatedListRegionCommitmentsRequest",
    "AggregatedListReservationsRequest",
    "AggregatedListResourcePoliciesRequest",
    "AggregatedListRoutersRequest",
    "AggregatedListSecurityPoliciesRequest",
    "AggregatedListServiceAttachmentsRequest",
    "AggregatedListSslCertificatesRequest",
    "AggregatedListSslPoliciesRequest",
    "AggregatedListStoragePoolsRequest",
    "AggregatedListStoragePoolTypesRequest",
    "AggregatedListSubnetworksRequest",
    "AggregatedListTargetHttpProxiesRequest",
    "AggregatedListTargetHttpsProxiesRequest",
    "AggregatedListTargetInstancesRequest",
    "AggregatedListTargetPoolsRequest",
    "AggregatedListTargetTcpProxiesRequest",
    "AggregatedListTargetVpnGatewaysRequest",
    "AggregatedListUrlMapsRequest",
    "AggregatedListVpnGatewaysRequest",
    "AggregatedListVpnTunnelsRequest",
    "AliasIpRange",
    "AllocationAggregateReservation",
    "AllocationAggregateReservationReservedResourceInfo",
    "AllocationAggregateReservationReservedResourceInfoAccelerator",
    "AllocationReservationSharingPolicy",
    "AllocationResourceStatus",
    "AllocationResourceStatusHealthInfo",
    "AllocationResourceStatusSpecificSKUAllocation",
    "AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk",
    "AllocationSpecificSKUAllocationReservedInstanceProperties",
    "AllocationSpecificSKUReservation",
    "Allowed",
    "AnnouncePublicAdvertisedPrefixeRequest",
    "AnnouncePublicDelegatedPrefixeRequest",
    "ApplyUpdatesToInstancesInstanceGroupManagerRequest",
    "ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest",
    "AttachDiskInstanceRequest",
    "AttachedDisk",
    "AttachedDiskInitializeParams",
    "AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest",
    "AttachNetworkEndpointsNetworkEndpointGroupRequest",
    "AttachNetworkEndpointsRegionNetworkEndpointGroupRequest",
    "AuditConfig",
    "AuditLogConfig",
    "Autoscaler",
    "AutoscalerAggregatedList",
    "AutoscalerList",
    "AutoscalersScopedList",
    "AutoscalerStatusDetails",
    "AutoscalingPolicy",
    "AutoscalingPolicyCpuUtilization",
    "AutoscalingPolicyCustomMetricUtilization",
    "AutoscalingPolicyLoadBalancingUtilization",
    "AutoscalingPolicyScaleInControl",
    "AutoscalingPolicyScalingSchedule",
    "AWSV4Signature",
    "Backend",
    "BackendBucket",
    "BackendBucketCdnPolicy",
    "BackendBucketCdnPolicyBypassCacheOnRequestHeader",
    "BackendBucketCdnPolicyCacheKeyPolicy",
    "BackendBucketCdnPolicyNegativeCachingPolicy",
    "BackendBucketList",
    "BackendBucketParams",
    "BackendBucketUsedBy",
    "BackendCustomMetric",
    "BackendService",
    "BackendServiceAggregatedList",
    "BackendServiceCdnPolicy",
    "BackendServiceCdnPolicyBypassCacheOnRequestHeader",
    "BackendServiceCdnPolicyNegativeCachingPolicy",
    "BackendServiceConnectionTrackingPolicy",
    "BackendServiceCustomMetric",
    "BackendServiceFailoverPolicy",
    "BackendServiceGroupHealth",
    "BackendServiceHAPolicy",
    "BackendServiceHAPolicyLeader",
    "BackendServiceHAPolicyLeaderNetworkEndpoint",
    "BackendServiceHttpCookie",
    "BackendServiceIAP",
    "BackendServiceList",
    "BackendServiceListUsable",
    "BackendServiceLocalityLoadBalancingPolicyConfig",
    "BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy",
    "BackendServiceLocalityLoadBalancingPolicyConfigPolicy",
    "BackendServiceLogConfig",
    "BackendServiceParams",
    "BackendServiceReference",
    "BackendServicesScopedList",
    "BackendServiceTlsSettings",
    "BackendServiceTlsSettingsSubjectAltName",
    "BackendServiceUsedBy",
    "BfdPacket",
    "BfdStatus",
    "BfdStatusPacketCounts",
    "BgpRoute",
    "BgpRouteAsPath",
    "BgpRouteNetworkLayerReachabilityInformation",
    "Binding",
    "BulkInsertDiskRequest",
    "BulkInsertDiskResource",
    "BulkInsertInstanceRequest",
    "BulkInsertInstanceResource",
    "BulkInsertInstanceResourcePerInstanceProperties",
    "BulkInsertOperationStatus",
    "BulkInsertRegionDiskRequest",
    "BulkInsertRegionInstanceRequest",
    "BulkSetLabelsDiskRequest",
    "BulkSetLabelsRequest",
    "BulkZoneSetLabelsRequest",
    "CacheInvalidationRule",
    "CacheKeyPolicy",
    "CancelInstanceGroupManagerResizeRequestRequest",
    "CircuitBreakers",
    "CloneRulesFirewallPolicyRequest",
    "CloneRulesNetworkFirewallPolicyRequest",
    "CloneRulesRegionNetworkFirewallPolicyRequest",
    "Commitment",
    "CommitmentAggregatedList",
    "CommitmentList",
    "CommitmentResourceStatus",
    "CommitmentsScopedList",
    "ConfidentialInstanceConfig",
    "ConnectionDraining",
    "ConsistentHashLoadBalancerSettings",
    "ConsistentHashLoadBalancerSettingsHttpCookie",
    "CorsPolicy",
    "CreateInstancesInstanceGroupManagerRequest",
    "CreateInstancesRegionInstanceGroupManagerRequest",
    "CreateMembersInterconnectGroupRequest",
    "CreateSnapshotDiskRequest",
    "CreateSnapshotRegionDiskRequest",
    "CustomerEncryptionKey",
    "CustomerEncryptionKeyProtectedDisk",
    "CustomErrorResponsePolicy",
    "CustomErrorResponsePolicyCustomErrorResponseRule",
    "Data",
    "DeleteAccessConfigInstanceRequest",
    "DeleteAddressRequest",
    "DeleteAutoscalerRequest",
    "DeleteBackendBucketRequest",
    "DeleteBackendServiceRequest",
    "DeleteDiskRequest",
    "DeleteExternalVpnGatewayRequest",
    "DeleteFirewallPolicyRequest",
    "DeleteFirewallRequest",
    "DeleteForwardingRuleRequest",
    "DeleteGlobalAddressRequest",
    "DeleteGlobalForwardingRuleRequest",
    "DeleteGlobalNetworkEndpointGroupRequest",
    "DeleteGlobalOperationRequest",
    "DeleteGlobalOperationResponse",
    "DeleteGlobalOrganizationOperationRequest",
    "DeleteGlobalOrganizationOperationResponse",
    "DeleteGlobalPublicDelegatedPrefixeRequest",
    "DeleteHealthCheckRequest",
    "DeleteImageRequest",
    "DeleteInstanceGroupManagerRequest",
    "DeleteInstanceGroupManagerResizeRequestRequest",
    "DeleteInstanceGroupRequest",
    "DeleteInstanceRequest",
    "DeleteInstancesInstanceGroupManagerRequest",
    "DeleteInstancesRegionInstanceGroupManagerRequest",
    "DeleteInstanceTemplateRequest",
    "DeleteInstantSnapshotRequest",
    "DeleteInterconnectAttachmentGroupRequest",
    "DeleteInterconnectAttachmentRequest",
    "DeleteInterconnectGroupRequest",
    "DeleteInterconnectRequest",
    "DeleteLicenseRequest",
    "DeleteMachineImageRequest",
    "DeleteNetworkAttachmentRequest",
    "DeleteNetworkEdgeSecurityServiceRequest",
    "DeleteNetworkEndpointGroupRequest",
    "DeleteNetworkFirewallPolicyRequest",
    "DeleteNetworkRequest",
    "DeleteNodeGroupRequest",
    "DeleteNodesNodeGroupRequest",
    "DeleteNodeTemplateRequest",
    "DeletePacketMirroringRequest",
    "DeletePerInstanceConfigsInstanceGroupManagerRequest",
    "DeletePerInstanceConfigsRegionInstanceGroupManagerRequest",
    "DeletePublicAdvertisedPrefixeRequest",
    "DeletePublicDelegatedPrefixeRequest",
    "DeleteRegionAutoscalerRequest",
    "DeleteRegionBackendServiceRequest",
    "DeleteRegionDiskRequest",
    "DeleteRegionHealthCheckRequest",
    "DeleteRegionHealthCheckServiceRequest",
    "DeleteRegionInstanceGroupManagerRequest",
    "DeleteRegionInstanceTemplateRequest",
    "DeleteRegionInstantSnapshotRequest",
    "DeleteRegionNetworkEndpointGroupRequest",
    "DeleteRegionNetworkFirewallPolicyRequest",
    "DeleteRegionNotificationEndpointRequest",
    "DeleteRegionOperationRequest",
    "DeleteRegionOperationResponse",
    "DeleteRegionSecurityPolicyRequest",
    "DeleteRegionSslCertificateRequest",
    "DeleteRegionSslPolicyRequest",
    "DeleteRegionTargetHttpProxyRequest",
    "DeleteRegionTargetHttpsProxyRequest",
    "DeleteRegionTargetTcpProxyRequest",
    "DeleteRegionUrlMapRequest",
    "DeleteReservationRequest",
    "DeleteResourcePolicyRequest",
    "DeleteRoutePolicyRouterRequest",
    "DeleteRouteRequest",
    "DeleteRouterRequest",
    "DeleteSecurityPolicyRequest",
    "DeleteServiceAttachmentRequest",
    "DeleteSignedUrlKeyBackendBucketRequest",
    "DeleteSignedUrlKeyBackendServiceRequest",
    "DeleteSnapshotRequest",
    "DeleteSslCertificateRequest",
    "DeleteSslPolicyRequest",
    "DeleteStoragePoolRequest",
    "DeleteSubnetworkRequest",
    "DeleteTargetGrpcProxyRequest",
    "DeleteTargetHttpProxyRequest",
    "DeleteTargetHttpsProxyRequest",
    "DeleteTargetInstanceRequest",
    "DeleteTargetPoolRequest",
    "DeleteTargetSslProxyRequest",
    "DeleteTargetTcpProxyRequest",
    "DeleteTargetVpnGatewayRequest",
    "DeleteUrlMapRequest",
    "DeleteVpnGatewayRequest",
    "DeleteVpnTunnelRequest",
    "DeleteZoneOperationRequest",
    "DeleteZoneOperationResponse",
    "Denied",
    "DeprecateImageRequest",
    "DeprecationStatus",
    "DetachDiskInstanceRequest",
    "DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest",
    "DetachNetworkEndpointsNetworkEndpointGroupRequest",
    "DetachNetworkEndpointsRegionNetworkEndpointGroupRequest",
    "DisableXpnHostProjectRequest",
    "DisableXpnResourceProjectRequest",
    "Disk",
    "DiskAggregatedList",
    "DiskAsyncReplication",
    "DiskAsyncReplicationList",
    "DiskInstantiationConfig",
    "DiskList",
    "DiskMoveRequest",
    "DiskParams",
    "DiskResourceStatus",
    "DiskResourceStatusAsyncReplicationStatus",
    "DisksAddResourcePoliciesRequest",
    "DisksRemoveResourcePoliciesRequest",
    "DisksResizeRequest",
    "DisksScopedList",
    "DisksStartAsyncReplicationRequest",
    "DisksStopGroupAsyncReplicationResource",
    "DiskType",
    "DiskTypeAggregatedList",
    "DiskTypeList",
    "DiskTypesScopedList",
    "DisplayDevice",
    "DistributionPolicy",
    "DistributionPolicyZoneConfiguration",
    "Duration",
    "EnableXpnHostProjectRequest",
    "EnableXpnResourceProjectRequest",
    "Error",
    "ErrorDetails",
    "ErrorInfo",
    "Errors",
    "ExchangedPeeringRoute",
    "ExchangedPeeringRoutesList",
    "ExpandIpCidrRangeSubnetworkRequest",
    "Expr",
    "ExternalVpnGateway",
    "ExternalVpnGatewayInterface",
    "ExternalVpnGatewayList",
    "FileContentBuffer",
    "Firewall",
    "FirewallList",
    "FirewallLogConfig",
    "FirewallParams",
    "FirewallPoliciesListAssociationsResponse",
    "FirewallPoliciesScopedList",
    "FirewallPolicy",
    "FirewallPolicyAssociation",
    "FirewallPolicyList",
    "FirewallPolicyRule",
    "FirewallPolicyRuleMatcher",
    "FirewallPolicyRuleMatcherLayer4Config",
    "FirewallPolicyRuleSecureTag",
    "FixedOrPercent",
    "ForwardingRule",
    "ForwardingRuleAggregatedList",
    "ForwardingRuleList",
    "ForwardingRuleReference",
    "ForwardingRuleServiceDirectoryRegistration",
    "ForwardingRulesScopedList",
    "GetAcceleratorTypeRequest",
    "GetAddressRequest",
    "GetAssociationFirewallPolicyRequest",
    "GetAssociationNetworkFirewallPolicyRequest",
    "GetAssociationRegionNetworkFirewallPolicyRequest",
    "GetAutoscalerRequest",
    "GetBackendBucketRequest",
    "GetBackendServiceRequest",
    "GetDiagnosticsInterconnectRequest",
    "GetDiskRequest",
    "GetDiskTypeRequest",
    "GetEffectiveFirewallsInstanceRequest",
    "GetEffectiveFirewallsNetworkRequest",
    "GetEffectiveFirewallsRegionNetworkFirewallPolicyRequest",
    "GetExternalVpnGatewayRequest",
    "GetFirewallPolicyRequest",
    "GetFirewallRequest",
    "GetForwardingRuleRequest",
    "GetFromFamilyImageRequest",
    "GetGlobalAddressRequest",
    "GetGlobalForwardingRuleRequest",
    "GetGlobalNetworkEndpointGroupRequest",
    "GetGlobalOperationRequest",
    "GetGlobalOrganizationOperationRequest",
    "GetGlobalPublicDelegatedPrefixeRequest",
    "GetGuestAttributesInstanceRequest",
    "GetHealthBackendServiceRequest",
    "GetHealthCheckRequest",
    "GetHealthRegionBackendServiceRequest",
    "GetHealthTargetPoolRequest",
    "GetIamPolicyBackendBucketRequest",
    "GetIamPolicyBackendServiceRequest",
    "GetIamPolicyDiskRequest",
    "GetIamPolicyFirewallPolicyRequest",
    "GetIamPolicyImageRequest",
    "GetIamPolicyInstanceRequest",
    "GetIamPolicyInstanceTemplateRequest",
    "GetIamPolicyInstantSnapshotRequest",
    "GetIamPolicyInterconnectAttachmentGroupRequest",
    "GetIamPolicyInterconnectGroupRequest",
    "GetIamPolicyLicenseRequest",
    "GetIamPolicyMachineImageRequest",
    "GetIamPolicyNetworkAttachmentRequest",
    "GetIamPolicyNetworkFirewallPolicyRequest",
    "GetIamPolicyNodeGroupRequest",
    "GetIamPolicyNodeTemplateRequest",
    "GetIamPolicyRegionBackendServiceRequest",
    "GetIamPolicyRegionDiskRequest",
    "GetIamPolicyRegionInstantSnapshotRequest",
    "GetIamPolicyRegionNetworkFirewallPolicyRequest",
    "GetIamPolicyReservationRequest",
    "GetIamPolicyResourcePolicyRequest",
    "GetIamPolicyServiceAttachmentRequest",
    "GetIamPolicySnapshotRequest",
    "GetIamPolicyStoragePoolRequest",
    "GetIamPolicySubnetworkRequest",
    "GetImageFamilyViewRequest",
    "GetImageRequest",
    "GetInstanceGroupManagerRequest",
    "GetInstanceGroupManagerResizeRequestRequest",
    "GetInstanceGroupRequest",
    "GetInstanceRequest",
    "GetInstanceSettingRequest",
    "GetInstanceTemplateRequest",
    "GetInstantSnapshotRequest",
    "GetInterconnectAttachmentGroupRequest",
    "GetInterconnectAttachmentRequest",
    "GetInterconnectGroupRequest",
    "GetInterconnectLocationRequest",
    "GetInterconnectRemoteLocationRequest",
    "GetInterconnectRequest",
    "GetLicenseCodeRequest",
    "GetLicenseRequest",
    "GetMachineImageRequest",
    "GetMachineTypeRequest",
    "GetMacsecConfigInterconnectRequest",
    "GetNatIpInfoRouterRequest",
    "GetNatMappingInfoRoutersRequest",
    "GetNetworkAttachmentRequest",
    "GetNetworkEdgeSecurityServiceRequest",
    "GetNetworkEndpointGroupRequest",
    "GetNetworkFirewallPolicyRequest",
    "GetNetworkProfileRequest",
    "GetNetworkRequest",
    "GetNodeGroupRequest",
    "GetNodeTemplateRequest",
    "GetNodeTypeRequest",
    "GetOperationalStatusInterconnectAttachmentGroupRequest",
    "GetOperationalStatusInterconnectGroupRequest",
    "GetPacketMirroringRequest",
    "GetPacketMirroringRuleNetworkFirewallPolicyRequest",
    "GetProjectRequest",
    "GetPublicAdvertisedPrefixeRequest",
    "GetPublicDelegatedPrefixeRequest",
    "GetRegionAutoscalerRequest",
    "GetRegionBackendServiceRequest",
    "GetRegionCommitmentRequest",
    "GetRegionDiskRequest",
    "GetRegionDiskTypeRequest",
    "GetRegionHealthCheckRequest",
    "GetRegionHealthCheckServiceRequest",
    "GetRegionInstanceGroupManagerRequest",
    "GetRegionInstanceGroupRequest",
    "GetRegionInstanceTemplateRequest",
    "GetRegionInstantSnapshotRequest",
    "GetRegionNetworkEndpointGroupRequest",
    "GetRegionNetworkFirewallPolicyRequest",
    "GetRegionNotificationEndpointRequest",
    "GetRegionOperationRequest",
    "GetRegionRequest",
    "GetRegionSecurityPolicyRequest",
    "GetRegionSslCertificateRequest",
    "GetRegionSslPolicyRequest",
    "GetRegionTargetHttpProxyRequest",
    "GetRegionTargetHttpsProxyRequest",
    "GetRegionTargetTcpProxyRequest",
    "GetRegionUrlMapRequest",
    "GetReservationBlockRequest",
    "GetReservationRequest",
    "GetReservationSubBlockRequest",
    "GetResourcePolicyRequest",
    "GetRoutePolicyRouterRequest",
    "GetRouteRequest",
    "GetRouterRequest",
    "GetRouterStatusRouterRequest",
    "GetRuleFirewallPolicyRequest",
    "GetRuleNetworkFirewallPolicyRequest",
    "GetRuleRegionNetworkFirewallPolicyRequest",
    "GetRuleRegionSecurityPolicyRequest",
    "GetRuleSecurityPolicyRequest",
    "GetScreenshotInstanceRequest",
    "GetSecurityPolicyRequest",
    "GetSerialPortOutputInstanceRequest",
    "GetServiceAttachmentRequest",
    "GetShieldedInstanceIdentityInstanceRequest",
    "GetSnapshotRequest",
    "GetSnapshotSettingRequest",
    "GetSslCertificateRequest",
    "GetSslPolicyRequest",
    "GetStatusVpnGatewayRequest",
    "GetStoragePoolRequest",
    "GetStoragePoolTypeRequest",
    "GetSubnetworkRequest",
    "GetTargetGrpcProxyRequest",
    "GetTargetHttpProxyRequest",
    "GetTargetHttpsProxyRequest",
    "GetTargetInstanceRequest",
    "GetTargetPoolRequest",
    "GetTargetSslProxyRequest",
    "GetTargetTcpProxyRequest",
    "GetTargetVpnGatewayRequest",
    "GetUrlMapRequest",
    "GetVpnGatewayRequest",
    "GetVpnTunnelRequest",
    "GetXpnHostProjectRequest",
    "GetXpnResourcesProjectsRequest",
    "GetZoneOperationRequest",
    "GetZoneRequest",
    "GlobalAddressesMoveRequest",
    "GlobalNetworkEndpointGroupsAttachEndpointsRequest",
    "GlobalNetworkEndpointGroupsDetachEndpointsRequest",
    "GlobalOrganizationSetPolicyRequest",
    "GlobalSetLabelsRequest",
    "GlobalSetPolicyRequest",
    "GroupMaintenanceInfo",
    "GRPCHealthCheck",
    "GuestAttributes",
    "GuestAttributesEntry",
    "GuestAttributesValue",
    "GuestOsFeature",
    "HealthCheck",
    "HealthCheckList",
    "HealthCheckLogConfig",
    "HealthCheckReference",
    "HealthChecksAggregatedList",
    "HealthCheckService",
    "HealthCheckServiceReference",
    "HealthCheckServicesList",
    "HealthChecksScopedList",
    "HealthStatus",
    "HealthStatusForNetworkEndpoint",
    "Help",
    "HelpLink",
    "HostRule",
    "HTTP2HealthCheck",
    "HttpFaultAbort",
    "HttpFaultDelay",
    "HttpFaultInjection",
    "HttpHeaderAction",
    "HttpHeaderMatch",
    "HttpHeaderOption",
    "HTTPHealthCheck",
    "HttpQueryParameterMatch",
    "HttpRedirectAction",
    "HttpRetryPolicy",
    "HttpRouteAction",
    "HttpRouteRule",
    "HttpRouteRuleMatch",
    "HTTPSHealthCheck",
    "Image",
    "ImageFamilyView",
    "ImageList",
    "InitialStateConfig",
    "InsertAddressRequest",
    "InsertAutoscalerRequest",
    "InsertBackendBucketRequest",
    "InsertBackendServiceRequest",
    "InsertDiskRequest",
    "InsertExternalVpnGatewayRequest",
    "InsertFirewallPolicyRequest",
    "InsertFirewallRequest",
    "InsertForwardingRuleRequest",
    "InsertGlobalAddressRequest",
    "InsertGlobalForwardingRuleRequest",
    "InsertGlobalNetworkEndpointGroupRequest",
    "InsertGlobalPublicDelegatedPrefixeRequest",
    "InsertHealthCheckRequest",
    "InsertImageRequest",
    "InsertInstanceGroupManagerRequest",
    "InsertInstanceGroupManagerResizeRequestRequest",
    "InsertInstanceGroupRequest",
    "InsertInstanceRequest",
    "InsertInstanceTemplateRequest",
    "InsertInstantSnapshotRequest",
    "InsertInterconnectAttachmentGroupRequest",
    "InsertInterconnectAttachmentRequest",
    "InsertInterconnectGroupRequest",
    "InsertInterconnectRequest",
    "InsertLicenseRequest",
    "InsertMachineImageRequest",
    "InsertNetworkAttachmentRequest",
    "InsertNetworkEdgeSecurityServiceRequest",
    "InsertNetworkEndpointGroupRequest",
    "InsertNetworkFirewallPolicyRequest",
    "InsertNetworkRequest",
    "InsertNodeGroupRequest",
    "InsertNodeTemplateRequest",
    "InsertPacketMirroringRequest",
    "InsertPublicAdvertisedPrefixeRequest",
    "InsertPublicDelegatedPrefixeRequest",
    "InsertRegionAutoscalerRequest",
    "InsertRegionBackendServiceRequest",
    "InsertRegionCommitmentRequest",
    "InsertRegionDiskRequest",
    "InsertRegionHealthCheckRequest",
    "InsertRegionHealthCheckServiceRequest",
    "InsertRegionInstanceGroupManagerRequest",
    "InsertRegionInstanceTemplateRequest",
    "InsertRegionInstantSnapshotRequest",
    "InsertRegionNetworkEndpointGroupRequest",
    "InsertRegionNetworkFirewallPolicyRequest",
    "InsertRegionNotificationEndpointRequest",
    "InsertRegionSecurityPolicyRequest",
    "InsertRegionSslCertificateRequest",
    "InsertRegionSslPolicyRequest",
    "InsertRegionTargetHttpProxyRequest",
    "InsertRegionTargetHttpsProxyRequest",
    "InsertRegionTargetTcpProxyRequest",
    "InsertRegionUrlMapRequest",
    "InsertReservationRequest",
    "InsertResourcePolicyRequest",
    "InsertRouteRequest",
    "InsertRouterRequest",
    "InsertSecurityPolicyRequest",
    "InsertServiceAttachmentRequest",
    "InsertSnapshotRequest",
    "InsertSslCertificateRequest",
    "InsertSslPolicyRequest",
    "InsertStoragePoolRequest",
    "InsertSubnetworkRequest",
    "InsertTargetGrpcProxyRequest",
    "InsertTargetHttpProxyRequest",
    "InsertTargetHttpsProxyRequest",
    "InsertTargetInstanceRequest",
    "InsertTargetPoolRequest",
    "InsertTargetSslProxyRequest",
    "InsertTargetTcpProxyRequest",
    "InsertTargetVpnGatewayRequest",
    "InsertUrlMapRequest",
    "InsertVpnGatewayRequest",
    "InsertVpnTunnelRequest",
    "Instance",
    "InstanceAggregatedList",
    "InstanceConsumptionData",
    "InstanceConsumptionInfo",
    "InstanceGroup",
    "InstanceGroupAggregatedList",
    "InstanceGroupList",
    "InstanceGroupManager",
    "InstanceGroupManagerActionsSummary",
    "InstanceGroupManagerAggregatedList",
    "InstanceGroupManagerAllInstancesConfig",
    "InstanceGroupManagerAutoHealingPolicy",
    "InstanceGroupManagerInstanceFlexibilityPolicy",
    "InstanceGroupManagerInstanceFlexibilityPolicyInstanceSelection",
    "InstanceGroupManagerInstanceLifecyclePolicy",
    "InstanceGroupManagerList",
    "InstanceGroupManagerResizeRequest",
    "InstanceGroupManagerResizeRequestsListResponse",
    "InstanceGroupManagerResizeRequestStatus",
    "InstanceGroupManagerResizeRequestStatusLastAttempt",
    "InstanceGroupManagerResourcePolicies",
    "InstanceGroupManagersAbandonInstancesRequest",
    "InstanceGroupManagersApplyUpdatesRequest",
    "InstanceGroupManagersCreateInstancesRequest",
    "InstanceGroupManagersDeleteInstancesRequest",
    "InstanceGroupManagersDeletePerInstanceConfigsReq",
    "InstanceGroupManagersListErrorsResponse",
    "InstanceGroupManagersListManagedInstancesResponse",
    "InstanceGroupManagersListPerInstanceConfigsResp",
    "InstanceGroupManagersPatchPerInstanceConfigsReq",
    "InstanceGroupManagersRecreateInstancesRequest",
    "InstanceGroupManagersResumeInstancesRequest",
    "InstanceGroupManagersScopedList",
    "InstanceGroupManagersSetInstanceTemplateRequest",
    "InstanceGroupManagersSetTargetPoolsRequest",
    "InstanceGroupManagersStartInstancesRequest",
    "InstanceGroupManagersStopInstancesRequest",
    "InstanceGroupManagersSuspendInstancesRequest",
    "InstanceGroupManagerStandbyPolicy",
    "InstanceGroupManagerStatus",
    "InstanceGroupManagerStatusAllInstancesConfig",
    "InstanceGroupManagerStatusStateful",
    "InstanceGroupManagerStatusStatefulPerInstanceConfigs",
    "InstanceGroupManagerStatusVersionTarget",
    "InstanceGroupManagersUpdatePerInstanceConfigsReq",
    "InstanceGroupManagerUpdatePolicy",
    "InstanceGroupManagerVersion",
    "InstanceGroupsAddInstancesRequest",
    "InstanceGroupsListInstances",
    "InstanceGroupsListInstancesRequest",
    "InstanceGroupsRemoveInstancesRequest",
    "InstanceGroupsScopedList",
    "InstanceGroupsSetNamedPortsRequest",
    "InstanceList",
    "InstanceListReferrers",
    "InstanceManagedByIgmError",
    "InstanceManagedByIgmErrorInstanceActionDetails",
    "InstanceManagedByIgmErrorManagedInstanceError",
    "InstanceMoveRequest",
    "InstanceParams",
    "InstanceProperties",
    "InstancePropertiesPatch",
    "InstanceReference",
    "InstancesAddResourcePoliciesRequest",
    "InstancesBulkInsertOperationMetadata",
    "InstanceSettings",
    "InstanceSettingsMetadata",
    "InstancesGetEffectiveFirewallsResponse",
    "InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy",
    "InstancesRemoveResourcePoliciesRequest",
    "InstancesReportHostAsFaultyRequest",
    "InstancesReportHostAsFaultyRequestFaultReason",
    "InstancesScopedList",
    "InstancesSetLabelsRequest",
    "InstancesSetMachineResourcesRequest",
    "InstancesSetMachineTypeRequest",
    "InstancesSetMinCpuPlatformRequest",
    "InstancesSetNameRequest",
    "InstancesSetSecurityPolicyRequest",
    "InstancesSetServiceAccountRequest",
    "InstancesStartWithEncryptionKeyRequest",
    "InstanceTemplate",
    "InstanceTemplateAggregatedList",
    "InstanceTemplateList",
    "InstanceTemplatesScopedList",
    "InstanceWithNamedPorts",
    "InstantSnapshot",
    "InstantSnapshotAggregatedList",
    "InstantSnapshotList",
    "InstantSnapshotResourceStatus",
    "InstantSnapshotsScopedList",
    "Int64RangeMatch",
    "Interconnect",
    "InterconnectApplicationAwareInterconnect",
    "InterconnectApplicationAwareInterconnectBandwidthPercentage",
    "InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy",
    "InterconnectApplicationAwareInterconnectStrictPriorityPolicy",
    "InterconnectAttachment",
    "InterconnectAttachmentAggregatedList",
    "InterconnectAttachmentConfigurationConstraints",
    "InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange",
    "InterconnectAttachmentGroup",
    "InterconnectAttachmentGroupAttachment",
    "InterconnectAttachmentGroupConfigured",
    "InterconnectAttachmentGroupConfiguredAvailabilitySLA",
    "InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers",
    "InterconnectAttachmentGroupIntent",
    "InterconnectAttachmentGroupLogicalStructure",
    "InterconnectAttachmentGroupLogicalStructureRegion",
    "InterconnectAttachmentGroupLogicalStructureRegionMetro",
    "InterconnectAttachmentGroupLogicalStructureRegionMetroFacility",
    "InterconnectAttachmentGroupLogicalStructureRegionMetroFacilityZone",
    "InterconnectAttachmentGroupsGetOperationalStatusResponse",
    "InterconnectAttachmentGroupsListResponse",
    "InterconnectAttachmentGroupsOperationalStatus",
    "InterconnectAttachmentGroupsOperationalStatusAttachmentStatus",
    "InterconnectAttachmentList",
    "InterconnectAttachmentPartnerMetadata",
    "InterconnectAttachmentPrivateInfo",
    "InterconnectAttachmentsScopedList",
    "InterconnectCircuitInfo",
    "InterconnectDiagnostics",
    "InterconnectDiagnosticsARPEntry",
    "InterconnectDiagnosticsLinkLACPStatus",
    "InterconnectDiagnosticsLinkOpticalPower",
    "InterconnectDiagnosticsLinkStatus",
    "InterconnectDiagnosticsMacsecStatus",
    "InterconnectGroup",
    "InterconnectGroupConfigured",
    "InterconnectGroupConfiguredTopologyCapability",
    "InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers",
    "InterconnectGroupIntent",
    "InterconnectGroupInterconnect",
    "InterconnectGroupPhysicalStructure",
    "InterconnectGroupPhysicalStructureMetros",
    "InterconnectGroupPhysicalStructureMetrosFacilities",
    "InterconnectGroupPhysicalStructureMetrosFacilitiesZones",
    "InterconnectGroupsCreateMembers",
    "InterconnectGroupsCreateMembersInterconnectInput",
    "InterconnectGroupsCreateMembersRequest",
    "InterconnectGroupsGetOperationalStatusResponse",
    "InterconnectGroupsListResponse",
    "InterconnectGroupsOperationalStatus",
    "InterconnectGroupsOperationalStatusInterconnectStatus",
    "InterconnectList",
    "InterconnectLocation",
    "InterconnectLocationList",
    "InterconnectLocationRegionInfo",
    "InterconnectMacsec",
    "InterconnectMacsecConfig",
    "InterconnectMacsecConfigPreSharedKey",
    "InterconnectMacsecPreSharedKey",
    "InterconnectOutageNotification",
    "InterconnectRemoteLocation",
    "InterconnectRemoteLocationConstraints",
    "InterconnectRemoteLocationConstraintsSubnetLengthRange",
    "InterconnectRemoteLocationList",
    "InterconnectRemoteLocationPermittedConnections",
    "InterconnectsGetDiagnosticsResponse",
    "InterconnectsGetMacsecConfigResponse",
    "InvalidateCacheUrlMapRequest",
    "Items",
    "License",
    "LicenseCode",
    "LicenseCodeLicenseAlias",
    "LicenseResourceCommitment",
    "LicenseResourceRequirements",
    "LicensesListResponse",
    "ListAcceleratorTypesRequest",
    "ListAddressesRequest",
    "ListAssociationsFirewallPolicyRequest",
    "ListAutoscalersRequest",
    "ListAvailableFeaturesRegionSslPoliciesRequest",
    "ListAvailableFeaturesSslPoliciesRequest",
    "ListBackendBucketsRequest",
    "ListBackendServicesRequest",
    "ListBgpRoutesRoutersRequest",
    "ListDisksRequest",
    "ListDisksStoragePoolsRequest",
    "ListDiskTypesRequest",
    "ListErrorsInstanceGroupManagersRequest",
    "ListErrorsRegionInstanceGroupManagersRequest",
    "ListExternalVpnGatewaysRequest",
    "ListFirewallPoliciesRequest",
    "ListFirewallsRequest",
    "ListForwardingRulesRequest",
    "ListGlobalAddressesRequest",
    "ListGlobalForwardingRulesRequest",
    "ListGlobalNetworkEndpointGroupsRequest",
    "ListGlobalOperationsRequest",
    "ListGlobalOrganizationOperationsRequest",
    "ListGlobalPublicDelegatedPrefixesRequest",
    "ListHealthChecksRequest",
    "ListImagesRequest",
    "ListInstanceGroupManagerResizeRequestsRequest",
    "ListInstanceGroupManagersRequest",
    "ListInstanceGroupsRequest",
    "ListInstancesInstanceGroupsRequest",
    "ListInstancesRegionInstanceGroupsRequest",
    "ListInstancesRequest",
    "ListInstanceTemplatesRequest",
    "ListInstantSnapshotsRequest",
    "ListInterconnectAttachmentGroupsRequest",
    "ListInterconnectAttachmentsRequest",
    "ListInterconnectGroupsRequest",
    "ListInterconnectLocationsRequest",
    "ListInterconnectRemoteLocationsRequest",
    "ListInterconnectsRequest",
    "ListLicensesRequest",
    "ListMachineImagesRequest",
    "ListMachineTypesRequest",
    "ListManagedInstancesInstanceGroupManagersRequest",
    "ListManagedInstancesRegionInstanceGroupManagersRequest",
    "ListNetworkAttachmentsRequest",
    "ListNetworkEndpointGroupsRequest",
    "ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest",
    "ListNetworkEndpointsNetworkEndpointGroupsRequest",
    "ListNetworkEndpointsRegionNetworkEndpointGroupsRequest",
    "ListNetworkFirewallPoliciesRequest",
    "ListNetworkProfilesRequest",
    "ListNetworksRequest",
    "ListNodeGroupsRequest",
    "ListNodesNodeGroupsRequest",
    "ListNodeTemplatesRequest",
    "ListNodeTypesRequest",
    "ListPacketMirroringsRequest",
    "ListPeeringRoutesNetworksRequest",
    "ListPerInstanceConfigsInstanceGroupManagersRequest",
    "ListPerInstanceConfigsRegionInstanceGroupManagersRequest",
    "ListPreconfiguredExpressionSetsSecurityPoliciesRequest",
    "ListPublicAdvertisedPrefixesRequest",
    "ListPublicDelegatedPrefixesRequest",
    "ListReferrersInstancesRequest",
    "ListRegionAutoscalersRequest",
    "ListRegionBackendServicesRequest",
    "ListRegionCommitmentsRequest",
    "ListRegionDisksRequest",
    "ListRegionDiskTypesRequest",
    "ListRegionHealthCheckServicesRequest",
    "ListRegionHealthChecksRequest",
    "ListRegionInstanceGroupManagersRequest",
    "ListRegionInstanceGroupsRequest",
    "ListRegionInstanceTemplatesRequest",
    "ListRegionInstantSnapshotsRequest",
    "ListRegionNetworkEndpointGroupsRequest",
    "ListRegionNetworkFirewallPoliciesRequest",
    "ListRegionNotificationEndpointsRequest",
    "ListRegionOperationsRequest",
    "ListRegionSecurityPoliciesRequest",
    "ListRegionsRequest",
    "ListRegionSslCertificatesRequest",
    "ListRegionSslPoliciesRequest",
    "ListRegionTargetHttpProxiesRequest",
    "ListRegionTargetHttpsProxiesRequest",
    "ListRegionTargetTcpProxiesRequest",
    "ListRegionUrlMapsRequest",
    "ListRegionZonesRequest",
    "ListReservationBlocksRequest",
    "ListReservationsRequest",
    "ListReservationSubBlocksRequest",
    "ListResourcePoliciesRequest",
    "ListRoutePoliciesRoutersRequest",
    "ListRoutersRequest",
    "ListRoutesRequest",
    "ListSecurityPoliciesRequest",
    "ListServiceAttachmentsRequest",
    "ListSnapshotsRequest",
    "ListSslCertificatesRequest",
    "ListSslPoliciesRequest",
    "ListStoragePoolsRequest",
    "ListStoragePoolTypesRequest",
    "ListSubnetworksRequest",
    "ListTargetGrpcProxiesRequest",
    "ListTargetHttpProxiesRequest",
    "ListTargetHttpsProxiesRequest",
    "ListTargetInstancesRequest",
    "ListTargetPoolsRequest",
    "ListTargetSslProxiesRequest",
    "ListTargetTcpProxiesRequest",
    "ListTargetVpnGatewaysRequest",
    "ListUrlMapsRequest",
    "ListUsableBackendServicesRequest",
    "ListUsableRegionBackendServicesRequest",
    "ListUsableSubnetworksRequest",
    "ListVpnGatewaysRequest",
    "ListVpnTunnelsRequest",
    "ListXpnHostsProjectsRequest",
    "ListZoneOperationsRequest",
    "ListZonesRequest",
    "LocalDisk",
    "LocalizedMessage",
    "LocationPolicy",
    "LocationPolicyLocation",
    "LocationPolicyLocationConstraints",
    "MachineImage",
    "MachineImageList",
    "MachineType",
    "MachineTypeAggregatedList",
    "MachineTypeList",
    "MachineTypesScopedList",
    "ManagedInstance",
    "ManagedInstanceInstanceHealth",
    "ManagedInstanceLastAttempt",
    "ManagedInstanceLastAttemptErrors",
    "ManagedInstancePropertiesFromFlexibilityPolicy",
    "ManagedInstanceVersion",
    "Metadata",
    "MetadataFilter",
    "MetadataFilterLabelMatch",
    "MoveAddressRequest",
    "MoveDiskProjectRequest",
    "MoveFirewallPolicyRequest",
    "MoveGlobalAddressRequest",
    "MoveInstanceProjectRequest",
    "NamedPort",
    "NatIpInfo",
    "NatIpInfoNatIpInfoMapping",
    "NatIpInfoResponse",
    "Network",
    "NetworkAttachment",
    "NetworkAttachmentAggregatedList",
    "NetworkAttachmentConnectedEndpoint",
    "NetworkAttachmentList",
    "NetworkAttachmentsScopedList",
    "NetworkEdgeSecurityService",
    "NetworkEdgeSecurityServiceAggregatedList",
    "NetworkEdgeSecurityServicesScopedList",
    "NetworkEndpoint",
    "NetworkEndpointGroup",
    "NetworkEndpointGroupAggregatedList",
    "NetworkEndpointGroupAppEngine",
    "NetworkEndpointGroupCloudFunction",
    "NetworkEndpointGroupCloudRun",
    "NetworkEndpointGroupList",
    "NetworkEndpointGroupPscData",
    "NetworkEndpointGroupsAttachEndpointsRequest",
    "NetworkEndpointGroupsDetachEndpointsRequest",
    "NetworkEndpointGroupsListEndpointsRequest",
    "NetworkEndpointGroupsListNetworkEndpoints",
    "NetworkEndpointGroupsScopedList",
    "NetworkEndpointWithHealthStatus",
    "NetworkFirewallPolicyAggregatedList",
    "NetworkInterface",
    "NetworkList",
    "NetworkParams",
    "NetworkPeering",
    "NetworkPeeringConnectionStatus",
    "NetworkPeeringConnectionStatusConsensusState",
    "NetworkPeeringConnectionStatusTrafficConfiguration",
    "NetworkPerformanceConfig",
    "NetworkProfile",
    "NetworkProfileLocation",
    "NetworkProfileNetworkFeatures",
    "NetworkProfilesListResponse",
    "NetworkRoutingConfig",
    "NetworksAddPeeringRequest",
    "NetworksGetEffectiveFirewallsResponse",
    "NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy",
    "NetworksRemovePeeringRequest",
    "NetworksRequestRemovePeeringRequest",
    "NetworksUpdatePeeringRequest",
    "NodeGroup",
    "NodeGroupAggregatedList",
    "NodeGroupAutoscalingPolicy",
    "NodeGroupList",
    "NodeGroupMaintenanceWindow",
    "NodeGroupNode",
    "NodeGroupsAddNodesRequest",
    "NodeGroupsDeleteNodesRequest",
    "NodeGroupsListNodes",
    "NodeGroupsPerformMaintenanceRequest",
    "NodeGroupsScopedList",
    "NodeGroupsSetNodeTemplateRequest",
    "NodeGroupsSimulateMaintenanceEventRequest",
    "NodeTemplate",
    "NodeTemplateAggregatedList",
    "NodeTemplateList",
    "NodeTemplateNodeTypeFlexibility",
    "NodeTemplatesScopedList",
    "NodeType",
    "NodeTypeAggregatedList",
    "NodeTypeList",
    "NodeTypesScopedList",
    "NotificationEndpoint",
    "NotificationEndpointGrpcSettings",
    "NotificationEndpointList",
    "Operation",
    "OperationAggregatedList",
    "OperationList",
    "OperationsScopedList",
    "OutlierDetection",
    "PacketIntervals",
    "PacketMirroring",
    "PacketMirroringAggregatedList",
    "PacketMirroringFilter",
    "PacketMirroringForwardingRuleInfo",
    "PacketMirroringList",
    "PacketMirroringMirroredResourceInfo",
    "PacketMirroringMirroredResourceInfoInstanceInfo",
    "PacketMirroringMirroredResourceInfoSubnetInfo",
    "PacketMirroringNetworkInfo",
    "PacketMirroringsScopedList",
    "PatchAutoscalerRequest",
    "PatchBackendBucketRequest",
    "PatchBackendServiceRequest",
    "PatchFirewallPolicyRequest",
    "PatchFirewallRequest",
    "PatchForwardingRuleRequest",
    "PatchGlobalForwardingRuleRequest",
    "PatchGlobalPublicDelegatedPrefixeRequest",
    "PatchHealthCheckRequest",
    "PatchImageRequest",
    "PatchInstanceGroupManagerRequest",
    "PatchInstanceSettingRequest",
    "PatchInterconnectAttachmentGroupRequest",
    "PatchInterconnectAttachmentRequest",
    "PatchInterconnectGroupRequest",
    "PatchInterconnectRequest",
    "PatchNetworkAttachmentRequest",
    "PatchNetworkEdgeSecurityServiceRequest",
    "PatchNetworkFirewallPolicyRequest",
    "PatchNetworkRequest",
    "PatchNodeGroupRequest",
    "PatchPacketMirroringRequest",
    "PatchPacketMirroringRuleNetworkFirewallPolicyRequest",
    "PatchPerInstanceConfigsInstanceGroupManagerRequest",
    "PatchPerInstanceConfigsRegionInstanceGroupManagerRequest",
    "PatchPublicAdvertisedPrefixeRequest",
    "PatchPublicDelegatedPrefixeRequest",
    "PatchRegionAutoscalerRequest",
    "PatchRegionBackendServiceRequest",
    "PatchRegionHealthCheckRequest",
    "PatchRegionHealthCheckServiceRequest",
    "PatchRegionInstanceGroupManagerRequest",
    "PatchRegionNetworkFirewallPolicyRequest",
    "PatchRegionSecurityPolicyRequest",
    "PatchRegionSslPolicyRequest",
    "PatchRegionTargetHttpsProxyRequest",
    "PatchRegionUrlMapRequest",
    "PatchResourcePolicyRequest",
    "PatchRoutePolicyRouterRequest",
    "PatchRouterRequest",
    "PatchRuleFirewallPolicyRequest",
    "PatchRuleNetworkFirewallPolicyRequest",
    "PatchRuleRegionNetworkFirewallPolicyRequest",
    "PatchRuleRegionSecurityPolicyRequest",
    "PatchRuleSecurityPolicyRequest",
    "PatchSecurityPolicyRequest",
    "PatchServiceAttachmentRequest",
    "PatchSnapshotSettingRequest",
    "PatchSslPolicyRequest",
    "PatchSubnetworkRequest",
    "PatchTargetGrpcProxyRequest",
    "PatchTargetHttpProxyRequest",
    "PatchTargetHttpsProxyRequest",
    "PatchUrlMapRequest",
    "PathMatcher",
    "PathRule",
    "PerformMaintenanceInstanceRequest",
    "PerformMaintenanceNodeGroupRequest",
    "PerformMaintenanceReservationBlockRequest",
    "PerformMaintenanceReservationRequest",
    "PerformMaintenanceReservationSubBlockRequest",
    "PerInstanceConfig",
    "Policy",
    "PreconfiguredWafSet",
    "PreservedState",
    "PreservedStatePreservedDisk",
    "PreservedStatePreservedNetworkIp",
    "PreservedStatePreservedNetworkIpIpAddress",
    "PreviewRouterRequest",
    "Project",
    "ProjectsDisableXpnResourceRequest",
    "ProjectsEnableXpnResourceRequest",
    "ProjectsGetXpnResources",
    "ProjectsListXpnHostsRequest",
    "ProjectsSetCloudArmorTierRequest",
    "ProjectsSetDefaultNetworkTierRequest",
    "PublicAdvertisedPrefix",
    "PublicAdvertisedPrefixList",
    "PublicAdvertisedPrefixPublicDelegatedPrefix",
    "PublicDelegatedPrefix",
    "PublicDelegatedPrefixAggregatedList",
    "PublicDelegatedPrefixesScopedList",
    "PublicDelegatedPrefixList",
    "PublicDelegatedPrefixPublicDelegatedSubPrefix",
    "Quota",
    "QuotaExceededInfo",
    "QuotaStatusWarning",
    "RawDisk",
    "RecreateInstancesInstanceGroupManagerRequest",
    "RecreateInstancesRegionInstanceGroupManagerRequest",
    "Reference",
    "Region",
    "RegionAddressesMoveRequest",
    "RegionAutoscalerList",
    "RegionDisksAddResourcePoliciesRequest",
    "RegionDisksRemoveResourcePoliciesRequest",
    "RegionDisksResizeRequest",
    "RegionDisksStartAsyncReplicationRequest",
    "RegionDiskTypeList",
    "RegionInstanceGroupList",
    "RegionInstanceGroupManagerDeleteInstanceConfigReq",
    "RegionInstanceGroupManagerList",
    "RegionInstanceGroupManagerPatchInstanceConfigReq",
    "RegionInstanceGroupManagersAbandonInstancesRequest",
    "RegionInstanceGroupManagersApplyUpdatesRequest",
    "RegionInstanceGroupManagersCreateInstancesRequest",
    "RegionInstanceGroupManagersDeleteInstancesRequest",
    "RegionInstanceGroupManagersListErrorsResponse",
    "RegionInstanceGroupManagersListInstanceConfigsResp",
    "RegionInstanceGroupManagersListInstancesResponse",
    "RegionInstanceGroupManagersRecreateRequest",
    "RegionInstanceGroupManagersResumeInstancesRequest",
    "RegionInstanceGroupManagersSetTargetPoolsRequest",
    "RegionInstanceGroupManagersSetTemplateRequest",
    "RegionInstanceGroupManagersStartInstancesRequest",
    "RegionInstanceGroupManagersStopInstancesRequest",
    "RegionInstanceGroupManagersSuspendInstancesRequest",
    "RegionInstanceGroupManagerUpdateInstanceConfigReq",
    "RegionInstanceGroupsListInstances",
    "RegionInstanceGroupsListInstancesRequest",
    "RegionInstanceGroupsSetNamedPortsRequest",
    "RegionList",
    "RegionNetworkEndpointGroupsAttachEndpointsRequest",
    "RegionNetworkEndpointGroupsDetachEndpointsRequest",
    "RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse",
    "RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy",
    "RegionSetLabelsRequest",
    "RegionSetPolicyRequest",
    "RegionTargetHttpsProxiesSetSslCertificatesRequest",
    "RegionUrlMapsValidateRequest",
    "RemoveAssociationFirewallPolicyRequest",
    "RemoveAssociationNetworkFirewallPolicyRequest",
    "RemoveAssociationRegionNetworkFirewallPolicyRequest",
    "RemoveHealthCheckTargetPoolRequest",
    "RemoveInstancesInstanceGroupRequest",
    "RemoveInstanceTargetPoolRequest",
    "RemovePacketMirroringRuleNetworkFirewallPolicyRequest",
    "RemovePeeringNetworkRequest",
    "RemoveResourcePoliciesDiskRequest",
    "RemoveResourcePoliciesInstanceRequest",
    "RemoveResourcePoliciesRegionDiskRequest",
    "RemoveRuleFirewallPolicyRequest",
    "RemoveRuleNetworkFirewallPolicyRequest",
    "RemoveRuleRegionNetworkFirewallPolicyRequest",
    "RemoveRuleRegionSecurityPolicyRequest",
    "RemoveRuleSecurityPolicyRequest",
    "ReportHostAsFaultyInstanceRequest",
    "RequestMirrorPolicy",
    "RequestRemovePeeringNetworkRequest",
    "Reservation",
    "ReservationAdvancedDeploymentControl",
    "ReservationAffinity",
    "ReservationAggregatedList",
    "ReservationBlock",
    "ReservationBlockHealthInfo",
    "ReservationBlockPhysicalTopology",
    "ReservationBlockPhysicalTopologyInstance",
    "ReservationBlockPhysicalTopologyInstancePhysicalHostTopology",
    "ReservationBlocksGetResponse",
    "ReservationBlocksListResponse",
    "ReservationList",
    "ReservationsBlocksPerformMaintenanceRequest",
    "ReservationsPerformMaintenanceRequest",
    "ReservationsResizeRequest",
    "ReservationsScopedList",
    "ReservationSubBlock",
    "ReservationSubBlockHealthInfo",
    "ReservationSubBlockPhysicalTopology",
    "ReservationSubBlocksGetResponse",
    "ReservationSubBlocksListResponse",
    "ResetInstanceRequest",
    "ResizeDiskRequest",
    "ResizeInstanceGroupManagerRequest",
    "ResizeRegionDiskRequest",
    "ResizeRegionInstanceGroupManagerRequest",
    "ResizeReservationRequest",
    "ResourceCommitment",
    "ResourceGroupReference",
    "ResourcePoliciesScopedList",
    "ResourcePolicy",
    "ResourcePolicyAggregatedList",
    "ResourcePolicyDailyCycle",
    "ResourcePolicyDiskConsistencyGroupPolicy",
    "ResourcePolicyGroupPlacementPolicy",
    "ResourcePolicyHourlyCycle",
    "ResourcePolicyInstanceSchedulePolicy",
    "ResourcePolicyInstanceSchedulePolicySchedule",
    "ResourcePolicyList",
    "ResourcePolicyResourceStatus",
    "ResourcePolicyResourceStatusInstanceSchedulePolicyStatus",
    "ResourcePolicySnapshotSchedulePolicy",
    "ResourcePolicySnapshotSchedulePolicyRetentionPolicy",
    "ResourcePolicySnapshotSchedulePolicySchedule",
    "ResourcePolicySnapshotSchedulePolicySnapshotProperties",
    "ResourcePolicyWeeklyCycle",
    "ResourcePolicyWeeklyCycleDayOfWeek",
    "ResourcePolicyWorkloadPolicy",
    "ResourceStatus",
    "ResourceStatusPhysicalHostTopology",
    "ResourceStatusScheduling",
    "ResumeInstanceRequest",
    "ResumeInstancesInstanceGroupManagerRequest",
    "ResumeInstancesRegionInstanceGroupManagerRequest",
    "Route",
    "RouteAsPath",
    "RouteList",
    "RouteParams",
    "RoutePolicy",
    "RoutePolicyPolicyTerm",
    "Router",
    "RouterAdvertisedIpRange",
    "RouterAggregatedList",
    "RouterBgp",
    "RouterBgpPeer",
    "RouterBgpPeerBfd",
    "RouterBgpPeerCustomLearnedIpRange",
    "RouterInterface",
    "RouterList",
    "RouterMd5AuthenticationKey",
    "RouterNat",
    "RouterNatLogConfig",
    "RouterNatRule",
    "RouterNatRuleAction",
    "RouterNatSubnetworkToNat",
    "RouterNatSubnetworkToNat64",
    "RoutersGetRoutePolicyResponse",
    "RoutersListBgpRoutes",
    "RoutersListRoutePolicies",
    "RoutersPreviewResponse",
    "RoutersScopedList",
    "RouterStatus",
    "RouterStatusBgpPeerStatus",
    "RouterStatusNatStatus",
    "RouterStatusNatStatusNatRuleStatus",
    "RouterStatusResponse",
    "SavedAttachedDisk",
    "SavedDisk",
    "ScalingScheduleStatus",
    "Scheduling",
    "SchedulingNodeAffinity",
    "SchedulingOnInstanceStopAction",
    "Screenshot",
    "SecurityPoliciesAggregatedList",
    "SecurityPoliciesListPreconfiguredExpressionSetsResponse",
    "SecurityPoliciesScopedList",
    "SecurityPoliciesWafConfig",
    "SecurityPolicy",
    "SecurityPolicyAdaptiveProtectionConfig",
    "SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig",
    "SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig",
    "SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfigTrafficGranularityConfig",
    "SecurityPolicyAdvancedOptionsConfig",
    "SecurityPolicyAdvancedOptionsConfigJsonCustomConfig",
    "SecurityPolicyDdosProtectionConfig",
    "SecurityPolicyList",
    "SecurityPolicyRecaptchaOptionsConfig",
    "SecurityPolicyReference",
    "SecurityPolicyRule",
    "SecurityPolicyRuleHttpHeaderAction",
    "SecurityPolicyRuleHttpHeaderActionHttpHeaderOption",
    "SecurityPolicyRuleMatcher",
    "SecurityPolicyRuleMatcherConfig",
    "SecurityPolicyRuleMatcherExprOptions",
    "SecurityPolicyRuleMatcherExprOptionsRecaptchaOptions",
    "SecurityPolicyRuleNetworkMatcher",
    "SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch",
    "SecurityPolicyRulePreconfiguredWafConfig",
    "SecurityPolicyRulePreconfiguredWafConfigExclusion",
    "SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams",
    "SecurityPolicyRuleRateLimitOptions",
    "SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig",
    "SecurityPolicyRuleRateLimitOptionsThreshold",
    "SecurityPolicyRuleRedirectOptions",
    "SecurityPolicyUserDefinedField",
    "SecuritySettings",
    "SendDiagnosticInterruptInstanceRequest",
    "SendDiagnosticInterruptInstanceResponse",
    "SerialPortOutput",
    "ServerBinding",
    "ServiceAccount",
    "ServiceAttachment",
    "ServiceAttachmentAggregatedList",
    "ServiceAttachmentConnectedEndpoint",
    "ServiceAttachmentConsumerProjectLimit",
    "ServiceAttachmentList",
    "ServiceAttachmentsScopedList",
    "SetBackendServiceTargetSslProxyRequest",
    "SetBackendServiceTargetTcpProxyRequest",
    "SetBackupTargetPoolRequest",
    "SetCertificateMapTargetHttpsProxyRequest",
    "SetCertificateMapTargetSslProxyRequest",
    "SetCloudArmorTierProjectRequest",
    "SetCommonInstanceMetadataOperationMetadata",
    "SetCommonInstanceMetadataOperationMetadataPerLocationOperationInfo",
    "SetCommonInstanceMetadataProjectRequest",
    "SetDefaultNetworkTierProjectRequest",
    "SetDeletionProtectionInstanceRequest",
    "SetDiskAutoDeleteInstanceRequest",
    "SetEdgeSecurityPolicyBackendBucketRequest",
    "SetEdgeSecurityPolicyBackendServiceRequest",
    "SetIamPolicyBackendBucketRequest",
    "SetIamPolicyBackendServiceRequest",
    "SetIamPolicyDiskRequest",
    "SetIamPolicyFirewallPolicyRequest",
    "SetIamPolicyImageRequest",
    "SetIamPolicyInstanceRequest",
    "SetIamPolicyInstanceTemplateRequest",
    "SetIamPolicyInstantSnapshotRequest",
    "SetIamPolicyInterconnectAttachmentGroupRequest",
    "SetIamPolicyInterconnectGroupRequest",
    "SetIamPolicyLicenseRequest",
    "SetIamPolicyMachineImageRequest",
    "SetIamPolicyNetworkAttachmentRequest",
    "SetIamPolicyNetworkFirewallPolicyRequest",
    "SetIamPolicyNodeGroupRequest",
    "SetIamPolicyNodeTemplateRequest",
    "SetIamPolicyRegionBackendServiceRequest",
    "SetIamPolicyRegionDiskRequest",
    "SetIamPolicyRegionInstantSnapshotRequest",
    "SetIamPolicyRegionNetworkFirewallPolicyRequest",
    "SetIamPolicyReservationRequest",
    "SetIamPolicyResourcePolicyRequest",
    "SetIamPolicyServiceAttachmentRequest",
    "SetIamPolicySnapshotRequest",
    "SetIamPolicyStoragePoolRequest",
    "SetIamPolicySubnetworkRequest",
    "SetInstanceTemplateInstanceGroupManagerRequest",
    "SetInstanceTemplateRegionInstanceGroupManagerRequest",
    "SetLabelsAddressRequest",
    "SetLabelsDiskRequest",
    "SetLabelsExternalVpnGatewayRequest",
    "SetLabelsForwardingRuleRequest",
    "SetLabelsGlobalAddressRequest",
    "SetLabelsGlobalForwardingRuleRequest",
    "SetLabelsImageRequest",
    "SetLabelsInstanceRequest",
    "SetLabelsInstantSnapshotRequest",
    "SetLabelsInterconnectAttachmentRequest",
    "SetLabelsInterconnectRequest",
    "SetLabelsMachineImageRequest",
    "SetLabelsRegionDiskRequest",
    "SetLabelsRegionInstantSnapshotRequest",
    "SetLabelsRegionSecurityPolicyRequest",
    "SetLabelsSecurityPolicyRequest",
    "SetLabelsSnapshotRequest",
    "SetLabelsTargetVpnGatewayRequest",
    "SetLabelsVpnGatewayRequest",
    "SetLabelsVpnTunnelRequest",
    "SetMachineResourcesInstanceRequest",
    "SetMachineTypeInstanceRequest",
    "SetMetadataInstanceRequest",
    "SetMinCpuPlatformInstanceRequest",
    "SetNamedPortsInstanceGroupRequest",
    "SetNamedPortsRegionInstanceGroupRequest",
    "SetNameInstanceRequest",
    "SetNodeTemplateNodeGroupRequest",
    "SetPrivateIpGoogleAccessSubnetworkRequest",
    "SetProxyHeaderTargetSslProxyRequest",
    "SetProxyHeaderTargetTcpProxyRequest",
    "SetQuicOverrideTargetHttpsProxyRequest",
    "SetSchedulingInstanceRequest",
    "SetSecurityPolicyBackendServiceRequest",
    "SetSecurityPolicyInstanceRequest",
    "SetSecurityPolicyRegionBackendServiceRequest",
    "SetSecurityPolicyTargetInstanceRequest",
    "SetSecurityPolicyTargetPoolRequest",
    "SetServiceAccountInstanceRequest",
    "SetShieldedInstanceIntegrityPolicyInstanceRequest",
    "SetSslCertificatesRegionTargetHttpsProxyRequest",
    "SetSslCertificatesTargetHttpsProxyRequest",
    "SetSslCertificatesTargetSslProxyRequest",
    "SetSslPolicyTargetHttpsProxyRequest",
    "SetSslPolicyTargetSslProxyRequest",
    "SetTagsInstanceRequest",
    "SetTargetForwardingRuleRequest",
    "SetTargetGlobalForwardingRuleRequest",
    "SetTargetPoolsInstanceGroupManagerRequest",
    "SetTargetPoolsRegionInstanceGroupManagerRequest",
    "SetUrlMapRegionTargetHttpProxyRequest",
    "SetUrlMapRegionTargetHttpsProxyRequest",
    "SetUrlMapTargetHttpProxyRequest",
    "SetUrlMapTargetHttpsProxyRequest",
    "SetUsageExportBucketProjectRequest",
    "ShareSettings",
    "ShareSettingsProjectConfig",
    "ShieldedInstanceConfig",
    "ShieldedInstanceIdentity",
    "ShieldedInstanceIdentityEntry",
    "ShieldedInstanceIntegrityPolicy",
    "SignedUrlKey",
    "SimulateMaintenanceEventInstanceRequest",
    "SimulateMaintenanceEventNodeGroupRequest",
    "Snapshot",
    "SnapshotList",
    "SnapshotSettings",
    "SnapshotSettingsStorageLocationSettings",
    "SnapshotSettingsStorageLocationSettingsStorageLocationPreference",
    "SourceDiskEncryptionKey",
    "SourceInstanceParams",
    "SourceInstanceProperties",
    "SslCertificate",
    "SslCertificateAggregatedList",
    "SslCertificateList",
    "SslCertificateManagedSslCertificate",
    "SslCertificateSelfManagedSslCertificate",
    "SslCertificatesScopedList",
    "SSLHealthCheck",
    "SslPoliciesAggregatedList",
    "SslPoliciesList",
    "SslPoliciesListAvailableFeaturesResponse",
    "SslPoliciesScopedList",
    "SslPolicy",
    "SslPolicyReference",
    "StartAsyncReplicationDiskRequest",
    "StartAsyncReplicationRegionDiskRequest",
    "StartInstanceRequest",
    "StartInstancesInstanceGroupManagerRequest",
    "StartInstancesRegionInstanceGroupManagerRequest",
    "StartWithEncryptionKeyInstanceRequest",
    "StatefulPolicy",
    "StatefulPolicyPreservedState",
    "StatefulPolicyPreservedStateDiskDevice",
    "StatefulPolicyPreservedStateNetworkIp",
    "Status",
    "StopAsyncReplicationDiskRequest",
    "StopAsyncReplicationRegionDiskRequest",
    "StopGroupAsyncReplicationDiskRequest",
    "StopGroupAsyncReplicationRegionDiskRequest",
    "StopInstanceRequest",
    "StopInstancesInstanceGroupManagerRequest",
    "StopInstancesRegionInstanceGroupManagerRequest",
    "StoragePool",
    "StoragePoolAggregatedList",
    "StoragePoolDisk",
    "StoragePoolList",
    "StoragePoolListDisks",
    "StoragePoolResourceStatus",
    "StoragePoolsScopedList",
    "StoragePoolType",
    "StoragePoolTypeAggregatedList",
    "StoragePoolTypeList",
    "StoragePoolTypesScopedList",
    "Subnetwork",
    "SubnetworkAggregatedList",
    "SubnetworkList",
    "SubnetworkLogConfig",
    "SubnetworkParams",
    "SubnetworkSecondaryRange",
    "SubnetworksExpandIpCidrRangeRequest",
    "SubnetworksScopedList",
    "SubnetworksScopedWarning",
    "SubnetworksSetPrivateIpGoogleAccessRequest",
    "Subsetting",
    "SuspendInstanceRequest",
    "SuspendInstancesInstanceGroupManagerRequest",
    "SuspendInstancesRegionInstanceGroupManagerRequest",
    "SwitchToCustomModeNetworkRequest",
    "Tags",
    "TargetGrpcProxy",
    "TargetGrpcProxyList",
    "TargetHttpProxiesScopedList",
    "TargetHttpProxy",
    "TargetHttpProxyAggregatedList",
    "TargetHttpProxyList",
    "TargetHttpsProxiesScopedList",
    "TargetHttpsProxiesSetCertificateMapRequest",
    "TargetHttpsProxiesSetQuicOverrideRequest",
    "TargetHttpsProxiesSetSslCertificatesRequest",
    "TargetHttpsProxy",
    "TargetHttpsProxyAggregatedList",
    "TargetHttpsProxyList",
    "TargetInstance",
    "TargetInstanceAggregatedList",
    "TargetInstanceList",
    "TargetInstancesScopedList",
    "TargetPool",
    "TargetPoolAggregatedList",
    "TargetPoolInstanceHealth",
    "TargetPoolList",
    "TargetPoolsAddHealthCheckRequest",
    "TargetPoolsAddInstanceRequest",
    "TargetPoolsRemoveHealthCheckRequest",
    "TargetPoolsRemoveInstanceRequest",
    "TargetPoolsScopedList",
    "TargetReference",
    "TargetSslProxiesSetBackendServiceRequest",
    "TargetSslProxiesSetCertificateMapRequest",
    "TargetSslProxiesSetProxyHeaderRequest",
    "TargetSslProxiesSetSslCertificatesRequest",
    "TargetSslProxy",
    "TargetSslProxyList",
    "TargetTcpProxiesScopedList",
    "TargetTcpProxiesSetBackendServiceRequest",
    "TargetTcpProxiesSetProxyHeaderRequest",
    "TargetTcpProxy",
    "TargetTcpProxyAggregatedList",
    "TargetTcpProxyList",
    "TargetVpnGateway",
    "TargetVpnGatewayAggregatedList",
    "TargetVpnGatewayList",
    "TargetVpnGatewaysScopedList",
    "TCPHealthCheck",
    "TestFailure",
    "TestIamPermissionsBackendBucketRequest",
    "TestIamPermissionsBackendServiceRequest",
    "TestIamPermissionsDiskRequest",
    "TestIamPermissionsExternalVpnGatewayRequest",
    "TestIamPermissionsFirewallPolicyRequest",
    "TestIamPermissionsImageRequest",
    "TestIamPermissionsInstanceRequest",
    "TestIamPermissionsInstanceTemplateRequest",
    "TestIamPermissionsInstantSnapshotRequest",
    "TestIamPermissionsInterconnectAttachmentGroupRequest",
    "TestIamPermissionsInterconnectGroupRequest",
    "TestIamPermissionsLicenseCodeRequest",
    "TestIamPermissionsLicenseRequest",
    "TestIamPermissionsMachineImageRequest",
    "TestIamPermissionsNetworkAttachmentRequest",
    "TestIamPermissionsNetworkEndpointGroupRequest",
    "TestIamPermissionsNetworkFirewallPolicyRequest",
    "TestIamPermissionsNodeGroupRequest",
    "TestIamPermissionsNodeTemplateRequest",
    "TestIamPermissionsPacketMirroringRequest",
    "TestIamPermissionsRegionBackendServiceRequest",
    "TestIamPermissionsRegionDiskRequest",
    "TestIamPermissionsRegionInstantSnapshotRequest",
    "TestIamPermissionsRegionNetworkFirewallPolicyRequest",
    "TestIamPermissionsReservationRequest",
    "TestIamPermissionsResourcePolicyRequest",
    "TestIamPermissionsServiceAttachmentRequest",
    "TestIamPermissionsSnapshotRequest",
    "TestIamPermissionsStoragePoolRequest",
    "TestIamPermissionsSubnetworkRequest",
    "TestIamPermissionsVpnGatewayRequest",
    "TestPermissionsRequest",
    "TestPermissionsResponse",
    "Uint128",
    "UpcomingMaintenance",
    "UpdateAccessConfigInstanceRequest",
    "UpdateAutoscalerRequest",
    "UpdateBackendBucketRequest",
    "UpdateBackendServiceRequest",
    "UpdateDiskRequest",
    "UpdateDisplayDeviceInstanceRequest",
    "UpdateFirewallRequest",
    "UpdateHealthCheckRequest",
    "UpdateInstanceRequest",
    "UpdateLicenseRequest",
    "UpdateNetworkInterfaceInstanceRequest",
    "UpdatePeeringNetworkRequest",
    "UpdatePerInstanceConfigsInstanceGroupManagerRequest",
    "UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest",
    "UpdateRegionAutoscalerRequest",
    "UpdateRegionBackendServiceRequest",
    "UpdateRegionCommitmentRequest",
    "UpdateRegionDiskRequest",
    "UpdateRegionHealthCheckRequest",
    "UpdateRegionUrlMapRequest",
    "UpdateReservationRequest",
    "UpdateRoutePolicyRouterRequest",
    "UpdateRouterRequest",
    "UpdateShieldedInstanceConfigInstanceRequest",
    "UpdateStoragePoolRequest",
    "UpdateUrlMapRequest",
    "UrlMap",
    "UrlMapList",
    "UrlMapReference",
    "UrlMapsAggregatedList",
    "UrlMapsScopedList",
    "UrlMapsValidateRequest",
    "UrlMapsValidateResponse",
    "UrlMapTest",
    "UrlMapTestHeader",
    "UrlMapValidationResult",
    "UrlRewrite",
    "UsableSubnetwork",
    "UsableSubnetworksAggregatedList",
    "UsableSubnetworkSecondaryRange",
    "UsageExportLocation",
    "ValidateRegionUrlMapRequest",
    "ValidateUrlMapRequest",
    "VmEndpointNatMappings",
    "VmEndpointNatMappingsInterfaceNatMappings",
    "VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings",
    "VmEndpointNatMappingsList",
    "VpnGateway",
    "VpnGatewayAggregatedList",
    "VpnGatewayList",
    "VpnGatewaysGetStatusResponse",
    "VpnGatewaysScopedList",
    "VpnGatewayStatus",
    "VpnGatewayStatusHighAvailabilityRequirementState",
    "VpnGatewayStatusTunnel",
    "VpnGatewayStatusVpnConnection",
    "VpnGatewayVpnGatewayInterface",
    "VpnTunnel",
    "VpnTunnelAggregatedList",
    "VpnTunnelList",
    "VpnTunnelsScopedList",
    "WafExpressionSet",
    "WafExpressionSetExpression",
    "WaitGlobalOperationRequest",
    "WaitRegionOperationRequest",
    "WaitZoneOperationRequest",
    "Warning",
    "Warnings",
    "WeightedBackendService",
    "WithdrawPublicAdvertisedPrefixeRequest",
    "WithdrawPublicDelegatedPrefixeRequest",
    "XpnHostList",
    "XpnResourceId",
    "Zone",
    "ZoneList",
    "ZoneSetLabelsRequest",
    "ZoneSetPolicyRequest",
)
