"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.1.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from delphix.api.gateway.exceptions import ApiAttributeError


def lazy_import():
    from delphix.api.gateway.model.oracle_virtual_ip import OracleVirtualIP
    globals()['OracleVirtualIP'] = OracleVirtualIP


class Host(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
        ('id',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('nfs_addresses',): {
        },
        ('dsp_keystore_alias',): {
            'min_length': 1,
        },
        ('dsp_keystore_path',): {
            'min_length': 1,
        },
        ('dsp_truststore_path',): {
            'min_length': 1,
        },
        ('java_home',): {
            'min_length': 1,
        },
        ('toolkit_path',): {
            'min_length': 1,
        },
        ('oracle_tde_keystores_root_path',): {
            'min_length': 1,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'id': (str,),  # noqa: E501
            'hostname': (str,),  # noqa: E501
            'os_name': (str,),  # noqa: E501
            'os_version': (str,),  # noqa: E501
            'memory_size': (int,),  # noqa: E501
            'available': (bool,),  # noqa: E501
            'available_timestamp': (datetime,),  # noqa: E501
            'not_available_reason': (str,),  # noqa: E501
            'oracle_cluster_node_reference': (str,),  # noqa: E501
            'oracle_cluster_node_name': (str,),  # noqa: E501
            'oracle_cluster_node_enabled': (bool,),  # noqa: E501
            'oracle_cluster_node_discovered': (bool,),  # noqa: E501
            'oracle_cluster_node_virtual_ips': ([OracleVirtualIP],),  # noqa: E501
            'windows_cluster_node_reference': (str,),  # noqa: E501
            'windows_cluster_node_name': (str,),  # noqa: E501
            'windows_cluster_node_discovered': (bool,),  # noqa: E501
            'nfs_addresses': ([str],),  # noqa: E501
            'dsp_keystore_alias': (str,),  # noqa: E501
            'dsp_keystore_path': (str,),  # noqa: E501
            'dsp_truststore_path': (str,),  # noqa: E501
            'java_home': (str,),  # noqa: E501
            'ssh_port': (int,),  # noqa: E501
            'toolkit_path': (str,),  # noqa: E501
            'oracle_tde_keystores_root_path': (str,),  # noqa: E501
            'processor_type': (str,),  # noqa: E501
            'timezone': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'id': 'id',  # noqa: E501
        'hostname': 'hostname',  # noqa: E501
        'os_name': 'os_name',  # noqa: E501
        'os_version': 'os_version',  # noqa: E501
        'memory_size': 'memory_size',  # noqa: E501
        'available': 'available',  # noqa: E501
        'available_timestamp': 'available_timestamp',  # noqa: E501
        'not_available_reason': 'not_available_reason',  # noqa: E501
        'oracle_cluster_node_reference': 'oracle_cluster_node_reference',  # noqa: E501
        'oracle_cluster_node_name': 'oracle_cluster_node_name',  # noqa: E501
        'oracle_cluster_node_enabled': 'oracle_cluster_node_enabled',  # noqa: E501
        'oracle_cluster_node_discovered': 'oracle_cluster_node_discovered',  # noqa: E501
        'oracle_cluster_node_virtual_ips': 'oracle_cluster_node_virtual_ips',  # noqa: E501
        'windows_cluster_node_reference': 'windows_cluster_node_reference',  # noqa: E501
        'windows_cluster_node_name': 'windows_cluster_node_name',  # noqa: E501
        'windows_cluster_node_discovered': 'windows_cluster_node_discovered',  # noqa: E501
        'nfs_addresses': 'nfs_addresses',  # noqa: E501
        'dsp_keystore_alias': 'dsp_keystore_alias',  # noqa: E501
        'dsp_keystore_path': 'dsp_keystore_path',  # noqa: E501
        'dsp_truststore_path': 'dsp_truststore_path',  # noqa: E501
        'java_home': 'java_home',  # noqa: E501
        'ssh_port': 'ssh_port',  # noqa: E501
        'toolkit_path': 'toolkit_path',  # noqa: E501
        'oracle_tde_keystores_root_path': 'oracle_tde_keystores_root_path',  # noqa: E501
        'processor_type': 'processor_type',  # noqa: E501
        'timezone': 'timezone',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """Host - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): The entity ID of this Host.. [optional]  # noqa: E501
            hostname (str): The hostname or IP address of this host.. [optional]  # noqa: E501
            os_name (str): The name of the OS on this host.. [optional]  # noqa: E501
            os_version (str): The version of the OS on this host.. [optional]  # noqa: E501
            memory_size (int): The total amount of memory on this host in bytes.. [optional]  # noqa: E501
            available (bool): True if the host is up and a connection can be established from the engine.. [optional]  # noqa: E501
            available_timestamp (datetime): The last time the available property was updated.. [optional]  # noqa: E501
            not_available_reason (str): The reason why the host is not available.. [optional]  # noqa: E501
            oracle_cluster_node_reference (str): The reference to the associated OracleClusterNode.. [optional]  # noqa: E501
            oracle_cluster_node_name (str): The name of the associated OracleClusterNode.. [optional]  # noqa: E501
            oracle_cluster_node_enabled (bool): Whether the associated OracleClusterNode is enabled.. [optional]  # noqa: E501
            oracle_cluster_node_discovered (bool): Whether the associated OracleClusterNode was discovered.. [optional]  # noqa: E501
            oracle_cluster_node_virtual_ips ([OracleVirtualIP]): The Virtual IP addresses associated with the OracleClusterNode.. [optional]  # noqa: E501
            windows_cluster_node_reference (str): The reference to the associated WindowsClusterNode.. [optional]  # noqa: E501
            windows_cluster_node_name (str): The name of the associated WindowsClusterNode.. [optional]  # noqa: E501
            windows_cluster_node_discovered (bool): Whether the associated Windows cluster node was discovered.. [optional]  # noqa: E501
            nfs_addresses ([str]): The list of host/IP addresses to use for NFS export.. [optional]  # noqa: E501
            dsp_keystore_alias (str): The lowercase alias to use inside the user managed DSP keystore.. [optional]  # noqa: E501
            dsp_keystore_path (str): The path to the user managed DSP keystore.. [optional]  # noqa: E501
            dsp_truststore_path (str): The path to the user managed DSP truststore.. [optional]  # noqa: E501
            java_home (str): The path to the user managed Java Development Kit (JDK). If not specified, then the OpenJDK will be used.. [optional]  # noqa: E501
            ssh_port (int): The port number used to connect to the host via SSH.. [optional]  # noqa: E501
            toolkit_path (str): The path for the toolkit that resides on the host.. [optional]  # noqa: E501
            oracle_tde_keystores_root_path (str): The path to the root of the Oracle TDE keystores artifact directories.. [optional]  # noqa: E501
            processor_type (str): The platform for the host machine.. [optional]  # noqa: E501
            timezone (str): The OS timezone.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """Host - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): The entity ID of this Host.. [optional]  # noqa: E501
            hostname (str): The hostname or IP address of this host.. [optional]  # noqa: E501
            os_name (str): The name of the OS on this host.. [optional]  # noqa: E501
            os_version (str): The version of the OS on this host.. [optional]  # noqa: E501
            memory_size (int): The total amount of memory on this host in bytes.. [optional]  # noqa: E501
            available (bool): True if the host is up and a connection can be established from the engine.. [optional]  # noqa: E501
            available_timestamp (datetime): The last time the available property was updated.. [optional]  # noqa: E501
            not_available_reason (str): The reason why the host is not available.. [optional]  # noqa: E501
            oracle_cluster_node_reference (str): The reference to the associated OracleClusterNode.. [optional]  # noqa: E501
            oracle_cluster_node_name (str): The name of the associated OracleClusterNode.. [optional]  # noqa: E501
            oracle_cluster_node_enabled (bool): Whether the associated OracleClusterNode is enabled.. [optional]  # noqa: E501
            oracle_cluster_node_discovered (bool): Whether the associated OracleClusterNode was discovered.. [optional]  # noqa: E501
            oracle_cluster_node_virtual_ips ([OracleVirtualIP]): The Virtual IP addresses associated with the OracleClusterNode.. [optional]  # noqa: E501
            windows_cluster_node_reference (str): The reference to the associated WindowsClusterNode.. [optional]  # noqa: E501
            windows_cluster_node_name (str): The name of the associated WindowsClusterNode.. [optional]  # noqa: E501
            windows_cluster_node_discovered (bool): Whether the associated Windows cluster node was discovered.. [optional]  # noqa: E501
            nfs_addresses ([str]): The list of host/IP addresses to use for NFS export.. [optional]  # noqa: E501
            dsp_keystore_alias (str): The lowercase alias to use inside the user managed DSP keystore.. [optional]  # noqa: E501
            dsp_keystore_path (str): The path to the user managed DSP keystore.. [optional]  # noqa: E501
            dsp_truststore_path (str): The path to the user managed DSP truststore.. [optional]  # noqa: E501
            java_home (str): The path to the user managed Java Development Kit (JDK). If not specified, then the OpenJDK will be used.. [optional]  # noqa: E501
            ssh_port (int): The port number used to connect to the host via SSH.. [optional]  # noqa: E501
            toolkit_path (str): The path for the toolkit that resides on the host.. [optional]  # noqa: E501
            oracle_tde_keystores_root_path (str): The path to the root of the Oracle TDE keystores artifact directories.. [optional]  # noqa: E501
            processor_type (str): The platform for the host machine.. [optional]  # noqa: E501
            timezone (str): The OS timezone.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
