"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Trail = exports.TrailProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const actiontrail_generated_1 = require("./actiontrail.generated");
Object.defineProperty(exports, "TrailProperty", { enumerable: true, get: function () { return actiontrail_generated_1.RosTrail; } });
/**
 * A ROS resource type:  `ALIYUN::ACTIONTRAIL::Trail`
 */
class Trail extends ros.Resource {
    /**
     * Create a new `ALIYUN::ACTIONTRAIL::Trail`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosTrail = new actiontrail_generated_1.RosTrail(this, id, {
            slsProjectArn: props.slsProjectArn,
            roleName: props.roleName,
            eventRw: props.eventRw ? props.eventRw : 'Write',
            ossKeyPrefix: props.ossKeyPrefix,
            ossBucketName: props.ossBucketName,
            slsWriteRoleArn: props.slsWriteRoleArn,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTrail;
        this.attrName = rosTrail.attrName;
    }
}
exports.Trail = Trail;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHJhaWwuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0cmFpbC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw4Q0FBOEM7QUFDOUMsbUVBQW1EO0FBRTlCLDhGQUZaLGdDQUFRLE9BRWlCO0FBMkNsQzs7R0FFRztBQUNILE1BQWEsS0FBTSxTQUFRLEdBQUcsQ0FBQyxRQUFRO0lBWW5DOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBaUIsRUFBRSxtQ0FBMkMsSUFBSTtRQUM1RyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0sUUFBUSxHQUFHLElBQUksZ0NBQVEsQ0FBQyxJQUFJLEVBQUUsRUFBRSxFQUFHO1lBQ3JDLGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtZQUNsQyxRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVE7WUFDeEIsT0FBTyxFQUFFLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLE9BQU87WUFDaEQsWUFBWSxFQUFFLEtBQUssQ0FBQyxZQUFZO1lBQ2hDLGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtZQUNsQyxlQUFlLEVBQUUsS0FBSyxDQUFDLGVBQWU7WUFDdEMsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJO1NBQ25CLEVBQUUsZ0NBQWdDLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO1FBQ3BGLElBQUksQ0FBQyxRQUFRLEdBQUcsUUFBUSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxRQUFRLEdBQUcsUUFBUSxDQUFDLFFBQVEsQ0FBQztJQUN0QyxDQUFDO0NBQ0o7QUFsQ0Qsc0JBa0NDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcm9zIGZyb20gJ0BhbGljbG91ZC9yb3MtY2RrLWNvcmUnO1xuaW1wb3J0IHsgUm9zVHJhaWwgfSBmcm9tICcuL2FjdGlvbnRyYWlsLmdlbmVyYXRlZCc7XG4vLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIFNwZWNpZmljYXRpb25cbmV4cG9ydCB7IFJvc1RyYWlsIGFzIFRyYWlsUHJvcGVydHkgfTtcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBBTElZVU46OkFDVElPTlRSQUlMOjpUcmFpbGBcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBUcmFpbFByb3BzIHtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IG5hbWU6IFRoZSBuYW1lIG9mIHRoZSB0cmFpbCB0byBiZSBjcmVhdGVkLCB3aGljaCBtdXN0IGJlIHVuaXF1ZSBmb3IgYW4gYWNjb3VudC5cbiAgICAgKi9cbiAgICByZWFkb25seSBuYW1lOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBvc3NCdWNrZXROYW1lOiBUaGUgT1NTIGJ1Y2tldCB0byB3aGljaCB0aGUgdHJhaWwgZGVsaXZlcnMgbG9ncy4gRW5zdXJlIHRoYXQgdGhpcyBpcyBhbiBleGlzdGluZyBPU1MgYnVja2V0LlxuICAgICAqL1xuICAgIHJlYWRvbmx5IG9zc0J1Y2tldE5hbWU6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHJvbGVOYW1lOiBUaGUgUkFNIHJvbGUgaW4gQWN0aW9uVHJhaWwgcGVybWl0dGVkIGJ5IHRoZSB1c2VyLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJvbGVOYW1lOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBldmVudFJ3OiBJbmRpY2F0ZXMgd2hldGhlciB0aGUgZXZlbnQgaXMgYSByZWFkIG9yIGEgd3JpdGUgZXZlbnQuIFZhbGlkIHZhbHVlczogUmVhZCwgV3JpdGUsIGFuZCBBbGwuIERlZmF1bHQgdmFsdWU6IFdyaXRlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGV2ZW50Unc/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBvc3NLZXlQcmVmaXg6IFRoZSBwcmVmaXggb2YgdGhlIHNwZWNpZmllZCBPU1MgYnVja2V0IG5hbWUuIFRoaXMgcGFyYW1ldGVyIGNhbiBiZSBsZWZ0IGVtcHR5LlxuICAgICAqL1xuICAgIHJlYWRvbmx5IG9zc0tleVByZWZpeD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHNsc1Byb2plY3RBcm46IFRoZSB1bmlxdWUgQVJOIG9mIHRoZSBMb2cgU2VydmljZSBwcm9qZWN0LlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNsc1Byb2plY3RBcm4/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBzbHNXcml0ZVJvbGVBcm46IFRoZSB1bmlxdWUgQVJOIG9mIHRoZSBMb2cgU2VydmljZSByb2xlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNsc1dyaXRlUm9sZUFybj86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcbn1cblxuLyoqXG4gKiBBIFJPUyByZXNvdXJjZSB0eXBlOiAgYEFMSVlVTjo6QUNUSU9OVFJBSUw6OlRyYWlsYFxuICovXG5leHBvcnQgY2xhc3MgVHJhaWwgZXh0ZW5kcyByb3MuUmVzb3VyY2Uge1xuXG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIHByb3BlcnRpZXMgb2YgdGhpcyBST1MgcmVzb3VyY2UsIHdoaWNoIHdpbGwgYmUgYXNzaWduZWQgdG8gUk9TIHJlc291cmNlLlxuICAgICAqL1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIE5hbWU6IFRoZSBuYW1lIG9mIHRoZSB0cmFpbCB0byBiZSBjcmVhdGVkLCB3aGljaCBtdXN0IGJlIHVuaXF1ZSBmb3IgYW4gYWNjb3VudC5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ck5hbWU6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIENyZWF0ZSBhIG5ldyBgQUxJWVVOOjpBQ1RJT05UUkFJTDo6VHJhaWxgLlxuICAgICAqXG4gICAgICogUGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBQYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBQYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3RvcihzY29wZTogcm9zLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFRyYWlsUHJvcHMsIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OmJvb2xlYW4gPSB0cnVlKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICAgICAgY29uc3Qgcm9zVHJhaWwgPSBuZXcgUm9zVHJhaWwodGhpcywgaWQsICB7XG4gICAgICAgICAgICBzbHNQcm9qZWN0QXJuOiBwcm9wcy5zbHNQcm9qZWN0QXJuLFxuICAgICAgICAgICAgcm9sZU5hbWU6IHByb3BzLnJvbGVOYW1lLFxuICAgICAgICAgICAgZXZlbnRSdzogcHJvcHMuZXZlbnRSdyA/IHByb3BzLmV2ZW50UncgOiAnV3JpdGUnLFxuICAgICAgICAgICAgb3NzS2V5UHJlZml4OiBwcm9wcy5vc3NLZXlQcmVmaXgsXG4gICAgICAgICAgICBvc3NCdWNrZXROYW1lOiBwcm9wcy5vc3NCdWNrZXROYW1lLFxuICAgICAgICAgICAgc2xzV3JpdGVSb2xlQXJuOiBwcm9wcy5zbHNXcml0ZVJvbGVBcm4sXG4gICAgICAgICAgICBuYW1lOiBwcm9wcy5uYW1lLFxuICAgICAgICB9LCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCAmJiB0aGlzLnN0YWNrLmVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50KTtcbiAgICAgICAgdGhpcy5yZXNvdXJjZSA9IHJvc1RyYWlsO1xuICAgICAgICB0aGlzLmF0dHJOYW1lID0gcm9zVHJhaWwuYXR0ck5hbWU7XG4gICAgfVxufVxuIl19