# -*- coding: utf-8 -*-

STIJLDATA = [
    {   u'broader': [],
        u'id': 64,
        u'labels': [   {   'label': u'acheuleaan',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'Acheulien',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [62],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Genoemd naar de vindplaats Saint-Acheul in de buurt van Amiens (Fr.). Het acheuleaan dekt het hele oudpaleolithicum. Deze cultuur wordt gekenmerkt door een meer verfijnde afslagstijl gericht op de vervaardiging van massieve werktuigen die aan beide zijden (bifaciaal) bewerkt zijn. Het meest karakteristieke bifaciaal werktuig is de vuistbijl. Het acheuleaan kent vooral een verspreiding in westelijk Europa, ongeveer tot aan de Rijn. In de rest van Europa vindt men een minder verfijnde cultuur terug, nl. het Clactoniaan.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) cursusmateriaal UGent (Prof. Ph. Cromb\xe9) \n2) VIOE',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/64'},
    {   u'broader': [],
        u'id': 65,
        u'labels': [   {   'label': u'ahrensburgiaan',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'Ahrensburgien',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [62],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Het ahrensburgiaan uit Noord-Europa (het laagland dat nu de Noordzee is, van Duitsland tot Nederland en Zuidoost-Engeland), genoemd naar de Duitse site van Ahrensburg-Stellmoor, vormde zonder twijfel de voorbode van het mesolithicum. De steenindustrie kenmerkt zich door een toenemende microlithisatie die vooral in de pijlbewapening tot uiting komt. In het ahrensburgiaan verschijnen immers de eerste microlieten. Het belangrijkste gidsfossiel is de steelspits.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) cursusmateriaal UGent (Prof. Ph. Cromb\xe9) \n2) Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a> \n3) Louwe Kooijmans L., van den Broecke P.W., Fokkens H. en van Gijn A. (eds.), 2005, Nederland in de prehistorie, Amsterdam.',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/65'},
    {   u'broader': [],
        u'id': 22,
        u'labels': [   {   'label': u'art deco',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [60],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'In de art deco wordt de geometrie tot ornament gemaakt. Aanvankelijk (proto-art deco) worden neoclassicistische gevels onder Weense en Franse invloed voorzien van geometrisch gestileerde ornamenten. Onder invloed van de Nederlandse architectuur wordt een spel met baksteenverbanden en baksteenkleuren ingevoerd. Het gehele gevelschema wordt geometrisch, door geknikte gevelvormen, en vensters en deuren met afgeschuinde bovenhoeken of in ruit- en trapeziumvorm. De geometrische ornamentiek wordt aangevuld met smeedwerk en glas in lood. De driehoek is een populair element. In de jaren 1930 evolueert de art deco. Elementen uit het modernisme en vooral uit de scheepsarchitectuur worden op zeer decoratieve wijze in gevels ge\xefntegreerd: vlaggenmasten, patrijspoortvensters, gestroomlijnde vormen. (ca. 1910 tot Tweede Wereldoorlog).',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [{   'citation': u'VIOE', 'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/22'},
    {   u'broader': [],
        u'id': 30,
        u'labels': [   {   'label': u'art nouveau',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'Jugendstil',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [60],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u"De art nouveau is een internationele beweging als reactie op de neostijlen, maar met sterk lokale verschillen. In Belgi\xeb kent de stijl twee stromingen, namelijk enerzijds de florale art nouveau met Victor Horta als boegbeeld en anderzijds de geometrische art nouveau be\xefnvloed door de Wiener Secession, met Paul Hankar als boegbeeld. Het is een bouwstijl waarbij men constructieve elementen toont, echter op zo'n manier dat zij ook als versiering dienen. Deze stijl wordt gekenmerkt door het gebruik van giet- en smeedijzer en glas, asymmetrie en een vloeiend lijnenspel. De dieren- en plantenwereld was een bron van inspiratie voor de ornamenten. Het is een totaalkunstvorm, die - op zijn best - zowel het interieur als het exterieur tot in de kleinste details omvat. (ca. 1890 tot WO I)",
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'HASLINGHUIS, E.J. en JANSE, H., Verklarend woordenboek van de westerse architectuur- en bouwhistorie: bouwkundige termen, Leiden, 2005.',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/30'},
    {   u'broader': [],
        u'id': 66,
        u'labels': [   {   'label': u'aurignaciaan',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'Aurignacien',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [62],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u"Het aurignaciaan kenmerkt zich door zijn zeer grote verspreiding en uniformiteit over zowat gans Europa en het Nabije Oosten. De gidsfossielen zijn kielschrabbers, boogstekers en zgn. 'lamelles Dufour'. Onder de benen artefacten vermelden we de assegaaien. Deze cultuur kan gedateerd worden van 35000 BP tot 29000 BP.",
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) cursusmateriaal UGent (Prof. Ph. Cromb\xe9) \n2) VIOE',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/66'},
    {   u'broader': [],
        u'id': 93,
        u'labels': [   {   'label': u'bandkeramiek',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'LBK',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [62],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Deze cultuur dankt haar naam aan het aardewerk met ronde bodems dat met typische banden is versierd. De BK-cultuur kan gedateerd worden tussen 5500 en 5000/4900 v.Chr. De Bandkeramische verspreiding vanuit Centraal-Europa in westelijke en noordwestelijke richting gebeurde in 4 fasen: de oudste BK, de oude BK, de midden BK en de recent BK-fase. Tegen circa 5250 v.Chr. heeft de Bandkeramiek ook Vlaanderen en zijn grootste verspreiding bereikt. De meeste Bandkeramische sites zijn ingeplant op loessgronden, die het best geschikt waren voor primitieve landbouw. Het zijn meestal open dorpen, waar enkele families samen hebben geleefd. Doorgaans bestaan ze uit enkele huizen, die steeds noordwest-zuidoost geori\xebnteerd. De precieze reden voor het plotse verdwijnen van de Bandkeramiek rond 4900 v.Chr. is vooralsnog niet bekend.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) cursusmateriaal UGent (Prof. Ph. Cromb\xe9) 2) VIOE',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/93'},
    {   u'broader': [],
        u'id': 7,
        u'labels': [   {   'label': u'barok',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [60],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De barok is een bouwstijl die gekenmerkt wordt door volplastische vormen, gebogen lijnen (concaaf-convex) en een contrast tussen licht en donker, massa en leegte. Kenmerkend voor de barokke gevels zijn de voluut- en klokgevels. Ook werd de kolossale orde ingevoerd op de rijkversierde gevels. Voor de versiering vond de barok haar inspiratie vaak in de oudheid, zoals de zuilenordes en frontons. Deze worden aangevuld met voluten en vlampotten. (grosso modo 17de eeuw)',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'HASLINGHUIS, E.J. en JANSE, H., Verklarend woordenboek van de westerse architectuur- en bouwhistorie: bouwkundige termen, Leiden, 2005; Nederlandse Art and Architecture Thesaurus (www.aat-ned.nl).',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/7'},
    {   u'broader': [35],
        u'id': 32,
        u'labels': [   {   'label': u'beaux-artsstijl',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De beaux-artsstijl is een architectuurstroming ontstaan uit het onderwijs aan de Franse Ecoles des Beaux Arts. De stijl wordt gekenmerkt door reminiscenties aan de grote Franse architectuurstijlen uit de 18de eeuw: classicerende barok, rococo en classicisme. Het gaat om rijk en zorgvuldig gedecoreerde gevels in natuursteen en/of simili of in combinatie met baksteen. Borstweringen en poorten worden fraai uitgewerkt in smeedwerk. (laatste kwart 19de eeuw - ca. 1930)',
                          'type': 'scopeNote'}],
        u'related': [12],
        u'sources': [   {   'citation': u'www.irismonument.be; Nederlandse Art and Architecture Thesaurus (www.aat-ned.nl).',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/32'},
    {   u'broader': [],
        u'id': 28,
        u'labels': [   {   'label': u'brutalisme',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [60],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Het brutalisme gaat terug op de late werken van Le Corbusier, met zijn expressieve, ruw afgewerkte vormen. Typisch is het toepassen van zichtbaar metselwerk en ruw, onversierd beton (zogenaamd zichtbeton of b\xe9ton brut), waarbij de textuur van het bekistingshout wordt gebruikt om het materiaal te vormen. (jaren 1950 - 1970)',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'VIOE, op basis van TRACHTENBERG M. &amp; HYMAN I. 2002: Architecture from Prehistory to Postmodernity, New Jersey.',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/28'},
    {   u'broader': [],
        u'id': 8,
        u'labels': [   {   'label': u'classicerende barok',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'Lodewijk-XIV-stijl',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [60],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De classicerende barok werd ontwikkeld in Frankrijk en sluit aan bij de barok, maar laat zich sterker inspireren door de klassieke vormentaal. De gebouwen hebben dikwijls nog een zware vormgeving die aansluit bij de baroktraditie. Typische elementen zijn de halsgevel, geflankeerd door vleugelstukken in de vorm van voluten; een fronton op zware voluutconsoles; siervazen; vlampotten (pot-\xe0-feu); bloemenslingers (guirlandes, festoenen), balustrades en panelen met uitgeronde hoeken op de borstwering van de vensters. Imitatiebanden leggen de nadruk op de verschillende geledingen van de gevel.  (grosso modo eerste helft 18de eeuw)',
                          'type': 'scopeNote'}],
        u'related': [12],
        u'sources': [{   'citation': u'VIOE', 'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/8'},
    {   u'broader': [],
        u'id': 10,
        u'labels': [   {   'label': u'classicisme',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'Lodewijk XVI-stijl',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [60],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Het classicisme is een strakke architectuur ge\xefnspireerd op de bouwstijl van de klassieke oudheid, zoals de Griekse of Romeinse tempelgevel met fronton en zuilenporticus. Men keerde terug naar de symmetrie en de rechte lijnen. De spaarzame decoratie bestaat onder meer uit: guirlandes of festoenen, consoles, urnen en rozetten. Ook klassieke palmetten, meanders, kraal- en eierlijsten worden aangetroffen. Deze stijl (ca. tweede helft 18de eeuw) gaat in het eerste kwart van de 19de eeuw geleidelijk over in het laatclassicisme.',
                          'type': 'scopeNote'},
                      {   'language': u'nl-BE',
                          'markup': 'HTML',
                          'note': u'26/11/2014: aanpassing laatste zin door Leen Meganck, op basis van discussie <a href="https://trac.onroerenderfgoed.be/oei/ticket/2181">https://trac.onroerenderfgoed.be/oei/ticket/2181</a>',
                          'type': 'historyNote'},
                      {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'In de Databank Bouwkundig Erfgoed worden gebouwen in laatclassicistische stijl ook opgenomen onder classicisme.',
                          'type': 'note'}],
        u'related': [12],
        u'sources': [   {   'citation': u'KOCH W. 1988: De Europese bouwstijlen, Amsterdam.',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/10'},
    {   u'broader': [],
        u'id': 31,
        u'labels': [   {   'label': u'cottagestijl',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'Normandische stijl',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [60],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De cottagestijl inspireert zich op de Engelse landelijke cottages. Het pittoreske effect van het exterieur werd onder meer bereikt door het gebruik van traditionele materialen zoals hout, baksteen of natuursteen, traditionele bouwtechnieken zoals vakwerkbouw en een asymmetrische opbouw. Een onregelmatig grondplan in L-vorm of met veel erkers en insprongen, vensters van diverse grootte en een levendig spel van daken en schouwen zorgden voor een gevarieerd exterieur van de woningen in cottagestijl.(laatste kwart 19de en eerste helft 20ste eeuw)',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [{   'citation': u'VIOE', 'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/31'},
    {   u'broader': [],
        u'id': 67,
        u'labels': [   {   'label': u'creswelliaan',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'Creswellien',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [62],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Het creswelliaan is een uitgesproken Noord-Europese traditie (zuidelijk UK). Gidsfossielen zijn de Creswell- en Cheddarspits. Deze traditie kan gedateerd worden van 12500 tot 12000 BP en is gelijktijdig met het hamburgiaan. De aanwezigheid van deze cultuur in Belgi\xeb is nog betwistbaar.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) cursusmateriaal UGent (Prof. Ph. Cromb\xe9) \n2) VIOE',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/67'},
    {   u'id': 61,
        u'labels': [   {   'label': u'culturen',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'member_of': [],
        u'members': [62, 63],
        u'notes': [],
        u'sources': [],
        u'superordinates': [],
        u'type': u'collection',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/61'},
    {   u'id': 63,
        u'labels': [   {   'label': u'culturen uit de metaaltijden',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'member_of': [61],
        u'members': [114, 115, 116, 117, 119, 120, 121],
        u'notes': [],
        u'sources': [],
        u'superordinates': [],
        u'type': u'collection',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/63'},
    {   u'id': 62,
        u'labels': [   {   'label': u'culturen uit de steentijd',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'member_of': [61],
        u'members': [   64,
                        65,
                        66,
                        67,
                        68,
                        69,
                        82,
                        87,
                        88,
                        89,
                        91,
                        93,
                        95,
                        97,
                        98,
                        100,
                        102,
                        104,
                        106,
                        108,
                        109,
                        110,
                        112,
                        113],
        u'notes': [],
        u'sources': [],
        u'superordinates': [],
        u'type': u'collection',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/62'},
    {   u'broader': [35],
        u'id': 29,
        u'labels': [   {   'label': u'eclecticisme',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'Rundbogenstil',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Het eclecticisme is een bouwstijl waarbij de architect als het ware gaat kiezen uit de catalogus van de gehele architectuurgeschiedenis om elementen ervan te combineren tot een nieuw geheel. De kunst bestond erin de diverse vormen, technieken, constructieprincipes, architectuurregels, verhoudingen, symbolen en sferen te laten samensmelten alsof ze altijd op die manier hadden bestaan.(tweede helft 19de eeuw tot WOI)',
                          'type': 'scopeNote'},
                      {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'In de Databank Bouwkundig Erfgoed wordt ook de Rundbogenstil opgenomen bij eclecticisme.',
                          'type': 'note'}],
        u'related': [],
        u'sources': [   {   'citation': u'VIOE, op basis van Jos Vandenbreeden, Eclecticisme, in: Jos Vandenbreeden, Fran\xe7oise Dierkens-Aubry, De 19de eeuw in Belgi\xeb. Architectuur en Interieurs, Tielt, Lannoo, 1994, p. 87.',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/29'},
    {   u'broader': [],
        u'id': 11,
        u'labels': [   {   'label': u'empire',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [60],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De empirestijl is in hoofdzaak een decoratieve stijl (meubels en interieur), waarvan de architectuur motieven heeft overgenomen. Hij werd voor de Franse keizer Napoleon ontwikkeld door de architecten Charles Percier en Fran\xe7ois Fontaine. Deze bouwstijl heeft als basis de neoclassicistische bouwstijl, en combineert deze met napoleontische motieven (zwaan, fasces,...) en motieven die verwijzen naar de Griekse en Egyptische oudheid zoals sfinxen, meanderfriezen, mercuriushoofden of palmetten. Kenmerkend voor de empire-gevels zijn het palladiaans venster, en de rijen gekoppelde rondboogvensters met muurdammen uitgewerkt als pilasters met lijstkapiteel. (ca. 1795 - ca. 1840)',
                          'type': 'scopeNote'}],
        u'related': [33, 36],
        u'sources': [{   'citation': u'VIOE', 'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/11'},
    {   u'broader': [],
        u'id': 68,
        u'labels': [   {   'label': u'enkelgrafcultuur',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'standvoetbekercultuur',
                           'language': u'nl-BE',
                           'type': 'altLabel'},
                       {   'label': u'touwbekercultuur',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [62],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Deze cultuur komt op in Noord-Nederland, Scandinavi\xeb, Duitsland, Polen, Oost-Frankrijk en Zwitserland rond 3000 v.Chr. De enkelgrafcultuur verschijnt dan. Het betreft een vooral Noord-Europese cultuur, gekenmerkt o.a. door aardewerk dat versierd is met touwindrukken (vandaar de alternatieve benaming Touwbekercultuur) en een totaal nieuw grafritueel, nl. individuele in plaats van collectieve begraving. Men vindt ze veel in graven van mannen, meestal samen met een strijdhamer. Deze gepolijste hardstenen bijlen hebben en centrale doorboring en veelal een dubbele snede. Het graf ligt ook hier onder een grafheuvel. De nadruk ligt hier op het individu, vooral de man.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) cursusmateriaal UGent (Prof. Ph. Cromb\xe9 &amp; Prof. J. Bourgeois) \n2) VIOE',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/68'},
    {   u'broader': [23],
        u'id': 24,
        u'labels': [   {   'label': u'expo-stijl',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De expo-stijl ontleent zijn naam aan de Wereldtentoonstelling in Brussel in 1958 en straalt het optimisme en geloof in de toekomst uit dat zo kenmerkend was voor de Expo. Dankzij het gebruik van de hyperbolische parabolo\xefde, de betonnen schaaldakconstructie, een voorkeur voor zwevende, hangende en lichte constructies en contrasten in kleur- en materiaalkeuze, zette men zich af tegen de architectuurtraditie. Er werd resoluut gebruik gemaakt van moderne materialen, zoals beton, metaal en grote glasvlakken, waarbij de dragende structuur werd benadrukt. De typische decoraties, zoals diagonalen, boemerang, V-vorm, spits toelopende vormen, enz. werden gebruikt in zowel het architecturale ontwerp als bij de uitwerking van de decoratieve details.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u"VIOE, op basis van PASAMONIK D. 1983: Expo '58 en de atoomstijl, Kortrijk, en HESS A. 2004: Googie Redux. Ultramodern roadside architecture, San Francisco.",
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/24'},
    {   u'broader': [],
        u'id': 69,
        u'labels': [   {   'label': u'federmesser',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'aziliaan',
                           'language': u'nl-BE',
                           'type': 'altLabel'},
                       {   'label': u'Azilien',
                           'language': u'nl-BE',
                           'type': 'altLabel'},
                       {   'label': u'tjonger',
                           'language': u'nl-BE',
                           'type': 'altLabel'},
                       {   'label': u'tjongeriaan',
                           'language': u'nl-BE',
                           'type': 'altLabel'},
                       {   'label': u'tjongercultuur',
                           'language': u'nl-BE',
                           'type': 'altLabel'},
                       {   'label': u'tjongertraditie',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [62],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De federmessercultuur sluit technologisch en typologisch zeer nauw aan bij het magdaleniaan en het hamburgiaan. De debitagetechniek is echter minder verzorgd. In de pijlbewapening komt een nieuw spitstype op, nl. de Federmesser- of Tjongerspits. De cultuur kan gerelateerd worden aan het finaalpaleolithicum.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) cursusmateriaal UGent (Prof. Ph. Cromb\xe9) \n2) VIOE',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/69'},
    {   u'broader': [],
        u'id': 4,
        u'labels': [   {   'label': u'gotiek',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [60],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De gotiek is ontstaan dankzij een technisch-constructieve vooruitgang als gevolg van een herverdeling van de krachten via een skeletbouw en schoorwerk. Deze stijl wordt gekenmerkt door haar verticaliteit, grote vensteropeningen, spitsbogen en kruisribgewelven. (ca. 13de eeuw - begin 16de eeuw)',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'HASLINGHUIS, E.J. en JANSE, H., Verklarend woordenboek van de westerse architectuur- en bouwhistorie: bouwkundige termen, Leiden, 2005.',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/4'},
    {   u'broader': [],
        u'id': 82,
        u'labels': [   {   'label': u'gravettiaan',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'Gravettien',
                           'language': u'nl-BE',
                           'type': 'altLabel'},
                       {   'label': u'p\xe9rigordiaan',
                           'language': u'nl-BE',
                           'type': 'altLabel'},
                       {   'label': u'P\xe9rigordien',
                           'language': u'nl-BE',
                           'type': 'altLabel'},
                       {   'label': u'perigordiaan',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [62],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u"De oudste vindplaatsen van het gravettiaan vinden we in Centraal-Europa. Vermoedelijk verspreidde de cultuur zich van daaruit over de rest van Europa, inclusief Noordwest-Europa. De gidsfossiel is de zgn. Gravettespits en de Font-Robertspits. Onder de organische werktuigen vermelden we de 'b\xe2tons de commondements' die waarschijnlijk gebruikt werden voor het vervaardigen van assegaaien. Deze cultuur kan gedateerd worden van 29000 tot 22000 BP. Perigordiaan is een verouderde term voor deze cultuur.",
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) cursusmateriaal UGent (Prof. Ph. Cromb\xe9) \n2) VIOE',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/82'},
    {   u'broader': [],
        u'id': 87,
        u'labels': [   {   'label': u'groupe de Blicquy',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [62],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Regionale variant van Villeneuve/Saint-Germain (Noord-Frankrijk) in Belgi\xeb. Nederzettingen van de Blicquy-groep worden op dezelfde plaatsen teruggevonden als LBK-nederzettingen, nl. aan de bovenloop van de Dender in Henegouwen en in het LBK-gebied in Haspengouw. Wordt gekenmerkt door typisch Blicquy-aardewerk. Deze groep overlapt mogelijk deels met het laatste deel van de LBK en loopt hierna verder.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Lanting J.N. &amp; Van der Plicht J. 2002, De C14-chronologie van de Nederlandse pre- en protohistorie. III: Neolithicum, in: Palaeohistoria: Acta et communicationes Instituti Bioarchaeologici Universitatis Groniganae 41/42, pp. 1-111.',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/87'},
    {   u'broader': [],
        u'id': 114,
        u'labels': [   {   'label': u'Halstatt',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [63],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Verwijst naar een periode en cultuur in de late bronstijd en de vroege ijzertijd, van circa 1100 tot circa 450 v. Chr. aangetroffen in Centraal- en West-Europa, en genoemd naar een begraafplaats en een zoutmijn in Halstatt (Oostenrijk). Begrafenispraktijken en artistieke stijlen verschilden per tijd en per plaats, maar over het algemeen wordt de cultuur gekenmerkt door de opkomst van handel met omliggende gebieden, door kunstvoorwerpen met symmetrische ontwerpen, geometrische versieringen, vogel- en plantenmotieven, en door de invloed van Italiaanse en mogelijk Griekse kunst.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a> \n2) VIOE',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/114'},
    {   u'broader': [],
        u'id': 88,
        u'labels': [   {   'label': u'hamburgiaan',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'Hamburgien',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [62],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Deze cultuur zou ontstaan zijn uit het magdaleniaan. Het is een uitgesproken Noord-Europese traditie (noordelijk deel van Nederland, Duitsland, Polen en zuidelijk Scandinavi\xeb). Gidsfossielen zijn de Hamburg- en Haveltespits. Deze traditie kan gedateerd worden van 12500 tot 12000 BP en is gelijktijdig met het Creswelliaan.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) cursusmateriaal UGent (Prof. Ph. Cromb\xe9) \n2) Louwe Kooijmans L., van den Broecke P.W., Fokkens H. en van Gijn A. (eds.), 2005, Nederland in de prehistorie, Amsterdam.',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/88'},
    {   u'broader': [],
        u'id': 89,
        u'labels': [   {   'label': u'hazendonkgroep',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [62],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Deze groep kan gedateerd worden van 3900 tot 3400 v.Chr. en komt voor in Zuid-Nederland en Belgi\xeb. Het kenmerkt zich door een geheel eigen aardewerkrepertoire.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Deeben J. e.a. (red.) 2005, De Steentijd van Nederland, Zutphen.',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/89'},
    {   u'broader': [],
        u'id': 27,
        u'labels': [   {   'label': u'high tech',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [60],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De high tech architectuur bouwt verder op het modernistische idee dat een gebouw de veruitwendiging is van een bouwprogramma. In de high tech architectuur worden de constructie (vaak een stalen skeletstructuur) en de technische installaties heel expliciet getoond, en wordt het gebouw bijna een ode aan de technologie en de ingenieurskunst. Een bekend voorbeeld van deze bouwstijl is het Centre Pompidou te Parijs, van Richard Rogers en Renzo Piano uit 1976. (jaren 1980)',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'VIOE, op basis van TRACHTENBERG M. &amp; HYMAN I. 2002: Architecture from Prehistory to Postmodernity, New Jersey.',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/27'},
    {   u'broader': [],
        u'id': 115,
        u'labels': [   {   'label': u'Hilversum-cultuur',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [63],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'In onze gewesten, waar geen ertsen aanwezig zijn, treft men minder rijke culturen aan, zoals de Hilversum-cultuur. Deze kan geplaatst worden in de vroege en midden-bronstijd. Kenmerkend voor deze cultuur is het grofgemagerd Hilversumaardewerk, de grote ringwalheuvels en de heuvels met paalkrans. Het gaat om een lokaal ontwikkelde archeologische cultuur met een open begrenzing met zijn kerngebied in Zuid-Nederland en Vlaanderen. De grote ringwalheuvels kennen een wijde verspreiding (Zuid-Nederland, Belgi\xeb, Noord-Frankrijk en Zuid-Engeland). Heuvels met paalkrans kennen een beperktere verspreiding (zuidoost-Brabant en de Belgische Kempen). De minder rijke graven in het Atlantisch complex zijn meestal relatief klein (enkele eenheden, tot maximaal een 10 of 20-tal graven), die veelal slechts gedurende een korte periode zijn gebruikt. Men schat de \u2018levensduur\u2019 van een dergelijk grafveld op \xe9\xe9n generatie. In grote ge\xefsloeerde grafheuvels komen ook secundaire bijzettingen voor. De nederzettingen van de Hilversumcultuur zijn steeds open nederzettingen, d.i. zonder versterkingen, waar een tot vier huizen samen voorkomen, naast enkele bijgebouwen. Het huisplattegrond in de (late) Hilversumcultuur is typerend: het betreft een langwerpig gebouw (tot 25m lengte) met meestal absidiaal afgeronde korte zijden; het huis is drieschepig en vertoont duidelijke onderverdelingen, waarin verschillende functies (schuur, stal en woongedeelte) kunnen worden onderscheiden. Men noemt ze ook woonstalhuizen. Het Hilversumaardewerk evolueert van een biconische naar een emmervormige vorm, zowel versierd (op kraag/rand met touw/nagelindrukken) als onversierd. Men kan de Hilversumcultuur dateren tussen 1775 en 1575 v.Chr.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) Theunissen E.M. 1999, Midden-Bronstijdsamenlevingen in het Zuiden van de Lage Landen: een evaluatie van het begrip Hilversum-cultuur, Proefschrift ter verkrijgen van de graad van Doctor, Universiteit Leiden. \n2) cursusmateriaal UGent (Prof. J. Bourgeois) \n3) VIOE',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/115'},
    {   u'broader': [],
        u'id': 123,
        u'labels': [   {   'label': u'integratiearchitectuur',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [60],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Integratiearchitectuur omvat een veelal kleinschalige nieuwbouw of verbouwing die zich qua volumes, structuur en vaak ook qua materiaal inschrijft in de omgeving, maar die eigentijds is van vormgeving (circa 1975-1990).',
                          'type': 'scopeNote'},
                      {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'19/07/2016: toegevoegd voor project sociale huisvesting.',
                          'type': 'historyNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'CONSTANDT L. 1988: Stenen herleven. 111 jaar kunstige herstellingen in Brugge, Brugge, 94.',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/123'},
    {   u'broader': [],
        u'id': 91,
        u'labels': [   {   'label': u'klokbekercultuur',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'KB',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [62],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Deze cultuur heeft zijn naam te danken aan het typische aardewerk dat op de kop geplaatst lijkt op een klepelklok. De klokbekercultuur heeft zich verspreid over grote delen van Europa en kan chronologisch gesitueerd worden tussen 2400 en 1900 v.Chr. De cultuur is waarschijnlijk oorspronkelijk afkomstig uit Spanje en heeft zich verspreid over Centraal- en West-Europa, daarbij de techniek van het werken met brons naar de Britse eilanden brengend. De cultuur wordt gekenmerkt door aardewerk, een voorkeur voor individuele graven, snelle expansie op zoek naar koper en goud, het ontstaan van talrijke wapens, waaronder bogen, koperen speerpunten, platte, getande dolken en opvallende gebogen, rechthoekige polsbeschermers. De klokbekercultuur moet dus eerder beschouwd worden als een typische vorm van uiting van elitevorming.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) Deeben J. e.a. (red.) 2005, De Steentijd van Nederland, Zutphen.  2) Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/91'},
    {   u'broader': [],
        u'id': 116,
        u'labels': [   {   'label': u'La T\xe8ne',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [63],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Verwijst naar een fase en cultuur van de Europese Kelten in de late ijzertijd, genoemd naar de archeologische vindplaats La T\xe8ne, of De Ondiepe Wateren, bij het Meer van Neuch\xe2tel in Zwitserland. De fase begon in het midden van de 5de eeuw v. Chr. en de cultuur verspreidde zich over Noord-Europa en de Britse Eilanden, om ten slotte halverwege de 1ste eeuw v. Chr. te verdwijnen. La T\xe8ne kenmerkt zich door Griekse en Etruskische invloeden op de traditionele Keltische cultuur en door de sterke geografische verspreiding van de Kelten.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a> \n2) VIOE',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/116'},
    {   u'broader': [12],
        u'id': 56,
        u'labels': [   {   'label': u'Louis-Philippestijl',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De Louis-Philippestijl is een variant op het neoclassicisme, ontwikkeld in Frankrijk onder burgerkoning Louis-Philippe, en hier toegepast tijdens de jaren 1850. Typisch zijn de gevelopstanden met een plastische vormgeving en een uitbundig stucdecor, ge\xefnspireerd op de vloeiende lijnvoering van het rococo. Vaak voorkomende decoratieve elementen  zijn balkons met geajoureerde borstwering en rijk versierde voluutconsoles, en sluitstenen met een decor van maskerkoppen en/of rankwerk.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'agentschap Onroerend Erfgoed',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/56'},
    {   u'broader': [],
        u'id': 95,
        u'labels': [   {   'label': u'magdaleniaan',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'Magdalenien',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [62],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Genoemd naar de Franse vindplaats La Madeleine nabij Tursac in Dordogne. Deze cultuur ontwikkelt zich in Zuidwest-Europa en zal zich geleidelijk ook verspreiden over Centraal- en West-Europa en kan gedateerd worden tussen 17000 en 14000 BP (jongpaleolithicum). De cultuur kenmerkt zich door het ontstaan van permanente of seizoensnederzettingen, het gebruik van een grote verscheidenheid aan planten en dieren, onder andere door het gebruik van strikken en vallen, en de ingenieuze vervaardiging van werktuigen, decoratieve vormen en kunstvoorwerpen. Gereedschappen werden gemaakt van bot en steen en hebben geometrisch gevormde snijbladen. Er zijn ook andere werktuigen van bot en geweien, graveerijzers, naalden, schrapers, boren, snijbladen met achterkanten, harpoenen en bladvormige punten voor projectielen. De artistieke productie bestond uit monumentale inscripties en schilderingen in grotten, bewerken van benen werktuigen, beeldhouwwerk en juwelen.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) cursusmateriaal UGent (Prof. Ph. Cromb\xe9) \n2) Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a> \n3) VIOE',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/95'},
    {   u'broader': [],
        u'id': 97,
        u'labels': [   {   'label': u'michelsbergcultuur',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [62],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'In de 2de fase van het middenneolithicum verschijnt in de regio van West- en Zuid-Duitsland, Belgi\xeb en Noord-Nederland de michelsbergcultuur die men kan dateren tussen 4400 en 3500 v.Chr. De cultuur komt voor in nagenoeg heel Vlaanderen, in tegenstelling tot de Bandkeramiek waarvan de verspreiding zich beperkte tot de leemstreek. Zeer typisch voor de Michelsbergcultuur zijn aardwerken of enclosures, grote structuren bestaande uit \xe9\xe9n of meerdere grote grachten en wallen die bijna steeds een hoge plek in het landschap afsluiten. Typische lithische werktuigen zijn grote, massieve eindschrabbers op afslag (hoefschrabbers) en afslagbijlen. Naast hardstenen bijlen worden nu ook gepolijste bijlen uit vuursteen vervaardigd. Het aardewerk is handgevormd en doorgaans gemagerd met grit en plantaardig materiaal. De meeste potten zijn onversierd.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Agentschap Onroerend Erfgoed',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/97'},
    {   u'broader': [],
        u'id': 98,
        u'labels': [   {   'label': u'micoquiaan',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'Micoquien',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [62],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Het micoquiaan kenmerkt zich door asymmetrische vuistbijlvormen en het gebruik van de Levalloistechniek. Het kan deels gelijktijdig met het mousteriaan geplaatst worden (middenpaleolithicum).',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) Cromb\xe9 P. &amp; Van Der Haeghen G. 1994, Twee midden-paleolithische vindplaatsen te Aalter (O.-Vl.), in: P. Cromb\xe9 &amp; G. Van Der Haeghen (eds.), Het midden-paleolithicum in Noordwestelijk Belgi\xeb, pp. 49-95. 2) Onderzoeksbalans Onroerend Erfgoed Vlaanderen <a href="http://www.onderzoeksbalans.be/.">http://www.onderzoeksbalans.be/.</a>',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/98'},
    {   u'broader': [],
        u'id': 23,
        u'labels': [   {   'label': u'modernisme',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'Nieuwe Zakelijkheid',
                           'language': u'nl-BE',
                           'type': 'altLabel'},
                       {   'label': u'Internationale Stijl',
                           'language': u'nl-BE',
                           'type': 'altLabel'},
                       {   'label': u'functionalisme',
                           'language': u'nl-BE',
                           'type': 'altLabel'},
                       {   'label': u'pakketbootstijl',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [60],
        u'narrower': [24],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Modernisme wordt in deze databank gehanteerd voor alle architectuur die getuigt van een streven naar vernieuwing door een versobering van\n de vormentaal. De meest pure vorm van modernisme, vaak benoemd als de internationale stijl of functionalisme, wordt gekenmerkt door een rationeel grondplan, eenvoudige geometrische vormen, dragende (beton)skeletten met platte daken, lichte scheidingswanden en het gebruik van moderne materialen.\n De meeste gebouwen bereiken echter niet het pure van de internationale stijl, maar getuigen niettemin van een streven naar verzakelijking. Zij zijn doorgaans uitgewerkt met egale bakstenen parementen, met een bescheiden volumewerking en een sterk gereduceerde decoratie. (jaren 1920 tot jaren 1960)',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'VIOE, op basis van HASLINGHUIS E.J. &amp; JANSE H. 2005: Verklarend woordenboek van de westerse architectuur- en bouwhistorie: bouwkundige termen, Leiden.',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/23'},
    {   u'broader': [],
        u'id': 100,
        u'labels': [   {   'label': u'mousteriaan',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'Mousterien',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [62],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Verwijst naar de periode en cultuur waarin specifieke gereedschappen tot ontwikkeling komen in Europa, het Midden-Oosten en Afrika, vanaf 250.000 jaar geleden. De periode is genoemd naar de schuilgrotten bij Le Moustier in het zuidwesten van Frankrijk. De cultuur wordt traditioneel in verband gebracht met Neanderthalers in Europa en hun tijdgenoten in Afrika. Het kenmerkt zich door de expansie van volkeren naar nieuwe gebieden en aanpassingen aan nieuwe omgevingen, zoals diversificatie en specialisatie van stenen werktuigen, vakkundig en selectief jagen en doelbewust begraven en door het voorkomen van de Levalloistechniek bij steenbewerking. Kleine vuistbijlen en unifaciaal bewerkte spitsen zijn kenmerkende objecten voor deze cultuur.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a> \n2) Deeben J. e.a. (red.) 2005, De Steentijd van Nederland, Zutphen.',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/100'},
    {   u'broader': [],
        u'id': 117,
        u'labels': [   {   'label': u'Nederrijnse grafheuvelcultuur',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'Niederrheinische grabh\xfcgelkultur',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [63],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u"De Nederrijnse grafheuvelcultuur wordt gekenmerkt door de introductie van een nieuw begrafenisritueel (urnenvelden, crematies, nieuwe graftypes (long barrows)), een nieuw aardewerkrepertoire, de intensificatie van de bronscirculatie door participatie in Atlantische en Centraal-Europese uitwisselingsnetwerken en een geavanceerder landbouwsysteem (celtic fields). De Nederrijnse bevolking vertoont in materi\xeble cultuur in deze periode een hoge graad van autonomie ten opzichte van de Centraal-Europese urnenveldencultuur waarmee het chronologisch gelijktijdig verloopt. Dit idee van een losstaande culturele identiteit wordt uitgedrukt met de term 'Nederrijnse grafheuvelcultuur'. Het is een meer westelijke variant van de Urnenveldencultuur.",
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) Roymans N. &amp; Kortlang F. 1999, Urnfield symbolism, ancestors and the land in the Lower Rhine Region, in: F. Theuws &amp; N. Roymans (eds.), Land and ancestors: cultural dynamics in the Urnfield Period and the Middle Ages in the Southern Netherlands, Amsterdam Archaeological Studies 4, pp. 33-63. \n2) VIOE',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/117'},
    {   u'broader': [35],
        u'id': 16,
        u'labels': [   {   'label': u'neobarok',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'neo-Lodewijk-XIV-stijl',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De neobarok inspireert zich op de barokke architectuur.(ca. 1840 tot het interbellum)',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [{   'citation': u'VIOE', 'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/16'},
    {   u'broader': [35],
        u'id': 18,
        u'labels': [   {   'label': u'neobyzantijns',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De neobyzantijnse bouwstijl inspireert zich op de architectuur van het Byzantijnse rijk, met onder meer de centraalbouw, het koepeldak, een veelvuldig gebruik van rondbogen en bepaalde decoratieve elementen zoals moza\xefeken met vergulde achtergronden. (19de eeuw en eerste kwart 20ste eeuw)',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [{   'citation': u'www.irismonument.be', 'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/18'},
    {   u'broader': [35],
        u'id': 12,
        u'labels': [   {   'label': u'neoclassicisme',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'neo-Lodewijk XVI-stijl',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [36, 56],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Het neoclassicisme inspireert zich op de classicistische architectuur met ornamenten zoals ovale medaillons, laurierguirlandes, voluutconsoles, enz. Deze stroming heeft net zoals het classicisme een voorliefde voor orde en symmetrie, maar gaat vrijer om met de classicistische ornamentiek. De gevels zijn vaak, maar niet altijd, bepleisterd.(tweede helft 19de eeuw en eerste kwart 20ste eeuw)',
                          'type': 'scopeNote'},
                      {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De Louis-Philippestijl is in de Databank Bouwkundig Erfgoed opgenomen onder neoclassicisme.',
                          'type': 'note'}],
        u'related': [8, 10, 32],
        u'sources': [{   'citation': u'www.irismonument.be', 'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/12'},
    {   u'broader': [35],
        u'id': 34,
        u'labels': [   {   'label': u'neo-Egyptisch',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De neo-Egyptische bouwstijl inspireert zich op de architectuur uit de Egyptische oudheid met onder meer bundelzuilen met papyrus- en palmenkapitelen, de holgebogen kroonlijst en de voor deze antieke cultuur typerende versieringen. (19de eeuw en eerste kwart 20ste eeuw)',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [{   'citation': u'www.irismonument.be', 'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/34'},
    {   u'broader': [35],
        u'id': 33,
        u'labels': [   {   'label': u'neo-empire',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De neo-empire inspireert zich op de empire-architectuur. (tweede helft 19de eeuw en eerste kwart 20ste eeuw)',
                          'type': 'scopeNote'}],
        u'related': [11, 36],
        u'sources': [{   'citation': u'VIOE', 'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/33'},
    {   u'broader': [35],
        u'id': 13,
        u'labels': [   {   'label': u'neogotiek',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'neotudorstijl',
                           'language': u'nl-BE',
                           'type': 'altLabel'},
                       {   'label': u'troubadourstijl',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De neogotiek inspireert zich op de gotische architectuur met o.m. spitsbogen, verticalisme, puntgevels, erkers, enz.(ca.1820 tot WOII)',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [{   'citation': u'VIOE', 'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/13'},
    {   u'broader': [35],
        u'id': 17,
        u'labels': [   {   'label': u'neomoors',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De neomoorse bouwstijl inspireert zich op de Maghrebijnse, Arabische, Osmaanse en Moorse architectuur. Kenmerkend voor deze stijl zijn onder meer minaretten, koepels, hoefijzerbogen en polychromie in de onderbouw. (19de eeuw en eerste kwart 20ste eeuw)',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'VIOE, op basis van Jos Vandenbreeden, Fran\xe7oise Dierkens-Aubry, De 19de eeuw in Belgi\xeb. Architectuur en Interieurs, Tielt, Lannoo, 1994, p.165.',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/17'},
    {   u'broader': [35],
        u'id': 122,
        u'labels': [   {   'label': u'neorenaissance',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [u'http://vocab.getty.edu/aat/300021464'],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De neorenaissancestijl is een architectuurstijl (circa 1860-1914) die zich inspireert op de renaissance, een kunststroming ontstaan in het Itali\xeb van de 15de eeuw en die er onder meer op gericht was de bouwkunst van de Grieks-Romeinse oudheid te doen herleven. Stijlkenmerken zijn een symmetrische opbouw van de gevel, frontonbekroningen, zuilen en pilasters enzoverder. In Vlaanderen is vooral de neo-Vlaamserenaissance-stijl populair.',
                          'type': 'scopeNote'},
                      {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'26/02/2015: term toegevoegd; SN wordt aangeleverd tegen de zomer.\n06/05/2015: SN aangeleverd door Elise en toegevoegd.',
                          'type': 'historyNote'}],
        u'related': [14],
        u'sources': [{   'citation': u'www.irismonument.be', 'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/122'},
    {   u'broader': [35],
        u'id': 19,
        u'labels': [   {   'label': u'neorococo',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'neo-Lodewijk-XV-stijl',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Het neorococo inspireert zich op het rococo.(ca. 1860 tot WOII)',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [{   'citation': u'VIOE', 'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/19'},
    {   u'broader': [35],
        u'id': 15,
        u'labels': [   {   'label': u'neoromaans',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De neoromaanse bouwstijl inspireert zich op de romaanse architectuur de rondbogen als centraal motief. (19de eeuw tot ca. WO II)',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [{   'citation': u'VIOE', 'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/15'},
    {   u'broader': [],
        u'id': 35,
        u'labels': [   {   'label': u'neostijl',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [60],
        u'narrower': [12, 13, 14, 15, 16, 17, 18, 19, 29, 32, 33, 34, 122],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Neostijl is een verzamelnaam voor stijlen vanaf de 19de eeuw die kenmerken van een vroegere stijl opnieuw gebruiken. (19de eeuw en eerste helft 20ste eeuw)',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'HASLINGHUIS, E.J. en JANSE, H., Verklarend woordenboek van de westerse architectuur- en bouwhistorie: bouwkundige termen, Leiden, 2005.',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/35'},
    {   u'broader': [],
        u'id': 21,
        u'labels': [   {   'label': u'neotraditioneel',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [60],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De neotraditionele bouwstijl inspireert zich op de traditionele architectuur, die men eerder vrij gaat incorporeren in een meer eigentijdse vormgeving, met eigentijdse materialen en technieken. (19de eeuw en 20ste eeuw)',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [{   'citation': u'VIOE', 'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/21'},
    {   u'broader': [35],
        u'id': 14,
        u'labels': [   {   'label': u'neo-Vlaamserenaissance-stijl',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De neo-Vlaamse-renaissance inspireert zich op de renaissance-architectuur en verwerkt elementen gaande van de Vredeman-de-Vriesstijl tot de barok: trapgevels, kruisvensters, torentjes, erkers, voluten, obelisken, etc. Typisch is het polychroom materiaalgebruik en de toepassing van "speklagen" (=afwisseling baksteen en natuursteen). (circa 1870 tot Eerste Wereldoorlog)',
                          'type': 'scopeNote'}],
        u'related': [122],
        u'sources': [{   'citation': u'VIOE', 'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/14'},
    {   u'broader': [],
        u'id': 25,
        u'labels': [   {   'label': u'organische architectuur',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [60],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Bij de organische architectuur bepaalt de functie de vorm. Men gaat ervan uit dat de architectuur een invloed uitoefent op de gebruiker. Met schuine plafonds, ronde hoeken en een beweeglijke vormgeving wil men een aangename omgeving cre\xebren voor de gebruiker.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [{   'citation': u'WIKI', 'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/25'},
    {   u'broader': [],
        u'id': 119,
        u'labels': [   {   'label': u'Plainseaucultuur',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [63],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Deze omschrijving verwijst meer naar de bloeiende bronsindustrie in de streek van Amiens en Picardi\xeb dan naar een echte cultuur, vermits er geen woningen of necropolen mee in verband kunnen worden gebracht. Voorwerpen van het Plainseau-type werden ge\xebxporteerd tot in Zuid-Engeland, Nederland en Belgi\xeb. Naast enkele ge\xefsoleerde vondsten in de Maas- en de Scheldevallei, werden kleinere depots opgegraven in onder meer Hoogstraten, Antwerpen, Lanaken en Eprave.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) De Plainseau-cultuur <a href="http://www.patrimoine-mobilier.be/patrimoine/additional_info.aspx?id=214684&amp;LangType=2067">http://www.patrimoine-mobilier.be/patrimoine/additional_info.aspx?id=214684&amp;LangType=2067</a> \n2) VIOE',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/119'},
    {   u'broader': [],
        u'id': 26,
        u'labels': [   {   'label': u'postmodernisme',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [60],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Het postmodernisme zet zich af tegen het functionalisme en de soberheid van het modernisme. Het ornament wordt opnieuw in eer hersteld en moet het gebouw betekenis verlenen. Vormelementen uit het verleden (classicisme, art deco, enz) worden op eigentijdse wijze en vaak met een ondertoon van humor als citaten toegepast. (jaren 1970 en 1980)',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'VIOE, o.m. op basis van www.irismonument.be en TRACHTENBERG M. &amp; HYMAN I. 2002: Architecture from Prehistory to Postmodernity, New Jersey.',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/26'},
    {   u'broader': [],
        u'id': 20,
        u'labels': [   {   'label': u'regionalisme',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [60],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Het regionalisme inspireert zich op de regionale bouwstijl, met zijn lokale, regiogebonden materialen, technieken en vormkenmerken. Vanuit deze elementen cre\xebert men een nieuwe architectuur. Het regionalisme was de dominerende stijl tijdens de wederopbouw na WO I. (laatste kwart 19de eeuw en eerste helft 20ste eeuw)',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [{   'citation': u'VIOE', 'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/20'},
    {   u'broader': [],
        u'id': 5,
        u'labels': [   {   'label': u'renaissance',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [60],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De renaissancebouwstijl poogde de vormentaal van de antieke oudheid opnieuw toe te passen. Vaak paste men elementen uit de Italiaanse renaissance toe op de traditionele bak- en zandsteenstijl. De typische renaissancegevel heeft een in- en uitgezwenkte top, bekroond met een (buiten proportie) klein fronton. Lijsten delen de geveltop horizontaal op. Centraal in de geveltop is meestal een oculus aangebracht. Als materiaal wordt baksteen gebruikt, in combinatie met witte natuursteen (Balegemse) voor de constructieve details en de ornamentiek. In de renaissance zijn de kruisvensters courant, bovenaan ingevuld met vast glas-in-lood, onderaan afgesloten door openslaande raamvleugels met luikjes. Veel voorkomende ornamenten in de renaissance zijn de versierde gevelankers, zuilen en pilasters volgens de klassieke orde, frontons, eierlijsten, obelisken, saters en mascarons. (grosso modo de 16de eeuw)',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [{   'citation': u'VIOE', 'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/5'},
    {   u'broader': [],
        u'id': 120,
        u'labels': [   {   'label': u'Rhin-Suisse-France Oriental',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [63],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De Rhin-Suisse-France ori\xebntale cultuur wordt gekenmerkt door typische urnenvelden, een bloeiende metaalproductie en o. a. nederzettingen aan oevers van meren en rivieren (paaldorpen). Meer oostelijke variant van de Urnenveldencultuur.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) cursusmateriaal UGent (Prof. J. Bourgeois) \n2) VIOE',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/120'},
    {   u'broader': [],
        u'id': 102,
        u'labels': [   {   'label': u'Rijnbekkengroep',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'Rheinbasin-kreis',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [62],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Vanaf het vroegmesolithicum treedt een regionalisatie op in de materi\xeble cultuur. Men kan in Zuid-Nederland, Belgi\xeb en een deel van Frankrijk de Rijnbekkengroep (Rheinbassin-kreis) onderscheiden. In Noord-Nederland krijgt men dan de Noordwest-groep (Nordwest-kreis). Een toename van het gebruik van het aantal spitstypen en een toename van het gebruik van Wommersomkwartsiet plus de toepassing van oppervlakte-retouches zijn kenmerkend voor deze periode. Sauveterre-spitsen, bladspitsen en feuilles de gui doen hun intrede.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) Lanting J.N. &amp; Van der Plicht J. 1998, De C14-chronologie van de Nederlandse pre- en protohistorie. II: Mesolithicum, in: Palaeohistoria: Acta et communicationes Instituti Bio-archaeologici Universitatis Groninganae 39/40, pp. 99-162. \n2) Louwe Kooijmans L., van den Broecke P.W., Fokkens H. en van Gijn A. (eds.), 2005, Nederland in de prehistorie, Amsterdam.',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/102'},
    {   u'broader': [],
        u'id': 9,
        u'labels': [   {   'label': u'rococo',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'r\xe9gence',
                           'language': u'nl-BE',
                           'type': 'altLabel'},
                       {   'label': u'Lodewijk-XV-stijl',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [60],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Het rococo is in hoofdzaak een decoratieve stijl (meubels en interieur), die gekenmerkt wordt door haar speelsheid, lichte kleuren en asymmetrische lijnenspel. Ze dankt haar naam aan de rocaille, het asymmetrische schelpmotief, dat veelvuldig gebruikt wordt als decoratie. (midden 18de eeuw)',
                          'type': 'scopeNote'},
                      {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'In de Databank Bouwkundig Erfgoed wordt ook r\xe9gence opgenomen bij rococo.',
                          'type': 'note'}],
        u'related': [],
        u'sources': [   {   'citation': u'HASLINGHUIS, E.J. en JANSE, H., Verklarend woordenboek van de westerse architectuur- en bouwhistorie: bouwkundige termen, Leiden, 2005; KOCH W. 1988: De Europese bouwstijlen, Amsterdam.',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/9'},
    {   u'broader': [],
        u'id': 3,
        u'labels': [   {   'label': u'romaans',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [60],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De romaanse bouwstijl wordt gekenmerkt door massieve stenen muren met kleine gevelopeningen, doorgaans met rondboog en soms gedeeld door middenzuiltjes. De overdekking gebeurde met een vlak houten gewelf, of - minder courant - met stenen ton-, kruis- en koepelgewelven. De decoratieve afwerking wordt gekarakteriseerd door rondboogfriezen, rondboognissen en lisenen. (ca. 10de eeuw tot 1200)',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'HASLINGHUIS, E.J. en JANSE, H., Verklarend woordenboek van de westerse architectuur- en bouwhistorie: bouwkundige termen, Leiden, 2005.',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/3'},
    {   u'broader': [],
        u'id': 104,
        u'labels': [   {   'label': u'r\xf6ssencultuur',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'Roessener',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [62],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Deze cultuur komt tot uiting in westelijk Duitsland en de oostelijke Benelux en kan gedateerd worden tussen 5000 en 4400/4300 v.Chr. Ze ontwikkelde zich in het Rijnland vanuit de Bandkeramische cultuur. De nederzettingen uit de r\xf6ssencultuur zijn versterkt en de gebouwen hebben een trapezo\xefdale plattegrond. In Vlaanderen zijn geen sites van deze cultuur gekend, wel is deze cultuur vertegenwoordigd door een aantal losse vondsten van Breitkeile (soort hamer/bijl).',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) cursusmateriaal UGent (Prof. Ph. Cromb\xe9) \n2) VIOE',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/104'},
    {   u'broader': [12],
        u'id': 36,
        u'labels': [   {   'label': u'second empire',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De second-empirestijl is een variant op het neoclassicisme, ontwikkeld in Frankrijk onder Napoleon III.\n Typisch zijn de zeer zware, exuberante vormen, en de mansardedaken. De gevel krijgt een sterk bewogen en plastisch karakter. De second empirestijl vertoont een voorkeur voor een uitbundige, sculpturale decoratie. (ca. 1850-1870)',
                          'type': 'scopeNote'}],
        u'related': [11, 33],
        u'sources': [{   'citation': u'VIOE', 'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/36'},
    {   u'broader': [],
        u'id': 106,
        u'labels': [   {   'label': u'Seine-Oise-Marne',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'SOM',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [62],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Deze cultuur komt voor in noordelijk Frankrijk en zuidelijk Belgi\xeb en kan gesitueerd worden in het laatneolithicum.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [{   'citation': u'VIOE', 'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/106'},
    {   u'broader': [],
        u'id': 108,
        u'labels': [   {   'label': u'steingroep',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [62],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Deze groep is onderdeel van het cultuurcomplex dat geografisch gezien tussen de trechterbekercultuur in het Noorden en de Seine-Oise-Marne-cultuur (waarmee het grote overeenkomsten kent) in het Zuiden ligt. De steingroep kan gedateerd worden tussen 3450 en 2500 v.Chr.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Deeben J. e.a. (red.) 2005, De Steentijd van Nederland, Zutphen.',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/108'},
    {   u'id': 60,
        u'labels': [   {   'label': u'stijlen',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'member_of': [],
        u'members': [   1,
                        3,
                        4,
                        5,
                        7,
                        8,
                        9,
                        10,
                        11,
                        20,
                        21,
                        22,
                        23,
                        25,
                        26,
                        27,
                        28,
                        30,
                        31,
                        35,
                        123],
        u'notes': [],
        u'sources': [],
        u'superordinates': [],
        u'type': u'collection',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/60'},
    {   u'broader': [],
        u'id': 109,
        u'labels': [   {   'label': u'swifterbantcultuur',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [62],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u"De Swifterbantcultuur ontstaat aan het begin van het neolithicum. Het Atlantisch kustgebied wordt gekenmerkd door een verschillend gradueel neolithisatieproces. Na de aankomst van LBK in de loesszone blijft de bevolking leven volgens het mesolithisch principe van jacht en visvangst. De swifterbantcultuur neemt mondjesmaat 'neolithische' elementen over en integreert ze in een eigen systeem: rond 5000 v.Chr. aardewerk met een typische vorm - vanaf dit ogenblik spreken we over de swifterbantcultuur -, gedomesticeerde dieren na 4700 v.Chr. en graan ca. 4100 v.Chr. De swifterbantcultuur is in Vlaanderen voorlopig enkel gekend in de vallei van de beneden-Schelde.",
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) Deeben J. e.a. (red.) 2005, De Steentijd van Nederland, Zutphen. \n2) cursusmateriaal UGent (Prof. Ph. Cromb\xe9) \n3) VIOE',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/109'},
    {   u'broader': [],
        u'id': 110,
        u'labels': [   {   'label': u'tardenoisiaan',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'Tardenoisien',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [62],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Deze cultuur komt voor vanaf het finaalpaleoltihicum in Noordwest-Frankrijk en Belgi\xeb. Karakteristieke artefacten zijn de trapeziumvormige pijlpunten. In de rest van Europa komen op hetzelfde moment parallelle culturen voor zoals bv. het aziliaan in Zuid-Frankrijk en Spanje.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) Onderzoeksbalans Onroerend Erfgoed Vlaanderen <a href="http://www.onderzoeksbalans.be/">http://www.onderzoeksbalans.be/</a> \n2) Louwe Kooijmans L., van den Broecke P.W., Fokkens H. en van Gijn A. (eds.), 2005, Nederland in de prehistorie, Amsterdam.',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/110'},
    {   u'broader': [],
        u'id': 1,
        u'labels': [   {   'label': u'traditioneel',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'bak- en zandsteenstijl',
                           'language': u'nl-BE',
                           'type': 'altLabel'},
                       {   'label': u'Maasstijl',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [60],
        u'narrower': [2],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De traditionele architectuur in Vlaanderen is een architectuur in baksteen of in vakwerk.\nHet bakstenen metselwerk wordt gecombineerd met natuurstenen elementen (bv. voor de plint, rond de gevelopeningen, aan de kroonlijst, ...), terwijl in het interieur houten draagconstructies voorkomen. Deze gebouwen bezitten zadeldaken, vaak met trapgevels. Ook enkel schaars bewaarde voorbeelden met houten gevels kunnen beschouwd worden als traditionele stijl.',
                          'type': 'scopeNote'},
                      {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'06/03/2015: SN aangevuld met houten gevels',
                          'type': 'historyNote'}],
        u'related': [],
        u'sources': [{   'citation': u'VIOE', 'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/1'},
    {   u'broader': [],
        u'id': 112,
        u'labels': [   {   'label': u'trechterbekercultuur',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [62],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u"In de 2de fase van het middenneolithicum verschijnt in de regio van Polen, Moravi\xeb, Bohemen, Noord- en Oost-Duitsland, Denemarken, Zweden, Belgi\xeb en Noord-Nederland de trechterbekercultuur. Deze kan gedateerd worden tussen 4350 en 2800/2700 v.Chr. en wordt gekenmerkt door trechtervormige vazen. De cultuur verschilt per regio, maar wordt over het algemeen gekenmerkt door vroege domesticatie van dieren en planten, gepolijst (vuur)stenen gereedschap, flessen met halzen, manden, potten, trechterbekers verfraaid met verticale en horizontale groeven en in sommige regio's megalithische grafmonumenten (hunnebedden). De trechterbekercultuur treft men ook aan op gronden die voor het eerst in gebruik genomen worden voor de landbouw.",
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a> \n2) Louwe Kooijmans L., van den Broecke P.W., Fokkens H. en van Gijn A. (eds.), 2005, Nederland in de prehistorie, Amsterdam. \n3) cursusmateriaal UGent (Prof. Ph. Cromb\xe9)',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/112'},
    {   u'broader': [],
        u'id': 121,
        u'labels': [   {   'label': u'urnenveldencultuur',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [63],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De urnenveldencultuur kan gedateerd worden tussen 1050 en 800 v.Chr. (late bronstijd tot vroege ijzertijd). Het hoofdkenmerk van de urnenveldencultuur is de veralgemening van de crematie bij behandeling van de dode, de depositie van de crematieresten in een urne en de plaatsing van de urne in vlakgraven in uitgestrekte grafvelden (honderden graven).',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) cursusmateriaal UGent (Prof. J. Bourgeois) \n2) VIOE',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/121'},
    {   u'broader': [1],
        u'id': 2,
        u'labels': [   {   'label': u'vakwerkbouw',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Bouw in houten stijl- en regelwerk. De open ruimtes worden gevuld met vitswerk (tenen gevlochten omheen vitslatten) waarop leem gesmeerd wordt. De vullingen kunnen ook bestaan uit baksteen.',
                          'type': 'scopeNote'},
                      {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Ook versteende vakwerkbouw is opgenomen in de Databank Bouwkundig Erfgoed.',
                          'type': 'note'}],
        u'related': [],
        u'sources': [   {   'citation': u'HASLINGHUIS, E.J. en JANSE, H., Verklarend woordenboek van de westerse architectuur- en bouwhistorie: bouwkundige termen, Leiden, 2005.',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/2'},
    {   u'broader': [],
        u'id': 113,
        u'labels': [   {   'label': u'vlaardingencultuur',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [62],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Deze cultuur komt voornamelijk voor in Nederland (langsheen kust), maar kent ook enkele sites in Belgi\xeb. Deze cultuur kent mogelijk zijn oorsprong in de hazendonkgroep en de swifterbantcultuur (technologische overeenkomsten). Ze heeft echter wel eigen aardewerkvormen en versiering ontbreekt. Deze traditie kan gedateerd worden tussen 3400 en 2500 v.Chr.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) Louwe Kooijmans L., van den Broecke P.W., Fokkens H. en van Gijn A. (eds.), 2005, Nederland in de prehistorie, Amsterdam. \n2) Deeben J. e.a. (red.) 2005, De Steentijd van Nederland, Zutphen.',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/stijlen_en_culturen/113'}]
