# m6

Some resources related to the M6-Forecasting competition. Pull requests welcome. 

### Official rules

- [Contest site](https://mofc.unic.ac.cy/the-m6-competition/)
- [Rules](https://github.com/microprediction/m6/blob/main/docs/M6-forecasting-competition-Guidelines-20210908.pdf) as of Oct 7, 2021
- [Rule clarifications](https://github.com/microprediction/m6/blob/main/docs/clarifications.md)

### Python time-series packages 
See also [PYTHON_PACKAGES.md](https://github.com/microprediction/m6/blob/main/PYTHON_PACKAGES.md)

- [Elo ratings](https://microprediction.github.io/timeseries-elo-ratings/html_leaderboards/overall.html) of autonomous time-series prediction algorithms judged against live data. 
- [Listing](https://www.microprediction.com/blog/popular-timeseries-packages) of popular Python time-series packages, including features, causality and so forth.

### Practice data 

- [Public API](https://www.microprediction.com/public-api) for time-series
- Example [csv](https://csv.microprediction.org/lagged?name=electricity-fueltype-nyiso-hydro.json)
- [Tutorial](https://www.microprediction.com/python-3) on retrieving time-series data using microprediction package. 
- [IEX](https://iexcloud.io/docs/api/) API and [example scripts](https://github.com/numerai/signals-example-scripts/blob/master/iexcloud/dividends.py) from Numerai


### Articles 

- [How to train for the M6 Financial Foreasting Competition](https://microprediction.medium.com/six-ways-to-train-for-the-m6-financial-forecasting-competition-cacaf3af58b5)
- [The future of forecasting competitions, according to the experts](https://www.microprediction.com/blog/future)

See [ARTICLES.md](https://github.com/microprediction/m6/blob/main/ARTICLES.md) for more. 

### Practice contests

- [Daily contest](https://www.microprediction.com/competitions/daily) for short-term distributional prediction of crypto-currencies
- [Electricity prediction contest](https://www.microprediction.com/competitions/electricity)
