"""init_db

Revision ID: 36de70108aeb
Revises: 
Create Date: 2023-05-16 14:06:39.799551

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "36de70108aeb"
down_revision = None
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "nonebot_plugin_session_sessionmodel",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("bot_id", sa.String(length=64), nullable=False),
        sa.Column("bot_type", sa.String(length=32), nullable=False),
        sa.Column("platform", sa.String(length=32), nullable=False),
        sa.Column(
            "level",
            sa.Enum("LEVEL0", "LEVEL1", "LEVEL2", "LEVEL3", name="sessionlevel"),
            nullable=False,
        ),
        sa.Column("id1", sa.String(length=64), nullable=True),
        sa.Column("id2", sa.String(length=64), nullable=True),
        sa.Column("id3", sa.String(length=64), nullable=True),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint(
            "bot_id",
            "bot_type",
            "platform",
            "level",
            "id1",
            "id2",
            "id3",
            name="unique_session",
        ),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("nonebot_plugin_session_sessionmodel")
    # ### end Alembic commands ###
