<p align="center">
<img alt="Logo" src="static/header_git.png"/ width="1000">
</p>

<p align="center">Open Source Data Observability for Analytics Engineers</p>

<p align="center">
<a href="https://join.slack.com/t/elementary-community/shared_invite/zt-uehfrq2f-zXeVTtXrjYRbdE_V6xq4Rg"><img src="https://img.shields.io/badge/join-Slack-ff69b4"/></a>
<a href="https://docs.elementary-data.com/quickstart"><img src="https://img.shields.io/badge/docs-quickstart-orange"/></a>
<img alt="License" src="https://img.shields.io/badge/license-Apache--2.0-ff69b4"/>
<img alt="Downloads" src="https://static.pepy.tech/personalized-badge/elementary-lineage?period=total&units=international_system&left_color=grey&right_color=orange"&left_text=Downloads"/>

**Monitor your dbt tests results** and add **Elementary anomaly detection tests** to your dbt project. 

See the test results on top of your dbt models in a report, with info for **fast triage**: test status, sample of failed rows, test queries, test configuration and anomaly detection metrics and graph.

Share the report with your team, and use Slack integration for alerting on incidents. 


##

:star: Support us with a <a href="https://github.com/elementary-data/elementary/stargazers"><img src="static/star_github.png" width="40"/></a> :star:  

<img alt="UI" src="static/ui_for_git.png" width="800">

### Checkout the [live demo](https://bit.ly/3IAp9wf)
 


## Quick start
  
Install dbt package & CLI -> Configure tests in dbt -> Alerts on Slack and detailed report  
[Quick start: Data monitoring as dbt tests in minutes](https://bit.ly/3IdMjYW). 

Our full documentation is [available here](https://docs.elementary-data.com/). 
  
  
## Elementary Features

 <img src="static/elementary_icon.ico" width="16"/>  **Data anomalies monitoring as dbt tests** - Collect metrics and metadata over time, detect anomalies, as native dbt tests in your project!

 <img src="static/elementary_icon.ico" width="16"/> **Data observability report** - Generate a report for all dbt tests and share with your team. 

 <img src="static/elementary_icon.ico" width="16"/> **dbt artifacts uploader**

 <img src="static/elementary_icon.ico" width="16"/> **Slack alerts**

 <img src="static/elementary_icon.ico" width="16"/> **Data lineage made simple, reliable, and automated**

##

  
Join [Slack](https://join.slack.com/t/elementary-community/shared_invite/zt-uehfrq2f-zXeVTtXrjYRbdE_V6xq4Rg) to learn more on Elementary.


  
## Demo & Sandbox

Data observability report [sandbox](https://bit.ly/3IAp9wf).  

Slack alert example:

<img src="static/Slack_alert_elementary.png" width="400"/>

## Community & Support

For additional information and help, you can use one of these channels:

* [Slack](https://join.slack.com/t/elementary-community/shared_invite/zt-uehfrq2f-zXeVTtXrjYRbdE_V6xq4Rg) \(Live chat with the team, support, discussions, etc.\)
* [GitHub issues](https://github.com/elementary-data/elementary/issues) \(Bug reports, feature requests)
* [Twitter](https://twitter.com/ElementaryData) \(Updates on new releases and stuff)


## **Integrations**

* [x] **Snowflake** ![](static/snowflake-16.png) 
* [x] **BigQuery**  ![](static/bigquery-16.png) 
* [x] **Redshift**  ![](static/redshift-16.png)
* [x] **Databricks**  ![](static/databricks-16.png)

Ask us for integrations on [Slack](https://join.slack.com/t/elementary-community/shared_invite/zt-uehfrq2f-zXeVTtXrjYRbdE_V6xq4Rg) or as a [GitHub issue](https://github.com/elementary-data/elementary-lineage/issues/new).


## **Contributions**

Thank you :orange_heart: Whether it’s a bug fix, new feature, or additional documentation - we greatly appreciate contributions!

Check out the [contributions guide](https://docs.elementary-data.com/general/contributions) and [open issues](https://github.com/elementary-data/elementary/issues). 


## **License**

Elementary is licensed under Apache License 2.0. See the [LICENSE](https://github.com/elementary-data/elementary/blob/master/LICENSE) file for licensing information.
