# Generated by Django 2.2.13 on 2020-07-22 19:11

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="EveCategory",
            fields=[
                (
                    "id",
                    models.PositiveIntegerField(
                        help_text="Eve Online ID", primary_key=True, serialize=False
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="Eve Online name",
                        max_length=100,
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True,
                        db_index=True,
                        help_text="When this object was last updated from ESI",
                    ),
                ),
                ("published", models.BooleanField()),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="EveConstellation",
            fields=[
                (
                    "id",
                    models.PositiveIntegerField(
                        help_text="Eve Online ID", primary_key=True, serialize=False
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="Eve Online name",
                        max_length=100,
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True,
                        db_index=True,
                        help_text="When this object was last updated from ESI",
                    ),
                ),
                (
                    "position_x",
                    models.FloatField(
                        blank=True,
                        default=None,
                        help_text="x position in the solar system",
                        null=True,
                    ),
                ),
                (
                    "position_y",
                    models.FloatField(
                        blank=True,
                        default=None,
                        help_text="y position in the solar system",
                        null=True,
                    ),
                ),
                (
                    "position_z",
                    models.FloatField(
                        blank=True,
                        default=None,
                        help_text="z position in the solar system",
                        null=True,
                    ),
                ),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="EveDogmaAttribute",
            fields=[
                (
                    "id",
                    models.PositiveIntegerField(
                        help_text="Eve Online ID", primary_key=True, serialize=False
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="Eve Online name",
                        max_length=100,
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True,
                        db_index=True,
                        help_text="When this object was last updated from ESI",
                    ),
                ),
                ("default_value", models.FloatField(default=None, null=True)),
                ("description", models.TextField(default="")),
                ("display_name", models.CharField(default="", max_length=100)),
                ("high_is_good", models.BooleanField(default=None, null=True)),
                (
                    "icon_id",
                    models.PositiveIntegerField(db_index=True, default=None, null=True),
                ),
                ("published", models.BooleanField(default=None, null=True)),
                ("stackable", models.BooleanField(default=None, null=True)),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="EveDogmaEffect",
            fields=[
                (
                    "id",
                    models.PositiveIntegerField(
                        help_text="Eve Online ID", primary_key=True, serialize=False
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="Eve Online name",
                        max_length=100,
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True,
                        db_index=True,
                        help_text="When this object was last updated from ESI",
                    ),
                ),
                ("description", models.TextField(default="")),
                ("disallow_auto_repeat", models.BooleanField(default=None, null=True)),
                ("display_name", models.CharField(default="", max_length=100)),
                (
                    "effect_category",
                    models.PositiveIntegerField(default=None, null=True),
                ),
                ("electronic_chance", models.BooleanField(default=None, null=True)),
                (
                    "icon_id",
                    models.PositiveIntegerField(db_index=True, default=None, null=True),
                ),
                ("is_assistance", models.BooleanField(default=None, null=True)),
                ("is_offensive", models.BooleanField(default=None, null=True)),
                ("is_warp_safe", models.BooleanField(default=None, null=True)),
                (
                    "post_expression",
                    models.PositiveIntegerField(default=None, null=True),
                ),
                (
                    "pre_expression",
                    models.PositiveIntegerField(default=None, null=True),
                ),
                ("published", models.BooleanField(default=None, null=True)),
                ("range_chance", models.BooleanField(default=None, null=True)),
                (
                    "discharge_attribute",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="discharge_attribute_effects",
                        to="eveuniverse.EveDogmaAttribute",
                    ),
                ),
                (
                    "duration_attribute",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="duration_attribute_effects",
                        to="eveuniverse.EveDogmaAttribute",
                    ),
                ),
                (
                    "falloff_attribute",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="falloff_attribute_effects",
                        to="eveuniverse.EveDogmaAttribute",
                    ),
                ),
                (
                    "range_attribute",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="range_attribute_effects",
                        to="eveuniverse.EveDogmaAttribute",
                    ),
                ),
                (
                    "tracking_speed_attribute",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="tracking_speed_attribute_effects",
                        to="eveuniverse.EveDogmaAttribute",
                    ),
                ),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="EveEntity",
            fields=[
                (
                    "id",
                    models.PositiveIntegerField(
                        help_text="Eve Online ID", primary_key=True, serialize=False
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="Eve Online name",
                        max_length=100,
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True,
                        db_index=True,
                        help_text="When this object was last updated from ESI",
                    ),
                ),
                (
                    "category",
                    models.CharField(
                        choices=[
                            ("alliance", "alliance"),
                            ("character", "character"),
                            ("constellation", "constellation"),
                            ("corporation", "corporation"),
                            ("faction", "faction"),
                            ("inventory_type", "inventory_type"),
                            ("region", "region"),
                            ("solar_system", "solar_system"),
                            ("station", "station"),
                        ],
                        default=None,
                        max_length=16,
                        null=True,
                    ),
                ),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="EveGraphic",
            fields=[
                (
                    "id",
                    models.PositiveIntegerField(
                        help_text="Eve Online ID", primary_key=True, serialize=False
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="Eve Online name",
                        max_length=100,
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True,
                        db_index=True,
                        help_text="When this object was last updated from ESI",
                    ),
                ),
                ("collision_file", models.CharField(default="", max_length=255)),
                ("graphic_file", models.CharField(default="", max_length=255)),
                ("icon_folder", models.CharField(default="", max_length=255)),
                ("sof_dna", models.CharField(default="", max_length=255)),
                ("sof_fation_name", models.CharField(default="", max_length=255)),
                ("sof_hull_name", models.CharField(default="", max_length=255)),
                ("sof_race_name", models.CharField(default="", max_length=255)),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="EveGroup",
            fields=[
                (
                    "id",
                    models.PositiveIntegerField(
                        help_text="Eve Online ID", primary_key=True, serialize=False
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="Eve Online name",
                        max_length=100,
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True,
                        db_index=True,
                        help_text="When this object was last updated from ESI",
                    ),
                ),
                ("published", models.BooleanField()),
                (
                    "eve_category",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="eve_groups",
                        to="eveuniverse.EveCategory",
                    ),
                ),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="EveMarketGroup",
            fields=[
                (
                    "id",
                    models.PositiveIntegerField(
                        help_text="Eve Online ID", primary_key=True, serialize=False
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="Eve Online name",
                        max_length=100,
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True,
                        db_index=True,
                        help_text="When this object was last updated from ESI",
                    ),
                ),
                ("description", models.TextField()),
                (
                    "parent_market_group",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="market_group_children",
                        to="eveuniverse.EveMarketGroup",
                    ),
                ),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="EveRace",
            fields=[
                (
                    "id",
                    models.PositiveIntegerField(
                        help_text="Eve Online ID", primary_key=True, serialize=False
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="Eve Online name",
                        max_length=100,
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True,
                        db_index=True,
                        help_text="When this object was last updated from ESI",
                    ),
                ),
                ("alliance_id", models.PositiveIntegerField(db_index=True)),
                ("description", models.TextField()),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="EveRegion",
            fields=[
                (
                    "id",
                    models.PositiveIntegerField(
                        help_text="Eve Online ID", primary_key=True, serialize=False
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="Eve Online name",
                        max_length=100,
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True,
                        db_index=True,
                        help_text="When this object was last updated from ESI",
                    ),
                ),
                ("description", models.TextField(default="")),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="EveSolarSystem",
            fields=[
                (
                    "id",
                    models.PositiveIntegerField(
                        help_text="Eve Online ID", primary_key=True, serialize=False
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="Eve Online name",
                        max_length=100,
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True,
                        db_index=True,
                        help_text="When this object was last updated from ESI",
                    ),
                ),
                (
                    "position_x",
                    models.FloatField(
                        blank=True,
                        default=None,
                        help_text="x position in the solar system",
                        null=True,
                    ),
                ),
                (
                    "position_y",
                    models.FloatField(
                        blank=True,
                        default=None,
                        help_text="y position in the solar system",
                        null=True,
                    ),
                ),
                (
                    "position_z",
                    models.FloatField(
                        blank=True,
                        default=None,
                        help_text="z position in the solar system",
                        null=True,
                    ),
                ),
                ("security_status", models.FloatField()),
                (
                    "eve_constellation",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="eve_solarsystems",
                        to="eveuniverse.EveConstellation",
                    ),
                ),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="EveStationService",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=50, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name="EveType",
            fields=[
                (
                    "id",
                    models.PositiveIntegerField(
                        help_text="Eve Online ID", primary_key=True, serialize=False
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="Eve Online name",
                        max_length=100,
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True,
                        db_index=True,
                        help_text="When this object was last updated from ESI",
                    ),
                ),
                ("capacity", models.FloatField(default=None, null=True)),
                (
                    "icon_id",
                    models.PositiveIntegerField(db_index=True, default=None, null=True),
                ),
                ("mass", models.FloatField(default=None, null=True)),
                ("packaged_volume", models.FloatField(default=None, null=True)),
                ("portion_size", models.PositiveIntegerField(default=None, null=True)),
                ("radius", models.FloatField(default=None, null=True)),
                ("published", models.BooleanField()),
                ("volume", models.FloatField(default=None, null=True)),
                (
                    "eve_graphic",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="eve_types",
                        to="eveuniverse.EveGraphic",
                    ),
                ),
                (
                    "eve_group",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="eve_types",
                        to="eveuniverse.EveGroup",
                    ),
                ),
                (
                    "eve_market_group",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="eve_types",
                        to="eveuniverse.EveMarketGroup",
                    ),
                ),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="EveUnit",
            fields=[
                (
                    "id",
                    models.PositiveIntegerField(
                        help_text="Eve Online ID", primary_key=True, serialize=False
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="Eve Online name",
                        max_length=100,
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True,
                        db_index=True,
                        help_text="When this object was last updated from ESI",
                    ),
                ),
                ("display_name", models.CharField(default="", max_length=50)),
                ("description", models.TextField(default="")),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="EveTypeDogmaEffect",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("is_default", models.BooleanField()),
                (
                    "eve_dogma_effect",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="eve_type_dogma_effects",
                        to="eveuniverse.EveDogmaEffect",
                    ),
                ),
                (
                    "eve_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="dogma_effects",
                        to="eveuniverse.EveType",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="EveTypeDogmaAttribute",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("value", models.FloatField()),
                (
                    "eve_dogma_attribute",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="eve_type_dogma_attributes",
                        to="eveuniverse.EveDogmaAttribute",
                    ),
                ),
                (
                    "eve_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="dogma_attributes",
                        to="eveuniverse.EveType",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="EveStation",
            fields=[
                (
                    "id",
                    models.PositiveIntegerField(
                        help_text="Eve Online ID", primary_key=True, serialize=False
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="Eve Online name",
                        max_length=100,
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True,
                        db_index=True,
                        help_text="When this object was last updated from ESI",
                    ),
                ),
                ("max_dockable_ship_volume", models.FloatField()),
                ("office_rental_cost", models.FloatField()),
                (
                    "owner_id",
                    models.PositiveIntegerField(db_index=True, default=None, null=True),
                ),
                (
                    "position_x",
                    models.FloatField(
                        blank=True,
                        default=None,
                        help_text="x position in the solar system",
                        null=True,
                    ),
                ),
                (
                    "position_y",
                    models.FloatField(
                        blank=True,
                        default=None,
                        help_text="y position in the solar system",
                        null=True,
                    ),
                ),
                (
                    "position_z",
                    models.FloatField(
                        blank=True,
                        default=None,
                        help_text="z position in the solar system",
                        null=True,
                    ),
                ),
                ("reprocessing_efficiency", models.FloatField()),
                ("reprocessing_stations_take", models.FloatField()),
                (
                    "eve_race",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="eve_stations",
                        to="eveuniverse.EveRace",
                    ),
                ),
                (
                    "eve_solar_system",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="eve_stations",
                        to="eveuniverse.EveSolarSystem",
                    ),
                ),
                (
                    "eve_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="eve_stations",
                        to="eveuniverse.EveType",
                    ),
                ),
                (
                    "services",
                    models.ManyToManyField(to="eveuniverse.EveStationService"),
                ),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="EveStargate",
            fields=[
                (
                    "id",
                    models.PositiveIntegerField(
                        help_text="Eve Online ID", primary_key=True, serialize=False
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="Eve Online name",
                        max_length=100,
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True,
                        db_index=True,
                        help_text="When this object was last updated from ESI",
                    ),
                ),
                (
                    "position_x",
                    models.FloatField(
                        blank=True,
                        default=None,
                        help_text="x position in the solar system",
                        null=True,
                    ),
                ),
                (
                    "position_y",
                    models.FloatField(
                        blank=True,
                        default=None,
                        help_text="y position in the solar system",
                        null=True,
                    ),
                ),
                (
                    "position_z",
                    models.FloatField(
                        blank=True,
                        default=None,
                        help_text="z position in the solar system",
                        null=True,
                    ),
                ),
                (
                    "destination_eve_solar_system",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="destination_eve_stargates",
                        to="eveuniverse.EveSolarSystem",
                    ),
                ),
                (
                    "destination_eve_stargate",
                    models.OneToOneField(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        to="eveuniverse.EveStargate",
                    ),
                ),
                (
                    "eve_solar_system",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="eve_stargates",
                        to="eveuniverse.EveSolarSystem",
                    ),
                ),
                (
                    "eve_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="eve_stargates",
                        to="eveuniverse.EveType",
                    ),
                ),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="EveStar",
            fields=[
                (
                    "id",
                    models.PositiveIntegerField(
                        help_text="Eve Online ID", primary_key=True, serialize=False
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="Eve Online name",
                        max_length=100,
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True,
                        db_index=True,
                        help_text="When this object was last updated from ESI",
                    ),
                ),
                ("age", models.BigIntegerField()),
                ("luminosity", models.FloatField()),
                ("radius", models.PositiveIntegerField()),
                ("spectral_class", models.CharField(max_length=16)),
                ("temperature", models.PositiveIntegerField()),
                (
                    "eve_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="eve_stars",
                        to="eveuniverse.EveType",
                    ),
                ),
            ],
            options={"abstract": False,},
        ),
        migrations.AddField(
            model_name="evesolarsystem",
            name="eve_star",
            field=models.OneToOneField(
                default=None,
                null=True,
                on_delete=django.db.models.deletion.SET_DEFAULT,
                related_name="eve_solarsystem",
                to="eveuniverse.EveStar",
            ),
        ),
        migrations.CreateModel(
            name="EvePlanet",
            fields=[
                (
                    "id",
                    models.PositiveIntegerField(
                        help_text="Eve Online ID", primary_key=True, serialize=False
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="Eve Online name",
                        max_length=100,
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True,
                        db_index=True,
                        help_text="When this object was last updated from ESI",
                    ),
                ),
                (
                    "position_x",
                    models.FloatField(
                        blank=True,
                        default=None,
                        help_text="x position in the solar system",
                        null=True,
                    ),
                ),
                (
                    "position_y",
                    models.FloatField(
                        blank=True,
                        default=None,
                        help_text="y position in the solar system",
                        null=True,
                    ),
                ),
                (
                    "position_z",
                    models.FloatField(
                        blank=True,
                        default=None,
                        help_text="z position in the solar system",
                        null=True,
                    ),
                ),
                (
                    "eve_solar_system",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="eve_planets",
                        to="eveuniverse.EveSolarSystem",
                    ),
                ),
                (
                    "eve_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="eve_planets",
                        to="eveuniverse.EveType",
                    ),
                ),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="EveMoon",
            fields=[
                (
                    "id",
                    models.PositiveIntegerField(
                        help_text="Eve Online ID", primary_key=True, serialize=False
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="Eve Online name",
                        max_length=100,
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True,
                        db_index=True,
                        help_text="When this object was last updated from ESI",
                    ),
                ),
                (
                    "position_x",
                    models.FloatField(
                        blank=True,
                        default=None,
                        help_text="x position in the solar system",
                        null=True,
                    ),
                ),
                (
                    "position_y",
                    models.FloatField(
                        blank=True,
                        default=None,
                        help_text="y position in the solar system",
                        null=True,
                    ),
                ),
                (
                    "position_z",
                    models.FloatField(
                        blank=True,
                        default=None,
                        help_text="z position in the solar system",
                        null=True,
                    ),
                ),
                (
                    "eve_planet",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="eve_moons",
                        to="eveuniverse.EvePlanet",
                    ),
                ),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="EveFaction",
            fields=[
                (
                    "id",
                    models.PositiveIntegerField(
                        help_text="Eve Online ID", primary_key=True, serialize=False
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="Eve Online name",
                        max_length=100,
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True,
                        db_index=True,
                        help_text="When this object was last updated from ESI",
                    ),
                ),
                (
                    "corporation_id",
                    models.PositiveIntegerField(db_index=True, default=None, null=True),
                ),
                ("description", models.TextField()),
                ("is_unique", models.BooleanField()),
                (
                    "militia_corporation_id",
                    models.PositiveIntegerField(db_index=True, default=None, null=True),
                ),
                ("size_factor", models.FloatField()),
                ("station_count", models.PositiveIntegerField()),
                ("station_system_count", models.PositiveIntegerField()),
                (
                    "eve_solar_system",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="eve_factions",
                        to="eveuniverse.EveSolarSystem",
                    ),
                ),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="EveDogmaEffectModifier",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("domain", models.CharField(default="", max_length=100)),
                ("func", models.CharField(max_length=100)),
                ("operator", models.PositiveIntegerField(default=None, null=True)),
                (
                    "eve_dogma_effect",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="modifiers",
                        to="eveuniverse.EveDogmaEffect",
                    ),
                ),
                (
                    "modified_attribute",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="modified_attribute_modifiers",
                        to="eveuniverse.EveDogmaAttribute",
                    ),
                ),
                (
                    "modifying_attribute",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="modifying_attribute_modifiers",
                        to="eveuniverse.EveDogmaAttribute",
                    ),
                ),
                (
                    "modifying_effect",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="modifying_effect_modifiers",
                        to="eveuniverse.EveDogmaEffect",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="evedogmaattribute",
            name="eve_unit",
            field=models.ForeignKey(
                default=None,
                null=True,
                on_delete=django.db.models.deletion.SET_DEFAULT,
                related_name="eve_units",
                to="eveuniverse.EveUnit",
            ),
        ),
        migrations.AddField(
            model_name="eveconstellation",
            name="eve_region",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="eve_constellations",
                to="eveuniverse.EveRegion",
            ),
        ),
        migrations.CreateModel(
            name="EveBloodline",
            fields=[
                (
                    "id",
                    models.PositiveIntegerField(
                        help_text="Eve Online ID", primary_key=True, serialize=False
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="Eve Online name",
                        max_length=100,
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True,
                        db_index=True,
                        help_text="When this object was last updated from ESI",
                    ),
                ),
                ("charisma", models.PositiveIntegerField()),
                ("corporation_id", models.PositiveIntegerField()),
                ("description", models.TextField()),
                ("intelligence", models.PositiveIntegerField()),
                ("memory", models.PositiveIntegerField()),
                ("perception", models.PositiveIntegerField()),
                ("willpower", models.PositiveIntegerField()),
                (
                    "eve_race",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="eve_bloodlines",
                        to="eveuniverse.EveRace",
                    ),
                ),
                (
                    "eve_ship_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="eve_bloodlines",
                        to="eveuniverse.EveType",
                    ),
                ),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="EveAsteroidBelt",
            fields=[
                (
                    "id",
                    models.PositiveIntegerField(
                        help_text="Eve Online ID", primary_key=True, serialize=False
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="Eve Online name",
                        max_length=100,
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True,
                        db_index=True,
                        help_text="When this object was last updated from ESI",
                    ),
                ),
                (
                    "position_x",
                    models.FloatField(
                        blank=True,
                        default=None,
                        help_text="x position in the solar system",
                        null=True,
                    ),
                ),
                (
                    "position_y",
                    models.FloatField(
                        blank=True,
                        default=None,
                        help_text="y position in the solar system",
                        null=True,
                    ),
                ),
                (
                    "position_z",
                    models.FloatField(
                        blank=True,
                        default=None,
                        help_text="z position in the solar system",
                        null=True,
                    ),
                ),
                (
                    "eve_planet",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="eve_asteroid_belts",
                        to="eveuniverse.EvePlanet",
                    ),
                ),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="EveAncestry",
            fields=[
                (
                    "id",
                    models.PositiveIntegerField(
                        help_text="Eve Online ID", primary_key=True, serialize=False
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="Eve Online name",
                        max_length=100,
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        auto_now=True,
                        db_index=True,
                        help_text="When this object was last updated from ESI",
                    ),
                ),
                ("description", models.TextField()),
                (
                    "icon_id",
                    models.PositiveIntegerField(db_index=True, default=None, null=True),
                ),
                ("short_description", models.TextField(default="")),
                (
                    "eve_bloodline",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="eve_bloodlines",
                        to="eveuniverse.EveBloodline",
                    ),
                ),
            ],
            options={"abstract": False,},
        ),
        migrations.AddConstraint(
            model_name="evetypedogmaeffect",
            constraint=models.UniqueConstraint(
                fields=("eve_type", "eve_dogma_effect"), name="fpk_evetypedogmaeffect"
            ),
        ),
        migrations.AddConstraint(
            model_name="evetypedogmaattribute",
            constraint=models.UniqueConstraint(
                fields=("eve_type", "eve_dogma_attribute"),
                name="fpk_evetypedogmaattribute",
            ),
        ),
        migrations.AddConstraint(
            model_name="evedogmaeffectmodifier",
            constraint=models.UniqueConstraint(
                fields=("eve_dogma_effect", "func"), name="fpk_evedogmaeffectmodifier"
            ),
        ),
    ]
