# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['opentype_feature_freezer']

package_data = \
{'': ['*']}

install_requires = \
['fonttools>=4.0,<5.0']

entry_points = \
{'console_scripts': ['pyftfeatfreeze = opentype_feature_freezer.cli:main']}

setup_kwargs = {
    'name': 'opentype-feature-freezer',
    'version': '1.32.2',
    'description': "Turns OpenType features 'on' by default in a font: reassigns the font's Unicode-to-glyph mapping fo permanently 'freeze' the 1-to-1 substitution features, and creates a new font.",
    'long_description': '# OpenType Feature Freezer\n\nWith **[OpenType Feature Freezer](https://twardoch.github.io/fonttools-opentype-feature-freezer/)**, you can “freeze” some OpenType features into a font.\n\nThese features are then “on by default”, so characters previously accessible through OpenType features only (such as smallcaps, oldstyle numerals or localized forms) will now be accessible even in apps that don’t support OpenType features, such as LibreOffice, OpenOffice, or in apps that don’t support a particular feature, such as Microsoft Office in case of smallcaps.\n\n_Note: This tool actually remaps the `cmap` table of the font by applying the specified `GSUB` features. It will not work for substitutions where neither glyph has any `cmap` entries. Only single and alternate substitutions are supported._\n\nThis tool comes in two versions: **OTFeatureFreezer**: a simple GUI (graphical) app for macOS and Windows that you can download and run without any special perparations, and **pyftfeatfreeze**: a CLI (command-line) app that required Python 3.6 or newer to be installed on your computer.\n\nCurrent version: **[1.32](https://github.com/twardoch/fonttools-opentype-feature-freezer/blob/master/README.md#changelog)**\n\n- [Download and install](https://twardoch.github.io/fonttools-opentype-feature-freezer/)\n- [Documentation](https://github.com/twardoch/fonttools-opentype-feature-freezer/blob/master/README.md#documentation)\n- [Source code](https://github.com/twardoch/fonttools-opentype-feature-freezer/)\n- [Issues](https://github.com/twardoch/fonttools-opentype-feature-freezer/issues) for problem reporting\n\n# Installation\n\n## Install the OTFeatureFreezer GUI app for macOS\n\n### <a class="github-button btn btn-primary" href="https://github.com/twardoch/fonttools-opentype-feature-freezer/raw/master/download/OTFeatureFreezer.dmg" data-color-scheme="no-preference: dark; light: dark; dark: dark;" data-icon="octicon-download" data-size="large" aria-label="Download DMG for macOS">Download DMG for macOS</a>\n\n1. On **macOS**, click the **Download** link above.\n2. **Ctrl+click** the downloaded DMG, choose **Open**, then **Open** again.\n3. Drag the _OTFeatureFreezer.app_ icon to your **/Applications** folder.\n4. When you **run the app for the first time**, **Ctrl+click** the _OTFeatureFreezer.app_, choose **Open**, then click **Open**.\n5. Later, you can just double-click the icon to run the app. If the app does not run, double-click again.\n6. See the [Documentation](https://github.com/twardoch/fonttools-opentype-feature-freezer/blob/master/README.md#documentation) for info about how to use the GUI app. The GUI corresponds to the command-line options.\n\n## Install the OTFeatureFreezer GUI app for Windows (64-bit)\n\n### <a class="github-button btn btn-primary" href="https://github.com/twardoch/fonttools-opentype-feature-freezer/raw/master/download/OTFeatureFreezer.zip" data-color-scheme="no-preference: dark; light: dark; dark: dark;" data-icon="octicon-download" data-size="large" aria-label="Download ZIP for Windows">Download ZIP for Windows</a>\n\n1. You need a **64-bit** version of **Windows**, 7 or newer. 32-bit Windows is not supported.\n2. Click the **Download** link above.\n3. Unzip the downloaded ZIP.\n4. Double-click the _setup_featfreeze.exe_ icon to install the app.\n5. Run _OTFeatureFreezer_ from your Start menu.\n6. See the [Documentation](https://github.com/twardoch/fonttools-opentype-feature-freezer/blob/master/README.md#documentation) for info about how to use the GUI app. The GUI corresponds to the command-line options.\n\n## Install the pyftfeatfreeze CLI app\n\nThis tool requires Python 3.6 or above to be installed first. Get it from https://www.python.org or your package manager.\n\n### Recommended\n\nWe recommend using [pipx](https://pypi.org/project/pipx/) to install Python command line tools. Pipx tucks them away neatly on your computer and gives you an easy way to add, update and remove Python tools on all platforms, without leaving a mess in your Python installation.\n\n```\npipx install opentype-feature-freezer\n```\n\n### Other methods\n\nInstall it with `pip`, as any other Python package.\n\n```\n# This is best done inside a virtual environment, so you don\'t pollute\n# your Python installation and need no special privileges to install anything.\n\npip install --upgrade opentype-feature-freezer\n```\n\nIf this does not work, try:\n\n```\npython3 -m pip install --user --upgrade opentype-feature-freezer\n```\n\n### Development version\n\n```\npip install --upgrade git+https://github.com/twardoch/fonttools-opentype-feature-freezer\n```\n\nIf this does not work, use:\n\n```\npython3 -m pip install --user --upgrade git+https://github.com/twardoch/fonttools-opentype-feature-freezer\n```\n\n- You may need to do `pip install --upgrade configparser` before installing\n\n# Documentation\n\n## Examples\n\nLet’s say you have the font *CharisSIL-R.ttf* (with the menu name “Charis SIL”), and this font includes true smallcaps accessible via the OpenType Layout features `c2sc` (for uppercase) and `smcp` (for lowercase). Let’s say that you’d like to make a second font where the **true smallcaps** are available by default. Just run:\n\n```\npyftfeatfreeze -f \'c2sc,smcp\' -S -U SC -R \'Charis SIL/Charix,CharisSIL/Charix\' CharisSIL-R.ttf CharixSC-R.ttf\n```\n\nYou’ll get a new font *CharisSIL-R.ttf* (with the menu name “Charix SC”). This font will have smallcaps instead of the lowercase and uppercase letters, available in all apps.\n\nSince the “Charis SIL” font is licensed under the OFL, and uses the Reserved Font Names “Charis” and “SIL”, I’ve specified the `-R` option to replace the name strings `Charis SIL` and `CharisSIL` with `Charix`. This way, the modified font is compliant with the OFL and I can distribute it.\n\nThe following example remaps the font so that the **Bulgarian localized forms** are available by default in all apps (the suffix “BG” will be added to the menu name):\n\n```\npyftfeatfreeze -f \'locl\' -s \'cyrl\' -l \'BGR \' -S -U BG SomeFont.ttf SomeFontBG.ttf\n```\n\n*Note: To remap features from multiple scripts or languagesystems, run the tool multiple times (taking the previous run’s output as input). Use the `-S` option only on the final run.*\n\nThe following replaces the string `Lato` by `Otal` in all internal font names (in the `name` and `CFF ` tables), without doing any “feature freezing”. This can be used to quickly change some internal font names:\n\n```\npyftfeatfreeze -R \'Lato/Otal\' Lato-Regular.ttf Otal-Regular.ttf\n```\n\n\n## Command-line syntax\n\n```\nusage: pyftfeatfreeze [-h] [-f FEATURES] [-s SCRIPT] [-l LANG] [-z] [-S]\n                      [-U USESUFFIX] [-R REPLACENAMES] [-i] [-r] [-n] [-v]\n                      [-V]\n                      inpath [outpath]\n\nWith pyftfeatfreeze you can "freeze" some OpenType features into a font. These\nfeatures are then "on by default", even in apps that don\'t support OpenType\nfeatures. Internally, the tool remaps the "cmap" table of the font by applying\nthe specified GSUB features. Only single and alternate substitutions are\nsupported.\n\npositional arguments:\n  inpath                input .otf or .ttf font file\n  outpath               output .otf or .ttf font file (optional)\n\noptional arguments:\n  -h, --help            show this help message and exit\n\noptions to control feature freezing:\n  -f FEATURES, --features FEATURES\n                        comma-separated list of OpenType feature tags, e.g.\n                        \'smcp,c2sc,onum\'\n  -s SCRIPT, --script SCRIPT\n                        OpenType script tag, e.g. \'cyrl\' (default: \'latn\')\n  -l LANG, --lang LANG  OpenType language tag, e.g. \'SRB \' (optional)\n  -z, --zapnames        zap glyphnames from the font (\'post\' table version 3,\n                        .ttf only)\n\noptions to control font renaming:\n  -S, --suffix          add a suffix to the font family name (by default, the\n                        suffix will be constructed from the OpenType feature\n                        tags)\n  -U USESUFFIX, --usesuffix USESUFFIX\n                        use a custom suffix when --suffix is provided\n  -R REPLACENAMES, --replacenames REPLACENAMES\n                        search for strings in the font naming tables and\n                        replace them, format is\n                        \'search1/replace1,search2/replace2,...\'\n  -i, --info            update font version string\n\nreporting options:\n  -r, --report          report languages, scripts and features in font\n  -n, --names           output names of remapped glyphs during processing\n  -v, --verbose         print additional information during processing\n  -V, --version         show program\'s version number and exit\n\nExamples: pyftfeatfreeze -f \'c2sc,smcp\' -S -U SC OpenSans.ttf OpenSansSC.ttf\npyftfeatfreeze -R \'Lato/Otal\' Lato-Regular.ttf Otal-Regular.ttf\n```\n\n*Tip: the `-n` option outputs a space-separated list of “frozen” glyphs. If you redirect it to a file, you can use this list as input for `pyftsubset` to create a small font that only includes the “frozen”\xa0glyphs.*\n\n## Other\n\n### Problem reporting\n\nTo report a problem, open an **[issue](https://github.com/twardoch/fonttools-opentype-feature-freezer/issues)**. You need a Github account.\n\n### Software license and disclaimer\n\nThis tool is licensed “as is” under the [Apache License, Version 2.0](http://www.apache.org/licenses/LICENSE-2.0). By using the tool, you accept all conditions of the license, including Disclaimer of Warranty and Limitation of Liability. **If you use this tool, please consult if your font’s EULA allows modifications. If the font is licensed under the OFL and uses the Reserved Font Name, please use the `-R` option to change the Reserved Font Name to something else.**\n\n\n### Requirements\n\nThis tool is written for Python 3.6+, and uses [fontTools/TTX](https://github.com/fonttools/fonttools/).\n\n\n### Changelog\n\n- **1.32**: Changes the `-s` (script) option so that if it’s not provided, the remapping is in all scripts.\n- **1.31**: Changes the `-S` (suffix) option so that if it’s not provided, no sufix is added, and added the GUI apps.\n- Previously, this tool was published as a sub-tool in a [fonttools-utils](https://github.com/twardoch/fonttools-utils/tree/master/pyftfeatfreeze) repo\n- The other tools of the `fonttools-utils` repo are now at [fonttools-ttxjson](https://github.com/twardoch/fonttools-ttxjson) and [mac-os-x-system-font-replacer](https://github.com/twardoch/mac-os-x-system-font-replacer)\n\n### Building\n\n#### Python\n\nTo build the Python package, install [Poetry](https://python-poetry.org/):\n\n```\npip install poetry\n```\n\nor\n\n```\npython3 -m install --user --upgrade poetry\n```\n\nthen in the main folder of the project run:\n\n```\npoetry build\n```\n\n#### DMG & EXE\n\nTo build the DMG & EXE, you need macOS. In the [app](https://github.com/twardoch/fonttools-opentype-feature-freezer/tree/master/app) subfolder, run `./macdeploy all`\n\n### Credits\n\n* Code by [Adam Twardoch and others](https://raw.githubusercontent.com/twardoch/fonttools-opentype-feature-freezer/master/AUTHORS)\n\n<!-- Place this tag in your head or just before your close body tag. -->\n<script async defer src="https://buttons.github.io/buttons.js"></script>\n\n',
    'author': 'Adam Twardoch',
    'author_email': 'adam@twardoch.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
