# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['QueryArgs', 'Query']

@pulumi.input_type
class QueryArgs:
    def __init__(__self__, *,
                 dataset: pulumi.Input[str],
                 query_json: pulumi.Input[str]):
        """
        The set of arguments for constructing a Query resource.
        :param pulumi.Input[str] dataset: The dataset this query is added to.
        :param pulumi.Input[str] query_json: A JSON object describing the query according to the [Query Specification](https://docs.honeycomb.io/api/query-specification/#fields-on-a-query-specification). While the JSON can be constructed manually, it is easiest to use the `_get_query_specification` data source.
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "query_json", query_json)

    @property
    @pulumi.getter
    def dataset(self) -> pulumi.Input[str]:
        """
        The dataset this query is added to.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter(name="queryJson")
    def query_json(self) -> pulumi.Input[str]:
        """
        A JSON object describing the query according to the [Query Specification](https://docs.honeycomb.io/api/query-specification/#fields-on-a-query-specification). While the JSON can be constructed manually, it is easiest to use the `_get_query_specification` data source.
        """
        return pulumi.get(self, "query_json")

    @query_json.setter
    def query_json(self, value: pulumi.Input[str]):
        pulumi.set(self, "query_json", value)


@pulumi.input_type
class _QueryState:
    def __init__(__self__, *,
                 dataset: Optional[pulumi.Input[str]] = None,
                 query_json: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Query resources.
        :param pulumi.Input[str] dataset: The dataset this query is added to.
        :param pulumi.Input[str] query_json: A JSON object describing the query according to the [Query Specification](https://docs.honeycomb.io/api/query-specification/#fields-on-a-query-specification). While the JSON can be constructed manually, it is easiest to use the `_get_query_specification` data source.
        """
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if query_json is not None:
            pulumi.set(__self__, "query_json", query_json)

    @property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input[str]]:
        """
        The dataset this query is added to.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter(name="queryJson")
    def query_json(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON object describing the query according to the [Query Specification](https://docs.honeycomb.io/api/query-specification/#fields-on-a-query-specification). While the JSON can be constructed manually, it is easiest to use the `_get_query_specification` data source.
        """
        return pulumi.get(self, "query_json")

    @query_json.setter
    def query_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_json", value)


class Query(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataset: Optional[pulumi.Input[str]] = None,
                 query_json: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # Resource: Query

        Creates a query in a dataset.

        Queries can be used by triggers and boards, or be executed via the [Query Data API](https://docs.honeycomb.io/api/query-results/).

        > **Note** Queries can only be created or read. Any changes will result in a new query object being created, and destroying it does nothing.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_honeycomb as honeycomb

        config = pulumi.Config()
        dataset = config.require("dataset")
        test_query_get_query_specification = honeycomb.get_query_specification(calculations=[honeycomb.GetQuerySpecificationCalculationArgs(
                op="AVG",
                column="duration_ms",
            )],
            filters=[honeycomb.GetQuerySpecificationFilterArgs(
                column="duration_ms",
                op=">",
                value="200",
            )])
        test_query_query = honeycomb.Query("testQueryQuery",
            dataset="%s",
            query_json=test_query_get_query_specification.json)
        ```

        ## Import

        Queries cannot be imported.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dataset: The dataset this query is added to.
        :param pulumi.Input[str] query_json: A JSON object describing the query according to the [Query Specification](https://docs.honeycomb.io/api/query-specification/#fields-on-a-query-specification). While the JSON can be constructed manually, it is easiest to use the `_get_query_specification` data source.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QueryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: Query

        Creates a query in a dataset.

        Queries can be used by triggers and boards, or be executed via the [Query Data API](https://docs.honeycomb.io/api/query-results/).

        > **Note** Queries can only be created or read. Any changes will result in a new query object being created, and destroying it does nothing.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_honeycomb as honeycomb

        config = pulumi.Config()
        dataset = config.require("dataset")
        test_query_get_query_specification = honeycomb.get_query_specification(calculations=[honeycomb.GetQuerySpecificationCalculationArgs(
                op="AVG",
                column="duration_ms",
            )],
            filters=[honeycomb.GetQuerySpecificationFilterArgs(
                column="duration_ms",
                op=">",
                value="200",
            )])
        test_query_query = honeycomb.Query("testQueryQuery",
            dataset="%s",
            query_json=test_query_get_query_specification.json)
        ```

        ## Import

        Queries cannot be imported.

        :param str resource_name: The name of the resource.
        :param QueryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QueryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataset: Optional[pulumi.Input[str]] = None,
                 query_json: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QueryArgs.__new__(QueryArgs)

            if dataset is None and not opts.urn:
                raise TypeError("Missing required property 'dataset'")
            __props__.__dict__["dataset"] = dataset
            if query_json is None and not opts.urn:
                raise TypeError("Missing required property 'query_json'")
            __props__.__dict__["query_json"] = query_json
        super(Query, __self__).__init__(
            'honeycomb:index/query:Query',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dataset: Optional[pulumi.Input[str]] = None,
            query_json: Optional[pulumi.Input[str]] = None) -> 'Query':
        """
        Get an existing Query resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dataset: The dataset this query is added to.
        :param pulumi.Input[str] query_json: A JSON object describing the query according to the [Query Specification](https://docs.honeycomb.io/api/query-specification/#fields-on-a-query-specification). While the JSON can be constructed manually, it is easiest to use the `_get_query_specification` data source.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QueryState.__new__(_QueryState)

        __props__.__dict__["dataset"] = dataset
        __props__.__dict__["query_json"] = query_json
        return Query(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def dataset(self) -> pulumi.Output[str]:
        """
        The dataset this query is added to.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter(name="queryJson")
    def query_json(self) -> pulumi.Output[str]:
        """
        A JSON object describing the query according to the [Query Specification](https://docs.honeycomb.io/api/query-specification/#fields-on-a-query-specification). While the JSON can be constructed manually, it is easiest to use the `_get_query_specification` data source.
        """
        return pulumi.get(self, "query_json")

