# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['PagerdutyRecipientArgs', 'PagerdutyRecipient']

@pulumi.input_type
class PagerdutyRecipientArgs:
    def __init__(__self__, *,
                 integration_key: pulumi.Input[str],
                 integration_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a PagerdutyRecipient resource.
        :param pulumi.Input[str] integration_key: The key of the PagerDuty Integration to send the notification to.
        :param pulumi.Input[str] integration_name: The name of the PagerDuty Integration to send the notification to.
        """
        pulumi.set(__self__, "integration_key", integration_key)
        pulumi.set(__self__, "integration_name", integration_name)

    @property
    @pulumi.getter(name="integrationKey")
    def integration_key(self) -> pulumi.Input[str]:
        """
        The key of the PagerDuty Integration to send the notification to.
        """
        return pulumi.get(self, "integration_key")

    @integration_key.setter
    def integration_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "integration_key", value)

    @property
    @pulumi.getter(name="integrationName")
    def integration_name(self) -> pulumi.Input[str]:
        """
        The name of the PagerDuty Integration to send the notification to.
        """
        return pulumi.get(self, "integration_name")

    @integration_name.setter
    def integration_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "integration_name", value)


@pulumi.input_type
class _PagerdutyRecipientState:
    def __init__(__self__, *,
                 integration_key: Optional[pulumi.Input[str]] = None,
                 integration_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering PagerdutyRecipient resources.
        :param pulumi.Input[str] integration_key: The key of the PagerDuty Integration to send the notification to.
        :param pulumi.Input[str] integration_name: The name of the PagerDuty Integration to send the notification to.
        """
        if integration_key is not None:
            pulumi.set(__self__, "integration_key", integration_key)
        if integration_name is not None:
            pulumi.set(__self__, "integration_name", integration_name)

    @property
    @pulumi.getter(name="integrationKey")
    def integration_key(self) -> Optional[pulumi.Input[str]]:
        """
        The key of the PagerDuty Integration to send the notification to.
        """
        return pulumi.get(self, "integration_key")

    @integration_key.setter
    def integration_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "integration_key", value)

    @property
    @pulumi.getter(name="integrationName")
    def integration_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the PagerDuty Integration to send the notification to.
        """
        return pulumi.get(self, "integration_name")

    @integration_name.setter
    def integration_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "integration_name", value)


class PagerdutyRecipient(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 integration_key: Optional[pulumi.Input[str]] = None,
                 integration_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # Resource: PagerdutyRecipient

        `PagerdutyRecipient` allows you to define and manage a PagerDuty recipient that can be used by Triggers or BurnAlerts notifications.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_honeycomb as honeycomb

        prod_oncall = honeycomb.PagerdutyRecipient("prod-oncall",
            integration_key="cd6e8de3c857aefc950e0d5ebcb79ac2",
            integration_name="Production on-call notifications")
        ```

        ## Import

        PagerDuty Recipients can be imported by their ID, e.g.

        ```sh
         $ pulumi import honeycomb:index/pagerdutyRecipient:PagerdutyRecipient my_recipient nx2zsegA0dZ
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] integration_key: The key of the PagerDuty Integration to send the notification to.
        :param pulumi.Input[str] integration_name: The name of the PagerDuty Integration to send the notification to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PagerdutyRecipientArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: PagerdutyRecipient

        `PagerdutyRecipient` allows you to define and manage a PagerDuty recipient that can be used by Triggers or BurnAlerts notifications.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_honeycomb as honeycomb

        prod_oncall = honeycomb.PagerdutyRecipient("prod-oncall",
            integration_key="cd6e8de3c857aefc950e0d5ebcb79ac2",
            integration_name="Production on-call notifications")
        ```

        ## Import

        PagerDuty Recipients can be imported by their ID, e.g.

        ```sh
         $ pulumi import honeycomb:index/pagerdutyRecipient:PagerdutyRecipient my_recipient nx2zsegA0dZ
        ```

        :param str resource_name: The name of the resource.
        :param PagerdutyRecipientArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PagerdutyRecipientArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 integration_key: Optional[pulumi.Input[str]] = None,
                 integration_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PagerdutyRecipientArgs.__new__(PagerdutyRecipientArgs)

            if integration_key is None and not opts.urn:
                raise TypeError("Missing required property 'integration_key'")
            __props__.__dict__["integration_key"] = integration_key
            if integration_name is None and not opts.urn:
                raise TypeError("Missing required property 'integration_name'")
            __props__.__dict__["integration_name"] = integration_name
        super(PagerdutyRecipient, __self__).__init__(
            'honeycomb:index/pagerdutyRecipient:PagerdutyRecipient',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            integration_key: Optional[pulumi.Input[str]] = None,
            integration_name: Optional[pulumi.Input[str]] = None) -> 'PagerdutyRecipient':
        """
        Get an existing PagerdutyRecipient resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] integration_key: The key of the PagerDuty Integration to send the notification to.
        :param pulumi.Input[str] integration_name: The name of the PagerDuty Integration to send the notification to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PagerdutyRecipientState.__new__(_PagerdutyRecipientState)

        __props__.__dict__["integration_key"] = integration_key
        __props__.__dict__["integration_name"] = integration_name
        return PagerdutyRecipient(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="integrationKey")
    def integration_key(self) -> pulumi.Output[str]:
        """
        The key of the PagerDuty Integration to send the notification to.
        """
        return pulumi.get(self, "integration_key")

    @property
    @pulumi.getter(name="integrationName")
    def integration_name(self) -> pulumi.Output[str]:
        """
        The name of the PagerDuty Integration to send the notification to.
        """
        return pulumi.get(self, "integration_name")

