# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'BoardQuery',
    'BoardQueryGraphSettings',
    'BurnAlertRecipient',
    'BurnAlertRecipientNotificationDetails',
    'GetQuerySpecificationCalculationResult',
    'GetQuerySpecificationFilterResult',
    'GetQuerySpecificationHavingResult',
    'GetQuerySpecificationOrderResult',
    'GetRecipientDetailFilterResult',
    'GetRecipientsDetailFilterResult',
    'TriggerRecipient',
    'TriggerRecipientNotificationDetails',
    'TriggerThreshold',
]

@pulumi.output_type
class BoardQuery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryId":
            suggest = "query_id"
        elif key == "graphSettings":
            suggest = "graph_settings"
        elif key == "queryAnnotationId":
            suggest = "query_annotation_id"
        elif key == "queryStyle":
            suggest = "query_style"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BoardQuery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BoardQuery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BoardQuery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_id: str,
                 caption: Optional[str] = None,
                 dataset: Optional[str] = None,
                 graph_settings: Optional['outputs.BoardQueryGraphSettings'] = None,
                 query_annotation_id: Optional[str] = None,
                 query_style: Optional[str] = None):
        """
        :param str query_id: The ID of the Query to run.
        :param str caption: A description of the query that will be displayed on the board. Supports markdown.
        :param str dataset: The dataset this query is associated with.
        :param 'BoardQueryGraphSettingsArgs' graph_settings: A map of boolean toggles to manages the settings for this query's graph on the board.
               If a value is unspecified, it is assumed to be false.
               Currently supported toggles are:
               * `hide_markers`
               * `log_scale`
               * `omit_missing_values`
               * `stacked_graphs`
               * `utc_xaxis`
        :param str query_annotation_id: The ID of the Query Annotation to associate with this query.
        :param str query_style: How the query should be displayed within the board, either `graph` (the default), `table` or `combo`.
        """
        pulumi.set(__self__, "query_id", query_id)
        if caption is not None:
            pulumi.set(__self__, "caption", caption)
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if graph_settings is not None:
            pulumi.set(__self__, "graph_settings", graph_settings)
        if query_annotation_id is not None:
            pulumi.set(__self__, "query_annotation_id", query_annotation_id)
        if query_style is not None:
            pulumi.set(__self__, "query_style", query_style)

    @property
    @pulumi.getter(name="queryId")
    def query_id(self) -> str:
        """
        The ID of the Query to run.
        """
        return pulumi.get(self, "query_id")

    @property
    @pulumi.getter
    def caption(self) -> Optional[str]:
        """
        A description of the query that will be displayed on the board. Supports markdown.
        """
        return pulumi.get(self, "caption")

    @property
    @pulumi.getter
    def dataset(self) -> Optional[str]:
        """
        The dataset this query is associated with.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter(name="graphSettings")
    def graph_settings(self) -> Optional['outputs.BoardQueryGraphSettings']:
        """
        A map of boolean toggles to manages the settings for this query's graph on the board.
        If a value is unspecified, it is assumed to be false.
        Currently supported toggles are:
        * `hide_markers`
        * `log_scale`
        * `omit_missing_values`
        * `stacked_graphs`
        * `utc_xaxis`
        """
        return pulumi.get(self, "graph_settings")

    @property
    @pulumi.getter(name="queryAnnotationId")
    def query_annotation_id(self) -> Optional[str]:
        """
        The ID of the Query Annotation to associate with this query.
        """
        return pulumi.get(self, "query_annotation_id")

    @property
    @pulumi.getter(name="queryStyle")
    def query_style(self) -> Optional[str]:
        """
        How the query should be displayed within the board, either `graph` (the default), `table` or `combo`.
        """
        return pulumi.get(self, "query_style")


@pulumi.output_type
class BoardQueryGraphSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hideMarkers":
            suggest = "hide_markers"
        elif key == "logScale":
            suggest = "log_scale"
        elif key == "omitMissingValues":
            suggest = "omit_missing_values"
        elif key == "stackedGraphs":
            suggest = "stacked_graphs"
        elif key == "utcXaxis":
            suggest = "utc_xaxis"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BoardQueryGraphSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BoardQueryGraphSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BoardQueryGraphSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hide_markers: Optional[bool] = None,
                 log_scale: Optional[bool] = None,
                 omit_missing_values: Optional[bool] = None,
                 stacked_graphs: Optional[bool] = None,
                 utc_xaxis: Optional[bool] = None):
        if hide_markers is not None:
            pulumi.set(__self__, "hide_markers", hide_markers)
        if log_scale is not None:
            pulumi.set(__self__, "log_scale", log_scale)
        if omit_missing_values is not None:
            pulumi.set(__self__, "omit_missing_values", omit_missing_values)
        if stacked_graphs is not None:
            pulumi.set(__self__, "stacked_graphs", stacked_graphs)
        if utc_xaxis is not None:
            pulumi.set(__self__, "utc_xaxis", utc_xaxis)

    @property
    @pulumi.getter(name="hideMarkers")
    def hide_markers(self) -> Optional[bool]:
        return pulumi.get(self, "hide_markers")

    @property
    @pulumi.getter(name="logScale")
    def log_scale(self) -> Optional[bool]:
        return pulumi.get(self, "log_scale")

    @property
    @pulumi.getter(name="omitMissingValues")
    def omit_missing_values(self) -> Optional[bool]:
        return pulumi.get(self, "omit_missing_values")

    @property
    @pulumi.getter(name="stackedGraphs")
    def stacked_graphs(self) -> Optional[bool]:
        return pulumi.get(self, "stacked_graphs")

    @property
    @pulumi.getter(name="utcXaxis")
    def utc_xaxis(self) -> Optional[bool]:
        return pulumi.get(self, "utc_xaxis")


@pulumi.output_type
class BurnAlertRecipient(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notificationDetails":
            suggest = "notification_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BurnAlertRecipient. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BurnAlertRecipient.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BurnAlertRecipient.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[str] = None,
                 notification_details: Optional['outputs.BurnAlertRecipientNotificationDetails'] = None,
                 target: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str id: The ID of an already existing recipient. Should not be used in combination with `type` and `target`.
        :param 'BurnAlertRecipientNotificationDetailsArgs' notification_details: a block of additional details to send along with the notification. The only supported option currently is `pagerduty_severity` which has a default value of `critical` but can be set to one of `info`, `warning`, `error`, or `critical` and must be used in combination with a PagerDuty recipient.
        :param str target: Target of the recipient, this has another meaning depending on the type of recipient (see the table below). Should not be used in combination with `id`.
        :param str type: The type of the recipient, allowed types are `email`, `pagerduty`, `slack` and `webhook`. Should not be used in combination with `id`.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if notification_details is not None:
            pulumi.set(__self__, "notification_details", notification_details)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of an already existing recipient. Should not be used in combination with `type` and `target`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="notificationDetails")
    def notification_details(self) -> Optional['outputs.BurnAlertRecipientNotificationDetails']:
        """
        a block of additional details to send along with the notification. The only supported option currently is `pagerduty_severity` which has a default value of `critical` but can be set to one of `info`, `warning`, `error`, or `critical` and must be used in combination with a PagerDuty recipient.
        """
        return pulumi.get(self, "notification_details")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        Target of the recipient, this has another meaning depending on the type of recipient (see the table below). Should not be used in combination with `id`.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the recipient, allowed types are `email`, `pagerduty`, `slack` and `webhook`. Should not be used in combination with `id`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class BurnAlertRecipientNotificationDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pagerdutySeverity":
            suggest = "pagerduty_severity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BurnAlertRecipientNotificationDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BurnAlertRecipientNotificationDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BurnAlertRecipientNotificationDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pagerduty_severity: str):
        pulumi.set(__self__, "pagerduty_severity", pagerduty_severity)

    @property
    @pulumi.getter(name="pagerdutySeverity")
    def pagerduty_severity(self) -> str:
        return pulumi.get(self, "pagerduty_severity")


@pulumi.output_type
class GetQuerySpecificationCalculationResult(dict):
    def __init__(__self__, *,
                 op: str,
                 column: Optional[str] = None):
        """
        :param str op: The operator to apply, see the supported list of calculation operators at [Calculation Operators](https://docs.honeycomb.io/api/query-specification/#calculation-operators).
        :param str column: The column to apply the operator to, not needed with `COUNT` or `CONCURRENCY`.
        """
        pulumi.set(__self__, "op", op)
        if column is not None:
            pulumi.set(__self__, "column", column)

    @property
    @pulumi.getter
    def op(self) -> str:
        """
        The operator to apply, see the supported list of calculation operators at [Calculation Operators](https://docs.honeycomb.io/api/query-specification/#calculation-operators).
        """
        return pulumi.get(self, "op")

    @property
    @pulumi.getter
    def column(self) -> Optional[str]:
        """
        The column to apply the operator to, not needed with `COUNT` or `CONCURRENCY`.
        """
        return pulumi.get(self, "column")


@pulumi.output_type
class GetQuerySpecificationFilterResult(dict):
    def __init__(__self__, *,
                 column: str,
                 op: str,
                 value: Optional[str] = None,
                 value_boolean: Optional[bool] = None,
                 value_float: Optional[float] = None,
                 value_integer: Optional[int] = None,
                 value_string: Optional[str] = None):
        """
        :param str column: The column to apply the filter to.
        :param str op: The operator to apply, see the supported list of filter operators at [Filter Operators](https://docs.honeycomb.io/api/query-specification/#filter-operators). Not all operators require a value.
        :param str value: The value used for the filter. Not needed if op is `exists`, `not-exists`, `in` or `not-in`. Mutually exclusive with the other `value_*` options.
        :param bool value_boolean: Deprecated: use 'value' instead. The value used for the filter when the column is a boolean. Mutually exclusive with `value` and the other `value_*` options.
        :param float value_float: Deprecated: use 'value' instead. The value used for the filter when the column is a float. Mutually exclusive with `value` and the other `value_*` options.
        :param int value_integer: Deprecated: use 'value' instead. The value used for the filter when the column is an integer. Mutually exclusive with `value` and the other `value_*` options.
        :param str value_string: Deprecated: use 'value' instead. The value used for the filter when the column is a string. Mutually exclusive with `value` and the other `value_*` options.
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "op", op)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_boolean is not None:
            pulumi.set(__self__, "value_boolean", value_boolean)
        if value_float is not None:
            pulumi.set(__self__, "value_float", value_float)
        if value_integer is not None:
            pulumi.set(__self__, "value_integer", value_integer)
        if value_string is not None:
            pulumi.set(__self__, "value_string", value_string)

    @property
    @pulumi.getter
    def column(self) -> str:
        """
        The column to apply the filter to.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter
    def op(self) -> str:
        """
        The operator to apply, see the supported list of filter operators at [Filter Operators](https://docs.honeycomb.io/api/query-specification/#filter-operators). Not all operators require a value.
        """
        return pulumi.get(self, "op")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value used for the filter. Not needed if op is `exists`, `not-exists`, `in` or `not-in`. Mutually exclusive with the other `value_*` options.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueBoolean")
    def value_boolean(self) -> Optional[bool]:
        """
        Deprecated: use 'value' instead. The value used for the filter when the column is a boolean. Mutually exclusive with `value` and the other `value_*` options.
        """
        return pulumi.get(self, "value_boolean")

    @property
    @pulumi.getter(name="valueFloat")
    def value_float(self) -> Optional[float]:
        """
        Deprecated: use 'value' instead. The value used for the filter when the column is a float. Mutually exclusive with `value` and the other `value_*` options.
        """
        return pulumi.get(self, "value_float")

    @property
    @pulumi.getter(name="valueInteger")
    def value_integer(self) -> Optional[int]:
        """
        Deprecated: use 'value' instead. The value used for the filter when the column is an integer. Mutually exclusive with `value` and the other `value_*` options.
        """
        return pulumi.get(self, "value_integer")

    @property
    @pulumi.getter(name="valueString")
    def value_string(self) -> Optional[str]:
        """
        Deprecated: use 'value' instead. The value used for the filter when the column is a string. Mutually exclusive with `value` and the other `value_*` options.
        """
        return pulumi.get(self, "value_string")


@pulumi.output_type
class GetQuerySpecificationHavingResult(dict):
    def __init__(__self__, *,
                 calculate_op: str,
                 op: str,
                 value: float,
                 column: Optional[str] = None):
        """
        :param str calculate_op: The calculation operator to apply, supports all of the [Calculation Operators](https://docs.honeycomb.io/api/query-specification/#calculation-operators) with the exception of `HEATMAP`.
        :param str op: The operator to apply to filter the query results. One of `=`, `!=`, `>`, `>=`, `<`, or `<=`.
        :param float value: The value used with `op`. Currently assumed to be a number.
        :param str column: The column to apply the `calculate_op` to, not needed with `COUNT` or `CONCURRENCY`.
        """
        pulumi.set(__self__, "calculate_op", calculate_op)
        pulumi.set(__self__, "op", op)
        pulumi.set(__self__, "value", value)
        if column is not None:
            pulumi.set(__self__, "column", column)

    @property
    @pulumi.getter(name="calculateOp")
    def calculate_op(self) -> str:
        """
        The calculation operator to apply, supports all of the [Calculation Operators](https://docs.honeycomb.io/api/query-specification/#calculation-operators) with the exception of `HEATMAP`.
        """
        return pulumi.get(self, "calculate_op")

    @property
    @pulumi.getter
    def op(self) -> str:
        """
        The operator to apply to filter the query results. One of `=`, `!=`, `>`, `>=`, `<`, or `<=`.
        """
        return pulumi.get(self, "op")

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        The value used with `op`. Currently assumed to be a number.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def column(self) -> Optional[str]:
        """
        The column to apply the `calculate_op` to, not needed with `COUNT` or `CONCURRENCY`.
        """
        return pulumi.get(self, "column")


@pulumi.output_type
class GetQuerySpecificationOrderResult(dict):
    def __init__(__self__, *,
                 column: Optional[str] = None,
                 op: Optional[str] = None,
                 order: Optional[str] = None):
        """
        :param str column: Either a column present in `breakdown` or a column to `op` applies to.
        :param str op: The calculation operator to apply, see the supported list of calculation operators at [Calculation Operators](https://docs.honeycomb.io/api/query-specification/#calculation-operators).
        :param str order: The sort direction, if set must be `ascending` or `descending`.
        """
        if column is not None:
            pulumi.set(__self__, "column", column)
        if op is not None:
            pulumi.set(__self__, "op", op)
        if order is not None:
            pulumi.set(__self__, "order", order)

    @property
    @pulumi.getter
    def column(self) -> Optional[str]:
        """
        Either a column present in `breakdown` or a column to `op` applies to.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter
    def op(self) -> Optional[str]:
        """
        The calculation operator to apply, see the supported list of calculation operators at [Calculation Operators](https://docs.honeycomb.io/api/query-specification/#calculation-operators).
        """
        return pulumi.get(self, "op")

    @property
    @pulumi.getter
    def order(self) -> Optional[str]:
        """
        The sort direction, if set must be `ascending` or `descending`.
        """
        return pulumi.get(self, "order")


@pulumi.output_type
class GetRecipientDetailFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: Optional[str] = None,
                 value_regex: Optional[str] = None):
        """
        :param str name: The name of the detail field to filter by. Allowed values are `address`, `channel`, `name`, `integration_name`, and `url`.
        :param str value: The value of the detail field to match on.
        :param str value_regex: A regular expression string to apply to the value of the detail field to match on.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_regex is not None:
            pulumi.set(__self__, "value_regex", value_regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the detail field to filter by. Allowed values are `address`, `channel`, `name`, `integration_name`, and `url`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the detail field to match on.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueRegex")
    def value_regex(self) -> Optional[str]:
        """
        A regular expression string to apply to the value of the detail field to match on.
        """
        return pulumi.get(self, "value_regex")


@pulumi.output_type
class GetRecipientsDetailFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: Optional[str] = None,
                 value_regex: Optional[str] = None):
        """
        :param str name: The name of the detail field to filter by. Allowed values are `address`, `channel`, `name`, `integration_name`, and `url`.
        :param str value: The value of the detail field to match on.
        :param str value_regex: A regular expression string to apply to the value of the detail field to match on.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_regex is not None:
            pulumi.set(__self__, "value_regex", value_regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the detail field to filter by. Allowed values are `address`, `channel`, `name`, `integration_name`, and `url`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the detail field to match on.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueRegex")
    def value_regex(self) -> Optional[str]:
        """
        A regular expression string to apply to the value of the detail field to match on.
        """
        return pulumi.get(self, "value_regex")


@pulumi.output_type
class TriggerRecipient(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notificationDetails":
            suggest = "notification_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerRecipient. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerRecipient.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerRecipient.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[str] = None,
                 notification_details: Optional['outputs.TriggerRecipientNotificationDetails'] = None,
                 target: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str id: The ID of an already existing recipient. Should not be used in combination with `type` and `target`.
        :param 'TriggerRecipientNotificationDetailsArgs' notification_details: a block of additional details to send along with the notification. The only supported option currently is `pagerduty_severity` which has a default value of `critical` but can be set to one of `info`, `warning`, `error`, or `critical` and must be used in combination with a PagerDuty recipient.
        :param str target: Target of the trigger recipient, this has another meaning depending on the type of recipient (see the table below). Should not be used in combination with `id`.
        :param str type: The type of the trigger recipient, allowed types are `email`, `marker`, `pagerduty`, `slack` and `webhook`. Should not be used in combination with `id`.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if notification_details is not None:
            pulumi.set(__self__, "notification_details", notification_details)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of an already existing recipient. Should not be used in combination with `type` and `target`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="notificationDetails")
    def notification_details(self) -> Optional['outputs.TriggerRecipientNotificationDetails']:
        """
        a block of additional details to send along with the notification. The only supported option currently is `pagerduty_severity` which has a default value of `critical` but can be set to one of `info`, `warning`, `error`, or `critical` and must be used in combination with a PagerDuty recipient.
        """
        return pulumi.get(self, "notification_details")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        Target of the trigger recipient, this has another meaning depending on the type of recipient (see the table below). Should not be used in combination with `id`.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the trigger recipient, allowed types are `email`, `marker`, `pagerduty`, `slack` and `webhook`. Should not be used in combination with `id`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class TriggerRecipientNotificationDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pagerdutySeverity":
            suggest = "pagerduty_severity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerRecipientNotificationDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerRecipientNotificationDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerRecipientNotificationDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pagerduty_severity: str):
        pulumi.set(__self__, "pagerduty_severity", pagerduty_severity)

    @property
    @pulumi.getter(name="pagerdutySeverity")
    def pagerduty_severity(self) -> str:
        return pulumi.get(self, "pagerduty_severity")


@pulumi.output_type
class TriggerThreshold(dict):
    def __init__(__self__, *,
                 op: str,
                 value: float):
        """
        :param str op: The operator to apply, allowed threshold operators are `>`, `>=`, `<`, and `<=`.
        :param float value: The value to be used with the operator.
        """
        pulumi.set(__self__, "op", op)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def op(self) -> str:
        """
        The operator to apply, allowed threshold operators are `>`, `>=`, `<`, and `<=`.
        """
        return pulumi.get(self, "op")

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        The value to be used with the operator.
        """
        return pulumi.get(self, "value")


