# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRecipientResult',
    'AwaitableGetRecipientResult',
    'get_recipient',
    'get_recipient_output',
]

@pulumi.output_type
class GetRecipientResult:
    """
    A collection of values returned by GetRecipient.
    """
    def __init__(__self__, address=None, channel=None, dataset=None, detail_filter=None, id=None, integration_key=None, integration_name=None, name=None, secret=None, target=None, type=None, url=None):
        if address and not isinstance(address, str):
            raise TypeError("Expected argument 'address' to be a str")
        pulumi.set(__self__, "address", address)
        if channel and not isinstance(channel, str):
            raise TypeError("Expected argument 'channel' to be a str")
        pulumi.set(__self__, "channel", channel)
        if dataset and not isinstance(dataset, str):
            raise TypeError("Expected argument 'dataset' to be a str")
        if dataset is not None:
            warnings.warn("""Recpients are now a Team-level construct. The provided 'dataset' value is being ignored and should be removed.""", DeprecationWarning)
            pulumi.log.warn("""dataset is deprecated: Recpients are now a Team-level construct. The provided 'dataset' value is being ignored and should be removed.""")

        pulumi.set(__self__, "dataset", dataset)
        if detail_filter and not isinstance(detail_filter, dict):
            raise TypeError("Expected argument 'detail_filter' to be a dict")
        pulumi.set(__self__, "detail_filter", detail_filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if integration_key and not isinstance(integration_key, str):
            raise TypeError("Expected argument 'integration_key' to be a str")
        pulumi.set(__self__, "integration_key", integration_key)
        if integration_name and not isinstance(integration_name, str):
            raise TypeError("Expected argument 'integration_name' to be a str")
        pulumi.set(__self__, "integration_name", integration_name)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if secret and not isinstance(secret, str):
            raise TypeError("Expected argument 'secret' to be a str")
        pulumi.set(__self__, "secret", secret)
        if target and not isinstance(target, str):
            raise TypeError("Expected argument 'target' to be a str")
        if target is not None:
            warnings.warn("""Use of 'target' has been replaced by 'detail_filter'.""", DeprecationWarning)
            pulumi.log.warn("""target is deprecated: Use of 'target' has been replaced by 'detail_filter'.""")

        pulumi.set(__self__, "target", target)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The email recipient's address -- if of type `email`.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def channel(self) -> str:
        """
        The Slack recipient's channel -- if of type `slack`.
        """
        return pulumi.get(self, "channel")

    @property
    @pulumi.getter
    def dataset(self) -> Optional[str]:
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter(name="detailFilter")
    def detail_filter(self) -> Optional['outputs.GetRecipientDetailFilterResult']:
        return pulumi.get(self, "detail_filter")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="integrationKey")
    def integration_key(self) -> str:
        """
        (Sensitive) The PagerDuty recipient's integration key -- if of type `pagerduty`.
        """
        return pulumi.get(self, "integration_key")

    @property
    @pulumi.getter(name="integrationName")
    def integration_name(self) -> str:
        """
        The PagerDuty recipient's inregration name -- if of type `pagerduty`.
        """
        return pulumi.get(self, "integration_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The webhook recipient's name -- if of type `webhook`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        (Sensitive) The webhook recipient's secret -- if of type `webhook`.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The webhook recipient's URL - if of type `webhook`.
        """
        return pulumi.get(self, "url")


class AwaitableGetRecipientResult(GetRecipientResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRecipientResult(
            address=self.address,
            channel=self.channel,
            dataset=self.dataset,
            detail_filter=self.detail_filter,
            id=self.id,
            integration_key=self.integration_key,
            integration_name=self.integration_name,
            name=self.name,
            secret=self.secret,
            target=self.target,
            type=self.type,
            url=self.url)


def get_recipient(dataset: Optional[str] = None,
                  detail_filter: Optional[pulumi.InputType['GetRecipientDetailFilterArgs']] = None,
                  target: Optional[str] = None,
                  type: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRecipientResult:
    """
    Use this data source to access information about an existing resource.

    :param str dataset: Deprecated: recpients are now a Team-level construct. Any provided value will be ignored.
    :param pulumi.InputType['GetRecipientDetailFilterArgs'] detail_filter: a block to further filter recipients as described below.
    :param str target: Deprecated: use `detail_filter` instead. The target of the recipient, this has another meaning depending on the type of recipient (see the table below).
    :param str type: The type of recipient, allowed types are `email`, `pagerduty`, `slack` and `webhook`.
    """
    __args__ = dict()
    __args__['dataset'] = dataset
    __args__['detailFilter'] = detail_filter
    __args__['target'] = target
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('honeycomb:index/getRecipient:GetRecipient', __args__, opts=opts, typ=GetRecipientResult).value

    return AwaitableGetRecipientResult(
        address=__ret__.address,
        channel=__ret__.channel,
        dataset=__ret__.dataset,
        detail_filter=__ret__.detail_filter,
        id=__ret__.id,
        integration_key=__ret__.integration_key,
        integration_name=__ret__.integration_name,
        name=__ret__.name,
        secret=__ret__.secret,
        target=__ret__.target,
        type=__ret__.type,
        url=__ret__.url)


@_utilities.lift_output_func(get_recipient)
def get_recipient_output(dataset: Optional[pulumi.Input[Optional[str]]] = None,
                         detail_filter: Optional[pulumi.Input[Optional[pulumi.InputType['GetRecipientDetailFilterArgs']]]] = None,
                         target: Optional[pulumi.Input[Optional[str]]] = None,
                         type: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRecipientResult]:
    """
    Use this data source to access information about an existing resource.

    :param str dataset: Deprecated: recpients are now a Team-level construct. Any provided value will be ignored.
    :param pulumi.InputType['GetRecipientDetailFilterArgs'] detail_filter: a block to further filter recipients as described below.
    :param str target: Deprecated: use `detail_filter` instead. The target of the recipient, this has another meaning depending on the type of recipient (see the table below).
    :param str type: The type of recipient, allowed types are `email`, `pagerduty`, `slack` and `webhook`.
    """
    ...
