window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = {"version": "0.9.5", "fields": ["qualname", "fullname", "annotation", "default_value", "signature", "bases", "doc"], "ref": "fullname", "documentStore": {"docs": {"csi_images": {"fullname": "csi_images", "modulename": "csi_images", "kind": "module", "doc": "<h1 id=\"csi_images-image-and-data-utilities-for-csi-cancer\">csi_images: image and data utilities for CSI-Cancer</h1>\n\n<p><a href=\"https://pypi.org/project/csi-images/\"><img src=\"https://img.shields.io/pypi/v/csi-images\" alt=\"PyPI version\" /></a>\n<a href=\"https://csi-cancer.github.io/csi_images/coverage\"><img src=\"data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSI5OSIgaGVpZ2h0PSIyMCI+CiAgICA8bGluZWFyR3JhZGllbnQgaWQ9ImIiIHgyPSIwIiB5Mj0iMTAwJSI+CiAgICAgICAgPHN0b3Agb2Zmc2V0PSIwIiBzdG9wLWNvbG9yPSIjYmJiIiBzdG9wLW9wYWNpdHk9Ii4xIi8+CiAgICAgICAgPHN0b3Agb2Zmc2V0PSIxIiBzdG9wLW9wYWNpdHk9Ii4xIi8+CiAgICA8L2xpbmVhckdyYWRpZW50PgogICAgPG1hc2sgaWQ9ImEiPgogICAgICAgIDxyZWN0IHdpZHRoPSI5OSIgaGVpZ2h0PSIyMCIgcng9IjMiIGZpbGw9IiNmZmYiLz4KICAgIDwvbWFzaz4KICAgIDxnIG1hc2s9InVybCgjYSkiPgogICAgICAgIDxwYXRoIGZpbGw9IiM1NTUiIGQ9Ik0wIDBoNjN2MjBIMHoiLz4KICAgICAgICA8cGF0aCBmaWxsPSIjZGZiMzE3IiBkPSJNNjMgMGgzNnYyMEg2M3oiLz4KICAgICAgICA8cGF0aCBmaWxsPSJ1cmwoI2IpIiBkPSJNMCAwaDk5djIwSDB6Ii8+CiAgICA8L2c+CiAgICA8ZyBmaWxsPSIjZmZmIiB0ZXh0LWFuY2hvcj0ibWlkZGxlIiBmb250LWZhbWlseT0iRGVqYVZ1IFNhbnMsVmVyZGFuYSxHZW5ldmEsc2Fucy1zZXJpZiIgZm9udC1zaXplPSIxMSI+CiAgICAgICAgPHRleHQgeD0iMzEuNSIgeT0iMTUiIGZpbGw9IiMwMTAxMDEiIGZpbGwtb3BhY2l0eT0iLjMiPmNvdmVyYWdlPC90ZXh0PgogICAgICAgIDx0ZXh0IHg9IjMxLjUiIHk9IjE0Ij5jb3ZlcmFnZTwvdGV4dD4KICAgICAgICA8dGV4dCB4PSI4MCIgeT0iMTUiIGZpbGw9IiMwMTAxMDEiIGZpbGwtb3BhY2l0eT0iLjMiPjYyJTwvdGV4dD4KICAgICAgICA8dGV4dCB4PSI4MCIgeT0iMTQiPjYyJTwvdGV4dD4KICAgIDwvZz4KPC9zdmc+Cg==\" alt=\"Coverage Badge\" /></a></p>\n\n<p>This package is a library for interacting with data, mainly from immunoflourescent \nmicroscopy, such as cells and the images thereof. \nWhile much of the functionality is specific to the CSI-Cancer organization, some of the\nfunctionality and structure may be beneficial for the broader community.\nOther packages in the CSI-Cancer organization may depend on this package.</p>\n\n<p>Install with:</p>\n\n<pre><code>pip install csi_images\n</code></pre>\n\n<p>or</p>\n\n<pre><code>pip install csi_images[imageio,rds,dev,all]\n</code></pre>\n\n<p>The base version of the package includes only core data structures and manipulations.</p>\n\n<p>Optional dependencies include:</p>\n\n<ul>\n<li><code>imageio</code>: for reading and writing images, include .czi files.</li>\n<li><code>rds</code>: for reading and writing RDS files, such as OCULAR outputs.</li>\n<li><code>dev</code>: for development dependencies, including documentation, tests, building, etc.</li>\n<li><code>all</code>: for all optional dependencies.</li>\n</ul>\n\n<h2 id=\"structure\">Structure</h2>\n\n<p>This package contains these modules:</p>\n\n<ol>\n<li><code>csi_scans.py</code>: a module for interacting with scan-level files, such as .czi files.\n<ul>\n<li><code>Scan</code>: a class that contains all of the scan metadata. for interacting with scan\nmetadata, such as the slide ID, the path to the scan, and scan parameters.\nRecommend importing via <code>from csi_images.csi_scans import Scan</code></li>\n</ul></li>\n<li><code>csi_tiles.py</code>: a module for interacting with tiles, which have a particular (x, y)\nposition in the scan. Tiles have several frames taken at the same position.\n<ul>\n<li><code>Tile</code>: a class for containing a tile's positional data. Imports <code>csi_scans.py</code>.\nThis class unifies multiple scanners' tile positioning to convert between index\nand (x, y). Recommend importing via <code>from csi_images.csi_tiles import Tile</code></li>\n</ul></li>\n<li><code>csi_frames.py</code>: a module for interacting with frames, which are individual images.\nImports <code>csi_scans.py</code> and <code>csi_tiles.py</code>. Recommend importing via\n<code>from csi_images.csi_frames import Frame</code>\n<ul>\n<li><code>Frame</code>: a class for containing a frame's metadata. Each frame in a tile has a\ndifferent channel, or light spectrum. The frame <strong>only contains metadata</strong>, but\nenables gathering of the image data through the <code>get_image()</code> method. For a list\nof frames, use <code>get_frames()</code>. For all frames in a scan, use <code>get_all_frames()</code>.\nFor many frames, use <code>[frame.get_image() for frame in frames]</code>. Recommend\nimporting via <code>from csi_images.csi_frames import Frame</code></li>\n</ul></li>\n<li><code>csi_events.py</code>: a module for interacting with individual events. Imports\n<code>csi_scans.py</code>, <code>csi_tiles.py</code>, and <code>csi_frames.py</code>.\n<ul>\n<li><code>Event</code>: a class for containing a single event's metadata and feature data. Key\nmetadata (scan, tile, x, y) is required; the others are optional and flexible.\nContains a convenience function for getting crops of an event, as well as\nfunctions for determining the position of the event in the slide coordinate frame.\nRecommend importing via <code>from csi_images.csi_events import Event</code></li>\n<li><code>EventArray</code>: a class for containing a list of events, holding their data in\npandas dataframes. Contains functions converting back and forth from <code>Event</code>s and\nfiles. Recommend importing via <code>from csi_images.csi_events import EventArray</code></li>\n</ul></li>\n</ol>\n\n<h3 id=\"planned-features\">Planned Features</h3>\n\n<ul>\n<li><code>Event.montage()</code>: Combines crops for an event into side-by-side montages.</li>\n</ul>\n\n<h2 id=\"documentation\">Documentation</h2>\n\n<p>For more detailed documentation, check\n<a href=\"https://csi-cancer.github.io/csi_images/\">the API docs</a>.</p>\n\n<p>Alternatively, once you have cloned the repository, you\ncan open up <code>docs/index.html</code> in your browser.</p>\n\n<p>To regenerate the documentation, ensure that you\nhave <a href=\"#installation\">installed the package</a> and then run:</p>\n\n<pre><code>make_docs_for_csi_images\n</code></pre>\n\n<h2 id=\"development-installation\">Development Installation</h2>\n\n<ol>\n<li>Activate your <code>conda</code> (<code>conda activate yourenv</code>) or\n<code>venv</code> (<code>source path/to/your/venv/bin/activate</code>) environment first.</li>\n<li>Clone <code>csi_images</code> and install:</li>\n</ol>\n\n<pre><code>cd ~/path/to/your/repositories\ngit clone git@github.com:CSI-Cancer/csi_images.git\npip install ./csi_images\n</code></pre>\n\n<p>Alternatively, you can \"editable\" install the package, which will allow you to make\nchanges to the package and have them reflected in your environment without reinstalling:</p>\n\n<pre><code>pip install -e ./csi_images\n</code></pre>\n\n<p>This will add symbolic links to your <code>site-packages</code> directory instead of copying the\npackage files over.</p>\n"}, "csi_images.csi_events": {"fullname": "csi_images.csi_events", "modulename": "csi_images.csi_events", "kind": "module", "doc": "<p>Contains the Event class, which represents a single event in a scan.\nThe Event class optionally holds metadata and features. Lists of events with\nsimilar metadata or features can be combined into DataFrames for analysis.</p>\n\n<p>The Event class holds the position of the event in the frame, which can be converted\nto the position in the scanner or slide coordinate positions. See the\ncsi_utils.csi_scans documentation page for more information on the coordinate systems.</p>\n"}, "csi_images.csi_events.Event": {"fullname": "csi_images.csi_events.Event", "modulename": "csi_images.csi_events", "qualname": "Event", "kind": "class", "doc": "<p>A class that represents a single event in a scan, making it easy to evaluate\nsingular events. Required metadata is exposed as attributes, and optional\nmetadata and features are stored as DataFrames.</p>\n"}, "csi_images.csi_events.Event.__init__": {"fullname": "csi_images.csi_events.Event.__init__", "modulename": "csi_images.csi_events", "qualname": "Event.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">scan</span><span class=\"p\">:</span> <span class=\"n\">csi_images</span><span class=\"o\">.</span><span class=\"n\">csi_scans</span><span class=\"o\">.</span><span class=\"n\">Scan</span>,</span><span class=\"param\">\t<span class=\"n\">tile</span><span class=\"p\">:</span> <span class=\"n\">csi_images</span><span class=\"o\">.</span><span class=\"n\">csi_tiles</span><span class=\"o\">.</span><span class=\"n\">Tile</span>,</span><span class=\"param\">\t<span class=\"n\">x</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">y</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">12</span>,</span><span class=\"param\">\t<span class=\"n\">metadata</span><span class=\"p\">:</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">series</span><span class=\"o\">.</span><span class=\"n\">Series</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">series</span><span class=\"o\">.</span><span class=\"n\">Series</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"fullname": "csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM", "modulename": "csi_images.csi_events", "qualname": "Event.SCAN_TO_SLIDE_TRANSFORM", "kind": "variable", "doc": "<p>Homogeneous transformation matrices for converting between scanner and slide\ncoordinates. The matrices are 3x3, with the final column representing the\ntranslation in micrometers (um). For more information, see \n<a href=\"https://en.wikipedia.org/wiki/Transformation_matrix#Affine_transformations\">affine transformations</a>.</p>\n\n<p>Transformations are nominal, and accuracy is not guaranteed; this is due to \nimperfections in slides and alignment in the scanners. Units are in micrometers.</p>\n", "default_value": "{&lt;Type.AXIOSCAN7: &#x27;axioscan7&#x27;&gt;: array([[    1,     0, 75000],\n       [    0,     1,     0],\n       [    0,     0,     1]]), &lt;Type.BZSCANNER: &#x27;bzscanner&#x27;&gt;: array([[    0,    -1, 75000],\n       [   -1,     0, 25000],\n       [    0,     0,     1]])}"}, "csi_images.csi_events.Event.scan": {"fullname": "csi_images.csi_events.Event.scan", "modulename": "csi_images.csi_events", "qualname": "Event.scan", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_events.Event.tile": {"fullname": "csi_images.csi_events.Event.tile", "modulename": "csi_images.csi_events", "qualname": "Event.tile", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_events.Event.x": {"fullname": "csi_images.csi_events.Event.x", "modulename": "csi_images.csi_events", "qualname": "Event.x", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_events.Event.y": {"fullname": "csi_images.csi_events.Event.y", "modulename": "csi_images.csi_events", "qualname": "Event.y", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_events.Event.size": {"fullname": "csi_images.csi_events.Event.size", "modulename": "csi_images.csi_events", "qualname": "Event.size", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_events.Event.metadata": {"fullname": "csi_images.csi_events.Event.metadata", "modulename": "csi_images.csi_events", "qualname": "Event.metadata", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_events.Event.features": {"fullname": "csi_images.csi_events.Event.features", "modulename": "csi_images.csi_events", "qualname": "Event.features", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_events.Event.get_scan_position": {"fullname": "csi_images.csi_events.Event.get_scan_position", "modulename": "csi_images.csi_events", "qualname": "Event.get_scan_position", "kind": "function", "doc": "<p>Get the position of the event in the scanner's coordinate frame.</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>the scan position of the event in micrometers (um).</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_events.Event.get_slide_position": {"fullname": "csi_images.csi_events.Event.get_slide_position", "modulename": "csi_images.csi_events", "qualname": "Event.get_slide_position", "kind": "function", "doc": "<p>Get the slide position of the event in micrometers (um).</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>the slide position of the event.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_events.Event.crop_images": {"fullname": "csi_images.csi_events.Event.crop_images", "modulename": "csi_images.csi_events", "qualname": "Event.crop_images", "kind": "function", "doc": "<p>Get the event crops from the frame images. Called \"get\" because it does not\nneed to extract anything; it is very quick for extracting multiple events from\nthe same tile.\nUse this if you're interested in many events.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>images</strong>:  the frame images.</li>\n<li><strong>crop_size</strong>:  the square size of the image crop to get for this event.</li>\n<li><strong>in_pixels</strong>:  whether the crop size is in pixels or micrometers. Defaults to pixels.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>image_size x image_size crops of the event in the provided frames. If\n  the event is too close to the edge, the crop will be smaller and not centered.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">images</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">crop_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span>,</span><span class=\"param\">\t<span class=\"n\">in_pixels</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_events.Event.extract_images": {"fullname": "csi_images.csi_events.Event.extract_images", "modulename": "csi_images.csi_events", "qualname": "Event.extract_images", "kind": "function", "doc": "<p>Extract the images from the scan and tile, reading from the file. Called\n\"extract\" because it must read and extract the images from file, which is slow.\nUse this if you're interested in only a few events, as it is inefficient when\nreading multiple events from the same tile.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>crop_size</strong>:  the square size of the image crop to get for this event.</li>\n<li><strong>in_pixels</strong>:  whether the crop size is in pixels or micrometers. Defaults to pixels.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>a list of cropped images from the scan in the order of the channels.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">crop_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">100</span>,</span><span class=\"param\">\t<span class=\"n\">in_pixels</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_events.Event.extract_images_for_list": {"fullname": "csi_images.csi_events.Event.extract_images_for_list", "modulename": "csi_images.csi_events", "qualname": "Event.extract_images_for_list", "kind": "function", "doc": "<p>Get the images for a list of events, ensuring that there is no wasteful reading\nof the same tile multiple times. This function is more efficient than calling\nextract_event_images for each event.\nTODO: test this function</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>events</strong>:  the events to extract images for.</li>\n<li><strong>crop_size</strong>:  the square size of the image crop to get for this event.\nDefaults to four times the size of the event.</li>\n<li><strong>in_pixels</strong>:  whether the crop size is in pixels or micrometers.\nDefaults to pixels, and is ignored if crop_size is None.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>a list of lists of cropped images for each event.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">events</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Self</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">crop_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">in_pixels</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_events.EventArray": {"fullname": "csi_images.csi_events.EventArray", "modulename": "csi_images.csi_events", "qualname": "EventArray", "kind": "class", "doc": "<p>A class that holds a large number of events' data, making it easy to analyze and\nmanipulate many events at once. A more separated version of the Event class.</p>\n"}, "csi_images.csi_events.EventArray.__init__": {"fullname": "csi_images.csi_events.EventArray.__init__", "modulename": "csi_images.csi_events", "qualname": "EventArray.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">info</span><span class=\"p\">:</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">metadata</span><span class=\"p\">:</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">features</span><span class=\"p\">:</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "csi_images.csi_events.EventArray.INFO_COLUMNS": {"fullname": "csi_images.csi_events.EventArray.INFO_COLUMNS", "modulename": "csi_images.csi_events", "qualname": "EventArray.INFO_COLUMNS", "kind": "variable", "doc": "<p></p>\n", "default_value": "[&#x27;slide_id&#x27;, &#x27;tile&#x27;, &#x27;roi&#x27;, &#x27;x&#x27;, &#x27;y&#x27;, &#x27;size&#x27;]"}, "csi_images.csi_events.EventArray.info": {"fullname": "csi_images.csi_events.EventArray.info", "modulename": "csi_images.csi_events", "qualname": "EventArray.info", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_events.EventArray.metadata": {"fullname": "csi_images.csi_events.EventArray.metadata", "modulename": "csi_images.csi_events", "qualname": "EventArray.metadata", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_events.EventArray.features": {"fullname": "csi_images.csi_events.EventArray.features", "modulename": "csi_images.csi_events", "qualname": "EventArray.features", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_events.EventArray.get_sort_order": {"fullname": "csi_images.csi_events.EventArray.get_sort_order", "modulename": "csi_images.csi_events", "qualname": "EventArray.get_sort_order", "kind": "function", "doc": "<p>Get the sort order for the EventArray by a column in the info, metadata, or features DataFrames.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>by</strong>:  name of the column(s) to sort by.</li>\n<li><strong>ascending</strong>:  whether to sort in ascending order; can be a list to match by</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>the order of the indices to sort by.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">by</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">ascending</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "csi_images.csi_events.EventArray.sort": {"fullname": "csi_images.csi_events.EventArray.sort", "modulename": "csi_images.csi_events", "qualname": "EventArray.sort", "kind": "function", "doc": "<p>Sort the EventArray by column(s) in the info, metadata, or features DataFrames.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>by</strong>:  name of the column(s) to sort by.</li>\n<li><strong>ascending</strong>:  whether to sort in ascending order; can be a list to match by</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>a new, sorted EventArray.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">by</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">ascending</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_events.EventArray.get": {"fullname": "csi_images.csi_events.EventArray.get", "modulename": "csi_images.csi_events", "qualname": "EventArray.get", "kind": "function", "doc": "<p>Get a DataFrame with the specified columns from the EventArray, by value.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>column_names</strong>:  the names of the columns to get.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>a DataFrame with the specified columns.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">column_names</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_events.EventArray.rows": {"fullname": "csi_images.csi_events.EventArray.rows", "modulename": "csi_images.csi_events", "qualname": "EventArray.rows", "kind": "function", "doc": "<p>Get a subset of the EventArray rows based on a boolean or integer index, by value.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>rows</strong>:  the indices to get as a 1D boolean/integer list/array/series</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>a new EventArray with the subset of events.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">rows</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_events.EventArray.copy": {"fullname": "csi_images.csi_events.EventArray.copy", "modulename": "csi_images.csi_events", "qualname": "EventArray.copy", "kind": "function", "doc": "<p>Create a deep copy of the EventArray.</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>a deep copy of the EventArray.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_events.EventArray.add_metadata": {"fullname": "csi_images.csi_events.EventArray.add_metadata", "modulename": "csi_images.csi_events", "qualname": "EventArray.add_metadata", "kind": "function", "doc": "<p>Add metadata to the EventArray. Removes the need to check if metadata is None.\nOverwrites any existing metadata with the same column names as the new metadata.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>new_metadata</strong>:  the metadata to add.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">new_metadata</span><span class=\"p\">:</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">series</span><span class=\"o\">.</span><span class=\"n\">Series</span> <span class=\"o\">|</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_events.EventArray.add_features": {"fullname": "csi_images.csi_events.EventArray.add_features", "modulename": "csi_images.csi_events", "qualname": "EventArray.add_features", "kind": "function", "doc": "<p>Add features to the EventArray. Removes the need to check if features is None.\nOverwrites any existing features with the same column names as the new features.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>new_features</strong>:  the features to add.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">new_features</span><span class=\"p\">:</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">series</span><span class=\"o\">.</span><span class=\"n\">Series</span> <span class=\"o\">|</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_events.EventArray.merge": {"fullname": "csi_images.csi_events.EventArray.merge", "modulename": "csi_images.csi_events", "qualname": "EventArray.merge", "kind": "function", "doc": "<p>Combine EventArrays in a list into a single EventArray.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>events</strong>:  the new list of events.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">events</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Self</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_events.EventArray.to_events": {"fullname": "csi_images.csi_events.EventArray.to_events", "modulename": "csi_images.csi_events", "qualname": "EventArray.to_events", "kind": "function", "doc": "<p>Get the events in the EventArray as a list of events.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>scans</strong>:  the scans that the events belong to, auto-matched by slide_id.\nPass None if you don't care about scan metadata (pass ignore_missing_scans).</li>\n<li><strong>ignore_missing_scans</strong>:  whether to create blank scans for events without scans.</li>\n<li><strong>ignore_metadata</strong>:  whether to ignore metadata or not</li>\n<li><strong>ignore_features</strong>:  whether to ignore features or not</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">scans</span><span class=\"p\">:</span> <span class=\"n\">csi_images</span><span class=\"o\">.</span><span class=\"n\">csi_scans</span><span class=\"o\">.</span><span class=\"n\">Scan</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">csi_images</span><span class=\"o\">.</span><span class=\"n\">csi_scans</span><span class=\"o\">.</span><span class=\"n\">Scan</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">ignore_missing_scans</span><span class=\"o\">=</span><span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">ignore_metadata</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">ignore_features</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">csi_images</span><span class=\"o\">.</span><span class=\"n\">csi_events</span><span class=\"o\">.</span><span class=\"n\">Event</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_events.EventArray.from_events": {"fullname": "csi_images.csi_events.EventArray.from_events", "modulename": "csi_images.csi_events", "qualname": "EventArray.from_events", "kind": "function", "doc": "<p>Set the events in the EventArray to a new list of events.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>events</strong>:  the new list of events.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">events</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">csi_images</span><span class=\"o\">.</span><span class=\"n\">csi_events</span><span class=\"o\">.</span><span class=\"n\">Event</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_events.EventArray.to_dataframe": {"fullname": "csi_images.csi_events.EventArray.to_dataframe", "modulename": "csi_images.csi_events", "qualname": "EventArray.to_dataframe", "kind": "function", "doc": "<p>Convert all the data in the EventArray to a single DataFrame.</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>a DataFrame with all the data in the EventArray.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_events.EventArray.from_dataframe": {"fullname": "csi_images.csi_events.EventArray.from_dataframe", "modulename": "csi_images.csi_events", "qualname": "EventArray.from_dataframe", "kind": "function", "doc": "<p>From a single, special DataFrame, create an EventArray.</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>a DataFrame with all the data in the EventArray.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">df</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_events.EventArray.from_mask": {"fullname": "csi_images.csi_events.EventArray.from_mask", "modulename": "csi_images.csi_events", "qualname": "EventArray.from_mask", "kind": "function", "doc": "<p>Extract events from a mask DataFrame, including metadata and features.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>mask</strong>:  the mask to extract events from.</li>\n<li><strong>slide_id</strong>:  the slide ID the mask is from.</li>\n<li><strong>tile_n</strong>:  the tile number the mask is from.</li>\n<li><strong>n_roi</strong>:  the ROI number the mask is from.</li>\n<li><strong>include_cell_id</strong>:  whether to include the cell_id, or numerical\nmask label, as metadata in the EventArray.</li>\n<li><strong>images</strong>:  the intensity images to extract features from.</li>\n<li><strong>image_labels</strong>:  the labels for the intensity images.</li>\n<li><strong>properties: list of properties to extract in addition to the defaults</strong>: </li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>EventArray corresponding to the mask labels.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">mask</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">slide_id</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">tile_n</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">n_roi</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">include_cell_id</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">images</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">image_labels</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">properties</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_events.EventArray.save_csv": {"fullname": "csi_images.csi_events.EventArray.save_csv", "modulename": "csi_images.csi_events", "qualname": "EventArray.save_csv", "kind": "function", "doc": "<p>Save the events to an CSV file, including metadata and features.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>output_path</strong>: </li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">output_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_events.EventArray.load_csv": {"fullname": "csi_images.csi_events.EventArray.load_csv", "modulename": "csi_images.csi_events", "qualname": "EventArray.load_csv", "kind": "function", "doc": "<p>Load the events from an CSV file, including metadata and features.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>input_path</strong>: </li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">input_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_events.EventArray.save_hdf5": {"fullname": "csi_images.csi_events.EventArray.save_hdf5", "modulename": "csi_images.csi_events", "qualname": "EventArray.save_hdf5", "kind": "function", "doc": "<p>Save the events to an HDF5 file, including metadata and features.\nUses the pandas-provided HDF5 functions for ease, and external compatibility,\nthough these files are slightly harder to view in HDFView or similar.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>output_path</strong>: </li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">output_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_events.EventArray.load_hdf5": {"fullname": "csi_images.csi_events.EventArray.load_hdf5", "modulename": "csi_images.csi_events", "qualname": "EventArray.load_hdf5", "kind": "function", "doc": "<p>Load the events from an HDF5 file, including metadata and features.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>input_path</strong>: </li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">input_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_events.EventArray.save_ocular": {"fullname": "csi_images.csi_events.EventArray.save_ocular", "modulename": "csi_images.csi_events", "qualname": "EventArray.save_ocular", "kind": "function", "doc": "<p>Save the events to an OCULAR file. Relies on the dataframe originating\nfrom an OCULAR file (same columns; duplicate metadata/info).</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>output_path</strong>: </li>\n<li><strong>event_type</strong>: </li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">output_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">event_type</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;cells&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "csi_images.csi_events.EventArray.load_ocular": {"fullname": "csi_images.csi_events.EventArray.load_ocular", "modulename": "csi_images.csi_events", "qualname": "EventArray.load_ocular", "kind": "function", "doc": "<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>input_path</strong>: </li>\n<li><strong>event_type</strong>: </li>\n<li><strong>cell_data_files</strong>: </li>\n<li><strong>others_data_files</strong>: </li>\n<li><strong>atlas_data_files</strong>: </li>\n<li><strong>drop_common_events</strong>: </li>\n<li><strong>log</strong>: </li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">input_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">event_type</span><span class=\"o\">=</span><span class=\"s1\">&#39;cells&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">cell_data_files</span><span class=\"o\">=</span><span class=\"p\">(</span><span class=\"s1\">&#39;rc-final1.rds&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;rc-final2.rds&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;rc-final3.rds&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;rc-final4.rds&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ocular_interesting.rds&#39;</span><span class=\"p\">)</span>,</span><span class=\"param\">\t<span class=\"n\">others_data_files</span><span class=\"o\">=</span><span class=\"p\">(</span><span class=\"s1\">&#39;others-final1.rds&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;others-final2.rds&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;others-final3.rds&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;others-final4.rds&#39;</span><span class=\"p\">)</span>,</span><span class=\"param\">\t<span class=\"n\">atlas_data_files</span><span class=\"o\">=</span><span class=\"p\">(</span><span class=\"s1\">&#39;ocular_interesting.rds&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ocular_not_interesting.rds&#39;</span><span class=\"p\">)</span>,</span><span class=\"param\">\t<span class=\"n\">drop_common_events</span><span class=\"o\">=</span><span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">log</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_frames": {"fullname": "csi_images.csi_frames", "modulename": "csi_images.csi_frames", "kind": "module", "doc": "<p>Contains the Frame class, which represents a single frame of an image. The Frame class\ndoes not hold the image data, but allows for easy loading of the image data from the\nappropriate file. This module also contains functions for creating RGB and RGBW\ncomposite images from a tile and a set of channels.</p>\n"}, "csi_images.csi_frames.Frame": {"fullname": "csi_images.csi_frames.Frame", "modulename": "csi_images.csi_frames", "qualname": "Frame", "kind": "class", "doc": "<p></p>\n"}, "csi_images.csi_frames.Frame.__init__": {"fullname": "csi_images.csi_frames.Frame.__init__", "modulename": "csi_images.csi_frames", "qualname": "Frame.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">scan</span><span class=\"p\">:</span> <span class=\"n\">csi_images</span><span class=\"o\">.</span><span class=\"n\">csi_scans</span><span class=\"o\">.</span><span class=\"n\">Scan</span>,</span><span class=\"param\">\t<span class=\"n\">tile</span><span class=\"p\">:</span> <span class=\"n\">csi_images</span><span class=\"o\">.</span><span class=\"n\">csi_tiles</span><span class=\"o\">.</span><span class=\"n\">Tile</span>,</span><span class=\"param\">\t<span class=\"n\">channel</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">str</span></span>)</span>"}, "csi_images.csi_frames.Frame.scan": {"fullname": "csi_images.csi_frames.Frame.scan", "modulename": "csi_images.csi_frames", "qualname": "Frame.scan", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_frames.Frame.tile": {"fullname": "csi_images.csi_frames.Frame.tile", "modulename": "csi_images.csi_frames", "qualname": "Frame.tile", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_frames.Frame.get_file_path": {"fullname": "csi_images.csi_frames.Frame.get_file_path", "modulename": "csi_images.csi_frames", "qualname": "Frame.get_file_path", "kind": "function", "doc": "<p>Get the file path for the frame, optionally changing\nthe scan path and file extension.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>input_path</strong>:  the path to the scan's directory. If None, defaults to\nthe path loaded in the frame's tile's scan object.</li>\n<li><strong>file_extension</strong>:  the image file extension. Defaults to .tif.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>the file path.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">input_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">file_extension</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;.tif&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_frames.Frame.get_file_name": {"fullname": "csi_images.csi_frames.Frame.get_file_name", "modulename": "csi_images.csi_frames", "qualname": "Frame.get_file_name", "kind": "function", "doc": "<p>Get the file name for the frame, handling different name conventions by scanner.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>file_extension</strong>:  the image file extension. Defaults to .tif.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>the file name.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">file_extension</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;.tif&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_frames.Frame.get_image": {"fullname": "csi_images.csi_frames.Frame.get_image", "modulename": "csi_images.csi_frames", "qualname": "Frame.get_image", "kind": "function", "doc": "<p>Loads the image for this frame. Handles .tif (will return 16-bit images) and\n.jpg/.jpeg (will return 8-bit images), based on the CSI convention for storing\n.jpg/.jpeg images (compressed, using .tags files).</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>input_path</strong>:  the path to the scan's directory. If None, defaults to\nthe path loaded in the frame's tile's scan object.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>the array representing the image.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">input_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_frames.Frame.check_image": {"fullname": "csi_images.csi_frames.Frame.check_image", "modulename": "csi_images.csi_frames", "qualname": "Frame.check_image", "kind": "function", "doc": "<p>Check if the image for this frame exists.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>input_path</strong>:  the path to the scan's directory. If None, defaults to\nthe path loaded in the frame's tile's scan object.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>whether the image exists.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">input_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_frames.Frame.check_all_images": {"fullname": "csi_images.csi_frames.Frame.check_all_images", "modulename": "csi_images.csi_frames", "qualname": "Frame.check_all_images", "kind": "function", "doc": "<p>Check if all images for a scan exist, either in .tif or .jpg form.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>scan</strong>: </li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">scan</span><span class=\"p\">:</span> <span class=\"n\">csi_images</span><span class=\"o\">.</span><span class=\"n\">csi_scans</span><span class=\"o\">.</span><span class=\"n\">Scan</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "csi_images.csi_frames.Frame.get_frames": {"fullname": "csi_images.csi_frames.Frame.get_frames", "modulename": "csi_images.csi_frames", "qualname": "Frame.get_frames", "kind": "function", "doc": "<p>Get the frames for a tile and a set of channels. By default, gets all channels.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>tile</strong>:  the tile.</li>\n<li><strong>channels</strong>:  the channels, as indices or names. Defaults to all channels.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>the frames, in order of the channels.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">tile</span><span class=\"p\">:</span> <span class=\"n\">csi_images</span><span class=\"o\">.</span><span class=\"n\">csi_tiles</span><span class=\"o\">.</span><span class=\"n\">Tile</span>,</span><span class=\"param\">\t<span class=\"n\">channels</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Self</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_frames.Frame.get_all_frames": {"fullname": "csi_images.csi_frames.Frame.get_all_frames", "modulename": "csi_images.csi_frames", "qualname": "Frame.get_all_frames", "kind": "function", "doc": "<p>Get all frames for a scan and a set of channels.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>scan</strong>:  the scan metadata.</li>\n<li><strong>channels</strong>:  the channels, as indices or names. Defaults to all channels.</li>\n<li><strong>n_roi</strong>:  the region of interest to use. Defaults to 0.</li>\n<li><strong>as_flat</strong>:  whether to flatten the frames into a 2D list.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>if as_flat: 2D list of frames, organized as [n][channel];\n           if not as_flat: 3D list of frames organized as [row][col][channel] a.k.a. [y][x][channel].</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">scan</span><span class=\"p\">:</span> <span class=\"n\">csi_images</span><span class=\"o\">.</span><span class=\"n\">csi_scans</span><span class=\"o\">.</span><span class=\"n\">Scan</span>,</span><span class=\"param\">\t<span class=\"n\">channels</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">n_roi</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">as_flat</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Self</span><span class=\"p\">]]</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Self</span><span class=\"p\">]]]</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_frames.Frame.make_rgb_image": {"fullname": "csi_images.csi_frames.Frame.make_rgb_image", "modulename": "csi_images.csi_frames", "qualname": "Frame.make_rgb_image", "kind": "function", "doc": "<p>Convenience method for creating an RGB image from a tile and a set of channels\nwithout manually extracting any frames.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>tile</strong>:  the tile for which the image should be made.</li>\n<li><strong>channels</strong>:  a dictionary of scan channel indices and RGB gains.</li>\n<li><strong>input_path</strong>:  the path to the input images. Will use metadata if not provided.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>the image as a numpy array.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">tile</span><span class=\"p\">:</span> <span class=\"n\">csi_images</span><span class=\"o\">.</span><span class=\"n\">csi_tiles</span><span class=\"o\">.</span><span class=\"n\">Tile</span>,</span><span class=\"param\">\t<span class=\"n\">channels</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">input_path</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_images": {"fullname": "csi_images.csi_images", "modulename": "csi_images.csi_images", "kind": "module", "doc": "<p></p>\n"}, "csi_images.csi_images.extract_mask_info": {"fullname": "csi_images.csi_images.extract_mask_info", "modulename": "csi_images.csi_images", "qualname": "extract_mask_info", "kind": "function", "doc": "<p>Extracts events from a mask. Originated from @vishnu</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>mask</strong>:  mask to extract events from</li>\n<li><strong>images</strong>:  list of intensity images to extract from</li>\n<li><strong>image_labels</strong>:  list of labels for images</li>\n<li><strong>properties: list of properties to extract in addition to the defaults</strong>: \nlabel, centroid, axis_major_length. See\n<a href=\"https://scikit-image.org/docs/stable/api/skimage.measure.html#skimage.measure.regionprops\">https://scikit-image.org/docs/stable/api/skimage.measure.html#skimage.measure.regionprops</a>\nfor additional properties.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>pd.DataFrame with columns: id, x, y, size, or an empty DataFrame</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">mask</span><span class=\"p\">:</span> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>,</span><span class=\"param\">\t<span class=\"n\">images</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">image_labels</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">properties</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_images.make_rgb": {"fullname": "csi_images.csi_images.make_rgb", "modulename": "csi_images.csi_images", "qualname": "make_rgb", "kind": "function", "doc": "<p>Combine multiple channels into a single RGB image.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>images</strong>:  list of numpy arrays representing the channels.</li>\n<li><strong>colors</strong>:  list of RGB tuples for each channel.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">images</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">colors</span><span class=\"o\">=</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">numpy</span><span class=\"o\">.</span><span class=\"n\">ndarray</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_scans": {"fullname": "csi_images.csi_scans", "modulename": "csi_images.csi_scans", "kind": "module", "doc": "<p>Contains the Scan class, which holds important metadata from a scan. This metadata\ncan be exported to a .yaml file, which can be loaded back into a Scan object. The Scan\nobject can also be loaded from a .czi file or a .txt file.</p>\n"}, "csi_images.csi_scans.Scan": {"fullname": "csi_images.csi_scans.Scan", "modulename": "csi_images.csi_scans", "qualname": "Scan", "kind": "class", "doc": "<p>Class that composes a whole scan's metadata. Contains some universal data,\nplus lists for channels and ROIs.</p>\n\n<p>Scans -> scan-level coordinate frames. Each scan maintains its own scan-level coordinate \nframes based on the scanner it was scanned with.</p>\n\n<p>Slide-level coordinate frame (common, agreed-upon frame of reference for a slide).</p>\n\n<p><img src=\"resources/slide_axes.png\" width=\"100%\"\nalt=\"Picture of the slide coordinate system, which assumes a slide placed horizontally\nwith the label on the left. The x-axis points to the right, and the y-axis points\ndown. The origin is at the top left corner. Key positions, such as the origin of the\nslide's active area at (14500, 2500) micrometers and the bottom-right corner at\n(72500, 22500) micrometers are displayed.\" /></p>\n", "bases": "yaml.YAMLObject"}, "csi_images.csi_scans.Scan.__init__": {"fullname": "csi_images.csi_scans.Scan.__init__", "modulename": "csi_images.csi_scans", "qualname": "Scan.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">slide_id</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">start_date</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">end_date</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">scan_time_s</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"o\">-</span><span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">scanner_id</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">tray</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"o\">-</span><span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">slot</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"o\">-</span><span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">camera</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">objective</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">pixel_size_um</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"o\">-</span><span class=\"mf\">1.0</span>,</span><span class=\"param\">\t<span class=\"n\">tile_width_px</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"o\">-</span><span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">tile_height_px</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"o\">-</span><span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">tile_overlap_proportion</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"o\">-</span><span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">channels</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">roi</span><span class=\"o\">=</span><span class=\"kc\">None</span></span>)</span>"}, "csi_images.csi_scans.Scan.yaml_tag": {"fullname": "csi_images.csi_scans.Scan.yaml_tag", "modulename": "csi_images.csi_scans", "qualname": "Scan.yaml_tag", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;csi_utils.scans.Scan&#x27;"}, "csi_images.csi_scans.Scan.Type": {"fullname": "csi_images.csi_scans.Scan.Type", "modulename": "csi_images.csi_scans", "qualname": "Scan.Type", "kind": "class", "doc": "<p></p>\n", "bases": "enum.Enum"}, "csi_images.csi_scans.Scan.Type.BZSCANNER": {"fullname": "csi_images.csi_scans.Scan.Type.BZSCANNER", "modulename": "csi_images.csi_scans", "qualname": "Scan.Type.BZSCANNER", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.BZSCANNER: &#x27;bzscanner&#x27;&gt;"}, "csi_images.csi_scans.Scan.Type.AXIOSCAN7": {"fullname": "csi_images.csi_scans.Scan.Type.AXIOSCAN7", "modulename": "csi_images.csi_scans", "qualname": "Scan.Type.AXIOSCAN7", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.AXIOSCAN7: &#x27;axioscan7&#x27;&gt;"}, "csi_images.csi_scans.Scan.SCANNER_IDS": {"fullname": "csi_images.csi_scans.Scan.SCANNER_IDS", "modulename": "csi_images.csi_scans", "qualname": "Scan.SCANNER_IDS", "kind": "variable", "doc": "<p>Axioscan 7 scanner IDs (service number), mapped to our scanner IDs</p>\n", "default_value": "{&#x27;4661000426&#x27;: &#x27;axioscan7_0&#x27;}"}, "csi_images.csi_scans.Scan.METADATA_FILE_NAME": {"fullname": "csi_images.csi_scans.Scan.METADATA_FILE_NAME", "modulename": "csi_images.csi_scans", "qualname": "Scan.METADATA_FILE_NAME", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;Type.AXIOSCAN7: &#x27;axioscan7&#x27;&gt;: &#x27;scan.yaml&#x27;, &lt;Type.BZSCANNER: &#x27;bzscanner&#x27;&gt;: &#x27;slideinfo.txt&#x27;}"}, "csi_images.csi_scans.Scan.DATETIME_FORMAT": {"fullname": "csi_images.csi_scans.Scan.DATETIME_FORMAT", "modulename": "csi_images.csi_scans", "qualname": "Scan.DATETIME_FORMAT", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;Type.AXIOSCAN7: &#x27;axioscan7&#x27;&gt;: &#x27;%Y-%m-%dT%H:%M:%S%z&#x27;, &lt;Type.BZSCANNER: &#x27;bzscanner&#x27;&gt;: &#x27;%a %b %d %H:%M:%S %Y&#x27;}"}, "csi_images.csi_scans.Scan.BZSCANNER_CHANNEL_MAP": {"fullname": "csi_images.csi_scans.Scan.BZSCANNER_CHANNEL_MAP", "modulename": "csi_images.csi_scans", "qualname": "Scan.BZSCANNER_CHANNEL_MAP", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;DAPI&#x27;: &#x27;DAPI&#x27;, &#x27;TRITC&#x27;: &#x27;AF555&#x27;, &#x27;CY5&#x27;: &#x27;AF647&#x27;, &#x27;BF&#x27;: &#x27;BRIGHT&#x27;, &#x27;FITC&#x27;: &#x27;AF488&#x27;}"}, "csi_images.csi_scans.Scan.Channel": {"fullname": "csi_images.csi_scans.Scan.Channel", "modulename": "csi_images.csi_scans", "qualname": "Scan.Channel", "kind": "class", "doc": "<p>Class that comprises a channel; we usually have multiple (2-5) per scan.\nContains three fields:</p>\n\n<ul>\n<li>name: the name of the channel (e.g. DAPI, AF647, AF555, AF488, BRIGHTFIELD)</li>\n<li>exposure_ms: the exposure time to capture a frame in milliseconds</li>\n<li>intensity: the light intensity used OR the gain applied to the channel</li>\n</ul>\n", "bases": "yaml.YAMLObject"}, "csi_images.csi_scans.Scan.Channel.__init__": {"fullname": "csi_images.csi_scans.Scan.Channel.__init__", "modulename": "csi_images.csi_scans", "qualname": "Scan.Channel.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>, </span><span class=\"param\"><span class=\"n\">exposure_ms</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"o\">-</span><span class=\"mf\">1.0</span>, </span><span class=\"param\"><span class=\"n\">intensity</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"o\">-</span><span class=\"mf\">1.0</span></span>)</span>"}, "csi_images.csi_scans.Scan.Channel.yaml_tag": {"fullname": "csi_images.csi_scans.Scan.Channel.yaml_tag", "modulename": "csi_images.csi_scans", "qualname": "Scan.Channel.yaml_tag", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;csi_utils.csi_scans.Scan.Channel&#x27;"}, "csi_images.csi_scans.Scan.Channel.name": {"fullname": "csi_images.csi_scans.Scan.Channel.name", "modulename": "csi_images.csi_scans", "qualname": "Scan.Channel.name", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_scans.Scan.Channel.exposure_ms": {"fullname": "csi_images.csi_scans.Scan.Channel.exposure_ms", "modulename": "csi_images.csi_scans", "qualname": "Scan.Channel.exposure_ms", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_scans.Scan.Channel.intensity": {"fullname": "csi_images.csi_scans.Scan.Channel.intensity", "modulename": "csi_images.csi_scans", "qualname": "Scan.Channel.intensity", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_scans.Scan.ROI": {"fullname": "csi_images.csi_scans.Scan.ROI", "modulename": "csi_images.csi_scans", "qualname": "Scan.ROI", "kind": "class", "doc": "<p>Class that comprises an ROI; we usually have 1, but may have more in a scan.</p>\n", "bases": "yaml.YAMLObject"}, "csi_images.csi_scans.Scan.ROI.__init__": {"fullname": "csi_images.csi_scans.Scan.ROI.__init__", "modulename": "csi_images.csi_scans", "qualname": "Scan.ROI.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">origin_x_um</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"o\">-</span><span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">origin_y_um</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"o\">-</span><span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">width_um</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"o\">-</span><span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">height_um</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"o\">-</span><span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">tile_rows</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"o\">-</span><span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">tile_cols</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"o\">-</span><span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">focus_points</span><span class=\"o\">=</span><span class=\"kc\">None</span></span>)</span>"}, "csi_images.csi_scans.Scan.ROI.yaml_tag": {"fullname": "csi_images.csi_scans.Scan.ROI.yaml_tag", "modulename": "csi_images.csi_scans", "qualname": "Scan.ROI.yaml_tag", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;csi_utils.csi_scans.Scan.ROI&#x27;"}, "csi_images.csi_scans.Scan.ROI.origin_x_um": {"fullname": "csi_images.csi_scans.Scan.ROI.origin_x_um", "modulename": "csi_images.csi_scans", "qualname": "Scan.ROI.origin_x_um", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_scans.Scan.ROI.origin_y_um": {"fullname": "csi_images.csi_scans.Scan.ROI.origin_y_um", "modulename": "csi_images.csi_scans", "qualname": "Scan.ROI.origin_y_um", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_scans.Scan.ROI.width_um": {"fullname": "csi_images.csi_scans.Scan.ROI.width_um", "modulename": "csi_images.csi_scans", "qualname": "Scan.ROI.width_um", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_scans.Scan.ROI.height_um": {"fullname": "csi_images.csi_scans.Scan.ROI.height_um", "modulename": "csi_images.csi_scans", "qualname": "Scan.ROI.height_um", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_scans.Scan.ROI.tile_rows": {"fullname": "csi_images.csi_scans.Scan.ROI.tile_rows", "modulename": "csi_images.csi_scans", "qualname": "Scan.ROI.tile_rows", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_scans.Scan.ROI.tile_cols": {"fullname": "csi_images.csi_scans.Scan.ROI.tile_cols", "modulename": "csi_images.csi_scans", "qualname": "Scan.ROI.tile_cols", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_scans.Scan.ROI.focus_points": {"fullname": "csi_images.csi_scans.Scan.ROI.focus_points", "modulename": "csi_images.csi_scans", "qualname": "Scan.ROI.focus_points", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_scans.Scan.ROI.similar": {"fullname": "csi_images.csi_scans.Scan.ROI.similar", "modulename": "csi_images.csi_scans", "qualname": "Scan.ROI.similar", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">other</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "csi_images.csi_scans.Scan.slide_id": {"fullname": "csi_images.csi_scans.Scan.slide_id", "modulename": "csi_images.csi_scans", "qualname": "Scan.slide_id", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_scans.Scan.path": {"fullname": "csi_images.csi_scans.Scan.path", "modulename": "csi_images.csi_scans", "qualname": "Scan.path", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_scans.Scan.start_date": {"fullname": "csi_images.csi_scans.Scan.start_date", "modulename": "csi_images.csi_scans", "qualname": "Scan.start_date", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_scans.Scan.end_date": {"fullname": "csi_images.csi_scans.Scan.end_date", "modulename": "csi_images.csi_scans", "qualname": "Scan.end_date", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_scans.Scan.scan_time_s": {"fullname": "csi_images.csi_scans.Scan.scan_time_s", "modulename": "csi_images.csi_scans", "qualname": "Scan.scan_time_s", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_scans.Scan.scanner_id": {"fullname": "csi_images.csi_scans.Scan.scanner_id", "modulename": "csi_images.csi_scans", "qualname": "Scan.scanner_id", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_scans.Scan.tray": {"fullname": "csi_images.csi_scans.Scan.tray", "modulename": "csi_images.csi_scans", "qualname": "Scan.tray", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_scans.Scan.slot": {"fullname": "csi_images.csi_scans.Scan.slot", "modulename": "csi_images.csi_scans", "qualname": "Scan.slot", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_scans.Scan.camera": {"fullname": "csi_images.csi_scans.Scan.camera", "modulename": "csi_images.csi_scans", "qualname": "Scan.camera", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_scans.Scan.objective": {"fullname": "csi_images.csi_scans.Scan.objective", "modulename": "csi_images.csi_scans", "qualname": "Scan.objective", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_scans.Scan.pixel_size_um": {"fullname": "csi_images.csi_scans.Scan.pixel_size_um", "modulename": "csi_images.csi_scans", "qualname": "Scan.pixel_size_um", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_scans.Scan.tile_width_px": {"fullname": "csi_images.csi_scans.Scan.tile_width_px", "modulename": "csi_images.csi_scans", "qualname": "Scan.tile_width_px", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_scans.Scan.tile_height_px": {"fullname": "csi_images.csi_scans.Scan.tile_height_px", "modulename": "csi_images.csi_scans", "qualname": "Scan.tile_height_px", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_scans.Scan.tile_overlap_proportion": {"fullname": "csi_images.csi_scans.Scan.tile_overlap_proportion", "modulename": "csi_images.csi_scans", "qualname": "Scan.tile_overlap_proportion", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_scans.Scan.channels": {"fullname": "csi_images.csi_scans.Scan.channels", "modulename": "csi_images.csi_scans", "qualname": "Scan.channels", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_scans.Scan.roi": {"fullname": "csi_images.csi_scans.Scan.roi", "modulename": "csi_images.csi_scans", "qualname": "Scan.roi", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_scans.Scan.has_same_profile": {"fullname": "csi_images.csi_scans.Scan.has_same_profile", "modulename": "csi_images.csi_scans", "qualname": "Scan.has_same_profile", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">other</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "csi_images.csi_scans.Scan.get_channel_names": {"fullname": "csi_images.csi_scans.Scan.get_channel_names", "modulename": "csi_images.csi_scans", "qualname": "Scan.get_channel_names", "kind": "function", "doc": "<p>Get the channel names in the scan's channel order.</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>a list of channel names.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_scans.Scan.get_channel_indices": {"fullname": "csi_images.csi_scans.Scan.get_channel_indices", "modulename": "csi_images.csi_scans", "qualname": "Scan.get_channel_indices", "kind": "function", "doc": "<p>Given a list of channel names, return the corresponding indices in the scan's\nchannel order. Will convert BZScanner channel names (TRITC, CY5, FITC) to the\nactual AlexaFluor names (AF555, AF647, AF488).\nIf a list entry is None, it will return -1 for that entry.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>channel_names</strong>:  a list of channel names.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>a list of channel indices.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">channel_names</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_scans.Scan.save_yaml": {"fullname": "csi_images.csi_scans.Scan.save_yaml", "modulename": "csi_images.csi_scans", "qualname": "Scan.save_yaml", "kind": "function", "doc": "<p>Write the Scan object to a .yaml file.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>output_path</strong>:  /path/to/file.yaml or /path/to/folder to put scan.yaml</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>nothing; will raise an error on failure</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">output_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "csi_images.csi_scans.Scan.load_yaml": {"fullname": "csi_images.csi_scans.Scan.load_yaml", "modulename": "csi_images.csi_scans", "qualname": "Scan.load_yaml", "kind": "function", "doc": "<p>Load a Scan object from a .yaml file.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>input_path</strong>:  /path/to/file.yaml or /path/to/folder with scan.yaml</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>a Scan object</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">input_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_scans.Scan.to_dict": {"fullname": "csi_images.csi_scans.Scan.to_dict", "modulename": "csi_images.csi_scans", "qualname": "Scan.to_dict", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_scans.Scan.from_dict": {"fullname": "csi_images.csi_scans.Scan.from_dict", "modulename": "csi_images.csi_scans", "qualname": "Scan.from_dict", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">scan_dict</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_scans.Scan.load_czi": {"fullname": "csi_images.csi_scans.Scan.load_czi", "modulename": "csi_images.csi_scans", "qualname": "Scan.load_czi", "kind": "function", "doc": "<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>input_path</strong>:  the path to the .czi file</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>a Scan object</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">input_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_scans.Scan.load_txt": {"fullname": "csi_images.csi_scans.Scan.load_txt", "modulename": "csi_images.csi_scans", "qualname": "Scan.load_txt", "kind": "function", "doc": "<p>Loads a Scan object from a .txt file, which originates from the BZScanner.\nSome metadata from the slideinfo.txt file is missing or adjusted to fit.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>input_path</strong>:  /path/to/file.txt or /path/to/folder that contains slideinfo.txt</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>a Scan object</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">input_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_scans.Scan.load_from_folder": {"fullname": "csi_images.csi_scans.Scan.load_from_folder", "modulename": "csi_images.csi_scans", "qualname": "Scan.load_from_folder", "kind": "function", "doc": "<p>Load a Scan object from a folder that contains scan.yaml or slideinfo.txt.\nPrefers scan.yaml if both exist.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>input_path</strong>:  /path/to/folder</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>a Scan object</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">input_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_scans.Scan.make_placeholder": {"fullname": "csi_images.csi_scans.Scan.make_placeholder", "modulename": "csi_images.csi_scans", "qualname": "Scan.make_placeholder", "kind": "function", "doc": "<p>Make a placeholder Scan object with only basic required information filled in.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>slide_id</strong>:  the slide ID</li>\n<li><strong>n_tile</strong>:  the number of this tile, which will become the number of\ntiles in the scan</li>\n<li><strong>n_roi</strong>:  the number of ROIs in the scan</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>a Scan object</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">slide_id</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">n_tile</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">2304</span>, </span><span class=\"param\"><span class=\"n\">n_roi</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Self</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_tiles": {"fullname": "csi_images.csi_tiles", "modulename": "csi_images.csi_tiles", "kind": "module", "doc": "<p>Contains the Tile class, which represents a collection of frames at the same position\nin a scan. The module comes with several helper functions that allow for gathering tiles\nbased on their position in the scan.</p>\n"}, "csi_images.csi_tiles.Tile": {"fullname": "csi_images.csi_tiles.Tile", "modulename": "csi_images.csi_tiles", "qualname": "Tile", "kind": "class", "doc": "<p>A class that represents a tile in a scan. This class encodes the position of a group\nof frames in a scan, based on the scan's metadata. The module comes with several\nhelper functions that allow for gathering tiles based on their position in the scan.</p>\n"}, "csi_images.csi_tiles.Tile.__init__": {"fullname": "csi_images.csi_tiles.Tile.__init__", "modulename": "csi_images.csi_tiles", "qualname": "Tile.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">scan</span><span class=\"p\">:</span> <span class=\"n\">csi_images</span><span class=\"o\">.</span><span class=\"n\">csi_scans</span><span class=\"o\">.</span><span class=\"n\">Scan</span>,</span><span class=\"param\">\t<span class=\"n\">coordinates</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">n_roi</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span>)</span>"}, "csi_images.csi_tiles.Tile.scan": {"fullname": "csi_images.csi_tiles.Tile.scan", "modulename": "csi_images.csi_tiles", "qualname": "Tile.scan", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_tiles.Tile.n_roi": {"fullname": "csi_images.csi_tiles.Tile.n_roi", "modulename": "csi_images.csi_tiles", "qualname": "Tile.n_roi", "kind": "variable", "doc": "<p></p>\n"}, "csi_images.csi_tiles.Tile.position_to_n": {"fullname": "csi_images.csi_tiles.Tile.position_to_n", "modulename": "csi_images.csi_tiles", "qualname": "Tile.position_to_n", "kind": "function", "doc": "<p>Convert the x, y coordinates to the n coordinate, based on this tile's scan\nmetadata and ROI. Can be provided alternative x, y to convert for convenience.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>position</strong>:  optional (x, y) coordinates to find the n for.\nIf none provided, this tile's (x, y) will be used.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>the coordinate n, which depends on the scanner and scan layout.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">position</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"p\">(</span><span class=\"o\">-</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"o\">-</span><span class=\"mi\">1</span><span class=\"p\">)</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_tiles.Tile.n_to_position": {"fullname": "csi_images.csi_tiles.Tile.n_to_position", "modulename": "csi_images.csi_tiles", "qualname": "Tile.n_to_position", "kind": "function", "doc": "<p>Convert the n coordinate to x, y coordinates, based on this tile's scan\nmetadata and ROI. Can be provided alternative n to convert for convenience.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>n</strong>:  an optional n coordinate to find the position for.\nIf none provided, this tile's n will be used.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>x, y coordinates of the tile in the scan's coordinate system.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">n</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"o\">-</span><span class=\"mi\">1</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_tiles.Tile.get_tiles": {"fullname": "csi_images.csi_tiles.Tile.get_tiles", "modulename": "csi_images.csi_tiles", "qualname": "Tile.get_tiles", "kind": "function", "doc": "<p>The simplest way to gather a list of Tile objects. By default, it will gather all\ntiles in the scan. To gather specific tiles, provide a list of coordinates.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>scan</strong>:  the scan metadata.</li>\n<li><strong>coordinates</strong>:  a list of n-based indices or (x, y) coordinates.\nLeave as None to include all tiles.</li>\n<li><strong>n_roi</strong>:  the region of interest to use. Defaults to 0.</li>\n<li><strong>as_flat</strong>:  whether to return a flat list of Tile objects or a list of lists.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>if as_flat: a list of Tile objects in the same order as the coordinates;\n           if not as_flat: a list of lists of Tile objects in their relative coordinates.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">scan</span><span class=\"p\">:</span> <span class=\"n\">csi_images</span><span class=\"o\">.</span><span class=\"n\">csi_scans</span><span class=\"o\">.</span><span class=\"n\">Scan</span>,</span><span class=\"param\">\t<span class=\"n\">coordinates</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">n_roi</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">as_flat</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Self</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Self</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"fullname": "csi_images.csi_tiles.Tile.get_tiles_by_row_col", "modulename": "csi_images.csi_tiles", "qualname": "Tile.get_tiles_by_row_col", "kind": "function", "doc": "<p>Gather a list of Tile objects based on the row and column indices provided.\nIf left as None, it will gather all rows and/or columns.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>scan</strong>:  the scan metadata.</li>\n<li><strong>rows</strong>:  a list of 0-indexed rows (y-positions) in the scan axes.\nLeave as None to include all rows.</li>\n<li><strong>cols</strong>:  a list of 0-indexed columns (x-positions) in the scan axes.\nLeave as None to include all columns.</li>\n<li><strong>n_roi</strong>:  the region of interest to use. Defaults to 0.</li>\n<li><strong>as_flat</strong>:  whether to return a flat list of Tile objects or a list of lists.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>if as_flat: a list of Tile objects in row-major order;\n           if not as_flat: a list of lists of Tile objects in their relative coordinates</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">scan</span><span class=\"p\">:</span> <span class=\"n\">csi_images</span><span class=\"o\">.</span><span class=\"n\">csi_scans</span><span class=\"o\">.</span><span class=\"n\">Scan</span>,</span><span class=\"param\">\t<span class=\"n\">rows</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">n_roi</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">as_flat</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Self</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Self</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"fullname": "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds", "modulename": "csi_images.csi_tiles", "qualname": "Tile.get_tiles_by_xy_bounds", "kind": "function", "doc": "<p>Gather a list of Tile objects based on the x, y bounds provided. The bounds are\nexclusive, like indices, so the tiles at the corners are NOT included in the list.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>scan</strong>:  the scan metadata.</li>\n<li><strong>bounds</strong>:  a tuple of (x_0, y_0, x_1, y_1) in the scan axes.</li>\n<li><strong>n_roi</strong>:  the region of interest to use. Defaults to 0.</li>\n<li><strong>as_flat</strong>:  whether to return a flat list of Tile objects or a list of lists.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>if as_flat: a list of Tile objects in row-major order;\n           if not as_flat: a list of lists of Tile objects in their relative coordinates</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">scan</span><span class=\"p\">:</span> <span class=\"n\">csi_images</span><span class=\"o\">.</span><span class=\"n\">csi_scans</span><span class=\"o\">.</span><span class=\"n\">Scan</span>,</span><span class=\"param\">\t<span class=\"n\">bounds</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">n_roi</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">as_flat</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Self</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Self</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "csi_images.ocular_files": {"fullname": "csi_images.ocular_files", "modulename": "csi_images.ocular_files", "kind": "module", "doc": "<p></p>\n"}, "csi_images.ocular_files.FRAME_INFO_FILE": {"fullname": "csi_images.ocular_files.FRAME_INFO_FILE", "modulename": "csi_images.ocular_files", "qualname": "FRAME_INFO_FILE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;frameinfo.csv&#x27;"}, "csi_images.ocular_files.FRAME_MORPHOMETRICS_FILES": {"fullname": "csi_images.ocular_files.FRAME_MORPHOMETRICS_FILES", "modulename": "csi_images.ocular_files", "qualname": "FRAME_MORPHOMETRICS_FILES", "kind": "variable", "doc": "<p></p>\n", "default_value": "[&#x27;framestat-means.csv&#x27;, &#x27;framestat-dev.csv&#x27;]"}, "csi_images.ocular_files.SLIDE_MORPHOMETRICS_FILE": {"fullname": "csi_images.ocular_files.SLIDE_MORPHOMETRICS_FILE", "modulename": "csi_images.ocular_files", "qualname": "SLIDE_MORPHOMETRICS_FILE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;slidestat-calc.csv&#x27;"}, "csi_images.ocular_files.get_cells": {"fullname": "csi_images.ocular_files.get_cells", "modulename": "csi_images.ocular_files", "qualname": "get_cells", "kind": "function", "doc": "<p>Convenience function to read the cells (post-clustering) from OCULAR.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>report_path</strong>: </li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">report_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">csi_images</span><span class=\"o\">.</span><span class=\"n\">csi_events</span><span class=\"o\">.</span><span class=\"n\">EventArray</span>:</span></span>", "funcdef": "def"}, "csi_images.ocular_files.get_others": {"fullname": "csi_images.ocular_files.get_others", "modulename": "csi_images.ocular_files", "qualname": "get_others", "kind": "function", "doc": "<p>Convenience function to read the DAPI- events (post-clustering from OCULAR.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>report_path</strong>: </li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">report_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">csi_images</span><span class=\"o\">.</span><span class=\"n\">csi_events</span><span class=\"o\">.</span><span class=\"n\">EventArray</span>:</span></span>", "funcdef": "def"}, "csi_images.ocular_files.save_cells": {"fullname": "csi_images.ocular_files.save_cells", "modulename": "csi_images.ocular_files", "qualname": "save_cells", "kind": "function", "doc": "<p>Convenience function to save the cells (post-clustering) from OCULAR.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>report_path</strong>: </li>\n<li><strong>events</strong>: </li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">report_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">events</span><span class=\"p\">:</span> <span class=\"n\">csi_images</span><span class=\"o\">.</span><span class=\"n\">csi_events</span><span class=\"o\">.</span><span class=\"n\">EventArray</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "csi_images.ocular_files.save_others": {"fullname": "csi_images.ocular_files.save_others", "modulename": "csi_images.ocular_files", "qualname": "save_others", "kind": "function", "doc": "<p>Convenience function to save the DAPI- events (post-clustering) from OCULAR.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>report_path</strong>: </li>\n<li><strong>events</strong>: </li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">report_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">events</span><span class=\"p\">:</span> <span class=\"n\">csi_images</span><span class=\"o\">.</span><span class=\"n\">csi_events</span><span class=\"o\">.</span><span class=\"n\">EventArray</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "csi_images.ocular_files.get_frame_info": {"fullname": "csi_images.ocular_files.get_frame_info", "modulename": "csi_images.ocular_files", "qualname": "get_frame_info", "kind": "function", "doc": "<p>Reads frameinfo.csv with high-level frame metadata.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>report_path</strong>:  path to the OCULAR report folder.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>DataFrame with frame info</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">report_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "csi_images.ocular_files.get_frame_statistics": {"fullname": "csi_images.ocular_files.get_frame_statistics", "modulename": "csi_images.ocular_files", "qualname": "get_frame_statistics", "kind": "function", "doc": "<p>Reads framestat-means.csv and framestat-dev.csv and merges them.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>report_path</strong>:  path to the OCULAR report folder.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">report_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "csi_images.ocular_files.get_slide_statistics": {"fullname": "csi_images.ocular_files.get_slide_statistics", "modulename": "csi_images.ocular_files", "qualname": "get_slide_statistics", "kind": "function", "doc": "<p>Gets slide-level morphometric statistics from slidestat-calc.csv.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>report_path</strong>:  path to the OCULAR report folder.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">report_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "csi_images.ocular_files.merge_statistics": {"fullname": "csi_images.ocular_files.merge_statistics", "modulename": "csi_images.ocular_files", "qualname": "merge_statistics", "kind": "function", "doc": "<p>Merges frame-level and slide-level morphometric statistics into the EventArray.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>events</strong>:  EventArray object</li>\n<li><strong>frame_stats</strong>:  frame-level morphometric statistics</li>\n<li><strong>slide_stats</strong>:  slide-level morphometric statistics</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>a new EventArray object with the merged data</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">events</span><span class=\"p\">:</span> <span class=\"n\">csi_images</span><span class=\"o\">.</span><span class=\"n\">csi_events</span><span class=\"o\">.</span><span class=\"n\">EventArray</span>,</span><span class=\"param\">\t<span class=\"n\">frame_stats</span><span class=\"p\">:</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>,</span><span class=\"param\">\t<span class=\"n\">slide_stats</span><span class=\"p\">:</span> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span></span><span class=\"return-annotation\">) -> <span class=\"n\">csi_images</span><span class=\"o\">.</span><span class=\"n\">csi_events</span><span class=\"o\">.</span><span class=\"n\">EventArray</span>:</span></span>", "funcdef": "def"}, "csi_images.ocular_files.filter_and_generate_statistics": {"fullname": "csi_images.ocular_files.filter_and_generate_statistics", "modulename": "csi_images.ocular_files", "qualname": "filter_and_generate_statistics", "kind": "function", "doc": "<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>events</strong>: </li>\n<li><strong>morphs_to_drop</strong>: </li>\n<li><strong>morphs_to_keep</strong>: </li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">events</span><span class=\"p\">:</span> <span class=\"n\">csi_images</span><span class=\"o\">.</span><span class=\"n\">csi_events</span><span class=\"o\">.</span><span class=\"n\">EventArray</span>,</span><span class=\"param\">\t<span class=\"n\">morphs_to_drop</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">morphs_to_keep</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">csi_images</span><span class=\"o\">.</span><span class=\"n\">csi_events</span><span class=\"o\">.</span><span class=\"n\">EventArray</span>:</span></span>", "funcdef": "def"}, "examples": {"fullname": "examples", "modulename": "examples", "kind": "module", "doc": "<p>Contains examples of how various modules can be used.\nPlease see the examples for more information.</p>\n\n<p>Examples focusing on particular modules may be sensitive, so please be careful\nwhen sharing them! No examples should modify the production database or files.</p>\n"}, "examples.scan_examples": {"fullname": "examples.scan_examples", "modulename": "examples.scan_examples", "kind": "module", "doc": "<p></p>\n"}, "examples.scan_examples.load_in_images": {"fullname": "examples.scan_examples.load_in_images", "modulename": "examples.scan_examples", "qualname": "load_in_images", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "tests": {"fullname": "tests", "modulename": "tests", "kind": "module", "doc": "<p>The test modules, which can be run with <code>pytest</code> once the package is installed and\n<code>pip install -r requirements.txt</code> has been run. Some of these tests act as little\ndemos of how to use the package, so you may find them helpful to see the imagined\nworkflow of the package.</p>\n"}, "tests.compare_cv2_tifffile": {"fullname": "tests.compare_cv2_tifffile", "modulename": "tests.compare_cv2_tifffile", "kind": "module", "doc": "<p>A script that compares reading images with cv2 and tifffile for speed.</p>\n"}, "tests.compare_cv2_tifffile.main": {"fullname": "tests.compare_cv2_tifffile.main", "modulename": "tests.compare_cv2_tifffile", "qualname": "main", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "tests.test_events": {"fullname": "tests.test_events", "modulename": "tests.test_events", "kind": "module", "doc": "<p></p>\n"}, "tests.test_events.test_getting_event": {"fullname": "tests.test_events.test_getting_event", "modulename": "tests.test_events", "qualname": "test_getting_event", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "tests.test_events.test_getting_many_events": {"fullname": "tests.test_events.test_getting_many_events", "modulename": "tests.test_events", "qualname": "test_getting_many_events", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "tests.test_events.test_event_coordinates_for_bzscanner": {"fullname": "tests.test_events.test_event_coordinates_for_bzscanner", "modulename": "tests.test_events", "qualname": "test_event_coordinates_for_bzscanner", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "tests.test_events.test_event_coordinates_for_axioscan": {"fullname": "tests.test_events.test_event_coordinates_for_axioscan", "modulename": "tests.test_events", "qualname": "test_event_coordinates_for_axioscan", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "tests.test_events.test_eventarray_conversions": {"fullname": "tests.test_events.test_eventarray_conversions", "modulename": "tests.test_events", "qualname": "test_eventarray_conversions", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "tests.test_events.test_ocular_conversions": {"fullname": "tests.test_events.test_ocular_conversions", "modulename": "tests.test_events", "qualname": "test_ocular_conversions", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "tests.test_events.test_copy_sort_rows_get": {"fullname": "tests.test_events.test_copy_sort_rows_get", "modulename": "tests.test_events", "qualname": "test_copy_sort_rows_get", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "tests.test_examples": {"fullname": "tests.test_examples", "modulename": "tests.test_examples", "kind": "module", "doc": "<p>Loads all scripts in the examples folder and runs them to ensure they execute without error.</p>\n"}, "tests.test_examples.test_all_examples": {"fullname": "tests.test_examples.test_all_examples", "modulename": "tests.test_examples", "qualname": "test_all_examples", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "tests.test_frames": {"fullname": "tests.test_frames", "modulename": "tests.test_frames", "kind": "module", "doc": "<p></p>\n"}, "tests.test_frames.test_getting_frames": {"fullname": "tests.test_frames.test_getting_frames", "modulename": "tests.test_frames", "qualname": "test_getting_frames", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "tests.test_frames.test_checking_frames": {"fullname": "tests.test_frames.test_checking_frames", "modulename": "tests.test_frames", "qualname": "test_checking_frames", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "tests.test_frames.test_make_rgb": {"fullname": "tests.test_frames.test_make_rgb", "modulename": "tests.test_frames", "qualname": "test_make_rgb", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "tests.test_scans": {"fullname": "tests.test_scans", "modulename": "tests.test_scans", "kind": "module", "doc": "<p></p>\n"}, "tests.test_scans.test_from_yaml": {"fullname": "tests.test_scans.test_from_yaml", "modulename": "tests.test_scans", "qualname": "test_from_yaml", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "tests.test_scans.test_from_txt": {"fullname": "tests.test_scans.test_from_txt", "modulename": "tests.test_scans", "qualname": "test_from_txt", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "tests.test_scans.test_names_and_indices": {"fullname": "tests.test_scans.test_names_and_indices", "modulename": "tests.test_scans", "qualname": "test_names_and_indices", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "tests.test_tiles": {"fullname": "tests.test_tiles", "modulename": "tests.test_tiles", "kind": "module", "doc": "<p></p>\n"}, "tests.test_tiles.test_axioscan_tiles": {"fullname": "tests.test_tiles.test_axioscan_tiles", "modulename": "tests.test_tiles", "qualname": "test_axioscan_tiles", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "tests.test_tiles.test_bzscanner_tiles": {"fullname": "tests.test_tiles.test_bzscanner_tiles", "modulename": "tests.test_tiles", "qualname": "test_bzscanner_tiles", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "tests.test_tiles.test_getting_tiles": {"fullname": "tests.test_tiles.test_getting_tiles", "modulename": "tests.test_tiles", "qualname": "test_getting_tiles", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}}, "docInfo": {"csi_images": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 848}, "csi_images.csi_events": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 82}, "csi_images.csi_events.Event": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 35}, "csi_images.csi_events.Event.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 156, "bases": 0, "doc": 3}, "csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"qualname": 5, "fullname": 9, "annotation": 0, "default_value": 44, "signature": 0, "bases": 0, "doc": 62}, "csi_images.csi_events.Event.scan": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_events.Event.tile": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_events.Event.x": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_events.Event.y": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_events.Event.size": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_events.Event.metadata": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_events.Event.features": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_events.Event.get_scan_position": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 34}, "csi_images.csi_events.Event.get_slide_position": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 29}, "csi_images.csi_events.Event.crop_images": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 86, "bases": 0, "doc": 136}, "csi_images.csi_events.Event.extract_images": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 64, "bases": 0, "doc": 122}, "csi_images.csi_events.Event.extract_images_for_list": {"qualname": 5, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 102, "bases": 0, "doc": 134}, "csi_images.csi_events.EventArray": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 32}, "csi_images.csi_events.EventArray.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 103, "bases": 0, "doc": 3}, "csi_images.csi_events.EventArray.INFO_COLUMNS": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 21, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_events.EventArray.info": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_events.EventArray.metadata": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_events.EventArray.features": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_events.EventArray.get_sort_order": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 62, "bases": 0, "doc": 77}, "csi_images.csi_events.EventArray.sort": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 65, "bases": 0, "doc": 69}, "csi_images.csi_events.EventArray.get": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 72, "bases": 0, "doc": 52}, "csi_images.csi_events.EventArray.rows": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 58}, "csi_images.csi_events.EventArray.copy": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 26}, "csi_images.csi_events.EventArray.add_metadata": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 63, "bases": 0, "doc": 48}, "csi_images.csi_events.EventArray.add_features": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 63, "bases": 0, "doc": 48}, "csi_images.csi_events.EventArray.merge": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 35, "bases": 0, "doc": 30}, "csi_images.csi_events.EventArray.to_events": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 117, "bases": 0, "doc": 97}, "csi_images.csi_events.EventArray.from_events": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 42, "bases": 0, "doc": 33}, "csi_images.csi_events.EventArray.to_dataframe": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 29, "bases": 0, "doc": 33}, "csi_images.csi_events.EventArray.from_dataframe": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 30}, "csi_images.csi_events.EventArray.from_mask": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 172, "bases": 0, "doc": 155}, "csi_images.csi_events.EventArray.save_csv": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 31}, "csi_images.csi_events.EventArray.load_csv": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 31}, "csi_images.csi_events.EventArray.save_hdf5": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 54}, "csi_images.csi_events.EventArray.load_hdf5": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 31}, "csi_images.csi_events.EventArray.save_ocular": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 44, "bases": 0, "doc": 47}, "csi_images.csi_events.EventArray.load_ocular": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 239, "bases": 0, "doc": 62}, "csi_images.csi_frames": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 57}, "csi_images.csi_frames.Frame": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_frames.Frame.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 67, "bases": 0, "doc": 3}, "csi_images.csi_frames.Frame.scan": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_frames.Frame.tile": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_frames.Frame.get_file_path": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 54, "bases": 0, "doc": 81}, "csi_images.csi_frames.Frame.get_file_name": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 50}, "csi_images.csi_frames.Frame.get_image": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 37, "bases": 0, "doc": 89}, "csi_images.csi_frames.Frame.check_image": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 32, "bases": 0, "doc": 61}, "csi_images.csi_frames.Frame.check_all_images": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 33}, "csi_images.csi_frames.Frame.get_frames": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 79, "bases": 0, "doc": 67}, "csi_images.csi_frames.Frame.get_all_frames": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 146, "bases": 0, "doc": 113}, "csi_images.csi_frames.Frame.make_rgb_image": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 94, "bases": 0, "doc": 95}, "csi_images.csi_images": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_images.extract_mask_info": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 118, "bases": 0, "doc": 105}, "csi_images.csi_images.make_rgb": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 69, "bases": 0, "doc": 47}, "csi_images.csi_scans": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 47}, "csi_images.csi_scans.Scan": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 67}, "csi_images.csi_scans.Scan.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 335, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.yaml_tag": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 8, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.Type": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 3}, "csi_images.csi_scans.Scan.Type.BZSCANNER": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.Type.AXIOSCAN7": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.SCANNER_IDS": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 10, "signature": 0, "bases": 0, "doc": 13}, "csi_images.csi_scans.Scan.METADATA_FILE_NAME": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 26, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.DATETIME_FORMAT": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 30, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.BZSCANNER_CHANNEL_MAP": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 37, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.Channel": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 65}, "csi_images.csi_scans.Scan.Channel.__init__": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 67, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.Channel.yaml_tag": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 10, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.Channel.name": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.Channel.exposure_ms": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.Channel.intensity": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.ROI": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 19}, "csi_images.csi_scans.Scan.ROI.__init__": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 150, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.ROI.yaml_tag": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 10, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.ROI.origin_x_um": {"qualname": 5, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.ROI.origin_y_um": {"qualname": 5, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.ROI.width_um": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.ROI.height_um": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.ROI.tile_rows": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.ROI.tile_cols": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.ROI.focus_points": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.ROI.similar": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.slide_id": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.path": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.start_date": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.end_date": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.scan_time_s": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.scanner_id": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.tray": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.slot": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.camera": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.objective": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.pixel_size_um": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.tile_width_px": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.tile_height_px": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.tile_overlap_proportion": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.channels": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.roi": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.has_same_profile": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.get_channel_names": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 28}, "csi_images.csi_scans.Scan.get_channel_indices": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 43, "bases": 0, "doc": 82}, "csi_images.csi_scans.Scan.save_yaml": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 48}, "csi_images.csi_scans.Scan.load_yaml": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 43}, "csi_images.csi_scans.Scan.to_dict": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.from_dict": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 3}, "csi_images.csi_scans.Scan.load_czi": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 31}, "csi_images.csi_scans.Scan.load_txt": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 62}, "csi_images.csi_scans.Scan.load_from_folder": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 49}, "csi_images.csi_scans.Scan.make_placeholder": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 61, "bases": 0, "doc": 77}, "csi_images.csi_tiles": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 39}, "csi_images.csi_tiles.Tile": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 50}, "csi_images.csi_tiles.Tile.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 75, "bases": 0, "doc": 3}, "csi_images.csi_tiles.Tile.scan": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_tiles.Tile.n_roi": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.csi_tiles.Tile.position_to_n": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 61, "bases": 0, "doc": 85}, "csi_images.csi_tiles.Tile.n_to_position": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 46, "bases": 0, "doc": 83}, "csi_images.csi_tiles.Tile.get_tiles": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 154, "bases": 0, "doc": 148}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"qualname": 6, "fullname": 10, "annotation": 0, "default_value": 0, "signature": 156, "bases": 0, "doc": 167}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"qualname": 6, "fullname": 10, "annotation": 0, "default_value": 0, "signature": 143, "bases": 0, "doc": 144}, "csi_images.ocular_files": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "csi_images.ocular_files.FRAME_INFO_FILE": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 6, "signature": 0, "bases": 0, "doc": 3}, "csi_images.ocular_files.FRAME_MORPHOMETRICS_FILES": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 12, "signature": 0, "bases": 0, "doc": 3}, "csi_images.ocular_files.SLIDE_MORPHOMETRICS_FILE": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 7, "signature": 0, "bases": 0, "doc": 3}, "csi_images.ocular_files.get_cells": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 32, "bases": 0, "doc": 30}, "csi_images.ocular_files.get_others": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 32, "bases": 0, "doc": 31}, "csi_images.ocular_files.save_cells": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 36}, "csi_images.ocular_files.save_others": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 37}, "csi_images.ocular_files.get_frame_info": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 35, "bases": 0, "doc": 44}, "csi_images.ocular_files.get_frame_statistics": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 35, "bases": 0, "doc": 37}, "csi_images.ocular_files.get_slide_statistics": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 35, "bases": 0, "doc": 35}, "csi_images.ocular_files.merge_statistics": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 65}, "csi_images.ocular_files.filter_and_generate_statistics": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 96, "bases": 0, "doc": 32}, "examples": {"qualname": 0, "fullname": 1, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 46}, "examples.scan_examples": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "examples.scan_examples.load_in_images": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 3}, "tests": {"qualname": 0, "fullname": 1, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 58}, "tests.compare_cv2_tifffile": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 15}, "tests.compare_cv2_tifffile.main": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 3}, "tests.test_events": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "tests.test_events.test_getting_event": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 3}, "tests.test_events.test_getting_many_events": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 3}, "tests.test_events.test_event_coordinates_for_bzscanner": {"qualname": 5, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 3}, "tests.test_events.test_event_coordinates_for_axioscan": {"qualname": 5, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 3}, "tests.test_events.test_eventarray_conversions": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 3}, "tests.test_events.test_ocular_conversions": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 3}, "tests.test_events.test_copy_sort_rows_get": {"qualname": 5, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 3}, "tests.test_examples": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 19}, "tests.test_examples.test_all_examples": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 3}, "tests.test_frames": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "tests.test_frames.test_getting_frames": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 3}, "tests.test_frames.test_checking_frames": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 3}, "tests.test_frames.test_make_rgb": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 3}, "tests.test_scans": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "tests.test_scans.test_from_yaml": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 3}, "tests.test_scans.test_from_txt": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 3}, "tests.test_scans.test_names_and_indices": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 3}, "tests.test_tiles": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "tests.test_tiles.test_axioscan_tiles": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 3}, "tests.test_tiles.test_bzscanner_tiles": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 3}, "tests.test_tiles.test_getting_tiles": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 3}}, "length": 164, "save": true}, "index": {"qualname": {"root": {"docs": {"csi_images.csi_events.Event.__init__": {"tf": 1}, "csi_images.csi_events.EventArray.__init__": {"tf": 1}, "csi_images.csi_frames.Frame.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.__init__": {"tf": 1}, "csi_images.csi_tiles.Tile.__init__": {"tf": 1}}, "df": 7, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.Event": {"tf": 1}, "csi_images.csi_events.Event.__init__": {"tf": 1}, "csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}, "csi_images.csi_events.Event.scan": {"tf": 1}, "csi_images.csi_events.Event.tile": {"tf": 1}, "csi_images.csi_events.Event.x": {"tf": 1}, "csi_images.csi_events.Event.y": {"tf": 1}, "csi_images.csi_events.Event.size": {"tf": 1}, "csi_images.csi_events.Event.metadata": {"tf": 1}, "csi_images.csi_events.Event.features": {"tf": 1}, "csi_images.csi_events.Event.get_scan_position": {"tf": 1}, "csi_images.csi_events.Event.get_slide_position": {"tf": 1}, "csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "tests.test_events.test_getting_event": {"tf": 1}, "tests.test_events.test_event_coordinates_for_bzscanner": {"tf": 1}, "tests.test_events.test_event_coordinates_for_axioscan": {"tf": 1}}, "df": 18, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {"csi_images.csi_events.EventArray": {"tf": 1}, "csi_images.csi_events.EventArray.__init__": {"tf": 1}, "csi_images.csi_events.EventArray.INFO_COLUMNS": {"tf": 1}, "csi_images.csi_events.EventArray.info": {"tf": 1}, "csi_images.csi_events.EventArray.metadata": {"tf": 1}, "csi_images.csi_events.EventArray.features": {"tf": 1}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.sort": {"tf": 1}, "csi_images.csi_events.EventArray.get": {"tf": 1}, "csi_images.csi_events.EventArray.rows": {"tf": 1}, "csi_images.csi_events.EventArray.copy": {"tf": 1}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}, "csi_images.csi_events.EventArray.merge": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_events.EventArray.from_events": {"tf": 1}, "csi_images.csi_events.EventArray.to_dataframe": {"tf": 1}, "csi_images.csi_events.EventArray.from_dataframe": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_csv": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}, "tests.test_events.test_eventarray_conversions": {"tf": 1}}, "df": 26}}}}}, "s": {"docs": {"csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_events.EventArray.from_events": {"tf": 1}, "tests.test_events.test_getting_many_events": {"tf": 1}}, "df": 3}}}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1}}, "df": 3}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.Channel.exposure_ms": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"tests.test_examples.test_all_examples": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_scans.Scan.end_date": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"examples.scan_examples.load_in_images": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.Event.__init__": {"tf": 1}, "csi_images.csi_events.EventArray.__init__": {"tf": 1}, "csi_images.csi_frames.Frame.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.__init__": {"tf": 1}, "csi_images.csi_tiles.Tile.__init__": {"tf": 1}}, "df": 7}}, "f": {"docs": {}, "df": 0, "o": {"docs": {"csi_images.csi_events.EventArray.INFO_COLUMNS": {"tf": 1}, "csi_images.csi_events.EventArray.info": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1}, "csi_images.ocular_files.FRAME_INFO_FILE": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1}}, "df": 5}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"csi_images.csi_scans.Scan.Channel.intensity": {"tf": 1}}, "df": 1}}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "tests.test_scans.test_names_and_indices": {"tf": 1}}, "df": 2}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}}, "df": 3, "s": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 1}, "examples.scan_examples.load_in_images": {"tf": 1}}, "df": 5}}}}}, "d": {"docs": {"csi_images.csi_scans.Scan.slide_id": {"tf": 1}, "csi_images.csi_scans.Scan.scanner_id": {"tf": 1}}, "df": 2, "s": {"docs": {"csi_images.csi_scans.Scan.SCANNER_IDS": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"csi_images.csi_scans.Scan.scan_time_s": {"tf": 1}}, "df": 1, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}, "csi_images.csi_events.Event.scan": {"tf": 1}, "csi_images.csi_events.Event.get_scan_position": {"tf": 1}, "csi_images.csi_frames.Frame.scan": {"tf": 1}, "csi_images.csi_scans.Scan": {"tf": 1}, "csi_images.csi_scans.Scan.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.Type": {"tf": 1}, "csi_images.csi_scans.Scan.Type.BZSCANNER": {"tf": 1}, "csi_images.csi_scans.Scan.Type.AXIOSCAN7": {"tf": 1}, "csi_images.csi_scans.Scan.SCANNER_IDS": {"tf": 1}, "csi_images.csi_scans.Scan.METADATA_FILE_NAME": {"tf": 1}, "csi_images.csi_scans.Scan.DATETIME_FORMAT": {"tf": 1}, "csi_images.csi_scans.Scan.BZSCANNER_CHANNEL_MAP": {"tf": 1}, "csi_images.csi_scans.Scan.Channel": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.name": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.exposure_ms": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.intensity": {"tf": 1}, "csi_images.csi_scans.Scan.ROI": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.origin_x_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.origin_y_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.width_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.height_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.tile_rows": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.tile_cols": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.focus_points": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.similar": {"tf": 1}, "csi_images.csi_scans.Scan.slide_id": {"tf": 1}, "csi_images.csi_scans.Scan.path": {"tf": 1}, "csi_images.csi_scans.Scan.start_date": {"tf": 1}, "csi_images.csi_scans.Scan.end_date": {"tf": 1}, "csi_images.csi_scans.Scan.scan_time_s": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.scanner_id": {"tf": 1}, "csi_images.csi_scans.Scan.tray": {"tf": 1}, "csi_images.csi_scans.Scan.slot": {"tf": 1}, "csi_images.csi_scans.Scan.camera": {"tf": 1}, "csi_images.csi_scans.Scan.objective": {"tf": 1}, "csi_images.csi_scans.Scan.pixel_size_um": {"tf": 1}, "csi_images.csi_scans.Scan.tile_width_px": {"tf": 1}, "csi_images.csi_scans.Scan.tile_height_px": {"tf": 1}, "csi_images.csi_scans.Scan.tile_overlap_proportion": {"tf": 1}, "csi_images.csi_scans.Scan.channels": {"tf": 1}, "csi_images.csi_scans.Scan.roi": {"tf": 1}, "csi_images.csi_scans.Scan.has_same_profile": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_names": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.to_dict": {"tf": 1}, "csi_images.csi_scans.Scan.from_dict": {"tf": 1}, "csi_images.csi_scans.Scan.load_czi": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}, "csi_images.csi_tiles.Tile.scan": {"tf": 1}}, "df": 59, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_scans.Scan.SCANNER_IDS": {"tf": 1}, "csi_images.csi_scans.Scan.scanner_id": {"tf": 1}}, "df": 2}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}, "csi_images.csi_events.Event.get_slide_position": {"tf": 1}, "csi_images.csi_scans.Scan.slide_id": {"tf": 1}, "csi_images.ocular_files.SLIDE_MORPHOMETRICS_FILE": {"tf": 1}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}}, "df": 5}}}, "o": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_scans.Scan.slot": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.Event.size": {"tf": 1}, "csi_images.csi_scans.Scan.pixel_size_um": {"tf": 1}}, "df": 2}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_scans.Scan.ROI.similar": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.sort": {"tf": 1}, "tests.test_events.test_copy_sort_rows_get": {"tf": 1}}, "df": 3}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}}, "df": 6}}, "m": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.has_same_profile": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_scans.Scan.start_date": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.ocular_files.get_frame_statistics": {"tf": 1}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}, "csi_images.ocular_files.merge_statistics": {"tf": 1}, "csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1}}, "df": 4}}}}}}}}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_events.EventArray.to_dataframe": {"tf": 1}, "csi_images.csi_scans.Scan.to_dict": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}}, "df": 6}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}}, "df": 1}}}}}}, "y": {"docs": {"csi_images.csi_scans.Scan.tray": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.Event.tile": {"tf": 1}, "csi_images.csi_frames.Frame.tile": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.tile_rows": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.tile_cols": {"tf": 1}, "csi_images.csi_scans.Scan.tile_width_px": {"tf": 1}, "csi_images.csi_scans.Scan.tile_height_px": {"tf": 1}, "csi_images.csi_scans.Scan.tile_overlap_proportion": {"tf": 1}, "csi_images.csi_tiles.Tile": {"tf": 1}, "csi_images.csi_tiles.Tile.__init__": {"tf": 1}, "csi_images.csi_tiles.Tile.scan": {"tf": 1}, "csi_images.csi_tiles.Tile.n_roi": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 16, "s": {"docs": {"csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}, "tests.test_tiles.test_axioscan_tiles": {"tf": 1}, "tests.test_tiles.test_bzscanner_tiles": {"tf": 1}, "tests.test_tiles.test_getting_tiles": {"tf": 1}}, "df": 6}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.scan_time_s": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_scans.Scan.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.yaml_tag": {"tf": 1}}, "df": 3}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.Type": {"tf": 1}, "csi_images.csi_scans.Scan.Type.BZSCANNER": {"tf": 1}, "csi_images.csi_scans.Scan.Type.AXIOSCAN7": {"tf": 1}}, "df": 3}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_scans.Scan.load_txt": {"tf": 1}, "tests.test_scans.test_from_txt": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"tests.test_events.test_getting_event": {"tf": 1}, "tests.test_events.test_getting_many_events": {"tf": 1}, "tests.test_events.test_event_coordinates_for_bzscanner": {"tf": 1}, "tests.test_events.test_event_coordinates_for_axioscan": {"tf": 1}, "tests.test_events.test_eventarray_conversions": {"tf": 1}, "tests.test_events.test_ocular_conversions": {"tf": 1}, "tests.test_events.test_copy_sort_rows_get": {"tf": 1}, "tests.test_examples.test_all_examples": {"tf": 1}, "tests.test_frames.test_getting_frames": {"tf": 1}, "tests.test_frames.test_checking_frames": {"tf": 1}, "tests.test_frames.test_make_rgb": {"tf": 1}, "tests.test_scans.test_from_yaml": {"tf": 1}, "tests.test_scans.test_from_txt": {"tf": 1}, "tests.test_scans.test_names_and_indices": {"tf": 1}, "tests.test_tiles.test_axioscan_tiles": {"tf": 1}, "tests.test_tiles.test_bzscanner_tiles": {"tf": 1}, "tests.test_tiles.test_getting_tiles": {"tf": 1}}, "df": 17}}}}, "x": {"docs": {"csi_images.csi_events.Event.x": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.origin_x_um": {"tf": 1}}, "df": 2, "y": {"docs": {"csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 1}}, "y": {"docs": {"csi_images.csi_events.Event.y": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.origin_y_um": {"tf": 1}}, "df": 2, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_scans.Scan.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1}, "tests.test_scans.test_from_yaml": {"tf": 1}}, "df": 6}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"csi_images.csi_events.Event.metadata": {"tf": 1}, "csi_images.csi_events.EventArray.metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_scans.Scan.METADATA_FILE_NAME": {"tf": 1}}, "df": 4}}}}}}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray.merge": {"tf": 1}, "csi_images.ocular_files.merge_statistics": {"tf": 1}}, "df": 2}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "k": {"docs": {"csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1}}, "df": 2}}, "k": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_images.make_rgb": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}, "tests.test_frames.test_make_rgb": {"tf": 1}}, "df": 4}}, "p": {"docs": {"csi_images.csi_scans.Scan.BZSCANNER_CHANNEL_MAP": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "n": {"docs": {"tests.compare_cv2_tifffile.main": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "y": {"docs": {"tests.test_events.test_getting_many_events": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"csi_images.csi_scans.Scan.Channel.exposure_ms": {"tf": 1}}, "df": 1}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.ocular_files.FRAME_MORPHOMETRICS_FILES": {"tf": 1}, "csi_images.ocular_files.SLIDE_MORPHOMETRICS_FILE": {"tf": 1}}, "df": 2}}}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.Event.features": {"tf": 1}, "csi_images.csi_events.EventArray.features": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}}, "df": 3}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "tests.test_events.test_event_coordinates_for_bzscanner": {"tf": 1}, "tests.test_events.test_event_coordinates_for_axioscan": {"tf": 1}}, "df": 3, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_scans.Scan.DATETIME_FORMAT": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_scans.Scan.ROI.focus_points": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"csi_images.csi_events.EventArray.from_events": {"tf": 1}, "csi_images.csi_events.EventArray.from_dataframe": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_scans.Scan.from_dict": {"tf": 1}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}, "tests.test_scans.test_from_yaml": {"tf": 1}, "tests.test_scans.test_from_txt": {"tf": 1}}, "df": 7}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_frames.Frame": {"tf": 1}, "csi_images.csi_frames.Frame.__init__": {"tf": 1}, "csi_images.csi_frames.Frame.scan": {"tf": 1}, "csi_images.csi_frames.Frame.tile": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.ocular_files.FRAME_INFO_FILE": {"tf": 1}, "csi_images.ocular_files.FRAME_MORPHOMETRICS_FILES": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1}}, "df": 16, "s": {"docs": {"csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "tests.test_frames.test_getting_frames": {"tf": 1}, "tests.test_frames.test_checking_frames": {"tf": 1}}, "df": 4}}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1}, "csi_images.csi_scans.Scan.METADATA_FILE_NAME": {"tf": 1}, "csi_images.ocular_files.FRAME_INFO_FILE": {"tf": 1}, "csi_images.ocular_files.SLIDE_MORPHOMETRICS_FILE": {"tf": 1}}, "df": 5, "s": {"docs": {"csi_images.ocular_files.FRAME_MORPHOMETRICS_FILES": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1}}, "df": 1}}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.Event.get_scan_position": {"tf": 1}, "csi_images.csi_events.Event.get_slide_position": {"tf": 1}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.get": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_names": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}, "csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}, "tests.test_events.test_copy_sort_rows_get": {"tf": 1}}, "df": 20, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"tests.test_events.test_getting_event": {"tf": 1}, "tests.test_events.test_getting_many_events": {"tf": 1}, "tests.test_frames.test_getting_frames": {"tf": 1}, "tests.test_tiles.test_getting_tiles": {"tf": 1}}, "df": 4}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1}}, "df": 1}}}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_events.Event.get_scan_position": {"tf": 1}, "csi_images.csi_events.Event.get_slide_position": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}}, "df": 4}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_scans.Scan.ROI.focus_points": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_scans.Scan.path": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_scans.Scan.pixel_size_um": {"tf": 1}}, "df": 1}}}}, "x": {"docs": {"csi_images.csi_scans.Scan.tile_width_px": {"tf": 1}, "csi_images.csi_scans.Scan.tile_height_px": {"tf": 1}}, "df": 2}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_scans.Scan.tile_overlap_proportion": {"tf": 1}}, "df": 1}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.has_same_profile": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}}, "df": 1}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}}, "df": 1, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.EventArray.INFO_COLUMNS": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"csi_images.csi_scans.Scan.ROI.tile_cols": {"tf": 1}}, "df": 1}}, "p": {"docs": {}, "df": 0, "y": {"docs": {"csi_images.csi_events.EventArray.copy": {"tf": 1}, "tests.test_events.test_copy_sort_rows_get": {"tf": 1}}, "df": 2}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"tests.test_events.test_event_coordinates_for_bzscanner": {"tf": 1}, "tests.test_events.test_event_coordinates_for_axioscan": {"tf": 1}}, "df": 2}}}}}}}}}, "n": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"tests.test_events.test_eventarray_conversions": {"tf": 1}, "tests.test_events.test_ocular_conversions": {"tf": 1}}, "df": 2}}}}}}}}}}, "s": {"docs": {}, "df": 0, "v": {"docs": {"csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_csv": {"tf": 1}}, "df": 2}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"tests.test_frames.test_checking_frames": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_scans.Scan.BZSCANNER_CHANNEL_MAP": {"tf": 1}, "csi_images.csi_scans.Scan.Channel": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.name": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.exposure_ms": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.intensity": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_names": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}}, "df": 9, "s": {"docs": {"csi_images.csi_scans.Scan.channels": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {"csi_images.csi_scans.Scan.camera": {"tf": 1}}, "df": 1}}}}}, "z": {"docs": {}, "df": 0, "i": {"docs": {"csi_images.csi_scans.Scan.load_czi": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}}, "df": 2}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_events.EventArray.load_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_czi": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}, "examples.scan_examples.load_in_images": {"tf": 1}}, "df": 8}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_scans.Scan.ROI.origin_x_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.origin_y_um": {"tf": 1}}, "df": 2}}}}}, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}, "tests.test_events.test_ocular_conversions": {"tf": 1}}, "df": 3}}}}}, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.objective": {"tf": 1}}, "df": 1}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"csi_images.csi_scans.Scan.tile_overlap_proportion": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}}, "df": 2}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}}, "df": 1, "s": {"docs": {"csi_images.csi_events.EventArray.rows": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.tile_rows": {"tf": 1}, "tests.test_events.test_copy_sort_rows_get": {"tf": 1}}, "df": 3}}, "i": {"docs": {"csi_images.csi_scans.Scan.ROI": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.origin_x_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.origin_y_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.width_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.height_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.tile_rows": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.tile_cols": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.focus_points": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.similar": {"tf": 1}, "csi_images.csi_scans.Scan.roi": {"tf": 1}, "csi_images.csi_tiles.Tile.n_roi": {"tf": 1}}, "df": 13}}, "g": {"docs": {}, "df": 0, "b": {"docs": {"csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_images.make_rgb": {"tf": 1}, "tests.test_frames.test_make_rgb": {"tf": 1}}, "df": 3}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}}, "df": 2}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_frames.Frame.check_all_images": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "tests.test_examples.test_all_examples": {"tf": 1}}, "df": 3}}, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"7": {"docs": {"csi_images.csi_scans.Scan.Type.AXIOSCAN7": {"tf": 1}}, "df": 1}, "docs": {"tests.test_events.test_event_coordinates_for_axioscan": {"tf": 1}, "tests.test_tiles.test_axioscan_tiles": {"tf": 1}}, "df": 2}}}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1}, "tests.test_scans.test_names_and_indices": {"tf": 1}}, "df": 2}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray.to_dataframe": {"tf": 1}, "csi_images.csi_events.EventArray.from_dataframe": {"tf": 1}}, "df": 2}}}}}}, "e": {"docs": {"csi_images.csi_scans.Scan.start_date": {"tf": 1}, "csi_images.csi_scans.Scan.end_date": {"tf": 1}}, "df": 2, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.DATETIME_FORMAT": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_scans.Scan.to_dict": {"tf": 1}, "csi_images.csi_scans.Scan.from_dict": {"tf": 1}}, "df": 2}}}}, "h": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "f": {"5": {"docs": {"csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}}, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_scans.Scan.ROI.height_um": {"tf": 1}, "csi_images.csi_scans.Scan.tile_height_px": {"tf": 1}}, "df": 2}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_scans.Scan.has_same_profile": {"tf": 1}}, "df": 1}}}, "n": {"docs": {"csi_images.csi_tiles.Tile.n_roi": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}}, "df": 3, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_frames.Frame.get_file_name": {"tf": 1}, "csi_images.csi_scans.Scan.METADATA_FILE_NAME": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.name": {"tf": 1}}, "df": 3, "s": {"docs": {"csi_images.csi_scans.Scan.get_channel_names": {"tf": 1}, "tests.test_scans.test_names_and_indices": {"tf": 1}}, "df": 2}}}}}, "b": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_scans.Scan.Type.BZSCANNER": {"tf": 1}, "csi_images.csi_scans.Scan.BZSCANNER_CHANNEL_MAP": {"tf": 1}, "tests.test_events.test_event_coordinates_for_bzscanner": {"tf": 1}, "tests.test_tiles.test_bzscanner_tiles": {"tf": 1}}, "df": 4}}}}}}}}, "y": {"docs": {"csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 2}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {"csi_images.csi_scans.Scan.ROI.origin_x_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.origin_y_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.width_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.height_um": {"tf": 1}, "csi_images.csi_scans.Scan.pixel_size_um": {"tf": 1}}, "df": 5}}, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"csi_images.csi_scans.Scan.ROI.width_um": {"tf": 1}, "csi_images.csi_scans.Scan.tile_width_px": {"tf": 1}}, "df": 2}}}}}}}, "fullname": {"root": {"docs": {"csi_images.csi_events.Event.__init__": {"tf": 1}, "csi_images.csi_events.EventArray.__init__": {"tf": 1}, "csi_images.csi_frames.Frame.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.__init__": {"tf": 1}, "csi_images.csi_tiles.Tile.__init__": {"tf": 1}}, "df": 7, "c": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.__init__": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.scan": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.tile": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.x": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.y": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.size": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.metadata": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.features": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.get_scan_position": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.get_slide_position": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.crop_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.__init__": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.INFO_COLUMNS": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.info": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.metadata": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.features": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.sort": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.get": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.rows": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.copy": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.add_features": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.merge": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.to_events": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_events": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.to_dataframe": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_dataframe": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.save_csv": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.load_csv": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1.4142135623730951}, "csi_images.csi_frames": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.__init__": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.scan": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.tile": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_image": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.check_image": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1.4142135623730951}, "csi_images.csi_images": {"tf": 1.4142135623730951}, "csi_images.csi_images.extract_mask_info": {"tf": 1.4142135623730951}, "csi_images.csi_images.make_rgb": {"tf": 1.4142135623730951}, "csi_images.csi_scans": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.__init__": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.yaml_tag": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.Type": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.Type.BZSCANNER": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.Type.AXIOSCAN7": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.SCANNER_IDS": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.METADATA_FILE_NAME": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.DATETIME_FORMAT": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.BZSCANNER_CHANNEL_MAP": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.Channel": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.Channel.__init__": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.Channel.yaml_tag": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.Channel.name": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.Channel.exposure_ms": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.Channel.intensity": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.ROI": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.ROI.__init__": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.ROI.yaml_tag": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.ROI.origin_x_um": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.ROI.origin_y_um": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.ROI.width_um": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.ROI.height_um": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.ROI.tile_rows": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.ROI.tile_cols": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.ROI.focus_points": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.ROI.similar": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.slide_id": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.path": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.start_date": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.end_date": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.scan_time_s": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.scanner_id": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.tray": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.slot": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.camera": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.objective": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.pixel_size_um": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.tile_width_px": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.tile_height_px": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.tile_overlap_proportion": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.channels": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.roi": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.has_same_profile": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.get_channel_names": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.to_dict": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.from_dict": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.load_czi": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1.4142135623730951}, "csi_images.csi_tiles": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.__init__": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.scan": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.n_roi": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1.4142135623730951}, "csi_images.ocular_files": {"tf": 1}, "csi_images.ocular_files.FRAME_INFO_FILE": {"tf": 1}, "csi_images.ocular_files.FRAME_MORPHOMETRICS_FILES": {"tf": 1}, "csi_images.ocular_files.SLIDE_MORPHOMETRICS_FILE": {"tf": 1}, "csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}, "csi_images.ocular_files.merge_statistics": {"tf": 1}, "csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1}}, "df": 136}, "v": {"docs": {"csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_csv": {"tf": 1}}, "df": 2}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}}, "df": 1, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.EventArray.INFO_COLUMNS": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"csi_images.csi_scans.Scan.ROI.tile_cols": {"tf": 1}}, "df": 1}}, "p": {"docs": {}, "df": 0, "y": {"docs": {"csi_images.csi_events.EventArray.copy": {"tf": 1}, "tests.test_events.test_copy_sort_rows_get": {"tf": 1}}, "df": 2}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"tests.compare_cv2_tifffile": {"tf": 1}, "tests.compare_cv2_tifffile.main": {"tf": 1}}, "df": 2}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"tests.test_events.test_event_coordinates_for_bzscanner": {"tf": 1}, "tests.test_events.test_event_coordinates_for_axioscan": {"tf": 1}}, "df": 2}}}}}}}}}, "n": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"tests.test_events.test_eventarray_conversions": {"tf": 1}, "tests.test_events.test_ocular_conversions": {"tf": 1}}, "df": 2}}}}}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"tests.test_frames.test_checking_frames": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_scans.Scan.BZSCANNER_CHANNEL_MAP": {"tf": 1}, "csi_images.csi_scans.Scan.Channel": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.name": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.exposure_ms": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.intensity": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_names": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}}, "df": 9, "s": {"docs": {"csi_images.csi_scans.Scan.channels": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {"csi_images.csi_scans.Scan.camera": {"tf": 1}}, "df": 1}}}}}, "z": {"docs": {}, "df": 0, "i": {"docs": {"csi_images.csi_scans.Scan.load_czi": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}}, "df": 2}}}}, "v": {"2": {"docs": {"tests.compare_cv2_tifffile": {"tf": 1}, "tests.compare_cv2_tifffile.main": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}}, "df": 3, "s": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events": {"tf": 1}, "csi_images.csi_events.Event": {"tf": 1}, "csi_images.csi_events.Event.__init__": {"tf": 1}, "csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}, "csi_images.csi_events.Event.scan": {"tf": 1}, "csi_images.csi_events.Event.tile": {"tf": 1}, "csi_images.csi_events.Event.x": {"tf": 1}, "csi_images.csi_events.Event.y": {"tf": 1}, "csi_images.csi_events.Event.size": {"tf": 1}, "csi_images.csi_events.Event.metadata": {"tf": 1}, "csi_images.csi_events.Event.features": {"tf": 1}, "csi_images.csi_events.Event.get_scan_position": {"tf": 1}, "csi_images.csi_events.Event.get_slide_position": {"tf": 1}, "csi_images.csi_events.Event.crop_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray": {"tf": 1}, "csi_images.csi_events.EventArray.__init__": {"tf": 1}, "csi_images.csi_events.EventArray.INFO_COLUMNS": {"tf": 1}, "csi_images.csi_events.EventArray.info": {"tf": 1}, "csi_images.csi_events.EventArray.metadata": {"tf": 1}, "csi_images.csi_events.EventArray.features": {"tf": 1}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.sort": {"tf": 1}, "csi_images.csi_events.EventArray.get": {"tf": 1}, "csi_images.csi_events.EventArray.rows": {"tf": 1}, "csi_images.csi_events.EventArray.copy": {"tf": 1}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}, "csi_images.csi_events.EventArray.merge": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_events.EventArray.from_events": {"tf": 1}, "csi_images.csi_events.EventArray.to_dataframe": {"tf": 1}, "csi_images.csi_events.EventArray.from_dataframe": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_csv": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}, "csi_images.csi_frames": {"tf": 1}, "csi_images.csi_frames.Frame": {"tf": 1}, "csi_images.csi_frames.Frame.__init__": {"tf": 1}, "csi_images.csi_frames.Frame.scan": {"tf": 1}, "csi_images.csi_frames.Frame.tile": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_images": {"tf": 1.4142135623730951}, "csi_images.csi_images.extract_mask_info": {"tf": 1.4142135623730951}, "csi_images.csi_images.make_rgb": {"tf": 1.4142135623730951}, "csi_images.csi_scans": {"tf": 1}, "csi_images.csi_scans.Scan": {"tf": 1}, "csi_images.csi_scans.Scan.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.Type": {"tf": 1}, "csi_images.csi_scans.Scan.Type.BZSCANNER": {"tf": 1}, "csi_images.csi_scans.Scan.Type.AXIOSCAN7": {"tf": 1}, "csi_images.csi_scans.Scan.SCANNER_IDS": {"tf": 1}, "csi_images.csi_scans.Scan.METADATA_FILE_NAME": {"tf": 1}, "csi_images.csi_scans.Scan.DATETIME_FORMAT": {"tf": 1}, "csi_images.csi_scans.Scan.BZSCANNER_CHANNEL_MAP": {"tf": 1}, "csi_images.csi_scans.Scan.Channel": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.name": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.exposure_ms": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.intensity": {"tf": 1}, "csi_images.csi_scans.Scan.ROI": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.origin_x_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.origin_y_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.width_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.height_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.tile_rows": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.tile_cols": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.focus_points": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.similar": {"tf": 1}, "csi_images.csi_scans.Scan.slide_id": {"tf": 1}, "csi_images.csi_scans.Scan.path": {"tf": 1}, "csi_images.csi_scans.Scan.start_date": {"tf": 1}, "csi_images.csi_scans.Scan.end_date": {"tf": 1}, "csi_images.csi_scans.Scan.scan_time_s": {"tf": 1}, "csi_images.csi_scans.Scan.scanner_id": {"tf": 1}, "csi_images.csi_scans.Scan.tray": {"tf": 1}, "csi_images.csi_scans.Scan.slot": {"tf": 1}, "csi_images.csi_scans.Scan.camera": {"tf": 1}, "csi_images.csi_scans.Scan.objective": {"tf": 1}, "csi_images.csi_scans.Scan.pixel_size_um": {"tf": 1}, "csi_images.csi_scans.Scan.tile_width_px": {"tf": 1}, "csi_images.csi_scans.Scan.tile_height_px": {"tf": 1}, "csi_images.csi_scans.Scan.tile_overlap_proportion": {"tf": 1}, "csi_images.csi_scans.Scan.channels": {"tf": 1}, "csi_images.csi_scans.Scan.roi": {"tf": 1}, "csi_images.csi_scans.Scan.has_same_profile": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_names": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.to_dict": {"tf": 1}, "csi_images.csi_scans.Scan.from_dict": {"tf": 1}, "csi_images.csi_scans.Scan.load_czi": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}, "csi_images.csi_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile": {"tf": 1}, "csi_images.csi_tiles.Tile.__init__": {"tf": 1}, "csi_images.csi_tiles.Tile.scan": {"tf": 1}, "csi_images.csi_tiles.Tile.n_roi": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}, "csi_images.ocular_files": {"tf": 1}, "csi_images.ocular_files.FRAME_INFO_FILE": {"tf": 1}, "csi_images.ocular_files.FRAME_MORPHOMETRICS_FILES": {"tf": 1}, "csi_images.ocular_files.SLIDE_MORPHOMETRICS_FILE": {"tf": 1}, "csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}, "csi_images.ocular_files.merge_statistics": {"tf": 1}, "csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1}, "examples.scan_examples.load_in_images": {"tf": 1}}, "df": 137}}}}}, "n": {"docs": {"examples.scan_examples.load_in_images": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.Event.__init__": {"tf": 1}, "csi_images.csi_events.EventArray.__init__": {"tf": 1}, "csi_images.csi_frames.Frame.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.__init__": {"tf": 1}, "csi_images.csi_tiles.Tile.__init__": {"tf": 1}}, "df": 7}}, "f": {"docs": {}, "df": 0, "o": {"docs": {"csi_images.csi_events.EventArray.INFO_COLUMNS": {"tf": 1}, "csi_images.csi_events.EventArray.info": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1}, "csi_images.ocular_files.FRAME_INFO_FILE": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1}}, "df": 5}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"csi_images.csi_scans.Scan.Channel.intensity": {"tf": 1}}, "df": 1}}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "tests.test_scans.test_names_and_indices": {"tf": 1}}, "df": 2}}}}}}, "d": {"docs": {"csi_images.csi_scans.Scan.slide_id": {"tf": 1}, "csi_images.csi_scans.Scan.scanner_id": {"tf": 1}}, "df": 2, "s": {"docs": {"csi_images.csi_scans.Scan.SCANNER_IDS": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.Event": {"tf": 1}, "csi_images.csi_events.Event.__init__": {"tf": 1}, "csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}, "csi_images.csi_events.Event.scan": {"tf": 1}, "csi_images.csi_events.Event.tile": {"tf": 1}, "csi_images.csi_events.Event.x": {"tf": 1}, "csi_images.csi_events.Event.y": {"tf": 1}, "csi_images.csi_events.Event.size": {"tf": 1}, "csi_images.csi_events.Event.metadata": {"tf": 1}, "csi_images.csi_events.Event.features": {"tf": 1}, "csi_images.csi_events.Event.get_scan_position": {"tf": 1}, "csi_images.csi_events.Event.get_slide_position": {"tf": 1}, "csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "tests.test_events.test_getting_event": {"tf": 1}, "tests.test_events.test_event_coordinates_for_bzscanner": {"tf": 1}, "tests.test_events.test_event_coordinates_for_axioscan": {"tf": 1}}, "df": 18, "s": {"docs": {"csi_images.csi_events": {"tf": 1}, "csi_images.csi_events.Event": {"tf": 1}, "csi_images.csi_events.Event.__init__": {"tf": 1}, "csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}, "csi_images.csi_events.Event.scan": {"tf": 1}, "csi_images.csi_events.Event.tile": {"tf": 1}, "csi_images.csi_events.Event.x": {"tf": 1}, "csi_images.csi_events.Event.y": {"tf": 1}, "csi_images.csi_events.Event.size": {"tf": 1}, "csi_images.csi_events.Event.metadata": {"tf": 1}, "csi_images.csi_events.Event.features": {"tf": 1}, "csi_images.csi_events.Event.get_scan_position": {"tf": 1}, "csi_images.csi_events.Event.get_slide_position": {"tf": 1}, "csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_events.EventArray": {"tf": 1}, "csi_images.csi_events.EventArray.__init__": {"tf": 1}, "csi_images.csi_events.EventArray.INFO_COLUMNS": {"tf": 1}, "csi_images.csi_events.EventArray.info": {"tf": 1}, "csi_images.csi_events.EventArray.metadata": {"tf": 1}, "csi_images.csi_events.EventArray.features": {"tf": 1}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.sort": {"tf": 1}, "csi_images.csi_events.EventArray.get": {"tf": 1}, "csi_images.csi_events.EventArray.rows": {"tf": 1}, "csi_images.csi_events.EventArray.copy": {"tf": 1}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}, "csi_images.csi_events.EventArray.merge": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_events": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.to_dataframe": {"tf": 1}, "csi_images.csi_events.EventArray.from_dataframe": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_csv": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}, "tests.test_events": {"tf": 1}, "tests.test_events.test_getting_event": {"tf": 1}, "tests.test_events.test_getting_many_events": {"tf": 1.4142135623730951}, "tests.test_events.test_event_coordinates_for_bzscanner": {"tf": 1}, "tests.test_events.test_event_coordinates_for_axioscan": {"tf": 1}, "tests.test_events.test_eventarray_conversions": {"tf": 1}, "tests.test_events.test_ocular_conversions": {"tf": 1}, "tests.test_events.test_copy_sort_rows_get": {"tf": 1}}, "df": 49}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {"csi_images.csi_events.EventArray": {"tf": 1}, "csi_images.csi_events.EventArray.__init__": {"tf": 1}, "csi_images.csi_events.EventArray.INFO_COLUMNS": {"tf": 1}, "csi_images.csi_events.EventArray.info": {"tf": 1}, "csi_images.csi_events.EventArray.metadata": {"tf": 1}, "csi_images.csi_events.EventArray.features": {"tf": 1}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.sort": {"tf": 1}, "csi_images.csi_events.EventArray.get": {"tf": 1}, "csi_images.csi_events.EventArray.rows": {"tf": 1}, "csi_images.csi_events.EventArray.copy": {"tf": 1}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}, "csi_images.csi_events.EventArray.merge": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_events.EventArray.from_events": {"tf": 1}, "csi_images.csi_events.EventArray.to_dataframe": {"tf": 1}, "csi_images.csi_events.EventArray.from_dataframe": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_csv": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}, "tests.test_events.test_eventarray_conversions": {"tf": 1}}, "df": 26}}}}}}}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1}}, "df": 3}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.Channel.exposure_ms": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"examples": {"tf": 1}, "examples.scan_examples": {"tf": 1.4142135623730951}, "examples.scan_examples.load_in_images": {"tf": 1.4142135623730951}, "tests.test_examples": {"tf": 1}, "tests.test_examples.test_all_examples": {"tf": 1.4142135623730951}}, "df": 5}}}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_scans.Scan.end_date": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"csi_images.csi_scans.Scan.scan_time_s": {"tf": 1}}, "df": 1, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}, "csi_images.csi_events.Event.scan": {"tf": 1}, "csi_images.csi_events.Event.get_scan_position": {"tf": 1}, "csi_images.csi_frames.Frame.scan": {"tf": 1}, "csi_images.csi_scans.Scan": {"tf": 1}, "csi_images.csi_scans.Scan.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.Type": {"tf": 1}, "csi_images.csi_scans.Scan.Type.BZSCANNER": {"tf": 1}, "csi_images.csi_scans.Scan.Type.AXIOSCAN7": {"tf": 1}, "csi_images.csi_scans.Scan.SCANNER_IDS": {"tf": 1}, "csi_images.csi_scans.Scan.METADATA_FILE_NAME": {"tf": 1}, "csi_images.csi_scans.Scan.DATETIME_FORMAT": {"tf": 1}, "csi_images.csi_scans.Scan.BZSCANNER_CHANNEL_MAP": {"tf": 1}, "csi_images.csi_scans.Scan.Channel": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.name": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.exposure_ms": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.intensity": {"tf": 1}, "csi_images.csi_scans.Scan.ROI": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.origin_x_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.origin_y_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.width_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.height_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.tile_rows": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.tile_cols": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.focus_points": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.similar": {"tf": 1}, "csi_images.csi_scans.Scan.slide_id": {"tf": 1}, "csi_images.csi_scans.Scan.path": {"tf": 1}, "csi_images.csi_scans.Scan.start_date": {"tf": 1}, "csi_images.csi_scans.Scan.end_date": {"tf": 1}, "csi_images.csi_scans.Scan.scan_time_s": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.scanner_id": {"tf": 1}, "csi_images.csi_scans.Scan.tray": {"tf": 1}, "csi_images.csi_scans.Scan.slot": {"tf": 1}, "csi_images.csi_scans.Scan.camera": {"tf": 1}, "csi_images.csi_scans.Scan.objective": {"tf": 1}, "csi_images.csi_scans.Scan.pixel_size_um": {"tf": 1}, "csi_images.csi_scans.Scan.tile_width_px": {"tf": 1}, "csi_images.csi_scans.Scan.tile_height_px": {"tf": 1}, "csi_images.csi_scans.Scan.tile_overlap_proportion": {"tf": 1}, "csi_images.csi_scans.Scan.channels": {"tf": 1}, "csi_images.csi_scans.Scan.roi": {"tf": 1}, "csi_images.csi_scans.Scan.has_same_profile": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_names": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.to_dict": {"tf": 1}, "csi_images.csi_scans.Scan.from_dict": {"tf": 1}, "csi_images.csi_scans.Scan.load_czi": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}, "csi_images.csi_tiles.Tile.scan": {"tf": 1}, "examples.scan_examples": {"tf": 1}, "examples.scan_examples.load_in_images": {"tf": 1}}, "df": 61, "s": {"docs": {"csi_images.csi_scans": {"tf": 1}, "csi_images.csi_scans.Scan": {"tf": 1}, "csi_images.csi_scans.Scan.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.Type": {"tf": 1}, "csi_images.csi_scans.Scan.Type.BZSCANNER": {"tf": 1}, "csi_images.csi_scans.Scan.Type.AXIOSCAN7": {"tf": 1}, "csi_images.csi_scans.Scan.SCANNER_IDS": {"tf": 1}, "csi_images.csi_scans.Scan.METADATA_FILE_NAME": {"tf": 1}, "csi_images.csi_scans.Scan.DATETIME_FORMAT": {"tf": 1}, "csi_images.csi_scans.Scan.BZSCANNER_CHANNEL_MAP": {"tf": 1}, "csi_images.csi_scans.Scan.Channel": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.name": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.exposure_ms": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.intensity": {"tf": 1}, "csi_images.csi_scans.Scan.ROI": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.origin_x_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.origin_y_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.width_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.height_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.tile_rows": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.tile_cols": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.focus_points": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.similar": {"tf": 1}, "csi_images.csi_scans.Scan.slide_id": {"tf": 1}, "csi_images.csi_scans.Scan.path": {"tf": 1}, "csi_images.csi_scans.Scan.start_date": {"tf": 1}, "csi_images.csi_scans.Scan.end_date": {"tf": 1}, "csi_images.csi_scans.Scan.scan_time_s": {"tf": 1}, "csi_images.csi_scans.Scan.scanner_id": {"tf": 1}, "csi_images.csi_scans.Scan.tray": {"tf": 1}, "csi_images.csi_scans.Scan.slot": {"tf": 1}, "csi_images.csi_scans.Scan.camera": {"tf": 1}, "csi_images.csi_scans.Scan.objective": {"tf": 1}, "csi_images.csi_scans.Scan.pixel_size_um": {"tf": 1}, "csi_images.csi_scans.Scan.tile_width_px": {"tf": 1}, "csi_images.csi_scans.Scan.tile_height_px": {"tf": 1}, "csi_images.csi_scans.Scan.tile_overlap_proportion": {"tf": 1}, "csi_images.csi_scans.Scan.channels": {"tf": 1}, "csi_images.csi_scans.Scan.roi": {"tf": 1}, "csi_images.csi_scans.Scan.has_same_profile": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_names": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.to_dict": {"tf": 1}, "csi_images.csi_scans.Scan.from_dict": {"tf": 1}, "csi_images.csi_scans.Scan.load_czi": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}, "tests.test_scans": {"tf": 1}, "tests.test_scans.test_from_yaml": {"tf": 1}, "tests.test_scans.test_from_txt": {"tf": 1}, "tests.test_scans.test_names_and_indices": {"tf": 1}}, "df": 59}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_scans.Scan.SCANNER_IDS": {"tf": 1}, "csi_images.csi_scans.Scan.scanner_id": {"tf": 1}}, "df": 2}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}, "csi_images.csi_events.Event.get_slide_position": {"tf": 1}, "csi_images.csi_scans.Scan.slide_id": {"tf": 1}, "csi_images.ocular_files.SLIDE_MORPHOMETRICS_FILE": {"tf": 1}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}}, "df": 5}}}, "o": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_scans.Scan.slot": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.Event.size": {"tf": 1}, "csi_images.csi_scans.Scan.pixel_size_um": {"tf": 1}}, "df": 2}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_scans.Scan.ROI.similar": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.sort": {"tf": 1}, "tests.test_events.test_copy_sort_rows_get": {"tf": 1}}, "df": 3}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}}, "df": 6}}, "m": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.has_same_profile": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_scans.Scan.start_date": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.ocular_files.get_frame_statistics": {"tf": 1}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}, "csi_images.ocular_files.merge_statistics": {"tf": 1}, "csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1}}, "df": 4}}}}}}}}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_events.EventArray.to_dataframe": {"tf": 1}, "csi_images.csi_scans.Scan.to_dict": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}}, "df": 6}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}}, "df": 1}}}}}}, "y": {"docs": {"csi_images.csi_scans.Scan.tray": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.Event.tile": {"tf": 1}, "csi_images.csi_frames.Frame.tile": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.tile_rows": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.tile_cols": {"tf": 1}, "csi_images.csi_scans.Scan.tile_width_px": {"tf": 1}, "csi_images.csi_scans.Scan.tile_height_px": {"tf": 1}, "csi_images.csi_scans.Scan.tile_overlap_proportion": {"tf": 1}, "csi_images.csi_tiles.Tile": {"tf": 1}, "csi_images.csi_tiles.Tile.__init__": {"tf": 1}, "csi_images.csi_tiles.Tile.scan": {"tf": 1}, "csi_images.csi_tiles.Tile.n_roi": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 16, "s": {"docs": {"csi_images.csi_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile": {"tf": 1}, "csi_images.csi_tiles.Tile.__init__": {"tf": 1}, "csi_images.csi_tiles.Tile.scan": {"tf": 1}, "csi_images.csi_tiles.Tile.n_roi": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1.4142135623730951}, "tests.test_tiles": {"tf": 1}, "tests.test_tiles.test_axioscan_tiles": {"tf": 1.4142135623730951}, "tests.test_tiles.test_bzscanner_tiles": {"tf": 1.4142135623730951}, "tests.test_tiles.test_getting_tiles": {"tf": 1.4142135623730951}}, "df": 14}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.scan_time_s": {"tf": 1}}, "df": 1}}, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"tests.compare_cv2_tifffile": {"tf": 1}, "tests.compare_cv2_tifffile.main": {"tf": 1}}, "df": 2}}}}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_scans.Scan.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.yaml_tag": {"tf": 1}}, "df": 3}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.Type": {"tf": 1}, "csi_images.csi_scans.Scan.Type.BZSCANNER": {"tf": 1}, "csi_images.csi_scans.Scan.Type.AXIOSCAN7": {"tf": 1}}, "df": 3}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_scans.Scan.load_txt": {"tf": 1}, "tests.test_scans.test_from_txt": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"tests.test_events": {"tf": 1}, "tests.test_events.test_getting_event": {"tf": 1.4142135623730951}, "tests.test_events.test_getting_many_events": {"tf": 1.4142135623730951}, "tests.test_events.test_event_coordinates_for_bzscanner": {"tf": 1.4142135623730951}, "tests.test_events.test_event_coordinates_for_axioscan": {"tf": 1.4142135623730951}, "tests.test_events.test_eventarray_conversions": {"tf": 1.4142135623730951}, "tests.test_events.test_ocular_conversions": {"tf": 1.4142135623730951}, "tests.test_events.test_copy_sort_rows_get": {"tf": 1.4142135623730951}, "tests.test_examples": {"tf": 1}, "tests.test_examples.test_all_examples": {"tf": 1.4142135623730951}, "tests.test_frames": {"tf": 1}, "tests.test_frames.test_getting_frames": {"tf": 1.4142135623730951}, "tests.test_frames.test_checking_frames": {"tf": 1.4142135623730951}, "tests.test_frames.test_make_rgb": {"tf": 1.4142135623730951}, "tests.test_scans": {"tf": 1}, "tests.test_scans.test_from_yaml": {"tf": 1.4142135623730951}, "tests.test_scans.test_from_txt": {"tf": 1.4142135623730951}, "tests.test_scans.test_names_and_indices": {"tf": 1.4142135623730951}, "tests.test_tiles": {"tf": 1}, "tests.test_tiles.test_axioscan_tiles": {"tf": 1.4142135623730951}, "tests.test_tiles.test_bzscanner_tiles": {"tf": 1.4142135623730951}, "tests.test_tiles.test_getting_tiles": {"tf": 1.4142135623730951}}, "df": 22, "s": {"docs": {"tests": {"tf": 1}, "tests.compare_cv2_tifffile": {"tf": 1}, "tests.compare_cv2_tifffile.main": {"tf": 1}, "tests.test_events": {"tf": 1}, "tests.test_events.test_getting_event": {"tf": 1}, "tests.test_events.test_getting_many_events": {"tf": 1}, "tests.test_events.test_event_coordinates_for_bzscanner": {"tf": 1}, "tests.test_events.test_event_coordinates_for_axioscan": {"tf": 1}, "tests.test_events.test_eventarray_conversions": {"tf": 1}, "tests.test_events.test_ocular_conversions": {"tf": 1}, "tests.test_events.test_copy_sort_rows_get": {"tf": 1}, "tests.test_examples": {"tf": 1}, "tests.test_examples.test_all_examples": {"tf": 1}, "tests.test_frames": {"tf": 1}, "tests.test_frames.test_getting_frames": {"tf": 1}, "tests.test_frames.test_checking_frames": {"tf": 1}, "tests.test_frames.test_make_rgb": {"tf": 1}, "tests.test_scans": {"tf": 1}, "tests.test_scans.test_from_yaml": {"tf": 1}, "tests.test_scans.test_from_txt": {"tf": 1}, "tests.test_scans.test_names_and_indices": {"tf": 1}, "tests.test_tiles": {"tf": 1}, "tests.test_tiles.test_axioscan_tiles": {"tf": 1}, "tests.test_tiles.test_bzscanner_tiles": {"tf": 1}, "tests.test_tiles.test_getting_tiles": {"tf": 1}}, "df": 25}}}}}, "x": {"docs": {"csi_images.csi_events.Event.x": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.origin_x_um": {"tf": 1}}, "df": 2, "y": {"docs": {"csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 1}}, "y": {"docs": {"csi_images.csi_events.Event.y": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.origin_y_um": {"tf": 1}}, "df": 2, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_scans.Scan.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1}, "tests.test_scans.test_from_yaml": {"tf": 1}}, "df": 6}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"csi_images.csi_events.Event.metadata": {"tf": 1}, "csi_images.csi_events.EventArray.metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_scans.Scan.METADATA_FILE_NAME": {"tf": 1}}, "df": 4}}}}}}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray.merge": {"tf": 1}, "csi_images.ocular_files.merge_statistics": {"tf": 1}}, "df": 2}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "k": {"docs": {"csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1}}, "df": 2}}, "k": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_images.make_rgb": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}, "tests.test_frames.test_make_rgb": {"tf": 1}}, "df": 4}}, "p": {"docs": {"csi_images.csi_scans.Scan.BZSCANNER_CHANNEL_MAP": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "n": {"docs": {"tests.compare_cv2_tifffile.main": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "y": {"docs": {"tests.test_events.test_getting_many_events": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"csi_images.csi_scans.Scan.Channel.exposure_ms": {"tf": 1}}, "df": 1}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.ocular_files.FRAME_MORPHOMETRICS_FILES": {"tf": 1}, "csi_images.ocular_files.SLIDE_MORPHOMETRICS_FILE": {"tf": 1}}, "df": 2}}}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.Event.features": {"tf": 1}, "csi_images.csi_events.EventArray.features": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}}, "df": 3}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "tests.test_events.test_event_coordinates_for_bzscanner": {"tf": 1}, "tests.test_events.test_event_coordinates_for_axioscan": {"tf": 1}}, "df": 3, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_scans.Scan.DATETIME_FORMAT": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_scans.Scan.ROI.focus_points": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"csi_images.csi_events.EventArray.from_events": {"tf": 1}, "csi_images.csi_events.EventArray.from_dataframe": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_scans.Scan.from_dict": {"tf": 1}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}, "tests.test_scans.test_from_yaml": {"tf": 1}, "tests.test_scans.test_from_txt": {"tf": 1}}, "df": 7}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_frames.Frame": {"tf": 1}, "csi_images.csi_frames.Frame.__init__": {"tf": 1}, "csi_images.csi_frames.Frame.scan": {"tf": 1}, "csi_images.csi_frames.Frame.tile": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.ocular_files.FRAME_INFO_FILE": {"tf": 1}, "csi_images.ocular_files.FRAME_MORPHOMETRICS_FILES": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1}}, "df": 16, "s": {"docs": {"csi_images.csi_frames": {"tf": 1}, "csi_images.csi_frames.Frame": {"tf": 1}, "csi_images.csi_frames.Frame.__init__": {"tf": 1}, "csi_images.csi_frames.Frame.scan": {"tf": 1}, "csi_images.csi_frames.Frame.tile": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "tests.test_frames": {"tf": 1}, "tests.test_frames.test_getting_frames": {"tf": 1.4142135623730951}, "tests.test_frames.test_checking_frames": {"tf": 1.4142135623730951}, "tests.test_frames.test_make_rgb": {"tf": 1}}, "df": 17}}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1}, "csi_images.csi_scans.Scan.METADATA_FILE_NAME": {"tf": 1}, "csi_images.ocular_files.FRAME_INFO_FILE": {"tf": 1}, "csi_images.ocular_files.SLIDE_MORPHOMETRICS_FILE": {"tf": 1}}, "df": 5, "s": {"docs": {"csi_images.ocular_files": {"tf": 1}, "csi_images.ocular_files.FRAME_INFO_FILE": {"tf": 1}, "csi_images.ocular_files.FRAME_MORPHOMETRICS_FILES": {"tf": 1.4142135623730951}, "csi_images.ocular_files.SLIDE_MORPHOMETRICS_FILE": {"tf": 1}, "csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}, "csi_images.ocular_files.merge_statistics": {"tf": 1}, "csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1}}, "df": 13}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1}}, "df": 1}}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.Event.get_scan_position": {"tf": 1}, "csi_images.csi_events.Event.get_slide_position": {"tf": 1}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.get": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_names": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}, "csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}, "tests.test_events.test_copy_sort_rows_get": {"tf": 1}}, "df": 20, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"tests.test_events.test_getting_event": {"tf": 1}, "tests.test_events.test_getting_many_events": {"tf": 1}, "tests.test_frames.test_getting_frames": {"tf": 1}, "tests.test_tiles.test_getting_tiles": {"tf": 1}}, "df": 4}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1}}, "df": 1}}}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_events.Event.get_scan_position": {"tf": 1}, "csi_images.csi_events.Event.get_slide_position": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}}, "df": 4}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_scans.Scan.ROI.focus_points": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_scans.Scan.path": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_scans.Scan.pixel_size_um": {"tf": 1}}, "df": 1}}}}, "x": {"docs": {"csi_images.csi_scans.Scan.tile_width_px": {"tf": 1}, "csi_images.csi_scans.Scan.tile_height_px": {"tf": 1}}, "df": 2}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_scans.Scan.tile_overlap_proportion": {"tf": 1}}, "df": 1}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.has_same_profile": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}}, "df": 1}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_events.EventArray.load_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_czi": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}, "examples.scan_examples.load_in_images": {"tf": 1}}, "df": 8}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_scans.Scan.ROI.origin_x_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.origin_y_um": {"tf": 1}}, "df": 2}}}}}, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}, "csi_images.ocular_files": {"tf": 1}, "csi_images.ocular_files.FRAME_INFO_FILE": {"tf": 1}, "csi_images.ocular_files.FRAME_MORPHOMETRICS_FILES": {"tf": 1}, "csi_images.ocular_files.SLIDE_MORPHOMETRICS_FILE": {"tf": 1}, "csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}, "csi_images.ocular_files.merge_statistics": {"tf": 1}, "csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1}, "tests.test_events.test_ocular_conversions": {"tf": 1}}, "df": 16}}}}}, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.objective": {"tf": 1}}, "df": 1}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"csi_images.csi_scans.Scan.tile_overlap_proportion": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}}, "df": 2}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}}, "df": 1, "s": {"docs": {"csi_images.csi_events.EventArray.rows": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.tile_rows": {"tf": 1}, "tests.test_events.test_copy_sort_rows_get": {"tf": 1}}, "df": 3}}, "i": {"docs": {"csi_images.csi_scans.Scan.ROI": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.origin_x_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.origin_y_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.width_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.height_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.tile_rows": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.tile_cols": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.focus_points": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.similar": {"tf": 1}, "csi_images.csi_scans.Scan.roi": {"tf": 1}, "csi_images.csi_tiles.Tile.n_roi": {"tf": 1}}, "df": 13}}, "g": {"docs": {}, "df": 0, "b": {"docs": {"csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_images.make_rgb": {"tf": 1}, "tests.test_frames.test_make_rgb": {"tf": 1}}, "df": 3}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}}, "df": 2}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_frames.Frame.check_all_images": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "tests.test_examples.test_all_examples": {"tf": 1}}, "df": 3}}, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"7": {"docs": {"csi_images.csi_scans.Scan.Type.AXIOSCAN7": {"tf": 1}}, "df": 1}, "docs": {"tests.test_events.test_event_coordinates_for_axioscan": {"tf": 1}, "tests.test_tiles.test_axioscan_tiles": {"tf": 1}}, "df": 2}}}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1}, "tests.test_scans.test_names_and_indices": {"tf": 1}}, "df": 2}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray.to_dataframe": {"tf": 1}, "csi_images.csi_events.EventArray.from_dataframe": {"tf": 1}}, "df": 2}}}}}}, "e": {"docs": {"csi_images.csi_scans.Scan.start_date": {"tf": 1}, "csi_images.csi_scans.Scan.end_date": {"tf": 1}}, "df": 2, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.DATETIME_FORMAT": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_scans.Scan.to_dict": {"tf": 1}, "csi_images.csi_scans.Scan.from_dict": {"tf": 1}}, "df": 2}}}}, "h": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "f": {"5": {"docs": {"csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}}, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_scans.Scan.ROI.height_um": {"tf": 1}, "csi_images.csi_scans.Scan.tile_height_px": {"tf": 1}}, "df": 2}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_scans.Scan.has_same_profile": {"tf": 1}}, "df": 1}}}, "n": {"docs": {"csi_images.csi_tiles.Tile.n_roi": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}}, "df": 3, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_frames.Frame.get_file_name": {"tf": 1}, "csi_images.csi_scans.Scan.METADATA_FILE_NAME": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.name": {"tf": 1}}, "df": 3, "s": {"docs": {"csi_images.csi_scans.Scan.get_channel_names": {"tf": 1}, "tests.test_scans.test_names_and_indices": {"tf": 1}}, "df": 2}}}}}, "b": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_scans.Scan.Type.BZSCANNER": {"tf": 1}, "csi_images.csi_scans.Scan.BZSCANNER_CHANNEL_MAP": {"tf": 1}, "tests.test_events.test_event_coordinates_for_bzscanner": {"tf": 1}, "tests.test_tiles.test_bzscanner_tiles": {"tf": 1}}, "df": 4}}}}}}}}, "y": {"docs": {"csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 2}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {"csi_images.csi_scans.Scan.ROI.origin_x_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.origin_y_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.width_um": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.height_um": {"tf": 1}, "csi_images.csi_scans.Scan.pixel_size_um": {"tf": 1}}, "df": 5}}, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"csi_images.csi_scans.Scan.ROI.width_um": {"tf": 1}, "csi_images.csi_scans.Scan.tile_width_px": {"tf": 1}}, "df": 2}}}}}}}, "annotation": {"root": {"docs": {}, "df": 0}}, "default_value": {"root": {"0": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 3}, "csi_images.csi_scans.Scan.SCANNER_IDS": {"tf": 1}}, "df": 2}, "1": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 2.449489742783178}}, "df": 1}, "2": {"5": {"0": {"0": {"0": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "4": {"6": {"6": {"1": {"0": {"0": {"0": {"4": {"2": {"6": {"docs": {"csi_images.csi_scans.Scan.SCANNER_IDS": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "7": {"5": {"0": {"0": {"0": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1.4142135623730951}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 3.1622776601683795}, "csi_images.csi_events.EventArray.INFO_COLUMNS": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.yaml_tag": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.Type.BZSCANNER": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.Type.AXIOSCAN7": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.SCANNER_IDS": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.METADATA_FILE_NAME": {"tf": 2}, "csi_images.csi_scans.Scan.DATETIME_FORMAT": {"tf": 2}, "csi_images.csi_scans.Scan.BZSCANNER_CHANNEL_MAP": {"tf": 2.6457513110645907}, "csi_images.csi_scans.Scan.Channel.yaml_tag": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.ROI.yaml_tag": {"tf": 1.4142135623730951}, "csi_images.ocular_files.FRAME_INFO_FILE": {"tf": 1.4142135623730951}, "csi_images.ocular_files.FRAME_MORPHOMETRICS_FILES": {"tf": 1.4142135623730951}, "csi_images.ocular_files.SLIDE_MORPHOMETRICS_FILE": {"tf": 1.4142135623730951}}, "df": 14, "l": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.Type.BZSCANNER": {"tf": 1}, "csi_images.csi_scans.Scan.Type.AXIOSCAN7": {"tf": 1}, "csi_images.csi_scans.Scan.METADATA_FILE_NAME": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.DATETIME_FORMAT": {"tf": 1.4142135623730951}}, "df": 5}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.Type.BZSCANNER": {"tf": 1}, "csi_images.csi_scans.Scan.Type.AXIOSCAN7": {"tf": 1}, "csi_images.csi_scans.Scan.METADATA_FILE_NAME": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.DATETIME_FORMAT": {"tf": 1.4142135623730951}}, "df": 5}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray.INFO_COLUMNS": {"tf": 1}}, "df": 1}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_scans.Scan.METADATA_FILE_NAME": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {"csi_images.csi_scans.Scan.BZSCANNER_CHANNEL_MAP": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {"csi_images.csi_scans.Scan.DATETIME_FORMAT": {"tf": 1}}, "df": 1, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"7": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.Type.AXIOSCAN7": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.SCANNER_IDS": {"tf": 1}, "csi_images.csi_scans.Scan.METADATA_FILE_NAME": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.DATETIME_FORMAT": {"tf": 1.4142135623730951}}, "df": 5}, "docs": {}, "df": 0}}}}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1.4142135623730951}}, "df": 1}}}}, "f": {"4": {"8": {"8": {"docs": {"csi_images.csi_scans.Scan.BZSCANNER_CHANNEL_MAP": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "5": {"5": {"5": {"docs": {"csi_images.csi_scans.Scan.BZSCANNER_CHANNEL_MAP": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "6": {"4": {"7": {"docs": {"csi_images.csi_scans.Scan.BZSCANNER_CHANNEL_MAP": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "x": {"2": {"7": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 2}, "csi_images.csi_events.EventArray.INFO_COLUMNS": {"tf": 3.4641016151377544}, "csi_images.csi_scans.Scan.yaml_tag": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.Type.BZSCANNER": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.Type.AXIOSCAN7": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.SCANNER_IDS": {"tf": 2}, "csi_images.csi_scans.Scan.METADATA_FILE_NAME": {"tf": 2.8284271247461903}, "csi_images.csi_scans.Scan.DATETIME_FORMAT": {"tf": 2.8284271247461903}, "csi_images.csi_scans.Scan.BZSCANNER_CHANNEL_MAP": {"tf": 4.47213595499958}, "csi_images.csi_scans.Scan.Channel.yaml_tag": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.ROI.yaml_tag": {"tf": 1.4142135623730951}, "csi_images.ocular_files.FRAME_INFO_FILE": {"tf": 1.4142135623730951}, "csi_images.ocular_files.FRAME_MORPHOMETRICS_FILES": {"tf": 2}, "csi_images.ocular_files.SLIDE_MORPHOMETRICS_FILE": {"tf": 1.4142135623730951}}, "df": 14}, "docs": {}, "df": 0}, "docs": {"csi_images.csi_events.EventArray.INFO_COLUMNS": {"tf": 1}}, "df": 1}, "g": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.Type.BZSCANNER": {"tf": 1}, "csi_images.csi_scans.Scan.Type.AXIOSCAN7": {"tf": 1}, "csi_images.csi_scans.Scan.METADATA_FILE_NAME": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.DATETIME_FORMAT": {"tf": 1.4142135623730951}}, "df": 5}}, "b": {"docs": {"csi_images.csi_scans.Scan.DATETIME_FORMAT": {"tf": 1}}, "df": 1, "z": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.Type.BZSCANNER": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.METADATA_FILE_NAME": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.DATETIME_FORMAT": {"tf": 1.4142135623730951}}, "df": 4}}}}}}}}, "f": {"docs": {"csi_images.csi_scans.Scan.BZSCANNER_CHANNEL_MAP": {"tf": 1}}, "df": 1}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_scans.Scan.BZSCANNER_CHANNEL_MAP": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray.INFO_COLUMNS": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {"csi_images.csi_scans.Scan.METADATA_FILE_NAME": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.ocular_files.SLIDE_MORPHOMETRICS_FILE": {"tf": 1}}, "df": 1}}}}}}}}, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray.INFO_COLUMNS": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_scans.Scan.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.METADATA_FILE_NAME": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.yaml_tag": {"tf": 1}}, "df": 4, "s": {"docs": {"csi_images.csi_scans.Scan.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.yaml_tag": {"tf": 1}}, "df": 3}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_events.EventArray.INFO_COLUMNS": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {"csi_images.csi_events.EventArray.INFO_COLUMNS": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.yaml_tag": {"tf": 1}}, "df": 2}}}, "y": {"docs": {"csi_images.csi_events.EventArray.INFO_COLUMNS": {"tf": 1}, "csi_images.csi_scans.Scan.DATETIME_FORMAT": {"tf": 1.4142135623730951}}, "df": 2, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_scans.Scan.METADATA_FILE_NAME": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {"csi_images.csi_scans.Scan.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.yaml_tag": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.ROI.yaml_tag": {"tf": 1.4142135623730951}}, "df": 3}, "v": {"docs": {"csi_images.ocular_files.FRAME_INFO_FILE": {"tf": 1}, "csi_images.ocular_files.FRAME_MORPHOMETRICS_FILES": {"tf": 1.4142135623730951}, "csi_images.ocular_files.SLIDE_MORPHOMETRICS_FILE": {"tf": 1}}, "df": 3}}, "y": {"5": {"docs": {"csi_images.csi_scans.Scan.BZSCANNER_CHANNEL_MAP": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_scans.Scan.Channel.yaml_tag": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "c": {"docs": {"csi_images.ocular_files.SLIDE_MORPHOMETRICS_FILE": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_scans.Scan.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.yaml_tag": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.yaml_tag": {"tf": 1}}, "df": 3}}}}}, "m": {"docs": {"csi_images.csi_scans.Scan.DATETIME_FORMAT": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.ocular_files.FRAME_MORPHOMETRICS_FILES": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {"csi_images.csi_scans.Scan.DATETIME_FORMAT": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "%": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "%": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "%": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "%": {"docs": {}, "df": 0, "z": {"docs": {"csi_images.csi_scans.Scan.DATETIME_FORMAT": {"tf": 1}}, "df": 1}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"csi_images.csi_scans.Scan.BZSCANNER_CHANNEL_MAP": {"tf": 1.4142135623730951}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "v": {"docs": {"csi_images.ocular_files.FRAME_MORPHOMETRICS_FILES": {"tf": 1}}, "df": 1}}}, "h": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "%": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "%": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_scans.Scan.DATETIME_FORMAT": {"tf": 1}}, "df": 1}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {"csi_images.csi_scans.Scan.BZSCANNER_CHANNEL_MAP": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {"csi_images.ocular_files.FRAME_INFO_FILE": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.ocular_files.FRAME_MORPHOMETRICS_FILES": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}, "signature": {"root": {"0": {"docs": {"csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_scans.Scan.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.__init__": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}, "csi_images.csi_tiles.Tile.__init__": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 9}, "1": {"0": {"0": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "2": {"docs": {"csi_images.csi_events.Event.__init__": {"tf": 1}}, "df": 1}, "docs": {"csi_images.csi_scans.Scan.__init__": {"tf": 2.6457513110645907}, "csi_images.csi_scans.Scan.Channel.__init__": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.ROI.__init__": {"tf": 2.449489742783178}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}}, "df": 5}, "2": {"3": {"0": {"4": {"docs": {"csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "3": {"9": {"docs": {"csi_images.csi_events.EventArray.save_ocular": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 4.898979485566356}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.__init__": {"tf": 3.7416573867739413}, "csi_images.csi_scans.Scan.Channel.__init__": {"tf": 1.4142135623730951}}, "df": 6}, "docs": {}, "df": 0}, "docs": {"csi_images.csi_events.Event.__init__": {"tf": 11.180339887498949}, "csi_images.csi_events.Event.get_scan_position": {"tf": 4.69041575982343}, "csi_images.csi_events.Event.get_slide_position": {"tf": 4.69041575982343}, "csi_images.csi_events.Event.crop_images": {"tf": 8.366600265340756}, "csi_images.csi_events.Event.extract_images": {"tf": 7.211102550927978}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 9.1104335791443}, "csi_images.csi_events.EventArray.__init__": {"tf": 9.219544457292887}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 7.211102550927978}, "csi_images.csi_events.EventArray.sort": {"tf": 7.3484692283495345}, "csi_images.csi_events.EventArray.get": {"tf": 7.681145747868608}, "csi_images.csi_events.EventArray.rows": {"tf": 4}, "csi_images.csi_events.EventArray.copy": {"tf": 3.4641016151377544}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 7.14142842854285}, "csi_images.csi_events.EventArray.add_features": {"tf": 7.14142842854285}, "csi_images.csi_events.EventArray.merge": {"tf": 5.385164807134504}, "csi_images.csi_events.EventArray.to_events": {"tf": 9.38083151964686}, "csi_images.csi_events.EventArray.from_events": {"tf": 5.744562646538029}, "csi_images.csi_events.EventArray.to_dataframe": {"tf": 4.898979485566356}, "csi_images.csi_events.EventArray.from_dataframe": {"tf": 4}, "csi_images.csi_events.EventArray.from_mask": {"tf": 11.74734012447073}, "csi_images.csi_events.EventArray.save_csv": {"tf": 4.47213595499958}, "csi_images.csi_events.EventArray.load_csv": {"tf": 4.47213595499958}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 4.47213595499958}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 4.47213595499958}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 5.830951894845301}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 12.569805089976535}, "csi_images.csi_frames.Frame.__init__": {"tf": 7.211102550927978}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 6.48074069840786}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 5.291502622129181}, "csi_images.csi_frames.Frame.get_image": {"tf": 5.477225575051661}, "csi_images.csi_frames.Frame.check_image": {"tf": 5.0990195135927845}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 5.0990195135927845}, "csi_images.csi_frames.Frame.get_frames": {"tf": 8}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 10.816653826391969}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 8.660254037844387}, "csi_images.csi_images.extract_mask_info": {"tf": 9.848857801796104}, "csi_images.csi_images.make_rgb": {"tf": 7.54983443527075}, "csi_images.csi_scans.Scan.__init__": {"tf": 16.34013463836819}, "csi_images.csi_scans.Scan.Channel.__init__": {"tf": 7.3484692283495345}, "csi_images.csi_scans.Scan.ROI.__init__": {"tf": 11}, "csi_images.csi_scans.Scan.ROI.similar": {"tf": 3.7416573867739413}, "csi_images.csi_scans.Scan.has_same_profile": {"tf": 3.7416573867739413}, "csi_images.csi_scans.Scan.get_channel_names": {"tf": 4.123105625617661}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 5.916079783099616}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 4.242640687119285}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 4.47213595499958}, "csi_images.csi_scans.Scan.to_dict": {"tf": 3.4641016151377544}, "csi_images.csi_scans.Scan.from_dict": {"tf": 4}, "csi_images.csi_scans.Scan.load_czi": {"tf": 4.47213595499958}, "csi_images.csi_scans.Scan.load_txt": {"tf": 4.47213595499958}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 4.47213595499958}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 6.928203230275509}, "csi_images.csi_tiles.Tile.__init__": {"tf": 7.745966692414834}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 7.280109889280518}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 6.244997998398398}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 11.135528725660043}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 11.224972160321824}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 10.723805294763608}, "csi_images.ocular_files.get_cells": {"tf": 4.898979485566356}, "csi_images.ocular_files.get_others": {"tf": 4.898979485566356}, "csi_images.ocular_files.save_cells": {"tf": 5.477225575051661}, "csi_images.ocular_files.save_others": {"tf": 5.477225575051661}, "csi_images.ocular_files.get_frame_info": {"tf": 5.291502622129181}, "csi_images.ocular_files.get_frame_statistics": {"tf": 5.291502622129181}, "csi_images.ocular_files.get_slide_statistics": {"tf": 5.291502622129181}, "csi_images.ocular_files.merge_statistics": {"tf": 8.660254037844387}, "csi_images.ocular_files.filter_and_generate_statistics": {"tf": 8.54400374531753}, "examples.scan_examples.load_in_images": {"tf": 2.6457513110645907}, "tests.compare_cv2_tifffile.main": {"tf": 2.6457513110645907}, "tests.test_events.test_getting_event": {"tf": 2.6457513110645907}, "tests.test_events.test_getting_many_events": {"tf": 2.6457513110645907}, "tests.test_events.test_event_coordinates_for_bzscanner": {"tf": 2.6457513110645907}, "tests.test_events.test_event_coordinates_for_axioscan": {"tf": 2.6457513110645907}, "tests.test_events.test_eventarray_conversions": {"tf": 2.6457513110645907}, "tests.test_events.test_ocular_conversions": {"tf": 2.6457513110645907}, "tests.test_events.test_copy_sort_rows_get": {"tf": 2.6457513110645907}, "tests.test_examples.test_all_examples": {"tf": 2.6457513110645907}, "tests.test_frames.test_getting_frames": {"tf": 2.6457513110645907}, "tests.test_frames.test_checking_frames": {"tf": 2.6457513110645907}, "tests.test_frames.test_make_rgb": {"tf": 2.6457513110645907}, "tests.test_scans.test_from_yaml": {"tf": 2.6457513110645907}, "tests.test_scans.test_from_txt": {"tf": 2.6457513110645907}, "tests.test_scans.test_names_and_indices": {"tf": 2.6457513110645907}, "tests.test_tiles.test_axioscan_tiles": {"tf": 2.6457513110645907}, "tests.test_tiles.test_bzscanner_tiles": {"tf": 2.6457513110645907}, "tests.test_tiles.test_getting_tiles": {"tf": 2.6457513110645907}}, "df": 86, "s": {"docs": {"csi_images.csi_scans.Scan.__init__": {"tf": 1}}, "df": 1, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_events.Event.__init__": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.to_events": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.__init__": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.from_dict": {"tf": 1}, "csi_images.csi_tiles.Tile.__init__": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1.4142135623730951}}, "df": 11, "s": {"docs": {"csi_images.csi_events.Event.__init__": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 2}, "csi_images.csi_frames.Frame.__init__": {"tf": 1}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_tiles.Tile.__init__": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 9}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_scans.Scan.__init__": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.Event.__init__": {"tf": 1}, "csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_scans.Scan.__init__": {"tf": 1}}, "df": 5}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.Event.__init__": {"tf": 2}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.add_features": {"tf": 1.4142135623730951}}, "df": 3}}}}, "l": {"docs": {}, "df": 0, "f": {"docs": {"csi_images.csi_events.Event.get_scan_position": {"tf": 1}, "csi_images.csi_events.Event.get_slide_position": {"tf": 1}, "csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.sort": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.get": {"tf": 1}, "csi_images.csi_events.EventArray.rows": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.copy": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}, "csi_images.csi_events.EventArray.merge": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_events.EventArray.from_events": {"tf": 1}, "csi_images.csi_events.EventArray.to_dataframe": {"tf": 1}, "csi_images.csi_events.EventArray.from_dataframe": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_csv": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.ROI.similar": {"tf": 1}, "csi_images.csi_scans.Scan.has_same_profile": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_names": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.to_dict": {"tf": 1}, "csi_images.csi_scans.Scan.from_dict": {"tf": 1}, "csi_images.csi_scans.Scan.load_czi": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1.4142135623730951}}, "df": 47}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_events.EventArray.get_sort_order": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.sort": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.get": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_csv": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}, "csi_images.csi_frames.Frame.__init__": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1.7320508075688772}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.__init__": {"tf": 2.6457513110645907}, "csi_images.csi_scans.Scan.Channel.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_names": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_czi": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}, "csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}, "csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1.4142135623730951}}, "df": 36}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_scans.Scan.__init__": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.ocular_files.merge_statistics": {"tf": 1.4142135623730951}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_scans.Scan.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}, "csi_images.ocular_files.merge_statistics": {"tf": 1}}, "df": 4}}}, "o": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_scans.Scan.__init__": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {"csi_images.csi_events.Event.__init__": {"tf": 2}, "csi_images.csi_events.EventArray.to_events": {"tf": 2.449489742783178}, "csi_images.csi_events.EventArray.from_events": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.__init__": {"tf": 2}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.__init__": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1.4142135623730951}, "csi_images.ocular_files.get_cells": {"tf": 1.4142135623730951}, "csi_images.ocular_files.get_others": {"tf": 1.4142135623730951}, "csi_images.ocular_files.save_cells": {"tf": 1.4142135623730951}, "csi_images.ocular_files.save_others": {"tf": 1.4142135623730951}, "csi_images.ocular_files.merge_statistics": {"tf": 2}, "csi_images.ocular_files.filter_and_generate_statistics": {"tf": 2}}, "df": 18}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.Event.__init__": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.__init__": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray.get": {"tf": 1}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.add_features": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.to_dataframe": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}, "csi_images.ocular_files.merge_statistics": {"tf": 1.4142135623730951}}, "df": 11}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_events.EventArray.get": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_images.make_rgb": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"csi_images.csi_scans.Scan.ROI.__init__": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}}, "df": 2}}, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_events.EventArray.load_ocular": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_tiles.Tile.__init__": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}}, "df": 2}}}}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}}, "df": 3}}}, "l": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_events.EventArray.merge": {"tf": 1}, "csi_images.csi_events.EventArray.from_events": {"tf": 1}, "csi_images.csi_events.EventArray.from_dataframe": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_events.EventArray.load_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.from_dict": {"tf": 1}, "csi_images.csi_scans.Scan.load_czi": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 21}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}}, "df": 2, "s": {"docs": {"csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}}, "df": 2}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_frames.Frame.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}}, "df": 2, "s": {"docs": {"csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_scans.Scan.__init__": {"tf": 1}}, "df": 4}}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {"csi_images.csi_scans.Scan.__init__": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1}}, "df": 2, "s": {"docs": {"csi_images.csi_events.Event.__init__": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray.from_events": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_frames.Frame.__init__": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1}, "csi_images.csi_images.make_rgb": {"tf": 1}, "csi_images.csi_tiles.Tile.__init__": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}, "csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}, "csi_images.ocular_files.merge_statistics": {"tf": 1.4142135623730951}, "csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1.4142135623730951}}, "df": 22}}}}}, "n": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}}, "df": 3, "t": {"docs": {"csi_images.csi_events.Event.__init__": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.get": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.__init__": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_scans.Scan.__init__": {"tf": 2.449489742783178}, "csi_images.csi_scans.Scan.ROI.__init__": {"tf": 2.449489742783178}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.__init__": {"tf": 2}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1.7320508075688772}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1.7320508075688772}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 2}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1.7320508075688772}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 2.23606797749979}}, "df": 20, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_events.EventArray.load_ocular": {"tf": 1.7320508075688772}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"csi_images.csi_scans.Scan.Channel.__init__": {"tf": 1}}, "df": 1}}}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {"csi_images.csi_events.EventArray.__init__": {"tf": 1}}, "df": 1}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray.from_mask": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.EventArray.load_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_czi": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}}, "df": 11}}}}, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray.to_events": {"tf": 1.7320508075688772}}, "df": 1}}}}}, "d": {"docs": {"csi_images.csi_events.EventArray.from_mask": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.__init__": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}}, "df": 3}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.Event.__init__": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_frames.Frame.__init__": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.__init__": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.ROI.__init__": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}}, "df": 8, "s": {"docs": {"csi_images.csi_events.Event.__init__": {"tf": 1}, "csi_images.csi_frames.Frame.__init__": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}}, "df": 4}}}, "f": {"docs": {"csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1}}, "df": 2}, "m": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.__init__": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.Event.get_scan_position": {"tf": 1}, "csi_images.csi_events.Event.get_slide_position": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_images.make_rgb": {"tf": 1}, "csi_images.csi_tiles.Tile.__init__": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 11}}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.sort": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 12}}, "a": {"docs": {}, "df": 0, "y": {"docs": {"csi_images.csi_scans.Scan.__init__": {"tf": 1}}, "df": 1}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_events.EventArray.merge": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1.4142135623730951}}, "df": 7}}}, "e": {"docs": {"csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}}, "df": 2}}}, "o": {"docs": {"csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1.4142135623730951}}, "df": 1}}, "x": {"docs": {"csi_images.csi_events.Event.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.__init__": {"tf": 1}}, "df": 2}, "y": {"docs": {"csi_images.csi_events.Event.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.__init__": {"tf": 1}}, "df": 2}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"csi_images.csi_events.Event.__init__": {"tf": 1}, "csi_images.csi_events.EventArray.__init__": {"tf": 1}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}}, "df": 4}}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_events.EventArray.to_events": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "k": {"docs": {"csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1}}, "df": 2}}}, "s": {"docs": {"csi_images.csi_scans.Scan.Channel.__init__": {"tf": 1}}, "df": 1}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.Event.__init__": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.__init__": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray.get": {"tf": 1}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.add_features": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.to_dataframe": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}, "csi_images.ocular_files.merge_statistics": {"tf": 1.4142135623730951}}, "df": 11}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_csv": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_scans.Scan.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_czi": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}, "csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}}, "df": 23}}}, "i": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_scans.Scan.__init__": {"tf": 1}}, "df": 1, "s": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}}, "df": 3}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1}}, "df": 2}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_scans.Scan.__init__": {"tf": 1}}, "df": 1}}}}}}}}}, "x": {"docs": {"csi_images.csi_scans.Scan.__init__": {"tf": 1.4142135623730951}}, "df": 1}, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_scans.Scan.ROI.__init__": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}}, "df": 1}}}}}}}}, "n": {"docs": {"csi_images.csi_events.EventArray.from_mask": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.__init__": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 8, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.Event.__init__": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_events.EventArray.__init__": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.__init__": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.ROI.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1.4142135623730951}, "csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1.4142135623730951}}, "df": 20}}, "t": {"docs": {"csi_images.csi_events.EventArray.load_ocular": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "y": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1.4142135623730951}, "csi_images.csi_images.make_rgb": {"tf": 1.4142135623730951}}, "df": 8}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1.4142135623730951}, "csi_images.csi_images.make_rgb": {"tf": 1.4142135623730951}}, "df": 8}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.Channel.__init__": {"tf": 1}}, "df": 1, "s": {"docs": {"csi_images.csi_events.EventArray.get": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}}, "df": 2}}}}, "e": {"docs": {}, "df": 0, "w": {"docs": {"csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}}, "df": 2}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.Event.__init__": {"tf": 1}, "csi_images.csi_events.EventArray.__init__": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}}, "df": 4}}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.Event.get_scan_position": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.get_slide_position": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1.7320508075688772}, "csi_images.csi_images.make_rgb": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.Channel.__init__": {"tf": 1.4142135623730951}}, "df": 6}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 4}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray.__init__": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray.get": {"tf": 1}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}, "csi_images.csi_events.EventArray.to_dataframe": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}, "csi_images.ocular_files.merge_statistics": {"tf": 1.7320508075688772}}, "df": 10}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray.to_events": {"tf": 1.4142135623730951}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1}}, "df": 2, "s": {"docs": {"csi_images.csi_events.EventArray.load_ocular": {"tf": 1.7320508075688772}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"1": {"docs": {"csi_images.csi_events.EventArray.load_ocular": {"tf": 1.4142135623730951}}, "df": 1}, "2": {"docs": {"csi_images.csi_events.EventArray.load_ocular": {"tf": 1.4142135623730951}}, "df": 1}, "3": {"docs": {"csi_images.csi_events.EventArray.load_ocular": {"tf": 1.4142135623730951}}, "df": 1}, "4": {"docs": {"csi_images.csi_events.EventArray.load_ocular": {"tf": 1.4142135623730951}}, "df": 1}, "docs": {}, "df": 0}}}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_scans.Scan.ROI.__init__": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 2}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.sort": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.get": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.merge": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_events": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1.7320508075688772}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 2.23606797749979}, "csi_images.csi_images.extract_mask_info": {"tf": 1.7320508075688772}, "csi_images.csi_images.make_rgb": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.get_channel_names": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 2.23606797749979}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 2.23606797749979}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1.7320508075688772}, "csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1.4142135623730951}}, "df": 20}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1}}, "df": 2}}}}}, "o": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_events.EventArray.load_ocular": {"tf": 1}}, "df": 1}}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.sort": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 13}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 1}}}}}, "y": {"docs": {"csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.sort": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_events.EventArray.from_events": {"tf": 1}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}}, "df": 4, "s": {"docs": {"csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_events.EventArray.merge": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_events.EventArray.from_events": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}, "csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1.4142135623730951}, "csi_images.ocular_files.save_others": {"tf": 1.4142135623730951}, "csi_images.ocular_files.merge_statistics": {"tf": 1.7320508075688772}, "csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1.7320508075688772}}, "df": 11}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {"csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}, "csi_images.ocular_files.merge_statistics": {"tf": 1.4142135623730951}, "csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1.4142135623730951}}, "df": 6}}}}}}}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1}}, "df": 2}}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.Channel.__init__": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_scans.Scan.__init__": {"tf": 1}}, "df": 1}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"csi_images.csi_events.EventArray.load_ocular": {"tf": 1.7320508075688772}}, "df": 1, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray.__init__": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray.get": {"tf": 1}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}, "csi_images.csi_events.EventArray.to_dataframe": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}, "csi_images.ocular_files.merge_statistics": {"tf": 1.4142135623730951}}, "df": 10}}}}}}, "e": {"docs": {"csi_images.csi_scans.Scan.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}, "f": {"docs": {"csi_images.csi_events.EventArray.from_dataframe": {"tf": 1}}, "df": 1}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {"csi_images.csi_events.EventArray.load_ocular": {"tf": 1}, "csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_scans.Scan.to_dict": {"tf": 1}, "csi_images.csi_scans.Scan.from_dict": {"tf": 1}}, "df": 3}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 4, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.sort": {"tf": 1}}, "df": 2}}}}}}}}, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.EventArray.load_ocular": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.EventArray.rows": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.__init__": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}}, "df": 3}}, "i": {"docs": {"csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_scans.Scan.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}, "csi_images.csi_tiles.Tile.__init__": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 8}}, "c": {"docs": {"csi_images.csi_events.EventArray.load_ocular": {"tf": 2}}, "df": 1}, "d": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.EventArray.load_ocular": {"tf": 3.3166247903554}}, "df": 1}}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}}, "df": 7}}}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1}}, "df": 4}}}}}, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_events.EventArray.load_ocular": {"tf": 1.7320508075688772}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_scans.Scan.ROI.similar": {"tf": 1}, "csi_images.csi_scans.Scan.has_same_profile": {"tf": 1}}, "df": 2, "s": {"docs": {"csi_images.csi_events.EventArray.load_ocular": {"tf": 2.23606797749979}}, "df": 1}}}}}, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.__init__": {"tf": 1}}, "df": 1}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"csi_images.csi_scans.Scan.__init__": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_scans.Scan.ROI.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {"csi_images.csi_scans.Scan.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.__init__": {"tf": 2}}, "df": 2}}, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"csi_images.csi_scans.Scan.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.__init__": {"tf": 1}}, "df": 2}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_scans.Scan.__init__": {"tf": 1}, "csi_images.csi_scans.Scan.ROI.__init__": {"tf": 1}}, "df": 2}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {"csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1}}, "df": 1}}}}}}, "bases": {"root": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_scans.Scan": {"tf": 1}, "csi_images.csi_scans.Scan.Channel": {"tf": 1}, "csi_images.csi_scans.Scan.ROI": {"tf": 1}}, "df": 3, "o": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_scans.Scan": {"tf": 1}, "csi_images.csi_scans.Scan.Channel": {"tf": 1}, "csi_images.csi_scans.Scan.ROI": {"tf": 1}}, "df": 3}}}}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {"csi_images.csi_scans.Scan.Type": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "doc": {"root": {"0": {"docs": {"csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1.7320508075688772}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1.7320508075688772}}, "df": 4}, "1": {"6": {"docs": {"csi_images.csi_frames.Frame.get_image": {"tf": 1}}, "df": 1}, "docs": {"csi_images.csi_scans.Scan.ROI": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1.4142135623730951}}, "df": 3, "d": {"docs": {"csi_images.csi_events.EventArray.rows": {"tf": 1}}, "df": 1}}, "2": {"docs": {"csi_images.csi_scans.Scan.Channel": {"tf": 1}}, "df": 1, "d": {"docs": {"csi_images.csi_frames.Frame.get_all_frames": {"tf": 1.4142135623730951}}, "df": 1}}, "3": {"docs": {}, "df": 0, "x": {"3": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "d": {"docs": {"csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}}, "df": 1}}, "5": {"docs": {"csi_images.csi_scans.Scan.Channel": {"tf": 1}}, "df": 1}, "7": {"docs": {"csi_images.csi_scans.Scan.SCANNER_IDS": {"tf": 1}}, "df": 1}, "8": {"docs": {"csi_images.csi_frames.Frame.get_image": {"tf": 1}}, "df": 1}, "docs": {"csi_images": {"tf": 15.066519173319364}, "csi_images.csi_events": {"tf": 2.449489742783178}, "csi_images.csi_events.Event": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event.__init__": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 2.8284271247461903}, "csi_images.csi_events.Event.scan": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event.tile": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event.x": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event.y": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event.size": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event.metadata": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event.features": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event.get_scan_position": {"tf": 3.4641016151377544}, "csi_images.csi_events.Event.get_slide_position": {"tf": 3.4641016151377544}, "csi_images.csi_events.Event.crop_images": {"tf": 5.744562646538029}, "csi_images.csi_events.Event.extract_images": {"tf": 5.291502622129181}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 5.656854249492381}, "csi_images.csi_events.EventArray": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray.__init__": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray.INFO_COLUMNS": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray.info": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray.metadata": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray.features": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 5.196152422706632}, "csi_images.csi_events.EventArray.sort": {"tf": 5.196152422706632}, "csi_images.csi_events.EventArray.get": {"tf": 4.795831523312719}, "csi_images.csi_events.EventArray.rows": {"tf": 4.69041575982343}, "csi_images.csi_events.EventArray.copy": {"tf": 3.4641016151377544}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 3.7416573867739413}, "csi_images.csi_events.EventArray.add_features": {"tf": 3.7416573867739413}, "csi_images.csi_events.EventArray.merge": {"tf": 3.7416573867739413}, "csi_images.csi_events.EventArray.to_events": {"tf": 5.385164807134504}, "csi_images.csi_events.EventArray.from_events": {"tf": 3.7416573867739413}, "csi_images.csi_events.EventArray.to_dataframe": {"tf": 3.4641016151377544}, "csi_images.csi_events.EventArray.from_dataframe": {"tf": 3.4641016151377544}, "csi_images.csi_events.EventArray.from_mask": {"tf": 7.615773105863909}, "csi_images.csi_events.EventArray.save_csv": {"tf": 4}, "csi_images.csi_events.EventArray.load_csv": {"tf": 4}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 4}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 4}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 4.58257569495584}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 6.557438524302}, "csi_images.csi_frames": {"tf": 1.7320508075688772}, "csi_images.csi_frames.Frame": {"tf": 1.7320508075688772}, "csi_images.csi_frames.Frame.__init__": {"tf": 1.7320508075688772}, "csi_images.csi_frames.Frame.scan": {"tf": 1.7320508075688772}, "csi_images.csi_frames.Frame.tile": {"tf": 1.7320508075688772}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 5.291502622129181}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 4.795831523312719}, "csi_images.csi_frames.Frame.get_image": {"tf": 4.795831523312719}, "csi_images.csi_frames.Frame.check_image": {"tf": 4.795831523312719}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 4}, "csi_images.csi_frames.Frame.get_frames": {"tf": 5.291502622129181}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 6.164414002968976}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 5.744562646538029}, "csi_images.csi_images": {"tf": 1.7320508075688772}, "csi_images.csi_images.extract_mask_info": {"tf": 5.916079783099616}, "csi_images.csi_images.make_rgb": {"tf": 4.58257569495584}, "csi_images.csi_scans": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan": {"tf": 3.7416573867739413}, "csi_images.csi_scans.Scan.__init__": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.yaml_tag": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.Type": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.Type.BZSCANNER": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.Type.AXIOSCAN7": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.SCANNER_IDS": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.METADATA_FILE_NAME": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.DATETIME_FORMAT": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.BZSCANNER_CHANNEL_MAP": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.Channel": {"tf": 3.605551275463989}, "csi_images.csi_scans.Scan.Channel.__init__": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.Channel.yaml_tag": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.Channel.name": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.Channel.exposure_ms": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.Channel.intensity": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.ROI": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.ROI.__init__": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.ROI.yaml_tag": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.ROI.origin_x_um": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.ROI.origin_y_um": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.ROI.width_um": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.ROI.height_um": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.ROI.tile_rows": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.ROI.tile_cols": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.ROI.focus_points": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.ROI.similar": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.slide_id": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.path": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.start_date": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.end_date": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.scan_time_s": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.scanner_id": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.tray": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.slot": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.camera": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.objective": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.pixel_size_um": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.tile_width_px": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.tile_height_px": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.tile_overlap_proportion": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.channels": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.roi": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.has_same_profile": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.get_channel_names": {"tf": 3.4641016151377544}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 4.795831523312719}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 4.58257569495584}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 4.58257569495584}, "csi_images.csi_scans.Scan.to_dict": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.from_dict": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.load_czi": {"tf": 4.242640687119285}, "csi_images.csi_scans.Scan.load_txt": {"tf": 4.58257569495584}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 4.58257569495584}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 5.385164807134504}, "csi_images.csi_tiles": {"tf": 1.7320508075688772}, "csi_images.csi_tiles.Tile": {"tf": 1.7320508075688772}, "csi_images.csi_tiles.Tile.__init__": {"tf": 1.7320508075688772}, "csi_images.csi_tiles.Tile.scan": {"tf": 1.7320508075688772}, "csi_images.csi_tiles.Tile.n_roi": {"tf": 1.7320508075688772}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 4.795831523312719}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 4.795831523312719}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 6.164414002968976}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 6.48074069840786}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 6.082762530298219}, "csi_images.ocular_files": {"tf": 1.7320508075688772}, "csi_images.ocular_files.FRAME_INFO_FILE": {"tf": 1.7320508075688772}, "csi_images.ocular_files.FRAME_MORPHOMETRICS_FILES": {"tf": 1.7320508075688772}, "csi_images.ocular_files.SLIDE_MORPHOMETRICS_FILE": {"tf": 1.7320508075688772}, "csi_images.ocular_files.get_cells": {"tf": 4}, "csi_images.ocular_files.get_others": {"tf": 4}, "csi_images.ocular_files.save_cells": {"tf": 4.58257569495584}, "csi_images.ocular_files.save_others": {"tf": 4.58257569495584}, "csi_images.ocular_files.get_frame_info": {"tf": 4.69041575982343}, "csi_images.ocular_files.get_frame_statistics": {"tf": 4}, "csi_images.ocular_files.get_slide_statistics": {"tf": 4}, "csi_images.ocular_files.merge_statistics": {"tf": 5.385164807134504}, "csi_images.ocular_files.filter_and_generate_statistics": {"tf": 4.795831523312719}, "examples": {"tf": 2.449489742783178}, "examples.scan_examples": {"tf": 1.7320508075688772}, "examples.scan_examples.load_in_images": {"tf": 1.7320508075688772}, "tests": {"tf": 2.6457513110645907}, "tests.compare_cv2_tifffile": {"tf": 1.7320508075688772}, "tests.compare_cv2_tifffile.main": {"tf": 1.7320508075688772}, "tests.test_events": {"tf": 1.7320508075688772}, "tests.test_events.test_getting_event": {"tf": 1.7320508075688772}, "tests.test_events.test_getting_many_events": {"tf": 1.7320508075688772}, "tests.test_events.test_event_coordinates_for_bzscanner": {"tf": 1.7320508075688772}, "tests.test_events.test_event_coordinates_for_axioscan": {"tf": 1.7320508075688772}, "tests.test_events.test_eventarray_conversions": {"tf": 1.7320508075688772}, "tests.test_events.test_ocular_conversions": {"tf": 1.7320508075688772}, "tests.test_events.test_copy_sort_rows_get": {"tf": 1.7320508075688772}, "tests.test_examples": {"tf": 1.7320508075688772}, "tests.test_examples.test_all_examples": {"tf": 1.7320508075688772}, "tests.test_frames": {"tf": 1.7320508075688772}, "tests.test_frames.test_getting_frames": {"tf": 1.7320508075688772}, "tests.test_frames.test_checking_frames": {"tf": 1.7320508075688772}, "tests.test_frames.test_make_rgb": {"tf": 1.7320508075688772}, "tests.test_scans": {"tf": 1.7320508075688772}, "tests.test_scans.test_from_yaml": {"tf": 1.7320508075688772}, "tests.test_scans.test_from_txt": {"tf": 1.7320508075688772}, "tests.test_scans.test_names_and_indices": {"tf": 1.7320508075688772}, "tests.test_tiles": {"tf": 1.7320508075688772}, "tests.test_tiles.test_axioscan_tiles": {"tf": 1.7320508075688772}, "tests.test_tiles.test_bzscanner_tiles": {"tf": 1.7320508075688772}, "tests.test_tiles.test_getting_tiles": {"tf": 1.7320508075688772}}, "df": 164, "c": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {"csi_images": {"tf": 5.656854249492381}, "csi_images.csi_events": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}}, "df": 3}, "v": {"docs": {"csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_csv": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1.4142135623730951}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}}, "df": 5}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"csi_images": {"tf": 1.4142135623730951}, "csi_images.csi_events": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.sort": {"tf": 1}, "csi_images.csi_scans": {"tf": 1.7320508075688772}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}, "examples": {"tf": 1}, "tests": {"tf": 1}}, "df": 9, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images": {"tf": 1.7320508075688772}}, "df": 1, "/": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}}, "df": 2}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {"csi_images.ocular_files.get_slide_statistics": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray.to_events": {"tf": 1}}, "df": 1, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {"examples": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.Channel": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_events.EventArray.from_mask": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}}, "df": 2, "s": {"docs": {"csi_images": {"tf": 1}, "csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}}, "df": 3}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_images.extract_mask_info": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_events.EventArray.load_ocular": {"tf": 1}, "csi_images.csi_scans.Scan": {"tf": 1}}, "df": 2}}}, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray.merge": {"tf": 1}, "csi_images.csi_images.make_rgb": {"tf": 1}}, "df": 2, "s": {"docs": {"csi_images": {"tf": 1}}, "df": 1}, "d": {"docs": {"csi_images.csi_events": {"tf": 1}}, "df": 1}}}}}, ":": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}}, "df": 1}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"tests.compare_cv2_tifffile": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_frames": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_scans.Scan": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_frames.Frame.get_image": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_scans.Scan.Channel": {"tf": 1}, "csi_images.csi_scans.Scan.ROI": {"tf": 1}}, "df": 2}}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile": {"tf": 1}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1}}, "df": 1}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}}, "df": 2}}}}}}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"csi_images": {"tf": 2.23606797749979}, "csi_images.csi_events": {"tf": 1}, "csi_images.csi_frames": {"tf": 1.4142135623730951}, "csi_images.csi_scans": {"tf": 1}, "csi_images.csi_scans.Scan": {"tf": 1}, "csi_images.csi_scans.Scan.Channel": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}, "csi_images.csi_tiles": {"tf": 1}, "examples": {"tf": 1}}, "df": 10}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images": {"tf": 2}}, "df": 1}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events.EventArray.to_dataframe": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1.4142135623730951}}, "df": 5, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_events": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}, "csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}}, "df": 8}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_frames.Frame.get_image": {"tf": 1}}, "df": 1, "s": {"docs": {"csi_images.csi_frames.Frame.get_file_name": {"tf": 1}}, "df": 1}}}}}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {"csi_images": {"tf": 1.4142135623730951}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.get_scan_position": {"tf": 1}, "csi_images.csi_scans.Scan": {"tf": 1.7320508075688772}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1.7320508075688772}}, "df": 6, "s": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 2.23606797749979}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 6}}}}}}}}}, "p": {"docs": {}, "df": 0, "y": {"docs": {"csi_images.csi_events.EventArray.copy": {"tf": 1.4142135623730951}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.sort": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.get": {"tf": 1}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}}, "df": 7, "s": {"docs": {"csi_images.csi_events.EventArray.get": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1.7320508075688772}}, "df": 4}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_images.make_rgb": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_tiles": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {"csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}}, "df": 1}}}, "z": {"docs": {}, "df": 0, "i": {"docs": {"csi_images": {"tf": 1.4142135623730951}, "csi_images.csi_scans": {"tf": 1}, "csi_images.csi_scans.Scan.load_czi": {"tf": 1}}, "df": 3}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"csi_images": {"tf": 2.449489742783178}, "csi_images.csi_events": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event": {"tf": 1}, "csi_images.csi_events.EventArray": {"tf": 1.4142135623730951}, "csi_images.csi_frames": {"tf": 1.4142135623730951}, "csi_images.csi_scans": {"tf": 1}, "csi_images.csi_scans.Scan": {"tf": 1}, "csi_images.csi_scans.Scan.Channel": {"tf": 1}, "csi_images.csi_scans.Scan.ROI": {"tf": 1}, "csi_images.csi_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile": {"tf": 1.4142135623730951}}, "df": 11}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1.4142135623730951}}, "df": 1, "d": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}}, "df": 4}}}}}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_images.make_rgb": {"tf": 1}, "csi_images.csi_scans.Scan.Channel": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.get_channel_names": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 2.449489742783178}}, "df": 6, "s": {"docs": {"csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 2.449489742783178}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 2}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1.4142135623730951}, "csi_images.csi_images.make_rgb": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan": {"tf": 1}}, "df": 7}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_frames.Frame.get_file_path": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}, "csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 1}}, "df": 5}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 2}, "csi_images.csi_events.Event.extract_images": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 2}}, "df": 3, "s": {"docs": {"csi_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.crop_images": {"tf": 1.4142135623730951}}, "df": 2}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray.copy": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_events.EventArray.from_dataframe": {"tf": 1}}, "df": 3}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_frames": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}}, "df": 2}}}}}}}, "d": {"docs": {"csi_images": {"tf": 1}}, "df": 1}, "y": {"5": {"docs": {"csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "v": {"2": {"docs": {"tests.compare_cv2_tifffile": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 2}, "csi_images.csi_events.Event.crop_images": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_frames": {"tf": 1.7320508075688772}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.check_image": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1.7320508075688772}, "csi_images.csi_images.extract_mask_info": {"tf": 1.4142135623730951}, "csi_images.csi_images.make_rgb": {"tf": 1}}, "df": 13, "s": {"docs": {"csi_images": {"tf": 4}, "csi_images.csi_events.Event.crop_images": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event.extract_images": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 2}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1.7320508075688772}, "csi_images.csi_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1.7320508075688772}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1.7320508075688772}, "csi_images.csi_images.make_rgb": {"tf": 1}, "tests.compare_cv2_tifffile": {"tf": 1}}, "df": 12, "[": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}}}}}, "i": {"docs": {}, "df": 0, "o": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"tests": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"csi_images": {"tf": 2.449489742783178}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images": {"tf": 2.449489742783178}}, "df": 1}}}, "s": {"docs": {"csi_images": {"tf": 1.7320508075688772}}, "df": 1}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_scans": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "s": {"docs": {"csi_images": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event": {"tf": 1}, "csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.crop_images": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event.extract_images": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 2.23606797749979}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}, "tests": {"tf": 1}}, "df": 12}, "n": {"docs": {"csi_images": {"tf": 3}, "csi_images.csi_events": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event": {"tf": 1}, "csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 2}, "csi_images.csi_events.Event.get_scan_position": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.get_slide_position": {"tf": 1}, "csi_images.csi_events.Event.crop_images": {"tf": 2}, "csi_images.csi_events.Event.extract_images": {"tf": 2}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.sort": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.merge": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_events.EventArray.from_events": {"tf": 1}, "csi_images.csi_events.EventArray.to_dataframe": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_dataframe": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1}, "csi_images.csi_scans.Scan.Channel": {"tf": 1}, "csi_images.csi_scans.Scan.ROI": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_names": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1.7320508075688772}, "csi_images.csi_tiles": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile": {"tf": 1.7320508075688772}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1.7320508075688772}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 2}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 2}, "tests.test_examples": {"tf": 1}}, "df": 36, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images": {"tf": 2.449489742783178}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}}, "df": 2}}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_events.EventArray.rows": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"csi_images.csi_events.EventArray.from_mask": {"tf": 1.4142135623730951}, "csi_images.csi_images.extract_mask_info": {"tf": 1}, "csi_images.csi_scans.Scan.Channel": {"tf": 1.4142135623730951}}, "df": 3}}}}}}, "o": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events": {"tf": 1}, "csi_images.csi_events.EventArray.merge": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_images.make_rgb": {"tf": 1}, "csi_images.csi_scans": {"tf": 1}, "csi_images.ocular_files.merge_statistics": {"tf": 1}}, "df": 7}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"csi_images": {"tf": 2.6457513110645907}, "tests": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images": {"tf": 1}, "tests": {"tf": 1}}, "df": 2}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1.4142135623730951}}, "df": 4, "s": {"docs": {"csi_images": {"tf": 1}}, "df": 1}, "d": {"docs": {"csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_csv": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}}, "df": 6}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events.EventArray.rows": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1.4142135623730951}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"csi_images": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.rows": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 9}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {"csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.sort": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1}}, "df": 3, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_events": {"tf": 1}, "csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}, "examples": {"tf": 1}}, "df": 4}}}}}}}}}, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.Event.extract_images": {"tf": 1}}, "df": 1}}}}}}}}}, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.EventArray.load_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_czi": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}}, "df": 11}}}}, "d": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 2}, "csi_images.csi_images.extract_mask_info": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1.4142135623730951}}, "df": 5, "s": {"docs": {"csi_images.csi_scans.Scan.SCANNER_IDS": {"tf": 1.4142135623730951}}, "df": 1}}, "t": {"docs": {"csi_images.csi_events.Event": {"tf": 1}, "csi_images.csi_events.Event.crop_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray": {"tf": 1}, "csi_images.csi_scans.Scan": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}}, "df": 8, "s": {"docs": {"csi_images.csi_scans.Scan": {"tf": 1}}, "df": 1}}, "f": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_image": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1.7320508075688772}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1.4142135623730951}}, "df": 19}, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray.to_events": {"tf": 2.449489742783178}}, "df": 1, "d": {"docs": {"csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {"csi_images": {"tf": 4.47213595499958}, "csi_images.csi_events": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event.extract_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.sort": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.get": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.rows": {"tf": 2}, "csi_images.csi_events.EventArray.copy": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.merge": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_events.EventArray.from_events": {"tf": 1}, "csi_images.csi_events.EventArray.to_dataframe": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_dataframe": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_frames": {"tf": 1.7320508075688772}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 2.23606797749979}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 2}, "csi_images.csi_images.extract_mask_info": {"tf": 1}, "csi_images.csi_images.make_rgb": {"tf": 1}, "csi_images.csi_scans": {"tf": 2.23606797749979}, "csi_images.csi_scans.Scan": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.Channel": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.ROI": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_names": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 2}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.load_czi": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1.4142135623730951}, "csi_images.csi_tiles": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile": {"tf": 2.23606797749979}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 2.6457513110645907}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 2.6457513110645907}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 2.449489742783178}, "csi_images.ocular_files.merge_statistics": {"tf": 1}, "tests.compare_cv2_tifffile": {"tf": 1}}, "df": 43, "n": {"docs": {"csi_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_dataframe": {"tf": 1}, "csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_csv": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1.4142135623730951}, "csi_images.csi_frames": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1}, "csi_images.csi_scans.Scan.ROI": {"tf": 1}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}}, "df": 13, "d": {"docs": {"csi_images": {"tf": 4.123105625617661}, "csi_images.csi_events": {"tf": 1}, "csi_images.csi_events.Event": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_events.EventArray": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_csv": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}, "csi_images.csi_frames": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1.4142135623730951}, "csi_images.ocular_files.merge_statistics": {"tf": 1}, "tests": {"tf": 1}, "tests.compare_cv2_tifffile": {"tf": 1}, "tests.test_examples": {"tf": 1}}, "df": 28, "/": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events": {"tf": 1}}, "df": 1}}}, "z": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray": {"tf": 1}}, "df": 1}}}}}, "y": {"docs": {"csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}}, "df": 3, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {"csi_images": {"tf": 2.449489742783178}, "csi_images.csi_events.Event": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.EventArray.rows": {"tf": 1}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 2.449489742783178}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 2.23606797749979}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 2.449489742783178}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1.7320508075688772}, "tests": {"tf": 1}}, "df": 15, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_events.EventArray.get_sort_order": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.sort": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"csi_images": {"tf": 2.449489742783178}, "csi_images.csi_events.EventArray.to_dataframe": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_dataframe": {"tf": 1}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1.7320508075688772}, "tests.test_examples": {"tf": 1}}, "df": 9, "o": {"docs": {}, "df": 0, "w": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile": {"tf": 1}}, "df": 3, "s": {"docs": {"csi_images.csi_frames": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}}, "df": 2, "l": {"docs": {}, "df": 0, "y": {"docs": {"csi_images": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "o": {"docs": {"csi_images.csi_frames": {"tf": 1}, "csi_images.csi_scans": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}}, "df": 1}}}}}}}}}, "t": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events.EventArray": {"tf": 1}, "csi_images.csi_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 4, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.Event": {"tf": 1}}, "df": 1}}}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.EventArray.load_ocular": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event": {"tf": 1}, "csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1.4142135623730951}}, "df": 5}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {"csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}}, "df": 2, "s": {"docs": {"csi_images.csi_images.make_rgb": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "i": {"docs": {"csi_images": {"tf": 1}}, "df": 1}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_frames": {"tf": 1}}, "df": 1}}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_scans.Scan.Channel": {"tf": 1}}, "df": 1}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {"tests": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}}, "df": 1}}}}}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.add_features": {"tf": 1.4142135623730951}}, "df": 3, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1}}, "df": 2, "a": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_images.extract_mask_info": {"tf": 1}}, "df": 1}}}}}}}}, "j": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_scans.Scan.load_txt": {"tf": 1}}, "df": 1}}}}}}}, "f": {"4": {"8": {"8": {"docs": {"csi_images.csi_scans.Scan.Channel": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "5": {"5": {"5": {"docs": {"csi_images.csi_scans.Scan.Channel": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "6": {"4": {"7": {"docs": {"csi_images.csi_scans.Scan.Channel": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {"csi_images.csi_events.EventArray.to_events": {"tf": 1}}, "df": 1}}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.EventArray.to_events": {"tf": 1}}, "df": 1}}}}, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_images.extract_mask_info": {"tf": 1}}, "df": 1}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_scans.Scan.SCANNER_IDS": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 2}}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_scans.Scan": {"tf": 1}}, "df": 1}}}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"csi_images": {"tf": 2.6457513110645907}, "csi_images.csi_events.EventArray": {"tf": 1}, "csi_images.csi_events.EventArray.to_dataframe": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_dataframe": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1.7320508075688772}, "csi_images.csi_frames": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan": {"tf": 1}, "csi_images.ocular_files.merge_statistics": {"tf": 1}}, "df": 8, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray.get": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.to_dataframe": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_dataframe": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1.4142135623730951}, "csi_images.ocular_files.get_frame_info": {"tf": 1}}, "df": 7, "s": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events": {"tf": 1}, "csi_images.csi_events.Event": {"tf": 1}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.sort": {"tf": 1}}, "df": 5}}}}}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"examples": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "i": {"docs": {"csi_images.csi_scans.Scan.Channel": {"tf": 1}, "csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}}, "df": 3}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"csi_images": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images": {"tf": 1.7320508075688772}}, "df": 1}}}}}}, "s": {"docs": {"csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}}, "df": 1}}}}}, "v": {"docs": {"csi_images": {"tf": 1.4142135623730951}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"csi_images": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}}, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}}, "df": 2, "s": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1.4142135623730951}, "csi_images.csi_images.extract_mask_info": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 14}}}}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {"csi_images.csi_events.EventArray.copy": {"tf": 1.4142135623730951}}, "df": 1}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {"tests": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"csi_images": {"tf": 2}, "csi_images.csi_events": {"tf": 1}}, "df": 2}}}}}}}}}}, "s": {"docs": {"csi_images": {"tf": 1.4142135623730951}}, "df": 1, "/": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_frames": {"tf": 1}}, "df": 2}}, "n": {"docs": {"csi_images.csi_events.EventArray.to_events": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1}}, "df": 2}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_image": {"tf": 1}}, "df": 4}}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}}, "df": 1}}}}}}}}}, "u": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}}, "df": 1}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray.save_ocular": {"tf": 1}}, "df": 1}}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {"csi_images.csi_events.EventArray.load_ocular": {"tf": 1}, "csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1}}, "df": 2}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {"csi_images.csi_events": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_scans.Scan": {"tf": 1}}, "df": 1}}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}, "tests": {"tf": 1}}, "df": 9, "s": {"docs": {"csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}}, "df": 1}, "d": {"docs": {"csi_images.csi_scans.Scan.Channel": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}, "examples": {"tf": 1}}, "df": 4}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_frames.Frame.get_image": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"csi_images.csi_scans.Scan.Channel": {"tf": 1}, "csi_images.csi_scans.Scan.ROI": {"tf": 1}}, "df": 2}}}}}}, "p": {"docs": {"csi_images": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_scans.Scan": {"tf": 1}}, "df": 1}}}, "m": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}, "csi_images.csi_events.Event.get_scan_position": {"tf": 1}, "csi_images.csi_events.Event.get_slide_position": {"tf": 1}}, "df": 3}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"csi_images": {"tf": 5}, "csi_images.csi_events": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.crop_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 2.23606797749979}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_frames": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1.4142135623730951}, "csi_images.csi_images.extract_mask_info": {"tf": 1.4142135623730951}, "csi_images.csi_images.make_rgb": {"tf": 1}, "csi_images.csi_scans.Scan": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "csi_images.csi_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1.4142135623730951}, "examples": {"tf": 1}, "tests.compare_cv2_tifffile": {"tf": 1}}, "df": 29, "t": {"docs": {}, "df": 0, "h": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}, "m": {"docs": {"csi_images.csi_frames.Frame.check_all_images": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}, "tests.test_examples": {"tf": 1}}, "df": 5}}}}, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"examples": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"csi_images": {"tf": 2.8284271247461903}, "csi_images.csi_events.Event.crop_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images": {"tf": 2.23606797749979}, "csi_images.csi_events.EventArray.get": {"tf": 1}, "csi_images.csi_events.EventArray.from_dataframe": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 2.449489742783178}, "csi_images.csi_events.EventArray.load_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_frames": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 2}, "csi_images.csi_scans": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}, "csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}}, "df": 21}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 3}, "csi_images.csi_events": {"tf": 1}, "csi_images.csi_events.Event.get_scan_position": {"tf": 1}, "csi_images.csi_events.Event.crop_images": {"tf": 1.4142135623730951}, "csi_images.csi_frames": {"tf": 1.7320508075688772}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.check_image": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.Channel": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1.4142135623730951}, "csi_images.ocular_files.merge_statistics": {"tf": 1.7320508075688772}}, "df": 13, "s": {"docs": {"csi_images": {"tf": 3.4641016151377544}, "csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 2}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_scans.Scan": {"tf": 1.4142135623730951}, "csi_images.csi_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile": {"tf": 1}}, "df": 8, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.ocular_files.get_frame_statistics": {"tf": 1.4142135623730951}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {"csi_images.ocular_files.get_frame_info": {"tf": 1}}, "df": 1}}}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1.4142135623730951}, "csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}}, "df": 6, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"csi_images": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "s": {"docs": {"csi_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_frames": {"tf": 1}, "csi_images.csi_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile": {"tf": 1}}, "df": 5}}}}}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.Event.extract_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_csv": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1.4142135623730951}, "csi_images.csi_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 2.23606797749979}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 2}, "csi_images.csi_scans": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_czi": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1.4142135623730951}}, "df": 14, "s": {"docs": {"csi_images": {"tf": 2.449489742783178}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1.7320508075688772}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "examples": {"tf": 1}}, "df": 5}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}}, "df": 1}}, "d": {"docs": {"csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}, "tests": {"tf": 1}}, "df": 3}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_scans.Scan.Channel": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {"csi_images.csi_scans.Scan.load_txt": {"tf": 1}}, "df": 1, "c": {"docs": {"csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1}}, "df": 1, "s": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event": {"tf": 1}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.sort": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 2.449489742783178}, "csi_images.csi_events.EventArray.to_events": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_csv": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}}, "df": 12}}}}}}, "w": {"docs": {"csi_images.csi_events.Event.extract_images": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_frames.Frame.get_all_frames": {"tf": 1.7320508075688772}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 2}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 2}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 2}}, "df": 4, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.save_yaml": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {"csi_images.csi_events.EventArray.to_events": {"tf": 1}}, "df": 1, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"csi_images": {"tf": 2.23606797749979}, "csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}, "csi_images.csi_events.Event.crop_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1.7320508075688772}, "csi_images.csi_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_scans": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}, "csi_images.csi_tiles.Tile": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1.4142135623730951}}, "df": 13}}, "e": {"docs": {"csi_images": {"tf": 5.291502622129181}, "csi_images.csi_events": {"tf": 3.1622776601683795}, "csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 2}, "csi_images.csi_events.Event.get_scan_position": {"tf": 2.23606797749979}, "csi_images.csi_events.Event.get_slide_position": {"tf": 2}, "csi_images.csi_events.Event.crop_images": {"tf": 3.4641016151377544}, "csi_images.csi_events.Event.extract_images": {"tf": 3.3166247903554}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 2.8284271247461903}, "csi_images.csi_events.EventArray": {"tf": 1}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 2.449489742783178}, "csi_images.csi_events.EventArray.sort": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray.get": {"tf": 2.23606797749979}, "csi_images.csi_events.EventArray.rows": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray.copy": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 2.23606797749979}, "csi_images.csi_events.EventArray.add_features": {"tf": 2.23606797749979}, "csi_images.csi_events.EventArray.merge": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 2}, "csi_images.csi_events.EventArray.from_events": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray.to_dataframe": {"tf": 2}, "csi_images.csi_events.EventArray.from_dataframe": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_mask": {"tf": 3.7416573867739413}, "csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_csv": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1.4142135623730951}, "csi_images.csi_frames": {"tf": 2.23606797749979}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 3}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 2}, "csi_images.csi_frames.Frame.get_image": {"tf": 2.8284271247461903}, "csi_images.csi_frames.Frame.check_image": {"tf": 2.449489742783178}, "csi_images.csi_frames.Frame.get_frames": {"tf": 2.23606797749979}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 2}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 2.23606797749979}, "csi_images.csi_images.extract_mask_info": {"tf": 1}, "csi_images.csi_images.make_rgb": {"tf": 1}, "csi_images.csi_scans": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan": {"tf": 1}, "csi_images.csi_scans.Scan.Channel": {"tf": 2.449489742783178}, "csi_images.csi_scans.Scan.get_channel_names": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_czi": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 2.449489742783178}, "csi_images.csi_tiles": {"tf": 2}, "csi_images.csi_tiles.Tile": {"tf": 2}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 2.23606797749979}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 2}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 2.449489742783178}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 2.23606797749979}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 2.8284271247461903}, "csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}, "csi_images.ocular_files.merge_statistics": {"tf": 1.4142135623730951}, "examples": {"tf": 1.4142135623730951}, "tests": {"tf": 2.23606797749979}, "tests.test_examples": {"tf": 1}}, "df": 64, "r": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "f": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "tests": {"tf": 1}}, "df": 3}}, "i": {"docs": {}, "df": 0, "r": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 6}}, "n": {"docs": {"csi_images": {"tf": 1}}, "df": 1}, "m": {"docs": {"csi_images": {"tf": 1}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1}, "examples": {"tf": 1}, "tests": {"tf": 1}, "tests.test_examples": {"tf": 1}}, "df": 5}, "y": {"docs": {"tests.test_examples": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "t": {"docs": {"csi_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_events.EventArray": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_scans.Scan": {"tf": 1}, "csi_images.csi_scans.Scan.Channel": {"tf": 1}, "csi_images.csi_scans.Scan.ROI": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}, "csi_images.csi_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile": {"tf": 1.4142135623730951}, "tests.compare_cv2_tifffile": {"tf": 1}}, "df": 14}, "n": {"docs": {"csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.Channel": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {"csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {"csi_images": {"tf": 2.6457513110645907}, "csi_images.csi_events": {"tf": 1}, "csi_images.csi_events.Event": {"tf": 1}, "csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}, "csi_images.csi_events.Event.crop_images": {"tf": 2}, "csi_images.csi_events.Event.extract_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 2}, "csi_images.csi_events.EventArray": {"tf": 1}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 2}, "csi_images.csi_events.EventArray.sort": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray.get": {"tf": 1}, "csi_images.csi_events.EventArray.rows": {"tf": 1}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray.add_features": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray.to_events": {"tf": 2}, "csi_images.csi_events.EventArray.from_events": {"tf": 1}, "csi_images.csi_events.EventArray.to_dataframe": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 2.449489742783178}, "csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1.7320508075688772}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.check_image": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 2}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 2}, "csi_images.csi_scans": {"tf": 1}, "csi_images.csi_scans.Scan.SCANNER_IDS": {"tf": 1}, "csi_images.csi_scans.Scan.Channel": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.load_czi": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1.7320508075688772}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1.7320508075688772}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 2.449489742783178}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 2.23606797749979}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1.7320508075688772}, "csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}, "csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1.4142135623730951}, "tests": {"tf": 1.4142135623730951}, "tests.test_examples": {"tf": 1}}, "df": 51, "o": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}}, "df": 1}, "d": {"docs": {}, "df": 0, "o": {"docs": {"csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "tests": {"tf": 1}}, "df": 2, "s": {"docs": {"csi_images": {"tf": 1}, "tests": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 2.449489742783178}, "csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1.4142135623730951}, "csi_images.csi_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1.7320508075688772}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1.4142135623730951}, "csi_images.csi_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1.7320508075688772}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 2}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 2}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 2}}, "df": 19, "s": {"docs": {"csi_images": {"tf": 2.449489742783178}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}, "csi_images.csi_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1.7320508075688772}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 6}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.Channel": {"tf": 1}}, "df": 1, "s": {"docs": {"csi_images.csi_events.Event.extract_images_for_list": {"tf": 1.4142135623730951}}, "df": 1}}}, "f": {"docs": {"csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 1}}, "df": 4, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"tests.compare_cv2_tifffile": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}, "g": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_frames.Frame.get_image": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}}, "df": 1, "s": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}}, "df": 1}}}}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {"csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}}, "df": 1}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}}, "df": 2}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 1, "s": {"docs": {"csi_images.csi_images.make_rgb": {"tf": 1}}, "df": 1}}}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_scans": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 2}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}, "tests": {"tf": 1}}, "df": 4}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 2.8284271247461903}, "tests": {"tf": 1.7320508075688772}}, "df": 2, "s": {"docs": {"csi_images": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_csv": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 2.449489742783178}, "csi_images.csi_frames.Frame.get_image": {"tf": 1.7320508075688772}, "csi_images.csi_frames.Frame.check_image": {"tf": 1.7320508075688772}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_czi": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}, "csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1.4142135623730951}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1.4142135623730951}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1.4142135623730951}}, "df": 23, "/": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.save_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}}, "df": 3}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_scans.Scan.save_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}}, "df": 4}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.sort": {"tf": 1}, "csi_images.csi_events.EventArray.get": {"tf": 1}, "csi_images.csi_events.EventArray.rows": {"tf": 1}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}, "csi_images.csi_events.EventArray.merge": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_events.EventArray.from_events": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_csv": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1}, "csi_images.csi_images.make_rgb": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_czi": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}, "csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}, "csi_images.ocular_files.merge_statistics": {"tf": 1}, "csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1}}, "df": 51}}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"csi_images": {"tf": 1}, "examples": {"tf": 1}}, "df": 2}}}}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}}, "df": 2}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.EventArray.to_events": {"tf": 1.4142135623730951}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "p": {"docs": {"csi_images": {"tf": 2}, "tests": {"tf": 1}}, "df": 2}, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event.extract_images": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1.7320508075688772}}, "df": 3}}}}}, "y": {"docs": {"csi_images": {"tf": 3.1622776601683795}}, "df": 1, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"tests": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"csi_images": {"tf": 1.7320508075688772}, "csi_images.csi_events": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.get_scan_position": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.get_slide_position": {"tf": 1.4142135623730951}, "csi_images.csi_tiles": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}}, "df": 8, "a": {"docs": {}, "df": 0, "l": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"csi_images.csi_events": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1.4142135623730951}}, "df": 2}}}}}}, "t": {"docs": {"csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}}, "df": 4}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}}, "df": 1}}}}}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_scans.Scan": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"examples": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}}, "df": 1, "d": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 7}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.EventArray.from_mask": {"tf": 1.4142135623730951}, "csi_images.csi_images.extract_mask_info": {"tf": 1.7320508075688772}}, "df": 2}}}}}}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"examples": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}}, "df": 1}}}}}}, "d": {"docs": {"csi_images.csi_images.extract_mask_info": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_scans.Scan.Channel": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_scans.Scan.save_yaml": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_scans.Scan.Channel": {"tf": 1}}, "df": 2}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"csi_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.sort": {"tf": 1}, "csi_images.csi_events.EventArray.merge": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_events.EventArray.from_events": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1.7320508075688772}, "csi_images.csi_images.extract_mask_info": {"tf": 1.7320508075688772}, "csi_images.csi_images.make_rgb": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.get_channel_names": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 2}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 2.6457513110645907}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 2.6457513110645907}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 2.449489742783178}}, "df": 17, "s": {"docs": {"csi_images.csi_events": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_scans.Scan": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1.4142135623730951}}, "df": 6}, "/": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.EventArray.rows": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"tests": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_scans.Scan": {"tf": 1.7320508075688772}, "csi_images.ocular_files.get_frame_info": {"tf": 1}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}, "csi_images.ocular_files.merge_statistics": {"tf": 2}}, "df": 5}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"csi_images.csi_images.extract_mask_info": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1.4142135623730951}}, "df": 2}}}, "f": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray": {"tf": 1}}, "df": 1}}}, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1}}, "df": 2, "s": {"docs": {"csi_images.csi_events.EventArray.from_mask": {"tf": 1.7320508075688772}, "csi_images.csi_images.extract_mask_info": {"tf": 1.4142135623730951}}, "df": 2}}}}, "y": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_events.EventArray.load_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}}, "df": 4, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_frames": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_scans": {"tf": 1.4142135623730951}}, "df": 4}}, "s": {"docs": {"csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}, "tests.test_examples": {"tf": 1}}, "df": 3}}}, "g": {"docs": {"csi_images.csi_events.EventArray.load_ocular": {"tf": 1}}, "df": 1}}}, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"csi_images": {"tf": 2.6457513110645907}, "csi_images.csi_events": {"tf": 1}, "csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}, "csi_images.csi_events.EventArray.get": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.rows": {"tf": 1}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}, "csi_images.csi_events.EventArray.to_dataframe": {"tf": 1}, "csi_images.csi_events.EventArray.from_dataframe": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1}, "csi_images.csi_scans.Scan": {"tf": 1}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}, "csi_images.csi_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1.4142135623730951}, "csi_images.ocular_files.merge_statistics": {"tf": 1}, "tests": {"tf": 1}, "tests.compare_cv2_tifffile": {"tf": 1}}, "df": 19, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "tests.test_examples": {"tf": 1}}, "df": 4}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"csi_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}}, "df": 11}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}, "c": {"docs": {}, "df": 0, "h": {"docs": {"csi_images": {"tf": 1.7320508075688772}, "csi_images.csi_events": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_frames": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_scans": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}, "csi_images.csi_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "tests": {"tf": 1}}, "df": 11}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.sort": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 12}}}}, "n": {"docs": {"csi_images.csi_events.Event.extract_images": {"tf": 1}, "examples": {"tf": 1}}, "df": 2}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images": {"tf": 1.4142135623730951}}, "df": 1}}}, "e": {"docs": {"csi_images.csi_scans.Scan.save_yaml": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {"csi_images.csi_scans.Scan.Channel": {"tf": 1}, "csi_images.csi_scans.Scan.ROI": {"tf": 1}}, "df": 2, "l": {"docs": {}, "df": 0, "l": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_scans.Scan": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}}, "df": 1}}}}}}, "y": {"docs": {"csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"tests": {"tf": 1}}, "df": 1}}}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_scans.Scan": {"tf": 1}}, "df": 1}}}}}}}, "y": {"docs": {"csi_images": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.ROI": {"tf": 1}, "examples": {"tf": 1}, "tests": {"tf": 1}}, "df": 4}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {"csi_images.csi_events.EventArray": {"tf": 1}}, "df": 1}}}}}}}, "y": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.EventArray": {"tf": 1}}, "df": 3}, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}}, "df": 1}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}}, "df": 2}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_events.Event": {"tf": 1}, "csi_images.csi_events.EventArray": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {"csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.sort": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_events.EventArray.to_events": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "k": {"docs": {"csi_images.csi_events.EventArray.from_mask": {"tf": 2.8284271247461903}, "csi_images.csi_images.extract_mask_info": {"tf": 1.7320508075688772}}, "df": 2}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}}, "df": 1}}, "j": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_images.extract_mask_info": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 3}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_scans.Scan.SCANNER_IDS": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "y": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.get_scan_position": {"tf": 1}, "csi_images.csi_events.Event.get_slide_position": {"tf": 1}, "csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}}, "df": 6}}}}}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_events.EventArray.to_events": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}}, "df": 2}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_scans.Scan.Channel": {"tf": 1}}, "df": 1}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_images.make_rgb": {"tf": 1}, "csi_images.csi_scans.Scan.Channel": {"tf": 1}}, "df": 6}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.Event.extract_images": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 2}, "csi_images.csi_frames": {"tf": 1}, "csi_images.csi_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile": {"tf": 1}}, "df": 4, "s": {"docs": {"csi_images": {"tf": 1}, "examples": {"tf": 1.4142135623730951}, "tests": {"tf": 1}}, "df": 3}}}}, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "y": {"docs": {"examples": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1}}, "df": 1, "s": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events": {"tf": 1}, "csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_events.EventArray": {"tf": 1}, "csi_images.csi_scans.Scan.ROI": {"tf": 1}, "examples": {"tf": 1}}, "df": 7}, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"csi_images.ocular_files.get_slide_statistics": {"tf": 1}, "csi_images.ocular_files.merge_statistics": {"tf": 1.7320508075688772}}, "df": 2}}}}}}}, "s": {"docs": {"csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"csi_images": {"tf": 2.449489742783178}, "csi_images.csi_events": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.sort": {"tf": 1}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 2.449489742783178}, "csi_images.csi_events.EventArray.to_events": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_csv": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_scans": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}, "csi_images.csi_tiles.Tile": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1}}, "df": 24, "/": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {"csi_images.csi_events.EventArray.save_ocular": {"tf": 1}}, "df": 1}}}}}}}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}}, "df": 2}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_images.extract_mask_info": {"tf": 1.4142135623730951}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.ocular_files.get_frame_statistics": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.ocular_files.get_frame_statistics": {"tf": 1}, "csi_images.ocular_files.merge_statistics": {"tf": 1}}, "df": 2}, "d": {"docs": {"csi_images.ocular_files.merge_statistics": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {"csi_images.csi_scans.Scan.Channel": {"tf": 1}}, "df": 1}}, "s": {"docs": {"csi_images": {"tf": 2}, "csi_images.csi_events.Event.get_scan_position": {"tf": 1}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.sort": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1.7320508075688772}, "csi_images.csi_frames.Frame.get_image": {"tf": 1.7320508075688772}, "csi_images.csi_frames.Frame.check_image": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_names": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "csi_images.csi_tiles.Tile": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1.7320508075688772}}, "df": 13, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"csi_images": {"tf": 2}}, "df": 1}}, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.EventArray.rows": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}}, "df": 2}, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_events.EventArray.get": {"tf": 1.4142135623730951}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_events.EventArray.from_dataframe": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"tests.compare_cv2_tifffile": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {"csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}, "examples": {"tf": 1}, "tests": {"tf": 1}}, "df": 3, "m": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_scans.Scan": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}, "tests": {"tf": 1}}, "df": 4}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.EventArray.get_sort_order": {"tf": 2}, "csi_images.csi_events.EventArray.sort": {"tf": 1.7320508075688772}}, "df": 2, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_events.EventArray.sort": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_events.Event": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_frames.Frame.get_image": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.ocular_files.get_slide_statistics": {"tf": 1}, "csi_images.ocular_files.merge_statistics": {"tf": 1.7320508075688772}}, "df": 2}}}}}}, "s": {"docs": {"csi_images.ocular_files.merge_statistics": {"tf": 1.4142135623730951}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"csi_images": {"tf": 3.1622776601683795}, "csi_images.csi_events": {"tf": 1}, "csi_images.csi_events.Event": {"tf": 1}, "csi_images.csi_events.Event.get_scan_position": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1.7320508075688772}, "csi_images.csi_frames.Frame.get_image": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.check_image": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1.7320508075688772}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_scans": {"tf": 2}, "csi_images.csi_scans.Scan": {"tf": 2}, "csi_images.csi_scans.Scan.Channel": {"tf": 1}, "csi_images.csi_scans.Scan.ROI": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_names": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.load_czi": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 2}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 2}, "csi_images.csi_tiles": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile": {"tf": 2}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1.7320508075688772}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 2}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1.7320508075688772}}, "df": 31, "s": {"docs": {"csi_images": {"tf": 2.23606797749979}, "csi_images.csi_events": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 2.449489742783178}, "csi_images.csi_scans.Scan": {"tf": 1}}, "df": 4}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_events": {"tf": 1}, "csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}, "csi_images.csi_events.Event.get_scan_position": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1}, "csi_images.csi_scans.Scan": {"tf": 1}, "csi_images.csi_scans.Scan.SCANNER_IDS": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}}, "df": 7, "s": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}}, "df": 2}}, "d": {"docs": {"csi_images.csi_scans.Scan": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"tests.compare_cv2_tifffile": {"tf": 1}}, "df": 1, "s": {"docs": {"tests.test_examples": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1.4142135623730951}, "csi_images.csi_events": {"tf": 1}, "csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}, "csi_images.csi_events.Event.get_slide_position": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1.4142135623730951}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}, "csi_images.ocular_files.merge_statistics": {"tf": 1.7320508075688772}}, "df": 10, "s": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.ocular_files.get_slide_statistics": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {"csi_images.csi_scans.Scan.load_txt": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}}, "df": 2}}}}}}, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "w": {"docs": {"csi_images.csi_events.Event.extract_images": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile": {"tf": 1}}, "df": 3}}}}}, "e": {"docs": {"csi_images.csi_events": {"tf": 1}, "csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1}, "examples": {"tf": 1}, "tests": {"tf": 1}}, "df": 5}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_events.EventArray": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {"csi_images.csi_events.EventArray.from_events": {"tf": 1}, "csi_images.csi_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}}, "df": 5}, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.SCANNER_IDS": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"examples": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}}, "df": 9}}, "v": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}}, "df": 5}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events": {"tf": 1}, "csi_images.csi_events.Event": {"tf": 1}, "csi_images.csi_events.EventArray.merge": {"tf": 1}, "csi_images.csi_events.EventArray.to_dataframe": {"tf": 1}, "csi_images.csi_events.EventArray.from_dataframe": {"tf": 1}, "csi_images.csi_frames": {"tf": 1}, "csi_images.csi_images.make_rgb": {"tf": 1}}, "df": 8}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_events.Event": {"tf": 1}}, "df": 1}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1.4142135623730951}}, "df": 1}}, "t": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_events": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}}, "df": 2}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}}, "df": 1}}}}}}, "z": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 2.23606797749979}, "csi_images.csi_events.Event.extract_images": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 2.23606797749979}, "csi_images.csi_images.extract_mask_info": {"tf": 1}}, "df": 4}}}, "y": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}}, "df": 1, "s": {"docs": {"csi_images.csi_events": {"tf": 1}}, "df": 1}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}}, "df": 3}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}}, "df": 1}}}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "examples": {"tf": 1}}, "df": 2}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"examples": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "f": {"docs": {"csi_images": {"tf": 3.1622776601683795}, "csi_images.csi_events": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.get_scan_position": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.get_slide_position": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.crop_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 2.449489742783178}, "csi_images.csi_events.EventArray": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.sort": {"tf": 1}, "csi_images.csi_events.EventArray.get": {"tf": 1}, "csi_images.csi_events.EventArray.rows": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.copy": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.merge": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_events.EventArray.from_events": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_frames": {"tf": 1.7320508075688772}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 2}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1.4142135623730951}, "csi_images.csi_images.extract_mask_info": {"tf": 1.7320508075688772}, "csi_images.csi_images.make_rgb": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan": {"tf": 1}, "csi_images.csi_scans.Scan.Channel": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_names": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1.7320508075688772}, "csi_images.csi_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 3}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 3}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 2.8284271247461903}, "examples": {"tf": 1}, "tests": {"tf": 1.7320508075688772}}, "df": 36}, "r": {"docs": {"csi_images": {"tf": 1.7320508075688772}, "csi_images.csi_events": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.sort": {"tf": 1}, "csi_images.csi_events.EventArray.rows": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1}, "csi_images.csi_scans": {"tf": 1}, "csi_images.csi_scans.Scan.Channel": {"tf": 1}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}, "examples": {"tf": 1}}, "df": 25, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"csi_images": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_frames.Frame.get_all_frames": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "/": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_images.extract_mask_info": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray.sort": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_names": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 9}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_events.EventArray.save_ocular": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_images.extract_mask_info": {"tf": 1}}, "df": 1}, "s": {"docs": {"csi_images.csi_scans.Scan.load_txt": {"tf": 1}}, "df": 1}}}}}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images": {"tf": 1}}, "df": 1, "s": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}}, "df": 2}}}}}, "n": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events": {"tf": 1}, "csi_images.csi_events.EventArray.rows": {"tf": 1}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_scans.Scan": {"tf": 1}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1}, "csi_images.csi_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}, "examples": {"tf": 1}}, "df": 14, "l": {"docs": {}, "df": 0, "y": {"docs": {"csi_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}}, "df": 3}}, "c": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events.EventArray": {"tf": 1}, "tests": {"tf": 1}}, "df": 3}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"csi_images": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}}, "df": 4, "l": {"docs": {}, "df": 0, "y": {"docs": {"csi_images.csi_events": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1}}, "df": 2}}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1.4142135623730951}, "csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}}, "df": 9}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1}}, "df": 4, "s": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {"csi_images.csi_scans.Scan.SCANNER_IDS": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images": {"tf": 1}}, "df": 1, "w": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}}, "df": 2}}}}}}}}}, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_scans": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.load_czi": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1.4142135623730951}, "csi_images.ocular_files.merge_statistics": {"tf": 1.4142135623730951}}, "df": 11, "s": {"docs": {"csi_images.csi_tiles.Tile.get_tiles": {"tf": 2}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 2}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 2}}, "df": 3}}}}}}, "w": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_scans.Scan": {"tf": 1}}, "df": 1}}}, "b": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.sort": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_scans": {"tf": 1.7320508075688772}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1.4142135623730951}, "examples": {"tf": 1.7320508075688772}, "tests": {"tf": 1}}, "df": 11, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}}}}, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}}, "df": 2}}}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}}, "df": 2}}}}, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_events.EventArray.to_events": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {"tests": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}, "w": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_scans.Scan.Channel": {"tf": 1}}, "df": 1}}}}}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1}}, "df": 1, "d": {"docs": {"csi_images.csi_events.EventArray.rows": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_scans.Scan": {"tf": 1}, "csi_images.csi_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 10}}, "i": {"docs": {}, "df": 0, "c": {"docs": {"csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "k": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_scans": {"tf": 1}}, "df": 2}}}, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_frames": {"tf": 1}, "csi_images.csi_scans.Scan.ROI": {"tf": 1}}, "df": 3}}, "y": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 2.23606797749979}, "csi_images.csi_events.EventArray.sort": {"tf": 2}, "csi_images.csi_events.EventArray.get": {"tf": 1}, "csi_images.csi_events.EventArray.rows": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}}, "df": 9}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_events.EventArray.rows": {"tf": 1}}, "df": 1, "/": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_events.EventArray.rows": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1.7320508075688772}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "k": {"docs": {"csi_images.csi_events.EventArray.to_events": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_frames.Frame.get_image": {"tf": 1.4142135623730951}}, "df": 1}}, "z": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}}, "df": 2}}}}}}}}}, "r": {"docs": {"tests": {"tf": 1}}, "df": 1, "d": {"docs": {}, "df": 0, "s": {"docs": {"csi_images": {"tf": 1.7320508075688772}}, "df": 1}}, "e": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}}, "df": 2, "a": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.get_others": {"tf": 1}}, "df": 3, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "tests.compare_cv2_tifffile": {"tf": 1}}, "df": 4}}}, "s": {"docs": {"csi_images.ocular_files.get_frame_info": {"tf": 1}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1}}, "df": 2}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"csi_images": {"tf": 2.449489742783178}}, "df": 1}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events.Event": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}}, "df": 3}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"tests": {"tf": 1}}, "df": 1}}}}}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1.4142135623730951}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1.4142135623730951}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1.4142135623730951}}, "df": 7}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events": {"tf": 1}, "csi_images.csi_events.Event": {"tf": 1}, "csi_images.csi_frames": {"tf": 1}, "csi_images.csi_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile": {"tf": 1}}, "df": 5}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_images.make_rgb": {"tf": 1}}, "df": 3}}}}}}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 4, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_images.extract_mask_info": {"tf": 1}}, "df": 1}}}}}}}}}, "f": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}}}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_frames.Frame.get_image": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 5, "s": {"docs": {"csi_images.csi_events.Event.get_scan_position": {"tf": 1}, "csi_images.csi_events.Event.get_slide_position": {"tf": 1}, "csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.sort": {"tf": 1}, "csi_images.csi_events.EventArray.get": {"tf": 1}, "csi_images.csi_events.EventArray.rows": {"tf": 1}, "csi_images.csi_events.EventArray.copy": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_events.EventArray.to_dataframe": {"tf": 1}, "csi_images.csi_events.EventArray.from_dataframe": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1}, "csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_csv": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1}, "csi_images.csi_images.make_rgb": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_names": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1}, "csi_images.csi_scans.Scan.load_czi": {"tf": 1}, "csi_images.csi_scans.Scan.load_txt": {"tf": 1}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}, "csi_images.ocular_files.get_cells": {"tf": 1}, "csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1}, "csi_images.ocular_files.get_frame_info": {"tf": 1}, "csi_images.ocular_files.get_frame_statistics": {"tf": 1}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}, "csi_images.ocular_files.merge_statistics": {"tf": 1}, "csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1}}, "df": 52}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}}, "df": 2}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.EventArray.save_ocular": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 3}}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"csi_images": {"tf": 1}, "tests": {"tf": 1.4142135623730951}}, "df": 2, "s": {"docs": {"tests.test_examples": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "w": {"docs": {"csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 2, "s": {"docs": {"csi_images.csi_events.EventArray.rows": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 2}}, "df": 2}, "]": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "]": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}, "i": {"docs": {"csi_images.csi_events.EventArray.from_mask": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_scans.Scan.ROI": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 9, "s": {"docs": {"csi_images.csi_scans.Scan": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1}}, "df": 2}}}, "g": {"docs": {}, "df": 0, "b": {"docs": {"csi_images.csi_frames": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1.4142135623730951}, "csi_images.csi_images.make_rgb": {"tf": 1.4142135623730951}}, "df": 3, "w": {"docs": {"csi_images.csi_frames": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.save_yaml": {"tf": 1}}, "df": 1}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events.EventArray": {"tf": 1}}, "df": 2}}}}, "y": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "v": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "a": {"docs": {"csi_images": {"tf": 2.449489742783178}}, "df": 1}, "e": {"docs": {}, "df": 0, "w": {"docs": {"csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "u": {"docs": {"csi_images.csi_images.extract_mask_info": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray.get": {"tf": 1}, "csi_images.csi_events.EventArray.rows": {"tf": 1}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"examples": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_scans.Scan.Channel": {"tf": 1}}, "df": 2, "t": {"docs": {}, "df": 0, "c": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1.4142135623730951}, "csi_images.csi_images.make_rgb": {"tf": 1}, "csi_images.csi_scans.Scan": {"tf": 1}}, "df": 4}}, "s": {"docs": {}, "df": 0, "y": {"docs": {"csi_images.csi_events.Event": {"tf": 1}, "csi_images.csi_events.EventArray": {"tf": 1}, "csi_images.csi_frames": {"tf": 1}}, "df": 3}, "e": {"docs": {"csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1}, "tests.test_examples": {"tf": 1}}, "df": 2}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}}, "df": 1}}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"csi_images": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1.4142135623730951}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_tiles.Tile": {"tf": 1}}, "df": 1}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"csi_images": {"tf": 2.8284271247461903}, "csi_images.csi_events": {"tf": 2.23606797749979}, "csi_images.csi_events.Event": {"tf": 1}, "csi_images.csi_events.Event.get_scan_position": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.get_slide_position": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.crop_images": {"tf": 2}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 2.23606797749979}, "csi_images.csi_events.EventArray": {"tf": 1}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}}, "df": 11, "s": {"docs": {"csi_images": {"tf": 2.23606797749979}, "csi_images.csi_events": {"tf": 1}, "csi_images.csi_events.Event": {"tf": 1}, "csi_images.csi_events.Event.crop_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1.7320508075688772}, "csi_images.csi_events.EventArray": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.rows": {"tf": 1}, "csi_images.csi_events.EventArray.merge": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.to_events": {"tf": 2}, "csi_images.csi_events.EventArray.from_events": {"tf": 2}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.save_csv": {"tf": 1}, "csi_images.csi_events.EventArray.load_csv": {"tf": 1}, "csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}, "csi_images.csi_events.EventArray.save_ocular": {"tf": 1}, "csi_images.csi_events.EventArray.load_ocular": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1.4142135623730951}, "csi_images.ocular_files.get_others": {"tf": 1}, "csi_images.ocular_files.save_cells": {"tf": 1}, "csi_images.ocular_files.save_others": {"tf": 1.4142135623730951}, "csi_images.ocular_files.merge_statistics": {"tf": 1}, "csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1}}, "df": 24}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {"csi_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.sort": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.get": {"tf": 1}, "csi_images.csi_events.EventArray.rows": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.copy": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}, "csi_images.csi_events.EventArray.merge": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_events.EventArray.from_events": {"tf": 1}, "csi_images.csi_events.EventArray.to_dataframe": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_dataframe": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1.4142135623730951}, "csi_images.ocular_files.merge_statistics": {"tf": 1.7320508075688772}}, "df": 15, "s": {"docs": {"csi_images.csi_events.EventArray.merge": {"tf": 1}}, "df": 1}}}}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.Event": {"tf": 1}}, "df": 1}}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}}, "df": 1}}}, "x": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_events.Event": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_scans.Scan.Channel": {"tf": 1.4142135623730951}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_scans": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.from_mask": {"tf": 2}, "csi_images.csi_images.extract_mask_info": {"tf": 1.7320508075688772}}, "df": 5, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}}, "df": 2}}}, "s": {"docs": {"csi_images.csi_images.extract_mask_info": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_frames.Frame.get_file_path": {"tf": 1.7320508075688772}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_frames.Frame.check_all_images": {"tf": 1}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}}, "df": 2}}}, "s": {"docs": {"csi_images.csi_frames.Frame.check_image": {"tf": 1.4142135623730951}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"examples": {"tf": 2}, "tests.test_examples": {"tf": 1}}, "df": 2}}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"tests.test_examples": {"tf": 1}}, "df": 1}}}}}}, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}}, "df": 1}}}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_frames.Frame.check_all_images": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"csi_images.csi_images.extract_mask_info": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_scans.Scan.save_yaml": {"tf": 1}, "tests.test_examples": {"tf": 1}}, "df": 2}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"csi_images": {"tf": 2.23606797749979}, "csi_images.csi_scans.Scan.Channel": {"tf": 1}, "csi_images.csi_scans.Scan.ROI": {"tf": 1.4142135623730951}}, "df": 3}}, "s": {"docs": {"csi_images": {"tf": 1}, "tests": {"tf": 1}}, "df": 2}, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_frames.Frame.get_file_name": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_frames.Frame.get_image": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_frames": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"csi_images.csi_events": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray": {"tf": 1}, "csi_images.csi_scans": {"tf": 1}}, "df": 3}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}}, "df": 1}}}}}}}}}, "w": {"docs": {"examples": {"tf": 1}, "tests": {"tf": 1}}, "df": 2}}, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"csi_images": {"tf": 1}}, "df": 1, "#": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_images.extract_mask_info": {"tf": 1}}, "df": 1}}}}}}}}}}, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"csi_images.csi_images.extract_mask_info": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "f": {"5": {"docs": {"csi_images.csi_events.EventArray.save_hdf5": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.load_hdf5": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {"csi_images.csi_events.EventArray.save_hdf5": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile": {"tf": 1}}, "df": 2}}, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {"tests": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {"csi_images.ocular_files.get_frame_info": {"tf": 1}}, "df": 1}}}}, "x": {"docs": {"csi_images": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_images.extract_mask_info": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 2}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1.7320508075688772}}, "df": 8}, "y": {"docs": {"csi_images": {"tf": 1.7320508075688772}, "csi_images.csi_images.extract_mask_info": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 2}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1.7320508075688772}}, "df": 7, "o": {"docs": {}, "df": 0, "u": {"docs": {"csi_images": {"tf": 2.23606797749979}, "csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "tests": {"tf": 1}}, "df": 5, "r": {"docs": {"csi_images": {"tf": 2}}, "df": 1, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "v": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}}, "]": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "]": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_scans": {"tf": 1}, "csi_images.csi_scans.Scan.save_yaml": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.load_yaml": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.load_from_folder": {"tf": 1.4142135623730951}}, "df": 4}}}}, "g": {"docs": {"csi_images.csi_scans.Scan.Channel": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_tiles.Tile.get_tiles": {"tf": 1.7320508075688772}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 3, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images": {"tf": 1}, "csi_images.csi_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile": {"tf": 1}}, "df": 3}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_scans.Scan.Channel": {"tf": 1}}, "df": 1, "s": {"docs": {"csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"csi_images": {"tf": 2}, "csi_images.csi_events.Event.get_scan_position": {"tf": 1}, "csi_images.csi_events.Event.get_slide_position": {"tf": 1}, "csi_images.csi_events.Event.crop_images": {"tf": 1.7320508075688772}, "csi_images.csi_events.Event.extract_images": {"tf": 1}, "csi_images.csi_events.Event.extract_images_for_list": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.get": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.rows": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_names": {"tf": 1}}, "df": 15, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.ocular_files.get_slide_statistics": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {"csi_images": {"tf": 1.4142135623730951}}, "df": 1, "@": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {"csi_images": {"tf": 1}}, "df": 1}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}}, "df": 1}}}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {"csi_images.csi_tiles.Tile": {"tf": 1}}, "df": 1}}}}}, "k": {"docs": {"csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "y": {"docs": {"csi_images": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "p": {"docs": {"csi_images.ocular_files.filter_and_generate_statistics": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {"csi_images.csi_events.EventArray.from_mask": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1.7320508075688772}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 2.23606797749979}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1.4142135623730951}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1}}, "df": 8, "o": {"docs": {"csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "examples": {"tf": 1}}, "df": 2, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {"csi_images.csi_events.Event.SCAN_TO_SLIDE_TRANSFORM": {"tf": 1}, "csi_images.csi_events.Event.crop_images": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.to_events": {"tf": 1.4142135623730951}, "csi_images.csi_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_xy_bounds": {"tf": 1.4142135623730951}}, "df": 9, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_scans.Scan.save_yaml": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.Event.extract_images_for_list": {"tf": 1}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}, "csi_images.csi_events.EventArray.to_events": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_path": {"tf": 1}, "csi_images.csi_frames.Frame.get_image": {"tf": 1}, "csi_images.csi_frames.Frame.check_image": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 1}, "csi_images.csi_tiles.Tile.position_to_n": {"tf": 1}, "csi_images.csi_tiles.Tile.n_to_position": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles": {"tf": 1}, "csi_images.csi_tiles.Tile.get_tiles_by_row_col": {"tf": 1.7320508075688772}}, "df": 12}}}, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}}, "df": 3}}, "w": {"docs": {"csi_images.csi_events.EventArray.sort": {"tf": 1}, "csi_images.csi_events.EventArray.rows": {"tf": 1}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.add_features": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.merge": {"tf": 1}, "csi_images.csi_events.EventArray.from_events": {"tf": 1.4142135623730951}, "csi_images.ocular_files.merge_statistics": {"tf": 1}}, "df": 7}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"csi_images.csi_events.EventArray": {"tf": 1}, "csi_images.csi_events.EventArray.from_mask": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.SCANNER_IDS": {"tf": 1}, "csi_images.csi_scans.Scan.make_placeholder": {"tf": 1.7320508075688772}}, "df": 4}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_events.EventArray.from_mask": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "y": {"docs": {"csi_images.csi_frames.Frame.make_rgb_image": {"tf": 1}, "csi_images.csi_images.make_rgb": {"tf": 1}}, "df": 2}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"csi_images.csi_events.EventArray.get_sort_order": {"tf": 1}, "csi_images.csi_events.EventArray.sort": {"tf": 1}, "csi_images.csi_frames.Frame.get_file_name": {"tf": 1.7320508075688772}, "csi_images.csi_scans.Scan.Channel": {"tf": 1.4142135623730951}}, "df": 4, "s": {"docs": {"csi_images.csi_events.EventArray.get": {"tf": 1.4142135623730951}, "csi_images.csi_events.EventArray.add_metadata": {"tf": 1}, "csi_images.csi_events.EventArray.add_features": {"tf": 1}, "csi_images.csi_frames.Frame.get_frames": {"tf": 1}, "csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}, "csi_images.csi_scans.Scan.get_channel_names": {"tf": 1.4142135623730951}, "csi_images.csi_scans.Scan.get_channel_indices": {"tf": 2.23606797749979}}, "df": 7}}}}, "]": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"csi_images.csi_frames.Frame.get_all_frames": {"tf": 1}}, "df": 1}}}}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"csi_images.csi_events.Event.crop_images": {"tf": 1}}, "df": 1}}}}}, "j": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_frames.Frame.get_image": {"tf": 1.4142135623730951}, "csi_images.csi_frames.Frame.check_all_images": {"tf": 1}}, "df": 2}, "e": {"docs": {}, "df": 0, "g": {"docs": {"csi_images.csi_frames.Frame.get_image": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "pipeline": ["trimmer"], "_isPrebuiltIndex": true};

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();