import setuptools

VERSION="0.0.10"

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setuptools.setup(
    name="topicmodels",
    version=VERSION,
    author="Amit Kumar Kushwaha",
    author_email="kushwaha.amitkumar@gmail.com",
    description="A package for topic modelling in python.",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/AmitKumarKushwaha/topicmodeling",
    project_urls={
        "Bug Tracker": "https://github.com/AmitKumarKushwaha/topicmodeling/issues",
    },
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    package_dir={"": "src"},
    package_data={'': ['*.json']},
    packages=setuptools.find_packages(where="src"),
    python_requires=">=3.6",
    install_requires=[
        "absl-py",
        "aiohttp",
        "astor",
        "astunparse",
        "async-timeout",
        "attrs",
        "blinker",
        "brotlipy",
        "cachetools",
        "certifi",
        "cffi",
        "chardet",
        "click",
        "collection",
        "colorama",
        "coverage",
        "cryptography",
        "cython",
        "dataclasses",
        "fasttext",
        "filelock",
        "gast",
        "google-auth",
        "google-auth-oauthlib",
        "google-pasta",
        "grpcio",
        "h5py",
        "huggingface-hub",
        "icc_rt",
        "idna",
        "idna_ssl",
        "importlib-metadata",
        "intel-openmp",
        "joblib",
        "keras==2.4.3",
        "keras-applications",
        "keras-preprocessing",
        "protobuf",
        "markdown",
        "multidict",
        "nltk",
        "numpy",
        "oauthlib",
        "opt_einsum",
        "packaging",
        "pandas",
        "protobuf",
        "pyasn1",
        "pyasn1-modules",
        "pybind11",
        "pycparser",
        "pyjwt",
        "pyopenssl",
        "pyparsing",
        "pyreadline",
        "pysocks",
        "pytz",
        "pyyaml",
        "regex",
        "requests",
        "requests-oauthlib",
        "rsa",
        "sacremoses",
        "scikit-learn",
        "scipy",
        "setuptools",
        "six",
        "sklearn",
        "tensorboard",
        "tensorboard-plugin-wit",
        "tensorflow==2.2.0",
        "tensorflow-estimator",
        "termcolor",
        "threadpoolctl",
        "tokenizers",
        "torch",
        "tqdm",
        "transformers",
        "typing-extensions",
        "typing_extensions",
        "urllib3",
        "vc",
        "werkzeug",
        "wheel",
        "win_inet_pton",
        "wincertstore",
        "wrapt",
        "yarl",
        "zipp"
    ]
)
