# mypy-boto3-appsync

Type annotations for
[boto3.AppSync 1.10.50](https://boto3.amazonaws.com/v1/documentation/api/1.10.50/reference/services/appsync.html#AppSync) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

More information can be found [here](https://vemel.github.io/mypy_boto3/).

- [mypy-boto3-appsync](#mypy-boto3-appsync)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
    - [Code auto-complete](#code-auto-complete)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `AppSync` service.

```bash
python -m pip install boto3-stubs[mypy-boto3-appsync]
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import appsync
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_appsync as appsync

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("appsync")
client: appsync.AppSyncClient = boto3.client("appsync")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: appsync.AppSyncClient = session.client("appsync")


# Paginators need type annotation on creation
list_api_keys_paginator: appsync.ListApiKeysPaginator = client.get_paginator("list_api_keys")
list_data_sources_paginator: appsync.ListDataSourcesPaginator = client.get_paginator("list_data_sources")
list_functions_paginator: appsync.ListFunctionsPaginator = client.get_paginator("list_functions")
list_graphql_apis_paginator: appsync.ListGraphqlApisPaginator = client.get_paginator("list_graphql_apis")
list_resolvers_paginator: appsync.ListResolversPaginator = client.get_paginator("list_resolvers")
list_resolvers_by_function_paginator: appsync.ListResolversByFunctionPaginator = client.get_paginator("list_resolvers_by_function")
list_types_paginator: appsync.ListTypesPaginator = client.get_paginator("list_types")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.