# Generated by Django 3.1.5 on 2021-03-10 19:04

import django.contrib.postgres.search
from django.db import migrations


def populate_search_vector_field(apps, schema_editor):
    """
    Data migration used to lowercase any purl field values that currently exist.
    """
    Package = apps.get_model('packagedb', 'Package')

    for pkg in Package.objects.iterator():
        pkg.search_vector = search.SearchVector('namespace', 'name', 'version', 'download_url')
        pkg.save()


class Migration(migrations.Migration):

    dependencies = [
        ('packagedb', '0046_add_extra_data_to_package'),
    ]

    operations = [
        migrations.AddField(
            model_name='package',
            name='search_vector',
            field=django.contrib.postgres.search.SearchVectorField(null=True),
        ),
        migrations.RunPython(populate_search_vector_field),
    ]
